       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04620.                                     
COB303 DATE-WRITTEN.  MAY 18,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETUNS BBP BPA DATA.                             *        
      *  RESULT SETS:                                                  *        
      *         1. ACCOUNT ELIGIBILTY FOR BBP                          *        
      *         2. IF ELIGIBLE, AVAILABLE OPTIONS                      *        
      *         3. OTHER MONTHLY PAYMENTS                              *        
      *         3. USAGE DETAILS                                       *        
      *         5. PLEASE PAY AMT DETAILS                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00220*  05/18/10  VP94820    PROCEDURE ORIGINALLY CODED.              *        
A02891*  11/09/10  GD97441    1.CHANGE DESCRIPTION OF OPTIONS.         *        
A02891*                       2.ADDED ON SIZE ERRROR CHECK TO COMPUTE  *        
A02891*                         STATEMENTS HAVING DENOMINATOR.         *        
A02891*                       3.ADD "WITH UR" AS NEEDED.               *        
A02878*  01/04/11  GD97441    1.FIX WINTER/SUMMER MONTHS COUNT ISSUE TO*        
A02878*                         CORRECTLY ESTIMATE BBP AMOUNT.         *        
A02878*                       2.IF CUSTOMER HAS ENOUGH SUMMER/WINTER   *        
A02878*                         USAGE, DON'T USE PREMISE USAGE.        *        
A02878*                       3.ADDITIONAL COLUMNS TO 7050- PARA.      *        
A02878*                       4.ADDED BILL CYCLE CHECK IN 7100- PARA.  *        
A02878*                       5.DELETED UNUSED CODE.                   *        
P00464*  01/28/11  VP94820    ADDED NEW INPUT PARMS TO CSR02322 CALL   *        
ACT004*  03/16/11  GD97441    APPL3118-ACT004:RETURN CHECK LOGIC CHANGE*        
P00471*  08/03/11  AA97148    REPLACE SQL IN 7900- PARA TO CHECK FOR   *        
P00471*                       DPP DROP FROM CSS_ACCT_ATTRIBUTE.        *        
A03710** 11/01/11  VV94890    FIX FOR BLL-CYCLE SPACES ON PENDING ACCTS*        
P00694** 09/06/12  VIJAY      REMOVE BUFFER ADDING AS IT IS ALREADY    *        
P00694**                      INCLUDED IN CSR02322.                    *        
P0694A** 01/29/13  VV94890  1)ADDED GAS AND ELECTRIC BUFFERS TO RS-4.  *        
P0694A** ***P00694*****     2)ADDED PRIVATE LIGHT, SUBDIVISION LIGHT & *        
P0694A**                      NON-ELIG-AMT TO RESULT SET-2.            *        
P0694B**                    3)NOT YET BILLED =>SHOW NEXT BILL OPT ONLY.*        
P0694C**                    4)CHANGED LOGIC FOR BBP900 MESSAGE.        *        
P0694D**                    5)MODIFIED VERBIAGE FOR ALL 4 BBP OPTIONS. *        
P0694E**                    6)CHANGED BACK TO OLD VERBIAGE FOR ALL 4 OP*        
ACT211** 06/24/14  VIJAY    DO NOT INCLUDE ONE TIME DEPOSIT IN BBP     *        
ACT211**                    MONTHLY AMOUNT.                            *        
P00721** 06/01/15  MC95456  CHANGES MADE FOR PROFILE SCREEN TO RETURN  *        
P00721**                    BBP ELIGIBLE FLAG ALONE.                   *        
P00836** 01/06/16  VK7L032  CHANGES MADE FOR WEB TO RETURN S-ELIGIBLE  *        
P00836**                    AS 'N' FOR ARREARS AND  BBP100.                     
P00836** 07/12/16  MS7M727  MOVED PARM-ELIGIBLE VALUE TO               *        
P00836**                    CALLING-PROGRAM  VALUE FOR VALIDATING *             
P00836**                    BBP028                                     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04620'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04620 STARTS HERE'.                 
      *                                                                         
       01 WS-CONSTANTS.                                                 
      *                                                                         
          05 WS-PPL-NSC              PIC S9(4) COMP VALUE +019.         
          05 WS-PPL-LPC              PIC S9(4) COMP VALUE +030.         
          05 WS-PPL-UTE              PIC S9(4) COMP VALUE +040.         
          05 WS-PPL-UTG              PIC S9(4) COMP VALUE +045.         
          05 WS-PPL-RCC              PIC S9(4) COMP VALUE +060.         
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04620'.        
P0694E*                                                                         
A02891    05 WS-BBP-OPTN-CUR-BIL-TX1.                                   
A02891       10 FILLER               PIC X(34) VALUE                    
A02891                      'Pay BBP amount and arrears, begin '.       
A02891       10 FILLER               PIC X(26) VALUE                    
A02891                              'BBP Current Bill          '.       
A02891*                                                                         
A02891    05 WS-BBP-OPTN-CUR-BIL-TX2.                                   
A02891       10 FILLER               PIC X(34) VALUE                    
A02891                      'Pay BBP Amount, begin BBP Current '.       
A02891       10 FILLER               PIC X(26) VALUE                    
A02891                              'Bill                      '.       
A02891*                                                                         
A02891    05 WS-BBP-OPTN-NXT-BIL-TX1.                                   
A02891       10 FILLER               PIC X(33) VALUE                    
A02891                       'Pay current charges and arrears, '.       
A02891       10 FILLER               PIC X(27) VALUE                    
A02891                             'begin BBP Next Bill        '.       
A02891*                                                                         
A02891    05 WS-BBP-OPTN-NXT-BIL-TX2.                                   
A02891       10 FILLER               PIC X(31) VALUE                    
A02891                         'Pay current charges, begin BBP '.       
A02891       10 FILLER               PIC X(29) VALUE                    
A02891                           'Next Bill                    '.       
A02891*                                                                         
A02891    05 WS-BBP-OPTN-ROL-CUR-BIL.                                   
A02891       10 FILLER               PIC X(34) VALUE                    
A02891                      'Pay BBP amount, rollover arrears, '.       
A02891       10 FILLER               PIC X(26) VALUE                    
A02891                              'begin BBP Current Bill    '.       
A02891*                                                                         
A02891    05 WS-BBP-OPTN-ROL-NXT-BIL.                                   
A02891       10 FILLER               PIC X(30) VALUE                    
A02891                          'Pay arrears, rollover current '.       
A02891       10 FILLER               PIC X(30) VALUE                    
A02891                          'charges, begin BBP Next Bill  '.       
P0694E*                                                                         
       01 WS-MISC.                                                      
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC 9(13).                         
          05 WS-PREMISE-NO           PIC X(10) VALUE SPACES.            
          05 WS-PREMISE-NUM REDEFINES WS-PREMISE-NO                     
                                     PIC 9(10).                         
          05 WS-REV-MTH.                                                
             10 WS-REV-MTH-CCYY      PIC X(04).                         
             10 WS-REV-MTH-MM        PIC X(02).                         
          05 WS-REV-MTH-NUM REDEFINES WS-REV-MTH                        
                                     PIC 9(06).                         
          05 WS-PYMT-STRT-DT.                                           
             10 WS-PYMT-STRT-CCYY    PIC X(04).                         
             10 FILLER               PIC X(01)  VALUE '-'.              
             10 WS-PYMT-STRT-MM      PIC X(02).                         
             10 FILLER               PIC X(01)  VALUE '-'.              
             10 WS-PYMT-STRT-DD      PIC X(02)  VALUE '01'.             
          05 WS-ELEC-TOTAL           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-GAS-TOTAL            PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-PVTL-TOTAL           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-SUBL-TOTAL           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-NONBBP-ELIG-AMT      PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-TOT-MTHS-USAGE-GAS   PIC S9(4)    COMP VALUE 0.         
          05 WS-TOT-MTHS-USAGE-ELEC  PIC S9(4)    COMP VALUE 0.         
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-5-DAY-AGO-DT         PIC X(10) VALUE SPACES.            
          05 WS-UTILITY-BAL-ED       PIC -Z(8)9.9(02).                  
          05 WS-UTILITY-ARR-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-MO-PYMT-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-BBP-EST-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-TO-COLL-ED       PIC -Z(8)9.9(02).                  
          05 WS-ROLOVR-AMT-ED        PIC -Z(8)9.9(02).                  
          05 WS-ROLOVR-AMT           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-AMT-MO-PYMT-RND      PIC S9(11) COMP-3 VALUE +0.        
          05 WS-AMT-MO-PYMT-HOLD     PIC S9(11) COMP-3 VALUE +0.        
          05 WS-RECV-AMT-HOLD        PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-MAX-RECV-AMT         PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-REVENUE-MONTH        PIC X(10) VALUE SPACES.            
      *                                                                         
          05 WS-NONBPP-ELIG-ARRAY.                                      
             10 WS-NONBBP-ELIG-DET   OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-1.               
                15 WS-RECV-TYPE      PIC X(25).                         
COB305          15 WS-RECV-AMT        PIC S9(9)V99 COMP-3 VALUE 0.              
      *                                                                         
          05 WS-UTIL-ARRS-ARRAY.                                        
             10 WS-UTIL-ARRS-DET     OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-A.               
                15 WS-ARRS-TYPE      PIC X(25).                         
COB305          15 WS-ARRS-AMT        PIC S9(9)V99 COMP-3 VALUE 0.              
      *                                                                         
          05 WS-UTIL-BAL-ARRAY.                                         
             10 WS-UTIL-BAL-DET      OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-B.               
                15 WS-BAL-TYPE       PIC X(25).                         
COB305          15 WS-BAL-AMT        PIC S9(9)V99 COMP-3 VALUE 0.               
      *                                                                         
          05 WS-REMARKS-TEXT.                                           
             10 WS-REMARKS           OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-R.               
                15 WS-REMARKS-CHAR   PIC X(01).                         
      *                                                                         
          05 WS-RESULT-TEXT.                                            
             10 WS-RESULT            OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-2.               
                15 WS-RESULT-CHAR    PIC X(01).                         
      *                                                                         
          05 WS-PREV-CHAR            PIC X(01) VALUE SPACE.             
          05 WS-BBP-DPP-CUTOFF-DT    PIC X(10) VALUE SPACES.            
          05 WS-DPP-CUTOFF-DT        PIC X(10) VALUE SPACES.            
          05 WS-BBP-LIMIT            PIC S9(04) COMP VALUE 0.           
          05 WS-BBP-DROP-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-DPP-DROP-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-UTL-ARRS-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-DAYS-UTIL-ARRS       PIC S9(4)V9(5) COMP-3 VALUE 0.     
          05 WS-ROL-OVR-ELIG         PIC X(01) VALUE 'N'.               
          05 WS-ROL-OVR-ENABLD       PIC X(01) VALUE 'N'.               
      *                                                                         
          05 WS-02322-CALL-AREA.                                        
             10 WS-02322-PREMISE     PIC X(10) VALUE SPACES.            
             10 WS-02322-DATE        PIC X(10) VALUE SPACES.            
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-RULES            PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-OPTIONS          PIC S9(9) COMP VALUE 0.            
          05 WS-MTHLY-CHRGS          PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-USAGE            PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-PLS-PAY          PIC S9(9) COMP VALUE 0.            
P00721    05 WS-BBP-ELIG             PIC S9(9) COMP VALUE 0.            
A02878    05 WS-WNTR-SUMR-MTHS-ELEC  PIC 9(04) VALUE 0.                 
A02878    05 WS-WNTR-SUMR-MTHS-GAS   PIC 9(04) VALUE 0.                 
A02878    05 WS-ACCT-WNT-SUM-USE-ELEC  PIC 9(04) VALUE 0.               
A02878    05 WS-ACCT-WNT-SUM-USE-GAS PIC 9(04) VALUE 0.                 
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 WS-EOF-CURSOR           PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-BBP-ELIGIBLE         PIC 9(01) VALUE ZERO.              
             88 BBP-ELIGIBLE                   VALUE 1.                 
             88 BBP-NOT-ELIGIBLE               VALUE 2.                 
          05 WS-RESULT-TYPE          PIC 9(01) VALUE ZERO.              
             88 WS-RULES                       VALUE 1.                 
             88 WS-OPTIONS                     VALUE 2.                 
             88 WS-OTHR-PYMTS                  VALUE 3.                 
             88 WS-USAGE                       VALUE 4.                 
             88 WS-PLS-PAY-AMT                 VALUE 5.                 
      *                                                                         
          05 WS-RETURN-CODE-1        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-2        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-3        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-4        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-5        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-6        PIC S9(4)    COMP VALUE 0.         
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE           PIC S9(4)    COMP VALUE 0.         
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(4)    COMP VALUE 0.         
             10 S-BUS-RULE-TYPE      PIC X(06)    VALUE SPACES.         
             10 S-BUS-RULE-RESULT    PIC X(01)    VALUE SPACES.         
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(9)    COMP VALUE 0.         
             10 S-OPTION-SEQ-NO      PIC X(01)    VALUE SPACES.         
A02891       10 S-OPTION-DESC        PIC X(60)    VALUE SPACES.         
             10 S-UTILITY-BALANCE    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-UTILITY-ARREARS    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-MO-PYMT        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-ELEC-MO-PYMT   PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-GAS-MO-PYMT    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-UNMTRD-MO-PYMT PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-OTHER-PYMTS    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-ROLLOVR        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-OPTN-PLS-PAY-AMT   PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-START-DATE         PIC X(10)    VALUE SPACES.         
             10 S-MTHS-ACCT-USAGE    PIC S9(9)    COMP VALUE 0.         
             10 S-MTHS-PREM-USAGE    PIC S9(9)    COMP VALUE 0.         
             10 S-BBP-BILL-FLAG      PIC X(01)    VALUE SPACES.         
             10 S-BBP-EST-AMT        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-LAST-UPDATE-TS     PIC X(26)    VALUE SPACES.         
             10 S-REMARKS-TEXT       PIC X(210)   VALUE SPACES.         
             10 S-REMARKS-LENGTH     PIC S9(4)    COMP VALUE 0.         
P0694A       10 S-PVTL-TOTAL         PIC S9(9)V99 COMP-3 VALUE +0.      
P0694A       10 S-SUBL-TOTAL         PIC S9(9)V99 COMP-3 VALUE +0.      
P0694A       10 S-NONBBP-ELIG-AMT    PIC S9(9)V99 COMP-3 VALUE +0.      
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3      PIC S9(4)    COMP VALUE 0.         
             10 S-CNT-NAME-DESC      PIC X(30)    VALUE SPACES.         
             10 S-CNT-AMT-MO-PYMT    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-CNT-PYMTS-REMAIN   PIC S9(9)    COMP VALUE 0.         
             10 S-CNT-EXPIRY-DT      PIC X(10)    VALUE SPACES.         
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4      PIC S9(4)    COMP VALUE 0.         
             10 S-REVENUE-MONTH      PIC X(10)    VALUE SPACES.         
             10 S-DAYS               PIC S9(4)    COMP VALUE 0.         
             10 S-UNITS              PIC S9(9)    COMP-3 VALUE 0.       
             10 S-CODE-UTIL-TYPE     PIC X(1)     VALUE SPACES.         
             10 S-CUSTOMER-NO        PIC S9(10)   COMP-3 VALUE 0.       
             10 S-NEW-CHARGE         PIC S9(9)V9(2)                     
                                                  COMP-3 VALUE 0.       
             10 S-RATE-PLAN-NO       PIC X(3)     VALUE SPACES.         
             10 S-CALC-ERROR         PIC X(08)    VALUE SPACES.         
             10 S-HTG-CLG-SW         PIC S9(03)   COMP-3 VALUE ZEROES.  
             10 S-BPP-CATEGORY       PIC X(1)     VALUE SPACES.         
P0694A       10 S-ELEC-BUFFER        PIC S9(4)V9(5)                     
P0694A                                            COMP-3 VALUE 0.       
P0694A       10 S-GAS-BUFFER         PIC S9(4)V9(5)                     
P0694A                                            COMP-3 VALUE 0.       
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5      PIC S9(4)    COMP VALUE 0.         
             10 S-OPTN-SEQ-NO-5      PIC X(01)    VALUE SPACES.         
             10 S-AR-TYPE-DESC       PIC X(25)    VALUE SPACES.         
             10 S-PLS-PAY-DET-AMT    PIC S9(9)V99 COMP-3 VALUE +0.      
                                                                        
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6      PIC S9(4)    COMP VALUE 0.         
             10 S-BBP-ELIGIBLE       PIC X(01)    VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *    COPYBOOK FOR CWS00309                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    COPYBOOK FOR CPD04353                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS04353                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_AR_CNTL  - AC                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_TYPE  - L5                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
P00471******************************************************************07690000
P00471*    CSS_ACCT_ATTRIBUTE - YP                                     *07700000
P00471******************************************************************07710000
P00471*                                                                 07720000
P00471     EXEC SQL                                                     07730000
P00471        INCLUDE TBACTATT                                          07740000
P00471     END-EXEC.                                                    07750000
P00471*                                                                 07760000
      ******************************************************************        
      *    CSS_BILL_WINDOW - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CONTRACT - CT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DEP_REQ - DR                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPREQ                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DFA_DESC - DS                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFADES                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CONTRACT_INFO - K6                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACTT_RTPK_AGR - D4                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION - FI                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PROJ_SHARE - PJ                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBPRJSHR                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTL_ENVRMNT - UT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORKING STORGAE FOR CPD04353                                *        
      ******************************************************************        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * CSS_RATE_COMP_DEF - J1                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_RATE_TOU_DEF - RJ                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTTOUD                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_NSF_HIST - NH                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNSFHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_RATE_CREATOR - RT                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      * CSS_RATE_PLAN_DESC - RD                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CREDIT_PROFILE- CZ                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BILLING_HDR - BI                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_BUDGET_HIST - BH                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD04353                         *        
      ******************************************************************        
      *                                                                         
          COPY CWS00056.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE AR_CURSOR CURSOR FOR                             
                       SELECT                                           
                              AC.AMT_AR_DAY_00                          
                             ,AC.AMT_AR_DAY_30                          
                             ,AC.AMT_AR_DAY_60                          
                             ,AC.AMT_AR_DAY_90                          
                             ,AC.AMT_UNUSED_CR                          
                             ,AC.AMT_TRAN_BALANCE                       
                             ,AC.TOT_SUMM_UNBILLED                      
                             ,AC.PYMT_PRIORITY_LVL                      
                             ,L5.AR_TYPE_LONG_DESC                      
                             ,AC.ITEM_ID                                
                         FROM                                           
                              CSS_AR_CNTL  AC WITH(READUNCOMMITTED)             
                             ,CSS_AR_TYPE  L5 WITH(READUNCOMMITTED)             
                        WHERE                                           
                              AC.ACCOUNT_NO = :AC-ACCOUNT-NO            
                          AND AC.PYMT_PRIORITY_LVL                      
                                            = L5.PYMT_PRIORITY_LVL      
                     ORDER BY                                           
                              PYMT_PRIORITY_LVL ASC                     
                             ,ITEM_ID DESC                              
               FOR READ ONLY                                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AR_CURSOR CURSOR FOR                                     
MFA-TR*                SELECT                                                   
MFA-TR*                       AC.AMT_AR_DAY_00                                  
MFA-TR*                      ,AC.AMT_AR_DAY_30                                  
MFA-TR*                      ,AC.AMT_AR_DAY_60                                  
MFA-TR*                      ,AC.AMT_AR_DAY_90                                  
MFA-TR*                      ,AC.AMT_UNUSED_CR                                  
MFA-TR*                      ,AC.AMT_TRAN_BALANCE                               
MFA-TR*                      ,AC.TOT_SUMM_UNBILLED                              
MFA-TR*                      ,AC.PYMT_PRIORITY_LVL                              
MFA-TR*                      ,L5.AR_TYPE_LONG_DESC                              
MFA-TR*                      ,AC.ITEM_ID                                        
MFA-TR*                  FROM                                                   
MFA-TR*                       CSS_AR_CNTL  AC                                   
MFA-TR*                      ,CSS_AR_TYPE  L5                                   
MFA-TR*                 WHERE                                                   
MFA-TR*                       AC.ACCOUNT_NO = :AC-ACCOUNT-NO                    
MFA-TR*                   AND AC.PYMT_PRIORITY_LVL                              
MFA-TR*                                     = L5.PYMT_PRIORITY_LVL              
MFA-TR*              ORDER BY                                                   
MFA-TR*                       PYMT_PRIORITY_LVL ASC                             
MFA-TR*                      ,ITEM_ID DESC                                      
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*               WITH UR                                                   
MFA-TR*               QUERYNO 7500                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04620 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE USAGE_CUR CURSOR
MSQ001          FOR CALL CSR02322( ' '
                  , :WS-02322-PREMISE
                  , :WS-02322-DATE
                  , ' '
                  )
MSQ001        END-EXEC.
            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC  X(13).                    
P00721 01  PARM-ELIGIBLE                 PIC  X(01).                    
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
P00721                         ,PARM-ELIGIBLE.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE       THRU 0100-EXIT.                
           PERFORM 1000-PROCESS-INPUT    THRU 1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT.                
           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT.                
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
P00836     MOVE  PARM-ELIGIBLE           TO CALLING-PROGRAM.            
           PERFORM 7000-GET-CUR-DATE     THRU 7000-EXIT.                
      *                                                                         
P00721     IF PARM-ELIGIBLE = SPACES                                    
P00721        PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT             
P00721     ELSE                                                         
P00721        PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT             
P00721     END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04620_R1                                  
               ORDER BY BUS_RULE_TYPE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R1                                          
MFA-TR*        ORDER BY BUS_RULE_TYPE                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04620_R2                                  
               ORDER BY OPTN_PLS_PAY_AMT DESC                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R2                                          
MFA-TR*        ORDER BY OPTN_PLS_PAY_AMT DESC                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04620_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R3                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04620_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R4                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04620_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R5                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00721     EXEC SQL                                                     
P00721         DECLARE C6 CURSOR                             
P00721                           WITH ROWSET POSITIONING FOR            
P00721         SELECT                                                   
P00721            *                                                     
P00721         FROM                                                     
P00721             #CSR04620_R6                                  
P00721     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04620_R6                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           INITIALIZE WS-NONBPP-ELIG-ARRAY                              
                      WS-UTIL-ARRS-ARRAY                                
                      WS-UTIL-BAL-ARRAY.                                
           SET WS-IDX-1                  TO 1.                          
           SET WS-IDX-A                  TO 1.                          
           SET WS-IDX-B                  TO 1.                          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
P00836     MOVE 'SESSION.CSR04620_R1'    TO WS-GTT-NAME.                
           SET  WS-RULES                 TO TRUE.                       
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R1
              (                                                       
                    RETURN_CODE       INT                           
                   ,BUS_RULE_TYPE CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                   256100
P00836     MOVE 'SESSION.CSR04620_R2'    TO WS-GTT-NAME.                
           SET  WS-OPTIONS               TO TRUE.                       
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R2
              (                                                       
                    RETURN_CODE         INT                         
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
A02891             ,OPTION_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,UTILITY_BALANCE     DECIMAL(11,2)                   
                   ,UTILITY_ARREARS     DECIMAL(11,2)                   
                   ,AMT_MO_PYMT         DECIMAL(11,2)                   
                   ,AMT_ELEC_MO_PYMT    DECIMAL(11,2)                   
                   ,AMT_GAS_MO_PYMT     DECIMAL(11,2)                   
                   ,AMT_UNMTRD_MO_PYMT  DECIMAL(11,2)                   
                   ,AMT_OTHER_PYMTS     DECIMAL(11,2)                   
                   ,AMT_ROLLOVR         DECIMAL(11,2)                   
                   ,OPTN_PLS_PAY_AMT    DECIMAL(11,2)                   
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MTHS_ACCT_USAGE     INT                         
                   ,MTHS_PREM_USAGE     INT                         
                   ,BBP_BILL_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BBP_EST_AMT         DECIMAL(11,2)                   
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,REMARKS_TEXT CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,REMARKS_LENGTH      SMALLINT                        
P0694A             ,PVTL_TOTAL          DECIMAL(11,2)                   
P0694A             ,SUBL_TOTAL          DECIMAL(11,2)                   
P0694A             ,NONBBP_ELIG_AMT     DECIMAL(11,2)                   
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS THRU 8000B-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
P00836           MOVE 'CSR04620_R2'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
P00836     MOVE 'SESSION.CSR04620_R3'    TO WS-GTT-NAME.                
           SET  WS-OTHR-PYMTS            TO TRUE.                       
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R3
              (                                                       
                    RETURN_CODE       INT                           
                   ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CNT_AMT_MO_PYMT   DECIMAL(11,2)                     
                   ,CNT_PYMTS_REMAIN  INT                           
                   ,CNT_EXPIRY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS THRU 8000C-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
P00836           MOVE 'CSR04620_R3'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
P00836     MOVE 'SESSION.CSR04620_R4'    TO WS-GTT-NAME.                
           SET  WS-USAGE                 TO TRUE.                       
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R4
              (                                                       
                    RETURN_CODE       INT                           
                   ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,DAYS              SMALLINT                          
                   ,UNITS             DECIMAL(9,0)                      
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CUSTOMER_NO       DECIMAL(10,0)                     
                   ,NEW_CHARGE        DECIMAL(11,2)                     
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,HTG_CLG_SW        DECIMAL(3,0)                      
                   ,EPP_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P0694A             ,ELEC_BUFFER       DECIMAL(9,5)                      
P0694A             ,GAS_BUFFER        DECIMAL(9,5)                      
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS THRU 8000D-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
P00836           MOVE 'CSR04620_R4'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                   256100
P00836     MOVE 'SESSION.CSR04620_R5'    TO WS-GTT-NAME.                
           SET  WS-PLS-PAY-AMT           TO TRUE.                       
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R5
              (                                                       
                    RETURN_CODE       INT                           
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AR_TYPE_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,PLS_PAY_DET_AMT   DECIMAL(11,2)                     
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS THRU 8000E-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
P00836           MOVE 'CSR04620_R5'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
P00721******************************************************************        
P00721* 0100B-DECLARE-GTT                                              *        
P00721******************************************************************        
P00721*                                                                         
P00721 0100B-DECLARE-GTT.                                               
P00721*                                                                         
P00836     MOVE 'SESSION.CSR04620_R1'    TO WS-GTT-NAME.                
P00721     SET  WS-RULES                 TO TRUE.                       
P00721*                                                                         
P00721     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R1
              (                                                       
P00721              RETURN_CODE       INT                           
P00721             ,BUS_RULE_TYPE CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721             ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                         
P00721     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-1.            
P00721*                                                                         
P00721     IF WS-SQLSTATE = '42710'                                     
P00721        PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
P00721     ELSE                                                         
P00721        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00721           CONTINUE                                               
P00721        ELSE                                                      
P00721           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00721           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
P00721           MOVE SQLCODE            TO ABEND-SQLCODE               
P00721           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00721           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00721           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00721                                      ABEND-TABLES                
P00721           MOVE WS-GTT-NAME        TO TABLE-1                     
P00721           MOVE SPACES             TO TABLE-ELEMENT-1             
P00721           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00721           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00721        END-IF                                                    
P00721     END-IF.                                                      
P00721*                                                                   256100
P00836     MOVE 'SESSION.CSR04620_R3'    TO WS-GTT-NAME.                
P00836     SET  WS-OTHR-PYMTS            TO TRUE.                       
P00836*                                                                         
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R3
              (                                                       
P00836              RETURN_CODE       INT                           
P00836             ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836             ,CNT_AMT_MO_PYMT   DECIMAL(11,2)                     
P00836             ,CNT_PYMTS_REMAIN  INT                           
P00836             ,CNT_EXPIRY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00836     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00836                                      S-RETURN-CODE-3.            
P00836*                                                                         
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000C-DEL-GTT-ROWS THRU 8000C-EXIT                
P00836     ELSE                                                         
P00836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00836           CONTINUE                                               
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00836           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
P00836           MOVE SQLCODE            TO ABEND-SQLCODE               
P00836           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00836           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00836           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00836                                         ABEND-TABLES             
P00836           MOVE 'CSR04620_R3'      TO TABLE-1                     
P00836           MOVE SPACES             TO TABLE-ELEMENT-1             
P00836           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00836           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836     MOVE 'SESSION.CSR04620_R4'    TO WS-GTT-NAME.                
P00836     SET  WS-USAGE                 TO TRUE.                       
P00836*                                                                         
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R4
              (                                                       
P00836              RETURN_CODE       INT                           
P00836             ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836             ,DAYS              SMALLINT                          
P00836             ,UNITS             DECIMAL(9,0)                      
P00836             ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836             ,CUSTOMER_NO       DECIMAL(10,0)                     
P00836             ,NEW_CHARGE        DECIMAL(11,2)                     
P00836             ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836             ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
P00836             ,HTG_CLG_SW        DECIMAL(3,0)                      
P00836             ,EPP_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00836             ,ELEC_BUFFER       DECIMAL(9,5)                      
P00836             ,GAS_BUFFER        DECIMAL(9,5)                      
P00836          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                         
P00836     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00836     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00836                                      S-RETURN-CODE-4.            
P00836*                                                                         
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000D-DEL-GTT-ROWS THRU 8000D-EXIT                
P00836     ELSE                                                         
P00836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00836           CONTINUE                                               
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00836           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
P00836           MOVE SQLCODE            TO ABEND-SQLCODE               
P00836           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00836           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00836           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00836                                         ABEND-TABLES             
P00836           MOVE 'CSR04620_R4'      TO TABLE-1                     
P00836           MOVE SPACES             TO TABLE-ELEMENT-1             
P00836           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00836           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836*                                                                   256100
P00721     MOVE 'SESSION.CSR04620_R6'    TO WS-GTT-NAME.                
P00721     SET  WS-RULES                 TO TRUE.                       
P00721*                                                                         
P00721     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04620_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04620_R6
              (                                                       
P00721              RETURN_CODE       INT                           
P00721             ,BBP_ELIGIBLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                         
P00721     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-6.            
P00721*                                                                         
P00721     IF WS-SQLSTATE = '42710'                                     
P00721        PERFORM 8000F-DEL-GTT-ROWS THRU 8000F-EXIT                
P00721     ELSE                                                         
P00721        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00721           CONTINUE                                               
P00721        ELSE                                                      
P00721           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00721           MOVE '0100B'            TO ACTIVE-PARAGRAPH            
P00721           MOVE SQLCODE            TO ABEND-SQLCODE               
P00721           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00721           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00721           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00721                                      ABEND-TABLES                
P00721           MOVE WS-GTT-NAME        TO TABLE-1                     
P00721           MOVE SPACES             TO TABLE-ELEMENT-1             
P00721           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00721           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00721        END-IF                                                    
P00721     END-IF.                                                      
P00721*                                                                   256100
P00721 0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO.              
           MOVE WS-ACCOUNT-NUM           TO AC-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
                                            BH-ACCOUNT-NO               
                                            CT-ACCOUNT-NO               
                                            DA-ACCOUNT-NO               
                                            PJ-ACCOUNT-NO               
                                            UT-ACCOUNT-NO               
P00471                                      YP-ACCOUNT-NO.              
      *                                                                 12257300
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE 0                        TO S-UTILITY-BALANCE           
                                            S-UTILITY-ARREARS.          
           MOVE 'N'                      TO WS-EOF-CURSOR.              
      *                                                                         
           SET WS-OPTIONS                TO TRUE.                       
           PERFORM 7050-GET-ACCT-DET     THRU 7050-EXIT.                
      *                                                                         
      * Check Roll-over Eligibility                                             
      *                                                                         
           PERFORM 2100-CHK-ROL-OVR-ELIG THRU 2100-EXIT.                
      *                                                                         
      * Validate Account                                                        
      *                                                                         
      *                                                                         
           SET WS-RULES                  TO TRUE.                       
           PERFORM 2200-VALIDATE-ACCT    THRU 2200-EXIT.                
                                                                        
P00721     IF PARM-ELIGIBLE = SPACES                                    
P00721        CONTINUE                                                  
P00721     ELSE                                                         
P00721        IF BBP-ELIGIBLE                                           
P00721           MOVE 'Y'                TO S-BBP-ELIGIBLE              
P00836           IF PARM-ELIGIBLE = 'W'                                 
P00836              IF ( AT-COMPANY-NO = '26'                           
P00836                   AND AT-CREDIT-GROUP NOT = 'C')                 
P00836              OR ( AT-COMPANY-NO = '01'                           
P00836                   AND AT-CREDIT-GROUP NOT = 'A'                  
P00836                   AND AT-CREDIT-GROUP NOT = 'C'                  
P00836                   AND AT-CREDIT-GROUP NOT = 'N')                 
P00836                 MOVE 'N'       TO S-BBP-ELIGIBLE                 
P00836              END-IF                                              
P00836              IF S-BBP-ELIGIBLE = 'Y'                             
P00836                 PERFORM 2700-COMPUTE-ARREAR-CHARGES              
P00836                                           THRU 2700-EXIT         
P00836                 IF S-UTILITY-ARREARS > 0                         
P00836                   MOVE 'N'          TO S-BBP-ELIGIBLE            
P00836                 ELSE                                             
P00836                    PERFORM 2800-COMPUTE-USAGE-TOTAL              
p00836                                           THRU 2800-EXIT         
P00836                    IF NOT ((WS-WNTR-SUMR-MTHS-ELEC >= 6)  OR     
P00836                            (WS-WNTR-SUMR-MTHS-GAS  >= 6))        
P00836                       MOVE 'N'       TO S-BBP-ELIGIBLE           
P00836                    END-IF                                        
P00836                 END-IF                                           
P00836              END-IF                                              
P00836           END-IF                                                 
P00721        ELSE                                                      
P00721           MOVE 'N'    TO S-BBP-ELIGIBLE                          
P00721        END-IF                                                    
P00721        PERFORM 8060-INSERT-GTT-R6 THRU 8060-EXIT                 
P00721        GO TO 2000-EXIT                                           
P00721     END-IF.                                                      
                                                                        
                                                                        
           IF BBP-ELIGIBLE                                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
      * Compute Current Charges & Arrears                                       
      *                                                                         
P00836     PERFORM 2700-COMPUTE-ARREAR-CHARGES      THRU 2700-EXIT.     
           MOVE S-UTILITY-BALANCE        TO WS-UTILITY-BAL-ED.          
           MOVE S-UTILITY-ARREARS        TO WS-UTILITY-ARR-ED.          
      *                                                                         
      * Compute Premise Usage Totals                                            
      *                                                                         
P00836     PERFORM 2800-COMPUTE-USAGE-TOTAL         THRU 2800-EXIT.     
      *                                                                         
A02878     IF (WS-WNTR-SUMR-MTHS-ELEC >= 6)  OR                         
A02878        (WS-WNTR-SUMR-MTHS-GAS  >= 6)                             
              CONTINUE                                                  
           ELSE                                                         
      * BBP900 - Cooling/heating hist is not enough to estimate BBP Amt         
P0694C*       PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                        
              PERFORM 8000B-DEL-GTT-ROWS THRU 8000B-EXIT                
              PERFORM 8000C-DEL-GTT-ROWS THRU 8000C-EXIT                
              PERFORM 8000D-DEL-GTT-ROWS THRU 8000D-EXIT                
P00836        MOVE 0                     TO WS-BBP-RULES                
P00836                                      WS-BBP-OPTIONS              
                                            WS-MTHLY-CHRGS              
                                            WS-BBP-USAGE                
                                            WS-BBP-PLS-PAY              
              MOVE 0                     TO S-RETURN-CODE-1             
              MOVE 'BBP900'              TO S-BUS-RULE-TYPE             
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
P0694C*       GO TO 2000-EXIT.                                                  
A02878     END-IF.                                                      
      *                                                                         
      * Compute BBP Estimated Monthly Amounts                                   
      *                                                                         
           SET WS-OPTIONS                TO TRUE.                       
A02878*                                                                         
A02878     IF (WS-WNTR-SUMR-MTHS-ELEC >= 6   )  AND                     
A02878        (WS-TOT-MTHS-USAGE-ELEC >  0   )                          
              COMPUTE S-AMT-ELEC-MO-PYMT ROUNDED =                      
P00694             (WS-ELEC-TOTAL /                                     
P00694             WS-TOT-MTHS-USAGE-ELEC )                             
           END-IF.                                                      
      *                                                                         
A02878     IF (WS-WNTR-SUMR-MTHS-GAS  >= 6   )  AND                     
A02878        (WS-TOT-MTHS-USAGE-GAS  >  0   )                          
              COMPUTE S-AMT-GAS-MO-PYMT  ROUNDED =                      
P00694             (WS-GAS-TOTAL /                                      
P00694             WS-TOT-MTHS-USAGE-GAS)                               
           END-IF.                                                      
      *                                                                         
           COMPUTE S-AMT-UNMTRD-MO-PYMT  = WS-PVTL-TOTAL       +        
                                           WS-SUBL-TOTAL.               
           COMPUTE S-BBP-EST-AMT         = S-AMT-ELEC-MO-PYMT  +        
                                           S-AMT-GAS-MO-PYMT   +        
                                           S-AMT-UNMTRD-MO-PYMT.        
      *                                                                         
      * Round-up Estimated BBP Amount                                           
      *                                                                         
           COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = S-BBP-EST-AMT.          
           IF S-BBP-EST-AMT > WS-AMT-MO-PYMT-RND                        
              COMPUTE S-BBP-EST-AMT =  WS-AMT-MO-PYMT-RND + 1           
           ELSE                                                         
              MOVE WS-AMT-MO-PYMT-RND    TO S-BBP-EST-AMT               
           END-IF.                                                      
      *                                                                         
           MOVE S-BBP-EST-AMT            TO S-AMT-MO-PYMT               
                                            WS-AMT-BBP-EST-ED           
                                            WS-AMT-MO-PYMT-HOLD.        
      *                                                                         
      * Get Revenue Month                                                       
      *                                                                         
           IF AT-REV-MTH-LST-NRML = 0                                   
A03710        IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES   
A03710                                         OR '99' OR '00' )        
A03710           PERFORM 7060-GET-BN-REV-MTH   THRU 7060-EXIT           
A03710        ELSE                                                      
A02878           MOVE AT-BILL-CYCLE         TO BN-BILL-CYCLE            
                 PERFORM 7100-GET-REV-MTH   THRU 7100-EXIT              
A03710        END-IF                                                    
              MOVE BN-REVENUE-MONTH      TO WS-REV-MTH-NUM              
           ELSE                                                         
              MOVE AT-REV-MTH-LST-NRML   TO WS-REV-MTH-NUM              
           END-IF.                                                      
      *                                                                         
           MOVE WS-REV-MTH-CCYY          TO WS-PYMT-STRT-CCYY.          
           MOVE WS-REV-MTH-MM            TO WS-PYMT-STRT-MM.            
           MOVE WS-PYMT-STRT-DT          TO S-START-DATE.               
           MOVE AT-LAST-UPDATE-TS        TO S-LAST-UPDATE-TS.           
      *                                                                         
      * Compute BBP Amount To Collect& Start Date                               
      *                                                                         
           IF ( S-UTILITY-ARREARS   = 0 AND S-UTILITY-BALANCE = 0 ) OR  
P0694B        ( AT-REV-MTH-LST-NRML = 0 )                               
      *       Option 2 - 'Next Bill' Only                                       
              PERFORM 2400-FMT-NXT-BIL-OPTN THRU 2400-EXIT              
           ELSE                                                         
      *       Option 1 - 'Current Bill'                                         
              PERFORM 2300-FMT-CUR-BIL-OPTN THRU 2300-EXIT              
      *       Option 2 - 'Next Bill'                                            
              PERFORM 2400-FMT-NXT-BIL-OPTN THRU 2400-EXIT              
      *                                                                         
              IF WS-ROL-OVR-ELIG = 'Y'                                  
                 IF S-UTILITY-ARREARS > 0                               
      *             Option 3 - Rollover with Current Bill                       
                    PERFORM 2500-ROLOVR-CUR-BIL-OPTN THRU 2500-EXIT     
                 END-IF                                                 
                 IF S-UTILITY-BALANCE > S-UTILITY-ARREARS AND           
                    S-UTILITY-ARREARS > 0                               
      *             Option 4 - Rollover with Next Bill                          
                    PERFORM 2600-ROLOVR-NXT-BIL-OPTN THRU 2600-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10740000
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           ADD +1                         TO CTR-ROWS.                  
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2100-CHK-ROL-OVR-ELIG.                                         *        
      ******************************************************************        
      *                                                                         
       2100-CHK-ROL-OVR-ELIG.                                           
      *                                                                 11670000
           MOVE AT-COMPANY-NO            TO C8-COMPANY-NO.              
           MOVE 'EPP-ROLLOVER'           TO C8-DELINQ-CD.               
           PERFORM 7600-SELECT-DELINQ    THRU 7600-EXIT.                
           IF C8-DELINQ-VALUE = 0                                       
              MOVE 'N'                   TO WS-ROL-OVR-ENABLD           
              GO TO 2100-EXIT                                           
           ELSE                                                         
              MOVE 'Y'                   TO WS-ROL-OVR-ENABLD           
           END-IF.                                                      
      *                                                                 11670000
           MOVE AT-COMPANY-NO            TO C8-COMPANY-NO.              
           MOVE 'EPP-DPP-DROP-FLAG'      TO C8-DELINQ-CD.               
           PERFORM 7600-SELECT-DELINQ    THRU 7600-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-BBP-LIMIT.               
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, -:WS-BBP-LIMIT, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )
            INTO
              :WS-BBP-DPP-CUTOFF-DT                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-BBP-DPP-CUTOFF-DT = CURRENT DATE -                     
MFA-TR*                            :WS-BBP-LIMIT  MONTHS                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7900-CHK-DPP-DROP     THRU 7900-EXIT                 
           PERFORM 7910-CHK-BBP-DROP     THRU 7910-EXIT                 
      *                                                                         
           MOVE AT-COMPANY-NO            TO C8-COMPANY-NO.              
           MOVE 'EPP-RO-DAYS-UTIL-ARR'   TO C8-DELINQ-CD.               
           PERFORM 7600-SELECT-DELINQ    THRU 7600-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DAYS-UTIL-ARRS.          
           IF WS-DAYS-UTIL-ARRS = 30                                    
              PERFORM 7920-CHK-UTL-ARRS  THRU 7920-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF WS-BBP-DROP-EXISTS = 'Y' OR WS-DPP-DROP-EXISTS = 'Y' OR   
              WS-UTL-ARRS-EXISTS = 'Y'                                  
              MOVE 'N'                   TO WS-ROL-OVR-ELIG             
           ELSE                                                         
              MOVE 'Y'                   TO WS-ROL-OVR-ELIG             
           END-IF.                                                      
      *                                                                 11670000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2200-VALIDATE-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
       2200-VALIDATE-ACCT.                                              
      *                                                                         
           PERFORM 6000-VALIDATE-ACCT    THRU 6000-EXIT.                
      *                                                                         
       2200-EXIT.                                                       
      *                                                                 11670000
      ******************************************************************        
      * 2250-GET-AR-BALANCE.                                           *        
      ******************************************************************        
      *                                                                         
       2250-GET-AR-BALANCE.                                             
      *                                                                         
           IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-NSC OR WS-PPL-LPC  OR     
                                       WS-PPL-UTE OR WS-PPL-UTG) AND    
               AC-ITEM-ID = 0)                                          
           OR (AC-PYMT-PRIORITY-LVL = WS-PPL-RCC AND AC-ITEM-ID > 0 AND 
               (AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 + AC-AMT-AR-DAY-60 +
                AC-AMT-AR-DAY-90 + AC-AMT-UNUSED-CR) > 0)               
      *                                                                         
              IF AC-ITEM-ID = 0                                         
                 COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +        
                                             AC-AMT-AR-DAY-00  +        
                                             AC-AMT-AR-DAY-30  +        
                                             AC-AMT-AR-DAY-60  +        
                                             AC-AMT-AR-DAY-90  +        
                                             AC-AMT-UNUSED-CR           
                 COMPUTE WS-RECV-AMT-HOLD  = AC-AMT-AR-DAY-00 +         
                                             AC-AMT-AR-DAY-30  +        
                                             AC-AMT-AR-DAY-60  +        
                                             AC-AMT-AR-DAY-90  +        
                                             AC-AMT-UNUSED-CR           
                 IF AC-TOT-SUMM-UNBILLED > 0                            
                    COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +     
                                                AC-TOT-SUMM-UNBILLED    
                    COMPUTE WS-RECV-AMT-HOLD  = WS-RECV-AMT-HOLD +      
                                                AC-TOT-SUMM-UNBILLED    
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +        
                                             AC-AMT-TRAN-BALANCE        
                 MOVE AC-AMT-TRAN-BALANCE     TO WS-RECV-AMT-HOLD       
              END-IF                                                    
      *                                                                         
              IF WS-RECV-AMT-HOLD > 0                                   
                 MOVE L5-AR-TYPE-LONG-DESC    TO WS-BAL-TYPE (WS-IDX-B) 
                 MOVE WS-RECV-AMT-HOLD        TO WS-BAL-AMT (WS-IDX-B)  
                 SET WS-IDX-B UP BY 1                                   
              END-IF                                                    
      *                                                                         
              COMPUTE S-UTILITY-ARREARS = S-UTILITY-ARREARS +           
                                          AC-AMT-AR-DAY-30  +           
                                          AC-AMT-AR-DAY-60  +           
                                          AC-AMT-AR-DAY-90              
      *                                                                         
              COMPUTE WS-RECV-AMT-HOLD  = AC-AMT-AR-DAY-30  +           
                                          AC-AMT-AR-DAY-60  +           
                                          AC-AMT-AR-DAY-90              
      *                                                                         
              IF WS-RECV-AMT-HOLD > 0                                   
                 MOVE L5-AR-TYPE-LONG-DESC    TO WS-ARRS-TYPE (WS-IDX-A)
                 MOVE WS-RECV-AMT-HOLD        TO WS-ARRS-AMT (WS-IDX-A) 
                 SET WS-IDX-A UP BY 1                                   
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL = WS-PPL-RCC                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 IF AC-PYMT-PRIORITY-LVL  < 50 OR                       
                    (AC-PYMT-PRIORITY-LVL > 50 AND AC-ITEM-ID > 0)      
                    COMPUTE WS-NONBBP-ELIG-AMT = WS-NONBBP-ELIG-AMT +   
                                                 AC-AMT-AR-DAY-00   +   
                                                 AC-AMT-AR-DAY-30   +   
                                                 AC-AMT-AR-DAY-60   +   
                                                 AC-AMT-AR-DAY-90   +   
                                                 AC-AMT-UNUSED-CR       
                    IF AC-TOT-SUMM-UNBILLED > ZERO                      
                       COMPUTE WS-NONBBP-ELIG-AMT =                     
                               WS-NONBBP-ELIG-AMT + AC-TOT-SUMM-UNBILLED
                    END-IF                                              
      *                                                                         
P0694A              MOVE WS-NONBBP-ELIG-AMT TO S-NONBBP-ELIG-AMT        
      *                                                                         
                    COMPUTE WS-RECV-AMT-HOLD = AC-AMT-AR-DAY-00 +       
                                               AC-AMT-AR-DAY-30 +       
                                               AC-AMT-AR-DAY-60 +       
                                               AC-AMT-AR-DAY-90 +       
                                               AC-AMT-UNUSED-CR +       
                                               AC-TOT-SUMM-UNBILLED     
                    IF WS-RECV-AMT-HOLD > 0                             
                       MOVE L5-AR-TYPE-LONG-DESC TO                     
                                                 WS-RECV-TYPE (WS-IDX-1)
                       MOVE WS-RECV-AMT-HOLD     TO                     
                                                 WS-RECV-AMT (WS-IDX-1) 
                       SET WS-IDX-1 UP BY 1                             
                    END-IF                                              
      *             Compute Other Monthly Payments                              
                    SET WS-OTHR-PYMTS             TO TRUE               
                    PERFORM 2260-GET-OTHR-AMTS   THRU 2260-EXIT         
                    SET WS-OPTIONS                TO TRUE               
                 END-IF                                                 
      *                                                                         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7510-FETCH-AR-CURSOR  THRU 7510-EXIT.                
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2260-GET-OTHR-AMTS.                                            *        
      ******************************************************************        
      *                                                                         
       2260-GET-OTHR-AMTS.                                              
      *                                                                         
           MOVE AC-AMT-TRAN-BALANCE            TO WS-MAX-RECV-AMT.      
      *                                                                         
           EVALUATE AC-PYMT-PRIORITY-LVL                                
               WHEN 80                                                  
      *             Deposits                                                    
                    MOVE AC-ACCOUNT-NO         TO DR-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DR-DEP-ITEM-ID        
                    PERFORM 7810-GET-DEP-REQ   THRU 7810-EXIT           
ACT211**-- DO NOT INCLUDE ONE TIME DEPOSIT                                      
ACT211              IF DR-NO-SCHED-PYMTS = 1                            
ACT211                 MOVE ZEROS TO DR-AMT-MO-PYMT                     
ACT211              END-IF                                              
                    MOVE DR-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-AMT-OTHER-PYMTS = S-AMT-OTHER-PYMTS +     
                                                DR-AMT-MO-PYMT          
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DR-AMT-MO-PYMT            
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891              END-COMPUTE                                         
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DR-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                                    
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +                  
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                         
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    MOVE 'Deposit'             TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 90                                                  
      *             DFA's                                                       
                    IF AC-ITEM-ID > 40000000                            
                       CONTINUE                                         
                    ELSE                                                
                       GO TO 2260-EXIT                                  
                    END-IF                                              
                    MOVE AC-ACCOUNT-NO         TO DA-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DA-DFA-ITEM-ID        
                    PERFORM 7820-GET-DFA-DET   THRU 7820-EXIT           
                    MOVE DA-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DA-AMT-MO-PYMT            
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891              END-COMPUTE                                         
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DA-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                                    
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +                  
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                         
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    COMPUTE S-AMT-OTHER-PYMTS = S-AMT-OTHER-PYMTS +     
                                                DA-AMT-MO-PYMT          
                    MOVE 'DFA'                 TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 100                                                 
      *             Contracts                                                   
                    MOVE AC-ACCOUNT-NO         TO CT-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO CT-CNT-ITEM-ID        
                    PERFORM 7830-GET-CNT-DET   THRU 7830-EXIT           
      *                                                                         
                    IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND               
                       GO TO 2260-EXIT                                  
                    ELSE                                                
                       CONTINUE                                         
                    END-IF                                              
      *                                                                         
                    COMPUTE S-AMT-OTHER-PYMTS = S-AMT-OTHER-PYMTS +     
                                                CT-AMT-MO-PYMT          
                    MOVE K6-CNT-NAME-DESC      TO S-CNT-NAME-DESC       
                    MOVE CT-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    IF CT-CODE-BILL-TYPE = 'C'                          
                       COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =             
                               WS-MAX-RECV-AMT / CT-AMT-MO-PYMT         
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891              END-COMPUTE                                         
                       IF S-CNT-PYMTS-REMAIN = 0                        
                          MOVE CT-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN 
                       END-IF                                           
                       EXEC SQL                                         
                            SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT              
                       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*                EXEC SQL                                                 
MFA-TR*                     SET :S-CNT-EXPIRY-DT = CURRENT DATE +               
MFA-TR*                         :S-CNT-PYMTS-REMAIN MONTHS                      
MFA-TR*                END-EXEC                                                 
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
                    ELSE                                                
                       MOVE SPACES             TO S-CNT-EXPIRY-DT       
                       MOVE 0                  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    MOVE ZERO                  TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 129                                                 
      *             Project Share                                               
                    PERFORM 7700-GET-PJS-AMT   THRU 7700-EXIT           
                    COMPUTE S-AMT-OTHER-PYMTS = S-AMT-OTHER-PYMTS +     
                                                PJ-MONTHLY-BILL-AM      
                    IF PJ-MONTHLY-BILL-AM > 0                           
                       MOVE 'Project Share'    TO S-CNT-NAME-DESC       
                       MOVE PJ-MONTHLY-BILL-AM TO S-CNT-AMT-MO-PYMT     
                       MOVE 0                  TO S-RETURN-CODE-3       
                       PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT        
                    END-IF                                              
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                         
       2260-EXIT.                                                       
      *                                                                 11670000
      ******************************************************************        
      * 2300-FMT-CUR-BIL-OPTN.                                         *        
      ******************************************************************        
      *                                                                         
       2300-FMT-CUR-BIL-OPTN.                                           
      *                                                                 11670000
           MOVE 'C'                      TO S-BBP-BILL-FLAG.            
           MOVE '1'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
      *                                                                         
A02891     IF S-UTILITY-ARREARS  >  0                                   
A02891        MOVE WS-BBP-OPTN-CUR-BIL-TX1  TO  S-OPTION-DESC           
A02891     ELSE                                                         
A02891        MOVE WS-BBP-OPTN-CUR-BIL-TX2  TO  S-OPTION-DESC           
A02891     END-IF.                                                      
A02891*                                                                         
           COMPUTE S-OPTN-PLS-PAY-AMT    = S-UTILITY-ARREARS +          
                                           S-AMT-MO-PYMT     +          
                                           WS-NONBBP-ELIG-AMT.          
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                         
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                         
      * Pls Pay Amt Details                                                     
      *                                                                         
      * Utility Arrears                                                         
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-ARREARS > 0                                     
              SET WS-IDX-A               TO 1                           
              PERFORM UNTIL WS-ARRS-TYPE(WS-IDX-A) = SPACES             
                 MOVE 0                       TO S-RETURN-CODE-5        
                 MOVE WS-ARRS-TYPE (WS-IDX-A) TO S-AR-TYPE-DESC         
                 MOVE WS-ARRS-AMT (WS-IDX-A)  TO S-PLS-PAY-DET-AMT      
                 PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT            
                 SET WS-IDX-A UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      * BBP Estimated Amount                                                    
           MOVE 0                        TO S-RETURN-CODE-5.            
           MOVE 'BBP MONTHLY AMOUNT'     TO S-AR-TYPE-DESC.             
           MOVE S-AMT-MO-PYMT            TO S-PLS-PAY-DET-AMT.          
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      * Non BBP Eligible Receivables                                            
           SET WS-IDX-1                  TO 1.                          
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                          TO S-RETURN-CODE-5        
              MOVE WS-RECV-TYPE (WS-IDX-1)    TO S-AR-TYPE-DESC         
              MOVE WS-RECV-AMT  (WS-IDX-1)    TO S-PLS-PAY-DET-AMT      
              PERFORM 8050-INSERT-GTT-R5 THRU 8050-EXIT                 
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 11670000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2400-FMT-NXT-BIL-OPTN.                                         *        
      ******************************************************************        
      *                                                                         
       2400-FMT-NXT-BIL-OPTN.                                           
      *                                                                 11670000
           MOVE 'N'                      TO S-BBP-BILL-FLAG.            
           MOVE '2'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
      *                                                                         
A02891     IF S-UTILITY-ARREARS  >  0                                   
A02891        MOVE WS-BBP-OPTN-NXT-BIL-TX1  TO  S-OPTION-DESC           
A02891     ELSE                                                         
A02891        MOVE WS-BBP-OPTN-NXT-BIL-TX2  TO  S-OPTION-DESC           
A02891     END-IF.                                                      
A02891*                                                                         
           COMPUTE S-OPTN-PLS-PAY-AMT    =  S-UTILITY-BALANCE +         
                                            WS-NONBBP-ELIG-AMT.         
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :S-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :S-START-DATE
              ) <> 0) OR (LEN(:S-START-DATE) <> 10), CIS.CHAR2DATE(
                                                          :S-START-DATE
              ), CONVERT(DATE, :S-START-DATE) ) )
            INTO
              :S-START-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :S-START-DATE         = DATE(:S-START-DATE) +               
MFA-TR*                                     1 MONTH                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                         
      * Pls Pay Amt Details                                                     
      *                                                                         
      * Utility Balance                                                         
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-BALANCE > 0                                     
              SET WS-IDX-B               TO 1                           
              PERFORM UNTIL WS-BAL-TYPE(WS-IDX-B) = SPACES              
                 MOVE 0                      TO S-RETURN-CODE-5         
                 MOVE WS-BAL-TYPE (WS-IDX-B) TO S-AR-TYPE-DESC          
                 MOVE WS-BAL-AMT (WS-IDX-B)  TO S-PLS-PAY-DET-AMT       
                 PERFORM 8050-INSERT-GTT-R5  THRU 8050-EXIT             
                 SET WS-IDX-B UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      * Non BBP Eligible Receivables                                            
           SET WS-IDX-1                  TO 1.                          
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                         TO S-RETURN-CODE-5         
              MOVE WS-RECV-TYPE (WS-IDX-1)   TO S-AR-TYPE-DESC          
              MOVE WS-RECV-AMT  (WS-IDX-1)   TO S-PLS-PAY-DET-AMT       
              PERFORM 8050-INSERT-GTT-R5 THRU 8050-EXIT                 
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 11670000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2500-ROLOVR-CUR-BIL-OPTN.                                      *        
      ******************************************************************        
      *                                                                         
       2500-ROLOVR-CUR-BIL-OPTN.                                        
      *                                                                 11670000
           MOVE 'R'                      TO S-BBP-BILL-FLAG.            
           MOVE '3'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
           MOVE WS-BBP-OPTN-ROL-CUR-BIL  TO S-OPTION-DESC.              
           MOVE WS-AMT-MO-PYMT-HOLD      TO S-AMT-MO-PYMT.              
      *                                                                         
           COMPUTE WS-ROLOVR-AMT = S-UTILITY-ARREARS / 12.              
           COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = WS-ROLOVR-AMT.          
           IF WS-ROLOVR-AMT > WS-AMT-MO-PYMT-RND                        
              COMPUTE WS-ROLOVR-AMT =  WS-AMT-MO-PYMT-RND + 1           
           ELSE                                                         
              MOVE WS-AMT-MO-PYMT-RND    TO WS-ROLOVR-AMT               
           END-IF.                                                      
           MOVE WS-ROLOVR-AMT            TO WS-ROLOVR-AMT-ED            
                                            S-AMT-ROLLOVR.              
      *                                                                         
           COMPUTE S-AMT-MO-PYMT = S-AMT-MO-PYMT +                      
                                   WS-ROLOVR-AMT.                       
           MOVE S-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-ED.          
      *                                                                         
           STRING 'BPA;ELIG RO $'      DELIMITED BY SIZE                
                  WS-UTILITY-ARR-ED    DELIMITED BY SIZE                
                  ' / 12 = $'          DELIMITED BY SIZE                
                  WS-ROLOVR-AMT-ED     DELIMITED BY SIZE                
                  ';BBP EST $'         DELIMITED BY SIZE                
                  WS-AMT-BBP-EST-ED    DELIMITED BY SIZE                
                  ';BBP AMT $'         DELIMITED BY SIZE                
                  WS-AMT-MO-PYMT-ED    DELIMITED BY SIZE                
                  ';'                  DELIMITED BY SIZE                
             INTO S-REMARKS-TEXT.                                       
           MOVE +95                    TO S-REMARKS-LENGTH.             
      * Remove embedded spaces                                                  
           MOVE SPACES                 TO WS-REMARKS-TEXT.              
           MOVE S-REMARKS-TEXT         TO WS-REMARKS-TEXT.              
           MOVE SPACES                 TO S-REMARKS-TEXT                
                                          WS-RESULT-TEXT                
                                          WS-PREV-CHAR.                 
           SET WS-IDX-R                TO 1.                            
           SET WS-IDX-2                TO 1.                            
      *                                                                         
           PERFORM S-REMARKS-LENGTH TIMES                               
              IF WS-REMARKS-CHAR(WS-IDX-R) = SPACES AND                 
                 WS-PREV-CHAR              = SPACES                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-REMARKS-CHAR(WS-IDX-R)                         
                                         TO WS-RESULT-CHAR(WS-IDX-2)    
                                            WS-PREV-CHAR                
                 SET WS-IDX-2            UP BY 1                        
              END-IF                                                    
                 SET WS-IDX-R            UP BY 1                        
           END-PERFORM.                                                 
           MOVE WS-RESULT-TEXT           TO S-REMARKS-TEXT.             
      *                                                                         
           COMPUTE S-OPTN-PLS-PAY-AMT    = S-AMT-MO-PYMT +              
                                           WS-NONBBP-ELIG-AMT.          
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                         
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                         
      * Pls Pay Amt Details                                                     
      *                                                                         
      * BBP Estimated Amount                                                    
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           MOVE 0                        TO S-RETURN-CODE-5.            
           MOVE 'BBP MONTHLY AMOUNT'     TO S-AR-TYPE-DESC.             
           MOVE S-AMT-MO-PYMT            TO S-PLS-PAY-DET-AMT.          
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      * Non BBP Eligible Receivables                                            
           SET WS-IDX-1                  TO 1.                          
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                       TO S-RETURN-CODE-5           
              MOVE WS-RECV-TYPE (WS-IDX-1) TO S-AR-TYPE-DESC            
              MOVE WS-RECV-AMT  (WS-IDX-1) TO S-PLS-PAY-DET-AMT         
              PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT               
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 11670000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2600-ROLOVR-CUR-BIL-OPTN.                                      *        
      ******************************************************************        
      *                                                                         
       2600-ROLOVR-NXT-BIL-OPTN.                                        
      *                                                                 11670000
           MOVE 'S'                      TO S-BBP-BILL-FLAG.            
           MOVE '4'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
           MOVE WS-BBP-OPTN-ROL-NXT-BIL  TO S-OPTION-DESC.              
           MOVE WS-AMT-MO-PYMT-HOLD      TO S-AMT-MO-PYMT.              
      *                                                                 11670000
           COMPUTE WS-ROLOVR-AMT =                                      
                         (S-UTILITY-BALANCE - S-UTILITY-ARREARS) / 12.  
           COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = WS-ROLOVR-AMT.          
           IF WS-ROLOVR-AMT > WS-AMT-MO-PYMT-RND                        
              COMPUTE WS-ROLOVR-AMT =  WS-AMT-MO-PYMT-RND + 1           
           ELSE                                                         
              MOVE WS-AMT-MO-PYMT-RND    TO WS-ROLOVR-AMT               
           END-IF.                                                      
           MOVE WS-ROLOVR-AMT            TO WS-ROLOVR-AMT-ED            
                                            S-AMT-ROLLOVR.              
      *                                                                         
           COMPUTE S-AMT-MO-PYMT = S-AMT-MO-PYMT +                      
                                   WS-ROLOVR-AMT.                       
           MOVE S-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-ED.          
      *                                                                         
           STRING 'BPA;ELIG RO $'      DELIMITED BY SIZE                
                  WS-UTILITY-BAL-ED    DELIMITED BY SIZE                
                  ' - AMT TO COLL $'   DELIMITED BY SIZE                
                  WS-UTILITY-ARR-ED    DELIMITED BY SIZE                
                  ' / 12 = $'          DELIMITED BY SIZE                
                  WS-ROLOVR-AMT-ED     DELIMITED BY SIZE                
                  ';BBP EST $'         DELIMITED BY SIZE                
                  WS-AMT-BBP-EST-ED    DELIMITED BY SIZE                
                  ';BBP AMT $'         DELIMITED BY SIZE                
                  WS-AMT-MO-PYMT-ED    DELIMITED BY SIZE                
                  ';'                  DELIMITED BY SIZE                
             INTO S-REMARKS-TEXT.                                       
           MOVE +124                   TO S-REMARKS-LENGTH.             
      * Remove embedded spaces                                                  
           MOVE SPACES                 TO WS-REMARKS-TEXT.              
           MOVE S-REMARKS-TEXT         TO WS-REMARKS-TEXT.              
           MOVE SPACES                 TO S-REMARKS-TEXT                
                                          WS-RESULT-TEXT                
                                          WS-PREV-CHAR.                 
           SET WS-IDX-R                TO 1.                            
           SET WS-IDX-2                TO 1.                            
      *                                                                         
           PERFORM S-REMARKS-LENGTH TIMES                               
              IF WS-REMARKS-CHAR(WS-IDX-R) = SPACES AND                 
                 WS-PREV-CHAR              = SPACES                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-REMARKS-CHAR(WS-IDX-R)                         
                                         TO WS-RESULT-CHAR(WS-IDX-2)    
                                            WS-PREV-CHAR                
                 SET WS-IDX-2            UP BY 1                        
              END-IF                                                    
                 SET WS-IDX-R            UP BY 1                        
           END-PERFORM.                                                 
           MOVE WS-RESULT-TEXT           TO S-REMARKS-TEXT.             
      *                                                                 11670000
           COMPUTE S-OPTN-PLS-PAY-AMT    =  S-UTILITY-ARREARS +         
                                            WS-NONBBP-ELIG-AMT.         
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                 11670000
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :S-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :S-START-DATE
              ) <> 0) OR (LEN(:S-START-DATE) <> 10), CIS.CHAR2DATE(
                                                          :S-START-DATE
              ), CONVERT(DATE, :S-START-DATE) ) )
            INTO
              :S-START-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :S-START-DATE         = DATE(:S-START-DATE) +               
MFA-TR*                                     1 MONTH                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11670000
           PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT.               
      *                                                                         
      * Pls Pay Amt Details                                                     
      *                                                                         
      * Utility Arrears                                                         
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-ARREARS > 0                                     
              SET WS-IDX-A               TO 1                           
              PERFORM UNTIL WS-ARRS-TYPE(WS-IDX-A) = SPACES             
                 MOVE 0                       TO S-RETURN-CODE-5        
                 MOVE WS-ARRS-TYPE (WS-IDX-A) TO S-AR-TYPE-DESC         
                 MOVE WS-ARRS-AMT (WS-IDX-A)  TO S-PLS-PAY-DET-AMT      
                 PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT            
                 SET WS-IDX-A UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      *    Pls Pay Amt Details                                                  
           SET WS-IDX-1                   TO 1.                         
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                        TO S-RETURN-CODE-5          
              MOVE WS-RECV-TYPE (WS-IDX-1)  TO S-AR-TYPE-DESC           
              MOVE WS-RECV-AMT  (WS-IDX-1)  TO S-PLS-PAY-DET-AMT        
              PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT              
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 11670000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00836***************************************************************** *       
P00836* 2700-COMPUTE-ARREAR-CHARGES                                   *         
P00836***************************************************************** *       
P00836*                                                                         
P00836 2700-COMPUTE-ARREAR-CHARGES.                                     
P00836*                                                                 11670000
P00836     SET WS-OPTIONS                TO TRUE.                       
P00836     PERFORM 7500-OPEN-AR-CURSOR   THRU 7500-EXIT.                
P00836     PERFORM 7510-FETCH-AR-CURSOR  THRU 7510-EXIT.                
P00836     PERFORM 2250-GET-AR-BALANCE   THRU 2250-EXIT                 
P00836                                   UNTIL NO-MORE-DATA.            
P00836     PERFORM 7520-CLOSE-AR-CURSOR  THRU 7520-EXIT.                
P00836*                                                                 11670000
P00836 2700-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
P00836***************************************************************** *       
P00836* 2800-COMPUTE-USAGE-TOTAL.                                               
P00836***************************************************************** *       
P00836*                                                                         
P00836 2800-COMPUTE-USAGE-TOTAL.                                        
P00836*                                                                 11670000
P00836     MOVE AT-PREMISE-NO            TO WS-PREMISE-NUM.             
P00836     MOVE WS-PREMISE-NO            TO WS-02322-PREMISE.           
P00836     MOVE WS-CURRENT-DATE          TO WS-02322-DATE.              
P00836     SET WS-USAGE                  TO TRUE.                       
P00836     PERFORM 5010-CALL-CSR02322    THRU 5010-EXIT.                
P00836*                                                                 11670000
P00836 2800-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                         
      ******************************************************************        
      * 5010-CALL-CSR04322                                             *        
      ******************************************************************        
      *                                                                         
       5010-CALL-CSR02322.                                              
      *                                                                         
      *    EXEC SQL                                                     
P00464*         CALL CSR02322(' '                                       
P00464*                      ,:WS-02322-PREMISE                         
P00464*                      ,:WS-02322-DATE                            
P00464*                      ,' '                                       
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE USAGE_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN USAGE_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR USAGE_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = +466                             
               CONTINUE                                                 
           ELSE                                                         
              MOVE '5010'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
              MOVE 'CSR02322'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-1           
              MOVE 'DATE'                TO TABLE-ELEMENT-2             
              MOVE WS-02322-DATE         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
      *    EXEC SQL                                                     
      *         ASSOCIATE LOCATORS                                      
      *         (:LOC-RESLTSET)                                         
      *         WITH PROCEDURE CSR02322                                 
      *    END-EXEC.                                                    
      *                                                                         
      *    EXEC SQL                                                     
      *      ALLOCATE USAGE_CUR CURSOR FOR RESULT SET                   
      *      :LOC-RESLTSET                                              
      *    END-EXEC.                                                    
      *                                                                         
           MOVE 'N'                      TO WS-EOF-CURSOR.              
           MOVE 0                        TO WS-ELEC-TOTAL               
                                            WS-GAS-TOTAL                
                                            WS-PVTL-TOTAL               
                                            WS-SUBL-TOTAL.              
           PERFORM 5011-FETCH-CSR02322   THRU 5011-EXIT                 
                                         UNTIL NO-MORE-DATA.            
      *                                                                         
           EXEC SQL                                                     
             CLOSE USAGE_CUR                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              MOVE '5010'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSR02322'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5011-FETCH-CSR02322                                            *        
      ******************************************************************        
      *                                                                         
       5011-FETCH-CSR02322.                                             
      *                                                                         
           EXEC SQL                                                     
             FETCH USAGE_CUR                                            
              INTO  :S-RETURN-CODE-4                                    
                   ,:S-REVENUE-MONTH                                    
                   ,:S-DAYS                                             
                   ,:S-UNITS                                            
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-CUSTOMER-NO                                      
                   ,:S-NEW-CHARGE                                       
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-CALC-ERROR                                       
                   ,:S-HTG-CLG-SW                                       
                   ,:S-BPP-CATEGORY                                     
P0694A             ,:S-ELEC-BUFFER                                      
P0694A             ,:S-GAS-BUFFER                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
A02878     EVALUATE TRUE                                                
A02878         WHEN (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)  AND      
A02878              (S-RETURN-CODE-4       = 0              )           
A02878              PERFORM 5025-PROCESS-CSR02322-DATA THRU 5025-EXIT   
A02878         WHEN (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                 
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-4       
               WHEN OTHER                                               
A02878              IF S-RETURN-CODE-4 NOT = 0                          
A02878                 MOVE S-RETURN-CODE-4    TO WS-ACTIVE-RETURN-CODE 
A02878              END-IF                                              
                    MOVE '5011'                TO ACTIVE-PARAGRAPH      
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE 'CSR02322'            TO TABLE-1               
                    MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1       
                    MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       5011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02878******************************************************************        
A02878** VALIDATE & PROCESS  RESULT SET DATA OF CSR02322              **        
A02878******************************************************************        
A02878*                                                                         
A02878 5025-PROCESS-CSR02322-DATA.                                      
A02878*                                                                         
A02878     IF (S-REVENUE-MONTH     > SPACES)            AND             
A02878        (S-REVENUE-MONTH NOT = WS-REVENUE-MONTH)                  
A02878        MOVE S-REVENUE-MONTH       TO WS-REVENUE-MONTH            
A02878        IF S-CUSTOMER-NO = AT-CUSTOMER-NO                         
A02878           ADD +1                  TO S-MTHS-ACCT-USAGE           
A02878        ELSE                                                      
A02878**IF CUSTOMER HAS ENOUGH SUMMER/WINTER USAGE FOR ELEC/GAS THEN            
A02878**USE ACCT'S USAGE FOR ALL CALC. ONCE THIS CONDITION IS MET, STOP         
A02878**FURTHER PROCESSING OF CSR02322 RESULT SET                               
A02878           IF (WS-ACCT-WNT-SUM-USE-ELEC >= 6)   OR                
A02878              (WS-ACCT-WNT-SUM-USE-GAS  >= 6)                     
A02878              SET NO-MORE-DATA     TO TRUE                        
A02878              MOVE 0               TO WS-ACTIVE-RETURN-CODE       
A02878                                      S-RETURN-CODE-4             
A02878              GO TO 5025-EXIT                                     
A02878           ELSE                                                   
A02878              ADD +1               TO S-MTHS-PREM-USAGE           
A02878           END-IF                                                 
A02878        END-IF                                                    
A02878     END-IF.                                                      
A02878*                                                                         
A02878     EVALUATE S-CODE-UTIL-TYPE                                    
A02878         WHEN 'E'                                                 
A02878              PERFORM 8040-INSERT-GTT-R4 THRU 8040-EXIT           
A02878              ADD +1               TO WS-TOT-MTHS-USAGE-ELEC      
A02878              IF S-HTG-CLG-SW = 1                                 
A02878                 ADD +1            TO WS-WNTR-SUMR-MTHS-ELEC      
A02878                 IF S-CUSTOMER-NO = AT-CUSTOMER-NO                
A02878                    ADD +1         TO WS-ACCT-WNT-SUM-USE-ELEC    
A02878                 END-IF                                           
A02878              END-IF                                              
A02878              COMPUTE WS-ELEC-TOTAL = WS-ELEC-TOTAL + S-NEW-CHARGE
A02878         WHEN 'G'                                                 
A02878              PERFORM 8040-INSERT-GTT-R4 THRU 8040-EXIT           
A02878              ADD +1               TO WS-TOT-MTHS-USAGE-GAS       
A02878              IF S-HTG-CLG-SW = 1                                 
A02878                 ADD +1            TO WS-WNTR-SUMR-MTHS-GAS       
A02878                 IF S-CUSTOMER-NO = AT-CUSTOMER-NO                
A02878                    ADD +1         TO WS-ACCT-WNT-SUM-USE-GAS     
A02878                 END-IF                                           
A02878              END-IF                                              
A02878              COMPUTE WS-GAS-TOTAL = WS-GAS-TOTAL + S-NEW-CHARGE  
A02878         WHEN 'U'                                                 
A02878              IF S-BPP-CATEGORY = 'P'                             
A02878                 COMPUTE WS-PVTL-TOTAL = WS-PVTL-TOTAL +          
A02878                                         S-NEW-CHARGE             
P0694A                 MOVE WS-PVTL-TOTAL TO   S-PVTL-TOTAL             
A02878              END-IF                                              
A02878              IF S-BPP-CATEGORY = 'S'                             
A02878                 COMPUTE WS-SUBL-TOTAL = WS-SUBL-TOTAL +          
A02878                                         S-NEW-CHARGE             
P0694A                 MOVE WS-SUBL-TOTAL TO   S-SUBL-TOTAL             
A02878              END-IF                                              
A02878     END-EVALUATE.                                                
A02878*                                                                         
A02878 5025-EXIT.                                                       
A02878     EXIT.                                                        
A02878*                                                                         
      ******************************************************************        
      * 5900-NEXT-BILL-DATE.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00309                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 6000-VALIDATE-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD04353                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-CUR-DATE.                                             *        
      ******************************************************************        
      *                                                                         
       7000-GET-CUR-DATE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 7050-GET-ACCT-DET.                                             *        
      ******************************************************************        
      *                                                                         
       7050-GET-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COMPANY_NO                                         
                    ,CUSTOMER_NO                                        
                    ,BILL_CYCLE                                         
                    ,PREMISE_NO                                         
                    ,REV_MTH_LST_NRML                                   
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
A02878              ,CODE_BILL_FREQ                                     
P00836              ,CREDIT_GROUP                                       
                INTO                                                    
                     :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-PREMISE-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-LAST-UPDATE-TS                                 
A02878              ,:AT-CODE-BILL-FREQ                                 
P00836              ,:AT-CREDIT-GROUP                                   
                FROM                                                    
                     CSS_ACCOUNT WITH(READUNCOMMITTED)                          
A02891        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
A02891                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COMPANY_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,CODE_BILL_FREQ                                             
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*         INTO                                                            
MFA-TR*              :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*             ,:AT-CODE-BILL-FREQ                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7735'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03710 7060-GET-BN-REV-MTH.                                             
      *                                                                         
           EXEC SQL                                                     
            SELECT TOP(1) REVENUE_MONTH                                        
             INTO  :BN-REVENUE-MONTH                                    
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)           
             AND CODE_BILL_COND   = 'R'                                 
             ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30631301
MFA-TR*     SELECT REVENUE_MONTH                                        30631401
MFA-TR*      INTO  :BN-REVENUE-MONTH                                    30631501
MFA-TR*      FROM CSS_BILL_WINDOW                                       30631601
MFA-TR*      WHERE DATE_EXTRACT  >= CURRENT DATE                        30631701
MFA-TR*      AND CODE_BILL_COND   = 'R'                                 30631801
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                          
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                    30631901

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
A03710 7060-EXIT.                                                       
A03710     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-REV-MTH.                                              *        
      ******************************************************************        
      *                                                                         
       7100-GET-REV-MTH.                                                
      *                                                                         
           EXEC SQL                                                     
A02878          SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                
A02878            INTO :BN-REVENUE-MONTH                                
A02878            FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
A02878           WHERE BN.DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                   AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30631301
MFA-TR*         SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                30631401
MFA-TR*           INTO :BN-REVENUE-MONTH                                30631501
MFA-TR*           FROM CSS_BILL_WINDOW BN                               30631601
MFA-TR*          WHERE BN.DATE_EXTRACT <= CURRENT DATE                  30631701
MFA-TR*            AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                30631801
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                    30631901

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02878        AND BN-REVENUE-MONTH  > 0                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
              MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 41260000
      ******************************************************************        
      * 7500-OPEN-AR-CURSOR                                            *        
      ******************************************************************        
      *                                                                         
       7500-OPEN-AR-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7510-FETCH-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7510-FETCH-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH                                                     
                     AR_CURSOR                                          
              INTO                                                      
                    :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:L5-AR-TYPE-LONG-DESC                               
                   ,:AC-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA     TO TRUE                        
                    MOVE 0               TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7510'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSS_AR_CNTL'   TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2       
                    MOVE 'ITEM_ID'       TO TABLE-ELEMENT-3             
                    MOVE AC-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2     
                    MOVE AC-ITEM-ID      TO HOSTVAR-ELEMENT-3           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7520-CLOSE-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7520-CLOSE-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7520'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-GET-DELINQ-VALUE                                          *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-DELINQ.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     DELINQ_VALUE                                       
                INTO                                                    
                     :C8-DELINQ-VALUE                                   
                FROM                                                    
                     CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                 AND C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              DELINQ_VALUE                                               
MFA-TR*         INTO                                                            
MFA-TR*              :C8-DELINQ-VALUE                                           
MFA-TR*         FROM                                                            
MFA-TR*              CSS_DELINQUENCY  C8                                        
MFA-TR*        WHERE                                                            
MFA-TR*              C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*          AND C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'COMPANY_NO '         TO TABLE-ELEMENT-1             
              MOVE 'DELINQ_CD '          TO TABLE-ELEMENT-2             
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-PJS-AMT.                                              *        
      ******************************************************************        
      *                                                                         
       7700-GET-PJS-AMT.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       COALESCE(MONTHLY_BILL_AM,0)                      
                  INTO                                                  
                       :PJ-MONTHLY-BILL-AM                              
                  FROM                                                  
                       CSS_PROJ_SHARE WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       ACCOUNT_NO        = :PJ-ACCOUNT-NO               
                   AND PYMT_PRIORITY_LVL = 129                          
                   AND ITEM_ID           = 1                            
                   AND SHARE_STATUS_CD   = 'A'                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     38870000
MFA-TR*         SELECT                                                  38880000
MFA-TR*                COALESCE(MONTHLY_BILL_AM,0)                      38900000
MFA-TR*           INTO                                                  38910000
MFA-TR*                :PJ-MONTHLY-BILL-AM                              38930000
MFA-TR*           FROM                                                  38940000
MFA-TR*                CSS_PROJ_SHARE                                   38940000
MFA-TR*          WHERE                                                  38950000
MFA-TR*                ACCOUNT_NO        = :PJ-ACCOUNT-NO               38950000
MFA-TR*            AND PYMT_PRIORITY_LVL = 129                          38960000
MFA-TR*            AND ITEM_ID           = 1                            38970000
MFA-TR*            AND SHARE_STATUS_CD   = 'A'                          38970000
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                    38980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 38990000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 38990000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
                 MOVE 0.0                TO PJ-MONTHLY-BILL-AM          
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROJ_SHARE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PJ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38990000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7810-GET-DEP-REQ.                                              *        
      ******************************************************************        
      *                                                                         
       7810-GET-DEP-REQ.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       DR.AMT_MO_PYMT                                   
                      ,DR.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DR-AMT-MO-PYMT                                  
                      ,:DR-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DEP_REQ DR WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            
                   AND DR.PYMT_PRIORITY_LVL = 80                        
                   AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                DR.AMT_MO_PYMT                                           
MFA-TR*               ,DR.NO_SCHED_PYMTS                                        
MFA-TR*           INTO                                                          
MFA-TR*                :DR-AMT-MO-PYMT                                          
MFA-TR*               ,:DR-NO-SCHED-PYMTS                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_DEP_REQ DR                                           
MFA-TR*          WHERE                                                          
MFA-TR*                DR.ACCOUNT_NO        = :DR-ACCOUNT-NO                    
MFA-TR*            AND DR.PYMT_PRIORITY_LVL = 80                        38960000
MFA-TR*            AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7810'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DR-DEP-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7820-GET-DEP-REQ.                                              *        
      ******************************************************************        
      *                                                                         
       7820-GET-DFA-DET.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       DA.AMT_MO_PYMT                                   
                      ,DA.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DA-AMT-MO-PYMT                                  
                      ,:DA-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                       DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                   AND DA.PYMT_PRIORITY_LVL = 90                        
                   AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                DA.AMT_MO_PYMT                                           
MFA-TR*               ,DA.NO_SCHED_PYMTS                                        
MFA-TR*           INTO                                                          
MFA-TR*                :DA-AMT-MO-PYMT                                          
MFA-TR*               ,:DA-NO-SCHED-PYMTS                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_DFA_ACCT DA                                          
MFA-TR*          WHERE                                                          
MFA-TR*                DA.ACCOUNT_NO        = :DA-ACCOUNT-NO                    
MFA-TR*            AND DA.PYMT_PRIORITY_LVL = 90                        38960000
MFA-TR*            AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7820'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DFA_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7830-GET-CNT-DET.                                              *        
      ******************************************************************        
      *                                                                         
       7830-GET-CNT-DET.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       K6.CNT_NAME_DESC                                 
                      ,CT.CODE_BILL_TYPE                                
                      ,CT.AMT_MO_PYMT                                   
                      ,CT.DATE_PYMT_START                               
                      ,CT.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :K6-CNT-NAME-DESC                                
                      ,:CT-CODE-BILL-TYPE                               
                      ,:CT-AMT-MO-PYMT                                  
                      ,:CT-DATE-PYMT-START                              
                      ,:CT-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_CONTRACT    CT WITH(READUNCOMMITTED)                 
                      ,CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            
                   AND CT.PYMT_PRIORITY_LVL = 100                       
                   AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           
                   AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            
                   AND CT.CNT_STATUS_CD     = 'B'                       
                   AND CT.CODE_BILL_TYPE    IN ('B','C')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                K6.CNT_NAME_DESC                                         
MFA-TR*               ,CT.CODE_BILL_TYPE                                        
MFA-TR*               ,CT.AMT_MO_PYMT                                           
MFA-TR*               ,CT.DATE_PYMT_START                                       
MFA-TR*               ,CT.NO_SCHED_PYMTS                                        
MFA-TR*           INTO                                                          
MFA-TR*                :K6-CNT-NAME-DESC                                        
MFA-TR*               ,:CT-CODE-BILL-TYPE                                       
MFA-TR*               ,:CT-AMT-MO-PYMT                                          
MFA-TR*               ,:CT-DATE-PYMT-START                                      
MFA-TR*               ,:CT-NO-SCHED-PYMTS                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_CONTRACT    CT                                       
MFA-TR*               ,CSS_CONTRACT_INFO K6                                     
MFA-TR*          WHERE                                                          
MFA-TR*                CT.ACCOUNT_NO        = :CT-ACCOUNT-NO                    
MFA-TR*            AND CT.PYMT_PRIORITY_LVL = 100                       38960000
MFA-TR*            AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID                   
MFA-TR*            AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD                    
MFA-TR*            AND CT.CNT_STATUS_CD     = 'B'                               
MFA-TR*            AND CT.CODE_BILL_TYPE    IN ('B','C')                        
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-2         
              MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38990000
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00471* 7900-CHK-DPP-DROP.                                             *        
      ******************************************************************        
      *                                                                         
       7900-CHK-DPP-DROP.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        'Y'                                             
                  INTO                                                  
                       :WS-DPP-DROP-EXISTS                              
                  FROM                                                  
P00471                 CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
                 WHERE                                                  
P00471                 YP.ACCOUNT_NO           = :YP-ACCOUNT-NO         
P00471             AND YP.STATUS_CD            = 'A'                    
P00471             AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'        
P00471                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 'Y'                                                     
MFA-TR*           INTO                                                          
MFA-TR*                :WS-DPP-DROP-EXISTS                                      
MFA-TR*           FROM                                                          
MFA-TR*                CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE                                                          
MFA-TR*                YP.ACCOUNT_NO           = :YP-ACCOUNT-NO                 
MFA-TR*            AND YP.STATUS_CD            = 'A'                            
MFA-TR*            AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'                
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7900                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7900'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
P00471        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00471        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38990000
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7910-CHK-BBP-DROP.                                             *        
      ******************************************************************        
      *                                                                         
       7910-CHK-BBP-DROP.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-BBP-DROP-EXISTS                              
                  FROM                                                  
                       CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       BH.ACCOUNT_NO         = :BH-ACCOUNT-NO           
                   AND BH.CHANGE_REASON      = 'D'                      
                   AND CIS.SUBSTR3(BH.REMARKS,1,30) =                        
                       'AUTOMATICALLY DROPPED FROM EPP'                 
                   AND CAST(BH.LAST_UPDATE_TS AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-BBP-DPP-CUTOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-BBP-DPP-CUTOFF-DT
              ) <> 0) OR (LEN(:WS-BBP-DPP-CUTOFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-BBP-DPP-CUTOFF-DT
              ), CONVERT(DATE, :WS-BBP-DPP-CUTOFF-DT) ) 
A02891                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-BBP-DROP-EXISTS                                      
MFA-TR*           FROM                                                          
MFA-TR*                CSS_BUDGET_HIST BH                                       
MFA-TR*          WHERE                                                          
MFA-TR*                BH.ACCOUNT_NO         = :BH-ACCOUNT-NO                   
MFA-TR*            AND BH.CHANGE_REASON      = 'D'                              
MFA-TR*            AND SUBSTR(BH.REMARKS,1,30) =                                
MFA-TR*                'AUTOMATICALLY DROPPED FROM EPP'                         
MFA-TR*            AND DATE(BH.LAST_UPDATE_TS) >= :WS-BBP-DPP-CUTOFF-DT         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7910'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7920-CHK-UTL-ARRS.                                             *        
      ******************************************************************        
      *                                                                         
       7920-CHK-UTL-ARRS.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-UTL-ARRS-EXISTS                              
                  FROM                                                  
                       CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       AC.ACCOUNT_NO         = :AC-ACCOUNT-NO           
                   AND AC.PYMT_PRIORITY_LVL  IN (40,45)                 
                   AND (AC.AMT_AR_DAY_60      > 0 OR                    
                        AC.AMT_AR_DAY_90      > 0)                      
A02891                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-UTL-ARRS-EXISTS                                      
MFA-TR*           FROM                                                          
MFA-TR*                CSS_AR_CNTL AC                                           
MFA-TR*          WHERE                                                          
MFA-TR*                AC.ACCOUNT_NO         = :AC-ACCOUNT-NO                   
MFA-TR*            AND AC.PYMT_PRIORITY_LVL  IN (40,45)                         
MFA-TR*            AND (AC.AMT_AR_DAY_60      > 0 OR                            
MFA-TR*                 AC.AMT_AR_DAY_90      > 0)                              
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*        QUERYNO 7920                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7920'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000C-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000C-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000D-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000D-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000E-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000E-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000F-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000F-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04620_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04620_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000F'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04620_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000F-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,BUS_RULE_TYPE                                       
                   ,BUS_RULE_RESULT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-BUS-RULE-TYPE                                    
                   ,:S-BUS-RULE-RESULT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,BUS_RULE_TYPE                                               
MFA-TR*            ,BUS_RULE_RESULT                                             
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-BUS-RULE-TYPE                                            
MFA-TR*            ,:S-BUS-RULE-RESULT                                          
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-RULES               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
      *                                                                         
       8020-INSERT-GTT-R2.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,OPTION_SEQ_NO                                       
                   ,OPTION_DESC                                         
                   ,UTILITY_BALANCE                                     
                   ,UTILITY_ARREARS                                     
                   ,AMT_MO_PYMT                                         
                   ,AMT_ELEC_MO_PYMT                                    
                   ,AMT_GAS_MO_PYMT                                     
                   ,AMT_UNMTRD_MO_PYMT                                  
                   ,AMT_OTHER_PYMTS                                     
                   ,AMT_ROLLOVR                                         
                   ,OPTN_PLS_PAY_AMT                                    
                   ,START_DATE                                          
                   ,MTHS_ACCT_USAGE                                     
                   ,MTHS_PREM_USAGE                                     
                   ,BBP_BILL_FLAG                                       
                   ,BBP_EST_AMT                                         
                   ,LAST_UPDATE_TS                                      
                   ,REMARKS_TEXT                                        
                   ,REMARKS_LENGTH                                      
P0694A             ,PVTL_TOTAL                                          
P0694A             ,SUBL_TOTAL                                          
P0694A             ,NONBBP_ELIG_AMT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-OPTION-SEQ-NO                                    
                   ,:S-OPTION-DESC                                      
                   ,:S-UTILITY-BALANCE                                  
                   ,:S-UTILITY-ARREARS                                  
                   ,:S-AMT-MO-PYMT                                      
                   ,:S-AMT-ELEC-MO-PYMT                                 
                   ,:S-AMT-GAS-MO-PYMT                                  
                   ,:S-AMT-UNMTRD-MO-PYMT                               
                   ,:S-AMT-OTHER-PYMTS                                  
                   ,:S-AMT-ROLLOVR                                      
                   ,:S-OPTN-PLS-PAY-AMT                                 
                   ,:S-START-DATE                                       
                   ,:S-MTHS-ACCT-USAGE                                  
                   ,:S-MTHS-PREM-USAGE                                  
                   ,:S-BBP-BILL-FLAG                                    
                   ,:S-BBP-EST-AMT                                      
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-REMARKS-TEXT                                     
                   ,:S-REMARKS-LENGTH                                   
P0694A             ,:S-PVTL-TOTAL                                       
P0694A             ,:S-SUBL-TOTAL                                       
P0694A             ,:S-NONBBP-ELIG-AMT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R2                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,OPTION_SEQ_NO                                               
MFA-TR*            ,OPTION_DESC                                                 
MFA-TR*            ,UTILITY_BALANCE                                             
MFA-TR*            ,UTILITY_ARREARS                                             
MFA-TR*            ,AMT_MO_PYMT                                                 
MFA-TR*            ,AMT_ELEC_MO_PYMT                                            
MFA-TR*            ,AMT_GAS_MO_PYMT                                             
MFA-TR*            ,AMT_UNMTRD_MO_PYMT                                          
MFA-TR*            ,AMT_OTHER_PYMTS                                             
MFA-TR*            ,AMT_ROLLOVR                                                 
MFA-TR*            ,OPTN_PLS_PAY_AMT                                            
MFA-TR*            ,START_DATE                                                  
MFA-TR*            ,MTHS_ACCT_USAGE                                             
MFA-TR*            ,MTHS_PREM_USAGE                                             
MFA-TR*            ,BBP_BILL_FLAG                                               
MFA-TR*            ,BBP_EST_AMT                                                 
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,REMARKS_TEXT                                                
MFA-TR*            ,REMARKS_LENGTH                                              
MFA-TR*            ,PVTL_TOTAL                                                  
MFA-TR*            ,SUBL_TOTAL                                                  
MFA-TR*            ,NONBBP_ELIG_AMT                                             
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-OPTION-SEQ-NO                                            
MFA-TR*            ,:S-OPTION-DESC                                              
MFA-TR*            ,:S-UTILITY-BALANCE                                          
MFA-TR*            ,:S-UTILITY-ARREARS                                          
MFA-TR*            ,:S-AMT-MO-PYMT                                              
MFA-TR*            ,:S-AMT-ELEC-MO-PYMT                                         
MFA-TR*            ,:S-AMT-GAS-MO-PYMT                                          
MFA-TR*            ,:S-AMT-UNMTRD-MO-PYMT                                       
MFA-TR*            ,:S-AMT-OTHER-PYMTS                                          
MFA-TR*            ,:S-AMT-ROLLOVR                                              
MFA-TR*            ,:S-OPTN-PLS-PAY-AMT                                         
MFA-TR*            ,:S-START-DATE                                               
MFA-TR*            ,:S-MTHS-ACCT-USAGE                                          
MFA-TR*            ,:S-MTHS-PREM-USAGE                                          
MFA-TR*            ,:S-BBP-BILL-FLAG                                            
MFA-TR*            ,:S-BBP-EST-AMT                                              
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-REMARKS-TEXT                                             
MFA-TR*            ,:S-REMARKS-LENGTH                                           
MFA-TR*            ,:S-PVTL-TOTAL                                               
MFA-TR*            ,:S-SUBL-TOTAL                                               
MFA-TR*            ,:S-NONBBP-ELIG-AMT                                          
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-OPTIONS             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
      *                                                                         
       8030-INSERT-GTT-R3.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R3                          
                  (                                                     
                    RETURN_CODE                                         
                   ,CNT_NAME_DESC                                       
                   ,CNT_AMT_MO_PYMT                                     
                   ,CNT_PYMTS_REMAIN                                    
                   ,CNT_EXPIRY_DT                                       
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-3                                    
                   ,:S-CNT-NAME-DESC                                    
                   ,:S-CNT-AMT-MO-PYMT                                  
                   ,:S-CNT-PYMTS-REMAIN                                 
                   ,:S-CNT-EXPIRY-DT                                    
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R3                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,CNT_NAME_DESC                                               
MFA-TR*            ,CNT_AMT_MO_PYMT                                             
MFA-TR*            ,CNT_PYMTS_REMAIN                                            
MFA-TR*            ,CNT_EXPIRY_DT                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-3                                            
MFA-TR*            ,:S-CNT-NAME-DESC                                            
MFA-TR*            ,:S-CNT-AMT-MO-PYMT                                          
MFA-TR*            ,:S-CNT-PYMTS-REMAIN                                         
MFA-TR*            ,:S-CNT-EXPIRY-DT                                            
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-MTHLY-CHRGS             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8040-INSERT-GTT-R4.                                            *        
      ******************************************************************        
      *                                                                         
       8040-INSERT-GTT-R4.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R4                          
                  (                                                     
                    RETURN_CODE                                         
                   ,REVENUE_MONTH                                       
                   ,DAYS                                                
                   ,UNITS                                               
                   ,CODE_UTIL_TYPE                                      
                   ,CUSTOMER_NO                                         
                   ,NEW_CHARGE                                          
                   ,RATE_PLAN_NO                                        
                   ,CALC_ERROR                                          
                   ,HTG_CLG_SW                                          
                   ,EPP_CATEGORY                                        
P0694A             ,ELEC_BUFFER                                         
P0694A             ,GAS_BUFFER                                          
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-4                                    
                   ,:S-REVENUE-MONTH                                    
                   ,:S-DAYS                                             
                   ,:S-UNITS                                            
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-CUSTOMER-NO                                      
                   ,:S-NEW-CHARGE                                       
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-CALC-ERROR                                       
                   ,:S-HTG-CLG-SW                                       
                   ,:S-BPP-CATEGORY                                     
P0694A             ,:S-ELEC-BUFFER                                      
P0694A             ,:S-GAS-BUFFER                                       
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R4                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,REVENUE_MONTH                                               
MFA-TR*            ,DAYS                                                        
MFA-TR*            ,UNITS                                                       
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,NEW_CHARGE                                                  
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,CALC_ERROR                                                  
MFA-TR*            ,HTG_CLG_SW                                                  
MFA-TR*            ,EPP_CATEGORY                                                
MFA-TR*            ,ELEC_BUFFER                                                 
MFA-TR*            ,GAS_BUFFER                                                  
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-4                                            
MFA-TR*            ,:S-REVENUE-MONTH                                            
MFA-TR*            ,:S-DAYS                                                     
MFA-TR*            ,:S-UNITS                                                    
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-CUSTOMER-NO                                              
MFA-TR*            ,:S-NEW-CHARGE                                               
MFA-TR*            ,:S-RATE-PLAN-NO                                             
MFA-TR*            ,:S-CALC-ERROR                                               
MFA-TR*            ,:S-HTG-CLG-SW                                               
MFA-TR*            ,:S-BPP-CATEGORY                                             
MFA-TR*            ,:S-ELEC-BUFFER                                              
MFA-TR*            ,:S-GAS-BUFFER                                               
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-USAGE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8040-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8050-INSERT-GTT-R5.                                            *        
      ******************************************************************        
      *                                                                         
       8050-INSERT-GTT-R5.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R5                          
                  (                                                     
                    RETURN_CODE                                         
                   ,OPTION_SEQ_NO                                       
                   ,AR_TYPE_DESC                                        
                   ,PLS_PAY_DET_AMT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-5                                    
                   ,:S-OPTN-SEQ-NO-5                                    
                   ,:S-AR-TYPE-DESC                                     
                   ,:S-PLS-PAY-DET-AMT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R5                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,OPTION_SEQ_NO                                               
MFA-TR*            ,AR_TYPE_DESC                                                
MFA-TR*            ,PLS_PAY_DET_AMT                                             
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-5                                            
MFA-TR*            ,:S-OPTN-SEQ-NO-5                                            
MFA-TR*            ,:S-AR-TYPE-DESC                                             
MFA-TR*            ,:S-PLS-PAY-DET-AMT                                          
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-PLS-PAY             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8050-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8060-INSERT-GTT-R6.                                            *        
      ******************************************************************        
      *                                                                         
       8060-INSERT-GTT-R6.                                              
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04620_R6                          
                  (                                                     
                    RETURN_CODE                                         
                   ,BBP_ELIGIBLE                                        
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-6                                    
                   ,:S-BBP-ELIGIBLE                                     
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04620_R6                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,BBP_ELIGIBLE                                                
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-6                                            
MFA-TR*            ,:S-BBP-ELIGIBLE                                             
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-ELIG                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8060'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04620_R6'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8060-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF WS-BBP-RULES   = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-BBP-OPTIONS = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-MTHLY-CHRGS = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                      TO S-RETURN-CODE-3          
              PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-BBP-USAGE   = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                      TO S-RETURN-CODE-4          
              PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-BBP-PLS-PAY = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                      TO S-RETURN-CODE-5          
              PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00721******************************************************************        
P00721* 8810-CHECK-RESULTS.                                            *        
P00721******************************************************************        
P00721*                                                                         
P00721 8810-CHECK-RESULTS.                                              
P00721*                                                                         
P00721     IF WS-BBP-ELIG = 0                                           
P00721        INITIALIZE GTT-RETURN-FIELDS-6                            
P00721        MOVE 100                      TO S-RETURN-CODE-6          
P00721        PERFORM 8060-INSERT-GTT-R6    THRU 8060-EXIT              
P00721     END-IF.                                                      
      *                                                                         
P00721 8810-EXIT.                                                       
P00721     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04620_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 00300000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 00300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04620_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 00300000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 00300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04620_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 00300000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 00300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04620_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 00300000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 00300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04620_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00721******************************************************************        
P00721* 8910-SEND-DONE.                                                *        
P00721******************************************************************        
P00721*                                                                         
P00721 8910-SEND-DONE.                                                  
P00721*                                                                         
P00721     EXEC SQL                                                     
P00721         OPEN C6                                                  
P00721     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00721*                                                                 00300000
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-6.            
P00721*                                                                 00300000
P00721     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00721        NEXT SENTENCE                                             
P00721     ELSE                                                         
P00721        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00721        MOVE SQLCODE               TO ABEND-SQLCODE               
P00721        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00721        MOVE '8910'                TO ACTIVE-PARAGRAPH            
P00721        MOVE 'OPEN'                TO ABEND-FUNCTION              
P00721        MOVE 'CSR04620_R6'         TO TABLE-1                     
P00721        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00721     END-IF.                                                      
P00721*                                                                 00300000
P00721*                                                                         
P00721 8910-EXIT.                                                       
P00721     EXIT.                                                        
P00721*                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-RULES                                            
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-OPTIONS                                          
                    MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-OTHR-PYMTS                                       
                    MOVE S-RETURN-CODE-3 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-USAGE                                            
                    MOVE S-RETURN-CODE-4 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-PLS-PAY-AMT                                      
                    MOVE S-RETURN-CODE-5 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-2         TO S-RETURN-CODE-2.            
           MOVE WS-RETURN-CODE-3         TO S-RETURN-CODE-3.            
           MOVE WS-RETURN-CODE-4         TO S-RETURN-CODE-4.            
           MOVE WS-RETURN-CODE-5         TO S-RETURN-CODE-5.            
      *                                                                 00339704
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
           PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT.                
           PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT.                
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9100-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-6                     
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT.               
      *                                                                         
           MOVE WS-RETURN-CODE-6         TO S-RETURN-CODE-6.            
      *                                                                 00339704
           PERFORM 8060-INSERT-GTT-R6    THRU 8060-EXIT.                
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           IF PARM-ELIGIBLE =SPACES                                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
           ELSE                                                         
              PERFORM 9100-SEND-ERROR-RESULT THRU 9100-EXIT             
           END-IF.                                                      
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           PERFORM 9975-ABEND-CONTROL-TRANSFER THRU 9975-EXIT.          
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9975-ABEND-CONTROL-TRANSFER.                                     

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
      *                                                                         
           EXEC SQL                                                     
      *                                                                         
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
P00721     IF PARM-ELIGIBLE = SPACES                                    
P00721        PERFORM 8900-SEND-DONE              THRU 8900-EXIT        
P00721     ELSE                                                         
P00721        PERFORM 8910-SEND-DONE              THRU 8910-EXIT        
P00721     EXIT
           END-IF.                                                        
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9975-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                      *                
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                 00380000
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
P00721        IF PARM-ELIGIBLE = SPACES                                 
P00721           PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT              
P00721           PERFORM 8900-SEND-DONE     THRU 8900-EXIT              
P00721        ELSE                                                      
P00721           PERFORM 8810-CHECK-RESULTS THRU 8810-EXIT              
P00721           PERFORM 8910-SEND-DONE     THRU 8910-EXIT
              END-IF
           END-IF.             
      *                                                                 00391000
           
MSQ016        GOBACK.                                                    
      *                                                                 00391000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      **********************End Of Program *****************************        
      *                                                                *        
