       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04618.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. MAR 20, 2013.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04618                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** CREDIT SCORING PROJECT: THIS PROGRAM RETRIEVES DATA FOR     **         
      ** "CREDIT WORTHINESS & IDENTITY VERIFICATION" SCREEN.         **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   CALL_TYPE              CHAR(03)                           **         
      **   CUSTOMER_NO            CHAR(10)                           **         
      **   USER_ID                CHAR(07)                           **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET:CREDIT SCORE SUMMARY DETAILS                      **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
P00704** 03/20/13    GD43988      NEW PROGRAM.                       **         
P00704** 06/05/13    MJ13662      IF ITPA AND RESOLVED, SEND 'G' IN  **         
P00704**                          HISTORY-RULE-CODE; IF ITPA AND NOT **         
P00704**                          RESOLVED, SEND 'I' IN HISTORY-RULE **         
P00704**                          CODE AND 'R' IN RESULTS-RULE-CODE. **         
P00704**                          IF NO UNRESOLVED ITPA EXISTS,      **         
P00704**                          IF APPLICATION-STATUS = DENY AND   **         
P00704**                          APPLICATION-RESPONSE-CD = 'C' SEND **         
P00704**                          'Y' IN RESULTS-RULE-CODE.          **         
P00704**                          IF NO UNRESOLVED ITPA EXISTS,      **         
P00704**                          IF APPLICATION-STATUS = DENY AND   **         
P00704**                          APPLICATION-RESPONSE-CD NOT = 'C'  **         
P00704**                          'R' IN RESULTS-RULE-CODE.          **         
P00704**                          INCREASED VENDOR-COMMENTS TO 210.  **         
P00757** 06/27/13    SV95326      POPULATE CUSTOMER DATA IN RESULT   **         
P00757**                          SET EVEN THEY DONT HAVE CREDIT     **         
P00757**                          HISTORY.                           **         
P00757** 07/12/13    GD43988      REMOVED CUSTOMER RELATED COLUMNS   **         
P00773** 09/16/13    MJ13662      SEND ACTION-MSG-TX AND RESP-SCRIPT-**         
P00773**                          TXT IN RESULT SET REGARDLESS OF    **         
P00773**                          APPLICATION-STATUS IF CK-CR-RQST-  **         
P00773**                          REASON-CD = 'R' (ACCOUNT REVIEW).  **         
I01701** 7/11/14     MJ13662                                         **         
I01701** D (UTILITY) NEEDS TO DISPLAY DIFFERENT RESULT/RESP BASED ON **         
I01701** CREDIT SCORE OR VERITY.                                     **         
I01701** H (HVAC) OR M (MERCHANDISE) HAS SAME VERBIAGE.              **         
ACT169** 9/2/15      MJ13662  APPL 5136 SELECT RESULT AND RESPONSE   **         
ACT169**                      BASED ON DATE OF CREDIT SCORE.         **         
A05198** 11/4/15     MJ13662  CHECK CK-SCORE-MODEL-CD ON             **         
A05198**                      CSS_CREDIT_HIST TO DETERMINE WHICH SCORE*         
A05198**                      TO RETURN TO VIEW.                     **         
A05198**                      INCLUDE SCORE-MODEL-CD IN CALL TO      **         
A05198**                      CSS_DEP_REQUIREMNT.                    **         
A05460** 10/14/16    MJ13662  K (DHR UTILITY) NEEDS TO ALSO DISPLAY  **         
A05460**                      RESULT/RESP BASED ON CREDIT SCORE OF   **         
A05460**                      POSID/VERIFY.                                     
A05460*  11/14/16    MJ13662  CREDIT SCORE HISTORY FOR PRE-PAY RESULT**         
A05460*                       AND RESPONSE SHOULD NOT MENTION DEPOSIT.*         
A05460*                       ONLY USE VERBIAGE ON CSS_DEP_REQUIREMNT.*         
A05460*                       ACT331                                            
***********************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04618'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
           EXEC SQL                                                     02320800
              INCLUDE TBDELQ                                            02320900
           END-EXEC.                                                    02321000
      *                                                                 02321000
      **** CSS_CATEGORY, F5                                                     
           EXEC SQL                                                     02320800
              INCLUDE TBCAT                                             02320900
           END-EXEC.                                                    02321000
      *                                                                 02321000
      **** CSS_CUSTOMER, CU                                                     
           EXEC SQL                                                     02320800
              INCLUDE TBCUST                                            02320900
           END-EXEC.                                                    02321000
      *                                                                 02321000
      **** CSS_CREDIT_HIST, CK                                                  
           EXEC SQL                                                     01730000
              INCLUDE TBCRHIST                                          01740000
           END-EXEC.                                                    01750000
      *                                                                 01760000
      **** CSS_CRED_ITPA_HIST, LF                                               
           EXEC SQL                                                     01730000
              INCLUDE TBCRITPA                                          01740000
           END-EXEC.                                                    01750000
      *                                                                 01760000
      **** CSS_USER_PROFILE, PF                                                 
           EXEC SQL                                                     01870200
              INCLUDE TBUSRPRF                                          01870300
           END-EXEC.                                                    01870400
      *                                                                         
      **** CSS_CRED_BUR_MATRX, DG                                               
           EXEC SQL                                                     01870200
              INCLUDE TBCRBUMX                                          01870300
           END-EXEC.                                                    01870400
      *                                                                         
      **** CSS_APPL_RESPONSE, KE                                                
           EXEC SQL                                                     01870200
              INCLUDE TBAPSRES                                          01870300
           END-EXEC.                                                    01870400
      *                                                                 01870500
      **** CSS_CRED_CODE_DESC, KL                                               
           EXEC SQL                                                     01870200
              INCLUDE TBCREDCD                                          01870300
           END-EXEC.                                                    01870400
      *                                                                         
      **** CSS_DEP_REQUIREMNT, D6                                               
           EXEC SQL                                                     02320800
              INCLUDE TBDEPRQ                                           02320900
           END-EXEC.                                                    02321000
      *                                                                 01870500
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04618'.      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CALL-TYPE          PIC X(03).                       
           05  PARM-CUSTOMER-NO        PIC X(10).                       
           05  PARM-CUSTOMER-NO-NUM   REDEFINES                         
               PARM-CUSTOMER-NO        PIC 9(10).                       
           05  PARM-USER-ID            PIC X(07).                       
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE +0.      
P00757     05  S-APPL-STATUS-CODE        PIC S9(09) COMP VALUE +0.      
           05  S-CR-HIST-TRAN-DT         PIC X(10).                     
           05  S-CR-HIST-TRAN-TM         PIC X(08).                     
           05  S-CR-HIST-TRAN-DT-TM-FMT  PIC X(19).                     
           05  S-APPL-RESULT-CD-DESC     PIC X(100).                    
           05  S-ACTION-MSG-TX           PIC X(25).                     
           05  S-APPL-RESPONSE-TEXT      PIC X(600).                    
           05  S-RESP-SCRIPT-TXT         PIC X(250).                    
           05  S-USER-ID-CR-INIT-BY      PIC X(07).                     
           05  S-FIRST-NAME-CR-INIT-BY   PIC X(12).                     
           05  S-LAST-NAME-CR-INIT-BY    PIC X(15).                     
           05  S-MIDDLE-NAME-CR-INIT-BY  PIC X(10).                     
           05  S-CR-RQST-REASON-CD       PIC X(01).                     
           05  S-CR-BUREAU-CD            PIC X(01).                     
           05  S-CR-COMMENTS             PIC X(210).                    
           05  S-VENDOR-COMMENTS         PIC X(210).                    
           05  S-REG-GROUP-CD            PIC X(03).                     
           05  S-CR-CHK-COMPANY-NO       PIC X(02).                     
           05  S-DIVISION                PIC X(05).                     
           05  S-CR-SCORE-UPDATE-FL      PIC X(01).                     
           05  S-CR-SCORE-CD             PIC X(05).                     
           05  S-CR-SCORE-TYPE-CD        PIC X(02).                     
           05  S-CREDIT-SOURCE-CD        PIC X(01).                     
           05  S-BEACON-SCORE            PIC X(05).                     
           05  S-APPL-STATUS-CD          PIC X(01).                     
           05  S-CR-ACTION-FL            PIC X(01).                     
           05  S-SPECIAL-OFFER-CD        PIC X(01).                     
           05  S-SSN                     PIC X(11).                     
           05  S-SSN-MASK-FLAG           PIC X(01).                     
           05  S-DATE-OF-BIRTH           PIC X(10).                     
           05  S-DRIVERS-LICENSE-NO      PIC X(20).                     
           05  S-DRIVERS-LIC-ST-CD       PIC X(02).                     
           05  S-ITPA-EXISTS-CD          PIC X(01).                     
           05  S-HISTORY-RULE-CD         PIC X(01).                     
           05  S-RESULTS-RULE-CD         PIC X(01).                     
           05  S-SENIOR-FL               PIC X(01).                     
           05  S-CB-BEACON-REJ-CD        PIC X(05).                     
           05  S-CB-BEACON-REJ-TYPE-CD   PIC X(02).                     
           05  S-CB-SAFESCAN-CD          PIC X(05).                     
           05  S-CB-SAFESCAN-TYPE-CD     PIC X(02).                     
           05  S-CB-MATCH-CD             PIC X(05).                     
           05  S-CB-MATCH-TYPE-CD        PIC X(02).                     
           05  S-CB-HIT-CD               PIC X(05).                     
           05  S-CB-HIT-TYPE-CD          PIC X(02).                     
           05  S-CB-ERROR-CD             PIC X(05).                     
           05  S-CB-ERROR-TYPE-CD        PIC X(02).                     
           05  S-ADV-CREDIT-LTR-FL       PIC X(01).                     
           05  S-ADV-CREDIT-LTR-DT       PIC X(10).                     
           05  S-ITPA-RSLT-CURR-CD       PIC X(01).                     
           05  S-LETTER-NOTIFY-CD        PIC X(01).                     
           05  S-LETTER-MAILED-DT        PIC X(10).                     
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88  SEND-DONE-ERROR                    VALUE 'N'.        
               88  SEND-DONE-OK                       VALUE 'Y'.        
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-NULL-1               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-2               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-3               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-4               PIC S9(04) COMP VALUE +0.   
           05  WS-ITPA-RSLT-CURR-NULL       PIC S9(04) COMP VALUE +0.   
           05  WS-LETTER-NOTIFY-NULL        PIC S9(04) COMP VALUE +0.   
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-MASK-SSN-CUST-DAYS        PIC S9(04) VALUE  0.        
           05  WS-MASK-SSN-SCORE-HOURS      PIC S9(04) VALUE  0.        
           05  WS-NO-SCORE-HOURS            PIC S9(04) VALUE  0.        
           05  WS-USER-CAT-ACCESS-FL        PIC X(01)  VALUE SPACES.    
           05  WS-CUST-EST-NO-OF-DAYS       PIC S9(09) COMP VALUE  0.   
           05  WS-CRED-HIST-NO-OF-HOURS     PIC S9(09) COMP VALUE  0.   
           05  WS-SSN-FMT                   PIC X(11)  VALUE SPACES.    
           05  WS-SSN-FMT-AND-MASK          PIC X(11)  VALUE SPACES.    
           05  WS-SSN-MASK-FLAG             PIC X(01)  VALUE SPACES.    
           05  WS-CUST-AGE                  PIC S9(04) COMP VALUE 0.    
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** CREDIT HISTORY DETAILS USING CUSTOMER NO                             
      *                                                                         
           EXEC SQL                                                     
             DECLARE  CRED_HIST_MAIN_CUR CURSOR FOR                     
              SELECT  CK.CR_HIST_TRAN_DT                                
                     ,REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM
           , 108), ':', '.') CR_HIST_TRAN_TM                                
                     ,CK.USER_ID_CR_INIT_BY                             
                     ,CK.CR_RQST_REASON_CD                              
                     ,CK.CR_BUREAU_CD                                   
                     ,CK.CR_COMMENTS                                    
                     ,CK.VENDOR_COMMENTS                                
                     ,CK.REG_GROUP_CD                                   
                     ,CK.CR_CHK_COMPANY_NO                              
                     ,CK.CR_SCORE_UPDATE_FL                             
                     ,CK.CR_SCORE_CD                                    
                     ,CK.CREDIT_SOURCE_CD                               
                     ,CK.CR_SCORE_TYPE_CD                               
                     ,CK.BEACON_SCORE                                   
                     ,CK.APPL_STATUS_CD                                 
                     ,CK.CR_ACTION_FL                                   
                     ,CK.SPECIAL_OFFER_CD                               
                     ,CK.SSN                                            
                     ,CIS.SUBSTR3(CK.SSN,1,3) + '-' + CIS.SUBSTR3(
           CK.SSN,4,2) + '-' + CIS.SUBSTR3(CK.SSN,6,4)                         
                     ,'###-##-' + CIS.SUBSTR3(CK.SSN,6,4)                   
                     ,CK.DATE_OF_BIRTH                                  
                     ,CK.DRIVERS_LICENSE_NO                             
                     ,CK.DRIVERS_LIC_ST_CD                              
                     ,CK.ITPA_EXISTS_CD                                 
                     ,CK.SENIOR_FL                                      
                     ,CK.CB_BEACON_REJ_CD                               
                     ,CK.CB_SAFESCAN_CD                                 
                     ,CK.CB_MATCH_CD                                    
                     ,CK.CB_HIT_CD                                      
                     ,CK.CB_FORMAT_ERR_CD                               
                     ,CK.CB_PROCESS_ERR_CD                              
                     ,CK.CB_VALIDITY_ERR_CD                             
                     ,CK.ADV_CREDIT_LTR                                 
                     ,CK.ADV_CREDIT_LTR_DT                              
A05198               ,CK.SCORE_MODEL_CD                                 
A05198               ,CK.ADDL_CRED_SCORE                                
                     ,LF.ITPA_RSLT_CURR_CD                              
                     ,LF.LETTER_NOTIFY_CD                               
                     ,LF.LETTER_MAILED_DT                               
               FROM  CSS_CREDIT_HIST     CK
                           WITH(READUNCOMMITTED) LEFT JOIN                   
                     CSS_CRED_ITPA_HIST  LF WITH(READUNCOMMITTED)               
                 ON  LF.CUSTOMER_NO         =   CK.CUSTOMER_NO          
                AND  LF.CR_HIST_TRAN_DT     =   CK.CR_HIST_TRAN_DT      
                AND  LF.CR_HIST_TRAN_TM     =   CK.CR_HIST_TRAN_TM      
              WHERE  CK.CUSTOMER_NO         =  :CK-CUSTOMER-NO          
                AND  CK.CR_RQST_REASON_CD  <>  'B'                      
             ORDER BY CK.CR_HIST_TRAN_DT DESC,                          
                      CR_HIST_TRAN_TM DESC                           
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  CRED_HIST_MAIN_CUR CURSOR FOR                             
MFA-TR*       SELECT  CK.CR_HIST_TRAN_DT                                        
MFA-TR*              ,CK.CR_HIST_TRAN_TM                                        
MFA-TR*              ,CK.USER_ID_CR_INIT_BY                                     
MFA-TR*              ,CK.CR_RQST_REASON_CD                                      
MFA-TR*              ,CK.CR_BUREAU_CD                                           
MFA-TR*              ,CK.CR_COMMENTS                                            
MFA-TR*              ,CK.VENDOR_COMMENTS                                        
MFA-TR*              ,CK.REG_GROUP_CD                                           
MFA-TR*              ,CK.CR_CHK_COMPANY_NO                                      
MFA-TR*              ,CK.CR_SCORE_UPDATE_FL                                     
MFA-TR*              ,CK.CR_SCORE_CD                                            
MFA-TR*              ,CK.CREDIT_SOURCE_CD                                       
MFA-TR*              ,CK.CR_SCORE_TYPE_CD                                       
MFA-TR*              ,CK.BEACON_SCORE                                           
MFA-TR*              ,CK.APPL_STATUS_CD                                         
MFA-TR*              ,CK.CR_ACTION_FL                                           
MFA-TR*              ,CK.SPECIAL_OFFER_CD                                       
MFA-TR*              ,CK.SSN                                                    
MFA-TR*              ,SUBSTR(CK.SSN,1,3) || '-' ||                              
MFA-TR*               SUBSTR(CK.SSN,4,2) || '-' ||                              
MFA-TR*               SUBSTR(CK.SSN,6,4)                                        
MFA-TR*              ,'###-##-' || SUBSTR(CK.SSN,6,4)                           
MFA-TR*              ,CK.DATE_OF_BIRTH                                          
MFA-TR*              ,CK.DRIVERS_LICENSE_NO                                     
MFA-TR*              ,CK.DRIVERS_LIC_ST_CD                                      
MFA-TR*              ,CK.ITPA_EXISTS_CD                                         
MFA-TR*              ,CK.SENIOR_FL                                              
MFA-TR*              ,CK.CB_BEACON_REJ_CD                                       
MFA-TR*              ,CK.CB_SAFESCAN_CD                                         
MFA-TR*              ,CK.CB_MATCH_CD                                            
MFA-TR*              ,CK.CB_HIT_CD                                              
MFA-TR*              ,CK.CB_FORMAT_ERR_CD                                       
MFA-TR*              ,CK.CB_PROCESS_ERR_CD                                      
MFA-TR*              ,CK.CB_VALIDITY_ERR_CD                                     
MFA-TR*              ,CK.ADV_CREDIT_LTR                                         
MFA-TR*              ,CK.ADV_CREDIT_LTR_DT                                      
MFA-TR*              ,CK.SCORE_MODEL_CD                                         
MFA-TR*              ,CK.ADDL_CRED_SCORE                                        
MFA-TR*              ,LF.ITPA_RSLT_CURR_CD                                      
MFA-TR*              ,LF.LETTER_NOTIFY_CD                                       
MFA-TR*              ,LF.LETTER_MAILED_DT                                       
MFA-TR*        FROM  CSS_CREDIT_HIST     CK LEFT JOIN                           
MFA-TR*              CSS_CRED_ITPA_HIST  LF                                     
MFA-TR*          ON  LF.CUSTOMER_NO         =   CK.CUSTOMER_NO                  
MFA-TR*         AND  LF.CR_HIST_TRAN_DT     =   CK.CR_HIST_TRAN_DT              
MFA-TR*         AND  LF.CR_HIST_TRAN_TM     =   CK.CR_HIST_TRAN_TM              
MFA-TR*       WHERE  CK.CUSTOMER_NO         =  :CK-CUSTOMER-NO                  
MFA-TR*         AND  CK.CR_RQST_REASON_CD  <>  'B'                              
MFA-TR*      ORDER BY CK.CR_HIST_TRAN_DT DESC,                                  
MFA-TR*               CK.CR_HIST_TRAN_TM DESC                                   
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE           PIC X(03).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-USER-ID             PIC X(07).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-CUSTOMER-NO                       
                                ,LINK-USER-ID.                          
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT       THRU  2000-EXIT.           
           PERFORM 2400-VLDT-NOTFOUND-RES    THRU  2400-EXIT.           
           PERFORM 9999-END-PROGRAM          THRU  9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU  0100A-EXIT.                 
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE                               **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04618_R1'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04618_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04618_R1
              (                                                    
                     RETURN_CODE              INT                   
P00757              ,APPL_STATUS_CODE         INT                   
                    ,CR_HIST_TRAN_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_HIST_TRAN_TM CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_HIST_TRAN_DT_TM_FMT CHAR(19)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,APPL_RESULT_CD_DESC CHAR(100)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,ACTION_MSG_TX CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,APPL_RESPONSE_TEXT VARCHAR(600)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2              
                    ,RESP_SCRIPT_TXT CHAR(250)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,USER_ID_CR_INIT_BY CHAR(07)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,FIRST_NAME_CR_INIT_BY CHAR(12)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,LAST_NAME_CR_INIT_BY CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,MIDDLE_NAME_CR_INIT_BY CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_RQST_REASON_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_BUREAU_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_COMMENTS CHAR(210)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,VENDOR_COMMENTS CHAR(210)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,REG_GROUP_CD CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_CHK_COMPANY_NO CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,DIVISION CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,CR_SCORE_UPDATE_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_SCORE_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_SCORE_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CREDIT_SOURCE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,BEACON_SCORE CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,APPL_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CR_ACTION_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,SPECIAL_OFFER_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,SSN CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2              
                    ,SSN_MASK_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,DATE_OF_BIRTH CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,DRIVERS_LICENSE_NO CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,DRIVERS_LIC_ST_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ITPA_EXISTS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,HISTORY_RULE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,RESULTS_RULE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,SENIOR_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,CB_BEACON_REJ_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_BEACON_REJ_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_SAFESCAN_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_SAFESCAN_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_MATCH_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_MATCH_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_HIT_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,CB_HIT_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_ERROR_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CB_ERROR_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ADV_CREDIT_LTR_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ADV_CREDIT_LTR_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ITPA_RSLT_CURR_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,LETTER_NOTIFY_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,LETTER_MAILED_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000-DELETE-GTT-ROWS  THRU  8000-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04618_R1'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
P00757                ,APPL_STATUS_CODE                                 
                      ,CR_HIST_TRAN_DT                                  
                      ,CR_HIST_TRAN_TM                                  
                      ,CR_HIST_TRAN_DT_TM_FMT                           
                      ,APPL_RESULT_CD_DESC                              
                      ,ACTION_MSG_TX                                    
                      ,APPL_RESPONSE_TEXT                               
                      ,RESP_SCRIPT_TXT                                  
                      ,USER_ID_CR_INIT_BY                               
                      ,FIRST_NAME_CR_INIT_BY                            
                      ,LAST_NAME_CR_INIT_BY                             
                      ,MIDDLE_NAME_CR_INIT_BY                           
                      ,CR_RQST_REASON_CD                                
                      ,CR_BUREAU_CD                                     
                      ,CR_COMMENTS                                      
                      ,VENDOR_COMMENTS                                  
                      ,REG_GROUP_CD                                     
                      ,CR_CHK_COMPANY_NO                                
                      ,DIVISION                                         
                      ,CR_SCORE_UPDATE_FL                               
                      ,CR_SCORE_CD                                      
                      ,CR_SCORE_TYPE_CD                                 
                      ,CREDIT_SOURCE_CD                                 
                      ,BEACON_SCORE                                     
                      ,APPL_STATUS_CD                                   
                      ,CR_ACTION_FL                                     
                      ,SPECIAL_OFFER_CD                                 
                      ,SSN                                              
                      ,SSN_MASK_FLAG                                    
                      ,DATE_OF_BIRTH                                    
                      ,DRIVERS_LICENSE_NO                               
                      ,DRIVERS_LIC_ST_CD                                
                      ,ITPA_EXISTS_CD                                   
                      ,HISTORY_RULE_CD                                  
                      ,RESULTS_RULE_CD                                  
                      ,SENIOR_FL                                        
                      ,CB_BEACON_REJ_CD                                 
                      ,CB_BEACON_REJ_TYPE_CD                            
                      ,CB_SAFESCAN_CD                                   
                      ,CB_SAFESCAN_TYPE_CD                              
                      ,CB_MATCH_CD                                      
                      ,CB_MATCH_TYPE_CD                                 
                      ,CB_HIT_CD                                        
                      ,CB_HIT_TYPE_CD                                   
                      ,CB_ERROR_CD                                      
                      ,CB_ERROR_TYPE_CD                                 
                      ,ADV_CREDIT_LTR_FL                                
                      ,ADV_CREDIT_LTR_DT                                
                      ,ITPA_RSLT_CURR_CD                                
                      ,LETTER_NOTIFY_CD                                 
                      ,LETTER_MAILED_DT                                 
               FROM #CSR04618_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,APPL_STATUS_CODE                                         
MFA-TR*               ,CR_HIST_TRAN_DT                                          
MFA-TR*               ,CR_HIST_TRAN_TM                                          
MFA-TR*               ,CR_HIST_TRAN_DT_TM_FMT                                   
MFA-TR*               ,APPL_RESULT_CD_DESC                                      
MFA-TR*               ,ACTION_MSG_TX                                            
MFA-TR*               ,APPL_RESPONSE_TEXT                                       
MFA-TR*               ,RESP_SCRIPT_TXT                                          
MFA-TR*               ,USER_ID_CR_INIT_BY                               ULL,    
MFA-TR*               ,FIRST_NAME_CR_INIT_BY                            ULL,    
MFA-TR*               ,LAST_NAME_CR_INIT_BY                                     
MFA-TR*               ,MIDDLE_NAME_CR_INIT_BY                                   
MFA-TR*               ,CR_RQST_REASON_CD                                        
MFA-TR*               ,CR_BUREAU_CD                                             
MFA-TR*               ,CR_COMMENTS                                              
MFA-TR*               ,VENDOR_COMMENTS                                          
MFA-TR*               ,REG_GROUP_CD                                             
MFA-TR*               ,CR_CHK_COMPANY_NO                                        
MFA-TR*               ,DIVISION                                                 
MFA-TR*               ,CR_SCORE_UPDATE_FL                                       
MFA-TR*               ,CR_SCORE_CD                                              
MFA-TR*               ,CR_SCORE_TYPE_CD                                         
MFA-TR*               ,CREDIT_SOURCE_CD                                         
MFA-TR*               ,BEACON_SCORE                                             
MFA-TR*               ,APPL_STATUS_CD                                           
MFA-TR*               ,CR_ACTION_FL                                             
MFA-TR*               ,SPECIAL_OFFER_CD                                         
MFA-TR*               ,SSN                                                      
MFA-TR*               ,SSN_MASK_FLAG                                            
MFA-TR*               ,DATE_OF_BIRTH                                            
MFA-TR*               ,DRIVERS_LICENSE_NO                                       
MFA-TR*               ,DRIVERS_LIC_ST_CD                                        
MFA-TR*               ,ITPA_EXISTS_CD                                           
MFA-TR*               ,HISTORY_RULE_CD                                          
MFA-TR*               ,RESULTS_RULE_CD                                          
MFA-TR*               ,SENIOR_FL                                                
MFA-TR*               ,CB_BEACON_REJ_CD                                         
MFA-TR*               ,CB_BEACON_REJ_TYPE_CD                                    
MFA-TR*               ,CB_SAFESCAN_CD                                           
MFA-TR*               ,CB_SAFESCAN_TYPE_CD                                      
MFA-TR*               ,CB_MATCH_CD                                              
MFA-TR*               ,CB_MATCH_TYPE_CD                                         
MFA-TR*               ,CB_HIT_CD                                                
MFA-TR*               ,CB_HIT_TYPE_CD                                           
MFA-TR*               ,CB_ERROR_CD                                              
MFA-TR*               ,CB_ERROR_TYPE_CD                                         
MFA-TR*               ,ADV_CREDIT_LTR_FL                                        
MFA-TR*               ,ADV_CREDIT_LTR_DT                                        
MFA-TR*               ,ITPA_RSLT_CURR_CD                                        
MFA-TR*               ,LETTER_NOTIFY_CD                                         
MFA-TR*               ,LETTER_MAILED_DT                                         
MFA-TR*        FROM SESSION.CSR04618_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
           MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO.          
           MOVE LINK-USER-ID              TO PARM-USER-ID.              
      *                                                                         
           INITIALIZE                        DCLCSS-CREDIT-HIST.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT CREDIT HISTORY DATA USING CUSTOMER NO                 **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-CUSTOMER-NO-NUM      TO CK-CUSTOMER-NO             
                                             CU-CUSTOMER-NO.            
      *                                                                         
           MOVE '01'                      TO C8-COMPANY-NO.             
           MOVE 'MASK-SSN-CUST-DAYS'      TO C8-DELINQ-CD.              
           PERFORM 7000-GET-DELINQ-VALUE  THRU  7000-EXIT.              
           MOVE C8-DELINQ-VALUE           TO WS-MASK-SSN-CUST-DAYS.     
      *                                                                         
           MOVE '01'                      TO C8-COMPANY-NO.             
           MOVE 'MASK-SSN-SCORE-HOURS'    TO C8-DELINQ-CD.              
           PERFORM 7000-GET-DELINQ-VALUE  THRU  7000-EXIT.              
           MOVE C8-DELINQ-VALUE           TO WS-MASK-SSN-SCORE-HOURS.   
      *                                                                         
           MOVE '01'                      TO C8-COMPANY-NO.             
           MOVE 'NO-HOURS-RANGE'          TO C8-DELINQ-CD.              
           PERFORM 7000-GET-DELINQ-VALUE  THRU  7000-EXIT.              
           MOVE C8-DELINQ-VALUE           TO WS-NO-SCORE-HOURS.         
      *                                                                         
           MOVE 'N'                       TO WS-USER-CAT-ACCESS-FL.     
           MOVE 316                       TO F5-CATEGORY-ID.            
           MOVE PARM-USER-ID              TO F5-USER-ID.                
           PERFORM 7010-CHK-USER-CATEGORY-ACCESS   THRU  7010-EXIT.     
      *                                                                         
           PERFORM 7020-GET-CUSTOMER-DATA          THRU  7020-EXIT.     
      *                                                                         
           IF CU-CUSTOMER-EST-DATE GREATER THAN SPACES                  
              PERFORM 7030-GET-CUST-EST-NO-OF-DAYS THRU  7030-EXIT      
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-OPEN-CRED-HIST-MAIN-CUR    THRU  7100-EXIT.     
      *                                                                         
           PERFORM 7110-FETCH-CRED-HIST-MAIN-CUR   THRU  7110-EXIT.     
      *                                                                         
           PERFORM 2200-PROCESS-CRED-HIST-DETAILS  THRU  2200-EXIT      
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                         
           PERFORM 7120-CLOSE-CRED-HIST-MAIN-CUR   THRU  7120-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS CREDIT HISTORY DETAILS                               **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-CRED-HIST-DETAILS.                                  
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS          
                                             DG-APPL-RESULT-CD          
                                             DG-APPL-RESPONSE-CD        
                                             KE-APPL-RESPONSE-TXT       
                                             KL-CRED-CD-DESC            
                                             D6-ACTION-MSG-TX           
                                             D6-RESP-SCRIPT-TXT.        
      *                                                                         
      *** GET FIRST NAME, MIDDLE NAME & LAST NAME FROM USER PROFILE             
           MOVE CK-USER-ID-CR-INIT-BY     TO PF-USER-ID.                
           PERFORM 7200-GET-USER-PROFILE-DATA  THRU  7200-EXIT.         
P00757     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00757        MOVE 'NOT FOUND'            TO PF-FIRST-NAME              
P00757        MOVE PF-USER-ID             TO PF-LAST-NAME               
P00757        MOVE SPACES                 TO PF-MIDDLE-NAME             
P00757     END-IF.                                                      
      *                                                                         
      *** GET APPL RESULT CD & APPL RESPONSE CD FROM CRED BUR MATRIX            
      *** GET APPL RESPONSE TEXT FROM APPL RESPONSE FOR APPL RESPONSE CD        
      *                                                                         
           MOVE CK-CR-CHK-COMPANY-NO      TO DG-COMPANY-NO.             
      ***** IF VERIFY DIFFERENT TABLE VALUES ARE SELECTED FOR DISPLAY.          
I01701** D (UTILITY) AND K (DHR UTILITY) NEEDS TO DISPLAY DIFFERENT             
I01701** RESULT/RESP BASED ON CREDIT SCORE OR VERIFY.                           
I01701** H (HVAC) OR M (MERCHANDISE) HAS SAME VERBIAGE.                         
           IF CK-CR-BUREAU-CD      = 'P'                                
I01701        IF CK-CR-RQST-REASON-CD = 'D' OR                          
A05655           CK-CR-RQST-REASON-CD = 'K'                             
                 MOVE CK-CR-BUREAU-CD       TO DG-CR-RQST-REASON-CD     
                                               KE-CR-RQST-REASON-CD     
                                               D6-CR-RQST-REASON-CD     
I01701        ELSE                                                      
                 MOVE CK-CR-RQST-REASON-CD  TO DG-CR-RQST-REASON-CD     
                                               KE-CR-RQST-REASON-CD     
                                               D6-CR-RQST-REASON-CD
              END-IF     
           ELSE                                                         
              MOVE CK-CR-RQST-REASON-CD  TO DG-CR-RQST-REASON-CD        
                                            KE-CR-RQST-REASON-CD        
                                            D6-CR-RQST-REASON-CD        
           END-IF.                                                      
           MOVE CK-REG-GROUP-CD           TO DG-REG-GROUP-CD.           
           MOVE CK-SENIOR-FL              TO DG-SENIOR-FL.              
           MOVE CK-CR-SCORE-TYPE-CD       TO DG-CR-SCORE-TYPE-CD.       
           MOVE CK-CR-SCORE-CD            TO DG-CR-SCORE-CD.            
ACT169     MOVE CK-CR-HIST-TRAN-DT        TO DG-EFFECTIVE-DT            
ACT169                                       DG-EXPIRATION-DT.          
           PERFORM 7225-GET-CRED-BUR-MATRX-DATA  THRU  7225-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CK-CR-CHK-COMPANY-NO   TO KE-COMPANY-NO              
              MOVE DG-APPL-RESPONSE-CD    TO KE-APPL-RESPONSE-CD        
              PERFORM 7250-GET-APPL-RESPONSE-TEXT  THRU  7250-EXIT      
           END-IF.                                                      
      *                                                                         
      *** GET ACTION MESSAGE TEXT & RESPONSE SCRIPT TEXT                        
      *                                                                         
P00773     IF CK-APPL-STATUS-CD = 'C' OR CK-CR-RQST-REASON-CD = 'R'     
              MOVE CK-CR-CHK-COMPANY-NO   TO D6-COMPANY-NO              
A05198        IF CK-SCORE-MODEL-CD = 'A'                                
A05198           MOVE CK-SCORE-MODEL-CD    TO D6-SCORE-MODEL-CD         
A05198           MOVE CK-ADDL-CRED-SCORE   TO D6-MIN-SCORE-NO           
A05198                                        D6-MAX-SCORE-NO           
A05198        ELSE                                                      
A05198           MOVE 'B'                  TO D6-SCORE-MODEL-CD         
                 MOVE CK-BEACON-SCORE      TO D6-MIN-SCORE-NO           
                                              D6-MAX-SCORE-NO           
A05198        END-IF                                                    
              MOVE CK-SENIOR-FL           TO D6-SENIOR-FL               
              MOVE CK-REG-GROUP-CD        TO D6-REG-GROUP-CD            
              PERFORM 7275-GET-DEP-REQUIREMNT-DATA  THRU  7275-EXIT     
ACT331*                                                                         
ACT331*** ONLY USE ACTION-MSG-TX AND RESP-SCRIPT-TXT FROM                       
ACT331*** CSS-DEP-REQUIREMNT FOR PRE-PAY                                        
ACT331*                                                                         
ACT331        IF CK-SPECIAL-OFFER-CD = 'P'                              
ACT331            MOVE SPACES             TO DG-APPL-RESULT-CD          
ACT331                                       KE-APPL-RESPONSE-TXT-TEXT  
ACT331        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2500-MOVE-RESULT  THRU  2500-EXIT.                   
      *                                                                         
           INITIALIZE                        CK-CR-COMMENTS             
                                             CK-VENDOR-COMMENTS         
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3             
                                             WS-DATE-NULL-4             
                                             WS-ITPA-RSLT-CURR-NULL     
                                             WS-LETTER-NOTIFY-NULL      
                                             WS-CRED-HIST-NO-OF-HOURS   
                                             WS-SSN-FMT                 
                                             WS-SSN-FMT-AND-MASK        
                                             WS-SSN-MASK-FLAG.          
      *                                                                         
           PERFORM 7110-FETCH-CRED-HIST-MAIN-CUR  THRU  7110-EXIT.      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2400-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS = 0                                              
              MOVE 100                    TO S-RETURN-CODE              
              PERFORM 8100-SEND-RESULT    THRU  8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - CREDIT HISTORY DETAILS                     **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT.                                                
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE CK-CR-HIST-TRAN-DT        TO S-CR-HIST-TRAN-DT.         
           MOVE CK-CR-HIST-TRAN-TM        TO S-CR-HIST-TRAN-TM.         
      *                                                                         
      *** COMBINE DATE & TIME FOR C# FORMATTING                                 
           STRING CK-CR-HIST-TRAN-DT         DELIMITED BY SIZE          
                  ' '                        DELIMITED BY SIZE          
                  CK-CR-HIST-TRAN-TM         DELIMITED BY SIZE          
             INTO S-CR-HIST-TRAN-DT-TM-FMT                              
           END-STRING.                                                  
           INSPECT S-CR-HIST-TRAN-DT-TM-FMT REPLACING ALL '.' BY ':'.   
      *                                                                         
      *** GET DESC FROM CRED CODE DESC FOR APPL RESPONSE CD                     
           IF DG-APPL-RESULT-CD GREATER THAN SPACES                     
              MOVE CK-CR-CHK-COMPANY-NO   TO KL-COMPANY-NO              
              MOVE 'APPL_RESULT_CD'       TO KL-COLUMN-NA               
              MOVE DG-APPL-RESULT-CD      TO KL-CRED-CD                 
              PERFORM 7300-GET-CRED-CODE-DESC  THRU  7300-EXIT          
              MOVE KL-CRED-CD-DESC        TO S-APPL-RESULT-CD-DESC      
           ELSE                                                         
              MOVE SPACES                 TO S-APPL-RESULT-CD-DESC      
           END-IF.                                                      
      *                                                                         
           MOVE D6-ACTION-MSG-TX          TO S-ACTION-MSG-TX.           
           MOVE KE-APPL-RESPONSE-TXT-TEXT TO S-APPL-RESPONSE-TEXT.      
           MOVE D6-RESP-SCRIPT-TXT        TO S-RESP-SCRIPT-TXT.         
           MOVE CK-USER-ID-CR-INIT-BY     TO S-USER-ID-CR-INIT-BY.      
           MOVE PF-FIRST-NAME             TO S-FIRST-NAME-CR-INIT-BY.   
           MOVE PF-LAST-NAME              TO S-LAST-NAME-CR-INIT-BY.    
           MOVE PF-MIDDLE-NAME            TO S-MIDDLE-NAME-CR-INIT-BY.  
           MOVE CK-CR-RQST-REASON-CD      TO S-CR-RQST-REASON-CD.       
           MOVE CK-CR-BUREAU-CD           TO S-CR-BUREAU-CD.            
           MOVE CK-CR-COMMENTS-TEXT       TO S-CR-COMMENTS.             
           MOVE CK-VENDOR-COMMENTS-TEXT   TO S-VENDOR-COMMENTS.         
           MOVE CK-REG-GROUP-CD           TO S-REG-GROUP-CD.            
           MOVE CK-CR-CHK-COMPANY-NO      TO S-CR-CHK-COMPANY-NO.       
      *                                                                         
           MOVE CK-CR-CHK-COMPANY-NO      TO S-DIVISION(1:2).           
           MOVE CK-REG-GROUP-CD           TO S-DIVISION(3:1).           
           IF CK-SENIOR-FL = 'Y'                                        
              MOVE 'S'                    TO S-DIVISION(4:1)            
           ELSE                                                         
              MOVE ' '                    TO S-DIVISION(4:1)            
           END-IF.                                                      
      *                                                                         
           MOVE CK-CR-SCORE-UPDATE-FL     TO S-CR-SCORE-UPDATE-FL.      
           MOVE CK-CR-SCORE-CD            TO S-CR-SCORE-CD.             
           MOVE CK-CR-SCORE-TYPE-CD       TO S-CR-SCORE-TYPE-CD.        
           MOVE CK-CREDIT-SOURCE-CD       TO S-CREDIT-SOURCE-CD.        
A05198     IF CK-SCORE-MODEL-CD = 'A'                                   
A05198        MOVE CK-ADDL-CRED-SCORE     TO S-BEACON-SCORE             
A05198     ELSE                                                         
A05198        MOVE CK-BEACON-SCORE        TO S-BEACON-SCORE             
A05198     END-IF                                                       
           MOVE CK-APPL-STATUS-CD         TO S-APPL-STATUS-CD.          
           MOVE CK-CR-ACTION-FL           TO S-CR-ACTION-FL.            
           MOVE CK-SPECIAL-OFFER-CD       TO S-SPECIAL-OFFER-CD.        
      *                                                                         
      *** CRED HIST NO OF HOURS:USED FOR HISTORY RULE & SSN MASK RULE           
           PERFORM 7325-GET-CRED-HIST-NO-OF-HOURS  THRU  7325-EXIT.     
      *                                                                         
           IF CK-SSN GREATER THAN SPACES                                
              PERFORM 2600-PROCESS-SSN-MASK-RULES  THRU  2600-EXIT      
           ELSE                                                         
              MOVE SPACES                 TO S-SSN                      
                                             WS-SSN-MASK-FLAG           
                                             S-SSN-MASK-FLAG            
           END-IF.                                                      
      *                                                                         
           MOVE CK-DATE-OF-BIRTH          TO S-DATE-OF-BIRTH.           
           MOVE CK-DRIVERS-LICENSE-NO     TO S-DRIVERS-LICENSE-NO.      
           MOVE CK-DRIVERS-LIC-ST-CD      TO S-DRIVERS-LIC-ST-CD.       
           MOVE CK-ITPA-EXISTS-CD         TO S-ITPA-EXISTS-CD.          
      *                                                                         
      *** HISTORY RULE:LF-ITPA-RSLT-CURR-CD = 'R' (RESOLVED)                    
      ***                                         G (ITPAGREEN CODE)            
      *** HISTORY RULE:LF-ITPA-RSLT-CURR-CD > ' ' AND NOT = 'R'                 
      ***                                      -> I (ITPA CODE)                 
      *** HISTORY RULE:CREDIT HIST CHECK HOURS <= DELINQ VAL -> N (NEW)         
      *                                                                         
           IF LF-ITPA-RSLT-CURR-CD GREATER THAN SPACES                  
P00704        IF LF-ITPA-RSLT-CURR-CD = 'R'                             
P00704           MOVE 'G'                 TO S-HISTORY-RULE-CD          
P00704        ELSE                                                      
P00704           MOVE 'I'                 TO S-HISTORY-RULE-CD          
P00704        END-IF                                                    
           ELSE                                                         
              IF WS-CRED-HIST-NO-OF-HOURS <= WS-NO-SCORE-HOURS          
                 MOVE 'N'                 TO S-HISTORY-RULE-CD          
              ELSE                                                      
                 MOVE SPACES              TO S-HISTORY-RULE-CD          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
P00704***  LF-ITPA-RSLT-CURR-CD NOT R (NOT RESOLVED)/                           
P00704***     S-RESULTS-RULE-CD = R                                             
P00704*** CK-APPL-STATUS-CD = D(DENY) AND APPL-STATUS-CD NOT 'C'                
P00704***                            /S-RESULTS-RULE-CD = R(RED)                
P00704*** CK-APPL-STATUS-CD = D(DENY) AND DG-APPL-RESPONSE-CD = 'C'             
P00704***                            /S-RESULTS-RULE-CD = Y(YELLOW)             
P00704     IF LF-ITPA-RSLT-CURR-CD GREATER THAN SPACES                  
P00704        IF LF-ITPA-RSLT-CURR-CD NOT = 'R'                         
P00704           MOVE 'R'              TO S-RESULTS-RULE-CD             
P00704        ELSE                                                      
P00704          IF CK-APPL-STATUS-CD = 'D' AND DG-APPL-RESPONSE-CD = 'C'
P00704             MOVE 'Y'                 TO S-RESULTS-RULE-CD        
P00704          ELSE                                                    
P00704             IF CK-APPL-STATUS-CD = 'D'                           
P00704                MOVE 'R'              TO S-RESULTS-RULE-CD        
P00704             ELSE                                                 
P00704                MOVE SPACES           TO S-RESULTS-RULE-CD        
P00704          END-IF                                                  
P00704        END-IF
              END-IF                                                    
P00704     ELSE                                                         
P00704        IF CK-APPL-STATUS-CD = 'D' AND DG-APPL-RESPONSE-CD = 'C'  
P00704           MOVE 'Y'                    TO S-RESULTS-RULE-CD       
P00704        ELSE                                                      
P00704           IF CK-APPL-STATUS-CD = 'D'                             
P00704              MOVE 'R'                 TO S-RESULTS-RULE-CD       
P00704           ELSE                                                   
P00704              MOVE SPACES              TO S-RESULTS-RULE-CD       
P00704           END-IF                                                 
P00704        END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE CK-SENIOR-FL              TO S-SENIOR-FL.               
      *                                                                         
           MOVE CK-CB-BEACON-REJ-CD       TO S-CB-BEACON-REJ-CD.        
           MOVE 'R'                       TO S-CB-BEACON-REJ-TYPE-CD.   
           MOVE CK-CB-SAFESCAN-CD         TO S-CB-SAFESCAN-CD.          
           MOVE 'S'                       TO S-CB-SAFESCAN-TYPE-CD.     
           MOVE CK-CB-MATCH-CD            TO S-CB-MATCH-CD.             
           MOVE 'M'                       TO S-CB-MATCH-TYPE-CD.        
           MOVE CK-CB-HIT-CD              TO S-CB-HIT-CD.               
           MOVE 'H'                       TO S-CB-HIT-TYPE-CD.          
      *                                                                         
           EVALUATE TRUE                                                
               WHEN CK-CB-FORMAT-ERR-CD   > SPACE                       
                    MOVE CK-CB-FORMAT-ERR-CD   TO S-CB-ERROR-CD         
                    MOVE 'FE'                  TO S-CB-ERROR-TYPE-CD    
               WHEN CK-CB-PROCESS-ERR-CD  > SPACE                       
                    MOVE CK-CB-PROCESS-ERR-CD  TO S-CB-ERROR-CD         
                    MOVE 'PE'                  TO S-CB-ERROR-TYPE-CD    
               WHEN CK-CB-VALIDITY-ERR-CD > SPACE                       
                    MOVE CK-CB-VALIDITY-ERR-CD TO S-CB-ERROR-CD         
                    MOVE 'VE'                  TO S-CB-ERROR-TYPE-CD    
           END-EVALUATE.                                                
      *                                                                         
           MOVE CK-ADV-CREDIT-LTR              TO S-ADV-CREDIT-LTR-FL.  
           MOVE CK-ADV-CREDIT-LTR-DT           TO S-ADV-CREDIT-LTR-DT.  
           MOVE LF-ITPA-RSLT-CURR-CD           TO S-ITPA-RSLT-CURR-CD.  
           MOVE LF-LETTER-NOTIFY-CD            TO S-LETTER-NOTIFY-CD.   
           MOVE LF-LETTER-MAILED-DT            TO S-LETTER-MAILED-DT.   
      *                                                                         
           PERFORM 8100-SEND-RESULT       THRU  8100-EXIT.              
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SSN MASK RULES                                               **        
      ** USERID HAS CATEGORY 316 -> FLAG = N(NO ADDL CHECKS REQUIRED) **        
      ** ESTABLISHED DATE RULE SETS FLAG = N(NO ADDL CHECKS REQUIRED) **        
      ** IF ESTABLISH DATE = SPACES/ESTABLISH DATE RULE RES = Y THEN  **        
      **    CHECK CREDIT-HIST-DATE-TIME RULE TO SET FLAG = N/Y        **        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-SSN-MASK-RULES.                                     
      *                                                                         
           MOVE '2600'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 'Y'                       TO WS-SSN-MASK-FLAG.          
      *                                                                         
           IF (WS-USER-CAT-ACCESS-FL = 'Y')                             
                          OR                                            
              (CU-CUSTOMER-EST-DATE GREATER THAN SPACES AND             
               WS-CUST-EST-NO-OF-DAYS   <= WS-MASK-SSN-CUST-DAYS)       
                          OR                                            
              (WS-CRED-HIST-NO-OF-HOURS <= WS-MASK-SSN-SCORE-HOURS)     
              MOVE 'N'                    TO WS-SSN-MASK-FLAG           
           END-IF.                                                      
      *                                                                         
           IF WS-SSN-MASK-FLAG = 'N'                                    
              MOVE WS-SSN-FMT             TO S-SSN                      
           ELSE                                                         
              MOVE WS-SSN-FMT-AND-MASK    TO S-SSN                      
           END-IF.                                                      
      *                                                                         
           MOVE WS-SSN-MASK-FLAG          TO S-SSN-MASK-FLAG.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET DELINQUENCY VALUE                                        **        
      ******************************************************************        
      *                                                                         
       7000-GET-DELINQ-VALUE.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  C8.DELINQ_VALUE                                    
               INTO :C8-DELINQ-VALUE                                    
               FROM  CSS_DELINQUENCY    C8 WITH(READUNCOMMITTED)                
              WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  C8.DELINQ_VALUE                                            
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM  CSS_DELINQUENCY    C8                                      
MFA-TR*       WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*         AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK IF USER HAS INPUT CATEGORY ACCESS                      **        
      ******************************************************************        
      *                                                                         
       7010-CHK-USER-CATEGORY-ACCESS.                                   
      *                                                                         
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :WS-USER-CAT-ACCESS-FL                              
              FROM  CSS_CATEGORY    F5 WITH(READUNCOMMITTED)                    
             WHERE  F5.CATEGORY_ID  =  :F5-CATEGORY-ID                  
               AND  F5.USER_ID      =  :F5-USER-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-USER-CAT-ACCESS-FL                                      
MFA-TR*       FROM  CSS_CATEGORY    F5                                          
MFA-TR*      WHERE  F5.CATEGORY_ID  =  :F5-CATEGORY-ID                          
MFA-TR*        AND  F5.USER_ID      =  :F5-USER-ID                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CATEGORY'             TO TABLE-1                
              MOVE 'CATEGORY_ID'              TO TABLE-ELEMENT-1        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE F5-CATEGORY-ID             TO HOSTVAR-ELEMENT-1      
              MOVE F5-USER-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET CUSTOMER DATA                                           **        
      ******************************************************************        
      *                                                                         
       7020-GET-CUSTOMER-DATA.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT  CU.CUSTOMER_EST_DATE                               
               INTO :CU-CUSTOMER-EST-DATE :WS-DATE-NULL-1                
               FROM  CSS_CUSTOMER    CU WITH(READUNCOMMITTED)                   
              WHERE  CU.CUSTOMER_NO  =  :CU-CUSTOMER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  CU.CUSTOMER_EST_DATE                                       
MFA-TR*        INTO :CU-CUSTOMER-EST-DATE:WS-DATE-NULL-1                        
MFA-TR*        FROM  CSS_CUSTOMER    CU                                         
MFA-TR*       WHERE  CU.CUSTOMER_NO  =  :CU-CUSTOMER-NO                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-1 = WS-YES-NULL                           
                 MOVE SPACES                  TO CU-CUSTOMER-EST-DATE   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUSTOMER'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE CU-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CUST EST NO OF DAYS                                      **        
      ******************************************************************        
      *                                                                         
       7030-GET-CUST-EST-NO-OF-DAYS.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))         
                                          -  CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :CU-CUSTOMER-EST-DATE
              ) IS NULL OR (PATINDEX('%.%', :CU-CUSTOMER-EST-DATE
              ) <> 0) OR (LEN(:CU-CUSTOMER-EST-DATE
              ) <> 10), CIS.CHAR2DATE(:CU-CUSTOMER-EST-DATE
              ), CONVERT(DATE, :CU-CUSTOMER-EST-DATE) ) )
            INTO
              :WS-CUST-EST-NO-OF-DAYS
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CUST-EST-NO-OF-DAYS  =  DAYS(CURRENT DATE)                 
MFA-TR*                                   -  DAYS(:CU-CUSTOMER-EST-DATE)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7030'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'CUSTOMER_EST_DATE'        TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE CU-CUSTOMER-EST-DATE       TO HOSTVAR-ELEMENT-1      
              MOVE CU-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN CRED_HIST_MAIN_CUR CURSOR                              **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-CRED-HIST-MAIN-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
               OPEN CRED_HIST_MAIN_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_HIST'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH CRED_HIST_MAIN_CUR CURSOR                             **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-CRED-HIST-MAIN-CUR.                                   
      *                                                                         
           EXEC SQL                                                     
              FETCH CRED_HIST_MAIN_CUR                                  
               INTO :CK-CR-HIST-TRAN-DT                                 
                   ,:CK-CR-HIST-TRAN-TM                                 
                   ,:CK-USER-ID-CR-INIT-BY                              
                   ,:CK-CR-RQST-REASON-CD                               
                   ,:CK-CR-BUREAU-CD                                    
                   ,:CK-CR-COMMENTS                                     
                   ,:CK-VENDOR-COMMENTS                                 
                   ,:CK-REG-GROUP-CD                                    
                   ,:CK-CR-CHK-COMPANY-NO                               
                   ,:CK-CR-SCORE-UPDATE-FL                              
                   ,:CK-CR-SCORE-CD                                     
                   ,:CK-CREDIT-SOURCE-CD                                
                   ,:CK-CR-SCORE-TYPE-CD                                
                   ,:CK-BEACON-SCORE                                    
                   ,:CK-APPL-STATUS-CD                                  
                   ,:CK-CR-ACTION-FL                                    
                   ,:CK-SPECIAL-OFFER-CD                                
                   ,:CK-SSN                                             
                   ,:WS-SSN-FMT                                         
                   ,:WS-SSN-FMT-AND-MASK                                
                   ,:CK-DATE-OF-BIRTH :WS-DATE-NULL-2                    
                   ,:CK-DRIVERS-LICENSE-NO                              
                   ,:CK-DRIVERS-LIC-ST-CD                               
                   ,:CK-ITPA-EXISTS-CD                                  
                   ,:CK-SENIOR-FL                                       
                   ,:CK-CB-BEACON-REJ-CD                                
                   ,:CK-CB-SAFESCAN-CD                                  
                   ,:CK-CB-MATCH-CD                                     
                   ,:CK-CB-HIT-CD                                       
                   ,:CK-CB-FORMAT-ERR-CD                                
                   ,:CK-CB-PROCESS-ERR-CD                               
                   ,:CK-CB-VALIDITY-ERR-CD                              
                   ,:CK-ADV-CREDIT-LTR                                  
                   ,:CK-ADV-CREDIT-LTR-DT :WS-DATE-NULL-3                
A05198             ,:CK-SCORE-MODEL-CD                                  
A05198             ,:CK-ADDL-CRED-SCORE                                 
                   ,:LF-ITPA-RSLT-CURR-CD :WS-ITPA-RSLT-CURR-NULL        
                   ,:LF-LETTER-NOTIFY-CD :WS-LETTER-NOTIFY-NULL          
                   ,:LF-LETTER-MAILED-DT :WS-DATE-NULL-4                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-2 = WS-YES-NULL                           
                 MOVE SPACES                  TO CK-DATE-OF-BIRTH       
              END-IF                                                    
              IF WS-DATE-NULL-3 = WS-YES-NULL                           
                 MOVE SPACES                  TO CK-ADV-CREDIT-LTR-DT   
              END-IF                                                    
              IF WS-DATE-NULL-4 = WS-YES-NULL                           
                 MOVE SPACES                  TO LF-LETTER-MAILED-DT    
              END-IF                                                    
              IF WS-ITPA-RSLT-CURR-NULL = WS-YES-NULL                   
                 MOVE SPACES                  TO LF-ITPA-RSLT-CURR-CD   
              END-IF                                                    
              IF WS-LETTER-NOTIFY-NULL = WS-YES-NULL                    
                 MOVE SPACES                  TO LF-LETTER-NOTIFY-CD    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_HIST'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE CRED_HIST_MAIN_CUR CURSOR                             **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-CRED-HIST-MAIN-CUR.                                   
      *                                                                         
           EXEC SQL                                                     
              CLOSE CRED_HIST_MAIN_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_HIST'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT USER PROFILE DATA                                     **        
      ******************************************************************        
      *                                                                         
       7200-GET-USER-PROFILE-DATA.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  PF.FIRST_NAME                                      
                    ,PF.LAST_NAME                                       
                    ,PF.MIDDLE_NAME                                     
               INTO  :PF-FIRST-NAME                                     
                    ,:PF-LAST-NAME                                      
                    ,:PF-MIDDLE-NAME                                    
              FROM  CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                  
             WHERE  PF.USER_ID        =  :PF-USER-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PF.FIRST_NAME                                              
MFA-TR*             ,PF.LAST_NAME                                               
MFA-TR*             ,PF.MIDDLE_NAME                                             
MFA-TR*        INTO  :PF-FIRST-NAME                                             
MFA-TR*             ,:PF-LAST-NAME                                              
MFA-TR*             ,:PF-MIDDLE-NAME                                            
MFA-TR*       FROM  CSS_USER_PROFILE  PF                                        
MFA-TR*      WHERE  PF.USER_ID        =  :PF-USER-ID                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
P00757     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID_CR_INIT_BY'       TO TABLE-ELEMENT-1        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-4        
              MOVE CK-USER-ID-CR-INIT-BY      TO HOSTVAR-ELEMENT-1      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-2      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT CRED BUR MATRIX DATA                                  **        
      ******************************************************************        
      *                                                                         
       7225-GET-CRED-BUR-MATRX-DATA.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) DG.APPL_RESULT_CD,
              DG.APPL_RESPONSE_CD                                
               INTO  :DG-APPL-RESULT-CD                                 
                    ,:DG-APPL-RESPONSE-CD                               
              FROM  CSS_CRED_BUR_MATRX   DG WITH(READUNCOMMITTED)               
             WHERE  DG.COMPANY_NO         =  :DG-COMPANY-NO             
               AND  DG.CR_RQST_REASON_CD  =  :DG-CR-RQST-REASON-CD      
               AND  DG.REG_GROUP_CD       =  :DG-REG-GROUP-CD           
               AND  DG.SENIOR_FL          =  :DG-SENIOR-FL              
               AND  DG.CR_SCORE_TYPE_CD   =  :DG-CR-SCORE-TYPE-CD       
               AND  DG.CR_SCORE_CD        =  :DG-CR-SCORE-CD            
ACT169         AND  DG.EFFECTIVE_DT       <= IIF(TRY_CONVERT(DATE, 
                                                       :DG-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :DG-EFFECTIVE-DT
              ) <> 0) OR (LEN(:DG-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :DG-EFFECTIVE-DT
              ), CONVERT(DATE, :DG-EFFECTIVE-DT) )           
ACT169         AND  DG.EXPIRATION_DT      >= IIF(TRY_CONVERT(DATE, 
                                                      :DG-EXPIRATION-DT
              ) IS NULL OR (PATINDEX('%.%', :DG-EXPIRATION-DT
              ) <> 0) OR (LEN(:DG-EXPIRATION-DT) <> 10), CIS.CHAR2DATE(
                                                      :DG-EXPIRATION-DT
              ), CONVERT(DATE, :DG-EXPIRATION-DT) )          
             ORDER BY DG.EFFECTIVE_DT DESC                              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DG.APPL_RESULT_CD                                          
MFA-TR*             ,DG.APPL_RESPONSE_CD                                        
MFA-TR*        INTO  :DG-APPL-RESULT-CD                                         
MFA-TR*             ,:DG-APPL-RESPONSE-CD                                       
MFA-TR*       FROM  CSS_CRED_BUR_MATRX   DG                                     
MFA-TR*      WHERE  DG.COMPANY_NO         =  :DG-COMPANY-NO                     
MFA-TR*        AND  DG.CR_RQST_REASON_CD  =  :DG-CR-RQST-REASON-CD              
MFA-TR*        AND  DG.REG_GROUP_CD       =  :DG-REG-GROUP-CD                   
MFA-TR*        AND  DG.SENIOR_FL          =  :DG-SENIOR-FL                      
MFA-TR*        AND  DG.CR_SCORE_TYPE_CD   =  :DG-CR-SCORE-TYPE-CD               
MFA-TR*        AND  DG.CR_SCORE_CD        =  :DG-CR-SCORE-CD                    
MFA-TR*        AND  DG.EFFECTIVE_DT       <= :DG-EFFECTIVE-DT                   
MFA-TR*        AND  DG.EXPIRATION_DT      >= :DG-EXPIRATION-DT                  
MFA-TR*      ORDER BY DG.EFFECTIVE_DT DESC                                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7225                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7225'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CRED_BUR_MATRX'       TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CR_RQST_REASON_CD'        TO TABLE-ELEMENT-2        
              MOVE 'REG_GROUP_CD'             TO TABLE-ELEMENT-3        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-4        
              MOVE DG-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE DG-CR-RQST-REASON-CD       TO HOSTVAR-ELEMENT-2      
              MOVE DG-REG-GROUP-CD            TO HOSTVAR-ELEMENT-3      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT APPL RESPONSE TEXT                                    **        
      ******************************************************************        
      *                                                                         
       7250-GET-APPL-RESPONSE-TEXT.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  KE.APPL_RESPONSE_TXT                               
               INTO :KE-APPL-RESPONSE-TXT                               
              FROM  CSS_APPL_RESPONSE    KE WITH(READUNCOMMITTED)               
             WHERE  KE.COMPANY_NO         =  :KE-COMPANY-NO             
               AND  KE.CR_RQST_REASON_CD  =  :KE-CR-RQST-REASON-CD      
               AND  KE.APPL_RESPONSE_CD   =  :KE-APPL-RESPONSE-CD       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  KE.APPL_RESPONSE_TXT                                       
MFA-TR*        INTO :KE-APPL-RESPONSE-TXT                                       
MFA-TR*       FROM  CSS_APPL_RESPONSE    KE                                     
MFA-TR*      WHERE  KE.COMPANY_NO         =  :KE-COMPANY-NO                     
MFA-TR*        AND  KE.CR_RQST_REASON_CD  =  :KE-CR-RQST-REASON-CD              
MFA-TR*        AND  KE.APPL_RESPONSE_CD   =  :KE-APPL-RESPONSE-CD               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_APPL_RESPONSE'        TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CR_RQST_REASON_CD'        TO TABLE-ELEMENT-2        
              MOVE 'APPL_RESPONSE_CD'         TO TABLE-ELEMENT-3        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-4        
              MOVE KE-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE KE-CR-RQST-REASON-CD       TO HOSTVAR-ELEMENT-2      
              MOVE KE-APPL-RESPONSE-CD        TO HOSTVAR-ELEMENT-3      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT DEP REQUIREMENT DATA                                  **        
      ******************************************************************        
      *                                                                         
       7275-GET-DEP-REQUIREMNT-DATA.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) D6.ACTION_MSG_TX,
              D6.RESP_SCRIPT_TXT                                 
               INTO  :D6-ACTION-MSG-TX                                  
                    ,:D6-RESP-SCRIPT-TXT                                
              FROM  CSS_DEP_REQUIREMNT    D6 WITH(READUNCOMMITTED)              
             WHERE  D6.COMPANY_NO         =  :D6-COMPANY-NO             
               AND  D6.MIN_SCORE_NO      <=  :D6-MIN-SCORE-NO           
               AND  D6.MAX_SCORE_NO      >=  :D6-MAX-SCORE-NO           
               AND  D6.SENIOR_FL          =  :D6-SENIOR-FL              
               AND  D6.CR_RQST_REASON_CD  =  :D6-CR-RQST-REASON-CD      
               AND  D6.REG_GROUP_CD       =  :D6-REG-GROUP-CD           
A05198         AND  D6.SCORE_MODEL_CD     =  :D6-SCORE-MODEL-CD         
             ORDER BY D6.EFFECTIVE_DT DESC                              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  D6.ACTION_MSG_TX                                           
MFA-TR*             ,D6.RESP_SCRIPT_TXT                                         
MFA-TR*        INTO  :D6-ACTION-MSG-TX                                          
MFA-TR*             ,:D6-RESP-SCRIPT-TXT                                        
MFA-TR*       FROM  CSS_DEP_REQUIREMNT    D6                                    
MFA-TR*      WHERE  D6.COMPANY_NO         =  :D6-COMPANY-NO                     
MFA-TR*        AND  D6.MIN_SCORE_NO      <=  :D6-MIN-SCORE-NO                   
MFA-TR*        AND  D6.MAX_SCORE_NO      >=  :D6-MAX-SCORE-NO                   
MFA-TR*        AND  D6.SENIOR_FL          =  :D6-SENIOR-FL                      
MFA-TR*        AND  D6.CR_RQST_REASON_CD  =  :D6-CR-RQST-REASON-CD              
MFA-TR*        AND  D6.REG_GROUP_CD       =  :D6-REG-GROUP-CD                   
MFA-TR*        AND  D6.SCORE_MODEL_CD     =  :D6-SCORE-MODEL-CD                 
MFA-TR*      ORDER BY D6.EFFECTIVE_DT DESC                                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7275                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7275'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DEP_REQUIREMENT'      TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CR_RQST_REASON_CD'        TO TABLE-ELEMENT-2        
              MOVE 'REG_GROUP_CD'             TO TABLE-ELEMENT-3        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-4        
              MOVE D6-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE D6-CR-RQST-REASON-CD       TO HOSTVAR-ELEMENT-2      
              MOVE D6-REG-GROUP-CD            TO HOSTVAR-ELEMENT-3      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT CRED CODE DESC                                        **        
      ******************************************************************        
      *                                                                         
       7300-GET-CRED-CODE-DESC.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  KL.CRED_CD_DESC                                    
               INTO :KL-CRED-CD-DESC                                    
              FROM  CSS_CRED_CODE_DESC KL WITH(READUNCOMMITTED)                 
             WHERE  KL.COMPANY_NO      =  :KL-COMPANY-NO                
               AND  KL.COLUMN_NA       =  :KL-COLUMN-NA                 
               AND  KL.CRED_CD         =  :KL-CRED-CD                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  KL.CRED_CD_DESC                                            
MFA-TR*        INTO :KL-CRED-CD-DESC                                            
MFA-TR*       FROM  CSS_CRED_CODE_DESC KL                                       
MFA-TR*      WHERE  KL.COMPANY_NO      =  :KL-COMPANY-NO                        
MFA-TR*        AND  KL.COLUMN_NA       =  :KL-COLUMN-NA                         
MFA-TR*        AND  KL.CRED_CD         =  :KL-CRED-CD                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CRED_CODE_DESC'       TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'COLUMN_NA'                TO TABLE-ELEMENT-2        
              MOVE 'CRED_CD'                  TO TABLE-ELEMENT-3        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-4        
              MOVE KL-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE KL-COLUMN-NA               TO HOSTVAR-ELEMENT-2      
              MOVE KL-CRED-CD                 TO HOSTVAR-ELEMENT-3      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CRED HIST NO OF HOURS                                    **        
      ******************************************************************        
      *                                                                         
       7325-GET-CRED-HIST-NO-OF-HOURS.                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT
              (CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE))-CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) ) )) * 24 + 
                  (DATEPART(HOUR, CIS.CURRENT$TIME())-CIS.CHAR2HOUR(
                                                  :CK-CR-HIST-TRAN-TM))
            INTO
              :WS-CRED-HIST-NO-OF-HOURS        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CRED-HIST-NO-OF-HOURS =                                    
MFA-TR*           (DAYS(CURRENT DATE)-DAYS(:CK-CR-HIST-TRAN-DT)) * 24 +         
MFA-TR*           (HOUR(CURRENT TIME)-HOUR(:CK-CR-HIST-TRAN-TM))                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7325'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'CR_HIST_TRAN_DT'          TO TABLE-ELEMENT-1        
              MOVE 'CR_HIST_TRAN_TM'          TO TABLE-ELEMENT-2        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3        
              MOVE CK-CR-HIST-TRAN-DT         TO HOSTVAR-ELEMENT-1      
              MOVE CK-CR-HIST-TRAN-TM         TO HOSTVAR-ELEMENT-2      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - INITIAL                               **        
      ******************************************************************        
      *                                                                         
       8000-DELETE-GTT-ROWS.                                            
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04618_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04618_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04618_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04618_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET                                              **        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04618_R1                            
             (                                                          
              RETURN_CODE                                               
P00757       ,APPL_STATUS_CODE                                          
             ,CR_HIST_TRAN_DT                                           
             ,CR_HIST_TRAN_TM                                           
             ,CR_HIST_TRAN_DT_TM_FMT                                    
             ,APPL_RESULT_CD_DESC                                       
             ,ACTION_MSG_TX                                             
             ,APPL_RESPONSE_TEXT                                        
             ,RESP_SCRIPT_TXT                                           
             ,USER_ID_CR_INIT_BY                                        
             ,FIRST_NAME_CR_INIT_BY                                     
             ,LAST_NAME_CR_INIT_BY                                      
             ,MIDDLE_NAME_CR_INIT_BY                                    
             ,CR_RQST_REASON_CD                                         
             ,CR_BUREAU_CD                                              
             ,CR_COMMENTS                                               
             ,VENDOR_COMMENTS                                           
             ,REG_GROUP_CD                                              
             ,CR_CHK_COMPANY_NO                                         
             ,DIVISION                                                  
             ,CR_SCORE_UPDATE_FL                                        
             ,CR_SCORE_CD                                               
             ,CR_SCORE_TYPE_CD                                          
             ,CREDIT_SOURCE_CD                                          
             ,BEACON_SCORE                                              
             ,APPL_STATUS_CD                                            
             ,CR_ACTION_FL                                              
             ,SPECIAL_OFFER_CD                                          
             ,SSN                                                       
             ,SSN_MASK_FLAG                                             
             ,DATE_OF_BIRTH                                             
             ,DRIVERS_LICENSE_NO                                        
             ,DRIVERS_LIC_ST_CD                                         
             ,ITPA_EXISTS_CD                                            
             ,HISTORY_RULE_CD                                           
             ,RESULTS_RULE_CD                                           
             ,SENIOR_FL                                                 
             ,CB_BEACON_REJ_CD                                          
             ,CB_BEACON_REJ_TYPE_CD                                     
             ,CB_SAFESCAN_CD                                            
             ,CB_SAFESCAN_TYPE_CD                                       
             ,CB_MATCH_CD                                               
             ,CB_MATCH_TYPE_CD                                          
             ,CB_HIT_CD                                                 
             ,CB_HIT_TYPE_CD                                            
             ,CB_ERROR_CD                                               
             ,CB_ERROR_TYPE_CD                                          
             ,ADV_CREDIT_LTR_FL                                         
             ,ADV_CREDIT_LTR_DT                                         
             ,ITPA_RSLT_CURR_CD                                         
             ,LETTER_NOTIFY_CD                                          
             ,LETTER_MAILED_DT                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
P00757       ,:S-APPL-STATUS-CODE                                       
             ,:S-CR-HIST-TRAN-DT                                        
             ,:S-CR-HIST-TRAN-TM                                        
             ,:S-CR-HIST-TRAN-DT-TM-FMT                                 
             ,:S-APPL-RESULT-CD-DESC                                    
             ,:S-ACTION-MSG-TX                                          
             ,:S-APPL-RESPONSE-TEXT                                     
             ,:S-RESP-SCRIPT-TXT                                        
             ,:S-USER-ID-CR-INIT-BY                                     
             ,:S-FIRST-NAME-CR-INIT-BY                                  
             ,:S-LAST-NAME-CR-INIT-BY                                   
             ,:S-MIDDLE-NAME-CR-INIT-BY                                 
             ,:S-CR-RQST-REASON-CD                                      
             ,:S-CR-BUREAU-CD                                           
             ,:S-CR-COMMENTS                                            
             ,:S-VENDOR-COMMENTS                                        
             ,:S-REG-GROUP-CD                                           
             ,:S-CR-CHK-COMPANY-NO                                      
             ,:S-DIVISION                                               
             ,:S-CR-SCORE-UPDATE-FL                                     
             ,:S-CR-SCORE-CD                                            
             ,:S-CR-SCORE-TYPE-CD                                       
             ,:S-CREDIT-SOURCE-CD                                       
             ,:S-BEACON-SCORE                                           
             ,:S-APPL-STATUS-CD                                         
             ,:S-CR-ACTION-FL                                           
             ,:S-SPECIAL-OFFER-CD                                       
             ,:S-SSN                                                    
             ,:S-SSN-MASK-FLAG                                          
             ,:S-DATE-OF-BIRTH                                          
             ,:S-DRIVERS-LICENSE-NO                                     
             ,:S-DRIVERS-LIC-ST-CD                                      
             ,:S-ITPA-EXISTS-CD                                         
             ,:S-HISTORY-RULE-CD                                        
             ,:S-RESULTS-RULE-CD                                        
             ,:S-SENIOR-FL                                              
             ,:S-CB-BEACON-REJ-CD                                       
             ,:S-CB-BEACON-REJ-TYPE-CD                                  
             ,:S-CB-SAFESCAN-CD                                         
             ,:S-CB-SAFESCAN-TYPE-CD                                    
             ,:S-CB-MATCH-CD                                            
             ,:S-CB-MATCH-TYPE-CD                                       
             ,:S-CB-HIT-CD                                              
             ,:S-CB-HIT-TYPE-CD                                         
             ,:S-CB-ERROR-CD                                            
             ,:S-CB-ERROR-TYPE-CD                                       
             ,:S-ADV-CREDIT-LTR-FL                                      
             ,:S-ADV-CREDIT-LTR-DT                                      
             ,:S-ITPA-RSLT-CURR-CD                                      
             ,:S-LETTER-NOTIFY-CD                                       
             ,:S-LETTER-MAILED-DT                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04618_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_STATUS_CODE                                                  
MFA-TR*      ,CR_HIST_TRAN_DT                                                   
MFA-TR*      ,CR_HIST_TRAN_TM                                                   
MFA-TR*      ,CR_HIST_TRAN_DT_TM_FMT                                            
MFA-TR*      ,APPL_RESULT_CD_DESC                                               
MFA-TR*      ,ACTION_MSG_TX                                                     
MFA-TR*      ,APPL_RESPONSE_TEXT                                                
MFA-TR*      ,RESP_SCRIPT_TXT                                                   
MFA-TR*      ,USER_ID_CR_INIT_BY                                                
MFA-TR*      ,FIRST_NAME_CR_INIT_BY                                             
MFA-TR*      ,LAST_NAME_CR_INIT_BY                                              
MFA-TR*      ,MIDDLE_NAME_CR_INIT_BY                                            
MFA-TR*      ,CR_RQST_REASON_CD                                                 
MFA-TR*      ,CR_BUREAU_CD                                                      
MFA-TR*      ,CR_COMMENTS                                                       
MFA-TR*      ,VENDOR_COMMENTS                                                   
MFA-TR*      ,REG_GROUP_CD                                                      
MFA-TR*      ,CR_CHK_COMPANY_NO                                                 
MFA-TR*      ,DIVISION                                                          
MFA-TR*      ,CR_SCORE_UPDATE_FL                                                
MFA-TR*      ,CR_SCORE_CD                                                       
MFA-TR*      ,CR_SCORE_TYPE_CD                                                  
MFA-TR*      ,CREDIT_SOURCE_CD                                                  
MFA-TR*      ,BEACON_SCORE                                                      
MFA-TR*      ,APPL_STATUS_CD                                                    
MFA-TR*      ,CR_ACTION_FL                                                      
MFA-TR*      ,SPECIAL_OFFER_CD                                                  
MFA-TR*      ,SSN                                                               
MFA-TR*      ,SSN_MASK_FLAG                                                     
MFA-TR*      ,DATE_OF_BIRTH                                                     
MFA-TR*      ,DRIVERS_LICENSE_NO                                                
MFA-TR*      ,DRIVERS_LIC_ST_CD                                                 
MFA-TR*      ,ITPA_EXISTS_CD                                                    
MFA-TR*      ,HISTORY_RULE_CD                                                   
MFA-TR*      ,RESULTS_RULE_CD                                                   
MFA-TR*      ,SENIOR_FL                                                         
MFA-TR*      ,CB_BEACON_REJ_CD                                                  
MFA-TR*      ,CB_BEACON_REJ_TYPE_CD                                             
MFA-TR*      ,CB_SAFESCAN_CD                                                    
MFA-TR*      ,CB_SAFESCAN_TYPE_CD                                               
MFA-TR*      ,CB_MATCH_CD                                                       
MFA-TR*      ,CB_MATCH_TYPE_CD                                                  
MFA-TR*      ,CB_HIT_CD                                                         
MFA-TR*      ,CB_HIT_TYPE_CD                                                    
MFA-TR*      ,CB_ERROR_CD                                                       
MFA-TR*      ,CB_ERROR_TYPE_CD                                                  
MFA-TR*      ,ADV_CREDIT_LTR_FL                                                 
MFA-TR*      ,ADV_CREDIT_LTR_DT                                                 
MFA-TR*      ,ITPA_RSLT_CURR_CD                                                 
MFA-TR*      ,LETTER_NOTIFY_CD                                                  
MFA-TR*      ,LETTER_MAILED_DT                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-APPL-STATUS-CODE                                               
MFA-TR*      ,:S-CR-HIST-TRAN-DT                                                
MFA-TR*      ,:S-CR-HIST-TRAN-TM                                                
MFA-TR*      ,:S-CR-HIST-TRAN-DT-TM-FMT                                         
MFA-TR*      ,:S-APPL-RESULT-CD-DESC                                            
MFA-TR*      ,:S-ACTION-MSG-TX                                                  
MFA-TR*      ,:S-APPL-RESPONSE-TEXT                                             
MFA-TR*      ,:S-RESP-SCRIPT-TXT                                                
MFA-TR*      ,:S-USER-ID-CR-INIT-BY                                             
MFA-TR*      ,:S-FIRST-NAME-CR-INIT-BY                                          
MFA-TR*      ,:S-LAST-NAME-CR-INIT-BY                                           
MFA-TR*      ,:S-MIDDLE-NAME-CR-INIT-BY                                         
MFA-TR*      ,:S-CR-RQST-REASON-CD                                              
MFA-TR*      ,:S-CR-BUREAU-CD                                                   
MFA-TR*      ,:S-CR-COMMENTS                                                    
MFA-TR*      ,:S-VENDOR-COMMENTS                                                
MFA-TR*      ,:S-REG-GROUP-CD                                                   
MFA-TR*      ,:S-CR-CHK-COMPANY-NO                                              
MFA-TR*      ,:S-DIVISION                                                       
MFA-TR*      ,:S-CR-SCORE-UPDATE-FL                                             
MFA-TR*      ,:S-CR-SCORE-CD                                                    
MFA-TR*      ,:S-CR-SCORE-TYPE-CD                                               
MFA-TR*      ,:S-CREDIT-SOURCE-CD                                               
MFA-TR*      ,:S-BEACON-SCORE                                                   
MFA-TR*      ,:S-APPL-STATUS-CD                                                 
MFA-TR*      ,:S-CR-ACTION-FL                                                   
MFA-TR*      ,:S-SPECIAL-OFFER-CD                                               
MFA-TR*      ,:S-SSN                                                            
MFA-TR*      ,:S-SSN-MASK-FLAG                                                  
MFA-TR*      ,:S-DATE-OF-BIRTH                                                  
MFA-TR*      ,:S-DRIVERS-LICENSE-NO                                             
MFA-TR*      ,:S-DRIVERS-LIC-ST-CD                                              
MFA-TR*      ,:S-ITPA-EXISTS-CD                                                 
MFA-TR*      ,:S-HISTORY-RULE-CD                                                
MFA-TR*      ,:S-RESULTS-RULE-CD                                                
MFA-TR*      ,:S-SENIOR-FL                                                      
MFA-TR*      ,:S-CB-BEACON-REJ-CD                                               
MFA-TR*      ,:S-CB-BEACON-REJ-TYPE-CD                                          
MFA-TR*      ,:S-CB-SAFESCAN-CD                                                 
MFA-TR*      ,:S-CB-SAFESCAN-TYPE-CD                                            
MFA-TR*      ,:S-CB-MATCH-CD                                                    
MFA-TR*      ,:S-CB-MATCH-TYPE-CD                                               
MFA-TR*      ,:S-CB-HIT-CD                                                      
MFA-TR*      ,:S-CB-HIT-TYPE-CD                                                 
MFA-TR*      ,:S-CB-ERROR-CD                                                    
MFA-TR*      ,:S-CB-ERROR-TYPE-CD                                               
MFA-TR*      ,:S-ADV-CREDIT-LTR-FL                                              
MFA-TR*      ,:S-ADV-CREDIT-LTR-DT                                              
MFA-TR*      ,:S-ITPA-RSLT-CURR-CD                                              
MFA-TR*      ,:S-LETTER-NOTIFY-CD                                               
MFA-TR*      ,:S-LETTER-MAILED-DT                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04618_R1'              TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 'USER ID'                  TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE CK-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS.              
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
