       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04617.                                         
COB303 DATE-WRITTEN.  DECEMBER 20, 2010.                                
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00100000
      *                 P R O G R A M  S U M M A R Y                   *00110000
      *                                                                *00120000
      * This Program updates the Budget Billing amount. Calling process*00130000
      * need to perform all necessary validations.                     *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                     PROGRAM MODIFICATION LOG                   *00180000
      *                                                                *00190000
      *    DATE    INITIALS   COMMENTS                                 *00200000
      *  --------  --------   ---------------------------------------  *00210000
P00424*  12/20/10  SP95538    PROCEDURE ORIGINALLY CODED FOR BPA'S.    *00220000
A03300*  06/04/11  AA97148    REMOVED 'Z' IN THE WHERE CLAUSE OF 7100- *00230000
A03300*                       PARA AND MOVE 1 TO THE ITEM-ID BEFORE    *00240000
A03300*                       INSERTING A NEW ROW INTO CSS_BUDGET_HIST *00250000
A03300*                       TABLE.                                   *00260000
P00694*  01/16/13  EM19682    ADDED CODE FOR BBP ADJUSTMENTS.          *00270000
P0694A*  02/08/13  VV94890    ADDED ACTION-CODE FOR DELETE FUNTIONALITY*00280000
P0694B*  02/09/13  GOKUL      ADDED LOGIC TO DELETE BBP.               *00290000
P0694C*  04/12/13  VV94890    MOVED CODE TO PROPER PLACE.              *00291000
ACT001*  12/17/14  MS93554    UPDATE LOGIC FOR PAYAMNET START DATE     *00292008
ACT001*                       AND TRANS HIST AS PART OF APPL05136.     *00293019
ACT002*  12/30/14  MS93554    CORRECT THE MONTH CHANGE TRAS HIST DTLS  *00294020
A05460*  07/01/16  VENKAT.P   FIXED S0C7 ISSUE.                        *00294030
      *                                                                *00295020
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                 00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----               00330000
      *                                                                 00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION              00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                     00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                    00370000
      *  3000 - 4999  NOT USED                                          00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                            00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                             00400000
      *  7000 - 7999  INPUT MODULES                                     00410000
      *  8000 - 8999  OUTPUT MODULES                                    00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES              00430000
      *                                                                 00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04617'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04617 STARTS HERE'.                  
      *                                                                 00530000
      ******************************************************************00540000
      * WORK AREAS                                                     *00550000
      ******************************************************************00560000
      *                                                                 00570000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04617'.     
           05  WS-AMT-MO-PYMT-C         PIC X(11).                      
A05460     05  WS-AMT-MO-PYMT-N REDEFINES WS-AMT-MO-PYMT-C              
A05460                                  PIC 9(09)V99.                   
           05  WS-AMT-MO-PYMT           PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-AMT-MO-PYMT-X         PIC ZZZZZZZZ9.99 VALUE SPACE.   
           05  WS-REMARKS-LEN-C         PIC X(04).                      
A05460     05  WS-REMARKS-LEN-N REDEFINES WS-REMARKS-LEN-C              
A05460                                  PIC 9(04).                      
           05  WS-REMARKS-LEN           PIC S9(04) USAGE COMP-3 VALUE 0.
           05  WS-MON-REMAIN-C          PIC X(02).                      
A05460     05  WS-MON-REMAIN-N REDEFINES WS-MON-REMAIN-C                
A05460                                  PIC 9(02).                      
           05  WS-MON-REMAIN            PIC S9(02) USAGE COMP-3 VALUE 0.
           05  WS-REMARKS-TXT           PIC X(210) VALUE SPACES.        
P00694     05  WS-ACT-COUNT             PIC S9(09) COMP VALUE 0.        
P00694     05  WS-REV-MNTH-C            PIC 9(06).                      
P00694     05  WS-HOLD-REV-LAST-NRML    PIC 9(06).                      
P00694     05  WS-FROM-REV-MTH          PIC S9(06)V COMP-3 VALUE +0.    
P00694     05  WS-TO-REV-MTH            PIC S9(06)V COMP-3 VALUE +0.    
P00694     05  WS-SYS-MON-REMAIN        PIC S9(02) USAGE COMP-3 VALUE 0.
P00694     05  WS-BBP-TERM              PIC S9(09) COMP VALUE 0.        
P00694     05  WS-EPP-MTHS-RMNG-QT      PIC S9(3)V COMP VALUE 0.        
P00694     05  WS-REVIEW-EXEMPT         PIC X(01) VALUE SPACES.         
P00694     05  WS-LETTER-NOTIFY         PIC X(01) VALUE SPACES.         
P00694     05  WS-CHANGE-REASON         PIC X(01) VALUE SPACES.         
P00694     05  WS-MNTHS-RMNG-DIFF       PIC S9(02) COMP VALUE 0.        
P00694     05  WS-NEW-ANNIV-DATE        PIC X(10) VALUE SPACES.         
ACT001     05  WS-NEW-START-DATE        PIC X(10) VALUE SPACES.         
ACT001     05  WS-PREV-MTHS-RMNG        PIC X(04) VALUE SPACES.         
ACT001     05  WS-PREV-MTHS-RMNG-N      PIC S9(03)V COMP-3 VALUE +0.    
P0694A     05  WS-ACTION-CODE           PIC X(01) VALUE SPACES.         
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
P0694B     05  WS-MON-LST-NRML-DATE.                                    
P0694B         10  WS-MON-LST-NRML-YY   PIC 9(04).                      
P0694B         10  FILLER               PIC X(01) VALUE '-'.            
P0694B         10  WS-MON-LST-NRML-MM   PIC 9(02).                      
P0694B         10  FILLER               PIC X(03) VALUE '-01'.          
P0694B     05  WS-MONTN-LST-NRML-DATE   PIC X(10).                      
P0694B     05  WS-CURR-DATE.                                            
P0694B         10  WS-CURRENT-YYYY      PIC 9(04).                      
P0694B         10  WS-DASH-1            PIC X(01) VALUE '-'.            
P0694B         10  WS-CURRENT-MM        PIC 9(02).                      
P0694B         10  WS-DASH-2            PIC X(01) VALUE '-'.            
P0694B         10  WS-CURRENT-DD        PIC 9(02).                      
P0694B     05  WS-CURRENT-DATE-C REDEFINES WS-CURR-DATE PIC X(10).      
P0694B     05  WS-PREV-DATE.                                            
P0694B         10  WS-PREV-YYYY         PIC 9(04).                      
P0694B         10  WS-DASH-1            PIC X(01) VALUE '-'.            
P0694B         10  WS-PREV-MM           PIC 9(02).                      
P0694B         10  WS-DASH-2            PIC X(01) VALUE '-'.            
P0694B         10  WS-PREV-DD           PIC 9(02).                      
P0694B     05  WS-PREV-DATE-C REDEFINES WS-PREV-DATE PIC X(10).         
P0694B     05  WS-BILLED-BALANCE        PIC S9(09)V99 COMP-3 VALUE +0.  
COB305     05 WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.           
P0694B     05  WS-REVENUE-MONTH-X       PIC X(6)      VALUE SPACES.     
P0694B     05  WS-NEXT-REV-DATE.                                        
P0694B         10 WS-NEXT-REV-YEAR      PIC X(04).                      
P0694B         10 FILLER                PIC X(01) VALUE '-'.            
P0694B         10 WS-NEXT-REV-MONTH     PIC X(02).                      
P0694B         10 FILLER                PIC X(01) VALUE '-'.            
P0694B         10 WS-NEXT-REV-DAY       PIC X(02).                      
P0694B                                                                  
P0694B     05  WS-CURR-REV-DATE.                                        
P0694B         10 WS-CURR-REV-YEAR      PIC X(04).                      
P0694B         10 FILLER                PIC X(01) VALUE '-'.            
P0694B         10 WS-CURR-REV-MONTH     PIC X(02).                      
P0694B         10 FILLER                PIC X(01) VALUE '-'.            
P0694B         10 WS-CURR-REV-DAY       PIC X(02).                      
COB305     05 WS-AMT-POSTED        PIC S9(09)V99 COMP-3 VALUE 0.           
P0694B     05  WS-PRV-CODE-TEMP-BILL    PIC X(01).                      
P0694B     05  WS-UTILITY-BALANCE-C     PIC X(11).                      
P0694B     05  WS-UTILITY-BALANCE-N REDEFINES WS-UTILITY-BALANCE-C      
P0694B                                  PIC 9(09)V99.                   
COB305     05 WS-UTILITY-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-UTILITY-BALANCE-TRN        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.           
P0694B     05  WS-UTILITY-BALANCE-UTE   PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-UTILITY-BALANCE-UTG   PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-UTE-DAY-00            PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-UTE-DAY-30            PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-UTG-DAY-00            PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-UTG-DAY-30            PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-TOT-BAL-UTE-UTG       PIC S9(09)V99 COMP-3 VALUE +0.  
P0694B     05  WS-EPP-OFFER-DT-NULL-IND PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-REVENUE-MONTH-NULL    PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-REVENUE-MONTH-NULL2   PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-DATE-ORIG-PYMT-IND    PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-AMT-POSTED-NULL       PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-BILL-NO-NULL          PIC S9(4) COMP VALUE +0.        
P0694B     05  WS-AR-AGE                PIC X(01).                      
P0694B     05  WS-GAS-EXISTS            PIC X(01).                      
P0694B     05  WS-ELEC-EXISTS           PIC X(01).                      
COB305     05 WS-EPP-ARREARS-AT-DELETE        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.           
COB305     05 WS-AMT-BILLED-UNPAID        PIC S9(09)V99 COMP-3 VALUE 0.         
P0694B     05  WS-ACCT-NAME-DR          PIC X(10).                      
P0694B     05  WS-ACCT-NAME-CR          PIC X(10).                      
COB305     05 WS-END-AR-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-BALANCE-FORWARD        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-EPP-ESTIMATE        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-ARREARS-AMT        PIC S9(09)V99 COMP-3 VALUE 0.           
P0694B     05  WS-SUMM-UNBILLED-FLAG    PIC X(01).                      
COB305     05 WS-AMT-TO-COLLECT        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-ACCOUNT-NO-PACKED        PIC S9(13) COMP-3 VALUE 0.            
P0694B     05  WS-ACCOUNT-NO-C.                                         
P0694B         10  WS-CUSTOMER-NO       PIC X(10) VALUE SPACES.         
P0694B         10  FILLER               PIC X(03) VALUE SPACES.         
P0694B     05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C.                 
P0694B         10  WS-ACCOUNT-NO-NUM    PIC 9(13).                      
P0694B     05  WS-CUST-NO-NUM           REDEFINES WS-ACCOUNT-NO.        
P0694B         10  WS-CUSTOMER-NO-NUM   PIC 9(10).                      
P0694B         10  WS-ACCOUNT-SEQ-NUM   PIC 9(03).                      
P0694B     05  WS-UTILITY-RELT-BALANCE PIC S9(09)V99 COMP-3 VALUE +0.   
P0694B     05  WS-UTILITY-RELT-ARREARS PIC S9(09)V99 COMP-3 VALUE +0.   
P0694B     05  WS-ZERO-DATE-MASK     PIC X(10) VALUE '1900-01-01'.      
P0694B                                                                  
P0694B     05  WS-COMMENT-TEXT.                                         
P0694B         10 WS-TRAN-COMMENT-TEXT  PIC X(210).                     
P0694B         10 WS-REMARKS-TEXT       PIC X(210) VALUE SPACES.        
P0694B                                                                  
P0694B     05  WS-COMMENT-LENGTH.                                       
P0694B         10 WS-TRAN-COMMENT-LEN   PIC X(04).                      
P0694B         10 WS-TRAN-COMMENT-LEN-N REDEFINES WS-TRAN-COMMENT-LEN   
P0694B                                  PIC 9(04).                      
P0694B         10 WS-TRAN-COMMENT-LEN-C PIC S9(04) USAGE COMP.          
P0694B                                                                  
P0694B                                                                  
P0694B     05  WS-UTE-SW                PIC X(01) VALUE 'N'.            
P0694B         88 UTE-EXISTS                      VALUE 'Y'.            
P0694B                                                                  
P0694B     05  WS-UTG-SW                PIC X(01) VALUE 'N'.            
P0694B         88 UTG-EXISTS                      VALUE 'Y'.            
P0694B                                                                  
P0694B     05  WS-UNMETERED-SW          PIC X(01) VALUE 'N'.            
P0694B         88 UNMETERED-EXISTS                VALUE 'Y'.            
P0694B 01  WS-GL-PPL-TABLE.                                             
P0694B     05  WS-PPL-AR-TYPE-NSC    PIC S9(4) COMP VALUE +019.         
P0694B     05  WS-PPL-AR-TYPE-LPC    PIC S9(4) COMP VALUE +030.         
P0694B     05  WS-PPL-AR-TYPE-LPN    PIC S9(4) COMP VALUE +039.         
P0694B     05  WS-PPL-AR-TYPE-UTE    PIC S9(4) COMP VALUE +040.         
P0694B     05  WS-PPL-AR-TYPE-UTG    PIC S9(4) COMP VALUE +045.         
P0694B     05  WS-PPL-AR-TYPE-EPP    PIC S9(4) COMP VALUE +050.         
P0694B     05  WS-PPL-AR-TYPE-RCC    PIC S9(4) COMP VALUE +060.         
P0694B     05  WS-PPL-AR-TYPE-CIA    PIC S9(4) COMP VALUE +070.         
P0694B     05  WS-GEN-LED-NSC        PIC X(10) VALUE 'AR-NSC'.          
P0694B     05  WS-GEN-LED-LPC        PIC X(10) VALUE 'AR-LPC'.          
P0694B     05  WS-GEN-LED-LPN        PIC X(10) VALUE 'AR-LPN'.          
P0694B     05  WS-GEN-LED-UTE        PIC X(10) VALUE 'AR-UTE'.          
P0694B     05  WS-GEN-LED-UTG        PIC X(10) VALUE 'AR-UTG'.          
P0694B     05  WS-GEN-LED-EPP        PIC X(10) VALUE 'AR-BUD'.          
P0694B     05  WS-GEN-LED-RCC        PIC X(10) VALUE 'AR-CCC'.          
P0694B     05  WS-GEN-LED-CIA        PIC X(10) VALUE 'AR-CIA'.          
                                                                        
P0694B 01  CASH-DRAWER-JOURNALING.                                      
P0694B     05  WS-CASH-DRAWER.                                          
P0694B         10  WS-CD-COMPANY-NO        PIC X(02).                   
P0694B         10  WS-CD-LOCAL-OFFICE      PIC X(03).                   
P0694B         10  WS-CD-REPORT-NO         PIC X(03).                   
P0694B         10  WS-CD-REPORT-DATE       PIC X(10).                   
P0694B         10  WS-CASH-DRAWER-ID       PIC S9(04) COMP.             
                                                                        
       01 WS-BBP-UPDATE-MSG.                                            
           05  FILLER                      PIC X(09) VALUE 'ADJ FROM '. 
           05  WS-BBP-OLD-AMT              PIC 9(04) VALUE ZEROS.       
           05  FILLER                      PIC X(04) VALUE ' TO '.      
           05  WS-BBP-NEW-AMT              PIC 9(04) VALUE ZEROS.       
      *                                                                 02220000
P0694B 01  WS-LITERALS.                                                 
P0694B     05  WS-0                        PIC X(01)   VALUE '0'.       
P0694B     05  WS-3                        PIC X(01)   VALUE '3'.       
P0694B     05  WS-6                        PIC X(01)   VALUE '6'.       
P0694B     05  WS-9                        PIC X(01)   VALUE '9'.       
P0694B     05  WS-A                        PIC X(01)   VALUE 'A'.       
P0694B     05  WS-B                        PIC X(01)   VALUE 'B'.       
P0694B     05  WS-C                        PIC X(01)   VALUE 'C'.       
P0694B     05  WS-F                        PIC X(01)   VALUE 'F'.       
P0694B     05  WS-J                        PIC X(01)   VALUE 'J'.       
P0694B     05  WS-K                        PIC X(01)   VALUE 'K'.       
P0694B     05  WS-R                        PIC X(01)   VALUE 'R'.       
P0694B     05  WS-T                        PIC X(01)   VALUE 'T'.       
P0694B     05  WS-W                        PIC X(01)   VALUE 'W'.       
P0694B     05  WS-Z                        PIC X(01)   VALUE 'Z'.       
P0694B     05  WS-UNMETERED                PIC X(01)   VALUE 'U'.       
P0694B     05  WS-LAST-UPDATE-TS-MISMATCH  PIC S9(9) COMP VALUE -999.   
P0694B     05  WS-E                        PIC X(01)   VALUE 'E'.       
P0694B     05  WS-G                        PIC X(01)   VALUE 'G'.       
P0694B*                                                                 02420000
p00694 01 WS-EXEMPT-ADDED.                                              
P00694     05  FILLER                      PIC X(41) VALUE              
P00694         'BUDGET BILLING MONITORING EXEMPT FLAG SET'.             
P00694 01 WS-EXEMPT-REMOVED.                                            
P00694     05  FILLER                      PIC X(45) VALUE              
P00694         'BUDGET BILLING MONITORING EXEMPT FLAG REMOVED'.         
      *                                                                 02490000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
      *                                                                 02520000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
      *                                                                 02550000
      ******************************************************************02560000
      *               COBOL WORKING STORAGE COPY BOOKS                 *02570000
      ******************************************************************02580000
      *                                                                 02590000
      ******************************************************************02600000
      *    ERROR HANDLING                                              *02610000
      ******************************************************************02620000
      *                                                                 02630000
           EXEC SQL                                                     02640000
              INCLUDE CWSX0010                                          02650000
           END-EXEC.                                                    02660000
      *                                                                 02670000
      ******************************************************************02680000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *02690000
      ******************************************************************02700000
      *                                                                 02710000
           COPY CWS00303.                                               02720000
      *                                                                 02730000
P0694B******************************************************************02740000
P0694B*    CODES_DATA_PRESENT COPYBOOK                                 *02750000
P0694B******************************************************************02760000
P0694B*                                                                 02770000
P0694B     COPY CWS00056.                                               02780000
P0694B*                                                                 02790000
P0694B******************************************************************02800000
P0694B*    SUPPORTS journalling                                        *02810000
P0694B******************************************************************02820000
P0694B*                                                                 02830000
P0694B     COPY CJF00113.                                               02840000
P0694B     COPY CJF00101.                                               02850000
P0694B     EXEC SQL                                                     02860000
P0694B        INCLUDE CWS0013B                                          02870000
P0694B     END-EXEC.                                                    02880000
P0694B*                                                                 02890000
      ******************************************************************02900000
      *   SQL COMMUNICATION AREA                                       *02910000
      ******************************************************************02920000
      *                                                                 02930000
           EXEC SQL                                                     02940000
               INCLUDE SQLCA                                            02950000
           END-EXEC.                                                    02960000
      *                                                                 02970000
      ******************************************************************02980000
      *   CSS_MNT_TRANS_HIST - MH                                      *02990000
      ******************************************************************03000000
      *                                                                 03010000
           EXEC SQL                                                     03020000
              INCLUDE TBMNHIST                                          03030000
           END-EXEC.                                                    03040000
      *                                                                 03050000
      ******************************************************************03060000
      *   CSS_MT_TRN_HST_DET - MI                                      *03070000
      ******************************************************************03080000
      *                                                                 03090000
           EXEC SQL                                                     03100000
              INCLUDE TBMNHDT                                           03110000
           END-EXEC.                                                    03120000
      *                                                                 03130000
      ******************************************************************03140000
      *   CSS_BUDGET_HIST - BH                                         *03150000
      ******************************************************************03160000
      *                                                                 03170000
           EXEC SQL                                                     03180000
              INCLUDE TBBGTHST                                          03190000
           END-EXEC.                                                    03200000
      *                                                                 03210000
      ******************************************************************03220000
      *   CSS_BUDGET_PLAN - BU                                         *03230000
      ******************************************************************03240000
      *                                                                 03250000
           EXEC SQL                                                     03260000
              INCLUDE TBBGTPLN                                          03270000
           END-EXEC.                                                    03280000
      *                                                                 03290000
      ******************************************************************03300000
      *   CSS_ACCT_ATTRIBUTE - YP                                      *03310000
      ******************************************************************03320000
      *                                                                 03330000
P00694     EXEC SQL                                                     03340000
P00694        INCLUDE TBACTATT                                          03350000
P00694     END-EXEC.                                                    03360000
P00694*                                                                 03370000
P0694B******************************************************************03380000
P0694B*   CSS_BATCH_JRNL     - BJ                                      *03390000
P0694B******************************************************************03400000
P0694B*                                                                 03410000
P0694B     EXEC SQL                                                     03420000
P0694B        INCLUDE TBBTJRNL                                          03430000
P0694B     END-EXEC.                                                    03440000
P0694B                                                                  
P0694B******************************************************************03460000
P0694B*   CSS_CSH_DRWR_JRNL  - CJ                                      *03470000
P0694B******************************************************************03480000
P0694B*                                                                 03490000
P0694B     EXEC SQL                                                     03500000
P0694B        INCLUDE TBCDJRNL                                          03510000
P0694B     END-EXEC.                                                    03520000
P0694B                                                                  
P0694B******************************************************************03540000
P0694B*   CSS_MISC_JRNL      - MJ                                      *03550000
P0694B******************************************************************03560000
P0694B*                                                                 03570000
P0694B     EXEC SQL                                                     03580000
P0694B        INCLUDE TBMSJRNL                                          03590000
P0694B     END-EXEC.                                                    03600000
P0694B                                                                  
P0694B******************************************************************03620000
P0694B*   CSS_ACCOUNT        - AT                                      *03630000
P0694B******************************************************************03640000
P0694B*                                                                 03650000
P0694B     EXEC SQL                                                     03660000
P0694B        INCLUDE TBACCT                                            03670000
P0694B     END-EXEC.                                                    03680000
P0694B                                                                  
P0694B******************************************************************03700000
P0694B*   CSS_AR_LOCKOUT     - AL                                      *03710000
P0694B******************************************************************03720000
P0694B*                                                                 03730000
P0694B     EXEC SQL                                                     03740000
P0694B        INCLUDE TBARLOCK                                          03750000
P0694B     END-EXEC.                                                    03760000
P0694B                                                                  
P0694B******************************************************************03780000
P0694B*   CSS_AR_CNTL        - AC                                      *03790000
P0694B******************************************************************03800000
P0694B*                                                                 03810000
P0694B     EXEC SQL                                                     03820000
P0694B           INCLUDE TBARCNTL                                       03830000
P0694B     END-EXEC.                                                    03840000
P0694B                                                                  
P0694B******************************************************************03860000
P0694B*   CSS_AR_TRANS_HIST  - AR                                      *03870000
P0694B******************************************************************03880000
P0694B*                                                                 03890000
P0694B     EXEC SQL                                                     03900000
P0694B           INCLUDE TBARHIST                                       03910000
P0694B     END-EXEC.                                                    03920000
P0694B                                                                  
P0694B******************************************************************03940000
P0694B*   CSS_AR_TRN_HST_DET - AU                                      *03950000
P0694B******************************************************************03960000
P0694B*                                                                 03970000
P0694B     EXEC SQL                                                     03980000
P0694B           INCLUDE TBARHDT                                        03990000
P0694B     END-EXEC.                                                    04000000
P0694B                                                                  
P0694B******************************************************************04020000
P0694B*   CSS_BCH_JRNL_CNTL  - BC                                      *04030000
P0694B******************************************************************04040000
P0694B*                                                                 04050000
P0694B     EXEC SQL                                                     04060000
P0694B           INCLUDE TBBJCNTL                                       04070000
P0694B     END-EXEC.                                                    04080000
P0694B                                                                  
P0694B******************************************************************04100000
P0694B*   CSS_BILLING_DET    - BG                                      *04110000
P0694B******************************************************************04120000
P0694B*                                                                 04130000
P0694B     EXEC SQL                                                     04140000
P0694B           INCLUDE TBBLLDET                                       04150000
P0694B     END-EXEC.                                                    04160000
P0694B                                                                  
P0694B******************************************************************04180000
P0694B*   CSS_BILL_WINDOW    - BN                                      *04190000
P0694B******************************************************************04200000
P0694B*                                                                 04210000
P0694B     EXEC SQL                                                     04220000
P0694B           INCLUDE TBBILWDW                                       04230000
P0694B     END-EXEC.                                                    04240000
P0694B                                                                  
P0694B******************************************************************04260000
P0694B*   CSS_CSH_DRWR_CNTL  - CS                                      *04270000
P0694B******************************************************************04280000
P0694B*                                                                 04290000
P0694B     EXEC SQL                                                     04300000
P0694B           INCLUDE TBCDCNTL                                       04310000
P0694B     END-EXEC.                                                    04320000
P0694B                                                                  
P0694B******************************************************************04340000
P0694B*   CSS_CUST_PLAN      - CP                                      *04350000
P0694B******************************************************************04360000
P0694B*                                                                 04370000
P0694B     EXEC SQL                                                     04380000
P0694B           INCLUDE TBCSTPLN                                       04390000
P0694B     END-EXEC.                                                    04400000
P0694B                                                                  
P0694B******************************************************************04420000
P0694B*   CSS_CUSTOMER       - CU                                      *04430000
P0694B******************************************************************04440000
P0694B*                                                                 04450000
P0694B     EXEC SQL                                                     04460000
P0694B           INCLUDE TBCUST                                         04470000
P0694B     END-EXEC.                                                    04480000
P0694B                                                                  
P0694B******************************************************************04500000
P0694B*   CSS_PREMISE        - PR                                      *04510000
P0694B******************************************************************04520000
P0694B*                                                                 04530000
P0694B     EXEC SQL                                                     04540000
P0694B           INCLUDE TBPREM                                         04550000
P0694B     END-EXEC.                                                    04560000
P0694B                                                                  
P0694B******************************************************************04580000
P0694B*   CSS_GL_ACCT_NO     - GO                                      *04590000
P0694B******************************************************************04600000
P0694B*                                                                 04610000
P0694B     EXEC SQL                                                     04620000
P0694B           INCLUDE TBGLATNO                                       04630000
P0694B     END-EXEC.                                                    04640000
P0694B                                                                  
P0694B******************************************************************04660000
P0694B*   CSS_USER_PROFILE   - PF                                      *04670000
P0694B******************************************************************04680000
P0694B*                                                                 04690000
P0694B     EXEC SQL                                                     04700000
P0694B           INCLUDE TBUSRPRF                                       04710000
P0694B     END-EXEC.                                                    04720000
P0694B                                                                  
P0694B******************************************************************04740000
P0694B*   CSS_LOCAL_OFFICE   - B1                                      *04750000
P0694B******************************************************************04760000
P0694B*                                                                 04770000
P0694B     EXEC SQL                                                     04780000
P0694B           INCLUDE TBLOCOFC                                       04790000
P0694B     END-EXEC.                                                    04800000
P0694B                                                                  
P0694B******************************************************************04820000
P0694B*   CSS_BILLING_HDR    - BI                                      *04830000
P0694B******************************************************************04840000
P0694B*                                                                 04850000
P0694B     EXEC SQL                                                     04860000
P0694B        INCLUDE TBBLLHDR                                          04870000
P0694B     END-EXEC.                                                    04880000
                                                                        
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04617 ENDS HERE  '.            
      *                                                                 04920000
P0694B     EXEC SQL DECLARE BG-CURSOR CURSOR FOR                        
P0694B         SELECT CODE_UTIL_TYPE                                    
P0694B           FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                     
P0694B          WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO             
P0694B            AND BILL_NO              = :BG-BILL-NO                
P0694B          FOR READ ONLY                                   
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE BG-CURSOR CURSOR FOR                        04930000
MFA-TR*        SELECT CODE_UTIL_TYPE                                    04940000
MFA-TR*          FROM CSS_BILLING_DET                                   04950000
MFA-TR*         WHERE ACCOUNT_NO           = :BG-ACCOUNT-NO             04960000
MFA-TR*           AND BILL_NO              = :BG-BILL-NO                04970000
MFA-TR*         FOR FETCH ONLY WITH UR                                  04980000
MFA-TR*    END-EXEC.                                                    04990000
P0694B*                                                                 05000000
P0694B     EXEC SQL DECLARE BILLING-HDR-CSR CURSOR FOR                  
P0694B        SELECT BILL_NO                                            
P0694B        FROM   CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
P0694B        WHERE  ACCOUNT_NO = :BI-ACCOUNT-NO                        
P0694B        AND    DATE_BILLED IS NOT NULL                            
P0694B        ORDER  BY BILL_NO DESC                                    
P0694B        FOR READ ONLY                                     
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE BILLING-HDR-CSR CURSOR FOR                  05010000
MFA-TR*       SELECT BILL_NO                                            05020000
MFA-TR*       FROM   CSS_BILLING_HDR                                    05030000
MFA-TR*       WHERE  ACCOUNT_NO = :BI-ACCOUNT-NO                        05040000
MFA-TR*       AND    DATE_BILLED IS NOT NULL                            05050000
MFA-TR*       ORDER  BY BILL_NO DESC                                    05060000
MFA-TR*       FOR FETCH ONLY WITH UR                                    05070000
MFA-TR*    END-EXEC.                                                    05080000
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-ID                 PIC X(08).                      
       01  PARM-USER-ID                 PIC X(07).                      
       01  PARM-ACCOUNT-NO              PIC 9(13).                      
       01  PARM-BBP-AMT                 PIC X(11).                      
       01  PARM-REMARKS-TEXT            PIC X(210).                     
       01  PARM-REMARKS-LEN             PIC X(4).                       
P00694 01  PARM-MONTHS-REMAIN           PIC X(2).                       
P00694 01  PARM-REVIEW-EXEMPT           PIC X(1).                       
P00694 01  PARM-LETTER-NOTIFY           PIC X(1).                       
P00694 01  PARM-CHANGE-REASON           PIC X(1).                       
P0694A 01  PARM-ACTION-CODE             PIC X(1).                       
      *                                                                 05220000
       PROCEDURE DIVISION USING  PARM-APPL-ID                           
                                ,PARM-USER-ID                           
                                ,PARM-ACCOUNT-NO                        
                                ,PARM-BBP-AMT                           
                                ,PARM-REMARKS-TEXT                      
                                ,PARM-REMARKS-LEN                       
P00694                          ,PARM-MONTHS-REMAIN                     
P00694                          ,PARM-REVIEW-EXEMPT                     
P00694                          ,PARM-LETTER-NOTIFY                     
P00694                          ,PARM-CHANGE-REASON                     
P0694A                          ,PARM-ACTION-CODE.                      
      *                                                                 05340000
      ******************************************************************05350000
      * 0000-MAINLINE                                                  *05360000
      ******************************************************************05370000
      *                                                                 05380000
       0000-MAINLINE.                                                   
      *                                                                 05400000
           PERFORM 0100-INITIALIZE        THRU 0100-EXIT.               
           PERFORM 1000-PROCESS-INPUT     THRU 1000-EXIT.               
           PERFORM 2000-PROCESS-OUTPUT    THRU 2000-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
      *                                                                 05450000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05480000
      ******************************************************************05490000
      * 0100-INITIALIZE                                                *05500000
      ******************************************************************05510000
      *                                                                 05520000
       0100-INITIALIZE.                                                 
      *                                                                 05540000
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
              WITH ROWSET POSITIONING FOR                               
              SELECT                                                    
                  :S-RETURN-CODE              AS    RETURN_CODE         
              FROM                                                      
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     05550000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                             05560000
MFA-TR*       WITH ROWSET POSITIONING FOR                               05570000
MFA-TR*       SELECT                                                    05580000
MFA-TR*           :S-RETURN-CODE              AS    RETURN_CODE         05590000
MFA-TR*       FROM                                                      05600000
MFA-TR*           SYSIBM.SYSDUMMY1                                      05610000
MFA-TR*    END-EXEC.                                                    05620000
      *                                                                 05630000
           PERFORM 7000-GET-CURRENT-TS   THRU 7000-EXIT.                
      *                                                                 05650000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05680000
      ******************************************************************05690000
      * 1000-PROCESS-INPUT                                             *05700000
      ******************************************************************05710000
      *                                                                 05720000
       1000-PROCESS-INPUT.                                              
      *                                                                 05740000
A05460     MOVE PARM-BBP-AMT              TO WS-AMT-MO-PYMT-C.          
A05460     MOVE WS-AMT-MO-PYMT-N          TO WS-AMT-MO-PYMT.            
      *                                                                 05790000
A05460     MOVE PARM-REMARKS-LEN          TO WS-REMARKS-LEN-C.          
A05460     MOVE WS-REMARKS-LEN-N          TO WS-REMARKS-LEN.            
      *                                                                 05840000
A05460     MOVE PARM-MONTHS-REMAIN        TO WS-MON-REMAIN-c.           
A05460     MOVE WS-MON-REMAIN-N           TO WS-MON-REMAIN.             
      *                                                                 05890000
           MOVE PARM-ACCOUNT-NO           TO BU-ACCOUNT-NO              
                                             BH-ACCOUNT-NO              
                                             MH-ACCOUNT-NO              
P00694                                       AT-ACCOUNT-NO              
P00694                                       YP-ACCOUNT-NO              
P00694                                       AR-ACCOUNT-NO              
P00694                                       AU-ACCOUNT-NO              
P00694                                       BI-ACCOUNT-NO              
P00694                                       BG-ACCOUNT-NO              
P00694                                       CP-ACCOUNT-NO              
P00694                                       AC-ACCOUNT-NO.             
                                                                        
P00694     MOVE PARM-REVIEW-EXEMPT        TO WS-REVIEW-EXEMPT.          
P00694     MOVE PARM-LETTER-NOTIFY        TO WS-LETTER-NOTIFY.          
P00694     MOVE PARM-CHANGE-REASON        TO WS-CHANGE-REASON.          
P0694A     MOVE PARM-ACTION-CODE          TO WS-ACTION-CODE.            
      *                                                                 06060000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06090000
      ******************************************************************06100000
      * 2000-PROCESS-OUTPUT.                                           *06110000
      ******************************************************************06120000
      *                                                                 06130000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 06150000
P00694     PERFORM 7999-SELECT-AL             THRU 7999-SELECT-AL-EXIT. 
P00694                                                                  
P00694     IF AL-AR-LOCKOUT-IND = 'Y'                                   
P00694        MOVE 100                        TO WS-ACTIVE-RETURN-CODE  
P00694                                           S-RETURN-CODE          
P00694        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00694     END-IF.                                                      
P00694                                                                  
P0694B     PERFORM 7100-SEL-BUDGET-HIST       THRU 7100-EXIT.           
ACT001     MOVE BH-EPP-MTHS-RMNG-QT           TO WS-PREV-MTHS-RMNG      
ACT001                                           WS-PREV-MTHS-RMNG-N.   
P00694     PERFORM 7150-SEL-BUDGET-PLAN       THRU 7150-EXIT.           
P0694B     PERFORM 7200-SELECT-ACCOUNT        THRU 7200-EXIT.           
P00694     IF AT-REV-MTH-LST-NRML  > 0                                  
P00694        MOVE AT-REV-MTH-LST-NRML        TO WS-HOLD-REV-LAST-NRML  
P00694     ELSE                                                         
P00694        IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES   
P00694                                         OR '99' OR '00' )        
P00694           PERFORM 7030-SELECT-REV-MTH     THRU 7030-EXIT         
P00694        ELSE                                                      
P00694           PERFORM 7020-SELECT-BILLING-DET THRU 7020-EXIT         
P00694        END-IF                                                    
P00694        MOVE WS-REVENUE-MONTH           TO WS-HOLD-REV-LAST-NRML  
P00694     END-IF.                                                      
P00694                                                                  
P00694     STRING WS-HOLD-REV-LAST-NRML (1:4) DELIMITED BY SIZE         
P00694       INTO WS-MON-LST-NRML-YY.                                   
P00694     STRING WS-HOLD-REV-LAST-NRML (5:2) DELIMITED BY SIZE         
P00694       INTO WS-MON-LST-NRML-MM.                                   
P00694     MOVE WS-MON-LST-NRML-DATE          TO WS-MONTN-LST-NRML-DATE.
P00694     PERFORM 7760-GET-BBP-TERM          THRU 7760-EXIT.           
                                                                        
           EVALUATE WS-ACTION-CODE                                      
            WHEN 'D'                                                    
      * DELETE Budget Plan                                              06490000
              PERFORM 2400-PROCESS-BBP-DELETE THRU 2400-EXIT            
            WHEN OTHER                                                  
      * Update Budget Plan                                              06520000
              IF (WS-AMT-MO-PYMT NOT = BH-AMT-MO-PYMT                   
P00694        OR WS-MON-REMAIN NOT = WS-BBP-TERM)                       
                 MOVE +50                   TO BU-PYMT-PRIORITY-LVL     
                                               BH-PYMT-PRIORITY-LVL     
                 MOVE +1                    TO BU-BP-ITEM-ID            
                                               BH-ITEM-ID               
                 MOVE WS-AMT-MO-PYMT        TO BU-AMT-MO-PYMT           
                 MOVE WS-CURRENT-TS         TO BU-LAST-UPDATE-TS        
                 MOVE BU-ANNIVERSARY-DATE   TO WS-NEW-ANNIV-DATE        
ACT001           IF WS-MON-REMAIN NOT = WS-BBP-TERM                     
                    PERFORM 4000-GET-MNTHS-RMNG-DIFF THRU 4000-EXIT     
ACT001           ELSE                                                   
ACT001              MOVE BH-DATE-PYMT-STRT  TO WS-NEW-START-DATE        
ACT001                                         BU-DATE-PYMT-STRT        
ACT001           END-IF                                                 
P0694C           MOVE WS-MON-REMAIN         TO BH-EPP-MTHS-RMNG-QT      
                 PERFORM 8000-UPD-BUDGET-PLAN  THRU 8000-EXIT           
      * Update MNT Trans & Budget Hist                                  06680000
                 MOVE BH-AMT-MO-PYMT        TO BH-BUDG-BILL-PREV-AMT    
                 MOVE WS-AMT-MO-PYMT        TO BH-AMT-MO-PYMT           
P00694           MOVE WS-CHANGE-REASON      TO BH-CHANGE-REASON         
                 MOVE WS-CURRENT-TS         TO BH-BUD-HIST-SEQ-NO       
                 PERFORM 2100-FORMAT-REMARKS   THRU 2100-EXIT           
                 MOVE 'BBP AMOUNT'          TO MI-COLUMN-DESC           
                 MOVE BH-BUDG-BILL-PREV-AMT TO WS-AMT-MO-PYMT-X         
                 MOVE 12                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-AMT-MO-PYMT-X      TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE WS-AMT-MO-PYMT        TO WS-AMT-MO-PYMT-X         
                 MOVE 12                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-AMT-MO-PYMT-X      TO MI-CHG-COLUMN-VALUE-TEXT 
P00694           IF (WS-AMT-MO-PYMT NOT = BH-BUDG-BILL-PREV-AMT)        
P00694              PERFORM 2200-UPD-MNT-TRANS THRU 2200-EXIT           
P00694           END-IF                                                 
                                                                        
ACT001*          TRANS HIST FOR UPDATED REMAINING MONTHS.               06830208
ACT002           IF WS-MON-REMAIN NOT EQUAL WS-BBP-TERM                 
ACT001              MOVE 'MTHS REMAINING'    TO MI-COLUMN-DESC          
ACT001              MOVE 04                  TO MI-PRV-COLUMN-VALUE-LEN 
ACT001              MOVE WS-PREV-MTHS-RMNG   TO MI-PRV-COLUMN-VALUE-TEXT
ACT001              MOVE 04                  TO MI-CHG-COLUMN-VALUE-LEN 
ACT001              MOVE BH-EPP-MTHS-RMNG-QT TO MI-CHG-COLUMN-VALUE-TEXT
ACT001              PERFORM 2200-UPD-MNT-TRANS THRU 2200-EXIT           
ACT002           END-IF                                                 
                                                                        
                 MOVE ZERO                  TO BH-UTILITY-BALANCE       
                                               BH-BALANCE-FORWARD       
A03300           MOVE 1                     TO BH-ITEM-ID               
P00694           MOVE PARM-USER-ID          TO BH-LAST-UPDATE-USERID    
                 PERFORM 8200-INS-BUDGET-HIST THRU 8200-EXIT            
P00694*                                                                 06890000
P00694           IF WS-LETTER-NOTIFY = 'Y'                              
P00694              PERFORM 7100-SEL-BUDGET-HIST  THRU 7100-EXIT        
P00694              MOVE +2                 TO BH-ITEM-ID               
P00694              MOVE 'X'                TO BH-CHANGE-REASON         
P00694              MOVE WS-CURRENT-TS      TO BH-BUD-HIST-SEQ-NO       
P00694              PERFORM 8200-INS-BUDGET-HIST THRU 8200-EXIT         
P00694           END-IF                                                 
P00694        END-IF                                                    
P00694     END-EVALUATE                                                 
P00694*                                                                 06990000
P00694     PERFORM 2300-REVIEW-EXEMPT    THRU 2300-EXIT.                
      *                                                                 07010000
           ADD 1                         TO CTR-ROWS.                   
      *                                                                 07030000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07060000
      ******************************************************************07070000
      * 2100-FORMAT-REMARKS.                                           *07080000
      ******************************************************************07090000
      *                                                                 07100000
       2100-FORMAT-REMARKS.                                             
      *                                                                 07120000
P00694*    INSPECT BH-REMARKS-TEXT REPLACING ALL LOW-VALUES BY SPACES   07130000
           MOVE BH-BUDG-BILL-PREV-AMT   TO WS-BBP-OLD-AMT.              
           MOVE WS-AMT-MO-PYMT          TO WS-BBP-NEW-AMT.              
P00694*    MOVE WS-BBP-UPDATE-MSG       TO PARM-REMARKS-TEXT.           07160000
P00694     ADD +21                      TO WS-REMARKS-LEN.              
      *                                                                 07180000
ACT002     IF WS-MON-REMAIN NOT EQUAL WS-BBP-TERM                       
ACT001        MOVE PARM-REMARKS-TEXT(1:WS-REMARKS-LEN-N)                
ACT001                                   TO WS-REMARKS-TXT              
ACT001     ELSE                                                         
P00694        STRING PARM-APPL-ID(1:3)                DELIMITED BY SIZE 
P00694        ' '                                   DELIMITED BY SIZE   
P00694        WS-BBP-UPDATE-MSG(1:21)               DELIMITED BY SIZE   
P00694        ' '                                   DELIMITED BY SIZE   
P00694        PARM-REMARKS-TEXT(1:WS-REMARKS-LEN-N) DELIMITED BY SIZE   
P00694        INTO WS-REMARKS-TXT                                       
ACT001     END-IF.                                                      
      *                                                                 07250000
           MOVE WS-REMARKS-TXT           TO BH-REMARKS-TEXT             
           ADD +5                        TO WS-REMARKS-LEN              
           ADD WS-REMARKS-LEN            TO BH-REMARKS-LEN              
           IF  BH-REMARKS-LEN > 210                                     
               MOVE +210                 TO BH-REMARKS-LEN              
           END-IF.                                                      
      *                                                                 07320000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07350000
      ******************************************************************07360000
      * 2200-UPD-MNT-TRANS.                                            *07370000
      ******************************************************************07380000
      *                                                                 07390000
       2200-UPD-MNT-TRANS.                                              
      * Populate MNT Hist                                               07410000
           MOVE BH-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE 0                        TO MH-CUSTOMER-NO.             
           MOVE 0                        TO MH-PREMISE-NO.              
ACT001     ADD  1                        TO MI-TRAN-APPL-NO.            
ACT001     IF MI-TRAN-APPL-NO = 1                                       
ACT001        PERFORM 7000-GET-CURRENT-TS   THRU 7000-EXIT              
ACT001        MOVE WS-CURRENT-TS            TO MH-TRANS-HIST-SEQ-NO     
ACT001                                         MI-TRANS-HIST-SEQ-NO     
ACT001     END-IF                                                       
           MOVE 'CSR04617A'              TO MH-APPL-PROGRAM-ID.         
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE PARM-USER-ID             TO MH-USER-ID.                 
P00694     MOVE WS-REMARKS-TXT           TO MH-TRAN-COMMENT-TEXT.       
P00694     IF  WS-REMARKS-LEN > 210                                     
P00694         MOVE +210                 TO MH-TRAN-COMMENT-LEN         
P00694     ELSE                                                         
P00694         MOVE WS-REMARKS-LEN       TO MH-TRAN-COMMENT-LEN         
P00694     END-IF.                                                      
           MOVE SPACES                   TO MI-TABLE-ID.                
      * Populate MNT Details                                            07630000
           PERFORM 6530-LOAD-MNT-TRANS-HIST                             
                                         THRU 6530-EXIT.                
      *                                                                 07660000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07690000
P00694 2300-REVIEW-EXEMPT.                                              
P00694     MOVE 'BBP_REVIEW_EXEMPT'      TO YP-ATTRIBUTE-DESC.          
P00694     PERFORM 3000-CHECK-ACT-ATT THRU 3000-EXIT.                   
P00694     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                     
P00694                         WS-REVIEW-EXEMPT = 'Y'                   
P00694        MOVE 'BBP_REVIEW_EXEMPT'   TO YP-ATTRIBUTE-DESC           
P00694        MOVE WS-REVIEW-EXEMPT      TO YP-ATTRIBUTE-VALUE-CD       
P00694        MOVE '4-6-8 BBP REVIEW EXEMPT' TO                         
P00694                                   YP-ATTRIBUTE-VALUE-TX-TEXT     
P00694        MOVE 23                    TO YP-ATTRIBUTE-VALUE-TX-LEN   
P00694        MOVE WS-CURRENT-DATE       TO YP-ATTRIBUTE-VALUE-DT       
P00694        MOVE SPACE                 TO YP-STATUS-CD                
P00694        PERFORM 3100-INSERT-ACCT-ATTR  THRU 3100-EXIT             
P00694*                                                                 07830000
P00694        STRING WS-EXEMPT-ADDED(1:41) DELIMITED BY SIZE            
P00694         ' '                         DELIMITED BY SIZE            
P00694         PARM-REMARKS-TEXT(1:WS-REMARKS-LEN-N) DELIMITED BY SIZE  
P00694         INTO WS-REMARKS-TXT                                      
P00694        ADD 42                     TO WS-REMARKS-LEN              
P00694        MOVE 'EXEMPT FLAG'         TO MI-COLUMN-DESC              
P00694        MOVE 25                    TO MI-PRV-COLUMN-VALUE-LEN     
ACT001        MOVE 'NO'                  TO MI-PRV-COLUMN-VALUE-TEXT    
P00694        MOVE 25                    TO MI-CHG-COLUMN-VALUE-LEN     
ACT001        MOVE 'YES'                 TO MI-CHG-COLUMN-VALUE-TEXT    
P00694        PERFORM 2200-UPD-MNT-TRANS    THRU 2200-EXIT              
P00694     ELSE                                                         
P00694        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
P00694                         WS-REVIEW-EXEMPT = 'N'                   
P00694           PERFORM 3200-DELETE-ACCT-ATTR  THRU 3200-EXIT          
P00694*                                                                 08010000
P00694           STRING WS-EXEMPT-REMOVED(1:45) DELIMITED BY SIZE       
P00694            ' '                         DELIMITED BY SIZE         
P00694           PARM-REMARKS-TEXT(1:WS-REMARKS-LEN-N) DELIMITED BY SIZE
P00694            INTO WS-REMARKS-TXT                                   
P00694           ADD 46                    TO WS-REMARKS-LEN            
P00694           MOVE 'EXEMPT FLAG'        TO MI-COLUMN-DESC            
P00694           MOVE 25                   TO MI-PRV-COLUMN-VALUE-LEN   
ACT001           MOVE 'YES'                TO MI-PRV-COLUMN-VALUE-TEXT  
P00694           MOVE 25                   TO MI-CHG-COLUMN-VALUE-LEN   
ACT001           MOVE 'NO'                 TO MI-CHG-COLUMN-VALUE-TEXT  
P00694           PERFORM 2200-UPD-MNT-TRANS    THRU 2200-EXIT           
P00694        END-IF                                                    
P00694     END-IF.                                                      
P00694*                                                                 08180000
P00694 2300-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 08210000
P0694B 2400-PROCESS-BBP-DELETE.                                         
P0694B                                                                  
P0694B     PERFORM 7200-SELECT-ACCOUNT    THRU 7200-EXIT.               
P0694B                                                                  
P0694B     MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
P0694B     MOVE AT-CODE-TEMP-BILL         TO WS-PRV-CODE-TEMP-BILL.     
P0694B                                                                  
P0694B     PERFORM 7250-SELECT-PREMISE    THRU 7250-EXIT.               
P0694B     PERFORM 7275-SELECT-CUSTOMER   THRU 7275-EXIT.               
P0694B     MOVE +0                        TO WS-101-DETAIL-END-BAL.     
P0694B     MOVE +0                        TO WS-101-DETAIL-END-AR-BAL.  
P0694B     MOVE +0                        TO WS-101-ACCT-END-AR-BAL.    
P0694B     MOVE +50                      TO AC-PYMT-PRIORITY-LVL        
P0694B                                      BU-PYMT-PRIORITY-LVL        
P0694B                                      BH-PYMT-PRIORITY-LVL        
P0694B     MOVE +1                       TO AC-ITEM-ID                  
P0694B                                      BU-BP-ITEM-ID               
P0694B                                      BH-ITEM-ID                  
P0694B     PERFORM 7300-SELECT-AR-CNTL   THRU 7300-EXIT                 
P0694B                                                                  
P0694B     COMPUTE WS-EPP-ARREARS-AT-DELETE = AC-AMT-AR-DAY-30          
P0694B                                      + AC-AMT-AR-DAY-60          
P0694B                                      + AC-AMT-AR-DAY-90          
P0694B                                                                  
P0694B     COMPUTE WS-BILLED-BALANCE =   AC-AMT-AR-DAY-00 +             
P0694B                                   AC-AMT-AR-DAY-30 +             
P0694B                                   AC-AMT-AR-DAY-60 +             
P0694B                                   AC-AMT-AR-DAY-90 +             
P0694B                                   AC-AMT-UNUSED-CR               
P0694B     SUBTRACT WS-BILLED-BALANCE    FROM AT-TOTAL-AR-BALANCE       
P0694B     ADD AC-AMT-TRAN-BALANCE       TO AT-TOTAL-AR-BALANCE         
P0694B                                                                  
P0694B     MOVE AT-TOTAL-AR-BALANCE      TO WS-AMT-BILLED-UNPAID        
P0694B                                                                  
P0694B     MOVE WS-GEN-LED-EPP          TO WS-ACCT-NAME-DR              
P0694B     MOVE WS-GEN-LED-EPP          TO WS-ACCT-NAME-CR              
P0694B     MOVE AC-AMT-TRAN-BALANCE     TO WS-UTILITY-BALANCE           
P0694B                                     WS-END-AR-BALANCE            
P0694B                                                                  
P0694B     MOVE 0                       TO AU-TRAN-APPL-NO              
P0694B     PERFORM 2500-SETUP-AR-JRNL   THRU 2500-EXIT                  
P0694B                                                                  
P0694B     MOVE WS-AMT-MO-PYMT          TO BH-AMT-MO-PYMT               
P0694B     IF AT-REV-MTH-LST-NRML  > 0                                  
P0694B        MOVE AT-REV-MTH-LST-NRML TO   WS-REVENUE-MONTH            
P0694B     ELSE                                                         
P0694B        IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES   
P0694B                                         OR '99' OR '00' )        
P0694B           PERFORM 7030-SELECT-REV-MTH     THRU 7030-EXIT         
P0694B        ELSE                                                      
P0694B           PERFORM 7020-SELECT-BILLING-DET THRU 7020-EXIT         
P0694B        END-IF                                                    
P0694B     END-IF                                                       
P0694B     MOVE WS-REVENUE-MONTH        TO WS-REVENUE-MONTH-X           
P0694B     MOVE WS-REVENUE-MONTH-X(1:4) TO WS-CURR-REV-YEAR             
P0694B     MOVE WS-REVENUE-MONTH-X(5:2) TO WS-CURR-REV-MONTH            
P0694B     MOVE '01'                    TO WS-CURR-REV-DAY              
P00694     MOVE 'D'                     TO BH-CHANGE-REASON             
P00694     MOVE WS-CURRENT-TS           TO BH-BUD-HIST-SEQ-NO           
P0694B     MOVE ZEROS                   TO BH-BUDG-BILL-PREV-AMT        
P0694B     MOVE PARM-USER-ID            TO BH-LAST-UPDATE-USERID        
P0694B                                                                  
P0694B     PERFORM 8200-INS-BUDGET-HIST    THRU 8200-EXIT               
P0694B     PERFORM 7925-RETRIEVE-OUTSTANDING-BILL THRU 7925-EXIT        
P0694B     PERFORM 8740-DELETE-AR-CNTL     THRU 8740-EXIT               
P0694B                                                                  
P0694B     MOVE +0                      TO AC-ITEM-ID                   
P0694B     PERFORM 8740-DELETE-AR-CNTL     THRU 8740-EXIT               
P0694B                                                                  
P0694B     MOVE 0                       TO AU-TRAN-APPL-NO              
P0694B     MOVE WS-CURRENT-DATE         TO WS-CURR-DATE                 
P0694B     PERFORM 2900-GET-PREV-DATE      THRU 2900-EXIT               
P0694B     PERFORM 2850-REVERSE-EPP        THRU 2850-EXIT               
P0694B                                                                  
P0694B     IF AC-AMT-TRAN-BALANCE < 0                                   
P0694B        MOVE AC-AMT-TRAN-BALANCE   TO WS-AMT-POSTED               
P0694B        PERFORM 7929C-CONTINUE-CIA-PROCESS THRU 7929C-EXIT        
P0694B     ELSE                                                         
P0694B        IF  UTE-EXISTS OR UTG-EXISTS                              
P0694B            IF (WS-AMT-POSTED >= AC-AMT-TRAN-BALANCE) OR          
P0694B               (WS-EPP-ARREARS-AT-DELETE = 0)                     
P0694B                MOVE AC-AMT-TRAN-BALANCE   TO WS-AMT-POSTED       
P0694B                PERFORM 7929-SPLIT-AMT     THRU 7929-EXIT         
P0694B                MOVE WS-0                  TO WS-AR-AGE           
P0694B                IF UTE-EXISTS                                     
P0694B                   MOVE WS-UTILITY-BALANCE-UTE                    
P0694B                                           TO AC-AMT-AR-DAY-00    
P0694B                                          WS-UTE-DAY-00           
P0694B                   PERFORM 7929A-CONTINUE-UTE-PROCESS             
P0694B                                           THRU 7929A-EXIT        
P0694B                END-IF                                            
P0694B                IF UTG-EXISTS                                     
P0694B                   MOVE WS-UTILITY-BALANCE-UTG                    
P0694B                                           TO AC-AMT-AR-DAY-00    
P0694B                                          WS-UTG-DAY-00           
P0694B                   PERFORM 7929B-CONTINUE-UTG-PROCESS             
P0694B                                           THRU 7929B-EXIT        
P0694B                END-IF                                            
P0694B            ELSE                                                  
P0694B                IF WS-AMT-POSTED < AC-AMT-TRAN-BALANCE            
P0694B                   SUBTRACT WS-AMT-POSTED                         
P0694B                                       FROM AC-AMT-TRAN-BALANCE   
P0694B                                       GIVING  WS-ARREARS-AMT     
P0694B                   PERFORM 7929-SPLIT-AMT  THRU 7929-EXIT         
P0694B                   MOVE WS-0               TO WS-AR-AGE           
P0694B                   IF UTE-EXISTS                                  
P0694B                      MOVE WS-UTILITY-BALANCE-UTE                 
P0694B                                           TO AC-AMT-AR-DAY-00    
P0694B                                            WS-UTE-DAY-00         
P0694B                      PERFORM 7929A-CONTINUE-UTE-PROCESS          
P0694B                                           THRU 7929A-EXIT        
P0694B                   END-IF                                         
P0694B                   IF UTG-EXISTS                                  
P0694B                      MOVE WS-UTILITY-BALANCE-UTG                 
P0694B                                           TO AC-AMT-AR-DAY-00    
P0694B                                            WS-UTG-DAY-00         
P0694B                      PERFORM 7929B-CONTINUE-UTG-PROCESS          
P0694B                                           THRU 7929B-EXIT        
P0694B                   END-IF                                         
P0694B                   MOVE WS-ARREARS-AMT     TO  WS-AMT-POSTED      
P0694B                   PERFORM 7929-SPLIT-AMT  THRU 7929-EXIT         
P0694B                   MOVE WS-3               TO WS-AR-AGE           
P0694B                   IF UTE-EXISTS                                  
P0694B                      MOVE WS-UTILITY-BALANCE-UTE                 
P0694B                                           TO AC-AMT-AR-DAY-30    
P0694B                                            WS-UTE-DAY-30         
P0694B                      PERFORM 7929A-CONTINUE-UTE-PROCESS          
P0694B                                           THRU 7929A-EXIT        
P0694B                   END-IF                                         
P0694B                   IF UTG-EXISTS                                  
P0694B                      MOVE WS-UTILITY-BALANCE-UTG                 
P0694B                                            TO AC-AMT-AR-DAY-30   
P0694B                                            WS-UTG-DAY-30         
P0694B                      PERFORM 7929B-CONTINUE-UTG-PROCESS          
P0694B                                            THRU 7929B-EXIT       
P0694B                   END-IF                                         
P0694B            END-IF
                  END-IF                                                
P0694B       ELSE                                                       
P0694B          IF AC-AMT-TRAN-BALANCE > 0                              
P0694B            PERFORM 7929C-CONTINUE-CIA-PROCESS THRU 7929C-EXIT    
P0694B          END-IF                                                  
P0694B       END-IF                                                     
P0694B                                                                  
P0694B       IF UTE-EXISTS                                              
P0694B          MOVE   +40                  TO   AC-PYMT-PRIORITY-LVL   
P0694B          MOVE  WS-UTE-DAY-00         TO   AC-AMT-AR-DAY-00       
P0694B          MOVE  WS-UTE-DAY-30         TO   AC-AMT-AR-DAY-30       
P0694B          PERFORM 8710-INSERT-AR-CNTL THRU 8710-EXIT              
P0694B       END-IF                                                     
P0694B                                                                  
P0694B       IF UTG-EXISTS                                              
P0694B          MOVE   +45                  TO   AC-PYMT-PRIORITY-LVL   
P0694B          MOVE  WS-UTG-DAY-00         TO   AC-AMT-AR-DAY-00       
P0694B          MOVE  WS-UTG-DAY-30         TO   AC-AMT-AR-DAY-30       
P0694B          PERFORM 8710-INSERT-AR-CNTL THRU 8710-EXIT              
P0694B       END-IF                                                     
P0694B     END-IF                                                       
P0694B                                                                  
P0694B     MOVE SPACES                      TO WS-CODE-BUDGET           
P0694B     MOVE 'A'                         TO WS-CODE-UTL              
P0694B     MOVE WS-CODES-DATA-PRESENT  TO AT-CODES-DATA-PRESENT         
P0694B     MOVE ZEROS                       TO AT-EPP-OFFER-AMOUNT      
P0694B     MOVE SPACES                      TO AT-EPP-OFFER-DATE        
P0694B     MOVE -1                     TO WS-EPP-OFFER-DT-NULL-IND      
P0694B     PERFORM 8805-UPDATE-ACCOUNT-EPP-OFFER                        
P0694B                                  THRU 8805-EXIT.                 
P0694B                                                                  
P0694B*                                                                 10010000
P0694B 2400-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B***************************************************************   10040000
P0694B* 2500-SETUP-AR-JRNL.                                         *   10050000
P0694B*                                                             *   10060000
P0694B* AR JOURNALLING FOR SETTING UP EPP.                          *   10070000
P0694B*                                                             *   10080000
P0694B***************************************************************   10090000
P0694B 2500-SETUP-AR-JRNL.                                              
P0694B                                                                  
P0694B     IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-NSC) OR           
P0694B         (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-LPC) OR           
P0694B         (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTE) OR           
P0694B         (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-UTG) OR           
P0694B         (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-CIA) OR           
P0694B         (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP AND           
P0694B          PARM-ACTION-CODE = 'D'))                                
P0694B                                                                  
P0694B        IF AC-AMT-AR-DAY-00 NOT = 0                               
P0694B           MOVE '0'                         TO WS-AR-AGE          
P0694B           MOVE AC-AMT-AR-DAY-00            TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF AC-AMT-AR-DAY-30 NOT = 0                               
P0694B           MOVE '3'                         TO WS-AR-AGE          
P0694B           MOVE AC-AMT-AR-DAY-30            TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF AC-AMT-AR-DAY-60 NOT = 0                               
P0694B           MOVE '6'                         TO WS-AR-AGE          
P0694B           MOVE AC-AMT-AR-DAY-60            TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF AC-AMT-AR-DAY-90 NOT = 0                               
P0694B           MOVE '9'                         TO WS-AR-AGE          
P0694B           MOVE AC-AMT-AR-DAY-90            TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF AC-AMT-UNUSED-CR NOT = 0                               
P0694B           MOVE 'P'                         TO WS-AR-AGE          
P0694B           MOVE AC-AMT-UNUSED-CR            TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF AC-TOT-SUMM-UNBILLED NOT = 0                           
P0694B           MOVE 'P'                         TO WS-AR-AGE          
P0694B           MOVE AC-TOT-SUMM-UNBILLED        TO WS-AMT-POSTED      
P0694B                                               WS-END-AR-BALANCE  
P0694B           MOVE 'Y' TO WS-SUMM-UNBILLED-FLAG                      
P0694B           PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT      
P0694B           MOVE 'N' TO WS-SUMM-UNBILLED-FLAG                      
P0694B           PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT      
P0694B        END-IF                                                    
P0694B                                                                  
P0694B        IF (AC-AMT-AR-DAY-00 = 0 AND                              
P0694B            AC-AMT-AR-DAY-30 = 0 AND                              
P0694B            AC-AMT-AR-DAY-60 = 0 AND                              
P0694B            AC-AMT-AR-DAY-90 = 0 AND                              
P0694B            AC-AMT-UNUSED-CR = 0 AND                              
P0694B            AC-TOT-SUMM-UNBILLED = 0 )                            
P0694B              IF  AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP AND   
P0694B                  PARM-ACTION-CODE = 'D'                          
P0694B                NEXT SENTENCE                                     
P0694B              ELSE                                                
P0694B                MOVE '0'                        TO WS-AR-AGE      
P0694B                MOVE ZEROES                     TO WS-AMT-POSTED  
P0694B                                                 WS-END-AR-BALANCE
P0694B                PERFORM 2600-UPDATE-TRANS-HISTORY THRU 2600-EXIT  
P0694B                PERFORM 2700-CASH-DRAWER-101      THRU 2700-EXIT  
P0694B              END-IF                                              
P0694B        END-IF                                                    
P0694B     ELSE                                                         
P0694B        IF (AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-RCC)            
P0694B                                                                  
P0694B           IF AC-AMT-TRAN-BALANCE NOT = 0                         
P0694B              MOVE 'F'                        TO WS-AR-AGE        
P0694B              MOVE AC-AMT-TRAN-BALANCE        TO WS-AMT-POSTED    
P0694B                                                 WS-END-AR-BALANCE
P0694B              PERFORM 2600-UPDATE-TRANS-HISTORY THRU 2600-EXIT    
P0694B              PERFORM 2700-CASH-DRAWER-101      THRU 2700-EXIT    
P0694B           END-IF                                                 
P0694B        ELSE                                                      
P0694B           IF  ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP)       
P0694B                 AND (WS-AMT-TO-COLLECT > 0) AND (AC-ITEM-ID > 0))
P0694B            OR ((AC-PYMT-PRIORITY-LVL = WS-PPL-AR-TYPE-EPP)       
P0694B                 AND (AT-REV-MTH-LST-NRML = 0)                    
P0694B                 AND (AC-ITEM-ID > 0))                            
P0694B                                                                  
P0694B              MOVE WS-GEN-LED-EPP     TO WS-ACCT-NAME-CR          
P0694B              MOVE '0'                TO WS-AR-AGE                
P0694B              MOVE WS-AMT-TO-COLLECT  TO WS-AMT-POSTED            
P0694B                                         WS-END-AR-BALANCE        
P0694B              PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT   
P0694B              PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT   
P0694B           END-IF                                                 
P0694B                                                                  
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 2500-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B**************************************************************    11180000
P0694B* 2600-UPDATE-TRANS-HISTORY.                                 *    11190000
P0694B*                                                            *    11200000
P0694B* UPDATE TRANSACTION HISTORY TABLE                           *    11210000
P0694B*                                                            *    11220000
P0694B**************************************************************    11230000
P0694B 2600-UPDATE-TRANS-HISTORY.                                       
P0694B*                                                                 11250000
P0694B     MOVE '2600'                   TO ACTIVE-PARAGRAPH.           
P0694B*                                                                 11270000
P0694B     ADD  1                        TO AU-TRAN-APPL-NO.            
P0694B     IF AU-TRAN-APPL-NO = 1                                       
P0694B        PERFORM 7000-GET-CURRENT-TS   THRU 7000-EXIT              
P0694B     END-IF.                                                      
P0694B     MOVE WS-CURRENT-TS            TO AR-TRANS-HIST-SEQ-NO        
P0694B                                      AU-TRANS-HIST-SEQ-NO.       
P0694B     MOVE WS-CURRENT-DATE          TO AR-DATE-TRANS.              
P0694B     MOVE AC-ITEM-ID               TO AU-ITEM-ID.                 
P0694B                                                                  
P0694B     MOVE WS-AR-AGE                TO AU-CODE-AR-AGE.             
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        MOVE WS-BILLED-BALANCE       TO AR-AMT-ORIG-ENTERED       
P0694B     ELSE                                                         
P0694B* THIS ONE IS OK! IT IS FOR A EPP CHANGE OR DELETE                11410000
P0694B        MOVE WS-UTILITY-BALANCE      TO AR-AMT-ORIG-ENTERED       
P0694B     END-IF.                                                      
P0694B     IF AR-AMT-ORIG-ENTERED < 0                                   
P0694B        MULTIPLY -1 BY AR-AMT-ORIG-ENTERED                        
P0694B        GIVING AR-AMT-ORIG-ENTERED                                
P0694B     END-IF.                                                      
P0694B     MOVE WS-AMT-BILLED-UNPAID     TO AR-AMT-BILLED-UNPAID.       
P0694B     IF PARM-ACTION-CODE = 'D'                                    
P0694B        IF AC-PYMT-PRIORITY-LVL = 50                              
P0694B           SUBTRACT AC-AMT-TRAN-BALANCE FROM AR-AMT-BILLED-UNPAID 
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B     IF WS-AMT-POSTED < 0                                         
P0694B        MOVE WS-ACCT-NAME-DR       TO GO-GL-ACCT-NAME             
P0694B     ELSE                                                         
P0694B        MOVE WS-ACCT-NAME-CR       TO GO-GL-ACCT-NAME             
P0694B     END-IF.                                                      
P0694B     PERFORM 7500-SELECT-GL-NAME  THRU 7500-EXIT.                 
P0694B                                                                  
P0694B     MOVE GO-GL-ACCT-NO            TO WS-101-ACCT-GEN-LED-CR      
P0694B                                      AU-GL-ACCT-CREDIT.          
P0694B     IF WS-AMT-POSTED < 0                                         
P0694B        MOVE WS-ACCT-NAME-CR       TO GO-GL-ACCT-NAME             
P0694B     ELSE                                                         
P0694B        MOVE WS-ACCT-NAME-DR       TO GO-GL-ACCT-NAME             
P0694B     END-IF.                                                      
P0694B     PERFORM 7500-SELECT-GL-NAME  THRU 7500-EXIT.                 
P0694B     MOVE GO-GL-ACCT-NO            TO WS-101-ACCT-GEN-LED-DR      
P0694B                                      AU-GL-ACCT-DEBIT.           
P0694B     IF WS-AMT-POSTED < 0                                         
P0694B        MULTIPLY -1 BY WS-AMT-POSTED GIVING WS-AMT-POSTED         
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B     MOVE WS-AMT-POSTED            TO AU-AMT-POSTED               
P0694B                                      AU-CURRENCY-AMT.            
P0694B     MOVE PARM-USER-ID             TO AR-USER-ID                  
P0694B                                      PF-USER-ID.                 
P0694B     PERFORM 7400-SELECT-USER-PROFILE THRU 7400-EXIT.             
P0694B     MOVE PF-RESP-AREA-ID          TO AR-RESP-AREA-ID.            
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        MOVE 'A'                   TO AR-CODE-TRAN-TYPE           
P0694B        MOVE +0                    TO AR-TRAN-COMMENT-LEN         
P0694B        MOVE SPACES                TO AR-TRAN-COMMENT-TEXT        
P0694B        IF AT-CODE-ACCT-STAT = 'P' OR AT-REV-MTH-LST-NRML = 0     
P0694B           MOVE 'D'                TO AR-CODE-TRAN-TYPE           
P0694B        END-IF                                                    
P0694B     ELSE                                                         
P0694B        MOVE 'D'                   TO AR-CODE-TRAN-TYPE           
P0694B        MOVE WS-UTILITY-BALANCE      TO AR-AMT-ORIG-ENTERED       
P0694B        IF AR-AMT-ORIG-ENTERED < 0                                
P0694B           MULTIPLY -1 BY AR-AMT-ORIG-ENTERED                     
P0694B              GIVING AR-AMT-ORIG-ENTERED                          
P0694B        MOVE WS-TRAN-COMMENT-LEN-C TO AR-TRAN-COMMENT-LEN         
P0694B        MOVE WS-TRAN-COMMENT-TEXT  TO AR-TRAN-COMMENT-TEXT        
P0694B     END-IF
           END-IF.                                                      
P0694B                                                                  
P0694B     MOVE SPACES                   TO AR-PYMT-FACILITY-CD         
P0694B                                      AR-RECORD-ONLY-FL           
P0694B                                      AU-CODE-CONTRACT-TYPE.      
P0694B     MOVE SPACES                   TO AU-CURRENCY-TYPE.           
P0694B     MOVE WS-CURRENT-DATE          TO AT-DATE-LAST-ACTION.        
P0694B     MOVE AT-COMPANY-NO            TO AR-COMPANY-NO.              
P0694B     MOVE WS-ZERO-DATE-MASK        TO AR-DATE-ORIG-PYMT.          
P0694B                                                                  
P0694B                                                                  
P0694B     IF PARM-ACTION-CODE = 'D'                                    
P0694B        MOVE 'PANEL147B'           TO AR-APPL-PROGRAM-ID          
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B     MOVE '01'                     TO WS-CD-COMPANY-NO.           
P0694B     MOVE '998'                    TO WS-CD-LOCAL-OFFICE.         
P0694B     MOVE '998'                    TO WS-CD-REPORT-NO.            
P0694B     MOVE WS-CURRENT-DATE          TO WS-CD-REPORT-DATE.          
P0694B     MOVE 9999                     TO WS-CASH-DRAWER-ID.          
P0694B     MOVE WS-CD-COMPANY-NO         TO AR-CASH-COMPANY-NO.         
P0694B     MOVE WS-CD-LOCAL-OFFICE       TO AR-CASH-LOCAL-OFFICE.       
P0694B     MOVE WS-CD-REPORT-NO          TO AR-CASH-REPORT-NO.          
P0694B     MOVE WS-CD-REPORT-DATE        TO AR-DATE-CASH-REPORT.        
P0694B     MOVE WS-CASH-DRAWER-ID        TO AR-CASH-DRAWER-ID.          
P0694B                                                                  
P0694B     PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
P0694B                                                                  
P0694B 2600-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B******************************************************************12280000
P0694B* 2700-CASH-DRAWER-101.                                          *12290000
P0694B*    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *12300000
P0694B******************************************************************12310000
P0694B 2700-CASH-DRAWER-101.                                            
P0694B                                                                  
P0694B     PERFORM 2800-SET-100-JRNL-VARS             THRU 2800-EXIT.   
P0694B                                                                  
P0694B     MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
P0694B                                                                  
P0694B     MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
P0694B                                                                  
P0694B     MOVE WS-AMT-POSTED           TO WS-101-AMT-POSTED            
P0694B                                     WS-JRNL-RCV-DEBIT-AMT        
P0694B                                     WS-JRNL-RCV-CREDIT-AMT.      
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        MOVE WS-BILLED-BALANCE TO WS-101-AMOUNT-ENTERED           
P0694B     ELSE                                                         
P0694B        MOVE WS-UTILITY-BALANCE     TO WS-101-AMOUNT-ENTERED      
P0694B     END-IF.                                                      
P0694B     MOVE WS-AR-AGE               TO WS-101-AR-AGE.               
P0694B     MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
P0694B     MOVE 0                       TO WS-101-ITEM-ID-NO.           
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        MOVE WS-UTILITY-BALANCE TO WS-101-DETAIL-END-BAL          
P0694B     ELSE                                                         
P0694B        SUBTRACT WS-AMT-POSTED  FROM WS-101-DETAIL-END-BAL        
P0694B     END-IF.                                                      
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        IF AU-TRAN-APPL-NO = 1                                    
P0694B           MOVE WS-BILLED-BALANCE TO WS-101-DETAIL-END-AR-BAL     
P0694B           SUBTRACT WS-AMT-POSTED FROM WS-101-DETAIL-END-AR-BAL   
P0694B        ELSE                                                      
P0694B           SUBTRACT WS-AMT-POSTED FROM WS-101-DETAIL-END-AR-BAL   
P0694B        END-IF                                                    
P0694B     ELSE                                                         
P0694B        MOVE ZEROES            TO WS-101-DETAIL-END-AR-BAL        
P0694B     END-IF.                                                      
P0694B     IF WS-101-ACCT-END-AR-BAL = 0                                
P0694B        IF AC-PYMT-PRIORITY-LVL = 50                              
P0694B           MOVE WS-BILLED-BALANCE TO WS-101-ACCT-END-AR-BAL       
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B     IF AC-PYMT-PRIORITY-LVL = 50                                 
P0694B        SUBTRACT WS-AMT-POSTED FROM WS-101-ACCT-END-AR-BAL        
P0694B     ELSE                                                         
P0694B        ADD  WS-AMT-POSTED     TO WS-101-ACCT-END-AR-BAL          
P0694B     END-IF.                                                      
P0694B     MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
P0694B     MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
P0694B     MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
P0694B     MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
P0694B     MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
P0694B     MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
P0694B*                                                                 12820000
P0694B     MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
P0694B                                                                  
P0694B     MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
P0694B     PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
P0694B                                                                  
P0694B     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT  
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B     MOVE WS-JRNL-CNTRL-ONLY      TO WS-JRNL-OPERATION-RQST.      
P0694B     PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
P0694B                                                                  
P0694B     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         PERFORM 9700-PROCESS-ABEND               THRU 9700-EXIT  
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 2700-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 13050000
P0694B****************************************************************  13060000
P0694B* 2800-SET-100-JRNL-VARS                                       *  13070000
P0694B*                                                              *  13080000
P0694B* INITIALIZE FIELDS THAT ARE REQUIRED FOR THE MISCELLANEOUS    *  13090000
P0694B* JOURNAL HEADER.                                              *  13100000
P0694B*                                                              *  13110000
P0694B****************************************************************  13120000
P0694B 2800-SET-100-JRNL-VARS.                                          
P0694B                                                                  
P0694B     MOVE '2800'               TO ACTIVE-PARAGRAPH.               
P0694B                                                                  
P0694B     MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
P0694B*******************************************************           13180000
P0694B* THESE FILEDS WERE POPULATED BY CALLING CPD00020     *           13190000
P0694B* (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *           13200000
P0694B*******************************************************           13210000
P0694B     MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
P0694B     MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
P0694B     MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
P0694B     MOVE 'C'           TO WS-TRAN-JRNL-TYPE.                     
P0694B     MOVE 'N'           TO WS-TRAN-HOLD-EXEMPT-FLAG.              
P0694B                                                                  
P0694B*******************************************************           13280000
P0694B* THESE FILEDS WERE POPULATED BY CALLING CPD00021     *           13290000
P0694B* (PARAGRAPH 5980) TO VERIFY USER-ID.                 *           13300000
P0694B*******************************************************           13310000
P0694B     MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
P0694B     MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
P0694B     PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
P0694B     MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
P0694B*                                                                 13360000
P0694B     MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.             
P0694B     MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.             
P0694B     MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.           
P0694B     MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.           
P0694B     MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.           
P0694B     MOVE SPACES               TO WS-JRNL-CURRENCY-TYPE           
P0694B                                  WS-JRNL-CODE-PYMT-FACILITY.     
P0694B     MOVE WS-TERM-LOC          TO WS-JRNL-OL-TERM-LOC             
P0694B                                  WS-JRNL-OL-CASH-LOC             
P0694B                                  WS-JRNL-OL-OPR-LOC.             
P0694B                                                                  
P0694B     MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
P0694B     MOVE 'C'                  TO WS-JRNL-SOURCE-CODE.            
P0694B     IF CASH-TRANSACTION                                          
P0694B        MOVE WS-JRNL-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE         
P0694B     ELSE                                                         
P0694B        MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
P0694B     PERFORM 6400-ONLINE-JRNL-ROUTINE      THRU 6400-EXIT.        
P0694B                                                                  
P0694B     MOVE 'A'                  TO WS-100-JRNL-SORT-ID.            
P0694B     MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.              
P0694B     MOVE AT-ACCOUNT-NO        TO WS-100-ACCT-NO.                 
P0694B     MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.             
P0694B     MOVE 0                    TO WS-100-PREMISE-NO.              
P0694B     MOVE '276B'               TO WS-100-CODE-TERMINAL-TRAN.      
P0694B     MOVE AU-TRAN-APPL-NO      TO WS-100-JRNL-TRAN-APPL-NO.       
P0694B     MOVE AT-DATE-LAST-ACTION  TO WS-100-DATE-LAST-ACTION.        
P0694B     MOVE 'C'                  TO WS-100-CODE-ENTRY-SOURCE.       
P0694B     MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.             
P0694B     MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.             
P0694B     MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.           
P0694B     MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.           
P0694B     MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.           
P0694B     MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD.         
P0694B     MOVE SPACES               TO WS-100-TRANS-ERRORS.            
P0694B                                                                  
P0694B 2800-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   13760000
P0694B* 2850-REVERSE-EPP.                                           *   13770000
P0694B*                                                             *   13780000
P0694B* REMOVE AN ACCOUNT FROM EPP AND PLACE IN UTE / UTG BASED ON  *   13790000
P0694B* PCR NUMBER 29                                               *   13800000
P0694B*                                                             *   13810000
P0694B***************************************************************   13820000
P0694B 2850-REVERSE-EPP.                                                
P0694B                                                                  
P0694B      MOVE AT-ACCOUNT-NO                   TO BG-ACCOUNT-NO       
P0694B                                              BI-ACCOUNT-NO.      
P0694B      PERFORM 7900-OPEN-BILLING-HDR-CSR    THRU 7900-EXIT.        
P0694B      PERFORM 7910-FETCH-BILLING-HDR-CSR   THRU 7910-EXIT.        
P0694B      PERFORM 7920-CLOSE-BILLING-HDR-CSR   THRU 7920-EXIT.        
P0694B      MOVE 'E'                             TO BG-CODE-UTIL-TYPE.  
P0694B      MOVE BI-BILL-NO                      TO BG-BILL-NO.         
P0694B                                                                  
P0694B      MOVE AT-LAST-NRML-BILL-NO            TO  BG-BILL-NO.        
P0694B      PERFORM 7922-READ-BILLING-DET        THRU 7922-EXIT.        
P0694B                                                                  
P0694B      PERFORM 7930-SUM-AMT-BILL-ITEM-ELE   THRU 7930-EXIT.        
P0694B      MOVE 'G'                             TO BG-CODE-UTIL-TYPE.  
P0694B      PERFORM 7940-SUM-AMT-BILL-ITEM-GAS   THRU 7940-EXIT.        
P0694B      IF  UTE-EXISTS OR UTG-EXISTS                                
P0694B          CONTINUE                                                
P0694B      ELSE                                                        
P0694B          PERFORM 2860-CHECK-MAX-BILL-DET  THRU 2860-EXIT         
P0694B      END-IF                                                      
P0694B                                                                  
P0694B      MOVE 'U'                             TO BG-CODE-UTIL-TYPE.  
P0694B      IF UTE-EXISTS AND UTG-EXISTS                                
P0694B         NEXT SENTENCE                                            
P0694B      ELSE                                                        
P0694B         PERFORM 7924-DECLARE-CUST-PLAN       THRU 7924-EXIT      
P0694B         PERFORM 7926-OPEN-CUST-PLAN          THRU 7926-EXIT      
P0694B         PERFORM 7927-FETCH-CUST-PLAN         THRU 7927-EXIT      
P0694B                                UNTIL SQLCODE = NOT-FOUND         
P0694B                                OR (UTE-EXISTS AND UTG-EXISTS)    
P0694B         PERFORM 7928-CLOSE-CUST-PLAN         THRU 7928-EXIT      
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B                                                                  
P0694B 2850-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B**************************************************************    14210000
P0694B* GETS MAX BILL NO FOR THE ACCOUNT FROM BILLING DET AND      *    14220000
P0694B* CHECKS WHETHER UTE AND UTG EXISTS FOR THE ACCOUNT          *    14230000
P0694B**************************************************************    14240000
P0694B 2860-CHECK-MAX-BILL-DET.                                         
P0694B*                                                                 14260000
P0694B     PERFORM 7935-GET-MAX-BILL                THRU 7935-EXIT.     
P0694B     IF  SQLCODE = SUCCESSFUL-CALL AND BG-BILL-NO > 0             
P0694B         PERFORM 7937-OPEN-BG-CURSOR          THRU 7937-EXIT      
P0694B         PERFORM 7938-FETCH-BG-CURSOR         THRU 7938-EXIT      
P0694B         PERFORM UNTIL SQLCODE = NOT-FOUND                        
P0694B             EVALUATE BG-CODE-UTIL-TYPE                           
P0694B                 WHEN WS-E                                        
P0694B                     SET UTE-EXISTS           TO TRUE             
P0694B                 WHEN WS-G                                        
P0694B                     SET UTG-EXISTS           TO TRUE             
P0694B                 WHEN OTHER                                       
P0694B                     CONTINUE                                     
P0694B             END-EVALUATE                                         
P0694B             PERFORM 7938-FETCH-BG-CURSOR     THRU 7938-EXIT      
P0694B         END-PERFORM                                              
P0694B         PERFORM 7939-CLOSE-BG-CURSOR         THRU 7939-EXIT      
P0694B     END-IF.                                                      
P0694B*                                                                 14440000
P0694B 2860-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B**************************************************************    14480000
P0694B* 2900-GET-PREV-DATE.                                        *    14490000
P0694B*                                                            *    14500000
P0694B* GET THREE MONTHS PREVIOUS DATE FROM THE CURRENT DATE       *    14510000
P0694B*                                                            *    14520000
P0694B**************************************************************    14530000
P0694B 2900-GET-PREV-DATE.                                              
P0694B                                                                  
P0694B     EVALUATE WS-CURRENT-MM                                       
P0694B      WHEN 1                                                      
P0694B         MOVE 10                     TO WS-PREV-MM                
P0694B         COMPUTE WS-PREV-YYYY      = WS-CURRENT-YYYY - 1          
P0694B         MOVE WS-CURRENT-DD          TO WS-PREV-DD                
P0694B      WHEN 2                                                      
P0694B         MOVE 11                     TO WS-PREV-MM                
P0694B         COMPUTE WS-PREV-YYYY      = WS-CURRENT-YYYY - 1          
P0694B         MOVE WS-CURRENT-DD          TO WS-PREV-DD                
P0694B      WHEN 3                                                      
P0694B         MOVE 12                     TO WS-PREV-MM                
P0694B         COMPUTE WS-PREV-YYYY      = WS-CURRENT-YYYY - 1          
P0694B         MOVE WS-CURRENT-DD          TO WS-PREV-DD                
P0694B      WHEN OTHER                                                  
P0694B         COMPUTE WS-PREV-MM        = WS-CURRENT-MM - 3            
P0694B         MOVE WS-CURRENT-YYYY        TO WS-PREV-YYYY              
P0694B         MOVE WS-CURRENT-DD          TO WS-PREV-DD                
P0694B     END-EVALUATE.                                                
P0694B                                                                  
P0694B 2900-EXIT.                                                       
P0694B     EXIT.                                                        
                                                                        
P00694*                                                                 14780000
P00694 3000-CHECK-ACT-ATT.                                              
P00694*                                                                 14800000
P00694     EXEC SQL                                                     
P00694         SELECT COALESCE(ATTRIBUTE_VALUE_CD, ' ')                   
P00694           INTO :YP-ATTRIBUTE-VALUE-CD                            
P00694           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P00694          WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO             
P00694            AND ATTRIBUTE_DESC       = :YP-ATTRIBUTE-DESC         
P00694                                                           
P00694                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     14810000
MFA-TR*        SELECT IFNULL(ATTRIBUTE_VALUE_CD, ' ')                   14820000
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                            14830000
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                14840000
MFA-TR*         WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO             14850000
MFA-TR*           AND ATTRIBUTE_DESC       = :YP-ATTRIBUTE-DESC         14860000
MFA-TR*         WITH UR                                                 14870000
MFA-TR*         QUERYNO 3000                                            14880000
MFA-TR*    END-EXEC.                                                    14890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 14900000
P00694     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00694                                                                  
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00694        NEXT SENTENCE                                             
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE '3000'                TO ACTIVE-PARAGRAPH            
P00694        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00694        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
P00694        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00694        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00694        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P00694     END-IF.                                                      
P00694*                                                                 15040000
P00694 3000-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 15070000
P00694***************************************************************   15080000
P00694* 3100-INSERT-ACCT-ATTR                                       *   15090000
P00694*                                                             *   15100000
P00694* INSERT RECORD IN THE ACCT ATTRIBUTE TABLE.                  *   15110000
P00694***************************************************************   15120000
P00694 3100-INSERT-ACCT-ATTR.                                           
P00694     MOVE '3100' TO ACTIVE-PARAGRAPH.                             
P00694     MOVE WS-CURRENT-TS           TO YP-CREATED-TS.               
P00694                                                                  
P00694     EXEC SQL                                                     
P00694     INSERT INTO CSS_ACCT_ATTRIBUTE                               
P00694            ( ACCOUNT_NO         ,                                
P00694              ATTRIBUTE_DESC     ,                                
P00694              ATTRIBUTE_VALUE_CD ,                                
P00694              ATTRIBUTE_VALUE_DT ,                                
P00694              ATTRIBUTE_VALUE_TX ,                                
P00694              CREATED_TS         ,                                
P00694              STATUS_CD)                                          
P00694     VALUES (:YP-ACCOUNT-NO        ,                              
P00694             :YP-ATTRIBUTE-DESC     ,                             
P00694             :YP-ATTRIBUTE-VALUE-CD ,                             
P00694             IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) ) ,                     
P00694             :YP-ATTRIBUTE-VALUE-TX ,                             
P00694             CIS.CHAR2TIMESTAMP(:YP-CREATED-TS)         ,                 
P00694             :YP-STATUS-CD)                                       
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15170000
MFA-TR*    INSERT INTO CSS_ACCT_ATTRIBUTE                               15180000
MFA-TR*           ( ACCOUNT_NO         ,                                15190000
MFA-TR*             ATTRIBUTE_DESC     ,                                15200000
MFA-TR*             ATTRIBUTE_VALUE_CD ,                                15210000
MFA-TR*             ATTRIBUTE_VALUE_DT ,                                15220000
MFA-TR*             ATTRIBUTE_VALUE_TX ,                                15230000
MFA-TR*             CREATED_TS         ,                                15240000
MFA-TR*             STATUS_CD)                                          15250000
MFA-TR*    VALUES (:YP-ACCOUNT-NO        ,                              15260000
MFA-TR*            :YP-ATTRIBUTE-DESC     ,                             15270000
MFA-TR*            :YP-ATTRIBUTE-VALUE-CD ,                             15280000
MFA-TR*            :YP-ATTRIBUTE-VALUE-DT ,                             15290000
MFA-TR*            :YP-ATTRIBUTE-VALUE-TX ,                             15300000
MFA-TR*            :YP-CREATED-TS         ,                             15310000
MFA-TR*            :YP-STATUS-CD)                                       15320000
MFA-TR*    END-EXEC.                                                    15330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694                                                                  
P00694     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P00694                     S-RETURN-CODE.                               
P00694     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00694        NEXT SENTENCE                                             
P00694     ELSE                                                         
P00694        MOVE SPACES               TO ABEND-TABLES                 
P00694        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P00694        MOVE 'INSERT'             TO ABEND-FUNCTION               
P00694        MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
P00694        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00694        MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00694        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
P00694     END-IF.                                                      
P00694                                                                  
P00694 3100-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 15510000
P00694 3200-DELETE-ACCT-ATTR.                                           
P00694                                                                  
P00694     MOVE '3200' TO ACTIVE-PARAGRAPH.                             
P00694                                                                  
P00694     EXEC SQL                                                     
P00694        DELETE FROM CSS_ACCT_ATTRIBUTE                            
P00694         WHERE ACCOUNT_NO        = :YP-ACCOUNT-NO                 
P00694           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
P00694     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694                                                                  
P00694     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00694     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00694        NEXT SENTENCE                                             
P00694     ELSE                                                         
P00694        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00694           MOVE 0 TO WS-ACTIVE-RETURN-CODE                        
P00694        ELSE                                                      
P00694           MOVE SPACES               TO ABEND-TABLES              
P00694           MOVE SPACES               TO ABEND-SQL-PREDICATES      
P00694           MOVE 'DELETE'             TO ABEND-FUNCTION            
P00694           MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                   
P00694           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
P00694           MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
P00694           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P00694        END-IF                                                    
P00694     END-IF.                                                      
P00694                                                                  
P00694 3200-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 15810000
P00694******************************************************************15820000
P00694* 4000-GET-MNTHS-RMNG-DIFF                                       *15830000
P00694*                                                                *15840000
P00694* DETERMINE THE DIFFERENCE IN THE MONTHS REMAINING.  UPDATE      *15850000
P00694* ANNIVERSARY DATE ACCORDINGLY                                   *15860000
P00694******************************************************************15870000
P00694*                                                                 15880000
P00694 4000-GET-MNTHS-RMNG-DIFF.                                        
P00694*                                                                 15900000
P00694     MOVE ZEROES                     TO WS-MNTHS-RMNG-DIFF.       
P00694*                                                                 15920000
P00694     IF WS-MON-REMAIN < WS-BBP-TERM                               
P00694        COMPUTE WS-MNTHS-RMNG-DIFF = WS-BBP-TERM                  
P00694                                   - WS-MON-REMAIN                
P00694        EXEC SQL                                                  
P00694           SELECT
              DATEADD( MONTH, -:WS-MNTHS-RMNG-DIFF, 
              IIF(TRY_CONVERT(DATE, :WS-NEW-ANNIV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-ANNIV-DATE
              ) <> 0) OR (LEN(:WS-NEW-ANNIV-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-ANNIV-DATE
              ), CONVERT(DATE, :WS-NEW-ANNIV-DATE) ) )
            INTO
              :WS-NEW-ANNIV-DATE         
P00694        END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                  15960000
MFA-TR*          SET :WS-NEW-ANNIV-DATE = DATE(:WS-NEW-ANNIV-DATE)      15970000
MFA-TR*                       - INT(:WS-MNTHS-RMNG-DIFF) MONTHS         15980000
MFA-TR*       END-EXEC                                                  15990000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
P00694     ELSE                                                         
P00694        IF WS-MON-REMAIN > WS-BBP-TERM                            
P00694           COMPUTE WS-MNTHS-RMNG-DIFF = WS-MON-REMAIN             
P00694                                      - WS-BBP-TERM               
P00694           EXEC SQL                                               
P00694              SELECT
              DATEADD( MONTH, :WS-MNTHS-RMNG-DIFF, 
              IIF(TRY_CONVERT(DATE, :WS-NEW-ANNIV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-ANNIV-DATE
              ) <> 0) OR (LEN(:WS-NEW-ANNIV-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-ANNIV-DATE
              ), CONVERT(DATE, :WS-NEW-ANNIV-DATE) ) )
            INTO
              :WS-NEW-ANNIV-DATE         
P00694           END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*          EXEC SQL                                               16040000
MFA-TR*             SET :WS-NEW-ANNIV-DATE = DATE(:WS-NEW-ANNIV-DATE)   16050000
MFA-TR*                       + INT(:WS-MNTHS-RMNG-DIFF) MONTHS         16060000
MFA-TR*          END-EXEC                                               16070000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                               
P00694        END-IF                                                    
P00694     END-IF.                                                      
                                                                        
ACT001*    GET NEW START DATE TO UPDATE IN BUDGET PLAN TABLE            16090208
ACT001     EXEC SQL                                                     
ACT001        SELECT
              DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEW-ANNIV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-ANNIV-DATE
              ) <> 0) OR (LEN(:WS-NEW-ANNIV-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-ANNIV-DATE
              ), CONVERT(DATE, :WS-NEW-ANNIV-DATE) ) )
            INTO
              :WS-NEW-START-DATE                                   
ACT001     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     16091008
MFA-TR*       SET :WS-NEW-START-DATE = DATE(:WS-NEW-ANNIV-DATE)         16092008
MFA-TR*                   - 11 MONTHS                                   16093016
MFA-TR*    END-EXEC                                                     16094019

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 16100000
P00694     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00694     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00694        MOVE WS-NEW-ANNIV-DATE       TO BU-ANNIVERSARY-DATE       
ACT001        MOVE WS-NEW-START-DATE       TO BU-DATE-PYMT-STRT         
ACT001        MOVE WS-NEW-START-DATE       TO BH-DATE-PYMT-STRT         
P00694     ELSE                                                         
P00694        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00694           MOVE 0 TO WS-ACTIVE-RETURN-CODE                        
P00694        ELSE                                                      
P00694           MOVE '4000'               TO ACTIVE-PARAGRAPH          
P00694           MOVE SPACES               TO ABEND-TABLES              
P00694           MOVE SPACES               TO ABEND-SQL-PREDICATES      
P00694           MOVE 'SET'                TO ABEND-FUNCTION            
P00694           MOVE SPACES               TO TABLE-1                   
P00694           MOVE SPACES               TO TABLE-ELEMENT-1           
P00694           MOVE SPACES               TO HOSTVAR-ELEMENT-1         
P00694           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P00694        END-IF                                                    
P00694     END-IF.                                                      
P00694*                                                                 16280000
P00694*                                                                 16290000
P00694 4000-EXIT.                                                       
P00694     EXIT.                                                        
      ******************************************************************16320000
      *   6530-LOAD-MNT-TRANS-HIST                                     *16330000
      ******************************************************************16340000
      *                                                                 16350000
           EXEC SQL                                                     16360000
              INCLUDE CPD00067                                          16370000
           END-EXEC.                                                    16380000
      *                                                                 16390000
P0694B******************************************************************16400000
P0694B*   6400-ONLINE-JRNL-ROUTINE                                     *16410000
P0694B******************************************************************16420000
P0694B*                                                                 16430000
P0694B     EXEC SQL                                                     16440000
P0694B        INCLUDE CPD0006A                                          16450000
P0694B     END-EXEC.                                                    16460000
P0694B*                                                                 16470000
P0694B******************************************************************16480000
P0694B*   6500-ONLINE-LOAD-AR-TRAN-HIST                                *16490000
P0694B******************************************************************16500000
P0694B*                                                                 16510000
P0694B     EXEC SQL                                                     16520000
P0694B        INCLUDE CPD00008                                          16530000
P0694B     END-EXEC.                                                    16540000
P0694B*                                                                 16550000
      ******************************************************************16560000
      * 7000-GET-CURRENT-TS.                                           *16570000
      ******************************************************************16580000
      *                                                                 16590000
       7000-GET-CURRENT-TS.                                             
      *                                                                 16610000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TS,
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16620000
MFA-TR*       SET :WS-CURRENT-TS   = CURRENT TIMESTAMP                  16630000
MFA-TR*          ,:WS-CURRENT-DATE = CURRENT DATE                       16640000
MFA-TR*    END-EXEC.                                                    16650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7000'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 16790000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16820000
P0694B******************************************************************16830000
P0694B* 7020-SELECT-BILLING-DET.                                       *16840000
P0694B*                                                                *16850000
P0694B*                                                                *16860000
P0694B******************************************************************16870000
P0694B 7020-SELECT-BILLING-DET.                                         
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B        SELECT MAX(REVENUE_MONTH)                                 
P0694B          INTO :WS-REVENUE-MONTH :WS-REVENUE-MONTH-NULL2           
P0694B          FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
P0694B         WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO                 
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16900000
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                 16910000
MFA-TR*         INTO :WS-REVENUE-MONTH:WS-REVENUE-MONTH-NULL2           16920000
MFA-TR*         FROM CSS_BILLING_DET                                    16930000
MFA-TR*        WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO                 16940000
MFA-TR*        WITH UR                                                  16950000
MFA-TR*        QUERYNO 7020                                             16960000
MFA-TR*    END-EXEC.                                                    16970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0694B        IF WS-REVENUE-MONTH-NULL2 < 0 OR WS-REVENUE-MONTH = 0     
P0694B           PERFORM 7730-READ-BILL-WINDOW   THRU 7730-EXIT         
P0694B        END-IF                                                    
P0694B     ELSE                                                         
P0694B        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
P0694B        MOVE '7020'          TO ACTIVE-PARAGRAPH                  
P0694B        MOVE 'SELECT'             TO ABEND-FUNCTION               
P0694B        MOVE 'CSS_BILLING_DET'    TO TABLE-1                      
P0694B        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P0694B        MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
P0694B        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7020-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 17170000
P0694B 7030-SELECT-REV-MTH.                                             
P0694B*                                                                 17190000
P0694B     EXEC SQL                                                     
P0694B      SELECT TOP(1) REVENUE_MONTH                                        
P0694B       INTO  :WS-REVENUE-MONTH                                    
P0694B       FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
P0694B       WHERE DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)           
P0694B         AND CODE_BILL_COND   = 'R'                               
P0694B       ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  
P0694B                                       
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     17200000
MFA-TR*     SELECT REVENUE_MONTH                                        17210000
MFA-TR*      INTO  :WS-REVENUE-MONTH                                    17220000
MFA-TR*      FROM CSS_BILL_WINDOW                                       17230000
MFA-TR*      WHERE DATE_EXTRACT  >= CURRENT DATE                        17240000
MFA-TR*        AND CODE_BILL_COND   = 'R'                               17250000
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  17260000
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               17270000
MFA-TR*      QUERYNO 7030                                               17280000
MFA-TR*    END-EXEC.                                                    17290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B*                                                                 17300000
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B*                                                                 17330000
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0694B        MOVE '7030'               TO ACTIVE-PARAGRAPH             
P0694B        MOVE 'SELECT'             TO ABEND-FUNCTION               
P0694B        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
P0694B        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P0694B        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P0694B        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P0694B     END-IF.                                                      
P0694B*                                                                 17450000
P0694B 7030-EXIT.                                                       
P0694B     EXIT.                                                        
      *                                                                 17480000
      ******************************************************************17490000
      *  7100-SEL-BUDGET-HIST                                          *17500000
      ******************************************************************17510000
      *                                                                 17520000
       7100-SEL-BUDGET-HIST.                                            
      *                                                                 17540000
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO,
              PYMT_PRIORITY_LVL,
              ITEM_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), BUD_HIST_SEQ_NO, 121), 
           ' ', '-'), ':', '.') BUD_HIST_SEQ_NO,
              AMT_MO_PYMT,
              DATE_PYMT_STRT,
              UTILITY_BALANCE,
              BALANCE_FORWARD,
              EPP_ESTIMATE,
              METHOD_OF_ESTIMATE,
              CHANGE_REASON,
              EPP_MTHS_RMNG_QT,
              REMARKS,
              BUDG_BILL_PREV_AMT                                
                 INTO :BH-ACCOUNT-NO                                    
                     ,:BH-PYMT-PRIORITY-LVL                             
                     ,:BH-ITEM-ID                                       
                     ,:BH-BUD-HIST-SEQ-NO                               
                     ,:BH-AMT-MO-PYMT                                   
                     ,:BH-DATE-PYMT-STRT                                
                     ,:BH-UTILITY-BALANCE                               
                     ,:BH-BALANCE-FORWARD                               
                     ,:BH-EPP-ESTIMATE                                  
                     ,:BH-METHOD-OF-ESTIMATE                            
                     ,:BH-CHANGE-REASON                                 
                     ,:BH-EPP-MTHS-RMNG-QT                              
                     ,:BH-REMARKS                                       
                     ,:BH-BUDG-BILL-PREV-AMT                            
                 FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                
A03300            AND CHANGE_REASON     IN ('M','A','S','C')            
A03300          ORDER BY BUD_HIST_SEQ_NO DESC                           
A03300                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17550000
MFA-TR*        SELECT ACCOUNT_NO                                        17560000
MFA-TR*              ,PYMT_PRIORITY_LVL                                 17570000
MFA-TR*              ,ITEM_ID                                           17580000
MFA-TR*              ,BUD_HIST_SEQ_NO                                   17590000
MFA-TR*              ,AMT_MO_PYMT                                       17600000
MFA-TR*              ,DATE_PYMT_STRT                                    17610000
MFA-TR*              ,UTILITY_BALANCE                                   17620000
MFA-TR*              ,BALANCE_FORWARD                                   17630000
MFA-TR*              ,EPP_ESTIMATE                                      17640000
MFA-TR*              ,METHOD_OF_ESTIMATE                                17650000
MFA-TR*              ,CHANGE_REASON                                     17660000
MFA-TR*              ,EPP_MTHS_RMNG_QT                                  17670000
MFA-TR*              ,REMARKS                                           17680000
MFA-TR*              ,BUDG_BILL_PREV_AMT                                17690000
MFA-TR*          INTO :BH-ACCOUNT-NO                                    17700000
MFA-TR*              ,:BH-PYMT-PRIORITY-LVL                             17710000
MFA-TR*              ,:BH-ITEM-ID                                       17720000
MFA-TR*              ,:BH-BUD-HIST-SEQ-NO                               17730000
MFA-TR*              ,:BH-AMT-MO-PYMT                                   17740000
MFA-TR*              ,:BH-DATE-PYMT-STRT                                17750000
MFA-TR*              ,:BH-UTILITY-BALANCE                               17760000
MFA-TR*              ,:BH-BALANCE-FORWARD                               17770000
MFA-TR*              ,:BH-EPP-ESTIMATE                                  17780000
MFA-TR*              ,:BH-METHOD-OF-ESTIMATE                            17790000
MFA-TR*              ,:BH-CHANGE-REASON                                 17800000
MFA-TR*              ,:BH-EPP-MTHS-RMNG-QT                              17810000
MFA-TR*              ,:BH-REMARKS                                       17820000
MFA-TR*              ,:BH-BUDG-BILL-PREV-AMT                            17830000
MFA-TR*          FROM CSS_BUDGET_HIST                                   17840000
MFA-TR*         WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                17850000
MFA-TR*           AND CHANGE_REASON     IN ('M','A','S','C')            17860000
MFA-TR*         ORDER BY BUD_HIST_SEQ_NO DESC                           17870000
MFA-TR*         FETCH FIRST 1 ROW ONLY                                  17880000
MFA-TR*          WITH UR                                                17890000
MFA-TR*       QUERYNO 7100                                              17900000
MFA-TR*    END-EXEC.                                                    17910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17920000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 17940000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 18080000
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************18110000
      *  7150-SEL-BUDGET-PLAN                                          *18120000
      ******************************************************************18130000
P00694*                                                                 18140000
P00694 7150-SEL-BUDGET-PLAN.                                            
P00694*                                                                 18160000
P00694     EXEC SQL                                                     
P00694         SELECT ANNIVERSARY_DATE                                  
P00694           INTO :BU-ANNIVERSARY-DATE                              
P00694           FROM CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                     
P00694          WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                
P00694                                                           
P00694                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18170000
MFA-TR*        SELECT ANNIVERSARY_DATE                                  18180000
MFA-TR*          INTO :BU-ANNIVERSARY-DATE                              18190000
MFA-TR*          FROM CSS_BUDGET_PLAN                                   18200000
MFA-TR*         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                18210000
MFA-TR*          WITH UR                                                18220000
MFA-TR*       QUERYNO 7150                                              18230000
MFA-TR*    END-EXEC.                                                    18240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 18250000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00694*                                                                 18270000
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        CONTINUE                                                  
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE '7150'                TO ACTIVE-PARAGRAPH            
P00694        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00694        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00694                                      ABEND-TABLES                
P00694        MOVE 'CSS_BUDGET_PLAN'     TO TABLE-1                     
P00694        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00694        MOVE BU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 18410000
P00694 7150-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 18440000
P0694B***************************************************************   18450000
P0694B* 7200-SELECT-ACCOUNT.                                        *   18460000
P0694B*                                                             *   18470000
P0694B* FETCH DETAILS FROM THE ACCOUNT TABLE                        *   18480000
P0694B*                                                             *   18490000
P0694B***************************************************************   18500000
P0694B 7200-SELECT-ACCOUNT.                                             
P0694B                                                                  
P0694B     MOVE '7200' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B      SELECT CODE_COMPANY_ACCT                                    
P0694B            ,DATE_LAST_ACTION                                     
P0694B            ,CODE_ACCT_STAT                                       
P0694B            ,COMPANY_NO                                           
P0694B            ,PREMISE_NO                                           
P0694B            ,TOTAL_AR_BALANCE                                     
P0694B            ,CUSTOMER_NO                                          
P0694B            ,CODES_DATA_PRESENT                                   
P0694B            ,LOCAL_OFFICE                                         
P0694B            ,CREDIT_GROUP                                         
P0694B            ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
P0694B            ,ELEC_REV_ALLOC_PCT                                   
P0694B            ,REV_MTH_LST_NRML                                     
P0694B            ,BILL_CYCLE                                           
P0694B            ,CODE_TEMP_BILL                                       
P0694B            ,DATE_BILL_DAY_00                                     
P0694B            ,ACCOUNT_TYPE_CODE                                    
P0694B            ,LAST_NRML_BILL_NO                                    
P0694B        INTO :AT-CODE-COMPANY-ACCT                                
P0694B            ,:AT-DATE-LAST-ACTION                                 
P0694B            ,:AT-CODE-ACCT-STAT                                   
P0694B            ,:AT-COMPANY-NO                                       
P0694B            ,:AT-PREMISE-NO                                       
P0694B            ,:AT-TOTAL-AR-BALANCE                                 
P0694B            ,:AT-CUSTOMER-NO                                      
P0694B            ,:AT-CODES-DATA-PRESENT                               
P0694B            ,:AT-LOCAL-OFFICE                                     
P0694B            ,:AT-CREDIT-GROUP                                     
P0694B            ,:AT-LAST-UPDATE-TS                                   
P0694B            ,:AT-ELEC-REV-ALLOC-PCT                               
P0694B            ,:AT-REV-MTH-LST-NRML :WS-REVENUE-MONTH-NULL           
P0694B            ,:AT-BILL-CYCLE                                       
P0694B            ,:AT-CODE-TEMP-BILL                                   
P0694B            ,:AT-DATE-BILL-DAY-00                                 
P0694B            ,:AT-ACCOUNT-TYPE-CODE                                
P0694B            ,:AT-LAST-NRML-BILL-NO                                
P0694B        FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
P0694B       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                         
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     18550000
MFA-TR*     SELECT CODE_COMPANY_ACCT                                    18560000
MFA-TR*           ,DATE_LAST_ACTION                                     18570000
MFA-TR*           ,CODE_ACCT_STAT                                       18580000
MFA-TR*           ,COMPANY_NO                                           18590000
MFA-TR*           ,PREMISE_NO                                           18600000
MFA-TR*           ,TOTAL_AR_BALANCE                                     18610000
MFA-TR*           ,CUSTOMER_NO                                          18620000
MFA-TR*           ,CODES_DATA_PRESENT                                   18630000
MFA-TR*           ,LOCAL_OFFICE                                         18640000
MFA-TR*           ,CREDIT_GROUP                                         18650000
MFA-TR*           ,LAST_UPDATE_TS                                       18660000
MFA-TR*           ,ELEC_REV_ALLOC_PCT                                   18670000
MFA-TR*           ,REV_MTH_LST_NRML                                     18680000
MFA-TR*           ,BILL_CYCLE                                           18690000
MFA-TR*           ,CODE_TEMP_BILL                                       18700000
MFA-TR*           ,DATE_BILL_DAY_00                                     18710000
MFA-TR*           ,ACCOUNT_TYPE_CODE                                    18720000
MFA-TR*           ,LAST_NRML_BILL_NO                                    18730000
MFA-TR*       INTO :AT-CODE-COMPANY-ACCT                                18740000
MFA-TR*           ,:AT-DATE-LAST-ACTION                                 18750000
MFA-TR*           ,:AT-CODE-ACCT-STAT                                   18760000
MFA-TR*           ,:AT-COMPANY-NO                                       18770000
MFA-TR*           ,:AT-PREMISE-NO                                       18780000
MFA-TR*           ,:AT-TOTAL-AR-BALANCE                                 18790000
MFA-TR*           ,:AT-CUSTOMER-NO                                      18800000
MFA-TR*           ,:AT-CODES-DATA-PRESENT                               18810000
MFA-TR*           ,:AT-LOCAL-OFFICE                                     18820000
MFA-TR*           ,:AT-CREDIT-GROUP                                     18830000
MFA-TR*           ,:AT-LAST-UPDATE-TS                                   18840000
MFA-TR*           ,:AT-ELEC-REV-ALLOC-PCT                               18850000
MFA-TR*           ,:AT-REV-MTH-LST-NRML:WS-REVENUE-MONTH-NULL           18860000
MFA-TR*           ,:AT-BILL-CYCLE                                       18870000
MFA-TR*           ,:AT-CODE-TEMP-BILL                                   18880000
MFA-TR*           ,:AT-DATE-BILL-DAY-00                                 18890000
MFA-TR*           ,:AT-ACCOUNT-TYPE-CODE                                18900000
MFA-TR*           ,:AT-LAST-NRML-BILL-NO                                18910000
MFA-TR*       FROM CSS_ACCOUNT                                          18920000
MFA-TR*      WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                         18930000
MFA-TR*      WITH UR                                                    18940000
MFA-TR*      QUERYNO 7200                                               18950000
MFA-TR*    END-EXEC.                                                    18960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B                                                                  
P0694B     IF WS-REVENUE-MONTH-NULL < 0                                 
P0694B        MOVE +0              TO AT-REV-MTH-LST-NRML               
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B           NEXT SENTENCE                                          
P0694B     ELSE                                                         
P0694B        MOVE SPACES         TO ABEND-TABLES                       
P0694B        MOVE SPACES         TO ABEND-SQL-PREDICATES               
P0694B        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
P0694B        MOVE 'SELECT'       TO ABEND-FUNCTION                     
P0694B        MOVE 'CSS_ACCOUNT'  TO TABLE-1                            
P0694B        MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
P0694B        MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
P0694B        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7200-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   19210000
P0694B* 7250-SELECT-PREMISE.                                        *   19220000
P0694B*                                                             *   19230000
P0694B* FETCH DETAILS FROM THE PREMISE TABLE                        *   19240000
P0694B*                                                             *   19250000
P0694B***************************************************************   19260000
P0694B 7250-SELECT-PREMISE.                                             
P0694B                                                                  
P0694B     MOVE '7250'                        TO ACTIVE-PARAGRAPH.      
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B     SELECT  CODE_PREMISE_STAT,                                   
P0694B             REV_DISTRICT_CD,                                     
P0694B             LOCAL_OFFICE,                                        
P0694B             GAS_AVAILABLE_IND,                                   
P0694B             ELEC_AVAILABLE_IND                                   
P0694B     INTO    :PR-CODE-PREMISE-STAT,                               
P0694B             :PR-REV-DISTRICT-CD,                                 
P0694B             :PR-LOCAL-OFFICE,                                    
P0694B             :PR-GAS-AVAILABLE-IND,                               
P0694B             :PR-ELEC-AVAILABLE-IND                               
P0694B     FROM    CSS_PREMISE WITH(READUNCOMMITTED)                            
P0694B     WHERE   PREMISE_NO = :AT-PREMISE-NO                          
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19310000
MFA-TR*    SELECT  CODE_PREMISE_STAT,                                   19320000
MFA-TR*            REV_DISTRICT_CD,                                     19330000
MFA-TR*            LOCAL_OFFICE,                                        19340000
MFA-TR*            GAS_AVAILABLE_IND,                                   19350000
MFA-TR*            ELEC_AVAILABLE_IND                                   19360000
MFA-TR*    INTO    :PR-CODE-PREMISE-STAT,                               19370000
MFA-TR*            :PR-REV-DISTRICT-CD,                                 19380000
MFA-TR*            :PR-LOCAL-OFFICE,                                    19390000
MFA-TR*            :PR-GAS-AVAILABLE-IND,                               19400000
MFA-TR*            :PR-ELEC-AVAILABLE-IND                               19410000
MFA-TR*    FROM    CSS_PREMISE                                          19420000
MFA-TR*    WHERE   PREMISE_NO = :AT-PREMISE-NO                          19430000
MFA-TR*    WITH UR                                                      19440000
MFA-TR*    QUERYNO 7250                                                 19450000
MFA-TR*    END-EXEC.                                                    19460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
P0694B        WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P0694B           NEXT SENTENCE                                          
P0694B       ELSE                                                       
P0694B         MOVE SPACES          TO ABEND-TABLES                     
P0694B         MOVE SPACES          TO ABEND-SQL-PREDICATES             
P0694B         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
P0694B         MOVE 'SELECT'        TO ABEND-FUNCTION                   
P0694B         MOVE 'CSS_PREMISE'   TO TABLE-1                          
P0694B         MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1                  
P0694B         MOVE AT-PREMISE-NO   TO HOSTVAR-ELEMENT-1                
P0694B         MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2                  
P0694B         MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2                
P0694B         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7250-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B                                                                  
P0694B***************************************************************   19700000
P0694B* 7275-SELECT-CUSTOMER.                                       *   19710000
P0694B*                                                             *   19720000
P0694B* FETCH DETAILS FROM THE CUSTOMER TABLE                       *   19730000
P0694B*                                                             *   19740000
P0694B***************************************************************   19750000
P0694B 7275-SELECT-CUSTOMER.                                            
P0694B                                                                  
P0694B     MOVE '7275' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B        SELECT CODE_EMPL_ACCT, CODE_CUST_STATUS                   
P0694B          INTO :CU-CODE-EMPL-ACCT, :CU-CODE-CUST-STATUS           
P0694B          FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
P0694B         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19800000
MFA-TR*       SELECT CODE_EMPL_ACCT, CODE_CUST_STATUS                   19810000
MFA-TR*         INTO :CU-CODE-EMPL-ACCT, :CU-CODE-CUST-STATUS           19820000
MFA-TR*         FROM CSS_CUSTOMER                                       19830000
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      19840000
MFA-TR*        WITH UR                                                  19850000
MFA-TR*        QUERYNO 7275                                             19860000
MFA-TR*    END-EXEC.                                                    19870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B           NEXT SENTENCE                                          
P0694B     ELSE                                                         
P0694B         MOVE SPACES          TO ABEND-TABLES                     
P0694B         MOVE SPACES          TO ABEND-SQL-PREDICATES             
P0694B         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
P0694B         MOVE 'SELECT'        TO ABEND-FUNCTION                   
P0694B         MOVE 'CSS_CUSTOMER'  TO TABLE-1                          
P0694B         MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                  
P0694B         MOVE AT-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1                
P0694B         MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2                  
P0694B         MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2                
P0694B         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7275-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   20090000
P0694B* 7300-SELECT-AR-CNTL.                                        *   20100000
P0694B*                                                             *   20110000
P0694B* FETCH CONTROL RECORD FROM THE AR CONTROL TABLE.             *   20120000
P0694B***************************************************************   20130000
P0694B 7300-SELECT-AR-CNTL.                                             
P0694B                                                                  
P0694B     MOVE '7300' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B         SELECT AMT_AR_DAY_00, AMT_AR_DAY_30,                     
P0694B                AMT_AR_DAY_60, AMT_AR_DAY_90,                     
P0694B                AMT_UNUSED_CR, TOT_SUMM_UNBILLED,                 
P0694B                AMT_TRAN_BALANCE                                  
P0694B           INTO :AC-AMT-AR-DAY-00,   :AC-AMT-AR-DAY-30,           
P0694B                :AC-AMT-AR-DAY-60,   :AC-AMT-AR-DAY-90,           
P0694B                :AC-AMT-UNUSED-CR,   :AC-TOT-SUMM-UNBILLED,       
P0694B                :AC-AMT-TRAN-BALANCE                              
P0694B           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P0694B          WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO AND            
P0694B                PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND     
P0694B                ITEM_ID           = :AC-ITEM-ID                   
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20180000
MFA-TR*        SELECT AMT_AR_DAY_00, AMT_AR_DAY_30,                     20190000
MFA-TR*               AMT_AR_DAY_60, AMT_AR_DAY_90,                     20200000
MFA-TR*               AMT_UNUSED_CR, TOT_SUMM_UNBILLED,                 20210000
MFA-TR*               AMT_TRAN_BALANCE                                  20220000
MFA-TR*          INTO :AC-AMT-AR-DAY-00,   :AC-AMT-AR-DAY-30,           20230000
MFA-TR*               :AC-AMT-AR-DAY-60,   :AC-AMT-AR-DAY-90,           20240000
MFA-TR*               :AC-AMT-UNUSED-CR,   :AC-TOT-SUMM-UNBILLED,       20250000
MFA-TR*               :AC-AMT-TRAN-BALANCE                              20260000
MFA-TR*          FROM CSS_AR_CNTL                                       20270000
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO AND            20280000
MFA-TR*               PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND     20290000
MFA-TR*               ITEM_ID           = :AC-ITEM-ID                   20300000
MFA-TR*         WITH UR                                                 20310000
MFA-TR*         QUERYNO 7300                                            20320000
MFA-TR*    END-EXEC.                                                    20330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
P0694B             MOVE 0     TO AC-AMT-AR-DAY-00                       
P0694B                           AC-AMT-AR-DAY-30                       
P0694B                           AC-AMT-AR-DAY-60                       
P0694B                           AC-AMT-AR-DAY-90                       
P0694B                           AC-AMT-UNUSED-CR                       
P0694B                           AC-TOT-SUMM-UNBILLED                   
P0694B         ELSE                                                     
P0694B             MOVE SPACES                TO ABEND-TABLES           
P0694B             MOVE SPACES                TO ABEND-SQL-PREDICATES   
P0694B             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P0694B             MOVE 'SELECT'              TO ABEND-FUNCTION         
P0694B             MOVE 'CSS_AR_CNTL'         TO TABLE-1                
P0694B             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
P0694B             MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2        
P0694B             MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3        
P0694B             MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
P0694B             MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2      
P0694B             MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3      
P0694B             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0694B         END-IF                                                   
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7300-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   20660000
P0694B* 7400-SELECT-USER-PROFILE.                                   *   20670000
P0694B*                                                             *   20680000
P0694B* FETCH RESP-AREA-ID FOR USER.                                *   20690000
P0694B***************************************************************   20700000
P0694B 7400-SELECT-USER-PROFILE.                                        
P0694B                                                                  
P0694B     MOVE '7400' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B         SELECT RESP_AREA_ID                                      
P0694B           INTO :PF-RESP-AREA-ID                                  
P0694B           FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
P0694B          WHERE USER_ID           = :PF-USER-ID                   
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20750000
MFA-TR*        SELECT RESP_AREA_ID                                      20760000
MFA-TR*          INTO :PF-RESP-AREA-ID                                  20770000
MFA-TR*          FROM CSS_USER_PROFILE                                  20780000
MFA-TR*         WHERE USER_ID           = :PF-USER-ID                   20790000
MFA-TR*         WITH UR                                                 20800000
MFA-TR*         QUERYNO 7400                                            20810000
MFA-TR*    END-EXEC.                                                    20820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        MOVE SPACES                TO ABEND-TABLES                
P0694B        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0694B        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0694B        MOVE 'SELECT'              TO ABEND-FUNCTION              
P0694B        MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
P0694B        MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
P0694B        MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1           
P0694B        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7400-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   21020000
P0694B* 7500-SELECT-GL-NAME.                                        *   21030000
P0694B*                                                             *   21040000
P0694B* GET THE GL NAME.                                            *   21050000
P0694B***************************************************************   21060000
P0694B 7500-SELECT-GL-NAME.                                             
P0694B                                                                  
P0694B     MOVE '7500' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B        SELECT GL_ACCT_NO                                         
P0694B        INTO   :GO-GL-ACCT-NO                                     
P0694B        FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
P0694B        WHERE  COMPANY_NO   = '01' AND                            
P0694B               GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21110000
MFA-TR*       SELECT GL_ACCT_NO                                         21120000
MFA-TR*       INTO   :GO-GL-ACCT-NO                                     21130000
MFA-TR*       FROM   CSS_GL_ACCT_NO                                     21140000
MFA-TR*       WHERE  COMPANY_NO   = '01' AND                            21150000
MFA-TR*              GL_ACCT_NAME = :GO-GL-ACCT-NAME                    21160000
MFA-TR*       WITH UR                                                   21170000
MFA-TR*       QUERYNO 7500                                              21180000
MFA-TR*    END-EXEC.                                                    21190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B        IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
P0694B           MOVE ZEROES     TO GO-GL-ACCT-NO                       
P0694B        ELSE                                                      
P0694B           MOVE SPACES           TO ABEND-TABLES                  
P0694B           MOVE SPACES           TO ABEND-SQL-PREDICATES          
P0694B           MOVE PROGRAM-NAME     TO ABEND-PROGRAM                 
P0694B           MOVE 'SELECT'         TO ABEND-FUNCTION                
P0694B           MOVE 'CSS_GL_ACCT_NO' TO TABLE-1                       
P0694B           MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-1               
P0694B           MOVE 'GL_ACCT_NAME'   TO TABLE-ELEMENT-2               
P0694B           MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-3               
P0694B           MOVE AT-COMPANY-NO    TO HOSTVAR-ELEMENT-1             
P0694B           MOVE GO-GL-ACCT-NAME  TO HOSTVAR-ELEMENT-2             
P0694B           MOVE PARM-ACCOUNT-NO  TO HOSTVAR-ELEMENT-3             
P0694B           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7500-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B 7730-READ-BILL-WINDOW.                                           
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B      SELECT MAX(REVENUE_MONTH)                                   
P0694B       INTO  :WS-REVENUE-MONTH :WS-REVENUE-MONTH-NULL              
P0694B       FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
P0694B       WHERE DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() AS DATE)            
P0694B       AND BILL_CYCLE      = :AT-BILL-CYCLE                       
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     21490000
MFA-TR*     SELECT MAX(REVENUE_MONTH)                                   21500000
MFA-TR*      INTO  :WS-REVENUE-MONTH:WS-REVENUE-MONTH-NULL              21510000
MFA-TR*      FROM CSS_BILL_WINDOW                                       21520000
MFA-TR*      WHERE DATE_EXTRACT <= CURRENT DATE                         21530000
MFA-TR*      AND BILL_CYCLE      = :AT-BILL-CYCLE                       21540000
MFA-TR*      WITH UR                                                    21550000
MFA-TR*      QUERYNO 7730                                               21560000
MFA-TR*    END-EXEC.                                                    21570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0694B                                                                  
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P0694B        MOVE '7730'              TO ACTIVE-PARAGRAPH              
P0694B        MOVE 'SELECT'            TO ABEND-FUNCTION                
P0694B        MOVE SPACES              TO ABEND-SQL-PREDICATES          
P0694B                                    ABEND-TABLES                  
P0694B        MOVE 'CSS_BILL_WINDOW'   TO TABLE-1                       
P0694B        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
P0694B        MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
P0694B        MOVE 'BILL_CYCLE'        TO TABLE-ELEMENT-2               
P0694B        MOVE AT-BILL-CYCLE       TO HOSTVAR-ELEMENT-2             
P0694B        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0694B     END-IF.                                                      
P0694B 7730-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B                                                                  
P0694B******************************************************************21800000
P0694B* 7760-GET-BBP-TERM.                                             *21810000
P0694B******************************************************************21820000
P0694B*                                                                 21830000
P0694B 7760-GET-BBP-TERM.                                               
P0694B*                                                                 21850000
P0694B     EXEC SQL                                                     
P0694B        SELECT
              (SELECT IIF(TRY_CAST(E AS INT) IS NULL, CIS.INTEGER(E), 
              CAST(E AS INT)) FROM (SELECT CIS.MONTHS_BETWEEN(
              IIF(TRY_CONVERT(DATE, :BU-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :BU-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:BU-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:BU-ANNIVERSARY-DATE
              ), CONVERT(DATE, :BU-ANNIVERSARY-DATE) ),        
P0694B                               IIF(TRY_CONVERT(DATE, 
                                                :WS-MONTN-LST-NRML-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MONTN-LST-NRML-DATE
              ) <> 0) OR (LEN(:WS-MONTN-LST-NRML-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-MONTN-LST-NRML-DATE
              ), CONVERT(DATE, :WS-MONTN-LST-NRML-DATE) )) E) T)
            INTO
              :WS-BBP-TERM    
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     21860000
MFA-TR*       SET :WS-BBP-TERM =                                        21870000
MFA-TR*           INT(MONTHS_BETWEEN(DATE(:BU-ANNIVERSARY-DATE),        21880000
MFA-TR*                              DATE(:WS-MONTN-LST-NRML-DATE)))    21890000
MFA-TR*    END-EXEC.                                                    21900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B*                                                                 21910000
P0694B     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P0694B                                      S-RETURN-CODE.              
P0694B*                                                                 21940000
P0694B     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0694B         WHEN SUCCESSFUL-CALL                                     
P0694B              CONTINUE                                            
P0694B         WHEN OTHER                                               
P0694B              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P0694B              MOVE '7760'                TO ACTIVE-PARAGRAPH      
P0694B              MOVE 'SELECT'              TO ABEND-FUNCTION        
P0694B              MOVE SPACES                TO ABEND-SQL-PREDICATES  
P0694B                                            ABEND-TABLES          
P0694B              MOVE 'DATE_COMPUTATION'    TO TABLE-1               
P0694B              MOVE 'ANNIV_DATE'          TO TABLE-ELEMENT-1       
P0694B              MOVE BU-ANNIVERSARY-DATE   TO HOSTVAR-ELEMENT-1     
P0694B              MOVE 'LAST BILL DATE'      TO TABLE-ELEMENT-2       
P0694B              MOVE WS-MON-LST-NRML-DATE  TO HOSTVAR-ELEMENT-2     
P0694B              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P0694B     END-EVALUATE.                                                
P0694B*                                                                 22110000
P0694B 7760-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 22140000
P0694B***************************************************************   22150000
P0694B* 7900-OPEN-BILLING-HDR-CSR.                                  *   22160000
P0694B*                                                             *   22170000
P0694B* OPEN BILLING HEADER CURSOR                                  *   22180000
P0694B***************************************************************   22190000
P0694B 7900-OPEN-BILLING-HDR-CSR.                                       
P0694B                                                                  
P0694B     MOVE '7900' TO ACTIVE-PARAGRAPH.                             
P0694B     EXEC SQL                                                     
P0694B        OPEN BILLING-HDR-CSR                                      
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE SPACES                  TO ABEND-TABLES             
P0694B         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P0694B         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0694B         MOVE 'OPEN'                  TO ABEND-FUNCTION           
P0694B         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
P0694B         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0694B         MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7900-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B                                                                  
P0694B***************************************************************   22460000
P0694B* 7910-FETCH-BILLING-HDR-CSR.                                 *   22470000
P0694B*                                                             *   22480000
P0694B* FETCH BILLING HEADER CURSOR                                 *   22490000
P0694B***************************************************************   22500000
P0694B 7910-FETCH-BILLING-HDR-CSR.                                      
P0694B                                                                  
P0694B     MOVE '7910' TO ACTIVE-PARAGRAPH.                             
P0694B     EXEC SQL                                                     
P0694B         FETCH BILLING-HDR-CSR                                    
P0694B         INTO :BI-BILL-NO                                         
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE SPACES                  TO ABEND-TABLES             
P0694B         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P0694B         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0694B         MOVE 'FETCH'                 TO ABEND-FUNCTION           
P0694B         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
P0694B         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0694B         MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7910-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B                                                                  
P0694B***************************************************************   22780000
P0694B* 7920-CLOSE-BILLING-HDR-CSR.                                 *   22790000
P0694B*                                                             *   22800000
P0694B* CLOSE BILLING HEADER CURSOR                                 *   22810000
P0694B***************************************************************   22820000
P0694B 7920-CLOSE-BILLING-HDR-CSR.                                      
P0694B                                                                  
P0694B     MOVE '7920' TO ACTIVE-PARAGRAPH.                             
P0694B     EXEC SQL                                                     
P0694B         CLOSE BILLING-HDR-CSR                                    
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE SPACES                  TO ABEND-TABLES             
P0694B         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P0694B         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0694B         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
P0694B         MOVE 'CSS_BILLING_HDR'       TO TABLE-1                  
P0694B         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0694B         MOVE BI-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7920-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B 7922-READ-BILLING-DET.                                           
P0694B                                                                  
P0694B     MOVE '7922' TO ACTIVE-PARAGRAPH.                             
P0694B     EXEC SQL                                                     
P0694B        SELECT DISTINCT 'Y'                                       
P0694B        INTO  :WS-ELEC-EXISTS                                     
P0694B        FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
P0694B        WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
P0694B        AND    BILL_NO           = :BG-BILL-NO                    
P0694B        AND    CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE             
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23110000
MFA-TR*       SELECT DISTINCT 'Y'                                       23120000
MFA-TR*       INTO  :WS-ELEC-EXISTS                                     23130000
MFA-TR*       FROM   CSS_BILLING_DET                                    23140000
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 23150000
MFA-TR*       AND    BILL_NO           = :BG-BILL-NO                    23160000
MFA-TR*       AND    CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE             23170000
MFA-TR*       WITH UR                                                   23180000
MFA-TR*       QUERYNO 7922                                              23190000
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
P0694B            SET UTE-EXISTS TO TRUE                                
P0694B     ELSE                                                         
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND              
P0694B            MOVE 'N'                     TO WS-ELEC-EXISTS        
P0694B         ELSE                                                     
P0694B            MOVE SPACES                  TO ABEND-TABLES          
P0694B            MOVE SPACES                  TO ABEND-SQL-PREDICATES  
P0694B            MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
P0694B            MOVE 'SELECT'                TO ABEND-FUNCTION        
P0694B            MOVE 'CSS_BILLING_DET'       TO TABLE-1               
P0694B            MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
P0694B            MOVE 'BILL_NO'               TO TABLE-ELEMENT-2       
P0694B            MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3       
P0694B            MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
P0694B            MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2     
P0694B            MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3     
P0694B            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
P0694B         END-IF                                                   
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7922-EXIT.                                                       
P0694B      EXIT.                                                       
P0694B                                                                  
P0694B 7924-DECLARE-CUST-PLAN.                                          
P0694B                                                                  
P0694B      MOVE '7924' TO ACTIVE-PARAGRAPH.                            
P0694B      EXEC SQL                                                    
P0694B         DECLARE CUST-PLAN-CURSOR CURSOR FOR                      
P0694B            SELECT CODE_SERVICE_TYPE                              
P0694B            FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                     
P0694B            WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                     
P0694B            FOR READ ONLY                                 
P0694B      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    23510000
MFA-TR*        DECLARE CUST-PLAN-CURSOR CURSOR FOR                      23520000
MFA-TR*           SELECT CODE_SERVICE_TYPE                              23530000
MFA-TR*           FROM  CSS_CUST_PLAN                                   23540000
MFA-TR*           WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                     23550000
MFA-TR*           FOR FETCH ONLY WITH UR                                23560000
MFA-TR*     END-EXEC.                                                   23570000
P0694B                                                                  
P0694B 7924-EXIT.                                                       
P0694B      EXIT.                                                       
                                                                        
P0694B************************************************************      23620000
P0694B* 7925-RETRIEVE-OUTSTANDING-BILL.                          *      23630000
P0694B*                                                          *      23640000
P0694B* RETRIEVE AMOUNT OWED BY CUSTOMER FOR REVERSING EPP       *      23650000
P0694B************************************************************      23660000
P0694B 7925-RETRIEVE-OUTSTANDING-BILL.                                  
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B         SELECT AMT_TRAN_BALANCE                                  
P0694B         INTO  :WS-AMT-POSTED :WS-AMT-POSTED-NULL                  
P0694B         FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P0694B         WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                
P0694B         AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
P0694B         AND    ITEM_ID           = :AC-ITEM-ID                   
P0694B                                                           
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23690000
MFA-TR*        SELECT AMT_TRAN_BALANCE                                  23700000
MFA-TR*        INTO  :WS-AMT-POSTED:WS-AMT-POSTED-NULL                  23710000
MFA-TR*        FROM   CSS_AR_CNTL                                       23720000
MFA-TR*        WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                23730000
MFA-TR*        AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         23740000
MFA-TR*        AND    ITEM_ID           = :AC-ITEM-ID                   23750000
MFA-TR*        WITH UR                                                  23760000
MFA-TR*    END-EXEC.                                                    23770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
P0694B         IF WS-AMT-POSTED-NULL < 0                                
P0694B            MOVE 0                       TO WS-AMT-POSTED         
P0694B         END-IF                                                   
P0694B     ELSE                                                         
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND              
P0694B             MOVE 0                       TO WS-AMT-POSTED        
P0694B         ELSE                                                     
P0694B         MOVE SPACES                  TO ABEND-TABLES             
P0694B         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
P0694B         MOVE '7925'                  TO ACTIVE-PARAGRAPH         
P0694B         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P0694B         MOVE 'SELECT'                TO ABEND-FUNCTION           
P0694B         MOVE 'CSS_AR_CNTL'           TO TABLE-1                  
P0694B         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
P0694B         MOVE 'PYMT_PRIORITY_LVL'     TO TABLE-ELEMENT-2          
P0694B         MOVE 'ITEM_ID'               TO TABLE-ELEMENT-3          
P0694B         MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
P0694B         MOVE AC-PYMT-PRIORITY-LVL    TO HOSTVAR-ELEMENT-2        
P0694B         MOVE AC-ITEM-ID              TO HOSTVAR-ELEMENT-3        
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B      END-IF
           END-IF.                                                     
P0694B                                                                  
P0694B 7925-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B                                                                  
P0694B 7926-OPEN-CUST-PLAN.                                             
P0694B                                                                  
P0694B      MOVE '7926' TO ACTIVE-PARAGRAPH.                            
P0694B      EXEC SQL                                                    
P0694B         OPEN CUST-PLAN-CURSOR                                    
P0694B      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B      MOVE  SQLCODE   TO  WS-ACTIVE-RETURN-CODE.                  
P0694B      IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL          
P0694B          NEXT SENTENCE                                           
P0694B      ELSE                                                        
P0694B          MOVE SPACES                  TO ABEND-TABLES            
P0694B          MOVE SPACES                  TO ABEND-SQL-PREDICATES    
P0694B          MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
P0694B          MOVE 'OPEN'                  TO ABEND-FUNCTION          
P0694B          MOVE 'CSS_CUST_PLAN'         TO TABLE-1                 
P0694B          MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1         
P0694B          MOVE CP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
P0694B          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B 7926-EXIT.                                                       
P0694B      EXIT.                                                       
P0694B                                                                  
P0694B 7927-FETCH-CUST-PLAN.                                            
P0694B      MOVE '7927' TO ACTIVE-PARAGRAPH.                            
P0694B      EXEC SQL                                                    
P0694B         FETCH CUST-PLAN-CURSOR                                   
P0694B         INTO  :CP-CODE-SERVICE-TYPE                              
P0694B      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B      MOVE  SQLCODE   TO  WS-ACTIVE-RETURN-CODE.                  
P0694B      IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL          
P0694B          IF CP-CODE-SERVICE-TYPE = 'E'                           
P0694B             SET UTE-EXISTS TO TRUE                               
P0694B          END-IF                                                  
P0694B          IF CP-CODE-SERVICE-TYPE = 'G'                           
P0694B             SET UTG-EXISTS TO TRUE                               
P0694B          END-IF                                                  
P0694B      ELSE                                                        
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND              
P0694B          NEXT SENTENCE                                           
P0694B         ELSE                                                     
P0694B          MOVE SPACES                  TO ABEND-TABLES            
P0694B          MOVE SPACES                  TO ABEND-SQL-PREDICATES    
P0694B          MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
P0694B          MOVE 'FETCH'                 TO ABEND-FUNCTION          
P0694B          MOVE 'CSS_CUST_PLAN'         TO TABLE-1                 
P0694B          MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1         
P0694B          MOVE CP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
P0694B          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
P0694B         END-IF                                                   
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B  7927-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B  7928-CLOSE-CUST-PLAN.                                           
P0694B                                                                  
P0694B      MOVE '7928' TO ACTIVE-PARAGRAPH.                            
P0694B      EXEC SQL                                                    
P0694B         CLOSE CUST-PLAN-CURSOR                                   
P0694B      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B      MOVE  SQLCODE   TO  WS-ACTIVE-RETURN-CODE.                  
P0694B      IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL          
P0694B          NEXT SENTENCE                                           
P0694B      ELSE                                                        
P0694B          MOVE SPACES                  TO ABEND-TABLES            
P0694B          MOVE SPACES                  TO ABEND-SQL-PREDICATES    
P0694B          MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
P0694B          MOVE 'CLOSE'                 TO ABEND-FUNCTION          
P0694B          MOVE 'CSS_CUST_PLAN'         TO TABLE-1                 
P0694B          MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1         
P0694B          MOVE CP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
P0694B          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B                                                                  
P0694B  7928-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B 7929-SPLIT-AMT.                                                  
P0694B                                                                  
P0694B        IF NOT UTG-EXISTS                                         
P0694B            MOVE  WS-AMT-POSTED       TO WS-UTILITY-BALANCE-UTE   
P0694B            MOVE 0                    TO WS-UTILITY-BALANCE-UTG   
P0694B        ELSE                                                      
P0694B           IF NOT UTE-EXISTS                                      
P0694B              MOVE  WS-AMT-POSTED     TO WS-UTILITY-BALANCE-UTG   
P0694B              MOVE 0                  TO WS-UTILITY-BALANCE-UTE   
P0694B           ELSE                                                   
P0694B              IF AT-ELEC-REV-ALLOC-PCT = 0                        
P0694B                MOVE AT-COMPANY-NO TO B1-COMPANY-NO               
P0694B                MOVE AT-LOCAL-OFFICE TO B1-LOCAL-OFFICE           
P0694B                PERFORM 7980-SELECT-LOC-OFF-FACTOR THRU 7980-EXIT 
P0694B                COMPUTE WS-UTILITY-BALANCE-UTE =                  
P0694B                    (B1-ELEC-REV-ALLOC-PCT / 100)                 
P0694B                    *  WS-AMT-POSTED                              
P0694B              ELSE                                                
P0694B                COMPUTE WS-UTILITY-BALANCE-UTE =                  
P0694B                    (AT-ELEC-REV-ALLOC-PCT / 100) * WS-AMT-POSTED 
P0694B              END-IF                                              
P0694B              COMPUTE WS-UTILITY-BALANCE-UTG =                    
P0694B                      WS-AMT-POSTED - WS-UTILITY-BALANCE-UTE      
P0694B           END-IF                                                 
P0694B        END-IF.                                                   
P0694B                                                                  
P0694B  7929-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B 7929A-CONTINUE-UTE-PROCESS.                                      
P0694B                                                                  
P0694B      IF UTE-EXISTS                                               
P0694B         MOVE +40                      TO AC-PYMT-PRIORITY-LVL    
P0694B         MOVE +0                       TO AC-ITEM-ID              
P0694B         MOVE +0                       TO AC-TOT-SUMM-UNBILLED    
P0694B         MOVE +0                       TO AC-AMT-TRAN-BALANCE     
P0694B         MOVE +0                       TO AC-AMT-AR-DAY-60        
P0694B                                          AC-AMT-AR-DAY-90        
P0694B                                          AC-AMT-UNUSED-CR        
P0694B         MOVE WS-GEN-LED-UTE          TO WS-ACCT-NAME-DR          
P0694B         MOVE WS-GEN-LED-EPP          TO WS-ACCT-NAME-CR          
P0694B         MOVE WS-UTILITY-BALANCE-UTE  TO WS-AMT-POSTED            
P0694B         MOVE WS-AMT-POSTED           TO WS-END-AR-BALANCE        
P0694B         PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT        
P0694B         PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT        
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B 7929A-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B 7929B-CONTINUE-UTG-PROCESS.                                      
P0694B                                                                  
P0694B      IF UTG-EXISTS                                               
P0694B         MOVE +45                      TO AC-PYMT-PRIORITY-LVL    
P0694B         MOVE +0                       TO AC-ITEM-ID              
P0694B         MOVE +0                       TO AC-TOT-SUMM-UNBILLED    
P0694B         MOVE WS-UTILITY-BALANCE-UTG   TO AC-AMT-AR-DAY-00        
P0694B         MOVE +0                       TO AC-AMT-TRAN-BALANCE     
P0694B         MOVE +0                       TO AC-AMT-AR-DAY-30        
P0694B                                          AC-AMT-AR-DAY-60        
P0694B                                          AC-AMT-AR-DAY-90        
P0694B                                          AC-AMT-UNUSED-CR        
P0694B         MOVE WS-GEN-LED-UTG          TO WS-ACCT-NAME-DR          
P0694B         MOVE WS-GEN-LED-EPP          TO WS-ACCT-NAME-CR          
P0694B         MOVE WS-UTILITY-BALANCE-UTG  TO WS-AMT-POSTED            
P0694B         MOVE WS-AMT-POSTED           TO WS-END-AR-BALANCE        
P0694B         PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT        
P0694B         PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT        
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B 7929B-EXIT.                                                      
P0694B      EXIT.                                                       
P0694B                                                                  
P0694B 7929C-CONTINUE-CIA-PROCESS.                                      
P0694B                                                                  
P0694B      MOVE +70                      TO AC-PYMT-PRIORITY-LVL.      
P0694B      MOVE +0                       TO AC-ITEM-ID.                
P0694B      PERFORM 7929D-UPDINS-AR-CNTL  THRU 7929D-EXIT               
P0694B      IF  UTE-EXISTS OR UTG-EXISTS                                
P0694B          MOVE +1                   TO AC-ITEM-ID                 
P0694B      ELSE                                                        
P0694B          MOVE +3                   TO AC-ITEM-ID                 
P0694B      END-IF.                                                     
P0694B      PERFORM 7929D-UPDINS-AR-CNTL  THRU 7929D-EXIT               
P0694B      MOVE WS-GEN-LED-EPP           TO WS-ACCT-NAME-DR.           
P0694B      MOVE WS-GEN-LED-CIA           TO WS-ACCT-NAME-CR.           
P0694B      MOVE WS-AMT-POSTED            TO WS-END-AR-BALANCE.         
P0694B      IF  UTE-EXISTS OR UTG-EXISTS                                
P0694B          MULTIPLY -1 BY WS-AMT-POSTED                            
P0694B      END-IF.                                                     
P0694B      PERFORM 2600-UPDATE-TRANS-HISTORY  THRU 2600-EXIT.          
P0694B      PERFORM 2700-CASH-DRAWER-101       THRU 2700-EXIT.          
P0694B      IF UTE-EXISTS OR UTG-EXISTS                                 
P0694B         MOVE +0                  TO   AC-ITEM-ID                 
P0694B                                       AC-AMT-AR-DAY-00           
P0694B                                       AC-AMT-AR-DAY-30           
P0694B                                       AC-AMT-AR-DAY-60           
P0694B                                       AC-AMT-AR-DAY-90           
P0694B                                       AC-AMT-UNUSED-CR           
P0694B                                       AC-TOT-SUMM-UNBILLED       
P0694B                                       AC-AMT-TRAN-BALANCE
            END-IF.       
P0694B      IF UTE-EXISTS                                               
P0694B         MOVE +40                 TO   AC-PYMT-PRIORITY-LVL       
P0694B         PERFORM 8710-INSERT-AR-CNTL  THRU 8710-EXIT
            END-IF.             
P0694B      IF UTG-EXISTS                                               
P0694B         MOVE +45                 TO   AC-PYMT-PRIORITY-LVL       
P0694B         PERFORM 8710-INSERT-AR-CNTL  THRU 8710-EXIT
            END-IF.             
P0694B                                                                  
P0694B                                                                  
P0694B 7929C-EXIT.                                                      
P0694B      EXIT.                                                       
P0694B                                                                  
P0694B 7929D-UPDINS-AR-CNTL.                                            
P0694B                                                                  
P0694B      PERFORM 7300-SELECT-AR-CNTL   THRU 7300-EXIT.               
P0694B      MOVE +0                       TO AC-TOT-SUMM-UNBILLED.      
P0694B      IF  UTE-EXISTS OR UTG-EXISTS                                
P0694B          ADD  WS-AMT-POSTED        TO AC-AMT-UNUSED-CR           
P0694B          MOVE +0                   TO AC-AMT-AR-DAY-00           
P0694B      ELSE                                                        
P0694B          ADD  WS-AMT-POSTED        TO AC-AMT-AR-DAY-00           
P0694B          MOVE +0                   TO AC-AMT-UNUSED-CR           
P0694B      END-IF                                                      
P0694B      MOVE +0                       TO AC-AMT-AR-DAY-30           
P0694B                                       AC-AMT-AR-DAY-60           
P0694B                                       AC-AMT-AR-DAY-90.          
P0694B      IF AC-ITEM-ID = 0                                           
P0694B         MOVE   +0                  TO AC-AMT-TRAN-BALANCE        
P0694B      ELSE                                                        
P0694B         ADD   WS-AMT-POSTED        TO AC-AMT-TRAN-BALANCE        
P0694B      END-IF.                                                     
P0694B      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
P0694B         PERFORM 7929E-UPDATE-AR-CNTL THRU 7929E-EXIT             
P0694B      ELSE                                                        
P0694B         PERFORM 8710-INSERT-AR-CNTL  THRU 8710-EXIT              
P0694B      END-IF.                                                     
P0694B                                                                  
P0694B 7929D-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B 7929E-UPDATE-AR-CNTL.                                            
P0694B                                                                  
P0694B     MOVE '7929E'  TO ACTIVE-PARAGRAPH.                           
P0694B     MOVE WS-CURRENT-TS           TO AC-LAST-UPDATE-TS.           
P0694B     EXEC SQL                                                     
P0694B        UPDATE CSS_AR_CNTL                                        
P0694B           SET AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,             
P0694B               AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,             
P0694B               AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,             
P0694B               AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,             
P0694B               AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,             
P0694B               AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,          
P0694B               TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED,         
P0694B               LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )             
P0694B         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO AND             
P0694B               PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND      
P0694B               ITEM_ID           = :AC-ITEM-ID                    
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26310000
MFA-TR*       UPDATE CSS_AR_CNTL                                        26320000
MFA-TR*          SET AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,             26330000
MFA-TR*              AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,             26340000
MFA-TR*              AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,             26350000
MFA-TR*              AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,             26360000
MFA-TR*              AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR,             26370000
MFA-TR*              AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,          26380000
MFA-TR*              TOT_SUMM_UNBILLED = :AC-TOT-SUMM-UNBILLED,         26390000
MFA-TR*              LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS             26400000
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO AND             26410000
MFA-TR*              PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND      26420000
MFA-TR*              ITEM_ID           = :AC-ITEM-ID                    26430000
MFA-TR*    END-EXEC.                                                    26440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        MOVE SPACES                TO ABEND-TABLES                
P0694B        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0694B        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0694B        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P0694B        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
P0694B        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0694B        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
P0694B        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
P0694B        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0694B        MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
P0694B        MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
P0694B        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7929E-EXIT.                                                      
P0694B       EXIT.                                                      
P0694B                                                                  
P0694B************************************************************      26680000
P0694B* 7930-SUM-AMT-BILL-ITEM-ELE.                              *      26690000
P0694B*                                                          *      26700000
P0694B* SUM AMT_BILL_ITEM .                                      *      26710000
P0694B************************************************************      26720000
P0694B 7930-SUM-AMT-BILL-ITEM-ELE.                                      
P0694B                                                                  
P0694B      MOVE '7930' TO ACTIVE-PARAGRAPH.                            
P0694B     EXEC SQL                                                     
P0694B        SELECT SUM(AMT_BILL_ITEM +                                
P0694B                   AMT_CITY_TAX  +                                
P0694B                   AMT_OTHER_TAX +                                
P0694B                   AMT_STATE_TAX )                                
P0694B        INTO  :WS-AMT-POSTED :WS-AMT-POSTED-NULL                   
P0694B        FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
P0694B        WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
P0694B        AND    BILL_NO           = :BG-BILL-NO                    
P0694B        AND    CODE_BILL_ITM_TYPE = 'C'                           
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26760000
MFA-TR*       SELECT SUM(AMT_BILL_ITEM +                                26770000
MFA-TR*                  AMT_CITY_TAX  +                                26780000
MFA-TR*                  AMT_OTHER_TAX +                                26790000
MFA-TR*                  AMT_STATE_TAX )                                26800000
MFA-TR*       INTO  :WS-AMT-POSTED:WS-AMT-POSTED-NULL                   26810000
MFA-TR*       FROM   CSS_BILLING_DET                                    26820000
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 26830000
MFA-TR*       AND    BILL_NO           = :BG-BILL-NO                    26840000
MFA-TR*       AND    CODE_BILL_ITM_TYPE = 'C'                           26850000
MFA-TR*       WITH UR                                                   26860000
MFA-TR*       QUERYNO 7930                                              26870000
MFA-TR*    END-EXEC.                                                    26880000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
P0694B         IF WS-AMT-POSTED-NULL NOT < 0                            
P0694B             NEXT SENTENCE                                        
P0694B         END-IF                                                   
P0694B     ELSE                                                         
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND              
P0694B            MOVE 0                       TO WS-AMT-POSTED         
P0694B         ELSE                                                     
P0694B            MOVE SPACES                  TO ABEND-TABLES          
P0694B            MOVE SPACES                  TO ABEND-SQL-PREDICATES  
P0694B            MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
P0694B            MOVE 'SELECT'                TO ABEND-FUNCTION        
P0694B            MOVE 'CSS_BILLING_DET'       TO TABLE-1               
P0694B            MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
P0694B            MOVE 'BILL_NO'               TO TABLE-ELEMENT-2       
P0694B            MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
P0694B            MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2     
P0694B            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
P0694B         END-IF                                                   
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7930-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B************************************************************      27160000
P0694B* GETS THE MAX BILL_NO FROM CSS_BILLING_DET                *      27170000
P0694B************************************************************      27180000
P0694B 7935-GET-MAX-BILL.                                               
P0694B*                                                                 27200000
P0694B      MOVE '7935'                      TO ACTIVE-PARAGRAPH.       
P0694B     EXEC SQL                                                     
P0694B        SELECT MAX(BILL_NO)                                       
P0694B        INTO  :BG-BILL-NO :WS-BILL-NO-NULL                         
P0694B        FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
P0694B        WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
P0694B        AND    DATE_ORIG_BILL IS NULL                             
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27220000
MFA-TR*       SELECT MAX(BILL_NO)                                       27230000
MFA-TR*       INTO  :BG-BILL-NO:WS-BILL-NO-NULL                         27240000
MFA-TR*       FROM   CSS_BILLING_DET                                    27250000
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 27260000
MFA-TR*       AND    DATE_ORIG_BILL IS NULL                             27270000
MFA-TR*       WITH UR                                                   27280000
MFA-TR*       QUERYNO 7935                                              27290000
MFA-TR*    END-EXEC.                                                    27300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P0694B                                             S-RETURN-CODE.       
P0694B     IF  WS-ACTIVE-RETURN-CODE EQUAL   TO SUCCESSFUL-CALL         
P0694B         OR NOT-FOUND                                             
P0694B         IF  WS-BILL-NO-NULL < 0                                  
P0694B             MOVE ZEROS                TO BG-BILL-NO              
P0694B         END-IF                                                   
P0694B     ELSE                                                         
P0694B         MOVE SPACES                   TO ABEND-TABLES            
P0694B         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
P0694B         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P0694B         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P0694B         MOVE 'CSS_BILLING_DET'        TO TABLE-1                 
P0694B         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
P0694B         MOVE BG-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7935-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 27520000
P0694B************************************************************      27530000
P0694B* OPENS THE CURSOR ON CSS-BILLING-DET TO DETERMINE THE     *      27540000
P0694B* CODE-UTIL-TYPE OF THE MAX AVAILABLE BILL-NO FOR THE ACCT *      27550000
P0694B************************************************************      27560000
P0694B  7937-OPEN-BG-CURSOR.                                            
P0694B*                                                                 27580000
P0694B     MOVE '7937'                         TO ACTIVE-PARAGRAPH.     
P0694B     EXEC SQL                                                     
P0694B        OPEN BG-CURSOR                                            
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0694B                                                                  
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
P0694B         MOVE 'OPEN'                     TO ABEND-FUNCTION        
P0694B         MOVE 'CSS_BILLING_DET'          TO TABLE-1               
P0694B         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0694B         MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0694B         MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2       
P0694B         MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2     
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7937-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 27810000
P0694B************************************************************      27820000
P0694B* FETCHES THE CODE-UTIL-TYPE FOR THE MAX AVAILABLE BILL-NO *      27830000
P0694B* FROM CSS_BILLING_DET                                     *      27840000
P0694B************************************************************      27850000
P0694B 7938-FETCH-BG-CURSOR.                                            
P0694B*                                                                 27870000
P0694B     MOVE '7938'                         TO ACTIVE-PARAGRAPH.     
P0694B     EXEC SQL                                                     
P0694B        FETCH BG-CURSOR                                           
P0694B         INTO :BG-CODE-UTIL-TYPE                                  
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0694B                                                                  
P0694B     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
P0694B         MOVE 'FETCH'                    TO ABEND-FUNCTION        
P0694B         MOVE 'CSS_BILLING_DET'          TO TABLE-1               
P0694B         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0694B         MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0694B         MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2       
P0694B         MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2     
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7938-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B*                                                                 28110000
P0694B************************************************************      28120000
P0694B* CLOSES THE BG-CURSOR                                     *      28130000
P0694B************************************************************      28140000
P0694B  7939-CLOSE-BG-CURSOR.                                           
P0694B*                                                                 28160000
P0694B     MOVE '7939'                         TO ACTIVE-PARAGRAPH.     
P0694B     EXEC SQL                                                     
P0694B        CLOSE BG-CURSOR                                           
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P0694B                                                                  
P0694B     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
P0694B         MOVE 'CLOSE'                    TO ABEND-FUNCTION        
P0694B         MOVE 'CSS_BILLING_DET'          TO TABLE-1               
P0694B         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0694B         MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0694B         MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2       
P0694B         MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2     
P0694B         MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3       
P0694B         MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3     
P0694B         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7939-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B************************************************************      28420000
P0694B* 7940-SUM-AMT-BILL-ITEM-GAS.                              *      28430000
P0694B*                                                          *      28440000
P0694B* SUM AMT_BILL_ITEM FOR UTIL TYPE GAS                      *      28450000
P0694B************************************************************      28460000
P0694B 7940-SUM-AMT-BILL-ITEM-GAS.                                      
P0694B                                                                  
P0694B      MOVE '7940' TO ACTIVE-PARAGRAPH.                            
P0694B     EXEC SQL                                                     
P0694B        SELECT DISTINCT 'Y'                                       
P0694B        INTO  :WS-GAS-EXISTS                                      
P0694B        FROM   CSS_BILLING_DET WITH(READUNCOMMITTED)                      
P0694B        WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 
P0694B        AND    BILL_NO           = :BG-BILL-NO                    
P0694B        AND    CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE             
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28500000
MFA-TR*       SELECT DISTINCT 'Y'                                       28510000
MFA-TR*       INTO  :WS-GAS-EXISTS                                      28520000
MFA-TR*       FROM   CSS_BILLING_DET                                    28530000
MFA-TR*       WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                 28540000
MFA-TR*       AND    BILL_NO           = :BG-BILL-NO                    28550000
MFA-TR*       AND    CODE_UTIL_TYPE    = :BG-CODE-UTIL-TYPE             28560000
MFA-TR*       WITH UR                                                   28570000
MFA-TR*       QUERYNO 7940                                              28580000
MFA-TR*    END-EXEC.                                                    28590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
P0694B            SET UTG-EXISTS TO TRUE                                
P0694B     ELSE                                                         
P0694B         IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND              
P0694B            MOVE 'N'                     TO WS-GAS-EXISTS         
P0694B         ELSE                                                     
P0694B            MOVE SPACES                  TO ABEND-TABLES          
P0694B            MOVE SPACES                  TO ABEND-SQL-PREDICATES  
P0694B            MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
P0694B            MOVE 'SELECT'                TO ABEND-FUNCTION        
P0694B            MOVE 'CSS_BILLING_DET'       TO TABLE-1               
P0694B            MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
P0694B            MOVE 'BILL_NO'               TO TABLE-ELEMENT-2       
P0694B            MOVE 'CODE_UTIL-TYPE'        TO TABLE-ELEMENT-3       
P0694B            MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
P0694B            MOVE BG-BILL-NO              TO HOSTVAR-ELEMENT-2     
P0694B            MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3     
P0694B            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
P0694B         END-IF                                                   
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7940-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B************************************************************      28870000
P0694B* 7980-SELECT-LOC-OFF-FACTOR                               *      28880000
P0694B*                                                          *      28890000
P0694B*                                                          *      28900000
P0694B************************************************************      28910000
P0694B 7980-SELECT-LOC-OFF-FACTOR.                                      
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B        SELECT ELEC_REV_ALLOC_PCT                                 
P0694B          INTO :B1-ELEC-REV-ALLOC-PCT                             
P0694B          FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
P0694B         WHERE COMPANY_NO   = :B1-COMPANY-NO                      
P0694B           AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                    
P0694B                                                           
P0694B                                                      
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28940000
MFA-TR*       SELECT ELEC_REV_ALLOC_PCT                                 28950000
MFA-TR*         INTO :B1-ELEC-REV-ALLOC-PCT                             28960000
MFA-TR*         FROM CSS_LOCAL_OFFICE                                   28970000
MFA-TR*        WHERE COMPANY_NO   = :B1-COMPANY-NO                      28980000
MFA-TR*          AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                    28990000
MFA-TR*        WITH UR                                                  29000000
MFA-TR*        QUERYNO 7980                                             29010000
MFA-TR*    END-EXEC.                                                    29020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0694B                                                                  
P0694B     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0694B         NEXT SENTENCE                                            
P0694B     ELSE                                                         
P0694B         MOVE PROGRAM-NAME                   TO ABEND-PROGRAM     
P0694B         MOVE '7980'                         TO ACTIVE-PARAGRAPH  
P0694B         MOVE 'SELECT'                       TO ABEND-FUNCTION    
P0694B         MOVE 'CSS_LOCAL_OFFICE'             TO TABLE-1           
P0694B         MOVE 'COMPANY_NO'                   TO TABLE-ELEMENT-1   
P0694B         MOVE 'LOCAL_OFFICE'                 TO TABLE-ELEMENT-2   
P0694B         MOVE 'ACCOUNT_NO'                   TO TABLE-ELEMENT-3   
P0694B         MOVE B1-COMPANY-NO                  TO HOSTVAR-ELEMENT-1 
P0694B         MOVE B1-LOCAL-OFFICE                TO HOSTVAR-ELEMENT-2 
P0694B         MOVE PARM-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-3
P0694B        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 7980-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B*                                                                 29250000
P00694*************************************************************     29260000
P00694* 7999-SELECT-AL.                                                 29270000
P00694*     COPYBOOK TO CHECK AR-LOCKOUT STATUS                         29280000
P00694*************************************************************     29290000
P00694     EXEC SQL                                                     29300000
P00694        INCLUDE CPD00075                                          29310000
P00694     END-EXEC.                                                    29320000
P00694                                                                  
      ******************************************************************29340000
      * 8000-UPD-BUDGET-PLAN.                                          *29350000
      ******************************************************************29360000
      *                                                                 29370000
       8000-UPD-BUDGET-PLAN.                                            
      *                                                                 29390000
           EXEC SQL                                                     
              UPDATE  BU                                 
                 SET  AMT_MO_PYMT       = :BU-AMT-MO-PYMT               
P00694               ,ANNIVERSARY_DATE  = IIF(TRY_CONVERT(DATE, 
                                                   :BU-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :BU-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:BU-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:BU-ANNIVERSARY-DATE
              ), CONVERT(DATE, :BU-ANNIVERSARY-DATE) )          
ACT001               ,DATE_PYMT_STRT    = IIF(TRY_CONVERT(DATE, 
                                                     :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) )            
                     ,LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :BU-LAST-UPDATE-TS
              )            
              FROM CSS_BUDGET_PLAN BU
               WHERE  ACCOUNT_NO        = :BU-ACCOUNT-NO                
                 AND  PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         
                 AND  BP_ITEM_ID        = :BU-BP-ITEM-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29400000
MFA-TR*       UPDATE  CSS_BUDGET_PLAN BU                                29410000
MFA-TR*          SET  AMT_MO_PYMT       = :BU-AMT-MO-PYMT               29420000
MFA-TR*              ,ANNIVERSARY_DATE  = :BU-ANNIVERSARY-DATE          29430000
MFA-TR*              ,DATE_PYMT_STRT    = :BU-DATE-PYMT-STRT            29431008
MFA-TR*              ,LAST_UPDATE_TS    = :BU-LAST-UPDATE-TS            29440000
MFA-TR*        WHERE  ACCOUNT_NO        = :BU-ACCOUNT-NO                29450000
MFA-TR*          AND  PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         29460000
MFA-TR*          AND  BP_ITEM_ID        = :BU-BP-ITEM-ID                29470000
MFA-TR*    END-EXEC.                                                    29480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_PLAN'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE BH-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE BH-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 29690000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29720000
      ******************************************************************29730000
      * 8200-INS-BUDGET-HIST.                                          *29740000
      ******************************************************************29750000
      *                                                                 29760000
       8200-INS-BUDGET-HIST.                                            
      *                                                                 29780000
           EXEC SQL                                                     
           INSERT INTO CSS_BUDGET_HIST                                  
                  ( ACCOUNT_NO                                          
                   ,PYMT_PRIORITY_LVL                                   
                   ,ITEM_ID                                             
                   ,BUD_HIST_SEQ_NO                                     
                   ,AMT_MO_PYMT                                         
                   ,DATE_PYMT_STRT                                      
                   ,UTILITY_BALANCE                                     
                   ,BALANCE_FORWARD                                     
                   ,EPP_ESTIMATE                                        
                   ,METHOD_OF_ESTIMATE                                  
                   ,CHANGE_REASON                                       
                   ,EPP_MTHS_RMNG_QT                                    
                   ,REMARKS                                             
                   ,BUDG_BILL_PREV_AMT                                  
                   ,LAST_UPDATE_USERID )                                
           VALUES (:BH-ACCOUNT-NO                                       
                  ,:BH-PYMT-PRIORITY-LVL                                
                  ,:BH-ITEM-ID                                          
                  ,CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO)                      
                  ,:BH-AMT-MO-PYMT                                      
                  ,IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )                           
                  ,:BH-UTILITY-BALANCE                                  
                  ,:BH-BALANCE-FORWARD                                  
                  ,:BH-EPP-ESTIMATE                                     
                  ,:BH-METHOD-OF-ESTIMATE                               
                  ,:BH-CHANGE-REASON                                    
                  ,:BH-EPP-MTHS-RMNG-QT                                 
                  ,:BH-REMARKS                                          
                  ,:BH-BUDG-BILL-PREV-AMT                               
P00694            ,:BH-LAST-UPDATE-USERID )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29790000
MFA-TR*    INSERT INTO CSS_BUDGET_HIST                                  29800000
MFA-TR*           ( ACCOUNT_NO                                          29810000
MFA-TR*            ,PYMT_PRIORITY_LVL                                   29820000
MFA-TR*            ,ITEM_ID                                             29830000
MFA-TR*            ,BUD_HIST_SEQ_NO                                     29840000
MFA-TR*            ,AMT_MO_PYMT                                         29850000
MFA-TR*            ,DATE_PYMT_STRT                                      29860000
MFA-TR*            ,UTILITY_BALANCE                                     29870000
MFA-TR*            ,BALANCE_FORWARD                                     29880000
MFA-TR*            ,EPP_ESTIMATE                                        29890000
MFA-TR*            ,METHOD_OF_ESTIMATE                                  29900000
MFA-TR*            ,CHANGE_REASON                                       29910000
MFA-TR*            ,EPP_MTHS_RMNG_QT                                    29920000
MFA-TR*            ,REMARKS                                             29930000
MFA-TR*            ,BUDG_BILL_PREV_AMT                                  29940000
MFA-TR*            ,LAST_UPDATE_USERID )                                29950000
MFA-TR*    VALUES (:BH-ACCOUNT-NO                                       29960000
MFA-TR*           ,:BH-PYMT-PRIORITY-LVL                                29970000
MFA-TR*           ,:BH-ITEM-ID                                          29980000
MFA-TR*           ,:BH-BUD-HIST-SEQ-NO                                  29990000
MFA-TR*           ,:BH-AMT-MO-PYMT                                      30000000
MFA-TR*           ,:BH-DATE-PYMT-STRT                                   30010000
MFA-TR*           ,:BH-UTILITY-BALANCE                                  30020000
MFA-TR*           ,:BH-BALANCE-FORWARD                                  30030000
MFA-TR*           ,:BH-EPP-ESTIMATE                                     30040000
MFA-TR*           ,:BH-METHOD-OF-ESTIMATE                               30050000
MFA-TR*           ,:BH-CHANGE-REASON                                    30060000
MFA-TR*           ,:BH-EPP-MTHS-RMNG-QT                                 30070000
MFA-TR*           ,:BH-REMARKS                                          30080000
MFA-TR*           ,:BH-BUDG-BILL-PREV-AMT                               30090000
MFA-TR*           ,:BH-LAST-UPDATE-USERID )                             30100000
MFA-TR*    END-EXEC.                                                    30110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE BH-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE BH-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              MOVE 'DATE_PYMT_STRT'      TO TABLE-ELEMENT-4             
              MOVE BH-DATE-PYMT-STRT     TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                 30340000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30370000
P0694B***************************************************************   30380000
P0694B* 8710-INSERT-AR-CNTL.                                        *   30390000
P0694B*                                                             *   30400000
P0694B* INSERT RECORD IN THE AR CONTROL TABLE.                      *   30410000
P0694B***************************************************************   30420000
P0694B 8710-INSERT-AR-CNTL.                                             
P0694B                                                                  
P0694B     MOVE '8710' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     MOVE WS-CURRENT-TS           TO AC-LAST-UPDATE-TS.           
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B     INSERT INTO CSS_AR_CNTL                                      
P0694B            ( ACCOUNT_NO         ,                                
P0694B              PYMT_PRIORITY_LVL  ,                                
P0694B              ITEM_ID            ,                                
P0694B              AMT_AR_DAY_00      ,                                
P0694B              AMT_AR_DAY_30      ,                                
P0694B              AMT_AR_DAY_60      ,                                
P0694B              AMT_AR_DAY_90      ,                                
P0694B              AMT_UNUSED_CR      ,                                
P0694B              AMT_TRAN_BALANCE   ,                                
P0694B              TOT_SUMM_UNBILLED  ,                                
P0694B              LAST_UPDATE_TS     )                                
P0694B     VALUES (:AT-ACCOUNT-NO        ,                              
P0694B             :AC-PYMT-PRIORITY-LVL ,                              
P0694B             :AC-ITEM-ID           ,                              
P0694B             :AC-AMT-AR-DAY-00     ,                              
P0694B             :AC-AMT-AR-DAY-30     ,                              
P0694B             :AC-AMT-AR-DAY-60     ,                              
P0694B             :AC-AMT-AR-DAY-90     ,                              
P0694B             :AC-AMT-UNUSED-CR     ,                              
P0694B             :AC-AMT-TRAN-BALANCE  ,                              
P0694B             :AC-TOT-SUMM-UNBILLED ,                              
P0694B             CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS)    )                  
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     30490000
MFA-TR*    INSERT INTO CSS_AR_CNTL                                      30500000
MFA-TR*           ( ACCOUNT_NO         ,                                30510000
MFA-TR*             PYMT_PRIORITY_LVL  ,                                30520000
MFA-TR*             ITEM_ID            ,                                30530000
MFA-TR*             AMT_AR_DAY_00      ,                                30540000
MFA-TR*             AMT_AR_DAY_30      ,                                30550000
MFA-TR*             AMT_AR_DAY_60      ,                                30560000
MFA-TR*             AMT_AR_DAY_90      ,                                30570000
MFA-TR*             AMT_UNUSED_CR      ,                                30580000
MFA-TR*             AMT_TRAN_BALANCE   ,                                30590000
MFA-TR*             TOT_SUMM_UNBILLED  ,                                30600000
MFA-TR*             LAST_UPDATE_TS     )                                30610000
MFA-TR*    VALUES (:AT-ACCOUNT-NO        ,                              30620000
MFA-TR*            :AC-PYMT-PRIORITY-LVL ,                              30630000
MFA-TR*            :AC-ITEM-ID           ,                              30640000
MFA-TR*            :AC-AMT-AR-DAY-00     ,                              30650000
MFA-TR*            :AC-AMT-AR-DAY-30     ,                              30660000
MFA-TR*            :AC-AMT-AR-DAY-60     ,                              30670000
MFA-TR*            :AC-AMT-AR-DAY-90     ,                              30680000
MFA-TR*            :AC-AMT-UNUSED-CR     ,                              30690000
MFA-TR*            :AC-AMT-TRAN-BALANCE  ,                              30700000
MFA-TR*            :AC-TOT-SUMM-UNBILLED ,                              30710000
MFA-TR*            :AC-LAST-UPDATE-TS    )                              30720000
MFA-TR*    END-EXEC.                                                    30730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        MOVE SPACES               TO ABEND-TABLES                 
P0694B        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P0694B        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0694B        MOVE 'INSERT'             TO ABEND-FUNCTION               
P0694B        MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
P0694B        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P0694B        MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
P0694B        MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
P0694B        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P0694B        MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
P0694B        MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
P0694B        MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-4              
P0694B        MOVE AC-LAST-UPDATE-TS    TO HOSTVAR-ELEMENT-4            
P0694B        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 8710-EXIT.                                                       
P0694B     EXIT.                                                        
                                                                        
P0694B***************************************************************   30990000
P0694B* 8740-DELETE-AR-CNTL.                                        *   31000000
P0694B*                                                             *   31010000
P0694B* DELETE RECORD IN THE AR CONTROL TABLE.                      *   31020000
P0694B***************************************************************   31030000
P0694B 8740-DELETE-AR-CNTL.                                             
P0694B                                                                  
P0694B     MOVE '8740' TO ACTIVE-PARAGRAPH.                             
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B        DELETE FROM CSS_AR_CNTL                                   
P0694B         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
P0694B           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
P0694B           AND ITEM_ID           = :AC-ITEM-ID                    
P0694B     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P0694B           MOVE 0 TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE                                
P0694B        ELSE                                                      
P0694B           MOVE SPACES               TO ABEND-TABLES              
P0694B           MOVE SPACES               TO ABEND-SQL-PREDICATES      
P0694B           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P0694B           MOVE 'DELETE'             TO ABEND-FUNCTION            
P0694B           MOVE 'CSS_AR_CNTL'        TO TABLE-1                   
P0694B           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
P0694B           MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2           
P0694B           MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3           
P0694B           MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
P0694B           MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2         
P0694B           MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3         
P0694B           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 8740-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
P0694B***************************************************************   31420000
P0694B* 8805-UPDATE-ACCOUNT-EPP-OFFER                               *   31430000
P0694B*                                                             *   31440000
P0694B* UPDATE LAST ACTION DATE ON ACCOUNT TABLE.                   *   31450000
P0694B***************************************************************   31460000
P0694B 8805-UPDATE-ACCOUNT-EPP-OFFER.                                   
P0694B                                                                  
P0694B     MOVE '8805' TO ACTIVE-PARAGRAPH.                             
P0694B*                                                                 31500000
P0694B                                                                  
P0694B     EXEC SQL                                                     
P0694B     UPDATE  CSS_ACCOUNT                                          
P0694B        SET DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),            
P0694B            CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,          
P0694B            CREDIT_GROUP       = :AT-CREDIT-GROUP,                
P0694B            TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,            
P0694B            EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,            
P0694B            EPP_OFFER_DATE     = IIF(TRY_CONVERT(DATE, 
                                                    :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) <> 0) OR (LEN(:AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ), CONVERT(DATE, :AT-EPP-OFFER-DATE 
                                              :WS-EPP-OFFER-DT-NULL-IND
              ) ),       
P0694B            ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT           
P0694B          , CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL               
P0694B          , LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()                
P0694B      WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                   
P0694B        AND LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )               
P0694B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31520000
MFA-TR*    UPDATE  CSS_ACCOUNT                                          31530000
MFA-TR*       SET DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION,            31540000
MFA-TR*           CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,          31550000
MFA-TR*           CREDIT_GROUP       = :AT-CREDIT-GROUP,                31560000
MFA-TR*           TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,            31570000
MFA-TR*           EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,            31580000
MFA-TR*           EPP_OFFER_DATE     = :AT-EPP-OFFER-DATE               31590000
MFA-TR*                                :WS-EPP-OFFER-DT-NULL-IND,       31600000
MFA-TR*           ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT           31610000
MFA-TR*         , CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL               31620000
MFA-TR*         , LAST_UPDATE_TS     = CURRENT TIMESTAMP                31630000
MFA-TR*     WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                   31640000
MFA-TR*       AND LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS               31650000
MFA-TR*    END-EXEC.                                                    31660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0694B                                                                  
P0694B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0694B                     S-RETURN-CODE.                               
P0694B     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0694B        NEXT SENTENCE                                             
P0694B     ELSE                                                         
P0694B        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P0694B           MOVE WS-LAST-UPDATE-TS-MISMATCH TO S-RETURN-CODE       
P0694B                                            WS-ACTIVE-RETURN-CODE 
P0694B           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P0694B        ELSE                                                      
P0694B           MOVE SPACES              TO ABEND-TABLES               
P0694B           MOVE SPACES              TO ABEND-SQL-PREDICATES       
P0694B           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P0694B           MOVE 'UPDATE'            TO ABEND-FUNCTION             
P0694B           MOVE 'CSS_ACCOUNT'       TO TABLE-1                    
P0694B           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
P0694B           MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
P0694B           MOVE 'LAST_UPDATE_TS'    TO TABLE-ELEMENT-2            
P0694B           MOVE AT-LAST-UPDATE-TS   TO HOSTVAR-ELEMENT-2          
P0694B           MOVE 'DATE_LAST_ACTION'  TO TABLE-ELEMENT-3            
P0694B           MOVE AT-DATE-LAST-ACTION TO HOSTVAR-ELEMENT-3          
P0694B           MOVE 'CREDIT_GROUP'      TO TABLE-ELEMENT-4            
P0694B           MOVE AT-CREDIT-GROUP     TO HOSTVAR-ELEMENT-4          
P0694B           PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
P0694B        END-IF                                                    
P0694B     END-IF.                                                      
P0694B                                                                  
P0694B 8805-EXIT.                                                       
P0694B     EXIT.                                                        
P0694B                                                                  
      ******************************************************************31980000
      *   9700-PROCESS-ABENDG / ABEND PROCESSING                       *31990000
      ******************************************************************32000000
      *                                                                 32010000
           EXEC SQL                                                     32020000
              INCLUDE CPD0023C                                          32030000
           END-EXEC.                                                    32040000
      *                                                                 32050000
      ******************************************************************32060000
      *       9900 - JOURNALING / ERROR HANDLING ROUTINE               *32070000
      ******************************************************************32080000
      *                                                                 32090000
           EXEC SQL                                                     32100000
              INCLUDE CPDSP300                                          32110000
           END-EXEC.                                                    32120000
      *                                                                 32130000
      ******************************************************************32140000
      *       END PROGRAM COPYLIB                                      *32150000
      ******************************************************************32160000
      *                                                                 32170000
           EXEC SQL                                                     32180000
              INCLUDE CPD00321                                          32190000
           END-EXEC.                                                    32200000
      *                                                                 32210000
