       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04612.                                         
COB303 DATE-WRITTEN.  MAR 04, 2013.                                     
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS IS A INITIAL RETRIEVE FOR AR TRANSFERS WIZARD.           *        
      *                                                                *        
      *  RESULTS SETS:                                                 *        
      *     1.  TRANSFER FROM ACCOUNT DETAILS                          *        
      *     2.  FROM ACCOUNT RECEIVABLES                               *        
      *   OR                                                           *        
      *     1.  TRANSFER TO ACCOUNT DETAILS                            *        
      *   OR                                                           *        
      *     1.  TRANSFER TO ACCOUNT DETAILS                            *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00627*  03/04/13  AA97148    INITIAL IMPLEMENTATION.                  *        
P00627*  10/25/13  VENKATP    ADDED STA FLAG TO RESULT SET             *        
ACT224*  07/18/14  RB19957    ADDED RCC AS INITIAL CK AND DO NOT INIT  *        
ACT224*           RICK        RETURN RESULT SET WHEN ERROR OCCURS.     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04612'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04612 STARTS HERE'.                  
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-TO-ACCT-NO-CHAR        PIC X(13).                       
          05 WS-TO-ACCT-NO-NUM         REDEFINES WS-TO-ACCT-NO-CHAR     
                                       PIC 9(13).                       
          05 WS-FROM-ACCT-NO-CHAR      PIC X(13).                       
          05 WS-FROM-ACCT-NO-NUM       REDEFINES WS-FROM-ACCT-NO-CHAR   
                                       PIC 9(13).                       
          05 WS-SQLSTATE               PIC X(05) VALUE SPACES.          
          05 WS-GTT-NAME               PIC X(19) VALUE SPACES.          
          05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04612'.      
          05 WS-NULL-IND-CHG-AMT       PIC S9(4) COMP  VALUE 0.         
          05 WS-NULL-IND-AMT-DEP       PIC S9(4) COMP  VALUE 0.         
          05 WS-AR-TYPE-SHORT-DESC     PIC X(03) VALUE SPACES.          
          05 WS-AR-TYPE-LONG-DESC      PIC X(25) VALUE SPACES.          
      *                                                                         
       01 WS-FLAG-VALUES.                                               
          05 WS-FACLTY-DAM-EXISTS      PIC X(01) VALUE SPACES.          
          05 WS-WRITEOFF-FLAG          PIC X(01) VALUE SPACES.          
          05 WS-EXISTS                 PIC X(01) VALUE SPACES.          
          05 WS-PYMT-PRIORITY-LVL      PIC S9(4) USAGE COMP VALUE 0.    
      *                                                                         
       01 COUNTER-FIELDS.                                               
          05 CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.          
          05 CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.          
          05 WS-DEPOSIT-CNT            PIC S9(4) COMP VALUE 0.          
      *                                                                         
       01 WS-LITERAL.                                                   
          05 WS-NSC                    PIC S9(4) VALUE +19.             
          05 WS-NSA                    PIC S9(4) VALUE +20.             
          05 WS-NSN                    PIC S9(4) VALUE +29.             
          05 WS-LPC                    PIC S9(4) VALUE +30.             
          05 WS-LPN                    PIC S9(4) VALUE +39.             
          05 WS-UTE                    PIC S9(4) VALUE +40.             
          05 WS-UTG                    PIC S9(4) VALUE +45.             
          05 WS-BBP                    PIC S9(4) VALUE +50.             
          05 WS-RCC                    PIC S9(4) VALUE +60.             
          05 WS-CIA                    PIC S9(4) VALUE +70.             
          05 WS-DEP                    PIC S9(4) VALUE +80.             
          05 WS-DFA                    PIC S9(4) VALUE +90.             
          05 WS-CNT                    PIC S9(4) VALUE +100.            
          05 WS-PJS                    PIC S9(4) VALUE +129.            
      *                                                                         
       01 FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.       
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-R1-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R1-DPP-IND           PIC X(01) VALUE SPACES.          
             10 S-R1-AR-LOCKOUT-IND    PIC X(01) VALUE SPACES.          
             10 S-R1-FULLY-PAID-AMT    PIC S9(7)V9(2)  USAGE COMP-3     
                                                 VALUE +0.              
             10 S-R1-DEPOSIT-CNT       PIC S9(4) COMP  VALUE 0.         
             10 S-R1-BBP-IND           PIC X(01) VALUE 'N'.             
             10 S-R1-DEPOSIT-WAIVER-CD PIC X(01) VALUE 'N'.             
             10 S-R1-REG-GROUP-CD      PIC X(03) VALUE SPACES.          
             10 S-R1-ACCT-TYPE-CD      PIC X(01) VALUE SPACES.          
             10 S-R1-PREPAY-IND        PIC X(01) VALUE SPACES.          
             10 S-R1-FACLTY-DAM-IND    PIC X(01) VALUE SPACES.          
             10 S-R1-BANK-DRAFT-IND    PIC X(01) VALUE SPACES.          
             10 S-R1-GUARANTEE-IND     PIC X(01) VALUE SPACES.          
             10 S-R1-GUARANTOR-IND     PIC X(01) VALUE SPACES.          
             10 S-R1-IS-ACT-DR-6YR-OLD PIC X(01) VALUE SPACES.          
             10 S-R1-RECV-ERR-FND-IND  PIC X(01) VALUE SPACES.          
             10 S-R1-RESP-AREA-ID      PIC X(03) VALUE SPACES.          
             10 S-R1-AT-LAST-UPDATE-TS PIC X(26) VALUE SPACES.          
             10 S-R1-STA-IND           PIC X(01) VALUE 'N'.             
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-R2-RETURN-CODE       PIC S9(9) COMP  VALUE 0.         
             10 S-R2-PYMT-PRIORITY-LVL PIC S9(4) USAGE COMP VALUE +0.   
             10 S-R2-RECV-TYPE         PIC X(03) VALUE SPACES.          
             10 S-R2-RECV-DESC         PIC X(25) VALUE SPACES.          
             10 S-R2-ITEM-ID           PIC S9(9) USAGE COMP VALUE +0.   
             10 S-R2-FULL-BALANCE      PIC S9(11)V99   COMP-3           
                                                 VALUE +0.              
             10 S-R2-LIEN-CD           PIC X(01) VALUE SPACES.          
             10 S-R2-WRITEOFF-FLAG     PIC X(01) VALUE SPACES.          
             10 S-R2-TOT-SUMM-UNBILLED PIC S9(11)V99   COMP-3           
                                                 VALUE +0.              
      *                                                                         
       01 SWITCHES.                                                     
          05 WS-PROCESSED-SW           PIC X(01) VALUE 'N'.             
             88 PROCESSED-FL                     VALUE 'Y'.             
          05 WS-AR-TYPE-TBL-LOADED     PIC X(01) VALUE 'N'.             
             88 AR-TYPE-TBL-LOADED               VALUE 'Y'.             
          05 WS-DATABASE               PIC 9(01) VALUE 0.               
             88 CSR-DATABASE                     VALUE 1.               
             88 SEB-DATABASE                     VALUE 2.               
      *                                                                         
       01 WS-TABLES.                                                    
          05 T2-AR-TYPE                OCCURS 300                       
                                       INDEXED BY T2-INDEX.             
             10 T2-PYMT-PRIORITY-LVL   PIC S9(4) USAGE COMP VALUE 0.    
             10 T2-AR-TYPE-SHORT-DESC  PIC X(03).                       
             10 T2-AR-TYPE-LONG-DESC   PIC X(25).                       
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT       - AT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_CNTL       - AC                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************01980000
      * CSS_AR_LOCKOUT       - AL                                      *01980000
      ******************************************************************01980000
      *                                                                         
           EXEC SQL                                                     02310000
              INCLUDE TBARLOCK                                          02320000
           END-EXEC.                                                    02330000
      *                                                                         
      ******************************************************************01980000
      * CSS_AR_TYPE          - L5                                      *01980000
      ******************************************************************01980000
      *                                                                         
           EXEC SQL                                                     02310000
              INCLUDE TBARTYPE                                          02320000
           END-EXEC.                                                    02330000
      *                                                                         
      ******************************************************************        
      *    CSS_CONTRACT      - CT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CHRG_OFF      - CO                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DEP_ON_HAND   - DO                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQ        - DQ                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     06660000
              INCLUDE TBDELQ                                            06670000
           END-EXEC.                                                    06680000
      *                                                                         
      ******************************************************************        
      *    CSS_GUARANTOR     - GU                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_REG_PROFILE   - LR                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SURETY_BOND   - SB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_USER_PROFILE  - PF                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     01870200
              INCLUDE TBUSRPRF                                          01870300
           END-EXEC.                                                    01870400
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSSP001                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
           COPY CWS00056.                                               01680000
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET ALL RECEIVABLES                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE AR_CURSOR CURSOR FOR                              
               SELECT AC.PYMT_PRIORITY_LVL                              
                     ,AC.ITEM_ID                                        
                     ,AC.AMT_AR_DAY_00                                  
                     ,AC.AMT_AR_DAY_30                                  
                     ,AC.AMT_AR_DAY_60                                  
                     ,AC.AMT_AR_DAY_90                                  
                     ,AC.AMT_UNUSED_CR                                  
                     ,AC.TOT_SUMM_UNBILLED                              
                     ,AC.AMT_TRAN_BALANCE                               
                 FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                     
                WHERE AC.ACCOUNT_NO         = :AC-ACCOUNT-NO            
                  AND AC.PYMT_PRIORITY_LVL >= :AC-PYMT-PRIORITY-LVL     
                  AND AC.ITEM_ID           >= :AC-ITEM-ID               
                ORDER BY  PYMT_PRIORITY_LVL ASC                         
                         ,ITEM_ID DESC                                  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE AR_CURSOR CURSOR FOR                                      
MFA-TR*        SELECT AC.PYMT_PRIORITY_LVL                                      
MFA-TR*              ,AC.ITEM_ID                                                
MFA-TR*              ,AC.AMT_AR_DAY_00                                  07160000
MFA-TR*              ,AC.AMT_AR_DAY_30                                  07170000
MFA-TR*              ,AC.AMT_AR_DAY_60                                  07180000
MFA-TR*              ,AC.AMT_AR_DAY_90                                  07190000
MFA-TR*              ,AC.AMT_UNUSED_CR                                  07210000
MFA-TR*              ,AC.TOT_SUMM_UNBILLED                              07220000
MFA-TR*              ,AC.AMT_TRAN_BALANCE                                       
MFA-TR*          FROM CSS_AR_CNTL  AC                                           
MFA-TR*         WHERE AC.ACCOUNT_NO         = :AC-ACCOUNT-NO                    
MFA-TR*           AND AC.PYMT_PRIORITY_LVL >= :AC-PYMT-PRIORITY-LVL     07260000
MFA-TR*           AND AC.ITEM_ID           >= :AC-ITEM-ID               07270000
MFA-TR*         ORDER BY  PYMT_PRIORITY_LVL ASC                                 
MFA-TR*                  ,ITEM_ID DESC                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET ALL CHRG OFF RECEIVABLES                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CHRG_OFF CURSOR FOR                               
               SELECT PYMT_PRIORITY_LVL                                 
                     ,ITEM_ID                                           
                     ,AMT_TRANS                                         
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO         =  :CO-ACCOUNT-NO              
                  AND PYMT_PRIORITY_LVL >=  :CO-PYMT-PRIORITY-LVL       
                  AND ITEM_ID           >=  :CO-ITEM-ID                 
                ORDER BY PYMT_PRIORITY_LVL ASC                          
                        ,ITEM_ID ASC                                    
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07330000
MFA-TR*       DECLARE CHRG_OFF CURSOR FOR                               07340000
MFA-TR*        SELECT PYMT_PRIORITY_LVL                                 07350000
MFA-TR*              ,ITEM_ID                                           07360000
MFA-TR*              ,AMT_TRANS                                         07370000
MFA-TR*          FROM CSS_CHRG_OFF                                      07380000
MFA-TR*         WHERE ACCOUNT_NO         =  :CO-ACCOUNT-NO              07390000
MFA-TR*           AND PYMT_PRIORITY_LVL >=  :CO-PYMT-PRIORITY-LVL       07400000
MFA-TR*           AND ITEM_ID           >=  :CO-ITEM-ID                 07410000
MFA-TR*         ORDER BY PYMT_PRIORITY_LVL ASC                          07420000
MFA-TR*                 ,ITEM_ID ASC                                    07430000
MFA-TR*           FOR FETCH ONLY WITH UR                                07440000
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                    07450000
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET ALL AR-TYPE DTLS.                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE AR-TYPE CURSOR FOR                                
               SELECT L5.PYMT_PRIORITY_LVL                              
                     ,L5.AR_TYPE_SHORT_DESC                             
                     ,L5.AR_TYPE_LONG_DESC                              
                 FROM CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                      
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE AR-TYPE CURSOR FOR                                        
MFA-TR*        SELECT L5.PYMT_PRIORITY_LVL                                      
MFA-TR*              ,L5.AR_TYPE_SHORT_DESC                                     
MFA-TR*              ,L5.AR_TYPE_LONG_DESC                                      
MFA-TR*          FROM CSS_AR_TYPE L5                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7570                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-PROCESS-CODE                PIC X(01).                  
       01  PARM-FROM-ACCT-NO                PIC X(13).                  
       01  PARM-TO-ACCT-NO                  PIC X(13).                  
       01  PARM-USER-ID                     PIC X(07).                  
      *                                                                         
       PROCEDURE DIVISION USING                                         
                          PARM-PROCESS-CODE                             
                          PARM-FROM-ACCT-NO                             
                          PARM-TO-ACCT-NO                               
                          PARM-USER-ID.                                 
                                                                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS                                 
                      WS-CODES-DATA-PRESENT                             
                      WS-PYMT-PRIORITY-LVL                              
                      WS-NULL-IND-AMT-DEP                               
                      WS-EXISTS.                                        
      *                                                                         
           MOVE PARM-FROM-ACCT-NO           TO WS-FROM-ACCT-NO-CHAR     
           MOVE PARM-TO-ACCT-NO             TO WS-TO-ACCT-NO-CHAR       
           MOVE 'N'                         TO S-R1-BBP-IND             
                                               S-R1-STA-IND             
                                               S-R1-DEPOSIT-WAIVER-CD   
                                               S-R1-DPP-IND             
                                               S-R1-AR-LOCKOUT-IND      
                                               S-R1-PREPAY-IND          
                                               S-R1-FACLTY-DAM-IND      
                                               S-R1-BANK-DRAFT-IND      
                                               S-R1-GUARANTEE-IND       
                                               S-R1-GUARANTOR-IND       
                                               WS-WRITEOFF-FLAG         
                                               WS-FACLTY-DAM-EXISTS     
                                               S-R1-IS-ACT-DR-6YR-OLD   
                                               S-R1-RECV-ERR-FND-IND.   
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
      *                                                                         
           MOVE ZERO                        TO WS-DATABASE.             
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 7120-SELECT-DELINQ-VALUE THRU 7120-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
           IF AR-TYPE-TBL-LOADED                                        
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7560-OPEN-AR-TYPE-CURSOR      THRU 7560-EXIT      
              PERFORM 7570-FETCH-AR-TYPE-CURSOR     THRU 7570-EXIT      
              SET T2-INDEX                  TO 1                        
              PERFORM 2730-LOAD-AR-TYPE             THRU 2730-EXIT      
                UNTIL SQLCODE = NOT-FOUND                               
              PERFORM 7580-CLOSE-AR-TYPE-CURSOR     THRU 7580-EXIT      
              SET AR-TYPE-TBL-LOADED        TO TRUE                     
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1 - CSS_RATE_COMP_DEF                       *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04612_R1'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04612_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04612_R1
              (                                                          
               RETURN_CODE              INT                         
              ,DPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,AR_LOCKOUT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,FULLY_PAID_DEP_AMT       DECIMAL(9,2)                   
              ,FULLY_PAID_DEP_CNT       INT                         
              ,BBP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,DEPOSIT_WAIVER_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,REG_GROUP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,ACCOUNT_TYPE_CODE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,PREPAY_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,FACLTY_DAM_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,BANK_DRAFT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,GUARANTEE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,GUARANTOR_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,SIX_YR_OLD_ACC_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,RECV_ERR_FND_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,RESP_AREA_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,STA_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,LTRIM(RTRIM(DPP_IND))            AS DPP_IND                  
                 ,LTRIM(RTRIM(AR_LOCKOUT_IND))     AS AR_LOCKOUT_IND           
                 ,FULLY_PAID_DEP_AMT        AS FULLY_PAID_DEP_AMT       
                 ,FULLY_PAID_DEP_CNT        AS FULLY_PAID_DEP_CNT       
                 ,LTRIM(RTRIM(BBP_IND))            AS BBP_IND                  
                 ,LTRIM(RTRIM(DEPOSIT_WAIVER_CD))  AS DEPOSIT_WAIVER_CD        
                 ,LTRIM(RTRIM(REG_GROUP_CD))       AS REG_GROUP_CD             
                 ,LTRIM(RTRIM(ACCOUNT_TYPE_CODE))  AS ACCOUNT_TYPE_CODE        
                 ,LTRIM(RTRIM(PREPAY_IND))         AS PREPAY_IND               
                 ,LTRIM(RTRIM(FACLTY_DAM_IND))     AS FACLTY_DAM_IND           
                 ,LTRIM(RTRIM(BANK_DRAFT_IND))     AS BANK_DRAFT_IND           
                 ,LTRIM(RTRIM(GUARANTEE_IND))      AS GUARANTEE_IND            
                 ,LTRIM(RTRIM(GUARANTOR_IND))      AS GUARANTOR_IND            
                 ,LTRIM(RTRIM(SIX_YR_OLD_ACC_IND)) AS SIX_YR_OLD_ACC_IND       
                 ,LTRIM(RTRIM(RECV_ERR_FND_IND))   AS RECV_ERR_FND_IND         
                 ,LTRIM(RTRIM(RESP_AREA_ID))       AS RESP_AREA_ID             
                 ,LTRIM(RTRIM(AT_LAST_UPDATE_TS))  AS AT_LAST_UPDATE_TS        
                 ,LTRIM(RTRIM(STA_IND))            AS STA_IND                  
               FROM #CSR04612_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(DPP_IND)            AS DPP_IND                          
MFA-TR*          ,STRIP(AR_LOCKOUT_IND)     AS AR_LOCKOUT_IND                   
MFA-TR*          ,FULLY_PAID_DEP_AMT        AS FULLY_PAID_DEP_AMT               
MFA-TR*          ,FULLY_PAID_DEP_CNT        AS FULLY_PAID_DEP_CNT               
MFA-TR*          ,STRIP(BBP_IND)            AS BBP_IND                          
MFA-TR*          ,STRIP(DEPOSIT_WAIVER_CD)  AS DEPOSIT_WAIVER_CD                
MFA-TR*          ,STRIP(REG_GROUP_CD)       AS REG_GROUP_CD                     
MFA-TR*          ,STRIP(ACCOUNT_TYPE_CODE)  AS ACCOUNT_TYPE_CODE                
MFA-TR*          ,STRIP(PREPAY_IND)         AS PREPAY_IND                       
MFA-TR*          ,STRIP(FACLTY_DAM_IND)     AS FACLTY_DAM_IND                   
MFA-TR*          ,STRIP(BANK_DRAFT_IND)     AS BANK_DRAFT_IND                   
MFA-TR*          ,STRIP(GUARANTEE_IND)      AS GUARANTEE_IND                    
MFA-TR*          ,STRIP(GUARANTOR_IND)      AS GUARANTOR_IND                    
MFA-TR*          ,STRIP(SIX_YR_OLD_ACC_IND) AS SIX_YR_OLD_ACC_IND               
MFA-TR*          ,STRIP(RECV_ERR_FND_IND)   AS RECV_ERR_FND_IND                 
MFA-TR*          ,STRIP(RESP_AREA_ID)       AS RESP_AREA_ID                     
MFA-TR*          ,STRIP(AT_LAST_UPDATE_TS)  AS AT_LAST_UPDATE_TS                
MFA-TR*          ,STRIP(STA_IND)            AS STA_IND                          
MFA-TR*        FROM SESSION.CSR04612_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-R2.                                            
      *                                                                         
           MOVE 'SESSION.CSR04612_R2'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04612_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04612_R2
              (                                                          
               RETURN_CODE              INT                         
              ,PYMT_PRIORITY_LVL        SMALLINT                        
              ,RECV_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,RECV_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,ITEM_ID                  INT                         
              ,FULL_BALANCE             DECIMAL(13,2)                   
              ,LIEN_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,WRITEOFF_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,TOT_SUMM_UNBILLED        DECIMAL(13,2)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,PYMT_PRIORITY_LVL         AS PYMT_PRIORITY_LVL        
                 ,LTRIM(RTRIM(RECV_TYPE))          AS RECV_TYPE                
                 ,LTRIM(RTRIM(RECV_DESC))          AS RECV_DESC                
                 ,ITEM_ID                   AS ITEM_ID                  
                 ,FULL_BALANCE              AS FULL_BALANCE             
                 ,LTRIM(RTRIM(LIEN_CD))            AS LIEN_CD                  
                 ,LTRIM(RTRIM(WRITEOFF_FLAG))      AS WRITEOFF_FLAG            
                 ,TOT_SUMM_UNBILLED         AS TOT_SUMM_UNBILLED        
               FROM #CSR04612_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,PYMT_PRIORITY_LVL         AS PYMT_PRIORITY_LVL                
MFA-TR*          ,STRIP(RECV_TYPE)          AS RECV_TYPE                        
MFA-TR*          ,STRIP(RECV_DESC)          AS RECV_DESC                        
MFA-TR*          ,ITEM_ID                   AS ITEM_ID                          
MFA-TR*          ,FULL_BALANCE              AS FULL_BALANCE                     
MFA-TR*          ,STRIP(LIEN_CD)            AS LIEN_CD                          
MFA-TR*          ,STRIP(WRITEOFF_FLAG)      AS WRITEOFF_FLAG                    
MFA-TR*          ,TOT_SUMM_UNBILLED         AS TOT_SUMM_UNBILLED                
MFA-TR*        FROM SESSION.CSR04612_R2                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF PARM-FROM-ACCT-NO NOT NUMERIC OR                          
              PARM-TO-ACCT-NO   NOT NUMERIC                             
              MOVE ZEROES                   TO PARM-FROM-ACCT-NO        
                                               PARM-TO-ACCT-NO          
           END-IF.                                                      
      *                                                                         
           IF PARM-TO-ACCT-NO = 0                                       
              INITIALIZE GTT-RETURN-FIELDS-1                            
                         GTT-RETURN-FIELDS-2                            
              MOVE +100         TO S-R1-RETURN-CODE                     
                                   S-R2-RETURN-CODE                     
              ADD +1            TO CTR-ROWS-RS1                         
                                   CTR-ROWS-RS2                         
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           IF PARM-USER-ID > SPACES                                     
              MOVE PARM-USER-ID             TO PF-USER-ID               
              PERFORM 7130-SELECT-RESP-AREA THRU 7130-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 7999-SELECT-AL  THRU 7999-SELECT-AL-EXIT             
           EVALUATE PARM-PROCESS-CODE                                   
               WHEN 'F'                                                 
                    PERFORM 2100-FROM-ACCT-PROCESS   THRU 2100-EXIT     
                    PERFORM 2200-BUILD-RESULTS-1     THRU 2200-EXIT     
                    PERFORM 2300-BUILD-RESULTS-2     THRU 2300-EXIT     
               WHEN 'T'                                                 
                    PERFORM 2150-TO-ACCT-PROCESS     THRU 2150-EXIT     
                    PERFORM 2200-BUILD-RESULTS-1     THRU 2200-EXIT     
               WHEN 'A'                                                 
                    MOVE AL-AR-LOCKOUT-IND  TO S-R1-AR-LOCKOUT-IND      
                    PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-FROM-ACCT-PROCESS                                                  
      ******************************************************************        
      *                                                                         
       2100-FROM-ACCT-PROCESS.                                          
      *                                                                         
           MOVE WS-FROM-ACCT-NO-NUM         TO AT-ACCOUNT-NO            
                                               DO-ACCOUNT-NO            
                                               LR-ACCOUNT-NO            
                                               SB-ACCOUNT-NO            
                                               CT-ACCOUNT-NO            
                                               GU-ACCOUNT-NO.           
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT.             
           MOVE PF-RESP-AREA-ID             TO S-R1-RESP-AREA-ID        
           MOVE AT-LAST-UPDATE-TS           TO S-R1-AT-LAST-UPDATE-TS   
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT    
      *                                                                         
           IF AT-COMPANY-NO = '26'                                      
              MOVE 'L'                      TO CT-CODE-CONTRACT-TYPE    
              PERFORM 7090-CHECK-FACIL-DAMG THRU 7090-EXIT              
              MOVE WS-FACLTY-DAM-EXISTS     TO S-R1-FACLTY-DAM-IND      
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-BANK-EFT = 'A'                                    
              MOVE 'Y'                      TO S-R1-BANK-DRAFT-IND      
           END-IF                                                       
      *                                                                         
           IF WS-CODE-STA-ACCT = 'A'                                    
              MOVE 'Y'                      TO S-R1-STA-IND             
           END-IF                                                       
      *                                                                         
           PERFORM 7110-CHECK-FOR-GUARANTEE THRU 7110-EXIT.             
           IF SQLCODE = 0                                               
              MOVE 'Y'                      TO S-R1-GUARANTEE-IND       
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150-TO-ACCT-PROCESS                                                    
      ******************************************************************        
      *                                                                         
       2150-TO-ACCT-PROCESS.                                            
      *                                                                         
           MOVE WS-TO-ACCT-NO-NUM           TO AT-ACCOUNT-NO            
                                               DO-ACCOUNT-NO            
                                               LR-ACCOUNT-NO            
                                               SB-ACCOUNT-NO            
                                               CT-ACCOUNT-NO            
                                               GU-ACCOUNT-NO.           
      *                                                                         
           PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT              
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT    
      *                                                                         
           IF WS-CODE-BANK-EFT = 'A'                                    
              MOVE 'Y'                      TO S-R1-BANK-DRAFT-IND      
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-STA-ACCT = 'A'                                    
              MOVE 'Y'                      TO S-R1-STA-IND             
           END-IF                                                       
      *                                                                         
           IF AT-COMPANY-NO = '26'                                      
              MOVE 'L'                      TO CT-CODE-CONTRACT-TYPE    
              PERFORM 7090-CHECK-FACIL-DAMG THRU 7090-EXIT              
              MOVE WS-FACLTY-DAM-EXISTS     TO S-R1-FACLTY-DAM-IND      
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO               TO GU-GUARNTR-ACCT-NO       
           MOVE WS-FROM-ACCT-NO-NUM         TO GU-ACCOUNT-NO            
           PERFORM 7060-CHECK-FOR-GRNTR     THRU 7060-EXIT              
           IF SQLCODE = 0                                               
              MOVE 'Y'                      TO S-R1-GUARANTOR-IND       
           END-IF.                                                      
                                                                        
           PERFORM 2700-GET-WRITEOFF-FLAG   THRU 2700-EXIT              
           MOVE WS-WRITEOFF-FLAG            TO S-R1-IS-ACT-DR-6YR-OLD.  
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULTS-1.                                                   
      ******************************************************************        
      *                                                                         
       2200-BUILD-RESULTS-1.                                            
      *                                                                         
           IF WS-CODE-DPP-ACCT = 'A'                                    
              MOVE 'Y'                      TO S-R1-DPP-IND             
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-BUDGET   = 'A'                                    
              MOVE 'Y'                      TO S-R1-BBP-IND             
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-TYPE-CODE        TO S-R1-ACCT-TYPE-CD        
           PERFORM 7020-SEL-DEPOSIT-WAIVER-CD  THRU 7020-EXIT           
           IF SQLCODE = 0                                               
              MOVE 'Y'                      TO S-R1-DEPOSIT-WAIVER-CD   
           END-IF                                                       
      *                                                                         
           IF SEB-DATABASE                                              
              MOVE 'N'                      TO WS-EXISTS                
              PERFORM 7080-CHECK-FOR-REG-PROFILE  THRU 7080-EXIT        
              IF SQLCODE = 0                                            
                 MOVE LR-REG-GROUP-CD       TO S-R1-REG-GROUP-CD        
              END-IF                                                    
                                                                        
              IF WS-CODE-PRE-PAY-PLAN = 'A'                             
                 MOVE 'Y'                   TO S-R1-PREPAY-IND          
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF PARM-PROCESS-CODE = 'F'                                   
              PERFORM 7010-SEL-FULLY-PAID-DEP-AMT THRU 7010-EXIT        
              IF SQLCODE = 0                                            
                 MOVE DO-AMT-DEPOSIT        TO S-R1-FULLY-PAID-AMT      
                 MOVE WS-DEPOSIT-CNT        TO S-R1-DEPOSIT-CNT         
              END-IF                                                    
              MOVE AL-AR-LOCKOUT-IND        TO S-R1-AR-LOCKOUT-IND      
           END-IF.                                                      
      *                                                                         
           PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT.       
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-BUILD-RESULTS-2.                                                   
      ******************************************************************        
      *                                                                         
       2300-BUILD-RESULTS-2.                                            
      *                                                                         
           MOVE WS-FROM-ACCT-NO-NUM         TO AC-ACCOUNT-NO            
                                               AT-ACCOUNT-NO.           
           MOVE ZEROES                      TO AC-PYMT-PRIORITY-LVL     
                                               AC-ITEM-ID.              
      *                                                                         
           IF PARM-PROCESS-CODE = 'T'                                   
              PERFORM 7000-SELECT-ACCOUNT          THRU 7000-EXIT       
              MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-OPEN-AR-CURSOR             THRU 7500-EXIT.      
           PERFORM 7510-FETCH-AR-CURSOR            THRU 7510-EXIT.      
           PERFORM 2400-GET-AR-BALANCE             THRU 2400-EXIT       
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7520-CLOSE-AR-CURSOR            THRU 7520-EXIT.      
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'S'                                   
              MOVE AT-ACCOUNT-NO            TO CO-ACCOUNT-NO            
              MOVE ZEROES                   TO CO-PYMT-PRIORITY-LVL     
                                               CO-ITEM-ID               
              PERFORM 7590-OPEN-CHARGE-OFF-CURSOR  THRU 7590-EXIT       
              PERFORM 7600-FETCH-CHARGE-OFF-CURSOR THRU 7600-EXIT       
              PERFORM 2750-LOAD-CHARGE-OFF-DTLS    THRU 2750-EXIT       
                UNTIL SQLCODE = NOT-FOUND                               
              PERFORM 7610-CLOSE-CHARGE-OFF-CURSOR THRU 7610-EXIT       
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-AR-BALANCE                                            *        
      ******************************************************************        
      *                                                                         
       2400-GET-AR-BALANCE.                                             
      *                                                                         
           MOVE ZEROES                      TO WS-PYMT-PRIORITY-LVL     
           MOVE 'N'                         TO WS-PROCESSED-SW          
           MOVE 'N'                         TO S-R2-LIEN-CD             
      *                                                                         
           MOVE AC-PYMT-PRIORITY-LVL        TO S-R2-PYMT-PRIORITY-LVL   
                                               WS-PYMT-PRIORITY-LVL.    
      *                                                                         
           PERFORM 2740-GET-AR-TYPE-DESC    THRU 2740-EXIT.             
           MOVE WS-AR-TYPE-SHORT-DESC       TO S-R2-RECV-TYPE           
           MOVE WS-AR-TYPE-LONG-DESC        TO S-R2-RECV-DESC           
      *                                                                         
           IF AC-PYMT-PRIORITY-LVL = WS-DFA AND                         
              AC-ITEM-ID >  0               AND                         
              AC-ITEM-ID <  40000000                                    
              MOVE 'DPP'                    TO S-R2-RECV-TYPE           
              MOVE 'DEFERRED PAYMENT PLAN'  TO S-R2-RECV-DESC           
           END-IF.                                                      
      *                                                                         
           IF AC-PYMT-PRIORITY-LVL = WS-BBP AND                         
              WS-CODE-PRE-PAY-PLAN = 'A'                                
              MOVE 'PRP'                    TO S-R2-RECV-TYPE           
              MOVE 'PRE-PAY PLAN'           TO S-R2-RECV-DESC           
           END-IF.                                                      
      *                                                                         
           IF (AC-ITEM-ID = 0 AND                                       
              (AC-PYMT-PRIORITY-LVL = 0      OR                         
               AC-PYMT-PRIORITY-LVL = WS-NSC OR                         
               AC-PYMT-PRIORITY-LVL = WS-NSA OR                         
               AC-PYMT-PRIORITY-LVL = WS-NSN OR                         
               AC-PYMT-PRIORITY-LVL = WS-LPC OR                         
               AC-PYMT-PRIORITY-LVL = WS-LPN OR                         
               AC-PYMT-PRIORITY-LVL = WS-UTE OR                         
               AC-PYMT-PRIORITY-LVL = WS-UTG))                          
              SET PROCESSED-FL  TO TRUE                                 
              ADD  AC-AMT-AR-DAY-00                                     
                   AC-AMT-AR-DAY-30                                     
                   AC-AMT-AR-DAY-60                                     
                   AC-AMT-AR-DAY-90                                     
                   AC-AMT-UNUSED-CR   GIVING S-R2-FULL-BALANCE          
              IF AC-TOT-SUMM-UNBILLED > 0                               
                 ADD AC-TOT-SUMM-UNBILLED  TO S-R2-FULL-BALANCE         
                 MOVE AC-TOT-SUMM-UNBILLED TO S-R2-TOT-SUMM-UNBILLED    
              ELSE                                                      
                 MOVE ZERO                 TO S-R2-TOT-SUMM-UNBILLED    
              END-IF                                                    
              IF S-R2-FULL-BALANCE < 0                                  
                 MOVE 'Y'                  TO S-R1-RECV-ERR-FND-IND     
              END-IF                                                    
           ELSE                                                         
              IF AC-ITEM-ID > 0                                         
                 PERFORM 2710-PYMT-PRIORITY-DTLS  THRU 2710-EXIT        
                 IF AC-PYMT-PRIORITY-LVL NOT = WS-CIA AND WS-BBP        
ACT224                                         AND WS-RCC               
                    AND S-R2-FULL-BALANCE < 0                           
                    MOVE 'Y'                   TO S-R1-RECV-ERR-FND-IND 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF PROCESSED-FL                                              
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
           PERFORM 7510-FETCH-AR-CURSOR     THRU 7510-EXIT.             
      *                                                                         
        2400-EXIT.                                                      
            EXIT.                                                       
      *                                                                 11670000
      ******************************************************************        
      *  2700-GET-WRITEOFF-FLAG                                        *        
      ******************************************************************        
      *                                                                         
       2700-GET-WRITEOFF-FLAG.                                          
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'S' AND AT-COMPANY-NO = '01'          
              MOVE 'WO-CUTOFF-DT'           TO C8-DELINQ-CD             
              MOVE AT-COMPANY-NO            TO C8-COMPANY-NO            
              PERFORM 7040-SELECT-WO-DELINQ THRU 7040-EXIT              
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2710-PYMT-PRIORITY-DTLS                                       *31850000
      ******************************************************************        
      *                                                                         
       2710-PYMT-PRIORITY-DTLS.                                         
      *                                                                         
           IF AC-PYMT-PRIORITY-LVL = WS-BBP OR WS-RCC OR WS-CIA OR      
                           WS-CNT OR WS-DEP OR WS-DFA OR WS-PJS         
              MOVE AC-ITEM-ID               TO S-R2-ITEM-ID             
              MOVE AC-AMT-TRAN-BALANCE      TO S-R2-FULL-BALANCE        
              IF AC-TOT-SUMM-UNBILLED > 0                               
                 MOVE AC-TOT-SUMM-UNBILLED  TO S-R2-TOT-SUMM-UNBILLED   
              ELSE                                                      
                 MOVE ZERO                  TO S-R2-TOT-SUMM-UNBILLED   
              END-IF                                                    
              SET PROCESSED-FL              TO TRUE                     
                                                                        
              IF AC-PYMT-PRIORITY-LVL = WS-CNT                          
                 MOVE AC-ACCOUNT-NO         TO CT-ACCOUNT-NO            
                 MOVE AC-PYMT-PRIORITY-LVL  TO CT-PYMT-PRIORITY-LVL     
                 MOVE AC-ITEM-ID            TO CT-CNT-ITEM-ID           
                 PERFORM 7050-SELECT-CNT    THRU 7050-EXIT              
                 IF SQLCODE = 0                                         
                    IF (CT-CNT-STATUS-CD = 'A' AND                      
                        AC-AMT-TRAN-BALANCE < 0)                        
                       MOVE 'N'             TO S-R2-LIEN-CD             
                    ELSE                                                
                       MOVE CT-LIEN-CD      TO S-R2-LIEN-CD             
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2730-LOAD-AR-TYPE                                             *31850000
      ******************************************************************        
      *                                                                         
       2730-LOAD-AR-TYPE.                                               
      *                                                                         
           MOVE L5-PYMT-PRIORITY-LVL  TO T2-PYMT-PRIORITY-LVL(T2-INDEX) 
           MOVE L5-AR-TYPE-SHORT-DESC TO T2-AR-TYPE-SHORT-DESC          
                                                    (T2-INDEX)          
           MOVE L5-AR-TYPE-LONG-DESC  TO T2-AR-TYPE-LONG-DESC(T2-INDEX) 
           SET T2-INDEX UP BY 1.                                        
      *                                                                         
           PERFORM 7570-FETCH-AR-TYPE-CURSOR THRU 7570-EXIT.            
      *                                                                         
       2730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2740-GER-AR-TYPE-DESC                                         *        
      ******************************************************************        
      *                                                                         
       2740-GET-AR-TYPE-DESC.                                           
      *                                                                         
           MOVE SPACES  TO WS-AR-TYPE-SHORT-DESC                        
                           WS-AR-TYPE-LONG-DESC.                        
      *                                                                         
           SET T2-INDEX TO +1.                                          
           SEARCH T2-AR-TYPE                                            
               AT END                                                   
                  MOVE SPACES TO WS-AR-TYPE-SHORT-DESC                  
                                 WS-AR-TYPE-LONG-DESC                   
             WHEN T2-PYMT-PRIORITY-LVL(T2-INDEX) = WS-PYMT-PRIORITY-LVL 
                  MOVE T2-AR-TYPE-SHORT-DESC(T2-INDEX) TO               
                       WS-AR-TYPE-SHORT-DESC                            
                  MOVE T2-AR-TYPE-LONG-DESC(T2-INDEX)  TO               
                       WS-AR-TYPE-LONG-DESC                             
           END-SEARCH.                                                  
      *                                                                         
       2740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2750-LOAD-CHARGE-OFF-DTLS                                      *        
      ******************************************************************        
      *                                                                         
       2750-LOAD-CHARGE-OFF-DTLS.                                       
      *                                                                 30760000
           MOVE ZEROES                      TO WS-PYMT-PRIORITY-LVL.    
           MOVE 'N'                         TO S-R2-LIEN-CD.            
      *                                                                         
           MOVE CO-PYMT-PRIORITY-LVL        TO S-R2-PYMT-PRIORITY-LVL   
                                               WS-PYMT-PRIORITY-LVL.    
      *                                                                         
           PERFORM 2740-GET-AR-TYPE-DESC    THRU 2740-EXIT.             
           MOVE WS-AR-TYPE-SHORT-DESC       TO S-R2-RECV-TYPE.          
           MOVE WS-AR-TYPE-LONG-DESC        TO S-R2-RECV-DESC.          
           MOVE CO-ITEM-ID                  TO S-R2-ITEM-ID.            
           MOVE CO-AMT-TRANS                TO S-R2-FULL-BALANCE.       
           MOVE 'Y'                         TO S-R2-WRITEOFF-FLAG.      
      *                                                                         
      *                                                                 31070000
           PERFORM 8020-INSERT-GTT-R2           THRU 8020-EXIT.         
           PERFORM 7600-FETCH-CHARGE-OFF-CURSOR THRU 7600-EXIT.         
      *                                                                 31070000
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7000-SELECT-ACCOUNT                                           *31850000
      ******************************************************************        
      *                                                                         
       7000-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
                    ,MST_SUB_ACCT_IND                                   
                    ,CREDIT_GROUP                                       
                    ,CODE_ACCT_STAT                                     
                    ,ACCOUNT_TYPE_CODE                                  
                    ,COMPANY_NO                                         
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-COMPANY-NO                                     
                    ,:AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*       SELECT CODES_DATA_PRESENT                                 32000000
MFA-TR*             ,MST_SUB_ACCT_IND                                           
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,ACCOUNT_TYPE_CODE                                          
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                             32260000
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                               32260000
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT                                        32390000
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        32400000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 32420000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7010-SEL-FULLY-PAID-DEP-AMT                                    31850000
      ******************************************************************        
      *                                                                         
       7010-SEL-FULLY-PAID-DEP-AMT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                    ,COUNT(AMT_DEPOSIT)                                 
                INTO :DO-AMT-DEPOSIT :WS-NULL-IND-AMT-DEP               
                    ,:WS-DEPOSIT-CNT                                    
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                 
                 AND DEPOSIT_STATUS_CD = 'P'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05630000
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                   05650000
MFA-TR*             ,COUNT(AMT_DEPOSIT)                                         
MFA-TR*         INTO :DO-AMT-DEPOSIT :WS-NULL-IND-AMT-DEP                       
MFA-TR*             ,:WS-DEPOSIT-CNT                                            
MFA-TR*         FROM CSS_DEP_ON_HAND                                    05760000
MFA-TR*        WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                 05770000
MFA-TR*          AND DEPOSIT_STATUS_CD = 'P'                            05790000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                    05800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7010'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_DEP_ON_HAND'  TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE DO-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
           IF WS-NULL-IND-AMT-DEP < 0                                   
              MOVE ZEROS                    TO DO-AMT-DEPOSIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7020-SEL-DEPOSIT-WAIVER-CD                                     31850000
      ******************************************************************        
      *                                                                         
       7020-SEL-DEPOSIT-WAIVER-CD.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-EXISTS                                         
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO          = :SB-ACCOUNT-NO               
                 AND CODE_BOND_TYPE      = 'C'                          
                 AND CODE_STATUS        IN ('A','P')                    
                 AND WAIVER_TYPE_CD NOT IN ('G','H')                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05630000
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-EXISTS                                                 
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO          = :SB-ACCOUNT-NO                       
MFA-TR*          AND CODE_BOND_TYPE      = 'C'                                  
MFA-TR*          AND CODE_STATUS        IN ('A','P')                            
MFA-TR*          AND WAIVER_TYPE_CD NOT IN ('G','H')                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                    05800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7020'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_SURETY_BOND'  TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE SB-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-SELECT-WRITEOFF-DT                                        *        
      ******************************************************************        
      *                                                                         
       7030-SELECT-WRITEOFF-DT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_TRANS)                                     
                INTO :CO-AMT-TRANS :WS-NULL-IND-CHG-AMT                 
                FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO      = :CO-ACCOUNT-NO                   
                 AND DATE_OF_CHG_OFF <                                  
                     (DATEADD( YEAR, -(:C8-DELINQ-VALUE), 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_TRANS)                                             
MFA-TR*         INTO :CO-AMT-TRANS :WS-NULL-IND-CHG-AMT                         
MFA-TR*         FROM CSS_CHRG_OFF                                               
MFA-TR*        WHERE ACCOUNT_NO      = :CO-ACCOUNT-NO                           
MFA-TR*          AND DATE_OF_CHG_OFF <                                          
MFA-TR*              (DATE (CURRENT DATE) - (:C8-DELINQ-VALUE) YEARS)           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                     CONTINUE                                           
               WHEN NOT-FOUND                                           
                    MOVE ZEROS              TO CO-AMT-TRANS             
                                               WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                              ABEND-TABLES              
               MOVE 'CSS_CHRG_OFF'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE CO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
           IF WS-NULL-IND-CHG-AMT < 0                                   
              MOVE ZEROS                    TO CO-AMT-TRANS             
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7140-SELECT-WO-DELINQ.                                        *        
      ******************************************************************        
      *                                                                         
       7040-SELECT-WO-DELINQ.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND   
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-ACCOUNT-NO         TO CO-ACCOUNT-NO            
                 PERFORM 7030-SELECT-WRITEOFF-DT THRU 7030-EXIT         
                 IF CO-AMT-TRANS > 0                                    
                    MOVE 'Y'                TO WS-WRITEOFF-FLAG         
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'N'                   TO WS-WRITEOFF-FLAG         
                 MOVE 0                     TO WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7050-SELECT-CNT                                                *        
      ******************************************************************        
      *                                                                         
       7050-SELECT-CNT.                                                 
      *                                                                 35550000
           EXEC SQL                                                     
              SELECT CNT_STATUS_CD                                      
                    ,LIEN_CD                                            
                INTO :CT-CNT-STATUS-CD                                  
                    ,:CT-LIEN-CD                                        
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL          
                 AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35580000
MFA-TR*       SELECT CNT_STATUS_CD                                      35630000
MFA-TR*             ,LIEN_CD                                            35730000
MFA-TR*         INTO :CT-CNT-STATUS-CD                                  35780000
MFA-TR*             ,:CT-LIEN-CD                                        35880000
MFA-TR*         FROM CSS_CONTRACT                                       35890000
MFA-TR*        WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                 35900000
MFA-TR*          AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL          35910000
MFA-TR*          AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID                35920000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                    35930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35940000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7050'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CONTRACT'     TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2       
                    MOVE CT-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2     
                    MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-3       
                    MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-3     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7060-CHECK-FOR-GRNTR                                          *12450000
      ******************************************************************        
      *                                                                         
       7060-CHECK-FOR-GRNTR.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-EXISTS                                         
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                   
                 AND GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO              
                 AND GUAR_STATUS_CD  = 'A'                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12460000
MFA-TR*       SELECT 'Y'                                                12470000
MFA-TR*         INTO :WS-EXISTS                                         12480000
MFA-TR*         FROM CSS_GUARANTOR                                      12490000
MFA-TR*        WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                   12500000
MFA-TR*          AND GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO              12510000
MFA-TR*          AND GUAR_STATUS_CD  = 'A'                              03399700
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                    12520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12521000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7060'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_GUARANTOR'    TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE 'GUARNTR_ACCT_NO'  TO TABLE-ELEMENT-2          
                    MOVE GU-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    MOVE GU-GUARNTR-ACCT-NO TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 12660000
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12660000
      ******************************************************************        
      * 7080-CHECK-FOR-REG-PROFILE                                     *12450000
      ******************************************************************        
      *                                                                 12660000
       7080-CHECK-FOR-REG-PROFILE.                                      
      *                                                                 12660000
           EXEC SQL                                                     
              SELECT REG_GROUP_CD                                       
                INTO :LR-REG-GROUP-CD                                   
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO      = :LR-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12694000
MFA-TR*       SELECT REG_GROUP_CD                                       12695000
MFA-TR*         INTO :LR-REG-GROUP-CD                                   12696000
MFA-TR*         FROM CSS_REG_PROFILE                                    12697000
MFA-TR*        WHERE ACCOUNT_NO      = :LR-ACCOUNT-NO                   12698000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                    12699100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12699200
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                 12699200
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7080'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_REG_PROFILE'  TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE LR-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 12700900
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7090-CHECK-FACIL-DAMG                                          *        
      ******************************************************************        
      *                                                                         
       7090-CHECK-FACIL-DAMG.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-FACLTY-DAM-EXISTS                              
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                
                 AND CODE_CONTRACT_TYPE = :CT-CODE-CONTRACT-TYPE        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-FACLTY-DAM-EXISTS                                      
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO         = :CT-ACCOUNT-NO                        
MFA-TR*          AND CODE_CONTRACT_TYPE = :CT-CODE-CONTRACT-TYPE                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7090'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_CONTRACT'     TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE 'CODE_CONTRACT_TYPE'  TO TABLE-ELEMENT-2       
                    MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE CT-CODE-CONTRACT-TYPE TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************27200000
      * 7110-CHECK-FOR-GUARANTOR.                                      *27210000
      ******************************************************************27230000
      *                                                                         
       7110-CHECK-FOR-GUARANTEE.                                        
      *                                                                 27250000
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-EXISTS                                         
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                   
                 AND GUAR_STATUS_CD  = 'A'                              
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27260000
MFA-TR*       SELECT 'Y'                                                27270000
MFA-TR*         INTO :WS-EXISTS                                         27280000
MFA-TR*         FROM CSS_GUARANTOR                                      27290000
MFA-TR*        WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO                   27300000
MFA-TR*          AND GUAR_STATUS_CD  = 'A'                              27310000
MFA-TR*        FETCH FIRST ROW ONLY                                     27320000
MFA-TR*      QUERYNO 7110                                               27330000
MFA-TR*         WITH UR                                                 27340000
MFA-TR*    END-EXEC.                                                    27350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12699200
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7110'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_GUARANTOR'    TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE GU-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 12700900
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27520000
      ******************************************************************        
      * 7120-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
      *                                                                         
       7120-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7120'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_DELINQUENCY'  TO TABLE-1                  
                    MOVE 'DELINQ_CD'        TO TABLE-ELEMENT-1          
                    MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2          
                    MOVE C8-DELINQ-CD       TO HOSTVAR-ELEMENT-1        
                    MOVE C8-COMPANY-NO      TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-SELECT-RESP-AREA.                                         *        
      ******************************************************************        
      *                                                                         
       7130-SELECT-RESP-AREA.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  PF.RESP_AREA_ID                                    
               INTO  :PF-RESP-AREA-ID                                   
              FROM  CSS_USER_PROFILE  PF WITH(READUNCOMMITTED)                  
             WHERE  PF.USER_ID        =  :PF-USER-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  PF.RESP_AREA_ID                                            
MFA-TR*        INTO  :PF-RESP-AREA-ID                                           
MFA-TR*       FROM  CSS_USER_PROFILE  PF                                        
MFA-TR*      WHERE  PF.USER_ID        =  :PF-USER-ID                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7130'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE PARM-USER-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-OPEN-AR-CURSOR                                            *        
      ******************************************************************        
      *                                                                         
       7500-OPEN-AR-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN AR_CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7510-FETCH-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7510-FETCH-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH AR_CURSOR                                           
              INTO :AC-PYMT-PRIORITY-LVL,
                :AC-ITEM-ID,
                :AC-AMT-AR-DAY-00,
                :AC-AMT-AR-DAY-30,
                :AC-AMT-AR-DAY-60,
                :AC-AMT-AR-DAY-90,
                :AC-AMT-UNUSED-CR,
                :AC-TOT-SUMM-UNBILLED,
                :AC-AMT-TRAN-BALANCE                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH AR_CURSOR                                                   
MFA-TR*       INTO  :AC-PYMT-PRIORITY-LVL                                       
MFA-TR*            ,:AC-ITEM-ID                                                 
MFA-TR*            ,:AC-AMT-AR-DAY-00                                           
MFA-TR*            ,:AC-AMT-AR-DAY-30                                           
MFA-TR*            ,:AC-AMT-AR-DAY-60                                           
MFA-TR*            ,:AC-AMT-AR-DAY-90                                           
MFA-TR*            ,:AC-AMT-UNUSED-CR                                           
MFA-TR*            ,:AC-TOT-SUMM-UNBILLED                                       
MFA-TR*            ,:AC-AMT-TRAN-BALANCE                                        
MFA-TR*            ,:L5-AR-TYPE-SHORT-DESC                                      
MFA-TR*            ,:L5-AR-TYPE-LONG-DESC                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7510'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_AR_CNTL'      TO TABLE-1                  
                    MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1          
                    MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2       
                    MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3          
                    MOVE AC-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2     
                    MOVE AC-ITEM-ID         TO HOSTVAR-ELEMENT-3        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7520-CLOSE-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7520-CLOSE-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE AR_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7560-OPEN-AR-TYPE-CURSOR                                       *        
      ******************************************************************        
      *                                                                         
       7560-OPEN-AR-TYPE-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN AR-TYPE                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7560'             TO ACTIVE-PARAGRAPH         
                    MOVE 'OPEN'             TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_AR_TYPE'      TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7570-FETCH-AR-TYPE-CURSOR                                      *        
      ******************************************************************        
      *                                                                         
       7570-FETCH-AR-TYPE-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               FETCH AR-TYPE                                            
                INTO :L5-PYMT-PRIORITY-LVL                              
                    ,:L5-AR-TYPE-SHORT-DESC                             
                    ,:L5-AR-TYPE-LONG-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7570'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_AR_TYPE'      TO TABLE-1                  
                    MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7580-CLOSE-AR-TYPE-CURSOR                                      *        
      ******************************************************************        
      *                                                                         
       7580-CLOSE-AR-TYPE-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR-TYPE                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7580'             TO ACTIVE-PARAGRAPH         
                    MOVE 'CLOSE'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_AR_TYPE'         TO TABLE-1               
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7590-OPEN-CHARGE-OFF-CURSOR                                    *        
      ******************************************************************        
      *                                                                         
       7590-OPEN-CHARGE-OFF-CURSOR.                                     
      *                                                                         
           EXEC SQL                                                     
              OPEN CHRG_OFF                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 40390000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 40390000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7590'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CHRG_OFF'           TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 40390000
       7590-EXIT.                                                       
           EXIT.                                                        
      *                                                                 40580000
      ******************************************************************        
      * 7600-FETCH-CHARGE-OFF-CURSOR                                   *        
      ******************************************************************        
      *                                                                         
       7600-FETCH-CHARGE-OFF-CURSOR.                                    
      *                                                                         
           EXEC SQL                                                     
               FETCH CHRG_OFF                                           
                INTO :CO-PYMT-PRIORITY-LVL,                             
                     :CO-ITEM-ID,                                       
                     :CO-AMT-TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 40660000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 40660000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7600'               TO ACTIVE-PARAGRAPH       
                    MOVE 'OPEN'               TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_CHRG_OFF'       TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE CO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2        
                    MOVE CO-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2      
                    MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3        
                    MOVE CO-ITEM-ID           TO HOSTVAR-ELEMENT-3      
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                 40860000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 40860000
      ******************************************************************        
      * 7610-CLOSE-CHARGE-OFF-CURSOR                                   *        
      ******************************************************************        
      *                                                                         
       7610-CLOSE-CHARGE-OFF-CURSOR.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE CHRG_OFF                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 40910000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 40910000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7610'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CHRG_OFF'           TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 40910000
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7999-SELECT-AL                                                          
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04612_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04612_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04612_R1'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04612_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04612_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '8000B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'DELETE'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSR04612_R2'       TO TABLE-1                  
                   MOVE SPACES              TO TABLE-ELEMENT-1          
                   MOVE SPACES              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04612_R1                            
             (                                                          
              RETURN_CODE                                               
             ,DPP_IND                                                   
             ,AR_LOCKOUT_IND                                            
             ,FULLY_PAID_DEP_AMT                                        
             ,FULLY_PAID_DEP_CNT                                        
             ,BBP_IND                                                   
             ,DEPOSIT_WAIVER_CD                                         
             ,REG_GROUP_CD                                              
             ,ACCOUNT_TYPE_CODE                                         
             ,PREPAY_IND                                                
             ,FACLTY_DAM_IND                                            
             ,BANK_DRAFT_IND                                            
             ,GUARANTEE_IND                                             
             ,GUARANTOR_IND                                             
             ,SIX_YR_OLD_ACC_IND                                        
             ,RECV_ERR_FND_IND                                          
             ,RESP_AREA_ID                                              
             ,AT_LAST_UPDATE_TS                                         
             ,STA_IND                                                   
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
             ,:S-R1-DPP-IND                                             
             ,:S-R1-AR-LOCKOUT-IND                                      
             ,:S-R1-FULLY-PAID-AMT                                      
             ,:S-R1-DEPOSIT-CNT                                         
             ,:S-R1-BBP-IND                                             
             ,:S-R1-DEPOSIT-WAIVER-CD                                   
             ,:S-R1-REG-GROUP-CD                                        
             ,:S-R1-ACCT-TYPE-CD                                        
             ,:S-R1-PREPAY-IND                                          
             ,:S-R1-FACLTY-DAM-IND                                      
             ,:S-R1-BANK-DRAFT-IND                                      
             ,:S-R1-GUARANTEE-IND                                       
             ,:S-R1-GUARANTOR-IND                                       
             ,:S-R1-IS-ACT-DR-6YR-OLD                                   
             ,:S-R1-RECV-ERR-FND-IND                                    
             ,:S-R1-RESP-AREA-ID                                        
             ,:S-R1-AT-LAST-UPDATE-TS                                   
             ,:S-R1-STA-IND                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04612_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,DPP_IND                                                           
MFA-TR*      ,AR_LOCKOUT_IND                                                    
MFA-TR*      ,FULLY_PAID_DEP_AMT                                                
MFA-TR*      ,FULLY_PAID_DEP_CNT                                                
MFA-TR*      ,BBP_IND                                                           
MFA-TR*      ,DEPOSIT_WAIVER_CD                                                 
MFA-TR*      ,REG_GROUP_CD                                                      
MFA-TR*      ,ACCOUNT_TYPE_CODE                                                 
MFA-TR*      ,PREPAY_IND                                                        
MFA-TR*      ,FACLTY_DAM_IND                                                    
MFA-TR*      ,BANK_DRAFT_IND                                                    
MFA-TR*      ,GUARANTEE_IND                                                     
MFA-TR*      ,GUARANTOR_IND                                                     
MFA-TR*      ,SIX_YR_OLD_ACC_IND                                                
MFA-TR*      ,RECV_ERR_FND_IND                                                  
MFA-TR*      ,RESP_AREA_ID                                                      
MFA-TR*      ,AT_LAST_UPDATE_TS                                                 
MFA-TR*      ,STA_IND                                                           
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R1-RETURN-CODE                                                 
MFA-TR*      ,:S-R1-DPP-IND                                                     
MFA-TR*      ,:S-R1-AR-LOCKOUT-IND                                              
MFA-TR*      ,:S-R1-FULLY-PAID-AMT                                              
MFA-TR*      ,:S-R1-DEPOSIT-CNT                                                 
MFA-TR*      ,:S-R1-BBP-IND                                                     
MFA-TR*      ,:S-R1-DEPOSIT-WAIVER-CD                                           
MFA-TR*      ,:S-R1-REG-GROUP-CD                                                
MFA-TR*      ,:S-R1-ACCT-TYPE-CD                                                
MFA-TR*      ,:S-R1-PREPAY-IND                                                  
MFA-TR*      ,:S-R1-FACLTY-DAM-IND                                              
MFA-TR*      ,:S-R1-BANK-DRAFT-IND                                              
MFA-TR*      ,:S-R1-GUARANTEE-IND                                               
MFA-TR*      ,:S-R1-GUARANTOR-IND                                               
MFA-TR*      ,:S-R1-IS-ACT-DR-6YR-OLD                                           
MFA-TR*      ,:S-R1-RECV-ERR-FND-IND                                            
MFA-TR*      ,:S-R1-RESP-AREA-ID                                                
MFA-TR*      ,:S-R1-AT-LAST-UPDATE-TS                                           
MFA-TR*      ,:S-R1-STA-IND                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04612_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
      *                                                                         
       8020-INSERT-GTT-R2.                                              
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04612_R2                            
             (                                                          
              RETURN_CODE                                               
             ,PYMT_PRIORITY_LVL                                         
             ,RECV_TYPE                                                 
             ,RECV_DESC                                                 
             ,ITEM_ID                                                   
             ,FULL_BALANCE                                              
             ,LIEN_CD                                                   
             ,WRITEOFF_FLAG                                             
             ,TOT_SUMM_UNBILLED                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-PYMT-PRIORITY-LVL                                   
             ,:S-R2-RECV-TYPE                                           
             ,:S-R2-RECV-DESC                                           
             ,:S-R2-ITEM-ID                                             
             ,:S-R2-FULL-BALANCE                                        
             ,:S-R2-LIEN-CD                                             
             ,:S-R2-WRITEOFF-FLAG                                       
             ,:S-R2-TOT-SUMM-UNBILLED                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04612_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,PYMT_PRIORITY_LVL                                                 
MFA-TR*      ,RECV_TYPE                                                         
MFA-TR*      ,RECV_DESC                                                         
MFA-TR*      ,ITEM_ID                                                           
MFA-TR*      ,FULL_BALANCE                                                      
MFA-TR*      ,LIEN_CD                                                           
MFA-TR*      ,WRITEOFF_FLAG                                                     
MFA-TR*      ,TOT_SUMM_UNBILLED                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-R2-RETURN-CODE                                                 
MFA-TR*      ,:S-R2-PYMT-PRIORITY-LVL                                           
MFA-TR*      ,:S-R2-RECV-TYPE                                                   
MFA-TR*      ,:S-R2-RECV-DESC                                                   
MFA-TR*      ,:S-R2-ITEM-ID                                                     
MFA-TR*      ,:S-R2-FULL-BALANCE                                                
MFA-TR*      ,:S-R2-LIEN-CD                                                     
MFA-TR*      ,:S-R2-WRITEOFF-FLAG                                               
MFA-TR*      ,:S-R2-TOT-SUMM-UNBILLED                                           
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                        TO  CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04612_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF CTR-ROWS-RS1 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM            
           MOVE '8900'                      TO ACTIVE-PARAGRAPH         
           MOVE 'OPEN'                      TO ABEND-FUNCTION           
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-R1-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04612_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-R2-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04612_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-R1-RETURN-CODE         
                                               S-R2-RETURN-CODE.        
      *                                                                         
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1     THRU 0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-R2     THRU 0100B-EXIT.            
      *                                                                         
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS-RS1 < 1 AND                                      
              CTR-ROWS-RS2 < 1                                          
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
                                                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT              
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
