       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04611.                                     
COB303 DATE-WRITTEN.                                                    
COB303            FEB  18, 2013.                                        
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  INSERTS CORR ROWS FOR GAS REPLACEMENT ORDERS                           
      *                                                                         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/18/13    PD       CREATED.                                 *        
A04527*  06/07/13   MC95456   REMOVED UNUSED COPYBOOK CWS00056         *        
ACT152*  06/07/13   SS7F226   REPLACE CSS_LETTER_CONTACT WITH          *        
ACT152*              A05460   CSS_CODE_VALUE.                          *        
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04611'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04611 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      * CSS_CORRESP_HDR - 1J                                            01892000
           EXEC SQL                                                     01782000
              INCLUDE TBCORHDR                                          01783000
           END-EXEC.                                                    01784000
      * CSS_CORRESP_VAR - 1K                                            01785000
           EXEC SQL                                                     01782000
              INCLUDE TBCORVAR                                          01783000
           END-EXEC.                                                    01784000
                                                                        
ACT152* CSS_CODE_VALUE     - UV                                         01785000
           EXEC SQL                                                     01782000
ACT152        INCLUDE TBCDVALU                                          01783000
           END-EXEC.                                                    01784000
                                                                        
      * CSS_COMM_DATA      - KO                                         01785000
           EXEC SQL                                                     01782000
              INCLUDE TBCOMDAT                                          01783000
           END-EXEC.                                                    01784000
                                                                        
      * CSS_CORR_COMM      - 1L                                         01785000
           EXEC SQL                                                     01782000
              INCLUDE TBCORCOM                                          01783000
           END-EXEC.                                                    01784000
                                                                        
      * CSS_CORR_NOT       - 1M                                         01785000
           EXEC SQL                                                     01782000
              INCLUDE TBCORNOT                                          01783000
           END-EXEC.                                                    01784000
                                                                        
      * CSS_CRED_MSG_REF - 1I                                           01785000
           EXEC SQL                                                     01782000
              INCLUDE TBCRMSG                                           01783000
           END-EXEC.                                                    01784000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
       COPY CCA00001.                                                           
            EXEC SQL                                                            
               INCLUDE CWSX0010                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
               INCLUDE CWS00350                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
               INCLUDE CWSCA165                                                 
            END-EXEC.                                                           
            EXEC SQL                                                            
               INCLUDE CWSKR125                                                 
            END-EXEC.                                                           
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
       COPY CWS00341.                                                           
                                                                        
       01  WS-MISC1.                                                    
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04611'.     
           05  WS-PGRMNAME              PIC X(08) VALUE 'CSR04611'.     
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE 0.              
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE 0.              
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
           05  WS-MTR-ENV-FOUND         PIC X(01) VALUE 'N'.            
           05  WS-DATE                  PIC X(10) VALUE ' '.            
           05  WS-TIMESTAMP             PIC X(26) VALUE ' '.            
ACT152     05  WS-CODE-LONG-DESC-TEXT   PIC X(80) VALUE SPACES.         
ACT152     05  WS-CODE-SHORT-DESC-TEXT  PIC X(15) VALUE SPACES.         
ACT152     05  WS-COMMENT-TX.                                           
ACT152         49 WS-COMMENT-TX-LEN-3   PIC S9(4)  USAGE COMP.          
ACT152         49 WS-COMMENT-TX-TEXT-3  PIC X(512) VALUE SPACES.        
ACT152     05  WS-TAB-COMMENTS.                                         
ACT152         15 WS-TAB-COMM           PIC X(01)  OCCURS 512 TIMES.    
ACT152     05  WS-MAX-LENGTH            PIC S9(04) COMP VALUE 512.      
ACT152     05  WS-TX-SUB                PIC S9(04) COMP VALUE 0.        
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04611_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE1          PIC S9(9) COMP VALUE 0.         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE1           PIC S9(9) COMP VALUE 0.         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO.                        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE AS  RETURN_CODE                    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE AS  RETURN_CODE                            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO    TO PARM-ACCOUNT-NO.                  
                                                                        
           MOVE PARM-ACCOUNT-NO    TO WS-ACCOUNT-NO.                    
           MOVE WS-ACCOUNT-NO      TO AT-ACCOUNT-NO.                    
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT152*                                                                         
ACT152******************************************************************        
ACT152* 2100-REMOVE-JUNK-DATA.                                         *        
ACT152*                                                                *        
ACT152******************************************************************        
ACT152*                                                                         
ACT152 2100-REMOVE-JUNK-DATA.                                           
ACT152*                                                                         
ACT152     MOVE SPACES                       TO WS-TAB-COMMENTS.        
ACT152                                                                  
ACT152     MOVE WS-COMMENT-TX-TEXT-3         TO WS-TAB-COMMENTS.        
ACT152     MOVE WS-MAX-LENGTH                TO WS-TX-SUB.              
ACT152                                                                  
ACT152     PERFORM UNTIL WS-TAB-COMM(WS-TX-SUB) > SPACES                
ACT152                                OR WS-TX-SUB  = 0                 
ACT152             COMPUTE WS-TX-SUB = WS-TX-SUB - 1                    
ACT152     END-PERFORM.                                                 
ACT152*                                                                         
ACT152 2100-EXIT.                                                       
ACT152     EXIT.                                                        
ACT152*                                                                         
       5000-UPDATE.                                                     
           INITIALIZE WS-CORRESP-COMM-VAR                               
                     WS-MISC.                                           
           PERFORM 7000-GET-ACCOUNT    THRU 7000-EXIT.                  
           MOVE AT-PREMISE-NO          TO PR-PREMISE-NO.                
           PERFORM 7400-GET-LOCAL-OFFICE THRU 7400-EXIT.                
ACT152     MOVE AT-COMPANY-NO          TO UV-COMPANY-NO                 
ACT152     MOVE +03                    TO UV-CODE-VALUE-LEN             
ACT152     MOVE PR-LOCAL-OFFICE        TO UV-CODE-VALUE-TEXT            
ACT152     MOVE +08                    TO UV-COLUMN-NA-LEN              
ACT152     MOVE 'PHONE_NO'             TO UV-COLUMN-NA-TEXT             
ACT152     MOVE +18                    TO UV-TABLE-NA-LEN               
ACT152     MOVE 'CSS_LETTER_CONTACT'   TO UV-TABLE-NA-TEXT              
           PERFORM 7300-GET-CONTACT      THRU 7300-EXIT.                
ACT152                                                                  
ACT152     MOVE UV-CODE-LONG-DESC-TEXT TO WS-COMMENT-TX-TEXT-3          
ACT152     PERFORM 2100-REMOVE-JUNK-DATA THRU 2100-EXIT.                
ACT152     MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                            
ACT152                                 TO WS-CODE-LONG-DESC-TEXT        
ACT152                                                                  
ACT152     MOVE UV-CODE-SHORT-DESC-TEXT TO WS-COMMENT-TX-TEXT-3         
ACT152     PERFORM 2100-REMOVE-JUNK-DATA THRU 2100-EXIT.                
ACT152     MOVE WS-TAB-COMMENTS(1:WS-TX-SUB)                            
ACT152                                 TO WS-CODE-SHORT-DESC-TEXT       
ACT152                                                                  
           PERFORM 7200-GET-DATES      THRU 7200-EXIT.                  
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE AT-CUSTOMER-NO         TO 1J-CUSTOMER-NO                
           MOVE AT-ACCOUNT-NO          TO 1J-ACCOUNT-NO                 
           MOVE '75004'                TO 1J-CORRESP-MSG-ID             
                                          1L-CORRESP-MSG-ID             
                                          1I-MESSAGE-ID                 
                                          WS-MESSAGE-ID.                
           PERFORM 7500-GET-COMM-TYPE-SUBTYPE                           
                                       THRU 7500-EXIT.                  
           MOVE 1L-CORRESP-TYPE-CD     TO 1J-CORRESP-TYPE-CD            
           MOVE SPACES                 TO WS-CORRESP-ID-FND             
                                          WS-MESSAGE-ID-FND.            
           MOVE WS-DATE                TO 1J-CORRESP-STMT-DT            
                                          1L-EFF-TO-DT.                 
           MOVE 0                      TO 1J-GUARNTR-ACCT-NO            
           MOVE 0                      TO 1J-THD-PRTY-ID                
           MOVE 0                      TO 1J-CORRESP-SEQ-NO             
           MOVE AT-COMPANY-NO          TO 1J-CORRESP-COMPANY-NO         
                                          1L-COMPANY-NO                 
                                          1I-COMPANY-NO                 
           MOVE WS-TIMESTAMP           TO 1J-CORRESP-CREATE-TS          
           MOVE 'I'                    TO 1J-CORRESP-STATUS-CD          
           MOVE ' '                    TO 1J-REG-GROUP-CD               
           MOVE ' '                    TO 1J-SENIOR-FL                  
           MOVE ' '                    TO 1J-BARCODE-UNIQUE-ID          
           MOVE 'CSR04611'             TO 1J-CREATED-BY-PGM-ID          
           MOVE 'CSR04611'             TO 1J-LAST-UPDATE-PGM-ID         
           MOVE WS-TIMESTAMP           TO 1J-LAST-UPDATE-TS             
                                                                        
           MOVE PR-LOCAL-OFFICE        TO WS-CWS350-LOCAL-OFFICE        
           MOVE 1                      TO WS-CWS350-DATABASE            
           SET ONLINE-CALL             TO TRUE.                         
           SET WS-COR-INDX             TO 1.                            
***********PERFORM 5430-POPULATE-CA165IN-DTLS THRU 5430-CPD350-EXIT             
           MOVE 'NONMKT'                  TO WS-CA165IN-CORR-TYPE.      
           MOVE 1J-CUSTOMER-NO            TO WS-CA165IN-CUSTOMER-NO.    
           MOVE 1J-ACCOUNT-NO             TO WS-CA165IN-ACCOUNT-NO      
           MOVE 1J-CORRESP-STMT-DT        TO WS-CA165IN-PROCESS-DATE.   
           MOVE 1J-CORRESP-COMPANY-NO     TO WS-CA165IN-COMPANY-NO.     
           MOVE WS-CWS350-DATABASE        TO WS-CA165IN-DATABASE.       
           MOVE SPACES                    TO WS-CA165IN-TP-MEMO-PROCESS.
           MOVE WS-CWS350-LOCAL-OFFICE    TO WS-CA165IN-LOCAL-OFFICE.   
           MOVE 'SYSTEM'                  TO WS-CA165IN-UPDATE-USERID.  
           MOVE PROGRAM-NAME              TO WS-CA165IN-APPL-PROGRAM-ID.
                                                                        
           IF CWS350-SEB-DATABASE                                       
              MOVE 1J-REG-GROUP-CD        TO WS-CA165IN-REG-GROUP-CD    
           ELSE                                                         
              MOVE SPACES                 TO WS-CA165IN-REG-GROUP-CD    
           END-IF.                                                      
***************  COPYBOOK CPD00350 CODE PULLED OUT                      00051005
                                                                        
           PERFORM 5440-CALL-MCSCB165      THRU 5440-CPD350-EXIT        
           MOVE WS-CA165OUT-UNIQ-ID    TO 1J-BARCODE-UNIQUE-ID          
           PERFORM 7000-GET-CORRESP-ID           THRU 7000-CPD350-EXIT. 
           MOVE WS-CORRESP-ID          TO 1J-CORRESP-ID                 
                                          1K-CORRESP-ID                 
           PERFORM 8001-INSERT-CORRESP-HDR                              
                                       THRU 8001-EXIT.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = 0                                 
            MOVE SPACES                 TO WS-CA165IN-PROCESS-DATE      
            MOVE 'ALPHA-VAR-1'          TO 1K-CORRESP-VAR-NM            
            MOVE 'GAS OP CONTACT NAME'  TO 1K-CORRESP-VAR-DATA          
            MOVE 0                      TO 1K-CORRESP-VAR-NUM           
ACT152      MOVE WS-CODE-LONG-DESC-TEXT TO 1K-CORRESP-VAR-CHAR          
            PERFORM 8050-INSERT-CORRESP-VAR THRU 8050-EXIT              
                                                                        
            MOVE 'ALPHA-VAR-2'          TO 1K-CORRESP-VAR-NM            
            MOVE 'GAS OP CONTACT PHONE' TO 1K-CORRESP-VAR-DATA          
            MOVE 0                      TO 1K-CORRESP-VAR-NUM           
ACT152      MOVE WS-CODE-SHORT-DESC-TEXT                                
ACT152                                  TO 1K-CORRESP-VAR-CHAR          
            PERFORM 8050-INSERT-CORRESP-VAR THRU 8050-EXIT              
            IF 1L-COMM-INSERT-FL = 'Y'                                  
              MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO              
              MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO             
              MOVE AT-PREMISE-NO          TO KO-PREMISE-NO              
              MOVE AT-COMPANY-NO          TO KO-COMPANY-NO              
              MOVE 'N'                    TO KO-RED-FLAG-IND            
              MOVE 'L'                    TO KO-COMM-METHOD             
              MOVE 'O'                    TO KO-COMM-DIRECTION          
              MOVE 1L-COMM-TYPE-CODE      TO KO-COMM-TYPE-CD            
              MOVE 1L-COMM-SUBTYPE-CODE   TO KO-COMM-SUBTYPE-CODE       
              MOVE 'SYSTEM'               TO KO-USER-ID-ORIG            
              MOVE SPACES                 TO KO-CONTACT-NAME            
              MOVE SPACES                 TO KO-PROMOTION-ID            
              MOVE 'N'                    TO KO-PSC-COMPLIANCE-IND      
              MOVE 0                      TO KO-CALL-ORIGIN-ID          
              MOVE 0                      TO KO-NUMBER-TRANSFERS        
              MOVE 0                      TO KO-HOLD-TIME               
              MOVE 0                      TO KO-QUEUE-TIME              
              MOVE 'N'                    TO KO-SCREEN-POP-IND          
              MOVE 0                      TO KO-TOTAL-CALL-TIME         
              MOVE 20                     TO KO-INITIAL-COMMENT-TX-LEN  
              MOVE 'LETTER FOR BP REPL'   TO KO-INITIAL-COMMENT-TX-TEXT 
              MOVE SPACES                 TO KO-RESPONSE-REASON-CD      
              MOVE SPACES                 TO KO-RESPONSE-TYPE-CD        
              MOVE SPACES                 TO KO-SOLICITATION-CD         
              MOVE 'A'                    TO KO-COMM-ASSOC-CD           
              MOVE 'N'                    TO KO-COMPLAINT-FL            
              MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD       
              MOVE SPACES                 TO KO-PREV-MARKETER-CD        
              PERFORM 8200-INSERT-COMM-DATA  THRU 8200-EXIT             
            END-IF                                                      
           ELSE                                                         
             MOVE 0                    TO RS-RETURN-CODE                
           END-IF                                                       
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE                 
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
           PERFORM 8900-SEND-DONE             THRU 8900-EXIT.           
       5000-EXIT.                                                       
           EXIT.                                                        
ACT152                                                                  
ACT152                                                                  
           EXEC SQL                                                             
              INCLUDE CPD00350                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
       7000-GET-ACCOUNT.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO,
              CUSTOMER_NO,
              COMPANY_NO                                         
              INTO :AT-PREMISE-NO                                       
                  ,:AT-CUSTOMER-NO                                      
                  ,:AT-COMPANY-NO                                       
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO                                                 
MFA-TR*       INTO :AT-PREMISE-NO                                               
MFA-TR*           ,:AT-CUSTOMER-NO                                              
MFA-TR*           ,:AT-COMPANY-NO                                               
MFA-TR*       FROM CSS_ACCOUNT                                                  
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                  
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_ACCOUNT     '  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7200-GET-DATES.                                                  
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         VALUES CURRENT DATE                                             
MFA-TR*           INTO :WS-DATE                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         VALUES CURRENT TIMESTAMP                                        
MFA-TR*           INTO :WS-TIMESTAMP                                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-CONTACT.                                                
                                                                        
           EXEC SQL                                                     
ACT152        SELECT TOP(1) UV.CODE_LONG_DESC,
              UV.CODE_SHORT_DESC                                 
ACT152          INTO :UV-CODE-LONG-DESC                                 
ACT152              ,:UV-CODE-SHORT-DESC                                
ACT152          FROM CSS_CODE_VALUE  UV WITH(READUNCOMMITTED)                   
ACT152        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                     
ACT152          AND UV.COLUMN_NA   = :UV-COLUMN-NA                      
ACT152          AND UV.TABLE_NA    = :UV-TABLE-NA                       
ACT152          AND UV.COMPANY_NO  = :UV-COMPANY-NO                     
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_LONG_DESC                                          
MFA-TR*             ,UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO :UV-CODE-LONG-DESC                                         
MFA-TR*             ,:UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE  UV                                         
MFA-TR*       WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                             
MFA-TR*         AND UV.COLUMN_NA   = :UV-COLUMN-NA                              
MFA-TR*         AND UV.TABLE_NA    = :UV-TABLE-NA                               
MFA-TR*         AND UV.COMPANY_NO  = :UV-COMPANY-NO                             
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7300'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
ACT152             MOVE 'CSS_CODE_VALUE'    TO TABLE-1                  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE                                       
              INTO :PR-LOCAL-OFFICE                                     
              FROM CSS_PREMISE WITH(READUNCOMMITTED)                            
             WHERE PREMISE_NO = :PR-PREMISE-NO                          
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*       INTO :PR-LOCAL-OFFICE                                             
MFA-TR*       FROM CSS_PREMISE                                                  
MFA-TR*      WHERE PREMISE_NO = :PR-PREMISE-NO                                  
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7400'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-COMM-TYPE-SUBTYPE.                                      
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [1L].COMM_TYPE_CODE,
              [1L].COMM_SUBTYPE_CODE,
              [1L].CORRESP_TYPE_CD,
              [1L].COMM_INSERT_FL                                   
             INTO  :1L-COMM-TYPE-CODE                                   
                  ,:1L-COMM-SUBTYPE-CODE                                
                  ,:1L-CORRESP-TYPE-CD                                  
                  ,:1L-COMM-INSERT-FL                                   
             FROM   CSS_CORRESP_COMM [1L] WITH(READUNCOMMITTED)                 
             WHERE  [1L].CORRESP_MSG_ID     = :1L-CORRESP-MSG-ID          
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1L.COMM_TYPE_CODE                                           
MFA-TR*            ,1L.COMM_SUBTYPE_CODE                                        
MFA-TR*            ,1L.CORRESP_TYPE_CD                                          
MFA-TR*            ,1L.COMM_INSERT_FL                                           
MFA-TR*      INTO  :1L-COMM-TYPE-CODE                                           
MFA-TR*           ,:1L-COMM-SUBTYPE-CODE                                        
MFA-TR*           ,:1L-CORRESP-TYPE-CD                                          
MFA-TR*           ,:1L-COMM-INSERT-FL                                           
MFA-TR*      FROM   CSS_CORRESP_COMM 1L                                         
MFA-TR*      WHERE  1L.CORRESP_MSG_ID     = :1L-CORRESP-MSG-ID                  
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7500'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_CORRESP_COMM'  TO TABLE-1                  
                   MOVE 'CORRESP-MSG-ID'    TO TABLE-ELEMENT-1          
                   MOVE 1L-CORRESP-MSG-ID   TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8001-INSERT-CORRESP-HDR.                                         
                                                                        
           MOVE '8001' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CORRESP_HDR                              
                  (CORRESP_ID,                                          
                   CUSTOMER_NO,                                         
                   ACCOUNT_NO,                                          
                   CORRESP_MSG_ID,                                      
                   CORRESP_STMT_DT,                                     
                   GUARNTR_ACCT_NO,                                     
                   THD_PRTY_ID,                                         
                   CORRESP_SEQ_NO,                                      
                   CORRESP_COMPANY_NO,                                  
                   CORRESP_CREATE_TS,                                   
                   CORRESP_STATUS_CD,                                   
                   CORRESP_TYPE_CD,                                     
                   REG_GROUP_CD,                                        
                   SENIOR_FL,                                           
                   BARCODE_UNIQUE_ID,                                   
                   CREATED_BY_PGM_ID,                                   
                   LAST_UPDATE_PGM_ID,                                  
                   LAST_UPDATE_TS                                       
                   )                                                    
                 VALUES                                                 
                  (:1J-CORRESP-ID,                                      
                   :1J-CUSTOMER-NO,                                     
                   :1J-ACCOUNT-NO,                                      
                   :1J-CORRESP-MSG-ID,                                  
                   IIF(TRY_CONVERT(DATE, :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) ),                         
                   :1J-GUARNTR-ACCT-NO,                                 
                   :1J-THD-PRTY-ID,                                     
                   :1J-CORRESP-SEQ-NO,                                  
                   :1J-CORRESP-COMPANY-NO,                              
                   CIS.CHAR2TIMESTAMP(:1J-CORRESP-CREATE-TS),                   
                   :1J-CORRESP-STATUS-CD,                               
                   :1J-CORRESP-TYPE-CD,                                 
                   :1J-REG-GROUP-CD,                                    
                   :1J-SENIOR-FL,                                       
                   :1J-BARCODE-UNIQUE-ID,                               
                   :1J-CREATED-BY-PGM-ID,                               
                   :1J-LAST-UPDATE-PGM-ID,                              
                   CIS.CHAR2TIMESTAMP(:1J-LAST-UPDATE-TS)                       
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CORRESP_HDR                                      
MFA-TR*           (CORRESP_ID,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CORRESP_MSG_ID,                                              
MFA-TR*            CORRESP_STMT_DT,                                             
MFA-TR*            GUARNTR_ACCT_NO,                                             
MFA-TR*            THD_PRTY_ID,                                                 
MFA-TR*            CORRESP_SEQ_NO,                                              
MFA-TR*            CORRESP_COMPANY_NO,                                          
MFA-TR*            CORRESP_CREATE_TS,                                           
MFA-TR*            CORRESP_STATUS_CD,                                           
MFA-TR*            CORRESP_TYPE_CD,                                             
MFA-TR*            REG_GROUP_CD,                                                
MFA-TR*            SENIOR_FL,                                                   
MFA-TR*            BARCODE_UNIQUE_ID,                                           
MFA-TR*            CREATED_BY_PGM_ID,                                           
MFA-TR*            LAST_UPDATE_PGM_ID,                                          
MFA-TR*            LAST_UPDATE_TS                                               
MFA-TR*            )                                                            
MFA-TR*          VALUES                                                         
MFA-TR*           (:1J-CORRESP-ID,                                              
MFA-TR*            :1J-CUSTOMER-NO,                                             
MFA-TR*            :1J-ACCOUNT-NO,                                              
MFA-TR*            :1J-CORRESP-MSG-ID,                                          
MFA-TR*            :1J-CORRESP-STMT-DT,                                         
MFA-TR*            :1J-GUARNTR-ACCT-NO,                                         
MFA-TR*            :1J-THD-PRTY-ID,                                             
MFA-TR*            :1J-CORRESP-SEQ-NO,                                          
MFA-TR*            :1J-CORRESP-COMPANY-NO,                                      
MFA-TR*            :1J-CORRESP-CREATE-TS,                                       
MFA-TR*            :1J-CORRESP-STATUS-CD,                                       
MFA-TR*            :1J-CORRESP-TYPE-CD,                                         
MFA-TR*            :1J-REG-GROUP-CD,                                            
MFA-TR*            :1J-SENIOR-FL,                                               
MFA-TR*            :1J-BARCODE-UNIQUE-ID,                                       
MFA-TR*            :1J-CREATED-BY-PGM-ID,                                       
MFA-TR*            :1J-LAST-UPDATE-PGM-ID,                                      
MFA-TR*            :1J-LAST-UPDATE-TS                                           
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN -803                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE SPACES              TO ABEND-TABLES             
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                   MOVE 'CSR04611'          TO ABEND-PROGRAM            
                   MOVE 'UPDATE'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CORRESP_HDR'   TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE 1J-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CORRESP_ID'        TO TABLE-ELEMENT-2          
                   MOVE 1J-CORRESP-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CORRESP-VAR.                                         
                                                                        
           MOVE '8050' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CORRESP_VAR                              
                  (CORRESP_ID,                                          
                   CORRESP_VAR_NM,                                      
                   CORRESP_VAR_DATA,                                    
                   CORRESP_VAR_NUM,                                     
                   CORRESP_VAR_CHAR                                     
                   )                                                    
                 VALUES                                                 
                  (:1K-CORRESP-ID,                                      
                   :1K-CORRESP-VAR-NM,                                  
                   :1K-CORRESP-VAR-DATA,                                
                   :1K-CORRESP-VAR-NUM,                                 
                   :1K-CORRESP-VAR-CHAR                                 
                  )                                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE SPACES              TO ABEND-TABLES             
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                   MOVE 'CSR04611'          TO ABEND-PROGRAM            
                   MOVE 'INSERT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CORRESP_VAR'   TO TABLE-1                  
                   MOVE 'CORRESP_ID'        TO TABLE-ELEMENT-1          
                   MOVE 1J-CORRESP-ID       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
             ADD 1 TO CTR-ROWS.                                         
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-INSERT-COMM-DATA.                                           
                                                                        
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COMM_DATA                                
                  (                                                     
                  COMMUNICATION_ID                                      
                 ,ACCOUNT_NO                                            
                 ,CUSTOMER_NO                                           
                 ,PREMISE_NO                                            
                 ,COMPANY_NO                                            
                 ,RED_FLAG_IND                                          
**************   ,RED_FLAG_EXPIRE_DT                                            
                 ,COMM_METHOD                                           
                 ,COMM_DIRECTION                                        
                 ,COMM_TYPE_CD                                          
                 ,COMM_SUBTYPE_CODE                                     
                 ,USER_ID_ORIG                                          
                 ,CONTACT_NAME                                          
                 ,PROMOTION_ID                                          
                 ,PSC_COMPLIANCE_IND                                    
                 ,CALL_ORIGIN_ID                                        
***************  ,CALL_END_TIME                                                 
                 ,NUMBER_TRANSFERS                                      
                 ,HOLD_TIME                                             
                 ,QUEUE_TIME                                            
                 ,SCREEN_POP_IND                                        
                 ,TOTAL_CALL_TIME                                       
                 ,INITIAL_COMMENT_TX                                    
                 ,RESPONSE_REASON_CD                                    
                 ,RESPONSE_TYPE_CD                                      
                 ,SOLICITATION_CD                                       
                 ,COMM_ASSOC_CD                                         
                 ,COMPLAINT_FL                                          
                 ,DISCOVERY_MTHD_CD                                     
                 ,PREV_MARKETER_CD                                      
                   )                                                    
                 VALUES                                                 
                  (                                                     
                  CIS.CURRENT$TIMESTAMP()                                     
                 ,:KO-ACCOUNT-NO                                        
                 ,:KO-CUSTOMER-NO                                       
                 ,:KO-PREMISE-NO                                        
                 ,:KO-COMPANY-NO                                        
                 ,:KO-RED-FLAG-IND                                      
**************   ,:KO-RED-FLAG-EXPIRE-DT                                        
***************  ,NULL                                                          
                 ,:KO-COMM-METHOD                                       
                 ,:KO-COMM-DIRECTION                                    
                 ,:KO-COMM-TYPE-CD                                      
                 ,:KO-COMM-SUBTYPE-CODE                                 
                 ,:KO-USER-ID-ORIG                                      
                 ,:KO-CONTACT-NAME                                      
                 ,:KO-PROMOTION-ID                                      
                 ,:KO-PSC-COMPLIANCE-IND                                
                 ,:KO-CALL-ORIGIN-ID                                    
************     ,:KO-CALL-END-TIME                                             
**************   ,NULL                                                          
                 ,:KO-NUMBER-TRANSFERS                                  
                 ,:KO-HOLD-TIME                                         
                 ,:KO-QUEUE-TIME                                        
                 ,:KO-SCREEN-POP-IND                                    
                 ,:KO-TOTAL-CALL-TIME                                   
                 ,:KO-INITIAL-COMMENT-TX                                
                 ,:KO-RESPONSE-REASON-CD                                
                 ,:KO-RESPONSE-TYPE-CD                                  
                 ,:KO-SOLICITATION-CD                                   
                 ,:KO-COMM-ASSOC-CD                                     
                 ,:KO-COMPLAINT-FL                                      
                 ,:KO-DISCOVERY-MTHD-CD                                 
                 ,:KO-PREV-MARKETER-CD                                  
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COMM_DATA                                        
MFA-TR*           (                                                             
MFA-TR*           COMMUNICATION_ID                                              
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,CUSTOMER_NO                                                   
MFA-TR*          ,PREMISE_NO                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,RED_FLAG_IND                                                  
MFA-TR********   ,RED_FLAG_EXPIRE_DT                                            
MFA-TR*          ,COMM_METHOD                                                   
MFA-TR*          ,COMM_DIRECTION                                                
MFA-TR*          ,COMM_TYPE_CD                                                  
MFA-TR*          ,COMM_SUBTYPE_CODE                                             
MFA-TR*          ,USER_ID_ORIG                                                  
MFA-TR*          ,CONTACT_NAME                                                  
MFA-TR*          ,PROMOTION_ID                                                  
MFA-TR*          ,PSC_COMPLIANCE_IND                                            
MFA-TR*          ,CALL_ORIGIN_ID                                                
MFA-TR*********  ,CALL_END_TIME                                                 
MFA-TR*          ,NUMBER_TRANSFERS                                              
MFA-TR*          ,HOLD_TIME                                                     
MFA-TR*          ,QUEUE_TIME                                                    
MFA-TR*          ,SCREEN_POP_IND                                                
MFA-TR*          ,TOTAL_CALL_TIME                                               
MFA-TR*          ,INITIAL_COMMENT_TX                                            
MFA-TR*          ,RESPONSE_REASON_CD                                            
MFA-TR*          ,RESPONSE_TYPE_CD                                              
MFA-TR*          ,SOLICITATION_CD                                               
MFA-TR*          ,COMM_ASSOC_CD                                                 
MFA-TR*          ,COMPLAINT_FL                                                  
MFA-TR*          ,DISCOVERY_MTHD_CD                                             
MFA-TR*          ,PREV_MARKETER_CD                                              
MFA-TR*            )                                                            
MFA-TR*          VALUES                                                         
MFA-TR*           (                                                             
MFA-TR*           CURRENT TIMESTAMP                                             
MFA-TR*          ,:KO-ACCOUNT-NO                                                
MFA-TR*          ,:KO-CUSTOMER-NO                                               
MFA-TR*          ,:KO-PREMISE-NO                                                
MFA-TR*          ,:KO-COMPANY-NO                                                
MFA-TR*          ,:KO-RED-FLAG-IND                                              
MFA-TR********   ,:KO-RED-FLAG-EXPIRE-DT                                        
MFA-TR*********  ,NULL                                                          
MFA-TR*          ,:KO-COMM-METHOD                                               
MFA-TR*          ,:KO-COMM-DIRECTION                                            
MFA-TR*          ,:KO-COMM-TYPE-CD                                              
MFA-TR*          ,:KO-COMM-SUBTYPE-CODE                                         
MFA-TR*          ,:KO-USER-ID-ORIG                                              
MFA-TR*          ,:KO-CONTACT-NAME                                              
MFA-TR*          ,:KO-PROMOTION-ID                                              
MFA-TR*          ,:KO-PSC-COMPLIANCE-IND                                        
MFA-TR*          ,:KO-CALL-ORIGIN-ID                                            
MFA-TR******     ,:KO-CALL-END-TIME                                             
MFA-TR********   ,NULL                                                          
MFA-TR*          ,:KO-NUMBER-TRANSFERS                                          
MFA-TR*          ,:KO-HOLD-TIME                                                 
MFA-TR*          ,:KO-QUEUE-TIME                                                
MFA-TR*          ,:KO-SCREEN-POP-IND                                            
MFA-TR*          ,:KO-TOTAL-CALL-TIME                                           
MFA-TR*          ,:KO-INITIAL-COMMENT-TX                                        
MFA-TR*          ,:KO-RESPONSE-REASON-CD                                        
MFA-TR*          ,:KO-RESPONSE-TYPE-CD                                          
MFA-TR*          ,:KO-SOLICITATION-CD                                           
MFA-TR*          ,:KO-COMM-ASSOC-CD                                             
MFA-TR*          ,:KO-COMPLAINT-FL                                              
MFA-TR*          ,:KO-DISCOVERY-MTHD-CD                                         
MFA-TR*          ,:KO-PREV-MARKETER-CD                                          
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE SPACES              TO ABEND-TABLES             
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                   MOVE 'CSR04611'          TO ABEND-PROGRAM            
                   MOVE 'INSERT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_COMM_DATA  '   TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE KO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPD00321                                               
              END-EXEC.                                                         
              EXEC SQL                                                          
                 INCLUDE CPD0023C                                               
              END-EXEC.                                                         
