       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04610.                                     
COB303 DATE-WRITTEN.      FEB 14, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00170014
      *                 P R O G R A M  S U M M A R Y                   *00180014
      ******************************************************************00180015
      *                                                                *00190014
      *  This program retrieves all securities for an Account.         *00200014
      *                                                                *00200015
      *  1. Cash Deposits                                              *00210014
      *  2. Guarantors                                                 *00220014
      *  3. Waivers                                                    *00230014
      *  4. Surety Bonds &                                             *00230015
      *     Irrevocable Letters Of Credit (ILOC)                       *00230016
      *  5. Max Deposit Review Details                                 *00230016
      *                                                                *00250014
      ******************************************************************00260014
      *                                                                *00270014
      *                     PROGRAM MODIFICATION LOG                   *00280014
      *                                                                *00280015
      ******************************************************************00280016
      *                                                                *00290014
      *    DATE    INITIALS   COMMENTS                                 *00300014
      *  --------  --------   ---------------------------------------  *00310014
P00705*  02/14/13  VP43661    PROCEDURE ORIGINALLY CODED.              *00311014
A05091*  01/21/16  RB19957    ADDED TBATMISC WHICH IS NOW NEEDED       *00311014
A05091*                       IN CPD00308 FOR SEB SEASONAL FLAG        *00311014
      *                                                                *00312014
      ******************************************************************00630014
      *                                                                *00640014
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00650014
      *                                                                *00660014
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00670014
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00680014
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00690014
      *  3000 - 4999  NOT USED                                         *00700014
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00710014
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00720014
      *  7000 - 7999  INPUT MODULES                                    *00730014
      *  8000 - 8999  OUTPUT MODULES                                   *00740014
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00750014
      *                                                                *00760014
      ******************************************************************00770014
      *                                                                 00780014
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04610'.
MSQ017     COPY MFASQLM.
      *                                                                 00820014
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04610 STARTS HERE'.                  
      *                                                                 01520014
      ******************************************************************00860014
      * Work Areas                                                     *01540014
      ******************************************************************00880014
      *                                                                 00890014
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-MIN-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-MAX-DEPOSIT-AMT-1     PIC S9(09)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-USAGE-HISTORY-FLAG    PIC X(01)      VALUE SPACES.    
             10 S-DEP-EXISTS-FLAG       PIC X(01)      VALUE SPACES.    
             10 S-DELQ-DEP-NTFY-LTR     PIC S99999V    USAGE COMP-3     
                                                       VALUE 0.         
             10 S-DEP-ACTION-CODE       PIC X(01)      VALUE SPACES.    
             10 S-DEPOSIT-STATUS-CD     PIC X(01)      VALUE SPACES.    
             10 S-DATE-TRAN             PIC X(10)      VALUE SPACES.    
             10 S-SERVICE-TYPE-CD       PIC X(01)      VALUE SPACES.    
             10 S-DEPOSIT-CERT-NO       PIC S9(09)     USAGE COMP.      
             10 S-AMT-ORIG-ENTERED-1    PIC S9(09)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-BILL-OPTION-CD        PIC X(01)      VALUE SPACES.    
             10 S-BILLED-FLAG           PIC X(10)      VALUE SPACES.    
             10 S-AMT-PAID              PIC S9(09)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-COMMENT               PIC X(72)      VALUE SPACES.    
             10 S-CODE-DEP-TYPE         PIC X(01)      VALUE SPACES.    
             10 S-NO-SCHED-PYMTS        PIC S9(04)     USAGE COMP.      
             10 S-AMT-MO-PYMT           PIC S9(07)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-BILL-COUNT            PIC S9(04)     COMP  VALUE 0.   
             10 S-USER-ID-UPDT-BY       PIC X(07)      VALUE SPACES.    
             10 S-DATE-PYMT-START       PIC X(10)      VALUE SPACES.    
             10 S-OLD-BILL-DATE         PIC X(10)      VALUE SPACES.    
             10 S-2ND-OLD-BILL-DATE     PIC X(10)      VALUE SPACES.    
             10 S-NEXT-BILLING-DATE     PIC X(10)      VALUE SPACES.    
             10 S-2ND-NEXT-BILL-DATE    PIC X(10)      VALUE SPACES.    
             10 S-LAST-BILL-DATE        PIC X(10)      VALUE SPACES.    
             10 S-MST-SUB-ACCT-IND      PIC X(01)      VALUE SPACES.    
             10 S-DELINQUENCY-VALUE     PIC S99999V    USAGE COMP-3     
                                                       VALUE 0.         
             10 S-DEP-DNP-LIMIT         PIC S99999V    USAGE COMP-3     
                                                       VALUE 0.         
             10 S-REBILLED-DEP-AMT      PIC S9(07)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-REBILLED-DEP-DATE     PIC X(10)      VALUE SPACES.    
             10 S-IMME-DUE-DATE         PIC X(10)      VALUE SPACES.    
             10 S-IMME-CUT-DATE         PIC X(10)      VALUE SPACES.    
             10 S-CODE-DISC-OK          PIC X(01)      VALUE SPACES.    
             10 S-CREDIT-GROUP          PIC X(01)      VALUE SPACES.    
             10 S-NOT-CURR-MTH-FLAG     PIC X(01)      VALUE SPACES.    
             10 S-RETURN-CODE-1         PIC S9(9)      COMP  VALUE 0.   
             10 S-AT-LAST-UPDATE-TS     PIC X(26)      VALUE SPACES.    
             10 S-DATE-FIRST-NOTICE     PIC X(10)      VALUE SPACES.    
             10 S-INSTLMNT-STRT-DATE    PIC X(10)      VALUE SPACES.    
             10 S-NEXT-BILL-DATE        PIC X(10)      VALUE SPACES.    
             10 S-NEXT-DUE-DATE         PIC X(10)      VALUE SPACES.    
             10 S-IMMED-DUE-DATE        PIC X(10)      VALUE SPACES.    
             10 S-DATE-FIRST-DUE        PIC X(10)      VALUE SPACES.    
             10 S-DATE-SECOND-DUE       PIC X(10)      VALUE SPACES.    
             10 S-CURRENT-BILL-DUE      PIC X(10)      VALUE SPACES.    
             10 S-ORIG-IMMED-DUE        PIC X(10)      VALUE SPACES.    
             10 S-CUR-IMMED-DUE         PIC X(10)      VALUE SPACES.    
             10 S-DT-FST-NTCE-OLD       PIC X(10)      VALUE SPACES.    
             10 S-CUT-DATE              PIC X(10)      VALUE SPACES.    
             10 S-FINAL-INSTLMNT-AMT    PIC S9(9)      COMP  VALUE 0.   
             10 S-CODE-REFUND-ELIG      PIC X(01)      VALUE SPACES.    
             10 S-AGENCY-TEXT           PIC X(72)      VALUE SPACES.    
             10 S-AUTODEP-LTR-DT        PIC X(10)      VALUE SPACES.    
             10 S-AUTODEP-LTR-IND       PIC X(01)      VALUE SPACES.    
             10 S-DATE-CERT-ISSUE       PIC X(10)      VALUE SPACES.    
             10 S-PROJECTED-CR-DT       PIC X(10)      VALUE SPACES.    
      *                                                                 00930014
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2         PIC S9(9)      COMP  VALUE 0.   
             10 S-GRNT-ACCT-TYPE        PIC X(01)      VALUE SPACE.     
             10 S-AMT-GUARANTEE         PIC S9(9)V9(2) USAGE COMP-3     
                                                       VALUE 0.         
             10 S-CODE-GUAR-STATUS      PIC X(01)      VALUE SPACE.     
             10 S-TRIGGER-DATE          PIC X(08)      VALUE SPACE.     
             10 S-STATUS-REASON         PIC X(20)      VALUE SPACE.     
             10 S-CODE-SERV-TYPE        PIC X(01)      VALUE SPACE.     
             10 S-CNT-ITEM-ID           PIC S9(9)      COMP  VALUE 0.   
             10 S-AMT-ORIG-ENTERED-2    PIC S9(11)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-CNT-NAME-ABBR         PIC X(10)      VALUE SPACE.     
             10 S-SEND-NOTICE-FLAG      PIC X(01)      VALUE SPACE.     
             10 S-SN-ADDR-FLAG          PIC X(01)      VALUE SPACE.     
             10 S-GUAR-ACCT-NO          PIC X(13)      VALUE SPACE.     
             10 S-CREDIT-STATUS-CD      PIC X(01)      VALUE SPACE.     
             10 S-ADDRESS-ID            PIC X(13)      VALUE SPACE.     
             10 S-GUAR-ACCT-TYPE        PIC X(01)      VALUE SPACE.     
             10 S-UPDATE-TS             PIC X(26)      VALUE SPACE.     
             10 S-NAME-USAGE            PIC X(01)      VALUE SPACE.     
             10 S-FULL-NAME             PIC X(70)      VALUE SPACE.     
             10 S-TITLE                 PIC X(09)      VALUE SPACE.     
             10 S-FIRST-NAME            PIC X(15)      VALUE SPACE.     
             10 S-MIDDLE-NAME           PIC X(15)      VALUE SPACE.     
             10 S-LAST-NAME             PIC X(40)      VALUE SPACE.     
             10 S-TITLE-SUFFIX1         PIC X(03)      VALUE SPACE.     
             10 S-TITLE-SUFFIX2         PIC X(03)      VALUE SPACE.     
             10 S-ADDR-USAGE            PIC X(01)      VALUE SPACE.     
             10 S-ADDR-STREET           PIC X(55)      VALUE SPACE.     
             10 S-HOUSE-NO              PIC X(15)      VALUE SPACE.     
             10 S-ADDR-PREFIX1          PIC X(03)      VALUE SPACE.     
             10 S-ADDR-CITY-STATE       PIC X(30)      VALUE SPACE.     
             10 S-ADDR-PREFIX2          PIC X(02)      VALUE SPACE.     
             10 S-STREET-NAME           PIC X(30)      VALUE SPACE.     
             10 S-STREET-SUFFIX         PIC X(04)      VALUE SPACE.     
             10 S-ADDR-SUFFIX           PIC X(02)      VALUE SPACE.     
             10 S-ADDR-ZIP-CODE         PIC X(09)      VALUE SPACE.     
             10 S-STREET-LOCATION1      PIC X(04)      VALUE SPACE.     
             10 S-STREET-LOCATION2      PIC X(11)      VALUE SPACE.     
             10 S-ADDR-COUNTRY          PIC X(35)      VALUE SPACE.     
             10 S-TOWN                  PIC X(26)      VALUE SPACE.     
             10 S-STATE                 PIC X(02)      VALUE SPACE.     
             10 S-ZIP-CODE              PIC X(05)      VALUE SPACE.     
             10 S-ZIP-CODE-PLUS         PIC X(04)      VALUE SPACE.     
             10 S-ADDR-OVERFLOW         PIC X(35)      VALUE SPACE.     
             10 S-ADDR-OVERFLOW-FORM    PIC X(35)      VALUE SPACE.     
             10 S-CARRIER-ROUTE         PIC X(05)      VALUE SPACE.     
             10 S-HOME-PHONE            PIC X(10)      VALUE SPACE.     
             10 S-WORK-PHONE            PIC X(10)      VALUE SPACE.     
             10 S-PHONE-EXT             PIC X(06)      VALUE SPACE.     
             10 S-DRIVER-LICENSE        PIC X(19)      VALUE SPACE.     
             10 S-CODE-STATE-ID         PIC X(02)      VALUE SPACE.     
             10 S-SSN                   PIC X(09)      VALUE SPACE.     
             10 S-SN-STREET             PIC X(55)      VALUE SPACE.     
             10 S-SN-CITY-STATE         PIC X(30)      VALUE SPACE.     
             10 S-SN-ZIP-CODE           PIC X(09)      VALUE SPACE.     
             10 S-SN-COUNTRY            PIC X(35)      VALUE SPACE.     
             10 S-SN-OVERFLOW           PIC X(35)      VALUE SPACE.     
             10 S-WQ-ITEM-ID            PIC S9(10)V    COMP-3           
                                                       VALUE ZERO.      
             10 S-GUAR-ESTBLSH-DT       PIC X(08)      VALUE SPACE.     
             10 S-MAX-DEPOSIT-AMT-2     PIC S9(09)V99  USAGE COMP-3     
                                                       VALUE 0.         
             10 S-CUSTOMER-NO           PIC X(10)      VALUE SPACES.    
      *                                                                 00970014
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3         PIC S9(9) COMP  VALUE 0.        
             10 S-WAIVER-TYPE-CD-3      PIC X(02) VALUE SPACES.         
             10 S-CODE-STATUS-3         PIC X(01) VALUE SPACES.         
             10 S-COMMENTS-3            PIC X(72) VALUE SPACES.         
             10 S-CODE-STATUS-REAS-3    PIC X(20) VALUE SPACES.         
             10 S-WAIVER-SOURCE-DESC-3  PIC X(35) VALUE SPACES.         
             10 S-TRIGGER-DATE-3        PIC X(08) VALUE SPACES.         
             10 S-BOND-ITEM-ID-3        PIC S9(9) COMP  VALUE 0.        
             10 S-SSN-NUMBER-3          PIC X(09) VALUE SPACES.         
      *                                                                 01010014
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4         PIC S9(9) COMP VALUE 0.         
             10 S-ACCOUNT-NO-4          PIC X(13) VALUE SPACE.          
             10 S-CODE-BOND-TYPE-4      PIC X(01) VALUE SPACE.          
             10 S-AMT-BOND-4            PIC S9(9)V9(2) USAGE COMP-3     
                                                  VALUE 0.              
             10 S-WAIV-ITEM-ID-4        PIC X(09) VALUE SPACE.          
             10 S-BOND-CO-NO-4          PIC S9(6)V USAGE COMP-3         
                                                  VALUE 0.              
             10 S-CODE-STATUS-4         PIC X(01) VALUE SPACE.          
             10 S-TRIGGER-DATE-4        PIC X(08) VALUE SPACE.          
             10 S-CODE-STATUS-REAS-4    PIC X(20) VALUE SPACE.          
             10 S-ORIGINATED-BY-4       PIC X(20) VALUE SPACE.          
             10 S-BOND-NO-4             PIC X(16) VALUE SPACE.          
             10 S-BOND-TOTAL-AMT-4      PIC S9(9)V9(2) USAGE COMP-3     
                                                  VALUE 0.              
             10 S-ISSUE-DATE-4          PIC X(08) VALUE SPACE.          
             10 S-EXPIRATION-DATE-4     PIC X(08) VALUE SPACE.          
             10 S-NAME-4                PIC X(50) VALUE SPACE.          
             10 S-ADDRESS-4             PIC X(50) VALUE SPACE.          
             10 S-CODE-ACCT-STAT-4      PIC X(01) VALUE SPACE.          
             10 S-MIN-DEP-AMT-4         PIC S9(09)V99  USAGE COMP-3     
                                                  VALUE 0.              
             10 S-MAX-DEP-AMT-4         PIC S9(09)V99  USAGE COMP-3     
                                                  VALUE 0.              
      *                                                                 01010014
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5         PIC S9(9) COMP VALUE 0.         
             10 S-MAX-DEP-REF-XMT-CD    PIC X(01) VALUE SPACES.         
             10 S-LAST-MAX-AT-REV-DT    PIC X(10) VALUE SPACES.         
             10 S-MAX-DEP-AT-REV-AM     PIC S9(9)V9(2) USAGE COMP-3     
                                                  VALUE 0.              
             10 S-PD-DEP-AT-REV-AM      PIC S9(9)V9(2) USAGE COMP-3     
                                                  VALUE 0.              
             10 S-MAX-DEP-REFUND-CD     PIC X(01) VALUE SPACES.         
      *                                                                 01050014
       01 WS-DUMMY.                                                     
          05 RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.           
          05 RS-MIN-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP-3       
                                                  VALUE 0.              
          05 WS-DATABASE                PIC 9(01) VALUE ZERO.           
             88 CSR-DATABASE                      VALUE 1.              
             88 SEB-DATABASE                      VALUE 2.              
          05 WS-N                       PIC X(01) VALUE 'N'.            
          05 WS-Y                       PIC X(01) VALUE 'Y'.            
      *                                                                 01050014
       01 WS-MISC.                                                      
          05 WS-GTT-R1-DECLARED         PIC X(01) VALUE 'N'.            
          05 WS-GTT-R2-DECLARED         PIC X(01) VALUE 'N'.            
          05 WS-GTT-R3-DECLARED         PIC X(01) VALUE 'N'.            
          05 WS-GTT-R4-DECLARED         PIC X(01) VALUE 'N'.            
          05 WS-GTT-R5-DECLARED         PIC X(01) VALUE 'N'.            
          05 WS-ACCOUNT-NO-IN           PIC X(13) VALUE SPACES.         
COB305    05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
          05 WS-BOND-TYPE               PIC X(01) VALUE SPACES.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04610'.     
          05 WS-GF-DEPOSIT              PIC X(01) VALUE SPACE.          
          05 WS-PROJ-RFND-DATE          PIC X(10) VALUE SPACES.         
          05 WS-LAST-BILL-DATE          PIC X(10) VALUE SPACES.         
          05 WS-DEP-PAID-DATE           PIC X(10) VALUE SPACES.         
          05 WS-CURRENT-DATE            PIC X(10) VALUE SPACES.         
          05 WS-CALC-DT-FROM-PMT        PIC X(10) VALUE SPACES.         
          05 WS-RES-SECUR-START-DATE.                                   
             10 WS-RES-SECUR-DATE.                                      
                15 WS-RES-DATE-CCYY     PIC X(04) VALUE SPACES.         
                15 WS-FILLER1-RES       PIC X(01) VALUE '-'.            
                15 WS-RES-DATE-MM       PIC X(02) VALUE SPACES.         
                15 WS-FILLER2-RES       PIC X(01) VALUE '-'.            
                15 WS-RES-DATE-DD       PIC X(02) VALUE SPACES.         
          05 WS-DEP-DATE-TRAN.                                          
             10 WS-DEP-DATE-TRAN-CCYY   PIC X(04) VALUE SPACES.         
             10 WS-FILLER1              PIC X(01) VALUE '-'.            
             10 WS-DEP-DATE-TRAN-MM     PIC X(02) VALUE SPACES.         
             10 WS-FILLER2              PIC X(01) VALUE '-'.            
             10 WS-DEP-DATE-TRAN-DD     PIC X(02) VALUE SPACES.         
          05 S-RETURN-CODE              PIC S9(9) COMP  VALUE +0.       
          05 WS-MONTHS-TEMP             PIC S9(4) COMP VALUE +0.        
          05 WS-LIMIT-MONTH             PIC S9(4) COMP VALUE +0.        
          05 WS-MONTHS-SQL              PIC S9(4) COMP VALUE +0.        
          05 WS-CALC                    PIC S9(4) COMP VALUE +0.        
          05 WS-NULL-VALUE              PIC S9(4) COMP VALUE -1.        
          05 WS-NULL-DATE               PIC S9(4) COMP VALUE 0.         
          05 WS-NULL-REVIEW-DT          PIC S9(4) COMP VALUE 0.         
          05 WS-COUNTER                 PIC S9(4) COMP VALUE 0.         
          05 WS-UTIL-ARRS-HOLD          PIC S9(4) COMP VALUE +0.        
          05 WS-NON-CONS-ARRS-HOLD      PIC S9(4) COMP VALUE +0.        
          05 WS-DISC-HIST-HOLD          PIC S9(4) COMP VALUE +0.        
          05 WS-DISC-EXC-HIST-HOLD      PIC S9(4) COMP VALUE +0.        
      *                                                                 01090014
       01 WS-REDEFINES.                                                 
          05 WS-REV-MTH-HOLD            PIC 9(06).                      
          05 WS-REV-MTH-CHAR REDEFINES WS-REV-MTH-HOLD   PIC X(06).     
          05 WS-DELINQ-VALUE9           PIC 9999V9999.                  
          05 WS-DELINQ-VALUEX REDEFINES WS-DELINQ-VALUE9 PIC X(09).     
      *                                                                 01090014
       01 SWITCHES.                                                     
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05 SW-FETCH                   PIC X(01) VALUE 'Y'.            
             88 NO-MORE-ROWS                      VALUE 'N'.            
             88 MORE-ROWS                         VALUE 'Y'.            
          05 WS-COMPANY                 PIC 9(01) VALUE 0.              
             88 COMPANY-CSR                       VALUE 1.              
             88 COMPANY-SEB                       VALUE 2.              
          05 WS-UTIL-ARRS-SW            PIC X(01) VALUE 'N'.            
             88 UTIL-ARRS-FOUND                   VALUE 'Y'.            
             88 UTIL-ARRS-NOT-FOUND               VALUE 'N'.            
          05 WS-DISC-HIST-SW            PIC X(01) VALUE 'N'.            
             88 DISC-HIST-FOUND                   VALUE 'Y'.            
             88 DISC-HIST-NOT-FOUND               VALUE 'N'.            
          05 WS-PREV-ARRS-SW            PIC X(01) VALUE 'N'.            
             88 PREV-ARRS-FOUND                   VALUE 'Y'.            
          05 WS-2ND-PREV-ARRS-SW        PIC X(01) VALUE 'N'.            
             88 2ND-PREV-ARRS-FOUND               VALUE 'Y'.            
          05 WS-NON-CONS-ARRS-SW        PIC X(01) VALUE 'N'.            
             88 NON-CONS-ARRS-FOUND               VALUE 'Y'.            
             88 NON-CONS-ARRS-NOT-FOUND           VALUE 'N'.            
      *                                                                 01130014
      ******************************************************************02130100
      * Declare Result set Locators for all sub-programs               *02979209
      ******************************************************************02979210
      *                                                                 01170014
      *01 LOC2092 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2304 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2164 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2150 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *                                                                 01210014
      ******************************************************************03050809
      * DB2 Includes                                                   *03050810
      ******************************************************************03050811
      *                                                                 01415014
      * SQLCA                                                           03050814
      *                                                                 01419114
           EXEC SQL                                                     01419214
                INCLUDE SQLCA                                           03050817
           END-EXEC.                                                    01419414
      *                                                                 01419514
      * ABEND-FILE                                                      03050820
      *                                                                 01419914
           EXEC SQL                                                     01420014
                INCLUDE CWSX0010                                        03050827
           END-EXEC.                                                    01420214
      *                                                                 01419514
      * MIN/MAX DEPOSIT CALC                                            03050820
      *                                                                 01419914
           EXEC SQL                                                     01420014
                INCLUDE CWS00308                                        03050827
           END-EXEC.                                                    01420214
      *                                                                 01520014
      * CSS_ACCOUNT - AT                                                01520014
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                 01520014
      * CSS_BILL_WINDOW - BN                                            01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBBILWDW                                                
           END-EXEC.                                                            
      *                                                                 01520014
      * CSS_LOCAL_OFFICE - B1                                           01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLOCOFC                                                
           END-EXEC.                                                            
      *                                                                 01520014
      * CSS_CUST_PREM_HIST - CH                                         01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSTPRM                                                
           END-EXEC.                                                            
      *                                                                 01520014
      * CSS_CREDIT_PROFILE - CZ                                         01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCRPROF                                                
           END-EXEC.                                                            
      *                                                                 01520014
      * CSS_DELINQUENCY - C8                                            01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_DEP_ON_HAND - DO                                            01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPHND                                                
           END-EXEC.                                                            
      *                                                                         
      * CSS_REG_PROFILE - LR                                            01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBREGPRF                                                
           END-EXEC.                                                            
      *                                                                         
      * CSS_MAX_DEP_REVIEW - MG                                         01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPREV                                                
           END-EXEC.                                                            
      *                                                                         
      * CSS_RATE_CREATOR - RT                                           01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRTCRTR                                                
           END-EXEC.                                                            
      *                                                                         
      * CSS_UTIL_ENVRNMT - UT                                           01520014
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
A05091*                                                                         
A05091* CSS_ACCT_MISC_INFO TA                                           01520014
A05091*                                                                         
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
      *                                                                         
      ******************************************************************01530014
      * COBOL Working Storage Copy Books                               *03050831
      ******************************************************************01550014
      *                                                                 01490014
      * WS-WARNING-DATA-ELEMENTS                                        03050834
      *                                                                 01494014
           COPY CWS00303.                                               01510014
      *                                                                 01490014
      * GOOD CREDIT RULE                                                03050834
      *                                                                 01494014
           COPY CWS00334.                                               01510014
      *                                                                 03050837
      * CSRERLOG-P                                                      03050838
      *                                                                 03050839
           COPY CWSSP001.                                               01511015
      *                                                                 01520014
      ******************************************************************01530014
      * Declare Result set Cursors                                     *03050843
      ******************************************************************01550014
      *                                                                 01560014
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT * FROM #CSR04610_R1                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     02980008
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            03060009
MFA-TR*                          WITH ROWSET POSITIONING FOR            03060010
MFA-TR*        SELECT * FROM SESSION.CSR04610_R1                        03060011
MFA-TR*    END-EXEC.                                                    03060007
      *                                                                 03060100
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT * FROM #CSR04610_R2                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03060207
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            03060040
MFA-TR*                          WITH ROWSET POSITIONING FOR            03060050
MFA-TR*        SELECT * FROM SESSION.CSR04610_R2                        03060060
MFA-TR*    END-EXEC.                                                    03060007
      *                                                                 03050850
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT * FROM #CSR04610_R3                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03062807
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            03060400
MFA-TR*                          WITH ROWSET POSITIONING FOR            03060500
MFA-TR*        SELECT * FROM SESSION.CSR04610_R3                        03060600
MFA-TR*    END-EXEC.                                                    03065407
      *                                                                 03060200
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT * FROM #CSR04610_R4                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03065607
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            03061300
MFA-TR*                          WITH ROWSET POSITIONING FOR            03061400
MFA-TR*        SELECT * FROM SESSION.CSR04610_R4                        03061410
MFA-TR*    END-EXEC.                                                    03065407
      *                                                                 03060200
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT * FROM #CSR04610_R5                        
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03065607
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                            03061300
MFA-TR*                          WITH ROWSET POSITIONING FOR            03061400
MFA-TR*        SELECT * FROM SESSION.CSR04610_R5                        03061410
MFA-TR*    END-EXEC.                                                    03065407
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2092 CURSOR
MSQ001          FOR CALL CSR02092( :WS-ACCOUNT-NO-IN
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2304 CURSOR
MSQ001          FOR CALL CSR02304 ( :WS-ACCOUNT-NO-IN
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2164 CURSOR
MSQ001          FOR CALL CSR02164 ( :WS-ACCOUNT-NO-IN
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2150 CURSOR
MSQ001          FOR CALL CSR02150  ( :WS-BOND-TYPE
                  , :WS-ACCOUNT-NO-IN
                  )
MSQ001        END-EXEC.
                                                    
      *                                                                 03065507
      ******************************************************************03068508
      * Linkage Section                                                *03068509
      ******************************************************************03068510
      *                                                                 03068520
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO         PIC X(13).                           
      *                                                                 03069008
      ******************************************************************03100000
      * Procedure Division                                             *03069010
      ******************************************************************03130000
      *                                                                 03069030
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
       0000-MAINLINE.                                                   
      *                                                                 03150100
           MOVE '0000'                 TO ACTIVE-PARAGRAPH.             
      *                                                                 03150100
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                 03190100
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +100 TO S-RETURN-CODE-1                             
           END-IF.                                                      
      *                                                                 03200226
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 03210000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03240000
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      ******************************************************************03330000
      *                                                                 03340008
       0100-INITIALIZE.                                                 
      *                                                                 03360008
           MOVE '0100'                 TO ACTIVE-PARAGRAPH.             
      *                                                                 03614106
           MOVE 'N' TO WS-GTT-R1-DECLARED                               
                       WS-GTT-R1-DECLARED                               
                       WS-GTT-R3-DECLARED                               
                       WS-GTT-R4-DECLARED                               
                       WS-GTT-R5-DECLARED.                              
      *                                                                 03360660
      * Declare all Temp Tables                                         03360670
      *                                                                 03360680
           PERFORM 0101-DECLARE-GTT-R1 THRU 0101-EXIT.                  
           PERFORM 0102-DECLARE-GTT-R2 THRU 0102-EXIT.                  
           PERFORM 0103-DECLARE-GTT-R3 THRU 0103-EXIT.                  
           PERFORM 0104-DECLARE-GTT-R4 THRU 0104-EXIT.                  
           PERFORM 0105-DECLARE-GTT-R5 THRU 0105-EXIT.                  
      *                                                                 03578037
           PERFORM 7430-GET-CURRENT-DATE THRU 7430-EXIT.                
      *                                                                 03578037
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03591008
      ******************************************************************03613606
      *0101-DECLARE-GTT-R1.                                             03613759
      ******************************************************************03613806
      *                                                                 03613906
       0101-DECLARE-GTT-R1.                                             
      *                                                                 03614106
            MOVE '0101'                TO ACTIVE-PARAGRAPH.             
      *                                                                 03614106
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04610_R1'           
                                       TO S-SQL-STATEMENT-V.            
      *                                                                 03614406
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04610_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04610_R1
               (                                                       
                    MIN_DEPOSIT_AMT      DECIMAL(11,2)                  
                   ,MAX_DEPOSIT_AMT      DECIMAL(11,2)                  
                   ,USAGE_HISTORY_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DEP_EXISTS_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DELQ_DEP_NTFY_LTR    DECIMAL(5,0)                   
                   ,DEP_ACTION_CODE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DEPOSIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SERVICE_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DEPOSIT_CERT_NO      INT                        
                   ,AMT_ORIG_ENTERED     DECIMAL(11,2)                  
                   ,BILL_OPTION_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,BILLED_FLAG CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,AMT_PAID             DECIMAL(11,2)                  
                   ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CODE_DEP_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,NO_SCHED_PYMTS       SMALLINT                       
                   ,AMT_MO_PYMT          DECIMAL(09,2)                  
                   ,BILL_COUNT           SMALLINT                       
                   ,USER_ID_UPDT_BY CHAR(07)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_PYMT_START CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,OLD_BILL_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[2ND_OLD_BILL_DATE] CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,NEXT_BILLING_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[2ND_NEXT_BILL_DATE] CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,LAST_BILL_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DELINQUENCY_VALUE    DECIMAL(5,0)                   
                   ,DEP_DNP_LIMIT        DECIMAL(5,0)                   
                   ,REBILLED_DEP_AMT     DECIMAL(09,2)                  
                   ,REBILLED_DEP_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,IMME_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,IMME_CUT_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CODE_DISC_OK CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CREDIT_GROUP CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,NOT_CURR_MTH_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,RETURN_CODE          INT                        
                   ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_FIRST_NOTICE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,INSTLMNT_STRT_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,NEXT_BILL_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,NEXT_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,IMMED_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_FIRST_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_SECOND_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CURRENT_BILL_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,ORIG_IMMED_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CUR_IMMED_DUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DT_FST_NTCE_OLD CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CUT_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,FINAL_INSTLMNT_AMT   INT                        
                   ,CODE_REFUND_ELIG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,AGENCY_TEXT CHAR(72)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,AUTODEP_LTR_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,AUTODEP_LTR_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_CERT_ISSUE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,PROJECTED_CR_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03617006
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 03617506
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8001-DELETE-GTT-ROWS THRU 8001-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04610_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
            MOVE 'Y' TO WS-GTT-R1-DECLARED.                             
      *                                                                 03619606
       0101-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03619906
      ******************************************************************03620059
      *0102-DECLARE-GTT-R2.                                             03626259
      ******************************************************************03620259
      *                                                                 03620359
       0102-DECLARE-GTT-R2.                                             
      *                                                                 03620559
            MOVE '0102'                  TO ACTIVE-PARAGRAPH.           
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04610_R2'           
                                         TO S-SQL-STATEMENT-V.          
      *                                                                 03620859
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04610_R2')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04610_R2
               (                                                       
                    RETURN_CODE            INT                      
                   ,GRNT_ACCT_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,AMT_GUARANTEE          DECIMAL(11,2)                
                   ,GUAR_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,TRIGGER_DATE CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,STATUS_REASON CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,SERV_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CONTRACT_ID            INT                      
                   ,CONTRACT_AMT           DECIMAL(13,2)                
                   ,CNT_NAME_ABBR CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,SEND_NOTICE_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,SN_ADDR_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,GUAR_ACCT CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CREDIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,ADDRESS_ID CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,GUAR_ACCT_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,NAME_USAGE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,TITLE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MIDDLE_NAME CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,TITLE_SUFFIX1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,TITLE_SUFFIX2 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,ADDR_USAGE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FR_ADDR_STREET CHAR(55)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_HOUSE_NO CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_ADDR_PREFIX1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FR_CITY_STATE CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_ADDR_PREFIX2 CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_STREET_NAME CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_STREET_SUFFIX CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_ADDR_SUFFIX CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FR_ADDR_ZIP CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_STREET1 CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FO_STREET2 CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FR_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FO_TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,FO_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,FO_ZIP_CODE CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_ZIP_PLUS CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FR_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,FO_CARRIER_ROUTE CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,HOME_PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,WORK_PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LICENSE CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,STATE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
                   ,SN_STREET CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SN_CITY_STATE CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,SN_ZIP_CODE CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,SN_COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SN_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,WQ_ITEM_ID             DECIMAL(10,0)                
                   ,GUAR_ESTBLSH_DT CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,MAX_DEPOSIT_AMT        DECIMAL(11,2)                
                   ,GUAR_CUST_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03623159
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 03623659
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8002-DELETE-GTT-ROWS THRU 8002-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04610_R2'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
            MOVE 'Y' TO WS-GTT-R2-DECLARED.                             
      *                                                                 03625759
       0102-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03619807
      ******************************************************************03626159
      *0103-DECLARE-GTT-R3.                                             03631359
      ******************************************************************03631459
      *                                                                 03631559
       0103-DECLARE-GTT-R3.                                             
      *                                                                 03631759
            MOVE '0103'                   TO ACTIVE-PARAGRAPH.          
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04610_R3'           
                                          TO S-SQL-STATEMENT-V.         
      *                                                                 03632059
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04610_R3')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04610_R3
               (                                                       
                    RETURN_CODE            INT                      
                   ,WAIVER_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,CODE_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CODE_STATUS_REAS CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,WAIVER_SOURCE_DESC CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,TRIGGER_DATE CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,BOND_ITEM_ID           INT                      
                   ,SSN_NUMBER CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03633559
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 03633959
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8003-DELETE-GTT-ROWS THRU 8003-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04610_R3'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
            MOVE 'Y' TO WS-GTT-R3-DECLARED.                             
      *                                                                 03636059
       0103-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03636359
      ******************************************************************03636459
      *0104-DECLARE-GTT-R4.                                             03636559
      ******************************************************************03636659
      *                                                                 03636759
       0104-DECLARE-GTT-R4.                                             
      *                                                                 03636959
            MOVE '0104'                   TO ACTIVE-PARAGRAPH.          
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04610_R4'           
                                          TO S-SQL-STATEMENT-V.         
      *                                                                 03637259
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04610_R4')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04610_R4
               (                                                       
                     RETURN_CODE         INT                        
                    ,ACCOUNT_NO CHAR(13)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,CODE_BOND_TYPE CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,AMT_BOND            DECIMAL(11,2)                  
                    ,WAIV_ITEM_ID CHAR(09)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,BOND_CO_NO          DECIMAL(6,0)                   
                    ,CODE_STATUS CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,TRIGGER_DATE CHAR(08)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,CODE_STATUS_REAS CHAR(20)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,ORIGINATED_BY CHAR(20)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,BOND_NO CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2          
                    ,BOND_TOTAL_AMT      DECIMAL(11,2)                  
                    ,ISSUE_DATE CHAR(08)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,EXPIRATION_DATE CHAR(08)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2             
                    ,ADDRESS CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
                    ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,MIN_DEPOSIT_AMT     DECIMAL(11,2)                  
                    ,MAX_DEPOSIT_AMT     DECIMAL(11,2)                  
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03638759
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 03639159
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8004-DELETE-GTT-ROWS THRU 8004-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04610_R4'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
            MOVE 'Y' TO WS-GTT-R4-DECLARED.                             
      *                                                                 03641259
       0104-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03641559
      ******************************************************************03636459
      *0105-DECLARE-GTT-R5.                                             03636559
      ******************************************************************03636659
      *                                                                 03636759
       0105-DECLARE-GTT-R5.                                             
      *                                                                 03636959
            MOVE '0105'                   TO ACTIVE-PARAGRAPH.          
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04610_R5'           
                                          TO S-SQL-STATEMENT-V.         
      *                                                                 03637259
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04610_R5')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04610_R5
               (                                                       
                     RETURN_CODE         INT                        
                    ,MAX_DEP_REF_XMT_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,LAST_MAX_AT_REV_DT CHAR(10)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                    ,MAX_DEP_AT_REV_AM   DECIMAL(11,2)                  
                    ,PD_DEP_AT_REV_AM    DECIMAL(11,2)                  
                    ,MAX_DEP_REFUND_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 03638759
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 03639159
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8005-DELETE-GTT-ROWS THRU 8005-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04610_R5'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
               END-IF                                                   
            END-IF.                                                     
            MOVE 'Y' TO WS-GTT-R5-DECLARED.                             
      *                                                                 03641259
       0105-EXIT.                                                       
            EXIT.                                                       
      *                                                                 03641559
      ******************************************************************03641659
      * 1000-PROCESS-INPUT                                             *03646759
      *                                                                *03646859
      *     1. RECEIVE PARMS.                                          *03647059
      *                                                                *03650000
      ******************************************************************03660000
      *                                                                 03670000
       1000-PROCESS-INPUT.                                              
      *                                                                 03690000
           MOVE '1000'                TO ACTIVE-PARAGRAPH.              
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO-IN.              
      *                                                                 03720000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04180000
      ******************************************************************04190000
      * 2000-PROCESS-OUTPUT.                                           *04200000
      ******************************************************************04310000
      *                                                                 04320000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 04340000
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
      * Cash Deposits                                                   04340100
           PERFORM 2100-CALL-CSR02092    THRU 2100-EXIT.                
      * Guarantors                                                      04474140
           PERFORM 2200-CALL-CSR02304    THRU 2200-EXIT.                
      * Waivers                                                         04474370
           PERFORM 2300-CALL-CSR02164    THRU 2300-EXIT.                
      * Surety Bonds                                                    04474562
           MOVE 'A'                      TO WS-BOND-TYPE.               
           PERFORM 2400-CALL-CSR02150    THRU 2400-EXIT.                
      * ILOC                                                            04474763
           MOVE 'B'                      TO WS-BOND-TYPE.               
           PERFORM 2400-CALL-CSR02150    THRU 2400-EXIT.                
      * Max Deposit Review Details                                      04474763
           PERFORM 2500-DEP-REVIEW-DET   THRU 2500-EXIT.                
      *                                                                 04476003
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 2100-CALL-CSR02092                                            * 07680011
      ***************************************************************** 07690003
      *                                                                 07691006
       2100-CALL-CSR02092.                                              
      *                                                                 07710003
           MOVE '2100'                   TO ACTIVE-PARAGRAPH.           
           INITIALIZE GTT-RETURN-FIELDS-1.                              
      *                                                                 07617003
      *    EXEC SQL                                                     
      *       CALL CSR02092(:WS-ACCOUNT-NO-IN)                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2092
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2092
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2092 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 07623003
           IF SQLCODE = +466 THEN                                       
      *                                                                 07627105
              PERFORM 2110-GET-DELINQ-VALUES THRU 2110-EXIT             
              PERFORM 2120-CHK-GOOD-CREDIT   THRU 2120-EXIT             
      *                                                                 07627105
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2092) WITH PROCEDURE      
      *         CSR02092                                                
      *       END-EXEC                                                  
      *                                                                 07627105
      *       EXEC SQL                                                  
      *          ALLOCATE RESULT_SET_CSR_2092 CURSOR FOR RESULT SET     
      *          :LOC2092                                               
      *       END-EXEC                                                  
      *                                                                 07629105
              PERFORM UNTIL NO-MORE-ROWS                                
                 EXEC SQL                                               
                    FETCH RESULT_SET_CSR_2092 INTO                      
                           :S-MIN-DEPOSIT-AMT                           
                          ,:S-MAX-DEPOSIT-AMT-1                         
                          ,:S-USAGE-HISTORY-FLAG                        
                          ,:S-DEP-EXISTS-FLAG                           
                          ,:S-DELQ-DEP-NTFY-LTR                         
                          ,:S-DEP-ACTION-CODE                           
                          ,:S-DEPOSIT-STATUS-CD                         
                          ,:S-DATE-TRAN                                 
                          ,:S-SERVICE-TYPE-CD                           
                          ,:S-DEPOSIT-CERT-NO                           
                          ,:S-AMT-ORIG-ENTERED-1                        
                          ,:S-BILL-OPTION-CD                            
                          ,:S-BILLED-FLAG                               
                          ,:S-AMT-PAID                                  
                          ,:S-COMMENT                                   
                          ,:S-CODE-DEP-TYPE                             
                          ,:S-NO-SCHED-PYMTS                            
                          ,:S-AMT-MO-PYMT                               
                          ,:S-BILL-COUNT                                
                          ,:S-USER-ID-UPDT-BY                           
                          ,:S-DATE-PYMT-START                           
                          ,:S-OLD-BILL-DATE                             
                          ,:S-2ND-OLD-BILL-DATE                         
                          ,:S-NEXT-BILLING-DATE                         
                          ,:S-2ND-NEXT-BILL-DATE                        
                          ,:S-LAST-BILL-DATE                            
                          ,:S-MST-SUB-ACCT-IND                          
                          ,:S-DELINQUENCY-VALUE                         
                          ,:S-DEP-DNP-LIMIT                             
                          ,:S-REBILLED-DEP-AMT                          
                          ,:S-REBILLED-DEP-DATE                         
                          ,:S-IMME-DUE-DATE                             
                          ,:S-IMME-CUT-DATE                             
                          ,:S-CODE-DISC-OK                              
                          ,:S-CREDIT-GROUP                              
                          ,:S-NOT-CURR-MTH-FLAG                         
                          ,:S-RETURN-CODE-1                             
                          ,:S-AT-LAST-UPDATE-TS                         
                          ,:S-DATE-FIRST-NOTICE                         
                          ,:S-INSTLMNT-STRT-DATE                        
                          ,:S-NEXT-BILL-DATE                            
                          ,:S-NEXT-DUE-DATE                             
                          ,:S-IMMED-DUE-DATE                            
                          ,:S-DATE-FIRST-DUE                            
                          ,:S-DATE-SECOND-DUE                           
                          ,:S-CURRENT-BILL-DUE                          
                          ,:S-ORIG-IMMED-DUE                            
                          ,:S-CUR-IMMED-DUE                             
                          ,:S-DT-FST-NTCE-OLD                           
                          ,:S-CUT-DATE                                  
                          ,:S-FINAL-INSTLMNT-AMT                        
                          ,:S-CODE-REFUND-ELIG                          
                          ,:S-AGENCY-TEXT                               
                          ,:S-AUTODEP-LTR-DT                            
                          ,:S-AUTODEP-LTR-IND                           
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07631203
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
      *                                                                 07631459
                 EVALUATE WS-ACTIVE-RETURN-CODE                         
                    WHEN SUCCESSFUL-CALL                                
                       EVALUATE S-RETURN-CODE-1                         
                          WHEN 0                                        
                             PERFORM 2130-GET-ADDL-DEP-DETAILS          
                                THRU 2130-EXIT                          
                             PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT  
                          WHEN OTHER                                    
                             IF S-RETURN-CODE-1 = -1                    
                                MOVE 100 TO S-RETURN-CODE-1             
                             END-IF                                     
                             PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT  
                       END-EVALUATE                                     
                    WHEN NOT-FOUND                                      
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                    WHEN OTHER                                          
                       MOVE PROGRAM-NAME          TO ABEND-PROGRAM      
                       MOVE 'FETCH'               TO ABEND-FUNCTION     
                       MOVE 'CSR02092'            TO TABLE-1            
                       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1    
                       MOVE WS-ACCOUNT-NO-IN      TO HOSTVAR-ELEMENT-1  
                       PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT       
                 END-EVALUATE                                           
              END-PERFORM                                               
              MOVE 'Y' TO SW-FETCH                                      
           END-IF.                                                      
      *                                                                 07637003
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 2110-GET-DELINQ-VALUES.                                       * 07680011
      ***************************************************************** 07690003
      *                                                                 07691006
       2110-GET-DELINQ-VALUES.                                          
      *                                                                 07691006
           MOVE '2110'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 07691006
           MOVE WS-ACCOUNT-NO-IN         TO AT-ACCOUNT-NO.              
           PERFORM 7100-SEL-ACCOUNT      THRU 7100-EXIT.                
           MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MTH-HOLD             
      *                                                                 07691006
           IF WS-COMPANY = 0                                            
              MOVE 'DATABASE'              TO C8-DELINQ-CD              
              MOVE AT-COMPANY-NO           TO C8-COMPANY-NO             
              PERFORM 7000-SEL-DELINQUENCY THRU 7000-EXIT               
              MOVE C8-DELINQ-VALUE         TO WS-COMPANY                
           END-IF                                                       
      *                                                                         
           EVALUATE AT-ACCOUNT-TYPE-CODE                                
           WHEN 'R'                                                     
                MOVE 'RETAIN-RESIDENT-DEP' TO  C8-DELINQ-CD             
           WHEN 'C'                                                     
                MOVE 'RETAIN-COMMER-DEP'   TO  C8-DELINQ-CD             
           WHEN 'I'                                                     
                MOVE 'RETAIN-INDUST-DEP'   TO  C8-DELINQ-CD             
           WHEN OTHER                                                   
                MOVE 'RETAIN-RESIDENT-DEP' TO  C8-DELINQ-CD             
           END-EVALUATE.                                                
           PERFORM 7000-SEL-DELINQUENCY  THRU 7000-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-LIMIT-MONTH.             
      *                                                                         
           IF COMPANY-CSR                                               
              IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'I'                      
                 CONTINUE                                               
              ELSE                                                      
                 IF AT-COMPANY-NO = '01'                                
                    MOVE 'RES-SECUR-START-DATE' TO C8-DELINQ-CD         
                    PERFORM 7000-SEL-DELINQUENCY  THRU 7000-EXIT        
                    MOVE C8-DELINQ-VALUE        TO WS-DELINQ-VALUE9     
                    MOVE WS-DELINQ-VALUEX(1:4)  TO WS-RES-DATE-CCYY     
                    MOVE WS-DELINQ-VALUEX(5:2)  TO WS-RES-DATE-MM       
                    MOVE WS-DELINQ-VALUEX(7:2)  TO WS-RES-DATE-DD       
                    MOVE '-'                    TO WS-FILLER1-RES       
                                                   WS-FILLER2-RES       
      * Check for Grand fathered Deposits                                       
                    MOVE WS-ACCOUNT-NO-IN       TO DO-ACCOUNT-NO        
                    MOVE WS-RES-SECUR-DATE      TO DO-DATE-TRAN         
                    MOVE 'N'                    TO WS-GF-DEPOSIT        
                    PERFORM 7200-CHECK-GF-DEPOSIT THRU 7200-EXIT        
                    IF WS-GF-DEPOSIT = 'Y'                              
                       MOVE +12                 TO WS-LIMIT-MONTH       
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04476003
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 2120-CHK-GOOD-CREDIT.                                         * 07680011
      ***************************************************************** 07690003
      *                                                                 07691006
       2120-CHK-GOOD-CREDIT.                                            
      *                                                                 04476003
           MOVE '2120'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 07691006
           MOVE WS-ACCOUNT-NO-IN            TO CZ-ACCOUNT-NO.           
           PERFORM 7500-GET-CRED-PROFILE    THRU 7500-EXIT.             
           MOVE CZ-DISCONNECT-HIST          TO WS-ACCT-DISCONNECT-HST.  
           MOVE CZ-DISC-EXCEPTN-HIST        TO WS-ACCT-DISC-EXCEPTN-HST.
      *                                                                 04476003
           IF COMPANY-SEB                                               
              PERFORM 6100-CHK-DISC-HIST     THRU 6100-EXIT             
              PERFORM 6200-CHK-UTIL-ARRS     THRU 6200-EXIT             
              PERFORM 6300-CHK-NON-CONS-ARRS THRU 6300-EXIT             
              MOVE 2                         TO WS-CALC                 
              EVALUATE TRUE                                             
               WHEN WS-UTIL-ARRS-HOLD <= WS-NON-CONS-ARRS-HOLD AND      
                    WS-UTIL-ARRS-HOLD <= WS-DISC-HIST-HOLD     AND      
                    WS-UTIL-ARRS-HOLD <= WS-DISC-EXC-HIST-HOLD          
                    MOVE WS-UTIL-ARRS-HOLD   TO WS-MONTHS-TEMP          
               WHEN WS-DISC-HIST-HOLD <= WS-NON-CONS-ARRS-HOLD AND      
                    WS-DISC-HIST-HOLD <= WS-UTIL-ARRS-HOLD     AND      
                    WS-DISC-HIST-HOLD <= WS-DISC-EXC-HIST-HOLD          
                    MOVE WS-DISC-HIST-HOLD   TO WS-MONTHS-TEMP          
               WHEN WS-DISC-EXC-HIST-HOLD <= WS-NON-CONS-ARRS-HOLD AND  
                    WS-DISC-EXC-HIST-HOLD <= WS-UTIL-ARRS-HOLD     AND  
                    WS-DISC-EXC-HIST-HOLD <= WS-DISC-HIST-HOLD          
                    MOVE WS-DISC-EXC-HIST-HOLD  TO WS-MONTHS-TEMP       
               WHEN OTHER                                               
                    MOVE WS-NON-CONS-ARRS-HOLD  TO WS-MONTHS-TEMP       
               END-EVALUATE                                             
           ELSE                                                         
               MOVE CZ-ARREARS-HIST(1:WS-LIMIT-MONTH) TO WS-ACCT-HST    
               MOVE CZ-ARREARS-HIST(1:WS-LIMIT-MONTH) TO WS-ACCT-HST    
               MOVE WS-LIMIT-MONTH                    TO WS-DELINQ-MTH  
                                                         WS-ELIG-NO-MTHS
               MOVE PROGRAM-NAME             TO WS-PROGRAM-CPD334       
               MOVE 'Y'                      TO WS-NOT-USE-CR-HIST-FL   
               MOVE 'N'                      TO WS-FORECAST-CRED-GR-FL  
               MOVE AT-COMPANY-NO            TO WS-COMPANY-CPD334       
               PERFORM 6565-PROCESS-CREDIT-RULE THRU 6565-EXIT          
               MOVE WS-PROJ-REF-POSITION     TO WS-MONTHS-TEMP          
               MOVE 1                        TO WS-CALC                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-MONTHS-TEMP               TO WS-MONTHS-SQL.          
           PERFORM 7400-SET-PROJ-RFND-DATE   THRU 7400-EXIT.            
           IF WS-PROJ-RFND-DATE (1:4) = WS-REV-MTH-CHAR (1:4) AND       
              WS-PROJ-RFND-DATE (6:2) = WS-REV-MTH-CHAR (5:2)           
              PERFORM 7410-ADD-1-MONTH       THRU 7410-EXIT             
           END-IF.                                                      
      *                                                                 04476003
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 2130-GET-ADDL-DEP-DETAILS.                                    * 07680011
      ***************************************************************** 07690003
      *                                                                 07691006
       2130-GET-ADDL-DEP-DETAILS.                                       
      *                                                                 04476003
           MOVE '2130'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 07691006
           MOVE WS-ACCOUNT-NO-IN             TO DO-ACCOUNT-NO.          
           MOVE S-DEPOSIT-CERT-NO            TO DO-DEPOSIT-CERT-NO.     
           PERFORM 7300-SEL-DEP-DETAILS      THRU 7300-EXIT.            
           MOVE DO-DATE-CERT-ISSUE           TO S-DATE-CERT-ISSUE.      
      *                                                                 04476003
           IF (S-DEPOSIT-STATUS-CD = 'A' OR 'P') AND                    
              (S-CODE-REFUND-ELIG  = '0' OR ' ')                        
              IF S-DATE-PYMT-START NOT = SPACES                         
                 IF COMPANY-SEB AND S-DATE-CERT-ISSUE NOT = SPACES      
                    MOVE S-DATE-CERT-ISSUE   TO WS-DEP-PAID-DATE        
                    PERFORM 7420-CALC-DATE-FROM-PMT    THRU 7420-EXIT   
                 ELSE                                                   
                    MOVE S-DATE-PYMT-START   TO WS-DEP-PAID-DATE        
                    IF WS-CALC-DT-FROM-PMT = SPACES                     
                       PERFORM 7420-CALC-DATE-FROM-PMT THRU 7420-EXIT   
                    END-IF                                              
                 END-IF                                                 
      *                                                                 04476003
                 IF WS-CALC-DT-FROM-PMT > WS-PROJ-RFND-DATE             
                    MOVE WS-CALC-DT-FROM-PMT TO S-PROJECTED-CR-DT       
                 ELSE                                                   
                    MOVE WS-PROJ-RFND-DATE   TO S-PROJECTED-CR-DT       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                    TO S-PROJECTED-CR-DT       
           END-IF.                                                      
      *                                                                 04476003
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07660003
      ***************************************************************** 07670003
      * 2200-CALL-CSR02304                                            * 07767311
      ***************************************************************** 07690003
      *                                                                 07691006
       2200-CALL-CSR02304.                                              
      *                                                                 07710003
           MOVE '2200'                       TO ACTIVE-PARAGRAPH.       
           INITIALIZE GTT-RETURN-FIELDS-2.                              
      *                                                                 07730003
      *    EXEC SQL                                                     
      *       CALL CSR02304 (:WS-ACCOUNT-NO-IN)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2304
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2304
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2304 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 07754003
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2304) WITH PROCEDURE      
      *         CSR02304                                                
      *       END-EXEC                                                  
      *                                                                 07758106
      *       EXEC SQL                                                  
      *          ALLOCATE RESULT_SET_CSR_2304 CURSOR FOR RESULT SET     
      *          :LOC2304                                               
      *       END-EXEC                                                  
      *                                                                 07759406
              PERFORM UNTIL NO-MORE-ROWS                                
                 EXEC SQL                                               
                    FETCH RESULT_SET_CSR_2304 INTO                      
                           :S-RETURN-CODE-2                             
                          ,:S-GRNT-ACCT-TYPE                            
                          ,:S-AMT-GUARANTEE                             
                          ,:S-CODE-GUAR-STATUS                          
                          ,:S-TRIGGER-DATE                              
                          ,:S-STATUS-REASON                             
                          ,:S-CODE-SERV-TYPE                            
                          ,:S-CNT-ITEM-ID                               
                          ,:S-AMT-ORIG-ENTERED-2                        
                          ,:S-CNT-NAME-ABBR                             
                          ,:S-SEND-NOTICE-FLAG                          
                          ,:S-SN-ADDR-FLAG                              
                          ,:S-GUAR-ACCT-NO                              
                          ,:S-CREDIT-STATUS-CD                          
                          ,:S-ADDRESS-ID                                
                          ,:S-GUAR-ACCT-TYPE                            
                          ,:S-UPDATE-TS                                 
                          ,:S-NAME-USAGE                                
                          ,:S-FULL-NAME                                 
                          ,:S-TITLE                                     
                          ,:S-FIRST-NAME                                
                          ,:S-MIDDLE-NAME                               
                          ,:S-LAST-NAME                                 
                          ,:S-TITLE-SUFFIX1                             
                          ,:S-TITLE-SUFFIX2                             
                          ,:S-ADDR-USAGE                                
                          ,:S-ADDR-STREET                               
                          ,:S-HOUSE-NO                                  
                          ,:S-ADDR-PREFIX1                              
                          ,:S-ADDR-CITY-STATE                           
                          ,:S-ADDR-PREFIX2                              
                          ,:S-STREET-NAME                               
                          ,:S-STREET-SUFFIX                             
                          ,:S-ADDR-SUFFIX                               
                          ,:S-ADDR-ZIP-CODE                             
                          ,:S-STREET-LOCATION1                          
                          ,:S-STREET-LOCATION2                          
                          ,:S-ADDR-COUNTRY                              
                          ,:S-TOWN                                      
                          ,:S-STATE                                     
                          ,:S-ZIP-CODE                                  
                          ,:S-ZIP-CODE-PLUS                             
                          ,:S-ADDR-OVERFLOW                             
                          ,:S-ADDR-OVERFLOW-FORM                        
                          ,:S-CARRIER-ROUTE                             
                          ,:S-HOME-PHONE                                
                          ,:S-WORK-PHONE                                
                          ,:S-PHONE-EXT                                 
                          ,:S-DRIVER-LICENSE                            
                          ,:S-CODE-STATE-ID                             
                          ,:S-SSN                                       
                          ,:S-SN-STREET                                 
                          ,:S-SN-CITY-STATE                             
                          ,:S-SN-ZIP-CODE                               
                          ,:S-SN-COUNTRY                                
                          ,:S-SN-OVERFLOW                               
                          ,:S-WQ-ITEM-ID                                
                          ,:S-GUAR-ESTBLSH-DT                           
                          ,:S-MAX-DEPOSIT-AMT-2                         
                          ,:S-CUSTOMER-NO                               
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07761806
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
      *                                                                 07762059
                 EVALUATE WS-ACTIVE-RETURN-CODE                         
                    WHEN SUCCESSFUL-CALL                                
                       EVALUATE S-RETURN-CODE-2                         
                          WHEN 0                                        
                             PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT  
                          WHEN OTHER                                    
                             IF S-RETURN-CODE-2 = -1                    
                               MOVE 100 TO S-RETURN-CODE-2              
                             END-IF                                     
                             PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT  
                       END-EVALUATE                                     
                    WHEN NOT-FOUND                                      
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                    WHEN OTHER                                          
                       MOVE PROGRAM-NAME          TO ABEND-PROGRAM      
                       MOVE 'FETCH'               TO ABEND-FUNCTION     
                       MOVE 'CSR02304'            TO TABLE-1            
                       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1    
                       MOVE WS-ACCOUNT-NO-IN      TO HOSTVAR-ELEMENT-1  
                       PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT       
                 END-EVALUATE                                           
              END-PERFORM                                               
              MOVE 'Y' TO SW-FETCH                                      
           END-IF.                                                      
      *                                                                 07766803
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07767103
      ***************************************************************** 07767203
      * 2300-CALL-CSR02164                                            * 07776111
      ***************************************************************** 07767403
      *                                                                 07767511
       2300-CALL-CSR02164.                                              
      *                                                                 07767703
           MOVE '2300'                       TO ACTIVE-PARAGRAPH        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
      *                                                                 07730003
      *    EXEC SQL                                                     
      *       CALL CSR02164 (:WS-ACCOUNT-NO-IN)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2164
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2164
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2164 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 07768503
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2164) WITH PROCEDURE      
      *         CSR02164                                                
      *       END-EXEC                                                  
      *                                                                 07769006
      *       EXEC SQL                                                  
      *          ALLOCATE RESULT_SET_CSR_2164 CURSOR FOR RESULT SET     
      *          :LOC2164                                               
      *       END-EXEC                                                  
      *                                                                 07769506
              PERFORM UNTIL NO-MORE-ROWS                                
                 EXEC SQL                                               
                    FETCH RESULT_SET_CSR_2164 INTO                      
                               :S-RETURN-CODE-3                         
                              ,:S-WAIVER-TYPE-CD-3                      
                              ,:S-CODE-STATUS-3                         
                              ,:S-COMMENTS-3                            
                              ,:S-CODE-STATUS-REAS-3                    
                              ,:S-WAIVER-SOURCE-DESC-3                  
                              ,:S-TRIGGER-DATE-3                        
                              ,:S-BOND-ITEM-ID-3                        
                              ,:S-SSN-NUMBER-3                          
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07771203
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
      *                                                                 07771532
                 EVALUATE WS-ACTIVE-RETURN-CODE                         
                    WHEN SUCCESSFUL-CALL                                
                       EVALUATE S-RETURN-CODE-3                         
                          WHEN 0                                        
                             PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT  
                          WHEN OTHER                                    
                             IF S-RETURN-CODE-3 = -1 OR 200             
                               MOVE 100 TO S-RETURN-CODE-3              
                             END-IF                                     
                             PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT  
                       END-EVALUATE                                     
                    WHEN NOT-FOUND                                      
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                    WHEN OTHER                                          
                       MOVE PROGRAM-NAME          TO ABEND-PROGRAM      
                       MOVE 'FETCH'               TO ABEND-FUNCTION     
                       MOVE 'CSR02164'            TO TABLE-1            
                       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1    
                       MOVE WS-ACCOUNT-NO-IN      TO HOSTVAR-ELEMENT-1  
                       PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT       
                 END-EVALUATE                                           
              END-PERFORM                                               
              MOVE 'Y' TO SW-FETCH                                      
           END-IF.                                                      
      *                                                                 07775603
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07775903
      ***************************************************************** 07776003
      * 2400-CALL-CSR02150                                            * 07784911
      ***************************************************************** 07776203
      *                                                                 07776311
       2400-CALL-CSR02150.                                              
      *                                                                 07776503
           MOVE '2400'                       TO ACTIVE-PARAGRAPH        
      *                                                                 07730003
           INITIALIZE GTT-RETURN-FIELDS-4.                              
      *                                                                 07776703
      *    EXEC SQL                                                     
      *       CALL CSR02150  (:WS-BOND-TYPE                             
      *                      ,:WS-ACCOUNT-NO-IN)                        
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2150
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2150
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2150 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 07777303
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC2150) WITH PROCEDURE      
      *         CSR02150                                                
      *       END-EXEC                                                  
      *                                                                 07777806
      *       EXEC SQL                                                  
      *          ALLOCATE RESULT_SET_CSR_2150 CURSOR FOR RESULT SET     
      *          :LOC2150                                               
      *       END-EXEC                                                  
      *                                                                 07778306
              PERFORM UNTIL NO-MORE-ROWS                                
                 EXEC SQL                                               
                    FETCH RESULT_SET_CSR_2150 INTO                      
                                 :S-RETURN-CODE-4                       
                                ,:S-ACCOUNT-NO-4                        
                                ,:S-AMT-BOND-4                          
                                ,:S-WAIV-ITEM-ID-4                      
                                ,:S-BOND-CO-NO-4                        
                                ,:S-CODE-STATUS-4                       
                                ,:S-TRIGGER-DATE-4                      
                                ,:S-CODE-STATUS-REAS-4                  
                                ,:S-ORIGINATED-BY-4                     
                                ,:S-BOND-NO-4                           
                                ,:S-BOND-TOTAL-AMT-4                    
                                ,:S-ISSUE-DATE-4                        
                                ,:S-EXPIRATION-DATE-4                   
                                ,:S-NAME-4                              
                                ,:S-ADDRESS-4                           
                                ,:S-CODE-ACCT-STAT-4                    
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07780003
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
      *                                                                 07781232
                 EVALUATE WS-ACTIVE-RETURN-CODE                         
                    WHEN SUCCESSFUL-CALL                                
                       EVALUATE S-RETURN-CODE-4                         
                          WHEN 0                                        
                             MOVE S-ACCOUNT-NO-4   TO WS-ACCOUNT-NO     
                             PERFORM 7610-SEL-BILL-CYCLE THRU 7610-EXIT 
                             IF WS-COMPANY = 0                          
                                MOVE 'DATABASE'    TO C8-DELINQ-CD      
                                MOVE AT-COMPANY-NO TO C8-COMPANY-NO     
                                PERFORM 7000-SEL-DELINQUENCY THRU       
                                        7000-EXIT                       
                                MOVE C8-DELINQ-VALUE TO WS-COMPANY      
                             END-IF                                     
                             MOVE WS-COMPANY       TO WS-DATABASE       
                             MOVE ZERO             TO WS-PREMISE-NO     
                             PERFORM 5650-GET-MAX-DEPOSIT               
                                THRU 5650-GET-MAX-DEPOSIT-EXIT          
                             MOVE WS-MIN-DEPOSIT-AMT TO S-MIN-DEP-AMT-4 
                             MOVE WS-MAX-DEPOSIT-AMT TO S-MAX-DEP-AMT-4 
                             MOVE WS-BOND-TYPE TO S-CODE-BOND-TYPE-4    
                             PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT  
                          WHEN OTHER                                    
                             IF S-RETURN-CODE-4 = -1                    
                               MOVE 100 TO S-RETURN-CODE-4              
                             END-IF                                     
                             MOVE WS-BOND-TYPE TO S-CODE-BOND-TYPE-4    
                             PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT  
                       END-EVALUATE                                     
                    WHEN NOT-FOUND                                      
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                    WHEN OTHER                                          
                       MOVE PROGRAM-NAME          TO ABEND-PROGRAM      
                       MOVE 'FETCH'               TO ABEND-FUNCTION     
                       MOVE 'CSR02150'            TO TABLE-1            
                       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1    
                       MOVE WS-ACCOUNT-NO-IN      TO HOSTVAR-ELEMENT-1  
                       PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT       
                 END-EVALUATE                                           
              END-PERFORM                                               
              MOVE 'Y' TO SW-FETCH                                      
           END-IF.                                                      
      *                                                                 07784403
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************23080000
      * 2500-DEP-REVIEW-DET                                            *23090000
      ******************************************************************23120000
      *                                                                 07942004
       2500-DEP-REVIEW-DET.                                             
      *                                                                 07784403
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           MOVE '2500'                       TO ACTIVE-PARAGRAPH        
      *                                                                 07730003
           MOVE WS-ACCOUNT-NO-IN       TO MG-ACCOUNT-NO.                
           PERFORM 7600-SEL-MAX-DEP-REVIEW   THRU 7600-EXIT.            
      *                                                                 07781232
           MOVE SQLCODE                TO S-RETURN-CODE-5.              
           MOVE AT-MAX-DEP-REF-XMT-CD  TO S-MAX-DEP-REF-XMT-CD.         
           MOVE MG-LAST-MAX-AT-REV-DT  TO S-LAST-MAX-AT-REV-DT.         
           MOVE MG-MAX-DEP-AT-REV-AM   TO S-MAX-DEP-AT-REV-AM.          
           MOVE MG-PD-DEP-AT-REV-AM    TO S-PD-DEP-AT-REV-AM.           
           MOVE MG-MAX-DEP-REFUND-CD   TO S-MAX-DEP-REFUND-CD.          
      *                                                                 07784403
           PERFORM 8500-SEND-RESULT-5        THRU 8500-EXIT.            
      *                                                                 07784403
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************23080000
      * 5650-GET-MAX-DEPOSIT                                           *23090000
      ******************************************************************23120000
      *                                                                 07942004
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************23080000
      * 6100-CHK-DISC-HIST.                                            *23090000
      ******************************************************************23120000
      *                                                                 07942004
       6100-CHK-DISC-HIST.                                              
      *                                                                 23140000
           MOVE '6100'                 TO ACTIVE-PARAGRAPH.             
           MOVE 'N'                    TO WS-DISC-HIST-SW.              
      *                                                                         
           PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
             UNTIL WS-COUNTER > WS-LIMIT-MONTH OR DISC-HIST-FOUND       
             IF CZ-DISCONNECT-HIST(WS-COUNTER:1) = '3' OR '4' OR 'I' OR 
                                                   'R'                  
               MOVE 'Y'                TO WS-DISC-HIST-SW               
               MOVE WS-COUNTER         TO WS-DISC-HIST-HOLD             
             END-IF                                                     
           END-PERFORM                                                  
      *                                                                         
           IF DISC-HIST-NOT-FOUND                                       
              COMPUTE WS-DISC-HIST-HOLD  = WS-LIMIT-MONTH + 1           
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                    TO WS-DISC-HIST-SW               
      *                                                                         
           PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
             UNTIL WS-COUNTER > WS-LIMIT-MONTH OR DISC-HIST-FOUND       
                IF CZ-DISC-EXCEPTN-HIST(WS-COUNTER:1) = '3' OR '4' OR   
                                                        'I' OR 'R'      
                  MOVE 'Y'             TO WS-DISC-HIST-SW               
                  MOVE WS-COUNTER      TO WS-DISC-EXC-HIST-HOLD         
                END-IF                                                  
           END-PERFORM                                                  
      *                                                                         
           IF DISC-HIST-NOT-FOUND                                       
              COMPUTE WS-DISC-EXC-HIST-HOLD  = WS-LIMIT-MONTH + 1       
           END-IF.                                                      
      *                                                                 07784403
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      *                                                                 07942004
      ******************************************************************23080000
      * 6200-CHK-UTIL-ARRS.                                            *23090000
      ******************************************************************23120000
      *                                                                 07942004
       6200-CHK-UTIL-ARRS.                                              
      *                                                                 23140000
           MOVE '6200'                 TO ACTIVE-PARAGRAPH              
      *                                                                         
           MOVE 'N'                    TO  WS-UTIL-ARRS-SW.             
           PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
             UNTIL WS-COUNTER > WS-LIMIT-MONTH OR UTIL-ARRS-FOUND       
             IF CZ-ARREARS-HIST(WS-COUNTER:1) >= '1'                    
                MOVE 'Y'               TO WS-UTIL-ARRS-SW               
                MOVE WS-COUNTER        TO WS-UTIL-ARRS-HOLD             
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
           IF UTIL-ARRS-NOT-FOUND                                       
              COMPUTE WS-UTIL-ARRS-HOLD = WS-LIMIT-MONTH + 1            
           END-IF.                                                      
      *                                                                 07784403
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************23080000
      * 6300-CHK-NON-CONS-ARRS.                                        *23090000
      ******************************************************************23120000
      *                                                                 07942004
       6300-CHK-NON-CONS-ARRS.                                          
      *                                                                 23140000
           MOVE '6300'                 TO ACTIVE-PARAGRAPH              
           MOVE 'N'                    TO WS-PREV-ARRS-SW               
                                          WS-2ND-PREV-ARRS-SW           
                                          WS-NON-CONS-ARRS-SW.          
      *                                                                         
           PERFORM VARYING WS-COUNTER FROM +1 BY +1                     
             UNTIL NON-CONS-ARRS-FOUND OR WS-COUNTER > WS-LIMIT-MONTH   
                IF (CZ-ARREARS-HIST(WS-COUNTER:1) = '1')                
                   AND PREV-ARRS-FOUND                                  
                   AND 2ND-PREV-ARRS-FOUND                              
                   MOVE 'Y'            TO WS-NON-CONS-ARRS-SW           
                   MOVE WS-COUNTER     TO WS-NON-CONS-ARRS-HOLD         
                ELSE                                                    
                   IF CZ-ARREARS-HIST(WS-COUNTER:1) = '1'               
                      IF PREV-ARRS-FOUND                                
                         MOVE 'Y'      TO WS-2ND-PREV-ARRS-SW           
                      ELSE                                              
                         MOVE  'Y'     TO WS-PREV-ARRS-SW               
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
           END-PERFORM.                                                 
      *                                                                         
           IF NON-CONS-ARRS-NOT-FOUND                                   
              COMPUTE WS-NON-CONS-ARRS-HOLD = WS-LIMIT-MONTH + 1        
           END-IF.                                                      
      *                                                                 07784403
       6300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6565-PROCESS-CREDIT-RULE.                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00334                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                 07942004
      ******************************************************************23080000
      * 7000-SEL-DELINQUENCY.                                          *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7000-SEL-DELINQUENCY.                                            
      *                                                                 23140000
           MOVE '7000'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT                                                    
                     DELINQ_VALUE                                       
                INTO                                                    
                     :C8-DELINQ-VALUE                                   
                FROM                                                    
                     CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE                                                    
                     DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              DELINQ_VALUE                                               
MFA-TR*         INTO                                                            
MFA-TR*              :C8-DELINQ-VALUE                                           
MFA-TR*         FROM                                                            
MFA-TR*              CSS_DELINQUENCY                                            
MFA-TR*        WHERE                                                            
MFA-TR*              DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************23080000
      * 7100-SEL-ACCOUNT.                                              *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7100-SEL-ACCOUNT.                                                
      *                                                                 23140000
           MOVE '7100'              TO ACTIVE-PARAGRAPH.                
           MOVE 0                   TO WS-NULL-DATE.                    
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT                                                    
                     AT.ACCOUNT_TYPE_CODE                               
                    ,AT.COMPANY_NO                                      
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.MAX_DEP_REF_XMT_CD                              
                INTO                                                    
                     :AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-COMPANY-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-DATE-BILL-DAY-00 :WS-NULL-DATE                  
                    ,:AT-MAX-DEP-REF-XMT-CD                             
                FROM                                                    
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE                                                    
                     AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.MAX_DEP_REF_XMT_CD                                      
MFA-TR*         INTO                                                            
MFA-TR*              :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-NULL-DATE                          
MFA-TR*             ,:AT-MAX-DEP-REF-XMT-CD                                     
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE                                                            
MFA-TR*              AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              IF WS-NULL-DATE = SUCCESSFUL-CALL                         
                 MOVE AT-DATE-BILL-DAY-00 TO WS-LAST-BILL-DATE          
              ELSE                                                      
                 MOVE WS-CURRENT-DATE     TO WS-LAST-BILL-DATE          
              END-IF                                                    
              MOVE AT-REV-MTH-LST-NRML    TO WS-REV-MTH-HOLD            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7200-CHECK-GF-DEPOSIT.                                         *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7200-CHECK-GF-DEPOSIT.                                           
      *                                                                 23140000
           MOVE '7200'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO                                                    
                     :WS-GF-DEPOSIT                                     
                FROM                                                    
                     CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     DO.ACCOUNT_NO = :DO-ACCOUNT-NO                     
                 AND DO.DEPOSIT_STATUS_CD IN ('A','P')                  
                 AND DO.DATE_TRAN <= IIF(TRY_CONVERT(DATE, :DO-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-TRAN
              ) <> 0) OR (LEN(:DO-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :DO-DATE-TRAN
              ), CONVERT(DATE, :DO-DATE-TRAN) )                      
               ORDER BY DO.DATE_TRAN                                    
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              'Y'                                                        
MFA-TR*         INTO                                                            
MFA-TR*              :WS-GF-DEPOSIT                                             
MFA-TR*         FROM                                                            
MFA-TR*              CSS_DEP_ON_HAND DO                                         
MFA-TR*        WHERE                                                            
MFA-TR*              DO.ACCOUNT_NO = :DO-ACCOUNT-NO                             
MFA-TR*          AND DO.DEPOSIT_STATUS_CD IN ('A','P')                          
MFA-TR*          AND DO.DATE_TRAN <= :DO-DATE-TRAN                              
MFA-TR*        ORDER BY DO.DATE_TRAN                                            
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'DATE_TRAN'           TO TABLE-ELEMENT-2            
               MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE DO-DATE-TRAN          TO HOSTVAR-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07942004
      ******************************************************************23080000
      * 7300-SEL-DEP-DETAILS.                                          *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7300-SEL-DEP-DETAILS.                                            
      *                                                                 23140000
           MOVE '7300'              TO ACTIVE-PARAGRAPH.                
           MOVE 0                   TO WS-NULL-DATE.                    
      *                                                                 23140000
           EXEC SQL                                                     
               SELECT                                                   
                      DATE_CERT_ISSUE                                   
                 INTO                                                   
                      :DO-DATE-CERT-ISSUE :WS-NULL-DATE                  
                 FROM                                                   
                      CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                  
                WHERE                                                   
                      DO.ACCOUNT_NO      = :DO-ACCOUNT-NO               
                  AND DO.DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23150000
MFA-TR*        SELECT                                                   23160000
MFA-TR*               DATE_CERT_ISSUE                                           
MFA-TR*          INTO                                                   23170000
MFA-TR*               :DO-DATE-CERT-ISSUE:WS-NULL-DATE                  23170000
MFA-TR*          FROM                                                   23180000
MFA-TR*               CSS_DEP_ON_HAND DO                                23180000
MFA-TR*         WHERE                                                   23190000
MFA-TR*               DO.ACCOUNT_NO      = :DO-ACCOUNT-NO               23190000
MFA-TR*           AND DO.DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO          23190000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 23240000
           IF WS-NULL-DATE = WS-NULL-VALUE                              
              MOVE SPACE                 TO DO-DATE-CERT-ISSUE          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE 'DEPOSIT_CERT_NO'   TO TABLE-ELEMENT-2            
                 MOVE DO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 MOVE DO-DEPOSIT-CERT-NO  TO HOSTVAR-ELEMENT-2          
                 PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                 23440000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7400-SET-PROJ-RFND-DATE.                                       *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7400-SET-PROJ-RFND-DATE.                                         
      *                                                                 23140000
           MOVE '7400'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, (:WS-LIMIT-MONTH + :WS-CALC), (DATEADD( 
              MONTH, -:WS-MONTHS-SQL, IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) ) )) )
            INTO
              :WS-PROJ-RFND-DATE                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     23150000
MFA-TR*       SET :WS-PROJ-RFND-DATE =                                          
MFA-TR*           (DATE(:WS-LAST-BILL-DATE) - :WS-MONTHS-SQL MONTHS) +          
MFA-TR*           (:WS-LIMIT-MONTH + :WS-CALC) MONTHS                           
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'WS-LAST-BILL-DATE'    TO TABLE-ELEMENT-1            
              MOVE 'WS-MONTHS-SQL'        TO TABLE-ELEMENT-2            
              MOVE 'WS-LIMIT-MONTH'       TO TABLE-ELEMENT-3            
              MOVE 'WS-CALC'              TO TABLE-ELEMENT-4            
              MOVE WS-LAST-BILL-DATE      TO HOSTVAR-ELEMENT-1          
              MOVE WS-MONTHS-SQL          TO HOSTVAR-ELEMENT-2          
              MOVE WS-LIMIT-MONTH         TO HOSTVAR-ELEMENT-3          
              MOVE WS-CALC                TO HOSTVAR-ELEMENT-4          
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7410-ADD-1-MONTH.                                              *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7410-ADD-1-MONTH.                                                
      *                                                                 23140000
           MOVE '7410'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                     :WS-PROJ-RFND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROJ-RFND-DATE
              ) <> 0) OR (LEN(:WS-PROJ-RFND-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PROJ-RFND-DATE
              ), CONVERT(DATE, :WS-PROJ-RFND-DATE) ) )
            INTO
              :WS-PROJ-RFND-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     23150000
MFA-TR*       SET :WS-PROJ-RFND-DATE =                                          
MFA-TR*           DATE(:WS-PROJ-RFND-DATE) + 1 MONTH                            
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'WS-PROJ-RFND-DATE'    TO TABLE-ELEMENT-1            
              MOVE WS-PROJ-RFND-DATE      TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7420-CALC-DATE-FROM-PMT.                                       *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7420-CALC-DATE-FROM-PMT.                                         
      *                                                                 23140000
           MOVE '7420'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, (:WS-LIMIT-MONTH + 1), 
              IIF(TRY_CONVERT(DATE, :WS-DEP-PAID-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DEP-PAID-DATE
              ) <> 0) OR (LEN(:WS-DEP-PAID-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-DEP-PAID-DATE
              ), CONVERT(DATE, :WS-DEP-PAID-DATE) ) )
            INTO
              :WS-CALC-DT-FROM-PMT                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     23150000
MFA-TR*       SET  :WS-CALC-DT-FROM-PMT =                                       
MFA-TR*             DATE(:WS-DEP-PAID-DATE) +                                   
MFA-TR*             (:WS-LIMIT-MONTH + 1) MONTHS                                
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'WS-PROJ-RFND-DATE'    TO TABLE-ELEMENT-1            
              MOVE 'WS-LIMIT-MONTH'       TO TABLE-ELEMENT-2            
              MOVE WS-PROJ-RFND-DATE      TO HOSTVAR-ELEMENT-1          
              MOVE WS-LIMIT-MONTH         TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7430-CALC-DATE-FROM-PMT.                                       *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7430-GET-CURRENT-DATE.                                           
      *                                                                 23140000
           MOVE '7430'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     23150000
MFA-TR*       SET  :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                    23200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************23080000
      * 7500-GET-CRED-PROFILE.                                         *23090000
      ******************************************************************23120000
      *                                                                 07942004
       7500-GET-CRED-PROFILE.                                           
      *                                                                 23140000
           MOVE '7500'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT                                                    
                      CZ.ARREARS_HIST                                   
                     ,CZ.DISCONNECT_HIST                                
                     ,CZ.DISC_EXCEPTN_HIST                              
                INTO  :CZ-ARREARS-HIST                                  
                     ,:CZ-DISCONNECT-HIST                               
                     ,:CZ-DISC-EXCEPTN-HIST                             
                FROM                                                    
                     CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
               WHERE                                                    
                     CZ.ACCOUNT_NO  = :CZ-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42345700
MFA-TR*       SELECT                                                    42345800
MFA-TR*               CZ.ARREARS_HIST                                   42345800
MFA-TR*              ,CZ.DISCONNECT_HIST                                        
MFA-TR*              ,CZ.DISC_EXCEPTN_HIST                                      
MFA-TR*         INTO  :CZ-ARREARS-HIST                                  42345900
MFA-TR*              ,:CZ-DISCONNECT-HIST                                       
MFA-TR*              ,:CZ-DISC-EXCEPTN-HIST                                     
MFA-TR*         FROM                                                    42346000
MFA-TR*              CSS_CREDIT_PROFILE CZ                              42346000
MFA-TR*        WHERE                                                    42346100
MFA-TR*              CZ.ACCOUNT_NO  = :CZ-ACCOUNT-NO                    42346100
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                    42346200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23210000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                 23440000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
      ******************************************************************        
      * 7600-SEL-MAX-DEP-REVIEW                                                 
      ******************************************************************        
      *                                                                         
       7600-SEL-MAX-DEP-REVIEW.                                         
      *                                                                         
           MOVE '7600'              TO ACTIVE-PARAGRAPH.                
      *                                                                 23140000
           EXEC SQL                                                     
              SELECT                                                    
                      MG.LAST_MAX_AT_REV_DT                             
                     ,MG.MAX_DEP_AT_REV_AM                              
                     ,MG.PD_DEP_AT_REV_AM                               
                     ,MG.MAX_DEP_REFUND_CD                              
                INTO                                                    
                      :MG-LAST-MAX-AT-REV-DT :WS-NULL-REVIEW-DT          
                     ,:MG-MAX-DEP-AT-REV-AM                             
                     ,:MG-PD-DEP-AT-REV-AM                              
                     ,:MG-MAX-DEP-REFUND-CD                             
               FROM                                                     
                      CSS_MAX_DEP_REVIEW MG WITH(READUNCOMMITTED)               
              WHERE                                                     
                     MG.ACCOUNT_NO = :MG-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               MG.LAST_MAX_AT_REV_DT                                     
MFA-TR*              ,MG.MAX_DEP_AT_REV_AM                                      
MFA-TR*              ,MG.PD_DEP_AT_REV_AM                                       
MFA-TR*              ,MG.MAX_DEP_REFUND_CD                                      
MFA-TR*         INTO                                                            
MFA-TR*               :MG-LAST-MAX-AT-REV-DT:WS-NULL-REVIEW-DT                  
MFA-TR*              ,:MG-MAX-DEP-AT-REV-AM                                     
MFA-TR*              ,:MG-PD-DEP-AT-REV-AM                                      
MFA-TR*              ,:MG-MAX-DEP-REFUND-CD                                     
MFA-TR*        FROM                                                             
MFA-TR*               CSS_MAX_DEP_REVIEW MG                                     
MFA-TR*       WHERE                                                             
MFA-TR*              MG.ACCOUNT_NO = :MG-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 23240000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               IF  WS-NULL-REVIEW-DT  = WS-NULL-VALUE                   
                   MOVE ZEROES                 TO MG-LAST-MAX-AT-REV-DT 
               END-IF                                                   
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES             TO   MG-LAST-MAX-AT-REV-DT    
                                               MG-MAX-DEP-REFUND-CD     
                  MOVE ZEROES             TO   MG-MAX-DEP-AT-REV-AM     
                                               MG-PD-DEP-AT-REV-AM      
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_MAX_DEP_REVIEW'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE MG-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************13871306
      *7610-SEL-BILL-CYCLE                                              13871459
      ******************************************************************13871506
      *                                                                         
       7610-SEL-BILL-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT  BILL_CYCLE                                       
                      ,COMPANY_NO                                       
                 INTO  :AT-BILL-CYCLE                                   
                      ,:AT-COMPANY-NO                                   
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7610'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
           END-IF.                                                      
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8001-DELETE-GTT-ROWS.                                            13871459
      ******************************************************************13871506
      *                                                                         
       8001-DELETE-GTT-ROWS.                                            
      *                                                                 13871706
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
            MOVE '8001'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13871906
            EXEC SQL                                                    
                DELETE FROM #CSR04610_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13872006
MFA-TR*         DELETE FROM SESSION.CSR04610_R1                         13872159
MFA-TR*     END-EXEC.                                                   13872206

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13872306
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 13872606
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04610_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
            END-IF.                                                     
      *                                                                 13874306
       8001-EXIT.                                                       
            EXIT.                                                       
      *                                                                 13880859
      ******************************************************************13880959
      *8002-DELETE-GTT-ROWS.                                            13874859
      ******************************************************************13874959
       8002-DELETE-GTT-ROWS.                                            
      *                                                                 13875159
            MOVE '8002'                   TO ACTIVE-PARAGRAPH.          
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                 13875359
            EXEC SQL                                                    
                DELETE FROM #CSR04610_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13875459
MFA-TR*         DELETE FROM SESSION.CSR04610_R2                         13875559
MFA-TR*     END-EXEC.                                                   13875659

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13875759
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 13875959
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04610_R2'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
            END-IF.                                                     
      *                                                                 13877459
       8002-EXIT.                                                       
            EXIT.                                                       
      *                                                                 13877759
      ******************************************************************13877859
      *8003-DELETE-GTT-ROWS.                                            13881059
      ******************************************************************13881159
       8003-DELETE-GTT-ROWS.                                            
      *                                                                 13881359
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
            MOVE '8003'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13881559
            EXEC SQL                                                    
                DELETE FROM #CSR04610_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13881659
MFA-TR*         DELETE FROM SESSION.CSR04610_R3                         13881759
MFA-TR*     END-EXEC.                                                   13881859

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13881959
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 13882159
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04610_R3'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
            END-IF.                                                     
      *                                                                 13883659
       8003-EXIT.                                                       
            EXIT.                                                       
      *                                                                 13883959
      ******************************************************************13884059
      *8004-DELETE-GTT-ROWS.                                            13884159
      ******************************************************************13884259
       8004-DELETE-GTT-ROWS.                                            
      *                                                                 13884459
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
            MOVE '8004'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13884659
            EXEC SQL                                                    
                DELETE FROM #CSR04610_R4                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13884759
MFA-TR*         DELETE FROM SESSION.CSR04610_R4                         13884859
MFA-TR*     END-EXEC.                                                   13884959

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13885059
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 13885259
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04610_R4'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
            END-IF.                                                     
      *                                                                 13886759
       8004-EXIT.                                                       
            EXIT.                                                       
      *                                                                 13883959
      ******************************************************************13884059
      *8005-DELETE-GTT-ROWS.                                            13884159
      ******************************************************************13884259
       8005-DELETE-GTT-ROWS.                                            
      *                                                                 13884459
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
            MOVE '8005'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13884659
            EXEC SQL                                                    
                DELETE FROM #CSR04610_R5                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13884759
MFA-TR*         DELETE FROM SESSION.CSR04610_R5                         13884859
MFA-TR*     END-EXEC.                                                   13884959

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13885059
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 13885259
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04610_R5'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT               
            END-IF.                                                     
      *                                                                 13886759
       8005-EXIT.                                                       
            EXIT.                                                       
      *                                                                 13891059
      ******************************************************************13894306
      *8100-SEND-RESULT-1                                               13894459
      ******************************************************************13894506
      *                                                                 13894606
       8100-SEND-RESULT-1.                                              
      *                                                                 13894806
            MOVE '8100'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13884659
            EXEC SQL                                                    
                 INSERT INTO #CSR04610_R1                        
                 (                                                      
                   MIN_DEPOSIT_AMT                                      
                  ,MAX_DEPOSIT_AMT                                      
                  ,USAGE_HISTORY_FLAG                                   
                  ,DEP_EXISTS_FLAG                                      
                  ,DELQ_DEP_NTFY_LTR                                    
                  ,DEP_ACTION_CODE                                      
                  ,DEPOSIT_STATUS_CD                                    
                  ,DATE_TRAN                                            
                  ,SERVICE_TYPE_CD                                      
                  ,DEPOSIT_CERT_NO                                      
                  ,AMT_ORIG_ENTERED                                     
                  ,BILL_OPTION_CD                                       
                  ,BILLED_FLAG                                          
                  ,AMT_PAID                                             
                  ,COMMENTS                                             
                  ,CODE_DEP_TYPE                                        
                  ,NO_SCHED_PYMTS                                       
                  ,AMT_MO_PYMT                                          
                  ,BILL_COUNT                                           
                  ,USER_ID_UPDT_BY                                      
                  ,DATE_PYMT_START                                      
                  ,OLD_BILL_DATE                                        
                  ,[2ND_OLD_BILL_DATE]                                    
                  ,NEXT_BILLING_DATE                                    
                  ,[2ND_NEXT_BILL_DATE]                                   
                  ,LAST_BILL_DATE                                       
                  ,MST_SUB_ACCT_IND                                     
                  ,DELINQUENCY_VALUE                                    
                  ,DEP_DNP_LIMIT                                        
                  ,REBILLED_DEP_AMT                                     
                  ,REBILLED_DEP_DATE                                    
                  ,IMME_DUE_DATE                                        
                  ,IMME_CUT_DATE                                        
                  ,CODE_DISC_OK                                         
                  ,CREDIT_GROUP                                         
                  ,NOT_CURR_MTH_FLAG                                    
                  ,RETURN_CODE                                          
                  ,AT_LAST_UPDATE_TS                                    
                  ,DATE_FIRST_NOTICE                                    
                  ,INSTLMNT_STRT_DATE                                   
                  ,NEXT_BILL_DATE                                       
                  ,NEXT_DUE_DATE                                        
                  ,IMMED_DUE_DATE                                       
                  ,DATE_FIRST_DUE                                       
                  ,DATE_SECOND_DUE                                      
                  ,CURRENT_BILL_DUE                                     
                  ,ORIG_IMMED_DUE                                       
                  ,CUR_IMMED_DUE                                        
                  ,DT_FST_NTCE_OLD                                      
                  ,CUT_DATE                                             
                  ,FINAL_INSTLMNT_AMT                                   
                  ,CODE_REFUND_ELIG                                     
                  ,AGENCY_TEXT                                          
                  ,AUTODEP_LTR_DT                                       
                  ,AUTODEP_LTR_IND                                      
                  ,DATE_CERT_ISSUE                                      
                  ,PROJECTED_CR_DT                                      
                   )                                                    
               VALUES                                                   
                   (                                                    
                   :S-MIN-DEPOSIT-AMT                                   
                  ,:S-MAX-DEPOSIT-AMT-1                                 
                  ,:S-USAGE-HISTORY-FLAG                                
                  ,:S-DEP-EXISTS-FLAG                                   
                  ,:S-DELQ-DEP-NTFY-LTR                                 
                  ,:S-DEP-ACTION-CODE                                   
                  ,:S-DEPOSIT-STATUS-CD                                 
                  ,:S-DATE-TRAN                                         
                  ,:S-SERVICE-TYPE-CD                                   
                  ,:S-DEPOSIT-CERT-NO                                   
                  ,:S-AMT-ORIG-ENTERED-1                                
                  ,:S-BILL-OPTION-CD                                    
                  ,:S-BILLED-FLAG                                       
                  ,:S-AMT-PAID                                          
                  ,:S-COMMENT                                           
                  ,:S-CODE-DEP-TYPE                                     
                  ,:S-NO-SCHED-PYMTS                                    
                  ,:S-AMT-MO-PYMT                                       
                  ,:S-BILL-COUNT                                        
                  ,:S-USER-ID-UPDT-BY                                   
                  ,:S-DATE-PYMT-START                                   
                  ,:S-OLD-BILL-DATE                                     
                  ,:S-2ND-OLD-BILL-DATE                                 
                  ,:S-NEXT-BILLING-DATE                                 
                  ,:S-2ND-NEXT-BILL-DATE                                
                  ,:S-LAST-BILL-DATE                                    
                  ,:S-MST-SUB-ACCT-IND                                  
                  ,:S-DELINQUENCY-VALUE                                 
                  ,:S-DEP-DNP-LIMIT                                     
                  ,:S-REBILLED-DEP-AMT                                  
                  ,:S-REBILLED-DEP-DATE                                 
                  ,:S-IMME-DUE-DATE                                     
                  ,:S-IMME-CUT-DATE                                     
                  ,:S-CODE-DISC-OK                                      
                  ,:S-CREDIT-GROUP                                      
                  ,:S-NOT-CURR-MTH-FLAG                                 
                  ,:S-RETURN-CODE-1                                     
                  ,:S-AT-LAST-UPDATE-TS                                 
                  ,:S-DATE-FIRST-NOTICE                                 
                  ,:S-INSTLMNT-STRT-DATE                                
                  ,:S-NEXT-BILL-DATE                                    
                  ,:S-NEXT-DUE-DATE                                     
                  ,:S-IMMED-DUE-DATE                                    
                  ,:S-DATE-FIRST-DUE                                    
                  ,:S-DATE-SECOND-DUE                                   
                  ,:S-CURRENT-BILL-DUE                                  
                  ,:S-ORIG-IMMED-DUE                                    
                  ,:S-CUR-IMMED-DUE                                     
                  ,:S-DT-FST-NTCE-OLD                                   
                  ,:S-CUT-DATE                                          
                  ,:S-FINAL-INSTLMNT-AMT                                
                  ,:S-CODE-REFUND-ELIG                                  
                  ,:S-AGENCY-TEXT                                       
                  ,:S-AUTODEP-LTR-DT                                    
                  ,:S-AUTODEP-LTR-IND                                   
                  ,:S-DATE-CERT-ISSUE                                   
                  ,:S-PROJECTED-CR-DT                                   
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13894906
MFA-TR*          INSERT INTO SESSION.CSR04610_R1                        13895059
MFA-TR*          (                                                      13895106
MFA-TR*            MIN_DEPOSIT_AMT                                      13895107
MFA-TR*           ,MAX_DEPOSIT_AMT                                      13895108
MFA-TR*           ,USAGE_HISTORY_FLAG                                   13895109
MFA-TR*           ,DEP_EXISTS_FLAG                                      13895110
MFA-TR*           ,DELQ_DEP_NTFY_LTR                                    13895120
MFA-TR*           ,DEP_ACTION_CODE                                      13895130
MFA-TR*           ,DEPOSIT_STATUS_CD                                    13895140
MFA-TR*           ,DATE_TRAN                                            13895150
MFA-TR*           ,SERVICE_TYPE_CD                                      13895160
MFA-TR*           ,DEPOSIT_CERT_NO                                      13895170
MFA-TR*           ,AMT_ORIG_ENTERED                                     13895180
MFA-TR*           ,BILL_OPTION_CD                                       13895190
MFA-TR*           ,BILLED_FLAG                                          13895200
MFA-TR*           ,AMT_PAID                                             13895300
MFA-TR*           ,COMMENTS                                             13895400
MFA-TR*           ,CODE_DEP_TYPE                                        13895500
MFA-TR*           ,NO_SCHED_PYMTS                                       13895600
MFA-TR*           ,AMT_MO_PYMT                                          13895700
MFA-TR*           ,BILL_COUNT                                           13895800
MFA-TR*           ,USER_ID_UPDT_BY                                      13895900
MFA-TR*           ,DATE_PYMT_START                                      13896000
MFA-TR*           ,OLD_BILL_DATE                                        13896100
MFA-TR*           ,2ND_OLD_BILL_DATE                                    13896200
MFA-TR*           ,NEXT_BILLING_DATE                                    13896300
MFA-TR*           ,2ND_NEXT_BILL_DATE                                   13896400
MFA-TR*           ,LAST_BILL_DATE                                       13896500
MFA-TR*           ,MST_SUB_ACCT_IND                                     13896600
MFA-TR*           ,DELINQUENCY_VALUE                                    13896700
MFA-TR*           ,DEP_DNP_LIMIT                                        13896800
MFA-TR*           ,REBILLED_DEP_AMT                                     13896900
MFA-TR*           ,REBILLED_DEP_DATE                                    13897000
MFA-TR*           ,IMME_DUE_DATE                                        13897100
MFA-TR*           ,IMME_CUT_DATE                                        13897200
MFA-TR*           ,CODE_DISC_OK                                         13897300
MFA-TR*           ,CREDIT_GROUP                                         13897400
MFA-TR*           ,NOT_CURR_MTH_FLAG                                    13897500
MFA-TR*           ,RETURN_CODE                                          13897600
MFA-TR*           ,AT_LAST_UPDATE_TS                                    13897700
MFA-TR*           ,DATE_FIRST_NOTICE                                    13897800
MFA-TR*           ,INSTLMNT_STRT_DATE                                   13897900
MFA-TR*           ,NEXT_BILL_DATE                                       13898000
MFA-TR*           ,NEXT_DUE_DATE                                        13898100
MFA-TR*           ,IMMED_DUE_DATE                                       13898200
MFA-TR*           ,DATE_FIRST_DUE                                       13898300
MFA-TR*           ,DATE_SECOND_DUE                                      13898400
MFA-TR*           ,CURRENT_BILL_DUE                                     13898500
MFA-TR*           ,ORIG_IMMED_DUE                                       13898501
MFA-TR*           ,CUR_IMMED_DUE                                        13898502
MFA-TR*           ,DT_FST_NTCE_OLD                                      13898503
MFA-TR*           ,CUT_DATE                                             13898504
MFA-TR*           ,FINAL_INSTLMNT_AMT                                   13898505
MFA-TR*           ,CODE_REFUND_ELIG                                     13898506
MFA-TR*           ,AGENCY_TEXT                                          13898507
MFA-TR*           ,AUTODEP_LTR_DT                                       13898508
MFA-TR*           ,AUTODEP_LTR_IND                                      13898509
MFA-TR*           ,DATE_CERT_ISSUE                                              
MFA-TR*           ,PROJECTED_CR_DT                                              
MFA-TR*            )                                                    13898510
MFA-TR*        VALUES                                                   13898511
MFA-TR*            (                                                    13898512
MFA-TR*            :S-MIN-DEPOSIT-AMT                                   13898513
MFA-TR*           ,:S-MAX-DEPOSIT-AMT-1                                 13898514
MFA-TR*           ,:S-USAGE-HISTORY-FLAG                                13898515
MFA-TR*           ,:S-DEP-EXISTS-FLAG                                   13898516
MFA-TR*           ,:S-DELQ-DEP-NTFY-LTR                                 13898517
MFA-TR*           ,:S-DEP-ACTION-CODE                                   13898518
MFA-TR*           ,:S-DEPOSIT-STATUS-CD                                 13898519
MFA-TR*           ,:S-DATE-TRAN                                         13898520
MFA-TR*           ,:S-SERVICE-TYPE-CD                                   13898521
MFA-TR*           ,:S-DEPOSIT-CERT-NO                                   13898522
MFA-TR*           ,:S-AMT-ORIG-ENTERED-1                                13898523
MFA-TR*           ,:S-BILL-OPTION-CD                                    13898524
MFA-TR*           ,:S-BILLED-FLAG                                       13898525
MFA-TR*           ,:S-AMT-PAID                                          13898526
MFA-TR*           ,:S-COMMENT                                           13898527
MFA-TR*           ,:S-CODE-DEP-TYPE                                     13898528
MFA-TR*           ,:S-NO-SCHED-PYMTS                                    13898529
MFA-TR*           ,:S-AMT-MO-PYMT                                       13898530
MFA-TR*           ,:S-BILL-COUNT                                        13898531
MFA-TR*           ,:S-USER-ID-UPDT-BY                                   13898532
MFA-TR*           ,:S-DATE-PYMT-START                                   13898533
MFA-TR*           ,:S-OLD-BILL-DATE                                     13898534
MFA-TR*           ,:S-2ND-OLD-BILL-DATE                                 13898535
MFA-TR*           ,:S-NEXT-BILLING-DATE                                 13898536
MFA-TR*           ,:S-2ND-NEXT-BILL-DATE                                13898537
MFA-TR*           ,:S-LAST-BILL-DATE                                    13898538
MFA-TR*           ,:S-MST-SUB-ACCT-IND                                  13898539
MFA-TR*           ,:S-DELINQUENCY-VALUE                                 13898540
MFA-TR*           ,:S-DEP-DNP-LIMIT                                     13898541
MFA-TR*           ,:S-REBILLED-DEP-AMT                                  13898542
MFA-TR*           ,:S-REBILLED-DEP-DATE                                 13898543
MFA-TR*           ,:S-IMME-DUE-DATE                                     13898544
MFA-TR*           ,:S-IMME-CUT-DATE                                     13898545
MFA-TR*           ,:S-CODE-DISC-OK                                      13898546
MFA-TR*           ,:S-CREDIT-GROUP                                      13898547
MFA-TR*           ,:S-NOT-CURR-MTH-FLAG                                 13898548
MFA-TR*           ,:S-RETURN-CODE-1                                     13898549
MFA-TR*           ,:S-AT-LAST-UPDATE-TS                                 13898550
MFA-TR*           ,:S-DATE-FIRST-NOTICE                                 13898551
MFA-TR*           ,:S-INSTLMNT-STRT-DATE                                13898552
MFA-TR*           ,:S-NEXT-BILL-DATE                                    13898553
MFA-TR*           ,:S-NEXT-DUE-DATE                                     13898554
MFA-TR*           ,:S-IMMED-DUE-DATE                                    13898555
MFA-TR*           ,:S-DATE-FIRST-DUE                                    13898556
MFA-TR*           ,:S-DATE-SECOND-DUE                                   13898557
MFA-TR*           ,:S-CURRENT-BILL-DUE                                  13898558
MFA-TR*           ,:S-ORIG-IMMED-DUE                                    13898559
MFA-TR*           ,:S-CUR-IMMED-DUE                                     13898560
MFA-TR*           ,:S-DT-FST-NTCE-OLD                                   13898561
MFA-TR*           ,:S-CUT-DATE                                          13898562
MFA-TR*           ,:S-FINAL-INSTLMNT-AMT                                13898563
MFA-TR*           ,:S-CODE-REFUND-ELIG                                  13898564
MFA-TR*           ,:S-AGENCY-TEXT                                       13898565
MFA-TR*           ,:S-AUTODEP-LTR-DT                                    13898566
MFA-TR*           ,:S-AUTODEP-LTR-IND                                   13898567
MFA-TR*           ,:S-DATE-CERT-ISSUE                                           
MFA-TR*           ,:S-PROJECTED-CR-DT                                           
MFA-TR*          )                                                      13898570
MFA-TR*      END-EXEC.                                                  13898606

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13898706
             MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.   
      *                                                                 13899006
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                     TO  CTR-ROWS                 
             ELSE                                                       
                MOVE PROGRAM-NAME          TO  ABEND-PROGRAM            
                MOVE 'INSERT'              TO  ABEND-FUNCTION           
                MOVE SQLCODE               TO  ABEND-SQLCODE            
                MOVE SPACES                TO  ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04610_R1'         TO  TABLE-1                  
                MOVE SPACES                TO  TABLE-ELEMENT-1          
                MOVE SPACES                TO  HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT              
             END-IF.                                                    
      *                                                                 13900606
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                 13900906
      ******************************************************************13901059
      *8200-SEND-RESULT-2                                               13901159
      ******************************************************************13901259
      *                                                                 13901359
       8200-SEND-RESULT-2.                                              
      *                                                                 13901559
            MOVE '8200'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13884659
            EXEC SQL                                                    
                 INSERT INTO #CSR04610_R2                        
                 (                                                      
                     RETURN_CODE                                        
                    ,GRNT_ACCT_TYPE                                     
                    ,AMT_GUARANTEE                                      
                    ,GUAR_STATUS                                        
                    ,TRIGGER_DATE                                       
                    ,STATUS_REASON                                      
                    ,SERV_TYPE                                          
                    ,CONTRACT_ID                                        
                    ,CONTRACT_AMT                                       
                    ,CNT_NAME_ABBR                                      
                    ,SEND_NOTICE_FLAG                                   
                    ,SN_ADDR_FLAG                                       
                    ,GUAR_ACCT                                          
                    ,CREDIT_STATUS_CD                                   
                    ,ADDRESS_ID                                         
                    ,GUAR_ACCT_TYPE                                     
                    ,UPDATE_TS                                          
                    ,NAME_USAGE                                         
                    ,FULL_NAME                                          
                    ,TITLE                                              
                    ,FIRST_NAME                                         
                    ,MIDDLE_NAME                                        
                    ,LAST_NAME                                          
                    ,TITLE_SUFFIX1                                      
                    ,TITLE_SUFFIX2                                      
                    ,ADDR_USAGE                                         
                    ,FR_ADDR_STREET                                     
                    ,FO_HOUSE_NO                                        
                    ,FO_ADDR_PREFIX1                                    
                    ,FR_CITY_STATE                                      
                    ,FO_ADDR_PREFIX2                                    
                    ,FO_STREET_NAME                                     
                    ,FO_STREET_SUFFIX                                   
                    ,FO_ADDR_SUFFIX                                     
                    ,FR_ADDR_ZIP                                        
                    ,FO_STREET1                                         
                    ,FO_STREET2                                         
                    ,FR_COUNTRY                                         
                    ,FO_TOWN                                            
                    ,FO_STATE                                           
                    ,FO_ZIP_CODE                                        
                    ,FO_ZIP_PLUS                                        
                    ,FR_OVERFLOW                                        
                    ,FO_OVERFLOW                                        
                    ,FO_CARRIER_ROUTE                                   
                    ,HOME_PHONE                                         
                    ,WORK_PHONE                                         
                    ,PHONE_EXT                                          
                    ,LICENSE                                            
                    ,STATE_ID                                           
                    ,SSN                                                
                    ,SN_STREET                                          
                    ,SN_CITY_STATE                                      
                    ,SN_ZIP_CODE                                        
                    ,SN_COUNTRY                                         
                    ,SN_OVERFLOW                                        
                    ,WQ_ITEM_ID                                         
                    ,GUAR_ESTBLSH_DT                                    
                    ,MAX_DEPOSIT_AMT                                    
                    ,GUAR_CUST_NO                                       
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE-2                                   
                    ,:S-GRNT-ACCT-TYPE                                  
                    ,:S-AMT-GUARANTEE                                   
                    ,:S-CODE-GUAR-STATUS                                
                    ,:S-TRIGGER-DATE                                    
                    ,:S-STATUS-REASON                                   
                    ,:S-CODE-SERV-TYPE                                  
                    ,:S-CNT-ITEM-ID                                     
                    ,:S-AMT-ORIG-ENTERED-2                              
                    ,:S-CNT-NAME-ABBR                                   
                    ,:S-SEND-NOTICE-FLAG                                
                    ,:S-SN-ADDR-FLAG                                    
                    ,:S-GUAR-ACCT-NO                                    
                    ,:S-CREDIT-STATUS-CD                                
                    ,:S-ADDRESS-ID                                      
                    ,:S-GUAR-ACCT-TYPE                                  
                    ,:S-UPDATE-TS                                       
                    ,:S-NAME-USAGE                                      
                    ,:S-FULL-NAME                                       
                    ,:S-TITLE                                           
                    ,:S-FIRST-NAME                                      
                    ,:S-MIDDLE-NAME                                     
                    ,:S-LAST-NAME                                       
                    ,:S-TITLE-SUFFIX1                                   
                    ,:S-TITLE-SUFFIX2                                   
                    ,:S-ADDR-USAGE                                      
                    ,:S-ADDR-STREET                                     
                    ,:S-HOUSE-NO                                        
                    ,:S-ADDR-PREFIX1                                    
                    ,:S-ADDR-CITY-STATE                                 
                    ,:S-ADDR-PREFIX2                                    
                    ,:S-STREET-NAME                                     
                    ,:S-STREET-SUFFIX                                   
                    ,:S-ADDR-SUFFIX                                     
                    ,:S-ADDR-ZIP-CODE                                   
                    ,:S-STREET-LOCATION1                                
                    ,:S-STREET-LOCATION2                                
                    ,:S-ADDR-COUNTRY                                    
                    ,:S-TOWN                                            
                    ,:S-STATE                                           
                    ,:S-ZIP-CODE                                        
                    ,:S-ZIP-CODE-PLUS                                   
                    ,:S-ADDR-OVERFLOW                                   
                    ,:S-ADDR-OVERFLOW-FORM                              
                    ,:S-CARRIER-ROUTE                                   
                    ,:S-HOME-PHONE                                      
                    ,:S-WORK-PHONE                                      
                    ,:S-PHONE-EXT                                       
                    ,:S-DRIVER-LICENSE                                  
                    ,:S-CODE-STATE-ID                                   
                    ,:S-SSN                                             
                    ,:S-SN-STREET                                       
                    ,:S-SN-CITY-STATE                                   
                    ,:S-SN-ZIP-CODE                                     
                    ,:S-SN-COUNTRY                                      
                    ,:S-SN-OVERFLOW                                     
                    ,:S-WQ-ITEM-ID                                      
                    ,:S-GUAR-ESTBLSH-DT                                 
                    ,:S-MAX-DEPOSIT-AMT-2                               
                    ,:S-CUSTOMER-NO                                     
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13901659
MFA-TR*          INSERT INTO SESSION.CSR04610_R2                        13901759
MFA-TR*          (                                                      13901859
MFA-TR*              RETURN_CODE                                        13908360
MFA-TR*             ,GRNT_ACCT_TYPE                                     13908370
MFA-TR*             ,AMT_GUARANTEE                                      13908380
MFA-TR*             ,GUAR_STATUS                                        13908390
MFA-TR*             ,TRIGGER_DATE                                       13908400
MFA-TR*             ,STATUS_REASON                                      13908500
MFA-TR*             ,SERV_TYPE                                          13908600
MFA-TR*             ,CONTRACT_ID                                        13908700
MFA-TR*             ,CONTRACT_AMT                                       13908800
MFA-TR*             ,CNT_NAME_ABBR                                      13908900
MFA-TR*             ,SEND_NOTICE_FLAG                                   13909000
MFA-TR*             ,SN_ADDR_FLAG                                       13909100
MFA-TR*             ,GUAR_ACCT                                          13909200
MFA-TR*             ,CREDIT_STATUS_CD                                   13909300
MFA-TR*             ,ADDRESS_ID                                         13909400
MFA-TR*             ,GUAR_ACCT_TYPE                                     13909500
MFA-TR*             ,UPDATE_TS                                          13909600
MFA-TR*             ,NAME_USAGE                                         13909700
MFA-TR*             ,FULL_NAME                                          13909800
MFA-TR*             ,TITLE                                              13909900
MFA-TR*             ,FIRST_NAME                                         13909910
MFA-TR*             ,MIDDLE_NAME                                        13909920
MFA-TR*             ,LAST_NAME                                          13909930
MFA-TR*             ,TITLE_SUFFIX1                                      13909940
MFA-TR*             ,TITLE_SUFFIX2                                      13909950
MFA-TR*             ,ADDR_USAGE                                         13909951
MFA-TR*             ,FR_ADDR_STREET                                     13909952
MFA-TR*             ,FO_HOUSE_NO                                        13909953
MFA-TR*             ,FO_ADDR_PREFIX1                                    13909954
MFA-TR*             ,FR_CITY_STATE                                      13909955
MFA-TR*             ,FO_ADDR_PREFIX2                                    13909956
MFA-TR*             ,FO_STREET_NAME                                     13909957
MFA-TR*             ,FO_STREET_SUFFIX                                   13909958
MFA-TR*             ,FO_ADDR_SUFFIX                                     13909959
MFA-TR*             ,FR_ADDR_ZIP                                        13909960
MFA-TR*             ,FO_STREET1                                         13909961
MFA-TR*             ,FO_STREET2                                         13909962
MFA-TR*             ,FR_COUNTRY                                         13909963
MFA-TR*             ,FO_TOWN                                            13909964
MFA-TR*             ,FO_STATE                                           13909965
MFA-TR*             ,FO_ZIP_CODE                                        13909966
MFA-TR*             ,FO_ZIP_PLUS                                        13909967
MFA-TR*             ,FR_OVERFLOW                                        13909968
MFA-TR*             ,FO_OVERFLOW                                        13909969
MFA-TR*             ,FO_CARRIER_ROUTE                                   13909970
MFA-TR*             ,HOME_PHONE                                         13909971
MFA-TR*             ,WORK_PHONE                                         13909972
MFA-TR*             ,PHONE_EXT                                          13909973
MFA-TR*             ,LICENSE                                            13909974
MFA-TR*             ,STATE_ID                                           13909975
MFA-TR*             ,SSN                                                13909976
MFA-TR*             ,SN_STREET                                          13909977
MFA-TR*             ,SN_CITY_STATE                                      13909978
MFA-TR*             ,SN_ZIP_CODE                                        13909979
MFA-TR*             ,SN_COUNTRY                                         13909980
MFA-TR*             ,SN_OVERFLOW                                        13909981
MFA-TR*             ,WQ_ITEM_ID                                         13909982
MFA-TR*             ,GUAR_ESTBLSH_DT                                    13909983
MFA-TR*             ,MAX_DEPOSIT_AMT                                    13909984
MFA-TR*             ,GUAR_CUST_NO                                       13909985
MFA-TR*            )                                                    13909986
MFA-TR*        VALUES                                                   13909987
MFA-TR*            (                                                    13909988
MFA-TR*              :S-RETURN-CODE-2                                   13909989
MFA-TR*             ,:S-GRNT-ACCT-TYPE                                  13909990
MFA-TR*             ,:S-AMT-GUARANTEE                                   13909991
MFA-TR*             ,:S-CODE-GUAR-STATUS                                13909992
MFA-TR*             ,:S-TRIGGER-DATE                                    13909993
MFA-TR*             ,:S-STATUS-REASON                                   13909994
MFA-TR*             ,:S-CODE-SERV-TYPE                                  13909995
MFA-TR*             ,:S-CNT-ITEM-ID                                     13909996
MFA-TR*             ,:S-AMT-ORIG-ENTERED-2                              13909997
MFA-TR*             ,:S-CNT-NAME-ABBR                                   13909998
MFA-TR*             ,:S-SEND-NOTICE-FLAG                                13909999
MFA-TR*             ,:S-SN-ADDR-FLAG                                    13910000
MFA-TR*             ,:S-GUAR-ACCT-NO                                    13910001
MFA-TR*             ,:S-CREDIT-STATUS-CD                                13910002
MFA-TR*             ,:S-ADDRESS-ID                                      13910003
MFA-TR*             ,:S-GUAR-ACCT-TYPE                                  13910004
MFA-TR*             ,:S-UPDATE-TS                                       13910005
MFA-TR*             ,:S-NAME-USAGE                                      13910006
MFA-TR*             ,:S-FULL-NAME                                       13910007
MFA-TR*             ,:S-TITLE                                           13910008
MFA-TR*             ,:S-FIRST-NAME                                      13910009
MFA-TR*             ,:S-MIDDLE-NAME                                     13910010
MFA-TR*             ,:S-LAST-NAME                                       13910011
MFA-TR*             ,:S-TITLE-SUFFIX1                                   13910012
MFA-TR*             ,:S-TITLE-SUFFIX2                                   13910013
MFA-TR*             ,:S-ADDR-USAGE                                      13910014
MFA-TR*             ,:S-ADDR-STREET                                     13910015
MFA-TR*             ,:S-HOUSE-NO                                        13910016
MFA-TR*             ,:S-ADDR-PREFIX1                                    13910017
MFA-TR*             ,:S-ADDR-CITY-STATE                                 13910018
MFA-TR*             ,:S-ADDR-PREFIX2                                    13910019
MFA-TR*             ,:S-STREET-NAME                                     13910020
MFA-TR*             ,:S-STREET-SUFFIX                                   13910021
MFA-TR*             ,:S-ADDR-SUFFIX                                     13910022
MFA-TR*             ,:S-ADDR-ZIP-CODE                                   13910023
MFA-TR*             ,:S-STREET-LOCATION1                                13910024
MFA-TR*             ,:S-STREET-LOCATION2                                13910025
MFA-TR*             ,:S-ADDR-COUNTRY                                    13910026
MFA-TR*             ,:S-TOWN                                            13910027
MFA-TR*             ,:S-STATE                                           13910028
MFA-TR*             ,:S-ZIP-CODE                                        13910029
MFA-TR*             ,:S-ZIP-CODE-PLUS                                   13910030
MFA-TR*             ,:S-ADDR-OVERFLOW                                   13910031
MFA-TR*             ,:S-ADDR-OVERFLOW-FORM                              13910032
MFA-TR*             ,:S-CARRIER-ROUTE                                   13910033
MFA-TR*             ,:S-HOME-PHONE                                      13910034
MFA-TR*             ,:S-WORK-PHONE                                      13910035
MFA-TR*             ,:S-PHONE-EXT                                       13910036
MFA-TR*             ,:S-DRIVER-LICENSE                                  13910037
MFA-TR*             ,:S-CODE-STATE-ID                                   13910038
MFA-TR*             ,:S-SSN                                             13910039
MFA-TR*             ,:S-SN-STREET                                       13910040
MFA-TR*             ,:S-SN-CITY-STATE                                   13910041
MFA-TR*             ,:S-SN-ZIP-CODE                                     13910042
MFA-TR*             ,:S-SN-COUNTRY                                      13910043
MFA-TR*             ,:S-SN-OVERFLOW                                     13910044
MFA-TR*             ,:S-WQ-ITEM-ID                                      13910045
MFA-TR*             ,:S-GUAR-ESTBLSH-DT                                 13910046
MFA-TR*             ,:S-MAX-DEPOSIT-AMT-2                               13910047
MFA-TR*             ,:S-CUSTOMER-NO                                     13910048
MFA-TR*          )                                                      13903459
MFA-TR*      END-EXEC.                                                  13905359

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13905459
             MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.   
      *                                                                 13905659
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                     TO  CTR-ROWS                 
             ELSE                                                       
                MOVE PROGRAM-NAME          TO  ABEND-PROGRAM            
                MOVE 'INSERT'              TO  ABEND-FUNCTION           
                MOVE SQLCODE               TO  ABEND-SQLCODE            
                MOVE SPACES                TO  ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04610_R2'         TO  TABLE-1                  
                MOVE SPACES                TO  TABLE-ELEMENT-1          
                MOVE SPACES                TO  HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT              
             END-IF.                                                    
      *                                                                 13907159
        8200-EXIT.                                                      
            EXIT.                                                       
      *                                                                 13907459
      ******************************************************************13907559
      *8300-SEND-RESULT-3                                               13907659
      ******************************************************************13907759
      *                                                                 13907859
       8300-SEND-RESULT-3.                                              
      *                                                                 13908059
            MOVE '8300'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13908059
            EXEC SQL                                                    
                 INSERT INTO #CSR04610_R3                        
                 (                                                      
                      RETURN_CODE                                       
                     ,WAIVER_TYPE_CD                                    
                     ,CODE_STATUS                                       
                     ,COMMENTS                                          
                     ,CODE_STATUS_REAS                                  
                     ,WAIVER_SOURCE_DESC                                
                     ,TRIGGER_DATE                                      
                     ,BOND_ITEM_ID                                      
                     ,SSN_NUMBER                                        
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE-3                                  
                     ,:S-WAIVER-TYPE-CD-3                               
                     ,:S-CODE-STATUS-3                                  
                     ,:S-COMMENTS-3                                     
                     ,:S-CODE-STATUS-REAS-3                             
                     ,:S-WAIVER-SOURCE-DESC-3                           
                     ,:S-TRIGGER-DATE-3                                 
                     ,:S-BOND-ITEM-ID-3                                 
                     ,:S-SSN-NUMBER-3                                   
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13908159
MFA-TR*          INSERT INTO SESSION.CSR04610_R3                        13908259
MFA-TR*          (                                                      13908359
MFA-TR*               RETURN_CODE                                       13913060
MFA-TR*              ,WAIVER_TYPE_CD                                    13913070
MFA-TR*              ,CODE_STATUS                                       13913080
MFA-TR*              ,COMMENTS                                          13913090
MFA-TR*              ,CODE_STATUS_REAS                                  13913100
MFA-TR*              ,WAIVER_SOURCE_DESC                                13913110
MFA-TR*              ,TRIGGER_DATE                                      13913120
MFA-TR*              ,BOND_ITEM_ID                                      13913130
MFA-TR*              ,SSN_NUMBER                                        13913140
MFA-TR*          )                                                      13909059
MFA-TR*          VALUES                                                 13909159
MFA-TR*          (                                                      13909259
MFA-TR*               :S-RETURN-CODE-3                                  13914060
MFA-TR*              ,:S-WAIVER-TYPE-CD-3                               13914070
MFA-TR*              ,:S-CODE-STATUS-3                                  13914080
MFA-TR*              ,:S-COMMENTS-3                                     13914090
MFA-TR*              ,:S-CODE-STATUS-REAS-3                             13914100
MFA-TR*              ,:S-WAIVER-SOURCE-DESC-3                           13914200
MFA-TR*              ,:S-TRIGGER-DATE-3                                 13914300
MFA-TR*              ,:S-BOND-ITEM-ID-3                                 13914400
MFA-TR*              ,:S-SSN-NUMBER-3                                   13914500
MFA-TR*          )                                                      13910050
MFA-TR*      END-EXEC.                                                  13910059

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13910159
             MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE.   
      *                                                                 13910359
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                     TO  CTR-ROWS                 
             ELSE                                                       
                MOVE PROGRAM-NAME          TO  ABEND-PROGRAM            
                MOVE 'INSERT'              TO  ABEND-FUNCTION           
                MOVE SQLCODE               TO  ABEND-SQLCODE            
                MOVE SPACES                TO  ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                MOVE 'CSR04610_R3'         TO  TABLE-1                  
                MOVE SPACES                TO  TABLE-ELEMENT-1          
                MOVE SPACES                TO  HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT              
             END-IF.                                                    
      *                                                                 13911859
        8300-EXIT.                                                      
            EXIT.                                                       
      *                                                                 13917059
      *                                                                 13921959
      ******************************************************************13917159
      *8400-SEND-RESULT-4                                               13917259
      ******************************************************************13917359
      *                                                                 13917459
       8400-SEND-RESULT-4.                                              
      *                                                                 13917659
            MOVE '8400'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13908059
            EXEC SQL                                                    
                 INSERT INTO #CSR04610_R4                        
               (                                                        
                    RETURN_CODE                                         
                   ,ACCOUNT_NO                                          
                   ,CODE_BOND_TYPE                                      
                   ,AMT_BOND                                            
                   ,WAIV_ITEM_ID                                        
                   ,BOND_CO_NO                                          
                   ,CODE_STATUS                                         
                   ,TRIGGER_DATE                                        
                   ,CODE_STATUS_REAS                                    
                   ,ORIGINATED_BY                                       
                   ,BOND_NO                                             
                   ,BOND_TOTAL_AMT                                      
                   ,ISSUE_DATE                                          
                   ,EXPIRATION_DATE                                     
                   ,NAME                                                
                   ,ADDRESS                                             
                   ,CODE_ACCT_STAT                                      
                   ,MIN_DEPOSIT_AMT                                     
                   ,MAX_DEPOSIT_AMT                                     
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-4                                    
                   ,:S-ACCOUNT-NO-4                                     
                   ,:S-CODE-BOND-TYPE-4                                 
                   ,:S-AMT-BOND-4                                       
                   ,:S-WAIV-ITEM-ID-4                                   
                   ,:S-BOND-CO-NO-4                                     
                   ,:S-CODE-STATUS-4                                    
                   ,:S-TRIGGER-DATE-4                                   
                   ,:S-CODE-STATUS-REAS-4                               
                   ,:S-ORIGINATED-BY-4                                  
                   ,:S-BOND-NO-4                                        
                   ,:S-BOND-TOTAL-AMT-4                                 
                   ,:S-ISSUE-DATE-4                                     
                   ,:S-EXPIRATION-DATE-4                                
                   ,:S-NAME-4                                           
                   ,:S-ADDRESS-4                                        
                   ,:S-CODE-ACCT-STAT-4                                 
                   ,:S-MIN-DEP-AMT-4                                    
                   ,:S-MAX-DEP-AMT-4                                    
                )                                                       
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13917759
MFA-TR*          INSERT INTO SESSION.CSR04610_R4                        13917859
MFA-TR*        (                                                        13917860
MFA-TR*             RETURN_CODE                                         13917870
MFA-TR*            ,ACCOUNT_NO                                          13917880
MFA-TR*            ,CODE_BOND_TYPE                                      13917881
MFA-TR*            ,AMT_BOND                                            13917890
MFA-TR*            ,WAIV_ITEM_ID                                        13917900
MFA-TR*            ,BOND_CO_NO                                          13918000
MFA-TR*            ,CODE_STATUS                                         13918100
MFA-TR*            ,TRIGGER_DATE                                        13918200
MFA-TR*            ,CODE_STATUS_REAS                                    13918300
MFA-TR*            ,ORIGINATED_BY                                       13918400
MFA-TR*            ,BOND_NO                                             13918500
MFA-TR*            ,BOND_TOTAL_AMT                                      13918600
MFA-TR*            ,ISSUE_DATE                                          13918700
MFA-TR*            ,EXPIRATION_DATE                                     13918800
MFA-TR*            ,NAME                                                13918900
MFA-TR*            ,ADDRESS                                             13919000
MFA-TR*            ,CODE_ACCT_STAT                                      13919100
MFA-TR*            ,MIN_DEPOSIT_AMT                                     13919100
MFA-TR*            ,MAX_DEPOSIT_AMT                                     13919100
MFA-TR*         )                                                       13919200
MFA-TR*         VALUES                                                  13919300
MFA-TR*         (                                                       13919400
MFA-TR*             :S-RETURN-CODE-4                                    13919500
MFA-TR*            ,:S-ACCOUNT-NO-4                                     13919600
MFA-TR*            ,:S-CODE-BOND-TYPE-4                                 13919700
MFA-TR*            ,:S-AMT-BOND-4                                       13919710
MFA-TR*            ,:S-WAIV-ITEM-ID-4                                   13919800
MFA-TR*            ,:S-BOND-CO-NO-4                                     13919810
MFA-TR*            ,:S-CODE-STATUS-4                                    13919820
MFA-TR*            ,:S-TRIGGER-DATE-4                                   13919830
MFA-TR*            ,:S-CODE-STATUS-REAS-4                               13919840
MFA-TR*            ,:S-ORIGINATED-BY-4                                  13919850
MFA-TR*            ,:S-BOND-NO-4                                        13919851
MFA-TR*            ,:S-BOND-TOTAL-AMT-4                                 13919852
MFA-TR*            ,:S-ISSUE-DATE-4                                     13919853
MFA-TR*            ,:S-EXPIRATION-DATE-4                                13919854
MFA-TR*            ,:S-NAME-4                                           13919855
MFA-TR*            ,:S-ADDRESS-4                                        13919856
MFA-TR*            ,:S-CODE-ACCT-STAT-4                                 13919857
MFA-TR*            ,:S-MIN-DEP-AMT-4                                    13919857
MFA-TR*            ,:S-MAX-DEP-AMT-4                                    13919857
MFA-TR*         )                                                       13919858
MFA-TR*      END-EXEC.                                                  13919859

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13919959
             MOVE SQLCODE                 TO  WS-ACTIVE-RETURN-CODE.    
      *                                                                 13920159
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04610_R4'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT              
             END-IF.                                                    
      *                                                                 13921659
        8400-EXIT.                                                      
            EXIT.                                                       
      *                                                                 13921959
      ******************************************************************13917159
      *8500-SEND-RESULT-5                                               13917259
      ******************************************************************13917359
      *                                                                 13917459
       8500-SEND-RESULT-5.                                              
      *                                                                 13917659
            MOVE '8500'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13908059
            EXEC SQL                                                    
                 INSERT INTO #CSR04610_R5                        
               (                                                        
                    RETURN_CODE                                         
                   ,MAX_DEP_REF_XMT_CD                                  
                   ,LAST_MAX_AT_REV_DT                                  
                   ,MAX_DEP_AT_REV_AM                                   
                   ,PD_DEP_AT_REV_AM                                    
                   ,MAX_DEP_REFUND_CD                                   
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-5                                    
                   ,:S-MAX-DEP-REF-XMT-CD                               
                   ,:S-LAST-MAX-AT-REV-DT                               
                   ,:S-MAX-DEP-AT-REV-AM                                
                   ,:S-PD-DEP-AT-REV-AM                                 
                   ,:S-MAX-DEP-REFUND-CD                                
                )                                                       
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13917759
MFA-TR*          INSERT INTO SESSION.CSR04610_R5                        13917859
MFA-TR*        (                                                        13917860
MFA-TR*             RETURN_CODE                                         13917870
MFA-TR*            ,MAX_DEP_REF_XMT_CD                                  13917880
MFA-TR*            ,LAST_MAX_AT_REV_DT                                  13917881
MFA-TR*            ,MAX_DEP_AT_REV_AM                                   13917890
MFA-TR*            ,PD_DEP_AT_REV_AM                                    13917900
MFA-TR*            ,MAX_DEP_REFUND_CD                                   13918000
MFA-TR*         )                                                       13919200
MFA-TR*         VALUES                                                  13919300
MFA-TR*         (                                                       13919400
MFA-TR*             :S-RETURN-CODE-5                                    13919500
MFA-TR*            ,:S-MAX-DEP-REF-XMT-CD                               13919600
MFA-TR*            ,:S-LAST-MAX-AT-REV-DT                               13919700
MFA-TR*            ,:S-MAX-DEP-AT-REV-AM                                13919710
MFA-TR*            ,:S-PD-DEP-AT-REV-AM                                 13919800
MFA-TR*            ,:S-MAX-DEP-REFUND-CD                                13919810
MFA-TR*         )                                                       13919858
MFA-TR*      END-EXEC.                                                  13919859

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13919959
             MOVE SQLCODE                 TO  WS-ACTIVE-RETURN-CODE.    
      *                                                                 13920159
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04610_R5'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9700-PROCESS-ABEND THRU  9700-EXIT              
             END-IF.                                                    
      *                                                                 13921659
        8500-EXIT.                                                      
            EXIT.                                                       
      *                                                                 13921659
      ******************************************************************13922059
      * 8900-SEND-DONE.                                                *13990624
      ******************************************************************13990724
      *                                                                 13990824
       8900-SEND-DONE.                                                  
      *                                                                 13991024
            MOVE '8900'                   TO ACTIVE-PARAGRAPH.          
      *                                                                 13908059
           IF WS-GTT-R1-DECLARED = 'Y'                                  
               EXEC SQL                                                 
                    OPEN C1                                             
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 13991624
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
      *                                                                 13991624
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE 'OPEN'            TO ABEND-FUNCTION              
                  MOVE 'CSR04610_R1'     TO TABLE-1                     
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 13993024
           IF WS-GTT-R2-DECLARED = 'Y'                                  
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 13993524
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE 'OPEN'            TO ABEND-FUNCTION              
                  MOVE 'CSR04610_R2'     TO TABLE-1                     
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 13995027
           IF WS-GTT-R3-DECLARED = 'Y'                                  
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 13997627
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE 'OPEN'            TO ABEND-FUNCTION              
                  MOVE 'CSR04610_R3'     TO TABLE-1                     
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 14004627
           IF WS-GTT-R4-DECLARED = 'Y'                                  
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 14005127
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE 'OPEN'            TO ABEND-FUNCTION              
                  MOVE 'CSR04610_R4'     TO TABLE-1                     
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 14005127
           IF WS-GTT-R5-DECLARED = 'Y'                                  
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 14005127
               MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE       
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE SQLCODE           TO ABEND-SQLCODE               
                  MOVE SQLSTATE          TO ABEND-SQLSTATE              
                  MOVE 'OPEN'            TO ABEND-FUNCTION              
                  MOVE 'CSR04610_R5'     TO TABLE-1                     
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 14006727
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14009227
      ******************************************************************14009327
      * 9000-SEND-ERROR-RESULT                                         *14009427
      ******************************************************************14009527
      *                                                                 14009528
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 14009727
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         S-RETURN-CODE-2                
                                         S-RETURN-CODE-3                
                                         S-RETURN-CODE-4                
                                         S-RETURN-CODE-5                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 14010932
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14011332
           PERFORM 0101-DECLARE-GTT-R1 THRU 0101-EXIT.                  
           PERFORM 0102-DECLARE-GTT-R2 THRU 0102-EXIT.                  
           PERFORM 0103-DECLARE-GTT-R3 THRU 0103-EXIT.                  
           PERFORM 0104-DECLARE-GTT-R4 THRU 0104-EXIT.                  
           PERFORM 0105-DECLARE-GTT-R5 THRU 0105-EXIT.                  
      *                                                                 14011337
           PERFORM 8100-SEND-RESULT-1  THRU 8100-EXIT.                  
           PERFORM 8200-SEND-RESULT-2  THRU 8200-EXIT.                  
           PERFORM 8300-SEND-RESULT-3  THRU 8300-EXIT.                  
           PERFORM 8400-SEND-RESULT-4  THRU 8400-EXIT.                  
           PERFORM 8500-SEND-RESULT-5  THRU 8500-EXIT.                  
      *                                                                 14011337
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 14011932
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14012232
      ******************************************************************14012747
      * 9700-PROCESS-ABEND                                             *14012847
      ******************************************************************14013447
      *                                                                 14013547
       9700-PROCESS-ABEND.                                              
      *                                                                 14013747
           PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT.     
           PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT.     
      *                                                                 14014047
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14015027
      ******************************************************************14020025
      * 9900-SQL-ERROR-ROUTINE                                         *14030025
      ******************************************************************14040025
      *                                                                 14051047
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
      *                                                                 14051249
           EXEC SQL                                                     
      *                                                                 14053047
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                     14052047
MFA-TR*                                                                 14053047
MFA-TR*        CALL CSRERLOG (                                          14054047
MFA-TR*             :ABEND-PROGRAM,                                     14055047
MFA-TR*             :ABEND-SQLCODE,                                     14056047
MFA-TR*             :ABEND-SQLSTATE,                                    14057047
MFA-TR*             :TABLE-1,                                           14058047
MFA-TR*              VARCHAR(STRIP(                                     14059047
MFA-TR*              CASE                                               14059147
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                14059247
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT    14059347
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                    14059447
MFA-TR*                 ELSE                                            14059547
MFA-TR*                    ''                                           14059647
MFA-TR*              END CONCAT                                         14059747
MFA-TR*              CASE                                               14059847
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                14059947
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT    14060047
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                    14060147
MFA-TR*                 ELSE                                            14060247
MFA-TR*                    ''                                           14060347
MFA-TR*              END CONCAT                                         14060447
MFA-TR*              CASE                                               14060547
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                14060647
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT    14060747
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                    14060847
MFA-TR*                 ELSE                                            14060947
MFA-TR*                    ''                                           14061047
MFA-TR*              END CONCAT                                         14061147
MFA-TR*              CASE                                               14061247
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                14061347
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT    14061447
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                    14061547
MFA-TR*                 ELSE                                            14061647
MFA-TR*                    ''                                           14061747
MFA-TR*              END                                                14061847
MFA-TR*              )),                                                14061947
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                          14062047
MFA-TR*              VARCHAR(                                           14062147
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT14062247
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT 14062347
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                  14062447
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                  14062547
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC) 14062647
MFA-TR*              )                                                  14062747
MFA-TR*             )                                                   14062847
MFA-TR*    END-EXEC.                                                    14062947

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14090025
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
           
MSQ016        GOBACK.                                                    
      *                                                                 14090347
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14093047
      ******************************************************************14100025
      * 9999-END-PROGRAM.                                      *        14110025
      ******************************************************************14120025
      *                                                                 14130025
       9999-END-PROGRAM.                                                
      *                                                                 14150025
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
      *                                                                 14280025
           
MSQ016        GOBACK.                                                    
      *                                                                 14300025
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *14330025
