       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04609.                                         
COB303 DATE-WRITTEN.     FEB  03, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS USED IN CRYSTAL REPORT.                       *00090000
      *                                                                *00140000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  02/03/13  SV95326    NEW PROGRAM.                             *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-R4-CUR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04609'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR RPC CSR04609 STARTS HERE'.              
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00303.                                               00930000
                                                                        
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04609'.      
           05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-REVENUE-MONTH        PIC X(06).                       
           05  WS-REVENUE-MONTH-NUM    REDEFINES WS-REVENUE-MONTH       
                                       PIC 9(06).                       
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-RB-ROW-FND-SW               PIC 9(01) VALUE 0.        
               88 NO-RB-MATCH                           VALUE 0.        
               88 RB-MATCH-FOUND                        VALUE 1.        
           05  WS-R9-ROW-FND-SW               PIC 9(01) VALUE 0.        
               88 NO-R9-MATCH                           VALUE 0.        
               88 R9-MATCH-FOUND                        VALUE 1.        
           05  WS-CUST-LIGHT-CT        PIC S9(09) COMP VALUE 0.         
           05  WS-CUST-LESS-LT-CT      PIC S9(09) COMP VALUE 0.         
           05  WS-BILL-USAGE-UNITS     PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-READ-UNITS           PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-BILLED-AMT           PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-SALES-TAX            PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-FRAN-TAX             PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-OTHER-TAX            PIC S9(13)V9(02) COMP-3 VALUE 0. 
           05  WS-CONSUMPTION-UNITS    PIC S9(13)V COMP-3  VALUE 0.     
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND3            PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND4            PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND5            PIC S9(04) COMP VALUE 0.         
           05  WS-NULL-IND6            PIC S9(04) COMP VALUE 0.         
      *                                                                         
       01 WS-TABLES.                                                    
          05 RV-SUB                          PIC 9(4) COMP VALUE 0.     
          05 R4-SUB                          PIC 9(4) COMP VALUE 0.     
          05 WS-RV-COUNT                     PIC 9(4) COMP VALUE 0.     
          05 WS-R4-COUNT                     PIC 9(4) COMP VALUE 0.     
          05 WS-R4-TABLE.                                               
             10 TAB-R4-COMPANY-NO            PIC X(02) OCCURS 600 TIMES.
             10 TAB-R4-SERVICE-TYPE          PIC X(01) OCCURS 600 TIMES.
             10 TAB-R4-REV-ACCT-TYPE         PIC X(01) OCCURS 600 TIMES.
             10 TAB-R4-REVENUE-CLASS         PIC X(03) OCCURS 600 TIMES.
             10 TAB-R4-RATE-PLAN             PIC X(03) OCCURS 600 TIMES.
             10 TAB-R4-METER-CT        PIC S9(9) COMP OCCURS 600 TIMES. 
             10 TAB-R4-METER-LIGHT-CT  PIC S9(9) COMP OCCURS 600 TIMES. 
             10 TAB-R4-MTR-LESS-LT-CT  PIC S9(9) COMP OCCURS 600 TIMES. 
             10 TAB-R4-ELE-DH-CUST-CT  PIC S9(9) COMP OCCURS 600 TIMES. 
             10 TAB-R4-GAS-DH-CUST-CT  PIC S9(9) COMP OCCURS 600 TIMES. 
COB305       10 TAB-R4-BILLED-AMT        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-CONS-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-BILL-USAGE-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-ELE-DH-BILL-USAGE        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-ELE-DH-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-GAS-DH-BILL-USAGE        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-GAS-DH-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-SALES-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-FRAN-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
COB305       10 TAB-R4-OTHER-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 600 TIMES VALUE 0.
      *                                                                         
          05 WS-RVRBR9-TABLE.                                           
             10 TAB-RV-COMPANY-NO            PIC X(02) OCCURS 400 TIMES.
             10 TAB-RV-SERVICE-TYPE          PIC X(01) OCCURS 400 TIMES.
             10 TAB-RV-REV-ACCT-TYPE         PIC X(01) OCCURS 400 TIMES.
             10 TAB-RV-REVENUE-CLASS         PIC X(03) OCCURS 400 TIMES.
             10 TAB-RV-RATE-PLAN             PIC X(03) OCCURS 400 TIMES.
             10 TAB-RV-METER-CT        PIC S9(9) COMP OCCURS 400 TIMES. 
             10 TAB-RV-METER-LIGHT-CT  PIC S9(9) COMP OCCURS 400 TIMES. 
             10 TAB-RV-MTR-LESS-LT-CT  PIC S9(9) COMP OCCURS 400 TIMES. 
             10 TAB-RV-ELE-DH-CUST-CT  PIC S9(9) COMP OCCURS 400 TIMES. 
             10 TAB-RV-GAS-DH-CUST-CT  PIC S9(9) COMP OCCURS 400 TIMES. 
COB305       10 TAB-RB-BILLED-AMT        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-CONS-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-BILL-USAGE-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-ELE-DH-BILL-USAGE        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-ELE-DH-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-GAS-DH-BILL-USAGE        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-RB-GAS-DH-READ-UNITS        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-R9-SALES-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-R9-FRAN-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
COB305       10 TAB-R9-OTHER-TAX        PIC S9(13)V9(02) COMP-3 
COB305          OCCURS 400 TIMES VALUE 0.
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE          PIC S9(9) COMP VALUE 0.            
           05 S-REV-COMPANY-NO       PIC X(02) VALUE SPACES.            
           05 S-CODE-REV-ACCT-TYPE   PIC X(01) VALUE SPACES.            
           05 S-CODE-REVENUE-CLASS   PIC X(03) VALUE SPACES.            
           05 S-RATE-PLAN-NO         PIC X(03) VALUE SPACES.            
           05 S-CODE-SERVICE-TYPE    PIC X(01) VALUE SPACES.            
           05 S-METER-CT             PIC S9(9) USAGE COMP.              
           05 S-METER-LIGHT-CT       PIC S9(9) USAGE COMP.              
           05 S-METER-LESS-LIGHT-CT  PIC S9(9) USAGE COMP.              
           05 S-ELE-DH-CUST-CT       PIC S9(9) USAGE COMP.              
           05 S-GAS-DH-CUST-CT       PIC S9(9) USAGE COMP.              
COB305     05 S-BILLED-AMT        PIC S9(13)V9(2) USAGE COMP-3 VALUE 0.      
COB305     05 S-CONSUMPTION-UNITS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-BILL-USAGE-UNITS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-READ-UNITS        PIC S9(13)V9(2) USAGE COMP-3 VALUE 0.      
COB305     05 S-ELE-DH-BILL-USAGE        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-ELE-DH-READ-UNITS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-GAS-DH-BILL-USAGE        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-GAS-DH-READ-UNITS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-STATE-SALES-TAX-AMT        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-FRANCHISE-TAX-AMT        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 S-OTHER-TAX-AMT        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
           05 S-CALC-SOURCE-CD       PIC X(01) VALUE SPACES.            
                                                                        
      *                                                                         
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      ******************************************************************00540000
      *    REV_BILLING_DET   - RV                                       00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVBLD                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_BILL_COMP_ADJ - RB                                      *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVCOM                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_BILL_TAX      - R9                                      *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVTAX                                          00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00540000
      *    REV_CLASS_RATE_TMP  - R9                                    *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBREVSUM                                          00640000
           END-EXEC.                                                    00650000
                                                                        
                                                                        
      *****************************************************************         
      * CURSOR FOR GETTING THE RV DETAILS                             *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE R4_CUR CURSOR WITH ROWSET POSITIONING FOR         
              SELECT REV_COMPANY_NO                                     
              ,CODE_SERVICE_TYPE                                        
              ,CODE_REV_ACCT_TYPE                                       
              ,CODE_REVENUE_CLASS                                       
              ,RATE_PLAN_NO                                             
              ,CUST_CT                                                  
              ,CUST_LIGHT_CT                                            
              ,CUST_LESS_LIGHT_CT                                       
              ,ELE_DH_CUST_CT                                           
              ,GAS_DH_CUST_CT                                           
              ,BILLED_AMT                                               
              ,CONSUMPTION_UNITS                                        
              ,BILL_USAGE_UNITS                                         
              ,READ_UNITS                                               
              ,ELE_DH_BILL_USAGE                                        
              ,ELE_DH_READ_UNITS                                        
              ,GAS_DH_BILL_USAGE                                        
              ,GAS_DH_READ_UNITS                                        
              ,STATE_SALES_TAX_AM                                       
              ,FRANCHISE_TAX_AM                                         
              ,OTHER_TAX_AM                                             
              FROM REV_CLASS_RATE_TMP R4 WITH(READUNCOMMITTED)                  
              WHERE R4.REVENUE_MONTH = :RV-REVENUE-MONTH                
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE R4_CUR CURSOR WITH ROWSET POSITIONING FOR                 
MFA-TR*       SELECT REV_COMPANY_NO                                             
MFA-TR*       ,CODE_SERVICE_TYPE                                                
MFA-TR*       ,CODE_REV_ACCT_TYPE                                               
MFA-TR*       ,CODE_REVENUE_CLASS                                               
MFA-TR*       ,RATE_PLAN_NO                                                     
MFA-TR*       ,CUST_CT                                                          
MFA-TR*       ,CUST_LIGHT_CT                                                    
MFA-TR*       ,CUST_LESS_LIGHT_CT                                               
MFA-TR*       ,ELE_DH_CUST_CT                                                   
MFA-TR*       ,GAS_DH_CUST_CT                                                   
MFA-TR*       ,BILLED_AMT                                                       
MFA-TR*       ,CONSUMPTION_UNITS                                                
MFA-TR*       ,BILL_USAGE_UNITS                                                 
MFA-TR*       ,READ_UNITS                                                       
MFA-TR*       ,ELE_DH_BILL_USAGE                                                
MFA-TR*       ,ELE_DH_READ_UNITS                                                
MFA-TR*       ,GAS_DH_BILL_USAGE                                                
MFA-TR*       ,GAS_DH_READ_UNITS                                                
MFA-TR*       ,STATE_SALES_TAX_AM                                               
MFA-TR*       ,FRANCHISE_TAX_AM                                                 
MFA-TR*       ,OTHER_TAX_AM                                                     
MFA-TR*       FROM REV_CLASS_RATE_TMP R4                                        
MFA-TR*       WHERE R4.REVENUE_MONTH = :RV-REVENUE-MONTH                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR FOR GETTING THE RV DETAILS                             *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE RV_CUR CURSOR FOR                                 
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), RV.BILL_UNIQUE_TS
           , 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS                         
              ,RV.REV_COMPANY_NO                                        
              ,RV.CODE_SERVICE_TYPE                                     
              ,RV.CODE_REV_ACCT_TYPE                                    
              ,RV.CODE_REVENUE_CLASS                                    
              ,RV.RATE_PLAN_NO                                          
              ,RV.RATE_DEPT_CD                                          
              ,CUST_CT                                                  
              ,CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                     
                        THEN 0 ELSE RV.CUST_CT END                      
              ,CUST_CT -                                                
               CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                     
                        THEN 0 ELSE RV.CUST_CT END                      
              FROM REV_BILLING_DET RV WITH(READUNCOMMITTED)                     
              LEFT OUTER JOIN CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                     
              ON (RV.RATE_PLAN_NO = RD.RATE_PLAN_NO                     
              AND RV.COMPANY_NO = RD.COMPANY_NO                         
              AND RV.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE)                
              WHERE RV.REVENUE_MONTH = :RV-REVENUE-MONTH                
               AND  RV.CALC_SOURCE_CD  =  'R'                           
               AND RV.RATE_PLAN_NO <> '000'                             
              ORDER BY                                                  
               RV.REV_COMPANY_NO                                        
              ,RV.CODE_SERVICE_TYPE                                     
              ,RV.CODE_REV_ACCT_TYPE                                    
              ,RV.CODE_REVENUE_CLASS                                    
              ,RV.RATE_PLAN_NO                                          
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RV_CUR CURSOR FOR                                         
MFA-TR*       SELECT RV.BILL_UNIQUE_TS                                          
MFA-TR*       ,RV.REV_COMPANY_NO                                                
MFA-TR*       ,RV.CODE_SERVICE_TYPE                                             
MFA-TR*       ,RV.CODE_REV_ACCT_TYPE                                            
MFA-TR*       ,RV.CODE_REVENUE_CLASS                                            
MFA-TR*       ,RV.RATE_PLAN_NO                                                  
MFA-TR*       ,RV.RATE_DEPT_CD                                                  
MFA-TR*       ,CUST_CT                                                          
MFA-TR*       ,CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                             
MFA-TR*                 THEN 0 ELSE RV.CUST_CT END                              
MFA-TR*       ,CUST_CT -                                                        
MFA-TR*        CASE WHEN RD.REV_CUST_COUNT_CD = 'P'                             
MFA-TR*                 THEN 0 ELSE RV.CUST_CT END                              
MFA-TR*       FROM REV_BILLING_DET RV                                           
MFA-TR*       LEFT OUTER JOIN CSS_RATE_PLAN_DESC RD                             
MFA-TR*       ON (RV.RATE_PLAN_NO = RD.RATE_PLAN_NO                             
MFA-TR*       AND RV.COMPANY_NO = RD.COMPANY_NO                                 
MFA-TR*       AND RV.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE)                        
MFA-TR*       WHERE RV.REVENUE_MONTH = :RV-REVENUE-MONTH                        
MFA-TR*        AND  RV.CALC_SOURCE_CD  =  'R'                                   
MFA-TR*        AND RV.RATE_PLAN_NO <> '000'                                     
MFA-TR*       ORDER BY                                                          
MFA-TR*        RV.REV_COMPANY_NO                                                
MFA-TR*       ,RV.CODE_SERVICE_TYPE                                             
MFA-TR*       ,RV.CODE_REV_ACCT_TYPE                                            
MFA-TR*       ,RV.CODE_REVENUE_CLASS                                            
MFA-TR*       ,RV.RATE_PLAN_NO                                                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                            02000000
       LINKAGE SECTION.                                                 
       01  PARM-REVENUE-MONTH          PIC X(06).                       
                                                                        
       PROCEDURE DIVISION USING PARM-REVENUE-MONTH.                     
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
      *================================================================*02120000
       0000-MAINLINE.                                                   
      *================================================================*02120000
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02220000
      *================================================================*02120000
       0100-INITIALIZE.                                                 
      *================================================================*02120000
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     RETURN_CODE                                        
                    ,REV_COMPANY_NO                                     
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,CODE_SERVICE_TYPE                                  
                    ,METER_CT                                           
                    ,METER_LIGHT_CT                                     
                    ,METER_LESS_LIGHT_CT                                
                    ,ELE_DH_CUST_CT                                     
                    ,GAS_DH_CUST_CT                                     
                    ,BILLED_AMT                                         
                    ,CONSUMPTION_UNITS                                  
                    ,BILL_USAGE_UNITS                                   
                    ,READ_UNITS                                         
                    ,ELE_DH_BILL_USAGE                                  
                    ,ELE_DH_READ_UNITS                                  
                    ,GAS_DH_BILL_USAGE                                  
                    ,GAS_DH_READ_UNITS                                  
                    ,STATE_SALES_TAX_AMT                                
                    ,FRANCHISE_TAX_AMT                                  
                    ,OTHER_TAX_AMT                                      
                    ,CALC_SOURCE_CD                                     
                FROM                                                    
                    #CSR04609_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,METER_CT                                                   
MFA-TR*             ,METER_LIGHT_CT                                             
MFA-TR*             ,METER_LESS_LIGHT_CT                                        
MFA-TR*             ,ELE_DH_CUST_CT                                             
MFA-TR*             ,GAS_DH_CUST_CT                                             
MFA-TR*             ,BILLED_AMT                                                 
MFA-TR*             ,CONSUMPTION_UNITS                                          
MFA-TR*             ,BILL_USAGE_UNITS                                           
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,ELE_DH_BILL_USAGE                                          
MFA-TR*             ,ELE_DH_READ_UNITS                                          
MFA-TR*             ,GAS_DH_BILL_USAGE                                          
MFA-TR*             ,GAS_DH_READ_UNITS                                          
MFA-TR*             ,STATE_SALES_TAX_AMT                                        
MFA-TR*             ,FRANCHISE_TAX_AMT                                          
MFA-TR*             ,OTHER_TAX_AMT                                              
MFA-TR*             ,CALC_SOURCE_CD                                             
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04609_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02630000
      *================================================================*07800000
       0100A-DECLARE-GTT.                                               
      *================================================================*07800000
      * DECLARE TABLE TO HOLD RESULT SET                               *        
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04609_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04609_R1
              (                                                       
                     RETURN_CODE            INT                     
                    ,REV_COMPANY_NO CHAR(2)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CODE_REV_ACCT_TYPE CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CODE_REVENUE_CLASS CHAR(3)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,CODE_SERVICE_TYPE CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                    ,METER_CT               INT                     
                    ,METER_LIGHT_CT         INT                     
                    ,METER_LESS_LIGHT_CT    INT                     
                    ,ELE_DH_CUST_CT         INT                     
                    ,GAS_DH_CUST_CT         INT                     
                    ,BILLED_AMT             DECIMAL(15,2)              
                    ,CONSUMPTION_UNITS      DECIMAL(15,2)              
                    ,BILL_USAGE_UNITS       DECIMAL(15,2)              
                    ,READ_UNITS             DECIMAL(15,2)              
                    ,ELE_DH_BILL_USAGE      DECIMAL(15,2)              
                    ,ELE_DH_READ_UNITS      DECIMAL(15,2)              
                    ,GAS_DH_BILL_USAGE      DECIMAL(15,2)              
                    ,GAS_DH_READ_UNITS      DECIMAL(15,2)              
                    ,STATE_SALES_TAX_AMT    DECIMAL(15,2)              
                    ,FRANCHISE_TAX_AMT      DECIMAL(15,2)              
                    ,OTHER_TAX_AMT          DECIMAL(15,2)              
                    ,CALC_SOURCE_CD CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04609_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *================================================================*02710000
       1000-PROCESS-INPUT.                                              
      *================================================================*02710000
      *     RECEIVE PARMS.                                             *02700000
                                                                        
           MOVE PARM-REVENUE-MONTH           TO WS-REVENUE-MONTH.       
           MOVE WS-REVENUE-MONTH-NUM         TO RV-REVENUE-MONTH.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*03300000
       2000-PROCESS-OUTPUT.                                             
      *================================================================*03300000
                                                                        
           MOVE '2000'                       TO   ACTIVE-PARAGRAPH.     
           INITIALIZE  WS-TABLES.                                       
                                                                        
           PERFORM 7100-OPEN-R4-CORR-CUR     THRU 7100-EXIT.            
           PERFORM 7110-FETCH-R4-CORR-CUR    THRU 7110-EXIT.            
           PERFORM 7120-CLOSE-R4-CORR-CUR    THRU 7120-EXIT.            
                                                                        
           PERFORM 7400-OPEN-RV-CORR-CUR     THRU 7400-EXIT.            
           PERFORM 7410-FETCH-RV-CORR-CUR    THRU 7410-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2020-SET-INITIAL-DATA     THRU 2020-EXIT          
              PERFORM 2100-PROCESS-RVRBR9-DATA  THRU 2100-EXIT          
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
              MOVE RV-SUB                     TO WS-RV-COUNT            
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-RV-CORR-CUR    THRU 7420-EXIT.            
                                                                        
           PERFORM 2200-LOAD-R4-DETAILS      THRU 2200-EXIT             
              VARYING R4-SUB FROM 1 BY 1                                
                             UNTIL R4-SUB > WS-R4-COUNT.                
                                                                        
           PERFORM 2300-LOAD-RVRBR9-DETAILS  THRU 2300-EXIT             
              VARYING RV-SUB FROM 1 BY 1                                
                             UNTIL RV-SUB > WS-RV-COUNT.                
                                                                        
           IF CTR-ROWS < 1 THEN                                         
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2020-SET-INITIAL-DATA.                                           
      *================================================================*        
      *                                                                         
           MOVE 1                     TO RV-SUB                         
           MOVE RV-COMPANY-NO         TO TAB-RV-COMPANY-NO (RV-SUB)     
           MOVE RV-CODE-SERVICE-TYPE  TO TAB-RV-SERVICE-TYPE (RV-SUB)   
           MOVE RV-CODE-REV-ACCT-TYPE TO TAB-RV-REV-ACCT-TYPE (RV-SUB)  
           MOVE RV-CODE-REVENUE-CLASS TO TAB-RV-REVENUE-CLASS (RV-SUB)  
           MOVE RV-RATE-PLAN-NO       TO TAB-RV-RATE-PLAN (RV-SUB)      
           MOVE ZEROS             TO TAB-RV-METER-CT (RV-SUB)           
                                     TAB-RV-METER-LIGHT-CT (RV-SUB)     
                                     TAB-RV-MTR-LESS-LT-CT (RV-SUB)     
                                     TAB-RV-ELE-DH-CUST-CT (RV-SUB)     
                                     TAB-RV-GAS-DH-CUST-CT (RV-SUB)     
                                     TAB-RB-BILLED-AMT (RV-SUB)         
                                     TAB-RB-CONS-UNITS (RV-SUB)         
                                     TAB-RB-BILL-USAGE-UNITS  (RV-SUB)  
                                     TAB-RB-READ-UNITS        (RV-SUB)  
                                     TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)  
                                     TAB-RB-ELE-DH-READ-UNITS (RV-SUB)  
                                     TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)  
                                     TAB-RB-GAS-DH-READ-UNITS (RV-SUB)  
                                     TAB-R9-SALES-TAX  (RV-SUB)         
                                     TAB-R9-FRAN-TAX  (RV-SUB)          
                                     TAB-R9-OTHER-TAX (RV-SUB).         
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-PROCESS-RVRBR9-DATA.                                        
      *================================================================*        
      *                                                                         
           MOVE ZEROS                         TO WS-BILL-USAGE-UNITS    
                                                 WS-READ-UNITS          
                                                 WS-CONSUMPTION-UNITS   
                                                 WS-BILLED-AMT          
                                                 WS-SALES-TAX           
                                                 WS-FRAN-TAX            
                                                 WS-OTHER-TAX.          
                                                                        
           PERFORM 7200-GET-CONS-AMT-ADJ     THRU 7200-EXIT.            
           PERFORM 7300-GET-ALL-TAXES        THRU 7300-EXIT.            
                                                                        
           IF RV-CODE-SERVICE-TYPE = 'E'                                
              MOVE WS-BILL-USAGE-UNITS        TO WS-CONSUMPTION-UNITS   
           ELSE                                                         
              MOVE WS-READ-UNITS              TO WS-CONSUMPTION-UNITS   
           END-IF.                                                      
                                                                        
           IF RV-COMPANY-NO          = TAB-RV-COMPANY-NO (RV-SUB)       
              AND RV-CODE-SERVICE-TYPE  = TAB-RV-SERVICE-TYPE (RV-SUB)  
              AND RV-CODE-REV-ACCT-TYPE = TAB-RV-REV-ACCT-TYPE (RV-SUB) 
              AND RV-CODE-REVENUE-CLASS = TAB-RV-REVENUE-CLASS (RV-SUB) 
              AND RV-RATE-PLAN-NO       = TAB-RV-RATE-PLAN (RV-SUB)     
                                                                        
              PERFORM 2120-ACCUM-RV-DATA      THRU 2120-EXIT            
                                                                        
           ELSE                                                         
              PERFORM 2140-SET-NEXT-RV-DATA   THRU 2140-EXIT            
           END-IF                                                       
                                                                        
           PERFORM 7410-FETCH-RV-CORR-CUR    THRU 7410-EXIT.            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2120-ACCUM-RV-DATA.                                              
      *================================================================*        
      *                                                                         
           COMPUTE TAB-RV-METER-CT (RV-SUB)                             
                                    = TAB-RV-METER-CT (RV-SUB)          
                                        + RV-CUST-CT                    
           COMPUTE TAB-RV-METER-LIGHT-CT (RV-SUB)                       
                                    = TAB-RV-METER-LIGHT-CT (RV-SUB)    
                                        + WS-CUST-LIGHT-CT              
           COMPUTE TAB-RV-MTR-LESS-LT-CT (RV-SUB)                       
                                    = TAB-RV-MTR-LESS-LT-CT (RV-SUB)    
                                        + WS-CUST-LESS-LT-CT            
           COMPUTE TAB-RB-BILLED-AMT (RV-SUB)                           
                                    = TAB-RB-BILLED-AMT (RV-SUB)        
                                        + WS-BILLED-AMT                 
           COMPUTE TAB-RB-CONS-UNITS (RV-SUB)                           
                                    = TAB-RB-CONS-UNITS (RV-SUB)        
                                        + WS-CONSUMPTION-UNITS          
           COMPUTE TAB-RB-BILL-USAGE-UNITS (RV-SUB)                     
                                  = TAB-RB-BILL-USAGE-UNITS (RV-SUB)    
                                     + WS-BILL-USAGE-UNITS              
           COMPUTE TAB-RB-READ-UNITS (RV-SUB)                           
                                  = TAB-RB-READ-UNITS (RV-SUB)          
                                     + WS-READ-UNITS                    
           COMPUTE TAB-R9-SALES-TAX  (RV-SUB)                           
                                    = TAB-R9-SALES-TAX  (RV-SUB)        
                                        + WS-SALES-TAX                  
           COMPUTE TAB-R9-FRAN-TAX  (RV-SUB)                            
                                    = TAB-R9-FRAN-TAX  (RV-SUB)         
                                        + WS-FRAN-TAX                   
           COMPUTE TAB-R9-OTHER-TAX (RV-SUB)                            
                                    = TAB-R9-OTHER-TAX (RV-SUB)         
                                        + WS-OTHER-TAX.                 
           IF RV-RATE-DEPT-CD = 'E99'                                   
              COMPUTE TAB-RV-ELE-DH-CUST-CT (RV-SUB)                    
                                    = TAB-RV-ELE-DH-CUST-CT (RV-SUB)    
                                        + RV-CUST-CT                    
              COMPUTE TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)                 
                                  = TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)   
                                     + WS-BILL-USAGE-UNITS              
              COMPUTE TAB-RB-ELE-DH-READ-UNITS (RV-SUB)                 
                                  = TAB-RB-ELE-DH-READ-UNITS (RV-SUB)   
                                     + WS-READ-UNITS                    
           END-IF.                                                      
           IF RV-RATE-DEPT-CD = 'G99'                                   
              COMPUTE TAB-RV-GAS-DH-CUST-CT (RV-SUB)                    
                                    = TAB-RV-GAS-DH-CUST-CT (RV-SUB)    
                                        + RV-CUST-CT                    
              COMPUTE TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)                 
                                  = TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)   
                                     + WS-BILL-USAGE-UNITS              
              COMPUTE TAB-RB-GAS-DH-READ-UNITS (RV-SUB)                 
                                  = TAB-RB-GAS-DH-READ-UNITS (RV-SUB)   
                                     + WS-READ-UNITS                    
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2140-SET-NEXT-RV-DATA.                                           
      *================================================================*        
      *                                                                         
           COMPUTE RV-SUB        = RV-SUB + 1                           
           MOVE RV-COMPANY-NO         TO TAB-RV-COMPANY-NO (RV-SUB)     
           MOVE RV-CODE-SERVICE-TYPE  TO TAB-RV-SERVICE-TYPE (RV-SUB)   
           MOVE RV-CODE-REV-ACCT-TYPE TO TAB-RV-REV-ACCT-TYPE (RV-SUB)  
           MOVE RV-CODE-REVENUE-CLASS TO TAB-RV-REVENUE-CLASS (RV-SUB)  
           MOVE RV-RATE-PLAN-NO       TO TAB-RV-RATE-PLAN (RV-SUB)      
           MOVE RV-CUST-CT            TO TAB-RV-METER-CT (RV-SUB)       
           MOVE WS-CUST-LIGHT-CT      TO TAB-RV-METER-LIGHT-CT (RV-SUB) 
           MOVE WS-CUST-LESS-LT-CT    TO TAB-RV-MTR-LESS-LT-CT (RV-SUB) 
           MOVE WS-BILLED-AMT         TO TAB-RB-BILLED-AMT (RV-SUB)     
           MOVE WS-CONSUMPTION-UNITS  TO TAB-RB-CONS-UNITS (RV-SUB)     
           MOVE WS-BILL-USAGE-UNITS TO TAB-RB-BILL-USAGE-UNITS (RV-SUB) 
           MOVE WS-READ-UNITS         TO TAB-RB-READ-UNITS (RV-SUB)     
           MOVE WS-SALES-TAX          TO TAB-R9-SALES-TAX  (RV-SUB)     
           MOVE WS-FRAN-TAX           TO TAB-R9-FRAN-TAX  (RV-SUB)      
           MOVE WS-OTHER-TAX          TO TAB-R9-OTHER-TAX (RV-SUB).     
           MOVE ZEROS            TO TAB-RV-ELE-DH-CUST-CT (RV-SUB)      
                                    TAB-RV-GAS-DH-CUST-CT (RV-SUB)      
                                    TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)   
                                    TAB-RB-ELE-DH-READ-UNITS (RV-SUB)   
                                    TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)   
                                    TAB-RB-GAS-DH-READ-UNITS (RV-SUB).  
           IF RV-RATE-DEPT-CD = 'E99'                                   
              MOVE RV-CUST-CT     TO TAB-RV-ELE-DH-CUST-CT (RV-SUB)     
              MOVE WS-BILL-USAGE-UNITS                                  
                                  TO TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)  
              MOVE WS-READ-UNITS  TO TAB-RB-ELE-DH-READ-UNITS (RV-SUB)  
           END-IF.                                                      
           IF RV-RATE-DEPT-CD = 'G99'                                   
              MOVE RV-CUST-CT     TO TAB-RV-GAS-DH-CUST-CT (RV-SUB)     
              MOVE WS-BILL-USAGE-UNITS                                  
                                  TO TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)  
              MOVE WS-READ-UNITS  TO TAB-RB-GAS-DH-READ-UNITS (RV-SUB)  
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2200-LOAD-R4-DETAILS.                                            
      *================================================================*        
      *                                                                         
           MOVE TAB-R4-COMPANY-NO (R4-SUB)    TO S-REV-COMPANY-NO       
           MOVE TAB-R4-SERVICE-TYPE (R4-SUB)  TO S-CODE-SERVICE-TYPE    
           MOVE TAB-R4-REV-ACCT-TYPE (R4-SUB)                           
                                              TO S-CODE-REV-ACCT-TYPE   
           MOVE TAB-R4-REVENUE-CLASS (R4-SUB)                           
                                              TO S-CODE-REVENUE-CLASS   
           MOVE TAB-R4-RATE-PLAN (R4-SUB)     TO S-RATE-PLAN-NO         
           MOVE TAB-R4-METER-CT (R4-SUB)      TO  S-METER-CT            
           MOVE TAB-R4-METER-LIGHT-CT (R4-SUB)                          
                                              TO S-METER-LIGHT-CT       
           MOVE TAB-R4-MTR-LESS-LT-CT (R4-SUB)                          
                                              TO S-METER-LESS-LIGHT-CT  
           MOVE TAB-R4-ELE-DH-CUST-CT (R4-SUB)                          
                                              TO S-ELE-DH-CUST-CT       
           MOVE TAB-R4-GAS-DH-CUST-CT (R4-SUB)                          
                                              TO S-GAS-DH-CUST-CT       
           MOVE TAB-R4-BILLED-AMT (R4-SUB)    TO S-BILLED-AMT           
           MOVE TAB-R4-CONS-UNITS (R4-SUB)    TO S-CONSUMPTION-UNITS    
           MOVE TAB-R4-BILL-USAGE-UNITS (R4-SUB)                        
                                              TO S-BILL-USAGE-UNITS     
           MOVE TAB-R4-READ-UNITS (R4-SUB)    TO S-READ-UNITS           
           MOVE TAB-R4-ELE-DH-BILL-USAGE (R4-SUB)                       
                                              TO S-ELE-DH-BILL-USAGE    
           MOVE TAB-R4-ELE-DH-READ-UNITS (R4-SUB)                       
                                              TO S-ELE-DH-READ-UNITS    
           MOVE TAB-R4-GAS-DH-BILL-USAGE (R4-SUB)                       
                                              TO S-GAS-DH-BILL-USAGE    
           MOVE TAB-R4-GAS-DH-READ-UNITS (R4-SUB)                       
                                              TO S-GAS-DH-READ-UNITS    
           MOVE TAB-R4-SALES-TAX  (R4-SUB)    TO S-STATE-SALES-TAX-AMT  
           MOVE TAB-R4-FRAN-TAX   (R4-SUB)    TO S-FRANCHISE-TAX-AMT    
           MOVE TAB-R4-OTHER-TAX  (R4-SUB)    TO S-OTHER-TAX-AMT        
           MOVE 'S'                           TO S-CALC-SOURCE-CD       
           MOVE ZEROS                         TO S-RETURN-CODE          
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2300-LOAD-RVRBR9-DETAILS.                                        
      *================================================================*        
      *                                                                         
           MOVE TAB-RV-COMPANY-NO (RV-SUB)    TO S-REV-COMPANY-NO       
           MOVE TAB-RV-SERVICE-TYPE (RV-SUB)  TO S-CODE-SERVICE-TYPE    
           MOVE TAB-RV-REV-ACCT-TYPE (RV-SUB) TO S-CODE-REV-ACCT-TYPE   
           MOVE TAB-RV-REVENUE-CLASS (RV-SUB) TO S-CODE-REVENUE-CLASS   
           MOVE TAB-RV-RATE-PLAN (RV-SUB)     TO S-RATE-PLAN-NO         
           MOVE TAB-RV-METER-CT (RV-SUB)      TO  S-METER-CT            
           MOVE TAB-RV-METER-LIGHT-CT (RV-SUB)                          
                                              TO S-METER-LIGHT-CT       
           MOVE TAB-RV-MTR-LESS-LT-CT (RV-SUB)                          
                                              TO S-METER-LESS-LIGHT-CT  
           MOVE TAB-RV-ELE-DH-CUST-CT (RV-SUB)                          
                                              TO S-ELE-DH-CUST-CT       
           MOVE TAB-RV-GAS-DH-CUST-CT (RV-SUB)                          
                                              TO S-GAS-DH-CUST-CT       
           MOVE TAB-RB-BILLED-AMT (RV-SUB)    TO S-BILLED-AMT           
           MOVE TAB-RB-CONS-UNITS (RV-SUB)    TO S-CONSUMPTION-UNITS    
           MOVE TAB-RB-BILL-USAGE-UNITS  (RV-SUB)                       
                                              TO S-BILL-USAGE-UNITS     
           MOVE TAB-RB-READ-UNITS        (RV-SUB)                       
                                              TO S-READ-UNITS           
           MOVE TAB-RB-ELE-DH-BILL-USAGE (RV-SUB)                       
                                              TO S-ELE-DH-BILL-USAGE    
           MOVE TAB-RB-ELE-DH-READ-UNITS (RV-SUB)                       
                                              TO S-ELE-DH-READ-UNITS    
           MOVE TAB-RB-GAS-DH-BILL-USAGE (RV-SUB)                       
                                              TO S-GAS-DH-BILL-USAGE    
           MOVE TAB-RB-GAS-DH-READ-UNITS (RV-SUB)                       
                                              TO S-GAS-DH-READ-UNITS    
           MOVE TAB-R9-SALES-TAX  (RV-SUB)    TO S-STATE-SALES-TAX-AMT  
           MOVE TAB-R9-FRAN-TAX   (RV-SUB)    TO S-FRANCHISE-TAX-AMT    
           MOVE TAB-R9-OTHER-TAX  (RV-SUB)    TO S-OTHER-TAX-AMT        
           MOVE 'R'                           TO S-CALC-SOURCE-CD       
           MOVE ZEROS                         TO S-RETURN-CODE          
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-OPEN-R4-CORR-CUR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN R4_CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_CLASS_RATE_TMP'  TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32940000
      *================================================================*        
       7110-FETCH-R4-CORR-CUR.                                          

MSQ008     MOVE 600 TO MSQ008-R4-CUR
      *================================================================*        
      *                                                                 32940000
           EXEC SQL                                                     
               FOR :MSQ008-R4-CUR
              FETCH 
              FROM R4_CUR                
                INTO :TAB-R4-COMPANY-NO                                 
                    ,:TAB-R4-SERVICE-TYPE                               
                    ,:TAB-R4-REV-ACCT-TYPE                              
                    ,:TAB-R4-REVENUE-CLASS                              
                    ,:TAB-R4-RATE-PLAN                                  
                    ,:TAB-R4-METER-CT                                   
                    ,:TAB-R4-METER-LIGHT-CT                             
                    ,:TAB-R4-MTR-LESS-LT-CT                             
                    ,:TAB-R4-ELE-DH-CUST-CT                             
                    ,:TAB-R4-GAS-DH-CUST-CT                             
                    ,:TAB-R4-BILLED-AMT                                 
                    ,:TAB-R4-CONS-UNITS                                 
                    ,:TAB-R4-BILL-USAGE-UNITS                           
                    ,:TAB-R4-READ-UNITS                                 
                    ,:TAB-R4-ELE-DH-BILL-USAGE                          
                    ,:TAB-R4-ELE-DH-READ-UNITS                          
                    ,:TAB-R4-GAS-DH-BILL-USAGE                          
                    ,:TAB-R4-GAS-DH-READ-UNITS                          
                    ,:TAB-R4-SALES-TAX                                  
                    ,:TAB-R4-FRAN-TAX                                   
                    ,:TAB-R4-OTHER-TAX                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*        FETCH NEXT ROWSET FROM R4_CUR FOR 600 ROWS               32970000
MFA-TR*         INTO :TAB-R4-COMPANY-NO                                 32980000
MFA-TR*             ,:TAB-R4-SERVICE-TYPE                                       
MFA-TR*             ,:TAB-R4-REV-ACCT-TYPE                                      
MFA-TR*             ,:TAB-R4-REVENUE-CLASS                                      
MFA-TR*             ,:TAB-R4-RATE-PLAN                                          
MFA-TR*             ,:TAB-R4-METER-CT                                           
MFA-TR*             ,:TAB-R4-METER-LIGHT-CT                                     
MFA-TR*             ,:TAB-R4-MTR-LESS-LT-CT                                     
MFA-TR*             ,:TAB-R4-ELE-DH-CUST-CT                                     
MFA-TR*             ,:TAB-R4-GAS-DH-CUST-CT                                     
MFA-TR*             ,:TAB-R4-BILLED-AMT                                         
MFA-TR*             ,:TAB-R4-CONS-UNITS                                         
MFA-TR*             ,:TAB-R4-BILL-USAGE-UNITS                                   
MFA-TR*             ,:TAB-R4-READ-UNITS                                         
MFA-TR*             ,:TAB-R4-ELE-DH-BILL-USAGE                                  
MFA-TR*             ,:TAB-R4-ELE-DH-READ-UNITS                                  
MFA-TR*             ,:TAB-R4-GAS-DH-BILL-USAGE                                  
MFA-TR*             ,:TAB-R4-GAS-DH-READ-UNITS                                  
MFA-TR*             ,:TAB-R4-SALES-TAX                                          
MFA-TR*             ,:TAB-R4-FRAN-TAX                                           
MFA-TR*             ,:TAB-R4-OTHER-TAX                                          
MFA-TR*    END-EXEC.                                                    33080000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-R4-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)              TO WS-R4-COUNT               
              IF WS-R4-COUNT > 0                                        
                MOVE ZEROS                 TO S-RETURN-CODE             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_CLASS_RATE_TMP'  TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33290000
      *================================================================*        
       7120-CLOSE-R4-CORR-CUR.                                          
      *================================================================*        
      *                                                                 33290000
           EXEC SQL                                                     
              CLOSE R4_CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7120'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_CLASS_RATE_TMP'  TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7200-GET-CONS-AMT-ADJ.                                           
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
             SELECT SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')     
                             THEN RB.BILL_USAGE_UNITS                   
                             WHEN RB.CONSUMPT_TYPE_CD IN ('D')          
                             THEN (RB.BILL_USAGE_UNITS * 10)            
                             ELSE 0 END) AS BILL_USAGE_UNITS            
                    ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')    
                              THEN RB.READ_UNITS                        
                              WHEN RB.CONSUMPT_TYPE_CD IN ('D')         
                              THEN (RB.READ_UNITS * 10)                 
                              ELSE 0 END) AS READ_UNITS                 
                    ,SUM(RB.BILLED_AMT) AS BILLED_AMT                   
                INTO :WS-BILL-USAGE-UNITS :WS-NULL-IND1               
                    ,:WS-READ-UNITS :WS-NULL-IND2               
                    ,:WS-BILLED-AMT :WS-NULL-IND3               
              FROM REV_BILL_COMP_ADJ RB WITH(READUNCOMMITTED)                   
              WHERE RB.BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )              
                AND RB.UTILITY_REV_CD   = 'U'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*      SELECT SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')             
MFA-TR*                      THEN RB.BILL_USAGE_UNITS                           
MFA-TR*                      WHEN RB.CONSUMPT_TYPE_CD IN ('D')                  
MFA-TR*                      THEN (RB.BILL_USAGE_UNITS * 10)                    
MFA-TR*                      ELSE 0 END) AS BILL_USAGE_UNITS                    
MFA-TR*             ,SUM(CASE WHEN RB.CONSUMPT_TYPE_CD IN ('B', 'C')            
MFA-TR*                       THEN RB.READ_UNITS                                
MFA-TR*                       WHEN RB.CONSUMPT_TYPE_CD IN ('D')                 
MFA-TR*                       THEN (RB.READ_UNITS * 10)                         
MFA-TR*                       ELSE 0 END) AS READ_UNITS                         
MFA-TR*             ,SUM(RB.BILLED_AMT) AS BILLED_AMT                           
MFA-TR*         INTO :WS-BILL-USAGE-UNITS   :WS-NULL-IND1                       
MFA-TR*             ,:WS-READ-UNITS         :WS-NULL-IND2                       
MFA-TR*             ,:WS-BILLED-AMT         :WS-NULL-IND3                       
MFA-TR*       FROM REV_BILL_COMP_ADJ RB                                         
MFA-TR*       WHERE RB.BILL_UNIQUE_TS = :RV-BILL-UNIQUE-TS                      
MFA-TR*         AND RB.UTILITY_REV_CD   = 'U'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_BILL_COMP_ADJ'   TO TABLE-1                     
              MOVE 'BILL_UNIQUE_TS'      TO TABLE-ELEMENT-1             
              MOVE RV-BILL-UNIQUE-TS     TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       7300-GET-ALL-TAXES.                                              
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(CASE WHEN R9.TAX_TYPE = 'A'                    
                              THEN R9.TAX_AMT ELSE 0 END)               
                                                                        
                     ,SUM(CASE WHEN R9.TAX_TYPE = 'B'                   
                               THEN R9.TAX_AMT ELSE 0 END)              
                                                                        
                     ,SUM(CASE WHEN R9.TAX_TYPE = 'C'                   
                               THEN R9.TAX_AMT ELSE 0 END)              
                                                                        
                INTO :WS-SALES-TAX :WS-NULL-IND4                        
                    ,:WS-FRAN-TAX :WS-NULL-IND5                        
                    ,:WS-OTHER-TAX :WS-NULL-IND6                        
                FROM REV_BILL_TAX    R9 WITH(READUNCOMMITTED)                   
              WHERE R9.BILL_UNIQUE_TS = CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     32960000
MFA-TR*       SELECT SUM(CASE WHEN R9.TAX_TYPE = 'A'                            
MFA-TR*                       THEN R9.TAX_AMT ELSE 0 END)                       
MFA-TR*                                                                         
MFA-TR*              ,SUM(CASE WHEN R9.TAX_TYPE = 'B'                           
MFA-TR*                        THEN R9.TAX_AMT ELSE 0 END)                      
MFA-TR*                                                                         
MFA-TR*              ,SUM(CASE WHEN R9.TAX_TYPE = 'C'                           
MFA-TR*                        THEN R9.TAX_AMT ELSE 0 END)                      
MFA-TR*                                                                         
MFA-TR*         INTO :WS-SALES-TAX :WS-NULL-IND4                                
MFA-TR*             ,:WS-FRAN-TAX  :WS-NULL-IND5                                
MFA-TR*             ,:WS-OTHER-TAX :WS-NULL-IND6                                
MFA-TR*         FROM REV_BILL_TAX    R9                                         
MFA-TR*       WHERE R9.BILL_UNIQUE_TS = :RV-BILL-UNIQUE-TS                      
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    33080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_BILL_TAX'        TO TABLE-1                     
              MOVE 'BILL_UNIQUE_TS'      TO TABLE-ELEMENT-1             
              MOVE RV-BILL-UNIQUE-TS     TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *================================================================*        
       7400-OPEN-RV-CORR-CUR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN RV_CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_BILLING_DET'     TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              MOVE 'CALC_SOURCE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'R'                   TO HOSTVAR-ELEMENT-2           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32940000
      *================================================================*        
       7410-FETCH-RV-CORR-CUR.                                          
      *================================================================*        
      *                                                                 32940000
           EXEC SQL                                                     
               FETCH RV_CUR                                             
                INTO :RV-BILL-UNIQUE-TS                                 
                    ,:RV-COMPANY-NO                                     
                    ,:RV-CODE-SERVICE-TYPE                              
                    ,:RV-CODE-REV-ACCT-TYPE                             
                    ,:RV-CODE-REVENUE-CLASS                             
                    ,:RV-RATE-PLAN-NO                                   
                    ,:RV-RATE-DEPT-CD                                   
                    ,:RV-CUST-CT                                        
                    ,:WS-CUST-LIGHT-CT                                  
                    ,:WS-CUST-LESS-LT-CT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7410'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_BILLING_DET'     TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              MOVE 'CALC_SOURCE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'R'                   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33290000
      *================================================================*        
       7420-CLOSE-RV-CORR-CUR.                                          
      *================================================================*        
      *                                                                 33290000
           EXEC SQL                                                     
              CLOSE RV_CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7420'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'REV_BILLING_DET'     TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE RV-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              MOVE 'CALC_SOURCE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'R'                   TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*07800000
       8000A-DELETE-GTT-ROWS.                                           
      *================================================================*07800000
      * DELETE TEMPORARY TABLE WHEN REQUIRED.                          *        
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04609_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04609_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                                    ABEND-TABLES        
              MOVE 'CSR04609_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *================================================================*07800000
       8100-SEND-RESULT.                                                
      *================================================================*07800000
      * INSERT RESULT SET INTO TEMPORARY TABLE.                        *        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04609_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,REV_COMPANY_NO                                     
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,CODE_SERVICE_TYPE                                  
                    ,METER_CT                                           
                    ,METER_LIGHT_CT                                     
                    ,METER_LESS_LIGHT_CT                                
                    ,ELE_DH_CUST_CT                                     
                    ,GAS_DH_CUST_CT                                     
                    ,BILLED_AMT                                         
                    ,CONSUMPTION_UNITS                                  
                    ,BILL_USAGE_UNITS                                   
                    ,READ_UNITS                                         
                    ,ELE_DH_BILL_USAGE                                  
                    ,ELE_DH_READ_UNITS                                  
                    ,GAS_DH_BILL_USAGE                                  
                    ,GAS_DH_READ_UNITS                                  
                    ,STATE_SALES_TAX_AMT                                
                    ,FRANCHISE_TAX_AMT                                  
                    ,OTHER_TAX_AMT                                      
                    ,CALC_SOURCE_CD                                     
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-REV-COMPANY-NO                                  
                    ,:S-CODE-REV-ACCT-TYPE                              
                    ,:S-CODE-REVENUE-CLASS                              
                    ,:S-RATE-PLAN-NO                                    
                    ,:S-CODE-SERVICE-TYPE                               
                    ,:S-METER-CT                                        
                    ,:S-METER-LIGHT-CT                                  
                    ,:S-METER-LESS-LIGHT-CT                             
                    ,:S-ELE-DH-CUST-CT                                  
                    ,:S-GAS-DH-CUST-CT                                  
                    ,:S-BILLED-AMT                                      
                    ,:S-CONSUMPTION-UNITS                               
                    ,:S-BILL-USAGE-UNITS                                
                    ,:S-READ-UNITS                                      
                    ,:S-ELE-DH-BILL-USAGE                               
                    ,:S-ELE-DH-READ-UNITS                               
                    ,:S-GAS-DH-BILL-USAGE                               
                    ,:S-GAS-DH-READ-UNITS                               
                    ,:S-STATE-SALES-TAX-AMT                             
                    ,:S-FRANCHISE-TAX-AMT                               
                    ,:S-OTHER-TAX-AMT                                   
                    ,:S-CALC-SOURCE-CD                                  
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     42750000
MFA-TR*         INSERT INTO SESSION.CSR04609_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,METER_CT                                                   
MFA-TR*             ,METER_LIGHT_CT                                             
MFA-TR*             ,METER_LESS_LIGHT_CT                                        
MFA-TR*             ,ELE_DH_CUST_CT                                             
MFA-TR*             ,GAS_DH_CUST_CT                                             
MFA-TR*             ,BILLED_AMT                                                 
MFA-TR*             ,CONSUMPTION_UNITS                                          
MFA-TR*             ,BILL_USAGE_UNITS                                           
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,ELE_DH_BILL_USAGE                                          
MFA-TR*             ,ELE_DH_READ_UNITS                                          
MFA-TR*             ,GAS_DH_BILL_USAGE                                          
MFA-TR*             ,GAS_DH_READ_UNITS                                          
MFA-TR*             ,STATE_SALES_TAX_AMT                                        
MFA-TR*             ,FRANCHISE_TAX_AMT                                          
MFA-TR*             ,OTHER_TAX_AMT                                              
MFA-TR*             ,CALC_SOURCE_CD                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-REV-COMPANY-NO                                  32980000
MFA-TR*             ,:S-CODE-REV-ACCT-TYPE                                      
MFA-TR*             ,:S-CODE-REVENUE-CLASS                                      
MFA-TR*             ,:S-RATE-PLAN-NO                                            
MFA-TR*             ,:S-CODE-SERVICE-TYPE                                       
MFA-TR*             ,:S-METER-CT                                                
MFA-TR*             ,:S-METER-LIGHT-CT                                          
MFA-TR*             ,:S-METER-LESS-LIGHT-CT                                     
MFA-TR*             ,:S-ELE-DH-CUST-CT                                          
MFA-TR*             ,:S-GAS-DH-CUST-CT                                          
MFA-TR*             ,:S-BILLED-AMT                                              
MFA-TR*             ,:S-CONSUMPTION-UNITS                                       
MFA-TR*             ,:S-BILL-USAGE-UNITS                                        
MFA-TR*             ,:S-READ-UNITS                                              
MFA-TR*             ,:S-ELE-DH-BILL-USAGE                                       
MFA-TR*             ,:S-ELE-DH-READ-UNITS                                       
MFA-TR*             ,:S-GAS-DH-BILL-USAGE                                       
MFA-TR*             ,:S-GAS-DH-READ-UNITS                                       
MFA-TR*             ,:S-STATE-SALES-TAX-AMT                                     
MFA-TR*             ,:S-FRANCHISE-TAX-AMT                                       
MFA-TR*             ,:S-OTHER-TAX-AMT                                           
MFA-TR*             ,:S-CALC-SOURCE-CD                                          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04609_R1'        TO TABLE-1                     
               MOVE 'REVENUE_MONTH'      TO TABLE-ELEMENT-1             
               MOVE RV-REVENUE-MONTH     TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
