       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04606.                                      
COB303 DATE-WRITTEN.     FEBRUARY 06,2013.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATES AUTO_XFER_TO_ACCT IN CSS_CUSTOMER TABLE.              *        
      *                                                                *        
      *  CLONED FROM CSR03369.                                         *        
      ******************************************************************        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          CUSTOMER_NO        DECIMAL(13)                        *        
      *          ACCOUNT_NO         DECIMAL(13)                        *        
      *          XFER_TO_ACCOUNT_NO DECIMAL(13)                        *        
      *                                                                *        
      *  RESUT SET 1:                                                  *        
      *                                                                *        
      *          RETURN_CODE          INTEGER                          *        
      *          APPL_RETURN_CODE     INTEGER                          *        
      *          BUS_RULE_ID          CHAR(10)                         *        
      *          BUS_RULE_RESULT_CD   CHAR(08)                         *        
      *          BUS_RULE_XREF_ID     CHAR(26)                         *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00627*  02/06/13  MS93554    INITIAL PROGRAM VERSION.                 *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04606'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04606 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT        AT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_CUSTOMER       CU                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_MNT_TRANS_HIST MH                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_MT_TRN_HST_DET MI                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04606'.   
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN            PIC S9(04) COMP.               
               49 GTT-ROW-CHAR           PIC X(1024).                   
           05  GTT-SQLCODE               PIC S9(9)  COMP.               
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)  COMP VALUE 1.       
           05  CTR-ROWS                  PIC S9(9)  COMP VALUE 0.       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-ZERO                   PIC S9(04) COMP VALUE 0.       
           05  WS-ACTIVE                 PIC X(01)  VALUE 'A'.          
           05  WS-FINAL-BILLED           PIC X(01)  VALUE 'B'.          
           05  WS-FAILED                 PIC X(01)  VALUE 'F'.          
                                                                        
       01  WS-BUS-RULE-ERROR.                                           
           05 WS-XFER-TO-ACCT-IS-INVALID   PIC X(10) VALUE 'AM00000007'.
           05 WS-XFER-TO-ACCT-IS-NOT-ACTV  PIC X(10) VALUE 'AM00000028'.
           05 WS-XFER-TO-ACCT-NOT-MSTR-SUB PIC X(10) VALUE 'AM00000029'.
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE              PIC S9(09) COMP VALUE 0.       
           10 S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE 0.       
           10 S-RS1-BUS-RULE-ID          PIC X(10)  VALUE SPACE.        
           10 S-RS1-BUS-RULE-RESULT-CD                                  
                                         PIC X(08)  VALUE SPACE.        
           10 S-RS1-BUS-RULE-XREF-ID     PIC X(26)  VALUE SPACE.        
                                                                        
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-XFER-TO-ACCT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-OLD-AUTO-XFER-TO-ACCT        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-TRAN-APPL-NO           PIC S9(04)  COMP VALUE 0.      
           05  WS-NULL-IND1              PIC S9(4)   COMP VALUE 0.      
           05  WS-GTT-NAME               PIC X(19)   VALUE SPACES.      
           05  WS-COMMENTS               PIC X(100)                     
               VALUE 'AUTO XFER ACCOUNT NUMBER MANUALLY CHANGED.'.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305 01 PARM-XFER-TO-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
       PROCEDURE DIVISION USING PARM-CUSTOMER-NO                        
                                PARM-ACCOUNT-NO                         
                                PARM-XFER-TO-ACCOUNT-NO.                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04606_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04606_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04606_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04606_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04606_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO            TO WS-CUSTOMER-NO.          
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE PARM-XFER-TO-ACCOUNT-NO     TO WS-XFER-TO-ACCT-NO.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCT-DETAILS    THRU 7000-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF AT-CODE-ACCT-STAT NOT EQUAL 'A'                        
                 MOVE WS-XFER-TO-ACCT-IS-NOT-ACTV                       
                                            TO S-RS1-BUS-RULE-ID        
                 MOVE WS-FAILED             TO S-RS1-BUS-RULE-RESULT-CD 
                 IF S-RS1-BUS-RULE-ID GREATER THAN SPACES               
                    PERFORM 7200-GET-RULE-XREF-ID THRU 7200-EXIT        
                 END-IF                                                 
                 MOVE 100                   TO S-APPL-RETURN-CODE       
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
                                                                        
              IF AT-MST-SUB-ACCT-IND EQUAL 'M' OR 'S'                   
                 MOVE WS-XFER-TO-ACCT-NOT-MSTR-SUB                      
                                            TO S-RS1-BUS-RULE-ID        
                 MOVE WS-FAILED             TO S-RS1-BUS-RULE-RESULT-CD 
                 IF S-RS1-BUS-RULE-ID GREATER THAN SPACES               
                    PERFORM 7200-GET-RULE-XREF-ID THRU 7200-EXIT        
                 END-IF                                                 
                 MOVE 100                   TO S-APPL-RETURN-CODE       
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-XFER-TO-ACCT-IS-INVALID                           
                                            TO S-RS1-BUS-RULE-ID        
              MOVE WS-FAILED                TO S-RS1-BUS-RULE-RESULT-CD 
              IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                  
                 PERFORM 7200-GET-RULE-XREF-ID THRU 7200-EXIT           
              END-IF                                                    
              MOVE 100                   TO S-APPL-RETURN-CODE          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7100-GET-AUTO-XFER-TO-ACCT  THRU 7100-EXIT.          
           PERFORM 8000-UPDATE-CUSTOMER        THRU 8000-EXIT.          
                                                                        
           IF WS-OLD-AUTO-XFER-TO-ACCT NOT EQUAL WS-XFER-TO-ACCT-NO     
              PERFORM 2100-WRITE-TRANS-HIST    THRU 2100-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS EQUAL WS-ZERO                                    
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-WRITE-TRANS-HIST.                                         *        
      ******************************************************************        
       2100-WRITE-TRANS-HIST.                                           
                                                                        
           PERFORM 7300-GET-CURR-TIMESTAMP  THRU 7300-EXIT.             
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW               05901000
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE SPACES                 TO MH-RESP-AREA-ID.              
           MOVE WS-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE WS-CUSTOMER-NO         TO MH-CUSTOMER-NO.               
           MOVE WS-ZERO                TO MH-PREMISE-NO.                
           MOVE SPACES                 TO MH-USER-ID.                   
           MOVE 'AUTO XFER'            TO MH-APPL-PROGRAM-ID.           
           MOVE WS-COMMENTS            TO MH-TRAN-COMMENT-TEXT.         
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                       TO MH-TRAN-COMMENT-LEN.          
                                                                        
      *    WRITE A TRANSACTION HISTORY DETAIL ROW                               
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
           MOVE SPACES                   TO MI-TABLE-ID.                
                                                                        
           MOVE +13                      TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-OLD-AUTO-XFER-TO-ACCT TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE WS-XFER-TO-ACCT-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE 'AUTO-XFER-TO-AC'        TO MI-COLUMN-DESC              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-ACCT-DETAILS.                                      *        
      ******************************************************************        
       7000-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
             SELECT AT.CODE_ACCT_STAT                                   
                   ,AT.MST_SUB_ACCT_IND                                 
               INTO :AT-CODE-ACCT-STAT                                  
                   ,:AT-MST-SUB-ACCT-IND                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO  = :WS-XFER-TO-ACCT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.MST_SUB_ACCT_IND                                         
MFA-TR*        INTO :AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                        
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO  = :WS-XFER-TO-ACCT-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
              MOVE 'XFER-TO-ACCT-NO'          TO TABLE-ELEMENT-1        
              MOVE WS-XFER-TO-ACCT-NO         TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-AUTO-XFER-TO-ACCT.                                    *        
      ******************************************************************        
       7100-GET-AUTO-XFER-TO-ACCT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CU.AUTO_XFER_TO_ACCT                               
                INTO :WS-OLD-AUTO-XFER-TO-ACCT :WS-NULL-IND1             
                FROM CSS_CUSTOMER CU                                    
               WHERE CU.CUSTOMER_NO = :WS-CUSTOMER-NO                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CU.AUTO_XFER_TO_ACCT                                       
MFA-TR*         INTO :WS-OLD-AUTO-XFER-TO-ACCT:WS-NULL-IND1                     
MFA-TR*         FROM CSS_CUSTOMER CU                                            
MFA-TR*        WHERE CU.CUSTOMER_NO = :WS-CUSTOMER-NO                           
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND1 < 0                                       
                 MOVE WS-ZERO                TO WS-OLD-AUTO-XFER-TO-ACCT
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUSTOMER'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7200-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1            
               MOVE S-RS1-BUS-RULE-ID     TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06010000
      * 7300-GET-CURR-TIMESTAMP                                       * 06020000
      ******************************************************************06030000
       7300-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06070000
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP            06080000
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                 06090000
MFA-TR*    END-EXEC.                                                    06100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-UPDATE-CUSTOMER.                                          *        
      ******************************************************************        
       8000-UPDATE-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER                                       
                 SET AUTO_XFER_TO_ACCT = :WS-XFER-TO-ACCT-NO            
                    ,AUTO_XFER_UPDT_DT =  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
               WHERE CUSTOMER_NO       = :WS-CUSTOMER-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*          SET AUTO_XFER_TO_ACCT = :WS-XFER-TO-ACCT-NO                    
MFA-TR*             ,AUTO_XFER_UPDT_DT =  CURRENT DATE                          
MFA-TR*        WHERE CUSTOMER_NO       = :WS-CUSTOMER-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUSTOMER'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04606_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04606_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04606_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND.RESULT.                                              .        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04606_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,BUS_RULE_ID                                         
                   ,BUS_RULE_RESULT_CD                                  
                   ,BUS_RULE_XREF_ID                                    
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-RS1-BUS-RULE-ID                                  
                   ,:S-RS1-BUS-RULE-RESULT-CD                           
                   ,:S-RS1-BUS-RULE-XREF-ID                             
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04606_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,BUS_RULE_ID                                                 
MFA-TR*            ,BUS_RULE_RESULT_CD                                          
MFA-TR*            ,BUS_RULE_XREF_ID                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-RS1-BUS-RULE-ID                                          
MFA-TR*            ,:S-RS1-BUS-RULE-RESULT-CD                                   
MFA-TR*            ,:S-RS1-BUS-RULE-XREF-ID                                     
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                    TO CTR-ROWS                     
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04606_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
