       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04605.                                      
COB303 DATE-WRITTEN.     FEBRUARY 11,2013.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ROWS FROM CSS_ACCOUNT TABLE BASED ON   *        
      *  THE CUSTOMER NUMBER AND RETRIEVING ADDRESS DETAILS FOR        *        
      *  THE SAME ACCOUNT.                                             *        
      *                                                                *        
      *  CLONED FROM CSR02029.                                         *        
      ******************************************************************        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          CUSTOMER_NO        DECIMAL(10)                        *        
      *          ACCOUNT_NO         DECIMAL(13)                        *        
      *          COMPANY_NO         CHAR(02)                           *        
      *          CURRENT_ACCT_STAT  CHAR(01)                           *        
      *                                                                *        
      *  RESULT SET 1:                                                 *        
      *                                                                *        
      *          RETURN_CODE        INTEGER                            *        
      *          APPL_RETURN_CODE   INTEGER                            *        
      *          ACCOUNT_NO         CHAR(13)                           *        
      *          CODE_ACCT_STAT     CHAR(01)                           *        
      *          ADDRESS            CHAR(42)                           *        
      *          CITY               CHAR(26)                           *        
      *          ZIP_CODE           CHAR(05)                           *        
      *          CREDIT_GROUP       CHAR(01)                           *        
      *          CREDIT_STATUS      CHAR(01)                           *        
      *          TOTAL_AR_BALANCE   DECIMAL(13,2)                      *        
      *          COMPANY_NO         CHAR(02)                           *        
      *          MST_SUB_IND        CHAR(01)                           *        
      *          ACCT_XFER_TO       DECIMAL(13,0)                      *        
      *          ACCT_XFER_TO_ARCHVD CHAR(01)                          *        
      *          XFER_TO_CUST_NO    DECIMAL(13,0)                      *        
      *          FULL_NAME          CHAR(70)                           *        
      *          ACCT_XFER_FROM_LST DECIMAL(13,0)                      *        
ACT257*          ACCT_XFER_FROM_TS  CHAR(26)                           *        
      *          ACCT_XFER_FROM_ARCHVD CHAR(01)                        *        
ACT257*          ACCT_XFER_COUNTER  DECIMAL(9,0)                       *        
P00936*          BNKRPT_CASE_NO        CHAR(10)                        *        
P00936*          BNKRPT_IND            CHAR(01)                        *        
P00936*          JDGMNT_CASE_NO        CHAR(10)                        *        
P00936*          JDGMNT_IND            CHAR(01)                        *        
P00936*          NAME_ID               CHAR(50)                        *        
P00936*          ACCT_TYPE             CHAR(01)                        *        
P00936*          ACCT_TYPE_DESC        CHAR(25)                        *        
P00936*          CUSTOMER_NO           CHAR(10)                        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00627*  02/09/13  MS93554    INITIAL PROGRAM VERSION.                 *        
ACT257*  09/15/14  RB19957  1)RETURN TO UI A VALUE INDICATING HOW MANY *        
ACT257*        APPL00004880   XFER FORWARD RELATIONSHIPS THERE ARE.    *        
ACT257*                     2)BYPASS XFER-FROM-LST FOR MSTR/SUB ACCTS  *        
P00936*  04/13/16  VV7M728  UPDATES FOR BANKRUPTCY / JUDGEMENTS        *        
A05460*  09/28/16  MR7E794    REMOVED THE MAIN USER TABLE AS PART      *        
      *            ACT282     OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04605'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04605 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT          AT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   HST_ACCOUNT          HA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME            DQ                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_NAME_ACCT_XREF  HT                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ADDR_FORMATTED  DY                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ZIP_CD          A4                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUSTOMER        CU                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
ACT282*    CSS_SO_CODE_DESC    SW                                      *        
P00936******************************************************************        
P00936     EXEC SQL                                                             
ACT282         INCLUDE TBSOCODE                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936******************************************************************        
P00936*    CSS_BANKRUPTCY      BQ                                      *        
P00936******************************************************************        
P00936     EXEC SQL                                                             
P00936         INCLUDE TBBNKRPT                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936******************************************************************        
P00936*    CSS_JUDGEMENT       JU                                      *        
P00936******************************************************************        
P00936     EXEC SQL                                                             
P00936         INCLUDE TBJDGMNT                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936         INCLUDE TBARCNTL                                                 
P00936     END-EXEC.                                                            
P00936     EXEC SQL                                                             
P00936        INCLUDE TBCHGOFF                                                  
P00936     END-EXEC.                                                            
P00936******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08)  VALUE 'CSR04605'.   
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN            PIC S9(04) COMP.               
               49 GTT-ROW-CHAR           PIC X(1024).                   
           05  GTT-SQLCODE               PIC S9(9)  COMP.               
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
P00936     05  WS-FULL-BALANCE-A       PIC S9(11)V99 VALUE 0 COMP-3.    
P00936     05  WS-FULL-BALANCE-B       PIC S9(11)V99 VALUE 0 COMP-3.    
P00936     05  WS-NULL-1               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-4               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-5               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-6               PIC S9(4) COMP VALUE +0.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9)  COMP VALUE 1.       
           05  CTR-ROWS                  PIC S9(9)  COMP VALUE 0.       
ACT257     05  WS-FROM-COUNTER           PIC S9(9)  COMP VALUE 0.       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-ZERO                   PIC S9(04) COMP VALUE 0.       
           05  WS-SUB                    PIC S9(8)  COMP VALUE 0.       
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-IGNORE-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  WS-COMPANY-NO             PIC X(02).                     
COB305     05 WS-ACCOUNT-XFER-TO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-ACCOUNT-STATUS         PIC X(01)   VALUE SPACES.      
           05  WS-FILTER-BY-ACCT-STATUS  PIC X(01)   VALUE 'N'.         
           05  WS-FILTER-BY-COMP-NO      PIC X(01)   VALUE 'N'.         
           05  WS-AR-XFER-IND-FOR-FROM-ACCT                             
                                         PIC X(01)   VALUE 'N'.         
           05  WS-AUTO-XFER-ACCT-NULL    PIC S9(04) COMP VALUE +0.      
           05  WS-LENGTH                 PIC S9(4).                     
           05  WS-MAX-SZ                 PIC S9(4).                     
P00936     05  RS-NAME                   PIC X(50) VALUE SPACES.        
           05  WS-FROM.                                                 
               10  WS-FROM-X             OCCURS 51 TIMES PIC X.         
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X          OCCURS 50 TIMES                
                                         INDEXED BY WS-ADD-SUB.         
                   15  FILLER            PIC X.                         
P00936 01  CN-CONSTANTS.                                                
P00936     05  CN-DELIMITER                 PIC X VALUE ';'.            
P00936     05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP.               
           05  S-APPL-RETURN-CODE        PIC S9(09) COMP.               
           05  S-ACCOUNT-NO              PIC X(13).                     
           05  S-CODE-ACCT-STAT          PIC X(01).                     
           05  S-ADDRESS                 PIC X(42).                     
           05  S-CITY                    PIC X(26).                     
           05  S-STATE                   PIC X(02).                     
           05  S-ZIP-CODE                PIC X(05).                     
           05  S-CREDIT-GROUP            PIC X(01).                     
           05  S-CREDIT-STATUS           PIC X(01).                     
           05  S-TOTAL-AR-BALANCE        PIC S9(13)V99 COMP-3 VALUE 0.  
           05  S-COMPANY-NO              PIC X(02).                     
           05  S-MST-SUB-IND             PIC X(01).                     
           05  S-ACCT-XFER-TO            PIC S9(13)V USAGE COMP-3       
                                                           VALUE 0.     
           05  S-ACCT-XFER-TO-ARCHVD     PIC X(01) VALUE 'N'.           
           05  S-XFER-TO-CUST-NO         PIC S9(13)V USAGE COMP-3       
                                                           VALUE 0.     
           05  S-FULL-NAME               PIC X(70) VALUE SPACES.        
           05  S-ACCT-XFER-FROM-LST      PIC S9(13)V USAGE COMP-3       
                                                           VALUE 0.     
ACT257     05  S-ACCT-XFER-FROM-TS       PIC X(26) VALUE SPACES.        
           05  S-ACCT-XFER-FROM-ARCHVD   PIC X(01) VALUE 'N'.           
ACT257     05  S-ACCT-XFER-COUNTER       PIC S9(9)V USAGE COMP-3        
ACT257                                                     VALUE 0.     
P00936     05 S-BNKRPT-CASE-NO           PIC X(10) VALUE SPACES.        
P00936     05 S-BNKRPT-IND               PIC X(01) VALUE SPACES.        
P00936     05 S-JDGMNT-CASE-NO           PIC X(10) VALUE SPACES.        
P00936     05 S-JDGMNT-IND               PIC X(10) VALUE SPACES.        
P00936     05 S-NAME                     PIC X(50) VALUE SPACES.        
P00936     05 S-ACCT-TYPE                PIC X(01) VALUE SPACES.        
P00936     05 S-ACCT-TYPE-DESC           PIC X(25) VALUE SPACES.        
P00936     05 S-CUSTOMER-NO              PIC X(10) VALUE SPACES.        
P00936     05 S-BNK-FILED-CASE-NO        PIC X(10) VALUE SPACES.        
P00936     05 S-BNK-CHAPTER              PIC X(02) VALUE SPACES.        
P00936     05 S-DATE-BNK-FILED           PIC X(10) VALUE SPACES.        
P00936     05 S-BNK-INIT-BY              PIC X(07) VALUE SPACES.        
P00936     05 S-RECEIVED-DATE            PIC X(10) VALUE SPACES.        
P00936     05 S-FILED-CASE-NO            PIC X(15) VALUE SPACES.        
P00936     05 S-JUDGEMENT-FILED-DT       PIC X(10) VALUE SPACES.        
P00936     05 S-USER-ID-INIT-BY          PIC X(07) VALUE SPACES.        
P00936     05 S-ACCOUNT-BALANCE          PIC S9(11)V99 VALUE 0 COMP-3.  
P00936     05 S-CREATE-DT                PIC X(10)   VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-NO-MORE-ROWS           PIC X(01) VALUE 'N'.           
               88 NO-MORE-ROWS                     VALUE 'Y'.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
      ******************************************************************        
      *    CURSOR TO RETRIEVE ACCOUNT  ROWS FOR THE CUSTOMER NUMBER    *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE ACCT_CURSOR CURSOR FOR                      
               SELECT AT.ACCOUNT_NO                                     
                     ,AT.COMPANY_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.CREDIT_GROUP                                   
                     ,AT.CREDIT_STATUS_CODE                             
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.MST_SUB_ACCT_IND                               
                     ,AT.ACCT_XFER_TO                                   
                     ,AT.ACCT_XFER_FROM_LST                             
                     ,AT.AR_XFER_IND                                    
P00936               ,AT.BNKRPT_CASE_NO                                 
P00936               ,AT.BANKRUPTCY_IND                                 
P00936               ,AT.JUDGEMENT_CASE_NO                              
P00936               ,AT.JUDGEMENT_IND                                  
P00936               ,AT.ACCOUNT_TYPE_CODE                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.CUSTOMER_NO             = :AT-CUSTOMER-NO      
                  AND (:WS-FILTER-BY-COMP-NO     = :WS-YES              
                        AND AT.COMPANY_NO        = :WS-COMPANY-NO       
                               OR                                       
                       :WS-FILTER-BY-COMP-NO     = :WS-NO)              
                                                                        
                  AND (:WS-FILTER-BY-ACCT-STATUS = :WS-YES              
                        AND CODE_ACCT_STAT       = :WS-ACCOUNT-STATUS   
                               OR                                       
                       :WS-FILTER-BY-ACCT-STATUS = :WS-NO)              
                ORDER BY AT.ACCOUNT_NO                                  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE ACCT_CURSOR CURSOR FOR                              
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.CREDIT_STATUS_CODE                                     
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.MST_SUB_ACCT_IND                                       
MFA-TR*              ,AT.ACCT_XFER_TO                                           
MFA-TR*              ,AT.ACCT_XFER_FROM_LST                                     
MFA-TR*              ,AT.AR_XFER_IND                                            
MFA-TR*              ,AT.BNKRPT_CASE_NO                                         
MFA-TR*              ,AT.BANKRUPTCY_IND                                         
MFA-TR*              ,AT.JUDGEMENT_CASE_NO                                      
MFA-TR*              ,AT.JUDGEMENT_IND                                          
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.CUSTOMER_NO             = :AT-CUSTOMER-NO              
MFA-TR*           AND (:WS-FILTER-BY-COMP-NO     = :WS-YES                      
MFA-TR*                 AND AT.COMPANY_NO        = :WS-COMPANY-NO               
MFA-TR*                        OR                                               
MFA-TR*                :WS-FILTER-BY-COMP-NO     = :WS-NO)                      
MFA-TR*                                                                         
MFA-TR*           AND (:WS-FILTER-BY-ACCT-STATUS = :WS-YES                      
MFA-TR*                 AND CODE_ACCT_STAT       = :WS-ACCOUNT-STATUS           
MFA-TR*                        OR                                               
MFA-TR*                :WS-FILTER-BY-ACCT-STATUS = :WS-NO)                      
MFA-TR*         ORDER BY AT.ACCOUNT_NO                                          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305 01 PARM-IGNORE-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
       01  PARM-COMPANY-NO               PIC X(02).                     
       01  PARM-ACCT-WITH-STATUS         PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING PARM-CUSTOMER-NO                        
                                PARM-IGNORE-ACCOUNT-NO                  
                                PARM-COMPANY-NO                         
                                PARM-ACCT-WITH-STATUS.                  
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04605_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04605_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04605_R1
              (                                                       
                    RETURN_CODE              INT                    
                   ,APPL_RETURN_CODE         INT                    
                   ,ACCOUNT_NUMBER CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,ADDRESS CHAR(42)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2              
                   ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
                   ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CREDIT_GROUP CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CREDIT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,TOTAL_AR_BALANCE         DECIMAL(13,2)              
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MST_SUB_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,ACCT_XFER_TO             DECIMAL(13,0)              
                   ,ACCT_XFER_TO_ARCHVD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,XFER_TO_CUST_NO          DECIMAL(13,0)              
                   ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ACCT_XFER_FROM_LST       DECIMAL(13,0)              
ACT257             ,ACCT_XFER_FROM_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,ACCT_XFER_FROM_ARCHVD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
ACT257             ,ACCT_XFER_COUNTER        DECIMAL(9,0)               
P00936             ,BNKRPT_CASE_NO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
P00936             ,BNKRPT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00936             ,JDGMNT_CASE_NO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
P00936             ,JDGMNT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00936             ,NAME_ID CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2           
P00936             ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00936             ,ACCT_TYPE_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
P00936             ,CUSTOMER_NO CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
P00936             ,ACCOUNT_BALANCE          DECIMAL(11,2)              
P00936             ,ACCT_CREATE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(ACCOUNT_NUMBER))     AS    
           ACCOUNT_NUMBER   
                      ,LTRIM(RTRIM(CODE_ACCT_STAT))     AS    
           CODE_ACCT_STAT   
                      ,LTRIM(RTRIM(ADDRESS))            AS    ADDRESS          
                      ,LTRIM(RTRIM(CITY))               AS    CITY             
                      ,LTRIM(RTRIM(STATE))              AS    STATE            
                      ,LTRIM(RTRIM(ZIP_CODE))           AS    ZIP_CODE         
                      ,LTRIM(RTRIM(CREDIT_GROUP))       AS    
           CREDIT_GROUP     
                      ,LTRIM(RTRIM(CREDIT_STATUS))      AS    
           CREDIT_STATUS    
                      ,TOTAL_AR_BALANCE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))         AS    COMPANY_NO       
                      ,LTRIM(RTRIM(MST_SUB_IND))        AS    
           MST_SUB_IND      
                      ,ACCT_XFER_TO                                     
                      ,LTRIM(RTRIM(ACCT_XFER_TO_ARCHVD)) AS 
           XFER_TO_ACCT_ARCHVD
                      ,XFER_TO_CUST_NO           AS ACCT_XFER_CUST_NO   
                      ,LTRIM(RTRIM(FULL_NAME))          AS 
           XFER_TO_CUST_NAME   
                      ,LTRIM(RTRIM(ACCT_XFER_FROM_LST)) AS 
           ACCT_XFER_FROM_LST  
ACT257                ,ACCT_XFER_FROM_TS         AS ACCT_XFER_FROM_TS   
                      ,LTRIM(RTRIM(ACCT_XFER_FROM_ARCHVD))                     
                                                AS XFER_FROM_ACCT_ARCHVD
ACT257                ,LTRIM(RTRIM(ACCT_XFER_COUNTER)) AS 
           ACCT_XFER_COUNTER    
P00936                ,BNKRPT_CASE_NO                                   
P00936                ,BNKRPT_IND                                       
P00936                ,JDGMNT_CASE_NO                                   
P00936                ,JDGMNT_IND                                       
P00936                ,NAME_ID                                          
P00936                ,ACCT_TYPE                                        
P00936                ,ACCT_TYPE_DESC                                   
P00936                ,CUSTOMER_NO                                      
P00936                ,ACCOUNT_BALANCE                                  
P00936                ,ACCT_CREATE_DT                                   
                  FROM #CSR04605_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(ACCOUNT_NUMBER)     AS    ACCOUNT_NUMBER           
MFA-TR*               ,STRIP(CODE_ACCT_STAT)     AS    CODE_ACCT_STAT           
MFA-TR*               ,STRIP(ADDRESS)            AS    ADDRESS                  
MFA-TR*               ,STRIP(CITY)               AS    CITY                     
MFA-TR*               ,STRIP(STATE)              AS    STATE                    
MFA-TR*               ,STRIP(ZIP_CODE)           AS    ZIP_CODE                 
MFA-TR*               ,STRIP(CREDIT_GROUP)       AS    CREDIT_GROUP             
MFA-TR*               ,STRIP(CREDIT_STATUS)      AS    CREDIT_STATUS            
MFA-TR*               ,TOTAL_AR_BALANCE                                         
MFA-TR*               ,STRIP(COMPANY_NO)         AS    COMPANY_NO               
MFA-TR*               ,STRIP(MST_SUB_IND)        AS    MST_SUB_IND              
MFA-TR*               ,ACCT_XFER_TO                                             
MFA-TR*               ,STRIP(ACCT_XFER_TO_ARCHVD) AS XFER_TO_ACCT_ARCHVD        
MFA-TR*               ,XFER_TO_CUST_NO           AS ACCT_XFER_CUST_NO           
MFA-TR*               ,STRIP(FULL_NAME)          AS XFER_TO_CUST_NAME           
MFA-TR*               ,STRIP(ACCT_XFER_FROM_LST) AS ACCT_XFER_FROM_LST          
MFA-TR*               ,ACCT_XFER_FROM_TS         AS ACCT_XFER_FROM_TS           
MFA-TR*               ,STRIP(ACCT_XFER_FROM_ARCHVD)                             
MFA-TR*                                         AS XFER_FROM_ACCT_ARCHVD        
MFA-TR*               ,STRIP(ACCT_XFER_COUNTER) AS ACCT_XFER_COUNTER            
MFA-TR*               ,BNKRPT_CASE_NO                                           
MFA-TR*               ,BNKRPT_IND                                               
MFA-TR*               ,JDGMNT_CASE_NO                                           
MFA-TR*               ,JDGMNT_IND                                               
MFA-TR*               ,NAME_ID                                                  
MFA-TR*               ,ACCT_TYPE                                                
MFA-TR*               ,ACCT_TYPE_DESC                                           
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,ACCOUNT_BALANCE                                          
MFA-TR*               ,ACCT_CREATE_DT                                           
MFA-TR*           FROM SESSION.CSR04605_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO            TO WS-CUSTOMER-NO           
                                               AT-CUSTOMER-NO.          
           MOVE PARM-IGNORE-ACCOUNT-NO      TO WS-IGNORE-ACCOUNT-NO.    
           MOVE PARM-COMPANY-NO             TO WS-COMPANY-NO.           
           MOVE PARM-ACCT-WITH-STATUS       TO WS-ACCOUNT-STATUS.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-COMPANY-NO NOT EQUAL SPACES                            
              MOVE WS-YES                   TO  WS-FILTER-BY-COMP-NO    
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-STATUS NOT EQUAL SPACES                        
              MOVE WS-YES                   TO WS-FILTER-BY-ACCT-STATUS 
           END-IF.                                                      
                                                                        
           PERFORM 7000-OPEN-ACCT-CURSOR       THRU 7000-EXIT           
           PERFORM 7100-FETCH-ACCT-CURSOR      THRU 7100-EXIT           
           PERFORM 2100-ACCT-PROCESS           THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7200-CLOSE-ACCT-CURSOR      THRU 7200-EXIT           
                                                                        
           IF CTR-ROWS EQUAL WS-ZERO                                    
              MOVE 100                      TO S-RETURN-CODE            
              MOVE WS-ZERO                  TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-ACCT-PROCESS.                                             *        
      ******************************************************************        
       2100-ACCT-PROCESS.                                               
                                                                        
           IF AT-ACCOUNT-NO     EQUAL WS-IGNORE-ACCOUNT-NO              
              PERFORM 7100-FETCH-ACCT-CURSOR THRU 7100-EXIT             
              GO TO 2100-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO            TO HT-ACCOUNT-NO               
                                            AC-ACCOUNT-NO               
                                            CO-ACCOUNT-NO.              
           MOVE AT-COMPANY-NO            TO HT-COMPANY-NO.              
P00936     PERFORM 2320-GET-NAME            THRU 2320-EXIT.             
           PERFORM 7300-GET-ADDR-FORMAT     THRU 7300-EXIT.             
           PERFORM 7400-GET-CITY            THRU 7400-EXIT.             
                                                                        
      *       Initialize all result set variables.                              
           MOVE ZEROES                   TO S-XFER-TO-CUST-NO.          
           MOVE SPACES                   TO S-FULL-NAME.                
           MOVE ZEROS                    TO S-ACCT-XFER-FROM-LST.       
           MOVE ZEROS                    TO S-ACCT-XFER-TO.             
           MOVE WS-NO                    TO S-ACCT-XFER-FROM-ARCHVD.    
           MOVE WS-NO                    TO S-ACCT-XFER-TO-ARCHVD.      
           MOVE WS-NO                    TO                             
                                           WS-AR-XFER-IND-FOR-FROM-ACCT.
                                                                        
      *       Check whether acct-xfer-from-lst is archived status,if yes        
      *       return xfer from acct flag as 'y'. if it's not archived           
      *       Return acct_xfer_from_lst account alone only when css_            
      *       account has ar_xfer_ind = 'y' and acct_xfer_to curr acct.         
ACT257     IF AT-MST-SUB-ACCT-IND = 'M' or 'S'                          
ACT257        NEXT SENTENCE                                             
ACT257     ELSE                                                         
              IF AT-ACCT-XFER-FROM-LST GREATER THAN ZEROES              
                 PERFORM 7700-GET-XFER-TO-ACCT   THRU 7700-EXIT         
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                   MOVE AT-ACCT-XFER-FROM-LST TO HA-ACCOUNT-NO          
                   PERFORM 7800-CHK-ACCT-STAT    THRU 7800-EXIT         
                   IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL       
                      MOVE  WS-YES          TO S-ACCT-XFER-FROM-ARCHVD  
                   END-IF                                               
                 ELSE                                                   
                   IF WS-AR-XFER-IND-FOR-FROM-ACCT EQUAL WS-YES AND     
                      WS-ACCOUNT-XFER-TO  EQUAL AT-ACCOUNT-NO           
ACT257                PERFORM 7750-CK4-MULTI-XFER2-ACCTS THRU 7750-EXIT 
ACT257                MOVE WS-FROM-COUNTER TO S-ACCT-XFER-COUNTER       
ACT257                IF WS-FROM-COUNTER = 1                            
                          MOVE AT-ACCT-XFER-FROM-LST                    
                                                 TO S-ACCT-XFER-FROM-LST
ACT257                    MOVE AT-LAST-UPDATE-TS TO S-ACCT-XFER-FROM-TS 
ACT257                ELSE                                              
ACT257                    MOVE ZEROES TO S-ACCT-XFER-FROM-LST           
ACT257                END-IF                                            
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
ACT257     END-IF.                                                      
                                                                        
      *       Check whether acct-xfer-to is archived status, if account         
      *       is archived return xfer to acct archived flag as 'y'              
      *       if its not archived return customet name and cust no.             
           IF AT-ACCT-XFER-TO GREATER THAN ZEROES                       
              PERFORM 7500-GET-CUST-NO      THRU 7500-EXIT              
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE AT-ACCT-XFER-TO    TO HA-ACCOUNT-NO               
                 PERFORM 7800-CHK-ACCT-STAT THRU 7800-EXIT              
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE WS-YES          TO S-ACCT-XFER-TO-ARCHVD       
                 END-IF                                                 
              ELSE                                                      
                 IF AT-AR-XFER-IND EQUAL WS-YES                         
                    MOVE AT-ACCT-XFER-TO TO S-ACCT-XFER-TO              
                    MOVE CU-CUSTOMER-NO  TO S-XFER-TO-CUST-NO           
                    PERFORM 7600-GET-CUST-NAME THRU 7600-EXIT           
                    MOVE DQ-FULL-NAME    TO S-FULL-NAME                 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO            TO S-ACCOUNT-NO.               
           MOVE AT-COMPANY-NO            TO S-COMPANY-NO.               
           MOVE AT-CODE-ACCT-STAT        TO S-CODE-ACCT-STAT.           
           MOVE AT-CREDIT-GROUP          TO S-CREDIT-GROUP.             
           MOVE AT-CREDIT-STATUS-CODE    TO S-CREDIT-STATUS.            
           MOVE AT-TOTAL-AR-BALANCE      TO S-TOTAL-AR-BALANCE.         
           MOVE AT-MST-SUB-ACCT-IND      TO S-MST-SUB-IND.              
P00936     MOVE AT-BNKRPT-CASE-NO        TO S-BNKRPT-CASE-NO.           
P00936                                                                  
P00936     IF AT-BNKRPT-CASE-NO > SPACES                                
P00936        MOVE AT-BNKRPT-CASE-NO     TO BQ-BNKRPT-CASE-NO           
P00936        PERFORM 7910-SELECT-BQ-ROW            THRU 7910-EXIT      
                                                                        
P00936        MOVE BQ-FILED-CASE-NO      TO S-BNK-FILED-CASE-NO         
P00936        MOVE BQ-BANKRUPTCY-CHAPTER TO S-BNK-CHAPTER               
P00936        MOVE BQ-DATE-BNKRPT-FILED  TO S-DATE-BNK-FILED            
P00936        MOVE BQ-USER-ID-INIT-BY    TO S-BNK-INIT-BY               
P00936        MOVE BQ-RECEIVED-DATE      TO S-RECEIVED-DATE             
P00936     ELSE                                                         
P00936        MOVE SPACES                TO S-BNK-FILED-CASE-NO         
P00936        MOVE SPACES                TO S-BNK-CHAPTER               
P00936        MOVE SPACES                TO S-DATE-BNK-FILED            
P00936        MOVE SPACES                TO S-BNK-INIT-BY               
P00936        MOVE SPACES                TO S-RECEIVED-DATE             
P00936     END-IF                                                       
P00936                                                                  
P00936     IF AT-JUDGEMENT-CASE-NO > SPACES                             
P00936        MOVE AT-JUDGEMENT-CASE-NO  TO JU-JUDGEMENT-CASE-NO        
P00936        PERFORM 7920-SELECT-JU-ROW            THRU 7920-EXIT      
P00936                                                                  
P00936        MOVE JU-FILED-CASE-NO      TO S-FILED-CASE-NO             
P00936        MOVE JU-JUDGEMENT-FILED-DT TO S-JUDGEMENT-FILED-DT        
P00936        MOVE JU-USER-ID-INIT-BY    TO S-USER-ID-INIT-BY           
P00936     ELSE                                                         
P00936        MOVE SPACES                TO S-FILED-CASE-NO             
P00936        MOVE SPACES                TO S-JUDGEMENT-FILED-DT        
P00936        MOVE SPACES                TO S-USER-ID-INIT-BY           
P00936     END-IF                                                       
P00936                                                                  
P00936     MOVE AT-BANKRUPTCY-IND        TO S-BNKRPT-IND.               
P00936     MOVE AT-JUDGEMENT-CASE-NO     TO S-JDGMNT-CASE-NO.           
P00936     MOVE AT-JUDGEMENT-IND         TO S-JDGMNT-IND.               
P00936     MOVE RS-NAME                  TO S-NAME.                     
P00936     MOVE AT-ACCOUNT-TYPE-CODE     TO S-ACCT-TYPE                 
ACT282                                      SW-CODE-VALUE.              
P00936     PERFORM 7930-ACCOUNT-TYPE                THRU 7930-EXIT      
                                                                        
ACT282     MOVE SW-CODE-LONG-DESC        TO S-ACCT-TYPE-DESC.           
P00936     MOVE AT-CUSTOMER-NO           TO S-CUSTOMER-NO.              
                                                                        
      *    THIS PROCESS TO GET ADDRESS FOR THE ACCOUNT.                         
           MOVE SPACE                    TO WS-ADDRESS.                 
           SET WS-ADD-SUB                TO 1.                          
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
              MOVE DY-STREET-NAME                TO WS-FROM             
              MOVE LENGTH OF DY-STREET-NAME      TO WS-MAX-SZ           
              PERFORM 2200-ACCUMULATE-ADDRESS       THRU 2200-EXIT      
                                                                        
              MOVE '&' TO WS-FROM                                       
              MOVE 1   TO WS-MAX-SZ                                     
              PERFORM 2200-ACCUMULATE-ADDRESS       THRU 2200-EXIT      
                                                                        
              MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM             
              MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ           
              PERFORM 2200-ACCUMULATE-ADDRESS       THRU 2200-EXIT      
           ELSE                                                         
              IF DY-HOUSE-NO NOT = SPACE                                
                 MOVE DY-HOUSE-NO                TO WS-FROM             
                 MOVE LENGTH OF DY-HOUSE-NO      TO WS-MAX-SZ           
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
                                                                        
              IF DY-ADDR-PREFIX-1 NOT = SPACE                           
                 MOVE DY-ADDR-PREFIX-1           TO WS-FROM             
                 MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ           
                 PERFORM 2200-ACCUMULATE-ADDRESS   THRU 2200-EXIT       
              END-IF                                                    
                                                                        
              IF DY-ADDR-PREFIX-2 NOT = SPACE                           
                 MOVE DY-ADDR-PREFIX-2           TO WS-FROM             
                 MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ           
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
                                                                        
              IF DY-STREET-NAME NOT = SPACE                             
                 MOVE DY-STREET-NAME             TO WS-FROM             
                 MOVE LENGTH OF DY-STREET-NAME   TO WS-MAX-SZ           
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
                                                                        
              IF DY-STREET-SUFFIX NOT = SPACE                           
                 MOVE DY-STREET-SUFFIX           TO WS-FROM             
                 MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ           
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
                                                                        
              IF DY-STREET-LOCATION-1 NOT = SPACE                       
                 MOVE DY-STREET-LOCATION-1       TO WS-FROM             
                 MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ       
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
                                                                        
              IF DY-STREET-LOCATION-2 NOT = SPACE                       
                 MOVE DY-STREET-LOCATION-2       TO WS-FROM             
                 MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ       
                 PERFORM 2200-ACCUMULATE-ADDRESS    THRU 2200-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS                       TO S-ADDRESS.          
           MOVE A4-TOWN                          TO S-CITY.             
           MOVE A4-STATE                         TO S-STATE.            
           MOVE DY-ZIP-CODE                      TO S-ZIP-CODE.         
P00936     PERFORM 7830-GET-ACCT-DTLS       THRU 7830-EXIT.             
P00936     MOVE AT-ACCT-CREATE-DT(1:10)          TO S-CREATE-DT.        
P00936     IF AT-CODE-ACCT-STAT EQUAL 'S'                               
P00936        PERFORM 2650-GET-WO-BALANCE      THRU 2650-EXIT           
P00936     ELSE                                                         
P00936        PERFORM 2630-GET-ACCOUNT-BALANCE THRU 2630-EXIT           
P00936     END-IF.                                                      
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           PERFORM 7100-FETCH-ACCT-CURSOR        THRU 7100-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-ACCUMULATE-ADDRESS                                        *        
      *                                                                *        
      *  DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO    *        
      *  THE FORMATTED ADDRESS FIELD.                                  *        
      ******************************************************************        
                                                                        
       2200-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM VARYING WS-LENGTH FROM WS-MAX-SZ BY -1               
                   UNTIL WS-LENGTH < 1                                  
                   OR WS-FROM-X (WS-LENGTH) NOT EQUAL SPACE             
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                   UNTIL WS-SUB > WS-LENGTH                             
             MOVE WS-FROM-X (WS-SUB) TO WS-ADDRESS-X (WS-ADD-SUB)       
             SET WS-ADD-SUB UP BY 1                                     
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
P00936******************************************************************        
P00936*                                                                *        
P00936* 2320-GET-NAME.                                                 *        
P00936******************************************************************        
      *                                                                         
P00936 2320-GET-NAME.                                                   
P00936*                                                                         
P00936     PERFORM 7900-SELECT-DQ-ROW THRU 7900-EXIT.                   
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936     IF DQ-NAME-FORMAT = 'I'                                      
P00936        MOVE DQ-LAST-NAME TO WS-FROM                              
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-LAST-NAME                             
P00936                                                                  
P00936         MOVE DQ-FIRST-NAME TO WS-FROM                            
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-FIRST-NAME                            
P00936                                                                  
P00936         IF DQ-MIDDLE-NAME NOT = SPACE                            
P00936             MOVE DQ-MIDDLE-NAME TO WS-FROM                       
P00936             PERFORM 2510-PROCESS-FROM-STRING                     
P00936             MOVE WS-FROM TO DQ-MIDDLE-NAME                       
P00936         END-IF                                                   
P00936                                                                  
P00936         MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
P00936                                                                  
P00936         IF DQ-MIDDLE-NAME = SPACE                                
P00936             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
P00936                    ', ' DELIMITED SIZE                           
P00936                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
P00936               INTO RS-NAME                                       
P00936             END-STRING                                           
P00936         ELSE                                                     
P00936             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
P00936                    ', ' DELIMITED SIZE                           
P00936                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
P00936               INTO RS-NAME                                       
P00936             END-STRING                                           
P00936         END-IF                                                   
P00936     ELSE                                                         
P00936         MOVE DQ-FULL-NAME     TO RS-NAME                         
P00936     END-IF                                                       
P00936     ELSE                                                         
P00936        MOVE 'NAME NOT FOUND' TO RS-NAME                          
P00936     END-IF.                                                      
P00936 2320-EXIT.                                                       
P00936      EXIT.                                                       
P00936*                                                                         
P00936************************************************************              
P00936* 2510-PROCESS-FROM-STRING                                 *              
P00936*                                                          *              
P00936* DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST*              
P00936* NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.*              
P00936*                                                          *              
P00936************************************************************              
P00936                                                                  
P00936 2510-PROCESS-FROM-STRING.                                        
P00936                                                                  
P00936                                                                  
P00936     PERFORM                                                      
P00936          VARYING WS-SUB FROM 51 BY -1                            
P00936          UNTIL WS-SUB < 1                                        
P00936          OR WS-FROM-X (WS-SUB) NOT = SPACE                       
P00936     END-PERFORM.                                                 
P00936     ADD 1             TO WS-SUB.                                 
P00936     MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
P00936                                                                  
P00936 2510-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936 2630-GET-ACCOUNT-BALANCE.                                        
P00936*                                                                         
P00936     PERFORM 7810-GET-FULL-BALANCE-A  THRU 7810-EXIT.             
P00936     PERFORM 7820-GET-FULL-BALANCE-B  THRU 7820-EXIT.             
P00936     COMPUTE S-ACCOUNT-BALANCE = WS-FULL-BALANCE-A +              
P00936                                 WS-FULL-BALANCE-B.               
P00936*                                                                         
P00936 2630-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936*                                                                         
P00936 2650-GET-WO-BALANCE.                                             
P00936*                                                                         
P00936     PERFORM 7850-WO-FULL-BALANCE THRU 7850-EXIT.                 
P00936     COMPUTE S-ACCOUNT-BALANCE = CO-AMT-TRANS +                   
P00936                                   AT-TOTAL-AR-BALANCE.           
P00936*                                                                         
P00936 2650-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-ACCT-CURSOR.                                         *        
      ******************************************************************        
       7000-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN ACCT_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-ACCT-CURSOR.                                        *        
      ******************************************************************        
       7100-FETCH-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH  ACCT_CURSOR                                        
               INTO :AT-ACCOUNT-NO,
                :AT-COMPANY-NO,
                :AT-CUSTOMER-NO,
                :AT-CODE-ACCT-STAT,
                :AT-CREDIT-GROUP,
                :AT-CREDIT-STATUS-CODE,
                :AT-TOTAL-AR-BALANCE,
                :AT-MST-SUB-ACCT-IND,
                :AT-ACCT-XFER-TO,
                :AT-ACCT-XFER-FROM-LST,
                :AT-AR-XFER-IND,
                :AT-BNKRPT-CASE-NO,
                :AT-BANKRUPTCY-IND,
                :AT-JUDGEMENT-CASE-NO,
                :AT-JUDGEMENT-IND,
                :AT-ACCOUNT-TYPE-CODE                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH  ACCT_CURSOR                                                
MFA-TR*        INTO :AT-ACCOUNT-NO                                              
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-CREDIT-GROUP                                            
MFA-TR*            ,:AT-CREDIT-STATUS-CODE                                      
MFA-TR*            ,:AT-TOTAL-AR-BALANCE                                        
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                        
MFA-TR*            ,:AT-ACCT-XFER-TO                                            
MFA-TR*            ,:AT-ACCT-XFER-FROM-LST                                      
MFA-TR*            ,:AT-AR-XFER-IND                                             
MFA-TR*            ,:AT-BNKRPT-CASE-NO                                          
MFA-TR*            ,:AT-BANKRUPTCY-IND                                          
MFA-TR*            ,:AT-JUDGEMENT-CASE-NO                                       
MFA-TR*            ,:AT-JUDGEMENT-IND                                           
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                                       
MFA-TR*            ,:SW-CODE-LONG-DESC                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7100'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_ACCOUNT'      TO TABLE-1                  
                    MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1          
                    MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2          
                    MOVE WS-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1        
                    MOVE WS-COMPANY-NO      TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-ACCT-CURSOR.                                        *        
      ******************************************************************        
       7200-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-GET-ADDR-FORMAT.                                          *        
      ******************************************************************        
       7300-GET-ADDR-FORMAT.                                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) DY.HOUSE_NO,
              DY.ADDR_PREFIX_1,
              DY.ADDR_PREFIX_2,
              DY.STREET_NAME,
              DY.ADDRESS_OVERFLOW,
              DY.ADDR_USAGE_CD,
              DY.STREET_SUFFIX,
              DY.STREET_LOCATION_1,
              DY.STREET_LOCATION_2,
              DY.ZIP_CODE,
              DY.ZIP_CODE_TOKEN                                   
               INTO :DY-HOUSE-NO                                        
                   ,:DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-STREET-NAME                                     
                   ,:DY-ADDRESS-OVERFLOW                                
                   ,:DY-ADDR-USAGE-CD                                   
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-ZIP-CODE                                        
                   ,:DY-ZIP-CODE-TOKEN                                  
               FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                 
                   ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                 
              WHERE HT.ACCOUNT_NO    = :HT-ACCOUNT-NO                   
                AND HT.COMPANY_NO    = :HT-COMPANY-NO                   
                AND DY.ADDRESS_ID    =  HT.ADDRESS_ID                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DY.HOUSE_NO                                                 
MFA-TR*            ,DY.ADDR_PREFIX_1                                            
MFA-TR*            ,DY.ADDR_PREFIX_2                                            
MFA-TR*            ,DY.STREET_NAME                                              
MFA-TR*            ,DY.ADDRESS_OVERFLOW                                         
MFA-TR*            ,DY.ADDR_USAGE_CD                                            
MFA-TR*            ,DY.STREET_SUFFIX                                            
MFA-TR*            ,DY.STREET_LOCATION_1                                        
MFA-TR*            ,DY.STREET_LOCATION_2                                        
MFA-TR*            ,DY.ZIP_CODE                                                 
MFA-TR*            ,DY.ZIP_CODE_TOKEN                                           
MFA-TR*        INTO :DY-HOUSE-NO                                                
MFA-TR*            ,:DY-ADDR-PREFIX-1                                           
MFA-TR*            ,:DY-ADDR-PREFIX-2                                           
MFA-TR*            ,:DY-STREET-NAME                                             
MFA-TR*            ,:DY-ADDRESS-OVERFLOW                                        
MFA-TR*            ,:DY-ADDR-USAGE-CD                                           
MFA-TR*            ,:DY-STREET-SUFFIX                                           
MFA-TR*            ,:DY-STREET-LOCATION-1                                       
MFA-TR*            ,:DY-STREET-LOCATION-2                                       
MFA-TR*            ,:DY-ZIP-CODE                                                
MFA-TR*            ,:DY-ZIP-CODE-TOKEN                                          
MFA-TR*        FROM CSS_NAME_ACCT_XREF HT                                       
MFA-TR*            ,CSS_ADDR_FORMATTED DY                                       
MFA-TR*       WHERE HT.ACCOUNT_NO    = :HT-ACCOUNT-NO                           
MFA-TR*         AND HT.COMPANY_NO    = :HT-COMPANY-NO                           
MFA-TR*         AND DY.ADDRESS_ID    =  HT.ADDRESS_ID                           
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*     QUERYNO 7300                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE HT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE HT-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-GET-CITY.                                                 *        
      ******************************************************************        
       7400-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT A4.TOWN                                           
                     ,A4.STATE                                          
                 INTO :A4-TOWN                                          
                     ,:A4-STATE                                         
                 FROM CSS_ZIP_CODE A4                                   
                WHERE A4.ZIP_CODE       = :DY-ZIP-CODE                  
                  AND A4.ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ZIP_CODE'             TO TABLE-1                
              MOVE 'ZIP_CODE'                 TO TABLE-ELEMENT-1        
              MOVE 'ZIP_CODE_TOKEN'           TO TABLE-ELEMENT-2        
              MOVE DY-ZIP-CODE                TO HOSTVAR-ELEMENT-1      
              MOVE DY-ZIP-CODE-TOKEN          TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-GET-CUST-NO.                                              *        
      ******************************************************************        
       7500-GET-CUST-NO.                                                
                                                                        
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO                                     
                INTO :CU-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCT-XFER-TO                   
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CUSTOMER_NO                                             
MFA-TR*         INTO :CU-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCT-XFER-TO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCT-XFER-TO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7600-GET-CUST-NAME.                                            *        
      ******************************************************************        
       7600-GET-CUST-NAME.                                              
                                                                        
           EXEC SQL                                                     
              SELECT CASE DQ.NAME_FORMAT                                
                     WHEN 'I' THEN RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME)                     
                     WHEN 'B' THEN DQ.FULL_NAME                         
                     END                                                
                INTO :DQ-FULL-NAME                                       
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
                    ,CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   
                 AND CU.NAME_ID     = DQ.NAME_ID                        
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ025
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASE DQ.NAME_FORMAT                                        
MFA-TR*              WHEN 'I' THEN RTRIM(DQ.LAST_NAME) || ', ' ||               
MFA-TR*                       RTRIM(DQ.FIRST_NAME)  || ' ' ||                   
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME)                             
MFA-TR*              WHEN 'B' THEN DQ.FULL_NAME                                 
MFA-TR*              END                                                        
MFA-TR*         INTO:DQ-FULL-NAME                                               
MFA-TR*         FROM CSS_CUSTOMER CU                                            
MFA-TR*             ,CSS_NAME DQ                                                
MFA-TR*        WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                           
MFA-TR*          AND CU.NAME_ID     = DQ.NAME_ID                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUSTOMER'             TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE CU-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7700-GET-XFER-TO-ACCT.                                         *        
      ******************************************************************        
       7700-GET-XFER-TO-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.ACCT_XFER_TO                                    
                    ,AT.AR_XFER_IND                                     
ACT257              ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :WS-ACCOUNT-XFER-TO                                
                    ,:WS-AR-XFER-IND-FOR-FROM-ACCT                      
ACT257              ,:AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCT-XFER-FROM-LST             
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCT_XFER_TO                                            
MFA-TR*             ,AT.AR_XFER_IND                                             
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*         INTO :WS-ACCOUNT-XFER-TO                                        
MFA-TR*             ,:WS-AR-XFER-IND-FOR-FROM-ACCT                              
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCT-XFER-FROM-LST                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCT-XFER-FROM-LST      TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT257******************************************************************        
ACT257*                                                                *        
ACT257* 7750-CK4-MULTI-XFER2-ACCTS.                                    *        
ACT257******************************************************************        
ACT257 7750-CK4-MULTI-XFER2-ACCTS.                                      
ACT257                                                                  
ACT257     EXEC SQL                                                     
ACT257        SELECT COUNT(*)                                           
ACT257          INTO :WS-FROM-COUNTER                                   
ACT257          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
ACT257         WHERE AT.ACCT_XFER_TO = :AT-ACCOUNT-NO                   
ACT257                                                           
ACT257                                                      
ACT257     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-FROM-COUNTER                                           
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCT_XFER_TO = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT257                                                                  
ACT257     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
ACT257                                                                  
ACT257     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT257        CONTINUE                                                  
ACT257     ELSE                                                         
ACT257        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
ACT257        MOVE '7750'                     TO ACTIVE-PARAGRAPH       
ACT257        MOVE 'SELECT'                   TO ABEND-FUNCTION         
ACT257        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
ACT257        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
ACT257        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
ACT257        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
ACT257     END-IF.                                                      
ACT257                                                                  
ACT257 7750-EXIT.                                                       
ACT257     EXIT.                                                        
ACT257                                                                  
      ******************************************************************        
      *                                                                *        
      * 7800-CHK-ACCT-STAT.                                            *        
      ******************************************************************        
       7800-CHK-ACCT-STAT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) HA.CUSTOMER_NO                                     
                INTO :HA-CUSTOMER-NO                                    
                FROM HST_ACCOUNT HA WITH(READUNCOMMITTED)                       
               WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                     
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HA.CUSTOMER_NO                                             
MFA-TR*         INTO :HA-CUSTOMER-NO                                            
MFA-TR*         FROM HST_ACCOUNT HA                                             
MFA-TR*        WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                             
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'HST_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00936 7810-GET-FULL-BALANCE-A.                                         
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_AR_DAY_00                                
P00936                   + AMT_AR_DAY_30                                
P00936                   + AMT_AR_DAY_60                                
P00936                   + AMT_AR_DAY_90                                
P00936                   + AMT_UNUSED_CR                                
P00936                   + AMT_TRAN_BALANCE                             
P00936                   + TOT_SUMM_UNBILLED)                           
P00936           INTO :WS-FULL-BALANCE-A :WS-NULL-4                      
P00936           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P00936          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
P00936            AND PYMT_PRIORITY_LVL < 50                            
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_AR_DAY_00                                        
MFA-TR*                  + AMT_AR_DAY_30                                        
MFA-TR*                  + AMT_AR_DAY_60                                        
MFA-TR*                  + AMT_AR_DAY_90                                        
MFA-TR*                  + AMT_UNUSED_CR                                        
MFA-TR*                  + AMT_TRAN_BALANCE                                     
MFA-TR*                  + TOT_SUMM_UNBILLED)                                   
MFA-TR*          INTO :WS-FULL-BALANCE-A:WS-NULL-4                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL < 50                                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-4 < 0                                     
P00936                MOVE ZEROS TO WS-FULL-BALANCE-A                   
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            WS-FULL-BALANCE-A                     
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7810'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7810-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936 7820-GET-FULL-BALANCE-B.                                         
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_TRAN_BALANCE)                            
P00936           INTO :WS-FULL-BALANCE-B :WS-NULL-5                      
P00936           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P00936          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
P00936            AND PYMT_PRIORITY_LVL > 49                            
P00936            AND ITEM_ID > 0                                       
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRAN_BALANCE)                                    
MFA-TR*          INTO :WS-FULL-BALANCE-B:WS-NULL-5                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL > 49                                    
MFA-TR*           AND ITEM_ID > 0                                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-5 < 0                                     
P00936                MOVE ZEROS TO WS-FULL-BALANCE-B                   
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            WS-FULL-BALANCE-B                     
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7820'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7820-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*   7830-GET-ACCT-DTLS.                                          *        
P00936******************************************************************        
P00936 7830-GET-ACCT-DTLS.                                              
P00936     MOVE '7830'                          TO ACTIVE-PARAGRAPH.    
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
P00936              ,CODE_ACCT_STAT                                     
P00936              ,TOTAL_AR_BALANCE                                   
P00936         INTO  :AT-ACCT-CREATE-DT :WS-NULL-1                       
P00936              ,:AT-CODE-ACCT-STAT                                 
P00936              ,:AT-TOTAL-AR-BALANCE                               
P00936         FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                          
P00936        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ACCT_CREATE_DT                                             
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,TOTAL_AR_BALANCE                                           
MFA-TR*        INTO  :AT-ACCT-CREATE-DT:WS-NULL-1                               
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*        FROM  CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936        IF WS-NULL-1 < 0                                          
P00936           MOVE SPACES TO AT-ACCT-CREATE-DT                       
P00936        END-IF                                                    
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
P00936        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00936        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936 7830-EXIT.                                                       
P00936     EXIT.                                                        
HPCCDM*EJECT                                                                    
P00936 7850-WO-FULL-BALANCE.                                            
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_TRANS)                                   
P00936           INTO :CO-AMT-TRANS :WS-NULL-6                           
P00936           FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
P00936          WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRANS)                                           
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-6                                   
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-6 < 0                                     
P00936                MOVE ZEROS TO CO-AMT-TRANS                        
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            CO-AMT-TRANS                          
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7850'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_CHRG_OFF'       TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE CO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7850-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936******************************************************************        
P00936*   7900-SELECT-DQ-ROW.                                          *        
P00936*                                                                *        
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
P00936*   CSS_NAME TABLE                                            *           
P00936******************************************************************        
P00936 7900-SELECT-DQ-ROW.                                              
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       SELECT  DQ.FULL_NAME,                                      
P00936               DQ.NAME_FORMAT,                                    
P00936               DQ.LAST_NAME,                                      
P00936               DQ.FIRST_NAME,                                     
P00936               DQ.MIDDLE_NAME,                                    
P00936               DQ.TITLE_PREFIX,                                   
P00936               DQ.TITLE_SUFFIX_1,                                 
P00936               DQ.TITLE_SUFFIX_2,                                 
P00936               HT.ADDRESS_ID                                      
P00936         INTO  :DQ-FULL-NAME,                                     
P00936               :DQ-NAME-FORMAT,                                   
P00936               :DQ-LAST-NAME,                                     
P00936               :DQ-FIRST-NAME,                                    
P00936               :DQ-MIDDLE-NAME,                                   
P00936               :DQ-TITLE-PREFIX,                                  
P00936               :DQ-TITLE-SUFFIX-1,                                
P00936               :DQ-TITLE-SUFFIX-2,                                
P00936               :HT-ADDRESS-ID                                     
P00936         FROM  CSS_NAME DQ,                                       
P00936               CSS_NAME_ACCT_XREF HT                              
P00936        WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO               
P00936          AND  HT.NAME_ID          = DQ.NAME_ID                   
P00936          AND  HT.CUSTOMER_ROLE_CD = ' '                          
P00936          AND  DQ.NAME_TYPE        = 'CN'                         
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936                                 OR NOT-FOUND                     
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_NAME'           TO TABLE-1                      
P00936        MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
P00936        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00936        MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936 7900-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************13550000
P00936*   7910-SELECT-BQ-ROW.                                          *13560000
P00936*                                                                *13570000
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *13580000
P00936*   CSS_BANKRUPTCY TABLE                                         *13590000
P00936******************************************************************13600000
P00936 7910-SELECT-BQ-ROW.                                              
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT  FILED_CASE_NO,                                   
P00936               BANKRUPTCY_CHAPTER,                                
P00936               DATE_BNKRPT_FILED,                                 
P00936               RECEIVED_DATE,                                     
P00936               USER_ID_INIT_BY                                    
P00936         INTO  :BQ-FILED-CASE-NO,                                 
P00936               :BQ-BANKRUPTCY-CHAPTER,                            
P00936               :BQ-DATE-BNKRPT-FILED,                             
P00936               :BQ-RECEIVED-DATE,                                 
P00936               :BQ-USER-ID-INIT-BY                                
P00936         FROM  CSS_BANKRUPTCY                                     
P00936        WHERE  BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO                
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                 13760000
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                 13780000
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00936        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00936        MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
P00936        MOVE 'BANKRPT_CASE_NO'     TO TABLE-ELEMENT-1             
P00936        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
P00936        MOVE BQ-BNKRPT-CASE-NO     TO HOSTVAR-ELEMENT-1           
P00936        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936 7910-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*   7920-SELECT-JU-ROW.                                          *        
P00936*                                                                *        
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
P00936*   CSS_JUDGEMENT TABLE                                          *        
P00936******************************************************************        
P00936 7920-SELECT-JU-ROW.                                              
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       SELECT  FILED_CASE_NO,                                     
P00936               JUDGEMENT_FILED_DT,                                
P00936               USER_ID_INIT_BY                                    
P00936         INTO  :JU-FILED-CASE-NO,                                 
P00936               :JU-JUDGEMENT-FILED-DT,                            
P00936               :JU-USER-ID-INIT-BY                                
P00936         FROM  CSS_JUDGEMENT                                      
P00936        WHERE  JUDGEMENT_CASE_NO = :JU-JUDGEMENT-CASE-NO          
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P00936         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00936         MOVE 'CSS_JUDGEMENT'       TO TABLE-1                    
P00936         MOVE 'JUDGEMENT_CASE_NO'   TO TABLE-ELEMENT-1            
P00936         MOVE JU-JUDGEMENT-CASE-NO  TO HOSTVAR-ELEMENT-1          
P00936         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
P00936         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2          
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00936     END-IF.                                                      
P00936                                                                  
P00936 7920-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*   7930-ACCOUNT-TYPE.                                           *        
P00936*                                                                *        
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
ACT282*   CSS_SO_CODE_DESC TABLE                                       *        
P00936******************************************************************        
P00936                                                                  
P00936 7930-ACCOUNT-TYPE.                                               
P00936                                                                  
P00936     EXEC SQL                                                     
ACT282        SELECT TOP(1) CODE_LONG_DESC                                     
ACT282          INTO :SW-CODE-LONG-DESC                                 
ACT282          FROM CSS_SO_CODE_DESC                                   
ACT282         WHERE CODE_VALUE = :SW-CODE-VALUE                        
ACT282           AND TABLE_NA   = 'CSS_ACCOUNT'                         
ACT282           AND COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                   
ACT282           AND PROGRAM_ID = 'ALL'                                 
ACT282           AND COMPANY_NO = '01'                                  
ACT282                                           
ACT282                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_LONG_DESC                                             
MFA-TR*         INTO :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_SO_CODE_DESC                                           
MFA-TR*        WHERE CODE_VALUE = :SW-CODE-VALUE                                
MFA-TR*          AND TABLE_NA   = 'CSS_ACCOUNT'                                 
MFA-TR*          AND COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                           
MFA-TR*          AND PROGRAM_ID = 'ALL'                                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         QUERYNO 7930                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             CONTINUE                                             
P00936         WHEN NOT-FOUND                                           
ACT282             MOVE SPACES            TO SW-CODE-LONG-DESC          
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P00936             MOVE 'SELECT'              TO ABEND-FUNCTION         
P00936             MOVE SPACES                TO ABEND-SQL-PREDICATES   
P00936                                                ABEND-TABLES      
ACT282             MOVE 'CSS_SO_CODE_DESC'    TO TABLE-1                
ACT282             MOVE 'TABLE_NA'            TO TABLE-ELEMENT-1        
ACT282             MOVE 'COLUMN_NA'           TO TABLE-ELEMENT-2        
ACT282             MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3        
ACT282             MOVE 'CODE_VALUE'          TO TABLE-ELEMENT-4        
ACT282             MOVE 'CSS_ACCOUNT'         TO HOSTVAR-ELEMENT-1      
ACT282             MOVE 'ACCOUNT_TYPE_CODE'   TO HOSTVAR-ELEMENT-2      
ACT282             MOVE '01'                  TO HOSTVAR-ELEMENT-3      
ACT282             MOVE SW-CODE-VALUE         TO HOSTVAR-ELEMENT-4      
P00936             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00936             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7930-EXIT.                                                       
P00936     EXIT.                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04605_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04605_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04605_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND.RESULT.                                              .        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04605_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,ACCOUNT_NUMBER                                      
                   ,CODE_ACCT_STAT                                      
                   ,ADDRESS                                             
                   ,CITY                                                
                   ,STATE                                               
                   ,ZIP_CODE                                            
                   ,CREDIT_GROUP                                        
                   ,CREDIT_STATUS                                       
                   ,TOTAL_AR_BALANCE                                    
                   ,COMPANY_NO                                          
                   ,MST_SUB_IND                                         
                   ,ACCT_XFER_TO                                        
                   ,ACCT_XFER_TO_ARCHVD                                 
                   ,XFER_TO_CUST_NO                                     
                   ,FULL_NAME                                           
                   ,ACCT_XFER_FROM_LST                                  
ACT257             ,ACCT_XFER_FROM_TS                                   
                   ,ACCT_XFER_FROM_ARCHVD                               
ACT257             ,ACCT_XFER_COUNTER                                   
P00936             ,BNKRPT_CASE_NO                                      
P00936             ,BNKRPT_IND                                          
P00936             ,JDGMNT_CASE_NO                                      
P00936             ,JDGMNT_IND                                          
P00936             ,NAME_ID                                             
P00936             ,ACCT_TYPE                                           
P00936             ,ACCT_TYPE_DESC                                      
P00936             ,CUSTOMER_NO                                         
P00936             ,ACCOUNT_BALANCE                                     
P00936             ,ACCT_CREATE_DT                                      
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-ACCOUNT-NO                                       
                   ,:S-CODE-ACCT-STAT                                   
                   ,:S-ADDRESS                                          
                   ,:S-CITY                                             
                   ,:S-STATE                                            
                   ,:S-ZIP-CODE                                         
                   ,:S-CREDIT-GROUP                                     
                   ,:S-CREDIT-STATUS                                    
                   ,:S-TOTAL-AR-BALANCE                                 
                   ,:S-COMPANY-NO                                       
                   ,:S-MST-SUB-IND                                      
                   ,:S-ACCT-XFER-TO                                     
                   ,:S-ACCT-XFER-TO-ARCHVD                              
                   ,:S-XFER-TO-CUST-NO                                  
                   ,:S-FULL-NAME                                        
                   ,:S-ACCT-XFER-FROM-LST                               
ACT257             ,:S-ACCT-XFER-FROM-TS                                
ACT257             ,:S-ACCT-XFER-FROM-ARCHVD                            
ACT257             ,:S-ACCT-XFER-COUNTER                                
P00936             ,:S-BNKRPT-CASE-NO                                   
P00936             ,:S-BNKRPT-IND                                       
P00936             ,:S-JDGMNT-CASE-NO                                   
P00936             ,:S-JDGMNT-IND                                       
P00936             ,:S-NAME                                             
P00936             ,:S-ACCT-TYPE                                        
P00936             ,:S-ACCT-TYPE-DESC                                   
P00936             ,:S-CUSTOMER-NO                                      
P00936             ,:S-ACCOUNT-BALANCE                                  
P00936             ,:S-CREATE-DT                                        
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04605_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,ACCOUNT_NUMBER                                              
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,ADDRESS                                                     
MFA-TR*            ,CITY                                                        
MFA-TR*            ,STATE                                                       
MFA-TR*            ,ZIP_CODE                                                    
MFA-TR*            ,CREDIT_GROUP                                                
MFA-TR*            ,CREDIT_STATUS                                               
MFA-TR*            ,TOTAL_AR_BALANCE                                            
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,MST_SUB_IND                                                 
MFA-TR*            ,ACCT_XFER_TO                                                
MFA-TR*            ,ACCT_XFER_TO_ARCHVD                                         
MFA-TR*            ,XFER_TO_CUST_NO                                             
MFA-TR*            ,FULL_NAME                                                   
MFA-TR*            ,ACCT_XFER_FROM_LST                                          
MFA-TR*            ,ACCT_XFER_FROM_TS                                           
MFA-TR*            ,ACCT_XFER_FROM_ARCHVD                                       
MFA-TR*            ,ACCT_XFER_COUNTER                                           
MFA-TR*            ,BNKRPT_CASE_NO                                              
MFA-TR*            ,BNKRPT_IND                                                  
MFA-TR*            ,JDGMNT_CASE_NO                                              
MFA-TR*            ,JDGMNT_IND                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,ACCT_TYPE                                                   
MFA-TR*            ,ACCT_TYPE_DESC                                              
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,ACCOUNT_BALANCE                                             
MFA-TR*            ,ACCT_CREATE_DT                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-CODE-ACCT-STAT                                           
MFA-TR*            ,:S-ADDRESS                                                  
MFA-TR*            ,:S-CITY                                                     
MFA-TR*            ,:S-STATE                                                    
MFA-TR*            ,:S-ZIP-CODE                                                 
MFA-TR*            ,:S-CREDIT-GROUP                                             
MFA-TR*            ,:S-CREDIT-STATUS                                            
MFA-TR*            ,:S-TOTAL-AR-BALANCE                                         
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-MST-SUB-IND                                              
MFA-TR*            ,:S-ACCT-XFER-TO                                             
MFA-TR*            ,:S-ACCT-XFER-TO-ARCHVD                                      
MFA-TR*            ,:S-XFER-TO-CUST-NO                                          
MFA-TR*            ,:S-FULL-NAME                                                
MFA-TR*            ,:S-ACCT-XFER-FROM-LST                                       
MFA-TR*            ,:S-ACCT-XFER-FROM-TS                                        
MFA-TR*            ,:S-ACCT-XFER-FROM-ARCHVD                                    
MFA-TR*            ,:S-ACCT-XFER-COUNTER                                        
MFA-TR*            ,:S-BNKRPT-CASE-NO                                           
MFA-TR*            ,:S-BNKRPT-IND                                               
MFA-TR*            ,:S-JDGMNT-CASE-NO                                           
MFA-TR*            ,:S-JDGMNT-IND                                               
MFA-TR*            ,:S-NAME                                                     
MFA-TR*            ,:S-ACCT-TYPE                                                
MFA-TR*            ,:S-ACCT-TYPE-DESC                                           
MFA-TR*            ,:S-CUSTOMER-NO                                              
MFA-TR*            ,:S-ACCOUNT-BALANCE                                          
MFA-TR*            ,:S-CREATE-DT                                                
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                    TO CTR-ROWS                     
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04605_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
