       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04601.                                     
COB303 DATE-WRITTEN.  JAN 14,2013                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS BUDGET BILLING ESTIMATION FOR CSR ONLY.  *        
      *  RESULT SET:                                                   *        
      *      1. SMALL USAGE (< 1400 SFT) -  BBP ESTIMATION AMOUNT.     *        
      *      2. MEDIUM USAGE(1400 - 2,399 SFT) - BBP ESTIMATION AMOUNT.*        
      *      3. LARGE USAGE (> 2,400 SFT) - BBP ESTIMATION AMOUNT.     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00694*  01/14/13  VV94890    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04601'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04601 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_AVERAGE_USAGE, 2Y                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBAVGUSE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_UTIL_ENVRNMT,UT                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MTRD_ENVRNMT,MN                                           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************00800000
      *    CSS_DELINQUENCY - C8                                        *00810000
      ******************************************************************00820000
      *                                                                 00860000
           EXEC SQL                                                     00830000
              INCLUDE TBDELQ                                            00840000
           END-EXEC.                                                    00850000
      *                                                                 00860000
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                 00860000
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                 00860000
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04601'.      
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-HOUSE-SIZE-CD        PIC X(01) VALUE SPACES.          
           05  WS-AVERAGE-USAGE        PIC S9(7)V99 COMP-3 VALUE 0.     
           05  WS-SMALL-USAGE          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-MEDIUM-USAGE         PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-LARGE-USAGE          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-SMALL-USG-CHG        PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-MEDIUM-USG-CHG       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-LARGE-USG-CHG        PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-SMALL-USAGE-RND      PIC S9(11) COMP-3 VALUE +0.      
           05  WS-MEDIUM-USAGE-RND     PIC S9(11) COMP-3 VALUE +0.      
           05  WS-LARGE-USAGE-RND      PIC S9(11) COMP-3 VALUE +0.      
           05  WS-ELE-SML-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-ELE-MDM-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-ELE-LRG-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-SML-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-MDM-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-LRG-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-ELE-SML-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-ELE-MDM-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-ELE-LRG-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-SML-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-MDM-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-LRG-EST          PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-SCEG-ELE-UNIT-PRICE  PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-SCEG-ELE-BFC-CHARGE  PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-UNIT-PRICE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-GAS-BFC-CHARGE       PIC S9(4)V9(5) COMP-3 VALUE 0.   
           05  WS-TOT-UNMTR-CHARGES    PIC S9(7)V99 COMP-3 VALUE 0.     
           05  WS-NULL-IND             PIC S9(4) COMP.                  
      *                                                                         
       01  WS-FLAG-VALUES.                                              
           05  WS-SCEG                 PIC X(02) VALUE '01'.            
           05  WS-PSNC                 PIC X(02) VALUE '26'.            
           05  WS-ELEC                 PIC X(01) VALUE 'E'.             
           05  WS-GAS                  PIC X(01) VALUE 'G'.             
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SMALL-USAGE          PIC S9(7)V99 COMP-3 VALUE 0.     
           05  RS-MEDIUM-USAGE         PIC S9(7)V99 COMP-3 VALUE 0.     
           05  RS-LARGE-USAGE          PIC S9(7)V99 COMP-3 VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-SMALL-USAGE           PIC S9(7)V99 COMP-3 VALUE 0.     
           05  S-MEDIUM-USAGE          PIC S9(7)V99 COMP-3 VALUE 0.     
           05  S-LARGE-USAGE           PIC S9(7)V99 COMP-3 VALUE 0.     
                                                                        
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  WS-EOF-CURSOR           PIC X(01) VALUE 'N'.             
               88 NO-MORE-DATA                   VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE UTIL-CURSOR CURSOR FOR                            
               SELECT UT.CODE_UTIL_TYPE,                                
                      UT.CODE_REVENUE_CLASS,                            
                      UT.COMPANY_NO                                     
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                
                  AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND MN.IC_NO      = UT.IC_NO                          
                  AND UT.CODE_UTIL_TYPE IN ('E','G')                    
                  AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE             
                  AND MN.CODE_METER_STATUS = 'A'                        
                  AND MN.CODE_METER_STATUS NOT IN ('K', 'J')            
                                                                 
                FOR READ ONLY                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT UT.CODE_UTIL_TYPE,                                        
MFA-TR*               UT.CODE_REVENUE_CLASS,                                    
MFA-TR*               UT.COMPANY_NO                                             
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                        
MFA-TR*           AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND MN.IC_NO      = UT.IC_NO                                  
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','G')                            
MFA-TR*           AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                     
MFA-TR*           AND MN.CODE_METER_STATUS = 'A'                                
MFA-TR*           AND MN.CODE_METER_STATUS NOT IN ('K', 'J')                    
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
      *                                                                 00000040
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                 00000010
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,SMALL_USAGE                                          
                  ,MEDIUM_USAGE                                         
                  ,LARGE_USAGE                                          
               FROM #CSR04601_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,SMALL_USAGE                                                  
MFA-TR*           ,MEDIUM_USAGE                                                 
MFA-TR*           ,LARGE_USAGE                                                  
MFA-TR*        FROM SESSION.CSR04601_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
      *                                                                         
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO                                         
               .                                                        
      *                                                                         
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           PERFORM 0100A-DECLARE-GTT                                    
             THRU 0100A-EXIT.                                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT.                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04601_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04601_R1
              (                                                          
               RETURN_CODE              INT                         
              ,SMALL_USAGE              DECIMAL(09,2)                   
              ,MEDIUM_USAGE             DECIMAL(09,2)                   
              ,LARGE_USAGE              DECIMAL(09,2)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00000300
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04601_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
               EXIT.                                                    
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO              
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM          
                                             AT-ACCOUNT-NO              
                                             CP-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                TO ACTIVE-PARAGRAPH               
      *                                                                         
           PERFORM 7600-GET-ACCOUNT-DET          THRU 7600-EXIT         
      *                                                                         
           MOVE AT-COMPANY-NO         TO C8-COMPANY-NO                  
           PERFORM 2400-PROCESS-DELINQ           THRU 2400-EXIT         
      *                                                                         
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE ZEROES                  TO S-RETURN-CODE               
            MOVE RS-SMALL-USAGE          TO S-SMALL-USAGE               
            MOVE RS-MEDIUM-USAGE         TO S-MEDIUM-USAGE              
            MOVE RS-LARGE-USAGE          TO S-LARGE-USAGE.              
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE 'N'                         TO WS-EOF-CURSOR            
      *                                                                         
           PERFORM 7100-OPEN-UTIL-CURSOR         THRU 7100-EXIT         
           PERFORM 7200-FETCH-UTIL-CURSOR        THRU 7200-EXIT         
           IF NO-MORE-DATA                                              
              MOVE AT-COMPANY-NO  TO UT-COMPANY-NO                      
              IF AT-COMPANY-NO = '01'                                   
                 MOVE 'E'      TO  UT-CODE-UTIL-TYPE                    
                 MOVE '010'    TO  UT-CODE-REVENUE-CLASS                
                 PERFORM 2300-PROCESS-AVG-EST    THRU 2300-EXIT         
                 MOVE 'G'      TO  UT-CODE-UTIL-TYPE                    
                 MOVE '010'    TO  UT-CODE-REVENUE-CLASS                
                 PERFORM 2300-PROCESS-AVG-EST    THRU 2300-EXIT         
              ELSE                                                      
                 MOVE 'G'      TO  UT-CODE-UTIL-TYPE                    
                 MOVE '712'    TO  UT-CODE-REVENUE-CLASS                
                 PERFORM 2300-PROCESS-AVG-EST    THRU 2300-EXIT         
              END-IF                                                    
           ELSE                                                         
              PERFORM UNTIL NO-MORE-DATA                                
                 PERFORM 2300-PROCESS-AVG-EST    THRU 2300-EXIT         
                 PERFORM 7200-FETCH-UTIL-CURSOR  THRU 7200-EXIT         
              END-PERFORM                                               
           END-IF                                                       
           PERFORM 7300-CLOSE-UTIL-CURSOR        THRU 7300-EXIT         
      *                                                                         
           IF AT-REV-MTH-LST-NRML > 0                                   
              PERFORM 7700-SELECT-UNMTR-CHARGES  THRU 7700-EXIT         
           ELSE                                                         
              MOVE ZEROES             TO WS-TOT-UNMTR-CHARGES           
           END-IF                                                       
      *                                                                         
           COMPUTE WS-SMALL-USAGE-RND ROUNDED  =                        
                             WS-SMALL-USG-CHG  + WS-TOT-UNMTR-CHARGES   
           COMPUTE WS-MEDIUM-USAGE-RND ROUNDED =                        
                             WS-MEDIUM-USG-CHG + WS-TOT-UNMTR-CHARGES   
           COMPUTE WS-LARGE-USAGE-RND ROUNDED  =                        
                             WS-LARGE-USG-CHG  + WS-TOT-UNMTR-CHARGES   
      *                                                                         
           MOVE WS-SMALL-USAGE-RND    TO RS-SMALL-USAGE                 
           MOVE WS-MEDIUM-USAGE-RND   TO RS-MEDIUM-USAGE                
           MOVE WS-LARGE-USAGE-RND    TO RS-LARGE-USAGE                 
      *                                                                         
           IF CTR-ROWS < 1                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE SQLCODE  TO RS-RETURN-CODE                           
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-AVG-EST                                           *        
      ******************************************************************        
       2300-PROCESS-AVG-EST.                                            
      *                                                                         
           MOVE '2300'                   TO ACTIVE-PARAGRAPH            
           MOVE ZEROES                   TO WS-ELE-SML-CHARGE           
                                            WS-ELE-MDM-CHARGE           
                                            WS-ELE-LRG-CHARGE           
                                            WS-GAS-SML-CHARGE           
                                            WS-GAS-MDM-CHARGE           
                                            WS-GAS-LRG-CHARGE           
      *                                                                         
           IF AT-COMPANY-NO = WS-SCEG AND UT-CODE-UTIL-TYPE = WS-ELEC   
      *                                                                         
              MOVE 'S'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
              COMPUTE  WS-ELE-SML-CHARGE  =                             
                      ( ( ( WS-AVERAGE-USAGE / 12 ) *                   
                           WS-SCEG-ELE-UNIT-PRICE ) +                   
                           WS-SCEG-ELE-BFC-CHARGE )                     
              COMPUTE WS-ELE-SML-EST = WS-ELE-SML-CHARGE +              
                                              WS-ELE-SML-EST            
      *                                                                         
              MOVE 'M'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
              COMPUTE  WS-ELE-MDM-CHARGE =                              
                      ( ( ( WS-AVERAGE-USAGE / 12 ) *                   
                           WS-SCEG-ELE-UNIT-PRICE ) +                   
                           WS-SCEG-ELE-BFC-CHARGE )                     
              COMPUTE WS-ELE-MDM-EST = WS-ELE-MDM-CHARGE +              
                                              WS-ELE-MDM-EST            
      *                                                                         
              MOVE 'L'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
              COMPUTE  WS-ELE-LRG-CHARGE =                              
                      ( ( ( WS-AVERAGE-USAGE / 12 ) *                   
                           WS-SCEG-ELE-UNIT-PRICE ) +                   
                           WS-SCEG-ELE-BFC-CHARGE )                     
              COMPUTE WS-ELE-LRG-EST = WS-ELE-LRG-CHARGE +              
                                              WS-ELE-LRG-EST            
           ELSE                                                         
              MOVE 'S'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
              COMPUTE  WS-GAS-SML-CHARGE =                              
                      ( ( ( WS-AVERAGE-USAGE / 12 ) *                   
                           WS-GAS-UNIT-PRICE ) +                        
                           WS-GAS-BFC-CHARGE )                          
              COMPUTE WS-GAS-SML-EST = WS-GAS-SML-CHARGE +              
                                              WS-GAS-SML-EST            
      *                                                                         
              MOVE 'M'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
             COMPUTE  WS-GAS-MDM-CHARGE =                               
                     ( ( ( WS-AVERAGE-USAGE / 12 ) *                    
                          WS-GAS-UNIT-PRICE ) +                         
                          WS-GAS-BFC-CHARGE )                           
              COMPUTE WS-GAS-MDM-EST = WS-GAS-MDM-CHARGE +              
                                              WS-GAS-MDM-EST            
      *                                                                         
              MOVE 'L'               TO WS-HOUSE-SIZE-CD                
              PERFORM 7400-AVG-USAGE        THRU 7400-EXIT              
              COMPUTE  WS-GAS-LRG-CHARGE =                              
                      ( ( ( WS-AVERAGE-USAGE / 12 ) *                   
                           WS-GAS-UNIT-PRICE ) +                        
                           WS-GAS-BFC-CHARGE )                          
              COMPUTE WS-GAS-LRG-EST = WS-GAS-LRG-CHARGE +              
                                              WS-GAS-LRG-EST            
      *                                                                         
           END-IF                                                       
      *                                                                         
           COMPUTE WS-SMALL-USG-CHG  = WS-ELE-SML-EST + WS-GAS-SML-EST  
           COMPUTE WS-MEDIUM-USG-CHG = WS-ELE-MDM-EST + WS-GAS-MDM-EST  
           COMPUTE WS-LARGE-USG-CHG  = WS-ELE-LRG-EST + WS-GAS-LRG-EST. 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-DELINQ                                            *        
      ******************************************************************        
       2400-PROCESS-DELINQ.                                             
      *                                                                         
           MOVE '2400'                TO ACTIVE-PARAGRAPH               
      *                                                                         
           MOVE ZERO                  TO WS-SCEG-ELE-UNIT-PRICE         
                                         WS-SCEG-ELE-BFC-CHARGE         
                                         WS-GAS-UNIT-PRICE              
                                         WS-GAS-BFC-CHARGE              
      *                                                                         
           IF AT-COMPANY-NO = WS-SCEG                                   
              MOVE 'SCEG-ELE-UNIT-PRICE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-SCEG-ELE-UNIT-PRICE      
              MOVE 'SCEG-ELE-BFC-CHARGE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-SCEG-ELE-BFC-CHARGE      
              MOVE 'SCEG-GAS-UNIT-PRICE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-GAS-UNIT-PRICE           
              MOVE 'SCEG-GAS-BFC-CHARGE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-GAS-BFC-CHARGE           
           ELSE                                                         
              MOVE 'PSNC-GAS-UNIT-PRICE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-GAS-UNIT-PRICE           
              MOVE 'PSNC-GAS-BFC-CHARGE' TO C8-DELINQ-CD                
              PERFORM 7500-GET-DELINQ-VALUE         THRU 7500-EXIT      
              MOVE C8-DELINQ-VALUE       TO WS-GAS-BFC-CHARGE           
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-UTIL-CURSOR                                          *        
      ******************************************************************        
       7100-OPEN-UTIL-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              OPEN UTIL-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-UTIL-CURSOR                                         *        
      ******************************************************************        
       7200-FETCH-UTIL-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH UTIL-CURSOR                                        
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-CODE-REVENUE-CLASS,                            
                     :UT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7200'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1     
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-UTIL-CURSOR                                         *        
      ******************************************************************        
       7300-CLOSE-UTIL-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE UTIL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-AVG-USAGE.                                                *        
      ******************************************************************        
       7400-AVG-USAGE.                                                  
      *                                                                         
           MOVE ZEROES                     TO WS-AVERAGE-USAGE.         
      *                                                                         
           EXEC SQL                                                     
               SELECT AVERAGE_USAGE                                     
                 INTO :WS-AVERAGE-USAGE                                 
                 FROM CSS_AVERAGE_USAGE WITH(READUNCOMMITTED)                   
                WHERE COMPANY_NO         = :UT-COMPANY-NO               
                  AND CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE           
                  AND CODE_REVENUE_CLASS = :UT-CODE-REVENUE-CLASS       
                  AND HOUSE_SIZE_CD      = :WS-HOUSE-SIZE-CD            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AVERAGE_USAGE                                             
MFA-TR*          INTO :WS-AVERAGE-USAGE                                         
MFA-TR*          FROM CSS_AVERAGE_USAGE                                         
MFA-TR*         WHERE COMPANY_NO         = :UT-COMPANY-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE                   
MFA-TR*           AND CODE_REVENUE_CLASS = :UT-CODE-REVENUE-CLASS               
MFA-TR*           AND HOUSE_SIZE_CD      = :WS-HOUSE-SIZE-CD                    
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE ZEROES TO WS-AVERAGE-USAGE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AVERAGE_USAGE'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-GET-DELINQ-VALUE                                         *         
      *     SELECTS VALUES FROM CSS_DELINQUENCY                       *         
      *****************************************************************         
      *                                                                         
       7500-GET-DELINQ-VALUE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2          
               MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
               MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-GET-ACCOUNT-DET                                           *        
      ******************************************************************        
      *                                                                         
       7600-GET-ACCOUNT-DET.                                            
      *                                                                         
            EXEC SQL                                                    
                 SELECT                                                 
                         AT.COMPANY_NO                                  
                        ,AT.CODE_ACCT_STAT                              
                        ,AT.REV_MTH_LST_NRML                            
                   INTO                                                 
                         :AT-COMPANY-NO                                 
                        ,:AT-CODE-ACCT-STAT                             
                        ,:AT-REV-MTH-LST-NRML                           
                   FROM                                                 
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                  WHERE                                                 
                        AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT                                                         
MFA-TR*                  AT.COMPANY_NO                                          
MFA-TR*                 ,AT.CODE_ACCT_STAT                                      
MFA-TR*                 ,AT.REV_MTH_LST_NRML                                    
MFA-TR*            INTO                                                         
MFA-TR*                  :AT-COMPANY-NO                                         
MFA-TR*                 ,:AT-CODE-ACCT-STAT                                     
MFA-TR*                 ,:AT-REV-MTH-LST-NRML                                   
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ACCOUNT AT                                          
MFA-TR*           WHERE                                                         
MFA-TR*                 AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7600                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN OTHER                                                 
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '7600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7700-SELECT-BILL-DATE                                          *        
      ******************************************************************        
       7700-SELECT-UNMTR-CHARGES.                                       
      *                                                                         
           MOVE '7700'          TO ACTIVE-PARAGRAPH                     
           MOVE ZEROES          TO WS-TOT-UNMTR-CHARGES                 
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(BG.AMT_BILL_ITEM)                            
                INTO :WS-TOT-UNMTR-CHARGES :WS-NULL-IND                 
                FROM  CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
                     ,CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE BI.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                AND   BG.ACCOUNT_NO         = BI.ACCOUNT_NO             
                AND   BI.BILL_NO = (SELECT MAX(B1.BILL_NO)              
                                     FROM CSS_BILLING_HDR B1
                           WITH(READUNCOMMITTED)            
                                    WHERE B1.ACCOUNT_NO = BI.ACCOUNT_NO 
                                      AND B1.DATE_BILLED IS NOT NULL)   
                AND   BG.BILL_NO            =  BI.BILL_NO               
                AND  (BG.CODE_UTIL_TYPE     = 'U'                       
                     OR  (BG.CODE_UTIL_TYPE = 'E'                       
                     AND CIS.SUBSTR3(
           BG.RATE_PLAN_NO,1,2) IN ('68','69')))   
                AND BG.CODE_BILL_CALC       = 'A'                       
                AND BG.CODE_BILL_ITM_TYPE   = 'C'                       
                AND BG.CODE_BILL_ITM_IND    = 'A'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BG.AMT_BILL_ITEM)                                    
MFA-TR*         INTO :WS-TOT-UNMTR-CHARGES :WS-NULL-IND                         
MFA-TR*         FROM  CSS_BILLING_HDR BI                                        
MFA-TR*              ,CSS_BILLING_DET BG                                        
MFA-TR*         WHERE BI.ACCOUNT_NO         = :AT-ACCOUNT-NO                    
MFA-TR*         AND   BG.ACCOUNT_NO         = BI.ACCOUNT_NO                     
MFA-TR*         AND   BI.BILL_NO = (SELECT MAX(B1.BILL_NO)                      
MFA-TR*                              FROM CSS_BILLING_HDR B1                    
MFA-TR*                             WHERE B1.ACCOUNT_NO = BI.ACCOUNT_NO         
MFA-TR*                               AND B1.DATE_BILLED IS NOT NULL)           
MFA-TR*         AND   BG.BILL_NO            =  BI.BILL_NO                       
MFA-TR*         AND  (BG.CODE_UTIL_TYPE     = 'U'                               
MFA-TR*              OR  (BG.CODE_UTIL_TYPE = 'E'                               
MFA-TR*              AND SUBSTR(BG.RATE_PLAN_NO,1,2) IN ('68','69')))           
MFA-TR*         AND BG.CODE_BILL_CALC       = 'A'                               
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE   = 'C'                               
MFA-TR*         AND BG.CODE_BILL_ITM_IND    = 'A'                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND        = -1                                
                 MOVE ZEROS TO WS-TOT-UNMTR-CHARGES                     
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +0                      TO WS-TOT-UNMTR-CHARGES    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
              MOVE 'CSS_BILLING_DET'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
      *                                                                         
      ******************************************************************00000100
      * 8100-SEND-RESULT.                                              *00000200
      ******************************************************************00000300
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04601_R1                            
             (                                                          
              RETURN_CODE                                               
             ,SMALL_USAGE                                               
             ,MEDIUM_USAGE                                              
             ,LARGE_USAGE                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-SMALL-USAGE                                            
             ,:S-MEDIUM-USAGE                                           
             ,:S-LARGE-USAGE                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04601_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,SMALL_USAGE                                                       
MFA-TR*      ,MEDIUM_USAGE                                                      
MFA-TR*      ,LARGE_USAGE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-SMALL-USAGE                                                    
MFA-TR*      ,:S-MEDIUM-USAGE                                                   
MFA-TR*      ,:S-LARGE-USAGE                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04601_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1 TO CTR-ROWS.                                           
      *                                                                 00002000
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00002000
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04601_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04601_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04601_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
