       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04600.                                     
COB303 DATE-WRITTEN. JAN 26, 2013.                                      
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04600              -- 00090000
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--  CSR04600 :                                                -- 00130000
      *--                                                            -- 00140000
      *--  #  RETRIEVES BBP PROJECTED COST FOR SEB ACCOUNTS.         -- 00150000
      *--  #  CALCULATES THE EPP ESTIMATE AND USAGE HISTORY.         -- 00160000
      *--  #  LOCAL - IF EXISTING CUSTOMERS, UTILIZES EXISTING  DATA -- 00170000
      *--             ALONG WITH SOME ESTIMATION.                    -- 00171000
      *--  #  GLOBAL - FOR NON-CUSTOMERS, ESTIMATES THE BBP AMOUNT.  -- 00180000
      *--                                                             - 00191000
      *---------------------------------------------------------------- 00200000
      *--                                                            -- 00210000
      *--  PARAMETERS                                                -- 00220000
      *--                                                            -- 00230000
      *--      IN                                                    -- 00240000
      *--                                                            -- 00250000
      *--            CHANNEL                                         -- 00260000
      *--            ACCOUNT-NO                                      -- 00270000
      *--            OPTION-CD                                       -- 00280000
      *--            RATE-PRICE                                      -- 00290000
      *--            DDDC                                            -- 00300000
      *--            CUST-SVC-FEE                                    -- 00310000
      *--            ZIP-CODE                                        -- 00320000
      *--                                                            -- 00330000
      *--      OUT                                                   -- 00340000
      *--                                                            -- 00350000
      *--            NONE                                            -- 00360000
      *--                                                            -- 00370000
      *--      INOUT                                                 -- 00380000
      *--                                                            -- 00390000
      *--            NONE                                            -- 00400000
      *--                                                            -- 00410000
      *--  RESULT SET                                                -- 00420000
      *--                                                            -- 00430000
      *--      2                                                     -- 00440000
      *--                                                            -- 00450000
      *---------------------------------------------------------------- 00470000
      *--                        MODIFICATION LOG                    -- 00480000
      *--                                                            -- 00490000
      *--  DATE          INITIALS    COMMENTS                        -- 00500000
      *--  -----------   --------    ---------------------------------- 00510000
      *--  01/14/2013    VENKAT      PROCEDURE ORIGINALLY CODED.     -- 00520000
      *--  ****P0694**** VUDDANDAPU                                  -- 00520100
      *--                                                            -- 00521000
BBPFIX*     04/02/13     VIJAY       APPLY FIXED PRICE CUSTOMERS BUFFER 00522000
BBPFIX*      P00694                  .                                  00523000
A04462*     04/25/13     RH15956     EXCLUDE MV90 BACKUP METERS.        00524000
A04527*     06/07/13     MC95456     REMOVED UNUSED COPY BOOK CWS00056  00524100
A04527*     07/25/13     MR7E794     CLEAN THE CSR CODE.                00524200
ACT111*     05/23/14     VIJAY       APPLY EXIT FEE ONLY ONCE.          00524300
ACT111*      A04880                                                     00524400
ACT250*     08/29/14      VIJAY     POPULATE BG.RT_PKG_OPT_SEQ_NO FROM  00524500
ACT250*      A04880                 UTIL_ENVRNMT WHEN IT IS 0 TO AVOID  00524600
ACT250*                             ABEND IN BILL CALC PROGRAM WHEN PRO-00524700
ACT250*                             CESSING 'EXIT FEE' FACTOR           00524800
ACT267*     09/30/14      VIJAY     DO NOT APPLY EXTCREDTX factor.      00524900
ACT267*      A04880                                                     00525000
ACT277*     10/15/14      VIJAY     APPLY EXIT FEE IF IT RETURNS FROM   00526000
ACT277*      A04880                 BILL CALC INSTEAD OF ONE TIME.      00527000
ACT306*     11/12/14      VIJAY     WHEN CONSUMPTION NOT FOUND(BC0006)  00527104
ACT306*      A04880                 DO NOT ABEND.                       00527204
A04987**    11/14/14      VIJAY     USE PREMISE DDC BEFORE GETTING      00528004
A04987**                            GETTING DEFAULT DDC.                00528102
A04987**    02/10/15      VENKAT.P  FIXED S0C7 ISSUE WITH PREMISE DDDC. 00528103
      ***************************************************************** 00530000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04600'.
MSQ017     COPY MFASQLM.
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
           EXEC SQL                                                     00610000
              INCLUDE SQLCA                                             00620000
           END-EXEC.                                                    00630000
                                                                        
      ******************************************************************00650000
      * CSS_ACCOUNT, AT                                                *00660000
      ******************************************************************00670000
           EXEC SQL                                                     00680000
              INCLUDE TBACCT                                            00690000
           END-EXEC.                                                    00700000
                                                                        
      ******************************************************************00720000
      * CSS_DELINQUENCY, C8                                            *00730000
      ******************************************************************00740000
           EXEC SQL                                                     00750000
              INCLUDE TBDELQ                                            00760000
           END-EXEC.                                                    00770000
                                                                        
      ******************************************************************00790000
      * CSS_BILL_WINDOW, BN                                            *00800000
      ******************************************************************00810000
           EXEC SQL                                                     00820000
              INCLUDE TBBILWDW                                          00830000
           END-EXEC.                                                    00840000
                                                                        
      ******************************************************************00860000
      * CSS_CNSMPTN_HIST, CX                                           *00870000
      ******************************************************************00880000
           EXEC SQL                                                     00890000
              INCLUDE TBCNSMP                                           00900000
           END-EXEC.                                                    00910000
                                                                        
      ******************************************************************01070000
      * CSS_PREMISE, PR                                                *01080000
      ******************************************************************01090000
           EXEC SQL                                                     01100000
              INCLUDE TBPREM                                            01110000
           END-EXEC.                                                    01120000
                                                                        
      ******************************************************************01210000
      * CSS_UTIL_ENVRMNT, UT                                           *01220000
      ******************************************************************01230000
           EXEC SQL                                                     01240000
              INCLUDE TBUTLENV                                          01250000
           END-EXEC.                                                    01260000
                                                                        
      ******************************************************************01420000
      * CSS_BILLING_HDR, BI                                            *01430000
      ******************************************************************01440000
           EXEC SQL                                                     01450000
              INCLUDE TBBLLHDR                                          01460000
           END-EXEC.                                                    01470000
                                                                        
      ******************************************************************01490000
      * CSS_BILLING_DET, BG                                            *01500000
      ******************************************************************01510000
           EXEC SQL                                                     01520000
              INCLUDE TBBLLDET                                          01530000
           END-EXEC.                                                    01540000
                                                                        
      ******************************************************************01560000
      * CSS_MODEL_SQL, MS                                              *01570000
      ******************************************************************01580000
           EXEC SQL                                                     01590000
              INCLUDE TBMODEL                                           01600000
           END-EXEC.                                                    01610000
                                                                        
      ******************************************************************01630000
      * CSS_FRNCHS_TX_XMPT, F2                                         *01640000
      ******************************************************************01650000
           EXEC SQL                                                     01660000
              INCLUDE TBFTXXMP                                          01670000
           END-EXEC.                                                    01680000
                                                                        
      ******************************************************************01700000
      * CSS_REVENUE_CLASS, F3                                          *01710000
      ******************************************************************01720000
           EXEC SQL                                                     01730000
              INCLUDE TBREVCLS                                          01740000
           END-EXEC.                                                    01750000
                                                                        
      ******************************************************************01770000
      * CSS_TAX_CNTL, TC                                               *01780000
      ******************************************************************01790000
           EXEC SQL                                                     01800000
              INCLUDE TBTXCNTL                                          01810000
           END-EXEC.                                                    01820000
                                                                        
      ******************************************************************01840000
      * CSS_TAX_RATE, TR                                               *01850000
      ******************************************************************01860000
           EXEC SQL                                                     01870000
              INCLUDE TBTXRATE                                          01880000
           END-EXEC.                                                    01890000
                                                                        
      ******************************************************************01910000
      * CSS_TAX_USE_CNTL, TU                                           *01920000
      ******************************************************************01930000
           EXEC SQL                                                     01940000
              INCLUDE TBTXUSE                                           01950000
           END-EXEC.                                                    01960000
                                                                        
      ******************************************************************01980000
      * CSS_TAX_EXCISE_AMT, X6                                        * 01990000
      ******************************************************************02000000
           EXEC SQL                                                     02010000
               INCLUDE TBEXCISE                                         02020000
           END-EXEC.                                                    02030000
                                                                        
      ******************************************************************02050000
      * CSS_SPCL_FCTR_APPL, SA                                        * 02060000
      ******************************************************************02070000
           EXEC SQL                                                     02080000
               INCLUDE TBSPLAPL                                         02090000
           END-EXEC.                                                    02100000
                                                                        
      ******************************************************************02120000
      * CSS_SPCL_FCTR     , SF                                        * 02130000
      ******************************************************************02140000
           EXEC SQL                                                     02150000
               INCLUDE TBSPLFTR                                         02160000
           END-EXEC.                                                    02170000
                                                                        
      ******************************************************************02190000
      * CSS_LO_FACTOR_XMPT ,LO                                         *02200000
      ******************************************************************02210000
           EXEC SQL                                                     02220000
               INCLUDE TBLOXMPT                                         02230000
           END-EXEC.                                                    02240000
                                                                        
      ******************************************************************02330000
      * CSS_LOCAL_OFFICE   ,B1                                         *02340000
      ******************************************************************02350000
           EXEC SQL                                                     02360000
               INCLUDE TBLOCOFC                                         02370000
           END-EXEC.                                                    02380000
                                                                        
      ******************************************************************02400000
      * CSS_ZIPCODE_LO_RT  ,ZT                                         *02410000
      ******************************************************************02420000
           EXEC SQL                                                     02430000
               INCLUDE TBZIPRTE                                         02440000
           END-EXEC.                                                    02450000
                                                                        
      ******************************************************************02470000
      * CSS_FIXED_FCTR,  FF                                            *02480000
      ******************************************************************02490000
           EXEC SQL                                                     02500000
               INCLUDE TBFXDFCT                                         02510000
           END-EXEC.                                                    02520000
                                                                        
      *                                                                 02540000
      ******************************************************************02550000
      *    CSS_ACCT_ATTRIBUTE - YP                                    * 02560000
      ******************************************************************02570000
      *                                                                 02580000
           EXEC SQL                                                     02590000
               INCLUDE TBACTATT                                         02600000
           END-EXEC.                                                    02610000
      *                                                                 02620000
      ******************************************************************02630000
      * FI - CRM_RT_PKG_OPTION                                         *02640000
      ******************************************************************02650000
      *                                                                 02660000
           EXEC SQL                                                     02670000
              INCLUDE TBRTPKGO                                          02680000
           END-EXEC.                                                    02690000
      *                                                                 02691000
BBPFIX******************************************************************02700000
BBPFIX* CSS_ACCT_RTPK_AGR DF                                            02701000
BBPFIX******************************************************************02702000
BBPFIX     EXEC SQL                                                     02703000
BBPFIX         INCLUDE TBACCTRG                                         02704000
BBPFIX     END-EXEC.                                                    02705000
BBPFIX                                                                  
                                                                        
      *                                                                 02710000
      ******************************************************************02720000
      *    WORK AREAS                                                  *02730000
      ******************************************************************02740000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04600'.    
           05  WS-OTHER-TAX              PIC X(01) VALUE 'C'.           
           05  MCSCB107                  PIC X(08) VALUE 'MCSCB107' .   
      *                                                                 02810000
       01  TDS-RETURN-FIELDS.                                           
           05  WS-DAYS                   PIC S9(4) COMP VALUE 0.        
           05  WS-UNITS                  PIC S9(9) COMP-3 VALUE 0.      
           05  WS-UNITS-MNTH             PIC S9(9) COMP-3 VALUE 0.      
           05  WS-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.        
           05  WS-NEW-CHARGE             PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  WS-EPP-GAS-AMT-TBL        PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  WS-NEW-CHARGE-2           PIC S9(9)V9(2) COMP-3          
                                                            VALUE 100.  
           05  WS-INTEGER                PIC S9(9) VALUE ZEROS.         
           05  WS-REMAINDER              PIC 9(9) VALUE ZEROS.          
           05  WS-RATE-PLAN-NO           PIC X(03) VALUE SPACES.        
           05  WS-EPP-RATE-PLAN-NO       PIC X(03).                     
           05  WS-EPP-RATE-PLAN-NO-R REDEFINES                          
               WS-EPP-RATE-PLAN-NO       PIC 9(03).                     
           05  WS-EPP-RATE-PRICE         PIC X(12).                     
           05  WS-EPP-RATE-PRICE-R   REDEFINES                          
               WS-EPP-RATE-PRICE         PIC -(4)9.9(6).                
           05  WS-EPP-RATE-PRICE-N       PIC  9(5)V9(6).                
           05  WS-EPP-CATEGORY           PIC X(01) VALUE SPACES.        
           05  WS-DO-NOT-BUFFER          PIC X(01) VALUE 'N'.           
      *                                                                 03030000
       01  WS-MONTHLY-PASS-THRU.                                        
           05  WS-MNTH-AGL-CUST-CHRG     PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-MNTH-PTC               PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-MNTH-PTC-DDDC          PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-MNTH-PTC-12MTHS        PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-MNTH-PTC-DDDC-12MTHS   PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-ANNUAL-DDAY-FACTOR     PIC S9(9)V9(6) COMP-3 VALUE 0. 
           05  WS-MONTH-DDAY-FACTOR      PIC S9(9)V9(6) COMP-3 VALUE 0. 
           05  WS-AGL-PASS-CHARGE       PIC S9(11)V9(2) COMP-3 VALUE 0. 
           05  WS-AGL-PASS-AMT-NUM       PIC S9(11)V9(2).               
           05  WS-AGL-PASS-AMT-CHAR      PIC X(13).                     
           05  WS-AGL-PASS-AMT-EDIT REDEFINES                           
                   WS-AGL-PASS-AMT-CHAR                                 
                                         PIC -(9)9.99.                  
      *                                                                 03160000
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-AMOUNT-CHECK.                                         
               10  WS-AMT-DOLLARS       PIC X(02).                      
               10  WS-DECIMAL-POINT     PIC X(01) VALUE '.'.            
               10  WS-AMT-CENTS         PIC X(02).                      
           05  WS-AMOUNT-CHECK-RPRICE.                                  
               10  WS-AMT-DOLLARS-P     PIC X(05).                      
               10  WS-DECIMAL-POINT-P   PIC X(01) VALUE '.'.            
               10  WS-AMT-CENTS-P       PIC X(06).                      
           05  WS-PARM-ACCOUNT-NO        PIC 9(13).                     
           05  WS-PARM-RATE-PLAN         PIC X(03).                     
           05  WS-PARM-DDDC              PIC X(07).                     
           05  WS-PARM-DDDC-EDIT REDEFINES WS-PARM-DDDC                 
                                         PIC 9(02).9(04).               
           05  WS-PARM-DDDC-N            PIC S9(02)V9(04).              
COB305     05 WS-DDDC        PIC S9(02)V9(04) COMP-3 VALUE 0.       
           05  WS-PARM-RATE-PRICE        PIC X(12).                     
           05  WS-PARM-RPRICE-EDIT REDEFINES WS-PARM-RATE-PRICE         
                                         PIC 9(05).9(06).               
           05  WS-PARM-RATE-PRICE-N      PIC S9(05)V9(06).              
COB305     05 WS-RATE-PRICE        PIC S9(05)V9(06) COMP-3 VALUE 0.       
           05  WS-SENIOR-IND             PIC X(01)  VALUE SPACES.       
           05  WS-PROCESS-IND            PIC X(01)  VALUE SPACES.       
           05  WS-CHANNEL                PIC X(03)  VALUE SPACES.       
           05  WS-RT-PLAN-NO             PIC X(03) VALUE SPACES.        
           05  WS-PARM-CUST-SVC-FEE      PIC X(05).                     
           05  WS-PARM-CSF-EDIT       REDEFINES WS-PARM-CUST-SVC-FEE    
                                         PIC 9(02).99.                  
           05  WS-PARM-CSF-N             PIC S9(02)V99.                 
COB305     05 WS-CUST-SVC-FEE        PIC S9(02)V99 COMP-3 VALUE 0.          
                                                                        
           05  WS-EPP-GAS-AMT            PIC S9(11)V9(7) COMP-3         
                                                           VALUE +0.    
           05  WS-EPP-GAS-AMT-NUM        PIC S9(11)V99.                 
           05  WS-EPP-GAS-AMT-CHAR       PIC X(13).                     
           05  WS-EPP-GAS-AMT-EDIT REDEFINES                            
                   WS-EPP-GAS-AMT-CHAR                                  
                                         PIC -(9)9.99.                  
                                                                        
           05  WS-EPP-SUBDIV-AMT         PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-EPP-SUBDIV-AMT-NUM     PIC S9(11)V99.                 
           05  WS-EPP-SUBDIV-AMT-CHAR    PIC X(13).                     
                                                                        
           05  WS-EPP-SUBDIV-AMT-EDIT REDEFINES                         
                 WS-EPP-SUBDIV-AMT-CHAR  PIC -(9)9.99.                  
                                                                        
           05  WS-EPP-PRIVATE-AMT        PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-EPP-PRIVATE-AMT-NUM    PIC S9(11)V99.                 
           05  WS-EPP-PRIVATE-AMT-CHAR   PIC X(13).                     
           05  WS-EPP-PRIVATE-AMT-EDIT REDEFINES                        
                WS-EPP-PRIVATE-AMT-CHAR  PIC -(9)9.99.                  
                                                                        
           05  WS-EPP-EST-AMT            PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-EPP-EST-AMT-NUM        PIC S9(11)V99.                 
           05  WS-EPP-EST-AMT-CHAR       PIC X(13).                     
           05  WS-EPP-EST-AMT-EDIT     REDEFINES                        
                   WS-EPP-EST-AMT-CHAR   PIC -(9)9.99.                  
                                                                        
           05  WS-EPP-EST-AMT-RND        PIC S9(11) COMP-3              
                                                      VALUE +0.         
           05  WS-EPP-EST-AMT-RND-NUM    PIC S9(11)V99.                 
           05  WS-EPP-EST-AMT-RND-CHAR   PIC X(13).                     
           05  WS-EPP-EST-AMT-RND-EDIT REDEFINES                        
                WS-EPP-EST-AMT-RND-CHAR  PIC -(9)9.00.                  
                                                                        
           05  WS-ESTRATE-INCR-ELEC      PIC S9(11)V9(7) COMP-3         
                                                       VALUE +0.        
           05  WS-ESTRATE-INCR-GAS       PIC S9(11)V9(7) COMP-3         
                                                       VALUE +0.        
BBPFIX     05  WS-RATE-CALC-TYPE-CD      PIC X(2)  VALUE SPACES.        
           05  WS-MONTHS-ELEC-USG        PIC 9(2)  VALUE 0.             
           05  WS-MONTHS-GAS-USG         PIC 9(2)  VALUE 0.             
COB305     05 WS-PREMISE-NO        PIC S9(10) COMP-3 VALUE 0.             
           05  WS-REVENUE-MONTH          PIC S9(6) COMP-3 VALUE 0.      
           05  WS-BILL-NO                PIC 9(9).                      
           05  WS-HOLD-BILL-DATE         PIC X(12) VALUE SPACES.        
           05  WS-DATE-BILLED            PIC X(12).                     
           05  WS-REVENUE-MONTH-CHAR     PIC X(10).                     
           05  WS-RCVPRM                 PIC X(20).                     
           05  WS-BILL-EXISTS            PIC X(1)  VALUE SPACES.        
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
           05  WS-BBP-EST                PIC S9(9) COMP VALUE 0.        
           05  WS-BBP-USAGE              PIC S9(9) COMP VALUE 0.        
           05  WS-RETURN-CODE-1          PIC S9(4) COMP VALUE 0.        
           05  WS-RETURN-CODE-2          PIC S9(4) COMP VALUE 0.        
      *                                                                 04060000
           05  WS-NO-MONTHS              PIC S9(04) COMP  VALUE 0.      
           05  WS-NULL-IND-1             PIC S9(04) VALUE ZEROS COMP.   
           05  WS-NULL-IND-FCTR          PIC S9(04) VALUE ZEROS COMP.   
           05  WS-NULL-2                 PIC S9(04) VALUE ZEROS COMP.   
           05  WS-FROM-DATE.                                            
               10 WS-YEAR-F              PIC X(04) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '-'.           
               10 WS-MONTH-F             PIC X(02) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '-'.           
               10 WS-DAY-F               PIC X(02) VALUE SPACES.        
           05  WS-HOLD-FROM-DATE.                                       
               10  WS-HOLD-FROM-YYYY     PIC X(04) VALUE SPACES.        
               10  WS-HOLD-FROM-MM       PIC X(02) VALUE SPACES.        
           05  WS-HOLD-FROM-DATE-R       PIC 9(06) VALUE ZEROS.         
           05  WS-IC-NO                  PIC S9(4) USAGE COMP.          
           05  WS-REVENUE-DATE.                                         
               10 WS-YEAR                PIC X(04) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '-'.           
               10 WS-MONTH               PIC X(02) VALUE SPACES.        
               10 FILLER                 PIC X(01) VALUE '-'.           
               10 WS-DAY                 PIC X(02) VALUE '01'.          
           05  WS-TO-DATE                PIC X(10) VALUE SPACES.        
           05  WS-NUM-OF-BILLS           PIC S9(4) COMP.                
           05  WS-NULL-IND               PIC S9(4) COMP.                
           05  WS-CUST-PLAN-EXISTS       PIC X(01) VALUE SPACES.        
           05  WS-CURRENT-BILL-NO        PIC S9(09) COMP                
                                                    VALUE ZEROES.       
COB305     05 WS-CURR-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.            
           05  WS-CURR-REVENUE-MONTH-NUM PIC 9(06).                     
           05  WS-CURR-REVENUE-MONTH-R REDEFINES                        
               WS-CURR-REVENUE-MONTH-NUM.                               
               10  WS-CURR-REV-YEAR      PIC 9(04).                     
               10  WS-CURR-REV-MTH       PIC 9(02).                     
           05  WS-EXIT-FEE-CHECKED       PIC X(01) VALUE SPACES.        
BBPFIX     05  WS-FIRST-TIME-SW          PIC X(01) VALUE SPACES.        
           05  WS-REVENUE-MONTH-NULL     PIC S9(4) COMP                 
                                                     VALUE ZEROES.      
           05  WS-COMPUTE-PTC            PIC X(01) VALUE SPACES.        
           05  WS-HOLD-ADJ-ELEMENT       PIC X(01) VALUE SPACES.        
           05  WS-DATABASE               PIC 9(1) VALUE ZERO.           
           05  RS-RETURN-CODE            PIC S9(9) VALUE 0 COMP.        
       01  WORK-VARIABLES-TAX.                                          
COB305     05 WS-BILL-AMT-PLUS-TAXES        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.          
COB305     05 WS-STATE-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.          
COB305     05 WS-CITY-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.          
COB305     05 WS-OTHER-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.          
COB305     05 WS-CITY-TAX-RATE-CALC        PIC S99V9(3) COMP-3 VALUE 0.         
COB305     05 WS-STATE-TAX-RATE-CALC        PIC S99V9(3) COMP-3 VALUE 0.        
           05  WS-DAYS-AT-CURRENT        PIC S9(9)     COMP.            
           05  WS-DATE-1                 PIC X(10).                     
           05  WS-DATE-2                 PIC X(10).                     
           05  WS-TAX-COMPARE-KEY.                                      
               10 WS-TAX-COMPARE-TYPE    PIC X(01).                     
               10 WS-TAX-JURISDICTION-CD PIC X(03).                     
           05  WS-FT-XMPT                PIC X(01).                     
           05  WS-ST-XMPT                PIC X(01).                     
           05  WS-TAX-FACTOR-ID          PIC X(9) VALUE SPACES.         
COB305     05 WS-AMT-OTHER-TAX        PIC S9(7)V9(2) COMP-3 VALUE 0.         
           05  WS-START-DATE             PIC X(10) VALUE SPACES.        
           05  WS-V1-REV-MTH             PIC 9(06) VALUE ZERO.          
           05  WS-V2-REV-MTH             PIC 9(06) VALUE ZERO.          
           05  WS-REV-MONTH-TEST         PIC 9(06) VALUE ZERO.          
COB305     05 WS-BILL-MESSAGE        PIC S9(5) COMP-3 VALUE 0.              
COB305     05 WS-MSG-INDX        PIC S9(5) COMP-3 VALUE 0.              
           05  WS-WORK-DATE              PIC X(10) VALUE SPACES.        
           05  WS-WORK-FROM-DATE         PIC 9(06) VALUE ZERO.          
           05  WS-REV-MONTH-FLAG         PIC X(01) VALUE SPACES.        
               88 WS-REV-MONTH-FOUND               VALUE 'Y'.           
           05  WS-ENTRIES-FLAG           PIC X(01) VALUE SPACES.        
               88 WS-ENTRIES-NOT-FOUND             VALUE 'Y' .          
COB305     05 WS-TOT-EXCISE-TAX-AMT        PIC S9(9)V99 COMP-3 VALUE 0.         
COB305     05 WS-EXCISE-TAX-AMT        PIC S9(9)V99 COMP-3 VALUE 0.           
COB305     05 WS-WORK-UNITS        PIC S9(9) COMP-3 VALUE 0.              
           05  WS-HOLD-YEAR              PIC 9(04) VALUE ZEROS.         
           05  WS-HOLD-MONTH             PIC 9(02) VALUE ZEROS.         
           05  WS-LAST-EST-MTH           PIC 9(02) VALUE ZEROS.         
           05  WS-MONTHS-TO-EST          PIC 9(02) VALUE ZEROS.         
           05  WS-NBR-MTH-CTR            PIC 9(02) VALUE ZEROS.         
           05  WS-HOLD-INDX-1            PIC 9(02) VALUE ZEROS.         
           05  WS-HOLD-INDX              PIC 9(02) VALUE ZEROS.         
           05  WS-ICD-INDX               PIC 9(02) VALUE ZEROS.         
      *                                                                 05120000
       01  WORK-VARIABLES-CIA.                                          
           05  WS-REV-DATE-FROM.                                        
               10  WS-REV-DATE-CCYYY   PIC 9(04) VALUE ZERO.            
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-REV-DATE-MM      PIC 9(02) VALUE ZERO.            
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-REV-DATE-DD      PIC 9(02) VALUE 01.              
           05  WS-REV-DATE-TO.                                          
               10  WS-REV2-DATE-CCYYY   PIC 9(04) VALUE ZERO.           
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-REV2-DATE-MM      PIC 9(02) VALUE ZERO.           
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-REV2-DATE-DD      PIC 9(02) VALUE 01.             
           05  WS-REV-CCYYMM-TEMP           .                           
               10  WS-REV-CCYY-TEMP         PIC 9(04).                  
               10  WS-REV-MM-TEMP           PIC 9(02).                  
      *                                                                 05290000
       01  WS-TAX-EX-ENTRIES-MAX         PIC S9(5) COMP VALUE 100.      
      *                                                                 05310000
       01  WS-RETRIEVE-INFO.                                            
           05  WS-RETRIEVE-DATA                                         
                 OCCURS 12 TIMES                                        
                 INDEXED BY WS-RET-INDX.                                
              10 WS-RET-REVENUE-DATE.                                   
                 15 WS-RET-YEAR             PIC 9(04).                  
                 15 WS-RET-MONTH            PIC 9(02).                  
COB305        10 WS-RET-UNITS        PIC S9(9) COMP-3 VALUE 0.           
COB305        10 WS-RET-NEW-CHRG        PIC S9(9)V99 COMP-3 VALUE 0.        
              10 WS-RET-EST-ACT             PIC X(01).                  
              10 WS-RET-DAYS                PIC S9(4) COMP VALUE 0.     
      *                                                                 05430000
       01  WS-DDDC-SCULP-PERCENT.                                       
           05  WS-DDDC-SCULP OCCURS 12 TIMES                            
               INDEXED BY WS-SC-INDX.                                   
               10  WS-DDDC-SCULP-MTH       PIC 9(02).                   
COB305         10 WS-DDDC-SCULP-VALUE        PIC 9(4)V9(5) USAGE COMP-3 
COB305           VALUE 0.  
      *                                                                 05490000
COB305 01 WS-DEFAULT-DDDC        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.    
COB305 01 WS-DEFAULT-EPP-LIMIT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
COB305 01 WS-DEFAULT-THERMS        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.    
COB305 01 WS-AGL-METER-CHARGE        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.    
       01  WS-TAX-EXCISE-TABLE.                                         
           05  WS-TAX-EX-ENTRIES         PIC S9(5) COMP VALUE ZERO.     
           05  WS-TAX-EX-ENTRY                                          
                  OCCURS 100 TIMES                                      
                  DESCENDING KEY WS-X6-TAX-KEY                          
                  INDEXED BY X6-INDX.                                   
                  07 WS-X6-TAX-KEY.                                     
                     08 WS-X6-TAX-CNTRL-NO   PIC S9(4) COMP.            
                     08 WS-X6-TAX-DATE-FROM  PIC X(10) .                
                     08 WS-X6-BLOCK-NO       PIC 9(01) .                
                  07 WS-X6-BLOCK-UNITS       PIC S9(9) COMP.            
COB305            07 WS-X6-EXCISE-TAX-UNIT-AM        PIC S9(5)V9(6) 
COB305           COMP-3 VALUE 0.    
           05  WS-TAX-EX-ENTRY-CORRECT                                  
                  OCCURS 9 TIMES                                        
                  INDEXED BY X6-INDX-CORRECT.                           
                  07 WS-X6-BLOCK-NO-C           PIC 9(01) .             
                  07 WS-X6-BLOCK-UNITS-C        PIC S9(9) COMP.         
COB305            07 WS-X6-EXCISE-TAX-UNIT-AM-C        PIC S9(5)V9(6) 
COB305           COMP-3 VALUE 0.  
      *                                                                 05720000
       01  WS-TAX-TABLE-ENTRIES-MAX      PIC S9(5) COMP VALUE 3000.     
      *                                                                 05740000
       01  WS-TAX-RATE-TABLE.                                           
           05  WS-TAX-TABLE-ENTRIES      PIC S9(5) COMP VALUE ZERO.     
           05  WS-TAX-RATE-ENTRY                                        
                  OCCURS 3000 TIMES                                     
                  ASCENDING KEY WS-TC-TAX-KEY                           
                  INDEXED BY TC-INDX.                                   
               10  WS-TC-TAX-KEY.                                       
                   15  WS-TC-TAX-ID.                                    
                       20  WS-TC-TAX-TYPE          PIC X(1).            
                       20  WS-TR-TAX-JURISDICTION  PIC 9(3).            
                   15  WS-TC-TAX-CNTRL-NO          PIC 9(4).            
               10  WS-TAX-USE-DATA.                                     
                   15  WS-TU-GAS         PIC X(01).                     
                   15  WS-TU-MDSE        PIC X(01).                     
                   15  WS-TU-WATER       PIC X(01).                     
                   15  WS-TU-SEWER       PIC X(01).                     
                   15  WS-TU-TRASH       PIC X(01).                     
                   15  WS-TU-FACTOR-ID   PIC X(09).                     
               10  WS-TU-CALC-INST       PIC X(01).                     
               10  WS-TAX-RATE-VERSION                                  
                      OCCURS 2 TIMES                                    
                      INDEXED BY TR-INDX.                               
                   15  WS-TR-DATE-FROM   PIC X(10).                     
                   15  WS-TR-DATE-TO     PIC X(10).                     
COB305             15 WS-TAX-RATE        PIC S9V9(4) COMP-3 VALUE 0.            
                                                                        
      *                                                                 06020000
      ***************************************************************** 06030000
      *    COPYBOOK RETURNS DB2 STORED PROCEDURE                      * 06040000
      ***************************************************************** 06050000
           COPY CCA00001.                                               06060000
                                                                        
      ******************************************************************06080000
      *    SQL ERROR CHECKING COPYBOOK                                 *06090000
      ******************************************************************06100000
           COPY CWS00303.                                               06110000
                                                                        
      ******************************************************************06180000
      *   LINKAGE SECTION COPY BOOK FOR UTILITY PRICING SUB-ROUTINE    *06190000
      ******************************************************************06200000
      *    COPY CWS0022B.                                               06210000
                                                                        
      ******************************************************************06230000
      *   LINKAGE SECTION VARIABLES NEEDED FOR MCSCB107                *06240000
      ******************************************************************06250000
           COPY CWS0024B.                                               06260000
                                                                        
      ******************************************************************06280000
      *   METERED INFORMATION AND USAGE HISTORY COPYBOOK               *06290000
      ******************************************************************06300000
           COPY CWS1001A.                                               06310000
                                                                        
      ******************************************************************06330000
      *    DB2 ERROR PROCESSING COPYBOOK                               *06340000
      ******************************************************************06350000
           COPY CWSSP001.                                               06360000
                                                                        
      ******************************************************************06380000
      *    ERROR HANDLING COPY BOOK                                    *06390000
      ******************************************************************06400000
           EXEC SQL                                                     06410000
               INCLUDE CWSX0010                                         06420000
           END-EXEC.                                                    06430000
                                                                        
      ******************************************************************06450000
      *   COPY BOOK FOR CUSTOMER BILL EXTRACT INFO                     *06460000
      ******************************************************************06470000
           EXEC SQL                                                     06480000
               INCLUDE CWS1000A                                         06490000
           END-EXEC.                                                    06500000
                                                                        
      ******************************************************************06520000
      *   TABLE LAYOUT FOR CUSTOMER BILL EXTRACT INFO                  *06530000
      ******************************************************************06540000
           EXEC SQL                                                     06550000
               INCLUDE CWS1000B                                         06560000
           END-EXEC.                                                    06570000
                                                                        
      ******************************************************************06590000
      *   TABLE LAYOUT FOR METERED INFORMATION AND USAGE HISTORY.      *06600000
      ******************************************************************06610000
           COPY CWS1001B.                                               06620000
                                                                        
      ******************************************************************06640000
      *   LINKAGE SECTION COPY BOOK FOR UTILITY PRICING SUB-ROUTINE    *06650000
      ******************************************************************06660000
           EXEC SQL                                                     06670000
               INCLUDE CWS0022B                                         06680000
           END-EXEC.                                                    06690000
      *                                                                 06700000
       01  WORK-VARIABLES.                                              
           03  WS-DATE-ORIG-BILL-NULL    PIC S9(4) COMP.                
           03  WS-DATE-LFTM-HI-DMD-NULL  PIC S9(4) COMP.                
           03  WS-DATE-BILLED-NULL       PIC S9(4) COMP.                
           03  WS-DATE-READ-NULL         PIC S9(4) COMP.                
           03  WS-DATE-USAGE-ENDS-NULL   PIC S9(4) COMP.                
           03  WS-EFF-DATE-TO-NULL       PIC S9(4) COMP.                
           03  WS-CURRENT-DATE           PIC X(10).                     
COB305     03 WS-MAX-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
COB305     03 WS-TO-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
           03  WS-TO-REV-MONTH-NI        PIC S9(04) COMP  VALUE +0.     
           03  WS-TO-REV-MONTH-C         PIC 9(06).                     
           03  WS-MAX-REV-DATE           PIC X(10).                     
           03  WS-MAX-REV-DATE-TMP       PIC X(10).                     
COB305     03 WS-FROM-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.       
           03  WS-FROM-REV-MONTH-C       PIC 9(06).                     
           03  WS-HOLD-DATE-DDDC         PIC X(10).                     
           03  WS-HOLD-DATE-DDDC-R.                                     
               05  WS-HOLD-YEAR-DDDC     PIC X(04) VALUE SPACES.        
               05  FILLER                PIC X(01) VALUE '-'.           
               05  WS-HOLD-MONTH-DDDC    PIC X(02) VALUE SPACES.        
               05  FILLER                PIC X(01) VALUE '-'.           
               05  WS-HOLD-FIRST-DAY     PIC X(02) VALUE '01'.          
                                                                        
       01  WS-HOLD-CX-DATA               PIC X(31000).                  
       01  WS-HOLD-BC-DATA               PIC X(100000).                 
       01  WS-HOLD-BA-DATA               PIC X(20400).                  
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  GOOD-AMOUNT-SW           PIC X(01) VALUE 'N'.            
               88 INVALID-AMT                     VALUE 'N'.            
               88 VALID-AMT                       VALUE 'Y'.            
           05  WS-END-OF-PTC            PIC X(01) VALUE SPACES.         
           05  WS-EOF-CURSOR            PIC X(01) VALUE 'N'.            
               88 NO-MORE-DATA                    VALUE 'Y'.            
           05  WS-RESULT-TYPE           PIC 9(01) VALUE ZERO.           
               88 WS-ESTIMATION                   VALUE 1.              
               88 WS-USAGE                        VALUE 2.              
      *                                                                 07160000
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE           PIC S9(4)    COMP VALUE 0.         
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(4)    COMP VALUE 0.         
             10 S-EPP-GAS-AMT        PIC X(13) VALUE SPACES.            
             10 S-EPP-SUBDIV-AMT     PIC X(13) VALUE SPACES.            
             10 S-EPP-PRIVATE-AMT    PIC X(13) VALUE SPACES.            
             10 S-EPP-EST-AMT        PIC X(13) VALUE SPACES.            
             10 S-EPP-EST-AMT-RND    PIC X(13) VALUE SPACES.            
             10 S-AGL-PASS-CHARGE    PIC X(13) VALUE SPACES.            
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(4)    COMP VALUE 0.         
             10 S-REVENUE-MONTH      PIC X(10)    VALUE SPACES.         
             10 S-DAYS               PIC S9(4)    COMP VALUE 0.         
             10 S-UNITS              PIC S9(9)    COMP-3 VALUE 0.       
             10 S-NEW-CHARGE         PIC S9(9)V9(2) COMP-3 VALUE 0.     
             10 S-GAS-BUFFER         PIC S9(4)V9(5) COMP-3 VALUE 0.     
      *                                                                 07390000
      ******************************************************************07400000
      *    CURSOR DECLARATIONS                                         *07410000
      ******************************************************************07420000
      *                                                                 07430000
           EXEC SQL DECLARE BI-CURSOR CURSOR FOR                        
               SELECT BG.REVENUE_MONTH                                  
                     ,BI.DATE_BILLED                                    
                     ,BI.CUSTOMER_NO                                    
                     ,BG.ACCOUNT_NO                                     
                     ,BG.CODE_UTIL_TYPE                                 
                     ,BG.AMT_BILL_ITEM                                  
                     ,BG.BILL_NO                                        
                     ,BG.IC_NO                                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                     ,BG.PREMISE_NO                                     
                     ,BG.DATE_ORIG_BILL                                 
                     ,BG.CODE_BILL_CALC                                 
                     ,BG.CODE_BILL_ITM_TYPE                             
                     ,BG.CODE_BILL_ITM_IND                              
                     ,BG.CODE_DR_CR_CNSMPTN                             
                     ,BG.AMT_STATE_TAX                                  
                     ,BG.AMT_CITY_TAX                                   
                     ,BG.AMT_OTHER_TAX                                  
                     ,BG.CODE_REVENUE_CLASS                             
                     ,BG.CODE_SIC_NO                                    
                     ,BG.RATE_PLAN_NO                                   
                     ,BG.CODE_CURTAIL_PRTY                              
                     ,BG.CODE_STAT_TAX_XMT                              
                     ,BG.CODE_CITY_TAX_XMT                              
                     ,BG.CODE_OTHR_TAX_XMT                              
                     ,BG.REV_RPT_CD                                     
                     ,BG.STANDBY_COMPLIED                               
                     ,BG.PRORATE_CD                                     
                     ,BG.NEW_RATE_PCT                                   
                     ,BG.CODE_SUB_TOTAL                                 
                     ,BG.TAX_REFUND_CD                                  
                     ,BG.COMPANY_NO                                     
                     ,BG.DATE_LFTM_HI_DMD                               
                     ,BG.LFTM_HI_PEAK_DMD                               
                     ,BG.REBILL_IND                                     
                     ,BG.REV_MTH_ORIG_BILL                              
                     ,BG.GAS_BASE_USE                                   
                     ,BG.ADJ_REASON_CD                                  
                     ,BG.WNA_FACTOR                                     
                     ,BG.BTU_FACTOR                                     
                     ,BG.REV_DISTRICT_CD                                
                     ,BG.RT_PKG_OPT_SEQ_NO                              
                 FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)                
                     ,CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BI.PREMISE_NO         = :BI-PREMISE-NO            
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
                  AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BI.BILL_NO            = BG.BILL_NO                
               AND ((BG.REV_MTH_ORIG_BILL = 0                           
                  AND BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH       
                  AND :WS-TO-REV-MONTH)                                 
                  OR (BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MONTH   
                  AND :WS-TO-REV-MONTH))                                
             ORDER BY BG.IC_NO                                          
                     ,BI.DATE_BILLED DESC                               
             FOR READ ONLY                                             
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE BI-CURSOR CURSOR FOR                        07440000
MFA-TR*        SELECT BG.REVENUE_MONTH                                  07450000
MFA-TR*              ,BI.DATE_BILLED                                    07460000
MFA-TR*              ,BI.CUSTOMER_NO                                    07470000
MFA-TR*              ,BG.ACCOUNT_NO                                     07480000
MFA-TR*              ,BG.CODE_UTIL_TYPE                                 07490000
MFA-TR*              ,BG.AMT_BILL_ITEM                                  07500000
MFA-TR*              ,BG.BILL_NO                                        07510000
MFA-TR*              ,BG.IC_NO                                          07520000
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                             07530000
MFA-TR*              ,BG.PREMISE_NO                                     07540000
MFA-TR*              ,BG.DATE_ORIG_BILL                                 07550000
MFA-TR*              ,BG.CODE_BILL_CALC                                 07560000
MFA-TR*              ,BG.CODE_BILL_ITM_TYPE                             07570000
MFA-TR*              ,BG.CODE_BILL_ITM_IND                              07580000
MFA-TR*              ,BG.CODE_DR_CR_CNSMPTN                             07590000
MFA-TR*              ,BG.AMT_STATE_TAX                                  07600000
MFA-TR*              ,BG.AMT_CITY_TAX                                   07610000
MFA-TR*              ,BG.AMT_OTHER_TAX                                  07620000
MFA-TR*              ,BG.CODE_REVENUE_CLASS                             07630000
MFA-TR*              ,BG.CODE_SIC_NO                                    07640000
MFA-TR*              ,BG.RATE_PLAN_NO                                   07650000
MFA-TR*              ,BG.CODE_CURTAIL_PRTY                              07660000
MFA-TR*              ,BG.CODE_STAT_TAX_XMT                              07670000
MFA-TR*              ,BG.CODE_CITY_TAX_XMT                              07680000
MFA-TR*              ,BG.CODE_OTHR_TAX_XMT                              07690000
MFA-TR*              ,BG.REV_RPT_CD                                     07700000
MFA-TR*              ,BG.STANDBY_COMPLIED                               07710000
MFA-TR*              ,BG.PRORATE_CD                                     07720000
MFA-TR*              ,BG.NEW_RATE_PCT                                   07730000
MFA-TR*              ,BG.CODE_SUB_TOTAL                                 07740000
MFA-TR*              ,BG.TAX_REFUND_CD                                  07750000
MFA-TR*              ,BG.COMPANY_NO                                     07760000
MFA-TR*              ,BG.DATE_LFTM_HI_DMD                               07770000
MFA-TR*              ,BG.LFTM_HI_PEAK_DMD                               07780000
MFA-TR*              ,BG.REBILL_IND                                     07790000
MFA-TR*              ,BG.REV_MTH_ORIG_BILL                              07800000
MFA-TR*              ,BG.GAS_BASE_USE                                   07810000
MFA-TR*              ,BG.ADJ_REASON_CD                                  07820000
MFA-TR*              ,BG.WNA_FACTOR                                     07830000
MFA-TR*              ,BG.BTU_FACTOR                                     07840000
MFA-TR*              ,BG.REV_DISTRICT_CD                                07850000
MFA-TR*              ,BG.RT_PKG_OPT_SEQ_NO                              07860000
MFA-TR*          FROM CSS_BILLING_HDR   BI                              07870000
MFA-TR*              ,CSS_BILLING_DET   BG                              07880000
MFA-TR*         WHERE BI.PREMISE_NO         = :BI-PREMISE-NO            07890000
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             07900000
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                       07910000
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                       07920000
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                       07930000
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                07940000
MFA-TR*        AND ((BG.REV_MTH_ORIG_BILL = 0                           07970000
MFA-TR*           AND BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH       07980000
MFA-TR*           AND :WS-TO-REV-MONTH)                                 07990000
MFA-TR*           OR (BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MONTH   08000000
MFA-TR*           AND :WS-TO-REV-MONTH))                                08010000
MFA-TR*      ORDER BY BG.IC_NO                                          08020000
MFA-TR*              ,BI.DATE_BILLED DESC                               08030000
MFA-TR*      FOR FETCH ONLY                                             08040000
MFA-TR*      WITH UR                                                    08041000
MFA-TR*      QUERYNO 7200                                               08042000
MFA-TR*    END-EXEC.                                                    08050000
      *                                                                 08060000
           EXEC SQL DECLARE CX-CURSOR CURSOR FOR                        
               SELECT CX.NO_UNITS                                       
                     ,CX.NO_DAYS                                        
                     ,CX.MTR_REF_NO                                     
                     ,CX.CODE_USAGE_TYPE                                
                     ,CX.CODE_USAGE_ID                                  
                     ,CX.CODE_USAGE_SOURCE                              
                     ,CX.CODE_TIME_PERIOD                               
                     ,CX.ITEM_SEQ_NO                                    
                     ,CX.METER_NO                                       
                     ,CX.REG_ID_NO                                      
                     ,CX.DATE_READ                                      
                     ,CX.CODE_METER_READ                                
                     ,CX.CODE_METER_NO_READ                             
                     ,CX.METER_READING                                  
                     ,CX.DEMAND_READING                                 
                     ,CX.EMPLOYEE_NO                                    
                     ,CX.NO_DEMAND_UNITS                                
                     ,CX.CODE_SOURCE_ID                                 
                     ,CX.CODE_DEBIT_CREDIT                              
                     ,CX.CODE_ITEM_STATUS                               
                     ,CX.CODE_DISCOUNT                                  
                     ,CX.CONSTANT                                       
                     ,CX.NO_DIALS                                       
                     ,CX.COMPANY_NO                                     
                     ,CX.EXCEPT_OVERRIDE_CD                             
                     ,CX.REQUESTED_USAGE                                
                     ,CX.DIGTL_INTRL_MTR_NO                             
                     ,CX.DIGTL_MTR_TYPE                                 
                     ,CX.CODE_TOU_SEASN                                 
                     ,CX.EXCL_DMD_RCHT_IND                              
                 FROM CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)                
                WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                  AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                  AND CX.BILL_NO            = :CX-BILL-NO               
                  AND CX.IC_NO              = :CX-IC-NO                 
                  AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
A04462            AND CX.CODE_USAGE_ID     <> 'X'                       
                FOR READ ONLY                                          
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE CX-CURSOR CURSOR FOR                        08070000
MFA-TR*        SELECT CX.NO_UNITS                                       08080000
MFA-TR*              ,CX.NO_DAYS                                        08090000
MFA-TR*              ,CX.MTR_REF_NO                                     08100000
MFA-TR*              ,CX.CODE_USAGE_TYPE                                08110000
MFA-TR*              ,CX.CODE_USAGE_ID                                  08120000
MFA-TR*              ,CX.CODE_USAGE_SOURCE                              08130000
MFA-TR*              ,CX.CODE_TIME_PERIOD                               08140000
MFA-TR*              ,CX.ITEM_SEQ_NO                                    08150000
MFA-TR*              ,CX.METER_NO                                       08160000
MFA-TR*              ,CX.REG_ID_NO                                      08170000
MFA-TR*              ,CX.DATE_READ                                      08180000
MFA-TR*              ,CX.CODE_METER_READ                                08190000
MFA-TR*              ,CX.CODE_METER_NO_READ                             08200000
MFA-TR*              ,CX.METER_READING                                  08210000
MFA-TR*              ,CX.DEMAND_READING                                 08220000
MFA-TR*              ,CX.EMPLOYEE_NO                                    08230000
MFA-TR*              ,CX.NO_DEMAND_UNITS                                08240000
MFA-TR*              ,CX.CODE_SOURCE_ID                                 08250000
MFA-TR*              ,CX.CODE_DEBIT_CREDIT                              08260000
MFA-TR*              ,CX.CODE_ITEM_STATUS                               08270000
MFA-TR*              ,CX.CODE_DISCOUNT                                  08280000
MFA-TR*              ,CX.CONSTANT                                       08290000
MFA-TR*              ,CX.NO_DIALS                                       08300000
MFA-TR*              ,CX.COMPANY_NO                                     08310000
MFA-TR*              ,CX.EXCEPT_OVERRIDE_CD                             08320000
MFA-TR*              ,CX.REQUESTED_USAGE                                08330000
MFA-TR*              ,CX.DIGTL_INTRL_MTR_NO                             08340000
MFA-TR*              ,CX.DIGTL_MTR_TYPE                                 08350000
MFA-TR*              ,CX.CODE_TOU_SEASN                                 08360000
MFA-TR*              ,CX.EXCL_DMD_RCHT_IND                              08370000
MFA-TR*          FROM CSS_CNSMPTN_HIST  CX                              08380000
MFA-TR*         WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            08390000
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP    08400000
MFA-TR*           AND CX.BILL_NO            = :CX-BILL-NO               08410000
MFA-TR*           AND CX.IC_NO              = :CX-IC-NO                 08420000
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        08430000
MFA-TR*           AND CX.CODE_USAGE_ID     <> 'X'                       08431000
MFA-TR*         FOR FETCH ONLY                                          08440000
MFA-TR*         WITH UR                                                 08441000
MFA-TR*         QUERYNO 7250                                            08442000
MFA-TR*    END-EXEC.                                                    08450000
      *                                                                 08460000
           EXEC SQL                                                     
              DECLARE TAX-DATA CURSOR FOR                               
                 SELECT TC.TAX_TYPE                                     
                       ,TR.DETAIL_ID                                    
                       ,TR.DATE_FROM                                    
                       ,TR.DATE_TO                                      
                       ,TR.TAX_RATE                                     
                       ,TU.CODE_TAX_CALC_INST                           
                       ,TU.TAX_ELEC                                     
                       ,TU.TAX_GAS                                      
                       ,TU.TAX_MDSE                                     
                       ,TU.TAX_WATER                                    
                       ,TU.TAX_SEWER                                    
                       ,TU.TAX_TRASH                                    
                       ,TC.TAX_CNTRL_NO                                 
                       ,TC.FACTOR_ID                                    
                   FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_RATE TR WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)               
                   WHERE TC.OPER_MODE     = 'A'                         
                     AND TR.OPER_MODE     = TC.OPER_MODE                
                     AND TR.TAX_CNTRL_NO  = TC.TAX_CNTRL_NO             
                     AND TU.OPER_MODE     = TC.OPER_MODE                
                     AND TU.TAX_CNTRL_NO  = TC.TAX_CNTRL_NO             
                     AND TU.DETAIL_ID     = TR.DETAIL_ID                
                     AND TR.DATE_FROM IS NOT NULL                       
                   ORDER BY TC.TAX_TYPE                                 
                           ,TR.DETAIL_ID                                
                           ,TR.DATE_FROM DESC                           
                   FOR READ ONLY                                       
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09100000
MFA-TR*       DECLARE TAX-DATA CURSOR FOR                               09110000
MFA-TR*          SELECT TC.TAX_TYPE                                     09120000
MFA-TR*                ,TR.DETAIL_ID                                    09130000
MFA-TR*                ,TR.DATE_FROM                                    09140000
MFA-TR*                ,TR.DATE_TO                                      09150000
MFA-TR*                ,TR.TAX_RATE                                     09160000
MFA-TR*                ,TU.CODE_TAX_CALC_INST                           09170000
MFA-TR*                ,TU.TAX_ELEC                                     09180000
MFA-TR*                ,TU.TAX_GAS                                      09190000
MFA-TR*                ,TU.TAX_MDSE                                     09200000
MFA-TR*                ,TU.TAX_WATER                                    09210000
MFA-TR*                ,TU.TAX_SEWER                                    09220000
MFA-TR*                ,TU.TAX_TRASH                                    09230000
MFA-TR*                ,TC.TAX_CNTRL_NO                                 09240000
MFA-TR*                ,TC.FACTOR_ID                                    09250000
MFA-TR*            FROM CSS_TAX_CNTL TC                                 09260000
MFA-TR*                ,CSS_TAX_RATE TR                                 09270000
MFA-TR*                ,CSS_TAX_USE_CNTL TU                             09280000
MFA-TR*            WHERE TC.OPER_MODE     = 'A'                         09290000
MFA-TR*              AND TR.OPER_MODE     = TC.OPER_MODE                09300000
MFA-TR*              AND TR.TAX_CNTRL_NO  = TC.TAX_CNTRL_NO             09310000
MFA-TR*              AND TU.OPER_MODE     = TC.OPER_MODE                09320000
MFA-TR*              AND TU.TAX_CNTRL_NO  = TC.TAX_CNTRL_NO             09330000
MFA-TR*              AND TU.DETAIL_ID     = TR.DETAIL_ID                09340000
MFA-TR*              AND TR.DATE_FROM IS NOT NULL                       09350000
MFA-TR*            ORDER BY TC.TAX_TYPE                                 09360000
MFA-TR*                    ,TR.DETAIL_ID                                09370000
MFA-TR*                    ,TR.DATE_FROM DESC                           09380000
MFA-TR*            FOR FETCH ONLY                                       09390000
MFA-TR*            WITH UR                                              09391000
MFA-TR*            QUERYNO 7600                                         09392000
MFA-TR*    END-EXEC.                                                    09400000
      *                                                                 09410000
           EXEC SQL                                                     
              DECLARE TAX-EXCISE-DATA CURSOR FOR                        
                 SELECT  X6.BLOCK_NO                                    
                        ,X6.BLOCK_UNITS                                 
                        ,X6.DATE_FROM                                   
                        ,X6.TAX_CNTRL_NO                                
                        ,X6.EXCISE_TAX_UNIT_AM                          
                    FROM CSS_TAX_EXCISE_AMT X6 WITH(READUNCOMMITTED)            
                       ORDER BY X6.TAX_CNTRL_NO                         
                                ,X6.DATE_FROM DESC                      
                                ,X6.BLOCK_NO                            
                 FOR READ ONLY                                         
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09420000
MFA-TR*       DECLARE TAX-EXCISE-DATA CURSOR FOR                        09430000
MFA-TR*          SELECT  X6.BLOCK_NO                                    09440000
MFA-TR*                 ,X6.BLOCK_UNITS                                 09450000
MFA-TR*                 ,X6.DATE_FROM                                   09460000
MFA-TR*                 ,X6.TAX_CNTRL_NO                                09470000
MFA-TR*                 ,X6.EXCISE_TAX_UNIT_AM                          09480000
MFA-TR*             FROM CSS_TAX_EXCISE_AMT X6                          09490000
MFA-TR*                ORDER BY X6.TAX_CNTRL_NO                         09500000
MFA-TR*                         ,X6.DATE_FROM DESC                      09510000
MFA-TR*                         ,X6.BLOCK_NO                            09520000
MFA-TR*          FOR FETCH ONLY                                         09530000
MFA-TR*          WITH UR                                                09531000
MFA-TR*          QUERYNO 7650                                           09532000
MFA-TR*    END-EXEC.                                                    09540000
      *                                                                 09760000
           EXEC SQL DECLARE SCULP-RATE-CSR CURSOR FOR                   
               SELECT  DELINQ_CD,                                       
                       DELINQ_VALUE                                     
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE CIS.SUBSTR3(DELINQ_CD,1,14) = 'EPP-SCULP-RATE'         
               ORDER BY DELINQ_CD DESC                                  
             FOR READ ONLY                                             
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE SCULP-RATE-CSR CURSOR FOR                   09770000
MFA-TR*        SELECT  DELINQ_CD,                                       09780000
MFA-TR*                DELINQ_VALUE                                     09790000
MFA-TR*          FROM CSS_DELINQUENCY                                   09800000
MFA-TR*         WHERE SUBSTR(DELINQ_CD,1,14) = 'EPP-SCULP-RATE'         09810000
MFA-TR*        ORDER BY DELINQ_CD DESC                                  09820000
MFA-TR*      FOR FETCH ONLY                                             09830000
MFA-TR*      WITH UR                                                    09831000
MFA-TR*      QUERYNO 7670                                               09832000
MFA-TR*    END-EXEC.                                                    09840000
                                                                        
           EXEC SQL                                                     
              DECLARE PASS-THRU-CHRG  CURSOR FOR                        
                 SELECT  SF.FACTOR_ID,                                  
                         SF.FACTOR_TYPE,                                
                         SF.CHECK_ELEMENT,                              
                         SF.ADJUST_ELEMENT                              
                    FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                 
                       WHERE SF.SPCL_GROUP_CD = 'AP'                    
                 FOR READ ONLY                                         
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       DECLARE PASS-THRU-CHRG  CURSOR FOR                        09870000
MFA-TR*          SELECT  SF.FACTOR_ID,                                  09880000
MFA-TR*                  SF.FACTOR_TYPE,                                09890000
MFA-TR*                  SF.CHECK_ELEMENT,                              09900000
MFA-TR*                  SF.ADJUST_ELEMENT                              09910000
MFA-TR*             FROM CSS_SPCL_FCTR SF                               09920000
MFA-TR*                WHERE SF.SPCL_GROUP_CD = 'AP'                    09930000
MFA-TR*          FOR FETCH ONLY                                         09940000
MFA-TR*          WITH UR                                                09941000
MFA-TR*          QUERYNO 7860                                           09942000
MFA-TR*    END-EXEC.                                                    09950000
      *                                                                 09960000
      ***************************************************************** 09962000
      * LINKAGE SECTION.                                              * 09963000
      ***************************************************************** 09964000
       LINKAGE SECTION.                                                 
      *                                                                 09980000
       01  IN-CHANNEL                    PIC X(03).                     
       01  IN-ACCOUNT-NO                 PIC X(13).                     
       01  IN-OPTION-CD                  PIC X(12).                     
       01  IN-RATE-PRICE                 PIC X(12).                     
       01  IN-DDDC                       PIC X(07).                     
       01  IN-CUST-SVC-FEE               PIC X(05).                     
       01  IN-ZIP-CODE                   PIC X(05).                     
      *                                                                 10060000
      ***************************************************************** 10070000
      * PROCEDURE DIVISION                                            * 10071000
      ***************************************************************** 10072000
       PROCEDURE DIVISION USING IN-CHANNEL,                             
                                IN-ACCOUNT-NO,                          
                                IN-OPTION-CD,                           
                                IN-RATE-PRICE,                          
                                IN-DDDC,                                
                                IN-CUST-SVC-FEE,                        
                                IN-ZIP-CODE.                            
      *                                                                 10150000
      ******************************************************************10160000
      * 0000-MAINLINE                                                  *10170000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *10180000
      ******************************************************************10190000
       0000-MAINLINE.                                                   
      *                                                                 10210000
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
      *                                                                 10270000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10300000
      ***************************************************************** 10310000
      * 0100-INITIALIZE.                                              * 10330000
      ***************************************************************** 10340000
       0100-INITIALIZE.                                                 
      *                                                                 10360000
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                 10380000
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04600_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     10390000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            10400000
MFA-TR*                          WITH ROWSET POSITIONING FOR            10410000
MFA-TR*        SELECT                                                   10420000
MFA-TR*           *                                                     10430000
MFA-TR*        FROM                                                     10440000
MFA-TR*            SESSION.CSR04600_R1                                  10450000
MFA-TR*    END-EXEC.                                                    10460000
      *                                                                 10470000
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04600_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     10480000
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            10490000
MFA-TR*                          WITH ROWSET POSITIONING FOR            10500000
MFA-TR*        SELECT                                                   10510000
MFA-TR*           *                                                     10520000
MFA-TR*        FROM                                                     10530000
MFA-TR*            SESSION.CSR04600_R2                                  10540000
MFA-TR*    END-EXEC.                                                    10550000
      *                                                                 10560000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10600000
      ******************************************************************10610000
      * 0100A-DECLARE-GTT                                              *10620000
      ******************************************************************10630000
      *                                                                 10640000
       0100A-DECLARE-GTT.                                               
      *                                                                 10660000
           MOVE 'SESSION.CSR04600_R1'    TO WS-GTT-NAME.                
           SET  WS-ESTIMATION            TO TRUE.                       
      *                                                                 10690000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04600_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04600_R1
              (                                                       
                    RETURN_CODE       INT                           
                   ,EPP_GAS CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,EPP_SUBDIV CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,EPP_PRIVATE CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,EPP_EST_AMT CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,EPP_EST_AMT_RND CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AGL_PASS_CHARGE CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10830000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 10870000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11070000
           MOVE 'SESSION.CSR04600_R2'    TO WS-GTT-NAME.                
           SET  WS-USAGE                 TO TRUE.                       
      *                                                                 11100000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04600_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04600_R2
              (                                                       
                    RETURN_CODE       INT                           
                   ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,DAYS              SMALLINT                          
                   ,UNITS             DECIMAL(9,0)                      
                   ,NEW_CHARGE        DECIMAL(11,2)                     
                   ,GAS_BUFFER        DECIMAL(9,5)                      
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11220000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 11260000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS THRU 8000B-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11460000
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 11490000
      ******************************************************************11500000
      * 1000-PROCESS-INPUT                                             *11520000
      ******************************************************************11530000
       1000-PROCESS-INPUT.                                              
      *                                                                 11550000
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                 11570000
           IF IN-ACCOUNT-NO > SPACES OR IN-ACCOUNT-NO IS NUMERIC        
                MOVE 'L'                       TO WS-PROCESS-IND        
           ELSE                                                         
                MOVE 'G'                       TO WS-PROCESS-IND        
           END-IF.                                                      
      *                                                                 11630000
           IF WS-PROCESS-IND = SPACES OR 'G'                            
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-PROCESS-IND = 'L' AND                              
                  IN-ACCOUNT-NO > SPACES OR IN-ACCOUNT-NO IS NUMERIC    
                MOVE IN-ACCOUNT-NO             TO WS-PARM-ACCOUNT-NO    
                MOVE WS-PARM-ACCOUNT-NO        TO AT-ACCOUNT-NO         
                                                  BI-ACCOUNT-NO         
                                                  FF-ACCOUNT-NO         
                                                  YP-ACCOUNT-NO         
               ELSE                                                     
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '1000'                    TO ACTIVE-PARAGRAPH      
                MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION        
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE IN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                MOVE +100                      TO WS-ACTIVE-RETURN-CODE 
                PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 11870000
           IF IN-OPTION-CD > SPACES                                     
              INITIALIZE FI-RATE-PLAN-NO                                
              MOVE IN-OPTION-CD              TO FI-OPTION-CD            
              PERFORM 7960-SEL-RT-PLAN-NO       THRU 7960-EXIT          
              MOVE FI-RATE-PLAN-NO           TO WS-RT-PLAN-NO           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE IN-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 12020000
           IF IN-RATE-PRICE > SPACES                                    
              MOVE IN-RATE-PRICE            TO WS-AMOUNT-CHECK-RPRICE   
              PERFORM 1100A-NUMERIC-CHECK   THRU 1100A-EXIT             
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-RATE-PRICE         TO WS-PARM-RATE-PRICE       
                 MOVE WS-PARM-RPRICE-EDIT   TO WS-PARM-RATE-PRICE-N     
                 MOVE WS-PARM-RATE-PRICE-N  TO WS-RATE-PRICE            
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '1000'                TO ACTIVE-PARAGRAPH         
                 MOVE 'RECEIVE INPUT'       TO ABEND-FUNCTION           
                 MOVE 'RATE-PRICE'          TO TABLE-ELEMENT-1          
                 MOVE IN-RATE-PRICE         TO HOSTVAR-ELEMENT-1        
                 MOVE +100                  TO WS-ACTIVE-RETURN-CODE    
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12210000
           IF IN-ZIP-CODE > SPACES                                      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-1         
              MOVE IN-ZIP-CODE               TO HOSTVAR-ELEMENT-1       
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 12340000
           IF IN-DDDC > SPACES                                          
              MOVE IN-DDDC TO WS-AMOUNT-CHECK                           
              PERFORM 1100-NUMERIC-CHECK THRU 1100-EXIT                 
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-DDDC             TO WS-PARM-DDDC               
                 MOVE WS-PARM-DDDC-EDIT   TO WS-PARM-DDDC-N             
                 MOVE WS-PARM-DDDC-N      TO WS-DDDC                    
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '1000'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION       
                 MOVE 'DDDC'  TO TABLE-ELEMENT-1                        
                 MOVE IN-DDDC TO HOSTVAR-ELEMENT-1                      
                 MOVE +100                  TO WS-ACTIVE-RETURN-CODE    
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12530000
           IF IN-CUST-SVC-FEE > SPACES                                  
              MOVE IN-CUST-SVC-FEE          TO WS-AMOUNT-CHECK          
              PERFORM 1100-NUMERIC-CHECK    THRU 1100-EXIT              
              IF GOOD-AMOUNT-SW = 'Y'                                   
                 MOVE IN-CUST-SVC-FEE       TO WS-PARM-CUST-SVC-FEE     
                 MOVE WS-PARM-CSF-EDIT      TO WS-PARM-CSF-N            
                 MOVE WS-PARM-CSF-N         TO WS-CUST-SVC-FEE          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '1000'                TO ACTIVE-PARAGRAPH         
                 MOVE 'RECEIVE INPUT'       TO ABEND-FUNCTION           
                 MOVE 'CUST_SVC_FEE'        TO TABLE-ELEMENT-1          
                 MOVE IN-CUST-SVC-FEE       TO HOSTVAR-ELEMENT-1        
                 MOVE +100                  TO WS-ACTIVE-RETURN-CODE    
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12720000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12750000
      ************************************************************      12760000
      * 1100-NUMERIC-CHECK.                                      *      12770000
      ************************************************************      12780000
       1100-NUMERIC-CHECK.                                              
      *                                                                 12800000
           INSPECT WS-AMT-DOLLARS REPLACING ALL ' ' BY '0'.             
           IF WS-AMT-DOLLARS NUMERIC AND WS-AMT-CENTS NUMERIC           
              SET VALID-AMT   TO TRUE                                   
           ELSE                                                         
              SET INVALID-AMT TO TRUE                                   
           END-IF.                                                      
      *                                                                 12870000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12900000
      ************************************************************      12910000
      * 1100A-NUMERIC-CHECK.                                      *     12920000
      ************************************************************      12930000
       1100A-NUMERIC-CHECK.                                             
      *                                                                 12950000
           INSPECT WS-AMT-DOLLARS-P REPLACING ALL ' ' BY '0'.           
           IF WS-AMT-DOLLARS-P NUMERIC AND WS-AMT-CENTS-P NUMERIC       
              SET VALID-AMT   TO TRUE                                   
           ELSE                                                         
              SET INVALID-AMT TO TRUE                                   
           END-IF.                                                      
      *                                                                 13020000
       1100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 13050000
      ******************************************************************13060000
      *                                                                *13070000
      *  2000-PROCESS-OUTPUT.                                          *13080000
      ******************************************************************13090000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 13110000
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 13130000
           IF IN-ACCOUNT-NO > SPACES OR IN-ACCOUNT-NO IS NUMERIC        
              PERFORM 7950-CHK-SR-CITIZEN   THRU 7950-EXIT              
           ELSE                                                         
              MOVE 'N'                   TO WS-SENIOR-IND               
           END-IF.                                                      
      *                                                                 13190000
           SET WS-ESTIMATION             TO TRUE.                       
      *                                                                 13210000
           IF WS-PROCESS-IND = 'L'                                      
              PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT        
              ADD +1                              TO CTR-ROWS           
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
           ELSE                                                         
              PERFORM 2300-GLOBAL-PROCESSING      THRU 2300-EXIT        
              ADD +1                              TO CTR-ROWS           
              PERFORM 2000B-MOVE-GLOBAL-RESULT    THRU 2000B-EXIT       
           END-IF.                                                      
      *                                                                 13310000
           PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT.                   
      *                                                                 13330000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13360000
      ***************************************************************** 13370000
      * 2000A-MOVE-RESULT.                                            * 13390000
      ***************************************************************** 13400000
       2000A-MOVE-RESULT.                                               
      *                                                                 13420000
           MOVE ZEROES                       TO S-RETURN-CODE-1.        
      *                                                                 13440000
           IF WS-MONTHS-GAS-USG NOT EQUAL ZERO                          
              COMPUTE WS-EPP-GAS-AMT =                                  
                             (WS-EPP-GAS-AMT / WS-MONTHS-GAS-USG)       
           ELSE                                                         
              MOVE ZEROES                    TO WS-EPP-GAS-AMT          
           END-IF.                                                      
      *                                                                 13520000
           COMPUTE WS-EPP-GAS-AMT-NUM ROUNDED = WS-EPP-GAS-AMT.         
      *                                                                 13540000
           MOVE WS-EPP-GAS-AMT-NUM           TO WS-EPP-GAS-AMT-EDIT.    
           MOVE WS-EPP-GAS-AMT-CHAR          TO S-EPP-GAS-AMT.          
      *                                                                 13570000
           COMPUTE WS-EPP-SUBDIV-AMT-NUM ROUNDED = WS-EPP-SUBDIV-AMT.   
      *                                                                 13590000
           MOVE WS-EPP-SUBDIV-AMT-NUM        TO WS-EPP-SUBDIV-AMT-EDIT. 
           MOVE WS-EPP-SUBDIV-AMT-CHAR       TO S-EPP-SUBDIV-AMT.       
      *                                                                 13620000
           COMPUTE WS-EPP-PRIVATE-AMT-NUM ROUNDED = WS-EPP-PRIVATE-AMT. 
      *                                                                 13640000
           MOVE WS-EPP-PRIVATE-AMT-NUM       TO WS-EPP-PRIVATE-AMT-EDIT.
           MOVE WS-EPP-PRIVATE-AMT-CHAR      TO S-EPP-PRIVATE-AMT.      
      *                                                                 13670000
           COMPUTE WS-EPP-EST-AMT         =                             
              ( WS-EPP-GAS-AMT-NUM                                      
                 + WS-EPP-SUBDIV-AMT-NUM + WS-EPP-PRIVATE-AMT-NUM).     
      ***************************************************************** 13721000
      * CHECK TO SEE IF ESTIMATE IS LESS THAN EPP LIMIT.              * 13722000
      ***************************************************************** 13723000
           MOVE 'EPP-ESTIMATE-LIMIT'        TO C8-DELINQ-CD.            
           PERFORM 7500-GET-DELINQ-VALUE    THRU 7500-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-EPP-LIMIT.    
           IF WS-DEFAULT-EPP-LIMIT > WS-EPP-EST-AMT                     
               MOVE WS-DEFAULT-EPP-LIMIT    TO WS-EPP-EST-AMT           
           END-IF.                                                      
      *                                                                 13800000
           COMPUTE WS-EPP-EST-AMT-RND ROUNDED = WS-EPP-EST-AMT.         
      *                                                                 13820000
           IF WS-EPP-EST-AMT >  WS-EPP-EST-AMT-RND                      
               COMPUTE WS-EPP-EST-AMT-RND =  WS-EPP-EST-AMT-RND + 1     
           END-IF.                                                      
      *                                                                 13860000
           MOVE WS-EPP-EST-AMT               TO WS-EPP-EST-AMT-NUM.     
           MOVE WS-EPP-EST-AMT-NUM           TO WS-EPP-EST-AMT-EDIT.    
           MOVE WS-EPP-EST-AMT-CHAR          TO S-EPP-EST-AMT.          
      *                                                                 13910000
           MOVE WS-EPP-EST-AMT-RND           TO WS-EPP-EST-AMT-RND-NUM. 
           MOVE WS-EPP-EST-AMT-RND-NUM       TO WS-EPP-EST-AMT-RND-EDIT.
           MOVE WS-EPP-EST-AMT-RND-CHAR      TO S-EPP-EST-AMT-RND.      
      *                                                                 13950000
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 13990000
      ***************************************************************** 14000000
      * 2000B-MOVE-GLOBAL-RESULT.                                      *14020000
      ***************************************************************** 14030000
       2000B-MOVE-GLOBAL-RESULT.                                        
      *                                                                 14041000
           MOVE ZEROES                       TO S-RETURN-CODE-1.        
      *                                                                 14061000
           IF WS-MONTHS-GAS-USG NOT EQUAL ZERO                          
              COMPUTE WS-EPP-GAS-AMT =                                  
                             (WS-EPP-GAS-AMT / WS-MONTHS-GAS-USG)       
           ELSE                                                         
              MOVE ZEROES                    TO WS-EPP-GAS-AMT          
           END-IF.                                                      
      *                                                                 14150000
           COMPUTE WS-EPP-GAS-AMT-NUM ROUNDED = WS-EPP-GAS-AMT.         
      *                                                                 14170000
           MOVE WS-EPP-GAS-AMT-NUM           TO WS-EPP-GAS-AMT-EDIT.    
           MOVE WS-EPP-GAS-AMT-CHAR          TO S-EPP-GAS-AMT.          
      *                                                                 14200000
           COMPUTE WS-EPP-SUBDIV-AMT-NUM ROUNDED = WS-EPP-SUBDIV-AMT.   
      *                                                                 14220000
           MOVE WS-EPP-SUBDIV-AMT-NUM        TO WS-EPP-SUBDIV-AMT-EDIT. 
           MOVE WS-EPP-SUBDIV-AMT-CHAR       TO S-EPP-SUBDIV-AMT.       
      *                                                                 14250000
           COMPUTE WS-EPP-PRIVATE-AMT-NUM ROUNDED = WS-EPP-PRIVATE-AMT. 
      *                                                                 14270000
           MOVE WS-EPP-PRIVATE-AMT-NUM       TO WS-EPP-PRIVATE-AMT-EDIT.
           MOVE WS-EPP-PRIVATE-AMT-CHAR      TO S-EPP-PRIVATE-AMT.      
      *                                                                 14300000
           COMPUTE WS-EPP-EST-AMT         =                             
              ( WS-EPP-GAS-AMT-NUM                                      
                 + WS-EPP-SUBDIV-AMT-NUM + WS-EPP-PRIVATE-AMT-NUM).     
      ***************************************************************** 14331000
      * CHECK TO SEE IF ESTIMATE IS LESS THAN EPP LIMIT.              * 14332000
      ***************************************************************** 14333000
           MOVE 'EPP-ESTIMATE-LIMIT'           TO C8-DELINQ-CD.         
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE                TO WS-DEFAULT-EPP-LIMIT. 
           IF WS-DEFAULT-EPP-LIMIT > WS-EPP-EST-AMT                     
               MOVE WS-DEFAULT-EPP-LIMIT       TO WS-EPP-EST-AMT        
           END-IF.                                                      
      *                                                                 14420000
           COMPUTE WS-EPP-EST-AMT-RND ROUNDED = WS-EPP-EST-AMT.         
      *                                                                 14440000
           IF WS-EPP-EST-AMT >  WS-EPP-EST-AMT-RND                      
               COMPUTE WS-EPP-EST-AMT-RND =  WS-EPP-EST-AMT-RND + 1     
           END-IF.                                                      
      *                                                                 14480000
           MOVE WS-EPP-EST-AMT               TO WS-EPP-EST-AMT-NUM.     
           MOVE WS-EPP-EST-AMT-NUM           TO WS-EPP-EST-AMT-EDIT.    
           MOVE WS-EPP-EST-AMT-CHAR          TO S-EPP-EST-AMT.          
                                                                        
           MOVE WS-EPP-EST-AMT-RND           TO WS-EPP-EST-AMT-RND-NUM. 
           MOVE WS-EPP-EST-AMT-RND-NUM       TO WS-EPP-EST-AMT-RND-EDIT.
           MOVE WS-EPP-EST-AMT-RND-CHAR      TO S-EPP-EST-AMT-RND.      
      *                                                                 14570000
           MOVE WS-AGL-PASS-CHARGE           TO WS-AGL-PASS-AMT-NUM.    
           MOVE WS-AGL-PASS-AMT-NUM          TO WS-AGL-PASS-AMT-EDIT.   
           MOVE WS-AGL-PASS-AMT-CHAR         TO S-AGL-PASS-CHARGE.      
      *                                                                 14610000
       2000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                 14650000
      ****************************************************************  14670000
      * 2150-MOVE-FF-FIELDS.                                         *  14680000
      ****************************************************************  14690000
       2150-MOVE-FF-FIELDS.                                             
                                                                        
           MOVE 1 TO WS-ICD-INDX.                                       
                                                                        
           MOVE BG-ACCOUNT-NO                      TO                   
                                  WS-BC-ACCOUNT-NO-FF (WS-ICD-INDX)     
           MOVE BG-CODE-UTIL-TYPE                  TO                   
                                  WS-BC-CODE-UTIL-TYPE-FF (WS-ICD-INDX) 
           MOVE BG-IC-NO                           TO                   
                                  WS-BC-IC-NO-FF (WS-ICD-INDX)          
                                                                        
           MOVE 1           TO WS-BC-FIXED-FCTR-SEQ-NO-FF (WS-ICD-INDX) 
           MOVE '&EPPPRICE' TO WS-BC-FACTOR-ID-FF (WS-ICD-INDX)         
                                                                        
      * POPULATE THE CURRENT REV. MTH IN THE FROM DATE                  14800000
           MOVE WS-REV-CCYY-TEMP TO  WS-REV-DATE-CCYYY                  
           MOVE WS-REV-MM-TEMP   TO WS-REV-DATE-MM                      
      *                                                                 14830000
           COMPUTE WS-REV-DATE-MM  =  WS-REV-DATE-MM + 1                
      *                                                                 14850000
           IF WS-REV-DATE-MM = 13                                       
              MOVE 01 TO WS-REV-DATE-MM                                 
              COMPUTE WS-REV-DATE-CCYYY = WS-REV-DATE-CCYYY + 1         
           END-IF                                                       
      *                                                                 14900000
           MOVE WS-REV-DATE-FROM                                        
                       TO  WS-BC-EFF-DATE-FROM-FF (WS-ICD-INDX)         
      *                                                                 14930000
           MOVE '10' TO WS-BC-CMPNT-ID-CD-FF (WS-ICD-INDX)              
           MOVE 'B'  TO WS-BC-CODE-SEASON-FF (WS-ICD-INDX)              
           MOVE 'R'  TO WS-BC-INSTR-USE-TYPE-CD-FF (WS-ICD-INDX)        
      * POPULATE THE CURRENT REV MTH IN THE TO DATE                     14980000
           MOVE WS-REV-CCYY-TEMP TO  WS-REV2-DATE-CCYYY                 
           MOVE WS-REV-MM-TEMP   TO WS-REV2-DATE-MM                     
      *                                                                 15010000
           COMPUTE WS-REV2-DATE-MM  =  WS-REV2-DATE-MM + 11             
           IF WS-REV2-DATE-MM > 12                                      
              COMPUTE WS-REV2-DATE-MM    = WS-REV2-DATE-MM    - 12      
              COMPUTE WS-REV2-DATE-CCYYY = WS-REV2-DATE-CCYYY + 1       
           END-IF                                                       
      *                                                                 15070000
           MOVE WS-REV-DATE-TO TO WS-BC-EFF-DATE-TO-FF (WS-ICD-INDX)    
      *                                                                 15090000
           MOVE SPACES TO WS-BC-FIXED-FCTR-TYP-CD-FF (WS-ICD-INDX)      
                          WS-BC-UPDATE-ACTION-IND-FF (WS-ICD-INDX)      
                          WS-BC-LAST-UPDATE-TS-FF (WS-ICD-INDX)         
           MOVE 0 TO WS-BC-CODE-TIME-PERIOD-FF (WS-ICD-INDX)            
                     WS-BC-RT-PKG-OPT-SEQ-NO-FF (WS-ICD-INDX)           
      *                                                                 15160000
           MOVE WS-RATE-PRICE    TO WS-BC-FACTOR-FF (WS-ICD-INDX)       
           MOVE WS-CUST-SVC-FEE  TO                                     
                             WS-BC-FAC-CHRG-BASE-AM-FF (WS-ICD-INDX).   
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15230000
      ******************************************************************15240000
      * 2200-BUILD-RESULT                                              *15260000
      ******************************************************************15270000
       2200-BUILD-RESULT.                                               
      *                                                                 15290000
           PERFORM 7000-GET-ACCOUNT-DETAILS    THRU 7000-EXIT.          
      *                                                                 15310000
           MOVE AT-COMPANY-NO                TO  C8-COMPANY-NO          
                                                 BG-COMPANY-NO.         
           INITIALIZE C8-DELINQ-VALUE.                                  
           MOVE 'DATABASE'                   TO  C8-DELINQ-CD.          
           PERFORM 7500-GET-DELINQ-VALUE     THRU 7500-EXIT.            
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
      *                                                                 15390000
           INITIALIZE C8-DELINQ-VALUE.                                  
           MOVE 'AGL-METER-CHARGE'        TO C8-DELINQ-CD.              
           PERFORM 7500-GET-DELINQ-VALUE  THRU 7500-EXIT.               
           MOVE C8-DELINQ-VALUE           TO WS-AGL-METER-CHARGE.       
      *                                                                 15440000
           SET WS-RET-INDX TO 1.                                        
           MOVE +1 TO WS-NBR-MTH-CTR.                                   
      *                                                                 15470000
           PERFORM 7050-READ-BILL-WINDOW       THRU 7050-EXIT.          
      *                                                                 15490000
           PERFORM 7100-CALCULATE-DATE         THRU 7100-EXIT.          
      *                                                                 15510000
           PERFORM 5000-CALC-ESTRATE-INCR      THRU 5000-EXIT.          
      *                                                                 15530000
           PERFORM 7150-LOAD-REV-DISTRICT-CD   THRU 7150-EXIT.          
      *                                                                 15550000
           PERFORM 7200-OPEN-BI-CURSOR         THRU 7200-EXIT.          
           PERFORM 7205-FETCH-BI-CURSOR        THRU 7205-EXIT.          
      *                                                                 15580000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             MOVE 'Y'                       TO WS-BILL-EXISTS           
             MOVE BG-BILL-NO                TO WS-CURRENT-BILL-NO       
           END-IF.                                                      
      *                                                                 15630000
           PERFORM 5050-PROCESS-BI-CURSOR   THRU 5050-EXIT              
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.   
      *                                                                 15660000
           PERFORM 7210-CLOSE-BI-CURSOR      THRU 7210-EXIT.            
      *                                                                 15680000
           IF WS-RET-INDX <= 12                                         
              IF WS-RET-INDX = 1                                        
      ******************************************************************15701000
      * ACCOUNT EXISTS BUT HAS NOT GONE THROUGH BILLING YET            *15702000
      * SO DO GLOBAL PROCESSING.                                       *15702100
      ******************************************************************15703000
                 MOVE 'G' TO   WS-PROCESS-IND                           
                 MOVE 'Y' TO WS-DO-NOT-BUFFER                           
                 PERFORM 2300-GLOBAL-PROCESSING THRU 2300-EXIT          
              ELSE                                                      
                 PERFORM 2210-ESTIMATE-REST   THROUGH 2210-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 15841000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15870000
      ******************************************************************15880000
      * 2210-ESTIMATE-REST.                                            *15900000
      ******************************************************************15910000
       2210-ESTIMATE-REST.                                              
      *                                                                 15921000
           PERFORM 2215-LOAD-SCULPTED-VALUES THRU 2215-EXIT.            
           MOVE 'Y' TO WS-DO-NOT-BUFFER.                                
           SUBTRACT 1 FROM WS-NBR-MTH-CTR.                              
           SUBTRACT WS-NBR-MTH-CTR FROM +12 GIVING WS-MONTHS-TO-EST.    
      *                                                                 15970000
           SET WS-RET-INDX DOWN BY 1.                                   
           MOVE WS-RET-MONTH (WS-RET-INDX) TO WS-LAST-EST-MTH.          
           MOVE WS-RET-YEAR (WS-RET-INDX) TO WS-HOLD-YEAR               
                                             WS-HOLD-YEAR-DDDC.         
      *                                                                 16020000
           SET WS-SC-INDX TO 1.                                         
           SEARCH WS-DDDC-SCULP                                         
             AT END DISPLAY 'CANNOT ESTIMATE'                           
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '2210'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SEARCH SCULP VALUES'     TO ABEND-FUNCTION        
                MOVE +100                      TO WS-ACTIVE-RETURN-CODE 
                PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT               
             WHEN WS-DDDC-SCULP-MTH (WS-SC-INDX) = WS-LAST-EST-MTH      
                      SET WS-SC-INDX UP BY 1.                           
      *                                                                 16150000
           IF WS-SC-INDX > 12                                           
               SET WS-SC-INDX TO 1                                      
               SUBTRACT +1 FROM WS-HOLD-YEAR                            
               MOVE WS-HOLD-YEAR TO WS-HOLD-YEAR-DDDC
           END-IF.                  
           MOVE WS-DDDC-SCULP-MTH (WS-SC-INDX) TO WS-HOLD-MONTH-DDDC.   
           MOVE WS-HOLD-DATE-DDDC-R TO WS-HOLD-DATE-DDDC.               
      *                                                                 16220000
           SET WS-RET-INDX UP BY 1.                                     
      *                                                                 16240000
A04987     IF PR-DDDC-FCTR > 0                                          
A04987        MOVE PR-DDDC-FCTR TO WS-DEFAULT-DDDC                      
A04987     ELSE                                                         
              MOVE 'EPP-DEFAULT-DDDC'        TO C8-DELINQ-CD            
              PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT        
              MOVE C8-DELINQ-VALUE TO WS-DEFAULT-DDDC                   
A04987     END-IF.                                                      
      *                                                                 16280000
           MOVE 'EPP-DEFAULT-THERMS'        TO C8-DELINQ-CD.            
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DEFAULT-THERMS.                   
      *                                                                 16320000
           MOVE 'AGL-METER-CHARGE'        TO C8-DELINQ-CD.              
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-AGL-METER-CHARGE.                 
      *                                                                 16360000
           COMPUTE WS-UNITS ROUNDED =                                   
               (WS-DEFAULT-THERMS * WS-DDDC) / WS-DEFAULT-DDDC.         
      *                                                                 16390000
           MOVE 'Y' TO WS-COMPUTE-PTC.                                  
           PERFORM 2220-BEGIN-ESTIMATE THRU 2220-EXIT                   
                    WS-MONTHS-TO-EST TIMES.                             
      *                                                                 16421000
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16450000
      ******************************************************************16460000
      * 2211-COMPUTE-TAX-EST                                           *16470000
      ******************************************************************16480000
       2211-COMPUTE-TAX-EST.                                            
      *                                                                 16491000
            MOVE ZT-REV-DISTRICT-CD TO  TR-DETAIL-ID                    
            PERFORM 7850-SELECT-TAX-RATE-EST THRU 7850-EXIT.            
      *                                                                 16511000
       2211-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16531000
      ******************************************************************16550000
      * 2212-COMPUTE-PTC   (COMPUTES PASS THRU CHARGES)                *16560000
      ******************************************************************16570000
       2212-COMPUTE-PTC.                                                
      *                                                                 16581000
           PERFORM 7860-OPEN-PASS-THRU-CHARGES THRU 7860-EXIT           
           MOVE SPACES TO WS-END-OF-PTC                                 
           PERFORM UNTIL WS-END-OF-PTC = 'Y'                            
              PERFORM 7870-FETCH-PASS-THRU-CHARGES  THRU 7870-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 EVALUATE SF-CHECK-ELEMENT                              
                   WHEN 'Q'                                             
                   WHEN 'R'                                             
                     EVALUATE SF-FACTOR-ID                              
                       WHEN 'AGL EDUC'                                  
                         CONTINUE                                       
                       WHEN OTHER                                       
                             PERFORM 2213-ADD-PTC THRU 2213-EXIT        
                     END-EVALUATE                                       
                   WHEN 'O'                                             
                     EVALUATE SF-FACTOR-ID                              
                       WHEN 'AGL EDUC'                                  
                         CONTINUE                                       
                       WHEN 'AGL DDAY'                                  
                         IF WS-PROCESS-IND NOT EQUAL 'L'                
                             MOVE SF-ADJUST-ELEMENT TO                  
                                  WS-HOLD-ADJ-ELEMENT                   
                             MOVE SF-FACTOR-ID   TO SA-FACTOR-ID        
                             MOVE 'G'            TO SA-CODE-UTIL-TYPE   
                             MOVE WS-RT-PLAN-NO  TO SA-RATE-PLAN-NO     
                             PERFORM 7900-SUM-DDAY-FACTOR THRU 7900-EXIT
                             COMPUTE WS-ANNUAL-DDAY-FACTOR =            
                               WS-ANNUAL-DDAY-FACTOR * WS-DDDC          
                         ELSE                                           
                             CONTINUE                                   
                         END-IF                                         
                       WHEN 'AGL LNG'                                   
                         IF WS-PROCESS-IND = 'L'                        
                            PERFORM 7910-CHECK-LOC-OFF-EXEMPT THRU      
                                    7910-EXIT                           
                            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND        
                               PERFORM 2214-ADD-PTC-DDDC THRU 2214-EXIT 
                            END-IF                                      
                         ELSE                                           
                            PERFORM 7920-GLO-LOC-OFFICE-EXEMPT THRU     
                                    7920-EXIT                           
                            IF B1-LOCAL-OFFICE-DESC(1:5) = 'MACON' OR   
                                                           'ATLAN' OR   
                                                           'VALDO'      
                               PERFORM 2214-ADD-PTC-DDDC THRU 2214-EXIT 
                            END-IF                                      
                         END-IF                                         
                       WHEN OTHER                                       
                         PERFORM 2214-ADD-PTC-DDDC THRU 2214-EXIT       
                     END-EVALUATE                                       
                  WHEN OTHER                                            
                     PERFORM 2213-ADD-PTC THRU 2213-EXIT                
                 END-EVALUATE                                           
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 7880-CLOSE-PASS-THRU-CHARGES THRU 7880-EXIT.         
      *                                                                 17170000
       2212-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17200000
      ******************************************************************17202000
      * 2213-ADD-PTC.                                                  *17203000
      ******************************************************************17204000
       2213-ADD-PTC.                                                    
      *                                                                 17211000
           MOVE SF-FACTOR-ID   TO SA-FACTOR-ID                          
           MOVE 'G'            TO SA-CODE-UTIL-TYPE                     
           MOVE WS-RT-PLAN-NO  TO SA-RATE-PLAN-NO                       
           PERFORM 7890-SELECT-FACTOR THRU 7890-EXIT                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF SF-ADJUST-ELEMENT = 'A'                                
                   ADD SA-FACTOR TO WS-MNTH-PTC                         
              ELSE                                                      
                   IF (SF-FACTOR-TYPE = 'V' OR SF-FACTOR-TYPE = 'F')    
                       AND SF-ADJUST-ELEMENT = 'H'                      
                       AND WS-SENIOR-IND = 'Y'                          
                           SUBTRACT SA-FACTOR FROM WS-MNTH-PTC          
                   END-IF                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                 17410000
       2213-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17440000
      ******************************************************************17441000
      * 2214-ADD-PTC-DDDC.                                             *17442000
      ******************************************************************17443000
       2214-ADD-PTC-DDDC.                                               
      *                                                                 17451000
           MOVE SF-FACTOR-ID    TO SA-FACTOR-ID                         
           MOVE 'G'             TO SA-CODE-UTIL-TYPE                    
           MOVE WS-RT-PLAN-NO   TO SA-RATE-PLAN-NO                      
           PERFORM 7890-SELECT-FACTOR THRU 7890-EXIT                    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF SF-ADJUST-ELEMENT = 'A'                               
                   COMPUTE WS-MNTH-PTC-DDDC =                           
                          WS-MNTH-PTC-DDDC +                            
                            (SA-FACTOR * WS-DDDC)                       
               ELSE                                                     
                    IF (SF-FACTOR-TYPE = 'V' OR SF-FACTOR-TYPE = 'F')   
                        AND SF-ADJUST-ELEMENT = 'H'                     
                        AND WS-SENIOR-IND = 'Y'                         
                           COMPUTE WS-MNTH-PTC-DDDC =                   
                                  WS-MNTH-PTC-DDDC -                    
                                    (SA-FACTOR * WS-DDDC)               
                    END-IF                                              
               END-IF                                                   
           END-IF.                                                      
      *                                                                 17730000
       2214-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17751000
      ******************************************************************17760000
      * 2215-LOAD-SCULPTED-VALUES.                                     *17780000
      ******************************************************************17790000
       2215-LOAD-SCULPTED-VALUES.                                       
      *                                                                 17801000
           SET WS-SC-INDX TO +1.                                        
           MOVE +12 TO WS-HOLD-MONTH.                                   
           PERFORM 7670-OPEN-SCULP-RATE-CSR THRU 7670-EXIT.             
           PERFORM 7675-FETCH-SCULP-RATE-CSR THRU 7675-EXIT             
                             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.   
           PERFORM 7680-CLOSE-SCULP-RATE-CSR THRU 7680-EXIT.            
      *                                                                 17861000
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17881000
      ****************************************************************  17900000
      * 2220-BEGIN-ESTIMATE.                                         *  17920000
      ****************************************************************  17930000
       2220-BEGIN-ESTIMATE.                                             
      *                                                                 17941000
           COMPUTE WS-UNITS-MNTH ROUNDED =                              
               (WS-UNITS * WS-DDDC-SCULP-VALUE (WS-SC-INDX)) / 100      
      *                                                                 17980000
           COMPUTE WS-NEW-CHARGE = WS-UNITS-MNTH * WS-RATE-PRICE        
      *                                                                 17991000
           MOVE WS-UNITS-MNTH    TO WS-RET-UNITS (WS-RET-INDX)          
           MOVE WS-RET-UNITS (WS-RET-INDX) TO S-UNITS                   
           MOVE ZEROES                     TO S-DAYS                    
           MOVE ZEROES                     TO S-RETURN-CODE-2           
           COMPUTE S-GAS-BUFFER = WS-ESTRATE-INCR-GAS - 1               
      ****************************************************************  18032000
      * COMPUTE PASS THRU CHARGES AND TAX.                           *  18033000
      ****************************************************************  18034000
           IF WS-COMPUTE-PTC = 'Y'                                      
               PERFORM 2212-COMPUTE-PTC     THRU   2212-EXIT            
               MOVE 'N' TO WS-COMPUTE-PTC                               
           END-IF                                                       
           MOVE 'AGL DDAY'   TO SA-FACTOR-ID                            
                                SF-FACTOR-ID                            
           MOVE 'G'          TO SA-CODE-UTIL-TYPE                       
           MOVE WS-RT-PLAN-NO   TO SA-RATE-PLAN-NO                      
           PERFORM 7905-GET-DDAY-FACTOR THRU 7905-EXIT                  
           COMPUTE WS-MONTH-DDAY-FACTOR =                               
                   WS-MONTH-DDAY-FACTOR * WS-DDDC                       
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                                   WS-MNTH-PTC + WS-MNTH-PTC-DDDC +     
                                   WS-AGL-METER-CHARGE                  
           IF SF-ADJUST-ELEMENT = 'A'                                   
              ADD WS-MONTH-DDAY-FACTOR TO WS-NEW-CHARGE                 
           ELSE                                                         
               IF SF-FACTOR-TYPE = 'V' OR SF-FACTOR-TYPE = 'F'          
                   AND SF-ADJUST-ELEMENT = 'H'                          
                   AND WS-SENIOR-IND = 'Y'                              
                     SUBTRACT WS-MONTH-DDAY-FACTOR FROM WS-NEW-CHARGE   
               END-IF                                                   
           END-IF                                                       
      *                                                                 18341000
           PERFORM 2211-COMPUTE-TAX-EST THRU   2211-EXIT                
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                           (WS-NEW-CHARGE * TR-TAX-RATE)                
           ADD WS-CUST-SVC-FEE TO WS-NEW-CHARGE                         
      *                                                                 18381000
           MOVE WS-NEW-CHARGE TO WS-RET-NEW-CHRG (WS-RET-INDX)          
           MOVE WS-RET-NEW-CHRG (WS-RET-INDX) TO S-NEW-CHARGE           
           MOVE 'G'  TO WS-EPP-CATEGORY                                 
           PERFORM 5350-GET-EPP-TOTALS         THRU 5350-EXIT           
           MOVE 'E'           TO WS-RET-EST-ACT (WS-RET-INDX)           
           MOVE WS-DDDC-SCULP-MTH (WS-SC-INDX)                          
                              TO WS-RET-MONTH (WS-RET-INDX)             
           MOVE WS-HOLD-YEAR  TO WS-RET-YEAR (WS-RET-INDX)              
           MOVE WS-RET-REVENUE-DATE (WS-RET-INDX) TO                    
                                                 S-REVENUE-MONTH        
           SET WS-USAGE               TO TRUE                           
      *                                                                 18511000
           PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT                    
           SET WS-RET-INDX UP BY 1                                      
           SET WS-SC-INDX UP BY 1                                       
           IF WS-SC-INDX > 12                                           
               SET WS-SC-INDX TO +1                                     
               SUBTRACT +1 FROM WS-HOLD-YEAR                            
               MOVE WS-HOLD-YEAR TO WS-HOLD-YEAR-DDDC                   
           MOVE WS-DDDC-SCULP-MTH (WS-SC-INDX) TO WS-HOLD-MONTH-DDDC    
           MOVE WS-HOLD-DATE-DDDC-R TO WS-HOLD-DATE-DDDC                
           MOVE ZEROS TO WS-MONTH-DDAY-FACTOR
           END-IF.                          
      *                                                                 18611000
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18631000
      ******************************************************************18650000
      * 2300-GLOBAL-PROCESSING                                         *18670000
      ******************************************************************18680000
       2300-GLOBAL-PROCESSING.                                          
      *                                                                 18691000
           MOVE 'Y' TO WS-DO-NOT-BUFFER.                                
           MOVE '01'                         TO  C8-COMPANY-NO          
                                                 BG-COMPANY-NO.         
           MOVE 'DATABASE'                   TO  C8-DELINQ-CD.          
           INITIALIZE C8-DELINQ-VALUE.                                  
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE              TO LS-DATABASE.            
      *                                                                 18780000
           MOVE 'EPP-DEFAULT-DDDC'          TO C8-DELINQ-CD             
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT           
           MOVE C8-DELINQ-VALUE TO WS-DEFAULT-DDDC                      
      *                                                                 18840000
           MOVE 'EPP-DEFAULT-THERMS'        TO C8-DELINQ-CD.            
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DEFAULT-THERMS.                   
      *                                                                 18880000
           MOVE 'AGL-METER-CHARGE'          TO C8-DELINQ-CD.            
           PERFORM 7500-GET-DELINQ-VALUE       THRU 7500-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-AGL-METER-CHARGE.                 
      *                                                                 18920000
           PERFORM 7155-LOAD-REV-DIST-FROM-ZIP THRU 7155-EXIT.          
      *                                                                 18940000
           COMPUTE WS-UNITS =                                           
                  (WS-DEFAULT-THERMS * WS-DDDC)/WS-DEFAULT-DDDC.        
           COMPUTE WS-NEW-CHARGE = WS-UNITS * WS-RATE-PRICE             
           MOVE 'G'  TO WS-EPP-CATEGORY.                                
      ******************************************************************18981000
      * COMPUTE PASS THRU CHARGES AND TAX.                             *18982000
      ******************************************************************18983000
           PERFORM 2212-COMPUTE-PTC     THRU   2212-EXIT.               
           COMPUTE WS-MNTH-PTC-12MTHS      = WS-MNTH-PTC * 12.          
           COMPUTE WS-MNTH-PTC-DDDC-12MTHS = WS-MNTH-PTC-DDDC * 12.     
      *                                                                 19021000
           IF WS-HOLD-ADJ-ELEMENT = 'A'                                 
             COMPUTE WS-MNTH-PTC-DDDC-12MTHS = WS-MNTH-PTC-DDDC-12MTHS  
                                   +  WS-ANNUAL-DDAY-FACTOR             
           ELSE                                                         
               IF SF-FACTOR-TYPE = 'V' OR SF-FACTOR-TYPE = 'F'          
                   AND WS-HOLD-ADJ-ELEMENT = 'H'                        
                   AND WS-SENIOR-IND = 'Y'                              
                       COMPUTE WS-MNTH-PTC-DDDC-12MTHS =                
                                  WS-MNTH-PTC-DDDC-12MTHS               
                                   -  WS-ANNUAL-DDAY-FACTOR             
               END-IF                                                   
           END-IF.                                                      
      *                                                                 19201000
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE             +          
                                   WS-MNTH-PTC-12MTHS        +          
                                   WS-MNTH-PTC-DDDC-12MTHS   +          
                                   (WS-AGL-METER-CHARGE * 12).          
                                                                        
           COMPUTE WS-AGL-PASS-CHARGE = WS-MNTH-PTC-12MTHS        +     
                                        WS-MNTH-PTC-DDDC-12MTHS   +     
                                        (WS-AGL-METER-CHARGE * 12).     
                                                                        
           DIVIDE WS-AGL-PASS-CHARGE BY 12 GIVING WS-INTEGER REMAINDER  
                                                       WS-REMAINDER.    
                                                                        
           IF WS-REMAINDER GREATER THAN ZERO                            
               ADD +1 TO WS-INTEGER                                     
           END-IF.                                                      
           MOVE WS-INTEGER TO WS-AGL-PASS-CHARGE.                       
                                                                        
           PERFORM 2211-COMPUTE-TAX-EST THRU   2211-EXIT.               
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                           (WS-NEW-CHARGE * TR-TAX-RATE).               
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                           (WS-CUST-SVC-FEE * 12).                      
           DIVIDE WS-NEW-CHARGE BY 12 GIVING WS-INTEGER REMAINDER       
                                                  WS-REMAINDER.         
           IF WS-REMAINDER GREATER THAN ZERO                            
               ADD +1 TO WS-INTEGER                                     
           END-IF.                                                      
           MOVE WS-INTEGER TO WS-NEW-CHARGE.                            
      *                                                                 19451000
           PERFORM 5350-GET-EPP-TOTALS         THRU 5350-EXIT.          
      *                                                                 19471000
           PERFORM 7845-GET-CURRENT-DATE       THRU 7845-EXIT.          
           MOVE WS-CURRENT-DATE (6:2) TO WS-LAST-EST-MTH.               
           MOVE WS-CURRENT-DATE (1:4) TO WS-HOLD-YEAR.                  
      *                                                                 19520000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19550000
      ******************************************************************19560000
      * 5000-CALC-ESTRATE-INCR.                                        *19580000
      ******************************************************************19590000
       5000-CALC-ESTRATE-INCR.                                          
      *                                                                 19610000
           MOVE 'PCT-ESTRATEINCR-GAS'        TO C8-DELINQ-CD            
           PERFORM 7500-GET-DELINQ-VALUE     THRU 7500-EXIT             
           MOVE C8-DELINQ-VALUE              TO WS-ESTRATE-INCR-GAS     
      *                                                                 19670000
           COMPUTE WS-ESTRATE-INCR-GAS =                                
                          (WS-ESTRATE-INCR-GAS * .01) + 1.              
      *                                                                 19700000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19821000
      ******************************************************************19840000
      * 5050-PROCESS-BI-CURSOR                                         *19860000
      ******************************************************************19870000
       5050-PROCESS-BI-CURSOR.                                          
      *                                                                 19881000
           IF BG-REV-MTH-ORIG-BILL > 0                                  
              MOVE BG-REV-MTH-ORIG-BILL      TO WS-REVENUE-MONTH-CHAR   
           ELSE                                                         
              MOVE BG-REVENUE-MONTH          TO WS-REVENUE-MONTH-CHAR   
           END-IF                                                       
      *                                                                 19950000
           MOVE WS-REVENUE-MONTH-CHAR (1:4)  TO WS-YEAR                 
           MOVE WS-REVENUE-MONTH-CHAR (5:2)  TO WS-MONTH                
           MOVE BG-CODE-UTIL-TYPE            TO WS-CODE-UTIL-TYPE       
      *                                                                 19990000
           MOVE BG-ACCOUNT-NO                TO UT-ACCOUNT-NO           
           MOVE BG-CODE-UTIL-TYPE            TO UT-CODE-UTIL-TYPE       
           MOVE BG-IC-NO                     TO UT-IC-NO                
                                                FF-IC-NO                
      *                                                                 20050000
BBPFIX     IF WS-FIRST-TIME-SW = ' '                                    
BBPFIX        PERFORM 7540-GET-PEND-OPTION      THRU 7540-EXIT          
BBPFIX        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
BBPFIX           PERFORM 7550-GET-OPT-CALC-TYPE-CD THRU 7550-EXIT       
BBPFIX        ELSE                                                      
BBPFIX           PERFORM 7560-GET-OPTION           THRU 7560-EXIT       
BBPFIX           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
BBPFIX              PERFORM 7550-GET-OPT-CALC-TYPE-CD THRU 7550-EXIT    
BBPFIX           END-IF                                                 
BBPFIX        END-IF                                                    
BBPFIX                                                                  
BBPFIX        MOVE 'Y' TO WS-FIRST-TIME-SW                              
BBPFIX                                                                  
BBPFIX        IF WS-RATE-CALC-TYPE-CD = 'FP'                            
BBPFIX           MOVE 'PCT-ESTRATEINCR-FR'       TO C8-DELINQ-CD        
BBPFIX           PERFORM 7500-GET-DELINQ-VALUE   THRU 7500-EXIT         
BBPFIX           MOVE C8-DELINQ-VALUE            TO WS-ESTRATE-INCR-GAS 
BBPFIX           COMPUTE WS-ESTRATE-INCR-GAS =                          
BBPFIX                (WS-ESTRATE-INCR-GAS * .01) + 1                   
BBPFIX        END-IF                                                    
BBPFIX                                                                  
BBPFIX     END-IF                                                       
      *                                                                 20271000
           MOVE BG-IC-NO                      TO WS-IC-NO               
               MOVE BG-ACCOUNT-NO             TO CX-ACCOUNT-NO          
               MOVE BG-BILL-ITEM-TIMESTMP     TO CX-BILL-ITEM-TIMESTMP  
               MOVE BG-BILL-NO                TO CX-BILL-NO             
               MOVE BG-CODE-UTIL-TYPE         TO CX-CODE-UTIL-TYPE      
               MOVE BG-IC-NO                  TO CX-IC-NO               
               PERFORM 5100-PROCESS-CX-CURSOR   THRU 5100-EXIT          
      *                                                                 20411000
A04527     IF WS-RET-INDX <= 12                                         
                 MOVE WS-REVENUE-MONTH-CHAR (1:4)                       
                                      TO WS-RET-YEAR (WS-RET-INDX)      
                 MOVE WS-REVENUE-MONTH-CHAR (5:2)                       
                                      TO WS-RET-MONTH (WS-RET-INDX)     
                 MOVE WS-RET-REVENUE-DATE (WS-RET-INDX)                 
                                      TO S-REVENUE-MONTH                
                 MOVE ZEROES          TO S-RETURN-CODE-2                
      *                                                                 20520000
                 MOVE WS-UNITS        TO WS-RET-UNITS (WS-RET-INDX)     
                                         S-UNITS                        
      *                                                                 20550000
                 MOVE WS-DAYS         TO WS-RET-DAYS (WS-RET-INDX)      
                                         S-DAYS                         
      *                                                                 20580000
                 MOVE WS-EPP-GAS-AMT-TBL TO WS-RET-NEW-CHRG(WS-RET-INDX)
                                            S-NEW-CHARGE                
      *                                                                 20610000
                 COMPUTE S-GAS-BUFFER = WS-ESTRATE-INCR-GAS - 1         
      *                                                                 20612000
                 MOVE 'A'             TO WS-RET-EST-ACT (WS-RET-INDX)   
      *                                                                 20630000
                 SET WS-USAGE                  TO TRUE                  
                 PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT              
      *                                                                 20660000
                 SET WS-RET-INDX UP BY 1                                
                 ADD +1 TO WS-NBR-MTH-CTR                               
           END-IF                                                       
      *                                                                 20691000
           PERFORM 7205-FETCH-BI-CURSOR        THRU 7205-EXIT.          
      *                                                                 20711000
       5050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20741000
      ******************************************************************20760000
      * 5100-PROCESS-CX-CURSOR                                         *20780000
      ******************************************************************20790000
       5100-PROCESS-CX-CURSOR.                                          
      *                                                                 20801000
           INITIALIZE LS-PCSCA100-COMM-AREA                             
                  WS-BILLING-CALC-WORK                                  
                  WS-BILLING-COMPONENT                                  
                  WS-BILLING-ADJUSTMENT                                 
                  WS-BILL-CALC-BG                                       
                  WS-BILL-CALC-CX                                       
                  WS-BILL-CALC-UC                                       
                  WS-BILL-CALC-FH                                       
                  WS-BILL-CONTRACT-BK                                   
                  WS-FIXED-FCTR-TABLE-FF                                
                  WS-BILL-CNTR-HIST-BX                                  
                  WS-PEAK-HIST-PH                                       
                  WS-INTERRUPT-ACCT-IP                                  
                  WS-STANDBY-GEN-SE                                     
                  WS-INTERRUPT-IR                                       
                  WS-MTRD-ENVRNMT-TABLE-MN                              
                  WS-HOLD-CX-DATA                                       
                  WS-HOLD-BC-DATA                                       
                  WS-HOLD-BA-DATA                                       
                  WS-BILLING-WQ-ITEMS-WF                                
                  WS-REFUND-RN                                          
                  WS-BC-BILL-ADJUSTMNT                                  
                  WS-BC-ACCT-RTPK-AGR-DF                                
                  WS-BC-FIXED-FCTR-FF                                   
                  WS-BC-BILL-DET-BT                                     
                  WS-BC-VOL-DAILY-ND                                    
                  WS-BILL-CALC-DETAIL-X                                 
                  WS-BILL-BSLN-CNTR-LN                                  
                  WS-BILL-BSLN-HIST-LO                                  
                  WS-CNSMPTN-HOURLY                                     
                  WS-UTL-BILL-REL-TABLE-UR.                             
                                                                        
           MOVE WS-DATABASE                  TO LS-DATABASE             
                                                                        
           PERFORM 5120-LOAD-BILLING-DETAILS THRU 5120-EXIT             
                                                                        
           MOVE SPACES                       TO WS-BC-CALC-DATE         
                                                                        
           MOVE WS-CURRENT-DATE              TO WS-BC-CALC-DATE         
                                                                        
           MOVE ZEROES                       TO WS-UNITS                
                                                                        
           PERFORM 7250-OPEN-CX-CURSOR         THRU 7250-EXIT           
           PERFORM 7255-FETCH-CX-CURSOR        THRU 7255-EXIT           
                                                                        
           SET CX-INDX                       TO 1                       
           PERFORM 5110-LOAD-MTRD-CNSMPTN      THRU 5110-EXIT           
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND     
                                                                        
           PERFORM 7260-CLOSE-CX-CURSOR      THRU 7260-EXIT             
                                                                        
           MOVE SPACES                        TO WS-CALC-ERROR          
                                                                        
           PERFORM 2150-MOVE-FF-FIELDS THRU 2150-EXIT                   
                                                                        
           PERFORM 5900-CALL-BILL-CALC         THRU 5900-EXIT           
                                                                        
           IF WS-CALC-ERROR NOT = SPACE                                 
ACT306        IF WS-CALC-ERROR = 'BC0006'                               
ACT306           MOVE ZEROES TO WS-NEW-CHARGE                           
ACT306           MOVE 'G'  TO WS-EPP-CATEGORY                           
ACT306           PERFORM 5350-GET-EPP-TOTALS  THRU 5350-EXIT            
ACT306           GO TO 5100-EXIT                                        
ACT306        END-IF                                                    
              MOVE ZEROES                    TO WS-NEW-CHARGE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CALC ERROR'              TO ABEND-FUNCTION          
              MOVE 'BILL_CALC'               TO TABLE-ELEMENT-1         
              MOVE +100                      TO WS-ACTIVE-RETURN-CODE   
              MOVE +1000                     TO S-RETURN-CODE           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
ACT277                                                                  
ACT277*** EXIT FEE IS ADDED IN BILL CALC                                21450000
ACT277         PERFORM VARYING BA-INDX FROM 1 BY 1                      
ACT277           UNTIL BA-INDX > 200                                    
ACT277              OR WS-BC-FACTOR-ID (BA-INDX) = SPACES               
ACT277               IF WS-BC-FACTOR-ID (BA-INDX) = 'EXIT FEE'          
ACT277                  SUBTRACT WS-BC-FACTOR(BA-INDX)                  
ACT277                      FROM WS-BC-AMT-BILL-ITEM-BG                 
ACT277               END-IF                                             
ACT277         END-PERFORM                                              
ACT277                                                                  
                                                                        
ACT267*** EXTCREDTX is a credit factor which is subtracted in bill calc 21620200
ACT267         PERFORM VARYING BA-INDX FROM 1 BY 1                      
ACT267           UNTIL BA-INDX > 200                                    
ACT267              OR WS-BC-FACTOR-ID (BA-INDX) = SPACES               
ACT267                IF WS-BC-FACTOR-ID (BA-INDX) = 'EXTCREDTX'        
ACT267                  ADD WS-BC-FACTOR(BA-INDX)                       
ACT267                   TO WS-BC-AMT-BILL-ITEM-BG                      
ACT267                END-IF                                            
ACT267         END-PERFORM                                              
                                                                        
               COMPUTE WS-BC-AMT-BILL-ITEM-BG =                         
                       WS-BC-AMT-BILL-ITEM-BG + WS-AGL-METER-CHARGE     
               PERFORM 5300-COMPUTE-TAXES     THRU 5300-EXIT            
               MOVE WS-BILL-AMT-PLUS-TAXES    TO WS-NEW-CHARGE          
           END-IF                                                       
                                                                        
                 COMPUTE WS-UNITS ROUNDED =                             
                                     WS-UNITS * WS-BC-BTU-FACTOR-BG     
                                                                        
           MOVE WS-BC-NO-CNSMPTN-DAYS        TO WS-DAYS                 
                                                                        
A04527     MOVE 'G'  TO WS-EPP-CATEGORY                                 
           PERFORM 5350-GET-EPP-TOTALS         THRU 5350-EXIT.          
      *                                                                 21840000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21870000
      ***************************************************************** 21880000
      * 5110-LOAD-MTRD-CNSMPTN.                                       * 21900000
      ***************************************************************** 21910000
       5110-LOAD-MTRD-CNSMPTN.                                          
      *                                                                 21931000
A04527     ADD CX-NO-UNITS    TO WS-UNITS                               
      *                                                                 22041000
           MOVE BG-ACCOUNT-NO                                           
             TO WS-BC-ACCOUNT-NO-CX (CX-INDX).                          
           MOVE BG-BILL-NO                                              
             TO WS-BC-BILL-NO-CX (CX-INDX).                             
           MOVE BG-CODE-UTIL-TYPE                                       
             TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX).                      
           MOVE BG-IC-NO                                                
             TO WS-BC-IC-NO-CX (CX-INDX).                               
           MOVE BG-BILL-ITEM-TIMESTMP                                   
             TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX).                  
           MOVE CX-MTR-REF-NO                                           
             TO WS-BC-MTR-REF-NO-CX (CX-INDX).                          
           MOVE CX-CODE-USAGE-TYPE                                      
             TO WS-BC-CODE-USAGE-TYPE-CX (CX-INDX).                     
           MOVE CX-CODE-USAGE-ID                                        
             TO WS-BC-CODE-USAGE-ID-CX (CX-INDX).                       
           MOVE CX-CODE-USAGE-SOURCE                                    
             TO WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX).                   
           MOVE CX-CODE-TIME-PERIOD                                     
             TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX).                    
           MOVE CX-ITEM-SEQ-NO                                          
             TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX).                         
           MOVE CX-METER-NO                                             
             TO WS-BC-METER-NO-CX (CX-INDX).                            
           MOVE CX-REG-ID-NO                                            
             TO WS-BC-REG-ID-NO-CX (CX-INDX).                           
           MOVE CX-DATE-READ                                            
             TO WS-BC-DATE-READ-CX (CX-INDX).                           
           MOVE CX-CODE-METER-READ                                      
             TO WS-BC-CODE-METER-READ-CX (CX-INDX).                     
           MOVE CX-CODE-METER-NO-READ                                   
             TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX).                  
           MOVE CX-METER-READING                                        
             TO WS-BC-METER-READING-CX (CX-INDX).                       
           MOVE CX-DEMAND-READING                                       
             TO WS-BC-DEMAND-READING-CX (CX-INDX).                      
           MOVE CX-EMPLOYEE-NO                                          
             TO WS-BC-EMPLOYEE-NO-CX (CX-INDX).                         
           MOVE CX-NO-UNITS                                             
             TO WS-BC-NO-UNITS-CX (CX-INDX).                            
           MOVE CX-NO-DEMAND-UNITS                                      
             TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).                     
           MOVE CX-NO-DAYS                                              
             TO WS-BC-NO-DAYS-CX (CX-INDX).                             
           MOVE CX-CODE-SOURCE-ID                                       
             TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX).                      
           MOVE CX-CODE-DEBIT-CREDIT                                    
             TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX).                   
           MOVE CX-CODE-ITEM-STATUS                                     
             TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).                    
           MOVE CX-CODE-DISCOUNT                                        
             TO WS-BC-CODE-DISCOUNT-CX (CX-INDX).                       
           MOVE CX-CONSTANT                                             
             TO WS-BC-CONSTANT-CX (CX-INDX).                            
           MOVE CX-NO-DIALS                                             
             TO WS-BC-NO-DIALS-CX (CX-INDX).                            
           MOVE CX-COMPANY-NO                                           
             TO WS-BC-COMPANY-NO-CX (CX-INDX).                          
           MOVE CX-EXCEPT-OVERRIDE-CD                                   
             TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX).                  
           MOVE CX-REQUESTED-USAGE                                      
             TO WS-BC-REQUESTED-USAGE-CX (CX-INDX).                     
           MOVE CX-DIGTL-INTRL-MTR-NO                                   
             TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX).                  
           MOVE CX-DIGTL-MTR-TYPE                                       
             TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).                      
           MOVE CX-CODE-TOU-SEASN                                       
             TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX).                      
           MOVE CX-EXCL-DMD-RCHT-IND                                    
             TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX).                   
           MOVE SPACE                                                   
             TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
                                                                        
      *                                                                 22781000
           SET CX-INDX UP BY 1.                                         
      *                                                                 22791000
           PERFORM 7255-FETCH-CX-CURSOR      THRU 7255-EXIT.            
      *                                                                 22811000
       5110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22850000
      ***************************************************************** 22860000
      * 5120-LOAD-BILLING-DETAILS.                                    * 22880000
      ***************************************************************** 22890000
       5120-LOAD-BILLING-DETAILS.                                       
      *                                                                 22901000
           MOVE BG-ACCOUNT-NO           TO WS-BC-ACCOUNT-NO-BG.         
           MOVE BG-BILL-NO              TO WS-BC-BILL-NO-BG.            
           MOVE BG-CODE-UTIL-TYPE       TO WS-BC-CODE-UTIL-TYPE-BG.     
           MOVE BG-IC-NO                TO WS-BC-IC-NO-BG.              
           MOVE BG-BILL-ITEM-TIMESTMP   TO WS-BC-BILL-ITEM-TIMESTMP-BG. 
           MOVE BG-PREMISE-NO           TO WS-BC-PREMISE-NO-BG.         
           MOVE LOW-VALUES              TO WS-BC-DATE-ORIG-BILL-BG.     
           MOVE 'I'                     TO WS-BC-PRORATE-OVERRIDE-IND.  
           MOVE 'A'                     TO WS-BC-CODE-BILL-STATUS-BI.   
           MOVE BG-AMT-BILL-ITEM        TO WS-BC-AMT-BILL-ITEM-BG.      
           MOVE BG-CODE-BILL-CALC       TO WS-BC-CODE-BILL-CALC-BG.     
           MOVE BG-CODE-BILL-ITM-TYPE   TO WS-BC-CODE-BILL-ITM-TYPE-BG. 
           MOVE BG-CODE-BILL-ITM-IND    TO WS-BC-CODE-BILL-ITM-IND-BG.  
           MOVE BG-CODE-DR-CR-CNSMPTN   TO WS-BC-CODE-DR-CR-CNSMPTN-BG. 
           MOVE BG-AMT-STATE-TAX        TO WS-BC-AMT-STATE-TAX-BG.      
           MOVE BG-AMT-CITY-TAX         TO WS-BC-AMT-CITY-TAX-BG.       
           MOVE BG-AMT-OTHER-TAX        TO WS-BC-AMT-OTHER-TAX-BG.      
           MOVE BG-CODE-REVENUE-CLASS   TO WS-BC-CODE-REVENUE-CLASS-BG. 
           MOVE BG-CODE-SIC-NO          TO WS-BC-CODE-SIC-NO-BG.        
A04527     MOVE BG-RATE-PLAN-NO         TO WS-BC-RATE-PLAN-NO-BG.       
           MOVE WS-BC-RATE-PLAN-NO-BG   TO WS-RATE-PLAN-NO.             
A04527     MOVE ZEROS                   TO WS-BC-CODE-CURTAIL-PRTY-BG.  
A04527     MOVE 'M01'                   TO WS-BC-CODE-MTR-READ-FREQ-BG. 
           MOVE BG-CODE-STAT-TAX-XMT    TO WS-BC-CODE-STAT-TAX-XMT-BG.  
           MOVE BG-CODE-CITY-TAX-XMT    TO WS-BC-CODE-CITY-TAX-XMT-BG.  
           MOVE BG-CODE-OTHR-TAX-XMT    TO WS-BC-CODE-OTHR-TAX-XMT-BG.  
           MOVE BG-REV-RPT-CD           TO WS-BC-REV-RPT-CD-BG.         
           MOVE BG-STANDBY-COMPLIED     TO WS-BC-STANDBY-COMPLIED-BG.   
           MOVE BG-PRORATE-CD           TO WS-BC-PRORATE-CD-BG.         
           MOVE BG-NEW-RATE-PCT         TO WS-BC-NEW-RATE-PCT-BG.       
           MOVE BG-CODE-SUB-TOTAL       TO WS-BC-CODE-SUB-TOTAL-BG.     
           MOVE BG-TAX-REFUND-CD        TO WS-BC-TAX-REFUND-CD-BG.      
           MOVE BG-COMPANY-NO           TO WS-BC-COMPANY-NO-BG.         
           MOVE BG-DATE-LFTM-HI-DMD     TO WS-BC-DATE-LFTM-HI-DMD-BG.   
           MOVE BG-LFTM-HI-PEAK-DMD     TO WS-BC-LFTM-HI-PEAK-DMD-BG.   
           MOVE BG-REBILL-IND           TO WS-BC-REBILL-IND-BG.         
           MOVE BG-REVENUE-MONTH        TO WS-BC-REV-MTH-ORIG-BILL-BG.  
           MOVE WS-CURR-REVENUE-MONTH   TO WS-BC-REVENUE-MONTH-BG       
                                           WS-CURR-REVENUE-MONTH-NUM.   
           MOVE WS-CURR-REV-YEAR        TO WS-REV-CCYY-TEMP.            
           MOVE WS-CURR-REV-MTH         TO WS-REV-MM-TEMP.              
           MOVE BG-GAS-BASE-USE         TO WS-BC-GAS-BASE-USE-BG.       
           MOVE BG-ADJ-REASON-CD        TO WS-BC-ADJ-REASON-CD-BG.      
           MOVE 0                       TO WS-BC-WNA-FACTOR-BG.         
           MOVE BG-BTU-FACTOR           TO WS-BC-BTU-FACTOR-BG.         
ACT250     MOVE BG-ACCOUNT-NO           TO UT-ACCOUNT-NO.               
ACT250     MOVE BG-CODE-UTIL-TYPE       TO UT-CODE-UTIL-TYPE.           
ACT250     MOVE BG-IC-NO                TO UT-IC-NO.                    
ACT250     PERFORM 7570-SELECT-READ-FREQ THRU 7570-EXIT.                
ACT250     MOVE UT-CODE-MTR-READ-FREQ   TO WS-BC-CODE-MTR-READ-FREQ-BG. 
ACT250     IF   BG-RT-PKG-OPT-SEQ-NO = 0                                
ACT250       MOVE UT-RT-PKG-OPT-SEQ-NO                                  
ACT250         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                            
ACT250     ELSE                                                         
ACT250       MOVE BG-RT-PKG-OPT-SEQ-NO                                  
ACT250         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                            
ACT250     END-IF.                                                      
      *                                                                 23660000
       5120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23690000
      ****************************************************************  24560000
      * 5300-COMPUTE-TAXES.                                          *  24580000
      ****************************************************************  24590000
       5300-COMPUTE-TAXES.                                              
      *                                                                 24601000
           IF WS-TAX-TABLE-ENTRIES = ZERO                               
              PERFORM 5310-LOAD-TAX-RATES      THRU 5310-EXIT           
              PERFORM 5320-LOAD-EXCISE-RATES   THRU 5320-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 5330-GET-SPECIAL-EXEMPTIONS THRU 5330-EXIT           
                                                                        
           MOVE ZERO                         TO WS-STATE-TAXABLE-AMT    
                                                WS-CITY-TAXABLE-AMT     
                                                WS-OTHER-TAXABLE-AMT    
                                                WS-CITY-TAX-RATE-CALC   
                                                WS-STATE-TAX-RATE-CALC  
                                                                        
           IF WS-BC-CODE-STAT-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG    TO WS-STATE-TAXABLE-AMT    
                                                                        
              IF WS-BC-CODE-OTHR-TAX-XMT-BG = 'N' OR SPACE              
                 MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-OTHER-TAXABLE-AMT    
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-BC-CODE-CITY-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG    TO WS-CITY-TAXABLE-AMT     
           END-IF                                                       
                                                                        
           IF WS-BC-CODE-OTHR-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG    TO WS-OTHER-TAXABLE-AMT    
           END-IF                                                       
                                                                        
             IF WS-STATE-TAXABLE-AMT > ZERO                             
                 OR WS-CITY-TAXABLE-AMT > ZERO                          
                 OR WS-OTHER-TAXABLE-AMT > ZERO                         
              PERFORM VARYING BA-INDX FROM 1 BY 1                       
                      UNTIL BA-INDX > 200                               
                         OR WS-BC-FACTOR-ID (BA-INDX) = SPACE           
                 IF ADD-TO-COMPONENT-AMT (BA-INDX)                      
                       OR SUB-FROM-COMPONENT-AMT (BA-INDX)              
                       OR REPL-COMPONENT-AMT (BA-INDX)                  
                    IF WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX) = 'Y'         
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-STATE-TAXABLE-AMT                     
                    END-IF                                              
                    IF WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX) = 'Y'          
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-CITY-TAXABLE-AMT                      
                    END-IF                                              
                    IF WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX) = 'Y'         
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-OTHER-TAXABLE-AMT                     
                    END-IF                                              
                 END-IF                                                 
              END-PERFORM                                               
             END-IF                                                     
                                                                        
           IF WS-CITY-TAXABLE-AMT > ZERO                                
              PERFORM 5340-CALCULATE-CITY-TAX THRU 5340-EXIT            
              IF WS-BC-CODE-STAT-TAX-XMT-BG = 'N' OR SPACE              
                 ADD WS-BC-AMT-CITY-TAX-BG   TO WS-STATE-TAXABLE-AMT    
                 ADD WS-BC-AMT-CITY-TAX-BG   TO WS-OTHER-TAXABLE-AMT    
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-OTHER-TAXABLE-AMT > ZERO                               
              PERFORM 5360-CALCULATE-OTHER-TAX THRU 5360-EXIT           
           END-IF                                                       
                                                                        
           IF WS-STATE-TAXABLE-AMT > ZERO                               
              PERFORM 5370-CALCULATE-STATE-TAX THRU 5370-EXIT           
           END-IF                                                       
                                                                        
             COMPUTE WS-BILL-AMT-PLUS-TAXES = WS-BC-AMT-BILL-ITEM-BG    
                  + (WS-BC-AMT-BILL-ITEM-BG * WS-STATE-TAX-RATE-CALC)   
                                                                        
           COMPUTE WS-BILL-AMT-PLUS-TAXES ROUNDED =                     
                   WS-BILL-AMT-PLUS-TAXES                               
                + (WS-BILL-AMT-PLUS-TAXES * WS-CITY-TAX-RATE-CALC).     
      *                                                                 25461000
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25491000
      ****************************************************************  25510000
      * 5310-LOAD-TAX-RATES                                          *  25530000
      ****************************************************************  25540000
       5310-LOAD-TAX-RATES.                                             
      *                                                                 25551000
           MOVE HIGH-VALUES                  TO WS-TAX-RATE-TABLE       
           SET TC-INDX                       TO 1                       
           MOVE ZERO                         TO WS-TAX-TABLE-ENTRIES    
                                                                        
           PERFORM 7600-OPEN-TAX-DATA          THRU 7600-EXIT           
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              PERFORM 7605-FETCH-TAX-DATA    THRU 7605-EXIT             
                                                                        
              IF SQLCODE = SUCCESSFUL-CALL                              
                 IF WS-TAX-TABLE-ENTRIES = WS-TAX-TABLE-ENTRIES-MAX     
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '5310'              TO ACTIVE-PARAGRAPH        
                    MOVE 'TAX ENTRIES '      TO ABEND-FUNCTION          
                    MOVE 'GREATER THAN 1000' TO TABLE-1                 
                    MOVE +100                TO WS-ACTIVE-RETURN-CODE   
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
                 ELSE                                                   
                    PERFORM 5380-LOAD-TAX-ENTRY THRU 5380-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
                                                                        
           PERFORM 7610-CLOSE-TAX-DATA         THRU 7610-EXIT.          
      *                                                                 25811000
       5310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25841000
      ****************************************************************  25860000
      * 5320-LOAD-EXCISE-RATES                                       *  25880000
      ****************************************************************  25890000
       5320-LOAD-EXCISE-RATES.                                          
      *                                                                 25901000
           INITIALIZE WS-TAX-EXCISE-TABLE                               
           SET X6-INDX TO 1                                             
           MOVE ZERO                         TO WS-TAX-EX-ENTRIES       
           PERFORM 7650-OPEN-EX-DATA           THRU 7650-EXIT           
                                                                        
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              PERFORM 7655-FETCH-EX-DATA       THRU 7655-EXIT           
              IF SQLCODE = SUCCESSFUL-CALL                              
                 IF WS-TAX-EX-ENTRIES = WS-TAX-EX-ENTRIES-MAX           
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '5320'              TO ACTIVE-PARAGRAPH        
                    MOVE 'EX ENTRIES '       TO ABEND-FUNCTION          
                    MOVE 'GREATER THAN 100 ' TO TABLE-1                 
                    MOVE +100                TO WS-ACTIVE-RETURN-CODE   
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
                 ELSE                                                   
                    PERFORM 5390-LOAD-EX-ENTRY THRU 5390-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                 26140000
           PERFORM 7660-CLOSE-EX-DATA        THRU 7660-EXIT.            
      *                                                                 26160000
       5320-EXIT.                                                       
            EXIT.                                                       
      *                                                                 26190000
      ****************************************************************  26200000
      * 5330-GET-SPECIAL-EXEMPTIONS                                  *  26220000
      ****************************************************************  26230000
       5330-GET-SPECIAL-EXEMPTIONS.                                     
      *                                                                 26241000
           MOVE BG-COMPANY-NO                TO F2-COMPANY-NO           
                                                F3-COMPANY-NO.          
           MOVE ZT-REV-DISTRICT-CD           TO F2-REV-DISTRICT-CD.     
           MOVE WS-BC-CODE-REVENUE-CLASS-BG  TO F2-CODE-REVENUE-CLASS   
                                                F3-CODE-REVENUE-CLASS.  
           MOVE WS-BC-CODE-UTIL-TYPE-BG      TO F2-CODE-UTIL-TYPE       
                                                F3-CODE-UTIL-TYPE.      
                                                                        
           IF WS-BC-CODE-CITY-TAX-XMT-BG = SPACE                        
              PERFORM 7800-GET-FRAN-TX-XMPTN THRU 7800-EXIT             
              IF WS-FT-XMPT = 'Y'                                       
                 MOVE 'Y'                  TO WS-BC-CODE-CITY-TAX-XMT-BG
              END-IF                                                    
           END-IF.                                                      
           IF WS-BC-CODE-STAT-TAX-XMT-BG = SPACE                        
              PERFORM 7810-GET-STATE-TX-XMPTN THRU 7810-EXIT            
              IF WS-ST-XMPT = 'Y'                                       
                 MOVE 'A'                  TO WS-BC-CODE-STAT-TAX-XMT-BG
                 MOVE 'A'                  TO WS-BC-CODE-OTHR-TAX-XMT-BG
              END-IF                                                    
           END-IF.                                                      
      *                                                                 26470000
       5330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26500000
      ****************************************************************  26510000
      * 5340-CALCULATE-CITY-TAX                                      *  26530000
      ****************************************************************  26540000
       5340-CALCULATE-CITY-TAX.                                         
      *                                                                 26551000
           MOVE ZT-REV-DISTRICT-CD           TO WS-TAX-JURISDICTION-CD  
           MOVE 'B'                          TO WS-TAX-COMPARE-TYPE     
           MOVE  ZERO                        TO WS-CITY-TAX-RATE-CALC   
                                                                        
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
                           UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES         
                           OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES      
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF ( WS-BC-CODE-UTIL-TYPE-BG = 'G' AND                 
                      WS-TU-GAS (TC-INDX) = 'Y')                        
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'W' AND                 
                      WS-TU-WATER (TC-INDX) = 'Y')                      
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'S' AND                 
                      WS-TU-SEWER (TC-INDX) = 'Y')                      
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'T' AND                 
                      WS-TU-TRASH (TC-INDX) = 'Y')                      
                    PERFORM 5395-APPLY-TAX     THRU 5395-EXIT           
                 ELSE                                                   
                    MOVE ZERO                TO WS-BC-AMT-CITY-TAX-BG   
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 26870000
       5340-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26900000
      ****************************************************************  26910000
      * 5350-GET-EPP-TOTALS                                          *  26930000
      ****************************************************************  26940000
       5350-GET-EPP-TOTALS.                                             
      *                                                                 26951000
           IF WS-EPP-CATEGORY   = 'G'                                   
             IF WS-DO-NOT-BUFFER = 'N'                                  
              COMPUTE WS-EPP-GAS-AMT = WS-EPP-GAS-AMT                   
                           + (WS-NEW-CHARGE * WS-ESTRATE-INCR-GAS)      
              COMPUTE WS-EPP-GAS-AMT-TBL =                              
                             (WS-NEW-CHARGE * WS-ESTRATE-INCR-GAS)      
             ELSE                                                       
              COMPUTE WS-EPP-GAS-AMT = WS-EPP-GAS-AMT                   
                           +  WS-NEW-CHARGE                             
              COMPUTE WS-EPP-GAS-AMT-TBL =  WS-NEW-CHARGE               
             END-IF                                                     
              ADD 1         TO WS-MONTHS-GAS-USG                        
A04527     END-IF.                                                      
      *                                                                 27180000
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27210000
      ****************************************************************  27220000
      * 5360-CALCULATE-OTHER-TAX                                     *  27240000
      ****************************************************************  27250000
       5360-CALCULATE-OTHER-TAX.                                        
      *                                                                 27261000
           MOVE ZT-REV-DISTRICT-CD           TO WS-TAX-JURISDICTION-CD  
           MOVE WS-OTHER-TAX                 TO WS-TAX-COMPARE-TYPE     
                                                                        
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
                            UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES        
                            OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES     
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
A04527           IF (WS-BC-CODE-UTIL-TYPE-BG = 'G'                      
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'W'                 
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'S'                 
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'T'                 
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                                                                        
                    PERFORM 5385-APPLY-OTHER-TAX THRU 5385-EXIT         
                                                                        
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 27570000
       5360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27600000
      ****************************************************************  27610000
      * 5370-CALCULATE-STATE-TAX                                     *  27630000
      ****************************************************************  27640000
       5370-CALCULATE-STATE-TAX.                                        
      *                                                                 27651000
           MOVE ZT-REV-DISTRICT-CD     TO WS-TAX-JURISDICTION-CD        
           MOVE 'A' TO WS-TAX-COMPARE-TYPE                              
           MOVE  ZERO TO WS-STATE-TAX-RATE-CALC                         
                                                                        
           PERFORM VARYING TC-INDX FROM 1 BY 1                          
             UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
                OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
              IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
A04527           IF ( WS-BC-CODE-UTIL-TYPE-BG = 'G' AND                 
                      WS-TU-GAS (TC-INDX) = 'Y')                        
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'W' AND                 
                      WS-TU-WATER (TC-INDX) = 'Y')                      
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'S' AND                 
                      WS-TU-SEWER (TC-INDX) = 'Y')                      
                 OR ( WS-BC-CODE-UTIL-TYPE-BG = 'T' AND                 
                      WS-TU-TRASH (TC-INDX) = 'Y')                      
                    PERFORM 5420-APPLY-TAX   THRU 5420-EXIT             
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 27950000
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27980000
      ****************************************************************  27990000
      * 5380-LOAD-TAX-ENTRY                                          *  28010000
      ****************************************************************  28020000
       5380-LOAD-TAX-ENTRY.                                             
      *                                                                 28031000
           IF WS-TC-TAX-TYPE (TC-INDX) = TC-TAX-TYPE                    
            AND WS-TR-TAX-JURISDICTION (TC-INDX) = TR-DETAIL-ID         
            AND WS-TC-TAX-CNTRL-NO (TC-INDX) = TC-TAX-CNTRL-NO          
              IF WS-TR-DATE-FROM (TC-INDX 2) = HIGH-VALUES              
                 MOVE TR-DATE-FROM        TO WS-TR-DATE-FROM (TC-INDX 2)
                 IF TR-DATE-TO > LOW-VALUES                             
                    MOVE TR-DATE-TO        TO WS-TR-DATE-TO (TC-INDX 2) 
                 ELSE                                                   
                    MOVE '9999-12-31'      TO WS-TR-DATE-TO (TC-INDX 2) 
                 END-IF                                                 
                 IF WS-TR-DATE-FROM (TC-INDX 2)                         
                       > WS-TR-DATE-TO (TC-INDX 1)                      
                    MOVE WS-TR-DATE-FROM (TC-INDX 2)                    
                      TO WS-TR-DATE-TO (TC-INDX 1)                      
                 END-IF                                                 
                 MOVE TR-TAX-RATE            TO WS-TAX-RATE (TC-INDX 2) 
              END-IF                                                    
           ELSE                                                         
              ADD 1                          TO WS-TAX-TABLE-ENTRIES    
              SET TC-INDX                    TO WS-TAX-TABLE-ENTRIES    
              MOVE TC-TAX-TYPE               TO WS-TC-TAX-TYPE (TC-INDX)
              MOVE TR-DETAIL-ID TO WS-TR-TAX-JURISDICTION (TC-INDX)     
              MOVE TR-DATE-FROM TO WS-TR-DATE-FROM (TC-INDX 1)          
              IF TR-DATE-TO > LOW-VALUES                                
                 MOVE TR-DATE-TO   TO WS-TR-DATE-TO (TC-INDX 1)         
              ELSE                                                      
                 MOVE '9999-12-31' TO WS-TR-DATE-TO (TC-INDX 1)         
              END-IF                                                    
              MOVE TR-TAX-RATE           TO WS-TAX-RATE (TC-INDX 1)     
              MOVE TU-CODE-TAX-CALC-INST TO WS-TU-CALC-INST (TC-INDX)   
              MOVE TU-TAX-GAS            TO WS-TU-GAS   (TC-INDX)       
              MOVE TU-TAX-MDSE           TO WS-TU-MDSE  (TC-INDX)       
              MOVE TU-TAX-WATER          TO WS-TU-WATER (TC-INDX)       
              MOVE TU-TAX-SEWER          TO WS-TU-SEWER (TC-INDX)       
              MOVE TU-TAX-TRASH          TO WS-TU-TRASH (TC-INDX)       
              MOVE TC-TAX-CNTRL-NO       TO WS-TC-TAX-CNTRL-NO (TC-INDX)
              MOVE TC-FACTOR-ID          TO WS-TU-FACTOR-ID (TC-INDX)   
           END-IF.                                                      
      *                                                                 28440000
       5380-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28470000
      ****************************************************************  28480000
      * 5385-APPLY-OTHER-TAX                                         *  28500000
      ****************************************************************  28510000
       5385-APPLY-OTHER-TAX.                                            
      *                                                                 28521000
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
              MOVE ZERO TO WS-V1-REV-MTH                                
                           WS-V2-REV-MTH                                
              IF BG-REV-MTH-ORIG-BILL     > 0                           
                 MOVE BG-REV-MTH-ORIG-BILL                              
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-BC-REVENUE-MONTH-BG                            
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
              MOVE WS-TR-DATE-FROM (TC-INDX 1) TO WS-START-DATE         
              MOVE WS-START-DATE (6:2) TO WS-V2-REV-MTH (5:2)           
              MOVE WS-START-DATE (1:4) TO WS-V2-REV-MTH (1:4)           
              IF WS-TR-DATE-FROM (TC-INDX 2) NOT = HIGH-VALUES          
                 MOVE WS-TR-DATE-FROM (TC-INDX 2) TO WS-START-DATE      
                 MOVE WS-START-DATE (6:2) TO WS-V1-REV-MTH (5:2)        
                 MOVE WS-START-DATE (1:4) TO WS-V1-REV-MTH (1:4)        
              END-IF                                                    
           ELSE                                                         
              EVALUATE TRUE                                             
                 WHEN WS-BC-CNSMPTN-START-DATE                          
                     >= WS-TR-DATE-FROM (TC-INDX 1)                     
                    COMPUTE WS-AMT-OTHER-TAX ROUNDED                    
                        = WS-OTHER-TAXABLE-AMT                          
                            * WS-TAX-RATE (TC-INDX 1)                   
                 WHEN (WS-BC-CNSMPTN-END-DATE                           
                     <= WS-TR-DATE-TO (TC-INDX 2)                       
                  AND WS-TR-DATE-TO (TC-INDX 2) NOT = HIGH-VALUES)      
                    COMPUTE WS-AMT-OTHER-TAX ROUNDED                    
                        = WS-OTHER-TAXABLE-AMT                          
                            * WS-TAX-RATE (TC-INDX 2)                   
                 WHEN WS-TU-CALC-INST (TC-INDX) = 'B'                   
                    IF WS-BC-CNSMPTN-END-DATE                           
                      >= WS-TR-DATE-FROM (TC-INDX 1)                    
                    COMPUTE WS-AMT-OTHER-TAX                            
                          ROUNDED                                       
                        = WS-OTHER-TAXABLE-AMT                          
                           * WS-TAX-RATE (TC-INDX 1)                    
                    ELSE                                                
                       COMPUTE WS-AMT-OTHER-TAX                         
                           ROUNDED                                      
                         = WS-OTHER-TAXABLE-AMT                         
                            * WS-TAX-RATE (TC-INDX 2)                   
                    END-IF                                              
                 WHEN OTHER                                             
                    PERFORM 5410-PRORATE-OTH-TAXES THRU 5410-EXIT       
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                 29011000
       5385-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29031000
      ****************************************************************  29050000
      * 5390-LOAD-EX-ENTRY                                           *  29070000
      ****************************************************************  29080000
       5390-LOAD-EX-ENTRY.                                              
      *                                                                 29091000
              ADD  1                TO WS-TAX-EX-ENTRIES.               
              SET  X6-INDX          TO WS-TAX-EX-ENTRIES.               
              MOVE X6-TAX-CNTRL-NO  TO WS-X6-TAX-CNTRL-NO (X6-INDX).    
              MOVE X6-DATE-FROM     TO WS-X6-TAX-DATE-FROM (X6-INDX).   
              MOVE X6-BLOCK-NO      TO WS-X6-BLOCK-NO (X6-INDX)    .    
              MOVE X6-BLOCK-UNITS   TO WS-X6-BLOCK-UNITS (X6-INDX) .    
              MOVE X6-EXCISE-TAX-UNIT-AM                                
                                  TO WS-X6-EXCISE-TAX-UNIT-AM(X6-INDX). 
      *                                                                 29181000
       5390-EXIT .                                                      
            EXIT.                                                       
      *                                                                 29201000
      ****************************************************************  29220000
      * 5395-APPLY-TAX                                               *  29240000
      ****************************************************************  29250000
       5395-APPLY-TAX.                                                  
      *                                                                 29261000
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
              IF BG-REV-MTH-ORIG-BILL > 0                               
                 MOVE BG-REV-MTH-ORIG-BILL                              
                   TO WS-REV-MONTH-TEST                                 
              ELSE                                                      
                 MOVE WS-BC-REVENUE-MONTH-BG                            
                   TO WS-REV-MONTH-TEST                                 
              END-IF                                                    
              MOVE ZERO TO WS-V1-REV-MTH                                
                           WS-V2-REV-MTH                                
              MOVE WS-TR-DATE-FROM (TC-INDX 1) TO WS-START-DATE         
              MOVE WS-START-DATE (6:2) TO WS-V2-REV-MTH (5:2)           
              MOVE WS-START-DATE (1:4) TO WS-V2-REV-MTH (1:4)           
              IF WS-TR-DATE-FROM (TC-INDX 2) NOT = HIGH-VALUES          
                 MOVE WS-TR-DATE-FROM (TC-INDX 2) TO WS-START-DATE      
                 MOVE WS-START-DATE (6:2) TO WS-V1-REV-MTH (5:2)        
                 MOVE WS-START-DATE (1:4) TO WS-V1-REV-MTH (1:4)        
              END-IF                                                    
              IF WS-REV-MONTH-TEST >= WS-V2-REV-MTH                     
                 COMPUTE WS-BC-AMT-CITY-TAX-BG ROUNDED                  
                   = WS-CITY-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 1)      
                 MOVE WS-TAX-RATE (TC-INDX 1)                           
                   TO WS-CITY-TAX-RATE-CALC                             
              ELSE                                                      
                 IF WS-V1-REV-MTH > 0                                   
                  AND WS-REV-MONTH-TEST >= WS-V1-REV-MTH                
                    COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED              
                      = WS-STATE-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 2)  
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-CITY-TAX-RATE-CALC                          
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              EVALUATE TRUE                                             
                 WHEN WS-BC-CNSMPTN-START-DATE                          
                     >= WS-TR-DATE-FROM (TC-INDX 1)                     
                    COMPUTE WS-BC-AMT-CITY-TAX-BG                       
                             ROUNDED                                    
                        = WS-CITY-TAXABLE-AMT                           
                            * WS-TAX-RATE (TC-INDX 1)                   
                    MOVE WS-TAX-RATE (TC-INDX 1)                        
                      TO WS-CITY-TAX-RATE-CALC                          
                 WHEN WS-BC-CNSMPTN-END-DATE                            
                     <= WS-TR-DATE-TO (TC-INDX 2)                       
                    COMPUTE WS-BC-AMT-CITY-TAX-BG                       
                             ROUNDED                                    
                          = WS-CITY-TAXABLE-AMT                         
                             * WS-TAX-RATE (TC-INDX 2)                  
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-CITY-TAX-RATE-CALC                          
                 WHEN WS-TU-CALC-INST (TC-INDX) = 'B'                   
                    IF WS-BC-CNSMPTN-END-DATE                           
                         >= WS-TR-DATE-FROM (TC-INDX 1)                 
                       COMPUTE WS-BC-AMT-CITY-TAX-BG                    
                             ROUNDED                                    
                           = WS-CITY-TAXABLE-AMT                        
                             * WS-TAX-RATE (TC-INDX 1)                  
                       MOVE WS-TAX-RATE (TC-INDX 1)                     
                         TO WS-CITY-TAX-RATE-CALC                       
                    ELSE                                                
                       COMPUTE WS-BC-AMT-CITY-TAX-BG                    
                             ROUNDED                                    
                            = WS-CITY-TAXABLE-AMT                       
                             * WS-TAX-RATE (TC-INDX 2)                  
                       MOVE WS-TAX-RATE (TC-INDX 2)                     
                         TO WS-CITY-TAX-RATE-CALC                       
                    END-IF                                              
                 WHEN OTHER                                             
                    PERFORM 5430-PRORATE-TAXES THRU 5430-EXIT           
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-CITY-TAX-RATE-CALC                          
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                 30010000
       5395-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30040000
      ****************************************************************  30050000
      * 5410-PRORATE-OTH-TAXES                                       *  30070000
      ****************************************************************  30080000
       5410-PRORATE-OTH-TAXES.                                          
      *                                                                 30091000
           PERFORM 7820-GET-DAYS-AT-CURRENT  THRU 7820-EXIT             
                                                                        
           IF WS-BC-NO-CNSMPTN-DAYS NOT EQUAL ZERO                      
              COMPUTE WS-AMT-OTHER-TAX ROUNDED =                        
                  ( WS-OTHER-TAXABLE-AMT    *                           
                    WS-TAX-RATE (TC-INDX 1) *                           
                  ( WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))        
                + ( WS-OTHER-TAXABLE-AMT    *                           
                    WS-TAX-RATE (TC-INDX 2) *                           
                  ( 1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS)))  
           END-IF.                                                      
      *                                                                 30211000
       5410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30241000
      ****************************************************************  30260000
      * 5420-APPLY-TAX                                               *  30280000
      ****************************************************************  30290000
       5420-APPLY-TAX.                                                  
      *                                                                 30301000
           IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
              MOVE ZERO                      TO WS-V1-REV-MTH           
                                                WS-V2-REV-MTH           
              IF BG-REV-MTH-ORIG-BILL > 0                               
                 MOVE BG-REV-MTH-ORIG-BILL   TO WS-REV-MONTH-TEST       
              ELSE                                                      
                 MOVE WS-BC-REVENUE-MONTH-BG TO WS-REV-MONTH-TEST       
              END-IF                                                    
                                                                        
              MOVE WS-TR-DATE-FROM (TC-INDX 1) TO WS-START-DATE         
              MOVE WS-START-DATE (6:2)       TO WS-V2-REV-MTH (5:2)     
              MOVE WS-START-DATE (1:4)       TO WS-V2-REV-MTH (1:4)     
                                                                        
              IF WS-TR-DATE-FROM (TC-INDX 2) NOT = HIGH-VALUES          
                 MOVE WS-TR-DATE-FROM (TC-INDX 2) TO WS-START-DATE      
                 MOVE WS-START-DATE (6:2) TO WS-V1-REV-MTH (5:2)        
                 MOVE WS-START-DATE (1:4) TO WS-V1-REV-MTH (1:4)        
              END-IF                                                    
                                                                        
              IF WS-REV-MONTH-TEST >= WS-V2-REV-MTH                     
                  COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED                
                    = WS-STATE-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 1)    
                  MOVE WS-TAX-RATE (TC-INDX 1)                          
                     TO WS-STATE-TAX-RATE-CALC                          
              ELSE                                                      
                 IF WS-V1-REV-MTH > 0                                   
                  AND WS-REV-MONTH-TEST >= WS-V1-REV-MTH                
                      COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED            
                       = WS-STATE-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 2) 
                      MOVE WS-TAX-RATE (TC-INDX 2)                      
                        TO WS-STATE-TAX-RATE-CALC                       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              EVALUATE TRUE                                             
                 WHEN WS-BC-CNSMPTN-START-DATE                          
                     >= WS-TR-DATE-FROM (TC-INDX 1)                     
                    COMPUTE WS-BC-AMT-STATE-TAX-BG                      
                             ROUNDED                                    
                        = WS-STATE-TAXABLE-AMT                          
                            * WS-TAX-RATE (TC-INDX 1)                   
                    MOVE WS-TAX-RATE (TC-INDX 1)                        
                      TO WS-STATE-TAX-RATE-CALC                         
                 WHEN WS-BC-CNSMPTN-END-DATE                            
                     <= WS-TR-DATE-TO (TC-INDX 2)                       
                    COMPUTE WS-BC-AMT-STATE-TAX-BG                      
                             ROUNDED                                    
                          = WS-STATE-TAXABLE-AMT                        
                             * WS-TAX-RATE (TC-INDX 2)                  
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-STATE-TAX-RATE-CALC                         
                 WHEN WS-TU-CALC-INST (TC-INDX) = 'B'                   
                    IF WS-BC-CNSMPTN-END-DATE                           
                         >= WS-TR-DATE-FROM (TC-INDX 1)                 
                       COMPUTE WS-BC-AMT-STATE-TAX-BG                   
                             ROUNDED                                    
                           = WS-STATE-TAXABLE-AMT                       
                             * WS-TAX-RATE (TC-INDX 1)                  
                       MOVE WS-TAX-RATE (TC-INDX 1)                     
                         TO WS-STATE-TAX-RATE-CALC                      
                    ELSE                                                
                       COMPUTE WS-BC-AMT-STATE-TAX-BG                   
                             ROUNDED                                    
                            = WS-STATE-TAXABLE-AMT                      
                             * WS-TAX-RATE (TC-INDX 2)                  
                       MOVE WS-TAX-RATE (TC-INDX 2)                     
                                           TO WS-STATE-TAX-RATE-CALC    
                    END-IF                                              
                 WHEN OTHER                                             
                    PERFORM 5450-PRORATE-TAXES THRU 5450-EXIT           
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                                          TO WS-STATE-TAX-RATE-CALC     
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                 31131000
       5420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31161000
      ****************************************************************  31180000
      * 5430-PRORATE-TAXES                                           *  31200000
      ****************************************************************  31210000
       5430-PRORATE-TAXES.                                              
      *                                                                 31221000
           PERFORM 7820-GET-DAYS-AT-CURRENT  THRU 7820-EXIT             
                                                                        
           IF WS-BC-NO-CNSMPTN-DAYS NOT EQUAL ZERO                      
              COMPUTE WS-BC-AMT-CITY-TAX-BG ROUNDED =                   
                 ( WS-CITY-TAXABLE-AMT       *                          
                   WS-TAX-RATE (TC-INDX 1)   *                          
                 ( WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))         
                +( WS-CITY-TAXABLE-AMT       *                          
                   WS-TAX-RATE (TC-INDX 2) *                            
                 ( 1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS)))   
           END-IF.                                                      
      *                                                                 31341000
       5430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31371000
      ****************************************************************  31900000
      * 5450-PRORATE-TAXES                                           *  31920000
      ****************************************************************  31930000
       5450-PRORATE-TAXES.                                              
      *                                                                 31941000
           PERFORM 7820-GET-DAYS-AT-CURRENT  THRU 7820-EXIT             
           IF WS-BC-NO-CNSMPTN-DAYS NOT EQUAL ZERO                      
              COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED =                  
                ( WS-STATE-TAXABLE-AMT         *                        
                  WS-TAX-RATE (TC-INDX 1)      *                        
                ( WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))          
               +( WS-STATE-TAXABLE-AMT         *                        
                  WS-TAX-RATE (TC-INDX 2)      *                        
                ( 1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS)))    
           END-IF.                                                      
      *                                                                 32051000
       5450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 32940000
      ***************************************************************** 32950000
      * 5900-CALL-BILL-CALC.                                          * 32970000
      ***************************************************************** 32980000
       5900-CALL-BILL-CALC.                                             
      *                                                                 32991000
           MOVE 'S' TO WS-BC-CALC-MODE.                                 
           CALL MCSCB107 USING   LS-PCSCA100-COMM-AREA                  
                                ,WS-BILLING-CALC-WORK                   
                                ,WS-BILLING-COMPONENT                   
                                ,WS-BILLING-ADJUSTMENT                  
                                ,WS-BILL-CALC-BG                        
                                ,WS-BILL-CALC-CX                        
                                ,WS-BILL-CALC-UC                        
                                ,WS-BILL-CALC-FH                        
                                ,WS-BILL-CONTRACT-BK                    
                                ,WS-FIXED-FCTR-TABLE-FF                 
                                ,WS-BILL-CNTR-HIST-BX                   
                                ,WS-PEAK-HIST-PH                        
                                ,WS-INTERRUPT-ACCT-IP                   
                                ,WS-MTRD-ENVRNMT-TABLE-MN               
                                ,WS-STANDBY-GEN-SE                      
                                ,WS-INTERRUPT-IR                        
                                ,WS-HOLD-CX-DATA                        
                                ,WS-HOLD-BC-DATA                        
                                ,WS-HOLD-BA-DATA                        
                                ,WS-BILLING-WQ-ITEMS-WF                 
                                ,WS-REFUND-RN                           
                                ,WS-ACCOUNT-AT                          
                                ,WS-BC-BILL-ADJUSTMNT                   
                                ,WS-BC-ACCT-RTPK-AGR-DF                 
                                ,WS-BC-FIXED-FCTR-FF                    
                                ,WS-BC-BILL-DET-BT                      
                                ,WS-CWS22B-MAX-TBL-LIMITS               
                                ,WS-BILL-CALC-DETAIL-X                  
                                ,WS-BC-VOL-DAILY-ND                     
                                ,WS-BILL-BSLN-CNTR-LN                   
                                ,WS-BILL-BSLN-HIST-LO                   
                                ,WS-UTL-BILL-REL-TABLE-UR               
                                ,WS-INTERRUPT-NZ                        
                                ,WS-CNSMPTN-HOURLY.                     
      *                                                                 33460000
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33490000
      ******************************************************************33500000
      *  7000-GET-ACCOUNT-DETAILS                                      *33520000
      ******************************************************************33530000
       7000-GET-ACCOUNT-DETAILS.                                        
      *                                                                 33541000
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.PREMISE_NO                                      
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:WS-CURRENT-DATE                                   
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     33560000
MFA-TR*       SELECT AT.COMPANY_NO                                      33570000
MFA-TR*             ,AT.LOCAL_OFFICE                                    33580000
MFA-TR*             ,AT.PREMISE_NO                                      33590000
MFA-TR*             ,CURRENT DATE                                       33600000
MFA-TR*         INTO :AT-COMPANY-NO                                     33610000
MFA-TR*             ,:AT-LOCAL-OFFICE                                   33620000
MFA-TR*             ,:AT-PREMISE-NO                                     33630000
MFA-TR*             ,:WS-CURRENT-DATE                                   33640000
MFA-TR*         FROM CSS_ACCOUNT AT                                     33650000
MFA-TR*       WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     33660000
MFA-TR*       WITH UR                                                   33661000
MFA-TR*       QUERYNO 7000                                              33662000
MFA-TR*    END-EXEC.                                                    33670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33680000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 33700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-COMPANY-NO             TO C8-COMPANY-NO           
              MOVE AT-PREMISE-NO             TO BI-PREMISE-NO           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 33850000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33880000
      ******************************************************************33890000
      *  7050-READ-BILL-WINDOW                                         *33910000
      ******************************************************************33920000
       7050-READ-BILL-WINDOW.                                           
      *                                                                 33931000
           EXEC SQL                                                     
            SELECT MAX(BN.REVENUE_MONTH)                                
             INTO  :BN-REVENUE-MONTH :WS-REVENUE-MONTH-NULL              
             FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                      
             WHERE DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() AS DATE)            
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     33950000
MFA-TR*     SELECT MAX(BN.REVENUE_MONTH)                                33960000
MFA-TR*      INTO  :BN-REVENUE-MONTH:WS-REVENUE-MONTH-NULL              33970000
MFA-TR*      FROM CSS_BILL_WINDOW BN                                    33980000
MFA-TR*      WHERE DATE_EXTRACT <= CURRENT DATE                         33990000
MFA-TR*      WITH UR                                                    33991000
MFA-TR*      QUERYNO 7050                                               33992000
MFA-TR*    END-EXEC.                                                    34000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34001000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 34030000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-REVENUE-MONTH-NULL EQUAL -1                         
                MOVE ZEROES                  TO BN-REVENUE-MONTH        
              ELSE                                                      
                MOVE BN-REVENUE-MONTH        TO WS-CURR-REVENUE-MONTH   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'MAX REVNUE MONTH'        TO TABLE-ELEMENT-1         
              MOVE WS-CURR-REVENUE-MONTH     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34210000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34240000
      ***************************************************************** 34250000
      * 7100-CALCULATE-DATE.                                          * 34270000
      ***************************************************************** 34280000
       7100-CALCULATE-DATE.                                             
      *                                                                 34300000
           EXEC SQL                                                     
               SELECT MAX(BG.REVENUE_MONTH)                             
                 INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI              
               FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED)                  
                   ,CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                  
              WHERE BI.PREMISE_NO         = :BI-PREMISE-NO              
                AND BI.PREMISE_NO         = BG.PREMISE_NO               
                AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO               
                AND BG.CODE_BILL_ITM_TYPE = 'C'                         
                AND BG.CODE_BILL_ITM_IND  = 'A'                         
                AND BG.CODE_BILL_CALC     = 'A'                         
A04527          AND BG.CODE_UTIL_TYPE     = 'G'                         
                AND BI.BILL_NO            = BG.BILL_NO                  
                AND BI.DATE_BILLED  BETWEEN                             
                    (DATEADD( MONTH, -2, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) AND             
                    IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     34310000
MFA-TR*        SELECT MAX(BG.REVENUE_MONTH)                             34320000
MFA-TR*          INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI              34330000
MFA-TR*        FROM CSS_BILLING_HDR   BI                                34340000
MFA-TR*            ,CSS_BILLING_DET   BG                                34350000
MFA-TR*       WHERE BI.PREMISE_NO         = :BI-PREMISE-NO              34360000
MFA-TR*         AND BI.PREMISE_NO         = BG.PREMISE_NO               34370000
MFA-TR*         AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO               34380000
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE = 'C'                         34390000
MFA-TR*         AND BG.CODE_BILL_ITM_IND  = 'A'                         34400000
MFA-TR*         AND BG.CODE_BILL_CALC     = 'A'                         34410000
MFA-TR*         AND BG.CODE_UTIL_TYPE     = 'G'                         34420000
MFA-TR*         AND BI.BILL_NO            = BG.BILL_NO                  34430000
MFA-TR*         AND BI.DATE_BILLED  BETWEEN                             34440000
MFA-TR*             (DATE(:WS-CURRENT-DATE) - 2 MONTHS) AND             34450000
MFA-TR*             :WS-CURRENT-DATE                                    34460000
MFA-TR*       WITH UR                                                   34461000
MFA-TR*       QUERYNO 7100                                              34462000
MFA-TR*    END-EXEC.                                                    34470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34480000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 34500000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CSS_BILLING_HDR'           TO TABLE-1               
              MOVE 'PREMISE_NO'                TO TABLE-ELEMENT-1       
              MOVE BI-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34640000
           IF WS-TO-REV-MONTH-NI < 0                                    
              STRING WS-CURRENT-DATE(1:4) WS-CURRENT-DATE(6:2)          
                     DELIMITED BY SIZE INTO WS-TO-REV-MONTH-C           
              MOVE WS-TO-REV-MONTH-C TO WS-TO-REV-MONTH                 
           ELSE                                                         
              MOVE  WS-TO-REV-MONTH TO WS-TO-REV-MONTH-C
           END-IF.               
           MOVE WS-TO-REV-MONTH-C TO  WS-MAX-REV-MONTH.                 
                                                                        
           STRING WS-TO-REV-MONTH-C(1:4) '-'                            
                  WS-TO-REV-MONTH-C(5:2) '-01'                          
                  DELIMITED BY SIZE INTO WS-MAX-REV-DATE.               
                                                                        
           EXEC SQL                                                     
              SELECT CAST(DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                       :WS-MAX-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-REV-DATE
              ) <> 0) OR (LEN(:WS-MAX-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MAX-REV-DATE
              ), CONVERT(DATE, :WS-MAX-REV-DATE) ) ) AS CHAR(10))          
                INTO :WS-MAX-REV-DATE-TMP                               
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     34770000
MFA-TR*       SELECT CHAR(DATE(:WS-MAX-REV-DATE) -  11 MONTHS)          34780000
MFA-TR*         INTO :WS-MAX-REV-DATE-TMP                               34790000
MFA-TR*         FROM CSS_MODEL_SQL                                      34800000
MFA-TR*       WITH UR                                                   34801000
MFA-TR*       QUERYNO 7100                                              34802000
MFA-TR*    END-EXEC.                                                    34810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34820000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 34840000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-MAX-REV-DATE-TMP       TO WS-MAX-REV-DATE         
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
              MOVE 'MAX REVENUE DATE'        TO TABLE-ELEMENT-1         
              MOVE WS-MAX-REV-DATE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34980000
           STRING WS-MAX-REV-DATE(1:4)                                  
                  WS-MAX-REV-DATE(6:2)                                  
                  DELIMITED BY SIZE INTO WS-FROM-REV-MONTH-C.           
           MOVE WS-FROM-REV-MONTH-C TO WS-FROM-REV-MONTH.               
      *                                                                 35030000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35060000
      ***************************************************************** 35070000
      * 7150-LOAD-REV-DISTRICT-CD                                     * 35090000
      ***************************************************************** 35100000
       7150-LOAD-REV-DISTRICT-CD.                                       
      *                                                                 35120000
           MOVE BI-PREMISE-NO                TO PR-PREMISE-NO.          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PR.REV_DISTRICT_CD,
              COALESCE(PR.DDDC_FCTR,0.0)                          
                 INTO :PR-REV-DISTRICT-CD                               
A04987               ,:PR-DDDC-FCTR                                     
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                      
               WHERE PR.PREMISE_NO = :PR-PREMISE-NO                     
                                                    
A04527                                                           
A04527                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     35150000
MFA-TR*        SELECT PR.REV_DISTRICT_CD                                35160000
MFA-TR*              ,IFNULL(PR.DDDC_FCTR,0.0)                          35161003
MFA-TR*          INTO :PR-REV-DISTRICT-CD                               35170000
MFA-TR*              ,:PR-DDDC-FCTR                                     35171002
MFA-TR*          FROM CSS_PREMISE PR                                    35180000
MFA-TR*        WHERE PR.PREMISE_NO = :PR-PREMISE-NO                     35190000
MFA-TR*        FETCH FIRST ROW ONLY                                     35200000
MFA-TR*        WITH UR                                                  35201000
MFA-TR*        QUERYNO 7150                                             35202000
MFA-TR*    END-EXEC                                                     35210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE PR-REV-DISTRICT-CD        TO ZT-REV-DISTRICT-CD      
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PREMISE'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 35420000
      * 7155-LOAD-REV-DIST-FROM-ZIP                                   * 35440000
      ***************************************************************** 35450000
       7155-LOAD-REV-DIST-FROM-ZIP.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REV_DISTRICT_CD,
              LOCAL_OFFICE                                      
                 INTO :ZT-REV-DISTRICT-CD,                              
                      :ZT-LOCAL-OFFICE                                  
                 FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                   
               WHERE ZIP_CODE = :IN-ZIP-CODE                            
                 AND REV_DISTRICT_CD <>  '800'                          
                                                    
A04527                                                           
A04527                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35480000
MFA-TR*        SELECT REV_DISTRICT_CD,                                  35490000
MFA-TR*               LOCAL_OFFICE                                      35500000
MFA-TR*          INTO :ZT-REV-DISTRICT-CD,                              35510000
MFA-TR*               :ZT-LOCAL-OFFICE                                  35520000
MFA-TR*          FROM CSS_ZIPCODE_LO_RT                                 35530000
MFA-TR*        WHERE ZIP_CODE = :IN-ZIP-CODE                            35540000
MFA-TR*          AND REV_DISTRICT_CD <>  '800'                          35550000
MFA-TR*        FETCH FIRST ROW ONLY                                     35560000
MFA-TR*        WITH UR                                                  35561000
MFA-TR*        QUERYNO 7155                                             35562000
MFA-TR*    END-EXEC                                                     35570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE +200 TO WS-ACTIVE-RETURN-CODE                    
                  MOVE PROGRAM-NAME              TO ABEND-PROGRAM       
                  MOVE '7155'                    TO ACTIVE-PARAGRAPH    
                  MOVE 'SELECT'                  TO ABEND-FUNCTION      
                  MOVE 'CSS_ZIPCODE_LO_RT'       TO TABLE-1             
                  MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-1     
                  MOVE IN-ZIP-CODE               TO HOSTVAR-ELEMENT-1   
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
              ELSE                                                      
                  MOVE PROGRAM-NAME              TO ABEND-PROGRAM       
                  MOVE '7155'                    TO ACTIVE-PARAGRAPH    
                  MOVE 'SELECT'                  TO ABEND-FUNCTION      
                  MOVE 'CSS_ZIPCODE_LO_RT'       TO TABLE-1             
                  MOVE 'ZIP_CODE'                TO TABLE-ELEMENT-1     
                  MOVE IN-ZIP-CODE               TO HOSTVAR-ELEMENT-1   
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7155-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************35910000
      * 7200-OPEN-BI-CURSOR                                            *35930000
      ******************************************************************35940000
       7200-OPEN-BI-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN BI-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR '        TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE BI-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************36200000
      * 7205-FETCH-BI-CURSOR                                           *36210000
      *     FETCH CURSOR TO RETRIEVE ROW                               *36220000
      ******************************************************************36230000
       7205-FETCH-BI-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH BI-CURSOR                                           
               INTO  :BG-REVENUE-MONTH                                  
                   ,:BI-DATE-BILLED :WS-DATE-BILLED-NULL                 
                   ,:BI-CUSTOMER-NO                                     
                   ,:BG-ACCOUNT-NO                                      
                   ,:BG-CODE-UTIL-TYPE                                  
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-BILL-NO                                         
                   ,:BG-IC-NO                                           
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-PREMISE-NO                                      
                   ,:BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL           
                   ,:BG-CODE-BILL-CALC                                  
                   ,:BG-CODE-BILL-ITM-TYPE                              
                   ,:BG-CODE-BILL-ITM-IND                               
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-AMT-STATE-TAX                                   
                   ,:BG-AMT-CITY-TAX                                    
                   ,:BG-AMT-OTHER-TAX                                   
                   ,:BG-CODE-REVENUE-CLASS                              
                   ,:BG-CODE-SIC-NO                                     
                   ,:BG-RATE-PLAN-NO                                    
                   ,:BG-CODE-CURTAIL-PRTY                               
                   ,:BG-CODE-STAT-TAX-XMT                               
                   ,:BG-CODE-CITY-TAX-XMT                               
                   ,:BG-CODE-OTHR-TAX-XMT                               
                   ,:BG-REV-RPT-CD                                      
                   ,:BG-STANDBY-COMPLIED                                
                   ,:BG-PRORATE-CD                                      
                   ,:BG-NEW-RATE-PCT                                    
                   ,:BG-CODE-SUB-TOTAL                                  
                   ,:BG-TAX-REFUND-CD                                   
                   ,:BG-COMPANY-NO                                      
                   ,:BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL       
                   ,:BG-LFTM-HI-PEAK-DMD                                
                   ,:BG-REBILL-IND                                      
                   ,:BG-REV-MTH-ORIG-BILL                               
                   ,:BG-GAS-BASE-USE                                    
                   ,:BG-ADJ-REASON-CD                                   
                   ,:BG-WNA-FACTOR                                      
                   ,:BG-BTU-FACTOR                                      
                   ,:BG-REV-DISTRICT-CD                                 
                   ,:BG-RT-PKG-OPT-SEQ-NO :WS-NULL-IND-1                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 IF WS-NULL-IND-1 < ZERO                                
                     MOVE ZERO TO BG-RT-PKG-OPT-SEQ-NO                  
                 END-IF                                                 
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +000                   TO S-RETURN-CODE           
              ELSE                                                      
                 IF WS-DATE-ORIG-BILL-NULL = -1                         
                    MOVE SPACES              TO BG-DATE-ORIG-BILL       
                 END-IF                                                 
                                                                        
                 IF WS-DATE-BILLED-NULL = -1                            
                    MOVE SPACES              TO BI-DATE-BILLED          
                 END-IF                                                 
                                                                        
                 IF WS-DATE-LFTM-HI-DMD-NULL = -1                       
                    MOVE SPACES              TO BG-DATE-LFTM-HI-DMD     
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7205'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR '        TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE BI-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************37080000
      * 7210-CLOSE-BI-CURSOR                                           *37100000
      ******************************************************************37110000
       7210-CLOSE-BI-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE BI-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'CSS_BILLING_DET '        TO TABLE-2                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE BI-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************37400000
      *  7250-OPEN-CX-CURSOR                                           *37420000
      ******************************************************************37430000
       7250-OPEN-CX-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CX-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************37750000
      *                                                                *37760000
      *   7255-FETCH-CX-CURSOR                                         *37770000
      ******************************************************************37780000
       7255-FETCH-CX-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH CX-CURSOR                                           
               INTO :CX-NO-UNITS                                        
                   ,:CX-NO-DAYS                                         
                   ,:CX-MTR-REF-NO                                      
                   ,:CX-CODE-USAGE-TYPE                                 
                   ,:CX-CODE-USAGE-ID                                   
                   ,:CX-CODE-USAGE-SOURCE                               
                   ,:CX-CODE-TIME-PERIOD                                
                   ,:CX-ITEM-SEQ-NO                                     
                   ,:CX-METER-NO                                        
                   ,:CX-REG-ID-NO                                       
                   ,:CX-DATE-READ :WS-DATE-READ-NULL                     
                   ,:CX-CODE-METER-READ                                 
                   ,:CX-CODE-METER-NO-READ                              
                   ,:CX-METER-READING                                   
                   ,:CX-DEMAND-READING                                  
                   ,:CX-EMPLOYEE-NO                                     
                   ,:CX-NO-DEMAND-UNITS                                 
                   ,:CX-CODE-SOURCE-ID                                  
                   ,:CX-CODE-DEBIT-CREDIT                               
                   ,:CX-CODE-ITEM-STATUS                                
                   ,:CX-CODE-DISCOUNT                                   
                   ,:CX-CONSTANT                                        
                   ,:CX-NO-DIALS                                        
                   ,:CX-COMPANY-NO                                      
                   ,:CX-EXCEPT-OVERRIDE-CD                              
                   ,:CX-REQUESTED-USAGE                                 
                   ,:CX-DIGTL-INTRL-MTR-NO                              
                   ,:CX-DIGTL-MTR-TYPE                                  
                   ,:CX-CODE-TOU-SEASN                                  
                   ,:CX-EXCL-DMD-RCHT-IND                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +000                    TO S-RETURN-CODE           
              ELSE                                                      
                 IF WS-DATE-READ-NULL EQUAL -1                          
                    MOVE SPACES                    TO CX-DATE-READ      
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7255'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7255-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************38460000
      *                                                                *38470000
      * 7260-CLOSE-BI-CURSOR                                           *38480000
      ******************************************************************38490000
       7260-CLOSE-CX-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38770000
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39490000
      ****************************************************************  39990000
      * 7500-GET-DELINQ-VALUE                                        *  40000000
      ****************************************************************  40010000
       7500-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT  C8.DELINQ_VALUE                                  
                 INTO :C8-DELINQ-VALUE                                  
                 FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                 WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    
                   AND C8.COMPANY_NO = :C8-COMPANY-NO                   
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40040000
MFA-TR*        SELECT  C8.DELINQ_VALUE                                  40050000
MFA-TR*          INTO :C8-DELINQ-VALUE                                  40060000
MFA-TR*          FROM  CSS_DELINQUENCY C8                               40070000
MFA-TR*          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    40080000
MFA-TR*            AND C8.COMPANY_NO = :C8-COMPANY-NO                   40090000
MFA-TR*          WITH UR                                                40091000
MFA-TR*          QUERYNO 7500                                           40092000
MFA-TR*    END-EXEC.                                                    40100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD '              TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
BBPFIX******************************************************************40321000
BBPFIX* 7540-GET-PEND-OPTION                                          **40322000
BBPFIX*                                                               **40323000
BBPFIX******************************************************************40324000
BBPFIX 7540-GET-PEND-OPTION.                                            
BBPFIX                                                                  
BBPFIX     EXEC SQL                                                     
BBPFIX         SELECT DF.OPTION_CD                                      
BBPFIX           INTO :DF-OPTION-CD                                     
BBPFIX           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
BBPFIX          WHERE DF.ACCOUNT_NO     = :UT-ACCOUNT-NO                
BBPFIX            AND DF.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
BBPFIX            AND DF.IC_NO          = :UT-IC-NO                     
BBPFIX            AND DF.STATUS_CD      = 'P'                           
BBPFIX                                                           
BBPFIX                                                      
BBPFIX     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40327000
MFA-TR*        SELECT DF.OPTION_CD                                      40328000
MFA-TR*          INTO :DF-OPTION-CD                                     40329000
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              40329100
MFA-TR*         WHERE DF.ACCOUNT_NO     = :UT-ACCOUNT-NO                40329200
MFA-TR*           AND DF.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            40329300
MFA-TR*           AND DF.IC_NO          = :UT-IC-NO                     40329400
MFA-TR*           AND DF.STATUS_CD      = 'P'                           40329500
MFA-TR*        WITH UR                                                  40329600
MFA-TR*        QUERYNO 7540                                             40329700
MFA-TR*    END-EXEC.                                                    40329800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BBPFIX                                                                  
BBPFIX     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
BBPFIX                                                                  
BBPFIX     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
BBPFIX        CONTINUE                                                  
BBPFIX     ELSE                                                         
BBPFIX        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
BBPFIX        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
BBPFIX        MOVE '7540'                   TO ACTIVE-PARAGRAPH         
BBPFIX        MOVE 'SELECT'                 TO ABEND-FUNCTION           
BBPFIX        MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
BBPFIX        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
BBPFIX        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
BBPFIX        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
BBPFIX        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
BBPFIX        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
BBPFIX        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
BBPFIX        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
BBPFIX        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
BBPFIX     END-IF.                                                      
BBPFIX                                                                  
BBPFIX 7540-EXIT.                                                       
BBPFIX     EXIT.                                                        
                                                                        
BBPFIX******************************************************************40332300
BBPFIX* 7550-GET-OPT-CALC-TYPE-CD                                     **40332400
BBPFIX*                                                               **40332500
BBPFIX******************************************************************40332600
BBPFIX 7550-GET-OPT-CALC-TYPE-CD.                                       
BBPFIX                                                                  
BBPFIX     EXEC SQL                                                     
BBPFIX         SELECT TOP(1) OPT_CALC_TYPE_CD                                  
BBPFIX           INTO :WS-RATE-CALC-TYPE-CD                             
BBPFIX            FROM CRM_RT_PKG_OPTION WITH(READUNCOMMITTED)                  
BBPFIX           WHERE OPTION_CD = :DF-OPTION-CD                        
BBPFIX             AND COMPANY_NO = '01'                                
BBPFIX             AND PROC_STATUS_CD  = 'AC'                           
BBPFIX         ORDER BY OPT_VEND_TS DESC                                
BBPFIX                                              
BBPFIX                                                           
BBPFIX                                                      
BBPFIX     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40332900
MFA-TR*        SELECT OPT_CALC_TYPE_CD                                  40333000
MFA-TR*          INTO :WS-RATE-CALC-TYPE-CD                             40333100
MFA-TR*           FROM CRM_RT_PKG_OPTION                                40333200
MFA-TR*          WHERE OPTION_CD = :DF-OPTION-CD                        40333300
MFA-TR*            AND COMPANY_NO = '01'                                40333400
MFA-TR*            AND PROC_STATUS_CD  = 'AC'                           40333500
MFA-TR*        ORDER BY OPT_VEND_TS DESC                                40333600
MFA-TR*        FETCH FIRST ROW ONLY                                     40333700
MFA-TR*        WITH UR                                                  40333800
MFA-TR*        QUERYNO 7550                                             40333900
MFA-TR*    END-EXEC.                                                    40334000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BBPFIX                                                                  
BBPFIX     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
BBPFIX                                                                  
BBPFIX     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
BBPFIX        CONTINUE                                                  
BBPFIX     ELSE                                                         
BBPFIX        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
BBPFIX        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
BBPFIX        MOVE '7550'                   TO ACTIVE-PARAGRAPH         
BBPFIX        MOVE 'SELECT'                 TO ABEND-FUNCTION           
BBPFIX        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
BBPFIX                                         ABEND-TABLES             
BBPFIX        MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
BBPFIX        MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
BBPFIX        MOVE DF-OPTION-CD             TO HOSTVAR-ELEMENT-1        
BBPFIX        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
BBPFIX        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
BBPFIX     END-IF.                                                      
BBPFIX*                                                                 40335900
BBPFIX 7550-EXIT.                                                       
BBPFIX     EXIT.                                                        
                                                                        
BBPFIX******************************************************************40336300
BBPFIX* 7560-GET-OPTION                                               **40336400
BBPFIX*                                                               **40336500
BBPFIX******************************************************************40336600
BBPFIX 7560-GET-OPTION.                                                 
BBPFIX                                                                  
BBPFIX     EXEC SQL                                                     
BBPFIX         SELECT DF.OPTION_CD                                      
BBPFIX           INTO :DF-OPTION-CD                                     
BBPFIX           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
BBPFIX               ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
BBPFIX         WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
BBPFIX           AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
BBPFIX           AND UT.IC_NO             = :UT-IC-NO                   
BBPFIX           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               
BBPFIX           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           
BBPFIX           AND UT.IC_NO             = DF.IC_NO                    
BBPFIX           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        
BBPFIX                                                           
BBPFIX                                                      
BBPFIX     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40336900
MFA-TR*        SELECT DF.OPTION_CD                                      40337000
MFA-TR*          INTO :DF-OPTION-CD                                     40337100
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              40337200
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                              40337300
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              40337400
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          40337500
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                   40337600
MFA-TR*          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               40337700
MFA-TR*          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           40337800
MFA-TR*          AND UT.IC_NO             = DF.IC_NO                    40337900
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        40338000
MFA-TR*        WITH UR                                                  40338100
MFA-TR*        QUERYNO 7560                                             40338200
MFA-TR*    END-EXEC.                                                    40338300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

BBPFIX                                                                  
BBPFIX     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
BBPFIX                                                                  
BBPFIX     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
BBPFIX        CONTINUE                                                  
BBPFIX     ELSE                                                         
BBPFIX        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
BBPFIX        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
BBPFIX        MOVE '7560'                   TO ACTIVE-PARAGRAPH         
BBPFIX        MOVE 'SELECT'                 TO ABEND-FUNCTION           
BBPFIX        MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
BBPFIX        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
BBPFIX        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
BBPFIX        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
BBPFIX        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
BBPFIX        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
BBPFIX        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
BBPFIX        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
BBPFIX        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
BBPFIX     END-IF.                                                      
BBPFIX                                                                  
BBPFIX 7560-EXIT.                                                       
BBPFIX     EXIT.                                                        
                                                                        
ACT250******************************************************************40340800
ACT250*        7570-SELECT-READ-FREQ                                    40340900
ACT250* ****************************************************************40341000
ACT250 7570-SELECT-READ-FREQ.                                           
ACT250      EXEC SQL                                                    
ACT250         SELECT CODE_MTR_READ_FREQ                                
ACT250              , RT_PKG_OPT_SEQ_NO                                 
ACT250           INTO :UT-CODE-MTR-READ-FREQ                            
ACT250              , :UT-RT-PKG-OPT-SEQ-NO                             
ACT250           FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
ACT250          WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
ACT250            AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
ACT250            AND IC_NO          = :UT-IC-NO                        
ACT250                                                           
ACT250      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    40341200
MFA-TR*        SELECT CODE_MTR_READ_FREQ                                40341300
MFA-TR*             , RT_PKG_OPT_SEQ_NO                                 40341400
MFA-TR*          INTO :UT-CODE-MTR-READ-FREQ                            40341500
MFA-TR*             , :UT-RT-PKG-OPT-SEQ-NO                             40341600
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  40341700
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   40341800
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               40341900
MFA-TR*           AND IC_NO          = :UT-IC-NO                        40342000
MFA-TR*        WITH UR                                                  40342100
MFA-TR*     END-EXEC.                                                   40342200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT250                                                                  
ACT250     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT250                                                                  
ACT250     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
ACT250        NEXT SENTENCE                                             
ACT250     ELSE                                                         
ACT250        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
ACT250        MOVE '7570'                     TO ACTIVE-PARAGRAPH       
ACT250        MOVE 'SELECT'                   TO ABEND-FUNCTION         
ACT250        MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
ACT250        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
ACT250        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
ACT250        MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
ACT250        MOVE  UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
ACT250        MOVE  UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2      
ACT250        MOVE  UT-IC-NO                  TO HOSTVAR-ELEMENT-3      
ACT250        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
ACT250        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT250     END-IF.                                                      
ACT250 7570-EXIT.                                                       
ACT250     EXIT.                                                        
ACT250                                                                  
      ******************************************************************40344600
      *                                                                *40345000
      * 7600-OPEN-TAX-DATA                                             *40350000
      ******************************************************************40360000
       7600-OPEN-TAX-DATA.                                              
                                                                        
           EXEC SQL                                                     
              OPEN TAX-DATA                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_CNTL'            TO TABLE-1                 
              MOVE 'CSS_TAX_RATE'            TO TABLE-2                 
              MOVE 'CSS_TAX_USE_CNTL'        TO TABLE-3                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************40620000
      *                                                                *40630000
      * 7605-FETCH-TAX-DATA                                            *40640000
      ******************************************************************40650000
       7605-FETCH-TAX-DATA.                                             
                                                                        
           EXEC SQL                                                     
              FETCH TAX-DATA                                            
                INTO :TC-TAX-TYPE                                       
                    ,:TR-DETAIL-ID                                      
                    ,:TR-DATE-FROM                                      
                    ,:TR-DATE-TO :WS-NULL-IND                            
                    ,:TR-TAX-RATE                                       
                    ,:TU-CODE-TAX-CALC-INST                             
                    ,:TU-TAX-ELEC                                       
                    ,:TU-TAX-GAS                                        
                    ,:TU-TAX-MDSE                                       
                    ,:TU-TAX-WATER                                      
                    ,:TU-TAX-SEWER                                      
                    ,:TU-TAX-TRASH                                      
                    ,:TC-TAX-CNTRL-NO                                   
                    ,:TC-FACTOR-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND EQUAL -1                                   
                MOVE SPACES                  TO TR-DATE-TO              
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +000                    TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7605'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_CNTL'            TO TABLE-1                 
              MOVE 'CSS_TAX_RATE'            TO TABLE-2                 
              MOVE 'CSS_TAX_USE_CNTL'        TO TABLE-3                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7605-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************41100000
      *                                                                *41110000
      * 7610-CLOSE-TAX-DATA                                            *41120000
      ******************************************************************41130000
       7610-CLOSE-TAX-DATA.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE TAX-DATA                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7610'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_CNTL'            TO TABLE-1                 
              MOVE 'CSS_TAX_RATE'            TO TABLE-2                 
              MOVE 'CSS_TAX_USE_CNTL'        TO TABLE-3                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************41380000
      *                                                                *41390000
      * 7650-OPEN-EX-DATA                                              *41400000
      ******************************************************************41410000
       7650-OPEN-EX-DATA.                                               
                                                                        
           EXEC SQL                                                     
              OPEN TAX-EXCISE-DATA                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7650'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_TAX_EXCISE_AMT'       TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************41650000
      *                                                                *41660000
      * 7655-FETCH-EX-DATA                                             *41670000
      ******************************************************************41680000
       7655-FETCH-EX-DATA.                                              
                                                                        
           EXEC SQL                                                     
              FETCH TAX-EXCISE-DATA                                     
                INTO :X6-BLOCK-NO                                       
                    ,:X6-BLOCK-UNITS                                    
                    ,:X6-DATE-FROM                                      
                    ,:X6-TAX-CNTRL-NO                                   
                    ,:X6-EXCISE-TAX-UNIT-AM                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE +000                    TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7655'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7655-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************41990000
      *                                                                *42000000
      * 7660-CLOSE-EX-DATA                                             *42010000
      ******************************************************************42020000
       7660-CLOSE-EX-DATA.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE TAX-EXCISE-DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7660'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42260000
      *                                                                *42270000
      * 7670-OPEN-SCULP-RATE-CSR                                       *42280000
      ******************************************************************42290000
       7670-OPEN-SCULP-RATE-CSR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN SCULP-RATE-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7670'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_DELIQUENCY'           TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************42520000
      *                                                                *42530000
      * 7675-FETCH-SCULP-RATE-CSR                                      *42540000
      ******************************************************************42550000
       7675-FETCH-SCULP-RATE-CSR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH SCULP-RATE-CSR                                      
                INTO :C8-DELINQ-CD                                      
                    ,:C8-DELINQ-VALUE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE WS-HOLD-MONTH TO WS-DDDC-SCULP-MTH (WS-SC-INDX)     
               MOVE C8-DELINQ-VALUE                                     
                                  TO WS-DDDC-SCULP-VALUE (WS-SC-INDX)   
               SUBTRACT +1 FROM WS-HOLD-MONTH                           
               SET WS-SC-INDX UP BY 1                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                 MOVE +000                    TO S-RETURN-CODE          
               ELSE                                                     
                  MOVE PROGRAM-NAME              TO ABEND-PROGRAM       
                  MOVE '7675'                    TO ACTIVE-PARAGRAPH    
                  MOVE 'FETCH'                   TO ABEND-FUNCTION      
                  MOVE 'CSS_DELINQUENCY'         TO TABLE-1             
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7675-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42890000
      *                                                                *42900000
      * 7680-CLOSE-SCULP-RATE-CSR                                      *42910000
      ******************************************************************42920000
       7680-CLOSE-SCULP-RATE-CSR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE SCULP-RATE-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7680'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************46660000
      *                                                                *46670000
      * 7800-GET-FRAN-TX-XMPTN                                         *46680000
      ******************************************************************46690000
       7800-GET-FRAN-TX-XMPTN.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-FT-XMPT                                        
                FROM CSS_FRNCHS_TX_XMPT F2 WITH(READUNCOMMITTED)                
                WHERE F2.REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD       
                  AND F2.CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS    
                  AND F2.CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE        
                  AND F2.COMPANY_NO         = :F2-COMPANY-NO            
                                                    
A04527                                                           
A04527                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46720000
MFA-TR*       SELECT 'Y'                                                46730000
MFA-TR*         INTO :WS-FT-XMPT                                        46740000
MFA-TR*         FROM CSS_FRNCHS_TX_XMPT F2                              46750000
MFA-TR*         WHERE F2.REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD       46760000
MFA-TR*           AND F2.CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS    46770000
MFA-TR*           AND F2.CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE        46780000
MFA-TR*           AND F2.COMPANY_NO         = :F2-COMPANY-NO            46790000
MFA-TR*       FETCH FIRST ROW ONLY                                      46800000
MFA-TR*       WITH UR                                                   46801000
MFA-TR*       QUERYNO 7800                                              46802000
MFA-TR*    END-EXEC                                                     46810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE 'N'                     TO WS-FT-XMPT              
                MOVE +000                    TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT      '            TO ABEND-FUNCTION          
              MOVE 'CSS_FRNCHS_TX_XMPT'      TO TABLE-1                 
              MOVE 'REV_DISTRICT_CD'         TO TABLE-ELEMENT-1         
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE F2-REV-DISTRICT-CD        TO HOSTVAR-ELEMENT-1       
              MOVE F2-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-2       
              MOVE F2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE F2-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************47110000
      *                                                                *47120000
      * 7810-GET-STATE-TX-XMPTN                                        *47130000
      ******************************************************************47140000
       7810-GET-STATE-TX-XMPTN.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ST-XMPT                                        
                FROM CSS_REVENUE_CLASS F3 WITH(READUNCOMMITTED)                 
               WHERE F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS     
                 AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE         
                 AND F3.COMPANY_NO         = :F3-COMPANY-NO             
                 AND F3.ST_TAX_XMPT_IND    = 'Y'                        
                                                    
A04527                                                           
A04527                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     47170000
MFA-TR*       SELECT 'Y'                                                47180000
MFA-TR*         INTO :WS-ST-XMPT                                        47190000
MFA-TR*         FROM CSS_REVENUE_CLASS F3                               47200000
MFA-TR*        WHERE F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS     47210000
MFA-TR*          AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE         47220000
MFA-TR*          AND F3.COMPANY_NO         = :F3-COMPANY-NO             47230000
MFA-TR*          AND F3.ST_TAX_XMPT_IND    = 'Y'                        47240000
MFA-TR*       FETCH FIRST ROW ONLY                                      47250000
MFA-TR*       WITH UR                                                   47251000
MFA-TR*       QUERYNO 7810                                              47252000
MFA-TR*    END-EXEC                                                     47260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE 'N'                     TO WS-ST-XMPT              
                MOVE +000                    TO S-RETURN-CODE           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7810'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT      '            TO ABEND-FUNCTION          
              MOVE 'CSS_REVENUE_CLASS'       TO TABLE-1                 
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE F3-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-1       
              MOVE F3-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE F3-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 47500000
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 47530000
      ******************************************************************47540000
      * 7820-GET-DAYS-AT-CURRENT                                       *47560000
      ******************************************************************47570000
       7820-GET-DAYS-AT-CURRENT.                                        
      *                                                                 47590000
           MOVE WS-TR-DATE-FROM (TC-INDX 1)  TO WS-DATE-1               
           MOVE WS-BC-CNSMPTN-END-DATE       TO WS-DATE-2               
                                                                        
           EXEC SQL                                                     
              SELECT CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) ))                             
                        - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-1) <> 0) OR (LEN(
                                                             :WS-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-1), CONVERT(DATE, 
                                                             :WS-DATE-1
              ) ))                        
                 INTO :WS-DAYS-AT-CURRENT                               
                 FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     47630000
MFA-TR*       SELECT DAYS(DATE(:WS-DATE-2))                             47640000
MFA-TR*                 - DAYS(DATE(:WS-DATE-1))                        47650000
MFA-TR*          INTO :WS-DAYS-AT-CURRENT                               47660000
MFA-TR*          FROM CSS_MODEL_SQL                                     47670000
MFA-TR*       WITH UR                                                   47671000
MFA-TR*       QUERYNO 7820                                              47672000
MFA-TR*    END-EXEC.                                                    47680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7820'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT      '            TO ABEND-FUNCTION          
              MOVE 'CSS_MODEL_SQL '          TO TABLE-1                 
              MOVE 'WS-DATE-1'               TO TABLE-ELEMENT-1         
              MOVE WS-DATE-1                 TO HOSTVAR-ELEMENT-1       
              MOVE 'WS-DATE-2'               TO TABLE-ELEMENT-2         
              MOVE WS-DATE-2                 TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 47861000
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49100000
      ******************************************************************49110000
      *                                                                *49120000
      * 7845-GET-CURRENT-DATE.                                         *49130000
      ******************************************************************49140000
       7845-GET-CURRENT-DATE.                                           
      *                                                                 49151000
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     49170000
MFA-TR*       SELECT CURRENT DATE                                       49180000
MFA-TR*         INTO :WS-CURRENT-DATE                                   49190000
MFA-TR*         FROM CSS_MODEL_SQL                                      49200000
MFA-TR*       WITH UR                                                   49201000
MFA-TR*       QUERYNO 7845                                              49202000
MFA-TR*    END-EXEC.                                                    49210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE '7845'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
              MOVE 'CURRENT DATE'            TO TABLE-ELEMENT-1         
              MOVE WS-CURRENT-DATE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7845-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49410000
      ******************************************************************49420000
      *                                                                *49430000
      * 7850-SELECT-TAX-RATE-EST                                       *49440000
      ******************************************************************49450000
       7850-SELECT-TAX-RATE-EST.                                        
      *                                                                 49461000
           EXEC SQL                                                     
              SELECT TR.TAX_RATE                                        
                INTO :TR-TAX-RATE                                       
                FROM CSS_TAX_RATE TR WITH(READUNCOMMITTED)                      
              WHERE  TR.DETAIL_ID  = :TR-DETAIL-ID                      
              AND    TR.TAX_CNTRL_NO = 10                               
              AND    TR.OPER_MODE  = 'A'                                
              AND    TR.DATE_FROM <= CAST(SYSDATETIMEOFFSET() AS DATE)          
              AND    TR.DATE_TO   >= CAST(SYSDATETIMEOFFSET() AS DATE)          
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     49470000
MFA-TR*       SELECT TR.TAX_RATE                                        49480000
MFA-TR*         INTO :TR-TAX-RATE                                       49490000
MFA-TR*         FROM CSS_TAX_RATE TR                                    49500000
MFA-TR*       WHERE  TR.DETAIL_ID  = :TR-DETAIL-ID                      49510000
MFA-TR*       AND    TR.TAX_CNTRL_NO = 10                               49520000
MFA-TR*       AND    TR.OPER_MODE  = 'A'                                49530000
MFA-TR*       AND    TR.DATE_FROM <= CURRENT DATE                       49540000
MFA-TR*       AND    TR.DATE_TO   >= CURRENT DATE                       49550000
MFA-TR*       WITH UR                                                   49551000
MFA-TR*       QUERYNO 7850                                              49552000
MFA-TR*    END-EXEC.                                                    49560000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7850'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-2         
              MOVE TR-DETAIL-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 49780000
      ******************************************************************49790000
      *                                                                *49800000
      * 7860-OPEN-PASS-THRU-CHARGES.                                   *49810000
      ******************************************************************49820000
        7860-OPEN-PASS-THRU-CHARGES.                                    
      *                                                                 49840000
           EXEC SQL                                                     
              OPEN PASS-THRU-CHRG                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7860'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'SPCL_GROUP_CD'           TO TABLE-ELEMENT-1         
              MOVE 'AP'                      TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50040000
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50070000
      ******************************************************************50080000
      * 7870-FETCH-PASS-THRU-CHARGES                                   *50090000
      *     FETCH CURSOR TO RETRIEVE ROW                               *50100000
      ******************************************************************50110000
       7870-FETCH-PASS-THRU-CHARGES.                                    
      *                                                                 50130000
           EXEC SQL                                                     
              FETCH PASS-THRU-CHRG                                      
               INTO  :SF-FACTOR-ID,                                     
                     :SF-FACTOR-TYPE,                                   
                     :SF-CHECK-ELEMENT,                                 
                     :SF-ADJUST-ELEMENT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-PTC                              
                 MOVE +000                   TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7870'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'SPCL_GROUP_CD'           TO TABLE-ELEMENT-1         
              MOVE 'AP'                      TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50460000
      * 7880-CLOSE-PASS-THRU-CHARGES                                   *50480000
      ******************************************************************50490000
       7880-CLOSE-PASS-THRU-CHARGES.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE PASS-THRU-CHRG                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7880'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'SPCL_GROUP_CD'           TO TABLE-ELEMENT-1         
              MOVE 'AP'                      TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7880-EXIT.                                                       
           EXIT.                                                        
      *                                                                 51111000
      ******************************************************************51120000
      * 7890-SELECT-FACTOR                                             *51140000
      ******************************************************************51150000
       7890-SELECT-FACTOR.                                              
      *                                                                 51161000
           EXEC SQL                                                     
              SELECT SA.FACTOR                                          
                INTO :SA-FACTOR :WS-NULL-IND-FCTR                       
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND    SA.CODE_STATUS     = 'A'                           
              AND    SA.DATE_FROM       < CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
              AND    SA.DATE_TO         > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     51170000
MFA-TR*       SELECT SA.FACTOR                                          51180000
MFA-TR*         INTO :SA-FACTOR :WS-NULL-IND-FCTR                       51190000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                              51200000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            51210000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              51220000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 51230000
MFA-TR*       AND    SA.CODE_STATUS     = 'A'                           51240000
MFA-TR*       AND    SA.DATE_FROM       < CURRENT DATE                  51250000
MFA-TR*       AND    SA.DATE_TO         > CURRENT DATE                  51260000
MFA-TR*       WITH UR                                                   51261000
MFA-TR*       QUERYNO 7890                                              51262000
MFA-TR*    END-EXEC.                                                    51270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 51280000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 51300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               IF WS-NULL-IND-FCTR < 0                                  
                 MOVE ZEROS                  TO SA-FACTOR               
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7890'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2         
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 51500000
       7890-EXIT.                                                       
           EXIT.                                                        
      *                                                                 51530000
      ******************************************************************51540000
      * 7900-SUM-DDAY-FACTOR                                           *51560000
      ******************************************************************51570000
       7900-SUM-DDAY-FACTOR.                                            
      *                                                                 51581000
           EXEC SQL                                                     
              SELECT SUM(SA.FACTOR)                                     
                INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND SA.DATE_FROM         >=                               
                   SUBSTRING(CAST(CAST(SYSDATETIMEOFFSET() AS DATE)
            AS CHAR(10)), 1, 8) + '01'               
              AND    SA.DATE_TO        <=                               
                  (SUBSTRING(CAST(DATEADD( MONTH, 12, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ) AS CHAR(10)), 1, 8) + 
           '01')  
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     51590000
MFA-TR*       SELECT SUM(SA.FACTOR)                                     51600000
MFA-TR*         INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           51610000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                              51620000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            51630000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              51640000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 51650000
MFA-TR*       AND SA.DATE_FROM         >=                               51660000
MFA-TR*            SUBSTR(CHAR(CURRENT DATE),1,8) || '01'               51670000
MFA-TR*       AND    SA.DATE_TO        <=                               51680000
MFA-TR*           (SUBSTR(CHAR(CURRENT DATE + 12 MONTHS),1,8) || '01')  51690000
MFA-TR*       WITH UR                                                   51691000
MFA-TR*       QUERYNO 7900                                              51692000
MFA-TR*    END-EXEC.                                                    51700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 51710000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 51730000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               IF WS-NULL-IND-FCTR < 0                                  
                 MOVE ZEROS                  TO SA-FACTOR               
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2         
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 51930000
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 51960000
      ******************************************************************51970000
      * 7905-GET-DDAY-FACTOR                                           *51990000
      ******************************************************************52000000
       7905-GET-DDAY-FACTOR.                                            
      *                                                                 52011000
           EXEC SQL                                                     
              SELECT SA.FACTOR,                                         
                     SF.ADJUST_ELEMENT                                  
                INTO :WS-MONTH-DDAY-FACTOR,                             
                     :SF-ADJUST-ELEMENT                                 
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED),               
                     CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND    SF.FACTOR_ID       = :SF-FACTOR-ID                 
              AND    SA.CODE_STATUS     = 'A'                           
              AND    SA.DATE_FROM       = IIF(TRY_CONVERT(DATE, 
                                                     :WS-HOLD-DATE-DDDC
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-DDDC
              ) <> 0) OR (LEN(:WS-HOLD-DATE-DDDC
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-DATE-DDDC
              ), CONVERT(DATE, :WS-HOLD-DATE-DDDC) )            
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52020000
MFA-TR*       SELECT SA.FACTOR,                                         52030000
MFA-TR*              SF.ADJUST_ELEMENT                                  52040000
MFA-TR*         INTO :WS-MONTH-DDAY-FACTOR,                             52050000
MFA-TR*              :SF-ADJUST-ELEMENT                                 52060000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA,                             52070000
MFA-TR*              CSS_SPCL_FCTR      SF                              52080000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            52090000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              52100000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 52110000
MFA-TR*       AND    SF.FACTOR_ID       = :SF-FACTOR-ID                 52120000
MFA-TR*       AND    SA.CODE_STATUS     = 'A'                           52130000
MFA-TR*       AND    SA.DATE_FROM       = :WS-HOLD-DATE-DDDC            52140000
MFA-TR*       WITH UR                                                   52141000
MFA-TR*       QUERYNO 7905                                              52142000
MFA-TR*    END-EXEC.                                                    52150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE WS-HOLD-YEAR TO WS-HOLD-YEAR-DDDC                
                  MOVE WS-HOLD-DATE-DDDC-R TO WS-HOLD-DATE-DDDC         
                  PERFORM 7906-GET-DDAY-FACTOR-1YEAR THRU               
                          7906-EXIT                                     
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7905'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1              
                 MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1      
                 MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2      
                 MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-2    
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 52420000
       7905-EXIT.                                                       
           EXIT.                                                        
      *                                                                 52450000
      ******************************************************************52460000
      * 7906-GET-DDAY-FACTOR                                           *52480000
      ******************************************************************52490000
       7906-GET-DDAY-FACTOR-1YEAR.                                      
      *                                                                 52501000
           EXEC SQL                                                     
              SELECT SA.FACTOR,                                         
                     SF.ADJUST_ELEMENT                                  
                INTO :WS-MONTH-DDAY-FACTOR,                             
                     :SF-ADJUST-ELEMENT                                 
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED),               
                     CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND    SF.FACTOR_ID       = :SF-FACTOR-ID                 
              AND    SA.CODE_STATUS     = 'A'                           
              AND    SA.DATE_FROM       = IIF(TRY_CONVERT(DATE, 
                                                     :WS-HOLD-DATE-DDDC
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-DDDC
              ) <> 0) OR (LEN(:WS-HOLD-DATE-DDDC
              ) <> 10), CIS.CHAR2DATE(:WS-HOLD-DATE-DDDC
              ), CONVERT(DATE, :WS-HOLD-DATE-DDDC) )            
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     52510000
MFA-TR*       SELECT SA.FACTOR,                                         52520000
MFA-TR*              SF.ADJUST_ELEMENT                                  52530000
MFA-TR*         INTO :WS-MONTH-DDAY-FACTOR,                             52540000
MFA-TR*              :SF-ADJUST-ELEMENT                                 52550000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA,                             52560000
MFA-TR*              CSS_SPCL_FCTR      SF                              52570000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            52580000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              52590000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 52600000
MFA-TR*       AND    SF.FACTOR_ID       = :SF-FACTOR-ID                 52610000
MFA-TR*       AND    SA.CODE_STATUS     = 'A'                           52620000
MFA-TR*       AND    SA.DATE_FROM       = :WS-HOLD-DATE-DDDC            52630000
MFA-TR*       WITH UR                                                   52631000
MFA-TR*       QUERYNO 7906                                              52632000
MFA-TR*    END-EXEC.                                                    52640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 52650000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 52670000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7906'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2         
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 52830000
       7906-EXIT.                                                       
           EXIT.                                                        
      *                                                                 52851000
      ******************************************************************52860000
      * 7910-CHECK-LOC-OFF-EXEMPT                                      *52880000
      ******************************************************************52890000
       7910-CHECK-LOC-OFF-EXEMPT.                                       
      *                                                                 52901000
           EXEC SQL                                                     
              SELECT TOP(1) COMPANY_NO,
              LOCAL_OFFICE,
              FACTOR_ID                                          
                INTO :L0-COMPANY-NO                                     
                    ,:L0-LOCAL-OFFICE                                   
                    ,:L0-FACTOR-ID                                      
                FROM CSS_LO_FACTOR_XMPT WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO      = :AT-COMPANY-NO                   
                 AND LOCAL_OFFICE    = :AT-LOCAL-OFFICE                 
                 AND FACTOR_ID       = :SF-FACTOR-ID                    
                 AND CIS.CHAR2DECIMAL(SUBSTRING(CAST(LO_FCT_XMPT_ST_DT
            AS CHAR(10)), 1, 4) + SUBSTRING(CAST(LO_FCT_XMPT_ST_DT
            AS CHAR(10)), 6, 2))  <=       
                                    :WS-CURR-REVENUE-MONTH              
                 AND CIS.CHAR2DECIMAL(SUBSTRING(CAST(LO_FCT_XMPT_END_DT
            AS CHAR(10)), 1, 4) + SUBSTRING(CAST(LO_FCT_XMPT_END_DT
            AS CHAR(10)), 6, 2)) >=       
                                    :WS-CURR-REVENUE-MONTH              
                                                    
                                                                 
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     52910000
MFA-TR*       SELECT COMPANY_NO                                         52920000
MFA-TR*             ,LOCAL_OFFICE                                       52930000
MFA-TR*             ,FACTOR_ID                                          52940000
MFA-TR*         INTO :L0-COMPANY-NO                                     52950000
MFA-TR*             ,:L0-LOCAL-OFFICE                                   52960000
MFA-TR*             ,:L0-FACTOR-ID                                      52970000
MFA-TR*         FROM CSS_LO_FACTOR_XMPT                                 52980000
MFA-TR*        WHERE COMPANY_NO      = :AT-COMPANY-NO                   52990000
MFA-TR*          AND LOCAL_OFFICE    = :AT-LOCAL-OFFICE                 53000000
MFA-TR*          AND FACTOR_ID       = :SF-FACTOR-ID                    53010000
MFA-TR*          AND DEC(SUBSTR(CHAR(LO_FCT_XMPT_ST_DT),1,4)   ||       53020000
MFA-TR*                  SUBSTR(CHAR(LO_FCT_XMPT_ST_DT),6,2))  <=       53030000
MFA-TR*                             :WS-CURR-REVENUE-MONTH              53040000
MFA-TR*          AND DEC(SUBSTR(CHAR(LO_FCT_XMPT_END_DT),1,4)  ||       53050000
MFA-TR*                  SUBSTR(CHAR(LO_FCT_XMPT_END_DT),6,2)) >=       53060000
MFA-TR*                             :WS-CURR-REVENUE-MONTH              53070000
MFA-TR*        FETCH FIRST ROW ONLY                                     53080000
MFA-TR*         WITH UR                                                 53090000
MFA-TR*         QUERYNO 7910                                            53091000
MFA-TR*    END-EXEC.                                                    53100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7910'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_LO_FACTOR_XMPT'      TO TABLE-1                 
              MOVE 'LOCAL_OFFICE'            TO TABLE-ELEMENT-1         
              MOVE AT-LOCAL-OFFICE           TO HOSTVAR-ELEMENT-1       
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2         
              MOVE SF-FACTOR-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 53290000
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                 53320000
      ******************************************************************53330000
      *                                                                *53340000
      * 7920-GLO-LOC-OFFICE-EXEMPT                                     *53350000
      ******************************************************************53360000
       7920-GLO-LOC-OFFICE-EXEMPT.                                      
      *                                                                 53371000
           MOVE ZT-LOCAL-OFFICE TO B1-LOCAL-OFFICE.                     
      *                                                                 53390000
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE_DESC                                  
                INTO :B1-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
              WHERE  COMPANY_NO      = :C8-COMPANY-NO                   
                AND  LOCAL_OFFICE    = :B1-LOCAL-OFFICE                 
A04527                                                           
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     53400000
MFA-TR*       SELECT LOCAL_OFFICE_DESC                                  53410000
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                              53420000
MFA-TR*         FROM CSS_LOCAL_OFFICE                                   53430000
MFA-TR*       WHERE  COMPANY_NO      = :C8-COMPANY-NO                   53440000
MFA-TR*         AND  LOCAL_OFFICE    = :B1-LOCAL-OFFICE                 53450000
MFA-TR*       WITH UR                                                   53451000
MFA-TR*       QUERYNO 7920                                              53452000
MFA-TR*    END-EXEC.                                                    53460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 53470000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                 53490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7920'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_LOCAL_OFFICE'        TO TABLE-1                 
              MOVE 'LOCAL_OFFICE'            TO TABLE-ELEMENT-1         
              MOVE B1-LOCAL-OFFICE           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 53630000
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 54380000
      ******************************************************************54390000
      * 7950-CHK-SR-CITIZEN                                            *54400000
      ******************************************************************54410000
      *                                                                 54420000
       7950-CHK-SR-CITIZEN.                                             
      *                                                                 54440000
           EXEC SQL                                                     
                SELECT                                                  
                       'Y'                                              
                  INTO                                                  
                       :WS-SENIOR-IND                                   
                  FROM                                                  
                       CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
                 WHERE                                                  
                       YP.ACCOUNT_NO         = :YP-ACCOUNT-NO           
                   AND YP.ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'        
                   AND YP.ATTRIBUTE_VALUE_CD = 'YES'                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     54450000
MFA-TR*         SELECT                                                  54460000
MFA-TR*                'Y'                                              54470000
MFA-TR*           INTO                                                  54480000
MFA-TR*                :WS-SENIOR-IND                                   54490000
MFA-TR*           FROM                                                  54500000
MFA-TR*                CSS_ACCT_ATTRIBUTE YP                            54510000
MFA-TR*          WHERE                                                  54520000
MFA-TR*                YP.ACCOUNT_NO         = :YP-ACCOUNT-NO           54530000
MFA-TR*            AND YP.ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'        54540000
MFA-TR*            AND YP.ATTRIBUTE_VALUE_CD = 'YES'                    54550000
MFA-TR*           WITH UR                                               54560000
MFA-TR*        QUERYNO 7950                                             54570000
MFA-TR*    END-EXEC.                                                    54580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 54590000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-SENIOR-IND = SPACE                                  
                 MOVE 'N'                TO WS-SENIOR-IND               
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7950'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 54770000
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                 54800000
      ******************************************************************54810000
      * 7960-SEL-RT-PLAN-NO                                            *54820000
      *                                                                *54830000
      ******************************************************************54840000
      *                                                                 54850000
       7960-SEL-RT-PLAN-NO.                                             
      *                                                                 54870000
           EXEC SQL                                                     
              SELECT                                                    
                     FI.RATE_PLAN_NO                                    
                INTO                                                    
                     :FI-RATE-PLAN-NO                                   
                FROM                                                    
                     CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE                                                    
                     FI.COMPANY_NO       = '01'                         
                 AND FI.OPTION_CD        = :FI-OPTION-CD                
                 AND FI.STATUS_CD        = 'A'                          
                 AND FI.OPTION_START_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                 AND FI.OPTION_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                 AND OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()            
                 AND OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()            
                 AND PROC_STATUS_CD      = 'AC'                         
                                                                 
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     54880000
MFA-TR*       SELECT                                                    54890000
MFA-TR*              FI.RATE_PLAN_NO                                    54900000
MFA-TR*         INTO                                                    54910000
MFA-TR*              :FI-RATE-PLAN-NO                                   54920000
MFA-TR*         FROM                                                    54930000
MFA-TR*              CRM_RT_PKG_OPTION FI                               54940000
MFA-TR*        WHERE                                                    54950000
MFA-TR*              FI.COMPANY_NO       = '01'                         54960000
MFA-TR*          AND FI.OPTION_CD        = :FI-OPTION-CD                54970000
MFA-TR*          AND FI.STATUS_CD        = 'A'                          54980000
MFA-TR*          AND FI.OPTION_START_DT <= CURRENT DATE                 54990000
MFA-TR*          AND FI.OPTION_END_DT   >= CURRENT DATE                 55000000
MFA-TR*          AND OPT_VSTART_TS      <= CURRENT TIMESTAMP            55010000
MFA-TR*          AND OPT_VEND_TS        >= CURRENT TIMESTAMP            55020000
MFA-TR*          AND PROC_STATUS_CD      = 'AC'                         55030000
MFA-TR*       WITH UR                                                   55040000
MFA-TR*       QUERYNO 7960                                              55042000
MFA-TR*    END-EXEC.                                                    55050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 55060000
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
      *                                                                 55080000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7960'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE FI-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 55220000
       7960-EXIT.                                                       
            EXIT.                                                       
      *                                                                 55250000
      ******************************************************************55260000
      * 8000A-DEL-GTT-ROWS.                                            *55270000
      ******************************************************************55280000
      *                                                                 55290000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 55310000
           EXEC SQL                                                     
               DELETE FROM #CSR04600_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     55320000
MFA-TR*        DELETE FROM SESSION.CSR04600_R1                          55330000
MFA-TR*    END-EXEC.                                                    55340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 55350000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 55380000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04353_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 55580000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 55610000
      ******************************************************************55620000
      * 8000B-DEL-GTT-ROWS.                                            *55630000
      ******************************************************************55640000
      *                                                                 55650000
       8000B-DEL-GTT-ROWS.                                              
      *                                                                 55670000
           EXEC SQL                                                     
               DELETE FROM #CSR04600_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     55680000
MFA-TR*        DELETE FROM SESSION.CSR04600_R2                          55690000
MFA-TR*    END-EXEC.                                                    55700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 55710000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 55740000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04353_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 55940000
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 55970000
      ******************************************************************55980000
      * 8010-INSERT-GTT-R1.                                            *55990000
      ******************************************************************56000000
      *                                                                 56010000
       8010-INSERT-GTT-R1.                                              
      *                                                                 56030000
            EXEC SQL                                                    
               INSERT INTO #CSR04600_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,EPP_GAS                                             
                   ,EPP_SUBDIV                                          
                   ,EPP_PRIVATE                                         
                   ,EPP_EST_AMT                                         
                   ,EPP_EST_AMT_RND                                     
                   ,AGL_PASS_CHARGE                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-EPP-GAS-AMT                                      
                   ,:S-EPP-SUBDIV-AMT                                   
                   ,:S-EPP-PRIVATE-AMT                                  
                   ,:S-EPP-EST-AMT                                      
                   ,:S-EPP-EST-AMT-RND                                  
                   ,:S-AGL-PASS-CHARGE                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    56040000
MFA-TR*        INSERT INTO SESSION.CSR04600_R1                          56050000
MFA-TR*           (                                                     56060000
MFA-TR*             RETURN_CODE                                         56070000
MFA-TR*            ,EPP_GAS                                             56080000
MFA-TR*            ,EPP_SUBDIV                                          56090000
MFA-TR*            ,EPP_PRIVATE                                         56100000
MFA-TR*            ,EPP_EST_AMT                                         56110000
MFA-TR*            ,EPP_EST_AMT_RND                                     56120000
MFA-TR*            ,AGL_PASS_CHARGE                                     56130000
MFA-TR*           )                                                     56140000
MFA-TR*        VALUES                                                   56150000
MFA-TR*           (                                                     56160000
MFA-TR*             :S-RETURN-CODE-1                                    56170000
MFA-TR*            ,:S-EPP-GAS-AMT                                      56180000
MFA-TR*            ,:S-EPP-SUBDIV-AMT                                   56190000
MFA-TR*            ,:S-EPP-PRIVATE-AMT                                  56200000
MFA-TR*            ,:S-EPP-EST-AMT                                      56210000
MFA-TR*            ,:S-EPP-EST-AMT-RND                                  56220000
MFA-TR*            ,:S-AGL-PASS-CHARGE                                  56230000
MFA-TR*           )                                                     56240000
MFA-TR*     END-EXEC                                                    56250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 56260000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 56290000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-EST                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04353_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 56450000
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 56480000
      ******************************************************************56490000
      * 8020-INSERT-GTT-R2.                                            *56500000
      ******************************************************************56510000
      *                                                                 56520000
       8020-INSERT-GTT-R2.                                              
      *                                                                 56540000
            EXEC SQL                                                    
               INSERT INTO #CSR04600_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,REVENUE_MONTH                                       
                   ,DAYS                                                
                   ,UNITS                                               
                   ,NEW_CHARGE                                          
                   ,GAS_BUFFER                                          
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-REVENUE-MONTH                                    
                   ,:S-DAYS                                             
                   ,:S-UNITS                                            
                   ,:S-NEW-CHARGE                                       
                   ,:S-GAS-BUFFER                                       
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    56550000
MFA-TR*        INSERT INTO SESSION.CSR04600_R2                          56560000
MFA-TR*           (                                                     56570000
MFA-TR*             RETURN_CODE                                         56580000
MFA-TR*            ,REVENUE_MONTH                                       56590000
MFA-TR*            ,DAYS                                                56600000
MFA-TR*            ,UNITS                                               56610000
MFA-TR*            ,NEW_CHARGE                                          56620000
MFA-TR*            ,GAS_BUFFER                                          56621000
MFA-TR*           )                                                     56630000
MFA-TR*        VALUES                                                   56640000
MFA-TR*           (                                                     56650000
MFA-TR*             :S-RETURN-CODE-2                                    56660000
MFA-TR*            ,:S-REVENUE-MONTH                                    56670000
MFA-TR*            ,:S-DAYS                                             56680000
MFA-TR*            ,:S-UNITS                                            56690000
MFA-TR*            ,:S-NEW-CHARGE                                       56700000
MFA-TR*            ,:S-GAS-BUFFER                                       56701000
MFA-TR*           )                                                     56710000
MFA-TR*     END-EXEC                                                    56720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 56730000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 56760000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-USAGE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04353_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 56920000
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 56950000
      ******************************************************************56960000
      * 8800-CHECK-RESULTS.                                            *56970000
      ******************************************************************56980000
      *                                                                 56990000
       8800-CHECK-RESULTS.                                              
      *                                                                 57010000
           IF WS-BBP-EST  = 0                                           
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                 57070000
           IF WS-BBP-USAGE   = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
      *                                                                 57130000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 57160000
      ******************************************************************57170000
      * 8900-SEND-DONE.                                                *57180000
      ******************************************************************57190000
      *                                                                 57200000
       8900-SEND-DONE.                                                  
      *                                                                 57220000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 57260000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 57290000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04353_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 57410000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 57450000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 57480000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04353_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 57600000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 57630000
      ******************************************************************57640000
      * 9700-ABEND-PROCESSING.                                         *57650000
      ******************************************************************57660000
      *                                                                 57670000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 57690000
           EVALUATE TRUE                                                
               WHEN WS-ESTIMATION                                       
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
               WHEN WS-USAGE                                            
                    MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
           END-EVALUATE.                                                
      *                                                                 57780000
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                 57830000
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 57870000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                 57930000
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                 57950000
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-2         TO S-RETURN-CODE-2.            
      *                                                                 57980000
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                 58010000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 58040000
      ******************************************************************58050000
      * 9700-ABEND-PROCESSING.                                         *58060000
      ******************************************************************58070000
      *                                                                 58080000
       9700-PROCESS-ABEND.                                              
      *                                                                 58100000
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                 58130000
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 58160000
      ******************************************************************58170000
      * 9900-SQL-ERROR-ROUTINE.                                        *58180000
      ******************************************************************58190000
      *                                                                 58200000
           EXEC SQL                                                     58210000
              INCLUDE CPDSP300                                          58220000
           END-EXEC.                                                    58230000
      *                                                                 58240000
      ******************************************************************58250000
      * 9999-END-PROGRAM.                                      *        58260000
      ******************************************************************58270000
      *                                                                 58280000
       9999-END-PROGRAM.                                                
      *                                                                 58300000
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT
           END-IF.                
      *                                                                 58420000
           
MSQ016        GOBACK.                                                    
      *                                                                 58440000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *58470000
      **********************End Of Program *****************************58480000
      *                                                                *58490000
