       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04596.                                       
       AUTHOR.           MS93554.                                       
COB303 DATE-WRITTEN. DEC 26, 2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04596              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04596 :                                                --         
      *--                                                            --         
      *--  RETRIEVE CURRENT OPTION DISCOUNT DETAILS AND              --         
      *--  PENDING OPTION DISCOUNT DETAILS BASED ON THE PENDING FLAG --         
      *--  FOR PRICE DISCOUNT / CSC DISCOUNT ATTR INCTV.             --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--                                                            --         
      *--            ACCOUNT_NO            DECIMAL(13)               --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            IC_NO                 SMALLINT                  --         
      *--            PENDING_FLAG          CHAR(01)                  --         
      *--                                                            --         
      *--      OUTPUT                                                --         
      *--                                                            --         
      *--      RESULT SET 1                                          --         
      *--            RETURN_CODE           INTEGER                   --         
      *--            APPL_RETURN_CODE      INTEGER                   --         
      *--            ATTR_INCTV_DESC       CHAR(35)                  --         
      *--            VALUE                 DECIMAL(13,4)             --         
      *--            DURATION_NO           SMALLINT                  --         
      *--            RT_ATTR_INCTV_TYPE    CHAR(15)                  --         
      *--                                                            --         
      *--      RESULT SET 2                                          --         
      *--            RETURN_CODE           INTEGER                   --         
      *--            APPL_RETURN_CODE      INTEGER                   --         
      *--            PRCE_NEGOTIATED_CD    CHAR(01)                  --         
P00805*--            CSC_DISCOUNT_CODE     CHAR(01)                  --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      RESULT SET                                            --         
      *--                                                            --         
      *--            MULTIPLE ROWS                                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  12/26/2012    MS93554     PROGRAM INTIALLY WRITTEN.       --         
P680PN*--  06/05/2013    MS93554     EARLIER THIS PROGRAM WAS CODED  --         
      *--                            WITH SINGLE RESULT SET NOW      --         
      *--                            CHANGED TO RETURN MLTBL RSLT    --         
      *--                            SET.PRCE NEGOTIATED CD RETURNING--         
      *--                            IN RESULT SET 2.                --         
P00805*--  02/26/2016    SS45239     ADD CSC DISCOUNT CODE TO RESULT --         
P805CS*--  04/05/2016    GD43988     ADD CSC DISCOUNT ELIG VALIDATION--         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04596'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CRM_OPT_ATTR_INCTV, HQ                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBOPTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCTR, FF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXDFCT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_RT_PKG_OPTION, FI                                         *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_UTIL_ENVRNMT UT                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUTLENV                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ACCT_RTPK_AGR DF                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCTRG                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_SPCL_FCTR   SF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBSPLFTR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_JOB_PARM, G6                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
      *                                                                         
P805CS*** DISCOUNT ELIGIBILITY ROUTINE WS COPYBOOK(S)                           
P805CS     EXEC SQL                                                             
P805CS         INCLUDE CWS0444E                                                 
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS     COPY CWS00444.                                                       
P805CS*                                                                         
P805CS*** CODES DATA PRESENT LAYOUT                                             
P805CS*                                                                         
P805CS     COPY CWS00056.                                                       
P805CS*                                                                         
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
           COPY CWS00063.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.               
           05 WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.           
           05 WS-IC-NO                PIC S9(4) COMP.                   
           05 WS-PENDING-FLAG         PIC X(01) VALUE SPACES.           
           05 WS-INCLUDE-SUMMARY      PIC X(01) VALUE SPACES.           
           05 WS-DURATION-NO-HQ       PIC Z9.                           
           05 WS-FACTOR-TEXT-LEN      PIC S9(4) COMP.                   
           05 WS-APPL-RETURN-CODE     PIC S9(04) VALUE 0.               
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
           05 WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.              
              88 NO-MORE-ROWS                   VALUE 'Y'.              
                                                                        
P680PN 01  COUNTER-FIELDS.                                              
P680PN     05  CTR-COLUMN             PIC S9(9) COMP VALUE 1.           
P680PN     05  CTR-ROWS-RS1           PIC S9(9) COMP VALUE 0.           
P680PN     05  CTR-ROWS-RS2           PIC S9(9) COMP VALUE 0.           
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08)  VALUE 'CSR04596'.      
           05 MCSCB063                PIC X(08)  VALUE 'MCSCB063'.      
           05 WS-NO                   PIC X(01)  VALUE 'N'.             
           05 WS-YES                  PIC X(01)  VALUE 'Y'.             
           05 WS-ZERO                 PIC S9(01) VALUE 0.               
           05 WS-ONE                  PIC S9(01) VALUE 1.               
           05 WS-TWO                  PIC S9(01) VALUE 2.               
           05 WS-THREE                PIC S9(01) VALUE 3.               
           05 WS-PENDING              PIC X(01)  VALUE 'P'.             
           05 WS-FOR-LIT-DESC         PIC X(04)  VALUE ' for'.          
           05 WS-MONTHS-LIT-DESC      PIC X(08)  VALUE ' Months'.       
           05 GTT-NAME1               PIC X(26)                         
                                            VALUE 'SESSION.CSR04596_R1'.
           05 GTT-NAME2               PIC X(26)                         
                                            VALUE 'SESSION.CSR04596_R2'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN         PIC S9(04) COMP.                  
               49 GTT-ROW-CHAR        PIC X(1024).                      
           05  GTT-SQLCODE            PIC S9(9) COMP.                   
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM        PIC S9(9) COMP.                   
           05  WRKLEN1                PIC S9(9) COMP.                   
           05  WRKLEN2                PIC S9(9) COMP.                   
           05  WRK-DONE-STATUS        PIC S9(9) COMP.                   
                                                                        
       01  WS-MISC.                                                     
           05 WS-MCSCB063-RET-CODE    PIC S9(04) COMP VALUE 0.          
           05 WS-FACTOR-FF            PIC S9(09)V9(06) USAGE COMP-3     
                                                     VALUE 0.           
           05 WS-OPT-DSCNTD-PRC       PIC S9(5)V9(6) USAGE COMP-3       
                                                     VALUE 0.           
           05 WS-OPT-TOT-PRC-DSCNT    PIC S9(5)V9(6) USAGE COMP-3       
                                                     VALUE 0.           
           05 WS-PUBLISHED-THRM-PRC   PIC S9(5)V9(6) USAGE COMP-3       
                                                     VALUE 0.           
                                                                        
P680PN 01 GTT-RETURN-FIELDS.                                            
P680PN    05  GTT-RETURN-FIELDS-1.                                      
P680PN        10 S-RETURN-CODE-1      PIC S9(09) COMP VALUE 0.          
P680PN        10 S-APPL-RETURN-CODE-1 PIC S9(09) COMP VALUE 0.          
P680PN        10 S-FACTOR-TEXT        PIC X(35)  VALUE SPACES.          
P680PN        10 S-FACTOR             PIC S9(5)V9(6)                    
P680PN                                           USAGE COMP-3 VALUE 0.  
P680PN        10 S-DURATION-NO        PIC S9(04) COMP VALUE 0.          
P680PN        10 S-RT-ATTR-INCTV-TYPE PIC X(15)  VALUE SPACES.          
P680PN        10 S-SORT-ORDER         PIC S9(04) COMP VALUE 0.          
P680PN                                                                  
P680PN    05  GTT-RETURN-FIELDS-2.                                      
P680PN        10 S-RETURN-CODE-2      PIC S9(04) COMP VALUE 0.          
P680PN        10 S-APPL-RETURN-CODE-2 PIC S9(04) COMP VALUE 0.          
P680PN        10 S-PRCE-NEGOTIATED-CD PIC X(01).                        
P00805        10 S-CSC-DISCOUNT-CODE  PIC X(01).                        
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO RETRIEVE DISCOUNT FACTORS FOR PENDING OPTION *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE FIXED_FCTR_CUR CURSOR FOR                        
                SELECT  SF.FACTOR_TEXT                                  
                       ,DATALENGTH(LTRIM(RTRIM(SF.FACTOR_TEXT)))                
                       ,SF.FCTR_POWER_10                                
                       ,FF.FACTOR                                       
                       ,HQ.DURATION_NO                                  
                       ,HQ.RT_ATTR_INCTV_TYPE                           
                       ,DF.OPTION_CD                                    
                       ,DF.RT_PKG_OPT_SEQ_NO                            
                  FROM  CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
                       ,CSS_ACCT_RTPK_AGR    DF WITH(READUNCOMMITTED)           
                       ,CSS_SPCL_FCTR        SF WITH(READUNCOMMITTED)           
                       ,CRM_OPT_ATTR_INCTV   HQ WITH(READUNCOMMITTED)           
                 WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO         
                   AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE     
                   AND  DF.IC_NO               = :DF-IC-NO              
                   AND  DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO  
                   AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO   
                   AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO          
                   AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE      
                   AND  FF.IC_NO               = DF.IC_NO               
                   AND  FF.FACTOR_ID           = SF.FACTOR_ID           
                   AND  FF.DURATION_REMAIN_NO  > 0                      
                   AND  HQ.OPTION_CD           = DF.OPTION_CD           
                   AND  HQ.FACTOR_ID           = FF.FACTOR_ID           
                   AND  HQ.COMPANY_NO          = DF.COMPANY_NO          
                   AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT    
                   AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT    
                   AND  HQ.RT_ATTR_INCTV_TYPE IN (                      
                                        SELECT G6.PARM_DATA             
                                          FROM CSS_JOB_PARM G6
                           WITH(READUNCOMMITTED)          
                                         WHERE PROGRAM_NAME = 'CSR04596'
                                           AND STATUS       = 'A' )     
                   AND  HQ.PROC_STATUS_CD      = 'AC'                   
                   AND  HQ.OPT_ATTR_VSTART_TS  = (                      
                      SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                
                        FROM  CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                     
                       WHERE  H1.OPTION_CD      = HQ.OPTION_CD          
                         AND  H1.RT_ATTR_INCTV_TYPE                     
                                                = HQ.RT_ATTR_INCTV_TYPE 
                         AND  H1.ATTR_INCTV_STRT_DT                     
                                                <= DF.OPT_AGRMT_EFF_DT  
                         AND  H1.ATTR_INCTV_END_DT                      
                                                >= DF.OPT_AGRMT_EFF_DT  
                         AND  CAST(H1.OPT_ATTR_VSTART_TS AS DATE)               
                                                <= DF.OPT_AGRMT_EFF_DT  
                         AND  CAST(H1.OPT_ATTR_VEND_TS AS DATE)                 
                                                >= DF.OPT_AGRMT_EFF_DT  
                         AND  H1.PROC_STATUS_CD  = 'AC')                
                   FOR READ ONLY                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FIXED_FCTR_CUR CURSOR FOR                                
MFA-TR*         SELECT  SF.FACTOR_TEXT                                          
MFA-TR*                ,LENGTH(STRIP(SF.FACTOR_TEXT))                           
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,HQ.DURATION_NO                                          
MFA-TR*                ,HQ.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                ,DF.OPTION_CD                                            
MFA-TR*                ,DF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*           FROM  CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_ACCT_RTPK_AGR    DF                                 
MFA-TR*                ,CSS_SPCL_FCTR        SF                                 
MFA-TR*                ,CRM_OPT_ATTR_INCTV   HQ                                 
MFA-TR*          WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                 
MFA-TR*            AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE             
MFA-TR*            AND  DF.IC_NO               = :DF-IC-NO                      
MFA-TR*            AND  DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO          
MFA-TR*            AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO           
MFA-TR*            AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO                  
MFA-TR*            AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE              
MFA-TR*            AND  FF.IC_NO               = DF.IC_NO                       
MFA-TR*            AND  FF.FACTOR_ID           = SF.FACTOR_ID                   
MFA-TR*            AND  FF.DURATION_REMAIN_NO  > 0                              
MFA-TR*            AND  HQ.OPTION_CD           = DF.OPTION_CD                   
MFA-TR*            AND  HQ.FACTOR_ID           = FF.FACTOR_ID                   
MFA-TR*            AND  HQ.COMPANY_NO          = DF.COMPANY_NO                  
MFA-TR*            AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.RT_ATTR_INCTV_TYPE IN (                              
MFA-TR*                                 SELECT G6.PARM_DATA                     
MFA-TR*                                   FROM CSS_JOB_PARM G6                  
MFA-TR*                                  WHERE PROGRAM_NAME = 'CSR04596'        
MFA-TR*                                    AND STATUS       = 'A' )             
MFA-TR*            AND  HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*            AND  HQ.OPT_ATTR_VSTART_TS  = (                              
MFA-TR*               SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                 FROM  CRM_OPT_ATTR_INCTV H1                             
MFA-TR*                WHERE  H1.OPTION_CD      = HQ.OPTION_CD                  
MFA-TR*                  AND  H1.RT_ATTR_INCTV_TYPE                             
MFA-TR*                                         = HQ.RT_ATTR_INCTV_TYPE         
MFA-TR*                  AND  H1.ATTR_INCTV_STRT_DT                             
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.ATTR_INCTV_END_DT                              
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VSTART_TS)                       
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VEND_TS)                         
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.PROC_STATUS_CD  = 'AC')                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO  7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.           
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC S9(4) COMP.               
       01  PARM-PENDING-FLAG              PIC X(01).                    
       01  PARM-INCLUDE-SUMMARY           PIC X(01).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-PENDING-FLAG                      
                                 PARM-INCLUDE-SUMMARY.                  
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100A-INSERT-GTT-R1.                                           *        
      ******************************************************************        
       0100A-INSERT-GTT-R1.                                             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04596_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04596_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,FACTOR_TEXT CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,FACTOR               DECIMAL(13,4)                  
                   ,DURATION_NO          SMALLINT                       
                   ,RT_ATTR_INCTV_TYPE CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,SORT_ORDER           INT                        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME1             TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(FACTOR_TEXT))        AS 
           ATTR_INCTV_DESC     
                      ,FACTOR                    AS VALUE               
                      ,DURATION_NO                                      
                      ,LTRIM(RTRIM(RT_ATTR_INCTV_TYPE)) AS 
           RT_ATTR_INCTV_TYPE  
                      ,SORT_ORDER                AS SORT_ORDER          
                  FROM #CSR04596_R1                              
                  ORDER BY SORT_ORDER                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(FACTOR_TEXT)        AS ATTR_INCTV_DESC             
MFA-TR*               ,FACTOR                    AS VALUE                       
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,STRIP(RT_ATTR_INCTV_TYPE) AS RT_ATTR_INCTV_TYPE          
MFA-TR*               ,SORT_ORDER                AS SORT_ORDER                  
MFA-TR*           FROM SESSION.CSR04596_R1                                      
MFA-TR*           ORDER BY SORT_ORDER                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
P680PN******************************************************************        
P680PN* 0100B-INSERT-GTT-R2.                                           *        
P680PN******************************************************************        
P680PN 0100B-INSERT-GTT-R2.                                             
P680PN                                                                  
P680PN     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04596_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04596_R2
              (                                                       
P680PN              RETURN_CODE          INT                        
P680PN             ,APPL_RETURN_CODE     INT                        
P680PN             ,PRCE_NEGOTIATED_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00805             ,CSC_DISCOUNT_CODE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P680PN          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680PN                                                                  
P680PN     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P680PN     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P680PN                                                                  
P680PN     IF WS-SQLSTATE = '42710'                                     
P680PN        PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
P680PN     ELSE                                                         
P680PN        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P680PN           CONTINUE                                               
P680PN        ELSE                                                      
P680PN           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
P680PN           MOVE '0100B'               TO ACTIVE-PARAGRAPH         
P680PN           MOVE SQLCODE               TO ABEND-SQLCODE            
P680PN           MOVE SQLSTATE              TO ABEND-SQLSTATE           
P680PN           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
P680PN           MOVE SPACES                TO ABEND-SQL-PREDICATES     
P680PN                                         ABEND-TABLES             
P680PN           MOVE GTT-NAME2             TO TABLE-1                  
P680PN           MOVE SPACES                TO TABLE-ELEMENT-1          
P680PN           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
P680PN           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
P680PN           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
P680PN        END-IF                                                    
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN         DECLARE C2 CURSOR                             
P680PN                           WITH ROWSET POSITIONING FOR            
P680PN          SELECT RETURN_CODE                                      
P680PN                ,APPL_RETURN_CODE                                 
P680PN                ,PRCE_NEGOTIATED_CD   AS PRCE_NEGOTIATED_CD       
P00805                ,CSC_DISCOUNT_CODE    AS CSC_DISCOUNT_CODE        
P680PN            FROM #CSR04596_R2                              
P680PN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,PRCE_NEGOTIATED_CD   AS PRCE_NEGOTIATED_CD               
MFA-TR*               ,CSC_DISCOUNT_CODE    AS CSC_DISCOUNT_CODE                
MFA-TR*           FROM SESSION.CSR04596_R2                                      
MFA-TR*    END-EXEC.                                                            
P680PN                                                                  
P680PN 0100B-EXIT.                                                      
P680PN     EXIT.                                                        
P680PN                                                                  
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO            
                                               FF-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               WS-ACCOUNT-NO-063.       
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE        
                                               FF-CODE-UTIL-TYPE        
                                               UT-CODE-UTIL-TYPE        
                                               WS-CODE-UTIL-TYPE-063.   
           MOVE PARM-IC-NO                  TO WS-IC-NO                 
                                               FF-IC-NO                 
                                               UT-IC-NO                 
                                               WS-IC-NO-063.            
           MOVE PARM-PENDING-FLAG           TO WS-PENDING-FLAG.         
           MOVE PARM-INCLUDE-SUMMARY        TO WS-INCLUDE-SUMMARY.      
                                                                        
           PERFORM 0100A-INSERT-GTT-R1         THRU 0100A-EXIT.         
           PERFORM 0100B-INSERT-GTT-R2         THRU 0100B-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO               TO DF-ACCOUNT-NO            
           MOVE WS-CODE-UTIL-TYPE           TO DF-CODE-UTIL-TYPE        
           MOVE WS-IC-NO                    TO DF-IC-NO                 
                                                                        
           IF WS-INCLUDE-SUMMARY EQUAL WS-YES                           
              MOVE WS-TWO                   TO S-SORT-ORDER             
           END-IF.                                                      
                                                                        
      *    Get rate package seq number.                                         
           IF WS-PENDING-FLAG EQUAL WS-YES                              
              PERFORM 7100-GET-RTPK-OPT-SEQ-NO THRU 7100-EXIT           
           ELSE                                                         
              PERFORM 7200-GET-RTPK-OPT-SEQ-NO THRU 7200-EXIT           
              MOVE UT-RT-PKG-OPT-SEQ-NO     TO DF-RT-PKG-OPT-SEQ-NO     
           END-IF.                                                      
                                                                        
      *    Result set 1:                                                        
           PERFORM 2100-GET-DISCOUNT-PRICE     THRU 2100-EXIT.          
           PERFORM 2200-BUILD-SUMMARY-ROW      THRU 2200-EXIT.          
                                                                        
      *    Result set 2:                                                        
P00805     PERFORM 2400-GET-ADDITIONAL-INFO    THRU 2400-EXIT.          
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-GET-DISCOUNT-PRICE.                                       *        
      ******************************************************************        
       2100-GET-DISCOUNT-PRICE.                                         
                                                                        
      *    GET THERM PRICE AND CSC DISCOUNTS FOR PENDING OPTION CODE            
           MOVE WS-NO                       TO WS-NO-MORE-ROWS          
           PERFORM 7300-OPEN-FIXED-FCTR-CUR    THRU 7300-EXIT.          
           PERFORM 7400-FETCH-FIXED-FCTR-CUR   THRU 7400-EXIT.          
           PERFORM 2300-GET-OPTION-DSCNT       THRU 2300-EXIT           
                                                  UNTIL NO-MORE-ROWS.   
           PERFORM 7500-CLOSE-FIXED-FCTR-CUR   THRU 7500-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-BUILD-SUMMARY-ROW.                                        *        
      ******************************************************************        
       2200-BUILD-SUMMARY-ROW.                                          
                                                                        
      *    Build the summary rows only if acct has any dscnt available.         
           IF WS-OPT-TOT-PRC-DSCNT EQUAL WS-ZERO                        
              MOVE WS-ZERO                   TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              MOVE WS-ZERO                   TO S-SORT-ORDER            
              INITIALIZE                        S-RT-ATTR-INCTV-TYPE    
                                                S-DURATION-NO           
                                                S-FACTOR-TEXT           
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
           ELSE                                                         
            IF WS-INCLUDE-SUMMARY EQUAL WS-YES                          
      *       Get total therm price from CPD00063                               
              MOVE 'Y'                       TO WS-THERM-CSC-ACCT-FL    
              MOVE 'Y'                       TO WS-PENDING-OPTION-FL-063
              MOVE DF-OPTION-CD              TO WS-OPTION-CD            
              PERFORM 6000-CALL-MCSCB063        THRU 6000-EXIT          
              MOVE WS-PUBLISHED-THRM-PRC     TO WS-OPT-DSCNTD-PRC       
                                                                        
      *       Get discount price.                                               
              COMPUTE WS-OPT-DSCNTD-PRC    EQUAL                        
                      WS-OPT-DSCNTD-PRC  + WS-OPT-TOT-PRC-DSCNT         
              MOVE 'Discounted Price'        TO S-FACTOR-TEXT           
              MOVE WS-OPT-DSCNTD-PRC         TO S-FACTOR                
              MOVE WS-ZERO                   TO S-DURATION-NO           
              MOVE SPACES                    TO S-RT-ATTR-INCTV-TYPE    
              ADD +1                         TO S-SORT-ORDER            
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
      *      Get Total Therm price.                                             
              COMPUTE WS-OPT-TOT-PRC-DSCNT EQUAL                        
                      WS-OPT-TOT-PRC-DSCNT * -1                         
              MOVE 'Total Therm Discount'    TO S-FACTOR-TEXT           
              MOVE WS-OPT-TOT-PRC-DSCNT      TO S-FACTOR                
              MOVE WS-ZERO                   TO S-DURATION-NO           
              MOVE SPACES                    TO S-RT-ATTR-INCTV-TYPE    
              MOVE WS-ONE                    TO S-SORT-ORDER            
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
                                                                        
      *      Get Published therm price.                                         
              MOVE 'Published Price'         TO S-FACTOR-TEXT           
              MOVE WS-PUBLISHED-THRM-PRC     TO S-FACTOR                
              MOVE WS-ZERO                   TO S-DURATION-NO           
              MOVE SPACES                    TO S-RT-ATTR-INCTV-TYPE    
              MOVE WS-TWO                    TO S-SORT-ORDER            
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
            END-IF                                                      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-GET-OPTION-DSCNT.                                         *        
      ******************************************************************        
       2300-GET-OPTION-DSCNT.                                           
                                                                        
           IF SF-FCTR-POWER-10 NOT EQUAL WS-ZERO                        
              COMPUTE FF-FACTOR = FF-FACTOR * 10** SF-FCTR-POWER-10     
           END-IF                                                       
                                                                        
           MOVE HQ-RT-ATTR-INCTV-TYPE      TO S-RT-ATTR-INCTV-TYPE.     
           MOVE HQ-DURATION-NO             TO WS-DURATION-NO-HQ         
                                              S-DURATION-NO.            
           MOVE FF-FACTOR                  TO S-FACTOR                  
                                                                        
           INITIALIZE S-FACTOR-TEXT                                     
           EVALUATE HQ-RT-ATTR-INCTV-TYPE                               
                                                                        
               WHEN 'PRICE DISCOUNT'                                    
                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)           
                                                DELIMITED BY SIZE       
                        WS-FOR-LIT-DESC         DELIMITED BY SIZE       
                           ' '                  DELIMITED BY SIZE       
                        WS-DURATION-NO-HQ       DELIMITED BY SIZE       
                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE       
                        INTO S-FACTOR-TEXT                              
               WHEN 'CSC DISCOUNT'                                      
                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)           
                                                DELIMITED BY SIZE       
                        WS-FOR-LIT-DESC         DELIMITED BY SIZE       
                           ' '                  DELIMITED BY SIZE       
                        WS-DURATION-NO-HQ       DELIMITED BY SIZE       
                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE       
                        INTO S-FACTOR-TEXT                              
           END-EVALUATE.                                                
                                                                        
           COMPUTE WS-OPT-TOT-PRC-DSCNT EQUAL                           
                   WS-OPT-TOT-PRC-DSCNT    + FF-FACTOR                  
                                                                        
           ADD +1                                 TO S-SORT-ORDER       
           IF WS-OPT-TOT-PRC-DSCNT NOT EQUAL WS-ZERO                    
              PERFORM 8010-INSERT-GTT-R1             THRU 8010-EXIT     
           END-IF                                                       
                                                                        
           PERFORM 7400-FETCH-FIXED-FCTR-CUR THRU 7400-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P680PN*****************************************************************         
P680PN*                                                               *         
P00805* 2400-GET-ADDITIONAL-INFO.                                     *         
P680PN*****************************************************************         
P00805 2400-GET-ADDITIONAL-INFO.                                        
P680PN                                                                  
P680PN     PERFORM 7000-GET-PRCE-NEGOTIATED-CD  THRU 7000-EXIT.         
P680PN     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P680PN        MOVE DF-PRCE-NEGOTIATED-CD     TO S-PRCE-NEGOTIATED-CD    
P680PN     ELSE                                                         
P680PN        MOVE WS-NO                     TO S-PRCE-NEGOTIATED-CD    
P680PN     END-IF.                                                      
P805CS*                                                                         
P805CS*** SET CSC DISCOUNT CODE                                                 
P805CS     PERFORM 2450-PROCESS-CSC-DISCOUNTS THRU 2450-EXIT.           
P805CS*                                                                         
P680PN     PERFORM 8020-INSERT-GTT-R2           THRU 8020-EXIT.         
P680PN                                                                  
P680PN 2400-EXIT.                                                       
P680PN     EXIT.                                                        
                                                                        
P805CS*****************************************************************         
P805CS*** VALIDATE CSC DISOCUNT ELIGIBILITY                         ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 2450-PROCESS-CSC-DISCOUNTS.                                      
P805CS*                                                                         
P805CS     MOVE '2450'                       TO ACTIVE-PARAGRAPH.       
P805CS*                                                                         
P805CS     MOVE WS-ACCOUNT-NO                TO WS-444-I-ACCT-NO.       
P805CS     MOVE PROGRAM-NAME                 TO WS-444-I-PGM-ID.        
P805CS     MOVE SPACES                       TO WS-444-I-USER-ID.       
P805CS*                                                                         
P805CS     PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
P805CS        THRU 6000-CPD444-EXIT.                                    
P805CS*                                                                         
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS       WHEN 0                                                     
P805CS            MOVE 'N'                   TO S-CSC-DISCOUNT-CODE     
P805CS            PERFORM VARYING WS-444-S FROM 1 BY 1                  
SCA006              UNTIL S-CSC-DISCOUNT-CODE        = 'Y' OR 
                          WS-444-S > 10 OR 
                          WS-444-O-ELIG-FL(WS-444-S) = SPACES              
P805CS              IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'                 
P805CS                 MOVE 'Y'              TO S-CSC-DISCOUNT-CODE     
P805CS              END-IF                                              
P805CS            END-PERFORM                                           
P805CS       WHEN 999                                                   
P805CS            MOVE 'N'                   TO S-CSC-DISCOUNT-CODE     
P805CS       WHEN OTHER                                                 
P805CS            PERFORM 6999-CPD444-ERROR-ROUTINE                     
P805CS               THRU 6999-CPD444-EXIT                              
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 2450-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      *****************************************************************         
      *                                                               *         
      * 6000-CALL-MCSCB063.                                           *         
      *****************************************************************         
       6000-CALL-MCSCB063.                                              
                                                                        
           CALL MCSCB063 USING CWS00063-FIELDS,                         
                              ,ABEND-FILE,                              
                              ,WS-MCSCB063-RET-CODE.                    
                                                                        
           MOVE WS-MCSCB063-RET-CODE         TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-MCSCB063-RET-CODE EQUAL ZEROES                         
              IF WS-FF-DURATION-REM EQUAL ZEROES                        
                               AND WS-RATE-CALC-TYPE-CD EQUAL '02'      
                 MOVE DF-OPTION-CD           TO HQ-OPTION-CD            
                 MOVE DF-RT-PKG-OPT-SEQ-NO   TO FF-RT-PKG-OPT-SEQ-NO    
                 PERFORM 7600-SEL-THERM-PRICE   THRU 7600-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE FF-FACTOR           TO WS-PUBLISHED-THRM-PRC   
                    IF SF-FCTR-POWER-10 NOT EQUAL WS-ZERO               
                       COMPUTE WS-FACTOR-FF = FF-FACTOR *               
                                         10** SF-FCTR-POWER-10          
                       MOVE WS-FACTOR-FF  TO WS-PUBLISHED-THRM-PRC      
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-THERM-PRICE         TO WS-PUBLISHED-THRM-PRC   
              END-IF                                                    
                                                                        
              IF WS-PENDING-FLAG EQUAL WS-YES                           
                 IF WS-PENDING-OPTION-FL-063 EQUAL WS-YES               
                    MOVE WS-PEND063-THERM-PRICE TO WS-PUBLISHED-THRM-PRC
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P805CS*****************************************************************         
P805CS*** 6000-CPD444-CSC-DISCOUNT-ELIG THRU 6000-CPD444-EXIT       ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS     EXEC SQL                                                     PCS03470
P805CS        INCLUDE CPD0444E                                          PCS03470
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS*****************************************************************         
P805CS*** ERROR ROUTINE FOR CPD0444E                                ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 6999-CPD444-ERROR-ROUTINE.                                       
P805CS*                                                                         
P805CS     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
P805CS     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
P805CS*                                                                         
P805CS 6999-CPD444-EXIT.                                                
P805CS     EXIT.                                                        
P805CS*                                                                         
P680PN******************************************************************        
P680PN*                                                                *        
P680PN* 7000-GET-PRCE-NEGOTIATED-CD.                                   *        
P680PN******************************************************************        
P680PN 7000-GET-PRCE-NEGOTIATED-CD.                                     
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN        SELECT DF.PRCE_NEGOTIATED_CD                              
P680PN          INTO :DF-PRCE-NEGOTIATED-CD                             
P680PN          FROM CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                
P680PN         WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO            
P680PN           AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE        
P680PN           AND DF.IC_NO               = :DF-IC-NO                 
P680PN           AND DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO     
P680PN                                                           
P680PN                                                      
P680PN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DF.PRCE_NEGOTIATED_CD                                      
MFA-TR*         INTO :DF-PRCE-NEGOTIATED-CD                                     
MFA-TR*         FROM CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*        WHERE DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                    
MFA-TR*          AND DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE                
MFA-TR*          AND DF.IC_NO               = :DF-IC-NO                         
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680PN                                                                  
P680PN     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P680PN                                         S-RETURN-CODE-2.         
P680PN                                                                  
P680PN     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P680PN        CONTINUE                                                  
P680PN     ELSE                                                         
P680PN        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P680PN        MOVE '7000'                    TO ACTIVE-PARAGRAPH        
P680PN        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P680PN        MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                 
P680PN        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P680PN        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
P680PN        MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
P680PN        MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-4         
P680PN        MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P680PN        MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
P680PN        MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3       
P680PN        MOVE DF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-4       
P680PN        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P680PN        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P680PN                                                                  
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN 7000-EXIT.                                                       
P680PN     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-RTPK-OPT-SEQ-NO.                                      *        
      ******************************************************************        
       7100-GET-RTPK-OPT-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DF.RT_PKG_OPT_SEQ_NO                               
                INTO :DF-RT-PKG-OPT-SEQ-NO                              
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO      = :DF-ACCOUNT-NO                
                 AND DF.CODE_UTIL_TYPE  = :DF-CODE-UTIL-TYPE            
                 AND DF.IC_NO           = :DF-IC-NO                     
                 AND DF.STATUS_CD       = :WS-PENDING                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DF.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*         INTO :DF-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*        WHERE DF.ACCOUNT_NO      = :DF-ACCOUNT-NO                        
MFA-TR*          AND DF.CODE_UTIL_TYPE  = :DF-CODE-UTIL-TYPE                    
MFA-TR*          AND DF.IC_NO           = :DF-IC-NO                             
MFA-TR*          AND DF.STATUS_CD       = :WS-PENDING                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-RTPK-OPT-SEQ-NO.                                      *        
      ******************************************************************        
       7200-GET-RTPK-OPT-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UT.RT_PKG_OPT_SEQ_NO                               
                INTO :UT-RT-PKG-OPT-SEQ-NO                              
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                
                 AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE            
                 AND UT.IC_NO           = :UT-IC-NO                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*         INTO :UT-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE                    
MFA-TR*          AND UT.IC_NO           = :UT-IC-NO                             
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-OPEN-FIXED-FCTR-CUR.                                      *        
      ******************************************************************        
       7300-OPEN-FIXED-FCTR-CUR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN FIXED_FCTR_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-4                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-FETCH-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7400-FETCH-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH FIXED_FCTR_CUR                                     
                INTO :SF-FACTOR-TEXT                                    
                    ,:WS-FACTOR-TEXT-LEN                                
                    ,:SF-FCTR-POWER-10                                  
                    ,:FF-FACTOR                                         
                    ,:HQ-DURATION-NO                                    
                    ,:HQ-RT-ATTR-INCTV-TYPE                             
                    ,:DF-OPTION-CD                                      
                    ,:DF-RT-PKG-OPT-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE WS-YES               TO WS-NO-MORE-ROWS          
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7400'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE 'CSS_FIXED_FCTR  '   TO TABLE-1                  
                  MOVE 'CSS_SPCL_FCTR   '   TO TABLE-2                  
                  MOVE 'CSS_ACCT_RTPK_AG'   TO TABLE-3                  
                  MOVE 'CSS_SPCL_FCTR'      TO TABLE-4                  
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
                  MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2          
                  MOVE 'IC_NO'              TO TABLE-ELEMENT-3          
                  MOVE DF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
                  MOVE DF-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2        
                  MOVE DF-IC-NO             TO HOSTVAR-ELEMENT-3        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-CLOSE-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7500-CLOSE-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE FIXED_FCTR_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-4                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7600-SEL-THERM-PRICE.                                         *         
      *****************************************************************         
       7600-SEL-THERM-PRICE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FACTOR,
              FF.FACTOR_ID                                       
                INTO :FF-FACTOR                                         
                    ,:FF-FACTOR-ID                                      
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
                    ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
                 AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
                 AND FF.IC_NO              = :FF-IC-NO                  
                 AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO      
                 AND FF.FACTOR_ID          = HQ.FACTOR_ID               
                 AND HQ.OPTION_CD          = :HQ-OPTION-CD              
                 AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'              
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
               ORDER BY FF.EFF_DATE_FROM DESC                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*             ,FF.FACTOR_ID                                               
MFA-TR*         INTO :FF-FACTOR                                                 
MFA-TR*             ,:FF-FACTOR-ID                                              
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND FF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1.        
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-4         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04596_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04596_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04596_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
P680PN*****************************************************************         
P680PN* 8000B-DEL-GTT-ROWS.                                           *         
P680PN*****************************************************************         
P680PN 8000B-DEL-GTT-ROWS.                                              
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN         DELETE FROM #CSR04596_R2                          
P680PN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04596_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680PN                                                                  
P680PN     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P680PN                                         S-RETURN-CODE-2.         
P680PN                                                                  
P680PN     EVALUATE WS-ACTIVE-RETURN-CODE                               
P680PN         WHEN SUCCESSFUL-CALL                                     
P680PN              CONTINUE                                            
P680PN         WHEN NOT-FOUND                                           
P680PN              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
P680PN         WHEN OTHER                                               
P680PN              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P680PN              MOVE SQLCODE            TO ABEND-SQLCODE            
P680PN              MOVE SQLSTATE           TO ABEND-SQLSTATE           
P680PN              MOVE '8000B'            TO ACTIVE-PARAGRAPH         
P680PN              MOVE 'DELETE'           TO ABEND-FUNCTION           
P680PN              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P680PN                                         ABEND-TABLES             
P680PN              MOVE 'CSR04596_R2'      TO TABLE-1                  
P680PN              MOVE SPACES             TO TABLE-ELEMENT-1          
P680PN              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
P680PN              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
P680PN              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
P680PN     END-EVALUATE.                                                
P680PN                                                                  
P680PN 8000B-EXIT.                                                      
P680PN      EXIT.                                                       
P680PN                                                                  
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04596_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,FACTOR_TEXT                                         
                   ,FACTOR                                              
                   ,DURATION_NO                                         
                   ,RT_ATTR_INCTV_TYPE                                  
                   ,SORT_ORDER                                          
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-1                                    
                   ,:S-APPL-RETURN-CODE-1                               
                   ,:S-FACTOR-TEXT                                      
                   ,:S-FACTOR                                           
                   ,:S-DURATION-NO                                      
                   ,:S-RT-ATTR-INCTV-TYPE                               
                   ,:S-SORT-ORDER                                       
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04596_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,FACTOR_TEXT                                                 
MFA-TR*            ,FACTOR                                                      
MFA-TR*            ,DURATION_NO                                                 
MFA-TR*            ,RT_ATTR_INCTV_TYPE                                          
MFA-TR*            ,SORT_ORDER                                                  
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-APPL-RETURN-CODE-1                                       
MFA-TR*            ,:S-FACTOR-TEXT                                              
MFA-TR*            ,:S-FACTOR                                                   
MFA-TR*            ,:S-DURATION-NO                                              
MFA-TR*            ,:S-RT-ATTR-INCTV-TYPE                                       
MFA-TR*            ,:S-SORT-ORDER                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE-1.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                          TO CTR-ROWS-RS1           
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8010'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04596_R1'              TO TABLE-1                
              MOVE SPACES                     TO TABLE-ELEMENT-1        
              MOVE SPACES                     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
P680PN******************************************************************        
P680PN* 8020-INSERT-GTT-R2.                                            *        
P680PN******************************************************************        
P680PN 8020-INSERT-GTT-R2.                                              
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN          INSERT INTO #CSR04596_R2                         
P680PN          (                                                       
P680PN              RETURN_CODE                                         
P680PN             ,APPL_RETURN_CODE                                    
P680PN             ,PRCE_NEGOTIATED_CD                                  
P00805             ,CSC_DISCOUNT_CODE                                   
P680PN          )                                                       
P680PN          VALUES                                                  
P680PN          (                                                       
P680PN              :S-RETURN-CODE-2                                    
P680PN             ,:S-APPL-RETURN-CODE-2                               
P680PN             ,:S-PRCE-NEGOTIATED-CD                               
P00805             ,:S-CSC-DISCOUNT-CODE                                
P680PN          )                                                       
P680PN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04596_R2                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,PRCE_NEGOTIATED_CD                                          
MFA-TR*            ,CSC_DISCOUNT_CODE                                           
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-APPL-RETURN-CODE-2                                       
MFA-TR*            ,:S-PRCE-NEGOTIATED-CD                                       
MFA-TR*            ,:S-CSC-DISCOUNT-CODE                                        
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680PN                                                                  
P680PN     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P680PN                                           S-RETURN-CODE-2.       
P680PN                                                                  
P680PN     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P680PN        ADD +1                          TO CTR-ROWS-RS2           
P680PN     ELSE                                                         
P680PN        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P680PN        MOVE '8020'                     TO ACTIVE-PARAGRAPH       
P680PN        MOVE SQLCODE                    TO ABEND-SQLCODE          
P680PN        MOVE 'INSERT'                   TO ABEND-FUNCTION         
P680PN        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P680PN                                           ABEND-TABLES           
P680PN        MOVE 'CSR04596_R2'              TO TABLE-1                
P680PN        MOVE SPACES                     TO TABLE-ELEMENT-1        
P680PN        MOVE SPACES                     TO HOSTVAR-ELEMENT-1      
P680PN        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P680PN        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN 8020-EXIT.                                                       
P680PN     EXIT.                                                        
P680PN                                                                  
P680PN*****************************************************************         
P680PN*                                                               *         
P680PN* 8800-CHECK-RESULTS.                                           *         
P680PN*****************************************************************         
P680PN 8800-CHECK-RESULTS.                                              
P680PN                                                                  
P680PN     IF CTR-ROWS-RS1 <= 0                                         
P680PN        INITIALIZE GTT-RETURN-FIELDS-1                            
P680PN        MOVE   0                       TO S-RETURN-CODE-1         
P680PN        MOVE 100                       TO S-APPL-RETURN-CODE-1    
P680PN        PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN     IF CTR-ROWS-RS2 <= 0                                         
P680PN        INITIALIZE GTT-RETURN-FIELDS-2                            
P680PN        MOVE   0                       TO S-RETURN-CODE-2         
P680PN        MOVE 100                       TO S-APPL-RETURN-CODE-2    
P680PN        PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT          
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN 8800-EXIT.                                                       
P680PN     EXIT.                                                        
P680PN                                                                  
P680PN******************************************************************        
P680PN*                                                                *        
P680PN* 8900-SEND-DONE.                                                *        
P680PN******************************************************************        
P680PN 8900-SEND-DONE.                                                  
P680PN                                                                  
P680PN     MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
P680PN     MOVE '8900'                TO ACTIVE-PARAGRAPH               
P680PN     MOVE 'OPEN'                TO ABEND-FUNCTION                 
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN         OPEN C1                                                  
P680PN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P680PN                                                                  
P680PN     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P680PN                                      S-RETURN-CODE-1.            
P680PN                                                                  
P680PN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P680PN        CONTINUE                                                  
P680PN     ELSE                                                         
P680PN        MOVE SQLCODE               TO ABEND-SQLCODE               
P680PN        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P680PN        MOVE 'CSR04596_R1'         TO TABLE-1                     
P680PN        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P680PN        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN         OPEN C2                                                  
P680PN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P680PN                                                                  
P680PN     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P680PN                                      S-RETURN-CODE-2.            
P680PN                                                                  
P680PN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P680PN        CONTINUE                                                  
P680PN     ELSE                                                         
P680PN        MOVE SQLCODE               TO ABEND-SQLCODE               
P680PN        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P680PN        MOVE 'CSR04596_R2'         TO TABLE-1                     
P680PN        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P680PN        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN                                                                  
P680PN 8900-EXIT.                                                       
P680PN     EXIT.                                                        
P680PN                                                                  
P680PN******************************************************************        
P680PN*                                                                *        
P680PN* 9000-SEND-ERROR-RESULT                                         *        
P680PN******************************************************************        
P680PN 9000-SEND-ERROR-RESULT.                                          
P680PN                                                                  
P680PN     INITIALIZE GTT-RETURN-FIELDS.                                
P680PN     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
P680PN                                         S-RETURN-CODE-1          
P680PN                                         S-RETURN-CODE-2.         
P680PN                                                                  
P680PN     MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
P680PN                                         S-APPL-RETURN-CODE-2.    
P680PN                                                                  
P680PN                                                                  
P680PN     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
P680PN                                                                  
P680PN     EXEC SQL                                                     
P680PN         ROLLBACK                                                 
P680PN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P680PN                                                                  
P680PN     IF SQLCODE = 0                                               
P680PN        CONTINUE                                                  
P680PN     ELSE                                                         
P680PN        MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
P680PN     END-IF.                                                      
P680PN                                                                  
P680PN     PERFORM 0100A-INSERT-GTT-R1         THRU 0100A-EXIT.         
P680PN     PERFORM 0100B-INSERT-GTT-R2         THRU 0100B-EXIT.         
P680PN                                                                  
P680PN     PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
P680PN     PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
P680PN                                                                  
P680PN 9000-EXIT.                                                       
P680PN     EXIT.                                                        
P680PN                                                                  
P680PN******************************************************************        
P680PN* 9900-SQL-ERROR-ROUTINE.                                        *        
P680PN******************************************************************        
P680PN     EXEC SQL                                                             
P680PN        INCLUDE CPDSP300                                                  
P680PN     END-EXEC.                                                            
P680PN                                                                  
P680PN******************************************************************        
P680PN* 9999-END-PROGRAM.                                              *        
P680PN******************************************************************        
P680PN                                                                  
P680PN 9999-END-PROGRAM.                                                
P680PN                                                                  
P680PN     PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
P680PN     PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
P680PN                                                                  
P680PN     
MSQ016        GOBACK.                                                    
P680PN                                                                  
P680PN 9999-EXIT.                                                       
P680PN     EXIT.                                                        
P680PN                                                                  
