       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04595.                                          
COB303 DATE-WRITTEN. DEC 17,2012                                        
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DOES THE FOLLOWING:                              *        
      *  1. TRANSFER A/R, CREDIT INFORMATION, ETC.                     *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      * 12/17/2012   RB19957  ORIGINAL CODE WAS DERIVIDED FROM CSR02045*        
      *                       AND CSR02367.                            *        
A04527* 10/21/2013   RB19957  ADDED CODE TO CHECK WRITEOFF ACCOUNTS TO *        
A04527*                       CHECK IF THE RECEIVABLE BEING TRANSFERRED*        
A04527*                       IS A CHARGEOFF RECEIVABLE.               *        
ACT047*  2/18/2014   RB19957  A CHRGOFF INDICATOR WAS ADDED TO EACH    *        
ACT047*                       OF THE 20 INPUT RECEIVABLE PARMS THAT    *        
ACT047*                       IS POPULATED BY THE UI.  THIS LOGIC      *        
ACT047*                       EXISTS IN CPD00025 AND SO WAS USED HERE  *        
ACT047*                       BECAUSE IT WORKS.  THE CHRGOFF INDICATOR *        
ACT047*                       IS USED TO TELL THE TRANSFER PROCESS     *        
ACT047*                       WHICH TABLE TO TRANSFER THE RECEIVABLE   *        
ACT047*                       FROM - CSS_CHRG_OFF OR CSS_AR_CNTL.      *        
ACT257*  9/16/2014  RB19957   1) ADD A NEW INPUT PARM TO INDICATE HOW  *        
ACT257*        APPL00004880      MANY INSTALLMENTS FOR A DFA.          *        
ACT257*                       2) MAKE CHANGES TO MNT COMMENTS WHEN NO  *        
ACT257*                          RECEIVABLES WITH SET/UNSET TRANSFER   *        
ACT257*                          FORWARD FLAG INCLUDING ARCHIVE        *        
ACT257*                          ACCOUNTS PERIOD.                      *        
ACT082*  9/16/2015  SS7F226   1) REMOVE WQ RELATED LOGIC.              *        
ACT082*        APPL00004860   2) REMOVE UNUSED PARAGRAPHS.             *        
P01137*  3/15/2017  VENKAT.P  INITIALIZE INDEX FOR OPTIMIZATION        *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      ** THE DELIMITER IS $$  ******************************************        
      ******************************************************************        
      *                ---- DATA FIELD VALUE MEANINGS ----             *        
      *                                                                *        
      *  PARM-SELECT-RECX    (X = 1 TO 20)                             *        
      *   TRC-TYPE: (ONLY SUMMARY IN AR_CNTL I.E. ITEM_ID = 0)         *        
      *    NSC = PPL = 19     RETURN CHECK CHARGE - NON UTILITY        *        
      *    NSA = PPL = 20     RETURN CHECK AMOUNT - UTILITY            *        
      *    NSN = PPL = 29     RETURN CHECK AMOUNT - NON UTILITY        *        
      *    LPC = PPL = 30     LATE PAYMENT CHARGE - UTILITY            *        
      *    LPN = PPL = 39     LATE PAYMENT CHARGE - NON-UTILITY        *        
      *    UTE = PPL = 40     UTILITY - ELECTRIC                       *        
      *    UTG = PPL = 45     UTILITY - GAS                            *        
      *                                                                *        
      *   TRD-TYPE(>49): (SUMMARY&DETAILS IN AR_CNTL W ITEM_ID = 0+)   *        
      *    BUD = PPL = 50     EASY PAYMENT PLAN                        *        
      *    RCC = PPL = 60     RECONNECT CHARGE                         *        
      *    CIA = PPL = 70     CREDIT IN ADVANCE                        *        
      *    DEP = PPL = 80     DEPOSIT                                  *        
      *    DFA = PPL = 90     DEFERRED AGREEMENT                       *        
      *    DPP = PPL = 90     DEFERRED PAYMENT PLAN                    *        
      *    CNT = PPL = 100    CONTRACT                                 *        
      *    PJS = PPL = 129    PROJECT SHARE                            *        
      *                                                                *        
      *  PARM-TRANSFER-TYPEX (X = 1 TO 20)                             *        
      *    L = (DEFERRED/DFA)                                          *        
      *    A = ORIGINAL                                                *        
      *    U = UNBILLED                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04595'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04595 STARTS HERE'.                  
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *      WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT ON TABLE    *        
      *      CSS_ACCOUNT                                               *        
      ******************************************************************        
           COPY CWS00056.                                                       
      *                                                                         
      *****************************************************************         
      ** THIS COPYBOOK IS FOR LINKAGE SECTION VARIABLES FOR SCSCO068.**         
      *****************************************************************         
           COPY CWS0068L.                                                       
      *                                                                         
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
      *****************************************************************         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      * THIS COPYBOOK IS USED IN THE ONLINE AND BATCH VERSIONS OF     *         
      * SCSCA225. THIS COPYBOOK IS GENERIC TO BATCH AND ONLINE AND    *         
      * IT HAS TO BE TAILORED USING THE COPY REPLACING STATEMENT.     *         
      *****************************************************************         
           COPY CWSCA225.                                                       
      *                                                                         
      *****************************************************************         
      **     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  *         
      **     PORTION OF THE BATCH AND CASH JOURNAL DETAIL             *         
      **     USED FOR ACCOUNTS RECEIVABLE POSTING                     *         
      *****************************************************************         
           COPY CJF00101.                                                       
      *                                                                         
      *****************************************************************         
      **     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  *         
      **     PORTION OF THE CASH AND BATCH JOURNAL DETAIL             *         
      **     USED FOR ACCOUNTS RECEIVABLE POSTING                     *         
      *****************************************************************         
           COPY CJF00102.                                                       
      *                                                                         
      *****************************************************************         
      **     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  *         
      **     PORTION OF THE BATCH AND CASH JOURNAL DETAIL             *         
      **     USED FOR ACCOUNTS RECEIVABLE POSTING                     *         
      *****************************************************************         
           COPY CJF00103.                                                       
      *                                                                         
      *****************************************************************         
      **     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  *         
      **     PORTION OF THE MISCELLANEOUS JOURNALS USED FOR           *         
      **     ACCOUNTS RECEIVABLE MAINTENANCE                          *         
      *****************************************************************         
           COPY CJF00113.                                                       
      *                                                                         
      *****************************************************************         
      **     THIS COPY STATEMENT IS FOR STORED PROCEDURE ERROR        *         
      **     PROCESSING.                                              *         
      *****************************************************************         
           COPY CWSSP001.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  WS-BILL-HEADER-FOUND        PIC X(1).                    
           05  REFORMAT-DATE.                                           
               10  WS-FORMAT-YEAR      PIC X(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-MONTH     PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-DAY       PIC X(02).                       
           05  USA-DATE-FORMAT.                                         
               10  USA-MONTH           PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-DAY             PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-YEAR            PIC X(04).                       
           05  WS-CNT-XFER-MESSAGE         PIC X(210) VALUE SPACES.     
           05  WS-CNT-XFER-COMMENTS        PIC X(50)  VALUE SPACES.     
           05  WS-CT-CNT-COMMENTS          PIC X(42)  VALUE SPACES.     
           05  WS-CNT-COMMENTS-TEMP        PIC X(42)  VALUE             
              'CONTRACT CREATED BY BATCH PROGRAM PCSBW160'.             
           05  WS-CNT-ITEM-ID              PIC 9(09)  VALUE 0.          
           05  WS-FROM-ACCOUNT-NO          PIC  X(13).                  
           05  WS-FROM-ACCOUNT-NO-NUM  REDEFINES WS-FROM-ACCOUNT-NO     
                                       PIC  9(13).                      
COB305     05 WS-FROM-ACCOUNT-COMP3        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-XFER-TO-ACCOUNT          PIC  9(13).                  
           05  WS-TO-ACCOUNT-NO            PIC  X(13).                  
           05  WS-TO-ACCOUNT-NO-NUM    REDEFINES WS-TO-ACCOUNT-NO       
                                       PIC  9(13).                      
COB305     05 WS-TO-ACCOUNT-COMP3        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-ACCOUNT-NO               PIC  X(13).                  
           05  WS-ACCOUNT-NO-NUM       REDEFINES WS-ACCOUNT-NO          
                                       PIC  9(13).                      
COB305     05 WS-ACCOUNT-COMP3        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-FR-ACCT-XFER-TO          PIC  9(13).                  
           05  WS-FR-ACCT-XFER-FROM-LST    PIC  9(13).                  
           05  WS-FR-AR-XFER-IND           PIC  X(1).                   
           05  WS-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.      
           05  WS-AMT-CONTRACT             PIC  X(12).                  
           05  WS-AMT-CONTRACT-NUM REDEFINES WS-AMT-CONTRACT            
                                       PIC  999999999.99.               
COB305     05 WS-AMT-CONTRACT-COMP3        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305     05 WS-UPD-AMT-ORIG-ENTERED        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.        
COB305     05 WS-4595-AMT-ORIG-ENTERED        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.        
           05  WS-TRAN-APPL-NO             PIC S9(4) COMP.              
           05  WS-MH-TRAN-APPL-NO          PIC S9(4) COMP.              
           05  WS-MH-TRAN-APPL-NO-TO       PIC S9(4) COMP.              
           05  WS-MH-TRAN-APPL-NO-FROM     PIC S9(4) COMP.              
           05  WS-TRANS-HIST-SEQ-NO-TO     PIC X(26).                   
           05  WS-TRANS-HIST-SEQ-NO-FROM   PIC X(26).                   
COB305     05 WS-REMAINING-AMT        PIC S9(11)V99 COMP-3 VALUE 0.        
           05  WS-FROM-ARREARS-HIST        PIC X(24).                   
           05  WS-FROM-DISC-EXCEPTN-HIST   PIC X(24).                   
           05  WS-FROM-DISCONNECT-HIST     PIC X(24).                   
           05  WS-FROM-NON-UTL-ARRER-HIST  PIC X(24).                   
           05  WS-FROM-NON-UTL-CR-HST-EX   PIC X(24).                   
           05  WS-FROM-NON-UTL-CR-HST      PIC X(24).                   
           05  WS-TO-ARREARS-HIST          PIC X(24).                   
           05  WS-TO-DISC-EXCEPTN-HIST     PIC X(24).                   
           05  WS-TO-DISCONNECT-HIST       PIC X(24).                   
           05  WS-TO-NON-UTL-ARRER-HIST    PIC X(24).                   
           05  WS-TO-NON-UTL-CR-HST-EX     PIC X(24).                   
           05  WS-TO-NON-UTL-CR-HST        PIC X(24).                   
           05  WS-RESULT-ARREARS-HIST      PIC X(24).                   
           05  WS-RESULT-DISC-EXCEPTN-HIST PIC X(24).                   
           05  WS-RESULT-DISCONNECT-HIST   PIC X(24).                   
           05  WS-RESULT-NON-UTL-ARRER-HIST PIC X(24).                  
           05  WS-RESULT-NON-UTL-CR-HST-EX PIC X(24).                   
           05  WS-RESULT-NON-UTL-CR-HST    PIC X(24).                   
           05  WS-FROM-START-BILL.                                      
               10 WS-FROM-START-YEAR       PIC X(4).                    
               10 FILLER                   PIC X(1).                    
               10 WS-FROM-START-MONTH      PIC X(2).                    
               10 FILLER                   PIC X(3).                    
           05  WS-TO-START-BILL.                                        
               10 WS-TO-START-YEAR         PIC X(4).                    
               10 FILLER                   PIC X(1).                    
               10 WS-TO-START-MONTH        PIC X(2).                    
               10 FILLER                   PIC X(3).                    
           05  WS-FROM-SMONTH-NUM          PIC 9(2).                    
           05  WS-FROM-SYEAR-NUM           PIC 9(4).                    
           05  WS-TO-SMONTH-NUM            PIC 9(2).                    
           05  WS-TO-SYEAR-NUM             PIC 9(4).                    
           05  WS-HOLD-SMONTH-NUM          PIC 9(2).                    
           05  WS-HOLD-SYEAR-NUM           PIC 9(4).                    
           05  WS-TO-SUB                   PIC 9(2).                    
           05  WS-FROM-SUB                 PIC 9(2).                    
           05  WS-FROM-SUB2                PIC 9(2).                    
           05  WS-RESULT-SUB               PIC 9(2).                    
           05  WS-DONE-FLAG                PIC X(1) VALUE 'N'.          
           05  WS-OUT-OF-FROM-BUCKETS      PIC X(1) VALUE 'N'.          
           05  WS-OUT-OF-TO-BUCKETS        PIC X(1) VALUE 'N'.          
           05  WS-DATE-ORIG-PYMT-IND       PIC S9(04) COMP VALUE +0.    
           05  WS-COMPANY-IN-TABLE         PIC  X(01) VALUE SPACES.     
           05  WS-CASH-DRAWER.                                          
               10  WS-COMPANY           PIC  X(02) VALUE SPACES.        
               10  WS-LOC-OFF           PIC  X(03) VALUE SPACES.        
               10  WS-REPORT-NO         PIC  X(03) VALUE SPACES.        
               10  WS-REPORT-DT         PIC  X(10) VALUE SPACES.        
               10  WS-CASH-DRAWER-ID    PIC  S9(04) COMP VALUE 0.       
           05 WS-CURRENT-DATE              PIC  X(10) VALUE SPACES.     
           05 WS-SAVE-SEL-REC-COUNT        PIC S9(04) COMP VALUE +0.    
COB305     05 WS-SAVE-SEL-REC-AMOUNT        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.        
           05 WS-SAVE-DFA-REC-COUNT        PIC S9(04) COMP VALUE +0.    
           05 WS-SUB                       PIC S9(04) COMP VALUE +0.    
           05 WS-SEL-TRANSFER-TABLE.                                    
              10  WS-SEL-TRANSFER-TAB OCCURS 20 TIMES.                  
                  15  WS-SEL-XFER-REC      PIC  X(03).                  
                  15  WS-SEL-XFER-ITEM-ID  PIC S9(09) COMP.             
COB305            15 WS-SEL-XFER-AMT        PIC S9(09)V99 COMP-3 
COB305              VALUE 0.        
COB305            15 WS-SEL-XFER-AMT-DEF        PIC S9(09)V99 COMP-3 
COB305              VALUE 0.        
ACT047            15  WS-SEL-XFER-CHGOFF   PIC  X(01).                  
           05 WS-TO-AT-BILL-CYCLE          PIC X(02) VALUE SPACES.      
           05 WS-FROM-REV-YEAR             PIC 9(04) VALUE 0.           
           05 WS-TO-REV-YEAR               PIC 9(04) VALUE 0.           
           05 WS-FROM-REV-MONTH            PIC 9(02) VALUE 0.           
           05 WS-TO-REV-MONTH              PIC 9(02) VALUE 0.           
COB305     05 WS-REVMTH        PIC S9(6)V USAGE COMP-3 VALUE 0.     
COB305     05 WS-BG-REV-FROM-MTH        PIC S9(6)V USAGE COMP-3 VALUE 0.     
           05 WS-PARM-DATE-COG             PIC X(10) VALUE SPACES.      
           05 WS-DNP-UPDATE-FL             PIC X(01) VALUE 'N'.         
           05 WS-CPD68-DNP-BAL             PIC S9(9)V99 COMP-3 VALUE 0. 
           05 RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.    
           05 WS-CURRENT-TASK              PIC X(3).                    
           05 WS-WAIVER-INSERTED           PIC X(01) VALUE 'N'.         
           05 WS-CANCELDNP-FROM-ACCT       PIC X(01) VALUE SPACES.      
           05 WS-CANCELDNP-TO-ACCT         PIC X(01) VALUE SPACES.      
           05 WS-UPDATE-PROFILE            PIC X(01) VALUE SPACE.       
           05 WS-4595-TRAN-COMMENT         PIC X(400) VALUE SPACES.     
           05 WS-4595-TRAN-COMMENT-LEN     PIC S9(4) USAGE COMP.        
           05 WS-TEMP-TRANSFER-STYLE       PIC X(01) VALUE SPACE.       
ACT257     05 WS-DISPLAY-NO-INSTALLS       PIC 9(01).                   
      *                                                                         
       01  NULL-INDICATOR-FIELDS.                                       
           05 WS-DATE-BOND-ISSUED-NI       PIC S9(4) COMP VALUE 0.      
           05 WS-TRIGGER-DATE-NI           PIC S9(4) COMP VALUE 0.      
           05 WS-BOND-EXPIRATION-DT-NI     PIC S9(4) COMP VALUE 0.      
           05 WS-NULL-IND1                 PIC S9(04) COMP VALUE 0.     
           05 WS-NULL-IND2                 PIC S9(04) COMP VALUE 0.     
           05 WS-NULL-IND3                 PIC S9(04) COMP VALUE 0.     
           05 WS-NULL-IND4                 PIC S9(04) COMP VALUE 0.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88 CSR-DATABASE                    VALUE 1.              
               88 SEB-DATABASE                    VALUE 2.              
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-AR-TRANSFER-TO        PIC X(01) VALUE 'N'.            
           05  WS-AR-TRANSFER-FROM      PIC X(01) VALUE 'N'.            
           05  WS-JUST-DFA              PIC X(01) VALUE 'N'.            
           05  WS-JUST-FROM-DFA         PIC X(01) VALUE 'Y'.            
      *                                                                         
       01  WS-LITERAL.                                                  
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04595'.     
           05  EIBTRNID                 PIC X(04) VALUE 'S045'.         
           05  MCSCO061                 PIC X(08) VALUE 'MCSCO061'.     
           05  MCSCB225                 PIC X(08) VALUE 'MCSCB225'.     
           05  MCSCB371                 PIC X(08) VALUE 'MCSCB371'.     
           05  MCSCA182                 PIC X(08) VALUE 'MCSCA182'.     
           05  WS-MCSCB068              PIC X(08) VALUE 'MCSCB068'.     
           05  WS-DELIMITER             PIC X(02) VALUE '$$'.           
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-F                     PIC X(01) VALUE 'F'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                 PIC X(26)                       
                                            VALUE 'SESSION.CSR04595_R1'.
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN           PIC S9(04) COMP.                
               49 GTT-ROW-CHAR          PIC X(1024).                    
           05  GTT-SQLCODE              PIC S9(9) COMP.                 
      *                                                                         
      * CSR00125 INPUT AREA                                                     
       01  WS-CSR00125-PARM-AREA.                                       
           05  PARM-ACCOUNT-NO               PIC X(13) VALUE SPACES.    
           05  PARM-SO-PREMISE-NO            PIC X(10) VALUE SPACES.    
           05  WS-USER-ID-C125               PIC X(07) VALUE SPACES.    
           05 WS-REMARKS-TX.                                            
              49 WS-REMARKS-TX-LEN            PIC S9(4) USAGE COMP.     
              49 WS-REMARKS-TX-TEXT           PIC X(210).               
           05  PARM-SO-UPDATE-REMARKS        PIC X(01) VALUE 'Y'.       
           05  WS-UPDATE                     PIC X(01) VALUE 'U'.       
           05  WS-PANEL-NO                   PIC X(03) VALUE '069'.     
           05  PARM-SO-ORDER-TYPE-FLAG       PIC X(01) VALUE 'A'.       
           05  PARM-SO-DNP-CANCEL-REASON     PIC X(01) VALUE 'R'.       
      * CSR00125 OUTPUT AREA                                                    
       01  WS-CSR00125-RET-AREA.                                        
           05  WS-SO-RETURN-CD-BD            PIC S9(04) COMP VALUE 0.   
           05  WS-SERV-ORDER-CHAR-BD         PIC X(13) VALUE SPACES.    
           05  WS-ORDER-REASON-BD            PIC X(01) VALUE SPACES.    
           05  WS-RESP-AREA-ID-BD            PIC X(03) VALUE SPACES.    
           05  WS-PENDING-DNP-FLAG-BD        PIC X(01) VALUE SPACES.    
           05  WS-INSERT-WORK-QUEUE-BD       PIC X(01) VALUE SPACES.    
           05  WS-AMOUNT-DISC-BAL            PIC X(12) VALUE SPACES.    
           05  WS-ORDER-TYPE-CD-BD           PIC X(05) VALUE SPACES.    
      *                                                                         
       01  WS-CSR02122-RET-AREA.                                        
           05  WS-2122-RETURN-CODE           PIC S9(04) COMP VALUE 0.   
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-STYLE-DESC           PIC X(18).                       
      *                                                                         
       01 WORK-FIELD2.                                                  
COB305    05 WS-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.           
          05 WS-REVENUE-MONTH-X      PIC X(06) VALUE SPACES.            
          05 WS-REV-MONTH-YR.                                           
             10 WS-REV-YEAR          PIC  9(04) VALUE 0.                
             10 WS-REV-MONTH         PIC  9(02) VALUE 0.                
      *                                                                         
       01  WS-CREDIT-HIST.                                              
           05 WS-FROM-HIST-TAB.                                         
              10 WS-FROM-HIST    PIC X(1) OCCURS 24 TIMES.              
           05 WS-TO-HIST-TAB.                                           
              10 WS-TO-HIST      PIC X(1) OCCURS 24 TIMES.              
           05 WS-RESULT-HIST-TAB.                                       
              10 WS-RESULT-HIST  PIC X(1) OCCURS 24 TIMES.              
      *                                                                         
       01  WS-TO-ACCT-BUCKETS-CHECK.                                    
           05 WS-TO-ACCT-BEFORE.                                        
COB305        10 WS-TO-ACCT-BEFORE-00        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-BEFORE-30        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-BEFORE-60        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-BEFORE-90        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
           05 WS-TO-ACCT-AFTER.                                         
COB305        10 WS-TO-ACCT-AFTER-00        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-AFTER-30        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-AFTER-60        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
COB305        10 WS-TO-ACCT-AFTER-90        PIC S999999999V99 
COB305           USAGE COMP-3 VALUE 0.
           05 WS-TO-ACCT-BUCKET-DATES.                                  
              10  WS-TO-ACCT-DATE-00     PIC X(10) VALUE SPACES.        
              10  WS-TO-ACCT-DATE-30     PIC X(10) VALUE SPACES.        
              10  WS-TO-ACCT-DATE-60     PIC X(10) VALUE SPACES.        
              10  WS-TO-ACCT-DATE-90     PIC X(10) VALUE SPACES.        
              10  WS-FROM-ACCT-DATE-00   PIC X(10) VALUE SPACES.        
              10  WS-FROM-ACCT-DATE-30   PIC X(10) VALUE SPACES.        
              10  WS-FROM-ACCT-DATE-60   PIC X(10) VALUE SPACES.        
              10  WS-FROM-ACCT-DATE-90   PIC X(10) VALUE SPACES.        
              10  WS-45-NULL-IND-00      PIC S9(04) COMP VALUE 0.       
              10  WS-45-NULL-IND-30      PIC S9(04) COMP VALUE 0.       
              10  WS-45-NULL-IND-60      PIC S9(04) COMP VALUE 0.       
              10  WS-45-NULL-IND-90      PIC S9(04) COMP VALUE 0.       
      *                                                                         
      * OLD LINKAGE PARMS.                                                      
       01  OLD-LINKAGE-PARMS.                                           
          05  PARM-TRANSFER-TYPE       PIC  X(3).                       
          05  PARM-TRANSFER-STYLE      PIC  X(1).                       
          05  PARM-SET-TRANSFER-FLAG   PIC  X(1).                       
          05  PARM-TRAN-COMMENT-LEN    PIC S9(4) COMP.                  
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
           05  S-BUS-RULE-ID            PIC X(10) VALUE SPACE.          
           05  S-BUS-RULE-RESULT-CD     PIC X(08) VALUE SPACE.          
           05  S-BUS-RULE-XREF-ID       PIC X(26) VALUE SPACE.          
      *                                                                 02280000
      *01  LOC2                        USAGE IS SQL TYPE IS             
      *                                RESULT-SET-LOCATOR VARYING.      
      *                                                                 02310000
      ******************************************************************        
      *    DB2 WORKING STORAGE COPY BOOKS                              *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *  CWSX0010            WS ABEND WORK AREA                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS0013B      C O M M O N    J O U R N A L    A R E A         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CWS04595    TRANSFER A/R AND JOURNALS WORK AREA               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS04595                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS0061L-COPYBOOK IS FOR LINKAGE SECTION VARIABLES FOR SCSCO061*        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS0061L                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00061-WORKING STORAGE VARIABLES FOR GENERAL LEDGER MNEMONICS*        
      *     AND NUMBERS USED IN CONJUNCTION WITH CPD00061 AND CPD00062.*        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00068-COPYBOOK IS FOR WORKING STORAGE VARIABLES FOR SCSCO068*        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00068                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CWS00078   WORKING STORAGE FOR TRANSFERS RECEIVABLES AS A DFA  *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00078                                                  
           END-EXEC.                                                            
      *                                                                         
      *************************************************************             
      * WORKING STORAGE FOR SCSCA182                                            
      *************************************************************             
       COPY CWS00182.                                                           
      *                                                                         
      ******************************************************************        
      **      WORKING STORAGE AREA USED IN CONJUNCTION WITH CPD00309  **        
      **   FOR NEXT BILLING DATE CALCULATION.                         **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00309                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  SQLCA  DB2 ERROR HANDLING                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  AT   CSS_ACCOUNT                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  AC   CSS_AR_CNTL                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  AU   CSS_AR_TRN_HST_DET                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  AR   CSS_AR_TRANS_HIST                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  AL   CSS_AR_LOCKOUT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BU   CSS_BUDGET_PLAN                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBGTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BN   CSS_BILL_WINDOW                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BC   CSS_BCH_JRNL_CNTL                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BG   CSS_BILLING_DET                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BI   CSS_BILLING_HDR                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  BJ   CSS_BATCH_JRNL                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  1R   CSS_BUS_RULE                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  1T   CSS_BUS_RULE_XREF                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CC   CSS_CONNECT_CHRG                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CS   CSS_CSH_DRWR_CNTL                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CJ   CSS_CSH_DRWR_JRNL                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CO   CSS_CHRG_OFF                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  EA   CSS_CNT_DETAIL                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTDET                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CT   CSS_CONTRACT                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CZ   CSS_CREDIT_PROFILE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CU   CSS_CUSTOMER                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  C8   CSS_DELINQUENCY                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DO   CSS_DEP_ON_HAND                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DP   CSS_DEP_PAY_HST                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDEPHST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DR   CSS_DEP_REQ                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DA   CSS_DFA_ACCT                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DV   CSS_DFA_RECVBLE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDFARCV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CO   CSS_GL_ACCT_NO                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  IH   CSS_INTEREST_HIST                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINTHST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  G6   CSS_JOB_PARM                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  B1   CSS_LOCAL_OFFICE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  MH   CSS_MNT_TRANS_HIST                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  MI   CSS_MT_TRN_HST_DET                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  MJ   CSS_MISC_JRNL                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  PR   CSS_PREMISE                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  PJ   CSS_PROJ_SHARE                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRJSHR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  U7   CSS_RECONNECT_CHRG                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRCNCHR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  DL   CSS_RECONNECT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  RN   CSS_REFUND                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREFUND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  XK   CSS_SO_DNP_CANCEL                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODNPC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  SB   CSS_SURETY_BOND                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  PF   CSS_USER_PROFILE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *********************************************************                 
      ******************************************************************05152000
      *    DB2 CURSOR DECLARATIONS                                     *05153000
      ******************************************************************05154000
                                                                        
      ****** SURETY CURSOR ******                                       05159100
            EXEC SQL                                                    
               DECLARE SURETY_CURSOR CURSOR FOR                         
                 SELECT BOND_WAIV_ITEM_ID ,                             
                        BOND_NO           ,                             
                        DATE_BOND_ISSUED  ,                             
                        TERM_OF_BOND      ,                             
                        AMT_BOND          ,                             
                        CODE_BOND_TYPE    ,                             
                        BOND_CO_NO        ,                             
                        BOND_CO_CUST_NO   ,                             
                        CODE_STATUS       ,                             
                        CODE_STATUS_REAS  ,                             
                        BOND_TOTAL_AMT    ,                             
                        TRIGGER_DATE      ,                             
                        BOND_EXPIRATION_DT,                             
                        WAIVER_TYPE_CD    ,                             
                        ADDRESS_ID        ,                             
                        USER_ID_ORIG_BY   ,                             
                        WAIVER_SOURCE_DESC,                             
                        COMMENTS                                        
                   FROM CSS_SURETY_BOND                                 
                  WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                     
                    AND CODE_BOND_TYPE = 'C'                            
                    AND CODE_STATUS IN ('A','P')                        
                    AND WAIVER_TYPE_CD NOT IN ('G','H')                 
            END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_DNP CURSOR
MSQ001          FOR CALL CSR00125                                       
                       ( :PARM-ACCOUNT-NO
                  , :PARM-SO-PREMISE-NO
                  , :PARM-USER-ID
                  , :WS-REMARKS-TX
                  , :PARM-SO-UPDATE-REMARKS
                  , :WS-UPDATE
                  , :WS-PANEL-NO
                  , :PARM-SO-ORDER-TYPE-FLAG
                  , :PARM-SO-DNP-CANCEL-REASON
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE UPDATE_ACCT_TB CURSOR
MSQ001          FOR CALL CSR02122                                       
                       ( :PARM-ACCOUNT-NO
                  , :PARM-SO-PREMISE-NO
                  , :WS-ORDER-REASON-BD
                  , :PARM-SO-DNP-CANCEL-REASON
                  , :WS-PENDING-DNP-FLAG-BD
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , :WS-PANEL-NO
                  , :WS-ORDER-TYPE-CD-BD
                  , :WS-REMARKS-TX
                  )
MSQ001        END-EXEC.
                                                   
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-TO-ACCOUNT-NO       PIC  X(13).                         
       01  PARM-USER-ID             PIC  X(7).                          
       01  PARM-RESP-AREA-ID        PIC  X(3).                          
       01  PARM-TO-NAME-ADDRESS     PIC  X(164).                        
       01  PARM-FROM-NAME-ADDRESS   PIC  X(164).                        
       01  PARM-TRAN-COMMENT        PIC  X(210).                        
       01  PARM-AR-TRAN-COMMENT     PIC  X(210).                        
       01  PARM-UTL-CRED-HIST       PIC X(1).                           
       01  PARM-NON-UTL-CRED-HIST   PIC X(1).                           
       01  PARM-SET-TRANSFER-FORWARD-FLAG PIC X(1).                     
       01  PARM-PAID-DEPOSIT-TRANSFER PIC X(1).                         
       01  PARM-DEPOSIT-WAIVER      PIC  X(1).                          
       01  PARM-FROM-ACCT-ARCHIVED  PIC  X(1).                          
       01  PARM-TO-ACCT-ARCHIVED    PIC  X(1).                          
       01  PARM-FROM-ACCOUNT-NO     PIC  X(13).                         
       01  PARM-LAST-UPDATE-TS      PIC  X(26).                         
ACT257 01  PARM-DFA-NO-INSTALLS     PIC S9(09) COMP.                    
       01  PARM-SELECT-REC1         PIC  X(3).                          
       01  PARM-ITEM-ID1            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT1       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE1      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND1       PIC  X(01).                         
       01  PARM-SELECT-REC2         PIC  X(3).                          
       01  PARM-ITEM-ID2            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT2       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE2      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND2       PIC  X(01).                         
       01  PARM-SELECT-REC3         PIC  X(3).                          
       01  PARM-ITEM-ID3            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT3       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE3      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND3       PIC  X(01).                         
       01  PARM-SELECT-REC4         PIC  X(3).                          
       01  PARM-ITEM-ID4            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT4       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE4      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND4       PIC  X(01).                         
       01  PARM-SELECT-REC5         PIC  X(3).                          
       01  PARM-ITEM-ID5            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT5       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE5      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND5       PIC  X(01).                         
       01  PARM-SELECT-REC6         PIC  X(3).                          
       01  PARM-ITEM-ID6            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT6       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE6      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND6       PIC  X(01).                         
       01  PARM-SELECT-REC7         PIC  X(3).                          
       01  PARM-ITEM-ID7            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT7       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE7      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND7       PIC  X(01).                         
       01  PARM-SELECT-REC8         PIC  X(3).                          
       01  PARM-ITEM-ID8            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT8       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE8      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND8       PIC  X(01).                         
       01  PARM-SELECT-REC9         PIC  X(3).                          
       01  PARM-ITEM-ID9            PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT9       PIC  X(12).                         
       01  PARM-TRANSFER-TYPE9      PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND9       PIC  X(01).                         
       01  PARM-SELECT-REC10        PIC  X(3).                          
       01  PARM-ITEM-ID10           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT10      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE10     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND10      PIC  X(01).                         
       01  PARM-SELECT-REC11        PIC  X(3).                          
       01  PARM-ITEM-ID11           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT11      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE11     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND11      PIC  X(01).                         
       01  PARM-SELECT-REC12        PIC  X(3).                          
       01  PARM-ITEM-ID12           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT12      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE12     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND12      PIC  X(01).                         
       01  PARM-SELECT-REC13        PIC  X(3).                          
       01  PARM-ITEM-ID13           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT13      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE13     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND13      PIC  X(01).                         
       01  PARM-SELECT-REC14        PIC  X(3).                          
       01  PARM-ITEM-ID14           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT14      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE14     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND14      PIC  X(01).                         
       01  PARM-SELECT-REC15        PIC  X(3).                          
       01  PARM-ITEM-ID15           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT15      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE15     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND15      PIC  X(01).                         
       01  PARM-SELECT-REC16        PIC  X(3).                          
       01  PARM-ITEM-ID16           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT16      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE16     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND16      PIC  X(01).                         
       01  PARM-SELECT-REC17        PIC  X(3).                          
       01  PARM-ITEM-ID17           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT17      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE17     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND17      PIC  X(01).                         
       01  PARM-SELECT-REC18        PIC  X(3).                          
       01  PARM-ITEM-ID18           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT18      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE18     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND18      PIC  X(01).                         
       01  PARM-SELECT-REC19        PIC  X(3).                          
       01  PARM-ITEM-ID19           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT19      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE19     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND19      PIC  X(01).                         
       01  PARM-SELECT-REC20        PIC  X(3).                          
       01  PARM-ITEM-ID20           PIC S9(09) COMP.                    
       01  PARM-AMT-CONTRACT20      PIC  X(12).                         
       01  PARM-TRANSFER-TYPE20     PIC  X(1).                          
ACT047 01  PARM-CHRG-OFF-IND20      PIC  X(01).                         
      *                                                                         
       PROCEDURE DIVISION USING PARM-TO-ACCOUNT-NO                      
                                PARM-USER-ID                            
                                PARM-RESP-AREA-ID                       
                                PARM-TO-NAME-ADDRESS                    
                                PARM-FROM-NAME-ADDRESS                  
                                PARM-TRAN-COMMENT                       
                                PARM-AR-TRAN-COMMENT                    
                                PARM-UTL-CRED-HIST                      
                                PARM-NON-UTL-CRED-HIST                  
                                PARM-SET-TRANSFER-FORWARD-FLAG          
                                PARM-PAID-DEPOSIT-TRANSFER              
                                PARM-DEPOSIT-WAIVER                     
                                PARM-FROM-ACCT-ARCHIVED                 
                                PARM-TO-ACCT-ARCHIVED                   
                                PARM-FROM-ACCOUNT-NO                    
                                PARM-LAST-UPDATE-TS                     
ACT257                          PARM-DFA-NO-INSTALLS                    
                                PARM-SELECT-REC1                        
                                PARM-ITEM-ID1                           
                                PARM-AMT-CONTRACT1                      
                                PARM-TRANSFER-TYPE1                     
ACT047                          PARM-CHRG-OFF-IND1                      
                                PARM-SELECT-REC2                        
                                PARM-ITEM-ID2                           
                                PARM-AMT-CONTRACT2                      
                                PARM-TRANSFER-TYPE2                     
ACT047                          PARM-CHRG-OFF-IND2                      
                                PARM-SELECT-REC3                        
                                PARM-ITEM-ID3                           
                                PARM-AMT-CONTRACT3                      
                                PARM-TRANSFER-TYPE3                     
ACT047                          PARM-CHRG-OFF-IND3                      
                                PARM-SELECT-REC4                        
                                PARM-ITEM-ID4                           
                                PARM-AMT-CONTRACT4                      
                                PARM-TRANSFER-TYPE4                     
ACT047                          PARM-CHRG-OFF-IND4                      
                                PARM-SELECT-REC5                        
                                PARM-ITEM-ID5                           
                                PARM-AMT-CONTRACT5                      
                                PARM-TRANSFER-TYPE5                     
ACT047                          PARM-CHRG-OFF-IND5                      
                                PARM-SELECT-REC6                        
                                PARM-ITEM-ID6                           
                                PARM-AMT-CONTRACT6                      
                                PARM-TRANSFER-TYPE6                     
ACT047                          PARM-CHRG-OFF-IND6                      
                                PARM-SELECT-REC7                        
                                PARM-ITEM-ID7                           
                                PARM-AMT-CONTRACT7                      
                                PARM-TRANSFER-TYPE7                     
ACT047                          PARM-CHRG-OFF-IND7                      
                                PARM-SELECT-REC8                        
                                PARM-ITEM-ID8                           
                                PARM-AMT-CONTRACT8                      
                                PARM-TRANSFER-TYPE8                     
ACT047                          PARM-CHRG-OFF-IND8                      
                                PARM-SELECT-REC9                        
                                PARM-ITEM-ID9                           
                                PARM-AMT-CONTRACT9                      
                                PARM-TRANSFER-TYPE9                     
ACT047                          PARM-CHRG-OFF-IND9                      
                                PARM-SELECT-REC10                       
                                PARM-ITEM-ID10                          
                                PARM-AMT-CONTRACT10                     
                                PARM-TRANSFER-TYPE10                    
ACT047                          PARM-CHRG-OFF-IND10                     
                                PARM-SELECT-REC11                       
                                PARM-ITEM-ID11                          
                                PARM-AMT-CONTRACT11                     
                                PARM-TRANSFER-TYPE11                    
ACT047                          PARM-CHRG-OFF-IND11                     
                                PARM-SELECT-REC12                       
                                PARM-ITEM-ID12                          
                                PARM-AMT-CONTRACT12                     
                                PARM-TRANSFER-TYPE12                    
ACT047                          PARM-CHRG-OFF-IND12                     
                                PARM-SELECT-REC13                       
                                PARM-ITEM-ID13                          
                                PARM-AMT-CONTRACT13                     
                                PARM-TRANSFER-TYPE13                    
ACT047                          PARM-CHRG-OFF-IND13                     
                                PARM-SELECT-REC14                       
                                PARM-ITEM-ID14                          
                                PARM-AMT-CONTRACT14                     
                                PARM-TRANSFER-TYPE14                    
ACT047                          PARM-CHRG-OFF-IND14                     
                                PARM-SELECT-REC15                       
                                PARM-ITEM-ID15                          
                                PARM-AMT-CONTRACT15                     
                                PARM-TRANSFER-TYPE15                    
ACT047                          PARM-CHRG-OFF-IND15                     
                                PARM-SELECT-REC16                       
                                PARM-ITEM-ID16                          
                                PARM-AMT-CONTRACT16                     
                                PARM-TRANSFER-TYPE16                    
ACT047                          PARM-CHRG-OFF-IND16                     
                                PARM-SELECT-REC17                       
                                PARM-ITEM-ID17                          
                                PARM-AMT-CONTRACT17                     
                                PARM-TRANSFER-TYPE17                    
ACT047                          PARM-CHRG-OFF-IND17                     
                                PARM-SELECT-REC18                       
                                PARM-ITEM-ID18                          
                                PARM-AMT-CONTRACT18                     
                                PARM-TRANSFER-TYPE18                    
ACT047                          PARM-CHRG-OFF-IND18                     
                                PARM-SELECT-REC19                       
                                PARM-ITEM-ID19                          
                                PARM-AMT-CONTRACT19                     
                                PARM-TRANSFER-TYPE19                    
ACT047                          PARM-CHRG-OFF-IND19                     
                                PARM-SELECT-REC20                       
                                PARM-ITEM-ID20                          
                                PARM-AMT-CONTRACT20                     
                                PARM-TRANSFER-TYPE20                    
ACT047                          PARM-CHRG-OFF-IND20.                    

SCA006        SET WS-GL-SUB TO 1.
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                 :S-RETURN-CODE          AS RETURN_CODE                 
                ,:S-BUS-RULE-ID          AS BUS_RULE_ID                 
                ,:S-BUS-RULE-RESULT-CD   AS BUS_RULE_RESULT_CD          
                ,:S-BUS-RULE-XREF-ID     AS BUS_RULE_XREF_ID            
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE          AS RETURN_CODE                         
MFA-TR*         ,:S-BUS-RULE-ID          AS BUS_RULE_ID                         
MFA-TR*         ,:S-BUS-RULE-RESULT-CD   AS BUS_RULE_RESULT_CD                  
MFA-TR*         ,:S-BUS-RULE-XREF-ID     AS BUS_RULE_XREF_ID                    
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P01137     SET WS-GL-SUB      TO 1.                                     
P01137     SET WS-25-CNT-INDX TO 1.                                     
      *                                                                         
           MOVE 'DATABASE'                 TO   C8-DELINQ-CD.           
           PERFORM 7060-SELECT-DELINQUENCY THRU 7060-EXIT.              
           MOVE C8-DELINQ-VALUE            TO   WS-DATABASE.            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL.                                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. UPDATE DB2 DATA                                         *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
      ***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 5400-LINK-SCSCA182        THRU 5400-EXIT             
           MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS.           
           IF PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                        TO S-RETURN-CODE            
              MOVE 'CMN0000016'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              ADD +1 TO CTR-ROWS                                        
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 0                        TO S-RETURN-CODE            
              MOVE 'CMN0000009'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              ADD +1 TO CTR-ROWS                                        
              PERFORM 8900-SEND-DONE         THRU 8900-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 2020-PROCESS-TRANSFERS THRU 2020-EXIT.               
      *                                                                         
           IF WS-DNP-UPDATE-FL = 'Y'                                    
              PERFORM 8999-ISSUE-COMMIT  THRU 8999-EXIT                 
              PERFORM 5700-CALL-MCSCB371 THRU 5700-EXIT                 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2020-PROCESS-TRANSFERS                                        *         
      *****************************************************************         
       2020-PROCESS-TRANSFERS.                                          
           MOVE ZERO TO WS-25-TRAN-APPL-NO                              
                        WS-4595-AMT-ORIG-ENTERED                        
                        WS-SAVE-SEL-REC-COUNT                           
                        WS-SAVE-SEL-REC-AMOUNT                          
                        WS-SAVE-DFA-REC-COUNT                           
                        WS-25-AMT-ORIG-ENTERED                          
                        WS-UPD-AMT-ORIG-ENTERED                         
                        CJ-TRAN-APPL-NO.                                
      *                                                                         
           MOVE 'N' TO WS-AR-TRANSFER-TO                                
                       WS-AR-TRANSFER-FROM.                             
      *                                                                         
           IF PARM-SET-TRANSFER-FORWARD-FLAG = 'N' OR 'Y'               
              MOVE PARM-FROM-ACCOUNT-NO      TO WS-FROM-ACCOUNT-NO      
              MOVE WS-FROM-ACCOUNT-NO-NUM    TO WS-FROM-ACCOUNT-COMP3   
              MOVE WS-FROM-ACCOUNT-COMP3     TO AT-ACCOUNT-NO           
              PERFORM 7200-SELECT-ACCOUNT    THRU 7200-EXIT             
              MOVE AT-ACCT-XFER-TO           TO WS-TO-ACCOUNT-NO        
              MOVE WS-TO-ACCOUNT-NO-NUM      TO WS-TO-ACCOUNT-COMP3     
              MOVE WS-TO-ACCOUNT-COMP3       TO WS-XFER-TO-ACCOUNT      
           END-IF.                                                      
      *                                                                         
           MOVE PARM-TO-ACCOUNT-NO        TO WS-TO-ACCOUNT-NO.          
           MOVE WS-TO-ACCOUNT-NO-NUM      TO WS-TO-ACCOUNT-COMP3.       
           MOVE WS-TO-ACCOUNT-COMP3       TO WS-25-ACCT-NO-TO           
                                             AT-ACCOUNT-NO.             
           PERFORM 7200-SELECT-ACCOUNT      THRU 7200-EXIT.             
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE AT-BILL-CYCLE         TO WS-TO-AT-BILL-CYCLE.           
           IF WS-CODE-UTL EQUAL WS-A                                    
              MOVE WS-Y TO WS-25-TO-HAS-UTL                             
           END-IF.                                                      
           IF WS-CODE-BUDGET EQUAL WS-A                                 
              MOVE WS-Y TO WS-25-TO-HAS-BUD                             
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                       TO WS-CANCELDNP-FROM-ACCT     
                                             WS-CANCELDNP-TO-ACCT.      
      *                                                                         
           IF PARM-SELECT-REC1 NOT = SPACES                             
              PERFORM 7000-SELECT-TO-ACCT-DATES     THRU 7000-EXIT      
              PERFORM 7010-SELECT-TO-ACCT-BUCKETS-1 THRU 7010-EXIT      
           END-IF.                                                      
      *                                                                         
           MOVE PARM-FROM-ACCOUNT-NO      TO WS-FROM-ACCOUNT-NO.        
           MOVE WS-FROM-ACCOUNT-NO-NUM    TO WS-FROM-ACCOUNT-COMP3.     
           MOVE WS-FROM-ACCOUNT-COMP3     TO WS-25-ACCT-NO-FROM         
                                             AT-ACCOUNT-NO.             
           PERFORM 7200-SELECT-ACCOUNT    THRU 7200-EXIT.               
           MOVE AT-LOCAL-OFFICE           TO WS-25-LOCAL-OFFICE-FROM.   
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
           MOVE AT-ACCT-XFER-TO           TO WS-FR-ACCT-XFER-TO.        
           MOVE AT-ACCT-XFER-FROM-LST     TO WS-FR-ACCT-XFER-FROM-LST.  
           MOVE AT-AR-XFER-IND            TO WS-FR-AR-XFER-IND.         
           IF WS-CODE-UTL EQUAL WS-A                                    
              MOVE WS-Y                   TO WS-25-FROM-HAS-UTL         
           END-IF.                                                      
           IF WS-CODE-BUDGET EQUAL WS-A                                 
              MOVE WS-Y                   TO WS-25-FROM-HAS-BUD         
           END-IF.                                                      
           PERFORM 5000-MAINTENANCE-HISTORY THRU 5000-EXIT.             
           MOVE WS-MH-TRAN-APPL-NO         TO WS-MH-TRAN-APPL-NO-FROM.  
           MOVE MH-TRANS-HIST-SEQ-NO       TO WS-TRANS-HIST-SEQ-NO-FROM.
      *                                                                         
           MOVE WS-TO-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.            
           PERFORM 5000-MAINTENANCE-HISTORY THRU 5000-EXIT.             
           MOVE WS-MH-TRAN-APPL-NO         TO WS-MH-TRAN-APPL-NO-TO.    
           MOVE MH-TRANS-HIST-SEQ-NO       TO WS-TRANS-HIST-SEQ-NO-TO.  
           MOVE WS-FROM-ACCOUNT-COMP3      TO AT-ACCOUNT-NO.            
      *                                                                         
           IF PARM-UTL-CRED-HIST = 'Y'                                  
               MOVE 'UCH'                    TO WS-CURRENT-TASK         
               PERFORM 2800-TRANSFER-HISTORY THRU 2800-EXIT             
               MOVE WS-MH-TRAN-APPL-NO       TO WS-MH-TRAN-APPL-NO-TO   
               MOVE WS-TO-ACCOUNT-NO-NUM     TO AT-ACCOUNT-NO           
               PERFORM 7200-SELECT-ACCOUNT   THRU 7200-EXIT             
               MOVE SPACES                   TO WS-CURRENT-TASK         
           END-IF.                                                      
      *                                                                         
           IF PARM-NON-UTL-CRED-HIST = 'Y'                              
               MOVE 'NCH'                    TO WS-CURRENT-TASK         
               PERFORM 2800-TRANSFER-HISTORY THRU 2800-EXIT             
               MOVE WS-MH-TRAN-APPL-NO       TO WS-MH-TRAN-APPL-NO-TO   
               MOVE WS-TO-ACCOUNT-NO-NUM     TO AT-ACCOUNT-NO           
               PERFORM 7200-SELECT-ACCOUNT   THRU 7200-EXIT             
               MOVE SPACES                   TO WS-CURRENT-TASK         
           END-IF.                                                      
      *                                                                         
           IF PARM-SET-TRANSFER-FORWARD-FLAG = 'Y' OR 'N'               
              IF WS-XFER-TO-ACCOUNT > 0                                 
                 MOVE WS-FROM-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO           
                 PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT             
                 MOVE 'UTF' TO WS-CURRENT-TASK                          
                 PERFORM 2900-UNSET-XFER-FORWARD-FLAG THRU 2900-EXIT    
                 MOVE WS-TO-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO             
                 PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT             
                 MOVE SPACES TO WS-CURRENT-TASK                         
              END-IF                                                    
              IF PARM-SET-TRANSFER-FORWARD-FLAG = 'N'                   
                 ADD +1 TO CTR-ROWS                                     
              END-IF                                                    
              IF PARM-SET-TRANSFER-FORWARD-FLAG = 'Y'                   
                 MOVE WS-FROM-ACCOUNT-NO-NUM  TO AT-ACCOUNT-NO          
                 PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT            
                 MOVE 'STF' TO WS-CURRENT-TASK                          
                 PERFORM 2910-SET-XFER-FORWARD-FLAG THRU 2910-EXIT      
                 MOVE SPACES TO WS-CURRENT-TASK                         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 5600-LOAD-GL-NUMBERS   THRU 5600-EXIT.               
      *                                                                         
           IF PARM-DEPOSIT-WAIVER = 'Y'                                 
               MOVE 'WAV' TO WS-CURRENT-TASK                            
               PERFORM 2920-TRANSFER-DEPOSIT-WAIVER  THRU 2920-EXIT     
               MOVE WS-TO-ACCOUNT-NO-NUM             TO AT-ACCOUNT-NO   
               PERFORM 7200-SELECT-ACCOUNT           THRU 7200-EXIT     
               MOVE SPACES TO WS-CURRENT-TASK                           
           END-IF.                                                      
      *                                                                         
           IF PARM-FROM-ACCT-ARCHIVED = 'Y'                             
               MOVE 'FAR' TO WS-CURRENT-TASK                            
               PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT     
               PERFORM 2930-REMOVE-FROM-ACCT-ARCHVD  THRU 2930-EXIT     
               MOVE WS-TO-ACCOUNT-NO-NUM             TO AT-ACCOUNT-NO   
               PERFORM 7200-SELECT-ACCOUNT           THRU 7200-EXIT     
               MOVE SPACES TO WS-CURRENT-TASK                           
           END-IF.                                                      
      *                                                                         
           IF PARM-TO-ACCT-ARCHIVED = 'Y'                               
               MOVE 'TAR' TO WS-CURRENT-TASK                            
               PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT     
               PERFORM 2940-REMOVE-TO-ACCT-ARCHVD    THRU 2940-EXIT     
               MOVE WS-TO-ACCOUNT-NO-NUM             TO AT-ACCOUNT-NO   
               PERFORM 7200-SELECT-ACCOUNT           THRU 7200-EXIT     
               MOVE SPACES TO WS-CURRENT-TASK                           
           END-IF.                                                      
      *                                                                         
           IF PARM-PAID-DEPOSIT-TRANSFER = 'Y'                          
               MOVE 'N' TO WS-JUST-DFA                                  
               MOVE 'N' TO WS-JUST-FROM-DFA                             
               MOVE 'DEP' TO WS-CURRENT-TASK                            
                             PARM-TRANSFER-TYPE                         
               PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT     
               PERFORM 2750-TRANSFER-PAID-DEPOSITS   THRU 2750-EXIT     
               PERFORM 2975-PROCESS-TO-MNT-JOURNAL   THRU 2975-EXIT     
               MOVE WS-TO-ACCOUNT-NO-NUM             TO AT-ACCOUNT-NO   
               PERFORM 7200-SELECT-ACCOUNT           THRU 7200-EXIT     
               MOVE SPACES TO WS-CURRENT-TASK                           
           END-IF.                                                      
      *                                                                         
           PERFORM 2021-CHECK-SEL-TRANSFERS THRU 2021-EXIT.             
           IF WS-SAVE-DFA-REC-COUNT > 0                                 
              MOVE 'L' TO PARM-TRANSFER-STYLE                           
              IF (WS-SAVE-SEL-REC-COUNT = 0                             
                OR WS-SAVE-SEL-REC-AMOUNT = 0)                          
                AND PARM-PAID-DEPOSIT-TRANSFER = 'N'                    
                 MOVE 'Y' TO WS-JUST-DFA                                
              END-IF                                                    
              MOVE WS-SAVE-DFA-REC-COUNT TO WS-SAVE-SEL-REC-COUNT       
              PERFORM 2023-DO-SEL THRU 2023-EXIT                        
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'CMN0000013'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              PERFORM 8900-SEND-DONE         THRU 8900-EXIT             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SET-TRANSFER-FORWARD-FLAG NOT = 'Y' AND              
              PARM-SET-TRANSFER-FORWARD-FLAG NOT = 'N' AND              
              PARM-PAID-DEPOSIT-TRANSFER NOT = 'Y' AND                  
              PARM-SELECT-REC1 NOT = SPACES                             
              PERFORM 7020-SELECT-FROM-ACCT-DATES    THRU 7020-EXIT     
              PERFORM 7030-SELECT-TO-ACCT-BUCKETS-2  THRU 7030-EXIT     
              PERFORM 2040-TRANSFER-ACCT-DATES       THRU 2040-EXIT     
           END-IF.                                                      
      *                                                                         
           IF WS-CANCELDNP-TO-ACCT NOT = 'N'                            
              MOVE PARM-TO-ACCOUNT-NO TO PARM-ACCOUNT-NO                
              MOVE SPACES             TO PARM-SO-PREMISE-NO             
              MOVE 25                 TO WS-REMARKS-TX-LEN              
              MOVE 'A/R TRANSFER - TO ACCOUNT'  TO WS-REMARKS-TX-TEXT   
              MOVE 'Y'                TO PARM-SO-UPDATE-REMARKS         
              MOVE 'U'                TO WS-UPDATE                      
              MOVE '069'              TO WS-PANEL-NO                    
              MOVE 'A'                TO PARM-SO-ORDER-TYPE-FLAG        
              MOVE 'R'                TO PARM-SO-DNP-CANCEL-REASON      
              PERFORM 2200-CANCEL-DNP THRU 2200-EXIT                    
           END-IF.                                                      
      *                                                                         
           IF WS-CANCELDNP-FROM-ACCT NOT = 'N'                          
              MOVE PARM-FROM-ACCOUNT-NO TO PARM-ACCOUNT-NO              
              MOVE SPACES               TO PARM-SO-PREMISE-NO           
              MOVE 25                   TO WS-REMARKS-TX-LEN            
              MOVE 'A/R TRANSFER - FROM ACCOUNT'  TO WS-REMARKS-TX-TEXT 
              MOVE 'Y'                  TO PARM-SO-UPDATE-REMARKS       
              MOVE 'U'                  TO WS-UPDATE                    
              MOVE '069'                TO WS-PANEL-NO                  
              MOVE 'A'                  TO PARM-SO-ORDER-TYPE-FLAG      
              MOVE 'R'                  TO PARM-SO-DNP-CANCEL-REASON    
              PERFORM 2200-CANCEL-DNP THRU 2200-EXIT                    
           END-IF.                                                      
      *                                                                         
           ADD +1 TO CTR-ROWS.                                          
      *                                                                         
           IF WS-AR-TRANSFER-TO   = 'N' OR                              
              WS-AR-TRANSFER-FROM = 'N'                                 
              PERFORM 5020-NO-AR-XFER-MNT-HST-DET THRU 5020-EXIT        
           END-IF.                                                      
      *                                                                         
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2021-CHECK-SEL-TRANSFERS                                      *         
      *****************************************************************         
       2021-CHECK-SEL-TRANSFERS.                                        
      *                                                                         
      *** THE FOLLOWING MEANS DEPOSITS WERE PROCESSED AND NEED ****             
      *** TO BE INCLUDED THE AR TRANS HIST HEADER.             ****             
           IF AU-TRAN-APPL-NO > 1 AND AU-AMT-POSTED > 0                 
              MOVE AR-TRANS-HIST-SEQ-NO TO WS-25-CURRENT-TIMESTAMP      
              ADD AU-AMT-POSTED         TO WS-4595-AMT-ORIG-ENTERED     
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC1 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC1      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID1         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE1   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT1    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND1    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC2 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC2      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID2         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE2   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT2    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND2    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC3 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC3      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID3         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE3   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT3    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND3    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC4 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC4      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID4         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE4   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT4    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND4    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC5 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC5      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID5         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE5   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT5    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND5    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC6 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC6      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID6         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE6   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT6    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND6    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC7 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC7      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID7         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE7   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT7    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND7    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC8 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC8      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID8         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE8   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT8    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND8    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC9 EQUAL SPACES                             
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC9      TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID9         TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE9   TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT9    TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND9    TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC10 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC10     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID10        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE10  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT10   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND10   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC11 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC11     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID11        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE11  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT11   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND11   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC12 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC12     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID12        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE12  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT12   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND12   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC13 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC13     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID13        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE13  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT13   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND13   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC14 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC14     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID14        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE14  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT14   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND14   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC15 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC15     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID15        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE15  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT15   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND15   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC16 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC16     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID16        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE16  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT16   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND16   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC17 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC17     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID17        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE17  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT17   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND17   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC18 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC18     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID18        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE18  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT18   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND18   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC19 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC19     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID19        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE19  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT19   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND19   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
           IF PARM-SELECT-REC20 EQUAL SPACES                            
              GO TO 2021-EXIT                                           
           ELSE                                                         
              MOVE PARM-SELECT-REC20     TO WS-SEL-XFER-REC (1)         
              MOVE PARM-ITEM-ID20        TO WS-SEL-XFER-ITEM-ID (1)     
              MOVE PARM-TRANSFER-TYPE20  TO PARM-TRANSFER-STYLE         
              MOVE PARM-AMT-CONTRACT20   TO WS-AMT-CONTRACT             
              MOVE WS-AMT-CONTRACT-NUM   TO WS-AMT-CONTRACT-COMP3       
              MOVE WS-AMT-CONTRACT-COMP3 TO WS-SEL-XFER-AMT (1)         
              MOVE 0                     TO WS-SEL-XFER-AMT-DEF (1)     
ACT047        MOVE PARM-CHRG-OFF-IND20   TO WS-SEL-XFER-CHGOFF (1)      
              PERFORM 2022-PROCESS-TRANSFERS THRU 2022-EXIT             
           END-IF.                                                      
      *                                                                         
       2021-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2022-PROCESS-TRANSFERS                                        *         
      *****************************************************************         
       2022-PROCESS-TRANSFERS.                                          
      *                                                                         
           IF PARM-TRANSFER-STYLE = 'L'                                 
              ADD 1 TO WS-SAVE-DFA-REC-COUNT                            
              MOVE WS-SAVE-DFA-REC-COUNT TO WS-SUB                      
              MOVE WS-SEL-XFER-REC (1) TO WS-SEL-XFER-REC (WS-SUB)      
              MOVE WS-SEL-XFER-AMT (1) TO WS-SEL-XFER-AMT (WS-SUB)      
              ADD WS-SEL-XFER-AMT (1)  TO WS-4595-AMT-ORIG-ENTERED      
              ADD  WS-SEL-XFER-AMT (1) TO WS-25-AMT-ORIG-ENTERED        
ACT047        MOVE WS-SEL-XFER-CHGOFF (1) TO WS-25-CHRGOFF-IND          
              PERFORM 2730-LOAD-ALL-DFA-RECV THRU 2730-EXIT             
              GO TO 2022-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE 1                       TO WS-SAVE-SEL-REC-COUNT.       
           MOVE WS-SEL-XFER-REC (1)     TO WS-25-TYPE-TO-XFER.          
           MOVE WS-SEL-XFER-ITEM-ID (1) TO WS-25-ID-NUMBER.             
           MOVE WS-SEL-XFER-AMT (1)     TO WS-25-AMT-TO-XFER.           
           ADD  WS-SEL-XFER-AMT (1)     TO WS-25-AMT-ORIG-ENTERED.      
           ADD  WS-SEL-XFER-AMT (1)     TO WS-SAVE-SEL-REC-AMOUNT.      
ACT047     MOVE WS-SEL-XFER-CHGOFF (1)  TO WS-25-CHRGOFF-IND.           
      *                                                                         
           IF WS-25-CHRGOFF-IND = 'Y'                                   
A04527        MOVE WS-FROM-ACCOUNT-NO-NUM TO CO-ACCOUNT-NO              
A04527        MOVE WS-25-ID-NUMBER        TO CO-ITEM-ID                 
A04527        EVALUATE WS-25-TYPE-TO-XFER                               
A04527          WHEN WS-25-NSC                                          
A04527             MOVE 19  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-NSA                                          
A04527             MOVE 20  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-NSN                                          
A04527             MOVE 29  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-LPC                                          
A04527             MOVE 30  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-LPN                                          
A04527             MOVE 39  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-UTE                                          
A04527             MOVE 40  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-UTG                                          
A04527             MOVE 45  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-BUD                                          
A04527             MOVE 50  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-CCC                                          
A04527             MOVE 60  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-CIA                                          
A04527             MOVE 70  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-DEP                                          
A04527             MOVE 80  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-DFA                                          
A04527             MOVE 90  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-DPP                                          
A04527             MOVE 90  TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-CNT                                          
A04527             MOVE 100 TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN WS-25-PJS                                          
A04527             MOVE 129 TO CO-PYMT-PRIORITY-LVL                     
A04527          WHEN OTHER                                              
A04527             MOVE 999 TO CO-PYMT-PRIORITY-LVL                     
A04527          END-EVALUATE                                            
A04527        PERFORM 7550-SELECT-CHRG-OFF THRU 7550-EXIT               
A04527     END-IF.                                                      
      *                                                                         
           IF WS-25-TYPE-TO-XFER ='DFA' AND WS-JUST-FROM-DFA = 'Y'      
                 NEXT SENTENCE                                          
           ELSE                                                         
                 MOVE 'N' TO WS-JUST-FROM-DFA                           
           END-IF.                                                      
      *                                                                         
           IF WS-25-TYPE-TO-XFER ='PJS'                                 
              PERFORM 2026-CK-PJS THRU 2026-EXIT                        
           END-IF.                                                      
      *                                                                         
           IF PARM-TRANSFER-STYLE = 'U'                                 
              MOVE 'STM' TO WS-CURRENT-TASK                             
                            PARM-TRANSFER-TYPE                          
              MOVE 'A'   TO PARM-TRANSFER-STYLE                         
              PERFORM 2024-DO-STM THRU 2024-EXIT                        
           ELSE                                                         
              MOVE WS-N TO WS-25-TRANSFER-ALL                           
              MOVE WS-Y TO WS-25-TRANSFER-SINGLE                        
              MOVE WS-N TO WS-25-TRANSFER-TYPE-STM                      
              MOVE 'SEL' TO WS-CURRENT-TASK                             
                            PARM-TRANSFER-TYPE                          
              PERFORM 2023-DO-SEL THRU 2023-EXIT                        
           END-IF.                                                      
      *                                                                         
           IF AU-TRAN-APPL-NO > 1 AND                                   
             (AU-AMT-POSTED > 0 OR WS-25-TYPE-TO-XFER ='CNT')           
              PERFORM 2027-DO-AR-TOTAL THRU 2027-EXIT                   
           END-IF.                                                      
      *                                                                         
           ADD +1 TO CTR-ROWS.                                          
                                                                        
       2022-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2023-DO-SEL                                                   *         
      *****************************************************************         
       2023-DO-SEL.                                                     
      *                                                                         
      * GET NEXT BILL DATE IF SEL MODE AND XFER AS DFA FOR TO ACCT              
           IF PARM-TRANSFER-STYLE = 'L'                                 
              MOVE WS-TO-ACCOUNT-COMP3   TO AT-ACCOUNT-NO               
              PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                
              PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT 
              IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                      
                 MOVE BN-DATE-EXTRACT          TO REFORMAT-DATE         
                 MOVE WS-FORMAT-YEAR           TO USA-YEAR              
                 MOVE WS-FORMAT-MONTH          TO USA-MONTH             
                 MOVE WS-FORMAT-DAY            TO USA-DAY               
                 MOVE USA-DATE-FORMAT          TO WS-78-DFA-START-DATE  
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE        
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '5900'                   TO ACTIVE-PARAGRAPH      
                 MOVE 'SELECT'                 TO ABEND-FUNCTION        
                 MOVE SPACES                   TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                 MOVE 'CSS_BILL_WINDOW'        TO TABLE-1               
                 MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1       
                 MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
                 PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE PARM-FROM-ACCOUNT-NO      TO WS-FROM-ACCOUNT-NO.        
           MOVE WS-FROM-ACCOUNT-NO-NUM    TO WS-FROM-ACCOUNT-COMP3.     
           MOVE WS-FROM-ACCOUNT-COMP3     TO WS-25-ACCT-NO-FROM         
                                             AT-ACCOUNT-NO.             
           PERFORM 7200-SELECT-ACCOUNT    THRU 7200-EXIT.               
           MOVE AT-LOCAL-OFFICE           TO WS-25-LOCAL-OFFICE-FROM.   
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.     
           IF WS-CODE-UTL EQUAL WS-A                                    
              MOVE WS-Y                   TO WS-25-FROM-HAS-UTL         
           END-IF.                                                      
           IF WS-CODE-BUDGET EQUAL WS-A                                 
              MOVE WS-Y                   TO WS-25-FROM-HAS-BUD         
           END-IF.                                                      
      *                                                                         
           PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT         
           PERFORM 2550-PREPARE-JOURNAL          THRU 2550-EXIT         
           IF PARM-TRANSFER-STYLE EQUAL WS-A OR WS-C                    
              PERFORM 2700-TRANSFER-SEL     THRU 2700-EXIT              
                  VARYING WS-SUB FROM 1 BY 1                            
              UNTIL WS-SUB > WS-SAVE-SEL-REC-COUNT                      
           ELSE                                                         
              PERFORM 2725-TRANSFER-SEL-DFA THRU 2725-EXIT              
           END-IF.                                                      
           MOVE WS-TO-ACCOUNT-NO-NUM    TO AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT.                 
           PERFORM 2975-PROCESS-TO-MNT-JOURNAL THRU 2975-EXIT.          
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
           MOVE WS-CURRENT-DATE         TO WS-HOLD-DATE                 
                                           WS-CL-DATE-NOTICE-MAIL       
                                           WS-CL-DATE-NOTICE-DUE.       
           PERFORM 5500-LINK-SCSCO068    THRU 5500-EXIT.                
           PERFORM 2030-CALC-NEW-DNP-AMT THRU 2030-EXIT.                
           MOVE WS-FROM-ACCOUNT-NO-NUM  TO AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT   THRU 7200-EXIT.                
           PERFORM 5500-LINK-SCSCO068    THRU 5500-EXIT.                
           PERFORM 2030-CALC-NEW-DNP-AMT THRU 2030-EXIT.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'CMN0000013'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              PERFORM 8900-SEND-DONE         THRU 8900-EXIT             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
      *                                                                         
       2023-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2024-DO-STM.                                                  *         
      *****************************************************************         
       2024-DO-STM.                                                     
      *                                                                         
           PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT.        
      *                                                                         
           PERFORM 2500-TRANSFER-STM THRU 2500-EXIT.                    
           MOVE WS-TO-ACCOUNT-NO-NUM           TO AT-ACCOUNT-NO.        
           PERFORM 7200-SELECT-ACCOUNT         THRU 7200-EXIT.          
           PERFORM 2975-PROCESS-TO-MNT-JOURNAL THRU 2975-EXIT.          
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
           MOVE WS-CURRENT-DATE         TO WS-HOLD-DATE                 
                                           WS-CL-DATE-NOTICE-MAIL       
                                           WS-CL-DATE-NOTICE-DUE.       
           PERFORM 5500-LINK-SCSCO068    THRU 5500-EXIT.                
           PERFORM 2030-CALC-NEW-DNP-AMT THRU 2030-EXIT.                
           MOVE WS-FROM-ACCOUNT-NO-NUM  TO AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT   THRU 7200-EXIT.                
           PERFORM 5500-LINK-SCSCO068    THRU 5500-EXIT.                
           PERFORM 2030-CALC-NEW-DNP-AMT THRU 2030-EXIT.                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZEROES                TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'CMN0000013'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              PERFORM 8900-SEND-DONE         THRU 8900-EXIT             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
      *                                                                         
       2024-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2026-CK-PJS.  *SET TRANSFER-PJS      IF EXIST ON FROM ACCOUNT *         
      *****************************************************************         
       2026-CK-PJS.                                                     
      *                                                                         
           MOVE WS-25-ACCT-NO-FROM      TO   AC-ACCOUNT-NO.             
           MOVE WS-25-PJS-PYMT-PRIORITY TO   AC-PYMT-PRIORITY-LVL.      
           PERFORM 6863-OPEN-AR-CNTRL-DETAIL  THRU 6863-EXIT.           
           PERFORM 6864-FETCH-AR-CNTRL-DETAIL THRU 6864-EXIT.           
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'Y' TO WS-PROJ-SHR-XFER-IND                          
              MOVE WS-TO-ACCOUNT-NO-NUM   TO AT-ACCOUNT-NO              
              PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                
              MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT      
              IF WS-CODE-PROJECT-SHARE = 'A'                            
                 MOVE 'Y' TO WS-25-TO-HAS-PJS                           
              END-IF                                                    
              PERFORM 6864-FETCH-AR-CNTRL-DETAIL THRU 6864-EXIT         
           END-PERFORM.                                                 
           PERFORM 6865-CLOSE-AR-CNTRL-DETAIL THRU 6865-EXIT.           
      *                                                                         
       2026-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2027-DO-AR-TOTAL                                              *         
      *****************************************************************         
       2027-DO-AR-TOTAL.                                                
      *                                                                         
           MOVE AU-TRAN-APPL-NO          TO WS-TRAN-APPL-NO.            
           MOVE WS-25-AMT-ORIG-ENTERED   TO WS-UPD-AMT-ORIG-ENTERED.    
           MOVE AR-TRANS-HIST-SEQ-NO     TO WS-25-CURRENT-TIMESTAMP.    
           MOVE WS-25-ACCT-NO-TO         TO AR-ACCOUNT-NO.              
           PERFORM 8300-UPDATE-AMT-ORIG THRU 8300-EXIT.                 
           MOVE WS-25-ACCT-NO-FROM       TO AR-ACCOUNT-NO.              
           PERFORM 8300-UPDATE-AMT-ORIG THRU 8300-EXIT.                 
      *                                                                         
       2027-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *2030-CALC-NEW-DNP-AMT.                                     *             
      *************************************************************             
       2030-CALC-NEW-DNP-AMT.                                           
      *                                                                         
           IF WS-NOTICE-DNP-LIMIT NOT NUMERIC OR WS-NOTICE-DNP-LIMIT < 0
               MOVE ZEROS TO WS-NOTICE-DNP-LIMIT                        
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
           PERFORM 7110-SELCT-DNP-RECON THRU 7110-EXIT.                 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              COMPUTE WS-AMT-DNP-BAL =                                  
                      DL-AMT-TOT-RECONNECT - DL-RECNCT-COLLECT-AMT      
              END-COMPUTE                                               
              IF WS-AMT-DNP-BAL < 0                                     
                 MOVE 0 TO WS-AMT-DNP-BAL                               
              END-IF                                                    
              ADD WS-AMT-UN-CR-CIA TO WS-AMT-DNP-BAL                    
              IF AT-ACCOUNT-NO = WS-25-ACCT-NO-TO                       
                 IF WS-AMT-DNP-BAL <= 0                                 
                    MOVE 'Z' TO WS-CANCELDNP-TO-ACCT                    
                 ELSE                                                   
                    MOVE 'N' TO WS-CANCELDNP-TO-ACCT                    
                    IF CSR-DATABASE-CPD68                               
                       MOVE 'Y' TO WS-DNP-UPDATE-FL                     
                    END-IF
                 END-IF                                              
              ELSE                                                      
                 IF WS-AMT-DNP-BAL <= 0                                 
                    MOVE 'Z' TO WS-CANCELDNP-FROM-ACCT                  
                 ELSE                                                   
                    MOVE 'N' TO WS-CANCELDNP-FROM-ACCT                  
                    IF CSR-DATABASE-CPD68                               
                       MOVE 'Y' TO WS-DNP-UPDATE-FL                     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              ADD WS-AMT-UN-CR-CIA TO WS-AMT-DNP-BAL                    
              IF AT-ACCOUNT-NO = WS-25-ACCT-NO-TO                       
                 IF WS-AMT-DNP-BAL <= WS-NOTICE-DNP-LIMIT               
                    MOVE 'Y' TO WS-CANCELDNP-TO-ACCT                    
                 ELSE                                                   
                    MOVE 'N' TO WS-CANCELDNP-TO-ACCT                    
                 END-IF                                                 
              ELSE                                                      
                 IF WS-AMT-DNP-BAL <= WS-NOTICE-DNP-LIMIT               
                    MOVE 'Y' TO WS-CANCELDNP-FROM-ACCT                  
                 ELSE                                                   
                    MOVE 'N' TO WS-CANCELDNP-FROM-ACCT                  
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2040-TRANSFER-ACCT-DATES                                       *        
      ******************************************************************        
       2040-TRANSFER-ACCT-DATES.                                        
      *                                                                         
           IF WS-TO-ACCT-BEFORE-00 NOT = WS-TO-ACCT-AFTER-00 AND        
              WS-TO-ACCT-DATE-00       = SPACES              AND        
              WS-FROM-ACCT-DATE-00 NOT = SPACES                         
                MOVE WS-FROM-ACCT-DATE-00    TO AT-DATE-BILL-DAY-00     
                MOVE 0                       TO WS-45-NULL-IND-00       
           ELSE                                                         
              IF WS-TO-ACCT-DATE-00 > SPACES                            
                 MOVE WS-TO-ACCT-DATE-00     TO AT-DATE-BILL-DAY-00     
                 MOVE 0                      TO WS-45-NULL-IND-00       
              ELSE                                                      
                 MOVE SPACES                 TO AT-DATE-BILL-DAY-00     
                 MOVE -1                     TO WS-45-NULL-IND-00       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-TO-ACCT-BEFORE-30 NOT = WS-TO-ACCT-AFTER-30 AND        
              WS-TO-ACCT-DATE-30       = SPACES              AND        
              WS-FROM-ACCT-DATE-30 NOT = SPACES                         
                MOVE WS-FROM-ACCT-DATE-30    TO AT-DATE-BILL-DAY-30     
                MOVE 0                       TO WS-45-NULL-IND-30       
           ELSE                                                         
              IF WS-TO-ACCT-DATE-30 > SPACES                            
                 MOVE WS-TO-ACCT-DATE-30     TO AT-DATE-BILL-DAY-30     
                 MOVE 0                      TO WS-45-NULL-IND-30       
              ELSE                                                      
                 MOVE SPACES                 TO AT-DATE-BILL-DAY-30     
                 MOVE -1                     TO WS-45-NULL-IND-30       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-TO-ACCT-BEFORE-60 NOT = WS-TO-ACCT-AFTER-60 AND        
              WS-TO-ACCT-DATE-60       = SPACES              AND        
              WS-FROM-ACCT-DATE-60 NOT = SPACES                         
                MOVE WS-FROM-ACCT-DATE-60    TO AT-DATE-BILL-DAY-60     
                MOVE 0                       TO WS-45-NULL-IND-60       
           ELSE                                                         
              IF WS-TO-ACCT-DATE-60 > SPACES                            
                 MOVE WS-TO-ACCT-DATE-60     TO AT-DATE-BILL-DAY-60     
                 MOVE 0                      TO WS-45-NULL-IND-60       
              ELSE                                                      
                 MOVE SPACES                 TO AT-DATE-BILL-DAY-60     
                 MOVE -1                     TO WS-45-NULL-IND-60       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-TO-ACCT-BEFORE-90 NOT = WS-TO-ACCT-AFTER-90 AND        
              WS-TO-ACCT-DATE-90       = SPACES              AND        
              WS-FROM-ACCT-DATE-90 NOT = SPACES                         
                MOVE WS-FROM-ACCT-DATE-90    TO AT-DATE-BILL-DAY-90     
                MOVE 0                       TO WS-45-NULL-IND-90       
           ELSE                                                         
              IF WS-TO-ACCT-DATE-90 > SPACES                            
                 MOVE WS-TO-ACCT-DATE-90     TO AT-DATE-BILL-DAY-90     
                 MOVE 0                      TO WS-45-NULL-IND-90       
              ELSE                                                      
                 MOVE SPACES                 TO AT-DATE-BILL-DAY-90     
                 MOVE -1                     TO WS-45-NULL-IND-90       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 8050-UPDATE-AT-BILL-DATES THRU 8050-EXIT.            
      *                                                                         
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-CANCEL-DNP.                                               *        
      ******************************************************************        
        2200-CANCEL-DNP.                                                
      *                                                                         
           PERFORM 5250-CALL-CSR00125      THRU 5250-EXIT.              
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR00125                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_DNP CURSOR FOR RESULT SET                
      *        :LOC2                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5300-FETCH-CSR00125     THRU 5300-EXIT.              
           EVALUATE WS-SO-RETURN-CD-BD                                  
              WHEN 0                                                    
                   IF CSR-DATABASE                                      
                      PERFORM 2300-UPD-ACCT-CRED-PROF-TB THRU 2300-EXIT 
                      MOVE 0                  TO S-RETURN-CODE          
      * DNP CANCELLED SUCCESSFULLY                                              
                   END-IF                                               
              WHEN 5000                                                 
                   IF CSR-DATABASE                                      
                      MOVE 0                 TO S-RETURN-CODE           
      * DNP IS IN ROUTE                                                         
                      MOVE 'CMN0000020'      TO S-BUS-RULE-ID           
                      MOVE 'F'               TO S-BUS-RULE-RESULT-CD    
                      IF S-BUS-RULE-ID > SPACES                         
                          PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT  
                      END-IF                                            
                      PERFORM 8900-SEND-DONE         THRU 8900-EXIT     
                      PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
                      PERFORM 9999-END-PROGRAM       THRU 9999-EXIT     
                   END-IF                                               
              WHEN 100                                                  
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-SO-RETURN-CD-BD    TO S-RETURN-CODE          
                   MOVE 'CMN0000020'          TO S-BUS-RULE-ID          
                   MOVE 'F'                   TO S-BUS-RULE-RESULT-CD   
                   IF S-BUS-RULE-ID > SPACES                            
                       PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT     
                   END-IF                                               
                   PERFORM 8900-SEND-DONE         THRU 8900-EXIT        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9999-END-PROGRAM       THRU 9999-EXIT        
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5350-CLOSE-CSR00125     THRU 5350-EXIT.              
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-UPD-ACCT-CRED-PROF-TB.                                             
      ******************************************************************        
        2300-UPD-ACCT-CRED-PROF-TB.                                     
      *                                                                         
           IF WS-ORDER-TYPE-CD-BD = 'DNPFB'                             
               MOVE 'N'                    TO WS-UPDATE-PROFILE         
           ELSE                                                         
               MOVE 'Y'                    TO WS-UPDATE-PROFILE         
           END-IF.                                                      
           PERFORM 5360-CALL-CSR02122      THRU 5360-EXIT.              
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR02122                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE UPDATE_ACCT_TB CURSOR FOR RESULT SET            
      *        :LOC2                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5370-FETCH-CSR02122     THRU 5370-EXIT.              
           EVALUATE WS-2122-RETURN-CODE                                 
              WHEN 0                                                    
                   CONTINUE                                             
              WHEN 1000                                                 
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-2122-RETURN-CODE TO S-RETURN-CODE            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9999-END-PROGRAM       THRU 9999-EXIT        
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5380-CLOSE-CSR02122     THRU 5380-EXIT.              
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  TRANSFER RECEIVABLES TO SUMMED UNBILLED                      *         
      * 2500-TRANSFER-STM.                                            *         
      *****************************************************************         
       2500-TRANSFER-STM.                                               
      *                                                                         
           MOVE WS-N TO WS-25-TRANSFER-ALL.                             
           MOVE WS-Y TO WS-25-TRANSFER-SINGLE.                          
           MOVE WS-Y TO WS-25-TRANSFER-TYPE-STM.                        
           PERFORM 2550-PREPARE-JOURNAL THRU 2550-EXIT.                 
           IF PARM-TRANSFER-STYLE EQUAL WS-A OR WS-C                    
              PERFORM 6800-TRANSFER-CONTROL THRU 6800-EXIT              
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2550-PREPARE-JOURNAL.                                         *         
      *****************************************************************         
       2550-PREPARE-JOURNAL.                                            
      *                                                                         
           MOVE '2550'        TO ACTIVE-PARAGRAPH.                      
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
      *                                                                         
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *                   
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *                   
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
      *                                                                         
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *                   
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *                   
           MOVE PARM-USER-ID                TO WS-JRNL-OL-TEMP-ID.      
           MOVE WS-JRNL-CK-OPER-ID          TO WS-JRNL-OPERATION-RQST.  
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC          TO WS-TERM-LOC.             
      *                                                                         
      * THESE FIELDS WERE POPULATED BY CALLING CPD00022     *                   
      * (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL.     *                   
           MOVE '01'                   TO   WS-JRNL-OL-COMPANY          
                                            AR-CASH-COMPANY-NO.         
           MOVE '998'                  TO   WS-JRNL-OL-LOC-OFF          
                                            AR-CASH-LOCAL-OFFICE.       
           MOVE '998'                  TO   WS-JRNL-OL-REPORT-NO        
                                            AR-CASH-REPORT-NO.          
           MOVE WS-CURRENT-DATE        TO   WS-JRNL-OL-REPORT-DT        
                                            AR-DATE-CASH-REPORT.        
           MOVE +9999                  TO   WS-JRNL-OL-CASH-DRWR        
                                            AR-CASH-DRAWER-ID.          
           MOVE WS-TERM-LOC            TO   WS-JRNL-OL-TERM-LOC         
                                            WS-JRNL-OL-CASH-LOC         
                                            WS-JRNL-OL-OPR-LOC.         
           MOVE WS-JRNL-VALIDATE-OPER  TO WS-JRNL-OPERATION-RQST.       
           MOVE WS-C                   TO WS-JRNL-SOURCE-CODE.          
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE     
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE  TO WS-JRNL-OL-AUTH-TYPE     
           END-IF.                                                      
      *                                                                         
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
      *                                                                         
           MOVE WS-A                    TO WS-100-JRNL-SORT-ID.         
           MOVE AT-ACCOUNT-NO           TO WS-100-ACCT-NO.              
           MOVE AT-CUSTOMER-NO          TO WS-100-CUSTOMER-NO.          
           MOVE AT-PREMISE-NO           TO WS-100-PREMISE-NO.           
           MOVE EIBTRNID                TO WS-100-CODE-TERMINAL-TRAN.   
           ADD 1                        TO WS-100-JRNL-TRAN-APPL-NO.    
           MOVE WS-CURRENT-DATE         TO WS-100-DATE-LAST-ACTION      
                                           AT-DATE-LAST-ACTION.         
           MOVE WS-C                    TO WS-100-CODE-ENTRY-SOURCE.    
           MOVE AT-LOCAL-OFFICE         TO WS-100-LOCAL-OFFICE-CD.      
           MOVE '01'                    TO WS-25-CD-COMPANY-NO.         
           MOVE '998'                   TO WS-25-CD-LOCAL-OFFICE.       
           MOVE '998'                   TO WS-25-CD-REPORT-NO.          
           MOVE WS-CURRENT-DATE         TO WS-25-CD-REPORT-DATE.        
           MOVE +9999                   TO WS-25-CD-CASH-DRAWER-ID.     
           MOVE WS-25-CASH-DRAWER       TO WS-CASH-DRAWER.              
           MOVE WS-TERM-LOC             TO WS-25-TERM-LOC.              
           MOVE PARM-USER-ID            TO WS-25-OPER-ID.               
           MOVE PF-RESP-AREA-ID         TO WS-25-RESP-AREA.             
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2700-TRANSFER-SEL    TRANSFER SELECT RECEIVABLES              *         
      *****************************************************************         
       2700-TRANSFER-SEL.                                               
      *                                                                         
           MOVE WS-Y TO WS-25-TRANSFER-SINGLE.                          
           MOVE AU-TRAN-APPL-NO TO WS-25-TRAN-APPL-NO.                  
      *                                                                         
           PERFORM 6800-TRANSFER-CONTROL     THRU 6800-EXIT.            
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2725-TRANSFER-SEL-DFA       TRANSFER SELECT RECEIVABLES AS DFA*         
      *****************************************************************         
       2725-TRANSFER-SEL-DFA.                                           
      *                                                                         
           MOVE CJ-TRAN-APPL-NO          TO WS-100-TRAN-APPL-NO-HOLD.   
           MOVE WS-25-ACCT-NO-TO         TO WS-78-DFA-ACCT-NO-TO.       
           MOVE WS-25-ACCT-NO-FROM       TO WS-78-DFA-ACCT-NO-FROM.     
           MOVE 'E'                      TO WS-78-DFA-CODE-DESC.        
           MOVE 'CSR04595T'              TO WS-78-TRIGGER-PROC.         
           PERFORM 6600-FORCE-DFA        THRU 6600-FORCE-DFA-EXIT.      
           PERFORM 2027-DO-AR-TOTAL      THRU 2027-EXIT.                
      *                                                                         
       2725-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2730-LOAD-ALL-DFA-RECV                                        *         
      *****************************************************************         
       2730-LOAD-ALL-DFA-RECV.                                          
      *                                                                         
           MOVE WS-SEL-XFER-REC(WS-SUB) TO WS-78-TBL-TYPE-XFR(WS-SUB).  
           MOVE WS-SEL-XFER-AMT(WS-SUB) TO WS-78-TBL-AMT-XFR(WS-SUB).   
           ADD  WS-SEL-XFER-AMT(WS-SUB) TO WS-78-DFA-AMT-TO-XFER.       
      *                                                                         
       2730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2750-TRANSFER-PAID-DEPOSITS.                                  *         
      *****************************************************************         
       2750-TRANSFER-PAID-DEPOSITS.                                     
      *                                                                         
           MOVE WS-Y                           TO WS-25-TRANSFER-SINGLE 
           PERFORM 2550-PREPARE-JOURNAL        THRU 2550-EXIT           
           MOVE ZERO                           TO WS-25-TRAN-APPL-NO    
           PERFORM 6800-TRANSFER-CONTROL       THRU 6800-EXIT.          
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2800-TRANSFER-HISTORY.                                        *         
      *****************************************************************         
       2800-TRANSFER-HISTORY.                                           
      *                                                                         
           MOVE WS-TO-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO.          
           MOVE WS-MH-TRAN-APPL-NO-TO        TO WS-MH-TRAN-APPL-NO.     
           MOVE WS-TRANS-HIST-SEQ-NO-TO      TO MH-TRANS-HIST-SEQ-NO.   
           IF WS-CURRENT-TASK = 'UCH'                                   
              PERFORM 2801-TRANSFER-UTL-HST  THRU 2801-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WS-CURRENT-TASK = 'NCH'                                   
              PERFORM 2802-TRANSFER-NON-UTL-HST THRU 2802-EXIT          
           END-IF.                                                      
      *                                                                         
           IF WS-CURRENT-TASK = 'UCH' OR 'NCH'                          
              MOVE MH-TRANS-HIST-SEQ-NO         TO CZ-LAST-UPDATE-TS    
              MOVE WS-TO-ACCOUNT-NO-NUM         TO CZ-ACCOUNT-NO        
              PERFORM 8250-UPDATE-CREDIT-PROF   THRU 8250-EXIT          
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2801-TRANSFER-UTL-HST.                                        *         
      *****************************************************************         
       2801-TRANSFER-UTL-HST.                                           
      *                                                                         
           MOVE SPACES                     TO WS-CREDIT-HIST.           
           MOVE WS-FROM-ACCOUNT-COMP3      TO CZ-ACCOUNT-NO.            
           PERFORM 7230-SELECT-CREDIT-PROF THRU 7230-EXIT.              
           MOVE CZ-ARREARS-HIST            TO WS-FROM-ARREARS-HIST.     
           MOVE CZ-DISC-EXCEPTN-HIST       TO WS-FROM-DISC-EXCEPTN-HIST.
           MOVE CZ-DISCONNECT-HIST         TO WS-FROM-DISCONNECT-HIST.  
           MOVE WS-TO-ACCOUNT-NO-NUM       TO CZ-ACCOUNT-NO.            
           PERFORM 7230-SELECT-CREDIT-PROF THRU 7230-EXIT.              
           MOVE CZ-ARREARS-HIST            TO WS-TO-ARREARS-HIST.       
           MOVE CZ-DISC-EXCEPTN-HIST       TO WS-TO-DISC-EXCEPTN-HIST.  
           MOVE CZ-DISCONNECT-HIST         TO WS-TO-DISCONNECT-HIST.    
           MOVE WS-FROM-ACCOUNT-COMP3      TO AT-ACCOUNT-NO.            
           PERFORM 7200-SELECT-ACCOUNT     THRU 7200-EXIT.              
           MOVE AT-DATE-BILL-DAY-00        TO WS-FROM-START-BILL.       
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML TO   BG-REVENUE-MONTH            
           ELSE                                                         
              IF AT-DATE-BILL-DAY-00 NOT EQUAL SPACES                   
                 PERFORM 7350-GET-BILL-NO      THRU 7350-EXIT           
                 IF WS-BILL-HEADER-FOUND = 'Y'                          
                    PERFORM 7360-GET-REV-MONTH    THRU 7360-EXIT        
                 ELSE                                                   
                    PERFORM 7370-READ-BILL-WINDOW  THRU 7370-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-REVENUE-MONTH       TO WS-REVENUE-MONTH              
                                          WS-REVMTH                     
                                          WS-BG-REV-FROM-MTH.           
           MOVE WS-REVENUE-MONTH       TO WS-REVENUE-MONTH-X.           
           MOVE WS-REVENUE-MONTH-X     TO WS-REV-MONTH-YR.              
      *                                                                         
           MOVE WS-REV-YEAR            TO WS-FROM-SYEAR-NUM.            
           MOVE WS-REV-YEAR            TO WS-FROM-REV-YEAR.             
           MOVE WS-REV-MONTH           TO WS-FROM-SMONTH-NUM.           
           MOVE WS-REV-MONTH           TO WS-FROM-REV-MONTH.            
           MOVE WS-TO-ACCOUNT-NO-NUM   TO AT-ACCOUNT-NO.                
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           MOVE AT-DATE-BILL-DAY-00    TO WS-TO-START-BILL.             
           INITIALIZE WORK-FIELD2.                                      
           INITIALIZE BG-REVENUE-MONTH.                                 
           INITIALIZE BI-BILL-NO.                                       
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML TO   BG-REVENUE-MONTH            
           ELSE                                                         
              IF AT-DATE-BILL-DAY-00 NOT EQUAL SPACES                   
                 IF AT-CODE-ACCT-STAT NOT EQUAL 'P'                     
                   PERFORM 7350-GET-BILL-NO      THRU 7350-EXIT         
                   IF WS-BILL-HEADER-FOUND = 'Y'                        
                      PERFORM 7360-GET-REV-MONTH    THRU 7360-EXIT      
                   ELSE                                                 
                      MOVE WS-BG-REV-FROM-MTH    TO BG-REVENUE-MONTH    
                   END-IF                                               
                 ELSE                                                   
                   MOVE WS-REVMTH                 TO BG-REVENUE-MONTH   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-REVENUE-MONTH        TO WS-REVENUE-MONTH.            
           MOVE WS-REVENUE-MONTH        TO WS-REVENUE-MONTH-X.          
           MOVE WS-REVENUE-MONTH-X      TO WS-REV-MONTH-YR.             
      *                                                                         
           MOVE WS-REV-YEAR             TO WS-TO-SYEAR-NUM.             
           MOVE WS-REV-YEAR             TO WS-TO-REV-YEAR.              
           MOVE WS-REV-MONTH            TO WS-TO-SMONTH-NUM.            
           MOVE WS-REV-MONTH            TO WS-TO-REV-MONTH.             
           MOVE 1                       TO WS-TO-SUB.                   
           MOVE 1                       TO WS-FROM-SUB.                 
           MOVE 1                       TO WS-RESULT-SUB.               
           MOVE SPACES                  TO WS-CREDIT-HIST.              
           MOVE WS-FROM-ARREARS-HIST    TO WS-FROM-HIST-TAB.            
           MOVE WS-TO-ARREARS-HIST      TO WS-TO-HIST-TAB.              
           MOVE WS-N                    TO WS-OUT-OF-FROM-BUCKETS.      
           MOVE WS-N                    TO WS-OUT-OF-TO-BUCKETS.        
           PERFORM 2810-PROCESS-HISTORY THRU 2810-EXIT                  
              UNTIL WS-DONE-FLAG = WS-Y.                                
      *                                                                         
           MOVE WS-RESULT-HIST-TAB        TO WS-RESULT-ARREARS-HIST.    
           MOVE 1                         TO WS-TO-SUB.                 
           MOVE 1                         TO WS-FROM-SUB.               
           MOVE 1                         TO WS-RESULT-SUB.             
           MOVE SPACES                    TO WS-CREDIT-HIST.            
           MOVE WS-FROM-REV-MONTH         TO WS-FROM-SMONTH-NUM         
           MOVE WS-FROM-REV-YEAR          TO WS-FROM-SYEAR-NUM.         
           MOVE WS-TO-REV-MONTH           TO WS-TO-SMONTH-NUM.          
           MOVE WS-TO-REV-YEAR            TO WS-TO-SYEAR-NUM.           
           MOVE WS-FROM-DISC-EXCEPTN-HIST TO WS-FROM-HIST-TAB.          
           MOVE WS-TO-DISC-EXCEPTN-HIST   TO WS-TO-HIST-TAB.            
           MOVE WS-N                      TO WS-DONE-FLAG.              
           MOVE WS-N                      TO WS-OUT-OF-FROM-BUCKETS.    
           MOVE WS-N                      TO WS-OUT-OF-TO-BUCKETS.      
           PERFORM 2810-PROCESS-HISTORY   THRU 2810-EXIT                
              UNTIL WS-DONE-FLAG = WS-Y.                                
      *                                                                         
           MOVE WS-RESULT-HIST-TAB      TO WS-RESULT-DISC-EXCEPTN-HIST. 
           MOVE 1                       TO WS-TO-SUB.                   
           MOVE 1                       TO WS-FROM-SUB.                 
           MOVE 1                       TO WS-RESULT-SUB.               
           MOVE SPACES                  TO WS-CREDIT-HIST.              
           MOVE WS-FROM-REV-MONTH       TO WS-FROM-SMONTH-NUM           
           MOVE WS-FROM-REV-YEAR        TO WS-FROM-SYEAR-NUM.           
           MOVE WS-TO-REV-MONTH         TO WS-TO-SMONTH-NUM.            
           MOVE WS-TO-REV-YEAR          TO WS-TO-SYEAR-NUM.             
           MOVE WS-FROM-DISCONNECT-HIST TO WS-FROM-HIST-TAB.            
           MOVE WS-TO-DISCONNECT-HIST   TO WS-TO-HIST-TAB.              
           MOVE 'N'                     TO WS-DONE-FLAG.                
           MOVE 'N'                     TO WS-OUT-OF-FROM-BUCKETS.      
           MOVE 'N'                     TO WS-OUT-OF-TO-BUCKETS.        
           PERFORM 2810-PROCESS-HISTORY THRU 2810-EXIT UNTIL            
                   WS-DONE-FLAG = WS-Y.                                 
           MOVE WS-RESULT-HIST-TAB TO WS-RESULT-DISCONNECT-HIST.        
           MOVE WS-RESULT-ARREARS-HIST       TO CZ-ARREARS-HIST.        
           MOVE WS-RESULT-DISC-EXCEPTN-HIST  TO CZ-DISC-EXCEPTN-HIST.   
           MOVE WS-RESULT-DISCONNECT-HIST    TO CZ-DISCONNECT-HIST.     
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO-TO      TO WS-MH-TRAN-APPL-NO.       
           MOVE WS-TRANS-HIST-SEQ-NO-TO    TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-TO-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.            
           MOVE 'CZ-ARREARS-HIST'          TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-ARREARS-HIST         TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-ARREARS-HIST     TO MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
           MOVE 'CZ-DISC-EXCEPTN-HIST'     TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-DISC-EXCEPTN-HIST    TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-DISC-EXCEPTN-HIST TO MI-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
           MOVE 'CZ-DISCONNECT-HIST'       TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-DISCONNECT-HIST      TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-DISCONNECT-HIST  TO MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
      *                                                                         
       2801-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2802-TRANSFER-NON-UTL-HST.                                    *         
      *****************************************************************         
       2802-TRANSFER-NON-UTL-HST.                                       
      *                                                                         
           MOVE SPACES                     TO WS-CREDIT-HIST.           
           MOVE WS-FROM-ACCOUNT-COMP3      TO CZ-ACCOUNT-NO.            
           PERFORM 7230-SELECT-CREDIT-PROF THRU 7230-EXIT.              
           MOVE CZ-NON-UTL-ARRER-HIST      TO WS-FROM-NON-UTL-ARRER-HIST
           MOVE CZ-NON-UTL-CR-HST-EX       TO WS-FROM-NON-UTL-CR-HST-EX.
           MOVE CZ-NON-UTL-CR-HST          TO WS-FROM-NON-UTL-CR-HST.   
           MOVE WS-TO-ACCOUNT-NO-NUM       TO CZ-ACCOUNT-NO.            
           PERFORM 7230-SELECT-CREDIT-PROF THRU 7230-EXIT.              
           MOVE CZ-NON-UTL-ARRER-HIST      TO WS-TO-NON-UTL-ARRER-HIST. 
           MOVE CZ-NON-UTL-CR-HST-EX       TO WS-TO-NON-UTL-CR-HST-EX.  
           MOVE CZ-NON-UTL-CR-HST          TO WS-TO-NON-UTL-CR-HST.     
           MOVE WS-FROM-ACCOUNT-COMP3      TO AT-ACCOUNT-NO.            
           PERFORM 7200-SELECT-ACCOUNT     THRU 7200-EXIT.              
           MOVE AT-DATE-BILL-DAY-00        TO WS-FROM-START-BILL.       
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML TO   BG-REVENUE-MONTH            
           ELSE                                                         
              IF AT-DATE-BILL-DAY-00 NOT EQUAL SPACES                   
                 PERFORM 7350-GET-BILL-NO      THRU 7350-EXIT           
                 IF WS-BILL-HEADER-FOUND = 'Y'                          
                    PERFORM 7360-GET-REV-MONTH    THRU 7360-EXIT        
                 ELSE                                                   
                    PERFORM 7370-READ-BILL-WINDOW  THRU 7370-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-REVENUE-MONTH       TO WS-REVENUE-MONTH              
                                          WS-REVMTH                     
                                          WS-BG-REV-FROM-MTH.           
           MOVE WS-REVENUE-MONTH       TO WS-REVENUE-MONTH-X.           
           MOVE WS-REVENUE-MONTH-X     TO WS-REV-MONTH-YR.              
      *                                                                         
           MOVE WS-REV-YEAR            TO WS-FROM-SYEAR-NUM.            
           MOVE WS-REV-YEAR            TO WS-FROM-REV-YEAR.             
           MOVE WS-REV-MONTH           TO WS-FROM-SMONTH-NUM.           
           MOVE WS-REV-MONTH           TO WS-FROM-REV-MONTH.            
           MOVE WS-TO-ACCOUNT-NO-NUM   TO AT-ACCOUNT-NO.                
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           MOVE AT-DATE-BILL-DAY-00    TO WS-TO-START-BILL.             
           INITIALIZE WORK-FIELD2.                                      
           INITIALIZE BG-REVENUE-MONTH.                                 
           INITIALIZE BI-BILL-NO.                                       
           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML TO   BG-REVENUE-MONTH            
           ELSE                                                         
              IF AT-DATE-BILL-DAY-00 NOT EQUAL SPACES                   
                 IF AT-CODE-ACCT-STAT NOT EQUAL 'P'                     
                   PERFORM 7350-GET-BILL-NO      THRU 7350-EXIT         
                   IF WS-BILL-HEADER-FOUND = 'Y'                        
                      PERFORM 7360-GET-REV-MONTH    THRU 7360-EXIT      
                   ELSE                                                 
                      MOVE WS-BG-REV-FROM-MTH    TO BG-REVENUE-MONTH    
                   END-IF                                               
                 ELSE                                                   
                   MOVE WS-REVMTH                 TO BG-REVENUE-MONTH   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE BG-REVENUE-MONTH           TO WS-REVENUE-MONTH.         
           MOVE WS-REVENUE-MONTH           TO WS-REVENUE-MONTH-X.       
           MOVE WS-REVENUE-MONTH-X         TO WS-REV-MONTH-YR.          
           MOVE WS-REV-YEAR                TO WS-TO-SYEAR-NUM.          
           MOVE WS-REV-YEAR                TO WS-TO-REV-YEAR.           
           MOVE WS-REV-MONTH               TO WS-TO-SMONTH-NUM.         
           MOVE WS-REV-MONTH               TO WS-TO-REV-MONTH.          
      *                                                                         
           MOVE 1                          TO WS-TO-SUB.                
           MOVE 1                          TO WS-FROM-SUB.              
           MOVE 1                          TO WS-RESULT-SUB.            
           MOVE SPACES                     TO WS-CREDIT-HIST.           
           MOVE WS-FROM-REV-MONTH          TO WS-FROM-SMONTH-NUM        
           MOVE WS-FROM-REV-YEAR           TO WS-FROM-SYEAR-NUM.        
           MOVE WS-TO-REV-MONTH            TO WS-TO-SMONTH-NUM.         
           MOVE WS-TO-REV-YEAR             TO WS-TO-SYEAR-NUM.          
           MOVE WS-FROM-NON-UTL-ARRER-HIST TO WS-FROM-HIST-TAB.         
           MOVE WS-TO-NON-UTL-ARRER-HIST   TO WS-TO-HIST-TAB.           
           MOVE 'N'                        TO WS-DONE-FLAG.             
           MOVE 'N'                        TO WS-OUT-OF-FROM-BUCKETS.   
           MOVE 'N'                        TO WS-OUT-OF-TO-BUCKETS.     
           PERFORM 2810-PROCESS-HISTORY    THRU 2810-EXIT UNTIL         
                   WS-DONE-FLAG = WS-Y.                                 
           MOVE WS-RESULT-HIST-TAB     TO WS-RESULT-NON-UTL-ARRER-HIST. 
           MOVE 1                          TO WS-TO-SUB.                
           MOVE 1                          TO WS-FROM-SUB.              
           MOVE 1                          TO WS-RESULT-SUB.            
           MOVE SPACES                     TO WS-CREDIT-HIST.           
           MOVE WS-FROM-REV-MONTH          TO WS-FROM-SMONTH-NUM        
           MOVE WS-FROM-REV-YEAR           TO WS-FROM-SYEAR-NUM.        
           MOVE WS-TO-REV-MONTH            TO WS-TO-SMONTH-NUM.         
           MOVE WS-TO-REV-YEAR             TO WS-TO-SYEAR-NUM.          
           MOVE WS-FROM-NON-UTL-CR-HST-EX  TO WS-FROM-HIST-TAB.         
           MOVE WS-TO-NON-UTL-CR-HST-EX    TO WS-TO-HIST-TAB.           
           MOVE 'N'                        TO WS-DONE-FLAG.             
           MOVE 'N'                        TO WS-OUT-OF-FROM-BUCKETS.   
           MOVE 'N'                        TO WS-OUT-OF-TO-BUCKETS.     
           PERFORM 2810-PROCESS-HISTORY    THRU 2810-EXIT UNTIL         
                   WS-DONE-FLAG = WS-Y.                                 
           MOVE WS-RESULT-HIST-TAB     TO WS-RESULT-NON-UTL-CR-HST-EX.  
           MOVE 1                          TO WS-TO-SUB.                
           MOVE 1                          TO WS-FROM-SUB.              
           MOVE 1                          TO WS-RESULT-SUB.            
           MOVE SPACES                     TO WS-CREDIT-HIST.           
           MOVE WS-FROM-REV-MONTH          TO WS-FROM-SMONTH-NUM        
           MOVE WS-FROM-REV-YEAR           TO WS-FROM-SYEAR-NUM.        
           MOVE WS-TO-REV-MONTH            TO WS-TO-SMONTH-NUM.         
           MOVE WS-TO-REV-YEAR             TO WS-TO-SYEAR-NUM.          
           MOVE WS-FROM-NON-UTL-CR-HST     TO WS-FROM-HIST-TAB.         
           MOVE WS-TO-NON-UTL-CR-HST       TO WS-TO-HIST-TAB.           
           MOVE 'N'                        TO WS-DONE-FLAG.             
           MOVE 'N'                        TO WS-OUT-OF-FROM-BUCKETS.   
           MOVE 'N'                        TO WS-OUT-OF-TO-BUCKETS.     
           PERFORM 2810-PROCESS-HISTORY    THRU 2810-EXIT UNTIL         
                   WS-DONE-FLAG = WS-Y.                                 
           MOVE WS-RESULT-HIST-TAB         TO WS-RESULT-NON-UTL-CR-HST. 
           MOVE WS-RESULT-NON-UTL-ARRER-HIST TO CZ-NON-UTL-ARRER-HIST.  
           MOVE WS-RESULT-NON-UTL-CR-HST-EX  TO CZ-NON-UTL-CR-HST-EX.   
           MOVE WS-RESULT-NON-UTL-CR-HST     TO CZ-NON-UTL-CR-HST.      
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO-TO      TO WS-MH-TRAN-APPL-NO.       
           MOVE WS-TRANS-HIST-SEQ-NO-TO    TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-TO-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.            
           MOVE 'CZ-NON-UTL-ARRER-HIST'    TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-NON-UTL-ARRER-HIST   TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-NON-UTL-ARRER-HIST TO                         
                                              MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
           MOVE 'CZ-NON-UTL-CR-HST-EX'     TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-NON-UTL-CR-HST-EX    TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-NON-UTL-CR-HST-EX  TO                         
                                              MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
           MOVE 'CZ-NON-UTL-CR-HST'        TO MI-COLUMN-DESC.           
           MOVE +24                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-TO-NON-UTL-CR-HST       TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +24                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE WS-RESULT-NON-UTL-CR-HST   TO                           
                                              MI-CHG-COLUMN-VALUE-TEXT. 
           PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT.              
      *                                                                         
       2802-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2810-PROCESS-HISTORY                                          *         
      *****************************************************************         
       2810-PROCESS-HISTORY.                                            
      *                                                                         
           IF WS-FROM-SYEAR-NUM NOT EQUAL WS-TO-SYEAR-NUM               
              PERFORM 2820-EQUALIZE-YEARS THRU 2820-EXIT                
                   UNTIL WS-FROM-SYEAR-NUM EQUAL WS-TO-SYEAR-NUM        
           END-IF.                                                      
      *                                                                         
           IF WS-RESULT-SUB > 24                                        
              MOVE WS-Y TO WS-DONE-FLAG                                 
              GO TO 2810-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF WS-OUT-OF-FROM-BUCKETS = WS-Y                             
               MOVE WS-TO-HIST(WS-TO-SUB) TO                            
                    WS-RESULT-HIST(WS-RESULT-SUB)                       
               ADD 1 TO WS-TO-SUB                                       
               ADD 1 TO WS-RESULT-SUB                                   
               GO TO 2810-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF WS-OUT-OF-TO-BUCKETS = WS-Y                               
               MOVE WS-FROM-HIST(WS-FROM-SUB) TO                        
                    WS-RESULT-HIST(WS-RESULT-SUB)                       
               ADD 1 TO WS-FROM-SUB                                     
               ADD 1 TO WS-RESULT-SUB                                   
               GO TO 2810-EXIT                                          
           END-IF.                                                      
                                                                        
           IF WS-FROM-SMONTH-NUM = WS-TO-SMONTH-NUM                     
              IF WS-FROM-HIST(WS-FROM-SUB) NOT = SPACE                  
                 IF WS-TO-HIST(WS-TO-SUB) = SPACE                       
                    MOVE WS-FROM-HIST(WS-FROM-SUB) TO                   
                         WS-RESULT-HIST(WS-RESULT-SUB)                  
                 ELSE                                                   
                    MOVE WS-TO-HIST(WS-TO-SUB) TO                       
                         WS-RESULT-HIST(WS-RESULT-SUB)                  
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-TO-HIST(WS-TO-SUB) TO                          
                      WS-RESULT-HIST(WS-RESULT-SUB)                     
              END-IF                                                    
              IF WS-TO-SUB = 24                                         
                 MOVE WS-Y TO WS-OUT-OF-TO-BUCKETS                      
              ELSE                                                      
                 ADD 1 TO WS-TO-SUB                                     
              END-IF                                                    
              IF WS-FROM-SUB = 24                                       
                 MOVE WS-Y TO WS-OUT-OF-FROM-BUCKETS                    
              ELSE                                                      
                 ADD 1 TO WS-FROM-SUB                                   
              END-IF                                                    
              ADD 1 TO WS-RESULT-SUB                                    
           ELSE                                                         
              IF WS-FROM-SMONTH-NUM < WS-TO-SMONTH-NUM                  
                 MOVE WS-TO-HIST(WS-TO-SUB) TO                          
                      WS-RESULT-HIST(WS-RESULT-SUB)                     
                 ADD 1 TO WS-TO-SUB                                     
                 ADD 1 TO WS-RESULT-SUB                                 
                 ADD 1 TO WS-FROM-SMONTH-NUM                            
              ELSE                                                      
                 ADD 1 TO WS-FROM-SUB                                   
                 SUBTRACT 1 FROM WS-FROM-SMONTH-NUM                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2820-EQUALIZE-YEARS                                           *         
      *****************************************************************         
       2820-EQUALIZE-YEARS.                                             
      *                                                                         
           IF WS-TO-SYEAR-NUM > WS-FROM-SYEAR-NUM                       
              MOVE WS-TO-HIST(WS-TO-SUB) TO                             
                                         WS-RESULT-HIST(WS-RESULT-SUB)  
              ADD 1                      TO WS-TO-SUB                   
              ADD 1                      TO WS-RESULT-SUB               
              MOVE WS-TO-SYEAR-NUM       TO WS-HOLD-SYEAR-NUM           
              MOVE WS-TO-SMONTH-NUM      TO WS-HOLD-SMONTH-NUM          
              PERFORM 2830-RECALC-DATE   THRU 2830-EXIT                 
              MOVE WS-HOLD-SYEAR-NUM     TO WS-TO-SYEAR-NUM             
              MOVE WS-HOLD-SMONTH-NUM    TO WS-TO-SMONTH-NUM            
           ELSE                                                         
              ADD 1                      TO WS-FROM-SUB                 
              MOVE WS-FROM-SYEAR-NUM     TO WS-HOLD-SYEAR-NUM           
              MOVE WS-FROM-SMONTH-NUM    TO WS-HOLD-SMONTH-NUM          
              PERFORM 2830-RECALC-DATE   THRU 2830-EXIT                 
              MOVE WS-HOLD-SYEAR-NUM     TO WS-FROM-SYEAR-NUM           
              MOVE WS-HOLD-SMONTH-NUM    TO WS-FROM-SMONTH-NUM          
           END-IF.                                                      
      *                                                                         
       2820-EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 2830-RECALC-DATE                                              *         
      *****************************************************************         
       2830-RECALC-DATE.                                                
      *                                                                         
           IF WS-HOLD-SMONTH-NUM = 1                                    
              SUBTRACT 1 FROM WS-HOLD-SYEAR-NUM                         
              MOVE 12 TO WS-HOLD-SMONTH-NUM                             
           ELSE                                                         
              SUBTRACT 1 FROM WS-HOLD-SMONTH-NUM                        
           END-IF.                                                      
      *                                                                         
       2830-EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 2900-UNSET-XFER-FORWARD-FLAGS                                 *         
      *****************************************************************         
       2900-UNSET-XFER-FORWARD-FLAG.                                    
      *                                                                         
           MOVE WS-FROM-ACCOUNT-NO-NUM  TO MH-ACCOUNT-NO                
                                           AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT.                 
           MOVE WS-MH-TRAN-APPL-NO-FROM TO WS-MH-TRAN-APPL-NO.          
           MOVE WS-TRANS-HIST-SEQ-NO-FROM TO MH-TRANS-HIST-SEQ-NO.      
           MOVE SPACES                  TO MI-TABLE-ID.                 
           MOVE 'TRANSFER IND'          TO MI-COLUMN-DESC.              
           MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE AT-AR-XFER-IND          TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE SPACES                  TO AT-AR-XFER-IND.              
           MOVE AT-AR-XFER-IND          TO MI-CHG-COLUMN-VALUE-TEXT.    
           PERFORM 5010-MNT-HST-DETAIL  THRU 5010-EXIT.                 
           MOVE 'XFER IND TO ACCT'      TO MI-COLUMN-DESC.              
           MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE WS-XFER-TO-ACCOUNT      TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +13                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE ZEROES                  TO AT-ACCT-XFER-TO.             
           MOVE AT-ACCT-XFER-TO         TO MI-CHG-COLUMN-VALUE-TEXT.    
           PERFORM 5010-MNT-HST-DETAIL  THRU 5010-EXIT.                 
           MOVE WS-MH-TRAN-APPL-NO      TO WS-MH-TRAN-APPL-NO-FROM.     
           MOVE ZEROES                  TO AT-ACCT-XFER-FROM-LST.       
           MOVE MH-TRANS-HIST-SEQ-NO    TO AT-LAST-UPDATE-TS.           
           PERFORM 8200-UPDATE-ACCOUNT  THRU 8200-EXIT.                 
           MOVE WS-XFER-TO-ACCOUNT      TO AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT.                 
           PERFORM 2976-PROCESS-XFER-TO-MNT-JRNL THRU 2976-EXIT.        
           MOVE SPACES                  TO AT-AR-XFER-IND.              
           MOVE ZEROES                  TO AT-ACCT-XFER-TO.             
           MOVE ZEROES                  TO AT-ACCT-XFER-FROM-LST.       
           MOVE MH-TRANS-HIST-SEQ-NO    TO AT-LAST-UPDATE-TS.           
           PERFORM 8200-UPDATE-ACCOUNT  THRU 8200-EXIT.                 
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2910-SET-XFER-FORWARD-FLAG                                    *         
      *****************************************************************         
       2910-SET-XFER-FORWARD-FLAG.                                      
      *                                                                         
           PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT.        
           MOVE WS-Y                    TO AT-AR-XFER-IND.              
           MOVE WS-TO-ACCOUNT-NO-NUM    TO AT-ACCT-XFER-TO.             
           MOVE MH-TRANS-HIST-SEQ-NO    TO AT-LAST-UPDATE-TS.           
           PERFORM 8200-UPDATE-ACCOUNT  THRU 8200-EXIT.                 
           MOVE WS-TO-ACCOUNT-NO-NUM    TO AT-ACCOUNT-NO.               
           PERFORM 7200-SELECT-ACCOUNT  THRU 7200-EXIT.                 
           PERFORM 2975-PROCESS-TO-MNT-JOURNAL THRU 2975-EXIT.          
           MOVE SPACES                  TO AT-AR-XFER-IND.              
           MOVE WS-FROM-ACCOUNT-COMP3   TO AT-ACCT-XFER-FROM-LST.       
           MOVE MH-TRANS-HIST-SEQ-NO    TO AT-LAST-UPDATE-TS.           
           PERFORM 8200-UPDATE-ACCOUNT  THRU 8200-EXIT.                 
      *                                                                         
       2910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2920-TRANSFER-DEPOSIT-WAIVER                                  *         
      *****************************************************************         
       2920-TRANSFER-DEPOSIT-WAIVER.                                    
      *                                                                         
           MOVE WS-FROM-ACCOUNT-COMP3 TO SB-ACCOUNT-NO.                 
           PERFORM 7400-OPEN-SURETY-BOND THRU 7400-EXIT.                
           PERFORM 7410-FETCH-SURETY-BOND THRU 7410-EXIT                
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2950-PROCESS-FROM-MNT-JOURNAL THRU 2950-EXIT      
      ****** TRANSFER THE DETAILS ******                                12910000
              MOVE WS-TO-ACCOUNT-NO-NUM       TO SB-ACCOUNT-NO          
              PERFORM 8350-INSERT-SURETY-BOND THRU 8350-EXIT            
              MOVE 'Y'                        TO WS-WAIVER-INSERTED     
              MOVE WS-FROM-ACCOUNT-COMP3      TO SB-ACCOUNT-NO          
              PERFORM 8360-DELETE-SURETY-BOND THRU 8360-EXIT            
      ****** UPDATE CODES-DATA-PRESENT DETAILS ** FROM ACCOUNT ***      12970000
              MOVE WS-FROM-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO              
              PERFORM 7205-SELECT-CODE-DATA-PRESENT THRU 7205-EXIT      
              MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT      
              MOVE SPACES                 TO WS-CODE-SEC-ACCT           
              MOVE WS-CODES-DATA-PRESENT  TO AT-CODES-DATA-PRESENT      
              PERFORM 8365-UPDATE-CODE-DATA-PRESENT THRU 8365-EXIT      
      ****** UPDATE CODES-DATA-PRESENT DETAILS ** TO ACCOUNT ***        12970000
              MOVE WS-TO-ACCOUNT-NO-NUM  TO AT-ACCOUNT-NO               
              PERFORM 7205-SELECT-CODE-DATA-PRESENT THRU 7205-EXIT      
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
              MOVE 'A'                      TO WS-CODE-SEC-ACCT         
              MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT       
              PERFORM 8365-UPDATE-CODE-DATA-PRESENT THRU 8365-EXIT      
      *                                                                         
              PERFORM 2975-PROCESS-TO-MNT-JOURNAL THRU 2975-EXIT        
              PERFORM 7410-FETCH-SURETY-BOND THRU 7410-EXIT             
           END-PERFORM.                                                 
           PERFORM 7420-CLOSE-SURETY-BOND THRU 7420-EXIT.               
      *                                                                         
      **DELETE 'SYSTEM TRANSFER' WAIVER IF EXISTS ON XFER-TO ACCT IF****        
      **SECURITIES WERE TRANSFERRED*************************************        
           MOVE WS-TO-ACCOUNT-NO-NUM TO SB-ACCOUNT-NO.                  
           IF WS-WAIVER-INSERTED = 'Y'                                  
              PERFORM 8355-DEL-SYS-WAIVER      THRU 8355-EXIT           
           END-IF.                                                      
      *                                                                         
       2920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2930-REMOVE-FROM-ACCT-ARCHVD                                  *         
      *****************************************************************         
       2930-REMOVE-FROM-ACCT-ARCHVD.                                    
      *                                                                         
           MOVE WS-FROM-ACCOUNT-COMP3  TO AT-ACCOUNT-NO.                
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           MOVE AT-ACCT-XFER-FROM-LST  TO WS-FR-ACCT-XFER-FROM-LST.     
      *                                                                         
           MOVE ZEROES                 TO AT-ACCT-XFER-FROM-LST.        
           PERFORM 8200-UPDATE-ACCOUNT THRU 8200-EXIT.                  
           MOVE ZEROES                 TO WS-FR-ACCT-XFER-FROM-LST.     
      *                                                                         
       2930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2940-REMOVE-TO-ACCT-ARCHVD                                    *         
      *****************************************************************         
       2940-REMOVE-TO-ACCT-ARCHVD.                                      
      *                                                                         
           MOVE WS-FROM-ACCOUNT-COMP3  TO AT-ACCOUNT-NO.                
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
      *                                                                         
           MOVE SPACES                   TO AT-AR-XFER-IND.             
           MOVE ZEROES                   TO AT-ACCT-XFER-TO.            
           PERFORM 8200-UPDATE-ACCOUNT   THRU 8200-EXIT.                
           MOVE SPACE                    TO WS-FR-AR-XFER-IND.          
           MOVE ZEROES                   TO WS-FR-ACCT-XFER-TO.         
      *                                                                         
       2940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 2950  MAINTENANCE JOURNAL FOR FROM ACCOUNT                *             
      *************************************************************             
       2950-PROCESS-FROM-MNT-JOURNAL.                                   
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO-FROM    TO WS-MH-TRAN-APPL-NO.       
           MOVE WS-TRANS-HIST-SEQ-NO-FROM  TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-FROM-ACCOUNT-NO-NUM     TO MH-ACCOUNT-NO.            
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE SPACES                     TO MI-COLUMN-DESC.           
           MOVE +13                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE +13                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-TABLE-ID.              
      *                                                                         
           EVALUATE WS-CURRENT-TASK                                     
            WHEN 'FAR'                                                  
              MOVE 'ACCT XFER FROM LST'     TO MI-COLUMN-DESC           
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*ARCHIVED*'             TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-FR-ACCT-XFER-FROM-LST TO MI-PRV-COLUMN-VALUE-TEXT 
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
            WHEN 'TAR'                                                  
              MOVE 'ACCT XFER FROM LST'     TO MI-COLUMN-DESC           
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*ARCHIVED*'             TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-FR-ACCT-XFER-TO       TO MI-PRV-COLUMN-VALUE-TEXT 
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
              MOVE 'AR XFER IND'            TO MI-COLUMN-DESC           
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-FR-AR-XFER-IND        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*ARCHIVED*'             TO MI-CHG-COLUMN-VALUE-TEXT 
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
            WHEN 'STF'                                                  
              MOVE 'XFER IND TO ACC'        TO MI-COLUMN-DESC           
              MOVE PARM-TO-ACCOUNT-NO       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-ACCT-XFER-TO          TO MI-PRV-COLUMN-VALUE-TEXT 
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
              MOVE 'TRANSFER IND'           TO MI-COLUMN-DESC           
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE AT-AR-XFER-IND           TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE 'Y'                      TO MI-CHG-COLUMN-VALUE-TEXT 
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
            WHEN 'WAV'                                                  
              MOVE 'WAIVER BOND TYP'     TO MI-COLUMN-DESC              
              MOVE LENGTH OF SB-BOND-NO  TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE SB-BOND-NO            TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*TRANSFERRED*'       TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 5010-MNT-HST-DETAIL   THRU 5010-EXIT              
           END-EVALUATE.                                                
      *                                                                         
           IF WS-MH-TRAN-APPL-NO = 1                                    
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE WS-MH-TRAN-APPL-NO     TO MI-TRAN-APPL-NO            
              PERFORM 5010-MNT-HST-DETAIL THRU 5010-EXIT                
************** RESET MH-TRAN-COMMENT FOR "TO" ACCOUNT AFTER  ********   06430600
************** BEING CHANGE IN 5015-NO-AR-XFER-MNT-HST-DET.  ********   06430600
              MOVE SPACES TO MH-TRAN-COMMENT-TEXT                       
                             WS-4595-TRAN-COMMENT                       
              MOVE ZEROES TO MH-TRAN-COMMENT-LEN                        
              MOVE 1      TO WS-4595-TRAN-COMMENT-LEN                   
              STRING PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
                    INTO MH-TRAN-COMMENT-TEXT WITH POINTER              
                       WS-4595-TRAN-COMMENT-LEN                         
              MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN      
           END-IF.                                                      
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO TO WS-MH-TRAN-APPL-NO-FROM.          
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 2975-PROCESS-TO-MNT-JOURNAL.                              *             
      *************************************************************             
       2975-PROCESS-TO-MNT-JOURNAL.                                     
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO-TO      TO WS-MH-TRAN-APPL-NO.       
           MOVE WS-TRANS-HIST-SEQ-NO-TO    TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-TO-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.            
           MOVE SPACES                     TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +13                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE +13                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-TABLE-ID.              
      *                                                                         
           IF WS-CURRENT-TASK = 'STF'                                   
              MOVE 'XFER IND FR ACC'       TO MI-COLUMN-DESC            
              MOVE WS-FROM-ACCOUNT-NO      TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE AT-ACCT-XFER-FROM-LST   TO MI-PRV-COLUMN-VALUE-TEXT  
              PERFORM 5010-MNT-HST-DETAIL  THRU 5010-EXIT               
           END-IF.                                                      
      *                                                                         
           IF WS-CURRENT-TASK = 'WAV'                                   
               MOVE 'WAIVER BOND TYP'    TO MI-COLUMN-DESC              
               MOVE LENGTH OF SB-BOND-NO TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE SB-BOND-NO           TO MI-CHG-COLUMN-VALUE-TEXT    
               MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE '*TRANSFERRED*'      TO MI-PRV-COLUMN-VALUE-TEXT    
               PERFORM 5010-MNT-HST-DETAIL THRU 5010-EXIT               
           END-IF.                                                      
      *                                                                         
           IF WS-MH-TRAN-APPL-NO = 1                                    
               MOVE SPACES                 TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE SPACES                 TO MI-PRV-COLUMN-VALUE-TEXT  
               PERFORM 5010-MNT-HST-DETAIL THRU 5010-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE WS-MH-TRAN-APPL-NO TO WS-MH-TRAN-APPL-NO-TO.            
      *                                                                         
       2975-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 2976-PROCESS-XFER-TO-MNT-JRNL.                            *             
      *************************************************************             
       2976-PROCESS-XFER-TO-MNT-JRNL.                                   
      *                                                                         
           PERFORM 7300-GET-TIMESTAMP THRU 7300-EXIT.                   
           MOVE +1                         TO WS-MH-TRAN-APPL-NO.       
           MOVE WS-XFER-TO-ACCOUNT         TO MH-ACCOUNT-NO.            
           MOVE SPACES                     TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE +13                        TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE +13                        TO MI-CHG-COLUMN-VALUE-LEN.  
           MOVE SPACES                     TO MI-TABLE-ID.              
      *                                                                         
           MOVE 'XFER IND FR ACC'      TO MI-COLUMN-DESC.               
           MOVE '0000000000000'        TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE AT-ACCT-XFER-FROM-LST  TO MI-PRV-COLUMN-VALUE-TEXT.     
           PERFORM 5010-MNT-HST-DETAIL THRU 5010-EXIT.                  
      *                                                                         
           IF WS-MH-TRAN-APPL-NO = 1                                    
               MOVE SPACES                 TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE SPACES                 TO MI-PRV-COLUMN-VALUE-TEXT  
               PERFORM 5010-MNT-HST-DETAIL THRU 5010-EXIT               
           END-IF.                                                      
      *                                                                         
       2976-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 5000  PREPARE MAINTENANCE JOURNAL AND INSERT.             *             
      *************************************************************             
       5000-MAINTENANCE-HISTORY.                                        
      *                                                                         
           PERFORM 7300-GET-TIMESTAMP THRU 7300-EXIT.                   
           MOVE WS-F                  TO MH-CODE-TRAN-TYPE.             
           MOVE PARM-RESP-AREA-ID     TO MH-RESP-AREA-ID.               
           MOVE AT-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
           MOVE ZEROS                 TO MH-CUSTOMER-NO.                
           MOVE ZEROS                 TO MH-PREMISE-NO.                 
           MOVE PARM-USER-ID          TO MH-USER-ID.                    
           MOVE +1                    TO WS-MH-TRAN-APPL-NO.            
           MOVE 'CSR04595F'           TO MH-APPL-PROGRAM-ID.            
           MOVE 1                     TO WS-4595-TRAN-COMMENT-LEN.      
           MOVE SPACES                TO MH-TRAN-COMMENT-TEXT.          
      *                                                                         
           IF WS-25-ACCT-NO-FROM = MH-ACCOUNT-NO AND                    
              PARM-SELECT-REC1 = SPACES AND                             
              (PARM-UTL-CRED-HIST = 'Y' OR                              
              PARM-NON-UTL-CRED-HIST = 'Y') AND                         
              (PARM-SET-TRANSFER-FORWARD-FLAG = 'N' OR ' ') AND         
              PARM-PAID-DEPOSIT-TRANSFER = 'N' AND                      
              PARM-DEPOSIT-WAIVER = 'N' AND                             
              PARM-FROM-ACCT-ARCHIVED = 'N' AND                         
              PARM-TO-ACCT-ARCHIVED = 'N'                               
                 STRING 'TRANSFER TO '                                  
                        WS-25-ACCT-NO-TO                                
                        '  '                                           
                        PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                        PARM-TO-NAME-ADDRESS DELIMITED BY WS-DELIMITER  
                       INTO MH-TRAN-COMMENT-TEXT WITH POINTER           
                          WS-4595-TRAN-COMMENT-LEN                      
                 MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN   
                 PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT      
           ELSE                                                         
                 STRING PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                       INTO MH-TRAN-COMMENT-TEXT WITH POINTER           
                          WS-4595-TRAN-COMMENT-LEN                      
                 MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN   
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 5010-MNT-HST-DETAIL                                       *             
      *************************************************************             
       5010-MNT-HST-DETAIL.                                             
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-MH-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.        
      *                                                                         
           IF PARM-SELECT-REC1 = SPACES                                 
             AND PARM-PAID-DEPOSIT-TRANSFER = 'N'                       
              PERFORM 5015-NO-AR-XFER-MNT-HST-DET THRU 5015-EXIT        
              GO TO 5010-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                             TO WS-MH-TRAN-APPL-NO.     
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 5015-NO-AR-XFER-MNT-HST-DET                               *             
      * THIS PARAGRAPH WRITES A MNT ROW FOR THOSE TRANSFERS WHERE *             
      * NO RECEIVABLE ARE TRANSFERRED.                            *             
      *************************************************************             
       5015-NO-AR-XFER-MNT-HST-DET.                                     
      *                                                                         
           MOVE SPACES TO MH-TRAN-COMMENT-TEXT                          
                          WS-4595-TRAN-COMMENT.                         
           MOVE ZEROES TO  MH-TRAN-COMMENT-LEN.                         
           MOVE 1      TO  WS-4595-TRAN-COMMENT-LEN.                    
      *                                                                         
ACT257*  THE FIRST IF CHECK FOR UNSET & SET TRANSFER FORWARD FLAG               
ACT257*  WITH NO RECEIVABLES AND NO CREDIT HISTORY TRANSFER AND NO              
ACT257*  PAID DEPOSIT TRANSFER AND NO DEPOSIT WAIVER TRANSFER.                  
ACT257*  THE ELSE CHECKS FOR IF TO ACCOUNT ELSE FROM ACCOUNT.                   
ACT257     IF PARM-SELECT-REC1 = SPACES AND                             
ACT257         ((PARM-SET-TRANSFER-FORWARD-FLAG = 'N' OR 'Y') OR        
ACT257           PARM-FROM-ACCT-ARCHIVED = 'Y' OR                       
ACT257           PARM-TO-ACCT-ARCHIVED = 'Y') AND                       
ACT257           PARM-UTL-CRED-HIST = 'N' AND                           
ACT257           PARM-NON-UTL-CRED-HIST = 'N' AND                       
ACT257           PARM-PAID-DEPOSIT-TRANSFER = 'N' AND                   
ACT257           PARM-DEPOSIT-WAIVER = 'N'                              
ACT257        IF WS-25-ACCT-NO-TO = MH-ACCOUNT-NO                       
ACT257             STRING                                               
ACT257               PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
ACT257               PARM-FROM-NAME-ADDRESS DELIMITED BY WS-DELIMITER   
ACT257               INTO WS-4595-TRAN-COMMENT WITH POINTER             
ACT257               WS-4595-TRAN-COMMENT-LEN                           
ACT257        ELSE                                                      
ACT257             STRING                                               
ACT257               PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
ACT257               PARM-TO-NAME-ADDRESS DELIMITED BY WS-DELIMITER     
ACT257               INTO WS-4595-TRAN-COMMENT WITH POINTER             
ACT257               WS-4595-TRAN-COMMENT-LEN
              END-IF                           
           ELSE                                                         
              IF WS-25-ACCT-NO-TO = MH-ACCOUNT-NO                       
                  STRING 'TRANSFER FROM '                               
                    WS-25-ACCT-NO-FROM                                  
                    '  '                                               
                    PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER         
                    PARM-FROM-NAME-ADDRESS DELIMITED BY WS-DELIMITER    
                    INTO WS-4595-TRAN-COMMENT WITH POINTER              
                    WS-4595-TRAN-COMMENT-LEN                            
              ELSE                                                      
                  STRING 'TRANSFER TO '                                 
                     WS-25-ACCT-NO-TO                                   
                     '  '                                              
                     PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
                     PARM-TO-NAME-ADDRESS DELIMITED BY WS-DELIMITER     
                     INTO WS-4595-TRAN-COMMENT WITH POINTER             
                     WS-4595-TRAN-COMMENT-LEN                           
              END-IF                                                    
ACT257     END-IF.                                                      
      *                                                                         
           MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN.        
           IF MH-TRAN-COMMENT-LEN > 210                                 
              MOVE +210 TO MH-TRAN-COMMENT-LEN                          
           END-IF.                                                      
           MOVE WS-4595-TRAN-COMMENT TO MH-TRAN-COMMENT-TEXT.           
      *                                                                         
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                             TO WS-MH-TRAN-APPL-NO.     
      *                                                                         
       5015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 5020-NO-AR-XFER-MNT-HST-DET                               *             
      * THIS PARAGRAPH UPDATES THE MNT ROW ON THE FROM ACCOUNT    *             
      * WHERE NO MONIES ARE TRANSFERED.                           *             
      *************************************************************             
       5020-NO-AR-XFER-MNT-HST-DET.                                     
      *                                                                         
           IF PARM-SELECT-REC1 = SPACES                                 
             AND PARM-PAID-DEPOSIT-TRANSFER = 'N'                       
              GO TO 5020-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF WS-AR-TRANSFER-FROM = 'N'                                 
              MOVE SPACES TO MH-TRAN-COMMENT-TEXT                       
                             WS-4595-TRAN-COMMENT                       
              MOVE ZEROES TO  MH-TRAN-COMMENT-LEN                       
              MOVE 1      TO  WS-4595-TRAN-COMMENT-LEN                  
      *                                                                         
              STRING 'TRANSFER TO '                                     
                     WS-25-ACCT-NO-TO                                   
                     PARM-AR-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                     PARM-TO-NAME-ADDRESS DELIMITED BY WS-DELIMITER     
                     '  '                                              
                     PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
                     INTO WS-4595-TRAN-COMMENT WITH POINTER             
                     WS-4595-TRAN-COMMENT-LEN                           
      *                                                                         
              MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN      
              IF MH-TRAN-COMMENT-LEN > 210                              
                 MOVE +210 TO MH-TRAN-COMMENT-LEN                       
              END-IF                                                    
              MOVE WS-4595-TRAN-COMMENT      TO MH-TRAN-COMMENT-TEXT    
              MOVE WS-FROM-ACCOUNT-NO-NUM    TO MH-ACCOUNT-NO           
              MOVE WS-TRANS-HIST-SEQ-NO-FROM TO MH-TRANS-HIST-SEQ-NO    
              PERFORM 8270-UPDT-MNT-TRANS-HIST THRU 8270-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-AR-TRANSFER-TO = 'N'                                   
              MOVE SPACES TO MH-TRAN-COMMENT-TEXT                       
                             WS-4595-TRAN-COMMENT                       
              MOVE ZEROES TO  MH-TRAN-COMMENT-LEN                       
              MOVE 1      TO  WS-4595-TRAN-COMMENT-LEN                  
      *                                                                         
              STRING 'TRANSFER FROM '                                   
                     WS-25-ACCT-NO-FROM                                 
                     PARM-AR-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                     PARM-FROM-NAME-ADDRESS DELIMITED BY WS-DELIMITER   
                     '  '                                              
                     PARM-TRAN-COMMENT DELIMITED BY WS-DELIMITER        
                     INTO WS-4595-TRAN-COMMENT WITH POINTER             
                     WS-4595-TRAN-COMMENT-LEN                           
      *                                                                         
              MOVE WS-4595-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN      
              IF MH-TRAN-COMMENT-LEN > 210                              
                 MOVE +210 TO MH-TRAN-COMMENT-LEN                       
              END-IF                                                    
              MOVE WS-4595-TRAN-COMMENT    TO MH-TRAN-COMMENT-TEXT      
              MOVE WS-TO-ACCOUNT-NO-NUM    TO MH-ACCOUNT-NO             
              MOVE WS-TRANS-HIST-SEQ-NO-TO TO MH-TRANS-HIST-SEQ-NO      
              PERFORM 8270-UPDT-MNT-TRANS-HIST THRU 8270-EXIT           
           END-IF.                                                      
      *                                                                         
       5020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5250-CALL-CSR00125.                                            *        
      ******************************************************************        
       5250-CALL-CSR00125.                                              
      *                                                                         
           INITIALIZE WS-CSR00125-RET-AREA.                             
      *                                                                         
      *    EXEC SQL CALL CSR00125                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:PARM-SO-PREMISE-NO                            
      *                 ,:PARM-USER-ID                                  
      *                 ,:WS-REMARKS-TX                                 
      *                 ,:PARM-SO-UPDATE-REMARKS                        
      *                 ,:WS-UPDATE                                     
      *                 ,:WS-PANEL-NO                                   
      *                 ,:PARM-SO-ORDER-TYPE-FLAG                       
      *                 ,:PARM-SO-DNP-CANCEL-REASON                     
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_DNP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_DNP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_DNP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE -1                         TO WS-ACTIVE-RETURN-CODE 
               MOVE '5250'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE 'CSR00125'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT           
           END-IF.                                                      
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5300-FETCH-CSR00125.                                           *        
      ******************************************************************        
       5300-FETCH-CSR00125.                                             
      *                                                                         
           EXEC SQL                                                     
           FETCH CANCEL_DNP INTO                                        
                    :WS-SO-RETURN-CD-BD                                 
                   ,:WS-SERV-ORDER-CHAR-BD                              
                   ,:WS-ORDER-REASON-BD                                 
                   ,:WS-RESP-AREA-ID-BD                                 
                   ,:WS-PENDING-DNP-FLAG-BD                             
                   ,:WS-INSERT-WORK-QUEUE-BD                            
                   ,:WS-AMOUNT-DISC-BAL                                 
                   ,:WS-ORDER-TYPE-CD-BD                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5300'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5350-CLOSE-CSR00125.                                           *        
      ******************************************************************        
       5350-CLOSE-CSR00125.                                             
      *                                                                         
           EXEC SQL                                                     
             CLOSE CANCEL_DNP                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5350'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR00125'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5360-CALL-CSR02122.                                            *        
      ******************************************************************        
      *                                                                         
       5360-CALL-CSR02122.                                              
      *                                                                         
           INITIALIZE WS-CSR02122-RET-AREA.                             
      *                                                                         
      *    EXEC SQL CALL CSR02122                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:PARM-SO-PREMISE-NO                            
      *                 ,:WS-ORDER-REASON-BD                            
      *                 ,:PARM-SO-DNP-CANCEL-REASON                     
      *                 ,:WS-PENDING-DNP-FLAG-BD                        
      *                 ,:WS-UPDATE-PROFILE                             
      *                 ,:WS-AMOUNT-DISC-BAL                            
      *                 ,:WS-PANEL-NO                                   
      *                 ,:WS-ORDER-TYPE-CD-BD                           
      *                 ,:WS-REMARKS-TX                                 
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR UPDATE_ACCT_TB INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE -1                         TO WS-ACTIVE-RETURN-CODE 
               MOVE '5360'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE 'CSR02122'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT           
           END-IF.                                                      
      *                                                                         
       5360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5370-FETCH-CSR02122.                                           *        
      ******************************************************************        
       5370-FETCH-CSR02122.                                             
      *                                                                         
           EXEC SQL                                                     
           FETCH UPDATE_ACCT_TB INTO                                    
                    :WS-2122-RETURN-CODE                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5370'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5380-CLOSE-CSR02122.                                           *        
      ******************************************************************        
       5380-CLOSE-CSR02122.                                             
      *                                                                         
           EXEC SQL                                                     
             CLOSE UPDATE_ACCT_TB                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5380'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR02122'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       5380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  CALLS SCSCA182 TO GET THE LAST UPDATED TIMESTAMP              *        
      ******************************************************************        
       5400-LINK-SCSCA182.                                              
      *                                                                         
           MOVE '5400' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           INITIALIZE SCSCA182-LINK-RECORD                              
           MOVE PARM-FROM-ACCOUNT-NO         TO WS-ACCOUNT-NO           
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-COMP3        
           MOVE WS-ACCOUNT-COMP3             TO SCSCA182-ACCOUNT-NO     
      *                                                                         
           CALL MCSCA182  USING    SCSCA182-ACCOUNT-NO                  
                                  ,SCSCA182-RETURN-CODE                 
                                  ,SCSCA182-LAST-UPDATE-TS              
                                  ,ABEND-FILE.                          
      *                                                                         
           IF SCSCA182-RETURN-CODE NOT = ZERO                           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SCSCA182-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE   
                                                SQLCODE                 
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-LINK-SCSCO068.                                            *        
      *    CALLS THE THE SUBPROGRAM SCSCO068.                          *        
      ******************************************************************        
       5500-LINK-SCSCO068.                                              
      *                                                                         
           MOVE 'Y' TO CALC-DNP-BAL-SW                                  
                       CALC-PAST-DUE-SW                                 
                       CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       CALC-NOT-BAL-SW.                                 
      *                                                                         
           MOVE SPACES TO ABEND-FUNCTION .                              
      *                                                                         
           CALL WS-MCSCB068 USING CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
      *                                                                         
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                  S-RETURN-CODE                         
                                  SQLCODE.                              
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
               IF ABEND-FUNCTION EQUAL 'BADDATA'                        
                   MOVE 'CMN0000018'          TO S-BUS-RULE-ID          
                   MOVE 'F'                   TO S-BUS-RULE-RESULT-CD   
                   IF S-BUS-RULE-ID > SPACES                            
                       PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT     
                   END-IF                                               
               END-IF                                                   
               PERFORM 8900-SEND-DONE         THRU 8900-EXIT            
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9999-END-PROGRAM       THRU 9999-EXIT            
           END-IF.                                                      
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5600-LOAD-GL-NUMBERS                                          *         
      *****************************************************************         
       5600-LOAD-GL-NUMBERS.                                            
      *                                                                         
           MOVE SPACES TO ABEND-FUNCTION.                               
      *                                                                         
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
      *                                                                         
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                  S-RETURN-CODE                         
                                  SQLCODE.                              
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1 TO RS-RETURN-CODE                              
                            S-RETURN-CODE                               
                            WS-ACTIVE-RETURN-CODE                       
              END-IF                                                    
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
              UNTIL WS-VALID-CO-SUB > 5                                 
                 OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'             
                    OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99      
              IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                
                 MOVE WS-Y TO WS-COMPANY-IN-TABLE                       
              END-IF                                                    
           END-PERFORM.                                                 
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *5700-CALL-MCSCB371.                                                      
      *MCSCB371 UPDATES DNP-BALANCE RETURNED BY CPD00068.                       
      *IF MCSCB371 FAILS, INSERT 'U' ROW IN CSS_SO_DNP_CANCEL TABLE             
      *TO BE PROCESSED BY BATCH PROGRAM.                                        
      *****************************************************************         
       5700-CALL-MCSCB371.                                              
      *                                                                         
           MOVE SPACES TO ABEND-FUNCTION.                               
           MOVE ZERO   TO RS-RETURN-CODE.                               
      *                                                                         
           CALL MCSCB371      USING  AT-ACCOUNT-NO,                     
                                     AT-DATE-BILL-DAY-00,               
                                     AT-CREDIT-GROUP,                   
                                     WS-CPD68-DNP-BAL,                  
                                     ABEND-FILE,                        
                                     RS-RETURN-CODE.                    
      *                                                                         
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
           IF ABEND-FUNCTION > SPACES OR WS-ACTIVE-RETURN-CODE NOT      
                                      EQUAL SUCCESSFUL-CALL             
              PERFORM 8610-INSERT-SO-DNP-CANCEL THRU 8610-EXIT          
           END-IF.                                                      
      *                                                                         
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      * 5900-NEXT-BILL-DATE                                       *             
      *************************************************************             
            EXEC SQL                                                            
               INCLUDE CPD00309                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6500-ONLINE-LOAD-AR-TRAN-HIST                                  *        
      ******************************************************************        
       6500-ONLINE-LOAD-AR-TRAN-HIST.                                   
           MOVE '6500' TO ACTIVE-PARAGRAPH.                             
           IF WS-JUST-DFA = 'Y' AND WS-25-ACCT-NO-TO = AR-ACCOUNT-NO    
              MOVE 'N' TO WS-JUST-DFA                                   
              MOVE +1  TO WS-TRAN-APPL-NO                               
                          AU-TRAN-APPL-NO                               
           END-IF.                                                      
           IF (WS-JUST-FROM-DFA = 'Y'                                   
             OR (PARM-TRANSFER-TYPE = 'CNT'                             
             AND WS-SAVE-SEL-REC-AMOUNT = 0 ))                          
             AND PARM-PAID-DEPOSIT-TRANSFER NOT = 'Y'                   
             AND WS-25-ACCT-NO-FROM = AR-ACCOUNT-NO                     
              MOVE 'N' TO WS-JUST-FROM-DFA                              
              MOVE +1  TO WS-TRAN-APPL-NO                               
                          AU-TRAN-APPL-NO                               
           END-IF.                                                      
           IF AU-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6510-INSERT-AR-TRANS-HIST THRU 6510-EXIT          
              IF (PARM-TRANSFER-TYPE NOT = 'DEP'                        
               AND WS-25-ACCT-NO-TO NOT = AR-ACCOUNT-NO) AND            
                 (PARM-TRANSFER-STYLE NOT = 'L')                        
                 MOVE WS-25-ACCT-NO-TO TO AR-ACCOUNT-NO                 
                 PERFORM 6510-INSERT-AR-TRANS-HIST THRU 6510-EXIT       
              END-IF                                                    
              IF AU-AMT-POSTED = 0 AND AU-CODE-AR-AGE = '0'             
                 NEXT SENTENCE                                          
              ELSE                                                      
                 PERFORM 6520-INSERT-AR-TRANS-DETL THRU 6520-EXIT       
              END-IF                                                    
           ELSE                                                         
              IF AU-AMT-POSTED = 0 AND AU-CODE-AR-AGE = '0'             
                 NEXT SENTENCE                                          
              ELSE                                                      
                 PERFORM 6520-INSERT-AR-TRANS-DETL THRU 6520-EXIT       
              END-IF                                                    
              PERFORM 6515-UPDATE-AR-TRANS-HIST THRU 6515-EXIT          
           END-IF.                                                      
           IF (PARM-TRANSFER-TYPE = 'DEP'                               
              OR WS-25-TYPE-TO-XFER = 'DEP')                            
             AND WS-25-ACCT-NO-TO = AR-ACCOUNT-NO                       
              MOVE AU-TRAN-APPL-NO TO WS-25-TRAN-APPL-NO                
           END-IF.                                                      
      *                                                                 00694300
       6500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00694300
      ******************************************************************        
      * 6510-INSERT-AR-TRANS-HIST                                      *        
      ******************************************************************        
       6510-INSERT-AR-TRANS-HIST.                                       
           MOVE '6510' TO ACTIVE-PARAGRAPH.                             
           MOVE SPACES TO AR-TRAN-COMMENT-TEXT                          
                          WS-4595-TRAN-COMMENT.                         
           MOVE ZEROES TO  AR-TRAN-COMMENT-LEN.                         
           MOVE 1      TO  WS-4595-TRAN-COMMENT-LEN.                    
      *                                                                 00694300
           IF WS-25-ACCT-NO-TO = AR-ACCOUNT-NO                          
              MOVE 'Y' TO WS-AR-TRANSFER-TO                             
              STRING 'TRANSFER FROM '                                   
                     WS-25-ACCT-NO-FROM                                 
                     PARM-AR-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                     PARM-FROM-NAME-ADDRESS DELIMITED BY WS-DELIMITER   
                   INTO WS-4595-TRAN-COMMENT WITH POINTER               
                      WS-4595-TRAN-COMMENT-LEN                          
           ELSE                                                         
              MOVE 'Y' TO WS-AR-TRANSFER-FROM                           
              STRING 'TRANSFER TO '                                     
                     WS-25-ACCT-NO-TO                                   
                     PARM-AR-TRAN-COMMENT DELIMITED BY WS-DELIMITER     
                     PARM-TO-NAME-ADDRESS DELIMITED BY WS-DELIMITER     
                    INTO WS-4595-TRAN-COMMENT WITH POINTER              
                       WS-4595-TRAN-COMMENT-LEN                         
           END-IF.                                                      
           MOVE WS-4595-TRAN-COMMENT-LEN TO AR-TRAN-COMMENT-LEN.        
           IF AR-TRAN-COMMENT-LEN > 210                                 
              MOVE +210 TO AR-TRAN-COMMENT-LEN                          
           END-IF.                                                      
           MOVE WS-4595-TRAN-COMMENT TO AR-TRAN-COMMENT-TEXT.           
      *                                                                 00694300
           IF PARM-PAID-DEPOSIT-TRANSFER = 'Y'                          
              IF WS-25-ACCT-NO-TO = AR-ACCOUNT-NO                       
                 MOVE 'CSR04595F' TO AR-APPL-PROGRAM-ID                 
              ELSE                                                      
                 MOVE 'CSR04595T' TO AR-APPL-PROGRAM-ID                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 00694300
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO,                                        
                     TRANS_HIST_SEQ_NO,                                 
                     DATE_TRANS,                                        
                     CODE_TRAN_TYPE,                                    
                     AMT_ORIG_ENTERED,                                  
                     AMT_BILLED_UNPAID,                                 
                     RESP_AREA_ID,                                      
                     APPL_PROGRAM_ID,                                   
                     PYMT_FACILITY_CD,                                  
                     USER_ID,                                           
                     COMPANY_NO,                                        
                     RECORD_ONLY_FL,                                    
                     DATE_ORIG_PYMT,                                    
                     PYMT_REFUNDED_IND,                                 
                     CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     CASH_REPORT_NO,                                    
                     DATE_CASH_REPORT,                                  
                     CASH_DRAWER_ID,                                    
                     TRAN_COMMENT,                                      
                     PYMT_RCPT_PRNTD_CD)                                
               VALUES                                                   
                  ( :AR-ACCOUNT-NO,                                     
                    CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO),                  
                    IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) ),                              
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-RECORD-ONLY-FL,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                          :WS-DATE-ORIG-PYMT-IND
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                 :WS-DATE-ORIG-PYMT-IND
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-DATE-ORIG-PYMT-IND
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT 
                                                 :WS-DATE-ORIG-PYMT-IND
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT 
                                                 :WS-DATE-ORIG-PYMT-IND
              ) ),           
                    :AR-PYMT-REFUNDED-IND,                              
                    :AR-CASH-COMPANY-NO,                                
                    :AR-CASH-LOCAL-OFFICE,                              
                    :AR-CASH-REPORT-NO,                                 
                    IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
                    :AR-CASH-DRAWER-ID,                                 
                    :AR-TRAN-COMMENT,                                   
                    :AR-PYMT-RCPT-PRNTD-CD)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00210000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            00220000
MFA-TR*            ( ACCOUNT_NO,                                        00230000
MFA-TR*              TRANS_HIST_SEQ_NO,                                 00240000
MFA-TR*              DATE_TRANS,                                        00250000
MFA-TR*              CODE_TRAN_TYPE,                                    00260000
MFA-TR*              AMT_ORIG_ENTERED,                                  00270000
MFA-TR*              AMT_BILLED_UNPAID,                                 00280000
MFA-TR*              RESP_AREA_ID,                                      00290000
MFA-TR*              APPL_PROGRAM_ID,                                   00300000
MFA-TR*              PYMT_FACILITY_CD,                                  00310000
MFA-TR*              USER_ID,                                           00320000
MFA-TR*              COMPANY_NO,                                        00330000
MFA-TR*              RECORD_ONLY_FL,                                    00340000
MFA-TR*              DATE_ORIG_PYMT,                                    00350000
MFA-TR*              PYMT_REFUNDED_IND,                                 00360000
MFA-TR*              CASH_COMPANY_NO,                                   00370000
MFA-TR*              CASH_LOCAL_OFFICE,                                 00380000
MFA-TR*              CASH_REPORT_NO,                                    00390000
MFA-TR*              DATE_CASH_REPORT,                                  00400000
MFA-TR*              CASH_DRAWER_ID,                                    00410000
MFA-TR*              TRAN_COMMENT,                                      00410100
MFA-TR*              PYMT_RCPT_PRNTD_CD)                                00410201
MFA-TR*        VALUES                                                   00410300
MFA-TR*           ( :AR-ACCOUNT-NO,                                     00410400
MFA-TR*             :AR-TRANS-HIST-SEQ-NO,                              00410500
MFA-TR*             :AR-DATE-TRANS,                                     00410600
MFA-TR*             :AR-CODE-TRAN-TYPE,                                 00410700
MFA-TR*             :AR-AMT-ORIG-ENTERED,                               00410800
MFA-TR*             :AR-AMT-BILLED-UNPAID,                              00410900
MFA-TR*             :AR-RESP-AREA-ID,                                   00411000
MFA-TR*             :AR-APPL-PROGRAM-ID,                                00411100
MFA-TR*             :AR-PYMT-FACILITY-CD,                               00412000
MFA-TR*             :AR-USER-ID,                                        00413000
MFA-TR*             :AR-COMPANY-NO,                                     00414000
MFA-TR*             :AR-RECORD-ONLY-FL,                                 00415000
MFA-TR*             :AR-DATE-ORIG-PYMT:WS-DATE-ORIG-PYMT-IND,           00416000
MFA-TR*             :AR-PYMT-REFUNDED-IND,                              00417000
MFA-TR*             :AR-CASH-COMPANY-NO,                                00418000
MFA-TR*             :AR-CASH-LOCAL-OFFICE,                              00419000
MFA-TR*             :AR-CASH-REPORT-NO,                                 00420000
MFA-TR*             :AR-DATE-CASH-REPORT,                               00430000
MFA-TR*             :AR-CASH-DRAWER-ID,                                 00440000
MFA-TR*             :AR-TRAN-COMMENT,                                   00450000
MFA-TR*             :AR-PYMT-RCPT-PRNTD-CD)                             00460000
MFA-TR*    END-EXEC.                                                    00480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00490000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                 00694300
       6510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00694300
      ******************************************************************        
      * 6515-UPDATE-AR-TRANS-HIST                                      *        
      ******************************************************************        
       6515-UPDATE-AR-TRANS-HIST.                                       
           MOVE '6515' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET AMT_BILLED_UNPAID = :AR-AMT-BILLED-UNPAID         
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00691300
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 00691400
MFA-TR*           SET AMT_BILLED_UNPAID = :AR-AMT-BILLED-UNPAID         00691500
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                00691600
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO         00691700
MFA-TR*    END-EXEC.                                                    00691800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00691900
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6515'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AR-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                 00694300
       6515-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00694300
      ******************************************************************        
      * 6520-INSERT-AR-TRANS-DETL                                      *        
      ******************************************************************        
       6520-INSERT-AR-TRANS-DETL.                                       
           MOVE '6520' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRN_HST_DET                           
                     ( ACCOUNT_NO,                                      
                       TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO,                                    
                       CODE_AR_AGE,                                     
                       GL_ACCT_CREDIT,                                  
                       GL_ACCT_DEBIT,                                   
                       AMT_POSTED,                                      
                       ITEM_ID,                                         
                       CODE_CONTRACT_TYPE,                              
                       CURRENCY_TYPE,                                   
                       CURRENCY_AMT )                                   
            VALUES                                                      
                     ( :AU-ACCOUNT-NO,                                  
                       CIS.CHAR2TIMESTAMP(:AU-TRANS-HIST-SEQ-NO),               
                       :AU-TRAN-APPL-NO,                                
                       :AU-CODE-AR-AGE,                                 
                       :AU-GL-ACCT-CREDIT,                              
                       :AU-GL-ACCT-DEBIT,                               
                       :AU-AMT-POSTED,                                  
                       :AU-ITEM-ID,                                     
                       :AU-CODE-CONTRACT-TYPE,                          
                       :AU-CURRENCY-TYPE,                               
                       :AU-CURRENCY-AMT )                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00694600
MFA-TR*        INSERT INTO CSS_AR_TRN_HST_DET                           00695000
MFA-TR*              ( ACCOUNT_NO,                                      00700000
MFA-TR*                TRANS_HIST_SEQ_NO,                               00710000
MFA-TR*                TRAN_APPL_NO,                                    00720000
MFA-TR*                CODE_AR_AGE,                                     00730000
MFA-TR*                GL_ACCT_CREDIT,                                  00740000
MFA-TR*                GL_ACCT_DEBIT,                                   00750000
MFA-TR*                AMT_POSTED,                                      00760000
MFA-TR*                ITEM_ID,                                         00770000
MFA-TR*                CODE_CONTRACT_TYPE,                              00780000
MFA-TR*                CURRENCY_TYPE,                                   00790000
MFA-TR*                CURRENCY_AMT )                                   00791000
MFA-TR*     VALUES                                                      00792000
MFA-TR*              ( :AU-ACCOUNT-NO,                                  00800000
MFA-TR*                :AU-TRANS-HIST-SEQ-NO,                           00810000
MFA-TR*                :AU-TRAN-APPL-NO,                                00820000
MFA-TR*                :AU-CODE-AR-AGE,                                 00830000
MFA-TR*                :AU-GL-ACCT-CREDIT,                              00840000
MFA-TR*                :AU-GL-ACCT-DEBIT,                               00850000
MFA-TR*                :AU-AMT-POSTED,                                  00860000
MFA-TR*                :AU-ITEM-ID,                                     00870000
MFA-TR*                :AU-CODE-CONTRACT-TYPE,                          00880000
MFA-TR*                :AU-CURRENCY-TYPE,                               00890000
MFA-TR*                :AU-CURRENCY-AMT )                               00891000
MFA-TR*    END-EXEC.                                                    00900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00910000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
              MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AU-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                 00694300
       6520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6600-FORCE-DFA                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04596                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6800-TRANSFER-CONTROL                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04595                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-TO-ACCT-DATES                                      *        
      ******************************************************************        
       7000-SELECT-TO-ACCT-DATES.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90                                   
                INTO :WS-TO-ACCT-DATE-00 :WS-45-NULL-IND-00,             
                     :WS-TO-ACCT-DATE-30 :WS-45-NULL-IND-30,             
                     :WS-TO-ACCT-DATE-60 :WS-45-NULL-IND-60,             
                     :WS-TO-ACCT-DATE-90 :WS-45-NULL-IND-90              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90                                           
MFA-TR*         INTO :WS-TO-ACCT-DATE-00:WS-45-NULL-IND-00,                     
MFA-TR*              :WS-TO-ACCT-DATE-30:WS-45-NULL-IND-30,                     
MFA-TR*              :WS-TO-ACCT-DATE-60:WS-45-NULL-IND-60,                     
MFA-TR*              :WS-TO-ACCT-DATE-90:WS-45-NULL-IND-90                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-45-NULL-IND-00 < 0                                 
                  MOVE SPACES TO WS-TO-ACCT-DATE-00                     
                  MOVE ZEROES TO WS-45-NULL-IND-00                      
               END-IF                                                   
               IF WS-45-NULL-IND-30 < 0                                 
                  MOVE SPACES TO WS-TO-ACCT-DATE-30                     
                  MOVE ZEROES TO WS-45-NULL-IND-30                      
               END-IF                                                   
               IF WS-45-NULL-IND-60 < 0                                 
                  MOVE SPACES TO WS-TO-ACCT-DATE-60                     
                  MOVE ZEROES TO WS-45-NULL-IND-60                      
               END-IF                                                   
               IF WS-45-NULL-IND-90 < 0                                 
                  MOVE SPACES TO WS-TO-ACCT-DATE-90                     
                  MOVE ZEROES TO WS-45-NULL-IND-90                      
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7000'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-TO-ACCT-BUCKETS-1                                  *        
      ******************************************************************        
       7010-SELECT-TO-ACCT-BUCKETS-1.                                   
      *                                                                         
           MOVE ZEROS TO WS-45-NULL-IND-00                              
                         WS-45-NULL-IND-30                              
                         WS-45-NULL-IND-60                              
                         WS-45-NULL-IND-90.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90)                                 
                INTO :WS-TO-ACCT-BEFORE-00 :WS-45-NULL-IND-00,           
                     :WS-TO-ACCT-BEFORE-30 :WS-45-NULL-IND-30,           
                     :WS-TO-ACCT-BEFORE-60 :WS-45-NULL-IND-60,           
                     :WS-TO-ACCT-BEFORE-90 :WS-45-NULL-IND-90            
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                        
MFA-TR*              SUM(AMT_AR_DAY_30),                                        
MFA-TR*              SUM(AMT_AR_DAY_60),                                        
MFA-TR*              SUM(AMT_AR_DAY_90)                                         
MFA-TR*         INTO :WS-TO-ACCT-BEFORE-00:WS-45-NULL-IND-00,                   
MFA-TR*              :WS-TO-ACCT-BEFORE-30:WS-45-NULL-IND-30,                   
MFA-TR*              :WS-TO-ACCT-BEFORE-60:WS-45-NULL-IND-60,                   
MFA-TR*              :WS-TO-ACCT-BEFORE-90:WS-45-NULL-IND-90                    
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-45-NULL-IND-00 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-BEFORE-00                    
                 MOVE ZEROES TO WS-45-NULL-IND-00                       
              END-IF                                                    
              IF WS-45-NULL-IND-30 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-BEFORE-30                    
                 MOVE ZEROES TO WS-45-NULL-IND-30                       
              END-IF                                                    
              IF WS-45-NULL-IND-60 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-BEFORE-60                    
                 MOVE ZEROES TO WS-45-NULL-IND-60                       
              END-IF                                                    
              IF WS-45-NULL-IND-90 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-BEFORE-90                    
                 MOVE ZEROES TO WS-45-NULL-IND-90                       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7010'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_CNTL'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-SELECT-FROM-ACCT-DATES                                    *        
      ******************************************************************        
       7020-SELECT-FROM-ACCT-DATES.                                     
      *                                                                         
           MOVE ZEROS TO WS-45-NULL-IND-00                              
                         WS-45-NULL-IND-30                              
                         WS-45-NULL-IND-60                              
                         WS-45-NULL-IND-90.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90                                   
                INTO :WS-FROM-ACCT-DATE-00 :WS-45-NULL-IND-00,           
                     :WS-FROM-ACCT-DATE-30 :WS-45-NULL-IND-30,           
                     :WS-FROM-ACCT-DATE-60 :WS-45-NULL-IND-60,           
                     :WS-FROM-ACCT-DATE-90 :WS-45-NULL-IND-90            
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90                                           
MFA-TR*         INTO :WS-FROM-ACCT-DATE-00:WS-45-NULL-IND-00,                   
MFA-TR*              :WS-FROM-ACCT-DATE-30:WS-45-NULL-IND-30,                   
MFA-TR*              :WS-FROM-ACCT-DATE-60:WS-45-NULL-IND-60,                   
MFA-TR*              :WS-FROM-ACCT-DATE-90:WS-45-NULL-IND-90                    
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-45-NULL-IND-00 < 0                                 
                  MOVE SPACES TO WS-FROM-ACCT-DATE-00                   
                  MOVE ZEROES TO WS-45-NULL-IND-00                      
               END-IF                                                   
               IF WS-45-NULL-IND-30 < 0                                 
                  MOVE SPACES TO WS-FROM-ACCT-DATE-30                   
                  MOVE ZEROES TO WS-45-NULL-IND-30                      
               END-IF                                                   
               IF WS-45-NULL-IND-60 < 0                                 
                  MOVE SPACES TO WS-FROM-ACCT-DATE-60                   
                  MOVE ZEROES TO WS-45-NULL-IND-60                      
               END-IF                                                   
               IF WS-45-NULL-IND-90 < 0                                 
                  MOVE SPACES TO WS-FROM-ACCT-DATE-90                   
                  MOVE ZEROES TO WS-45-NULL-IND-90                      
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7020'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-SELECT-TO-ACCT-BUCKETS-2                                  *        
      ******************************************************************        
       7030-SELECT-TO-ACCT-BUCKETS-2.                                   
      *                                                                         
           MOVE ZEROS            TO WS-45-NULL-IND-00                   
                                    WS-45-NULL-IND-30                   
                                    WS-45-NULL-IND-60                   
                                    WS-45-NULL-IND-90.                  
           MOVE WS-25-ACCT-NO-TO TO AT-ACCOUNT-NO.                      
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90)                                 
                INTO :WS-TO-ACCT-AFTER-00 :WS-45-NULL-IND-00,            
                     :WS-TO-ACCT-AFTER-30 :WS-45-NULL-IND-30,            
                     :WS-TO-ACCT-AFTER-60 :WS-45-NULL-IND-60,            
                     :WS-TO-ACCT-AFTER-90 :WS-45-NULL-IND-90             
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                        
MFA-TR*              SUM(AMT_AR_DAY_30),                                        
MFA-TR*              SUM(AMT_AR_DAY_60),                                        
MFA-TR*              SUM(AMT_AR_DAY_90)                                         
MFA-TR*         INTO :WS-TO-ACCT-AFTER-00:WS-45-NULL-IND-00,                    
MFA-TR*              :WS-TO-ACCT-AFTER-30:WS-45-NULL-IND-30,                    
MFA-TR*              :WS-TO-ACCT-AFTER-60:WS-45-NULL-IND-60,                    
MFA-TR*              :WS-TO-ACCT-AFTER-90:WS-45-NULL-IND-90                     
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-45-NULL-IND-00 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-AFTER-00                     
                 MOVE ZEROES TO WS-45-NULL-IND-00                       
              END-IF                                                    
              IF WS-45-NULL-IND-30 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-AFTER-30                     
                 MOVE ZEROES TO WS-45-NULL-IND-30                       
              END-IF                                                    
              IF WS-45-NULL-IND-60 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-AFTER-60                     
                 MOVE ZEROES TO WS-45-NULL-IND-60                       
              END-IF                                                    
              IF WS-45-NULL-IND-90 < 0                                  
                 MOVE ZEROES TO WS-TO-ACCT-AFTER-90                     
                 MOVE ZEROES TO WS-45-NULL-IND-90                       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7030'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_CNTL'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7040-GET-RULE-XREF-ID.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7040'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_XREF_ID'    TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-XREF-ID    TO HOSTVAR-ELEMENT-1          
               PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7060-SELECT-DELINQUENCY                                        *        
      ******************************************************************        
       7060-SELECT-DELINQUENCY.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *7110-SELCT-DNP-RECON                                       *             
      *************************************************************             
       7110-SELCT-DNP-RECON.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT RECNCT_COLLECT_AMT,                                
                     AMT_TOT_RECONNECT                                  
              INTO  :DL-RECNCT-COLLECT-AMT,                             
                    :DL-AMT-TOT-RECONNECT                               
              FROM   CSS_RECONNECT WITH(READUNCOMMITTED)                        
              WHERE  ACCOUNT_NO = :DL-ACCOUNT-NO                        
                                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RECNCT_COLLECT_AMT,                                        
MFA-TR*              AMT_TOT_RECONNECT                                          
MFA-TR*       INTO  :DL-RECNCT-COLLECT-AMT,                                     
MFA-TR*             :DL-AMT-TOT-RECONNECT                                       
MFA-TR*       FROM   CSS_RECONNECT                                              
MFA-TR*       WHERE  ACCOUNT_NO = :DL-ACCOUNT-NO                                
MFA-TR*       WITH   UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RECONNECT '          TO TABLE-1                 
              MOVE 'ACCOUNT NO'              TO TABLE-ELEMENT-1         
              MOVE DL-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-ACCOUNT                                            *        
      ******************************************************************        
       7200-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
            SELECT AR_XFER_IND,                                         
                   ACCT_XFER_TO,                                        
                   ACCT_XFER_FROM_LST,                                  
                   PREMISE_NO,                                          
                   CUSTOMER_NO,                                         
                   COMPANY_NO,                                          
                   LOCAL_OFFICE,                                        
                   CODE_ACCT_STAT,                                      
                   CODES_DATA_PRESENT,                                  
                   BANKRUPTCY_IND,                                      
                   NOTICE_EXEMPT_CD,                                    
                   CODE_DISC_OK,                                        
                   DATE_BILL_DAY_00,                                    
                   DATE_BILL_DAY_30,                                    
                   DATE_BILL_DAY_60,                                    
                   DATE_BILL_DAY_90,                                    
                   CREDIT_GROUP,                                        
                   BILL_CYCLE,                                          
                   CODE_BILL_FREQ,                                      
                   REV_MTH_LST_NRML,                                    
                   IVR_EXEMPT_CD,                                       
                   CAST(SYSDATETIMEOFFSET() AS DATE)                            
             INTO :AT-AR-XFER-IND,                                      
                  :AT-ACCT-XFER-TO,                                     
                  :AT-ACCT-XFER-FROM-LST,                               
                  :AT-PREMISE-NO,                                       
                  :AT-CUSTOMER-NO,                                      
                  :AT-COMPANY-NO,                                       
                  :AT-LOCAL-OFFICE,                                     
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-BANKRUPTCY-IND,                                   
                  :AT-NOTICE-EXEMPT-CD,                                 
                  :AT-CODE-DISC-OK,                                     
                  :AT-DATE-BILL-DAY-00 :WS-NULL-IND1,                    
                  :AT-DATE-BILL-DAY-30 :WS-NULL-IND2,                    
                  :AT-DATE-BILL-DAY-60 :WS-NULL-IND3,                    
                  :AT-DATE-BILL-DAY-90 :WS-NULL-IND4,                    
                  :AT-CREDIT-GROUP,                                     
                  :AT-BILL-CYCLE,                                       
                  :AT-CODE-BILL-FREQ,                                   
                  :AT-REV-MTH-LST-NRML,                                 
                  :AT-IVR-EXEMPT-CD,                                    
                  :WS-CURRENT-DATE                                      
             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT AR_XFER_IND,                                                 
MFA-TR*            ACCT_XFER_TO,                                                
MFA-TR*            ACCT_XFER_FROM_LST,                                          
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            CODE_ACCT_STAT,                                              
MFA-TR*            CODES_DATA_PRESENT,                                          
MFA-TR*            BANKRUPTCY_IND,                                              
MFA-TR*            NOTICE_EXEMPT_CD,                                            
MFA-TR*            CODE_DISC_OK,                                                
MFA-TR*            DATE_BILL_DAY_00,                                            
MFA-TR*            DATE_BILL_DAY_30,                                            
MFA-TR*            DATE_BILL_DAY_60,                                            
MFA-TR*            DATE_BILL_DAY_90,                                            
MFA-TR*            CREDIT_GROUP,                                                
MFA-TR*            BILL_CYCLE,                                                  
MFA-TR*            CODE_BILL_FREQ,                                              
MFA-TR*            REV_MTH_LST_NRML,                                            
MFA-TR*            IVR_EXEMPT_CD,                                               
MFA-TR*            CURRENT DATE                                                 
MFA-TR*      INTO :AT-AR-XFER-IND,                                              
MFA-TR*           :AT-ACCT-XFER-TO,                                             
MFA-TR*           :AT-ACCT-XFER-FROM-LST,                                       
MFA-TR*           :AT-PREMISE-NO,                                               
MFA-TR*           :AT-CUSTOMER-NO,                                              
MFA-TR*           :AT-COMPANY-NO,                                               
MFA-TR*           :AT-LOCAL-OFFICE,                                             
MFA-TR*           :AT-CODE-ACCT-STAT,                                           
MFA-TR*           :AT-CODES-DATA-PRESENT,                                       
MFA-TR*           :AT-BANKRUPTCY-IND,                                           
MFA-TR*           :AT-NOTICE-EXEMPT-CD,                                         
MFA-TR*           :AT-CODE-DISC-OK,                                             
MFA-TR*           :AT-DATE-BILL-DAY-00:WS-NULL-IND1,                            
MFA-TR*           :AT-DATE-BILL-DAY-30:WS-NULL-IND2,                            
MFA-TR*           :AT-DATE-BILL-DAY-60:WS-NULL-IND3,                            
MFA-TR*           :AT-DATE-BILL-DAY-90:WS-NULL-IND4,                            
MFA-TR*           :AT-CREDIT-GROUP,                                             
MFA-TR*           :AT-BILL-CYCLE,                                               
MFA-TR*           :AT-CODE-BILL-FREQ,                                           
MFA-TR*           :AT-REV-MTH-LST-NRML,                                         
MFA-TR*           :AT-IVR-EXEMPT-CD,                                            
MFA-TR*           :WS-CURRENT-DATE                                              
MFA-TR*      FROM CSS_ACCOUNT                                                   
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-NULL-IND1 < 0                                      
                  MOVE SPACES TO AT-DATE-BILL-DAY-00                    
                  MOVE ZEROES TO WS-NULL-IND1                           
               END-IF                                                   
               IF WS-NULL-IND2 < 0                                      
                  MOVE SPACES TO AT-DATE-BILL-DAY-30                    
                  MOVE ZEROES TO WS-NULL-IND2                           
               END-IF                                                   
               IF WS-NULL-IND3 < 0                                      
                  MOVE SPACES TO AT-DATE-BILL-DAY-60                    
                  MOVE ZEROES TO WS-NULL-IND3                           
               END-IF                                                   
               IF WS-NULL-IND3 < 0                                      
                  MOVE SPACES TO AT-DATE-BILL-DAY-90                    
                  MOVE ZEROES TO WS-NULL-IND4                           
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7205-SELECT-CODE-DATA-PRESENT.                                 *        
      ******************************************************************        
       7205-SELECT-CODE-DATA-PRESENT.                                   
      *                                                                         
           EXEC SQL                                                     
            SELECT CODES_DATA_PRESENT                                   
             INTO :AT-CODES-DATA-PRESENT                                
             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODES_DATA_PRESENT                                           
MFA-TR*      INTO :AT-CODES-DATA-PRESENT                                        
MFA-TR*      FROM CSS_ACCOUNT                                                   
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*      QUERYNO 7205                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7205'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-SELECT-CREDIT-PROF                                        *        
      ******************************************************************        
       7230-SELECT-CREDIT-PROF.                                         
      *                                                                         
           EXEC SQL                                                     
            SELECT ARREARS_HIST,                                        
                   DISC_EXCEPTN_HIST,                                   
                   DISCONNECT_HIST,                                     
                   NON_UTL_ARRER_HIST,                                  
                   NON_UTL_CR_HST_EX,                                   
                   NON_UTL_CR_HST                                       
             INTO :CZ-ARREARS-HIST,                                     
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-NON-UTL-CR-HST-EX,                                
                  :CZ-NON-UTL-CR-HST                                    
             FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT ARREARS_HIST,                                                
MFA-TR*            DISC_EXCEPTN_HIST,                                           
MFA-TR*            DISCONNECT_HIST,                                             
MFA-TR*            NON_UTL_ARRER_HIST,                                          
MFA-TR*            NON_UTL_CR_HST_EX,                                           
MFA-TR*            NON_UTL_CR_HST                                               
MFA-TR*      INTO :CZ-ARREARS-HIST,                                             
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                        
MFA-TR*           :CZ-DISCONNECT-HIST,                                          
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                                       
MFA-TR*           :CZ-NON-UTL-CR-HST-EX,                                        
MFA-TR*           :CZ-NON-UTL-CR-HST                                            
MFA-TR*      FROM CSS_CREDIT_PROFILE                                            
MFA-TR*         WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                               
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7230'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-TIMESTAMP                                             *        
      ******************************************************************        
       7300-GET-TIMESTAMP.                                              
      *                                                                         
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( SECOND, 10, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP + 10 SECONDS         
MFA-TR*         ,:MH-DATE-TRANS = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-TO-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7350-GET-BILL-NO                                              *         
      *****************************************************************         
       7350-GET-BILL-NO.                                                
      *                                                                         
           EXEC SQL                                                     
            SELECT BILL_NO                                              
             INTO :BI-BILL-NO                                           
             FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT BILL_NO                                                      
MFA-TR*      INTO :BI-BILL-NO                                                   
MFA-TR*      FROM CSS_BILLING_HDR                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED = :AT-DATE-BILL-DAY-00                         
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILLING_HDR'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_BILLED'             TO TABLE-ELEMENT-2         
              MOVE AT-DATE-BILL-DAY-00       TO HOSTVAR-ELEMENT-2       
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                        
              MOVE 'N' TO WS-BILL-HEADER-FOUND                          
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y' TO WS-BILL-HEADER-FOUND                          
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7360-GET-REV-MONTH                                            *         
      *****************************************************************         
       7360-GET-REV-MONTH.                                              
      *                                                                         
           EXEC SQL                                                     
            SELECT MAX(REVENUE_MONTH)                                   
             INTO :BG-REVENUE-MONTH                                     
             FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                 AND BILL_NO     = :BI-BILL-NO                          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT MAX(REVENUE_MONTH)                                           
MFA-TR*      INTO :BG-REVENUE-MONTH                                             
MFA-TR*      FROM CSS_BILLING_DET                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          AND BILL_NO     = :BI-BILL-NO                                  
MFA-TR*      QUERYNO 7360                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7360'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_BILLING_DET'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'BILL_NO'           TO TABLE-ELEMENT-2               
              MOVE BI-BILL-NO          TO HOSTVAR-ELEMENT-2             
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7370-READ-BILL-WINDOW                                         *         
      *****************************************************************         
       7370-READ-BILL-WINDOW.                                           
      *                                                                         
           EXEC SQL                                                     
            SELECT MAX(REVENUE_MONTH)                                   
             INTO :BG-REVENUE-MONTH                                     
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() AS DATE)            
             AND BILL_CYCLE      = :AT-BILL-CYCLE                       
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT MAX(REVENUE_MONTH)                                           
MFA-TR*      INTO :BG-REVENUE-MONTH                                             
MFA-TR*      FROM CSS_BILL_WINDOW                                               
MFA-TR*      WHERE DATE_EXTRACT <= CURRENT DATE                                 
MFA-TR*      AND BILL_CYCLE      = :AT-BILL-CYCLE                               
MFA-TR*      QUERYNO 7370                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7370'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_BILL_WINDOW'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'BILL_CYCLE'        TO TABLE-ELEMENT-2               
              MOVE AT-BILL-CYCLE       TO HOSTVAR-ELEMENT-2             
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 21330000
      * 7400-OPEN-SURETY-BOND                                         * 21340000
      *     OPEN A CURSOR WHICH SELECTS WAIVER-'C'                    * 21350000
      ***************************************************************** 21370000
       7400-OPEN-SURETY-BOND.                                           
      *                                                                 21390000
           EXEC SQL                                                     
              OPEN SURETY_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21671000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 21690000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BOND_WAIV_ITEM_ID'        TO TABLE-ELEMENT-2        
              MOVE 'DATE_BOND_ISSUED'         TO TABLE-ELEMENT-3        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE SB-BOND-WAIV-ITEM-ID       TO HOSTVAR-ELEMENT-2      
              MOVE SB-DATE-BOND-ISSUED        TO HOSTVAR-ELEMENT-3      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 21810000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21840000
      ***************************************************************** 21850000
      * 7410-FETCH-SURETY-BOND                                        * 21860000
      ***************************************************************** 21870000
       7410-FETCH-SURETY-BOND.                                          
      *                                                                 21890000
           EXEC SQL                                                     
              FETCH SURETY_CURSOR                                       
               INTO :SB-BOND-WAIV-ITEM-ID ,                             
                    :SB-BOND-NO           ,                             
                    :SB-DATE-BOND-ISSUED :WS-DATE-BOND-ISSUED-NI,        
                    :SB-TERM-OF-BOND      ,                             
                    :SB-AMT-BOND          ,                             
                    :SB-CODE-BOND-TYPE    ,                             
                    :SB-BOND-CO-NO        ,                             
                    :SB-BOND-CO-CUST-NO   ,                             
                    :SB-CODE-STATUS       ,                             
                    :SB-CODE-STATUS-REAS  ,                             
                    :SB-BOND-TOTAL-AMT    ,                             
                    :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI,                
                    :SB-BOND-EXPIRATION-DT :WS-BOND-EXPIRATION-DT-NI,    
                    :SB-WAIVER-TYPE-CD    ,                             
                    :SB-ADDRESS-ID        ,                             
                    :SB-USER-ID-ORIG-BY   ,                             
                    :SB-WAIVER-SOURCE-DESC,                             
                    :SB-COMMENTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22110000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 22130000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BOND_WAIV_ITEM_ID'        TO TABLE-ELEMENT-2        
              MOVE 'DATE_BOND_ISSUED'         TO TABLE-ELEMENT-3        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE SB-BOND-WAIV-ITEM-ID       TO HOSTVAR-ELEMENT-2      
              MOVE SB-DATE-BOND-ISSUED        TO HOSTVAR-ELEMENT-3      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 22250000
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22280000
      ***************************************************************** 22290000
      * 7420-CLOSE-SURETY-BOND                                        * 22300000
      ***************************************************************** 22310000
       7420-CLOSE-SURETY-BOND.                                          
      *                                                                 22330000
           EXEC SQL                                                     
              CLOSE SURETY_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22361000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 22380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BOND_WAIV_ITEM_ID'        TO TABLE-ELEMENT-2        
              MOVE 'DATE_BOND_ISSUED'         TO TABLE-ELEMENT-3        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE SB-BOND-WAIV-ITEM-ID       TO HOSTVAR-ELEMENT-2      
              MOVE SB-DATE-BOND-ISSUED        TO HOSTVAR-ELEMENT-3      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 22500000
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28960000
      ***************************************************************** 28310000
      * 7500-SELECT-LIEN-CODE                                         * 28320000
      ***************************************************************** 28330000
       7500-SELECT-LIEN-CODE.                                           
      *                                                                 28960000
           EXEC SQL                                                     
            SELECT LIEN_CD                                              
             INTO :CT-LIEN-CD                                           
             FROM CSS_CONTRACT WITH(READUNCOMMITTED)                            
             WHERE ACCOUNT_NO  = :CT-ACCOUNT-NO                         
             AND   CNT_ITEM_ID = :CT-CNT-ITEM-ID                        
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35793000
MFA-TR*     SELECT LIEN_CD                                              35793100
MFA-TR*      INTO :CT-LIEN-CD                                           35793200
MFA-TR*      FROM CSS_CONTRACT                                          35793300
MFA-TR*      WHERE ACCOUNT_NO  = :CT-ACCOUNT-NO                         35793400
MFA-TR*      AND   CNT_ITEM_ID = :CT-CNT-ITEM-ID                        35793500
MFA-TR*        QUERYNO 7500                                             28570000
MFA-TR*        WITH UR                                                  28570000
MFA-TR*    END-EXEC.                                                    35799500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28960000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 28960000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CNT_ITEM_ID'              TO TABLE-ELEMENT-2        
              MOVE CT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CT-CNT-ITEM-ID             TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 28350000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28960000
A04527***************************************************************** 28310000
A04527* 7550-SELECT-CHRG-OFF                                          * 28320000
A04527***************************************************************** 28330000
A04527 7550-SELECT-CHRG-OFF.                                            
A04527*                                                                 28960000
A04527     EXEC SQL                                                     
A04527      SELECT AMT_TRANS                                            
A04527       INTO :CO-AMT-TRANS                                         
A04527       FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                            
A04527       WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                   
A04527       AND   PYMT_PRIORITY_LVL = :CO-PYMT-PRIORITY-LVL            
A04527       AND   ITEM_ID           = :CO-ITEM-ID                      
A04527                                                      
A04527                                                           
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35793000
MFA-TR*     SELECT AMT_TRANS                                            35793100
MFA-TR*      INTO :CO-AMT-TRANS                                         35793200
MFA-TR*      FROM CSS_CHRG_OFF                                          35793300
MFA-TR*      WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                   35793400
MFA-TR*      AND   PYMT_PRIORITY_LVL = :CO-PYMT-PRIORITY-LVL            35793500
MFA-TR*      AND   ITEM_ID           = :CO-ITEM-ID                      35793500
MFA-TR*        QUERYNO 7550                                             28570000
MFA-TR*        WITH UR                                                  28570000
MFA-TR*    END-EXEC.                                                    35799500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527*                                                                 28960000
A04527     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04527*                                                                 28960000
A04527     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04527        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A04527           MOVE WS-Y TO WS-25-CHRGOFF-IND                         
A04527        ELSE                                                      
A04527           MOVE WS-N TO WS-25-CHRGOFF-IND                         
A04527        END-IF                                                    
A04527     ELSE                                                         
A04527        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A04527        MOVE '7550'                     TO ACTIVE-PARAGRAPH       
A04527        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A04527        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A04527                                           ABEND-TABLES           
A04527        MOVE 'CSS_CHRG_OFF'             TO TABLE-1                
A04527        MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1        
A04527        MOVE 'PYMT-PRIORITY-LVL'        TO TABLE-ELEMENT-2        
A04527        MOVE 'ITEM-ID'                  TO TABLE-ELEMENT-3        
A04527        MOVE CO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A04527        MOVE CO-PYMT-PRIORITY-LVL       TO HOSTVAR-ELEMENT-2      
A04527        MOVE CO-ITEM-ID                 TO HOSTVAR-ELEMENT-3      
A04527        PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
A04527     END-IF.                                                      
A04527*                                                                 28350000
A04527 7550-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
      *****************************************************************         
      * 7999-SELECT-AL   SQL TO CHECK A/R LOCKOUT INDICATOR           *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8050-UPDATE-AT-BILL-DATES                                      *        
      ******************************************************************        
       8050-UPDATE-AT-BILL-DATES.                                       
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET DATE_BILL_DAY_00 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-00 
                                                     :WS-45-NULL-IND-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00 
                                                     :WS-45-NULL-IND-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00 :WS-45-NULL-IND-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00 
                                                     :WS-45-NULL-IND-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00 :WS-45-NULL-IND-00
              ) ),             
                     DATE_BILL_DAY_30 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-30 
                                                     :WS-45-NULL-IND-30
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30 
                                                     :WS-45-NULL-IND-30
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30 :WS-45-NULL-IND-30
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30 
                                                     :WS-45-NULL-IND-30
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30 :WS-45-NULL-IND-30
              ) ),             
                     DATE_BILL_DAY_60 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-60 
                                                     :WS-45-NULL-IND-60
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60 
                                                     :WS-45-NULL-IND-60
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60 :WS-45-NULL-IND-60
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60 
                                                     :WS-45-NULL-IND-60
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60 :WS-45-NULL-IND-60
              ) ),             
                     DATE_BILL_DAY_90 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-90 
                                                     :WS-45-NULL-IND-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90 
                                                     :WS-45-NULL-IND-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90 :WS-45-NULL-IND-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90 
                                                     :WS-45-NULL-IND-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90 :WS-45-NULL-IND-90
              ) )              
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET DATE_BILL_DAY_00 = :AT-DATE-BILL-DAY-00                    
MFA-TR*                                 :WS-45-NULL-IND-00,                     
MFA-TR*              DATE_BILL_DAY_30 = :AT-DATE-BILL-DAY-30                    
MFA-TR*                                 :WS-45-NULL-IND-30,                     
MFA-TR*              DATE_BILL_DAY_60 = :AT-DATE-BILL-DAY-60                    
MFA-TR*                                 :WS-45-NULL-IND-60,                     
MFA-TR*              DATE_BILL_DAY_90 = :AT-DATE-BILL-DAY-90                    
MFA-TR*                                 :WS-45-NULL-IND-90                      
MFA-TR*        WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '8050'                 TO ACTIVE-PARAGRAPH           
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'DATE_BILL_DAY_00'     TO TABLE-ELEMENT-2            
              MOVE 'DATE_BILL_DAY_30'     TO TABLE-ELEMENT-3            
              MOVE 'DATE_BILL_DAY_60'     TO TABLE-ELEMENT-4            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE AT-DATE-BILL-DAY-00    TO HOSTVAR-ELEMENT-2          
              MOVE AT-DATE-BILL-DAY-30    TO HOSTVAR-ELEMENT-3          
              MOVE AT-DATE-BILL-DAY-60    TO HOSTVAR-ELEMENT-4          
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-UPDATE-ACCOUNT                                            *        
      ******************************************************************        
       8200-UPDATE-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
           UPDATE CSS_ACCOUNT                                           
              SET  AR_XFER_IND         =:AT-AR-XFER-IND,                
                   ACCT_XFER_TO        =:AT-ACCT-XFER-TO,               
                   ACCT_XFER_FROM_LST  =:AT-ACCT-XFER-FROM-LST          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8200'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'AR_XFER_IND'       TO TABLE-ELEMENT-2               
              MOVE 'ACCT_XFER_TO'      TO TABLE-ELEMENT-3               
              MOVE 'ACCT_XFER_FROM_LST' TO TABLE-ELEMENT-4              
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE AT-AR-XFER-IND      TO HOSTVAR-ELEMENT-2             
              MOVE AT-ACCT-XFER-TO     TO HOSTVAR-ELEMENT-3             
              MOVE AT-ACCT-XFER-FROM-LST TO HOSTVAR-ELEMENT-4           
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8250-UPDATE-CREDIT-PROF                                        *        
      ******************************************************************        
       8250-UPDATE-CREDIT-PROF.                                         
      *                                                                         
           EXEC SQL                                                     
            UPDATE CSS_CREDIT_PROFILE                                   
               SET ARREARS_HIST       = :CZ-ARREARS-HIST,               
                   DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,          
                   DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,            
                   NON_UTL_ARRER_HIST = :CZ-NON-UTL-ARRER-HIST,         
                   NON_UTL_CR_HST_EX  = :CZ-NON-UTL-CR-HST-EX,          
                   NON_UTL_CR_HST     = :CZ-NON-UTL-CR-HST              
                WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8270-UPDT-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
       8270-UPDT-MNT-TRANS-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
            UPDATE CSS_MNT_TRANS_HIST                                   
               SET TRAN_COMMENT  = :MH-TRAN-COMMENT                     
                WHERE ACCOUNT_NO = :MH-ACCOUNT-NO                       
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_MNT_TRANS_HIST                                           
MFA-TR*        SET TRAN_COMMENT  = :MH-TRAN-COMMENT                             
MFA-TR*         WHERE ACCOUNT_NO = :MH-ACCOUNT-NO                               
MFA-TR*           AND TRANS_HIST_SEQ_NO = :MH-TRANS-HIST-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2        
              MOVE MH-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                         
       8270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 28310000
      * 8350-INSERT-SURETY-BOND                                       * 28320000
      ***************************************************************** 28330000
       8350-INSERT-SURETY-BOND.                                         
      *                                                                 28350000
           EXEC SQL                                                     
              INSERT INTO CSS_SURETY_BOND                               
                     (ACCOUNT_NO        ,                               
                      BOND_WAIV_ITEM_ID ,                               
                      BOND_NO           ,                               
                      DATE_BOND_ISSUED  ,                               
                      TERM_OF_BOND      ,                               
                      AMT_BOND          ,                               
                      CODE_BOND_TYPE    ,                               
                      BOND_CO_NO        ,                               
                      BOND_CO_CUST_NO   ,                               
                      CODE_STATUS       ,                               
                      CODE_STATUS_REAS  ,                               
                      BOND_TOTAL_AMT    ,                               
                      TRIGGER_DATE      ,                               
                      BOND_EXPIRATION_DT,                               
                      WAIVER_TYPE_CD    ,                               
                      ADDRESS_ID        ,                               
                      USER_ID_ORIG_BY   ,                               
                      WAIVER_SOURCE_DESC,                               
                      COMMENTS)                                         
              VALUES (:SB-ACCOUNT-NO        ,                           
                      :SB-BOND-WAIV-ITEM-ID ,                           
                      :SB-BOND-NO           ,                           
                      IIF(TRY_CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                            :WS-DATE-BOND-ISSUED-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 0) OR (LEN(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) <> 10), CIS.CHAR2DATE(:SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ), CONVERT(DATE, :SB-DATE-BOND-ISSUED 
                                                :WS-DATE-BOND-ISSUED-NI
              ) ),      
                      :SB-TERM-OF-BOND      ,                           
                      :SB-AMT-BOND          ,                           
                      :SB-CODE-BOND-TYPE    ,                           
                      :SB-BOND-CO-NO        ,                           
                      :SB-BOND-CO-CUST-NO   ,                           
                      :SB-CODE-STATUS       ,                           
                      :SB-CODE-STATUS-REAS  ,                           
                      :SB-BOND-TOTAL-AMT    ,                           
                      IIF(TRY_CONVERT(DATE, :SB-TRIGGER-DATE 
                                            :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:SB-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :SB-TRIGGER-DATE :WS-TRIGGER-DATE-NI) ),        
                      IIF(TRY_CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                            :WS-BOND-EXPIRATION-DT-NI
              ) IS NULL OR (PATINDEX('%.%', :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 0) OR (LEN(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) <> 10), CIS.CHAR2DATE(:SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ), CONVERT(DATE, :SB-BOND-EXPIRATION-DT 
                                              :WS-BOND-EXPIRATION-DT-NI
              ) ),  
                      :SB-WAIVER-TYPE-CD    ,                           
                      :SB-ADDRESS-ID        ,                           
                      :SB-USER-ID-ORIG-BY   ,                           
                      :SB-WAIVER-SOURCE-DESC,                           
                      :SB-COMMENTS)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     28360000
MFA-TR*       INSERT INTO CSS_SURETY_BOND                               28370000
MFA-TR*              (ACCOUNT_NO        ,                               28380000
MFA-TR*               BOND_WAIV_ITEM_ID ,                               28390000
MFA-TR*               BOND_NO           ,                               28400000
MFA-TR*               DATE_BOND_ISSUED  ,                               28410000
MFA-TR*               TERM_OF_BOND      ,                               28420000
MFA-TR*               AMT_BOND          ,                               28430000
MFA-TR*               CODE_BOND_TYPE    ,                               28440000
MFA-TR*               BOND_CO_NO        ,                               28450000
MFA-TR*               BOND_CO_CUST_NO   ,                               28460000
MFA-TR*               CODE_STATUS       ,                               28470000
MFA-TR*               CODE_STATUS_REAS  ,                               28480000
MFA-TR*               BOND_TOTAL_AMT    ,                               28490000
MFA-TR*               TRIGGER_DATE      ,                               28500000
MFA-TR*               BOND_EXPIRATION_DT,                               28510000
MFA-TR*               WAIVER_TYPE_CD    ,                               28520000
MFA-TR*               ADDRESS_ID        ,                               28530000
MFA-TR*               USER_ID_ORIG_BY   ,                               28540000
MFA-TR*               WAIVER_SOURCE_DESC,                               28550000
MFA-TR*               COMMENTS)                                         28560000
MFA-TR*       VALUES (:SB-ACCOUNT-NO        ,                           28570000
MFA-TR*               :SB-BOND-WAIV-ITEM-ID ,                           28580000
MFA-TR*               :SB-BOND-NO           ,                           28590000
MFA-TR*               :SB-DATE-BOND-ISSUED:WS-DATE-BOND-ISSUED-NI,      28600000
MFA-TR*               :SB-TERM-OF-BOND      ,                           28610000
MFA-TR*               :SB-AMT-BOND          ,                           28620000
MFA-TR*               :SB-CODE-BOND-TYPE    ,                           28630000
MFA-TR*               :SB-BOND-CO-NO        ,                           28640000
MFA-TR*               :SB-BOND-CO-CUST-NO   ,                           28650000
MFA-TR*               :SB-CODE-STATUS       ,                           28660000
MFA-TR*               :SB-CODE-STATUS-REAS  ,                           28670000
MFA-TR*               :SB-BOND-TOTAL-AMT    ,                           28680000
MFA-TR*               :SB-TRIGGER-DATE:WS-TRIGGER-DATE-NI,              28690000
MFA-TR*               :SB-BOND-EXPIRATION-DT:WS-BOND-EXPIRATION-DT-NI,  28700000
MFA-TR*               :SB-WAIVER-TYPE-CD    ,                           28710000
MFA-TR*               :SB-ADDRESS-ID        ,                           28720000
MFA-TR*               :SB-USER-ID-ORIG-BY   ,                           28730000
MFA-TR*               :SB-WAIVER-SOURCE-DESC,                           28740000
MFA-TR*               :SB-COMMENTS)                                     28750000
MFA-TR*    END-EXEC.                                                    28760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28770000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 28790000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BOND_WAIV_ITEM_ID'        TO TABLE-ELEMENT-2        
              MOVE 'DATE_BOND_ISSUED'         TO TABLE-ELEMENT-3        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE SB-BOND-WAIV-ITEM-ID       TO HOSTVAR-ELEMENT-2      
              MOVE SB-DATE-BOND-ISSUED        TO HOSTVAR-ELEMENT-3      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 28930000
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28960000
      ***************************************************************** 28970000
      * 8355-DEL-SYS-WAIVER*                                          * 28980000
      * SPECIFICALLY DELETES 'SYSTEM TRANSFER' WAIVERS FOR XFER-TO    * 28981000
      * ACCOUNT BECAUSE THEY ARE NO LONGER NECESSARY AFTER XFER OCCURS* 28982000
      ***************************************************************** 28990000
       8355-DEL-SYS-WAIVER.                                             
      *                                                                 29010000
           EXEC SQL                                                     
              DELETE FROM CSS_SURETY_BOND                               
               WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO                 
                 AND WAIVER_TYPE_CD    = 'K'                            
                 AND CODE_STATUS       = 'A'                            
                 AND CODE_BOND_TYPE    = 'C'                            
                 AND COMMENTS          = 'WAIVER ADDED BY SYSTEM'       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29070000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 29090000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8355'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 29230000
       8355-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29260000
      ***************************************************************** 28970000
      * 8360-DELETE-SURETY-BOND                                       * 28980000
      ***************************************************************** 28990000
       8360-DELETE-SURETY-BOND.                                         
      *                                                                 29010000
           EXEC SQL                                                     
              DELETE FROM CSS_SURETY_BOND                               
               WHERE ACCOUNT_NO        = :SB-ACCOUNT-NO                 
                 AND BOND_WAIV_ITEM_ID = :SB-BOND-WAIV-ITEM-ID          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29070000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 29090000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8360'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_SURETY_BOND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BOND_WAIV_ITEM_ID'        TO TABLE-ELEMENT-2        
              MOVE SB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE SB-BOND-WAIV-ITEM-ID       TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 29230000
       8360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29230000
      ***************************************************************** 28970000
      * 8365-UPDATE-CODE-DATA-PRESENT                                 * 28980000
      ***************************************************************** 28990000
       8365-UPDATE-CODE-DATA-PRESENT.                                   
      *                                                                 29010000
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29070000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 29090000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8365'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODES_DATA_PRESENT'       TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AT-CODES-DATA-PRESENT      TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-DO-BUS-RULE-ABEND  THRU 9100-EXIT            
           END-IF.                                                      
      *                                                                 29230000
       8365-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29230000
      ******************************************************************        
      * 8610-INSERT-SO-DNP-CANCEL                                      *        
      ******************************************************************        
       8610-INSERT-SO-DNP-CANCEL.                                       
      *                                                                         
           MOVE WS-U          TO XK-SO-UPDT-ACTION-FL.                  
           MOVE AT-ACCOUNT-NO TO XK-ACCOUNT-NO.                         
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_SO_DNP_CANCEL                             
                ( ACCOUNT_NO,                                           
                  SO_UPDT_ACTION_FL )                                   
              VALUES ( :XK-ACCOUNT-NO,                                  
                       :XK-SO-UPDT-ACTION-FL )                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL -803                          
              MOVE ZERO TO WS-ACTIVE-RETURN-CODE                        
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8610'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SO_DNP_CANCEL'       TO TABLE-1                 
              MOVE XK-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE XK-SO-UPDT-ACTION-FL      TO HOSTVAR-ELEMENT-2       
              MOVE 'XK-ACCOUNT-NO'           TO TABLE-ELEMENT-1         
              MOVE 'XK-SO-UPDT-ACTION-FL'    TO TABLE-ELEMENT-2         
              PERFORM 9100-DO-BUS-RULE-ABEND THRU 9100-EXIT             
           END-IF.                                                      
      *                                                                         
       8610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE  END PROGRAM COPYLIB CPD00321 WILL NOT WORK     *        
      *                 BECAUSE IT INITS THE GTT FIELDS THAT NEED TO GO*        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
ACT257*                                                                         
ACT257     IF WS-ACTIVE-RETURN-CODE = 5653                              
ACT257        MOVE ZERO                  TO RS-RETURN-CODE              
ACT257                                      S-RETURN-CODE               
ACT257        MOVE 'ARXFR00038'          TO S-BUS-RULE-ID               
ACT257        MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
ACT257        IF S-BUS-RULE-ID > SPACES                                 
ACT257           PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
ACT257        END-IF                                                    
ACT257        MOVE 'N'                   TO SEND-DONE-SW                
ACT257        MOVE S-RETURN-CODE         TO ABEND-SQLCODE               
ACT257        MOVE SQLERRMC              TO ABEND-SQLERRMC              
ACT257        EXEC SQL                                                  
ACT257            ROLLBACK                                              
ACT257        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT257        PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
ACT257     END-IF.                                                      
      *                                                                         
           IF S-BUS-RULE-ID = SPACES                                    
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE 'CMN0000013' TO S-BUS-RULE-ID                        
              MOVE 'F'          TO S-BUS-RULE-RESULT-CD                 
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT           
              END-IF                                                    
              MOVE 'N'                   TO SEND-DONE-SW                
              MOVE S-RETURN-CODE         TO ABEND-SQLCODE               
              MOVE SQLERRMC              TO ABEND-SQLERRMC              
              EXEC SQL                                                  
                  ROLLBACK                                              
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
              GO TO 9000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           MOVE S-RETURN-CODE         TO ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *8999-ISSUE-COMMIT.                                                       
      ******************************************************************        
       8999-ISSUE-COMMIT.                                               
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                    
      *                                                                         
       8999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *9100-DO-BUS-RULE-ABEND.                                         *        
      *     DO THE BUSINESS RULE LOGIC AND ABEND.                      *        
      ******************************************************************        
       9100-DO-BUS-RULE-ABEND.                                          
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE 'CMN0000013' TO S-BUS-RULE-ID.                          
           MOVE 'F'          TO S-BUS-RULE-RESULT-CD.                   
           IF S-BUS-RULE-ID > SPACES                                    
              PERFORM 7040-GET-RULE-XREF-ID THRU 7040-EXIT              
           END-IF.                                                      
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700 - SPECIAL / ERROR HANDLING ROUTINE                     *           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
