       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04593.                                         
COB303 DATE-WRITTEN. DECEMBER 15,2012.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      D*****************************************************************
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM INSERTS/UPDATES/DELETES FROM CSS_MSTSUB_ACCT AND *        
      *  UPDATES CSS_ACCOUNT BASED ON THE ACTION PARAMETER.            *        
      *                                                                *        
      *  INPUT PARAMETERS.                                             *        
      *  -----------------                                             *        
      *        OPERATION_TYPE     CHAR(01)                             *        
      *        MAKE_MASTER_FLG    CHAR(01)                             *        
      *        MST_ACCT_NO        DECIMAL(13)                          *        
      *        CODE_PRNT_BLL_MST  CHAR(01)                             *        
      *        SUB_ACCT_NO        DECIMAL(13)                          *        
      *        CODE_SUB_TOTAL     CHAR(18)                             *        
      *        SUB_ACTION_IND     CHAR(01)                             *        
      *        TRAN_COMMENT       CHAR(255)                            *        
      *        USER_ID            CHAR(07)                             *        
      *        PRNT_SUB_BILL      CHAR(01)                             *        
      *        SUB_ACCT_BLLD_OK   CHAR(01)                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00733*  12-14-12  MS93554    INITIAL PROGRAM VERSION.                 *        
A04527*  25-09-13  AS7C117    IF PRNT-SUB-BILL IS NOT YES,             *        
A04527*            ACT157     ALL THE ROWS FROM CSS_HELD_BP_SUBS       *        
A04527*                       SHOULD BE DELETED FOR THE SUB ACCOUNT    *        
ACT278*  20-09-16  TP7R341    REMOVE UNWANTED COLUMNS FROM CONTRACT    *        
ACT278*   A05460              TABLE                                    *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04593'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04593 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MSTSUB_ACCT   MU                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT       AT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_HELD_BP_SUBS  HB                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHLDBPS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET MI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST MH                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CONTRACT       CT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_AR_CNTL        AC                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BANK_EFT       BE                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE     UV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04593'.      
COB305     05 WS-LL-MST-ACCT-NUM        PIC S9(13)V COMP-3 VALUE 0.             
           05  WS-AR-XFER-IND          PIC X(01).                       
           05  WS-BILL-HIST-XFER-IND   PIC X(01).                       
           05  WS-MST-SUB-ACCT-IND     PIC X(01).                       
           05  WS-CREDIT-GROUP         PIC X(01).                       
           05  WS-ACCOUNT-TYPE-CODE    PIC X(01).                       
           05  WS-COUNT-SUB-ACCT       PIC S9(04) COMP VALUE 0.         
           05  WS-COUNT-CONTRACT       PIC S9(04) COMP VALUE 0.         
           05  WS-ACCT-STATUS          PIC X(01).                       
           05  WS-NULL-IND-1           PIC S9(4)  COMP.                 
           05  WS-RESP-AREA-ID         PIC X(03)  VALUE SPACES.         
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE ZERO.      
           05  WS-MST-OVRRD-BLL-IND-OLD  PIC X(01) VALUE SPACES.        
           05  WS-CODE-PRNT-BLL-MST-OLD  PIC X(01) VALUE SPACES.        
           05  WS-ACCOUNT-TYPE-CD-OLD  PIC X(01)  VALUE SPACES.         
           05  WS-MST-SUB-ACCT-IND-OLD PIC X(01)  VALUE SPACES.         
           05  WS-AR-XFER-IND-OLD      PIC X(01)  VALUE SPACES.         
           05  WS-BILL-TYPE-OLD        PIC X(01)  VALUE SPACES.         
           05  WS-SUB-ACCT-BLLED-OK    PIC X(01)  VALUE SPACES.         
           05  WS-BILL-HIST-XFER-IND-OLD PIC X(01) VALUE SPACES.        
           05  WS-USER-ID              PIC X(07).                       
           05  WS-CURRENT-TIMESTAMP    PIC X(26).                       
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-PREV-SHORT-DESC-LEN  PIC S9(4) USAGE COMP.            
           05  WS-CURR-SHORT-DESC-LEN  PIC S9(4) USAGE COMP.            
           05  WS-PREV-SHORT-DESC      PIC X(16) VALUE SPACES.          
           05  WS-CURR-SHORT-DESC      PIC X(16) VALUE SPACES.          
                                                                        
       01  WS-INPUT-VALUES.                                             
COB305     05 WS-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
COB305     05 WS-SUB-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
           05  WS-MAKE-MASTER-FLG      PIC X(01)  VALUE SPACES.         
           05  WS-CODE-SUB-TOTAL       PIC X(18)  VALUE SPACES.         
           05  WS-CODE-PRNT-BLL-MST    PIC X(01)  VALUE SPACES.         
           05  WS-PRNT-SUB-BILL        PIC X(01)  VALUE SPACES.         
           05  WS-TRAN-COMMENT         PIC X(255) VALUE SPACES.         
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26)                        
                                       VALUE 'SESSION.CSR04593_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-DEPOSITS-EXISTS      PIC X(01)  VALUE 'N'.            
           05  WS-RECVBLS-EXISTS       PIC X(01)  VALUE 'N'.            
           05  WS-MST-ACCT-ONLY        PIC X(01)  VALUE 'A'.            
           05  WS-NON-UTIL-ACCT        PIC X(01)  VALUE 'N'.            
           05  WS-MASTER-ACCT          PIC X(01)  VALUE 'B'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-BYPASSED             PIC X(01)  VALUE 'B'.            
           05  WS-INACTIVE             PIC X(01)  VALUE 'J'.            
           05  WS-MASTER               PIC X(01)  VALUE 'M'.            
           05  WS-FAILED               PIC X(01)  VALUE 'F'.            
           05  WS-PASSED               PIC X(01)  VALUE 'P'.            
           05  WS-UPDATE               PIC X(01)  VALUE 'U'.            
           05  WS-DELETE               PIC X(01)  VALUE 'D'.            
           05  WS-INSERT               PIC X(01)  VALUE 'I'.            
           05  WS-SPACE                PIC X(01)  VALUE SPACE.          
           05  WS-ACTIVE               PIC X(01)  VALUE 'A'.            
           05  WS-ZERO                 PIC S9(04) COMP VALUE 0.         
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-SUB                  PIC X(01)  VALUE 'S'.            
           05  WS-ONE                  PIC S9(04) COMP VALUE 1.         
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-M1                   PIC X(01)  VALUE 'M'.            
           05  WS-N1                   PIC X(01)  VALUE 'N'.            
           05  WS-A                    PIC X(01)  VALUE 'A'.            
           05  WS-B                    PIC X(01)  VALUE 'B'.            
           05  WS-C                    PIC X(01)  VALUE 'C'.            
           05  WS-D                    PIC X(01)  VALUE 'D'.            
           05  WS-E                    PIC X(01)  VALUE 'E'.            
           05  WS-F                    PIC X(01)  VALUE 'F'.            
           05  WS-M                    PIC X(01)  VALUE 'M'.            
           05  WS-P                    PIC X(01)  VALUE 'P'.            
           05  WS-S                    PIC X(01)  VALUE 'S'.            
                                                                        
       01  WS-BUS-RULE-ERROR.                                           
           05 WS-BUSRUL-SUBACCT-NOT-EXIST  PIC X(10) VALUE 'CB00000001'.
           05 WS-BUSRUL-SUBACCT-ON-EPAY    PIC X(10) VALUE 'CB00000002'.
           05 WS-BUSRUL-SUBACCT-ON-BDGT-BLNG PIC X(10)                  
                                                     VALUE 'CB00000003'.
           05 WS-BUSRUL-SUBACCT-HAS-SECUTY PIC X(10) VALUE 'CB00000004'.
           05 WS-BUSRUL-SUBACCT-IS-FNALBIL PIC X(10) VALUE 'CB00000005'.
           05 WS-BUSRUL-SUBACCT-IS-INACTV  PIC X(10) VALUE 'CB00000006'.
           05 WS-BUSRUL-SUBACCT-IS-WRTOFF  PIC X(10) VALUE 'CB00000007'.
           05 WS-BUSRUL-SUBACCT-ON-BNKRPTC PIC X(10) VALUE 'CB00000008'.
           05 WS-BUSRUL-SUBACCT-HAS-DPP    PIC X(10) VALUE 'CB00000009'.
           05 WS-BUSRUL-SUBACCT-HAS-DFA    PIC X(10) VALUE 'CB00000010'.
           05 WS-BUSRUL-SUBACCT-HAS-CNT    PIC X(10) VALUE 'CB00000011'.
           05 WS-BUSRUL-MSTACCT-NOT-SUBACCT                             
                                           PIC X(10) VALUE 'CB00000012'.
           05 WS-BUSRUL-ACCT-ALRDY-SUBACCT PIC X(10) VALUE 'CB00000013'.
           05 WS-BUSRUL-ACCT-HAS-RCVBLE-DEP                             
                                           PIC X(10) VALUE 'CB00000014'.
           05 WS-BUSRUL-ACCT-HAS-RCVBLE    PIC X(10) VALUE 'CB00000015'.
           05 WS-BUSRUL-ACCT-HAS-DEPOSIT   PIC X(10) VALUE 'CB00000016'.
           05 WS-BUSRUL-TRNSFR-CNT-MST-2-SUB                            
                                           PIC X(10) VALUE 'CB00000024'.
           05 WS-BUSRUL-SUBACCT-HAS-ACTV-SEC                            
                                           PIC X(10) VALUE 'CB00000025'.
           05 WS-BUSRUL-NO-BILL-FOR-SUBACCT                             
                                           PIC X(10) VALUE 'CB00000026'.
                                                                        
       01  WS-VALIDATION-MISC.                                          
           05  WS-EPP-IND              PIC X(01)      VALUE 'N'.        
           05  WS-SEC-IND              PIC X(01)      VALUE 'N'.        
           05  WS-ALRDY-MST-ACCT       PIC X(01)      VALUE 'N'.        
           05  WS-FINAL-BILL           PIC X(01)      VALUE 'N'.        
           05  WS-BANKRUPT-IND         PIC X(01)      VALUE 'N'.        
           05  WS-WRITE-OFF            PIC X(01)      VALUE 'N'.        
           05  WS-INACTIVE-IND         PIC X(01)      VALUE 'N'.        
           05  WS-SUBACCT-EXISTS       PIC X(01)      VALUE 'N'.        
           05  WS-DPP-IND              PIC X(01)      VALUE 'N'.        
           05  WS-DFA-ACCT-IND         PIC X(01)      VALUE 'N'.        
           05  WS-CONTRACT-IND         PIC X(01)      VALUE 'N'.        
           05  WS-ACCT-ON-EPAY-IND     PIC X(01)      VALUE 'N'.        
           05  WS-ACCT-EXIST-IND       PIC X(01)      VALUE SPACES.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.         
           05  S-BUS-RULE-ID           PIC X(10)  VALUE SPACE.          
           05  S-BUS-RULE-RESULT-CD    PIC X(08)  VALUE SPACE.          
           05  S-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACE.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-OPERATION-TYPE       PIC X(01) VALUE SPACES.          
               88 MASTER-ACCT                    VALUE 'M'.             
               88 SUB-ACCT                       VALUE 'S'.             
           05  WS-LANDLORD-EXISTS      PIC X(01) VALUE 'N'.             
               88 LANDLORD-EXISTS                VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
      ******************************************************************        
      *    CURSOR TO FETCH ALL THE SUB ACCOUNTS FOR THE MASTER ACCT    *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE SUB_ACCT_CURSOR CURSOR FOR                         
              SELECT MU.SUB_ACCT_NO                                     
                FROM CSS_MSTSUB_ACCT MU WITH(READUNCOMMITTED)                   
               WHERE MU.MST_ACCT_NO       = :WS-MST-ACCT-NO             
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUB_ACCT_CURSOR CURSOR FOR                                 
MFA-TR*       SELECT MU.SUB_ACCT_NO                                             
MFA-TR*         FROM CSS_MSTSUB_ACCT MU                                         
MFA-TR*        WHERE MU.MST_ACCT_NO       = :WS-MST-ACCT-NO                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-OPERATION-TYPE      PIC X(01).                          
       01  PARM-MAKE-MASTER-FLG     PIC X(01).                          
COB305 01 PARM-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.                 
       01  PARM-CODE-PRNT-BLL-MST   PIC X(01).                          
COB305 01 PARM-SUB-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.                 
       01  PARM-CODE-SUB-TOTAL      PIC X(18).                          
       01  PARM-SUB-ACTION-IND      PIC X(01).                          
       01  PARM-TRAN-COMMENT        PIC X(255).                         
       01  PARM-USER-ID             PIC X(07).                          
       01  PARM-PRNT-SUB-BILL       PIC X(01).                          
       01  PARM-SUB-ACCT-BLLED-OK   PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  PARM-OPERATION-TYPE                    
                                ,PARM-MAKE-MASTER-FLG                   
                                ,PARM-MST-ACCT-NO                       
                                ,PARM-CODE-PRNT-BLL-MST                 
                                ,PARM-SUB-ACCT-NO                       
                                ,PARM-CODE-SUB-TOTAL                    
                                ,PARM-SUB-ACTION-IND                    
                                ,PARM-TRAN-COMMENT                      
                                ,PARM-USER-ID                           
                                ,PARM-PRNT-SUB-BILL                     
                                ,PARM-SUB-ACCT-BLLED-OK.                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT             THRU 0100A-EXIT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04593_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04593_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04593_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04593_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-OPERATION-TYPE         TO WS-OPERATION-TYPE.       
           MOVE PARM-MAKE-MASTER-FLG        TO WS-MAKE-MASTER-FLG.      
           MOVE PARM-MST-ACCT-NO            TO WS-MST-ACCT-NO.          
           MOVE PARM-SUB-ACCT-NO            TO WS-SUB-ACCT-NO           
                                               BE-ACCOUNT-NO.           
           MOVE PARM-CODE-SUB-TOTAL         TO WS-CODE-SUB-TOTAL.       
           MOVE PARM-PRNT-SUB-BILL          TO WS-PRNT-SUB-BILL.        
           MOVE PARM-CODE-PRNT-BLL-MST      TO WS-CODE-PRNT-BLL-MST     
                                               AT-CODE-PRNT-BLL-MST.    
           MOVE PARM-USER-ID                TO WS-USER-ID.              
           MOVE PARM-TRAN-COMMENT           TO WS-TRAN-COMMENT.         
           MOVE PARM-SUB-ACCT-BLLED-OK      TO WS-SUB-ACCT-BLLED-OK.    
                                                                        
           PERFORM 7005-GET-CURR-DATE          THRU 7005-EXIT.          
           PERFORM 7150-SELECT-RESP-AREA       THRU 7150-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
             WHEN MASTER-ACCT                                           
                  PERFORM 2100-MST-ACCT-PROCESS      THRU 2100-EXIT     
             WHEN SUB-ACCT                                              
                  PERFORM 2150-SUB-ACCT-PROCESS      THRU 2150-EXIT     
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS EQUAL WS-ZERO                                    
              PERFORM 8100-SEND-RESULT               THRU 8100-EXIT     
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-MST-ACCT-PROCESS.                                         *        
      ******************************************************************        
       2100-MST-ACCT-PROCESS.                                           
                                                                        
           PERFORM 7010-SELECT-ACCOUNT           THRU 7010-EXIT.        
                                                                        
           IF WS-MAKE-MASTER-FLG EQUAL WS-YES                           
              PERFORM 8000-UPD-MST-ACCT          THRU 8000-EXIT         
              PERFORM 5050-WRITE-TRANS-HIST      THRU 5050-EXIT         
           ELSE                                                         
              PERFORM 8010-UPD-CODE-PRNT-BLL-MST THRU 8010-EXIT         
              PERFORM 8050-UPD-CODE-PRNT-BLL-SUB THRU 8050-EXIT         
              PERFORM 5050-WRITE-TRANS-HIST      THRU 5050-EXIT         
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-SUB-ACCT-PROCESS.                                         *        
      *                                                                *        
      ******************************************************************        
        2150-SUB-ACCT-PROCESS.                                          
                                                                        
           PERFORM 2200-PROCESS-SUBACCT             THRU 2200-EXIT.     
                                                                        
           IF WS-RECVBLS-EXISTS     EQUAL WS-YES                        
              IF WS-DEPOSITS-EXISTS EQUAL WS-YES                        
                 IF PARM-SUB-ACTION-IND EQUAL WS-DELETE                 
                    MOVE WS-BUSRUL-SUBACCT-HAS-ACTV-SEC TO S-BUS-RULE-ID
                 ELSE                                                   
                    MOVE WS-BUSRUL-ACCT-HAS-RCVBLE-DEP  TO S-BUS-RULE-ID
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-BUSRUL-ACCT-HAS-RCVBLE  TO S-BUS-RULE-ID       
              END-IF                                                    
              MOVE WS-FAILED                     TO S-BUS-RULE-RESULT-CD
              PERFORM 2500-INSERT-RULE-ID           THRU 2500-EXIT      
           ELSE                                                         
              IF WS-DEPOSITS-EXISTS     EQUAL WS-YES                    
                 IF PARM-SUB-ACTION-IND EQUAL WS-DELETE                 
                    MOVE WS-BUSRUL-SUBACCT-HAS-ACTV-SEC TO S-BUS-RULE-ID
                 ELSE                                                   
                    MOVE WS-BUSRUL-ACCT-HAS-DEPOSIT     TO S-BUS-RULE-ID
                 END-IF                                                 
                 MOVE WS-FAILED                  TO S-BUS-RULE-RESULT-CD
                 PERFORM 2500-INSERT-RULE-ID        THRU 2500-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-COUNT-CONTRACT GREATER THAN WS-ZERO                    
              MOVE WS-BUSRUL-TRNSFR-CNT-MST-2-SUB                       
                                                 TO S-BUS-RULE-ID       
              MOVE WS-FAILED                     TO S-BUS-RULE-RESULT-CD
              PERFORM 2500-INSERT-RULE-ID           THRU 2500-EXIT      
           END-IF.                                                      
                                                                        
        2150-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-SUBACCT                                           *        
      ******************************************************************        
       2200-PROCESS-SUBACCT.                                            
                                                                        
      *    CHECK IF SUBACCOUNT EXISTS ON CSS_ACCOUNT TABLE.                     
           MOVE WS-SUB-ACCT-NO              TO AT-ACCOUNT-NO.           
           PERFORM 7000-SELECT-ACCOUNT         THRU 7000-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-YES                      TO WS-ACCT-EXIST-IND     
              MOVE AT-MST-SUB-ACCT-IND         TO WS-MST-SUB-ACCT-IND   
              MOVE AT-CREDIT-GROUP             TO WS-CREDIT-GROUP       
              MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT 
      *       MOVE AT-BILL-CYCLE               TO WS-SUB-BILL-CYCLE             
      *       MOVE AT-REV-MTH-LST-NRML         TO WS-SUB-REV-MTH-LST            
      *       MOVE WS-NULL-IND-1               TO WS-SUB-00-DAY-NULL            
           ELSE                                                         
              MOVE WS-NO                       TO WS-ACCT-EXIST-IND     
              MOVE WS-BUSRUL-SUBACCT-NOT-EXIST TO S-BUS-RULE-ID         
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
              PERFORM 2500-INSERT-RULE-ID         THRU 2500-EXIT        
           END-IF.                                                      
                                                                        
      *    ALSO CHECK FOR INSERT DETAIL, IF SUB ACCT ALREADY EXISTS.            
           IF PARM-SUB-ACTION-IND EQUAL WS-INSERT  AND                  
              AT-MST-SUB-ACCT-IND EQUAL WS-SUB     AND                  
              WS-ACCT-EXIST-IND   EQUAL WS-YES                          
              MOVE WS-YES                   TO WS-SUBACCT-EXISTS        
              MOVE WS-BUSRUL-ACCT-ALRDY-SUBACCT                         
                                            TO S-BUS-RULE-ID            
              MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD     
              PERFORM 2500-INSERT-RULE-ID      THRU 2500-EXIT           
           END-IF.                                                      
                                                                        
      *    VALIDATE ONLY WHEN THE INDICATOR IS INSERT / UPDATE.                 
           IF WS-ACCT-EXIST-IND EQUAL WS-YES AND                        
              WS-SUBACCT-EXISTS EQUAL WS-NO  AND                        
              PARM-SUB-ACTION-IND NOT EQUAL WS-DELETE                   
              PERFORM 2300-CD-DATA-PRSNT-VLDTN    THRU 2300-EXIT        
           END-IF.                                                      
                                                                        
      *    CHECK THAT SUBACCOUNT IS NOT ALREADY AN EXISTING MASTER ACCT.        
           PERFORM 2400-VALIDATE-SUB-ACCT         THRU 2400-EXIT.       
                                                                        
      *    PERFORM UPDATE/INSERT/DELETE BASED ON THE ACTION IND.                
           PERFORM 2600-INSRT-UPD-DEL-PROCESS     THRU 2600-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2300-CD-DATA-PRSNT-VLDTN.                                       *        
      ******************************************************************        
       2300-CD-DATA-PRSNT-VLDTN.                                        
                                                                        
      *    CHECK FOR  EPAYMENT ACCOUNT NUMBERS                                  
           PERFORM 7450-SELECT-EPAY-ACCOUNT       THRU 7450-EXIT        
           MOVE WS-BUSRUL-SUBACCT-ON-EPAY      TO S-BUS-RULE-ID         
           IF WS-ACCT-ON-EPAY-IND EQUAL WS-YES                          
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
      *    BASED ON THE CODES_DATA_PRESENT SET RESPECTIVE FLAGS.                
           MOVE WS-BUSRUL-SUBACCT-ON-BDGT-BLNG TO S-BUS-RULE-ID         
           IF WS-CODE-BUDGET EQUAL 'A'                                  
              MOVE WS-YES                      TO WS-EPP-IND            
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-HAS-SECUTY   TO S-BUS-RULE-ID         
           IF (WS-CODE-DEP-ON-HAND  EQUAL 'A') OR                       
              (WS-CODE-GUARANTOR    EQUAL 'A')                          
              MOVE WS-YES                      TO WS-SEC-IND            
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           IF PARM-SUB-ACTION-IND EQUAL WS-INSERT                       
              MOVE WS-BUSRUL-SUBACCT-IS-FNALBIL TO S-BUS-RULE-ID        
              IF AT-CODE-ACCT-STAT EQUAL 'B'                            
                 MOVE WS-YES                   TO WS-FINAL-BILL         
                 MOVE WS-FAILED                TO S-BUS-RULE-RESULT-CD  
              ELSE                                                      
                 MOVE WS-PASSED                TO S-BUS-RULE-RESULT-CD  
              END-IF                                                    
              PERFORM 2500-INSERT-RULE-ID         THRU 2500-EXIT        
           END-IF.                                                      
                                                                        
           MOVE WS-BUSRUL-SUBACCT-IS-INACTV    TO S-BUS-RULE-ID         
           IF AT-CODE-ACCT-STAT EQUAL WS-INACTIVE                       
              MOVE WS-YES                      TO WS-INACTIVE-IND       
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-IS-WRTOFF    TO S-BUS-RULE-ID         
           IF AT-CODE-ACCT-STAT EQUAL 'S'                               
              MOVE WS-YES                      TO WS-WRITE-OFF          
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-ON-BNKRPTC   TO S-BUS-RULE-ID         
           IF AT-BANKRUPTCY-IND EQUAL 'B'                               
              MOVE WS-YES                      TO WS-BANKRUPT-IND       
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-HAS-DPP      TO S-BUS-RULE-ID         
           IF WS-CODE-DPP-ACCT EQUAL 'A'                                
              MOVE WS-YES                      TO WS-DPP-IND            
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-HAS-DFA      TO S-BUS-RULE-ID         
           IF WS-CODE-DFA-ACCT EQUAL 'A'                                
              MOVE WS-YES                      TO WS-DFA-ACCT-IND       
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
           MOVE WS-BUSRUL-SUBACCT-HAS-CNT      TO S-BUS-RULE-ID         
           IF WS-CODE-CONTRACT EQUAL 'A'                                
              MOVE WS-YES                      TO WS-CONTRACT-IND       
              MOVE WS-FAILED                   TO S-BUS-RULE-RESULT-CD  
           ELSE                                                         
              MOVE WS-PASSED                   TO S-BUS-RULE-RESULT-CD  
           END-IF.                                                      
           PERFORM 2500-INSERT-RULE-ID            THRU 2500-EXIT.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2400-VALIDATE-SUB-ACCT.                                         *        
      ******************************************************************        
       2400-VALIDATE-SUB-ACCT.                                          
                                                                        
           IF (WS-EPP-IND           EQUAL  WS-NO)                       
             AND (WS-SEC-IND        EQUAL  WS-NO)                       
             AND (WS-ACCT-EXIST-IND EQUAL  WS-YES)                      
             AND (WS-INACTIVE-IND   EQUAL  WS-NO)                       
             AND (WS-WRITE-OFF      EQUAL  WS-NO)                       
             AND (WS-BANKRUPT-IND   EQUAL  WS-NO)                       
             AND (WS-DPP-IND        EQUAL  WS-NO)                       
             AND (WS-DFA-ACCT-IND   EQUAL  WS-NO)                       
             AND (WS-CONTRACT-IND   EQUAL  WS-NO)                       
                                                                        
             PERFORM 7100-SELECT-MASTER        THRU 7100-EXIT           
             IF WS-ALRDY-MST-ACCT EQUAL WS-YES                          
                MOVE WS-BUSRUL-MSTACCT-NOT-SUBACCT                      
                                            TO S-BUS-RULE-ID            
                MOVE WS-FAILED              TO S-BUS-RULE-RESULT-CD     
                PERFORM 2500-INSERT-RULE-ID    THRU 2500-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE WS-YES                      TO WS-AR-XFER-IND           
                                               WS-BILL-HIST-XFER-IND.   
                                                                        
      *    CHECK IF THE SUB ACCOUNT IS A NON UTILITY ACCOUNT                    
           IF WS-CODE-UTL       EQUAL  SPACES AND                       
              WS-CODE-BUDGET    EQUAL  SPACES AND                       
              AT-CODE-ACCT-STAT NOT EQUAL WS-P                          
              MOVE WS-YES                   TO WS-NON-UTIL-ACCT         
           ELSE                                                         
              MOVE WS-NO                    TO WS-NON-UTIL-ACCT         
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2500-INSERT-RULE-ID.                                           *        
      ******************************************************************        
       2500-INSERT-RULE-ID.                                             
                                                                        
           IF S-BUS-RULE-ID GREATER THAN SPACES                         
              PERFORM 7430-GET-RULE-XREF-ID    THRU 7430-EXIT           
           END-IF                                                       
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2600-INSRT-UPD-DEL-PROCESS.                                    *        
      ******************************************************************        
       2600-INSRT-UPD-DEL-PROCESS.                                      
                                                                        
           IF PARM-SUB-ACTION-IND EQUAL WS-DELETE OR                    
             (   (WS-EPP-IND          = WS-NO)                          
             AND (WS-SEC-IND          = WS-NO)                          
             AND (WS-ALRDY-MST-ACCT   = WS-NO)                          
             AND (WS-ACCT-EXIST-IND   = WS-YES)                         
             AND (WS-INACTIVE-IND     = WS-NO)                          
             AND (WS-WRITE-OFF        = WS-NO)                          
             AND (WS-BANKRUPT-IND     = WS-NO)                          
             AND (WS-SUBACCT-EXISTS   = WS-NO)                          
             AND (WS-DPP-IND          = WS-NO)                          
             AND (WS-DFA-ACCT-IND     = WS-NO)                          
             AND (WS-CONTRACT-IND     = WS-NO)                          
             AND (WS-ACCT-ON-EPAY-IND = WS-NO))                         
                                                                        
      * CHECK IF SUB HAS ANY ACTIVE RECEIVABLES OR DEPOSITS.                    
             PERFORM 7425-SELECT-SUB-RECVBLS          THRU 7425-EXIT    
             PERFORM 7426-SELECT-SUB-DEPOSITS         THRU 7426-EXIT    
                                                                        
             IF WS-RECVBLS-EXISTS  EQUAL WS-NO  AND                     
                WS-DEPOSITS-EXISTS EQUAL WS-NO                          
                                                                        
                PERFORM 5000-PROCESS-TRAN-COMM        THRU 5000-EXIT    
                                                                        
                EVALUATE PARM-SUB-ACTION-IND                            
                    WHEN WS-DELETE                                      
                                                                        
                      IF WS-NON-UTIL-ACCT = WS-YES                      
                         MOVE WS-D          TO WS-CREDIT-GROUP          
                      ELSE                                              
                         MOVE WS-C          TO WS-CREDIT-GROUP          
                      END-IF                                            
                                                                        
      * LOOK FOR ACTIVE/PENDING MONTHLY CREDIT CONTRACTS. MONTHLY               
      * CREDIT CONTRACT ROWS MAY NOT BE PRESENT IN AR CONTROL.                  
                      PERFORM 7700-CHK-CONTRACT          THRU 7700-EXIT 
                      IF WS-COUNT-CONTRACT EQUAL WS-ZERO                
                         PERFORM 7800-GET-CONTRACT-CNT   THRU 7800-EXIT 
                      END-IF                                            
                                                                        
                      PERFORM 8300-DELETE-SUBACCT        THRU 8300-EXIT 
                      PERFORM 8600-UPDATE-ACCT-AFTER-DEL THRU 8600-EXIT 
                                                                        
      * CK IF INDICATOR IS SET TO 'Y' (PRINT THE SUBS BILL AFTER IT HAS         
      * BEEN DELETED). IF SO, UPDATE THE CSS_HELD_BP_SUBS TABLE,                
      * PULL-FL COLUMN WITH A 'D'. THIS WILL TRIGGER BILL PRINT TO              
      * PRINT THE SUB'S BILL.                                                   
                      IF WS-PRNT-SUB-BILL EQUAL WS-YES                  
                         PERFORM 8650-UPD-HELD-BP-SUBS   THRU 8650-EXIT 
                         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                            MOVE WS-BUSRUL-NO-BILL-FOR-SUBACCT          
                                                 TO S-BUS-RULE-ID       
                            MOVE WS-FAILED       TO S-BUS-RULE-RESULT-CD
                            PERFORM 2500-INSERT-RULE-ID  THRU 2500-EXIT 
                         END-IF                                         
A04527                ELSE                                              
A04527                   PERFORM 8350-DEL-HELD-BP-SUBS   THRU 8350-EXIT 
                      END-IF                                            
                                                                        
      * RESET CREDIT GROUP TO NON-UTILITY IF MASTER ACCOUNT IS NON UTILI        
                      PERFORM 7600-GET-SUBACCT-CNT        THRU 7600-EXIT
                      IF WS-COUNT-SUB-ACCT EQUAL WS-ZERO                
                        MOVE WS-MST-ACCT-NO      TO AT-ACCOUNT-NO       
                                                    WS-LL-MST-ACCT-NUM  
                        PERFORM 7000-SELECT-ACCOUNT       THRU 7000-EXIT
                        MOVE AT-CREDIT-GROUP     TO WS-CREDIT-GROUP     
                        MOVE AT-CODES-DATA-PRESENT TO                   
                                                 WS-CODES-DATA-PRESENT  
                        MOVE WS-D                TO WS-CREDIT-GROUP     
                        MOVE WS-ACTIVE           TO WS-ACCT-STATUS      
                        MOVE SPACES              TO WS-MST-SUB-ACCT-IND 
                        MOVE WS-NO               TO WS-ACCOUNT-TYPE-CODE
                                                                        
                        PERFORM 8700-UPDATE-MST-ACCT      THRU 8700-EXIT
                        PERFORM 7200-CHK-LANDLORD-EXISTS  THRU 7200-EXIT
                                                                        
                        IF LANDLORD-EXISTS                              
                           PERFORM 8450-UPD-LANDLORD-ACCT THRU 8450-EXIT
                        END-IF                                          
                      END-IF                                            
                                                                        
                    WHEN WS-INSERT                                      
                     IF WS-FINAL-BILL EQUAL WS-NO                       
                      MOVE WS-S                  TO WS-CREDIT-GROUP     
                      MOVE WS-MST-ACCT-NO        TO AT-ACCOUNT-NO       
                      PERFORM 7000-SELECT-ACCOUNT         THRU 7000-EXIT
                      MOVE AT-CODE-PRNT-BLL-MST  TO WS-CODE-PRNT-BLL-MST
                      MOVE WS-BYPASSED           TO WS-SUB-ACCT-BLLED-OK
                                                                        
                      PERFORM 8200-INSERT-SUBACCT         THRU 8200-EXIT
                      PERFORM 8500-UPDATE-SUBACCT         THRU 8500-EXIT
                                                                        
      * SET CREDIT GROUP TO MASTER,IF MASTER ACCOUNT IS NON-UTILITY.            
                      PERFORM 7600-GET-SUBACCT-CNT        THRU 7600-EXIT
                      IF WS-COUNT-SUB-ACCT EQUAL WS-ONE                 
                        MOVE WS-MST-ACCT-NO      TO AT-ACCOUNT-NO       
                        PERFORM 7000-SELECT-ACCOUNT       THRU 7000-EXIT
                        MOVE AT-CODES-DATA-PRESENT TO                   
                                                 WS-CODES-DATA-PRESENT  
      * WHEN THE FIRST SUB A/C IS ADDED, SET THE CREDIT GRP TO MASTER.          
      * ALSO, SET THE MST_SUB_ACCT_IND TO 'M' FOR MASTER A/C.                   
                        MOVE WS-M                TO WS-CREDIT-GROUP     
                        MOVE WS-MASTER           TO WS-MST-SUB-ACCT-IND 
                        MOVE WS-ACTIVE           TO WS-ACCT-STATUS      
                        MOVE WS-B                TO WS-ACCOUNT-TYPE-CODE
                        PERFORM 8700-UPDATE-MST-ACCT      THRU 8700-EXIT
                      END-IF                                            
                     ELSE                                               
                        PERFORM 2700-INSERT-ERR-MESSAGE   THRU 2700-EXIT
                     END-IF                                             
                                                                        
                    WHEN WS-UPDATE                                      
                      PERFORM 8400-UPDATE-MSTSUB   THRU 8400-EXIT       
                END-EVALUATE                                            
             ELSE                                                       
                PERFORM 2700-INSERT-ERR-MESSAGE    THRU 2700-EXIT       
             END-IF                                                     
           ELSE                                                         
              PERFORM 2700-INSERT-ERR-MESSAGE      THRU 2700-EXIT       
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 2700-INSERT-ERR-MESSAGE.                                    *           
      ***************************************************************           
       2700-INSERT-ERR-MESSAGE.                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
           MOVE 5000                         TO S-APPL-RETURN-CODE      
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT          
           INITIALIZE S-APPL-RETURN-CODE.                               
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5000-PROCESS-TRAN-COMM                                      *           
      ***************************************************************           
       5000-PROCESS-TRAN-COMM.                                          
                                                                        
           MOVE WS-SUB-ACCT-NO                 TO MH-ACCOUNT-NO.        
           PERFORM 5100-MOVE-TRAN-SUMM            THRU 5100-EXIT.       
                                                                        
           EVALUATE PARM-SUB-ACTION-IND                                 
             WHEN WS-INSERT                                             
               MOVE WS-SUB                     TO WS-MST-SUB-ACCT-IND   
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
             WHEN WS-UPDATE                                             
               PERFORM 7300-SELECT-MSTSUB         THRU 7300-EXIT        
      *        PREVIOUS SUB_ACCT_BLLD_OK DESCRIPTION                            
               MOVE +16                        TO UV-COLUMN-NA-LEN      
               MOVE 'SUB_ACCT_BLLD_OK'         TO UV-COLUMN-NA-TEXT     
               MOVE +1                         TO UV-CODE-VALUE-LEN     
               MOVE MU-SUB-ACCT-BLLD-OK        TO UV-CODE-VALUE-TEXT    
               PERFORM 7500-GET-CODE-VALUE        THRU 7500-EXIT        
               MOVE UV-CODE-SHORT-DESC-LEN     TO WS-PREV-SHORT-DESC-LEN
               MOVE UV-CODE-SHORT-DESC-TEXT    TO WS-PREV-SHORT-DESC    
      *        NEW SUB_ACCT_BLLD_OK DESCRIPTION                                 
               MOVE +1                         TO UV-CODE-VALUE-LEN     
               MOVE WS-SUB-ACCT-BLLED-OK       TO UV-CODE-VALUE-TEXT    
               PERFORM 7500-GET-CODE-VALUE        THRU 7500-EXIT        
               MOVE UV-CODE-SHORT-DESC-LEN     TO WS-CURR-SHORT-DESC-LEN
               MOVE UV-CODE-SHORT-DESC-TEXT    TO WS-CURR-SHORT-DESC    
                                                                        
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
             WHEN WS-DELETE                                             
               PERFORM 7300-SELECT-MSTSUB         THRU 7300-EXIT        
               PERFORM 5400-MOVE-DEL-TRAN-DET     THRU 5400-EXIT        
               MOVE WS-SPACE                   TO WS-MST-SUB-ACCT-IND   
               PERFORM 5300-MOVE-UPD-TRAN-DET     THRU 5300-EXIT        
           END-EVALUATE.                                                
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5050-WRITE-TRANS-HIST.                                         *        
      ******************************************************************        
       5050-WRITE-TRANS-HIST.                                           
                                                                        
           IF WS-MAKE-MASTER-FLG EQUAL WS-YES                           
      *       WRITE A TRANSACTION HISTORY FOR MASTER ACCTS THAT                 
      *       GOT UPDATED IN 8000-UPD-MST-ACCT.                                 
              MOVE WS-MST-ACCT-NO              TO MH-ACCOUNT-NO         
              PERFORM 5100-MOVE-TRAN-SUMM         THRU 5100-EXIT        
              PERFORM 5200-MOVE-TRAN-DET-MST      THRU 5200-EXIT        
           ELSE                                                         
      *       WRITE A TRANSACTION HISTORY FOR MASTER ACCTS THAT                 
      *       GOT UPDATED IN 8010-UPD-CODE-PRNT-BLL-MST.                        
              MOVE WS-MST-ACCT-NO              TO MH-ACCOUNT-NO         
              PERFORM 5100-MOVE-TRAN-SUMM         THRU 5100-EXIT        
              PERFORM 5240-MOVE-TRAN-DET-MST      THRU 5240-EXIT        
      *       WRITE A TRANSACTION HISTORY FOR ALL THE SUB ACCTS                 
      *       THAT GOT UPDATED IN 8050-UPD-CODE-PRNT-BLL-SUB.                   
              PERFORM 7810-OPEN-SUB-ACCT-CURSOR   THRU 7810-EXIT        
              PERFORM 7820-FETCH-SUB-ACCT-CURSOR  THRU 7820-EXIT        
              PERFORM 5250-MOVE-TRAN-DET-SUB      THRU 5250-EXIT        
                                                  UNTIL NO-MORE-ROWS    
              PERFORM 7830-CLOSE-SUB-ACCT-CURSOR  THRU 7830-EXIT        
           END-IF.                                                      
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   5100-MOVE-TRAN-SUMM.                                         *        
      ******************************************************************        
       5100-MOVE-TRAN-SUMM.                                             
                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE WS-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE 0                        TO MH-CUSTOMER-NO.             
           MOVE 0                        TO MH-PREMISE-NO.              
           MOVE WS-USER-ID               TO MH-USER-ID.                 
           MOVE 'CSR04593'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-TRAN-COMMENT          TO MH-TRAN-COMMENT-TEXT.       
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                         TO MH-TRAN-COMMENT-LEN.        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5200-MOVE-TRAN-DET-MST.                                        *        
      ******************************************************************        
       5200-MOVE-TRAN-DET-MST.                                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-ACCOUNT-TYPE-CD-OLD NOT EQUAL WS-MASTER-ACCT           
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-MASTER-ACCT           TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ACCOUNT TYPE'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           IF WS-MST-SUB-ACCT-IND-OLD NOT EQUAL WS-MASTER               
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-MASTER                TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'MST SUB ACCT IND'       TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5240-MOVE-TRAN-DET-MST.                                        *        
      ******************************************************************        
       5240-MOVE-TRAN-DET-MST.                                          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-CODE-PRNT-BLL-MST-OLD NOT EQUAL WS-CODE-PRNT-BLL-MST   
              MOVE '41'                     TO MI-TABLE-ID              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
                                                                        
              IF WS-CODE-PRNT-BLL-MST GREATER THAN SPACES               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-CODE-PRNT-BLL-MST   TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-CODE-PRNT-BLL-MST-OLD  GREATER THAN SPACES          
                 MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CODE-PRNT-BLL-MST-OLD                          
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'PRINT OPTION   '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
           END-IF.                                                      
                                                                        
       5240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5250-MOVE-TRAN-DET-SUB.                                        *        
      ******************************************************************        
       5250-MOVE-TRAN-DET-SUB.                                          
                                                                        
           PERFORM 7005-GET-CURR-DATE       THRU 7005-EXIT.             
                                                                        
           MOVE 1                        TO WS-TRAN-APPL-NO             
                                            MI-TRAN-APPL-NO.            
           MOVE MU-SUB-ACCT-NO           TO MH-ACCOUNT-NO.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE WS-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE 0                        TO MH-CUSTOMER-NO.             
           MOVE 0                        TO MH-PREMISE-NO.              
           MOVE WS-USER-ID               TO MH-USER-ID.                 
           MOVE 'CSR04593'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-TRAN-COMMENT          TO MH-TRAN-COMMENT-TEXT.       
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                         TO MH-TRAN-COMMENT-LEN.        
                                                                        
      *    TRANSACTION HISTORY DETAIL ROW                                       
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-CODE-PRNT-BLL-MST-OLD NOT EQUAL WS-CODE-PRNT-BLL-MST   
              MOVE '41'                     TO MI-TABLE-ID              
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
                                                                        
              IF WS-CODE-PRNT-BLL-MST GREATER THAN SPACES               
                 MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-CODE-PRNT-BLL-MST   TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              IF WS-CODE-PRNT-BLL-MST-OLD  GREATER THAN SPACES          
                 MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-CODE-PRNT-BLL-MST-OLD                          
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
                                                                        
              MOVE 'PRINT OPTION   '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                         TO WS-TRAN-APPL-NO          
              MOVE SPACES                   TO MI-TABLE-ID              
           END-IF.                                                      
                                                                        
           PERFORM 7820-FETCH-SUB-ACCT-CURSOR  THRU 7820-EXIT.          
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5300-MOVE-UPD-TRAN-DET.                                     *           
      ***************************************************************           
       5300-MOVE-UPD-TRAN-DET.                                          
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             IF (WS-CODE-SUB-TOTAL NOT EQUAL MU-CODE-SUB-TOTAL) AND     
                (PARM-SUB-ACTION-IND EQUAL WS-UPDATE)                   
                 MOVE +18                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE MU-CODE-SUB-TOTAL     TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE WS-CODE-SUB-TOTAL     TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE 'CODE-SUB-TOTAL '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO WS-TRAN-APPL-NO          
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             IF (WS-SUB-ACCT-BLLED-OK NOT EQUAL MU-SUB-ACCT-BLLD-OK) AND
                (PARM-SUB-ACTION-IND EQUAL WS-UPDATE)                   
                 MOVE +15                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-PREV-SHORT-DESC     TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE WS-CURR-SHORT-DESC     TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE 'CODE-BILLED-OK'      TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO WS-TRAN-APPL-NO          
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             IF WS-MST-ACCT-NO        NOT EQUAL AT-ACCT-XFER-TO         
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-MST-ACCT-NO        TO MI-CHG-COLUMN-VALUE-TEXT 
                 IF AT-ACCT-XFER-TO EQUAL ZEROS                         
                    MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT            
                 ELSE                                                   
                    MOVE AT-ACCT-XFER-TO    TO MI-PRV-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                 MOVE 'ACCT XFER TO   '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO WS-TRAN-APPL-NO          
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             IF WS-CREDIT-GROUP NOT EQUAL AT-CREDIT-GROUP               
                 MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                 MOVE WS-CREDIT-GROUP       TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE AT-CREDIT-GROUP       TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE 'CREDIT GROUP   '     TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                      TO WS-TRAN-APPL-NO          
             END-IF.                                                    
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5400-MOVE-DEL-TRAN-DET                                      *           
      *                                                             *           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5400-MOVE-DEL-TRAN-DET.                                          
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +2                        TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE MU-CODE-SUB-TOTAL         TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'CODE SUB TOTAL '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.          
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +13                       TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE WS-MST-ACCT-NO            TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'MST ACCT NO    '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.          
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE WS-SPACE                  TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'SUB ACT BLLD OK'         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.          
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +13                       TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE WS-SUB-ACCT-NO            TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE 'SUB ACCT NO    '         TO MI-COLUMN-DESC.          
             PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.          
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT                                 
                    ,ACCT_XFER_TO                                       
                    ,AR_XFER_IND                                        
                    ,BILL_HIST_XFER_IND                                 
                    ,MST_SUB_ACCT_IND                                   
                    ,CREDIT_GROUP                                       
                    ,CODE_ACCT_STAT                                     
                    ,BANKRUPTCY_IND                                     
                    ,BILL_CYCLE                                         
                    ,REV_MTH_LST_NRML                                   
                    ,CODE_PRNT_BLL_MST                                  
                    ,DATE_BILL_DAY_00                                   
                    ,MEMO_BILL_IND                                      
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-ACCT-XFER-TO                                   
                    ,:AT-AR-XFER-IND                                    
                    ,:AT-BILL-HIST-XFER-IND                             
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-CODE-PRNT-BLL-MST                              
                    ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-1                 
                    ,:AT-MEMO-BILL-IND                                  
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODES_DATA_PRESENT                                         
MFA-TR*             ,ACCT_XFER_TO                                               
MFA-TR*             ,AR_XFER_IND                                                
MFA-TR*             ,BILL_HIST_XFER_IND                                         
MFA-TR*             ,MST_SUB_ACCT_IND                                           
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,BANKRUPTCY_IND                                             
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*             ,REV_MTH_LST_NRML                                           
MFA-TR*             ,CODE_PRNT_BLL_MST                                          
MFA-TR*             ,DATE_BILL_DAY_00                                           
MFA-TR*             ,MEMO_BILL_IND                                              
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-ACCT-XFER-TO                                           
MFA-TR*             ,:AT-AR-XFER-IND                                            
MFA-TR*             ,:AT-BILL-HIST-XFER-IND                                     
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CODE-PRNT-BLL-MST                                      
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-NULL-IND-1                         
MFA-TR*             ,:AT-MEMO-BILL-IND                                          
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7005-GET-CURR-DATE.                                           *         
      *****************************************************************         
        7005-GET-CURR-DATE.                                             
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE      = CURRENT DATE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7005'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
       7010-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT AT.MST_OVRRD_BLL_IND                                
                   ,AT.CODE_PRNT_BLL_MST                                
                   ,AT.AR_XFER_IND                                      
                   ,AT.BILL_HIST_XFER_IND                               
                   ,AT.ACCOUNT_TYPE_CODE                                
                   ,AT.MST_SUB_ACCT_IND                                 
               INTO :WS-MST-OVRRD-BLL-IND-OLD                           
                   ,:WS-CODE-PRNT-BLL-MST-OLD                           
                   ,:WS-AR-XFER-IND-OLD                                 
                   ,:WS-BILL-HIST-XFER-IND-OLD                          
                   ,:WS-ACCOUNT-TYPE-CD-OLD                             
                   ,:WS-MST-SUB-ACCT-IND-OLD                            
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO  = :WS-MST-ACCT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.MST_OVRRD_BLL_IND                                        
MFA-TR*            ,AT.CODE_PRNT_BLL_MST                                        
MFA-TR*            ,AT.AR_XFER_IND                                              
MFA-TR*            ,AT.BILL_HIST_XFER_IND                                       
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*            ,AT.MST_SUB_ACCT_IND                                         
MFA-TR*        INTO :WS-MST-OVRRD-BLL-IND-OLD                                   
MFA-TR*            ,:WS-CODE-PRNT-BLL-MST-OLD                                   
MFA-TR*            ,:WS-AR-XFER-IND-OLD                                         
MFA-TR*            ,:WS-BILL-HIST-XFER-IND-OLD                                  
MFA-TR*            ,:WS-ACCOUNT-TYPE-CD-OLD                                     
MFA-TR*            ,:WS-MST-SUB-ACCT-IND-OLD                                    
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO  = :WS-MST-ACCT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7010                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-SELECT-MASTER                                             *        
      ******************************************************************        
       7100-SELECT-MASTER.                                              
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-ALRDY-MST-ACCT                                 
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO       = :WS-SUB-ACCT-NO              
                 AND AT.MST_SUB_ACCT_IND = :WS-MASTER                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ALRDY-MST-ACCT                                         
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO       = :WS-SUB-ACCT-NO                      
MFA-TR*          AND AT.MST_SUB_ACCT_IND = :WS-MASTER                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'MST_SUB_ACCT_IND'         TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-MASTER                  TO HOSTVAR-ELEMENT-1      
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7150-SELECT-RESP-AREA                                         *         
      *****************************************************************         
       7150-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :WS-USER-ID                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :WS-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :WS-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      * 7200-CHK-LANDLORD-EXISTS.                                *              
      ************************************************************              
       7200-CHK-LANDLORD-EXISTS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-LANDLORD-EXISTS                                
                FROM CSS_LANDLORD SI WITH(READUNCOMMITTED)                      
               WHERE SI.LL_MASTER_ACCT_NO = :WS-LL-MST-ACCT-NUM         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-LANDLORD-EXISTS                                        
MFA-TR*         FROM CSS_LANDLORD SI                                            
MFA-TR*        WHERE SI.LL_MASTER_ACCT_NO = :WS-LL-MST-ACCT-NUM                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_LANDLORD'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-LL-MST-ACCT-NUM         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-SELECT-MSTSUB                                             *        
      ******************************************************************        
       7300-SELECT-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              SELECT MU.CODE_SUB_TOTAL,                                 
                     MU.SUB_ACCT_BLLD_OK                                
                INTO :MU-CODE-SUB-TOTAL                                 
                    ,:MU-SUB-ACCT-BLLD-OK                               
                FROM CSS_MSTSUB_ACCT MU WITH(READUNCOMMITTED)                   
               WHERE MU.MST_ACCT_NO = :WS-MST-ACCT-NO                   
                 AND MU.SUB_ACCT_NO = :WS-SUB-ACCT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MU.CODE_SUB_TOTAL,                                         
MFA-TR*              MU.SUB_ACCT_BLLD_OK                                        
MFA-TR*         INTO :MU-CODE-SUB-TOTAL                                         
MFA-TR*             ,:MU-SUB-ACCT-BLLD-OK                                       
MFA-TR*         FROM CSS_MSTSUB_ACCT MU                                         
MFA-TR*        WHERE MU.MST_ACCT_NO = :WS-MST-ACCT-NO                           
MFA-TR*          AND MU.SUB_ACCT_NO = :WS-SUB-ACCT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
              MOVE 'SUB_ACCT_NO'              TO TABLE-ELEMENT-2        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7425-SELECT-SUB-RECVBLS                                        *        
      ******************************************************************        
       7425-SELECT-SUB-RECVBLS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RECVBLS-EXISTS                                 
                FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                       
               WHERE AC.ACCOUNT_NO       = :WS-SUB-ACCT-NO              
                 AND AC.ITEM_ID          = :WS-ZERO                     
                 AND (AC.AMT_AR_DAY_00   > :WS-ZERO                     
                  OR AC.AMT_AR_DAY_30    > :WS-ZERO                     
                  OR AC.AMT_AR_DAY_60    > :WS-ZERO                     
                  OR AC.AMT_AR_DAY_90    > :WS-ZERO                     
                  OR AC.AMT_TRAN_BALANCE > :WS-ZERO )                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-RECVBLS-EXISTS                                         
MFA-TR*         FROM CSS_AR_CNTL AC                                             
MFA-TR*        WHERE AC.ACCOUNT_NO       = :WS-SUB-ACCT-NO                      
MFA-TR*          AND AC.ITEM_ID          = :WS-ZERO                             
MFA-TR*          AND (AC.AMT_AR_DAY_00   > :WS-ZERO                             
MFA-TR*           OR AC.AMT_AR_DAY_30    > :WS-ZERO                             
MFA-TR*           OR AC.AMT_AR_DAY_60    > :WS-ZERO                             
MFA-TR*           OR AC.AMT_AR_DAY_90    > :WS-ZERO                             
MFA-TR*           OR AC.AMT_TRAN_BALANCE > :WS-ZERO )                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7425                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7425'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7426-SELECT-SUB-DEPOSITS                                       *        
      ******************************************************************        
       7426-SELECT-SUB-DEPOSITS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DEPOSITS-EXISTS                                
                FROM CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                   
               WHERE DO.ACCOUNT_NO         = :WS-SUB-ACCT-NO            
                 AND DO.DEPOSIT_STATUS_CD IN ('A','P')                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-DEPOSITS-EXISTS                                        
MFA-TR*         FROM CSS_DEP_ON_HAND DO                                         
MFA-TR*        WHERE DO.ACCOUNT_NO         = :WS-SUB-ACCT-NO                    
MFA-TR*          AND DO.DEPOSIT_STATUS_CD IN ('A','P')                          
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7426                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7426'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DEP_ON_HAND'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7426-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7430-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7430-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7430                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                    TO ABEND-TABLES           
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
               MOVE '7430'                    TO ACTIVE-PARAGRAPH       
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_BUS_RULE'            TO TABLE-1                
               MOVE 'BUS_RULE_ID'             TO TABLE-ELEMENT-1        
               MOVE S-BUS-RULE-ID             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7450-SELECT-EPAY-ACCOUNT                                       *        
      ******************************************************************        
       7450-SELECT-EPAY-ACCOUNT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-ACCT-ON-EPAY-IND                               
                FROM CSS_BANK_EFT BE WITH(READUNCOMMITTED)                      
               WHERE BE.ACCOUNT_NO   = :BE-ACCOUNT-NO                   
                 AND BE.STATUS_CODE IN (:WS-M1,:WS-N1)                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ACCT-ON-EPAY-IND                                       
MFA-TR*         FROM CSS_BANK_EFT BE                                            
MFA-TR*        WHERE BE.ACCOUNT_NO   = :BE-ACCOUNT-NO                           
MFA-TR*          AND BE.STATUS_CODE IN (:WS-M1,:WS-N1)                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BANK_EFT'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-GET-CODE-VALUE.                                           *        
      ******************************************************************        
       7500-GET-CODE-VALUE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT UV.CODE_SHORT_DESC                                 
                INTO :UV-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                    
               WHERE UV.COLUMN_NA   = :UV-COLUMN-NA                     
                 AND UV.TABLE_NA    = 'CSS_MSTSUB_ACCT'                 
                 AND UV.CODE_VALUE  = :UV-CODE-VALUE                    
                 AND UV.PROGRAM_ID  = 'ALL'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_SHORT_DESC                                         
MFA-TR*         INTO :UV-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE UV                                          
MFA-TR*        WHERE UV.COLUMN_NA   = :UV-COLUMN-NA                             
MFA-TR*          AND UV.TABLE_NA    = 'CSS_MSTSUB_ACCT'                         
MFA-TR*          AND UV.CODE_VALUE  = :UV-CODE-VALUE                            
MFA-TR*          AND UV.PROGRAM_ID  = 'ALL'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CODE_VALUE'           TO TABLE-1                
              MOVE 'CODE_VALUE'               TO TABLE-ELEMENT-1        
              MOVE 'COLUMN_NA'                TO TABLE-ELEMENT-2        
              MOVE UV-CODE-VALUE              TO HOSTVAR-ELEMENT-1      
              MOVE UV-COLUMN-NA               TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7600-GET-SUBACCT-CNT                                           *        
      ******************************************************************        
       7600-GET-SUBACCT-CNT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT-SUB-ACCT                                 
                FROM CSS_MSTSUB_ACCT MU                                 
               WHERE MU.MST_ACCT_NO = :WS-MST-ACCT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7700-CHK-CONTRACT.                                             *        
      ******************************************************************        
       7700-CHK-CONTRACT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT-CONTRACT                                 
                FROM CSS_CONTRACT CT                                    
                    ,CSS_AR_CNTL  AC                                    
               WHERE CT.ACCOUNT_NO        = AC.ACCOUNT_NO               
                 AND CT.ACCOUNT_NO        = :WS-MST-ACCT-NO             
                 AND AC.PYMT_PRIORITY_LVL = 100                         
                 AND AC.ITEM_ID           = CT.CNT_ITEM_ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'CSS_AR_CNTL AC'           TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7800-CHK-CONTRACT.                                             *        
      ******************************************************************        
       7800-GET-CONTRACT-CNT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT-CONTRACT                                 
                FROM CSS_CONTRACT CT                                    
               WHERE CT.ACCOUNT_NO        = :WS-MST-ACCT-NO             
                 AND CT.CODE_BILL_TYPE    = :WS-E                       
                 AND (CT.CNT_STATUS_CD    = :WS-B                       
                      OR CT.CNT_STATUS_CD = :WS-A)                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CONTRACT'             TO TABLE-1                
              MOVE 'CSS_AR_CNTL AC'           TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7810-OPEN-SUB-ACCT-CURSOR                                      *        
      ******************************************************************        
       7810-OPEN-SUB-ACCT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN SUB_ACCT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7810'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_MSTSUB_ACCT'        TO TABLE-1                  
              MOVE 'MST_ACCT_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-MST-ACCT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7820-FETCH-SUB-ACCT-CURSOR.                                    *        
      ******************************************************************        
       7820-FETCH-SUB-ACCT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  SUB_ACCT_CURSOR                                    
               INTO :MU-SUB-ACCT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7820'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_MSTSUB_ACCT'  TO TABLE-1                  
                    MOVE 'MST_ACCOUNT_NO'   TO TABLE-ELEMENT-1          
                    MOVE WS-MST-ACCT-NO     TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7830-CLOSE-SUB-ACCT-CURSOR                                     *        
      ******************************************************************        
       7830-CLOSE-SUB-ACCT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE SUB_ACCT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04593_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04593_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04593_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000-UPD-MST-ACCT                                             *         
      *****************************************************************         
       8000-UPD-MST-ACCT.                                               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET NXT_BILL_NO         = :WS-ONE                      
                    ,CODE_PRNT_BLL_MST   = :WS-MST-ACCT-ONLY            
                    ,ACCOUNT_TYPE_CODE   = :WS-MASTER-ACCT              
                    ,MST_SUB_ACCT_IND    = :WS-MASTER                   
               WHERE ACCOUNT_NO          = :WS-MST-ACCT-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT  '            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8010-UPD-CODE-PRNT-BLL-MST.                                   *         
      *****************************************************************         
       8010-UPD-CODE-PRNT-BLL-MST.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_PRNT_BLL_MST   = :AT-CODE-PRNT-BLL-MST        
               WHERE ACCOUNT_NO          = :WS-MST-ACCT-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT  '            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_PRNT_BLL_MST'        TO TABLE-ELEMENT-3        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE AT-CODE-PRNT-BLL-MST       TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8050-UPD-CODE-PRNT-BLL-SUB.                                   *         
      *****************************************************************         
       8050-UPD-CODE-PRNT-BLL-SUB.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.CODE_PRNT_BLL_MST = :AT-CODE-PRNT-BLL-MST       
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO IN                                   
                             (SELECT MU.SUB_ACCT_NO FROM                
                                     CSS_MSTSUB_ACCT MU                 
                               WHERE MU.MST_ACCT_NO = :WS-MST-ACCT-NO)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.CODE_PRNT_BLL_MST = :AT-CODE-PRNT-BLL-MST               
MFA-TR*        WHERE AT.ACCOUNT_NO IN                                           
MFA-TR*                      (SELECT MU.SUB_ACCT_NO FROM                        
MFA-TR*                              CSS_MSTSUB_ACCT MU                         
MFA-TR*                        WHERE MU.MST_ACCT_NO = :WS-MST-ACCT-NO)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT  '            TO TABLE-1                
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-2                
              MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
              MOVE 'CODE_PRNT_BLL_MST'        TO TABLE-ELEMENT-2        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE AT-CODE-PRNT-BLL-MST    TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04593_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,BUS_RULE_ID                                         
                   ,BUS_RULE_RESULT_CD                                  
                   ,BUS_RULE_XREF_ID                                    
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-BUS-RULE-ID                                      
                   ,:S-BUS-RULE-RESULT-CD                               
                   ,:S-BUS-RULE-XREF-ID                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04593_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,BUS_RULE_ID                                                 
MFA-TR*            ,BUS_RULE_RESULT_CD                                          
MFA-TR*            ,BUS_RULE_XREF_ID                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-BUS-RULE-ID                                              
MFA-TR*            ,:S-BUS-RULE-RESULT-CD                                       
MFA-TR*            ,:S-BUS-RULE-XREF-ID                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                          TO CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04593_R1'              TO TABLE-1                
              MOVE SPACES                     TO TABLE-ELEMENT-1        
              MOVE SPACES                     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-SUBACCT                                            *        
      *    INSERT ROW FOR NEW SUB ACCOUNT NO                           *        
      ******************************************************************        
       8200-INSERT-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MSTSUB_ACCT                               
                    (CODE_SUB_TOTAL                                     
                    ,MST_ACCT_NO                                        
                    ,SUB_ACCT_BLLD_OK                                   
                    ,SUB_ACCT_NO)                                       
              VALUES                                                    
                    (:WS-CODE-SUB-TOTAL                                 
                    ,:WS-MST-ACCT-NO                                    
                    ,:WS-SUB-ACCT-BLLED-OK                              
                    ,:WS-SUB-ACCT-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
              MOVE 'SUB_ACCT_NO'              TO TABLE-ELEMENT-2        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              MOVE WS-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8300-DELETE-SUBACCT                                            *        
      ******************************************************************        
       8300-DELETE-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM MU                             
              FROM CSS_MSTSUB_ACCT MU
               WHERE MU.MST_ACCT_NO    = :WS-MST-ACCT-NO                
                 AND MU.SUB_ACCT_NO    = :WS-SUB-ACCT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_MSTSUB_ACCT MU                                    
MFA-TR*        WHERE MU.MST_ACCT_NO    = :WS-MST-ACCT-NO                        
MFA-TR*          AND MU.SUB_ACCT_NO    = :WS-SUB-ACCT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8300'                    TO ACTIVE-PARAGRAPH       
               MOVE 'DELETE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_MSTSUB_ACCT'         TO TABLE-1                
               MOVE 'MST_ACCT_NO'             TO TABLE-ELEMENT-1        
               MOVE 'SUB_ACCT_NO'             TO TABLE-ELEMENT-2        
               MOVE WS-MST-ACCT-NO            TO HOSTVAR-ELEMENT-1      
               MOVE WS-SUB-ACCT-NO            TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04527******************************************************************        
A04527*                                                                *        
A04527* 8350-DEL-HELD-BP-SUBS                                          *        
A04527******************************************************************        
A04527 8350-DEL-HELD-BP-SUBS.                                           
A04527                                                                  
A04527     EXEC SQL                                                     
A04527        DELETE FROM HB                            
              FROM CSS_HELD_BP_SUBS HB
A04527         WHERE HB.ACCOUNT_NO    = :WS-SUB-ACCT-NO                 
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_HELD_BP_SUBS HB                                   
MFA-TR*        WHERE HB.ACCOUNT_NO    = :WS-SUB-ACCT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04527         CONTINUE                                                 
A04527     ELSE                                                         
A04527         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
A04527         MOVE '8350'                    TO ACTIVE-PARAGRAPH       
A04527         MOVE 'DELETE'                  TO ABEND-FUNCTION         
A04527         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
A04527                                           ABEND-TABLES           
A04527         MOVE 'CSS_HELD_BP_SUBS'        TO TABLE-1                
A04527         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
A04527         MOVE WS-SUB-ACCT-NO            TO HOSTVAR-ELEMENT-1      
A04527         PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
A04527         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
A04527     END-IF.                                                      
A04527                                                                  
A04527 8350-EXIT.                                                       
A04527     EXIT.                                                        
A04527                                                                  
      ******************************************************************        
      *                                                                *        
      * 8400-UPDATE-MSTSUB                                             *        
      ******************************************************************        
       8400-UPDATE-MSTSUB.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MSTSUB_ACCT                                    
                 SET CODE_SUB_TOTAL    = :WS-CODE-SUB-TOTAL             
                    ,SUB_ACCT_BLLD_OK  = :WS-SUB-ACCT-BLLED-OK          
               WHERE MST_ACCT_NO       = :WS-MST-ACCT-NO                
                 AND SUB_ACCT_NO       = :WS-SUB-ACCT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8400'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_MSTSUB_ACCT'         TO TABLE-1                
               MOVE 'MST_ACCT_NO'             TO TABLE-ELEMENT-1        
               MOVE 'SUB_ACCT_NO'             TO TABLE-ELEMENT-2        
               MOVE WS-MST-ACCT-NO            TO HOSTVAR-ELEMENT-1      
               MOVE WS-SUB-ACCT-NO            TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *                                                          *              
      * 8450-UPD-LANDLORD-ACCT.                                 *               
      ************************************************************              
       8450-UPD-LANDLORD-ACCT.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET LL_MASTER_ACCT_NO  = :WS-ZERO                     
                WHERE LL_MASTER_ACCT_NO  = :WS-LL-MST-ACCT-NUM          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE '8450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_LANDLORD'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-LL-MST-ACCT-NUM         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8500-UPDATE-SUBACCT                                            *        
      ******************************************************************        
       8500-UPDATE-SUBACCT.                                             
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND           
                   ,ACCT_XFER_TO       = :WS-MST-ACCT-NO                
                   ,AR_XFER_IND        = :WS-YES                        
                   ,BILL_HIST_XFER_IND = :WS-YES                        
                   ,CREDIT_GROUP       = :WS-CREDIT-GROUP               
                   ,CODE_PRNT_BLL_MST  = :WS-CODE-PRNT-BLL-MST          
                   ,MEMO_BILL_IND      = :WS-SPACE                      
              WHERE ACCOUNT_NO         = :WS-SUB-ACCT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8500'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-SUB-ACCT-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8600-UPDATE-ACCT-AFTER-DEL                                     *        
      ******************************************************************        
       8600-UPDATE-ACCT-AFTER-DEL.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND       
                    ,AT.CREDIT_GROUP       = :WS-CREDIT-GROUP           
                    ,AT.AR_XFER_IND        = :WS-SPACE                  
                    ,AT.BILL_HIST_XFER_IND = :WS-SPACE                  
                    ,AT.ACCT_XFER_TO       = :WS-ZERO                   
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO         = :WS-SUB-ACCT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND               
MFA-TR*             ,AT.CREDIT_GROUP       = :WS-CREDIT-GROUP                   
MFA-TR*             ,AT.AR_XFER_IND        = :WS-SPACE                          
MFA-TR*             ,AT.BILL_HIST_XFER_IND = :WS-SPACE                          
MFA-TR*             ,AT.ACCT_XFER_TO       = :WS-ZERO                           
MFA-TR*        WHERE AT.ACCOUNT_NO         = :WS-SUB-ACCT-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8600'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-SUB-ACCT-NO            TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8650-UPD-HELD-BP-SUBS.                                         *        
      ******************************************************************        
       8650-UPD-HELD-BP-SUBS.                                           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_HELD_BP_SUBS                                    
                SET PULL_FL           = :WS-D                           
              WHERE ACCOUNT_NO        = :WS-SUB-ACCT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                 MOVE '8650'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'UPDATE'                TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_HELD_BP_SUBS'      TO TABLE-1                
                 MOVE 'ACCOUNT-NO'            TO TABLE-ELEMENT-1        
                 MOVE WS-SUB-ACCT-NO          TO HOSTVAR-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8700-UPDATE-MST-ACCTT                                          *        
      ******************************************************************        
       8700-UPDATE-MST-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE AT                                      
                 SET AT.CODE_ACCT_STAT     = :WS-ACCT-STATUS            
                    ,AT.AR_XFER_IND        = :WS-SPACE                  
                    ,AT.BILL_HIST_XFER_IND = :WS-SPACE                  
                    ,AT.CREDIT_GROUP       = :WS-CREDIT-GROUP           
                    ,AT.ACCOUNT_TYPE_CODE  = :WS-ACCOUNT-TYPE-CODE      
                    ,AT.MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND       
              FROM CSS_ACCOUNT AT
               WHERE AT.ACCOUNT_NO         = :WS-MST-ACCT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT AT                                             
MFA-TR*          SET AT.CODE_ACCT_STAT     = :WS-ACCT-STATUS                    
MFA-TR*             ,AT.AR_XFER_IND        = :WS-SPACE                          
MFA-TR*             ,AT.BILL_HIST_XFER_IND = :WS-SPACE                          
MFA-TR*             ,AT.CREDIT_GROUP       = :WS-CREDIT-GROUP                   
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE  = :WS-ACCOUNT-TYPE-CODE              
MFA-TR*             ,AT.MST_SUB_ACCT_IND   = :WS-MST-SUB-ACCT-IND               
MFA-TR*        WHERE AT.ACCOUNT_NO         = :WS-MST-ACCT-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
