       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04592.                                      
COB303 DATE-WRITTEN.     DECEMBER 07,2012.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ROWS FROM CSS_MSTSUB_ACCT USING        *        
      *  ACCOUNT_NO AS THE PRDICATE TO FIND OUT ALL THE SUBACCOUNTS    *        
      *  FOR A PARTICULAR MASTER ACCOUNT, AND BUSINESS NAME FROM       *        
      *  CSS_ACCT_BILL_NMES , AND BILL TYPE AND BILL CYCLE FROM        *        
      *  CSS_ACCOUNT WITH ACCOUNT_NO AS THE PREDICATE.                 *        
      *                                                                *        
      *  CLONED FROM CSR02278.                                         *        
      ******************************************************************        
      *  INPUT PARAMETERS:                                             *        
      *                                                                *        
      *          ACCOUNT_NO      CHAR(13)                              *        
      *                                                                *        
      *  RESUT SET 1:                                                  *        
      *                                                                *        
      *          RETURN_CODE          INTEGER                          *        
      *          APPL_RETURN_CODE     INTEGER                          *        
      *          BUS_RULE_ID          CHAR(10)                         *        
      *          BUS_RULE_RESULT_CD   CHAR(08)                         *        
      *          BUS_RULE_XREF_ID     CHAR(26)                         *        
      *                                                                *        
      *  RESUT SET 2:                                                  *        
      *                                                                *        
      *          RETURN_CODE          INTEGER                          *        
      *          APPL_RETURN_CODE     INTEGER                          *        
      *          MST_ACCT_NO          CHAR(13)                         *        
      *          CODE_PRNT_BLL_MST    CHAR(01)                         *        
      *          SUB_ACCT_NO          CHAR(13)                         *        
      *          ACCOUNT_NAME         CHAR(76)                         *        
      *          BILL_CYCLE           CHAR(02)                         *        
      *          BILL_STATUS          CHAR(01)                         *        
      *          SUB_TOTAL_CODE       CHAR(18)                         *        
      *          SUB_ACCT_STATUS      CHAR(01)                         *        
      *          CUSTOMER_NO          DECIMAL(10,0)                    *        
      *          PREMISE_NO           DECIMAL(10,0)                    *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00733*  12/07/12  MS93554    INITIAL PROGRAM VERSION.                 *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04592'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04592 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT        AT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_MSTSUB_ACCT    MU                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCT_BILL_NMES AB                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATBLNM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_NAME           DQ                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_DELINQUENCY    D8                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04592'.    
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN            PIC S9(04) COMP.               
               49 GTT-ROW-CHAR           PIC X(1024).                   
           05  GTT-SQLCODE               PIC S9(9) COMP.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(9) COMP VALUE 1.        
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
           05  WS-ZERO                   PIC S9(04) COMP VALUE 0.       
           05  WS-MASTER                 PIC X(01) VALUE 'M'.           
           05  WS-ACTIVE                 PIC X(01) VALUE 'A'.           
           05  WS-BANKRUPTCY             PIC X(01) VALUE 'B'.           
           05  WS-FINAL-BILLED           PIC X(01) VALUE 'B'.           
           05  WS-WRITE-OFF              PIC X(01) VALUE 'S'.           
           05  WS-FAILED                 PIC X(01) VALUE 'F'.           
           05  WS-INDIVIDUAL             PIC X(01) VALUE 'I'.           
                                                                        
       01  WS-BUS-RULE-ERROR.                                           
           05 WS-BUSRUL-MSTACCT-IS-FNALBIL PIC X(10) VALUE 'CB00000017'.
           05 WS-BUSRUL-MSTACCT-IS-WRTOFF  PIC X(10) VALUE 'CB00000018'.
           05 WS-BUSRUL-MSTACCT-IS-BNKRPTC PIC X(10) VALUE 'CB00000019'.
           05 WS-BUSRUL-CREATE-MST-ACCT    PIC X(10) VALUE 'CB00000020'.
           05 WS-BUSRUL-NOT-ELGBL-MSTR     PIC X(10) VALUE 'CB00000021'.
           05 WS-BUSRUL-NO-SUBACCT-EXIST   PIC X(10) VALUE 'CB00000022'.
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1         PIC S9(09) COMP VALUE 0.       
              10 S-APPL-RETURN-CODE-1    PIC S9(09) COMP VALUE 0.       
              10 S-RS1-BUS-RULE-ID       PIC X(10) VALUE SPACE.         
              10 S-RS1-BUS-RULE-RESULT-CD                               
                                         PIC X(08) VALUE SPACE.         
              10 S-RS1-BUS-RULE-XREF-ID  PIC X(26) VALUE SPACE.         
                                                                        
           05 GTT-RETURN-FIELDS-2.                                      
              10 S-RETURN-CODE-2         PIC S9(9) COMP VALUE 0.        
              10 S-APPL-RETURN-CODE-2    PIC S9(9) COMP VALUE 0.        
              10 S-RS2-MST-ACCT-NO       PIC S9(13)V USAGE COMP-3       
                                                   VALUE 0.             
              10 S-RS2-CODE-PRNT-BLL-MST PIC X(01) VALUE SPACES.        
              10 S-RS2-SUB-ACCT-NO       PIC S9(13)V USAGE COMP-3       
                                                   VALUE 0.             
              10 S-RS2-ACCOUNT-NAME      PIC X(76) VALUE SPACES.        
              10 S-RS2-BILL-CYCLE        PIC X(02) VALUE SPACES.        
              10 S-RS2-BILL-STATUS       PIC X(01) VALUE SPACES.        
              10 S-RS2-SUB-TOTAL-CODE    PIC X(18) VALUE SPACES.        
              10 S-RS2-SUB-ACCT-STATUS   PIC X(01) VALUE SPACES.        
              10 S-RS2-SUB-ACCT-CUST-NO  PIC S9(10)V USAGE COMP-3       
                                                   VALUE 0.             
              10 S-RS2-SUB-ACCT-PREM-NO  PIC S9(10)V USAGE COMP-3       
                                                   VALUE 0.             
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-MST-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-UTILITY-ACCT           PIC X(1)  VALUE 'N'.           
           05  WS-ELIGIBLE-FLAG          PIC X(1)  VALUE 'N'.           
           05  WS-APPL-RETURN-CODE       PIC S9(09) COMP VALUE 0.       
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
           05  WS-DELINQ-CD-VALUE        PIC X(20)                      
                                         VALUE'DAY-FINAL-BILLED-SUB'.   
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-NO-MORE-ROWS           PIC X(01) VALUE 'N'.           
               88 NO-MORE-ROWS                     VALUE 'Y'.           
           05  WS-WRITE-OFF-FL           PIC X(01) VALUE 'N'.           
               88 WRITE-OFF-FL                     VALUE 'Y'.           
           05  WS-FINAL-BLL-FL           PIC X(01) VALUE 'N'.           
               88 FINAL-BLL-FL                     VALUE 'Y'.           
           05  WS-BANKRUPTCY-FL          PIC X(01) VALUE 'N'.           
               88 BANKRUPTCY-FL                    VALUE 'Y'.           
           05  WS-MSTR-ACCT-FOUND        PIC X(01) VALUE 'N'.           
               88 MSTR-ACCT-FOUND                  VALUE 'Y'.           
           05  WS-UTILITY-ACCT-ROW       PIC X(01) VALUE 'N'.           
               88 UTILITY-FOUND                    VALUE 'Y'.           
           05  WS-ACCOUNT-STATUS         PIC X(01) VALUE 'N'.           
               88 SKIP-ACCOUNT                     VALUE 'Y'.           
               88 DONT-SKIP-ACCOUNT                VALUE 'N'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05 WS-NULL-IND-1              PIC S9(4) COMP VALUE ZEROS.    
           05 WS-WORK-DATE               PIC X(10) VALUE SPACES.        
           05 WS-PLUS60-DATE             PIC X(10) VALUE SPACES.        
           05 WS-CURRENT-DATE            PIC X(10) VALUE SPACES.        
           05 WS-DLNQ-DAYS               PIC S9(3) COMP-3 VALUE ZEROS.  
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
      ******************************************************************        
      *    CURSOR TO FETCH ALL THE SUB ACCOUNTS FOR THE MASTER ACCT    *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE SUB_ACCT_CURSOR CURSOR FOR                         
              SELECT MU.SUB_ACCT_NO                                     
                    ,MU.CODE_SUB_TOTAL                                  
                    ,MU.SUB_ACCT_BLLD_OK                                
                FROM CSS_MSTSUB_ACCT MU WITH(READUNCOMMITTED)                   
               WHERE MU.MST_ACCT_NO   = :WS-MST-ACCT-NO                 
               ORDER BY MU.SUB_ACCT_NO                                  
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SUB_ACCT_CURSOR CURSOR FOR                                 
MFA-TR*       SELECT MU.SUB_ACCT_NO                                             
MFA-TR*             ,MU.CODE_SUB_TOTAL                                          
MFA-TR*             ,MU.SUB_ACCT_BLLD_OK                                        
MFA-TR*         FROM CSS_MSTSUB_ACCT MU                                         
MFA-TR*        WHERE MU.MST_ACCT_NO   = :WS-MST-ACCT-NO                         
MFA-TR*        ORDER BY MU.SUB_ACCT_NO                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.              
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT.               
           PERFORM 0100B-DECLARE-GTT-R2  THRU 0100B-EXIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04592_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04592_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04592_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,BUS_RULE_ID                                      
                      ,BUS_RULE_RESULT_CD                               
                      ,BUS_RULE_XREF_ID                                 
                  FROM #CSR04592_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,BUS_RULE_ID                                              
MFA-TR*               ,BUS_RULE_RESULT_CD                                       
MFA-TR*               ,BUS_RULE_XREF_ID                                         
MFA-TR*           FROM SESSION.CSR04592_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2                                           *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04592_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04592_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04592_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,MST_ACCT_NO          DECIMAL(13,0)                  
                   ,CODE_PRNT_BLL_MST CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,SUB_ACCT_NO          DECIMAL(13,0)                  
                   ,ACCOUNT_NAME CHAR(76)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BILL_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,BILL_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,SUB_TOTAL_CODE CHAR(18)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,SUB_ACCT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CUSTOMER_NO          DECIMAL(10,0)                  
                   ,PREMISE_NO           DECIMAL(10,0)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,MST_ACCT_NO              AS MST_ACCT_NO          
                      ,LTRIM(RTRIM(CODE_PRNT_BLL_MST)) AS 
           CODE_PRNT_BLL_MST    
                      ,SUB_ACCT_NO              AS SUB_ACCT_NO          
                      ,LTRIM(RTRIM(ACCOUNT_NAME))      AS ACCOUNT_NAME         
                      ,LTRIM(RTRIM(BILL_CYCLE))        AS BILL_CYCLE           
                      ,LTRIM(RTRIM(BILL_STATUS))       AS BILL_STATUS          
                      ,LTRIM(RTRIM(SUB_TOTAL_CODE))    AS SUB_TOTAL_CODE       
                      ,LTRIM(RTRIM(SUB_ACCT_STATUS))   AS 
           SUB_ACCT_STATUS      
                      ,CUSTOMER_NO              AS SUB_ACCT_CUST_NO     
                      ,PREMISE_NO               AS SUB_ACCT_PREM_NO     
                  FROM #CSR04592_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,MST_ACCT_NO              AS MST_ACCT_NO                  
MFA-TR*               ,STRIP(CODE_PRNT_BLL_MST) AS CODE_PRNT_BLL_MST            
MFA-TR*               ,SUB_ACCT_NO              AS SUB_ACCT_NO                  
MFA-TR*               ,STRIP(ACCOUNT_NAME)      AS ACCOUNT_NAME                 
MFA-TR*               ,STRIP(BILL_CYCLE)        AS BILL_CYCLE                   
MFA-TR*               ,STRIP(BILL_STATUS)       AS BILL_STATUS                  
MFA-TR*               ,STRIP(SUB_TOTAL_CODE)    AS SUB_TOTAL_CODE               
MFA-TR*               ,STRIP(SUB_ACCT_STATUS)   AS SUB_ACCT_STATUS              
MFA-TR*               ,CUSTOMER_NO              AS SUB_ACCT_CUST_NO             
MFA-TR*               ,PREMISE_NO               AS SUB_ACCT_PREM_NO             
MFA-TR*           FROM SESSION.CSR04592_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO MU-MST-ACCT-NO           
                                               WS-MST-ACCT-NO.          
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *DETERMINE WHETHER THE INPUT ACCOUNT IS ELIGIBLE FOR MASTER.              
           PERFORM 7410-SELECT-ACCT-DETAILS    THRU 7410-EXIT.          
           IF AT-MST-SUB-ACCT-IND EQUAL WS-MASTER AND                   
              AT-CODE-ACCT-STAT   EQUAL WS-ACTIVE AND                   
              AT-BANKRUPTCY-IND   NOT EQUAL WS-BANKRUPTCY               
              MOVE WS-YES                   TO WS-ELIGIBLE-FLAG         
           ELSE                                                         
              PERFORM 7420-CHECK-UTILITY-ACCT  THRU 7420-EXIT           
              IF WS-UTILITY-ACCT  EQUAL WS-NO                           
                 IF AT-CODE-ACCT-STAT  EQUAL WS-FINAL-BILLED            
                    MOVE WS-BUSRUL-MSTACCT-IS-FNALBIL                   
                                            TO S-RS1-BUS-RULE-ID        
                    MOVE WS-FAILED          TO S-RS1-BUS-RULE-RESULT-CD 
                    IF S-RS1-BUS-RULE-ID GREATER THAN SPACES            
                       PERFORM 7430-GET-RULE-XREF-ID                    
                                               THRU 7430-EXIT           
                    END-IF                                              
                    PERFORM 8100-INSERT-GTT-R1 THRU 8100-EXIT           
                    MOVE WS-YES             TO WS-FINAL-BLL-FL          
                 END-IF                                                 
                 IF AT-CODE-ACCT-STAT  EQUAL WS-WRITE-OFF               
                    MOVE WS-BUSRUL-MSTACCT-IS-WRTOFF                    
                                            TO S-RS1-BUS-RULE-ID        
                    MOVE WS-FAILED          TO S-RS1-BUS-RULE-RESULT-CD 
                    IF S-RS1-BUS-RULE-ID GREATER THAN SPACES            
                       PERFORM 7430-GET-RULE-XREF-ID THRU 7430-EXIT     
                    END-IF                                              
                    PERFORM 8100-INSERT-GTT-R1 THRU 8100-EXIT           
                    MOVE WS-YES             TO WS-WRITE-OFF-FL          
                 END-IF                                                 
                 IF AT-BANKRUPTCY-IND  EQUAL WS-BANKRUPTCY              
                    MOVE WS-BUSRUL-MSTACCT-IS-BNKRPTC                   
                                            TO S-RS1-BUS-RULE-ID        
                    MOVE WS-FAILED          TO S-RS1-BUS-RULE-RESULT-CD 
                    IF S-RS1-BUS-RULE-ID GREATER THAN SPACES            
                       PERFORM 7430-GET-RULE-XREF-ID THRU 7430-EXIT     
                    END-IF                                              
                    PERFORM 8100-INSERT-GTT-R1 THRU 8100-EXIT           
                    MOVE WS-YES             TO WS-BANKRUPTCY-FL         
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-YES                TO WS-UTILITY-ACCT-ROW      
                 MOVE WS-NO                 TO WS-ELIGIBLE-FLAG         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ELIGIBLE-FLAG EQUAL WS-YES                             
             PERFORM 7300-CHECK-MSTSUB-ACCT    THRU 7300-EXIT           
             IF MSTR-ACCT-FOUND                                         
                PERFORM 2100-BUILD-RESULT      THRU 2100-EXIT           
             ELSE                                                       
      * IF THERE IS NO SUB ACCOUNT FOR THE INPUT MASTER ACCT, WE NEED           
      * TO DISPLAY BUS RULE ID IN RESULT SET1. MSTR ACCT AND PRINT TYPE         
      * DETAILS IN RESULT SET2.                                                 
                MOVE WS-BUSRUL-NO-SUBACCT-EXIST                         
                                            TO S-RS1-BUS-RULE-ID        
                MOVE WS-FAILED              TO S-RS1-BUS-RULE-RESULT-CD 
                IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                
                   PERFORM 7430-GET-RULE-XREF-ID THRU 7430-EXIT         
                END-IF                                                  
                PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT           
                                                                        
                MOVE WS-ZERO                TO S-RETURN-CODE-2          
                MOVE WS-ZERO                TO S-APPL-RETURN-CODE-2     
                MOVE MU-MST-ACCT-NO         TO S-RS2-MST-ACCT-NO        
                MOVE AT-CODE-PRNT-BLL-MST   TO S-RS2-CODE-PRNT-BLL-MST  
                PERFORM 8200-INSERT-GTT-R2     THRU 8200-EXIT           
             END-IF                                                     
           ELSE                                                         
             IF WRITE-OFF-FL OR FINAL-BLL-FL OR BANKRUPTCY-FL           
                                             OR UTILITY-FOUND           
                MOVE WS-BUSRUL-NOT-ELGBL-MSTR                           
                                            TO S-RS1-BUS-RULE-ID        
                MOVE WS-FAILED              TO S-RS1-BUS-RULE-RESULT-CD 
                IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                
                   PERFORM 7430-GET-RULE-XREF-ID THRU 7430-EXIT         
                END-IF                                                  
                PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT           
             ELSE                                                       
                MOVE WS-BUSRUL-CREATE-MST-ACCT                          
                                            TO S-RS1-BUS-RULE-ID        
                MOVE WS-FAILED              TO S-RS1-BUS-RULE-RESULT-CD 
                IF S-RS1-BUS-RULE-ID GREATER THAN SPACES                
                   PERFORM 7430-GET-RULE-XREF-ID THRU 7430-EXIT         
                END-IF                                                  
                PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-BUILD-RESULT.                                             *        
      ******************************************************************        
       2100-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-SUB-ACCT-CURSOR     THRU 7000-EXIT.        
           PERFORM 7100-FETCH-SUB-ACCT-CURSOR    THRU 7100-EXIT.        
           PERFORM 2200-GET-SUB-ACCOUNT          THRU 2200-EXIT         
                                                 UNTIL NO-MORE-ROWS.    
           PERFORM 7200-CLOSE-SUB-ACCT-CURSOR    THRU 7200-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-GET-SUB-ACCOUNT.                                          *        
      ******************************************************************        
       2200-GET-SUB-ACCOUNT.                                            
                                                                        
           MOVE MU-MST-ACCT-NO              TO S-RS2-MST-ACCT-NO.       
           MOVE MU-SUB-ACCT-NO              TO S-RS2-SUB-ACCT-NO.       
           MOVE MU-CODE-SUB-TOTAL           TO S-RS2-SUB-TOTAL-CODE.    
           MOVE MU-SUB-ACCT-BLLD-OK         TO S-RS2-BILL-STATUS.       
           MOVE AT-CODE-PRNT-BLL-MST        TO S-RS2-CODE-PRNT-BLL-MST. 
           MOVE SPACES                      TO S-RS2-ACCOUNT-NAME.      
                                                                        
           PERFORM 7400-SELECT-SUB-ACCT-DET    THRU 7400-EXIT.          
                                                                        
           MOVE AT-CODE-ACCT-STAT           TO S-RS2-SUB-ACCT-STATUS.   
           MOVE AT-BILL-CYCLE               TO S-RS2-BILL-CYCLE.        
           MOVE AT-CUSTOMER-NO              TO S-RS2-SUB-ACCT-CUST-NO.  
           MOVE AT-PREMISE-NO               TO S-RS2-SUB-ACCT-PREM-NO.  
           SET DONT-SKIP-ACCOUNT            TO TRUE                     
                                                                        
           IF AT-ACCT-FINALED-DT GREATER THAN SPACES                    
              MOVE AT-ACCT-FINALED-DT(1:10) TO WS-WORK-DATE             
              MOVE WS-DELINQ-CD-VALUE       TO C8-DELINQ-CD             
              PERFORM 7440-GET-DELINQ-VALUE    THRU 7440-EXIT           
              MOVE C8-DELINQ-VALUE          TO WS-DLNQ-DAYS             
              PERFORM 7450-FINAL-DATE-PLUS-DLNQ THRU 7450-EXIT          
              IF WS-PLUS60-DATE LESS THAN WS-CURRENT-DATE               
                 SET SKIP-ACCOUNT           TO TRUE                     
              END-IF                                                    
              INITIALIZE     AT-ACCT-FINALED-DT                         
           END-IF.                                                      
                                                                        
           IF DONT-SKIP-ACCOUNT                                         
              PERFORM 2300-GET-CUSTOMER-NAME   THRU 2300-EXIT           
              PERFORM 8200-INSERT-GTT-R2       THRU 8200-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 7100-FETCH-SUB-ACCT-CURSOR  THRU 7100-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-GET-CUSTOMER-NAME.                                        *        
      ******************************************************************        
       2300-GET-CUSTOMER-NAME.                                          
                                                                        
           PERFORM 7500-SELECT-NAME            THRU 7500-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF DQ-NAME-FORMAT EQUAL WS-INDIVIDUAL                     
                 STRING DQ-TITLE-PREFIX   DELIMITED BY SPACES           
                   ' '               DELIMITED BY SIZE                  
                   DQ-FIRST-NAME     DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-MIDDLE-NAME    DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-LAST-NAME      DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-TITLE-SUFFIX-1 DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-TITLE-SUFFIX-2 DELIMITED BY SPACES                
                   INTO S-RS2-ACCOUNT-NAME                              
              ELSE                                                      
                   MOVE DQ-FULL-NAME        TO S-RS2-ACCOUNT-NAME       
              END-IF                                                    
           ELSE                                                         
              PERFORM 7510-SELECT-CUST-NAME    THRU 7510-EXIT           
              IF DQ-NAME-FORMAT EQUAL WS-INDIVIDUAL                     
                 STRING DQ-TITLE-PREFIX   DELIMITED BY SPACES           
                   ' '               DELIMITED BY SIZE                  
                   DQ-FIRST-NAME     DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-MIDDLE-NAME    DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-LAST-NAME      DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-TITLE-SUFFIX-1 DELIMITED BY SPACES                
                   ' '               DELIMITED BY SIZE                  
                   DQ-TITLE-SUFFIX-2 DELIMITED BY SPACES                
                   INTO  S-RS2-ACCOUNT-NAME                             
              ELSE                                                      
                 MOVE DQ-FULL-NAME          TO S-RS2-ACCOUNT-NAME       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-SUB-ACCT-CURSOR                                      *        
      ******************************************************************        
       7000-OPEN-SUB-ACCT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN SUB_ACCT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_MSTSUB_ACCT'        TO TABLE-1                  
              MOVE 'MST_ACCT_NO'            TO TABLE-ELEMENT-1          
              MOVE WS-MST-ACCT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-SUB-ACCT-CURSOR.                                    *        
      ******************************************************************        
       7100-FETCH-SUB-ACCT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  SUB_ACCT_CURSOR                                    
               INTO :MU-SUB-ACCT-NO                                     
                   ,:MU-CODE-SUB-TOTAL                                  
                   ,:MU-SUB-ACCT-BLLD-OK                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7100'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_MSTSUB_ACCT'  TO TABLE-1                  
                    MOVE 'MST_ACCOUNT_NO'   TO TABLE-ELEMENT-1          
                    MOVE WS-MST-ACCT-NO     TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-SUB-ACCT-CURSOR                                     *        
      ******************************************************************        
       7200-CLOSE-SUB-ACCT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE SUB_ACCT_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-CHECK-MSTSUB-ACCT.                                        *        
      ******************************************************************        
       7300-CHECK-MSTSUB-ACCT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MSTR-ACCT-FOUND                                
                FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
               WHERE MST_ACCT_NO = :WS-MST-ACCT-NO                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MSTR-ACCT-FOUND                                        
MFA-TR*         FROM CSS_MSTSUB_ACCT                                            
MFA-TR*        WHERE MST_ACCT_NO = :WS-MST-ACCT-NO                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
              MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-SELECT-SUB-ACCT-DET.                                      *        
      ******************************************************************        
       7400-SELECT-SUB-ACCT-DET.                                        
                                                                        
           EXEC SQL                                                     
             SELECT AT.BILL_CYCLE                                       
                   ,AT.CUSTOMER_NO                                      
                   ,AT.CODE_ACCT_STAT                                   
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                   ,AT.PREMISE_NO                                       
               INTO :AT-BILL-CYCLE                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-ACCT-FINALED-DT :WS-NULL-IND-1                   
                   ,:AT-PREMISE-NO                                      
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO  = :MU-SUB-ACCT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.BILL_CYCLE                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.ACCT_FINALED_DT                                          
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*        INTO :AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-ACCT-FINALED-DT:WS-NULL-IND-1                           
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO  = :MU-SUB-ACCT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7400                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MU-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7410-SELECT-ACCT-DETAILS                                       *        
      ******************************************************************        
       7410-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
             SELECT AT.BANKRUPTCY_IND                                   
                   ,AT.CODE_ACCT_STAT                                   
                   ,AT.CODE_PRNT_BLL_MST                                
                   ,AT.MST_SUB_ACCT_IND                                 
                   ,AT.COMPANY_NO                                       
               INTO :AT-BANKRUPTCY-IND                                  
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CODE-PRNT-BLL-MST                               
                   ,:AT-MST-SUB-ACCT-IND                                
                   ,:AT-COMPANY-NO                                      
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO  = :WS-MST-ACCT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.BANKRUPTCY_IND                                           
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,AT.CODE_PRNT_BLL_MST                                        
MFA-TR*            ,AT.MST_SUB_ACCT_IND                                         
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*        INTO :AT-BANKRUPTCY-IND                                          
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-CODE-PRNT-BLL-MST                                       
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                        
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO  = :WS-MST-ACCT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7410                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7420-CHECK-UTILITY-ACCT.                                       *        
      ******************************************************************        
       7420-CHECK-UTILITY-ACCT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-UTILITY-ACCT                                   
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO  = :WS-MST-ACCT-NO                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-UTILITY-ACCT                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :WS-MST-ACCT-NO                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7420                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7430-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7430-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-RS1-BUS-RULE-XREF-ID                            
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-RS1-BUS-RULE-ID                
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-RS1-BUS-RULE-XREF-ID                                    
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-RS1-BUS-RULE-ID                        
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7430                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7430'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1            
               MOVE S-RS1-BUS-RULE-ID TO HOSTVAR-ELEMENT-1              
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7440-GET-DELINQ-VALUE.                                         *        
      ******************************************************************        
       7440-GET-DELINQ-VALUE.                                           
                                                                        
            EXEC SQL                                                    
                 SELECT C8.DELINQ_VALUE                                 
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                  WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                   
                    AND C8.COMPANY_NO = :AT-COMPANY-NO                  
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT C8.DELINQ_VALUE                                         
MFA-TR*            INTO :C8-DELINQ-VALUE                                        
MFA-TR*            FROM CSS_DELINQUENCY C8                                      
MFA-TR*           WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                           
MFA-TR*             AND C8.COMPANY_NO = :AT-COMPANY-NO                          
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7440                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7440'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_DELINQUENCY'          TO TABLE-1               
               MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1       
               MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1     
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2       
               MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT        
            END-IF.                                                     
                                                                        
       7440-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7450-FINAL-DATE-PLUS-DLNQ.                                     *        
      ******************************************************************        
       7450-FINAL-DATE-PLUS-DLNQ.                                       
                                                                        
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, :WS-DLNQ-DAYS, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-PLUS60-DATE,
              :WS-CURRENT-DATE                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-PLUS60-DATE  =                                             
MFA-TR*                       DATE(:WS-WORK-DATE) + :WS-DLNQ-DAYS DAYS          
MFA-TR*         ,:WS-CURRENT-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
              MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-SELECT-NAME                                               *        
      ******************************************************************        
       7500-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
             SELECT DQ.FIRST_NAME                                       
                   ,DQ.LAST_NAME                                        
                   ,DQ.MIDDLE_NAME                                      
                   ,DQ.TITLE_PREFIX                                     
                   ,DQ.TITLE_SUFFIX_1                                   
                   ,DQ.TITLE_SUFFIX_2                                   
                   ,DQ.FULL_NAME                                        
                   ,DQ.NAME_FORMAT                                      
               INTO :DQ-FIRST-NAME                                      
                   ,:DQ-LAST-NAME                                       
                   ,:DQ-MIDDLE-NAME                                     
                   ,:DQ-TITLE-PREFIX                                    
                   ,:DQ-TITLE-SUFFIX-1                                  
                   ,:DQ-TITLE-SUFFIX-2                                  
                   ,:DQ-FULL-NAME                                       
                   ,:DQ-NAME-FORMAT                                     
               FROM CSS_NAME DQ WITH(READUNCOMMITTED)                           
                   ,CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED)                 
              WHERE AB.ACCOUNT_NO  = :MU-SUB-ACCT-NO                    
                AND DQ.NAME_ID     = AB.NAME_ID                         
                AND AB.NAME_TYPE   = 'DB'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DQ.FIRST_NAME                                               
MFA-TR*            ,DQ.LAST_NAME                                                
MFA-TR*            ,DQ.MIDDLE_NAME                                              
MFA-TR*            ,DQ.TITLE_PREFIX                                             
MFA-TR*            ,DQ.TITLE_SUFFIX_1                                           
MFA-TR*            ,DQ.TITLE_SUFFIX_2                                           
MFA-TR*            ,DQ.FULL_NAME                                                
MFA-TR*            ,DQ.NAME_FORMAT                                              
MFA-TR*        INTO :DQ-FIRST-NAME                                              
MFA-TR*            ,:DQ-LAST-NAME                                               
MFA-TR*            ,:DQ-MIDDLE-NAME                                             
MFA-TR*            ,:DQ-TITLE-PREFIX                                            
MFA-TR*            ,:DQ-TITLE-SUFFIX-1                                          
MFA-TR*            ,:DQ-TITLE-SUFFIX-2                                          
MFA-TR*            ,:DQ-FULL-NAME                                               
MFA-TR*            ,:DQ-NAME-FORMAT                                             
MFA-TR*        FROM CSS_NAME DQ                                                 
MFA-TR*            ,CSS_ACCT_BILL_NMES AB                                       
MFA-TR*       WHERE AB.ACCOUNT_NO  = :MU-SUB-ACCT-NO                            
MFA-TR*         AND DQ.NAME_ID     = AB.NAME_ID                                 
MFA-TR*         AND AB.NAME_TYPE   = 'DB'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_BILL_NMES'       TO TABLE-1                
              MOVE 'CSS_NAME'                 TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MU-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-SELECT-CUST-NAME                                          *        
      ******************************************************************        
       7510-SELECT-CUST-NAME.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DQ.FIRST_NAME                                       
                   ,DQ.LAST_NAME                                        
                   ,DQ.MIDDLE_NAME                                      
                   ,DQ.TITLE_PREFIX                                     
                   ,DQ.TITLE_SUFFIX_1                                   
                   ,DQ.TITLE_SUFFIX_2                                   
                   ,DQ.FULL_NAME                                        
                   ,DQ.NAME_FORMAT                                      
               INTO :DQ-FIRST-NAME                                      
                   ,:DQ-LAST-NAME                                       
                   ,:DQ-MIDDLE-NAME                                     
                   ,:DQ-TITLE-PREFIX                                    
                   ,:DQ-TITLE-SUFFIX-1                                  
                   ,:DQ-TITLE-SUFFIX-2                                  
                   ,:DQ-FULL-NAME                                       
                   ,:DQ-NAME-FORMAT                                     
               FROM CSS_NAME DQ WITH(READUNCOMMITTED)                           
                   ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
              WHERE CU.CUSTOMER_NO = :AT-CUSTOMER-NO                    
                AND DQ.NAME_ID     = CU.NAME_ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DQ.FIRST_NAME                                               
MFA-TR*            ,DQ.LAST_NAME                                                
MFA-TR*            ,DQ.MIDDLE_NAME                                              
MFA-TR*            ,DQ.TITLE_PREFIX                                             
MFA-TR*            ,DQ.TITLE_SUFFIX_1                                           
MFA-TR*            ,DQ.TITLE_SUFFIX_2                                           
MFA-TR*            ,DQ.FULL_NAME                                                
MFA-TR*            ,DQ.NAME_FORMAT                                              
MFA-TR*        INTO :DQ-FIRST-NAME                                              
MFA-TR*            ,:DQ-LAST-NAME                                               
MFA-TR*            ,:DQ-MIDDLE-NAME                                             
MFA-TR*            ,:DQ-TITLE-PREFIX                                            
MFA-TR*            ,:DQ-TITLE-SUFFIX-1                                          
MFA-TR*            ,:DQ-TITLE-SUFFIX-2                                          
MFA-TR*            ,:DQ-FULL-NAME                                               
MFA-TR*            ,:DQ-NAME-FORMAT                                             
MFA-TR*        FROM CSS_NAME DQ                                                 
MFA-TR*            ,CSS_CUSTOMER CU                                             
MFA-TR*       WHERE CU.CUSTOMER_NO = :AT-CUSTOMER-NO                            
MFA-TR*         AND DQ.NAME_ID     = CU.NAME_ID                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7510                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CUSTOMER      '       TO TABLE-1                
              MOVE 'CSS_NAME'                 TO TABLE-2                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-MST-ACCT-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04592_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04592_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04592_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04592_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04592_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04592_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-INSERT-GTT-R1                                             *        
      ******************************************************************        
       8100-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04592_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,BUS_RULE_ID                                         
                   ,BUS_RULE_RESULT_CD                                  
                   ,BUS_RULE_XREF_ID                                    
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-1                                    
                   ,:S-APPL-RETURN-CODE-1                               
                   ,:S-RS1-BUS-RULE-ID                                  
                   ,:S-RS1-BUS-RULE-RESULT-CD                           
                   ,:S-RS1-BUS-RULE-XREF-ID                             
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04592_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,BUS_RULE_ID                                                 
MFA-TR*            ,BUS_RULE_RESULT_CD                                          
MFA-TR*            ,BUS_RULE_XREF_ID                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-APPL-RETURN-CODE-1                                       
MFA-TR*            ,:S-RS1-BUS-RULE-ID                                          
MFA-TR*            ,:S-RS1-BUS-RULE-RESULT-CD                                   
MFA-TR*            ,:S-RS1-BUS-RULE-XREF-ID                                     
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                    TO CTR-ROWS-RS1                 
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04592_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8200-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04592_R2                         
                (                                                       
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,MST_ACCT_NO                                         
                   ,CODE_PRNT_BLL_MST                                   
                   ,SUB_ACCT_NO                                         
                   ,ACCOUNT_NAME                                        
                   ,BILL_CYCLE                                          
                   ,BILL_STATUS                                         
                   ,SUB_TOTAL_CODE                                      
                   ,SUB_ACCT_STATUS                                     
                   ,CUSTOMER_NO                                         
                   ,PREMISE_NO                                          
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-RETURN-CODE-2                                    
                   ,:S-APPL-RETURN-CODE-2                               
                   ,:S-RS2-MST-ACCT-NO                                  
                   ,:S-RS2-CODE-PRNT-BLL-MST                            
                   ,:S-RS2-SUB-ACCT-NO                                  
                   ,:S-RS2-ACCOUNT-NAME                                 
                   ,:S-RS2-BILL-CYCLE                                   
                   ,:S-RS2-BILL-STATUS                                  
                   ,:S-RS2-SUB-TOTAL-CODE                               
                   ,:S-RS2-SUB-ACCT-STATUS                              
                   ,:S-RS2-SUB-ACCT-CUST-NO                             
                   ,:S-RS2-SUB-ACCT-PREM-NO                             
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04592_R2                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,MST_ACCT_NO                                                 
MFA-TR*            ,CODE_PRNT_BLL_MST                                           
MFA-TR*            ,SUB_ACCT_NO                                                 
MFA-TR*            ,ACCOUNT_NAME                                                
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,BILL_STATUS                                                 
MFA-TR*            ,SUB_TOTAL_CODE                                              
MFA-TR*            ,SUB_ACCT_STATUS                                             
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-APPL-RETURN-CODE-2                                       
MFA-TR*            ,:S-RS2-MST-ACCT-NO                                          
MFA-TR*            ,:S-RS2-CODE-PRNT-BLL-MST                                    
MFA-TR*            ,:S-RS2-SUB-ACCT-NO                                          
MFA-TR*            ,:S-RS2-ACCOUNT-NAME                                         
MFA-TR*            ,:S-RS2-BILL-CYCLE                                           
MFA-TR*            ,:S-RS2-BILL-STATUS                                          
MFA-TR*            ,:S-RS2-SUB-TOTAL-CODE                                       
MFA-TR*            ,:S-RS2-SUB-ACCT-STATUS                                      
MFA-TR*            ,:S-RS2-SUB-ACCT-CUST-NO                                     
MFA-TR*            ,:S-RS2-SUB-ACCT-PREM-NO                                     
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                    TO CTR-ROWS-RS2                 
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04592_R2'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8200-INSERT-GTT-R2     THRU 8200-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04592_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04592_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8100-INSERT-GTT-R1          THRU 8100-EXIT.          
           PERFORM 8200-INSERT-GTT-R2          THRU 8200-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
