       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04589.                                         
COB303 DATE-WRITTEN.  DECEMBER 26, 2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CUSTOMER PASSWORD AND PASSWORD HINT.     *00200000
      *  STATUS CODE VALUES                                            *00200000
      *      +4 CUSTOMER NUMBER IS ZERO                                *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  12/26/13    FMB      NEW PROGRAM.                             *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04589'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBCSTSTS                                          00780000
           END-EXEC.                                                    00790000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBCUST                                            00780000
           END-EXEC.                                                    00790000
                                                                        
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
                                                                        
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
                                                                        
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
                                                                        
           EXEC SQL                                                     01420000
              INCLUDE TBPWDHNT                                          01430000
           END-EXEC.                                                    01440000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04589'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-STATS-EXIST-FL        PIC X(01) VALUE 'N'.            
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-PASSWORD-TX         PIC X(16).                          
       01  LINK-PASSWORD-HINT       PIC X(100).                         
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO,                                       
                LINK-PASSWORD-TX,                                       
                LINK-PASSWORD-HINT,                                     
                LINK-USERID,                                            
                LINK-COMMENTS.                                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-NO                          
               MOVE +4 TO S-STATUS-CODE
           END-IF.                                
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO.                   
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
                                                                        
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-PREMISE-NO.              
           MOVE WS-CUSTOMER-NO-NUM       TO MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL087'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-CUST-STATS THRU 7000-EXIT.                      
           MOVE LINK-PASSWORD-HINT TO PZ-PASSWORD-HINT-DESC.            
           PERFORM 7020-GET-HINT-CODE THRU 7020-EXIT.                   
                                                                        
           EVALUATE WS-STATS-EXIST-FL                                   
               WHEN 'Y'                                                 
                   PERFORM 8200-UPDATE-PASSWORD THRU 8200-EXIT          
                   PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT     
                   IF LINK-PASSWORD-TX <= SPACES                        
                       PERFORM 8300-DELETE-NULL-ROW THRU 8300-EXIT      
                   END-IF                                               
               WHEN 'N'                                                 
                   INITIALIZE DCLCSS-CUST-STATS                         
                   MOVE WS-CUSTOMER-NO-NUM TO CE-CUSTOMER-NO            
                   MOVE LINK-PASSWORD-TX TO CE-PASSWORD-TX              
                   MOVE LINK-PASSWORD-HINT TO CE-PASSWORD-HINT          
                   MOVE PZ-PASSWORD-HINT-CD TO CE-PASSWORD-HINT-CD      
                   PERFORM 7010-CUSTOMER THRU 7010-EXIT                 
                   PERFORM 8000-INSERT-PASSWORD THRU 8000-EXIT          
                   PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT     
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF LINK-PASSWORD-TX > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +16                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-PASSWORD-TX      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PASSWORD'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-PASSWORD-HINT > SPACES                               
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +75                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-PASSWORD-HINT    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PASSWORD HINT'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF CE-PASSWORD-TX NOT = LINK-PASSWORD-TX                     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF LINK-PASSWORD-TX > SPACES                              
                  MOVE +16                  TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE LINK-PASSWORD-TX     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF CE-PASSWORD-TX > SPACES                                
                  MOVE +16                  TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE CE-PASSWORD-TX       TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'PASSWORD'               TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF CE-PASSWORD-HINT NOT = LINK-PASSWORD-HINT                 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF LINK-PASSWORD-HINT > SPACES                            
                  MOVE +75                  TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE LINK-PASSWORD-HINT   TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF CE-PASSWORD-HINT > SPACES                              
                  MOVE +75                  TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE CE-PASSWORD-HINT     TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'PASSWORD HINT'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-CUST-STATS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PASSWORD_TX,
              PASSWORD_HINT                                      
              INTO  :CE-PASSWORD-TX,                                    
                    :CE-PASSWORD-HINT                                   
              FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                      
                AND  CUSTOMER_TYPE = 'C'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PASSWORD_TX,                                               
MFA-TR*              PASSWORD_HINT                                              
MFA-TR*       INTO  :CE-PASSWORD-TX,                                            
MFA-TR*             :CE-PASSWORD-HINT                                           
MFA-TR*       FROM   CSS_CUST_STATS                                             
MFA-TR*       WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-STATS-EXIST-FL                        
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-STATS-EXIST-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-CUSTOMER.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
              INTO  :CU-NAME-ID                                         
              FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                         
              WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*       INTO  :CU-NAME-ID                                                 
MFA-TR*       FROM   CSS_CUSTOMER                                               
MFA-TR*       WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-GET-HINT-CODE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PASSWORD_HINT_CD                                   
              INTO  :PZ-PASSWORD-HINT-CD                                
              FROM   CSS_PASSWORD_HINT WITH(READUNCOMMITTED)                    
              WHERE  PASSWORD_HINT_DESC = :PZ-PASSWORD-HINT-DESC        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PASSWORD_HINT_CD                                           
MFA-TR*       INTO  :PZ-PASSWORD-HINT-CD                                        
MFA-TR*       FROM   CSS_PASSWORD_HINT                                          
MFA-TR*       WHERE  PASSWORD_HINT_DESC = :PZ-PASSWORD-HINT-DESC                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PZ-PASSWORD-HINT-CD                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_PASSWORD_HINT' TO TABLE-1                  
                   MOVE 'PASSWORD_HINT_DESC' TO TABLE-ELEMENT-1         
                   MOVE PZ-PASSWORD-HINT-DESC   TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-PASSWORD.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     NAME_ID,                                           
                     PASSWORD_TX,                                       
                     PASSWORD_HINT,                                     
                     PASSWORD_HINT_CD)                                  
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    'C',                                                
                    :CU-NAME-ID,                                        
                    :CE-PASSWORD-TX,                                    
                    :CE-PASSWORD-HINT,                                  
                    :CE-PASSWORD-HINT-CD)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'PASSWORD TX'        TO TABLE-ELEMENT-2              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-PASSWORD-TX       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-UPDATE-PASSWORD.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
              SET    PASSWORD_TX   = :LINK-PASSWORD-TX,                 
                     PASSWORD_HINT = :LINK-PASSWORD-HINT,               
                     PASSWORD_HINT_CD = :PZ-PASSWORD-HINT-CD            
              WHERE  CUSTOMER_NO   = :CE-CUSTOMER-NO                    
                AND  CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*       SET    PASSWORD_TX   = :LINK-PASSWORD-TX,                         
MFA-TR*              PASSWORD_HINT = :LINK-PASSWORD-HINT,                       
MFA-TR*              PASSWORD_HINT_CD = :PZ-PASSWORD-HINT-CD                    
MFA-TR*       WHERE  CUSTOMER_NO   = :CE-CUSTOMER-NO                            
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PASSWORD TX'        TO TABLE-ELEMENT-2              
              MOVE CE-PASSWORD-TX       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-DELETE-NULL-ROW.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'C'                          
                 AND SSN                =  ' '                          
                 AND CODE_STATE_ID      =  ' '                          
                 AND DRIVERS_LICENSE_NO =  ' '                          
                 AND EMPLOYER           =  ' '                          
                 AND EMPLOYED_DATE      IS NULL                         
                 AND OCCUPATION         =  ' '                          
                 AND OTHER_ID_TYPE      =  ' '                          
                 AND OTHER_ID           =  ' '                          
                 AND DRVR_LIC_ISS_DT    IS NULL                         
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_NBR       =  ' '                          
                 AND INTR_CO_IND        =  ' '                          
                 AND EBILL_REGISTER_IND =  ' '                          
                 AND PASSWORD_HINT_CD   = ' '                           
                 AND PASSWORD_TX        = ' '                           
                 AND REFUSED_SSN_FL     = ' '                           
                 AND LANGUAGE_PREF_CD   = ' '                           
                 AND DOB_VERIFIED_CD    = ' '                           
                 AND ACCESS_LEVEL_CD    = ' '                           
                 AND ALLOW_CALL_FL      IN (' ', 'Y')                   
                 AND ITIN_ID            = ' '                           
                 AND VERIFY_SSN_FL      = ' '                           
                 AND PASSWORD_HINT      = ' '                           
                 AND ALLOW_EMAIL_FL     IN (' ', 'Y')                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ' '                                  
MFA-TR*          AND PASSWORD_HINT_CD   = ' '                                   
MFA-TR*          AND PASSWORD_TX        = ' '                                   
MFA-TR*          AND REFUSED_SSN_FL     = ' '                                   
MFA-TR*          AND LANGUAGE_PREF_CD   = ' '                                   
MFA-TR*          AND DOB_VERIFIED_CD    = ' '                                   
MFA-TR*          AND ACCESS_LEVEL_CD    = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      IN (' ', 'Y')                           
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND VERIFY_SSN_FL      = ' '                                   
MFA-TR*          AND PASSWORD_HINT      = ' '                                   
MFA-TR*          AND ALLOW_EMAIL_FL     IN (' ', 'Y')                           
MFA-TR*       QUERYNO 8300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
