       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04585.                                         
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 25, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00270000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM VALIDATES SSN/DLN/ITIN/OTHER ID AGAINST EXISTING *00210000
      *  RECORDS.                                                      *00220000
      *                                                                *00230000
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  12/25/13    FMB      ORIGINALLY CREATED.                      *00330000
A05317*  11/02/16    FMB      UNCOMMENT ITIN MATCH LOGIC.              *00330000
      ******************************************************************00350000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04585'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                               PIC X(40) VALUE       
           'WORKING STORAGE FOR CSR04585 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE SQLCA                                             00650000
           END-EXEC.                                                    00660000
                                                                        
           EXEC SQL                                                     00751000
              INCLUDE TBCSTSTS                                          00752000
           END-EXEC.                                                    00753000
                                                                        
           EXEC SQL                                                     00755000
              INCLUDE TBACCT                                            00756000
           END-EXEC.                                                    00757000
                                                                        
           EXEC SQL                                                     00755000
              INCLUDE TBRULXRF                                          00756000
           END-EXEC.                                                    00757000
                                                                        
           COPY CCA00001.                                               00830000
           COPY CWS00303.                                               00860000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC-VALUES.                                              
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04585'.     
           05  WS-GTT01-DECLARED       PIC X(01) VALUE 'N'.             
           05  WS-CUSTOMER-NO-CHAR     PIC X(10) VALUE ZEROES.          
           05  WS-CUSTOMER-NO-NUM      REDEFINES WS-CUSTOMER-NO-CHAR    
                                       PIC 9(10).                       
           05  WS-ITIN-BAD-MATCH-FL    PIC X(01) VALUE 'N'.             
           05  WS-SSN-BAD-MATCH-FL     PIC X(01) VALUE 'N'.             
           05  WS-DLN-BAD-MATCH-FL     PIC X(01) VALUE 'N'.             
           05  WS-OTHER-ID-BAD-MATCH-FL PIC X(01) VALUE 'N'.            
           05  WS-ITIN-GOOD-MATCH-FL   PIC X(01) VALUE 'N'.             
           05  WS-SSN-GOOD-MATCH-FL    PIC X(01) VALUE 'N'.             
           05  WS-DLN-GOOD-MATCH-FL    PIC X(01) VALUE 'N'.             
           05  WS-OTHER-ID-GOOD-MATCH-FL PIC X(01) VALUE 'N'.           
           05  WS-SSN-MATCH-FL         PIC X(01) VALUE 'N'.             
           05  WS-ITIN-MATCH-FL        PIC X(01) VALUE 'N'.             
           05  WS-DLN-MATCH-FL         PIC X(01) VALUE 'N'.             
           05  WS-OTHER-ID-MATCH-FL    PIC X(01) VALUE 'N'.             
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TS           PIC X(26) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04585_R1'.          
       01  GTT-RETURN-FIELDS.                                           
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.      
              10 S-STATUS-CODE          PIC S9(9) COMP VALUE ZERO.      
              10 S-BUS-RULE-ID          PIC X(10) VALUE SPACES.         
              10 S-RULE-RESULT-CD       PIC X(08) VALUE SPACES.         
              10 S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.         
              10 S-MESSAGE-PARMS        PIC X(200) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 RULE_RESULT_CD       AS RULE_RESULT_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
                 MESSAGE_PARMS        AS MESSAGE_PARMS                  
              FROM #CSR04585_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          RULE_RESULT_CD       AS RULE_RESULT_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          MESSAGE_PARMS        AS MESSAGE_PARMS                          
MFA-TR*       FROM SESSION.CSR04585_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-RULE-RESULT-CD    AS RULE_RESULT_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,         
                      :S-MESSAGE-PARMS     AS MESSAGE_PARMS             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-RULE-RESULT-CD    AS RULE_RESULT_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,                 
MFA-TR*               :S-MESSAGE-PARMS     AS MESSAGE_PARMS                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACTION-CODE         PIC X(01).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-SSN                 PIC X(09).                          
       01  LINK-LICENSE-NO          PIC X(19).                          
       01  LINK-CODE-STATE-ID       PIC X(02).                          
       01  LINK-OTHER-ID            PIC X(16).                          
       01  LINK-OTHER-ID-TYPE       PIC X(12).                          
       01  LINK-BYPASS-FLAG         PIC X(01).                          
       01  LINK-ITIN                PIC X(09).                          
                                                                        
       PROCEDURE DIVISION USING LINK-ACTION-CODE,                       
                                LINK-CUSTOMER-NO,                       
                                LINK-SSN,                               
                                LINK-LICENSE-NO,                        
                                LINK-CODE-STATE-ID,                     
                                LINK-OTHER-ID,                          
                                LINK-OTHER-ID-TYPE,                     
                                LINK-BYPASS-FLAG,                       
                                LINK-ITIN.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'NO DATA' TO S-BUS-RULE-ID                          
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04585_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04585_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               RULE_RESULT_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MESSAGE_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04585_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE 'F' TO LINK-BYPASS-FLAG.                                
           MOVE 'CASA' TO 1T-BUS-PROCESS-ID.                            
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-SSN = SPACES AND                                     
              LINK-ITIN = SPACES AND                                    
              LINK-LICENSE-NO = SPACES AND                              
              LINK-OTHER-ID = SPACES                                    
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'NO PARMS' TO S-BUS-RULE-ID                      
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-ACTION-CODE                                    
               WHEN 'D'                                                 
                   PERFORM 5100-CHECK-ACCOUNTS THRU 5100-EXIT           
               WHEN 'I'                                                 
               WHEN 'U'                                                 
                   PERFORM 5000-PROCESS-INSERT-CHECK THRU 5000-EXIT     
               WHEN OTHER                                               
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE +1 TO S-STATUS-CODE                             
                   MOVE 'BAD ACTION' TO S-BUS-RULE-ID                   
                   ADD +1 TO CTR-ROWS                                   
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-SSN-BAD-MATCH-FL = 'Y'                                 
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000001' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-SSN TO S-MESSAGE-PARMS                         
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-DLN-BAD-MATCH-FL = 'Y'                                 
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000002' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-LICENSE-NO                                   
                      ';'                                               
                      LINK-CODE-STATE-ID                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-OTHER-ID-BAD-MATCH-FL = 'Y'                            
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000003' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-OTHER-ID                                     
                      ';'                                               
                      LINK-OTHER-ID-TYPE                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-ITIN-BAD-MATCH-FL = 'Y'                                
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000004' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-ITIN TO S-MESSAGE-PARMS                        
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-SSN-GOOD-MATCH-FL = 'Y'                                
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000005' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-SSN TO S-MESSAGE-PARMS                         
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-DLN-GOOD-MATCH-FL = 'Y'                                
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000006' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-LICENSE-NO                                   
                      ';'                                               
                      LINK-CODE-STATE-ID                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-OTHER-ID-GOOD-MATCH-FL = 'Y'                           
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000007' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-OTHER-ID                                     
                      ';'                                               
                      LINK-OTHER-ID-TYPE                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-ITIN-GOOD-MATCH-FL = 'Y'                               
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000008' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-ITIN TO S-MESSAGE-PARMS                        
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-SSN-MATCH-FL = 'Y'                                     
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-SSN TO S-MESSAGE-PARMS                         
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-DLN-MATCH-FL = 'Y'                                     
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000010' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-LICENSE-NO                                   
                      ';'                                               
                      LINK-CODE-STATE-ID                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-OTHER-ID-MATCH-FL = 'Y'                                
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000011' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               STRING LINK-OTHER-ID                                     
                      ';'                                               
                      LINK-OTHER-ID-TYPE                                
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-ITIN-MATCH-FL = 'Y'                                    
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'CASA000012' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-RULE-RESULT-CD                             
               MOVE LINK-ITIN TO S-MESSAGE-PARMS                        
               PERFORM 7200-RULE-XREF THRU 7200-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-PROCESS-INSERT-CHECK.                                       
                                                                        
           MOVE 'C' TO CE-CUSTOMER-TYPE.                                
           IF LINK-BYPASS-FLAG = 'F'                                    
               PERFORM 7100-CHECK-CUSTOMER THRU 7100-EXIT
           END-IF.              
                                                                        
           IF WS-SSN-MATCH-FL = 'Y' OR                                  
              WS-DLN-MATCH-FL = 'Y' OR                                  
              WS-OTHER-ID-MATCH-FL = 'Y' OR                             
              WS-ITIN-MATCH-FL = 'Y'                                    
                  NEXT SENTENCE                                         
           ELSE                                                         
               PERFORM 5100-CHECK-ACCOUNTS THRU 5100-EXIT
           END-IF.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04118200
      *   DO THE IDS ENTERED MATCH A SPOUSE WITH A WRITE OFF/BANKRUPT/ *04118400
      *   JUDGEMENT ACCOUNT?                                           *04118500
      *   DO THE IDS ENTERED MATCH A SPOUSE WITH ANY ACCOUNT?          *04118400
      ******************************************************************04118700
                                                                        
       5100-CHECK-ACCOUNTS.                                             
                                                                        
           IF LINK-ITIN > SPACES                                        
              MOVE LINK-ITIN TO CE-ITIN-ID                              
              PERFORM 7000-CHECK-ITIN THRU 7000-EXIT
           END-IF.                   
                                                                        
           IF LINK-SSN > SPACES                                         
              MOVE LINK-SSN TO CE-SSN                                   
              PERFORM 7010-CHECK-SSN THRU 7010-EXIT
           END-IF.                    
                                                                        
           IF LINK-LICENSE-NO > SPACES                                  
              MOVE LINK-LICENSE-NO TO CE-DRIVERS-LICENSE-NO             
              MOVE LINK-CODE-STATE-ID TO CE-CODE-STATE-ID               
              PERFORM 7020-CHECK-DLN THRU 7020-EXIT
           END-IF.                    
                                                                        
           IF LINK-OTHER-ID > SPACES                                    
              MOVE LINK-OTHER-ID TO CE-OTHER-ID                         
              MOVE LINK-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE               
              PERFORM 7030-CHECK-OTHER-ID THRU 7030-EXIT
           END-IF.               
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-CHECK-ITIN.                                                 
                                                                        
           MOVE 'N' TO WS-ITIN-BAD-MATCH-FL.                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-ITIN-BAD-MATCH-FL                               
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE AT.CUSTOMER_NO  = CE.CUSTOMER_NO                    
                AND ITIN_ID         = :CE-ITIN-ID                       
                AND CUSTOMER_TYPE   = 'S'                               
                AND (CODE_ACCT_STAT = 'S'                               
                 OR  BANKRUPTCY_IND = 'B'                               
                 OR  JUDGEMENT_IND  = 'J')                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04181600
MFA-TR*      SELECT 'Y'                                                 04181700
MFA-TR*        INTO :WS-ITIN-BAD-MATCH-FL                               04181800
MFA-TR*        FROM CSS_ACCOUNT AT,                                     04181900
MFA-TR*             CSS_CUST_STATS CE                                   04182000
MFA-TR*       WHERE AT.CUSTOMER_NO  = CE.CUSTOMER_NO                    04182100
MFA-TR*         AND ITIN_ID         = :CE-ITIN-ID                       04182200
MFA-TR*         AND CUSTOMER_TYPE   = 'S'                               04182400
MFA-TR*         AND (CODE_ACCT_STAT = 'S'                               04182500
MFA-TR*          OR  BANKRUPTCY_IND = 'B'                               04182600
MFA-TR*          OR  JUDGEMENT_IND  = 'J')                              04182700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 70001                                                     
MFA-TR*    END-EXEC.                                                    04182800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ITIN-BAD-MATCH-FL                     
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ITIN-BAD-MATCH-FL                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_CUST_STATS'    TO TABLE-2                  
                   MOVE 'ITIN_ID'           TO TABLE-ELEMENT-1          
                   MOVE CE-ITIN-ID          TO HOSTVAR-ELEMENT-1        
                   MOVE 'BAD'               TO TABLE-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-ITIN-BAD-MATCH-FL = 'N'                                
               EXEC SQL                                                 
                 SELECT TOP(1) 'Y'                                             
                   INTO :WS-ITIN-GOOD-MATCH-FL                          
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_CUST_STATS CE WITH(READUNCOMMITTED)                 
                  WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 
                    AND ITIN_ID     = :CE-ITIN-ID                       
                    AND CUSTOMER_TYPE = 'S'                             
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                 04181600
MFA-TR*          SELECT 'Y'                                             04181700
MFA-TR*            INTO :WS-ITIN-GOOD-MATCH-FL                          04181800
MFA-TR*            FROM CSS_ACCOUNT AT,                                 04181900
MFA-TR*                 CSS_CUST_STATS CE                               04182000
MFA-TR*           WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 04182100
MFA-TR*             AND ITIN_ID     = :CE-ITIN-ID                       04182200
MFA-TR*             AND CUSTOMER_TYPE = 'S'                             04182400
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 70002                                                 
MFA-TR*        END-EXEC                                                 04182800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'Y' TO WS-ITIN-GOOD-MATCH-FL                
                   WHEN NOT-FOUND                                       
                       MOVE 'N' TO WS-ITIN-GOOD-MATCH-FL                
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME    TO ABEND-PROGRAM            
                       MOVE SQLCODE         TO ABEND-SQLCODE            
                       MOVE SQLSTATE        TO ABEND-SQLSTATE           
                       MOVE '7000'          TO ACTIVE-PARAGRAPH         
                       MOVE 'SELECT'        TO ABEND-FUNCTION           
                       MOVE 'CSS_ACCOUNT'   TO TABLE-1                  
                       MOVE 'CSS_CUST_STATS' TO TABLE-2                 
                       MOVE 'ITIN_ID'       TO TABLE-ELEMENT-1          
                       MOVE CE-ITIN-ID      TO HOSTVAR-ELEMENT-1        
                       MOVE 'GOOD'          TO TABLE-ELEMENT-2          
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE
           END-IF.                                            
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-CHECK-SSN.                                                  
                                                                        
           MOVE 'N' TO WS-SSN-BAD-MATCH-FL.                             
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-SSN-BAD-MATCH-FL                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE AT.CUSTOMER_NO  = CE.CUSTOMER_NO                    
                AND SSN             = :CE-SSN                           
                AND CUSTOMER_TYPE   = 'S'                               
                AND (CODE_ACCT_STAT = 'S'                               
                 OR  BANKRUPTCY_IND = 'B'                               
                 OR  JUDGEMENT_IND  = 'J')                              
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04181600
MFA-TR*      SELECT 'Y'                                                 04181700
MFA-TR*        INTO :WS-SSN-BAD-MATCH-FL                                04181800
MFA-TR*        FROM CSS_ACCOUNT AT,                                     04181900
MFA-TR*             CSS_CUST_STATS CE                                   04182000
MFA-TR*       WHERE AT.CUSTOMER_NO  = CE.CUSTOMER_NO                    04182100
MFA-TR*         AND SSN             = :CE-SSN                           04182200
MFA-TR*         AND CUSTOMER_TYPE   = 'S'                               04182400
MFA-TR*         AND (CODE_ACCT_STAT = 'S'                               04182500
MFA-TR*          OR  BANKRUPTCY_IND = 'B'                               04182600
MFA-TR*          OR  JUDGEMENT_IND  = 'J')                              04182700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 70101                                                     
MFA-TR*    END-EXEC.                                                    04182800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SSN-BAD-MATCH-FL                      
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SSN-BAD-MATCH-FL                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '70101'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_CUST_STATS'    TO TABLE-2                  
                   MOVE 'SSN'               TO TABLE-ELEMENT-1          
                   MOVE CE-SSN              TO HOSTVAR-ELEMENT-1        
                   MOVE 'BAD'               TO TABLE-ELEMENT-2          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-SSN-BAD-MATCH-FL = 'N'                                 
               EXEC SQL                                                 
                 SELECT TOP(1) 'Y'                                             
                   INTO :WS-SSN-GOOD-MATCH-FL                           
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_CUST_STATS CE WITH(READUNCOMMITTED)                 
                  WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 
                    AND SSN        = :CE-SSN                            
                    AND CUSTOMER_TYPE = 'S'                             
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                 04168100
MFA-TR*          SELECT 'Y'                                             04168200
MFA-TR*            INTO :WS-SSN-GOOD-MATCH-FL                           04168300
MFA-TR*            FROM CSS_ACCOUNT AT,                                 04168400
MFA-TR*                 CSS_CUST_STATS CE                               04168500
MFA-TR*           WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 04168600
MFA-TR*             AND SSN        = :CE-SSN                            04168700
MFA-TR*             AND CUSTOMER_TYPE = 'S'                             04168800
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 70102                                                 
MFA-TR*        END-EXEC                                                 04169200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'Y' TO WS-SSN-GOOD-MATCH-FL                 
                   WHEN NOT-FOUND                                       
                       MOVE 'N' TO WS-SSN-GOOD-MATCH-FL                 
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME    TO ABEND-PROGRAM            
                       MOVE SQLCODE         TO ABEND-SQLCODE            
                       MOVE SQLSTATE        TO ABEND-SQLSTATE           
                       MOVE '7010'          TO ACTIVE-PARAGRAPH         
                       MOVE 'SELECT'        TO ABEND-FUNCTION           
                       MOVE 'CSS_ACCOUNT'   TO TABLE-1                  
                       MOVE 'CSS_CUST_STATS' TO TABLE-2                 
                       MOVE 'SSN'           TO TABLE-ELEMENT-1          
                       MOVE CE-SSN          TO HOSTVAR-ELEMENT-1        
                       MOVE 'GOOD'          TO TABLE-ELEMENT-2          
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE
           END-IF.                                            
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CHECK-DLN.                                                  
                                                                        
           MOVE 'N' TO WS-DLN-BAD-MATCH-FL.                             
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-DLN-BAD-MATCH-FL                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE AT.CUSTOMER_NO     = CE.CUSTOMER_NO                 
                AND DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO         
                AND CODE_STATE_ID      = :CE-CODE-STATE-ID              
                AND CUSTOMER_TYPE      = 'S'                            
                AND (CODE_ACCT_STAT    = 'S'                            
                 OR  BANKRUPTCY_IND    = 'B'                            
                 OR  JUDGEMENT_IND     = 'J')                           
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04172700
MFA-TR*      SELECT 'Y'                                                 04172800
MFA-TR*        INTO :WS-DLN-BAD-MATCH-FL                                04172900
MFA-TR*        FROM CSS_ACCOUNT AT,                                     04181900
MFA-TR*             CSS_CUST_STATS CE                                   04182000
MFA-TR*       WHERE AT.CUSTOMER_NO     = CE.CUSTOMER_NO                 04182100
MFA-TR*         AND DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO         04182200
MFA-TR*         AND CODE_STATE_ID      = :CE-CODE-STATE-ID              04182200
MFA-TR*         AND CUSTOMER_TYPE      = 'S'                            04182400
MFA-TR*         AND (CODE_ACCT_STAT    = 'S'                            04182500
MFA-TR*          OR  BANKRUPTCY_IND    = 'B'                            04182600
MFA-TR*          OR  JUDGEMENT_IND     = 'J')                           04182700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 70201                                                     
MFA-TR*    END-EXEC.                                                    04173900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-DLN-BAD-MATCH-FL                      
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DLN-BAD-MATCH-FL                      
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_CUST_STATS'    TO TABLE-2                  
                   MOVE 'DLN'               TO TABLE-ELEMENT-1          
                   MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-1      
                   MOVE 'STATE'             TO TABLE-ELEMENT-2          
                   MOVE CE-CODE-STATE-ID    TO HOSTVAR-ELEMENT-2        
                   MOVE 'BAD'               TO TABLE-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-DLN-BAD-MATCH-FL = 'N'                                 
               EXEC SQL                                                 
                 SELECT TOP(1) 'Y'                                             
                   INTO :WS-DLN-GOOD-MATCH-FL                           
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_CUST_STATS CE WITH(READUNCOMMITTED)                 
                  WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 
                    AND DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO     
                    AND CODE_STATE_ID  = :CE-CODE-STATE-ID              
                    AND CUSTOMER_TYPE  = 'S'                            
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                 04172700
MFA-TR*          SELECT 'Y'                                             04172800
MFA-TR*            INTO :WS-DLN-GOOD-MATCH-FL                           04172900
MFA-TR*            FROM CSS_ACCOUNT AT,                                 04181900
MFA-TR*                 CSS_CUST_STATS CE                               04182000
MFA-TR*           WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 04182100
MFA-TR*             AND DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO     04182200
MFA-TR*             AND CODE_STATE_ID  = :CE-CODE-STATE-ID              04182200
MFA-TR*             AND CUSTOMER_TYPE  = 'S'                            04182400
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 70202                                                 
MFA-TR*        END-EXEC                                                 04173900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'Y' TO WS-DLN-GOOD-MATCH-FL                 
                   WHEN NOT-FOUND                                       
                       MOVE 'N' TO WS-DLN-GOOD-MATCH-FL                 
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME    TO ABEND-PROGRAM            
                       MOVE SQLCODE         TO ABEND-SQLCODE            
                       MOVE SQLSTATE        TO ABEND-SQLSTATE           
                       MOVE '7020'          TO ACTIVE-PARAGRAPH         
                       MOVE 'SELECT'        TO ABEND-FUNCTION           
                       MOVE 'CSS_ACCOUNT'   TO TABLE-1                  
                       MOVE 'CSS_CUST_STATS' TO TABLE-2                 
                       MOVE 'DLN'           TO TABLE-ELEMENT-1          
                       MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-1  
                       MOVE 'STATE'         TO TABLE-ELEMENT-2          
                       MOVE CE-CODE-STATE-ID TO HOSTVAR-ELEMENT-2       
                       MOVE 'GOOD'          TO TABLE-ELEMENT-3          
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE
           END-IF.                                            
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CHECK-OTHER-ID.                                             
                                                                        
           MOVE 'N' TO WS-OTHER-ID-BAD-MATCH-FL.                        
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
               INTO :WS-OTHER-ID-BAD-MATCH-FL                           
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_CUST_STATS CE WITH(READUNCOMMITTED)                     
              WHERE AT.CUSTOMER_NO     = CE.CUSTOMER_NO                 
                AND OTHER_ID           = :CE-OTHER-ID                   
                AND OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE              
                AND CUSTOMER_TYPE      = 'S'                            
                AND (CODE_ACCT_STAT    = 'S'                            
                 OR  BANKRUPTCY_IND    = 'B'                            
                 OR  JUDGEMENT_IND     = 'J')                           
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04181600
MFA-TR*      SELECT 'Y'                                                 04181700
MFA-TR*        INTO :WS-OTHER-ID-BAD-MATCH-FL                           04181800
MFA-TR*        FROM CSS_ACCOUNT AT,                                     04181900
MFA-TR*             CSS_CUST_STATS CE                                   04182000
MFA-TR*       WHERE AT.CUSTOMER_NO     = CE.CUSTOMER_NO                 04182100
MFA-TR*         AND OTHER_ID           = :CE-OTHER-ID                   04182200
MFA-TR*         AND OTHER_ID_TYPE      = :CE-OTHER-ID-TYPE              04182200
MFA-TR*         AND CUSTOMER_TYPE      = 'S'                            04182400
MFA-TR*         AND (CODE_ACCT_STAT    = 'S'                            04182500
MFA-TR*          OR  BANKRUPTCY_IND    = 'B'                            04182600
MFA-TR*          OR  JUDGEMENT_IND     = 'J')                           04182700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 70301                                                     
MFA-TR*    END-EXEC.                                                    04182800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-OTHER-ID-BAD-MATCH-FL                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-OTHER-ID-BAD-MATCH-FL                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_CUST_STATS'    TO TABLE-2                  
                   MOVE 'OTHER ID'          TO TABLE-ELEMENT-1          
                   MOVE CE-OTHER-ID         TO HOSTVAR-ELEMENT-1        
                   MOVE 'OTHER ID TYPE'     TO TABLE-ELEMENT-2          
                   MOVE CE-OTHER-ID-TYPE    TO HOSTVAR-ELEMENT-2        
                   MOVE 'BAD'               TO TABLE-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-DLN-BAD-MATCH-FL = 'N'                                 
               EXEC SQL                                                 
                 SELECT TOP(1) 'Y'                                             
                   INTO :WS-OTHER-ID-GOOD-MATCH-FL                      
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_CUST_STATS CE WITH(READUNCOMMITTED)                 
                  WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 
                    AND OTHER_ID       = :CE-OTHER-ID                   
                    AND OTHER_ID_TYPE  = :CE-OTHER-ID-TYPE              
                    AND CUSTOMER_TYPE  = 'S'                            
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                 04181600
MFA-TR*          SELECT 'Y'                                             04181700
MFA-TR*            INTO :WS-OTHER-ID-GOOD-MATCH-FL                      04181800
MFA-TR*            FROM CSS_ACCOUNT AT,                                 04181900
MFA-TR*                 CSS_CUST_STATS CE                               04182000
MFA-TR*           WHERE AT.CUSTOMER_NO = CE.CUSTOMER_NO                 04182100
MFA-TR*             AND OTHER_ID       = :CE-OTHER-ID                   04182200
MFA-TR*             AND OTHER_ID_TYPE  = :CE-OTHER-ID-TYPE              04182200
MFA-TR*             AND CUSTOMER_TYPE  = 'S'                            04182400
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 70302                                                 
MFA-TR*        END-EXEC                                                 04182800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'Y' TO WS-OTHER-ID-GOOD-MATCH-FL            
                   WHEN NOT-FOUND                                       
                       MOVE 'N' TO WS-OTHER-ID-GOOD-MATCH-FL            
                       MOVE ZEROES TO WS-ACTIVE-RETURN-CODE             
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME    TO ABEND-PROGRAM            
                       MOVE SQLCODE         TO ABEND-SQLCODE            
                       MOVE SQLSTATE        TO ABEND-SQLSTATE           
                       MOVE '7030'          TO ACTIVE-PARAGRAPH         
                       MOVE 'SELECT'        TO ABEND-FUNCTION           
                       MOVE 'CSS_ACCOUNT'   TO TABLE-1                  
                       MOVE 'CSS_CUST_STATS' TO TABLE-2                 
                       MOVE 'OTHER ID'      TO TABLE-ELEMENT-1          
                       MOVE CE-OTHER-ID     TO HOSTVAR-ELEMENT-1        
                       MOVE 'OTHER ID TYPE' TO TABLE-ELEMENT-2          
                       MOVE CE-OTHER-ID-TYPE TO HOSTVAR-ELEMENT-2       
                       MOVE 'GOOD'          TO TABLE-ELEMENT-3          
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
               END-EVALUATE
           END-IF.                                            
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CHECK-CUSTOMER.                                             
                                                                        
           IF LINK-SSN > SPACES                                         
              MOVE LINK-SSN TO CE-SSN                                   
              PERFORM 7110-CHECK-SSN-MATCH THRU 7110-EXIT
           END-IF.              
                                                                        
           IF LINK-LICENSE-NO > SPACES                                  
              MOVE LINK-LICENSE-NO TO CE-DRIVERS-LICENSE-NO             
              MOVE LINK-CODE-STATE-ID TO CE-CODE-STATE-ID               
              PERFORM 7120-CHECK-LICENSE-NO THRU 7120-EXIT
           END-IF.             
                                                                        
           IF LINK-OTHER-ID > SPACES                                    
              MOVE LINK-OTHER-ID TO CE-OTHER-ID                         
              MOVE LINK-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE               
              PERFORM 7130-CHECK-OTHER-ID THRU 7130-EXIT
           END-IF.               
                                                                        
           IF LINK-ITIN > SPACES                                        
              MOVE LINK-ITIN TO CE-ITIN-ID                              
              PERFORM 7140-CHECK-ITIN-MATCH THRU 7140-EXIT
           END-IF.             
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-CHECK-SSN-MATCH.                                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
              WHERE SSN           = :CE-SSN                             
                AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04132200
MFA-TR*      SELECT CUSTOMER_NO                                         04133000
MFA-TR*        INTO :CE-CUSTOMER-NO                                     04138200
MFA-TR*        FROM CSS_CUST_STATS                                      04141600
MFA-TR*       WHERE SSN           = :CE-SSN                             04141700
MFA-TR*         AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   04141800
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                    04141900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = WS-CUSTOMER-NO-NUM               
                       MOVE 'N' TO WS-SSN-MATCH-FL                      
                   ELSE                                                 
                       MOVE 'Y' TO WS-SSN-MATCH-FL                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SSN-MATCH-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7110'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'SSN'               TO TABLE-ELEMENT-1          
                   MOVE CE-SSN              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CHECK-LICENSE-NO.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
              WHERE DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO         
                AND CODE_STATE_ID      = :CE-CODE-STATE-ID              
                AND CUSTOMER_TYPE      = :CE-CUSTOMER-TYPE              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04145700
MFA-TR*      SELECT CUSTOMER_NO                                         04145800
MFA-TR*        INTO :CE-CUSTOMER-NO                                     04146200
MFA-TR*        FROM CSS_CUST_STATS                                      04146900
MFA-TR*       WHERE DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO         04147000
MFA-TR*         AND CODE_STATE_ID      = :CE-CODE-STATE-ID              04147100
MFA-TR*         AND CUSTOMER_TYPE      = :CE-CUSTOMER-TYPE              04147200
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                    04147300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = WS-CUSTOMER-NO-NUM               
                       MOVE 'N' TO WS-DLN-MATCH-FL                      
                   ELSE                                                 
                       MOVE 'Y' TO WS-DLN-MATCH-FL                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DLN-MATCH-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7120'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-1        
                   MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-1      
                   MOVE 'CODE_STATE_ID'       TO TABLE-ELEMENT-2        
                   MOVE CE-CODE-STATE-ID      TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-CHECK-OTHER-ID.                                             
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
              WHERE OTHER_ID      = :CE-OTHER-ID                        
                AND OTHER_ID_TYPE = :CE-OTHER-ID-TYPE                   
                AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04152200
MFA-TR*      SELECT CUSTOMER_NO                                         04152300
MFA-TR*        INTO :CE-CUSTOMER-NO                                     04152400
MFA-TR*        FROM CSS_CUST_STATS                                      04152500
MFA-TR*       WHERE OTHER_ID      = :CE-OTHER-ID                        04152600
MFA-TR*         AND OTHER_ID_TYPE = :CE-OTHER-ID-TYPE                   04152700
MFA-TR*         AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   04152800
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                    04152900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = WS-CUSTOMER-NO-NUM               
                       MOVE 'N' TO WS-OTHER-ID-MATCH-FL                 
                   ELSE                                                 
                       MOVE 'Y' TO WS-OTHER-ID-MATCH-FL                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-OTHER-ID-MATCH-FL                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7130'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'OTHER_ID'            TO TABLE-ELEMENT-1        
                   MOVE CE-OTHER-ID           TO HOSTVAR-ELEMENT-1      
                   MOVE 'OTHER_ID_TYPE'       TO TABLE-ELEMENT-2        
                   MOVE CE-OTHER-ID-TYPE      TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-CHECK-ITIN-MATCH.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
              WHERE ITIN_ID       = :CE-ITIN-ID                         
                AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04132200
MFA-TR*      SELECT CUSTOMER_NO                                         04133000
MFA-TR*        INTO :CE-CUSTOMER-NO                                     04138200
MFA-TR*        FROM CSS_CUST_STATS                                      04141600
MFA-TR*       WHERE ITIN_ID       = :CE-ITIN-ID                         04141700
MFA-TR*         AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   04141800
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                    04141900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = WS-CUSTOMER-NO-NUM               
                       MOVE 'N' TO WS-ITIN-MATCH-FL                     
                   ELSE                                                 
                       MOVE 'Y' TO WS-ITIN-MATCH-FL                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ITIN-MATCH-FL                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7140'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE CE-ITIN-ID         TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04585_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04585_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04585_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04585_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_RULE_ID,                                              
              RULE_RESULT_CD,                                           
              BUS_RULE_XREF_ID,                                         
              MESSAGE_PARMS                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-RULE-RESULT-CD,                                       
               :S-BUS-RULE-XREF-ID,                                     
               :S-MESSAGE-PARMS                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04585_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       RULE_RESULT_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       MESSAGE_PARMS                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-RULE-RESULT-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID,                                             
MFA-TR*        :S-MESSAGE-PARMS                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04585_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
