       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04584.                                          
       AUTHOR.       VIDHU VALSARAJAN.                                  
       DATE-WRITTEN. DEC 2013.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                P R O G R A M  S U M M A R Y                    *        
      *                                                                *        
      *         THIS IS THE ORDER RETRIEVE DRIVER FOR CLICK            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
P00718*  12/05/2013 VV90387   INITIAL VERSION                          *        
A00520*  09/23/2014 VV90387   ADD COMM COMMENTS                        *        
A05020*  10/01/2014 VV90387   GET PREMISE APPLIANCE INFO FOR EMER ORDERS        
A05020*  10/13/2014 VV90387   INTERSECTION ADDRESS                     *        
A05020*  10/29/2014 VV90387   PERFORMANCE TUNING                       *        
A05020*  11/17/2014 VV90387   MULTI REGISTER CHECK                     *        
A05020*  12/15/2014 MSR       DO NOT SEND ORDER PRIORITY FOR ARRG.     *        
A05020*  01/06/2015 MSR       SEND CHARGES TO RECONNECT ORDERS.        *        
A05020*  02/10/2015 VV90387   SET PRINTED IND TO 'Y' FOR ACTIVE ORDERS *        
A05020*  03/12/2015 VV90387   MOVE INTERSECTION STREET NAMES TO STREET *        
A05020*                       NAME FOR INTERSECTION ADDRESS            *        
A05020*  11/09/2015 VV90387   INITIALIZE DBA NAME FOR PREMISE ONLY     *        
A05020*  11/13/2015 VV90387   FIX COMPLIANCE DATE                      *        
A05020*  01/05/2015 VV90387   FOR FW019 & FW016 NOT SEND METER STATS   *        
A05020*  04/07/2015 VV90387   ADDED CHANGES FOR MULTI REGITER METERS   *        
A05020*  04/25/2016 VV90387   FIX REGISTER READ DT FORMAT              *        
A05020*  05/05/2016 VV90387   CHANGE PHONE NO FORMAT                   *        
A05020*  05/18/2016 VV90387   SEND TASKS FOR PAYMENT REQUIRED          *        
A05020*  05/20/2016 VV90387   NEW TASK TYPES FOR SOLAR                 *        
A05020*  07/25/2016 VV90387   DEFAULT COMPLIANCE DATE FOR APPOINTMENTS *        
A05020*  09/15/2016 VV90387   SEND 999 FOR HI/LO% FOR UNB/UDP          *        
A05020*  09/17/2016 VV90387   SEND APPLIANCE DETAILS FOR A ORDERS      *        
A05020*  09/20/2016 VV90387   UPDATE OFFS TO USE ACCOUNT NO PRIOR      *        
A05020*  09/20/2016 VV90387   REPLACE REFERENCE TO CSS_ACCOUNT_TYPE    *        
P01176*  09/22/2016 VV90387   SEND SAMPLE TEST FLAG FOR CLICK          *        
A05020*  09/22/2016 VV90387   DO NOT SEND MADE SAFE DT                 *        
P01176*  09/22/2016 VV90387   ADD MCU TO HI/LO EDITS                   *        
A05020*  12/12/2016 VV90387   SEND ONLY APPLIANCES WITH CIS_DISPLAY_FL *        
A05020*  12/12/2016 VV90387   SEND HOT SPOT PREMISE FOR DNPS           *        
A05020*  01/30/2017 VV90387   FIX APPLIANCES                           *        
A05020*  02/13/2017 VV90387   ALLOW INITIAL CANCELS TO BE PROCESSED    *        
A05020*  02/16/2017 VV90387   COMMIT CHANGES                           *        
A05020*  02/21/2017 VV90387   METER PRESSURE CHANGES                   *        
A05020*  03/23/2017 VV90387   RESTRICT APPLIANCE COMMENTS TO 50        *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04584'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04584 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
                                                                        
            05  GTT-NAME-1             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R1'.           
            05  GTT-NAME-2             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R2'.           
            05  GTT-NAME-3             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R3'.           
            05  GTT-NAME-4             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R4'.           
            05  GTT-NAME-5             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R5'.           
            05  GTT-NAME-6             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R6'.           
            05  GTT-NAME-7             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R7'.           
            05  GTT-NAME-8             PIC X(26) VALUE                  
                                       'SESSION.CSR04584_R8'.           
       01 GTT-RETURN-FIELDS.                                            
                                                                        
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-SO-INST-SEQ-NO-1     PIC S9(9) COMP VALUE ZERO.       
             10 S-WORK-TYPE-CD-1       PIC X(03) VALUE SPACES.          
             10 S-WORK-TYPE-DESC-1     PIC X(25) VALUE SPACES.          
             10 S-CODE-UTIL-TYPE-1     PIC X(01) VALUE SPACES.          
             10 S-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.      
             10 S-ORDER-PRIORITY-CD    PIC S9(4) COMP VALUE 0.          
             10 S-SO-EST-LABOR-HR      PIC S9(6)V9 COMP-3 VALUE 0.      
             10 S-COMPANY-NO           PIC X(12) VALUE SPACES.          
             10 S-LOCAL-OFFICE         PIC X(22) VALUE SPACES.          
             10 S-ORDER-TYPE-CD        PIC X(15) VALUE SPACES.          
             10 S-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.      
             10 S-FULL-NAME            PIC X(76) VALUE SPACES.          
             10 S-STREET-ADDRESS       PIC X(80) VALUE SPACES.          
             10 S-HOUSE-NO             PIC X(15) VALUE SPACES.          
             10 S-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.          
             10 S-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.          
             10 S-STREET-NAME          PIC X(70) VALUE SPACES.          
             10 S-STREET-SUFFIX        PIC X(04) VALUE SPACES.          
             10 S-ADDR-SUFFIX          PIC X(02) VALUE SPACES.          
             10 S-STREET-LOCATION-1    PIC X(04) VALUE SPACES.          
             10 S-STREET-LOCATION-2    PIC X(11) VALUE SPACES.          
             10 S-ADDR-STREET          PIC X(55) VALUE SPACES.          
             10 S-ADDR-CITY-STATE      PIC X(30) VALUE SPACES.          
             10 S-STATE                PIC X(02) VALUE SPACES.          
             10 S-COUNTRY              PIC X(35) VALUE SPACES.          
             10 S-LATITUDE             PIC S9(9)V9(6) COMP-3 VALUE 0.   
             10 S-LONGITUDE            PIC S9(9)V9(6) COMP-3 VALUE 0.   
             10 S-LOT                  PIC X(05) VALUE SPACES.          
             10 S-BLOCK                PIC X(05) VALUE SPACES.          
             10 S-SUBDIVISION-DESC     PIC X(26) VALUE SPACES.          
A05020       10 S-SUBDIVISION-ID       PIC X(03) VALUE SPACES.          
             10 S-ZIP-CODE             PIC X(09) VALUE SPACES.          
A05020       10 S-ZIP-CODE-PLUS-FOUR   PIC X(04) VALUE SPACES.          
             10 S-TOWN                 PIC X(26) VALUE SPACES.          
             10 S-ORDER-PLACED-BY      PIC X(25) VALUE SPACES.          
             10 S-ORDER-REASON         PIC X(40) VALUE SPACES.          
             10 S-CALL-BEFORE-MINUTS   PIC X(03) VALUE SPACES.          
             10 S-PHONE-NO             PIC X(13) VALUE SPACES.          
             10 S-PHONE-NO-EXT         PIC X(06) VALUE SPACES.          
             10 S-SERV-ORDER-REMARKS   PIC X(210) VALUE SPACES.         
             10 S-SERV-ORDER-REMUPD    PIC X(210) VALUE SPACES.         
             10 S-SPCL-INSTRUCTIONS    PIC X(255) VALUE SPACES.         
             10 S-PREMISE              PIC S9(10)V COMP-3 VALUE 0.      
             10 S-PREMISE-DIRECTIONS   PIC X(255) VALUE SPACES.         
             10 S-CODE-ACCT-STAT       PIC X(15) VALUE SPACES.          
             10 S-XS-FLOW-VALVE-FL     PIC X(01) VALUE SPACES.          
             10 S-SPLIT-SERVICE-FL     PIC X(01) VALUE SPACES.          
             10 S-SERVICE-CHARGES      PIC S9(11)V9(2) COMP-3 VALUE 0.  
             10 S-COUNTY               PIC X(22) VALUE SPACES.          
             10 S-TOTAL-BTU            PIC S9(9) COMP VALUE 0.          
             10 S-ALT-PHONE-NO         PIC X(13) VALUE SPACES.          
             10 S-ALT-PHONE-NO-EXT     PIC X(06) VALUE SPACES.          
A05020*      10 S-MADE-SAFE-DT         PIC X(26) VALUE SPACES.                  
             10 S-HOME-ALL-DAY-FL      PIC X(80) VALUE SPACES.          
             10 S-BUSINESS-UNIT        PIC X(80) VALUE SPACES.          
             10 S-DNP-CRITICAL-CUS     PIC X(01) VALUE SPACES.          
             10 S-CIRCUIT-ID           PIC X(05) VALUE SPACES.          
             10 S-CUST-PHASE-CD        PIC X(01) VALUE SPACES.          
             10 S-GRID-CELL            PIC X(10) VALUE SPACES.          
             10 S-POLE-NO              PIC X(10) VALUE SPACES.          
             10 S-ASSIGNED-DATE        PIC X(26) VALUE SPACES.          
             10 S-COMPLIANCE-DAYS      PIC S9(9) COMP VALUE 0.          
             10 S-DUE-DAYS             PIC S9(9) COMP VALUE 0.          
             10 S-MATERIAL-FL          PIC X(01) VALUE SPACES.          
             10 S-WORK-START-TIME      PIC X(08) VALUE SPACES.          
             10 S-WORK-STOP-TIME       PIC X(08) VALUE SPACES.          
             10 S-WORK-DISTRICT        PIC X(40) VALUE SPACES.          
             10 S-OPTIMIZE-ORDER       PIC X(01) VALUE SPACES.          
             10 S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
             10 S-RED-FLAG-SAFETY      PIC X(01) VALUE SPACES.          
             10 S-RED-FLAG-MAINT       PIC X(01) VALUE SPACES.          
             10 S-RED-FLAG-STORM       PIC X(01) VALUE SPACES.          
             10 S-SO-SERVICE-CHRG      PIC X(01) VALUE SPACES.          
             10 S-GROUP-CODE           PIC X(01) VALUE SPACES.          
             10 S-RLSE-NO-1            PIC X(10) VALUE SPACES.          
             10 S-ORDER-CANCEL         PIC X(01) VALUE SPACES.          
             10 S-SO-COMPL-REMARKS     PIC X(210) VALUE SPACES.         
             10 S-DATE-RECVED          PIC X(26) VALUE SPACES.          
A00520       10 S-COMM-COMMENTS        PIC X(255) VALUE SPACES.         
A00520       10 S-DBA-NAME             PIC X(70) VALUE SPACES.          
A00520       10 S-COMPLIANCE-DATE      PIC X(26) VALUE SPACES.          
A00520       10 S-TASK-TYPE            PIC X(50) VALUE SPACES.          
A00520       10 S-APPT-FL              PIC X(01) VALUE SPACES.          
P01176       10 S-SAMPLE-TEST          PIC X(03) VALUE SPACES.          
A00520       10 S-HOT-SPOT-FL          PIC X(01) VALUE SPACES.          
                                                                        
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9) COMP VALUE 0.          
             10 S-SO-INST-SEQ-NO-2     PIC S9(9) COMP VALUE ZERO.       
             10 S-APPLIANCE-CD         PIC X(20) VALUE SPACES.          
             10 S-CODE-UTIL-TYPE-2     PIC X(01) VALUE SPACES.          
             10 S-LEAK-IND             PIC X(01) VALUE SPACES.          
             10 S-LIGHT-IND            PIC X(01) VALUE SPACES.          
             10 S-REPAIR-IND           PIC X(01) VALUE SPACES.          
             10 S-CUTOFF-IND           PIC X(01) VALUE SPACES.          
             10 S-CAUTION-TAG-IND      PIC X(01) VALUE SPACES.          
             10 S-CONDITION-CD         PIC X(50) VALUE SPACES.          
             10 S-REPLACE-APP-FL       PIC X(01) VALUE SPACES.          
             10 S-INSTALL-DT           PIC X(26) VALUE SPACES.          
             10 S-APPLIANCE-COMMENTS   PIC X(50) VALUE SPACES.          
             10 S-TAG-NO               PIC X(10) VALUE SPACES.          
             10 S-CAUTION-TAG-DT       PIC X(10) VALUE SPACES.          
             10 S-EQUIPMENT-UNQ        PIC X(20) VALUE SPACES.          
                                                                        
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9) COMP VALUE ZERO.       
             10 S-SO-INST-SEQ-NO-3     PIC S9(9) COMP VALUE ZERO.       
             10 S-REG-CHARGEABLE-HRS   PIC S9(9) COMP VALUE 0.          
             10 S-OT-CHARGEABLE-HRS    PIC S9(9) COMP VALUE 0.          
             10 S-CHARGES-COMMENTS     PIC X(35) VALUE SPACES.          
             10 S-WORK-PERIOD-CD       PIC X(09) VALUE SPACES.          
             10 S-WAIVER-TYPE-CD       PIC X(30) VALUE SPACES.          
             10 S-MATERIAL-CHRG        PIC S9(6)V99 COMP-3 VALUE 0.     
             10 S-CODE-UTIL-TYPE-3     PIC X(01) VALUE SPACES.          
                                                                        
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9) COMP VALUE ZERO.       
             10 S-SO-INST-SEQ-NO-4     PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-4     PIC X(01) VALUE SPACES.          
             10 S-WORK-TYPE-CD-4       PIC X(03) VALUE SPACES.          
             10 S-WORK-TYPE-DESC-4     PIC X(25) VALUE SPACES.          
             10 S-METER-NO-4           PIC X(09) VALUE SPACES.          
             10 S-IC-NO-4              PIC S9(9) COMP VALUE ZERO.       
             10 S-MTR-REF-NO-4         PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-DEST            PIC X(10) VALUE SPACES.          
             10 S-DEST-NO              PIC X(35) VALUE SPACES.          
             10 S-CODE-MTR-STATUS-WS   PIC X(80) VALUE SPACES.          
             10 S-READ-VALUE-IS-4      PIC S9(15)V999 COMP-3 VALUE 0.   
             10 S-METER-SUPPLYING      PIC X(15) VALUE SPACES.          
             10 S-READ-ROUTE           PIC S9(9) COMP VALUE ZERO.       
             10 S-READ-CYCLE           PIC X(02) VALUE SPACES.          
             10 S-SPCL-READ-INSTR      PIC X(114) VALUE SPACES.         
             10 S-CODE-TIME-PERIOD-4   PIC S9(9) COMP VALUE ZERO.       
             10 S-REG-ID-NO-4          PIC S9(9) COMP VALUE ZERO.       
             10 S-CONSTANT             PIC S9(9)V999 COMP-3 VALUE 0.    
             10 S-NO-DIALS-4           PIC S9(9) COMP VALUE ZERO.       
             10 S-METER-SIZE-ID        PIC X(08) VALUE SPACES.          
             10 S-CODE-METER-LOC       PIC X(14) VALUE SPACES.          
             10 S-METER-POINT-ID       PIC X(10) VALUE SPACES.          
             10 S-SUBSTATION-ID        PIC X(30) VALUE SPACES.          
             10 S-RATE-PLAN-NO         PIC X(03) VALUE SPACES.          
             10 S-CODE-REVENUE-CLASS   PIC X(03) VALUE SPACES.          
             10 S-LOCK-TYPE-ID         PIC X(09) VALUE SPACES.          
             10 S-CODE-MAKE            PIC X(16) VALUE SPACES.          
             10 S-AMPS                 PIC S9(9) COMP VALUE ZERO.       
             10 S-NO-WIRES             PIC X(01) VALUE SPACES.          
             10 S-VOLTAGE              PIC S9(9) COMP VALUE ZERO.       
             10 S-MTR-CONNECT-TYPE-ID  PIC X(10) VALUE SPACES.          
             10 S-CASE-PRESSURE        PIC X(15) VALUE SPACES.          
             10 S-RLSE-NO              PIC X(10) VALUE SPACES.          
             10 S-RLSE-DATE            PIC X(26) VALUE SPACES.          
             10 S-MAX-NO-UNITS-4       PIC S9(9)V COMP-3 VALUE 0.       
             10 S-MIN-NO-UNITS-4       PIC S9(9)V COMP-3 VALUE 0.       
             10 S-USAGE-HIGH-PCT-4     PIC S9(5)V99 COMP-3 VALUE 0.     
             10 S-USAGE-LOW-PCT-4      PIC S9(5)V99 COMP-3 VALUE 0.     
             10 S-LAST-MTR-READ-VALUE  PIC S9(15)V999 COMP-3 VALUE 0.   
             10 S-LAST-MTR-READ-DATE   PIC X(26) VALUE SPACES.          
             10 S-REMOTE-READ-IND      PIC X(20) VALUE SPACES.          
             10 S-MTR-ACCESSIBLE-CD    PIC X(15) VALUE SPACES.          
             10 S-MTR-ACCESSIBLE-DT    PIC X(10) VALUE SPACES.          
             10 S-MTR-ACCESSIBLE-RSN   PIC X(15) VALUE SPACES.          
             10 S-CODE-STATUS-REASON-4 PIC X(80) VALUE SPACES.          
             10 S-NUMBER-OF-DRIVE      PIC S9(9) COMP VALUE ZERO.       
             10 S-ELEC-MTR-FORM-CD     PIC X(04) VALUE SPACES.          
             10 S-READ-SEQUENCE-NO-4   PIC S9(9) COMP VALUE ZERO.       
             10 S-MTR-RD-DISP-CD-4     PIC X(80) VALUE SPACES.          
             10 S-INDEX-VALUE-CD-4     PIC X(80) VALUE SPACES.          
             10 S-NO-READ-DIGITS-4     PIC S9(4) COMP VALUE ZEROES.     
             10 S-NO-READ-DECIMALS-4   PIC S9(4) COMP VALUE ZEROES.     
                                                                        
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5        PIC S9(9) COMP VALUE ZERO.       
             10 S-SO-INST-SEQ-NO-5     PIC S9(9) COMP VALUE ZERO.       
             10 S-REG-ID-NO-5          PIC S9(9) COMP VALUE ZERO.       
             10 S-METER-NO-5           PIC X(09) VALUE SPACES.          
             10 S-IC-NO-5              PIC S9(9) COMP VALUE ZERO.       
             10 S-MTR-REF-NO-5         PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-5     PIC X(01) VALUE SPACES.          
             10 S-READ-SEQUENCE-NO     PIC S9(9) COMP VALUE ZERO.       
             10 S-READ-VALUE-IS-5      PIC S9(15)V999 COMP-3 VALUE 0.   
             10 S-MTR-RD-DISP-CD       PIC X(80) VALUE SPACES.          
             10 S-CODE-TIME-PERIOD-5   PIC S9(9) COMP VALUE ZERO.       
             10 S-INDEX-VALUE-CD       PIC X(80) VALUE SPACES.          
             10 S-CODE-STATUS-REASON-5 PIC X(80) VALUE SPACES.          
             10 S-MAX-NO-UNITS-5       PIC S9(9)V COMP-3 VALUE 0.       
             10 S-MIN-NO-UNITS-5       PIC S9(9)V COMP-3 VALUE 0.       
             10 S-USAGE-HIGH-PCT-5     PIC S9(5)V99 COMP-3 VALUE 0.     
             10 S-USAGE-LOW-PCT-5      PIC S9(5)V99 COMP-3 VALUE 0.     
             10 S-LAST-REG-READ-VALUE  PIC S9(15)V999 COMP-3 VALUE 0.   
             10 S-NO-DIALS-5           PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-REG-STATUS-WS   PIC X(80) VALUE SPACES.          
A05020       10 S-LAST-REG-READ-DT     PIC X(26) VALUE SPACES.          
A05020       10 S-NO-READ-DIGITS       PIC S9(4) COMP VALUE ZEROES.     
A05020       10 S-NO-READ-DECIMALS     PIC S9(4) COMP VALUE ZEROES.     
                                                                        
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6        PIC S9(9) COMP VALUE ZERO.       
             10 S-SO-INST-SEQ-NO-6     PIC S9(9) COMP VALUE ZERO.       
             10 S-REG-ID-NO-6          PIC S9(9) COMP VALUE ZERO.       
             10 S-METER-NO-6           PIC X(09) VALUE SPACES.          
             10 S-IC-NO-6              PIC S9(9) COMP VALUE ZERO.       
             10 S-MTR-REF-NO-6         PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-6     PIC X(01) VALUE SPACES.          
             10 S-DEVICE-NO            PIC X(12) VALUE SPACES.          
             10 S-CODE-ATT-TYPE        PIC X(08) VALUE SPACES.          
             10 S-CODE-STATUS-REASON-6 PIC X(80) VALUE SPACES.          
             10 S-READ-VALUE-IS-6      PIC S9(15)V999 COMP-3 VALUE 0.   
                                                                        
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7        PIC S9(9) COMP VALUE ZERO.       
             10 S-ACCT-TYPE            PIC X(25) VALUE SPACES.          
             10 S-DNP-COUNTER          PIC S9(4) COMP VALUE 0.          
             10 S-DNP-AMNT             PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-RETURN-CKS       PIC S9(4) COMP VALUE 0.          
             10 S-DNP-CUS-TURN-DATE    PIC X(10) VALUE SPACES.          
             10 S-DNP-CREDIT-GROUP     PIC X(01) VALUE SPACES.          
             10 S-DNP-CASH             PIC X(01) VALUE SPACES.          
             10 S-DNP-LAST-PAY-AMNT    PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-LAST-PAY-DATE    PIC X(26) VALUE SPACES.          
             10 S-DNP-2ND-NOTICE-DATE  PIC X(10) VALUE SPACES.          
             10 S-DNP-DEPOSIT-AMNT     PIC S9(10)V9(2) COMP-3 VALUE +0. 
             10 S-DNP-ARREARS-AMNT     PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-TOTAL-AMNT       PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-PAST-DUE-AMNT    PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-INDICATOR        PIC X(01) VALUE SPACES.          
             10 S-DNP-ARREARS-HISTORY  PIC X(24) VALUE SPACES.          
             10 S-DNP-CREDIT-HISTORY   PIC X(24) VALUE SPACES.          
             10 S-DNP-EXCEPT-HISTORY   PIC X(24) VALUE SPACES.          
             10 S-DNP-30-ARREARS       PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-60-ARREARS       PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-90-ARREARS       PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-UTILITY-AMNT     PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-NON-UTILITY-AMNT PIC S9(9)V9(2) COMP-3 VALUE +0.  
             10 S-DNP-BANKRUPT         PIC X(01) VALUE SPACES.          
             10 S-DNP-KEY-CUS          PIC X(01) VALUE SPACES.          
             10 S-DNP-CRITICAL-CUS-7   PIC X(01) VALUE SPACES.          
             10 S-REASON-CD            PIC X(80) VALUE SPACES.          
                                                                        
          05 GTT-RETURN-FIELDS-8.                                       
             10 S-RETURN-CODE-8        PIC S9(9) COMP VALUE ZERO.       
             10 S-CASE-NO              PIC S9(9) COMP VALUE ZERO.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-SINGLE-FORM-CODES.                                        
           05 FILLER PIC X(04) VALUE '1S'.                              
           05 FILLER PIC X(04) VALUE '2S'.                              
           05 FILLER PIC X(04) VALUE '12S'.                             
                                                                        
       01  WS-SINGLE-FORM-CODE-RED REDEFINES WS-SINGLE-FORM-CODES.      
           05  WS-SINGLE-FORM-CODE-TBL OCCURS 03 TIMES                  
                                       INDEXED BY WS-TBL-INDX.          
               10 WS-SINGLE-FORM-CODE         PIC X(04).                
                                                                        
       01  WS-BOLTED-FORM-CODES.                                        
           05 FILLER PIC X(04) VALUE '2K'.                              
           05 FILLER PIC X(04) VALUE '4K'.                              
           05 FILLER PIC X(04) VALUE '9K'.                              
           05 FILLER PIC X(04) VALUE '12K'.                             
                                                                        
       01  WS-BOLTED-FORM-CODE-RED REDEFINES WS-BOLTED-FORM-CODES.      
           05  WS-BOLTED-FORM-CODE-TBL OCCURS 04 TIMES                  
                                       INDEXED BY WS-TBL-INDX1.         
               10 WS-BOLTED-FORM-CODE  PIC X(04).                       
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04584'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-SERV-ORDER-NO         PIC X(13) VALUE SPACES.          
          05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO       
                                       PIC 9(13).                       
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-ACCOUNT               PIC S9(13)V COMP-3 VALUE 0.      
          05  WS-MTR-ACCESSIBLE-CD     PIC X(02) VALUE SPACES.          
          05  WS-MTR-ACCESSIBLE-RSN    PIC X(02) VALUE SPACES.          
          05  WS-MTR-ACCESSIBLE-DT     PIC X(10) VALUE SPACES.          
          05  WS-MTR-PRESSURE          PIC 9(03) VALUE ZEROS.           
          05  WS-METER-PRESSURE        REDEFINES WS-MTR-PRESSURE        
                                       PIC X(03).                       
          05  WS-CUST-NAME             PIC X(76) VALUE SPACES.          
COB305    05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
          05  WS-DPP                   PIC X(01) VALUE SPACES.          
          05  WS-TASK-DATA             PIC X(01) VALUE 'N'.             
          05  WS-TASK-CANCEL           PIC X(01) VALUE 'N'.             
          05  WS-COMPANY-NO            PIC X(02).                       
A05020    05  WS-STREET-ADDRESS-I      PIC X(80) VALUE SPACES.          
A05020    05  WS-STREET-NAMES-I        PIC X(70) VALUE SPACES.          
          05  WS-ORDER-TYPE            PIC X(02).                       
          05  WS-DAY-OF-WEEK           PIC X(01) VALUE SPACES.          
          05  WS-HOLIDAY               PIC X(01) VALUE 'N'.             
A05020    05  WS-MULTI-REGISTER        PIC X(01) VALUE 'N'.             
A05020    05  WS-PRINT                 PIC X(01) VALUE 'N'.             
A05020    05  WS-PRINT-INSERTED        PIC X(01) VALUE 'N'.             
A05020    05  WS-PRINT-IND             PIC X(01) VALUE ' '.             
A05020    05  WS-CLICK-CANCEL          PIC X(01) VALUE ' '.             
A05020    05  WS-WEEKEND               PIC X(01) VALUE 'N'.             
A05020    05  WS-AFTER-HOURS           PIC X(01) VALUE 'N'.             
A05020    05  WS-CURRENT-TIME          PIC S9(4) USAGE COMP.            
A05020    05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
A05020    05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.          
A05020    05  WS-WT-APPL               PIC X(01) VALUE SPACES.          
A05020    05  WS-PHONE-NO.                                              
A05020        10 WS-FILLER             PIC X(01) VALUE '('.             
A05020        10 WS-AREA-CD            PIC X(03) VALUE SPACES.          
A05020        10 WS-FILLER             PIC X(01) VALUE ')'.             
A05020        10 WS-NO1                PIC X(03) VALUE SPACES.          
A05020        10 WS-FILLER             PIC X(01) VALUE '-'.             
A05020        10 WS-NO2                PIC X(04) VALUE SPACES.          
A05020    05  WS-ALT-PHONE-NO.                                          
A05020        10 WS-FILLER             PIC X(01) VALUE '('.             
A05020        10 WS-ALT-AREA-CD        PIC X(03) VALUE SPACES.          
A05020        10 WS-FILLER             PIC X(01) VALUE ')'.             
A05020        10 WS-ALT-NO1            PIC X(03) VALUE SPACES.          
A05020        10 WS-FILLER             PIC X(01) VALUE '-'.             
A05020        10 WS-ALT-NO2            PIC X(04) VALUE SPACES.          
A05020    05  WS-LAST-REG-READ-DT.                                      
A05020        10  WS-LAST-REG-READ-DATE PIC X(10) VALUE SPACES.         
A05020        10  WS-FILLER             PIC X(01) VALUE '-'.            
A05020        10  WS-LAST-REG-READ-TM   PIC X(08) VALUE SPACES.         
A05020        10  WS-FILLER             PIC X(07) VALUE '.000000'.      
A05020    05  WS-COMPLIANCE-TS.                                         
A05020        10  WS-COMP-DT           PIC X(10) VALUE SPACES.          
A05020        10  WS-TS      PIC X(16) VALUE '-11.59.00.000000'.        
A05020    05  WS-BILL-TS.                                               
A05020        10  WS-BILL-DT           PIC X(10) VALUE SPACES.          
A05020        10  WS-TS      PIC X(16) VALUE '-11.59.00.000000'.        
A05020    05  WS-DATE-CCYY-MM-DD.                                       
A05020        10  WS-DATE-CCYY         PIC X(04) VALUE SPACES.          
A05020        10  FILLER               PIC X(01) VALUE SPACES.          
A05020        10  WS-DATE-MM           PIC X(02) VALUE SPACES.          
A05020        10  FILLER               PIC X(01) VALUE SPACES.          
A05020        10  WS-DATE-DD           PIC X(02) VALUE SPACES.          
A05020    05  WS-DATE-MM-DD-YYYY.                                       
A05020        10  WS-DATE2-MM          PIC X(02) VALUE SPACES.          
A05020        10  FILLER               PIC X(01) VALUE '/'.             
A05020        10  WS-DATE2-DD          PIC X(02) VALUE SPACES.          
A05020        10  FILLER               PIC X(01) VALUE '/'.             
A05020        10  WS-DATE2-CCYY        PIC X(04) VALUE SPACES.          
A05020    05  WS-NEXT-BILL-DATE        PIC X(10) VALUE SPACES.          
          05  WS-ASSIGN-DATE           PIC X(10) VALUE SPACES.          
          05  WS-ELECTRIC              PIC X(01) VALUE 'E'.             
          05  WS-GAS                   PIC X(01) VALUE 'G'.             
          05  WS-UNMTR                 PIC X(01) VALUE 'U'.             
          05  WS-A                     PIC X(01) VALUE 'A'.             
          05  WS-SCEG                  PIC X(02) VALUE '01'.            
          05  WS-PSNC                  PIC X(02) VALUE '26'.            
          05  WS-SEB                   PIC X(12) VALUE 'SCANA ENERGY'.  
          05  WS-01                    PIC X(04) VALUE 'SCEG'.          
          05  WS-26                    PIC X(04) VALUE 'PSNC'.          
          05  WS-YES                   PIC X(01) VALUE 'Y'.             
          05  WS-NO                    PIC X(01) VALUE 'N'.             
          05  WS-ORDER-CHK             PIC X(01) VALUE 'N'.             
          05  WS-SOMETER-CHK           PIC X(01) VALUE 'N'.             
          05  WS-CANCEL                PIC X(01) VALUE 'C'.             
          05  WS-SERVICE-CHARGES       PIC S9(11)V9(2) COMP-3 VALUE 0.  
          05  WS-BEGIN-APPT-TIME       PIC X(08) VALUE SPACES.          
          05  WS-END-APPT-TIME         PIC X(08) VALUE SPACES.          
          05  WS-BEGIN-TIME            PIC X(08) VALUE '08.00.00'.      
          05  WS-END-TIME              PIC X(08) VALUE '17.00.00'.      
          05  WS-APPL-CHK              PIC X(01) VALUE 'Y'.             
          05  WS-GAS-FOUND             PIC X(01) VALUE 'N'.             
          05  WS-MTR-FOUND             PIC X(01) VALUE 'Y'.             
          05  WS-TASK-FND              PIC X(01) VALUE 'N'.             
          05  WS-SOLAR-TASK            PIC X(01) VALUE 'N'.             
          05  WS-COMP-DAYS             PIC S9(9) COMP VALUE ZERO.       
          05  WS-COMPANY               PIC X(02) VALUE SPACES.          
          05  WS-SPCL-READ-INSTR       PIC X(114) VALUE SPACES.         
          05  WS-REMARK-TYPE           PIC X(01) VALUE SPACES.          
          05  WS-SO-REMARKS            PIC X(01) VALUE 'G'.             
          05  WS-SO-CHANGELOG          PIC X(01) VALUE 'E'.             
          05  WS-SO-COMPLETION         PIC X(01) VALUE 'A'.             
          05  WS-SAMPLE-TEST           PIC X(01) VALUE ' '.             
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT06-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT07-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT08-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-IC-NO-NUM             PIC 9(04).                       
          05  WS-IC-NO-CHAR            REDEFINES WS-IC-NO-NUM           
                                       PIC X(04).                       
          05  WS-MTR-REF-NO-NUM        PIC 9(04).                       
          05  WS-MTR-REF-NO-CHAR       REDEFINES WS-MTR-REF-NO-NUM      
                                       PIC X(04).                       
          05  WS-PREV-MNTH             PIC S9(4) COMP VALUE 0.          
          05  WS-EXCEPTIONAL-HIST      PIC X(24).                       
          05  WS-EXCEPTIONAL-HIST-BRKDWN  REDEFINES                     
                 WS-EXCEPTIONAL-HIST   PIC X(1) OCCURS 24.              
          05  WS-DISC-HIST             PIC X(24).                       
          05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISC-HIST                
                                       PIC X(1) OCCURS 24.              
          05  WS-ONE-YEAR-AGO         PIC X(10) VALUE SPACES.           
          05  WS-C                    PIC X(1)  VALUE 'C'.              
          05  WS-FOUR                 PIC X(1)  VALUE '4'.              
          05  WS-RET-CHK-CNT-NO       PIC S9(4) COMP VALUE 0.           
          05  WS-RET-CHK-CNT          PIC X(04) VALUE SPACES.           
          05  WS-GAS-INST-NO          PIC S9(4) COMP VALUE 0.           
          05  WS-ELEC-INST-NO         PIC S9(4) COMP VALUE 0.           
          05  WS-GAS-INST-FND         PIC X(01) VALUE 'N'.              
          05  WS-ELEC-INST-FND        PIC X(01) VALUE 'N'.              
          05  WS-LOAD-VALUES          PIC X(01) VALUE 'N'.              
          05  WS-LOAD-CHARGE          PIC X(01) VALUE 'N'.              
          05  WS-DATABASE             PIC 9(01) VALUE ZERO.             
              88  CSR-DATABASE                  VALUE 1.                
              88  SEB-DATABASE                  VALUE 2.                
                                                                        
       01 CSR04753-RETURN-DATA.                                         
          03  RETURN-CODE-4753         PIC S9(9) COMP VALUE 0.          
          03  ORDER-REASON-CD-4753     PIC X(02) VALUE SPACES.          
          03  ORDER-REASON-DESC-4753   PIC X(40) VALUE SPACES.          
          03  ORDER-TYPE-CD-4753       PIC X(05) VALUE SPACES.          
                                                                        
       01 WS-TABLES.                                                    
          05 T1-CSR04753   OCCURS 75 INDEXED BY T1-INDEX.               
             10 T1-RETURN-CODE         PIC S9(9) COMP VALUE 0.          
             10 T1-ORDER-REASON-CD     PIC X(02) VALUE SPACES.          
             10 T1-ORDER-REASON-DESC   PIC X(40) VALUE SPACES.          
             10 T1-ORDER-TYPE-CD       PIC X(05) VALUE SPACES.          
                                                                        
       01 CSR01136-CALL-DATA.                                           
          03  SERV-ORDER-NO-1136       PIC X(13) VALUE SPACES.          
          03  HISTORY-FLAG-1136        PIC X(01) VALUE SPACES.          
                                                                        
       01 CSR01136-RETURN-DATA.                                         
          03  TOTAL-CHARGES-AM-1136    PIC S9(11)V9(2) COMP-3 VALUE 0.  
          03  WORK-COMPLETED-1136      PIC X(01) VALUE SPACES.          
          03  CATHODIC-PROTECT-1136    PIC X(03) VALUE SPACES.          
          03  FIXED-LABOR-CHRG-1136    PIC S9(11)V9(2) COMP-3 VALUE 0.  
                                                                        
       01 WS-NULL-IND-VARIABLES.                                        
          05  WS-NULL-01               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-02               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-03               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-04               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-05               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-06               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-07               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-08               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-09               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-10               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-11               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-12               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-13               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-14               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-15               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-16               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-17               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-18               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-19               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-20               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-21               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-22               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-23               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-24               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-25               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-26               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-27               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-28               PIC S9(4) COMP VALUE +0.         
          05  WS-NULL-29               PIC S9(4) COMP VALUE +0.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_ORDER_INST  (PREFIX = VI)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ORDER_TYPE     (PREFIX = C2)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ORDER_WK_TYPE  (PREFIX = L3)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBORWT                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREMISE        (PREFIX = PR)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SUBDIVISION    (PREFIX = B0)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MTRD_ENVRNMT   (PREFIX = MN)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT        (PREFIX = AT)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CUSTOMER       (PREFIX = CU)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DNP            (PREFIX = DN)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDNP                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_NAME           (PREFIX = DQ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_REMARKS     (PREFIX = EF)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ADDR_FORMATTED (PREFIX = DY)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ADDR_FREEFORM  (PREFIX = DZ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ZIP_CODE        (PREFIX = A4)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_DATA        (PREFIX = VO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_METER       (PREFIX = VM)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOMTR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_UTILITY     (PREFIX = VT)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOUTL                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_UTL_CHG     (PREFIX = VE)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_MTR_CHG     (PREFIX = VC)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOMCG                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_REG_CHG     (PREFIX = VK)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSORCG                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_REGISTER    (PREFIX = WK)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOREG                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_MTR_ATT_CHG (PREFIX = ON)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOMAC                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_APPLIANCE   (PREFIX = VQ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_APPLIANCE      (PREFIX = LA)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MSE_APPLIANCE  (PREFIX = MO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMSAPPL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_CHARGES     (PREFIX = VG)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_SERVICE_CHG (PREFIX = SV)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSRVCHG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PIM_POINT      (PREFIX = PP)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GASLINE_SO_XRF (PREFIX = XX)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGASSO                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GAS_SERV_LINE  (PREFIX = XO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_PREM_GAS_LINE  (PREFIX = YO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_TASK_QUEUE  (PREFIX = TQ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBTSKQUE                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MTR_RD_FMT     (PREFIX = OA)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRDFMT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ELEC_METER     (PREFIX = EM)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ELEC_CL_SPEC   (PREFIX = U0)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBELCLSP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GAS_METER      (PREFIX = GM)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_REGISTER_READ  (PREFIX = RG)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_EQUIPMENT      (PREFIX = EQ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_RATE_HIGH_LOW  (PREFIX = 09)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTHGLW                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_AR_TRANS_HIST  (PREFIX = AR)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_AR_CNTL        (PREFIX = AC)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CRED_COLL      (PREFIX = CL)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CRIT_OUTAGE    (PREFIX = Q2)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCRITOG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CUST_MISC_INFO (PREFIX = LQ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CREDIT_PROFILE (PREFIX = CZ)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_NSF_HIST       (PREFIX = NH)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DEP_ON_HAND    (PREFIX = DO)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_GUARANTOR      (PREFIX = GU)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SURETY_BOND    (PREFIX = AI)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_CODE_DESC   (PREFIX = SW)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOCODE                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MKT_APPLIANCE  (PREFIX = JA)                              *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_APPLIANCE_COND  (PREFIX = A7)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBAPLCON                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_SO_WAIVER       (PREFIX = SU)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOWAIV                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_METER_LOC       (PREFIX = Q4)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_LOCK_TYPE       (PREFIX = B3)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBLCKTYP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_WORK_TYPE       (PREFIX = L4)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_LOCAL_OFFICE    (PREFIX = B1)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_MTR_ATT_TYPE    (PREFIX = N5)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_CODE_VALUE      (PREFIX = UV)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY     (PREFIX = C8)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_COMM_DATA       (PREFIX = KO)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
A05020*****************************************************************         
A05020* CSS_BILL_WINDOW     (PREFIX = BN)                             *         
A05020*****************************************************************         
A05020     EXEC SQL                                                             
A05020        INCLUDE TBBILWDW                                                  
A05020     END-EXEC.                                                            
A05020                                                                  
A05020*****************************************************************         
A05020* CSS_FM_ORD_TASK_TP  (PREFIX = TY)                             *         
A05020*****************************************************************         
A05020     EXEC SQL                                                             
A05020        INCLUDE TBFMORTK                                                  
A05020     END-EXEC.                                                            
A05020                                                                  
A05020*****************************************************************         
A05020* CSS_SO_PRINT_LOC    (PREFIX = C4)                             *         
A05020*****************************************************************         
A05020     EXEC SQL                                                             
A05020        INCLUDE TBSOLOC                                                   
A05020     END-EXEC.                                                            
A05020                                                                  
A05020*****************************************************************         
A05020* CSS_SO_PRINT_QUEUE  (PREFIX = VP)                             *         
A05020*****************************************************************         
A05020     EXEC SQL                                                             
A05020        INCLUDE TBSOPRT                                                   
A05020     END-EXEC.                                                            
A05020*****************************************************************         
A05020* CSS_WKAREA_PRMSSN   (PREFIX = I4)                             *         
A05020*****************************************************************         
A05020     EXEC SQL                                                             
A05020        INCLUDE TBWKARPR                                                  
A05020     END-EXEC.                                                            
      *****************************************************************         
      * CSS_SO_UPDATE       (PREFIX = VW)                             *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
A05020     EXEC SQL                                                             
A05020        INCLUDE CWS00309                                                  
A05020     END-EXEC.                                                            
                                                                        
A05020     EXEC SQL                                                             
A05020        INCLUDE CWS00322                                                  
A05020     END-EXEC.                                                            
                                                                        
           COPY CWS0068L.                                                       
                                                                        
      *01 LOC1136  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4753  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL TASKS                                 *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE TASKS-CURSOR CURSOR FOR                           
               SELECT VO.SERV_ORDER_NO,                                 
                      SO_INST_SEQ_NO,                                   
                      VI.WORK_TYPE_CD,                                  
                      L4.WORK_TYPE_DESC,                                
                      CODE_UTIL_TYPE,                                   
                      ORDER_PRIORITY_CD,                                
                      SO_EST_LABOR_HR,                                  
                      VO.PREMISE_NO,                                    
                      VO.COMPANY_NO,                                    
                      LOCAL_OFFICE_DESC,                                
                      ORDER_TYPE_CD,                                    
                      VO.ACCOUNT_NO,                                    
                      VO.ACCOUNT_NO_PRIOR,                              
                      ORDER_PLACED_BY,                                  
                      ORDER_REASON,                                     
                      CALL_BEFORE_MINUTS,                               
                      VO.PHONE_NO,                                      
                      VO.PHONE_NO_EXT,                                  
                      ALT_PHONE_NO,                                     
                      ALT_PHONE_NO_EXT,                                 
A05020*               MADE_SAFE_DT,                                             
                      HOME_ALL_DAY_FL,                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           DATE_FORECAST_DNP, 121), ' ', '-'), ':', '.') 
           DATE_FORECAST_DNP,                                
                      MTR_ACCESSIBLE_CD,                                
                      MTR_ACCESSIBLE_DT,                                
                      MTR_ACCESSIBLE_RSN,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      SO_BUSINESS_UNIT,                                 
                      WORK_AREA_ID,                                     
                      CIS.DAYOFWEEK(ASSIGNED_DATETIME),                     
                      CAST(ASSIGNED_DATETIME AS DATE),                          
                      VI.IC_NO,                                         
                      VI.MTR_REF_NO,                                    
                      REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(VO.BEGIN_APPT_DT AS TIME)), 
           CAST(VO.BEGIN_APPT_DT AS TIME)), 108), ':', '.'),                   
                      REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(VO.END_APPT_DT AS TIME)), CAST(
           VO.END_APPT_DT AS TIME)), 108), ':', '.'),                          
                      VO.OPTIMIZE_ORDER_FL,                             
                      VO.ORDER_STATE_CD,                                
                      VI.RLSE_NO,                                       
                      VI.TASK_STATUS_CD,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED,                           
A05020                VO.LOCAL_OFFICE,                                  
A05020                VO.APPT_AM_PM_CD,                                 
A05020                VI.METER_NO,                                      
A05020                LTRIM(RTRIM(VI.METER_SUPPLYING)),                         
A05020                REPLACE(REPLACE(CONVERT(CHAR(26), VO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT,                         
P01176                VI.SAMPLE_TEST_FL                                 
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED),                
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)                    
                WHERE VI.SERV_ORDER_NO     = VO.SERV_ORDER_NO           
                  AND VI.SERV_ORDER_NO     = :VI-SERV-ORDER-NO          
                  AND VI.WORK_TYPE_CD      > ' '                        
                  AND VI.WORK_TYPE_CD      <> 'FIN'                     
                  AND VI.TASK_STATUS_CD    <> 'Z'                       
A05020*           AND ((VI.HOLD_RELEASE    <> 'Y')                              
A05020*            OR (VI.HOLD_RELEASE     = 'Y' AND                            
A05020*                VI.RLSE_NO          > ''))                               
                  AND VO.COMPANY_NO        = B1.COMPANY_NO              
                  AND VO.LOCAL_OFFICE      = B1.LOCAL_OFFICE            
                  AND VO.COMPANY_NO        = L4.COMPANY_NO              
                  AND VI.WORK_TYPE_CD      = L4.WORK_TYPE_CD            
                ORDER BY VI.SO_INST_SEQ_NO                              
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TASKS-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               L4.WORK_TYPE_DESC,                                        
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               ORDER_PRIORITY_CD,                                        
MFA-TR*               SO_EST_LABOR_HR,                                          
MFA-TR*               VO.PREMISE_NO,                                            
MFA-TR*               VO.COMPANY_NO,                                            
MFA-TR*               LOCAL_OFFICE_DESC,                                        
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               VO.ACCOUNT_NO,                                            
MFA-TR*               VO.ACCOUNT_NO_PRIOR,                                      
MFA-TR*               ORDER_PLACED_BY,                                          
MFA-TR*               ORDER_REASON,                                             
MFA-TR*               CALL_BEFORE_MINUTS,                                       
MFA-TR*               VO.PHONE_NO,                                              
MFA-TR*               VO.PHONE_NO_EXT,                                          
MFA-TR*               ALT_PHONE_NO,                                             
MFA-TR*               ALT_PHONE_NO_EXT,                                         
MFA-TR*               MADE_SAFE_DT,                                             
MFA-TR*               HOME_ALL_DAY_FL,                                          
MFA-TR*               DATE_FORECAST_DNP,                                        
MFA-TR*               MTR_ACCESSIBLE_CD,                                        
MFA-TR*               MTR_ACCESSIBLE_DT,                                        
MFA-TR*               MTR_ACCESSIBLE_RSN,                                       
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               SO_BUSINESS_UNIT,                                         
MFA-TR*               WORK_AREA_ID,                                             
MFA-TR*               DAYOFWEEK(ASSIGNED_DATETIME),                             
MFA-TR*               DATE(ASSIGNED_DATETIME),                                  
MFA-TR*               VI.IC_NO,                                                 
MFA-TR*               VI.MTR_REF_NO,                                            
MFA-TR*               TIME(VO.BEGIN_APPT_DT),                                   
MFA-TR*               TIME(VO.END_APPT_DT),                                     
MFA-TR*               VO.OPTIMIZE_ORDER_FL,                                     
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VI.RLSE_NO,                                               
MFA-TR*               VI.TASK_STATUS_CD,                                        
MFA-TR*               VO.DATE_RECVED,                                           
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               VO.APPT_AM_PM_CD,                                         
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               TRIM(VI.METER_SUPPLYING),                                 
MFA-TR*               VO.BEGIN_APPT_DT,                                         
MFA-TR*               VI.SAMPLE_TEST_FL                                         
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1,                                      
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VI.SERV_ORDER_NO     = VO.SERV_ORDER_NO                   
MFA-TR*           AND VI.SERV_ORDER_NO     = :VI-SERV-ORDER-NO                  
MFA-TR*           AND VI.WORK_TYPE_CD      > ' '                                
MFA-TR*           AND VI.WORK_TYPE_CD      <> 'FIN'                             
MFA-TR*           AND VI.TASK_STATUS_CD    <> 'Z'                               
MFA-TR*           AND ((VI.HOLD_RELEASE    <> 'Y')                              
MFA-TR*            OR (VI.HOLD_RELEASE     = 'Y' AND                            
MFA-TR*                VI.RLSE_NO          > ''))                               
MFA-TR*           AND VO.COMPANY_NO        = B1.COMPANY_NO                      
MFA-TR*           AND VO.LOCAL_OFFICE      = B1.LOCAL_OFFICE                    
MFA-TR*           AND VO.COMPANY_NO        = L4.COMPANY_NO                      
MFA-TR*           AND VI.WORK_TYPE_CD      = L4.WORK_TYPE_CD                    
MFA-TR*         ORDER BY VI.SO_INST_SEQ_NO                                      
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL APPLIANCES                            *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE APPL-CURSOR CURSOR FOR                            
               SELECT VQ.APPLIANCE_CD,                                  
                      CODE_UTIL_TYPE,                                   
                      LEAK_IND,                                         
                      LIGHT_IND,                                        
                      REPAIR_IND,                                       
                      CUTOFF_IND,                                       
                      CAUTION_TAG_IND,                                  
                      REPLACE_APP_FL,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), INSTALL_DT
           , 121), ' ', '-'), ':', '.') INSTALL_DT,                            
                      EQUIPMENT_UNQ                                     
                 FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED),                
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE VQ.SERV_ORDER_NO   = :VI-SERV-ORDER-NO            
                  AND VQ.SERV_ORDER_NO   = VO.SERV_ORDER_NO             
                  AND VQ.APPLIANCE_CD    = JA.APPLIANCE_CD              
                  AND JA.COMPANY_NO      = VO.COMPANY_NO                
                  AND JA.DATE_TO        >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                  AND JA.CIS_DISPLAY_FL  = 'Y'                          
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APPL-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT VQ.APPLIANCE_CD,                                          
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               LEAK_IND,                                                 
MFA-TR*               LIGHT_IND,                                                
MFA-TR*               REPAIR_IND,                                               
MFA-TR*               CUTOFF_IND,                                               
MFA-TR*               CAUTION_TAG_IND,                                          
MFA-TR*               REPLACE_APP_FL,                                           
MFA-TR*               INSTALL_DT,                                               
MFA-TR*               EQUIPMENT_UNQ                                             
MFA-TR*          FROM CSS_SO_APPLIANCE VQ,                                      
MFA-TR*               CSS_MKT_APPLIANCE JA,                                     
MFA-TR*               CSS_SO_DATA VO                                            
MFA-TR*         WHERE VQ.SERV_ORDER_NO   = :VI-SERV-ORDER-NO                    
MFA-TR*           AND VQ.SERV_ORDER_NO   = VO.SERV_ORDER_NO                     
MFA-TR*           AND VQ.APPLIANCE_CD    = JA.APPLIANCE_CD                      
MFA-TR*           AND JA.COMPANY_NO      = VO.COMPANY_NO                        
MFA-TR*           AND JA.DATE_TO        >= CURRENT DATE                         
MFA-TR*           AND JA.CIS_DISPLAY_FL  = 'Y'                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
A05020                                                                  
A05020*****************************************************************         
A05020* CURSOR FOR FETCHING ALL APPLIANCES                            *         
A05020*****************************************************************         
A05020     EXEC SQL                                                     
A05020        DECLARE EMER-APPL-CURSOR CURSOR FOR                       
A05020         SELECT LA.APPLIANCE_CD,                                  
A05020                CAUTION_TAG_IND,                                  
A05020                CAUTION_TAG_DT,                                   
A05020                INSTALL_DT,                                       
A05020                EQUIPMENT_NO,                                     
A05020                TAG_NO,                                           
A05020                CONDITION_CD,                                     
A05020                APPLIANCE_COMMENTS                                
A05020           FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
A05020          WHERE PREMISE_NO         = :VO-PREMISE-NO               
                  AND LA.COMPANY_NO      = JA.COMPANY_NO                
                  AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD              
                  AND JA.DATE_TO        >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                  AND JA.CIS_DISPLAY_FL  = 'Y'                          
A05020            FOR READ ONLY                                        
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE EMER-APPL-CURSOR CURSOR FOR                               
MFA-TR*        SELECT LA.APPLIANCE_CD,                                          
MFA-TR*               CAUTION_TAG_IND,                                          
MFA-TR*               CAUTION_TAG_DT,                                           
MFA-TR*               INSTALL_DT,                                               
MFA-TR*               EQUIPMENT_NO,                                             
MFA-TR*               TAG_NO,                                                   
MFA-TR*               CONDITION_CD,                                             
MFA-TR*               APPLIANCE_COMMENTS                                        
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO         = :VO-PREMISE-NO                       
MFA-TR*           AND LA.COMPANY_NO      = JA.COMPANY_NO                        
MFA-TR*           AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD                      
MFA-TR*           AND JA.DATE_TO        >= CURRENT_DATE                         
MFA-TR*           AND JA.CIS_DISPLAY_FL  = 'Y'                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7201                                                      
MFA-TR*    END-EXEC.                                                            
A05020                                                                  
      *****************************************************************         
      * CURSOR FOR FETCHING ALL CHARGES                               *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE CHARGES-CURSOR CURSOR FOR                         
               SELECT DISTINCT REG_CHARGEABLE_HRS,                      
                      OT_CHARGEABLE_HRS,                                
                      COMMENTS,                                         
                      WORK_PERIOD_CD,                                   
                      WAIVER_TYPE_CD,                                   
                      MATERIAL_CHRG,                                    
                      VG.CODE_UTIL_TYPE                                 
                 FROM CSS_SO_CHARGES  VG WITH(READUNCOMMITTED),                 
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VG.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VG.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VG.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
A05020*           AND ((VI.HOLD_RELEASE   <> 'Y')                               
A05020*            OR (VI.HOLD_RELEASE    = 'Y' AND                             
A05020*                VI.RLSE_NO         > ''))                                
                  AND VI.TASK_STATUS_CD   <> 'Z'                        
                  AND (REG_CHARGEABLE_HRS > 0                           
                   OR OT_CHARGEABLE_HRS   > 0                           
                   OR WORK_PERIOD_CD      > ' '                         
                   OR WAIVER_TYPE_CD      > ' '                         
                   OR MATERIAL_CHRG       > 0)                          
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CHARGES-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT DISTINCT REG_CHARGEABLE_HRS,                              
MFA-TR*               OT_CHARGEABLE_HRS,                                        
MFA-TR*               COMMENTS,                                                 
MFA-TR*               WORK_PERIOD_CD,                                           
MFA-TR*               WAIVER_TYPE_CD,                                           
MFA-TR*               MATERIAL_CHRG,                                            
MFA-TR*               VG.CODE_UTIL_TYPE                                         
MFA-TR*          FROM CSS_SO_CHARGES  VG,                                       
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VG.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VG.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VG.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND ((VI.HOLD_RELEASE   <> 'Y')                               
MFA-TR*            OR (VI.HOLD_RELEASE    = 'Y' AND                             
MFA-TR*                VI.RLSE_NO         > ''))                                
MFA-TR*           AND VI.TASK_STATUS_CD   <> 'Z'                                
MFA-TR*           AND (REG_CHARGEABLE_HRS > 0                                   
MFA-TR*            OR OT_CHARGEABLE_HRS   > 0                                   
MFA-TR*            OR WORK_PERIOD_CD      > ' '                                 
MFA-TR*            OR WAIVER_TYPE_CD      > ' '                                 
MFA-TR*            OR MATERIAL_CHRG       > 0)                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL METERS FOR GROUP A ORDER TYPES        *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE A-MTR-CURSOR CURSOR FOR                           
               SELECT MN.CODE_METER_STATUS,                             
                      MN.METER_SUPPLYING,                               
                      MN.CODE_UTIL_TYPE,                                
                      MN.METER_NO,                                      
                      MN.IC_NO,                                         
                      MN.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      VI.WORK_TYPE_CD,                                  
                      WORK_TYPE_DESC,                                   
                      CODE_TIME_PERIOD,                                 
                      REG_ID_NO,                                        
                      LOCK_TYPE_DESC,                                   
                      METER_LOC_DESC,                                   
                      LAST_READ_VALUE,                                  
                      LAST_REG_READ_DATE,                               
                      MN.CODE_STATUS_REAS,                              
                      RLSE_NO,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,                             
                      ELEC_PHASE_CD,                                    
                      POINT_ID,                                         
                      GIS_POINT_ID,                                     
                      MIN_NO_UNITS,                                     
                      MAX_NO_UNITS,                                     
                      REMOTE_READ_IND,                                  
                      DIGTL_MTR_TYPE,                                   
                      PROGRAM_ID,                                       
                      MTR_READ_SOURCE_CD,                               
                      METER_PRESSURE                                    
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED),                   
                      CSS_LOCK_TYPE B3 WITH(READUNCOMMITTED),                   
                      CSS_METER_LOC Q4 WITH(READUNCOMMITTED)                    
                WHERE MN.ACCOUNT_NO     = :VO-ACCOUNT-NO                
                  AND VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND MN.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND MN.LOCK_TYPE_ID   = B3.LOCK_TYPE_ID               
                  AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC             
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE A-MTR-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT MN.CODE_METER_STATUS,                                     
MFA-TR*               MN.METER_SUPPLYING,                                       
MFA-TR*               MN.CODE_UTIL_TYPE,                                        
MFA-TR*               MN.METER_NO,                                              
MFA-TR*               MN.IC_NO,                                                 
MFA-TR*               MN.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               CODE_TIME_PERIOD,                                         
MFA-TR*               REG_ID_NO,                                                
MFA-TR*               LOCK_TYPE_DESC,                                           
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               LAST_READ_VALUE,                                          
MFA-TR*               LAST_REG_READ_DATE,                                       
MFA-TR*               MN.CODE_STATUS_REAS,                                      
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               ELEC_PHASE_CD,                                            
MFA-TR*               POINT_ID,                                                 
MFA-TR*               GIS_POINT_ID,                                             
MFA-TR*               MIN_NO_UNITS,                                             
MFA-TR*               MAX_NO_UNITS,                                             
MFA-TR*               REMOTE_READ_IND,                                          
MFA-TR*               DIGTL_MTR_TYPE,                                           
MFA-TR*               PROGRAM_ID,                                               
MFA-TR*               MTR_READ_SOURCE_CD,                                       
MFA-TR*               METER_PRESSURE                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4,                                         
MFA-TR*               CSS_LOCK_TYPE B3,                                         
MFA-TR*               CSS_METER_LOC Q4                                          
MFA-TR*         WHERE MN.ACCOUNT_NO     = :VO-ACCOUNT-NO                        
MFA-TR*           AND VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VI.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND MN.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND MN.LOCK_TYPE_ID   = B3.LOCK_TYPE_ID                       
MFA-TR*           AND MN.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7401                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL METERS                                *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE METER-CURSOR CURSOR FOR                           
               SELECT CODE_DEST,                                        
                      DEST_NO,                                          
                      CODE_MTR_STATUS_WS,                               
                      READ_VALUE_IS,                                    
                      VC.METER_SUPPLYING,                               
                      VC.CODE_UTIL_TYPE,                                
                      VC.METER_NO,                                      
                      VC.IC_NO,                                         
                      VC.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      VI.WORK_TYPE_CD,                                  
                      WORK_TYPE_DESC,                                   
                      CODE_TIME_PERIOD,                                 
                      REG_ID_NO,                                        
                      CONSTANT,                                         
                      NO_DIALS,                                         
                      LOCK_TYPE_DESC,                                   
                      METER_LOC_DESC,                                   
                      LAST_READ_VALUE,                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_REG_READ_DATE, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DATE,                               
                      CODE_STATUS_REA_WS,                               
                      RLSE_NO,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,                             
                      VC.CODE_USAGE_TYPE,                               
                      VC.METER_PRESSURE                                 
                 FROM CSS_SO_MTR_CHG VC WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_LOCK_TYPE B3 WITH(READUNCOMMITTED),                   
                      CSS_METER_LOC Q4 WITH(READUNCOMMITTED),                   
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)                    
                WHERE VC.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VC.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VC.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VC.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND VC.IC_NO          = VI.IC_NO                      
                  AND VC.METER_NO       = VI.METER_NO                   
                  AND VC.MTR_REF_NO     = VI.MTR_REF_NO                 
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  AND VC.LOCK_TYPE_ID   = B3.LOCK_TYPE_ID               
                  AND VC.CODE_METER_LOC = Q4.CODE_METER_LOC             
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT CODE_DEST,                                                
MFA-TR*               DEST_NO,                                                  
MFA-TR*               CODE_MTR_STATUS_WS,                                       
MFA-TR*               READ_VALUE_IS,                                            
MFA-TR*               VC.METER_SUPPLYING,                                       
MFA-TR*               VC.CODE_UTIL_TYPE,                                        
MFA-TR*               VC.METER_NO,                                              
MFA-TR*               VC.IC_NO,                                                 
MFA-TR*               VC.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               CODE_TIME_PERIOD,                                         
MFA-TR*               REG_ID_NO,                                                
MFA-TR*               CONSTANT,                                                 
MFA-TR*               NO_DIALS,                                                 
MFA-TR*               LOCK_TYPE_DESC,                                           
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               LAST_READ_VALUE,                                          
MFA-TR*               LAST_REG_READ_DATE,                                       
MFA-TR*               CODE_STATUS_REA_WS,                                       
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               VC.CODE_USAGE_TYPE,                                       
MFA-TR*               VC.METER_PRESSURE                                         
MFA-TR*          FROM CSS_SO_MTR_CHG VC,                                        
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_LOCK_TYPE B3,                                         
MFA-TR*               CSS_METER_LOC Q4,                                         
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VC.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VC.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VC.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VC.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND VC.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VC.METER_NO       = VI.METER_NO                           
MFA-TR*           AND VC.MTR_REF_NO     = VI.MTR_REF_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           AND VC.LOCK_TYPE_ID   = B3.LOCK_TYPE_ID                       
MFA-TR*           AND VC.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL UTILITY INFO                          *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE UTIL-CURSOR CURSOR FOR                            
               SELECT VI.METER_SUPPLYING,                               
                      VI.CODE_UTIL_TYPE,                                
                      VI.METER_NO,                                      
                      VI.IC_NO,                                         
                      VI.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      VI.WORK_TYPE_CD,                                  
                      WORK_TYPE_DESC,                                   
                      RLSE_NO,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,                             
                      CODE_REVENUE_CLASS,                               
                      RATE_PLAN_NO,                                     
                      READ_CYCLE,                                       
                      VE.READ_ROUTE                                     
                 FROM CSS_SO_UTL_CHG VE WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)                    
                WHERE VE.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VE.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VE.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VE.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND VE.IC_NO          = VI.IC_NO                      
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE UTIL-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT VI.METER_SUPPLYING,                                       
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               VI.IC_NO,                                                 
MFA-TR*               VI.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               READ_CYCLE,                                               
MFA-TR*               VE.READ_ROUTE                                             
MFA-TR*          FROM CSS_SO_UTL_CHG VE,                                        
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VE.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VE.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VE.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VE.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND VE.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7402                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL SO METER INFO                         *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE SOMETER-CURSOR CURSOR FOR                         
               SELECT VI.METER_SUPPLYING,                               
                      VI.CODE_UTIL_TYPE,                                
                      VI.METER_NO,                                      
                      VI.IC_NO,                                         
                      VI.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      VI.WORK_TYPE_CD,                                  
                      WORK_TYPE_DESC,                                   
                      METER_LOC_DESC,                                   
                      RLSE_NO,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE
           , 121), ' ', '-'), ':', '.') RLSE_DATE,                             
                      METER_PRESSURE                                    
                 FROM CSS_SO_METER   VM WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_METER_LOC Q4 WITH(READUNCOMMITTED),                   
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)                    
                WHERE VM.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VM.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VM.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VM.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND VM.IC_NO          = VI.IC_NO                      
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC             
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SOMETER-CURSOR CURSOR FOR                                 
MFA-TR*        SELECT VI.METER_SUPPLYING,                                       
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               VI.IC_NO,                                                 
MFA-TR*               VI.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               METER_PRESSURE                                            
MFA-TR*          FROM CSS_SO_METER   VM,                                        
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_METER_LOC Q4,                                         
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VM.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VM.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VM.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VM.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND VM.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7403                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL REGISTERS                             *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE REGISTERS-CURSOR CURSOR FOR                       
               SELECT READ_VALUE_IS,                                    
                      CODE_TIME_PERIOD,                                 
                      REG_ID_NO,                                        
                      CODE_STATUS_REA_WS,                               
                      LAST_READ_VALUE,                                  
                      NO_DIALS,                                         
                      VK.CODE_UTIL_TYPE,                                
                      VK.METER_NO,                                      
                      VK.IC_NO,                                         
                      VK.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      VK.CODE_USAGE_TYPE,                               
                      VK.CODE_REG_STATUS_WS,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           VK.LAST_REG_READ_DT, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DT,                              
                      VI.WORK_TYPE_CD                                   
                 FROM CSS_SO_REG_CHG VK WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VK.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VK.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VK.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND VK.IC_NO          = VI.IC_NO                      
                  AND VK.METER_NO       = VI.METER_NO                   
                  AND VK.MTR_REF_NO     = VI.MTR_REF_NO                 
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <>'FIN'                         
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REGISTERS-CURSOR CURSOR FOR                               
MFA-TR*        SELECT READ_VALUE_IS,                                            
MFA-TR*               CODE_TIME_PERIOD,                                         
MFA-TR*               REG_ID_NO,                                                
MFA-TR*               CODE_STATUS_REA_WS,                                       
MFA-TR*               LAST_READ_VALUE,                                          
MFA-TR*               NO_DIALS,                                                 
MFA-TR*               VK.CODE_UTIL_TYPE,                                        
MFA-TR*               VK.METER_NO,                                              
MFA-TR*               VK.IC_NO,                                                 
MFA-TR*               VK.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VK.CODE_USAGE_TYPE,                                       
MFA-TR*               VK.CODE_REG_STATUS_WS,                                    
MFA-TR*               VK.LAST_REG_READ_DT,                                      
MFA-TR*               VI.WORK_TYPE_CD                                           
MFA-TR*          FROM CSS_SO_REG_CHG VK,                                        
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VK.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VK.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VK.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND VK.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VK.METER_NO       = VI.METER_NO                           
MFA-TR*           AND VK.MTR_REF_NO     = VI.MTR_REF_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <>'FIN'                                 
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL SOREGISTERS                           *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE SOREGISTERS-CURSOR CURSOR FOR                     
               SELECT CODE_TIME_PERIOD,                                 
                      REG_ID_NO,                                        
                      CODE_STATUS_REAS,                                 
                      LAST_READ_VALUE,                                  
                      NO_DIALS,                                         
                      WK.CODE_UTIL_TYPE,                                
                      WK.METER_NO,                                      
                      WK.IC_NO,                                         
                      WK.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      WK.CODE_REG_STATUS,                               
                      WK.CODE_USAGE_TYPE,                               
                      VI.WORK_TYPE_CD                                   
                 FROM CSS_SO_REGISTER WK WITH(READUNCOMMITTED),                 
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE WK.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND WK.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND WK.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND WK.IC_NO          = VI.IC_NO                      
                  AND WK.METER_NO       = VI.METER_NO                   
                  AND WK.MTR_REF_NO     = VI.MTR_REF_NO                 
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <>'FIN'                         
                  AND VI.TASK_STATUS_CD <> 'Z'                          
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SOREGISTERS-CURSOR CURSOR FOR                             
MFA-TR*        SELECT CODE_TIME_PERIOD,                                         
MFA-TR*               REG_ID_NO,                                                
MFA-TR*               CODE_STATUS_REAS,                                         
MFA-TR*               LAST_READ_VALUE,                                          
MFA-TR*               NO_DIALS,                                                 
MFA-TR*               WK.CODE_UTIL_TYPE,                                        
MFA-TR*               WK.METER_NO,                                              
MFA-TR*               WK.IC_NO,                                                 
MFA-TR*               WK.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               WK.CODE_REG_STATUS,                                       
MFA-TR*               WK.CODE_USAGE_TYPE,                                       
MFA-TR*               VI.WORK_TYPE_CD                                           
MFA-TR*          FROM CSS_SO_REGISTER WK,                                       
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE WK.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND WK.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND WK.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND WK.IC_NO          = VI.IC_NO                              
MFA-TR*           AND WK.METER_NO       = VI.METER_NO                           
MFA-TR*           AND WK.MTR_REF_NO     = VI.MTR_REF_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <>'FIN'                                 
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7404                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL REGISTERS FOR GROUP A ORDERS          *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE REG-READ-CURSOR CURSOR FOR                        
               SELECT RG.LAST_VAL_RD_VALUE,                             
                      RG.CODE_TIME_PERIOD,                              
                      RG.REG_ID_NO,                                     
                      RG.CODE_STATUS_REAS,                              
                      RG.LAST_READ_VALUE,                               
                      MC.NO_DIALS,                                      
                      RG.CODE_UTIL_TYPE,                                
                      RG.METER_NO,                                      
                      RG.IC_NO,                                         
                      RG.MTR_REF_NO,                                    
                      SO_INST_SEQ_NO,                                   
                      RG.CODE_USAGE_TYPE,                               
                      RG.CODE_REG_STATUS,                               
                      RG.MIN_NO_UNITS,                                  
                      RG.MAX_NO_UNITS,                                  
                      REPLACE(CONVERT(CHAR(8), RG.LAST_REG_READ_TM
           , 108), ':', '.') LAST_REG_READ_TM,                              
                      RG.LAST_REG_READ_DT,                              
                      VI.WORK_TYPE_CD                                   
                 FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),               
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_MTR_CAP       MC WITH(READUNCOMMITTED),               
                      CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED),               
                      CSS_SO_DATA       VO WITH(READUNCOMMITTED)                
                WHERE VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VO.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VO.ACCOUNT_NO     = RG.ACCOUNT_NO                 
                  AND VO.ACCOUNT_NO     = MN.ACCOUNT_NO                 
                  AND RG.ACCOUNT_NO     = MN.ACCOUNT_NO                 
                  AND RG.IC_NO          = MN.IC_NO                      
                  AND RG.METER_NO       = MN.METER_NO                   
                  AND RG.MTR_REF_NO     = MN.MTR_REF_NO                 
                  AND RG.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
                  AND RG.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE             
                  AND RG.METER_NO       = MC.METER_NO                   
                  AND RG.REG_ID_NO      = MC.REG_ID_NO                  
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <>'FIN'                         
                  AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REG-READ-CURSOR CURSOR FOR                                
MFA-TR*        SELECT RG.LAST_VAL_RD_VALUE,                                     
MFA-TR*               RG.CODE_TIME_PERIOD,                                      
MFA-TR*               RG.REG_ID_NO,                                             
MFA-TR*               RG.CODE_STATUS_REAS,                                      
MFA-TR*               RG.LAST_READ_VALUE,                                       
MFA-TR*               MC.NO_DIALS,                                              
MFA-TR*               RG.CODE_UTIL_TYPE,                                        
MFA-TR*               RG.METER_NO,                                              
MFA-TR*               RG.IC_NO,                                                 
MFA-TR*               RG.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               RG.CODE_USAGE_TYPE,                                       
MFA-TR*               RG.CODE_REG_STATUS,                                       
MFA-TR*               RG.MIN_NO_UNITS,                                          
MFA-TR*               RG.MAX_NO_UNITS,                                          
MFA-TR*               RG.LAST_REG_READ_TM,                                      
MFA-TR*               RG.LAST_REG_READ_DT,                                      
MFA-TR*               VI.WORK_TYPE_CD                                           
MFA-TR*          FROM CSS_REGISTER_READ RG,                                     
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_MTR_CAP       MC,                                     
MFA-TR*               CSS_MTRD_ENVRNMT  MN,                                     
MFA-TR*               CSS_SO_DATA       VO                                      
MFA-TR*         WHERE VI.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VO.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VO.ACCOUNT_NO     = RG.ACCOUNT_NO                         
MFA-TR*           AND VO.ACCOUNT_NO     = MN.ACCOUNT_NO                         
MFA-TR*           AND RG.ACCOUNT_NO     = MN.ACCOUNT_NO                         
MFA-TR*           AND RG.IC_NO          = MN.IC_NO                              
MFA-TR*           AND RG.METER_NO       = MN.METER_NO                           
MFA-TR*           AND RG.MTR_REF_NO     = MN.MTR_REF_NO                         
MFA-TR*           AND RG.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND RG.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                     
MFA-TR*           AND RG.METER_NO       = MC.METER_NO                           
MFA-TR*           AND RG.REG_ID_NO      = MC.REG_ID_NO                          
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <>'FIN'                                 
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7501                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
P00718*****************************************************************         
P00718* CURSOR FOR FETCHING ALL METER ATTACHMENTS                     *         
P00718*****************************************************************         
P00718     EXEC SQL                                                     
P00718       DECLARE ATTACHMENTS-CURSOR CURSOR FOR                      
P00718        SELECT DEVICE_NO,                                         
P00718               MTR_ATT_TYPE_DESC,                                 
P00718               CODE_STATUS_REASON,                                
P00718               READ_VALUE_IS,                                     
P00718               [ON].CODE_UTIL_TYPE,                                 
P00718               [ON].METER_NO,                                       
P00718               [ON].IC_NO,                                          
P00718               [ON].MTR_REF_NO,                                     
P00718               [ON].REG_ID_NO,                                      
P00718               VI.SO_INST_SEQ_NO                                  
P00718          FROM CSS_SO_MTR_ATT_CHG [ON] WITH(READUNCOMMITTED),             
P00718               CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),                
P00718               CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                  
P00718         WHERE [ON].SERV_ORDER_NO  = :VI-SERV-ORDER-NO              
P00718            AND [ON].SERV_ORDER_NO  = VI.SERV_ORDER_NO              
P00718            AND [ON].IC_NO          = VI.IC_NO                      
P00718            AND [ON].METER_NO       = VI.METER_NO                   
P00718            AND [ON].MTR_REF_NO     = VI.MTR_REF_NO                 
P00718            AND VI.WORK_TYPE_CD   > ' '                           
P00718            AND VI.WORK_TYPE_CD   <> 'FIN'                        
P00718            AND VI.TASK_STATUS_CD <> 'Z'                          
A05020*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
A05020*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
A05020*                VI.RLSE_NO       > ''))                                  
P00718            AND [ON].CODE_ATT_TYPE  = N5.CODE_ATT_TYPE              
P00718            AND [ON].CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE             
P00718            AND [ON].CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE             
P00718            AND N5.DEVICE_TYPE_CD = 'A'                           
P00718            AND [ON].DEVICE_NO =                                    
P00718                  (SELECT MIN(A.DEVICE_NO)                        
P00718                     FROM CSS_SO_MTR_ATT_CHG A
                           WITH(READUNCOMMITTED)                    
P00718                     WHERE A.SERV_ORDER_NO   = [ON].SERV_ORDER_NO   
P00718                       AND A.CODE_UTIL_TYPE  = [ON].CODE_UTIL_TYPE  
P00718                       AND A.IC_NO           = [ON].IC_NO           
P00718                       AND A.MTR_REF_NO      = [ON].MTR_REF_NO)     
P00718            FOR READ ONLY                                        
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ATTACHMENTS-CURSOR CURSOR FOR                              
MFA-TR*       SELECT DEVICE_NO,                                                 
MFA-TR*              MTR_ATT_TYPE_DESC,                                         
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              READ_VALUE_IS,                                             
MFA-TR*              ON.CODE_UTIL_TYPE,                                         
MFA-TR*              ON.METER_NO,                                               
MFA-TR*              ON.IC_NO,                                                  
MFA-TR*              ON.MTR_REF_NO,                                             
MFA-TR*              ON.REG_ID_NO,                                              
MFA-TR*              VI.SO_INST_SEQ_NO                                          
MFA-TR*         FROM CSS_SO_MTR_ATT_CHG ON,                                     
MFA-TR*              CSS_SO_ORDER_INST VI,                                      
MFA-TR*              CSS_MTR_ATT_TYPE N5                                        
MFA-TR*        WHERE ON.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                      
MFA-TR*           AND ON.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND ON.IC_NO          = VI.IC_NO                              
MFA-TR*           AND ON.METER_NO       = VI.METER_NO                           
MFA-TR*           AND ON.MTR_REF_NO     = VI.MTR_REF_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.TASK_STATUS_CD <> 'Z'                                  
MFA-TR*           AND ((VI.HOLD_RELEASE <> 'Y')                                 
MFA-TR*            OR (VI.HOLD_RELEASE  = 'Y' AND                               
MFA-TR*                VI.RLSE_NO       > ''))                                  
MFA-TR*           AND ON.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                      
MFA-TR*           AND ON.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                     
MFA-TR*           AND ON.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                     
MFA-TR*           AND N5.DEVICE_TYPE_CD = 'A'                                   
MFA-TR*           AND ON.DEVICE_NO =                                            
MFA-TR*                 (SELECT MIN(A.DEVICE_NO)                                
MFA-TR*                    FROM CSS_SO_MTR_ATT_CHG A                            
MFA-TR*                    WHERE A.SERV_ORDER_NO   = ON.SERV_ORDER_NO           
MFA-TR*                      AND A.CODE_UTIL_TYPE  = ON.CODE_UTIL_TYPE          
MFA-TR*                      AND A.IC_NO           = ON.IC_NO                   
MFA-TR*                      AND A.MTR_REF_NO      = ON.MTR_REF_NO)             
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL DNP INFORMATION                       *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE DNP-CURSOR CURSOR FOR                             
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      AMT_ORIG_ENTERED                                  
                 FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                   
                  AND CODE_TRAN_TYPE = 'P'                              
                  AND RECORD_ONLY_FL <> 'Y'                             
                ORDER BY TRANS_HIST_SEQ_NO DESC
            OPTION(FAST 1)
            FOR READ ONLY
            
                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DNP-CURSOR CURSOR FOR                                     
MFA-TR*        SELECT TRANS_HIST_SEQ_NO,                                        
MFA-TR*               AMT_ORIG_ENTERED                                          
MFA-TR*          FROM CSS_AR_TRANS_HIST                                         
MFA-TR*         WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                           
MFA-TR*           AND CODE_TRAN_TYPE = 'P'                                      
MFA-TR*           AND RECORD_ONLY_FL <> 'Y'                                     
MFA-TR*         ORDER BY TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*         OPTIMIZE FOR 1 ROW                                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL RED FLAG COMMUNICATIONS FOR ACCOUNT   *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE COMM-CURSOR CURSOR FOR                            
               SELECT COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      INITIAL_COMMENT_TX                                
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO   = :VO-ACCOUNT-NO                     
                  AND RED_FLAG_IND = 'Y'                                
                  AND (RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                 :KO-RED-FLAG-EXPIRE-DT
              )      
                   OR  RED_FLAG_EXPIRE_DT IS NULL)                      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               INITIAL_COMMENT_TX                                        
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE ACCOUNT_NO   = :VO-ACCOUNT-NO                             
MFA-TR*           AND RED_FLAG_IND = 'Y'                                        
MFA-TR*           AND (RED_FLAG_EXPIRE_DT > :KO-RED-FLAG-EXPIRE-DT              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CURSOR FOR FETCHING ALL RED FLAG COMMUNICATIONS FOR PREMISE   *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE COMM-PREM-CURSOR CURSOR FOR                       
               SELECT COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      INITIAL_COMMENT_TX                                
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO   = :VO-PREMISE-NO                     
                  AND RED_FLAG_IND = 'Y'                                
                  AND (RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                 :KO-RED-FLAG-EXPIRE-DT
              )      
                   OR  RED_FLAG_EXPIRE_DT IS NULL)                      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-PREM-CURSOR CURSOR FOR                               
MFA-TR*        SELECT COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               INITIAL_COMMENT_TX                                        
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE PREMISE_NO   = :VO-PREMISE-NO                             
MFA-TR*           AND RED_FLAG_IND = 'Y'                                        
MFA-TR*           AND (RED_FLAG_EXPIRE_DT > :KO-RED-FLAG-EXPIRE-DT              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7121                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
A05020*****************************************************************         
A05020* CURSOR FOR FETCHING ALL ORDER TASK TYPES                      *         
A05020*****************************************************************         
A05020     EXEC SQL                                                     
A05020        DECLARE TASK-TYPE-CURSOR CURSOR FOR                       
A05020         SELECT VALIDATION_CD,                                    
A05020                LTRIM(RTRIM(VALIDATE_CRITERIA)),                          
A05020                SO_BUSINESS_UNIT,                                 
A05020                CLICK_VALUE                                       
A05020           FROM CSS_FM_ORD_TASK_TP WITH(READUNCOMMITTED)                  
A05020          WHERE COMPANY_NO       = :VO-COMPANY-NO                 
A05020            AND ORDER_TYPE_CD    = :VO-ORDER-TYPE-CD              
A05020            AND WORK_TYPE_CD     = :VI-WORK-TYPE-CD               
A05020            AND CODE_UTIL_TYPE   = :VI-CODE-UTIL-TYPE             
A05020            AND CAST(VALID_THROUGH_TS AS DATE) > 
           CAST(SYSDATETIMEOFFSET() AS DATE)             
A05020          ORDER BY FLD_MOB_PRIORTY_CD                             
A05020         FOR READ ONLY                                    
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TASK-TYPE-CURSOR CURSOR FOR                               
MFA-TR*        SELECT VALIDATION_CD,                                            
MFA-TR*               TRIM(VALIDATE_CRITERIA),                                  
MFA-TR*               SO_BUSINESS_UNIT,                                         
MFA-TR*               CLICK_VALUE                                               
MFA-TR*          FROM CSS_FM_ORD_TASK_TP                                        
MFA-TR*         WHERE COMPANY_NO       = :VO-COMPANY-NO                         
MFA-TR*           AND ORDER_TYPE_CD    = :VO-ORDER-TYPE-CD                      
MFA-TR*           AND WORK_TYPE_CD     = :VI-WORK-TYPE-CD                       
MFA-TR*           AND CODE_UTIL_TYPE   = :VI-CODE-UTIL-TYPE                     
MFA-TR*           AND DATE(VALID_THROUGH_TS) > CURRENT DATE                     
MFA-TR*         ORDER BY FLD_MOB_PRIORTY_CD                                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7131                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                 AS RETURN_CODE,            
                 SERV_ORDER_NO               AS SERV_ORDER_NO,          
                 SO_INST_SEQ_NO              AS SO_INST_SEQ_NO,         
                 WORK_TYPE_CD                AS WORK_TYPE_CD,           
                 LTRIM(RTRIM(WORK_TYPE_DESC))       AS WORK_TYPE_DESC,         
                 CODE_UTIL_TYPE              AS CODE_UTIL_TYPE,         
                 ORDER_PRIORITY_CD           AS ORDER_PRIORITY_CD,      
                 SO_EST_LABOR_HR             AS SO_EST_LABOR_HR,        
                 COMPANY_NO                  AS COMPANY_NO,             
                 LOCAL_OFFICE                AS LOCAL_OFFICE,           
                 ORDER_TYPE_CD               AS ORDER_TYPE_CD,          
                 ACCOUNT_NO                  AS ACCOUNT_NO,             
                 LTRIM(RTRIM(FULL_NAME))            AS FULL_NAME,              
                 LTRIM(RTRIM(STREET_ADDRESS))       AS STREET_ADDRESS,         
                 HOUSE_NO                    AS HOUSE_NO,               
                 ADDR_PREFIX_1               AS ADDR_PREFIX_1,          
                 ADDR_PREFIX_2               AS ADDR_PREFIX_2,          
                 LTRIM(RTRIM(STREET_NAME))                 AS 
           STREET_NAME,     
                 STREET_SUFFIX               AS STREET_SUFFIX,          
                 ADDR_SUFFIX                 AS ADDR_SUFFIX,            
                 STREET_LOCATION_1           AS STREET_LOCATION_1,      
                 STREET_LOCATION_2           AS STREET_LOCATION_2,      
                 LTRIM(RTRIM(ADDR_STREET))          AS ADDR_STREET,            
                 LTRIM(RTRIM(ADDR_CITY_STATE))      AS ADDR_CITY_STATE,        
                 STATE                       AS STATE,                  
                 LTRIM(RTRIM(COUNTRY))              AS COUNTRY,                
                 LATITUDE                    AS LATITUDE,               
                 LONGITUDE                   AS LONGITUDE,              
                 LOT                         AS LOT,                    
                 BLOCK                       AS BLOCK,                  
                 LTRIM(RTRIM(SUBDIVISION_DESC))     AS SUBDIVISION_DESC,       
A05020           LTRIM(RTRIM(SUBDIVISION_ID))       AS SUBDIVISION_ID,         
                 LTRIM(RTRIM(ZIP_CODE))             AS ZIP_CODE,               
A05020           LTRIM(RTRIM(ZIP_CODE_PLUS_FOUR))   AS 
           ZIP_CODE_PLUS_FOUR,     
                 LTRIM(RTRIM(TOWN))                 AS TOWN,                   
                 LTRIM(RTRIM(ORDER_PLACED_BY))      AS ORDER_PLACED_BY,        
                 ORDER_REASON                AS ORDER_REASON,           
                 CALL_BEFORE_MINUTS          AS CALL_BEFORE_MINUTS,     
                 PHONE_NO                    AS PHONE_NO,               
                 PHONE_NO_EXT                AS PHONE_NO_EXT,           
                 LTRIM(RTRIM(SERV_ORDER_REMARKS))   AS 
           SERV_ORDER_REMARKS,     
                 LTRIM(RTRIM(SERV_ORDER_REMUPD))    AS 
           SERV_ORDER_REMUPD,      
                 LTRIM(RTRIM(SPCL_INSTRUCTIONS))    AS 
           SPCL_INSTRUCTIONS,      
                 PREMISE                     AS PREMISE,                
                 LTRIM(RTRIM(PREMISE_DIRECTIONS))   AS 
           PREMISE_DIRECTIONS,     
                 CODE_ACCT_STAT              AS CODE_ACCT_STAT,         
                 XS_FLOW_VALVE_FL            AS XS_FLOW_VALVE_FL,       
                 SPLIT_SERVICE_FL            AS SPLIT_SERVICE_FL,       
                 SERVICE_CHARGES             AS SERVICE_CHARGES,        
                 LTRIM(RTRIM(COUNTY))               AS COUNTY,                 
                 TOTAL_BTU                   AS TOTAL_BTU,              
                 ALT_PHONE_NO                AS ALT_PHONE_NO,           
                 ALT_PHONE_NO_EXT            AS ALT_PHONE_NO_EXT,       
A05020*          MADE_SAFE_DT                AS MADE_SAFE_DT,                   
                 HOME_ALL_DAY_FL             AS HOME_ALL_DAY_FL,        
                 LTRIM(RTRIM(BUSINESS_UNIT))        AS BUSINESS_UNIT,          
                 DNP_CRITICAL_CUS            AS DNP_CRITICAL_CUS,       
                 CIRCUIT_ID                  AS CIRCUIT_ID,             
                 CUST_PHASE_CD               AS CUST_PHASE_CD,          
                 GRID_CELL                   AS GRID_CELL,              
                 POLE_NO                     AS POLE_NO,                
                 ASSIGNED_DATE               AS ASSIGNED_DATE,          
                 COMPLIANCE_DAYS             AS COMPLIANCE_DAYS,        
                 DUE_DAYS                    AS DUE_DAYS,               
                 MATERIAL_FL                 AS MATERIAL_FL,            
                 WORK_START_TIME             AS WORK_START_TIME,        
                 WORK_STOP_TIME              AS WORK_STOP_TIME,         
                 LTRIM(RTRIM(WORK_DISTRICT))        AS WORK_DISTRICT,          
                 OPTIMIZE_ORDER              AS OPTIMIZE_ORDER,         
                 ORDER_STATE_CD              AS ORDER_STATE_CD,         
                 RED_FLAG_SAFETY             AS RED_FLAG_SAFETY,        
                 RED_FLAG_MAINT              AS RED_FLAG_MAINT,         
                 RED_FLAG_STORM              AS RED_FLAG_STORM,         
                 SO_SERVICE_CHRG             AS SO_SERVICE_CHRG,        
                 GROUP_CODE                  AS GROUP_CODE,             
                 RLSE_NO                     AS RLSE_NO,                
                 ORDER_CANCEL                AS ORDER_CANCEL,           
                 LTRIM(RTRIM(SO_COMPL_REMARKS))     AS SO_COMPL_REMARKS,       
                 LTRIM(RTRIM(DATE_RECVED))          AS DATE_RECVED,            
A00520           LTRIM(RTRIM(COMM_COMMENTS))        AS COMM_COMMENTS,          
A00520           LTRIM(RTRIM(DBA_NAME))             AS DBA_NAME,               
A00520           COMPLIANCE_DATE             AS COMPLIANCE_DATE,        
A00520           LTRIM(RTRIM(TASK_TYPE))            AS TASK_TYPE,              
A00520           APPT_FL                     AS APPT_FL,                
P01176           SAMPLE_TEST                 AS SAMPLE_TEST,            
A05020           HOT_SPOT_FL                 AS HOT_SPOT_FL             
              FROM #CSR04584_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                 AS RETURN_CODE,                    
MFA-TR*          SERV_ORDER_NO               AS SERV_ORDER_NO,                  
MFA-TR*          SO_INST_SEQ_NO              AS SO_INST_SEQ_NO,                 
MFA-TR*          WORK_TYPE_CD                AS WORK_TYPE_CD,                   
MFA-TR*          STRIP(WORK_TYPE_DESC)       AS WORK_TYPE_DESC,                 
MFA-TR*          CODE_UTIL_TYPE              AS CODE_UTIL_TYPE,                 
MFA-TR*          ORDER_PRIORITY_CD           AS ORDER_PRIORITY_CD,              
MFA-TR*          SO_EST_LABOR_HR             AS SO_EST_LABOR_HR,                
MFA-TR*          COMPANY_NO                  AS COMPANY_NO,                     
MFA-TR*          LOCAL_OFFICE                AS LOCAL_OFFICE,                   
MFA-TR*          ORDER_TYPE_CD               AS ORDER_TYPE_CD,                  
MFA-TR*          ACCOUNT_NO                  AS ACCOUNT_NO,                     
MFA-TR*          STRIP(FULL_NAME)            AS FULL_NAME,                      
MFA-TR*          STRIP(STREET_ADDRESS)       AS STREET_ADDRESS,                 
MFA-TR*          HOUSE_NO                    AS HOUSE_NO,                       
MFA-TR*          ADDR_PREFIX_1               AS ADDR_PREFIX_1,                  
MFA-TR*          ADDR_PREFIX_2               AS ADDR_PREFIX_2,                  
MFA-TR*          STRIP(STREET_NAME)                 AS STREET_NAME,             
MFA-TR*          STREET_SUFFIX               AS STREET_SUFFIX,                  
MFA-TR*          ADDR_SUFFIX                 AS ADDR_SUFFIX,                    
MFA-TR*          STREET_LOCATION_1           AS STREET_LOCATION_1,              
MFA-TR*          STREET_LOCATION_2           AS STREET_LOCATION_2,              
MFA-TR*          STRIP(ADDR_STREET)          AS ADDR_STREET,                    
MFA-TR*          STRIP(ADDR_CITY_STATE)      AS ADDR_CITY_STATE,                
MFA-TR*          STATE                       AS STATE,                          
MFA-TR*          STRIP(COUNTRY)              AS COUNTRY,                        
MFA-TR*          LATITUDE                    AS LATITUDE,                       
MFA-TR*          LONGITUDE                   AS LONGITUDE,                      
MFA-TR*          LOT                         AS LOT,                            
MFA-TR*          BLOCK                       AS BLOCK,                          
MFA-TR*          STRIP(SUBDIVISION_DESC)     AS SUBDIVISION_DESC,               
MFA-TR*          STRIP(SUBDIVISION_ID)       AS SUBDIVISION_ID,                 
MFA-TR*          STRIP(ZIP_CODE)             AS ZIP_CODE,                       
MFA-TR*          STRIP(ZIP_CODE_PLUS_FOUR)   AS ZIP_CODE_PLUS_FOUR,             
MFA-TR*          STRIP(TOWN)                 AS TOWN,                           
MFA-TR*          STRIP(ORDER_PLACED_BY)      AS ORDER_PLACED_BY,                
MFA-TR*          ORDER_REASON                AS ORDER_REASON,                   
MFA-TR*          CALL_BEFORE_MINUTS          AS CALL_BEFORE_MINUTS,             
MFA-TR*          PHONE_NO                    AS PHONE_NO,                       
MFA-TR*          PHONE_NO_EXT                AS PHONE_NO_EXT,                   
MFA-TR*          STRIP(SERV_ORDER_REMARKS)   AS SERV_ORDER_REMARKS,             
MFA-TR*          STRIP(SERV_ORDER_REMUPD)    AS SERV_ORDER_REMUPD,              
MFA-TR*          STRIP(SPCL_INSTRUCTIONS)    AS SPCL_INSTRUCTIONS,              
MFA-TR*          PREMISE                     AS PREMISE,                        
MFA-TR*          STRIP(PREMISE_DIRECTIONS)   AS PREMISE_DIRECTIONS,             
MFA-TR*          CODE_ACCT_STAT              AS CODE_ACCT_STAT,                 
MFA-TR*          XS_FLOW_VALVE_FL            AS XS_FLOW_VALVE_FL,               
MFA-TR*          SPLIT_SERVICE_FL            AS SPLIT_SERVICE_FL,               
MFA-TR*          SERVICE_CHARGES             AS SERVICE_CHARGES,                
MFA-TR*          STRIP(COUNTY)               AS COUNTY,                         
MFA-TR*          TOTAL_BTU                   AS TOTAL_BTU,                      
MFA-TR*          ALT_PHONE_NO                AS ALT_PHONE_NO,                   
MFA-TR*          ALT_PHONE_NO_EXT            AS ALT_PHONE_NO_EXT,               
MFA-TR*          MADE_SAFE_DT                AS MADE_SAFE_DT,                   
MFA-TR*          HOME_ALL_DAY_FL             AS HOME_ALL_DAY_FL,                
MFA-TR*          STRIP(BUSINESS_UNIT)        AS BUSINESS_UNIT,                  
MFA-TR*          DNP_CRITICAL_CUS            AS DNP_CRITICAL_CUS,               
MFA-TR*          CIRCUIT_ID                  AS CIRCUIT_ID,                     
MFA-TR*          CUST_PHASE_CD               AS CUST_PHASE_CD,                  
MFA-TR*          GRID_CELL                   AS GRID_CELL,                      
MFA-TR*          POLE_NO                     AS POLE_NO,                        
MFA-TR*          ASSIGNED_DATE               AS ASSIGNED_DATE,                  
MFA-TR*          COMPLIANCE_DAYS             AS COMPLIANCE_DAYS,                
MFA-TR*          DUE_DAYS                    AS DUE_DAYS,                       
MFA-TR*          MATERIAL_FL                 AS MATERIAL_FL,                    
MFA-TR*          WORK_START_TIME             AS WORK_START_TIME,                
MFA-TR*          WORK_STOP_TIME              AS WORK_STOP_TIME,                 
MFA-TR*          STRIP(WORK_DISTRICT)        AS WORK_DISTRICT,                  
MFA-TR*          OPTIMIZE_ORDER              AS OPTIMIZE_ORDER,                 
MFA-TR*          ORDER_STATE_CD              AS ORDER_STATE_CD,                 
MFA-TR*          RED_FLAG_SAFETY             AS RED_FLAG_SAFETY,                
MFA-TR*          RED_FLAG_MAINT              AS RED_FLAG_MAINT,                 
MFA-TR*          RED_FLAG_STORM              AS RED_FLAG_STORM,                 
MFA-TR*          SO_SERVICE_CHRG             AS SO_SERVICE_CHRG,                
MFA-TR*          GROUP_CODE                  AS GROUP_CODE,                     
MFA-TR*          RLSE_NO                     AS RLSE_NO,                        
MFA-TR*          ORDER_CANCEL                AS ORDER_CANCEL,                   
MFA-TR*          STRIP(SO_COMPL_REMARKS)     AS SO_COMPL_REMARKS,               
MFA-TR*          STRIP(DATE_RECVED)          AS DATE_RECVED,                    
MFA-TR*          STRIP(COMM_COMMENTS)        AS COMM_COMMENTS,                  
MFA-TR*          STRIP(DBA_NAME)             AS DBA_NAME,                       
MFA-TR*          COMPLIANCE_DATE             AS COMPLIANCE_DATE,                
MFA-TR*          STRIP(TASK_TYPE)            AS TASK_TYPE,                      
MFA-TR*          APPT_FL                     AS APPT_FL,                        
MFA-TR*          SAMPLE_TEST                 AS SAMPLE_TEST,                    
MFA-TR*          HOT_SPOT_FL                 AS HOT_SPOT_FL                     
MFA-TR*       FROM SESSION.CSR04584_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1       AS RETURN_CODE,            
                      :S-SERV-ORDER-NO       AS SERV_ORDER_NO ,         
                      :S-SO-INST-SEQ-NO-1    AS SO_INST_SEQ_NO,         
                      :S-WORK-TYPE-CD-1      AS WORK_TYPE_CD,           
                      :S-WORK-TYPE-DESC-1    AS WORK_TYPE_DESC,         
                      :S-CODE-UTIL-TYPE-1    AS CODE_UTIL_TYPE,         
                      :S-ORDER-PRIORITY-CD   AS ORDER_PRIORITY_CD,      
                      :S-SO-EST-LABOR-HR     AS SO_EST_LABOR_HR,        
                      :S-COMPANY-NO          AS COMPANY_NO,             
                      :S-LOCAL-OFFICE        AS LOCAL_OFFICE,           
                      :S-ORDER-TYPE-CD       AS ORDER_TYPE_CD,          
                      :S-ACCOUNT-NO          AS ACCOUNT_NO,             
                      :S-FULL-NAME           AS FULL_NAME,              
                      :S-STREET-ADDRESS      AS STREET_ADDRESS,         
                      :S-HOUSE-NO            AS HOUSE_NO,               
                      :S-ADDR-PREFIX-1       AS ADDR_PREFIX_1,          
                      :S-ADDR-PREFIX-2       AS ADDR_PREFIX_2,          
                      :S-STREET-NAME         AS STREET_NAME,            
                      :S-STREET-SUFFIX       AS STREET_SUFFIX,          
                      :S-ADDR-SUFFIX         AS ADDR_SUFFIX,            
                      :S-STREET-LOCATION-1   AS STREET_LOCATION_1,      
                      :S-STREET-LOCATION-2   AS STREET_LOCATION_2,      
                      :S-ADDR-STREET         AS ADDR_STREET,            
                      :S-ADDR-CITY-STATE     AS ADDR_CITY_STATE,        
                      :S-STATE               AS STATE,                  
                      :S-COUNTRY             AS COUNTRY,                
                      :S-LATITUDE            AS LATITUDE,               
                      :S-LONGITUDE           AS LONGITUDE,              
                      :S-LOT                 AS LOT,                    
                      :S-BLOCK               AS BLOCK ,                 
                      :S-SUBDIVISION-DESC    AS SUBDIVISION_DESC,       
A05020                :S-SUBDIVISION-ID      AS SUBDIVISION_ID,         
                      :S-ZIP-CODE            AS ZIP_CODE,               
A05020                :S-ZIP-CODE-PLUS-FOUR  AS ZIP_CODE_PLUS_FOUR,     
                      :S-TOWN                AS TOWN ,                  
                      :S-ORDER-PLACED-BY     AS ORDER_PLACED_BY,        
                      :S-ORDER-REASON        AS ORDER_REASON,           
                      :S-CALL-BEFORE-MINUTS  AS CALL_BEFORE_MINUTS,     
                      :S-PHONE-NO            AS PHONE_NO,               
                      :S-PHONE-NO-EXT        AS PHONE_NO_EXT,           
                      :S-SERV-ORDER-REMARKS  AS SERV_ORDER_REMARKS,     
                      :S-SERV-ORDER-REMUPD   AS SERV_ORDER_REMUPD,      
                      :S-SPCL-INSTRUCTIONS   AS SPCL_INSTRUCTIONS,      
                      :S-PREMISE             AS PREMISE,                
                      :S-PREMISE-DIRECTIONS  AS PREMISE_DIRECTIONS,     
                      :S-CODE-ACCT-STAT      AS CODE_ACCT_STAT,         
                      :S-XS-FLOW-VALVE-FL    AS XS_FLOW_VALVE_FL,       
                      :S-SPLIT-SERVICE-FL    AS SPLIT_SERVICE_FL,       
                      :S-SERVICE-CHARGES     AS SERVICE_CHARGES,        
                      :S-COUNTY              AS COUNTY,                 
                      :S-TOTAL-BTU           AS TOTAL_BTU,              
                      :S-ALT-PHONE-NO        AS ALT_PHONE_NO,           
                      :S-ALT-PHONE-NO-EXT    AS ALT_PHONE_NO_EXT,       
A05020*         STRIP(:S-MADE-SAFE-DT)       AS MADE_SAFE_DT,                   
                      :S-HOME-ALL-DAY-FL     AS HOME_ALL_DAY_FL,        
                      :S-BUSINESS-UNIT       AS BUSINESS_UNIT,          
                      :S-DNP-CRITICAL-CUS    AS DNP_CRITICAL_CUS,       
                      :S-CIRCUIT-ID          AS CIRCUIT_ID,             
                      :S-CUST-PHASE-CD       AS CUST_PHASE_CD,          
                      :S-GRID-CELL           AS GRID_CELL,              
                      :S-POLE-NO             AS POLE_NO,                
                      :S-ASSIGNED-DATE       AS ASSIGNED_DATE,          
                      :S-COMPLIANCE-DAYS     AS COMPLIANCE_DAYS,        
                      :S-DUE-DAYS            AS DUE_DAYS,               
                      :S-MATERIAL-FL         AS MATERIAL_FL,            
                      :S-WORK-START-TIME     AS WORK_START_TIME,        
                      :S-WORK-STOP-TIME      AS WORK_STOP_TIME,         
                      :S-WORK-DISTRICT       AS WORK_DISTRICT,          
                      :S-OPTIMIZE-ORDER      AS OPTIMIZE_ORDER,         
                      :S-ORDER-STATE-CD      AS ORDER_STATE_CD,         
                      :S-RED-FLAG-SAFETY     AS RED_FLAG_SAFETY,        
                      :S-RED-FLAG-MAINT      AS RED_FLAG_MAINT,         
                      :S-RED-FLAG-STORM      AS RED_FLAG_STORM,         
                      :S-SO-SERVICE-CHRG     AS SO_SERVICE_CHRG,        
                      :S-GROUP-CODE          AS GROUP_CODE,             
                      :S-RLSE-NO-1           AS RLSE_NO,                
                      :S-ORDER-CANCEL        AS ORDER_CANCEL,           
                      :S-SO-COMPL-REMARKS    AS SO_COMPL_REMARKS,       
                      :S-DATE-RECVED         AS DATE_RECVED,            
A00520                :S-COMM-COMMENTS       AS COMM_COMMENTS,          
A00520                :S-DBA-NAME            AS DBA_NAME,               
A00520                :S-COMPLIANCE-DATE     AS COMPLIANCE_DATE,        
A00520                :S-TASK-TYPE           AS TASK_TYPE,              
A00520                :S-APPT-FL             AS APPT_FL,                
P01176                :S-SAMPLE-TEST         AS SAMPLE_TEST,            
A05020                :S-HOT-SPOT-FL         AS HOT_SPOT_FL             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1       AS RETURN_CODE,                    
MFA-TR*               :S-SERV-ORDER-NO       AS SERV_ORDER_NO ,                 
MFA-TR*               :S-SO-INST-SEQ-NO-1    AS SO_INST_SEQ_NO,                 
MFA-TR*               :S-WORK-TYPE-CD-1      AS WORK_TYPE_CD,                   
MFA-TR*               :S-WORK-TYPE-DESC-1    AS WORK_TYPE_DESC,                 
MFA-TR*               :S-CODE-UTIL-TYPE-1    AS CODE_UTIL_TYPE,                 
MFA-TR*               :S-ORDER-PRIORITY-CD   AS ORDER_PRIORITY_CD,              
MFA-TR*               :S-SO-EST-LABOR-HR     AS SO_EST_LABOR_HR,                
MFA-TR*               :S-COMPANY-NO          AS COMPANY_NO,                     
MFA-TR*               :S-LOCAL-OFFICE        AS LOCAL_OFFICE,                   
MFA-TR*               :S-ORDER-TYPE-CD       AS ORDER_TYPE_CD,                  
MFA-TR*               :S-ACCOUNT-NO          AS ACCOUNT_NO,                     
MFA-TR*               :S-FULL-NAME           AS FULL_NAME,                      
MFA-TR*               :S-STREET-ADDRESS      AS STREET_ADDRESS,                 
MFA-TR*               :S-HOUSE-NO            AS HOUSE_NO,                       
MFA-TR*               :S-ADDR-PREFIX-1       AS ADDR_PREFIX_1,                  
MFA-TR*               :S-ADDR-PREFIX-2       AS ADDR_PREFIX_2,                  
MFA-TR*               :S-STREET-NAME         AS STREET_NAME,                    
MFA-TR*               :S-STREET-SUFFIX       AS STREET_SUFFIX,                  
MFA-TR*               :S-ADDR-SUFFIX         AS ADDR_SUFFIX,                    
MFA-TR*               :S-STREET-LOCATION-1   AS STREET_LOCATION_1,              
MFA-TR*               :S-STREET-LOCATION-2   AS STREET_LOCATION_2,              
MFA-TR*               :S-ADDR-STREET         AS ADDR_STREET,                    
MFA-TR*               :S-ADDR-CITY-STATE     AS ADDR_CITY_STATE,                
MFA-TR*               :S-STATE               AS STATE,                          
MFA-TR*               :S-COUNTRY             AS COUNTRY,                        
MFA-TR*               :S-LATITUDE            AS LATITUDE,                       
MFA-TR*               :S-LONGITUDE           AS LONGITUDE,                      
MFA-TR*               :S-LOT                 AS LOT,                            
MFA-TR*               :S-BLOCK               AS BLOCK ,                         
MFA-TR*               :S-SUBDIVISION-DESC    AS SUBDIVISION_DESC,               
MFA-TR*               :S-SUBDIVISION-ID      AS SUBDIVISION_ID,                 
MFA-TR*               :S-ZIP-CODE            AS ZIP_CODE,                       
MFA-TR*               :S-ZIP-CODE-PLUS-FOUR  AS ZIP_CODE_PLUS_FOUR,             
MFA-TR*               :S-TOWN                AS TOWN ,                          
MFA-TR*               :S-ORDER-PLACED-BY     AS ORDER_PLACED_BY,                
MFA-TR*               :S-ORDER-REASON        AS ORDER_REASON,                   
MFA-TR*               :S-CALL-BEFORE-MINUTS  AS CALL_BEFORE_MINUTS,             
MFA-TR*               :S-PHONE-NO            AS PHONE_NO,                       
MFA-TR*               :S-PHONE-NO-EXT        AS PHONE_NO_EXT,                   
MFA-TR*               :S-SERV-ORDER-REMARKS  AS SERV_ORDER_REMARKS,             
MFA-TR*               :S-SERV-ORDER-REMUPD   AS SERV_ORDER_REMUPD,              
MFA-TR*               :S-SPCL-INSTRUCTIONS   AS SPCL_INSTRUCTIONS,              
MFA-TR*               :S-PREMISE             AS PREMISE,                        
MFA-TR*               :S-PREMISE-DIRECTIONS  AS PREMISE_DIRECTIONS,             
MFA-TR*               :S-CODE-ACCT-STAT      AS CODE_ACCT_STAT,                 
MFA-TR*               :S-XS-FLOW-VALVE-FL    AS XS_FLOW_VALVE_FL,               
MFA-TR*               :S-SPLIT-SERVICE-FL    AS SPLIT_SERVICE_FL,               
MFA-TR*               :S-SERVICE-CHARGES     AS SERVICE_CHARGES,                
MFA-TR*               :S-COUNTY              AS COUNTY,                         
MFA-TR*               :S-TOTAL-BTU           AS TOTAL_BTU,                      
MFA-TR*               :S-ALT-PHONE-NO        AS ALT_PHONE_NO,                   
MFA-TR*               :S-ALT-PHONE-NO-EXT    AS ALT_PHONE_NO_EXT,               
MFA-TR*         STRIP(:S-MADE-SAFE-DT)       AS MADE_SAFE_DT,                   
MFA-TR*               :S-HOME-ALL-DAY-FL     AS HOME_ALL_DAY_FL,                
MFA-TR*               :S-BUSINESS-UNIT       AS BUSINESS_UNIT,                  
MFA-TR*               :S-DNP-CRITICAL-CUS    AS DNP_CRITICAL_CUS,               
MFA-TR*               :S-CIRCUIT-ID          AS CIRCUIT_ID,                     
MFA-TR*               :S-CUST-PHASE-CD       AS CUST_PHASE_CD,                  
MFA-TR*               :S-GRID-CELL           AS GRID_CELL,                      
MFA-TR*               :S-POLE-NO             AS POLE_NO,                        
MFA-TR*               :S-ASSIGNED-DATE       AS ASSIGNED_DATE,                  
MFA-TR*               :S-COMPLIANCE-DAYS     AS COMPLIANCE_DAYS,                
MFA-TR*               :S-DUE-DAYS            AS DUE_DAYS,                       
MFA-TR*               :S-MATERIAL-FL         AS MATERIAL_FL,                    
MFA-TR*               :S-WORK-START-TIME     AS WORK_START_TIME,                
MFA-TR*               :S-WORK-STOP-TIME      AS WORK_STOP_TIME,                 
MFA-TR*               :S-WORK-DISTRICT       AS WORK_DISTRICT,                  
MFA-TR*               :S-OPTIMIZE-ORDER      AS OPTIMIZE_ORDER,                 
MFA-TR*               :S-ORDER-STATE-CD      AS ORDER_STATE_CD,                 
MFA-TR*               :S-RED-FLAG-SAFETY     AS RED_FLAG_SAFETY,                
MFA-TR*               :S-RED-FLAG-MAINT      AS RED_FLAG_MAINT,                 
MFA-TR*               :S-RED-FLAG-STORM      AS RED_FLAG_STORM,                 
MFA-TR*               :S-SO-SERVICE-CHRG     AS SO_SERVICE_CHRG,                
MFA-TR*               :S-GROUP-CODE          AS GROUP_CODE,                     
MFA-TR*               :S-RLSE-NO-1           AS RLSE_NO,                        
MFA-TR*               :S-ORDER-CANCEL        AS ORDER_CANCEL,                   
MFA-TR*               :S-SO-COMPL-REMARKS    AS SO_COMPL_REMARKS,               
MFA-TR*               :S-DATE-RECVED         AS DATE_RECVED,                    
MFA-TR*               :S-COMM-COMMENTS       AS COMM_COMMENTS,                  
MFA-TR*               :S-DBA-NAME            AS DBA_NAME,                       
MFA-TR*               :S-COMPLIANCE-DATE     AS COMPLIANCE_DATE,                
MFA-TR*               :S-TASK-TYPE           AS TASK_TYPE,                      
MFA-TR*               :S-APPT-FL             AS APPT_FL,                        
MFA-TR*               :S-SAMPLE-TEST         AS SAMPLE_TEST,                    
MFA-TR*               :S-HOT-SPOT-FL         AS HOT_SPOT_FL                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                AS RETURN_CODE,             
                 SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,          
                 LTRIM(RTRIM(APPLIANCE_CD))        AS APPLIANCE_CD,            
                 CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,          
                 LEAK_IND                   AS LEAK_IND,                
                 LIGHT_IND                  AS LIGHT_IND,               
                 REPAIR_IND                 AS REPAIR_IND,              
                 CUTOFF_IND                 AS CUTOFF_IND,              
                 CAUTION_TAG_IND            AS CAUTION_TAG_IND,         
                 CONDITION_CD               AS CONDITION_CD,            
                 REPLACE_APP_FL             AS REPLACE_APP_FL,          
                 INSTALL_DT                 AS INSTALL_DT,              
                 LTRIM(RTRIM(APPLIANCE_COMMENTS))  AS 
           APPLIANCE_COMMENTS,      
                 TAG_NO                     AS TAG_NO,                  
                 CAUTION_TAG_DT             AS CAUTION_TAG_DT,          
                 EQUIPMENT_UNQ              AS EQUIPMENT_UNQ            
              FROM #CSR04584_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                AS RETURN_CODE,                     
MFA-TR*          SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,                  
MFA-TR*          STRIP(APPLIANCE_CD)        AS APPLIANCE_CD,                    
MFA-TR*          CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,                  
MFA-TR*          LEAK_IND                   AS LEAK_IND,                        
MFA-TR*          LIGHT_IND                  AS LIGHT_IND,                       
MFA-TR*          REPAIR_IND                 AS REPAIR_IND,                      
MFA-TR*          CUTOFF_IND                 AS CUTOFF_IND,                      
MFA-TR*          CAUTION_TAG_IND            AS CAUTION_TAG_IND,                 
MFA-TR*          CONDITION_CD               AS CONDITION_CD,                    
MFA-TR*          REPLACE_APP_FL             AS REPLACE_APP_FL,                  
MFA-TR*          INSTALL_DT                 AS INSTALL_DT,                      
MFA-TR*          STRIP(APPLIANCE_COMMENTS)  AS APPLIANCE_COMMENTS,              
MFA-TR*          TAG_NO                     AS TAG_NO,                          
MFA-TR*          CAUTION_TAG_DT             AS CAUTION_TAG_DT,                  
MFA-TR*          EQUIPMENT_UNQ              AS EQUIPMENT_UNQ                    
MFA-TR*       FROM SESSION.CSR04584_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-SO-INST-SEQ-NO-2   AS SO_INST_SEQ_NO,          
                      :S-APPLIANCE-CD       AS APPLIANCE_CD,            
                      :S-CODE-UTIL-TYPE-2   AS CODE_UTIL_TYPE,          
                      :S-LEAK-IND           AS LEAK_IND,                
                      :S-LIGHT-IND          AS LIGHT_IND,               
                      :S-REPAIR-IND         AS REPAIR_IND,              
                      :S-CUTOFF-IND         AS CUTOFF_IND,              
                      :S-CAUTION-TAG-IND    AS CAUTION_TAG_IND,         
                      :S-CONDITION-CD       AS CONDITION_CD,            
                      :S-REPLACE-APP-FL     AS REPLACE_APP_FL,          
                      :S-INSTALL-DT         AS INSTALL_DT,              
                      :S-APPLIANCE-COMMENTS AS APPLIANCE_COMMENTS,      
                      :S-TAG-NO             AS TAG_NO,                  
                      :S-CAUTION-TAG-DT     AS CAUTION_TAG_DT,          
                      :S-EQUIPMENT-UNQ      AS EQUIPMENT_UNQ            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-SO-INST-SEQ-NO-2   AS SO_INST_SEQ_NO,                  
MFA-TR*               :S-APPLIANCE-CD       AS APPLIANCE_CD,                    
MFA-TR*               :S-CODE-UTIL-TYPE-2   AS CODE_UTIL_TYPE,                  
MFA-TR*               :S-LEAK-IND           AS LEAK_IND,                        
MFA-TR*               :S-LIGHT-IND          AS LIGHT_IND,                       
MFA-TR*               :S-REPAIR-IND         AS REPAIR_IND,                      
MFA-TR*               :S-CUTOFF-IND         AS CUTOFF_IND,                      
MFA-TR*               :S-CAUTION-TAG-IND    AS CAUTION_TAG_IND,                 
MFA-TR*               :S-CONDITION-CD       AS CONDITION_CD,                    
MFA-TR*               :S-REPLACE-APP-FL     AS REPLACE_APP_FL,                  
MFA-TR*               :S-INSTALL-DT         AS INSTALL_DT,                      
MFA-TR*               :S-APPLIANCE-COMMENTS AS APPLIANCE_COMMENTS,              
MFA-TR*               :S-TAG-NO             AS TAG_NO,                          
MFA-TR*               :S-CAUTION-TAG-DT     AS CAUTION_TAG_DT,                  
MFA-TR*               :S-EQUIPMENT-UNQ      AS EQUIPMENT_UNQ                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE               AS RETURN_CODE,              
                 SO_INST_SEQ_NO            AS SO_INST_SEQ_NO,           
                 REG_CHARGEABLE_HRS        AS REG_CHARGEABLE_HRS,       
                 OT_CHARGEABLE_HRS         AS OT_CHARGEABLE_HRS,        
                 LTRIM(RTRIM(CHARGES_COMMENTS))   AS CHARGES_COMMENTS,         
                 LTRIM(RTRIM(WORK_PERIOD_CD))     AS WORK_PERIOD_CD,           
                 LTRIM(RTRIM(WAIVER_TYPE_CD))     AS WAIVER_TYPE_CD,           
                 MATERIAL_CHRG             AS MATERIAL_CHRG,            
                 CODE_UTIL_TYPE            AS CODE_UTIL_TYPE            
              FROM #CSR04584_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE               AS RETURN_CODE,                      
MFA-TR*          SO_INST_SEQ_NO            AS SO_INST_SEQ_NO,                   
MFA-TR*          REG_CHARGEABLE_HRS        AS REG_CHARGEABLE_HRS,               
MFA-TR*          OT_CHARGEABLE_HRS         AS OT_CHARGEABLE_HRS,                
MFA-TR*          STRIP(CHARGES_COMMENTS)   AS CHARGES_COMMENTS,                 
MFA-TR*          STRIP(WORK_PERIOD_CD)     AS WORK_PERIOD_CD,                   
MFA-TR*          STRIP(WAIVER_TYPE_CD)     AS WAIVER_TYPE_CD,                   
MFA-TR*          MATERIAL_CHRG             AS MATERIAL_CHRG,                    
MFA-TR*          CODE_UTIL_TYPE            AS CODE_UTIL_TYPE                    
MFA-TR*       FROM SESSION.CSR04584_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3      AS RETURN_CODE,             
                      :S-SO-INST-SEQ-NO-3   AS SO_INST_SEQ_NO,          
                      :S-REG-CHARGEABLE-HRS AS REG_CHARGEABLE_HRS,      
                      :S-OT-CHARGEABLE-HRS  AS OT_CHARGEABLE_HRS,       
                      :S-CHARGES-COMMENTS   AS CHARGES_COMMENTS,        
                      :S-WORK-PERIOD-CD     AS WORK_PERIOD_CD,          
                      :S-WAIVER-TYPE-CD     AS WAIVER_TYPE_CD,          
                      :S-MATERIAL-CHRG      AS MATERIAL_CHRG,           
                      :S-CODE-UTIL-TYPE-3   AS CODE_UTIL_TYPE           
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3      AS RETURN_CODE,                     
MFA-TR*               :S-SO-INST-SEQ-NO-3   AS SO_INST_SEQ_NO,                  
MFA-TR*               :S-REG-CHARGEABLE-HRS AS REG_CHARGEABLE_HRS,              
MFA-TR*               :S-OT-CHARGEABLE-HRS  AS OT_CHARGEABLE_HRS,               
MFA-TR*               :S-CHARGES-COMMENTS   AS CHARGES_COMMENTS,                
MFA-TR*               :S-WORK-PERIOD-CD     AS WORK_PERIOD_CD,                  
MFA-TR*               :S-WAIVER-TYPE-CD     AS WAIVER_TYPE_CD,                  
MFA-TR*               :S-MATERIAL-CHRG      AS MATERIAL_CHRG,                   
MFA-TR*               :S-CODE-UTIL-TYPE-3   AS CODE_UTIL_TYPE                   
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                AS RETURN_CODE,             
                 SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,          
                 CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,          
                 WORK_TYPE_CD               AS WORK_TYPE_CD,            
                 WORK_TYPE_DESC             AS WORK_TYPE_DESC,          
                 METER_NO                   AS METER_NO,                
                 IC_NO                      AS IC_NO,                   
                 MTR_REF_NO                 AS MTR_REF_NO,              
                 CODE_DEST                  AS CODE_DEST,               
                 LTRIM(RTRIM(DEST_NO))             AS DEST_NO,                 
                 LTRIM(RTRIM(CODE_MTR_STATUS_WS))  AS 
           CODE_MTR_STATUS_WS,      
                 MTR_READ_VALUE_IS          AS MTR_READ_VALUE_IS,       
                 METER_SUPPLYING            AS METER_SUPPLYING,         
                 READ_ROUTE                 AS READ_ROUTE,              
                 READ_CYCLE                 AS READ_CYCLE,              
                 LTRIM(RTRIM(SPCL_READ_INSTR))     AS SPCL_READ_INSTR,         
                 LTRIM(RTRIM(MTR_CODE_TIME_PERIOD)) AS 
           MTR_CODE_TIME_PERIOD,   
                 REG_ID_NO                  AS REG_ID_NO,               
                 CONSTANT                   AS CONSTANT,                
                 MTR_NO_DIALS               AS MTR_NO_DIALS,            
                 METER_SIZE_ID              AS METER_SIZE_ID,           
                 CODE_METER_LOC             AS CODE_METER_LOC,          
                 METER_POINT_ID             AS METER_POINT_ID,          
                 LTRIM(RTRIM(SUBSTATION_ID))       AS SUBSTATION_ID,           
                 RATE_PLAN_NO               AS RATE_PLAN_NO,            
                 CODE_REVENUE_CLASS         AS CODE_REVENUE_CLASS,      
                 LOCK_TYPE_ID               AS LOCK_TYPE_ID,            
                 LTRIM(RTRIM(CODE_MAKE))           AS CODE_MAKE,               
                 AMPS                       AS AMPS,                    
                 NO_WIRES                   AS NO_WIRES,                
                 VOLTAGE                    AS VOLTAGE,                 
                 LTRIM(RTRIM(MTR_CONNECT_TYPE_ID)) AS 
           MTR_CONNECT_TYPE_ID,     
                 LTRIM(RTRIM(CASE_PRESSURE))       AS CASE_PRESSURE,           
                 RLSE_NO                    AS RLSE_NO,                 
                 RLSE_DATE                  AS RLSE_DATE,               
                 MTR_MAX_NO_UNITS           AS MTR_MAX_NO_UNITS,        
                 MTR_MIN_NO_UNITS           AS MTR_MIN_NO_UNITS,        
                 MTR_USAGE_HIGH_PCT         AS MTR_USAGE_HIGH_PCT,      
                 MTR_USAGE_LOW_PCT          AS MTR_USAGE_LOW_PCT,       
                 LAST_MTR_READ_VALUE        AS LAST_MTR_READ_VALUE,     
                 LAST_MTR_READ_DATE         AS LAST_MTR_READ_DATE,      
                 REMOTE_READ_IND            AS REMOTE_READ_IND,         
                 MTR_ACCESSIBLE_CD          AS MTR_ACCESSIBLE_CD,       
                 MTR_ACCESSIBLE_DT          AS MTR_ACCESSIBLE_DT,       
                 MTR_ACCESSIBLE_RSN         AS MTR_ACCESSIBLE_RSN,      
                 LTRIM(RTRIM(MTR_CODE_STATUS_REASON))                          
                                            AS MTR_CODE_STATUS_REASON,  
                 NUMBER_OF_DRIVE            AS NUMBER_OF_DRIVE,         
                 ELEC_MTR_FORM_CD           AS ELEC_MTR_FORM_CD ,       
                 READ_SEQUENCE_NO           AS READ_SEQUENCE_NO,        
                 LTRIM(RTRIM(MTR_RD_DISP_CD))      AS MTR_RD_DISP_CD,          
                 LTRIM(RTRIM(INDEX_VALUE_CD))      AS INDEX_VALUE_CD,          
                 NO_READ_DIGITS             AS NO_READ_DIGITS,          
                 NO_READ_DECIMALS           AS NO_READ_DECIMALS         
              FROM #CSR04584_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                AS RETURN_CODE,                     
MFA-TR*          SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,                  
MFA-TR*          CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,                  
MFA-TR*          WORK_TYPE_CD               AS WORK_TYPE_CD,                    
MFA-TR*          WORK_TYPE_DESC             AS WORK_TYPE_DESC,                  
MFA-TR*          METER_NO                   AS METER_NO,                        
MFA-TR*          IC_NO                      AS IC_NO,                           
MFA-TR*          MTR_REF_NO                 AS MTR_REF_NO,                      
MFA-TR*          CODE_DEST                  AS CODE_DEST,                       
MFA-TR*          STRIP(DEST_NO)             AS DEST_NO,                         
MFA-TR*          STRIP(CODE_MTR_STATUS_WS)  AS CODE_MTR_STATUS_WS,              
MFA-TR*          MTR_READ_VALUE_IS          AS MTR_READ_VALUE_IS,               
MFA-TR*          METER_SUPPLYING            AS METER_SUPPLYING,                 
MFA-TR*          READ_ROUTE                 AS READ_ROUTE,                      
MFA-TR*          READ_CYCLE                 AS READ_CYCLE,                      
MFA-TR*          STRIP(SPCL_READ_INSTR)     AS SPCL_READ_INSTR,                 
MFA-TR*          STRIP(MTR_CODE_TIME_PERIOD) AS MTR_CODE_TIME_PERIOD,           
MFA-TR*          REG_ID_NO                  AS REG_ID_NO,                       
MFA-TR*          CONSTANT                   AS CONSTANT,                        
MFA-TR*          MTR_NO_DIALS               AS MTR_NO_DIALS,                    
MFA-TR*          METER_SIZE_ID              AS METER_SIZE_ID,                   
MFA-TR*          CODE_METER_LOC             AS CODE_METER_LOC,                  
MFA-TR*          METER_POINT_ID             AS METER_POINT_ID,                  
MFA-TR*          STRIP(SUBSTATION_ID)       AS SUBSTATION_ID,                   
MFA-TR*          RATE_PLAN_NO               AS RATE_PLAN_NO,                    
MFA-TR*          CODE_REVENUE_CLASS         AS CODE_REVENUE_CLASS,              
MFA-TR*          LOCK_TYPE_ID               AS LOCK_TYPE_ID,                    
MFA-TR*          STRIP(CODE_MAKE)           AS CODE_MAKE,                       
MFA-TR*          AMPS                       AS AMPS,                            
MFA-TR*          NO_WIRES                   AS NO_WIRES,                        
MFA-TR*          VOLTAGE                    AS VOLTAGE,                         
MFA-TR*          STRIP(MTR_CONNECT_TYPE_ID) AS MTR_CONNECT_TYPE_ID,             
MFA-TR*          STRIP(CASE_PRESSURE)       AS CASE_PRESSURE,                   
MFA-TR*          RLSE_NO                    AS RLSE_NO,                         
MFA-TR*          RLSE_DATE                  AS RLSE_DATE,                       
MFA-TR*          MTR_MAX_NO_UNITS           AS MTR_MAX_NO_UNITS,                
MFA-TR*          MTR_MIN_NO_UNITS           AS MTR_MIN_NO_UNITS,                
MFA-TR*          MTR_USAGE_HIGH_PCT         AS MTR_USAGE_HIGH_PCT,              
MFA-TR*          MTR_USAGE_LOW_PCT          AS MTR_USAGE_LOW_PCT,               
MFA-TR*          LAST_MTR_READ_VALUE        AS LAST_MTR_READ_VALUE,             
MFA-TR*          LAST_MTR_READ_DATE         AS LAST_MTR_READ_DATE,              
MFA-TR*          REMOTE_READ_IND            AS REMOTE_READ_IND,                 
MFA-TR*          MTR_ACCESSIBLE_CD          AS MTR_ACCESSIBLE_CD,               
MFA-TR*          MTR_ACCESSIBLE_DT          AS MTR_ACCESSIBLE_DT,               
MFA-TR*          MTR_ACCESSIBLE_RSN         AS MTR_ACCESSIBLE_RSN,              
MFA-TR*          STRIP(MTR_CODE_STATUS_REASON)                                  
MFA-TR*                                     AS MTR_CODE_STATUS_REASON,          
MFA-TR*          NUMBER_OF_DRIVE            AS NUMBER_OF_DRIVE,                 
MFA-TR*          ELEC_MTR_FORM_CD           AS ELEC_MTR_FORM_CD ,               
MFA-TR*          READ_SEQUENCE_NO           AS READ_SEQUENCE_NO,                
MFA-TR*          STRIP(MTR_RD_DISP_CD)      AS MTR_RD_DISP_CD,                  
MFA-TR*          STRIP(INDEX_VALUE_CD)      AS INDEX_VALUE_CD,                  
MFA-TR*          NO_READ_DIGITS             AS NO_READ_DIGITS,                  
MFA-TR*          NO_READ_DECIMALS           AS NO_READ_DECIMALS                 
MFA-TR*       FROM SESSION.CSR04584_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4        AS RETURN_CODE,           
                      :S-SO-INST-SEQ-NO-4     AS SO_INST_SEQ_NO,        
                      :S-CODE-UTIL-TYPE-4     AS CODE_UTIL_TYPE,        
                      :S-WORK-TYPE-CD-4       AS WORK_TYPE_CD,          
                      :S-WORK-TYPE-DESC-4     AS WORK_TYPE_DESC,        
                      :S-METER-NO-4           AS METER_NO,              
                      :S-IC-NO-4              AS IC_NO,                 
                      :S-MTR-REF-NO-4         AS MTR_REF_NO,            
                      :S-CODE-DEST            AS CODE_DEST,             
                      :S-DEST-NO              AS DEST_NO,               
                      :S-CODE-MTR-STATUS-WS   AS CODE_MTR_STATUS_WS,    
                      :S-READ-VALUE-IS-4      AS MTR_READ_VALUE_IS,     
                      :S-METER-SUPPLYING      AS METER_SUPPLYING,       
                      :S-READ-ROUTE           AS READ_ROUTE,            
                      :S-READ-CYCLE           AS READ_CYCLE,            
                      :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,       
                      :S-CODE-TIME-PERIOD-4   AS MTR_CODE_TIME_PERIOD,  
                      :S-REG-ID-NO-4          AS REG_ID_NO,             
                      :S-CONSTANT             AS CONSTANT,              
                      :S-NO-DIALS-4           AS MTR_NO_DIALS,          
                      :S-METER-SIZE-ID        AS METER_SIZE_ID,         
                      :S-CODE-METER-LOC       AS CODE_METER_LOC,        
                      :S-METER-POINT-ID       AS METER_POINT_ID,        
                      :S-SUBSTATION-ID        AS SUBSTATION_ID,         
                      :S-RATE-PLAN-NO         AS RATE_PLAN_NO,          
                      :S-CODE-REVENUE-CLASS   AS CODE_REVENUE_CLASS,    
                      :S-LOCK-TYPE-ID         AS LOCK_TYPE_ID,          
                      :S-CODE-MAKE            AS CODE_MAKE,             
                      :S-AMPS                 AS AMPS,                  
                      :S-NO-WIRES             AS NO_WIRES,              
                      :S-VOLTAGE              AS VOLTAGE,               
                      :S-MTR-CONNECT-TYPE-ID  AS MTR_CONNECT_TYPE_ID,   
                      :S-CASE-PRESSURE        AS CASE_PRESSURE,         
                      :S-RLSE-NO              AS RLSE_NO,               
                      :S-RLSE-DATE            AS RLSE_DATE,             
                      :S-MAX-NO-UNITS-4       AS MTR_MAX_NO_UNITS,      
                      :S-MIN-NO-UNITS-4       AS MTR_MIN_NO_UNITS,      
                      :S-USAGE-HIGH-PCT-4     AS MTR_USAGE_HIGH_PCT,    
                      :S-USAGE-LOW-PCT-4      AS MTR_USAGE_LOW_PCT,     
                      :S-LAST-MTR-READ-VALUE  AS LAST_MTR_READ_VALUE,   
                      :S-LAST-MTR-READ-DATE   AS LAST_MTR_READ_DATE,    
                      :S-REMOTE-READ-IND      AS REMOTE_READ_IND,       
                      :S-MTR-ACCESSIBLE-CD    AS MTR_ACCESSIBLE_CD,     
                      :S-MTR-ACCESSIBLE-DT    AS MTR_ACCESSIBLE_DT,     
                      :S-MTR-ACCESSIBLE-RSN   AS MTR_ACCESSIBLE_RSN,    
                      :S-CODE-STATUS-REASON-4 AS MTR_CODE_STATUS_REASON,
                      :S-NUMBER-OF-DRIVE      AS NUMBER_OF_DRIVE,       
                      :S-ELEC-MTR-FORM-CD     AS ELEC_MTR_FORM_CD,      
                      :S-READ-SEQUENCE-NO-4   AS READ_SEQUENCE_NO,      
                      :S-MTR-RD-DISP-CD-4     AS MTR_RD_DISP_CD,        
                      :S-INDEX-VALUE-CD-4     AS INDEX_VALUE_CD,        
                      :S-NO-READ-DIGITS-4     AS NO_READ_DIGITS,        
                      :S-NO-READ-DECIMALS-4   AS NO_READ_DECIMALS       
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4        AS RETURN_CODE,                   
MFA-TR*               :S-SO-INST-SEQ-NO-4     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-CODE-UTIL-TYPE-4     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-WORK-TYPE-CD-4       AS WORK_TYPE_CD,                  
MFA-TR*               :S-WORK-TYPE-DESC-4     AS WORK_TYPE_DESC,                
MFA-TR*               :S-METER-NO-4           AS METER_NO,                      
MFA-TR*               :S-IC-NO-4              AS IC_NO,                         
MFA-TR*               :S-MTR-REF-NO-4         AS MTR_REF_NO,                    
MFA-TR*               :S-CODE-DEST            AS CODE_DEST,                     
MFA-TR*               :S-DEST-NO              AS DEST_NO,                       
MFA-TR*               :S-CODE-MTR-STATUS-WS   AS CODE_MTR_STATUS_WS,            
MFA-TR*               :S-READ-VALUE-IS-4      AS MTR_READ_VALUE_IS,             
MFA-TR*               :S-METER-SUPPLYING      AS METER_SUPPLYING,               
MFA-TR*               :S-READ-ROUTE           AS READ_ROUTE,                    
MFA-TR*               :S-READ-CYCLE           AS READ_CYCLE,                    
MFA-TR*               :S-SPCL-READ-INSTR      AS SPCL_READ_INSTR,               
MFA-TR*               :S-CODE-TIME-PERIOD-4   AS MTR_CODE_TIME_PERIOD,          
MFA-TR*               :S-REG-ID-NO-4          AS REG_ID_NO,                     
MFA-TR*               :S-CONSTANT             AS CONSTANT,                      
MFA-TR*               :S-NO-DIALS-4           AS MTR_NO_DIALS,                  
MFA-TR*               :S-METER-SIZE-ID        AS METER_SIZE_ID,                 
MFA-TR*               :S-CODE-METER-LOC       AS CODE_METER_LOC,                
MFA-TR*               :S-METER-POINT-ID       AS METER_POINT_ID,                
MFA-TR*               :S-SUBSTATION-ID        AS SUBSTATION_ID,                 
MFA-TR*               :S-RATE-PLAN-NO         AS RATE_PLAN_NO,                  
MFA-TR*               :S-CODE-REVENUE-CLASS   AS CODE_REVENUE_CLASS,            
MFA-TR*               :S-LOCK-TYPE-ID         AS LOCK_TYPE_ID,                  
MFA-TR*               :S-CODE-MAKE            AS CODE_MAKE,                     
MFA-TR*               :S-AMPS                 AS AMPS,                          
MFA-TR*               :S-NO-WIRES             AS NO_WIRES,                      
MFA-TR*               :S-VOLTAGE              AS VOLTAGE,                       
MFA-TR*               :S-MTR-CONNECT-TYPE-ID  AS MTR_CONNECT_TYPE_ID,           
MFA-TR*               :S-CASE-PRESSURE        AS CASE_PRESSURE,                 
MFA-TR*               :S-RLSE-NO              AS RLSE_NO,                       
MFA-TR*               :S-RLSE-DATE            AS RLSE_DATE,                     
MFA-TR*               :S-MAX-NO-UNITS-4       AS MTR_MAX_NO_UNITS,              
MFA-TR*               :S-MIN-NO-UNITS-4       AS MTR_MIN_NO_UNITS,              
MFA-TR*               :S-USAGE-HIGH-PCT-4     AS MTR_USAGE_HIGH_PCT,            
MFA-TR*               :S-USAGE-LOW-PCT-4      AS MTR_USAGE_LOW_PCT,             
MFA-TR*               :S-LAST-MTR-READ-VALUE  AS LAST_MTR_READ_VALUE,           
MFA-TR*               :S-LAST-MTR-READ-DATE   AS LAST_MTR_READ_DATE,            
MFA-TR*               :S-REMOTE-READ-IND      AS REMOTE_READ_IND,               
MFA-TR*               :S-MTR-ACCESSIBLE-CD    AS MTR_ACCESSIBLE_CD,             
MFA-TR*               :S-MTR-ACCESSIBLE-DT    AS MTR_ACCESSIBLE_DT,             
MFA-TR*               :S-MTR-ACCESSIBLE-RSN   AS MTR_ACCESSIBLE_RSN,            
MFA-TR*               :S-CODE-STATUS-REASON-4 AS MTR_CODE_STATUS_REASON,        
MFA-TR*               :S-NUMBER-OF-DRIVE      AS NUMBER_OF_DRIVE,               
MFA-TR*               :S-ELEC-MTR-FORM-CD     AS ELEC_MTR_FORM_CD,              
MFA-TR*               :S-READ-SEQUENCE-NO-4   AS READ_SEQUENCE_NO,              
MFA-TR*               :S-MTR-RD-DISP-CD-4     AS MTR_RD_DISP_CD,                
MFA-TR*               :S-INDEX-VALUE-CD-4     AS INDEX_VALUE_CD,                
MFA-TR*               :S-NO-READ-DIGITS-4     AS NO_READ_DIGITS,                
MFA-TR*               :S-NO-READ-DECIMALS-4   AS NO_READ_DECIMALS               
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                AS RETURN_CODE,             
                 SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,          
                 REG_ID_NO                  AS REG_ID_NO,               
                 METER_NO                   AS METER_NO,                
                 IC_NO                      AS IC_NO,                   
                 MTR_REF_NO                 AS MTR_REF_NO,              
                 CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,          
                 READ_SEQUENCE_NO           AS READ_SEQUENCE_NO,        
                 REG_READ_VALUE_IS          AS REG_READ_VALUE_IS,       
                 LTRIM(RTRIM(MTR_RD_DISP_CD))      AS MTR_RD_DISP_CD,          
                 LTRIM(RTRIM(REG_CODE_TIME_PERIOD)) AS 
           REG_CODE_TIME_PERIOD,   
                 LTRIM(RTRIM(INDEX_VALUE_CD))       AS INDEX_VALUE_CD,         
                 LTRIM(RTRIM(REG_CODE_STATUS_REASON))                          
                                            AS REG_CODE_STATUS_REASON,  
                 REG_MAX_NO_UNITS           AS REG_MAX_NO_UNITS,        
                 REG_MIN_NO_UNITS           AS REG_MIN_NO_UNITS,        
                 REG_USAGE_HIGH_PCT         AS REG_USAGE_HIGH_PCT,      
                 REG_USAGE_LOW_PCT          AS REG_USAGE_LOW_PCT,       
                 LAST_REG_READ_VALUE        AS LAST_REG_READ_VALUE,     
                 REG_NO_DIALS               AS REG_NO_DIALS,            
                 LTRIM(RTRIM(CODE_REG_STATUS_WS))  AS 
           CODE_REG_STATUS_WS,      
A05020           LTRIM(RTRIM(LAST_REG_READ_DT))    AS LAST_REG_READ_DT,        
A05020           LTRIM(RTRIM(NO_READ_DIGITS))      AS NO_READ_DIGITS,          
A05020           LTRIM(RTRIM(NO_READ_DECIMALS))    AS NO_READ_DECIMALS         
              FROM #CSR04584_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                AS RETURN_CODE,                     
MFA-TR*          SO_INST_SEQ_NO             AS SO_INST_SEQ_NO,                  
MFA-TR*          REG_ID_NO                  AS REG_ID_NO,                       
MFA-TR*          METER_NO                   AS METER_NO,                        
MFA-TR*          IC_NO                      AS IC_NO,                           
MFA-TR*          MTR_REF_NO                 AS MTR_REF_NO,                      
MFA-TR*          CODE_UTIL_TYPE             AS CODE_UTIL_TYPE,                  
MFA-TR*          READ_SEQUENCE_NO           AS READ_SEQUENCE_NO,                
MFA-TR*          REG_READ_VALUE_IS          AS REG_READ_VALUE_IS,               
MFA-TR*          STRIP(MTR_RD_DISP_CD)      AS MTR_RD_DISP_CD,                  
MFA-TR*          STRIP(REG_CODE_TIME_PERIOD) AS REG_CODE_TIME_PERIOD,           
MFA-TR*          STRIP(INDEX_VALUE_CD)       AS INDEX_VALUE_CD,                 
MFA-TR*          STRIP(REG_CODE_STATUS_REASON)                                  
MFA-TR*                                     AS REG_CODE_STATUS_REASON,          
MFA-TR*          REG_MAX_NO_UNITS           AS REG_MAX_NO_UNITS,                
MFA-TR*          REG_MIN_NO_UNITS           AS REG_MIN_NO_UNITS,                
MFA-TR*          REG_USAGE_HIGH_PCT         AS REG_USAGE_HIGH_PCT,              
MFA-TR*          REG_USAGE_LOW_PCT          AS REG_USAGE_LOW_PCT,               
MFA-TR*          LAST_REG_READ_VALUE        AS LAST_REG_READ_VALUE,             
MFA-TR*          REG_NO_DIALS               AS REG_NO_DIALS,                    
MFA-TR*          STRIP(CODE_REG_STATUS_WS)  AS CODE_REG_STATUS_WS,              
MFA-TR*          STRIP(LAST_REG_READ_DT)    AS LAST_REG_READ_DT,                
MFA-TR*          STRIP(NO_READ_DIGITS)      AS NO_READ_DIGITS,                  
MFA-TR*          STRIP(NO_READ_DECIMALS)    AS NO_READ_DECIMALS                 
MFA-TR*       FROM SESSION.CSR04584_R5                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5        AS RETURN_CODE,           
                      :S-SO-INST-SEQ-NO-5     AS SO_INST_SEQ_NO,        
                      :S-REG-ID-NO-5          AS REG_ID_NO,             
                      :S-METER-NO-5           AS METER_NO,              
                      :S-IC-NO-5              AS IC_NO,                 
                      :S-MTR-REF-NO-5         AS MTR_REF_NO,            
                      :S-CODE-UTIL-TYPE-5     AS CODE_UTIL_TYPE,        
                      :S-READ-SEQUENCE-NO     AS READ_SEQUENCE_NO,      
                      :S-READ-VALUE-IS-5      AS REG_READ_VALUE_IS,     
                      :S-MTR-RD-DISP-CD       AS MTR_RD_DISP_CD,        
                      :S-CODE-TIME-PERIOD-5   AS REG_CODE_TIME_PERIOD,  
                      :S-INDEX-VALUE-CD       AS INDEX_VALUE_CD,        
                      :S-CODE-STATUS-REASON-5 AS REG_CODE_STATUS_REASON,
                      :S-MAX-NO-UNITS-5       AS REG_MAX_NO_UNITS,      
                      :S-MIN-NO-UNITS-5       AS REG_MIN_NO_UNITS,      
                      :S-USAGE-HIGH-PCT-5     AS REG_USAGE_HIGH_PCT,    
                      :S-USAGE-LOW-PCT-5      AS REG_USAGE_LOW_PCT,     
                      :S-LAST-REG-READ-VALUE  AS LAST_REG_READ_VALUE,   
                      :S-NO-DIALS-5           AS REG_NO_DIALS,          
                      :S-CODE-REG-STATUS-WS   AS CODE_REG_STATUS_WS,    
A05020                :S-LAST-REG-READ-DT     AS LAST_REG_READ_DT,      
A05020                :S-NO-READ-DIGITS       AS NO_READ_DIGITS,        
A05020                :S-NO-READ-DECIMALS     AS NO_READ_DECIMALS       
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5        AS RETURN_CODE,                   
MFA-TR*               :S-SO-INST-SEQ-NO-5     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-REG-ID-NO-5          AS REG_ID_NO,                     
MFA-TR*               :S-METER-NO-5           AS METER_NO,                      
MFA-TR*               :S-IC-NO-5              AS IC_NO,                         
MFA-TR*               :S-MTR-REF-NO-5         AS MTR_REF_NO,                    
MFA-TR*               :S-CODE-UTIL-TYPE-5     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-READ-SEQUENCE-NO     AS READ_SEQUENCE_NO,              
MFA-TR*               :S-READ-VALUE-IS-5      AS REG_READ_VALUE_IS,             
MFA-TR*               :S-MTR-RD-DISP-CD       AS MTR_RD_DISP_CD,                
MFA-TR*               :S-CODE-TIME-PERIOD-5   AS REG_CODE_TIME_PERIOD,          
MFA-TR*               :S-INDEX-VALUE-CD       AS INDEX_VALUE_CD,                
MFA-TR*               :S-CODE-STATUS-REASON-5 AS REG_CODE_STATUS_REASON,        
MFA-TR*               :S-MAX-NO-UNITS-5       AS REG_MAX_NO_UNITS,              
MFA-TR*               :S-MIN-NO-UNITS-5       AS REG_MIN_NO_UNITS,              
MFA-TR*               :S-USAGE-HIGH-PCT-5     AS REG_USAGE_HIGH_PCT,            
MFA-TR*               :S-USAGE-LOW-PCT-5      AS REG_USAGE_LOW_PCT,             
MFA-TR*               :S-LAST-REG-READ-VALUE  AS LAST_REG_READ_VALUE,           
MFA-TR*               :S-NO-DIALS-5           AS REG_NO_DIALS,                  
MFA-TR*               :S-CODE-REG-STATUS-WS   AS CODE_REG_STATUS_WS,            
MFA-TR*               :S-LAST-REG-READ-DT     AS LAST_REG_READ_DT,              
MFA-TR*               :S-NO-READ-DIGITS       AS NO_READ_DIGITS,                
MFA-TR*               :S-NO-READ-DECIMALS     AS NO_READ_DECIMALS               
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C6 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                  AS RETURN_CODE,           
                 SO_INST_SEQ_NO               AS SO_INST_SEQ_NO,        
                 REG_ID_NO                    AS REG_ID_NO,             
                 METER_NO                     AS METER_NO,              
                 IC_NO                        AS IC_NO,                 
                 MTR_REF_NO                   AS MTR_REF_NO,            
                 CODE_UTIL_TYPE               AS CODE_UTIL_TYPE,        
                 DEVICE_NO                    AS DEVICE_NO,             
                 CODE_ATT_TYPE                AS CODE_ATT_TYPE,         
                 ATT_CODE_STATUS_REASON       AS ATT_CODE_STATUS_REASON,
                 ATT_READ_VALUE_IS            AS ATT_READ_VALUE_IS      
              FROM #CSR04584_R6                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C6 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                  AS RETURN_CODE,                   
MFA-TR*          SO_INST_SEQ_NO               AS SO_INST_SEQ_NO,                
MFA-TR*          REG_ID_NO                    AS REG_ID_NO,                     
MFA-TR*          METER_NO                     AS METER_NO,                      
MFA-TR*          IC_NO                        AS IC_NO,                         
MFA-TR*          MTR_REF_NO                   AS MTR_REF_NO,                    
MFA-TR*          CODE_UTIL_TYPE               AS CODE_UTIL_TYPE,                
MFA-TR*          DEVICE_NO                    AS DEVICE_NO,                     
MFA-TR*          CODE_ATT_TYPE                AS CODE_ATT_TYPE,                 
MFA-TR*          ATT_CODE_STATUS_REASON       AS ATT_CODE_STATUS_REASON,        
MFA-TR*          ATT_READ_VALUE_IS            AS ATT_READ_VALUE_IS              
MFA-TR*       FROM SESSION.CSR04584_R6                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N6 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-6        AS RETURN_CODE,           
                      :S-SO-INST-SEQ-NO-6     AS SO_INST_SEQ_NO,        
                      :S-REG-ID-NO-6          AS REG_ID_NO,             
                      :S-METER-NO-6           AS METER_NO,              
                      :S-IC-NO-6              AS IC_NO,                 
                      :S-MTR-REF-NO-6         AS MTR_REF_NO,            
                      :S-CODE-UTIL-TYPE-6     AS CODE_UTIL_TYPE,        
                      :S-DEVICE-NO            AS DEVICE_NO,             
                      :S-CODE-ATT-TYPE        AS CODE_ATT_TYPE,         
               LTRIM(RTRIM(:S-CODE-STATUS-REASON-6)) AS 
           ATT_CODE_STATUS_REASON,
                      :S-READ-VALUE-IS-6      AS ATT_READ_VALUE_IS      
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N6 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-6        AS RETURN_CODE,                   
MFA-TR*               :S-SO-INST-SEQ-NO-6     AS SO_INST_SEQ_NO,                
MFA-TR*               :S-REG-ID-NO-6          AS REG_ID_NO,                     
MFA-TR*               :S-METER-NO-6           AS METER_NO,                      
MFA-TR*               :S-IC-NO-6              AS IC_NO,                         
MFA-TR*               :S-MTR-REF-NO-6         AS MTR_REF_NO,                    
MFA-TR*               :S-CODE-UTIL-TYPE-6     AS CODE_UTIL_TYPE,                
MFA-TR*               :S-DEVICE-NO            AS DEVICE_NO,                     
MFA-TR*               :S-CODE-ATT-TYPE        AS CODE_ATT_TYPE,                 
MFA-TR*        STRIP(:S-CODE-STATUS-REASON-6) AS ATT_CODE_STATUS_REASON,        
MFA-TR*               :S-READ-VALUE-IS-6      AS ATT_READ_VALUE_IS              
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C7 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                  AS RETURN_CODE,           
                 LTRIM(RTRIM(ACCT_TYPE))             AS ACCT_TYPE,             
                 DNP_COUNTER                  AS DNP_COUNTER,           
                 DNP_AMNT                     AS DNP_AMNT,              
                 DNP_RETURN_CKS               AS DNP_RETURN_CKS,        
                 DNP_CUS_TURN_DATE            AS DNP_CUS_TURN_DATE,     
                 DNP_CREDIT_GROUP             AS DNP_CREDIT_GROUP,      
                 DNP_CASH                     AS DNP_CASH,              
                 DNP_LAST_PAY_AMNT            AS DNP_LAST_PAY_AMNT,     
                 DNP_LAST_PAY_DATE            AS DNP_LAST_PAY_DATE,     
                 DNP_2ND_NOTICE_DATE          AS DNP_2ND_NOTICE_DATE,   
                 DNP_DEPOSIT_AMNT             AS DNP_DEPOSIT_AMNT,      
                 DNP_ARREARS_AMNT             AS DNP_ARREARS_AMNT,      
                 DNP_TOTAL_AMNT               AS DNP_TOTAL_AMNT,        
                 DNP_PAST_DUE_AMNT            AS DNP_PAST_DUE_AMNT,     
                 DNP_INDICATOR                AS DNP_INDICATOR,         
                 DNP_ARREARS_HISTORY          AS DNP_ARREARS_HISTORY,   
                 DNP_CREDIT_HISTORY           AS DNP_CREDIT_HISTORY,    
                 DNP_EXCEPT_HISTORY           AS DNP_EXCEPT_HISTORY,    
                 DNP_30_ARREARS               AS DNP_30_ARREARS,        
                 DNP_60_ARREARS               AS DNP_60_ARREARS,        
                 DNP_90_ARREARS               AS DNP_90_ARREARS,        
                 DNP_UTILITY_AMNT             AS DNP_UTILITY_AMNT,      
                 DNP_NON_UTILITY_AMNT         AS DNP_NON_UTILITY_AMNT,  
                 DNP_BANKRUPT                 AS DNP_BANKRUPT,          
                 DNP_KEY_CUS                  AS DNP_KEY_CUS,           
                 LTRIM(RTRIM(DNP_CRITICAL_CUS))      AS 
           DNP_CRITICAL_CUS,      
                 LTRIM(RTRIM(REASON_CD))             AS REASON_CD              
              FROM #CSR04584_R7                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C7 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                  AS RETURN_CODE,                   
MFA-TR*          STRIP(ACCT_TYPE)             AS ACCT_TYPE,                     
MFA-TR*          DNP_COUNTER                  AS DNP_COUNTER,                   
MFA-TR*          DNP_AMNT                     AS DNP_AMNT,                      
MFA-TR*          DNP_RETURN_CKS               AS DNP_RETURN_CKS,                
MFA-TR*          DNP_CUS_TURN_DATE            AS DNP_CUS_TURN_DATE,             
MFA-TR*          DNP_CREDIT_GROUP             AS DNP_CREDIT_GROUP,              
MFA-TR*          DNP_CASH                     AS DNP_CASH,                      
MFA-TR*          DNP_LAST_PAY_AMNT            AS DNP_LAST_PAY_AMNT,             
MFA-TR*          DNP_LAST_PAY_DATE            AS DNP_LAST_PAY_DATE,             
MFA-TR*          DNP_2ND_NOTICE_DATE          AS DNP_2ND_NOTICE_DATE,           
MFA-TR*          DNP_DEPOSIT_AMNT             AS DNP_DEPOSIT_AMNT,              
MFA-TR*          DNP_ARREARS_AMNT             AS DNP_ARREARS_AMNT,              
MFA-TR*          DNP_TOTAL_AMNT               AS DNP_TOTAL_AMNT,                
MFA-TR*          DNP_PAST_DUE_AMNT            AS DNP_PAST_DUE_AMNT,             
MFA-TR*          DNP_INDICATOR                AS DNP_INDICATOR,                 
MFA-TR*          DNP_ARREARS_HISTORY          AS DNP_ARREARS_HISTORY,           
MFA-TR*          DNP_CREDIT_HISTORY           AS DNP_CREDIT_HISTORY,            
MFA-TR*          DNP_EXCEPT_HISTORY           AS DNP_EXCEPT_HISTORY,            
MFA-TR*          DNP_30_ARREARS               AS DNP_30_ARREARS,                
MFA-TR*          DNP_60_ARREARS               AS DNP_60_ARREARS,                
MFA-TR*          DNP_90_ARREARS               AS DNP_90_ARREARS,                
MFA-TR*          DNP_UTILITY_AMNT             AS DNP_UTILITY_AMNT,              
MFA-TR*          DNP_NON_UTILITY_AMNT         AS DNP_NON_UTILITY_AMNT,          
MFA-TR*          DNP_BANKRUPT                 AS DNP_BANKRUPT,                  
MFA-TR*          DNP_KEY_CUS                  AS DNP_KEY_CUS,                   
MFA-TR*          STRIP(DNP_CRITICAL_CUS)      AS DNP_CRITICAL_CUS,              
MFA-TR*          STRIP(REASON_CD)             AS REASON_CD                      
MFA-TR*       FROM SESSION.CSR04584_R7                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N7 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-7        AS RETURN_CODE,           
                      :S-ACCT-TYPE            AS ACCT_TYPE,             
                      :S-DNP-COUNTER          AS DNP_COUNTER,           
                      :S-DNP-AMNT             AS DNP_AMNT,              
                      :S-DNP-RETURN-CKS       AS DNP_RETURN_CKS,        
                      :S-DNP-CUS-TURN-DATE    AS DNP_CUS_TURN_DATE,     
                      :S-DNP-CREDIT-GROUP     AS DNP_CREDIT_GROUP,      
                      :S-DNP-CASH             AS DNP_CASH,              
                      :S-DNP-LAST-PAY-AMNT    AS DNP_LAST_PAY_AMNT,     
                      :S-DNP-LAST-PAY-DATE    AS DNP_LAST_PAY_DATE,     
                      :S-DNP-2ND-NOTICE-DATE  AS DNP_2ND_NOTICE_DATE,   
                      :S-DNP-DEPOSIT-AMNT     AS DNP_DEPOSIT_AMNT,      
                      :S-DNP-ARREARS-AMNT     AS DNP_ARREARS_AMNT,      
                      :S-DNP-TOTAL-AMNT       AS DNP_TOTAL_AMNT,        
                      :S-DNP-PAST-DUE-AMNT    AS DNP_PAST_DUE_AMNT,     
                      :S-DNP-INDICATOR        AS DNP_INDICATOR,         
                      :S-DNP-ARREARS-HISTORY  AS DNP_ARREARS_HISTORY,   
                      :S-DNP-CREDIT-HISTORY   AS DNP_CREDIT_HISTORY,    
                      :S-DNP-EXCEPT-HISTORY   AS DNP_EXCEPT_HISTORY,    
                      :S-DNP-30-ARREARS       AS DNP_30_ARREARS,        
                      :S-DNP-60-ARREARS       AS DNP_60_ARREARS,        
                      :S-DNP-90-ARREARS       AS DNP_90_ARREARS,        
                      :S-DNP-UTILITY-AMNT     AS DNP_UTILITY_AMNT,      
                      :S-DNP-NON-UTILITY-AMNT AS DNP_NON_UTILITY_AMNT,  
                      :S-DNP-BANKRUPT         AS DNP_BANKRUPT,          
                      :S-DNP-KEY-CUS          AS DNP_KEY_CUS,           
                      :S-DNP-CRITICAL-CUS-7   AS DNP_CRITICAL_CUS,      
                      :S-REASON-CD            AS REASON_CD              
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N7 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-7        AS RETURN_CODE,                   
MFA-TR*               :S-ACCT-TYPE            AS ACCT_TYPE,                     
MFA-TR*               :S-DNP-COUNTER          AS DNP_COUNTER,                   
MFA-TR*               :S-DNP-AMNT             AS DNP_AMNT,                      
MFA-TR*               :S-DNP-RETURN-CKS       AS DNP_RETURN_CKS,                
MFA-TR*               :S-DNP-CUS-TURN-DATE    AS DNP_CUS_TURN_DATE,             
MFA-TR*               :S-DNP-CREDIT-GROUP     AS DNP_CREDIT_GROUP,              
MFA-TR*               :S-DNP-CASH             AS DNP_CASH,                      
MFA-TR*               :S-DNP-LAST-PAY-AMNT    AS DNP_LAST_PAY_AMNT,             
MFA-TR*               :S-DNP-LAST-PAY-DATE    AS DNP_LAST_PAY_DATE,             
MFA-TR*               :S-DNP-2ND-NOTICE-DATE  AS DNP_2ND_NOTICE_DATE,           
MFA-TR*               :S-DNP-DEPOSIT-AMNT     AS DNP_DEPOSIT_AMNT,              
MFA-TR*               :S-DNP-ARREARS-AMNT     AS DNP_ARREARS_AMNT,              
MFA-TR*               :S-DNP-TOTAL-AMNT       AS DNP_TOTAL_AMNT,                
MFA-TR*               :S-DNP-PAST-DUE-AMNT    AS DNP_PAST_DUE_AMNT,             
MFA-TR*               :S-DNP-INDICATOR        AS DNP_INDICATOR,                 
MFA-TR*               :S-DNP-ARREARS-HISTORY  AS DNP_ARREARS_HISTORY,           
MFA-TR*               :S-DNP-CREDIT-HISTORY   AS DNP_CREDIT_HISTORY,            
MFA-TR*               :S-DNP-EXCEPT-HISTORY   AS DNP_EXCEPT_HISTORY,            
MFA-TR*               :S-DNP-30-ARREARS       AS DNP_30_ARREARS,                
MFA-TR*               :S-DNP-60-ARREARS       AS DNP_60_ARREARS,                
MFA-TR*               :S-DNP-90-ARREARS       AS DNP_90_ARREARS,                
MFA-TR*               :S-DNP-UTILITY-AMNT     AS DNP_UTILITY_AMNT,              
MFA-TR*               :S-DNP-NON-UTILITY-AMNT AS DNP_NON_UTILITY_AMNT,          
MFA-TR*               :S-DNP-BANKRUPT         AS DNP_BANKRUPT,                  
MFA-TR*               :S-DNP-KEY-CUS          AS DNP_KEY_CUS,                   
MFA-TR*               :S-DNP-CRITICAL-CUS-7   AS DNP_CRITICAL_CUS,              
MFA-TR*               :S-REASON-CD            AS REASON_CD                      
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C8 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE                  AS RETURN_CODE,           
                 CASE_NO                      AS CASE_NO                
              FROM #CSR04584_R8                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C8 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE                  AS RETURN_CODE,                   
MFA-TR*          CASE_NO                      AS CASE_NO                        
MFA-TR*       FROM SESSION.CSR04584_R8                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N8 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-8       AS RETURN_CODE,            
                      :S-CASE-NO             AS CASE_NO                 
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N8 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-8       AS RETURN_CODE,                    
MFA-TR*               :S-CASE-NO             AS CASE_NO                         
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4753 CURSOR
MSQ001          FOR CALL CSR04753()
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1136 CURSOR
MSQ001          FOR CALL CSR01136( :SERV-ORDER-NO-1136
                  , :HISTORY-FLAG-1136
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO       PIC X(13).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-SERV-ORDER-NO.                    
                                                                        
      ******************************************************************        
      *    0000-MAINLINE                                               *        
      *         CONTROLS MAIN PATH OF PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
                            S-RETURN-CODE-6                             
                            S-RETURN-CODE-7                             
                            S-RETURN-CODE-8                             
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT                
               PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT                
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT                
               PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT                
               PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT                
               PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT                
               PERFORM 9999-END-PROGRAM   THRU 9999-EXIT
           END-IF.               
           PERFORM 8030-COMMIT-UPDATES    THRU 8030-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    1000-INITIALIZATION                                         *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED                                
                       WS-GTT06-DECLARED                                
                       WS-GTT07-DECLARED                                
                       WS-GTT08-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0101-DECLARE-GTT01                                          *        
      ******************************************************************        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R1
              (                                                          
               RETURN_CODE                  INT,                    
               SERV_ORDER_NO                DECIMAL(13,0),              
               SO_INST_SEQ_NO               SMALLINT,                   
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               WORK_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ORDER_PRIORITY_CD            SMALLINT,                   
               SO_EST_LABOR_HR              DECIMAL(6,1),               
               COMPANY_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,            
               LOCAL_OFFICE CHAR(22)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ORDER_TYPE_CD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ACCOUNT_NO                   DECIMAL(13,0),              
               FULL_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,             
               STREET_ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,        
               HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ADDR_PREFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_PREFIX_2 CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_LOCATION_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               STREET_LOCATION_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               ADDR_STREET CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ADDR_CITY_STATE CHAR(30)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2,               
               LATITUDE                     DECIMAL(9,6),               
               LONGITUDE                    DECIMAL(9,6),               
               LOT CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               BLOCK CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               SUBDIVISION_DESC CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
A05020         SUBDIVISION_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
A05020         ZIP_CODE_PLUS_FOUR CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               ORDER_PLACED_BY CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               ORDER_REASON CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CALL_BEFORE_MINUTS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               PHONE_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,              
               PHONE_NO_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,          
               SERV_ORDER_REMARKS CHAR(210)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               SERV_ORDER_REMUPD CHAR(210)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               SPCL_INSTRUCTIONS CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               PREMISE                      DECIMAL(10,0),              
               PREMISE_DIRECTIONS CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               CODE_ACCT_STAT CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,        
               XS_FLOW_VALVE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               SPLIT_SERVICE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               SERVICE_CHARGES              DECIMAL(11,2),              
               COUNTY CHAR(22)  COLLATE LATIN1_GENERAL_100_BIN2,                
               TOTAL_BTU                    INT,                    
               ALT_PHONE_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ALT_PHONE_NO_EXT CHAR(06)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
A05020*        MADE_SAFE_DT                 CHAR(26),                           
               HOME_ALL_DAY_FL CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               BUSINESS_UNIT CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DNP_CRITICAL_CUS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               CIRCUIT_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CUST_PHASE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               GRID_CELL CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,             
               POLE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               ASSIGNED_DATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,         
               COMPLIANCE_DAYS              SMALLINT,                   
               DUE_DAYS                     SMALLINT,                   
               MATERIAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               WORK_START_TIME CHAR(08)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               WORK_STOP_TIME CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               WORK_DISTRICT CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,         
               OPTIMIZE_ORDER CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RED_FLAG_SAFETY CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               RED_FLAG_MAINT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RED_FLAG_STORM CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SO_SERVICE_CHRG CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               GROUP_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               ORDER_CANCEL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               SO_COMPL_REMARKS CHAR(210)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               DATE_RECVED CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,           
               COMM_COMMENTS CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2,        
A05020         DBA_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,              
A05020         COMPLIANCE_DATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
A05020         TASK_TYPE CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2,             
A05020         APPT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,               
P01176         SAMPLE_TEST CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
A05020         HOT_SPOT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0102-DECLARE-GTT02                                          *        
      ******************************************************************        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R2
              (                                                          
               RETURN_CODE                  INT,                    
               SO_INST_SEQ_NO               SMALLINT,                   
               APPLIANCE_CD CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               LEAK_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
               LIGHT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               REPAIR_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CUTOFF_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CAUTION_TAG_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               CONDITION_CD CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2,          
               REPLACE_APP_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               INSTALL_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,            
               APPLIANCE_COMMENTS CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               TAG_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                
               CAUTION_TAG_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               EQUIPMENT_UNQ CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT2'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0103-DECLARE-GTT03                                          *        
      ******************************************************************        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R3
              (                                                          
               RETURN_CODE                  INT,                    
               SO_INST_SEQ_NO               SMALLINT,                   
               REG_CHARGEABLE_HRS           SMALLINT,                   
               OT_CHARGEABLE_HRS            SMALLINT,                   
               CHARGES_COMMENTS CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               WORK_PERIOD_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,        
               WAIVER_TYPE_CD CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,        
               MATERIAL_CHRG                DECIMAL(9,2),               
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT3'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0104-DECLARE-GTT04                                          *        
      ******************************************************************        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R4
              (                                                          
               RETURN_CODE                  INT,                    
               SO_INST_SEQ_NO               SMALLINT,                   
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               WORK_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               IC_NO                        SMALLINT,                   
               MTR_REF_NO                   SMALLINT,                   
               CODE_DEST CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DEST_NO CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2,               
               CODE_MTR_STATUS_WS CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               MTR_READ_VALUE_IS            DECIMAL(15,3),              
               METER_SUPPLYING CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               READ_ROUTE                   SMALLINT,                   
               READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SPCL_READ_INSTR CHAR(114)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                  
               MTR_CODE_TIME_PERIOD         SMALLINT,                   
               REG_ID_NO                    SMALLINT,                   
               CONSTANT                     DECIMAL(9,3),               
               MTR_NO_DIALS                 SMALLINT,                   
               METER_SIZE_ID CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,         
               CODE_METER_LOC CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SUBSTATION_ID CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               LOCK_TYPE_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_MAKE CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2,             
               AMPS                         SMALLINT,                   
               NO_WIRES CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
               VOLTAGE                      SMALLINT,                   
               MTR_CONNECT_TYPE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               CASE_PRESSURE CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               RLSE_DATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,             
               MTR_MAX_NO_UNITS             DECIMAL(9,0),               
               MTR_MIN_NO_UNITS             DECIMAL(9,0),               
               MTR_USAGE_HIGH_PCT           DECIMAL(5,2),               
               MTR_USAGE_LOW_PCT            DECIMAL(5,2),               
               LAST_MTR_READ_VALUE          DECIMAL(15,3),              
               LAST_MTR_READ_DATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               REMOTE_READ_IND CHAR(20)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               MTR_ACCESSIBLE_CD CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               MTR_ACCESSIBLE_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               MTR_ACCESSIBLE_RSN CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               MTR_CODE_STATUS_REASON CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               NUMBER_OF_DRIVE              SMALLINT,                   
               ELEC_MTR_FORM_CD CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               READ_SEQUENCE_NO             INT,                    
               MTR_RD_DISP_CD CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,        
               INDEX_VALUE_CD CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,        
               NO_READ_DIGITS               INT,                    
               NO_READ_DECIMALS             INT                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT4'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0105-DECLARE-GTT05                                          *        
      ******************************************************************        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R5
              (                                                          
               RETURN_CODE                  INT,                    
               SO_INST_SEQ_NO               SMALLINT,                   
               REG_ID_NO                    SMALLINT,                   
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               IC_NO                        SMALLINT,                   
               MTR_REF_NO                   SMALLINT,                   
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               READ_SEQUENCE_NO             SMALLINT,                   
               REG_READ_VALUE_IS            DECIMAL(15,3),              
               MTR_RD_DISP_CD CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,        
               REG_CODE_TIME_PERIOD         SMALLINT,                   
               INDEX_VALUE_CD CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,        
               REG_CODE_STATUS_REASON CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               REG_MAX_NO_UNITS             DECIMAL(9,0),               
               REG_MIN_NO_UNITS             DECIMAL(9,0),               
               REG_USAGE_HIGH_PCT           DECIMAL(5,2),               
               REG_USAGE_LOW_PCT            DECIMAL(5,2),               
               LAST_REG_READ_VALUE          DECIMAL(15,3),              
               REG_NO_DIALS                 SMALLINT,                   
               CODE_REG_STATUS_WS CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               LAST_REG_READ_DT CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               NO_READ_DIGITS               INT,                    
               NO_READ_DECIMALS             INT                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT5'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0106-DECLARE-GTT06                                          *        
      ******************************************************************        
       0106-DECLARE-GTT06.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R6
              (                                                          
               RETURN_CODE                  INT,                    
               SO_INST_SEQ_NO               SMALLINT,                   
               REG_ID_NO                    SMALLINT,                   
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               IC_NO                        SMALLINT,                   
               MTR_REF_NO                   SMALLINT,                   
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               DEVICE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,             
               CODE_ATT_TYPE CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ATT_CODE_STATUS_REASON CHAR(80)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               ATT_READ_VALUE_IS            DECIMAL(15,3)               
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8006-DELETE-GTT6-ROWS THRU 8006-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0106'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT6'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R6'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT06-DECLARED.                               
                                                                        
       0106-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0107-DECLARE-GTT07                                          *        
      ******************************************************************        
       0107-DECLARE-GTT07.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R7
              (                                                          
               RETURN_CODE                  INT,                    
               ACCT_TYPE CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DNP_COUNTER                  SMALLINT,                   
               DNP_AMNT                     DECIMAL(9,2),               
               DNP_RETURN_CKS               SMALLINT,                   
               DNP_CUS_TURN_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_CREDIT_GROUP CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_CASH CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
               DNP_LAST_PAY_AMNT            DECIMAL(9,2),               
               DNP_LAST_PAY_DATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_2ND_NOTICE_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_DEPOSIT_AMNT             DECIMAL(10,2),              
               DNP_ARREARS_AMNT             DECIMAL(9,2),               
               DNP_TOTAL_AMNT               DECIMAL(9,2),               
               DNP_PAST_DUE_AMNT            DECIMAL(9,2),               
               DNP_INDICATOR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DNP_ARREARS_HISTORY CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_CREDIT_HISTORY CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_EXCEPT_HISTORY CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               DNP_30_ARREARS               DECIMAL(9,2),               
               DNP_60_ARREARS               DECIMAL(9,2),               
               DNP_90_ARREARS               DECIMAL(9,2),               
               DNP_UTILITY_AMNT             DECIMAL(9,2),               
               DNP_NON_UTILITY_AMNT         DECIMAL(9,2),               
               DNP_BANKRUPT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               DNP_KEY_CUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               DNP_CRITICAL_CUS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                   
               REASON_CD CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2              
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8007-DELETE-GTT7-ROWS THRU 8007-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0107'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT7'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R7'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT07-DECLARED.                               
                                                                        
       0107-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    0108-DECLARE-GTT08                                          *        
      ******************************************************************        
       0108-DECLARE-GTT08.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04584_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04584_R8
              (                                                          
               RETURN_CODE                  INT,                    
               CASE_NO                      INT                     
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8008-DELETE-GTT8-ROWS THRU 8008-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0108'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT8'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04584_R8'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT08-DECLARED.                               
                                                                        
       0108-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    1000-PROCESS-INPUT                                          *        
      *        VALIDATES INPUT SERVICE ORDER NO                        *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
              MOVE ZEROES                  TO LINK-SERV-ORDER-NO
           END-IF.       
           MOVE LINK-SERV-ORDER-NO         TO WS-SERV-ORDER-NO.         
           MOVE WS-SERV-ORDER-NO-NUM       TO VI-SERV-ORDER-NO.         
                                                                        
           IF LINK-SERV-ORDER-NO = ZEROES                               
              PERFORM 1100-NO-PROCESSING   THRU 1100-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    1100-NO-PROCESSING                                          *        
      *        VALIDATES INPUT SERVICE ORDER NO                        *        
      ******************************************************************        
       1100-NO-PROCESSING.                                              
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE +100     TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
                            S-RETURN-CODE-6                             
                            S-RETURN-CODE-7                             
                            S-RETURN-CODE-8.                            
           ADD +1 TO CTR-ROWS.                                          
           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT.                   
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
           PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT.                   
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
           PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT.                   
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
           PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT.                   
           PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT.                   
           PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT.                   
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
           PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT.                   
           PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT.                   
           PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT.                   
           PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT.                   
           PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT.                   
           PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT.                   
           PERFORM 9999-END-PROGRAM THRU 9999-EXIT.                     
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2000-PROCESS-OUTPUT                                         *        
      *        PROCESSES ALL TASKS                                     *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-OPEN-TASKS-CURSOR              THRU 7100-EXIT.  
           PERFORM 7101-FETCH-TASKS-CURSOR             THRU 7101-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              EVALUATE VO-ORDER-STATE-CD                                
                  WHEN 'A'                                              
                  WHEN 'R'                                              
                     MOVE 'Y'                          TO WS-TASK-DATA  
                  WHEN 'C'                                              
                     MOVE 'Y'                          TO WS-TASK-DATA  
                     MOVE 'Y'                          TO WS-TASK-CANCEL
                  WHEN OTHER                                            
                     PERFORM 7055-CHECK-SO-UPDATE      THRU 7055-EXIT   
              END-EVALUATE                                              
A05020        IF (VO-ORDER-TYPE-CD = 'FW022' OR                         
A05020            VO-ORDER-TYPE-CD = 'FW024' OR                         
A05020            VO-ORDER-TYPE-CD = 'FM007')                           
A05020            MOVE 'N'                             TO WS-TASK-DATA  
A05020        END-IF                                                    
A05020        IF ((VO-ORDER-TYPE-CD = 'FW022' OR                        
A05020             VO-ORDER-TYPE-CD = 'FW024' OR                        
A05020             VO-ORDER-TYPE-CD = 'FM007')) AND WS-PRINT = 'N'      
A05020            MOVE 'N'                             TO WS-TASK-DATA  
A05020            MOVE 'Y'                             TO WS-PRINT      
A05020            MOVE 'N'                             TO WS-PRINT-IND  
A05020            PERFORM 8000-RESET-PRINTED-IND       THRU 8000-EXIT   
A05020            PERFORM 7098-GET-CURRENT-TIMES       THRU 7098-EXIT   
A05020            IF WS-ASSIGN-DATE = WS-CURRENT-DATE                   
A05020               PERFORM 7097-GET-PRINT-LOC        THRU 7097-EXIT   
A05020               PERFORM 7096A-CHECK-HOLIDAY       THRU 7096A-EXIT  
A05020               IF WS-DAY-OF-WEEK = 1 OR WS-DAY-OF-WEEK = 7        
A05020                  MOVE 'Y'                       TO WS-WEEKEND    
A05020               ELSE                                               
A05020                  MOVE 'N'                       TO WS-WEEKEND    
A05020               END-IF                                             
A05020               IF WS-DAY-OF-WEEK = 8                              
A05020                  MOVE 'Y'                       TO WS-HOLIDAY    
A05020               ELSE                                               
A05020                  MOVE 'N'                       TO WS-HOLIDAY    
A05020               END-IF                                             
A05020               IF WS-CURRENT-TIME < C4-START-TIME OR              
A05020                  WS-CURRENT-TIME > C4-END-TIME                   
A05020                  MOVE 'Y'                      TO WS-AFTER-HOURS 
A05020               ELSE                                               
A05020                  MOVE 'N'                      TO WS-AFTER-HOURS 
A05020               END-IF                                             
A05020               IF WS-WEEKEND = 'Y' OR WS-HOLIDAY = 'Y' OR         
A05020                  WS-AFTER-HOURS = 'Y'                            
A05020                  MOVE C4-PRINTER-AFTER-HRS     TO VP-PRINT-ID    
A05020               ELSE                                               
A05020                  MOVE C4-PRINTER-NRML-HRS      TO VP-PRINT-ID    
A05020               END-IF                                             
A05020               PERFORM 7099-CHECK-PRINT-INS     THRU 7099-EXIT    
A05020               IF WS-PRINT-INSERTED = 'N'                         
A05020                  PERFORM 8010-INSERT-PRINT-Q   THRU 8010-EXIT    
A05020               END-IF                                             
A05020            END-IF                                                
A05020        END-IF                                                    
              IF WS-GTT01-DECLARED = 'N' AND WS-TASK-DATA = 'Y'         
                 PERFORM 0101-DECLARE-GTT01            THRU 0101-EXIT   
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                 WS-TASK-DATA = 'Y'                                     
                 MOVE 0                        TO S-RETURN-CODE-1       
                 IF VO-ORDER-STATE-CD = 'C'                             
                    MOVE 'N'                   TO WS-ORDER-CHK          
                 ELSE                                                   
                    MOVE WS-YES                TO WS-ORDER-CHK          
                 END-IF                                                 
                 MOVE VI-SERV-ORDER-NO         TO S-SERV-ORDER-NO       
                 MOVE VI-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE-1    
                 MOVE VI-WORK-TYPE-CD          TO S-WORK-TYPE-CD-1      
                 MOVE VO-PREMISE-NO            TO S-PREMISE             
                 MOVE VO-ORDER-STATE-CD        TO S-ORDER-STATE-CD      
                 MOVE VO-DATE-RECVED           TO S-DATE-RECVED         
                 IF VO-PHONE-NO > SPACES                                
                    MOVE VO-PHONE-NO(1:3)      TO WS-AREA-CD            
                    MOVE VO-PHONE-NO(4:3)      TO WS-NO1                
                    MOVE VO-PHONE-NO(7:4)      TO WS-NO2                
                    MOVE WS-PHONE-NO           TO S-PHONE-NO            
                 END-IF                                                 
                 IF VO-ALT-PHONE-NO > SPACES                            
                    MOVE VO-ALT-PHONE-NO(1:3)  TO WS-ALT-AREA-CD        
                    MOVE VO-ALT-PHONE-NO(4:3)  TO WS-ALT-NO1            
                    MOVE VO-ALT-PHONE-NO(7:4)  TO WS-ALT-NO2            
                    MOVE WS-ALT-PHONE-NO       TO S-ALT-PHONE-NO        
                 END-IF                                                 
                 IF VI-TASK-STATUS-CD = WS-CANCEL                       
                    MOVE WS-YES                TO S-ORDER-CANCEL        
                    MOVE WS-YES                TO WS-CLICK-CANCEL       
                 END-IF                                                 
                 MOVE VO-COMPANY-NO            TO WS-COMPANY            
                 MOVE 'DATABASE'               TO C8-DELINQ-CD          
                 MOVE '01'                     TO C8-COMPANY-NO         
                 PERFORM 7005-GET-DLINQ-VAL    THRU 7005-EXIT           
                 MOVE C8-DELINQ-VALUE          TO WS-DATABASE           
                 IF CSR-DATABASE                                        
                    EVALUATE VO-COMPANY-NO                              
                      WHEN WS-SCEG                                      
                        MOVE WS-01                TO S-COMPANY-NO       
                      WHEN WS-PSNC                                      
                        MOVE WS-26                TO S-COMPANY-NO       
                    END-EVALUATE                                        
                 ELSE                                                   
                   MOVE WS-SEB                 TO S-COMPANY-NO          
                 END-IF                                                 
                 IF WS-LOAD-VALUES = 'N'                                
                    PERFORM 2130-GET-ORDER-REASON-DESC  THRU 2130-EXIT  
                    MOVE 'Y'                   TO WS-LOAD-VALUES        
                 END-IF                                                 
                                                                        
                 PERFORM 2150-GET-REASON-DESC           THRU 2150-EXIT  
P01176           IF VI-SAMPLE-TEST-FL = 'Y'                             
P01176              MOVE 'YES'                 TO S-SAMPLE-TEST         
P01176              MOVE 'Y'                   TO WS-SAMPLE-TEST        
P01176           ELSE                                                   
P01176              MOVE 'NO'                  TO S-SAMPLE-TEST         
P01176           END-IF                                                 
                 MOVE VO-ACCOUNT-NO            TO S-ACCOUNT-NO          
                 IF VI-CODE-UTIL-TYPE = WS-GAS                          
                    MOVE WS-YES                TO WS-GAS-FOUND          
                    IF WS-GAS-INST-FND = WS-NO                          
                       MOVE S-SO-INST-SEQ-NO-1 TO WS-GAS-INST-NO        
                       MOVE WS-YES             TO WS-GAS-INST-FND       
                    END-IF                                              
                 ELSE                                                   
                    IF WS-ELEC-INST-FND = WS-NO                         
                       MOVE S-SO-INST-SEQ-NO-1    TO WS-ELEC-INST-NO    
                       MOVE WS-YES                TO WS-ELEC-INST-FND   
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 2100-GET-TASK-DTLS            THRU 2100-EXIT   
                 PERFORM 8100-SEND-RESULT-1            THRU 8100-EXIT   
              END-IF                                                    
              PERFORM 7101-FETCH-TASKS-CURSOR          THRU 7101-EXIT   
           END-PERFORM.                                                 
           PERFORM 7102-CLOSE-TASKS-CURSOR             THRU 7102-EXIT.  
                                                                        
A05020     IF WS-CLICK-CANCEL    = WS-YES                               
A05020        MOVE 'N'                                 TO WS-PRINT-IND  
A05020        PERFORM 8000-RESET-PRINTED-IND           THRU 8000-EXIT   
A05020     ELSE                                                         
A05020        IF VO-ORDER-STATE-CD = 'A'                                
A05020           MOVE 'Y'                              TO WS-PRINT-IND  
A05020           PERFORM 8000-RESET-PRINTED-IND        THRU 8000-EXIT   
A05020        END-IF                                                    
A05020     END-IF.                                                      
                                                                        
           IF WS-ORDER-CHK   = WS-YES                                   
A05020*       IF VO-ORDER-TYPE-CD = 'EM001' OR                                  
A05020*          VO-ORDER-TYPE-CD = 'EM002'                                     
A05020        IF C2-ORDER-GROUP-CD = 'A'                                
A05020           PERFORM 2200E-GET-EMER-APPL-DTLS      THRU 2200E-EXIT  
              ELSE                                                      
                 PERFORM 2200-GET-APPLIANCE-DTLS       THRU 2200-EXIT   
              END-IF                                                    
              PERFORM 2300-GET-CHARGES-DTLS            THRU 2300-EXIT   
              IF C2-ORDER-GROUP-CD = 'A'                                
                 PERFORM 2400A-GET-MTRD-ENVRNMT        THRU 2400A-EXIT  
                 PERFORM 2500A-GET-REGISTER-READ       THRU 2500A-EXIT  
              ELSE                                                      
                 IF VO-ORDER-TYPE-CD = 'FM002'                          
                    PERFORM 2400C-GET-SOMETER          THRU 2400C-EXIT  
                    IF WS-SOMETER-CHK = 'N'                             
                       PERFORM 2400B-GET-UTIL-DTLS     THRU 2400B-EXIT  
                    END-IF                                              
                    PERFORM 2500C-GET-SOREGISTER       THRU 2500C-EXIT  
                    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                       PERFORM 2500-GET-REGISTER-DTLS  THRU 2500-EXIT   
                    END-IF                                              
                 ELSE                                                   
                    PERFORM 2400-GET-METER-DTLS        THRU 2400-EXIT   
                    PERFORM 2500-GET-REGISTER-DTLS     THRU 2500-EXIT   
                 END-IF                                                 
              END-IF                                                    
              PERFORM 2600-GET-ATTACHMENT-DTLS         THRU 2600-EXIT   
A05020*       PERFORM 7795-GET-MULTI-REGISTER          THRU 7795-EXIT           
A05020        IF VO-ORDER-TYPE-CD(1:3) = 'DNP'                          
A05020*          AND WS-MULTI-REGISTER = 'N'                                    
                 INITIALIZE GTT-RETURN-FIELDS-7                         
                 PERFORM 2700-GET-DNP-DTLS             THRU 2700-EXIT   
              ELSE                                                      
                 INITIALIZE GTT-RETURN-FIELDS-7                         
              END-IF                                                    
                                                                        
              IF VO-ORDER-TYPE-CD = 'FW016'  OR                         
                 VO-ORDER-TYPE-CD = 'FW019'                             
                 INITIALIZE GTT-RETURN-FIELDS-8                         
      *          PERFORM 2800-GET-ENDV-DTLS            THRU 2800-EXIT           
              ELSE                                                      
                 INITIALIZE GTT-RETURN-FIELDS-8                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2100-GET-TASK-DTLS                                          *        
      *        GETS ALL TASK DETAILS                                   *        
      ******************************************************************        
       2100-GET-TASK-DTLS.                                              
                                                                        
           PERFORM 7000-ORDER-INFO             THRU 7000-EXIT.          
A05020     MOVE SPACES                         TO S-TASK-TYPE.          
A05020     IF L3-TASK-TYPE-CALC-FL = 'Y'                                
A05020        MOVE 'N' TO  WS-TASK-FND                                  
A05020        PERFORM 2172-GET-ORDER-TASK-TYPE THRU 2172-EXIT           
A05020        PERFORM 7132-CLOSE-TASK-TYPE-CURSOR THRU 7132-EXIT        
A05020     END-IF.                                                      
A05020     MOVE SPACES                         TO S-COMPLIANCE-DATE.    
A05020     PERFORM 2101-GET-COMPLIANCE-DATE    THRU 2101-EXIT.          
A05020     MOVE 'N'                            TO WS-SOLAR-TASK.        
A05020*    IF (VO-ORDER-PRIORITY-CD = 3 OR VO-ORDER-PRIORITY-CD = 4             
A05020*        OR VO-ORDER-TYPE-CD  = 'DNP01')                                  
A05020     IF VO-ORDER-TYPE-CD  = 'DNP01' OR VO-ORDER-PRIORITY-CD = 3   
              MOVE VO-ORDER-PRIORITY-CD        TO S-ORDER-PRIORITY-CD   
           END-IF.                                                      
           PERFORM 7010-ACCOUNT-INFO           THRU 7010-EXIT.          
A05020     IF VO-ACCOUNT-NO > 0                                         
A05020        PERFORM 7011-GET-DBA-INFO        THRU 7011-EXIT           
A05020     END-IF.                                                      
A05020     IF DQ-FULL-NAME = SPACES AND AT-CODE-ACCT-STAT = 'P'         
A05020        AND AT-CUSTOMER-NO > 0                                    
A05020        PERFORM 7012-GET-CUST-DBA        THRU 7012-EXIT           
A05020     END-IF.                                                      
A05020     IF VO-ACCOUNT-NO = 0 AND AT-CUSTOMER-NO = 0                  
A05020        MOVE SPACES                      TO S-DBA-NAME            
A05020     ELSE                                                         
A05020        MOVE DQ-FULL-NAME                TO S-DBA-NAME            
A05020     END-IF.                                                      
           PERFORM 7020-PREMISE-INFO           THRU 7020-EXIT.          
           INSPECT PR-SPCL-INSTRUCTIONS-TEXT   REPLACING ALL LOW-VALUES 
                                               BY SPACES.               
           MOVE PR-SPCL-INSTRUCTIONS-TEXT      TO S-SPCL-INSTRUCTIONS.  
           INSPECT PR-SPCL-READ-INSTR-TEXT     REPLACING ALL LOW-VALUES 
                                               BY SPACES.               
           MOVE PR-SPCL-READ-INSTR-TEXT        TO WS-SPCL-READ-INSTR.   
           PERFORM 2160-GET-WORK-DISTRICT      THRU 2160-EXIT.          
           IF WS-TASK-CANCEL NOT EQUAL 'Y'                              
              PERFORM 7030-CUST-DNP-INFO       THRU 7030-EXIT           
           END-IF.                                                      
           PERFORM 7040A-GAS-SERV-LINE-INFO    THRU 7040A-EXIT.         
           IF XO-XS-FLOW-VALVE-FL = WS-YES                              
              MOVE XO-XS-FLOW-VALVE-FL         TO S-XS-FLOW-VALVE-FL    
           ELSE                                                         
              MOVE WS-NO                       TO S-XS-FLOW-VALVE-FL    
           END-IF.                                                      
           IF XO-SPLIT-SERV-FL    = WS-YES                              
              MOVE XO-SPLIT-SERV-FL            TO S-SPLIT-SERVICE-FL    
           ELSE                                                         
              MOVE WS-NO                       TO S-SPLIT-SERVICE-FL    
           END-IF.                                                      
           PERFORM 7060-GET-ORDER-DETAILS      THRU 7060-EXIT.          
           IF C2-ORDER-GROUP-CD = 'B' AND                               
              VO-ORDER-TYPE-CD NOT EQUAL 'FW016' AND                    
              VO-ORDER-TYPE-CD NOT EQUAL 'FW019' AND                    
              VO-ORDER-TYPE-CD NOT EQUAL 'FW004'                        
              MOVE 'Y'                         TO S-SO-SERVICE-CHRG     
           ELSE                                                         
              MOVE 'N'                         TO S-SO-SERVICE-CHRG     
           END-IF.                                                      
A05020*   ADD CHARGES SCREEN TO RECONNECT ORDERS.                               
A05020     IF VO-ORDER-TYPE-CD = 'FM006'                                
A05020        MOVE 'Y'                         TO S-SO-SERVICE-CHRG     
A05020     END-IF.                                                      
           MOVE WS-SERVICE-CHARGES             TO S-SERVICE-CHARGES.    
           MOVE C2-ORDER-GROUP-CD              TO S-GROUP-CODE.         
           IF WS-LOAD-CHARGE = 'N'                                      
             PERFORM 2180-GET-SERVICE-CHARGES  THRU 2180-EXIT           
           END-IF.                                                      
           PERFORM 2110-GET-ADDR-DTLS          THRU 2110-EXIT.          
           MOVE WS-SO-REMARKS                  TO WS-REMARK-TYPE.       
           INITIALIZE EF-REMARK-TX.                                     
           PERFORM 7070-SO-REMARKS-INFO        THRU 7070-EXIT.          
           MOVE WS-SO-CHANGELOG                TO WS-REMARK-TYPE.       
           PERFORM 7070-SO-REMARKS-INFO        THRU 7070-EXIT.          
           MOVE WS-SO-COMPLETION               TO WS-REMARK-TYPE.       
           PERFORM 7070-SO-REMARKS-INFO        THRU 7070-EXIT.          
           IF WS-TASK-CANCEL NOT EQUAL 'Y'                              
              PERFORM 7080-GET-NAME-INFO       THRU 7080-EXIT           
           END-IF.                                                      
           IF VO-ORDER-TYPE-CD(1:2) = 'CC' OR                           
              VO-ORDER-TYPE-CD(1:2) = 'NC' OR                           
              VO-ORDER-TYPE-CD(1:3) = 'OFF'                             
              MOVE VO-ACCOUNT-NO-PRIOR         TO WS-ACCOUNT            
           ELSE                                                         
              MOVE VO-ACCOUNT-NO               TO WS-ACCOUNT            
           END-IF.                                                      
           PERFORM 7085-GET-METER-INFO         THRU 7085-EXIT.          
           IF MN-GIS-POINT-ID > 0                                       
              PERFORM 7090-PIM-POINT-INFO      THRU 7090-EXIT           
           END-IF.                                                      
           IF VO-ORDER-TYPE-CD = 'FM002' OR VO-ORDER-TYPE-CD = 'MC001'  
              MOVE 'Y'                         TO S-MATERIAL-FL         
           ELSE                                                         
              PERFORM 7095-GET-MATERIAL-FL     THRU 7095-EXIT           
           END-IF                                                       
A05020     IF WS-NULL-26 = 0 AND WS-NULL-27 = 0                         
A05020        MOVE 'Y'                         TO S-APPT-FL             
A05020        MOVE VO-BEGIN-APPT-DT(1:10)      TO WS-COMP-DT            
A05020        MOVE WS-COMPLIANCE-TS            TO S-COMPLIANCE-DATE     
A05020     END-IF                                                       
           IF WS-NULL-26 = 0 AND WS-NULL-27 = 0 AND                     
A05020        VO-APPT-AM-PM-CD NOT EQUAL 'A' AND                        
A05020        VO-APPT-AM-PM-CD NOT EQUAL 'P'                            
              MOVE WS-BEGIN-APPT-TIME          TO S-WORK-START-TIME     
              MOVE WS-END-APPT-TIME            TO S-WORK-STOP-TIME      
           ELSE                                                         
              PERFORM 7096A-CHECK-HOLIDAY      THRU 7096A-EXIT          
              PERFORM 2190-CHECK-DAY-OF-WEEK   THRU 2190-EXIT           
A05020        IF VO-APPT-AM-PM-CD = 'A' OR                              
A05020           VO-APPT-AM-PM-CD = 'P'                                 
A05020           PERFORM 7096B-GET-WORK-TIMES  THRU 7096B-EXIT          
A05020        ELSE                                                      
                 PERFORM 7096-GET-WORK-TIMES   THRU 7096-EXIT           
A05020        END-IF                                                    
           END-IF                                                       
           PERFORM 2120-GET-DESCRIPTIONS       THRU 2120-EXIT.          
A05020     IF VO-ACCOUNT-NO > 0                                         
A05020        PERFORM 2170-GET-RED-FLAG-COMM   THRU 2170-EXIT           
A05020     ELSE                                                         
A05020        IF VO-PREMISE-NO > 0                                      
A05020           PERFORM 2171-GET-RED-FLAG-COMM-PREM THRU 2171-EXIT     
A05020        END-IF                                                    
A05020     END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05020******************************************************************        
A05020*    2101-GET-COMPLIANCE-DATE                                    *        
A05020*        CALCULATES THE COMPLIANCE DATE                          *        
A05020******************************************************************        
A05020 2101-GET-COMPLIANCE-DATE.                                        
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                  
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT DATE                                              
MFA-TR*          INTO :WS-CURRENT-DATE                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     IF VO-ORDER-TYPE-CD = 'DNP01'                                
A05020        PERFORM 7002-GET-ACCT-DTLS       THRU 7002-EXIT           
A05020        IF AT-CODE-ACCT-STAT = 'A'                                
A05020           MOVE VO-ACCOUNT-NO         TO AT-ACCOUNT-NO            
A05020           PERFORM 5900-NEXT-BILL-DATE THRU                       
A05020                   5900-NEXT-BILL-DATE-EXIT                       
A05020           MOVE BN-DATE-EXTRACT       TO WS-NEXT-BILL-DATE        
A05020                                         WS-BILL-DT               
A05020        ELSE                                                      
A05020            MOVE SPACES TO WS-NEXT-BILL-DATE                      
A05020        END-IF                                                    
A05020     END-IF.                                                      
A05020                                                                  
A05020     MOVE S-COMPLIANCE-DAYS           TO WS-NO-OF-DAY.            
A05020     IF WS-SOLAR-TASK = 'Y'                                       
A05020        PERFORM 7796-GET-SOLAR-COMPLIANCE-DAYS   THRU 7796-EXIT   
A05020        MOVE WS-COMP-DAYS             TO S-COMPLIANCE-DAYS        
A05020        MOVE S-COMPLIANCE-DAYS        TO WS-NO-OF-DAY             
A05020     END-IF.                                                      
A05020                                                                  
A05020     IF S-COMPLIANCE-DAYS = 0                                     
A05020        MOVE S-ASSIGNED-DATE          TO S-COMPLIANCE-DATE        
A05020        MOVE S-COMPLIANCE-DATE(1:10)  TO WS-COMP-DT               
A05020        MOVE WS-COMPLIANCE-TS         TO S-COMPLIANCE-DATE        
A05020     ELSE                                                         
A05020       EVALUATE L3-COMPLY-DT-CALC-CD                              
A05020         WHEN 'AB'                                                
A05020            MOVE S-ASSIGNED-DATE      TO WS-NEW-BUSINESS-DAY      
A05020            PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU               
A05020                    6500-NEXT-BUSINESS-DAY-EXIT                   
A05020            MOVE WS-NEW-BUSINESS-DAY  TO S-COMPLIANCE-DATE        
A05020            MOVE S-COMPLIANCE-DATE(1:10) TO WS-COMP-DT            
A05020            MOVE WS-COMPLIANCE-TS     TO S-COMPLIANCE-DATE        
A05020         WHEN 'AC'                                                
A05020              EXEC SQL                                            
A05020                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, 
                                                   :S-COMPLIANCE-DAYS, 
           CIS.CHAR2TIMESTAMP(:S-ASSIGNED-DATE) ), 121), ' ', '-'), 
           ':', '.')
            INTO
              :S-COMPLIANCE-DATE  
A05020              END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*             EXEC SQL                                                    
MFA-TR*                SET :S-COMPLIANCE-DATE =                                 
MFA-TR*          TIMESTAMP(:S-ASSIGNED-DATE) + :S-COMPLIANCE-DAYS DAYS          
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020            MOVE S-COMPLIANCE-DATE(1:10) TO WS-COMP-DT            
A05020            MOVE WS-COMPLIANCE-TS     TO S-COMPLIANCE-DATE        
A05020         WHEN 'RB'                                                
A05020            MOVE VO-DATE-RECVED       TO WS-NEW-BUSINESS-DAY      
A05020            PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU               
A05020                    6500-NEXT-BUSINESS-DAY-EXIT                   
A05020            MOVE WS-NEW-BUSINESS-DAY  TO S-COMPLIANCE-DATE        
A05020            IF WS-NEW-BUSINESS-DAY < WS-CURRENT-DATE              
A05020               MOVE WS-CURRENT-DATE   TO S-COMPLIANCE-DATE        
A05020            END-IF                                                
A05020            MOVE S-COMPLIANCE-DATE(1:10) TO WS-COMP-DT            
A05020            MOVE WS-COMPLIANCE-TS     TO S-COMPLIANCE-DATE        
A05020         WHEN 'RC'                                                
A05020              EXEC SQL                                            
A05020                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, 
                                                   :S-COMPLIANCE-DAYS, 
           CIS.CHAR2TIMESTAMP(:VO-DATE-RECVED) ), 121), ' ', '-'), 
           ':', '.')
            INTO
              :S-COMPLIANCE-DATE   
A05020              END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*             EXEC SQL                                                    
MFA-TR*                SET :S-COMPLIANCE-DATE =                                 
MFA-TR*          TIMESTAMP(:VO-DATE-RECVED) + :S-COMPLIANCE-DAYS DAYS           
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020            IF S-COMPLIANCE-DATE(1:10) < WS-CURRENT-DATE          
A05020               MOVE WS-CURRENT-DATE   TO S-COMPLIANCE-DATE        
A05020            END-IF                                                
A05020            MOVE S-COMPLIANCE-DATE(1:10) TO WS-COMP-DT            
A05020            MOVE WS-COMPLIANCE-TS     TO S-COMPLIANCE-DATE        
A05020         WHEN OTHER                                               
A05020             MOVE SPACES                 TO S-COMPLIANCE-DATE     
A05020       END-EVALUATE                                               
A05020     END-IF.                                                      
A05020                                                                  
A05020     IF VO-ORDER-TYPE-CD = 'DNP01' AND WS-NEXT-BILL-DATE > SPACES 
A05020        IF S-COMPLIANCE-DATE > WS-BILL-TS                         
A05020           MOVE WS-BILL-TS               TO S-COMPLIANCE-DATE     
A05020        END-IF                                                    
A05020     END-IF.                                                      
A05020                                                                  
A05020 2101-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    2110-GET-ADDR-DTLS                                          *        
      *        GETS THE PREMISE ADDRESS                                *        
      ******************************************************************        
       2110-GET-ADDR-DTLS.                                              
                                                                        
           EVALUATE PR-ADDRESS-FORMAT                                   
               WHEN 'A'                                                 
                   PERFORM 7060A-FMT-PREMADDR  THRU 7060A-EXIT          
A05020             IF DY-ADDR-USAGE-CD = 'I'                            
A05020                MOVE SPACES              TO S-STREET-ADDRESS      
A05020                MOVE SPACES              TO S-STREET-NAME         
A05020                MOVE WS-STREET-ADDRESS-I TO S-STREET-ADDRESS      
A05020                MOVE WS-STREET-NAMES-I   TO S-STREET-NAME         
A05020             END-IF                                               
                   PERFORM 7065A-GET-COUNTY    THRU 7065A-EXIT          
               WHEN 'B'                                                 
                   PERFORM 7060B-FF-PREMADDR   THRU 7060B-EXIT          
               WHEN OTHER                                               
                   MOVE SPACES                 TO S-STREET-ADDRESS      
                                                  S-HOUSE-NO            
                                                  S-ADDR-PREFIX-1       
                                                  S-ADDR-PREFIX-2       
                                                  S-STREET-NAME         
                                                  S-STREET-SUFFIX       
                                                  S-ADDR-SUFFIX         
                                                  S-STREET-LOCATION-1   
                                                  S-STREET-LOCATION-2   
                                                  S-ADDR-STREET         
                                                  S-ADDR-CITY-STATE     
                                                  S-STATE               
                                                  S-TOWN                
                                                  S-COUNTRY             
           END-EVALUATE.                                                
                                                                        
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2120-GET-DESCRIPTIONS                                       *        
      *        GETS THE DESCRIPTIONS FOR ALL CODE VALUES               *        
      ******************************************************************        
       2120-GET-DESCRIPTIONS.                                           
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                           TO SW-COMPANY-NO.        
           MOVE 'CSS_ACCOUNT'                  TO SW-TABLE-NA.          
           MOVE 'CODE_ACCT_STAT'               TO SW-COLUMN-NA.         
           MOVE AT-CODE-ACCT-STAT              TO SW-CODE-VALUE.        
           PERFORM 7015-GET-SHORT-DESC         THRU 7015-EXIT.          
           MOVE SW-CODE-SHORT-DESC             TO S-CODE-ACCT-STAT.     
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                           TO SW-COMPANY-NO.        
           MOVE 'CSS_WORK_CATEGORY'            TO SW-TABLE-NA.          
           MOVE 'SO_BUSINESS_UNIT'             TO SW-COLUMN-NA.         
           MOVE VO-SO-BUSINESS-UNIT            TO SW-CODE-VALUE.        
           PERFORM 7050-GET-LONG-DESC          THRU 7050-EXIT.          
           MOVE SW-CODE-LONG-DESC              TO S-BUSINESS-UNIT.      
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                           TO SW-COMPANY-NO.        
           MOVE 'CSS_SO_DATA'                  TO SW-TABLE-NA.          
           MOVE 'ARRANGEMENT'                  TO SW-COLUMN-NA.         
           MOVE VO-HOME-ALL-DAY-FL             TO SW-CODE-VALUE.        
           PERFORM 7050-GET-LONG-DESC          THRU 7050-EXIT.          
           MOVE SW-CODE-LONG-DESC              TO S-HOME-ALL-DAY-FL.    
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2130-GET-ORDER-REASON-DESC.                                 *        
      *        GETS THE DESCRIPTIONS FOR ALL ORDER REASONS             *        
      ******************************************************************        
       2130-GET-ORDER-REASON-DESC.                                      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04753()                                           
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4753
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4753
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4753 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2130'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04753'            TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4753)                                                
      *       WITH PROCEDURE CSR04753                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4753 CURSOR FOR RESULT SET        
      *       :LOC4753                                                  
      *    END-EXEC.                                                    
                                                                        
           SET T1-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_4753 INTO                          
                   :RETURN-CODE-4753,                                   
                   :ORDER-REASON-CD-4753,                               
                   :ORDER-REASON-DESC-4753,                             
                   :ORDER-TYPE-CD-4753                                  
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4753 NOT = 0 AND                     
                       RETURN-CODE-4753 NOT = +100                      
                         MOVE RETURN-CODE-4753 TO                       
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '2130'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04753'        TO TABLE-1              
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4753 = +100                          
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 2140-PROCESS-4753 THRU 2140-EXIT        
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '2130'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04753'            TO TABLE-1              
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_SET_CSR_4753                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2140-PROCESS-4753                                           *        
      *        GETS ALL ORDER REASONS                                  *        
      ******************************************************************        
       2140-PROCESS-4753.                                               
                                                                        
           MOVE 0                      TO T1-RETURN-CODE (T1-INDEX).    
           MOVE ORDER-REASON-CD-4753   TO T1-ORDER-REASON-CD (T1-INDEX).
           MOVE ORDER-REASON-DESC-4753 TO                               
                                       T1-ORDER-REASON-DESC (T1-INDEX). 
           MOVE ORDER-TYPE-CD-4753     TO T1-ORDER-TYPE-CD (T1-INDEX).  
           SET T1-INDEX UP BY 1.                                        
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2150-GET-REASON-DESC                                        *        
      *        GETS ALL ORDER REASONS                                  *        
      ******************************************************************        
       2150-GET-REASON-DESC.                                            
                                                                        
           SET T1-INDEX TO +1.                                          
           SEARCH T1-CSR04753                                           
               AT END                                                   
                   CONTINUE                                             
               WHEN VO-ORDER-REASON    = T1-ORDER-REASON-CD (T1-INDEX)  
                AND VO-ORDER-TYPE-CD   = T1-ORDER-TYPE-CD (T1-INDEX)    
                        MOVE T1-ORDER-REASON-DESC (T1-INDEX) TO         
                             S-ORDER-REASON                             
           END-SEARCH.                                                  
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2160-GET-WORK-DISTRICT                                      *        
      *        GETS THE APPROPRIATE WORK DISTRICT                      *        
      ******************************************************************        
       2160-GET-WORK-DISTRICT.                                          
                                                                        
           INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
                                                        BY SPACES.      
           INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
                                                        BY SPACES.      
           INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
                                                        BY SPACES.      
           INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
                                                        BY SPACES.      
           INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
                                                        BY SPACES.      
           EVALUATE TRUE                                                
              WHEN VO-SO-BUSINESS-UNIT = 'EOP'                          
               AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
                   MOVE PR-FM-ELEC-SVC-WKDIST-TEXT    TO S-WORK-DISTRICT
              WHEN VO-SO-BUSINESS-UNIT = 'GOP'                          
               AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
                   MOVE PR-FM-GAS-OPS-WKDIST-TEXT     TO S-WORK-DISTRICT
              WHEN VO-SO-BUSINESS-UNIT = 'FSV'                          
               AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
                   MOVE PR-FM-FLD-SVCS-WKDIST-TEXT    TO S-WORK-DISTRICT
              WHEN VO-SO-BUSINESS-UNIT = 'RVP'                          
               AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
                   MOVE PR-FM-REV-PRT-WKDIST-TEXT     TO S-WORK-DISTRICT
              WHEN VO-SO-BUSINESS-UNIT = 'DSM'                          
               AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
                   MOVE PR-FM-DSM-ESVC-WKDIST-TEXT    TO S-WORK-DISTRICT
           END-EVALUATE.                                                
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2170-GET-RED-FLAG-COMM                                      *        
      *        GETS ALL RED FLAG COMMUNICATIONS FOR ACCOUNT            *        
      ******************************************************************        
       2170-GET-RED-FLAG-COMM.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :KO-RED-FLAG-EXPIRE-DT            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :KO-RED-FLAG-EXPIRE-DT = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7110-OPEN-COMM-CURSOR           THRU 7110-EXIT.      
           PERFORM 7111-FETCH-COMM-CURSOR          THRU 7111-EXIT.      
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE SPACES                       TO S-COMM-COMMENTS   
                 INSPECT KO-INITIAL-COMMENT-TX-TEXT                     
                 REPLACING ALL LOW-VALUES BY SPACES                     
                 MOVE KO-INITIAL-COMMENT-TX-TEXT   TO S-COMM-COMMENTS   
                 IF (KO-COMM-TYPE-CD      = '31' AND                    
                     KO-COMM-SUBTYPE-CODE = '02') OR                    
                    (KO-COMM-TYPE-CD      = '48')                       
                        MOVE 'Y' TO  S-RED-FLAG-SAFETY                  
                 END-IF                                                 
                 IF (KO-COMM-TYPE-CD      = '04' AND                    
                     KO-COMM-SUBTYPE-CODE = '06') OR                    
                    (KO-COMM-TYPE-CD      = '41' AND                    
                     KO-COMM-SUBTYPE-CODE = '09')                       
                        MOVE 'Y' TO  S-RED-FLAG-MAINT                   
                 END-IF                                                 
                 IF (KO-COMM-TYPE-CD      = '04' AND                    
                     KO-COMM-SUBTYPE-CODE = '17') OR                    
                    (KO-COMM-TYPE-CD      = '41' AND                    
                     KO-COMM-SUBTYPE-CODE = '05')                       
                        MOVE 'Y' TO  S-RED-FLAG-STORM                   
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7111-FETCH-COMM-CURSOR       THRU 7111-EXIT       
           END-PERFORM.                                                 
           PERFORM 7112-CLOSE-COMM-CURSOR          THRU 7112-EXIT.      
                                                                        
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2171-GET-RED-FLAG-COMM-PREM                                 *        
      *        GETS ALL RED FLAG COMMUNICATIONS FOR PREMISE            *        
      ******************************************************************        
       2171-GET-RED-FLAG-COMM-PREM.                                     
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :KO-RED-FLAG-EXPIRE-DT            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :KO-RED-FLAG-EXPIRE-DT = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7120-OPEN-COMM-PREM-CURSOR           THRU 7120-EXIT. 
           PERFORM 7121-FETCH-COMM-PREM-CURSOR          THRU 7121-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE SPACES                       TO S-COMM-COMMENTS   
                 INSPECT KO-INITIAL-COMMENT-TX-TEXT                     
                 REPLACING ALL LOW-VALUES BY SPACES                     
                 MOVE KO-INITIAL-COMMENT-TX-TEXT   TO S-COMM-COMMENTS   
                 IF (KO-COMM-TYPE-CD      = '31' AND                    
                     KO-COMM-SUBTYPE-CODE = '02') OR                    
                    (KO-COMM-TYPE-CD      = '48')                       
                        MOVE 'Y' TO  S-RED-FLAG-SAFETY                  
                 END-IF                                                 
                 IF (KO-COMM-TYPE-CD      = '04' AND                    
                     KO-COMM-SUBTYPE-CODE = '06') OR                    
                    (KO-COMM-TYPE-CD      = '41' AND                    
                     KO-COMM-SUBTYPE-CODE = '09')                       
                        MOVE 'Y' TO  S-RED-FLAG-MAINT                   
                 END-IF                                                 
                 IF (KO-COMM-TYPE-CD      = '04' AND                    
                     KO-COMM-SUBTYPE-CODE = '17') OR                    
                    (KO-COMM-TYPE-CD      = '41' AND                    
                     KO-COMM-SUBTYPE-CODE = '05')                       
                        MOVE 'Y' TO  S-RED-FLAG-STORM                   
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7121-FETCH-COMM-PREM-CURSOR       THRU 7121-EXIT  
           END-PERFORM.                                                 
           PERFORM 7122-CLOSE-COMM-PREM-CURSOR          THRU 7122-EXIT. 
                                                                        
       2171-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    2172-GET-ORDER-TASK-TYPE                                    *        
A05020*        GETS ALL TASK TYPES                                              
A05020******************************************************************        
A05020 2172-GET-ORDER-TASK-TYPE.                                        
A05020                                                                  
A05020     PERFORM 7130-OPEN-TASK-TYPE-CURSOR           THRU 7130-EXIT. 
A05020     PERFORM 7131-FETCH-TASK-TYPE-CURSOR          THRU 7131-EXIT. 
A05020     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A05020        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A05020           EVALUATE TY-VALIDATION-CD                              
A05020               WHEN 'SO'                                          
A05020                  IF VI-CODE-UTIL-TYPE = 'E'                      
AO5020                     IF VI-METER-SUPPLYING = TY-VALIDATE-CRITERIA 
AO5020                        MOVE TY-CLICK-VALUE      TO S-TASK-TYPE   
AO5020                        MOVE 'Y'                 TO WS-SOLAR-TASK 
AO5020                        MOVE TY-SO-BUSINESS-UNIT TO               
AO5020                             VO-SO-BUSINESS-UNIT                  
AO5020                        PERFORM 8020-UPDATE-BIZ-UNIT              
AO5020                                                 THRU 8020-EXIT   
A05020                        GO TO 2172-EXIT                           
A05020                     END-IF                                       
A05020                  END-IF                                          
A05020               WHEN 'TW'                                          
A05020                    PERFORM 7001-GET-WT-APPL      THRU 7001-EXIT  
A05020                    IF WS-WT-APPL = 'Y'                           
A05020                       MOVE TY-CLICK-VALUE        TO S-TASK-TYPE  
A05020                       GO TO 2172-EXIT                            
A05020                    END-IF                                        
A05020               WHEN 'OH'                                          
A05020                  IF VI-CODE-UTIL-TYPE = 'E'                      
A05020                     PERFORM 7003-GET-POINT-ID   THRU 7003-EXIT   
A05020                     IF MN-POINT-ID > 0 AND                       
A05020                        WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL   
A05020                        MOVE MN-POINT-ID(1:3)     TO PP-AREA-ID   
A05020                        MOVE MN-POINT-ID(4:7)     TO PP-TAG-NM    
A05020                        PERFORM 7004-POINT-CLASS THRU 7004-EXIT   
A05020                        IF PP-POINT-CLASS-NA = 'REBA.POLE'        
A05020                          MOVE TY-CLICK-VALUE     TO S-TASK-TYPE  
A05020                          GO TO 2172-EXIT                         
A05020                        END-IF                                    
A05020                     END-IF                                       
A05020                  END-IF                                          
A05020               WHEN 'UG'                                          
A05020                  IF VI-CODE-UTIL-TYPE = 'E'                      
A05020                    PERFORM 7003-GET-POINT-ID     THRU 7003-EXIT  
A05020                    IF MN-POINT-ID > 0 AND                        
A05020                       WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
A05020                       MOVE MN-POINT-ID(1:3)      TO PP-AREA-ID   
A05020                       MOVE MN-POINT-ID(4:7)      TO PP-TAG-NM    
A05020                       PERFORM 7004-POINT-CLASS   THRU 7004-EXIT  
A05020                       IF PP-POINT-CLASS-NA NOT EQUAL             
A05020                          'REDBA.POLE' AND                        
A05020                          WS-ACTIVE-RETURN-CODE =                 
A05020                          SUCCESSFUL-CALL                         
A05020                          MOVE TY-CLICK-VALUE     TO S-TASK-TYPE  
A05020                          GO TO 2172-EXIT                         
A05020                       END-IF                                     
A05020                    END-IF                                        
A05020                 END-IF                                           
A05020               WHEN 'SM'                                          
A05020               WHEN 'TM'                                          
A05020               WHEN 'BM'                                          
A05020                  IF VI-CODE-UTIL-TYPE = 'E'                      
A05020                     PERFORM 7795-GET-MULTI-REGISTER THRU         
A05020                                                         7795-EXIT
A05020                     IF WS-MULTI-REGISTER = 'Y'                   
A05020                        PERFORM 7006-GET-ELEC-MTR   THRU 7006-EXIT
A05020                        PERFORM 7007-GET-FORM-CD    THRU 7007-EXIT
A05020                        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL
A05020                           PERFORM 2173-GET-METER-TASK-TYPE       
A05020                                                    THRU 2173-EXIT
A05020                        END-IF                                    
A05020                     END-IF                                       
A05020                  END-IF                                          
A05020                  IF WS-TASK-FND = 'Y'                            
A05020                     GO TO 2172-EXIT                              
A05020                  END-IF                                          
A05020               WHEN 'SP'                                          
A05020               WHEN 'TP'                                          
A05020               WHEN 'BI'                                          
A05020                  IF VI-CODE-UTIL-TYPE = 'E'                      
A05020                     PERFORM 7006-GET-ELEC-MTR   THRU 7006-EXIT   
A05020                     PERFORM 7007-GET-FORM-CD    THRU 7007-EXIT   
A05020                     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL   
A05020                        PERFORM 2173-GET-METER-TASK-TYPE          
A05020                                                 THRU 2173-EXIT   
A05020                     END-IF                                       
A05020                  END-IF                                          
A05020                  IF WS-TASK-FND = 'Y'                            
A05020                     GO TO 2172-EXIT                              
A05020                  END-IF                                          
A05020               WHEN OTHER                                         
A05020                    MOVE SPACES                  TO S-TASK-TYPE   
A05020           END-EVALUATE                                           
A05020        END-IF                                                    
A05020        PERFORM 7131-FETCH-TASK-TYPE-CURSOR      THRU 7131-EXIT   
A05020     END-PERFORM.                                                 
A05020*    PERFORM 7132-CLOSE-TASK-TYPE-CURSOR         THRU 7132-EXIT.          
A05020                                                                  
A05020 2172-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    2173-GET-METER-TASK-TYPE                                    *        
A05020*        GETS ALL TASK TYPES                                              
A05020******************************************************************        
A05020 2173-GET-METER-TASK-TYPE.                                        
A05020                                                                  
A05020     IF TY-VALIDATION-CD = 'SP' OR TY-VALIDATION-CD = 'SM'        
A05020         SET WS-TBL-INDX                  TO +1                   
A05020         SEARCH WS-SINGLE-FORM-CODE-TBL VARYING WS-TBL-INDX       
A05020          AT END                                                  
A05020          CONTINUE                                                
A05020          WHEN U0-ELEC-MTR-FORM-CD  =                             
A05020               WS-SINGLE-FORM-CODE(WS-TBL-INDX)                   
A05020               MOVE TY-CLICK-VALUE        TO S-TASK-TYPE          
A05020               MOVE 'Y'                   TO WS-TASK-FND          
A05020        END-SEARCH                                                
A05020     END-IF.                                                      
A05020                                                                  
A05020     IF U0-ELEC-MTR-FORM-CD = '16S'                               
A05020        AND (TY-VALIDATION-CD = 'TP' OR TY-VALIDATION-CD = 'TM')  
A05020        MOVE TY-CLICK-VALUE                TO S-TASK-TYPE         
A05020        MOVE 'Y'                           TO WS-TASK-FND         
A05020     END-IF.                                                      
A05020                                                                  
A05020     IF TY-VALIDATION-CD = 'BI' OR TY-VALIDATION-CD = 'BM'        
A05020         SET WS-TBL-INDX1                  TO +1                  
A05020         SEARCH WS-BOLTED-FORM-CODE-TBL VARYING WS-TBL-INDX1      
A05020          AT END                                                  
A05020          CONTINUE                                                
A05020          WHEN U0-ELEC-MTR-FORM-CD =                              
A05020               WS-BOLTED-FORM-CODE(WS-TBL-INDX1)                  
A05020               MOVE TY-CLICK-VALUE         TO S-TASK-TYPE         
A05020               MOVE 'Y'                    TO WS-TASK-FND         
A05020        END-SEARCH                                                
A05020     END-IF.                                                      
A05020                                                                  
A05020 2173-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    2180-GET-SERVICE-CHARGES.                                   *        
      *        GETS THE TOTAL CHARGES                                  *        
      ******************************************************************        
       2180-GET-SERVICE-CHARGES.                                        
                                                                        
           MOVE VI-SERV-ORDER-NO         TO SERV-ORDER-NO-1136.         
           MOVE 'C'                      TO HISTORY-FLAG-1136.          
           MOVE 'Y'                      TO WS-LOAD-CHARGE.             
           MOVE 0                        TO S-SERVICE-CHARGES.          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01136(:SERV-ORDER-NO-1136,:HISTORY-FLAG-1136)     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1136
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1136
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1136 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2180'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01136'            TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1136)                                                
      *       WITH PROCEDURE CSR01136                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1136 CURSOR FOR RESULT SET        
      *       :LOC1136                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1136 INTO                            
                 :TOTAL-CHARGES-AM-1136,                                
                 :WORK-COMPLETED-1136,                                  
                 :CATHODIC-PROTECT-1136,                                
                 :FIXED-LABOR-CHRG-1136                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE TOTAL-CHARGES-AM-1136 TO S-SERVICE-CHARGES      
                                                 WS-SERVICE-CHARGES     
               WHEN NOT-FOUND                                           
                   SET NO-MORE-ROWS TO TRUE                             
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE 0 TO S-SERVICE-CHARGES                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '2180'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01136'            TO TABLE-1                
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              CLOSE RESULT_SET_CSR_1136                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       2180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2190-CHECK-DAY-OF-WEEK                                      *        
      *        GETS ALL RED FLAG COMMUNICATIONS                        *        
      ******************************************************************        
       2190-CHECK-DAY-OF-WEEK.                                          
                                                                        
           EVALUATE WS-DAY-OF-WEEK                                      
               WHEN '1'                                                 
                   MOVE '7'                      TO WS-DAY-OF-WEEK      
               WHEN '2'                                                 
                   MOVE '1'                      TO WS-DAY-OF-WEEK      
               WHEN '3'                                                 
                   MOVE '2'                      TO WS-DAY-OF-WEEK      
               WHEN '4'                                                 
                   MOVE '3'                      TO WS-DAY-OF-WEEK      
               WHEN '5'                                                 
                   MOVE '4'                      TO WS-DAY-OF-WEEK      
               WHEN '6'                                                 
                   MOVE '5'                      TO WS-DAY-OF-WEEK      
               WHEN '7'                                                 
                   MOVE '6'                      TO WS-DAY-OF-WEEK      
           END-EVALUATE.                                                
                                                                        
       2190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-GET-APPLIANCE-DTLS                                     *        
      *        GETS ALL APPLIANCE DETAILS                              *        
      ******************************************************************        
       2200-GET-APPLIANCE-DTLS.                                         
                                                                        
           IF WS-GAS-FOUND = WS-YES                                     
              PERFORM 7200-OPEN-APPL-CURSOR            THRU 7200-EXIT   
              PERFORM 7201-FETCH-APPL-CURSOR           THRU 7201-EXIT   
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 IF WS-GTT02-DECLARED = 'N'                             
                    PERFORM 0102-DECLARE-GTT02         THRU 0102-EXIT   
                 END-IF                                                 
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE 0                        TO S-RETURN-CODE-2    
                    MOVE WS-GAS-INST-NO           TO S-SO-INST-SEQ-NO-2 
                    MOVE VQ-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE-2 
                    PERFORM 7210-GET-APPLIANCE         THRU 7210-EXIT   
                    PERFORM 7220-GET-APPLIANCE-TYPE    THRU 7220-EXIT   
                    PERFORM 8200-SEND-RESULT-2         THRU 8200-EXIT   
                 END-IF                                                 
                 PERFORM 7201-FETCH-APPL-CURSOR        THRU 7201-EXIT   
              END-PERFORM                                               
              PERFORM 7202-CLOSE-APPL-CURSOR           THRU 7202-EXIT   
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    2200E-GET-EMER-APPL-DTLS                                    *        
A05020*        GETS ALL APPLIANCE DETAILS                              *        
A05020******************************************************************        
A05020 2200E-GET-EMER-APPL-DTLS.                                        
A05020                                                                  
A05020     IF WS-GAS-FOUND = WS-YES                                     
A05020        PERFORM 7200E-OPEN-EMER-APPL-CURSOR      THRU 7200E-EXIT  
A05020        PERFORM 7201E-FETCH-EMER-APPL-CURSOR     THRU 7201E-EXIT  
A05020        PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
A05020           IF WS-GTT02-DECLARED = 'N'                             
A05020              PERFORM 0102-DECLARE-GTT02         THRU 0102-EXIT   
A05020           END-IF                                                 
A05020           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
A05020              MOVE 0                        TO S-RETURN-CODE-2    
A05020              MOVE WS-GAS-INST-NO           TO S-SO-INST-SEQ-NO-2 
A05020              MOVE SPACES                   TO S-CODE-UTIL-TYPE-2 
A05020              PERFORM 7210E-GET-APPLIANCE         THRU 7210E-EXIT 
A05020              PERFORM 7220-GET-APPLIANCE-TYPE    THRU 7220-EXIT   
A05020              PERFORM 8200-SEND-RESULT-2         THRU 8200-EXIT   
A05020           END-IF                                                 
A05020           PERFORM 7201E-FETCH-EMER-APPL-CURSOR  THRU 7201E-EXIT  
A05020        END-PERFORM                                               
A05020        PERFORM 7202E-CLOSE-EMER-APPL-CURSOR     THRU 7202E-EXIT  
A05020     END-IF.                                                      
A05020                                                                  
A05020 2200E-EXIT.                                                      
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    2300-GET-CHARGES-DTLS                                       *        
      *        GETS ALL CHARGES DETAILS                                *        
      ******************************************************************        
       2300-GET-CHARGES-DTLS.                                           
                                                                        
           PERFORM 7300-OPEN-CHARGES-CURSOR            THRU 7300-EXIT.  
           PERFORM 7301-FETCH-CHARGES-CURSOR           THRU 7301-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF WS-GTT03-DECLARED = 'N'                                
                 PERFORM 0103-DECLARE-GTT03            THRU 0103-EXIT   
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 0                    TO S-RETURN-CODE-3           
                 IF VG-CODE-UTIL-TYPE = WS-GAS                          
                    MOVE WS-GAS-INST-NO    TO S-SO-INST-SEQ-NO-3        
                 END-IF                                                 
                 IF VG-CODE-UTIL-TYPE = WS-ELECTRIC                     
                    MOVE WS-ELEC-INST-NO   TO S-SO-INST-SEQ-NO-3        
                 END-IF                                                 
                 MOVE VG-CODE-UTIL-TYPE    TO S-CODE-UTIL-TYPE-3        
                 PERFORM 7310-GET-WORK-PERIOD         THRU 7310-EXIT    
                 PERFORM 7320-GET-WAIVER-TYPE-DESC    THRU 7320-EXIT    
                 PERFORM 8300-SEND-RESULT-3           THRU 8300-EXIT    
              END-IF                                                    
              PERFORM 7301-FETCH-CHARGES-CURSOR       THRU 7301-EXIT    
           END-PERFORM.                                                 
           PERFORM 7302-CLOSE-CHARGES-CURSOR          THRU 7302-EXIT.   
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400A-GET-MTRD-ENVRNMT                                      *        
      *        GETS ALL METER DETAILS FOR GROUP A ORDER TYPES          *        
      ******************************************************************        
       2400A-GET-MTRD-ENVRNMT.                                          
                                                                        
           PERFORM 7400A-OPEN-METER-CURSOR             THRU 7400A-EXIT. 
           PERFORM 7401A-FETCH-METER-CURSOR            THRU 7401A-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT04-DECLARED = 'N'                              
                   PERFORM 0104-DECLARE-GTT04          THRU 0104-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                     TO S-RETURN-CODE-4        
                   MOVE WS-MTR-ACCESSIBLE-DT  TO S-MTR-ACCESSIBLE-DT    
                   PERFORM 2410-GET-DESCRIPTIONS THRU 2410-EXIT         
                   MOVE MN-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-4     
A05020             MOVE MN-CODE-UTIL-TYPE     TO VC-CODE-UTIL-TYPE      
A05020             MOVE MN-METER-NO           TO VC-METER-NO            
                   MOVE MN-METER-NO           TO S-METER-NO-4           
A05020             MOVE MN-IC-NO              TO VC-IC-NO               
                   MOVE MN-IC-NO              TO S-IC-NO-4              
                   MOVE MN-MTR-REF-NO         TO S-MTR-REF-NO-4         
                   MOVE MN-REG-ID-NO          TO S-REG-ID-NO-4          
                   MOVE MN-LAST-READ-VALUE    TO S-LAST-MTR-READ-VALUE  
                   MOVE MN-LAST-REG-READ-DATE TO S-LAST-MTR-READ-DATE   
                   PERFORM 7405-GET-MTR-CAP            THRU 7405-EXIT   
                   IF MN-GIS-POINT-ID > 0                               
                      PERFORM 7090-PIM-POINT-INFO      THRU 7090-EXIT   
                   ELSE                                                 
                      MOVE MN-POINT-ID        TO S-METER-POINT-ID       
                   END-IF                                               
                   MOVE MN-MIN-NO-UNITS       TO S-MIN-NO-UNITS-4       
                   MOVE MN-MAX-NO-UNITS       TO S-MAX-NO-UNITS-4       
                   MOVE MN-CODE-UTIL-TYPE     TO VC-CODE-UTIL-TYPE      
                   MOVE MN-IC-NO              TO VC-IC-NO               
                   PERFORM 7420-RATES-INFO             THRU 7420-EXIT   
                   IF (S-WORK-TYPE-CD-4 = 'UDP' OR                      
                       S-WORK-TYPE-CD-4 = 'UNB' OR                      
                       S-WORK-TYPE-CD-4 = 'MCU' OR                      
                       S-WORK-TYPE-CD-4 = 'REC')                        
                       MOVE 999               TO S-USAGE-HIGH-PCT-4     
                       MOVE 999               TO S-USAGE-LOW-PCT-4      
                   ELSE                                                 
                       MOVE O9-USAGE-HIGH-PCT TO S-USAGE-HIGH-PCT-4     
                       MOVE O9-USAGE-LOW-PCT  TO S-USAGE-LOW-PCT-4      
                   END-IF                                               
                   PERFORM 7430-READ-INFO              THRU 7430-EXIT   
                   IF MN-CODE-UTIL-TYPE  = WS-ELECTRIC                  
                      PERFORM 7440-ELEC-METER-INFO     THRU 7440-EXIT   
                      PERFORM 7450-MTR-CL-AMPS-INFO    THRU 7450-EXIT   
                   ELSE                                                 
                      IF MN-CODE-UTIL-TYPE = WS-GAS                     
                         PERFORM 7460-GAS-METER-INFO   THRU 7460-EXIT   
                      END-IF                                            
                   END-IF                                               
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES TO S-CODE-MTR-STATUS-WS               
                      MOVE SPACES TO S-CODE-STATUS-REASON-4             
                   END-IF                                               
P01176             IF WS-SAMPLE-TEST = 'Y'                              
P01176                MOVE 'SAMPLE TEST'      TO S-CODE-STATUS-REASON-4 
P01176             END-IF                                               
                   PERFORM 7410-METER-INFO              THRU 7410-EXIT  
                   MOVE MN-CODE-UTIL-TYPE     TO OA-CODE-UTIL-TYPE      
                   MOVE MN-CODE-USAGE-TYPE    TO OA-CODE-USAGE-TYPE     
                   MOVE MN-CODE-TIME-PERIOD   TO OA-CODE-TIME-PERIOD    
                   MOVE MN-REG-ID-NO          TO OA-REG-ID-NO           
                   PERFORM 7520-GET-MTR-RD-FMT          THRU 7520-EXIT  
                   MOVE OA-READ-SEQUENCE-NO   TO S-READ-SEQUENCE-NO-4   
                   MOVE OA-INDEX-VALUE-CD     TO S-INDEX-VALUE-CD-4     
                   MOVE OA-NO-READ-DIGITS     TO S-NO-READ-DIGITS-4     
                   MOVE OA-NO-READ-DECIMALS   TO S-NO-READ-DECIMALS-4   
                   INITIALIZE DCLCSS-CODE-VALUE                         
                   MOVE VO-COMPANY-NO         TO UV-COMPANY-NO          
                   MOVE +17                   TO UV-TABLE-NA-LEN        
                   MOVE 'CSS_MTR_RD_FMT'      TO UV-TABLE-NA-TEXT       
                   MOVE +14                   TO UV-COLUMN-NA-LEN       
                   MOVE 'MTR_RD_DISP_CD'      TO UV-COLUMN-NA-TEXT      
                   MOVE +3                    TO UV-CODE-VALUE-LEN      
                   MOVE OA-MTR-RD-DISP-CD     TO UV-CODE-VALUE-TEXT     
                   PERFORM 7470-GET-LONG-DESC      THRU 7470-EXIT       
                   MOVE UV-CODE-LONG-DESC-TEXT  TO S-MTR-RD-DISP-CD-4   
                                                                        
                   INITIALIZE DCLCSS-CODE-VALUE                         
                   MOVE VO-COMPANY-NO           TO UV-COMPANY-NO        
                   MOVE +17                     TO UV-TABLE-NA-LEN      
                   MOVE 'CSS_MTR_RD_FMT'        TO UV-TABLE-NA-TEXT     
                   MOVE +14                     TO UV-COLUMN-NA-LEN     
                   MOVE 'INDEX_VALUE_CD'        TO UV-COLUMN-NA-TEXT    
                   MOVE +1                      TO UV-CODE-VALUE-LEN    
                   MOVE OA-INDEX-VALUE-CD       TO UV-CODE-VALUE-TEXT   
                   PERFORM 7470-GET-LONG-DESC   THRU 7470-EXIT          
                   MOVE UV-CODE-LONG-DESC-TEXT  TO S-INDEX-VALUE-CD-4   
                   PERFORM 8400-SEND-RESULT-4           THRU 8400-EXIT  
                END-IF                                                  
                PERFORM 7401A-FETCH-METER-CURSOR        THRU 7401A-EXIT 
           END-PERFORM.                                                 
           PERFORM 7402A-CLOSE-METER-CURSOR             THRU 7402A-EXIT.
                                                                        
       2400A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400B-GET-UTIL-DTLS                                         *        
      *        GETS ALL UTILITY DATA FOR SETS                          *        
      ******************************************************************        
       2400B-GET-UTIL-DTLS.                                             
                                                                        
           PERFORM 7400B-OPEN-UTIL-CURSOR              THRU 7400B-EXIT. 
           PERFORM 7401B-FETCH-UTIL-CURSOR             THRU 7401B-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT04-DECLARED = 'N'                              
                   PERFORM 0104-DECLARE-GTT04          THRU 0104-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                     TO S-RETURN-CODE-4        
                   MOVE WS-MTR-ACCESSIBLE-DT  TO S-MTR-ACCESSIBLE-DT    
                   INITIALIZE DCLCSS-SO-CODE-DESC                       
                   MOVE '01'                  TO SW-COMPANY-NO          
                   MOVE 'CSS_SO_DATA'         TO SW-TABLE-NA            
                   MOVE 'MTR_ACCESSIBLE'      TO SW-COLUMN-NA           
                   MOVE WS-MTR-ACCESSIBLE-CD  TO SW-CODE-VALUE          
                   PERFORM 7015-GET-SHORT-DESC   THRU 7015-EXIT         
                   MOVE SW-CODE-SHORT-DESC    TO S-MTR-ACCESSIBLE-CD    
                                                                        
                   INITIALIZE DCLCSS-SO-CODE-DESC                       
                   MOVE '01'                  TO SW-COMPANY-NO          
                   MOVE 'CSS_SO_DATA'         TO SW-TABLE-NA            
                   MOVE 'MTR_ACCESSIBLE_RSN'  TO SW-COLUMN-NA           
                   MOVE WS-MTR-ACCESSIBLE-RSN TO SW-CODE-VALUE          
                   PERFORM 7015-GET-SHORT-DESC   THRU 7015-EXIT         
                   MOVE SW-CODE-SHORT-DESC    TO S-MTR-ACCESSIBLE-RSN   
                                                                        
                   MOVE VE-CODE-UTIL-TYPE     TO VC-CODE-UTIL-TYPE      
                   MOVE VE-IC-NO              TO VC-IC-NO               
                   MOVE VE-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-4     
                   MOVE VE-IC-NO              TO S-IC-NO-4              
                   PERFORM 7420-RATES-INFO       THRU 7420-EXIT         
                   IF (S-WORK-TYPE-CD-4 = 'UDP' OR                      
                       S-WORK-TYPE-CD-4 = 'UNB' OR                      
                       S-WORK-TYPE-CD-4 = 'MCU' OR                      
                       S-WORK-TYPE-CD-4 = 'REC')                        
                       MOVE 999               TO S-USAGE-HIGH-PCT-4     
                       MOVE 999               TO S-USAGE-LOW-PCT-4      
                   ELSE                                                 
                       MOVE O9-USAGE-HIGH-PCT TO S-USAGE-HIGH-PCT-4     
                       MOVE O9-USAGE-LOW-PCT  TO S-USAGE-LOW-PCT-4      
                   END-IF                                               
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES TO S-CODE-MTR-STATUS-WS               
                      MOVE SPACES TO S-CODE-STATUS-REASON-4             
                   END-IF                                               
P01176             IF WS-SAMPLE-TEST = 'Y'                              
P01176                MOVE 'SAMPLE TEST'      TO S-CODE-STATUS-REASON-4 
P01176             END-IF                                               
                   PERFORM 8400-SEND-RESULT-4    THRU 8400-EXIT         
                END-IF                                                  
                PERFORM 7401B-FETCH-UTIL-CURSOR  THRU 7401B-EXIT        
           END-PERFORM.                                                 
           PERFORM 7402B-CLOSE-UTIL-CURSOR       THRU 7402B-EXIT.       
                                                                        
       2400B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400C-GET-SOMETER                                           *        
      *        GETS ALL SO METER DATA FOR SETS                         *        
      ******************************************************************        
       2400C-GET-SOMETER.                                               
                                                                        
           PERFORM 7400C-OPEN-SOMETER-CURSOR         THRU 7400C-EXIT.   
           PERFORM 7401C-FETCH-SOMETER-CURSOR        THRU 7401C-EXIT.   
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT04-DECLARED = 'N'                              
                   PERFORM 0104-DECLARE-GTT04          THRU 0104-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE WS-YES                TO WS-SOMETER-CHK         
                   MOVE 0                     TO S-RETURN-CODE-4        
                   MOVE VM-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-4     
                   MOVE VM-IC-NO              TO S-IC-NO-4              
                   MOVE VM-MTR-REF-NO         TO S-MTR-REF-NO-4         
                   MOVE WS-MTR-ACCESSIBLE-DT  TO S-MTR-ACCESSIBLE-DT    
                   INITIALIZE DCLCSS-SO-CODE-DESC                       
                   MOVE '01'                  TO SW-COMPANY-NO          
                   MOVE 'CSS_SO_DATA'         TO SW-TABLE-NA            
                   MOVE 'MTR_ACCESSIBLE'      TO SW-COLUMN-NA           
                   MOVE WS-MTR-ACCESSIBLE-CD  TO SW-CODE-VALUE          
                   PERFORM 7015-GET-SHORT-DESC   THRU 7015-EXIT         
                   MOVE SW-CODE-SHORT-DESC    TO S-MTR-ACCESSIBLE-CD    
                                                                        
                   INITIALIZE DCLCSS-SO-CODE-DESC                       
                   MOVE '01'                  TO SW-COMPANY-NO          
                   MOVE 'CSS_SO_DATA'         TO SW-TABLE-NA            
                   MOVE 'MTR_ACCESSIBLE_RSN'  TO SW-COLUMN-NA           
                   MOVE WS-MTR-ACCESSIBLE-RSN TO SW-CODE-VALUE          
                   PERFORM 7015-GET-SHORT-DESC   THRU 7015-EXIT         
                   MOVE SW-CODE-SHORT-DESC    TO S-MTR-ACCESSIBLE-RSN   
                                                                        
                   PERFORM 7490-CHK-UTILITY      THRU 7490-EXIT         
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                      MOVE VI-CODE-UTIL-TYPE  TO S-CODE-UTIL-TYPE-4     
                      MOVE VI-IC-NO           TO S-IC-NO-4              
                      PERFORM 7425-RATES-INFO    THRU 7425-EXIT         
                      MOVE O9-USAGE-HIGH-PCT  TO S-USAGE-HIGH-PCT-4     
                      MOVE O9-USAGE-LOW-PCT   TO S-USAGE-LOW-PCT-4      
                   ELSE                                                 
                      PERFORM 7491-CHK-UTL-CHG   THRU 7491-EXIT         
                      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL        
                         MOVE VE-CODE-UTIL-TYPE  TO VC-CODE-UTIL-TYPE   
                         MOVE VE-IC-NO           TO VC-IC-NO            
                         MOVE VE-CODE-UTIL-TYPE  TO S-CODE-UTIL-TYPE-4  
                         MOVE VE-IC-NO           TO S-IC-NO-4           
                         PERFORM 7420-RATES-INFO THRU 7420-EXIT         
                         MOVE O9-USAGE-HIGH-PCT  TO S-USAGE-HIGH-PCT-4  
                         MOVE O9-USAGE-LOW-PCT   TO S-USAGE-LOW-PCT-4   
                      END-IF                                            
                   END-IF                                               
                   IF (S-WORK-TYPE-CD-4 = 'UDP' OR                      
                       S-WORK-TYPE-CD-4 = 'UNB' OR                      
                       S-WORK-TYPE-CD-4 = 'MCU' OR                      
                       S-WORK-TYPE-CD-4 = 'REC')                        
                       MOVE 999               TO S-USAGE-HIGH-PCT-4     
                       MOVE 999               TO S-USAGE-LOW-PCT-4      
                   ELSE                                                 
                       MOVE O9-USAGE-HIGH-PCT TO S-USAGE-HIGH-PCT-4     
                       MOVE O9-USAGE-LOW-PCT  TO S-USAGE-LOW-PCT-4      
                   END-IF                                               
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES TO S-CODE-MTR-STATUS-WS               
                      MOVE SPACES TO S-CODE-STATUS-REASON-4             
                   END-IF                                               
                   IF VM-CODE-UTIL-TYPE = WS-GAS                        
                      INITIALIZE DCLCSS-SO-CODE-DESC                    
                      MOVE WS-COMPANY                TO SW-COMPANY-NO   
                      MOVE 'CSS_MTRD_ENVRNMT'        TO SW-TABLE-NA     
                      MOVE 'METER_PRESSURE'          TO SW-COLUMN-NA    
                      MOVE VM-METER-PRESSURE         TO WS-MTR-PRESSURE 
                      MOVE WS-METER-PRESSURE         TO SW-CODE-VALUE   
                      PERFORM 7015-GET-SHORT-DESC    THRU 7015-EXIT     
                      MOVE SW-CODE-SHORT-DESC        TO S-CASE-PRESSURE 
                   END-IF                                               
P01176             IF WS-SAMPLE-TEST = 'Y'                              
P01176                MOVE 'SAMPLE TEST'      TO S-CODE-STATUS-REASON-4 
P01176             END-IF                                               
                   MOVE '1900-01-01-00.00.00.000000' TO                 
                   S-LAST-MTR-READ-DATE                                 
                   PERFORM 8400-SEND-RESULT-4    THRU 8400-EXIT         
                END-IF                                                  
                PERFORM 7401C-FETCH-SOMETER-CURSOR  THRU 7401C-EXIT     
           END-PERFORM.                                                 
           PERFORM 7402C-CLOSE-SOMETER-CURSOR       THRU 7402C-EXIT.    
                                                                        
       2400C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400-GET-METER-DTLS                                         *        
      *        GETS ALL METER DETAILS                                  *        
      ******************************************************************        
       2400-GET-METER-DTLS.                                             
                                                                        
           PERFORM 7400-OPEN-METER-CURSOR              THRU 7400-EXIT.  
           PERFORM 7401-FETCH-METER-CURSOR             THRU 7401-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT04-DECLARED = 'N'                              
                   PERFORM 0104-DECLARE-GTT04          THRU 0104-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                     TO S-RETURN-CODE-4        
                   MOVE WS-MTR-ACCESSIBLE-DT  TO S-MTR-ACCESSIBLE-DT    
                   MOVE VC-METER-PRESSURE     TO MN-METER-PRESSURE      
                   MOVE VC-CODE-UTIL-TYPE     TO MN-CODE-UTIL-TYPE      
                   PERFORM 2410-GET-DESCRIPTIONS THRU 2410-EXIT         
                   MOVE VC-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-4     
                                                 MN-CODE-UTIL-TYPE      
                   EVALUATE VC-CODE-DEST                                
                     WHEN WS-A                                          
                        MOVE 'INVENTORY'      TO S-CODE-DEST            
                     WHEN WS-C                                          
                        MOVE 'IN TRANSIT'     TO S-CODE-DEST            
                   END-EVALUATE                                         
                   MOVE VC-METER-NO           TO S-METER-NO-4           
                   MOVE VC-IC-NO              TO S-IC-NO-4              
                                                 MN-IC-NO               
                   MOVE VC-MTR-REF-NO         TO S-MTR-REF-NO-4         
                                                 MN-MTR-REF-NO          
                   MOVE VC-REG-ID-NO          TO S-REG-ID-NO-4          
                   MOVE VC-LAST-READ-VALUE    TO S-LAST-MTR-READ-VALUE  
                   MOVE VC-LAST-REG-READ-DATE TO S-LAST-MTR-READ-DATE   
                   PERFORM 7410-METER-INFO             THRU 7410-EXIT   
                   PERFORM 7415-GET-REMOTE-IND         THRU 7415-EXIT   
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                      IF MN-GIS-POINT-ID > 0                            
                         PERFORM 7090-PIM-POINT-INFO   THRU 7090-EXIT   
                      ELSE                                              
                         MOVE MN-POINT-ID        TO S-METER-POINT-ID    
                      END-IF                                            
                      MOVE MN-MIN-NO-UNITS       TO S-MIN-NO-UNITS-4    
                      MOVE MN-MAX-NO-UNITS       TO S-MAX-NO-UNITS-4    
                      PERFORM 7420-RATES-INFO            THRU 7420-EXIT 
                      IF (S-WORK-TYPE-CD-4 = 'UDP' OR                   
                          S-WORK-TYPE-CD-4 = 'UNB' OR                   
                          S-WORK-TYPE-CD-4 = 'MCU' OR                   
                          S-WORK-TYPE-CD-4 = 'REC')                     
                          MOVE 999               TO S-USAGE-HIGH-PCT-4  
                          MOVE 999               TO S-USAGE-LOW-PCT-4   
                      ELSE                                              
                          MOVE O9-USAGE-HIGH-PCT TO S-USAGE-HIGH-PCT-4  
                          MOVE O9-USAGE-LOW-PCT  TO S-USAGE-LOW-PCT-4   
                      END-IF                                            
                      PERFORM 7430-READ-INFO             THRU 7430-EXIT 
                      IF VC-CODE-UTIL-TYPE  = WS-ELECTRIC               
                         PERFORM 7440-ELEC-METER-INFO    THRU 7440-EXIT 
                         PERFORM 7450-MTR-CL-AMPS-INFO   THRU 7450-EXIT 
                      ELSE                                              
                         IF VC-CODE-UTIL-TYPE = WS-GAS                  
                            PERFORM 7460-GAS-METER-INFO  THRU 7460-EXIT 
                         END-IF                                         
                      END-IF                                            
                    END-IF                                              
                    PERFORM 7480-GET-DEST-NO             THRU 7480-EXIT 
                    IF VO-ORDER-TYPE-CD = 'FW019' OR                    
                       VO-ORDER-TYPE-CD = 'FW016'                       
                       MOVE SPACES TO S-CODE-MTR-STATUS-WS              
                       MOVE SPACES TO S-CODE-STATUS-REASON-4            
                    END-IF                                              
P01176              IF WS-SAMPLE-TEST = 'Y'                             
P01176                 MOVE 'SAMPLE TEST'     TO S-CODE-STATUS-REASON-4 
P01176              END-IF                                              
                    MOVE VC-CODE-UTIL-TYPE       TO OA-CODE-UTIL-TYPE   
                    MOVE VC-CODE-USAGE-TYPE      TO OA-CODE-USAGE-TYPE  
                    MOVE VC-CODE-TIME-PERIOD     TO OA-CODE-TIME-PERIOD 
                    MOVE VC-REG-ID-NO            TO OA-REG-ID-NO        
                    PERFORM 7520-GET-MTR-RD-FMT          THRU 7520-EXIT 
                    MOVE OA-READ-SEQUENCE-NO     TO S-READ-SEQUENCE-NO-4
                    MOVE OA-INDEX-VALUE-CD       TO S-INDEX-VALUE-CD-4  
                    MOVE OA-NO-READ-DIGITS       TO S-NO-READ-DIGITS-4  
                    MOVE OA-NO-READ-DECIMALS     TO S-NO-READ-DECIMALS-4
                    INITIALIZE DCLCSS-CODE-VALUE                        
                    MOVE VO-COMPANY-NO         TO UV-COMPANY-NO         
                    MOVE +17                   TO UV-TABLE-NA-LEN       
                    MOVE 'CSS_MTR_RD_FMT'      TO UV-TABLE-NA-TEXT      
                    MOVE +14                   TO UV-COLUMN-NA-LEN      
                    MOVE 'MTR_RD_DISP_CD'      TO UV-COLUMN-NA-TEXT     
                    MOVE +3                    TO UV-CODE-VALUE-LEN     
                    MOVE OA-MTR-RD-DISP-CD     TO UV-CODE-VALUE-TEXT    
                    PERFORM 7470-GET-LONG-DESC      THRU 7470-EXIT      
                    MOVE UV-CODE-LONG-DESC-TEXT  TO S-MTR-RD-DISP-CD-4  
                                                                        
                    INITIALIZE DCLCSS-CODE-VALUE                        
                    MOVE VO-COMPANY-NO           TO UV-COMPANY-NO       
                    MOVE +17                     TO UV-TABLE-NA-LEN     
                    MOVE 'CSS_MTR_RD_FMT'        TO UV-TABLE-NA-TEXT    
                    MOVE +14                     TO UV-COLUMN-NA-LEN    
                    MOVE 'INDEX_VALUE_CD'        TO UV-COLUMN-NA-TEXT   
                    MOVE +1                      TO UV-CODE-VALUE-LEN   
                    MOVE OA-INDEX-VALUE-CD       TO UV-CODE-VALUE-TEXT  
                    PERFORM 7470-GET-LONG-DESC   THRU 7470-EXIT         
                    MOVE UV-CODE-LONG-DESC-TEXT  TO S-INDEX-VALUE-CD-4  
                    PERFORM 8400-SEND-RESULT-4           THRU 8400-EXIT 
                END-IF                                                  
                PERFORM 7401-FETCH-METER-CURSOR          THRU 7401-EXIT 
           END-PERFORM.                                                 
           PERFORM 7402-CLOSE-METER-CURSOR               THRU 7402-EXIT.
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2410-GET-DESCRIPTIONS                                       *        
      *        GETS THE DESCRIPTIONS FOR ALL CODE VALUES               *        
      ******************************************************************        
       2410-GET-DESCRIPTIONS.                                           
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                           TO SW-COMPANY-NO.        
           MOVE 'CSS_SO_DATA'                  TO SW-TABLE-NA.          
           MOVE 'MTR_ACCESSIBLE'               TO SW-COLUMN-NA.         
           MOVE WS-MTR-ACCESSIBLE-CD           TO SW-CODE-VALUE.        
           PERFORM 7015-GET-SHORT-DESC         THRU 7015-EXIT.          
           MOVE SW-CODE-SHORT-DESC             TO S-MTR-ACCESSIBLE-CD.  
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                           TO SW-COMPANY-NO.        
           MOVE 'CSS_SO_DATA'                  TO SW-TABLE-NA.          
           MOVE 'MTR_ACCESSIBLE_RSN'           TO SW-COLUMN-NA.         
           MOVE WS-MTR-ACCESSIBLE-RSN          TO SW-CODE-VALUE.        
           PERFORM 7015-GET-SHORT-DESC         THRU 7015-EXIT.          
           MOVE SW-CODE-SHORT-DESC             TO S-MTR-ACCESSIBLE-RSN. 
                                                                        
           IF MN-CODE-UTIL-TYPE = WS-GAS                                
              INITIALIZE DCLCSS-SO-CODE-DESC                            
              MOVE WS-COMPANY                  TO SW-COMPANY-NO         
              MOVE 'CSS_MTRD_ENVRNMT'          TO SW-TABLE-NA           
              MOVE 'METER_PRESSURE'            TO SW-COLUMN-NA          
              MOVE MN-METER-PRESSURE           TO WS-MTR-PRESSURE       
              MOVE WS-METER-PRESSURE           TO SW-CODE-VALUE         
              PERFORM 7015-GET-SHORT-DESC      THRU 7015-EXIT           
              MOVE SW-CODE-SHORT-DESC          TO S-CASE-PRESSURE       
           END-IF.                                                      
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE VO-COMPANY-NO                  TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +16                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_TIME_PERIOD'             TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           IF C2-ORDER-GROUP-CD = 'A'                                   
              MOVE MN-CODE-TIME-PERIOD         TO S-CODE-TIME-PERIOD-4  
           ELSE                                                         
              MOVE VC-CODE-TIME-PERIOD         TO S-CODE-TIME-PERIOD-4  
           END-IF.                                                      
P00718*    PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.                  
P00718*    MOVE UV-CODE-LONG-DESC-TEXT         TO S-CODE-TIME-PERIOD-4.         
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +15                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_REG_STATUS'              TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           IF C2-ORDER-GROUP-CD = 'A'                                   
              MOVE MN-CODE-METER-STATUS        TO UV-CODE-VALUE-TEXT    
           ELSE                                                         
              MOVE VC-CODE-MTR-STATUS-WS       TO UV-CODE-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT         TO S-CODE-MTR-STATUS-WS. 
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +16                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_STATUS_REAS'             TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           IF C2-ORDER-GROUP-CD = 'A'                                   
              MOVE MN-CODE-STATUS-REAS         TO UV-CODE-VALUE-TEXT    
           ELSE                                                         
              MOVE VC-CODE-STATUS-REA-WS       TO UV-CODE-VALUE-TEXT    
           END-IF.                                                      
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT        TO S-CODE-STATUS-REASON-4.
P01176     IF WS-SAMPLE-TEST = 'Y'                                      
P01176        MOVE 'SAMPLE TEST'              TO S-CODE-STATUS-REASON-4 
P01176     END-IF.                                                      
                                                                        
           PERFORM 7415-GET-REMOTE-IND         THRU 7415-EXIT.          
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500-GET-REGISTER-DTLS                                      *        
      *        GETS ALL REGISTER DETAILS                               *        
      ******************************************************************        
       2500-GET-REGISTER-DTLS.                                          
                                                                        
           PERFORM 7500-OPEN-REGISTERS-CURSOR          THRU 7500-EXIT.  
           PERFORM 7501-FETCH-REGISTERS-CURSOR         THRU 7501-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT05-DECLARED = 'N'                              
                   PERFORM 0105-DECLARE-GTT05          THRU 0105-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                   TO S-RETURN-CODE-5          
                   MOVE VK-CODE-UTIL-TYPE   TO S-CODE-UTIL-TYPE-5       
                                               VC-CODE-UTIL-TYPE        
                                               OA-CODE-UTIL-TYPE        
                   MOVE VK-METER-NO         TO S-METER-NO-5             
                   MOVE VK-IC-NO            TO S-IC-NO-5                
                                               VC-IC-NO                 
                   MOVE VK-MTR-REF-NO       TO S-MTR-REF-NO-5           
                   MOVE VK-REG-ID-NO        TO S-REG-ID-NO-5            
                   MOVE VK-CODE-TIME-PERIOD TO S-CODE-TIME-PERIOD-5     
A05020             MOVE VK-LAST-REG-READ-DT TO S-LAST-REG-READ-DT       
                   PERFORM 7420-RATES-INFO             THRU 7420-EXIT   
                   IF (VI-WORK-TYPE-CD = 'UDP' OR                       
                       VI-WORK-TYPE-CD = 'UNB' OR                       
                       VI-WORK-TYPE-CD = 'MCU' OR                       
                       VI-WORK-TYPE-CD = 'REC')                         
                       MOVE 999             TO S-USAGE-HIGH-PCT-5       
                       MOVE 999             TO S-USAGE-LOW-PCT-5        
                   ELSE                                                 
                     IF VK-CODE-USAGE-TYPE = 'J' OR                     
                        VK-CODE-USAGE-TYPE = 'E'                        
A05020                  MOVE O9-DEMAND-HIGH-PCT TO S-USAGE-HIGH-PCT-5   
A05020                  MOVE O9-DEMAND-LOW-PCT  TO S-USAGE-LOW-PCT-5    
                     ELSE                                               
A05020                  MOVE O9-USAGE-HIGH-PCT  TO S-USAGE-HIGH-PCT-5   
A05020                  MOVE O9-USAGE-LOW-PCT   TO S-USAGE-LOW-PCT-5    
                     END-IF                                             
                   END-IF                                               
                   MOVE VK-CODE-UTIL-TYPE   TO MN-CODE-UTIL-TYPE        
                   MOVE VK-IC-NO            TO MN-IC-NO                 
                   MOVE VK-MTR-REF-NO       TO MN-MTR-REF-NO            
                   PERFORM 7510-GET-MTR-INFO           THRU 7510-EXIT   
                   MOVE VK-CODE-USAGE-TYPE  TO OA-CODE-USAGE-TYPE       
                   MOVE VK-CODE-TIME-PERIOD TO OA-CODE-TIME-PERIOD      
                   MOVE VK-REG-ID-NO        TO OA-REG-ID-NO             
                   PERFORM 7520-GET-MTR-RD-FMT         THRU 7520-EXIT   
                   MOVE OA-INDEX-VALUE-CD   TO S-INDEX-VALUE-CD         
                   MOVE OA-READ-SEQUENCE-NO TO S-READ-SEQUENCE-NO       
                   MOVE OA-NO-READ-DIGITS   TO S-NO-READ-DIGITS         
                   MOVE OA-NO-READ-DECIMALS TO S-NO-READ-DECIMALS       
                   PERFORM 2510-GET-DESCRIPTIONS       THRU 2510-EXIT   
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES           TO S-CODE-STATUS-REASON-5   
                      MOVE SPACES           TO S-CODE-REG-STATUS-WS     
                   END-IF                                               
                   PERFORM 8500-SEND-RESULT-5          THRU 8500-EXIT   
                END-IF                                                  
                PERFORM 7501-FETCH-REGISTERS-CURSOR    THRU 7501-EXIT   
           END-PERFORM.                                                 
           PERFORM 7502-CLOSE-REGISTERS-CURSOR         THRU 7502-EXIT.  
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500C-GET-SOREGISTER.                                       *        
      *        GETS ALL REGISTER DETAILS                               *        
      ******************************************************************        
       2500C-GET-SOREGISTER.                                            
                                                                        
           PERFORM 7500C-OPEN-SOREGISTERS-CURSOR       THRU 7500C-EXIT. 
           PERFORM 7501C-FETCH-SOREGISTERS-CURSOR      THRU 7501C-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT05-DECLARED = 'N'                              
                   PERFORM 0105-DECLARE-GTT05          THRU 0105-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                   TO S-RETURN-CODE-5          
                   MOVE WK-CODE-UTIL-TYPE   TO S-CODE-UTIL-TYPE-5       
                                               VC-CODE-UTIL-TYPE        
                                               OA-CODE-UTIL-TYPE        
                   MOVE WK-METER-NO         TO S-METER-NO-5             
                   MOVE WK-IC-NO            TO S-IC-NO-5                
                                               VC-IC-NO                 
                   MOVE WK-MTR-REF-NO       TO S-MTR-REF-NO-5           
                   MOVE WK-REG-ID-NO        TO S-REG-ID-NO-5            
                   MOVE WK-CODE-TIME-PERIOD TO S-CODE-TIME-PERIOD-5     
                   PERFORM 7495-GET-UTILITY            THRU 7495-EXIT   
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                      PERFORM 7425-RATES-INFO          THRU 7425-EXIT   
                   ELSE                                                 
                      PERFORM 7420-RATES-INFO          THRU 7420-EXIT   
                   END-IF                                               
                   IF (VI-WORK-TYPE-CD = 'UDP' OR                       
                       VI-WORK-TYPE-CD = 'UNB' OR                       
                       VI-WORK-TYPE-CD = 'MCU' OR                       
                       VI-WORK-TYPE-CD = 'REC')                         
                       MOVE 999             TO S-USAGE-HIGH-PCT-5       
                       MOVE 999             TO S-USAGE-LOW-PCT-5        
                   ELSE                                                 
                     IF WK-CODE-USAGE-TYPE = 'J' OR                     
                        WK-CODE-USAGE-TYPE = 'E'                        
                        MOVE O9-DEMAND-HIGH-PCT TO S-USAGE-HIGH-PCT-5   
                        MOVE O9-DEMAND-LOW-PCT  TO S-USAGE-LOW-PCT-5    
                     ELSE                                               
                        MOVE O9-USAGE-HIGH-PCT  TO S-USAGE-HIGH-PCT-5   
                        MOVE O9-USAGE-LOW-PCT   TO S-USAGE-LOW-PCT-5    
                     END-IF                                             
                   END-IF                                               
                   MOVE WK-CODE-UTIL-TYPE   TO MN-CODE-UTIL-TYPE        
                   MOVE WK-IC-NO            TO MN-IC-NO                 
                   MOVE WK-MTR-REF-NO       TO MN-MTR-REF-NO            
                   PERFORM 7510-GET-MTR-INFO           THRU 7510-EXIT   
                   MOVE WK-CODE-TIME-PERIOD TO OA-CODE-TIME-PERIOD      
                   MOVE WK-CODE-USAGE-TYPE  TO OA-CODE-USAGE-TYPE       
                   MOVE WK-REG-ID-NO        TO OA-REG-ID-NO             
                   PERFORM 7520-GET-MTR-RD-FMT         THRU 7520-EXIT   
                   MOVE OA-INDEX-VALUE-CD   TO S-INDEX-VALUE-CD         
                   MOVE OA-READ-SEQUENCE-NO TO S-READ-SEQUENCE-NO       
                   MOVE OA-NO-READ-DIGITS   TO S-NO-READ-DIGITS         
                   MOVE OA-NO-READ-DECIMALS TO S-NO-READ-DECIMALS       
                   MOVE WK-CODE-STATUS-REAS TO VK-CODE-STATUS-REA-WS    
                   MOVE WK-CODE-REG-STATUS  TO VK-CODE-REG-STATUS-WS    
                   PERFORM 2510-GET-DESCRIPTIONS       THRU 2510-EXIT   
                   MOVE '1900-01-01-00.00.00.000000' TO                 
                   S-LAST-REG-READ-DT                                   
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES           TO S-CODE-STATUS-REASON-5   
                      MOVE SPACES           TO S-CODE-REG-STATUS-WS     
                   END-IF                                               
                   PERFORM 8500-SEND-RESULT-5          THRU 8500-EXIT   
                END-IF                                                  
                PERFORM 7501C-FETCH-SOREGISTERS-CURSOR THRU 7501C-EXIT  
           END-PERFORM.                                                 
           PERFORM 7502C-CLOSE-SOREGISTERS-CURSOR      THRU 7502C-EXIT. 
                                                                        
       2500C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500A-GET-REGISTER-READ                                     *        
      *        GETS ALL REGISTER DETAILS                               *        
      ******************************************************************        
       2500A-GET-REGISTER-READ.                                         
                                                                        
           PERFORM 7500A-OPEN-REGISTERS-CURSOR         THRU 7500A-EXIT. 
           PERFORM 7501A-FETCH-REGISTERS-CURSOR        THRU 7501A-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT05-DECLARED = 'N'                              
                   PERFORM 0105-DECLARE-GTT05          THRU 0105-EXIT   
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                       TO S-RETURN-CODE-5      
A05020             MOVE RG-CODE-UTIL-TYPE       TO S-CODE-UTIL-TYPE-5   
A05020                                             VC-CODE-UTIL-TYPE    
A05020             MOVE RG-IC-NO                TO S-IC-NO-5            
A05020                                             VC-IC-NO             
A05020             MOVE RG-MTR-REF-NO           TO S-MTR-REF-NO-5       
A05020             MOVE RG-REG-ID-NO            TO S-REG-ID-NO-5        
A05020                                             OA-REG-ID-NO         
A05020             MOVE RG-CODE-TIME-PERIOD     TO S-CODE-TIME-PERIOD-5 
A05020                                             OA-CODE-TIME-PERIOD  
A05020             PERFORM 7420-RATES-INFO             THRU 7420-EXIT   
                   IF (VI-WORK-TYPE-CD = 'UDP' OR                       
                       VI-WORK-TYPE-CD = 'UNB' OR                       
                       VI-WORK-TYPE-CD = 'MCU' OR                       
                       VI-WORK-TYPE-CD = 'REC')                         
                       MOVE 999                 TO S-USAGE-HIGH-PCT-5   
                       MOVE 999                 TO S-USAGE-LOW-PCT-5    
                   ELSE                                                 
                     IF RG-CODE-USAGE-TYPE = 'J' OR                     
                        RG-CODE-USAGE-TYPE = 'E'                        
                        MOVE O9-DEMAND-HIGH-PCT TO S-USAGE-HIGH-PCT-5   
                        MOVE O9-DEMAND-LOW-PCT  TO S-USAGE-LOW-PCT-5    
                     ELSE                                               
                        MOVE O9-USAGE-HIGH-PCT  TO S-USAGE-HIGH-PCT-5   
                        MOVE O9-USAGE-LOW-PCT   TO S-USAGE-LOW-PCT-5    
                     END-IF                                             
                   END-IF                                               
                   MOVE RG-CODE-UTIL-TYPE       TO MN-CODE-UTIL-TYPE    
                   MOVE RG-IC-NO                TO MN-IC-NO             
                   MOVE RG-MTR-REF-NO           TO MN-MTR-REF-NO        
                   PERFORM 7510-GET-MTR-INFO           THRU 7510-EXIT   
                   MOVE RG-CODE-USAGE-TYPE      TO OA-CODE-USAGE-TYPE   
                   PERFORM 7520-GET-MTR-RD-FMT         THRU 7520-EXIT   
                   MOVE OA-INDEX-VALUE-CD       TO S-INDEX-VALUE-CD     
                   MOVE OA-READ-SEQUENCE-NO     TO S-READ-SEQUENCE-NO   
                   MOVE OA-NO-READ-DIGITS       TO S-NO-READ-DIGITS     
                   MOVE OA-NO-READ-DECIMALS     TO S-NO-READ-DECIMALS   
                   MOVE RG-CODE-STATUS-REAS     TO VK-CODE-STATUS-REA-WS
                   MOVE RG-CODE-REG-STATUS      TO VK-CODE-REG-STATUS-WS
                   PERFORM 2510-GET-DESCRIPTIONS       THRU 2510-EXIT   
A05020             MOVE RG-LAST-REG-READ-TM     TO WS-LAST-REG-READ-TM  
A05020             MOVE RG-LAST-REG-READ-DT     TO WS-LAST-REG-READ-DATE
A05020             MOVE WS-LAST-REG-READ-DT     TO S-LAST-REG-READ-DT   
                   PERFORM 2520-GET-DESCRIPTIONS       THRU 2520-EXIT   
                   IF VO-ORDER-TYPE-CD = 'FW019' OR                     
                      VO-ORDER-TYPE-CD = 'FW016'                        
                      MOVE SPACES TO S-CODE-STATUS-REASON-5             
                      MOVE SPACES TO S-CODE-REG-STATUS-WS               
                   END-IF                                               
                   PERFORM 8500-SEND-RESULT-5          THRU 8500-EXIT   
                END-IF                                                  
                PERFORM 7501A-FETCH-REGISTERS-CURSOR   THRU 7501A-EXIT  
           END-PERFORM.                                                 
           PERFORM 7502A-CLOSE-REGISTERS-CURSOR        THRU 7502A-EXIT. 
                                                                        
       2500A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2510-GET-DESCRIPTIONS                                       *        
      *        GETS THE DESCRIPTIONS FOR ALL CODE VALUES               *        
      ******************************************************************        
       2510-GET-DESCRIPTIONS.                                           
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE VO-COMPANY-NO              TO UV-COMPANY-NO.            
           MOVE +17                        TO UV-TABLE-NA-LEN.          
           MOVE 'CSS_REGISTER_READ'        TO UV-TABLE-NA-TEXT.         
           MOVE +16                        TO UV-COLUMN-NA-LEN.         
           MOVE 'CODE_TIME_PERIOD'         TO UV-COLUMN-NA-TEXT.        
           MOVE +2                         TO UV-CODE-VALUE-LEN.        
P00718     MOVE OA-CODE-TIME-PERIOD        TO S-CODE-TIME-PERIOD-5.     
P00718*    MOVE VK-CODE-TIME-PERIOD        TO UV-CODE-VALUE-TEXT.               
P00718*    PERFORM 7470-GET-LONG-DESC      THRU 7470-EXIT.                      
P00718*    MOVE UV-CODE-LONG-DESC-TEXT     TO S-CODE-TIME-PERIOD-5.             
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE VO-COMPANY-NO              TO UV-COMPANY-NO.            
           MOVE +17                        TO UV-TABLE-NA-LEN.          
           MOVE 'CSS_MTR_RD_FMT'           TO UV-TABLE-NA-TEXT.         
           MOVE +14                        TO UV-COLUMN-NA-LEN.         
           MOVE 'MTR_RD_DISP_CD'           TO UV-COLUMN-NA-TEXT.        
           MOVE +3                         TO UV-CODE-VALUE-LEN.        
           MOVE OA-MTR-RD-DISP-CD          TO UV-CODE-VALUE-TEXT.       
           PERFORM 7470-GET-LONG-DESC      THRU 7470-EXIT.              
           MOVE UV-CODE-LONG-DESC-TEXT     TO S-MTR-RD-DISP-CD.         
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE VO-COMPANY-NO           TO UV-COMPANY-NO.               
           MOVE +17                     TO UV-TABLE-NA-LEN.             
           MOVE 'CSS_MTR_RD_FMT'        TO UV-TABLE-NA-TEXT.            
           MOVE +14                     TO UV-COLUMN-NA-LEN.            
           MOVE 'INDEX_VALUE_CD'        TO UV-COLUMN-NA-TEXT.           
           MOVE +1                      TO UV-CODE-VALUE-LEN.           
           MOVE OA-INDEX-VALUE-CD       TO UV-CODE-VALUE-TEXT.          
           PERFORM 7470-GET-LONG-DESC   THRU 7470-EXIT.                 
           MOVE UV-CODE-LONG-DESC-TEXT  TO S-INDEX-VALUE-CD.            
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +16                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_STATUS_REAS'             TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           MOVE VK-CODE-STATUS-REA-WS          TO UV-CODE-VALUE-TEXT    
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT        TO S-CODE-STATUS-REASON-5.
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +15                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_REG_STATUS'              TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           MOVE VK-CODE-REG-STATUS-WS          TO UV-CODE-VALUE-TEXT.   
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT         TO S-CODE-REG-STATUS-WS. 
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2520-GET-DESCRIPTIONS                                       *        
      *        GETS THE DESCRIPTIONS FOR ALL CODE VALUES               *        
      ******************************************************************        
       2520-GET-DESCRIPTIONS.                                           
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +16                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_STATUS_REAS'             TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           MOVE RG-CODE-STATUS-REAS            TO UV-CODE-VALUE-TEXT    
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT        TO S-CODE-STATUS-REASON-5.
                                                                        
           INITIALIZE DCLCSS-CODE-VALUE.                                
           MOVE '01'                           TO UV-COMPANY-NO.        
           MOVE +17                            TO UV-TABLE-NA-LEN.      
           MOVE 'CSS_REGISTER_READ'            TO UV-TABLE-NA-TEXT.     
           MOVE +15                            TO UV-COLUMN-NA-LEN.     
           MOVE 'CODE_REG_STATUS'              TO UV-COLUMN-NA-TEXT.    
           MOVE +2                             TO UV-CODE-VALUE-LEN.    
           MOVE RG-CODE-REG-STATUS             TO UV-CODE-VALUE-TEXT.   
           PERFORM 7470-GET-LONG-DESC          THRU 7470-EXIT.          
           MOVE UV-CODE-LONG-DESC-TEXT         TO S-CODE-REG-STATUS-WS. 
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2600-GET-ATTACHMENT-DTLS                                    *        
      *        GETS ALL ATTACHMENT DETAILS                             *        
      ******************************************************************        
       2600-GET-ATTACHMENT-DTLS.                                        
                                                                        
           PERFORM 7600-OPEN-ATTACHMENTS-CURSOR        THRU 7600-EXIT.  
           PERFORM 7601-FETCH-ATTACHMENTS-CURSOR       THRU 7601-EXIT.  
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF WS-GTT06-DECLARED = 'N'                              
                   PERFORM 0106-DECLARE-GTT06         THRU 0106-EXIT    
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 0                     TO S-RETURN-CODE-6        
                   MOVE ON-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE-6     
                   INITIALIZE DCLCSS-SO-CODE-DESC                       
                   MOVE '01'                  TO SW-COMPANY-NO          
                   MOVE 'CSS_SO_MTR_ATT_CHG'  TO SW-TABLE-NA            
                   MOVE 'CODE_STATUS_REASON'  TO SW-COLUMN-NA           
                   MOVE ON-CODE-STATUS-REASON TO SW-CODE-VALUE          
                   PERFORM 7050-GET-LONG-DESC       THRU 7050-EXIT      
                   MOVE SW-CODE-LONG-DESC   TO S-CODE-STATUS-REASON-6   
                   PERFORM 8600-SEND-RESULT-6          THRU 8600-EXIT   
                END-IF                                                  
P00718          PERFORM 7601-FETCH-ATTACHMENTS-CURSOR  THRU 7601-EXIT   
P00718     END-PERFORM.                                                 
P00718     PERFORM 7602-CLOSE-ATTACHMENTS-CURSOR       THRU 7602-EXIT.  
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2700-GET-DNP-DTLS                                           *        
      *        GETS THE DNP DETAILS                                    *        
      ******************************************************************        
       2700-GET-DNP-DTLS.                                               
                                                                        
           IF WS-GTT07-DECLARED = 'N'                                   
              PERFORM 0107-DECLARE-GTT07               THRU 0107-EXIT   
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0 TO S-RETURN-CODE-7                                 
              PERFORM 7710-GET-CREDIT-PROFILE          THRU 7710-EXIT   
              PERFORM 2710-CALC-NO-OF-DNPS             THRU 2710-EXIT   
              PERFORM 7720-GET-CRED-COLL               THRU 7720-EXIT   
              PERFORM 7700-OPEN-DNP-CURSOR             THRU 7700-EXIT   
              PERFORM 7701-FETCH-DNP-CURSOR            THRU 7701-EXIT   
              PERFORM 7702-CLOSE-DNP-CURSOR            THRU 7702-EXIT   
              PERFORM 7730-GET-DEP-ON-HAND             THRU 7730-EXIT   
              PERFORM 7740-GET-GUARANTOR               THRU 7740-EXIT   
              PERFORM 7750-GET-SURETY-BONDS            THRU 7750-EXIT   
              ADD DO-AMT-DEPOSIT GU-AMOUNT-GUARANTEED SB-AMT-BOND       
                             TO S-DNP-DEPOSIT-AMNT                      
              PERFORM 7760-GET-CRIT-CUSTOMER           THRU 7760-EXIT   
              PERFORM 7770-GET-ACCOUNT-TABLE           THRU 7770-EXIT   
              PERFORM 7775-GET-ACCT-TYPE               THRU 7775-EXIT   
              MOVE AT-COMPANY-NO                       TO WS-COMPANY-NO 
              IF WS-COMPANY-NO = WS-PSNC                                
                 MOVE WS-YES TO WS-LOAD-GUARANTOR-XFER-AMT-SW           
              END-IF                                                    
              MOVE WS-YES    TO CALC-ARREARS-SW                         
                                CALC-BALANCE-SW                         
                                CALC-PAST-DUE-SW                        
                                CALC-DNP-BAL-SW                         
                                                                        
              MOVE PROGRAM-NAME TO WS-CPD00068-CALLING-PGM              
              PERFORM 9500-CALL-CPD00068               THRU 9500-EXIT   
              IF ABEND-FUNCTION  > SPACES                               
                 PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT   
              END-IF                                                    
              MOVE WS-AMT-DNP-BAL              TO S-DNP-AMNT            
              MOVE WS-AMT-ARREARS              TO S-DNP-ARREARS-AMNT    
              MOVE WS-TOTAL-BALANCE            TO S-DNP-TOTAL-AMNT      
              MOVE WS-AMT-PAST-DUE             TO S-DNP-PAST-DUE-AMNT   
              MOVE WS-AMT-30-DAY               TO S-DNP-30-ARREARS      
              MOVE WS-AMT-60-DAY               TO S-DNP-60-ARREARS      
              MOVE WS-AMT-90-DAY               TO S-DNP-90-ARREARS      
              MOVE WS-CURR-CHARGES-UTL         TO S-DNP-UTILITY-AMNT    
              MOVE WS-CURR-CHARGES-NONUTL      TO S-DNP-NON-UTILITY-AMNT
              PERFORM 2720-CALC-NO-OF-RET-CHKS         THRU 2720-EXIT   
              PERFORM 7780-GET-CUST-MISC               THRU 7780-EXIT   
              PERFORM 2730-GET-DESCRIPTIONS            THRU 2730-EXIT   
              INSPECT S-DNP-LAST-PAY-DATE                               
                  REPLACING ALL LOW-VALUES BY SPACES                    
              INSPECT S-DNP-2ND-NOTICE-DATE                             
                  REPLACING ALL LOW-VALUES BY SPACES                    
              INSPECT S-DNP-EXCEPT-HISTORY                              
                  REPLACING ALL LOW-VALUES BY SPACES                    
              PERFORM 8700-SEND-RESULT-7               THRU 8700-EXIT   
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2710-CALC-NO-OF-DNPS                                           *        
      *   BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT          *        
      *   EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES            *        
      *   REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A DNP.        *        
      *   WE ARE ONLY CHECKING THE PREVIOUS YEAR.                      *        
      ******************************************************************        
       2710-CALC-NO-OF-DNPS.                                            
                                                                        
           MOVE CZ-DISCONNECT-HIST   TO WS-DISC-HIST.                   
           MOVE CZ-DISC-EXCEPTN-HIST TO WS-EXCEPTIONAL-HIST.            
           MOVE 0                    TO S-DNP-COUNTER.                  
           MOVE 1                    TO WS-PREV-MNTH.                   
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
              IF WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR            
                 ADD 1 TO S-DNP-COUNTER                                 
              END-IF                                                    
              IF WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR     
                 ADD 1 TO S-DNP-COUNTER                                 
              END-IF                                                    
              ADD 1 TO WS-PREV-MNTH                                     
           END-PERFORM.                                                 
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2720-CALC-NO-OF-RET-CHKS                                       *        
      *   COUNTS THE NUMBER OF RETURNED CHECKS/DRAFTS IN THE LAST      *        
      *   YEAR.                                                        *        
      ******************************************************************        
       2720-CALC-NO-OF-RET-CHKS.                                        
                                                                        
           PERFORM 7790-CALCULATE-ONE-YEAR-AGO    THRU 7790-EXIT.       
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :S-DNP-RETURN-CKS                                  
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                     
                 AND NSF_STATUS_CD = 'C'                                
                 AND DATE_TRAN     > IIF(TRY_CONVERT(DATE, 
                                                       :WS-ONE-YEAR-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-ONE-YEAR-AGO
              ) <> 0) OR (LEN(:WS-ONE-YEAR-AGO) <> 10), CIS.CHAR2DATE(
                                                       :WS-ONE-YEAR-AGO
              ), CONVERT(DATE, :WS-ONE-YEAR-AGO) )                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :S-DNP-RETURN-CKS                                          
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD = 'C'                                        
MFA-TR*          AND DATE_TRAN     > :WS-ONE-YEAR-AGO                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '2720'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_TRAN'                TO TABLE-ELEMENT-2        
              MOVE VO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ONE-YEAR-AGO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2730-GET-DESCRIPTIONS                                       *        
      *        GETS THE DESCRIPTIONS FOR ALL CODE VALUES               *        
      ******************************************************************        
       2730-GET-DESCRIPTIONS.                                           
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC.                              
           MOVE '01'                                TO SW-COMPANY-NO.   
           MOVE 'CSS_ACCOUNT'                       TO SW-TABLE-NA.     
           MOVE 'CODE_STATUS_REASON'                TO SW-COLUMN-NA.    
           MOVE AT-CODE-STATUS-REASON               TO SW-CODE-VALUE.   
           PERFORM 7050-GET-LONG-DESC               THRU 7050-EXIT.     
           MOVE SW-CODE-LONG-DESC                   TO S-REASON-CD.     
                                                                        
           INITIALIZE DCLCSS-SO-CODE-DESC                               
           MOVE '01'                                TO SW-COMPANY-NO.   
           MOVE 'CSS_ACCOUNT'                       TO SW-TABLE-NA.     
           MOVE 'CREDIT_GROUP'                      TO SW-COLUMN-NA.    
           MOVE AT-CODE-STATUS-REASON               TO SW-CODE-VALUE.   
           PERFORM 7050-GET-LONG-DESC               THRU 7050-EXIT.     
           MOVE SW-CODE-LONG-DESC                 TO S-DNP-CREDIT-GROUP.
                                                                        
       2730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7000-ORDER-INFO.                                            *        
      *        GETS ORDER INFORMATION                                  *        
      ******************************************************************        
       7000-ORDER-INFO.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TASK_DUE_DAYS_NO,                                  
                     COMPLIANCE_DAYS_NO,                                
                     TASK_PRIORITY_CD,                                  
                     COMPLY_DT_CALC_CD,                                 
                     TASK_TYPE_CALC_FL                                  
                INTO :S-DUE-DAYS,                                       
                     :S-COMPLIANCE-DAYS,                                
                     :S-ORDER-PRIORITY-CD,                              
                     :L3-COMPLY-DT-CALC-CD,                             
                     :L3-TASK-TYPE-CALC-FL                              
                FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO    = :VO-COMPANY-NO                     
                 AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                  
                 AND WORK_TYPE_CD  = :VI-WORK-TYPE-CD                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TASK_DUE_DAYS_NO,                                          
MFA-TR*              COMPLIANCE_DAYS_NO,                                        
MFA-TR*              TASK_PRIORITY_CD,                                          
MFA-TR*              COMPLY_DT_CALC_CD,                                         
MFA-TR*              TASK_TYPE_CALC_FL                                          
MFA-TR*         INTO :S-DUE-DAYS,                                               
MFA-TR*              :S-COMPLIANCE-DAYS,                                        
MFA-TR*              :S-ORDER-PRIORITY-CD,                                      
MFA-TR*              :L3-COMPLY-DT-CALC-CD,                                     
MFA-TR*              :L3-TASK-TYPE-CALC-FL                                      
MFA-TR*         FROM CSS_ORDER_WK_TYPE                                          
MFA-TR*        WHERE COMPANY_NO    = :VO-COMPANY-NO                             
MFA-TR*          AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                          
MFA-TR*          AND WORK_TYPE_CD  = :VI-WORK-TYPE-CD                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ORDER_WK_TYPE' TO TABLE-1                  
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE VO-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   MOVE 'WORK_TYPE_CD'      TO TABLE-ELEMENT-3          
                   MOVE VI-WORK-TYPE-CD     TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7001-GET-WT-APPL                                            *        
A05020*        CHECKS FOR TANKLESS WATER HEATER                        *        
A05020******************************************************************        
A05020 7001-GET-WT-APPL.                                                
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT TOP(1) 'Y'                                                
A05020          INTO :WS-WT-APPL                                        
A05020          FROM CSS_SO_APPLIANCE WITH(READUNCOMMITTED)                     
A05020         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                  
A05020           AND APPLIANCE_CD  = 'WT'                               
A05020                                            
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-WT-APPL                                                
MFA-TR*         FROM CSS_SO_APPLIANCE                                           
MFA-TR*        WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                          
MFA-TR*          AND APPLIANCE_CD  = 'WT'                                       
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020         WHEN NOT-FOUND                                           
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7001'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_APPLIANCE'  TO TABLE-1                  
A05020             MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
A05020             MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7001-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7002-GET-ACCT-DTLS                                          *        
A05020*        GETS THE ACCOUNT DETAILS FOR DETERMINING THE NEXT BILL DT        
A05020******************************************************************        
A05020 7002-GET-ACCT-DTLS.                                              
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT CODE_BILL_FREQ,                                    
A05020               REV_MTH_LST_NRML,                                  
A05020               CODE_ACCT_STAT,                                    
A05020               BILL_CYCLE                                         
A05020          INTO :AT-CODE-BILL-FREQ,                                
A05020               :AT-REV-MTH-LST-NRML,                              
A05020               :AT-CODE-ACCT-STAT,                                
A05020               :AT-BILL-CYCLE                                     
A05020          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
A05020         WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                     
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_BILL_FREQ,                                            
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              BILL_CYCLE                                                 
MFA-TR*         INTO :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020         WHEN NOT-FOUND                                           
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7002'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
A05020             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
A05020             MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7002-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7003-GET-POINT-ID                                           *        
A05020*        GETS THE POINT ID INFO                                  *        
A05020******************************************************************        
A05020 7003-GET-POINT-ID.                                               
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT POINT_ID                                           
A05020          INTO :MN-POINT-ID                                       
A05020          FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
A05020         WHERE METER_NO        = :VI-METER-NO                     
A05020           AND ACCOUNT_NO      = :VO-ACCOUNT-NO-PRIOR             
A05020           AND CODE_UTIL_TYPE  = :VI-CODE-UTIL-TYPE               
A05020           AND IC_NO           = :VI-IC-NO                        
A05020           AND MTR_REF_NO      = :VI-MTR-REF-NO                   
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT POINT_ID                                                   
MFA-TR*         INTO :MN-POINT-ID                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE METER_NO        = :VI-METER-NO                             
MFA-TR*          AND ACCOUNT_NO      = :VO-ACCOUNT-NO-PRIOR                     
MFA-TR*          AND CODE_UTIL_TYPE  = :VI-CODE-UTIL-TYPE                       
MFA-TR*          AND IC_NO           = :VI-IC-NO                                
MFA-TR*          AND MTR_REF_NO      = :VI-MTR-REF-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7003                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE SPACES              TO MN-POINT-ID              
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7003'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
A05020             MOVE 'METER_NO'          TO TABLE-ELEMENT-1          
A05020             MOVE VI-METER-NO         TO HOSTVAR-ELEMENT-1        
A05020             MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
A05020             MOVE VI-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7003-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7004-POINT-CLASS                                            *        
A05020*        GETS THE POINT ID INFO                                  *        
A05020******************************************************************        
A05020 7004-POINT-CLASS.                                                
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT POINT_CLASS_NA                                     
A05020          INTO :PP-POINT-CLASS-NA                                 
A05020          FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                        
A05020         WHERE AREA_ID         = :PP-AREA-ID                      
A05020           AND TAG_NM          = :PP-TAG-NM                       
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT POINT_CLASS_NA                                             
MFA-TR*         INTO :PP-POINT-CLASS-NA                                         
MFA-TR*         FROM CSS_PIM_POINT                                              
MFA-TR*        WHERE AREA_ID         = :PP-AREA-ID                              
MFA-TR*          AND TAG_NM          = :PP-TAG-NM                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7004                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE SPACES              TO PP-POINT-CLASS-NA        
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7004'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_PIM_POINT'     TO TABLE-1                  
A05020             MOVE 'AREA_ID'           TO TABLE-ELEMENT-1          
A05020             MOVE PP-AREA-ID          TO HOSTVAR-ELEMENT-1        
A05020             MOVE 'TAG_NM'            TO TABLE-ELEMENT-2          
A05020             MOVE PP-TAG-NM           TO HOSTVAR-ELEMENT-2        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7004-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    7005-GET-DLINQ-VAL                                          *        
      *        GETS CSR/SEB INFORMATION                                *        
      ******************************************************************        
       7005-GET-DLINQ-VAL.                                              
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7005                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7005'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_DELINQUENCY'   TO TABLE-1                  
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE C8-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7006-GET-ELEC-MTR                                           *        
A05020*        GETS THE ELECTRIC METER                                 *        
A05020******************************************************************        
A05020 7006-GET-ELEC-MTR.                                               
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT NO_PHASES,                                         
A05020               ELEC_MTR_CLASS_CD,                                 
A05020               ELEC_MTR_SPEC_CD,                                  
A05020               MTR_CONNECT_TYP_ID                                 
A05020          INTO :EM-NO-PHASES,                                     
A05020               :EM-ELEC-MTR-CLASS-CD,                             
A05020               :EM-ELEC-MTR-SPEC-CD,                              
A05020               :EM-MTR-CONNECT-TYP-ID                             
A05020          FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
A05020         WHERE CODE_UTIL_TYPE  = :VI-CODE-UTIL-TYPE               
A05020           AND METER_NO        = :VI-METER-NO                     
A05020           AND COMPANY_NO      = :VO-COMPANY-NO                   
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NO_PHASES,                                                 
MFA-TR*              ELEC_MTR_CLASS_CD,                                         
MFA-TR*              ELEC_MTR_SPEC_CD,                                          
MFA-TR*              MTR_CONNECT_TYP_ID                                         
MFA-TR*         INTO :EM-NO-PHASES,                                             
MFA-TR*              :EM-ELEC-MTR-CLASS-CD,                                     
MFA-TR*              :EM-ELEC-MTR-SPEC-CD,                                      
MFA-TR*              :EM-MTR-CONNECT-TYP-ID                                     
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*        WHERE CODE_UTIL_TYPE  = :VI-CODE-UTIL-TYPE                       
MFA-TR*          AND METER_NO        = :VI-METER-NO                             
MFA-TR*          AND COMPANY_NO      = :VO-COMPANY-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7006                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE SPACES              TO EM-NO-PHASES             
A05020             MOVE SPACES              TO EM-ELEC-MTR-CLASS-CD     
A05020             MOVE SPACES              TO EM-ELEC-MTR-SPEC-CD      
A05020             MOVE SPACES              TO EM-MTR-CONNECT-TYP-ID    
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7006'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_ELEC_METER'    TO TABLE-1                  
A05020             MOVE 'METER_NO'          TO TABLE-ELEMENT-1          
A05020             MOVE VI-METER-NO         TO HOSTVAR-ELEMENT-1        
A05020             MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
A05020             MOVE VI-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7006-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7007-GET-FORM-CD                                            *        
A05020*        GETS THE FORM CODE INFO                                 *        
A05020******************************************************************        
A05020 7007-GET-FORM-CD.                                                
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT ELEC_MTR_FORM_CD                                   
A05020          INTO :U0-ELEC-MTR-FORM-CD                               
A05020          FROM CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                     
A05020         WHERE ELEC_MTR_CLASS_CD = :EM-ELEC-MTR-CLASS-CD          
A05020           AND ELEC_MTR_SPEC_CD  = :EM-ELEC-MTR-SPEC-CD           
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ELEC_MTR_FORM_CD                                           
MFA-TR*         INTO :U0-ELEC-MTR-FORM-CD                                       
MFA-TR*         FROM CSS_ELEC_CL_SPEC                                           
MFA-TR*        WHERE ELEC_MTR_CLASS_CD = :EM-ELEC-MTR-CLASS-CD                  
MFA-TR*          AND ELEC_MTR_SPEC_CD  = :EM-ELEC-MTR-SPEC-CD                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7007                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE SPACES              TO U0-ELEC-MTR-FORM-CD      
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7007'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_ELEC_CL_SPEC'  TO TABLE-1                  
A05020             MOVE 'ELEC_MTR_CLASS_CD' TO TABLE-ELEMENT-1          
A05020             MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-1       
A05020             MOVE 'ELEC_MTR_SPEC_CD'  TO TABLE-ELEMENT-2          
A05020             MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7007-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    7010-ACCOUNT-INFO.                                          *        
      *        GETS ACCOUNT INFORMATION                                *        
      ******************************************************************        
       7010-ACCOUNT-INFO.                                               
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE,                                 
                     CODE_ACCT_STAT,                                    
                     CUSTOMER_NO                                        
                INTO :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO    = :VO-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y'                 TO WS-TASK-CANCEL           
                   MOVE SPACES              TO AT-ACCOUNT-TYPE-CODE     
                   MOVE SPACES              TO AT-CODE-ACCT-STAT        
                   MOVE ZERO                TO AT-CUSTOMER-NO           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7011-GET-DBA-INFO.                                          *        
A05020*        GETS ACCOUNT INFORMATION                                *        
A05020******************************************************************        
A05020 7011-GET-DBA-INFO.                                               
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         SELECT TOP(1) FULL_NAME                                         
A05020           INTO :DQ-FULL-NAME                                     
A05020           FROM CSS_ACCT_BILL_NMES AB WITH(READUNCOMMITTED),              
A05020                CSS_NAME DQ WITH(READUNCOMMITTED)                         
A05020          WHERE ACCOUNT_NO   = :VO-ACCOUNT-NO                     
A05020            AND AB.NAME_TYPE = 'DB'                               
A05020            AND AB.NAME_ID   = DQ.NAME_ID                         
A05020                                           
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FULL_NAME                                                 
MFA-TR*          INTO :DQ-FULL-NAME                                             
MFA-TR*          FROM CSS_ACCT_BILL_NMES AB,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO   = :VO-ACCOUNT-NO                             
MFA-TR*           AND AB.NAME_TYPE = 'DB'                                       
MFA-TR*           AND AB.NAME_ID   = DQ.NAME_ID                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7011                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05020             MOVE SPACES TO DQ-FULL-NAME                          
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7011'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_NAME'          TO TABLE-1                  
A05020             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
A05020             MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7011-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7012-GET-CUST-DBA.                                          *        
A05020*        GETS ACCOUNT INFORMATION                                *        
A05020******************************************************************        
A05020 7012-GET-CUST-DBA.                                               
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT TOP(1) DBA_NAME                                           
A05020          INTO :DQ-FULL-NAME                                      
A05020          FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
A05020         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
A05020                                           
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DBA_NAME                                                   
MFA-TR*         INTO :DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7012                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05020             MOVE SPACES TO DQ-FULL-NAME                          
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7012'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
A05020             MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
A05020             MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7012-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    7015-GET-SHORT-DESC                                         *        
      *        GETS DESCRIPTIONS FOR THE DIFFERENT CODE VALUES         *        
      ******************************************************************        
       7015-GET-SHORT-DESC.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
                INTO :SW-CODE-SHORT-DESC                                
                FROM CSS_SO_CODE_DESC WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO    = :SW-COMPANY-NO                     
                 AND TABLE_NA      = :SW-TABLE-NA                       
                 AND COLUMN_NA     = :SW-COLUMN-NA                      
                 AND CODE_VALUE    = :SW-CODE-VALUE                     
                 AND PROGRAM_ID    = 'ALL'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*         INTO :SW-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_SO_CODE_DESC                                           
MFA-TR*        WHERE COMPANY_NO    = :SW-COMPANY-NO                             
MFA-TR*          AND TABLE_NA      = :SW-TABLE-NA                               
MFA-TR*          AND COLUMN_NA     = :SW-COLUMN-NA                              
MFA-TR*          AND CODE_VALUE    = :SW-CODE-VALUE                             
MFA-TR*          AND PROGRAM_ID    = 'ALL'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7015'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_CODE_DESC'  TO TABLE-1                  
                   MOVE 'CODE_VALUE'        TO TABLE-ELEMENT-1          
                   MOVE SW-CODE-VALUE       TO HOSTVAR-ELEMENT-1        
                   MOVE 'COLUMN_NA'         TO TABLE-ELEMENT-2          
                   MOVE SW-COLUMN-NA        TO HOSTVAR-ELEMENT-2        
                   MOVE 'TABLE_NA'          TO TABLE-ELEMENT-3          
                   MOVE SW-TABLE-NA         TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7020-PREMISE-INFO                                           *        
      *        GETS PREMISE INFORMATION                                *        
      ******************************************************************        
       7020-PREMISE-INFO.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOT,
              BLOCK,
              PREM_REF_LATITUDE,
              PREM_REF_LONGITUDE,
              SPCL_INSTRUCTIONS,
              SPCL_READ_INSTR,
              PREMISE_DIRECTIONS,
              SUBDIVISION_DESC,
              PR.SUBDIVISION_ID,
              COUNTY,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST,
              HOT_SPOT_FL                                        
                INTO :S-LOT,                                            
                     :S-BLOCK,                                          
                     :S-LATITUDE,                                       
                     :S-LONGITUDE,                                      
                     :PR-SPCL-INSTRUCTIONS,                             
                     :PR-SPCL-READ-INSTR,                               
                     :S-PREMISE-DIRECTIONS,                             
                     :S-SUBDIVISION-DESC,                               
A05020               :S-SUBDIVISION-ID,                                 
                     :PR-COUNTY,                                        
                     :PR-ADDRESS-ID,                                    
                     :PR-ADDRESS-FORMAT,                                
                     :PR-FM-ELEC-SVC-WKDIST,                            
                     :PR-FM-GAS-OPS-WKDIST,                             
                     :PR-FM-FLD-SVCS-WKDIST,                            
                     :PR-FM-REV-PRT-WKDIST,                             
                     :PR-FM-DSM-ESVC-WKDIST,                            
A05020               :S-HOT-SPOT-FL                                     
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_SUBDIVISION B0 WITH(READUNCOMMITTED)                   
               WHERE PREMISE_NO        = :VO-PREMISE-NO                 
                 AND PR.COMPANY_NO     = :VO-COMPANY-NO                 
                 AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID              
                 AND PR.COMPANY_NO     = B0.COMPANY_NO                  
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOT,                                                       
MFA-TR*              BLOCK,                                                     
MFA-TR*              PREM_REF_LATITUDE,                                         
MFA-TR*              PREM_REF_LONGITUDE,                                        
MFA-TR*              SPCL_INSTRUCTIONS,                                         
MFA-TR*              SPCL_READ_INSTR,                                           
MFA-TR*              PREMISE_DIRECTIONS,                                        
MFA-TR*              SUBDIVISION_DESC,                                          
MFA-TR*              PR.SUBDIVISION_ID,                                         
MFA-TR*              COUNTY,                                                    
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              FM_ELEC_SVC_WKDIST,                                        
MFA-TR*              FM_GAS_OPS_WKDIST,                                         
MFA-TR*              FM_FLD_SVCS_WKDIST,                                        
MFA-TR*              FM_REV_PRT_WKDIST,                                         
MFA-TR*              FM_DSM_ESVC_WKDIST,                                        
MFA-TR*              HOT_SPOT_FL                                                
MFA-TR*         INTO :S-LOT,                                                    
MFA-TR*              :S-BLOCK,                                                  
MFA-TR*              :S-LATITUDE,                                               
MFA-TR*              :S-LONGITUDE,                                              
MFA-TR*              :PR-SPCL-INSTRUCTIONS,                                     
MFA-TR*              :PR-SPCL-READ-INSTR,                                       
MFA-TR*              :S-PREMISE-DIRECTIONS,                                     
MFA-TR*              :S-SUBDIVISION-DESC,                                       
MFA-TR*              :S-SUBDIVISION-ID,                                         
MFA-TR*              :PR-COUNTY,                                                
MFA-TR*              :PR-ADDRESS-ID,                                            
MFA-TR*              :PR-ADDRESS-FORMAT,                                        
MFA-TR*              :PR-FM-ELEC-SVC-WKDIST,                                    
MFA-TR*              :PR-FM-GAS-OPS-WKDIST,                                     
MFA-TR*              :PR-FM-FLD-SVCS-WKDIST,                                    
MFA-TR*              :PR-FM-REV-PRT-WKDIST,                                     
MFA-TR*              :PR-FM-DSM-ESVC-WKDIST,                                    
MFA-TR*              :S-HOT-SPOT-FL                                             
MFA-TR*         FROM CSS_PREMISE PR,                                            
MFA-TR*              CSS_SUBDIVISION B0                                         
MFA-TR*        WHERE PREMISE_NO        = :VO-PREMISE-NO                         
MFA-TR*          AND PR.COMPANY_NO     = :VO-COMPANY-NO                         
MFA-TR*          AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID                      
MFA-TR*          AND PR.COMPANY_NO     = B0.COMPANY_NO                          
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7030-CUST-DNP-INFO                                          *        
      *        GETS CUSTOMERS DNP INFORMATION                          *        
      ******************************************************************        
       7030-CUST-DNP-INFO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-DNP-CRITICAL-CUS                                
                FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED),                  
                     CSS_CRIT_OUTAGE Q2 WITH(READUNCOMMITTED)                   
               WHERE AT.ACCOUNT_NO       = :VO-ACCOUNT-NO               
                 AND AT.CODE_CRIT_OUTAGE = Q2.CODE_CRIT_OUTAGE          
                 AND AT.COMPANY_NO       = Q2.COMPANY_NO                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-DNP-CRITICAL-CUS                                        
MFA-TR*         FROM CSS_ACCOUNT     AT,                                        
MFA-TR*              CSS_CRIT_OUTAGE Q2                                         
MFA-TR*        WHERE AT.ACCOUNT_NO       = :VO-ACCOUNT-NO                       
MFA-TR*          AND AT.CODE_CRIT_OUTAGE = Q2.CODE_CRIT_OUTAGE                  
MFA-TR*          AND AT.COMPANY_NO       = Q2.COMPANY_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N'                 TO S-DNP-CRITICAL-CUS       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_DNP'           TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7040A-GAS-SERV-LINE-INFO                                    *        
      *        GETS GAS SERVICE LINE INFORMATION                       *        
      ******************************************************************        
       7040A-GAS-SERV-LINE-INFO.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XO.TOTAL_BTU,
              SPLIT_SERV_FL,
              XS_FLOW_VALVE_FL                                   
                INTO :S-TOTAL-BTU,                                      
                     :XO-SPLIT-SERV-FL,                                 
                     :XO-XS-FLOW-VALVE-FL                               
                FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED),                
                     CSS_GASLINE_SO_XRF XX WITH(READUNCOMMITTED)                
               WHERE XO.SERVICE_NO    = XX.SERVICE_NO                   
                 AND XX.SERV_ORDER_NO = :VI-SERV-ORDER-NO               
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XO.TOTAL_BTU,                                              
MFA-TR*              SPLIT_SERV_FL,                                             
MFA-TR*              XS_FLOW_VALVE_FL                                           
MFA-TR*         INTO :S-TOTAL-BTU,                                              
MFA-TR*              :XO-SPLIT-SERV-FL,                                         
MFA-TR*              :XO-XS-FLOW-VALVE-FL                                       
MFA-TR*         FROM CSS_GAS_SERV_LINE XO,                                      
MFA-TR*              CSS_GASLINE_SO_XRF XX                                      
MFA-TR*        WHERE XO.SERVICE_NO    = XX.SERVICE_NO                           
MFA-TR*          AND XX.SERV_ORDER_NO = :VI-SERV-ORDER-NO                       
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   MOVE SPACES              TO XO-SPLIT-SERV-FL         
                                               XO-XS-FLOW-VALVE-FL      
                   PERFORM 7040B-GAS-SERV-LINE-INFO  THRU 7040B-EXIT    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_GASLINE_SO_XRF' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7040B-GAS-SERV-LINE-INFO                                    *        
      *        GETS GAS SERVICE LINE INFORMATION                       *        
      ******************************************************************        
       7040B-GAS-SERV-LINE-INFO.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) XO.TOTAL_BTU,
              SPLIT_SERV_FL,
              XS_FLOW_VALVE_FL                                   
                INTO :S-TOTAL-BTU,                                      
                     :XO-SPLIT-SERV-FL,                                 
                     :XO-XS-FLOW-VALVE-FL                               
                FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED),                
                     CSS_PREM_GAS_LINE YO WITH(READUNCOMMITTED)                 
               WHERE XO.SERVICE_NO = YO.SERVICE_NO                      
                 AND PREMISE_NO    = :VO-PREMISE-NO                     
                 AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')               
               ORDER BY SERV_LINE_STAT_FL ASC                           
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT XO.TOTAL_BTU,                                              
MFA-TR*              SPLIT_SERV_FL,                                             
MFA-TR*              XS_FLOW_VALVE_FL                                           
MFA-TR*         INTO :S-TOTAL-BTU,                                              
MFA-TR*              :XO-SPLIT-SERV-FL,                                         
MFA-TR*              :XO-XS-FLOW-VALVE-FL                                       
MFA-TR*         FROM CSS_GAS_SERV_LINE XO,                                      
MFA-TR*              CSS_PREM_GAS_LINE YO                                       
MFA-TR*        WHERE XO.SERVICE_NO = YO.SERVICE_NO                              
MFA-TR*          AND PREMISE_NO    = :VO-PREMISE-NO                             
MFA-TR*          AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')                       
MFA-TR*        ORDER BY SERV_LINE_STAT_FL ASC                                   
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7041                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   MOVE SPACES              TO XO-SPLIT-SERV-FL         
                                               XO-XS-FLOW-VALVE-FL      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_GAS_SERV_LINE' TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7050-GET-LONG-DESC.                                         *        
      *        GETS BUSINESS UNIT INFORMATION                          *        
      ******************************************************************        
       7050-GET-LONG-DESC.                                              
                                                                        
           EXEC SQL                                                     
              SELECT CODE_LONG_DESC                                     
                INTO :SW-CODE-LONG-DESC                                 
                FROM CSS_SO_CODE_DESC WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO    = :SW-COMPANY-NO                     
                 AND TABLE_NA      = :SW-TABLE-NA                       
                 AND COLUMN_NA     = :SW-COLUMN-NA                      
                 AND CODE_VALUE    = :SW-CODE-VALUE                     
                 AND PROGRAM_ID    = 'ALL'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_LONG_DESC                                             
MFA-TR*         INTO :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_SO_CODE_DESC                                           
MFA-TR*        WHERE COMPANY_NO    = :SW-COMPANY-NO                             
MFA-TR*          AND TABLE_NA      = :SW-TABLE-NA                               
MFA-TR*          AND COLUMN_NA     = :SW-COLUMN-NA                              
MFA-TR*          AND CODE_VALUE    = :SW-CODE-VALUE                             
MFA-TR*          AND PROGRAM_ID    = 'ALL'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7050'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_CODE_DESC'  TO TABLE-1                  
                   MOVE 'CODE_VALUE'        TO TABLE-ELEMENT-1          
                   MOVE SW-CODE-VALUE       TO HOSTVAR-ELEMENT-1        
                   MOVE 'COLUMN_NA'         TO TABLE-ELEMENT-2          
                   MOVE SW-COLUMN-NA        TO HOSTVAR-ELEMENT-2        
                   MOVE 'TABLE_NA'          TO TABLE-ELEMENT-3          
                   MOVE SW-TABLE-NA         TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7055-CHECK-SO-UPDATE                                        *        
      *        CHECKS FOR FM RELATED ORDER INFO                        *        
      ******************************************************************        
       7055-CHECK-SO-UPDATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-TASK-DATA                                      
                FROM CSS_SO_UPDATE WITH(READUNCOMMITTED)                        
               WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                  
                 AND PANEL_NO      = 'FMLD'                             
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-TASK-DATA                                              
MFA-TR*         FROM CSS_SO_UPDATE                                              
MFA-TR*        WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                          
MFA-TR*          AND PANEL_NO      = 'FMLD'                                     
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7055                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N'                 TO WS-TASK-DATA             
                   PERFORM 7056-CHECK-SO-ORD-INST THRU 7056-EXIT        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7055'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UPDATE'     TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7056-CHECK-SO-ORD-INST.                                     *        
      *        CHECKS FOR FM RELATED ORDER INFO FOR CANCELS            *        
      ******************************************************************        
       7056-CHECK-SO-ORD-INST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-TASK-DATA                                      
                FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                    
               WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                 
                 AND TASK_STATUS_CD = 'C'                               
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-TASK-DATA                                              
MFA-TR*         FROM CSS_SO_ORDER_INST                                          
MFA-TR*        WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                         
MFA-TR*          AND TASK_STATUS_CD = 'C'                                       
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7056                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N'                 TO WS-TASK-DATA             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7056'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7056-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7060-GET-ORDER-DETAILS                                      *        
      *        GETS SERVICE CHARGES INFORMATION                        *        
      ******************************************************************        
       7060-GET-ORDER-DETAILS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ORDER_GROUP_CD,
              ORDER_TYPE_DESC                                    
                INTO :C2-ORDER-GROUP-CD,                                
                     :S-ORDER-TYPE-CD                                   
                FROM CSS_SO_DATA  VO WITH(READUNCOMMITTED),                     
                     CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)                    
               WHERE SERV_ORDER_NO    = :VI-SERV-ORDER-NO               
                 AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                
                 AND VO.COMPANY_NO    = C2.COMPANY_NO                   
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ORDER_GROUP_CD,                                            
MFA-TR*              ORDER_TYPE_DESC                                            
MFA-TR*         INTO :C2-ORDER-GROUP-CD,                                        
MFA-TR*              :S-ORDER-TYPE-CD                                           
MFA-TR*         FROM CSS_SO_DATA  VO,                                           
MFA-TR*              CSS_ORDER_TYPE C2                                          
MFA-TR*        WHERE SERV_ORDER_NO    = :VI-SERV-ORDER-NO                       
MFA-TR*          AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                        
MFA-TR*          AND VO.COMPANY_NO    = C2.COMPANY_NO                           
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7060'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ORDER_TYPE'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE VO-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7060A-FMT-PREMADDR                                          *        
      *        GETS CUSTOMERS FORMATTED ADDRESS INFORMATION            *        
      ******************************************************************        
       7060A-FMT-PREMADDR.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))))))))),
              DY.ZIP_CODE,
              DY.ZIP_CODE_PLUS_FOUR,
              A4.TOWN,
              STATE,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))),
              RTRIM(LTRIM(RTRIM(STREET_NAME) + ' AND  ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW)))),
              ADDR_USAGE_CD                                     
                 INTO :S-STREET-ADDRESS,                                
                      :S-ZIP-CODE,                                      
A05020                :S-ZIP-CODE-PLUS-FOUR,                            
                      :S-TOWN,                                          
                      :S-STATE,                                         
                      :S-HOUSE-NO,                                      
                      :S-ADDR-PREFIX-1,                                 
                      :S-ADDR-PREFIX-2,                                 
                      :S-STREET-NAME,                                   
                      :S-STREET-SUFFIX,                                 
                      :S-ADDR-SUFFIX,                                   
                      :S-STREET-LOCATION-1,                             
                      :S-STREET-LOCATION-2,                             
A05020                :WS-STREET-ADDRESS-I,                             
A05020                :WS-STREET-NAMES-I,                               
A05020                :DY-ADDR-USAGE-CD                                 
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                    
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE PR.ADDRESS_ID     = :PR-ADDRESS-ID                
                  AND PR.ADDRESS_ID     = DY.ADDRESS_ID                 
                  AND DY.ZIP_CODE       = A4.ZIP_CODE                   
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)))))))))),                  
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_PLUS_FOUR,                                    
MFA-TR*               A4.TOWN,                                                  
MFA-TR*               STATE,                                                    
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||               
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                   
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                              
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                              
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))),                           
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' AND  ' ||             
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                         
MFA-TR*               ADDR_USAGE_CD                                             
MFA-TR*          INTO :S-STREET-ADDRESS,                                        
MFA-TR*               :S-ZIP-CODE,                                              
MFA-TR*               :S-ZIP-CODE-PLUS-FOUR,                                    
MFA-TR*               :S-TOWN,                                                  
MFA-TR*               :S-STATE,                                                 
MFA-TR*               :S-HOUSE-NO,                                              
MFA-TR*               :S-ADDR-PREFIX-1,                                         
MFA-TR*               :S-ADDR-PREFIX-2,                                         
MFA-TR*               :S-STREET-NAME,                                           
MFA-TR*               :S-STREET-SUFFIX,                                         
MFA-TR*               :S-ADDR-SUFFIX,                                           
MFA-TR*               :S-STREET-LOCATION-1,                                     
MFA-TR*               :S-STREET-LOCATION-2,                                     
MFA-TR*               :WS-STREET-ADDRESS-I,                                     
MFA-TR*               :WS-STREET-NAMES-I,                                       
MFA-TR*               :DY-ADDR-USAGE-CD                                         
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4,                                          
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE PR.ADDRESS_ID     = :PR-ADDRESS-ID                        
MFA-TR*           AND PR.ADDRESS_ID     = DY.ADDRESS_ID                         
MFA-TR*           AND DY.ZIP_CODE       = A4.ZIP_CODE                           
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE S-STREET-ADDRESS                          
                              S-HOUSE-NO                                
                              S-ADDR-PREFIX-1                           
                              S-ADDR-PREFIX-2                           
                              S-STREET-NAME                             
                              S-STREET-SUFFIX                           
                              S-ADDR-SUFFIX                             
                              S-STREET-LOCATION-1                       
                              S-STREET-LOCATION-2                       
                              WS-STREET-ADDRESS-I                       
                              WS-STREET-NAMES-I                         
                              DY-ADDR-USAGE-CD                          
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7060A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'      TO TABLE-3                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-2          
                   MOVE PR-ADDRESS-ID       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7065A-GET-COUNTY                                            *        
      *        GETS COUNTY DESCRIPTION                                 *        
      ******************************************************************        
       7065A-GET-COUNTY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COUNTY_DESC                                       
                 INTO :S-COUNTY                                         
                 FROM CSS_STATE_COUNTY WITH(READUNCOMMITTED)                    
                WHERE STATE  = :S-STATE                                 
                  AND COUNTY = :PR-COUNTY                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNTY_DESC                                               
MFA-TR*          INTO :S-COUNTY                                                 
MFA-TR*          FROM CSS_STATE_COUNTY                                          
MFA-TR*         WHERE STATE  = :S-STATE                                         
MFA-TR*           AND COUNTY = :PR-COUNTY                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7065                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7065A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_STATE_COUNTY'  TO TABLE-1                  
                   MOVE 'COUNTY'            TO TABLE-ELEMENT-1          
                   MOVE PR-COUNTY           TO HOSTVAR-ELEMENT-1        
                   MOVE 'STATE'             TO TABLE-ELEMENT-2          
                   MOVE S-STATE             TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7065A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7060B-FF-PREMADDR                                           *        
      *        GETS CUSTOMERS FREEFORM ADDRESS INFORMATION             *        
      ******************************************************************        
       7060B-FF-PREMADDR.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(ADDR_STREET))),
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY,
              ADDR_STREET                                       
                 INTO :S-STREET-ADDRESS,                                
                      :S-STATE,                                         
                      :S-ZIP-CODE,                                      
                      :S-COUNTRY,                                       
                      :S-ADDR-STREET                                    
                 FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),               
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE PR.ADDRESS_ID = DZ.ADDRESS_ID                     
                  AND PR.ADDRESS_ID = :PR-ADDRESS-ID                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(ADDR_STREET))),                         
MFA-TR*               ADDR_CITY_STATE,                                          
MFA-TR*               ADDR_ZIP_CODE,                                            
MFA-TR*               ADDR_COUNTRY,                                             
MFA-TR*               ADDR_STREET                                               
MFA-TR*          INTO :S-STREET-ADDRESS,                                        
MFA-TR*               :S-STATE,                                                 
MFA-TR*               :S-ZIP-CODE,                                              
MFA-TR*               :S-COUNTRY,                                               
MFA-TR*               :S-ADDR-STREET                                            
MFA-TR*          FROM CSS_ADDR_FREEFORM DZ,                                     
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE PR.ADDRESS_ID = DZ.ADDRESS_ID                             
MFA-TR*           AND PR.ADDRESS_ID = :PR-ADDRESS-ID                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7061                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF S-STREET-ADDRESS = '-'                            
                       MOVE SPACES TO S-STREET-ADDRESS                  
                   END-IF                                               
                   IF S-COUNTRY > ' '                                   
                       INSPECT S-STREET-ADDRESS REPLACING               
                           ALL ' -' BY '  '                             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES              TO S-STREET-ADDRESS         
                                               S-ADDR-STREET            
                                               S-ADDR-CITY-STATE        
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7060B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-1          
                   MOVE PR-ADDRESS-ID       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7070-SO-REMARKS-INFO                                        *        
      *        GETS SERVICE ORDER REMARKS INFORMATION                  *        
      ******************************************************************        
       7070-SO-REMARKS-INFO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REMARK_TX,
              REMARK_TYPE_CD                                     
                INTO :EF-REMARK-TX,                                     
                     :EF-REMARK-TYPE-CD                                 
                FROM CSS_SO_REMARKS WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO     = :VI-SERV-ORDER-NO              
                 AND REMARK_TYPE_CD    = :WS-REMARK-TYPE                
               ORDER BY REMARK_DATETIME DESC                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REMARK_TX,                                                 
MFA-TR*              REMARK_TYPE_CD                                             
MFA-TR*         INTO :EF-REMARK-TX,                                             
MFA-TR*              :EF-REMARK-TYPE-CD                                         
MFA-TR*         FROM CSS_SO_REMARKS                                             
MFA-TR*        WHERE SERV_ORDER_NO     = :VI-SERV-ORDER-NO                      
MFA-TR*          AND REMARK_TYPE_CD    = :WS-REMARK-TYPE                        
MFA-TR*        ORDER BY REMARK_DATETIME DESC                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 INSPECT EF-REMARK-TX-TEXT REPLACING ALL LOW-VALUES     
                                           BY SPACES                    
                 IF EF-REMARK-TYPE-CD = WS-SO-REMARKS                   
                    MOVE EF-REMARK-TX-TEXT  TO S-SERV-ORDER-REMARKS     
                 END-IF                                                 
                 IF EF-REMARK-TYPE-CD = WS-SO-CHANGELOG                 
                    MOVE EF-REMARK-TX-TEXT  TO S-SERV-ORDER-REMUPD      
                 END-IF                                                 
                 IF EF-REMARK-TYPE-CD = WS-SO-COMPLETION                
                    MOVE EF-REMARK-TX-TEXT  TO S-SO-COMPL-REMARKS       
                 END-IF                                                 
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7070'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7080-GET-NAME-INFO                                          *        
      *        GETS SERVICE ORDER REMARKS INFORMATION                  *        
      ******************************************************************        
       7080-GET-NAME-INFO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),
              FULL_NAME,
              NAME_FORMAT                                        
                INTO :WS-CUST-NAME,                                     
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                 AND CU.NAME_ID  = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(RTRIM(LAST_NAME) ||                                  
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(TITLE_SUFFIX_1)) ||                                  
MFA-TR*              ', ' ||                                                    
MFA-TR*              RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME),                                        
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         INTO :WS-CUST-NAME,                                             
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*         FROM CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*          AND CU.NAME_ID  = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME    TO S-FULL-NAME              
                   ELSE                                                 
                       MOVE WS-CUST-NAME    TO S-FULL-NAME              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7080'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_NAME'          TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7085-GET-METER-INFO                                         *        
      *        GETS METER INFORMATION                                  *        
      ******************************************************************        
       7085-GET-METER-INFO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GIS_POINT_ID,                                      
                     ELEC_PHASE_CD                                      
                INTO :MN-GIS-POINT-ID,                                  
                     :S-CUST-PHASE-CD                                   
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :WS-ACCOUNT                       
                 AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                
                 AND IC_NO          = :VI-IC-NO                         
                 AND MTR_REF_NO     = :VI-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GIS_POINT_ID,                                              
MFA-TR*              ELEC_PHASE_CD                                              
MFA-TR*         INTO :MN-GIS-POINT-ID,                                          
MFA-TR*              :S-CUST-PHASE-CD                                           
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :WS-ACCOUNT                               
MFA-TR*          AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :VI-IC-NO                                 
MFA-TR*          AND MTR_REF_NO     = :VI-MTR-REF-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7085                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE                  MN-GIS-POINT-ID          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7085'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7085-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7090-PIM-POINT-INFO                                         *        
      *        GETS POINT ID INFORMATION                               *        
      ******************************************************************        
       7090-PIM-POINT-INFO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COALESCE(GRID_CELL_TX,'000000-000'),                 
                     COALESCE(CIRCUIT_ID, '     '),                       
                     AREA_ID,                                           
                     TAG_NM,                                            
                     SUBSTATION_ID                                      
                INTO :S-GRID-CELL,                                      
                     :S-CIRCUIT-ID,                                     
                     :PP-AREA-ID,                                       
                     :PP-TAG-NM,                                        
                     :PP-SUBSTATION-ID                                  
                FROM CSS_PIM_POINT PP WITH(READUNCOMMITTED)                     
               WHERE POINT_ID         = :MN-GIS-POINT-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(GRID_CELL_TX,'000000-000'),                         
MFA-TR*              IFNULL(CIRCUIT_ID, '     '),                               
MFA-TR*              AREA_ID,                                                   
MFA-TR*              TAG_NM,                                                    
MFA-TR*              SUBSTATION_ID                                              
MFA-TR*         INTO :S-GRID-CELL,                                              
MFA-TR*              :S-CIRCUIT-ID,                                             
MFA-TR*              :PP-AREA-ID,                                               
MFA-TR*              :PP-TAG-NM,                                                
MFA-TR*              :PP-SUBSTATION-ID                                          
MFA-TR*         FROM CSS_PIM_POINT PP                                           
MFA-TR*        WHERE POINT_ID         = :MN-GIS-POINT-ID                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PP-AREA-ID          TO S-METER-POINT-ID(1:3)    
                   MOVE PP-TAG-NM           TO S-METER-POINT-ID(4:7)    
                   MOVE PP-TAG-NM           TO S-POLE-NO                
                   PERFORM 7091-GET-SUBSTATION   THRU 7091-EXIT         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7090'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PIM_POINT'     TO TABLE-1                  
                   MOVE 'POINT_ID'          TO TABLE-ELEMENT-1          
                   MOVE PP-POINT-ID         TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7091-GET-SUBSTATION                                         *        
      *        GETS SUBSTATION NAME                                    *        
      ******************************************************************        
       7091-GET-SUBSTATION.                                             
                                                                        
           EXEC SQL                                                     
              SELECT SUBSTATION_NA                                      
                INTO :S-SUBSTATION-ID                                   
                FROM CSS_SUBSTATION WITH(READUNCOMMITTED)                       
               WHERE SUBSTATION_ID    = :PP-SUBSTATION-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTATION_NA                                              
MFA-TR*         INTO :S-SUBSTATION-ID                                           
MFA-TR*         FROM CSS_SUBSTATION                                             
MFA-TR*        WHERE SUBSTATION_ID    = :PP-SUBSTATION-ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7091                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES              TO S-SUBSTATION-ID          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7091'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SUBSTATION'    TO TABLE-1                  
                   MOVE 'SUBSTATION_ID'     TO TABLE-ELEMENT-1          
                   MOVE PP-SUBSTATION-ID    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7091-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7095-GET-MATERIAL-FL                                        *        
      *        GETS MATERIAL FL INFORMATION                            *        
      ******************************************************************        
       7095-GET-MATERIAL-FL.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :S-MATERIAL-FL                                     
                FROM CSS_WORK_AREA_MATL WITH(READUNCOMMITTED)                   
               WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-MATERIAL-FL                                             
MFA-TR*         FROM CSS_WORK_AREA_MATL                                         
MFA-TR*        WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7095                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N'                 TO S-MATERIAL-FL            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7095'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_WORK_AREA_MATL' TO TABLE-1                 
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7095-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7096A-CHECK-HOLIDAY                                         *        
      *        CHECKS FOR HOLIDAY                                      *        
      ******************************************************************        
       7096A-CHECK-HOLIDAY.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-HOLIDAY                                        
                FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                          
               WHERE HOLIDAY_DT       = IIF(TRY_CONVERT(DATE, 
                                                        :WS-ASSIGN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGN-DATE
              ) <> 0) OR (LEN(:WS-ASSIGN-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ASSIGN-DATE
              ), CONVERT(DATE, :WS-ASSIGN-DATE) )                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-HOLIDAY                                                
MFA-TR*         FROM CSS_HOLIDAY                                                
MFA-TR*        WHERE HOLIDAY_DT       = :WS-ASSIGN-DATE                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70961                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE '8'                TO WS-DAY-OF-WEEK           
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7096A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_HOLIDAY'       TO TABLE-1                  
                   MOVE 'ASSIGN_DATE'       TO TABLE-ELEMENT-1          
                   MOVE WS-ASSIGN-DATE      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7096A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7096-GET-WORK-TIMES                                         *        
      *        GETS WORK TIMES FOR THE WORK AREA                       *        
      ******************************************************************        
       7096-GET-WORK-TIMES.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(START_TIME AS TIME)), CAST(
           START_TIME AS TIME)), 108), ':', '.'),                              
                     REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(STOP_TIME AS TIME)), CAST(
           STOP_TIME AS TIME)), 108), ':', '.')                                
                INTO :S-WORK-START-TIME,                                
                     :S-WORK-STOP-TIME                                  
                FROM CSS_WKAREA_PRMSSN WITH(READUNCOMMITTED)                    
               WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                
                 AND BLOCK_TYPE_ID    = :WS-DAY-OF-WEEK                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIME(START_TIME),                                          
MFA-TR*              TIME(STOP_TIME)                                            
MFA-TR*         INTO :S-WORK-START-TIME,                                        
MFA-TR*              :S-WORK-STOP-TIME                                          
MFA-TR*         FROM CSS_WKAREA_PRMSSN                                          
MFA-TR*        WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                        
MFA-TR*          AND BLOCK_TYPE_ID    = :WS-DAY-OF-WEEK                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7096                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-BEGIN-TIME       TO S-WORK-START-TIME        
                   MOVE WS-END-TIME         TO S-WORK-STOP-TIME         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7096'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_WKAREA_PRMSSN' TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7096-EXIT.                                                       
           EXIT.                                                        
A05020******************************************************************        
A05020*   7096B-GET-WORK-TIMES                                         *        
A05020*        GETS AM PM WORK TIMES FOR THE WORK AREA                 *        
A05020******************************************************************        
A05020 7096B-GET-WORK-TIMES.                                            
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(START_SHIFT_AM_TM AS TIME)), 
           CAST(START_SHIFT_AM_TM AS TIME)), 108), ':', '.'),                  
A05020               REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(STOP_SHIFT_AM_TM AS TIME)), 
           CAST(STOP_SHIFT_AM_TM AS TIME)), 108), ':', '.'),                   
A05020               REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(START_SHIFT_PM_TM AS TIME)), 
           CAST(START_SHIFT_PM_TM AS TIME)), 108), ':', '.'),                  
A05020               REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(STOP_SHIFT_PM_TM AS TIME)), 
           CAST(STOP_SHIFT_PM_TM AS TIME)), 108), ':', '.')                    
A05020          INTO :I4-START-SHIFT-AM-TM                              
A05020              ,:I4-STOP-SHIFT-AM-TM                               
A05020              ,:I4-START-SHIFT-PM-TM                              
A05020              ,:I4-STOP-SHIFT-PM-TM                               
A05020          FROM CSS_WKAREA_PRMSSN WITH(READUNCOMMITTED)                    
A05020         WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                
A05020           AND BLOCK_TYPE_ID    = :WS-DAY-OF-WEEK                 
A05020                                                           
A05020                                                     
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TIME(START_SHIFT_AM_TM),                                   
MFA-TR*              TIME(STOP_SHIFT_AM_TM),                                    
MFA-TR*              TIME(START_SHIFT_PM_TM),                                   
MFA-TR*              TIME(STOP_SHIFT_PM_TM)                                     
MFA-TR*         INTO :I4-START-SHIFT-AM-TM                                      
MFA-TR*             ,:I4-STOP-SHIFT-AM-TM                                       
MFA-TR*             ,:I4-START-SHIFT-PM-TM                                      
MFA-TR*             ,:I4-STOP-SHIFT-PM-TM                                       
MFA-TR*         FROM CSS_WKAREA_PRMSSN                                          
MFA-TR*        WHERE WORK_AREA_ID     = :VO-WORK-AREA-ID                        
MFA-TR*          AND BLOCK_TYPE_ID    = :WS-DAY-OF-WEEK                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70962                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             IF VO-APPT-AM-PM-CD = 'A'                            
A05020                MOVE I4-START-SHIFT-AM-TM TO S-WORK-START-TIME    
A05020                MOVE I4-STOP-SHIFT-AM-TM TO S-WORK-STOP-TIME      
A05020             ELSE                                                 
A05020                IF VO-APPT-AM-PM-CD = 'P'                         
A05020                   MOVE I4-START-SHIFT-PM-TM TO S-WORK-START-TIME 
A05020                   MOVE I4-STOP-SHIFT-PM-TM  TO S-WORK-STOP-TIME  
A05020                END-IF                                            
A05020             END-IF                                               
A05020         WHEN NOT-FOUND                                           
A05020             MOVE WS-BEGIN-APPT-TIME  TO S-WORK-START-TIME        
A05020             MOVE WS-END-APPT-TIME    TO S-WORK-STOP-TIME         
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7096B'             TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_WKAREA_PRMSSN' TO TABLE-1                  
A05020             MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
A05020             MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7096B-EXIT.                                                      
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7097-GET-PRINT-LOC                                          *        
A05020*        GETS THE PRINTER DETAILS                                *        
A05020******************************************************************        
A05020 7097-GET-PRINT-LOC.                                              
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         SELECT START_TIME,                                       
A05020                END_TIME,                                         
A05020                PRINTER_NRML_HRS,                                 
A05020                PRINTER_AFTER_HRS                                 
A05020           INTO :C4-START-TIME,                                   
A05020                :C4-END-TIME,                                     
A05020                :C4-PRINTER-NRML-HRS,                             
A05020                :C4-PRINTER-AFTER-HRS                             
A05020           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
A05020          WHERE WORK_AREA_ID  = :VO-WORK-AREA-ID                  
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT START_TIME,                                               
MFA-TR*               END_TIME,                                                 
MFA-TR*               PRINTER_NRML_HRS,                                         
MFA-TR*               PRINTER_AFTER_HRS                                         
MFA-TR*          INTO :C4-START-TIME,                                           
MFA-TR*               :C4-END-TIME,                                             
MFA-TR*               :C4-PRINTER-NRML-HRS,                                     
MFA-TR*               :C4-PRINTER-AFTER-HRS                                     
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID  = :VO-WORK-AREA-ID                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7097                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE ZERO                TO C4-START-TIME            
A05020                                         C4-END-TIME              
A05020             MOVE SPACES              TO C4-PRINTER-NRML-HRS      
A05020                                         C4-PRINTER-AFTER-HRS     
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7097'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_PRINT_LOC'  TO TABLE-1                  
A05020             MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
A05020             MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7097-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7098-GET-CURRENT-TIMES                                      *        
A05020*        GETS THE CURRENT DATE/TIME/TIMESTAMP                    *        
A05020******************************************************************        
A05020 7098-GET-CURRENT-TIMES.                                          
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT
              SUBSTRING(CIS.CHAR2$TIME(CIS.CURRENT$TIME(),'EUR'), 1, 2
           ) + SUBSTRING(CIS.CHAR2$TIME(CIS.CURRENT$TIME(),'EUR'), 4, 2
           )
            INTO
              :WS-CURRENT-TIME           
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIME =                                            
MFA-TR*              SUBSTR(CHAR(TIME(CURRENT TIME),EUR),1,2) ||                
MFA-TR*              SUBSTR(CHAR(TIME(CURRENT TIME),EUR),4,2)                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
A05020     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
A05020                                                                  
A05020 7098-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    7099-CHECK-PRINT-INS                                        *        
A05020*        VERIFIES IF A ROW IS INSERTED FOR THIS SO# FOR WHICH THE*08100000
A05020*        THE PRINT IS PENDING. IF SO PREVENTS RE-INSERTING TO    *        
A05020*        AVOID DUPLICATE ORDERS BEING PRINTED.                            
A05020******************************************************************        
A05020 7099-CHECK-PRINT-INS.                                            
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        SELECT TOP(1) 'Y'                                                
A05020          INTO :WS-PRINT-INSERTED                                 
A05020          FROM CSS_SO_PRINT_QUEUE WITH(READUNCOMMITTED)                   
A05020         WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                 
A05020           AND PRINTED_TS     IS NULL                             
A05020           AND PRINT_PRIORITY = 1                                 
A05020                                            
A05020                                                           
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PRINT-INSERTED                                         
MFA-TR*         FROM CSS_SO_PRINT_QUEUE                                         
MFA-TR*        WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                         
MFA-TR*          AND PRINTED_TS     IS NULL                                     
MFA-TR*          AND PRINT_PRIORITY = 1                                         
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7099                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020         WHEN -811                                                
A05020             CONTINUE                                             
A05020         WHEN NOT-FOUND                                           
A05020             MOVE 'N'                 TO WS-PRINT-INSERTED        
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '7099'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'SELECT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_PRINT_Q'    TO TABLE-1                  
A05020             MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
A05020             MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7099-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      *    7210-GET-APPLIANCE                                          *        
      *        GETS APPLIANCES INFORMATION                             *        
      ******************************************************************        
       7210-GET-APPLIANCE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TAG_NO,                                            
                     CONDITION_DESC,                                    
                     APPLIANCE_COMMENTS,                                
                     CAUTION_TAG_DT                                     
                INTO :S-TAG-NO,                                         
                     :S-CONDITION-CD,                                   
                     :S-APPLIANCE-COMMENTS,                             
                     :S-CAUTION-TAG-DT :WS-NULL-11                       
                FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                    
                     CSS_APPLIANCE_COND A7 WITH(READUNCOMMITTED)                
               WHERE PREMISE_NO      = :VO-PREMISE-NO                   
                 AND APPLIANCE_CD    = :VQ-APPLIANCE-CD                 
                 AND A7.COMPANY_NO   = :VO-COMPANY-NO                   
                 AND A7.COMPANY_NO   = LA.COMPANY_NO                    
                 AND A7.CONDITION_CD = LA.CONDITION_CD                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TAG_NO,                                                    
MFA-TR*              CONDITION_DESC,                                            
MFA-TR*              APPLIANCE_COMMENTS,                                        
MFA-TR*              CAUTION_TAG_DT                                             
MFA-TR*         INTO :S-TAG-NO,                                                 
MFA-TR*              :S-CONDITION-CD,                                           
MFA-TR*              :S-APPLIANCE-COMMENTS,                                     
MFA-TR*              :S-CAUTION-TAG-DT:WS-NULL-11                               
MFA-TR*         FROM CSS_APPLIANCE LA,                                          
MFA-TR*              CSS_APPLIANCE_COND A7                                      
MFA-TR*        WHERE PREMISE_NO      = :VO-PREMISE-NO                           
MFA-TR*          AND APPLIANCE_CD    = :VQ-APPLIANCE-CD                         
MFA-TR*          AND A7.COMPANY_NO   = :VO-COMPANY-NO                           
MFA-TR*          AND A7.COMPANY_NO   = LA.COMPANY_NO                            
MFA-TR*          AND A7.CONDITION_CD = LA.CONDITION_CD                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-11 < 0                                   
                       MOVE SPACES          TO S-CAUTION-TAG-DT         
                    END-IF                                              
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7210'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'APPLIANCE_CD'      TO TABLE-ELEMENT-2          
                   MOVE VQ-APPLIANCE-CD     TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7210E-GET-APPLIANCE                                          *        
      *        GETS APPLIANCES INFORMATION FOR EMERGENCY ORDERS        *        
      ******************************************************************        
       7210E-GET-APPLIANCE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CONDITION_DESC                                     
                INTO :S-CONDITION-CD                                    
                FROM CSS_APPLIANCE_COND A7 WITH(READUNCOMMITTED)                
               WHERE A7.CONDITION_CD = :S-CONDITION-CD                  
                 AND A7.COMPANY_NO   = :VO-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONDITION_DESC                                             
MFA-TR*         INTO :S-CONDITION-CD                                            
MFA-TR*         FROM CSS_APPLIANCE_COND A7                                      
MFA-TR*        WHERE A7.CONDITION_CD = :S-CONDITION-CD                          
MFA-TR*          AND A7.COMPANY_NO   = :VO-COMPANY-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN -811                                                
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7210E'             TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE_COND' TO TABLE-1                 
                   MOVE 'CONDITION_CD'      TO TABLE-ELEMENT-1          
                   MOVE S-CONDITION-CD      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210E-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7220-GET-APPLIANCE-TYPE                                     *        
      *        GETS APPLIANCE TYPE DESCRIPTION                         *        
      ******************************************************************        
       7220-GET-APPLIANCE-TYPE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) APPLIANCE_DESC                                     
                INTO :S-APPLIANCE-CD                                    
                FROM CSS_MKT_APPLIANCE WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO      = :VO-COMPANY-NO                   
                 AND APPLIANCE_CD    = :VQ-APPLIANCE-CD                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT APPLIANCE_DESC                                             
MFA-TR*         INTO :S-APPLIANCE-CD                                            
MFA-TR*         FROM CSS_MKT_APPLIANCE                                          
MFA-TR*        WHERE COMPANY_NO      = :VO-COMPANY-NO                           
MFA-TR*          AND APPLIANCE_CD    = :VQ-APPLIANCE-CD                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7220'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-1                  
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'APPLIANCE_CD'      TO TABLE-ELEMENT-2          
                   MOVE VQ-APPLIANCE-CD     TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7310-GET-WORK-PERIOD.                                       *        
      *        GETS WORK PERIOD DESCRIPTION                            *        
      ******************************************************************        
       7310-GET-WORK-PERIOD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT WORK_PERIOD_DESC                                   
                INTO :SV-WORK-PERIOD-DESC                               
                FROM CSS_SO_SERVICE_CHG WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO        = :VO-COMPANY-NO                 
                 AND ORDER_TYPE_CD     = :VO-ORDER-TYPE-CD              
                 AND WORK_PERIOD_CD    = :VG-WORK-PERIOD-CD             
                 AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WORK_PERIOD_DESC                                           
MFA-TR*         INTO :SV-WORK-PERIOD-DESC                                       
MFA-TR*         FROM CSS_SO_SERVICE_CHG                                         
MFA-TR*        WHERE COMPANY_NO        = :VO-COMPANY-NO                         
MFA-TR*          AND ORDER_TYPE_CD     = :VO-ORDER-TYPE-CD                      
MFA-TR*          AND WORK_PERIOD_CD    = :VG-WORK-PERIOD-CD                     
MFA-TR*          AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    IF VO-ORDER-TYPE-CD = 'CC001' OR                    
                       VO-ORDER-TYPE-CD = 'CC002' OR                    
                       VO-ORDER-TYPE-CD = 'CC003'                       
                       MOVE VO-ORDER-TYPE-CD(1:2)  TO WS-ORDER-TYPE     
                       STRING VO-COMPANY-NO                             
                              AT-ACCOUNT-TYPE-CODE                      
                              WS-ORDER-TYPE                             
                              VG-WORK-PERIOD-CD                         
                              DELIMITED BY SIZE INTO S-WORK-PERIOD-CD   
                    ELSE                                                
                       STRING VO-COMPANY-NO                             
                              AT-ACCOUNT-TYPE-CODE                      
                              VO-ORDER-TYPE-CD                          
                              VG-WORK-PERIOD-CD                         
                              DELIMITED BY SIZE INTO S-WORK-PERIOD-CD   
                    END-IF                                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_SERVICE_CHG' TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-1          
                   MOVE VO-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
                   MOVE 'WORK_PERIOD_CD'    TO TABLE-ELEMENT-1          
                   MOVE VG-WORK-PERIOD-CD   TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7320-GET-WAIVER-TYPE-DESC                                   *        
      *        GETS WAIVER TYPE DESCRIPTION                            *        
      ******************************************************************        
       7320-GET-WAIVER-TYPE-DESC.                                       
                                                                        
           EXEC SQL                                                     
              SELECT WAIVER_DESC                                        
                INTO :S-WAIVER-TYPE-CD                                  
                FROM CSS_SO_WAIVER WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO        = :VO-COMPANY-NO                 
                 AND ORDER_TYPE_CD     = :VO-ORDER-TYPE-CD              
                 AND WAIVER_TYPE_CD    = :VG-WAIVER-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WAIVER_DESC                                                
MFA-TR*         INTO :S-WAIVER-TYPE-CD                                          
MFA-TR*         FROM CSS_SO_WAIVER                                              
MFA-TR*        WHERE COMPANY_NO        = :VO-COMPANY-NO                         
MFA-TR*          AND ORDER_TYPE_CD     = :VO-ORDER-TYPE-CD                      
MFA-TR*          AND WAIVER_TYPE_CD    = :VG-WAIVER-TYPE-CD                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7320'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_WAIVER'     TO TABLE-1                  
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-1          
                   MOVE VO-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
                   MOVE 'WAIVER_TYPE_CD'    TO TABLE-ELEMENT-1          
                   MOVE VG-WAIVER-TYPE-CD   TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7405-GET-MTR-CAP                                            *        
      *        GETS METER INFORMATION                                  *        
      ******************************************************************        
       7405-GET-MTR-CAP.                                                
                                                                        
           EXEC SQL                                                     
              SELECT CONSTANT,                                          
                     NO_DIALS                                           
                INTO :S-CONSTANT,                                       
                     :S-NO-DIALS-4                                      
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO     = :VO-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND REG_ID_NO      = :MN-REG-ID-NO                     
                 AND METER_NO       = :MN-METER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CONSTANT,                                                  
MFA-TR*              NO_DIALS                                                   
MFA-TR*         INTO :S-CONSTANT,                                               
MFA-TR*              :S-NO-DIALS-4                                              
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*        WHERE COMPANY_NO     = :VO-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND REG_ID_NO      = :MN-REG-ID-NO                             
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7405'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTR_CAP'       TO TABLE-1                  
                   MOVE 'METER_NO'          TO TABLE-ELEMENT-1          
                   MOVE MN-METER-NO         TO HOSTVAR-ELEMENT-1        
                   MOVE 'REG_ID_NO'         TO TABLE-ELEMENT-2          
                   MOVE MN-REG-ID-NO        TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7405-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7410-METER-INFO                                             *        
      *        GETS METER INFORMATION                                  *        
      ******************************************************************        
       7410-METER-INFO.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT ELEC_PHASE_CD,                                     
                     POINT_ID,                                          
                     GIS_POINT_ID,                                      
                     MIN_NO_UNITS,                                      
                     MAX_NO_UNITS,                                      
                     REMOTE_READ_IND,                                   
                     DIGTL_MTR_TYPE,                                    
                     PROGRAM_ID,                                        
                     MTR_READ_SOURCE_CD,                                
                     CODE_USAGE_TYPE                                    
                INTO :S-CUST-PHASE-CD,                                  
                     :MN-POINT-ID,                                      
                     :MN-GIS-POINT-ID,                                  
                     :MN-MIN-NO-UNITS,                                  
                     :MN-MAX-NO-UNITS,                                  
                     :MN-REMOTE-READ-IND :WS-NULL-12,                    
                     :MN-DIGTL-MTR-TYPE,                                
                     :MN-PROGRAM-ID,                                    
                     :MN-MTR-READ-SOURCE-CD,                            
                     :MN-CODE-USAGE-TYPE                                
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :WS-ACCOUNT                       
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND IC_NO          = :MN-IC-NO                         
                 AND MTR_REF_NO     = :MN-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ELEC_PHASE_CD,                                             
MFA-TR*              POINT_ID,                                                  
MFA-TR*              GIS_POINT_ID,                                              
MFA-TR*              MIN_NO_UNITS,                                              
MFA-TR*              MAX_NO_UNITS,                                              
MFA-TR*              REMOTE_READ_IND,                                           
MFA-TR*              DIGTL_MTR_TYPE,                                            
MFA-TR*              PROGRAM_ID,                                                
MFA-TR*              MTR_READ_SOURCE_CD,                                        
MFA-TR*              CODE_USAGE_TYPE                                            
MFA-TR*         INTO :S-CUST-PHASE-CD,                                          
MFA-TR*              :MN-POINT-ID,                                              
MFA-TR*              :MN-GIS-POINT-ID,                                          
MFA-TR*              :MN-MIN-NO-UNITS,                                          
MFA-TR*              :MN-MAX-NO-UNITS,                                          
MFA-TR*              :MN-REMOTE-READ-IND:WS-NULL-12,                            
MFA-TR*              :MN-DIGTL-MTR-TYPE,                                        
MFA-TR*              :MN-PROGRAM-ID,                                            
MFA-TR*              :MN-MTR-READ-SOURCE-CD,                                    
MFA-TR*              :MN-CODE-USAGE-TYPE                                        
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :WS-ACCOUNT                               
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :MN-IC-NO                                 
MFA-TR*          AND MTR_REF_NO     = :MN-MTR-REF-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-12 < 0                                    
                      MOVE SPACES           TO MN-REMOTE-READ-IND       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE                  MN-POINT-ID              
                                               MN-GIS-POINT-ID          
                                               MN-MIN-NO-UNITS          
                                               MN-MAX-NO-UNITS          
                                               MN-DIGTL-MTR-TYPE        
                                               MN-PROGRAM-ID            
                                               MN-MTR-READ-SOURCE-CD    
                                               MN-REMOTE-READ-IND       
                                               MN-CODE-USAGE-TYPE       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7410'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE WS-ACCOUNT          TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7415-GET-REMOTE-IND                                         *        
      *        GETS REMOTE READ INDICATOR DESCRIPTION                  *        
      ******************************************************************        
       7415-GET-REMOTE-IND.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REMOTE_READ_IND_TX                                 
                INTO :S-REMOTE-READ-IND                                 
                FROM CSS_REMOTE_RD_IND WITH(READUNCOMMITTED)                    
               WHERE REMOTE_READ_IND = :MN-REMOTE-READ-IND              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REMOTE_READ_IND_TX                                         
MFA-TR*         INTO :S-REMOTE-READ-IND                                         
MFA-TR*         FROM CSS_REMOTE_RD_IND                                          
MFA-TR*        WHERE REMOTE_READ_IND = :MN-REMOTE-READ-IND                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7415                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7415'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_REMOTE_RD_IND' TO TABLE-1                  
                   MOVE 'REMOTE_READ_IND'   TO TABLE-ELEMENT-1          
                   MOVE MN-REMOTE-READ-IND  TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7415-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7420-RATES-INFO                                             *        
      *        GETS RATES INFORMATION                                  *        
      ******************************************************************        
       7420-RATES-INFO.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT USAGE_HIGH_PCT,                                    
                     USAGE_LOW_PCT,                                     
                     DEMAND_HIGH_PCT,                                   
                     DEMAND_LOW_PCT                                     
                INTO :O9-USAGE-HIGH-PCT,                                
                     :O9-USAGE-LOW-PCT,                                 
                     :O9-DEMAND-HIGH-PCT,                               
                     :O9-DEMAND-LOW-PCT                                 
                FROM CSS_RATE_HIGH_LOW O9 WITH(READUNCOMMITTED),                
                     CSS_SO_UTL_CHG    VE WITH(READUNCOMMITTED)                 
               WHERE O9.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE              
                 AND O9.RATE_PLAN_NO   = VE.RATE_PLAN_NO                
                 AND SERV_ORDER_NO     = :VI-SERV-ORDER-NO              
                 AND O9.CODE_UTIL_TYPE = :VC-CODE-UTIL-TYPE             
                 AND IC_NO             = :VC-IC-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USAGE_HIGH_PCT,                                            
MFA-TR*              USAGE_LOW_PCT,                                             
MFA-TR*              DEMAND_HIGH_PCT,                                           
MFA-TR*              DEMAND_LOW_PCT                                             
MFA-TR*         INTO :O9-USAGE-HIGH-PCT,                                        
MFA-TR*              :O9-USAGE-LOW-PCT,                                         
MFA-TR*              :O9-DEMAND-HIGH-PCT,                                       
MFA-TR*              :O9-DEMAND-LOW-PCT                                         
MFA-TR*         FROM CSS_RATE_HIGH_LOW O9,                                      
MFA-TR*              CSS_SO_UTL_CHG    VE                                       
MFA-TR*        WHERE O9.CODE_UTIL_TYPE = VE.CODE_UTIL_TYPE                      
MFA-TR*          AND O9.RATE_PLAN_NO   = VE.RATE_PLAN_NO                        
MFA-TR*          AND SERV_ORDER_NO     = :VI-SERV-ORDER-NO                      
MFA-TR*          AND O9.CODE_UTIL_TYPE = :VC-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :VC-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7420                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE O9-USAGE-HIGH-PCT                         
                              O9-USAGE-LOW-PCT                          
                              O9-DEMAND-HIGH-PCT                        
                              O9-DEMAND-LOW-PCT                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7420'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_RATE_HIGH_LOW' TO TABLE-1                  
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1          
                   MOVE 'IC_NO'             TO TABLE-ELEMENT-2          
                   MOVE VC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1        
                   MOVE VC-IC-NO            TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7425-RATES-INFO                                             *        
      *        GETS RATES INFORMATION                                  *        
      ******************************************************************        
       7425-RATES-INFO.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT USAGE_HIGH_PCT,                                    
                     USAGE_LOW_PCT,                                     
                     DEMAND_HIGH_PCT,                                   
                     DEMAND_LOW_PCT                                     
                INTO :O9-USAGE-HIGH-PCT,                                
                     :O9-USAGE-LOW-PCT,                                 
                     :O9-DEMAND-HIGH-PCT,                               
                     :O9-DEMAND-LOW-PCT                                 
                FROM CSS_RATE_HIGH_LOW O9 WITH(READUNCOMMITTED),                
                     CSS_SO_UTILITY    VT WITH(READUNCOMMITTED)                 
               WHERE O9.CODE_UTIL_TYPE = VT.CODE_UTIL_TYPE              
                 AND O9.RATE_PLAN_NO   = VT.RATE_PLAN_NO                
                 AND SERV_ORDER_NO     = :VI-SERV-ORDER-NO              
                 AND O9.CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE             
                 AND IC_NO             = :VI-IC-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USAGE_HIGH_PCT,                                            
MFA-TR*              USAGE_LOW_PCT,                                             
MFA-TR*              DEMAND_HIGH_PCT,                                           
MFA-TR*              DEMAND_LOW_PCT                                             
MFA-TR*         INTO :O9-USAGE-HIGH-PCT,                                        
MFA-TR*              :O9-USAGE-LOW-PCT,                                         
MFA-TR*              :O9-DEMAND-HIGH-PCT,                                       
MFA-TR*              :O9-DEMAND-LOW-PCT                                         
MFA-TR*         FROM CSS_RATE_HIGH_LOW O9,                                      
MFA-TR*              CSS_SO_UTILITY    VT                                       
MFA-TR*        WHERE O9.CODE_UTIL_TYPE = VT.CODE_UTIL_TYPE                      
MFA-TR*          AND O9.RATE_PLAN_NO   = VT.RATE_PLAN_NO                        
MFA-TR*          AND SERV_ORDER_NO     = :VI-SERV-ORDER-NO                      
MFA-TR*          AND O9.CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :VI-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7425                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE O9-USAGE-HIGH-PCT                         
                              O9-USAGE-LOW-PCT                          
                              O9-DEMAND-HIGH-PCT                        
                              O9-DEMAND-LOW-PCT                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7425'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_RATE_HIGH_LOW' TO TABLE-1                  
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1          
                   MOVE 'IC_NO'             TO TABLE-ELEMENT-2          
                   MOVE VC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1        
                   MOVE VC-IC-NO            TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7430-READ-INFO                                              *        
      *        GETS READ INFORMATION                                   *        
      ******************************************************************        
       7430-READ-INFO.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT READ_CYCLE,                                        
                     READ_ROUTE,                                        
                     RATE_PLAN_NO,                                      
                     CODE_REVENUE_CLASS                                 
                INTO :S-READ-CYCLE,                                     
                     :S-READ-ROUTE,                                     
                     :S-RATE-PLAN-NO,                                   
                     :S-CODE-REVENUE-CLASS                              
                FROM CSS_SO_UTL_CHG WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO         = :VI-SERV-ORDER-NO          
                 AND CODE_UTIL_TYPE        = :VC-CODE-UTIL-TYPE         
                 AND IC_NO                 = :VC-IC-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_CYCLE,                                                
MFA-TR*              READ_ROUTE,                                                
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              CODE_REVENUE_CLASS                                         
MFA-TR*         INTO :S-READ-CYCLE,                                             
MFA-TR*              :S-READ-ROUTE,                                             
MFA-TR*              :S-RATE-PLAN-NO,                                           
MFA-TR*              :S-CODE-REVENUE-CLASS                                      
MFA-TR*         FROM CSS_SO_UTL_CHG                                             
MFA-TR*        WHERE SERV_ORDER_NO         = :VI-SERV-ORDER-NO                  
MFA-TR*          AND CODE_UTIL_TYPE        = :VC-CODE-UTIL-TYPE                 
MFA-TR*          AND IC_NO                 = :VC-IC-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7430                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7430'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTL_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7440-ELEC-METER-INFO                                        *        
      *        GETS ELECTRIC METER INFORMATION                         *        
      ******************************************************************        
       7440-ELEC-METER-INFO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT EM.METER_SIZE_ID,                                  
                     EM.NO_WIRES,                                       
                     EM.VOLTAGE,                                        
                     EM.ELEC_MTR_CLASS_CD,                              
                     EM.ELEC_MTR_SPEC_CD,                               
                     EM.MTR_CONNECT_TYP_ID,                             
                     EQUIP_MAKE_DESC                                    
                INTO :S-METER-SIZE-ID,                                  
                     :S-NO-WIRES,                                       
                     :S-VOLTAGE,                                        
                     :EM-ELEC-MTR-CLASS-CD,                             
                     :EM-ELEC-MTR-SPEC-CD,                              
                     :S-MTR-CONNECT-TYPE-ID,                            
                     :S-CODE-MAKE                                       
                FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED),                   
                     CSS_EQUIPMENT  EQ WITH(READUNCOMMITTED),                   
                     CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                    
               WHERE EM.CODE_UTIL_TYPE     = :VC-CODE-UTIL-TYPE         
                 AND EM.COMPANY_NO         = :VO-COMPANY-NO             
                 AND EM.COMPANY_NO         = EQ.COMPANY_NO              
                 AND EM.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE          
                 AND EM.METER_NO           = :VC-METER-NO               
                 AND EM.METER_NO           = EQ.DEVICE_NO               
                 AND EQ.CODE_MAKE          = M2.CODE_MAKE               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.METER_SIZE_ID,                                          
MFA-TR*              EM.NO_WIRES,                                               
MFA-TR*              EM.VOLTAGE,                                                
MFA-TR*              EM.ELEC_MTR_CLASS_CD,                                      
MFA-TR*              EM.ELEC_MTR_SPEC_CD,                                       
MFA-TR*              EM.MTR_CONNECT_TYP_ID,                                     
MFA-TR*              EQUIP_MAKE_DESC                                            
MFA-TR*         INTO :S-METER-SIZE-ID,                                          
MFA-TR*              :S-NO-WIRES,                                               
MFA-TR*              :S-VOLTAGE,                                                
MFA-TR*              :EM-ELEC-MTR-CLASS-CD,                                     
MFA-TR*              :EM-ELEC-MTR-SPEC-CD,                                      
MFA-TR*              :S-MTR-CONNECT-TYPE-ID,                                    
MFA-TR*              :S-CODE-MAKE                                               
MFA-TR*         FROM CSS_ELEC_METER EM,                                         
MFA-TR*              CSS_EQUIPMENT  EQ,                                         
MFA-TR*              CSS_EQUIP_MAKE M2                                          
MFA-TR*        WHERE EM.CODE_UTIL_TYPE     = :VC-CODE-UTIL-TYPE                 
MFA-TR*          AND EM.COMPANY_NO         = :VO-COMPANY-NO                     
MFA-TR*          AND EM.COMPANY_NO         = EQ.COMPANY_NO                      
MFA-TR*          AND EM.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE                  
MFA-TR*          AND EM.METER_NO           = :VC-METER-NO                       
MFA-TR*          AND EM.METER_NO           = EQ.DEVICE_NO                       
MFA-TR*          AND EQ.CODE_MAKE          = M2.CODE_MAKE                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7440                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE               EM-ELEC-MTR-CLASS-CD        
                                            EM-ELEC-MTR-SPEC-CD         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7440'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ELEC_METER'    TO TABLE-1                  
                   MOVE 'METER_NO'          TO TABLE-ELEMENT-1          
                   MOVE VC-METER-NO         TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7450-MTR-CL-AMPS-INFO                                       *        
      *        GETS ELECTRIC METER AMP INFORMATION                     *        
      ******************************************************************        
       7450-MTR-CL-AMPS-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CLASS_AMPS,                                        
                     ELEC_MTR_FORM_CD                                   
                INTO :S-AMPS,                                           
                     :S-ELEC-MTR-FORM-CD                                
                FROM CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                     
               WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD         
                 AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CLASS_AMPS,                                                
MFA-TR*              ELEC_MTR_FORM_CD                                           
MFA-TR*         INTO :S-AMPS,                                                   
MFA-TR*              :S-ELEC-MTR-FORM-CD                                        
MFA-TR*         FROM CSS_ELEC_CL_SPEC                                           
MFA-TR*        WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD                 
MFA-TR*          AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7450                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7450'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ELEC_CL_SPEC'  TO TABLE-1                  
                   MOVE 'CLASS_CD'          TO TABLE-ELEMENT-1          
                   MOVE 'SPEC_CD'           TO TABLE-ELEMENT-2          
                   MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-1       
                   MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7460-GAS-METER-INFO                                         *        
      *        GETS GAS METER INFORMATION                              *        
      ******************************************************************        
       7460-GAS-METER-INFO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GM.METER_SIZE_ID,                                  
                     GM.CASE_PRESSURE,                                  
                     GM.CONNECTION_TYPE_CD,                             
                     GM.NUMBER_OF_DRIVE,                                
                     EQUIP_MAKE_DESC                                    
                INTO :S-METER-SIZE-ID,                                  
                     :GM-CASE-PRESSURE,                                 
                     :S-MTR-CONNECT-TYPE-ID,                            
                     :S-NUMBER-OF-DRIVE,                                
                     :S-CODE-MAKE                                       
                FROM CSS_GAS_METER GM WITH(READUNCOMMITTED),                    
                     CSS_EQUIPMENT EQ WITH(READUNCOMMITTED),                    
                     CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                    
               WHERE GM.CODE_UTIL_TYPE  = :VC-CODE-UTIL-TYPE            
                 AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE             
                 AND GM.COMPANY_NO      = :VO-COMPANY-NO                
                 AND GM.COMPANY_NO      = EQ.COMPANY_NO                 
                 AND METER_NO           = :VC-METER-NO                  
                 AND GM.METER_NO        = EQ.DEVICE_NO                  
                 AND EQ.CODE_MAKE       = M2.CODE_MAKE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GM.METER_SIZE_ID,                                          
MFA-TR*              GM.CASE_PRESSURE,                                          
MFA-TR*              GM.CONNECTION_TYPE_CD,                                     
MFA-TR*              GM.NUMBER_OF_DRIVE,                                        
MFA-TR*              EQUIP_MAKE_DESC                                            
MFA-TR*         INTO :S-METER-SIZE-ID,                                          
MFA-TR*              :GM-CASE-PRESSURE,                                         
MFA-TR*              :S-MTR-CONNECT-TYPE-ID,                                    
MFA-TR*              :S-NUMBER-OF-DRIVE,                                        
MFA-TR*              :S-CODE-MAKE                                               
MFA-TR*         FROM CSS_GAS_METER GM,                                          
MFA-TR*              CSS_EQUIPMENT EQ,                                          
MFA-TR*              CSS_EQUIP_MAKE M2                                          
MFA-TR*        WHERE GM.CODE_UTIL_TYPE  = :VC-CODE-UTIL-TYPE                    
MFA-TR*          AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE                     
MFA-TR*          AND GM.COMPANY_NO      = :VO-COMPANY-NO                        
MFA-TR*          AND GM.COMPANY_NO      = EQ.COMPANY_NO                         
MFA-TR*          AND METER_NO           = :VC-METER-NO                          
MFA-TR*          AND GM.METER_NO        = EQ.DEVICE_NO                          
MFA-TR*          AND EQ.CODE_MAKE       = M2.CODE_MAKE                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7460                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7460'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_GAS_METER'     TO TABLE-1                  
                   MOVE 'METER_NO'          TO TABLE-ELEMENT-1          
                   MOVE VC-METER-NO         TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7470-GET-LONG-DESC.                                         *        
      *        GETS CODE DESCRIPTIONS                                  *        
      ******************************************************************        
       7470-GET-LONG-DESC.                                              
                                                                        
           EXEC SQL                                                     
              SELECT CODE_LONG_DESC                                     
                INTO :UV-CODE-LONG-DESC                                 
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO    = :UV-COMPANY-NO                     
                 AND TABLE_NA      = :UV-TABLE-NA                       
                 AND COLUMN_NA     = :UV-COLUMN-NA                      
                 AND CODE_VALUE    = :UV-CODE-VALUE                     
                 AND PROGRAM_ID    = 'ALL'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_LONG_DESC                                             
MFA-TR*         INTO :UV-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COMPANY_NO    = :UV-COMPANY-NO                             
MFA-TR*          AND TABLE_NA      = :UV-TABLE-NA                               
MFA-TR*          AND COLUMN_NA     = :UV-COLUMN-NA                              
MFA-TR*          AND CODE_VALUE    = :UV-CODE-VALUE                             
MFA-TR*          AND PROGRAM_ID    = 'ALL'                                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7470                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7470'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CODE_VALUE'    TO TABLE-1                  
                   MOVE 'CODE_VALUE'        TO TABLE-ELEMENT-1          
                   MOVE UV-CODE-VALUE       TO HOSTVAR-ELEMENT-1        
                   MOVE 'COLUMN_NA'         TO TABLE-ELEMENT-2          
                   MOVE UV-COLUMN-NA        TO HOSTVAR-ELEMENT-2        
                   MOVE 'TABLE_NA'          TO TABLE-ELEMENT-3          
                   MOVE UV-TABLE-NA         TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7480-GET-DEST-NO                                            *        
      *        GETS THE DESTINATION FORMATION                          *        
      ******************************************************************        
       7480-GET-DEST-NO.                                                
                                                                        
           EXEC SQL                                                     
              SELECT MTR_STORAGE_FAC_TX                                 
                INTO :S-DEST-NO                                         
                FROM CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO         = :VO-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :VC-CODE-UTIL-TYPE            
                 AND MTR_STORAGE_FAC_CD = :VC-DEST-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_STORAGE_FAC_TX                                         
MFA-TR*         INTO :S-DEST-NO                                                 
MFA-TR*         FROM CSS_MTR_STORGE_FAC                                         
MFA-TR*        WHERE COMPANY_NO         = :VO-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :VC-CODE-UTIL-TYPE                    
MFA-TR*          AND MTR_STORAGE_FAC_CD = :VC-DEST-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7480                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7480'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTR_STORGE_FAC' TO TABLE-1                 
                   MOVE 'DEST_NO'           TO TABLE-ELEMENT-1          
                   MOVE VC-DEST-NO          TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE VC-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-3          
                   MOVE VO-COMPANY-NO       TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7490-CHK-UTILITY                                            *        
      *        GETS THE UTILITY INFORMATION                            *        
      ******************************************************************        
       7490-CHK-UTILITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VI.METER_SUPPLYING,
              VI.CODE_UTIL_TYPE,
              VI.METER_NO,
              VI.IC_NO,
              VI.MTR_REF_NO,
              SO_INST_SEQ_NO,
              VI.WORK_TYPE_CD,
              WORK_TYPE_DESC,
              METER_LOC_DESC,
              RLSE_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE, 121), ' ', 
           '-'), ':', '.') RLSE_DATE,
              CODE_REVENUE_CLASS,
              RATE_PLAN_NO,
              READ_CYCLE,
              VT.READ_ROUTE                                     
                 INTO :S-METER-SUPPLYING,                               
                      :VI-CODE-UTIL-TYPE,                               
                      :S-METER-NO-4,                                    
                      :VI-IC-NO,                                        
                      :S-MTR-REF-NO-4,                                  
                      :S-SO-INST-SEQ-NO-4,                              
                      :S-WORK-TYPE-CD-4,                                
                      :S-WORK-TYPE-DESC-4,                              
                      :S-CODE-METER-LOC,                                
                      :S-RLSE-NO,                                       
                      :S-RLSE-DATE :WS-NULL-13,                          
                      :S-CODE-REVENUE-CLASS,                            
                      :S-RATE-PLAN-NO,                                  
                      :S-READ-CYCLE,                                    
                      :S-READ-ROUTE                                     
                 FROM CSS_SO_UTILITY VT WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_METER_LOC Q4 WITH(READUNCOMMITTED),                   
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)                    
                WHERE VT.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VT.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VT.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VT.IC_NO          = VI.IC_NO                      
                  AND VT.CODE_UTIL_TYPE = :VM-CODE-UTIL-TYPE            
                  AND VT.IC_NO          = :VM-IC-NO                     
                  AND VI.MTR_REF_NO     = :VM-MTR-REF-NO                
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                  AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC             
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VI.METER_SUPPLYING,                                       
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               VI.IC_NO,                                                 
MFA-TR*               VI.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               READ_CYCLE,                                               
MFA-TR*               VT.READ_ROUTE                                             
MFA-TR*          INTO :S-METER-SUPPLYING,                                       
MFA-TR*               :VI-CODE-UTIL-TYPE,                                       
MFA-TR*               :S-METER-NO-4,                                            
MFA-TR*               :VI-IC-NO,                                                
MFA-TR*               :S-MTR-REF-NO-4,                                          
MFA-TR*               :S-SO-INST-SEQ-NO-4,                                      
MFA-TR*               :S-WORK-TYPE-CD-4,                                        
MFA-TR*               :S-WORK-TYPE-DESC-4,                                      
MFA-TR*               :S-CODE-METER-LOC,                                        
MFA-TR*               :S-RLSE-NO,                                               
MFA-TR*               :S-RLSE-DATE:WS-NULL-13,                                  
MFA-TR*               :S-CODE-REVENUE-CLASS,                                    
MFA-TR*               :S-RATE-PLAN-NO,                                          
MFA-TR*               :S-READ-CYCLE,                                            
MFA-TR*               :S-READ-ROUTE                                             
MFA-TR*          FROM CSS_SO_UTILITY VT,                                        
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_METER_LOC Q4,                                         
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VT.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VT.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VT.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VT.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VT.CODE_UTIL_TYPE = :VM-CODE-UTIL-TYPE                    
MFA-TR*           AND VT.IC_NO          = :VM-IC-NO                             
MFA-TR*           AND VI.MTR_REF_NO     = :VM-MTR-REF-NO                        
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7490                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7490'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTILITY'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE VM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   MOVE 'IC_NO'             TO TABLE-ELEMENT-3          
                   MOVE VM-IC-NO            TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7490-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7495-GET-UTILITY                                            *        
      *        GETS THE UTILITY INFORMATION                            *        
      ******************************************************************        
       7495-GET-UTILITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_REVENUE_CLASS,
              RATE_PLAN_NO                                      
                 INTO :VT-CODE-REVENUE-CLASS,                           
                      :VT-RATE-PLAN-NO                                  
                 FROM CSS_SO_UTILITY VT WITH(READUNCOMMITTED),                  
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VT.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VT.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VT.IC_NO          = VI.IC_NO                      
                  AND VT.CODE_UTIL_TYPE = :WK-CODE-UTIL-TYPE            
                  AND VT.IC_NO          = :WK-IC-NO                     
                  AND VI.MTR_REF_NO     = :WK-MTR-REF-NO                
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_REVENUE_CLASS,                                       
MFA-TR*               RATE_PLAN_NO                                              
MFA-TR*          INTO :VT-CODE-REVENUE-CLASS,                                   
MFA-TR*               :VT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_SO_UTILITY VT,                                        
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VT.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VT.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VT.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VT.CODE_UTIL_TYPE = :WK-CODE-UTIL-TYPE                    
MFA-TR*           AND VT.IC_NO          = :WK-IC-NO                             
MFA-TR*           AND VI.MTR_REF_NO     = :WK-MTR-REF-NO                        
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7495                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7495'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTILITY'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE WK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   MOVE 'IC_NO'             TO TABLE-ELEMENT-3          
                   MOVE WK-IC-NO            TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7495-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7491-CHK-UTL-CHG                                            *        
      *        GETS THE UTILITY CHANGE INFORMATION                     *        
      ******************************************************************        
       7491-CHK-UTL-CHG.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VI.METER_SUPPLYING,
              VI.CODE_UTIL_TYPE,
              VI.METER_NO,
              VI.IC_NO,
              VI.MTR_REF_NO,
              SO_INST_SEQ_NO,
              VI.WORK_TYPE_CD,
              WORK_TYPE_DESC,
              METER_LOC_DESC,
              RLSE_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), RLSE_DATE, 121), ' ', 
           '-'), ':', '.') RLSE_DATE,
              CODE_REVENUE_CLASS,
              RATE_PLAN_NO,
              READ_CYCLE,
              VE.READ_ROUTE                                     
                 INTO :S-METER-SUPPLYING,                               
                      :VE-CODE-UTIL-TYPE,                               
                      :S-METER-NO-4,                                    
                      :VE-IC-NO,                                        
                      :S-MTR-REF-NO-4,                                  
                      :S-SO-INST-SEQ-NO-4,                              
                      :S-WORK-TYPE-CD-4,                                
                      :S-WORK-TYPE-DESC-4,                              
                      :S-CODE-METER-LOC,                                
                      :S-RLSE-NO,                                       
                      :S-RLSE-DATE :WS-NULL-13,                          
                      :S-CODE-REVENUE-CLASS,                            
                      :S-RATE-PLAN-NO,                                  
                      :S-READ-CYCLE,                                    
                      :S-READ-ROUTE                                     
                 FROM CSS_SO_UTL_CHG VE,                                
                      CSS_SO_ORDER_INST VI,                             
                      CSS_METER_LOC Q4,                                 
                      CSS_SO_DATA VO,                                   
                      CSS_WORK_TYPE L4                                  
                WHERE VE.SERV_ORDER_NO  = :VI-SERV-ORDER-NO             
                  AND VE.SERV_ORDER_NO  = VI.SERV_ORDER_NO              
                  AND VE.SERV_ORDER_NO  = VO.SERV_ORDER_NO              
                  AND VE.IC_NO          = VI.IC_NO                      
                  AND VE.IC_NO          = :VM-IC-NO                     
                  AND VE.CODE_UTIL_TYPE = :VM-CODE-UTIL-TYPE            
                  AND VI.MTR_REF_NO     = :VM-MTR-REF-NO                
                  AND VI.WORK_TYPE_CD   > ' '                           
                  AND VI.WORK_TYPE_CD   <> 'FIN'                        
                  AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC             
                  AND VO.COMPANY_NO     = L4.COMPANY_NO                 
                  AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD               
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VI.METER_SUPPLYING,                                       
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VI.METER_NO,                                              
MFA-TR*               VI.IC_NO,                                                 
MFA-TR*               VI.MTR_REF_NO,                                            
MFA-TR*               SO_INST_SEQ_NO,                                           
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               WORK_TYPE_DESC,                                           
MFA-TR*               METER_LOC_DESC,                                           
MFA-TR*               RLSE_NO,                                                  
MFA-TR*               RLSE_DATE,                                                
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               READ_CYCLE,                                               
MFA-TR*               VE.READ_ROUTE                                             
MFA-TR*          INTO :S-METER-SUPPLYING,                                       
MFA-TR*               :VE-CODE-UTIL-TYPE,                                       
MFA-TR*               :S-METER-NO-4,                                            
MFA-TR*               :VE-IC-NO,                                                
MFA-TR*               :S-MTR-REF-NO-4,                                          
MFA-TR*               :S-SO-INST-SEQ-NO-4,                                      
MFA-TR*               :S-WORK-TYPE-CD-4,                                        
MFA-TR*               :S-WORK-TYPE-DESC-4,                                      
MFA-TR*               :S-CODE-METER-LOC,                                        
MFA-TR*               :S-RLSE-NO,                                               
MFA-TR*               :S-RLSE-DATE:WS-NULL-13,                                  
MFA-TR*               :S-CODE-REVENUE-CLASS,                                    
MFA-TR*               :S-RATE-PLAN-NO,                                          
MFA-TR*               :S-READ-CYCLE,                                            
MFA-TR*               :S-READ-ROUTE                                             
MFA-TR*          FROM CSS_SO_UTL_CHG VE,                                        
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_METER_LOC Q4,                                         
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_WORK_TYPE L4                                          
MFA-TR*         WHERE VE.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                     
MFA-TR*           AND VE.SERV_ORDER_NO  = VI.SERV_ORDER_NO                      
MFA-TR*           AND VE.SERV_ORDER_NO  = VO.SERV_ORDER_NO                      
MFA-TR*           AND VE.IC_NO          = VI.IC_NO                              
MFA-TR*           AND VE.IC_NO          = :VM-IC-NO                             
MFA-TR*           AND VE.CODE_UTIL_TYPE = :VM-CODE-UTIL-TYPE                    
MFA-TR*           AND VI.MTR_REF_NO     = :VM-MTR-REF-NO                        
MFA-TR*           AND VI.WORK_TYPE_CD   > ' '                                   
MFA-TR*           AND VI.WORK_TYPE_CD   <> 'FIN'                                
MFA-TR*           AND VI.CODE_METER_LOC = Q4.CODE_METER_LOC                     
MFA-TR*           AND VO.COMPANY_NO     = L4.COMPANY_NO                         
MFA-TR*           AND VI.WORK_TYPE_CD   = L4.WORK_TYPE_CD                       
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*        QUERYNO 7491                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7491'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTL_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE VM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   MOVE 'IC_NO'             TO TABLE-ELEMENT-3          
                   MOVE VM-IC-NO            TO HOSTVAR-ELEMENT-3        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7491-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7510-GET-MTR-INFO                                           *        
      *        GETS METER INFORMATION                                  *        
      ******************************************************************        
       7510-GET-MTR-INFO.                                               
                                                                        
           EXEC SQL                                                     
              SELECT REMOTE_READ_IND,                                   
                     DIGTL_MTR_TYPE,                                    
                     PROGRAM_ID,                                        
                     MTR_READ_SOURCE_CD,                                
                     CODE_USAGE_TYPE                                    
                INTO :MN-REMOTE-READ-IND :WS-NULL-12,                    
                     :MN-DIGTL-MTR-TYPE,                                
                     :MN-PROGRAM-ID,                                    
                     :MN-MTR-READ-SOURCE-CD,                            
                     :MN-CODE-USAGE-TYPE                                
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :WS-ACCOUNT                       
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
                 AND IC_NO          = :MN-IC-NO                         
                 AND MTR_REF_NO     = :MN-MTR-REF-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REMOTE_READ_IND,                                           
MFA-TR*              DIGTL_MTR_TYPE,                                            
MFA-TR*              PROGRAM_ID,                                                
MFA-TR*              MTR_READ_SOURCE_CD,                                        
MFA-TR*              CODE_USAGE_TYPE                                            
MFA-TR*         INTO :MN-REMOTE-READ-IND:WS-NULL-12,                            
MFA-TR*              :MN-DIGTL-MTR-TYPE,                                        
MFA-TR*              :MN-PROGRAM-ID,                                            
MFA-TR*              :MN-MTR-READ-SOURCE-CD,                                    
MFA-TR*              :MN-CODE-USAGE-TYPE                                        
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :WS-ACCOUNT                               
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*          AND IC_NO          = :MN-IC-NO                                 
MFA-TR*          AND MTR_REF_NO     = :MN-MTR-REF-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-12 < 0                                    
                      MOVE SPACES           TO MN-REMOTE-READ-IND       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE                  MN-POINT-ID              
                                               MN-GIS-POINT-ID          
                                               MN-MIN-NO-UNITS          
                                               MN-MAX-NO-UNITS          
                                               MN-REMOTE-READ-IND       
                                               MN-DIGTL-MTR-TYPE        
                                               MN-PROGRAM-ID            
                                               MN-CODE-USAGE-TYPE       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7510'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE WS-ACCOUNT          TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7520-GET-MTR-RD-FMT                                         *        
      *        GETS METER READ INFORMATION                             *        
      ******************************************************************        
       7520-GET-MTR-RD-FMT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MTR_RD_DISP_CD,
              INDEX_VALUE_CD,
              READ_SEQUENCE_NO,
              NO_READ_DIGITS,
              NO_READ_DECIMALS                                   
                INTO :OA-MTR-RD-DISP-CD,                                
                     :OA-INDEX-VALUE-CD,                                
                     :OA-READ-SEQUENCE-NO,                              
                     :OA-NO-READ-DIGITS,                                
                     :OA-NO-READ-DECIMALS                               
                FROM CSS_MTR_RD_FMT WITH(READUNCOMMITTED)                       
               WHERE CODE_UTIL_TYPE     = :OA-CODE-UTIL-TYPE            
                 AND DIGTL_MTR_TYPE     = :MN-DIGTL-MTR-TYPE            
                 AND PROGRAM_ID         = :MN-PROGRAM-ID                
                 AND MTR_READ_SOURCE_CD = :MN-MTR-READ-SOURCE-CD        
      *          AND MTR_RD_RECORD_CD   = :OA-MTR-RD-RECORD-CD                  
                 AND REMOTE_READ_IND    = :MN-REMOTE-READ-IND           
                 AND CODE_USAGE_TYPE    = :OA-CODE-USAGE-TYPE           
                 AND CODE_TIME_PERIOD   = :OA-CODE-TIME-PERIOD          
      *          AND CODE_TOU_SEASN     = :OA-CODE-TOU-SEASN                    
                 AND CNSMPTN_READ_FL    = 'Y'                           
                 AND SO_REGISTER_CD     <> 'I'                          
                 AND CODE_TOU_SEASN     = 'C'                           
                 AND REG_ID_NO          = :OA-REG-ID-NO                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_RD_DISP_CD,                                            
MFA-TR*              INDEX_VALUE_CD,                                            
MFA-TR*              READ_SEQUENCE_NO,                                          
MFA-TR*              NO_READ_DIGITS,                                            
MFA-TR*              NO_READ_DECIMALS                                           
MFA-TR*         INTO :OA-MTR-RD-DISP-CD,                                        
MFA-TR*              :OA-INDEX-VALUE-CD,                                        
MFA-TR*              :OA-READ-SEQUENCE-NO,                                      
MFA-TR*              :OA-NO-READ-DIGITS,                                        
MFA-TR*              :OA-NO-READ-DECIMALS                                       
MFA-TR*         FROM CSS_MTR_RD_FMT                                             
MFA-TR*        WHERE CODE_UTIL_TYPE     = :OA-CODE-UTIL-TYPE                    
MFA-TR*          AND DIGTL_MTR_TYPE     = :MN-DIGTL-MTR-TYPE                    
MFA-TR*          AND PROGRAM_ID         = :MN-PROGRAM-ID                        
MFA-TR*          AND MTR_READ_SOURCE_CD = :MN-MTR-READ-SOURCE-CD                
MFA-TR*          AND MTR_RD_RECORD_CD   = :OA-MTR-RD-RECORD-CD                  
MFA-TR*          AND REMOTE_READ_IND    = :MN-REMOTE-READ-IND                   
MFA-TR*          AND CODE_USAGE_TYPE    = :OA-CODE-USAGE-TYPE                   
MFA-TR*          AND CODE_TIME_PERIOD   = :OA-CODE-TIME-PERIOD                  
MFA-TR*          AND CODE_TOU_SEASN     = :OA-CODE-TOU-SEASN                    
MFA-TR*          AND CNSMPTN_READ_FL    = 'Y'                                   
MFA-TR*          AND SO_REGISTER_CD     <> 'I'                                  
MFA-TR*          AND CODE_TOU_SEASN     = 'C'                                   
MFA-TR*          AND REG_ID_NO          = :OA-REG-ID-NO                         
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE                  OA-MTR-RD-DISP-CD        
                                               OA-INDEX-VALUE-CD        
                                               OA-READ-SEQUENCE-NO      
                                               OA-NO-READ-DIGITS        
                                               OA-NO-READ-DECIMALS      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7520'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTR_RD_FMT'    TO TABLE-1                  
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1          
                   MOVE VK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_TIME_PERIOD'  TO TABLE-ELEMENT-1          
                   MOVE VK-CODE-TIME-PERIOD TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7710-GET-CREDIT-PROFILE                                        *        
      *      GETS CREDIT HISTORY DETAILS                               *        
      ******************************************************************        
       7710-GET-CREDIT-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT CASH_ONLY_FL,                                      
                     DISCONNECT_HIST,                                   
                     ARREARS_HIST,                                      
                     DISC_EXCEPTN_HIST                                  
                INTO :S-DNP-CASH,                                       
                     :CZ-DISCONNECT-HIST,                               
                     :S-DNP-ARREARS-HISTORY,                            
                     :CZ-DISC-EXCEPTN-HIST                              
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_ONLY_FL,                                              
MFA-TR*              DISCONNECT_HIST,                                           
MFA-TR*              ARREARS_HIST,                                              
MFA-TR*              DISC_EXCEPTN_HIST                                          
MFA-TR*         INTO :S-DNP-CASH,                                               
MFA-TR*              :CZ-DISCONNECT-HIST,                                       
MFA-TR*              :S-DNP-ARREARS-HISTORY,                                    
MFA-TR*              :CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                                
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF S-DNP-CASH = 'Y'                                  
                      CONTINUE                                          
                   ELSE                                                 
                      MOVE 'N'                TO S-DNP-CASH             
                   END-IF                                               
                   MOVE CZ-DISCONNECT-HIST    TO S-DNP-CREDIT-HISTORY   
                   MOVE CZ-DISC-EXCEPTN-HIST  TO S-DNP-EXCEPT-HISTORY   
               WHEN NOT-FOUND                                           
                   MOVE 'N'                   TO S-DNP-CASH             
                   MOVE SPACES                TO CZ-DISCONNECT-HIST     
                                                 CZ-DISC-EXCEPTN-HIST   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7710'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7720-GET-CRED-COLL                                             *        
      *     GETS CREDIT COLLECTION DETAILS                             *        
      ******************************************************************        
       7720-GET-CRED-COLL.                                              
                                                                        
           EVALUATE VO-ORDER-REASON                                     
              WHEN 'N'                                                  
              WHEN 'O'                                                  
              WHEN 'J'                                                  
              WHEN 'K'                                                  
              WHEN 'U'                                                  
              WHEN 'V'                                                  
                 MOVE 'C' TO CL-CODE-NOTICE-TYPE                        
              WHEN 'H'                                                  
                 MOVE 'N' TO CL-CODE-NOTICE-TYPE                        
              WHEN 'I'                                                  
                 MOVE 'O' TO CL-CODE-NOTICE-TYPE                        
              WHEN 'X'                                                  
                 MOVE  SPACES TO S-DNP-2ND-NOTICE-DATE                  
                 GO TO  7720-EXIT                                       
              WHEN OTHER                                                
                 MOVE 'F' TO CL-CODE-NOTICE-TYPE                        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DATE_NOTICE_MAIL                                   
                INTO :S-DNP-2ND-NOTICE-DATE :WS-NULL-15                  
                FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO                
                 AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE          
                 AND ITEM_ID            = 0                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_NOTICE_MAIL                                           
MFA-TR*         INTO :S-DNP-2ND-NOTICE-DATE:WS-NULL-15                          
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO                        
MFA-TR*          AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE                  
MFA-TR*          AND ITEM_ID            = 0                                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7720                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-15 < 0                                    
                      MOVE SPACES             TO S-DNP-2ND-NOTICE-DATE  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7720'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CRED_COLL'       TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2        
                   MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7730-GET-DEP-ON-HAND                                           *        
      *     GETS DEPOSIT DETAILS                                       *        
      ******************************************************************        
       7730-GET-DEP-ON-HAND.                                            
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :DO-AMT-DEPOSIT :WS-NULL-16                         
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO       = :VO-ACCOUNT-NO                  
                 AND CODE_REFUND_TYPE = ' '                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*         INTO :DO-AMT-DEPOSIT:WS-NULL-16                                 
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO       = :VO-ACCOUNT-NO                          
MFA-TR*          AND CODE_REFUND_TYPE = ' '                                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7730                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-16 < 0                                    
                      MOVE 0                  TO DO-AMT-DEPOSIT         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE                 DO-AMT-DEPOSIT            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7730'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7740-GET-GUARANTOR                                             *        
      *     GETS GUARANTOR INFO                                        *        
      ******************************************************************        
       7740-GET-GUARANTOR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMOUNT_GUARANTEED)                             
                INTO :GU-AMOUNT-GUARANTEED :WS-NULL-17                   
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                    
                 AND GUAR_STATUS_CD = 'A'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMOUNT_GUARANTEED)                                     
MFA-TR*         INTO :GU-AMOUNT-GUARANTEED:WS-NULL-17                           
MFA-TR*         FROM CSS_GUARANTOR                                              
MFA-TR*        WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                            
MFA-TR*          AND GUAR_STATUS_CD = 'A'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7740                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-17 < 0                                    
                      MOVE 0                     TO GU-AMOUNT-GUARANTEED
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE                    GU-AMOUNT-GUARANTEED   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7740'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE 'CSS_GUARANTOR'          TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE VO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7750-GET-SURETY-BONDS                                          *        
      *     GETS SURETY BONDS DETAILS                                  *        
      ******************************************************************        
       7750-GET-SURETY-BONDS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_BOND)                                      
                INTO :SB-AMT-BOND :WS-NULL-18                            
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                    
                 AND (CODE_STATUS   = 'A'                               
                  OR CODE_BOND_TYPE = 'B'  )                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BOND)                                              
MFA-TR*         INTO :SB-AMT-BOND:WS-NULL-18                                    
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                            
MFA-TR*          AND (CODE_STATUS   = 'A'                                       
MFA-TR*           OR CODE_BOND_TYPE = 'B'  )                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7750                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-18 < 0                                   
                       MOVE 0                  TO SB-AMT-BOND           
                    END-IF                                              
                WHEN NOT-FOUND                                          
                    MOVE ZEROES                TO SB-AMT-BOND           
                WHEN OTHER                                              
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7750'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE 'CSS_SURETY_BOND'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7760-GET-CRIT-CUSTOMER                                         *        
      *     GETS CRITICAL CUSTOMER INFO                                *        
      ******************************************************************        
       7760-GET-CRIT-CUSTOMER.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-DNP-CRITICAL-CUS-7                              
                FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED),                  
                     CSS_CRIT_OUTAGE Q2 WITH(READUNCOMMITTED)                   
               WHERE AT.ACCOUNT_NO       = :VO-ACCOUNT-NO               
                 AND AT.CODE_CRIT_OUTAGE = Q2.CODE_CRIT_OUTAGE          
                 AND AT.COMPANY_NO       = Q2.COMPANY_NO                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-DNP-CRITICAL-CUS-7                                      
MFA-TR*         FROM CSS_ACCOUNT     AT,                                        
MFA-TR*              CSS_CRIT_OUTAGE Q2                                         
MFA-TR*        WHERE AT.ACCOUNT_NO       = :VO-ACCOUNT-NO                       
MFA-TR*          AND AT.CODE_CRIT_OUTAGE = Q2.CODE_CRIT_OUTAGE                  
MFA-TR*          AND AT.COMPANY_NO       = Q2.COMPANY_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7760                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N'                    TO S-DNP-CRITICAL-CUS-7  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
                   MOVE '7760'                  TO ACTIVE-PARAGRAPH     
                   MOVE 'SELECT'                TO ABEND-FUNCTION       
                   MOVE 'CSS_ACCOUNT'           TO TABLE-1              
                   MOVE 'CSS_CRIT_OUTAGE'       TO TABLE-2              
                   MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1      
                   MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                   PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7770-GET-ACCOUNT-TABLE                                         *        
      *     GETS ACCOUNT INFORMATION                                   *        
      **********************************************************************    
       7770-GET-ACCOUNT-TABLE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT BANKRUPTCY_IND,                                    
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     NOTICE_EXEMPT_CD,                                  
                     CODE_DISC_OK,                                      
                     CODES_DATA_PRESENT,                                
                     CAST(ACCT_CREATE_DT AS DATE),                              
                     CREDIT_GROUP,                                      
                     CUSTOMER_NO,                                       
                     CODE_ACCT_STAT,                                    
                     IVR_EXEMPT_CD,                                     
                     CODE_ACCT_STAT,                                    
                     ACCOUNT_TYPE_CODE,                                 
                     ACCOUNT_NO,                                        
                     CODE_STATUS_REASON                                 
                INTO :AT-BANKRUPTCY-IND,                                
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-19,                   
                     :AT-DATE-BILL-DAY-30 :WS-NULL-20,                   
                     :AT-DATE-BILL-DAY-60 :WS-NULL-21,                   
                     :AT-DATE-BILL-DAY-90 :WS-NULL-22,                   
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-CODE-DISC-OK,                                  
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-ACCT-CREATE-DT :WS-NULL-23,                     
                     :AT-CREDIT-GROUP,                                  
                     :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-IVR-EXEMPT-CD,                                 
                     :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-ACCOUNT-NO,                                    
                     :AT-CODE-STATUS-REASON                             
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BANKRUPTCY_IND,                                            
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              NOTICE_EXEMPT_CD,                                          
MFA-TR*              CODE_DISC_OK,                                              
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              DATE(ACCT_CREATE_DT),                                      
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              IVR_EXEMPT_CD,                                             
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CODE_STATUS_REASON                                         
MFA-TR*         INTO :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-19,                           
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-NULL-20,                           
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-NULL-21,                           
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-NULL-22,                           
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-ACCT-CREATE-DT:WS-NULL-23,                             
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-ACCOUNT-NO,                                            
MFA-TR*              :AT-CODE-STATUS-REASON                                     
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO         = :VO-ACCOUNT-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7770                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE AT-BANKRUPTCY-IND      TO S-DNP-BANKRUPT             
              IF AT-BANKRUPTCY-IND = ' '                                
                 MOVE WS-NO               TO S-DNP-BANKRUPT             
              END-IF                                                    
              MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER-NO             
              MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT      
              MOVE AT-CREDIT-GROUP        TO S-DNP-CREDIT-GROUP         
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'Y'                 TO S-DNP-INDICATOR            
              ELSE                                                      
                 MOVE 'N'                 TO S-DNP-INDICATOR            
              END-IF                                                    
              IF WS-NULL-19 < 0 THEN                                    
                 MOVE SPACES              TO AT-DATE-BILL-DAY-00        
              END-IF                                                    
              IF WS-NULL-20 < 0 THEN                                    
                 MOVE SPACES              TO AT-DATE-BILL-DAY-30        
              END-IF                                                    
              IF WS-NULL-21 < 0 THEN                                    
                 MOVE SPACES              TO AT-DATE-BILL-DAY-60        
              END-IF                                                    
              IF WS-NULL-22 < 0 THEN                                    
                 MOVE SPACES              TO AT-DATE-BILL-DAY-90        
              END-IF                                                    
              IF WS-NULL-23 < 0 THEN                                    
                 MOVE SPACES              TO AT-ACCT-CREATE-DT          
              END-IF                                                    
              MOVE AT-ACCT-CREATE-DT      TO S-DNP-CUS-TURN-DATE        
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7770'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE VO-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7770-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7775-GET-ACCT-TYPE.                                            *        
      *     GETS THE ACCOUNT TYPE INFO                                 *        
      **********************************************************************    
       7775-GET-ACCT-TYPE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_SHORT_DESC                                    
                INTO :S-ACCT-TYPE                                       
                FROM CSS_SO_CODE_DESC WITH(READUNCOMMITTED)                     
               WHERE CODE_VALUE        = :AT-ACCOUNT-TYPE-CODE          
                 AND TABLE_NA          = 'CSS_ACCOUNT'                  
                 AND COLUMN_NA         = 'ACCOUNT_TYPE_CODE'            
                 AND PROGRAM_ID        = 'ALL'                          
                 AND COMPANY_NO        = '01'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*         INTO :S-ACCT-TYPE                                               
MFA-TR*         FROM CSS_SO_CODE_DESC                                           
MFA-TR*        WHERE CODE_VALUE        = :AT-ACCOUNT-TYPE-CODE                  
MFA-TR*          AND TABLE_NA          = 'CSS_ACCOUNT'                          
MFA-TR*          AND COLUMN_NA         = 'ACCOUNT_TYPE_CODE'                    
MFA-TR*          AND PROGRAM_ID        = 'ALL'                                  
MFA-TR*          AND COMPANY_NO        = '01'                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7775                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                       TO S-ACCT-TYPE       
              ELSE                                                      
                 MOVE PROGRAM-NAME                 TO ABEND-PROGRAM     
                 MOVE '7775'                       TO ACTIVE-PARAGRAPH  
                 MOVE 'SELECT'                     TO ABEND-FUNCTION    
                 MOVE 'CSS_SO_CODE_DESC'           TO TABLE-1           
                 MOVE 'ACCOUNT_TYPE_CODE'          TO TABLE-ELEMENT-1   
                 MOVE AT-ACCOUNT-TYPE-CODE         TO HOSTVAR-ELEMENT-1 
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7780-GET-CUST-MISC.                                            *        
      *     GETS MISCELLANEOUS CUSTOMER DETAILS                        *        
      **********************************************************************    
       7780-GET-CUST-MISC.                                              
                                                                        
           EXEC SQL                                                     
              SELECT KEY_CUSTOMER                                       
                INTO :S-DNP-KEY-CUS                                     
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KEY_CUSTOMER                                               
MFA-TR*         INTO :S-DNP-KEY-CUS                                             
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7780                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF S-DNP-KEY-CUS =  SPACES                                
                 MOVE WS-NO                        TO S-DNP-KEY-CUS     
              ELSE                                                      
                 MOVE WS-YES                       TO S-DNP-KEY-CUS     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                        TO S-DNP-KEY-CUS     
              ELSE                                                      
                 MOVE PROGRAM-NAME                 TO ABEND-PROGRAM     
                 MOVE '7780'                       TO ACTIVE-PARAGRAPH  
                 MOVE 'SELECT'                     TO ABEND-FUNCTION    
                 MOVE 'CSS_CUST_MISC_INFO'         TO TABLE-1           
                 MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1   
                 MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2   
                 MOVE AT-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1 
                 MOVE VO-ACCOUNT-NO                TO HOSTVAR-ELEMENT-2 
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7780-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7790-CALCULATE-ONE-YEAR-AGO                                    *        
      *   WORKS OUT THE DATE ONE YEAR AGO                              *        
      ******************************************************************        
       7790-CALCULATE-ONE-YEAR-AGO.                                     
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ONE-YEAR-AGO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ONE-YEAR-AGO = CURRENT DATE - 12 MONTH                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7790'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE VO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7790-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7795-GET-MULTI-REGISTER.                                       *        
      *     GETS MISCELLANEOUS CUSTOMER DETAILS                        *        
      **********************************************************************    
       7795-GET-MULTI-REGISTER.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MULTI-REGISTER                                 
                FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),                
                     CSS_SO_DATA       VO WITH(READUNCOMMITTED),                
                     CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
               WHERE VO.SERV_ORDER_NO     = :VI-SERV-ORDER-NO           
                 AND VO.ACCOUNT_NO_PRIOR  = RG.ACCOUNT_NO               
                 AND VO.SERV_ORDER_NO     = VI.SERV_ORDER_NO            
                 AND RG.CODE_UTIL_TYPE    = VI.CODE_UTIL_TYPE           
                 AND RG.METER_NO          = VI.METER_NO                 
                 AND RG.IC_NO             = VI.IC_NO                    
                 AND RG.MTR_REF_NO        = VI.MTR_REF_NO               
                 AND VI.WORK_TYPE_CD      > ' '                         
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULTI-REGISTER                                         
MFA-TR*         FROM CSS_REGISTER_READ RG,                                      
MFA-TR*              CSS_SO_DATA       VO,                                      
MFA-TR*              CSS_SO_ORDER_INST VI                                       
MFA-TR*        WHERE VO.SERV_ORDER_NO     = :VI-SERV-ORDER-NO                   
MFA-TR*          AND VO.ACCOUNT_NO_PRIOR  = RG.ACCOUNT_NO                       
MFA-TR*          AND VO.SERV_ORDER_NO     = VI.SERV_ORDER_NO                    
MFA-TR*          AND RG.CODE_UTIL_TYPE    = VI.CODE_UTIL_TYPE                   
MFA-TR*          AND RG.METER_NO          = VI.METER_NO                         
MFA-TR*          AND RG.IC_NO             = VI.IC_NO                            
MFA-TR*          AND RG.MTR_REF_NO        = VI.MTR_REF_NO                       
MFA-TR*          AND VI.WORK_TYPE_CD      > ' '                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7795                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-NO                        TO WS-MULTI-REGISTER 
              ELSE                                                      
                 MOVE PROGRAM-NAME                 TO ABEND-PROGRAM     
                 MOVE '7795'                       TO ACTIVE-PARAGRAPH  
                 MOVE 'SELECT'                     TO ABEND-FUNCTION    
                 MOVE 'CSS_REGISTER_READ'          TO TABLE-1           
                 MOVE 'SERV_ORDER_NO'              TO TABLE-ELEMENT-1   
                 MOVE VI-SERV-ORDER-NO             TO HOSTVAR-ELEMENT-1 
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7795-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7796-GET-SOLAR-COMPLIANCE-DAYS                              *        
      *        GETS DESCRIPTIONS FOR THE DIFFERENT CODE VALUES         *        
      ******************************************************************        
       7796-GET-SOLAR-COMPLIANCE-DAYS.                                  
                                                                        
           EXEC SQL                                                     
              SELECT IIF(TRY_CAST(C8.DELINQ_VALUE AS INT) IS NULL, 
              CIS.INTEGER(C8.DELINQ_VALUE), CAST(C8.DELINQ_VALUE
               AS INT)) DELINQ_VALUE                                    
                INTO :WS-COMP-DAYS                                      
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = 'SLR-COMPLIANCE-DAYS'              
                 AND C8.COMPANY_NO = '01'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :WS-COMP-DAYS                                              
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = 'SLR-COMPLIANCE-DAYS'                      
MFA-TR*          AND C8.COMPANY_NO = '01'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7796                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE S-COMPLIANCE-DAYS   TO WS-COMP-DAYS             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7796'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_DELINQUENCY'   TO TABLE-1                  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7796-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
       7100-OPEN-TASKS-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN TASKS-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7100'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7101-FETCH-TASKS-CURSOR.                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           EXEC SQL                                                     
               FETCH TASKS-CURSOR                                       
                INTO :VI-SERV-ORDER-NO,                                 
                     :S-SO-INST-SEQ-NO-1,                               
                     :VI-WORK-TYPE-CD,                                  
                     :S-WORK-TYPE-DESC-1,                               
                     :VI-CODE-UTIL-TYPE,                                
                     :VO-ORDER-PRIORITY-CD,                             
                     :S-SO-EST-LABOR-HR,                                
                     :VO-PREMISE-NO,                                    
                     :VO-COMPANY-NO,                                    
                     :S-LOCAL-OFFICE,                                   
                     :VO-ORDER-TYPE-CD,                                 
                     :VO-ACCOUNT-NO,                                    
                     :VO-ACCOUNT-NO-PRIOR,                              
                     :S-ORDER-PLACED-BY,                                
                     :VO-ORDER-REASON,                                  
                     :S-CALL-BEFORE-MINUTS,                             
                     :VO-PHONE-NO,                                      
                     :S-PHONE-NO-EXT,                                   
                     :VO-ALT-PHONE-NO,                                  
                     :S-ALT-PHONE-NO-EXT,                               
A05020*              :S-MADE-SAFE-DT:WS-NULL-14,                                
                     :VO-HOME-ALL-DAY-FL,                               
                     :VO-DATE-FORECAST-DNP,                             
                     :WS-MTR-ACCESSIBLE-CD,                             
                     :WS-MTR-ACCESSIBLE-DT :WS-NULL-11,                  
                     :WS-MTR-ACCESSIBLE-RSN,                            
                     :S-ASSIGNED-DATE,                                  
                     :VO-SO-BUSINESS-UNIT,                              
                     :VO-WORK-AREA-ID,                                  
                     :WS-DAY-OF-WEEK,                                   
                     :WS-ASSIGN-DATE,                                   
                     :VI-IC-NO,                                         
                     :VI-MTR-REF-NO,                                    
                     :WS-BEGIN-APPT-TIME :WS-NULL-26,                    
                     :WS-END-APPT-TIME :WS-NULL-27,                      
                     :S-OPTIMIZE-ORDER,                                 
                     :VO-ORDER-STATE-CD,                                
                     :S-RLSE-NO-1,                                      
                     :VI-TASK-STATUS-CD,                                
                     :VO-DATE-RECVED :WS-NULL-28,                        
A05020               :VO-LOCAL-OFFICE,                                  
A05020               :VO-APPT-AM-PM-CD,                                 
A05020               :VI-METER-NO,                                      
A05020               :VI-METER-SUPPLYING,                               
A05020               :VO-BEGIN-APPT-DT :WS-NULL-29,                      
P01176               :VI-SAMPLE-TEST-FL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-11 < 0                                    
                      MOVE SPACES            TO WS-MTR-ACCESSIBLE-DT    
                   END-IF                                               
A05020*            IF WS-NULL-14 < 0                                            
A05020*               MOVE SPACES            TO S-MADE-SAFE-DT                  
A05020*            END-IF                                                       
                   IF WS-NULL-28 < 0                                    
                      MOVE SPACES            TO S-DATE-RECVED           
                   END-IF                                               
A05020*            IF S-MADE-SAFE-DT = '1900-01-01-00.00.00.000000'             
A05020*               MOVE SPACES            TO S-MADE-SAFE-DT                  
A05020*            END-IF                                                       
A05020*            MOVE SPACES               TO S-MADE-SAFE-DT                  
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7101'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7102-CLOSE-TASKS-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE TASKS-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7102'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-OPEN-COMM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN COMM-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7110'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_COMM_DATA'      TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7111-FETCH-COMM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR                                        
                INTO :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-INITIAL-COMMENT-TX                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   IF S-RED-FLAG-SAFETY = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-SAFETY        
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-SAFETY        
                   END-IF                                               
                   IF S-RED-FLAG-MAINT  = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-MAINT         
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-MAINT         
                   END-IF                                               
                   IF S-RED-FLAG-STORM  = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-STORM         
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-STORM         
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7111'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_COMM_DATA'      TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7112-CLOSE-COMM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7112'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_COMM_DATA'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7112-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-OPEN-COMM-PREM-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN COMM-PREM-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7120'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_COMM_DATA'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7121-FETCH-COMM-PREM-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH COMM-PREM-CURSOR                                   
                INTO :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-INITIAL-COMMENT-TX                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   IF S-RED-FLAG-SAFETY = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-SAFETY        
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-SAFETY        
                   END-IF                                               
                   IF S-RED-FLAG-MAINT  = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-MAINT         
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-MAINT         
                   END-IF                                               
                   IF S-RED-FLAG-STORM  = 'Y'                           
                      MOVE 'Y'              TO S-RED-FLAG-STORM         
                   ELSE                                                 
                      MOVE 'N'              TO S-RED-FLAG-STORM         
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7121'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_COMM_DATA'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7121-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7122-CLOSE-COMM-PREM-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-PREM-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7122'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_COMM_DATA'     TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7122-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-OPEN-TASK-TYPE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN TASK-TYPE-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7130'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_FM_ORD_TASK_TP' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7131-FETCH-TASK-TYPE-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH TASK-TYPE-CURSOR                                   
                INTO :TY-VALIDATION-CD,                                 
                     :TY-VALIDATE-CRITERIA,                             
                     :TY-SO-BUSINESS-UNIT,                              
                     :TY-CLICK-VALUE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7131'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_FM_ORD_TASK_TP' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   MOVE 'WORK_TYPE_CD'       TO TABLE-ELEMENT-2         
                   MOVE VI-WORK-TYPE-CD      TO HOSTVAR-ELEMENT-2       
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3         
                   MOVE VI-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7131-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7132-CLOSE-TASK-TYPE-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE TASK-TYPE-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7132'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_FM_ORD_TASK_TP' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7132-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-APPL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN APPL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7201-FETCH-APPL-CURSOR.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
                                                                        
           EXEC SQL                                                     
               FETCH APPL-CURSOR                                        
                INTO :VQ-APPLIANCE-CD :WS-NULL-01,                       
                     :VQ-CODE-UTIL-TYPE :WS-NULL-02,                     
                     :S-LEAK-IND :WS-NULL-03,                            
                     :S-LIGHT-IND :WS-NULL-04,                           
                     :S-REPAIR-IND :WS-NULL-05,                          
                     :S-CUTOFF-IND :WS-NULL-06,                          
                     :S-CAUTION-TAG-IND :WS-NULL-07,                     
                     :S-REPLACE-APP-FL :WS-NULL-08,                      
                     :S-INSTALL-DT :WS-NULL-09,                          
                     :S-EQUIPMENT-UNQ                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-01 < 0                                   
                       MOVE SPACES    TO  S-APPLIANCE-CD                
                    END-IF                                              
                    IF WS-NULL-02 < 0                                   
                       MOVE SPACES    TO  S-CODE-UTIL-TYPE-2            
                    END-IF                                              
                    IF WS-NULL-03 < 0                                   
                       MOVE SPACES    TO  S-LEAK-IND                    
                    END-IF                                              
                    IF WS-NULL-04 < 0                                   
                       MOVE SPACES    TO  S-LIGHT-IND                   
                    END-IF                                              
                    IF WS-NULL-05 < 0                                   
                       MOVE SPACES    TO  S-REPAIR-IND                  
                    END-IF                                              
                    IF WS-NULL-06 < 0                                   
                       MOVE SPACES    TO  S-CUTOFF-IND                  
                    END-IF                                              
                    IF WS-NULL-07 < 0                                   
                       MOVE SPACES    TO  S-CAUTION-TAG-IND             
                    END-IF                                              
                    IF WS-NULL-08 < 0                                   
                       MOVE SPACES    TO  S-REPLACE-APP-FL              
                    END-IF                                              
                    IF WS-NULL-09 < 0                                   
                       MOVE SPACES    TO  S-INSTALL-DT                  
                    END-IF                                              
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7201'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7201-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7202-CLOSE-APPL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE APPL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7202'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7202-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020 7200E-OPEN-EMER-APPL-CURSOR.                                     
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         OPEN EMER-APPL-CURSOR                                    
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
A05020             MOVE '7200E'              TO ACTIVE-PARAGRAPH        
A05020             MOVE 'OPEN'               TO ABEND-FUNCTION          
A05020             MOVE SPACES               TO ABEND-SQL-PREDICATES    
A05020                                          ABEND-TABLES            
A05020             MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
A05020             MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
A05020             MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7200E-EXIT.                                                      
A05020     EXIT.                                                        
A05020                                                                  
A05020 7201E-FETCH-EMER-APPL-CURSOR.                                    
A05020                                                                  
A05020     INITIALIZE GTT-RETURN-FIELDS-2.                              
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         FETCH EMER-APPL-CURSOR                                   
A05020          INTO :VQ-APPLIANCE-CD :WS-NULL-01,                       
A05020               :S-CAUTION-TAG-IND :WS-NULL-07,                     
A05020               :S-CAUTION-TAG-DT :WS-NULL-11,                      
A05020               :S-INSTALL-DT :WS-NULL-09,                          
A05020               :S-EQUIPMENT-UNQ,                                  
A05020               :S-TAG-NO,                                         
A05020               :S-CONDITION-CD,                                   
A05020               :S-APPLIANCE-COMMENTS                              
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020              IF WS-NULL-01 < 0                                   
A05020                 MOVE SPACES    TO  S-APPLIANCE-CD                
A05020              END-IF                                              
A05020              IF WS-NULL-07 < 0                                   
A05020                 MOVE SPACES    TO  S-CAUTION-TAG-IND             
A05020              END-IF                                              
A05020              IF WS-NULL-09 < 0                                   
A05020                 MOVE SPACES    TO  S-INSTALL-DT                  
A05020              END-IF                                              
A05020              IF WS-NULL-11 < 0                                   
A05020                 MOVE SPACES    TO  S-CAUTION-TAG-DT              
A05020              END-IF                                              
A05020         WHEN NOT-FOUND                                           
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
A05020             MOVE '7201E'              TO ACTIVE-PARAGRAPH        
A05020             MOVE 'FETCH'              TO ABEND-FUNCTION          
A05020             MOVE SPACES               TO ABEND-SQL-PREDICATES    
A05020                                          ABEND-TABLES            
A05020             MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
A05020             MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
A05020             MOVE VO-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7201E-EXIT.                                                      
A05020     EXIT.                                                        
A05020                                                                  
A05020 7202E-CLOSE-EMER-APPL-CURSOR.                                    
A05020                                                                  
A05020     EXEC SQL                                                     
A05020         CLOSE EMER-APPL-CURSOR                                   
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE '7202E'             TO ACTIVE-PARAGRAPH         
A05020             MOVE 'CLOSE'             TO ABEND-FUNCTION           
A05020             MOVE SPACES              TO ABEND-SQL-PREDICATES     
A05020                                         ABEND-TABLES             
A05020             MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
A05020             MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
A05020             MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-2        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 7202E-EXIT.                                                      
A05020     EXIT.                                                        
A05020                                                                  
       7300-OPEN-CHARGES-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN CHARGES-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7300'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_CHARGES'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7301-FETCH-CHARGES-CURSOR.                                       
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
                                                                        
           EXEC SQL                                                     
               FETCH CHARGES-CURSOR                                     
                INTO :S-REG-CHARGEABLE-HRS,                             
                     :S-OT-CHARGEABLE-HRS,                              
                     :S-CHARGES-COMMENTS,                               
                     :VG-WORK-PERIOD-CD,                                
                     :VG-WAIVER-TYPE-CD,                                
                     :S-MATERIAL-CHRG,                                  
                     :VG-CODE-UTIL-TYPE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7301'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_CHARGES'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7301-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7302-CLOSE-CHARGES-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE CHARGES-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7302'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_CHARGES'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7302-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400A-OPEN-METER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN A-MTR-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7400A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7401A-FETCH-METER-CURSOR.                                        
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
                                                                        
           EXEC SQL                                                     
               FETCH A-MTR-CURSOR                                       
                INTO :MN-CODE-METER-STATUS,                             
                     :S-METER-SUPPLYING,                                
                     :MN-CODE-UTIL-TYPE,                                
                     :MN-METER-NO,                                      
                     :MN-IC-NO,                                         
                     :MN-MTR-REF-NO,                                    
                     :S-SO-INST-SEQ-NO-4,                               
                     :S-WORK-TYPE-CD-4,                                 
                     :S-WORK-TYPE-DESC-4,                               
                     :MN-CODE-TIME-PERIOD,                              
                     :MN-REG-ID-NO,                                     
                     :S-LOCK-TYPE-ID,                                   
                     :S-CODE-METER-LOC,                                 
                     :MN-LAST-READ-VALUE,                               
                     :MN-LAST-REG-READ-DATE,                            
                     :MN-CODE-STATUS-REAS,                              
                     :S-RLSE-NO,                                        
                     :S-RLSE-DATE :WS-NULL-13,                           
                     :S-CUST-PHASE-CD,                                  
                     :MN-POINT-ID,                                      
                     :MN-GIS-POINT-ID,                                  
                     :MN-MIN-NO-UNITS,                                  
                     :MN-MAX-NO-UNITS,                                  
                     :MN-REMOTE-READ-IND :WS-NULL-12,                    
                     :MN-DIGTL-MTR-TYPE,                                
                     :MN-PROGRAM-ID,                                    
                     :MN-MTR-READ-SOURCE-CD,                            
                     :MN-METER-PRESSURE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-12 < 0                                    
                      INITIALIZE                MN-REMOTE-READ-IND      
                   END-IF                                               
                   IF WS-NULL-13 < 0                                    
                      INITIALIZE                S-RLSE-DATE             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7401A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7401A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7402A-CLOSE-METER-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE A-MTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7402A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7402A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7400-OPEN-METER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN METER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7400'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_MTR_CHG'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7401-FETCH-METER-CURSOR.                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
                                                                        
           EXEC SQL                                                     
               FETCH METER-CURSOR                                       
                INTO :VC-CODE-DEST,                                     
                     :VC-DEST-NO,                                       
                     :VC-CODE-MTR-STATUS-WS,                            
                     :S-READ-VALUE-IS-4,                                
                     :S-METER-SUPPLYING,                                
                     :VC-CODE-UTIL-TYPE,                                
                     :VC-METER-NO,                                      
                     :VC-IC-NO,                                         
                     :VC-MTR-REF-NO,                                    
                     :S-SO-INST-SEQ-NO-4,                               
                     :S-WORK-TYPE-CD-4,                                 
                     :S-WORK-TYPE-DESC-4,                               
                     :VC-CODE-TIME-PERIOD,                              
                     :VC-REG-ID-NO,                                     
                     :S-CONSTANT,                                       
                     :S-NO-DIALS-4,                                     
                     :S-LOCK-TYPE-ID,                                   
                     :S-CODE-METER-LOC,                                 
                     :VC-LAST-READ-VALUE,                               
                     :VC-LAST-REG-READ-DATE,                            
                     :VC-CODE-STATUS-REA-WS,                            
                     :S-RLSE-NO,                                        
                     :S-RLSE-DATE :WS-NULL-13,                           
                     :VC-CODE-USAGE-TYPE,                               
                     :VC-METER-PRESSURE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-13 < 0                                    
                      INITIALIZE                S-RLSE-DATE             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7401'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_MTR_CHG'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7401-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7402-CLOSE-METER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE METER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7402'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_MTR_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7402-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400B-OPEN-UTIL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN UTIL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7400B'              TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_UTILITY'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7401B-FETCH-UTIL-CURSOR.                                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
                                                                        
           EXEC SQL                                                     
               FETCH UTIL-CURSOR                                        
                INTO :S-METER-SUPPLYING,                                
                     :VE-CODE-UTIL-TYPE,                                
                     :S-METER-NO-4,                                     
                     :VE-IC-NO,                                         
                     :S-MTR-REF-NO-4,                                   
                     :S-SO-INST-SEQ-NO-4,                               
                     :S-WORK-TYPE-CD-4,                                 
                     :S-WORK-TYPE-DESC-4,                               
                     :S-RLSE-NO,                                        
                     :S-RLSE-DATE :WS-NULL-13,                           
                     :S-CODE-REVENUE-CLASS,                             
                     :S-RATE-PLAN-NO,                                   
                     :S-READ-CYCLE,                                     
                     :S-READ-ROUTE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-13 < 0                                    
                      INITIALIZE                S-RLSE-DATE             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7401B'              TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_UTILITY'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7401B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7402B-CLOSE-UTIL-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE UTIL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7402B'             TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_UTILITY'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7402B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7400C-OPEN-SOMETER-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN SOMETER-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7400C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_METER'       TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7401C-FETCH-SOMETER-CURSOR.                                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-4.                              
                                                                        
           EXEC SQL                                                     
               FETCH SOMETER-CURSOR                                     
                INTO :S-METER-SUPPLYING,                                
                     :VM-CODE-UTIL-TYPE,                                
                     :S-METER-NO-4,                                     
                     :VM-IC-NO,                                         
                     :VM-MTR-REF-NO,                                    
                     :S-SO-INST-SEQ-NO-4,                               
                     :S-WORK-TYPE-CD-4,                                 
                     :S-WORK-TYPE-DESC-4,                               
                     :S-CODE-METER-LOC,                                 
                     :S-RLSE-NO,                                        
                     :S-RLSE-DATE :WS-NULL-13,                           
                     :VM-METER-PRESSURE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-13 < 0                                    
                      INITIALIZE                S-RLSE-DATE             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7401C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_METER'       TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7401C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7402C-CLOSE-SOMETER-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE SOMETER-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7402C'             TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_METER'      TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7402C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7500-OPEN-REGISTERS-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN REGISTERS-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7500'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_REG_CHG'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-FETCH-REGISTERS-CURSOR.                                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
                                                                        
           EXEC SQL                                                     
               FETCH REGISTERS-CURSOR                                   
                INTO :S-READ-VALUE-IS-5,                                
                     :VK-CODE-TIME-PERIOD,                              
                     :VK-REG-ID-NO,                                     
                     :VK-CODE-STATUS-REA-WS,                            
                     :S-LAST-REG-READ-VALUE,                            
                     :S-NO-DIALS-5,                                     
                     :VK-CODE-UTIL-TYPE,                                
                     :VK-METER-NO,                                      
                     :VK-IC-NO,                                         
                     :VK-MTR-REF-NO,                                    
                     :S-SO-INST-SEQ-NO-5,                               
                     :VK-CODE-USAGE-TYPE,                               
                     :VK-CODE-REG-STATUS-WS,                            
                     :VK-LAST-REG-READ-DT,                              
                     :VI-WORK-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7501'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_REG_CHG'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7502-CLOSE-REGISTERS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE REGISTERS-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7502'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_REG_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7502-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500A-OPEN-REGISTERS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               OPEN REG-READ-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7500A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_REAGISTER_READ' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7501A-FETCH-REGISTERS-CURSOR.                                    
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
                                                                        
           EXEC SQL                                                     
               FETCH REG-READ-CURSOR                                    
                INTO :S-READ-VALUE-IS-5,                                
                     :RG-CODE-TIME-PERIOD,                              
                     :RG-REG-ID-NO,                                     
                     :RG-CODE-STATUS-REAS,                              
                     :S-LAST-REG-READ-VALUE,                            
                     :S-NO-DIALS-5,                                     
                     :RG-CODE-UTIL-TYPE,                                
                     :S-METER-NO-5,                                     
                     :RG-IC-NO,                                         
                     :S-MTR-REF-NO-5,                                   
                     :S-SO-INST-SEQ-NO-5,                               
                     :RG-CODE-USAGE-TYPE,                               
                     :RG-CODE-REG-STATUS,                               
                     :S-MIN-NO-UNITS-5,                                 
                     :S-MAX-NO-UNITS-5,                                 
A05020               :RG-LAST-REG-READ-TM,                              
A05020               :RG-LAST-REG-READ-DT,                              
                     :VI-WORK-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7501A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_REGISTER_READ'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7502A-CLOSE-REGISTERS-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE REG-READ-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7502A'             TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7502A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7500C-OPEN-SOREGISTERS-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN SOREGISTERS-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7500C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_REGISTER'    TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7501C-FETCH-SOREGISTERS-CURSOR.                                  
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
                                                                        
           EXEC SQL                                                     
               FETCH SOREGISTERS-CURSOR                                 
                INTO :WK-CODE-TIME-PERIOD,                              
                     :WK-REG-ID-NO,                                     
                     :WK-CODE-STATUS-REAS,                              
                     :S-LAST-REG-READ-VALUE,                            
                     :S-NO-DIALS-5,                                     
                     :WK-CODE-UTIL-TYPE,                                
                     :WK-METER-NO,                                      
                     :WK-IC-NO,                                         
                     :WK-MTR-REF-NO,                                    
                     :S-SO-INST-SEQ-NO-5,                               
                     :WK-CODE-REG-STATUS,                               
                     :WK-CODE-USAGE-TYPE,                               
                     :VI-WORK-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7501C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_SO_REGISTER'    TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7501C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7502C-CLOSE-SOREGISTERS-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE SOREGISTERS-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7502C'             TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_REGISTER'   TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7502C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7601-SELECT-MIN-DEVICE                                         *        
      *     GETS THE MIN DEVICE NO                                     *        
      ******************************************************************        
      *7601-SELECT-MIN-DEVICE.                                                  
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT DEVICE_NO,                                                 
      *              MTR_ATT_TYPE_DESC,                                         
      *              CODE_STATUS_REASON,                                        
      *              READ_VALUE_IS,                                             
      *              ON.CODE_UTIL_TYPE,                                         
      *              ON.METER_NO,                                               
      *              ON.IC_NO,                                                  
      *              ON.MTR_REF_NO,                                             
      *              ON.REG_ID_NO,                                              
      *              VI.SO_INST_SEQ_NO                                          
      *         INTO :S-DEVICE-NO,                                              
      *              :S-CODE-ATT-TYPE,                                          
      *              :ON-CODE-STATUS-REASON,                                    
      *              :S-READ-VALUE-IS-6:WS-NULL-10,                             
      *              :ON-CODE-UTIL-TYPE,                                        
      *              :S-METER-NO-6,                                             
      *              :S-IC-NO-6,                                                
      *              :S-MTR-REF-NO-6,                                           
      *              :S-REG-ID-NO-6,                                            
      *              :S-SO-INST-SEQ-NO-6                                        
      *         FROM CSS_SO_MTR_ATT_CHG ON,                                     
      *              CSS_SO_ORDER_INST VI,                                      
      *              CSS_MTR_ATT_TYPE N5                                        
      *        WHERE ON.SERV_ORDER_NO  = :VI-SERV-ORDER-NO                      
      *          AND ON.SERV_ORDER_NO  = VI.SERV_ORDER_NO                       
      *          AND ON.IC_NO          = VI.IC_NO                               
      *          AND ON.METER_NO       = VI.METER_NO                            
      *          AND ON.MTR_REF_NO     = VI.MTR_REF_NO                          
      *          AND VI.WORK_TYPE_CD   > ' '                                    
      *          AND VI.WORK_TYPE_CD   <> 'FIN'                                 
      *          AND ON.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                       
      *          AND ON.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                      
      *          AND ON.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                      
      *          AND N5.DEVICE_TYPE_CD = 'A'                                    
      *          AND DEVICE_NO =                                                
      *          (SELECT MIN(A.DEVICE_NO)                                       
      *             FROM CSS_SO_MTR_ATT_CHG A                                   
      *            WHERE A.SERV_ORDER_NO   = ON.SERV_ORDER_NO                   
      *              AND A.CODE_UTIL_TYPE  = ON.CODE_UTIL_TYPE)                 
      *        FETCH FIRST 1 ROW ONLY                                           
      *         WITH UR                                                         
      *         QUERYNO 7601                                                    
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
      *    EVALUATE WS-ACTIVE-RETURN-CODE                                       
      *        WHEN SUCCESSFUL-CALL                                             
      *        WHEN NOT-FOUND                                                   
      *        WHEN -811                                                        
      *            CONTINUE                                                     
      *        WHEN OTHER                                                       
      *            MOVE PROGRAM-NAME            TO ABEND-PROGRAM                
      *            MOVE '7601'                  TO ACTIVE-PARAGRAPH             
      *            MOVE 'SELECT'                TO ABEND-FUNCTION               
      *            MOVE 'CSS_SO_MTR_ATT_CHG'    TO TABLE-1                      
      *            MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1              
      *            MOVE VI-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1            
      *            PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT                  
      *    END-EVALUATE.                                                        
      *                                                                         
      *7601-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
P00718 7600-OPEN-ATTACHMENTS-CURSOR.                                    
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         OPEN ATTACHMENTS-CURSOR                                  
P00718     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00718             MOVE '7600'               TO ACTIVE-PARAGRAPH        
P00718             MOVE 'OPEN'               TO ABEND-FUNCTION          
P00718             MOVE SPACES               TO ABEND-SQL-PREDICATES    
P00718                                          ABEND-TABLES            
P00718             MOVE 'CSS_SO_MTR_ATT_CHG' TO TABLE-1                 
P00718             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
P00718             MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7600-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
P00718 7601-FETCH-ATTACHMENTS-CURSOR.                                   
P00718                                                                  
P00718     INITIALIZE GTT-RETURN-FIELDS-6.                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         FETCH ATTACHMENTS-CURSOR                                 
P00718          INTO :S-DEVICE-NO,                                      
P00718               :S-CODE-ATT-TYPE,                                  
P00718               :ON-CODE-STATUS-REASON,                            
P00718               :S-READ-VALUE-IS-6 :WS-NULL-10,                     
P00718               :ON-CODE-UTIL-TYPE,                                
P00718               :S-METER-NO-6,                                     
P00718               :S-IC-NO-6,                                        
P00718               :S-MTR-REF-NO-6,                                   
P00718               :S-REG-ID-NO-6,                                    
P00718               :S-SO-INST-SEQ-NO-6                                
P00718     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718             IF WS-NULL-10 < 10                                   
P00718                MOVE ZEROES            TO S-READ-VALUE-IS-6       
P00718             END-IF                                               
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00718             MOVE '7601'               TO ACTIVE-PARAGRAPH        
P00718             MOVE 'FETCH'              TO ABEND-FUNCTION          
P00718             MOVE SPACES               TO ABEND-SQL-PREDICATES    
P00718                                          ABEND-TABLES            
P00718             MOVE 'CSS_SO_MTR_ATT_CHG' TO TABLE-1                 
P00718             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
P00718             MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7601-EXIT.                                                       
P00718     EXIT.                                                        
P00718                                                                  
P00718 7602-CLOSE-ATTACHMENTS-CURSOR.                                   
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         CLOSE ATTACHMENTS-CURSOR                                 
P00718     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00718             MOVE '7602'               TO ACTIVE-PARAGRAPH        
P00718             MOVE 'CLOSE'              TO ABEND-FUNCTION          
P00718             MOVE SPACES               TO ABEND-SQL-PREDICATES    
P00718                                          ABEND-TABLES            
P00718             MOVE 'CSS_SO_MTR_ATT_CHG' TO TABLE-1                 
P00718             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
P00718             MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7602-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
       7700-OPEN-DNP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN DNP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7700'               TO ACTIVE-PARAGRAPH        
                   MOVE 'OPEN'               TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7701-FETCH-DNP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH DNP-CURSOR                                         
                INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-24,                  
                     :AR-AMT-ORIG-ENTERED                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-24 < 0                                    
                      MOVE SPACES            TO AR-TRANS-HIST-SEQ-NO    
                   END-IF                                               
                   MOVE AR-TRANS-HIST-SEQ-NO TO S-DNP-LAST-PAY-DATE     
                   IF AR-AMT-ORIG-ENTERED NUMERIC                       
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE 0                TO AR-AMT-ORIG-ENTERED     
                   END-IF                                               
                   MOVE AR-AMT-ORIG-ENTERED  TO S-DNP-LAST-PAY-AMNT     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7701'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7701-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7702-CLOSE-DNP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE DNP-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7702'               TO ACTIVE-PARAGRAPH        
                   MOVE 'CLOSE'              TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7702-EXIT.                                                       
           EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    8000-RESET-PRINTED-IND                                      *        
A05020*        RESETS PRINTED IND FOR JOBBING/MARKETTING/GAS CONSTR    *        
A05020******************************************************************        
A05020 8000-RESET-PRINTED-IND.                                          
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        UPDATE CSS_SO_DATA                                        
A05020           SET PRINTED_IND   = :WS-PRINT-IND                      
A05020         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                  
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '8000'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'UPDATE'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_DATA'       TO TABLE-1                  
A05020             MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
A05020             MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 8000-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    8010-INSERT-PRINT-Q                                         *        
A05020*       IRESETS INTO PRINT QUEUEJOBBING/MARKETTING/GAS CONSTR    *        
A05020******************************************************************        
A05020 8010-INSERT-PRINT-Q.                                             
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        INSERT INTO CSS_SO_PRINT_QUEUE                            
A05020               (                                                  
A05020                SERV_ORDER_NO,                                    
A05020                COMPANY_NO,                                       
A05020                LOCAL_OFFICE,                                     
A05020                SORT_CRITERIA,                                    
A05020                CREATED_TS,                                       
A05020                PRINTED_TS,                                       
A05020                PRINT_ID,                                         
A05020                PRINT_PRIORITY,                                   
A05020                CREATED_BY_USER_ID,                               
A05020                WANTED_BY_DATE                                    
A05020               )                                                  
A05020        VALUES                                                    
A05020               (                                                  
A05020                :VI-SERV-ORDER-NO,                                
A05020                :VO-COMPANY-NO,                                   
A05020                :VO-LOCAL-OFFICE,                                 
A05020                1,                                                
A05020                CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP),                
A05020                NULL,                                             
A05020                :VP-PRINT-ID,                                     
A05020                1,                                                
A05020                'SYSTEM',                                         
A05020                CIS.CHAR2TIMESTAMP(:S-ASSIGNED-DATE)                      
A05020               )                                                  
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SO_PRINT_QUEUE                                    
MFA-TR*              (                                                          
MFA-TR*               SERV_ORDER_NO,                                            
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               SORT_CRITERIA,                                            
MFA-TR*               CREATED_TS,                                               
MFA-TR*               PRINTED_TS,                                               
MFA-TR*               PRINT_ID,                                                 
MFA-TR*               PRINT_PRIORITY,                                           
MFA-TR*               CREATED_BY_USER_ID,                                       
MFA-TR*               WANTED_BY_DATE                                            
MFA-TR*              )                                                          
MFA-TR*       VALUES                                                            
MFA-TR*              (                                                          
MFA-TR*               :VI-SERV-ORDER-NO,                                        
MFA-TR*               :VO-COMPANY-NO,                                           
MFA-TR*               :VO-LOCAL-OFFICE,                                         
MFA-TR*               1,                                                        
MFA-TR*               :WS-CURRENT-TIMESTAMP,                                    
MFA-TR*               NULL,                                                     
MFA-TR*               :VP-PRINT-ID,                                             
MFA-TR*               1,                                                        
MFA-TR*               'SYSTEM',                                                 
MFA-TR*               :S-ASSIGNED-DATE                                          
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '8010'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'INSERT'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_PRINT_QUEUE' TO TABLE-1                 
A05020             MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
A05020             MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 8010-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    8020-UPDATE-BIZ-UNIT                                        *        
A05020*        OVERRIDES SO BUSINESS UNIT                              *        
A05020******************************************************************        
A05020 8020-UPDATE-BIZ-UNIT.                                            
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        UPDATE CSS_SO_DATA                                        
A05020           SET SO_BUSINESS_UNIT = :VO-SO-BUSINESS-UNIT            
A05020         WHERE SERV_ORDER_NO    = :VI-SERV-ORDER-NO               
A05020     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020                                                                  
A05020     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A05020                                                                  
A05020     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05020         WHEN SUCCESSFUL-CALL                                     
A05020             CONTINUE                                             
A05020         WHEN OTHER                                               
A05020             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A05020             MOVE SQLCODE             TO ABEND-SQLCODE            
A05020             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A05020             MOVE '8000'              TO ACTIVE-PARAGRAPH         
A05020             MOVE 'UPDATE'            TO ABEND-FUNCTION           
A05020             MOVE 'CSS_SO_DATA'       TO TABLE-1                  
A05020             MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
A05020             MOVE VI-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
A05020             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05020     END-EVALUATE.                                                
A05020                                                                  
A05020 8020-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
A05020******************************************************************        
A05020*    8030-COMMIT-UPDATES                                         *        
A05020*        COMMITS UPDATES                                         *        
A05020******************************************************************        
A05020 8030-COMMIT-UPDATES.                                             
A05020                                                                  
A05020     EXEC SQL                                                     
A05020        COMMIT                                                    
A05020     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
A05020                                                                  
A05020 8030-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      ******************************************************************        
      * INSERTS INTO TEMP TABLE                                        *        
      ******************************************************************        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04584_R1                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              SO_INST_SEQ_NO,                                           
              WORK_TYPE_CD,                                             
              WORK_TYPE_DESC,                                           
              CODE_UTIL_TYPE,                                           
              ORDER_PRIORITY_CD,                                        
              SO_EST_LABOR_HR,                                          
              COMPANY_NO,                                               
              LOCAL_OFFICE,                                             
              ORDER_TYPE_CD,                                            
              ACCOUNT_NO,                                               
              FULL_NAME,                                                
              STREET_ADDRESS,                                           
              HOUSE_NO,                                                 
              ADDR_PREFIX_1,                                            
              ADDR_PREFIX_2,                                            
              STREET_NAME,                                              
              STREET_SUFFIX,                                            
              ADDR_SUFFIX,                                              
              STREET_LOCATION_1,                                        
              STREET_LOCATION_2,                                        
              ADDR_STREET,                                              
              ADDR_CITY_STATE,                                          
              STATE,                                                    
              COUNTRY,                                                  
              LATITUDE,                                                 
              LONGITUDE,                                                
              LOT,                                                      
              BLOCK,                                                    
              SUBDIVISION_DESC,                                         
A05020        SUBDIVISION_ID,                                           
              ZIP_CODE,                                                 
A05020        ZIP_CODE_PLUS_FOUR,                                       
              TOWN,                                                     
              ORDER_PLACED_BY,                                          
              ORDER_REASON,                                             
              CALL_BEFORE_MINUTS,                                       
              PHONE_NO,                                                 
              PHONE_NO_EXT,                                             
              SERV_ORDER_REMARKS,                                       
              SERV_ORDER_REMUPD,                                        
              SPCL_INSTRUCTIONS,                                        
              PREMISE,                                                  
              PREMISE_DIRECTIONS,                                       
              CODE_ACCT_STAT,                                           
              XS_FLOW_VALVE_FL,                                         
              SPLIT_SERVICE_FL,                                         
              SERVICE_CHARGES ,                                         
              COUNTY,                                                   
              TOTAL_BTU,                                                
              ALT_PHONE_NO,                                             
              ALT_PHONE_NO_EXT,                                         
A05020*       MADE_SAFE_DT,                                                     
              HOME_ALL_DAY_FL,                                          
              BUSINESS_UNIT,                                            
              DNP_CRITICAL_CUS,                                         
              CIRCUIT_ID ,                                              
              CUST_PHASE_CD,                                            
              GRID_CELL,                                                
              POLE_NO,                                                  
              ASSIGNED_DATE,                                            
              COMPLIANCE_DAYS,                                          
              DUE_DAYS,                                                 
              MATERIAL_FL,                                              
              WORK_START_TIME,                                          
              WORK_STOP_TIME,                                           
              WORK_DISTRICT,                                            
              OPTIMIZE_ORDER,                                           
              ORDER_STATE_CD,                                           
              RED_FLAG_SAFETY,                                          
              RED_FLAG_MAINT,                                           
              RED_FLAG_STORM,                                           
              SO_SERVICE_CHRG,                                          
              GROUP_CODE,                                               
              RLSE_NO,                                                  
              ORDER_CANCEL,                                             
              SO_COMPL_REMARKS,                                         
              DATE_RECVED,                                              
A00520        COMM_COMMENTS,                                            
A00520        DBA_NAME,                                                 
A00520        COMPLIANCE_DATE,                                          
A00520        TASK_TYPE,                                                
A00520        APPT_FL,                                                  
P01176        SAMPLE_TEST,                                              
A05020        HOT_SPOT_FL                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-SERV-ORDER-NO,                                        
               :S-SO-INST-SEQ-NO-1,                                     
               :S-WORK-TYPE-CD-1,                                       
               :S-WORK-TYPE-DESC-1,                                     
               :S-CODE-UTIL-TYPE-1,                                     
               :S-ORDER-PRIORITY-CD,                                    
               :S-SO-EST-LABOR-HR,                                      
               :S-COMPANY-NO,                                           
               :S-LOCAL-OFFICE,                                         
               :S-ORDER-TYPE-CD,                                        
               :S-ACCOUNT-NO,                                           
               :S-FULL-NAME,                                            
               :S-STREET-ADDRESS,                                       
               :S-HOUSE-NO,                                             
               :S-ADDR-PREFIX-1,                                        
               :S-ADDR-PREFIX-2,                                        
               :S-STREET-NAME,                                          
               :S-STREET-SUFFIX,                                        
               :S-ADDR-SUFFIX,                                          
               :S-STREET-LOCATION-1,                                    
               :S-STREET-LOCATION-2,                                    
               :S-ADDR-STREET,                                          
               :S-ADDR-CITY-STATE,                                      
               :S-STATE,                                                
               :S-COUNTRY,                                              
               :S-LATITUDE,                                             
               :S-LONGITUDE,                                            
               :S-LOT,                                                  
               :S-BLOCK,                                                
               :S-SUBDIVISION-DESC,                                     
A05020         :S-SUBDIVISION-ID,                                       
               :S-ZIP-CODE,                                             
A05020         :S-ZIP-CODE-PLUS-FOUR,                                   
               :S-TOWN,                                                 
               :S-ORDER-PLACED-BY,                                      
               :S-ORDER-REASON,                                         
               :S-CALL-BEFORE-MINUTS,                                   
               :S-PHONE-NO,                                             
               :S-PHONE-NO-EXT,                                         
               :S-SERV-ORDER-REMARKS,                                   
               :S-SERV-ORDER-REMUPD,                                    
               :S-SPCL-INSTRUCTIONS,                                    
               :S-PREMISE,                                              
               :S-PREMISE-DIRECTIONS,                                   
               :S-CODE-ACCT-STAT,                                       
               :S-XS-FLOW-VALVE-FL,                                     
               :S-SPLIT-SERVICE-FL,                                     
               :S-SERVICE-CHARGES,                                      
               :S-COUNTY,                                               
               :S-TOTAL-BTU,                                            
               :S-ALT-PHONE-NO,                                         
               :S-ALT-PHONE-NO-EXT,                                     
A05020*        :S-MADE-SAFE-DT,                                                 
               :S-HOME-ALL-DAY-FL,                                      
               :S-BUSINESS-UNIT,                                        
               :S-DNP-CRITICAL-CUS,                                     
               :S-CIRCUIT-ID,                                           
               :S-CUST-PHASE-CD,                                        
               :S-GRID-CELL,                                            
               :S-POLE-NO,                                              
               :S-ASSIGNED-DATE,                                        
               :S-COMPLIANCE-DAYS,                                      
               :S-DUE-DAYS,                                             
               :S-MATERIAL-FL,                                          
               :S-WORK-START-TIME,                                      
               :S-WORK-STOP-TIME,                                       
               :S-WORK-DISTRICT,                                        
               :S-OPTIMIZE-ORDER,                                       
               :S-ORDER-STATE-CD,                                       
               :S-RED-FLAG-SAFETY,                                      
               :S-RED-FLAG-MAINT,                                       
               :S-RED-FLAG-STORM,                                       
               :S-SO-SERVICE-CHRG,                                      
               :S-GROUP-CODE,                                           
               :S-RLSE-NO-1,                                            
               :S-ORDER-CANCEL,                                         
               :S-SO-COMPL-REMARKS,                                     
               :S-DATE-RECVED,                                          
A00520         :S-COMM-COMMENTS,                                        
A00520         :S-DBA-NAME,                                             
A00520         :S-COMPLIANCE-DATE,                                      
A00520         :S-TASK-TYPE,                                            
A00520         :S-APPT-FL,                                              
P01176         :S-SAMPLE-TEST,                                          
A05020         :S-HOT-SPOT-FL                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04584_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       SO_INST_SEQ_NO,                                                   
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       WORK_TYPE_DESC,                                                   
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       ORDER_PRIORITY_CD,                                                
MFA-TR*       SO_EST_LABOR_HR,                                                  
MFA-TR*       COMPANY_NO,                                                       
MFA-TR*       LOCAL_OFFICE,                                                     
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       FULL_NAME,                                                        
MFA-TR*       STREET_ADDRESS,                                                   
MFA-TR*       HOUSE_NO,                                                         
MFA-TR*       ADDR_PREFIX_1,                                                    
MFA-TR*       ADDR_PREFIX_2,                                                    
MFA-TR*       STREET_NAME,                                                      
MFA-TR*       STREET_SUFFIX,                                                    
MFA-TR*       ADDR_SUFFIX,                                                      
MFA-TR*       STREET_LOCATION_1,                                                
MFA-TR*       STREET_LOCATION_2,                                                
MFA-TR*       ADDR_STREET,                                                      
MFA-TR*       ADDR_CITY_STATE,                                                  
MFA-TR*       STATE,                                                            
MFA-TR*       COUNTRY,                                                          
MFA-TR*       LATITUDE,                                                         
MFA-TR*       LONGITUDE,                                                        
MFA-TR*       LOT,                                                              
MFA-TR*       BLOCK,                                                            
MFA-TR*       SUBDIVISION_DESC,                                                 
MFA-TR*       SUBDIVISION_ID,                                                   
MFA-TR*       ZIP_CODE,                                                         
MFA-TR*       ZIP_CODE_PLUS_FOUR,                                               
MFA-TR*       TOWN,                                                             
MFA-TR*       ORDER_PLACED_BY,                                                  
MFA-TR*       ORDER_REASON,                                                     
MFA-TR*       CALL_BEFORE_MINUTS,                                               
MFA-TR*       PHONE_NO,                                                         
MFA-TR*       PHONE_NO_EXT,                                                     
MFA-TR*       SERV_ORDER_REMARKS,                                               
MFA-TR*       SERV_ORDER_REMUPD,                                                
MFA-TR*       SPCL_INSTRUCTIONS,                                                
MFA-TR*       PREMISE,                                                          
MFA-TR*       PREMISE_DIRECTIONS,                                               
MFA-TR*       CODE_ACCT_STAT,                                                   
MFA-TR*       XS_FLOW_VALVE_FL,                                                 
MFA-TR*       SPLIT_SERVICE_FL,                                                 
MFA-TR*       SERVICE_CHARGES ,                                                 
MFA-TR*       COUNTY,                                                           
MFA-TR*       TOTAL_BTU,                                                        
MFA-TR*       ALT_PHONE_NO,                                                     
MFA-TR*       ALT_PHONE_NO_EXT,                                                 
MFA-TR*       MADE_SAFE_DT,                                                     
MFA-TR*       HOME_ALL_DAY_FL,                                                  
MFA-TR*       BUSINESS_UNIT,                                                    
MFA-TR*       DNP_CRITICAL_CUS,                                                 
MFA-TR*       CIRCUIT_ID ,                                                      
MFA-TR*       CUST_PHASE_CD,                                                    
MFA-TR*       GRID_CELL,                                                        
MFA-TR*       POLE_NO,                                                          
MFA-TR*       ASSIGNED_DATE,                                                    
MFA-TR*       COMPLIANCE_DAYS,                                                  
MFA-TR*       DUE_DAYS,                                                         
MFA-TR*       MATERIAL_FL,                                                      
MFA-TR*       WORK_START_TIME,                                                  
MFA-TR*       WORK_STOP_TIME,                                                   
MFA-TR*       WORK_DISTRICT,                                                    
MFA-TR*       OPTIMIZE_ORDER,                                                   
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       RED_FLAG_SAFETY,                                                  
MFA-TR*       RED_FLAG_MAINT,                                                   
MFA-TR*       RED_FLAG_STORM,                                                   
MFA-TR*       SO_SERVICE_CHRG,                                                  
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       RLSE_NO,                                                          
MFA-TR*       ORDER_CANCEL,                                                     
MFA-TR*       SO_COMPL_REMARKS,                                                 
MFA-TR*       DATE_RECVED,                                                      
MFA-TR*       COMM_COMMENTS,                                                    
MFA-TR*       DBA_NAME,                                                         
MFA-TR*       COMPLIANCE_DATE,                                                  
MFA-TR*       TASK_TYPE,                                                        
MFA-TR*       APPT_FL,                                                          
MFA-TR*       SAMPLE_TEST,                                                      
MFA-TR*       HOT_SPOT_FL                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-SO-INST-SEQ-NO-1,                                             
MFA-TR*        :S-WORK-TYPE-CD-1,                                               
MFA-TR*        :S-WORK-TYPE-DESC-1,                                             
MFA-TR*        :S-CODE-UTIL-TYPE-1,                                             
MFA-TR*        :S-ORDER-PRIORITY-CD,                                            
MFA-TR*        :S-SO-EST-LABOR-HR,                                              
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-LOCAL-OFFICE,                                                 
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-FULL-NAME,                                                    
MFA-TR*        :S-STREET-ADDRESS,                                               
MFA-TR*        :S-HOUSE-NO,                                                     
MFA-TR*        :S-ADDR-PREFIX-1,                                                
MFA-TR*        :S-ADDR-PREFIX-2,                                                
MFA-TR*        :S-STREET-NAME,                                                  
MFA-TR*        :S-STREET-SUFFIX,                                                
MFA-TR*        :S-ADDR-SUFFIX,                                                  
MFA-TR*        :S-STREET-LOCATION-1,                                            
MFA-TR*        :S-STREET-LOCATION-2,                                            
MFA-TR*        :S-ADDR-STREET,                                                  
MFA-TR*        :S-ADDR-CITY-STATE,                                              
MFA-TR*        :S-STATE,                                                        
MFA-TR*        :S-COUNTRY,                                                      
MFA-TR*        :S-LATITUDE,                                                     
MFA-TR*        :S-LONGITUDE,                                                    
MFA-TR*        :S-LOT,                                                          
MFA-TR*        :S-BLOCK,                                                        
MFA-TR*        :S-SUBDIVISION-DESC,                                             
MFA-TR*        :S-SUBDIVISION-ID,                                               
MFA-TR*        :S-ZIP-CODE,                                                     
MFA-TR*        :S-ZIP-CODE-PLUS-FOUR,                                           
MFA-TR*        :S-TOWN,                                                         
MFA-TR*        :S-ORDER-PLACED-BY,                                              
MFA-TR*        :S-ORDER-REASON,                                                 
MFA-TR*        :S-CALL-BEFORE-MINUTS,                                           
MFA-TR*        :S-PHONE-NO,                                                     
MFA-TR*        :S-PHONE-NO-EXT,                                                 
MFA-TR*        :S-SERV-ORDER-REMARKS,                                           
MFA-TR*        :S-SERV-ORDER-REMUPD,                                            
MFA-TR*        :S-SPCL-INSTRUCTIONS,                                            
MFA-TR*        :S-PREMISE,                                                      
MFA-TR*        :S-PREMISE-DIRECTIONS,                                           
MFA-TR*        :S-CODE-ACCT-STAT,                                               
MFA-TR*        :S-XS-FLOW-VALVE-FL,                                             
MFA-TR*        :S-SPLIT-SERVICE-FL,                                             
MFA-TR*        :S-SERVICE-CHARGES,                                              
MFA-TR*        :S-COUNTY,                                                       
MFA-TR*        :S-TOTAL-BTU,                                                    
MFA-TR*        :S-ALT-PHONE-NO,                                                 
MFA-TR*        :S-ALT-PHONE-NO-EXT,                                             
MFA-TR*        :S-MADE-SAFE-DT,                                                 
MFA-TR*        :S-HOME-ALL-DAY-FL,                                              
MFA-TR*        :S-BUSINESS-UNIT,                                                
MFA-TR*        :S-DNP-CRITICAL-CUS,                                             
MFA-TR*        :S-CIRCUIT-ID,                                                   
MFA-TR*        :S-CUST-PHASE-CD,                                                
MFA-TR*        :S-GRID-CELL,                                                    
MFA-TR*        :S-POLE-NO,                                                      
MFA-TR*        :S-ASSIGNED-DATE,                                                
MFA-TR*        :S-COMPLIANCE-DAYS,                                              
MFA-TR*        :S-DUE-DAYS,                                                     
MFA-TR*        :S-MATERIAL-FL,                                                  
MFA-TR*        :S-WORK-START-TIME,                                              
MFA-TR*        :S-WORK-STOP-TIME,                                               
MFA-TR*        :S-WORK-DISTRICT,                                                
MFA-TR*        :S-OPTIMIZE-ORDER,                                               
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-RED-FLAG-SAFETY,                                              
MFA-TR*        :S-RED-FLAG-MAINT,                                               
MFA-TR*        :S-RED-FLAG-STORM,                                               
MFA-TR*        :S-SO-SERVICE-CHRG,                                              
MFA-TR*        :S-GROUP-CODE,                                                   
MFA-TR*        :S-RLSE-NO-1,                                                    
MFA-TR*        :S-ORDER-CANCEL,                                                 
MFA-TR*        :S-SO-COMPL-REMARKS,                                             
MFA-TR*        :S-DATE-RECVED,                                                  
MFA-TR*        :S-COMM-COMMENTS,                                                
MFA-TR*        :S-DBA-NAME,                                                     
MFA-TR*        :S-COMPLIANCE-DATE,                                              
MFA-TR*        :S-TASK-TYPE,                                                    
MFA-TR*        :S-APPT-FL,                                                      
MFA-TR*        :S-SAMPLE-TEST,                                                  
MFA-TR*        :S-HOT-SPOT-FL                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04584_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04584_R2                            
             (                                                          
              RETURN_CODE,                                              
              SO_INST_SEQ_NO,                                           
              APPLIANCE_CD,                                             
              CODE_UTIL_TYPE,                                           
              LEAK_IND,                                                 
              LIGHT_IND,                                                
              REPAIR_IND,                                               
              CUTOFF_IND,                                               
              CAUTION_TAG_IND,                                          
              CONDITION_CD,                                             
              REPLACE_APP_FL,                                           
              INSTALL_DT,                                               
              APPLIANCE_COMMENTS,                                       
              TAG_NO,                                                   
              CAUTION_TAG_DT,                                           
              EQUIPMENT_UNQ                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-SO-INST-SEQ-NO-2,                                     
               :S-APPLIANCE-CD,                                         
               :S-CODE-UTIL-TYPE-2,                                     
               :S-LEAK-IND,                                             
               :S-LIGHT-IND,                                            
               :S-REPAIR-IND,                                           
               :S-CUTOFF-IND,                                           
               :S-CAUTION-TAG-IND,                                      
               :S-CONDITION-CD,                                         
               :S-REPLACE-APP-FL,                                       
               :S-INSTALL-DT,                                           
               :S-APPLIANCE-COMMENTS,                                   
               :S-TAG-NO,                                               
               :S-CAUTION-TAG-DT,                                       
               :S-EQUIPMENT-UNQ                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04584_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SO_INST_SEQ_NO,                                                   
MFA-TR*       APPLIANCE_CD,                                                     
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       LEAK_IND,                                                         
MFA-TR*       LIGHT_IND,                                                        
MFA-TR*       REPAIR_IND,                                                       
MFA-TR*       CUTOFF_IND,                                                       
MFA-TR*       CAUTION_TAG_IND,                                                  
MFA-TR*       CONDITION_CD,                                                     
MFA-TR*       REPLACE_APP_FL,                                                   
MFA-TR*       INSTALL_DT,                                                       
MFA-TR*       APPLIANCE_COMMENTS,                                               
MFA-TR*       TAG_NO,                                                           
MFA-TR*       CAUTION_TAG_DT,                                                   
MFA-TR*       EQUIPMENT_UNQ                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-SO-INST-SEQ-NO-2,                                             
MFA-TR*        :S-APPLIANCE-CD,                                                 
MFA-TR*        :S-CODE-UTIL-TYPE-2,                                             
MFA-TR*        :S-LEAK-IND,                                                     
MFA-TR*        :S-LIGHT-IND,                                                    
MFA-TR*        :S-REPAIR-IND,                                                   
MFA-TR*        :S-CUTOFF-IND,                                                   
MFA-TR*        :S-CAUTION-TAG-IND,                                              
MFA-TR*        :S-CONDITION-CD,                                                 
MFA-TR*        :S-REPLACE-APP-FL,                                               
MFA-TR*        :S-INSTALL-DT,                                                   
MFA-TR*        :S-APPLIANCE-COMMENTS,                                           
MFA-TR*        :S-TAG-NO,                                                       
MFA-TR*        :S-CAUTION-TAG-DT,                                               
MFA-TR*        :S-EQUIPMENT-UNQ                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04584_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04584_R3                            
             (                                                          
              RETURN_CODE,                                              
              SO_INST_SEQ_NO,                                           
              REG_CHARGEABLE_HRS,                                       
              OT_CHARGEABLE_HRS,                                        
              CHARGES_COMMENTS,                                         
              WORK_PERIOD_CD,                                           
              WAIVER_TYPE_CD,                                           
              MATERIAL_CHRG,                                            
              CODE_UTIL_TYPE                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-SO-INST-SEQ-NO-3,                                     
               :S-REG-CHARGEABLE-HRS,                                   
               :S-OT-CHARGEABLE-HRS,                                    
               :S-CHARGES-COMMENTS,                                     
               :S-WORK-PERIOD-CD,                                       
               :S-WAIVER-TYPE-CD,                                       
               :S-MATERIAL-CHRG,                                        
               :S-CODE-UTIL-TYPE-3                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04584_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SO_INST_SEQ_NO,                                                   
MFA-TR*       REG_CHARGEABLE_HRS,                                               
MFA-TR*       OT_CHARGEABLE_HRS,                                                
MFA-TR*       CHARGES_COMMENTS,                                                 
MFA-TR*       WORK_PERIOD_CD,                                                   
MFA-TR*       WAIVER_TYPE_CD,                                                   
MFA-TR*       MATERIAL_CHRG,                                                    
MFA-TR*       CODE_UTIL_TYPE                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-SO-INST-SEQ-NO-3,                                             
MFA-TR*        :S-REG-CHARGEABLE-HRS,                                           
MFA-TR*        :S-OT-CHARGEABLE-HRS,                                            
MFA-TR*        :S-CHARGES-COMMENTS,                                             
MFA-TR*        :S-WORK-PERIOD-CD,                                               
MFA-TR*        :S-WAIVER-TYPE-CD,                                               
MFA-TR*        :S-MATERIAL-CHRG,                                                
MFA-TR*        :S-CODE-UTIL-TYPE-3                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04584_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04584_R4                            
             (                                                          
              RETURN_CODE,                                              
              SO_INST_SEQ_NO,                                           
              CODE_UTIL_TYPE,                                           
              WORK_TYPE_CD,                                             
              WORK_TYPE_DESC,                                           
              METER_NO,                                                 
              IC_NO,                                                    
              MTR_REF_NO,                                               
              CODE_DEST,                                                
              DEST_NO,                                                  
              CODE_MTR_STATUS_WS,                                       
              MTR_READ_VALUE_IS,                                        
              METER_SUPPLYING,                                          
              READ_ROUTE,                                               
              READ_CYCLE,                                               
              SPCL_READ_INSTR,                                          
              MTR_CODE_TIME_PERIOD,                                     
              REG_ID_NO,                                                
              CONSTANT,                                                 
              MTR_NO_DIALS,                                             
              METER_SIZE_ID,                                            
              CODE_METER_LOC,                                           
              METER_POINT_ID,                                           
              SUBSTATION_ID,                                            
              RATE_PLAN_NO,                                             
              CODE_REVENUE_CLASS,                                       
              LOCK_TYPE_ID,                                             
              CODE_MAKE,                                                
              AMPS,                                                     
              NO_WIRES,                                                 
              VOLTAGE,                                                  
              MTR_CONNECT_TYPE_ID,                                      
              CASE_PRESSURE,                                            
              RLSE_NO,                                                  
              RLSE_DATE,                                                
              MTR_MAX_NO_UNITS,                                         
              MTR_MIN_NO_UNITS,                                         
              MTR_USAGE_HIGH_PCT,                                       
              MTR_USAGE_LOW_PCT,                                        
              LAST_MTR_READ_VALUE,                                      
              LAST_MTR_READ_DATE,                                       
              REMOTE_READ_IND,                                          
              MTR_ACCESSIBLE_CD,                                        
              MTR_ACCESSIBLE_DT,                                        
              MTR_ACCESSIBLE_RSN,                                       
              MTR_CODE_STATUS_REASON,                                   
              NUMBER_OF_DRIVE,                                          
              ELEC_MTR_FORM_CD,                                         
              READ_SEQUENCE_NO,                                         
              MTR_RD_DISP_CD,                                           
              INDEX_VALUE_CD,                                           
              NO_READ_DIGITS,                                           
              NO_READ_DECIMALS                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-SO-INST-SEQ-NO-4,                                     
               :S-CODE-UTIL-TYPE-4,                                     
               :S-WORK-TYPE-CD-4,                                       
               :S-WORK-TYPE-DESC-4,                                     
               :S-METER-NO-4,                                           
               :S-IC-NO-4,                                              
               :S-MTR-REF-NO-4,                                         
               :S-CODE-DEST,                                            
               :S-DEST-NO,                                              
               :S-CODE-MTR-STATUS-WS,                                   
               :S-READ-VALUE-IS-4,                                      
               :S-METER-SUPPLYING,                                      
               :S-READ-ROUTE,                                           
               :S-READ-CYCLE,                                           
               :WS-SPCL-READ-INSTR,                                     
               :S-CODE-TIME-PERIOD-4,                                   
               :S-REG-ID-NO-4,                                          
               :S-CONSTANT,                                             
               :S-NO-DIALS-4,                                           
               :S-METER-SIZE-ID,                                        
               :S-CODE-METER-LOC,                                       
               :S-METER-POINT-ID,                                       
               :S-SUBSTATION-ID,                                        
               :S-RATE-PLAN-NO,                                         
               :S-CODE-REVENUE-CLASS,                                   
               :S-LOCK-TYPE-ID,                                         
               :S-CODE-MAKE,                                            
               :S-AMPS,                                                 
               :S-NO-WIRES,                                             
               :S-VOLTAGE,                                              
               :S-MTR-CONNECT-TYPE-ID,                                  
               :S-CASE-PRESSURE,                                        
               :S-RLSE-NO,                                              
               :S-RLSE-DATE,                                            
               :S-MAX-NO-UNITS-4,                                       
               :S-MIN-NO-UNITS-4,                                       
               :S-USAGE-HIGH-PCT-4,                                     
               :S-USAGE-LOW-PCT-4,                                      
               :S-LAST-MTR-READ-VALUE,                                  
               :S-LAST-MTR-READ-DATE,                                   
               :S-REMOTE-READ-IND,                                      
               :S-MTR-ACCESSIBLE-CD,                                    
               :S-MTR-ACCESSIBLE-DT,                                    
               :S-MTR-ACCESSIBLE-RSN,                                   
               :S-CODE-STATUS-REASON-4,                                 
               :S-NUMBER-OF-DRIVE,                                      
               :S-ELEC-MTR-FORM-CD,                                     
               :S-READ-SEQUENCE-NO-4,                                   
               :S-MTR-RD-DISP-CD-4,                                     
               :S-INDEX-VALUE-CD-4,                                     
               :S-NO-READ-DIGITS-4,                                     
               :S-NO-READ-DECIMALS-4                                    
              )       