       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04583.                                         
COB303 DATE-WRITTEN.  DECEMBER 10, 2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CUSTOMER EMAIL ADDRESS.                  *00200000
      *  STATUS CODE VALUES                                            *00200000
      *      +1 = INVALID ACTION CODE                                  *00200000
      *      +2 = 9 EMAIL ADDRESSES ALREADY EXIST                      *00200000
      *      +3 = INPUT EMAIL ADDRESS IS SPACES FOR INSERT             *00200000
      *      +4 = CUSTOMER, ACCOUNT, OR PREMISE NOT PROVIDED           *00200000
      *      +5 = TYPE AND INPUT MISMATCH                              *00200000
      *      +6 = INVALID CUSTOMER TYPE                                *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  12/12/13    FMB      NEW PROGRAM.                             *00290000
P00740*  03/10/15    FMB      FORCE EMAIL ADDRESSES TO LOWERCASE.      *00290000
P00836*  11/10/15    FMB      IF CUSTOMER EMAIL NOT FOUND FOR UPDATE,  *00290000
P00836*                       INSERT IT.                               *00290000
D05317*  11/11/15    FMB      EMAIL PERMISSION DATE TO TIMESTAMP.      *00290000
P00836*  03/15/16    FMB      SET SOURCE BASED ON USERID.              *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04583'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00770000
              INCLUDE TBCSTEML                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBCONEML                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBTHDEML                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTHDPTY                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-CONTACT-ID-CHAR       PIC X(10).                      
           05  WS-CONTACT-ID-NUM        REDEFINES WS-CONTACT-ID-CHAR    
                                        PIC 9(10).                      
           05  WS-THD-PRTY-ID-CHAR      PIC X(10).                      
           05  WS-THD-PRTY-ID-NUM       REDEFINES WS-THD-PRTY-ID-CHAR   
                                        PIC 9(10).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-EMAIL-ADDRESS.                                        
               10 WS-EMAIL-ADDRESS-LEN  PIC S9(4) COMP VALUE 0.         
               10 WS-EMAIL-ADDRESS-TEXT PIC X(100) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04583'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-EMAIL-TYPE-NUM        PIC 9(1)  VALUE 0.              
           05  WS-EMAIL-COUNT           PIC 9(3)  VALUE 0.              
           05  WS-FLAG-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 FLAG-CHANGED                    VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-2                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-ENTITY-TYPE           PIC X(01) VALUE SPACES.         
           05  WS-EMAIL-TYPE-CD         PIC X(02) VALUE SPACES.         
           05  WS-NEW-EMAIL-TYPE-CD     PIC X(02) VALUE SPACES.         
           05  WS-DELETE-TYPE-CD        PIC X(02) VALUE SPACES.         
           05  WS-FIRST-BYTE            PIC X(01) VALUE SPACES.         
           05  WS-SUB1                  PIC 9(01) VALUE 0.              
P00836     05  WS-EMAIL-EXISTS-FL       PIC X(01) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-EMAIL-TYPE-CD        PIC X(02) VALUE SPACES.           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
              DECLARE CUST-EMAIL-CURSOR CURSOR FOR                      
               SELECT EMAIL_TYPE_CD                                     
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
                  AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST-EMAIL-CURSOR CURSOR FOR                              
MFA-TR*        SELECT EMAIL_TYPE_CD                                             
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE THD-EMAIL-CURSOR CURSOR FOR                       
               SELECT EMAIL_TYPE_CD                                     
                 FROM CSS_THD_PRTY_EMAIL WITH(READUNCOMMITTED)                  
                WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                     
                  AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE THD-EMAIL-CURSOR CURSOR FOR                               
MFA-TR*        SELECT EMAIL_TYPE_CD                                             
MFA-TR*          FROM CSS_THD_PRTY_EMAIL                                        
MFA-TR*         WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CONTACT-EMAIL-CURSOR CURSOR FOR                   
               SELECT EMAIL_TYPE_CD                                     
                 FROM CSS_CONTACT_EMAIL WITH(READUNCOMMITTED)                   
                WHERE CONTACT_ID = :3G-CONTACT-ID                       
                  AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-EMAIL-CURSOR CURSOR FOR                           
MFA-TR*        SELECT EMAIL_TYPE_CD                                             
MFA-TR*          FROM CSS_CONTACT_EMAIL                                         
MFA-TR*         WHERE CONTACT_ID = :3G-CONTACT-ID                               
MFA-TR*           AND EMAIL_TYPE_CD LIKE :WS-DELETE-TYPE-CD                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-CUSTOMER-TYPE       PIC X(01).                          
       01  LINK-EMAIL-TYPE-CD       PIC X(02).                          
       01  LINK-EMAIL-ADDRESS       PIC X(100).                         
       01  LINK-EMAIL-MKT-FL        PIC X(01).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-CONTACT-ID          PIC X(10).                          
       01  LINK-THD-PRTY-ID         PIC X(10).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-CUSTOMER-NO,                                       
                LINK-CUSTOMER-TYPE,                                     
                LINK-EMAIL-TYPE-CD,                                     
                LINK-EMAIL-ADDRESS,                                     
                LINK-EMAIL-MKT-FL,                                      
                LINK-USERID,                                            
                LINK-COMMENTS,                                          
                LINK-ACCOUNT-NO,                                        
                LINK-PREMISE-NO,                                        
                LINK-CONTACT-ID,                                        
                LINK-THD-PRTY-ID.                                       
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :S-STATUS-CODE  AS STATUS_CODE,                  
                       :S-EMAIL-TYPE-CD  AS EMAIL_TYPE                  
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :S-STATUS-CODE  AS STATUS_CODE,                          
MFA-TR*                :S-EMAIL-TYPE-CD  AS EMAIL_TYPE                          
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO <= SPACES AND                            
              LINK-ACCOUNT-NO <= SPACES AND                             
              LINK-PREMISE-NO <= SPACES AND                             
              LINK-THD-PRTY-ID <= SPACES AND                            
              LINK-CONTACT-ID <= SPACES                                 
                  MOVE +4 TO S-STATUS-CODE
           END-IF.                             
           IF (LINK-CUSTOMER-TYPE = 'C' OR 'S') AND                     
               LINK-CUSTOMER-NO <= SPACES                               
                   MOVE +5 TO S-STATUS-CODE
           END-IF.                            
           IF LINK-CUSTOMER-TYPE = 'T' AND                              
              LINK-THD-PRTY-ID <= SPACES                                
                  MOVE +5 TO S-STATUS-CODE
           END-IF.                             
           IF LINK-CUSTOMER-TYPE = 'N' AND                              
              LINK-CONTACT-ID <= SPACES                                 
                  MOVE +5 TO S-STATUS-CODE
           END-IF.                             
           IF LINK-CUSTOMER-TYPE = 'C' OR 'S'                           
               MOVE SPACES TO LINK-ACCOUNT-NO                           
                              LINK-PREMISE-NO
           END-IF.                          
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-CONTACT-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-CONTACT-ID
           END-IF.                          
           IF LINK-THD-PRTY-ID NOT NUMERIC                              
               MOVE ZEROES TO LINK-THD-PRTY-ID
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE LINK-CONTACT-ID TO WS-CONTACT-ID-CHAR.                  
           MOVE LINK-THD-PRTY-ID TO WS-THD-PRTY-ID-CHAR.                
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           MOVE LINK-EMAIL-ADDRESS TO WS-EMAIL-ADDRESS.                 
                                                                        
           IF WS-EMAIL-ADDRESS-TEXT <= SPACES AND                       
              LINK-UPDATE-TYPE = 'U'                                    
                  MOVE 'D' TO LINK-UPDATE-TYPE
           END-IF.                         
                                                                        
           EVALUATE LINK-CUSTOMER-TYPE                                  
               WHEN 'C'                                                 
               WHEN 'S'                                                 
                   MOVE WS-CUSTOMER-NO-NUM TO NE-CUSTOMER-NO            
                   IF LINK-CUSTOMER-TYPE = 'C'                          
                       MOVE 'P' TO LINK-CUSTOMER-TYPE                   
                   END-IF                                               
               WHEN 'N'                                                 
                   MOVE WS-CONTACT-ID-NUM TO 3G-CONTACT-ID              
                   MOVE ZEROES TO DW-ACCOUNT-NO                         
                                  DT-CUSTOMER-NO                        
                                  DX-PREMISE-NO                         
                   MOVE SPACES TO WS-ENTITY-TYPE                        
                   PERFORM 7120-SELECT-CONT-ACCT THRU 7120-EXIT         
                   IF WS-ENTITY-TYPE = SPACES                           
                       PERFORM 7130-SELECT-CONT-CUST THRU 7130-EXIT     
                   END-IF                                               
                   IF WS-ENTITY-TYPE = SPACES                           
                       PERFORM 7140-SELECT-CONT-PREM THRU 7140-EXIT     
                   END-IF                                               
               WHEN 'T'                                                 
                   MOVE WS-THD-PRTY-ID-NUM TO 3N-THD-PRTY-ID            
                   PERFORM 7220-SELECT-3RD-PARTY THRU 7220-EXIT         
           END-EVALUATE.                                                
                                                                        
           PERFORM 7800-SELECT-RESP-AREA-ID THRU 7800-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-ACCOUNT-NO-NUM        TO MH-ACCOUNT-NO.              
           MOVE WS-PREMISE-NO-NUM        TO MH-PREMISE-NO.              
           MOVE WS-CUSTOMER-NO-NUM       TO MH-CUSTOMER-NO.             
           MOVE LINK-USERID              TO MH-USER-ID.                 
           EVALUATE LINK-CUSTOMER-TYPE                                  
               WHEN 'P'                                                 
               WHEN 'S'                                                 
                   MOVE 'PANEL087'       TO MH-APPL-PROGRAM-ID          
               WHEN 'T'                                                 
                   MOVE ZW-ACCOUNT-NO    TO MH-ACCOUNT-NO               
                   MOVE 'PANEL037'       TO MH-APPL-PROGRAM-ID          
               WHEN 'N'                                                 
                   EVALUATE WS-ENTITY-TYPE                              
                       WHEN 'A'                                         
                           MOVE DW-ACCOUNT-NO TO MH-ACCOUNT-NO          
                       WHEN 'C'                                         
                           MOVE DT-CUSTOMER-NO TO MH-CUSTOMER-NO        
                       WHEN 'P'                                         
                           MOVE DX-PREMISE-NO TO MH-PREMISE-NO          
                   END-EVALUATE                                         
                   MOVE 'PANEL262'       TO MH-APPL-PROGRAM-ID          
           END-EVALUATE.                                                
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   EVALUATE LINK-CUSTOMER-TYPE                          
                       WHEN 'P'                                         
                       WHEN 'S'                                         
                           IF WS-EMAIL-ADDRESS-TEXT <= SPACES           
                               MOVE +3 TO S-STATUS-CODE                 
                           END-IF                                       
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3000-INSERT-CUST-EMAIL THRU      
                                       3000-EXIT                        
                           END-IF                                       
                       WHEN 'N'                                         
                           IF WS-EMAIL-ADDRESS-TEXT <= SPACES           
                               MOVE +3 TO S-STATUS-CODE                 
                           END-IF                                       
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3100-INSERT-CONTACT-EMAIL THRU   
                                       3100-EXIT                        
                           END-IF                                       
                       WHEN 'T'                                         
                           IF WS-EMAIL-ADDRESS-TEXT <= SPACES           
                               MOVE +3 TO S-STATUS-CODE                 
                           END-IF                                       
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3200-INSERT-3RD-EMAIL THRU       
                                       3200-EXIT                        
                           END-IF                                       
                       WHEN OTHER                                       
                           MOVE +6 TO S-STATUS-CODE                     
                   END-EVALUATE                                         
                   MOVE WS-EMAIL-TYPE-CD TO S-EMAIL-TYPE-CD             
               WHEN 'U'                                                 
                   EVALUATE LINK-CUSTOMER-TYPE                          
                       WHEN 'P'                                         
                       WHEN 'S'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3020-UPDATE-CUST-EMAIL THRU      
                                       3020-EXIT                        
                           END-IF                                       
                       WHEN 'N'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3120-UPDATE-CONTACT-EMAIL THRU   
                                       3120-EXIT                        
                           END-IF                                       
                       WHEN 'T'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3220-UPDATE-3RD-EMAIL THRU       
                                       3220-EXIT                        
                           END-IF                                       
                       WHEN OTHER                                       
                           MOVE +6 TO S-STATUS-CODE                     
                   END-EVALUATE                                         
               WHEN 'D'                                                 
                   EVALUATE LINK-CUSTOMER-TYPE                          
                       WHEN 'P'                                         
                       WHEN 'S'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3030-DELETE-CUST-EMAIL THRU      
                                       3030-EXIT                        
                           END-IF                                       
                       WHEN 'N'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3130-DELETE-CONTACT-EMAIL THRU   
                                       3130-EXIT                        
                           END-IF                                       
                       WHEN 'T'                                         
                           IF S-STATUS-CODE = 0                         
                               PERFORM 3230-DELETE-3RD-EMAIL THRU       
                                       3230-EXIT                        
                           END-IF                                       
                       WHEN OTHER                                       
                           MOVE +6 TO S-STATUS-CODE                     
                   END-EVALUATE                                         
               WHEN OTHER                                               
                   MOVE +1 TO S-STATUS-CODE                             
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-CUST-EMAIL.                                          
                                                                        
           PERFORM 7000-CUST-EMAIL-TYPE-CD THRU 7000-EXIT.              
                                                                        
           IF S-STATUS-CODE = 0                                         
               IF NE-EMAIL-TYPE-CD(2:1) = '0'                           
                   MOVE '1' TO NE-EMAIL-TYPE-CD(2:1)                    
               ELSE                                                     
                   PERFORM 3010-CALC-CUST-EMAIL-TYPE THRU 3010-EXIT     
               END-IF                                                   
               IF S-STATUS-CODE = 0                                     
P00836             PERFORM 3015-CUST-INSERT-PROCESS THRU 3015-EXIT
               END-IF
           END-IF.     
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-CALC-CUST-EMAIL-TYPE.                                       
                                                                        
           IF NE-EMAIL-TYPE-CD(2:1) NOT NUMERIC                         
               MOVE LINK-CUSTOMER-TYPE TO NE-EMAIL-TYPE-CD(1:1)         
               MOVE '1' TO NE-EMAIL-TYPE-CD(2:1)                        
           ELSE                                                         
               MOVE NE-EMAIL-TYPE-CD(2:1) TO WS-EMAIL-TYPE-NUM          
               MOVE WS-EMAIL-TYPE-NUM TO WS-EMAIL-COUNT                 
               ADD +1 TO WS-EMAIL-COUNT                                 
               IF WS-EMAIL-COUNT > 9                                    
                   MOVE +2 TO S-STATUS-CODE                             
               ELSE                                                     
                   MOVE WS-EMAIL-COUNT TO WS-EMAIL-TYPE-NUM             
                   MOVE LINK-CUSTOMER-TYPE TO NE-EMAIL-TYPE-CD(1:1)     
                   MOVE WS-EMAIL-TYPE-NUM TO NE-EMAIL-TYPE-CD(2:1)
               END-IF
           END-IF.     
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 3015-CUST-INSERT-PROCESS.                                        
P00836                                                                  
P00836     MOVE 'H' TO NE-EMAIL-DISP-PREF-CD.                           
P00836     MOVE WS-EMAIL-ADDRESS-LEN TO NE-EMAIL-ADDRESS-TX-LEN.        
P00836     MOVE WS-EMAIL-ADDRESS-TEXT TO                                
P00836          NE-EMAIL-ADDRESS-TX-TEXT.                               
P00836     IF LINK-USERID = 'WEBTRN1'                                   
P00836         MOVE 'W' TO NE-EMAIL-SOURCE-CD                           
P00836     ELSE                                                         
P00836         MOVE 'D' TO NE-EMAIL-SOURCE-CD
           END-IF.                          
P00836     IF LINK-EMAIL-MKT-FL = 'Y' OR 'N'                            
D05317         MOVE WS-CURRENT-TIMESTAMP TO NE-PERMISN-TO-MKT-TS        
P00836         MOVE LINK-EMAIL-MKT-FL TO NE-PERMISN-TO-MKT-FL           
P00836         MOVE +1 TO WS-NULL-3                                     
P00836     ELSE                                                         
P00836         MOVE -1 TO WS-NULL-3                                     
D05317         MOVE SPACES TO NE-PERMISN-TO-MKT-TS                      
P00836                        NE-PERMISN-TO-MKT-FL
           END-IF.                     
P00836     PERFORM 8000-INSERT-CUST-EMAIL THRU 8000-EXIT.               
P00836     MOVE NE-EMAIL-TYPE-CD TO WS-EMAIL-TYPE-CD.                   
P00836     PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
P00836                                                                  
P00836 3015-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       3020-UPDATE-CUST-EMAIL.                                          
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO NE-EMAIL-TYPE-CD.                 
           PERFORM 7010-SELECT-CUST-EMAIL THRU 7010-EXIT.               
P00836     IF WS-EMAIL-EXISTS-FL = 'N'                                  
P00836         PERFORM 3015-CUST-INSERT-PROCESS THRU 3015-EXIT          
P00836         GO TO 3020-EXIT
           END-IF.                                         
           MOVE NE-EMAIL-TYPE-CD TO WS-EMAIL-TYPE-CD.                   
           PERFORM 5100-TRANSHIST-FOR-CUST-UPDATE THRU 5100-EXIT.       
           MOVE WS-EMAIL-ADDRESS-LEN TO NE-EMAIL-ADDRESS-TX-LEN.        
           MOVE WS-EMAIL-ADDRESS-TEXT TO NE-EMAIL-ADDRESS-TX-TEXT.      
           IF FLAG-CHANGED                                              
D05317         MOVE WS-CURRENT-TIMESTAMP TO NE-PERMISN-TO-MKT-TS        
               MOVE LINK-EMAIL-MKT-FL TO NE-PERMISN-TO-MKT-FL
           END-IF.          
           PERFORM 8020-UPDATE-CUST-EMAIL THRU 8020-EXIT.               
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3030-DELETE-CUST-EMAIL.                                          
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO NE-EMAIL-TYPE-CD.                 
           MOVE WS-EMAIL-ADDRESS-LEN TO NE-EMAIL-ADDRESS-TX-LEN.        
           MOVE WS-EMAIL-ADDRESS-TEXT TO NE-EMAIL-ADDRESS-TX-TEXT.      
           MOVE LINK-EMAIL-TYPE-CD(1:1) TO WS-FIRST-BYTE.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE WS-EMAIL-ADDRESS-TEXT TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'EMAIL ADDRESS'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE NE-EMAIL-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'EMAIL TYPE CD'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           PERFORM 8010-DELETE-CUST-EMAIL THRU 8010-EXIT.               
                                                                        
           MOVE LINK-CUSTOMER-TYPE TO WS-DELETE-TYPE-CD(1:1).           
           MOVE '%' TO WS-DELETE-TYPE-CD(2:1).                          
           MOVE 1 TO WS-SUB1.                                           
           PERFORM 7500-OPEN-CUST-EMAIL-CURSOR THRU 7500-EXIT.          
           PERFORM 3035-FETCH-ROWS THRU 3035-EXIT.                      
           PERFORM 7501-CLOSE-CUST-EMAIL-CURSOR THRU 7501-EXIT.         
                                                                        
       3030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3035-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CUST-EMAIL-CURSOR                                  
                INTO :NE-EMAIL-TYPE-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3035-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3035'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           IF NE-EMAIL-TYPE-CD(2:1) = WS-SUB1                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE NE-EMAIL-TYPE-CD(1:1) TO WS-NEW-EMAIL-TYPE-CD(1:1)  
               MOVE WS-SUB1 TO WS-NEW-EMAIL-TYPE-CD(2:1)                
               PERFORM 8030-UPDATE-CUST-EMAIL-TYPE THRU 8030-EXIT
           END-IF.      
                                                                        
           ADD 1 TO WS-SUB1.                                            
                                                                        
           GO TO 3035-FETCH-ROWS.                                       
                                                                        
       3035-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-INSERT-CONTACT-EMAIL.                                       
                                                                        
           PERFORM 7100-CONTACT-EMAIL-TYPE-CD THRU 7100-EXIT.           
                                                                        
           IF S-STATUS-CODE = 0                                         
               IF 3G-EMAIL-TYPE-CD = 'N0'                               
                   MOVE 'N1' TO 3G-EMAIL-TYPE-CD                        
               ELSE                                                     
                   PERFORM 3110-CALC-CONTACT-EMAIL-TYPE THRU 3110-EXIT  
               END-IF                                                   
               IF S-STATUS-CODE = 0                                     
                   MOVE WS-EMAIL-ADDRESS-TEXT TO 3G-EMAIL-ADDRESS-TX    
                   IF LINK-EMAIL-MKT-FL = 'Y' OR 'N'                    
                       MOVE WS-CURRENT-TIMESTAMP TO 3G-PERMISN-TO-MKT-TS
                       MOVE LINK-EMAIL-MKT-FL TO 3G-PERMISN-TO-MKT-FL   
                       MOVE +1 TO WS-NULL-3                             
                   ELSE                                                 
                       MOVE -1 TO WS-NULL-3                             
D05317                 MOVE SPACES TO 3G-PERMISN-TO-MKT-TS              
                                      3G-PERMISN-TO-MKT-FL              
                   END-IF                                               
                   PERFORM 8101-INSERT-CONTACT-EMAIL THRU 8101-EXIT     
                   MOVE 3G-EMAIL-TYPE-CD TO WS-EMAIL-TYPE-CD            
                   PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT
               END-IF
           END-IF.    
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3110-CALC-CONTACT-EMAIL-TYPE.                                    
                                                                        
           IF 3G-EMAIL-TYPE-CD(2:1) NOT NUMERIC                         
               MOVE 'N1' TO 3G-EMAIL-TYPE-CD                            
           ELSE                                                         
               MOVE 3G-EMAIL-TYPE-CD(2:1) TO WS-EMAIL-TYPE-NUM          
               MOVE WS-EMAIL-TYPE-NUM TO WS-EMAIL-COUNT                 
               ADD +1 TO WS-EMAIL-COUNT                                 
               IF WS-EMAIL-COUNT > 9                                    
                   MOVE +2 TO S-STATUS-CODE                             
               ELSE                                                     
                   MOVE WS-EMAIL-COUNT TO WS-EMAIL-TYPE-NUM             
                   MOVE 'N' TO 3G-EMAIL-TYPE-CD(1:1)                    
                   MOVE WS-EMAIL-TYPE-NUM TO 3G-EMAIL-TYPE-CD(2:1)
               END-IF
           END-IF.     
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3120-UPDATE-CONTACT-EMAIL.                                       
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO 3G-EMAIL-TYPE-CD.                 
           PERFORM 7110-SELECT-CONTACT-EMAIL THRU 7110-EXIT.            
           PERFORM 5200-TRANSHIST-FOR-CONT-UPDATE THRU 5200-EXIT.       
           MOVE WS-EMAIL-ADDRESS-TEXT TO 3G-EMAIL-ADDRESS-TX.           
           IF FLAG-CHANGED                                              
D05317         MOVE WS-CURRENT-TIMESTAMP TO 3G-PERMISN-TO-MKT-TS        
               MOVE LINK-EMAIL-MKT-FL TO 3G-PERMISN-TO-MKT-FL
           END-IF.          
           PERFORM 8120-UPDATE-CONTACT-EMAIL THRU 8120-EXIT.            
                                                                        
       3120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3130-DELETE-CONTACT-EMAIL.                                       
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO 3G-EMAIL-TYPE-CD.                 
           MOVE WS-EMAIL-ADDRESS-TEXT TO 3G-EMAIL-ADDRESS-TX.           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE WS-EMAIL-ADDRESS-TEXT TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'CONTACT EMAIL'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 3G-EMAIL-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'EMAIL TYPE CD'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           PERFORM 8110-DELETE-CONTACT-EMAIL THRU 8110-EXIT.            
                                                                        
           MOVE 'N%' TO WS-DELETE-TYPE-CD.                              
           MOVE 1 TO WS-SUB1.                                           
           PERFORM 7700-OPEN-CONTACT-EMAIL-CURSOR THRU 7700-EXIT.       
           PERFORM 3135-FETCH-ROWS THRU 3135-EXIT.                      
           PERFORM 7701-CLOSE-CON-EMAIL-CURSOR THRU 7701-EXIT.          
                                                                        
       3130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3135-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CONTACT-EMAIL-CURSOR                               
                INTO :3G-EMAIL-TYPE-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3135-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3135'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           IF 3G-EMAIL-TYPE-CD(2:1) = WS-SUB1                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 3G-EMAIL-TYPE-CD(1:1) TO WS-NEW-EMAIL-TYPE-CD(1:1)  
               MOVE WS-SUB1 TO WS-NEW-EMAIL-TYPE-CD(2:1)                
               PERFORM 8130-UPDATE-CONTACT-EMAIL-TYPE THRU 8130-EXIT
           END-IF.   
                                                                        
           ADD 1 TO WS-SUB1.                                            
                                                                        
           GO TO 3135-FETCH-ROWS.                                       
                                                                        
       3135-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-INSERT-3RD-EMAIL.                                           
                                                                        
           PERFORM 7200-3RD-EMAIL-TYPE-CD THRU 7200-EXIT.               
                                                                        
           IF S-STATUS-CODE = 0                                         
               IF 3N-EMAIL-TYPE-CD = 'T0'                               
                   MOVE 'T1' TO 3N-EMAIL-TYPE-CD                        
               ELSE                                                     
                   PERFORM 3210-CALC-3RD-EMAIL-TYPE THRU 3210-EXIT      
               END-IF                                                   
               IF S-STATUS-CODE = 0                                     
                   MOVE WS-EMAIL-ADDRESS-TEXT TO 3N-EMAIL-ADDRESS-TX    
                   IF LINK-EMAIL-MKT-FL = 'Y' OR 'N'                    
                       MOVE WS-CURRENT-TIMESTAMP TO 3N-PERMISN-TO-MKT-TS
                       MOVE LINK-EMAIL-MKT-FL TO 3N-PERMISN-TO-MKT-FL   
                       MOVE +1 TO WS-NULL-3                             
                   ELSE                                                 
                       MOVE -1 TO WS-NULL-3                             
D05317                 MOVE SPACES TO 3N-PERMISN-TO-MKT-TS              
                                      3N-PERMISN-TO-MKT-FL              
                   END-IF                                               
                   PERFORM 8200-INSERT-3RD-EMAIL THRU 8200-EXIT         
                   MOVE 3N-EMAIL-TYPE-CD TO WS-EMAIL-TYPE-CD            
                   PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT
               END-IF
           END-IF.    
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3210-CALC-3RD-EMAIL-TYPE.                                        
                                                                        
           IF 3N-EMAIL-TYPE-CD(2:1) NOT NUMERIC                         
               MOVE 'T1' TO 3N-EMAIL-TYPE-CD                            
           ELSE                                                         
               MOVE 3N-EMAIL-TYPE-CD(2:1) TO WS-EMAIL-TYPE-NUM          
               MOVE WS-EMAIL-TYPE-NUM TO WS-EMAIL-COUNT                 
               ADD +1 TO WS-EMAIL-COUNT                                 
               IF WS-EMAIL-COUNT > 9                                    
                   MOVE +2 TO S-STATUS-CODE                             
               ELSE                                                     
                   MOVE WS-EMAIL-COUNT TO WS-EMAIL-TYPE-NUM             
                   MOVE 'T' TO 3N-EMAIL-TYPE-CD(1:1)                    
                   MOVE WS-EMAIL-TYPE-NUM TO 3N-EMAIL-TYPE-CD(2:1)
               END-IF
           END-IF.     
                                                                        
       3210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3220-UPDATE-3RD-EMAIL.                                           
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO 3N-EMAIL-TYPE-CD.                 
           PERFORM 7210-SELECT-3RD-EMAIL THRU 7210-EXIT.                
           PERFORM 5300-TRANSHIST-FOR-3RD-UPDATE THRU 5300-EXIT.        
           MOVE WS-EMAIL-ADDRESS-TEXT TO 3N-EMAIL-ADDRESS-TX.           
           IF FLAG-CHANGED                                              
D05317         MOVE WS-CURRENT-TIMESTAMP TO 3N-PERMISN-TO-MKT-TS        
               MOVE LINK-EMAIL-MKT-FL TO 3N-PERMISN-TO-MKT-FL
           END-IF.          
           PERFORM 8220-UPDATE-3RD-EMAIL THRU 8220-EXIT.                
                                                                        
       3220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3230-DELETE-3RD-EMAIL.                                           
                                                                        
           MOVE LINK-EMAIL-TYPE-CD TO 3N-EMAIL-TYPE-CD.                 
           MOVE WS-EMAIL-ADDRESS-TEXT TO 3N-EMAIL-ADDRESS-TX.           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +75                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE WS-EMAIL-ADDRESS-TEXT TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE '3RD PRTY EMAIL'      TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 3N-EMAIL-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'EMAIL TYPE CD'       TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           PERFORM 8210-DELETE-3RD-EMAIL THRU 8210-EXIT.                
                                                                        
           MOVE 'T%' TO WS-DELETE-TYPE-CD.                              
           MOVE 1 TO WS-SUB1.                                           
           PERFORM 7600-OPEN-THD-EMAIL-CURSOR THRU 7600-EXIT.           
           PERFORM 3235-FETCH-ROWS THRU 3235-EXIT.                      
           PERFORM 7601-CLOSE-THD-EMAIL-CURSOR THRU 7601-EXIT.          
                                                                        
       3230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3235-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH THD-EMAIL-CURSOR                                   
                INTO :3N-EMAIL-TYPE-CD                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 3235-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '3235'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PTY_EMAIL' TO TABLE-1                  
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           IF 3N-EMAIL-TYPE-CD(2:1) = WS-SUB1                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'T' TO WS-NEW-EMAIL-TYPE-CD(1:1)                    
               MOVE WS-SUB1 TO WS-NEW-EMAIL-TYPE-CD(2:1)                
               PERFORM 8230-UPDATE-THD-EMAIL-TYPE THRU 8230-EXIT
           END-IF.       
                                                                        
           ADD 1 TO WS-SUB1.                                            
                                                                        
           GO TO 3235-FETCH-ROWS.                                       
                                                                        
       3235-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           IF WS-EMAIL-ADDRESS-TEXT > SPACES                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +75                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-EMAIL-ADDRESS-TEXT TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMAIL ADDRESS'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-EMAIL-TYPE-CD > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-EMAIL-TYPE-CD      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMAIL TYPE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMAIL-MKT-FL = 'Y' OR 'N'                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMAIL-MKT-FL     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMAIL MKT FL'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMAIL MKT DATE'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-CUST-UPDATE.                                  
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF NE-EMAIL-ADDRESS-TX-TEXT NOT = WS-EMAIL-ADDRESS-TEXT      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +75                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +75                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EMAIL-ADDRESS-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE NE-EMAIL-ADDRESS-TX-TEXT TO MI-PRV-COLUMN-VALUE-TEXT 
              STRING 'EMAIL ADDR '                                      
                     WS-EMAIL-TYPE-CD                                   
                     DELIMITED BY SIZE                                  
                     INTO MI-COLUMN-DESC                                
              END-STRING                                                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF NE-PERMISN-TO-MKT-FL NOT = LINK-EMAIL-MKT-FL              
              MOVE 'YES'                    TO WS-FLAG-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-EMAIL-MKT-FL        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE NE-PERMISN-TO-MKT-FL     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT FL'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
D05317        IF NE-PERMISN-TO-MKT-TS > SPACES                          
                  MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN  
D05317            MOVE NE-PERMISN-TO-MKT-TS TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT DATE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-TRANSHIST-FOR-CONT-UPDATE.                                  
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF 3G-EMAIL-ADDRESS-TX NOT = WS-EMAIL-ADDRESS-TEXT           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +75                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +75                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EMAIL-ADDRESS-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3G-EMAIL-ADDRESS-TX      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'CONTACT EMAIL'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF 3G-PERMISN-TO-MKT-FL NOT = LINK-EMAIL-MKT-FL              
              MOVE 'YES'                    TO WS-FLAG-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-EMAIL-MKT-FL        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3G-PERMISN-TO-MKT-FL     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT FL'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
D05317        IF 3G-PERMISN-TO-MKT-TS > SPACES                          
                  MOVE +26                  TO MI-PRV-COLUMN-VALUE-LEN  
D05317            MOVE 3G-PERMISN-TO-MKT-TS TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT DATE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5300-TRANSHIST-FOR-3RD-UPDATE.                                   
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF 3N-EMAIL-ADDRESS-TX NOT = WS-EMAIL-ADDRESS-TEXT           
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +75                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +75                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-EMAIL-ADDRESS-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3N-EMAIL-ADDRESS-TX      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE '3RD PARTY EMAIL'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF 3N-PERMISN-TO-MKT-FL NOT = LINK-EMAIL-MKT-FL              
              MOVE 'YES'                    TO WS-FLAG-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-EMAIL-MKT-FL        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 3N-PERMISN-TO-MKT-FL     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT FL'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
D05317        IF 3N-PERMISN-TO-MKT-TS > SPACES                          
                  MOVE +26                  TO MI-PRV-COLUMN-VALUE-LEN  
D05317            MOVE 3N-PERMISN-TO-MKT-TS TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                  MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN  
                  MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE 'EMAIL MKT DATE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-CUST-EMAIL-TYPE-CD.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(EMAIL_TYPE_CD)                                 
                INTO :NE-EMAIL-TYPE-CD :WS-NULL-1                        
                FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                      
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = 
                                                    :LINK-CUSTOMER-TYPE    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(EMAIL_TYPE_CD)                                         
MFA-TR*         INTO :NE-EMAIL-TYPE-CD:WS-NULL-1                                
MFA-TR*         FROM CSS_CUST_EMAIL                                             
MFA-TR*        WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                              
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = :LINK-CUSTOMER-TYPE            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE LINK-CUSTOMER-TYPE TO NE-EMAIL-TYPE-CD(1:1) 
                       MOVE '0' TO NE-EMAIL-TYPE-CD(2:1)                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE LINK-CUSTOMER-TYPE TO NE-EMAIL-TYPE-CD(1:1)     
                   MOVE '0' TO NE-EMAIL-TYPE-CD(2:1)                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE LINK-CUSTOMER-TYPE TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-CUST-EMAIL.                                          
                                                                        
           MOVE SPACES TO NE-EMAIL-ADDRESS-TX.                          
                                                                        
           EXEC SQL                                                     
              SELECT EMAIL_ADDRESS_TX,                                  
                     PERMISN_TO_MKT_FL,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), PERMISN_TO_MKT_TS
           , 121), ' ', '-'), ':', '.') PERMISN_TO_MKT_TS                      
                INTO :NE-EMAIL-ADDRESS-TX,                              
                     :NE-PERMISN-TO-MKT-FL,                             
D05317               :NE-PERMISN-TO-MKT-TS :WS-NULL-2                    
                FROM CSS_CUST_EMAIL                                     
               WHERE CUSTOMER_NO   = :NE-CUSTOMER-NO                    
                 AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EMAIL_ADDRESS_TX,                                          
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS                                          
MFA-TR*         INTO :NE-EMAIL-ADDRESS-TX,                                      
MFA-TR*              :NE-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :NE-PERMISN-TO-MKT-TS:WS-NULL-2                            
MFA-TR*         FROM CSS_CUST_EMAIL                                             
MFA-TR*        WHERE CUSTOMER_NO   = :NE-CUSTOMER-NO                            
MFA-TR*          AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00836             MOVE 'Y' TO WS-EMAIL-EXISTS-FL                       
                   IF WS-NULL-2 < 0                                     
D05317                 MOVE SPACES TO NE-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
P00836             MOVE 'N' TO WS-EMAIL-EXISTS-FL                       
                   MOVE 0 TO NE-EMAIL-ADDRESS-TX-LEN                    
                   MOVE SPACES TO NE-EMAIL-ADDRESS-TX-TEXT              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CONTACT-EMAIL-TYPE-CD.                                      
                                                                        
           EXEC SQL                                                     
              SELECT MAX(EMAIL_TYPE_CD)                                 
                INTO :3G-EMAIL-TYPE-CD :WS-NULL-1                        
                FROM CSS_CONTACT_EMAIL WITH(READUNCOMMITTED)                    
               WHERE CONTACT_ID = :3G-CONTACT-ID                        
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = 'N'                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(EMAIL_TYPE_CD)                                         
MFA-TR*         INTO :3G-EMAIL-TYPE-CD:WS-NULL-1                                
MFA-TR*         FROM CSS_CONTACT_EMAIL                                          
MFA-TR*        WHERE CONTACT_ID = :3G-CONTACT-ID                                
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = 'N'                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE 'N0' TO 3G-EMAIL-TYPE-CD                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N0' TO 3G-EMAIL-TYPE-CD                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'N'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-CONTACT-EMAIL.                                       
                                                                        
           EXEC SQL                                                     
              SELECT EMAIL_ADDRESS_TX,                                  
                     PERMISN_TO_MKT_FL,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), PERMISN_TO_MKT_TS
           , 121), ' ', '-'), ':', '.') PERMISN_TO_MKT_TS                      
                INTO :3G-EMAIL-ADDRESS-TX,                              
                     :3G-PERMISN-TO-MKT-FL,                             
D05317               :3G-PERMISN-TO-MKT-TS :WS-NULL-2                    
                FROM CSS_CONTACT_EMAIL                                  
               WHERE CONTACT_ID    = :3G-CONTACT-ID                     
                 AND EMAIL_TYPE_CD = :3G-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EMAIL_ADDRESS_TX,                                          
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS                                          
MFA-TR*         INTO :3G-EMAIL-ADDRESS-TX,                                      
MFA-TR*              :3G-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :3G-PERMISN-TO-MKT-TS:WS-NULL-2                            
MFA-TR*         FROM CSS_CONTACT_EMAIL                                          
MFA-TR*        WHERE CONTACT_ID    = :3G-CONTACT-ID                             
MFA-TR*          AND EMAIL_TYPE_CD = :3G-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
D05317                 MOVE SPACES TO 3G-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO 3G-EMAIL-ADDRESS-TX                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-CONT-ACCT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'A',
              ACCOUNT_NO                                         
                INTO :WS-ENTITY-TYPE,                                   
                     :DW-ACCOUNT-NO                                     
                FROM CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :3G-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'A',                                                       
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DW-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_CONTACT_ACCT                                           
MFA-TR*        WHERE CONTACT_ID = :3G-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DW-ACCOUNT-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SELECT-CONT-CUST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'C',
              CUSTOMER_NO                                        
                INTO :WS-ENTITY-TYPE,                                   
                     :DT-CUSTOMER-NO                                    
                FROM CSS_CONTACT_CUST WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :3G-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'C',                                                       
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CONTACT_CUST                                           
MFA-TR*        WHERE CONTACT_ID = :3G-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DT-CUSTOMER-NO                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-SELECT-CONT-PREM.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'P',
              PREMISE_NO                                         
                INTO :WS-ENTITY-TYPE,                                   
                     :DX-PREMISE-NO                                     
                FROM CSS_CONTACT_PREM WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :3G-CONTACT-ID                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'P',                                                       
MFA-TR*              PREMISE_NO                                                 
MFA-TR*         INTO :WS-ENTITY-TYPE,                                           
MFA-TR*              :DX-PREMISE-NO                                             
MFA-TR*         FROM CSS_CONTACT_PREM                                           
MFA-TR*        WHERE CONTACT_ID = :3G-CONTACT-ID                                
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DX-PREMISE-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CONTACT_PREM' TO TABLE-1                   
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-3RD-EMAIL-TYPE-CD.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(EMAIL_TYPE_CD)                                 
                INTO :3N-EMAIL-TYPE-CD :WS-NULL-1                        
                FROM CSS_THD_PRTY_EMAIL WITH(READUNCOMMITTED)                   
               WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                      
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = 'T'                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(EMAIL_TYPE_CD)                                         
MFA-TR*         INTO :3N-EMAIL-TYPE-CD:WS-NULL-1                                
MFA-TR*         FROM CSS_THD_PRTY_EMAIL                                         
MFA-TR*        WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                              
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = 'T'                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE 'T0' TO 3N-EMAIL-TYPE-CD                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'T0' TO 3N-EMAIL-TYPE-CD                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'T'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-3RD-EMAIL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT EMAIL_ADDRESS_TX,                                  
                     PERMISN_TO_MKT_FL,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), PERMISN_TO_MKT_TS
           , 121), ' ', '-'), ':', '.') PERMISN_TO_MKT_TS                      
                INTO :3N-EMAIL-ADDRESS-TX,                              
                     :3N-PERMISN-TO-MKT-FL,                             
D05317               :3N-PERMISN-TO-MKT-TS :WS-NULL-2                    
                FROM CSS_THD_PRTY_EMAIL                                 
               WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                    
                 AND EMAIL_TYPE_CD = :3N-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EMAIL_ADDRESS_TX,                                          
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS                                          
MFA-TR*         INTO :3N-EMAIL-ADDRESS-TX,                                      
MFA-TR*              :3N-PERMISN-TO-MKT-FL,                                     
MFA-TR*              :3N-PERMISN-TO-MKT-TS:WS-NULL-2                            
MFA-TR*         FROM CSS_THD_PRTY_EMAIL                                         
MFA-TR*        WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                            
MFA-TR*          AND EMAIL_TYPE_CD = :3N-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
D05317                 MOVE SPACES TO 3N-PERMISN-TO-MKT-TS              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO 3N-EMAIL-ADDRESS-TX                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-SELECT-3RD-PARTY.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                INTO :ZW-ACCOUNT-NO                                     
                FROM CSS_THD_PRTY                                       
               WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :ZW-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_THD_PRTY                                               
MFA-TR*        WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                            
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7220'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY'   TO TABLE-1                     
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-CUST-EMAIL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               OPEN CUST-EMAIL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7501-CLOSE-CUST-EMAIL-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE CUST-EMAIL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7501'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-OPEN-THD-EMAIL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN THD-EMAIL-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7601-CLOSE-THD-EMAIL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE THD-EMAIL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7601'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7601-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-OPEN-CONTACT-EMAIL-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               OPEN CONTACT-EMAIL-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                 
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7701-CLOSE-CON-EMAIL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE CONTACT-EMAIL-CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7701'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7701-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-CUST-EMAIL.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_EMAIL                                
                   ( CUSTOMER_NO,                                       
                     EMAIL_TYPE_CD,                                     
                     EMAIL_DISP_PREF_CD,                                
                     EMAIL_ADDRESS_TX,                                  
                     EMAIL_SOURCE_CD,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_TS)                                 
              VALUES                                                    
                   (:NE-CUSTOMER-NO,                                    
                    :NE-EMAIL-TYPE-CD,                                  
                    :NE-EMAIL-DISP-PREF-CD,                             
P00740              LOWER(:NE-EMAIL-ADDRESS-TX),                        
                    :NE-EMAIL-SOURCE-CD,                                
                    :NE-PERMISN-TO-MKT-FL,                              
D05317              CIS.CHAR2TIMESTAMP(:NE-PERMISN-TO-MKT-TS :WS-NULL-3
              ))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_EMAIL                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              EMAIL_TYPE_CD,                                             
MFA-TR*              EMAIL_DISP_PREF_CD,                                        
MFA-TR*              EMAIL_ADDRESS_TX,                                          
MFA-TR*              EMAIL_SOURCE_CD,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:NE-CUSTOMER-NO,                                            
MFA-TR*             :NE-EMAIL-TYPE-CD,                                          
MFA-TR*             :NE-EMAIL-DISP-PREF-CD,                                     
MFA-TR*             LOWER(:NE-EMAIL-ADDRESS-TX),                                
MFA-TR*             :NE-EMAIL-SOURCE-CD,                                        
MFA-TR*             :NE-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :NE-PERMISN-TO-MKT-TS:WS-NULL-3)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'EMAIL_ADDRESS'      TO TABLE-ELEMENT-2              
              MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE WS-EMAIL-ADDRESS-TEXT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-DELETE-CUST-EMAIL.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_EMAIL                                
               WHERE CUSTOMER_NO        = :NE-CUSTOMER-NO               
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = :WS-FIRST-BYTE         
P00740           AND EMAIL_ADDRESS_TX   = LOWER(:NE-EMAIL-ADDRESS-TX)   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_EMAIL                                        
MFA-TR*        WHERE CUSTOMER_NO        = :NE-CUSTOMER-NO                       
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = :WS-FIRST-BYTE                 
MFA-TR*          AND EMAIL_ADDRESS_TX   = LOWER(:NE-EMAIL-ADDRESS-TX)           
MFA-TR*       QUERYNO 8010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL TYPE CD'      TO TABLE-ELEMENT-1              
              MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-UPDATE-CUST-EMAIL.                                          
                                                                        
D05317     IF NE-PERMISN-TO-MKT-TS > ' '                                
               MOVE +1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE -1 TO WS-NULL-3
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_EMAIL                                     
P00740           SET EMAIL_ADDRESS_TX  = LOWER(:NE-EMAIL-ADDRESS-TX),   
                     PERMISN_TO_MKT_FL = :NE-PERMISN-TO-MKT-FL,         
D05317               PERMISN_TO_MKT_TS = CIS.CHAR2TIMESTAMP(
                                                 :NE-PERMISN-TO-MKT-TS 
                                                            :WS-NULL-3)
               WHERE CUSTOMER_NO       = :NE-CUSTOMER-NO                
                 AND EMAIL_TYPE_CD     = :NE-EMAIL-TYPE-CD              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_EMAIL                                             
MFA-TR*          SET EMAIL_ADDRESS_TX  = LOWER(:NE-EMAIL-ADDRESS-TX),           
MFA-TR*              PERMISN_TO_MKT_FL = :NE-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_TS = :NE-PERMISN-TO-MKT-TS:WS-NULL-3        
MFA-TR*        WHERE CUSTOMER_NO       = :NE-CUSTOMER-NO                        
MFA-TR*          AND EMAIL_TYPE_CD     = :NE-EMAIL-TYPE-CD                      
MFA-TR*       QUERYNO 8020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-UPDATE-CUST-EMAIL-TYPE.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_EMAIL                                     
                 SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD              
               WHERE CUSTOMER_NO   = :NE-CUSTOMER-NO                    
                 AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_EMAIL                                             
MFA-TR*          SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD                      
MFA-TR*        WHERE CUSTOMER_NO   = :NE-CUSTOMER-NO                            
MFA-TR*          AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 8030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8101-INSERT-CONTACT-EMAIL.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_EMAIL                             
                   ( CONTACT_ID,                                        
                     EMAIL_TYPE_CD,                                     
                     EMAIL_ADDRESS_TX,                                  
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_TS)                                 
              VALUES                                                    
                   (:3G-CONTACT-ID,                                     
                    :3G-EMAIL-TYPE-CD,                                  
P00740              LOWER(:3G-EMAIL-ADDRESS-TX),                        
                    :3G-PERMISN-TO-MKT-FL,                              
D05317              CIS.CHAR2TIMESTAMP(:3G-PERMISN-TO-MKT-TS :WS-NULL-3
              ))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT_EMAIL                                     
MFA-TR*            ( CONTACT_ID,                                                
MFA-TR*              EMAIL_TYPE_CD,                                             
MFA-TR*              EMAIL_ADDRESS_TX,                                          
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:3G-CONTACT-ID,                                             
MFA-TR*             :3G-EMAIL-TYPE-CD,                                          
MFA-TR*             LOWER(:3G-EMAIL-ADDRESS-TX),                                
MFA-TR*             :3G-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :3G-PERMISN-TO-MKT-TS:WS-NULL-3)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8101'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 'EMAIL_ADDRESS'      TO TABLE-ELEMENT-2              
              MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE WS-EMAIL-ADDRESS-TEXT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8110-DELETE-CONTACT-EMAIL.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_EMAIL                             
               WHERE CONTACT_ID    = :3G-CONTACT-ID                     
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = 'N'                    
P00740           AND EMAIL_ADDRESS_TX  = LOWER(:3G-EMAIL-ADDRESS-TX)    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_EMAIL                                     
MFA-TR*        WHERE CONTACT_ID    = :3G-CONTACT-ID                             
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = 'N'                            
MFA-TR*          AND EMAIL_ADDRESS_TX  = LOWER(:3G-EMAIL-ADDRESS-TX)            
MFA-TR*       QUERYNO 8110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8110'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL TYPE CD'      TO TABLE-ELEMENT-1              
              MOVE 3G-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8120-UPDATE-CONTACT-EMAIL.                                       
                                                                        
D05317     IF 3G-PERMISN-TO-MKT-TS > ' '                                
               MOVE +1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE -1 TO WS-NULL-3
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_EMAIL                                  
P00740           SET EMAIL_ADDRESS_TX  = LOWER(:3G-EMAIL-ADDRESS-TX),   
                     PERMISN_TO_MKT_FL = :3G-PERMISN-TO-MKT-FL,         
D05317               PERMISN_TO_MKT_TS = CIS.CHAR2TIMESTAMP(
                                                 :3G-PERMISN-TO-MKT-TS 
                                                            :WS-NULL-3)
               WHERE CONTACT_ID        = :3G-CONTACT-ID                 
                 AND EMAIL_TYPE_CD     = :3G-EMAIL-TYPE-CD              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_EMAIL                                          
MFA-TR*          SET EMAIL_ADDRESS_TX  = LOWER(:3G-EMAIL-ADDRESS-TX),           
MFA-TR*              PERMISN_TO_MKT_FL = :3G-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_TS = :3G-PERMISN-TO-MKT-TS:WS-NULL-3        
MFA-TR*        WHERE CONTACT_ID        = :3G-CONTACT-ID                         
MFA-TR*          AND EMAIL_TYPE_CD     = :3G-EMAIL-TYPE-CD                      
MFA-TR*       QUERYNO 8120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8120'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 3G-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8130-UPDATE-CONTACT-EMAIL-TYPE.                                  
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_EMAIL                                  
                 SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD              
               WHERE CONTACT_ID    = :3G-CONTACT-ID                     
                 AND EMAIL_TYPE_CD = :3G-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_EMAIL                                          
MFA-TR*          SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD                      
MFA-TR*        WHERE CONTACT_ID    = :3G-CONTACT-ID                             
MFA-TR*          AND EMAIL_TYPE_CD = :3G-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 8130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8130'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                      
              MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1              
              MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 3G-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-INSERT-3RD-EMAIL.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_THD_PRTY_EMAIL                            
                   ( THD_PRTY_ID,                                       
                     EMAIL_TYPE_CD,                                     
                     EMAIL_ADDRESS_TX,                                  
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_TS)                                 
              VALUES                                                    
                   (:3N-THD-PRTY-ID,                                    
                    :3N-EMAIL-TYPE-CD,                                  
P00740              LOWER(:3N-EMAIL-ADDRESS-TX),                        
                    :3N-PERMISN-TO-MKT-FL,                              
D05317              CIS.CHAR2TIMESTAMP(:3N-PERMISN-TO-MKT-TS :WS-NULL-3
              ))                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_THD_PRTY_EMAIL                                    
MFA-TR*            ( THD_PRTY_ID,                                               
MFA-TR*              EMAIL_TYPE_CD,                                             
MFA-TR*              EMAIL_ADDRESS_TX,                                          
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_TS)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:3N-THD-PRTY-ID,                                            
MFA-TR*             :3N-EMAIL-TYPE-CD,                                          
MFA-TR*             LOWER(:3N-EMAIL-ADDRESS-TX),                                
MFA-TR*             :3N-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :3N-PERMISN-TO-MKT-TS:WS-NULL-3)                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE 'EMAIL_ADDRESS'      TO TABLE-ELEMENT-2              
              MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE WS-EMAIL-ADDRESS-TEXT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-3RD-EMAIL.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_THD_PRTY_EMAIL                            
               WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                    
                 AND CIS.SUBSTR3(EMAIL_TYPE_CD,1,1) = 'T'                    
P00740           AND EMAIL_ADDRESS_TX  = LOWER(:3N-EMAIL-ADDRESS-TX)    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_THD_PRTY_EMAIL                                    
MFA-TR*        WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                            
MFA-TR*          AND SUBSTR(EMAIL_TYPE_CD,1,1) = 'T'                            
MFA-TR*          AND EMAIL_ADDRESS_TX  = LOWER(:3N-EMAIL-ADDRESS-TX)            
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL TYPE CD'      TO TABLE-ELEMENT-1              
              MOVE 3N-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8220-UPDATE-3RD-EMAIL.                                           
                                                                        
D05317     IF 3N-PERMISN-TO-MKT-TS > ' '                                
               MOVE +1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE -1 TO WS-NULL-3
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY_EMAIL                                 
P00740           SET EMAIL_ADDRESS_TX  = LOWER(:3N-EMAIL-ADDRESS-TX),   
                     PERMISN_TO_MKT_FL = :3N-PERMISN-TO-MKT-FL,         
D05317               PERMISN_TO_MKT_TS = CIS.CHAR2TIMESTAMP(
                                                 :3N-PERMISN-TO-MKT-TS 
                                                            :WS-NULL-3)
               WHERE THD_PRTY_ID       = :3N-THD-PRTY-ID                
                 AND EMAIL_TYPE_CD     = :3N-EMAIL-TYPE-CD              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY_EMAIL                                         
MFA-TR*          SET EMAIL_ADDRESS_TX  = LOWER(:3N-EMAIL-ADDRESS-TX),           
MFA-TR*              PERMISN_TO_MKT_FL = :3N-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_TS = :3N-PERMISN-TO-MKT-TS:WS-NULL-3        
MFA-TR*        WHERE THD_PRTY_ID       = :3N-THD-PRTY-ID                        
MFA-TR*          AND EMAIL_TYPE_CD     = :3N-EMAIL-TYPE-CD                      
MFA-TR*       QUERYNO 8220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 3N-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8230-UPDATE-THD-EMAIL-TYPE.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY_EMAIL                                 
                 SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD              
               WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                    
                 AND EMAIL_TYPE_CD = :3N-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY_EMAIL                                         
MFA-TR*          SET EMAIL_TYPE_CD = :WS-NEW-EMAIL-TYPE-CD                      
MFA-TR*        WHERE THD_PRTY_ID   = :3N-THD-PRTY-ID                            
MFA-TR*          AND EMAIL_TYPE_CD = :3N-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 8230                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8230'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                      
              MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1              
              MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1            
              MOVE 'EMAIL_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 3N-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8230-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
