       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04582.                                         
COB303 DATE-WRITTEN.  NOVEMBER 15,2012.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *        
      *                                                                *        
      *  PROGRAM:       CSR04582                                       *        
      *  CALLING SP:    REQUGETACCTMULTIPYMTINFOBUSINESSOP             *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ACCOUNT DATA, NAME AND RECEIVABLES INFO*        
      *  FOR MULTI PAYMENT ENTRY SCREEN.                               *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/15/12  LG41184    INITIAL PROGRAM VERSION                  *        
      *  11/07/13  LG41184    ADD CPD00068 CALL FOR DNP DELINQ LIMIT.  *        
PRJ586*  02/18/16  AP40911    1.CHANGE PROFILE054 TO PROFILE055        *        
      *                       2.ADD BILL IMMEDIATE DEPOSIT MESSAGE     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04582'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04582 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *  CSS_ACCOUNT     AT                                            *        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *  CSS_NAME_ACCT_XREF     HT                                              
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_NAME      DQ                                                       
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *  CSS_ADDR_FORMATTED     DY                                              
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_ZIP_CODE     A4                                                    
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *  CSS_AR_CNTL     AC                                            *        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_SO_DATA       VO                                          *        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *  CSS_SO_ORDER_INST    VI                                                
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *  CSS_RECONNECT     DL                                                   
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_CREDIT_PROFILE  CZ                                        *        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_DELINQUENCY     C8                                        *        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *  HST_ACCOUNT                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
      *  CSS_BUS_RULE_XREF   1T                                                 
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_CHRG_OFF   CO                                                      
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
      *  CSS_DEP_REQ    DR                                                      
           EXEC SQL                                                     00010000
              INCLUDE TBDEPREQ                                          00020000
           END-EXEC.                                                    00030000
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
           COPY CWS00011.                                                       
           COPY CWS00056.                                                       
           COPY CWS00068.                                                       
                                                                        
      ******************************************************************        
      *  ERROR HANDLING                                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-LITERAL.                                                  
           05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR04582'.      
           05  MCSCB068                PIC  X(08) VALUE 'MCSCB068'.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-ACCOUNT-NO-CHAR      PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO-CHAR           
                                       PIC 9(13).                       
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE 0.       
           05  WS-TRANSFER-FLAG        PIC X(01) VALUE 'N'.             
           05  WS-HST-ACCOUNT-NO       PIC S9(13) COMP-3 VALUE 0.       
           05  WS-FORMAT-ACCT-NUM      PIC 9(13) VALUE ZEROES.          
           05  WS-FORMAT-ACCT          PIC X(16) VALUE SPACES.          
           05  WS-ACCT-NAME            PIC X(90)  VALUE SPACES.         
           05  WS-CASH-ONLY-FL         PIC X(01)  VALUE 'N'.            
           05  WS-ARCHIVE-IND          PIC X(01)  VALUE 'N'.            
           05  WS-RTN-CHECK-EXISTS     PIC X(01)  VALUE 'N'.            
           05  WS-COMPLEX-AR-EXISTS    PIC X(01)  VALUE 'N'.            
           05  WS-ADDRESS              PIC X(70)  VALUE SPACES.         
           05  WS-ITEM-DESC            PIC X(30)  VALUE  SPACES.        
           05  WS-ORDER-STATE          PIC X(25)  VALUE SPACES.         
           05  WS-SO-DATE              PIC X(10)  VALUE SPACES.         
           05  WS-SO-DISPLAY-DATE      PIC X(10)  VALUE SPACES.         
           05  WS-WOFF-YEARS           PIC S9(9)V COMP-3 VALUE 0.       
           05  WS-DISPLAY-YEARS        PIC 99     VALUE 0.              
           05  WS-WOFF-DT              PIC X(10)  VALUE SPACES.         
           05  WS-GASONLY-RECONCT      PIC X(01)  VALUE SPACE.          
                                                                        
           05  WS-FINAL-NULL-IND       PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-AMT             PIC S9(04) COMP VALUE +0.        
           05  WS-GTT02-DECLARED       PIC X(01) VALUE 'N'.             
           05  WS-DEP-REQ-FOUND        PIC  X(01) VALUE 'N'.            
           05  WS-BILL-IMMEDIATE       PIC  X(01) VALUE 'I'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  GTT-RETURN-FIELDS-1.                                         
           05  S-RETURN-CODE-1        PIC S9(9)     COMP   VALUE 0.     
           05  S-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.       
           05  S-CUSTOMER-NO          PIC S9(10)V COMP-3 VALUE 0.       
           05  S-PREMISE-NO           PIC S9(10)V COMP-3 VALUE 0.       
           05  S-COMPANY-NO           PIC X(02)     VALUE SPACES.       
           05  S-CUSTOMER-NAME        PIC X(90)     VALUE SPACES.       
           05  S-ADDRESS              PIC X(70)     VALUE SPACES.       
           05  S-TOWN                 PIC X(26) VALUE SPACES.           
                                                                        
           05  S-CODE-ACCT-STAT       PIC X(01)     VALUE SPACE.        
           05  S-TOTAL-AR-BALANCE     PIC S9(11)V99 COMP-3 VALUE +0.    
           05  S-ACCT-XFER-TO         PIC S9(13)V COMP-3 VALUE 0.       
           05  S-AT-LAST-UPDATE-TS    PIC  X(26)      VALUE SPACES.     
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
           05  S-DNP-RECON-AMT        PIC S9(11)V99 COMP-3 VALUE +0.    
           05  S-DNP-DELINQ-LIMIT     PIC S9(11)V99 COMP-3 VALUE +0.    
           05  S-GASONLY-RECONCT      PIC X(01) VALUE SPACE.            
                                                                        
       01  GTT-RETURN-FIELDS-2.                                         
           05 S-RETURN-CODE-2         PIC S9(9) COMP VALUE 0.           
           05 S-BUS-RULE-ID           PIC X(10) VALUE SPACES.           
           05 S-RULE-RESULT-CD        PIC X(10) VALUE SPACES.           
           05 S-BUS-RULE-XREF-ID      PIC X(26) VALUE SPACES.           
           05 S-MESSAGE-PARM          PIC X(200) VALUE SPACES.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE-1     AS RETURN_CODE,             
                       :S-ACCOUNT-NO        AS ACCOUNT_NO,              
                       :S-CUSTOMER-NO       AS CUSTOMER_NO,             
                       :S-PREMISE-NO        AS PREMISE_NO,              
                       :S-COMPANY-NO        AS COMPANY_NO,              
                       :S-CUSTOMER-NAME     AS CUSTOMER_NAME,           
                       :S-ADDRESS           AS ADDRESS,                 
                       :S-TOWN              AS TOWN,                    
                       :S-CODE-ACCT-STAT    AS ACCT_STATUS,             
                       :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,        
                       :S-ACCT-XFER-TO      AS ACCT_XFER_TO,            
                       :S-AT-LAST-UPDATE-TS AS ACCT_LAST_UPDATE_TS,     
                       :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,           
                       :S-DNP-RECON-AMT     AS DNP_RECON_AMT,           
                       :S-DNP-DELINQ-LIMIT  AS DNP_DELINQ_LIMIT,        
                       :S-GASONLY-RECONCT   AS RECONNECT_GASONLY        
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                     
MFA-TR*                :S-ACCOUNT-NO        AS ACCOUNT_NO,                      
MFA-TR*                :S-CUSTOMER-NO       AS CUSTOMER_NO,                     
MFA-TR*                :S-PREMISE-NO        AS PREMISE_NO,                      
MFA-TR*                :S-COMPANY-NO        AS COMPANY_NO,                      
MFA-TR*                :S-CUSTOMER-NAME     AS CUSTOMER_NAME,                   
MFA-TR*                :S-ADDRESS           AS ADDRESS,                         
MFA-TR*                :S-TOWN              AS TOWN,                            
MFA-TR*                :S-CODE-ACCT-STAT    AS ACCT_STATUS,                     
MFA-TR*                :S-TOTAL-AR-BALANCE  AS TOTAL_AR_BALANCE,                
MFA-TR*                :S-ACCT-XFER-TO      AS ACCT_XFER_TO,                    
MFA-TR*                :S-AT-LAST-UPDATE-TS AS ACCT_LAST_UPDATE_TS,             
MFA-TR*                :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,                   
MFA-TR*                :S-DNP-RECON-AMT     AS DNP_RECON_AMT,                   
MFA-TR*                :S-DNP-DELINQ-LIMIT  AS DNP_DELINQ_LIMIT,                
MFA-TR*                :S-GASONLY-RECONCT   AS RECONNECT_GASONLY                
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE           AS RETURN_CODE,             
                      BUS_RULE_ID           AS BUS_RULE_ID,             
                      RULE_RESULT_CD        AS RULE_RESULT_CD,          
                      BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID,        
                      MESSAGE_PARM          AS MESSAGE_PARM             
                FROM #CSR04582_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE           AS RETURN_CODE,                     
MFA-TR*               BUS_RULE_ID           AS BUS_RULE_ID,                     
MFA-TR*               RULE_RESULT_CD        AS RULE_RESULT_CD,                  
MFA-TR*               BUS_RULE_XREF_ID      AS BUS_RULE_XREF_ID,                
MFA-TR*               MESSAGE_PARM          AS MESSAGE_PARM                     
MFA-TR*         FROM SESSION.CSR04582_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2         AS RETURN_CODE,          
                      :S-BUS-RULE-ID           AS BUS_RULE_ID,          
                      :S-RULE-RESULT-CD        AS RULE_RESULT_CD,       
                      :S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID,     
                      :S-MESSAGE-PARM          AS MESSAGE_PARM          
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2         AS RETURN_CODE,                  
MFA-TR*               :S-BUS-RULE-ID           AS BUS_RULE_ID,                  
MFA-TR*               :S-RULE-RESULT-CD        AS RULE_RESULT_CD,               
MFA-TR*               :S-BUS-RULE-XREF-ID      AS BUS_RULE_XREF_ID,             
MFA-TR*               :S-MESSAGE-PARM          AS MESSAGE_PARM                  
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 LINK-ACCOUNT-NO         PIC X(13).                            
                                                                        
       PROCEDURE DIVISION USING LINK-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N'                     TO WS-GTT02-DECLARED.           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT2.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04582_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04582_R2
              (                                                          
               RETURN_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               RULE_RESULT_CD CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MESSAGE_PARM CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT2'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04582_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE 'Y'                         TO WS-GTT02-DECLARED.       
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
              MOVE ZEROES                 TO LINK-ACCOUNT-NO
           END-IF.           
           MOVE LINK-ACCOUNT-NO           TO WS-ACCOUNT-NO-CHAR.        
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO.             
                                                                        
           IF WS-ACCOUNT-NO EQUAL ZEROES                                
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                    TO S-RETURN-CODE-1,           
                                             S-RETURN-CODE-2            
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO                TO AT-ACCOUNT-NO,          
                                                HT-ACCOUNT-NO,          
                                                DR-ACCOUNT-NO.          
           MOVE ZEROS                        TO HA-ACCT-XFER-TO.        
           MOVE 'PYMTENTRY'                  TO 1T-BUS-PROCESS-ID.      
                                                                        
           PERFORM 7250-SELECT-ACCOUNT       THRU 7250-EXIT.            
           IF (AT-AR-XFER-IND = 'Y' AND AT-ACCT-XFER-TO > 0) OR         
                                       (HA-ACCT-XFER-TO > 0)            
              MOVE AT-ACCT-XFER-TO           TO AT-ACCOUNT-NO,          
                                                HT-ACCOUNT-NO           
              MOVE 'Y'                       TO WS-TRANSFER-FLAG        
              PERFORM 7250-SELECT-ACCOUNT    THRU 7250-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 2200-BUILD-RESULT-1       THRU 2200-EXIT.            
           PERFORM 2250-BUILD-RULE-RESULT-2  THRU 2250-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT-1.                                           *        
      ******************************************************************        
       2200-BUILD-RESULT-1.                                             
                                                                        
           MOVE AT-ACCOUNT-NO                 TO S-ACCOUNT-NO.          
           MOVE AT-CUSTOMER-NO                TO S-CUSTOMER-NO          
           MOVE AT-PREMISE-NO                 TO S-PREMISE-NO           
           MOVE AT-COMPANY-NO                 TO S-COMPANY-NO           
           MOVE AT-CODE-ACCT-STAT             TO S-CODE-ACCT-STAT       
           MOVE AT-TOTAL-AR-BALANCE           TO S-TOTAL-AR-BALANCE     
           MOVE AT-ACCT-XFER-TO               TO S-ACCT-XFER-TO         
           MOVE AT-LAST-UPDATE-TS             TO S-AT-LAST-UPDATE-TS.   
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT. 
                                                                        
           PERFORM 7100-SELECT-ACCT-NAME   THRU 7100-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF DQ-NAME-FORMAT = 'B'                                   
                 MOVE DQ-FULL-NAME            TO S-CUSTOMER-NAME        
              ELSE                                                      
                 MOVE WS-ACCT-NAME            TO S-CUSTOMER-NAME        
              END-IF                                                    
              MOVE WS-ADDRESS                 TO S-ADDRESS              
              MOVE A4-TOWN                    TO S-TOWN                 
           END-IF.                                                      
                                                                        
           ADD 1         TO CTR-ROWS.                                   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2250-BUILD-RULE-RESULT-2.                                               
      ******************************************************************        
       2250-BUILD-RULE-RESULT-2.                                        
                                                                        
      ** ARCHIVED ACCOUNT                                                       
           IF WS-ARCHIVE-IND = 'Y'                                      
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PYMT000007'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF  THRU 7310-EXIT            
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT            
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
      ** INACTIVE ACCOUNT                                                       
           IF AT-CODE-ACCT-STAT = 'J'                                   
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PYMT000001'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF   THRU 7310-EXIT           
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2     THRU 0102-EXIT           
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
      ** SCEG DEBT > 6 YEARS                                                    
           IF AT-COMPANY-NO = '01' AND AT-CODE-ACCT-STAT = 'S'          
              PERFORM 7335-SELECT-DELINQUENCY      THRU 7335-EXIT       
              IF AT-ACCT-FINALED-DT(1:10) < WS-WOFF-DT                  
                 PERFORM 7375-SELECT-CHRG-OFF      THRU 7375-EXIT       
                 IF CO-AMT-TRANS > 0                                    
                    INITIALIZE GTT-RETURN-FIELDS-2                      
                    MOVE 0                   TO S-RETURN-CODE-2         
                    MOVE 'PROFILE023'        TO S-BUS-RULE-ID           
                    PERFORM 7310-GET-BUS-RULE-XREF THRU 7310-EXIT       
                    MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID      
                    MOVE 'P'                 TO S-RULE-RESULT-CD        
                    IF WS-GTT02-DECLARED = 'N'                          
                       PERFORM 0102-DECLARE-GTT2   THRU 0102-EXIT       
                    END-IF                                              
                    PERFORM 8200-SEND-RESULT-2     THRU 8200-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ** ACCT TRANSFERRED                                                       
           IF WS-TRANSFER-FLAG = 'Y'                                    
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
PRJ586        MOVE 'PROFILE055'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF  THRU 7310-EXIT            
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
PRJ586        MOVE WS-ACCOUNT-NO       TO S-MESSAGE-PARM                
                                                                        
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT            
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
      **   BANKRUPT ACCOUNT                                                     
           IF AT-BANKRUPTCY-IND = 'B'                                   
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PROFILE009'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF   THRU 7310-EXIT           
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2     THRU 0102-EXIT           
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
      ** CASH ONLY OR UNPAID NSA/NSN                                            
           PERFORM 7325-SELECT-CRED-PROF       THRU 7325-EXIT.          
           IF WS-CASH-ONLY-FL NOT EQUAL 'Y'                             
              PERFORM 7345-GET-RETURN-CHECK    THRU 7345-EXIT
           END-IF.          
           IF (WS-CASH-ONLY-FL = 'Y' OR WS-RTN-CHECK-EXISTS = 'Y')      
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PROFILE016'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF   THRU 7310-EXIT           
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2     THRU 0102-EXIT           
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2       THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
      ** CHECK FOR RECEIVABLES WITH PPL >= 50                                   
           PERFORM 7355-SELECT-AR-CNTL        THRU 7355-EXIT.           
           IF WS-COMPLEX-AR-EXISTS = 'Y'                                
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PYMT000004'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF  THRU 7310-EXIT            
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT            
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
      ** DNP /RECONNECT ORDERS                                                  
           INITIALIZE GTT-RETURN-FIELDS-2                               
           MOVE AT-ACCOUNT-NO       TO VO-ACCOUNT-NO                    
           PERFORM 7365-SELECT-DNP-DET  THRU 7365-EXIT                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE VO-ORDER-TYPE-CD                                 
                 WHEN 'DNP01'                                           
                    MOVE VO-ORDER-TYPE-CD TO S-ORDER-TYPE-CD            
                    IF VO-ORDER-STATE-CD = 'A'                          
                       PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT   
                    END-IF                                              
                    MOVE WS-AMT-DNP-BAL        TO S-DNP-RECON-AMT       
                    MOVE WS-NOTICE-DNP-LIMIT   TO S-DNP-DELINQ-LIMIT    
                    MOVE 'PROFILE041'     TO S-BUS-RULE-ID              
                 WHEN 'FM006'                                           
                    MOVE VO-ORDER-TYPE-CD TO S-ORDER-TYPE-CD            
                    MOVE AT-ACCOUNT-NO    TO DL-ACCOUNT-NO              
                    PERFORM 7370-SELECT-RECONNECT      THRU 7370-EXIT   
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       SUBTRACT DL-RECNCT-COLLECT-AMT FROM              
                           DL-AMT-TOT-RECONNECT GIVING S-DNP-RECON-AMT  
                    END-IF                                              
                    MOVE 'PROFILE043'     TO S-BUS-RULE-ID              
                    PERFORM 7372-CHECK-RECONCT-GASONLY THRU 7372-EXIT   
                    IF WS-GASONLY-RECONCT EQUAL 'Y'                     
                       MOVE 'Y'           TO S-GASONLY-RECONCT          
                    END-IF                                              
              END-EVALUATE                                              
              PERFORM 7310-GET-BUS-RULE-XREF           THRU 7310-EXIT   
              MOVE 1T-BUS-RULE-XREF-ID    TO S-BUS-RULE-XREF-ID         
              MOVE 'P'                    TO S-RULE-RESULT-CD           
                                                                        
              IF VO-ORDER-TYPE-CD = 'DNP01'                             
                 EVALUATE VO-ORDER-STATE-CD                             
                    WHEN 'A'                                            
                       MOVE 'ACTIVE'      TO WS-ORDER-STATE             
                    WHEN 'H'                                            
                       MOVE 'HOLD'        TO WS-ORDER-STATE             
                    WHEN 'D'                                            
                       MOVE 'TURNED DOWN CUSTOMER' TO WS-ORDER-STATE    
                    WHEN 'B'                                            
                       MOVE 'TURNED DOWN COMPANY'  TO WS-ORDER-STATE    
                 END-EVALUATE                                           
                 MOVE VO-ASSIGNED-DATETIME(1:10)   TO WS-SO-DATE        
                 MOVE WS-SO-DATE(6:2)     TO WS-SO-DISPLAY-DATE(1:2)    
                 MOVE WS-SO-DATE(9:2)     TO WS-SO-DISPLAY-DATE(4:2)    
                 MOVE WS-SO-DATE(1:4)     TO WS-SO-DISPLAY-DATE(7:4)    
                 MOVE '/'                 TO WS-SO-DISPLAY-DATE(3:1),   
                                             WS-SO-DISPLAY-DATE(6:1)    
                                                                        
                 STRING WS-ORDER-STATE ';' WS-SO-DISPLAY-DATE           
                           DELIMITED BY SIZE INTO S-MESSAGE-PARM        
              END-IF                                                    
                                                                        
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT            
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
PRJ586** CHECK FOR BILL IMMEDIATE DEPOSIT                                       
PRJ586     PERFORM 7380-SELECT-DEP-REQ        THRU 7380-EXIT.           
           IF WS-DEP-REQ-FOUND = 'Y'                                    
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                   TO S-RETURN-CODE-2               
              MOVE 'PYMT000002'        TO S-BUS-RULE-ID                 
              PERFORM 7310-GET-BUS-RULE-XREF  THRU 7310-EXIT            
              MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID            
              MOVE 'P'                 TO S-RULE-RESULT-CD              
              IF WS-GTT02-DECLARED = 'N'                                
                 PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT            
              END-IF                                                    
              PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT            
           END-IF.                                                      
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *REDUCE EMBEDDED SPACE.                                                   
           COPY CPD00004.                                                       
                                                                        
       7100-SELECT-ACCT-NAME.                                           
           EXEC SQL                                                     
              SELECT TOP(1) DQ.NAME_FORMAT,
              RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME) + ' ' + 
           RTRIM(LAST_NAME),
              DQ.TITLE_PREFIX,
              DQ.TITLE_SUFFIX_1,
              DQ.TITLE_SUFFIX_2,
              RTRIM(FULL_NAME),
              RTRIM(HOUSE_NO) + ' ' + RTRIM(ADDR_PREFIX_1) + ' ' + 
           RTRIM(ADDR_PREFIX_2) + ' ' + RTRIM(STREET_NAME) + ' ' + 
           RTRIM(STREET_LOCATION_1) + ' ' + RTRIM(STREET_LOCATION_2) + 
           ' ' + RTRIM(STREET_SUFFIX),
              HT.CUSTOMER_NO,
              HT.PREMISE_NO,
              HT.COMPANY_NO,
              A4.TOWN                                            
                INTO :DQ-NAME-FORMAT,                                   
                     :WS-ACCT-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME,                                     
                     :WS-ADDRESS,                                       
                     :HT-CUSTOMER-NO,                                   
                     :HT-PREMISE-NO,                                    
                     :HT-COMPANY-NO,                                    
                     :A4-TOWN                                           
              FROM CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED),                
                   CSS_NAME            DQ WITH(READUNCOMMITTED),                
                   CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED),                
                   CSS_ZIP_CODE        A4 WITH(READUNCOMMITTED)                 
             WHERE HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                 
               AND DQ.NAME_ID          = HT.NAME_ID                     
               AND DQ.NAME_TYPE        = 'CN'                           
               AND HT.CUSTOMER_ROLE_CD = ' '                            
               AND DY.ADDRESS_ID       = HT.ADDRESS_ID                  
               AND DY.ZIP_CODE         = A4.ZIP_CODE                    
               AND DY.ZIP_CODE_TOKEN   = A4.ZIP_CODE_TOKEN              
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.NAME_FORMAT,                                            
MFA-TR*              RTRIM(FIRST_NAME) || ' ' ||                                
MFA-TR*              RTRIM(MIDDLE_NAME) || ' ' ||                               
MFA-TR*              RTRIM(LAST_NAME),                                          
MFA-TR*              DQ.TITLE_PREFIX,                                           
MFA-TR*              DQ.TITLE_SUFFIX_1,                                         
MFA-TR*              DQ.TITLE_SUFFIX_2,                                         
MFA-TR*              RTRIM(FULL_NAME),                                          
MFA-TR*              RTRIM(HOUSE_NO) || ' ' ||                                  
MFA-TR*               RTRIM(ADDR_PREFIX_1) || ' ' ||                            
MFA-TR*               RTRIM(ADDR_PREFIX_2) || ' ' ||                            
MFA-TR*               RTRIM(STREET_NAME)   || ' ' ||                            
MFA-TR*               RTRIM(STREET_LOCATION_1) || ' ' ||                        
MFA-TR*               RTRIM(STREET_LOCATION_2) || ' ' ||                        
MFA-TR*               RTRIM(STREET_SUFFIX),                                     
MFA-TR*              HT.CUSTOMER_NO,                                            
MFA-TR*              HT.PREMISE_NO,                                             
MFA-TR*              HT.COMPANY_NO,                                             
MFA-TR*              A4.TOWN                                                    
MFA-TR*         INTO :DQ-NAME-FORMAT,                                           
MFA-TR*              :WS-ACCT-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :WS-ADDRESS,                                               
MFA-TR*              :HT-CUSTOMER-NO,                                           
MFA-TR*              :HT-PREMISE-NO,                                            
MFA-TR*              :HT-COMPANY-NO,                                            
MFA-TR*              :A4-TOWN                                                   
MFA-TR*       FROM CSS_NAME_ACCT_XREF  HT,                                      
MFA-TR*            CSS_NAME            DQ,                                      
MFA-TR*            CSS_ADDR_FORMATTED  DY,                                      
MFA-TR*            CSS_ZIP_CODE        A4                                       
MFA-TR*      WHERE HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                         
MFA-TR*        AND DQ.NAME_ID          = HT.NAME_ID                             
MFA-TR*        AND DQ.NAME_TYPE        = 'CN'                                   
MFA-TR*        AND HT.CUSTOMER_ROLE_CD = ' '                                    
MFA-TR*        AND DY.ADDRESS_ID       = HT.ADDRESS_ID                          
MFA-TR*        AND DY.ZIP_CODE         = A4.ZIP_CODE                            
MFA-TR*        AND DY.ZIP_CODE_TOKEN   = A4.ZIP_CODE_TOKEN                      
MFA-TR*      FETCH FIRST 1 ROW ONLY                                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE 'SELECT'                   TO   ABEND-FUNCTION       
              MOVE '7100'                     TO   ACTIVE-PARAGRAPH     
              MOVE SPACES                     TO   ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_NAME_ACCT_XREF'       TO   TABLE-1              
              MOVE 'ACCOUNT_NO'               TO   TABLE-ELEMENT-1      
              MOVE HT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
       7250-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT,                                
                      AT.COMPANY_NO,                                    
                      AT.CUSTOMER_NO,                                   
                      AT.PREMISE_NO,                                    
                      AT.TOTAL_AR_BALANCE,                              
                      AT.ACCT_XFER_TO,                                  
                      AT.ACCT_XFER_FROM_LST,                            
                      AT.AR_XFER_IND,                                   
                      AT.CODES_DATA_PRESENT,                            
                      AT.BANKRUPTCY_IND,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                
                INTO :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-ACCT-XFER-TO,                                  
                     :AT-ACCT-XFER-FROM-LST,                            
                     :AT-AR-XFER-IND,                                   
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-BANKRUPTCY-IND,                                
                     :AT-LAST-UPDATE-TS,                                
                     :AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND              
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.TOTAL_AR_BALANCE,                                      
MFA-TR*               AT.ACCT_XFER_TO,                                          
MFA-TR*               AT.ACCT_XFER_FROM_LST,                                    
MFA-TR*               AT.AR_XFER_IND,                                           
MFA-TR*               AT.CODES_DATA_PRESENT,                                    
MFA-TR*               AT.BANKRUPTCY_IND,                                        
MFA-TR*               AT.LAST_UPDATE_TS,                                        
MFA-TR*               AT.ACCT_FINALED_DT                                        
MFA-TR*         INTO :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-TOTAL-AR-BALANCE,                                      
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-ACCT-XFER-FROM-LST,                                    
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  IF WS-FINAL-NULL-IND < 0                              
                     MOVE SPACES               TO AT-ACCT-FINALED-DT    
                  END-IF                                                
              WHEN NOT-FOUND                                            
                  PERFORM 7260-SELECT-HST-ACCT    THRU 7260-EXIT        
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME            TO ABEND-PROGRAM         
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE '7250'                  TO ACTIVE-PARAGRAPH      
                  MOVE SPACES                  TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                  MOVE 'CSS_ACCOUNT'           TO TABLE-1               
                  MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
                  MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-SELECT-HST-ACCT.                                            
           EXEC SQL                                                     
              SELECT 'Y',                                               
                     CUSTOMER_NO,                                       
                     CODE_ACCT_STAT,                                    
                     COMPANY_NO,                                        
                     PREMISE_NO,                                        
                     ACCOUNT_BALANCE_AM,                                
                     ACCT_XFER_TO,                                      
                     ACCT_XFER_FROM_LST,                                
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     ACCT_FINALED_DT                                    
                INTO :WS-ARCHIVE-IND,                                   
                     :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :AT-PREMISE-NO,                                    
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-ACCT-XFER-TO,                                  
                     :AT-ACCT-XFER-FROM-LST,                            
                     :AT-LAST-UPDATE-TS,                                
                     :AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND              
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              ACCOUNT_BALANCE_AM,                                        
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              ACCT_FINALED_DT                                            
MFA-TR*         INTO :WS-ARCHIVE-IND,                                           
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-TOTAL-AR-BALANCE,                                      
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-ACCT-XFER-FROM-LST,                                    
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND                      
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF AT-ACCT-XFER-TO > ZERO                              
                    MOVE 'N'              TO WS-ARCHIVE-IND             
                    MOVE AT-ACCT-XFER-TO  TO HA-ACCT-XFER-TO            
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 INITIALIZE GTT-RETURN-FIELDS-2                         
                 MOVE 0                   TO S-RETURN-CODE-2            
                 MOVE 'PYMT000008'        TO S-BUS-RULE-ID              
                 PERFORM 7310-GET-BUS-RULE-XREF  THRU 7310-EXIT         
                 MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID         
                 MOVE 'P'                 TO S-RULE-RESULT-CD           
                 IF WS-GTT02-DECLARED = 'N'                             
                    PERFORM 0102-DECLARE-GTT2    THRU 0102-EXIT         
                 END-IF                                                 
                 PERFORM 8200-SEND-RESULT-2      THRU 8200-EXIT         
                 MOVE NOT-FOUND           TO WS-ACTIVE-RETURN-CODE      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE '7260'              TO ACTIVE-PARAGRAPH           
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'HST_ACCOUNT'       TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7310-GET-BUS-RULE-XREF.                                          
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO 1T-BUS-RULE-XREF-ID                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   MOVE 'BUS_PROCESS_ID'    TO TABLE-ELEMENT-2          
                   MOVE 1T-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7325-SELECT-CRED-PROF.                                         *        
      ******************************************************************        
       7325-SELECT-CRED-PROF.                                           
                                                                        
           EXEC SQL                                                     
               SELECT CASH_ONLY_FL                                      
                 INTO :WS-CASH-ONLY-FL                                  
                 FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CASH_ONLY_FL                                              
MFA-TR*          INTO :WS-CASH-ONLY-FL                                          
MFA-TR*          FROM CSS_CREDIT_PROFILE                                        
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7325                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE '7325'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7335-SELECT-DELINQUENCY.                                         
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD  = 'WO-CUTOFF-DT'                       
                  AND COMPANY_NO = :AT-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD  = 'WO-CUTOFF-DT'                               
MFA-TR*           AND COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7335                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE C8-DELINQ-VALUE TO WS-WOFF-YEARS,                 
                                         WS-DISPLAY-YEARS               
              WHEN NOT-FOUND                                            
                 MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                   
                 MOVE 0               TO WS-WOFF-YEARS,                 
                                         WS-DISPLAY-YEARS               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7335'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_DELINQUENCY'    TO TABLE-1                   
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
           IF WS-WOFF-YEARS > 0                                         
               EXEC SQL                                                 
                   SELECT
              DATEADD( YEAR, -(:WS-WOFF-YEARS), 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-WOFF-DT            
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SET :WS-WOFF-DT = (DATE(CURRENT_DATE) -                      
MFA-TR*                              (:WS-WOFF-YEARS) YEARS)                    
MFA-TR*        END-EXEC.                                                        
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL


           END-IF.                                                
       7335-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7345-GET-RETURN-CHECK.                                         *        
      ******************************************************************        
       7345-GET-RETURN-CHECK.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RTN-CHECK-EXISTS                              
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                  AND (PYMT_PRIORITY_LVL = 020 OR                       
                       PYMT_PRIORITY_LVL = 029)                         
                  AND ITEM_ID            = 0                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RTN-CHECK-EXISTS                                      
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*           AND (PYMT_PRIORITY_LVL = 020 OR                               
MFA-TR*                PYMT_PRIORITY_LVL = 029)                                 
MFA-TR*           AND ITEM_ID            = 0                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7345                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7345'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7345-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7355-SELECT-AR-CNTL.                                           *        
      ******************************************************************        
       7355-SELECT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-COMPLEX-AR-EXISTS                             
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
                  AND PYMT_PRIORITY_LVL  >= 50                          
                  AND ITEM_ID            > 0                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-COMPLEX-AR-EXISTS                                     
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                       
MFA-TR*           AND PYMT_PRIORITY_LVL  >= 50                                  
MFA-TR*           AND ITEM_ID            > 0                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7355                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7355'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7355-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7365-SELECT-DNP-DET.                                           *        
      ******************************************************************        
       7365-SELECT-DNP-DET.                                             
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO,
              ORDER_TYPE_CD,
              SERV_ORDER_STATUS,
              AMT_DNP_AT_BILLING,
              ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME                      
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ORDER-TYPE-CD,                                
                      :VO-SERV-ORDER-STATUS,                            
                      :VO-AMT-DNP-AT-BILLING,                           
                      :VO-ORDER-STATE-CD,                               
                      :VO-ASSIGNED-DATETIME                             
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                       
                  AND ORDER_TYPE_CD  IN ('DNP01', 'FM006')              
                  AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B')            
                ORDER BY DATE_RECVED DESC                               
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               SERV_ORDER_STATUS,                                        
MFA-TR*               AMT_DNP_AT_BILLING,                                       
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               ASSIGNED_DATETIME                                         
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-SERV-ORDER-STATUS,                                    
MFA-TR*               :VO-AMT-DNP-AT-BILLING,                                   
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-ASSIGNED-DATETIME                                     
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                               
MFA-TR*           AND ORDER_TYPE_CD  IN ('DNP01', 'FM006')                      
MFA-TR*           AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B')                    
MFA-TR*         ORDER BY DATE_RECVED DESC                                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7365                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7365'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SO_DATA'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE VO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7365-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7370-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT,                                
                      RECNCT_COLLECT_AMT                                
                 INTO :DL-AMT-TOT-RECONNECT,                            
                      :DL-RECNCT-COLLECT-AMT                            
                 FROM CSS_RECONNECT WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      
                  AND AMT_TOT_RECONNECT > 0                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_TOT_RECONNECT,                                        
MFA-TR*               RECNCT_COLLECT_AMT                                        
MFA-TR*          INTO :DL-AMT-TOT-RECONNECT,                                    
MFA-TR*               :DL-RECNCT-COLLECT-AMT                                    
MFA-TR*          FROM CSS_RECONNECT                                             
MFA-TR*         WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                              
MFA-TR*           AND AMT_TOT_RECONNECT > 0                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7370'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_RECONNECT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE DL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7372-CHECK-RECONCT-GASONLY.                                      
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-GASONLY-RECONCT                               
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND WORK_TYPE_CD  <> ''                               
                  AND NOT EXISTS (SELECT '1' FROM CSS_SO_ORDER_INST
                           WITH(READUNCOMMITTED)     
                             WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO   
                               AND CODE_UTIL_TYPE = 'E')                
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-GASONLY-RECONCT                                       
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                        
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND WORK_TYPE_CD  <> ''                                       
MFA-TR*           AND NOT EXISTS (SELECT '1' FROM CSS_SO_ORDER_INST             
MFA-TR*                      WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO           
MFA-TR*                        AND CODE_UTIL_TYPE = 'E')                        
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7372                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7372'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                      
              MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1              
              MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7372-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7375-SELECT-CHRG-OFF.                                            
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-NULL-AMT                         
                 FROM CSS_CHRG_OFF CO WITH(READUNCOMMITTED),                    
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE CO.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND CO.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CAST(ACCT_FINALED_DT AS DATE) < 
              IIF(TRY_CONVERT(DATE, :WS-WOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WOFF-DT) <> 0) OR (LEN(
                                                            :WS-WOFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-WOFF-DT), CONVERT(DATE, 
                                                            :WS-WOFF-DT
              ) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-AMT                                 
MFA-TR*          FROM CSS_CHRG_OFF CO,                                          
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE CO.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND CO.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND DATE(ACCT_FINALED_DT) < :WS-WOFF-DT                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7375                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-AMT < 0                                   
                       MOVE 0.00            TO CO-AMT-TRANS             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE    
                                               CO-AMT-TRANS             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE '7375'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CHRG_OFF'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
       7375-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ586 7380-SELECT-DEP-REQ.                                             
           EXEC SQL                                                     
             SELECT 'Y'                                                 
             INTO :WS-DEP-REQ-FOUND                                     
             FROM CSS_DEP_REQ DR WITH(READUNCOMMITTED)                          
             WHERE DR.ACCOUNT_NO = :DR-ACCOUNT-NO AND                   
                   DR.PYMT_PRIORITY_LVL = 80 AND                        
                   DR.DEP_BILL_OPTION_CD = :WS-BILL-IMMEDIATE           
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*      INTO :WS-DEP-REQ-FOUND                                             
MFA-TR*      FROM CSS_DEP_REQ DR                                                
MFA-TR*      WHERE DR.ACCOUNT_NO = :DR-ACCOUNT-NO AND                           
MFA-TR*            DR.PYMT_PRIORITY_LVL = 80 AND                                
MFA-TR*            DR.DEP_BILL_OPTION_CD = :WS-BILL-IMMEDIATE                   
MFA-TR*        QUERYNO 7380                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7380'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE 'DEP_BILL_OPTION_CD'  TO TABLE-ELEMENT-2             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-BILL-IMMEDIATE     TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8002-DELETE-GTT2-ROWS                                           *        
      ******************************************************************        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
              DELETE FROM #CSR04582_R2                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04582_R2                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE '8002'                TO ACTIVE-PARAGRAPH         
                 MOVE 'DELETE'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR04582_R2'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
           EXEC SQL                                                     
               INSERT INTO #CSR04582_R2                          
                ( RETURN_CODE,                                          
                  BUS_RULE_ID,                                          
                  RULE_RESULT_CD,                                       
                  BUS_RULE_XREF_ID,                                     
                  MESSAGE_PARM                                          
                )                                                       
               VALUES                                                   
                ( :S-RETURN-CODE-2,                                     
                  :S-BUS-RULE-ID,                                       
                  :S-RULE-RESULT-CD,                                    
                  :S-BUS-RULE-XREF-ID,                                  
                  :S-MESSAGE-PARM                                       
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04582_R2                                  
MFA-TR*         ( RETURN_CODE,                                                  
MFA-TR*           BUS_RULE_ID,                                                  
MFA-TR*           RULE_RESULT_CD,                                               
MFA-TR*           BUS_RULE_XREF_ID,                                             
MFA-TR*           MESSAGE_PARM                                                  
MFA-TR*         )                                                               
MFA-TR*        VALUES                                                           
MFA-TR*         ( :S-RETURN-CODE-2,                                             
MFA-TR*           :S-BUS-RULE-ID,                                               
MFA-TR*           :S-RULE-RESULT-CD,                                            
MFA-TR*           :S-BUS-RULE-XREF-ID,                                          
MFA-TR*           :S-MESSAGE-PARM                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04582_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
              EXEC SQL                                                  
                 OPEN C2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           ELSE                                                         
              MOVE +100 TO S-RETURN-CODE-2                              
              EXEC SQL                                                  
                 OPEN N2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1,               
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *CALL CPD00068 TO DETERMINE THE DELINQUENCY VALUE TO USE FOR DNP          
      ****************************************************************          
       9500-CALL-CPD00068.                                              
           MOVE 'Y'                 TO CALC-ARREARS-SW,                 
                                       CALC-PAST-DUE-SW,                
                                       CALC-DNP-BAL-SW,                 
                                       CALC-BALANCE-SW,                 
                                       CALC-NOT-BAL-SW.                 
           MOVE SPACES              TO ABEND-FUNCTION.                  
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 S-RETURN-CODE-1.                       
                                                                        
           MOVE S-RETURN-CODE-1     TO  WS-ACTIVE-RETURN-CODE,          
                                        SQLCODE.                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1           TO S-RETURN-CODE-1,                  
                                      WS-ACTIVE-RETURN-CODE             
              END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
