       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04581.                                            
       DATE-WRITTEN. NOV 26  2012.                                      
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM INSERTS CUSTOMER RESPONSE INFO TO THE VARIOUS     *        
      * SERVICE PROMOTIONS OFFERED                                     *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
I00483*  11/27/12  VV90387    INITIAL CODE.                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04581'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04581 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT           (PREFIX = AT)                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SERVICE_PROMO    (PREFIX = 3A)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSERPRM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_EMAIL       (PREFIX = NE)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04581'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-CUSTOMER-NO        PIC X(10) VALUE SPACES.          
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
           05  PARM-CUSTOMER-NUM       PIC S9(10)V COMP-3 VALUE 0.      
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-ACCOUNT-NUM        PIC S9(13)V COMP-3 VALUE 0.      
           05  PARM-OFFERED-SERV       PIC X(25)  VALUE SPACES.         
           05  PARM-OFFERED-TS         PIC X(26)  VALUE SPACES.         
           05  PARM-CHOICE-CD          PIC X(02)  VALUE SPACES.         
           05  PARM-BY-USERID          PIC X(07)  VALUE SPACES.         
           05  PARM-ACTIVATE-ID        PIC X(32)  VALUE SPACES.         
           05  PARM-EMAIL-ADDR.                                         
               49  PARM-EMAIL-ADDR-LEN    PIC S9(04) COMP SYNC VALUE +0.
               49  PARM-EMAIL-ADDR-TEXT   PIC X(255) VALUE SPACES.      
           05  PARM-PROMO-STATUS-CD    PIC X(01)  VALUE SPACES.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-CUST-EMAIL-EXISTS    PIC X(01) VALUE 'N'.             
           05  WS-CUSTOMER-NO          PIC S9(10)V COMP-3 VALUE 0.      
           05  WS-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE         PIC S9(9) COMP VALUE 0.            
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01)      VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW           PIC X(01)      VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18)       VALUE SPACES.  
           10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.       
           10  S-SQLSTATE                PIC X(5)        VALUE ' '.     
           10  S-TABLE-NAME              PIC X(18)       VALUE SPACES.  
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-RETURN-CODE            PIC S9(9) COMP  VALUE 0.       
           10  WS-SQLSTATE               PIC X(05)       VALUE SPACES.  
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO              PIC X(10).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-PROMO-OFFERED-SERV       PIC X(25).                     
       01  LINK-PROMO-OFFERED-TS         PIC X(26).                     
       01  LINK-PROMO-CHOICE-CD          PIC X(02).                     
       01  LINK-PROMO-BY-USERID          PIC X(07).                     
       01  LINK-PROMO-ACTIVATE-ID        PIC X(32).                     
       01  LINK-PROMO-EMAIL-ADDR-LEN     PIC S9(04) COMP SYNC VALUE +0. 
       01  LINK-PROMO-EMAIL-ADDR-TEXT    PIC X(100) VALUE SPACES.       
       01  LINK-PROMO-STATUS-CD          PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING          LINK-CUSTOMER-NO               
                                        ,LINK-ACCOUNT-NO                
                                        ,LINK-PROMO-OFFERED-SERV        
                                        ,LINK-PROMO-OFFERED-TS          
                                        ,LINK-PROMO-CHOICE-CD           
                                        ,LINK-PROMO-BY-USERID           
                                        ,LINK-PROMO-ACTIVATE-ID         
                                        ,LINK-PROMO-EMAIL-ADDR-LEN      
                                        ,LINK-PROMO-EMAIL-ADDR-TEXT     
                                        ,LINK-PROMO-STATUS-CD.          
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. DECLARE CURSOR                                          *        
      *     2. RECEIVE INPUT PARAMETRS                                 *        
      *     3. INITIALIZE OUTPUT PARAMETERS                            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE         AS RETURN_CODE              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
                                 MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.       
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
                                 MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.        
                                                                        
           MOVE LINK-CUSTOMER-NO             TO PARM-CUSTOMER-NO.       
           MOVE LINK-ACCOUNT-NO              TO PARM-ACCOUNT-NO.        
           MOVE LINK-PROMO-OFFERED-SERV      TO PARM-OFFERED-SERV.      
           MOVE LINK-PROMO-OFFERED-TS        TO PARM-OFFERED-TS.        
           MOVE LINK-PROMO-CHOICE-CD         TO PARM-CHOICE-CD.         
           MOVE LINK-PROMO-BY-USERID         TO PARM-BY-USERID.         
           MOVE LINK-PROMO-ACTIVATE-ID       TO PARM-ACTIVATE-ID.       
           MOVE LINK-PROMO-EMAIL-ADDR-LEN    TO PARM-EMAIL-ADDR-LEN.    
           MOVE LINK-PROMO-EMAIL-ADDR-TEXT   TO                         
                                             PARM-EMAIL-ADDR-TEXT.      
           MOVE LINK-PROMO-STATUS-CD         TO PARM-PROMO-STATUS-CD.   
                                                                        
           INITIALIZE                           S-RETURN-CODE.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-CUSTOMER-NO-RED      TO PARM-CUSTOMER-NUM.         
           MOVE PARM-ACCOUNT-NO-RED       TO PARM-ACCOUNT-NUM.          
           MOVE PARM-CUSTOMER-NUM         TO 3A-CUSTOMER-NO.            
           MOVE PARM-ACCOUNT-NUM          TO 3A-ACCOUNT-NO.             
           MOVE PARM-OFFERED-SERV         TO 3A-PROMO-OFFERED-SERV.     
           MOVE PARM-OFFERED-TS           TO 3A-PROMO-OFFERED-TS.       
           MOVE PARM-CHOICE-CD            TO 3A-PROMO-CHOICE-CD.        
           MOVE PARM-BY-USERID            TO 3A-PROMO-BY-USERID.        
           MOVE PARM-ACTIVATE-ID          TO 3A-PROMO-ACTIVATE-ID.      
           INITIALIZE 3A-PROMO-EMAIL-ADDR                               
           MOVE PARM-EMAIL-ADDR-LEN       TO 3A-PROMO-EMAIL-ADDR-LEN.   
           MOVE PARM-EMAIL-ADDR-TEXT      TO 3A-PROMO-EMAIL-ADDR-TEXT.  
           INSPECT 3A-PROMO-EMAIL-ADDR-TEXT REPLACING ALL LOW-VALUES    
                                          BY SPACES.                    
           MOVE PARM-PROMO-STATUS-CD      TO 3A-PROMO-STATUS-CD.        
                                                                        
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 8010-UPD-EXISTING-PROMO    THRU 8010-EXIT.           
           IF 3A-PROMO-STATUS-CD = 'E'                                  
              PERFORM 8030-UPD-ERROR-SENDING-EMAIL THRU 8030-EXIT       
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
           PERFORM 8000-INSERT-SERVICE-PROMO  THRU 8000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF 3A-PROMO-CHOICE-CD = WS-YES                            
                 PERFORM 7000-CHECK-CUST-EMAIL     THRU 7000-EXIT       
                 IF WS-CUST-EMAIL-EXISTS  = WS-NO                       
                    PERFORM 8020-INSERT-CUST-EMAIL THRU 8020-EXIT       
                    MOVE ZERO TO                   WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE        
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-CHECK-CUST-EMAIL                                          *        
      *     VALIDATE IF CUSTOMER HAS A PRIMARY EMAIL IN THE SYSTEM     *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-CHECK-CUST-EMAIL.                                           
                                                                        
           MOVE WS-NO                         TO WS-CUST-EMAIL-EXISTS.  
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CUST-EMAIL-EXISTS                              
                FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :3A-CUSTOMER-NO                    
                 AND EMAIL_TYPE_CD = 'P1'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CUST-EMAIL-EXISTS                                      
MFA-TR*         FROM CSS_CUST_EMAIL                                             
MFA-TR*        WHERE CUSTOMER_NO   = :3A-CUSTOMER-NO                            
MFA-TR*          AND EMAIL_TYPE_CD = 'P1'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_EMAIL'           TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE 3A-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-SERVICE-PROMO                                      *        
      *     CAPTURES THE CUSTOMER RESPONSE TO THE VARIOUS SERVICE      *        
      *     PROMOTIONS                                                 *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       8000-INSERT-SERVICE-PROMO.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SERVICE_PROMO                             
                     (CUSTOMER_NO,                                      
                      ACCOUNT_NO,                                       
                      PROMO_OFFERED_SERV,                               
                      PROMO_OFFERED_TS,                                 
                      PROMO_CHOICE_CD,                                  
                      PROMO_BY_USERID,                                  
                      PROMO_ACTIVATE_ID,                                
                      PROMO_EMAIL_ADDR,                                 
                      PROMO_STATUS_CD)                                  
                VALUES                                                  
                     (:3A-CUSTOMER-NO,                                  
                      :3A-ACCOUNT-NO,                                   
                      :3A-PROMO-OFFERED-SERV,                           
                       CIS.CURRENT$TIMESTAMP(),                               
                      :3A-PROMO-CHOICE-CD,                              
                      :3A-PROMO-BY-USERID,                              
                      :3A-PROMO-ACTIVATE-ID,                            
                      :3A-PROMO-EMAIL-ADDR,                             
                      :3A-PROMO-STATUS-CD)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SERVICE_PROMO                                     
MFA-TR*              (CUSTOMER_NO,                                              
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               PROMO_OFFERED_SERV,                                       
MFA-TR*               PROMO_OFFERED_TS,                                         
MFA-TR*               PROMO_CHOICE_CD,                                          
MFA-TR*               PROMO_BY_USERID,                                          
MFA-TR*               PROMO_ACTIVATE_ID,                                        
MFA-TR*               PROMO_EMAIL_ADDR,                                         
MFA-TR*               PROMO_STATUS_CD)                                          
MFA-TR*         VALUES                                                          
MFA-TR*              (:3A-CUSTOMER-NO,                                          
MFA-TR*               :3A-ACCOUNT-NO,                                           
MFA-TR*               :3A-PROMO-OFFERED-SERV,                                   
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*               :3A-PROMO-CHOICE-CD,                                      
MFA-TR*               :3A-PROMO-BY-USERID,                                      
MFA-TR*               :3A-PROMO-ACTIVATE-ID,                                    
MFA-TR*               :3A-PROMO-EMAIL-ADDR,                                     
MFA-TR*               :3A-PROMO-STATUS-CD)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SERVICE_PROMO'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 3A-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 3A-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-UPD-EXISTING-PROMO                                        *        
      *     UPDATES THE EXISTING PROMO STATUS TO INACTIVE              *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       8010-UPD-EXISTING-PROMO.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SERVICE_PROMO                                  
                 SET PROMO_STATUS_CD = 'I'                              
               WHERE CUSTOMER_NO     =  :3A-CUSTOMER-NO                 
                 AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV        
                 AND PROMO_STATUS_CD <> 'E'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SERVICE_PROMO'        TO TABLE-1                
              MOVE 'PROMO_OFFERED_SERV'       TO TABLE-ELEMENT-1        
              MOVE 3A-PROMO-OFFERED-SERV      TO HOSTVAR-ELEMENT-1      
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 3A-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-CUST-EMAIL                                         *        
      *     INSERTS A DUMMY ROW INTO CSS_CUST_EMAIL FOR THE BATCH EMAIL*        
      *     FUNCTIONALITY TO WORK                                      *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       8020-INSERT-CUST-EMAIL.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_EMAIL                                
                     (CUSTOMER_NO,                                      
                      EMAIL_TYPE_CD ,                                   
                      EMAIL_DISP_PREF_CD,                               
                      EMAIL_ADDRESS_TX,                                 
                      EMAIL_SOURCE_CD)                                  
                VALUES                                                  
                     (:3A-CUSTOMER-NO,                                  
                      'P1',                                             
                      'H',                                              
                      ' ',                                              
                      'D')                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_EMAIL'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 3A-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 3A-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-UPD-ERROR-SENDING-EMAIL                                   *        
      *     UPDATES THE EXISTING PROMO STATUS TO ERROR AS THE EMAIL WAS*        
      *     NOT SENT SUCCESSFULLY                                      *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       8030-UPD-ERROR-SENDING-EMAIL.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SERVICE_PROMO                                  
                 SET PROMO_STATUS_CD    = 'E'                           
               WHERE CUSTOMER_NO        = :3A-CUSTOMER-NO               
                 AND PROMO_OFFERED_SERV = :3A-PROMO-OFFERED-SERV        
                 AND PROMO_ACTIVATE_ID  = :3A-PROMO-ACTIVATE-ID         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8030'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SERVICE_PROMO'        TO TABLE-1                
              MOVE 'PROMO_OFFERED_SERV'       TO TABLE-ELEMENT-1        
              MOVE 3A-PROMO-OFFERED-SERV      TO HOSTVAR-ELEMENT-1      
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE 3A-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              MOVE 'GUID'                     TO TABLE-ELEMENT-3        
              MOVE 3A-PROMO-ACTIVATE-ID       TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
