       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04580.                                        
       DATE-WRITTEN.   JAN     2013.                                    
       DATE-COMPILED.                                                   
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      *****************************************************************         
      **                STORED PROCEDURE:  CSR04580                  **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      **  THIS PROGRAM WRITES THE READ DATE,OPTIMUM READ DATE AND    ** 00380000
      **  BILL DATE FOR EACH BILL CYCLE IN CSS_READ_WINDOW AND       ** 00390029
      **  CSS_BILL_WINDOW TABLE FOR THE GIVEN REVENUE MONTH IN       ** 00391029
      **  WORK SCHEDULE SCREEN.                                         00392029
      **  WHEN INSERT BILL_WINDOW AND READ_WINDOW DATA FOR PARTICULAR** 00150000
      **  REVENUE MONTH THAT TIME WE INSERT DATA IN CSS_CRED_FORECAST**         
      **  FOR THE PREVIOUS REVENUE MONTH.                            **         
      **                                                             **         
      **  PARAMETERS                                                 **         
      **                                                             **         
      **      INPUT                                                  **         
      **        READ_CYCLE           CHAR(02)                        **         
      **        BILL_OPEN_DT         CHAR(10)                        **         
      **        REV_YR               CHAR(04)                        **         
      **        REV_MO               CHAR(02)                        **         
      **                                                             **         
      **      OUTPUT                                                 **         
      **                                                             **         
      **       RETURN_CODE           INTEGER                         **         
      **                                                             **         
      **      RESULT SET                                             **         
      **        1                                                    **         
      *****************************************************************         
      **                                                              *         
      **              PROGRAM MODIFICATION LOG                        *         
      ** DATE        INITIALS     REASON                              *         
      ** --------    ---------    ----------------------------------- *         
P00722** 01/30/13    SV95326      NEW PROGRAM.                        *         
P00722** 01/06/14    SV95326      USE OPTIMUM_READ_DATE INSTEAD OF    *         
P00722**                          THIRD_PRTY_READ_DATE FOR CALCULATION*         
P00722**                          IN NEXT-READ-DATE IN BILL-WINDOW    *         
P00722**                          CURSOR.                             *         
A04880** 02/20/13    SV95326      ACT049 -FIX FOR SEB CYCLE 21 DATES. *         
I01687** 03/03/14    SV95326      AVOID LPC DATE CHANGE FOR GEORGIA.  *         
A05267** 06/18/15    MJ13662      FOR SCANA ENERGY, ALL TYPES EXCEPT  *         
A05267**                          BALANCE CREDIT GROUP, CHANGE        *         
A05267**                          ARREARS-DUE-DT TO BE DNP-DT MINUS   *         
A05267**                          DAY-DUE.                            *         
      *****************************************************************         
      *                                                               *         
      *         -----    BASIC SEQUENCE STRUCTURE   -----             *         
      * 0000         MODULE CONTROL                                   *         
      * 0100 - 0999  INITIALIZATION                                   *         
      * 1000 - 1999  FUNCTIONAL CONTROL                               *         
      * 2000 - 4999  DETAIL LOGIC                                     *         
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               *         
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     *         
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    *         
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    *         
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                 00570000
       DATA DIVISION.                                                   
      *                                                                 00600000
       WORKING-STORAGE SECTION.                                         

MSQ009  01 MSQ009-SQLCODE  PIC S9(9) COMP-4.
MSQ009  01 MSQ009-FOR-21  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-BILL-WINDOW  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WORK-CUR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04580'.
MSQ017     COPY MFASQLM.
      *                                                                 00620000
       01  WS-WORK-STORAGE-BEGIN.                                       
           05  FILLER                  PIC X(20)                        
               VALUE 'WORKING STORAGE FOR '.                            
           05  PROGRAM-NAME            PIC X(08)                        
               VALUE 'CSR04580'.                                        
           05  PROGRAM-NAME-BILL-WIN   PIC X(08)                        
               VALUE 'PCSSF047'.                                        
           05  FILLER                  PIC X(12)                        
               VALUE ' BEGINS HERE'.                                    
      *                                                                 00793030
           EXEC SQL                                                     01482100
               INCLUDE CWSX0010                                         01483000
           END-EXEC.                                                    01484000
      *                                                                 01485000
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                 01507000
           EXEC SQL                                                     00860031
              INCLUDE CWS00038                                          00870031
           END-EXEC.                                                    00880031
      *                                                                 00890000
        01  WS-INPUT-DATA-R8                                            
             REDEFINES                                                  
            WS-INPUT-DATA-BREAKDOWN.                                    
            10  WS-SYSIPT-R8            PIC X(17).                      
                88  BILL-CYCLE-WINDOW VALUE 'BILL CYCLE WINDOW'.        
            10  FILLER                  PIC X(01).                      
            10  WS-BILL-WINDOW-PARM     PIC 9(02).                      
            10  FILLER                  PIC X(33).                      
      *                                                                         
       01   WS-INSERT-ROW-COUNT                                         
             REDEFINES                                                  
            WS-INPUT-DATA-BREAKDOWN.                                    
            10  WS-PARM-INSERT-ROW-COUNT-TXT PIC X(21).                 
                88 INSERT-ROW-CNT         VALUE 'NO-OF-ROWS-TO-INSERT='.
            10  WS-NO-OF-ROWS-TO-INSERT   PIC X(05).                    
            10  FILLER                    PIC X(54).                    
      *                                                                         
       01  WS-FLAGS.                                                    
      *                                                                 01160000
           05  WS-DATABASE              PIC S9(4)V9(5) COMP-3 VALUE +0. 
           05  WS-DATABASE-FL           PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-BW-FLG                PIC X(01) VALUE SPACES.         
           05  WS-BILL-COND-FLG         PIC X(01) VALUE SPACES.         
COB305     05 WS-BN-REV-MONTH        PIC S999999V USAGE COMP-3 VALUE 0.      
COB305     05 WS-RW-REV-MONTH        PIC S999999V USAGE COMP-3 VALUE 0.      
           05  WS-THIRD-PTY-EXCEPTION  PIC X(01) VALUE ' '.             
               88  TP-EXCEPTION-EXISTS           VALUE 'Y'.             
           05 WS-START-FOUND-SW         PIC 9(01) VALUE 0.              
              88 CYC21-START-NOT-FOUND            VALUE 0.              
              88 CYC21-START-FOUND                VALUE 1.              
      *                                                                 01250000
       01  WS-DELINQUENCY-DAY-CONSTANTS USAGE COMP-3.                   
           05  WS-ARREARS-DUE-DT-DEL     PIC S9(4) COMP-3 VALUE +0.     
           05  WS-AVOID-LPC-DT-DEL       PIC S9(4) COMP-3 VALUE +0.     
I01687     05  WS-AVOID-LPC-DT-SEB-DEL   PIC S9(4) COMP-3 VALUE +0.     
           05  WS-CURR-CHG-DUE-DT-DEL    PIC S9(4) COMP-3 VALUE +0.     
           05  WS-DNP-DT-DEL             PIC S9(4) COMP-3 VALUE +0.     
           05  WS-DNP-NOTICE-DUE-DT-DEL  PIC S9(4) COMP-3 VALUE +0.     
           05  WS-DNP-NOTICE-MAIL-DT-DEL PIC S9(4) COMP-3 VALUE +0.     
           05  WS-DNP-REVIEW-DT-DEL      PIC S9(4) COMP-3 VALUE +0.     
           05  WS-IVR-CALL-DT-DEL        PIC S9(4) COMP-3 VALUE +0.     
           05  WS-NONUTIL-WQ-DT-DEL      PIC S9(4) COMP-3 VALUE +0.     
           05  WS-ARREARS-DUE-DT-B       PIC S9(4) COMP-3 VALUE 0.      
           05  WS-AVOID-LPC-DT-B         PIC S9(4) COMP-3 VALUE 0.      
I01687     05  WS-AVOID-LPC-DT-SEB-B     PIC S9(4) COMP-3 VALUE 0.      
           05  WS-CURR-CHG-DUE-DT-B      PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-DT-B               PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-NOTICE-DUE-DT-B    PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-NOTICE-MAIL-DT-B   PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-REVIEW-DT-B        PIC S9(4) COMP-3 VALUE 0.      
           05  WS-IVR-CALL-DT-B          PIC S9(4) COMP-3 VALUE 0.      
           05  WS-NONUTIL-WQ-DT-B        PIC S9(4) COMP-3 VALUE 0.      
           05  WS-ARREARS-DUE-DT-A       PIC S9(4) COMP-3 VALUE 0.      
           05  WS-AVOID-LPC-DT-A         PIC S9(4) COMP-3 VALUE 0.      
I01687     05  WS-AVOID-LPC-DT-SEB-A     PIC S9(4) COMP-3 VALUE 0.      
           05  WS-CURR-CHG-DUE-DT-A      PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-DT-A               PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-NOTICE-DUE-DT-A    PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-NOTICE-MAIL-DT-A   PIC S9(4) COMP-3 VALUE 0.      
           05  WS-DNP-REVIEW-DT-A        PIC S9(4) COMP-3 VALUE 0.      
           05  WS-IVR-CALL-DT-A          PIC S9(4) COMP-3 VALUE 0.      
           05  WS-NONUTIL-WQ-DT-A        PIC S9(4) COMP-3 VALUE 0.      
                                                                        
       01  WS-CONSTANTS.                                                
      *                                                                 01270000
           05  WS-2                     PIC 9(01)  VALUE 2.             
           05  WS-3                     PIC 9(01)  VALUE 3.             
           05  WS-4                     PIC 9(01)  VALUE 4.             
           05  WS-20                    PIC 9(02)  VALUE 20.            
           05  WS-90                    PIC 9(02)  VALUE 90.            
           05  WS-CLOSED                PIC X(01)  VALUE 'C'.           
           05  WS-READ                  PIC X(01)  VALUE 'R'.           
           05  WS-YES                   PIC X(03)  VALUE 'Y'.           
           05  WS-NO                    PIC X(03)  VALUE 'N'.           
           05  WS-DAY                   PIC S9(04) COMP.                
           05  WS-DATE-FOUND            PIC X(01)  VALUE 'N'.           
               88  DATE-FOUND                      VALUE 'Y'.           
           05  WS-ROW-COUNT             PIC S9(09) COMP VALUE +0.       
           05  WS-DAY-COUNTER           PIC 9(01)  VALUE 0.             
           05  WS-BUSI-DAY-COUNT        PIC S9(09) COMP VALUE +0.       
           05  WS-21-CYCLE-COUNT        PIC S9(09) COMP VALUE +0.       
           05  WS-READ-CYCLE-COUNT      PIC S9(09) COMP VALUE +0.       
           05  WS-BILL-CYCLE-COUNT      PIC S9(09) COMP VALUE +0.       
           05  SEND-DONE-SW             PIC X(01)  VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
      *                                                                 01450000
       01  WS-INPUT-DATA.                                               
           05  WS-INPUT-CYCLE                 PIC X(02)  VALUE ' '.     
           05  WS-INPUT-CYCLE-OPEN-DT         PIC X(10)  VALUE ' '.     
           05  WS-INPUT-3RD-PTY-READ-DT       PIC X(10)  VALUE ' '.     
           05  WS-INPUT-REVENUE-MONTH         PIC 9(06)  VALUE 0.       
           05  WS-REV-MNTH-DT-ST              PIC X(10)  VALUE ' '.     
           05  WS-REV-MNTH-DT-END             PIC X(10)  VALUE ' '.     
           05  WS-CYC21-XTRACT-DT             PIC X(10)  VALUE ' '.     
           05  WS-TEMP-BILL-CYCLE             PIC X(02)  VALUE ' '.     
      *                                                                 01450000
       01 WS-WORKING-VARIABLES.                                         
      *                                                                 01470000
          05 WS-BUSINESS-DAY-START       PIC X(10)  VALUE SPACES.       
          05 WS-NEW-BUSINESS-DAY         PIC X(10)  VALUE SPACES.       
          05 WS-NO-OF-DAYS               PIC S9(09) COMP VALUE 1.       
           05  WS-BILL-WIN-COUNT        PIC S9(09) COMP  VALUE +0.      
           05  WS-NULL-1                PIC S9(04) COMP  VALUE +0.      
           05  WS-CURR-REV-YR.                                          
               10  WS-CURR-REV-CC       PIC 9(02).                      
               10  WS-CURR-REV-YY       PIC 9(02).                      
           05  WS-CURR-REV-YR-NUM REDEFINES WS-CURR-REV-YR              
                                        PIC 9(04).                      
           05  WS-CURR-REV-MNTH         PIC 9(02)  VALUE 0.             
           05  CTR-ROWS                 PIC S9(9)  COMP VALUE 0.        
           05  WS-21-READ-DATE          PIC X(10)  VALUE SPACES.        
           05  WS-21-CSR-READ-DATE      PIC X(10)  VALUE SPACES.        
           05  WS-21-XTRCT-DATE         PIC X(10)  VALUE SPACES.        
           05  WS-21-DATE-EXTRACT       PIC X(10)  VALUE SPACES.        
           05  WS-20-CLOSE-DATE         PIC X(10)  VALUE SPACES.        
           05  WS-REV-CALC-DATE         PIC X(10)  VALUE SPACES.        
           05  TEMP-RETURN-CODE         PIC S9(09) USAGE COMP VALUE +0. 
           05  WS-READ-CYCLE            PIC X(02).                      
           05  WS-READ-CYCLE-NUM REDEFINES WS-READ-CYCLE                
                                        PIC 9(02).                      
           05  WS-REV-CALC-CYCLE        PIC X(02).                      
           05  WS-REV-CALC-CYCLE-NUM REDEFINES WS-REV-CALC-CYCLE        
                                        PIC 9(02).                      
           05  WS-COMPANY-NO-AT         PIC X(02)  VALUE SPACES.        
           05  WS-PGRMNAME              PIC X(10)  VALUE 'PCSKR366'.    
      *                                                                 01472054
           05  WS-HOLD-DATE-X.                                          
               10  WS-HOLD-DATE-YEAR    PIC X(04).                      
               10  FILLER               PIC X(01).                      
               10  WS-HOLD-DATE-MO      PIC X(02).                      
               10  FILLER               PIC X(01).                      
               10  WS-HOLD-DATE-DAY     PIC X(02).                      
           05  WS-HOLD-DATE     REDEFINES WS-HOLD-DATE-X PIC X(10).     
      *                                                                         
           05  WS-XTRCT-DATE.                                           
               10  WS-XTRCT-YR          PIC X(04).                      
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-XTRCT-MO          PIC X(02).                      
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-XTRCT-DAY         PIC X(02).                      
      *                                                                 01540037
           05  WS-PRV-XTRCT-DATE        PIC  X(10) VALUE SPACES.        
      *                                                                 01540037
           05  WS-PREV-TPRD-DATE        PIC X(10).                      
           05  WS-TPRD-RD-DATE          PIC X(10).                      
      *                                                                 01540037
           05  WS-PREV-DATE             PIC X(10).                      
           05  WS-CURR-YEAR             PIC X(02).                      
           05  WS-REVENUE-DATE          PIC 9(06).                      
           05  WS-REVENUE-DATE-RED REDEFINES WS-REVENUE-DATE.           
               10  WS-REV-DATE-CCYY     PIC 9(04).                      
               10  WS-REV-DATE-MM       PIC 9(02).                      
COB305     05 WS-REVENUE-MONTH        PIC S999999V USAGE COMP-3 VALUE 0.      
COB305     05 WS-REVENUE-MONTH-CM        PIC S999999V USAGE COMP-3 
COB305       VALUE 0.      
           05  WS-REVENUE-MONTH-N       PIC 9(6) VALUE 0.               
      *                                                                 01580000
           05  WS-PREV-REVENUE-DATE     PIC 9(06).                      
           05  WS-PREV-REVENUE-DATE-RED  REDEFINES                      
                  WS-PREV-REVENUE-DATE.                                 
               10  WS-PREV-REV-DATE-CCYY  PIC 9(04).                    
               10  WS-PREV-REV-DATE-MM  PIC 9(02).                      
COB305     05 WS-PREV-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.        
      *                                                                 01580000
           05  WS-CYCLE-90-OPT-READ.                                    
               20  WS-CYCLE-90-YR       PIC X(04).                      
               20  WS-FILLER1           PIC X(01) VALUE '-'.            
               20  WS-CYCLE-90-MO       PIC X(02).                      
               20  WS-FILLER1           PIC X(01) VALUE '-'.            
               20  WS-CYCLE-90-DAY      PIC X(02) VALUE '15'.           
           05  WS-PREV-BUSINESS-DAY     PIC X(10).                      
           05  WS-DAY-OF-WEEK           PIC S9(04) COMP.                
           05  WS-SUNDAY                PIC S9(04) COMP VALUE +1.       
           05  WS-SATURDAY              PIC S9(04) COMP VALUE +7.       
           05  WS-MAX-NO-CYCLES         PIC 9(02)  VALUE 21.            
      *                                                                 01790000
           05  WS-ARR-DELINQ-CD         PIC X(20)  OCCURS 18 TIMES.     
COB305     05 WS-ARR-DELINQ-VALUE        PIC S9(4)V9(5) COMP-3 
COB305       OCCURS 18 TIMES VALUE 0.      
           05  WS-DELINQ-FORECAST          PIC X(02).                   
           05  WS-DNP-DT-DELQ-VALUE      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-MAIL-DT-DELQ-VALUE     PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-DUE-DT-DELQ-VALUE      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-FIELD-DT-DELQ-VALUE    PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-DPP-DT-DELQ-VALUE      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-TOT-DT-DELQ-VALUE      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-NU-DT-DELQ-VALUE       PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-CBILL-DT-DELQ-VALUE    PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-NONRES-DT-DELQ-VALUE   PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-CB15CYCLE-DELQ-VALUE   PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-CB610CYCLE-DELQ-VALUE  PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-CB1115CYCLE-DELQ-VALUE PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-CB1620CYCLE-DELQ-VALUE PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  TB-CRED-INDEX             PIC S9(9)  USAGE COMP VALUE 0. 
           05  WS-BILL-WNDW-REV-MTH      PIC S9(6)V VALUE 0.            
           05  WS-CRED-FCST-REV-MTH      PIC S9(6)V VALUE 0.            
           05  WS-CURR-REVENUE-MONTH.                                   
               10  WS-CURR-REV-YEAR      PIC 9(4).                      
               10  WS-CURR-REV-MONTH     PIC 9(2).                      
           05  WS-NEXT-REVENUE-DATE      PIC 9(06).                     
           05  WS-NEXT-REV-DATE REDEFINES WS-NEXT-REVENUE-DATE.         
               10  WS-NEXT-REV-YEAR      PIC 9(04).                     
               10  WS-NEXT-REV-MTH       PIC 9(02).                     
           05  WS-PREV-REVENUE-DATE-CM   PIC 9(06).                     
           05  WS-PREV-REV-DATE REDEFINES WS-PREV-REVENUE-DATE-CM.      
               10  WS-PREV-REV-YEAR      PIC 9(04).                     
               10  WS-PREV-REV-MTH       PIC 9(02).                     
           05  WS-TEMP-FCST-REV-MTH      PIC 9(6)   VALUE 0.            
           05  WS-PREV-BILL-CYCLE        PIC X(02)  VALUE SPACES.       
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY          PIC X(04) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-DATE-MM            PIC X(02) VALUE SPACES.        
               10  FILLER                PIC X(01) VALUE '-'.           
               10  WS-DATE-DD            PIC X(02) VALUE '01'.          
           05  WS-PREVIOUS-REV-MONTH   REDEFINES WS-DATE-CCYY-MM-DD     
                                         PIC X(10).                     
           05  WS-PREV-REV-MONTH         PIC X(06).                     
           05  WS-PREV-REV-MONTH-RED  REDEFINES WS-PREV-REV-MONTH       
                                         PIC 9(06).                     
COB305     05 WS-PARM-PREV-REV-MONTH-NUM        PIC S999999V 
COB305       USAGE COMP-3 VALUE 0.    
COB305     05 WS-PARM-PREV-REV-MONTH        PIC S999999V USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-REV-MONTH-CM        PIC S9(6)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-REV-MONTH-BN        PIC S9(6)V USAGE COMP-3 VALUE 0.       
COB305     05 WS-NEXT-REV-MONTH-CM        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.       
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-ARREARS-DUE-NULL-IND   PIC S9(04) COMP  VALUE 0.      
           05  WS-CURR-CHG-DUE-NULL-IND  PIC S9(04) COMP  VALUE 0.      
           05  WS-DNP-NOTICE-DUE-NULL-IND PIC S9(04) COMP VALUE 0.      
           05  WS-DNP-NOTICE-MAIL-NULL-IND PIC S9(04) COMP VALUE 0.     
           05  WS-DNP-REVIEW-NULL-IND    PIC S9(04) COMP  VALUE 0.      
           05  WS-DNP-NULL-IND           PIC S9(04) COMP  VALUE 0.      
           05  WS-IVR-CALL-NULL-IND      PIC S9(04) COMP  VALUE 0.      
           05  WS-AVOID-LPC-NULL-IND     PIC S9(04) COMP  VALUE 0.      
           05  WS-NONUTIL-WQ-NULL-IND    PIC S9(04) COMP  VALUE 0.      
           05  WS-CRED-BUR-NULL-IND      PIC S9(04) COMP  VALUE 0.      
           05  WS-BILL-WNDW-REV-NULL     PIC S9(04) COMP  VALUE 0.      
           05  WS-CRED-FCST-REV-NULL     PIC S9(04) COMP  VALUE 0.      
      *                                                                         
       01  WS-DELINQUENCY-VALUES-TABLE.                                 
           05  WS-DELINQ-FORECAST-ENTRY-TB                              
               OCCURS 5 TIMES                                           
               INDEXED BY TB-FC-INDEX.                                  
               10  WS-DELINQ-VALUE-ENTRY-TB                             
                   OCCURS 19 TIMES                                      
                   INDEXED BY TB-VAL-INDEX.                             
                   15  WS-DELINQ-FORECAST-TB  PIC X(02).                
                   15  WS-DELINQ-CODE-TB      PIC X(20).                
COB305             15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305               VALUE 0.    
           05  WS-DEQ-ROW-COUNT         PIC 9(02)  VALUE 0.             
           05  CRED-DEQ-IDX             PIC 9(02)  VALUE 0.             
           05  WS-DAYS-TO-ADD           PIC S9(4)  COMP.                
I01687     05  WS-DAYS-TO-MINUS         PIC S9(4)  COMP.                
           05  WS-DATE-INPUT            PIC  X(10) VALUE SPACES.        
           05  WS-OUT-DATE              PIC  X(10) VALUE SPACES.        
           05  WS-ARREARS-DUE-DT        PIC  X(10) VALUE SPACES.        
           05  WS-AVOID-LPC-DT          PIC  X(10) VALUE SPACES.        
           05  WS-CURR-CHG-DUE-DT       PIC  X(10) VALUE SPACES.        
           05  WS-DNP-DT                PIC  X(10) VALUE SPACES.        
           05  WS-DNP-NOTICE-DUE-DT     PIC  X(10) VALUE SPACES.        
           05  WS-DNP-NOTICE-MAIL-DT    PIC  X(10) VALUE SPACES.        
           05  WS-DNP-REVIEW-DT         PIC  X(10) VALUE SPACES.        
           05  WS-IVR-CALL-DT           PIC  X(10) VALUE SPACES.        
           05  WS-NONUTIL-WQ-DT         PIC  X(10) VALUE SPACES.        
           05  WS-HOLIDAY-EXISTS        PIC  X(01).                     
               88 HOLIDAY-EXISTS-NO     VALUE 'N'.                      
               88 HOLIDAY-EXISTS-YES    VALUE 'Y'.                      
           05  WS-PREV-BUS-DAY-FLAG     PIC X(01) VALUE 'N'.            
               88 PREV-BUS-DAY-FOUND    VALUE 'Y'.                      
      *                                                                         
       01 WS-ONE-TIME-EACH-CYCLE.                                       
          05 TMP-CURR-CHG-DUE-DT         PIC  X(10) VALUE SPACES.       
          05 TMP-DNP-REVIEW-DT           PIC  X(10) VALUE SPACES.       
          05 TMP-DNP-DT                  PIC  X(10) VALUE SPACES.       
          05 TMP-DNP-NOTICE-MAIL-DT      PIC  X(10) VALUE SPACES.       
          05 TMP-DNP-NOTICE-DUE-DT       PIC  X(10) VALUE SPACES.       
          05 TMP-IVR-CALL-DT             PIC  X(10) VALUE SPACES.       
          05 TMP-ARREARS-DUE-DT          PIC  X(10) VALUE SPACES.       
          05 TMP-AVOID-LPC-DT            PIC  X(10) VALUE SPACES.       
          05 TMP-NONUTIL-WQ-DT           PIC  X(10) VALUE SPACES.       
          05 TMP-CRED-BUR-RPT-DT         PIC  X(10) VALUE SPACES.       
          05 TMP-CURR-CHG-DUE-IND        PIC S9(04) COMP  VALUE 0.      
          05 TMP-DNP-REVIEW-IND          PIC S9(04) COMP  VALUE 0.      
          05 TMP-DNP-IND                 PIC S9(04) COMP  VALUE 0.      
          05 TMP-DNP-NOTICE-DUE-IND      PIC S9(04) COMP  VALUE 0.      
          05 TMP-DNP-NOTICE-MAIL-IND     PIC S9(04) COMP  VALUE 0.      
          05 TMP-IVR-CALL-IND            PIC S9(04) COMP  VALUE 0.      
          05 TMP-ARREARS-DUE-IND         PIC S9(04) COMP  VALUE 0.      
          05 TMP-AVOID-LPC-IND           PIC S9(04) COMP  VALUE 0.      
          05 TMP-NONUTIL-WQ-IND          PIC S9(04) COMP  VALUE 0.      
          05 TMP-CRED-BUR-IND            PIC S9(04) COMP  VALUE 0.      
      *                                                                         
       01 WS-BILL-SCH-ARRAY.                                            
          05 BILL-SUB                  PIC S9(9) COMP VALUE 0.          
          05 BILL-SCH-TAB.                                              
             10 TAB-BN-CYCLE           PIC X(02) OCCURS 125 TIMES.      
             10 TAB-BN-XTRACT-DT       PIC X(10) OCCURS 125 TIMES.      
             10 TAB-BN-BILL-COND       PIC X(01) OCCURS 125 TIMES.      
COB305       10 TAB-BN-REVENUE-MONTH        PIC S9(6)V COMP-3 
COB305          OCCURS 125 TIMES VALUE 0.      
             10 TAB-BN-REV-CALC-CYCLE  PIC X(02) OCCURS 125 TIMES.      
      *                                                                         
COB305 01 MFA-BN-REVENUE-MONTH        PIC S9(6)V COMP-3 
COB305       OCCURS 125 TIMES VALUE 0.
      *
       01 WS-WORK-SCH-ARRAY.                                            
          05 READ-SUB                  PIC 9(02) VALUE 0.               
          05 READ-SUB1                 PIC 9(02) VALUE 0.               
          05 READ-COUNT-MAX            PIC 9(02) VALUE 0.               
          05 WORK-SCH-TAB.                                              
             10 TAB-CYCLE                 PIC X(02) OCCURS 40 TIMES.    
             10 TAB-READ-XTRACT-DT        PIC X(10) OCCURS 40 TIMES.    
             10 TAB-OPTIMUM-READ-DT       PIC X(10) OCCURS 40 TIMES.    
COB305       10 TAB-REVENUE-MONTH        PIC S9(6)V COMP-3 
COB305          OCCURS 40 TIMES VALUE 0.    
             10 TAB-UT-READ-CYCLE         PIC X(02) OCCURS 40 TIMES.    
             10 TAB-3RD-PTY-READ-DT       PIC X(10) OCCURS 40 TIMES.    
             10 TAB-3RD-PTY-NULL-IND      PIC S9(04) COMP               
                                                    OCCURS 40 TIMES.    
             10 TAB-BILL-XTRACT-DT        PIC X(10) OCCURS 40 TIMES.    
      *                                                                         
MAN006 01 MFA-COUNT PIC 9(8) COMP.
COB305 01 MFA-RW-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       OCCURS 40 TIMES VALUE 0.
      *
       01  WS-CRED-FORECAST-ARRAY.                                      
           05  WS-COMPANY-NO             PIC X(2)                       
                                         OCCURS 500 TIMES.              
           05  WS-REG-GROUP-CD           PIC X(3)                       
                                         OCCURS 500 TIMES.              
COB305     05 WS-REVENUE-MNTH        PIC S9(6)V USAGE COMP-3 
COB305       OCCURS 500 TIMES VALUE 0.              
           05  WS-BILL-DT                PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-BILL-CYCLE             PIC X(2)                       
                                         OCCURS 500 TIMES.              
           05  WS-CREDIT-GROUP           PIC X(1)                       
                                         OCCURS 500 TIMES.              
           05  WS-CREDIT-GROUP-ID        PIC X(3)                       
                                         OCCURS 500 TIMES.              
           05  WS-CRED-ACCT-TYPE-CD      PIC X(1)                       
                                         OCCURS 500 TIMES.              
           05  WS-CRED-FORECAST-CD       PIC X(2)                       
                                         OCCURS 500 TIMES.              
           05  WS-ARREARS-DUE-DATE       PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-ARRERS-DUE-NULL-IND    PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-CURR-CHG-DUE-DATE      PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-CURR-CHG-NULL-IND      PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-DNP-NOTICE-DUE-DATE    PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-DNP-NOTICE-NULL-IND    PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-DNP-NOTICE-MAIL-DATE   PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-DNP-MAIL-NULL-IND      PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-DNP-REVIEW-DATE        PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-DNP-REV-NULL-IND       PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-DNP-DATE               PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-DNP-DATE-NULL-IND      PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-IVR-CALL-DATE          PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-IVR-DT-NULL-IND        PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-AVOID-LPC-DATE         PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-LPC-DT-NULL-IND        PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-NONUTIL-WQ-DATE        PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-WQ-DT-NULL-IND         PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
           05  WS-CRED-BUR-RPT-DATE      PIC X(10)                      
                                         OCCURS 500 TIMES.              
           05  WS-BUR-RPT-DT-NULL-IND    PIC S9(04) COMP                
                                         OCCURS 500 TIMES.              
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-INSERT-COUNT           PIC S9(09) COMP VALUE 0.       
           05  WS-DEFAULT-INSERT-COUNT   PIC S9(09) COMP VALUE +50.     
           05  WS-READY-TO-INSERT-COUNT  PIC S9(09) COMP VALUE 499.     
           05  WS-DELINQ-COUNT           PIC S9(04) COMP VALUE 0.       
           05  WS-FORECAST-COUNT         PIC S9(04) COMP VALUE 0.       
      *                                                                         
       01  WS-DELINQ-TABLE.                                             
           05 WS-DELINQ-DATA-TB OCCURS 35                               
                              INDEXED BY DELQ-INDX.                     
              10 WS-COMPANY-NO-C8        PIC X(2).                      
              10 WS-DELINQ-CD-C8         PIC X(20).                     
              10 WS-DELINQ-VALUE-C8      PIC 9(4)V9(5).                 
      *                                                                         
       01 WS-BILL-WNDW-TABLE.                                           
          05 WS-NEXT-READ-DT           PIC  X(10) VALUE SPACES.         
          05 WS-NEXT-BILL-OPEN-DT      PIC  X(10) VALUE SPACES.         
          05 WS-BILL-CYC-CLOSE-DT      PIC  X(10)  VALUE SPACES.        
          05 WS-BILL-WND-COUNT         PIC S9(04) COMP VALUE 0.         
          05 BILL-WNDW-SUB             PIC S9(04) COMP VALUE 0.         
          05 WS-BILL-WNDW-DATA-TB.                                      
             10 WS-DATE-EXTRACT-BW      PIC X(10) OCCURS 150 TIMES.     
             10 WS-BILL-CYCLE-BW        PIC X(2)  OCCURS 150 TIMES.     
             10 WS-CODE-BILL-COND-BW    PIC X(1)  OCCURS 150 TIMES.     
             10 WS-DATE-BN-CLOSE-BW     PIC X(10) OCCURS 150 TIMES.     
             10 WS-NEXT-BILL-DT-BW      PIC X(10) OCCURS 150 TIMES.     
             10 WS-NEXT-READ-DT-BW      PIC X(10) OCCURS 150 TIMES.     
      *                                                                         
       01  WS-DATE-FIELDS.                                              
           05  WS-IVR-DT                 PIC X(10)  VALUE SPACES.       
           05  WS-DAY-DPP-MAIL-DT        PIC X(10)  VALUE SPACES.       
          05  WS-CRED-BUR-RPT-DT         PIC  X(10) VALUE SPACES.       
           05  WS-NONUTIL-WQ-DT-TEMP     PIC X(10)  VALUE SPACES.       
           05  WS-OPTIMUM-NULL-IND       PIC S9(04) COMP  VALUE 0.      
           05  WS-THIRD-PTY-NULL-IND     PIC S9(04) COMP  VALUE 0.      
      *                                                                         
       01 WS-BUSI-DAY-TABLE.                                            
          05 WS-BUSI-DAY-LIST.                                          
             10 WS-BUSI-DAY              PIC X(10) OCCURS 120 TIMES.    
      *                                                                         
       01 WS-WORK-DAY-TABLE REDEFINES WS-BUSI-DAY-TABLE.                
          05 WS-WORK-DAY-LIST OCCURS 120 TIMES                          
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
             10 WS-WORK-DAY              PIC X(10).                     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
      *                                                                         
       COPY CWS00303.                                                   00791730
       COPY FIOJC01.                                                    00791930
      *                                                                         
      *===============================================================*         
      *    DB2 TABLES INCLUDED IN PROGRAM                             *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     01880000
               INCLUDE SQLCA                                            01890000
           END-EXEC.                                                    01900000
      *                                                                         
      *===============================================================* 01910000
      * CSS_BILL_WINDOW - BN                                          *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     01920031
             INCLUDE TBBILWDW                                           01930061
           END-EXEC.                                                    01940031
      *                                                                         
      *===============================================================*         
      * CSS_CRED_FORECAST - CM                                        *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCRFCST                                                   
           END-EXEC.                                                            
      *                                                                         
      *===============================================================*         
      * CSS_DELINQUENCY - C8                                          *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     01920031
             INCLUDE TBDELQ                                             01930061
           END-EXEC.                                                    01940031
      *                                                                         
      *===============================================================* 01990031
      * CSS_ERROR_MSG - B5                                            *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     02210005
             INCLUDE TBERRMSG                                           02220005
           END-EXEC.                                                    02230005
      *                                                                         
      *===============================================================* 02250005
      * CSS_HOLIDAY - J8                                              * 01910000
      *===============================================================* 01950000
      *                                                                         
           EXEC SQL                                                     02260031
             INCLUDE TBHLDAY                                            02253061
           END-EXEC.                                                    02280031
      *                                                                         
      *===============================================================* 02290031
      * CSS_JOB_PARM - G6                                             *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *===============================================================* 00142500
      * CSS_READ_WINDOW - RW                                          *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     01960031
             INCLUDE TBRDWNDW                                           01970031
           END-EXEC.                                                    01980031
      *                                                                         
      *===============================================================* 01910000
      * CSS_BUSINESS_DAYS - 1G                                        *         
      *===============================================================*         
      *                                                                         
           EXEC SQL                                                     01920031
             INCLUDE TBBUSDAY                                           01930061
           END-EXEC.                                                    01940031
      *                                                                         
      *===============================================================*         
      * CSS_CODE_VALUE - UV                                           *         
      *===============================================================*         
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
       01  FILLER                      PIC X(38)                        
           VALUE 'WORKING STORAGE FOR CSR04580 ENDS HERE'.              
      *                                                                 02670000
      *                                                                         
      *===============================================================* 00010003
      *  CURSOR DECLARATION FOR THE CSS_BILL_WINDOW TABLE.            * 00021003
      *===============================================================* 00030003
      *                                                                         
           EXEC SQL                                                     
             DECLARE BILL-WINDOW CURSOR WITH ROWSET POSITIONING FOR     
               SELECT BN.DATE_EXTRACT                                   
                     ,BN.BILL_CYCLE                                     
                     ,BN.CODE_BILL_COND                                 
                     ,RS.NEXT_BILL_DATE                                 
                     ,RS.NEXT_READ_DATE                                 
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
                  ,(SELECT MIN(BN2.DATE_EXTRACT) AS NEXT_BILL_DATE      
                          ,BN2.BILL_CYCLE                               
                          , (RW2.OPTIMUM_READ_DATE) AS NEXT_READ_DATE   
                    FROM CSS_BILL_WINDOW BN2 WITH(READUNCOMMITTED)              
                        ,CSS_READ_WINDOW RW2 WITH(READUNCOMMITTED)              
                    WHERE BN2.REVENUE_MONTH = :WS-NEXT-REV-MONTH-CM     
                      AND BN2.REVENUE_MONTH = RW2.REVENUE_MONTH         
                      AND BN2.BILL_CYCLE    = RW2.READ_CYCLE            
                    GROUP BY BN2.BILL_CYCLE                             
                            ,RW2.OPTIMUM_READ_DATE                      
                            ,RW2.THIRD_PTY_READ_DT) RS                  
                WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                 
                  AND BN.BILL_CYCLE = RS.BILL_CYCLE                     
                ORDER BY BN.BILL_CYCLE                                  
                        ,BN.DATE_EXTRACT                                
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BILL-WINDOW CURSOR WITH ROWSET POSITIONING FOR             
MFA-TR*        SELECT BN.DATE_EXTRACT                                           
MFA-TR*              ,BN.BILL_CYCLE                                             
MFA-TR*              ,BN.CODE_BILL_COND                                         
MFA-TR*              ,RS.NEXT_BILL_DATE                                         
MFA-TR*              ,RS.NEXT_READ_DATE                                         
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*           ,(SELECT MIN(BN2.DATE_EXTRACT) AS NEXT_BILL_DATE              
MFA-TR*                   ,BN2.BILL_CYCLE                                       
MFA-TR*                   , (RW2.OPTIMUM_READ_DATE) AS NEXT_READ_DATE           
MFA-TR*             FROM CSS_BILL_WINDOW BN2                                    
MFA-TR*                 ,CSS_READ_WINDOW RW2                                    
MFA-TR*             WHERE BN2.REVENUE_MONTH = :WS-NEXT-REV-MONTH-CM             
MFA-TR*               AND BN2.REVENUE_MONTH = RW2.REVENUE_MONTH                 
MFA-TR*               AND BN2.BILL_CYCLE    = RW2.READ_CYCLE                    
MFA-TR*             GROUP BY BN2.BILL_CYCLE                                     
MFA-TR*                     ,RW2.OPTIMUM_READ_DATE                              
MFA-TR*                     ,RW2.THIRD_PTY_READ_DT) RS                          
MFA-TR*         WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                         
MFA-TR*           AND BN.BILL_CYCLE = RS.BILL_CYCLE                             
MFA-TR*         ORDER BY BN.BILL_CYCLE                                          
MFA-TR*                 ,BN.DATE_EXTRACT                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      *  CURSOR DECLARATION FOR THE CSS_DELINQUENCY TABLE.             *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             DECLARE DELINQ-CURSOR CURSOR  WITH ROWSET POSITIONING FOR  
                   SELECT C8.DELINQ_CD                                  
                         ,C8.DELINQ_VALUE                               
                         ,C8.COMPANY_NO                                 
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                   WHERE C8.DELINQ_CD  IN                               
                    ( 'DAY-DNP'                                         
                     ,'DAY-SECOND-MAIL'                                 
                     ,'DAY-DUE'                                         
                     ,'DAY-SECOND-FIELD'                                
                     ,'DAY-DPP-SECOND-MAIL'                             
                     ,'DAY-TOTAL-DUE'                                   
                     ,'DAY-NU-WQDELQ'                                   
                     ,'DAY-CBILL-DELQ-WQ'                               
                     ,'DAY-DUE-NONRES'                                  
                     ,'DAY-CB15CYCLES'                                  
                     ,'DAY-CB610CYCLES'                                 
                     ,'DAY-CB1115CYCLES'                                
                     ,'DAY-CB1620CYCLES'                                
                     ,'ARREARS-DUE-DT-A'                                
                     ,'AVOID-LPC-DT-A'                                  
I01687               ,'AVOID-LPC-DT-SEB-A'                              
                     ,'CURR-CHG-DUE-DT-A'                               
                     ,'DNP-DT-A'                                        
                     ,'DNP-NOTICE-DUE-DT-A'                             
                     ,'DNP-NOTICE-MAIL-DT-A'                            
                     ,'DNP-REVIEW-DT-A'                                 
                     ,'IVR-CALL-DT-A'                                   
                     ,'NONUTIL-WQ-DT-A'                                 
                     ,'ARREARS-DUE-DT-B'                                
                     ,'AVOID-LPC-DT-B'                                  
I01687               ,'AVOID-LPC-DT-SEB-B'                              
                     ,'CURR-CHG-DUE-DT-B'                               
                     ,'DNP-DT-B'                                        
                     ,'DNP-NOTICE-DUE-DT-B'                             
                     ,'DNP-NOTICE-MAIL-DT-B'                            
                     ,'DNP-REVIEW-DT-B'                                 
                     ,'IVR-CALL-DT-B'                                   
                     ,'NONUTIL-WQ-DT-B')                                
                   ORDER BY C8.COMPANY_NO                               
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DELINQ-CURSOR CURSOR  WITH ROWSET POSITIONING FOR          
MFA-TR*            SELECT C8.DELINQ_CD                                          
MFA-TR*                  ,C8.DELINQ_VALUE                                       
MFA-TR*                  ,C8.COMPANY_NO                                         
MFA-TR*            FROM CSS_DELINQUENCY C8                                      
MFA-TR*            WHERE C8.DELINQ_CD  IN                                       
MFA-TR*             ( 'DAY-DNP'                                                 
MFA-TR*              ,'DAY-SECOND-MAIL'                                         
MFA-TR*              ,'DAY-DUE'                                                 
MFA-TR*              ,'DAY-SECOND-FIELD'                                        
MFA-TR*              ,'DAY-DPP-SECOND-MAIL'                                     
MFA-TR*              ,'DAY-TOTAL-DUE'                                           
MFA-TR*              ,'DAY-NU-WQDELQ'                                           
MFA-TR*              ,'DAY-CBILL-DELQ-WQ'                                       
MFA-TR*              ,'DAY-DUE-NONRES'                                          
MFA-TR*              ,'DAY-CB15CYCLES'                                          
MFA-TR*              ,'DAY-CB610CYCLES'                                         
MFA-TR*              ,'DAY-CB1115CYCLES'                                        
MFA-TR*              ,'DAY-CB1620CYCLES'                                        
MFA-TR*              ,'ARREARS-DUE-DT-A'                                        
MFA-TR*              ,'AVOID-LPC-DT-A'                                          
MFA-TR*              ,'AVOID-LPC-DT-SEB-A'                                      
MFA-TR*              ,'CURR-CHG-DUE-DT-A'                                       
MFA-TR*              ,'DNP-DT-A'                                                
MFA-TR*              ,'DNP-NOTICE-DUE-DT-A'                                     
MFA-TR*              ,'DNP-NOTICE-MAIL-DT-A'                                    
MFA-TR*              ,'DNP-REVIEW-DT-A'                                         
MFA-TR*              ,'IVR-CALL-DT-A'                                           
MFA-TR*              ,'NONUTIL-WQ-DT-A'                                         
MFA-TR*              ,'ARREARS-DUE-DT-B'                                        
MFA-TR*              ,'AVOID-LPC-DT-B'                                          
MFA-TR*              ,'AVOID-LPC-DT-SEB-B'                                      
MFA-TR*              ,'CURR-CHG-DUE-DT-B'                                       
MFA-TR*              ,'DNP-DT-B'                                                
MFA-TR*              ,'DNP-NOTICE-DUE-DT-B'                                     
MFA-TR*              ,'DNP-NOTICE-MAIL-DT-B'                                    
MFA-TR*              ,'DNP-REVIEW-DT-B'                                         
MFA-TR*              ,'IVR-CALL-DT-B'                                           
MFA-TR*              ,'NONUTIL-WQ-DT-B')                                        
MFA-TR*            ORDER BY C8.COMPANY_NO                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7500                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                 02750000
      *===============================================================* 00010003
      *  CURSOR DECLARATION FOR THE CSS_BUSINESS_DAYS TABLE.          * 00021003
      *===============================================================* 00030003
      *                                                                         
           EXEC SQL                                                     
             DECLARE WORK-CUR CURSOR WITH ROWSET POSITIONING FOR        
               SELECT TOP(120) BUSINESS_DAY_DT                                  
                  FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                  
               WHERE BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )            
               ORDER BY BUSINESS_DAY_DT                                 
                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WORK-CUR CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*        SELECT BUSINESS_DAY_DT                                           
MFA-TR*           FROM CSS_BUSINESS_DAYS                                        
MFA-TR*        WHERE BUSINESS_DAY_DT >= :WS-NEW-BUSINESS-DAY                    
MFA-TR*        ORDER BY BUSINESS_DAY_DT                                         
MFA-TR*        FETCH FIRST 120 ROWS ONLY WITH UR                                
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                 02750000
       LINKAGE SECTION.                                                 
       01 PARM-READ-CYCLE           PIC X(02).                          
       01 PARM-BILL-CYCLE-OPEN-DT   PIC X(10).                          
       01 PARM-REV-YR               PIC X(04).                          
       01 PARM-REV-MO               PIC X(02).                          
       01 PARM-THIRD-PTY-READ-DT    PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING PARM-READ-CYCLE                         
                               ,PARM-BILL-CYCLE-OPEN-DT                 
                               ,PARM-REV-YR                             
                               ,PARM-REV-MO                             
                               ,PARM-THIRD-PTY-READ-DT.                 
      *                                                                 02750000
      *===============================================================* 02760000
      *      THE FOLLOWING IS THE MAJOR CONTROL FOR THE PROGRAM       * 02780000
      *===============================================================* 02800000
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                 02820000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                 02860000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 02891031
       0100-INITIALIZATION.                                             
      *===============================================================* 02899031
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 05550000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 05770000
           EXEC SQL                                                     
                DECLARE C1 CURSOR                            
                                  WITH ROWSET POSITIONING FOR           
                 SELECT :S-RETURN-CODE       AS RETURN_CODE             
                       ,:S-APPL-RETURN-CODE  AS APPL_RETURN_CODE        
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*          SELECT :S-RETURN-CODE       AS RETURN_CODE                     
MFA-TR*                ,:S-APPL-RETURN-CODE  AS APPL_RETURN_CODE                
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                 02899631
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 02901000
       1000-PROCESS-INPUT.                                              
      *===============================================================* 02980000
      *                                                                         
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7000-WHICH-DBASE         THRU 7000-EXIT.             
           MOVE WS-DATABASE                 TO WS-DATABASE-FL.          
           PERFORM 1100-VALIDATE-PARM-DET   THRU 1100-EXIT.             
           IF SEB-DATABASE                                              
               MOVE 'PCSSF47A'              TO PROGRAM-NAME-BILL-WIN    
           END-IF.                                                      
      *                                                                         
           MOVE PROGRAM-NAME-BILL-WIN       TO WS-PROGRAM.              
           MOVE WS-PARM                     TO WS-COMMAND.              
           PERFORM 7600-START-FCSJC01           THRU 7600-EXIT.         
           PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT.         
           IF END-OF-SYSIPT                                             
               IF CSR-DATABASE                                          
                  MOVE 5                    TO WS-BILL-WIN-COUNT        
                                               WS-BILL-WINDOW-PARM      
               ELSE                                                     
                  MOVE 3                    TO WS-BILL-WIN-COUNT        
                                               WS-BILL-WINDOW-PARM      
               END-IF                                                   
           ELSE                                                         
               MOVE WS-BILL-WINDOW-PARM     TO WS-BILL-WIN-COUNT        
           END-IF.                                                      
      *                                                                         
           PERFORM 7611-CLOSE                    THRU 7611-EXIT.        
      *                                                                         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03372047
      *==============================================================*  04450000
       1100-VALIDATE-PARM-DET.                                          
      *==============================================================*  04510000
      *  VALIDATE THE INPUT PARAMETER FROM THE FRONT END .                      
      *                                                                 04530000
           MOVE '1100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 04530000
           MOVE PARM-READ-CYCLE             TO WS-INPUT-CYCLE           
                                               BN-BILL-CYCLE            
                                               WS-READ-CYCLE.           
           MOVE PARM-BILL-CYCLE-OPEN-DT     TO WS-INPUT-CYCLE-OPEN-DT   
                                               WS-XTRCT-DATE            
                                               BN-DATE-EXTRACT.         
           MOVE PARM-REV-YR                 TO WS-CYCLE-90-YR           
                                               WS-REV-DATE-CCYY.        
           MOVE PARM-REV-MO                 TO WS-CYCLE-90-MO           
                                               WS-REV-DATE-MM.          
           MOVE WS-REVENUE-DATE             TO WS-INPUT-REVENUE-MONTH   
                                               RW-REVENUE-MONTH         
                                               BN-REVENUE-MONTH.        
           MOVE PARM-THIRD-PTY-READ-DT      TO WS-INPUT-3RD-PTY-READ-DT 
                                               WS-TPRD-RD-DATE.         
           MOVE PARM-REV-YR                 TO WS-REV-MNTH-DT-ST(1:4)   
           MOVE '-'                         TO WS-REV-MNTH-DT-ST(5:1)   
           MOVE PARM-REV-MO                 TO WS-REV-MNTH-DT-ST(6:2)   
           MOVE '-'                         TO WS-REV-MNTH-DT-ST(8:1)   
           MOVE '01'                        TO WS-REV-MNTH-DT-ST(9:2)   
      *                                                                         
           IF SEB-DATABASE AND PARM-THIRD-PTY-READ-DT  = SPACES         
               MOVE 200                      TO S-APPL-RETURN-CODE      
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 7370-REV-MNTH-LAST-DAY   THRU 7370-EXIT.             
                                                                        
           IF BN-BILL-CYCLE NOT = '01'                                  
               MOVE 300                      TO S-APPL-RETURN-CODE      
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 7960-GET-BILL-REVENUE-MONTH THRU 7960-EXIT.          
           IF WS-BN-REV-MONTH = BN-REVENUE-MONTH                        
               MOVE 400                         TO S-APPL-RETURN-CODE   
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 3200-CALC-PREV-REVENUE-MONTH THRU 3200-EXIT.         
           IF WS-BN-REV-MONTH  = WS-PREV-REVENUE-MONTH                  
              CONTINUE                                                  
           ELSE                                                         
               MOVE 500                      TO S-APPL-RETURN-CODE      
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7970-GET-READ-REVENUE-MONTH THRU 7970-EXIT.          
           IF WS-RW-REV-MONTH = RW-REVENUE-MONTH                        
               MOVE 600                         TO S-APPL-RETURN-CODE   
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-RW-REV-MONTH  = WS-PREV-REVENUE-MONTH                  
              CONTINUE                                                  
           ELSE                                                         
               MOVE 700                      TO S-APPL-RETURN-CODE      
               PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
               PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *=============================================================*   04450000
       2000-PROCESS-OUTPUT.                                             
      *=============================================================*   04510000
      *  PROCESS CSS_BILL_WINDOW AND CSS_READ_WINDOW TABLE FOR EACH             
      *  CYCLE GIVEN REVENUE MONTH IN THE PANEL.                                
      *                                                                 04530000
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-PREV-REVENUE-MONTH       TO WS-PREV-REVENUE-DATE     
           PERFORM 2600-LOAD-BUSINESS-DAYS       THRU 2600-EXIT.        
                                                                        
           PERFORM 2100-PREPARE-READ-WINDOW     THRU 2100-EXIT.         
           PERFORM 2200-PREPARE-BILL-WINDOW     THRU 2200-EXIT.         
                                                                        
           PERFORM 2300-LOAD-DELINQUENCY-VALUES  THRU 2300-EXIT.        
                                                                        
           PERFORM 7990-GET-CRED-REVENUE-MONTH   THRU 7990-EXIT.        
           EVALUATE TRUE                                                
              WHEN WS-REV-MONTH-CM  =  WS-PREV-REVENUE-MONTH            
                PERFORM 8500-DELETE-CRED-FORECAST THRU 8500-EXIT        
                PERFORM 2400-PROCESS-FORECAST-DATES THRU 2400-EXIT      
              WHEN WS-REV-MONTH-CM  <  WS-PREV-REVENUE-MONTH            
                MOVE WS-REV-MONTH-CM      TO WS-REVENUE-MONTH-CM        
                PERFORM 3100-CALC-NEXT-REVENUE-MONTH THRU 3100-EXIT     
                MOVE WS-NEXT-REVENUE-DATE TO WS-REV-MONTH-CM            
                PERFORM 2400-PROCESS-FORECAST-DATES THRU 2400-EXIT      
                   UNTIL WS-REV-MONTH-CM  >  WS-PREV-REVENUE-MONTH      
              WHEN OTHER                                                
                MOVE 800                    TO S-APPL-RETURN-CODE       
                PERFORM 8100-SEND-RESULT    THRU 8100-EXIT              
                PERFORM 9999-END-PROGRAM    THRU 9999-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2100-PREPARE-READ-WINDOW.                                        
      *===============================================================* 07180054
      *   CALCULATE OPTIMUM READ DATE & XTRACT-READ-DATE FOR CYCLE1     07150054
      *   BY USING BILL CYCLE OPEN DATE ENTERED BY USER                 07150054
      *                                                                 07207757
           MOVE '2100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 2110-PROCESS-READ-CYCLE-01   THRU  2110-EXIT.        
                                                                        
           PERFORM 2120-PROCESS-NEXT-READ-CYCLE THRU  2120-EXIT         
              VARYING READ-SUB FROM 2 BY 1 UNTIL READ-SUB > 20          
                                                                        
           PERFORM 2130-PROCESS-READ-CYCLE-21   THRU  2130-EXIT.        
                                                                        
           PERFORM 8250-INSERT-CSS-READ-WINDOW  THRU  8250-EXIT.        
                                                                        
           PERFORM 2140-PROCESS-SPCL-CYCLE-90   THRU  2140-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2110-PROCESS-READ-CYCLE-01.                                      
      *===============================================================* 07180054
                                                                        
           MOVE WS-2                     TO WS-NO-OF-DAYS.              
           MOVE WS-INPUT-CYCLE-OPEN-DT   TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO  RW-OPTIMUM-READ-DATE       
           IF CSR-DATABASE                                              
               MOVE WS-3                 TO WS-NO-OF-DAYS               
           ELSE                                                         
               MOVE WS-2                 TO WS-NO-OF-DAYS               
           END-IF.                                                      
           MOVE RW-OPTIMUM-READ-DATE     TO  WS-NEW-BUSINESS-DAY        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO RW-DATE-MTR-RD-XTRCT.    
                                                                        
           MOVE WS-INPUT-CYCLE              TO RW-READ-CYCLE.           
           MOVE WS-INPUT-REVENUE-MONTH      TO RW-REVENUE-MONTH.        
           MOVE SPACES                      TO RW-UT-READ-CYCLE.        
                                                                        
      *** FOR SEB-DATABASE ONLY WE MOVE THIRD PARTY READ DATE.                  
           IF SEB-DATABASE                                              
              MOVE WS-TPRD-RD-DATE          TO WS-HOLD-DATE             
              PERFORM 2190-VALIDATE-THIRD-PTY-DATE THRU 2190-EXIT       
              MOVE WS-HOLD-DATE             TO RW-THIRD-PTY-READ-DT     
                                               WS-PREV-TPRD-DATE        
              MOVE ZERO                      TO WS-NULL-1               
           ELSE                                                         
              MOVE SPACES                    TO RW-THIRD-PTY-READ-DT    
              MOVE -1                        TO WS-NULL-1               
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-CYCLE           TO TAB-CYCLE            (1)    
           MOVE RW-DATE-MTR-RD-XTRCT     TO TAB-READ-XTRACT-DT   (1)    
           MOVE RW-THIRD-PTY-READ-DT     TO TAB-3RD-PTY-READ-DT  (1)    
           MOVE WS-INPUT-REVENUE-MONTH   TO TAB-REVENUE-MONTH    (1)    
           MOVE RW-OPTIMUM-READ-DATE     TO TAB-OPTIMUM-READ-DT  (1)    
           MOVE WS-NULL-1                TO TAB-3RD-PTY-NULL-IND (1)    
           MOVE WS-INPUT-CYCLE-OPEN-DT   TO TAB-BILL-XTRACT-DT   (1)    
           MOVE SPACES                   TO TAB-UT-READ-CYCLE    (1).   
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2120-PROCESS-NEXT-READ-CYCLE.                                    
      *===============================================================* 07180054
                                                                        
           MOVE READ-SUB               TO TAB-CYCLE (READ-SUB)          
           MOVE WS-INPUT-REVENUE-MONTH TO TAB-REVENUE-MONTH (READ-SUB)  
                                                                        
      *** GET NEXT BUSINESS DAY FOR OPTIMUM READ DATE                           
           MOVE 1                      TO WS-NO-OF-DAYS                 
           MOVE RW-OPTIMUM-READ-DATE   TO WS-NEW-BUSINESS-DAY           
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY    TO RW-OPTIMUM-READ-DATE          
                                          TAB-OPTIMUM-READ-DT(READ-SUB) 
                                                                        
      *** GET NEXT BUSINESS DAY FOR XTRACT DATE                                 
           MOVE 1                      TO WS-NO-OF-DAYS                 
           MOVE RW-DATE-MTR-RD-XTRCT   TO WS-NEW-BUSINESS-DAY           
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY    TO RW-DATE-MTR-RD-XTRCT          
                                          TAB-READ-XTRACT-DT (READ-SUB) 
                                                                        
      *** GET NEXT BUSINESS DAY FOR SEB 3RD PARTY READ DATE                     
           IF SEB-DATABASE                                              
              MOVE WS-NO                TO WS-DATE-FOUND                
              MOVE RW-THIRD-PTY-READ-DT TO WS-HOLD-DATE                 
              PERFORM 2195-GET-NEXT-THIRD-PTY-DATE THRU 2195-EXIT       
                 UNTIL DATE-FOUND                                       
              MOVE WS-HOLD-DATE        TO RW-THIRD-PTY-READ-DT          
                                          TAB-3RD-PTY-READ-DT (READ-SUB)
              MOVE ZERO               TO TAB-3RD-PTY-NULL-IND (READ-SUB)
           ELSE                                                         
              MOVE SPACES              TO RW-THIRD-PTY-READ-DT          
                                          TAB-3RD-PTY-READ-DT (READ-SUB)
              MOVE -1                 TO TAB-3RD-PTY-NULL-IND (READ-SUB)
           END-IF.                                                      
                                                                        
      *** GET NEXT BUSINESS DAY FOR BILL XTRACT DATE                            
           MOVE 1                      TO WS-NO-OF-DAYS                 
           MOVE BN-DATE-EXTRACT        TO WS-NEW-BUSINESS-DAY           
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY    TO BN-DATE-EXTRACT               
                                          TAB-BILL-XTRACT-DT (READ-SUB) 
                                                                        
      *** GET NEXT UT-READ-CYCLE                                                
           MOVE SPACES                 TO TAB-UT-READ-CYCLE  (READ-SUB).
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2130-PROCESS-READ-CYCLE-21.                                      
      *===============================================================* 07180054
                                                                        
           MOVE '21'                        TO TAB-CYCLE (21)           
           MOVE SPACES                      TO TAB-UT-READ-CYCLE (21)   
           MOVE TAB-REVENUE-MONTH (20)      TO TAB-REVENUE-MONTH (21)   
           IF SEB-DATABASE                                              
              MOVE TAB-READ-XTRACT-DT (20)  TO TAB-READ-XTRACT-DT (21)  
              MOVE TAB-OPTIMUM-READ-DT (20) TO TAB-OPTIMUM-READ-DT (21) 
              MOVE TAB-3RD-PTY-READ-DT (20) TO TAB-3RD-PTY-READ-DT (21) 
              MOVE TAB-BILL-XTRACT-DT (20)  TO TAB-BILL-XTRACT-DT (21)  
              MOVE WS-NO                    TO WS-DATE-FOUND            
              MOVE TAB-3RD-PTY-READ-DT (20) TO WS-HOLD-DATE             
              PERFORM 2195-GET-NEXT-THIRD-PTY-DATE THRU 2195-EXIT       
                 UNTIL DATE-FOUND                                       
              MOVE WS-HOLD-DATE            TO RW-THIRD-PTY-READ-DT      
                                              TAB-3RD-PTY-READ-DT (21)  
              MOVE ZERO                    TO TAB-3RD-PTY-NULL-IND (21) 
           ELSE                                                         
              MOVE WS-REV-MNTH-DT-END      TO TAB-OPTIMUM-READ-DT  (21) 
              MOVE SPACES                  TO TAB-3RD-PTY-READ-DT  (21) 
              MOVE -1                      TO TAB-3RD-PTY-NULL-IND (21) 
              MOVE WS-REV-MNTH-DT-END      TO WS-NEW-BUSINESS-DAY       
              MOVE WS-3                    TO WS-NO-OF-DAYS             
              PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT         
              MOVE WS-NEW-BUSINESS-DAY     TO TAB-READ-XTRACT-DT (21)   
      *** GET NEXT BUSINESS DAY FOR BILL XTRACT DATE                            
              MOVE 1                       TO WS-NO-OF-DAYS             
              MOVE WS-REV-MNTH-DT-END      TO WS-NEW-BUSINESS-DAY       
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
              MOVE WS-NEW-BUSINESS-DAY     TO BN-DATE-EXTRACT           
                                              TAB-BILL-XTRACT-DT (21)   
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2140-PROCESS-SPCL-CYCLE-90.                                      
      *==============================================================*  07772359
      *   THIS PARAGRAPH IS USED TO INSERT THE SPCL READ CYCLE          07772059
      *   90 WITH THE OPTIMUM READ DATE SHOULD BE FALL ON THE           07772159
      *   15TH OF EACH MONTH.                                           07772259
      *                                                                         
           MOVE '2140'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      *** VERIFY THE OPTIMUM-READ-DATE IS A VALID BUSSINESS DAY.        07772459
           MOVE WS-CYCLE-90-OPT-READ        TO  WS-HOLD-DATE.           
           MOVE WS-NO                       TO  WS-DATE-FOUND.          
           PERFORM 2145-OPTI-VALID-DATE         THRU 2145-EXIT.         
           MOVE WS-HOLD-DATE                TO  RW-OPTIMUM-READ-DATE    
                                                WS-NEW-BUSINESS-DAY.    
                                                                        
           MOVE WS-3                        TO WS-NO-OF-DAYS            
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO RW-DATE-MTR-RD-XTRCT.    
                                                                        
           MOVE WS-90                       TO  RW-READ-CYCLE.          
           MOVE WS-20                       TO  RW-UT-READ-CYCLE.       
                                                                        
           MOVE WS-INPUT-REVENUE-MONTH      TO  RW-REVENUE-MONTH.       
                                                                        
           MOVE SPACES                      TO RW-THIRD-PTY-READ-DT     
           MOVE -1                          TO WS-NULL-1                
           PERFORM 8200-INSERT-CSS-READ-WINDOW  THRU  8200-EXIT.        
           MOVE ZEROS                       TO WS-NULL-1.               
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07380054
      *==============================================================*  07394758
       2145-OPTI-VALID-DATE.                                            
      *==============================================================*  07430055
      *   THIS PARAGRAPH IS USED TO VALIDATE THAT THE OPTIMUM DATE      07410055
      *   IS A VALID BUSINESS DAY.                                      07420055
      *                                                                 07440055
           MOVE '2145'                      TO  ACTIVE-PARAGRAPH        
                                                                        
           PERFORM 7050-GET-CURRENT-DATE        THRU 7050-EXIT.         
      *                                                                         
      *** IF 15TH FALLS ON SATUARDAY, IT SHOULD BE SET TO 14TH,                 
      *** IF 14TH FALLS ON HOLIDAY, IT SHOULD BE SET TO                         
      *** MONDAY, THE 17TH.                                                     
      *                                                                         
           IF WS-DAY EQUAL 6                                            
              MOVE WS-NO                    TO WS-DATE-FOUND            
              MOVE WS-HOLD-DATE             TO WS-PREV-BUSINESS-DAY     
              MOVE WS-4                     TO WS-DAY-COUNTER           
              PERFORM 7200-GET-PREV-BUSINESS-DAY THRU  7200-EXIT        
              IF DATE-FOUND                                             
                 MOVE WS-PREV-BUSINESS-DAY  TO  WS-HOLD-DATE            
              ELSE                                                      
                 MOVE WS-NO                 TO  WS-DATE-FOUND           
                 MOVE WS-PREV-BUSINESS-DAY  TO  WS-HOLD-DATE            
                 PERFORM 2900-GET-NEXT-DATE     THRU  2900-EXIT         
                                       UNTIL DATE-FOUND                 
              END-IF                                                    
           ELSE                                                         
      *                                                                         
      *** IF 15TH FALLS ON SUNDAY, IT SHOULD BE SET TO 16TH, MONDAY             
      *** IF 16TH FALLS ON HOLIDAY, IT SHOULD BE SET TO 17TH, TUESDAY           
      *                                                                         
               IF WS-DAY EQUAL ZEROES                                   
                  MOVE WS-NO                TO WS-DATE-FOUND            
                  PERFORM 2900-GET-NEXT-DATE    THRU 2900-EXIT          
                                   UNTIL DATE-FOUND                     
               ELSE                                                     
      *                                                                         
      *** IF 15TH FALLS ON FRIDAY AND FRIDAY IS HOLIDAY, IT SHOULD              
      *** BE SET TO THURSDAY, THE 14TH.                                         
      *                                                                         
                  MOVE ZEROES               TO WS-ROW-COUNT             
                  MOVE WS-HOLD-DATE         TO J8-HOLIDAY-DT            
                  PERFORM 7150-SELECT-HOLIDAY   THRU 7150-EXIT          
                  IF WS-ROW-COUNT GREATER THAN ZEROES                   
                     MOVE WS-NO             TO WS-DATE-FOUND            
                     MOVE WS-HOLD-DATE      TO WS-PREV-BUSINESS-DAY     
                     MOVE WS-4              TO WS-DAY-COUNTER           
                     PERFORM 7200-GET-PREV-BUSINESS-DAY THRU 7200-EXIT  
                             UNTIL DATE-FOUND                           
                     MOVE WS-PREV-BUSINESS-DAY  TO  WS-HOLD-DATE        
                  ELSE                                                  
                     MOVE WS-YES            TO WS-DATE-FOUND            
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                 07610055
       2145-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650060
      *==============================================================*         0
       2190-VALIDATE-THIRD-PTY-DATE.                                    
      *==============================================================*         0
      **  THIS PARAGRAPH IS USED TO VALIDATE THAT THE DATE SPECIFIED *  07410055
      **  IS A VALID THIRD PARTY READ DAY.                           *  07420055
      *                                                                 07440055
           PERFORM 7350-GET-LAST-DAY THRU 7350-EXIT.                    
           MOVE WS-PREV-DATE         TO WS-HOLD-DATE.                   
           MOVE WS-NO                TO WS-DATE-FOUND.                  
           PERFORM 2195-GET-NEXT-THIRD-PTY-DATE THRU 2195-EXIT          
                                     UNTIL DATE-FOUND.                  
      *                                                                 07610055
       2190-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650060
      *==============================================================*         0
       2195-GET-NEXT-THIRD-PTY-DATE.                                    
      *==============================================================*         0
      **  THIS PARAGRAPH IS USED TO SELECT THE FOLLOWING DAY'S DATE  *  07763055
      **  FROM THE TABLE CSS_MODEL_SQL.                              *  07764055
      *                                                                 07766055
           PERFORM 7100-GET-NEXT-DAY               THRU 7100-EXIT.      
           IF  WS-DAY EQUAL ZEROS                                       
               MOVE WS-NO           TO WS-DATE-FOUND                    
           ELSE                                                         
               IF  WS-DAY EQUAL 6                                       
                   MOVE WS-NO           TO WS-THIRD-PTY-EXCEPTION       
                   MOVE +7              TO UV-COLUMN-NA-LEN             
                   MOVE 'WORKDAY'       TO UV-COLUMN-NA-TEXT            
                   MOVE +10             TO UV-CODE-VALUE-LEN            
                   MOVE WS-HOLD-DATE    TO UV-CODE-VALUE-TEXT           
                   PERFORM  7950-GET-THIRD-PTY-EXCEPTION THRU 7950-EXIT 
                   IF  TP-EXCEPTION-EXISTS                              
                       MOVE WS-YES      TO WS-DATE-FOUND                
                   ELSE                                                 
                       MOVE WS-NO       TO WS-DATE-FOUND                
                   END-IF                                               
               ELSE                                                     
                   MOVE ZEROES          TO WS-ROW-COUNT                 
                   MOVE WS-HOLD-DATE    TO J8-HOLIDAY-DT                
                   PERFORM 7150-SELECT-HOLIDAY         THRU 7150-EXIT   
                   IF WS-ROW-COUNT GREATER THAN ZEROES                  
                       MOVE WS-NO           TO WS-THIRD-PTY-EXCEPTION   
                       MOVE +7              TO UV-COLUMN-NA-LEN         
                       MOVE 'WORKDAY'       TO UV-COLUMN-NA-TEXT        
                       MOVE +10             TO UV-CODE-VALUE-LEN        
                       MOVE WS-HOLD-DATE    TO UV-CODE-VALUE-TEXT       
                       PERFORM  7950-GET-THIRD-PTY-EXCEPTION            
                                THRU 7950-EXIT                          
                       IF  TP-EXCEPTION-EXISTS                          
                           MOVE WS-YES      TO WS-DATE-FOUND            
                       ELSE                                             
                           MOVE WS-NO       TO WS-DATE-FOUND            
                       END-IF                                           
                   ELSE                                                 
                       MOVE WS-NO           TO WS-THIRD-PTY-EXCEPTION   
                       MOVE +7              TO UV-COLUMN-NA-LEN         
                       MOVE 'HOLIDAY'       TO UV-COLUMN-NA-TEXT        
                       MOVE +10             TO UV-CODE-VALUE-LEN        
                       MOVE WS-HOLD-DATE    TO UV-CODE-VALUE-TEXT       
                       PERFORM  7950-GET-THIRD-PTY-EXCEPTION            
                                THRU 7950-EXIT                          
                       IF  TP-EXCEPTION-EXISTS                          
                           MOVE WS-NO       TO WS-DATE-FOUND            
                       ELSE                                             
                           MOVE WS-YES      TO WS-DATE-FOUND            
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2195-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07769255
      *===============================================================*         
       2200-PREPARE-BILL-WINDOW.                                        
      *===============================================================* 07180054
      *   CALCULATE OPTIMUM READ DATE & XTRACT-READ-DATE FOR CYCLE1     07150054
      *   BY USING BILL CYCLE OPEN DATE ENTERED BY USER                 07150054
           MOVE TAB-BILL-XTRACT-DT (21) TO WS-CYC21-XTRACT-DT           
      *** GET NEXT BUSINESS DAY FOR BILL XTRACT DATE                            
           MOVE 1                           TO WS-NO-OF-DAYS            
           MOVE TAB-BILL-XTRACT-DT (20)     TO WS-NEW-BUSINESS-DAY      
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO BN-DATE-EXTRACT          
           IF WS-CYC21-XTRACT-DT = BN-DATE-EXTRACT                      
              MOVE 21              TO READ-COUNT-MAX                    
           ELSE                                                         
              IF WS-CYC21-XTRACT-DT < BN-DATE-EXTRACT                   
                 MOVE 20              TO READ-COUNT-MAX                 
              ELSE                                                      
                 MOVE 20              TO READ-COUNT-MAX                 
                 PERFORM UNTIL WS-CYC21-XTRACT-DT < BN-DATE-EXTRACT     
                    COMPUTE READ-COUNT-MAX = READ-COUNT-MAX + 1         
                    MOVE READ-COUNT-MAX TO TAB-CYCLE (READ-COUNT-MAX)   
                    MOVE BN-DATE-EXTRACT                                
                                  TO TAB-BILL-XTRACT-DT (READ-COUNT-MAX)
                                     WS-NEW-BUSINESS-DAY                
                    MOVE 1                          TO WS-NO-OF-DAYS    
                    PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT   
                    MOVE WS-NEW-BUSINESS-DAY        TO BN-DATE-EXTRACT  
                 END-PERFORM                                            
              END-IF                                                    
           END-IF                                                       
      *                                                                 07207757
           MOVE TAB-BILL-XTRACT-DT (READ-COUNT-MAX)                     
                                      TO WS-NEW-BUSINESS-DAY            
           MOVE 1                     TO WS-NO-OF-DAYS                  
           IF (TAB-BILL-XTRACT-DT (20) = TAB-BILL-XTRACT-DT (21) )      
ACT049        AND CSR-DATABASE                                          
              MOVE WS-BILL-WIN-COUNT  TO READ-SUB                       
           ELSE                                                         
              COMPUTE READ-SUB = WS-BILL-WIN-COUNT - 1                  
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM READ-SUB TIMES                                       
              COMPUTE READ-COUNT-MAX = READ-COUNT-MAX + 1               
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
              MOVE WS-NEW-BUSINESS-DAY                                  
                              TO TAB-BILL-XTRACT-DT (READ-COUNT-MAX)    
              MOVE READ-COUNT-MAX TO TAB-CYCLE (READ-COUNT-MAX)         
           END-PERFORM                                                  
      *                                                                 07207757
           MOVE ZEROS              TO BILL-SUB                          
           PERFORM VARYING READ-SUB FROM 1 BY 1 UNTIL READ-SUB > 20     
              MOVE READ-SUB            TO READ-SUB1                     
              MOVE TAB-CYCLE (READ-SUB)  TO WS-TEMP-BILL-CYCLE          
              PERFORM VARYING READ-SUB1 FROM READ-SUB BY 1              
                 UNTIL READ-SUB1 >= (WS-BILL-WIN-COUNT + READ-SUB )     
                 COMPUTE BILL-SUB  = BILL-SUB + 1                       
                 MOVE WS-TEMP-BILL-CYCLE TO TAB-BN-CYCLE (BILL-SUB)     
                 MOVE TAB-BILL-XTRACT-DT (READ-SUB1)                    
                                     TO TAB-BN-XTRACT-DT (BILL-SUB)     
                 MOVE 'R'            TO TAB-BN-BILL-COND (BILL-SUB)     
                 MOVE TAB-CYCLE (READ-SUB1)                             
                                     TO TAB-BN-REV-CALC-CYCLE (BILL-SUB)
              END-PERFORM                                               
              MOVE 'C'               TO TAB-BN-BILL-COND (BILL-SUB)     
           END-PERFORM                                                  
           SET CYC21-START-NOT-FOUND   TO TRUE                          
           PERFORM VARYING READ-SUB FROM 15 BY 1                        
              UNTIL READ-SUB > READ-COUNT-MAX                           
              IF TAB-BILL-XTRACT-DT (READ-SUB) = WS-CYC21-XTRACT-DT     
                 SET CYC21-START-FOUND   TO TRUE                        
              END-IF                                                    
              IF CYC21-START-FOUND                                      
                 COMPUTE BILL-SUB  = BILL-SUB + 1                       
                 MOVE '21'               TO TAB-BN-CYCLE (BILL-SUB)     
                 MOVE TAB-BILL-XTRACT-DT (READ-SUB)                     
                                     TO TAB-BN-XTRACT-DT (BILL-SUB)     
                 MOVE 'R'            TO TAB-BN-BILL-COND (BILL-SUB)     
                 MOVE TAB-CYCLE (READ-SUB)                              
                                     TO TAB-BN-REV-CALC-CYCLE (BILL-SUB)
                                                                        
              END-IF                                                    
           END-PERFORM                                                  
           IF CYC21-START-FOUND                                         
              MOVE 'C'               TO TAB-BN-BILL-COND (BILL-SUB)     
           ELSE                                                         
              CONTINUE                                                  
      ****  ABEND                                                               
           END-IF                                                       
           PERFORM 8300-INSERT-CSS-BILL-WINDOW THRU 8300-EXIT.          
      *                                                                 07209054
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2300-LOAD-DELINQUENCY-VALUES.                                    
      *==============================================================*          
                                                                        
           MOVE '2300'                      TO ACTIVE-PARAGRAPH.        
           SET DELQ-INDX  TO 1.                                         
           PERFORM 7450-OPEN-DELINQUENCY         THRU 7450-EXIT         
           PERFORM 7500-FETCH-DELINQUENCY        THRU 7500-EXIT         
           PERFORM 2310-MOVE-DELINQUENCY         THRU 2310-EXIT         
                  UNTIL SQLCODE EQUAL NOT-FOUND                         
           PERFORM 7550-CLOSE-DELINQUENCY        THRU 7550-EXIT.        
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*         0
       2310-MOVE-DELINQUENCY.                                           
      *==============================================================*         0
      *                                                                         
           MOVE '2310'                  TO ACTIVE-PARAGRAPH             
           ADD +1                       TO WS-DELINQ-COUNT              
           MOVE  C8-COMPANY-NO          TO WS-COMPANY-NO-C8(DELQ-INDX)  
           MOVE  C8-DELINQ-CD           TO WS-DELINQ-CD-C8(DELQ-INDX)   
           MOVE  C8-DELINQ-VALUE        TO WS-DELINQ-VALUE-C8(DELQ-INDX)
           SET DELQ-INDX UP BY 1                                        
           PERFORM 7500-FETCH-DELINQUENCY        THRU 7500-EXIT.        
      *                                                                         
       2310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2400-PROCESS-FORECAST-DATES.                                     
      *==============================================================*  04510000
      *  PROCESS CSS_BILL_WINDOW AND CSS_READ_WINDOW TABLE FOR EACH             
      *  CYCLE GIVEN REVENUE MONTH IN THE PANEL.                                
      *                                                                 04530000
           MOVE '2400'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE DCLCSS-CRED-FORECAST                              
                      WS-BILL-WNDW-TABLE                                
                      WS-BILL-WND-COUNT                                 
                      WS-DATE-FIELDS                                    
                      WS-CRED-FORECAST-ARRAY                            
                      TB-CRED-INDEX.                                    
      *                                                                         
           MOVE WS-REV-MONTH-CM             TO WS-REVENUE-MONTH-CM.     
           PERFORM 3100-CALC-NEXT-REVENUE-MONTH  THRU 3100-EXIT.        
           MOVE WS-NEXT-REVENUE-DATE        TO WS-NEXT-REV-MONTH-CM     
                                                                        
           MOVE WS-READY-TO-INSERT-COUNT    TO WS-INSERT-COUNT.         
                                                                        
           MOVE 1                           TO BILL-WNDW-SUB.           
           MOVE WS-REV-MONTH-CM             TO BN-REVENUE-MONTH.        
           PERFORM 2500-LOAD-BILL-WINDOW         THRU 2500-EXIT.        
      *                                                                         
           MOVE WS-REV-MONTH-CM             TO WS-PREV-REVENUE-DATE     
           PERFORM 2600-LOAD-BUSINESS-DAYS       THRU 2600-EXIT.        
      *                                                                         
           MOVE SPACES                      TO WS-BILL-CYC-CLOSE-DT     
           PERFORM VARYING BILL-WNDW-SUB FROM WS-BILL-WND-COUNT BY -1   
              UNTIL BILL-WNDW-SUB = 0                                   
              IF WS-CODE-BILL-COND-BW(BILL-WNDW-SUB) = 'C'              
                 MOVE WS-DATE-EXTRACT-BW(BILL-WNDW-SUB)                 
                                              TO WS-BILL-CYC-CLOSE-DT   
              END-IF                                                    
              MOVE WS-BILL-CYC-CLOSE-DT       TO WS-DATE-BN-CLOSE-BW    
                                                 (BILL-WNDW-SUB)        
           END-PERFORM.                                                 
      *                                                                         
           IF CSR-DATABASE                                              
              PERFORM 2700-PROCESS-CSR-FORECAST  THRU 2700-EXIT         
           ELSE                                                         
              PERFORM 2800-PROCESS-SEB-FORECAST  THRU 2800-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-REV-MONTH-CM             TO WS-REVENUE-MONTH-CM.     
           PERFORM 3100-CALC-NEXT-REVENUE-MONTH  THRU 3100-EXIT.        
           MOVE WS-NEXT-REVENUE-DATE        TO WS-REV-MONTH-CM.         
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2500-LOAD-BILL-WINDOW.                                           
      *==============================================================*          
      *                                                                         
           PERFORM 7280-OPEN-BILL-WINDOW-CSR    THRU 7280-EXIT.         
           PERFORM 7290-FETCH-BILL-WINDOW-CSR   THRU 7290-EXIT.         
           PERFORM 7300-CLOSE-BILL-WINDOW-CSR   THRU 7300-EXIT.         
           IF WS-BILL-WND-COUNT > ZERO                                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 900                    TO S-APPL-RETURN-CODE         
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2600-LOAD-BUSINESS-DAYS.                                         
      *==============================================================*          
      *                                                                         
           MOVE WS-PREV-REV-DATE-CCYY    TO WS-NEW-BUSINESS-DAY(1:4)    
           MOVE '-'                      TO WS-NEW-BUSINESS-DAY(5:1)    
           MOVE WS-PREV-REV-DATE-MM      TO WS-NEW-BUSINESS-DAY(6:2)    
           MOVE '-'                      TO WS-NEW-BUSINESS-DAY(8:1)    
           MOVE '01'                     TO WS-NEW-BUSINESS-DAY(9:2)    
           IF WS-BUSINESS-DAY-START = WS-NEW-BUSINESS-DAY               
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7220-OPEN-WORK-DAY-CSR       THRU 7220-EXIT       
              PERFORM 7230-FETCH-WORK-DAY-CSR      THRU 7230-EXIT       
              PERFORM 7240-CLOSE-WORK-DAY-CSR      THRU 7240-EXIT       
              MOVE WS-NEW-BUSINESS-DAY   TO WS-BUSINESS-DAY-START       
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2700-PROCESS-CSR-FORECAST.                                       
      *==============================================================*  04450000
      *                                                                 07766055
           MOVE  '2700'                     TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-REV-MONTH-CM             TO BN-REVENUE-MONTH         
                                               CM-REVENUE-MONTH         
                                                                        
      *** SCEG PROCESS                                                          
           MOVE '01'                        TO WS-COMPANY-NO-AT         
                                               CM-COMPANY-NO.           
                                                                        
           SET DELQ-INDX                    TO 1.                       
           PERFORM 2710-LOAD-CSR-DELINQ            THRU 2710-EXIT       
                  UNTIL DELQ-INDX > WS-DELINQ-COUNT.                    
      *                                                                         
           MOVE SPACES                      TO WS-PREV-BILL-CYCLE       
           PERFORM VARYING BILL-WNDW-SUB FROM 1 BY 1 UNTIL              
                   BILL-WNDW-SUB > WS-BILL-WND-COUNT                    
                                                                        
               PERFORM 2820-CHECK-BILL-CYC-CHNG THRU 2820-EXIT          
               PERFORM 2750-PROCESS-SCEG-GRP    THRU 2750-EXIT          
                                                                        
           END-PERFORM.                                                 
                                                                        
      *** PSNC PROCESS                                                          
           MOVE '26'                        TO WS-COMPANY-NO-AT         
                                               CM-COMPANY-NO.           
                                                                        
           SET DELQ-INDX                    TO 1.                       
           PERFORM 2710-LOAD-CSR-DELINQ            THRU 2710-EXIT       
                  UNTIL DELQ-INDX > WS-DELINQ-COUNT.                    
                                                                        
           MOVE SPACES                      TO WS-PREV-BILL-CYCLE       
           PERFORM VARYING BILL-WNDW-SUB FROM 1 BY 1 UNTIL              
                   BILL-WNDW-SUB > WS-BILL-WND-COUNT                    
                                                                        
               PERFORM 2820-CHECK-BILL-CYC-CHNG THRU 2820-EXIT          
               PERFORM 2760-PROCESS-PSNC-GRP    THRU 2760-EXIT          
                                                                        
           END-PERFORM.                                                 
                                                                        
           IF TB-CRED-INDEX > 0                                         
              MOVE TB-CRED-INDEX            TO WS-INSERT-COUNT          
              PERFORM 8400-INSERT-CRED-FORECAST    THRU 8400-EXIT       
              MOVE ZERO                     TO TB-CRED-INDEX            
           END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2710-LOAD-CSR-DELINQ.                                            
      *==============================================================*          
      *                                                                         
           IF WS-COMPANY-NO-C8(DELQ-INDX)  = WS-COMPANY-NO-AT           
              EVALUATE WS-DELINQ-CD-C8(DELQ-INDX)                       
                WHEN 'DAY-DNP'                                          
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-DNP-DT-DELQ-VALUE     
                WHEN 'DAY-SECOND-MAIL'                                  
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-MAIL-DT-DELQ-VALUE    
                WHEN 'DAY-DUE'                                          
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-DUE-DT-DELQ-VALUE     
                WHEN 'DAY-SECOND-FIELD'                                 
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-FIELD-DT-DELQ-VALUE   
                WHEN 'DAY-DPP-SECOND-MAIL'                              
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-DPP-DT-DELQ-VALUE     
                WHEN 'DAY-TOTAL-DUE'                                    
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-TOT-DT-DELQ-VALUE     
                WHEN 'DAY-NU-WQDELQ'                                    
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-NU-DT-DELQ-VALUE      
                WHEN 'DAY-CBILL-DELQ-WQ'                                
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-CBILL-DT-DELQ-VALUE   
                WHEN 'DAY-DUE-NONRES'                                   
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-NONRES-DT-DELQ-VALUE  
                WHEN 'DAY-CB15CYCLES'                                   
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-CB15CYCLE-DELQ-VALUE  
                WHEN 'DAY-CB610CYCLES'                                  
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-CB610CYCLE-DELQ-VALUE 
                WHEN 'DAY-CB1115CYCLES'                                 
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-CB1115CYCLE-DELQ-VALUE
                WHEN 'DAY-CB1620CYCLES'                                 
                     MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                 
                                            TO WS-CB1620CYCLE-DELQ-VALUE
              END-EVALUATE                                              
           END-IF.                                                      
           SET DELQ-INDX UP BY 1.                                       
      *                                                                         
       2710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2750-PROCESS-SCEG-GRP.                                           
      *==============================================================*  04450000
                                                                        
           MOVE  '2750'                     TO ACTIVE-PARAGRAPH.        
                                                                        
           IF BN-CODE-BILL-COND = 'C'                                   
      *** SCEG, NEW                                                             
              PERFORM 2752-SCEG-NEW-GROUP           THRU 2752-EXIT      
                                                                        
      *** SCEG, ARREARS                                                         
              PERFORM 2754-SCEG-ARR-GROUP           THRU 2754-EXIT      
                                                                        
      *** SCEG, EXEMPT                                                          
              PERFORM 2756-SCEG-EXE-GROUP           THRU 2756-EXIT      
                                                                        
      *** SCEG, NON-UTIL                                                        
              PERFORM 2758-SCEG-NON-GROUP           THRU 2758-EXIT      
           END-IF.                                                      
                                                                        
      *** SCEG, MASTER                                                          
           PERFORM 2780-CSR-MASTER-GROUP         THRU 2780-EXIT.        
                                                                        
       2750-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2752-SCEG-NEW-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES   THRU  2870-EXIT.       
                                                                        
           MOVE 'N'                      TO CM-CREDIT-GROUP.            
      *** OTHER - RESIDENTIAL                                                   
           MOVE  SPACES                     TO CM-CREDIT-GROUP-ID       
           MOVE  'R'                        TO CM-CRED-ACCT-TYPE-CD.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT        
      *                                                                         
      *** OTHER - NON-RESIDENTIAL                                               
           MOVE  SPACES                     TO CM-CREDIT-GROUP-ID       
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE SPACES                      TO WS-IVR-CALL-DT.          
           MOVE -1                          TO WS-IVR-CALL-NULL-IND.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *                                                                         
      *** RE-CALCULATE BELOW FIELDS FOR CREDIT GROUP ID = DPP                   
      *** NOTICE  MAIL DATE                                                     
           MOVE WS-DPP-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
           MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-NOTICE-MAIL-DT.      
                                                                        
      *** ARREARS DUE DATE                                                      
           MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
           MOVE WS-DNP-NOTICE-MAIL-DT    TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
                                                                        
      *** DPP - RESIDENTIAL                                                     
           MOVE  'N'                        TO CM-CREDIT-GROUP.         
           MOVE  'DPP'                      TO CM-CREDIT-GROUP-ID.      
           MOVE  'R'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE TMP-IVR-CALL-DT             TO WS-IVR-CALL-DT.          
           MOVE TMP-IVR-CALL-IND            TO WS-IVR-CALL-NULL-IND.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *** DPP - NON-RESIDENTIAL                                                 
           MOVE  'DPP'                      TO CM-CREDIT-GROUP-ID.      
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE SPACES                      TO WS-IVR-CALL-DT.          
           MOVE -1                          TO WS-IVR-CALL-NULL-IND.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *                                                                         
       2752-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2754-SCEG-ARR-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES   THRU  2870-EXIT.       
                                                                        
      *** OTHER, RESIDENTIAL                                                    
           MOVE 'A'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID.         
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *** OTHER, OTHER                                                          
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID.         
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO WS-IVR-CALL-DT.             
           MOVE -1                       TO WS-IVR-CALL-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *** RE-CALCULATE BELOW FIELDS FOR CREDIT GROUP ID = DPP                   
      *** NOTICE  MAIL DATE                                                     
           MOVE WS-DPP-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
           MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-NOTICE-MAIL-DT.      
                                                                        
      *** ARREARS DUE DATE                                                      
           MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
           MOVE WS-DNP-NOTICE-MAIL-DT    TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
                                                                        
      *** DPP, RESIDENTIAL                                                      
           MOVE 'DPP'                    TO CM-CREDIT-GROUP-ID.         
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE TMP-IVR-CALL-DT          TO WS-IVR-CALL-DT.             
           MOVE TMP-IVR-CALL-IND         TO WS-IVR-CALL-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *** DPP, OTHER                                                            
           MOVE 'DPP'                    TO CM-CREDIT-GROUP-ID.         
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-IVR-CALL-DT.             
           MOVE -1                       TO WS-IVR-CALL-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *                                                                         
       2754-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2756-SCEG-EXE-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES   THRU  2870-EXIT.       
                                                                        
           MOVE TMP-CURR-CHG-DUE-DT      TO WS-ARREARS-DUE-DT           
           MOVE ZERO                     TO WS-ARREARS-DUE-NULL-IND     
           MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT.             
                                                                        
           MOVE -1                       TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND.       
                                                                        
      *** OTHER, RESIDENTIAL                                                    
           MOVE 'C'                        TO CM-CREDIT-GROUP.          
           MOVE SPACES                     TO CM-CREDIT-GROUP-ID        
           MOVE 'R'                        TO CM-CRED-ACCT-TYPE-CD.     
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *** OTHER, OTHER                                                          
           MOVE SPACES                     TO CM-CREDIT-GROUP-ID        
           MOVE 'O'                        TO CM-CRED-ACCT-TYPE-CD.     
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
       2756-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2758-SCEG-NON-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES   THRU  2870-EXIT.       
                                                                        
      *** NON UTIL WQ DATE                                                      
           MOVE WS-NU-DT-DELQ-VALUE      TO WS-NO-OF-DAYS               
           MOVE TMP-CURR-CHG-DUE-DT      TO WS-NEW-BUSINESS-DAY         
                                            WS-ARREARS-DUE-DT           
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT            
           MOVE BN-DATE-EXTRACT          TO WS-CRED-BUR-RPT-DT          
           MOVE ZERO                     TO WS-CRED-BUR-NULL-IND        
                                            WS-NONUTIL-WQ-NULL-IND      
                                            WS-ARREARS-DUE-NULL-IND     
           MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT              
           MOVE -1                       TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND        
                                                                        
      *** OTHER, OTHER                                                          
           MOVE  'D'                     TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID.         
           MOVE  'O'                     TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
       2758-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2760-PROCESS-PSNC-GRP.                                           
      *==============================================================*  04450000
                                                                        
           MOVE  '2760'                     TO ACTIVE-PARAGRAPH         
      *** PSNC, NEW                                                             
           PERFORM 2762-PSNC-NEW-GROUP           THRU 2762-EXIT         
                                                                        
      *** PSNC, ARREARS                                                         
           PERFORM 2764-PSNC-ARR-GROUP           THRU 2764-EXIT         
                                                                        
      *** PSNC, EXEMPT                                                          
           PERFORM 2766-PSNC-EXE-GROUP           THRU 2766-EXIT         
                                                                        
      *** PSNC, NON-UTIL                                                        
           PERFORM 2768-PSNC-NON-GROUP           THRU 2768-EXIT         
                                                                        
      *** PSNC, MASTER                                                          
           PERFORM 2780-CSR-MASTER-GROUP         THRU 2780-EXIT.        
                                                                        
       2760-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2762-PSNC-NEW-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * CURRENT CHARGE DUE DATE                                                 
           MOVE WS-NONRES-DT-DELQ-VALUE  TO WS-NO-OF-DAYS.              
           MOVE BN-DATE-EXTRACT          TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT.         
                                                                        
           MOVE 'N'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO WS-CRED-BUR-RPT-DT          
                                            WS-IVR-CALL-DT.             
           MOVE -1                       TO WS-CRED-BUR-NULL-IND        
                                            WS-IVR-CALL-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST  THRU 5100-EXIT              
                                                                        
           IF BN-CODE-BILL-COND = 'C'                                   
              PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT        
                                                                        
              MOVE 'N'                   TO CM-CREDIT-GROUP             
      *** OTHER - RESIDENTIAL                                                   
              MOVE SPACES                TO CM-CREDIT-GROUP-ID          
              MOVE 'R'                   TO CM-CRED-ACCT-TYPE-CD        
              PERFORM 5100-LOAD-CRED-FORECAST   THRU 5100-EXIT          
           END-IF.                                                      
                                                                        
       2762-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2764-PSNC-ARR-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * CURRENT CHARGE DUE DATE                                                 
           MOVE WS-NONRES-DT-DELQ-VALUE  TO WS-NO-OF-DAYS.              
           MOVE BN-DATE-EXTRACT          TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT.         
                                                                        
           MOVE 'A'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-IVR-CALL-DT.             
           MOVE -1                       TO WS-IVR-CALL-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           IF BN-CODE-BILL-COND = 'C'                                   
              PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT        
                                                                        
              MOVE 'A'                   TO CM-CREDIT-GROUP             
      *** OTHER - RESIDENTIAL                                                   
              MOVE  SPACES               TO CM-CREDIT-GROUP-ID          
              MOVE  'R'                  TO CM-CRED-ACCT-TYPE-CD        
              PERFORM 5100-LOAD-CRED-FORECAST    THRU 5100-EXIT         
           END-IF.                                                      
      *                                                                         
      *                                                                         
       2764-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2766-PSNC-EXE-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * CURRENT CHARGE DUE DATE                                                 
           MOVE WS-NONRES-DT-DELQ-VALUE  TO WS-NO-OF-DAYS.              
           MOVE BN-DATE-EXTRACT          TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT          
                                            WS-ARREARS-DUE-DT           
           MOVE ZERO                     TO WS-ARREARS-DUE-NULL-IND     
           MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT              
                                                                        
           MOVE -1                       TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND        
                                                                        
                                                                        
           MOVE  'C'                     TO CM-CREDIT-GROUP.            
           MOVE  SPACES                  TO CM-CREDIT-GROUP-ID          
           MOVE  'O'                     TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           IF BN-CODE-BILL-COND = 'C'                                   
              PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT        
              MOVE TMP-CURR-CHG-DUE-DT   TO WS-ARREARS-DUE-DT           
              MOVE ZERO                  TO WS-ARREARS-DUE-NULL-IND     
              MOVE SPACES                TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT              
                                                                        
              MOVE -1                    TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND        
                                                                        
              MOVE 'C'                   TO CM-CREDIT-GROUP             
      *** OTHER - RESIDENTIAL                                                   
              MOVE  SPACES               TO CM-CREDIT-GROUP-ID          
              MOVE  'R'                  TO CM-CRED-ACCT-TYPE-CD        
              PERFORM 5100-LOAD-CRED-FORECAST    THRU  5100-EXIT        
           END-IF.                                                      
      *                                                                         
      *                                                                         
       2766-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       2768-PSNC-NON-GROUP.                                             
      *==============================================================*  04450000
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * CURRENT CHARGE DUE DATE                                                 
           MOVE WS-NONRES-DT-DELQ-VALUE  TO WS-NO-OF-DAYS.              
           MOVE BN-DATE-EXTRACT          TO WS-NEW-BUSINESS-DAY.        
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT          
      *** NON UTIL WQ DATE                                                      
           MOVE WS-CURR-CHG-DUE-DT       TO WS-NEW-BUSINESS-DAY         
                                            WS-ARREARS-DUE-DT           
           MOVE WS-NU-DT-DELQ-VALUE      TO WS-NO-OF-DAYS               
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT            
           MOVE BN-DATE-EXTRACT          TO WS-CRED-BUR-RPT-DT          
           MOVE ZERO                     TO WS-CRED-BUR-NULL-IND        
                                            WS-NONUTIL-WQ-NULL-IND      
                                            WS-ARREARS-DUE-NULL-IND     
           MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT              
           MOVE -1                       TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND        
                                                                        
                                                                        
                                                                        
           MOVE  'D'                     TO CM-CREDIT-GROUP.            
           MOVE  SPACES                  TO CM-CREDIT-GROUP-ID          
           MOVE  'O'                     TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2768-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2780-CSR-MASTER-GROUP.                                           
      *==============================================================*          
      *                                                                         
           MOVE  '2780'                  TO ACTIVE-PARAGRAPH.           
           INITIALIZE    WS-NULL-INDICATORS.                            
           MOVE WS-REV-MONTH-CM          TO BN-REVENUE-MONTH            
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
      *** MASTER, OTHER, OTHER                                                  
           MOVE 'M'                      TO CM-CREDIT-GROUP             
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD        
                                                                        
           MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-IVR-CALL-DT              
                                            WS-CRED-BUR-RPT-DT          
                                            WS-DNP-REVIEW-DT.           
                                                                        
           MOVE -1                       TO WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-IVR-CALL-NULL-IND        
                                            WS-CRED-BUR-NULL-IND        
                                            WS-DNP-REVIEW-NULL-IND.     
      * CHARGE DUE DATE                                                         
           PERFORM 2880-PROCESS-CHRG-DUE-DT      THRU 2880-EXIT         
           MOVE WS-CURR-CHG-DUE-DT       TO WS-ARREARS-DUE-DT           
                                            WS-AVOID-LPC-DT             
           MOVE ZERO                     TO WS-ARREARS-DUE-NULL-IND     
                                            WS-AVOID-LPC-NULL-IND       
      * NON UTIL WQ DATE                                                        
           MOVE WS-CBILL-DT-DELQ-VALUE   TO WS-NO-OF-DAYS               
           MOVE WS-CURR-CHG-DUE-DT       TO WS-NEW-BUSINESS-DAY         
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT            
           MOVE ZERO                     TO WS-NONUTIL-WQ-NULL-IND      
                                                                        
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *                                                                         
       2780-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2800-PROCESS-SEB-FORECAST.                                       
      *==============================================================*  04450000
      *                                                                 07766055
           MOVE  '2800'                     TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-REV-MONTH-CM             TO BN-REVENUE-MONTH         
                                               CM-REVENUE-MONTH         
                                                                        
      *** SEB PROCESS                                                           
           MOVE '01'                        TO WS-COMPANY-NO-AT         
                                               CM-COMPANY-NO.           
                                                                        
      *                                                                         
      *LOAD SEB DELINQUENCY VALUE                                               
           SET DELQ-INDX                    TO 1.                       
           PERFORM 2810-LOAD-SEB-DELINQ          THRU  2810-EXIT        
               UNTIL DELQ-INDX > WS-DELINQ-COUNT.                       
      *                                                                         
           MOVE SPACES                      TO WS-PREV-BILL-CYCLE       
           PERFORM VARYING BILL-WNDW-SUB FROM 1 BY 1 UNTIL              
                   BILL-WNDW-SUB > WS-BILL-WND-COUNT                    
               PERFORM 2820-CHECK-BILL-CYC-CHNG THRU 2820-EXIT          
               PERFORM 2850-PROCESS-SEB-GRP      THRU 2850-EXIT         
               PERFORM 2860-PROCESS-SEB-BALANCE  THRU 2860-EXIT         
           END-PERFORM.                                                 
      *                                                                         
           IF TB-CRED-INDEX > 0                                         
              MOVE TB-CRED-INDEX            TO WS-INSERT-COUNT          
              PERFORM 8400-INSERT-CRED-FORECAST  THRU 8400-EXIT         
              MOVE ZERO                     TO TB-CRED-INDEX            
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2810-LOAD-SEB-DELINQ.                                            
      *==============================================================*          
      *                                                                         
           EVALUATE WS-DELINQ-CD-C8(DELQ-INDX)                          
              WHEN 'ARREARS-DUE-DT-A'                                   
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-ARREARS-DUE-DT-A                             
              WHEN 'AVOID-LPC-DT-A'                                     
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-AVOID-LPC-DT-A                               
I01687        WHEN 'AVOID-LPC-DT-SEB-A'                                 
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-AVOID-LPC-DT-SEB-A                           
              WHEN 'CURR-CHG-DUE-DT-A'                                  
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CURR-CHG-DUE-DT-A                            
              WHEN 'DNP-DT-A'                                           
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-DT-A                                     
              WHEN 'DNP-NOTICE-DUE-DT-A'                                
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-NOTICE-DUE-DT-A                          
              WHEN 'DNP-NOTICE-MAIL-DT-A'                               
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-NOTICE-MAIL-DT-A                         
              WHEN 'DNP-REVIEW-DT-A'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-REVIEW-DT-A                              
              WHEN 'IVR-CALL-DT-A'                                      
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-IVR-CALL-DT-A                                
              WHEN 'NONUTIL-WQ-DT-A'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-NONUTIL-WQ-DT-A                              
              WHEN 'DAY-DNP'                                            
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-DT-DELQ-VALUE                            
              WHEN 'DAY-SECOND-MAIL'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-MAIL-DT-DELQ-VALUE                           
              WHEN 'DAY-DUE'                                            
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DUE-DT-DELQ-VALUE                            
              WHEN 'DAY-SECOND-FIELD'                                   
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-FIELD-DT-DELQ-VALUE                          
              WHEN 'DAY-DPP-SECOND-MAIL'                                
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DPP-DT-DELQ-VALUE                            
              WHEN 'DAY-TOTAL-DUE'                                      
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-TOT-DT-DELQ-VALUE                            
              WHEN 'DAY-NU-WQDELQ'                                      
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-NU-DT-DELQ-VALUE                             
              WHEN 'DAY-CBILL-DELQ-WQ'                                  
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CBILL-DT-DELQ-VALUE                          
              WHEN 'DAY-CB15CYCLES'                                     
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CB15CYCLE-DELQ-VALUE                         
              WHEN 'DAY-CB610CYCLES'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CB610CYCLE-DELQ-VALUE                        
              WHEN 'DAY-CB1115CYCLES'                                   
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CB1115CYCLE-DELQ-VALUE                       
              WHEN 'DAY-CB1620CYCLES'                                   
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CB1620CYCLE-DELQ-VALUE                       
              WHEN 'ARREARS-DUE-DT-B'                                   
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-ARREARS-DUE-DT-B                             
              WHEN 'AVOID-LPC-DT-B'                                     
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-AVOID-LPC-DT-B                               
I01687        WHEN 'AVOID-LPC-DT-SEB-B'                                 
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-AVOID-LPC-DT-SEB-B                           
              WHEN 'CURR-CHG-DUE-DT-B'                                  
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-CURR-CHG-DUE-DT-B                            
              WHEN 'DNP-DT-B'                                           
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-DT-B                                     
              WHEN 'DNP-NOTICE-DUE-DT-B'                                
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-NOTICE-DUE-DT-B                          
              WHEN 'DNP-NOTICE-MAIL-DT-B'                               
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-NOTICE-MAIL-DT-B                         
              WHEN 'DNP-REVIEW-DT-B'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-DNP-REVIEW-DT-B                              
              WHEN 'IVR-CALL-DT-B'                                      
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-IVR-CALL-DT-B                                
              WHEN 'NONUTIL-WQ-DT-B'                                    
                   MOVE WS-DELINQ-VALUE-C8(DELQ-INDX)                   
                     TO WS-NONUTIL-WQ-DT-B                              
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
           SET DELQ-INDX UP BY 1.                                       
      *                                                                         
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2820-CHECK-BILL-CYC-CHNG.                                        
      *==============================================================*          
                                                                        
           MOVE WS-BILL-CYCLE-BW(BILL-WNDW-SUB)                         
                                           TO BN-BILL-CYCLE             
           MOVE WS-DATE-BN-CLOSE-BW(BILL-WNDW-SUB)                      
                                           TO WS-BILL-CYC-CLOSE-DT      
           MOVE WS-DATE-EXTRACT-BW(BILL-WNDW-SUB)                       
                                           TO BN-DATE-EXTRACT           
           MOVE WS-CODE-BILL-COND-BW(BILL-WNDW-SUB)                     
                                           TO BN-CODE-BILL-COND         
           MOVE WS-NEXT-BILL-DT-BW(BILL-WNDW-SUB)                       
                                           TO WS-NEXT-BILL-OPEN-DT      
           MOVE WS-NEXT-READ-DT-BW(BILL-WNDW-SUB)                       
                                           TO WS-NEXT-READ-DT           
      *                                                                         
           IF BN-BILL-CYCLE = WS-PREV-BILL-CYCLE                        
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2825-ONE-TIME-FORECAST-DATES  THRU  2825-EXIT     
              MOVE BN-BILL-CYCLE           TO WS-PREV-BILL-CYCLE        
           END-IF.                                                      
                                                                        
       2820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       2825-ONE-TIME-FORECAST-DATES.                                    
      *==============================================================*          
                                                                        
           MOVE '2825'                      TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE  SPACES                     TO TMP-CRED-BUR-RPT-DT.     
           MOVE -1                          TO TMP-CRED-BUR-IND         
           MOVE SPACES                      TO TMP-DNP-REVIEW-DT.       
           MOVE -1                          TO TMP-DNP-REVIEW-IND.      
      *DNP DATE                                                                 
           MOVE WS-DNP-DT-DELQ-VALUE        TO WS-NO-OF-DAYS.           
           MOVE WS-BILL-CYC-CLOSE-DT        TO WS-NEW-BUSINESS-DAY.     
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-DNP-DT.              
           MOVE ZERO                        TO TMP-DNP-IND.             
                                                                        
      *DNP NOTICE MAIL DATE                                                     
           MOVE WS-MAIL-DT-DELQ-VALUE       TO WS-NO-OF-DAYS.           
           MOVE TMP-DNP-DT                  TO WS-NEW-BUSINESS-DAY.     
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-DNP-NOTICE-MAIL-DT.  
           MOVE ZERO                        TO TMP-DNP-NOTICE-MAIL-IND. 
                                                                        
      * DNP NOTICE DUE DATE                                                     
           MOVE WS-DUE-DT-DELQ-VALUE        TO WS-NO-OF-DAYS.           
           MOVE TMP-DNP-DT                  TO WS-NEW-BUSINESS-DAY.     
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-DNP-NOTICE-DUE-DT.   
           MOVE ZERO                        TO TMP-DNP-NOTICE-DUE-IND.  
      * IVR DATE                                                                
           MOVE WS-FIELD-DT-DELQ-VALUE      TO WS-NO-OF-DAYS.           
           MOVE TMP-DNP-DT                  TO WS-NEW-BUSINESS-DAY.     
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-IVR-CALL-DT          
           MOVE ZERO                        TO TMP-IVR-CALL-IND.        
      * ARREARS DUE DATE                                                        
           MOVE WS-DUE-DT-DELQ-VALUE        TO WS-NO-OF-DAYS.           
           MOVE TMP-DNP-NOTICE-MAIL-DT      TO WS-NEW-BUSINESS-DAY.     
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-ARREARS-DUE-DT.      
           MOVE ZERO                        TO TMP-ARREARS-DUE-IND.     
      *                                                                         
      * AVOID LPC DATE                                                          
                                                                        
           MOVE WS-NEXT-BILL-OPEN-DT        TO TMP-AVOID-LPC-DT         
           MOVE ZERO                        TO TMP-AVOID-LPC-IND        
      * NON UTIL WQ DATE                                                        
           MOVE WS-DUE-DT-DELQ-VALUE        TO WS-NO-OF-DAYS            
I01687     MOVE WS-NEXT-BILL-OPEN-DT        TO WS-NEW-BUSINESS-DAY      
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY         TO TMP-NONUTIL-WQ-DT        
           MOVE ZERO                        TO TMP-NONUTIL-WQ-IND       
      * NEXT READ DATE                                                          
      * CHARGE DUE DATE                                                         
           MOVE WS-TOT-DT-DELQ-VALUE TO WS-NO-OF-DAYS                   
           MOVE WS-NEXT-READ-DT      TO WS-NEW-BUSINESS-DAY             
           PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT            
           MOVE WS-NEW-BUSINESS-DAY  TO TMP-CURR-CHG-DUE-DT             
           MOVE ZERO                 TO TMP-CURR-CHG-DUE-IND.           
      *                                                                         
       2825-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*         0
       2850-PROCESS-SEB-GRP.                                            
      *==============================================================*         0
                                                                        
           MOVE  '2850'                     TO ACTIVE-PARAGRAPH.        
                                                                        
      *** SEB, NEW                                                              
           PERFORM 2851-SEB-NEW-GROUP           THRU 2851-EXIT          
                                                                        
      *** SEB, ARREARS                                                          
           PERFORM 2852-SEB-ARR-GROUP           THRU 2852-EXIT          
                                                                        
      *** SEB, EXEMPT                                                           
           PERFORM 2853-SEB-EXE-GROUP           THRU 2853-EXIT          
                                                                        
      *** SEB, NON-UTIL                                                         
           PERFORM 2854-SEB-NON-GROUP           THRU 2854-EXIT          
                                                                        
      *** SEB, MASTER                                                           
           PERFORM 2855-SEB-MASTER-GROUP         THRU 2855-EXIT.        
                                                                        
       2850-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*         0
       2851-SEB-NEW-GROUP.                                              
      *==============================================================*         0
                                                                        
I01687     IF SEB-DATABASE AND                                          
I01687        WS-AVOID-LPC-DT-SEB-B  <  9999  AND                       
I01687        WS-NEXT-BILL-OPEN-DT   > SPACES                           
I01687        MOVE WS-AVOID-LPC-DT-SEB-B     TO   WS-DAYS-TO-MINUS      
I01687        MOVE WS-NEXT-BILL-OPEN-DT      TO   WS-DATE-INPUT         
I01687        PERFORM 7710-SET-LPC-DT-SEB       THRU 7710-EXIT          
I01687        MOVE WS-OUT-DATE               TO   WS-NEW-BUSINESS-DAY   
I01687        PERFORM 7750-VERIFY-PREV-BUSINESS-DAY THRU 7750-EXIT      
I01687        MOVE WS-NEW-BUSINESS-DAY       TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE ZERO                      TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     ELSE                                                         
I01687        MOVE SPACES                    TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE -1                        TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     END-IF.                                                      
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT.          
                                                                        
      * ARREARS DUE DATE                                                        
A05267     MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
A05267     MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
A05267     PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT.           
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
           MOVE  ZERO                    TO WS-ARREARS-DUE-NULL-IND.    
                                                                        
           MOVE 'N'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO WS-IVR-CALL-DT              
                                            WS-CRED-BUR-RPT-DT.         
           MOVE -1                       TO WS-IVR-CALL-NULL-IND        
                                            WS-CRED-BUR-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2851-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*         0
       2852-SEB-ARR-GROUP.                                              
      *==============================================================*         0
                                                                        
I01687     IF SEB-DATABASE AND                                          
I01687        WS-AVOID-LPC-DT-SEB-B   <  9999  AND                      
I01687        WS-NEXT-BILL-OPEN-DT   > SPACES                           
I01687        MOVE WS-AVOID-LPC-DT-SEB-B     TO   WS-DAYS-TO-MINUS      
I01687        MOVE WS-NEXT-BILL-OPEN-DT      TO   WS-DATE-INPUT         
I01687        PERFORM 7710-SET-LPC-DT-SEB       THRU 7710-EXIT          
I01687        MOVE WS-OUT-DATE               TO   WS-NEW-BUSINESS-DAY   
I01687        PERFORM 7750-VERIFY-PREV-BUSINESS-DAY  THRU 7750-EXIT     
I01687        MOVE WS-NEW-BUSINESS-DAY       TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE ZERO                      TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     ELSE                                                         
I01687        MOVE SPACES                    TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE -1                        TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     END-IF.                                                      
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * ARREARS DUE DATE                                                        
A05267     MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
A05267     MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
A05267     PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT.           
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
           MOVE  ZERO                    TO WS-ARREARS-DUE-NULL-IND     
                                                                        
           MOVE 'A'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO WS-IVR-CALL-DT              
                                            WS-CRED-BUR-RPT-DT.         
           MOVE -1                       TO WS-IVR-CALL-NULL-IND        
                                            WS-CRED-BUR-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE '100'                    TO CM-REG-GROUP-CD             
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE '200'                    TO CM-REG-GROUP-CD             
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2852-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*         0
       2853-SEB-EXE-GROUP.                                              
      *==============================================================*         0
                                                                        
I01687     IF SEB-DATABASE AND                                          
I01687        WS-AVOID-LPC-DT-SEB-B   <  9999  AND                      
I01687        WS-NEXT-BILL-OPEN-DT   > SPACES                           
I01687        MOVE WS-AVOID-LPC-DT-SEB-B     TO   WS-DAYS-TO-MINUS      
I01687        MOVE WS-NEXT-BILL-OPEN-DT      TO   WS-DATE-INPUT         
I01687        PERFORM 7710-SET-LPC-DT-SEB       THRU 7710-EXIT          
I01687        MOVE WS-OUT-DATE               TO   WS-NEW-BUSINESS-DAY   
I01687        PERFORM 7750-VERIFY-PREV-BUSINESS-DAY THRU 7750-EXIT      
I01687        MOVE WS-NEW-BUSINESS-DAY       TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE ZERO                      TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     ELSE                                                         
I01687        MOVE SPACES                    TO WS-AVOID-LPC-DT         
I01687                                          TMP-AVOID-LPC-DT        
I01687        MOVE -1                        TO WS-AVOID-LPC-NULL-IND   
I01687                                          TMP-AVOID-LPC-IND       
I01687     END-IF.                                                      
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * ARREARS DUE DATE                                                        
A05267     MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
A05267     MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
A05267     PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT.           
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
           MOVE  ZERO                    TO WS-ARREARS-DUE-NULL-IND     
                                                                        
           MOVE 'C'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'R'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO WS-IVR-CALL-DT              
                                            WS-CRED-BUR-RPT-DT          
                                            WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-NONUTIL-WQ-DT            
           MOVE -1                       TO WS-IVR-CALL-NULL-IND        
                                            WS-CRED-BUR-NULL-IND        
                                            WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-NONUTIL-WQ-NULL-IND      
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2853-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*         0
       2854-SEB-NON-GROUP.                                              
      *==============================================================*         0
                                                                        
I01687     IF WS-AVOID-LPC-DT-SEB-B   <  9999  AND                      
I01687        WS-NEXT-BILL-OPEN-DT   > SPACES                           
I01687        MOVE WS-AVOID-LPC-DT-SEB-B     TO   WS-DAYS-TO-MINUS      
I01687        MOVE WS-NEXT-BILL-OPEN-DT      TO   WS-DATE-INPUT         
I01687        PERFORM 7710-SET-LPC-DT-SEB       THRU 7710-EXIT          
I01687        MOVE WS-OUT-DATE               TO   WS-NEW-BUSINESS-DAY   
I01687        PERFORM 7750-VERIFY-PREV-BUSINESS-DAY THRU 7750-EXIT      
I01687        MOVE WS-NEW-BUSINESS-DAY       TO WS-AVOID-LPC-DT         
I01687        MOVE ZERO                      TO WS-AVOID-LPC-NULL-IND   
I01687     ELSE                                                         
I01687        MOVE SPACES                    TO WS-AVOID-LPC-DT         
I01687        MOVE -1                        TO WS-AVOID-LPC-NULL-IND   
I01687     END-IF.                                                      
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * ARREARS DUE DATE                                                        
A05267     MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
A05267     MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
A05267     PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT.           
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
           MOVE  ZERO                    TO WS-ARREARS-DUE-NULL-IND     
                                                                        
      * NON UTIL WQ DATE                                                        
           MOVE WS-NU-DT-DELQ-VALUE      TO WS-NO-OF-DAYS               
           MOVE TMP-CURR-CHG-DUE-DT      TO WS-NEW-BUSINESS-DAY         
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT            
           MOVE ZERO                     TO WS-NONUTIL-WQ-NULL-IND      
                                                                        
           MOVE 'D'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE BN-DATE-EXTRACT          TO WS-CRED-BUR-RPT-DT          
           MOVE ZERO                     TO WS-CRED-BUR-NULL-IND.       
           MOVE SPACES                   TO WS-IVR-CALL-DT              
                                            WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
           MOVE -1                       TO WS-IVR-CALL-NULL-IND        
                                            WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND.            
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2854-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*         0
       2855-SEB-MASTER-GROUP.                                           
      *==============================================================*         0
                                                                        
           PERFORM 2870-ASSIGN-ONE-TIME-VALUES THRU 2870-EXIT           
                                                                        
      * ARREARS DUE DATE                                                        
A05267     MOVE WS-DUE-DT-DELQ-VALUE     TO WS-NO-OF-DAYS.              
A05267     MOVE TMP-DNP-DT               TO WS-NEW-BUSINESS-DAY.        
A05267     PERFORM 5520-GET-PREV-BUSINESS-DAY THRU 5520-EXIT.           
           MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT.          
           MOVE  ZERO                    TO WS-ARREARS-DUE-NULL-IND     
                                                                        
      * CHARGE DUE DATE                                                         
           PERFORM 2880-PROCESS-CHRG-DUE-DT   THRU 2880-EXIT            
           MOVE WS-CURR-CHG-DUE-DT       TO WS-AVOID-LPC-DT             
      * NON UTIL WQ DATE                                                        
           MOVE WS-CBILL-DT-DELQ-VALUE   TO WS-NO-OF-DAYS               
           MOVE WS-CURR-CHG-DUE-DT       TO WS-NEW-BUSINESS-DAY         
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT            
           MOVE ZERO                     TO WS-NONUTIL-WQ-NULL-IND      
           MOVE ZERO                     TO WS-AVOID-LPC-NULL-IND       
                                                                        
           MOVE 'M'                      TO CM-CREDIT-GROUP.            
           MOVE SPACES                   TO CM-CREDIT-GROUP-ID          
           MOVE 'O'                      TO CM-CRED-ACCT-TYPE-CD.       
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO WS-IVR-CALL-DT              
                                            WS-DNP-NOTICE-DUE-DT        
                                            WS-DNP-NOTICE-MAIL-DT       
                                            WS-DNP-DT                   
                                            WS-CRED-BUR-RPT-DT          
           MOVE -1                       TO WS-IVR-CALL-NULL-IND        
                                            WS-DNP-NOTICE-DUE-NULL-IND  
                                            WS-DNP-NOTICE-MAIL-NULL-IND 
                                            WS-DNP-NULL-IND             
                                            WS-CRED-BUR-NULL-IND.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
                                                                        
      *                                                                         
       2855-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*         0
       2860-PROCESS-SEB-BALANCE.                                        
      *==============================================================*         0
      *                                                                         
           MOVE  '2860'                     TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE    WS-NULL-INDICATORS.                            
      *                                                                         
           MOVE WS-ARREARS-DUE-DT-A         TO WS-ARREARS-DUE-DT-DEL.   
           MOVE WS-AVOID-LPC-DT-A           TO WS-AVOID-LPC-DT-DEL.     
I01687     MOVE WS-AVOID-LPC-DT-SEB-A       TO WS-AVOID-LPC-DT-SEB-DEL. 
           MOVE WS-CURR-CHG-DUE-DT-A        TO WS-CURR-CHG-DUE-DT-DEL.  
           MOVE WS-DNP-DT-A                 TO WS-DNP-DT-DEL.           
           MOVE WS-DNP-NOTICE-DUE-DT-A      TO WS-DNP-NOTICE-DUE-DT-DEL.
           MOVE WS-DNP-NOTICE-MAIL-DT-A     TO WS-DNP-NOTICE-MAIL-DT-DEL
           MOVE WS-DNP-REVIEW-DT-A          TO WS-DNP-REVIEW-DT-DEL.    
           MOVE WS-IVR-CALL-DT-A            TO WS-IVR-CALL-DT-DEL.      
           MOVE WS-NONUTIL-WQ-DT-A          TO WS-NONUTIL-WQ-DT-DEL.    
      *                                                                         
      *PROCESS FOR REG GRP CD-REG(100),CREDIT GROUP-B,CREDIT TYPE CD-R,O        
      *    CREDIT TYPE CODE- R                                                  
           MOVE  'B'                        TO CM-CREDIT-GROUP.         
           MOVE  SPACES                     TO CM-CRED-FORECAST-CD.     
           MOVE '100'                       TO CM-REG-GROUP-CD.         
           MOVE  'R'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE SPACES                      TO CM-CREDIT-GROUP-ID       
                                               WS-CRED-BUR-RPT-DT.      
           MOVE -1                          TO WS-CRED-BUR-NULL-IND.    
           PERFORM 2862-COMPUTE-SEB-BAL-DUE-DT   THRU  2862-EXIT.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *    CREDIT TYPE CODE- O                                                  
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *PROCESS FOR REG GRP CD-REG(200),CREDIT GROUP-B,CREDIT TYPE CD-R,O        
      *    CREDIT TYPE CODE- R (RESIDENTIAL)                                    
           MOVE '200'                       TO CM-REG-GROUP-CD.         
           MOVE  'R'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE  'A'                        TO CM-CRED-FORECAST-CD.     
           MOVE SPACES                      TO CM-CREDIT-GROUP-ID.      
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *    CREDIT TYPE CODE- O (NON-RESIDENTIAL)                                
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE  SPACES                     TO CM-CRED-FORECAST-CD.     
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *                                                                         
      *PROCESS FOR REG GRP CD- DREG,CREDIT GROUP- B,CREDIT TYPE CD- R,O         
      *    CREDIT TYPE CODE- R                                                  
           MOVE WS-ARREARS-DUE-DT-B         TO WS-ARREARS-DUE-DT-DEL.   
           MOVE WS-AVOID-LPC-DT-B           TO WS-AVOID-LPC-DT-DEL.     
I01687     MOVE WS-AVOID-LPC-DT-SEB-B       TO WS-AVOID-LPC-DT-SEB-DEL. 
           MOVE WS-CURR-CHG-DUE-DT-B        TO WS-CURR-CHG-DUE-DT-DEL.  
           MOVE WS-DNP-DT-B                 TO WS-DNP-DT-DEL.           
           MOVE WS-DNP-NOTICE-DUE-DT-B      TO WS-DNP-NOTICE-DUE-DT-DEL.
           MOVE WS-DNP-NOTICE-MAIL-DT-B     TO WS-DNP-NOTICE-MAIL-DT-DEL
           MOVE WS-DNP-REVIEW-DT-B          TO WS-DNP-REVIEW-DT-DEL.    
           MOVE WS-IVR-CALL-DT-B            TO WS-IVR-CALL-DT-DEL.      
           MOVE WS-NONUTIL-WQ-DT-B          TO WS-NONUTIL-WQ-DT-DEL.    
      *                                                                         
           MOVE  'R'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE  'B'                        TO CM-CRED-FORECAST-CD.     
           MOVE SPACES                      TO CM-CREDIT-GROUP-ID       
                                               CM-REG-GROUP-CD.         
           MOVE  SPACES                     TO WS-DNP-NOTICE-DUE-DT     
                                               WS-DNP-NOTICE-MAIL-DT    
                                               WS-DNP-DT                
                                               WS-IVR-CALL-DT           
           PERFORM 2862-COMPUTE-SEB-BAL-DUE-DT   THRU  2862-EXIT.       
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
      *    CREDIT TYPE CODE- O (NON-RESIDENTIAL)                                
           MOVE  'O'                        TO CM-CRED-ACCT-TYPE-CD.    
           MOVE  SPACES                     TO CM-CRED-FORECAST-CD.     
           PERFORM 5100-LOAD-CRED-FORECAST       THRU  5100-EXIT.       
           INITIALIZE    WS-DATE-FIELDS.                                
      *                                                                         
       2860-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2862-COMPUTE-SEB-BAL-DUE-DT.                                     
      *==============================================================*  04450000
                                                                        
           MOVE  '2862'                     TO ACTIVE-PARAGRAPH.        
                                                                        
      *** ARREARS DUE DT                                                        
           IF WS-ARREARS-DUE-DT-DEL < 9999                              
              MOVE WS-ARREARS-DUE-DT-DEL    TO WS-DAYS-TO-ADD           
              MOVE BN-DATE-EXTRACT          TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST   THRU 7720-EXIT           
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-ARREARS-DUE-DT        
              MOVE ZERO                     TO WS-ARREARS-DUE-NULL-IND  
           ELSE                                                         
              MOVE SPACES                   TO WS-ARREARS-DUE-DT        
              MOVE -1                       TO WS-ARREARS-DUE-NULL-IND  
           END-IF                                                       
                                                                        
      *** CURR CHG DUE DT                                                       
           IF WS-CURR-CHG-DUE-DT-DEL < 9999                             
              MOVE WS-CURR-CHG-DUE-DT-DEL   TO WS-DAYS-TO-ADD           
              MOVE BN-DATE-EXTRACT          TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT       
              MOVE ZERO                     TO WS-CURR-CHG-DUE-NULL-IND 
           ELSE                                                         
              MOVE SPACES                   TO WS-CURR-CHG-DUE-DT       
              MOVE -1                       TO WS-CURR-CHG-DUE-NULL-IND 
           END-IF                                                       
                                                                        
      *** DNP NOTICE MAIL DT                                                    
           IF WS-DNP-NOTICE-MAIL-DT-DEL < 9999  AND                     
              WS-CURR-CHG-DUE-DT      > SPACES                          
              MOVE WS-DNP-NOTICE-MAIL-DT-DEL TO WS-DAYS-TO-ADD          
              MOVE WS-CURR-CHG-DUE-DT       TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST     THRU 7720-EXIT         
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-NOTICE-MAIL-DT    
              MOVE ZERO                   TO WS-DNP-NOTICE-MAIL-NULL-IND
           ELSE                                                         
              MOVE SPACES                   TO WS-DNP-NOTICE-MAIL-DT    
              MOVE -1                     TO WS-DNP-NOTICE-MAIL-NULL-IND
           END-IF                                                       
                                                                        
      *** IVR CALL DT                                                           
           IF WS-IVR-CALL-DT-DEL <  9999 AND                            
              WS-DNP-NOTICE-MAIL-DT > SPACES                            
              MOVE WS-IVR-CALL-DT-DEL       TO WS-DAYS-TO-ADD           
              MOVE WS-DNP-NOTICE-MAIL-DT    TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-IVR-CALL-DT           
              MOVE ZERO                     TO WS-IVR-CALL-NULL-IND     
           ELSE                                                         
              MOVE SPACES                   TO WS-IVR-CALL-DT           
              MOVE -1                       TO WS-IVR-CALL-NULL-IND     
           END-IF                                                       
                                                                        
      *** DNP NOTICE DUE DT                                                     
           IF WS-DNP-NOTICE-DUE-DT-DEL <  9999 AND                      
              WS-DNP-NOTICE-MAIL-DT > SPACES                            
              MOVE WS-DNP-NOTICE-DUE-DT-DEL TO WS-DAYS-TO-ADD           
              MOVE WS-DNP-NOTICE-MAIL-DT    TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-NOTICE-DUE-DT     
              MOVE ZERO                    TO WS-DNP-NOTICE-DUE-NULL-IND
           ELSE                                                         
              MOVE SPACES                   TO WS-DNP-NOTICE-DUE-DT     
              MOVE -1                      TO WS-DNP-NOTICE-DUE-NULL-IND
           END-IF                                                       
                                                                        
      *** DNP REVIEW DT                                                         
           IF WS-DNP-REVIEW-DT-DEL    <  9999 AND                       
              WS-DNP-NOTICE-MAIL-DT   >  SPACES                         
              MOVE WS-DNP-REVIEW-DT-DEL     TO WS-DAYS-TO-ADD           
              MOVE WS-DNP-NOTICE-MAIL-DT    TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-REVIEW-DT         
              MOVE ZERO                     TO WS-DNP-REVIEW-NULL-IND   
           ELSE                                                         
              MOVE SPACES                   TO WS-DNP-REVIEW-DT         
              MOVE -1                       TO WS-DNP-REVIEW-NULL-IND   
           END-IF                                                       
                                                                        
      *** DNP DT                                                                
           IF WS-DNP-DT-DEL < 9999  AND                                 
              WS-DNP-NOTICE-DUE-DT > SPACES                             
              MOVE WS-DNP-DT-DEL            TO WS-DAYS-TO-ADD           
              MOVE WS-DNP-NOTICE-DUE-DT     TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-DNP-DT                
              MOVE ZERO                     TO WS-DNP-NULL-IND          
           ELSE                                                         
              MOVE SPACES                   TO WS-DNP-DT                
              MOVE -1                       TO WS-DNP-NULL-IND          
           END-IF                                                       
                                                                        
      *** NONUTIL WQ DT                                                         
           IF WS-NONUTIL-WQ-DT-DEL < 9999  AND                          
              WS-DNP-NOTICE-DUE-DT > SPACES                             
              MOVE WS-NONUTIL-WQ-DT-DEL     TO WS-DAYS-TO-ADD           
              MOVE WS-DNP-NOTICE-DUE-DT     TO WS-DATE-INPUT            
              PERFORM 7720-SET-CRED-FORECAST    THRU 7720-EXIT          
              MOVE WS-OUT-DATE              TO WS-NEW-BUSINESS-DAY      
              PERFORM 7725-VERIFY-BUSINESS-DAY THRU 7725-EXIT           
              MOVE WS-NEW-BUSINESS-DAY      TO WS-NONUTIL-WQ-DT         
              MOVE ZERO                     TO WS-NONUTIL-WQ-NULL-IND   
           ELSE                                                         
              MOVE SPACES                   TO WS-NONUTIL-WQ-DT         
              MOVE -1                       TO WS-NONUTIL-WQ-NULL-IND   
           END-IF.                                                      
                                                                        
      *** AVOID LPC DT                                                          
I01687     IF WS-AVOID-LPC-DT-SEB-B   <  9999  AND                      
              WS-NEXT-BILL-OPEN-DT   > SPACES                           
I01687        MOVE WS-AVOID-LPC-DT-SEB-B     TO   WS-DAYS-TO-MINUS      
              MOVE WS-NEXT-BILL-OPEN-DT      TO   WS-DATE-INPUT         
I01687        PERFORM 7710-SET-LPC-DT-SEB       THRU 7710-EXIT          
              MOVE WS-OUT-DATE               TO   WS-NEW-BUSINESS-DAY   
I01687        PERFORM 7750-VERIFY-PREV-BUSINESS-DAY THRU 7750-EXIT      
              MOVE WS-NEW-BUSINESS-DAY       TO   WS-AVOID-LPC-DT       
              MOVE ZERO                      TO   WS-AVOID-LPC-NULL-IND 
           ELSE                                                         
              MOVE SPACES                    TO   WS-AVOID-LPC-DT       
              MOVE -1                        TO   WS-AVOID-LPC-NULL-IND 
           END-IF.                                                      
                                                                        
      *                                                                         
       2862-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*          
       2870-ASSIGN-ONE-TIME-VALUES.                                     
      *==============================================================*          
      *                                                                         
           MOVE '2870'                   TO ACTIVE-PARAGRAPH            
      *                                                                         
           MOVE SPACES                   TO CM-REG-GROUP-CD             
           MOVE SPACES                   TO CM-CRED-FORECAST-CD         
           MOVE TMP-CRED-BUR-RPT-DT      TO WS-CRED-BUR-RPT-DT          
           MOVE TMP-CRED-BUR-IND         TO WS-CRED-BUR-NULL-IND        
           MOVE TMP-DNP-REVIEW-DT        TO WS-DNP-REVIEW-DT            
           MOVE TMP-DNP-REVIEW-IND       TO WS-DNP-REVIEW-NULL-IND      
           MOVE TMP-DNP-DT               TO WS-DNP-DT                   
           MOVE TMP-DNP-IND              TO WS-DNP-NULL-IND             
           MOVE TMP-DNP-NOTICE-MAIL-DT   TO WS-DNP-NOTICE-MAIL-DT       
           MOVE TMP-DNP-NOTICE-MAIL-IND  TO WS-DNP-NOTICE-MAIL-NULL-IND 
           MOVE TMP-DNP-NOTICE-DUE-DT    TO WS-DNP-NOTICE-DUE-DT        
           MOVE TMP-DNP-NOTICE-DUE-IND   TO WS-DNP-NOTICE-DUE-NULL-IND  
           MOVE TMP-IVR-CALL-DT          TO WS-IVR-CALL-DT              
           MOVE TMP-IVR-CALL-IND         TO WS-IVR-CALL-NULL-IND        
           MOVE TMP-ARREARS-DUE-DT       TO WS-ARREARS-DUE-DT           
           MOVE TMP-ARREARS-DUE-IND      TO WS-ARREARS-DUE-NULL-IND     
           MOVE TMP-AVOID-LPC-DT         TO WS-AVOID-LPC-DT             
           MOVE TMP-AVOID-LPC-IND        TO WS-AVOID-LPC-NULL-IND       
           MOVE TMP-NONUTIL-WQ-DT        TO WS-NONUTIL-WQ-DT            
           MOVE TMP-NONUTIL-WQ-IND       TO WS-NONUTIL-WQ-NULL-IND      
           MOVE TMP-CURR-CHG-DUE-DT      TO WS-CURR-CHG-DUE-DT          
           MOVE TMP-CURR-CHG-DUE-IND     TO WS-CURR-CHG-DUE-NULL-IND.   
                                                                        
       2870-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       2880-PROCESS-CHRG-DUE-DT.                                        
      *==============================================================*  04450000
      *                                                                 07766055
           MOVE  '2880'                           TO ACTIVE-PARAGRAPH.  
      *                                                                         
           EVALUATE BN-BILL-CYCLE                                       
               WHEN '01'                                                
               WHEN '02'                                                
               WHEN '03'                                                
               WHEN '04'                                                
               WHEN '05'                                                
                    MOVE WS-CB15CYCLE-DELQ-VALUE  TO WS-NO-OF-DAYS      
               WHEN '06'                                                
               WHEN '07'                                                
               WHEN '08'                                                
               WHEN '09'                                                
               WHEN '10'                                                
                    MOVE WS-CB610CYCLE-DELQ-VALUE TO WS-NO-OF-DAYS      
               WHEN '11'                                                
               WHEN '12'                                                
               WHEN '13'                                                
               WHEN '14'                                                
               WHEN '15'                                                
                    MOVE WS-CB1115CYCLE-DELQ-VALUE TO WS-NO-OF-DAYS     
               WHEN '16'                                                
               WHEN '17'                                                
               WHEN '18'                                                
               WHEN '19'                                                
               WHEN '20'                                                
                    MOVE WS-CB1620CYCLE-DELQ-VALUE TO WS-NO-OF-DAYS     
               WHEN OTHER                                               
                    MOVE WS-CB15CYCLE-DELQ-VALUE   TO WS-NO-OF-DAYS     
           END-EVALUATE.                                                
      *                                                                         
           MOVE BN-DATE-EXTRACT          TO WS-NEW-BUSINESS-DAY         
           PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT            
           MOVE WS-NEW-BUSINESS-DAY      TO WS-CURR-CHG-DUE-DT.         
           MOVE ZERO                     TO WS-CURR-CHG-DUE-NULL-IND.   
      *                                                                         
       2880-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  07660060
       2900-GET-NEXT-DATE.                                              
      *==============================================================*  07765055
      *   THIS PARAGRAPH IS USED TO GET NEXT BUSINESS DAY.              07763055
      *                                                                 07766055
           MOVE  '2900'                     TO  ACTIVE-PARAGRAPH        
                                                                        
           PERFORM 7100-GET-NEXT-DAY            THRU 7100-EXIT.         
           IF WS-DAY EQUAL 6                                            
               OR WS-DAY EQUAL ZEROES                                   
               MOVE WS-NO                   TO WS-DATE-FOUND            
           ELSE                                                         
               MOVE ZEROES                  TO WS-ROW-COUNT             
               MOVE WS-HOLD-DATE            TO J8-HOLIDAY-DT            
               PERFORM 7150-SELECT-HOLIDAY      THRU 7150-EXIT          
               IF WS-ROW-COUNT GREATER THAN ZEROES                      
                   MOVE WS-NO               TO WS-DATE-FOUND            
               ELSE                                                     
                   MOVE WS-YES              TO WS-DATE-FOUND            
                   ADD 1                    TO WS-DAY-COUNTER           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07772459
      *==============================================================*  04450000
       3100-CALC-NEXT-REVENUE-MONTH.                                    
      *==============================================================*  04450000
      *                                                                         
           MOVE '3100'                      TO ACTIVE-PARAGRAPH         
                                                                        
           MOVE WS-REVENUE-MONTH-CM         TO WS-REVENUE-MONTH-N       
           MOVE WS-REVENUE-MONTH-N          TO WS-CURR-REVENUE-MONTH    
      *                                                                         
           IF WS-CURR-REV-MONTH = 12                                    
              MOVE 01                       TO WS-NEXT-REV-MTH          
              COMPUTE WS-NEXT-REV-YEAR = WS-CURR-REV-YEAR  + 01         
           ELSE                                                         
              COMPUTE WS-NEXT-REV-MTH = WS-CURR-REV-MONTH  + 01         
              MOVE WS-CURR-REV-YEAR         TO WS-NEXT-REV-YEAR         
           END-IF.                                                      
      *                                                                         
       3100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       3200-CALC-PREV-REVENUE-MONTH.                                    
      *==============================================================*  04450000
                                                                        
           MOVE '3200'                       TO ACTIVE-PARAGRAPH        
                                                                        
           MOVE BN-REVENUE-MONTH             TO WS-PREV-REVENUE-DATE    
      *                                                                         
           IF WS-PREV-REV-DATE-MM   > 01                                
              COMPUTE WS-PREV-REV-DATE-MM =  WS-PREV-REV-DATE-MM - 1    
           ELSE                                                         
              MOVE    12                     TO WS-PREV-REV-DATE-MM     
              COMPUTE WS-PREV-REV-DATE-CCYY                             
                                       =  WS-PREV-REV-DATE-CCYY - 1     
           END-IF.                                                      
      *                                                                         
           MOVE WS-PREV-REVENUE-DATE         TO WS-PREV-REVENUE-MONTH.  
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       5100-LOAD-CRED-FORECAST.                                         
      *==============================================================*  04450000
                                                                        
           MOVE  '5100'                     TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 5110-MOVE-FORECAST-VALUE      THRU  5110-EXIT.       
                                                                        
           IF TB-CRED-INDEX  = WS-READY-TO-INSERT-COUNT                 
              PERFORM 8400-INSERT-CRED-FORECAST  THRU 8400-EXIT         
              MOVE ZERO                     TO TB-CRED-INDEX            
              MOVE WS-READY-TO-INSERT-COUNT TO WS-INSERT-COUNT          
              INITIALIZE  WS-CRED-FORECAST-ARRAY                        
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*         0
       5110-MOVE-FORECAST-VALUE.                                        
      *==============================================================*         0
      *                                                                         
           MOVE  '5110'                     TO ACTIVE-PARAGRAPH.        
           ADD 1                            TO TB-CRED-INDEX            
           MOVE CM-COMPANY-NO               TO                          
                WS-COMPANY-NO(TB-CRED-INDEX)                            
           MOVE CM-REG-GROUP-CD             TO                          
                WS-REG-GROUP-CD(TB-CRED-INDEX)                          
           MOVE BN-REVENUE-MONTH            TO                          
                WS-REVENUE-MNTH(TB-CRED-INDEX)                          
           MOVE BN-DATE-EXTRACT             TO                          
                WS-BILL-DT(TB-CRED-INDEX)                               
           MOVE BN-BILL-CYCLE               TO                          
                WS-BILL-CYCLE(TB-CRED-INDEX)                            
           MOVE CM-CREDIT-GROUP             TO                          
                WS-CREDIT-GROUP(TB-CRED-INDEX)                          
           MOVE CM-CREDIT-GROUP-ID          TO                          
                WS-CREDIT-GROUP-ID(TB-CRED-INDEX)                       
           MOVE CM-CRED-ACCT-TYPE-CD        TO                          
                WS-CRED-ACCT-TYPE-CD(TB-CRED-INDEX)                     
           MOVE CM-CRED-FORECAST-CD         TO                          
                WS-CRED-FORECAST-CD(TB-CRED-INDEX)                      
           MOVE WS-ARREARS-DUE-DT           TO                          
                WS-ARREARS-DUE-DATE(TB-CRED-INDEX)                      
           MOVE WS-ARREARS-DUE-NULL-IND     TO                          
                WS-ARRERS-DUE-NULL-IND(TB-CRED-INDEX)                   
           MOVE WS-DNP-NOTICE-DUE-DT        TO                          
                WS-DNP-NOTICE-DUE-DATE(TB-CRED-INDEX)                   
           MOVE WS-DNP-NOTICE-DUE-NULL-IND  TO                          
                WS-DNP-NOTICE-NULL-IND(TB-CRED-INDEX)                   
           MOVE WS-DNP-NOTICE-MAIL-DT       TO                          
                WS-DNP-NOTICE-MAIL-DATE(TB-CRED-INDEX)                  
           MOVE WS-DNP-NOTICE-MAIL-NULL-IND TO                          
                WS-DNP-MAIL-NULL-IND(TB-CRED-INDEX)                     
           MOVE WS-DNP-REVIEW-DT            TO                          
                WS-DNP-REVIEW-DATE(TB-CRED-INDEX)                       
           MOVE WS-DNP-REVIEW-NULL-IND      TO                          
                WS-DNP-REV-NULL-IND(TB-CRED-INDEX)                      
           MOVE WS-DNP-DT                   TO                          
                WS-DNP-DATE(TB-CRED-INDEX)                              
           MOVE WS-DNP-NULL-IND             TO                          
                WS-DNP-DATE-NULL-IND(TB-CRED-INDEX)                     
           MOVE WS-CURR-CHG-DUE-DT          TO                          
                WS-CURR-CHG-DUE-DATE(TB-CRED-INDEX)                     
           MOVE WS-CURR-CHG-DUE-NULL-IND    TO                          
                WS-CURR-CHG-NULL-IND(TB-CRED-INDEX)                     
           MOVE WS-IVR-CALL-DT              TO                          
                WS-IVR-CALL-DATE(TB-CRED-INDEX)                         
           MOVE WS-IVR-CALL-NULL-IND        TO                          
                WS-IVR-DT-NULL-IND(TB-CRED-INDEX)                       
           MOVE WS-AVOID-LPC-DT             TO                          
                WS-AVOID-LPC-DATE(TB-CRED-INDEX)                        
           MOVE WS-AVOID-LPC-NULL-IND       TO                          
                WS-LPC-DT-NULL-IND(TB-CRED-INDEX)                       
           MOVE WS-NONUTIL-WQ-DT            TO                          
                WS-NONUTIL-WQ-DATE(TB-CRED-INDEX)                       
           MOVE WS-NONUTIL-WQ-NULL-IND      TO                          
                WS-WQ-DT-NULL-IND(TB-CRED-INDEX)                        
           MOVE WS-CRED-BUR-RPT-DT          TO                          
                WS-CRED-BUR-RPT-DATE(TB-CRED-INDEX)                     
           MOVE WS-CRED-BUR-NULL-IND        TO                          
                WS-BUR-RPT-DT-NULL-IND(TB-CRED-INDEX).                  
      *                                                                         
       5110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       5500-GET-NEXT-BUSINESS-DAY.                                      
      *==============================================================*  04450000
                                                                        
           SET WD-INDX TO 1.                                            
                                                                        
           SEARCH ALL WS-WORK-DAY-LIST                                  
              AT END                                                    
                PERFORM 7730-GET-NEXT-BUSINESS-DAY THRU 7730-EXIT       
                                                                        
              WHEN WS-WORK-DAY (WD-INDX) = WS-NEW-BUSINESS-DAY          
                                                                        
                SET WD-INDX UP BY WS-NO-OF-DAYS                         
                MOVE WS-WORK-DAY (WD-INDX)    TO WS-NEW-BUSINESS-DAY    
                MOVE  1                       TO WS-NO-OF-DAYS          
                                                                        
           END-SEARCH.                                                  
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       5520-GET-PREV-BUSINESS-DAY.                                      
      *==============================================================*  04450000
                                                                        
           SET WD-INDX TO 1.                                            
                                                                        
           SEARCH ALL WS-WORK-DAY-LIST                                  
              AT END                                                    
                PERFORM 7740-GET-PREV-BUSINESS-DAY THRU 7740-EXIT       
                                                                        
              WHEN WS-WORK-DAY (WD-INDX) = WS-NEW-BUSINESS-DAY          
                                                                        
                SET WD-INDX DOWN BY WS-NO-OF-DAYS                       
                MOVE WS-WORK-DAY (WD-INDX)    TO WS-NEW-BUSINESS-DAY    
                MOVE  1                       TO WS-NO-OF-DAYS          
                                                                        
           END-SEARCH.                                                  
                                                                        
       5520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7000-WHICH-DBASE.                                                
      *==============================================================*          
      *                                                                 08840000
           EXEC SQL                                                     
              SELECT DELINQ_CD                                          
                    ,COMPANY_NO                                         
                    ,DELINQ_VALUE                                       
                INTO :C8-DELINQ-CD                                      
                    ,:C8-COMPANY-NO                                     
                    ,:C8-DELINQ-VALUE                                   
               FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD  = 'LS-BILL-ENTITY'                       
                AND COMPANY_NO = '01'                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08220000
MFA-TR*       SELECT DELINQ_CD                                          08223065
MFA-TR*             ,COMPANY_NO                                         08223065
MFA-TR*             ,DELINQ_VALUE                                       08223065
MFA-TR*         INTO :C8-DELINQ-CD                                      08225063
MFA-TR*             ,:C8-COMPANY-NO                                     08225063
MFA-TR*             ,:C8-DELINQ-VALUE                                   08225063
MFA-TR*        FROM  CSS_DELINQUENCY                                    08227056
MFA-TR*       WHERE DELINQ_CD  = 'LS-BILL-ENTITY'                               
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    08240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08250000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08229356
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               MOVE C8-DELINQ-VALUE         TO WS-DATABASE              
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09110000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7050-GET-CURRENT-DATE.                                           
      *==============================================================*          
      *                                                                 08220056
           EXEC SQL                                                     
               SELECT
              CIS.DAYS (IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ))                 
                      - (CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ))/7 * 7)
            INTO
              :WS-DAY     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DAY = DAYS (DATE(:WS-HOLD-DATE))                         
MFA-TR*               - (INTEGER (DAYS(DATE(:WS-HOLD-DATE))/7) * 7)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08250000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08229356
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'WS-HOLD-DATE'          TO TABLE-ELEMENT-1          
               MOVE WS-HOLD-DATE            TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08230456
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08260056
      *==============================================================*          
       7100-GET-NEXT-DAY.                                               
      *==============================================================*          
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))       
                  - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))/7 * 7)
            INTO
              :WS-HOLD-DATE,
              :WS-DAY 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-HOLD-DATE  = DATE (:WS-HOLD-DATE) + 1 DAYS               
MFA-TR*           ,:WS-DAY =  DAYS (DATE(:WS-HOLD-DATE) + 1 DAYS)               
MFA-TR*           - (INTEGER(DAYS(DATE(:WS-HOLD-DATE) + 1 DAYS)/7) * 7)         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'WS-HOLD-DATE'          TO TABLE-ELEMENT-1          
               MOVE WS-HOLD-DATE            TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08380056
      *==============================================================*          
       7150-SELECT-HOLIDAY.                                             
      *==============================================================*          
      *   THIS PARAGRAPH IS USED TO DETERMINE IF THE DATE SPECIFIED   * 08810055
      *   IS A HOLIDAY.                                               * 08820055
      *                                                                 08840000
           EXEC SQL                                                     
               SELECT COUNT (*)                                         
                 INTO :WS-ROW-COUNT                                     
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08850000
MFA-TR*        SELECT COUNT (*)                                         08860056
MFA-TR*          INTO :WS-ROW-COUNT                                     08870056
MFA-TR*          FROM CSS_HOLIDAY                                       08880056
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                       08890063
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    08940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08950000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08970000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_HOLIDAY'           TO TABLE-1                  
               MOVE 'HOLIDAY_DT'            TO TABLE-ELEMENT-1          
               MOVE J8-HOLIDAY-DT           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09110000
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7200-GET-PREV-BUSINESS-DAY.                                      
      *==============================================================*          
      *                                                                 08840000
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) )) -      
                     CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-PREV-BUSINESS-DAY,
              :WS-DAY-OF-WEEK  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-PREV-BUSINESS-DAY                                        
MFA-TR*            = DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS                       
MFA-TR*            ,:WS-DAY-OF-WEEK                                             
MFA-TR*            = (DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS) -              
MFA-TR*              DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS)/7*7)+1          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO  WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'WS-PREV-BUSINESS-DAY'  TO TABLE-ELEMENT-1          
               MOVE WS-PREV-BUSINESS-DAY    TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
      ***  CHECK TO SEE IF IT IS A WEEKEND                                      
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
      *                                                                         
              MOVE WS-PREV-BUSINESS-DAY     TO J8-HOLIDAY-DT            
              MOVE ZEROES                   TO WS-ROW-COUNT             
      *                                                                         
              PERFORM 7150-SELECT-HOLIDAY       THRU 7150-EXIT          
              IF WS-ROW-COUNT GREATER THAN ZEROES                       
                 MOVE WS-NO                 TO  WS-DATE-FOUND           
              ELSE                                                      
                 MOVE WS-YES                TO  WS-DATE-FOUND           
                 SUBTRACT  1  FROM  WS-DAY-COUNTER                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08840000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7220-OPEN-WORK-DAY-CSR.                                          
      *==============================================================*          
                                                                        
           EXEC SQL                                                     
              OPEN WORK-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7220'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7230-FETCH-WORK-DAY-CSR.                                         

MSQ008     MOVE 120 TO MSQ008-WORK-CUR
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-WORK-CUR
              FETCH 
              FROM WORK-CUR               
               INTO :WS-BUSI-DAY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM WORK-CUR FOR 120 ROWS                      
MFA-TR*        INTO :WS-BUSI-DAY                                                
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WORK-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7230'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7240-CLOSE-WORK-DAY-CSR.                                         
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              CLOSE WORK-CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7240'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7280-OPEN-BILL-WINDOW-CSR.                                       
      *==============================================================*          
                                                                        
           EXEC SQL                                                     
              OPEN BILL-WINDOW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7280'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_BILL_WINDOW'       TO TABLE-1                  
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-1          
               MOVE BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7290-FETCH-BILL-WINDOW-CSR.                                      

MSQ008     MOVE 150 TO MSQ008-BILL-WINDOW
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-BILL-WINDOW
              FETCH 
              FROM BILL-WINDOW            
               INTO :WS-DATE-EXTRACT-BW                                 
                   ,:WS-BILL-CYCLE-BW                                   
                   ,:WS-CODE-BILL-COND-BW                               
                   ,:WS-NEXT-BILL-DT-BW                                 
                   ,:WS-NEXT-READ-DT-BW                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM BILL-WINDOW FOR 150 ROWS                   
MFA-TR*        INTO :WS-DATE-EXTRACT-BW                                         
MFA-TR*            ,:WS-BILL-CYCLE-BW                                           
MFA-TR*            ,:WS-CODE-BILL-COND-BW                                       
MFA-TR*            ,:WS-NEXT-BILL-DT-BW                                         
MFA-TR*            ,:WS-NEXT-READ-DT-BW                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-BILL-WINDOW
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)        TO WS-BILL-WND-COUNT               
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7290'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE 'CSS_BILL_WINDOW'       TO TABLE-1                   
              MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-1           
              MOVE BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7300-CLOSE-BILL-WINDOW-CSR.                                      
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL-WINDOW                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_BILL_WINDOW'       TO TABLE-1                  
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-1          
               MOVE BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7350-GET-LAST-DAY.                                               
      *==============================================================*          
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) )
            INTO
              :WS-PREV-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-PREV-DATE  = DATE (:WS-HOLD-DATE) - 1 DAYS               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7350'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'WS-HOLD-DATE'          TO TABLE-ELEMENT-1          
               MOVE WS-HOLD-DATE            TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 08270056
       7370-REV-MNTH-LAST-DAY.                                          
      *===============================================================* 08320056
      *                                                                         
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT
              (SELECT CAST(DATEADD(DAY, -DAY(E), E) AS DATE) 
              FROM (SELECT DATEADD(MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                     :WS-REV-MNTH-DT-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-MNTH-DT-ST
              ) <> 0) OR (LEN(:WS-REV-MNTH-DT-ST
              ) <> 10), CIS.CHAR2DATE(:WS-REV-MNTH-DT-ST
              ), CONVERT(DATE, :WS-REV-MNTH-DT-ST) )) E) T)
            INTO
              :WS-REV-MNTH-DT-END        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-REV-MNTH-DT-END =                                        
MFA-TR*                             LAST_DAY(:WS-REV-MNTH-DT-ST)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7370'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'REV_MNTH_DATE'         TO TABLE-ELEMENT-1          
               MOVE WS-REV-MNTH-DT-ST TO HOSTVAR-ELEMENT-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 29950000
      *==============================================================*  04450000
       7450-OPEN-DELINQUENCY.                                           
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
               OPEN DELINQ-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7450'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       7500-FETCH-DELINQUENCY.                                          
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
               FETCH DELINQ-CURSOR                                      
               INTO  :C8-DELINQ-CD                                      
                    ,:C8-DELINQ-VALUE                                   
                    ,:C8-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       7550-CLOSE-DELINQUENCY.                                          
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
               CLOSE DELINQ-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7550'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                         
      *==============================================================*  04450000
      *7600-START-FCSJC01                                            *          
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
I01687*==============================================================*  04450000
I01687 7710-SET-LPC-DT-SEB.                                             
I01687*==============================================================*  04450000
I01687*                                                                         
I01687      EXEC SQL                                                    
I01687           SELECT
              DATEADD( DAY, -:WS-DAYS-TO-MINUS, IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-INPUT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-INPUT
              ) <> 0) OR (LEN(:WS-DATE-INPUT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-INPUT
              ), CONVERT(DATE, :WS-DATE-INPUT) ) )
            INTO
              :WS-OUT-DATE            
I01687      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SET :WS-OUT-DATE    = DATE(:WS-DATE-INPUT) -                   
MFA-TR*                               :WS-DAYS-TO-MINUS DAYS                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687*                                                                         
I01687     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
I01687*                                                                 08229356
I01687     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
I01687         NEXT SENTENCE                                            
I01687     ELSE                                                         
I01687         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
I01687         MOVE '7710'                  TO ACTIVE-PARAGRAPH         
I01687         MOVE 'SET'                   TO ABEND-FUNCTION           
I01687         MOVE 'WS-DATE-INPUT'         TO TABLE-ELEMENT-1          
I01687         MOVE WS-DATE-INPUT           TO HOSTVAR-ELEMENT-1        
I01687         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
I01687         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
I01687     END-IF.                                                      
I01687*                                                                         
I01687 7710-EXIT.                                                       
I01687      EXIT.                                                       
I01687*                                                                         
                                                                        
      *==============================================================*  04450000
       7720-SET-CRED-FORECAST.                                          
      *==============================================================*  04450000
      *                                                                         
            EXEC SQL                                                    
                 SELECT
              DATEADD( DAY, :WS-DAYS-TO-ADD, IIF(TRY_CONVERT(DATE, 
                                                         :WS-DATE-INPUT
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-INPUT
              ) <> 0) OR (LEN(:WS-DATE-INPUT) <> 10), CIS.CHAR2DATE(
                                                         :WS-DATE-INPUT
              ), CONVERT(DATE, :WS-DATE-INPUT) ) )
            INTO
              :WS-OUT-DATE              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SET :WS-OUT-DATE    = DATE(:WS-DATE-INPUT) +                   
MFA-TR*                               :WS-DAYS-TO-ADD DAYS                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08229356
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7720'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE 'WS-DATE-INPUT'         TO TABLE-ELEMENT-1          
               MOVE WS-DATE-INPUT           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*  04450000
       7725-VERIFY-BUSINESS-DAY.                                        
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) BUSINESS_DAY_DT                                    
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                    
               WHERE BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )            
               ORDER BY BUSINESS_DAY_DT                                 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUSINESS_DAY_DT                                            
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS                                          
MFA-TR*        WHERE BUSINESS_DAY_DT >= :WS-NEW-BUSINESS-DAY                    
MFA-TR*        ORDER BY BUSINESS_DAY_DT                                         
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7725                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '7725'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7725-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       7730-GET-NEXT-BUSINESS-DAY.                                      
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MIN(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT >                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) - 1 + 
                                                         :WS-NO-OF-DAYS 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MIN(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT >                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) - 1 + :WS-NO-OF-DAYS         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAYS             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '7730'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAYS           TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       7740-GET-PREV-BUSINESS-DAY.                                      
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MAX(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT <                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) + 1 - 
                                                         :WS-NO-OF-DAYS 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MAX(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT <                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) + 1 - :WS-NO-OF-DAYS         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAYS             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '7740'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAYS           TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I01687*==============================================================*  04450000
I01687 7750-VERIFY-PREV-BUSINESS-DAY.                                   
I01687*==============================================================*  04450000
I01687*                                                                         
I01687     EXEC SQL                                                     
I01687        SELECT TOP(1) BUSINESS_DAY_DT                                    
I01687          INTO :WS-NEW-BUSINESS-DAY                               
I01687          FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                    
I01687         WHERE BUSINESS_DAY_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )            
I01687         ORDER BY BUSINESS_DAY_DT DESC                            
I01687                                       
I01687                                                      
I01687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUSINESS_DAY_DT                                            
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS                                          
MFA-TR*        WHERE BUSINESS_DAY_DT <= :WS-NEW-BUSINESS-DAY                    
MFA-TR*        ORDER BY BUSINESS_DAY_DT DESC                                    
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01687*                                                                         
I01687     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
I01687     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I01687        CONTINUE                                                  
I01687     ELSE                                                         
I01687        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
I01687        MOVE SQLCODE                 TO ABEND-SQLCODE             
I01687        MOVE '7750'                  TO ACTIVE-PARAGRAPH          
I01687        MOVE 'SELECT'                TO ABEND-FUNCTION            
I01687        MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
I01687        MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
I01687        MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
I01687        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I01687        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I01687     END-IF.                                                      
I01687*                                                                         
I01687 7750-EXIT.                                                       
I01687     EXIT.                                                        
I01687*                                                                         
I01687*==============================================================*  04450000
       7950-GET-THIRD-PTY-EXCEPTION.                                    
      *==============================================================*  04450000
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-THIRD-PTY-EXCEPTION                           
                 FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                      
                WHERE TABLE_NA = 'THIRD_PTY_RD_EXCPN'                   
                  AND COMPANY_NO = '01'                                 
                  AND PROGRAM_ID = 'PCSSF047'                           
                  AND COLUMN_NA  = :UV-COLUMN-NA                        
                  AND CODE_VALUE = :UV-CODE-VALUE                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08510000
MFA-TR*        SELECT 'Y'                                               08342056
MFA-TR*          INTO :WS-THIRD-PTY-EXCEPTION                           08343156
MFA-TR*          FROM CSS_CODE_VALUE                                    08344056
MFA-TR*         WHERE TABLE_NA = 'THIRD_PTY_RD_EXCPN'                   08344056
MFA-TR*           AND COMPANY_NO = '01'                                 08344056
MFA-TR*           AND PROGRAM_ID = 'PCSSF047'                           08344056
MFA-TR*           AND COLUMN_NA  = :UV-COLUMN-NA                        08344056
MFA-TR*           AND CODE_VALUE = :UV-CODE-VALUE                       08344056
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                    08580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7950'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CODE_VALUE'        TO TABLE-1                  
               MOVE 'COLUMN_NA'             TO TABLE-ELEMENT-1          
               MOVE UV-COLUMN-NA            TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08380056
      *================================================================*08320056
       7960-GET-BILL-REVENUE-MONTH.                                     
      *================================================================*08320056
      * CHECK GIVEN REV MONTH ALREADY EXISTS IN DB                      08340056
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT TOP(1) BN.REVENUE_MONTH                                  
                 INTO :WS-BN-REV-MONTH                                  
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE BN.BILL_CYCLE     = '01'                          
                ORDER BY REVENUE_MONTH DESC                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08510000
MFA-TR*        SELECT BN.REVENUE_MONTH                                  08342056
MFA-TR*          INTO :WS-BN-REV-MONTH                                  08343156
MFA-TR*          FROM CSS_BILL_WINDOW BN                                08344056
MFA-TR*         WHERE BN.BILL_CYCLE     = '01'                          08344056
MFA-TR*         ORDER BY REVENUE_MONTH DESC                                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7960                                                    
MFA-TR*    END-EXEC.                                                    08580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7960'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILL_WINDOW'       TO TABLE-1                  
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-1          
               MOVE BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08380056
      *================================================================*08320056
       7970-GET-READ-REVENUE-MONTH.                                     
      *================================================================*08320056
      * CHECK GIVEN REV MONTH ALREADY EXISTS IN DB                      08340056
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT TOP(1) RW.REVENUE_MONTH                                  
                 INTO :WS-RW-REV-MONTH                                  
                 FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                  
                WHERE RW.READ_CYCLE     = '01'                          
                ORDER BY REVENUE_MONTH DESC                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08510000
MFA-TR*        SELECT RW.REVENUE_MONTH                                  08342056
MFA-TR*          INTO :WS-RW-REV-MONTH                                  08343156
MFA-TR*          FROM CSS_READ_WINDOW RW                                08344056
MFA-TR*         WHERE RW.READ_CYCLE     = '01'                          08344056
MFA-TR*         ORDER BY REVENUE_MONTH DESC                                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7970                                                    
MFA-TR*    END-EXEC.                                                    08580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7970'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_READ_WINDOW'       TO TABLE-1                  
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-1          
               MOVE RW-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7970-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08380056
      *================================================================*08320056
       7990-GET-CRED-REVENUE-MONTH.                                     
      *================================================================*08320056
      *                                                                 08340056
           EXEC SQL                                                     
               SELECT TOP(1) REVENUE_MONTH                                     
                 INTO :WS-REV-MONTH-CM                                  
                 FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                
                WHERE CM.COMPANY_NO  = '01'                             
                ORDER BY REVENUE_MONTH DESC                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08510000
MFA-TR*        SELECT REVENUE_MONTH                                     08342056
MFA-TR*          INTO :WS-REV-MONTH-CM                                  08343156
MFA-TR*          FROM CSS_CRED_FORECAST CM                              08344056
MFA-TR*         WHERE CM.COMPANY_NO  = '01'                             08344056
MFA-TR*         ORDER BY REVENUE_MONTH DESC                                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7990                                                    
MFA-TR*    END-EXEC.                                                    08580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 08610000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7990'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_FORECAST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08350156
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08380056
      *================================================================*08320056
       8100-SEND-RESULT.                                                
      *================================================================*08320056
      *                                                                         
           ADD +1                           TO CTR-ROWS.                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21622000
      *================================================================*08320056
       8200-INSERT-CSS-READ-WINDOW.                                     
      *================================================================*08320056
      *                                                                 09560000
           EXEC SQL                                                     
               INSERT                                                   
                   INTO CSS_READ_WINDOW                                 
                          ( DATE_MTR_RD_XTRCT                           
                           ,READ_CYCLE                                  
                           ,OPTIMUM_READ_DATE                           
                           ,REVENUE_MONTH                               
                           ,UT_READ_CYCLE                               
                           ,THIRD_PTY_READ_DT)                          
                   VALUES ( IIF(TRY_CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )                       
                           ,:RW-READ-CYCLE                              
                           ,IIF(TRY_CONVERT(DATE, :RW-OPTIMUM-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :RW-OPTIMUM-READ-DATE
              ) <> 0) OR (LEN(:RW-OPTIMUM-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:RW-OPTIMUM-READ-DATE
              ), CONVERT(DATE, :RW-OPTIMUM-READ-DATE) )                       
                           ,:RW-REVENUE-MONTH                           
                           ,:RW-UT-READ-CYCLE                           
                           ,IIF(TRY_CONVERT(DATE, :RW-THIRD-PTY-READ-DT 
                                                  :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :RW-THIRD-PTY-READ-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:RW-THIRD-PTY-READ-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:RW-THIRD-PTY-READ-DT :WS-NULL-1
              ), CONVERT(DATE, :RW-THIRD-PTY-READ-DT :WS-NULL-1) ))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09570000
MFA-TR*        INSERT                                                   09580000
MFA-TR*            INTO CSS_READ_WINDOW                                 09590037
MFA-TR*                   ( DATE_MTR_RD_XTRCT                           09600037
MFA-TR*                    ,READ_CYCLE                                  09610037
MFA-TR*                    ,OPTIMUM_READ_DATE                           09620039
MFA-TR*                    ,REVENUE_MONTH                               09620039
MFA-TR*                    ,UT_READ_CYCLE                                       
MFA-TR*                    ,THIRD_PTY_READ_DT)                                  
MFA-TR*            VALUES ( :RW-DATE-MTR-RD-XTRCT                       09650037
MFA-TR*                    ,:RW-READ-CYCLE                              09660037
MFA-TR*                    ,:RW-OPTIMUM-READ-DATE                       09670039
MFA-TR*                    ,:RW-REVENUE-MONTH                           09670039
MFA-TR*                    ,:RW-UT-READ-CYCLE                                   
MFA-TR*                    ,:RW-THIRD-PTY-READ-DT:WS-NULL-1)                    
MFA-TR*    END-EXEC.                                                    09700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09710000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 09730000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_READ_WINDOW'       TO TABLE-1                  
               MOVE 'DATE_MTR_RD_XTRCT'     TO TABLE-ELEMENT-1          
               MOVE 'READ_CYCLE'            TO TABLE-ELEMENT-2          
               MOVE 'OPTIMUM_READ_DATE'     TO TABLE-ELEMENT-3          
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-4          
               MOVE RW-DATE-MTR-RD-XTRCT    TO HOSTVAR-ELEMENT-1        
               MOVE RW-READ-CYCLE           TO HOSTVAR-ELEMENT-2        
               MOVE RW-OPTIMUM-READ-DATE    TO HOSTVAR-ELEMENT-3        
               MOVE WS-REVENUE-MONTH        TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09870000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8250-INSERT-CSS-READ-WINDOW.                                     
      *================================================================*        
      *                                                                 09560000
MAN006     PERFORM VARYING MFA-COUNT FROM 1 BY 1 UNTIL MFA-COUNT = 40
MAN006       MOVE RW-REVENUE-MONTH TO MFA-RW-REVENUE-MONTH(MFA-COUNT)
MAN006     END-PERFORM

MSQ009     MOVE 21 TO MSQ009-FOR-21
MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
      *
           EXEC SQL                                                     
               FOR :MSQ009-FOR-21
              INSERT INTO CSS_READ_WINDOW
              ( DATE_MTR_RD_XTRCT                           
                           ,READ_CYCLE                                  
                           ,OPTIMUM_READ_DATE                           
                           ,REVENUE_MONTH                               
                           ,UT_READ_CYCLE                               
                           ,THIRD_PTY_READ_DT)
              VALUES ( IIF(TRY_CONVERT(DATE, :TAB-READ-XTRACT-DT
              ) IS NULL OR (PATINDEX('%.%', :TAB-READ-XTRACT-DT
              ) <> 0) OR (LEN(:TAB-READ-XTRACT-DT
              ) <> 10), CIS.CHAR2DATE(:TAB-READ-XTRACT-DT
              ), CONVERT(DATE, :TAB-READ-XTRACT-DT) )                         
                           ,:TAB-CYCLE                                  
                           ,IIF(TRY_CONVERT(DATE, :TAB-OPTIMUM-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :TAB-OPTIMUM-READ-DT
              ) <> 0) OR (LEN(:TAB-OPTIMUM-READ-DT
              ) <> 10), CIS.CHAR2DATE(:TAB-OPTIMUM-READ-DT
              ), CONVERT(DATE, :TAB-OPTIMUM-READ-DT) )                        
MAN006*                    ,:RW-REVENUE-MONTH                           09670039
MAN006                     ,:MFA-RW-REVENUE-MONTH
                           ,:TAB-UT-READ-CYCLE                          
                           ,IIF(TRY_CONVERT(DATE, :TAB-3RD-PTY-READ-DT 
                                                  :TAB-3RD-PTY-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :TAB-3RD-PTY-READ-DT 
                                                  :TAB-3RD-PTY-NULL-IND
              ) <> 0) OR (LEN(:TAB-3RD-PTY-READ-DT 
                                                  :TAB-3RD-PTY-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:TAB-3RD-PTY-READ-DT 
                                                  :TAB-3RD-PTY-NULL-IND
              ), CONVERT(DATE, :TAB-3RD-PTY-READ-DT 
                                                  :TAB-3RD-PTY-NULL-IND
              ) ))
              
                                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09570000
MFA-TR*        INSERT                                                   09580000
MFA-TR*            INTO CSS_READ_WINDOW                                 09590037
MFA-TR*                   ( DATE_MTR_RD_XTRCT                           09600037
MFA-TR*                    ,READ_CYCLE                                  09610037
MFA-TR*                    ,OPTIMUM_READ_DATE                           09620039
MFA-TR*                    ,REVENUE_MONTH                               09620039
MFA-TR*                    ,UT_READ_CYCLE                                       
MFA-TR*                    ,THIRD_PTY_READ_DT)                                  
MFA-TR*            VALUES ( :TAB-READ-XTRACT-DT                         09650037
MFA-TR*                    ,:TAB-CYCLE                                  09660037
MFA-TR*                    ,:TAB-OPTIMUM-READ-DT                        09670039
MFA-TR*                    ,:RW-REVENUE-MONTH                           09670039
MFA-TR*                    ,:MFA-RW-REVENUE-MONTH
MFA-TR*                    ,:TAB-UT-READ-CYCLE                                  
MFA-TR*                    ,:TAB-3RD-PTY-READ-DT:TAB-3RD-PTY-NULL-IND)          
MFA-TR*            FOR 21 ROWS                                                  
MFA-TR*            ATOMIC                                                       
MFA-TR*    END-EXEC.                                                    09700000

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09710000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 09730000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8250'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_READ_WINDOW'       TO TABLE-1                  
               MOVE 'DATE_MTR_RD_XTRCT'     TO TABLE-ELEMENT-1          
               MOVE 'READ_CYCLE'            TO TABLE-ELEMENT-2          
               MOVE 'OPTIMUM_READ_DATE'     TO TABLE-ELEMENT-3          
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-4          
               MOVE TAB-READ-XTRACT-DT (1)  TO HOSTVAR-ELEMENT-1        
               MOVE TAB-CYCLE (1)           TO HOSTVAR-ELEMENT-2        
               MOVE TAB-OPTIMUM-READ-DT (1) TO HOSTVAR-ELEMENT-3        
               MOVE RW-REVENUE-MONTH        TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09870000
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09900000
      *================================================================*        
       8300-INSERT-CSS-BILL-WINDOW.                                     
      *================================================================*        
      *                                                                 10466057
MAN006     PERFORM VARYING MFA-COUNT FROM 1 BY 1 UNTIL MFA-COUNT = 125
MAN006       MOVE BN-REVENUE-MONTH TO MFA-BN-REVENUE-MONTH(MFA-COUNT)
MAN006     END-PERFORM

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
      *
           EXEC SQL                                                     
               FOR :BILL-SUB
              INSERT INTO CSS_BILL_WINDOW
              ( DATE_EXTRACT                                
                           ,BILL_CYCLE                                  
                           ,CODE_BILL_COND                              
                           ,REVENUE_MONTH                               
                           ,REV_CALC_CYCLE)
              VALUES ( IIF(TRY_CONVERT(DATE, :TAB-BN-XTRACT-DT
              ) IS NULL OR (PATINDEX('%.%', :TAB-BN-XTRACT-DT
              ) <> 0) OR (LEN(:TAB-BN-XTRACT-DT) <> 10), CIS.CHAR2DATE(
                                                      :TAB-BN-XTRACT-DT
              ), CONVERT(DATE, :TAB-BN-XTRACT-DT) )                           
                           ,:TAB-BN-CYCLE                               
                           ,:TAB-BN-BILL-COND                           
MAN006*                    ,:BN-REVENUE-MONTH                           10470057
MAN006                     ,:MFA-BN-REVENUE-MONTH
                           ,:TAB-BN-REV-CALC-CYCLE)
              
                                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10467057
MFA-TR*        INSERT                                                   10468057
MFA-TR*            INTO CSS_BILL_WINDOW                                 10469057
MFA-TR*                   ( DATE_EXTRACT                                10469157
MFA-TR*                    ,BILL_CYCLE                                  10469357
MFA-TR*                    ,CODE_BILL_COND                              10469457
MFA-TR*                    ,REVENUE_MONTH                               10469557
MFA-TR*                    ,REV_CALC_CYCLE)                                     
MFA-TR*            VALUES ( :TAB-BN-XTRACT-DT                           10469657
MFA-TR*                    ,:TAB-BN-CYCLE                               10469857
MFA-TR*                    ,:TAB-BN-BILL-COND                           10469957
MFA-TR*                    ,:BN-REVENUE-MONTH                           10470057
MFA-TR*                    ,:MFA-BN-REVENUE-MONTH
MFA-TR*                    ,:TAB-BN-REV-CALC-CYCLE)                             
MFA-TR*            FOR :BILL-SUB  ROWS                                          
MFA-TR*            ATOMIC                                                       
MFA-TR*    END-EXEC.                                                    10470157

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10470257
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10470457
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILL_WINDOW'       TO TABLE-1                  
               MOVE 'DATE_EXTRACT'          TO TABLE-ELEMENT-1          
               MOVE 'BILL_CYCLE'            TO TABLE-ELEMENT-2          
               MOVE 'REVENUE_MONTH'         TO TABLE-ELEMENT-3          
               MOVE TAB-BN-XTRACT-DT (1)    TO HOSTVAR-ELEMENT-1        
               MOVE TAB-BN-CYCLE (1)        TO HOSTVAR-ELEMENT-2        
               MOVE WS-INPUT-REVENUE-MONTH  TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10471857
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10472257
      *================================================================*        
       8400-INSERT-CRED-FORECAST.                                       

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :WS-INSERT-COUNT
              INSERT INTO CSS_CRED_FORECAST
              (COMPANY_NO                                          
                   ,REG_GROUP_CD                                        
                   ,REVENUE_MONTH                                       
                   ,BILL_DT                                             
                   ,BILL_CYCLE                                          
                   ,CREDIT_GROUP                                        
                   ,CREDIT_GROUP_ID                                     
                   ,CRED_ACCT_TYPE_CD                                   
                   ,CRED_FORECAST_CD                                    
                   ,ARREARS_DUE_DT                                      
                   ,CURR_CHG_DUE_DT                                     
                   ,DNP_NOTICE_DUE_DT                                   
                   ,DNP_NOTICE_MAIL_DT                                  
                   ,DNP_REVIEW_DT                                       
                   ,DNP_DT                                              
                   ,IVR_CALL_DT                                         
                   ,AVOID_LPC_DT                                        
                   ,NONUTIL_WQ_DT                                       
                   ,CRED_BUR_RPT_DT                                     
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID)
              VALUES (:WS-COMPANY-NO                                      
                   ,:WS-REG-GROUP-CD                                    
                   ,:WS-REVENUE-MNTH                                    
                   ,IIF(TRY_CONVERT(DATE, :WS-BILL-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-DT) <> 0) OR (LEN(
                                                            :WS-BILL-DT
              ) <> 10), CIS.CHAR2DATE(:WS-BILL-DT), CONVERT(DATE, 
                                                            :WS-BILL-DT
              ) )                                         
                   ,:WS-BILL-CYCLE                                      
                   ,:WS-CREDIT-GROUP                                    
                   ,:WS-CREDIT-GROUP-ID                                 
                   ,:WS-CRED-ACCT-TYPE-CD                               
                   ,:WS-CRED-FORECAST-CD                                
                   ,IIF(TRY_CONVERT(DATE, :WS-ARREARS-DUE-DATE 
                                          :WS-ARRERS-DUE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-ARREARS-DUE-DATE 
                                                :WS-ARRERS-DUE-NULL-IND
              ) <> 0) OR (LEN(:WS-ARREARS-DUE-DATE 
                                                :WS-ARRERS-DUE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-ARREARS-DUE-DATE 
                                                :WS-ARRERS-DUE-NULL-IND
              ), CONVERT(DATE, :WS-ARREARS-DUE-DATE 
                                                :WS-ARRERS-DUE-NULL-IND
              ) )    
                   ,IIF(TRY_CONVERT(DATE, :WS-CURR-CHG-DUE-DATE 
                                          :WS-CURR-CHG-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-CHG-DUE-DATE 
                                                  :WS-CURR-CHG-NULL-IND
              ) <> 0) OR (LEN(:WS-CURR-CHG-DUE-DATE 
                                                  :WS-CURR-CHG-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-CHG-DUE-DATE 
                                                  :WS-CURR-CHG-NULL-IND
              ), CONVERT(DATE, :WS-CURR-CHG-DUE-DATE 
                                                  :WS-CURR-CHG-NULL-IND
              ) )      
                   ,IIF(TRY_CONVERT(DATE, :WS-DNP-NOTICE-DUE-DATE 
                                          :WS-DNP-NOTICE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-DNP-NOTICE-DUE-DATE 
                                                :WS-DNP-NOTICE-NULL-IND
              ) <> 0) OR (LEN(:WS-DNP-NOTICE-DUE-DATE 
                                                :WS-DNP-NOTICE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-DNP-NOTICE-DUE-DATE 
                                                :WS-DNP-NOTICE-NULL-IND
              ), CONVERT(DATE, :WS-DNP-NOTICE-DUE-DATE 
                                                :WS-DNP-NOTICE-NULL-IND
              ) )    
                   ,IIF(TRY_CONVERT(DATE, :WS-DNP-NOTICE-MAIL-DATE 
                                          :WS-DNP-MAIL-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-DNP-NOTICE-MAIL-DATE 
                                                  :WS-DNP-MAIL-NULL-IND
              ) <> 0) OR (LEN(:WS-DNP-NOTICE-MAIL-DATE 
                                                  :WS-DNP-MAIL-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-DNP-NOTICE-MAIL-DATE 
                                                  :WS-DNP-MAIL-NULL-IND
              ), CONVERT(DATE, :WS-DNP-NOTICE-MAIL-DATE 
                                                  :WS-DNP-MAIL-NULL-IND
              ) )      
                   ,IIF(TRY_CONVERT(DATE, :WS-DNP-REVIEW-DATE 
                                          :WS-DNP-REV-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-DNP-REVIEW-DATE 
                                                   :WS-DNP-REV-NULL-IND
              ) <> 0) OR (LEN(:WS-DNP-REVIEW-DATE :WS-DNP-REV-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-DNP-REVIEW-DATE 
                                                   :WS-DNP-REV-NULL-IND
              ), CONVERT(DATE, :WS-DNP-REVIEW-DATE :WS-DNP-REV-NULL-IND
              ) )       
                   ,IIF(TRY_CONVERT(DATE, :WS-DNP-DATE 
                                          :WS-DNP-DATE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-DNP-DATE 
                                                  :WS-DNP-DATE-NULL-IND
              ) <> 0) OR (LEN(:WS-DNP-DATE :WS-DNP-DATE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-DNP-DATE 
                                                  :WS-DNP-DATE-NULL-IND
              ), CONVERT(DATE, :WS-DNP-DATE :WS-DNP-DATE-NULL-IND) )      
                   ,IIF(TRY_CONVERT(DATE, :WS-IVR-CALL-DATE 
                                          :WS-IVR-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-IVR-CALL-DATE 
                                                    :WS-IVR-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-IVR-CALL-DATE :WS-IVR-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-IVR-CALL-DATE 
                                                    :WS-IVR-DT-NULL-IND
              ), CONVERT(DATE, :WS-IVR-CALL-DATE :WS-IVR-DT-NULL-IND) )        
                   ,IIF(TRY_CONVERT(DATE, :WS-AVOID-LPC-DATE 
                                          :WS-LPC-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-AVOID-LPC-DATE 
                                                    :WS-LPC-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-AVOID-LPC-DATE :WS-LPC-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-AVOID-LPC-DATE 
                                                    :WS-LPC-DT-NULL-IND
              ), CONVERT(DATE, :WS-AVOID-LPC-DATE :WS-LPC-DT-NULL-IND
              ) )        
                   ,IIF(TRY_CONVERT(DATE, :WS-NONUTIL-WQ-DATE 
                                          :WS-WQ-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-NONUTIL-WQ-DATE 
                                                     :WS-WQ-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-NONUTIL-WQ-DATE :WS-WQ-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-NONUTIL-WQ-DATE 
                                                     :WS-WQ-DT-NULL-IND
              ), CONVERT(DATE, :WS-NONUTIL-WQ-DATE :WS-WQ-DT-NULL-IND
              ) )         
                   ,IIF(TRY_CONVERT(DATE, :WS-CRED-BUR-RPT-DATE 
                                          :WS-BUR-RPT-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-CRED-BUR-RPT-DATE 
                                                :WS-BUR-RPT-DT-NULL-IND
              ) <> 0) OR (LEN(:WS-CRED-BUR-RPT-DATE 
                                                :WS-BUR-RPT-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-CRED-BUR-RPT-DATE 
                                                :WS-BUR-RPT-DT-NULL-IND
              ), CONVERT(DATE, :WS-CRED-BUR-RPT-DATE 
                                                :WS-BUR-RPT-DT-NULL-IND
              ) )    
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,'SYSTEM')
              
                                                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT                                                           
MFA-TR*        INTO CSS_CRED_FORECAST                                           
MFA-TR*            (COMPANY_NO                                                  
MFA-TR*            ,REG_GROUP_CD                                                
MFA-TR*            ,REVENUE_MONTH                                               
MFA-TR*            ,BILL_DT                                                     
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,CREDIT_GROUP                                                
MFA-TR*            ,CREDIT_GROUP_ID                                             
MFA-TR*            ,CRED_ACCT_TYPE_CD                                           
MFA-TR*            ,CRED_FORECAST_CD                                            
MFA-TR*            ,ARREARS_DUE_DT                                              
MFA-TR*            ,CURR_CHG_DUE_DT                                             
MFA-TR*            ,DNP_NOTICE_DUE_DT                                           
MFA-TR*            ,DNP_NOTICE_MAIL_DT                                          
MFA-TR*            ,DNP_REVIEW_DT                                               
MFA-TR*            ,DNP_DT                                                      
MFA-TR*            ,IVR_CALL_DT                                                 
MFA-TR*            ,AVOID_LPC_DT                                                
MFA-TR*            ,NONUTIL_WQ_DT                                               
MFA-TR*            ,CRED_BUR_RPT_DT                                             
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID)                                         
MFA-TR*     VALUES (:WS-COMPANY-NO                                              
MFA-TR*            ,:WS-REG-GROUP-CD                                            
MFA-TR*            ,:WS-REVENUE-MNTH                                            
MFA-TR*            ,:WS-BILL-DT                                                 
MFA-TR*            ,:WS-BILL-CYCLE                                              
MFA-TR*            ,:WS-CREDIT-GROUP                                            
MFA-TR*            ,:WS-CREDIT-GROUP-ID                                         
MFA-TR*            ,:WS-CRED-ACCT-TYPE-CD                                       
MFA-TR*            ,:WS-CRED-FORECAST-CD                                        
MFA-TR*            ,:WS-ARREARS-DUE-DATE     :WS-ARRERS-DUE-NULL-IND            
MFA-TR*            ,:WS-CURR-CHG-DUE-DATE    :WS-CURR-CHG-NULL-IND              
MFA-TR*            ,:WS-DNP-NOTICE-DUE-DATE  :WS-DNP-NOTICE-NULL-IND            
MFA-TR*            ,:WS-DNP-NOTICE-MAIL-DATE :WS-DNP-MAIL-NULL-IND              
MFA-TR*            ,:WS-DNP-REVIEW-DATE      :WS-DNP-REV-NULL-IND               
MFA-TR*            ,:WS-DNP-DATE             :WS-DNP-DATE-NULL-IND              
MFA-TR*            ,:WS-IVR-CALL-DATE        :WS-IVR-DT-NULL-IND                
MFA-TR*            ,:WS-AVOID-LPC-DATE       :WS-LPC-DT-NULL-IND                
MFA-TR*            ,:WS-NONUTIL-WQ-DATE      :WS-WQ-DT-NULL-IND                 
MFA-TR*            ,:WS-CRED-BUR-RPT-DATE    :WS-BUR-RPT-DT-NULL-IND            
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,'SYSTEM')                                                   
MFA-TR*            FOR :WS-INSERT-COUNT  ROWS                                   
MFA-TR*            ATOMIC                                                       
MFA-TR*     END-EXEC.                                                           

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '8400'                 TO ACTIVE-PARAGRAPH         
                MOVE 'INSERT'               TO ABEND-FUNCTION           
                MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                  
                MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1          
                MOVE WS-REVENUE-MONTH-CM    TO HOSTVAR-ELEMENT-1        
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
            END-IF.                                                     
      *                                                                         
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       8500-DELETE-CRED-FORECAST.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               DELETE                                                   
               FROM CSS_CRED_FORECAST                                   
               WHERE REVENUE_MONTH    = :WS-REV-MONTH-CM                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CRED_FORECAST'      TO TABLE-1                  
              MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
              MOVE WS-REV-MONTH-CM          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *21624000
      *================================================================*        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     20620000
               INCLUDE CPD00321                                         20630000
           END-EXEC.                                                    20640000
      *                                                                         
      *================================================================*        
      *9900-ABEND.                                                     *        
      *================================================================*        
      *                                                                         
       9900-ABEND.                                                      
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
