       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04579.                                         
       DATE-WRITTEN.  01/26/13.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE THE WORKSCHEDULE FOR       *        
      *   PANEL274 AND PANEL300.                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PCR635*  01/26/13  NC94746    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-WORK-CUR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-WSCH-CUR1  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04579'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CL - CSS_CRED_COLL                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    RW - CSS_READ_WINDOW                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    BN - CSS_BILL_WINDOW                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
P00399*    CSS_COMPANY C7                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
P00399*    CSS_HOLIDAY J8                                                       
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
T34822******************************************************************        
T34822*    CM - CSS_CRED_FORECAST                                               
T34822******************************************************************        
T34822*                                                                         
T34822     EXEC SQL                                                             
T34822          INCLUDE TBCRFCST                                                
T34822     END-EXEC.                                                            
T34822*                                                                         
P00399***************************************************************** 00010000
P00399*  CWSX0010            WS ABEND WORK AREA                       * 00020000
P00399***************************************************************** 00080000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
P00399*****************************************************************         
P00399*  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
P00399*****************************************************************         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04579'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
      *                                                                         
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACES.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-R1                  PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-R2                  PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26)                        
                                            VALUE 'SESSION.CSR04579_R2'.
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
      *                                                                         
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-R1.                                      
             10 S-RETURN-CODE-R1             PIC S9(9) COMP VALUE +0.   
             10 S-APPL-RETURN-CODE-R1        PIC S9(9) COMP VALUE +0.   
             10 S-COMPANY-NO                 PIC X(02) VALUE SPACES.    
             10 S-CREDIT-GROUP               PIC X(01) VALUE SPACES.    
             10 S-BILL-YEAR-START            PIC X(04) VALUE SPACES.    
             10 S-BILL-MONTH-START           PIC X(02) VALUE SPACES.    
             10 S-BILL-YEAR-END              PIC X(04) VALUE SPACES.    
             10 S-BILL-MONTH-END             PIC X(02) VALUE SPACES.    
             10 S-BILL-YEAR                  PIC X(04) VALUE SPACES.    
             10 S-BILL-MONTH                 PIC X(02) VALUE SPACES.    
             10 S-CREDIT-GROUP-ID-DF         PIC X(01) VALUE SPACES.    
             10 S-CREDIT-ACCT-TYPE-DF        PIC X(01) VALUE SPACES.    
             10 S-REG-GROUP-CD-DF            PIC X(04) VALUE SPACES.    
          05 GTT-RETURN-FIELDS-R2.                                      
             10 S-RETURN-CODE-R2             PIC S9(9) COMP VALUE +0.   
             10 S-BILL-CYCLE                 PIC X(02) VALUE SPACES.    
             10 S-REG-GROUP-CD               PIC X(04) VALUE SPACES.    
             10 S-CREDIT-GROUP-ID            PIC X(01) VALUE SPACES.    
             10 S-CREDIT-ACCT-TYPE           PIC X(01) VALUE SPACES.    
             10 S-READ-DATE                  PIC X(10) VALUE SPACES.    
             10 S-BILL-FROM                  PIC X(10) VALUE SPACES.    
             10 S-BILL-TO                    PIC X(10) VALUE SPACES.    
             10 S-BILL-DATE                  PIC X(10) VALUE SPACES.    
             10 S-MAIL-DATE                  PIC X(10) VALUE SPACES.    
             10 S-BILL-DUE-DATE              PIC X(10) VALUE SPACES.    
             10 S-AVOID-LPC-DATE             PIC X(10) VALUE SPACES.    
             10 S-FIRST-NOTICE-DATE          PIC X(10) VALUE SPACES.    
             10 S-SECOND-NOTICE-DATE         PIC X(10) VALUE SPACES.    
             10 S-DNP-DATE                   PIC X(10) VALUE SPACES.    
             10 S-IVR-DATE                   PIC X(10) VALUE SPACES.    
             10 S-THIRD-PTY-READ-DT          PIC X(10) VALUE SPACES.    
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88  CSR-DATABASE             VALUE 1.                    
               88  SEB-DATABASE             VALUE 2.                    
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8)   VALUE 'CSR04579'.
           05  WS-SQLSTATE                  PIC X(5)   VALUE SPACES.    
           05  WS-NEXT-REV-MO               PIC S9(6)  COMP-3 VALUE +0. 
           05  WS-BILL-CYCLE                PIC X(02)  VALUE SPACES.    
           05  WS-BILL-CYCLE-NO             REDEFINES  WS-BILL-CYCLE    
                                            PIC 9(02).                  
           05  WS-CREDIT-GROUP              PIC X(01)  VALUE SPACES.    
           05  WS-COMPANY-NO                PIC X(02)  VALUE SPACES.    
           05  WS-MIN-DATE-EXTRACT          PIC X(10)  VALUE SPACES.    
           05  WS-MAX-DATE-EXTRACT          PIC X(10)  VALUE SPACES.    
           05  WS-TARGET-DATE               PIC X(10)  VALUE SPACES.    
           05  WS-NUM-COND                  PIC S9(04) COMP   VALUE +0. 
           05  WS-CFCAST-ROW-COUNT          PIC S9(04) COMP   VALUE +0. 
           05  WS-INDEX                     PIC S9(04) COMP-3 VALUE +0. 
           05  WS-NULL-1                    PIC S9(4)  COMP.            
           05  WS-NULL-2                    PIC S9(4)  COMP.            
           05  WS-NULL-3                    PIC S9(4)  COMP.            
           05  WS-ADJ-DAY                   PIC S9(9)  COMP.            
           05  WS-WORK-DATE                 PIC X(10).                  
           05  WS-HOLIDAY-FL                PIC X(01)  VALUE 'N'.       
           05  WS-HOLIDAY-CNT               PIC S9(04) COMP VALUE 0.    
           05  WS-HOLD-DATE                 PIC X(10).                  
           05  WS-DELINQ-CODE               PIC X(20).                  
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.          
           05  WS-WEEK-DAY                  PIC S9(04) COMP VALUE 0.    
           05  WS-INDX                      PIC S9(04) COMP.            
           05  WS-SEARCH-DATE               PIC X(10)  VALUE SPACES.    
           05  WS-HOLIDAY-TABLE.                                        
               10  WS-HOLIDAY-DT            PIC X(10)                   
                    OCCURS 200 TIMES                                    
                    INDEXED BY WS-HOLIDAY-INDX.                         
           05  WS-DATE-YYYY-MM-DD.                                      
               10  WS-DATE-YYYY             PIC X(04) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  WS-DATE-MM               PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  WS-DATE-DD               PIC X(02) VALUE SPACES.     
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM              PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  WS-DATE2-DD              PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  WS-DATE2-YYYY            PIC X(04) VALUE SPACES.     
      *                                                                         
       01  WS-DELINQUENCY-WS USAGE COMP-3.                              
           05  WS-DAY-TOTAL-DUE          PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-DUE                PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-DNP                PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-SECOND-MAIL        PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-SECOND-FIELD       PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-EXC-IVR-DATE       PIC S9(5) COMP-3 VALUE +0.     
           05  WS-DAY-BTOTALDUE          PIC S9(5) COMP-3 VALUE +0.     
      *                                                                         
       01 WS-SCH-VARIABLES.                                             
          05 WS-CUR-REV-MONTH            PIC S9(6)V COMP-3 VALUE +0.    
          05 WS-NXT-REV-MONTH            PIC S9(6)V COMP-3 VALUE +0.    
          05 WS-MIN-REV-MONTH            PIC S9(6)V COMP-3 VALUE +0.    
          05 WS-MAX-REV-MONTH            PIC S9(6)V COMP-3 VALUE +0.    
          05 WS-NEW-BUSINESS-DAY         PIC X(10)  VALUE SPACES.       
          05 WS-NO-OF-DAYS               PIC S9(09) COMP VALUE 1.       
                                                                        
          05 WS-REV-MONTH-CHAR           PIC X(06).                     
          05 WS-REV-MONTH-NUM REDEFINES                                 
                     WS-REV-MONTH-CHAR   PIC 9(06).                     
                                                                        
          05 WS-YEAR-MONTH.                                             
             10 WS-YEAR                  PIC 9(04).                     
             10 WS-MONTH                 PIC 9(02).                     
          05 WS-CODE-SHORT-DESC          PIC X(15) VALUE SPACES.        
          05 WS-CRE-GRP-ID-AC-TYP REDEFINES                             
                     WS-CODE-SHORT-DESC.                                
             10 WS-DFLT-CRE-GRP-ID       PIC X(01).                     
             10 WS-DLFT-ACC-TYP-CD       PIC X(01).                     
             10 WS-DLFT-REG-GRP-CD       PIC X(04).                     
             10 FILLER                   PIC X(09).                     
      *                                                                         
       01 WS-BUSI-DAY-TABLE.                                            
          05 WS-BUSI-DAY-LIST.                                          
             10 WS-BUSI-DAY              PIC X(10) OCCURS 120 TIMES.    
      *                                                                         
       01 WS-WORK-DAY-TABLE REDEFINES WS-BUSI-DAY-TABLE.                
          05 WS-WORK-DAY-LIST OCCURS 120 TIMES                          
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
             10 WS-WORK-DAY              PIC X(10).                     
      *                                                                         
       01 WS-SCH-TABLES.                                                
          05 WS-COUNT1                   PIC S9(4) COMP VALUE +0.       
          05 WS-WSCH-ROW-COUNT1          PIC S9(4) COMP VALUE +0.       
          05 WS-SCH-TABLE1.                                             
             10 CUR-BILL-CYCLE           PIC X(02) OCCURS 450 TIMES.    
             10 CUR-BILL-FROM            PIC X(10) OCCURS 450 TIMES.    
             10 CUR-BILL-BY              PIC X(10) OCCURS 450 TIMES.    
             10 CUR-OPTIMUM-READ-DT      PIC X(10) OCCURS 450 TIMES.    
             10 CUR-THIRD-PTY-READ-DT    PIC X(10) OCCURS 450 TIMES.    
             10 CUR-REG-GROUP-CD         PIC X(03) OCCURS 450 TIMES.    
             10 CUR-CREDIT-GROUP-ID      PIC X(03) OCCURS 450 TIMES.    
             10 CUR-CRED-ACCT-TYPE-CD    PIC X(01) OCCURS 450 TIMES.    
             10 CUR-BILL-DT              PIC X(10) OCCURS 450 TIMES.    
             10 CUR-CURR-CHG-DUE-DT      PIC X(10) OCCURS 450 TIMES.    
             10 CUR-AVOID-LPC-DT         PIC X(10) OCCURS 450 TIMES.    
             10 CUR-DNP-NOTICE-MAIL-DT   PIC X(10) OCCURS 450 TIMES.    
             10 CUR-DNP-DT               PIC X(10) OCCURS 450 TIMES.    
             10 NXT-BILL-FROM            PIC X(10) OCCURS 450 TIMES.    
             10 NXT-BILL-BY              PIC X(10) OCCURS 450 TIMES.    
             10 NXT-OPTIMUM-READ-DT      PIC X(10) OCCURS 450 TIMES.    
             10 NXT-CURR-CHG-DUE-DT      PIC X(10) OCCURS 450 TIMES.    
             10 NXT-DNP-NOTICE-MAIL-DT   PIC X(10) OCCURS 450 TIMES.    
             10 NXT-DNP-DT               PIC X(10) OCCURS 450 TIMES.    
             10 NXT-IVR-CALL-DT          PIC X(10) OCCURS 450 TIMES.    
             10 NXT-AVOID-LPC-DT         PIC X(10) OCCURS 450 TIMES.    
                                                                        
      *                                                                         
       01  LITERALS.                                                    
           05  WS-ARREARS              PIC X(1)  VALUE 'A'.             
           05  WS-BALANCE              PIC X(1)  VALUE 'B'.             
           05  WS-BALANCE-REG          PIC X(1)  VALUE 'F'.             
           05  WS-BALANCE-DEREG        PIC X(1)  VALUE 'G'.             
           05  WS-EXEMPT               PIC X(1)  VALUE 'C'.             
           05  WS-NON-UTILITY          PIC X(1)  VALUE 'D'.             
           05  WS-MASTER               PIC X(1)  VALUE 'M'.             
           05  WS-NEW                  PIC X(1)  VALUE 'N'.             
           05  WS-SCEG                 PIC X(2)  VALUE '01'.            
           05  WS-PSNC                 PIC X(2)  VALUE '26'.            
           05  WS-1                    PIC 9(1)  VALUE 1.               
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-REV-YEAR                PIC X(04).                      
       01  PARM-REV-MONTH               PIC X(02).                      
       01  PARM-CR-GROUP                PIC X(01).                      
       01  PARM-COMPANY-NO              PIC X(02).                      
      *                                                                         
      *===============================================================* 00030003
      * DELIQ CURSOR                                                            
      *===============================================================* 00030003
      *                                                                         
           EXEC SQL                                                     
              DECLARE DELINQUENCY_CSR CURSOR FOR                        
                SELECT                                                  
                    DELINQ_CD,                                          
                    DELINQ_VALUE                                        
                FROM                                                    
                    CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
                WHERE COMPANY_NO = :WS-COMPANY-NO                       
                FOR READ ONLY                                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQUENCY_CSR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*             DELINQ_CD,                                                  
MFA-TR*             DELINQ_VALUE                                                
MFA-TR*         FROM                                                            
MFA-TR*             CSS_DELINQUENCY                                             
MFA-TR*         WHERE COMPANY_NO = :WS-COMPANY-NO                               
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7005                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***             AND CM1.BILL_DT =  BN1.BILL_BY                            
      ***             ,COALESCE(CUR.REG_GROUP_CD, SPACE(3))                     
      ***             ,COALESCE(CUR.CREDIT_GROUP_ID, SPACE(3))                  
      ***             ,COALESCE(CUR.CRED_ACCT_TYPE_CD, SPACE(1))                
      *===============================================================* 00030003
      * MAIN CURSOR TO GET WORK SCHEDULES DATA                                  
      *===============================================================* 00030003
      *                                                                         
           EXEC SQL                                                     
              DECLARE WSCH_CUR1 CURSOR WITH ROWSET POSITIONING FOR      
                SELECT CUR.BILL_CYCLE                                   
                   ,CUR.BILL_FROM                                       
                   ,CUR.BILL_BY                                         
                   ,CUR.OPTIMUM_READ_DATE                               
                   ,COALESCE(CAST(CUR.THIRD_PTY_READ_DT
            AS CHAR(10)), ' ')         
                   ,COALESCE(CUR.REG_GROUP_CD, 'XXX')                   
                   ,COALESCE(CUR.CREDIT_GROUP_ID, 'XXX')                
                   ,COALESCE(CUR.CRED_ACCT_TYPE_CD, 'X')                
                   ,COALESCE(CAST(CUR.BILL_DT AS CHAR(10)), ' ')                
                   ,COALESCE(CAST(CUR.CURR_CHG_DUE_DT AS CHAR(10)), ' ')        
                   ,COALESCE(CAST(CUR.AVOID_LPC_DT AS CHAR(10)), ' ')           
                   ,COALESCE(CAST(CUR.DNP_NOTICE_MAIL_DT
            AS CHAR(10)), ' ')         
                   ,COALESCE(CAST(CUR.DNP_DT AS CHAR(10)), ' ')                 
                   ,COALESCE(CAST(NXT.BILL_FROM AS CHAR(10)), ' ')              
                   ,COALESCE(CAST(NXT.BILL_BY AS CHAR(10)), ' ')                
                   ,COALESCE(CAST(NXT.OPTIMUM_READ_DATE
            AS CHAR(10)), ' ')          
                   ,COALESCE(CAST(NXT.CURR_CHG_DUE_DT AS CHAR(10)), ' ')        
                   ,COALESCE(CAST(NXT.DNP_NOTICE_MAIL_DT
            AS CHAR(10)), ' ')         
                   ,COALESCE(CAST(NXT.DNP_DT AS CHAR(10)), ' ')                 
                   ,COALESCE(CAST(NXT.IVR_CALL_DT AS CHAR(10)), ' ')            
                   ,COALESCE(CAST(NXT.AVOID_LPC_DT AS CHAR(10)), ' ')           
                FROM                                                    
                   (SELECT TOP 100 PERCENT BN1.BILL_FROM,
              BN1.BILL_BY,
              BN1.BILL_CYCLE,
              BN1.REVENUE_MONTH,
              RW1.OPTIMUM_READ_DATE,
              RW1.THIRD_PTY_READ_DT,
              CM1.REG_GROUP_CD,
              CM1.BILL_DT,
              CM1.AVOID_LPC_DT,
              CM1.CURR_CHG_DUE_DT,
              CM1.DNP_NOTICE_MAIL_DT,
              CM1.DNP_DT,
              CM1.CREDIT_GROUP_ID,
              CM1.CRED_ACCT_TYPE_CD                        
                   FROM                                                 
                      (SELECT MIN(B1.DATE_EXTRACT) AS BILL_FROM         
                             ,MAX(B1.DATE_EXTRACT) AS BILL_BY           
                             ,B1.BILL_CYCLE                             
                             ,B1.REVENUE_MONTH                          
                      FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)             
                      WHERE B1.REVENUE_MONTH = :WS-CUR-REV-MONTH        
                      GROUP BY B1.REVENUE_MONTH                         
                              ,B1.BILL_CYCLE   ) BN1                    
                      JOIN                                              
                      CSS_READ_WINDOW RW1 WITH(READUNCOMMITTED)                 
                      ON ( BN1.BILL_CYCLE = RW1.READ_CYCLE              
                       AND BN1.REVENUE_MONTH = RW1.REVENUE_MONTH)       
                      LEFT JOIN                                         
                      CSS_CRED_FORECAST CM1 WITH(READUNCOMMITTED)               
                      ON (CM1.COMPANY_NO  = :CM-COMPANY-NO              
                      AND CM1.BILL_CYCLE = BN1.BILL_CYCLE               
                      AND CM1.REVENUE_MONTH = BN1.REVENUE_MONTH         
                      AND CM1.CREDIT_GROUP = :CM-CREDIT-GROUP)          
                      WHERE BN1.REVENUE_MONTH = :WS-CUR-REV-MONTH       
                      ORDER BY BN1.BILL_CYCLE                           
                              ,BN1.BILL_FROM                            
                              ,CM1.BILL_DT                              
                              ,CM1.CREDIT_GROUP_ID                      
                              ,CM1.CRED_ACCT_TYPE_CD ) CUR              
                   LEFT JOIN                                            
                   (SELECT TOP 100 PERCENT BN1.BILL_FROM,
              BN1.BILL_BY,
              BN1.BILL_CYCLE,
              BN1.REVENUE_MONTH,
              RW1.OPTIMUM_READ_DATE,
              CM1.REG_GROUP_CD,
              CM1.CREDIT_GROUP_ID,
              CM1.CRED_ACCT_TYPE_CD,
              CM1.CURR_CHG_DUE_DT,
              CM1.DNP_NOTICE_MAIL_DT,
              CM1.DNP_DT,
              CM1.IVR_CALL_DT,
              CM1.AVOID_LPC_DT                             
                   FROM                                                 
                      (SELECT MIN(B1.DATE_EXTRACT) AS BILL_FROM         
                             ,MAX(B1.DATE_EXTRACT) AS BILL_BY           
                             ,B1.BILL_CYCLE                             
                             ,B1.REVENUE_MONTH                          
                      FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)             
                      WHERE B1.REVENUE_MONTH = :WS-NXT-REV-MONTH        
                      GROUP BY B1.REVENUE_MONTH                         
                              ,B1.BILL_CYCLE   ) BN1                    
                      JOIN                                              
                      CSS_READ_WINDOW RW1 WITH(READUNCOMMITTED)                 
                      ON ( BN1.BILL_CYCLE = RW1.READ_CYCLE              
                       AND BN1.REVENUE_MONTH = RW1.REVENUE_MONTH)       
                      LEFT JOIN                                         
                      CSS_CRED_FORECAST CM1 WITH(READUNCOMMITTED)               
                      ON (CM1.COMPANY_NO  = :CM-COMPANY-NO              
                      AND CM1.BILL_CYCLE = BN1.BILL_CYCLE               
                      AND CM1.REVENUE_MONTH = BN1.REVENUE_MONTH         
                      AND CM1.BILL_DT =  BN1.BILL_BY                    
                      AND CM1.CREDIT_GROUP = :CM-CREDIT-GROUP)          
                      WHERE BN1.REVENUE_MONTH = :WS-NXT-REV-MONTH       
                      ORDER BY BN1.BILL_CYCLE                           
                              ,BN1.BILL_FROM                            
                              ,CM1.CREDIT_GROUP_ID                      
                              ,CM1.CRED_ACCT_TYPE_CD  ) NXT             
                   ON (CUR.BILL_CYCLE = NXT.BILL_CYCLE                  
                   AND CUR.CREDIT_GROUP_ID = NXT.CREDIT_GROUP_ID        
                   AND CUR.CRED_ACCT_TYPE_CD = NXT.CRED_ACCT_TYPE_CD    
                   AND CUR.REG_GROUP_CD  = NXT.REG_GROUP_CD)            
                ORDER BY 1, 2, 6, 7, 8, 9                               
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ023
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WSCH_CUR1 CURSOR WITH ROWSET POSITIONING FOR              
MFA-TR*         SELECT CUR.BILL_CYCLE                                           
MFA-TR*            ,CUR.BILL_FROM                                               
MFA-TR*            ,CUR.BILL_BY                                                 
MFA-TR*            ,CUR.OPTIMUM_READ_DATE                                       
MFA-TR*            ,COALESCE(CHAR(CUR.THIRD_PTY_READ_DT ), ' ')                 
MFA-TR*            ,COALESCE(CUR.REG_GROUP_CD, 'XXX')                           
MFA-TR*            ,COALESCE(CUR.CREDIT_GROUP_ID, 'XXX')                        
MFA-TR*            ,COALESCE(CUR.CRED_ACCT_TYPE_CD, 'X')                        
MFA-TR*            ,COALESCE(CHAR(CUR.BILL_DT), ' ')                            
MFA-TR*            ,COALESCE(CHAR(CUR.CURR_CHG_DUE_DT), ' ')                    
MFA-TR*            ,COALESCE(CHAR(CUR.AVOID_LPC_DT), ' ')                       
MFA-TR*            ,COALESCE(CHAR(CUR.DNP_NOTICE_MAIL_DT), ' ')                 
MFA-TR*            ,COALESCE(CHAR(CUR.DNP_DT), ' ')                             
MFA-TR*            ,COALESCE(CHAR(NXT.BILL_FROM), ' ')                          
MFA-TR*            ,COALESCE(CHAR(NXT.BILL_BY), ' ')                            
MFA-TR*            ,COALESCE(CHAR(NXT.OPTIMUM_READ_DATE), ' ')                  
MFA-TR*            ,COALESCE(CHAR(NXT.CURR_CHG_DUE_DT), ' ')                    
MFA-TR*            ,COALESCE(CHAR(NXT.DNP_NOTICE_MAIL_DT), ' ')                 
MFA-TR*            ,COALESCE(CHAR(NXT.DNP_DT), ' ')                             
MFA-TR*            ,COALESCE(CHAR(NXT.IVR_CALL_DT), ' ')                        
MFA-TR*            ,COALESCE(CHAR(NXT.AVOID_LPC_DT), ' ')                       
MFA-TR*         FROM                                                            
MFA-TR*            (SELECT BN1.BILL_FROM                                        
MFA-TR*                   ,BN1.BILL_BY                                          
MFA-TR*                   ,BN1.BILL_CYCLE                                       
MFA-TR*                   ,BN1.REVENUE_MONTH                                    
MFA-TR*                   ,RW1.OPTIMUM_READ_DATE                                
MFA-TR*                   ,RW1.THIRD_PTY_READ_DT                                
MFA-TR*                   ,CM1.REG_GROUP_CD                                     
MFA-TR*                   ,CM1.BILL_DT                                          
MFA-TR*                   ,CM1.AVOID_LPC_DT                                     
MFA-TR*                   ,CM1.CURR_CHG_DUE_DT                                  
MFA-TR*                   ,CM1.DNP_NOTICE_MAIL_DT                               
MFA-TR*                   ,CM1.DNP_DT                                           
MFA-TR*                   ,CM1.CREDIT_GROUP_ID                                  
MFA-TR*                   ,CM1.CRED_ACCT_TYPE_CD                                
MFA-TR*            FROM                                                         
MFA-TR*               (SELECT MIN(B1.DATE_EXTRACT) AS BILL_FROM                 
MFA-TR*                      ,MAX(B1.DATE_EXTRACT) AS BILL_BY                   
MFA-TR*                      ,B1.BILL_CYCLE                                     
MFA-TR*                      ,B1.REVENUE_MONTH                                  
MFA-TR*               FROM CSS_BILL_WINDOW B1                                   
MFA-TR*               WHERE B1.REVENUE_MONTH = :WS-CUR-REV-MONTH                
MFA-TR*               GROUP BY B1.REVENUE_MONTH                                 
MFA-TR*                       ,B1.BILL_CYCLE   ) BN1                            
MFA-TR*               JOIN                                                      
MFA-TR*               CSS_READ_WINDOW RW1                                       
MFA-TR*               ON ( BN1.BILL_CYCLE = RW1.READ_CYCLE                      
MFA-TR*                AND BN1.REVENUE_MONTH = RW1.REVENUE_MONTH)               
MFA-TR*               LEFT JOIN                                                 
MFA-TR*               CSS_CRED_FORECAST CM1                                     
MFA-TR*               ON (CM1.COMPANY_NO  = :CM-COMPANY-NO                      
MFA-TR*               AND CM1.BILL_CYCLE = BN1.BILL_CYCLE                       
MFA-TR*               AND CM1.REVENUE_MONTH = BN1.REVENUE_MONTH                 
MFA-TR*               AND CM1.CREDIT_GROUP = :CM-CREDIT-GROUP)                  
MFA-TR*               WHERE BN1.REVENUE_MONTH = :WS-CUR-REV-MONTH               
MFA-TR*               ORDER BY BN1.BILL_CYCLE                                   
MFA-TR*                       ,BN1.BILL_FROM                                    
MFA-TR*                       ,CM1.BILL_DT                                      
MFA-TR*                       ,CM1.CREDIT_GROUP_ID                              
MFA-TR*                       ,CM1.CRED_ACCT_TYPE_CD ) CUR                      
MFA-TR*            LEFT JOIN                                                    
MFA-TR*            (SELECT BN1.BILL_FROM                                        
MFA-TR*                   ,BN1.BILL_BY                                          
MFA-TR*                   ,BN1.BILL_CYCLE                                       
MFA-TR*                   ,BN1.REVENUE_MONTH                                    
MFA-TR*                   ,RW1.OPTIMUM_READ_DATE                                
MFA-TR*                   ,CM1.REG_GROUP_CD                                     
MFA-TR*                   ,CM1.CREDIT_GROUP_ID                                  
MFA-TR*                   ,CM1.CRED_ACCT_TYPE_CD                                
MFA-TR*                   ,CM1.CURR_CHG_DUE_DT                                  
MFA-TR*                   ,CM1.DNP_NOTICE_MAIL_DT                               
MFA-TR*                   ,CM1.DNP_DT                                           
MFA-TR*                   ,CM1.IVR_CALL_DT                                      
MFA-TR*                   ,CM1.AVOID_LPC_DT                                     
MFA-TR*            FROM                                                         
MFA-TR*               (SELECT MIN(B1.DATE_EXTRACT) AS BILL_FROM                 
MFA-TR*                      ,MAX(B1.DATE_EXTRACT) AS BILL_BY                   
MFA-TR*                      ,B1.BILL_CYCLE                                     
MFA-TR*                      ,B1.REVENUE_MONTH                                  
MFA-TR*               FROM CSS_BILL_WINDOW B1                                   
MFA-TR*               WHERE B1.REVENUE_MONTH = :WS-NXT-REV-MONTH                
MFA-TR*               GROUP BY B1.REVENUE_MONTH                                 
MFA-TR*                       ,B1.BILL_CYCLE   ) BN1                            
MFA-TR*               JOIN                                                      
MFA-TR*               CSS_READ_WINDOW RW1                                       
MFA-TR*               ON ( BN1.BILL_CYCLE = RW1.READ_CYCLE                      
MFA-TR*                AND BN1.REVENUE_MONTH = RW1.REVENUE_MONTH)               
MFA-TR*               LEFT JOIN                                                 
MFA-TR*               CSS_CRED_FORECAST CM1                                     
MFA-TR*               ON (CM1.COMPANY_NO  = :CM-COMPANY-NO                      
MFA-TR*               AND CM1.BILL_CYCLE = BN1.BILL_CYCLE                       
MFA-TR*               AND CM1.REVENUE_MONTH = BN1.REVENUE_MONTH                 
MFA-TR*               AND CM1.BILL_DT =  BN1.BILL_BY                            
MFA-TR*               AND CM1.CREDIT_GROUP = :CM-CREDIT-GROUP)                  
MFA-TR*               WHERE BN1.REVENUE_MONTH = :WS-NXT-REV-MONTH               
MFA-TR*               ORDER BY BN1.BILL_CYCLE                                   
MFA-TR*                       ,BN1.BILL_FROM                                    
MFA-TR*                       ,CM1.CREDIT_GROUP_ID                              
MFA-TR*                       ,CM1.CRED_ACCT_TYPE_CD  ) NXT                     
MFA-TR*            ON (CUR.BILL_CYCLE = NXT.BILL_CYCLE                          
MFA-TR*            AND CUR.CREDIT_GROUP_ID = NXT.CREDIT_GROUP_ID                
MFA-TR*            AND CUR.CRED_ACCT_TYPE_CD = NXT.CRED_ACCT_TYPE_CD            
MFA-TR*            AND CUR.REG_GROUP_CD  = NXT.REG_GROUP_CD)                    
MFA-TR*         ORDER BY 1, 2, 6, 7, 8, 9                                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                 02750000
      *===============================================================* 00010003
      *  CURSOR DECLARATION FOR THE CSS_BUSINESS_DAYS TABLE.          * 00021003
      *===============================================================* 00030003
      *                                                                         
           EXEC SQL                                                     
             DECLARE WORK-CUR CURSOR WITH ROWSET POSITIONING FOR        
               SELECT TOP(120) BUSINESS_DAY_DT                                  
                  FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                  
               WHERE BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )            
               ORDER BY BUSINESS_DAY_DT                                 
                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE WORK-CUR CURSOR WITH ROWSET POSITIONING FOR                
MFA-TR*        SELECT BUSINESS_DAY_DT                                           
MFA-TR*           FROM CSS_BUSINESS_DAYS                                        
MFA-TR*        WHERE BUSINESS_DAY_DT >= :WS-NEW-BUSINESS-DAY                    
MFA-TR*        ORDER BY BUSINESS_DAY_DT                                         
MFA-TR*        FETCH FIRST 120 ROWS ONLY WITH UR                                
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      ******************************************************************        
      ******************************************************************        
       PROCEDURE DIVISION USING PARM-REV-YEAR                           
                               ,PARM-REV-MONTH                          
                               ,PARM-CR-GROUP                           
                               ,PARM-COMPANY-NO.                        
      ******************************************************************        
                                                                        
      *===============================================================* 00030003
       0000-MAINLINE.                                                   
      *===============================================================* 00030003
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      *================================================================*        
       0100-INITIALIZE.                                                 
      *================================================================*        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
           PERFORM 0100B-DECLARE-GTT   THRU 0100B-EXIT.                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100A-DECLARE-GTT.                                               
      *================================================================*        
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04579_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04579_R1
              (                                                        
                    RETURN_CODE_R1            INT                   
                   ,APPL_RETURN_CODE_R1       INT                   
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CREDIT_GROUP CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_YEAR_START CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_MONTH_START CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_YEAR_END CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_MONTH_END CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_YEAR CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,BILL_MONTH CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,REG_GROUP_CD_DF CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,CREDIT_GROUP_ID_DF CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,CREDIT_ACCT_TYPE_DF CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8900B-DELETE-GTT-ROWS THRU 8900B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME     TO ABEND-PROGRAM                 
                 MOVE '0100A'          TO ACTIVE-PARAGRAPH              
                 MOVE 'DECLARE GTT'    TO ABEND-FUNCTION                
                 MOVE SPACES           TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
                 MOVE SQLCODE          TO ABEND-SQLCODE                 
                 MOVE SQLSTATE         TO ABEND-SQLSTATE                
                 MOVE 'CSR04579_R1'    TO TABLE-1                       
                 MOVE SPACES           TO TABLE-ELEMENT-1               
                 MOVE SPACES           TO HOSTVAR-ELEMENT-1             
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
               WITH ROWSET POSITIONING FOR                              
               SELECT *                                                 
               FROM #CSR04579_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR04579_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100B-DECLARE-GTT.                                               
      *================================================================*        
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04579_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04579_R2
              (                                                        
                    RETURN_CODE_R2            INT                   
                   ,BILL_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,REG_GROUP_CD CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,CREDIT_GROUP_ID CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,CREDIT_ACCT_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,OPTIMUM_READ_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_FROM_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_BY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,BILL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,MAIL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DUE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,LPC_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,FIRST_NOTICE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,SECOND_NOTICE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                   ,IVR_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,DNP_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,THIRD_PARTY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8900A-DELETE-GTT-ROWS THRU 8900A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME     TO ABEND-PROGRAM                 
                 MOVE '0100B'          TO ACTIVE-PARAGRAPH              
                 MOVE 'DECLARE GTT'    TO ABEND-FUNCTION                
                 MOVE SPACES           TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
                 MOVE SQLCODE          TO ABEND-SQLCODE                 
                 MOVE SQLSTATE         TO ABEND-SQLSTATE                
                 MOVE 'CSR04579_R2'    TO TABLE-1                       
                 MOVE SPACES           TO TABLE-ELEMENT-1               
                 MOVE SPACES           TO HOSTVAR-ELEMENT-1             
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
               WITH ROWSET POSITIONING FOR                              
               SELECT *                                                 
               FROM #CSR04579_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR04579_R2                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-INPUT.                                              
      *================================================================*        
      *                                                                         
           IF PARM-REV-MONTH >= '01'                                    
              MOVE PARM-REV-YEAR       TO WS-YEAR                       
              MOVE PARM-REV-MONTH      TO WS-MONTH                      
              MOVE WS-YEAR-MONTH       TO WS-REV-MONTH-CHAR             
              MOVE WS-REV-MONTH-NUM    TO WS-CUR-REV-MONTH              
                                          BN-REVENUE-MONTH              
                                          RW-REVENUE-MONTH              
           ELSE                                                         
              PERFORM 7004-GET-CURRENT-REV-MONTH THRU 7004-EXIT         
              MOVE BN-REVENUE-MONTH    TO WS-CUR-REV-MONTH              
                                          RW-REVENUE-MONTH              
                                          WS-REV-MONTH-NUM              
              MOVE WS-REV-MONTH-NUM     TO WS-YEAR-MONTH                
              MOVE WS-YEAR              TO PARM-REV-YEAR                
              MOVE WS-MONTH             TO PARM-REV-MONTH               
           END-IF.                                                      
           MOVE BN-REVENUE-MONTH        TO WS-REV-MONTH-NUM             
           PERFORM 2215-GET-NEXT-REV-MONTH THRU 2215-EXIT.              
           MOVE '00'                       TO WS-BILL-CYCLE.            
           MOVE PARM-CR-GROUP              TO WS-CREDIT-GROUP.          
           MOVE PARM-COMPANY-NO            TO WS-COMPANY-NO.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-PROCESS-OUTPUT.                                             
      *================================================================*        
                                                                        
                                                                        
           PERFORM 7050-GET-EQP-ATTCHMTS-DESC THRU 7050-EXIT.           
                                                                        
           PERFORM 2205-LOAD-DELINQ-VALUES    THRU 2205-EXIT.           
                                                                        
           PERFORM 2206-VERIFY-DELINQ-VALUES  THRU 2206-EXIT.           
                                                                        
           PERFORM 2210-LOAD-WORK-DAYS        THRU 2210-EXIT.           
                                                                        
           PERFORM 2100-GET-WORK-SCHS         THRU 2100-EXIT.           
                                                                        
           EVALUATE TRUE                                                
             WHEN WS-CREDIT-GROUP = WS-NEW                              
             WHEN WS-CREDIT-GROUP = WS-ARREARS                          
                 PERFORM 2400-FORECASTING-NEW-ARR  THRU 2400-EXIT       
                  VARYING WS-COUNT1 FROM 1 BY 1                         
                  UNTIL WS-COUNT1 > WS-WSCH-ROW-COUNT1                  
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-EXEMPT                           
                 PERFORM 2500-FORECASTING-EXEMPT      THRU 2500-EXIT    
                  VARYING WS-COUNT1 FROM 1 BY 1                         
                  UNTIL WS-COUNT1 > WS-WSCH-ROW-COUNT1                  
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-BALANCE                          
                PERFORM 2600-FORECASTING-BALANCE     THRU 2600-EXIT     
                  VARYING WS-COUNT1 FROM 1 BY 1                         
                  UNTIL WS-COUNT1 > WS-WSCH-ROW-COUNT1                  
      *                                                                         
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-NON-UTILITY                      
                 PERFORM 2700-FORECASTING-NON-UTIL    THRU 2700-EXIT    
                  VARYING WS-COUNT1 FROM 1 BY 1                         
                  UNTIL WS-COUNT1 > WS-WSCH-ROW-COUNT1                  
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-MASTER                           
                 PERFORM 2800-FORECASTING-MASTER      THRU 2800-EXIT    
                  VARYING WS-COUNT1 FROM 1 BY 1                         
                  UNTIL WS-COUNT1 > WS-WSCH-ROW-COUNT1                  
      *                                                                         
           END-EVALUATE.                                                
                                                                        
           PERFORM 2050-PROCESS-HEADER-DATA   THRU 2050-EXIT.           
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      *================================================================*        
       2050-PROCESS-HEADER-DATA.                                        
      *================================================================*        
      *                                                                         
           MOVE ZEROS                    TO WS-MIN-REV-MONTH            
                                            WS-MAX-REV-MONTH            
           PERFORM 7003-GET-MIN-MAX-REV-MONTH THRU 7003-EXIT.           
                                                                        
           MOVE WS-MIN-REV-MONTH         TO WS-REV-MONTH-NUM            
           MOVE WS-REV-MONTH-CHAR        TO WS-YEAR-MONTH               
           MOVE WS-YEAR                  TO S-BILL-YEAR-START           
           MOVE WS-MONTH                 TO S-BILL-MONTH-START          
                                                                        
           MOVE WS-MAX-REV-MONTH         TO WS-REV-MONTH-NUM            
           MOVE WS-REV-MONTH-CHAR        TO WS-YEAR-MONTH               
           MOVE WS-YEAR                  TO S-BILL-YEAR-END             
           MOVE WS-MONTH                 TO S-BILL-MONTH-END            
                                                                        
           MOVE ZERO                     TO S-RETURN-CODE-R1.           
                                                                        
           PERFORM 8100-SEND-R1-RESULT        THRU 8100-EXIT.           
                                                                        
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2100-GET-WORK-SCHS.                                              
      *================================================================*        
      *                                                                         
           MOVE WS-CREDIT-GROUP               TO CM-CREDIT-GROUP.       
           MOVE WS-COMPANY-NO                 TO CM-COMPANY-NO.         
           MOVE SPACES                        TO CM-CRED-FORECAST-CD.   
           PERFORM 7100-OPEN-WSCH-CUR1        THRU 7100-EXIT.           
           PERFORM 7110-FETCH-WSCH-CUR1       THRU 7110-EXIT.           
           PERFORM 7120-CLOSE-WSCH-CUR1       THRU 7120-EXIT.           
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2205-LOAD-DELINQ-VALUES.                                         
      *================================================================*        
      *                                                                         
           PERFORM 7005-OPEN-DELINQ-CSR               THRU 7005-EXIT.   
           PERFORM 7006-FETCH-DELINQ-CSR              THRU 7006-EXIT.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7006'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
              MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
              MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE C8-DELINQ-CD    TO WS-DELINQ-CODE                    
              MOVE C8-DELINQ-VALUE TO WS-DELINQ-VALUE                   
                                                                        
              EVALUATE WS-DELINQ-CODE                                   
                WHEN 'DAY-SECOND-MAIL'                                  
                   MOVE WS-DELINQ-VALUE TO WS-DAY-SECOND-MAIL           
                WHEN 'DAY-SECOND-FIELD'                                 
                   MOVE WS-DELINQ-VALUE TO WS-DAY-SECOND-FIELD          
                WHEN 'DAY-BSECIVREXC'                                   
                   MOVE WS-DELINQ-VALUE TO WS-DAY-EXC-IVR-DATE          
                WHEN 'DAY-TOTAL-DUE'                                    
                   MOVE WS-DELINQ-VALUE TO WS-DAY-TOTAL-DUE             
                WHEN 'DAY-DNP'                                          
                   MOVE WS-DELINQ-VALUE TO WS-DAY-DNP                   
                WHEN 'DAY-DUE'                                          
                   MOVE WS-DELINQ-VALUE TO WS-DAY-DUE                   
                WHEN 'DATABASE'                                         
                   MOVE WS-DELINQ-VALUE TO WS-DATABASE                  
                WHEN 'DAY-BTOTALDUE'                                    
                   MOVE WS-DELINQ-VALUE TO WS-DAY-BTOTALDUE             
               END-EVALUATE                                             
      *                                                                         
               PERFORM 7006-FETCH-DELINQ-CSR          THRU 7006-EXIT    
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7007-CLOSE-DELINQ-CSR              THRU 7007-EXIT.   
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2206-VERIFY-DELINQ-VALUES.                                       
      *================================================================*        
           IF WS-DAY-DUE                       > ZERO                   
              AND WS-DAY-DNP                   > ZERO                   
              AND WS-DAY-SECOND-MAIL           > ZERO                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '12'                   TO WS-ACTIVE-RETURN-CODE      
                                             SQLCODE                    
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '2206'                 TO ACTIVE-PARAGRAPH           
              MOVE 'DELINQER'             TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
              MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
       2206-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *==============================================================*          
       2210-LOAD-WORK-DAYS.                                             
      *==============================================================*          
      *                                                                         
           MOVE WS-CUR-REV-MONTH         TO WS-REV-MONTH-NUM            
           MOVE WS-REV-MONTH-CHAR        TO WS-YEAR-MONTH               
           MOVE WS-YEAR                  TO WS-NEW-BUSINESS-DAY(1:4)    
           MOVE '-'                      TO WS-NEW-BUSINESS-DAY(5:1)    
           MOVE WS-MONTH                 TO WS-NEW-BUSINESS-DAY(6:2)    
           MOVE '-'                      TO WS-NEW-BUSINESS-DAY(8:1)    
           MOVE '01'                     TO WS-NEW-BUSINESS-DAY(9:2)    
           PERFORM 7220-OPEN-WORK-DAY-CSR       THRU 7220-EXIT          
           PERFORM 7230-FETCH-WORK-DAY-CSR      THRU 7230-EXIT          
           PERFORM 7240-CLOSE-WORK-DAY-CSR      THRU 7240-EXIT.         
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2215-GET-NEXT-REV-MONTH.                                         
      *================================================================*        
      *                                                                         
           MOVE WS-REV-MONTH-NUM     TO WS-YEAR-MONTH.                  
      *                                                                         
           ADD 1                     TO WS-MONTH.                       
           IF WS-MONTH = 13                                             
               MOVE 1                TO WS-MONTH                        
               ADD  1                TO WS-YEAR                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-YEAR-MONTH        TO WS-REV-MONTH-CHAR               
           MOVE WS-REV-MONTH-NUM     TO WS-NXT-REV-MONTH.               
      *                                                                         
      *                                                                         
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2400-FORECASTING-NEW-ARR.                                        
      *================================================================*        
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO NEW OR ARREARS.                              
      *                                                                         
      **   IF CUR-BILL-BY (WS-COUNT1) = CUR-BILL-DT (WS-COUNT1)                 
      **      OR CUR-BILL-DT (WS-COUNT1) = ' '                                  
      **      CONTINUE                                                          
      **   ELSE                                                                 
      ***     GO TO 2400-EXIT                                                   
      ***  END-IF                                                               
                                                                        
           PERFORM 3000-FORMAT-COMMON-DATA    THRU 3000-EXIT.           
                                                                        
           IF CUR-BILL-DT (WS-COUNT1) > SPACES                          
              MOVE CUR-BILL-DT (WS-COUNT1)    TO S-BILL-DATE            
           ELSE                                                         
              MOVE CUR-BILL-BY (WS-COUNT1)    TO S-BILL-DATE            
           END-IF                                                       
                                                                        
                                                                        
      *** GET MAIL DATE                                                         
           MOVE WS-DAY-DUE             TO WS-NO-OF-DAYS                 
           MOVE S-BILL-DATE            TO WS-NEW-BUSINESS-DAY           
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY    TO S-MAIL-DATE.                  
      *                                                                         
           MOVE CUR-OPTIMUM-READ-DT (WS-COUNT1)                         
                                              TO S-READ-DATE.           
           MOVE CUR-AVOID-LPC-DT (WS-COUNT1)  TO S-AVOID-LPC-DATE.      
      *                                                                         
      *** GET FIRST NOTICE DATE                                                 
           MOVE NXT-BILL-BY (WS-COUNT1)       TO WS-NEW-BUSINESS-DAY.   
           MOVE WS-DAY-DUE                    TO WS-NO-OF-DAYS          
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY           TO S-FIRST-NOTICE-DATE.   
      *                                                                         
           MOVE NXT-DNP-DT (WS-COUNT1)        TO S-DNP-DATE.            
                                                                        
           MOVE NXT-IVR-CALL-DT (WS-COUNT1)   TO S-IVR-DATE             
           MOVE CUR-THIRD-PTY-READ-DT (WS-COUNT1)                       
                                              TO S-THIRD-PTY-READ-DT    
           MOVE NXT-DNP-NOTICE-MAIL-DT (WS-COUNT1)                      
                                              TO S-SECOND-NOTICE-DATE.  
           MOVE CUR-CURR-CHG-DUE-DT (WS-COUNT1)                         
                                              TO S-BILL-DUE-DATE        
                                                                        
           PERFORM 8200-SEND-R2-RESULT                THRU 8200-EXIT.   
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 2500-FORECASTING-EXEMPT                                                 
      *                                                                         
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO NEW.                                         
      *                                                                         
      ******************************************************************        
      *                                                                         
      *================================================================*        
       2500-FORECASTING-EXEMPT.                                         
      *================================================================*        
      *                                                                         
           PERFORM 3000-FORMAT-COMMON-DATA    THRU 3000-EXIT.           
                                                                        
           IF CUR-BILL-DT (WS-COUNT1) > SPACES                          
              MOVE CUR-BILL-DT (WS-COUNT1)    TO  S-BILL-DATE           
           ELSE                                                         
              MOVE CUR-BILL-BY (WS-COUNT1)    TO S-BILL-DATE            
           END-IF                                                       
                                                                        
      *** GET MAIL DATE                                                         
           MOVE WS-DAY-DUE             TO WS-NO-OF-DAYS                 
           MOVE S-BILL-DATE            TO WS-NEW-BUSINESS-DAY           
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY    TO S-MAIL-DATE.                  
      *                                                                         
           MOVE CUR-OPTIMUM-READ-DT (WS-COUNT1)                         
                                              TO S-READ-DATE.           
           MOVE CUR-THIRD-PTY-READ-DT (WS-COUNT1)                       
                                              TO S-THIRD-PTY-READ-DT    
      *                                                                         
           MOVE CUR-AVOID-LPC-DT (WS-COUNT1)  TO S-AVOID-LPC-DATE.      
      *                                                                         
           MOVE SPACES                TO S-FIRST-NOTICE-DATE            
                                         S-DNP-DATE                     
                                         S-IVR-DATE                     
                                         S-SECOND-NOTICE-DATE           
      *                                                                         
           MOVE CUR-CURR-CHG-DUE-DT (WS-COUNT1)                         
                                              TO S-BILL-DUE-DATE        
      *                                                                         
           PERFORM 8200-SEND-R2-RESULT                THRU 8200-EXIT.   
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2600-FORECASTING-BALANCE.                                        
      *================================================================*        
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO BALANCE.                                     
      *                                                                         
           PERFORM 3000-FORMAT-COMMON-DATA    THRU 3000-EXIT.           
                                                                        
           IF CUR-BILL-DT (WS-COUNT1) > SPACES                          
              MOVE CUR-BILL-DT (WS-COUNT1)    TO  S-BILL-DATE           
           ELSE                                                         
              MOVE CUR-BILL-BY (WS-COUNT1)    TO S-BILL-DATE            
           END-IF                                                       
      *                                                                         
      *** GET MAIL DATE                                                         
           MOVE WS-DAY-DUE             TO WS-NO-OF-DAYS                 
           MOVE S-BILL-DATE            TO WS-NEW-BUSINESS-DAY           
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY    TO S-MAIL-DATE.                  
      *                                                                         
           MOVE CUR-OPTIMUM-READ-DT (WS-COUNT1)                         
                                              TO S-READ-DATE.           
           MOVE CUR-THIRD-PTY-READ-DT (WS-COUNT1)                       
                                              TO S-THIRD-PTY-READ-DT    
           MOVE CUR-AVOID-LPC-DT (WS-COUNT1)  TO S-AVOID-LPC-DATE.      
      *                                                                         
      *** GET FIRST NOTICE DATE                                                 
           MOVE CUR-BILL-BY (WS-COUNT1)       TO WS-NEW-BUSINESS-DAY.   
           MOVE WS-DAY-DUE                    TO WS-NO-OF-DAYS          
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY           TO S-FIRST-NOTICE-DATE.   
      *                                                                         
           MOVE CUR-DNP-DT (WS-COUNT1)        TO S-DNP-DATE.            
                                                                        
           MOVE NXT-IVR-CALL-DT (WS-COUNT1)   TO S-IVR-DATE             
           MOVE CUR-DNP-NOTICE-MAIL-DT (WS-COUNT1)                      
                                              TO S-SECOND-NOTICE-DATE.  
           MOVE CUR-CURR-CHG-DUE-DT (WS-COUNT1)                         
                                              TO S-BILL-DUE-DATE        
                                                                        
           PERFORM 8200-SEND-R2-RESULT                THRU 8200-EXIT.   
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2700-FORECASTING-NON-UTIL.                                       
      *================================================================*        
      *                                                                         
           PERFORM 3000-FORMAT-COMMON-DATA    THRU 3000-EXIT.           
                                                                        
           IF CM-COMPANY-NO = '01' AND CSR-DATABASE                     
              MOVE CUR-BILL-FROM (WS-COUNT1)  TO S-BILL-DATE            
           ELSE                                                         
              MOVE CUR-BILL-DT (WS-COUNT1)    TO S-BILL-DATE            
           END-IF.                                                      
           IF S-BILL-DATE > SPACES                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE CUR-BILL-FROM (WS-COUNT1)  TO S-BILL-DATE            
           END-IF                                                       
      *** GET MAIL DATE                                                         
           MOVE WS-DAY-DUE             TO WS-NO-OF-DAYS                 
           MOVE S-BILL-DATE            TO WS-NEW-BUSINESS-DAY           
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY    TO S-MAIL-DATE.                  
      *                                                                         
           MOVE CUR-OPTIMUM-READ-DT (WS-COUNT1)                         
                                              TO S-READ-DATE.           
           MOVE CUR-THIRD-PTY-READ-DT (WS-COUNT1)                       
                                              TO S-THIRD-PTY-READ-DT    
           MOVE CUR-AVOID-LPC-DT (WS-COUNT1)  TO S-AVOID-LPC-DATE       
      *                                                                         
      *** GET FIRST NOTICE DATE                                                 
           MOVE S-AVOID-LPC-DATE              TO WS-NEW-BUSINESS-DAY.   
           MOVE WS-DAY-DUE                    TO WS-NO-OF-DAYS          
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY           TO S-FIRST-NOTICE-DATE.   
      *                                                                         
           MOVE CUR-CURR-CHG-DUE-DT (WS-COUNT1)                         
                                              TO S-BILL-DUE-DATE        
      *                                                                         
           MOVE SPACES                TO S-DNP-DATE                     
                                         S-IVR-DATE                     
                                         S-SECOND-NOTICE-DATE.          
      *                                                                         
           PERFORM 8200-SEND-R2-RESULT                THRU 8200-EXIT.   
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2800-FORECASTING-MASTER.                                         
      *================================================================*        
      *                                                                         
           PERFORM 3000-FORMAT-COMMON-DATA    THRU 3000-EXIT.           
                                                                        
           MOVE CUR-BILL-DT (WS-COUNT1)    TO S-BILL-DATE.              
                                                                        
           IF S-BILL-DATE > SPACES                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE CUR-BILL-FROM (WS-COUNT1)  TO S-BILL-DATE            
           END-IF                                                       
      *** GET MAIL DATE                                                         
           MOVE WS-DAY-DUE             TO WS-NO-OF-DAYS                 
           MOVE S-BILL-DATE            TO WS-NEW-BUSINESS-DAY           
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY    TO S-MAIL-DATE.                  
      *                                                                         
           MOVE CUR-OPTIMUM-READ-DT (WS-COUNT1)                         
                                              TO S-READ-DATE.           
           MOVE CUR-THIRD-PTY-READ-DT (WS-COUNT1)                       
                                              TO S-THIRD-PTY-READ-DT    
           MOVE CUR-AVOID-LPC-DT (WS-COUNT1)  TO S-AVOID-LPC-DATE       
      *                                                                         
      *** GET FIRST NOTICE DATE                                                 
           MOVE S-AVOID-LPC-DATE              TO WS-NEW-BUSINESS-DAY.   
           MOVE WS-DAY-DUE                    TO WS-NO-OF-DAYS          
           IF WS-NEW-BUSINESS-DAY > SPACES                              
              PERFORM 5500-GET-NEXT-BUSINESS-DAY THRU 5500-EXIT         
           END-IF                                                       
           MOVE WS-NEW-BUSINESS-DAY           TO S-FIRST-NOTICE-DATE.   
      *                                                                         
           MOVE CUR-CURR-CHG-DUE-DT (WS-COUNT1)                         
                                              TO S-BILL-DUE-DATE        
      *                                                                         
           MOVE SPACES                TO S-DNP-DATE                     
                                         S-IVR-DATE                     
                                         S-SECOND-NOTICE-DATE.          
      *                                                                         
           PERFORM 8200-SEND-R2-RESULT                THRU 8200-EXIT.   
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       3000-FORMAT-COMMON-DATA.                                         
      *==============================================================*  04450000
                                                                        
           MOVE CUR-BILL-CYCLE (WS-COUNT1)    TO S-BILL-CYCLE.          
      *                                                                         
           MOVE CUR-BILL-FROM (WS-COUNT1)     TO S-BILL-FROM.           
           MOVE CUR-BILL-BY (WS-COUNT1)       TO S-BILL-TO.             
      *                                                                         
           IF CUR-CRED-ACCT-TYPE-CD (WS-COUNT1) = 'X'                   
              MOVE WS-DLFT-REG-GRP-CD    TO S-REG-GROUP-CD              
              MOVE WS-DFLT-CRE-GRP-ID    TO S-CREDIT-GROUP-ID           
              MOVE WS-DLFT-ACC-TYP-CD    TO S-CREDIT-ACCT-TYPE          
           ELSE                                                         
              EVALUATE TRUE                                             
                 WHEN CUR-REG-GROUP-CD (WS-COUNT1) = '100'              
                      MOVE 'GRP1'                TO S-REG-GROUP-CD      
                 WHEN CUR-REG-GROUP-CD (WS-COUNT1) = '200'              
                      MOVE 'GRP2'                TO S-REG-GROUP-CD      
                 WHEN CUR-REG-GROUP-CD (WS-COUNT1) = '   '              
                      MOVE 'DREG'                TO S-REG-GROUP-CD      
              END-EVALUATE                                              
                                                                        
              IF CUR-CREDIT-GROUP-ID  (WS-COUNT1) = 'DPP'               
                 MOVE 'D'                        TO S-CREDIT-GROUP-ID   
              ELSE                                                      
                 MOVE 'N'                        TO S-CREDIT-GROUP-ID   
              END-IF                                                    
              MOVE CUR-CRED-ACCT-TYPE-CD (WS-COUNT1)                    
                                                 TO S-CREDIT-ACCT-TYPE  
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       5500-GET-NEXT-BUSINESS-DAY.                                      
      *==============================================================*  04450000
                                                                        
           SET WD-INDX TO 1.                                            
                                                                        
           SEARCH ALL WS-WORK-DAY-LIST                                  
              AT END                                                    
                PERFORM 7730-GET-NEXT-BUSINESS-DAY THRU 7730-EXIT       
                                                                        
              WHEN WS-WORK-DAY (WD-INDX) = WS-NEW-BUSINESS-DAY          
                                                                        
                SET WD-INDX UP BY WS-NO-OF-DAYS                         
                MOVE WS-WORK-DAY (WD-INDX)    TO WS-NEW-BUSINESS-DAY    
                MOVE  1                       TO WS-NO-OF-DAYS          
                                                                        
           END-SEARCH.                                                  
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       5520-GET-PREV-BUSINESS-DAY.                                      
      *==============================================================*  04450000
                                                                        
           SET WD-INDX TO 1.                                            
                                                                        
           SEARCH ALL WS-WORK-DAY-LIST                                  
              AT END                                                    
                PERFORM 7740-GET-PREV-BUSINESS-DAY THRU 7740-EXIT       
                                                                        
              WHEN WS-WORK-DAY (WD-INDX) = WS-NEW-BUSINESS-DAY          
                                                                        
                SET WD-INDX DOWN BY WS-NO-OF-DAYS                       
                MOVE WS-WORK-DAY (WD-INDX)    TO WS-NEW-BUSINESS-DAY    
                MOVE  1                       TO WS-NO-OF-DAYS          
                                                                        
           END-SEARCH.                                                  
                                                                        
       5520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-OPEN-WSCH-CUR1.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN WSCH_CUR1                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
              MOVE  CM-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1          
              MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-2            
              MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-2          
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
              MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
              MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7110-FETCH-WSCH-CUR1.                                            

MSQ008     MOVE 450 TO MSQ008-WSCH-CUR1
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-WSCH-CUR1
              FETCH 
              FROM WSCH_CUR1             
                INTO :CUR-BILL-CYCLE                                    
                    ,:CUR-BILL-FROM                                     
                    ,:CUR-BILL-BY                                       
                    ,:CUR-OPTIMUM-READ-DT                               
                    ,:CUR-THIRD-PTY-READ-DT                             
                    ,:CUR-REG-GROUP-CD                                  
                    ,:CUR-CREDIT-GROUP-ID                               
                    ,:CUR-CRED-ACCT-TYPE-CD                             
                    ,:CUR-BILL-DT                                       
                    ,:CUR-CURR-CHG-DUE-DT                               
                    ,:CUR-AVOID-LPC-DT                                  
                    ,:CUR-DNP-NOTICE-MAIL-DT                            
                    ,:CUR-DNP-DT                                        
                    ,:NXT-BILL-FROM                                     
                    ,:NXT-BILL-BY                                       
                    ,:NXT-OPTIMUM-READ-DT                               
                    ,:NXT-CURR-CHG-DUE-DT                               
                    ,:NXT-DNP-NOTICE-MAIL-DT                            
                    ,:NXT-DNP-DT                                        
                    ,:NXT-IVR-CALL-DT                                   
                    ,:NXT-AVOID-LPC-DT                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM WSCH_CUR1 FOR 450 ROWS                    
MFA-TR*         INTO :CUR-BILL-CYCLE                                            
MFA-TR*             ,:CUR-BILL-FROM                                             
MFA-TR*             ,:CUR-BILL-BY                                               
MFA-TR*             ,:CUR-OPTIMUM-READ-DT                                       
MFA-TR*             ,:CUR-THIRD-PTY-READ-DT                                     
MFA-TR*             ,:CUR-REG-GROUP-CD                                          
MFA-TR*             ,:CUR-CREDIT-GROUP-ID                                       
MFA-TR*             ,:CUR-CRED-ACCT-TYPE-CD                                     
MFA-TR*             ,:CUR-BILL-DT                                               
MFA-TR*             ,:CUR-CURR-CHG-DUE-DT                                       
MFA-TR*             ,:CUR-AVOID-LPC-DT                                          
MFA-TR*             ,:CUR-DNP-NOTICE-MAIL-DT                                    
MFA-TR*             ,:CUR-DNP-DT                                                
MFA-TR*             ,:NXT-BILL-FROM                                             
MFA-TR*             ,:NXT-BILL-BY                                               
MFA-TR*             ,:NXT-OPTIMUM-READ-DT                                       
MFA-TR*             ,:NXT-CURR-CHG-DUE-DT                                       
MFA-TR*             ,:NXT-DNP-NOTICE-MAIL-DT                                    
MFA-TR*             ,:NXT-DNP-DT                                                
MFA-TR*             ,:NXT-IVR-CALL-DT                                           
MFA-TR*             ,:NXT-AVOID-LPC-DT                                          
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WSCH-CUR1
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD (3)        TO WS-WSCH-ROW-COUNT1             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-R2            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CRED_FORECAST'   TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE CM-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1           
              MOVE 'CRED_FORECAST_CD'    TO TABLE-ELEMENT-2             
              MOVE CM-CRED-FORECAST-CD   TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE CM-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7120-CLOSE-WSCH-CUR1.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE WSCH_CUR1                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
              MOVE CM-REVENUE-MONTH       TO HOSTVAR-ELEMENT-1          
              MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-2            
              MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-2          
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
              MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7003-GET-MIN-MAX-REV-MONTH.                                      
      *================================================================*        
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                 MIN(REVENUE_MONTH)                                     
                ,MAX(REVENUE_MONTH)                                     
              INTO                                                      
                 :WS-MIN-REV-MONTH :WS-NULL-1                           
                ,:WS-MAX-REV-MONTH :WS-NULL-2                           
              FROM                                                      
                 CSS_BILL_WINDOW WITH(READUNCOMMITTED)                          
              WHERE BILL_CYCLE     = '01'                               
                AND REVENUE_MONTH > 201012                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          MIN(REVENUE_MONTH)                                             
MFA-TR*         ,MAX(REVENUE_MONTH)                                             
MFA-TR*       INTO                                                              
MFA-TR*          :WS-MIN-REV-MONTH :WS-NULL-1                                   
MFA-TR*         ,:WS-MAX-REV-MONTH :WS-NULL-2                                   
MFA-TR*       FROM                                                              
MFA-TR*          CSS_BILL_WINDOW                                                
MFA-TR*       WHERE BILL_CYCLE     = '01'                                       
MFA-TR*         AND REVENUE_MONTH > 201012                                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7003                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-R2       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
              MOVE '01'                       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7004-GET-CURRENT-REV-MONTH.                                      
      *================================================================*        
                                                                        
           MOVE '7004'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REVENUE_MONTH                                       
              INTO                                                      
                 :BN-REVENUE-MONTH                                      
              FROM                                                      
                 CSS_BILL_WINDOW WITH(READUNCOMMITTED)                          
              WHERE                                                     
                 DATE_EXTRACT    <= CAST(SYSDATETIMEOFFSET() AS DATE)           
              ORDER BY DATE_EXTRACT DESC                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          REVENUE_MONTH                                                  
MFA-TR*       INTO                                                              
MFA-TR*          :BN-REVENUE-MONTH                                              
MFA-TR*       FROM                                                              
MFA-TR*          CSS_BILL_WINDOW                                                
MFA-TR*       WHERE                                                             
MFA-TR*          DATE_EXTRACT    <= CURRENT DATE                                
MFA-TR*       ORDER BY DATE_EXTRACT DESC                                        
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7004                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE-R2       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-1        
              MOVE  BN-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7005-OPEN-DELINQ-CSR.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN DELINQUENCY_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7005'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7006-FETCH-DELINQ-CSR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                  DELINQUENCY_CSR                                       
               INTO                                                     
                  :C8-DELINQ-CD,                                        
                  :C8-DELINQ-VALUE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7006'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
              MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
              MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7007-CLOSE-DELINQ-CSR.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE DELINQUENCY_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R2           
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7007'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELIQUENCY'       TO TABLE-1                    
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7007-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17930000
      *================================================================*        
       7050-GET-EQP-ATTCHMTS-DESC.                                      
      *================================================================*        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
                INTO :WS-CODE-SHORT-DESC                                
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO    = :WS-COMPANY-NO                     
                 AND TABLE_NA      = 'WORK_SCHEDULE'                    
                 AND COLUMN_NA     = 'CRE_GRP_ACC_DFLTS'                
                 AND CODE_VALUE    = :WS-CREDIT-GROUP                   
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*         INTO :WS-CODE-SHORT-DESC                                        
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COMPANY_NO    = :WS-COMPANY-NO                             
MFA-TR*          AND TABLE_NA      = 'WORK_SCHEDULE'                            
MFA-TR*          AND COLUMN_NA     = 'CRE_GRP_ACC_DFLTS'                        
MFA-TR*          AND CODE_VALUE    = :WS-CREDIT-GROUP                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC                                                     17980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17990000
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-R1           
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7050'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CODE_VALUE '    TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_VALUE'         TO TABLE-ELEMENT-2              
              MOVE 'COLUMN_NA'          TO TABLE-ELEMENT-3              
              MOVE WS-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE WS-CREDIT-GROUP      TO HOSTVAR-ELEMENT-2            
              MOVE 'CRE_GRP_ACC_DFLTS'  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 18150000
      *                                                                 18160000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7220-OPEN-WORK-DAY-CSR.                                          
      *==============================================================*          
                                                                        
           EXEC SQL                                                     
              OPEN WORK-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7220'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7230-FETCH-WORK-DAY-CSR.                                         

MSQ008     MOVE 120 TO MSQ008-WORK-CUR
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              FOR :MSQ008-WORK-CUR
              FETCH 
              FROM WORK-CUR               
               INTO :WS-BUSI-DAY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH NEXT ROWSET FROM WORK-CUR FOR 120 ROWS                      
MFA-TR*        INTO :WS-BUSI-DAY                                                
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WORK-CUR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7230'                  TO ACTIVE-PARAGRAPH          
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7240-CLOSE-WORK-DAY-CSR.                                         
      *==============================================================*          
      *                                                                         
           EXEC SQL                                                     
              CLOSE WORK-CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 00020009
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7240'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS_DAY_DT'       TO TABLE-ELEMENT-1           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       7730-GET-NEXT-BUSINESS-DAY.                                      
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MIN(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT >                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) - 1 + 
                                                         :WS-NO-OF-DAYS 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MIN(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT >                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) - 1 + :WS-NO-OF-DAYS         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAYS             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '7730'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAYS           TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*  04450000
       7740-GET-PREV-BUSINESS-DAY.                                      
      *==============================================================*  04450000
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MAX(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT <                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) + 1 - 
                                                         :WS-NO-OF-DAYS 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MAX(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT <                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) + 1 - :WS-NO-OF-DAYS         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAYS             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '7740'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAYS           TO HOSTVAR-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 07599100
       8100-SEND-R1-RESULT.                                             
      *===============================================================* 07599100
      *                                                                         
           MOVE PARM-COMPANY-NO        TO      S-COMPANY-NO             
           MOVE PARM-REV-YEAR          TO      S-BILL-YEAR              
           MOVE PARM-REV-MONTH         TO      S-BILL-MONTH             
           MOVE PARM-CR-GROUP          TO      S-CREDIT-GROUP           
           MOVE WS-DFLT-CRE-GRP-ID     TO      S-CREDIT-GROUP-ID-DF     
           MOVE WS-DLFT-ACC-TYP-CD     TO      S-CREDIT-ACCT-TYPE-DF    
           MOVE WS-DLFT-REG-GRP-CD     TO      S-REG-GROUP-CD-DF        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO #CSR04579_R1                          
                  (                                                     
                    RETURN_CODE_R1                                      
                   ,APPL_RETURN_CODE_R1                                 
                   ,COMPANY_NO                                          
                   ,CREDIT_GROUP                                        
                   ,BILL_YEAR_START                                     
                   ,BILL_MONTH_START                                    
                   ,BILL_YEAR_END                                       
                   ,BILL_MONTH_END                                      
                   ,BILL_YEAR                                           
                   ,BILL_MONTH                                          
                   ,REG_GROUP_CD_DF                                     
                   ,CREDIT_GROUP_ID_DF                                  
                   ,CREDIT_ACCT_TYPE_DF                                 
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-R1                                   
                   ,:S-APPL-RETURN-CODE-R1                              
                   ,:S-COMPANY-NO                                       
                   ,:S-CREDIT-GROUP                                     
                   ,:S-BILL-YEAR-START                                  
                   ,:S-BILL-MONTH-START                                 
                   ,:S-BILL-YEAR-END                                    
                   ,:S-BILL-MONTH-END                                   
                   ,:S-BILL-YEAR                                        
                   ,:S-BILL-MONTH                                       
                   ,:S-REG-GROUP-CD-DF                                  
                   ,:S-CREDIT-GROUP-ID-DF                               
                   ,:S-CREDIT-ACCT-TYPE-DF                              
                  )                                                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04579_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE_R1                                              
MFA-TR*            ,APPL_RETURN_CODE_R1                                         
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CREDIT_GROUP                                                
MFA-TR*            ,BILL_YEAR_START                                             
MFA-TR*            ,BILL_MONTH_START                                            
MFA-TR*            ,BILL_YEAR_END                                               
MFA-TR*            ,BILL_MONTH_END                                              
MFA-TR*            ,BILL_YEAR                                                   
MFA-TR*            ,BILL_MONTH                                                  
MFA-TR*            ,REG_GROUP_CD_DF                                             
MFA-TR*            ,CREDIT_GROUP_ID_DF                                          
MFA-TR*            ,CREDIT_ACCT_TYPE_DF                                         
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-R1                                           
MFA-TR*            ,:S-APPL-RETURN-CODE-R1                                      
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-CREDIT-GROUP                                             
MFA-TR*            ,:S-BILL-YEAR-START                                          
MFA-TR*            ,:S-BILL-MONTH-START                                         
MFA-TR*            ,:S-BILL-YEAR-END                                            
MFA-TR*            ,:S-BILL-MONTH-END                                           
MFA-TR*            ,:S-BILL-YEAR                                                
MFA-TR*            ,:S-BILL-MONTH                                               
MFA-TR*            ,:S-REG-GROUP-CD-DF                                          
MFA-TR*            ,:S-CREDIT-GROUP-ID-DF                                       
MFA-TR*            ,:S-CREDIT-ACCT-TYPE-DF                                      
MFA-TR*           )                                                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS-R1                                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04579_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT   
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 07599100
       8200-SEND-R2-RESULT.                                             
      *===============================================================* 07599100
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO #CSR04579_R2                          
                   (RETURN_CODE_R2                                      
                   ,BILL_CYCLE                                          
                   ,REG_GROUP_CD                                        
                   ,CREDIT_GROUP_ID                                     
                   ,CREDIT_ACCT_TYPE                                    
                   ,OPTIMUM_READ_DATE                                   
                   ,BILL_FROM_DATE                                      
                   ,BILL_BY_DATE                                        
                   ,BILL_DATE                                           
                   ,MAIL_DATE                                           
                   ,DUE_DATE                                            
                   ,LPC_DATE                                            
                   ,FIRST_NOTICE_DATE                                   
                   ,SECOND_NOTICE_DATE                                  
                   ,IVR_DATE                                            
                   ,DNP_DATE                                            
                   ,THIRD_PARTY_DATE )                                  
               VALUES                                                   
               (   :S-RETURN-CODE-R2                                    
                  ,:S-BILL-CYCLE                                        
                  ,:S-REG-GROUP-CD                                      
                  ,:S-CREDIT-GROUP-ID                                   
                  ,:S-CREDIT-ACCT-TYPE                                  
                  ,:S-READ-DATE                                         
                  ,:S-BILL-FROM                                         
                  ,:S-BILL-TO                                           
                  ,:S-BILL-DATE                                         
                  ,:S-MAIL-DATE                                         
                  ,:S-BILL-DUE-DATE                                     
                  ,:S-AVOID-LPC-DATE                                    
                  ,:S-FIRST-NOTICE-DATE                                 
                  ,:S-SECOND-NOTICE-DATE                                
                  ,:S-IVR-DATE                                          
                  ,:S-DNP-DATE                                          
                  ,:S-THIRD-PTY-READ-DT                                 
               )                                                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04579_R2                                  
MFA-TR*            (RETURN_CODE_R2                                              
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,REG_GROUP_CD                                                
MFA-TR*            ,CREDIT_GROUP_ID                                             
MFA-TR*            ,CREDIT_ACCT_TYPE                                            
MFA-TR*            ,OPTIMUM_READ_DATE                                           
MFA-TR*            ,BILL_FROM_DATE                                              
MFA-TR*            ,BILL_BY_DATE                                                
MFA-TR*            ,BILL_DATE                                                   
MFA-TR*            ,MAIL_DATE                                                   
MFA-TR*            ,DUE_DATE                                                    
MFA-TR*            ,LPC_DATE                                                    
MFA-TR*            ,FIRST_NOTICE_DATE                                           
MFA-TR*            ,SECOND_NOTICE_DATE                                          
MFA-TR*            ,IVR_DATE                                                    
MFA-TR*            ,DNP_DATE                                                    
MFA-TR*            ,THIRD_PARTY_DATE )                                          
MFA-TR*        VALUES                                                           
MFA-TR*        (   :S-RETURN-CODE-R2                                            
MFA-TR*           ,:S-BILL-CYCLE                                                
MFA-TR*           ,:S-REG-GROUP-CD                                              
MFA-TR*           ,:S-CREDIT-GROUP-ID                                           
MFA-TR*           ,:S-CREDIT-ACCT-TYPE                                          
MFA-TR*           ,:S-READ-DATE                                                 
MFA-TR*           ,:S-BILL-FROM                                                 
MFA-TR*           ,:S-BILL-TO                                                   
MFA-TR*           ,:S-BILL-DATE                                                 
MFA-TR*           ,:S-MAIL-DATE                                                 
MFA-TR*           ,:S-BILL-DUE-DATE                                             
MFA-TR*           ,:S-AVOID-LPC-DATE                                            
MFA-TR*           ,:S-FIRST-NOTICE-DATE                                         
MFA-TR*           ,:S-SECOND-NOTICE-DATE                                        
MFA-TR*           ,:S-IVR-DATE                                                  
MFA-TR*           ,:S-DNP-DATE                                                  
MFA-TR*           ,:S-THIRD-PTY-READ-DT                                         
MFA-TR*        )                                                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS-R2                                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04579_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT   
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 07599100
       8800-CHECK-RESULTS.                                              
      *===============================================================* 07599100
                                                                        
           IF CTR-ROWS-R1 <= 0                                          
              INITIALIZE                    GTT-RETURN-FIELDS-R1        
              MOVE   100                 TO S-RETURN-CODE-R1            
                                            S-APPL-RETURN-CODE-R1       
              PERFORM 8100-SEND-R1-RESULT    THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-R2  <= 0                                         
              INITIALIZE                    GTT-RETURN-FIELDS-R2        
              MOVE 100                   TO S-RETURN-CODE-R2            
              PERFORM 8200-SEND-R2-RESULT   THRU 8200-EXIT              
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *===============================================================* 07599100
       8900A-DELETE-GTT-ROWS.                                           
      *===============================================================* 07599100
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04579_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04579_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE 100                  TO S-RETURN-CODE-R1            
               MOVE ZERO                 TO CTR-ROWS-R2                 
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8900A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04579_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8900A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *===============================================================* 07599100
       8900B-DELETE-GTT-ROWS.                                           
      *===============================================================* 07599100
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04579_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04579_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE 100                  TO S-RETURN-CODE-R2            
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8900B'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04579_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8900B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *===============================================================* 07599100
       8900-SEND-DONE.                                                  
      *===============================================================* 07599100
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE '8900'                      TO ACTIVE-PARAGRAPH.        
           MOVE 'OPEN'                      TO ABEND-FUNCTION.          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04579_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04579_R2'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *                                                                         
      *===============================================================* 07599100
       9000-SEND-ERROR-RESULT.                                          
      *===============================================================* 07599100
                                                                        
           INITIALIZE                          GTT-RETURN-FIELDS.       
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
           MOVE 100                         TO S-RETURN-CODE-R1         
                                               S-RETURN-CODE-R2         
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100B-DECLARE-GTT           THRU 0100B-EXIT.         
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
           PERFORM 8100-SEND-R1-RESULT         THRU 8100-EXIT.          
           PERFORM 8200-SEND-R2-RESULT         THRU 8200-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* 07599100
       9999-END-PROGRAM.                                                
      *===============================================================* 07599100
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *       END OF PROGRAM                                           *        
      ******************************************************************        
