       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04578.                                            
       DATE-WRITTEN. NOV 26  2012.                                      
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM DETERMINES THE ELIGIBILITY CRITERIA OF A CUSTOMER *        
      * FOR THE DIFFERENT SERVICE PROMOTIONS.                          *        
      *                                                                *        
      * ALSO RETRIEVES THE CUSTOMER INFORMATION FOR THE WEB FOR THE    *        
      * GUID PASSED AND VALIDATES THE ELIGIBILTY.                      *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
I00483*  11/26/12  VV90387    INITIAL CODE.                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04578'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04578 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT           (PREFIX = AT)                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUSTOMER         (PREFIX = CU)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_STATS       (PREFIX = CE)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUST_EMAIL       (PREFIX = NE)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SERVICE_PROMO    (PREFIX = 3A)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSERPRM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY    (PREFIX = C8)                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04578'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-CALLING-SYSTEM     PIC X(03) VALUE SPACES.          
           05  PARM-ACTIVATION-ID      PIC X(32) VALUE SPACES.          
           05  PARM-CUSTOMER-NO        PIC X(10) VALUE SPACES.          
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
           05  PARM-CUSTOMER-NUM       PIC S9(10)V COMP-3 VALUE 0.      
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-ACCOUNT-NUM        PIC S9(13)V COMP-3 VALUE 0.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-WEB                  PIC X(03) VALUE 'WEB'.           
           05  WS-CSR                  PIC X(03) VALUE 'CSR'.           
           05  WS-VALID-CUSTOMER       PIC X(01) VALUE 'N'.             
           05  WS-CUSTOMER-PROMO       PIC X(01) VALUE 'N'.             
           05  WS-ALREADY-ENROLLED     PIC S9(9) COMP VALUE 100.        
           05  WS-PROMO-ONLINE-ENROLL  PIC X(25) VALUE                  
                                       'PROMO_ONLINE_ENROLL'.           
                                                                        
       01  WS-HOLD-PARMS.                                               
           05  WS-CUSTOMER-NO          PIC S9(10)V COMP-3 VALUE 0.      
           05  WS-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.      
           05  WS-PROMO-OFFERED-SERV   PIC X(25) VALUE SPACES.          
           05  WS-PROMO-OFFERED-DT     PIC X(10) VALUE SPACES.          
           05  WS-CHK-EXP-DAYS         PIC S9(4)V COMP-3 VALUE 0.       
           05  WS-ELIG-FL              PIC X(01) VALUE SPACES.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE         PIC S9(9) COMP VALUE 0.            
           05  S-CUSTOMER-NO         PIC X(10)      VALUE SPACES.       
           05  S-ACCOUNT-NO          PIC X(13)      VALUE SPACES.       
           05  S-SSN                 PIC X(05)      VALUE SPACES.       
           05  S-PROMO-EMAIL-ADDR    PIC X(100)     VALUE SPACES.       
           05  S-ONLINE-ELIG-FL      PIC X(01)      VALUE 'N'.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01)      VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW           PIC X(01)      VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18)       VALUE SPACES.  
           10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.       
           10  S-SQLSTATE                PIC X(5)        VALUE ' '.     
           10  S-TABLE-NAME              PIC X(18)       VALUE SPACES.  
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-RETURN-CODE            PIC S9(9) COMP  VALUE 0.       
           10  WS-SQLSTATE               PIC X(05)       VALUE SPACES.  
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CALLING-SYSTEM           PIC X(03).                     
       01  LINK-ACTIVATION-ID            PIC X(32).                     
       01  LINK-CUSTOMER-NO              PIC X(10).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
                                                                        
       PROCEDURE DIVISION USING          LINK-CALLING-SYSTEM            
                                        ,LINK-ACTIVATION-ID             
                                        ,LINK-CUSTOMER-NO               
                                        ,LINK-ACCOUNT-NO.               
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. DECLARE CURSOR                                          *        
      *     2. RECEIVE INPUT PARAMETRS                                 *        
      *     3. INITIALIZE OUTPUT PARAMETERS                            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE         AS RETURN_CODE              
                    ,:S-CUSTOMER-NO         AS CUSTOMER_NO              
                    ,:S-ACCOUNT-NO          AS ACCOUNT_NO               
                    ,:S-SSN                 AS SSN                      
                    ,LTRIM(RTRIM(:S-PROMO-EMAIL-ADDR)) AS 
           PROMO_EMAIL_ADDR     
                    ,:S-ONLINE-ELIG-FL      AS ONLINE_ELIG_FL           
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*             ,:S-CUSTOMER-NO         AS CUSTOMER_NO                      
MFA-TR*             ,:S-ACCOUNT-NO          AS ACCOUNT_NO                       
MFA-TR*             ,:S-SSN                 AS SSN                              
MFA-TR*             ,STRIP(:S-PROMO-EMAIL-ADDR) AS PROMO_EMAIL_ADDR             
MFA-TR*             ,:S-ONLINE-ELIG-FL      AS ONLINE_ELIG_FL                   
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
                                 MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.       
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
                                 MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.        
                                                                        
           MOVE LINK-CALLING-SYSTEM          TO PARM-CALLING-SYSTEM.    
           MOVE LINK-ACTIVATION-ID           TO PARM-ACTIVATION-ID.     
           MOVE LINK-CUSTOMER-NO             TO PARM-CUSTOMER-NO.       
           MOVE LINK-ACCOUNT-NO              TO PARM-ACCOUNT-NO.        
                                                                        
           INITIALIZE                           S-RETURN-CODE           
                                                S-CUSTOMER-NO           
                                                S-ACCOUNT-NO            
                                                S-SSN                   
                                                S-PROMO-EMAIL-ADDR      
                                                S-ONLINE-ELIG-FL.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-CUSTOMER-NO-RED          TO PARM-CUSTOMER-NUM.     
           MOVE PARM-ACCOUNT-NO-RED           TO PARM-ACCOUNT-NUM.      
           MOVE PARM-CUSTOMER-NUM             TO WS-CUSTOMER-NO.        
           MOVE PARM-ACCOUNT-NUM              TO WS-ACCOUNT-NO.         
           MOVE PARM-ACTIVATION-ID            TO 3A-PROMO-ACTIVATE-ID.  
                                                                        
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF PARM-CALLING-SYSTEM   = WS-WEB                            
              PERFORM 3000-VALIDATE-GUID      THRU 3000-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-VALIDATE-GUID                                             *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       3000-VALIDATE-GUID.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           PERFORM 7000-GET-GUID-DETAILS        THRU 7000-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 3A-CUSTOMER-NO               TO S-CUSTOMER-NO        
                                                   WS-CUSTOMER-NO       
              MOVE 3A-ACCOUNT-NO                TO S-ACCOUNT-NO         
              MOVE 3A-PROMO-EMAIL-ADDR-TEXT     TO S-PROMO-EMAIL-ADDR   
              IF WS-CUSTOMER-NO > 0                                     
                  PERFORM 7100-GET-CUSTOMER-DETAILS THRU 7100-EXIT      
              END-IF                                                    
              PERFORM 7200-CHECK-ONLINE-ENROLLED THRU 7200-EXIT         
              IF CE-EBILL-REGISTER-IND = WS-YES                         
                 MOVE WS-ALREADY-ENROLLED       TO S-RETURN-CODE        
              ELSE                                                      
                 PERFORM 8000-UPDATE-SERVICE-PROMO   THRU 8000-EXIT     
              END-IF
           END-IF.                                                   
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-GUID-DETAILS                                          *        
      *     GETS GUID CUSTOMER/ACCOUNT INFO                            *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-GET-GUID-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     PROMO_EMAIL_ADDR                                   
                INTO :3A-CUSTOMER-NO,                                   
                     :3A-ACCOUNT-NO,                                    
                     :3A-PROMO-EMAIL-ADDR                               
                FROM CSS_SERVICE_PROMO WITH(READUNCOMMITTED)                    
               WHERE PROMO_ACTIVATE_ID  = :3A-PROMO-ACTIVATE-ID         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              PROMO_EMAIL_ADDR                                           
MFA-TR*         INTO :3A-CUSTOMER-NO,                                           
MFA-TR*              :3A-ACCOUNT-NO,                                            
MFA-TR*              :3A-PROMO-EMAIL-ADDR                                       
MFA-TR*         FROM CSS_SERVICE_PROMO                                          
MFA-TR*        WHERE PROMO_ACTIVATE_ID  = :3A-PROMO-ACTIVATE-ID                 
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SERVICE_PROMO'        TO TABLE-1                
              MOVE 'PROMO_ACTIVATE_ID'        TO TABLE-ELEMENT-1        
              MOVE 3A-PROMO-ACTIVATE-ID       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-CUSTOMER-DETAILS                                      *        
      *     GETS THE CUSTOMER SSN                                      *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-GET-CUSTOMER-DETAILS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT SSN                                                
                INTO :CE-SSN                                            
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO        = :WS-CUSTOMER-NO               
                 AND CUSTOMER_TYPE      = 'C'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN                                                        
MFA-TR*         INTO :CE-SSN                                                    
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO        = :WS-CUSTOMER-NO                       
MFA-TR*          AND CUSTOMER_TYPE      = 'C'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CE-SSN(6:4) TO S-SSN                            
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                      ABEND-TABLES      
                   MOVE 'CSS_CUST_STATS'      TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CHECK-ONLINE-ENROLLED                                     *        
      *     CHECKS IF THE CUSTOMER HAS AN ONLINE ACCOUNT               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7200-CHECK-ONLINE-ENROLLED.                                      
                                                                        
           EXEC SQL                                                     
              SELECT EBILL_REGISTER_IND                                 
                INTO :CE-EBILL-REGISTER-IND                             
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO       = :WS-CUSTOMER-NO                
                 AND CUSTOMER_TYPE     = 'C'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :CE-EBILL-REGISTER-IND                                     
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO       = :WS-CUSTOMER-NO                        
MFA-TR*          AND CUSTOMER_TYPE     = 'C'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_STATS'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE-SERVICE-PROMO                                      *        
      *     UPDATES CSS_SERVICE_PROMO IF GUID EXISTS                   *        
      *                                                                *        
      *     CALLED BY:  3000-VALIDATE-GUID                             *        
      ******************************************************************        
       8000-UPDATE-SERVICE-PROMO.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SERVICE_PROMO                                  
                SET PROMO_REGISTER_FL = 'R'                             
               WHERE PROMO_ACTIVATE_ID  = :3A-PROMO-ACTIVATE-ID         
                AND PROMO_REGISTER_FL = ' '                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SERVICE_PROMO                                          
MFA-TR*         SET PROMO_REGISTER_FL = 'R'                                     
MFA-TR*        WHERE PROMO_ACTIVATE_ID  = :3A-PROMO-ACTIVATE-ID                 
MFA-TR*         AND PROMO_REGISTER_FL = ' '                                     
MFA-TR*        QUERYNO 8000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SERVICE_PROMO'        TO TABLE-1                
              MOVE 'PROMO_ACTIVATE_ID'        TO TABLE-ELEMENT-1        
              MOVE 3A-PROMO-ACTIVATE-ID       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
