       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04577.                                         
COB303 DATE-WRITTEN.  NOV 28, 2012                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES THE  RATE GROUP ,OFFER AND 12 MONTHS *        
      *  THERM PRICE FOR THE RELATED OPTION.                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00610*  28/11/12  MS93554    PROCEDURE ORIGINALLY CODED.              *        
ACT170*  10/14/13  BD09555    INCREASE OFFER DESCRIPTION LENGTH TO 255 *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04577'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04577 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * CRM_RT_PKG_OFFER,   FG                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_RT_PKG_OPTION , FI                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_OFFER_OPTION,   E9                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_JOB_PARM,       G6                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DELINQUENCY,    C8                                                  
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    SUPPORT FOR MCSCB063                                                 
      *****************************************************************         
           COPY CWS00063.                                                       
                                                                        
      ******************************************************************        
      *  WORK AREA                                                     *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04577'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  MCSCB063                 PIC X(08) VALUE 'MCSCB063'.     
           05  WS-MCSCB063-RET-CODE     PIC S9(04) COMP VALUE 0.        
           05  WS-MONTH-COUNT           PIC S9(04) COMP VALUE 0.        
           05  WS-COMMON-DATE           PIC X(10) VALUE SPACES.         
           05  WS-ZERO                  PIC S9(04) COMP VALUE 0.        
           05  WS-OFFER-CD              PIC X(12) VALUE SPACES.         
           05  WS-PRICE-HISTORY-FL      PIC X(01) VALUE SPACES.         
           05  WS-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.        
           05  WS-PRICE-EFF-DATE        PIC X(10) VALUE SPACES.         
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-TOTAL-COUNT-DLINQ-CD  PIC X(19)                       
                                           VALUE 'PRICE-HIST-DUR-MTHS'. 
                                                                        
       01  WS-EFF-MTH-DATE.                                             
           05  WS-EFF-MTH-YR            PIC 9(04).                      
           05  WS-DASH1                 PIC X(01).                      
           05  WS-EFF-MTH-MM            PIC 9(02).                      
           05  WS-DASH2                 PIC X(01).                      
           05  WS-EFF-MTH-DD            PIC 9(02).                      
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS           PIC X(01) VALUE 'N'.            
              88 NO-MORE-ROWS                     VALUE 'Y'.            
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                 PIC X(26)                       
                                            VALUE 'SESSION.CSR04577_R1'.
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN           PIC S9(04) COMP.                
               49 GTT-ROW-CHAR          PIC X(1024).                    
           05  GTT-SQLCODE              PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
           05  SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS-RS1             PIC S9(9) COMP VALUE 0.         
           05  CTR-ROWS-RS2             PIC S9(9) COMP VALUE 0.         
           05  CTR-ROWS-RS3             PIC S9(9) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE               PIC S9(04) COMP VALUE 0.      
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-1     PIC S9(09) COMP VALUE 0.      
              10 S-RS1-OFFER-CD           PIC X(12).                    
              10 S-RS1-OFFER-DESC-EXT-LNG.                              
                 49 S-RS1-OFFER-DESC-EXT-LNG-LEN                        
                                          PIC S9(4)  USAGE COMP.        
                 49 S-RS1-OFFER-DESC-EXT-LNG-TEXT                       
                                          PIC X(255).                   
                                                                        
           05 GTT-RETURN-FIELDS-2.                                      
              10 S-RETURN-CODE-2          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-2     PIC S9(09) COMP VALUE 0.      
              10 S-RS2-OFFER-CD           PIC X(12).                    
              10 S-RS2-OPTION-CD          PIC X(12).                    
              10 S-RS2-CURR-EXT-DESC-LONG.                              
                 49 S-RS2-CURR-EXT-DESC-LONG-LEN                        
                                          PIC S9(4) USAGE COMP.         
                 49 S-RS2-CURR-EXT-DESC-LONG-TEXT                       
                                          PIC X(255).                   
              10 S-RS2-OPTION-SORT-SEQ-NO PIC S9(04) COMP VALUE 0.      
COB305        10 S-RS2-THERM-PRICE        PIC S9(5)V9(6) USAGE COMP-3 
COB305           VALUE 0.  
COB305        10 S-RS2-CSC-AMOUNT        PIC S9(5)V9(6) USAGE COMP-3 
COB305           VALUE 0.  
                                                                        
           05 GTT-RETURN-FIELDS-3.                                      
              10 S-RETURN-CODE-3          PIC S9(09) COMP VALUE 0.      
              10 S-APPL-RETURN-CODE-3     PIC S9(09) COMP VALUE 0.      
              10 S-RS3-OPTION-CD          PIC X(12).                    
              10 S-RS3-PRICE-EFF-DATE     PIC X(10).                    
COB305        10 S-RS3-THERM-PRICE        PIC S9(5)V9(6) USAGE COMP-3 
COB305           VALUE 0.  
                                                                        
      ******************************************************************        
      * GETTING THE OFFER MARKET TIER DETAILS BASED ON THE DEFAULT FLAG*        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE OFFER_DETAILS_CUR CURSOR FOR                      
               SELECT FG.OFFER_CD                                       
                     ,FG.OFFER_DESC_EXT_LNG                             
                     ,FI.OPTION_CD                                      
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,E9.OPTION_SORT_SEQ_NO                             
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                     ,CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                 
                WHERE FG.OFFER_CD               = :FG-OFFER-CD          
                  AND FG.OFFER_START_DT        <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND FG.OFFER_END_DT          >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND FG.OFF_VSTART_TS         <= 
           CIS.CURRENT$TIMESTAMP()     
                  AND FG.OFF_VEND_TS           >= 
           CIS.CURRENT$TIMESTAMP()     
                  AND FG.PROC_STATUS_CD         = 'AC'                  
                  AND FG.OFFER_CD               = E9.OFFER_CD           
                  AND E9.OFFER_OPT_START_DT    <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND E9.OFFER_OPT_END_DT      >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND E9.OFF_OPT_VSTART_TS     <= 
           CIS.CURRENT$TIMESTAMP()     
                  AND E9.OFF_OPT_VEND_TS       >= 
           CIS.CURRENT$TIMESTAMP()     
                  AND E9.PROC_STATUS_CD         = 'AC'                  
                  AND FI.OPTION_CD              = E9.OPTION_CD          
                  AND FI.OPTION_START_DT       <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND FI.OPTION_END_DT         >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)          
                  AND FI.OPT_VSTART_TS         <= 
           CIS.CURRENT$TIMESTAMP()     
                  AND FI.OPT_VEND_TS           >= 
           CIS.CURRENT$TIMESTAMP()     
                  AND FI.PROC_STATUS_CD         = 'AC'                  
                ORDER BY E9.OPTION_SORT_SEQ_NO                          
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFFER_DETAILS_CUR CURSOR FOR                              
MFA-TR*        SELECT FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,E9.OPTION_SORT_SEQ_NO                                     
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CRM_OFFER_OPTION E9                                       
MFA-TR*         WHERE FG.OFFER_CD               = :FG-OFFER-CD                  
MFA-TR*           AND FG.OFFER_START_DT        <= CURRENT DATE                  
MFA-TR*           AND FG.OFFER_END_DT          >= CURRENT DATE                  
MFA-TR*           AND FG.OFF_VSTART_TS         <= CURRENT TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS           >= CURRENT TIMESTAMP             
MFA-TR*           AND FG.PROC_STATUS_CD         = 'AC'                          
MFA-TR*           AND FG.OFFER_CD               = E9.OFFER_CD                   
MFA-TR*           AND E9.OFFER_OPT_START_DT    <= CURRENT DATE                  
MFA-TR*           AND E9.OFFER_OPT_END_DT      >= CURRENT DATE                  
MFA-TR*           AND E9.OFF_OPT_VSTART_TS     <= CURRENT TIMESTAMP             
MFA-TR*           AND E9.OFF_OPT_VEND_TS       >= CURRENT TIMESTAMP             
MFA-TR*           AND E9.PROC_STATUS_CD         = 'AC'                          
MFA-TR*           AND FI.OPTION_CD              = E9.OPTION_CD                  
MFA-TR*           AND FI.OPTION_START_DT       <= CURRENT DATE                  
MFA-TR*           AND FI.OPTION_END_DT         >= CURRENT DATE                  
MFA-TR*           AND FI.OPT_VSTART_TS         <= CURRENT TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS           >= CURRENT TIMESTAMP             
MFA-TR*           AND FI.PROC_STATUS_CD         = 'AC'                          
MFA-TR*         ORDER BY E9.OPTION_SORT_SEQ_NO                                  
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-OFFER-CD              PIC X(12).                        
       01  PARM-RESOURCE-ID           PIC X(16).                        
       01  PARM-PRICE-HISTORY-FL      PIC X(01).                        
                                                                        
       PROCEDURE DIVISION USING                                         
                          PARM-OFFER-CD                                 
                          PARM-RESOURCE-ID                              
                          PARM-PRICE-HISTORY-FL.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
      *DECLARE THE GLOBAL TEMPRAORY TABLE                                       
           PERFORM 0100A-DECLARE-GTT-R1      THRU 0100A-EXIT.           
           PERFORM 0100B-DECLARE-GTT-R2      THRU 0100B-EXIT.           
           PERFORM 0100C-DECLARE-GTT-R3      THRU 0100C-EXIT.           
                                                                        
      *GETTING COMMON DATE FROM JOB_PARM TABLE                                  
           MOVE 'COMMON'                  TO G6-PROGRAM-NAME            
           MOVE '01'                      TO G6-COMPANY-NO              
           MOVE 'DATE'                    TO G6-CMND-CODE               
           MOVE 10                        TO G6-SEQ-NO                  
           PERFORM 7000-SELECT-JOB-PARM      THRU 7000-EXIT             
           MOVE G6-PARM-DATA(10:10)       TO WS-COMMON-DATE.            
                                                                        
      *GETTING TOTAL MONTH COUNT FROM CSS_DELIQUENCY.                           
           MOVE '01'                      TO C8-COMPANY-NO.             
           MOVE WS-TOTAL-COUNT-DLINQ-CD   TO C8-DELINQ-CD.              
           PERFORM 7050-SELECT-DELINQ-VALUE  THRU 7050-EXIT.            
           MOVE C8-DELINQ-VALUE           TO WS-MONTH-COUNT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04577_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04577_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
ACT170             ,OFFER_DESC_EXT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(OFFER_CD))            AS OFFER_CD           
                      ,LTRIM(RTRIM(OFFER_DESC_EXT_LNG))  AS 
           OFFER_DESC_EXT_LNG 
                  FROM #CSR04577_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(OFFER_CD)            AS OFFER_CD                   
MFA-TR*               ,STRIP(OFFER_DESC_EXT_LNG)  AS OFFER_DESC_EXT_LNG         
MFA-TR*           FROM SESSION.CSR04577_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2.                                          *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04577_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04577_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
ACT170             ,CURR_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,OPTION_SORT_SEQ_NO   SMALLINT                       
                   ,THERM_PRICE          DECIMAL(11,6)                  
                   ,CSC_AMOUNT           DECIMAL(11,6)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(OFFER_CD))           AS OFFER_CD            
                      ,LTRIM(RTRIM(OPTION_CD))          AS OPTION_CD           
                      ,LTRIM(RTRIM(CURR_EXT_DESC_LONG)) AS 
           CURR_EXT_DESC_LONG  
                      ,OPTION_SORT_SEQ_NO                               
                      ,THERM_PRICE                                      
                      ,CSC_AMOUNT                                       
                  FROM #CSR04577_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(OFFER_CD)           AS OFFER_CD                    
MFA-TR*               ,STRIP(OPTION_CD)          AS OPTION_CD                   
MFA-TR*               ,STRIP(CURR_EXT_DESC_LONG) AS CURR_EXT_DESC_LONG          
MFA-TR*               ,OPTION_SORT_SEQ_NO                                       
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*               ,CSC_AMOUNT                                               
MFA-TR*           FROM SESSION.CSR04577_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100C-DECLARE-GTT-R3.                                          *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04577_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04577_R3
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE     INT                        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,PRICE_EFF_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,THERM_PRICE          DECIMAL(11,6)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS       THRU 8000C-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,OPTION_CD                                        
                      ,PRICE_EFF_DATE                                   
                      ,THERM_PRICE                                      
                  FROM #CSR04577_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,OPTION_CD                                                
MFA-TR*               ,PRICE_EFF_DATE                                           
MFA-TR*               ,THERM_PRICE                                              
MFA-TR*           FROM SESSION.CSR04577_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-OFFER-CD               TO FG-OFFER-CD.             
           MOVE PARM-PRICE-HISTORY-FL       TO WS-PRICE-HISTORY-FL.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'N'                       TO WS-NO-MORE-ROWS.           
           PERFORM 7100-OPEN-OFFER-CURSOR    THRU 7100-EXIT.            
           PERFORM 7200-FETCH-OFFER-CURSOR   THRU 7200-EXIT.            
      *    WRITE OFFER DEATILS FIRST TIME ALONE.                                
           MOVE FG-OFFER-CD               TO S-RS1-OFFER-CD             
           MOVE FG-OFFER-DESC-EXT-LNG     TO S-RS1-OFFER-DESC-EXT-LNG   
           PERFORM 8100-INSERT-GTT-R1        THRU 8100-EXIT             
                                                                        
           PERFORM 2100-POPULATE-OFFER-INO   THRU 2100-EXIT             
                                             UNTIL NO-MORE-ROWS.        
           PERFORM 7300-CLOSE-OFFER-CURSOR   THRU 7300-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-POPULATE-OFFER-INO.                                       *        
      ******************************************************************        
       2100-POPULATE-OFFER-INO.                                         
                                                                        
           MOVE FG-OFFER-CD                 TO S-RS2-OFFER-CD.          
           MOVE FI-OPTION-CD                TO S-RS2-OPTION-CD.         
           MOVE FI-CURR-EXT-DESC-LONG       TO S-RS2-CURR-EXT-DESC-LONG.
           MOVE E9-OPTION-SORT-SEQ-NO       TO S-RS2-OPTION-SORT-SEQ-NO.
                                                                        
      *    GETTING CURRENT THERM PRICE & CSC AMOUNT FROM CPD00063.              
           MOVE FI-OPTION-CD                TO WS-OPTION-CD.            
           MOVE 'N'                         TO WS-CSC-TIMELINE-FL-063.  
           PERFORM 6000-CALL-MCSCB063          THRU 6000-EXIT           
           IF WS-MCSCB063-RET-CODE EQUAL ZEROES                         
              MOVE WS-THERM-PRICE           TO S-RS2-THERM-PRICE        
              MOVE WS-CSC-AMT               TO S-RS2-CSC-AMOUNT         
           END-IF                                                       
           PERFORM 8200-INSERT-GTT-R2          THRU 8200-EXIT.          
                                                                        
      *    GETTING 12 MONTHS THERM PRICE FROM CPD00063.                         
           IF WS-PRICE-HISTORY-FL EQUAL WS-YES                          
              PERFORM 2200-BUILD-PRICE-HIST    THRU 2200-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7200-FETCH-OFFER-CURSOR THRU 7200-EXIT.              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2200-BUILD-PRICE-HIST                                         *         
      *****************************************************************         
       2200-BUILD-PRICE-HIST.                                           
                                                                        
           MOVE FI-OPTION-CD               TO WS-OPTION-CD.             
           MOVE 'Y'                        TO WS-CSC-TIMELINE-FL-063.   
           MOVE WS-COMMON-DATE(1:4)        TO WS-EFF-MTH-YR.            
           MOVE WS-COMMON-DATE(6:2)        TO WS-EFF-MTH-MM.            
           MOVE '05'                       TO WS-EFF-MTH-DD.            
           MOVE '-'                        TO WS-DASH1                  
                                              WS-DASH2.                 
                                                                        
           COMPUTE WS-EFF-MTH-MM = WS-EFF-MTH-MM + 1                    
           PERFORM WS-MONTH-COUNT TIMES                                 
             COMPUTE WS-EFF-MTH-MM = WS-EFF-MTH-MM - 1                  
             IF WS-EFF-MTH-MM = WS-ZERO                                 
                COMPUTE WS-EFF-MTH-YR = WS-EFF-MTH-YR - 1               
                MOVE 12         TO WS-EFF-MTH-MM                        
             END-IF                                                     
                                                                        
             MOVE WS-EFF-MTH-DATE           TO WS-DATE-FOR-CSC-TIMELINE 
             PERFORM 6000-CALL-MCSCB063        THRU 6000-EXIT           
             IF WS-MCSCB063-RET-CODE EQUAL ZEROES AND                   
                WS-THERM-PRICE GREATER THAN WS-ZERO                     
                MOVE WS-OPTION-CD           TO S-RS3-OPTION-CD          
                MOVE SPACES                 TO WS-PRICE-EFF-DATE        
                MOVE WS-THRM-PRC-EFF-DT-063 TO WS-PRICE-EFF-DATE        
                IF WS-PRICE-EFF-DATE GREATER THAN SPACES                
                   MOVE '01'                TO WS-PRICE-EFF-DATE(9:2)   
                END-IF                                                  
                MOVE WS-PRICE-EFF-DATE      TO S-RS3-PRICE-EFF-DATE     
                MOVE WS-THERM-PRICE         TO S-RS3-THERM-PRICE        
                PERFORM 8300-INSERT-GTT-R3     THRU 8300-EXIT           
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      * 6000-CALL-MCSCB063.                                          **         
      *****************************************************************         
       6000-CALL-MCSCB063.                                              
                                                                        
           CALL MCSCB063 USING CWS00063-FIELDS                          
                            ,ABEND-FILE,                                
                            ,WS-MCSCB063-RET-CODE                       
                                                                        
           IF WS-MCSCB063-RET-CODE NOT EQUAL ZEROES                     
              MOVE WS-MCSCB063-RET-CODE      TO WS-ACTIVE-RETURN-CODE   
              MOVE 'CALL'                    TO ABEND-FUNCTION          
              MOVE 'MCSCB063'                TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                              **         
      * 7000-SELECT-JOB-PARM.                                        **         
      *****************************************************************         
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
               SELECT G6.PARM_DATA                                      
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G6.PARM_DATA                                              
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.COMPANY_NO   = :G6-COMPANY-NO                          
MFA-TR*           AND G6.CMND_CODE    = :G6-CMND-CODE                           
MFA-TR*           AND G6.SEQ_NO       = :G6-SEQ-NO                              
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-SEQ-NO                TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7050-SELECT-DELINQ-VALUE.                                     *         
      *****************************************************************         
       7050-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                     
                 AND C8.COMPANY_NO  = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                             
MFA-TR*          AND C8.COMPANY_NO  = :C8-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  7100-OPEN-OFFER-CURSOR.                                       *        
      ******************************************************************        
       7100-OPEN-OFFER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_DETAILS_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RATE_GRP-OFFER'  TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE FG-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-FETCH-OFFER-CURSOR.                                       *        
      ******************************************************************        
       7200-FETCH-OFFER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_DETAILS_CUR                                  
                INTO :FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FI-OPTION-CD                                      
                    ,:FI-CURR-EXT-DESC-LONG                             
                    ,:E9-OPTION-SORT-SEQ-NO                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7200'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RATE_GRP_OFFER' TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE FG-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-CLOSE-OFFER-CURSOR.                                       *        
      ******************************************************************        
       7300-CLOSE-OFFER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_DETAILS_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE FG-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04577_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04577_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04577_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04577_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04577_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04577_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04577_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04577_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000C'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04577_R3'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-INSERT-GTT-R1.                                            *        
      ******************************************************************        
       8100-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04577_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,OFFER_CD                                             
                  ,OFFER_DESC_EXT_LNG                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-OFFER-CD                                      
                  ,:S-RS1-OFFER-DESC-EXT-LNG                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04577_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OFFER_DESC_EXT_LNG                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-OFFER-CD                                              
MFA-TR*           ,:S-RS1-OFFER-DESC-EXT-LNG                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04577_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-GTT-R2.                                            *        
      ******************************************************************        
       8200-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04577_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,CURR_EXT_DESC_LONG                                   
                  ,OPTION_SORT_SEQ_NO                                   
                  ,THERM_PRICE                                          
                  ,CSC_AMOUNT                                           
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-OFFER-CD                                      
                  ,:S-RS2-OPTION-CD                                     
                  ,:S-RS2-CURR-EXT-DESC-LONG                            
                  ,:S-RS2-OPTION-SORT-SEQ-NO                            
                  ,:S-RS2-THERM-PRICE                                   
                  ,:S-RS2-CSC-AMOUNT                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04577_R2                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,CURR_EXT_DESC_LONG                                           
MFA-TR*           ,OPTION_SORT_SEQ_NO                                           
MFA-TR*           ,THERM_PRICE                                                  
MFA-TR*           ,CSC_AMOUNT                                                   
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-OFFER-CD                                              
MFA-TR*           ,:S-RS2-OPTION-CD                                             
MFA-TR*           ,:S-RS2-CURR-EXT-DESC-LONG                                    
MFA-TR*           ,:S-RS2-OPTION-SORT-SEQ-NO                                    
MFA-TR*           ,:S-RS2-THERM-PRICE                                           
MFA-TR*           ,:S-RS2-CSC-AMOUNT                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8200'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04577_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-INSERT-GTT-R3.                                            *        
      ******************************************************************        
       8300-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04577_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,OPTION_CD                                            
                  ,PRICE_EFF_DATE                                       
                  ,THERM_PRICE                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-OPTION-CD                                     
                  ,:S-RS3-PRICE-EFF-DATE                                
                  ,:S-RS3-THERM-PRICE                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04577_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,PRICE_EFF_DATE                                               
MFA-TR*           ,THERM_PRICE                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-OPTION-CD                                             
MFA-TR*           ,:S-RS3-PRICE-EFF-DATE                                        
MFA-TR*           ,:S-RS3-THERM-PRICE                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8300'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04577_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8200-INSERT-GTT-R2     THRU 8200-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8300-INSERT-GTT-R3     THRU 8300-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04577_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04577_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04577_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3     
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
                                                                        
           PERFORM 8100-INSERT-GTT-R1          THRU 8100-EXIT.          
           PERFORM 8200-INSERT-GTT-R2          THRU 8200-EXIT.          
           PERFORM 8300-INSERT-GTT-R3          THRU 8300-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
