       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04574.                                         
COB303 DATE-WRITTEN.  OCTOBER 22,2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *        
      *                                                                *        
      *  PROGRAM:       CSR04574                                       *        
      *  CALLING SP:    REQUGETACCOUNTMNTACCTRECEIVABLESBUSINESSOP     *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES DATA FROM CSS_AR_CNTL FOR              *        
      *  MAINTENANCE PURPOSE.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PRJ743*  10/22/12  AS7C117    INITIAL PROGRAM VERSION                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04574'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04574 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      ******************************************************************        
      *  CSS_AR_CNTL     AC                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  CSS_CONTRACT    CT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  CSS_CONTRACT_INFO K6                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *  CSS_AR_TYPE       L5                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARTYPE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
      ******************************************************************        
      *  ERROR HANDLING                                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR04574'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-ACCOUNT-NO-CHR       PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO-CHR            
                                       PIC 9(13).                       
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE 0.       
           05  WS-ITEM-DESC            PIC X(30)  VALUE  SPACES.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9)     COMP   VALUE 0.     
           05  S-APPL-RETURN-CODE     PIC S9(9)     COMP   VALUE 0.     
           05  S-PYMT-PRIORITY-LVL    PIC S9(04)    COMP   VALUE 0.     
           05  S-ITEM-ID              PIC S9(9)     COMP   VALUE 0.     
           05  S-ITEM-DESC            PIC X(30)     VALUE  SPACES.      
           05  S-AMT-AR-DAY-00        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AMT-AR-DAY-30        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AMT-AR-DAY-60        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AMT-AR-DAY-90        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AMT-UNUSED-CR        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AMT-TRAN-BALANCE     PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-TOT-SUMM-UNBILLED    PIC S9(09)V99 COMP-3 VALUE 0.     
           05  S-AC-LAST-UPDATE-TS    PIC X(26)     VALUE SPACES.       
           05  S-BUS-RULE-ID          PIC X(10)     VALUE SPACE.        
           05  S-BUS-RULE-RESULT-CD   PIC X(08)     VALUE SPACE.        
           05  S-BUS-RULE-XREF-ID     PIC X(26)     VALUE SPACE.        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE AR-CNTL-CURSOR CURSOR FOR                   
              SELECT PYMT_PRIORITY_LVL                                  
                   ,ITEM_ID                                             
                   ,AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_TRAN_BALANCE                                    
                   ,TOT_SUMM_UNBILLED                                   
                   ,AMT_UNUSED_CR                                       
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
               ORDER BY PYMT_PRIORITY_LVL,                              
                        ITEM_ID                                         
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-CNTL-CURSOR CURSOR FOR                           
MFA-TR*       SELECT PYMT_PRIORITY_LVL                                          
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,AMT_AR_DAY_00                                               
MFA-TR*            ,AMT_AR_DAY_30                                               
MFA-TR*            ,AMT_AR_DAY_60                                               
MFA-TR*            ,AMT_AR_DAY_90                                               
MFA-TR*            ,AMT_TRAN_BALANCE                                            
MFA-TR*            ,TOT_SUMM_UNBILLED                                           
MFA-TR*            ,AMT_UNUSED_CR                                               
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                
MFA-TR*        ORDER BY PYMT_PRIORITY_LVL,                                      
MFA-TR*                 ITEM_ID                                                 
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.              
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT RETURN_CODE                                        
                   ,APPL_RETURN_CODE                                    
                   ,PYMT_PRIORITY_LVL                                   
                   ,ITEM_ID                                             
                   ,LTRIM(RTRIM(ITEM_DESC))          AS ITEM_DESC              
                   ,AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_UNUSED_CR                                       
                   ,AMT_TRAN_BALANCE                                    
                   ,TOT_SUMM_UNBILLED                                   
                   ,LTRIM(RTRIM(AC_LAST_UPDATE_TS))  AS 
           AC_LAST_UPDATE_TS      
                   ,LTRIM(RTRIM(BUS_RULE_ID))        AS BUS_RULE_ID            
                   ,LTRIM(RTRIM(BUS_RULE_RESULT_CD)) AS 
           BUS_RULE_RESULT_CD     
                   ,LTRIM(RTRIM(BUS_RULE_XREF_ID))   AS BUS_RULE_XREF_ID       
                FROM #CSR04574_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT RETURN_CODE                                                
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,PYMT_PRIORITY_LVL                                           
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,STRIP(ITEM_DESC)          AS ITEM_DESC                      
MFA-TR*            ,AMT_AR_DAY_00                                               
MFA-TR*            ,AMT_AR_DAY_30                                               
MFA-TR*            ,AMT_AR_DAY_60                                               
MFA-TR*            ,AMT_AR_DAY_90                                               
MFA-TR*            ,AMT_UNUSED_CR                                               
MFA-TR*            ,AMT_TRAN_BALANCE                                            
MFA-TR*            ,TOT_SUMM_UNBILLED                                           
MFA-TR*            ,STRIP(AC_LAST_UPDATE_TS)  AS AC_LAST_UPDATE_TS              
MFA-TR*            ,STRIP(BUS_RULE_ID)        AS BUS_RULE_ID                    
MFA-TR*            ,STRIP(BUS_RULE_RESULT_CD) AS BUS_RULE_RESULT_CD             
MFA-TR*            ,STRIP(BUS_RULE_XREF_ID)   AS BUS_RULE_XREF_ID               
MFA-TR*         FROM SESSION.CSR04574_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04574_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04574_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04574_R1
              (                                                          
               RETURN_CODE                  INT                     
              ,APPL_RETURN_CODE             INT                     
              ,PYMT_PRIORITY_LVL            SMALLINT                    
              ,ITEM_ID                      INT                     
              ,ITEM_DESC CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,AMT_AR_DAY_00                DECIMAL(11,2)               
              ,AMT_AR_DAY_30                DECIMAL(11,2)               
              ,AMT_AR_DAY_60                DECIMAL(11,2)               
              ,AMT_AR_DAY_90                DECIMAL(11,2)               
              ,AMT_UNUSED_CR                DECIMAL(11,2)               
              ,AMT_TRAN_BALANCE             DECIMAL(11,2)               
              ,TOT_SUMM_UNBILLED            DECIMAL(11,2)               
              ,AC_LAST_UPDATE_TS CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                    
              ,BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BUS_RULE_RESULT_CD CHAR(08)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                    
              ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
                  MOVE SQLCODE            TO ABEND-SQLCODE              
                  MOVE SQLSTATE           TO ABEND-SQLSTATE             
                  MOVE '0100A'            TO ACTIVE-PARAGRAPH           
                  MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE 'CSR04574_R1'      TO TABLE-1                    
                  MOVE SPACES             TO TABLE-ELEMENT-1            
                  MOVE SPACES             TO HOSTVAR-ELEMENT-1          
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-CHR.         
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-AR-CNTL       THRU 7000-EXIT               
           PERFORM 7100-FETCH-AR-CNTL      THRU 7100-EXIT               
           PERFORM 2210-PROCESS-RESULT-SET THRU 2210-EXIT               
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
           PERFORM 7200-CLOSE-AR-CNTL      THRU 7200-EXIT               
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE ZEROS                   TO S-RETURN-CODE             
              MOVE ZEROS                   TO S-APPL-RETURN-CODE        
              MOVE 'AM00000021'            TO S-BUS-RULE-ID             
              MOVE 'F'                     TO S-BUS-RULE-RESULT-CD      
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7210-GET-RULE-XREF-ID THRU 7210-EXIT           
              END-IF                                                    
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2210-PROCESS-RESULT-SET.                                                 
      ******************************************************************        
       2210-PROCESS-RESULT-SET.                                         
                                                                        
           MOVE AC-PYMT-PRIORITY-LVL            TO S-PYMT-PRIORITY-LVL  
           MOVE AC-ITEM-ID                      TO S-ITEM-ID            
           MOVE 'UNKNOWN'                       TO S-ITEM-DESC          
                                                   WS-ITEM-DESC         
           PERFORM 2400-GET-ITEM-DESC              THRU 2400-EXIT       
           IF WS-ITEM-DESC > SPACES                                     
              MOVE WS-ITEM-DESC                 TO S-ITEM-DESC          
           END-IF                                                       
           MOVE AC-AMT-AR-DAY-00                TO S-AMT-AR-DAY-00      
           MOVE AC-AMT-AR-DAY-00                TO S-AMT-AR-DAY-00      
           MOVE AC-AMT-AR-DAY-30                TO S-AMT-AR-DAY-30      
           MOVE AC-AMT-AR-DAY-60                TO S-AMT-AR-DAY-60      
           MOVE AC-AMT-AR-DAY-90                TO S-AMT-AR-DAY-90      
           MOVE AC-AMT-UNUSED-CR                TO S-AMT-UNUSED-CR      
           MOVE AC-AMT-TRAN-BALANCE             TO S-AMT-TRAN-BALANCE   
           MOVE AC-TOT-SUMM-UNBILLED            TO S-TOT-SUMM-UNBILLED  
           MOVE AC-LAST-UPDATE-TS               TO S-AC-LAST-UPDATE-TS  
                                                                        
           PERFORM 8100-SEND-RESULT                THRU 8100-EXIT       
           PERFORM 7100-FETCH-AR-CNTL              THRU 7100-EXIT.      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-GET-ITEM-DESC                                             *        
      ******************************************************************        
       2400-GET-ITEM-DESC.                                              
                                                                        
           IF AC-ITEM-ID > 0 AND AC-PYMT-PRIORITY-LVL = 100             
              PERFORM 7300-SELECT-CONTRACT-DESC THRU 7300-EXIT          
           ELSE                                                         
              PERFORM 7400-SELECT-AR-TYPE-DESC  THRU 7400-EXIT          
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-AR-CNTL                                              *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
       7000-OPEN-AR-CNTL.                                               
                                                                        
           EXEC SQL                                                     
              OPEN AR-CNTL-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL '             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7100-FETCH-AR-CNTL                                             *        
      *                                                                *        
      ******************************************************************        
       7100-FETCH-AR-CNTL.                                              
                                                                        
           EXEC SQL                                                     
              FETCH AR-CNTL-CURSOR                                      
               INTO :AC-PYMT-PRIORITY-LVL                               
                   ,:AC-ITEM-ID                                         
                   ,:AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-LAST-UPDATE-TS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
              MOVE 'FETCH'                    TO   ABEND-FUNCTION       
              MOVE '7100'                     TO   ACTIVE-PARAGRAPH     
              MOVE SPACES                     TO   ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_AR_CNTL'              TO   TABLE-1              
              MOVE 'ACCOUNT_NO'               TO   TABLE-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-AR-CNTL                                             *        
      *                                                                *        
      ******************************************************************        
       7200-CLOSE-AR-CNTL.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE AR-CNTL-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7210-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                                  
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7210'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_XREF_ID'    TO TABLE-ELEMENT-1            
               MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-2            
               MOVE S-BUS-RULE-XREF-ID    TO HOSTVAR-ELEMENT-1          
               MOVE S-BUS-RULE-ID         TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-CONTRACT-DESC                                      *        
      ******************************************************************        
       7300-SELECT-CONTRACT-DESC.                                       
                                                                        
           EXEC SQL                                                     
              SELECT K6.CNT_NAME_DESC                                   
                INTO :WS-ITEM-DESC                                      
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED),                     
                     CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)                 
               WHERE CT.ACCOUNT_NO        = :WS-ACCOUNT-NO              
                 AND CT.CNT_ITEM_ID       = :AC-ITEM-ID                 
                 AND CT.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL       
                 AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT K6.CNT_NAME_DESC                                           
MFA-TR*         INTO :WS-ITEM-DESC                                              
MFA-TR*         FROM CSS_CONTRACT CT,                                           
MFA-TR*              CSS_CONTRACT_INFO K6                                       
MFA-TR*        WHERE CT.ACCOUNT_NO        = :WS-ACCOUNT-NO                      
MFA-TR*          AND CT.CNT_ITEM_ID       = :AC-ITEM-ID                         
MFA-TR*          AND CT.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL               
MFA-TR*          AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-AR-TYPE-DESC                                       *        
      ******************************************************************        
       7400-SELECT-AR-TYPE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AR_TYPE_LONG_DESC                                  
                INTO :WS-ITEM-DESC                                      
                FROM CSS_AR_TYPE WITH(READUNCOMMITTED)                          
               WHERE PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AR_TYPE_LONG_DESC                                          
MFA-TR*         INTO :WS-ITEM-DESC                                              
MFA-TR*         FROM CSS_AR_TYPE                                                
MFA-TR*        WHERE PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TYPE'        TO TABLE-1                      
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-1              
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04574_R1                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04574_R1                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04574_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04574_R1                           
              (                                                         
               RETURN_CODE                                              
              ,APPL_RETURN_CODE                                         
              ,PYMT_PRIORITY_LVL                                        
              ,ITEM_ID                                                  
              ,ITEM_DESC                                                
              ,AMT_AR_DAY_00                                            
              ,AMT_AR_DAY_30                                            
              ,AMT_AR_DAY_60                                            
              ,AMT_AR_DAY_90                                            
              ,AMT_UNUSED_CR                                            
              ,AMT_TRAN_BALANCE                                         
              ,TOT_SUMM_UNBILLED                                        
              ,AC_LAST_UPDATE_TS                                        
              ,BUS_RULE_ID                                              
              ,BUS_RULE_RESULT_CD                                       
              ,BUS_RULE_XREF_ID                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE                                           
              ,:S-APPL-RETURN-CODE                                      
              ,:S-PYMT-PRIORITY-LVL                                     
              ,:S-ITEM-ID                                               
              ,:S-ITEM-DESC                                             
              ,:S-AMT-AR-DAY-00                                         
              ,:S-AMT-AR-DAY-30                                         
              ,:S-AMT-AR-DAY-60                                         
              ,:S-AMT-AR-DAY-90                                         
              ,:S-AMT-UNUSED-CR                                         
              ,:S-AMT-TRAN-BALANCE                                      
              ,:S-TOT-SUMM-UNBILLED                                     
              ,:S-AC-LAST-UPDATE-TS                                     
              ,:S-BUS-RULE-ID                                           
              ,:S-BUS-RULE-RESULT-CD                                    
              ,:S-BUS-RULE-XREF-ID                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04574_R1                                   
MFA-TR*       (                                                                 
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,APPL_RETURN_CODE                                                 
MFA-TR*       ,PYMT_PRIORITY_LVL                                                
MFA-TR*       ,ITEM_ID                                                          
MFA-TR*       ,ITEM_DESC                                                        
MFA-TR*       ,AMT_AR_DAY_00                                                    
MFA-TR*       ,AMT_AR_DAY_30                                                    
MFA-TR*       ,AMT_AR_DAY_60                                                    
MFA-TR*       ,AMT_AR_DAY_90                                                    
MFA-TR*       ,AMT_UNUSED_CR                                                    
MFA-TR*       ,AMT_TRAN_BALANCE                                                 
MFA-TR*       ,TOT_SUMM_UNBILLED                                                
MFA-TR*       ,AC_LAST_UPDATE_TS                                                
MFA-TR*       ,BUS_RULE_ID                                                      
MFA-TR*       ,BUS_RULE_RESULT_CD                                               
MFA-TR*       ,BUS_RULE_XREF_ID                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE                                                   
MFA-TR*       ,:S-APPL-RETURN-CODE                                              
MFA-TR*       ,:S-PYMT-PRIORITY-LVL                                             
MFA-TR*       ,:S-ITEM-ID                                                       
MFA-TR*       ,:S-ITEM-DESC                                                     
MFA-TR*       ,:S-AMT-AR-DAY-00                                                 
MFA-TR*       ,:S-AMT-AR-DAY-30                                                 
MFA-TR*       ,:S-AMT-AR-DAY-60                                                 
MFA-TR*       ,:S-AMT-AR-DAY-90                                                 
MFA-TR*       ,:S-AMT-UNUSED-CR                                                 
MFA-TR*       ,:S-AMT-TRAN-BALANCE                                              
MFA-TR*       ,:S-TOT-SUMM-UNBILLED                                             
MFA-TR*       ,:S-AC-LAST-UPDATE-TS                                             
MFA-TR*       ,:S-BUS-RULE-ID                                                   
MFA-TR*       ,:S-BUS-RULE-RESULT-CD                                            
MFA-TR*       ,:S-BUS-RULE-XREF-ID                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04574_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
