       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04573.                                         
COB303 DATE-WRITTEN.  OCTOBER 19, 2012.                                 
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *00100000
      *                                                                *00110000
      *  PROGRAM:       CSR04573                                       *00120000
      *  CALLING SP:    UPDSYSTEMMNTACCOUNTRECEIVABLEDETAILS           *00130000
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROCEDURE UPDATES ACCOUNT RECEIVABLE DETAILS             *00180000
      *  INTO CSS_AR_CNTL TABLE.                                       *00190000
      *                                                                *00190000
      *  INPUT PARAMETRS                                               *00190000
      *  -----------------                                             *00190000
      *       I_ACCOUNT_NO          CHAR(13)                           *00190000
      *       I_PYMT_PRIRITY_LVL    CHAR(03)                           *00190000
      *       I_RECV_TYPE           CHAR(03)                           *00190000
      *       I_AMT_AR_DAY_00       DECIMAL(13,2)                      *00190000
      *       I_AMT_AR_DAY_30       DECIMAL(13,2)                      *00190000
      *       I_AMT_AR_DAY_60       DECIMAL(13,2)                      *00190000
      *       I_AMT_AR_DAY_90       DECIMAL(13,2)                      *00190000
      *       I_AMT_UNUSED_CR       DECIMAL(13,2)                      *00190000
      *       I_USER_ID             CHAR(07)                           *00190000
      *       I_AMT_TRAN_BALANCE    DECIMAL(13,2)                      *00190000
      *       I_TOT_SUM_UNBILLED    DECIMAL(13,2)                      *00190000
      *       I_ITEM_ID             INTEGER                            *00190000
      *       I_COMMENT_TEXT        CHAR(210)                          *00190000
      *       I_PROCESSING_FL       CHAR(01)                           *00190000
      *       I_AC_LST_UPDATE_TS    CHAR(26)                           *00190000
      *                                                                *00190000
      ******************************************************************00200000
      *                                                                *00210000
      *                     PROGRAM MODIFICATION LOG                   *00220000
      *                                                                *00230000
      *    DATE    INITIALS   COMMENTS                                 *00240000
      *  --------  --------   ---------------------------------------  *00250000
      *  10/19/12  AS7C117    INITIAL PROGRAM VERSION                  *00260000
A05136*  19/08/15  SM93554    UNWANTED FIELD- COMMENTED OUT IN 8200-   *00260000
A05136*  09/01/15  SM93554    ADDED NOT-FOUND IN 8310-DELETE-SUMM-AR   *00260000
A05136*            ACT-167                                             *00260000
A05136*                                                                *00260000
      ******************************************************************00270000
      ******************************************************************00280000
      *                                                                *00290000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00300000
      *                                                                *00310000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00320000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00330000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00340000
      *  3000 - 4999  NOT USED                                         *00350000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00360000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00370000
      *  7000 - 7999  INPUT MODULES                                    *00380000
      *  8000 - 8999  OUTPUT MODULES                                   *00390000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00400000
      *                                                                *00410000
      ******************************************************************00420000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04573'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04573 STARTS HERE'.                  
                                                                        
      ******************************************************************00510000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00520000
      ******************************************************************00530000
                                                                        
           COPY CWS00056.                                               00570000
           COPY CWS00303.                                               00580000
                                                                        
           EXEC SQL                                                     00630000
               INCLUDE CWSX0010                                         00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00670000
      *    WORK AREAS                                                  *00680000
      ******************************************************************00690000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04573'.     
           05  WS-ACCOUNT-NO-C          PIC X(13).                      
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C                  
                                        PIC S9(13).                     
      *                                                                 00760000
           05  WS-PYMT-PRIORITY-LVL-C   PIC X(03).                      
           05  WS-PYMT-PRIORITY-LVL-N  REDEFINES WS-PYMT-PRIORITY-LVL-C 
                                        PIC 9(03).                      
           05  WS-PYMT-PRIORITY-LVL     PIC S9(03) COMP VALUE +0.       
      *                                                                 00820000
           05  WS-ITEM-ID               PIC S9(09) COMP VALUE +0.       
           05  WS-ITEM-ID-C             PIC X(09) VALUE SPACES.         
           05  WS-ITEM-ID-N             PIC 9(09) VALUE 0.              
COB305     05 WS-AMT-AR-DAY-00        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-AR-DAY-30        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-AR-DAY-60        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-AR-DAY-90        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-TRAN-BAL        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-TOT-SUM-UNBILL        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-AMT-UNUSED-CR        PIC S9(11)V99 COMP-3 VALUE 0.           
           05  WS-DTL-EXISTS            PIC X(01) VALUE SPACES.         
           05  WS-DETAIL-ROW-EXIST      PIC X(01) VALUE 'N'.            
           05  WS-SUMM-EXISTS           PIC X(01) VALUE SPACES.         
           05  WS-AMT-TRAN-BAL-ED       PIC -(11)9.99.                  
           05  WS-AR-TYPE-SHORT-DESC    PIC X(03) VALUE SPACES.         
COB305     05 WS-TOTAL-AR-BALANCE        PIC S9(11)V99 COMP-3 VALUE 0.          
           05  WS-LAST-UPDATE-TS        PIC X(26)  VALUE SPACES.        
           05  WS-CODE-ACCT-STAT        PIC X(01)  VALUE SPACES.        
COB305     05 WS-CHK-ACC-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  ROW-EXIST                PIC X(01)  VALUE 'N'.           
           05  WS-DELETED-FLAG          PIC X(01) VALUE SPACE.          
           05  WS-UPDATE-FLAG           PIC X(01) VALUE SPACE.          
           05  WS-PRE-CD-DATA-PRESENT   PIC X(32) VALUE SPACE.          
           05  WS-CD-DATA-PRESENT-CHNGD PIC X(01) VALUE 'N'.            
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-DELETE-SUMM-ROW       PIC X(01) VALUE 'N'.            
               88 DELETED-SUMM-ROW                VALUE 'Y'.            
           05  WS-INSERTE-SUMM-ROW      PIC X(01) VALUE 'N'.            
               88 INSERTED-SUMM-ROW               VALUE 'Y'.            
           05  WS-UPD-CODE-DATA-PRESENT PIC X(01) VALUE 'N'.            
               88 UPD-CODE-DATA-PRESENT           VALUE 'Y'.            
                                                                        
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE +0.       
           05  WS-INSERT-FLAG           PIC X(01) VALUE SPACE.          
           05  WS-COMMENT-LEN           PIC S9(4) COMP-3 VALUE 0.       
           05  WS-COMP-2-CHAR-CONV      PIC -Z(10)9.99.                 
           05  WS-SUM-AR-DAY-00         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-AR-DAY-30         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-AR-DAY-60         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-AR-DAY-90         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-UNUSED-CR         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-TRAN-BAL          PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-SUM-SUMM-UNBILL       PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-AR-DAY-00         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-AR-DAY-30         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-AR-DAY-60         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-AR-DAY-90         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-UNUSED-CR         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-TRAN-BALANCE      PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-PRE-SUMM-UNBILLED     PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-ZERO                  PIC S9(01) COMP VALUE +0.       
                                                                        
       01  WS-LITERALS.                                                 
           05  MCSCA182                 PIC X(08)   VALUE 'MCSCA182'.   
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04573_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(09) COMP.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE 0.          
           05 S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.          
           05 S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACE.           
           05 S-BUS-RULE-ID            PIC X(10) VALUE SPACE.           
           05 S-BUS-RULE-RESULT-CD     PIC X(08) VALUE SPACE.           
           05 S-BUS-RULE-XREF-ID       PIC X(26) VALUE SPACE.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                 01880000
                                                                        
      ******************************************************************01900000
      *    DB2 INCLUDES                                                *01910000
      ******************************************************************01920000
           EXEC SQL                                                     01940000
              INCLUDE SQLCA                                             01950000
           END-EXEC.                                                    01960000
      ******************************************************************01970000
      * CSS_ACCOUNT        AT                                          *01971000
      ******************************************************************01972000
           EXEC SQL                                                     01980000
              INCLUDE TBACCT                                            01990000
           END-EXEC.                                                    02000000
      ******************************************************************02010000
      * CSS_AR_LOCKOUT     AL                                          *02011000
      ******************************************************************02012000
           EXEC SQL                                                     02020000
              INCLUDE TBARLOCK                                          02030000
           END-EXEC.                                                    02040000
      ******************************************************************02050000
      * CSS_MNT_TRANS_HIST MH                                          *02051000
      ******************************************************************02052000
           EXEC SQL                                                     02060000
              INCLUDE TBMNHIST                                          02070000
           END-EXEC.                                                    02080000
      ******************************************************************02090000
      * CSS_MT_TRN_HST_DET MI                                          *02091000
      ******************************************************************02092000
           EXEC SQL                                                     02100000
              INCLUDE TBMNHDT                                           02110000
           END-EXEC.                                                    02120000
      ******************************************************************02130000
      * CSS_AR_CNTL        AC                                          *02130100
      ******************************************************************02130200
           EXEC SQL                                                     02131000
              INCLUDE TBARCNTL                                          02132000
           END-EXEC.                                                    02133000
      ******************************************************************02134000
      * CSS_AR_TYPE        L5                                          *02134100
      ******************************************************************02134200
           EXEC SQL                                                     02135000
              INCLUDE TBARTYPE                                          02136000
           END-EXEC.                                                    02137000
      ******************************************************************02138000
      * CSS_BUS_RULE       1R                                          *02139000
      ******************************************************************02140000
           EXEC SQL                                                     02180000
              INCLUDE TBBUSRUL                                          02190000
           END-EXEC.                                                    02200000
      ******************************************************************02210000
      * CSS_BUS_RULE_XREF  1T                                          *02211000
      ******************************************************************02212000
           EXEC SQL                                                     02220000
              INCLUDE TBRULXRF                                          02230000
           END-EXEC.                                                    02240000
      ******************************************************************02241001
      * CSS_USER_PROFILE   PF                                          *02242001
      ******************************************************************02243001
           EXEC SQL                                                     02244001
              INCLUDE TBUSRPRF                                          02245001
           END-EXEC.                                                    02246001
                                                                        
       COPY CWS00182.                                                   02260000
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC X(13).                     
       01  PARM-PYMT-PRIORITY-LVL        PIC X(03).                     
       01  PARM-RECV-TYPE                PIC X(03).                     
COB305 01 PARM-AMT-AR-DAY-00        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-AMT-AR-DAY-30        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-AMT-AR-DAY-60        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-AMT-AR-DAY-90        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-AMT-UNUSED-CR        PIC S9(11)V99 COMP-3 VALUE 0.          
       01  PARM-USER-ID                  PIC X(07).                     
COB305 01 PARM-AMT-TRAN-BALANCE        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305 01 PARM-TOT-SUMM-UNBILLED        PIC S9(11)V99 COMP-3 VALUE 0.          
       01  PARM-ITEM-ID                  PIC S9(9) COMP.                
       01  PARM-COMMENT-TEXT             PIC X(210).                    
       01  PARM-PROCESSING-FL            PIC X(01).                     
       01  PARM-AC-LAST-UPDATE-TS        PIC X(26).                     
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-PYMT-PRIORITY-LVL                  
                                PARM-RECV-TYPE                          
                                PARM-AMT-AR-DAY-00                      
                                PARM-AMT-AR-DAY-30                      
                                PARM-AMT-AR-DAY-60                      
                                PARM-AMT-AR-DAY-90                      
                                PARM-AMT-UNUSED-CR                      
                                PARM-USER-ID                            
                                PARM-AMT-TRAN-BALANCE                   
                                PARM-TOT-SUMM-UNBILLED                  
                                PARM-ITEM-ID                            
                                PARM-COMMENT-TEXT                       
                                PARM-PROCESSING-FL                      
                                PARM-AC-LAST-UPDATE-TS.                 
                                                                        
      ******************************************************************02670000
      *                                                                *02671000
      * 0000-MAINLINE                                                  *02680000
      ******************************************************************02700000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02810000
      *                                                                *02811000
      * 0100-INITIALIZE                                                *02820000
      ******************************************************************02890000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE               AS RETURN_CODE       
                     ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CO    
                     ,LTRIM(RTRIM(:S-AR-LOCKOUT-IND))     AS 
           AR_LOCKOUT_IND    
                     ,LTRIM(RTRIM(:S-BUS-RULE-ID))        AS 
           [BUS_RULE-ID]       
                     ,LTRIM(RTRIM(:S-BUS-RULE-RESULT-CD)) AS 
           BUS_RULE_RESULT_CD
                     ,LTRIM(RTRIM(:S-BUS-RULE-XREF-ID))   AS 
           BUS_RULE_XREF_ID  
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02970000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        02980000
MFA-TR*        SELECT :S-RETURN-CODE               AS RETURN_CODE       02990000
MFA-TR*              ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CO    03000000
MFA-TR*              ,STRIP(:S-AR-LOCKOUT-IND)     AS AR_LOCKOUT_IND    03010000
MFA-TR*              ,STRIP(:S-BUS-RULE-ID)        AS BUS_RULE-ID       03020000
MFA-TR*              ,STRIP(:S-BUS-RULE-RESULT-CD) AS BUS_RULE_RESULT_CD03030000
MFA-TR*              ,STRIP(:S-BUS-RULE-XREF-ID)   AS BUS_RULE_XREF_ID  03040000
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                  03050000
MFA-TR*    END-EXEC.                                                    03060000
                                                                        
           MOVE PARM-ACCOUNT-NO               TO   WS-ACCOUNT-NO-C.     
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03130000
      *                                                                *03131000
      * 2000-PROCESS-OUTPUT.                                           *03140000
      ******************************************************************03210000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2010-CHECK-LOCK-OUT     THRU 2010-EXIT               
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE PARM-PYMT-PRIORITY-LVL  TO WS-PYMT-PRIORITY-LVL-C.      
           MOVE WS-PYMT-PRIORITY-LVL-N  TO WS-PYMT-PRIORITY-LVL.        
           PERFORM 7500-SELECT-AR-TYPE     THRU 7500-EXIT.              
           PERFORM 5000-PROCESS-PARA       THRU 5000-EXIT               
           ADD +1                       TO   CTR-ROWS.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03410000
      *                                                                *03411000
      * 2010-CHECK-LOCK-OUT                                            *03420000
      ******************************************************************03430000
       2010-CHECK-LOCK-OUT.                                             
                                                                        
           PERFORM 7999-SELECT-AL            THRU 7999-SELECT-AL-EXIT.  
                                                                        
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE ZEROS                     TO   S-RETURN-CODE         
              MOVE ZEROS                     TO   S-APPL-RETURN-CODE    
              MOVE AL-AR-LOCKOUT-IND         TO   S-AR-LOCKOUT-IND      
              MOVE 'AM00000005'              TO   S-BUS-RULE-ID         
              MOVE 'F'                       TO   S-BUS-RULE-RESULT-CD  
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                         TO   CTR-ROWS              
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           ELSE                                                         
              NEXT SENTENCE                                             
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
             EXEC SQL                                                   
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                 
                  INTO :S-BUS-RULE-XREF-ID                              
                  FROM CSS_BUS_RULE   [1R]                                
                      ,CSS_BUS_RULE_XREF [1T]                             
                 WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                  
                   AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                  
                                                  
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT BUS_RULE_XREF_ID                                         
MFA-TR*           INTO :S-BUS-RULE-XREF-ID                                      
MFA-TR*           FROM CSS_BUS_RULE   1R                                        
MFA-TR*               ,CSS_BUS_RULE_XREF 1T                                     
MFA-TR*          WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                          
MFA-TR*            AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                          
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE    
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                 CONTINUE                                               
             ELSE                                                       
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE '7020'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_BUS_RULE'        TO TABLE-1                  
                 MOVE 'BUS_RULE_XREF_ID'    TO TABLE-ELEMENT-1          
                 MOVE S-BUS-RULE-XREF-ID    TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF.                                                    
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
       5000-PROCESS-PARA.                                               
                                                                        
           MOVE PARM-AMT-AR-DAY-00     TO WS-AMT-AR-DAY-00.             
           MOVE PARM-AMT-AR-DAY-30     TO WS-AMT-AR-DAY-30.             
           MOVE PARM-AMT-AR-DAY-60     TO WS-AMT-AR-DAY-60.             
           MOVE PARM-AMT-AR-DAY-90     TO WS-AMT-AR-DAY-90.             
           MOVE PARM-AMT-TRAN-BALANCE  TO WS-AMT-TRAN-BAL.              
           MOVE PARM-TOT-SUMM-UNBILLED TO WS-TOT-SUM-UNBILL.            
           MOVE PARM-ITEM-ID           TO WS-ITEM-ID.                   
           MOVE PARM-ITEM-ID           TO WS-ITEM-ID-N.                 
           MOVE WS-ITEM-ID-N           TO WS-ITEM-ID-C.                 
           MOVE PARM-AMT-UNUSED-CR     TO WS-AMT-UNUSED-CR.             
           MOVE WS-ACCOUNT-NO          TO AT-ACCOUNT-NO.                
           MOVE PARM-USER-ID           TO PF-USER-ID.                   
           PERFORM 7000-SELECT-ACCOUNT    THRU 7000-EXIT.               
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT         
                                          WS-PRE-CD-DATA-PRESENT.       
                                                                        
           IF WS-AR-TYPE-SHORT-DESC EQUAL 'BBP' AND                     
              WS-CODE-PRE-PAY-PLAN  EQUAL 'A'                           
              MOVE 'PRP'               TO WS-AR-TYPE-SHORT-DESC         
           END-IF                                                       
                                                                        
           PERFORM 5100-GET-CURR-TIMESTAMP  THRU 5100-EXIT.             
           PERFORM 7300-GET-RESP-ARE-ID     THRU 7300-EXIT.             
                                                                        
      *    WRITE A TRANSACTION HISTORY FOR THE HEADER ROW               05901000
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE PF-RESP-AREA-ID        TO MH-RESP-AREA-ID.              
           MOVE AT-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO MH-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO MH-PREMISE-NO.                
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE 'CSR04573'             TO MH-APPL-PROGRAM-ID.           
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                       TO MH-TRAN-COMMENT-LEN.          
           INITIALIZE DCLCSS-AR-CNTL                                    
      *    INSERT , UPDATE AND DELETE PROCESS                                   
           PERFORM 5200-PROCESS-UPD-INS-DEL-PARA THRU 5200-EXIT.        
                                                                        
      *    TO WRITE A TRANSACTION HIST FOR DETAIL ROW IN AR CNTL TABLE  05913010
           PERFORM 5300-MOVE-TRAN-DET            THRU 5300-EXIT.        
                                                                        
      *    TO WRITE A TRANSACTION HIST FOR SUMMARY ROW IN AR CNTL TABLE 05920210
      *    IF WS-PYMT-PRIORITY-LVL > 50 OR WS-ITEM-ID > 0               05920310
           IF WS-ITEM-ID > 0                                            
              PERFORM 5400-MOVE-TRAN-SUMM        THRU 5400-EXIT         
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06010000
      * 5100-GET-CURR-TIMESTAMP                                       * 06020000
      ******************************************************************06030000
       5100-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06070000
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP            06080000
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                 06090000
MFA-TR*    END-EXEC.                                                    06100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '5100'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06301017
      * 5200-PROCESS-UPD-INS-DEL-PARA                                  *06302017
      ******************************************************************06303017
       5200-PROCESS-UPD-INS-DEL-PARA.                                   
                                                                        
           EVALUATE TRUE                                                
              WHEN PARM-PROCESSING-FL = 'U'                             
                   MOVE 'Y'                      TO WS-UPDATE-FLAG      
                   PERFORM 5250-UPDATE-PROCESS      THRU 5250-EXIT      
              WHEN PARM-PROCESSING-FL = 'D'                             
                  MOVE 'Y'                       TO WS-DELETED-FLAG     
                  IF  WS-ITEM-ID = 0                                    
                      PERFORM 7350-DETAIL-ROW-EXISTS-PARA THRU 7350-EXIT
      *               SHOULD NOT ALLOW TO DELETE SUMMARY ROW WHEN               
      *               DETAIL ROW EXIST.                                         
                      IF  WS-DTL-EXISTS = 'Y'                           
                          MOVE ZEROS             TO S-RETURN-CODE       
                          MOVE ZEROS             TO S-APPL-RETURN-CODE  
                          MOVE SPACES            TO S-AR-LOCKOUT-IND    
                          MOVE 'AM00000002'      TO S-BUS-RULE-ID       
                          MOVE 'F'               TO S-BUS-RULE-RESULT-CD
                          IF S-BUS-RULE-ID > SPACES                     
                             PERFORM 7020-GET-RULE-XREF-ID              
                                                    THRU 7020-EXIT      
                          END-IF                                        
                          ADD +1                 TO   CTR-ROWS          
                          PERFORM 9999-END-PROGRAM                      
                                                 THRU 9999-EXIT         
                      END-IF                                            
                  ELSE                                                  
                     PERFORM 5210-DELETE-PROCESS THRU 5210-EXIT         
                  END-IF                                                
                  PERFORM 7100-SELECT-AR-CONTROL THRU 7100-EXIT         
                  PERFORM 8300-DELETE-AR-CNTL    THRU 8300-EXIT         
                  STRING 'PYMT PRIORITY LVL=  '                         
                          WS-AR-TYPE-SHORT-DESC                         
                         ' ;  '                                         
                         PARM-COMMENT-TEXT                              
                  DELIMITED BY SIZE            INTO MH-TRAN-COMMENT-TEXT
                  IF DELETED-SUMM-ROW OR WS-ITEM-ID = WS-ZERO           
                      EVALUATE TRUE                                     
                          WHEN WS-PYMT-PRIORITY-LVL = +90               
                               MOVE SPACES      TO WS-CODE-DPP-ACCT     
                               SET UPD-CODE-DATA-PRESENT TO TRUE        
                          WHEN WS-PYMT-PRIORITY-LVL = +129              
                               MOVE SPACES      TO WS-CODE-PROJECT-SHARE
                               SET UPD-CODE-DATA-PRESENT TO TRUE        
                          WHEN OTHER                                    
                               CONTINUE                                 
                  END-IF                                                
      *           BASED ON THE FLAG WILL WRITE TRANSACTION HISTORY              
                  IF WS-CODES-DATA-PRESENT NOT EQUAL                    
                                               AT-CODES-DATA-PRESENT    
                     MOVE 'Y'    TO WS-CD-DATA-PRESENT-CHNGD            
                  END-IF                                                
      *           UPDATE CODES DATA PRESENT IN CSS_ACCOUNT TABLE                
                  IF UPD-CODE-DATA-PRESENT                              
                     MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT
                     PERFORM 8250-UPD-CODE-DATA-PRESENT THRU 8250-EXIT  
                  END-IF                                                
              WHEN PARM-PROCESSING-FL = 'I'                             
                  MOVE 'Y'                       TO WS-INSERT-FLAG      
                  PERFORM 7200-SELECT-INSERT-AR-CNTL THRU 7200-EXIT     
      *           SHOULD NOT ALLOW TO INSERT WHEN ALREADY ROW EXIST.    06313517
                  IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL       
                      MOVE ZEROS                 TO S-RETURN-CODE       
                      MOVE ZEROS                 TO S-APPL-RETURN-CODE  
                      MOVE SPACES                TO S-AR-LOCKOUT-IND    
                      MOVE 'AM00000003'          TO S-BUS-RULE-ID       
                      MOVE 'F'                   TO S-BUS-RULE-RESULT-CD
                      IF S-BUS-RULE-ID > SPACES                         
                         PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT   
                      END-IF                                            
                      ADD +1                     TO   CTR-ROWS          
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                  END-IF                                                
                  IF WS-ITEM-ID > 0                                     
                     PERFORM 5220-INSERT-PROCESS THRU 5220-EXIT         
                  END-IF                                                
                  PERFORM 8400-INSERT-AR-CNTL           THRU 8400-EXIT  
                  STRING 'PYMT PRIORITY LVL = '                         
                          WS-AR-TYPE-SHORT-DESC                         
                         ' ;  '                                         
                         PARM-COMMENT-TEXT                              
                  DELIMITED BY SIZE            INTO MH-TRAN-COMMENT-TEXT
           END-EVALUATE.                                                
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06316317
      * 1. IF ITEM ID > 0 AND HAS MULTIBLE DETAILS ROW THEN DELETES    *        
      * DETAIL ROW AND UPDATE  SUMMARY ROW WITH SUM OF AMOUNT          *        
      * FIELDS OF DETAIL ROW.                                          *        
      * 2. IF ITEM ID > 0 AND ONLY ONE DETAIL ROW EXIST THEN DELETE    *06316417
      * DETAIL ROW AND DELETE SUMMARY ROW.                             *06316417
      ******************************************************************06316517
       5210-DELETE-PROCESS.                                             
                                                                        
           PERFORM 7360-DETAIL-ROW-EXISTS      THRU 7360-EXIT           
           IF WS-DETAIL-ROW-EXIST = 'Y'                                 
              PERFORM 7370-GET-SUM-OF-TOT-AMT  THRU 7370-EXIT           
              PERFORM 7380-GET-PRE-SUMM-AMT    THRU 7380-EXIT           
              PERFORM 8200-UPDATE-AR-CNTL      THRU 8200-EXIT           
           ELSE                                                         
              PERFORM 7380-GET-PRE-SUMM-AMT    THRU 7380-EXIT           
              PERFORM 8310-DELETE-SUMM-AR-CNTL THRU 8310-EXIT           
ACT167        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
ACT167           SET DELETED-SUMM-ROW  TO TRUE                          
ACT167        END-IF                                                    
           END-IF.                                                      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06318017
      * 1.WHEN ITEM_ID > 0 AND NO SUMMARY ROW THEN INSERTS A SUMMARY   *06318117
      *   ROW WITH ITEM_ID AS ZERO AND INSERTS DETAIL ROW.             *06318117
      * 2.WHEN ITEM_ID > 0 AND SUMMARY ROW EXISTS THEN INSERTS DETAIL  *06318117
      *   ROW AND UPDATES THE SUMMARY ROW WITH SUM OF AMT FIELDS OF    *06318117
      *   DETAIL ROW.                                                  *        
      ******************************************************************06318217
       5220-INSERT-PROCESS.                                             
                                                                        
           PERFORM 7250-SUMM-ROW-EXISTS-PARA  THRU 7250-EXIT            
           IF WS-SUMM-EXISTS = 'N'                                      
              MOVE WS-ZERO             TO WS-PRE-AR-DAY-00              
                                          WS-PRE-AR-DAY-30              
                                          WS-PRE-AR-DAY-60              
                                          WS-PRE-AR-DAY-90              
                                          WS-PRE-UNUSED-CR              
                                          WS-PRE-TRAN-BALANCE           
                                          WS-PRE-SUMM-UNBILLED          
              MOVE WS-AMT-AR-DAY-00    TO WS-SUM-AR-DAY-00              
              MOVE WS-AMT-AR-DAY-30    TO WS-SUM-AR-DAY-30              
              MOVE WS-AMT-AR-DAY-60    TO WS-SUM-AR-DAY-60              
              MOVE WS-AMT-AR-DAY-90    TO WS-SUM-AR-DAY-90              
              MOVE WS-AMT-UNUSED-CR    TO WS-SUM-UNUSED-CR              
              MOVE WS-AMT-TRAN-BAL     TO WS-SUM-TRAN-BAL               
              MOVE WS-TOT-SUM-UNBILL   TO WS-SUM-SUMM-UNBILL            
              MOVE WS-ZERO             TO WS-ITEM-ID                    
              PERFORM 8400-INSERT-AR-CNTL THRU 8400-EXIT                
              MOVE PARM-ITEM-ID        TO WS-ITEM-ID                    
              SET INSERTED-SUMM-ROW    TO TRUE                          
           ELSE                                                         
              PERFORM 7370-GET-SUM-OF-TOT-AMT THRU 7370-EXIT            
              ADD WS-AMT-AR-DAY-00     TO WS-SUM-AR-DAY-00              
              ADD WS-AMT-AR-DAY-30     TO WS-SUM-AR-DAY-30              
              ADD WS-AMT-AR-DAY-60     TO WS-SUM-AR-DAY-60              
              ADD WS-AMT-AR-DAY-90     TO WS-SUM-AR-DAY-90              
              ADD WS-AMT-UNUSED-CR     TO WS-SUM-UNUSED-CR              
              ADD WS-AMT-TRAN-BAL      TO WS-SUM-TRAN-BAL               
              ADD WS-TOT-SUM-UNBILL    TO WS-SUM-SUMM-UNBILL            
              PERFORM 7380-GET-PRE-SUMM-AMT   THRU 7380-EXIT            
              PERFORM 8200-UPDATE-AR-CNTL     THRU 8200-EXIT            
           END-IF.                                                      
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06322017
      *                                                                *06322117
      *5250-UPDATE-PROCESS.                                            *06322217
      ******************************************************************06322617
       5250-UPDATE-PROCESS.                                             
                                                                        
           PERFORM 7100-SELECT-AR-CONTROL      THRU 7100-EXIT           
      *    SHOULD NOT ALLOW TO UPDATE WHEN LAST UPDATE TS WAS NOT MATCH         
           IF  PARM-AC-LAST-UPDATE-TS NOT = AC-LAST-UPDATE-TS           
               MOVE ZEROS                 TO S-RETURN-CODE              
               MOVE ZEROS                 TO S-APPL-RETURN-CODE         
               MOVE SPACES                TO S-AR-LOCKOUT-IND           
               MOVE 'AM00000006'          TO S-BUS-RULE-ID              
               MOVE 'F'                   TO S-BUS-RULE-RESULT-CD       
               IF S-BUS-RULE-ID > SPACES                                
                  PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT          
               END-IF                                                   
               ADD +1                     TO   CTR-ROWS                 
               PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                
           END-IF.                                                      
      ******************************************************************06322017
      *1. WHEN ITEM_ID > 0 AND SUMMARY ROW EXISTS THEN UPDATES THE     *06322117
      *   THE DETAIL ROW AND UPDATES THE SUMMARY WITH SUM OF AMOUNT    *06322217
      *   FIELDS OF DETAILS ROWS.                                      *06322317
      ******************************************************************        
           IF WS-ITEM-ID  > WS-ZERO                                     
              PERFORM 7370-GET-SUM-OF-TOT-AMT THRU 7370-EXIT            
              ADD WS-AMT-AR-DAY-00     TO WS-SUM-AR-DAY-00              
              ADD WS-AMT-AR-DAY-30     TO WS-SUM-AR-DAY-30              
              ADD WS-AMT-AR-DAY-60     TO WS-SUM-AR-DAY-60              
              ADD WS-AMT-AR-DAY-90     TO WS-SUM-AR-DAY-90              
              ADD WS-AMT-UNUSED-CR     TO WS-SUM-UNUSED-CR              
              ADD WS-AMT-TRAN-BAL      TO WS-SUM-TRAN-BAL               
              ADD WS-TOT-SUM-UNBILL    TO WS-SUM-SUMM-UNBILL            
              PERFORM 7380-GET-PRE-SUMM-AMT   THRU 7380-EXIT            
              PERFORM 8200-UPDATE-AR-CNTL     THRU 8200-EXIT            
           END-IF                                                       
           PERFORM 8100-UPDATE-AR-CNTL THRU 8100-EXIT                   
           STRING 'PYMT PRIORITY LVL = '                                
                   WS-AR-TYPE-SHORT-DESC                                
                  ' ;  '                                                
                   PARM-COMMENT-TEXT                                    
                   DELIMITED BY SIZE     INTO MH-TRAN-COMMENT-TEXT.     
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06326700
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF      *   06327000
      * SO THEN WRITE A RECORD IN THE TRNSCTN DETAIL FOR DETAIL ROW *   06330010
      ***************************************************************   06340000
       5300-MOVE-TRAN-DET.                                              
                                                                        
           MOVE '5300'                     TO ACTIVE-PARAGRAPH.         
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE 1                          TO WS-TRAN-APPL-NO           
                                              MI-TRAN-APPL-NO.          
           MOVE '48'                       TO MI-TABLE-ID.              
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO              
           IF WS-CD-DATA-PRESENT-CHNGD EQUAL 'Y'                        
              MOVE +32                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE AT-CODES-DATA-PRESENT    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-PRE-CD-DATA-PRESENT   TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'CODES DATA PRESENT'     TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO              
           IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y' OR          
              WS-UPDATE-FLAG  = 'Y'                                     
                                                                        
              MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
              IF WS-DELETED-FLAG = 'Y'                                  
                 MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 IF WS-INSERT-FLAG = 'Y'                                
                    MOVE '**INSERTED**'    TO MI-CHG-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                   IF WS-UPDATE-FLAG = 'Y'                              
                      MOVE '**UPDATED**'   TO MI-CHG-COLUMN-VALUE-TEXT  
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
              MOVE WS-ITEM-ID              TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE 'ITEM ID '              TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                     TO WS-TRAN-APPL-NO              
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-00 NOT EQUAL AC-AMT-AR-DAY-00 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y'                                  
                 MOVE AC-AMT-AR-DAY-00       TO WS-COMP-2-CHAR-CONV     
                 MOVE WS-COMP-2-CHAR-CONV    TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '**DELETED**'          TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 IF WS-INSERT-FLAG = 'Y'                                
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE AC-AMT-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 00  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-30 NOT EQUAL AC-AMT-AR-DAY-30 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG  = 'Y'            
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y'                                  
                 MOVE AC-AMT-AR-DAY-30       TO WS-COMP-2-CHAR-CONV     
                 MOVE WS-COMP-2-CHAR-CONV    TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '**DELETED**'          TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 IF WS-INSERT-FLAG = 'Y'                                
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE AC-AMT-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 30  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
           IF WS-AMT-AR-DAY-60 NOT EQUAL AC-AMT-AR-DAY-60 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG  = 'Y'            
               MOVE +15                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
               IF WS-DELETED-FLAG = 'Y'                                 
                  MOVE AC-AMT-AR-DAY-60      TO WS-COMP-2-CHAR-CONV     
                  MOVE WS-COMP-2-CHAR-CONV   TO MI-PRV-COLUMN-VALUE-TEXT
                  MOVE '**DELETED**'         TO MI-CHG-COLUMN-VALUE-TEXT
               ELSE                                                     
                  IF WS-INSERT-FLAG = 'Y'                               
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE AC-AMT-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  END-IF                                                
               END-IF                                                   
               MOVE 'AMT AR DAY 60  '        TO MI-COLUMN-DESC          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                         TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-90 NOT EQUAL AC-AMT-AR-DAY-90 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG  = 'Y'            
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y'                                  
                 MOVE AC-AMT-AR-DAY-90       TO WS-COMP-2-CHAR-CONV     
                 MOVE WS-COMP-2-CHAR-CONV    TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE '**DELETED**'          TO MI-CHG-COLUMN-VALUE-TEXT
              ELSE                                                      
                 IF WS-INSERT-FLAG = 'Y'                                
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE AC-AMT-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 90  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
            MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO         
            IF WS-AMT-UNUSED-CR NOT EQUAL AC-AMT-UNUSED-CR OR           
               WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG  = 'Y'           
               MOVE +15                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
               IF WS-DELETED-FLAG = 'Y'                                 
                  MOVE AC-AMT-UNUSED-CR      TO WS-COMP-2-CHAR-CONV     
                  MOVE WS-COMP-2-CHAR-CONV   TO MI-PRV-COLUMN-VALUE-TEXT
                  MOVE '**DELETED**'         TO MI-CHG-COLUMN-VALUE-TEXT
               ELSE                                                     
                  IF WS-INSERT-FLAG = 'Y'                               
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE AC-AMT-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-AMT-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  END-IF                                                
               END-IF                                                   
               MOVE 'AMT UNUSED CR  '        TO MI-COLUMN-DESC          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                         TO WS-TRAN-APPL-NO         
            END-IF                                                      
                                                                        
            MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO         
            IF WS-AMT-TRAN-BAL NOT EQUAL AC-AMT-TRAN-BALANCE OR         
               WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'            
               MOVE +15                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
               IF WS-DELETED-FLAG = 'Y'                                 
                  MOVE AC-AMT-TRAN-BALANCE   TO WS-COMP-2-CHAR-CONV     
                  MOVE WS-COMP-2-CHAR-CONV   TO MI-PRV-COLUMN-VALUE-TEXT
                  MOVE '**DELETED**'         TO MI-CHG-COLUMN-VALUE-TEXT
               ELSE                                                     
                 IF WS-INSERT-FLAG = 'Y'                                
                   MOVE '**INSERTED**'       TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE WS-AMT-TRAN-BAL      TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE AC-AMT-TRAN-BALANCE  TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE WS-AMT-TRAN-BAL      TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
               END-IF                                                   
               MOVE 'TRANAMT BALANCE'        TO MI-COLUMN-DESC          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                         TO WS-TRAN-APPL-NO         
            END-IF                                                      
                                                                        
            MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO         
            IF WS-TOT-SUM-UNBILL NOT EQUAL AC-TOT-SUMM-UNBILLED OR      
               WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'            
               MOVE +15                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
               IF WS-DELETED-FLAG = 'Y'                                 
                  MOVE AC-TOT-SUMM-UNBILLED  TO WS-COMP-2-CHAR-CONV     
                  MOVE WS-COMP-2-CHAR-CONV   TO MI-PRV-COLUMN-VALUE-TEXT
                  MOVE '**DELETED**'         TO MI-CHG-COLUMN-VALUE-TEXT
               ELSE                                                     
                 IF WS-INSERT-FLAG = 'Y'                                
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-TOT-SUM-UNBILL   TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                    MOVE AC-TOT-SUMM-UNBILLED TO WS-COMP-2-CHAR-CONV    
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-TOT-SUM-UNBILL   TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                 END-IF                                                 
               END-IF                                                   
               MOVE 'TOTSUM UNBILLED'        TO MI-COLUMN-DESC          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1                         TO WS-TRAN-APPL-NO         
            END-IF.                                                     
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   08211010
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF      *   08212010
      * SO THEN WRITE A RECORD IN THE TRNSCTN DETAIL FOR SUMMARY ROW*   08213010
      ***************************************************************   08214010
       5400-MOVE-TRAN-SUMM.                                             
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO              
           IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y' OR          
              WS-UPDATE-FLAG  = 'Y'                                     
              MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
              IF DELETED-SUMM-ROW                                       
                 MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 IF INSERTED-SUMM-ROW                                   
                    MOVE '**INSERTED**'    TO MI-CHG-COLUMN-VALUE-TEXT  
                 ELSE                                                   
                    MOVE '**UPDATED**'     TO MI-CHG-COLUMN-VALUE-TEXT  
                 END-IF                                                 
              END-IF                                                    
              MOVE '0'                     TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE 'ITEM ID'               TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                     TO WS-TRAN-APPL-NO              
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO              
           IF WS-AMT-AR-DAY-00 NOT EQUAL AC-AMT-AR-DAY-00 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN    
                                            MI-CHG-COLUMN-VALUE-LEN     
              IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'OR        
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  IF INSERTED-SUMM-ROW                                  
                    MOVE '**INSERTED**'   TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE WS-SUM-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE WS-SUM-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-00    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 00  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-30 NOT EQUAL AC-AMT-AR-DAY-30 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'OR        
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  IF INSERTED-SUMM-ROW                                  
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-SUM-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE WS-SUM-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-30    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 30  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-60 NOT EQUAL AC-AMT-AR-DAY-60 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'OR        
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  IF INSERTED-SUMM-ROW                                  
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-SUM-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE WS-SUM-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-60    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 60  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-AR-DAY-90 NOT EQUAL AC-AMT-AR-DAY-90 OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'OR        
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  IF INSERTED-SUMM-ROW                                  
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-SUM-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                    MOVE WS-SUM-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-AR-DAY-90    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT AR DAY 90  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-UNUSED-CR NOT EQUAL AC-AMT-UNUSED-CR OR            
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG  = 'Y'            
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y'  OR WS-INSERT-FLAG = 'Y' OR      
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   IF INSERTED-SUMM-ROW                                 
                    MOVE '**INSERTED**'   TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE WS-SUM-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                   ELSE                                                 
                    MOVE WS-SUM-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-UNUSED-CR    TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
              MOVE 'AMT UNUSED CR  '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-AMT-TRAN-BAL NOT EQUAL AC-AMT-TRAN-BALANCE OR          
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y'  OR WS-INSERT-FLAG = 'Y' OR      
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-TRAN-BALANCE TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   IF INSERTED-SUMM-ROW                                 
                    MOVE '**INSERTED**'      TO MI-PRV-COLUMN-VALUE-TEXT
                    MOVE WS-SUM-TRAN-BAL     TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                   ELSE                                                 
                    MOVE WS-SUM-TRAN-BAL     TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-TRAN-BALANCE TO WS-COMP-2-CHAR-CONV     
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
              MOVE 'TRANAMT BALANCE'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           IF WS-TOT-SUM-UNBILL NOT EQUAL AC-TOT-SUMM-UNBILLED OR       
              WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y'             
              MOVE +15                       TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
              IF WS-DELETED-FLAG = 'Y' OR WS-INSERT-FLAG = 'Y' OR       
                 WS-UPDATE-FLAG  = 'Y'                                  
                 IF DELETED-SUMM-ROW                                    
                    MOVE '**DELETED**'       TO MI-CHG-COLUMN-VALUE-TEXT
                    MOVE WS-PRE-SUMM-UNBILLED  TO WS-COMP-2-CHAR-CONV   
                    MOVE WS-COMP-2-CHAR-CONV TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  IF INSERTED-SUMM-ROW                                  
                   MOVE '**INSERTED**'       TO MI-PRV-COLUMN-VALUE-TEXT
                   MOVE WS-SUM-SUMM-UNBILL   TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-CHG-COLUMN-VALUE-TEXT
                  ELSE                                                  
                                                                        
                   MOVE WS-SUM-SUMM-UNBILL   TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-CHG-COLUMN-VALUE-TEXT
                   MOVE WS-PRE-SUMM-UNBILLED TO WS-COMP-2-CHAR-CONV     
                   MOVE WS-COMP-2-CHAR-CONV  TO MI-PRV-COLUMN-VALUE-TEXT
                  END-IF                                                
                 END-IF                                                 
              END-IF                                                    
              MOVE 'TOTSUM UNBILLED'         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08550811
      *   6530-LOAD-MNT-TRANS-HIST                                     *08551000
      ******************************************************************08560000
                                                                        
           EXEC SQL                                                     08580000
              INCLUDE CPD00067                                          08590000
           END-EXEC.                                                    08600000
                                                                        
      ***************************************************************   08640000
      * 7000-SELECT-ACCOUNT                                         *   08650000
      ***************************************************************   08680000
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT PREMISE_NO                                          
                   ,CUSTOMER_NO                                         
                   ,CODES_DATA_PRESENT                                  
               INTO :AT-PREMISE-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-CODES-DATA-PRESENT                              
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08740000
MFA-TR*      SELECT PREMISE_NO                                          08750000
MFA-TR*            ,CUSTOMER_NO                                         08760000
MFA-TR*            ,CODES_DATA_PRESENT                                  08770000
MFA-TR*        INTO :AT-PREMISE-NO                                      08870000
MFA-TR*            ,:AT-CUSTOMER-NO                                     08880000
MFA-TR*            ,:AT-CODES-DATA-PRESENT                              08890000
MFA-TR*        FROM CSS_ACCOUNT                                         09030000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         09040000
MFA-TR*       WITH UR                                                   09041000
MFA-TR*       QUERYNO 7000                                              09042000
MFA-TR*    END-EXEC.                                                    09050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_ACCOUNT'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09240200
      * 7100-SELECT-AR-CONTROL                                         *09240300
      ******************************************************************09240500
       7100-SELECT-AR-CONTROL.                                          
                                                                        
           EXEC SQL                                                     
             SELECT AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_TRAN_BALANCE                                    
                   ,TOT_SUMM_UNBILLED                                   
                   ,AMT_UNUSED_CR                                       
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
              INTO :AC-AMT-AR-DAY-00                                    
                  ,:AC-AMT-AR-DAY-30                                    
                  ,:AC-AMT-AR-DAY-60                                    
                  ,:AC-AMT-AR-DAY-90                                    
                  ,:AC-AMT-TRAN-BALANCE                                 
                  ,:AC-TOT-SUMM-UNBILLED                                
                  ,:AC-AMT-UNUSED-CR                                    
                  ,:AC-LAST-UPDATE-TS                                   
              FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
             WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                   
               AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            
               AND ITEM_ID           = :WS-ITEM-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09241100
MFA-TR*      SELECT AMT_AR_DAY_00                                       09241200
MFA-TR*            ,AMT_AR_DAY_30                                       09241300
MFA-TR*            ,AMT_AR_DAY_60                                       09241400
MFA-TR*            ,AMT_AR_DAY_90                                       09241500
MFA-TR*            ,AMT_TRAN_BALANCE                                    09241600
MFA-TR*            ,TOT_SUMM_UNBILLED                                   09241700
MFA-TR*            ,AMT_UNUSED_CR                                       09241800
MFA-TR*            ,LAST_UPDATE_TS                                      09241900
MFA-TR*       INTO :AC-AMT-AR-DAY-00                                    09242000
MFA-TR*           ,:AC-AMT-AR-DAY-30                                    09242100
MFA-TR*           ,:AC-AMT-AR-DAY-60                                    09242200
MFA-TR*           ,:AC-AMT-AR-DAY-90                                    09242300
MFA-TR*           ,:AC-AMT-TRAN-BALANCE                                 09242400
MFA-TR*           ,:AC-TOT-SUMM-UNBILLED                                09242500
MFA-TR*           ,:AC-AMT-UNUSED-CR                                    09242600
MFA-TR*           ,:AC-LAST-UPDATE-TS                                   09242700
MFA-TR*       FROM CSS_AR_CNTL                                          09242900
MFA-TR*      WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                   09243100
MFA-TR*        AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL            09243300
MFA-TR*        AND ITEM_ID           = :WS-ITEM-ID                      09243400
MFA-TR*       WITH UR                                                   09243500
MFA-TR*    QUERYNO 7100                                                 09243600
MFA-TR*    END-EXEC.                                                    09243700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES              TO ABEND-TABLES                 
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7100'              TO ACTIVE-PARAGRAPH             
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE 'CSS_AR_CNTL'       TO TABLE-1                      
               MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
               MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2              
               MOVE 'ITEM_ID'           TO TABLE-ELEMENT-3              
               MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               MOVE WS-PYMT-PRIORITY-LVL                                
                                        TO HOSTVAR-ELEMENT-2            
               MOVE WS-ITEM-ID          TO HOSTVAR-ELEMENT-3            
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09246400
      * 7200-SELECT-INSERT-AR-CNTL                                     *09246500
      ******************************************************************09246600
       7200-SELECT-INSERT-AR-CNTL.                                      
                                                                        
           INITIALIZE AC-AMT-AR-DAY-00                                  
                      AC-AMT-AR-DAY-30                                  
                      AC-AMT-AR-DAY-60                                  
                      AC-AMT-AR-DAY-90                                  
                      AC-AMT-TRAN-BALANCE                               
                      AC-TOT-SUMM-UNBILLED                              
                      AC-AMT-UNUSED-CR.                                 
           EXEC SQL                                                     
             SELECT AMT_AR_DAY_00                                       
                   ,AMT_AR_DAY_30                                       
                   ,AMT_AR_DAY_60                                       
                   ,AMT_AR_DAY_90                                       
                   ,AMT_TRAN_BALANCE                                    
                   ,TOT_SUMM_UNBILLED                                   
                   ,AMT_UNUSED_CR                                       
               INTO :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-AMT-UNUSED-CR                                   
               FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL           
                AND ITEM_ID           = :WS-ITEM-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09247900
MFA-TR*      SELECT AMT_AR_DAY_00                                       09248000
MFA-TR*            ,AMT_AR_DAY_30                                       09248100
MFA-TR*            ,AMT_AR_DAY_60                                       09248200
MFA-TR*            ,AMT_AR_DAY_90                                       09248300
MFA-TR*            ,AMT_TRAN_BALANCE                                    09248400
MFA-TR*            ,TOT_SUMM_UNBILLED                                   09248500
MFA-TR*            ,AMT_UNUSED_CR                                       09248600
MFA-TR*        INTO :AC-AMT-AR-DAY-00                                   09248700
MFA-TR*            ,:AC-AMT-AR-DAY-30                                   09248800
MFA-TR*            ,:AC-AMT-AR-DAY-60                                   09248900
MFA-TR*            ,:AC-AMT-AR-DAY-90                                   09249000
MFA-TR*            ,:AC-AMT-TRAN-BALANCE                                09249100
MFA-TR*            ,:AC-TOT-SUMM-UNBILLED                               09249200
MFA-TR*            ,:AC-AMT-UNUSED-CR                                   09249300
MFA-TR*        FROM CSS_AR_CNTL                                         09249500
MFA-TR*       WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                  09249700
MFA-TR*         AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL           09249900
MFA-TR*         AND ITEM_ID           = :WS-ITEM-ID                     09250000
MFA-TR*        WITH UR                                                  09250100
MFA-TR*     QUERYNO 7200                                                09250200
MFA-TR*    END-EXEC.                                                    09250300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 09250600
             IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND   
                CONTINUE                                                
             ELSE                                                       
                 MOVE SPACES             TO ABEND-TABLES                
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                 MOVE '7200'             TO ACTIVE-PARAGRAPH            
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_AR_CNTL'      TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1             
                 MOVE 'PYMT_PRIORITY_LVL'                               
                                         TO TABLE-ELEMENT-2             
                 MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3             
                 MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
                 MOVE WS-PYMT-PRIORITY-LVL                              
                                         TO HOSTVAR-ELEMENT-2           
                 MOVE WS-ITEM-ID         TO HOSTVAR-ELEMENT-3           
                 PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT    
                 PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT
             END-IF.   
      *                                                                 09252600
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09252900
      ******************************************************************09253000
      * 7250-SUMM-ROW-EXISTS-PARA                                      *09253100
      ******************************************************************09253200
       7250-SUMM-ROW-EXISTS-PARA.                                       
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SUMM-EXISTS                                    
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :WS-ZERO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09253600
MFA-TR*       SELECT 'Y'                                                09253700
MFA-TR*         INTO :WS-SUMM-EXISTS                                    09253800
MFA-TR*         FROM CSS_AR_CNTL                                        09253900
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 09254000
MFA-TR*          AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL          09254100
MFA-TR*          AND ITEM_ID           = :WS-ZERO                       09254200
MFA-TR*         WITH UR                                                 09254300
MFA-TR*      QUERYNO 7350                                               09254400
MFA-TR*    END-EXEC.                                                    09254500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 09254800
           IF  WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                 
               CONTINUE                                                 
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE =  NOT-FOUND                   
                   MOVE 'N'                TO WS-SUMM-EXISTS            
               ELSE                                                     
                   MOVE SPACES             TO ABEND-TABLES              
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                   MOVE '7250'             TO ACTIVE-PARAGRAPH          
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_AR_CNTL'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE 'PYMT_PRIORITY_LVL'                             
                                           TO TABLE-ELEMENT-2           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   MOVE WS-PYMT-PRIORITY-LVL                            
                                           TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT
                   PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09257500
      * 7300-GET-RESP-ARE-ID.                                        *  09257600
      ****************************************************************  09257700
       7300-GET-RESP-ARE-ID.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                  INTO :PF-RESP-AREA-ID                                 
                  FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                
                 WHERE USER_ID    = :PF-USER-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09258000
MFA-TR*       SELECT PF.RESP_AREA_ID                                    09258100
MFA-TR*           INTO :PF-RESP-AREA-ID                                 09258200
MFA-TR*           FROM CSS_USER_PROFILE PF                              09258300
MFA-TR*          WHERE USER_ID    = :PF-USER-ID                         09258400
MFA-TR*           WITH UR                                               09258500
MFA-TR*        QUERYNO 7300                                             09258600
MFA-TR*    END-EXEC.                                                    09258700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE PF-USER-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09261000
      * 7350-DETAIL-ROW-EXISTS-PARA                                     09261100
      ******************************************************************09261200
       7350-DETAIL-ROW-EXISTS-PARA.                                     
      *                                                                 09261500
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DTL-EXISTS                                     
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         
                 AND ITEM_ID  > 0                                       
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09261600
MFA-TR*       SELECT 'Y'                                                09261700
MFA-TR*         INTO :WS-DTL-EXISTS                                     09261800
MFA-TR*         FROM CSS_AR_CNTL                                        09261900
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                09262000
MFA-TR*          AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         09262100
MFA-TR*          AND ITEM_ID  > 0                                       09262200
MFA-TR*        FETCH FIRST ROW ONLY                                     09262300
MFA-TR*         WITH UR                                                 09262400
MFA-TR*      QUERYNO 7350                                               09262500
MFA-TR*    END-EXEC                                                     09262600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7350'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE WS-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                 09264600
       7350-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09264903
      * CHECK WHETHER DETAILS ROW EXIST FOR THE PYMT PRIORITY LEVEL.   *09265003
      ******************************************************************09265103
       7360-DETAIL-ROW-EXISTS.                                          
      *                                                                 09265303
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-DETAIL-ROW-EXIST                               
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         
                 AND ITEM_ID NOT IN (:WS-ITEM-ID , :WS-ZERO)            
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09265403
MFA-TR*       SELECT 'Y'                                                09265503
MFA-TR*         INTO :WS-DETAIL-ROW-EXIST                               09265603
MFA-TR*         FROM CSS_AR_CNTL                                        09265703
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                09265803
MFA-TR*          AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         09265903
MFA-TR*          AND ITEM_ID NOT IN (:WS-ITEM-ID , :WS-ZERO)            09266004
MFA-TR*        FETCH FIRST ROW ONLY                                     09266103
MFA-TR*         WITH UR                                                 09266203
MFA-TR*      QUERYNO 7360                                               09266303
MFA-TR*    END-EXEC                                                     09266403

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7360'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2               
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-3               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE WS-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE WS-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                 09268603
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09269003
      ******************************************************************09270003
      * GETTING THE SUM OF AMOUNT FIELDS OF DETAILS ROWS TO UPDATE     *09271003
      * TRANSACTION HISTORY TABLE.                                     *09271003
      ******************************************************************09272003
       7370-GET-SUM-OF-TOT-AMT.                                         
      *                                                                 09274003
           EXEC SQL                                                     
              SELECT COALESCE(SUM(AMT_AR_DAY_00),0)                     
                    ,COALESCE(SUM(AMT_AR_DAY_30),0)                     
                    ,COALESCE(SUM(AMT_AR_DAY_60),0)                     
                    ,COALESCE(SUM(AMT_AR_DAY_90),0)                     
                    ,COALESCE(SUM(AMT_UNUSED_CR),0)                     
                    ,COALESCE(SUM(AMT_TRAN_BALANCE),0)                  
                    ,COALESCE(SUM(TOT_SUMM_UNBILLED),0)                 
                INTO :WS-SUM-AR-DAY-00                                  
                    ,:WS-SUM-AR-DAY-30                                  
                    ,:WS-SUM-AR-DAY-60                                  
                    ,:WS-SUM-AR-DAY-90                                  
                    ,:WS-SUM-UNUSED-CR                                  
                    ,:WS-SUM-TRAN-BAL                                   
                    ,:WS-SUM-SUMM-UNBILL                                
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         
                 AND ITEM_ID NOT IN (:WS-ITEM-ID , :WS-ZERO)            
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09275003
MFA-TR*       SELECT COALESCE(SUM(AMT_AR_DAY_00),0)                     09275103
MFA-TR*             ,COALESCE(SUM(AMT_AR_DAY_30),0)                     09275203
MFA-TR*             ,COALESCE(SUM(AMT_AR_DAY_60),0)                     09275303
MFA-TR*             ,COALESCE(SUM(AMT_AR_DAY_90),0)                     09275403
MFA-TR*             ,COALESCE(SUM(AMT_UNUSED_CR),0)                     09275503
MFA-TR*             ,COALESCE(SUM(AMT_TRAN_BALANCE),0)                  09275603
MFA-TR*             ,COALESCE(SUM(TOT_SUMM_UNBILLED),0)                 09275703
MFA-TR*         INTO :WS-SUM-AR-DAY-00                                  09275804
MFA-TR*             ,:WS-SUM-AR-DAY-30                                  09275904
MFA-TR*             ,:WS-SUM-AR-DAY-60                                  09276004
MFA-TR*             ,:WS-SUM-AR-DAY-90                                  09276104
MFA-TR*             ,:WS-SUM-UNUSED-CR                                  09276204
MFA-TR*             ,:WS-SUM-TRAN-BAL                                   09276314
MFA-TR*             ,:WS-SUM-SUMM-UNBILL                                09276414
MFA-TR*         FROM CSS_AR_CNTL                                        09276503
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                09276603
MFA-TR*          AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         09276703
MFA-TR*          AND ITEM_ID NOT IN (:WS-ITEM-ID , :WS-ZERO)            09276803
MFA-TR*         WITH UR                                                 09277003
MFA-TR*      QUERYNO 7370                                               09277103
MFA-TR*    END-EXEC                                                     09277203

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7370'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2               
              MOVE 'ITEM_ID'           TO TABLE-ELEMENT-3               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE WS-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE WS-ITEM-ID           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                 09279403
       7370-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09279704
      * GETTING THE PREVIOUS VALUES OF SUMMARY ROW ( ITEM ID = 0 ) TO  *09279804
      * UPDATE TRANSACTION HISTORY TABLE.                              *09279804
      ******************************************************************09279904
       7380-GET-PRE-SUMM-AMT.                                           
      *                                                                 09280104
           EXEC SQL                                                     
              SELECT AMT_AR_DAY_00                                      
                    ,AMT_AR_DAY_30                                      
                    ,AMT_AR_DAY_60                                      
                    ,AMT_AR_DAY_90                                      
                    ,AMT_UNUSED_CR                                      
                    ,AMT_TRAN_BALANCE                                   
                    ,TOT_SUMM_UNBILLED                                  
                INTO :WS-PRE-AR-DAY-00                                  
                    ,:WS-PRE-AR-DAY-30                                  
                    ,:WS-PRE-AR-DAY-60                                  
                    ,:WS-PRE-AR-DAY-90                                  
                    ,:WS-PRE-UNUSED-CR                                  
                    ,:WS-PRE-TRAN-BALANCE                               
                    ,:WS-PRE-SUMM-UNBILLED                              
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         
                 AND ITEM_ID            = :WS-ZERO                      
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09280204
MFA-TR*       SELECT AMT_AR_DAY_00                                      09280304
MFA-TR*             ,AMT_AR_DAY_30                                      09280404
MFA-TR*             ,AMT_AR_DAY_60                                      09280504
MFA-TR*             ,AMT_AR_DAY_90                                      09280604
MFA-TR*             ,AMT_UNUSED_CR                                      09280704
MFA-TR*             ,AMT_TRAN_BALANCE                                   09280804
MFA-TR*             ,TOT_SUMM_UNBILLED                                  09280904
MFA-TR*         INTO :WS-PRE-AR-DAY-00                                  09281004
MFA-TR*             ,:WS-PRE-AR-DAY-30                                  09281104
MFA-TR*             ,:WS-PRE-AR-DAY-60                                  09281204
MFA-TR*             ,:WS-PRE-AR-DAY-90                                  09281304
MFA-TR*             ,:WS-PRE-UNUSED-CR                                  09281404
MFA-TR*             ,:WS-PRE-TRAN-BALANCE                               09281504
MFA-TR*             ,:WS-PRE-SUMM-UNBILLED                              09281604
MFA-TR*         FROM CSS_AR_CNTL                                        09281704
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                09281804
MFA-TR*          AND PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         09281904
MFA-TR*          AND ITEM_ID            = :WS-ZERO                      09282004
MFA-TR*         WITH UR                                                 09282104
MFA-TR*      QUERYNO 7380                                               09282204
MFA-TR*    END-EXEC                                                     09282304

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7380'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE WS-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09284904
      * 7500-SELECT-AR-TYPE                                             09285004
      ****************************************************************  09285204
       7500-SELECT-AR-TYPE.                                             
                                                                        
           MOVE SPACES                  TO WS-AR-TYPE-SHORT-DESC        
                                                                        
           EXEC SQL                                                     
              SELECT AR_TYPE_SHORT_DESC                                 
                INTO :WS-AR-TYPE-SHORT-DESC                             
                FROM CSS_AR_TYPE                                        
               WHERE PYMT_PRIORITY_LVL  = :WS-PYMT-PRIORITY-LVL         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE     = SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TYPE'        TO TABLE-1                      
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-1              
              MOVE WS-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09288404
      * 7999-SELECT-AL AR LOCKOUT AND TRANSFER ROUTINE               *  09288504
      ****************************************************************  09289004
                                                                        
              EXEC SQL                                                  09300000
                 INCLUDE CPD00075                                       09310000
              END-EXEC.                                                 09320000
                                                                        
              EXEC SQL                                                  09340000
                 INCLUDE CPD00307                                       09350000
              END-EXEC.                                                 09360000
                                                                        
      ******************************************************************09362000
      * 8100-UPDATE-AR-CNTL                                            *09363000
      ******************************************************************09364000
       8100-UPDATE-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_AR_DAY_00     = :WS-AMT-AR-DAY-00             
                     ,AMT_AR_DAY_30     = :WS-AMT-AR-DAY-30             
                     ,AMT_AR_DAY_60     = :WS-AMT-AR-DAY-60             
                     ,AMT_AR_DAY_90     = :WS-AMT-AR-DAY-90             
                     ,AMT_TRAN_BALANCE  = :WS-AMT-TRAN-BAL              
                     ,TOT_SUMM_UNBILLED = :WS-TOT-SUM-UNBILL            
                     ,AMT_UNUSED_CR     = :WS-AMT-UNUSED-CR             
                     ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :WS-ITEM-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     09369100
MFA-TR*        UPDATE CSS_AR_CNTL                                       09369300
MFA-TR*           SET AMT_AR_DAY_00     = :WS-AMT-AR-DAY-00             09369500
MFA-TR*              ,AMT_AR_DAY_30     = :WS-AMT-AR-DAY-30             09369600
MFA-TR*              ,AMT_AR_DAY_60     = :WS-AMT-AR-DAY-60             09369700
MFA-TR*              ,AMT_AR_DAY_90     = :WS-AMT-AR-DAY-90             09369800
MFA-TR*              ,AMT_TRAN_BALANCE  = :WS-AMT-TRAN-BAL              09369900
MFA-TR*              ,TOT_SUMM_UNBILLED = :WS-TOT-SUM-UNBILL            09370000
MFA-TR*              ,AMT_UNUSED_CR     = :WS-AMT-UNUSED-CR             09370100
MFA-TR*              ,LAST_UPDATE_TS    = CURRENT TIMESTAMP             09370200
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                09370400
MFA-TR*           AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         09370600
MFA-TR*           AND ITEM_ID           = :WS-ITEM-ID                   09370700
MFA-TR*    END-EXEC.                                                    09370800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_AR_CNTL'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'PYMT_PRIORITY_LVL'                                 
                                       TO TABLE-ELEMENT-2               
               MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3               
               MOVE 'AMT_TRAN_BALANCE' TO TABLE-ELEMENT-4               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-PYMT-PRIORITY-LVL                                
                                       TO HOSTVAR-ELEMENT-2             
               MOVE WS-ITEM-ID         TO HOSTVAR-ELEMENT-3             
               MOVE WS-AMT-TRAN-BAL    TO WS-AMT-TRAN-BAL-ED            
               MOVE WS-AMT-TRAN-BAL-ED TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09891004
      * UPDATE THE SUMMARY ROW WITH SUM OF AMOUNT FIELDS OF DETAILS ROW*09892004
      ******************************************************************09893004
       8200-UPDATE-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_AR_DAY_00     = :WS-SUM-AR-DAY-00             
                     ,AMT_AR_DAY_30     = :WS-SUM-AR-DAY-30             
                     ,AMT_AR_DAY_60     = :WS-SUM-AR-DAY-60             
                     ,AMT_AR_DAY_90     = :WS-SUM-AR-DAY-90             
A05136*              ,AMT_TRAN_BALANCE  = :WS-SUM-TRAN-BAL              09899314
A05136*              ,TOT_SUMM_UNBILLED = :WS-SUM-SUMM-UNBILL           09899414
                     ,AMT_UNUSED_CR     = :WS-SUM-UNUSED-CR             
                     ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :WS-ZERO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     09896004
MFA-TR*        UPDATE CSS_AR_CNTL                                       09897004
MFA-TR*           SET AMT_AR_DAY_00     = :WS-SUM-AR-DAY-00             09898004
MFA-TR*              ,AMT_AR_DAY_30     = :WS-SUM-AR-DAY-30             09899004
MFA-TR*              ,AMT_AR_DAY_60     = :WS-SUM-AR-DAY-60             09899104
MFA-TR*              ,AMT_AR_DAY_90     = :WS-SUM-AR-DAY-90             09899204
MFA-TR*              ,AMT_TRAN_BALANCE  = :WS-SUM-TRAN-BAL              09899314
MFA-TR*              ,TOT_SUMM_UNBILLED = :WS-SUM-SUMM-UNBILL           09899414
MFA-TR*              ,AMT_UNUSED_CR     = :WS-SUM-UNUSED-CR             09899504
MFA-TR*              ,LAST_UPDATE_TS    = CURRENT TIMESTAMP             09899604
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                09899704
MFA-TR*           AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         09899804
MFA-TR*           AND ITEM_ID           = :WS-ZERO                      09899904
MFA-TR*    END-EXEC.                                                    09900004

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_AR_CNTL'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'PYMT_PRIORITY_LVL'                                 
                                       TO TABLE-ELEMENT-2               
               MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-PYMT-PRIORITY-LVL                                
                                       TO HOSTVAR-ELEMENT-2             
               MOVE WS-ITEM-ID         TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09891004
      * UPDATE THE CODE DATE PRESENT IN CSS_ACCOUNT TABLE              *09892004
      ******************************************************************09893004
       8250-UPD-CODE-DATA-PRESENT.                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_ACCOUNT'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09903004
      * 8300-DELETE-AR-CNTL                                            *09910000
      ******************************************************************09911000
       8300-DELETE-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_AR_CNTL                                  
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND ITEM_ID           = :WS-ITEM-ID                   
                  AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE 'CSS_AR_CNTL'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'PYMT_PRIORITY_LVL'                                 
                                       TO TABLE-ELEMENT-2               
               MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-PYMT-PRIORITY-LVL                                
                                       TO HOSTVAR-ELEMENT-2             
               MOVE WS-ITEM-ID         TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09922104
      * DELETE THE SUMMARY ROW  .                                      *09922204
      ******************************************************************09922304
       8310-DELETE-SUMM-AR-CNTL.                                        
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_AR_CNTL                                  
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND ITEM_ID           = :WS-ZERO                      
                  AND PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT167     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE 'CSS_AR_CNTL'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'PYMT_PRIORITY_LVL'                                 
                                       TO TABLE-ELEMENT-2               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-PYMT-PRIORITY-LVL                                
                                       TO HOSTVAR-ELEMENT-2             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09925704
      * 8400-INSERT-AR-CNTL                                           * 09925804
      ******************************************************************09925904
       8400-INSERT-AR-CNTL.                                             
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_AR_CNTL                                 
                       (ACCOUNT_NO                                      
                      ,PYMT_PRIORITY_LVL                                
                      ,ITEM_ID                                          
                      ,AMT_AR_DAY_00                                    
                      ,AMT_AR_DAY_30                                    
                      ,AMT_AR_DAY_60                                    
                      ,AMT_AR_DAY_90                                    
                      ,AMT_UNUSED_CR                                    
                      ,AMT_TRAN_BALANCE                                 
                      ,TOT_SUMM_UNBILLED                                
                      ,LAST_UPDATE_TS)                                  
               VALUES (:AT-ACCOUNT-NO                                   
                      ,:WS-PYMT-PRIORITY-LVL                            
                      ,:WS-ITEM-ID                                      
                      ,:WS-AMT-AR-DAY-00                                
                      ,:WS-AMT-AR-DAY-30                                
                      ,:WS-AMT-AR-DAY-60                                
                      ,:WS-AMT-AR-DAY-90                                
                      ,:WS-AMT-UNUSED-CR                                
                      ,:WS-AMT-TRAN-BAL                                 
                      ,:WS-TOT-SUM-UNBILL                               
                      ,CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     09926204
MFA-TR*         INSERT INTO CSS_AR_CNTL                                 09926304
MFA-TR*                (ACCOUNT_NO                                      09926404
MFA-TR*               ,PYMT_PRIORITY_LVL                                09926504
MFA-TR*               ,ITEM_ID                                          09926604
MFA-TR*               ,AMT_AR_DAY_00                                    09926704
MFA-TR*               ,AMT_AR_DAY_30                                    09926804
MFA-TR*               ,AMT_AR_DAY_60                                    09926904
MFA-TR*               ,AMT_AR_DAY_90                                    09927004
MFA-TR*               ,AMT_UNUSED_CR                                    09927104
MFA-TR*               ,AMT_TRAN_BALANCE                                 09927204
MFA-TR*               ,TOT_SUMM_UNBILLED                                09927304
MFA-TR*               ,LAST_UPDATE_TS)                                  09927404
MFA-TR*        VALUES (:AT-ACCOUNT-NO                                   09927504
MFA-TR*               ,:WS-PYMT-PRIORITY-LVL                            09927604
MFA-TR*               ,:WS-ITEM-ID                                      09927704
MFA-TR*               ,:WS-AMT-AR-DAY-00                                09927804
MFA-TR*               ,:WS-AMT-AR-DAY-30                                09927904
MFA-TR*               ,:WS-AMT-AR-DAY-60                                09928004
MFA-TR*               ,:WS-AMT-AR-DAY-90                                09928104
MFA-TR*               ,:WS-AMT-UNUSED-CR                                09928204
MFA-TR*               ,:WS-AMT-TRAN-BAL                                 09928304
MFA-TR*               ,:WS-TOT-SUM-UNBILL                               09928404
MFA-TR*               ,CURRENT TIMESTAMP)                               09928504
MFA-TR*    END-EXEC.                                                    09928604

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'INSERT'           TO ABEND-FUNCTION                
               MOVE 'CSS_AR_CNTL'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE 'PYMT_PRIORITY_LVL'                                 
                                       TO TABLE-ELEMENT-2               
               MOVE 'ITEM_ID'          TO TABLE-ELEMENT-3               
               MOVE 'AMT_TRAN_BALANCE' TO TABLE-ELEMENT-4               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               MOVE WS-PYMT-PRIORITY-LVL                                
                                       TO HOSTVAR-ELEMENT-2             
               MOVE WS-ITEM-ID         TO HOSTVAR-ELEMENT-3             
               MOVE WS-AMT-TRAN-BAL    TO WS-AMT-TRAN-BAL-ED            
               MOVE WS-AMT-TRAN-BAL-ED TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09931504
      *  CALLS THE SUBPROGRAM SCSCA182                                * 09932004
      ***************************************************************** 09940000
       9200-LINK-SCSCA182.                                              
                                                                        
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                 SCSCA182-RETURN-CODE                   
                                 SCSCA182-LAST-UPDATE-TS                
                                 ABEND-FILE.                            
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10060000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     10070000
      ****************************************************************  10080000
                                                                        
           EXEC SQL                                                     10100000
             INCLUDE CPDSP300                                           10110000
           END-EXEC.                                                    10120000
                                                                        
      ****************************************************************  10140000
      *       END PROGRAM COPYLIB                                       10150000
      ****************************************************************  10160000
                                                                        
           EXEC SQL                                                     10180000
              INCLUDE CPD00321                                          10190000
           END-EXEC.                                                    10200000
                                                                        
