       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04572.                                         
COB303 DATE-WRITTEN.  OCTOBER 13, 2012.                                 
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *00100000
      *                                                                *00110000
      *  PROGRAM:       CSR04572                                       *00130001
      *  CALLING SP:    UPDSYSTEMMNTACCOUNTDETAILS                     *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS  ROCEDURE UPDATES ACCOUNT DETAILS INTO CSS_ACCOUNT TABLE.*00190002
      *                                                                *        
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  10/13/12  AS7C117    INITIAL PROGRAM VERSION                  *00270002
      ******************************************************************00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04572'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04572 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
           COPY CCA00001.                                               01140000
           COPY CWS00027.                                               01160000
           COPY CWS00056.                                                       
           COPY CWS00303.                                               01170000
           COPY CJF00113.                                                       
                                                                        
           EXEC SQL                                                     01200000
               INCLUDE CWS00013                                         01210000
           END-EXEC.                                                    01220000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04572'.     
           05  WS-ACCOUNT-NO-C          PIC X(13).                      
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C                  
                                        PIC S9(13).                     
           05  WS-ACCT-XFER-TO-C        PIC X(13).                      
           05  WS-ACCT-XFER-TO REDEFINES WS-ACCT-XFER-TO-C              
                                        PIC S9(13).                     
           05  WS-ACCT-XFER-FROM-LST-C  PIC X(13).                      
           05  WS-ACCT-XFER-FROM-LST REDEFINES WS-ACCT-XFER-FROM-LST-C  
                                        PIC S9(13).                     
COB305     05 WS-TOTAL-AR-BALANCE        PIC S9(11)V99 COMP-3 VALUE 0.          
           05  WS-ACCT-CREATE-DT        PIC X(26).                      
           05  WS-ACCT-FINALED-DT       PIC X(26).                      
           05  WS-LAST-UPDATE-TS        PIC X(26)  VALUE SPACES.        
           05  WS-CODE-ACCT-STAT        PIC X(01)  VALUE SPACES.        
COB305     05 WS-CHK-ACC-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  ROW-EXIST                PIC X(01)  VALUE 'N'.           
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-DATE-BILL-DAY-00      PIC X(10) VALUE SPACES.         
           05  WS-DATE-BILL-DAY-30      PIC X(10) VALUE SPACES.         
           05  WS-DATE-BILL-DAY-60      PIC X(10) VALUE SPACES.         
           05  WS-DATE-BILL-DAY-90      PIC X(10) VALUE SPACES.         
                                                                        
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE +0.       
           05  WS-INSERT-FLAG           PIC X(01) VALUE SPACE.          
           05  WS-COMMENT-LEN           PIC S9(4) COMP-3 VALUE 0.       
           05  WS-COMP-2-CHAR-CONV      PIC -Z(10)9.99.                 
                                                                        
       01  WS-LITERALS.                                                 
           05  MCSCA182                 PIC X(08)   VALUE 'MCSCA182'.   
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-2            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-3            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-4            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-5            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-6            PIC S9(04) COMP VALUE +0.       
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04572_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(09) COMP.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
           05  SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
           05  S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACE.          
           05  S-BUS-RULE-ID            PIC X(10) VALUE SPACE.          
           05  S-BUS-RULE-RESULT-CD     PIC X(08) VALUE SPACE.          
           05  S-BUS-RULE-XREF-ID       PIC X(26) VALUE SPACE.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
                                                                        
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBACCT                                            00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBARLOCK                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBMNHIST                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBMNHDT                                           00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00960000
              INCLUDE TBMODEL                                           00970000
           END-EXEC.                                                    00980000
                                                                        
           EXEC SQL                                                     00960000
              INCLUDE TBBUSRUL                                          00970000
           END-EXEC.                                                    00980000
                                                                        
           EXEC SQL                                                     00960000
              INCLUDE TBRULXRF                                          00970000
           END-EXEC.                                                    00980000
      ******************************************************************        
      * CSS_USER_PROFILE   PF                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
       COPY CWS00182.                                                           
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC X(13).                     
       01  PARM-AR-XFER-IND              PIC X(1).                      
       01  PARM-ACCT-XFER-TO             PIC X(13).                     
       01  PARM-ACCT-XFER-FROM-LST       PIC X(13).                     
COB305 01 PARM-TOTAL-AR-BALANCE        PIC S9(11)V99 COMP-3 VALUE 0.          
       01  PARM-CODE-ACCT-STAT           PIC X(01).                     
       01  PARM-DATE-BILL-DAY-00         PIC X(10).                     
       01  PARM-DATE-BILL-DAY-30         PIC X(10).                     
       01  PARM-DATE-BILL-DAY-60         PIC X(10).                     
       01  PARM-DATE-BILL-DAY-90         PIC X(10).                     
       01  PARM-USER-ID                  PIC X(07).                     
       01  PARM-COMMENT-TEXT             PIC X(210).                    
       01  PARM-PROCESSING-FL            PIC X(01).                     
       01  PARM-AT-LAST-UPDATE-TS        PIC X(26).                     
       01  PARM-CODES-DATA-PRESENT       PIC X(32).                     
       01  PARM-ACCT-CREATE-DT           PIC X(26).                     
       01  PARM-ACCT-FINALED-DT          PIC X(26).                     
                                                                        
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-AR-XFER-IND                        
                                PARM-ACCT-XFER-TO                       
                                PARM-ACCT-XFER-FROM-LST                 
                                PARM-TOTAL-AR-BALANCE                   
                                PARM-CODE-ACCT-STAT                     
                                PARM-DATE-BILL-DAY-00                   
                                PARM-DATE-BILL-DAY-30                   
                                PARM-DATE-BILL-DAY-60                   
                                PARM-DATE-BILL-DAY-90                   
                                PARM-USER-ID                            
                                PARM-COMMENT-TEXT                       
                                PARM-PROCESSING-FL                      
                                PARM-AT-LAST-UPDATE-TS                  
                                PARM-CODES-DATA-PRESENT                 
                                PARM-ACCT-CREATE-DT                     
                                PARM-ACCT-FINALED-DT.                   
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE               AS RETURN_CODE       
                     ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CD    
                     ,LTRIM(RTRIM(:S-AR-LOCKOUT-IND))     AS 
           AR_LOCKOUT_IND    
                     ,LTRIM(RTRIM(:S-BUS-RULE-ID))        AS BUS_RULE_ID       
                     ,LTRIM(RTRIM(:S-BUS-RULE-RESULT-CD)) AS 
           BUS_RULE_RESULT_CD
                     ,LTRIM(RTRIM(:S-BUS-RULE-XREF-ID))   AS 
           BUS_RULE_XREF_ID  
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE               AS RETURN_CODE               
MFA-TR*              ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CD            
MFA-TR*              ,STRIP(:S-AR-LOCKOUT-IND)     AS AR_LOCKOUT_IND            
MFA-TR*              ,STRIP(:S-BUS-RULE-ID)        AS BUS_RULE_ID               
MFA-TR*              ,STRIP(:S-BUS-RULE-RESULT-CD) AS BUS_RULE_RESULT_CD        
MFA-TR*              ,STRIP(:S-BUS-RULE-XREF-ID)   AS BUS_RULE_XREF_ID          
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           INITIALIZE WS-MISC.                                          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      ******************************************************************05190000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2010-CHECK-LOCK-OUT        THRU 2010-EXIT            
           PERFORM 2020-CHECK-LAST-UPDATE-TS  THRU 2020-EXIT            
           PERFORM 2030-VALIDATE-ACCT-FROM-TO THRU 2030-EXIT            
           PERFORM 5000-UPDATE                THRU 5000-EXIT            
           ADD +1                             TO   CTR-ROWS.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-CHECK-LOCK-OUT                                            *        
      ******************************************************************        
       2010-CHECK-LOCK-OUT.                                             
                                                                        
           PERFORM 7999-SELECT-AL              THRU 7999-SELECT-AL-EXIT.
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE ZEROS                    TO S-RETURN-CODE            
              MOVE ZEROS                    TO S-APPL-RETURN-CODE       
              MOVE AL-AR-LOCKOUT-IND        TO S-AR-LOCKOUT-IND         
              MOVE 'AM00000005'             TO S-BUS-RULE-ID            
              MOVE 'F'                      TO S-BUS-RULE-RESULT-CD     
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                        TO CTR-ROWS                 
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05270000
      ******************************************************************        
      * 2020-CHECK-LAST-UPDATE-TS                                      *        
      ******************************************************************        
       2020-CHECK-LAST-UPDATE-TS.                                       
                                                                        
           INITIALIZE SCSCA182-LINK-RECORD.                             
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO-C        
                                                 SCSCA182-ACCOUNT-NO.   
                                                                        
           PERFORM 9200-LINK-SCSCA182            THRU 9200-EXIT.        
           IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                      
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE SCSCA182-RETURN-CODE      TO SQLCODE                
                                                 WS-ACTIVE-RETURN-CODE  
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           ELSE                                                         
               MOVE SCSCA182-LAST-UPDATE-TS   TO WS-LAST-UPDATE-TS      
               IF  PARM-AT-LAST-UPDATE-TS     =  WS-LAST-UPDATE-TS      
                   CONTINUE                                             
               ELSE                                                     
                   MOVE ZEROS                 TO S-RETURN-CODE          
                   MOVE ZEROS                 TO S-APPL-RETURN-CODE     
                   MOVE SPACES                TO S-AR-LOCKOUT-IND       
                   MOVE 'AM00000006'          TO S-BUS-RULE-ID          
                   MOVE 'F'                   TO S-BUS-RULE-RESULT-CD   
                   IF S-BUS-RULE-ID > SPACES                            
                      PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT      
                   END-IF                                               
                   ADD +1                     TO   CTR-ROWS             
                   PERFORM 9999-END-PROGRAM      THRU 9999-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 05270000
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05270000
      ******************************************************************        
      * 2030-VALIDATE-ACCT-FROM-TO                                     *        
      ******************************************************************        
       2030-VALIDATE-ACCT-FROM-TO.                                      
                                                                        
           MOVE PARM-ACCT-XFER-TO             TO WS-ACCT-XFER-TO-C      
           MOVE WS-ACCT-XFER-TO               TO WS-CHK-ACC-NO          
           IF WS-CHK-ACC-NO > ZERO                                      
              PERFORM 7030-CHECK-ACCOUNT-NO      THRU 7030-EXIT         
              IF ROW-EXIST = 'Y'                                        
                 CONTINUE                                               
              ELSE                                                      
                 MOVE ZEROS                   TO S-RETURN-CODE          
                 MOVE ZEROS                   TO S-APPL-RETURN-CODE     
                 MOVE SPACES                  TO S-AR-LOCKOUT-IND       
                 MOVE 'AM00000007'            TO S-BUS-RULE-ID          
                 MOVE 'F'                     TO S-BUS-RULE-RESULT-CD   
                 IF S-BUS-RULE-ID > SPACES                              
                    PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT        
                 END-IF                                                 
                 ADD +1                       TO   CTR-ROWS             
                 PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCT-XFER-FROM-LST       TO WS-ACCT-XFER-FROM-LST-C
           MOVE WS-ACCT-XFER-FROM-LST         TO WS-CHK-ACC-NO          
           IF WS-CHK-ACC-NO > ZERO                                      
              PERFORM 7030-CHECK-ACCOUNT-NO      THRU 7030-EXIT         
              IF ROW-EXIST = 'Y'                                        
                 CONTINUE                                               
              ELSE                                                      
                 MOVE ZEROS                   TO S-RETURN-CODE          
                 MOVE ZEROS                   TO S-APPL-RETURN-CODE     
                 MOVE SPACES                  TO S-AR-LOCKOUT-IND       
                 MOVE 'AM00000001'            TO S-BUS-RULE-ID          
                 MOVE 'F'                     TO S-BUS-RULE-RESULT-CD   
                 IF S-BUS-RULE-ID > SPACES                              
                    PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT        
                 END-IF                                                 
                 ADD +1                       TO   CTR-ROWS             
                 PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                                  
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7020'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_XREF_ID'    TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-XREF-ID    TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-CHECK-ACCOUNT-NO                                          *        
      ******************************************************************        
       7030-CHECK-ACCOUNT-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :ROW-EXIST                                         
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :WS-CHK-ACC-NO                        
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :ROW-EXIST                                                 
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-CHK-ACC-NO                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                    TO ABEND-TABLES           
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
               MOVE '7030'                    TO ACTIVE-PARAGRAPH       
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-CHK-ACC-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
       5000-UPDATE.                                                     
                                                                        
           MOVE WS-ACCOUNT-NO                  TO AT-ACCOUNT-NO.        
           PERFORM 7999-SELECT-TRANSFER-IND                             
                                THRU 7999-SELECT-TRANSFER-IND-EXIT.     
                                                                        
           MOVE PARM-DATE-BILL-DAY-00       TO WS-DATE-BILL-DAY-00.     
           MOVE PARM-DATE-BILL-DAY-30       TO WS-DATE-BILL-DAY-30.     
           MOVE PARM-DATE-BILL-DAY-60       TO WS-DATE-BILL-DAY-60.     
           MOVE PARM-DATE-BILL-DAY-90       TO WS-DATE-BILL-DAY-90.     
           MOVE PARM-CODE-ACCT-STAT         TO WS-CODE-ACCT-STAT.       
           MOVE PARM-ACCT-XFER-TO           TO WS-ACCT-XFER-TO-C        
           MOVE WS-ACCT-XFER-TO             TO AT-ACCT-XFER-TO.         
           MOVE PARM-ACCT-XFER-FROM-LST     TO WS-ACCT-XFER-FROM-LST-C. 
           MOVE WS-ACCT-XFER-FROM-LST       TO AT-ACCT-XFER-FROM-LST.   
           MOVE PARM-TOTAL-AR-BALANCE       TO WS-TOTAL-AR-BALANCE.     
           MOVE PARM-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.   
           MOVE PARM-USER-ID                TO PF-USER-ID.              
           MOVE PARM-ACCT-CREATE-DT         TO WS-ACCT-CREATE-DT.       
           MOVE PARM-ACCT-FINALED-DT        TO WS-ACCT-FINALED-DT.      
           MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO.           
           PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT.             
                                                                        
           IF WS-NULL-IND-1 < 0                                         
               MOVE SPACES                  TO AT-DATE-BILL-DAY-00      
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-2 < 0                                         
               MOVE SPACES                  TO AT-DATE-BILL-DAY-30      
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-3 < 0                                         
               MOVE SPACES                  TO AT-DATE-BILL-DAY-60      
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-4 < 0                                         
               MOVE SPACES                  TO AT-DATE-BILL-DAY-90      
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-5 < 0                                         
               MOVE SPACES                  TO AT-ACCT-CREATE-DT        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-6 < 0                                         
               MOVE SPACES                  TO AT-ACCT-FINALED-DT       
           END-IF                                                       
                                                                        
           PERFORM 7300-GET-RESP-ARE-ID        THRU 7300-EXIT.          
           PERFORM 5100-GET-CURR-TIMESTAMP     THRU 5100-EXIT.          
           PERFORM 5200-MOVE-TRAN-DET          THRU 5200-EXIT.          
           PERFORM 5300-MOVE-ACC-DTL           THRU 5300-EXIT.          
           PERFORM 8200-UPDATE-ACCOUNT         THRU 8200-EXIT.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06630000
      ******************************************************************        
      * 5100-GET-CURR-TIMESTAMP                                       *         
      ******************************************************************        
       5100-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*           ,:MH-DATE-TRANS        = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                    TO ABEND-TABLES           
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
               MOVE '5100'                    TO ACTIVE-PARAGRAPH       
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF      *           
      * SO THEN WRITE A RECORD IN THE TRANSACTION DETAIL.           *           
      ***************************************************************           
       5200-MOVE-TRAN-DET.                                              
                                                                        
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE AT-CUSTOMER-NO              TO MH-CUSTOMER-NO.          
           MOVE AT-PREMISE-NO               TO MH-PREMISE-NO.           
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE 'CSR04572'                  TO MH-APPL-PROGRAM-ID.      
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
           MOVE PARM-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.    
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE 1                           TO WS-TRAN-APPL-NO          
                                               MI-TRAN-APPL-NO.         
           MOVE '48'                        TO MI-TABLE-ID.             
                                                                        
           IF PARM-AR-XFER-IND NOT = AT-AR-XFER-IND                     
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-AR-XFER-IND         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-AR-XFER-IND           TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'AR XFER IND    '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           IF WS-ACCT-XFER-TO NOT = AT-ACCT-XFER-TO                     
              MOVE +13                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-ACCT-XFER-TO        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-ACCT-XFER-TO          TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ACCT XFER TO   '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-ACCT-XFER-FROM-LST NOT = AT-ACCT-XFER-FROM-LST         
              MOVE +13                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-ACCT-XFER-FROM-LST  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-ACCT-XFER-FROM-LST    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ACCT XFER FROM '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-CODE-ACCT-STAT NOT EQUAL AT-CODE-ACCT-STAT             
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CODE-ACCT-STAT        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-CODE-ACCT-STAT        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CODE-ACCT-STAT        TO AT-CODE-ACCT-STAT        
              MOVE 'CODE ACCT STAT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-TOTAL-AR-BALANCE NOT EQUAL AT-TOTAL-AR-BALANCE         
              MOVE +15                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-TOTAL-AR-BALANCE      TO WS-COMP-2-CHAR-CONV      
              MOVE WS-COMP-2-CHAR-CONV      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-TOTAL-AR-BALANCE      TO WS-COMP-2-CHAR-CONV      
              MOVE WS-COMP-2-CHAR-CONV      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'TOTAL AR BAL   '        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF WS-DATE-BILL-DAY-00 NOT EQUAL AT-DATE-BILL-DAY-00         
              AND PARM-DATE-BILL-DAY-00 > SPACES                        
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-BILL-DAY-00      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-DATE-BILL-DAY-00      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-DATE-BILL-DAY-00      TO AT-DATE-BILL-DAY-00      
              MOVE 'DATE BILL DAY00'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF WS-DATE-BILL-DAY-30 NOT EQUAL AT-DATE-BILL-DAY-30         
              AND PARM-DATE-BILL-DAY-30 > SPACES                        
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-BILL-DAY-30      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-DATE-BILL-DAY-30      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-DATE-BILL-DAY-30      TO AT-DATE-BILL-DAY-30      
              MOVE 'DATE BILL DAY30'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF WS-DATE-BILL-DAY-60 NOT EQUAL AT-DATE-BILL-DAY-60         
              AND PARM-DATE-BILL-DAY-60 > SPACES                        
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-BILL-DAY-60 TO MI-CHG-COLUMN-VALUE-TEXT      
              MOVE AT-DATE-BILL-DAY-60      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-DATE-BILL-DAY-60      TO AT-DATE-BILL-DAY-60      
              MOVE 'DATE BILL DAY60'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF WS-DATE-BILL-DAY-90 NOT EQUAL AT-DATE-BILL-DAY-90         
              AND  PARM-DATE-BILL-DAY-90 > SPACES                       
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-DATE-BILL-DAY-90      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-DATE-BILL-DAY-90      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-DATE-BILL-DAY-90      TO AT-DATE-BILL-DAY-90      
              MOVE 'DATE BILL DAY90'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF WS-CODES-DATA-PRESENT NOT EQUAL AT-CODES-DATA-PRESENT     
              AND  PARM-CODES-DATA-PRESENT > SPACES                     
              MOVE +32                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CODES-DATA-PRESENT    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-CODES-DATA-PRESENT    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
              MOVE 'CODES DATA PRESENT'     TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-ACCT-CREATE-DT  NOT EQUAL AT-ACCT-CREATE-DT            
              MOVE +26                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-ACCT-CREATE-DT        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-ACCT-CREATE-DT        TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ACCT CREATE DATE'       TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           IF WS-ACCT-FINALED-DT NOT EQUAL AT-ACCT-FINALED-DT           
              MOVE +26                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-ACCT-FINALED-DT       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE AT-ACCT-FINALED-DT       TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ACCT FINALED DT'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-MOVE-ACC-DTL                                              *        
      ******************************************************************        
       5300-MOVE-ACC-DTL.                                               
                                                                        
           INITIALIZE                  WS-NULL-INDICATORS.              
                                                                        
           MOVE WS-CODES-DATA-PRESENT       TO AT-CODES-DATA-PRESENT.   
           MOVE WS-TOTAL-AR-BALANCE         TO AT-TOTAL-AR-BALANCE.     
           MOVE WS-ACCT-XFER-TO             TO AT-ACCT-XFER-TO.         
           MOVE WS-ACCT-XFER-FROM-LST       TO AT-ACCT-XFER-FROM-LST.   
           MOVE WS-ACCT-CREATE-DT           TO AT-ACCT-CREATE-DT.       
           MOVE WS-ACCT-FINALED-DT          TO AT-ACCT-FINALED-DT.      
           MOVE PARM-AR-XFER-IND            TO AT-AR-XFER-IND.          
           MOVE WS-CODE-ACCT-STAT           TO AT-CODE-ACCT-STAT.       
           IF AT-DATE-BILL-DAY-00 = SPACES                              
               MOVE -1                      TO WS-NULL-IND-1            
           END-IF.                                                      
      *                                                                         
           IF AT-DATE-BILL-DAY-30 = SPACES                              
               MOVE -1                      TO WS-NULL-IND-2            
           END-IF.                                                      
      *                                                                         
           IF AT-DATE-BILL-DAY-60 = SPACES                              
               MOVE -1                      TO WS-NULL-IND-3            
           END-IF.                                                      
      *                                                                         
           IF AT-DATE-BILL-DAY-90 = SPACES                              
               MOVE -1                      TO WS-NULL-IND-4            
           END-IF.                                                      
      *                                                                         
           IF AT-ACCT-CREATE-DT   = SPACES                              
               MOVE -1                      TO WS-NULL-IND-5            
           END-IF.                                                      
      *                                                                         
           IF AT-ACCT-FINALED-DT = SPACES                               
               MOVE -1                      TO WS-NULL-IND-6            
           END-IF.                                                      
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07090000
      ******************************************************************        
      *   6530-LOAD-MNT-TRANS-HIST                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      * 7000-SELECT-ACCOUNT                                         *           
      *                                                             *           
      ***************************************************************           
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT PREMISE_NO                                          
                  ,CUSTOMER_NO                                          
                  ,DATE_BILL_DAY_00                                     
                  ,DATE_BILL_DAY_30                                     
                  ,DATE_BILL_DAY_60                                     
                  ,DATE_BILL_DAY_90                                     
                  ,TOTAL_AR_BALANCE                                     
                  ,AR_XFER_IND                                          
                  ,ACCT_XFER_TO                                         
                  ,ACCT_XFER_FROM_LST                                   
                  ,CODE_ACCT_STAT                                       
                  ,CODES_DATA_PRESENT                                   
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
               INTO :AT-PREMISE-NO                                      
                  ,:AT-CUSTOMER-NO                                      
                  ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-1                          
                  ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-2                          
                  ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-3                          
                  ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-4                          
                  ,:AT-TOTAL-AR-BALANCE                                 
                  ,:AT-AR-XFER-IND                                      
                  ,:AT-ACCT-XFER-TO                                     
                  ,:AT-ACCT-XFER-FROM-LST                               
                  ,:AT-CODE-ACCT-STAT                                   
                  ,:AT-CODES-DATA-PRESENT                               
                  ,:AT-ACCT-CREATE-DT :WS-NULL-IND-5                            
                  ,:AT-ACCT-FINALED-DT :WS-NULL-IND-6                           
               FROM CSS_ACCOUNT                                         
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10700000
MFA-TR*      SELECT PREMISE_NO                                          14490002
MFA-TR*           ,CUSTOMER_NO                                          14490002
MFA-TR*           ,DATE_BILL_DAY_00                                     14490002
MFA-TR*           ,DATE_BILL_DAY_30                                             
MFA-TR*           ,DATE_BILL_DAY_60                                             
MFA-TR*           ,DATE_BILL_DAY_90                                             
MFA-TR*           ,TOTAL_AR_BALANCE                                             
MFA-TR*           ,AR_XFER_IND                                          14500002
MFA-TR*           ,ACCT_XFER_TO                                                 
MFA-TR*           ,ACCT_XFER_FROM_LST                                           
MFA-TR*           ,CODE_ACCT_STAT                                               
MFA-TR*           ,CODES_DATA_PRESENT                                           
MFA-TR*           ,ACCT_CREATE_DT                                               
MFA-TR*           ,ACCT_FINALED_DT                                              
MFA-TR*        INTO :AT-PREMISE-NO                                      14510002
MFA-TR*           ,:AT-CUSTOMER-NO                                      14510002
MFA-TR*           ,:AT-DATE-BILL-DAY-00                                 14510002
MFA-TR*            :WS-NULL-IND-1                                               
MFA-TR*           ,:AT-DATE-BILL-DAY-30                                         
MFA-TR*            :WS-NULL-IND-2                                               
MFA-TR*           ,:AT-DATE-BILL-DAY-60                                         
MFA-TR*            :WS-NULL-IND-3                                               
MFA-TR*           ,:AT-DATE-BILL-DAY-90                                         
MFA-TR*            :WS-NULL-IND-4                                               
MFA-TR*           ,:AT-TOTAL-AR-BALANCE                                         
MFA-TR*           ,:AT-AR-XFER-IND                                              
MFA-TR*           ,:AT-ACCT-XFER-TO                                             
MFA-TR*           ,:AT-ACCT-XFER-FROM-LST                                       
MFA-TR*           ,:AT-CODE-ACCT-STAT                                           
MFA-TR*           ,:AT-CODES-DATA-PRESENT                                       
MFA-TR*           ,:AT-ACCT-CREATE-DT                                           
MFA-TR*            :WS-NULL-IND-5                                               
MFA-TR*           ,:AT-ACCT-FINALED-DT                                          
MFA-TR*            :WS-NULL-IND-6                                               
MFA-TR*        FROM CSS_ACCOUNT                                         14530002
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14540002
MFA-TR*    END-EXEC.                                                    10340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_ACCOUNT'      TO TABLE-1                       
               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
               MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 10370000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7300-GET-RESP-ARE-ID.                                        *          
      ****************************************************************          
       7300-GET-RESP-ARE-ID.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                  INTO :PF-RESP-AREA-ID                                 
                  FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                
                 WHERE USER_ID    = :PF-USER-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*           INTO :PF-RESP-AREA-ID                                         
MFA-TR*           FROM CSS_USER_PROFILE PF                                      
MFA-TR*          WHERE USER_ID    = :PF-USER-ID                                 
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE PF-USER-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      * 7999-SELECT-AL AR LOCKOUT AND TRANSFER ROUTINE               *  16265003
      ****************************************************************  16267003
                                                                        
              EXEC SQL                                                  16269003
                 INCLUDE CPD00075                                       16270003
              END-EXEC.                                                 16280003
                                                                        
              EXEC SQL                                                  16269003
                 INCLUDE CPD00307                                       16270003
              END-EXEC.                                                 16280003
      *                                                                 11670000
      ***************************************************************           
      * UPDATE ACCOUNT TABLE                                        *           
      ***************************************************************           
       8200-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET DATE_BILL_DAY_00  = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-00 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00 :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00 
                                                         :WS-NULL-IND-1
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00 :WS-NULL-IND-1) )          
                    ,DATE_BILL_DAY_30   = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-30 
                                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30 :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30 :WS-NULL-IND-2) )          
                    ,DATE_BILL_DAY_60   = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-60 
                                                         :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60 :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60 
                                                         :WS-NULL-IND-3
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60 :WS-NULL-IND-3) )          
                    ,DATE_BILL_DAY_90   = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-90 
                                                         :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90 :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90 :WS-NULL-IND-4) )          
                    ,CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT            
                    ,TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE          
                    ,AR_XFER_IND        = :AT-AR-XFER-IND               
                    ,ACCT_XFER_TO       = :AT-ACCT-XFER-TO              
                    ,ACCT_XFER_FROM_LST = :AT-ACCT-XFER-FROM-LST        
                    ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
                    ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,ACCT_CREATE_DT     = CIS.CHAR2TIMESTAMP(
                                                    :AT-ACCT-CREATE-DT 
                                                         :WS-NULL-IND-5
              )                
                    ,ACCT_FINALED_DT    = CIS.CHAR2TIMESTAMP(
                                                   :AT-ACCT-FINALED-DT 
                                                         :WS-NULL-IND-6
              )                
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16000003
MFA-TR*        UPDATE CSS_ACCOUNT                                       16010003
MFA-TR*           SET DATE_BILL_DAY_00  = :AT-DATE-BILL-DAY-00          16011003
MFA-TR*                                   :WS-NULL-IND-1                        
MFA-TR*             ,DATE_BILL_DAY_30   = :AT-DATE-BILL-DAY-30                  
MFA-TR*                                   :WS-NULL-IND-2                        
MFA-TR*             ,DATE_BILL_DAY_60   = :AT-DATE-BILL-DAY-60                  
MFA-TR*                                   :WS-NULL-IND-3                        
MFA-TR*             ,DATE_BILL_DAY_90   = :AT-DATE-BILL-DAY-90                  
MFA-TR*                                   :WS-NULL-IND-4                        
MFA-TR*             ,CODE_ACCT_STAT     = :AT-CODE-ACCT-STAT                    
MFA-TR*             ,TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE                  
MFA-TR*             ,AR_XFER_IND        = :AT-AR-XFER-IND                       
MFA-TR*             ,ACCT_XFER_TO       = :AT-ACCT-XFER-TO                      
MFA-TR*             ,ACCT_XFER_FROM_LST = :AT-ACCT-XFER-FROM-LST                
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*             ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                
MFA-TR*             ,ACCT_CREATE_DT     = :AT-ACCT-CREATE-DT                    
MFA-TR*                                   :WS-NULL-IND-5                        
MFA-TR*             ,ACCT_FINALED_DT    = :AT-ACCT-FINALED-DT                   
MFA-TR*                                   :WS-NULL-IND-6                        
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                16015003
MFA-TR*    END-EXEC.                                                    16018003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                     TO   ABEND-TABLES        
               MOVE SPACES                     TO   ABEND-SQL-PREDICATES
               MOVE '8200'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO   ABEND-PROGRAM       
               MOVE 'UPDATE'                   TO   ABEND-FUNCTION      
               MOVE 'CSS_ACCOUNT'              TO   TABLE-1             
               MOVE 'ACCOUNT_NO'               TO   TABLE-ELEMENT-1     
               MOVE 'CODE_ACCT_STAT'           TO   TABLE-ELEMENT-2     
               MOVE 'DATE_BILL_DAY_00'         TO   TABLE-ELEMENT-3     
               MOVE 'DATE_BILL_DAY_30'         TO   TABLE-ELEMENT-4     
               MOVE AT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1   
               MOVE AT-CODE-ACCT-STAT          TO   HOSTVAR-ELEMENT-2   
               MOVE AT-DATE-BILL-DAY-00        TO   HOSTVAR-ELEMENT-3   
               MOVE AT-DATE-BILL-DAY-30        TO   HOSTVAR-ELEMENT-4   
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  CALLS THE SUBPROGRAM SCSCA182                                *         
      *****************************************************************         
       9200-LINK-SCSCA182.                                              
                                                                        
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                 SCSCA182-RETURN-CODE                   
                                 SCSCA182-LAST-UPDATE-TS                
                                 ABEND-FILE.                            
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16265003
      ****************************************************************  16267003
           EXEC SQL                                                             
             INCLUDE CPDSP300                                                   
           END-EXEC.                                                            
                                                                        
      ****************************************************************  16310003
      *       END PROGRAM COPYLIB                                       16330003
      ****************************************************************  16360003
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
