       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04570.                                      
COB303 DATE-WRITTEN.     SEPTEMBER 11,2012.                             
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04570              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04570 :                                                --         
      *--                                                            --         
      *--     RETRIEVE ACTIVE RATE PLAN AND RATE VERSION DETAILS.    --         
      *--                                                            --         
      *--       CSS_RATE_PLAN_DESC                                   --         
      *--       CSS_RATE_CREATOR                                     --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--            NONE                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04570_R1 - ACTIVE RATE DETAILS                  --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           CODE_UTIL_TYPE          CHAR(1)                  --         
      *--           RATE_PLAN_NO            CHAR(3)                  --         
      *--           COMPANY_NO              CHAR(2)                  --         
      *--           VERS_PRORATE_CD         CHAR(1)                  --         
      *--           SECURED_RATE_FL         CHAR(1)                  --         
      *--           RATE_DESC               CHAR(50)                 --         
      *--           SUM_REVENUE_FL          CHAR(1)                  --         
      *--           EXT_BILLING_FL          CHAR(1)                  --         
      *--           UNMTR_PROV_FL           CHAR(1)                  --         
      *--           REG_GROUP_CD            CHAR(3)                  --         
      *--           BILL_LITERAL_TX         VC(50)                   --         
      *--           MKT_PROGRAM_CD          CHAR(2)                  --         
      *--           RATE_CALC_TYPE_CD       CHAR(2)                  --         
      *--           SENIOR_RATE_FL          CHAR(1)                  --         
      *--           DISPLAY_START_TS        TIMESTMP                 --         
      *--           DISPLAY_END_TS          TIMESTMP                 --         
      *--           DEFERRED_COG_FL         CHAR(1)                  --         
      *--           RATE_DEFINITION_CD      CHAR(1)                  --         
      *--           RATE_DEPT_CD            CHAR(3)                  --         
      *--           REV_CUST_COUNT_CD       CHAR(1)                  --         
      *--           CODE_SERVICE_TYPE       CHAR(1)                  --         
      *--           VERSION_NO_CNTRL        SMALLINT                 --         
      *--           CODE_STATUS             CHAR(1)                  --         
      *--           DATE_CREATED            DATE                     --         
      *--           FROM_EFFECTIVE_DT       DATE                     --         
      *--           BILL_FORMAT_CD          CHAR(2)                  --         
      *--           SEASONAL_DEP_IND        CHAR(1)                  --         
      *--           BASE_LOAD_THERMS        DECIMAL(9,5)             --         
      *--           HEAT_SENSITIVE_FAC      DECIMAL(5,5)             --         
      *--           SEASNAL_BLK_CHG_CD      CHAR(1)                  --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
P00738*--           REG_TYPE_CD             CHAR(1)                  --         
P00738*--           DEM_REG_TYPE_CD         CHAR(1)                  --         
P00738*--           DEM_UNIT_CD             CHAR(1)                  --         
P00738*--           LFTM_PEAK_PCT           DECIMAL(5,2)             --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00480*--  08/25/2012    MS93554     RETRIEVE RATE INFORMATION.      --         
P00738*--  08/28/2013    MS93554     SELECT THE DEMAND AND ENERGY    --         
      *--                            TIME-OF-USE CODES & PEAD IND.   --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04570'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04570 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04570'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-ACTIVE                    PIC X(01)  VALUE 'A'.       
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
P00738     05  WS-ENABLE-PEAK-IND           PIC X(01) VALUE SPACES.     
P00738     05  WS-CMPNT-ID-CD               PIC X(02)      VALUE '10'.  
P00738     05  WS-IDR-TYPE                  PIC X(01) VALUE 'I'.        
P00738     05  WS-YES                       PIC X(01) VALUE 'Y'.        
P00738     05  WS-NO                        PIC X(01) VALUE 'N'.        
P00738     05  WS-ZERO                      PIC S9(4) VALUE 0.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CSS_RATE_PLAN_DESC             *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-CODE-UTIL-TYPE        PIC X(1).                   
             10 S-RS1-RATE-PLAN-NO          PIC X(3).                   
             10 S-RS1-COMPANY-NO            PIC X(2).                   
             10 S-RS1-VERS-PRORATE-CD       PIC X(1).                   
             10 S-RS1-SECURED-RATE-FL       PIC X(1).                   
             10 S-RS1-RATE-DESC             PIC X(50).                  
             10 S-RS1-SUM-REVENUE-FL        PIC X(1).                   
             10 S-RS1-EXT-BILLING-FL        PIC X(1).                   
             10 S-RS1-UNMTR-PROV-FL         PIC X(1).                   
             10 S-RS1-REG-GROUP-CD          PIC X(3).                   
             10 S-RS1-BILL-LITERAL-TX.                                  
                49 S-RS1-BILL-LITERAL-TX-LEN  PIC S9(4) USAGE COMP.     
                49 S-RS1-BILL-LITERAL-TX-TEXT PIC X(50).                
             10 S-RS1-MKT-PROGRAM-CD        PIC X(2).                   
             10 S-RS1-RATE-CALC-TYPE-CD     PIC X(2).                   
             10 S-RS1-SENIOR-RATE-FL        PIC X(1).                   
             10 S-RS1-DISPLAY-START-TS      PIC X(26).                  
             10 S-RS1-DISPLAY-END-TS        PIC X(26).                  
             10 S-RS1-DEFERRED-COG-FL       PIC X(1).                   
             10 S-RS1-RATE-DEFINITION-CD    PIC X(1).                   
             10 S-RS1-RATE-DEPT-CD          PIC X(3).                   
             10 S-RS1-REV-CUST-COUNT        PIC X(1).                   
             10 S-RS1-CODE-SERVICE-TYPE     PIC X(1).                   
             10 S-RS1-VERSION-NO-CNTRL      PIC S9(4) USAGE COMP.       
             10 S-RS1-CODE-STATUS           PIC X(1).                   
             10 S-RS1-DATE-CREATED          PIC X(10).                  
             10 S-RS1-FROM-EFFECTIVE-DT     PIC X(10).                  
             10 S-RS1-BILL-FORMAT-CD        PIC X(2).                   
             10 S-RS1-SEASONAL-DEP-IND      PIC X(1).                   
COB305       10 S-RS1-BASE-LOAD-THERMS        PIC S9(4)V9(5) 
COB305          USAGE COMP-3 VALUE 0.
COB305       10 S-RS1-HEAT-SENSITIVE-FAC        PIC SV9(5) USAGE COMP-3 
COB305          VALUE 0.    
             10 S-RS1-SEASNAL-BLK-CHG-CD    PIC X(1).                   
COB305       10 S-RS1-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
P00738       10 S-RS1-REG-TYPE-CD           PIC X(1).                   
P00738       10 S-RS1-DEM-REG-TYPE-CD       PIC X(1).                   
P00738       10 S-RS1-DEM-UNIT-CD           PIC X(1).                   
COB305       10 S-RS1-LFTM-PEAK-PCT        PIC S9(3)V9(2) USAGE COMP-3 
COB305          VALUE 0.
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC  (RD)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_CREATOR   (RT)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
P00738******************************************************************        
P00738*    CSS_DEMAND_INSTR   (DI)                                     *        
P00738******************************************************************        
P00738*                                                                         
P00738     EXEC SQL                                                             
P00738        INCLUDE TBDMDINS                                                  
P00738     END-EXEC.                                                            
P00738*                                                                         
P00738******************************************************************        
P00738*    CSS_RATE_COMP_DEF  (J1)                                     *        
P00738******************************************************************        
P00738*                                                                         
P00738     EXEC SQL                                                             
P00738        INCLUDE TBRTCDEF                                                  
P00738     END-EXEC.                                                            
P00738*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH ACTIVE RATE AND RATE VERSION     *        
      *   INFORMATION.                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE ACTV_RATE_VRSN_CUR CURSOR FOR                    
               SELECT RD.CODE_UTIL_TYPE                                 
                     ,RD.RATE_PLAN_NO                                   
                     ,RD.COMPANY_NO                                     
                     ,RD.VERS_PRORATE_CD                                
                     ,RD.SECURED_RATE_FL                                
                     ,RD.RATE_DESC                                      
                     ,RD.SUM_REVENUE_FL                                 
                     ,RD.EXT_BILLING_FL                                 
                     ,RD.UNMTR_PROV_FL                                  
                     ,RD.REG_GROUP_CD                                   
                     ,RD.BILL_LITERAL_TX                                
                     ,RD.MKT_PROGRAM_CD                                 
                     ,RD.RATE_CALC_TYPE_CD                              
                     ,RD.SENIOR_RATE_FL                                 
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RD.DISPLAY_START_TS, 121), ' ', '-'), ':', '.') 
           DISPLAY_START_TS                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RD.DISPLAY_END_TS, 121), ' ', '-'), ':', '.') DISPLAY_END_TS        
                     ,RD.DEFERRED_COG_FL                                
                     ,RD.RATE_DEFINITION_CD                             
                     ,RD.RATE_DEPT_CD                                   
                     ,RD.REV_CUST_COUNT_CD                              
                     ,RD.CODE_SERVICE_TYPE                              
                     ,RT.VERSION_NO_CNTRL                               
                     ,RT.CODE_STATUS                                    
                     ,RT.DATE_CREATED                                   
                     ,RT.FROM_EFFECTIVE_DT                              
                     ,RT.BILL_FORMAT_CD                                 
                     ,RT.SEASONAL_DEP_IND                               
                     ,RT.BASE_LOAD_THERMS                               
                     ,RT.HEAT_SENSITIVE_FAC                             
                     ,RT.SEASNAL_BLK_CHG_CD                             
                     ,RT.PROC_REQ_ID                                    
                 FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
                     ,CSS_RATE_CREATOR   RT WITH(READUNCOMMITTED)               
                WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE             
                  AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO               
                  AND RD.DISPLAY_START_TS  <= CIS.CURRENT$TIMESTAMP()         
                  AND RD.DISPLAY_END_TS    >= CIS.CURRENT$TIMESTAMP()         
                  AND RT.VERSION_NO_CNTRL =                             
                               (SELECT MAX(IRT.VERSION_NO_CNTRL)        
                                 FROM CSS_RATE_CREATOR IRT
                           WITH(READUNCOMMITTED)              
                                WHERE IRT.RATE_PLAN_NO = RT.RATE_PLAN_NO
                                  AND IRT.CODE_STATUS    = 'A'          
                                  AND IRT.CODE_UTIL_TYPE =              
                                                     RT.CODE_UTIL_TYPE) 
                ORDER BY RD.RATE_PLAN_NO                                
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACTV_RATE_VRSN_CUR CURSOR FOR                            
MFA-TR*        SELECT RD.CODE_UTIL_TYPE                                         
MFA-TR*              ,RD.RATE_PLAN_NO                                           
MFA-TR*              ,RD.COMPANY_NO                                             
MFA-TR*              ,RD.VERS_PRORATE_CD                                        
MFA-TR*              ,RD.SECURED_RATE_FL                                        
MFA-TR*              ,RD.RATE_DESC                                              
MFA-TR*              ,RD.SUM_REVENUE_FL                                         
MFA-TR*              ,RD.EXT_BILLING_FL                                         
MFA-TR*              ,RD.UNMTR_PROV_FL                                          
MFA-TR*              ,RD.REG_GROUP_CD                                           
MFA-TR*              ,RD.BILL_LITERAL_TX                                        
MFA-TR*              ,RD.MKT_PROGRAM_CD                                         
MFA-TR*              ,RD.RATE_CALC_TYPE_CD                                      
MFA-TR*              ,RD.SENIOR_RATE_FL                                         
MFA-TR*              ,RD.DISPLAY_START_TS                                       
MFA-TR*              ,RD.DISPLAY_END_TS                                         
MFA-TR*              ,RD.DEFERRED_COG_FL                                        
MFA-TR*              ,RD.RATE_DEFINITION_CD                                     
MFA-TR*              ,RD.RATE_DEPT_CD                                           
MFA-TR*              ,RD.REV_CUST_COUNT_CD                                      
MFA-TR*              ,RD.CODE_SERVICE_TYPE                                      
MFA-TR*              ,RT.VERSION_NO_CNTRL                                       
MFA-TR*              ,RT.CODE_STATUS                                            
MFA-TR*              ,RT.DATE_CREATED                                           
MFA-TR*              ,RT.FROM_EFFECTIVE_DT                                      
MFA-TR*              ,RT.BILL_FORMAT_CD                                         
MFA-TR*              ,RT.SEASONAL_DEP_IND                                       
MFA-TR*              ,RT.BASE_LOAD_THERMS                                       
MFA-TR*              ,RT.HEAT_SENSITIVE_FAC                                     
MFA-TR*              ,RT.SEASNAL_BLK_CHG_CD                                     
MFA-TR*              ,RT.PROC_REQ_ID                                            
MFA-TR*          FROM CSS_RATE_PLAN_DESC RD                                     
MFA-TR*              ,CSS_RATE_CREATOR   RT                                     
MFA-TR*         WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE                     
MFA-TR*           AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO                       
MFA-TR*           AND RD.DISPLAY_START_TS  <= CURRENT TIMESTAMP                 
MFA-TR*           AND RD.DISPLAY_END_TS    >= CURRENT TIMESTAMP                 
MFA-TR*           AND RT.VERSION_NO_CNTRL =                                     
MFA-TR*                        (SELECT MAX(IRT.VERSION_NO_CNTRL)                
MFA-TR*                          FROM CSS_RATE_CREATOR IRT                      
MFA-TR*                         WHERE IRT.RATE_PLAN_NO = RT.RATE_PLAN_NO        
MFA-TR*                           AND IRT.CODE_STATUS    = 'A'                  
MFA-TR*                           AND IRT.CODE_UTIL_TYPE =                      
MFA-TR*                                              RT.CODE_UTIL_TYPE)         
MFA-TR*         ORDER BY RD.RATE_PLAN_NO                                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-DECLARE-GTT         THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT - CSS_RATE_PLAN_DES & CSS_RATE_CREATOR       *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04570_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04570_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04570_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,VERS_PRORATE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SECURED_RATE_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SUM_REVENUE_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,EXT_BILLING_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,UNMTR_PROV_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REG_GROUP_CD CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,BILL_LITERAL_TX VARCHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,MKT_PROGRAM_CD CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_CALC_TYPE_CD CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SENIOR_RATE_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,DISPLAY_START_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISPLAY_END_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DEFERRED_COG_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_DEFINITION_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,RATE_DEPT_CD CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,REV_CUST_COUNT_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,CODE_SERVICE_TYPE CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,VERSION_NO_CNTRL        SMALLINT                    
                   ,CODE_STATUS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,DATE_CREATED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FROM_EFFECTIVE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BILL_FORMAT_CD CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,SEASONAL_DEP_IND CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,BASE_LOAD_THERMS        DECIMAL(9,5)                
                   ,HEAT_SENSITIVE_FAC      DECIMAL(5,5)                
                   ,SEASNAL_BLK_CHG_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PROC_REQ_ID             DECIMAL(10,0)               
P00738             ,REG_TYPE_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
P00738             ,DEM_REG_TYPE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
P00738             ,DEM_UNIT_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
P00738             ,LFTM_PEAK_PCT           DECIMAL(5,2)                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))        AS 
           CODE_UTIL_TYPE   
                      ,LTRIM(RTRIM(RATE_PLAN_NO))          AS 
           RATE_PLAN_NO     
                      ,LTRIM(RTRIM(COMPANY_NO))            AS COMPANY_NO       
                      ,LTRIM(RTRIM(VERS_PRORATE_CD))       AS 
           VERS_PRORATE_CD  
                      ,LTRIM(RTRIM(SECURED_RATE_FL))       AS 
           SECURED_RATE_FL  
                      ,LTRIM(RTRIM(RATE_DESC))             AS RATE_DESC        
                      ,LTRIM(RTRIM(SUM_REVENUE_FL))        AS 
           SUM_REVENUE_FL   
                      ,LTRIM(RTRIM(EXT_BILLING_FL))        AS 
           EXT_BILLING_FL   
                      ,LTRIM(RTRIM(UNMTR_PROV_FL))         AS 
           UNMTR_PROV_FL    
                      ,LTRIM(RTRIM(REG_GROUP_CD))          AS 
           REG_GROUP_CD     
                      ,LTRIM(RTRIM(BILL_LITERAL_TX))       AS 
           BILL_LITERAL_TX  
                      ,LTRIM(RTRIM(MKT_PROGRAM_CD))        AS 
           MKT_PROGRAM_CD   
                      ,LTRIM(RTRIM(RATE_CALC_TYPE_CD))     AS 
           RATE_CALC_TYPE_CD
                      ,LTRIM(RTRIM(SENIOR_RATE_FL))        AS 
           SENIOR_RATE_FL   
                      ,LTRIM(RTRIM(DISPLAY_START_TS))      AS 
           DISPLAY_START_TS 
                      ,LTRIM(RTRIM(DISPLAY_END_TS))        AS 
           DISPLAY_END_TS   
                      ,LTRIM(RTRIM(DEFERRED_COG_FL))       AS 
           DEFERRED_COG_FL  
                      ,LTRIM(RTRIM(RATE_DEFINITION_CD))   AS 
           RATE_DEFINITION_CD
                      ,LTRIM(RTRIM(RATE_DEPT_CD))         AS 
           RATE_DEPT_CD      
                      ,LTRIM(RTRIM(REV_CUST_COUNT_CD))    AS 
           REV_CUST_COUNT_CD 
                      ,LTRIM(RTRIM(CODE_SERVICE_TYPE))    AS 
           CODE_SERVICE_TYPE 
                      ,VERSION_NO_CNTRL            AS VERSION_NO_CNTRL  
                      ,LTRIM(RTRIM(CODE_STATUS))          AS CODE_STATUS       
                      ,LTRIM(RTRIM(DATE_CREATED))         AS 
           DATE_CREATED      
                      ,LTRIM(RTRIM(FROM_EFFECTIVE_DT))    AS 
           FROM_EFFECTIVE_DT 
                      ,LTRIM(RTRIM(BILL_FORMAT_CD))       AS 
           BILL_FORMAT_CD    
                      ,LTRIM(RTRIM(SEASONAL_DEP_IND))     AS 
           SEASONAL_DEP_IND  
                      ,BASE_LOAD_THERMS            AS BASE_LOAD_THERMS  
                      ,HEAT_SENSITIVE_FAC          AS HEAT_SENSITIVE_FAC
                      ,LTRIM(RTRIM(SEASNAL_BLK_CHG_CD))   AS 
           SEASNAL_BLK_CHG_CD
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
P00738                ,LTRIM(RTRIM(REG_TYPE_CD))          AS REG_TYPE_CD       
P00738                ,LTRIM(RTRIM(DEM_REG_TYPE_CD))      AS 
           DEM_REG_TYPE_CD   
P00738                ,LTRIM(RTRIM(DEM_UNIT_CD))          AS DEM_UNIT_CD       
P00738                ,LFTM_PEAK_PCT               AS LFTM_PEAK_PCT     
                  FROM #CSR04570_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)        AS CODE_UTIL_TYPE           
MFA-TR*               ,STRIP(RATE_PLAN_NO)          AS RATE_PLAN_NO             
MFA-TR*               ,STRIP(COMPANY_NO)            AS COMPANY_NO               
MFA-TR*               ,STRIP(VERS_PRORATE_CD)       AS VERS_PRORATE_CD          
MFA-TR*               ,STRIP(SECURED_RATE_FL)       AS SECURED_RATE_FL          
MFA-TR*               ,STRIP(RATE_DESC)             AS RATE_DESC                
MFA-TR*               ,STRIP(SUM_REVENUE_FL)        AS SUM_REVENUE_FL           
MFA-TR*               ,STRIP(EXT_BILLING_FL)        AS EXT_BILLING_FL           
MFA-TR*               ,STRIP(UNMTR_PROV_FL)         AS UNMTR_PROV_FL            
MFA-TR*               ,STRIP(REG_GROUP_CD)          AS REG_GROUP_CD             
MFA-TR*               ,STRIP(BILL_LITERAL_TX)       AS BILL_LITERAL_TX          
MFA-TR*               ,STRIP(MKT_PROGRAM_CD)        AS MKT_PROGRAM_CD           
MFA-TR*               ,STRIP(RATE_CALC_TYPE_CD)     AS RATE_CALC_TYPE_CD        
MFA-TR*               ,STRIP(SENIOR_RATE_FL)        AS SENIOR_RATE_FL           
MFA-TR*               ,STRIP(DISPLAY_START_TS)      AS DISPLAY_START_TS         
MFA-TR*               ,STRIP(DISPLAY_END_TS)        AS DISPLAY_END_TS           
MFA-TR*               ,STRIP(DEFERRED_COG_FL)       AS DEFERRED_COG_FL          
MFA-TR*               ,STRIP(RATE_DEFINITION_CD)   AS RATE_DEFINITION_CD        
MFA-TR*               ,STRIP(RATE_DEPT_CD)         AS RATE_DEPT_CD              
MFA-TR*               ,STRIP(REV_CUST_COUNT_CD)    AS REV_CUST_COUNT_CD         
MFA-TR*               ,STRIP(CODE_SERVICE_TYPE)    AS CODE_SERVICE_TYPE         
MFA-TR*               ,VERSION_NO_CNTRL            AS VERSION_NO_CNTRL          
MFA-TR*               ,STRIP(CODE_STATUS)          AS CODE_STATUS               
MFA-TR*               ,STRIP(DATE_CREATED)         AS DATE_CREATED              
MFA-TR*               ,STRIP(FROM_EFFECTIVE_DT)    AS FROM_EFFECTIVE_DT         
MFA-TR*               ,STRIP(BILL_FORMAT_CD)       AS BILL_FORMAT_CD            
MFA-TR*               ,STRIP(SEASONAL_DEP_IND)     AS SEASONAL_DEP_IND          
MFA-TR*               ,BASE_LOAD_THERMS            AS BASE_LOAD_THERMS          
MFA-TR*               ,HEAT_SENSITIVE_FAC          AS HEAT_SENSITIVE_FAC        
MFA-TR*               ,STRIP(SEASNAL_BLK_CHG_CD)   AS SEASNAL_BLK_CHG_CD        
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(REG_TYPE_CD)          AS REG_TYPE_CD               
MFA-TR*               ,STRIP(DEM_REG_TYPE_CD)      AS DEM_REG_TYPE_CD           
MFA-TR*               ,STRIP(DEM_UNIT_CD)          AS DEM_UNIT_CD               
MFA-TR*               ,LFTM_PEAK_PCT               AS LFTM_PEAK_PCT             
MFA-TR*           FROM SESSION.CSR04570_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-DECLARE-GTT.                                              *        
      ******************************************************************        
       1000-DECLARE-GTT.                                                
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-OPEN-ACTV-RATE-VRSN-CUR    THRU 7000-EXIT.      
           PERFORM 7100-FETCH-ACTV-RATE-VRSN-CUR   THRU 7100-EXIT.      
           PERFORM 2100-PROCESS-ACTV-RATE          THRU 2100-EXIT       
                                                  UNTIL NO-MORE-ROWS.   
           PERFORM 7200-CLOSE-ACTV-RATE-VRSN-CUR   THRU 7200-EXIT.      
                                                                        
           IF CTR-ROWS     EQUAL ZERO                                   
              MOVE 100                        TO S-RETURN-CODE-1        
              MOVE   0                        TO S-APPL-RETURN-CODE-1   
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-ACTV-RATE.                                        *        
      ******************************************************************        
       2100-PROCESS-ACTV-RATE.                                          
                                                                        
           MOVE RD-CODE-UTIL-TYPE       TO J1-CODE-UTIL-TYPE            
                                           DI-CODE-UTIL-TYPE.           
           MOVE RD-RATE-PLAN-NO         TO J1-RATE-PLAN-NO              
                                           DI-RATE-PLAN-NO.             
           MOVE RT-VERSION-NO-CNTRL     TO J1-VERSION-NO-CNTRL          
                                           DI-VERSION-NO-CNTRL.         
           MOVE WS-CMPNT-ID-CD          TO J1-CMPNT-ID-CD               
                                           DI-CMPNT-ID-CD.              
                                                                        
P00738*********************************************************                 
P00738* SELECT THE DEMAND AND ENERGY TIME-OF-USE CODES.       *                 
P00738* A NOT-FOUND CALL INDICATES THAT THE RATE IS IDR.      *                 
P00738*********************************************************                 
P00738     PERFORM 7300-SELECT-TOU-PERIODS  THRU 7300-EXIT.             
P00738     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00738        MOVE WS-IDR-TYPE           TO J1-REG-TYPE-CD              
P00738        MOVE WS-IDR-TYPE           TO J1-DEM-REG-TYPE-CD          
P00738        MOVE SPACES                TO J1-DEM-UNIT-CD              
P00738     END-IF.                                                      
P00738                                                                  
P00738*********************************************************                 
P00738* BASED ON THE RATE, DETERMINE IF LIFETIME PEAK DEMAND  *                 
P00738* DETAILS ARE PERTINENT.                                *                 
P00738*********************************************************                 
P00738     MOVE WS-ZERO                  TO DI-LFTM-PEAK-PCT.           
P00738     PERFORM 7400-SELECT-PEAK-IND     THRU 7400-EXIT.             
P00738                                                                  
P00738     PERFORM 6000-MOVE-RESULT-RS1          THRU 6000-EXIT.        
           PERFORM 7100-FETCH-ACTV-RATE-VRSN-CUR THRU 7100-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00738******************************************************************        
P00738*                                                                *        
P00738* 6000-MOVE-RESULT-RS1.                                          *        
P00738******************************************************************        
P00738 6000-MOVE-RESULT-RS1.                                            
                                                                        
           MOVE RD-CODE-UTIL-TYPE          TO S-RS1-CODE-UTIL-TYPE.     
           MOVE RD-RATE-PLAN-NO            TO S-RS1-RATE-PLAN-NO.       
           MOVE RD-COMPANY-NO              TO S-RS1-COMPANY-NO.         
           MOVE RD-VERS-PRORATE-CD         TO S-RS1-VERS-PRORATE-CD.    
           MOVE RD-SECURED-RATE-FL         TO S-RS1-SECURED-RATE-FL.    
           MOVE RD-RATE-DESC               TO S-RS1-RATE-DESC.          
           MOVE RD-SUM-REVENUE-FL          TO S-RS1-SUM-REVENUE-FL.     
           MOVE RD-EXT-BILLING-FL          TO S-RS1-EXT-BILLING-FL.     
           MOVE RD-UNMTR-PROV-FL           TO S-RS1-UNMTR-PROV-FL.      
           MOVE RD-REG-GROUP-CD            TO S-RS1-REG-GROUP-CD.       
           MOVE RD-BILL-LITERAL-TX         TO S-RS1-BILL-LITERAL-TX.    
           MOVE RD-MKT-PROGRAM-CD          TO S-RS1-MKT-PROGRAM-CD.     
           MOVE RD-RATE-CALC-TYPE-CD       TO S-RS1-RATE-CALC-TYPE-CD.  
           MOVE RD-SENIOR-RATE-FL          TO S-RS1-SENIOR-RATE-FL.     
           MOVE RD-DISPLAY-START-TS        TO S-RS1-DISPLAY-START-TS.   
           MOVE RD-DISPLAY-END-TS          TO S-RS1-DISPLAY-END-TS.     
           MOVE RD-DEFERRED-COG-FL         TO S-RS1-DEFERRED-COG-FL.    
           MOVE RD-RATE-DEFINITION-CD      TO S-RS1-RATE-DEFINITION-CD. 
           MOVE RD-RATE-DEPT-CD            TO S-RS1-RATE-DEPT-CD.       
           MOVE RD-REV-CUST-COUNT-CD       TO S-RS1-REV-CUST-COUNT.     
           MOVE RD-CODE-SERVICE-TYPE       TO S-RS1-CODE-SERVICE-TYPE.  
           MOVE RT-VERSION-NO-CNTRL        TO S-RS1-VERSION-NO-CNTRL.   
           MOVE RT-CODE-STATUS             TO S-RS1-CODE-STATUS.        
           MOVE RT-DATE-CREATED            TO S-RS1-DATE-CREATED.       
           MOVE RT-FROM-EFFECTIVE-DT       TO S-RS1-FROM-EFFECTIVE-DT.  
           MOVE RT-BILL-FORMAT-CD          TO S-RS1-BILL-FORMAT-CD.     
           MOVE RT-SEASONAL-DEP-IND        TO S-RS1-SEASONAL-DEP-IND.   
           MOVE RT-BASE-LOAD-THERMS        TO S-RS1-BASE-LOAD-THERMS.   
           MOVE RT-HEAT-SENSITIVE-FAC      TO S-RS1-HEAT-SENSITIVE-FAC. 
           MOVE RT-SEASNAL-BLK-CHG-CD      TO S-RS1-SEASNAL-BLK-CHG-CD. 
           MOVE RT-PROC-REQ-ID             TO S-RS1-PROC-REQ-ID.        
P00738     MOVE J1-REG-TYPE-CD             TO S-RS1-REG-TYPE-CD.        
P00738     MOVE J1-DEM-REG-TYPE-CD         TO S-RS1-DEM-REG-TYPE-CD.    
P00738     MOVE J1-DEM-UNIT-CD             TO S-RS1-DEM-UNIT-CD.        
P00738     MOVE DI-LFTM-PEAK-PCT           TO S-RS1-LFTM-PEAK-PCT.      
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
P00738 6000-EXIT.                                                       
P00738     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  7000-OPEN-ACTV-RATE-VRSN-CUR.                                 *        
      ******************************************************************        
       7000-OPEN-ACTV-RATE-VRSN-CUR.                                    
                                                                        
           EXEC SQL                                                     
                OPEN ACTV_RATE_VRSN_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-1                     
              MOVE 'CSS_RATE_CREATOR'    TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-ACTV-RATE-VRSN-CUR.                                 *        
      ******************************************************************        
       7100-FETCH-ACTV-RATE-VRSN-CUR.                                   
                                                                        
           EXEC SQL                                                     
               FETCH ACTV_RATE_VRSN_CUR                                 
                INTO :RD-CODE-UTIL-TYPE                                 
                    ,:RD-RATE-PLAN-NO                                   
                    ,:RD-COMPANY-NO                                     
                    ,:RD-VERS-PRORATE-CD                                
                    ,:RD-SECURED-RATE-FL                                
                    ,:RD-RATE-DESC                                      
                    ,:RD-SUM-REVENUE-FL                                 
                    ,:RD-EXT-BILLING-FL                                 
                    ,:RD-UNMTR-PROV-FL                                  
                    ,:RD-REG-GROUP-CD                                   
                    ,:RD-BILL-LITERAL-TX                                
                    ,:RD-MKT-PROGRAM-CD                                 
                    ,:RD-RATE-CALC-TYPE-CD                              
                    ,:RD-SENIOR-RATE-FL                                 
                    ,:RD-DISPLAY-START-TS                               
                    ,:RD-DISPLAY-END-TS                                 
                    ,:RD-DEFERRED-COG-FL                                
                    ,:RD-RATE-DEFINITION-CD                             
                    ,:RD-RATE-DEPT-CD                                   
                    ,:RD-REV-CUST-COUNT-CD                              
                    ,:RD-CODE-SERVICE-TYPE                              
                    ,:RT-VERSION-NO-CNTRL                               
                    ,:RT-CODE-STATUS                                    
                    ,:RT-DATE-CREATED                                   
                    ,:RT-FROM-EFFECTIVE-DT                              
                    ,:RT-BILL-FORMAT-CD                                 
                    ,:RT-SEASONAL-DEP-IND                               
                    ,:RT-BASE-LOAD-THERMS                               
                    ,:RT-HEAT-SENSITIVE-FAC                             
                    ,:RT-SEASNAL-BLK-CHG-CD                             
                    ,:RT-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7100'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                
                    MOVE 'CSS_RATE_CREATOR' TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-ACTV-RATE-VRSN-CUR.                                 *        
      ******************************************************************        
       7200-CLOSE-ACTV-RATE-VRSN-CUR.                                   
                                                                        
           EXEC SQL                                                     
                CLOSE ACTV_RATE_VRSN_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'CSS_RATE_CREATOR'       TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00738******************************************************************        
P00738* 7300-SELECT-TOU-PERIODS.                                       *        
P00738*     DETERMINE THE ENERGY AND DEMAND TIME-OF-USE PERIODS,       *        
P00738*     AND THE DEMAND TIME-OF-USE PERIOD'S UNITS.                 *        
P00738*     A NOT-FOUND SQLCODE INDICATES THAT THE RATE IS IDR         *        
P00738*     (BECAUSE WE USED A COMPONENT ID CODE OF '10' IN THE WHERE  *        
P00738*     CLAUSE).                                                   *        
P00738*                                                                *        
P00738******************************************************************        
P00738 7300-SELECT-TOU-PERIODS.                                         
P00738                                                                  
P00738     EXEC SQL                                                     
P00738        SELECT J1.REG_TYPE_CD                                     
P00738              ,J1.DEM_REG_TYPE_CD                                 
P00738              ,J1.DEM_UNIT_CD                                     
P00738         INTO  :J1-REG-TYPE-CD                                    
P00738              ,:J1-DEM-REG-TYPE-CD                                
P00738              ,:J1-DEM-UNIT-CD                                    
P00738         FROM  CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
P00738        WHERE  J1.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE         
P00738          AND  J1.RATE_PLAN_NO       = :J1-RATE-PLAN-NO           
P00738          AND  J1.CMPNT_ID_CD        = :J1-CMPNT-ID-CD            
P00738          AND  J1.VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL       
P00738                                                           
P00738                                                      
P00738     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT J1.REG_TYPE_CD                                             
MFA-TR*             ,J1.DEM_REG_TYPE_CD                                         
MFA-TR*             ,J1.DEM_UNIT_CD                                             
MFA-TR*        INTO  :J1-REG-TYPE-CD                                            
MFA-TR*             ,:J1-DEM-REG-TYPE-CD                                        
MFA-TR*             ,:J1-DEM-UNIT-CD                                            
MFA-TR*        FROM  CSS_RATE_COMP_DEF J1                                       
MFA-TR*       WHERE  J1.CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE                 
MFA-TR*         AND  J1.RATE_PLAN_NO       = :J1-RATE-PLAN-NO                   
MFA-TR*         AND  J1.CMPNT_ID_CD        = :J1-CMPNT-ID-CD                    
MFA-TR*         AND  J1.VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL               
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7300                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00738                                                                  
P00738     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00738                                                                  
P00738     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00738        CONTINUE                                                  
P00738     ELSE                                                         
P00738        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00738        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
P00738        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00738        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00738                                            ABEND-TABLES          
P00738        MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
P00738        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00738        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
P00738        MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
P00738        MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
P00738        MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00738        MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
P00738        MOVE J1-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
P00738        MOVE J1-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-4      
P00738        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
P00738     END-IF.                                                      
P00738                                                                  
P00738 7300-EXIT.                                                       
P00738     EXIT.                                                        
P00738                                                                  
P00738******************************************************************        
P00738* 7400-SELECT-PEAK-IND.                                          *        
P00738*     DETERMINE THE LFTM PEAK PERCENTAGE.  IF A RECORD IS NOT    *        
P00738*     FOUND OR THE PERCENTAGE = 0, THEN THE RATE DOES NOT        *        
P00738*     HAVE ANY LIFETIME PEAK OR DATE INFORMATION.                *        
P00738*                                                                *        
P00738******************************************************************        
P00738 7400-SELECT-PEAK-IND.                                            
P00738                                                                  
P00738     EXEC SQL                                                     
P00738        SELECT DI.LFTM_PEAK_PCT                                   
P00738          INTO :DI-LFTM-PEAK-PCT                                  
P00738          FROM CSS_DEMAND_INSTR DI WITH(READUNCOMMITTED)                  
P00738         WHERE DI.CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE         
P00738           AND DI.RATE_PLAN_NO       = :DI-RATE-PLAN-NO           
P00738           AND DI.CMPNT_ID_CD        = :DI-CMPNT-ID-CD            
P00738           AND DI.VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL       
P00738                                                           
P00738                                                      
P00738     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DI.LFTM_PEAK_PCT                                           
MFA-TR*         INTO :DI-LFTM-PEAK-PCT                                          
MFA-TR*         FROM CSS_DEMAND_INSTR DI                                        
MFA-TR*        WHERE DI.CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE                 
MFA-TR*          AND DI.RATE_PLAN_NO       = :DI-RATE-PLAN-NO                   
MFA-TR*          AND DI.CMPNT_ID_CD        = :DI-CMPNT-ID-CD                    
MFA-TR*          AND DI.VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00738                                                                  
P00738     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00738                                                                  
P00738     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00738        CONTINUE                                                  
P00738     ELSE                                                         
P00738        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00738        MOVE '7400'                     TO ACTIVE-PARAGRAPH       
P00738        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00738        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00738                                            ABEND-TABLES          
P00738        MOVE 'CSS_DEMAND_INSTR'         TO TABLE-1                
P00738        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
P00738        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
P00738        MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-3        
P00738        MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
P00738        MOVE DI-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
P00738        MOVE DI-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
P00738        MOVE DI-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
P00738        MOVE DI-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-4      
P00738        PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
P00738     END-IF.                                                      
P00738                                                                  
P00738 7400-EXIT.                                                       
P00738     EXIT.                                                        
P00738                                                                  
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04570_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04570_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04570_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04570_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,CODE_UTIL_TYPE                                       
                  ,RATE_PLAN_NO                                         
                  ,COMPANY_NO                                           
                  ,VERS_PRORATE_CD                                      
                  ,SECURED_RATE_FL                                      
                  ,RATE_DESC                                            
                  ,SUM_REVENUE_FL                                       
                  ,EXT_BILLING_FL                                       
                  ,UNMTR_PROV_FL                                        
                  ,REG_GROUP_CD                                         
                  ,BILL_LITERAL_TX                                      
                  ,MKT_PROGRAM_CD                                       
                  ,RATE_CALC_TYPE_CD                                    
                  ,SENIOR_RATE_FL                                       
                  ,DISPLAY_START_TS                                     
                  ,DISPLAY_END_TS                                       
                  ,DEFERRED_COG_FL                                      
                  ,RATE_DEFINITION_CD                                   
                  ,RATE_DEPT_CD                                         
                  ,REV_CUST_COUNT_CD                                    
                  ,CODE_SERVICE_TYPE                                    
                  ,VERSION_NO_CNTRL                                     
                  ,CODE_STATUS                                          
                  ,DATE_CREATED                                         
                  ,FROM_EFFECTIVE_DT                                    
                  ,BILL_FORMAT_CD                                       
                  ,SEASONAL_DEP_IND                                     
                  ,BASE_LOAD_THERMS                                     
                  ,HEAT_SENSITIVE_FAC                                   
                  ,SEASNAL_BLK_CHG_CD                                   
                  ,PROC_REQ_ID                                          
P00738            ,REG_TYPE_CD                                          
P00738            ,DEM_REG_TYPE_CD                                      
P00738            ,DEM_UNIT_CD                                          
P00738            ,LFTM_PEAK_PCT                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-CODE-UTIL-TYPE                                
                  ,:S-RS1-RATE-PLAN-NO                                  
                  ,:S-RS1-COMPANY-NO                                    
                  ,:S-RS1-VERS-PRORATE-CD                               
                  ,:S-RS1-SECURED-RATE-FL                               
                  ,:S-RS1-RATE-DESC                                     
                  ,:S-RS1-SUM-REVENUE-FL                                
                  ,:S-RS1-EXT-BILLING-FL                                
                  ,:S-RS1-UNMTR-PROV-FL                                 
                  ,:S-RS1-REG-GROUP-CD                                  
                  ,:S-RS1-BILL-LITERAL-TX                               
                  ,:S-RS1-MKT-PROGRAM-CD                                
                  ,:S-RS1-RATE-CALC-TYPE-CD                             
                  ,:S-RS1-SENIOR-RATE-FL                                
                  ,:S-RS1-DISPLAY-START-TS                              
                  ,:S-RS1-DISPLAY-END-TS                                
                  ,:S-RS1-DEFERRED-COG-FL                               
                  ,:S-RS1-RATE-DEFINITION-CD                            
                  ,:S-RS1-RATE-DEPT-CD                                  
                  ,:S-RS1-REV-CUST-COUNT                                
                  ,:S-RS1-CODE-SERVICE-TYPE                             
                  ,:S-RS1-VERSION-NO-CNTRL                              
                  ,:S-RS1-CODE-STATUS                                   
                  ,:S-RS1-DATE-CREATED                                  
                  ,:S-RS1-FROM-EFFECTIVE-DT                             
                  ,:S-RS1-BILL-FORMAT-CD                                
                  ,:S-RS1-SEASONAL-DEP-IND                              
                  ,:S-RS1-BASE-LOAD-THERMS                              
                  ,:S-RS1-HEAT-SENSITIVE-FAC                            
                  ,:S-RS1-SEASNAL-BLK-CHG-CD                            
                  ,:S-RS1-PROC-REQ-ID                                   
P00738            ,:S-RS1-REG-TYPE-CD                                   
P00738            ,:S-RS1-DEM-REG-TYPE-CD                               
P00738            ,:S-RS1-DEM-UNIT-CD                                   
P00738            ,:S-RS1-LFTM-PEAK-PCT                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04570_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,VERS_PRORATE_CD                                              
MFA-TR*           ,SECURED_RATE_FL                                              
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,SUM_REVENUE_FL                                               
MFA-TR*           ,EXT_BILLING_FL                                               
MFA-TR*           ,UNMTR_PROV_FL                                                
MFA-TR*           ,REG_GROUP_CD                                                 
MFA-TR*           ,BILL_LITERAL_TX                                              
MFA-TR*           ,MKT_PROGRAM_CD                                               
MFA-TR*           ,RATE_CALC_TYPE_CD                                            
MFA-TR*           ,SENIOR_RATE_FL                                               
MFA-TR*           ,DISPLAY_START_TS                                             
MFA-TR*           ,DISPLAY_END_TS                                               
MFA-TR*           ,DEFERRED_COG_FL                                              
MFA-TR*           ,RATE_DEFINITION_CD                                           
MFA-TR*           ,RATE_DEPT_CD                                                 
MFA-TR*           ,REV_CUST_COUNT_CD                                            
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*           ,VERSION_NO_CNTRL                                             
MFA-TR*           ,CODE_STATUS                                                  
MFA-TR*           ,DATE_CREATED                                                 
MFA-TR*           ,FROM_EFFECTIVE_DT                                            
MFA-TR*           ,BILL_FORMAT_CD                                               
MFA-TR*           ,SEASONAL_DEP_IND                                             
MFA-TR*           ,BASE_LOAD_THERMS                                             
MFA-TR*           ,HEAT_SENSITIVE_FAC                                           
MFA-TR*           ,SEASNAL_BLK_CHG_CD                                           
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,REG_TYPE_CD                                                  
MFA-TR*           ,DEM_REG_TYPE_CD                                              
MFA-TR*           ,DEM_UNIT_CD                                                  
MFA-TR*           ,LFTM_PEAK_PCT                                                
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS1-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS1-COMPANY-NO                                            
MFA-TR*           ,:S-RS1-VERS-PRORATE-CD                                       
MFA-TR*           ,:S-RS1-SECURED-RATE-FL                                       
MFA-TR*           ,:S-RS1-RATE-DESC                                             
MFA-TR*           ,:S-RS1-SUM-REVENUE-FL                                        
MFA-TR*           ,:S-RS1-EXT-BILLING-FL                                        
MFA-TR*           ,:S-RS1-UNMTR-PROV-FL                                         
MFA-TR*           ,:S-RS1-REG-GROUP-CD                                          
MFA-TR*           ,:S-RS1-BILL-LITERAL-TX                                       
MFA-TR*           ,:S-RS1-MKT-PROGRAM-CD                                        
MFA-TR*           ,:S-RS1-RATE-CALC-TYPE-CD                                     
MFA-TR*           ,:S-RS1-SENIOR-RATE-FL                                        
MFA-TR*           ,:S-RS1-DISPLAY-START-TS                                      
MFA-TR*           ,:S-RS1-DISPLAY-END-TS                                        
MFA-TR*           ,:S-RS1-DEFERRED-COG-FL                                       
MFA-TR*           ,:S-RS1-RATE-DEFINITION-CD                                    
MFA-TR*           ,:S-RS1-RATE-DEPT-CD                                          
MFA-TR*           ,:S-RS1-REV-CUST-COUNT                                        
MFA-TR*           ,:S-RS1-CODE-SERVICE-TYPE                                     
MFA-TR*           ,:S-RS1-VERSION-NO-CNTRL                                      
MFA-TR*           ,:S-RS1-CODE-STATUS                                           
MFA-TR*           ,:S-RS1-DATE-CREATED                                          
MFA-TR*           ,:S-RS1-FROM-EFFECTIVE-DT                                     
MFA-TR*           ,:S-RS1-BILL-FORMAT-CD                                        
MFA-TR*           ,:S-RS1-SEASONAL-DEP-IND                                      
MFA-TR*           ,:S-RS1-BASE-LOAD-THERMS                                      
MFA-TR*           ,:S-RS1-HEAT-SENSITIVE-FAC                                    
MFA-TR*           ,:S-RS1-SEASNAL-BLK-CHG-CD                                    
MFA-TR*           ,:S-RS1-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS1-REG-TYPE-CD                                           
MFA-TR*           ,:S-RS1-DEM-REG-TYPE-CD                                       
MFA-TR*           ,:S-RS1-DEM-UNIT-CD                                           
MFA-TR*           ,:S-RS1-LFTM-PEAK-PCT                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04570_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
