       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04563.                                         
       AUTHOR.        MS93554.                                          
COB303 DATE-WRITTEN.  AUGUST 22,2012                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *      USED TO INSERT/DELETE FOR GENERAL LEDGER INTERFACE TABLE  *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  -------------------                                           *        
      *  ACTION_CD            CHAR(01)                                 *        
      *  GL_INTRFCE_ACCT_NO   DECIMAL(7,4)                             *        
      *  RESOURCE_CD          CHAR(03)                                 *        
      *  ACTIVITY_CD          CHAR(04)                                 *        
      *  COMPANY_IND          CHAR(02)                                 *        
      *  BUSINESS_UNIT        CHAR(05)                                 *        
      *  CUSTOMER_CD          CHAR(03)                                 *        
      *  COST_CENTER          CHAR(04)                                 *        
      *  COST_CENTER_IND      CHAR(01)                                 *        
      *  OPERATING_UNIT       CHAR(04)                                 *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -------------------------                                     *        
      *  RETURN_CODE           INTEGER                                 *        
      *  APPL_RETURN_CODE      INTEGER                                 *        
      *                                                                *        
      *  APPL_RETURN_CODE                                              *        
      *  -------------------------                                     *        
      *  200 - ROW ALREADY EXISTS IN CSS_GL_INTRFCE TABLE.             *        
      *  200 - ROW ALREADY EXISTS IN CSS_GL_INTRFCE_SEQ TABLE.         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/22/12  MS93554    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04563'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04563 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_GL_INTRFCE     2J                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_GL_INTRFCE_SEQ J1                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINSQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *  COMMON SYSTEM AREA                                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *  ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                *        
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *  SUPPORTS DB2 AND SQL ERROR CHECKING                           *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *  ERROR HANDLING                                              *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04563'. 
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-GL-INTRFCE-EXIST          PIC X(01) VALUE 'N'.        
               88 GL-INTRFCE-SEQ-EXIST                VALUE 'Y'.        
           05  WS-GL-INTRFC-ACCT-EXIST      PIC X(01) VALUE 'N'.        
               88 GL-INTRFCE-ACCT-EXIST               VALUE 'Y'.        
                                                                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-LITERALS.                                                 
           05 INSERT-ROW                    PIC X(01) VALUE 'I'.        
           05 DELETE-ROW                    PIC X(01) VALUE 'D'.        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01                PIC S9(4) COMP.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.     
           05 S-APPL-RETURN-CODE            PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-GENERAL-FIELDS.                                           
           05 WS-ACTION-CD                  PIC X(01).                  
           05 WS-LAST-UPDATE-USER-ID        PIC X(07).                  
           05 WS-GL-MAX-SEQ-NO              PIC S9(4) USAGE COMP.       
COB305     05 WS-GL-INTRFCE-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.
           05 WS-RESOURCE-CD                PIC X(03).                  
           05 WS-ACTIVITY-CD                PIC X(04).                  
           05 WS-COMPANY-IND                PIC X(02).                  
           05 WS-BUSINESS-UNIT              PIC X(05).                  
           05 WS-CUSTOMER-CD                PIC X(03).                  
           05 WS-COST-CENTER                PIC X(04).                  
           05 WS-COST-CENTER-IND            PIC X(01).                  
           05 WS-OPERATING-UNIT             PIC X(04).                  
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACTION-CD                PIC X(01).                     
       01  PARM-USER-ID                  PIC X(07).                     
COB305 01 PARM-GL-INTRFCE-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.   
       01  PARM-RESOURCE-CD              PIC X(03).                     
       01  PARM-ACTIVITY-CD              PIC X(04).                     
       01  PARM-COMPANY-IND              PIC X(02).                     
       01  PARM-BUSINESS-UNIT            PIC X(05).                     
       01  PARM-CUSTOMER-CD              PIC X(03).                     
       01  PARM-COST-CENTER              PIC X(04).                     
       01  PARM-COST-CENTER-IND          PIC X(01).                     
       01  PARM-OPERATING-UNIT           PIC X(04).                     
                                                                        
       PROCEDURE DIVISION USING PARM-ACTION-CD                          
                                PARM-USER-ID                            
                                PARM-GL-INTRFCE-ACCT-NO                 
                                PARM-RESOURCE-CD                        
                                PARM-ACTIVITY-CD                        
                                PARM-COMPANY-IND                        
                                PARM-BUSINESS-UNIT                      
                                PARM-CUSTOMER-CD                        
                                PARM-COST-CENTER                        
                                PARM-COST-CENTER-IND                    
                                PARM-OPERATING-UNIT.                    
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :S-RETURN-CODE              AS  RETURN_CODE           
                 ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE      
             FROM CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :S-RETURN-CODE              AS  RETURN_CODE                   
MFA-TR*          ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE              
MFA-TR*      FROM SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-CD            TO WS-ACTION-CD               
           MOVE PARM-USER-ID              TO 2J-LAST-UPDATE-USERID      
           MOVE PARM-GL-INTRFCE-ACCT-NO   TO 2J-GL-INTRFCE-ACCT-NO      
           MOVE PARM-RESOURCE-CD          TO 2J-RESOURCE-CD             
           MOVE PARM-ACTIVITY-CD          TO 2J-ACTIVITY-CD             
           MOVE PARM-COMPANY-IND          TO 2J-COMPANY-IND             
           MOVE PARM-BUSINESS-UNIT        TO 2J-BUSINESS-UNIT           
           MOVE PARM-CUSTOMER-CD          TO 2J-CUSTOMER-CD             
           MOVE PARM-COST-CENTER          TO 2J-COST-CENTER             
           MOVE PARM-COST-CENTER-IND      TO 2J-COST-CENTER-IND         
           MOVE PARM-OPERATING-UNIT       TO 2J-OPERATING-UNIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *    INSERT/DELETE PROCESSS FOR CSS_GL_INTRFCE.                           
           EVALUATE WS-ACTION-CD                                        
              WHEN INSERT-ROW                                           
                   PERFORM 7000-CHK-GL-ROW-ALRDY-EXIST    THRU 7000-EXIT
                   IF GL-INTRFCE-ACCT-EXIST                             
                      MOVE 0                     TO S-RETURN-CODE       
                      MOVE 200                   TO S-APPL-RETURN-CODE  
                      ADD +1                     TO CTR-ROWS            
                      PERFORM 9999-END-PROGRAM            THRU 9999-EXIT
                   ELSE                                                 
                      PERFORM 7100-GET-GL-INTRFCE-MAX-SEQ THRU 7100-EXIT
                      ADD  +1                    TO WS-GL-MAX-SEQ-NO    
                      MOVE WS-GL-MAX-SEQ-NO      TO 2J-GL-INTRFCE-SEQ-NO
                      PERFORM 8000-INSERT-GL-INTRFCE      THRU 8000-EXIT
                   END-IF                                               
              WHEN DELETE-ROW                                           
                   PERFORM 7200-CHK-GL-ROW-ALRDY-EXIT     THRU 7200-EXIT
                   IF GL-INTRFCE-SEQ-EXIST                              
                      MOVE 0                     TO S-RETURN-CODE       
                      MOVE 210                   TO S-APPL-RETURN-CODE  
                      ADD +1                     TO CTR-ROWS            
                      PERFORM 9999-END-PROGRAM      THRU 9999-EXIT      
                   ELSE                                                 
                      PERFORM 8100-DEL-GL-INTRFCE   THRU 8100-EXIT      
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           ADD +1                                TO CTR-ROWS.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-CHK-GL-ROW-ALRDY-EXIST.                                  *         
      *****************************************************************         
       7000-CHK-GL-ROW-ALRDY-EXIST.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-GL-INTRFC-ACCT-EXIST                           
                FROM CSS_GL_INTRFCE     T2J WITH(READUNCOMMITTED)               
               WHERE T2J.GL_INTRFCE_ACCT_NO   = :2J-GL-INTRFCE-ACCT-NO  
                 AND T2J.COMPANY_IND          = :2J-COMPANY-IND         
                 AND T2J.ACTIVITY_CD          = :2J-ACTIVITY-CD         
                 AND T2J.RESOURCE_CD          = :2J-RESOURCE-CD         
                 AND T2J.BUSINESS_UNIT        = :2J-BUSINESS-UNIT       
                 AND T2J.CUSTOMER_CD          = :2J-CUSTOMER-CD         
                 AND T2J.COST_CENTER          = :2J-COST-CENTER         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-GL-INTRFC-ACCT-EXIST                                   
MFA-TR*         FROM CSS_GL_INTRFCE     T2J                                     
MFA-TR*        WHERE T2J.GL_INTRFCE_ACCT_NO   = :2J-GL-INTRFCE-ACCT-NO          
MFA-TR*          AND T2J.COMPANY_IND          = :2J-COMPANY-IND                 
MFA-TR*          AND T2J.ACTIVITY_CD          = :2J-ACTIVITY-CD                 
MFA-TR*          AND T2J.RESOURCE_CD          = :2J-RESOURCE-CD                 
MFA-TR*          AND T2J.BUSINESS_UNIT        = :2J-BUSINESS-UNIT               
MFA-TR*          AND T2J.CUSTOMER_CD          = :2J-CUSTOMER-CD                 
MFA-TR*          AND T2J.COST_CENTER          = :2J-COST-CENTER                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_INTRFCE'           TO TABLE-1                
              MOVE 'CSS_GL_INTRFCE_SEQ'       TO TABLE-1                
              MOVE 'GL_GL_INTRFCE_SEQ_NO'     TO TABLE-ELEMENT-1        
              MOVE 'ACTIVITY_CD'              TO TABLE-ELEMENT-2        
              MOVE 'RESOURCE_CD'              TO TABLE-ELEMENT-3        
              MOVE 2J-GL-INTRFCE-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE 2J-ACTIVITY-CD             TO HOSTVAR-ELEMENT-2      
              MOVE 2J-RESOURCE-CD             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-GET-GL-INTRFCE-MAX-SEQ.                                  *         
      *****************************************************************         
       7100-GET-GL-INTRFCE-MAX-SEQ.                                     
                                                                        
           EXEC SQL                                                     
              SELECT MAX(GL_INTRFCE_SEQ_NO)                             
                INTO :WS-GL-MAX-SEQ-NO :WS-NULL-IND-01                   
                FROM CSS_GL_INTRFCE T2J WITH(READUNCOMMITTED)                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(GL_INTRFCE_SEQ_NO)                                     
MFA-TR*         INTO :WS-GL-MAX-SEQ-NO:WS-NULL-IND-01                           
MFA-TR*         FROM CSS_GL_INTRFCE T2J                                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 = -1                                    
                 MOVE ZERO                    TO WS-GL-MAX-SEQ-NO       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_INTRFCE'           TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-CHK-GL-ROW-ALRDY-EXIT.                                   *         
      *****************************************************************         
       7200-CHK-GL-ROW-ALRDY-EXIT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-GL-INTRFCE-EXIST                               
                FROM CSS_GL_INTRFCE     T2J WITH(READUNCOMMITTED)               
                    ,CSS_GL_INTRFCE_SEQ T2N WITH(READUNCOMMITTED)               
               WHERE T2J.GL_INTRFCE_ACCT_NO   = :2J-GL-INTRFCE-ACCT-NO  
                 AND T2J.COMPANY_IND          = :2J-COMPANY-IND         
                 AND T2J.ACTIVITY_CD          = :2J-ACTIVITY-CD         
                 AND T2J.RESOURCE_CD          = :2J-RESOURCE-CD         
                 AND T2J.BUSINESS_UNIT        = :2J-BUSINESS-UNIT       
                 AND T2J.CUSTOMER_CD          = :2J-CUSTOMER-CD         
                 AND T2J.COST_CENTER          = :2J-COST-CENTER         
                 AND T2N.GL_INTRFCE_SEQ_NO    = T2J.GL_INTRFCE_SEQ_NO   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-GL-INTRFCE-EXIST                                       
MFA-TR*         FROM CSS_GL_INTRFCE     T2J                                     
MFA-TR*             ,CSS_GL_INTRFCE_SEQ T2N                                     
MFA-TR*        WHERE T2J.GL_INTRFCE_ACCT_NO   = :2J-GL-INTRFCE-ACCT-NO          
MFA-TR*          AND T2J.COMPANY_IND          = :2J-COMPANY-IND                 
MFA-TR*          AND T2J.ACTIVITY_CD          = :2J-ACTIVITY-CD                 
MFA-TR*          AND T2J.RESOURCE_CD          = :2J-RESOURCE-CD                 
MFA-TR*          AND T2J.BUSINESS_UNIT        = :2J-BUSINESS-UNIT               
MFA-TR*          AND T2J.CUSTOMER_CD          = :2J-CUSTOMER-CD                 
MFA-TR*          AND T2J.COST_CENTER          = :2J-COST-CENTER                 
MFA-TR*          AND T2N.GL_INTRFCE_SEQ_NO    = T2J.GL_INTRFCE_SEQ_NO           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_INTRFCE'           TO TABLE-1                
              MOVE 'CSS_GL_INTRFCE_SEQ'       TO TABLE-1                
              MOVE 'GL_GL_INTRFCE_SEQ_NO'     TO TABLE-ELEMENT-1        
              MOVE 'ACTIVITY_CD'              TO TABLE-ELEMENT-2        
              MOVE 'RESOURCE_CD'              TO TABLE-ELEMENT-3        
              MOVE 2J-GL-INTRFCE-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE 2J-ACTIVITY-CD             TO HOSTVAR-ELEMENT-2      
              MOVE 2J-RESOURCE-CD             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000-INSERT-GL-INTRFCE.                                       *         
      *****************************************************************         
       8000-INSERT-GL-INTRFCE.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_GL_INTRFCE                                
                   (                                                    
                     GL_INTRFCE_SEQ_NO                                  
                    ,GL_INTRFCE_ACCT_NO                                 
                    ,RESOURCE_CD                                        
                    ,ACTIVITY_CD                                        
                    ,COMPANY_IND                                        
                    ,BUSINESS_UNIT                                      
                    ,CUSTOMER_CD                                        
                    ,COST_CENTER                                        
                    ,COST_CENTER_IND                                    
                    ,OPERATING_UNIT                                     
                    ,LAST_UPDATE_USERID                                 
                   )                                                    
              VALUES                                                    
                   (                                                    
                     :2J-GL-INTRFCE-SEQ-NO                              
                    ,:2J-GL-INTRFCE-ACCT-NO                             
                    ,:2J-RESOURCE-CD                                    
                    ,:2J-ACTIVITY-CD                                    
                    ,:2J-COMPANY-IND                                    
                    ,:2J-BUSINESS-UNIT                                  
                    ,:2J-CUSTOMER-CD                                    
                    ,:2J-COST-CENTER                                    
                    ,:2J-COST-CENTER-IND                                
                    ,:2J-OPERATING-UNIT                                 
                    ,:2J-LAST-UPDATE-USERID                             
                   )                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_INTRFCE'           TO TABLE-1                
              MOVE 'GL_INTRFCE_SEQ_NO'        TO TABLE-ELEMENT-1        
              MOVE 2J-GL-INTRFCE-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-DEL-GL-INTRFCE.                                          *         
      *****************************************************************         
       8100-DEL-GL-INTRFCE.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_GL_INTRFCE                                
               WHERE GL_INTRFCE_ACCT_NO   = :2J-GL-INTRFCE-ACCT-NO      
                 AND COMPANY_IND          = :2J-COMPANY-IND             
                 AND ACTIVITY_CD          = :2J-ACTIVITY-CD             
                 AND RESOURCE_CD          = :2J-RESOURCE-CD             
                 AND BUSINESS_UNIT        = :2J-BUSINESS-UNIT           
                 AND CUSTOMER_CD          = :2J-CUSTOMER-CD             
                 AND COST_CENTER          = :2J-COST-CENTER             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_INTRFCE'           TO TABLE-1                
              MOVE 'GL_GL_INTRFCE_SEQ_NO'     TO TABLE-ELEMENT-1        
              MOVE 'ACTIVITY_CD'              TO TABLE-ELEMENT-2        
              MOVE 'RESOURCE_CD'              TO TABLE-ELEMENT-3        
              MOVE 2J-GL-INTRFCE-SEQ-NO       TO HOSTVAR-ELEMENT-1      
              MOVE 2J-ACTIVITY-CD             TO HOSTVAR-ELEMENT-2      
              MOVE 2J-RESOURCE-CD             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
                                                                        
