       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04560.                                     
COB303 DATE-WRITTEN.  AUG 01,2012                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * This Program is used to create/Update/Delete Local Office &    *        
      * Cost Center assignment.                                        *        
      *                                                                *        
      *  Result Sets:                                                  *        
      *         1. Return Code                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  08/16/12  VENKAT.P   Procedure Originally Coded.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04560'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                    PIC X(40) VALUE                   
          'WORKING STORAGE FOR CSR04560 STARTS HERE'.                   
      *                                                                         
       01 WS-MISC.                                                      
          05 CTR-ROWS                 PIC S9(9) COMP VALUE 0.           
      *                                                                         
       01 WS-PARMS.                                                     
          05 WS-PARM-ACTION-CD        PIC X(01).                        
          05 WS-PARM-LOCAL-OFFICE     PIC X(03).                        
          05 WS-PARM-BUSINESS-UNIT    PIC X(05).                        
          05 WS-PARM-COST-CTR-IND     PIC X(01).                        
          05 WS-PARM-COST-CTR         PIC X(04).                        
          05 WS-PARM-LST-UPD-USER-ID  PIC X(07).                        
      *                                                                         
       01 WS-LABELS.                                                    
          05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04560'.       
          05 WS-D                     PIC X(01) VALUE 'D'.              
          05 WS-I                     PIC X(01) VALUE 'I'.              
          05 WS-U                     PIC X(01) VALUE 'U'.              
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE            PIC S9(9) COMP VALUE 0.           
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR                VALUE 'N'.              
              88 SEND-DONE-OK                   VALUE 'Y'.              
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      *--> ERROR HANDLING                                                       
      *                                                                         
          COPY CWS00303.                                                        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GL_COSTCTR_ASN - 2S                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGLCOST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WS FOR ERROR HANDLING                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-ACTION-CD               PIC X(1).                        
       01 PARM-LOCAL-OFFICE            PIC X(3).                        
       01 PARM-BUSINESS-UNIT           PIC X(5).                        
       01 PARM-COST-CTR-IND            PIC X(1).                        
       01 PARM-COST-CTR                PIC X(4).                        
       01 PARM-LST-UPD-USER-ID         PIC X(7).                        
      *                                                                         
       PROCEDURE DIVISION USING                                         
                          PARM-ACTION-CD                                
                        , PARM-LOCAL-OFFICE                             
                        , PARM-BUSINESS-UNIT                            
                        , PARM-COST-CTR-IND                             
                        , PARM-COST-CTR                                 
                        , PARM-LST-UPD-USER-ID                          
                        .                                               
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           MOVE PARM-ACTION-CD           TO WS-PARM-ACTION-CD.          
           MOVE PARM-LOCAL-OFFICE        TO WS-PARM-LOCAL-OFFICE.       
           MOVE PARM-BUSINESS-UNIT       TO WS-PARM-BUSINESS-UNIT.      
           MOVE PARM-COST-CTR-IND        TO WS-PARM-COST-CTR-IND.       
           MOVE PARM-COST-CTR            TO WS-PARM-COST-CTR.           
           MOVE PARM-LST-UPD-USER-ID     TO WS-PARM-LST-UPD-USER-ID.    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           MOVE WS-PARM-LOCAL-OFFICE     TO 2S-LOCAL-OFFICE.            
           MOVE WS-PARM-BUSINESS-UNIT    TO 2S-BUSINESS-UNIT.           
           MOVE WS-PARM-COST-CTR-IND     TO 2S-COST-CENTER-IND.         
           MOVE WS-PARM-COST-CTR         TO 2S-COST-CENTER.             
           MOVE WS-PARM-LST-UPD-USER-ID  TO 2S-LAST-UPDATE-USERID.      
      *                                                                         
           MOVE ZERO                     TO S-RETURN-CODE.              
           EVALUATE WS-PARM-ACTION-CD                                   
               WHEN 'I'                                                 
                    PERFORM 8000-INSERT-ASSIGNMENT THRU 8000-EXIT       
               WHEN 'U'                                                 
                    PERFORM 8025-UPDATE-ASSIGNMENT THRU 8025-EXIT       
               WHEN 'D'                                                 
                    PERFORM 8050-DELETE-ASSIGNMENT THRU 8050-EXIT       
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INSERT-ASSIGNMENT.                                        *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-ASSIGNMENT.                                          
      *                                                                         
           MOVE '8000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_GL_COSTCTR_ASN                             
                         (                                              
                           LOCAL_OFFICE                                 
                          ,BUSINESS_UNIT                                
                          ,COST_CENTER_IND                              
                          ,COST_CENTER                                  
                          ,LAST_UPDATE_USERID                           
                         )                                              
                  VALUES                                                
                         (                                              
                           :2S-LOCAL-OFFICE                             
                          ,:2S-BUSINESS-UNIT                            
                          ,:2S-COST-CENTER-IND                          
                          ,:2S-COST-CENTER                              
                          ,:2S-LAST-UPDATE-USERID                       
                         )                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GL_COSTCTR_ASN'  TO TABLE-1                    
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1            
               MOVE 'BUSINESS_UNIT'       TO TABLE-ELEMENT-2            
               MOVE 'COST_CENTER_IND'     TO TABLE-ELEMENT-3            
               MOVE 'LAST_UPDATE_USERID'  TO TABLE-ELEMENT-4            
               MOVE 2S-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1          
               MOVE 2S-BUSINESS-UNIT      TO HOSTVAR-ELEMENT-2          
               MOVE 2S-COST-CENTER-IND    TO HOSTVAR-ELEMENT-3          
               MOVE 2S-LAST-UPDATE-USERID TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8025-UPDATE-ASSIGNMENT.                                        *        
      ******************************************************************        
      *                                                                         
       8025-UPDATE-ASSIGNMENT.                                          
      *                                                                         
           MOVE '8025'                    TO WS-ACTIVE-PARAGRAPH.       
      *                                                                         
           EXEC SQL                                                     
             UPDATE [2S]                                
                SET [2S].COST_CENTER        = :2S-COST-CENTER             
                   ,[2S].LAST_UPDATE_USERID = :2S-LAST-UPDATE-USERID      
             FROM CSS_GL_COSTCTR_ASN [2S]
              WHERE                                                     
                    [2S].LOCAL_OFFICE       = :2S-LOCAL-OFFICE            
                AND [2S].BUSINESS_UNIT      = :2S-BUSINESS-UNIT           
                AND [2S].COST_CENTER_IND    = :2S-COST-CENTER-IND         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_GL_COSTCTR_ASN 2S                                       
MFA-TR*         SET 2S.COST_CENTER        = :2S-COST-CENTER                     
MFA-TR*            ,2S.LAST_UPDATE_USERID = :2S-LAST-UPDATE-USERID              
MFA-TR*       WHERE                                                             
MFA-TR*             2S.LOCAL_OFFICE       = :2S-LOCAL-OFFICE                    
MFA-TR*         AND 2S.BUSINESS_UNIT      = :2S-BUSINESS-UNIT                   
MFA-TR*         AND 2S.COST_CENTER_IND    = :2S-COST-CENTER-IND                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_GL_COSTCTR_ASN'  TO TABLE-1                    
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1            
               MOVE 'BUSINESS_UNIT'       TO TABLE-ELEMENT-2            
               MOVE 'COST_CENTER_IND'     TO TABLE-ELEMENT-3            
               MOVE 'LAST_UPDATE_USERID'  TO TABLE-ELEMENT-4            
               MOVE 2S-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1          
               MOVE 2S-BUSINESS-UNIT      TO HOSTVAR-ELEMENT-2          
               MOVE 2S-COST-CENTER-IND    TO HOSTVAR-ELEMENT-3          
               MOVE 2S-LAST-UPDATE-USERID TO HOSTVAR-ELEMENT-4          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8050-DELETE-ASSIGNMENT.                                        *        
      ******************************************************************        
      *                                                                         
       8050-DELETE-ASSIGNMENT.                                          
      *                                                                         
           MOVE '8050'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_GL_COSTCTR_ASN                             
              WHERE                                                     
                    LOCAL_OFFICE       = :2S-LOCAL-OFFICE               
                AND BUSINESS_UNIT      = :2S-BUSINESS-UNIT              
                AND COST_CENTER_IND    = :2S-COST-CENTER-IND            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_GL_COSTCTR_ASN'  TO TABLE-1                    
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1            
               MOVE 'BUSINESS_UNIT'       TO TABLE-ELEMENT-2            
               MOVE 'COST_CENTER_IND'     TO TABLE-ELEMENT-3            
               MOVE 2S-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1          
               MOVE 2S-BUSINESS-UNIT      TO HOSTVAR-ELEMENT-2          
               MOVE 2S-COST-CENTER-IND    TO HOSTVAR-ELEMENT-3          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
             ADD 1 TO CTR-ROWS.                                         
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
