       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04559.                                     
COB303 DATE-WRITTEN.  AUG 01,2012                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * This Program is used to transfer money from one GL Account to  *        
      * another. Cloned from CSR02448.                                 *        
      *                                                                *        
      *  Result Sets:                                                  *        
      *         1. Return Code and/or failed Business Rules, if any.   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  08/01/12  VENKAT.P   Procedure Originally Coded.              *        
ACT287*  11/02/16  RB19957    Update CSR04559 by replacing 'KP09775'   *        
ACT287*   APPL00005460,ACT287 with 'SYSTEM'.                           *        
ACT382*  12/09/16  VIJAY      REMOVE UNUSED DCLGEN TBBAPYMT            *        
ACT382*   APPL00005460                                                 *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04559'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                    PIC X(40) VALUE                   
          'WORKING STORAGE FOR CSR04559 STARTS HERE'.                   
      *                                                                         
       01 WS-FLAGS.                                                     
          05 WS-HDR-COUNT-FLAG        PIC X(01) VALUE 'N'.              
      *                                                                         
       01 WS-LABELS.                                                    
          05 PROGRAM-NAME             PIC X(8)  VALUE 'CSR04559'.       
          05 WS-Y                     PIC X(01) VALUE 'Y'.              
          05 WS-N                     PIC X(01) VALUE 'N'.              
          05 WS-A                     PIC X(01) VALUE 'A'.              
          05 WS-C                     PIC X(01) VALUE 'C'.              
          05 WS-D                     PIC X(01) VALUE 'D'.              
          05 WS-001                   PIC X(03) VALUE '001'.            
          05 WS-998                   PIC X(03) VALUE '998'.            
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-NULL-INDICATOR1       PIC S9(04) COMP VALUE +0.         
          05 WS-ACCOUNT-NO            PIC X(13).                        
          05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                  
                                      PIC 9(13).                        
          05 WS-DEBIT-GL-ACCT-NO      PIC X(07).                        
          05 WS-DEBIT-GL-ACCT  REDEFINES WS-DEBIT-GL-ACCT-NO            
                                      PIC 9(03)V9(04).                  
          05 WS-CR-GL-ACCT-NO         PIC X(07).                        
          05 WS-CR-GL-ACCT     REDEFINES WS-CR-GL-ACCT-NO               
                                      PIC 9(03)V9(04).                  
          05 WS-TRAN-COMMENT-LEN      PIC S9(09) COMP.                  
          05 WS-TRAN-COMMENT-TEXT     PIC X(210).                       
          05 WS-AMOUNT-MOVED          PIC X(12).                        
          05 WS-AMOUNT         REDEFINES  WS-AMOUNT-MOVED               
                                      PIC 9(10)V99.                     
          05 WS-REVENUE-MONTH         PIC X(06).                        
          05 WS-REV-MONTH-NUM  REDEFINES WS-REVENUE-MONTH               
                                      PIC 9(06).                        
          05 WS-REV-MONTH-COMP        PIC S9(06) COMP VALUE +0.         
          05 CTR-ROWS                 PIC S9(9) COMP VALUE 0.           
          05 WRK-DONE-STATUS          PIC S9(9) COMP.                   
      *                                                                         
       01 WS-DATES.                                                     
          05 WS-CURRENT-DATE          PIC X(10).                        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE            PIC S9(9) COMP VALUE 0.           
          05 S-BUS-RULE-ID            PIC X(10) VALUE SPACES.           
          05 S-BUS-RULE-RESULT-CD     PIC X(08) VALUE SPACES.           
          05 S-BUS-RULE-XREF-ID       PIC X(26) VALUE SPACES.           
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE                   VALUE 'N'.              
              88 ALL-DONE                       VALUE 'Y'.              
          05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR                VALUE 'N'.              
              88 SEND-DONE-OK                   VALUE 'Y'.              
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      *--> ERROR HANDLING                                                       
      *                                                                         
          COPY CWS00303.                                                        
      *                                                                         
      *--> WS FOR USER DEFINED BATCH/CASH JOURNAL                               
      *                                                                         
          COPY CJF00101.                                                        
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    CSS_AR_LOCKOUT - AL                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BCH_JRNL_CNTL - BC                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BATCH_JRNL - BJ                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL - CS                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CSH_DRWR_JRNL - CJ                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_GL_ACCT_NO - GO                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MISC_JRNL - MJ                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_USER_PROFILE - PF                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PREMISE - PR                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CSH_REPORT_HDR - YR                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSRPHD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CASHIER_OFFICE - Y2                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BUS_RULE - 1R                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBUSRUL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BUS_RULE_ACTN - 1S                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRULACT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BUS_RULE_XREF - 1T                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CPD00010 WORKING STORAGE                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COMMON JOURNAL AREA                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WS FOR ERROR HANDLING                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-ACCOUNT-NO              PIC X(013).                      
       01 PARM-DEBIT-GL-ACCT           PIC X(007).                      
       01 PARM-CREDIT-GL-ACCT          PIC X(007).                      
       01 PARM-AMOUNT                  PIC X(012).                      
       01 PARM-COMMENT-TEXT            PIC X(210).                      
       01 PARM-COMMENT-LEN             PIC X(004).                      
       01 PARM-USER-ID                 PIC X(007).                      
       01 PARM-PANEL-NO                PIC X(009).                      
       01 PARM-DATE-CASH-REPORT        PIC X(010).                      
       01 PARM-CASH-COMPANY-NO         PIC X(002).                      
       01 PARM-CASH-LOCAL-OFFICE       PIC X(003).                      
       01 PARM-LOCAL-OFFICE            PIC X(003).                      
       01 PARM-REVENUE-MONTH           PIC X(006).                      
       01 PARM-CSR-PC-ID               PIC X(004).                      
      *                                                                         
       PROCEDURE DIVISION USING                                         
                          PARM-ACCOUNT-NO                               
                        , PARM-DEBIT-GL-ACCT                            
                        , PARM-CREDIT-GL-ACCT                           
                        , PARM-AMOUNT                                   
                        , PARM-COMMENT-TEXT                             
                        , PARM-COMMENT-LEN                              
                        , PARM-USER-ID                                  
                        , PARM-PANEL-NO                                 
                        , PARM-DATE-CASH-REPORT                         
                        , PARM-CASH-COMPANY-NO                          
                        , PARM-CASH-LOCAL-OFFICE                        
                        , PARM-LOCAL-OFFICE                             
                        , PARM-REVENUE-MONTH                            
                        , PARM-CSR-PC-ID                                
                        .                                               
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           PERFORM 7100-GET-CURRENT-DT   THRU 7100-EXIT.                
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-BUS-RULE-ID              AS    BUS_RULE_ID             
             ,:S-BUS-RULE-RESULT-CD       AS    BUS_RULE_RESULT_CD      
             ,:S-BUS-RULE-XREF-ID         AS    BUS_RULE_XREF_ID        
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-BUS-RULE-ID              AS    BUS_RULE_ID                     
MFA-TR*      ,:S-BUS-RULE-RESULT-CD       AS    BUS_RULE_RESULT_CD              
MFA-TR*      ,:S-BUS-RULE-XREF-ID         AS    BUS_RULE_XREF_ID                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           MOVE PARM-DEBIT-GL-ACCT       TO WS-DEBIT-GL-ACCT-NO.        
           MOVE PARM-CREDIT-GL-ACCT      TO WS-CR-GL-ACCT-NO.           
           MOVE PARM-AMOUNT              TO WS-AMOUNT-MOVED.            
           MOVE PARM-COMMENT-LEN         TO WS-TRAN-COMMENT-LEN.        
           MOVE PARM-COMMENT-TEXT        TO WS-TRAN-COMMENT-TEXT.       
           MOVE PARM-REVENUE-MONTH       TO WS-REVENUE-MONTH.           
           MOVE WS-REV-MONTH-NUM         TO WS-REV-MONTH-COMP.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
      * Check AR Lock-out status                                                
           PERFORM 7999-SELECT-AL        THRU 7999-SELECT-AL-EXIT.      
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 'GL00000007'          TO   S-BUS-RULE-ID             
              MOVE 0                     TO   S-RETURN-CODE             
              MOVE 'B'                   TO S-BUS-RULE-RESULT-CD        
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
      * Validate account                                                        
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO.              
           MOVE WS-ACCOUNT-NO-NUM        TO AT-ACCOUNT-NO.              
           MOVE 0                        TO AT-PREMISE-NO               
           IF AT-ACCOUNT-NO NOT = 9999999999998                         
              PERFORM 7200-VALIDATE-ACCOUNT THRU 7200-EXIT              
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'GL00000002'       TO S-BUS-RULE-ID               
                 MOVE 0                  TO S-RETURN-CODE               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
                 PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT             
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
                 PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 2200-PROCESS-JOURNAL  THRU 2200-EXIT.                
           MOVE ZERO                     TO S-RETURN-CODE.              
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           IF S-BUS-RULE-ID > SPACES                                    
              MOVE S-BUS-RULE-ID         TO 1R-BUS-RULE-ID              
              PERFORM 7000-GET-BUS-RULES THRU 7000-EXIT                 
              MOVE 1T-BUS-RULE-XREF-ID   TO S-BUS-RULE-XREF-ID          
           END-IF.                                                      
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-JOURNAL                                           *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-JOURNAL.                                            
      *                                                                         
           MOVE PARM-CASH-COMPANY-NO     TO WS-100-COMPANY-NO.          
           MOVE 9                        TO WS-TRAN-OPER-LEVEL.         
           MOVE 1                        TO WS-TRAN-OCAP-FIELD.         
           MOVE 1                        TO WS-TRAN-OCAP-VALUE.         
           MOVE WS-C                     TO WS-TRAN-JRNL-TYPE.          
           MOVE WS-N                     TO WS-TRAN-HOLD-EXEMPT-FLAG.   
           MOVE PARM-USER-ID             TO WS-JRNL-OL-TEMP-ID.         
           MOVE '4559'                   TO WS-100-CODE-TERMINAL-TRAN.  
           MOVE PARM-PANEL-NO            TO WS-PAR-APPL-PROG-ID.        
      * 'VO' - Check Operator Id                                                
           MOVE WS-JRNL-CK-OPER-ID       TO WS-JRNL-OPERATION-RQST.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                         THRU 6400-EXIT.                
      *                                                                         
           MOVE PARM-CASH-COMPANY-NO     TO WS-JRNL-OL-COMPANY.         
           MOVE PARM-CASH-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF          
                                            WS-JRNL-OL-REPORT-NO.       
           MOVE PARM-DATE-CASH-REPORT    TO WS-JRNL-OL-REPORT-DT.       
                                                                        
           EVALUATE PARM-CASH-LOCAL-OFFICE                              
               WHEN WS-001                                              
                  MOVE 9901              TO WS-JRNL-OL-CASH-DRWR        
                  MOVE WS-998            TO WS-JRNL-OL-REPORT-NO        
               WHEN WS-998                                              
                  MOVE 9999              TO WS-JRNL-OL-CASH-DRWR        
               WHEN OTHER                                               
                  PERFORM 2300-GET-CASH-DRWR THRU  2300-EXIT            
                  MOVE CS-CASH-DRAWER-ID TO WS-JRNL-OL-CASH-DRWR        
                  MOVE 1                 TO WS-JRNL-ENTRY-NO-HOLD       
           END-EVALUATE.                                                
                                                                        
           MOVE PARM-CSR-PC-ID           TO WS-JRNL-OL-CSR-PC-ID.       
           MOVE WS-JRNL-OL-OPR-LOC       TO WS-JRNL-OL-TERM-LOC         
                                            WS-JRNL-OL-CASH-LOC.        
           MOVE WS-C                     TO WS-JRNL-SOURCE-CODE.        
           MOVE WS-JRNL-CASH-UPDATE      TO WS-JRNL-OL-AUTH-TYPE.       
      * 'VH' - Validate Cash Drawer                                             
           MOVE WS-JRNL-VALIDATE-OPER    TO WS-JRNL-OPERATION-RQST.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                         THRU 6400-EXIT.                
      *                                                                         
           MOVE WS-A                     TO WS-100-JRNL-SORT-ID.        
           MOVE WS-ACCOUNT-NO-NUM        TO WS-100-ACCT-NO.             
           MOVE ZEROES                   TO WS-100-CUSTOMER-NO.         
           MOVE ZEROES                   TO WS-100-PREMISE-NO.          
           ADD  1                        TO WS-100-JRNL-TRAN-APPL-NO.   
           MOVE WS-CURRENT-DATE          TO WS-100-DATE-LAST-ACTION.    
           MOVE WS-C                     TO WS-100-CODE-ENTRY-SOURCE.   
           MOVE PARM-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD.     
           MOVE WS-JRNL-OL-COMPANY       TO WS-PAR-COMPANY-NO.          
           MOVE WS-JRNL-OL-LOC-OFF       TO WS-PAR-LOCAL-OFFICE.        
           MOVE WS-JRNL-OL-REPORT-NO     TO WS-PAR-REPORT-NO.           
           MOVE WS-JRNL-OL-REPORT-DT     TO WS-PAR-REPORT-DATE.         
           MOVE WS-JRNL-OL-CASH-DRWR     TO WS-PAR-CASH-DRAWER.         
           MOVE WS-TERM-LOC              TO WS-PAR-ACCESS-LOC.          
           MOVE PARM-USER-ID             TO WS-PAR-OPERATOR-ID.         
           MOVE PF-RESP-AREA-ID          TO WS-PAR-RESP-AREA.           
           MOVE WS-TRAN-COMMENT-LEN      TO WS-JRNL-TRAN-COMMENT-LEN.   
           MOVE WS-TRAN-COMMENT-TEXT     TO WS-JRNL-TRAN-COMMENT-TEXT.  
                                                                        
           PERFORM 2210-MOVE-TRAN-DATA-VALUES THRU 2210-EXIT.           
                                                                        
           MOVE WS-DEBIT-GL-ACCT         TO WS-101-ACCT-GEN-LED-DR.     
           MOVE WS-CR-GL-ACCT            TO WS-101-ACCT-GEN-LED-CR.     
           MOVE WS-A                     TO WS-JRNL-CURRENCY-TYPE.      
           MOVE WS-AMOUNT                TO WS-101-AMT-POSTED.          
           MOVE CJF00101                 TO WS-100-USER-DEFINED-AREA.   
      * 'JH' - Write Journals                                                   
           MOVE WS-JRNL-ONLY             TO WS-JRNL-OPERATION-RQST.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                         THRU 6400-EXIT.                
           IF WS-JRNL-RTRN-CODE NOT = SPACES                            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'USERABEN'            TO ABEND-FUNCTION              
              MOVE WS-Y                  TO WS-USER-FORCE-ABEND         
              MOVE 'JOURNAL ABEND'       TO DSNTIAR-MESSAGE-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      * 'JM' - Update Controls                                                  
           MOVE WS-JRNL-CNTRL-ONLY       TO WS-JRNL-OPERATION-RQST.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE                             
                                         THRU 6400-EXIT.                
           IF WS-JRNL-RTRN-CODE NOT = SPACES                            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'USERABEN'            TO ABEND-FUNCTION              
              MOVE WS-Y                  TO WS-USER-FORCE-ABEND         
              MOVE 'JOURNAL ABEND'       TO DSNTIAR-MESSAGE-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-MOVE-TRAN-DATA-VALUES                                     *        
      ******************************************************************        
      *                                                                         
       2210-MOVE-TRAN-DATA-VALUES.                                      
      *                                                                         
           INITIALIZE CJF00101                                          
                                                                        
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO        
           MOVE WS-AMOUNT               TO WS-101-AMOUNT-ENTERED        
                                                                        
           MOVE SPACES                  TO WS-101-AR-AGE                
                                           WS-101-FCS-ACCT-NO           
                                           WS-101-CASH-DRAWER-USED      
                                           WS-101-DATE-AR-BILLED        
                                           WS-101-FCS-DEP-BANK-CD       
                                           WS-101-FCS-DEP-BANK-ST-CD    
                                           WS-101-FUNCTION-CODE         
                                           WS-101-CODE-REVENUE-DISTRICT 
                                           WS-101-CODE-EMPL-ACCT        
                                           WS-101-CODE-COMPANY-ACCT     
                                           WS-101-CODE-ACCOUNT-STATUS   
                                           WS-101-CODE-PREMISE-STATUS   
           MOVE ZERO                    TO WS-101-ITEM-DETAIL-DATA      
                                           WS-101-ITEM-ID-NO            
                                           WS-101-DETAIL-END-BAL        
                                           WS-101-DETAIL-END-AR-BAL     
                                           WS-101-ACCT-END-AR-BAL.      
           MOVE WS-REV-MONTH-COMP       TO WS-101-REVENUE-MONTH.        
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-GET-CASH-DRWR                                             *        
      ******************************************************************        
      *                                                                         
       2300-GET-CASH-DRWR.                                              
      *                                                                         
           MOVE PARM-CASH-COMPANY-NO    TO CS-CASH-COMPANY-NO           
                                           YR-CASH-COMPANY-NO           
                                           Y2-CASH-COMPANY-NO           
           MOVE PARM-CASH-LOCAL-OFFICE  TO CS-CASH-LOCAL-OFFICE         
                                           CS-CASH-REPORT-NO            
                                           YR-CASH-LOCAL-OFFICE         
                                           Y2-CASH-LOCAL-OFFICE         
           MOVE PARM-DATE-CASH-REPORT   TO CS-DATE-CASH-REPORT          
                                           CS-DATE-LAST-ACTIVITY        
                                           YR-DATE-CASH-REPORT          
           MOVE PARM-USER-ID            TO CS-USER-ID,                  
           MOVE WS-N                    TO CS-CODE-FCS-EXTRACTED        
           MOVE WS-C                    TO CS-CODE-CSH-DRWR-STAT.       
           MOVE SPACES                  TO CS-CASHIER-CODE              
                                           CS-CODE-PYMT-FACILITY.       
           INITIALIZE CS-CASH-DRAWER-ID.                                
           PERFORM 7300-SELECT-CASH-DRAWERID THRU 7300-EXIT.            
           IF CS-CASH-DRAWER-ID = ZERO                                  
              PERFORM 7600-SELECT-CASH-RPT   THRU 7600-EXIT             
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT287           MOVE 'SYSTEM'          TO YR-USER-ID                   
                 MOVE WS-A              TO YR-STATUS                    
                 PERFORM 7650-CREATE-CASH-RPT THRU 7650-EXIT            
              END-IF                                                    
           END-IF                                                       
                                                                        
           ADD  1                       TO CS-CASH-DRAWER-ID.           
                                                                        
           MOVE ZERO                    TO CS-AMT-BASIC-WORK,           
                                           CS-AMT-CASH-BEGIN-BAL        
           INITIALIZE  CS-AMT-CASH-DEBIT,                               
                       CS-AMT-CASH-CREDIT,                              
                       CS-AMT-AR-DEBIT,                                 
                       CS-AMT-AR-CREDIT,                                
                       CS-AMT-CK-ISS-DEBIT,                             
                       CS-AMT-CK-ISS-CREDIT,                            
                       CS-AMT-GL-DEBIT,                                 
                       CS-AMT-GL-CREDIT,                                
                       CS-NO-ITEMS-ENTERED.                             
           PERFORM 7500-INSERT-CASHDRWR THRU 7500-EXIT.                 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6400-ONLINE-JRNL-ROUTINE                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-BUS-RULES                                             *        
      ******************************************************************        
      *                                                                         
       7000-GET-BUS-RULES.                                              
      *                                                                         
           MOVE '7000'                         TO ACTIVE-PARAGRAPH.     
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                
                  INTO                                                  
                     :1T-BUS-RULE-XREF-ID                               
                  FROM                                                  
                     CSS_BUS_RULE      [1R] WITH(READUNCOMMITTED)               
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
                 WHERE                                                  
                      [1R].BUS_RULE_ID = :1R-BUS-RULE-ID                  
                  AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                   
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              1T.BUS_RULE_XREF_ID                                        
MFA-TR*           INTO                                                          
MFA-TR*              :1T-BUS-RULE-XREF-ID                                       
MFA-TR*           FROM                                                          
MFA-TR*              CSS_BUS_RULE      1R                                       
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*          WHERE                                                          
MFA-TR*               1R.BUS_RULE_ID = :1R-BUS-RULE-ID                          
MFA-TR*           AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                           
MFA-TR*         WITH  UR                                                        
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_BUS_RULE'             TO TABLE-1               
               MOVE 'CSS_BUS_RULE_XREF'        TO TABLE-2               
               MOVE 'CSS_BUS_RULE_ACTN'        TO TABLE-3               
               MOVE 'BUS_RULE_ID'              TO TABLE-ELEMENT-1       
               MOVE 1R-BUS-RULE-ID             TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-CURRENT-DT                                            *        
      ******************************************************************        
      *                                                                         
       7100-GET-CURRENT-DT.                                             
      *                                                                         
           MOVE '7100'                         TO ACTIVE-PARAGRAPH.     
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SET'                      TO ABEND-FUNCTION        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-VALIDATE-ACCOUNT                                          *        
      ******************************************************************        
      *                                                                         
       7200-VALIDATE-ACCOUNT.                                           
      *                                                                         
           MOVE '7200'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                      ACCOUNT_NO                                        
                     ,PREMISE_NO                                        
                 INTO                                                   
                      :AT-ACCOUNT-NO                                    
                     ,:AT-PREMISE-NO                                    
                 FROM                                                   
                      CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE                                                   
                      ACCOUNT_NO       = :AT-ACCOUNT-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*               ACCOUNT_NO                                                
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*          INTO                                                           
MFA-TR*               :AT-ACCOUNT-NO                                            
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*          FROM                                                           
MFA-TR*               CSS_ACCOUNT                                               
MFA-TR*         WHERE                                                           
MFA-TR*               ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE                               
                                        TO S-RETURN-CODE                
               MOVE SPACES              TO ABEND-TABLES                 
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE 'CSS_ACCOUNT'       TO TABLE-1                      
               MOVE 'ACCOUNT NO'        TO TABLE-ELEMENT-1              
               MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-SELECT-CASH-DRAWERID                                      *        
      ******************************************************************        
      *                                                                         
       7300-SELECT-CASH-DRAWERID.                                       
      *                                                                         
           MOVE '7300'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       MAX(CASH_DRAWER_ID)                              
                  INTO                                                  
                       :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1            
                  FROM                                                  
                       CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                  
                 WHERE                                                  
                       CASH_COMPANY_NO  = :CS-CASH-COMPANY-NO           
                   AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE        
                   AND DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                MAX(CASH_DRAWER_ID)                                      
MFA-TR*           INTO                                                          
MFA-TR*                :CS-CASH-DRAWER-ID:WS-NULL-INDICATOR1                    
MFA-TR*           FROM                                                          
MFA-TR*                CSS_CSH_DRWR_CNTL                                        
MFA-TR*          WHERE                                                          
MFA-TR*                CASH_COMPANY_NO  = :CS-CASH-COMPANY-NO                   
MFA-TR*            AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                
MFA-TR*            AND DATE_CASH_REPORT = :CS-DATE-CASH-REPORT                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  WS-NULL-INDICATOR1 < ZERO                            
                   MOVE 0               TO CS-CASH-DRAWER-ID            
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE                               
                                        TO S-RETURN-CODE                
               MOVE SPACES              TO ABEND-TABLES                 
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE 'CSS_CSH_DRWR_CNTL' TO TABLE-1                      
               MOVE 'CASH_COMPANY_NO'   TO TABLE-ELEMENT-1              
               MOVE 'CASH_LOCAL_OFFICE' TO TABLE-ELEMENT-2              
               MOVE 'DATE_CASH_REPORT'  TO TABLE-ELEMENT-3              
               MOVE CS-CASH-COMPANY-NO  TO HOSTVAR-ELEMENT-1            
               MOVE CS-CASH-LOCAL-OFFICE                                
                                        TO HOSTVAR-ELEMENT-2            
               MOVE CS-DATE-CASH-REPORT TO HOSTVAR-ELEMENT-3            
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-SELECT-CASH-DRAWERID                                      *        
      * INSERT NEW BATCH INTO CASH DRAWER CNTL.                        *        
      ******************************************************************        
      *                                                                         
       7500-INSERT-CASHDRWR.                                            
      *                                                                         
           MOVE '7500'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL(                             
                         CASH_COMPANY_NO,                               
                         CASH_LOCAL_OFFICE,                             
                         CASH_REPORT_NO,                                
                         DATE_CASH_REPORT,                              
                         CASH_DRAWER_ID,                                
                         AMT_CASH_DEBIT,                                
                         AMT_CASH_CREDIT,                               
                         AMT_AR_DEBIT,                                  
                         AMT_AR_CREDIT,                                 
                         AMT_CK_ISS_DEBIT,                              
                         AMT_CK_ISS_CREDIT,                             
                         AMT_GL_DEBIT,                                  
                         AMT_GL_CREDIT,                                 
                         AMT_CASH_BEGIN_BAL,                            
                         AMT_BASIC_WORK,                                
                         USER_ID,                                       
                         CASHIER_CODE,                                  
                         CODE_PYMT_FACILITY,                            
                         CODE_FCS_EXTRACTED,                            
                         CODE_CSH_DRWR_STAT,                            
                         DATE_LAST_ACTIVITY,                            
                         NO_ITEMS_ENTERED,                              
                         BALANCED_TS,                                   
                         BALANCED_BY)                                   
             VALUES(                                                    
                         :CS-CASH-COMPANY-NO,                           
                         :CS-CASH-LOCAL-OFFICE,                         
                         :CS-CASH-REPORT-NO,                            
                         IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                         :CS-CASH-DRAWER-ID,                            
                         :CS-AMT-CASH-DEBIT,                            
                         :CS-AMT-CASH-CREDIT,                           
                         :CS-AMT-AR-DEBIT,                              
                         :CS-AMT-AR-CREDIT,                             
                         :CS-AMT-CK-ISS-DEBIT,                          
                         :CS-AMT-CK-ISS-CREDIT,                         
                         :CS-AMT-GL-DEBIT,                              
                         :CS-AMT-GL-CREDIT,                             
                         :CS-AMT-CASH-BEGIN-BAL,                        
                         :CS-AMT-BASIC-WORK,                            
                         :CS-USER-ID,                                   
                         :CS-CASHIER-CODE,                              
                         :CS-CODE-PYMT-FACILITY,                        
                         :CS-CODE-FCS-EXTRACTED,                        
                         :CS-CODE-CSH-DRWR-STAT,                        
                         IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                         :CS-NO-ITEMS-ENTERED,                          
                         CIS.CURRENT$TIMESTAMP(),                             
                         :CS-USER-ID)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL(                                     
MFA-TR*                  CASH_COMPANY_NO,                                       
MFA-TR*                  CASH_LOCAL_OFFICE,                                     
MFA-TR*                  CASH_REPORT_NO,                                        
MFA-TR*                  DATE_CASH_REPORT,                                      
MFA-TR*                  CASH_DRAWER_ID,                                        
MFA-TR*                  AMT_CASH_DEBIT,                                        
MFA-TR*                  AMT_CASH_CREDIT,                                       
MFA-TR*                  AMT_AR_DEBIT,                                          
MFA-TR*                  AMT_AR_CREDIT,                                         
MFA-TR*                  AMT_CK_ISS_DEBIT,                                      
MFA-TR*                  AMT_CK_ISS_CREDIT,                                     
MFA-TR*                  AMT_GL_DEBIT,                                          
MFA-TR*                  AMT_GL_CREDIT,                                         
MFA-TR*                  AMT_CASH_BEGIN_BAL,                                    
MFA-TR*                  AMT_BASIC_WORK,                                        
MFA-TR*                  USER_ID,                                               
MFA-TR*                  CASHIER_CODE,                                          
MFA-TR*                  CODE_PYMT_FACILITY,                                    
MFA-TR*                  CODE_FCS_EXTRACTED,                                    
MFA-TR*                  CODE_CSH_DRWR_STAT,                                    
MFA-TR*                  DATE_LAST_ACTIVITY,                                    
MFA-TR*                  NO_ITEMS_ENTERED,                                      
MFA-TR*                  BALANCED_TS,                                           
MFA-TR*                  BALANCED_BY)                                           
MFA-TR*      VALUES(                                                            
MFA-TR*                  :CS-CASH-COMPANY-NO,                                   
MFA-TR*                  :CS-CASH-LOCAL-OFFICE,                                 
MFA-TR*                  :CS-CASH-REPORT-NO,                                    
MFA-TR*                  :CS-DATE-CASH-REPORT,                                  
MFA-TR*                  :CS-CASH-DRAWER-ID,                                    
MFA-TR*                  :CS-AMT-CASH-DEBIT,                                    
MFA-TR*                  :CS-AMT-CASH-CREDIT,                                   
MFA-TR*                  :CS-AMT-AR-DEBIT,                                      
MFA-TR*                  :CS-AMT-AR-CREDIT,                                     
MFA-TR*                  :CS-AMT-CK-ISS-DEBIT,                                  
MFA-TR*                  :CS-AMT-CK-ISS-CREDIT,                                 
MFA-TR*                  :CS-AMT-GL-DEBIT,                                      
MFA-TR*                  :CS-AMT-GL-CREDIT,                                     
MFA-TR*                  :CS-AMT-CASH-BEGIN-BAL,                                
MFA-TR*                  :CS-AMT-BASIC-WORK,                                    
MFA-TR*                  :CS-USER-ID,                                           
MFA-TR*                  :CS-CASHIER-CODE,                                      
MFA-TR*                  :CS-CODE-PYMT-FACILITY,                                
MFA-TR*                  :CS-CODE-FCS-EXTRACTED,                                
MFA-TR*                  :CS-CODE-CSH-DRWR-STAT,                                
MFA-TR*                  :CS-DATE-LAST-ACTIVITY,                                
MFA-TR*                  :CS-NO-ITEMS-ENTERED,                                  
MFA-TR*                  CURRENT TIMESTAMP,                                     
MFA-TR*                  :CS-USER-ID)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE                               
                                        TO S-RETURN-CODE                
               MOVE SPACES              TO ABEND-TABLES                 
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE 'INSERT'            TO ABEND-FUNCTION               
               MOVE 'CSS_CSH_DRWR_CNTL' TO TABLE-1                      
               MOVE 'CASH_COMPANY_NO'   TO TABLE-ELEMENT-1              
               MOVE 'CASH_LOCAL_OFFICE' TO TABLE-ELEMENT-2              
               MOVE 'CASH_DRAWER_ID'    TO TABLE-ELEMENT-3              
               MOVE 'DATE_CASH_REPORT'  TO TABLE-ELEMENT-4              
               MOVE CS-CASH-COMPANY-NO  TO HOSTVAR-ELEMENT-1            
               MOVE CS-CASH-LOCAL-OFFICE                                
                                        TO HOSTVAR-ELEMENT-2            
               MOVE CS-CASH-DRAWER-ID   TO HOSTVAR-ELEMENT-3            
               MOVE CS-DATE-CASH-REPORT TO HOSTVAR-ELEMENT-4            
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-SELECT-CASH-RPT                                           *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-CASH-RPT.                                            
      *                                                                         
           MOVE '7600'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             SELECT USER_ID                                             
               INTO :YR-USER-ID                                         
               FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7325'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7650-CREATE-CASH-RPT                                           *        
      ******************************************************************        
      *                                                                         
       7650-CREATE-CASH-RPT.                                            
      *                                                                         
           MOVE '7650'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      USER_ID,                                          
                      STATUS,                                           
                      CLOSED_TS)                                        
             VALUES ( :YR-CASH-COMPANY-NO                               
                      ,:YR-CASH-LOCAL-OFFICE                            
                      ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                      ,:YR-USER-ID                                      
                      ,:YR-STATUS                                       
                      ,CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               STATUS,                                                   
MFA-TR*               CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*               ,:YR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:YR-DATE-CASH-REPORT                                     
MFA-TR*               ,:YR-USER-ID                                              
MFA-TR*               ,:YR-STATUS                                               
MFA-TR*               ,CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7650'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
              MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
              MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-LOCAL-OFFICE                                          *        
      ******************************************************************        
      *                                                                         
       7700-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT LOCAL_OFFICE                                     
                  INTO :Y2-LOCAL-OFFICE                                 
                  FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                 
                 WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LOCAL_OFFICE                                             
MFA-TR*           INTO :Y2-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_CASHIER_OFFICE                                       
MFA-TR*          WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE Y2-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-GET-REV-DISTRICT                                          *        
      ******************************************************************        
      *                                                                         
       7800-GET-REV-DISTRICT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       PR.REV_DISTRICT_CD                               
                  INTO                                                  
                       :PR-REV-DISTRICT-CD                              
                  FROM                                                  
                       CSS_PREMISE PR WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       PR.PREMISE_NO   = :PR-PREMISE-NO                 
                                                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                PR.REV_DISTRICT_CD                                       
MFA-TR*           INTO                                                          
MFA-TR*                :PR-REV-DISTRICT-CD                                      
MFA-TR*           FROM                                                          
MFA-TR*                CSS_PREMISE PR                                           
MFA-TR*          WHERE                                                          
MFA-TR*                PR.PREMISE_NO   = :PR-PREMISE-NO                         
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7800'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_PREMISE'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2       
               MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7999-SELECT-AL                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00075                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
             ADD 1 TO CTR-ROWS.                                         
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
