       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04557.                                        
       AUTHOR.         HA7A338.                                         
COB303 DATE-WRITTEN.   AUGUST 22, 2012.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000200
      ******************************************************************00000600
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  TO RETRIEVE GL_INTRFCE_ACCT DETAILS FROM GL_INTRFCE TABLES    *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             NONE                                               *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  ------------------                                            *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             GL_INTRFCE_ACCT_NO         DECIMAL(7,4)            *        
      *             RESOURCE_CD                CHAR(03)                *        
      *             ACTIVITY_CD                CHAR(04)                *        
      *             COMPANY_IND                CHAR(02)                *        
      *             BUSINESS_UNIT              CHAR(05)                *        
      *             CUSTOMER_CD                CHAR(03)                *        
      *             COST_CENTER                CHAR(04)                *        
      *             COST_CENTER_IND            CHAR(01)                *        
      *             OPERATING_UNIT             CHAR(04)                *        
      *             GL_ACCT_NO                 DECIMAL(7,4)            *        
      *             ALLOCATION_PCT             SMALLINT                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS    COMMENTS                                *        
      *  --------  --------    ----------------------------            *        
      *  08/22/12   HA7A338    NEW PROGRAM                             *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04557'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04557 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GL_INTRFCE     2J                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GL_INTRFCE_SEQ 2N                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINSQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04557'.      
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 GTT-NAME                 PIC X(26)                        
                                            VALUE 'SESSION.CSR04557_R1'.
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  MISC-FIELD.                                                  
      *    05  WS-APPL-PROG-ID         PIC X(03) VALUE SPACES.                  
      *    05  WS-USER-ID              PIC X(07) VALUE SPACES.                  
           05  WS-NULL-IND-01          PIC S9(4) COMP VALUE 0.          
           05  WS-NULL-IND-02          PIC S9(4) COMP VALUE 0.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-GL-INTRFCE-ACCT-NO    PIC S9(3)V9(4) USAGE             
                                               COMP-3 VALUE 0.          
           05  S-RESOURCE-CD           PIC X(03) VALUE SPACES.          
           05  S-ACTIVITY-CD           PIC X(04) VALUE SPACES.          
           05  S-COMPANY-IND           PIC X(02) VALUE SPACES.          
           05  S-BUSINESS-UNIT         PIC X(05) VALUE SPACES.          
           05  S-CUSTOMER-CD           PIC X(03) VALUE SPACES.          
           05  S-COST-CENTER           PIC X(04) VALUE SPACES.          
           05  S-COST-CENTER-IND       PIC X(01) VALUE SPACES.          
           05  S-OPERATING-UNIT        PIC X(04) VALUE SPACES.          
           05  S-GL-ACCT-NO            PIC S9(3)V9(4) USAGE             
                                               COMP-3 VALUE 0.          
           05  S-ALLOCATION-PCT        PIC S9(4) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    CURSOR TO FETCH GL_INTRFCE_ACCT DETAILS FROM GL_INTRFCE TBLS*        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE GL_INTRFCE_CUR CURSOR FOR                        
                SELECT  T2J.GL_INTRFCE_ACCT_NO                          
                       ,T2J.RESOURCE_CD                                 
                       ,T2J.ACTIVITY_CD                                 
                       ,T2J.COMPANY_IND                                 
                       ,T2J.BUSINESS_UNIT                               
                       ,T2J.CUSTOMER_CD                                 
                       ,T2J.COST_CENTER                                 
                       ,T2J.COST_CENTER_IND                             
                       ,T2J.OPERATING_UNIT                              
                       ,T2N.GL_ACCT_NO                                  
                       ,T2N.ALLOCATION_PCT                              
                  FROM  CSS_GL_INTRFCE     T2J WITH(READUNCOMMITTED)            
                  LEFT  OUTER JOIN                                      
                        CSS_GL_INTRFCE_SEQ T2N WITH(READUNCOMMITTED)            
                  ON    T2N.GL_INTRFCE_SEQ_NO  = T2J.GL_INTRFCE_SEQ_NO  
                  ORDER BY                                              
                        T2J.GL_INTRFCE_ACCT_NO                          
                       ,T2J.GL_INTRFCE_SEQ_NO                           
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GL_INTRFCE_CUR CURSOR FOR                                
MFA-TR*         SELECT  T2J.GL_INTRFCE_ACCT_NO                                  
MFA-TR*                ,T2J.RESOURCE_CD                                         
MFA-TR*                ,T2J.ACTIVITY_CD                                         
MFA-TR*                ,T2J.COMPANY_IND                                         
MFA-TR*                ,T2J.BUSINESS_UNIT                                       
MFA-TR*                ,T2J.CUSTOMER_CD                                         
MFA-TR*                ,T2J.COST_CENTER                                         
MFA-TR*                ,T2J.COST_CENTER_IND                                     
MFA-TR*                ,T2J.OPERATING_UNIT                                      
MFA-TR*                ,T2N.GL_ACCT_NO                                          
MFA-TR*                ,T2N.ALLOCATION_PCT                                      
MFA-TR*           FROM  CSS_GL_INTRFCE     T2J                                  
MFA-TR*           LEFT  OUTER JOIN                                              
MFA-TR*                 CSS_GL_INTRFCE_SEQ T2N                                  
MFA-TR*           ON    T2N.GL_INTRFCE_SEQ_NO  = T2J.GL_INTRFCE_SEQ_NO          
MFA-TR*           ORDER BY                                                      
MFA-TR*                 T2J.GL_INTRFCE_ACCT_NO                                  
MFA-TR*                ,T2J.GL_INTRFCE_SEQ_NO                                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
      *01  PARM-APPL-PROG-ID        PIC X(03).                                  
      *01  PARM-USER-ID             PIC X(07).                                  
                                                                        
       PROCEDURE DIVISION.                                              
      *PROCEDURE DIVISION  USING PARM-APPL-PROG-ID                              
      *                        , PARM-USER-ID.                                  
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
      *    PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                          
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04557_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04557_R1
              (                                                        
                 RETURN_CODE                INT                     
                ,APPL_RETURN_CODE           INT                     
                ,GL_INTRFCE_ACCT_NO         DECIMAL(7,4)                
                ,RESOURCE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,ACTIVITY_CD CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,COMPANY_IND CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,BUSINESS_UNIT CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,CUSTOMER_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,COST_CENTER CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,COST_CENTER_IND CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,OPERATING_UNIT CHAR(04)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,GL_ACCT_NO                 DECIMAL(7,4)                
                ,ALLOCATION_PCT             SMALLINT                    
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE              AS RETURN_CODE           
                     ,APPL_RETURN_CODE         AS APPL_RETURN_CODE      
                     ,GL_INTRFCE_ACCT_NO       AS GL_INTRFCE_ACCT_NO    
                     ,LTRIM(RTRIM(RESOURCE_CD))       AS RESOURCE_CD           
                     ,LTRIM(RTRIM(ACTIVITY_CD))       AS ACTIVITY_CD           
                     ,LTRIM(RTRIM(COMPANY_IND))       AS COMPANY_IND           
                     ,LTRIM(RTRIM(BUSINESS_UNIT))     AS BUSINESS_UNIT         
                     ,LTRIM(RTRIM(CUSTOMER_CD))       AS CUSTOMER_CD           
                     ,LTRIM(RTRIM(COST_CENTER))       AS COST_CENTER           
                     ,LTRIM(RTRIM(COST_CENTER_IND))   AS COST_CENTER_IND       
                     ,LTRIM(RTRIM(OPERATING_UNIT))    AS OPERATING_UNIT        
                     ,GL_ACCT_NO               AS GL_ACCT_NO            
                     ,ALLOCATION_PCT           AS ALLOCATION_PCT        
               FROM #CSR04557_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT RETURN_CODE              AS RETURN_CODE           00000400
MFA-TR*              ,APPL_RETURN_CODE         AS APPL_RETURN_CODE              
MFA-TR*              ,GL_INTRFCE_ACCT_NO       AS GL_INTRFCE_ACCT_NO            
MFA-TR*              ,STRIP(RESOURCE_CD)       AS RESOURCE_CD                   
MFA-TR*              ,STRIP(ACTIVITY_CD)       AS ACTIVITY_CD                   
MFA-TR*              ,STRIP(COMPANY_IND)       AS COMPANY_IND                000
MFA-TR*              ,STRIP(BUSINESS_UNIT)     AS BUSINESS_UNIT              000
MFA-TR*              ,STRIP(CUSTOMER_CD)       AS CUSTOMER_CD                000
MFA-TR*              ,STRIP(COST_CENTER)       AS COST_CENTER                000
MFA-TR*              ,STRIP(COST_CENTER_IND)   AS COST_CENTER_IND            000
MFA-TR*              ,STRIP(OPERATING_UNIT)    AS OPERATING_UNIT             000
MFA-TR*              ,GL_ACCT_NO               AS GL_ACCT_NO                 000
MFA-TR*              ,ALLOCATION_PCT           AS ALLOCATION_PCT             000
MFA-TR*        FROM SESSION.CSR04557_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *1000-PROCESS-INPUT.                                                      
      *                                                                         
      *    MOVE PARM-APPL-PROG-ID     TO WS-APPL-PROG-ID.                       
      *    MOVE PARM-USER-ID          TO WS-USER-ID.                            
      *                                                                         
      *1000-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-NO                        TO WS-NO-MORE-ROWS.        
                                                                        
           PERFORM 7100-OPEN-GL-INTRFCE-CUR   THRU 7100-EXIT            
           PERFORM 7200-FETCH-GL-INTRFCE-CUR  THRU 7200-EXIT            
           PERFORM 2100-GL-INTRFCE-PROCESS    THRU 2100-EXIT            
             UNTIL NO-MORE-ROWS                                         
           PERFORM 7300-CLOSE-GL-INTRFCE-CUR  THRU 7300-EXIT            
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                       TO S-RETURN-CODE           
              MOVE   0                       TO S-APPL-RETURN-CODE      
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-GL-INTRFCE-PROCESS.                                 *              
      ******************************************************************        
       2100-GL-INTRFCE-PROCESS.                                         
                                                                        
           MOVE 2J-GL-INTRFCE-ACCT-NO        TO S-GL-INTRFCE-ACCT-NO.   
           MOVE 2J-RESOURCE-CD               TO S-RESOURCE-CD.          
           MOVE 2J-ACTIVITY-CD               TO S-ACTIVITY-CD.          
           MOVE 2J-COMPANY-IND               TO S-COMPANY-IND.          
           MOVE 2J-BUSINESS-UNIT             TO S-BUSINESS-UNIT.        
           MOVE 2J-CUSTOMER-CD               TO S-CUSTOMER-CD.          
           MOVE 2J-COST-CENTER               TO S-COST-CENTER.          
           MOVE 2J-COST-CENTER-IND           TO S-COST-CENTER-IND.      
           MOVE 2J-OPERATING-UNIT            TO S-OPERATING-UNIT.       
                                                                        
           IF WS-NULL-IND-01 < 0                                        
              MOVE ZEROES                    TO S-GL-ACCT-NO            
           ELSE                                                         
              MOVE 2N-GL-ACCT-NO             TO S-GL-ACCT-NO            
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND-02 < 0                                        
              MOVE ZEROES                    TO S-ALLOCATION-PCT        
           ELSE                                                         
              MOVE 2N-ALLOCATION-PCT         TO S-ALLOCATION-PCT        
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
           PERFORM 7200-FETCH-GL-INTRFCE-CUR  THRU 7200-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GL-INTRFCE-CUR.                                           *        
      ******************************************************************        
       7100-OPEN-GL-INTRFCE-CUR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN GL_INTRFCE_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_GL_INTRFCE'          TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-FETCH-GL-INTRFCE-CUR.                                     *        
      ******************************************************************        
       7200-FETCH-GL-INTRFCE-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH GL_INTRFCE_CUR                                      
               INTO :2J-GL-INTRFCE-ACCT-NO                              
                   ,:2J-RESOURCE-CD                                     
                   ,:2J-ACTIVITY-CD                                     
                   ,:2J-COMPANY-IND                                     
                   ,:2J-BUSINESS-UNIT                                   
                   ,:2J-CUSTOMER-CD                                     
                   ,:2J-COST-CENTER                                     
                   ,:2J-COST-CENTER-IND                                 
                   ,:2J-OPERATING-UNIT                                  
                   ,:2N-GL-ACCT-NO :WS-NULL-IND-01                       
                   ,:2N-ALLOCATION-PCT :WS-NULL-IND-02                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES              TO WS-NO-MORE-ROWS         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7200'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE 'CSS_GL_INTRFCE'    TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-CLOSE-GL-INTRFCE-CUR.                                     *        
      ******************************************************************        
       7300-CLOSE-GL-INTRFCE-CUR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE GL_INTRFCE_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_GL_INTRFCE'          TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04557_R1                           
                (                                                       
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,GL_INTRFCE_ACCT_NO                                   
                  ,RESOURCE_CD                                          
                  ,ACTIVITY_CD                                          
                  ,COMPANY_IND                                          
                  ,BUSINESS_UNIT                                        
                  ,CUSTOMER_CD                                          
                  ,COST_CENTER                                          
                  ,COST_CENTER_IND                                      
                  ,OPERATING_UNIT                                       
                  ,GL_ACCT_NO                                           
                  ,ALLOCATION_PCT                                       
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-GL-INTRFCE-ACCT-NO                                
                  ,:S-RESOURCE-CD                                       
                  ,:S-ACTIVITY-CD                                       
                  ,:S-COMPANY-IND                                       
                  ,:S-BUSINESS-UNIT                                     
                  ,:S-CUSTOMER-CD                                       
                  ,:S-COST-CENTER                                       
                  ,:S-COST-CENTER-IND                                   
                  ,:S-OPERATING-UNIT                                    
                  ,:S-GL-ACCT-NO                                        
                  ,:S-ALLOCATION-PCT                                    
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04557_R1                                   
MFA-TR*         (                                                               
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,GL_INTRFCE_ACCT_NO                                           
MFA-TR*           ,RESOURCE_CD                                                  
MFA-TR*           ,ACTIVITY_CD                                                  
MFA-TR*           ,COMPANY_IND                                                  
MFA-TR*           ,BUSINESS_UNIT                                                
MFA-TR*           ,CUSTOMER_CD                                                  
MFA-TR*           ,COST_CENTER                                                  
MFA-TR*           ,COST_CENTER_IND                                              
MFA-TR*           ,OPERATING_UNIT                                               
MFA-TR*           ,GL_ACCT_NO                                                   
MFA-TR*           ,ALLOCATION_PCT                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-GL-INTRFCE-ACCT-NO                                        
MFA-TR*           ,:S-RESOURCE-CD                                               
MFA-TR*           ,:S-ACTIVITY-CD                                               
MFA-TR*           ,:S-COMPANY-IND                                               
MFA-TR*           ,:S-BUSINESS-UNIT                                             
MFA-TR*           ,:S-CUSTOMER-CD                                               
MFA-TR*           ,:S-COST-CENTER                                               
MFA-TR*           ,:S-COST-CENTER-IND                                           
MFA-TR*           ,:S-OPERATING-UNIT                                            
MFA-TR*           ,:S-GL-ACCT-NO                                                
MFA-TR*           ,:S-ALLOCATION-PCT                                            
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                         TO  CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8100'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04557_R1'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04557_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04557_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04557_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
                                                                        
