       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04556.                                         
       DATE-WRITTEN.  08/09/2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : UPDGLACCOUNTBUSINESSOP                            *        
      *  INPUT     : GL_ACCT_NO               CSS_GL_ACCT_NO           *        
      *              GO_ACTION_CD                                      *        
      *              GL_ACCT_NAME                                      *        
      *              CODE_UTIL_TYPE                                    *        
      *              GL_ACCT_TYPE                                      *        
      *              GL_ACCT_CLASS                                     *        
      *              ACCT_BALANCE_HI                                   *        
      *              ACCT_BALANCE_LO                                   *        
      *              MONITOR_FL                                        *        
      *              EXTERNAL_DISPLAY_FL                               *        
      *              GL_ACCT_NAME_DESC                                 *        
      *              WRITE_OFF_FL                                      *        
      *              GL_INTRFCE_ID                                     *        
      *              GL_ACTION_CD                                      *        
      *              LOCAL_OFFICE                                      *        
      *              CODE_ACCT_STATUS                                  *        
      *              2Q_STRING                                         *        
      *                                                                *        
      *--      OUT                                                   --*        
      *--           RETURN_CODE             INTEGER                  --*        
      *--           APPLICATION_CODE        INTEGER                  --*        
      *--                                                            --*        
      *--      INOUT                                                 --*        
      *--                                                            --*        
      *--           NONE                                             --*        
      *--                                                            --*        
      *--  RESULT SET                                                --*        
      *--                                                            --*        
      *--           NONE                                             --*        
      *--                                                            --*        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      * UPDATE/INSERT/DELETE GL FROM CSS_GL_ACCOUNT, CSS_GL_ACCT,      *        
      * CSS_GL_CNTL_REF and CSS_GL_INTRFCE_SEQ.                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  06/2012   RAJ        INITIAL VERSION.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04556'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4551 STARTS HERE'.                  
                                                                        
                                                                        
       01  WORK-FIELDS.                                                 
           05  HAS-ACCESS-FL           PIC X(01) VALUE 'N'.             
           05  PROGRAM-NAME            PIC X(08)      VALUE 'CSR04556'. 
COB305     05 WS-MISC-INDX        PIC S9(05) COMP-3 VALUE 0.              
           05  WS-NO-MORE-LOC-OFF      PIC X(01) VALUE 'N'.             
               88  NO-MORE-LOC-OFF               VALUE 'Y'.             
           05  WS-PARM-GL-ACCT-NO.                                      
               10  PARM-GL-ACCT-NO-VAL      PIC X(8).                   
           05  WS-DECIMAL-3V4-NUM      PIC S9(7).                       
           05  WS-DECIMAL-3V4          REDEFINES WS-DECIMAL-3V4-NUM     
                                       PIC S9(3)V9(4).                  
           05  WS-DECIMAL-3V4-FMT.                                      
               10 WS-DECIMAL-3V4-INT      PIC 9(3).                     
               10 WS-DECIMAL-3V4-FRA      PIC 9(4).                     
           05  WS-DECIMAL-9V2-NUM      PIC S9(11).                      
           05  WS-DECIMAL-9V2          REDEFINES WS-DECIMAL-9V2-NUM     
                                       PIC S9(9)V9(2).                  
           05  WS-DECIMAL-9V2-FMT.                                      
               10 WS-DECIMAL-9V2-INT      PIC 9(9).                     
               10 WS-DECIMAL-9V2-FRA      PIC 9(2).                     
           05  WS-ACCT-BALANCE-HI      PIC 9(12) VALUE ZEROES.          
           05  WS-ACCT-BALANCE-LO      PIC 9(12) VALUE ZEROES.          
           05  WS-COUNT-MNTLY-TOT      PIC S9(9) COMP.                  
COB305     05 WS-GL-ACCOUNT-TOT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
                                                                        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01 WS-2N-INPUT-FIELDS.                                           
          05 WS-2N-INPUT-TABLE OCCURS 13 TIMES.                         
             10 WS-2N-INPUT-DATA.                                       
                15 WS-2N-INPUT-SEQ                        PIC 9(8).     
                15 WS-2N-ALLOCATION-PCT                   PIC 9(4).     
                15 WS-2N-ACTIO-SEQ                        PIC X(1).     
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_ACCOUNT_NO.                      *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE               PIC S9(4) COMP VALUE 0.     
             10 S-APPLICATION-CODE          PIC S9(4) COMP VALUE 0.     
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_ACCT_NO             GO                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_ACCOUNT             GL                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_INTRFCE_SEQ         2J                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINSQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_LOCAL_OFFICE           B1                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_INTRFCE             2N                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_CNTL_REF            GC                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLCNTL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_MNTHLY_TOT          GY                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLMNTH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE LOC_OFF CURSOR FOR                          
               SELECT LOCAL_OFFICE                                      
                 FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
                 WHERE LOCAL_OFFICE > ' '                               
                 AND LOCAL_OFFICE <> '997'                              
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE LOC_OFF CURSOR FOR                                  
MFA-TR*        SELECT LOCAL_OFFICE                                              
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*          WHERE LOCAL_OFFICE > ' '                                       
MFA-TR*          AND LOCAL_OFFICE <> '997'                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-GL-ACCT-NO                PIC  X(08).                   
       01  PARM-GO-ACTION-CD              PIC  X(01).                   
       01  PARM-GL-ACCT-NAME              PIC  X(10).                   
       01  PARM-CODE-UTIL-TYPE            PIC  X(01).                   
       01  PARM-GL-ACCT-TYPE              PIC  X(01).                   
       01  PARM-GL-ACCT-CLASS             PIC  X(01).                   
       01  PARM-ACCT-BALANCE-HI           PIC  X(12).                   
       01  PARM-ACCT-BALANCE-LO           PIC  X(12).                   
       01  PARM-MONITOR-FL                PIC  X(05).                   
       01  PARM-GL-ACCT-NAME-DESC         PIC  X(25).                   
       01  PARM-WRITE-OFF-FL              PIC  X(05).                   
       01  PARM-EXTERNAL-DISP-FL          PIC  X(05).                   
       01  PARM-GL-INTRFCE-ID             PIC  X(01).                   
       01  PARM-GL-ACTION-CD              PIC  X(01).                   
       01  PARM-LOCAL-OFFICE              PIC  X(03).                   
       01  PARM-CODE-ACCT-STATUS          PIC  X(01).                   
       01  PARM-SEQ-STRING                PIC  X(169).                  
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-GL-ACCT-NO                                         
              , PARM-GO-ACTION-CD                                       
              , PARM-GL-ACCT-NAME                                       
              , PARM-CODE-UTIL-TYPE                                     
              , PARM-GL-ACCT-TYPE                                       
              , PARM-GL-ACCT-CLASS                                      
              , PARM-ACCT-BALANCE-HI                                    
              , PARM-ACCT-BALANCE-LO                                    
              , PARM-MONITOR-FL                                         
              , PARM-GL-ACCT-NAME-DESC                                  
              , PARM-WRITE-OFF-FL                                       
              , PARM-EXTERNAL-DISP-FL                                   
              , PARM-GL-INTRFCE-ID                                      
              , PARM-GL-ACTION-CD                                       
              , PARM-LOCAL-OFFICE                                       
              , PARM-CODE-ACCT-STATUS                                   
              , PARM-SEQ-STRING.                                        
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           MOVE 0                             TO   S-RETURN-CODE        
                                                   S-APPLICATION-CODE.  
           PERFORM 8800-SEND-RESULT           THRU 8800-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE WS-NO-MORE-LOC-OFF.                               
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      *      DECLARE CUSOR FOR RESULT SET.                                      
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04556_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04556_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04556_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  MOVE 100                  TO S-APPLICATION-CODE       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
               RETURN_CODE                                              
              ,APPL_RETURN_CODE                                         
                FROM #CSR04556_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,APPL_RETURN_CODE                                                 
MFA-TR*         FROM SESSION.CSR04556_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '0100A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DECLARE GTT'        TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04556_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE 100                  TO S-APPLICATION-CODE          
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
            END-IF.                                                     
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *      Evaluate parm for detailed processing.                    *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF PARM-GL-ACCT-NO GREATER THAN SPACES                       
              MOVE PARM-GL-ACCT-NO           TO WS-PARM-GL-ACCT-NO      
              MOVE PARM-GL-ACCT-NO-VAL(1:3)  TO WS-DECIMAL-3V4-INT      
              MOVE PARM-GL-ACCT-NO-VAL(5:4)  TO WS-DECIMAL-3V4-FRA      
              MOVE WS-DECIMAL-3V4-FMT        TO WS-DECIMAL-3V4-NUM      
              MOVE WS-DECIMAL-3V4            TO GO-GL-ACCT-NO           
                                                GL-GL-ACCT-NO           
                                                2N-GL-ACCT-NO           
           END-IF                                                       
           IF PARM-ACCT-BALANCE-HI GREATER THAN SPACES                  
              MOVE PARM-ACCT-BALANCE-HI(1:9)  TO WS-DECIMAL-9V2-INT     
              MOVE PARM-ACCT-BALANCE-HI(11:2) TO WS-DECIMAL-9V2-FRA     
              MOVE WS-DECIMAL-9V2-FMT         TO WS-DECIMAL-9V2-NUM     
              MOVE WS-DECIMAL-9V2             TO GO-ACCT-BALANCE-HI     
           ELSE                                                         
              MOVE ZERO                       TO GO-ACCT-BALANCE-HI     
           END-IF                                                       
           IF PARM-ACCT-BALANCE-LO GREATER THAN SPACES                  
              MOVE PARM-ACCT-BALANCE-LO(1:9)  TO WS-DECIMAL-9V2-INT     
              MOVE PARM-ACCT-BALANCE-LO(11:2) TO WS-DECIMAL-9V2-FRA     
              MOVE WS-DECIMAL-9V2-FMT         TO WS-DECIMAL-9V2-NUM     
              MOVE WS-DECIMAL-9V2             TO GO-ACCT-BALANCE-LO     
           ELSE                                                         
              MOVE ZERO                       TO GO-ACCT-BALANCE-LO     
           END-IF                                                       
           MOVE '01'                          TO GO-COMPANY-NO          
           IF PARM-CODE-UTIL-TYPE = 'N'                                 
              MOVE SPACE                      TO GO-CODE-UTIL-TYPE      
           ELSE                                                         
              MOVE PARM-CODE-UTIL-TYPE        TO GO-CODE-UTIL-TYPE      
           END-IF                                                       
           MOVE PARM-GL-ACCT-TYPE             TO GO-GL-ACCT-TYPE        
           MOVE PARM-GL-ACCT-CLASS            TO GO-GL-ACCT-CLASS       
           IF PARM-MONITOR-FL = 'True'                                  
              MOVE 'Y'                        TO GO-MONITOR-FL          
           ELSE                                                         
              MOVE 'N'                        TO GO-MONITOR-FL          
           END-IF                                                       
           IF PARM-WRITE-OFF-FL = 'True'                                
              MOVE 'Y'                        TO GO-WRITE-OFF-FL        
           ELSE                                                         
              MOVE 'N'                        TO GO-WRITE-OFF-FL        
           END-IF                                                       
           IF PARM-EXTERNAL-DISP-FL = 'True'                            
              MOVE 'Y'                        TO GO-EXTERNAL-DISP-FL    
           ELSE                                                         
              MOVE 'N'                        TO GO-EXTERNAL-DISP-FL    
           END-IF                                                       
           MOVE PARM-GL-INTRFCE-ID            TO GO-GL-INTRFCE-ID       
           MOVE PARM-GL-ACCT-NAME             TO GO-GL-ACCT-NAME        
           MOVE PARM-GL-ACCT-NAME-DESC        TO GO-GL-ACCT-NAME-DESC   
                                                                        
           EVALUATE PARM-GO-ACTION-CD                                   
             WHEN 'I'                                                   
                 MOVE 'SYSTEM'                 TO GO-LAST-UPDATE-USERID 
                 MOVE 'N'                      TO GO-EXTERNAL-DISP-FL   
                 PERFORM 8100-INSERT-GO-ACCT   THRU 8100-EXIT           
                 MOVE 'I'                      TO PARM-GL-ACTION-CD     
             WHEN 'U'                                                   
                 PERFORM 8150-UPDATE-GO-ACCT   THRU 8150-EXIT           
             WHEN 'D'                                                   
                 MOVE 0                        TO WS-COUNT-MNTLY-TOT    
                                                  WS-GL-ACCOUNT-TOT     
                 PERFORM 7200-CHECK-GL-MONTHLY-TOT THRU 7200-EXIT       
                 PERFORM 7300-GET-GL-ACCOUNT-TOT   THRU 7300-EXIT       
                 IF WS-COUNT-MNTLY-TOT = 0 AND WS-GL-ACCOUNT-TOT = 0    
                    PERFORM 8180-DELETE-GO-ACCT       THRU 8180-EXIT    
                 ELSE                                                   
                    MOVE 500                   TO  S-APPLICATION-CODE   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           EVALUATE PARM-GL-ACTION-CD                                   
             WHEN 'I'                                                   
                 PERFORM 2000-DETAIL-GL-PROCESS     THRU 2000-EXIT      
             WHEN 'U'                                                   
                 MOVE PARM-CODE-ACCT-STATUS       TO GL-CODE-ACCT-STATUS
                 IF PARM-LOCAL-OFFICE = 'ALL'                           
                    PERFORM 8250-UPDATE-GL-ACCT-ALL THRU 8250-EXIT      
                 ELSE                                                   
                    MOVE PARM-LOCAL-OFFICE          TO GL-LOCAL-OFFICE  
                    PERFORM 8255-UPDATE-GL-ACCT     THRU 8255-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
           MOVE PARM-SEQ-STRING  TO WS-2N-INPUT-FIELDS.                 
                                                                        
           PERFORM VARYING WS-MISC-INDX FROM 1 BY 1 UNTIL               
                       WS-MISC-INDX > 13 OR                             
                       WS-2N-ACTIO-SEQ (WS-MISC-INDX) <= SPACES         
              MOVE WS-2N-INPUT-SEQ (WS-MISC-INDX) TO                    
                                                2N-GL-INTRFCE-SEQ-NO    
              MOVE WS-2N-ALLOCATION-PCT(WS-MISC-INDX) TO                
                                                2N-ALLOCATION-PCT       
              MOVE 'SYSTEM'                TO  2N-LAST-UPDATE-USERID    
              EVALUATE WS-2N-ACTIO-SEQ (WS-MISC-INDX)                   
                WHEN 'I'                                                
                  PERFORM 8300-INSERT-2N-SEQ    THRU 8300-EXIT          
                WHEN 'U'                                                
                  PERFORM 8350-UPDATE-2N-SEQ    THRU 8350-EXIT          
                WHEN 'D'                                                
                  PERFORM 8380-DELETE-2N-SEQ    THRU 8380-EXIT          
                WHEN OTHER                                              
                  CONTINUE                                              
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-DETAIL-GL-PROCESS.                                        *        
      *      Insert processing for new GL.                             *        
      ******************************************************************        
       2000-DETAIL-GL-PROCESS.                                          
      *                                                                         
                                                                        
           MOVE '2000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           EVALUATE TRUE                                                
              WHEN PARM-LOCAL-OFFICE = 'ALL'                            
      *****Need 997 record first in CSS_GL_ACCOUNT to insert any row            
      *****in CSS_GL_CNTL_REF.                                                  
                 MOVE '997'                          TO GL-LOCAL-OFFICE 
                 PERFORM 8200-INSERT-GO-ACCT         THRU 8200-EXIT     
                 PERFORM 8225-INSERT-GL-CNTL-REF     THRU 8225-EXIT     
                                                                        
                 PERFORM 7100-OPEN-LOC-OFF-CURSOR    THRU 7100-EXIT     
                 PERFORM 7150-FETCH-LOC-OFF-CURSOR   THRU 7150-EXIT     
                                                  UNTIL NO-MORE-LOC-OFF 
                 PERFORM 7180-CLOSE-LOC-OFF-CURSOR   THRU 7180-EXIT     
              WHEN PARM-LOCAL-OFFICE > ' '                              
                 MOVE PARM-LOCAL-OFFICE           TO GL-LOCAL-OFFICE    
                 PERFORM 8200-INSERT-GO-ACCT THRU 8200-EXIT             
              WHEN OTHER                                                
                 CONTINUE                                               
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-LOC-OFF-CURSOR.                                      *        
      *      Cursor to get all local office.                           *        
      ******************************************************************        
       7100-OPEN-LOC-OFF-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN LOC_OFF                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 100                  TO RETURN-CODE                 
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7100'               TO ACTIVE-PARAGRAPH            
               MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_LOCAL_OFFICE'   TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE 101                  TO S-APPLICATION-CODE          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-LOC-OFF-CURSOR.                                     *        
      *      Get all local offices from CSs_LOCAL_OFFICE.              *        
      ******************************************************************        
       7150-FETCH-LOC-OFF-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH LOC_OFF                                            
                INTO :GL-LOCAL-OFFICE                                   
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 8200-INSERT-GO-ACCT     THRU 8200-EXIT      
                    PERFORM 8225-INSERT-GL-CNTL-REF THRU 8225-EXIT      
               WHEN NOT-FOUND                                           
                    MOVE 'Y'               TO WS-NO-MORE-LOC-OFF        
               WHEN OTHER                                               
                 MOVE 100                  TO RETURN-CODE               
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '7150'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSS_LOCAL_OFFICE'   TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 MOVE 101                  TO S-APPLICATION-CODE        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7180-CLOSE-LOC-OFF-CURSOR.                                     *        
      *      CLOSE CURSOR OPENED FOR CSS_LOCAL_OFFICE.                 *        
      ******************************************************************        
                                                                        
       7180-CLOSE-LOC-OFF-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE LOC_OFF                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 100                  TO RETURN-CODE                 
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7180'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_LOCAL_OFFICE'   TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE 101                  TO S-APPLICATION-CODE          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************83130036
      *   7200-CHECK-GL-MONTHLY-TOT.                                  **83140036
      *        CHECK IF A ROW EXISTS FOR GL IN CSS_GL_MNTHLY_TOT.     **83150036
      ******************************************************************83160036
       7200-CHECK-GL-MONTHLY-TOT.                                       
                                                                        
           MOVE 0                       TO WS-COUNT-MNTLY-TOT           
           MOVE '01'                    TO GY-COMPANY-NO                
           MOVE GO-GL-ACCT-NO           TO GY-GL-ACCT-NO                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                 INTO :WS-COUNT-MNTLY-TOT                               
                 FROM CSS_GL_MNTHLY_TOT WITH(READUNCOMMITTED)                   
                WHERE COMPANY_NO = :GY-COMPANY-NO                       
                  AND GL_ACCT_NO = :GY-GL-ACCT-NO                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     83210036
MFA-TR*        SELECT 1                                                 83220036
MFA-TR*          INTO :WS-COUNT-MNTLY-TOT                               83230036
MFA-TR*          FROM CSS_GL_MNTHLY_TOT                                 83240036
MFA-TR*         WHERE COMPANY_NO = :GY-COMPANY-NO                       83250036
MFA-TR*           AND GL_ACCT_NO = :GY-GL-ACCT-NO                       83250036
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                    83270036

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE '7200'                   TO ACTIVE-PARAGRAPH   
                    MOVE 'SELECT'                 TO ABEND-FUNCTION     
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CSS_GL_MNTHLY_TOT'      TO TABLE-ELEMENT-1    
                    MOVE GY-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N
                    MOVE 102                      TO S-APPLICATION-CODE 
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************83130036
      *   7300-GET-GL-ACCOUNT-TOT.                                    **83140036
      *        Get total of amount fields from CSS_GL_ACCOUNT.        **83150036
      ******************************************************************83160036
       7300-GET-GL-ACCOUNT-TOT.                                         
                                                                        
           EXEC SQL                                                     
               SELECT  SUM(ACCT_BALANCE) +                              
                       SUM(AMT_PER_DR_POSTED) +                         
                       SUM(AMT_PER_CR_POSTED)                           
                 INTO :WS-GL-ACCOUNT-TOT                                
                 FROM CSS_GL_ACCOUNT WITH(READUNCOMMITTED)                      
                WHERE GL_ACCT_NO = :GL-GL-ACCT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     83210036
MFA-TR*        SELECT  SUM(ACCT_BALANCE) +                              83220036
MFA-TR*                SUM(AMT_PER_DR_POSTED) +                                 
MFA-TR*                SUM(AMT_PER_CR_POSTED)                                   
MFA-TR*          INTO :WS-GL-ACCOUNT-TOT                                83230036
MFA-TR*          FROM CSS_GL_ACCOUNT                                    83240036
MFA-TR*         WHERE GL_ACCT_NO = :GL-GL-ACCT-NO                       83250036
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    83270036

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE '7300'                   TO ACTIVE-PARAGRAPH   
                    MOVE 'SELECT'                 TO ABEND-FUNCTION     
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CSS_GL_ACCOUNT'         TO TABLE-ELEMENT-1    
                    MOVE GL-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N
                    MOVE 103                      TO S-APPLICATION-CODE 
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      *       DELETE result set cursor.                                *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04556_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04556_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04556_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               MOVE 100                  TO S-APPLICATION-CODE          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-INSERT-GO-ACCT.                                           *        
      *      INSERT row into CSS_GL_ACCT_NO.                           *        
      ******************************************************************        
       8100-INSERT-GO-ACCT.                                             
                                                                        
           EXEC SQL                                                     
                  INSERT INTO CSS_GL_ACCT_NO                            
                  (    GL_ACCT_NO                                       
                      ,COMPANY_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,GL_ACCT_TYPE                                     
                      ,GL_ACCT_CLASS                                    
                      ,ACCT_BALANCE_HI                                  
                      ,ACCT_BALANCE_LO                                  
                      ,MONITOR_FL                                       
                      ,WRITE_OFF_FL                                     
                      ,EXTERNAL_DISP_FL                                 
                      ,GL_INTRFCE_ID                                    
                      ,GL_ACCT_NAME                                     
                      ,GL_ACCT_NAME_DESC                                
                      ,LAST_UPDATE_TS                                   
                      ,LAST_UPDATE_USERID                               
                  )                                                     
               VALUES                                                   
               (                                                        
                    :GO-GL-ACCT-NO                                      
                   ,:GO-COMPANY-NO                                      
                   ,:GO-CODE-UTIL-TYPE                                  
                   ,:GO-GL-ACCT-TYPE                                    
                   ,:GO-GL-ACCT-CLASS                                   
                   ,:GO-ACCT-BALANCE-HI                                 
                   ,:GO-ACCT-BALANCE-LO                                 
                   ,:GO-MONITOR-FL                                      
                   ,:GO-WRITE-OFF-FL                                    
                   ,:GO-EXTERNAL-DISP-FL                                
                   ,:GO-GL-INTRFCE-ID                                   
                   ,:GO-GL-ACCT-NAME                                    
                   ,:GO-GL-ACCT-NAME-DESC                               
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:GO-LAST-UPDATE-USERID                              
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO CSS_GL_ACCT_NO                                    
MFA-TR*           (    GL_ACCT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,GL_ACCT_TYPE                                             
MFA-TR*               ,GL_ACCT_CLASS                                            
MFA-TR*               ,ACCT_BALANCE_HI                                          
MFA-TR*               ,ACCT_BALANCE_LO                                          
MFA-TR*               ,MONITOR_FL                                               
MFA-TR*               ,WRITE_OFF_FL                                             
MFA-TR*               ,EXTERNAL_DISP_FL                                         
MFA-TR*               ,GL_INTRFCE_ID                                            
MFA-TR*               ,GL_ACCT_NAME                                             
MFA-TR*               ,GL_ACCT_NAME_DESC                                        
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :GO-GL-ACCT-NO                                              
MFA-TR*            ,:GO-COMPANY-NO                                              
MFA-TR*            ,:GO-CODE-UTIL-TYPE                                          
MFA-TR*            ,:GO-GL-ACCT-TYPE                                            
MFA-TR*            ,:GO-GL-ACCT-CLASS                                           
MFA-TR*            ,:GO-ACCT-BALANCE-HI                                         
MFA-TR*            ,:GO-ACCT-BALANCE-LO                                         
MFA-TR*            ,:GO-MONITOR-FL                                              
MFA-TR*            ,:GO-WRITE-OFF-FL                                            
MFA-TR*            ,:GO-EXTERNAL-DISP-FL                                        
MFA-TR*            ,:GO-GL-INTRFCE-ID                                           
MFA-TR*            ,:GO-GL-ACCT-NAME                                            
MFA-TR*            ,:GO-GL-ACCT-NAME-DESC                                       
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:GO-LAST-UPDATE-USERID                                      
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 200                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-UPDATE-GO-ACCT.                                           *        
      *      update row into CSS_GL_ACCT_NO.                           *        
      ******************************************************************        
       8150-UPDATE-GO-ACCT.                                             
                                                                        
           EXEC SQL                                                     
            UPDATE  CSS_GL_ACCT_NO                                      
            SET CODE_UTIL_TYPE     = :GO-CODE-UTIL-TYPE                 
               ,GL_ACCT_TYPE       = :GO-GL-ACCT-TYPE                   
               ,GL_ACCT_CLASS      = :GO-GL-ACCT-CLASS                  
               ,ACCT_BALANCE_HI    = :GO-ACCT-BALANCE-HI                
               ,ACCT_BALANCE_LO    = :GO-ACCT-BALANCE-LO                
               ,MONITOR_FL         = :GO-MONITOR-FL                     
               ,WRITE_OFF_FL       = :GO-WRITE-OFF-FL                   
               ,EXTERNAL_DISP_FL   = :GO-EXTERNAL-DISP-FL               
               ,GL_INTRFCE_ID      = :GO-GL-INTRFCE-ID                  
               ,GL_ACCT_NAME       = :GO-GL-ACCT-NAME                   
               ,GL_ACCT_NAME_DESC  = :GO-GL-ACCT-NAME-DESC              
            WHERE GL_ACCT_NO       = :GO-GL-ACCT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE  CSS_GL_ACCT_NO                                              
MFA-TR*     SET CODE_UTIL_TYPE     = :GO-CODE-UTIL-TYPE                         
MFA-TR*        ,GL_ACCT_TYPE       = :GO-GL-ACCT-TYPE                           
MFA-TR*        ,GL_ACCT_CLASS      = :GO-GL-ACCT-CLASS                          
MFA-TR*        ,ACCT_BALANCE_HI    = :GO-ACCT-BALANCE-HI                        
MFA-TR*        ,ACCT_BALANCE_LO    = :GO-ACCT-BALANCE-LO                        
MFA-TR*        ,MONITOR_FL         = :GO-MONITOR-FL                             
MFA-TR*        ,WRITE_OFF_FL       = :GO-WRITE-OFF-FL                           
MFA-TR*        ,EXTERNAL_DISP_FL   = :GO-EXTERNAL-DISP-FL                       
MFA-TR*        ,GL_INTRFCE_ID      = :GO-GL-INTRFCE-ID                          
MFA-TR*        ,GL_ACCT_NAME       = :GO-GL-ACCT-NAME                           
MFA-TR*        ,GL_ACCT_NAME_DESC  = :GO-GL-ACCT-NAME-DESC                      
MFA-TR*     WHERE GL_ACCT_NO       = :GO-GL-ACCT-NO                             
MFA-TR*     QUERYNO 8150                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 300                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8180-DELETE-GO-ACCT.                                           *        
      * Before delete the GL from CSS_GL_ACCT_NO the rows should be    *        
      * deleted from child tables for the GL.                          *        
      ******************************************************************        
                                                                        
       8180-DELETE-GO-ACCT.                                             
                                                                        
           MOVE GO-GL-ACCT-NO           TO GC-GL-DEPNDT-ACCT-NO         
                                           GL-GL-ACCT-NO                
                                           2N-GL-ACCT-NO.               
                                                                        
           EXEC SQL                                                     
             DELETE FROM  CSS_GL_CNTL_REF                               
             WHERE GL_DEPNDT_ACCT_NO = :GC-GL-DEPNDT-ACCT-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_CNTL_REF'    TO TABLE-1                      
              MOVE 403                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DELETE FROM  CSS_GL_ACCOUNT                                
             WHERE GL_ACCT_NO = :GL-GL-ACCT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                      
              MOVE 401                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DELETE FROM  CSS_GL_INTRFCE_SEQ                            
             WHERE GL_ACCT_NO = :2N-GL-ACCT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-1                      
              MOVE 402                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DELETE FROM  CSS_GL_ACCT_NO                                
             WHERE GL_ACCT_NO = :GO-GL-ACCT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 400                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-GO-ACCT.                                           *        
      *      Insert row into CSS_GL_ACCOUNT.                           *        
      ******************************************************************        
       8200-INSERT-GO-ACCT.                                             
                                                                        
           MOVE '01'                          TO GL-COMPANY-NO.         
           MOVE 'A'                           TO GL-CODE-ACCT-STATUS.   
           IF GL-LOCAL-OFFICE = '997'                                   
              MOVE 'C'                        TO GL-GL-DTL-CNTL-IND     
           ELSE                                                         
              MOVE 'D'                        TO GL-GL-DTL-CNTL-IND     
           END-IF.                                                      
           MOVE ZEROES                        TO GL-ACCT-BALANCE        
                                                 GL-BEGIN-ACCT-BALANCE  
                                                 GL-AMT-PER-DR-POSTED   
                                                 GL-AMT-PER-CR-POSTED.  
           MOVE 'SYSTEM'                      TO GL-LAST-UPDATE-USERID. 
                                                                        
           EXEC SQL                                                     
                  INSERT INTO CSS_GL_ACCOUNT                            
                  (    COMPANY_NO                                       
                      ,GL_ACCT_NO                                       
                      ,LOCAL_OFFICE                                     
                      ,DATE_LAST_TRANS                                  
                      ,CODE_ACCT_STATUS                                 
                      ,GL_DTL_CNTL_IND                                  
                      ,ACCT_BALANCE                                     
                      ,BEGIN_ACCT_BALANCE                               
                      ,AMT_PER_DR_POSTED                                
                      ,AMT_PER_CR_POSTED                                
                      ,LAST_UPDATE_TS                                   
                      ,LAST_UPDATE_USERID                               
                  )                                                     
               VALUES                                                   
               (    :GL-COMPANY-NO                                      
                   ,:GL-GL-ACCT-NO                                      
                   ,:GL-LOCAL-OFFICE                                    
                   ,CAST(SYSDATETIMEOFFSET() AS DATE)                           
                   ,:GL-CODE-ACCT-STATUS                                
                   ,:GL-GL-DTL-CNTL-IND                                 
                   ,:GL-ACCT-BALANCE                                    
                   ,:GL-BEGIN-ACCT-BALANCE                              
                   ,:GL-AMT-PER-DR-POSTED                               
                   ,:GL-AMT-PER-CR-POSTED                               
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:GL-LAST-UPDATE-USERID                              
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO CSS_GL_ACCOUNT                                    
MFA-TR*           (    COMPANY_NO                                               
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,DATE_LAST_TRANS                                          
MFA-TR*               ,CODE_ACCT_STATUS                                         
MFA-TR*               ,GL_DTL_CNTL_IND                                          
MFA-TR*               ,ACCT_BALANCE                                             
MFA-TR*               ,BEGIN_ACCT_BALANCE                                       
MFA-TR*               ,AMT_PER_DR_POSTED                                        
MFA-TR*               ,AMT_PER_CR_POSTED                                        
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (    :GL-COMPANY-NO                                              
MFA-TR*            ,:GL-GL-ACCT-NO                                              
MFA-TR*            ,:GL-LOCAL-OFFICE                                            
MFA-TR*            ,CURRENT DATE                                                
MFA-TR*            ,:GL-CODE-ACCT-STATUS                                        
MFA-TR*            ,:GL-GL-DTL-CNTL-IND                                         
MFA-TR*            ,:GL-ACCT-BALANCE                                            
MFA-TR*            ,:GL-BEGIN-ACCT-BALANCE                                      
MFA-TR*            ,:GL-AMT-PER-DR-POSTED                                       
MFA-TR*            ,:GL-AMT-PER-CR-POSTED                                       
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:GL-LAST-UPDATE-USERID                                      
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                      
              MOVE 201                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8225-INSERT-GL-CNTL-REF.                                       *        
      *      Insert row into CSS_GL_CNTL_REF.                          *        
      ******************************************************************        
       8225-INSERT-GL-CNTL-REF.                                         
                                                                        
           MOVE GL-GL-ACCT-NO                 TO GC-GL-DEPNDT-ACCT-NO   
                                                 GC-GL-CNTRL-ACCT-NO.   
           MOVE GL-LOCAL-OFFICE               TO GC-DEPNDT-LOCOFC-CD.   
           IF GL-LOCAL-OFFICE = '997'                                   
              MOVE 999.9999                   TO GC-GL-CNTRL-ACCT-NO    
           END-IF.                                                      
           MOVE '997'                         TO GC-CNTRL-LOCOFC-CD.    
           MOVE '01'                          TO GC-CNTRL-COMPANY-NO    
                                                 GC-DEPNDT-COMPANY-NO.  
           MOVE 'SYSTEM'                      TO GC-LAST-UPDATE-USERID. 
                                                                        
           EXEC SQL                                                     
                  INSERT INTO CSS_GL_CNTL_REF                           
                  (    GL_DEPNDT_ACCT_NO                                
                      ,DEPNDT_LOCOFC_CD                                 
                      ,GL_CNTRL_ACCT_NO                                 
                      ,CNTRL_LOCOFC_CD                                  
                      ,CNTRL_COMPANY_NO                                 
                      ,DEPNDT_COMPANY_NO                                
                      ,LAST_UPDATE_TS                                   
                      ,LAST_UPDATE_USERID                               
                  )                                                     
               VALUES                                                   
               (    :GC-GL-DEPNDT-ACCT-NO                               
                   ,:GC-DEPNDT-LOCOFC-CD                                
                   ,:GC-GL-CNTRL-ACCT-NO                                
                   ,:GC-CNTRL-LOCOFC-CD                                 
                   ,:GC-CNTRL-COMPANY-NO                                
                   ,:GC-DEPNDT-COMPANY-NO                               
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:GC-LAST-UPDATE-USERID                              
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO CSS_GL_CNTL_REF                                   
MFA-TR*           (    GL_DEPNDT_ACCT_NO                                        
MFA-TR*               ,DEPNDT_LOCOFC_CD                                         
MFA-TR*               ,GL_CNTRL_ACCT_NO                                         
MFA-TR*               ,CNTRL_LOCOFC_CD                                          
MFA-TR*               ,CNTRL_COMPANY_NO                                         
MFA-TR*               ,DEPNDT_COMPANY_NO                                        
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (    :GC-GL-DEPNDT-ACCT-NO                                       
MFA-TR*            ,:GC-DEPNDT-LOCOFC-CD                                        
MFA-TR*            ,:GC-GL-CNTRL-ACCT-NO                                        
MFA-TR*            ,:GC-CNTRL-LOCOFC-CD                                         
MFA-TR*            ,:GC-CNTRL-COMPANY-NO                                        
MFA-TR*            ,:GC-DEPNDT-COMPANY-NO                                       
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:GC-LAST-UPDATE-USERID                                      
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8225'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_CNTL_REF'    TO TABLE-1                      
              MOVE 203                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8250-UPDATE-GL-ACCT-ALL.                                       *        
      *      Update all row in CSS_GL_ACCOUNT.                         *        
      ******************************************************************        
       8250-UPDATE-GL-ACCT-ALL.                                         
                                                                        
           EXEC SQL                                                     
            UPDATE  CSS_GL_ACCOUNT                                      
            SET CODE_ACCT_STATUS   = :GL-CODE-ACCT-STATUS               
            WHERE GL_ACCT_NO       = :GL-GL-ACCT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE  CSS_GL_ACCOUNT                                              
MFA-TR*     SET CODE_ACCT_STATUS   = :GL-CODE-ACCT-STATUS                       
MFA-TR*     WHERE GL_ACCT_NO       = :GL-GL-ACCT-NO                             
MFA-TR*     QUERYNO 8250                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8250'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                      
              MOVE 301                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8255-UPDATE-GL-ACCT.                                           *        
      *      Update row in CSS_GL_ACCOUNT.                             *        
      ******************************************************************        
       8255-UPDATE-GL-ACCT.                                             
                                                                        
           EXEC SQL                                                     
            UPDATE  CSS_GL_ACCOUNT                                      
            SET CODE_ACCT_STATUS   = :GL-CODE-ACCT-STATUS               
            WHERE GL_ACCT_NO       = :GL-GL-ACCT-NO                     
              AND LOCAL_OFFICE     = :GL-LOCAL-OFFICE                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE  CSS_GL_ACCOUNT                                              
MFA-TR*     SET CODE_ACCT_STATUS   = :GL-CODE-ACCT-STATUS                       
MFA-TR*     WHERE GL_ACCT_NO       = :GL-GL-ACCT-NO                             
MFA-TR*       AND LOCAL_OFFICE     = :GL-LOCAL-OFFICE                           
MFA-TR*     QUERYNO 8255                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8255'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                      
              MOVE 301                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8255-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-INSERT-2N-SEQ.                                            *        
      *      Insert row in CSS_GL_INTRFCE_SEQ.                         *        
      ******************************************************************        
       8300-INSERT-2N-SEQ.                                              
                                                                        
           EXEC SQL                                                     
                  INSERT INTO CSS_GL_INTRFCE_SEQ                        
                  (    GL_INTRFCE_SEQ_NO                                
                      ,GL_ACCT_NO                                       
                      ,ALLOCATION_PCT                                   
                      ,LAST_UPDATE_TS                                   
                      ,LAST_UPDATE_USERID                               
                  )                                                     
               VALUES                                                   
               (                                                        
                    :2N-GL-INTRFCE-SEQ-NO                               
                   ,:2N-GL-ACCT-NO                                      
                   ,:2N-ALLOCATION-PCT                                  
                   ,CIS.CURRENT$TIMESTAMP()                                   
                   ,:2N-LAST-UPDATE-USERID                              
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO CSS_GL_INTRFCE_SEQ                                
MFA-TR*           (    GL_INTRFCE_SEQ_NO                                        
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,ALLOCATION_PCT                                           
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :2N-GL-INTRFCE-SEQ-NO                                       
MFA-TR*            ,:2N-GL-ACCT-NO                                              
MFA-TR*            ,:2N-ALLOCATION-PCT                                          
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:2N-LAST-UPDATE-USERID                                      
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-1                      
              MOVE 202                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-UPDATE-2N-SEQ.                                            *        
      *      Update row in CSS_GL_INTRFCE_SEQ.                         *        
      ******************************************************************        
       8350-UPDATE-2N-SEQ.                                              
                                                                        
           EXEC SQL                                                     
            UPDATE  CSS_GL_INTRFCE_SEQ                                  
            SET ALLOCATION_PCT     = :2N-ALLOCATION-PCT                 
            WHERE GL_ACCT_NO       = :2N-GL-ACCT-NO                     
            AND  GL_INTRFCE_SEQ_NO = :2N-GL-INTRFCE-SEQ-NO              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE  CSS_GL_INTRFCE_SEQ                                          
MFA-TR*     SET ALLOCATION_PCT     = :2N-ALLOCATION-PCT                         
MFA-TR*     WHERE GL_ACCT_NO       = :2N-GL-ACCT-NO                             
MFA-TR*     AND  GL_INTRFCE_SEQ_NO = :2N-GL-INTRFCE-SEQ-NO                      
MFA-TR*     QUERYNO 8350                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8350'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 302                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8380-DELETE-2N-SEQ.                                            *        
      *      Delete row in CSS_GL_INTRFCE_SEQ.                         *        
      ******************************************************************        
       8380-DELETE-2N-SEQ.                                              
                                                                        
           EXEC SQL                                                     
             DELETE FROM  CSS_GL_INTRFCE_SEQ                            
             WHERE GL_ACCT_NO       = :2N-GL-ACCT-NO                    
             AND  GL_INTRFCE_SEQ_NO = :2N-GL-INTRFCE-SEQ-NO             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-1                      
              MOVE 402                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8800-SEND-RESULT.                                              *        
      * RETURN FIELDS TO CALLING MODULE.                               *        
      ******************************************************************        
       8800-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04556_R1                       
                 (  RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                  )                                                     
               VALUES                                                   
               (    :S-RETURN-CODE                                      
                   ,:S-APPLICATION-CODE                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04556_R1                               
MFA-TR*          (  RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (    :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPLICATION-CODE                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8800'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04556_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              MOVE 100                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE '8900'                      TO ACTIVE-PARAGRAPH.        
           MOVE 'OPEN'                      TO ABEND-FUNCTION.          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04556_R1'            TO TABLE-1                  
              MOVE 100                  TO S-APPLICATION-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE                          GTT-RETURN-FIELDS.       
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE.           
           MOVE 100                         TO S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
           PERFORM 8800-SEND-RESULT            THRU 8800-EXIT.          
                                                                        
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
