       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04552.                                         
       DATE-WRITTEN.  06/21/2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUGETGLCODEDESCBUSINESSOP                       *        
      *  INPUT     : NONE                                              *        
      *                                                                *        
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04552_R1 - CSS_GL_CODE_DESC                     --         
      *--           RETURN_CODE             INTEGER                  --         
      *             COMPANY_IND              CSS_GL_CODE_DESC         *         
      *             TABLE_NA                 CSS_GL_CODE_DESC         *         
      *             COLUMN_NA                CSS_GL_CODE_DESC         *         
      *             CODE_VALUE               CSS_GL_CODE_DESC         *         
      *             SORT_ORDER               CSS_GL_CODE_DESC         *         
      *             CODE_SHORT_DESC          CSS_GL_CODE_DESC         *         
      *             CODE_LONG_DESC           CSS_GL_CODE_DESC         *         
      *--                                                            --         
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  06/2012   RAJ        INITIAL VERSION.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04552'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4552 STARTS HERE'.                  
                                                                        
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  HAS-ACCESS-FL           PIC X(01) VALUE 'N'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08)      VALUE 'CSR04552'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-2Q-ROWS           PIC X(01) VALUE 'N'.        
               88  NO-MORE-2Q-ROWS                    VALUE 'Y'.        
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_ACCOUNT_NO.                      *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE               PIC S9(4)  COMP VALUE 0.    
             10 S-COMPANY-IND               PIC X(02)  VALUE SPACES.    
             10 S-TABLE-NA                  PIC X(18)  VALUE SPACES.    
             10 S-COLUMN-NA                 PIC X(18)  VALUE SPACES.    
             10 S-SORT-ORDER                PIC S9(4)  COMP VALUE 0.    
             10 S-CODE-VALUE                PIC X(10)  VALUE SPACES.    
             10 S-CODE-SHORT-DESC           PIC X(15)  VALUE SPACES.    
             10 S-CODE-LONG-DESC            PIC X(80)  VALUE SPACES.    
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_CODE_DESC           2Q                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLCDVA                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * INCLUDE CSS_CATEGORY               F5                                   
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *****DUMP FROM CSS_GL_CODE_DESC                             ******        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE GL-CODE-DESC CURSOR FOR                     
            SELECT COMPANY_IND                                          
                  ,TABLE_NA                                             
                  ,COLUMN_NA                                            
                  ,CODE_VALUE                                           
                  ,SORT_ORDER                                           
                  ,CODE_SHORT_DESC                                      
                  ,CODE_LONG_DESC                                       
                FROM CSS_GL_CODE_DESC WITH(READUNCOMMITTED)                     
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE GL-CODE-DESC CURSOR FOR                             
MFA-TR*     SELECT COMPANY_IND                                                  
MFA-TR*           ,TABLE_NA                                                     
MFA-TR*           ,COLUMN_NA                                                    
MFA-TR*           ,CODE_VALUE                                                   
MFA-TR*           ,SORT_ORDER                                                   
MFA-TR*           ,CODE_SHORT_DESC                                              
MFA-TR*           ,CODE_LONG_DESC                                               
MFA-TR*         FROM CSS_GL_CODE_DESC                                           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS               THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      *      DECLARE CURSOR FOR RESULT SET.                                     
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04552_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04552_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,COMPANY_IND CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,TABLE_NA CHAR(18)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,COLUMN_NA CHAR(18)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,CODE_VALUE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,SORT_ORDER              SMALLINT                     
                  ,CODE_SHORT_DESC CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CODE_LONG_DESC CHAR(80)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS-1      
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS-RS1             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04552_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,COMPANY_IND                                               
             ,TABLE_NA                                                  
             ,COLUMN_NA                                                 
             ,CODE_VALUE                                                
             ,SORT_ORDER                                                
             ,CODE_SHORT_DESC                                           
             ,CODE_LONG_DESC                                            
                FROM #CSR04552_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,COMPANY_IND                                                       
MFA-TR*      ,TABLE_NA                                                          
MFA-TR*      ,COLUMN_NA                                                         
MFA-TR*      ,CODE_VALUE                                                        
MFA-TR*      ,SORT_ORDER                                                        
MFA-TR*      ,CODE_SHORT_DESC                                                   
MFA-TR*      ,CODE_LONG_DESC                                                    
MFA-TR*         FROM SESSION.CSR04552_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS-1          
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS-RS1                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '0100A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DECLARE GTT'        TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04552_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
            END-IF.                                                     
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS.                                                  *        
      *      MAIN PROCESSING.                                          *        
      ******************************************************************        
       1000-PROCESS.                                                    
                                                                        
           MOVE '1000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 7000-OPEN-GL-CODE-DESC-CUR     THRU 7000-EXIT.       
                                                                        
           PERFORM 7050-FETCH-GL-CODE-DESC-CUR    THRU 7050-EXIT.       
                                                                        
           PERFORM 2000-PROCESS-GL-CODE-DESC-CUR  THRU 2000-EXIT        
                                                  UNTIL NO-MORE-2Q-ROWS.
                                                                        
           PERFORM 7080-CLOSE-GL-CODE-DESC-CUR    THRU 7080-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-GL-CODE-DESC-CUR.                                   
                                                                        
           MOVE '2000'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           ADD 1                               TO CTR-ROWS-RS1.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE.        
           MOVE 2Q-COMPANY-IND                 TO S-COMPANY-IND.        
           MOVE 2Q-TABLE-NA                    TO S-TABLE-NA.           
           MOVE 2Q-COLUMN-NA                   TO S-COLUMN-NA.          
           MOVE 2Q-CODE-VALUE                  TO S-CODE-VALUE.         
           MOVE 2Q-SORT-ORDER                  TO S-SORT-ORDER.         
           MOVE 2Q-CODE-SHORT-DESC             TO S-CODE-SHORT-DESC.    
           MOVE 2Q-CODE-LONG-DESC              TO S-CODE-LONG-DESC.     
                                                                        
           PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT.          
                                                                        
           PERFORM 7050-FETCH-GL-CODE-DESC-CUR THRU 7050-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-GL-CODE-DESC-CUR.                               *             
      *      OPEN CURSOR FOR TABLE CSS_GL_CODE_DESC               *             
      ****************************************************************          
                                                                        
       7000-OPEN-GL-CODE-DESC-CUR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN GL-CODE-DESC                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-1           
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS-RS1                  
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_GL_CODE_DESC'  TO TABLE-1                       
              MOVE 'COMPANY_IND'       TO TABLE-ELEMENT-1               
              MOVE 2Q-COMPANY-IND    TO HOSTVAR-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-FETCH-GL-CODE-DESC-CUR.                                   *        
      *     GET THE DATA FROM CSS_GL_CODE_DESC                         *        
      ******************************************************************        
       7050-FETCH-GL-CODE-DESC-CUR.                                     
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH GL-CODE-DESC                                        
                INTO :2Q-COMPANY-IND                                    
                    ,:2Q-TABLE-NA                                       
                    ,:2Q-COLUMN-NA                                      
                    ,:2Q-CODE-VALUE                                     
                    ,:2Q-SORT-ORDER                                     
                    ,:2Q-CODE-SHORT-DESC                                
                    ,:2Q-CODE-LONG-DESC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-2Q-ROWS       
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7050'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_CODE_DESC'   TO TABLE-1                  
                  MOVE 'COMPANY_IND'        TO TABLE-ELEMENT-1          
                  MOVE 2Q-COMPANY-IND       TO HOSTVAR-ELEMENT-1-N      
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7080-CLOSE-GL-CODE-DESC-CUR.                                 *          
      *      OPEN CURSOR FOR TABLE CSS_GL_CODE_DESC                  *          
      ****************************************************************          
                                                                        
       7080-CLOSE-GL-CODE-DESC-CUR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE GL-CODE-DESC                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-1           
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS-RS1                  
              PERFORM 8100-SEND-GO-RESULT THRU 8100-EXIT                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7080'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_GL_CODE_DESC'  TO TABLE-1                       
              MOVE 'COMPANY_IND'       TO TABLE-ELEMENT-1               
              MOVE 2Q-COMPANY-IND      TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04552_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04552_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS-1         
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS-RS1                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04552_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-GO-RESULT.                                           *        
      ******************************************************************        
       8100-SEND-GO-RESULT.                                             
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04552_R1                       
                  (    RETURN_CODE                                      
                      ,COMPANY_IND                                      
                      ,TABLE_NA                                         
                      ,COLUMN_NA                                        
                      ,CODE_VALUE                                       
                      ,SORT_ORDER                                       
                      ,CODE_SHORT_DESC                                  
                      ,CODE_LONG_DESC                                   
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-COMPANY-IND                                      
                   ,:S-TABLE-NA                                         
                   ,:S-COLUMN-NA                                        
                   ,:S-CODE-VALUE                                       
                   ,:S-SORT-ORDER                                       
                   ,:S-CODE-SHORT-DESC                                  
                   ,:S-CODE-LONG-DESC                                   
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04552_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,COMPANY_IND                                              
MFA-TR*               ,TABLE_NA                                                 
MFA-TR*               ,COLUMN_NA                                                
MFA-TR*               ,CODE_VALUE                                               
MFA-TR*               ,SORT_ORDER                                               
MFA-TR*               ,CODE_SHORT_DESC                                          
MFA-TR*               ,CODE_LONG_DESC                                           
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-COMPANY-IND                                              
MFA-TR*            ,:S-TABLE-NA                                                 
MFA-TR*            ,:S-COLUMN-NA                                                
MFA-TR*            ,:S-CODE-VALUE                                               
MFA-TR*            ,:S-SORT-ORDER                                               
MFA-TR*            ,:S-CODE-SHORT-DESC                                          
MFA-TR*            ,:S-CODE-LONG-DESC                                           
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              ADD 1 TO CTR-ROWS                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04552_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-1      
              MOVE   100                    TO S-RETURN-CODE            
              PERFORM 8100-SEND-GO-RESULT      THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE '8900'                      TO ACTIVE-PARAGRAPH.        
           MOVE 'OPEN'                      TO ABEND-FUNCTION.          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04552_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE                          GTT-RETURN-FIELDS.       
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE.           
           MOVE 100                         TO S-RETURN-CODE.           
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
           PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
