       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04551.                                         
       DATE-WRITTEN.  06/21/2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  RETRIEVE DATA FROM CSS_GL_ACCT_NO, CSS_GL_ACCOUNT,            *        
      *  CSS_GL_INTRFCE_SEQ AND CSS_GL_INTRFCE.                        *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUGETGLACCOUNTDETAILSBUSINESSOP                 *        
      *  INPUT     : PROCESS_CD               CHAR(03)                 *        
      *            : GL_ACCT_NO               CSS_GL_ACCT_NO           *        
      *                                                                *        
      *--      OUT                                                   --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04551_R1 - CSS_GL_ACCOUNT_NO                    --         
      *--           RETURN_CODE             INTEGER                  --         
      *             GL_ACCT_NO               CSS_GL_ACCT_NO           *         
      *             CODE_UTIL_TYPE           CSS_GL_ACCT_NO           *         
      *             GL_ACCT_TYPE             CSS_GL_ACCT_NO           *         
      *             GL_ACCT_CLASS            CSS_GL_ACCT_NO           *         
      *             ACCT_BALANCE_HI          CSS_GL_ACCT_NO           *         
      *             ACCT_BALANCE_LO          CSS_GL_ACCT_NO           *         
      *             MONITOR_FL               CSS_GL_ACCT_NO           *         
      *             WRITE_OFF_FL             CSS_GL_ACCT_NO           *         
      *             EXTERNAL_DISP_FL         CSS_GL_ACCT_NO           *         
      *             GL_INTRFCE_ID            CSS_GL_ACCT_NO           *         
      *             ALLOW_DELETE_FL          CHAR                     *         
      *--                                                            --         
      *--      2. CSR04551_R2 - CSS_GL_INTRFCE                       --         
      *--           RETURN_CODE             INTEGER                  --         
      *              GL_ACCT_NO               CSS_GL_ACCT_NO           *        
      *              GL_INTRFCE_ACCT_NO       CSS_GL_INTRFCE           *        
      *              COMPANY_ID               CSS_GL_INTRFCE           *        
      *              ACTIVITY_CD              CSS_GL_INTRFCE           *        
      *              RESOURCE_CD              CSS_GL_INTRFCE           *        
      *              BUSINESS_UNIT            CSS_GL_INTRFCE           *        
      *              COST_CENTER              CSS_GL_INTRFCE           *        
      *              CUSTOMER_CD              CSS_GL_INTRFCE           *        
      *              COST_CENTER_IND          CSS_GL_INTRFCE           *        
      *              OPERATING_UNIT           CSS_GL_INTRFCE           *        
      *              GL_INTRFCE_SEQ_NO        CSS_GL_INTRFCE_SEQ       *        
      *              ALLOCATION_PCT           CSS_GL_INTRFCE_SEQ       *        
      *--                                                            --         
      *--      3. CSR04551_R3 - CSS_GL_ACCOUNT                       --         
      *--            RETURN_CODE              INTEGER                 --        
      *              GL_ACCT_NO               CSS_GL_ACCOUNT           *        
      *              LOCAL_OFFICE             CSS_GL_ACCOUNT           *        
      *              CODE_ACCT_STATUS         CSS_GL_ACCOUNT           *        
      *              GL_DTL_CNTL_IND          CSS_GL_ACCOUNT           *        
      *--                                                             --        
      *--      4. CSR04551_R4 - CSS_GL_INTRFCE                        --        
      *--            RETURN_CODE             INTEGER                  --        
      *              GL_INTRFCE_ACCT_NO       CSS_GL_INTRFCE           *        
      *              COMPANY_ID               CSS_GL_INTRFCE           *        
      *              ACTIVITY_CD              CSS_GL_INTRFCE           *        
      *              RESOURCE_CD              CSS_GL_INTRFCE           *        
      *              BUSINESS_UNIT            CSS_GL_INTRFCE           *        
      *              COST_CENTER              CSS_GL_INTRFCE           *        
      *              CUSTOMER_CD              CSS_GL_INTRFCE           *        
      *              COST_CENTER_IND          CSS_GL_INTRFCE           *        
      *              OPERATING_UNIT           CSS_GL_INTRFCE           *        
      *              GL_INTRFCE_SEQ_NO        CSS_GL_INTRFCE           *        
      *--                                                            --         
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  06/2012    RAJ       INITIAL VERSION.                         *        
A05460*  09/12/2016 SM93554   ADDED LOCAL OFFICE STATUS CHECK IN       *        
      *             ACT277    GL-CURSOR TO AVOID APPL ERR IN CIS MOD.  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04551'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4551 STARTS HERE'.                  
                                                                        
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  HAS-ACCESS-FL           PIC X(01) VALUE 'N'.             
ACT277     05  WS-INACTIVE             PIC X(01) VALUE 'I'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-GL-CHANGED           PIC X(01) VALUE 'N'.             
               88 GL-CHANGED                     VALUE 'Y'.             
           05  WS-GL-FOUND             PIC X(01) VALUE 'N'.             
               88 GL-FOUND                       VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08)      VALUE 'CSR04551'. 
           05 S-RETURN-CODE            PIC S9(4) COMP VALUE 0.          
           05  WS-DECIMAL-3V4-NUM      PIC S9(7).                       
           05  WS-DECIMAL-3V4          REDEFINES WS-DECIMAL-3V4-NUM     
                                       PIC S9(3)V9(4).                  
           05  WS-DECIMAL-3V4-FMT.                                      
               10 WS-DECIMAL-3V4-INT      PIC 9(3).                     
               10 WS-DECIMAL-3V4-FRA      PIC 9(4).                     
                                                                        
           05  WS-COUNT-MNTLY-TOT      PIC S9(9) COMP.                  
           05  GL-CNT                  PIC S9(5) COMP-3 VALUE +0.       
       01  WS-NULL-IND1                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND2                PIC S9(4) COMP VALUE 0.          
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-GL-ACCT-NO.                                         
               10  PARM-GL-ACCT-NO-VAL      PIC X(8).                   
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-GO-ROWS           PIC X(01) VALUE 'N'.        
               88  NO-MORE-GO-ROWS                    VALUE 'Y'.        
           05  WS-NO-MORE-GL-ROWS           PIC X(01) VALUE 'N'.        
               88  NO-MORE-GL-ROWS                    VALUE 'Y'.        
           05  WS-NO-MORE-2J2N-ROWS         PIC X(01) VALUE 'N'.        
               88  NO-MORE-2J2N-ROWS                  VALUE 'Y'.        
           05  WS-NO-MORE-2J-ROWS           PIC X(01) VALUE 'N'.        
               88  NO-MORE-2J-ROWS                    VALUE 'Y'.        
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_ACCOUNT_NO.                      *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-GO            PIC S9(4) COMP VALUE 0.     
             10 S-GL-ACCT-NO-GO             PIC S9(3)V9(4) USAGE COMP-3 
                                                VALUE 0.                
             10 S-CODE-UTIL-TYPE            PIC X(1)  VALUE SPACE.      
             10 S-GL-ACCT-TYPE              PIC X(1)  VALUE SPACE.      
             10 S-GL-ACCT-CLASS             PIC X(1)  VALUE SPACE.      
             10 S-ACCT-BALANCE-HI           PIC S9(9)V9(2) USAGE COMP-3 
                                                      VALUE 0.          
             10 S-ACCT-BALANCE-LO           PIC S9(9)V9(2) USAGE COMP-3 
                                                      VALUE 0.          
             10 S-MONITOR-FL                PIC X(1)  VALUE SPACE.      
             10 S-WRITE-OFF-FL              PIC X(1)  VALUE SPACE.      
             10 S-EXTERNAL-DISP-FL          PIC X(1)  VALUE SPACE.      
             10 S-GL-INTRFCE-ID             PIC X(1)  VALUE SPACE.      
             10 S-GL-ACCT-NAME              PIC X(10) VALUE SPACE.      
             10 S-GL-ACCT-NAME-DESC         PIC X(25) VALUE SPACE.      
             10 S-ALLOW-DELETE-FL           PIC X(1)  VALUE SPACE.      
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ      *        
      ******************************************************************        
           05 GTT-RETURN-FIELDS-2.                                      
               10 S-RETURN-CODE-2J2N          PIC S9(4) COMP VALUE 0.   
               10 S-GL-ACCT-NO-2N          PIC S9(3)V9(4) USAGE COMP-3  
                                                        VALUE 0.        
               10 S-GL-INTRFCE-SEQ-NO         PIC S9(4) USAGE COMP      
                                                      VALUE 0.          
               10 S-ALLOCATION-PCT            PIC S9(4) USAGE COMP      
                                                      VALUE 0.          
               10 S-COMPANY-IND               PIC X(2) VALUE SPACES.    
               10 S-RESOURCE-CD               PIC X(3) VALUE SPACES.    
               10 S-ACTIVITY-CD               PIC X(4) VALUE SPACES.    
               10 S-GL-INTRFCE-ACCT-NO      PIC S9(3)V9(4) USAGE COMP-3 
                                                           VALUE 0.     
               10 S-BUSINESS-UNIT             PIC X(5) VALUE SPACES.    
               10 S-COST-CENTER               PIC X(4) VALUE SPACES.    
               10 S-CUSTOMER-CD               PIC X(3) VALUE SPACES.    
               10 S-COST-CENTER-IND           PIC X(3) VALUE SPACES.    
               10 S-OPERATING-UNIT            PIC X(4) VALUE SPACES.    
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_ACCOUNT.                         *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-GL            PIC S9(4) COMP VALUE 0.     
             10 S-GL-ACCT-NO-GL             PIC S9(3)V9(4) USAGE COMP-3 
                                                VALUE 0.                
             10 S-LOCAL-OFFICE              PIC X(3) VALUE SPACES.      
             10 S-CODE-ACCT-STATUS          PIC X(1) VALUE SPACES.      
             10 S-GL-DTL-CNTL-IND           PIC X(1) VALUE SPACES.      
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR CSS_GL_INTRFCE                          *        
      ******************************************************************        
           05 GTT-RETURN-FIELDS-4.                                      
               10 S-RETURN-CODE-2J            PIC S9(4) COMP VALUE 0.   
               10 S-GL-INTRFCE-SEQ-NO-2J      PIC S9(4) USAGE COMP      
                                                      VALUE 0.          
               10 S-ALLOCATION-PCT-2J         PIC S9(4) USAGE COMP      
                                                      VALUE 0.          
               10 S-COMPANY-IND-2J            PIC X(2) VALUE SPACES.    
               10 S-RESOURCE-CD-2J            PIC X(3) VALUE SPACES.    
               10 S-ACTIVITY-CD-2J            PIC X(4) VALUE SPACES.    
               10 S-GL-INTRFCE-ACCT-NO-2J   PIC S9(3)V9(4) USAGE COMP-3 
                                                           VALUE 0.     
               10 S-BUSINESS-UNIT-2J          PIC X(5) VALUE SPACES.    
               10 S-COST-CENTER-2J            PIC X(4) VALUE SPACES.    
               10 S-CUSTOMER-CD-2J            PIC X(3) VALUE SPACES.    
               10 S-COST-CENTER-IND-2J        PIC X(3) VALUE SPACES.    
               10 S-OPERATING-UNIT-2J         PIC X(4) VALUE SPACES.    
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_ACCT_NO         GO                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_ACCOUNT         GL                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLACCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_INTRFCE_SEQ     2J                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINSQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_INTRFCE         2N                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLINFC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_MNTHLY_TOT      GY                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLMNTH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_CATEGORY           F5                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
ACT277******************************************************************        
ACT277* INCLUDE CSS_LOCAL_OFFICE       B1                                       
ACT277******************************************************************        
ACT277     EXEC SQL                                                             
ACT277        INCLUDE TBLOCOFC                                                  
ACT277     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *****DUMP FROM CSS_GL_ACCT_NO                               ******        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE GO-CURSOR CURSOR FOR                        
            SELECT GO.GL_ACCT_NO                                        
                  ,GO.CODE_UTIL_TYPE                                    
                  ,GO.GL_ACCT_TYPE                                      
                  ,GO.GL_ACCT_CLASS                                     
                  ,GO.ACCT_BALANCE_HI                                   
                  ,GO.ACCT_BALANCE_LO                                   
                  ,GO.MONITOR_FL                                        
                  ,GO.WRITE_OFF_FL                                      
                  ,GO.EXTERNAL_DISP_FL                                  
                  ,GO.GL_INTRFCE_ID                                     
                  ,GO.GL_ACCT_NAME                                      
                  ,GO.GL_ACCT_NAME_DESC                                 
                FROM CSS_GL_ACCT_NO GO WITH(READUNCOMMITTED)                    
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE GO-CURSOR CURSOR FOR                                
MFA-TR*     SELECT GO.GL_ACCT_NO                                                
MFA-TR*           ,GO.CODE_UTIL_TYPE                                            
MFA-TR*           ,GO.GL_ACCT_TYPE                                              
MFA-TR*           ,GO.GL_ACCT_CLASS                                             
MFA-TR*           ,GO.ACCT_BALANCE_HI                                           
MFA-TR*           ,GO.ACCT_BALANCE_LO                                           
MFA-TR*           ,GO.MONITOR_FL                                                
MFA-TR*           ,GO.WRITE_OFF_FL                                              
MFA-TR*           ,GO.EXTERNAL_DISP_FL                                          
MFA-TR*           ,GO.GL_INTRFCE_ID                                             
MFA-TR*           ,GO.GL_ACCT_NAME                                              
MFA-TR*           ,GO.GL_ACCT_NAME_DESC                                         
MFA-TR*         FROM CSS_GL_ACCT_NO GO                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *****PULL FROM CSS_GL_ACCOUNT BASED ON GL_ACCT_NBR           *****        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE GL-CURSOR CURSOR FOR                        
ACT277      SELECT GL.LOCAL_OFFICE                                      
ACT277            ,GL.CODE_ACCT_STATUS                                  
ACT277            ,GL.GL_DTL_CNTL_IND                                   
              FROM CSS_GL_ACCOUNT GL WITH(READUNCOMMITTED)                      
ACT277            ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                    
             WHERE GL.GL_ACCT_NO = :GL-GL-ACCT-NO                       
               AND GL.LOCAL_OFFICE > ' '                                
ACT277         AND GL.LOCAL_OFFICE = B1.LOCAL_OFFICE                    
ACT277         AND B1.STATUS_CD <> :WS-INACTIVE                         
ACT277       ORDER BY GL.LOCAL_OFFICE                                   
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE GL-CURSOR CURSOR FOR                                
MFA-TR*     SELECT GL.LOCAL_OFFICE                                              
MFA-TR*           ,GL.CODE_ACCT_STATUS                                          
MFA-TR*           ,GL.GL_DTL_CNTL_IND                                           
MFA-TR*       FROM CSS_GL_ACCOUNT GL                                            
MFA-TR*           ,CSS_LOCAL_OFFICE B1                                          
MFA-TR*      WHERE GL.GL_ACCT_NO = :GL-GL-ACCT-NO                               
MFA-TR*        AND GL.LOCAL_OFFICE > ' '                                        
MFA-TR*        AND GL.LOCAL_OFFICE = B1.LOCAL_OFFICE                            
MFA-TR*        AND B1.STATUS_CD <> :WS-INACTIVE                                 
MFA-TR*      ORDER BY GL.LOCAL_OFFICE                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *****PULL FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ BASED ON   *****        
      *****                                          GL_ACCT_NBR   *****        
      ******************************************************************        
      * CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ                                      
           EXEC SQL DECLARE 2J2N-CURSOR CURSOR FOR                      
            SELECT [2N].GL_ACCT_NO                                        
                  ,[2N].GL_INTRFCE_SEQ_NO                                 
                  ,[2N].ALLOCATION_PCT                                    
                  ,[2J].COMPANY_IND                                       
                  ,[2J].RESOURCE_CD                                       
                  ,[2J].ACTIVITY_CD                                       
                  ,[2J].GL_INTRFCE_ACCT_NO                                
                  ,[2J].BUSINESS_UNIT                                     
                  ,[2J].COST_CENTER                                       
                  ,[2J].CUSTOMER_CD                                       
                  ,[2J].COST_CENTER_IND                                   
                  ,[2J].OPERATING_UNIT                                    
                FROM CSS_GL_INTRFCE_SEQ [2N] WITH(READUNCOMMITTED)              
                    ,CSS_GL_INTRFCE [2J] WITH(READUNCOMMITTED)                  
                 WHERE  [2N].GL_ACCT_NO        = :2N-GL-ACCT-NO           
                 AND    [2N].GL_INTRFCE_SEQ_NO = [2J].GL_INTRFCE_SEQ_NO     
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL DECLARE 2J2N-CURSOR CURSOR FOR                              
MFA-TR*     SELECT 2N.GL_ACCT_NO                                                
MFA-TR*           ,2N.GL_INTRFCE_SEQ_NO                                         
MFA-TR*           ,2N.ALLOCATION_PCT                                            
MFA-TR*           ,2J.COMPANY_IND                                               
MFA-TR*           ,2J.RESOURCE_CD                                               
MFA-TR*           ,2J.ACTIVITY_CD                                               
MFA-TR*           ,2J.GL_INTRFCE_ACCT_NO                                        
MFA-TR*           ,2J.BUSINESS_UNIT                                             
MFA-TR*           ,2J.COST_CENTER                                               
MFA-TR*           ,2J.CUSTOMER_CD                                               
MFA-TR*           ,2J.COST_CENTER_IND                                           
MFA-TR*           ,2J.OPERATING_UNIT                                            
MFA-TR*         FROM CSS_GL_INTRFCE_SEQ 2N                                      
MFA-TR*             ,CSS_GL_INTRFCE 2J                                          
MFA-TR*          WHERE  2N.GL_ACCT_NO        = :2N-GL-ACCT-NO                   
MFA-TR*          AND    2N.GL_INTRFCE_SEQ_NO = 2J.GL_INTRFCE_SEQ_NO             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *****DUMP FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ  IF       ******        
      *****GL_ACCT_NBR IS AVAILABLE IN CSS_GL_ACCT_NO.            ******        
      ******************************************************************        
      *                                                                         
           EXEC SQL DECLARE INTFCE-2J   CURSOR FOR                      
            SELECT [2J].GL_INTRFCE_SEQ_NO                                 
                  ,[2J].COMPANY_IND                                       
                  ,[2J].RESOURCE_CD                                       
                  ,[2J].ACTIVITY_CD                                       
                  ,[2J].GL_INTRFCE_ACCT_NO                                
                  ,[2J].BUSINESS_UNIT                                     
                  ,[2J].COST_CENTER                                       
                  ,[2J].CUSTOMER_CD                                       
                  ,[2J].COST_CENTER_IND                                   
                  ,[2J].OPERATING_UNIT                                    
                FROM CSS_GL_INTRFCE [2J] WITH(READUNCOMMITTED)                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL DECLARE INTFCE-2J   CURSOR FOR                              
MFA-TR*     SELECT 2J.GL_INTRFCE_SEQ_NO                                         
MFA-TR*           ,2J.COMPANY_IND                                               
MFA-TR*           ,2J.RESOURCE_CD                                               
MFA-TR*           ,2J.ACTIVITY_CD                                               
MFA-TR*           ,2J.GL_INTRFCE_ACCT_NO                                        
MFA-TR*           ,2J.BUSINESS_UNIT                                             
MFA-TR*           ,2J.COST_CENTER                                               
MFA-TR*           ,2J.CUSTOMER_CD                                               
MFA-TR*           ,2J.COST_CENTER_IND                                           
MFA-TR*           ,2J.OPERATING_UNIT                                            
MFA-TR*         FROM CSS_GL_INTRFCE 2J                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7600                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *****DUMP FROM CSS_GL_INTRFCE                               ******        
      ******************************************************************        
      *                                                                         
           EXEC SQL DECLARE INTFCE-SEQ  CURSOR FOR                      
            SELECT [2N].GL_ACCT_NO                                        
                  ,[2N].GL_INTRFCE_SEQ_NO                                 
                  ,[2N].ALLOCATION_PCT                                    
                  ,[2J].COMPANY_IND                                       
                  ,[2J].RESOURCE_CD                                       
                  ,[2J].ACTIVITY_CD                                       
                  ,[2J].GL_INTRFCE_ACCT_NO                                
                  ,[2J].BUSINESS_UNIT                                     
                  ,[2J].COST_CENTER                                       
                  ,[2J].CUSTOMER_CD                                       
                  ,[2J].COST_CENTER_IND                                   
                  ,[2J].OPERATING_UNIT                                    
                FROM CSS_GL_INTRFCE_SEQ [2N] WITH(READUNCOMMITTED)              
                    ,CSS_GL_INTRFCE [2J] WITH(READUNCOMMITTED)                  
                 WHERE  [2N].GL_INTRFCE_SEQ_NO = [2J].GL_INTRFCE_SEQ_NO     
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL DECLARE INTFCE-SEQ  CURSOR FOR                              
MFA-TR*     SELECT 2N.GL_ACCT_NO                                                
MFA-TR*           ,2N.GL_INTRFCE_SEQ_NO                                         
MFA-TR*           ,2N.ALLOCATION_PCT                                            
MFA-TR*           ,2J.COMPANY_IND                                               
MFA-TR*           ,2J.RESOURCE_CD                                               
MFA-TR*           ,2J.ACTIVITY_CD                                               
MFA-TR*           ,2J.GL_INTRFCE_ACCT_NO                                        
MFA-TR*           ,2J.BUSINESS_UNIT                                             
MFA-TR*           ,2J.COST_CENTER                                               
MFA-TR*           ,2J.CUSTOMER_CD                                               
MFA-TR*           ,2J.COST_CENTER_IND                                           
MFA-TR*           ,2J.OPERATING_UNIT                                            
MFA-TR*         FROM CSS_GL_INTRFCE_SEQ 2N                                      
MFA-TR*             ,CSS_GL_INTRFCE 2J                                          
MFA-TR*          WHERE  2N.GL_INTRFCE_SEQ_NO = 2J.GL_INTRFCE_SEQ_NO             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  I-PROCESS-CD                   PIC  X(3).                    
       01  I-GL-ACCT-NO                   PIC  X(8).                    
                                                                        
       PROCEDURE DIVISION USING                                         
                I-PROCESS-CD,                                           
                I-GL-ACCT-NO.                                           
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS               THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           PERFORM 0100B-DECLARE-GTT           THRU  0100B-EXIT.        
                                                                        
           PERFORM 0100C-DECLARE-GTT           THRU  0100C-EXIT.        
                                                                        
           PERFORM 0100D-DECLARE-GTT           THRU  0100D-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                              *        
      *      DECLARE CURSORT FOR RESULT SET 1.                         *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04551_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04551_R1
              (                                                        
                   RETURN_CODE_GO          INT                      
                  ,GL_ACCT_NO_GO           DECIMAL(7,4)                
                  ,CODE_UTIL_TYPE CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_ACCT_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,GL_ACCT_CLASS CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,ACCT_BALANCE_HI         DECIMAL(11,2)               
                  ,ACCT_BALANCE_LO         DECIMAL(11,2)               
                  ,MONITOR_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,WRITE_OFF_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,EXTERNAL_DISP_FL CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_INTRFCE_ID CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,ALLOW_DELETE_FL CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_ACCT_NAME CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,GL_ACCT_NAME_DESC CHAR(25)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS-1      
                  MOVE 100                  TO S-RETURN-CODE-GO         
                  ADD 1                     TO CTR-ROWS-RS1             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04551_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE_GO                                            
             ,GL_ACCT_NO_GO                                             
             ,CODE_UTIL_TYPE                                            
             ,GL_ACCT_TYPE                                              
             ,GL_ACCT_CLASS                                             
             ,ACCT_BALANCE_HI                                           
             ,ACCT_BALANCE_LO                                           
             ,MONITOR_FL                                                
             ,WRITE_OFF_FL                                              
             ,EXTERNAL_DISP_FL                                          
             ,GL_INTRFCE_ID                                             
             ,ALLOW_DELETE_FL                                           
             ,GL_ACCT_NAME                                              
             ,GL_ACCT_NAME_DESC                                         
                FROM #CSR04551_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE_GO                                                    
MFA-TR*      ,GL_ACCT_NO_GO                                                     
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,GL_ACCT_TYPE                                                      
MFA-TR*      ,GL_ACCT_CLASS                                                     
MFA-TR*      ,ACCT_BALANCE_HI                                                   
MFA-TR*      ,ACCT_BALANCE_LO                                                   
MFA-TR*      ,MONITOR_FL                                                        
MFA-TR*      ,WRITE_OFF_FL                                                      
MFA-TR*      ,EXTERNAL_DISP_FL                                                  
MFA-TR*      ,GL_INTRFCE_ID                                                     
MFA-TR*      ,ALLOW_DELETE_FL                                                   
MFA-TR*      ,GL_ACCT_NAME                                                      
MFA-TR*      ,GL_ACCT_NAME_DESC                                                 
MFA-TR*         FROM SESSION.CSR04551_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100B-DECLARE-GTT.                                              *        
      *      DECLARE CURSORT FOR RESULT SET 2.                         *        
      ******************************************************************        
       0100B-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04551_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04551_R2
              (                                                        
                   RETURN_CODE_2J2N        INT                      
                  ,GL_ACCT_NO              DECIMAL(7,4)                
                  ,GL_INTRFCE_SEQ_NO       SMALLINT                     
                  ,ALLOCATION_PCT          SMALLINT                     
                  ,COMPANY_IND CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,RESOURCE_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ACTIVITY_CD CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,GL_INTRFCE_ACCT_NO      DECIMAL(7,4)                
                  ,BUSINESS_UNIT CHAR(5)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,COST_CENTER CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CUSTOMER_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,COST_CENTER_IND CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,OPERATING_UNIT CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS-2      
                  MOVE 100                  TO S-RETURN-CODE-2J2N       
                  ADD 1                     TO CTR-ROWS-RS2             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100C'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04551_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C2 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE_2J2N                                          
             ,GL_ACCT_NO                                                
             ,GL_INTRFCE_SEQ_NO                                         
             ,ALLOCATION_PCT                                            
             ,COMPANY_IND                                               
             ,RESOURCE_CD                                               
             ,ACTIVITY_CD                                               
             ,GL_INTRFCE_ACCT_NO                                        
             ,BUSINESS_UNIT                                             
             ,COST_CENTER                                               
             ,CUSTOMER_CD                                               
             ,COST_CENTER_IND                                           
             ,OPERATING_UNIT                                            
                FROM #CSR04551_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C2 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE_2J2N                                                  
MFA-TR*      ,GL_ACCT_NO                                                        
MFA-TR*      ,GL_INTRFCE_SEQ_NO                                                 
MFA-TR*      ,ALLOCATION_PCT                                                    
MFA-TR*      ,COMPANY_IND                                                       
MFA-TR*      ,RESOURCE_CD                                                       
MFA-TR*      ,ACTIVITY_CD                                                       
MFA-TR*      ,GL_INTRFCE_ACCT_NO                                                
MFA-TR*      ,BUSINESS_UNIT                                                     
MFA-TR*      ,COST_CENTER                                                       
MFA-TR*      ,CUSTOMER_CD                                                       
MFA-TR*      ,COST_CENTER_IND                                                   
MFA-TR*      ,OPERATING_UNIT                                                    
MFA-TR*         FROM SESSION.CSR04551_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100C-DECLARE-GTT.                                              *        
      *      DECLARE CURSORT FOR RESULT SET 3.                         *        
      ******************************************************************        
       0100C-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04551_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04551_R3
              (                                                        
                   RETURN_CODE_GL          INT                      
                  ,GL_ACCT_NO_GL           DECIMAL(7,4)                
                  ,GL_LOCAL_OFFICE CHAR(3)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_CODE_ACCT_STATUS CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_DTL_CNTL_IND CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000C-DELETE-GTT-ROWS THRU 8000C-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS-3      
                  MOVE 100                  TO S-RETURN-CODE-GL         
                  ADD 1                     TO CTR-ROWS-RS3             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100C'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04551_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C3 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE_GL                                            
             ,GL_ACCT_NO_GL                                             
             ,GL_LOCAL_OFFICE                                           
             ,GL_CODE_ACCT_STATUS                                       
             ,GL_DTL_CNTL_IND                                           
                FROM #CSR04551_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C3 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE_GL                                                    
MFA-TR*      ,GL_ACCT_NO_GL                                                     
MFA-TR*      ,GL_LOCAL_OFFICE                                                   
MFA-TR*      ,GL_CODE_ACCT_STATUS                                               
MFA-TR*      ,GL_DTL_CNTL_IND                                                   
MFA-TR*         FROM SESSION.CSR04551_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100D-DECLARE-GTT.                           *                           
      *      DECLARE CURSORT FOR RESULT SET 4.                         *        
      ******************************************************************        
       0100D-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04551_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04551_R4
              (                                                        
                   RETURN_CODE_2J          INT                      
                  ,GL_INTRFCE_SEQ_NO_2J    SMALLINT                     
                  ,COMPANY_IND_2J CHAR(2)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,RESOURCE_CD_2J CHAR(3)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,ACTIVITY_CD_2J CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_INTRFCE_ACCT_NO_2J   DECIMAL(7,4)                
                  ,BUSINESS_UNIT_2J CHAR(5)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,COST_CENTER_2J CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,CUSTOMER_CD_2J CHAR(3)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,COST_CENTER_IND_2J CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,OPERATING_UNIT_2J CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000D-DELETE-GTT-ROWS THRU 8000D-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS-4      
                  MOVE 100                  TO S-RETURN-CODE-2J         
                  ADD 1                     TO CTR-ROWS-RS4             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100D'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04551_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C4 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE_2J                                            
             ,GL_INTRFCE_SEQ_NO_2J                                      
             ,COMPANY_IND_2J                                            
             ,RESOURCE_CD_2J                                            
             ,ACTIVITY_CD_2J                                            
             ,GL_INTRFCE_ACCT_NO_2J                                     
             ,BUSINESS_UNIT_2J                                          
             ,COST_CENTER_2J                                            
             ,CUSTOMER_CD_2J                                            
             ,COST_CENTER_IND_2J                                        
             ,OPERATING_UNIT_2J                                         
                FROM #CSR04551_R4                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C4 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE_2J                                                    
MFA-TR*      ,GL_INTRFCE_SEQ_NO_2J                                              
MFA-TR*      ,COMPANY_IND_2J                                                    
MFA-TR*      ,RESOURCE_CD_2J                                                    
MFA-TR*      ,ACTIVITY_CD_2J                                                    
MFA-TR*      ,GL_INTRFCE_ACCT_NO_2J                                             
MFA-TR*      ,BUSINESS_UNIT_2J                                                  
MFA-TR*      ,COST_CENTER_2J                                                    
MFA-TR*      ,CUSTOMER_CD_2J                                                    
MFA-TR*      ,COST_CENTER_IND_2J                                                
MFA-TR*      ,OPERATING_UNIT_2J                                                 
MFA-TR*         FROM SESSION.CSR04551_R4                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *      EVALUVATE PARM TO DECIDE ON WHAT DATA TO RETURN.          *        
      ******************************************************************        
       1000-PROCESS.                                                    
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF I-GL-ACCT-NO GREATER THAN SPACES                          
              MOVE I-GL-ACCT-NO              TO PARM-GL-ACCT-NO         
              MOVE PARM-GL-ACCT-NO-VAL(1:3)  TO WS-DECIMAL-3V4-INT      
              MOVE PARM-GL-ACCT-NO-VAL(5:4)  TO WS-DECIMAL-3V4-FRA      
              MOVE WS-DECIMAL-3V4-FMT        TO WS-DECIMAL-3V4-NUM      
              MOVE WS-DECIMAL-3V4            TO GO-GL-ACCT-NO           
                                                GL-GL-ACCT-NO           
           END-IF                                                       
                                                                        
           EVALUATE I-PROCESS-CD                                        
           WHEN 'ALL'                                                   
              MOVE 'N'                            TO WS-NO-MORE-GO-ROWS 
              PERFORM 7000-OPEN-GO-CURSOR         THRU 7000-EXIT        
              PERFORM 7050-FETCH-GO-CURSOR        THRU 7050-EXIT        
              PERFORM 2050-PROCESS-GO             THRU 2050-EXIT        
                                                  UNTIL NO-MORE-GO-ROWS 
              PERFORM 7080-CLOSE-GO-CURSOR        THRU 7080-EXIT        
              PERFORM 2400-DUMP-2J2N              THRU 2400-EXIT        
              INITIALIZE GTT-RETURN-FIELDS-3                            
                         GTT-RETURN-FIELDS-4                            
              MOVE 0                              TO S-RETURN-CODE-GL   
                                                     S-RETURN-CODE-2J   
              PERFORM 8300-SEND-GL-RESULT         THRU 8300-EXIT        
              PERFORM 8400-SEND-2J-RESULT         THRU 8400-EXIT        
           WHEN 'LOC'                                                   
              MOVE 'N'                            TO WS-NO-MORE-GL-ROWS 
              PERFORM 7100-OPEN-GL-CURSOR         THRU 7100-EXIT        
              PERFORM 7150-FETCH-GL-CURSOR        THRU 7150-EXIT        
              PERFORM 2100-PROCESS-GL             THRU 2100-EXIT        
                                                  UNTIL NO-MORE-GL-ROWS 
              PERFORM 7180-CLOSE-GL-CURSOR        THRU 7180-EXIT        
              INITIALIZE GTT-RETURN-FIELDS-1                            
                         GTT-RETURN-FIELDS-2                            
                         GTT-RETURN-FIELDS-4                            
              MOVE 0                              TO  S-RETURN-CODE-GO  
                                                      S-RETURN-CODE-2J2N
                                                      S-RETURN-CODE-2J  
              PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT        
              PERFORM 8200-SEND-2J2N-RESULT       THRU 8200-EXIT        
              PERFORM 8400-SEND-2J-RESULT         THRU 8400-EXIT        
           WHEN 'DTL'                                                   
              PERFORM 7010-SELECT-GO              THRU 7010-EXIT        
              INITIALIZE GTT-RETURN-FIELDS-3                            
                         GTT-RETURN-FIELDS-4                            
              MOVE 0                              TO S-RETURN-CODE-GL   
                                                     S-RETURN-CODE-2J   
              PERFORM 8300-SEND-GL-RESULT         THRU 8300-EXIT        
              PERFORM 8400-SEND-2J-RESULT         THRU 8400-EXIT        
           WHEN 'INT'                                                   
              MOVE 'N'                            TO WS-NO-MORE-2J-ROWS 
              PERFORM 7600-OPEN-INTFCE-2J         THRU 7600-EXIT        
              PERFORM 7650-FETCH-INTFCE-2J        THRU 7650-EXIT        
              PERFORM 2500-PROCESS-INTFCE-2J      THRU 2500-EXIT        
                                                  UNTIL NO-MORE-2J-ROWS 
              PERFORM 7680-CLOSE-INTFCE-2J        THRU 7680-EXIT        
              INITIALIZE GTT-RETURN-FIELDS-1                            
                         GTT-RETURN-FIELDS-2                            
                         GTT-RETURN-FIELDS-3                            
              MOVE 0                              TO  S-RETURN-CODE-GO  
                                                      S-RETURN-CODE-2J2N
                                                      S-RETURN-CODE-GL  
              PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT        
              PERFORM 8200-SEND-2J2N-RESULT       THRU 8200-EXIT        
              PERFORM 8300-SEND-GL-RESULT         THRU 8300-EXIT        
           WHEN OTHER                                                   
              CONTINUE                                                  
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2050-PROCESS-GO.                                              *        
      *       PROCESS DATA FROM CSS_GL_ACCT_NO                         *        
      ******************************************************************        
       2050-PROCESS-GO.                                                 
                                                                        
           MOVE '2050'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           MOVE GO-GL-ACCT-NO                  TO GL-GL-ACCT-NO         
                                                  2N-GL-ACCT-NO.        
           IF WS-NULL-IND1 < 0 THEN                                     
              MOVE ZEROES                      TO GO-ACCT-BALANCE-HI    
           END-IF.                                                      
           IF WS-NULL-IND2 < 0 THEN                                     
              MOVE ZEROES                      TO GO-ACCT-BALANCE-LO    
           END-IF.                                                      
           MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE-GO.     
           MOVE GO-GL-ACCT-NO                  TO S-GL-ACCT-NO-GO       
                                                  GL-GL-ACCT-NO.        
           IF GO-CODE-UTIL-TYPE > SPACES                                
              MOVE GO-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE      
           ELSE                                                         
              MOVE 'N'                         TO S-CODE-UTIL-TYPE      
           END-IF.                                                      
           MOVE GO-GL-ACCT-TYPE                TO S-GL-ACCT-TYPE.       
           MOVE GO-GL-ACCT-CLASS               TO S-GL-ACCT-CLASS.      
           MOVE GO-ACCT-BALANCE-HI             TO S-ACCT-BALANCE-HI.    
           MOVE GO-ACCT-BALANCE-LO             TO S-ACCT-BALANCE-LO.    
           MOVE GO-MONITOR-FL                  TO S-MONITOR-FL.         
           MOVE GO-WRITE-OFF-FL                TO S-WRITE-OFF-FL.       
           MOVE GO-EXTERNAL-DISP-FL            TO S-EXTERNAL-DISP-FL.   
           MOVE GO-GL-INTRFCE-ID               TO S-GL-INTRFCE-ID.      
           MOVE GO-GL-ACCT-NAME                TO S-GL-ACCT-NAME.       
           MOVE GO-GL-ACCT-NAME-DESC           TO S-GL-ACCT-NAME-DESC.  
           MOVE 'N'                            TO S-ALLOW-DELETE-FL.    
      * CHECK IF THE GL CAN BE DELETED                                          
           PERFORM 7500-CHECK-GL-MONTHLY-TOT THRU 7500-EXIT             
           IF WS-COUNT-MNTLY-TOT = 0                                    
              MOVE 'Y'                      TO S-ALLOW-DELETE-FL        
           END-IF.                                                      
           PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT.          
           PERFORM 7050-FETCH-GO-CURSOR        THRU 7050-EXIT.          
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2100-PROCESS-GL.                                              *        
      *       PROCESS DATA FROM CSS_GL_ACCOUNT.                        *        
      ******************************************************************        
       2100-PROCESS-GL.                                                 
                                                                        
           MOVE '2100'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE-GL.     
           MOVE GL-GL-ACCT-NO                  TO S-GL-ACCT-NO-GL.      
           MOVE GL-LOCAL-OFFICE                TO S-LOCAL-OFFICE.       
           MOVE GL-CODE-ACCT-STATUS            TO S-CODE-ACCT-STATUS.   
           MOVE GL-GL-DTL-CNTL-IND             TO S-GL-DTL-CNTL-IND.    
                                                                        
           PERFORM 8300-SEND-GL-RESULT         THRU 8300-EXIT.          
                                                                        
           PERFORM 7150-FETCH-GL-CURSOR        THRU 7150-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2200-PROCESS-2J2N.                                            *        
      *       GET DATA FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ         *        
      ******************************************************************        
       2200-PROCESS-2J2N.                                               
                                                                        
           MOVE '2200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE 'N'                            TO WS-NO-MORE-2J2N-ROWS. 
           PERFORM 7200-OPEN-2J2N-CURSOR       THRU 7200-EXIT.          
           PERFORM 7250-FETCH-2J2N-CURSOR      THRU 7250-EXIT.          
           PERFORM 2250-PROCESS-2J2N           THRU 2250-EXIT           
                                               UNTIL NO-MORE-2J2N-ROWS. 
           PERFORM 7280-CLOSE-2J2N-CURSOR      THRU 7280-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  2250-PROCESS-2J2N.                                            *        
      *       PROCESS DATA FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ     *        
      ******************************************************************        
       2250-PROCESS-2J2N.                                               
                                                                        
           MOVE '2250'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE-2J2N    
           MOVE 2N-GL-ACCT-NO                  TO S-GL-ACCT-NO-2N       
           MOVE 2N-ALLOCATION-PCT              TO S-ALLOCATION-PCT      
           MOVE 2N-GL-INTRFCE-SEQ-NO           TO S-GL-INTRFCE-SEQ-NO   
           MOVE 2J-COMPANY-IND                 TO S-COMPANY-IND         
           MOVE 2J-RESOURCE-CD                 TO S-RESOURCE-CD         
           MOVE 2J-ACTIVITY-CD                 TO S-ACTIVITY-CD         
           MOVE 2J-GL-INTRFCE-ACCT-NO          TO S-GL-INTRFCE-ACCT-NO  
           MOVE 2J-BUSINESS-UNIT               TO S-BUSINESS-UNIT       
           MOVE 2J-COST-CENTER                 TO S-COST-CENTER         
           MOVE 2J-CUSTOMER-CD                 TO S-CUSTOMER-CD         
           MOVE 2J-COST-CENTER-IND             TO S-COST-CENTER-IND     
           MOVE 2J-OPERATING-UNIT              TO S-OPERATING-UNIT      
                                                                        
           PERFORM 8200-SEND-2J2N-RESULT       THRU 8200-EXIT.          
           PERFORM 7250-FETCH-2J2N-CURSOR      THRU 7250-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2400-DUMP-2J2N.                                               *        
      *       DUMP ALL ROWS FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ    *        
      ******************************************************************        
       2400-DUMP-2J2N.                                                  
                                                                        
           MOVE '2400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE 'N'                            TO WS-NO-MORE-2J2N-ROWS. 
           PERFORM 7400-OPEN-INTFCE-SEQ        THRU 7400-EXIT.          
           PERFORM 7450-FETCH-INTFCE-SEQ       THRU 7450-EXIT.          
           PERFORM 2450-PROCESS-INTFCE-SEQ     THRU 2450-EXIT           
                                               UNTIL NO-MORE-2J2N-ROWS. 
           PERFORM 7480-CLOSE-INFCE-CUR        THRU 7480-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  2450-PROCESS-INTFCE-SEQ.                                      *        
      *    MOVE ROWS FROM CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ TO RESULT *        
      ******************************************************************        
       2450-PROCESS-INTFCE-SEQ.                                         
                                                                        
           MOVE '2450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE-2J2N    
           MOVE 2N-GL-ACCT-NO                  TO S-GL-ACCT-NO-2N       
           MOVE 2N-ALLOCATION-PCT              TO S-ALLOCATION-PCT      
           MOVE 2N-GL-INTRFCE-SEQ-NO           TO S-GL-INTRFCE-SEQ-NO   
           MOVE 2J-COMPANY-IND                 TO S-COMPANY-IND         
           MOVE 2J-RESOURCE-CD                 TO S-RESOURCE-CD         
           MOVE 2J-ACTIVITY-CD                 TO S-ACTIVITY-CD         
           MOVE 2J-GL-INTRFCE-ACCT-NO          TO S-GL-INTRFCE-ACCT-NO  
           MOVE 2J-BUSINESS-UNIT               TO S-BUSINESS-UNIT       
           MOVE 2J-COST-CENTER                 TO S-COST-CENTER         
           MOVE 2J-CUSTOMER-CD                 TO S-CUSTOMER-CD         
           MOVE 2J-COST-CENTER-IND             TO S-COST-CENTER-IND     
           MOVE 2J-OPERATING-UNIT              TO S-OPERATING-UNIT      
                                                                        
           PERFORM 8200-SEND-2J2N-RESULT       THRU 8200-EXIT.          
           PERFORM 7450-FETCH-INTFCE-SEQ       THRU 7450-EXIT.          
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2500-PROCESS-INTFCE-2J.                                       *        
      *       PROCESS DATA FROM CSS_GL_INTRFCE_SEQ                     *        
      ******************************************************************        
       2500-PROCESS-INTFCE-2J.                                          
                                                                        
           MOVE '2500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE-2J       
           MOVE 2J-GL-INTRFCE-SEQ-NO          TO S-GL-INTRFCE-SEQ-NO-2J 
           MOVE 2J-COMPANY-IND                TO S-COMPANY-IND-2J       
           MOVE 2J-RESOURCE-CD                TO S-RESOURCE-CD-2J       
           MOVE 2J-ACTIVITY-CD                TO S-ACTIVITY-CD-2J       
           MOVE 2J-GL-INTRFCE-ACCT-NO         TO S-GL-INTRFCE-ACCT-NO-2J
           MOVE 2J-BUSINESS-UNIT              TO S-BUSINESS-UNIT-2J     
           MOVE 2J-COST-CENTER                TO S-COST-CENTER-2J       
           MOVE 2J-CUSTOMER-CD                TO S-CUSTOMER-CD-2J       
           MOVE 2J-COST-CENTER-IND            TO S-COST-CENTER-IND-2J   
           MOVE 2J-OPERATING-UNIT             TO S-OPERATING-UNIT-2J    
                                                                        
           PERFORM 8400-SEND-2J-RESULT        THRU 8400-EXIT.           
           PERFORM 7650-FETCH-INTFCE-2J        THRU 7650-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-GO-CURSOR                                          *          
      *      OPEN CURSOR FOR TABLE CSS_GL_ACCT_NO.                   *          
      ****************************************************************          
                                                                        
       7000-OPEN-GO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN GO-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-1           
              MOVE 100                 TO S-RETURN-CODE-GO              
              ADD 1                    TO CTR-ROWS-RS1                  
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_GL_ACCT_NO   ' TO TABLE-1                       
              MOVE 'GO_GO_ACCT_NO'     TO TABLE-ELEMENT-1               
              MOVE GO-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7010-SELECT-GO                                               *          
      *      SELECT DATA FROM TABLE CSS_GL_ACCT_NO.                  *          
      ****************************************************************          
                                                                        
       7010-SELECT-GO.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT GO.GL_ACCT_NO                                      
                     ,GO.CODE_UTIL_TYPE                                 
                     ,GO.GL_ACCT_TYPE                                   
                     ,GO.GL_ACCT_CLASS                                  
                     ,GO.ACCT_BALANCE_HI                                
                     ,GO.ACCT_BALANCE_LO                                
                     ,GO.MONITOR_FL                                     
                     ,GO.WRITE_OFF_FL                                   
                     ,GO.EXTERNAL_DISP_FL                               
                     ,GO.GL_INTRFCE_ID                                  
                     ,GO.GL_ACCT_NAME                                   
                     ,GO.GL_ACCT_NAME_DESC                              
                INTO :GO-GL-ACCT-NO                                     
                    ,:GO-CODE-UTIL-TYPE                                 
                    ,:GO-GL-ACCT-TYPE                                   
                    ,:GO-GL-ACCT-CLASS                                  
                    ,:GO-ACCT-BALANCE-HI :WS-NULL-IND1                   
                    ,:GO-ACCT-BALANCE-LO :WS-NULL-IND2                   
                    ,:GO-MONITOR-FL                                     
                    ,:GO-WRITE-OFF-FL                                   
                    ,:GO-EXTERNAL-DISP-FL                               
                    ,:GO-GL-INTRFCE-ID                                  
                    ,:GO-GL-ACCT-NAME                                   
                    ,:GO-GL-ACCT-NAME-DESC                              
                 FROM CSS_GL_ACCT_NO GO WITH(READUNCOMMITTED)                   
                 WHERE  GO.GL_ACCT_NO = :GO-GL-ACCT-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GO.GL_ACCT_NO                                              
MFA-TR*              ,GO.CODE_UTIL_TYPE                                         
MFA-TR*              ,GO.GL_ACCT_TYPE                                           
MFA-TR*              ,GO.GL_ACCT_CLASS                                          
MFA-TR*              ,GO.ACCT_BALANCE_HI                                        
MFA-TR*              ,GO.ACCT_BALANCE_LO                                        
MFA-TR*              ,GO.MONITOR_FL                                             
MFA-TR*              ,GO.WRITE_OFF_FL                                           
MFA-TR*              ,GO.EXTERNAL_DISP_FL                                       
MFA-TR*              ,GO.GL_INTRFCE_ID                                          
MFA-TR*              ,GO.GL_ACCT_NAME                                           
MFA-TR*              ,GO.GL_ACCT_NAME_DESC                                      
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*             ,:GO-CODE-UTIL-TYPE                                         
MFA-TR*             ,:GO-GL-ACCT-TYPE                                           
MFA-TR*             ,:GO-GL-ACCT-CLASS                                          
MFA-TR*             ,:GO-ACCT-BALANCE-HI:WS-NULL-IND1                           
MFA-TR*             ,:GO-ACCT-BALANCE-LO:WS-NULL-IND2                           
MFA-TR*             ,:GO-MONITOR-FL                                             
MFA-TR*             ,:GO-WRITE-OFF-FL                                           
MFA-TR*             ,:GO-EXTERNAL-DISP-FL                                       
MFA-TR*             ,:GO-GL-INTRFCE-ID                                          
MFA-TR*             ,:GO-GL-ACCT-NAME                                           
MFA-TR*             ,:GO-GL-ACCT-NAME-DESC                                      
MFA-TR*          FROM CSS_GL_ACCT_NO GO                                         
MFA-TR*          WHERE  GO.GL_ACCT_NO = :GO-GL-ACCT-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE GO-GL-ACCT-NO             TO GL-GL-ACCT-NO          
                                                 2N-GL-ACCT-NO          
                                                                        
               IF WS-NULL-IND1 < 0 THEN                                 
                  MOVE ZEROES                      TO GO-ACCT-BALANCE-HI
               END-IF                                                   
               IF WS-NULL-IND2 < 0 THEN                                 
                  MOVE ZEROES                      TO GO-ACCT-BALANCE-LO
               END-IF                                                   
               MOVE WS-ACTIVE-RETURN-CODE          TO S-RETURN-CODE-GO  
               MOVE GO-GL-ACCT-NO                  TO S-GL-ACCT-NO-GO   
               IF GO-CODE-UTIL-TYPE > SPACES                            
                  MOVE GO-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE  
               ELSE                                                     
                  MOVE 'N'                         TO S-CODE-UTIL-TYPE  
               END-IF                                                   
               MOVE GO-GL-ACCT-TYPE                TO S-GL-ACCT-TYPE    
               MOVE GO-GL-ACCT-CLASS               TO S-GL-ACCT-CLASS   
               MOVE GO-ACCT-BALANCE-HI             TO S-ACCT-BALANCE-HI 
               MOVE GO-ACCT-BALANCE-LO             TO S-ACCT-BALANCE-LO 
               MOVE GO-MONITOR-FL                  TO S-MONITOR-FL      
               MOVE GO-WRITE-OFF-FL                TO S-WRITE-OFF-FL    
               MOVE GO-EXTERNAL-DISP-FL            TO S-EXTERNAL-DISP-FL
               MOVE GO-GL-INTRFCE-ID               TO S-GL-INTRFCE-ID   
               MOVE GO-GL-ACCT-NAME                TO S-GL-ACCT-NAME    
               MOVE GO-GL-ACCT-NAME-DESC          TO S-GL-ACCT-NAME-DESC
               PERFORM 2200-PROCESS-2J2N           THRU 2200-EXIT       
               MOVE 'N'                            TO S-ALLOW-DELETE-FL 
               PERFORM 7500-CHECK-GL-MONTHLY-TOT THRU 7500-EXIT         
               IF WS-COUNT-MNTLY-TOT = 0                                
                  MOVE 'Y'                      TO S-ALLOW-DELETE-FL    
               END-IF                                                   
               PERFORM 8100-SEND-GO-RESULT  THRU 8100-EXIT              
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-1           
              MOVE 100                 TO S-RETURN-CODE-GO              
              PERFORM 8100-SEND-GO-RESULT THRU 8100-EXIT                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_GL_ACCT_NO   ' TO TABLE-1                       
              MOVE 'GO_GO_ACCT_NO'     TO TABLE-ELEMENT-1               
              MOVE GO-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-FETCH-GO-CURSOR.                                          *        
      *   FETCH THE DATA FROM CSS_GL_ACCT_NO                           *        
      ******************************************************************        
       7050-FETCH-GO-CURSOR.                                            
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH GO-CURSOR                                           
                INTO :GO-GL-ACCT-NO                                     
                    ,:GO-CODE-UTIL-TYPE                                 
                    ,:GO-GL-ACCT-TYPE                                   
                    ,:GO-GL-ACCT-CLASS                                  
                    ,:GO-ACCT-BALANCE-HI :WS-NULL-IND1                   
                    ,:GO-ACCT-BALANCE-LO :WS-NULL-IND2                   
                    ,:GO-MONITOR-FL                                     
                    ,:GO-WRITE-OFF-FL                                   
                    ,:GO-EXTERNAL-DISP-FL                               
                    ,:GO-GL-INTRFCE-ID                                  
                    ,:GO-GL-ACCT-NAME                                   
                    ,:GO-GL-ACCT-NAME-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-GO-ROWS       
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  INITIALIZE                   GTT-RETURN-FIELDS-1      
                  MOVE 100                  TO S-RETURN-CODE-GO         
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7050'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                  
                  MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-1          
                  MOVE GL-GL-ACCT-NO        TO HOSTVAR-ELEMENT-1-N      
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7080-CLOSE-GO-CURSOR.                                        *          
      *   CLOSE CURSOR OPENED FOR CSS_GL_ACCT_NO                     *          
      ****************************************************************          
                                                                        
       7080-CLOSE-GO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE GO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-1           
              MOVE 100                 TO S-RETURN-CODE-GO              
              ADD 1                    TO CTR-ROWS-RS1                  
              PERFORM 8100-SEND-GO-RESULT THRU 8100-EXIT                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7080'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_GL_ACCT_NO'    TO TABLE-1                       
              MOVE 'GL_ACCT_NAME'      TO TABLE-ELEMENT-1               
              MOVE GO-GL-ACCT-NAME     TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE GO-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-OPEN-GL-CURSOR                                          *          
      *   OPEN CURSOR OPENED FOR CSS_GL_ACCOUNT                      *          
      ****************************************************************          
                                                                        
       7100-OPEN-GL-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN GL-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS-3           
              MOVE 100                 TO S-RETURN-CODE-GL              
              ADD 1                    TO CTR-ROWS-RS3                  
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'GL_ACCT_NO'        TO TABLE-ELEMENT-1               
              MOVE GL-GL-ACCT-NO       TO HOSTVAR-ELEMENT-1-N           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-GL-CURSOR.                                          *        
      *     GET THE DATA FROM CSS_GL_ACCOUNT                           *        
      ******************************************************************        
       7150-FETCH-GL-CURSOR.                                            
                                                                        
           MOVE '7150'                        TO ACTIVE-PARAGRAPH.      
                                                                        
                                                                        
           EXEC SQL                                                     
              FETCH GL-CURSOR                                           
                INTO :GL-LOCAL-OFFICE                                   
                    ,:GL-CODE-ACCT-STATUS                               
                    ,:GL-GL-DTL-CNTL-IND                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-GL-ROWS       
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  INITIALIZE                   GTT-RETURN-FIELDS-3      
                  MOVE 100                  TO S-RETURN-CODE-GL         
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7150'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_ACCOUNT'     TO TABLE-1                  
                  MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-1          
                  MOVE GL-GL-ACCT-NO        TO HOSTVAR-ELEMENT-1-N      
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7180-CLOSE-GL-CURSOR.                                        *          
      *   CLOSE CURSOR OPENED FOR CSS_GL_ACCOUNT                     *          
      ****************************************************************          
                                                                        
       7180-CLOSE-GL-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE GL-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                       GTT-RETURN-FIELDS-3      
              MOVE 100                      TO S-RETURN-CODE-GL         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7180'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GL_ACCOUNT'         TO TABLE-1                  
              MOVE 'GL_ACCT_NO'             TO TABLE-ELEMENT-1          
              MOVE GL-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-OPEN-2J2N-CURSOR.                                       *          
      *   CURSOR OPENED FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ       *          
      ****************************************************************          
                                                                        
       7200-OPEN-2J2N-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN 2J2N-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS-2          
              MOVE 100                  TO S-RETURN-CODE-2J2N           
              ADD 1                     TO CTR-ROWS-RS2                 
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1              
              MOVE 2N-GL-ACCT-NO         TO HOSTVAR-ELEMENT-1-N         
              MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-ELEMENT-2              
              MOVE 2J-GL-INTRFCE-SEQ-NO TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-FETCH-2J2N-CURSOR.                                        *        
      *   GET DATA FROM FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ         *        
      ******************************************************************        
       7250-FETCH-2J2N-CURSOR.                                          
                                                                        
           MOVE '7250'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH 2J2N-CURSOR                                         
                INTO :2N-GL-ACCT-NO                                     
                    ,:2N-GL-INTRFCE-SEQ-NO                              
                    ,:2N-ALLOCATION-PCT                                 
                    ,:2J-COMPANY-IND                                    
                    ,:2J-RESOURCE-CD                                    
                    ,:2J-ACTIVITY-CD                                    
                    ,:2J-GL-INTRFCE-ACCT-NO                             
                    ,:2J-BUSINESS-UNIT                                  
                    ,:2J-COST-CENTER                                    
                    ,:2J-CUSTOMER-CD                                    
                    ,:2J-COST-CENTER-IND                                
                    ,:2J-OPERATING-UNIT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-2J2N-ROWS     
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  INITIALIZE                   GTT-RETURN-FIELDS-2      
                  MOVE 100                  TO S-RETURN-CODE-2J2N       
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7250'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1          
                  MOVE 2N-GL-ACCT-NO         TO HOSTVAR-ELEMENT-1-N     
                  MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-ELEMENT-2          
                  MOVE 2J-GL-INTRFCE-SEQ-NO TO HOSTVAR-ELEMENT-2        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7280-CLOSE-2J2N-CURSOR.                                      *          
      *   CLOSE CURSOR OPENED FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ *          
      ****************************************************************          
                                                                        
       7280-CLOSE-2J2N-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE 2J2N-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS-2          
              MOVE 100                      TO S-RETURN-CODE-2J2N       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GL_INTRFCE'         TO TABLE-ELEMENT-1          
              MOVE 2N-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N      
              MOVE 'CSS_GL_INTRFCE_SEQ'     TO TABLE-ELEMENT-2          
              MOVE 2J-GL-INTRFCE-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-OPEN-INTFCE-SEQ.                                        *          
      *   CURSOR OPENED FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ       *          
      ****************************************************************          
                                                                        
       7400-OPEN-INTFCE-SEQ.                                            
                                                                        
           EXEC SQL                                                     
              OPEN INTFCE-SEQ                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS-2          
              MOVE 100                  TO S-RETURN-CODE-2J2N           
              ADD 1                     TO CTR-ROWS-RS2                 
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1              
              MOVE 2N-GL-ACCT-NO         TO HOSTVAR-ELEMENT-1-N         
              MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-ELEMENT-2              
              MOVE 2J-GL-INTRFCE-SEQ-NO TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7450-FETCH-INTFCE-SEQ.                                         *        
      *   GET DATA FROM FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ         *        
      ******************************************************************        
       7450-FETCH-INTFCE-SEQ.                                           
                                                                        
           MOVE '7450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH INTFCE-SEQ                                          
                INTO :2N-GL-ACCT-NO                                     
                    ,:2N-GL-INTRFCE-SEQ-NO                              
                    ,:2N-ALLOCATION-PCT                                 
                    ,:2J-COMPANY-IND                                    
                    ,:2J-RESOURCE-CD                                    
                    ,:2J-ACTIVITY-CD                                    
                    ,:2J-GL-INTRFCE-ACCT-NO                             
                    ,:2J-BUSINESS-UNIT                                  
                    ,:2J-COST-CENTER                                    
                    ,:2J-CUSTOMER-CD                                    
                    ,:2J-COST-CENTER-IND                                
                    ,:2J-OPERATING-UNIT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-2J2N-ROWS     
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  INITIALIZE                   GTT-RETURN-FIELDS-2      
                  MOVE 100                  TO S-RETURN-CODE-2J2N       
                  ADD 1                     TO CTR-ROWS-RS2             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7450'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1          
                  MOVE 2N-GL-ACCT-NO         TO HOSTVAR-ELEMENT-1-N     
                  MOVE 'CSS_GL_INTRFCE_SEQ' TO TABLE-ELEMENT-2          
                  MOVE 2J-GL-INTRFCE-SEQ-NO TO HOSTVAR-ELEMENT-2        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7480-CLOSE-INTFCE-SEQ.                                       *          
      *   CLOSE CURSOR OPENED FOR CSS_GL_INTRFCE, CSS_GL_INTRFCE_SEQ *          
      ****************************************************************          
                                                                        
       7480-CLOSE-INFCE-CUR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE INTFCE-SEQ                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                       GTT-RETURN-FIELDS-2      
              MOVE 100                      TO S-RETURN-CODE-2J2N       
              ADD 1                         TO CTR-ROWS-RS2             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7480'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GL_INTRFCE'         TO TABLE-ELEMENT-1          
              MOVE 2N-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N      
              MOVE 'CSS_GL_INTRFCE_SEQ'     TO TABLE-ELEMENT-2          
              MOVE 2J-GL-INTRFCE-SEQ-NO     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************83130036
      *   7500-CHECK-GL-MONTHLY-TOT.                                  **83140036
      *        CHECK IF A ROW EXISTS FOR GL IN CSS_GL_MNTHLY_TOT.     **83150036
      ******************************************************************83160036
       7500-CHECK-GL-MONTHLY-TOT.                                       
                                                                        
           MOVE 0                       TO WS-COUNT-MNTLY-TOT           
           MOVE '01'                    TO GY-COMPANY-NO                
           MOVE GO-GL-ACCT-NO           TO GY-GL-ACCT-NO                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                 INTO :WS-COUNT-MNTLY-TOT                               
                 FROM CSS_GL_MNTHLY_TOT WITH(READUNCOMMITTED)                   
                WHERE COMPANY_NO = :GY-COMPANY-NO                       
                  AND GL_ACCT_NO = :GY-GL-ACCT-NO                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     83210036
MFA-TR*        SELECT 1                                                 83220036
MFA-TR*          INTO :WS-COUNT-MNTLY-TOT                               83230036
MFA-TR*          FROM CSS_GL_MNTHLY_TOT                                 83240036
MFA-TR*         WHERE COMPANY_NO = :GY-COMPANY-NO                       83250036
MFA-TR*           AND GL_ACCT_NO = :GY-GL-ACCT-NO                       83250036
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                    83270036

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    INITIALIZE                       GTT-RETURN-FIELDS-4
                    MOVE 100                      TO S-RETURN-CODE-2J   
                    ADD 1                         TO CTR-ROWS-RS4       
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE '7500'                   TO ACTIVE-PARAGRAPH   
                    MOVE 'SELECT'                 TO ABEND-FUNCTION     
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CSS_GL_MNTHLY_TOT'      TO TABLE-ELEMENT-1    
                    MOVE GY-GL-ACCT-NO            TO HOSTVAR-ELEMENT-1-N
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7600-OPEN-INTFCE-2J.                                         *          
      *   CURSOR OPENED FOR CSS_GL_INTRFCE                           *          
      ****************************************************************          
                                                                        
       7600-OPEN-INTFCE-2J.                                             
                                                                        
           EXEC SQL                                                     
              OPEN INTFCE-2J                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS-4          
              MOVE 100                  TO S-RETURN-CODE-2J             
              ADD 1                     TO CTR-ROWS-RS4                 
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-FETCH-INTFCE-2J.                                          *        
      *   GET DATA FROM CSS_GL_INTRFCE                                 *        
      ******************************************************************        
       7650-FETCH-INTFCE-2J.                                            
                                                                        
           MOVE '7650'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH INTFCE-2J                                           
                INTO :2J-GL-INTRFCE-SEQ-NO                              
                    ,:2J-COMPANY-IND                                    
                    ,:2J-RESOURCE-CD                                    
                    ,:2J-ACTIVITY-CD                                    
                    ,:2J-GL-INTRFCE-ACCT-NO                             
                    ,:2J-BUSINESS-UNIT                                  
                    ,:2J-COST-CENTER                                    
                    ,:2J-CUSTOMER-CD                                    
                    ,:2J-COST-CENTER-IND                                
                    ,:2J-OPERATING-UNIT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-2J-ROWS       
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  INITIALIZE                   GTT-RETURN-FIELDS-4      
                  MOVE 100                  TO S-RETURN-CODE-2J         
                  ADD 1                     TO CTR-ROWS-RS4             
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7650'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_GL_INTRFCE'     TO TABLE-ELEMENT-1          
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7680-CLOSE-INTFCE-2J.                                        *          
      *   CLOSE CURSOR OPENED FOR CSS_GL_INTRFCE                     *          
      ****************************************************************          
                                                                        
       7680-CLOSE-INTFCE-2J.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE INTFCE-2J                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                       GTT-RETURN-FIELDS-4      
              MOVE 100                      TO S-RETURN-CODE-2J         
              ADD 1                         TO CTR-ROWS-RS4             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7680'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GL_INTRFCE'         TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      *       DELETE RETURN CURSOR 1.                                  *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04551_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04551_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS-1         
               MOVE 100                  TO S-RETURN-CODE-GO            
               ADD 1                     TO CTR-ROWS-RS1                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04551_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      *       DELETE RETURN CURSOR 2.                                  *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04551_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04551_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS-2         
               MOVE 100                  TO S-RETURN-CODE-2J2N          
               ADD 1                     TO CTR-ROWS-RS2                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000B'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04551_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000C-DELETE-GTT-ROWS.                                         *        
      *       DELETE RETURN CURSOR 3.                                  *        
      ******************************************************************        
       8000C-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04551_R3                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04551_R3                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS-3         
               MOVE 100                  TO S-RETURN-CODE-GL            
               ADD 1                     TO CTR-ROWS-RS3                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000C'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04551_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000D-DELETE-GTT-ROWS.                                         *        
      *       DELETE RETURN CURSOR 4.                                  *        
      ******************************************************************        
       8000D-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04551_R4                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04551_R4                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS-4         
               MOVE 100                  TO S-RETURN-CODE-2J            
               ADD 1                     TO CTR-ROWS-RS4                
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000D'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04551_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000D-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-GO-RESULT.                                           *        
      *      INSERT DATA TO CURSOR 1 TAKEN FROM CSS_GL_ACCT_NO GO      *        
      ******************************************************************        
       8100-SEND-GO-RESULT.                                             
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04551_R1                       
                  (    RETURN_CODE_GO                                   
                      ,GL_ACCT_NO_GO                                    
                      ,CODE_UTIL_TYPE                                   
                      ,GL_ACCT_TYPE                                     
                      ,GL_ACCT_CLASS                                    
                      ,ACCT_BALANCE_HI                                  
                      ,ACCT_BALANCE_LO                                  
                      ,MONITOR_FL                                       
                      ,WRITE_OFF_FL                                     
                      ,EXTERNAL_DISP_FL                                 
                      ,GL_INTRFCE_ID                                    
                      ,GL_ACCT_NAME                                     
                      ,GL_ACCT_NAME_DESC                                
                      ,ALLOW_DELETE_FL                                  
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE-GO                                   
                   ,:S-GL-ACCT-NO-GO                                    
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-GL-ACCT-TYPE                                     
                   ,:S-GL-ACCT-CLASS                                    
                   ,:S-ACCT-BALANCE-HI                                  
                   ,:S-ACCT-BALANCE-LO                                  
                   ,:S-MONITOR-FL                                       
                   ,:S-WRITE-OFF-FL                                     
                   ,:S-EXTERNAL-DISP-FL                                 
                   ,:S-GL-INTRFCE-ID                                    
                   ,:S-GL-ACCT-NAME                                     
                   ,:S-GL-ACCT-NAME-DESC                                
                   ,:S-ALLOW-DELETE-FL                                  
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04551_R1                               
MFA-TR*           (    RETURN_CODE_GO                                           
MFA-TR*               ,GL_ACCT_NO_GO                                            
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,GL_ACCT_TYPE                                             
MFA-TR*               ,GL_ACCT_CLASS                                            
MFA-TR*               ,ACCT_BALANCE_HI                                          
MFA-TR*               ,ACCT_BALANCE_LO                                          
MFA-TR*               ,MONITOR_FL                                               
MFA-TR*               ,WRITE_OFF_FL                                             
MFA-TR*               ,EXTERNAL_DISP_FL                                         
MFA-TR*               ,GL_INTRFCE_ID                                            
MFA-TR*               ,GL_ACCT_NAME                                             
MFA-TR*               ,GL_ACCT_NAME_DESC                                        
MFA-TR*               ,ALLOW_DELETE_FL                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE-GO                                           
MFA-TR*            ,:S-GL-ACCT-NO-GO                                            
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-GL-ACCT-TYPE                                             
MFA-TR*            ,:S-GL-ACCT-CLASS                                            
MFA-TR*            ,:S-ACCT-BALANCE-HI                                          
MFA-TR*            ,:S-ACCT-BALANCE-LO                                          
MFA-TR*            ,:S-MONITOR-FL                                               
MFA-TR*            ,:S-WRITE-OFF-FL                                             
MFA-TR*            ,:S-EXTERNAL-DISP-FL                                         
MFA-TR*            ,:S-GL-INTRFCE-ID                                            
MFA-TR*            ,:S-GL-ACCT-NAME                                             
MFA-TR*            ,:S-GL-ACCT-NAME-DESC                                        
MFA-TR*            ,:S-ALLOW-DELETE-FL                                          
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS-RS1                                     
           ELSE                                                         
              ADD 1 TO CTR-ROWS-RS1                                     
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE-GO             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04551_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-SEND-2J2N-RESULT.                                         *        
      *      INSERT DATA TO CURSOR 2 TAKEN FROM CSS_GL_INTRFCE         *        
      *                                         CSS_GL_INTRFCE_SEQ     *        
      ******************************************************************        
       8200-SEND-2J2N-RESULT.                                           
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04551_R2                       
                  (    RETURN_CODE_2J2N                                 
                      ,GL_ACCT_NO                                       
                      ,GL_INTRFCE_SEQ_NO                                
                      ,ALLOCATION_PCT                                   
                      ,COMPANY_IND                                      
                      ,RESOURCE_CD                                      
                      ,ACTIVITY_CD                                      
                      ,GL_INTRFCE_ACCT_NO                               
                      ,BUSINESS_UNIT                                    
                      ,COST_CENTER                                      
                      ,CUSTOMER_CD                                      
                      ,COST_CENTER_IND                                  
                      ,OPERATING_UNIT                                   
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE-2J2N                                 
                   ,:S-GL-ACCT-NO-2N                                    
                   ,:S-GL-INTRFCE-SEQ-NO                                
                   ,:S-ALLOCATION-PCT                                   
                   ,:S-COMPANY-IND                                      
                   ,:S-RESOURCE-CD                                      
                   ,:S-ACTIVITY-CD                                      
                   ,:S-GL-INTRFCE-ACCT-NO                               
                   ,:S-BUSINESS-UNIT                                    
                   ,:S-COST-CENTER                                      
                   ,:S-CUSTOMER-CD                                      
                   ,:S-COST-CENTER-IND                                  
                   ,:S-OPERATING-UNIT                                   
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04551_R2                               
MFA-TR*           (    RETURN_CODE_2J2N                                         
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,GL_INTRFCE_SEQ_NO                                        
MFA-TR*               ,ALLOCATION_PCT                                           
MFA-TR*               ,COMPANY_IND                                              
MFA-TR*               ,RESOURCE_CD                                              
MFA-TR*               ,ACTIVITY_CD                                              
MFA-TR*               ,GL_INTRFCE_ACCT_NO                                       
MFA-TR*               ,BUSINESS_UNIT                                            
MFA-TR*               ,COST_CENTER                                              
MFA-TR*               ,CUSTOMER_CD                                              
MFA-TR*               ,COST_CENTER_IND                                          
MFA-TR*               ,OPERATING_UNIT                                           
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE-2J2N                                         
MFA-TR*            ,:S-GL-ACCT-NO-2N                                            
MFA-TR*            ,:S-GL-INTRFCE-SEQ-NO                                        
MFA-TR*            ,:S-ALLOCATION-PCT                                           
MFA-TR*            ,:S-COMPANY-IND                                              
MFA-TR*            ,:S-RESOURCE-CD                                              
MFA-TR*            ,:S-ACTIVITY-CD                                              
MFA-TR*            ,:S-GL-INTRFCE-ACCT-NO                                       
MFA-TR*            ,:S-BUSINESS-UNIT                                            
MFA-TR*            ,:S-COST-CENTER                                              
MFA-TR*            ,:S-CUSTOMER-CD                                              
MFA-TR*            ,:S-COST-CENTER-IND                                          
MFA-TR*            ,:S-OPERATING-UNIT                                           
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS-RS2                                     
           ELSE                                                         
              ADD 1 TO CTR-ROWS-RS2                                     
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE-2J2N           
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04551_R2'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-SEND-GL-RESULT.                                           *        
      *      INSERT DATA TO CURSOR 3 TAKEN FROM CSS_GL_ACCOUNT GL      *        
      ******************************************************************        
       8300-SEND-GL-RESULT.                                             
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04551_R3                       
                  (    RETURN_CODE_GL                                   
                      ,GL_ACCT_NO_GL                                    
                      ,GL_LOCAL_OFFICE                                  
                      ,GL_CODE_ACCT_STATUS                              
                      ,GL_DTL_CNTL_IND                                  
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE-GL                                   
                   ,:S-GL-ACCT-NO-GL                                    
                   ,:S-LOCAL-OFFICE                                     
                   ,:S-CODE-ACCT-STATUS                                 
                   ,:S-GL-DTL-CNTL-IND                                  
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04551_R3                               
MFA-TR*           (    RETURN_CODE_GL                                           
MFA-TR*               ,GL_ACCT_NO_GL                                            
MFA-TR*               ,GL_LOCAL_OFFICE                                          
MFA-TR*               ,GL_CODE_ACCT_STATUS                                      
MFA-TR*               ,GL_DTL_CNTL_IND                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE-GL                                           
MFA-TR*            ,:S-GL-ACCT-NO-GL                                            
MFA-TR*            ,:S-LOCAL-OFFICE                                             
MFA-TR*            ,:S-CODE-ACCT-STATUS                                         
MFA-TR*            ,:S-GL-DTL-CNTL-IND                                          
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS-RS3                                     
           ELSE                                                         
              ADD 1 TO CTR-ROWS-RS3                                     
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE-GL             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04551_R3'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-SEND-2J-RESULT.                                           *        
      *      INSERT DATA TO CURSOR 4 TAKEN FROM CSS_GL_INTRFCE_SEQ 2J  *        
      ******************************************************************        
       8400-SEND-2J-RESULT.                                             
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04551_R4                       
                  (    RETURN_CODE_2J                                   
                      ,GL_INTRFCE_SEQ_NO_2J                             
                      ,COMPANY_IND_2J                                   
                      ,RESOURCE_CD_2J                                   
                      ,ACTIVITY_CD_2J                                   
                      ,GL_INTRFCE_ACCT_NO_2J                            
                      ,BUSINESS_UNIT_2J                                 
                      ,COST_CENTER_2J                                   
                      ,CUSTOMER_CD_2J                                   
                      ,COST_CENTER_IND_2J                               
                      ,OPERATING_UNIT_2J                                
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE-2J                                   
                   ,:S-GL-INTRFCE-SEQ-NO-2J                             
                   ,:S-COMPANY-IND-2J                                   
                   ,:S-RESOURCE-CD-2J                                   
                   ,:S-ACTIVITY-CD-2J                                   
                   ,:S-GL-INTRFCE-ACCT-NO-2J                            
                   ,:S-BUSINESS-UNIT-2J                                 
                   ,:S-COST-CENTER-2J                                   
                   ,:S-CUSTOMER-CD-2J                                   
                   ,:S-COST-CENTER-IND-2J                               
                   ,:S-OPERATING-UNIT-2J                                
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04551_R4                               
MFA-TR*           (    RETURN_CODE_2J                                           
MFA-TR*               ,GL_INTRFCE_SEQ_NO_2J                                     
MFA-TR*               ,COMPANY_IND_2J                                           
MFA-TR*               ,RESOURCE_CD_2J                                           
MFA-TR*               ,ACTIVITY_CD_2J                                           
MFA-TR*               ,GL_INTRFCE_ACCT_NO_2J                                    
MFA-TR*               ,BUSINESS_UNIT_2J                                         
MFA-TR*               ,COST_CENTER_2J                                           
MFA-TR*               ,CUSTOMER_CD_2J                                           
MFA-TR*               ,COST_CENTER_IND_2J                                       
MFA-TR*               ,OPERATING_UNIT_2J                                        
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE-2J                                           
MFA-TR*            ,:S-GL-INTRFCE-SEQ-NO-2J                                     
MFA-TR*            ,:S-COMPANY-IND-2J                                           
MFA-TR*            ,:S-RESOURCE-CD-2J                                           
MFA-TR*            ,:S-ACTIVITY-CD-2J                                           
MFA-TR*            ,:S-GL-INTRFCE-ACCT-NO-2J                                    
MFA-TR*            ,:S-BUSINESS-UNIT-2J                                         
MFA-TR*            ,:S-COST-CENTER-2J                                           
MFA-TR*            ,:S-CUSTOMER-CD-2J                                           
MFA-TR*            ,:S-COST-CENTER-IND-2J                                       
MFA-TR*            ,:S-OPERATING-UNIT-2J                                        
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS-RS4                                     
           ELSE                                                         
              ADD 1 TO CTR-ROWS-RS4                                     
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE-2J2N           
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04551_R4'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-1      
              MOVE   100                    TO S-RETURN-CODE-GO         
              PERFORM 8100-SEND-GO-RESULT      THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-2      
              MOVE   100                    TO S-RETURN-CODE-2J2N       
              PERFORM 8200-SEND-2J2N-RESULT    THRU 8200-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-3      
              MOVE   100                    TO S-RETURN-CODE-GL         
              PERFORM 8300-SEND-GL-RESULT    THRU 8300-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-4      
              MOVE   100                    TO S-RETURN-CODE-2J         
              PERFORM 8400-SEND-2J-RESULT    THRU 8400-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE '8900'                      TO ACTIVE-PARAGRAPH.        
           MOVE 'OPEN'                      TO ABEND-FUNCTION.          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-GO.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04551_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2J2N.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04551_R2'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-GL.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04551_R3'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2J.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04551_R4'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE                          GTT-RETURN-FIELDS.       
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
           MOVE 100                         TO S-RETURN-CODE-GO         
                                               S-RETURN-CODE-GL         
                                               S-RETURN-CODE-2J         
                                               S-RETURN-CODE-2J2N.      
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT           THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT           THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT           THRU 0100D-EXIT.         
                                                                        
           PERFORM 8100-SEND-GO-RESULT         THRU 8100-EXIT.          
           PERFORM 8200-SEND-2J2N-RESULT       THRU 8200-EXIT.          
           PERFORM 8300-SEND-GL-RESULT         THRU 8300-EXIT.          
           PERFORM 8400-SEND-2J-RESULT         THRU 8400-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
