       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04549.                                         
       DATE-WRITTEN.  06/21/2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  GETS BASE DATA FROM CSS_GL_ACCT_NO.                           *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : RequGetGLAccountsBusinessOp.                      *        
      *  INPUT     : NONE.                                             *        
      *  OUTPUT    : RETURN_CODE              INTEGER                  *        
      *              GL_ACCT_NO               CSS_GL_ACCT_NO           *        
      *              GL_ACCT_NAME             CSS_GL_ACCT_NO           *        
      *              EXTERNAL_DISP_FL         CSS_GL_ACCT_NO           *        
      *              GL_ACCT_NAME_DESC        CSS_GL_ACCT_NO           *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00641*  06/2012   RAJ        INITIAL VERSION.                         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04549'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4549 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_GL_ACCT_NO            GO                                    
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_CATEGORY              F5                                    
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  HAS-ACCESS-FL           PIC X(01) VALUE 'N'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08)      VALUE 'CSR04549'. 
       01  WS-NULL-IND1                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND2                PIC S9(4) COMP VALUE 0.          
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                PIC S9(09) COMP VALUE +0.    
           05 S-GL-ACCT-NO                 PIC S9(3)V9(4) USAGE COMP-3  
                                                           VALUE 0.     
           05 S-GL-ACCT-NAME               PIC X(10) VALUE SPACES.      
           05 S-EXTERNAL-DISP-FL           PIC X(1)  VALUE SPACE.       
           05 S-GL-ACCT-NAME-DESC          PIC X(25) VALUE SPACE.       
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE GO-CURSOR CURSOR FOR                        
            SELECT GL_ACCT_NO                                           
                  ,GL_ACCT_NAME                                         
                  ,EXTERNAL_DISP_FL                                     
                  ,GL_ACCT_NAME_DESC                                    
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE GO-CURSOR CURSOR FOR                                
MFA-TR*     SELECT GL_ACCT_NO                                                   
MFA-TR*           ,GL_ACCT_NAME                                                 
MFA-TR*           ,EXTERNAL_DISP_FL                                             
MFA-TR*           ,GL_ACCT_NAME_DESC                                            
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = 100.                        
           PERFORM 7200-CLOSE-GL-ACCT         THRU 7200-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,GL_ACCT_NO                                                
             ,GL_ACCT_NAME                                              
             ,EXTERNAL_DISP_FL                                          
             ,GL_ACCT_NAME_DESC                                         
                FROM #CSR04549_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,GL_ACCT_NO                                                        
MFA-TR*      ,GL_ACCT_NAME                                                      
MFA-TR*      ,EXTERNAL_DISP_FL                                                  
MFA-TR*      ,GL_ACCT_NAME_DESC                                                 
MFA-TR*         FROM SESSION.CSR04549_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                   GTT-RETURN-FIELDS            
              MOVE 100                  TO S-RETURN-CODE                
              ADD 1                     TO CTR-ROWS                     
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '0100A'              TO ACTIVE-PARAGRAPH             
              MOVE 'DECLARE GTT'        TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04549_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04549_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04549_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,GL_ACCT_NO              DECIMAL(7,4)                
                  ,GL_ACCT_NAME CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,EXTERNAL_DISP_FL CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,GL_ACCT_NAME_DESC CHAR(25)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04549_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04549_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04549_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04549_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7000-OPEN-GL-ACCT       THRU 7000-EXIT.              
           PERFORM 7100-FETCH-GL-ACCT      THRU 7100-EXIT.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE GO-GL-ACCT-NO             TO S-GL-ACCT-NO               
           MOVE GO-GL-ACCT-NAME           TO S-GL-ACCT-NAME             
           MOVE GO-EXTERNAL-DISP-FL       TO S-EXTERNAL-DISP-FL         
           MOVE GO-GL-ACCT-NAME-DESC      TO S-GL-ACCT-NAME-DESC        
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
           PERFORM 7100-FETCH-GL-ACCT       THRU 7100-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7000-OPEN-GL-ACCT                                            *          
      *     OPEN CURSOR FOR TABLE CSS_GL_ACCT_NO                     *          
      ****************************************************************          
                                                                        
       7000-OPEN-GL-ACCT.                                               
                                                                        
           EXEC SQL                                                     
              OPEN GO-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS             
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_GL_ACCT_NO   ' TO TABLE-1                       
              MOVE 'GL_ACCT_NAME'      TO TABLE-ELEMENT-1               
              MOVE GO-GL-ACCT-NAME        TO HOSTVAR-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE GO-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-GL-ACCT.                                            *        
      *     GET THE DATA FROM CSS_GL_ACCT_NO                           *        
      ******************************************************************        
       7100-FETCH-GL-ACCT.                                              
                                                                        
           MOVE '7110'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH GO-CURSOR                                           
                INTO :GO-GL-ACCT-NO                                     
                    ,:GO-GL-ACCT-NAME                                   
                    ,:GO-EXTERNAL-DISP-FL                               
                    ,:GO-GL-ACCT-NAME-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0 TO S-RETURN-CODE                                   
              IF WS-NULL-IND1 < 0 THEN                                  
                 MOVE ZEROES TO GO-ACCT-BALANCE-HI                      
              END-IF                                                    
              IF WS-NULL-IND2 < 0 THEN                                  
                 MOVE ZEROES TO GO-ACCT-BALANCE-LO                      
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 100 TO S-RETURN-CODE                              
                 IF CTR-ROWS = 0                                        
                    INITIALIZE                    GTT-RETURN-FIELDS     
                    MOVE 100                   TO S-RETURN-CODE         
                    MOVE GO-GL-ACCT-NO         TO S-GL-ACCT-NO          
                    PERFORM 8100-SEND-RESULT   THRU 8100-EXIT           
                    MOVE 100                   TO WS-ACTIVE-RETURN-CODE 
                 END-IF                                                 
              ELSE                                                      
                 INITIALIZE                      GTT-RETURN-FIELDS      
                 MOVE 100                     TO S-RETURN-CODE          
                 ADD 1                        TO CTR-ROWS               
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7100'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_GL_ACCT_NO'        TO TABLE-1                
                 MOVE 'GL_ACCT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2        
                 MOVE GO-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1      
                 MOVE GO-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-CLOSE-GL-ACCT.                                        *            
      *    CLOSE CURSOR FOR TABLE CSS_GL_ACCT_NO                     *          
      ****************************************************************          
                                                                        
       7200-CLOSE-GL-ACCT.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE GO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS             
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_GL_ACCT_NO'    TO TABLE-1                       
              MOVE 'GL_ACCT_NAME'      TO TABLE-ELEMENT-1               
              MOVE GO-GL-ACCT-NAME     TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE GO-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-GO-RESULT.                                           *        
      *      INSERT DATA TO CURSOR 1 TAKEN FROM CSS_GL_ACCT_NO GO      *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04549_R1                       
                  (    RETURN_CODE                                      
                      ,GL_ACCT_NO                                       
                      ,GL_ACCT_NAME                                     
                      ,EXTERNAL_DISP_FL                                 
                      ,GL_ACCT_NAME_DESC                                
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-GL-ACCT-NO                                       
                   ,:S-GL-ACCT-NAME                                     
                   ,:S-EXTERNAL-DISP-FL                                 
                   ,:S-GL-ACCT-NAME-DESC                                
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04549_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,GL_ACCT_NAME                                             
MFA-TR*               ,EXTERNAL_DISP_FL                                         
MFA-TR*               ,GL_ACCT_NAME_DESC                                        
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-GL-ACCT-NO                                               
MFA-TR*            ,:S-GL-ACCT-NAME                                             
MFA-TR*            ,:S-EXTERNAL-DISP-FL                                         
MFA-TR*            ,:S-GL-ACCT-NAME-DESC                                        
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              ADD 1 TO CTR-ROWS                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04549_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
