       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04532.                                       
       AUTHOR.       MC95456.                                           
COB303 DATE-WRITTEN. 08 NOV 2011.                                        
       DATE-COMPILED.                                                   
      *---------------------------------------------------------------- 00070000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00080000
      *---------------------------------------------------------------- 00090000
      *--                   STORED PROCEDURE:  CSR04532              -- 00100000
      *---------------------------------------------------------------- 00110000
      *--                         S U M M A R Y                      -- 00120000
      *--                                                            -- 00130000
      *--  CSR04532 :                                                -- 00140000
      *--                                                            -- 00150000
      *--  #  PROJ*254                                               -- 00160000
      *--  #  RETRIEVE OR UPDATE ACCOUNT RELATED INFORMATION BASED   -- 00161000
      *--  #  ON THE PROVIDED INPUT AND WHENEVER UPDATE OPERATION IS -- 00170000
      *--  #  DONE DETAILS SHOULD BE ENTERED IN CSS_MNT_TRANS_HIST.  -- 00180000
      *---------------------------------------------------------------- 00190000
      *--                                                            -- 00200000
      *--  PARAMETERS                                                -- 00210000
      *--                                                            -- 00220000
      *--      IN                                                    -- 00230000
      *--                                                            -- 00240000
      *--            I_APPL_PGM_ID          CHAR(07)                 -- 00250000
      *--            I_ACTION_IND           CHAR(01)                 -- 00260000
      *--            I_ACCOUNT_NO           CHAR(13)                 -- 00261000
      *--            I_SPCL_BILL_STMNT_TX   CHAR(35)                 -- 00262000
      *--            I_ADDTL_BILL_NAME_TX   CHAR(35)                 -- 00263000
      *--                                                            -- 00270000
      *--      OUT                                                   -- 00280000
      *--            NONE                                            -- 00290000
      *--                                                            -- 00300000
      *--      INOUT                                                 -- 00310000
      *--            NONE                                            -- 00320000
      *--                                                            -- 00330000
      *--  RESULT SET                                                -- 00340000
      *--                                                            -- 00350000
      *--            RETURN_CODE           INTEGER                   -- 00360000
      *--            SPCL_BILL_STMNT_TX    CHAR(35)                  -- 00410000
      *--            ADDTL_BILL_NAME_TX    CHAR(35)                  -- 00411000
      *--                                                            -- 00420000
      *---------------------------------------------------------------- 00430000
      *--                        MODIFICATION LOG                    -- 00440000
      *--                                                            -- 00450000
      *--  DATE          INITIALS    COMMENTS                        -- 00460000
      *--  -----------   --------    ---------------------------------- 00470000
P00254*--  11/08/2011    MC95456     RETRIEVE OR UPDATE ACCOUNT INFO -- 00480000
      *--                            FOR GIVEN CUSTOMER              -- 00490000
      *---------------------------------------------------------------- 00500000
      ******************************************************************00510000
      *                                                                *00520000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00530000
      *                                                                *00540000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00550000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00560000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00570000
      *  3000 - 4999  NOT USED                                         *00580000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00590000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00600000
      *  7000 - 7999  INPUT MODULES                                    *00610000
      *  8000 - 8999  OUTPUT MODULES                                   *00620000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00630000
      *                                                                *00640000
      ******************************************************************00650000
      *                                                                 00660000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00680000
       DATA DIVISION.                                                   
      *                                                                 00700000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04532'.
MSQ017     COPY MFASQLM.
       01 WS-START                     PIC X(40) VALUE                  
          'WORKING STORAGE FOR CSR04532 STARTS HERE'.                   
      ******************************************************************00731900
      *    WORK AREAS                                                  *00732000
      ******************************************************************00732100
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04532'.      
       01  WS-MISC.                                                     
           05 WS-APPL-PGM-ID           PIC X(07).                       
           05 WS-ACTION-IND            PIC X(01).                       
           05 WS-TRAN-APPL-NO          PIC S9(4)   COMP VALUE 0.        
           05 WS-SPCL-BILL-STMNT-TX    PIC X(35)   VALUE SPACES.        
           05 WS-ADDTL-BILL-NAME-TX    PIC X(35)   VALUE SPACES.        
                                                                        
      * ACCT# REDEFINES                                                 00733200
           05 WS-ACCOUNT               PIC X(13).                       
           05 WS-ACCOUNT-DEC           REDEFINES WS-ACCOUNT             
                                       PIC 9(13).                       
      *                                                                 00733800
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9)   COMP VALUE 0.        
           05  S-ACCOUNT-NO            PIC X(13)   VALUE SPACES.        
           05  S-SPCL-BILL-STMNT-TX    PIC X(35)   VALUE SPACES.        
           05  S-ADDTL-BILL-NAME-TX    PIC X(35)   VALUE SPACES.        
      *                                                                 00734900
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                 PIC S9(9)   COMP VALUE 0.        
      *                                                                 00735200
       01  SWITCHES.                                                    
           05 SEND-DONE-SW             PIC X(01)   VALUE 'Y'.           
              88 SEND-DONE-ERROR                   VALUE 'N'.           
              88 SEND-DONE-OK                      VALUE 'Y'.           
      *                                                                 00735700
      ******************************************************************00735800
      *    DB2 INCLUDES                                                *00735900
      ******************************************************************00736000
      *                                                                 00736100
      ***************************************************************** 00736200
      *   SQL COMMUNICATION AREA                                      * 00736300
      ***************************************************************** 00736400
      *                                                                 00736500
           EXEC SQL                                                     00736600
              INCLUDE SQLCA                                             00736700
           END-EXEC.                                                    00736800
      ***************************************************************** 00736900
      *   CSS_ACCT_MISC_INFO TA                                       * 00737000
      ***************************************************************** 00737100
           EXEC SQL                                                     00737200
              INCLUDE TBATMISC                                          00737300
           END-EXEC.                                                    00737400
      ***************************************************************** 00737500
      *   CSS_MNT_TRANS_HIST MH                                       * 00737600
      ***************************************************************** 00737700
           EXEC SQL                                                     00737800
              INCLUDE TBMNHIST                                          00737900
           END-EXEC.                                                    00738000
      ***************************************************************** 00738100
      *   CSS_MT_TRN_HST_DET MI                                       * 00738200
      ***************************************************************** 00738300
           EXEC SQL                                                     00738400
              INCLUDE TBMNHDT                                           00738500
           END-EXEC.                                                    00738600
      ***************************************************************** 00738700
      *   WS-ABEND-WORK-AREA                                          * 00738800
      ***************************************************************** 00738900
           EXEC SQL                                                     00739000
              INCLUDE CWSX0010                                          00739100
           END-EXEC.                                                    00739200
      ***************************************************************** 00739300
      *   ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS              * 00739400
      ***************************************************************** 00739500
           COPY CWS00027.                                               00739600
      ***************************************************************** 00739700
      *   SUPPORTS DB2 AND SQL ERROR CHECKING                         * 00739800
      ***************************************************************** 00739900
           COPY CWS00303.                                               00740000
      *                                                                 00740100
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID            PIC X(07).                       
       01  PARM-ACTION-IND             PIC X(01).                       
       01  PARM-ACCOUNT-NO             PIC X(13).                       
       01  PARM-SPCL-BILL-STMNT-TX     PIC X(35).                       
       01  PARM-ADDTL-BILL-NAME-TX     PIC X(35).                       
                                                                        
      *                                                                 00740900
       PROCEDURE DIVISION USING PARM-APPL-PGM-ID                        
                                PARM-ACTION-IND                         
                                PARM-ACCOUNT-NO                         
                                PARM-SPCL-BILL-STMNT-TX                 
                                PARM-ADDTL-BILL-NAME-TX.                
      *                                                                 00770000
      ******************************************************************00780000
      * 0000-MAINLINE                                                  *00790000
      ******************************************************************00800000
      *                                                                 00810000
       0000-MAINLINE.                                                   
      *                                                                 00830000
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
      *                                                                 00890000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00920000
      ******************************************************************00930000
      * 0100-INITIALIZE                                                *00940000
      ******************************************************************00950000
      *                                                                 00960000
       0100-INITIALIZE.                                                 
      *                                                                 00980000
           MOVE '0100'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 00980200
           EVALUATE PARM-ACTION-IND                                     
              WHEN 'R'                                                  
                PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT      
              WHEN 'U'                                                  
                PERFORM 0100B-DECLARE-GTT          THRU 0100B-EXIT      
           END-EVALUATE.                                                
      *                                                                 01062000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01090000
      ******************************************************************01091000
      * 0100A-DECLARE-GTT.                                             *01092000
      ******************************************************************01093000
       0100A-DECLARE-GTT.                                               
      *                                                                 01095000
           MOVE '0100A'                  TO ACTIVE-PARAGRAPH.           
              EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR04532_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR04532_R1
                 (                                                       
                    RETURN_CODE              INT                    
                   ,SPCL_BILL_STMNT_TX CHAR(35)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,ADDTL_BILL_NAME_TX CHAR(35)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01102100
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 01102400
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04532_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                              THRU  9900-EXIT           
              END-IF.                                                   
      *                                                                 01104200
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
                  ,:S-SPCL-BILL-STMNT-TX   AS  SPCL_BILL_STMNT_TX       
                  ,:S-ADDTL-BILL-NAME-TX   AS  ADDTL_BILL_NAME_TX       
               FROM                                                     
                   #CSR04532_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01104300
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        01104400
MFA-TR*        SELECT                                                   01104500
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE              01104600
MFA-TR*           ,:S-SPCL-BILL-STMNT-TX   AS  SPCL_BILL_STMNT_TX       01104800
MFA-TR*           ,:S-ADDTL-BILL-NAME-TX   AS  ADDTL_BILL_NAME_TX       01104900
MFA-TR*        FROM                                                     01105000
MFA-TR*            SESSION.CSR04532_R1                                  01105100
MFA-TR*    END-EXEC.                                                    01105200
      *                                                                 01105300
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 01105600
      ******************************************************************01105700
      * 0100B-DECLARE-GTT.                                             *01105800
      ******************************************************************01105900
       0100B-DECLARE-GTT.                                               
      *                                                                 01106100
           MOVE '0100B'                  TO ACTIVE-PARAGRAPH.           
              EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR04532_R2')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR04532_R2
                 (                                                       
                    RETURN_CODE              INT                    
                )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01108700
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 01109000
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100B'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04532_R2'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                              THRU  9900-EXIT           
              END-IF.                                                   
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   #CSR04532_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     01110800
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                        01110900
MFA-TR*        SELECT                                                   01111000
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE              01111100
MFA-TR*        FROM                                                     01111300
MFA-TR*            SESSION.CSR04532_R2                                  01111400
MFA-TR*    END-EXEC.                                                    01111500
      *                                                                 01111600
       0100B-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************01111900
      * 1000-PROCESS-INPUT.                                            *01112000
      ******************************************************************01120000
      *                                                                 01130000
       1000-PROCESS-INPUT.                                              
      *                                                                 01150000
           MOVE '1000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 01150200
           INITIALIZE DCLCSS-ACCT-MISC-INFO                             
           MOVE PARM-APPL-PGM-ID         TO WS-APPL-PGM-ID.             
           MOVE PARM-ACTION-IND          TO WS-ACTION-IND.              
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT                  
           MOVE WS-ACCOUNT-DEC           TO TA-ACCOUNT-NO.              
      *                                                                 01180000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01210000
      ******************************************************************01220000
      * 2000-PROCESS-OUTPUT.                                           *01230000
      ******************************************************************01240000
      *                                                                 01250000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 01270000
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 01272000
           EVALUATE WS-ACTION-IND                                       
              WHEN 'R'                                                  
                PERFORM 2200-PROCESS-RETRIEVE-DETAIL THRU 2200-EXIT     
              WHEN 'U'                                                  
                PERFORM 2300-PROCESS-UPDATE-DETAIL   THRU 2300-EXIT     
           END-EVALUATE.                                                
      *                                                                 01370000
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01400000
      * 2200-PROCESS-RETRIEVE-DETAIL.                                  *01410000
      ******************************************************************01480000
                                                                        
       2200-PROCESS-RETRIEVE-DETAIL.                                    
                                                                        
           MOVE '2200'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 01520100
           PERFORM 7000-SELECT-ACCT-MISC-INFO THRU 7000-EXIT.           
      *                                                                 01530100
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE TA-SPCL-BILL-STMNT-TX      TO S-SPCL-BILL-STMNT-TX   
              MOVE TA-ADDTL-BILL-NAME-TX      TO S-ADDTL-BILL-NAME-TX   
           ELSE                                                         
              MOVE SPACES                     TO S-SPCL-BILL-STMNT-TX   
              MOVE SPACES                     TO S-ADDTL-BILL-NAME-TX   
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
      *                                                                 01531800
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01533100
      ******************************************************************01534000
      * 2300-PROCESS-UPDATE-DETAIL.                                    *01535000
      ******************************************************************01539300
      *                                                                 01539400
       2300-PROCESS-UPDATE-DETAIL.                                      
      *                                                                 01539600
           MOVE '2300'                   TO ACTIVE-PARAGRAPH.           
      *                                                                 01539800
           PERFORM 7000-SELECT-ACCT-MISC-INFO THRU 7000-EXIT.           
           MOVE TA-SPCL-BILL-STMNT-TX           TO WS-SPCL-BILL-STMNT-TX
           MOVE TA-ADDTL-BILL-NAME-TX           TO WS-ADDTL-BILL-NAME-TX
      *                                                                 01540400
           MOVE PARM-SPCL-BILL-STMNT-TX         TO TA-SPCL-BILL-STMNT-TX
           MOVE PARM-ADDTL-BILL-NAME-TX         TO TA-ADDTL-BILL-NAME-TX
      *                                                                 01540700
           PERFORM 8200-INSERT-ACCT-MISC-INFO    THRU 8200-EXIT         
           IF WS-ACTIVE-RETURN-CODE       = -803                        
              PERFORM 8300-UPDATE-ACCT-MISC-INFO THRU 8300-EXIT         
           END-IF                                                       
           PERFORM 5000-INSERT-MNT-TRANS-HIST    THRU 5000-EXIT         
           PERFORM 8020-INSERT-GTT-R2            THRU 8020-EXIT.        
      *                                                                 01542800
       2300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01543100
      * 5000-UPDATE-MNT-TRANS-HIST.                                    *01543200
      ******************************************************************01543300
       5000-INSERT-MNT-TRANS-HIST.                                      
      *                                                                 01543500
           MOVE '5000'                     TO ACTIVE-PARAGRAPH.         
      *                                                                 01543700
           PERFORM 7100-GET-TIMESTAMP            THRU 7100-EXIT.        
      *                                                                 01543900
           IF WS-SPCL-BILL-STMNT-TX < SPACES                            
              MOVE SPACES                TO WS-SPCL-BILL-STMNT-TX       
           END-IF.                                                      
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE TA-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE ZEROES                   TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE 'SYSTEM'                 TO MH-USER-ID.                 
           MOVE PARM-APPL-PGM-ID         TO MH-APPL-PROGRAM-ID.         
           MOVE ZEROES                   TO MH-TRAN-COMMENT-LEN.        
           MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT.       
           MOVE 1                        TO WS-TRAN-APPL-NO.            
      *                                                                 01545300
           IF PARM-SPCL-BILL-STMNT-TX NOT = WS-SPCL-BILL-STMNT-TX       
              MOVE 'SPCL BILL STMNT TX'  TO MI-COLUMN-DESC              
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +35                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-SPCL-BILL-STMNT-TX                              
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO        
              IF WS-SPCL-BILL-STMNT-TX > SPACES                         
                 MOVE +35                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-SPCL-BILL-STMNT-TX                             
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                      TO WS-TRAN-APPL-NO             
           END-IF.                                                      
      *                                                                 01547300
           IF WS-ADDTL-BILL-NAME-TX < SPACES                            
              MOVE SPACES TO WS-ADDTL-BILL-NAME-TX                      
           END-IF.                                                      
                                                                        
           IF PARM-ADDTL-BILL-NAME-TX NOT = WS-ADDTL-BILL-NAME-TX       
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'ADDTL BILL NAME TX'     TO MI-COLUMN-DESC           
              MOVE SPACES                   TO MI-TABLE-ID              
              MOVE +35                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE PARM-ADDTL-BILL-NAME-TX  TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
              IF WS-ADDTL-BILL-NAME-TX > SPACES                         
                 MOVE +35                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE WS-ADDTL-BILL-NAME-TX TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
       5000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01549800
      * 7100-GET-TIMESTAMP                                             *01549900
      ******************************************************************01550000
                                                                        
       7100-GET-TIMESTAMP.                                              
                                                                        
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01550500
MFA-TR*         SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP           01550600
MFA-TR*            ,:MH-DATE-TRANS        = CURRENT DATE                01550700
MFA-TR*    END-EXEC.                                                    01550800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01554500
      *  JOURNALING COPYBOOK.                                          *01554600
      ******************************************************************01554700
                                                                        
           EXEC SQL                                                     01554900
              INCLUDE CPD00067                                          01555000
           END-EXEC.                                                    01555100
                                                                        
      ******************************************************************01555300
      * 7000-SELECT-ACCT-MISC-INFO                                     *01555400
      ******************************************************************01555500
                                                                        
       7000-SELECT-ACCT-MISC-INFO.                                      
                                                                        
           MOVE '7000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              SELECT  TA.SPCL_BILL_STMNT_TX                             
                     ,TA.ADDTL_BILL_NAME_TX                             
              INTO    :TA-SPCL-BILL-STMNT-TX                            
                     ,:TA-ADDTL-BILL-NAME-TX                            
              FROM    CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
              WHERE   TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01556100
MFA-TR*       SELECT  TA.SPCL_BILL_STMNT_TX                             01556200
MFA-TR*              ,TA.ADDTL_BILL_NAME_TX                             01556300
MFA-TR*       INTO    :TA-SPCL-BILL-STMNT-TX                            01556400
MFA-TR*              ,:TA-ADDTL-BILL-NAME-TX                            01556500
MFA-TR*       FROM    CSS_ACCT_MISC_INFO TA                             01556700
MFA-TR*       WHERE   TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    01556800
MFA-TR*       WITH UR                                                   01556900
MFA-TR*       QUERYNO 7000                                              01557000
MFA-TR*    END-EXEC.                                                    01557100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE TA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01561100
      *8010-INSERT-GTT-R1.                                              01561200
      ******************************************************************01561300
      *                                                                 01561400
       8010-INSERT-GTT-R1.                                              
      *                                                                 01561600
            EXEC SQL                                                    
                 INSERT INTO #CSR04532_R1                        
                 (                                                      
                     RETURN_CODE                                        
                    ,SPCL_BILL_STMNT_TX                                 
                    ,ADDTL_BILL_NAME_TX                                 
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-SPCL-BILL-STMNT-TX                             
                     ,:S-ADDTL-BILL-NAME-TX                             
                 )                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    01561700
MFA-TR*          INSERT INTO SESSION.CSR04532_R1                        01561800
MFA-TR*          (                                                      01561900
MFA-TR*              RETURN_CODE                                        01562000
MFA-TR*             ,SPCL_BILL_STMNT_TX                                 01562200
MFA-TR*             ,ADDTL_BILL_NAME_TX                                 01562300
MFA-TR*          )                                                      01562400
MFA-TR*          VALUES                                                 01562500
MFA-TR*          (                                                      01562600
MFA-TR*               :S-RETURN-CODE                                    01562700
MFA-TR*              ,:S-SPCL-BILL-STMNT-TX                             01562900
MFA-TR*              ,:S-ADDTL-BILL-NAME-TX                             01563000
MFA-TR*          )                                                      01563100
MFA-TR*    END-EXEC                                                     01563200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01563300
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
      *                                                                 01563600
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD  +1                    TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8010'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04532_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 01565200
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 01565500
      ******************************************************************01565600
      *8020-INSERT-GTT-R2.                                              01565700
      ******************************************************************01565800
      *                                                                 01565900
       8020-INSERT-GTT-R2.                                              
      *                                                                 01566100
            EXEC SQL                                                    
                 INSERT INTO #CSR04532_R2                        
                 (                                                      
                     RETURN_CODE                                        
                 )                                                      
                 VALUES                                                 
                 (                                                      
                     :S-RETURN-CODE                                     
                 )                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    01566200
MFA-TR*          INSERT INTO SESSION.CSR04532_R2                        01566300
MFA-TR*          (                                                      01566400
MFA-TR*              RETURN_CODE                                        01566500
MFA-TR*          )                                                      01566700
MFA-TR*          VALUES                                                 01566800
MFA-TR*          (                                                      01566900
MFA-TR*              :S-RETURN-CODE                                     01567000
MFA-TR*          )                                                      01567200
MFA-TR*    END-EXEC                                                     01567300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01567400
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
      *                                                                 01567700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD  +1                    TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8020'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04532_R2'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 01569300
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 01569600
      ******************************************************************01573800
      * 8200-INSERT-ACCT-MISC-INFO                                      01573900
      ******************************************************************01574000
                                                                        
       8200-INSERT-ACCT-MISC-INFO.                                      
                                                                        
           MOVE '8200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_MISC_INFO                            
                         (ACCOUNT_NO,                                   
                          SPCL_BILL_STMNT_TX,                           
                          ADDTL_BILL_NAME_TX)                           
              VALUES     (:TA-ACCOUNT-NO,                               
                          :TA-SPCL-BILL-STMNT-TX,                       
                          :TA-ADDTL-BILL-NAME-TX)                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_MISC_INFO'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'SPCL_BILL_STMNT_TX'       TO TABLE-ELEMENT-2        
              MOVE 'ADDTL_BILL_NAME_TX'       TO TABLE-ELEMENT-3        
              MOVE TA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE TA-SPCL-BILL-STMNT-TX      TO HOSTVAR-ELEMENT-2      
              MOVE TA-ADDTL-BILL-NAME-TX      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                *01582300
      ******************************************************************01582400
      * 8300-UPDATE-ACCT-MISC-INFO                                     *01582500
      ******************************************************************01582600
                                                                        
       8300-UPDATE-ACCT-MISC-INFO.                                      
                                                                        
           MOVE '8300'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              UPDATE  TA                              
              SET     TA.SPCL_BILL_STMNT_TX = :TA-SPCL-BILL-STMNT-TX    
                     ,TA.ADDTL_BILL_NAME_TX = :TA-ADDTL-BILL-NAME-TX    
              FROM CSS_ACCT_MISC_INFO TA
              WHERE   TA.ACCOUNT_NO         = :TA-ACCOUNT-NO            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     01583200
MFA-TR*       UPDATE  CSS_ACCT_MISC_INFO TA                             01583300
MFA-TR*       SET     TA.SPCL_BILL_STMNT_TX = :TA-SPCL-BILL-STMNT-TX    01583400
MFA-TR*              ,TA.ADDTL_BILL_NAME_TX = :TA-ADDTL-BILL-NAME-TX    01583500
MFA-TR*       WHERE   TA.ACCOUNT_NO         = :TA-ACCOUNT-NO            01583600
MFA-TR*       QUERYNO 8300                                              01583700
MFA-TR*    END-EXEC.                                                    01583800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'SPCL_BILL_STMNT_TX'  TO TABLE-ELEMENT-2             
              MOVE 'ADDTL_BILL_NAME_TX'  TO TABLE-ELEMENT-3             
              MOVE TA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PARM-SPCL-BILL-STMNT-TX                              
                                         TO HOSTVAR-ELEMENT-2           
              MOVE PARM-ADDTL-BILL-NAME-TX                              
                                         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01586500
      * 8900-SEND-DONE.                                                *01586600
      ******************************************************************01586700
      *                                                                 01586800
       8900-SEND-DONE.                                                  
      *                                                                 01587000
           EVALUATE WS-ACTION-IND                                       
               WHEN 'R'                                                 
                 EXEC SQL                                               
                      OPEN C1                                           
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 01587600
                 MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE 
                                                                        
      *                                                                 01588100
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE SQLCODE               TO ABEND-SQLCODE         
                    MOVE SQLSTATE              TO ABEND-SQLSTATE        
                    MOVE '8900'                TO ACTIVE-PARAGRAPH      
                    MOVE 'OPEN'                TO ABEND-FUNCTION        
                    MOVE 'CSR04532_R1'         TO TABLE-1               
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
                 END-IF                                                 
      *                                                                 01589500
               WHEN 'U'                                                 
                 EXEC SQL                                               
                     OPEN C2                                            
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 01590000
                 MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE 
                                                                        
      *                                                                 01590300
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE SQLCODE               TO ABEND-SQLCODE         
                    MOVE SQLSTATE              TO ABEND-SQLSTATE        
                    MOVE '8900'                TO ACTIVE-PARAGRAPH      
                    MOVE 'OPEN'                TO ABEND-FUNCTION        
                    MOVE 'CSR04532_R2'         TO TABLE-1               
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                 01593100
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01593400
      ******************************************************************01593500
      * 9000-SEND-ERROR-RESULT.                                        *01593600
      ******************************************************************01593700
      *                                                                 01593800
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 01594000
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 01597100
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01597500
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 01598100
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01598500
      ******************************************************************01598600
      *   9999-END-PROGRAM                                             *01598700
      ******************************************************************01598800
      *                                                                 01598900
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************01599300
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *01599400
      ******************************************************************01599500
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01601200
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     01601300
      ******************************************************************01601400
           EXEC SQL                                                     01601500
              INCLUDE CPDSP300                                          01601600
           END-EXEC.                                                    01602000
                                                                        
