       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04531.                                       
       AUTHOR.       MC95456.                                           
COB303 DATE-WRITTEN. 08 NOV 2011.                                        
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04531              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04531 :                                                --         
      *--                                                            --         
      *--  #  PROJ*254                                               --         
      *--  #  RETRIEVE ACCOUNT RELATED INFORMATION FOR GIVEN CUSTOMER--         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_APPL_PGM_ID     CHAR(07)                      --         
      *--            I_CUSTOMER_NO     CHAR(10)                      --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--            RETURN_CODE           INTEGER                   --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CODE_CRIT_OUTAGE      CHAR(02)                  --         
      *--            UTILITY_SOURCE_CD     CHAR(01)                  --         
      *--            SPCL_BILL_STMT_TX     CHAR(35)                  --         
      *--            OUTAGE_IND            CHAR(03)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00254*--  11/08/2011    MC95456     RETRIEVE ACCOUNT INFO FOR GIVEN --         
      *--                            CUSTOMER                        --         
ACT037*--  04/13/2012    VIJAY       REMOVE SUB ACCT CHECK           --         
      *----------------------------------------------------------------         
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04531'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40) VALUE                  
            'WORKING STORAGE FOR CSR04531 STARTS HERE'.                 
      *                                                                         
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04531'.      
           05 WS-ACTIVE                PIC X(01) VALUE 'A'.             
           05 WS-TEST                  PIC X(01) VALUE 'T'.             
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 GTT-NAME                 PIC X(26)                        
                                            VALUE 'SESSION.CSR04531_R1'.
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-APPL-PGM-ID           PIC X(07).                       
           05 WS-CUSTOMER-NO           PIC X(10).                       
           05 WS-CUSTOMER-DEC          REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
           05 WS-TRANSMISSION-FLAG     PIC X(01) VALUE 'N'.             
              88 TRANSMISSION                    VALUE 'Y'.             
           05 WS-DISTRIBUTION-FLAG     PIC X(01) VALUE 'N'.             
              88 DISTRIBUTION                    VALUE 'Y'.             
           05  WS-SQLSTATE             PIC X(5) VALUE SPACES.           
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW              PIC X(01) VALUE 'N'.             
              88 NOT-ALL-DONE                    VALUE 'N'.             
              88 ALL-DONE                        VALUE 'Y'.             
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
           05 WS-NO-MORE-ROWS          PIC X(01) VALUE 'N'.             
              88 NO-MORE-ROWS                    VALUE 'Y'.             
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-ACCOUNT-NO            PIC X(13)  VALUE SPACES.         
           05  S-CODE-CRIT-OUTAGE      PIC X(02)  VALUE SPACES.         
           05  S-UTILITY-SOURCE-CD     PIC X(01)  VALUE SPACES.         
           05  S-SPCL-BILL-STMNT-TX    PIC X(35)  VALUE SPACES.         
           05  S-OUTAGE-IND            PIC X(01)  VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT AT                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCT_MISC_INFO TA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT  MN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
      *                                                                         
           COPY CCA00001.                                                       
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH ACCOUNT DETAILS                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCT_DETAIL_CSR CURSOR FOR                       
                SELECT DISTINCT AT.ACCOUNT_NO                           
                               ,AT.COMPANY_NO                           
                               ,AT.CODE_ACCT_STAT                       
                               ,AT.ACCOUNT_TYPE_CODE                    
                               ,AT.CODE_CRIT_OUTAGE                     
                  FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                  WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                
                  AND ((AT.CODE_ACCT_STAT = 'A')                        
                        OR  (AT.CODE_ACCT_STAT = 'B'                    
                        AND  AT.TOTAL_AR_BALANCE <> 0)                  
                  OR  (AT.CODE_ACCT_STAT = 'B'                          
                       AND AT.TOTAL_AR_BALANCE = 0                      
                       AND CAST(AT.ACCT_FINALED_DT AS DATE)                     
                           > DATEADD( DAY, -30, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )))             
                  ORDER BY AT.ACCOUNT_NO                                
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT_DETAIL_CSR CURSOR FOR                               
MFA-TR*         SELECT DISTINCT AT.ACCOUNT_NO                                   
MFA-TR*                        ,AT.COMPANY_NO                                   
MFA-TR*                        ,AT.CODE_ACCT_STAT                               
MFA-TR*                        ,AT.ACCOUNT_TYPE_CODE                            
MFA-TR*                        ,AT.CODE_CRIT_OUTAGE                             
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*           WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                        
MFA-TR*           AND ((AT.CODE_ACCT_STAT = 'A')                                
MFA-TR*                 OR  (AT.CODE_ACCT_STAT = 'B'                            
MFA-TR*                 AND  AT.TOTAL_AR_BALANCE <> 0)                          
MFA-TR*           OR  (AT.CODE_ACCT_STAT = 'B'                                  
MFA-TR*                AND AT.TOTAL_AR_BALANCE = 0                              
MFA-TR*                AND DATE(AT.ACCT_FINALED_DT)                             
MFA-TR*                    > DATE(CURRENT DATE) - 30 DAYS))                     
MFA-TR*           ORDER BY AT.ACCOUNT_NO                                        
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04531 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-APPL-PGM-ID            PIC X(07).                       
       01  PARM-CUSTOMER-NO            PIC X(10).                       
      *                                                                         
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-CUSTOMER-NO.                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                    THRU 0100-EXIT.   
           PERFORM 1000-PROCESS-INPUT                 THRU 1000-EXIT.   
           PERFORM 2000-PROCESS-OUTPUT                THRU 2000-EXIT.   
           PERFORM 9999-END-PROGRAM                   THRU 9999-EXIT.   
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT                  THRU 0100A-EXIT.  
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT                                                  
                   *                                                    
                  FROM #CSR04531_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT                                                          
MFA-TR*            *                                                            
MFA-TR*           FROM SESSION.CSR04531_R1                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04531_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04531_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_CRIT_OUTAGE CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,UTILITY_SOURCE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SPCL_BILL_STMT_TX CHAR(35)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OUTAGE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS         THRU 8000A-EXIT        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE '0100A'                    TO ACTIVE-PARAGRAPH    
                 MOVE SQLCODE                    TO ABEND-SQLCODE       
                 MOVE SQLSTATE                   TO ABEND-SQLSTATE      
                 MOVE 'DECLARE GTT'              TO ABEND-FUNCTION      
                 MOVE SPACES                     TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                 MOVE 'CSR04531_R1'              TO TABLE-1             
                 MOVE SPACES                     TO TABLE-ELEMENT-1     
                 MOVE SPACES                     TO HOSTVAR-ELEMENT-1   
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-APPL-PGM-ID                 TO WS-APPL-PGM-ID.     
           MOVE PARM-CUSTOMER-NO                 TO WS-CUSTOMER-NO.     
           MOVE WS-CUSTOMER-DEC                  TO AT-CUSTOMER-NO.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE WS-NO                            TO WS-NO-MORE-ROWS     
           PERFORM 7000-OPEN-ACCT-DETAIL-CSR     THRU 7000-EXIT         
           PERFORM 7100-FETCH-ACCT-DETAIL-CSR    THRU 7100-EXIT         
           PERFORM 2100-PROCESS-ACCT-DETAILS     THRU 2100-EXIT         
                                                 UNTIL NO-MORE-ROWS     
           PERFORM 7200-CLOSE-ACCT-DETAIL-CSR    THRU 7200-EXIT.        
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                           TO S-RETURN-CODE       
              PERFORM 8100-SEND-RESULT           THRU  8100-EXIT        
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2100-PROCESS-ACCT-DETAILS.                                    *         
      *****************************************************************         
      *                                                                         
       2100-PROCESS-ACCT-DETAILS.                                       
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           INITIALIZE WS-TRANSMISSION-FLAG                              
                      WS-DISTRIBUTION-FLAG.                             
                                                                        
           MOVE    AT-ACCOUNT-NO                 TO S-ACCOUNT-NO        
                                                    TA-ACCOUNT-NO       
                                                    MN-ACCOUNT-NO.      
           IF AT-CODE-CRIT-OUTAGE > SPACES                              
              MOVE AT-CODE-CRIT-OUTAGE           TO S-CODE-CRIT-OUTAGE  
           ELSE                                                         
              MOVE SPACES                        TO S-CODE-CRIT-OUTAGE  
           END-IF.                                                      
                                                                        
           PERFORM 7500-SELECT-ACCT-MISC-INFO    THRU 7500-EXIT.        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE TA-SPCL-BILL-STMNT-TX         TO S-SPCL-BILL-STMNT-TX
           END-IF.                                                      
                                                                        
           PERFORM 7600-SET-TRANS-FLAG           THRU 7600-EXIT.        
           PERFORM 7700-SET-DISTRB-FLAG          THRU 7700-EXIT.        
           IF TRANSMISSION AND DISTRIBUTION                             
              MOVE   'B'                         TO S-UTILITY-SOURCE-CD 
           ELSE                                                         
              IF TRANSMISSION                                           
                 MOVE  'T'                       TO S-UTILITY-SOURCE-CD 
              ELSE                                                      
                 IF DISTRIBUTION                                        
                    MOVE 'D'                     TO S-UTILITY-SOURCE-CD 
                 END-IF                                                 
              END-IF                                                    
            END-IF.                                                     
      *                                                                         
           MOVE    SPACES                        TO S-OUTAGE-IND.       
      *                                                                         
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 7100-FETCH-ACCT-DETAIL-CSR    THRU 7100-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7000-OPEN-ACCT-DETAIL-CSR.                                    *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-ACCT-DETAIL-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCT_DETAIL_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE       
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '7000'                        TO ACTIVE-PARAGRAPH    
              MOVE 'OPEN'                        TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_ACCOUNT'                 TO TABLE-1             
              MOVE SPACES                        TO TABLE-ELEMENT-1     
              MOVE SPACES                        TO HOSTVAR-ELEMENT-1   
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-ACCT-DETAIL-CSR.                                    *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-ACCT-DETAIL-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH ACCT_DETAIL_CSR                                    
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-CODE-CRIT-OUTAGE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES                  TO WS-NO-MORE-ROWS     
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE                          
                                                 TO S-RETURN-CODE       
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '7100'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'FETCH'                 TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CSS_ACCOUNT'           TO TABLE-1             
                    MOVE SPACES                  TO TABLE-ELEMENT-1     
                    MOVE SPACES                  TO HOSTVAR-ELEMENT-1   
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-ACCT-DETAIL-CSR.                                    *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-ACCT-DETAIL-CSR.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACCT_DETAIL_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE       
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '7200'                        TO ACTIVE-PARAGRAPH    
              MOVE 'CLOSE'                       TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_ACCOUNT'                 TO TABLE-1             
              MOVE SPACES                        TO TABLE-ELEMENT-1     
              MOVE SPACES                        TO HOSTVAR-ELEMENT-1   
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-SELECT-ACCT-MISC-INFO                                    *         
      *****************************************************************         
      *                                                                         
       7500-SELECT-ACCT-MISC-INFO.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  SPCL_BILL_STMNT_TX                               
                      ,ADDTL_BILL_NAME_TX                               
               INTO    :TA-SPCL-BILL-STMNT-TX                           
                      ,:TA-ADDTL-BILL-NAME-TX                           
               FROM    CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                 
               WHERE   ACCOUNT_NO = :TA-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SPCL_BILL_STMNT_TX                                       
MFA-TR*               ,ADDTL_BILL_NAME_TX                                       
MFA-TR*        INTO    :TA-SPCL-BILL-STMNT-TX                                   
MFA-TR*               ,:TA-ADDTL-BILL-NAME-TX                                   
MFA-TR*        FROM    CSS_ACCT_MISC_INFO                                       
MFA-TR*        WHERE   ACCOUNT_NO = :TA-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE       
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '7500'                        TO ACTIVE-PARAGRAPH    
              MOVE 'SELECT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_ACCT_MISC_INFO'          TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE TA-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7600-SET-TRANS-FLAG                                           *         
      *****************************************************************         
      *                                                                         
       7600-SET-TRANS-FLAG.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
               INTO    :WS-TRANSMISSION-FLAG                            
               FROM    CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                   
               WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO               
               AND     UTILITY_SOURCE_CD = 'T'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*        INTO    :WS-TRANSMISSION-FLAG                                    
MFA-TR*        FROM    CSS_MTRD_ENVRNMT                                         
MFA-TR*        WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO                       
MFA-TR*        AND     UTILITY_SOURCE_CD = 'T'                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE       
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '7600'                        TO ACTIVE-PARAGRAPH    
              MOVE 'SELECT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_MTRD_ENVRNMT'            TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE MN-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7700-SET-DISTRB-FLAG                                           *        
      *****************************************************************         
      *                                                                         
       7700-SET-DISTRB-FLAG.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
               INTO    :WS-DISTRIBUTION-FLAG                            
               FROM    CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                   
               WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO               
               AND     UTILITY_SOURCE_CD = 'D'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*        INTO    :WS-DISTRIBUTION-FLAG                                    
MFA-TR*        FROM    CSS_MTRD_ENVRNMT                                         
MFA-TR*        WHERE   ACCOUNT_NO        = :MN-ACCOUNT-NO                       
MFA-TR*        AND     UTILITY_SOURCE_CD = 'D'                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE       
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '7700'                        TO ACTIVE-PARAGRAPH    
              MOVE 'SELECT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_MTRD_ENVRNMT'            TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE MN-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04531_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04531_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE SQLCODE                TO ABEND-SQLCODE        
                    MOVE SQLSTATE               TO ABEND-SQLSTATE       
                    MOVE '8000A'                TO ACTIVE-PARAGRAPH     
                    MOVE 'DELETE'               TO ABEND-FUNCTION       
                    MOVE 'CSR04531_R1'          TO TABLE-1              
                    MOVE SPACES                 TO TABLE-ELEMENT-1      
                    MOVE SPACES                 TO HOSTVAR-ELEMENT-1    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04531_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,ACCOUNT_NO                                           
                  ,CODE_CRIT_OUTAGE                                     
                  ,UTILITY_SOURCE_CD                                    
                  ,SPCL_BILL_STMT_TX                                    
                  ,OUTAGE_IND                                           
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-ACCOUNT-NO                                        
                  ,:S-CODE-CRIT-OUTAGE                                  
                  ,:S-UTILITY-SOURCE-CD                                 
                  ,:S-SPCL-BILL-STMNT-TX                                
                  ,:S-OUTAGE-IND                                        
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04531_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,CODE_CRIT_OUTAGE                                             
MFA-TR*           ,UTILITY_SOURCE_CD                                            
MFA-TR*           ,SPCL_BILL_STMT_TX                                            
MFA-TR*           ,OUTAGE_IND                                                   
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-ACCOUNT-NO                                                
MFA-TR*           ,:S-CODE-CRIT-OUTAGE                                          
MFA-TR*           ,:S-UTILITY-SOURCE-CD                                         
MFA-TR*           ,:S-SPCL-BILL-STMNT-TX                                        
MFA-TR*           ,:S-OUTAGE-IND                                                
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                             TO CTR-ROWS            
           ELSE                                                         
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '8100'                        TO ACTIVE-PARAGRAPH    
              MOVE SQLCODE                       TO ABEND-SQLCODE       
              MOVE 'INSERT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSR04531_R1'                 TO TABLE-1             
              MOVE SPACES                        TO TABLE-ELEMENT-1     
              MOVE SPACES                        TO HOSTVAR-ELEMENT-1   
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
        9700-PROCESS-ABEND.                                             
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.        
                                                                        
             PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.        
      *                                                                         
        9700-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
      *                                                                         
