       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04530.                                        
       AUTHOR.         SIVARAJAN.                                       
       DATE-WRITTEN.   OCT 2011.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070000
      ***************************************************************** 00080000
      **                STORED PROCEDURE:  CSR04530                  ** 00090000
      ***************************************************************** 00100000
      **                P R O G R A M   S U M M A R Y                ** 00110000
      **                                                             ** 00120000
      **  THIS PROGRAM USED IN PANEL091 TO INSERT DATA IN            ** 00130000
      **  CSS_SPCL_BILL_MSG AND CSS_COMM_DATA TABLE FOR STATEMENT    ** 00140000
      **  REQUEST PROJECT BASED ON CONDITION.                        ** 00150000
      **                                                             ** 00160000
      **  PARAMETERS                                                 ** 00170000
      **                                                             ** 00180000
      **      INPUT                                                  ** 00190000
      **        ACCOUNT NO           CHAR(13)                        ** 00200000
      **        USER ID              CHAR(07)                        ** 00210000
      **                                                             ** 00220000
      **      OUTPUT                                                 ** 00230000
      **                                                             ** 00240000
      **       RETURN_CODE           INTEGER                         ** 00250000
      **       ACCT_CREATE_DT        CHAR(10)                        ** 00260000
      **       LAST_BILL_DT          CHAR(10)                        ** 00270000
      **                                                             ** 00280000
      **      RESULT SET                                             ** 00290000
      **        1                                                    ** 00300000
      ***************************************************************** 00310000
      **                                                              * 00320000
      **              PROGRAM MODIFICATION LOG                        * 00330000
      ** DATE        INITIALS     REASON                              * 00340000
      ** --------    ---------    ----------------------------------- * 00350000
P00527** 10/20/11    SV95326      NEW PROGRAM.                        * 00360000
P00527** 03/06/12    SV95326      FIX SQL TO LOOK AT SPECIFIC MSG.    * 00370000
A04494** 07/22/13    SV95326      NEED TO CHECK PAYMENT END DATE      * 00380000
A04494**             ACT047       INSTEAD OF PAYMENT START DATE BEFORE* 00390000
A04494**                          GENERATING STATEMENT.               * 00400000
P00836** 01/27/15    VK7L032      DELETE PREV BEFORE INSRT STMNT      * 00401005
P00836** 02/19/16    VK7L032      FIXED THE 305 SQL ERROR WHEN CREATE * 00402001
P00836**                          BILL STATEMENT.                     * 00403001
      ***************************************************************** 00410000
      *                                                               * 00420000
      *         -----    BASIC SEQUENCE STRUCTURE   -----             * 00430000
      * 0000         MODULE CONTROL                                   * 00440000
      * 0100 - 0999  INITIALIZATION                                   * 00450000
      * 1000 - 1999  FUNCTIONAL CONTROL                               * 00460000
      * 2000 - 4999  DETAIL LOGIC                                     * 00470000
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               * 00480000
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     * 00490000
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    * 00500000
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    * 00510000
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          * 00520000
      *                                                               * 00530000
      ***************************************************************** 00540000
      *                                                                 00550000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00570000
       DATA DIVISION.                                                   
      *                                                                 00590000
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04530'.
MSQ017     COPY MFASQLM.
      *                                                                 00610000
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                 00800000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
       01  WS-CONSTANTS.                                                
           05  SEND-DONE-SW             PIC X(01)  VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
      *                                                                 00870000
       01  WS-WORKING-VARIABLES.                                        
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR04530'.    
           05  WS-ACCOUNT-NO           PIC 9(13)   VALUE ZERO.          
           05  WS-ACCOUNT-NO-RED       REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
           05  WS-ACCOUNT-NO-NUM       PIC S9(13)  COMP-3 VALUE ZERO.   
           05  WS-CURR-REV-MONTH       PIC X(06)   VALUE SPACES.        
           05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CURRENT-TIMESTMP     PIC X(26)   VALUE SPACES.        
           05  WS-TRAN-APPL-NO         PIC S9(02)  VALUE +1.            
           05  WS-CODE-DFA-TYPE        PIC X(01)   VALUE SPACES.        
           05  WS-TOU-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-DFA-TAB-FLAG         PIC X(01)   VALUE 'N'.           
           05  WS-BBP-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-INS-FLAG             PIC X(01)   VALUE 'N'.           
           05  WS-BILL-MSG-FLAG        PIC X(01)   VALUE 'N'.           
           05  WS-CONTRACT-FLAG        PIC X(01)   VALUE 'N'.           
           05  WS-SECURE-RATE-FLAG     PIC X(01)   VALUE 'N'.           
           05  WS-PREPAY-FLAG          PIC X(01)   VALUE 'N'.           
           05  WS-TOU-SEC-FL           PIC X(01)   VALUE 'N'.           
           05  WS-MASTER-SUB-FLAG      PIC X(01)   VALUE 'N'.           
           05  WS-RED-FL-NULL-IND      PIC S9(4) COMP VALUE 0.          
           05  WS-END-NULL-IND         PIC S9(4) COMP VALUE 0.          
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN   PIC S9(4) USAGE COMP.     
               10 WS-INITIAL-COMMENT-TX-TEXT  PIC X(255).               
           05  WS-INIT-COMMENTS-LEN     PIC S9(4) USAGE COMP VALUE +87. 
           05  WS-INIT-COMMENTS-TEXT.                                   
               10 FILLER                      PIC X(89) VALUE SPACES.   
           05  WS-DATABASE                 PIC 9(01) VALUE ZERO.        
               88  CSR-DATABASE             VALUE 1.                    
               88  SEB-DATABASE             VALUE 2.                    
A04494     05  WS-ADD-DAYS                 PIC S9(4) USAGE COMP.        
A04494     05  WS-2YR-PREV-DT              PIC X(10)   VALUE SPACES.    
A04494     05  WS-PYMNT-END-DT             PIC X(10)   VALUE SPACES.    
P00836     05  WS-NO                   PIC X(02)   VALUE 'NO'.          
P00836     05  WS-NULL-IND             PIC S9(04) COMP  VALUE +0.       
      *                                                                 01230000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-ACCT-CREATE-DT        PIC X(10)   VALUE SPACES.        
           05  S-LAST-BILL-DT          PIC X(10)   VALUE SPACES.        
      *                                                                 01280000
           EXEC SQL                                                     01290000
               INCLUDE CWSX0010                                         01300000
           END-EXEC.                                                    01310000
      *                                                                 01320000
       COPY CWS00303.                                                   01330000
      *                                                                 01340000
      ***************************************************************** 01350000
      *    DB2 TABLES INCLUDED IN PROGRAM                             * 01360000
      ***************************************************************** 01370000
      *                                                                 01380000
           EXEC SQL                                                     01390000
               INCLUDE SQLCA                                            01400000
           END-EXEC.                                                    01410000
      *                                                                 01420000
      ***************************************************************** 01430000
      * CSS_ACCOUNT - AT                                              * 01440000
      ***************************************************************** 01450000
      *                                                                 01460000
           EXEC SQL                                                     01470000
             INCLUDE TBACCT                                             01480000
           END-EXEC.                                                    01490000
      *                                                                 01500000
      ***************************************************************** 01510000
      * CSS_SPCL_BILL_MSG  - U1                                       * 01520000
      ***************************************************************** 01530000
      *                                                                 01540000
           EXEC SQL                                                     01550000
             INCLUDE TBSBLMSG                                           01560000
           END-EXEC.                                                    01570000
      *                                                                 01580000
      ***************************************************************** 01590000
      * CSS_MNT_TRANS_HIST - MH                                       * 01600000
      ***************************************************************** 01610000
      *                                                                 01620000
           EXEC SQL                                                     01630000
             INCLUDE TBMNHIST                                           01640000
           END-EXEC.                                                    01650000
      *                                                                 01660000
      ***************************************************************** 01670000
      * CSS_MT_TRN_HST_DET - MI                                       * 01680000
      ***************************************************************** 01690000
      *                                                                 01700000
           EXEC SQL                                                     01710000
             INCLUDE TBMNHDT                                            01720000
           END-EXEC.                                                    01730000
      *                                                                 01740000
      ***************************************************************** 01750000
      * CSS_COMM_DATA - KO                                            * 01760000
      ***************************************************************** 01770000
      *                                                                 01780000
           EXEC SQL                                                     01790000
              INCLUDE TBCOMDAT                                          01800000
           END-EXEC.                                                    01810000
      *                                                                 01820000
      ***************************************************************** 01830000
      * CSS_DELINQUENCY - C8                                          * 01840000
      ***************************************************************** 01850000
      *                                                                 01860000
           EXEC SQL                                                     01870000
              INCLUDE TBDELQ                                            01880000
           END-EXEC.                                                    01890000
      *                                                                 01900000
      ***************************************************************** 01910000
      * CSS_BILLING_DET - BG                                          * 01920000
      ***************************************************************** 01930000
      *                                                                 01940000
           EXEC SQL                                                     01950000
              INCLUDE TBBLLDET                                          01960000
           END-EXEC.                                                    01970000
      *                                                                 01980000
A04494***************************************************************** 01990000
A04494* CSS_DFA_ACCT    - DA                                          * 02000000
A04494***************************************************************** 02010000
A04494*                                                                 02020000
A04494     EXEC SQL                                                     02030000
A04494        INCLUDE TBDFAACT                                          02040000
A04494     END-EXEC.                                                    02050000
A04494*                                                                 02060000
      ****************************************************************  02070000
      *  CSS_BILLING_DET CURSOR                                      *  02080000
      ****************************************************************  02090000
           EXEC SQL                                                     
             DECLARE BILL_DET_CUR CURSOR FOR                            
              SELECT BG.ACCOUNT_NO                                      
                    ,BG.CODE_UTIL_TYPE                                  
                    ,BG.RATE_PLAN_NO                                    
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
               WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM         
                 AND BG.BILL_ITEM_TIMESTMP >=(DATEADD( YEAR, -2, 
           CIS.CURRENT$TIMESTAMP() )) 
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     02100000
MFA-TR*      DECLARE BILL_DET_CUR CURSOR FOR                            02110000
MFA-TR*       SELECT BG.ACCOUNT_NO                                      02120000
MFA-TR*             ,BG.CODE_UTIL_TYPE                                  02130000
MFA-TR*             ,BG.RATE_PLAN_NO                                    02140000
MFA-TR*         FROM CSS_BILLING_DET BG                                 02150000
MFA-TR*        WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM         02160000
MFA-TR*          AND BG.BILL_ITEM_TIMESTMP >=(CURRENT TIMESTAMP         02170000
MFA-TR*                                                      - 2 YEARS) 02180000
MFA-TR*        FOR FETCH ONLY WITH UR                                   02190000
MFA-TR*         QUERYNO 7920                                            02200000
MFA-TR*    END-EXEC.                                                    02210000
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO           PIC X(13).                          
       01 PARM-USER-ID              PIC X(07).                          
       01 PARM-INS-IND              PIC X(01).                          
      *                                                                 02270000
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                               ,PARM-USER-ID                            
                               ,PARM-INS-IND.                           
      *                                                                 02310000
      ***************************************************************** 02320000
      *  0000-MAINLINE                                                * 02330000
      *      THE FOLLOWING IS THE MAJOR CONTROL FOR THE PROGRAM       * 02340000
      ***************************************************************** 02350000
      *                                                                 02360000
       0000-MAINLINE.                                                   
      *                                                                 02380000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                 02440000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02470000
      ***************************************************************** 02480000
      *  0100-INITIALIZATION                                          * 02490000
      ***************************************************************** 02500000
      *                                                                 02510000
       0100-INITIALIZATION.                                             
      *                                                                 02530000
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                 02550000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 02590000
           EXEC SQL                                                     
                DECLARE C1 CURSOR                            
                                  WITH ROWSET POSITIONING FOR           
                 SELECT :S-RETURN-CODE       AS RETURN_CODE             
                       ,:S-ACCT-CREATE-DT    AS ACCT_CREATE_DT          
                       ,:S-LAST-BILL-DT      AS LAST_BILL_DT            
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     02600000
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                           02610000
MFA-TR*                           WITH ROWSET POSITIONING FOR           02620000
MFA-TR*          SELECT :S-RETURN-CODE       AS RETURN_CODE             02630000
MFA-TR*                ,:S-ACCT-CREATE-DT    AS ACCT_CREATE_DT          02640000
MFA-TR*                ,:S-LAST-BILL-DT      AS LAST_BILL_DT            02650000
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                02660000
MFA-TR*    END-EXEC.                                                    02670000
      *                                                                 02680000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02710000
      ***************************************************************** 02720000
      *  1000-PROCESS-INPUT                                           * 02730000
      *     RECEIVE PARMS                                             * 02740000
      ***************************************************************** 02750000
      *                                                                 02760000
       1000-PROCESS-INPUT.                                              
      *                                                                 02780000
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 02800000
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-RED           TO WS-ACCOUNT-NO-NUM.       
      *                                                                 02830000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02860000
      ******************************************************************02870000
      *  2000-PROCESS-OUTPUT                                           *02880000
      ******************************************************************02890000
      *                                                                 02900000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 02920000
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 02940000
           IF PARM-INS-IND  = 'N'                                       
              PERFORM 2100-VALIDATE-ACCOUNT     THRU 2100-EXIT          
           ELSE                                                         
              PERFORM 2200-INS-BILL-MSG-PROCESS THRU 2200-EXIT          
           END-IF.                                                      
      *                                                                 03000000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03030000
      ***************************************************************   03040000
      * 2100-VALIDATE-ACCOUNT.                                      *   03050000
      ***************************************************************   03060000
                                                                        
       2100-VALIDATE-ACCOUNT.                                           
                                                                        
           PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT.             
           MOVE AT-ACCT-CREATE-DT(1:10)     TO S-ACCT-CREATE-DT.        
           EVALUATE TRUE                                                
              WHEN AT-CODES-DATA-PRESENT(3:1)  = 'A'                    
                   MOVE  200                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN AT-CODES-DATA-PRESENT(5:1)  = 'A'                    
                   MOVE  800                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN AT-CODES-DATA-PRESENT(26:1) = 'A'                    
                   MOVE  300                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN AT-CODES-DATA-PRESENT(15:1) = 'A'                    
                   MOVE  600                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN AT-MST-SUB-ACCT-IND         = 'M'                    
                   MOVE  700                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN AT-MST-SUB-ACCT-IND         = 'S'                    
                   MOVE  700                TO S-RETURN-CODE            
                   GO TO 2000-EXIT                                      
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 03350100
P00836     PERFORM 7950-GET-LAST-BILL-DT    THRU 7950-EXIT.             
P00836     MOVE BG-BILL-ITEM-TIMESTMP(1:10) TO S-LAST-BILL-DT.          
P00836     IF BG-BILL-ITEM-TIMESTMP EQUAL SPACES                        
P00836        MOVE 100                 TO S-RETURN-CODE                 
P00836        GO TO 2000-EXIT                                           
P00836     END-IF.                                                      
      *                                                                 03360000
           PERFORM 7700-CHECK-SPCL-BILL-MSG   THRU 7700-EXIT.           
           IF WS-BILL-MSG-FLAG = 'Y'                                    
              MOVE  -803               TO S-RETURN-CODE                 
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                 03420000
           IF AT-MST-SUB-ACCT-IND = ' '                                 
              PERFORM 7850-CHECK-MASTER-SUB    THRU 7850-EXIT           
              IF WS-MASTER-SUB-FLAG = 'Y'                               
                 MOVE  700                TO S-RETURN-CODE              
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                 03500000
A04494     PERFORM 7050-GET-PREV-DT        THRU 7050-EXIT.              
           MOVE 'B'                    TO WS-CODE-DFA-TYPE.             
           PERFORM 7200-CHECK-DFA-TABLE     THRU 7200-EXIT.             
A04494     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04494        COMPUTE WS-ADD-DAYS ROUNDED = (DA-NO-SCHED-PYMTS - 1) *   
A04494                                                         30.5     
A04494        PERFORM 7060-GET-PYMNT-END-DT    THRU 7060-EXIT           
A04494        IF WS-PYMNT-END-DT >= WS-2YR-PREV-DT                      
A04494           MOVE  300                TO S-RETURN-CODE              
A04494           GO TO 2000-EXIT                                        
A04494        END-IF                                                    
A04494     END-IF.                                                      
      *                                                                 03630000
           MOVE 'A'                    TO WS-CODE-DFA-TYPE.             
           PERFORM 7200-CHECK-DFA-TABLE     THRU 7200-EXIT.             
A04494     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04494        MOVE 0                          TO WS-ADD-DAYS            
A04494        COMPUTE WS-ADD-DAYS ROUNDED = (DA-NO-SCHED-PYMTS - 1) *   
A04494                                                         30.5     
A04494        PERFORM 7060-GET-PYMNT-END-DT    THRU 7060-EXIT           
A04494        IF WS-PYMNT-END-DT >= WS-2YR-PREV-DT                      
A04494           MOVE  800                TO S-RETURN-CODE              
A04494           GO TO 2000-EXIT                                        
A04494        END-IF                                                    
A04494     END-IF.                                                      
      *                                                                 03760000
           PERFORM 7400-CHECK-BBP-ACCT      THRU 7400-EXIT.             
           IF WS-BBP-FLAG = 'Y'                                         
              MOVE  200                TO S-RETURN-CODE                 
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                 03820000
           PERFORM 7910-OPEN-BILL-DET-CUR     THRU 7910-EXIT.           
           PERFORM 7920-FETCH-BILL-DET-CUR    THRU 7920-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 5300-GET-TOU-SECURE-ACCT THRU 5300-EXIT           
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
                   OR WS-TOU-SEC-FL = 'Y'                               
           END-IF.                                                      
           PERFORM 7930-CLOSE-BILL-DET-CUR    THRU 7930-EXIT.           
      *                                                                 03910000
           IF WS-TOU-FLAG = 'Y' OR WS-SECURE-RATE-FLAG = 'Y'            
               GO TO 2000-EXIT                                          
           END-IF.                                                      
      *                                                                 03950000
           MOVE ZERO            TO WS-DATABASE.                         
           MOVE 'DATABASE'      TO C8-DELINQ-CD.                        
           PERFORM 7750-GET-DELINQUENCY-VALUE THRU 7750-EXIT.           
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           IF SEB-DATABASE                                              
              PERFORM 7800-CHECK-CONTRACT      THRU 7800-EXIT           
              IF WS-CONTRACT-FLAG = 'Y'                                 
                 MOVE  900                TO S-RETURN-CODE              
                 GO TO 2000-EXIT                                        
              END-IF                                                    
                                                                        
              PERFORM 7900-CHECK-PREPAY-HIST   THRU 7900-EXIT           
              IF WS-PREPAY-FLAG = 'Y'                                   
                 MOVE  600                TO S-RETURN-CODE              
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                 04130000
           PERFORM 7300-CHECK-RATE-PLAN     THRU 7300-EXIT.             
           IF WS-INS-FLAG = 'N'                                         
               MOVE  950                TO S-RETURN-CODE                
               GO TO 2000-EXIT                                          
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04220000
      ***************************************************************   04230000
      * 2200-INS-BILL-MSG-PROCESS.                                  *   04240000
      ***************************************************************   04250000
      *                                                                 04260000
       2200-INS-BILL-MSG-PROCESS.                                       
      *                                                                 04280000
           PERFORM 7300-CHECK-RATE-PLAN     THRU 7300-EXIT.             
           IF WS-INS-FLAG = 'Y'                                         
              MOVE WS-ACCOUNT-NO-NUM      TO U1-ACCOUNT-NO              
              PERFORM 7700-CHECK-SPCL-BILL-MSG   THRU 7700-EXIT         
              IF WS-BILL-MSG-FLAG = 'Y'                                 
                 MOVE  -803               TO S-RETURN-CODE              
              ELSE                                                      
                 PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT             
P00836           PERFORM 8400-DELETE-PREV-BILL-MSG  THRU 8400-EXIT      
                 PERFORM 7500-GET-REVENUE-MONTH     THRU 7500-EXIT      
                 MOVE WS-CURR-REV-MONTH   TO U1-REVENUE-MO-ST           
                 MOVE 'STMNT'             TO U1-BILL-MSG-ID             
                 MOVE 'S'                 TO U1-MSG-TYPE-CD             
                 MOVE AT-COMPANY-NO       TO U1-COMPANY-NO              
                 MOVE 1                   TO U1-BILL-CYCLE-ST           
                 MOVE 21                  TO U1-BILL-CYCLE-END          
                 MOVE WS-CURR-REV-MONTH   TO U1-REVENUE-MO-END          
                 PERFORM 8200-INSERT-SPCL-BILL-MSG  THRU 8200-EXIT      
                 MOVE ZERO                TO S-RETURN-CODE              
                 PERFORM 7600-SELECT-CUR-TIMESTAMP  THRU 7600-EXIT      
                 PERFORM 2300-PROCESS-COMM-DATA     THRU 2300-EXIT      
              END-IF                                                    
           ELSE                                                         
              MOVE  950                TO S-RETURN-CODE                 
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                 04540000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04570000
      ******************************************************************04580000
      * 2300-PROCESS-COMM-DATA                                         *04590000
      ******************************************************************04600000
       2300-PROCESS-COMM-DATA.                                          
      *                                                                 04620000
           MOVE WS-INIT-COMMENTS-LEN   TO WS-INITIAL-COMMENT-TX-LEN.    
           MOVE 'SYSTEM'               TO WS-INIT-COMMENTS-TEXT.        
           MOVE WS-INIT-COMMENTS-TEXT  TO WS-INITIAL-COMMENT-TX-TEXT.   
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE 'O'                    TO KO-COMM-METHOD.               
           MOVE 'I'                    TO KO-COMM-DIRECTION.            
           MOVE '42'                   TO KO-COMM-TYPE-CD.              
           MOVE '51'                   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE 'N'                    TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE 'N'                    TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE SPACES                 TO KO-COMM-ASSOC-CD.             
           MOVE SPACES                 TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
      *                                                                 04970000
           PERFORM 8300-INSERT-COMM-DATA         THRU 8300-EXIT.        
      *                                                                 04990000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05020000
      ***************************************************************** 05030000
      * 5300-GET-TOU-SECURE-ACCT.                                     * 05040000
      ***************************************************************** 05050000
       5300-GET-TOU-SECURE-ACCT.                                        
      *                                                                 05070000
           IF WS-TOU-FLAG = 'N'                                         
              PERFORM 7100-CHECK-TOU-ACCT      THRU 7100-EXIT           
              IF WS-TOU-FLAG = 'Y'                                      
                 MOVE  500                TO S-RETURN-CODE              
                 MOVE 'Y'                 TO WS-TOU-SEC-FL              
                 GO TO 5300-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
           IF WS-SECURE-RATE-FLAG = 'N'                                 
              PERFORM 7940-CHECK-SECURE-RATE   THRU 7940-EXIT           
              IF WS-SECURE-RATE-FLAG = 'Y'                              
                 MOVE  400                TO S-RETURN-CODE              
      *          MOVE 'Y'                 TO WS-TOU-SEC-FL              05200000
      *          GO TO 5300-EXIT                                        05210000
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7920-FETCH-BILL-DET-CUR    THRU 7920-EXIT.           
      *                                                                 05250000
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05290000
      * JOURNALLING COPYBOOK.                                         * 05300000
      * 6530-LOAD-MNT-TRANS-HIST.                                     * 05310000
      ***************************************************************** 05320000
                                                                        
           EXEC SQL                                                     05340000
              INCLUDE CPD00067                                          05350000
           END-EXEC.                                                    05360000
                                                                        
      ***************************************************************** 05380000
      * 7000-SELECT-ACCOUNT.                                          * 05390000
      ***************************************************************** 05400000
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.COMPANY_NO                                      
                    ,AT.MST_SUB_ACCT_IND                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.ACCOUNT_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-ACCT-CREATE-DT                                 
                    ,:AT-ACCOUNT-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     05460000
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                              05470000
MFA-TR*             ,AT.COMPANY_NO                                      05480000
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                05490000
MFA-TR*             ,AT.ACCT_CREATE_DT                                  05500000
MFA-TR*             ,AT.ACCOUNT_NO                                      05510000
MFA-TR*             ,AT.CUSTOMER_NO                                     05520000
MFA-TR*             ,AT.PREMISE_NO                                      05530000
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                             05540000
MFA-TR*             ,:AT-COMPANY-NO                                     05550000
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                               05560000
MFA-TR*             ,:AT-ACCT-CREATE-DT                                 05570000
MFA-TR*             ,:AT-ACCOUNT-NO                                     05580000
MFA-TR*             ,:AT-CUSTOMER-NO                                    05590000
MFA-TR*             ,:AT-PREMISE-NO                                     05600000
MFA-TR*         FROM CSS_ACCOUNT AT                                     05610000
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    05620000
MFA-TR*        WITH UR                                                  05630000
MFA-TR*        QUERYNO 7000                                             05640000
MFA-TR*    END-EXEC.                                                    05650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05840000
A04494***************************************************************** 05850000
A04494* 7050-GET-PREV-DT.                                             * 05860000
A04494***************************************************************** 05870000
A04494 7050-GET-PREV-DT.                                                
A04494*                                                                 05890000
A04494     EXEC SQL                                                     
A04494         SELECT
              DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-2YR-PREV-DT             
A04494     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*        SET :WS-2YR-PREV-DT = CURRENT DATE - 2 YEARS             05910000
MFA-TR*    END-EXEC.                                                    05920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04494*                                                                 05930000
A04494     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04494*                                                                 05950000
A04494     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
A04494         NEXT SENTENCE                                            
A04494     ELSE                                                         
A04494         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04494         MOVE '7050'                  TO ACTIVE-PARAGRAPH         
A04494         MOVE 'SET'                   TO ABEND-FUNCTION           
A04494         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
A04494         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
A04494     END-IF.                                                      
A04494*                                                                 06050000
A04494 7050-EXIT.                                                       
A04494     EXIT.                                                        
A04494*                                                                 06080000
A04494***************************************************************** 06090000
A04494* 7060-GET-PYMNT-END-DT.                                        * 06100000
A04494***************************************************************** 06110000
A04494 7060-GET-PYMNT-END-DT.                                           
A04494*                                                                 06130000
A04494     EXEC SQL                                                     
A04494         SELECT
              DATEADD( DAY, :WS-ADD-DAYS, IIF(TRY_CONVERT(DATE, 
                                                    :DA-DATE-PYMT-START
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-PYMT-START
              ) <> 0) OR (LEN(:DA-DATE-PYMT-START
              ) <> 10), CIS.CHAR2DATE(:DA-DATE-PYMT-START
              ), CONVERT(DATE, :DA-DATE-PYMT-START) ) )
            INTO
              :WS-PYMNT-END-DT          
A04494     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     06140000
MFA-TR*        SET :WS-PYMNT-END-DT = DATE (:DA-DATE-PYMT-START) +      06150000
MFA-TR*                                      :WS-ADD-DAYS DAYS          06160000
MFA-TR*    END-EXEC.                                                    06170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04494*                                                                 06180000
A04494     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04494*                                                                 06200000
A04494     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
A04494         NEXT SENTENCE                                            
A04494     ELSE                                                         
A04494         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04494         MOVE '7060'                  TO ACTIVE-PARAGRAPH         
A04494         MOVE 'SET'                   TO ABEND-FUNCTION           
A04494         MOVE 'DATE_PYMT_START'       TO TABLE-ELEMENT-1          
A04494         MOVE DA-DATE-PYMT-START      TO HOSTVAR-ELEMENT-1        
A04494         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
A04494         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
A04494     END-IF.                                                      
A04494*                                                                 06320000
A04494 7060-EXIT.                                                       
A04494     EXIT.                                                        
A04494*                                                                 06350000
      ***************************************************************** 06360000
      * 7100-CHECK-TOU-ACCT.                                          * 06370000
      ***************************************************************** 06380000
                                                                        
       7100-CHECK-TOU-ACCT.                                             
                                                                        
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-TOU-FLAG                                       
              FROM CSS_RATE_TOU_DEF RJ WITH(READUNCOMMITTED)                    
                  ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                    
              WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                  
                AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE               
                AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO                 
                AND RJ.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE              
                AND RJ.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                
                AND RJ.VERSION_NO_CNTRL =                               
                (SELECT MAX(RT.VERSION_NO_CNTRL)                        
                 FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                 
                 WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE            
                   AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO              
                   AND RT.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE           
                   AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO             
                   AND RT.CODE_STATUS    NOT IN ('T')                   
                   AND RT.FROM_EFFECTIVE_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE))            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     06440000
MFA-TR*       SELECT 'Y'                                                06450000
MFA-TR*         INTO :WS-TOU-FLAG                                       06460000
MFA-TR*       FROM CSS_RATE_TOU_DEF RJ                                  06470000
MFA-TR*           ,CSS_UTIL_ENVRNMT UT                                  06480000
MFA-TR*       WHERE UT.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                  06490000
MFA-TR*         AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE               06500000
MFA-TR*         AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO                 06510000
MFA-TR*         AND RJ.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE              06520000
MFA-TR*         AND RJ.RATE_PLAN_NO   = :BG-RATE-PLAN-NO                06530000
MFA-TR*         AND RJ.VERSION_NO_CNTRL =                               06540000
MFA-TR*         (SELECT MAX(RT.VERSION_NO_CNTRL)                        06550000
MFA-TR*          FROM CSS_RATE_CREATOR RT                               06560000
MFA-TR*          WHERE RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE            06570000
MFA-TR*            AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO              06580000
MFA-TR*            AND RT.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE           06590000
MFA-TR*            AND RT.RATE_PLAN_NO   = :BG-RATE-PLAN-NO             06600000
MFA-TR*            AND RT.CODE_STATUS    NOT IN ('T')                   06610000
MFA-TR*            AND RT.FROM_EFFECTIVE_DT <= CURRENT DATE)            06620000
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                           06630000
MFA-TR*        QUERYNO 7100                                             06640000
MFA-TR*    END-EXEC.                                                    06650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06660000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 06680000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_UTIL_ENVRNMT'      TO TABLE-1                  
               MOVE 'CSS_RATE_TOU_DEF'      TO TABLE-2                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 06820000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06850000
      ***************************************************************** 06860000
      * 7200-CHECK-DFA-TABLE.                                         * 06870000
      ***************************************************************** 06880000
                                                                        
       7200-CHECK-DFA-TABLE.                                            
                                                                        
           MOVE '7200'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
A04494        SELECT TOP(1) NO_SCHED_PYMTS,
              DATE_PYMT_START                                    
A04494          INTO :DA-NO-SCHED-PYMTS                                 
A04494              ,:DA-DATE-PYMT-START                                
                FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                      
              WHERE DA.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             
                AND DA.CODE_DFA_TYPE   = :WS-CODE-DFA-TYPE              
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06940000
MFA-TR*       SELECT NO_SCHED_PYMTS                                     06950000
MFA-TR*             ,DATE_PYMT_START                                    06960000
MFA-TR*         INTO :DA-NO-SCHED-PYMTS                                 06970000
MFA-TR*             ,:DA-DATE-PYMT-START                                06980000
MFA-TR*         FROM CSS_DFA_ACCT DA                                    06990000
MFA-TR*       WHERE DA.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             07000000
MFA-TR*         AND DA.CODE_DFA_TYPE   = :WS-CODE-DFA-TYPE              07010000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              07020000
MFA-TR*       QUERYNO 7200                                              07030000
MFA-TR*     END-EXEC.                                                   07040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07050000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 07070000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DFA_ACCT'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 07200000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07230000
      ***************************************************************** 07240000
      * 7300-CHECK-RATE-PLAN.                                         * 07250000
      ***************************************************************** 07260000
                                                                        
       7300-CHECK-RATE-PLAN.                                            
                                                                        
           MOVE '7300'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-INS-FLAG                                       
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
              WHERE BG.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM              
                AND ((BG.CODE_UTIL_TYPE = 'E' AND                       
                      BG.RATE_PLAN_NO IN ('001','002','006','008','009',
                                          '010','012','014','022')) OR  
                     (BG.CODE_UTIL_TYPE = 'G' AND                       
                      BG.RATE_PLAN_NO IN ('031','31A','31B','32S','32B',
                                          '32V','033','33B','022','101',
                                          '102','115','125','126','127',
                                          '225','227')) OR              
                      BG.CODE_UTIL_TYPE= 'U')                           
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07320000
MFA-TR*       SELECT 'Y'                                                07330000
MFA-TR*         INTO :WS-INS-FLAG                                       07340000
MFA-TR*         FROM CSS_BILLING_DET BG                                 07350000
MFA-TR*       WHERE BG.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM              07360000
MFA-TR*         AND ((BG.CODE_UTIL_TYPE = 'E' AND                       07370000
MFA-TR*               BG.RATE_PLAN_NO IN ('001','002','006','008','009',07380000
MFA-TR*                                   '010','012','014','022')) OR  07390000
MFA-TR*              (BG.CODE_UTIL_TYPE = 'G' AND                       07400000
MFA-TR*               BG.RATE_PLAN_NO IN ('031','31A','31B','32S','32B',07410000
MFA-TR*                                   '32V','033','33B','022','101',07420000
MFA-TR*                                   '102','115','125','126','127',07430000
MFA-TR*                                   '225','227')) OR              07440000
MFA-TR*               BG.CODE_UTIL_TYPE= 'U')                           07450000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              07460000
MFA-TR*       QUERYNO 7300                                              07470000
MFA-TR*     END-EXEC.                                                   07480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07490000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 07510000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 07640000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07670000
      ***************************************************************** 07680000
      * 7400-CHECK-BBP-ACCT.                                          * 07690000
      ***************************************************************** 07700000
                                                                        
       7400-CHECK-BBP-ACCT.                                             
                                                                        
           MOVE '7400'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-BBP-FLAG                                       
                FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                   
              WHERE BH.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             
                AND BH.DATE_PYMT_STRT  >= (DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))      
                AND BH.CHANGE_REASON   <> 'O'                           
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     07760000
MFA-TR*       SELECT 'Y'                                                07770000
MFA-TR*         INTO :WS-BBP-FLAG                                       07780000
MFA-TR*         FROM CSS_BUDGET_HIST BH                                 07790000
MFA-TR*       WHERE BH.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             07800000
MFA-TR*         AND BH.DATE_PYMT_STRT  >= (CURRENT DATE - 2 YEARS)      07810000
MFA-TR*         AND BH.CHANGE_REASON   <> 'O'                           07820000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              07830000
MFA-TR*       QUERYNO 7400                                              07840000
MFA-TR*     END-EXEC.                                                   07850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07860000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 07880000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BUDGET_HIST'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08010000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08040000
      ******************************************************************08050000
      * 7500-GET-REVENUE-MONTH.                                         08060000
      ******************************************************************08070000
      *                                                                 08080000
       7500-GET-REVENUE-MONTH.                                          
      *                                                                 08100000
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,15,06)                            
                INTO :WS-CURR-REV-MONTH                                 
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME   = 'COMMON'                          
                 AND COMPANY_NO     = '01'                              
                 AND CMND_CODE      = 'DATE'                            
                 AND SEQ_NO         = 20                                
                 AND STATUS         = 'A'                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     08110000
MFA-TR*       SELECT SUBSTR(PARM_DATA,15,06)                            08120000
MFA-TR*         INTO :WS-CURR-REV-MONTH                                 08130000
MFA-TR*         FROM CSS_JOB_PARM                                       08140000
MFA-TR*        WHERE PROGRAM_NAME   = 'COMMON'                          08150000
MFA-TR*          AND COMPANY_NO     = '01'                              08160000
MFA-TR*          AND CMND_CODE      = 'DATE'                            08170000
MFA-TR*          AND SEQ_NO         = 20                                08180000
MFA-TR*          AND STATUS         = 'A'                               08190000
MFA-TR*         WITH UR                                                 08200000
MFA-TR*        QUERYNO 7500                                             08210000
MFA-TR*    END-EXEC.                                                    08220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08230000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08250000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_JOB_PARM'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 08380000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08410000
      ******************************************************************08420000
      *  GET THE CURRENT TIMESTAMP                                     *08430000
      ******************************************************************08440000
                                                                        
       7600-SELECT-CUR-TIMESTAMP.                                       
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08480000
MFA-TR*        SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP ,           08490000
MFA-TR*            :WS-CURRENT-DATE     = CURRENT DATE                  08500000
MFA-TR*    END-EXEC.                                                    08510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7600'               TO ACTIVE-PARAGRAPH            
               MOVE 'SET'                TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE SPACES               TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08720000
      ***************************************************************** 08730000
      * 7700-CHECK-SPCL-BILL-MSG.                                     * 08740000
      ***************************************************************** 08750000
                                                                        
       7700-CHECK-SPCL-BILL-MSG.                                        
                                                                        
           MOVE '7700'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-BILL-MSG-FLAG                                  
                FROM CSS_SPCL_BILL_MSG U1 WITH(READUNCOMMITTED)                 
              WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             
P00527          AND U1.BILL_MSG_ID     = 'STMNT'                        
P00527          AND U1.MSG_TYPE_CD     = 'S'                            
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08810000
MFA-TR*       SELECT 'Y'                                                08820000
MFA-TR*         INTO :WS-BILL-MSG-FLAG                                  08830000
MFA-TR*         FROM CSS_SPCL_BILL_MSG U1                               08840000
MFA-TR*       WHERE U1.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             08850000
MFA-TR*         AND U1.BILL_MSG_ID     = 'STMNT'                        08860000
MFA-TR*         AND U1.MSG_TYPE_CD     = 'S'                            08870000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              08880000
MFA-TR*       QUERYNO 7700                                              08890000
MFA-TR*     END-EXEC.                                                   08900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08910000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 08930000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_SPCL_BILL_MSG'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09060000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09090000
      ******************************************************************09100000
      *   ARE WE IN SEB OR CSR?                                        *09110000
      ******************************************************************09120000
                                                                        
       7750-GET-DELINQUENCY-VALUE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
                AND   COMPANY_NO = :AT-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09160000
MFA-TR*       SELECT  DELINQ_VALUE                                      09170000
MFA-TR*       INTO    :C8-DELINQ-VALUE                                  09180000
MFA-TR*       FROM    CSS_DELINQUENCY                                   09190000
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                        09200000
MFA-TR*         AND   COMPANY_NO = :AT-COMPANY-NO                       09210000
MFA-TR*       WITH UR                                                   09220000
MFA-TR*       QUERYNO 7750                                              09230000
MFA-TR*    END-EXEC.                                                    09240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7750'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_DELINQUENCY'       TO TABLE-1                   
              MOVE 'DATABASE'              TO TABLE-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        09440000
                                                                        
      ***************************************************************** 09460000
      * 7800-CHECK-CONTRACT.                                          * 09470000
      ***************************************************************** 09480000
                                                                        
       7800-CHECK-CONTRACT.                                             
                                                                        
           MOVE '7800'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CONTRACT-FLAG                                  
                FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
              WHERE CT.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             
                AND CT.DATE_CONTRACT   >= (DATEADD( YEAR, -2, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))      
                AND CT.CNT_NAME_CD     = 530                            
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     09540000
MFA-TR*       SELECT 'Y'                                                09550000
MFA-TR*         INTO :WS-CONTRACT-FLAG                                  09560000
MFA-TR*         FROM CSS_CONTRACT CT                                    09570000
MFA-TR*       WHERE CT.ACCOUNT_NO      = :WS-ACCOUNT-NO-NUM             09580000
MFA-TR*         AND CT.DATE_CONTRACT   >= (CURRENT DATE - 2 YEARS)      09590000
MFA-TR*         AND CT.CNT_NAME_CD     = 530                            09600000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              09610000
MFA-TR*       QUERYNO 7800                                              09620000
MFA-TR*     END-EXEC.                                                   09630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09640000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 09660000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7800'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CONTRACT'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 09790000
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09820000
      ***************************************************************** 09830000
      * 7850-CHECK-MASTER-SUB.                                        * 09840000
      ***************************************************************** 09850000
                                                                        
       7850-CHECK-MASTER-SUB.                                           
                                                                        
           MOVE '7850'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MASTER-SUB-FLAG                                
                FROM CSS_BILL_ACCT_XFER AF WITH(READUNCOMMITTED)                
               WHERE (AF.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM            
                               OR                                       
                      AF.ACCT_XFER_FROM = :WS-ACCOUNT-NO-NUM)           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09910000
MFA-TR*       SELECT 'Y'                                                09920000
MFA-TR*         INTO :WS-MASTER-SUB-FLAG                                09930000
MFA-TR*         FROM CSS_BILL_ACCT_XFER AF                              09940000
MFA-TR*        WHERE (AF.ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM            09950000
MFA-TR*                        OR                                       09960000
MFA-TR*               AF.ACCT_XFER_FROM = :WS-ACCOUNT-NO-NUM)           09970000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             09980000
MFA-TR*        QUERYNO 7850                                             09990000
MFA-TR*    END-EXEC.                                                    10000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10010000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10030000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7850'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CSS_BILL_ACCT_XFER'    TO TABLE-2                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10170000
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10200000
      ***************************************************************** 10210000
      * 7900-CHECK-PREPAY-HIST.                                       * 10220000
      ***************************************************************** 10230000
                                                                        
       7900-CHECK-PREPAY-HIST.                                          
                                                                        
           MOVE '7900'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-PREPAY-FLAG                                    
                FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                   
              WHERE PK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM          
                AND PK.PREPAY_HIST_SEQ_TS >= (DATEADD( YEAR, -2, 
           CIS.CURRENT$TIMESTAMP() )) 
                                             
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     10290000
MFA-TR*       SELECT 'Y'                                                10300000
MFA-TR*         INTO :WS-PREPAY-FLAG                                    10310000
MFA-TR*         FROM CSS_PREPAY_HIST PK                                 10320000
MFA-TR*       WHERE PK.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM          10330000
MFA-TR*         AND PK.PREPAY_HIST_SEQ_TS >= (CURRENT TIMESTAMP -       10340000
MFA-TR*                                                        2 YEARS) 10350000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              10360000
MFA-TR*       QUERYNO 7900                                              10370000
MFA-TR*     END-EXEC.                                                   10380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10390000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 10410000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7900'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_PREPAY_HIST'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 10540000
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10570000
      ******************************************************************10580000
      *  7910-OPEN-BILL-DET-CUR                                         10590000
      ******************************************************************10600000
      *                                                                 10610000
       7910-OPEN-BILL-DET-CUR.                                          
      *                                                                 10630000
           EXEC SQL                                                     
               OPEN BILL_DET_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
             MOVE PROGRAM-NAME            TO ABEND-PROGRAM              
             MOVE '7910'                  TO ACTIVE-PARAGRAPH           
             MOVE 'OPEN'                  TO ABEND-FUNCTION             
             MOVE SPACES                  TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
             MOVE 'CSS_BILLING_DET'       TO TABLE-1                    
             MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1            
             MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1          
             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT              
           END-IF.                                                      
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10870000
      *  7920-FETCH-BILL-DET-CUR.                                       10880000
      ******************************************************************10890000
                                                                        
       7920-FETCH-BILL-DET-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH BILL_DET_CUR                                       
                INTO :BG-ACCOUNT-NO                                     
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7920'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11200000
      * 7930-CLOSE-BILL-DET-CUR.                                        11210000
      ******************************************************************11220000
       7930-CLOSE-BILL-DET-CUR.                                         
           EXEC SQL                                                     
               CLOSE BILL_DET_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7930'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_BILLING_DET'       TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 11440000
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11470000
      ***************************************************************** 11480000
      * 7940-CHECK-SECURE-RATE .                                      * 11490000
      ***************************************************************** 11500000
                                                                        
       7940-CHECK-SECURE-RATE.                                          
                                                                        
           MOVE '7940'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SECURE-RATE-FLAG                               
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
              WHERE RD.CODE_UTIL_TYPE  = :BG-CODE-UTIL-TYPE             
                AND RD.RATE_PLAN_NO    = :BG-RATE-PLAN-NO               
                AND RD.SECURED_RATE_FL = 'Y'                            
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11560000
MFA-TR*       SELECT 'Y'                                                11570000
MFA-TR*         INTO :WS-SECURE-RATE-FLAG                               11580000
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                              11590000
MFA-TR*       WHERE RD.CODE_UTIL_TYPE  = :BG-CODE-UTIL-TYPE             11600000
MFA-TR*         AND RD.RATE_PLAN_NO    = :BG-RATE-PLAN-NO               11610000
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y'                            11620000
MFA-TR*        WITH UR                                                  11630000
MFA-TR*       QUERYNO 7940                                              11640000
MFA-TR*     END-EXEC.                                                   11650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11660000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 11680000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7940'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_RATE_PLAN_DESC'    TO TABLE-1                  
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL-TYPE'        TO TABLE-ELEMENT-2          
               MOVE BG-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-1        
               MOVE BG-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 11830000
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11860000
      ***************************************************************** 11870000
      * 7950-GET-LAST-BILL-DT.                                        * 11880000
      ***************************************************************** 11890000
                                                                        
       7950-GET-LAST-BILL-DT.                                           
                                                                        
           MOVE '7950'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           BILL_ITEM_TIMESTMP), 121), ' ', '-'), ':', '.')                     
P00836          INTO :BG-BILL-ITEM-TIMESTMP :WS-NULL-IND                 
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
              WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM          
                AND BG.CODE_BILL_CALC     = 'A'                         
                AND BG.CODE_BILL_ITM_TYPE = 'C'                         
                AND BG.CODE_BILL_ITM_IND  = 'A'                         
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11950000
MFA-TR*       SELECT MAX(BILL_ITEM_TIMESTMP)                            11960000
MFA-TR*         INTO :BG-BILL-ITEM-TIMESTMP:WS-NULL-IND                 11970002
MFA-TR*         FROM CSS_BILLING_DET BG                                 11980000
MFA-TR*       WHERE BG.ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM          11990000
MFA-TR*         AND BG.CODE_BILL_CALC     = 'A'                         12000000
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE = 'C'                         12010000
MFA-TR*         AND BG.CODE_BILL_ITM_IND  = 'A'                         12020000
MFA-TR*        WITH UR                                                  12030000
MFA-TR*       QUERYNO 7950                                              12040000
MFA-TR*     END-EXEC.                                                   12050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12060000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 12080000
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00836        IF WS-NULL-IND    < 0                                     
P00836           MOVE SPACES                TO BG-BILL-ITEM-TIMESTMP    
P00836        END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7950'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_BILLING_DET'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 12210000
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12240000
      ****************************************************************  12250000
      * 8100-SEND-RESULT.                                            *  12260000
      ****************************************************************  12270000
      *                                                                 12280000
       8100-SEND-RESULT.                                                
      *                                                                 12300000
           ADD +1                           TO CTR-ROWS.                
      *                                                                 12320000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12350000
      ******************************************************************12360000
      * 8200-INSERT-SPCL-BILL-MSG.                                     *12370000
      ******************************************************************12380000
      *                                                                 12390000
       8200-INSERT-SPCL-BILL-MSG.                                       
      *                                                                 12410000
           EXEC SQL                                                     
             INSERT INTO CSS_SPCL_BILL_MSG                              
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END )                                    
            VALUES (:U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                  TO ABEND-PROGRAM       
              MOVE '8200'                        TO ACTIVE-PARAGRAPH    
              MOVE 'INSERT'                      TO ABEND-FUNCTION      
              MOVE SPACES                        TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
              MOVE 'CSS_SPCL_BILL_MSG'           TO TABLE-1             
              MOVE 'ACCOUNT_NO'                  TO TABLE-ELEMENT-1     
              MOVE U1-ACCOUNT-NO                 TO HOSTVAR-ELEMENT-1   
              MOVE 'BILL_MSG_ID'                 TO TABLE-ELEMENT-2     
              MOVE U1-BILL-MSG-ID                TO HOSTVAR-ELEMENT-2   
              MOVE 'REVENUE_MO_END'              TO TABLE-ELEMENT-3     
              MOVE U1-REVENUE-MO-END             TO HOSTVAR-ELEMENT-3   
              PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT   
              PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT   
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  12860000
      *   8300-INSERT-COMM-DATA                                      *  12870000
      ****************************************************************  12880000
       8300-INSERT-COMM-DATA.                                           
      *                                                                 12900000
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12910000
MFA-TR*         INSERT INTO CSS_COMM_DATA                               12920000
MFA-TR*                 (COMMUNICATION_ID,                              12930000
MFA-TR*                  ACCOUNT_NO,                                    12940000
MFA-TR*                  CUSTOMER_NO,                                   12950000
MFA-TR*                  PREMISE_NO,                                    12960000
MFA-TR*                  COMPANY_NO,                                    12970000
MFA-TR*                  RED_FLAG_IND,                                  12980000
MFA-TR*                  RED_FLAG_EXPIRE_DT,                            12990000
MFA-TR*                  COMM_METHOD,                                   13000000
MFA-TR*                  COMM_DIRECTION,                                13010000
MFA-TR*                  COMM_TYPE_CD,                                  13020000
MFA-TR*                  COMM_SUBTYPE_CODE,                             13030000
MFA-TR*                  USER_ID_ORIG,                                  13040000
MFA-TR*                  CONTACT_NAME,                                  13050000
MFA-TR*                  PROMOTION_ID,                                  13060000
MFA-TR*                  PSC_COMPLIANCE_IND,                            13070000
MFA-TR*                  CALL_ORIGIN_ID,                                13080000
MFA-TR*                  CALL_END_TIME,                                 13090000
MFA-TR*                  NUMBER_TRANSFERS,                              13100000
MFA-TR*                  HOLD_TIME,                                     13110000
MFA-TR*                  QUEUE_TIME,                                    13120000
MFA-TR*                  SCREEN_POP_IND,                                13130000
MFA-TR*                  TOTAL_CALL_TIME,                               13140000
MFA-TR*                  INITIAL_COMMENT_TX,                            13150000
MFA-TR*                  RESPONSE_REASON_CD,                            13160000
MFA-TR*                  RESPONSE_TYPE_CD,                              13170000
MFA-TR*                  SOLICITATION_CD,                               13180000
MFA-TR*                  COMM_ASSOC_CD,                                 13190000
MFA-TR*                  COMPLAINT_FL,                                  13200000
MFA-TR*                  DISCOVERY_MTHD_CD,                             13210000
MFA-TR*                  PREV_MARKETER_CD)                              13220000
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                            13230000
MFA-TR*                  :KO-ACCOUNT-NO,                                13240000
MFA-TR*                  :KO-CUSTOMER-NO,                               13250000
MFA-TR*                  :KO-PREMISE-NO,                                13260000
MFA-TR*                  :KO-COMPANY-NO,                                13270000
MFA-TR*                  :KO-RED-FLAG-IND,                              13280000
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,     13290000
MFA-TR*                  :KO-COMM-METHOD,                               13300000
MFA-TR*                  :KO-COMM-DIRECTION,                            13310000
MFA-TR*                  :KO-COMM-TYPE-CD,                              13320000
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                         13330000
MFA-TR*                  :KO-USER-ID-ORIG,                              13340000
MFA-TR*                  :KO-CONTACT-NAME,                              13350000
MFA-TR*                  :KO-PROMOTION-ID,                              13360000
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                        13370000
MFA-TR*                  :KO-CALL-ORIGIN-ID,                            13380000
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,             13390000
MFA-TR*                  :KO-NUMBER-TRANSFERS,                          13400000
MFA-TR*                  :KO-HOLD-TIME,                                 13410000
MFA-TR*                  :KO-QUEUE-TIME,                                13420000
MFA-TR*                  :KO-SCREEN-POP-IND,                            13430000
MFA-TR*                  :KO-TOTAL-CALL-TIME,                           13440000
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                        13450000
MFA-TR*                  :KO-RESPONSE-REASON-CD,                        13460000
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                          13470000
MFA-TR*                  :KO-SOLICITATION-CD,                           13480000
MFA-TR*                  :KO-COMM-ASSOC-CD,                             13490000
MFA-TR*                  :KO-COMPLAINT-FL,                              13500000
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                         13510000
MFA-TR*                  :KO-PREV-MARKETER-CD)                          13520000
MFA-TR*    END-EXEC.                                                    13530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13540000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 13570000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE ACTIVE-PARAGRAPH      TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE KO-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 13720000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13750000
P00836******************************************************************13751005
P00836* 8400-DELETE-PREV-BILL-MSG.                                    * 13752005
P00836******************************************************************13753005
P00836*                                                                 13754005
P00836 8400-DELETE-PREV-BILL-MSG.                                       
P00836*                                                                 13756005
P00836     EXEC SQL                                                     
P00836         DELETE FROM CSS_SPCL_BILL_MSG                            
P00836               WHERE ACCOUNT_NO     = :U1-ACCOUNT-NO              
P00836                 AND BILL_MSG_ID    IN ('ST12E','ST24E')          
P00836                 AND MSG_TYPE_CD    = 'S'                         
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00836*                                                                 13759705
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00836         CONTINUE                                                 
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00836        MOVE SQLCODE               TO ABEND-SQLCODE               
P00836        MOVE '8400'                TO ACTIVE-PARAGRAPH            
P00836        MOVE 'DELETE'              TO ABEND-FUNCTION              
P00836        MOVE 'CSS_SPCL_BILL_MSG'   TO TABLE-1                     
P00836        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00836        MOVE 'BILL_MSG_ID'         TO TABLE-ELEMENT-2             
P00836        MOVE 'MSG_TYPE_CD'         TO TABLE-ELEMENT-3             
P00836        MOVE U1-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00836        MOVE 'STM12'               TO HOSTVAR-ELEMENT-2           
P00836        MOVE 'S'                   TO HOSTVAR-ELEMENT-3           
P00836        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00836        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00836     END-IF.                                                      
P00836*                                                                 13761605
P00836 8400-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 13761905
      ******************************************************************13764000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     13770000
      ******************************************************************13780000
           EXEC SQL                                                     13790000
              INCLUDE CPDSP300                                          13800000
           END-EXEC.                                                    13810000
      *                                                                 13820000
           EXEC SQL                                                     13830000
               INCLUDE CPD00321                                         13840000
           END-EXEC.                                                    13850000
      *                                                                 13860000
      ***************************************************************** 13870000
      *9900-ABEND.                                                    * 13880000
      ***************************************************************** 13890000
      *                                                                 13900000
       9900-ABEND.                                                      
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                 13940000
