       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04521.                                         
COB303 DATE-WRITTEN.  OCTOBER 19, 2011                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *        
      *        CSR04521 CLONED FROM SP CSR02287 ON 10/19/2011          *        
      *             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S287                                           *        
      *  PROGRAM:       S287                                           *        
      *  CALLING SP:    PA_S287                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE INSERTS/UPDATES/DELETES SPECIAL FACTOR         *        
      *  DEFINITION INFORMATION IN CSS_SPCL_FCTR.                      *        
      *                                                                *        
      *    # APPL-RETURN-CODE:                                         *        
      *                                                                *        
      *        210 - 803 SQLCODE ERROR WHEN A FACTOR ALREADY EXISTS.   *        
      *              IF ACTION CODE IS INSERT.                         *        
      *        220 - WHEN SF-ADJUST-ELEMENT = 'H' OR 'I' OR 'J' OR 'O' *        
      *        226 - 532 SQLCODE ERROR WHEN DELETING FROM CSS_SPCL_FCTR*        
      *        235 - 803 SQLCODE ERROR WHEN A FACTOR ALREADY EXISTS.            
      *              IF ACTION CODE IS INSERT.                         *        
      *        237 - PROC REQUEST ID IS INVALID                        *        
      ******************************************************************        
      *    PARAMETERS                                                  *        
      *        IN                                                      *        
      *              APPL_PROG_ID       CHAR(03)                       *        
      *              USER_ID            CHAR(07)                       *        
      *              ACTION_CODE        CHAR(01)                       *        
      *              FACTOR_ID          CHAR(09)                       *        
      *              FACTOR_TEXT        CHAR(20)                       *        
      *              FACTOR_DESC        CHAR(60)                       *        
      *              FACTOR_TYPE        CHAR(01)                       *        
      *              CHECK_ELEMENT      CHAR(01)                       *        
      *              CALC_TYPE_CD       CHAR(01)                       *        
      *              ADJUST_ELEMENT     CHAR(01)                       *        
      *              RATE_ELEC_FCTR     CHAR(01)                       *        
      *              RATE_GAS_FCTR      CHAR(01)                       *        
      *              RATE_UNMTRD_FCTR   CHAR(01)                       *        
      *              RATE_DEMAND_FCTR   CHAR(01)                       *        
      *              RATE_ON_PEAK_FCTR  CHAR(01)                       *        
      *              RATE_OFF_PEAK_FCTR CHAR(01)                       *        
      *              RATE_SHOULDER_FCTR CHAR(01)                       *        
      *              RATE_SUMMER_FCTR   CHAR(01)                       *        
      *              RATE_WINTER_FCTR   CHAR(01)                       *        
      *              RATE_USAGE_FCTR    CHAR(01)                       *        
      *              CODE_TAX_STAT_XMT  CHAR(01)                       *        
      *              CODE_TAX_CITY_XMT  CHAR(01)                       *        
      *              CODE_TAX_OTHR_XMT  CHAR(01)                       *        
      *              GL_ACCT_NO         CHAR(07)                       *        
      *              USER_ID_UPD_BY     CHAR(07)                       *        
      *              VERS_PRORATE_CD    CHAR(01)                       *        
      *              PRORATE_FL         CHAR(01)                       *        
      *              SPCL_GROUP_CD      CHAR(02)                       *        
      *              RATE_TEMPLATE_FL   CHAR(01)                       *        
      *              FACTOR_HISTORY_CD  CHAR(01)                       *        
      *              REV_INTERFACE_FL   CHAR(01)                       *        
      *              RT_ATTR_INCTV_TYPE CHAR(15)                       *        
      *              DURATION_TYPE_CD   CHAR(01)                       *        
      *              DURATION_START_CD  CHAR(01)                       *        
      *              OVR_RT_VER_PRO_FL  CHAR(01)                       *        
      *              OVR_RT_CALC_TYP_CD CHAR(02)                       *        
      *              OVR_RATE_DESC      CHAR(50)                       *        
      *              BILL_PRT_MSG_PL_CD CHAR(03)                       *        
      *              BILL_PRT_LN_ITM_FL CHAR(01)                       *        
      *              CODE_DR_CR         CHAR(01)                       *        
      *              DEFLT_DURATION_NO  CHAR(04)                       *        
      *              SPCL_CALC_CD       CHAR(02)                       *        
      *              TEMPLATE_FACTOR_ID CHAR(09)                       *        
      *              CODE_STATUS        CHAR(01)                       *        
      *              FCTR_POWER_10      SMALLINT                       *        
      *              PROC_REQ_ID        CHAR(10)                       *        
      *              BILL_PRT_FCTR_CD   CHAR(01)                       *        
      *              BILL_PRT_UNITS_CD  CHAR(01)                       *        
      *              BILL_PRT_SEQ_NO    SMALLINT                       *        
      *              FCTR_ELEM_APPL_CD  CHAR(01)                       *        
      *              DELETE_BY_REQUEST  CHAR(01)                       *        
PRJ680*              MULTI_VRSN_BA_CD   CHAR(01)                       *        
PRJ680*              FCTR_DECIMAL_PLACE SMALLINT                       *        
      *        INOUT                                                   *        
      *                NONE                                            *        
      *        OUT                                                     *        
      *                REFER RESULT SET                                *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *                RETURN_CODE           INTEGER                   *        
      *                APPL_RETURN_CODE      INTEGER                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/19/11    NS74550  CREATED.                                 *        
PRJ473*  07/02/11    MS93554  ADDED DELETE BY REQUEST LOGIC.           *        
PRJ473*  02/19/13    MS93554  UPDATE MULTI_VRSN_BA_CD & FCTR_DECIMAL   *        
      *                       _PRICE IN CSS_SPCL_FCTR TABLE.           *        
ACT004*  06/01/16    TP7R341  REMOVING UNWANTED COLUMNS FROM TABLE     *        
ACT004*   A04177              CSS_SPCL_FCTR                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04521'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04521 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCT_CMPNT, SK                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFCTCMP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS.                         
           COPY CWS00027.                                                       
                                                                        
      * SUPPORTS DB2 AND SQL ERROR CHECKING.                                    
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04521'.     
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-532                   PIC S9(9) VALUE -532 COMP.      
           05  WS-803                   PIC S9(9) VALUE -803 COMP.      
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-APPL-PGM-ID        PIC X(03) VALUE SPACES.          
           05  PARM-USER-ID            PIC X(07) VALUE SPACES.          
           05  PARM-ACTION-CODE        PIC X(01) VALUE SPACES.          
           05  PARM-FACTOR-ID          PIC X(09) VALUE SPACES.          
           05  PARM-FACTOR-TEXT        PIC X(20) VALUE SPACES.          
           05  PARM-FACTOR-DESC        PIC X(60) VALUE SPACES.          
           05  PARM-FACTOR-TYPE        PIC X(01) VALUE SPACES.          
           05  PARM-CHECK-ELEMENT      PIC X(01) VALUE SPACES.          
           05  PARM-CALC-TYPE-CD       PIC X(01) VALUE SPACES.          
           05  PARM-ADJUST-ELEMENT     PIC X(01) VALUE SPACES.          
           05  PARM-RATE-ELEC-FCTR     PIC X(01) VALUE SPACES.          
           05  PARM-RATE-GAS-FCTR      PIC X(01) VALUE SPACES.          
           05  PARM-RATE-UNMTRD-FCTR   PIC X(01) VALUE SPACES.          
           05  PARM-RATE-DEMAND-FCTR   PIC X(01) VALUE SPACES.          
           05  PARM-RATE-ON-PEAK-FCTR  PIC X(01) VALUE SPACES.          
           05  PARM-RATE-OFF-PEAK-FCTR PIC X(01) VALUE SPACES.          
           05  PARM-RATE-SHOULDER-FCTR PIC X(01) VALUE SPACES.          
           05  PARM-RATE-SUMMER-FCTR   PIC X(01) VALUE SPACES.          
           05  PARM-RATE-WINTER-FCTR   PIC X(01) VALUE SPACES.          
           05  PARM-RATE-USAGE-FCTR    PIC X(01) VALUE SPACES.          
      *                                                                         
           05  PARM-GL-ACCT-NO         PIC X(07)       VALUE SPACES.    
           05  PARM-GL-ACCT-NO-RED     REDEFINES PARM-GL-ACCT-NO        
                                       PIC 9(07).                       
           05  PARM-GL-ACCT-NO-INT     PIC S9(07)      COMP-3 VALUE 0.  
           05  PARM-GL-ACCT-NO-NUM     PIC S9(3)V9(4)  COMP-3 VALUE 0.  
      *                                                                         
           05  PARM-CODE-TAX-STAT-XMT  PIC X(01) VALUE SPACES.          
           05  PARM-CODE-TAX-CITY-XMT  PIC X(01) VALUE SPACES.          
           05  PARM-CODE-TAX-OTHR-XMT  PIC X(01) VALUE SPACES.          
           05  PARM-USER-ID-UPD-BY     PIC X(07) VALUE SPACES.          
           05  PARM-VERS-PRORATE-CD    PIC X(01) VALUE SPACES.          
           05  PARM-PRORATE-FL         PIC X(01) VALUE SPACES.          
           05  PARM-SPCL-GROUP-CD      PIC X(02) VALUE SPACES.          
           05  PARM-RATE-TEMPLATE-FL   PIC X(01) VALUE SPACES.          
           05  PARM-FACTOR-HISTORY-CD  PIC X(01) VALUE SPACES.          
           05  PARM-REV-INTERFACE-FL   PIC X(01) VALUE SPACES.          
           05  PARM-RT-ATTR-INCTV-TYPE PIC X(15) VALUE SPACES.          
           05  PARM-DURATION-TYPE-CD   PIC X(01) VALUE SPACES.          
           05  PARM-DURATION-START-CD  PIC X(01) VALUE SPACES.          
           05  PARM-OVR-RT-VER-PRO-FL  PIC X(01) VALUE SPACES.          
           05  PARM-OVR-RT-CALC-TYP-CD PIC X(02) VALUE SPACES.          
           05  PARM-OVR-RATE-DESC      PIC X(50) VALUE SPACES.          
           05  PARM-BILL-PRT-MSG-PL-CD PIC X(03) VALUE SPACES.          
           05  PARM-BILL-PRT-LN-ITM-FL PIC X(01) VALUE SPACES.          
           05  PARM-CODE-DR-CR         PIC X(01) VALUE SPACES.          
           05  PARM-DEFLT-DURATION-NO  PIC X(04) VALUE SPACES.          
           05  PARM-SPECIAL-CALC-CD    PIC X(02) VALUE SPACES.          
           05  PARM-TEMPLATE-FACTOR-ID PIC X(09) VALUE SPACES.          
           05  PARM-CODE-STATUS        PIC X(01) VALUE SPACES.          
           05  PARM-POWER-FACTOR-10    PIC S9(4) COMP VALUE 0.          
      *                                                                         
           05  PARM-PROC-REQ-ID        PIC X(10)       VALUE SPACES.    
           05  PARM-PROC-REQ-ID-RED    REDEFINES PARM-PROC-REQ-ID       
                                       PIC 9(10).                       
           05  PARM-PROC-REQ-ID-INT    PIC S9(10)      COMP-3 VALUE 0.  
           05  PARM-PROC-REQ-ID-NUM    PIC S9(10)V     COMP-3 VALUE 0.  
      *                                                                         
           05  PARM-BILL-PRT-FCTR-CD   PIC X(01) VALUE SPACES.          
           05  PARM-BILL-PRT-UNITS-CD  PIC X(01) VALUE SPACES.          
           05  PARM-BILL-PRT-SEQ-NO    PIC S9(4) COMP VALUE 0.          
           05  PARM-FCTR-ELEM-APPL-CD  PIC X(01) VALUE SPACES.          
           05  PARM-DELETE-BY-REQUEST  PIC X(01) VALUE SPACES.          
PRJ680     05  PARM-MULTI-VRSN-BA-CD   PIC X(01) VALUE SPACES.          
PRJ680     05  PARM-FCTR-DECIMAL-PLACE PIC S9(04) COMP VALUE 0.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-SPACES               PIC X(03) VALUE SPACES.          
           05  WS-DEFLT-DURATION-NO    PIC X(04) JUSTIFIED RIGHT.       
           05  WS-DEFLT-DURATION-NO-NUM REDEFINES                       
               WS-DEFLT-DURATION-NO    PIC 9(4).                        
           05  WS-DFT-DURATION-NO-NULL PIC S9(04) COMP VALUE +0.        
               88 DFT-DURATION-NO-NULL           VALUE -1.              
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-CSS-FCT-CMPNT-EXISTS  PIC X(01) VALUE 'N'.            
               88  ROW-IN-CSS-FCT-CMPNT           VALUE 'Y'.            
               88  ROW-NOT-IN-CSS-FCT-CMPNT       VALUE 'N'.            
                                                                        
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-APPL-PGM-ID         PIC X(03)                .          
       01  LINK-USER-ID             PIC X(07)                .          
       01  LINK-ACTION-CODE         PIC X(01)                .          
       01  LINK-FACTOR-ID           PIC X(09)                .          
       01  LINK-FACTOR-TEXT         PIC X(20)                .          
       01  LINK-FACTOR-DESC         PIC X(60)                .          
       01  LINK-FACTOR-TYPE         PIC X(01)                .          
       01  LINK-CHECK-ELEMENT       PIC X(01)                .          
       01  LINK-CALC-TYPE-CD        PIC X(01)                .          
       01  LINK-ADJUST-ELEMENT      PIC X(01)                .          
       01  LINK-RATE-ELEC-FCTR      PIC X(01)                .          
       01  LINK-RATE-GAS-FCTR       PIC X(01)                .          
       01  LINK-RATE-UNMTRD-FCTR    PIC X(01)                .          
       01  LINK-RATE-DEMAND-FCTR    PIC X(01)                .          
       01  LINK-RATE-ON-PEAK-FCTR   PIC X(01)                .          
       01  LINK-RATE-OFF-PEAK-FCTR  PIC X(01)                .          
       01  LINK-RATE-SHOULDER-FCTR  PIC X(01)                .          
       01  LINK-RATE-SUMMER-FCTR    PIC X(01)                .          
       01  LINK-RATE-WINTER-FCTR    PIC X(01)                .          
       01  LINK-RATE-USAGE-FCTR     PIC X(01)                .          
       01  LINK-CODE-TAX-STAT-XMT   PIC X(01)                .          
       01  LINK-CODE-TAX-CITY-XMT   PIC X(01)                .          
       01  LINK-CODE-TAX-OTHR-XMT   PIC X(01)                .          
       01  LINK-GL-ACCT-NO          PIC X(07)                .          
       01  LINK-USER-ID-UPD-BY      PIC X(07)                .          
       01  LINK-VERS-PRORATE-CD     PIC X(01)                .          
       01  LINK-PRORATE-FL          PIC X(01)                .          
       01  LINK-SPCL-GROUP-CD       PIC X(02)                .          
       01  LINK-RATE-TEMPLATE-FL    PIC X(01)                .          
       01  LINK-FACTOR-HISTORY-CD   PIC X(01)                .          
       01  LINK-REV-INTERFACE-FL    PIC X(01)                .          
       01  LINK-RT-ATTR-INCTV-TYPE  PIC X(15)                .          
       01  LINK-DURATION-TYPE-CD    PIC X(01)                .          
       01  LINK-DURATION-START-CD   PIC X(01)                .          
       01  LINK-OVR-RT-VER-PRO-FL   PIC X(01)                .          
       01  LINK-OVR-RT-CALC-TYP-CD  PIC X(02)                .          
       01  LINK-OVR-RATE-DESC       PIC X(50)                .          
       01  LINK-BILL-PRT-MSG-PL-CD  PIC X(03)                .          
       01  LINK-BILL-PRT-LN-ITM-FL  PIC X(01)                .          
       01  LINK-CODE-DR-CR          PIC X(01)                .          
       01  LINK-DEFLT-DURATION-NO   PIC X(04)                .          
       01  LINK-SPECIAL-CALC-CD     PIC X(02)                .          
       01  LINK-TEMPLATE-FACTOR-ID  PIC X(09)                .          
       01  LINK-CODE-STATUS         PIC X(01)                .          
       01  LINK-POWER-FACTOR-10     PIC S9(4) COMP VALUE 0   .          
       01  LINK-PROC-REQ-ID         PIC X(10)                .          
       01  LINK-BILL-PRT-FCTR-CD    PIC X(01)                .          
       01  LINK-BILL-PRT-UNITS-CD   PIC X(01)                .          
       01  LINK-BILL-PRT-SEQ-NO     PIC S9(4) COMP  VALUE 0  .          
       01  LINK-FCTR-ELEM-APPL-CD   PIC X(01)                .          
PRJ473 01  LINK-DELETE-BY-REQUEST   PIC X(01)                .          
PRJ680 01  LINK-MULTI-VRSN-BA-CD    PIC X(01)                .          
PRJ680 01  LINK-FCTR-DECIMAL-PLACE  PIC S9(04) COMP VALUE 0  .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-APPL-PGM-ID                                        
               ,LINK-USER-ID                                            
               ,LINK-ACTION-CODE                                        
               ,LINK-FACTOR-ID                                          
               ,LINK-FACTOR-TEXT                                        
               ,LINK-FACTOR-DESC                                        
               ,LINK-FACTOR-TYPE                                        
               ,LINK-CHECK-ELEMENT                                      
               ,LINK-CALC-TYPE-CD                                       
               ,LINK-ADJUST-ELEMENT                                     
               ,LINK-RATE-ELEC-FCTR                                     
               ,LINK-RATE-GAS-FCTR                                      
               ,LINK-RATE-UNMTRD-FCTR                                   
               ,LINK-RATE-DEMAND-FCTR                                   
               ,LINK-RATE-ON-PEAK-FCTR                                  
               ,LINK-RATE-OFF-PEAK-FCTR                                 
               ,LINK-RATE-SHOULDER-FCTR                                 
               ,LINK-RATE-SUMMER-FCTR                                   
               ,LINK-RATE-WINTER-FCTR                                   
               ,LINK-RATE-USAGE-FCTR                                    
               ,LINK-CODE-TAX-STAT-XMT                                  
               ,LINK-CODE-TAX-CITY-XMT                                  
               ,LINK-CODE-TAX-OTHR-XMT                                  
               ,LINK-GL-ACCT-NO                                         
               ,LINK-USER-ID-UPD-BY                                     
               ,LINK-VERS-PRORATE-CD                                    
               ,LINK-PRORATE-FL                                         
               ,LINK-SPCL-GROUP-CD                                      
               ,LINK-RATE-TEMPLATE-FL                                   
               ,LINK-FACTOR-HISTORY-CD                                  
               ,LINK-REV-INTERFACE-FL                                   
               ,LINK-RT-ATTR-INCTV-TYPE                                 
               ,LINK-DURATION-TYPE-CD                                   
               ,LINK-DURATION-START-CD                                  
               ,LINK-OVR-RT-VER-PRO-FL                                  
               ,LINK-OVR-RT-CALC-TYP-CD                                 
               ,LINK-OVR-RATE-DESC                                      
               ,LINK-BILL-PRT-MSG-PL-CD                                 
               ,LINK-BILL-PRT-LN-ITM-FL                                 
               ,LINK-CODE-DR-CR                                         
               ,LINK-DEFLT-DURATION-NO                                  
               ,LINK-SPECIAL-CALC-CD                                    
               ,LINK-TEMPLATE-FACTOR-ID                                 
               ,LINK-CODE-STATUS                                        
               ,LINK-POWER-FACTOR-10                                    
               ,LINK-PROC-REQ-ID                                        
               ,LINK-BILL-PRT-FCTR-CD                                   
               ,LINK-BILL-PRT-UNITS-CD                                  
               ,LINK-BILL-PRT-SEQ-NO                                    
               ,LINK-FCTR-ELEM-APPL-CD                                  
PRJ473         ,LINK-DELETE-BY-REQUEST                                  
PRJ680         ,LINK-MULTI-VRSN-BA-CD                                   
PRJ680         ,LINK-FCTR-DECIMAL-PLACE.                                
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      *                                                                *        
      *     CALLED BY: NONE                                            *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY:  0000-MAINLINE                                  *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-APPL-RETURN-CODE         AS    APPL_RETURN_CODE        
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-APPL-RETURN-CODE         AS    APPL_RETURN_CODE                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-APPL-PGM-ID          TO PARM-APPL-PGM-ID         . 
           MOVE LINK-USER-ID              TO PARM-USER-ID             . 
           MOVE LINK-ACTION-CODE          TO PARM-ACTION-CODE         . 
           MOVE LINK-FACTOR-ID            TO PARM-FACTOR-ID           . 
           MOVE LINK-FACTOR-TEXT          TO PARM-FACTOR-TEXT         . 
           MOVE LINK-FACTOR-DESC          TO PARM-FACTOR-DESC         . 
           MOVE LINK-FACTOR-TYPE          TO PARM-FACTOR-TYPE         . 
           MOVE LINK-CHECK-ELEMENT        TO PARM-CHECK-ELEMENT       . 
           MOVE LINK-CALC-TYPE-CD         TO PARM-CALC-TYPE-CD        . 
           MOVE LINK-ADJUST-ELEMENT       TO PARM-ADJUST-ELEMENT      . 
           MOVE LINK-RATE-ELEC-FCTR       TO PARM-RATE-ELEC-FCTR      . 
           MOVE LINK-RATE-GAS-FCTR        TO PARM-RATE-GAS-FCTR       . 
           MOVE LINK-RATE-UNMTRD-FCTR     TO PARM-RATE-UNMTRD-FCTR    . 
           MOVE LINK-RATE-DEMAND-FCTR     TO PARM-RATE-DEMAND-FCTR    . 
           MOVE LINK-RATE-ON-PEAK-FCTR    TO PARM-RATE-ON-PEAK-FCTR   . 
           MOVE LINK-RATE-OFF-PEAK-FCTR   TO PARM-RATE-OFF-PEAK-FCTR  . 
           MOVE LINK-RATE-SHOULDER-FCTR   TO PARM-RATE-SHOULDER-FCTR  . 
           MOVE LINK-RATE-SUMMER-FCTR     TO PARM-RATE-SUMMER-FCTR    . 
           MOVE LINK-RATE-WINTER-FCTR     TO PARM-RATE-WINTER-FCTR    . 
           MOVE LINK-RATE-USAGE-FCTR      TO PARM-RATE-USAGE-FCTR     . 
           MOVE LINK-CODE-TAX-STAT-XMT    TO PARM-CODE-TAX-STAT-XMT   . 
           MOVE LINK-CODE-TAX-CITY-XMT    TO PARM-CODE-TAX-CITY-XMT   . 
           MOVE LINK-CODE-TAX-OTHR-XMT    TO PARM-CODE-TAX-OTHR-XMT   . 
           MOVE LINK-GL-ACCT-NO           TO PARM-GL-ACCT-NO          . 
           MOVE LINK-USER-ID-UPD-BY       TO PARM-USER-ID-UPD-BY      . 
           MOVE LINK-VERS-PRORATE-CD      TO PARM-VERS-PRORATE-CD     . 
           MOVE LINK-PRORATE-FL           TO PARM-PRORATE-FL          . 
           MOVE LINK-SPCL-GROUP-CD        TO PARM-SPCL-GROUP-CD       . 
           MOVE LINK-RATE-TEMPLATE-FL     TO PARM-RATE-TEMPLATE-FL    . 
           MOVE LINK-FACTOR-HISTORY-CD    TO PARM-FACTOR-HISTORY-CD   . 
           MOVE LINK-REV-INTERFACE-FL     TO PARM-REV-INTERFACE-FL    . 
           MOVE LINK-RT-ATTR-INCTV-TYPE   TO PARM-RT-ATTR-INCTV-TYPE  . 
           MOVE LINK-DURATION-TYPE-CD     TO PARM-DURATION-TYPE-CD    . 
           MOVE LINK-DURATION-START-CD    TO PARM-DURATION-START-CD   . 
           MOVE LINK-OVR-RT-VER-PRO-FL    TO PARM-OVR-RT-VER-PRO-FL   . 
           MOVE LINK-OVR-RT-CALC-TYP-CD   TO PARM-OVR-RT-CALC-TYP-CD  . 
           MOVE LINK-OVR-RATE-DESC        TO PARM-OVR-RATE-DESC       . 
           MOVE LINK-BILL-PRT-MSG-PL-CD   TO PARM-BILL-PRT-MSG-PL-CD  . 
           MOVE LINK-BILL-PRT-LN-ITM-FL   TO PARM-BILL-PRT-LN-ITM-FL  . 
           MOVE LINK-CODE-DR-CR           TO PARM-CODE-DR-CR          . 
           MOVE LINK-DEFLT-DURATION-NO    TO PARM-DEFLT-DURATION-NO   . 
           MOVE LINK-SPECIAL-CALC-CD      TO PARM-SPECIAL-CALC-CD     . 
           MOVE LINK-TEMPLATE-FACTOR-ID   TO PARM-TEMPLATE-FACTOR-ID  . 
           MOVE LINK-CODE-STATUS          TO PARM-CODE-STATUS         . 
           MOVE LINK-POWER-FACTOR-10      TO PARM-POWER-FACTOR-10     . 
           MOVE LINK-PROC-REQ-ID          TO PARM-PROC-REQ-ID         . 
           MOVE LINK-BILL-PRT-FCTR-CD     TO PARM-BILL-PRT-FCTR-CD    . 
           MOVE LINK-BILL-PRT-UNITS-CD    TO PARM-BILL-PRT-UNITS-CD   . 
           MOVE LINK-BILL-PRT-SEQ-NO      TO PARM-BILL-PRT-SEQ-NO     . 
           MOVE LINK-FCTR-ELEM-APPL-CD    TO PARM-FCTR-ELEM-APPL-CD   . 
PRJ473     MOVE LINK-DELETE-BY-REQUEST    TO PARM-DELETE-BY-REQUEST   . 
PRJ680     MOVE LINK-MULTI-VRSN-BA-CD     TO PARM-MULTI-VRSN-BA-CD    . 
PRJ680     MOVE LINK-FCTR-DECIMAL-PLACE   TO PARM-FCTR-DECIMAL-PLACE  . 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      *     CALLED BY:  0000-MAINLINE                                  *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-GL-ACCT-NO-RED    TO PARM-GL-ACCT-NO-INT.          
           MOVE PARM-PROC-REQ-ID-RED   TO PARM-PROC-REQ-ID-INT.         
                                                                        
PRJ473     IF (PARM-ACTION-CODE = 'I' OR PARM-ACTION-CODE = 'T'         
PRJ473                                OR PARM-ACTION-CODE = 'D')        
PRJ473        IF PARM-PROC-REQ-ID-INT GREATER THAN ZERO                 
PRJ473           MOVE PARM-PROC-REQ-ID-INT TO PARM-PROC-REQ-ID-NUM      
PRJ473        ELSE                                                      
PRJ473           MOVE 237                  TO S-APPL-RETURN-CODE        
PRJ473           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
PRJ473           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
PRJ473           PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
PRJ473        END-IF                                                    
PRJ473     END-IF.                                                      
                                                                        
PRJ473     IF PARM-ACTION-CODE       EQUAL 'D' AND                      
PRJ473        PARM-DELETE-BY-REQUEST EQUAL 'Y'                          
PRJ473        MOVE PARM-PROC-REQ-ID-NUM    TO SF-PROC-REQ-ID            
PRJ473        PERFORM 7200-GET-KEY-VALUES-SF  THRU 7200-EXIT            
PRJ473        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
PRJ473           MOVE SF-FACTOR-ID            TO PARM-FACTOR-ID         
PRJ473        ELSE                                                      
PRJ473           MOVE 237                  TO S-APPL-RETURN-CODE        
PRJ473           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
PRJ473           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
PRJ473           PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
PRJ473        END-IF                                                    
PRJ473     END-IF.                                                      
                                                                        
           IF PARM-GL-ACCT-NO-INT NOT EQUAL ZERO                        
              COMPUTE PARM-GL-ACCT-NO-NUM =                             
                  (PARM-GL-ACCT-NO-INT / 10000)                         
           ELSE                                                         
              MOVE ZERO                TO PARM-GL-ACCT-NO-NUM           
           END-IF.                                                      
                                                                        
           IF PARM-DEFLT-DURATION-NO NOT = SPACES                       
              UNSTRING PARM-DEFLT-DURATION-NO DELIMITED BY ' '          
                                        INTO WS-DEFLT-DURATION-NO       
           ELSE                                                         
              MOVE PARM-DEFLT-DURATION-NO TO WS-DEFLT-DURATION-NO       
           END-IF.                                                      
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE/INSERT/DELETE DB2 TABLE DATA.                    *        
      *     3. SEND RESULT SET                                         *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-PROCESS-FACTOR-UPDATE   THRU 5000-EXIT.         
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE      TO S-RETURN-CODE.                 
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 5000-PROCESS-FACTOR-UPDATE                                     *        
      *     BASED ON THE PASSED ACTION CODE, PERFORM THE               *        
      *     UPDATE/INSERT/DELETE.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       5000-PROCESS-FACTOR-UPDATE.                                      
                                                                        
           PERFORM 5100-FORMAT-ROW-VARIABLES    THRU 5100-EXIT.         
                                                                        
           EVALUATE PARM-ACTION-CODE                                    
            WHEN 'U'                                                    
              PERFORM 8200-UPDATE-SPCL-FCTR     THRU 8200-EXIT          
            WHEN 'D'                                                    
              PERFORM 8300-DELETE-SPCL-FCTR     THRU 8300-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL WS-532                     
                 MOVE 226                 TO S-APPL-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 8100-SEND-RESULT    THRU 8100-EXIT             
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
              END-IF                                                    
            WHEN 'I'                                                    
              PERFORM 8400-INSERT-SPCL-FCTR     THRU 8400-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL WS-803                     
                 MOVE 210                 TO S-APPL-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 8100-SEND-RESULT    THRU 8100-EXIT             
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
              END-IF                                                    
                                                                        
              MOVE SF-FACTOR-ID           TO SK-FACTOR-ID               
                                                                        
              PERFORM 7000-CHECK-SPCL-FCT-CMPNT THRU 7000-EXIT          
                                                                        
              IF ROW-NOT-IN-CSS-FCT-CMPNT                               
                 MOVE '10'                TO SK-CMPNT-ID-CD             
                 MOVE 'A'                 TO SK-STATUS-CD               
                 PERFORM 8410-INSERT-SPCL-FCT-CMPNT                     
                                                THRU 8410-EXIT          
              END-IF                                                    
                                                                        
            WHEN 'T'                                                    
              MOVE PARM-TEMPLATE-FACTOR-ID   TO SF-FACTOR-ID            
              PERFORM 7100-GET-TEMPLATE-FCTR    THRU 7100-EXIT          
                                                                        
              MOVE PARM-PROC-REQ-ID-NUM     TO SF-PROC-REQ-ID           
              MOVE PARM-CODE-STATUS         TO SF-CODE-STATUS           
                                                                        
              IF SF-ADJUST-ELEMENT = 'H' OR 'I' OR 'J' OR 'O'           
                 MOVE 220                 TO S-APPL-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 8100-SEND-RESULT    THRU 8100-EXIT             
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
              END-IF                                                    
                                                                        
              MOVE PARM-FACTOR-ID         TO SF-FACTOR-ID               
              MOVE PARM-FACTOR-TEXT       TO SF-FACTOR-TEXT             
              MOVE PARM-FACTOR-DESC       TO SF-FACTOR-DESC             
                                                                        
              PERFORM 8400-INSERT-SPCL-FCTR     THRU 8400-EXIT          
              IF WS-ACTIVE-RETURN-CODE EQUAL WS-803                     
                 MOVE 235                 TO S-APPL-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 8100-SEND-RESULT    THRU 8100-EXIT             
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
              END-IF                                                    
                                                                        
              MOVE PARM-TEMPLATE-FACTOR-ID   TO SK-FACTOR-ID            
              PERFORM 7000-CHECK-SPCL-FCT-CMPNT                         
                                                THRU 7000-EXIT          
              IF ROW-NOT-IN-CSS-FCT-CMPNT                               
                 MOVE '10'                TO SK-CMPNT-ID-CD             
                 MOVE 'A'                 TO SK-STATUS-CD               
                 PERFORM 8410-INSERT-SPCL-FCT-CMPNT                     
                                                THRU 8410-EXIT          
              ELSE                                                      
                 MOVE PARM-FACTOR-ID         TO SK-FACTOR-ID            
                 PERFORM 8420-COPY-FCTR-CMPT-ID                         
                                                THRU 8420-EXIT          
              END-IF                                                    
           END-EVALUATE.                                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-FORMAT-ROW-VARIABLES                                      *        
      *     FORMAT THE CSS_SPCL_FCTR ROW FROM THE PASSED PARMS.        *        
      *                                                                *        
      *     CALLED BY:  5000-PROCESS-FACTOR-UPDATE                     *        
      ******************************************************************        
       5100-FORMAT-ROW-VARIABLES.                                       
                                                                        
           MOVE PARM-FACTOR-ID           TO SF-FACTOR-ID.               
           MOVE PARM-FACTOR-TEXT         TO SF-FACTOR-TEXT.             
           MOVE PARM-FACTOR-DESC         TO SF-FACTOR-DESC.             
           MOVE PARM-FACTOR-TYPE         TO SF-FACTOR-TYPE.             
           MOVE PARM-CHECK-ELEMENT       TO SF-CHECK-ELEMENT.           
           MOVE PARM-CALC-TYPE-CD        TO SF-CALC-TYPE-CD.            
           MOVE PARM-ADJUST-ELEMENT      TO SF-ADJUST-ELEMENT.          
           MOVE PARM-RATE-ELEC-FCTR      TO SF-RATE-ELEC-FCTR.          
           MOVE PARM-RATE-GAS-FCTR       TO SF-RATE-GAS-FCTR.           
           MOVE PARM-RATE-UNMTRD-FCTR    TO SF-RATE-UNMTRD-FCTR.        
           MOVE PARM-RATE-DEMAND-FCTR    TO SF-RATE-DEMAND-FCTR.        
           MOVE PARM-RATE-ON-PEAK-FCTR   TO SF-RATE-ON-PEAK-FCTR.       
           MOVE PARM-RATE-OFF-PEAK-FCTR  TO SF-RATE-OFF-PEAK-FCTR.      
           MOVE PARM-RATE-SHOULDER-FCTR  TO SF-RATE-SHOULDER-FCTR.      
           MOVE PARM-RATE-SUMMER-FCTR    TO SF-RATE-SUMMER-FCTR.        
           MOVE PARM-RATE-WINTER-FCTR    TO SF-RATE-WINTER-FCTR.        
           MOVE PARM-RATE-USAGE-FCTR     TO SF-RATE-USAGE-FCTR.         
           MOVE PARM-GL-ACCT-NO-NUM      TO SF-GL-ACCT-NO.              
           MOVE PARM-CODE-TAX-STAT-XMT   TO SF-CODE-TAX-STAT-XMT.       
           MOVE PARM-CODE-TAX-CITY-XMT   TO SF-CODE-TAX-CITY-XMT.       
           MOVE PARM-USER-ID-UPD-BY      TO SF-USER-ID-UPD-BY.          
           MOVE PARM-VERS-PRORATE-CD     TO SF-VERS-PRORATE-CD.         
           MOVE PARM-PRORATE-FL          TO SF-PRORATE-FL.              
           MOVE PARM-SPCL-GROUP-CD       TO SF-SPCL-GROUP-CD.           
           MOVE PARM-RATE-TEMPLATE-FL    TO SF-RATE-TEMPLATE-FL.        
           MOVE PARM-FACTOR-HISTORY-CD   TO SF-FACTOR-HISTORY-CD.       
           MOVE PARM-REV-INTERFACE-FL    TO SF-REV-INTERFACE-FL.        
           MOVE PARM-RT-ATTR-INCTV-TYPE  TO SF-RT-ATTR-INCTV-TYPE.      
           MOVE PARM-DURATION-TYPE-CD    TO SF-DURATION-TYPE-CD.        
           MOVE PARM-DURATION-START-CD   TO SF-DURATION-START-CD.       
           MOVE PARM-OVR-RT-VER-PRO-FL   TO SF-OVR-RT-VER-PRO-FL.       
           MOVE PARM-OVR-RT-CALC-TYP-CD  TO SF-OVR-RT-CALC-TYP-CD.      
           MOVE PARM-OVR-RATE-DESC       TO SF-OVR-RATE-DESC.           
           MOVE PARM-BILL-PRT-MSG-PL-CD  TO SF-BILL-PRT-MSG-PL-CD.      
           MOVE PARM-BILL-PRT-LN-ITM-FL  TO SF-BILL-PRT-LN-ITM-FL.      
           MOVE PARM-CODE-DR-CR          TO SF-CODE-DR-CR.              
           IF WS-DEFLT-DURATION-NO = SPACES                             
              SET DFT-DURATION-NO-NULL   TO TRUE                        
           ELSE                                                         
              MOVE WS-DEFLT-DURATION-NO-NUM TO SF-DEFLT-DURATION-NO     
           END-IF.                                                      
           MOVE PARM-SPECIAL-CALC-CD     TO SF-SPECIAL-CALC-CD.         
           MOVE PARM-CODE-STATUS         TO SF-CODE-STATUS.             
           MOVE PARM-POWER-FACTOR-10     TO SF-FCTR-POWER-10.           
           MOVE PARM-PROC-REQ-ID-NUM     TO SF-PROC-REQ-ID.             
           MOVE PARM-BILL-PRT-FCTR-CD    TO SF-BILL-PRT-FCTR-CD.        
           MOVE PARM-BILL-PRT-UNITS-CD   TO SF-BILL-PRT-UNITS-CD.       
           MOVE PARM-BILL-PRT-SEQ-NO     TO SF-BILL-PRT-SEQ-NO.         
           MOVE PARM-FCTR-ELEM-APPL-CD   TO SF-FCTR-ELEM-APPL-CD.       
PRJ680     MOVE PARM-MULTI-VRSN-BA-CD    TO SF-MULTI-VRSN-BA-CD.        
PRJ680     MOVE PARM-FCTR-DECIMAL-PLACE  TO SF-FCTR-DECIMAL-PLACE.      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-CHECK-SPCL-FCT-CMPNT                                     *         
      *     CHECK FOR FACTOR EXISTENCE IN CSS_SPCL_FCT_CMPNT TABLE    *         
      *                                                               *         
      *****************************************************************         
       7000-CHECK-SPCL-FCT-CMPNT.                                       
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
           MOVE 'N'                  TO WS-CSS-FCT-CMPNT-EXISTS.        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-CSS-FCT-CMPNT-EXISTS                          
                 FROM CSS_SPCL_FCT_CMPNT SK WITH(READUNCOMMITTED)               
                WHERE SK.FACTOR_ID = :SK-FACTOR-ID                      
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CSS-FCT-CMPNT-EXISTS                                  
MFA-TR*          FROM CSS_SPCL_FCT_CMPNT SK                                     
MFA-TR*         WHERE SK.FACTOR_ID = :SK-FACTOR-ID                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCT_CMPNT'      TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE SK-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-GET-TEMPLATE-FCTR.                                       *         
      *     SELECT TEMPLATE FACTORS DETAIL                            *         
      *****************************************************************         
       7100-GET-TEMPLATE-FCTR.                                          
                                                                        
           EXEC SQL                                                     
             SELECT SF.FACTOR_ID                                        
                   ,SF.FACTOR_TEXT                                      
                   ,SF.FACTOR_DESC                                      
                   ,SF.FACTOR_TYPE                                      
                   ,SF.CHECK_ELEMENT                                    
                   ,SF.CALC_TYPE_CD                                     
                   ,SF.ADJUST_ELEMENT                                   
                   ,SF.RATE_ELEC_FCTR                                   
                   ,SF.RATE_GAS_FCTR                                    
                   ,SF.RATE_UNMTRD_FCTR                                 
                   ,SF.RATE_DEMAND_FCTR                                 
                   ,SF.RATE_ON_PEAK_FCTR                                
                   ,SF.RATE_OFF_PEAK_FCTR                               
                   ,SF.RATE_SHOULDER_FCTR                               
                   ,SF.RATE_SUMMER_FCTR                                 
                   ,SF.RATE_WINTER_FCTR                                 
                   ,SF.RATE_USAGE_FCTR                                  
                   ,SF.GL_ACCT_NO                                       
                   ,SF.CODE_TAX_STAT_XMT                                
                   ,SF.CODE_TAX_CITY_XMT                                
                   ,SF.VERS_PRORATE_CD                                  
                   ,SF.PRORATE_FL                                       
                   ,SF.SPCL_GROUP_CD                                    
                   ,SF.RATE_TEMPLATE_FL                                 
                   ,SF.FACTOR_HISTORY_CD                                
                   ,SF.REV_INTERFACE_FL                                 
                   ,SF.RT_ATTR_INCTV_TYPE                               
                   ,SF.DURATION_TYPE_CD                                 
                   ,SF.DURATION_START_CD                                
                   ,SF.OVR_RT_VER_PRO_FL                                
                   ,SF.OVR_RT_CALC_TYP_CD                               
                   ,SF.OVR_RATE_DESC                                    
                   ,SF.BILL_PRT_MSG_PL_CD                               
                   ,SF.BILL_PRT_LN_ITM_FL                               
                   ,SF.CODE_DR_CR                                       
                   ,SF.DEFLT_DURATION_NO                                
                   ,SF.SPECIAL_CALC_CD                                  
                   ,SF.CODE_STATUS                                      
                   ,SF.FCTR_POWER_10                                    
                   ,SF.PROC_REQ_ID                                      
                   ,SF.BILL_PRT_FCTR_CD                                 
                   ,SF.BILL_PRT_UNITS_CD                                
                   ,SF.BILL_PRT_SEQ_NO                                  
                   ,SF.FCTR_ELEM_APPL_CD                                
PRJ680             ,SF.MULTI_VRSN_BA_CD                                 
PRJ680             ,SF.FCTR_DECIMAL_PLACE                               
               INTO :SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:SF-FACTOR-DESC                                     
                   ,:SF-FACTOR-TYPE                                     
                   ,:SF-CHECK-ELEMENT                                   
                   ,:SF-CALC-TYPE-CD                                    
                   ,:SF-ADJUST-ELEMENT                                  
                   ,:SF-RATE-ELEC-FCTR                                  
                   ,:SF-RATE-GAS-FCTR                                   
                   ,:SF-RATE-UNMTRD-FCTR                                
                   ,:SF-RATE-DEMAND-FCTR                                
                   ,:SF-RATE-ON-PEAK-FCTR                               
                   ,:SF-RATE-OFF-PEAK-FCTR                              
                   ,:SF-RATE-SHOULDER-FCTR                              
                   ,:SF-RATE-SUMMER-FCTR                                
                   ,:SF-RATE-WINTER-FCTR                                
                   ,:SF-RATE-USAGE-FCTR                                 
                   ,:SF-GL-ACCT-NO                                      
                   ,:SF-CODE-TAX-STAT-XMT                               
                   ,:SF-CODE-TAX-CITY-XMT                               
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:SF-PRORATE-FL                                      
                   ,:SF-SPCL-GROUP-CD                                   
                   ,:SF-RATE-TEMPLATE-FL                                
                   ,:SF-FACTOR-HISTORY-CD                               
                   ,:SF-REV-INTERFACE-FL                                
                   ,:SF-RT-ATTR-INCTV-TYPE                              
                   ,:SF-DURATION-TYPE-CD                                
                   ,:SF-DURATION-START-CD                               
                   ,:SF-OVR-RT-VER-PRO-FL                               
                   ,:SF-OVR-RT-CALC-TYP-CD                              
                   ,:SF-OVR-RATE-DESC                                   
                   ,:SF-BILL-PRT-MSG-PL-CD                              
                   ,:SF-BILL-PRT-LN-ITM-FL                              
                   ,:SF-CODE-DR-CR                                      
                   ,:SF-DEFLT-DURATION-NO :WS-DFT-DURATION-NO-NULL       
                   ,:SF-SPECIAL-CALC-CD                                 
                   ,:SF-CODE-STATUS                                     
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-PROC-REQ-ID                                     
                   ,:SF-BILL-PRT-FCTR-CD                                
                   ,:SF-BILL-PRT-UNITS-CD                               
                   ,:SF-BILL-PRT-SEQ-NO                                 
                   ,:SF-FCTR-ELEM-APPL-CD                               
PRJ680             ,:SF-MULTI-VRSN-BA-CD                                
PRJ680             ,:SF-FCTR-DECIMAL-PLACE                              
               FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                      
              WHERE SF.FACTOR_ID   = :SF-FACTOR-ID                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SF.FACTOR_ID                                                
MFA-TR*            ,SF.FACTOR_TEXT                                              
MFA-TR*            ,SF.FACTOR_DESC                                              
MFA-TR*            ,SF.FACTOR_TYPE                                              
MFA-TR*            ,SF.CHECK_ELEMENT                                            
MFA-TR*            ,SF.CALC_TYPE_CD                                             
MFA-TR*            ,SF.ADJUST_ELEMENT                                           
MFA-TR*            ,SF.RATE_ELEC_FCTR                                           
MFA-TR*            ,SF.RATE_GAS_FCTR                                            
MFA-TR*            ,SF.RATE_UNMTRD_FCTR                                         
MFA-TR*            ,SF.RATE_DEMAND_FCTR                                         
MFA-TR*            ,SF.RATE_ON_PEAK_FCTR                                        
MFA-TR*            ,SF.RATE_OFF_PEAK_FCTR                                       
MFA-TR*            ,SF.RATE_SHOULDER_FCTR                                       
MFA-TR*            ,SF.RATE_SUMMER_FCTR                                         
MFA-TR*            ,SF.RATE_WINTER_FCTR                                         
MFA-TR*            ,SF.RATE_USAGE_FCTR                                          
MFA-TR*            ,SF.GL_ACCT_NO                                               
MFA-TR*            ,SF.CODE_TAX_STAT_XMT                                        
MFA-TR*            ,SF.CODE_TAX_CITY_XMT                                        
MFA-TR*            ,SF.VERS_PRORATE_CD                                          
MFA-TR*            ,SF.PRORATE_FL                                               
MFA-TR*            ,SF.SPCL_GROUP_CD                                            
MFA-TR*            ,SF.RATE_TEMPLATE_FL                                         
MFA-TR*            ,SF.FACTOR_HISTORY_CD                                        
MFA-TR*            ,SF.REV_INTERFACE_FL                                         
MFA-TR*            ,SF.RT_ATTR_INCTV_TYPE                                       
MFA-TR*            ,SF.DURATION_TYPE_CD                                         
MFA-TR*            ,SF.DURATION_START_CD                                        
MFA-TR*            ,SF.OVR_RT_VER_PRO_FL                                        
MFA-TR*            ,SF.OVR_RT_CALC_TYP_CD                                       
MFA-TR*            ,SF.OVR_RATE_DESC                                            
MFA-TR*            ,SF.BILL_PRT_MSG_PL_CD                                       
MFA-TR*            ,SF.BILL_PRT_LN_ITM_FL                                       
MFA-TR*            ,SF.CODE_DR_CR                                               
MFA-TR*            ,SF.DEFLT_DURATION_NO                                        
MFA-TR*            ,SF.SPECIAL_CALC_CD                                          
MFA-TR*            ,SF.CODE_STATUS                                              
MFA-TR*            ,SF.FCTR_POWER_10                                            
MFA-TR*            ,SF.PROC_REQ_ID                                              
MFA-TR*            ,SF.BILL_PRT_FCTR_CD                                         
MFA-TR*            ,SF.BILL_PRT_UNITS_CD                                        
MFA-TR*            ,SF.BILL_PRT_SEQ_NO                                          
MFA-TR*            ,SF.FCTR_ELEM_APPL_CD                                        
MFA-TR*            ,SF.MULTI_VRSN_BA_CD                                         
MFA-TR*            ,SF.FCTR_DECIMAL_PLACE                                       
MFA-TR*        INTO :SF-FACTOR-ID                                               
MFA-TR*            ,:SF-FACTOR-TEXT                                             
MFA-TR*            ,:SF-FACTOR-DESC                                             
MFA-TR*            ,:SF-FACTOR-TYPE                                             
MFA-TR*            ,:SF-CHECK-ELEMENT                                           
MFA-TR*            ,:SF-CALC-TYPE-CD                                            
MFA-TR*            ,:SF-ADJUST-ELEMENT                                          
MFA-TR*            ,:SF-RATE-ELEC-FCTR                                          
MFA-TR*            ,:SF-RATE-GAS-FCTR                                           
MFA-TR*            ,:SF-RATE-UNMTRD-FCTR                                        
MFA-TR*            ,:SF-RATE-DEMAND-FCTR                                        
MFA-TR*            ,:SF-RATE-ON-PEAK-FCTR                                       
MFA-TR*            ,:SF-RATE-OFF-PEAK-FCTR                                      
MFA-TR*            ,:SF-RATE-SHOULDER-FCTR                                      
MFA-TR*            ,:SF-RATE-SUMMER-FCTR                                        
MFA-TR*            ,:SF-RATE-WINTER-FCTR                                        
MFA-TR*            ,:SF-RATE-USAGE-FCTR                                         
MFA-TR*            ,:SF-GL-ACCT-NO                                              
MFA-TR*            ,:SF-CODE-TAX-STAT-XMT                                       
MFA-TR*            ,:SF-CODE-TAX-CITY-XMT                                       
MFA-TR*            ,:SF-VERS-PRORATE-CD                                         
MFA-TR*            ,:SF-PRORATE-FL                                              
MFA-TR*            ,:SF-SPCL-GROUP-CD                                           
MFA-TR*            ,:SF-RATE-TEMPLATE-FL                                        
MFA-TR*            ,:SF-FACTOR-HISTORY-CD                                       
MFA-TR*            ,:SF-REV-INTERFACE-FL                                        
MFA-TR*            ,:SF-RT-ATTR-INCTV-TYPE                                      
MFA-TR*            ,:SF-DURATION-TYPE-CD                                        
MFA-TR*            ,:SF-DURATION-START-CD                                       
MFA-TR*            ,:SF-OVR-RT-VER-PRO-FL                                       
MFA-TR*            ,:SF-OVR-RT-CALC-TYP-CD                                      
MFA-TR*            ,:SF-OVR-RATE-DESC                                           
MFA-TR*            ,:SF-BILL-PRT-MSG-PL-CD                                      
MFA-TR*            ,:SF-BILL-PRT-LN-ITM-FL                                      
MFA-TR*            ,:SF-CODE-DR-CR                                              
MFA-TR*            ,:SF-DEFLT-DURATION-NO:WS-DFT-DURATION-NO-NULL               
MFA-TR*            ,:SF-SPECIAL-CALC-CD                                         
MFA-TR*            ,:SF-CODE-STATUS                                             
MFA-TR*            ,:SF-FCTR-POWER-10                                           
MFA-TR*            ,:SF-PROC-REQ-ID                                             
MFA-TR*            ,:SF-BILL-PRT-FCTR-CD                                        
MFA-TR*            ,:SF-BILL-PRT-UNITS-CD                                       
MFA-TR*            ,:SF-BILL-PRT-SEQ-NO                                         
MFA-TR*            ,:SF-FCTR-ELEM-APPL-CD                                       
MFA-TR*            ,:SF-MULTI-VRSN-BA-CD                                        
MFA-TR*            ,:SF-FCTR-DECIMAL-PLACE                                      
MFA-TR*        FROM CSS_SPCL_FCTR SF                                            
MFA-TR*       WHERE SF.FACTOR_ID   = :SF-FACTOR-ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_SPCL_FCTR'      TO TABLE-1                      
              MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1              
              MOVE SF-FACTOR-ID         TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ473*****************************************************************         
PRJ473* 7200-GET-KEY-VALUES-SF.                                       *         
PRJ473*****************************************************************         
PRJ473 7200-GET-KEY-VALUES-SF.                                          
PRJ473                                                                  
PRJ473     EXEC SQL                                                     
PRJ473       SELECT SF.FACTOR_ID                                        
PRJ473         INTO :SF-FACTOR-ID                                       
PRJ473         FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                      
PRJ473        WHERE SF.PROC_REQ_ID   = :SF-PROC-REQ-ID                  
PRJ473                                                           
PRJ473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SF.FACTOR_ID                                                
MFA-TR*        INTO :SF-FACTOR-ID                                               
MFA-TR*        FROM CSS_SPCL_FCTR SF                                            
MFA-TR*       WHERE SF.PROC_REQ_ID   = :SF-PROC-REQ-ID                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ473                                                                  
PRJ473     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
PRJ473                                                                  
PRJ473     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ473        CONTINUE                                                  
PRJ473     ELSE                                                         
PRJ473        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PRJ473        MOVE '7200'               TO ACTIVE-PARAGRAPH             
PRJ473        MOVE 'SELECT'             TO ABEND-FUNCTION               
PRJ473        MOVE 'CSS_SPCL_FCTR'      TO TABLE-1                      
PRJ473        MOVE 'PROC_REQ_ID'        TO TABLE-ELEMENT-1              
PRJ473        MOVE SF-PROC-REQ-ID       TO HOSTVAR-ELEMENT-1            
PRJ473        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ473        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ473     END-IF.                                                      
PRJ473                                                                  
PRJ473 7200-EXIT.                                                       
PRJ473     EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
             ADD 1 TO CTR-ROWS.                                         
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8200-UPDATE-SPCL-FCTR                                         *         
      *     UPDATE CSS_SPCL_FCTR FACTOR DEFINITION.                   *         
      *                                                               *         
      *     CALLED BY:  5000-PROCESS-FACTOR-UPDATE                    *         
      *****************************************************************         
       8200-UPDATE-SPCL-FCTR.                                           
                                                                        
           MOVE '8200'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SPCL_FCTR                                      
              SET  FACTOR_TEXT          =:SF-FACTOR-TEXT,               
                   FACTOR_DESC          =:SF-FACTOR-DESC,               
                   FACTOR_TYPE          =:SF-FACTOR-TYPE,               
                   CHECK_ELEMENT        =:SF-CHECK-ELEMENT,             
                   CALC_TYPE_CD         =:SF-CALC-TYPE-CD,              
                   ADJUST_ELEMENT       =:SF-ADJUST-ELEMENT,            
                   RATE_ELEC_FCTR       =:SF-RATE-ELEC-FCTR,            
                   RATE_GAS_FCTR        =:SF-RATE-GAS-FCTR,             
                   RATE_UNMTRD_FCTR     =:SF-RATE-UNMTRD-FCTR,          
                   RATE_DEMAND_FCTR     =:SF-RATE-DEMAND-FCTR,          
                   RATE_ON_PEAK_FCTR    =:SF-RATE-ON-PEAK-FCTR,         
                   RATE_OFF_PEAK_FCTR   =:SF-RATE-OFF-PEAK-FCTR,        
                   RATE_SHOULDER_FCTR   =:SF-RATE-SHOULDER-FCTR,        
                   RATE_SUMMER_FCTR     =:SF-RATE-SUMMER-FCTR,          
                   RATE_WINTER_FCTR     =:SF-RATE-WINTER-FCTR,          
                   RATE_USAGE_FCTR      =:SF-RATE-USAGE-FCTR,           
                   GL_ACCT_NO           =:SF-GL-ACCT-NO,                
                   CODE_TAX_STAT_XMT    =:SF-CODE-TAX-STAT-XMT,         
                   CODE_TAX_CITY_XMT    =:SF-CODE-TAX-CITY-XMT,         
                   USER_ID_UPD_BY       =:SF-USER-ID-UPD-BY,            
                   VERS_PRORATE_CD      =:SF-VERS-PRORATE-CD,           
                   PRORATE_FL           =:SF-PRORATE-FL,                
                   SPCL_GROUP_CD        =:SF-SPCL-GROUP-CD,             
                   RATE_TEMPLATE_FL     =:SF-RATE-TEMPLATE-FL,          
                   FACTOR_HISTORY_CD    =:SF-FACTOR-HISTORY-CD,         
                   REV_INTERFACE_FL     =:SF-REV-INTERFACE-FL,          
                   RT_ATTR_INCTV_TYPE   =:SF-RT-ATTR-INCTV-TYPE,        
                   DURATION_TYPE_CD     =:SF-DURATION-TYPE-CD,          
                   DURATION_START_CD    =:SF-DURATION-START-CD,         
                   OVR_RT_VER_PRO_FL    =:SF-OVR-RT-VER-PRO-FL,         
                   OVR_RT_CALC_TYP_CD   =:SF-OVR-RT-CALC-TYP-CD,        
                   OVR_RATE_DESC        =:SF-OVR-RATE-DESC,             
                   BILL_PRT_MSG_PL_CD   =:SF-BILL-PRT-MSG-PL-CD,        
                   BILL_PRT_LN_ITM_FL   =:SF-BILL-PRT-LN-ITM-FL,        
                   CODE_DR_CR           =:SF-CODE-DR-CR,                
                   DEFLT_DURATION_NO    =:SF-DEFLT-DURATION-NO 
                                         :WS-DFT-DURATION-NO-NULL,      
                   SPECIAL_CALC_CD      =:SF-SPECIAL-CALC-CD,           
                   CODE_STATUS          =:SF-CODE-STATUS,               
                   FCTR_POWER_10        =:SF-FCTR-POWER-10,             
                   BILL_PRT_FCTR_CD     =:SF-BILL-PRT-FCTR-CD,          
                   BILL_PRT_UNITS_CD    =:SF-BILL-PRT-UNITS-CD,         
                   BILL_PRT_SEQ_NO      =:SF-BILL-PRT-SEQ-NO,           
                   FCTR_ELEM_APPL_CD    =:SF-FCTR-ELEM-APPL-CD,         
PRJ680             MULTI_VRSN_BA_CD     =:SF-MULTI-VRSN-BA-CD,          
PRJ680             FCTR_DECIMAL_PLACE   =:SF-FCTR-DECIMAL-PLACE         
              WHERE FACTOR_ID           =:SF-FACTOR-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE 'USER_ID_UPD_BY'          TO TABLE-ELEMENT-2         
              MOVE 'CALC_TYPE_CD'            TO TABLE-ELEMENT-3         
              MOVE SF-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              MOVE SF-USER-ID-UPD-BY         TO HOSTVAR-ELEMENT-2       
              MOVE SF-CALC-TYPE-CD           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8300-DELETE-SPCL-FCTR                                         *         
      *     DELETE CSS_SPCL_FCTR FACTOR DEFINITION.                   *         
      *                                                               *         
      *     CALLED BY:  5000-PROCESS-FACTOR-UPDATE                    *         
      *****************************************************************         
       8300-DELETE-SPCL-FCTR.                                           
                                                                        
           MOVE '8300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SPCL_FCTR                                 
              WHERE  FACTOR_ID  = :SF-FACTOR-ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-532         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8400-INSERT-SPCL-FCTR                                         *         
      *     INSERT NEW CSS_SPCL_FCTR FACTOR DEFINITION.               *         
      *                                                               *         
      *     CALLED BY:  5000-PROCESS-FACTOR-UPDATE                    *         
      *****************************************************************         
       8400-INSERT-SPCL-FCTR.                                           
                                                                        
           MOVE '8400'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SPCL_FCTR                                 
                    (FACTOR_ID,                                         
                     FACTOR_TEXT,                                       
                     FACTOR_DESC,                                       
                     FACTOR_TYPE,                                       
                     CHECK_ELEMENT,                                     
                     CALC_TYPE_CD,                                      
                     ADJUST_ELEMENT,                                    
                     RATE_ELEC_FCTR,                                    
                     RATE_GAS_FCTR,                                     
                     RATE_UNMTRD_FCTR,                                  
                     RATE_DEMAND_FCTR,                                  
                     RATE_ON_PEAK_FCTR,                                 
                     RATE_OFF_PEAK_FCTR,                                
                     RATE_SHOULDER_FCTR,                                
                     RATE_SUMMER_FCTR,                                  
                     RATE_WINTER_FCTR,                                  
                     RATE_USAGE_FCTR,                                   
                     GL_ACCT_NO,                                        
                     CODE_TAX_STAT_XMT,                                 
                     CODE_TAX_CITY_XMT,                                 
                     CODE_STATUS,                                       
                     USER_ID_UPD_BY,                                    
                     VERS_PRORATE_CD,                                   
                     PRORATE_FL,                                        
                     SPCL_GROUP_CD,                                     
                     RATE_TEMPLATE_FL,                                  
                     FACTOR_HISTORY_CD,                                 
                     REV_INTERFACE_FL,                                  
                     RT_ATTR_INCTV_TYPE,                                
                     DURATION_TYPE_CD,                                  
                     DURATION_START_CD,                                 
                     OVR_RT_VER_PRO_FL,                                 
                     OVR_RT_CALC_TYP_CD,                                
                     OVR_RATE_DESC,                                     
                     BILL_PRT_MSG_PL_CD,                                
                     BILL_PRT_LN_ITM_FL,                                
                     CODE_DR_CR,                                        
                     DEFLT_DURATION_NO,                                 
                     SPECIAL_CALC_CD,                                   
                     FCTR_POWER_10,                                     
                     PROC_REQ_ID,                                       
                     BILL_PRT_FCTR_CD,                                  
                     BILL_PRT_UNITS_CD,                                 
                     BILL_PRT_SEQ_NO,                                   
                     FCTR_ELEM_APPL_CD,                                 
PRJ680               MULTI_VRSN_BA_CD,                                  
PRJ680               FCTR_DECIMAL_PLACE                                 
                     )                                                  
              VALUES                                                    
                    (:SF-FACTOR-ID,                                     
                     :SF-FACTOR-TEXT,                                   
                     :SF-FACTOR-DESC,                                   
                     :SF-FACTOR-TYPE,                                   
                     :SF-CHECK-ELEMENT,                                 
                     :SF-CALC-TYPE-CD,                                  
                     :SF-ADJUST-ELEMENT,                                
                     :SF-RATE-ELEC-FCTR,                                
                     :SF-RATE-GAS-FCTR,                                 
                     :SF-RATE-UNMTRD-FCTR,                              
                     :SF-RATE-DEMAND-FCTR,                              
                     :SF-RATE-ON-PEAK-FCTR,                             
                     :SF-RATE-OFF-PEAK-FCTR,                            
                     :SF-RATE-SHOULDER-FCTR,                            
                     :SF-RATE-SUMMER-FCTR,                              
                     :SF-RATE-WINTER-FCTR,                              
                     :SF-RATE-USAGE-FCTR,                               
                     :SF-GL-ACCT-NO,                                    
                     :SF-CODE-TAX-STAT-XMT,                             
                     :SF-CODE-TAX-CITY-XMT,                             
                     :SF-CODE-STATUS,                                   
                     :SF-USER-ID-UPD-BY,                                
                     :SF-VERS-PRORATE-CD,                               
                     :SF-PRORATE-FL,                                    
                     :SF-SPCL-GROUP-CD,                                 
                     :SF-RATE-TEMPLATE-FL,                              
                     :SF-FACTOR-HISTORY-CD,                             
                     :SF-REV-INTERFACE-FL,                              
                     :SF-RT-ATTR-INCTV-TYPE,                            
                     :SF-DURATION-TYPE-CD,                              
                     :SF-DURATION-START-CD,                             
                     :SF-OVR-RT-VER-PRO-FL,                             
                     :SF-OVR-RT-CALC-TYP-CD,                            
                     :SF-OVR-RATE-DESC,                                 
                     :SF-BILL-PRT-MSG-PL-CD,                            
                     :SF-BILL-PRT-LN-ITM-FL,                            
                     :SF-CODE-DR-CR,                                    
                     :SF-DEFLT-DURATION-NO :WS-DFT-DURATION-NO-NULL,     
                     :SF-SPECIAL-CALC-CD,                               
                     :SF-FCTR-POWER-10,                                 
                     :SF-PROC-REQ-ID,                                   
                     :SF-BILL-PRT-FCTR-CD,                              
                     :SF-BILL-PRT-UNITS-CD,                             
                     :SF-BILL-PRT-SEQ-NO,                               
                     :SF-FCTR-ELEM-APPL-CD,                             
PRJ680               :SF-MULTI-VRSN-BA-CD,                              
PRJ680               :SF-FCTR-DECIMAL-PLACE                             
                    )                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-803         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE 'FACTOR_TYPE'              TO TABLE-ELEMENT-2        
              MOVE 'FACTOR_TEXT'              TO TABLE-ELEMENT-3        
              MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              MOVE SF-FACTOR-TYPE             TO HOSTVAR-ELEMENT-2      
              MOVE SF-FACTOR-TEXT             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 8410-INSERT-SPCL-FCT-CMPNT                                    *         
      *     INSERT NEW CSS_SPCL_FCT_CMPNT ROW                         *         
      *                                                               *         
      *****************************************************************         
       8410-INSERT-SPCL-FCT-CMPNT.                                      
                                                                        
           MOVE '8410'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SPCL_FCT_CMPNT                            
                    (CMPNT_ID_CD                                        
                    ,FACTOR_ID                                          
                    ,STATUS_CD                                          
                    ,STATUS_CHANGE_DT                                   
                     )                                                  
              VALUES                                                    
                    (:SK-CMPNT-ID-CD                                    
                    ,:SK-FACTOR-ID                                      
                    ,:SK-STATUS-CD                                      
                    , CAST(SYSDATETIMEOFFSET() AS DATE)                         
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SPCL_FCT_CMPNT                                    
MFA-TR*             (CMPNT_ID_CD                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,STATUS_CHANGE_DT                                           
MFA-TR*              )                                                          
MFA-TR*       VALUES                                                            
MFA-TR*             (:SK-CMPNT-ID-CD                                            
MFA-TR*             ,:SK-FACTOR-ID                                              
MFA-TR*             ,:SK-STATUS-CD                                              
MFA-TR*             , CURRENT DATE                                              
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCT_CMPNT'       TO TABLE-1                
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-1        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-2        
              MOVE 'STATUS_CD'                TO TABLE-ELEMENT-3        
              MOVE SK-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-1      
              MOVE SK-FACTOR-ID               TO HOSTVAR-ELEMENT-2      
              MOVE SK-STATUS-CD               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8420-COPY-FCTR-CMPT-ID.                                       *         
      *****************************************************************         
       8420-COPY-FCTR-CMPT-ID.                                          
                                                                        
           MOVE '8420'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SPCL_FCT_CMPNT                            
                    (CMPNT_ID_CD                                        
                    ,FACTOR_ID                                          
                    ,STATUS_CD                                          
                    ,STATUS_CHANGE_DT                                   
                     )                                                  
               SELECT CMPNT_ID_CD                                       
                     ,:SK-FACTOR-ID                                     
                     ,'A'                                               
                     ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
                 FROM CSS_SPCL_FCT_CMPNT                                
                WHERE FACTOR_ID = :PARM-TEMPLATE-FACTOR-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_SPCL_FCT_CMPNT                                    
MFA-TR*             (CMPNT_ID_CD                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,STATUS_CHANGE_DT                                           
MFA-TR*              )                                                          
MFA-TR*        SELECT CMPNT_ID_CD                                               
MFA-TR*              ,:SK-FACTOR-ID                                             
MFA-TR*              ,'A'                                                       
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*          FROM CSS_SPCL_FCT_CMPNT                                        
MFA-TR*         WHERE FACTOR_ID = :PARM-TEMPLATE-FACTOR-ID                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCT_CMPNT'       TO TABLE-1                
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-1        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-2        
              MOVE 'TEMPLATE FCTR'            TO TABLE-ELEMENT-3        
              MOVE SK-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-1      
              MOVE SK-FACTOR-ID               TO HOSTVAR-ELEMENT-2      
              MOVE PARM-TEMPLATE-FACTOR-ID    TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
