       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04520.                                         
COB303 DATE-WRITTEN.                                                    
COB303            OCTOBER 19, 2011.                                     
       DATE-COMPILED.                                                   
                                                                        
      ***************************** ************************************00000100
      *     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
      *         CSR04520 CLONED FROM SP CSR02286 ON 10/19/2011         *00000300
      *             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
      *                                                                *00000500
      ******************************************************************00000600
      ******************************************************************00070000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES SPECIAL FACTOR DEFINITION INFORMATION  *00240000
      *  FROM CSS_SPCL_FCTR TABLE.                                     *00250000
      *                                                                *00264000
      *    # APPL-RETURN-CODE:                                         *        
      *                                                                *00264000
      *      +1000 - FACTOR ID/PROC REQ ID IS INVALID                  *        
      *                                                                *        
      ******************************************************************00180000
      *    PARAMETERS                                                  *        
      *        IN                                                      *        
      *                APPL_PROG_ID    CHAR(03)                        *        
      *                USER_ID         CHAR(07)                        *        
      *                FACTOR_ID       CHAR(09)                        *        
      *                PROC_REQ_ID     CHAR(10)                        *        
      *        OUT                                                     *        
      *                REFER RESULT SET                                *        
      *    RESULT SET                                                  *        
      *                RETURN_CODE           INTEGER                   *        
      *                APPL_RETURN_CODE      INTEGER                   *        
      *                FACTOR_ID             CHAR(09)                  *04092100
      *                FACTOR_TEXT           CHAR(20)                  *04092200
      *                FACTOR_DESC           CHAR(60)                  *04092300
      *                FACTOR_TYPE           CHAR(01)                  *04092400
      *                CHECK_ELEMENT         CHAR(01)                  *04092500
      *                CALC_TYPE_CD          CHAR(01)                  *04092600
      *                ADJUST_ELEMENT        CHAR(01)                  *04092700
      *                RATE_ELEC_FCTR        CHAR(01)                  *04092800
      *                RATE_GAS_FCTR         CHAR(01)                  *04092900
      *                RATE_UNMTRD_FCTR      CHAR(01)                  *04093000
      *                RATE_DEMAND_FCTR      CHAR(01)                  *04093700
      *                RATE_ON_PEAK_FCTR     CHAR(01)                  *04094000
      *                RATE_OFF_PEAK_FCTR    CHAR(01)                  *04094100
      *                RATE_SHOULDER_FCTR    CHAR(01)                  *04094200
      *                RATE_SUMMER_FCTR      CHAR(01)                  *04094300
      *                RATE_WINTER_FCTR      CHAR(01)                  *04094400
      *                RATE_USAGE_FCTR       CHAR(01)                  *04094500
      *                GL_ACCT_NO            DECIMAL(3,4)              *04094700
      *                CODE_TAX_STAT_XMT     CHAR(01)                  *04095200
      *                CODE_TAX_CITY_XMT     CHAR(01)                  *04095300
      *                CODE_TAX_OTHR_XMT     CHAR(01)                  *04095401
      *                VERS_PRORATE_CD       CHAR(01)                  *04095602
      *                PRORATE_FL            CHAR(01)                  *04095602
      *                SPCL_GROUP_CD         CHAR(02)                  *04095602
      *                RATE_TEMPLATE_FL      CHAR(01)                  *        
      *                FACTOR_HISTORY_CD     CHAR(01)                  *        
      *                REV_INTERFACE_FL      CHAR(01)                  *        
      *                RT_ATTR_INCTV_TYPE    CHAR(15)                  *        
      *                DURATION_TYPE_CD      CHAR(01)                  *        
      *                DURATION_START_CD     CHAR(01)                  *        
      *                OVR_RT_VER_PRO_FL     CHAR(01)                  *        
      *                OVR_RT_CALC_TYP_CD    CHAR(01)                  *        
      *                OVR_RATE_DESC         CHAR(50)                  *        
      *                BILL_PRT_MSG_PL_CD    CHAR(03)                  *        
      *                BILL_PRT_LN_ITM_FL    CHAR(01)                  *        
      *                CODE_DR_CR            CHAR(01)                  *        
      *                DEFLT_DURATION_NO     CHAR(04)                  *        
      *                SPECIAL_CALC_CD       CHAR(02)                  *        
      *                CODE_STATUS           CHAR(01)                  *        
      *                FCTR_POWER_10         SMALLINT                  *        
      *                PROC_REQ_ID           DECIMAL(10,0)             *        
      *                BILL_PRT_FCTR_CD      CHAR(01)                  *        
      *                BILL_PRT_UNITS_CD     CHAR(01)                  *        
      *                BILL_PRT_SEQ_NO       SMALLINT                  *        
      *                FCTR_ELEM_APPL_CD     CHAR(01)                  *        
      *                LAST_UPDATE_TS        CHAR(26)                  *        
PRJ680*                MULTI_VRSN_BA_CD      CHAR(01)                  *        
PRJ680*                FCTR_DECIMAL_PLACE    SMALLINT                  *        
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      * 10/19/11   NS75440    CREATED.                                 *00330000
      * 04/16/12   HA7A338    ADDED LOGIC TO GET SPECIAL FACTOR DETAILS*00330000
      *                       WHEN PROC REQ ID IS PASSED ELSE CONTINUE *00330000
      *                       NORMAL RETRIEVE PROCESS USING FACTOR ID  *00330000
      *                       REMOVED RS- VARIABLES & LINK- VARIABLES  *00340000
PRJ680* 02/19/13   MS93554    RETRIEVE MULTI_VRSN_BA_CD & FCTR_DECIMAL *00340000
      *                       _PRICE FROM CSS_SPCL_FCTR TABLE.         *00340000
ACT004* 06/03/16   TP7R341    REMOVE UNWANTED COLUMNS FROM THE TABLE   *00340000
ACT004*  A04177               CSS_SPCL_FCTR                            *00340000
      ******************************************************************00350000
      ******************************************************************00360000
      *                                                                *00370000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00380000
      *                                                                *00390000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00400000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00410000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00430000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00440000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00450000
      *  7000 - 7999  INPUT MODULES                                    *00460000
      *  8000 - 8999  OUTPUT MODULES                                   *00470000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00480000
      *                                                                *00490000
      ******************************************************************00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04520'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                               PIC X(40) VALUE       
           'WORKING STORAGE FOR CSR04520 STARTS HERE'.                  
                                                                        
      ******************************************************************00600000
      *    DB2 INCLUDES                                                *00610000
      ******************************************************************00620000
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE SQLCA                                             00650000
           END-EXEC.                                                    00660000
                                                                        
           EXEC SQL                                                     00751000
              INCLUDE TBSPLFTR                                          00752000
           END-EXEC.                                                    00753000
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *  COMMON SYSTEM AREA                                            *        
      ******************************************************************        
      ******************************************************************        
      *  ERROR HANDLING                                              *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      ******************************************************************        
      *  ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                *        
      ******************************************************************        
           COPY CWS00027.                                                       
      ******************************************************************        
      *  SUPPORTS DB2 AND SQL ERROR CHECKING                           *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  WS-PARM-FIELDS.                                              
           05  WS-APPL-PGM-ID          PIC X(03) VALUE SPACES.          
           05  WS-USER-ID              PIC X(07) VALUE SPACES.          
           05  WS-FACTOR-ID            PIC X(09) VALUE SPACES.          
           05  WS-PROC-REQ-ID          PIC S9(10)V     COMP-3 VALUE +0. 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(09) COMP.                 
                                                                        
       01 NULL-INDICATORS.                                              
           05  IND-DEFLT-DURATION-NO   PIC S9(04) COMP.                 
                                                                        
       01  WS-MISC-VALUES.                                              
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04520'.     
           05  NOT-FOUND-CALL          PIC S9(03) VALUE +100.           
           05  S-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.         
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-YES-NULL             PIC S9(04) VALUE -1.             
           05  WS-DFT-DURATION-NO-TMP1 PIC 9(04).                       
           05  WS-DFT-DURATION-NO-TMP2 PIC ZZZ9.                        
           05  WS-SRCH-FLTR            PIC X(01)  VALUE 'N'.            
                                                                        
       01  FILLER  PIC X(32)  VALUE 'THIS IS THE ROW RETURN AREA.    '. 
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-FACTOR-ID             PIC X(09)  VALUE SPACES.         
           05  S-FACTOR-TEXT           PIC X(20)  VALUE SPACES.         
           05  S-FACTOR-DESC           PIC X(60)  VALUE SPACES.         
           05  S-FACTOR-TYPE           PIC X(01)  VALUE SPACES.         
           05  S-CHECK-ELEMENT         PIC X(01)  VALUE SPACES.         
           05  S-CALC-TYPE-CD          PIC X(01)  VALUE SPACES.         
           05  S-ADJUST-ELEMENT        PIC X(01)  VALUE SPACES.         
           05  S-RATE-ELEC-FCTR        PIC X(01)  VALUE SPACES.         
           05  S-RATE-GAS-FCTR         PIC X(01)  VALUE SPACES.         
           05  S-RATE-UNMTRD-FCTR      PIC X(01)  VALUE SPACES.         
           05  S-RATE-DEMAND-FCTR      PIC X(01)  VALUE SPACES.         
           05  S-RATE-ON-PEAK-FCTR     PIC X(01)  VALUE SPACES.         
           05  S-RATE-OFF-PEAK-FCTR    PIC X(01)  VALUE SPACES.         
           05  S-RATE-SHOULDER-FCTR    PIC X(01)  VALUE SPACES.         
           05  S-RATE-SUMMER-FCTR      PIC X(01)  VALUE SPACES.         
           05  S-RATE-WINTER-FCTR      PIC X(01)  VALUE SPACES.         
           05  S-RATE-USAGE-FCTR       PIC X(01)  VALUE SPACES.         
           05  S-GL-ACCT-NO            PIC S9(3)V9(4)  COMP-3 VALUE 0.  
           05  S-CODE-TAX-STAT-XMT     PIC X(01)  VALUE SPACES.         
           05  S-CODE-TAX-CITY-XMT     PIC X(01)  VALUE SPACES.         
           05  S-VERS-PRORATE-CD       PIC X(01)  VALUE SPACES.         
           05  S-PRORATE-FL            PIC X(01)  VALUE SPACES.         
           05  S-SPCL-GROUP-CD         PIC X(02)  VALUE SPACES.         
           05  S-RATE-TEMPLATE-FL      PIC X(01)  VALUE SPACES.         
           05  S-FACTOR-HISTORY-CD     PIC X(01)  VALUE SPACES.         
           05  S-REV-INTERFACE-FL      PIC X(01)  VALUE SPACES.         
           05  S-RT-ATTR-INCTV-TYPE    PIC X(15)  VALUE SPACES.         
           05  S-DURATION-TYPE-CD      PIC X(01)  VALUE SPACES.         
           05  S-DURATION-START-CD     PIC X(01)  VALUE SPACES.         
           05  S-OVR-RT-VER-PRO-FL     PIC X(01)  VALUE SPACES.         
           05  S-OVR-RT-CALC-TYP-CD    PIC X(02)  VALUE SPACES.         
           05  S-OVR-RATE-DESC         PIC X(50)  VALUE SPACES.         
           05  S-BILL-PRT-MSG-PL-CD    PIC X(03)  VALUE SPACES.         
           05  S-BILL-PRT-LN-ITM-FL    PIC X(01)  VALUE SPACES.         
           05  S-CODE-DR-CR            PIC X(01)  VALUE SPACES.         
           05  S-DEFLT-DURATION-NO     PIC X(04)  VALUE SPACES.         
           05  S-SPECIAL-CALC-CD       PIC X(02)  VALUE SPACES.         
           05  S-CODE-STATUS           PIC X(01)  VALUE SPACES.         
           05  S-FCTR-POWER-10         PIC S9(04) COMP  VALUE 0.        
           05  S-PROC-REQ-ID           PIC S9(10)V     COMP-3 VALUE 0.  
           05  S-BILL-PRT-FCTR-CD      PIC X(01)  VALUE SPACES.         
           05  S-BILL-PRT-UNITS-CD     PIC X(01)  VALUE SPACES.         
           05  S-BILL-PRT-SEQ-NO       PIC S9(04) COMP  VALUE 0.        
           05  S-FCTR-ELEM-APPL-CD     PIC X(01)  VALUE SPACES.         
           05  S-LAST-UPDATE-TS        PIC X(26)  VALUE SPACES.         
PRJ680     05  S-MULTI-VRSN-BA-CD      PIC X(01)  VALUE SPACES.         
PRJ680     05  S-FCTR-DECIMAL-PLACE    PIC S9(04) COMP  VALUE 0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01)  VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW            PIC X(01)  VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID         PIC X(03).                          
       01  PARM-USER-ID             PIC X(07).                          
       01  PARM-FACTOR-ID           PIC X(09).                          
       01  PARM-PROC-REQ-ID         PIC X(10).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-APPL-PGM-ID                                        
                PARM-USER-ID                                            
                PARM-FACTOR-ID                                          
                PARM-PROC-REQ-ID                                        
               .                                                        
                                                                        
      ******************************************************************01640000
      * 0000-MAINLINE                                                  *01650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01660000
      ******************************************************************01670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01790000
      * 0100-INITIALIZE                                                *01800000
      *                                                                *01810000
      *     1. RESET DB2 ERROR HANDLERS                                *01820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01850000
      *                                                                *01860000
      ******************************************************************01870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE                AS  RETURN_CODE          
                ,:S-APPL-RETURN-CODE           AS  APPL_RETURN_CODE     
                , LTRIM(RTRIM(:S-FACTOR-ID))          AS  FACTOR_ID            
                , LTRIM(RTRIM(:S-FACTOR-TEXT))        AS  FACTOR_TEXT          
                , LTRIM(RTRIM(:S-FACTOR-DESC))        AS  FACTOR_DESC          
                , LTRIM(RTRIM(:S-FACTOR-TYPE))        AS  FACTOR_TYPE          
                , LTRIM(RTRIM(:S-CHECK-ELEMENT))      AS  CHECK_ELEMENT        
                , LTRIM(RTRIM(:S-CALC-TYPE-CD))       AS  CALC_TYPE_CD         
                , LTRIM(RTRIM(:S-ADJUST-ELEMENT))     AS  ADJUST_ELEMENT       
                , LTRIM(RTRIM(:S-RATE-ELEC-FCTR))     AS  RATE_ELEC_FCTR       
                , LTRIM(RTRIM(:S-RATE-GAS-FCTR))      AS  RATE_GAS_FCTR        
                , LTRIM(RTRIM(:S-RATE-UNMTRD-FCTR))   AS  
           RATE_UNMTRD_FCTR     
                , LTRIM(RTRIM(:S-RATE-DEMAND-FCTR))   AS  
           RATE_DEMAND_FCTR     
                , LTRIM(RTRIM(:S-RATE-ON-PEAK-FCTR))  AS  
           RATE_ON_PEAK_FCTR    
                , LTRIM(RTRIM(:S-RATE-OFF-PEAK-FCTR)) AS  
           RATE_OFF_PEAK_FCTR   
                , LTRIM(RTRIM(:S-RATE-SHOULDER-FCTR)) AS  
           RATE_SHOULDER_FCTR   
                , LTRIM(RTRIM(:S-RATE-SUMMER-FCTR))   AS  
           RATE_SUMMER_FCTR     
                , LTRIM(RTRIM(:S-RATE-WINTER-FCTR))   AS  
           RATE_WINTER_FCTR     
                , LTRIM(RTRIM(:S-RATE-USAGE-FCTR))    AS  
           RATE_USAGE_FCTR      
                ,:S-GL-ACCT-NO                 AS  GL_ACCT_NO           
                , LTRIM(RTRIM(:S-CODE-TAX-STAT-XMT))  AS  
           CODE_TAX_STAT_XMT    
                , LTRIM(RTRIM(:S-CODE-TAX-CITY-XMT))  AS  
           CODE_TAX_CITY_XMT    
                , LTRIM(RTRIM(:S-VERS-PRORATE-CD))    AS  
           VERS_PRORATE_CD      
                , LTRIM(RTRIM(:S-PRORATE-FL))         AS  PRORATE_FL           
                , LTRIM(RTRIM(:S-SPCL-GROUP-CD))      AS  SPCL_GROUP_CD        
                , LTRIM(RTRIM(:S-RATE-TEMPLATE-FL))   AS  
           RATE_TEMPLATE_FL     
                , LTRIM(RTRIM(:S-FACTOR-HISTORY-CD))  AS  
           FACTOR_HISTORY_CD    
                , LTRIM(RTRIM(:S-REV-INTERFACE-FL))   AS  
           REV_INTERFACE_FL     
                , LTRIM(RTRIM(:S-RT-ATTR-INCTV-TYPE)) AS  
           RT_ATTR_INCTV_TYPE   
                ,:S-DURATION-TYPE-CD           AS  DURATION_TYPE_CD     
                ,:S-DURATION-START-CD          AS  DURATION_START_CD    
                , LTRIM(RTRIM(:S-OVR-RT-VER-PRO-FL))  AS  
           OVR_RT_VER_PRO_FL    
                ,:S-OVR-RT-CALC-TYP-CD         AS  OVR_RT_CALC_TYP_CD   
                , LTRIM(RTRIM(:S-OVR-RATE-DESC))      AS  OVR_RATE_DESC        
                , LTRIM(RTRIM(:S-BILL-PRT-MSG-PL-CD)) AS  
           BILL_PRT_MSG_PL_CD   
                , LTRIM(RTRIM(:S-BILL-PRT-LN-ITM-FL)) AS  
           BILL_PRT_LN_ITM_FL   
                , LTRIM(RTRIM(:S-CODE-DR-CR))         AS  CODE_DR_CR           
                , LTRIM(RTRIM(:S-DEFLT-DURATION-NO))  AS  
           DEFLT_DURATION_NO    
                , LTRIM(RTRIM(:S-SPECIAL-CALC-CD))    AS  SPCL_CALC_CD         
                , LTRIM(RTRIM(:S-CODE-STATUS))        AS  CODE_STATUS          
                ,:S-FCTR-POWER-10              AS  FCTR_POWER_10        
                ,:S-PROC-REQ-ID                AS  PROC_REQ_ID          
                , LTRIM(RTRIM(:S-BILL-PRT-FCTR-CD))   AS  
           BILL_PRT_FCTR_CD     
                , LTRIM(RTRIM(:S-BILL-PRT-UNITS-CD))  AS  
           BILL_PRT_UNITS_CD    
                ,:S-BILL-PRT-SEQ-NO            AS  BILL_PRT_SEQ_NO      
                , LTRIM(RTRIM(:S-FCTR-ELEM-APPL-CD))  AS  
           FCTR_ELEM_APPL_CD    
                , LTRIM(RTRIM(:S-LAST-UPDATE-TS))     AS  LAST_UPDATE_TS       
PRJ680          , LTRIM(RTRIM(:S-MULTI-VRSN-BA-CD))   AS  
           MULTI_VRSN_BA_CD     
PRJ680          ,:S-FCTR-DECIMAL-PLACE         AS  FCTR_DECIMAL_PLACE   
              FROM                                                      
                 CIS.SYSDUMMY1                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE                AS  RETURN_CODE                  
MFA-TR*         ,:S-APPL-RETURN-CODE           AS  APPL_RETURN_CODE             
MFA-TR*         , STRIP(:S-FACTOR-ID)          AS  FACTOR_ID                    
MFA-TR*         , STRIP(:S-FACTOR-TEXT)        AS  FACTOR_TEXT                  
MFA-TR*         , STRIP(:S-FACTOR-DESC)        AS  FACTOR_DESC                  
MFA-TR*         , STRIP(:S-FACTOR-TYPE)        AS  FACTOR_TYPE                  
MFA-TR*         , STRIP(:S-CHECK-ELEMENT)      AS  CHECK_ELEMENT                
MFA-TR*         , STRIP(:S-CALC-TYPE-CD)       AS  CALC_TYPE_CD                 
MFA-TR*         , STRIP(:S-ADJUST-ELEMENT)     AS  ADJUST_ELEMENT               
MFA-TR*         , STRIP(:S-RATE-ELEC-FCTR)     AS  RATE_ELEC_FCTR               
MFA-TR*         , STRIP(:S-RATE-GAS-FCTR)      AS  RATE_GAS_FCTR                
MFA-TR*         , STRIP(:S-RATE-UNMTRD-FCTR)   AS  RATE_UNMTRD_FCTR             
MFA-TR*         , STRIP(:S-RATE-DEMAND-FCTR)   AS  RATE_DEMAND_FCTR             
MFA-TR*         , STRIP(:S-RATE-ON-PEAK-FCTR)  AS  RATE_ON_PEAK_FCTR            
MFA-TR*         , STRIP(:S-RATE-OFF-PEAK-FCTR) AS  RATE_OFF_PEAK_FCTR           
MFA-TR*         , STRIP(:S-RATE-SHOULDER-FCTR) AS  RATE_SHOULDER_FCTR           
MFA-TR*         , STRIP(:S-RATE-SUMMER-FCTR)   AS  RATE_SUMMER_FCTR             
MFA-TR*         , STRIP(:S-RATE-WINTER-FCTR)   AS  RATE_WINTER_FCTR             
MFA-TR*         , STRIP(:S-RATE-USAGE-FCTR)    AS  RATE_USAGE_FCTR              
MFA-TR*         ,:S-GL-ACCT-NO                 AS  GL_ACCT_NO                   
MFA-TR*         , STRIP(:S-CODE-TAX-STAT-XMT)  AS  CODE_TAX_STAT_XMT            
MFA-TR*         , STRIP(:S-CODE-TAX-CITY-XMT)  AS  CODE_TAX_CITY_XMT            
MFA-TR*         , STRIP(:S-VERS-PRORATE-CD)    AS  VERS_PRORATE_CD              
MFA-TR*         , STRIP(:S-PRORATE-FL)         AS  PRORATE_FL                   
MFA-TR*         , STRIP(:S-SPCL-GROUP-CD)      AS  SPCL_GROUP_CD                
MFA-TR*         , STRIP(:S-RATE-TEMPLATE-FL)   AS  RATE_TEMPLATE_FL             
MFA-TR*         , STRIP(:S-FACTOR-HISTORY-CD)  AS  FACTOR_HISTORY_CD            
MFA-TR*         , STRIP(:S-REV-INTERFACE-FL)   AS  REV_INTERFACE_FL             
MFA-TR*         , STRIP(:S-RT-ATTR-INCTV-TYPE) AS  RT_ATTR_INCTV_TYPE           
MFA-TR*         ,:S-DURATION-TYPE-CD           AS  DURATION_TYPE_CD             
MFA-TR*         ,:S-DURATION-START-CD          AS  DURATION_START_CD            
MFA-TR*         , STRIP(:S-OVR-RT-VER-PRO-FL)  AS  OVR_RT_VER_PRO_FL            
MFA-TR*         ,:S-OVR-RT-CALC-TYP-CD         AS  OVR_RT_CALC_TYP_CD           
MFA-TR*         , STRIP(:S-OVR-RATE-DESC)      AS  OVR_RATE_DESC                
MFA-TR*         , STRIP(:S-BILL-PRT-MSG-PL-CD) AS  BILL_PRT_MSG_PL_CD           
MFA-TR*         , STRIP(:S-BILL-PRT-LN-ITM-FL) AS  BILL_PRT_LN_ITM_FL           
MFA-TR*         , STRIP(:S-CODE-DR-CR)         AS  CODE_DR_CR                   
MFA-TR*         , STRIP(:S-DEFLT-DURATION-NO)  AS  DEFLT_DURATION_NO            
MFA-TR*         , STRIP(:S-SPECIAL-CALC-CD)    AS  SPCL_CALC_CD                 
MFA-TR*         , STRIP(:S-CODE-STATUS)        AS  CODE_STATUS                  
MFA-TR*         ,:S-FCTR-POWER-10              AS  FCTR_POWER_10                
MFA-TR*         ,:S-PROC-REQ-ID                AS  PROC_REQ_ID                  
MFA-TR*         , STRIP(:S-BILL-PRT-FCTR-CD)   AS  BILL_PRT_FCTR_CD             
MFA-TR*         , STRIP(:S-BILL-PRT-UNITS-CD)  AS  BILL_PRT_UNITS_CD            
MFA-TR*         ,:S-BILL-PRT-SEQ-NO            AS  BILL_PRT_SEQ_NO              
MFA-TR*         , STRIP(:S-FCTR-ELEM-APPL-CD)  AS  FCTR_ELEM_APPL_CD            
MFA-TR*         , STRIP(:S-LAST-UPDATE-TS)     AS  LAST_UPDATE_TS               
MFA-TR*         , STRIP(:S-MULTI-VRSN-BA-CD)   AS  MULTI_VRSN_BA_CD             
MFA-TR*         ,:S-FCTR-DECIMAL-PLACE         AS  FCTR_DECIMAL_PLACE           
MFA-TR*       FROM                                                              
MFA-TR*          SYSIBM.SYSDUMMY1                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140000
      * 1000-PROCESS-INPUT                                             *02150000
      *                                                                *02160000
      *     1. PROCESS INPUT PARMS.                                    *02170000
      *                                                                *02180000
      ******************************************************************02190000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PGM-ID             TO WS-APPL-PGM-ID.         
           MOVE PARM-USER-ID                 TO WS-USER-ID.             
           MOVE PARM-FACTOR-ID               TO WS-FACTOR-ID.           
           MOVE PARM-PROC-REQ-ID             TO WS-PROC-REQ-ID.         
                                                                        
           PERFORM 1100-VALIDATE-INPUT       THRU 1100-EXIT.            
                                                                        
           IF WS-PROC-REQ-ID  > 0                                       
              MOVE 'Y'                       TO WS-SRCH-FLTR            
           ELSE                                                         
              IF PARM-FACTOR-ID  > SPACES                               
                 MOVE 'N'                    TO WS-SRCH-FLTR            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      * VALIDATION FOR INPUT VARIABLES                                          
      **************************************************************            
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF PARM-FACTOR-ID > SPACES                                   
           OR WS-PROC-REQ-ID > 0                                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '1100'               TO ACTIVE-PARAGRAPH             
              MOVE 'RECEIVE INPUT'      TO ABEND-FUNCTION               
              MOVE SPACES               TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE PARM-FACTOR-ID       TO HOSTVAR-ELEMENT-1            
              MOVE PARM-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2            
              MOVE +0                   TO WS-ACTIVE-RETURN-CODE        
              MOVE +1000                TO S-APPL-RETURN-CODE           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02450000
      * 2000-PROCESS-OUTPUT.                                           *02460000
      ******************************************************************02480000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT         THRU 2200-EXIT.            
           PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
           ADD 1                             TO CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02590000
      * 2000A-MOVE-RESULT                                              *02600000
      ******************************************************************02610000
       2000A-MOVE-RESULT.                                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SF-FACTOR-ID              TO  S-FACTOR-ID            
              MOVE SF-FACTOR-TEXT            TO  S-FACTOR-TEXT          
              MOVE SF-FACTOR-DESC            TO  S-FACTOR-DESC          
              MOVE SF-FACTOR-TYPE            TO  S-FACTOR-TYPE          
              MOVE SF-CHECK-ELEMENT          TO  S-CHECK-ELEMENT        
              MOVE SF-CALC-TYPE-CD           TO  S-CALC-TYPE-CD         
              MOVE SF-ADJUST-ELEMENT         TO  S-ADJUST-ELEMENT       
              MOVE SF-RATE-ELEC-FCTR         TO  S-RATE-ELEC-FCTR       
              MOVE SF-RATE-GAS-FCTR          TO  S-RATE-GAS-FCTR        
              MOVE SF-RATE-UNMTRD-FCTR       TO  S-RATE-UNMTRD-FCTR     
              MOVE SF-RATE-DEMAND-FCTR       TO  S-RATE-DEMAND-FCTR     
              MOVE SF-RATE-ON-PEAK-FCTR      TO  S-RATE-ON-PEAK-FCTR    
              MOVE SF-RATE-OFF-PEAK-FCTR     TO  S-RATE-OFF-PEAK-FCTR   
              MOVE SF-RATE-SHOULDER-FCTR     TO  S-RATE-SHOULDER-FCTR   
              MOVE SF-RATE-SUMMER-FCTR       TO  S-RATE-SUMMER-FCTR     
              MOVE SF-RATE-WINTER-FCTR       TO  S-RATE-WINTER-FCTR     
              MOVE SF-RATE-USAGE-FCTR        TO  S-RATE-USAGE-FCTR      
              MOVE SF-GL-ACCT-NO             TO  S-GL-ACCT-NO           
              MOVE SF-CODE-TAX-STAT-XMT      TO  S-CODE-TAX-STAT-XMT    
              MOVE SF-CODE-TAX-CITY-XMT      TO  S-CODE-TAX-CITY-XMT    
              MOVE SF-VERS-PRORATE-CD        TO  S-VERS-PRORATE-CD      
              MOVE SF-PRORATE-FL             TO  S-PRORATE-FL           
              MOVE SF-SPCL-GROUP-CD          TO  S-SPCL-GROUP-CD        
              MOVE SF-RATE-TEMPLATE-FL       TO  S-RATE-TEMPLATE-FL     
              MOVE SF-FACTOR-HISTORY-CD      TO  S-FACTOR-HISTORY-CD    
              MOVE SF-REV-INTERFACE-FL       TO  S-REV-INTERFACE-FL     
              MOVE SF-RT-ATTR-INCTV-TYPE     TO  S-RT-ATTR-INCTV-TYPE   
              MOVE SF-DURATION-TYPE-CD       TO  S-DURATION-TYPE-CD     
              MOVE SF-DURATION-START-CD      TO  S-DURATION-START-CD    
              MOVE SF-OVR-RT-VER-PRO-FL      TO  S-OVR-RT-VER-PRO-FL    
              MOVE SF-OVR-RT-CALC-TYP-CD     TO  S-OVR-RT-CALC-TYP-CD   
              MOVE SF-OVR-RATE-DESC          TO  S-OVR-RATE-DESC        
              MOVE SF-BILL-PRT-MSG-PL-CD     TO  S-BILL-PRT-MSG-PL-CD   
              MOVE SF-BILL-PRT-LN-ITM-FL     TO  S-BILL-PRT-LN-ITM-FL   
              MOVE SF-CODE-DR-CR             TO  S-CODE-DR-CR           
              MOVE SF-SPECIAL-CALC-CD        TO  S-SPECIAL-CALC-CD      
              MOVE SF-CODE-STATUS            TO  S-CODE-STATUS          
              MOVE SF-FCTR-POWER-10          TO  S-FCTR-POWER-10        
              MOVE SF-PROC-REQ-ID            TO  S-PROC-REQ-ID          
              MOVE SF-BILL-PRT-FCTR-CD       TO  S-BILL-PRT-FCTR-CD     
              MOVE SF-BILL-PRT-UNITS-CD      TO  S-BILL-PRT-UNITS-CD    
              MOVE SF-BILL-PRT-SEQ-NO        TO  S-BILL-PRT-SEQ-NO      
              MOVE SF-FCTR-ELEM-APPL-CD      TO  S-FCTR-ELEM-APPL-CD    
              MOVE SF-LAST-UPDATE-TS         TO  S-LAST-UPDATE-TS       
PRJ680        MOVE SF-MULTI-VRSN-BA-CD       TO  S-MULTI-VRSN-BA-CD     
PRJ680        MOVE SF-FCTR-DECIMAL-PLACE     TO  S-FCTR-DECIMAL-PLACE   
           ELSE                                                         
              INITIALIZE GTT-RETURN-FIELDS                              
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE        TO  S-RETURN-CODE.         
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************03597500
      * 2200-BUILD-RESULT.                                             *03597600
      *                                                                *03597700
      *      1. READ SPECIAL FACTOR INFORMATION BASED ON FACTOR ID.    *03597800
      *                                                                *03597900
      ******************************************************************03598000
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-READ-SPCL-FACTOR     THRU 7000-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************04090800
      * 7000-READ-SPCL-FACTOR.                                         *04090900
      *                                                                *04091000
      *     1. READ CSS_SPCL_FCTR INFORMATION THAT WILL BE DISPLAYED.  *04091100
      *                                                                *04091200
      ******************************************************************04091700
       7000-READ-SPCL-FACTOR.                                           
                                                                        
           EXEC SQL                                                     
             SELECT A.FACTOR_ID                                         
                   ,A.FACTOR_TEXT                                       
                   ,A.FACTOR_DESC                                       
                   ,A.FACTOR_TYPE                                       
                   ,A.CHECK_ELEMENT                                     
                   ,A.CALC_TYPE_CD                                      
                   ,A.ADJUST_ELEMENT                                    
                   ,A.RATE_ELEC_FCTR                                    
                   ,A.RATE_GAS_FCTR                                     
                   ,A.RATE_UNMTRD_FCTR                                  
                   ,A.RATE_DEMAND_FCTR                                  
                   ,A.RATE_ON_PEAK_FCTR                                 
                   ,A.RATE_OFF_PEAK_FCTR                                
                   ,A.RATE_SHOULDER_FCTR                                
                   ,A.RATE_SUMMER_FCTR                                  
                   ,A.RATE_WINTER_FCTR                                  
                   ,A.RATE_USAGE_FCTR                                   
                   ,A.GL_ACCT_NO                                        
                   ,A.CODE_TAX_STAT_XMT                                 
                   ,A.CODE_TAX_CITY_XMT                                 
                   ,A.VERS_PRORATE_CD                                   
                   ,A.PRORATE_FL                                        
                   ,A.SPCL_GROUP_CD                                     
                   ,A.RATE_TEMPLATE_FL                                  
                   ,A.FACTOR_HISTORY_CD                                 
                   ,A.REV_INTERFACE_FL                                  
                   ,A.RT_ATTR_INCTV_TYPE                                
                   ,A.DURATION_TYPE_CD                                  
                   ,A.DURATION_START_CD                                 
                   ,A.OVR_RT_VER_PRO_FL                                 
                   ,A.OVR_RT_CALC_TYP_CD                                
                   ,A.OVR_RATE_DESC                                     
                   ,A.BILL_PRT_MSG_PL_CD                                
                   ,A.BILL_PRT_LN_ITM_FL                                
                   ,A.CODE_DR_CR                                        
                   ,A.DEFLT_DURATION_NO                                 
                   ,A.SPECIAL_CALC_CD                                   
                   ,A.CODE_STATUS                                       
                   ,A.FCTR_POWER_10                                     
                   ,A.PROC_REQ_ID                                       
                   ,A.BILL_PRT_FCTR_CD                                  
                   ,A.BILL_PRT_UNITS_CD                                 
                   ,A.BILL_PRT_SEQ_NO                                   
                   ,A.FCTR_ELEM_APPL_CD                                 
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), A.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
PRJ680             ,A.MULTI_VRSN_BA_CD                                  
PRJ680             ,A.FCTR_DECIMAL_PLACE                                
               INTO :SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:SF-FACTOR-DESC                                     
                   ,:SF-FACTOR-TYPE                                     
                   ,:SF-CHECK-ELEMENT                                   
                   ,:SF-CALC-TYPE-CD                                    
                   ,:SF-ADJUST-ELEMENT                                  
                   ,:SF-RATE-ELEC-FCTR                                  
                   ,:SF-RATE-GAS-FCTR                                   
                   ,:SF-RATE-UNMTRD-FCTR                                
                   ,:SF-RATE-DEMAND-FCTR                                
                   ,:SF-RATE-ON-PEAK-FCTR                               
                   ,:SF-RATE-OFF-PEAK-FCTR                              
                   ,:SF-RATE-SHOULDER-FCTR                              
                   ,:SF-RATE-SUMMER-FCTR                                
                   ,:SF-RATE-WINTER-FCTR                                
                   ,:SF-RATE-USAGE-FCTR                                 
                   ,:SF-GL-ACCT-NO                                      
                   ,:SF-CODE-TAX-STAT-XMT                               
                   ,:SF-CODE-TAX-CITY-XMT                               
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:SF-PRORATE-FL                                      
                   ,:SF-SPCL-GROUP-CD                                   
                   ,:SF-RATE-TEMPLATE-FL                                
                   ,:SF-FACTOR-HISTORY-CD                               
                   ,:SF-REV-INTERFACE-FL                                
                   ,:SF-RT-ATTR-INCTV-TYPE                              
                   ,:SF-DURATION-TYPE-CD                                
                   ,:SF-DURATION-START-CD                               
                   ,:SF-OVR-RT-VER-PRO-FL                               
                   ,:SF-OVR-RT-CALC-TYP-CD                              
                   ,:SF-OVR-RATE-DESC                                   
                   ,:SF-BILL-PRT-MSG-PL-CD                              
                   ,:SF-BILL-PRT-LN-ITM-FL                              
                   ,:SF-CODE-DR-CR                                      
                   ,:SF-DEFLT-DURATION-NO :IND-DEFLT-DURATION-NO         
                   ,:SF-SPECIAL-CALC-CD                                 
                   ,:SF-CODE-STATUS                                     
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-PROC-REQ-ID                                     
                   ,:SF-BILL-PRT-FCTR-CD                                
                   ,:SF-BILL-PRT-UNITS-CD                               
                   ,:SF-BILL-PRT-SEQ-NO                                 
                   ,:SF-FCTR-ELEM-APPL-CD                               
                   ,:SF-LAST-UPDATE-TS                                  
PRJ680             ,:SF-MULTI-VRSN-BA-CD                                
PRJ680             ,:SF-FCTR-DECIMAL-PLACE                              
               FROM CSS_SPCL_FCTR A WITH(READUNCOMMITTED)                       
              WHERE ((A.FACTOR_ID      = :WS-FACTOR-ID                  
                AND  :WS-SRCH-FLTR     = 'N')                           
                 OR  (A.PROC_REQ_ID    = :WS-PROC-REQ-ID                
                AND  :WS-SRCH-FLTR     = 'Y'))                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04092000
MFA-TR*      SELECT A.FACTOR_ID                                         04092100
MFA-TR*            ,A.FACTOR_TEXT                                       04092200
MFA-TR*            ,A.FACTOR_DESC                                       04092300
MFA-TR*            ,A.FACTOR_TYPE                                       04092400
MFA-TR*            ,A.CHECK_ELEMENT                                     04092500
MFA-TR*            ,A.CALC_TYPE_CD                                      04092600
MFA-TR*            ,A.ADJUST_ELEMENT                                    04092700
MFA-TR*            ,A.RATE_ELEC_FCTR                                    04092800
MFA-TR*            ,A.RATE_GAS_FCTR                                     04092900
MFA-TR*            ,A.RATE_UNMTRD_FCTR                                  04093000
MFA-TR*            ,A.RATE_DEMAND_FCTR                                  04093700
MFA-TR*            ,A.RATE_ON_PEAK_FCTR                                 04094000
MFA-TR*            ,A.RATE_OFF_PEAK_FCTR                                04094100
MFA-TR*            ,A.RATE_SHOULDER_FCTR                                04094200
MFA-TR*            ,A.RATE_SUMMER_FCTR                                  04094300
MFA-TR*            ,A.RATE_WINTER_FCTR                                  04094400
MFA-TR*            ,A.RATE_USAGE_FCTR                                   04094500
MFA-TR*            ,A.GL_ACCT_NO                                        04094700
MFA-TR*            ,A.CODE_TAX_STAT_XMT                                 04095200
MFA-TR*            ,A.CODE_TAX_CITY_XMT                                 04095300
MFA-TR*            ,A.VERS_PRORATE_CD                                   04095602
MFA-TR*            ,A.PRORATE_FL                                        04095602
MFA-TR*            ,A.SPCL_GROUP_CD                                     04095602
MFA-TR*            ,A.RATE_TEMPLATE_FL                                          
MFA-TR*            ,A.FACTOR_HISTORY_CD                                         
MFA-TR*            ,A.REV_INTERFACE_FL                                          
MFA-TR*            ,A.RT_ATTR_INCTV_TYPE                                        
MFA-TR*            ,A.DURATION_TYPE_CD                                          
MFA-TR*            ,A.DURATION_START_CD                                         
MFA-TR*            ,A.OVR_RT_VER_PRO_FL                                         
MFA-TR*            ,A.OVR_RT_CALC_TYP_CD                                        
MFA-TR*            ,A.OVR_RATE_DESC                                             
MFA-TR*            ,A.BILL_PRT_MSG_PL_CD                                        
MFA-TR*            ,A.BILL_PRT_LN_ITM_FL                                        
MFA-TR*            ,A.CODE_DR_CR                                                
MFA-TR*            ,A.DEFLT_DURATION_NO                                         
MFA-TR*            ,A.SPECIAL_CALC_CD                                           
MFA-TR*            ,A.CODE_STATUS                                               
MFA-TR*            ,A.FCTR_POWER_10                                             
MFA-TR*            ,A.PROC_REQ_ID                                               
MFA-TR*            ,A.BILL_PRT_FCTR_CD                                          
MFA-TR*            ,A.BILL_PRT_UNITS_CD                                         
MFA-TR*            ,A.BILL_PRT_SEQ_NO                                           
MFA-TR*            ,A.FCTR_ELEM_APPL_CD                                         
MFA-TR*            ,A.LAST_UPDATE_TS                                            
MFA-TR*            ,A.MULTI_VRSN_BA_CD                                          
MFA-TR*            ,A.FCTR_DECIMAL_PLACE                                        
MFA-TR*        INTO :SF-FACTOR-ID                                       04095700
MFA-TR*            ,:SF-FACTOR-TEXT                                     04095800
MFA-TR*            ,:SF-FACTOR-DESC                                     04095900
MFA-TR*            ,:SF-FACTOR-TYPE                                     04096000
MFA-TR*            ,:SF-CHECK-ELEMENT                                   04096100
MFA-TR*            ,:SF-CALC-TYPE-CD                                    04096200
MFA-TR*            ,:SF-ADJUST-ELEMENT                                  04096300
MFA-TR*            ,:SF-RATE-ELEC-FCTR                                  04096400
MFA-TR*            ,:SF-RATE-GAS-FCTR                                   04096500
MFA-TR*            ,:SF-RATE-UNMTRD-FCTR                                04096600
MFA-TR*            ,:SF-RATE-DEMAND-FCTR                                04097300
MFA-TR*            ,:SF-RATE-ON-PEAK-FCTR                               04097600
MFA-TR*            ,:SF-RATE-OFF-PEAK-FCTR                              04097700
MFA-TR*            ,:SF-RATE-SHOULDER-FCTR                              04097800
MFA-TR*            ,:SF-RATE-SUMMER-FCTR                                04097900
MFA-TR*            ,:SF-RATE-WINTER-FCTR                                04098000
MFA-TR*            ,:SF-RATE-USAGE-FCTR                                 04098100
MFA-TR*            ,:SF-GL-ACCT-NO                                      04098300
MFA-TR*            ,:SF-CODE-TAX-STAT-XMT                               04098800
MFA-TR*            ,:SF-CODE-TAX-CITY-XMT                               04098900
MFA-TR*            ,:SF-VERS-PRORATE-CD                                 04099202
MFA-TR*            ,:SF-PRORATE-FL                                      04099202
MFA-TR*            ,:SF-SPCL-GROUP-CD                                   04099202
MFA-TR*            ,:SF-RATE-TEMPLATE-FL                                        
MFA-TR*            ,:SF-FACTOR-HISTORY-CD                                       
MFA-TR*            ,:SF-REV-INTERFACE-FL                                        
MFA-TR*            ,:SF-RT-ATTR-INCTV-TYPE                                      
MFA-TR*            ,:SF-DURATION-TYPE-CD                                        
MFA-TR*            ,:SF-DURATION-START-CD                                       
MFA-TR*            ,:SF-OVR-RT-VER-PRO-FL                                       
MFA-TR*            ,:SF-OVR-RT-CALC-TYP-CD                                      
MFA-TR*            ,:SF-OVR-RATE-DESC                                           
MFA-TR*            ,:SF-BILL-PRT-MSG-PL-CD                                      
MFA-TR*            ,:SF-BILL-PRT-LN-ITM-FL                                      
MFA-TR*            ,:SF-CODE-DR-CR                                              
MFA-TR*            ,:SF-DEFLT-DURATION-NO:IND-DEFLT-DURATION-NO                 
MFA-TR*            ,:SF-SPECIAL-CALC-CD                                         
MFA-TR*            ,:SF-CODE-STATUS                                             
MFA-TR*            ,:SF-FCTR-POWER-10                                           
MFA-TR*            ,:SF-PROC-REQ-ID                                             
MFA-TR*            ,:SF-BILL-PRT-FCTR-CD                                        
MFA-TR*            ,:SF-BILL-PRT-UNITS-CD                                       
MFA-TR*            ,:SF-BILL-PRT-SEQ-NO                                         
MFA-TR*            ,:SF-FCTR-ELEM-APPL-CD                                       
MFA-TR*            ,:SF-LAST-UPDATE-TS                                          
MFA-TR*            ,:SF-MULTI-VRSN-BA-CD                                        
MFA-TR*            ,:SF-FCTR-DECIMAL-PLACE                                      
MFA-TR*        FROM CSS_SPCL_FCTR A                                     04099300
MFA-TR*       WHERE ((A.FACTOR_ID      = :WS-FACTOR-ID                  04099400
MFA-TR*         AND  :WS-SRCH-FLTR     = 'N')                           04099400
MFA-TR*          OR  (A.PROC_REQ_ID    = :WS-PROC-REQ-ID                04099400
MFA-TR*         AND  :WS-SRCH-FLTR     = 'Y'))                          04099400
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04099500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR WS-ACTIVE-RETURN-CODE = NOT-FOUND-CALL                    
              IF IND-DEFLT-DURATION-NO = WS-YES-NULL                    
                 MOVE 'N/A'                  TO S-DEFLT-DURATION-NO     
              ELSE                                                      
                 MOVE SF-DEFLT-DURATION-NO   TO WS-DFT-DURATION-NO-TMP1 
                 MOVE WS-DFT-DURATION-NO-TMP1                           
                                             TO WS-DFT-DURATION-NO-TMP2 
                 MOVE WS-DFT-DURATION-NO-TMP2                           
                                             TO S-DEFLT-DURATION-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE 'PROC_REQ_ID'             TO TABLE-ELEMENT-2         
              MOVE WS-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              MOVE WS-PROC-REQ-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************04136000
      * 9000-SEND-ERROR-RESULT.                                        *04140000
      ******************************************************************04150000
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
      ******************************************************************04136000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *04140000
      ******************************************************************04150000
                                                                        
           EXEC SQL                                                     04160000
              INCLUDE CPDSP300                                          04170000
           END-EXEC.                                                    04180000
                                                                        
