       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04519.                                     
       DATE-WRITTEN.  07/30/2011.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROCEDURE PERFORMS AN UPDATE, INSERT OR DELETE OF FACTOR *        
      *  USE INFORMATION IN THE CSS_SPCL_FCTR_APPL TABLE DEPENDING ON  *        
      *  THE ACTION CODE PARAMETER.                                    *        
      ******************************************************************        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : UPDSPCLFCTRAPPL                                   *        
      *  INPUT     : APPL_PROG_ID        CHAR(03)                      *        
      *              USER_ID             CHAR(07)                      *        
      *              ACTION_CODE         CHAR(01)                      *        
      *              FACTOR_ID           CHAR(09)                      *        
      *              UTIL_TYPE           CHAR(01)                      *        
      *              RATE_PLAN           CHAR(03)                      *        
      *              RATE_COMPONENT_TMP  CHAR(08)                      *        
      *              REVENUE_CLASS       CHAR(03)                      *        
      *              START_DATE          CHAR(10)                      *        
      *              END_DATE            CHAR(10)                      *        
      *              FACTOR              CHAR(10)                      *        
      *              STATUS              CHAR(01)                      *        
      *              ENTRY_NO            CHAR(04)                      *        
      *              USER_ID_UPD_BY      CHAR(07)                      *        
      *              NEW_START_DATE      CHAR(10)                      *        
      *              CHG_INDICATOR       CHAR(01)                      *        
      *              FCTR_UPDATE_FL      CHAR(01)                      *        
      *              INT_DISP_START_TS   CHAR(26)                      *        
      *              INT_DISP_END_TS     CHAR(26)                      *        
      *              EXT_DISP_START_TS   CHAR(26)                      *        
      *              EXT_DISP_END_TS     CHAR(26)                      *        
      *              BLOCK_NO            CHAR(08)                      *        
      *              VERS_PRORATE_CD     CHAR(01)                      *        
      *              PROC_REQ_ID         CHAR(10)                      *        
      *              DELETE_BY_REQUEST   CHAR(01)                      *        
      *  OUTPUT    : RETURN_CODE         INTEGER                       *        
      *              APPL_RETURN_CODE    INTEGER                       *        
      *              ENTRY_NO            INTEGER                       *        
      *              DELETE_BPR          CHAR(01)                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *                                                                *        
      *   237   INVALID PROCESS REQUEST ID                             *        
      *   238   EXISTING ACTIVE ROW EXIST                              *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED. CLONED FROM  *        
P00473*                       CSR02014.                                *        
P00473*  01/23/11  MJ13662    DUE TO SUCCESSFUL RESULTS NOT BEING      *        
P00473*                       RETURNED, CHANGED LOGIC TO DECLARE       *        
P00473*                       TEMP TABLE IN 0100 INITIALIZE PARA.      *        
P00473*                       ALSO, CHANGED HOW PARM-BLOCK-NO IS MOVED *        
P00473*                       TO WS VARIABLE DUE TO ISSUES.            *        
P00473* 06/27/12   AW41078    ADDED LAST_UPDATE_TS TO INSERT AND UPDATE*        
PRJ473* 07/04/12   MS93554    ADDED DELETE BY REQUEST LOGIC.           *        
P00473* 08/07/12   AW41078    CORRECT ISSUE WITH -811 IN PARAGRAPH 2230*        
A04177* 08/20/12   MS93554    1.CALLED THIS SP THROUGH CSR04436 TO     *        
A04177*                         UPDATE CSS_SPCL_FCTR_APPL WHEN ACTION  *        
A04177*                         CODE PASSED AS 'F' AND PROC REQ ID.    *        
A04177*                       2.COMMENTED THE LOGIC TO DO NOT UPDATE   *        
A04177*                         DATE_TO WHEN NEW ROW INSERTED WITH     *        
A04177*                         TEST STATUS.                           *        
A04177*                       3.ADDED COMPONENT ID,BLOCK AND SEASON IN *        
A04177*                         THE WHERE CLAUSE IN 2540-GET-MAX-FROM  *        
A04177*                         -DATE PARA.                                     
A04221* 11/19/12   MS93554    UPDATE INT-DISP-END-TS WITH 1 MICROSECOND*        
      *                       FROM INT-DISP-START-DATE WHEN ACTION     *        
      *                       CODE PASSED AS 'F'.                *              
A04177* 05/30-13   MS93554    ADDED THE CODE TO AVOID ABEND WITH ERROR *        
      *            ACT-038    CD 237,INSTEAD WE NEED TO CHK WHETHER ROW*        
      *                       EXIST IN PROCESS REQ TABLE FOR THE SAME  *        
      *                       PROC REQ ID.IF IT IS, SYS WON'T THROW AN *        
      *                       ERROR MESSAGE.                           *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  +400    ADDRESS WAS FOUND BY FINALIST AND IT MATCHED EXACTLY  *        
      *          WITH THE ENTERED ADDRESS                              *        
      *  +300    ADDRESS WAS NOT FOUND BY FINALIST                     *        
      *  +200    ADDRESS WAS FOUND BY FINALIST BUT IT DID NOT EXACTLY  *        
      *          MATCH THE ENTERED ADDRESS                             *        
      *  ANY -   ERROR                                                 *        
      *   0      FINALIST WAS NOT CALLED                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04519'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4519 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *CSS_DELINQUENCY. C8.                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *CSS_RATE_PLAN_DESC. RD.                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PRICE_SCHED, PS                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_PROCESS_REQ, 1P                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
           COPY CWS00027.                                                       
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
       01  WORK-FIELDS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04519'.      
           05  PARM-RATE-COMPONENT.                                     
               10  PARM-CMPNT-ID-CD       PIC X(02) VALUE SPACES.       
               10  PARM-CODE-SEASON       PIC X(01) VALUE SPACES.       
               10  PARM-INSTR-USE-TYPE-CD PIC X(01) VALUE SPACES.       
               10  PARM-CODE-TIME-PERIOD  PIC X(04) VALUE SPACES.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-BLOCK-NO-EXISTS-SW   PIC X(01) VALUE 'N'.             
               88 WS-BLOCK-NO-EXISTS             VALUE 'Y'.             
               88 WS-BLOCK-NO-NOT-EXISTS         VALUE 'N'.             
PRJ473     05  WS-ROW-STATUS           PIC X(01) VALUE 'N'.             
PRJ473         88 ROW-FOUND                      VALUE 'Y'.             
PRJ473         88 ROW-NOT-FOUND                  VALUE 'N'.             
PRJ473     05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
PRJ473         88 NO-MORE-ROWS                   VALUE 'Y'.             
           05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
A04177     05  WS-ROW-EXIST            PIC X(01) VALUE 'N'.             
A04177         88  ROW-EXIST                     VALUE 'Y'.             
A04177         88  ROW-NOT-EXIST                 VALUE 'N'.             
                                                                        
                                                                        
        01  PARM-TO-WS-VARIABLES.                                       
            05  WS-ACTION-CODE            PIC X(01).                    
            05  WS-FACTOR-ID              PIC X(09).                    
            05  WS-BLOCK-NO               PIC S9(04) COMP VALUE 0.      
            05  WS-VERS-PRORATE-CD        PIC X(01).                    
            05  WS-UTIL-TYPE              PIC X(01).                    
            05  WS-RATE-PLAN              PIC X(03).                    
            05  WS-DATE-FROM              PIC X(10).                    
            05  WS-DATE-TO                PIC X(10).                    
            05  WS-RATE-COMPONENT.                                      
                10  WS-CMPNT-ID-CD        PIC X(02).                    
                10  WS-CODE-SEASON        PIC X(01).                    
                10  WS-INSTR-USE-TYPE-CD  PIC X(01).                    
                10  WS-CODE-TIME-PERIOD   PIC X(04).                    
                10  WS-CODE-TIME-PERIOD-NUM REDEFINES                   
                    WS-CODE-TIME-PERIOD                PIC 9(04).       
            05  WS-REVENUE-CLASS          PIC X(03).                    
            05  WS-START-DATE             PIC X(10).                    
            05  WS-START-DATE-ISO         PIC X(10).                    
            05  WS-START-DT-MINUS-1       PIC X(10).                    
A04221      05  WS-INT-DISP-MINUS-1       PIC X(26).                    
            05  WS-NEW-START-DATE         PIC X(10).                    
            05  WS-END-DATE               PIC X(10).                    
            05  WS-END-DATE-ISO           PIC X(10).                    
            05  WS-FACTOR                 PIC X(10).                    
            05  WS-FACTOR-NUM REDEFINES WS-FACTOR      PIC S9(10).      
            05  WS-STATUS                 PIC X(01).                    
            05  WS-ENTRY-NO               PIC X(04).                    
            05  WS-ENTRY-NO-NUM REDEFINES WS-ENTRY-NO  PIC 9(04).       
            05  WS-USER-ID-UPD-BY         PIC X(07).                    
            05  WS-MAX-FROM               PIC X(10).                    
            05  WS-MAX-TO                 PIC X(10).                    
            05  WS-PREV-STATUS            PIC X(01).                    
            05  WS-FCTR-UPDATE-FL         PIC X(01).                    
            05  WS-CHG-INDICATOR          PIC X(01).                    
            05  WS-RATE-PLAN-NO-TEMP      PIC X(03).                    
            05  WS-NO                     PIC X(01) VALUE 'N'.          
            05  WS-NEW-RATE-PLAN-FL       PIC X(01) VALUE 'N'.          
                88  RATE-PLAN-EQUAL                 VALUE 'Y'.          
                88  RATE-PLAN-NOT-EQUAL             VALUE 'N'.          
            05  WS-PROCESS-REQ-EXISTS-FL  PIC X(01) VALUE 'N'.          
                88  PROCESS-REQ-EXISTS              VALUE 'Y'.          
            05  WS-RATE-PLAN-INS-TABLE OCCURS 500 TIMES.                
                10  WS-RATE-PLAN-INS      PIC X(03) VALUE SPACES.       
                10  WS-ENTRY-NO-INS       PIC S9(04) COMP               
                                                    VALUE ZEROS.        
                10  WS-DATE-FROM-INS      PIC X(10) VALUE SPACES.       
                10  WS-DATE-TO-INS        PIC X(10) VALUE SPACES.       
            05  WS-INS-INDEX              PIC S9(03) COMP               
                                                    VALUE ZEROS.        
            05  WS-MAX-ENTRY-NO           PIC S9(04) COMP               
                                                    VALUE ZEROS.        
            05  WS-NEW-START-DATE-1       PIC X(10) VALUE SPACES.       
            05  WS-PREV-END-DATE          PIC X(10) VALUE SPACES.       
            05  WS-MAX-DATE-TO            PIC X(10).                    
            05  WS-INT-DISP-START-TS      PIC X(26) VALUE SPACES.       
            05  WS-INT-DISP-END-TS        PIC X(26) VALUE SPACES.       
            05  WS-EXT-DISP-START-TS      PIC X(26) VALUE SPACES.       
            05  WS-EXT-DISP-END-TS        PIC X(26) VALUE SPACES.       
            05  WS-PROC-REQ-ID            PIC 9(10).                    
            05  WS-ACTIVE                 PIC X(01) VALUE 'A'.          
A04177      05  WS-EXPIRED                PIC X(01) VALUE 'E'.          
A04177      05  WS-CODE-STATUS            PIC X(01) VALUE SPACES.       
A04177      05  WS-ACTV-ROW-ALRDY-EXIST   PIC X(01) VALUE 'N'.          
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-ENTRY-NO-IND           PIC S9(04) COMP VALUE 0.       
           05  WS-DATE-TO-IND            PIC S9(04) COMP VALUE 0.       
           05  NULL-VALUE                PIC S9(04) COMP VALUE -1.      
           05  WS-BLOCK-NULL-ID          PIC S9(04) COMP VALUE 0.       
                                                                        
       01  CODE-TIME-PERIOD-CONVERSION.                                 
           05  WS-CODE-TIME-PERIOD-INT   PIC S9(04) COMP.               
                                                                        
       01  FACTOR-CONVERSION.                                           
           05  WS-FACTOR-TEMP            PIC S9(10)V9(06).              
COB305     05 WS-FACTOR-DEC        PIC S9(10)V9(06) COMP-3 VALUE 0.       
           05  WS-FACTOR-SIGN.                                          
               10  WS-SIGN               PIC X(01).                     
               10  WS-NUMBER             PIC X(09).                     
                                                                        
       01  ENTRY-NO-CONVERSION.                                         
           05  WS-ENTRY-NO-INT           PIC S9(04) COMP.               
                                                                        
       01  ACTION-CODE-LITERALS.                                        
           05  INSERT-ROW                PIC X(01) VALUE 'I'.           
           05  UPDATE-ROW                PIC X(01) VALUE 'U'.           
           05  DELETE-ROW                PIC X(01) VALUE 'D'.           
A04177     05  FILE-ROW                  PIC X(01) VALUE 'F'.           
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE +0.     
           05  S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE +0.     
           05  S-ENTRY-NO                 PIC S9(09) COMP VALUE +0.     
           05  S-DELETE-BPR               PIC X(01) VALUE 'N'.          
      *                                                                 02559400
       01  WS-STORAGE-FIELDS.                                           
           05  WS-PRGM-NAME            PIC X(10) VALUE 'CSR04519'.      
           05  WS-BPR-COUNT            PIC S9(09) COMP VALUE +0.        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *                                                                 03984000
           EXEC SQL                                                     
                 DECLARE SPL_FACTOR_CRSR CURSOR FOR                     
                 SELECT SA.RATE_PLAN_NO,                                
                        SA.DATE_FROM,                                   
                        SA.DATE_TO,                                     
                        SA.ENTRY_NO,                                    
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                   FROM CSS_SPCL_FCTR_APPL SA                           
                  WHERE SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE       
                    AND SA.FACTOR_ID         = :SA-FACTOR-ID            
                    AND SA.CMPNT_ID_CD       = :SA-CMPNT-ID-CD          
                    AND SA.BLOCK_NO          = :SA-BLOCK-NO             
                    AND SA.CODE_SEASON       = :SA-CODE-SEASON          
                    AND SA.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD    
                    AND SA.CODE_TIME_PERIOD  = :SA-CODE-TIME-PERIOD     
                    AND SA.DATE_TO           > CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
                    AND SA.CODE_STATUS       = 'A'                      
                 FOR UPDATE OF DATE_TO, LAST_UPDATE_TS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE SPL_FACTOR_CRSR CURSOR FOR                             
MFA-TR*          SELECT SA.RATE_PLAN_NO,                                        
MFA-TR*                 SA.DATE_FROM,                                           
MFA-TR*                 SA.DATE_TO,                                             
MFA-TR*                 SA.ENTRY_NO,                                            
MFA-TR*                 SA.LAST_UPDATE_TS                                       
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*           WHERE SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE               
MFA-TR*             AND SA.FACTOR_ID         = :SA-FACTOR-ID                    
MFA-TR*             AND SA.CMPNT_ID_CD       = :SA-CMPNT-ID-CD                  
MFA-TR*             AND SA.BLOCK_NO          = :SA-BLOCK-NO                     
MFA-TR*             AND SA.CODE_SEASON       = :SA-CODE-SEASON                  
MFA-TR*             AND SA.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD            
MFA-TR*             AND SA.CODE_TIME_PERIOD  = :SA-CODE-TIME-PERIOD             
MFA-TR*             AND SA.DATE_TO           > CURRENT DATE                     
MFA-TR*             AND SA.CODE_STATUS       = 'A'                              
MFA-TR*          FOR UPDATE OF DATE_TO, LAST_UPDATE_TS                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *  CURSOR DECLARATION FOR TRANSCO FACTOR                                  
      ****************************************************************          
           EXEC SQL                                                     
                 DECLARE TRN_FACTOR_CRSR CURSOR FOR                     
                 SELECT SA.RATE_PLAN_NO,                                
                        SA.DATE_FROM,                                   
                        SA.DATE_TO,                                     
                        SA.ENTRY_NO                                     
                   FROM CSS_SPCL_FCTR_APPL SA                           
                  WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          
                    AND SA.FACTOR_ID      = :SA-FACTOR-ID               
                    AND SA.CMPNT_ID_CD    = :SA-CMPNT-ID-CD             
                    AND SA.DATE_TO        = IIF(TRY_CONVERT(DATE, 
                                                        :WS-MAX-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE-TO
              ) <> 0) OR (LEN(:WS-MAX-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :WS-MAX-DATE-TO
              ), CONVERT(DATE, :WS-MAX-DATE-TO) )             
                    AND SA.BLOCK_NO       = :SA-BLOCK-NO                
                    AND SA.CODE_STATUS    IN ('A', 'E')                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE TRN_FACTOR_CRSR CURSOR FOR                             
MFA-TR*          SELECT SA.RATE_PLAN_NO,                                        
MFA-TR*                 SA.DATE_FROM,                                           
MFA-TR*                 SA.DATE_TO,                                             
MFA-TR*                 SA.ENTRY_NO                                             
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*           WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                  
MFA-TR*             AND SA.FACTOR_ID      = :SA-FACTOR-ID                       
MFA-TR*             AND SA.CMPNT_ID_CD    = :SA-CMPNT-ID-CD                     
MFA-TR*             AND SA.DATE_TO        = :WS-MAX-DATE-TO                     
MFA-TR*             AND SA.BLOCK_NO       = :SA-BLOCK-NO                        
MFA-TR*             AND SA.CODE_STATUS    IN ('A', 'E')                         
MFA-TR*    END-EXEC.                                                            
                                                                        
PRJ473****************************************************************          
PRJ473*  CURSOR DECLARATION FOR SPCL FCTR APPL                                  
PRJ473****************************************************************          
PRJ473     EXEC SQL                                                     
PRJ473           DECLARE SPCL_FCTR_APPL_CUR CURSOR FOR                  
PRJ473           SELECT SA.CODE_UTIL_TYPE                               
PRJ473                 ,SA.RATE_PLAN_NO                                 
PRJ473                 ,SA.FACTOR_ID                                    
PRJ473                 ,SA.DATE_FROM                                    
PRJ473                 ,SA.DATE_TO                                      
PRJ473                 ,SA.ENTRY_NO                                     
A04177                 ,SA.BLOCK_NO                                     
A04177                 ,SA.CMPNT_ID_CD                                  
A04177                 ,SA.CODE_SEASON                                  
A04177                 ,SA.INSTR_USE_TYPE_CD                            
A04177                 ,SA.CODE_TIME_PERIOD                             
A04177                 ,SA.CODE_STATUS                                  
A04221                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA.INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS                            
PRJ473             FROM CSS_SPCL_FCTR_APPL SA                           
PRJ473            WHERE SA.PROC_REQ_ID    = :SA-PROC-REQ-ID             
PRJ473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE SPCL_FCTR_APPL_CUR CURSOR FOR                          
MFA-TR*          SELECT SA.CODE_UTIL_TYPE                                       
MFA-TR*                ,SA.RATE_PLAN_NO                                         
MFA-TR*                ,SA.FACTOR_ID                                            
MFA-TR*                ,SA.DATE_FROM                                            
MFA-TR*                ,SA.DATE_TO                                              
MFA-TR*                ,SA.ENTRY_NO                                             
MFA-TR*                ,SA.BLOCK_NO                                             
MFA-TR*                ,SA.CMPNT_ID_CD                                          
MFA-TR*                ,SA.CODE_SEASON                                          
MFA-TR*                ,SA.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,SA.CODE_TIME_PERIOD                                     
MFA-TR*                ,SA.CODE_STATUS                                          
MFA-TR*                ,SA.INT_DISP_START_TS                                    
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*           WHERE SA.PROC_REQ_ID    = :SA-PROC-REQ-ID                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID          PIC X(03).                        
       01  PARM-USER-ID               PIC X(07).                        
       01  PARM-ACTION-CODE           PIC X(01).                        
       01  PARM-FACTOR-ID             PIC X(09).                        
       01  PARM-UTIL-TYPE             PIC X(01).                        
       01  PARM-RATE-PLAN             PIC X(03).                        
       01  PARM-RATE-COMPONENT-TEMP   PIC X(08).                        
       01  PARM-REVENUE-CLASS         PIC X(03).                        
       01  PARM-START-DATE            PIC X(10).                        
       01  PARM-END-DATE              PIC X(10).                        
       01  PARM-FACTOR                PIC X(10).                        
       01  PARM-STATUS                PIC X(01).                        
       01  PARM-ENTRY-NO              PIC X(04).                        
       01  PARM-USER-ID-UPD-BY        PIC X(07).                        
       01  PARM-NEW-START-DATE        PIC X(10).                        
       01  PARM-CHG-INDICATOR         PIC X(01).                        
       01  PARM-FCTR-UPDATE-FL        PIC X(01).                        
       01  PARM-INT-DISP-START-TS     PIC X(26).                        
       01  PARM-INT-DISP-END-TS       PIC X(26).                        
       01  PARM-EXT-DISP-START-TS     PIC X(26).                        
       01  PARM-EXT-DISP-END-TS       PIC X(26).                        
P00473 01  PARM-BLOCK-NO              PIC X(8).                         
       01  PARM-VERS-PRORATE-CD       PIC X(01).                        
       01  PARM-PROC-REQ-ID           PIC 9(10).                        
PRJ473 01  PARM-DELETE-BY-REQUEST     PIC X(01).                        
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-USER-ID                            
                                PARM-ACTION-CODE                        
                                PARM-FACTOR-ID                          
                                PARM-UTIL-TYPE                          
                                PARM-RATE-PLAN                          
                                PARM-RATE-COMPONENT-TEMP                
                                PARM-REVENUE-CLASS                      
                                PARM-START-DATE                         
                                PARM-END-DATE                           
                                PARM-FACTOR                             
                                PARM-STATUS                             
                                PARM-ENTRY-NO                           
                                PARM-USER-ID-UPD-BY                     
                                PARM-NEW-START-DATE                     
                                PARM-CHG-INDICATOR                      
                                PARM-FCTR-UPDATE-FL                     
                                PARM-INT-DISP-START-TS                  
                                PARM-INT-DISP-END-TS                    
                                PARM-EXT-DISP-START-TS                  
                                PARM-EXT-DISP-END-TS                    
                                PARM-BLOCK-NO                           
                                PARM-VERS-PRORATE-CD                    
                                PARM-PROC-REQ-ID                        
                                PARM-DELETE-BY-REQUEST.                 
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *        
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *        
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *        
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *        
      *        U/I/D PROCESSES.                                        *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-RATE-COMPONENT-TEMP   TO PARM-RATE-COMPONENT.      
           MOVE PARM-ACTION-CODE           TO WS-ACTION-CODE.           
           MOVE PARM-FACTOR-ID             TO WS-FACTOR-ID.             
           MOVE PARM-UTIL-TYPE             TO WS-UTIL-TYPE.             
           MOVE PARM-RATE-PLAN             TO WS-RATE-PLAN.             
           MOVE PARM-RATE-COMPONENT        TO WS-RATE-COMPONENT.        
           MOVE PARM-REVENUE-CLASS         TO WS-REVENUE-CLASS.         
           MOVE PARM-START-DATE            TO WS-START-DATE.            
           MOVE PARM-NEW-START-DATE        TO WS-NEW-START-DATE.        
           MOVE PARM-END-DATE              TO WS-END-DATE.              
           MOVE PARM-FACTOR                TO WS-FACTOR.                
           MOVE PARM-STATUS                TO WS-STATUS.                
           MOVE PARM-ENTRY-NO              TO WS-ENTRY-NO.              
           MOVE PARM-USER-ID-UPD-BY        TO WS-USER-ID-UPD-BY.        
           MOVE PARM-CHG-INDICATOR         TO WS-CHG-INDICATOR.         
           MOVE PARM-FCTR-UPDATE-FL        TO WS-FCTR-UPDATE-FL.        
           MOVE PARM-INT-DISP-START-TS     TO WS-INT-DISP-START-TS.     
           MOVE PARM-INT-DISP-END-TS       TO WS-INT-DISP-END-TS.       
                                                                        
           MOVE PARM-EXT-DISP-START-TS     TO WS-EXT-DISP-START-TS.     
           MOVE PARM-EXT-DISP-END-TS       TO WS-EXT-DISP-END-TS.       
                                                                        
           MOVE WS-CODE-TIME-PERIOD-NUM    TO WS-CODE-TIME-PERIOD-INT.  
           MOVE WS-FACTOR-NUM              TO WS-FACTOR-TEMP.           
           MOVE WS-FACTOR-TEMP             TO WS-FACTOR-DEC.            
           MOVE WS-FACTOR                  TO WS-FACTOR-SIGN.           
P00473     IF PARM-BLOCK-NO IS NUMERIC                                  
P00473        MOVE PARM-BLOCK-NO           TO WS-BLOCK-NO               
P00473     ELSE                                                         
P00473        MOVE ZEROS                   TO WS-BLOCK-NO               
P00473     END-IF.                                                      
           MOVE PARM-VERS-PRORATE-CD       TO WS-VERS-PRORATE-CD.       
                                                                        
           DIVIDE 1000000 INTO WS-FACTOR-DEC.                           
                                                                        
           IF WS-SIGN = '-' THEN                                        
               MULTIPLY -1 BY WS-FACTOR-DEC
           END-IF.                            
                                                                        
           MOVE WS-ENTRY-NO-NUM             TO WS-ENTRY-NO-INT.         
                                                                        
P00473     PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE '0100A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04519_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04519_R1
              (                                                        
                   RETURN_CODE           INT                        
                  ,APPL_RETURN_CODE      INT                        
                  ,ENTRY_NO              INT                        
                  ,DELETE_BPR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00473         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04519_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                 WITH ROWSET POSITIONING FOR                            
               SELECT                                                   
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ENTRY_NO                                             
                  ,DELETE_BPR                                           
                FROM #CSR04519_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*          WITH ROWSET POSITIONING FOR                                    
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,ENTRY_NO                                                     
MFA-TR*           ,DELETE_BPR                                                   
MFA-TR*         FROM SESSION.CSR04519_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     -- THIS MODULE DIRECTS THE PROGRAM TO PERFORM AN INSERT,   *        
      *        UPDATE OR DELETE ROW DEPENDING ON THE ACTION CODE       *        
      *        PARAMETER THAT HAS BEEN SENT AS A PARAMETER.            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
                                                                        
           IF WS-ACTION-CODE = INSERT-ROW THEN                          
      ***     CHECK IF PROCESS REQUEST ID WAS PASSED AND EXISTS IN              
      ***     SYSTEM BEFORE INSERTING INTO CSS_SPCL_FCTR_APPL                   
                                                                        
              MOVE PARM-PROC-REQ-ID TO WS-PROC-REQ-ID                   
                                       1P-PROC-REQ-ID                   
                                       SA-PROC-REQ-ID                   
                                                                        
              PERFORM 7050-CHECK-PROCESS-REQ-EXISTS THRU 7050-EXIT      
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 100                  TO S-RETURN-CODE             
                 MOVE 237                  TO S-APPL-RETURN-CODE        
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
                                                                        
              IF  WS-CHG-INDICATOR = 'Y'                                
                  IF WS-FACTOR-ID = 'TRANSCO'                           
                     PERFORM 2215-UPDATE-RATE-PLAN   THRU 2215-EXIT     
                  ELSE                                                  
                     PERFORM 2210-UPDATE-RATE-PLAN   THRU 2210-EXIT     
                  END-IF                                                
                  PERFORM 2220-INSERT-ALL-RATES   THRU 2220-EXIT        
              END-IF                                                    
              IF  RATE-PLAN-NOT-EQUAL                                   
                  IF WS-BLOCK-NO > 0 THEN                               
                     PERFORM 2800-VALIDATE-BLOCK-NO THRU 2800-EXIT      
                  END-IF                                                
A04177*COMMENT THE BELOW LOGIC TO DO NOT UPDATE DATE_TO WHEN NEW                
A04177*ROW IS INSERTED WITH TEST STATUS.                                        
A04177*                                                                         
A04177*           IF  WS-CHG-INDICATOR NOT EQUAL 'Y'                            
A04177*               MOVE WS-UTIL-TYPE     TO SA-CODE-UTIL-TYPE                
A04177*               MOVE WS-FACTOR-ID     TO SA-FACTOR-ID                     
A04177*               MOVE WS-RATE-PLAN     TO SA-RATE-PLAN-NO                  
A04177*               MOVE WS-CMPNT-ID-CD   TO SA-CMPNT-ID-CD                   
A04177*               MOVE WS-BLOCK-NO      TO SA-BLOCK-NO                      
A04177*               MOVE WS-CODE-SEASON   TO SA-CODE-SEASON                   
A04177*               MOVE WS-INSTR-USE-TYPE-CD TO SA-INSTR-USE-TYPE-CD         
A04177*               MOVE WS-CODE-TIME-PERIOD-INT TO                           
A04177*                                            SA-CODE-TIME-PERIOD          
A04177*               PERFORM 2650-GET-MAX-ENTRY-NO                             
A04177*                                     THRU 2650-EXIT                      
A04177*               IF  WS-MAX-ENTRY-NO > 0                                   
A04177*                   PERFORM 2635-GET-PREV-DATE-TO                         
A04177*                                     THRU 2635-EXIT                      
A04177*                   PERFORM 2230-SELECT-SAME-RATE                         
A04177*                                     THRU 2230-EXIT                      
A04177*                   IF  WS-DATE-FROM > WS-NEW-START-DATE-1                
A04177*                       MOVE WS-DATE-FROM                                 
A04177*                                     TO WS-DATE-TO                       
A04177*                   ELSE                                                  
A04177*                       MOVE WS-NEW-START-DATE-1                          
A04177*                                     TO WS-DATE-TO                       
A04177*                   END-IF                                                
A04177*                   PERFORM 2235-UPDATE-SAME-RATE-DATE-TO                 
A04177*                                         THRU 2235-EXIT                  
A04177*               END-IF                                                    
A04177*           END-IF                                                        
                 MOVE PARM-RATE-PLAN       TO WS-RATE-PLAN              
                 PERFORM 2500-INSERT-ROW         THRU 2500-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ACTION-CODE = UPDATE-ROW THEN                          
              IF WS-FCTR-UPDATE-FL = 'Y' AND WS-CHG-INDICATOR = 'Y' THEN
                  PERFORM 2225-UPDATE-ALL-RATES   THRU 2225-EXIT        
              ELSE                                                      
                  IF WS-BLOCK-NO > 0 THEN                               
                     PERFORM 2800-VALIDATE-BLOCK-NO THRU 2800-EXIT      
                  END-IF                                                
                  PERFORM 2520-GET-PREV-STATUS       THRU 2520-EXIT     
                  IF WS-PREV-STATUS = 'T' AND                           
                              (WS-STATUS = 'A' OR WS-STATUS = 'F')      
                     PERFORM 2530-UPDATE-LAST-FACTOR THRU 2530-EXIT     
                  END-IF                                                
              END-IF                                                    
              PERFORM 2600-UPDATE-ROW            THRU 2600-EXIT         
           END-IF.                                                      
                                                                        
A04177*THE BELOW LOGIC CALLED FROM CSR04436 WHEN NEW-FACTOR-PRICE-WIZARD        
A04177*ACTION CODE PASSED AS 'F' AND PROC REQ ID.                               
A04177     IF WS-ACTION-CODE = FILE-ROW THEN                            
A04177        IF PARM-PROC-REQ-ID      > 0                              
A04177           MOVE PARM-PROC-REQ-ID       TO SA-PROC-REQ-ID          
A04177           PERFORM 7100-OPEN-SPCL-FCTR-APPL  THRU 7100-EXIT       
A04177           PERFORM 7200-FETCH-SPCL-FCTR-APPL THRU 7200-EXIT       
A04177           PERFORM 2105-FILE-ROW-PROCESS     THRU 2105-EXIT       
A04177                                            UNTIL NO-MORE-ROWS    
A04177           PERFORM 7300-CLOSE-SPCL-FCTR-APPL THRU 7300-EXIT       
A04177*          IF ROW NOT FOUND FOR THE PASSED PROC REQ ID.                   
A04177           IF ROW-NOT-FOUND                                       
A04177              MOVE 0                   TO S-RETURN-CODE           
A04177              MOVE 237                 TO S-APPL-RETURN-CODE      
A04177              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT          
A04177              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT          
A04177           END-IF                                                 
A04177        END-IF                                                    
A04177     END-IF.                                                      
                                                                        
PRJ473*    WHEN THE ACTION CODE IS DELETE AND DELETE BY REQUEST FLAG            
PRJ473*    IS 'Y' ( INPUT),SHOULD GET THE KEY VALUES FROM                       
PRJ473*    CSS_SPCL_FCTR_APPL TABLE TO PROCEED FURTHER.                         
                                                                        
           IF WS-ACTION-CODE = DELETE-ROW THEN                          
PRJ473        IF PARM-DELETE-BY-REQUEST = 'Y'                           
PRJ473           IF PARM-PROC-REQ-ID    > 0                             
PRJ473              MOVE PARM-PROC-REQ-ID       TO SA-PROC-REQ-ID       
PRJ473              PERFORM 7100-OPEN-SPCL-FCTR-APPL  THRU 7100-EXIT    
PRJ473              PERFORM 7200-FETCH-SPCL-FCTR-APPL THRU 7200-EXIT    
PRJ473              PERFORM 2100-DELETE-PROCESS       THRU 2100-EXIT    
PRJ473                                                UNTIL NO-MORE-ROWS
PRJ473              PERFORM 7300-CLOSE-SPCL-FCTR-APPL THRU 7300-EXIT    
PRJ473              IF ROW-NOT-FOUND                                    
A04177                 MOVE WS-NO               TO WS-ROW-EXIST         
A04177                 PERFORM 2704-CHK-ROW-EXIST     THRU 2704-EXIT    
A04177                 IF ROW-NOT-EXIST                                 
PRJ473                    MOVE 0                TO S-RETURN-CODE        
PRJ473                    MOVE 237              TO S-APPL-RETURN-CODE   
PRJ473                    PERFORM 8100-SEND-RESULT THRU 8100-EXIT       
PRJ473                    PERFORM 9999-END-PROGRAM THRU 9999-EXIT       
A04177                 END-IF                                           
PRJ473              END-IF                                              
PRJ473           ELSE                                                   
PRJ473              MOVE 0                      TO S-RETURN-CODE        
PRJ473              MOVE 237                    TO S-APPL-RETURN-CODE   
PRJ473              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT       
PRJ473              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
PRJ473           END-IF                                                 
PRJ473        ELSE                                                      
PRJ473           PERFORM 2700-DELETE-ROW           THRU 2700-EXIT       
PRJ473        END-IF                                                    
                                                                        
      *** DETERMINE IF BUSINESS PROCESS REQUEST IS TIED TO ANY OTHER            
      *** ROWS.                                                                 
               IF PARM-PROC-REQ-ID > 0 THEN                             
                  MOVE PARM-PROC-REQ-ID        TO SA-PROC-REQ-ID        
                  PERFORM 2705-GET-BPR-COUNT   THRU 2705-EXIT           
                  IF WS-BPR-COUNT EQUAL ZERO THEN                       
                     MOVE 'Y'                  TO S-DELETE-BPR          
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ473*****************************************************************         
PRJ473*                                                               *         
PRJ473*2100-DELETE-PROCESS.                                           *         
PRJ473*****************************************************************         
PRJ473 2100-DELETE-PROCESS.                                             
PRJ473                                                                  
PRJ473     MOVE SA-CODE-UTIL-TYPE        TO WS-UTIL-TYPE.               
PRJ473     MOVE SA-RATE-PLAN-NO          TO WS-RATE-PLAN.               
PRJ473     MOVE SA-FACTOR-ID             TO WS-FACTOR-ID.               
PRJ473     MOVE SA-DATE-FROM             TO WS-START-DATE.              
PRJ473     MOVE SA-ENTRY-NO              TO WS-ENTRY-NO-INT.            
PRJ473                                                                  
PRJ473     PERFORM 2700-DELETE-ROW             THRU 2700-EXIT.          
PRJ473     PERFORM 7200-FETCH-SPCL-FCTR-APPL   THRU 7200-EXIT.          
PRJ473                                                                  
PRJ473 2100-EXIT.                                                       
PRJ473     EXIT.                                                        
                                                                        
A04177*****************************************************************         
A04177*                                                               *         
A04177*2105-FILE-ROW-PROCESS.                                         *         
A04177*****************************************************************         
A04177 2105-FILE-ROW-PROCESS.                                           
A04177                                                                  
A04177     MOVE SA-CODE-UTIL-TYPE        TO WS-UTIL-TYPE.               
A04177     MOVE SA-RATE-PLAN-NO          TO WS-RATE-PLAN.               
A04177     MOVE SA-FACTOR-ID             TO WS-FACTOR-ID.               
A04177     MOVE SA-DATE-FROM             TO WS-START-DATE.              
A04177     MOVE SA-DATE-TO               TO WS-END-DATE.                
A04177     MOVE SA-BLOCK-NO              TO WS-BLOCK-NO.                
A04177     MOVE SA-ENTRY-NO              TO WS-ENTRY-NO-INT.            
A04177     MOVE SA-CMPNT-ID-CD           TO WS-CMPNT-ID-CD.             
A04177     MOVE SA-CODE-SEASON           TO WS-CODE-SEASON.             
A04177     MOVE SA-INSTR-USE-TYPE-CD     TO WS-INSTR-USE-TYPE-CD.       
A04177     MOVE SA-CODE-TIME-PERIOD      TO WS-CODE-TIME-PERIOD.        
A04177     MOVE WS-CODE-TIME-PERIOD-NUM  TO WS-CODE-TIME-PERIOD-INT.    
A04177     MOVE SA-CODE-STATUS           TO WS-STATUS.                  
A04177                                                                  
A04177     IF WS-BLOCK-NO > 0 THEN                                      
A04177        PERFORM 2800-VALIDATE-BLOCK-NO  THRU 2800-EXIT            
A04177     END-IF                                                       
A04221*    GETTING PREVIOUS ROW STATUS TO CHECK                                 
A04177     PERFORM 2520-GET-PREV-STATUS       THRU 2520-EXIT.           
A04177     IF WS-PREV-STATUS = 'T'                                      
A04177*    ANY DATE OF NEW ROW OVERLAPS WITH EXISTING ROWS                      
A04177        MOVE 'N'                       TO WS-ACTV-ROW-ALRDY-EXIST 
A04177        PERFORM 2535-DATE-OVERLAP-VLDT  THRU  2535-EXIT           
A04177        IF WS-ACTV-ROW-ALRDY-EXIST  = 'Y'                         
A04177           MOVE 0                      TO S-RETURN-CODE           
A04177           MOVE 238                    TO S-APPL-RETURN-CODE      
A04177           PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
A04177           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
A04177        END-IF                                                    
A04177        PERFORM 2530-UPDATE-LAST-FACTOR THRU 2530-EXIT            
A04177     END-IF                                                       
A04177                                                                  
A04177     PERFORM 2605-UPDATE-SPCL-FCTR-APPL THRU 2605-EXIT.           
A04177     PERFORM 7200-FETCH-SPCL-FCTR-APPL  THRU 7200-EXIT.           
A04177                                                                  
A04177 2105-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATES ROWS OF RATE-PLAN WITH MAX ENTRY-NO WITH DATE_TO AS *   05390001
      * THE VALUE OF NEW-START-DATE - 1 WHEN A NEW ROW IS INSERTED  *   05390001
      * IN THE PANEL WITH THE CHECKBOX APPLY TO ALL RATES CHECKED   *   05390001
      ***************************************************************           
       2210-UPDATE-RATE-PLAN.                                           
                                                                        
           MOVE WS-UTIL-TYPE                TO SA-CODE-UTIL-TYPE        
           MOVE WS-FACTOR-ID                TO SA-FACTOR-ID             
           MOVE WS-CMPNT-ID-CD              TO SA-CMPNT-ID-CD           
           MOVE WS-BLOCK-NO                 TO SA-BLOCK-NO              
           MOVE WS-CODE-SEASON              TO SA-CODE-SEASON           
           MOVE WS-INSTR-USE-TYPE-CD        TO SA-INSTR-USE-TYPE-CD     
           MOVE WS-CODE-TIME-PERIOD-INT     TO SA-CODE-TIME-PERIOD      
                                                                        
           PERFORM 2610-OPEN-SPLFCTR-CURSOR       THRU 2610-EXIT        
           PERFORM 2620-FETCH-SPLFCTR-CURSOR      THRU 2620-EXIT        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               IF  SA-RATE-PLAN-NO = WS-RATE-PLAN-NO-TEMP               
                   CONTINUE                                             
               ELSE                                                     
                   MOVE   SA-RATE-PLAN-NO   TO WS-RATE-PLAN-NO-TEMP     
                   PERFORM 2650-GET-MAX-ENTRY-NO  THRU 2650-EXIT        
                   ADD 1                    TO WS-INS-INDEX             
                   MOVE SA-RATE-PLAN-NO     TO                          
                              WS-RATE-PLAN-INS(WS-INS-INDEX)            
                   MOVE WS-MAX-ENTRY-NO     TO                          
                              WS-ENTRY-NO-INS(WS-INS-INDEX)             
               END-IF                                                   
               IF  (SA-RATE-PLAN-NO = WS-RATE-PLAN-INS(WS-INS-INDEX))   
               AND (SA-ENTRY-NO = WS-ENTRY-NO-INS(WS-INS-INDEX))        
                   PERFORM 2635-GET-PREV-DATE-TO  THRU 2635-EXIT        
                   IF  SA-DATE-FROM > WS-NEW-START-DATE-1               
                       MOVE SA-DATE-FROM          TO WS-PREV-END-DATE   
                   ELSE                                                 
                       MOVE WS-NEW-START-DATE-1   TO WS-PREV-END-DATE   
                   END-IF                                               
                   PERFORM 2640-UPDATE-DATE-TO    THRU 2640-EXIT        
               END-IF                                                   
               PERFORM 2620-FETCH-SPLFCTR-CURSOR  THRU 2620-EXIT        
           END-PERFORM                                                  
           PERFORM 2630-CLOSE-SPLFCTR-CURSOR      THRU 2630-EXIT.       
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      * SELECT MAX(DATE-TO) FOR TRANSCO FACTOR AND A NEW ROW INERTED*   05390001
      * IN THE PANEL WITH THE CHECKBOX APPLY TO ALL RATES CHECKED   *   05390001
      ***************************************************************           
       2215-UPDATE-RATE-PLAN.                                           
                                                                        
           MOVE WS-UTIL-TYPE                TO SA-CODE-UTIL-TYPE        
           MOVE WS-FACTOR-ID                TO SA-FACTOR-ID             
           MOVE WS-CMPNT-ID-CD              TO SA-CMPNT-ID-CD           
           MOVE WS-BLOCK-NO                 TO SA-BLOCK-NO              
           PERFORM 2740-GET-MAX-DATE-TO           THRU 2740-EXIT        
           PERFORM 2710-OPEN-TRNFCTR-CURSOR       THRU 2710-EXIT        
           PERFORM 2720-FETCH-TRNFCTR-CURSOR      THRU 2720-EXIT        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               IF  SA-RATE-PLAN-NO = WS-RATE-PLAN-NO-TEMP               
                   CONTINUE                                             
               ELSE                                                     
                   MOVE   SA-RATE-PLAN-NO   TO WS-RATE-PLAN-NO-TEMP     
                   PERFORM 2750-GET-MAX-ENTRY-NO  THRU 2750-EXIT        
                   ADD 1                    TO WS-INS-INDEX             
                   MOVE SA-RATE-PLAN-NO     TO                          
                              WS-RATE-PLAN-INS(WS-INS-INDEX)            
                   MOVE WS-MAX-ENTRY-NO     TO                          
                              WS-ENTRY-NO-INS(WS-INS-INDEX)             
                                                                        
               END-IF                                                   
               PERFORM 2720-FETCH-TRNFCTR-CURSOR  THRU 2720-EXIT        
           END-PERFORM                                                  
           PERFORM 2730-CLOSE-TRNFCTR-CURSOR      THRU 2730-EXIT.       
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERTS ROWS FOR RATE-PLAN WHICH WERE FETCHED BY CURSOR     *           
      * SPL_FACTOR_CRSR WITH ENTRY-NO AS MAX + 1 AND REMAINING      *           
      * VALUES AS THE VALUE OF NEW ROW WHEN A NEW ROW IS INSERTED   *           
      * IN THE PANEL WITH THE CHECKBOX APPLY TO ALL RATES CHECKED   *   05390001
      ***************************************************************           
       2220-INSERT-ALL-RATES.                                           
                                                                        
           PERFORM VARYING WS-INS-INDEX FROM 1 BY 1 UNTIL               
SCA006            WS-INS-INDEX > 500 OR 
                  WS-RATE-PLAN-INS(WS-INS-INDEX) = SPACES                       
               IF  PARM-RATE-PLAN = WS-RATE-PLAN-INS(WS-INS-INDEX)      
                   AND  RATE-PLAN-NOT-EQUAL                             
                   SET RATE-PLAN-EQUAL      TO TRUE                     
               END-IF                                                   
               MOVE WS-RATE-PLAN-INS(WS-INS-INDEX)                      
                                            TO WS-RATE-PLAN             
               IF WS-BLOCK-NO > 0 THEN                                  
                  PERFORM 2800-VALIDATE-BLOCK-NO                        
                                                  THRU 2800-EXIT        
               END-IF                                                   
                                                                        
               PERFORM 2500-INSERT-ROW            THRU 2500-EXIT        
           END-PERFORM.                                                 
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATES ROWS FOR RATE-PLAN WHICH WERE FETCHED BY CURSOR     *           
      * SPL_FACTOR_CRSR WITH CORRESPOND ENTRY NO AND REMAINING      *           
      * VALUES AS THE VALUE OF NEW FACTOR VALUE FOR ALL RATE PLANS  *           
      * IN THE PANEL WITH THE CHECKBOX APPLY TO ALL RATES CHECKED   *   05390001
      * AND PARM-FCTR-UPDATE-FL EQUALS TO "Y".                      *           
      ***************************************************************           
       2225-UPDATE-ALL-RATES.                                           
                                                                        
           MOVE WS-UTIL-TYPE                TO SA-CODE-UTIL-TYPE        
           MOVE WS-FACTOR-ID                TO SA-FACTOR-ID             
           MOVE WS-CMPNT-ID-CD              TO SA-CMPNT-ID-CD           
           MOVE WS-BLOCK-NO                 TO SA-BLOCK-NO              
           MOVE WS-CODE-SEASON              TO SA-CODE-SEASON           
           MOVE WS-INSTR-USE-TYPE-CD        TO SA-INSTR-USE-TYPE-CD     
           MOVE WS-CODE-TIME-PERIOD-INT     TO SA-CODE-TIME-PERIOD      
                                                                        
           PERFORM 2610-OPEN-SPLFCTR-CURSOR       THRU 2610-EXIT        
           PERFORM 2620-FETCH-SPLFCTR-CURSOR      THRU 2620-EXIT        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               IF  SA-RATE-PLAN-NO = WS-RATE-PLAN-NO-TEMP               
                   CONTINUE                                             
               ELSE                                                     
                   MOVE   SA-RATE-PLAN-NO   TO WS-RATE-PLAN-NO-TEMP     
                   ADD 1                    TO WS-INS-INDEX             
                   MOVE SA-RATE-PLAN-NO     TO                          
                              WS-RATE-PLAN-INS(WS-INS-INDEX)            
                   MOVE SA-ENTRY-NO         TO                          
                              WS-ENTRY-NO-INS(WS-INS-INDEX)             
                   MOVE SA-DATE-FROM        TO                          
                              WS-DATE-FROM-INS(WS-INS-INDEX)            
                   MOVE SA-DATE-TO          TO                          
                              WS-DATE-TO-INS(WS-INS-INDEX)              
               END-IF                                                   
               PERFORM 2620-FETCH-SPLFCTR-CURSOR  THRU 2620-EXIT        
           END-PERFORM.                                                 
           PERFORM 2630-CLOSE-SPLFCTR-CURSOR      THRU 2630-EXIT.       
                                                                        
           PERFORM 2525-GET-ISO-DATE              THRU 2525-EXIT.       
                                                                        
           PERFORM VARYING WS-INS-INDEX FROM 1 BY 1 UNTIL               
SCA006            WS-INS-INDEX > 500 OR 
                  WS-RATE-PLAN-INS(WS-INS-INDEX) = SPACES                       
               IF  PARM-RATE-PLAN = WS-RATE-PLAN-INS(WS-INS-INDEX)      
                   AND  RATE-PLAN-NOT-EQUAL                             
                   SET RATE-PLAN-EQUAL      TO TRUE                     
               END-IF                                                   
               MOVE WS-RATE-PLAN-INS(WS-INS-INDEX)                      
                                            TO WS-RATE-PLAN             
               MOVE WS-ENTRY-NO-INS(WS-INS-INDEX)                       
                                            TO WS-ENTRY-NO-INT          
               MOVE WS-DATE-FROM-INS(WS-INS-INDEX)                      
                                           TO WS-START-DATE             
               IF WS-DATE-FROM-INS(WS-INS-INDEX) EQUAL WS-START-DATE-ISO
                  AND WS-DATE-TO-INS(WS-INS-INDEX) EQUAL WS-END-DATE-ISO
                  PERFORM 2660-UPDATE-FACTOR         THRU 2660-EXIT     
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
       2225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SELECTS ACTIVE ROW FOR THE SAME RATE-PLAN AS NEW TO UPDATE ITS *        
      * DATE-TO.                                                       *        
      ******************************************************************        
      ******************************************************************        
       2230-SELECT-SAME-RATE.                                           
                                                                        
           EXEC SQL                                                     
                                                                        
               SELECT DATE_FROM                                         
                INTO  :WS-DATE-FROM                                     
                FROM  CSS_SPCL_FCTR_APPL                                
                WHERE  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                
                   AND RATE_PLAN_NO      = :WS-RATE-PLAN                
                   AND FACTOR_ID         = :WS-FACTOR-ID                
                   AND CODE_STATUS       = 'A'                          
                   AND ENTRY_NO          = :WS-MAX-ENTRY-NO             
                   AND DATE_TO           = IIF(TRY_CONVERT(DATE, 
                                                        :WS-MAX-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE-TO
              ) <> 0) OR (LEN(:WS-MAX-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :WS-MAX-DATE-TO
              ), CONVERT(DATE, :WS-MAX-DATE-TO) )              
                   AND BLOCK_NO          = :WS-BLOCK-NO                 
                   AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD              
                   AND CODE_SEASON       = :WS-CODE-SEASON              
                   AND INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD        
                   AND CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT     
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*                                                                         
MFA-TR*        SELECT DATE_FROM                                                 
MFA-TR*         INTO  :WS-DATE-FROM                                             
MFA-TR*         FROM  CSS_SPCL_FCTR_APPL                                06490002
MFA-TR*         WHERE  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                06630002
MFA-TR*            AND RATE_PLAN_NO      = :WS-RATE-PLAN                06650002
MFA-TR*            AND FACTOR_ID         = :WS-FACTOR-ID                06660002
MFA-TR*            AND CODE_STATUS       = 'A'                          06660002
MFA-TR*            AND ENTRY_NO          = :WS-MAX-ENTRY-NO             06670002
MFA-TR*            AND DATE_TO           = :WS-MAX-DATE-TO                      
MFA-TR*            AND BLOCK_NO          = :WS-BLOCK-NO                         
MFA-TR*            AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                      
MFA-TR*            AND CODE_SEASON       = :WS-CODE-SEASON                      
MFA-TR*            AND INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD                
MFA-TR*            AND CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT             
MFA-TR*                                                                 06680002
MFA-TR*    END-EXEC.                                                    06690002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2230'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-1        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-2        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * UPDATES DATE_TO OF EXISTING ACTIVE ROW FOR THE RATE-PLAN WITH  *        
      * NEW START_DATE - 1 OR ITS START-DATE WHEN A NEW ROW FOR THE    *        
      * RATE-PLAN WITH STATUS ACTIVE IS INSERTED                       *        
      ******************************************************************        
      ******************************************************************        
       2235-UPDATE-SAME-RATE-DATE-TO.                                   
                                                                        
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_SPCL_FCTR_APPL                                
                  SET  DATE_TO        = IIF(TRY_CONVERT(DATE, 
                                                            :WS-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TO) <> 0) OR (LEN(
                                                            :WS-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TO), CONVERT(DATE, 
                                                            :WS-DATE-TO
              ) )                     
                      ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()               
                WHERE  CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               
                       RATE_PLAN_NO   = :WS-RATE-PLAN AND               
                       FACTOR_ID      = :WS-FACTOR-ID AND               
                       CMPNT_ID_CD    = :WS-CMPNT-ID-CD AND             
                       DATE_TO        > CAST(SYSDATETIMEOFFSET() 
           AS DATE)  AND               
                       CODE_STATUS    = 'A'           AND               
                       ENTRY_NO       = :WS-MAX-ENTRY-NO                
                   AND DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) )                   
                   AND BLOCK_NO       = :WS-BLOCK-NO                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*                                                                         
MFA-TR*        UPDATE CSS_SPCL_FCTR_APPL                                06490002
MFA-TR*           SET  DATE_TO        = :WS-DATE-TO                     06500002
MFA-TR*               ,LAST_UPDATE_TS = CURRENT TIMESTAMP                       
MFA-TR*         WHERE  CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               06630002
MFA-TR*                RATE_PLAN_NO   = :WS-RATE-PLAN AND               06650002
MFA-TR*                FACTOR_ID      = :WS-FACTOR-ID AND               06660002
MFA-TR*                CMPNT_ID_CD    = :WS-CMPNT-ID-CD AND             06660002
MFA-TR*                DATE_TO        > CURRENT DATE  AND               06660002
MFA-TR*                CODE_STATUS    = 'A'           AND               06660002
MFA-TR*                ENTRY_NO       = :WS-MAX-ENTRY-NO                06670002
MFA-TR*            AND DATE_FROM      = :WS-DATE-FROM                           
MFA-TR*            AND BLOCK_NO       = :WS-BLOCK-NO                            
MFA-TR*                                                                 06680002
MFA-TR*    END-EXEC.                                                    06690002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2235'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-1        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-2        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2235-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05400001
      * 2500 INSERT ROW                                                *05410001
      *    -- THIS MODULE INSERTS A NEW ROW OF FACTOR USE INFORMATION  *05420001
      *       INTO THE CSS_SPCL_FCTR_APPL TABLE.                       *05430001
      ******************************************************************05440001
       2500-INSERT-ROW.                                                 
                                                                        
           PERFORM 2510-GET-ENTRY-NO            THRU 2510-EXIT.         
                                                                        
           MOVE WS-ENTRY-NO-INT                 TO S-ENTRY-NO.          
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SPCL_FCTR_APPL                           
                  (CODE_UTIL_TYPE,                                      
                   RATE_PLAN_NO,                                        
                   FACTOR_ID,                                           
                   BLOCK_NO,                                            
                   VERS_PRORATE_CD,                                     
                   DATE_FROM,                                           
                   ENTRY_NO,                                            
                   DATE_TO,                                             
                   CMPNT_ID_CD,                                         
                   CODE_SEASON,                                         
                   INSTR_USE_TYPE_CD,                                   
                   CODE_TIME_PERIOD,                                    
                   CODE_REVENUE_CLASS,                                  
                   FACTOR,                                              
                   CODE_STATUS,                                         
                   USER_ID_UPD_BY,                                      
                   INT_DISP_START_TS,                                   
                   INT_DISP_END_TS,                                     
                   EXT_DISP_START_TS,                                   
                   EXT_DISP_END_TS,                                     
                   PROC_REQ_ID,                                         
                   LAST_UPDATE_TS)                                      
               VALUES                                                   
                  (:WS-UTIL-TYPE,                                       
                   :WS-RATE-PLAN,                                       
                   :WS-FACTOR-ID,                                       
                   :WS-BLOCK-NO,                                        
                   :WS-VERS-PRORATE-CD,                                 
                   IIF(TRY_CONVERT(DATE, :WS-NEW-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-START-DATE
              ) <> 0) OR (LEN(:WS-NEW-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-START-DATE
              ), CONVERT(DATE, :WS-NEW-START-DATE) ),                          
                   :WS-ENTRY-NO-INT,                                    
                   IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ),                                
                   :WS-CMPNT-ID-CD,                                     
                   :WS-CODE-SEASON,                                     
                   :WS-INSTR-USE-TYPE-CD,                               
                   :WS-CODE-TIME-PERIOD-INT,                            
                   :WS-REVENUE-CLASS,                                   
                   :WS-FACTOR-DEC,                                      
                   :WS-STATUS,                                          
                   :WS-USER-ID-UPD-BY,                                  
                   CIS.CHAR2TIMESTAMP(:WS-INT-DISP-START-TS),                   
                   CIS.CHAR2TIMESTAMP(:WS-INT-DISP-END-TS),                     
                   CIS.CHAR2TIMESTAMP(:WS-EXT-DISP-START-TS),                   
                   CIS.CHAR2TIMESTAMP(:WS-EXT-DISP-END-TS),                     
                   :SA-PROC-REQ-ID,                                     
                   CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05520001
MFA-TR*        INSERT INTO CSS_SPCL_FCTR_APPL                           05530001
MFA-TR*           (CODE_UTIL_TYPE,                                      05540001
MFA-TR*            RATE_PLAN_NO,                                        05550001
MFA-TR*            FACTOR_ID,                                           05560001
MFA-TR*            BLOCK_NO,                                                    
MFA-TR*            VERS_PRORATE_CD,                                             
MFA-TR*            DATE_FROM,                                           05570001
MFA-TR*            ENTRY_NO,                                            05580001
MFA-TR*            DATE_TO,                                             05590001
MFA-TR*            CMPNT_ID_CD,                                         05600001
MFA-TR*            CODE_SEASON,                                         05610001
MFA-TR*            INSTR_USE_TYPE_CD,                                   05620001
MFA-TR*            CODE_TIME_PERIOD,                                    05630001
MFA-TR*            CODE_REVENUE_CLASS,                                  05640001
MFA-TR*            FACTOR,                                              05650001
MFA-TR*            CODE_STATUS,                                         05660001
MFA-TR*            USER_ID_UPD_BY,                                      05670001
MFA-TR*            INT_DISP_START_TS,                                           
MFA-TR*            INT_DISP_END_TS,                                             
MFA-TR*            EXT_DISP_START_TS,                                           
MFA-TR*            EXT_DISP_END_TS,                                             
MFA-TR*            PROC_REQ_ID,                                                 
MFA-TR*            LAST_UPDATE_TS)                                              
MFA-TR*        VALUES                                                   05680001
MFA-TR*           (:WS-UTIL-TYPE,                                       05690001
MFA-TR*            :WS-RATE-PLAN,                                       05700001
MFA-TR*            :WS-FACTOR-ID,                                       05710001
MFA-TR*            :WS-BLOCK-NO,                                                
MFA-TR*            :WS-VERS-PRORATE-CD,                                         
MFA-TR*            :WS-NEW-START-DATE,                                          
MFA-TR*            :WS-ENTRY-NO-INT,                                    05730001
MFA-TR*            :WS-END-DATE,                                        05740001
MFA-TR*            :WS-CMPNT-ID-CD,                                     05750001
MFA-TR*            :WS-CODE-SEASON,                                     05760001
MFA-TR*            :WS-INSTR-USE-TYPE-CD,                               05770001
MFA-TR*            :WS-CODE-TIME-PERIOD-INT,                            05780001
MFA-TR*            :WS-REVENUE-CLASS,                                   05790001
MFA-TR*            :WS-FACTOR-DEC,                                      05800001
MFA-TR*            :WS-STATUS,                                          05810001
MFA-TR*            :WS-USER-ID-UPD-BY,                                  05820001
MFA-TR*            :WS-INT-DISP-START-TS,                                       
MFA-TR*            :WS-INT-DISP-END-TS,                                         
MFA-TR*            :WS-EXT-DISP-START-TS,                                       
MFA-TR*            :WS-EXT-DISP-END-TS,                                         
MFA-TR*            :SA-PROC-REQ-ID,                                             
MFA-TR*            CURRENT TIMESTAMP)                                           
MFA-TR*    END-EXEC.                                                    05830001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT-ROW'            TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-1          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-3          
               MOVE 'ENTRY_NO'              TO TABLE-ELEMENT-4          
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-1        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-2        
               MOVE WS-NEW-START-DATE       TO HOSTVAR-ELEMENT-3        
               MOVE WS-ENTRY-NO-INT         TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06040001
      * 2510-GET-ENTRY-NO.                                             *06050001
      *     -- THIS MODULE SELECTS THE MAXIMUM ENTRY NUMBER FROM THE   *06060001
      *        CSS_SPCL_FCTR_APPL TABLE FOR INSERTING NEW MESSAGES.    *06070001
      ******************************************************************06080001
       2510-GET-ENTRY-NO.                                               
                                                                        
           EXEC SQL                                                     
               SELECT MAX(ENTRY_NO) + 1                                 
                 INTO :WS-ENTRY-NO-INT :WS-ENTRY-NO-IND                  
                 FROM CSS_SPCL_FCTR_APPL                                
                WHERE RATE_PLAN_NO   = :WS-RATE-PLAN      AND           
                      CODE_UTIL_TYPE = :WS-UTIL-TYPE      AND           
                      FACTOR_ID      = :WS-FACTOR-ID      AND           
                      DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEW-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-START-DATE
              ) <> 0) OR (LEN(:WS-NEW-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-START-DATE
              ), CONVERT(DATE, :WS-NEW-START-DATE) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06110001
MFA-TR*        SELECT MAX(ENTRY_NO) + 1                                 06120001
MFA-TR*          INTO :WS-ENTRY-NO-INT:WS-ENTRY-NO-IND                  06130001
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                06140001
MFA-TR*         WHERE RATE_PLAN_NO   = :WS-RATE-PLAN      AND                   
MFA-TR*               CODE_UTIL_TYPE = :WS-UTIL-TYPE      AND                   
MFA-TR*               FACTOR_ID      = :WS-FACTOR-ID      AND                   
MFA-TR*               DATE_FROM      = :WS-NEW-START-DATE                       
MFA-TR*    END-EXEC.                                                    06150001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-ENTRY-NO-IND = NULL-VALUE                          
                   MOVE +1                  TO WS-ENTRY-NO-INT          
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               MOVE +1                      TO WS-ENTRY-NO-INT          
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2510'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT '               TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06392001
      * 2520-GET-PREV-STATUS.                                          *06393001
      *     -- THIS MODULE SELECTS THE CODE STATUS.                    *06394001
      ******************************************************************06395001
                                                                        
       2520-GET-PREV-STATUS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT CODE_STATUS                                       
                 INTO :WS-PREV-STATUS                                   
                 FROM CSS_SPCL_FCTR_APPL                                
               WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND             
                      CODE_UTIL_TYPE = :WS-UTIL-TYPE AND                
                      RATE_PLAN_NO   = :WS-RATE-PLAN AND                
                      FACTOR_ID      = :WS-FACTOR-ID AND                
                      DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06400301
MFA-TR*        SELECT CODE_STATUS                                       06400401
MFA-TR*          INTO :WS-PREV-STATUS                                   06400501
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                06400601
MFA-TR*        WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND             06400701
MFA-TR*               CODE_UTIL_TYPE = :WS-UTIL-TYPE AND                06400801
MFA-TR*               RATE_PLAN_NO   = :WS-RATE-PLAN AND                06400901
MFA-TR*               FACTOR_ID      = :WS-FACTOR-ID AND                06401001
MFA-TR*               DATE_FROM      = :WS-START-DATE                   06401101
MFA-TR*    END-EXEC.                                                    06401201

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2520'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT '               TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'ENTRY_NO'              TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-3          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-4          
               MOVE WS-ENTRY-NO-INT         TO HOSTVAR-ELEMENT-1        
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-2        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-3        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06403408
      * 2525-GET-ISO-DATE.                                             *06403508
      *     -- THIS MODULE SELECTS THE CODE STATUS.                    *06403608
      ******************************************************************06403708
                                                                        
       2525-GET-ISO-DATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                              
                     ,IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                                
A04177               ,DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )                      
A04221               ,REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( 
              MICROSECOND, -1, CIS.CHAR2TIMESTAMP(
                                                 :SA-INT-DISP-START-TS)
               ), 121), ' ', '-'), ':', '.')  
                 INTO :WS-START-DATE-ISO                                
                     ,:WS-END-DATE-ISO                                  
A04177               ,:WS-START-DT-MINUS-1                              
A04221               ,:WS-INT-DISP-MINUS-1                              
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06404108
MFA-TR*        SELECT DATE(:WS-START-DATE)                              06404209
MFA-TR*              ,DATE(:WS-END-DATE)                                        
MFA-TR*              ,DATE(:WS-START-DATE) - 1 DAY                              
MFA-TR*              ,TIMESTAMP(:SA-INT-DISP-START-TS) - 1 MICROSECOND          
MFA-TR*          INTO :WS-START-DATE-ISO                                06404308
MFA-TR*              ,:WS-END-DATE-ISO                                          
MFA-TR*              ,:WS-START-DT-MINUS-1                                      
MFA-TR*              ,:WS-INT-DISP-MINUS-1                                      
MFA-TR*          FROM CSS_MODEL_SQL                                     06404408
MFA-TR*    END-EXEC.                                                    06405008

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2525'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MODEL_SQL'         TO TABLE-1                  
               MOVE 'WS-START-DATE'         TO TABLE-ELEMENT-1          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-3          
               MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-1        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-2        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06407108
      * 2530-UPDATE-LAST-FACTOR.                                       *06407208
      *     -- THIS UPDATE THE LAST FACTOR.                            *06407308
      ******************************************************************06407408
                                                                        
       2530-UPDATE-LAST-FACTOR.                                         
                                                                        
           PERFORM 2525-GET-ISO-DATE      THRU 2525-EXIT.               
A04221*    GETTING PREVIOUS ROW MAX FROM DT AND MAX TO DATE TO VALIDATE         
A04221*    WITH CURRENT ROW INPUT DATE.                                         
A04177     PERFORM 2540-GET-MAX-FROM-DATE THRU 2540-EXIT.               
A04177     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04177           IF WS-MAX-TO             = WS-END-DATE-ISO             
A04177              IF WS-START-DT-MINUS-1  >= WS-MAX-FROM AND          
A04177                 WS-CODE-STATUS        = WS-ACTIVE                
A04177                 PERFORM 2550-UPDATE-LAST-FACTOR THRU 2550-EXIT   
A04177              ELSE                                                
A04177                 MOVE 0                      TO S-RETURN-CODE     
A04177                 MOVE 238                    TO S-APPL-RETURN-CODE
A04177                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT    
A04177                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT    
A04177              END-IF                                              
                 END-IF                                                 
           END-IF.                                                      
                                                                        
       2530-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177******************************************************************06407108
A04177* 2535-DATE-OVERLAP-VLDT.                                        *06407208
A04177*                                                                *06407308
A04177******************************************************************06407408
A04177 2535-DATE-OVERLAP-VLDT.                                          
A04177                                                                  
A04177     EXEC SQL                                                     
A04177       SELECT TOP(1) 'Y'                                                 
A04177          INTO :WS-ACTV-ROW-ALRDY-EXIST                           
A04177          FROM CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)                   
A04177        WHERE  FACTOR_ID         = :WS-FACTOR-ID                  
A04177          AND  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                  
A04177          AND  RATE_PLAN_NO      = :WS-RATE-PLAN                  
A04177          AND  CMPNT_ID_CD       = :WS-CMPNT-ID-CD                
A04177          AND  BLOCK_NO          = :WS-BLOCK-NO                   
A04177          AND  CODE_SEASON       = :WS-CODE-SEASON                
A04177          AND  INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD          
A04177          AND  CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT       
A04177          AND  ((DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                 
A04177          AND    DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )               
A04177           OR   (DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                   
A04177          AND    DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )                 
A04177           OR   (DATE_FROM      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                 
A04177          AND    DATE_TO        <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))                
A04177          AND  DATE_TO          <> IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                   
A04177          AND  CODE_STATUS      IN (:WS-ACTIVE ,:WS-EXPIRED)      
A04177                                       
A04177                                                      
A04177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*         INTO :WS-ACTV-ROW-ALRDY-EXIST                                   
MFA-TR*         FROM CSS_SPCL_FCTR_APPL                                         
MFA-TR*       WHERE  FACTOR_ID         = :WS-FACTOR-ID                          
MFA-TR*         AND  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                          
MFA-TR*         AND  RATE_PLAN_NO      = :WS-RATE-PLAN                          
MFA-TR*         AND  CMPNT_ID_CD       = :WS-CMPNT-ID-CD                        
MFA-TR*         AND  BLOCK_NO          = :WS-BLOCK-NO                           
MFA-TR*         AND  CODE_SEASON       = :WS-CODE-SEASON                        
MFA-TR*         AND  INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD                  
MFA-TR*         AND  CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT               
MFA-TR*         AND  ((DATE_FROM      <= :WS-START-DATE                         
MFA-TR*         AND    DATE_TO        >= :WS-START-DATE )                       
MFA-TR*          OR   (DATE_FROM      <= :WS-END-DATE                           
MFA-TR*         AND    DATE_TO        >= :WS-END-DATE )                         
MFA-TR*          OR   (DATE_FROM      >= :WS-START-DATE                         
MFA-TR*         AND    DATE_TO        <= :WS-END-DATE ))                        
MFA-TR*         AND  DATE_TO          <> :WS-END-DATE                           
MFA-TR*         AND  CODE_STATUS      IN (:WS-ACTIVE ,:WS-EXPIRED)              
MFA-TR*     FETCH FIRST ROW ONLY WITH UR                                        
MFA-TR*     QUERYNO 2535                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04177                                                                  
A04177     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04177         NEXT SENTENCE                                            
A04177     ELSE                                                         
A04177         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04177         MOVE '2535'                  TO ACTIVE-PARAGRAPH         
A04177         MOVE 'SELECT'                TO ABEND-FUNCTION           
A04177         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
A04177                                         ABEND-TABLES             
A04177         MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
A04177         MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-1          
A04177         MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
A04177         MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-3          
A04177         MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
A04177         MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-1        
A04177         MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-2        
A04177         MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-3        
A04177         MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-4        
A04177         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A04177         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A04177     END-IF.                                                      
A04177                                                                  
A04177 2535-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
      ******************************************************************06411502
      * 2540-GET-MAX-FROM-DATE.                                        *06411602
      ******************************************************************06411802
                                                                        
       2540-GET-MAX-FROM-DATE.                                          
                                                                        
           EXEC SQL                                                     
A04177         SELECT TOP(1) DATE_FROM,
              DATE_TO,
              CODE_STATUS                    
A04177           INTO :WS-MAX-FROM                                      
A04177               ,:WS-MAX-TO                                        
A04177               ,:WS-CODE-STATUS                                   
                 FROM CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)                  
               WHERE  FACTOR_ID         = :WS-FACTOR-ID                 
                 AND  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                 
                 AND  RATE_PLAN_NO      = :WS-RATE-PLAN                 
A04177           AND  CMPNT_ID_CD       = :WS-CMPNT-ID-CD               
A04177           AND  BLOCK_NO          = :WS-BLOCK-NO                  
A04177           AND  CODE_SEASON       = :WS-CODE-SEASON               
A04177           AND  INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD         
A04177           AND  CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT      
A04177*          AND  DATE_FROM        <> :WS-START-DATE                06412905
A04177           AND  DATE_TO          >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                
A04177           AND  CODE_STATUS       IN (:WS-ACTIVE , :WS-EXPIRED)   
A04177           ORDER BY DATE_FROM DESC                                
A04177                   ,DATE_TO   DESC                                
A04177                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06412202
MFA-TR*        SELECT DATE_FROM,DATE_TO, CODE_STATUS                    06412308
MFA-TR*          INTO :WS-MAX-FROM                                      06412402
MFA-TR*              ,:WS-MAX-TO                                        06412402
MFA-TR*              ,:WS-CODE-STATUS                                           
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                06412502
MFA-TR*        WHERE  FACTOR_ID         = :WS-FACTOR-ID                 06412602
MFA-TR*          AND  CODE_UTIL_TYPE    = :WS-UTIL-TYPE                 06412702
MFA-TR*          AND  RATE_PLAN_NO      = :WS-RATE-PLAN                 06412802
MFA-TR*          AND  CMPNT_ID_CD       = :WS-CMPNT-ID-CD                       
MFA-TR*          AND  BLOCK_NO          = :WS-BLOCK-NO                          
MFA-TR*          AND  CODE_SEASON       = :WS-CODE-SEASON                       
MFA-TR*          AND  INSTR_USE_TYPE_CD = :WS-INSTR-USE-TYPE-CD                 
MFA-TR*          AND  CODE_TIME_PERIOD  = :WS-CODE-TIME-PERIOD-INT              
MFA-TR*          AND  DATE_FROM        <> :WS-START-DATE                06412905
MFA-TR*          AND  DATE_TO          >= :WS-START-DATE                06680002
MFA-TR*          AND  CODE_STATUS       IN (:WS-ACTIVE , :WS-EXPIRED)   06680002
MFA-TR*          ORDER BY DATE_FROM DESC                                06680002
MFA-TR*                  ,DATE_TO   DESC                                06680002
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                    06413005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2540'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-3          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-1        
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-2        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-3        
               MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06416005
      * 2550-UPDATE-LAST-FACTOR                                        *06420002
      *    -- THIS MODULE UPDATES A ROW OF FACTOR USE INFORMATION      *06430002
      *       IN THE CSS_SPCL_FCTR_APPL TABLE.                         *06440002
      ******************************************************************06450002
       2550-UPDATE-LAST-FACTOR.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_FCTR_APPL                                
                  SET  DATE_TO            = IIF(TRY_CONVERT(DATE, 
                                                   :WS-START-DT-MINUS-1
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DT-MINUS-1
              ) <> 0) OR (LEN(:WS-START-DT-MINUS-1
              ) <> 10), CIS.CHAR2DATE(:WS-START-DT-MINUS-1
              ), CONVERT(DATE, :WS-START-DT-MINUS-1) )        
A04221                ,INT_DISP_END_TS    = CIS.CHAR2TIMESTAMP(
                                                   :WS-INT-DISP-MINUS-1
              )        
                      ,USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY          
                      ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()           
                WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE               
                   AND RATE_PLAN_NO       = :WS-RATE-PLAN               
                   AND FACTOR_ID          = :WS-FACTOR-ID               
                   AND DATE_FROM          = IIF(TRY_CONVERT(DATE, 
                                                           :WS-MAX-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-FROM
              ) <> 0) OR (LEN(:WS-MAX-FROM) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-FROM
              ), CONVERT(DATE, :WS-MAX-FROM) )                
                   AND BLOCK_NO           = :WS-BLOCK-NO                
A04177             AND CMPNT_ID_CD        = :WS-CMPNT-ID-CD             
A04177             AND CODE_SEASON        = :WS-CODE-SEASON             
A04177             AND INSTR_USE_TYPE_CD  = :WS-INSTR-USE-TYPE-CD       
A04177             AND CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD-INT    
A04177             AND CODE_STATUS        = :WS-ACTIVE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*        UPDATE CSS_SPCL_FCTR_APPL                                06490002
MFA-TR*           SET  DATE_TO            = :WS-START-DT-MINUS-1        06500002
MFA-TR*               ,INT_DISP_END_TS    = :WS-INT-DISP-MINUS-1                
MFA-TR*               ,USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY                  
MFA-TR*               ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                   
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :WS-UTIL-TYPE               06630002
MFA-TR*            AND RATE_PLAN_NO       = :WS-RATE-PLAN               06650002
MFA-TR*            AND FACTOR_ID          = :WS-FACTOR-ID               06660002
MFA-TR*            AND DATE_FROM          = :WS-MAX-FROM                06670002
MFA-TR*            AND BLOCK_NO           = :WS-BLOCK-NO                        
MFA-TR*            AND CMPNT_ID_CD        = :WS-CMPNT-ID-CD             06680002
MFA-TR*            AND CODE_SEASON        = :WS-CODE-SEASON             06680002
MFA-TR*            AND INSTR_USE_TYPE_CD  = :WS-INSTR-USE-TYPE-CD               
MFA-TR*            AND CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD-INT    06680002
MFA-TR*            AND CODE_STATUS        = :WS-ACTIVE                  06680002
MFA-TR*    END-EXEC.                                                    06690002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2550'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-1        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-2        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               MOVE WS-MAX-FROM             TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06890110
      * 2560-GET-MAX-TO-DATE.                                          *06890210
      *     -- THIS MODULE SELECTS THE MAX DATE.                       *06890310
      ******************************************************************06890410
                                                                        
       2560-GET-MAX-TO-DATE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DATE_TO,
              CODE_STATUS                             
                 INTO :WS-MAX-TO :NULL-VALUE                             
                     ,:WS-CODE-STATUS                                   
                 FROM CSS_SPCL_FCTR_APPL                                
               WHERE  FACTOR_ID      = :WS-FACTOR-ID                    
                 AND  CODE_UTIL_TYPE = :WS-UTIL-TYPE                    
                 AND  RATE_PLAN_NO   = :WS-RATE-PLAN                    
                 AND  DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                           :WS-MAX-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-FROM
              ) <> 0) OR (LEN(:WS-MAX-FROM) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-FROM
              ), CONVERT(DATE, :WS-MAX-FROM) )                     
               ORDER BY DATE_TO DESC                                    
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06890810
MFA-TR*        SELECT DATE_TO , CODE_STATUS                             06890910
MFA-TR*          INTO :WS-MAX-TO:NULL-VALUE                             06891010
MFA-TR*              ,:WS-CODE-STATUS                                           
MFA-TR*          FROM CSS_SPCL_FCTR_APPL                                06891110
MFA-TR*        WHERE  FACTOR_ID      = :WS-FACTOR-ID                    06891210
MFA-TR*          AND  CODE_UTIL_TYPE = :WS-UTIL-TYPE                    06891310
MFA-TR*          AND  RATE_PLAN_NO   = :WS-RATE-PLAN                    06891410
MFA-TR*          AND  DATE_FROM      = :WS-MAX-FROM                     06891510
MFA-TR*        ORDER BY DATE_TO DESC                                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*    END-EXEC.                                                    06891610

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2560'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-3          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-1        
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-2        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-3        
               MOVE WS-MAX-FROM             TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06893802
      * 2610 UPDATE ROW                                                *06893902
      *    -- THIS MODULE UPDATES A ROW OF FACTOR USE INFORMATION      *06894002
      *       IN THE CSS_SPCL_FCTR_APPL TABLE.                         *06895002
      ******************************************************************06896002
       2600-UPDATE-ROW.                                                 
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_FCTR_APPL                                
                  SET  CODE_UTIL_TYPE     = :WS-UTIL-TYPE,              
                       RATE_PLAN_NO       = :WS-RATE-PLAN,              
                       FACTOR_ID          = :WS-FACTOR-ID,              
                       BLOCK_NO           = :WS-BLOCK-NO,               
                       VERS_PRORATE_CD    = :WS-VERS-PRORATE-CD,        
                       DATE_FROM          = IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEW-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-START-DATE
              ) <> 0) OR (LEN(:WS-NEW-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-START-DATE
              ), CONVERT(DATE, :WS-NEW-START-DATE) ),         
                       DATE_TO            = IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ),               
                       CMPNT_ID_CD        = :WS-CMPNT-ID-CD,            
                       CODE_SEASON        = :WS-CODE-SEASON,            
                       INSTR_USE_TYPE_CD  = :WS-INSTR-USE-TYPE-CD,      
                       CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD-INT,   
                       CODE_REVENUE_CLASS = :WS-REVENUE-CLASS,          
                       FACTOR             = :WS-FACTOR-DEC,             
                       CODE_STATUS        = :WS-STATUS,                 
                       USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY,         
                       INT_DISP_START_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-INT-DISP-START-TS
              ),      
                       INT_DISP_END_TS    = CIS.CHAR2TIMESTAMP(
                                                    :WS-INT-DISP-END-TS
              ),        
                       EXT_DISP_START_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-EXT-DISP-START-TS
              ),      
                       EXT_DISP_END_TS    = CIS.CHAR2TIMESTAMP(
                                                    :WS-EXT-DISP-END-TS
              )         
                      ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()               
                WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND            
                       CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               
                       RATE_PLAN_NO   = :WS-RATE-PLAN AND               
                       FACTOR_ID      = :WS-FACTOR-ID AND               
                       DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                  
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06899002
MFA-TR*        UPDATE CSS_SPCL_FCTR_APPL                                06899102
MFA-TR*           SET  CODE_UTIL_TYPE     = :WS-UTIL-TYPE,              06899202
MFA-TR*                RATE_PLAN_NO       = :WS-RATE-PLAN,              06899302
MFA-TR*                FACTOR_ID          = :WS-FACTOR-ID,              06899402
MFA-TR*                BLOCK_NO           = :WS-BLOCK-NO,                       
MFA-TR*                VERS_PRORATE_CD    = :WS-VERS-PRORATE-CD,                
MFA-TR*                DATE_FROM          = :WS-NEW-START-DATE,                 
MFA-TR*                DATE_TO            = :WS-END-DATE,               06899602
MFA-TR*                CMPNT_ID_CD        = :WS-CMPNT-ID-CD,            06899702
MFA-TR*                CODE_SEASON        = :WS-CODE-SEASON,            06899802
MFA-TR*                INSTR_USE_TYPE_CD  = :WS-INSTR-USE-TYPE-CD,      06899902
MFA-TR*                CODE_TIME_PERIOD   = :WS-CODE-TIME-PERIOD-INT,   06900002
MFA-TR*                CODE_REVENUE_CLASS = :WS-REVENUE-CLASS,          06900102
MFA-TR*                FACTOR             = :WS-FACTOR-DEC,             06900202
MFA-TR*                CODE_STATUS        = :WS-STATUS,                 06900302
MFA-TR*                USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY,         06900402
MFA-TR*                INT_DISP_START_TS  = :WS-INT-DISP-START-TS,              
MFA-TR*                INT_DISP_END_TS    = :WS-INT-DISP-END-TS,                
MFA-TR*                EXT_DISP_START_TS  = :WS-EXT-DISP-START-TS,              
MFA-TR*                EXT_DISP_END_TS    = :WS-EXT-DISP-END-TS                 
MFA-TR*               ,LAST_UPDATE_TS = CURRENT TIMESTAMP                       
MFA-TR*         WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND            06900502
MFA-TR*                CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               06900602
MFA-TR*                RATE_PLAN_NO   = :WS-RATE-PLAN AND               06900702
MFA-TR*                FACTOR_ID      = :WS-FACTOR-ID AND               06900802
MFA-TR*                DATE_FROM      = :WS-START-DATE                  06900902
MFA-TR*                                                                 06901002
MFA-TR*    END-EXEC.                                                    06901102

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-1        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-2        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177*****************************************************************         
A04177*                                                               *         
A04177* 2605-UPDATE-SPCL-FCTR-APPL.                                   *         
A04177*****************************************************************         
A04177 2605-UPDATE-SPCL-FCTR-APPL.                                      
A04177                                                                  
A04177     EXEC SQL                                                     
A04177          UPDATE CSS_SPCL_FCTR_APPL                               
A04177             SET CODE_STATUS = 'A'                                
A04177                ,USER_ID_UPD_BY  = :WS-USER-ID-UPD-BY             
A04177                ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()              
A04177           WHERE CODE_UTIL_TYPE  = :WS-UTIL-TYPE                  
A04177             AND RATE_PLAN_NO    = :WS-RATE-PLAN                  
A04177             AND FACTOR_ID       = :WS-FACTOR-ID                  
A04177             AND DATE_FROM       = IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                 
A04177             AND ENTRY_NO        = :WS-ENTRY-NO-INT               
A04177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SPCL_FCTR_APPL                                       
MFA-TR*            SET CODE_STATUS = 'A'                                        
MFA-TR*               ,USER_ID_UPD_BY  = :WS-USER-ID-UPD-BY                     
MFA-TR*               ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                      
MFA-TR*          WHERE CODE_UTIL_TYPE  = :WS-UTIL-TYPE                          
MFA-TR*            AND RATE_PLAN_NO    = :WS-RATE-PLAN                          
MFA-TR*            AND FACTOR_ID       = :WS-FACTOR-ID                          
MFA-TR*            AND DATE_FROM       = :WS-START-DATE                         
MFA-TR*            AND ENTRY_NO        = :WS-ENTRY-NO-INT                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04177                                                                  
A04177     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04177        CONTINUE                                                  
A04177     ELSE                                                         
A04177        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A04177        MOVE '2605'                    TO ACTIVE-PARAGRAPH        
A04177        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
A04177        MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
A04177        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
A04177        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
A04177        MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
A04177        MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
A04177        MOVE WS-UTIL-TYPE              TO HOSTVAR-ELEMENT-1       
A04177        MOVE WS-RATE-PLAN              TO HOSTVAR-ELEMENT-2       
A04177        MOVE WS-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
A04177        MOVE WS-START-DATE             TO HOSTVAR-ELEMENT-4       
A04177        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A04177        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A04177     END-IF.                                                      
A04177                                                                  
A04177 2605-EXIT.                                                       
A04177     EXIT.                                                        
A04177                                                                  
      *****************************************************************         
      * 2610-OPEN-SPLFCTR-CURSOR                                      *         
      *****************************************************************         
       2610-OPEN-SPLFCTR-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN SPL_FACTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2610'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2620-FETCH-SPLFCTR-CURSOR                                      *        
      * FETCHES A ROW WHICH HAS A  FACTOR-ID AND CODE-UTIL-TYPE        *        
      * MATCHING THE NEW ROW AND CODE_STATUS ACTIVE                    *        
      ******************************************************************        
                                                                        
       2620-FETCH-SPLFCTR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH SPL_FACTOR_CRSR                                   
                 INTO :SA-RATE-PLAN-NO,                                 
                      :SA-DATE-FROM,                                    
                      :SA-DATE-TO,                                      
                      :SA-ENTRY-NO,                                     
                      :SA-LAST-UPDATE-TS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2620'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2630-CLOSE-SPLFCTR-CURSOR                                     *         
      *****************************************************************         
       2630-CLOSE-SPLFCTR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE SPL_FACTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2630'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETS THE ONE DAY BEFORE NEW START DATE                         *        
      ******************************************************************        
       2635-GET-PREV-DATE-TO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT (DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                     :WS-NEW-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-START-DATE
              ) <> 0) OR (LEN(:WS-NEW-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-START-DATE
              ), CONVERT(DATE, :WS-NEW-START-DATE) ) ))                
                 INTO :WS-NEW-START-DATE-1                              
                 FROM  CSS_MODEL_SQL                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*        SELECT (DATE(:WS-NEW-START-DATE) - 1 DAY)                06490002
MFA-TR*          INTO :WS-NEW-START-DATE-1                                      
MFA-TR*          FROM  CSS_MODEL_SQL                                    06500002
MFA-TR*                                                                 06680002
MFA-TR*    END-EXEC.                                                    06480002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2635'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MODEL_SQL'         TO TABLE-1                  
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-1          
               MOVE WS-NEW-START-DATE       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2635-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06416005
      * 2640-UPDATE-DATE-TO                                            *06420002
      *    -- THIS MODULE UPDATES THE ROW FETCHED FROM SPL_FACTOR_CRSR *06430002
      *       WITH THE NEW VALUE OF DATE_TO                            *06440002
      ******************************************************************06450002
       2640-UPDATE-DATE-TO.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_FCTR_APPL                                
                  SET  DATE_TO  = IIF(TRY_CONVERT(DATE, 
                                                      :WS-PREV-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-END-DATE
              ) <> 0) OR (LEN(:WS-PREV-END-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-END-DATE
              ), CONVERT(DATE, :WS-PREV-END-DATE) )                     
                      ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()               
                  WHERE CURRENT OF SPL_FACTOR_CRSR                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*        UPDATE CSS_SPCL_FCTR_APPL                                06490002
MFA-TR*           SET  DATE_TO  = :WS-PREV-END-DATE                     06500002
MFA-TR*               ,LAST_UPDATE_TS = CURRENT TIMESTAMP                       
MFA-TR*           WHERE CURRENT OF SPL_FACTOR_CRSR                              
MFA-TR*                                                                 06680002
MFA-TR*    END-EXEC.                                                    06480002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2640'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE SA-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE SA-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2        
               MOVE SA-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06416005
      * 2650-GET-MAX-ENTRY-NO                                          *06420002
      *    -- THIS MODULE GETS THE MAX ENTRY-NO FOR THE RATE-PLAN      *06430002
      *       FETCHED BY CURSOR  SPL_FACTOR_CRSR                       *06440002
      ******************************************************************06450002
       2650-GET-MAX-ENTRY-NO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT MAX(A.ENTRY_NO)                                   
                     ,MAX(A.DATE_TO)                                    
                 INTO :WS-MAX-ENTRY-NO :WS-ENTRY-NO-IND                  
                     ,:WS-MAX-DATE-TO :WS-DATE-TO-IND                    
                 FROM CSS_SPCL_FCTR_APPL A                              
                WHERE A.RATE_PLAN_NO      = :SA-RATE-PLAN-NO            
                  AND A.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE          
                  AND A.FACTOR_ID         = :SA-FACTOR-ID               
                  AND A.CMPNT_ID_CD       = :SA-CMPNT-ID-CD             
                  AND A.BLOCK_NO          = :SA-BLOCK-NO                
                  AND A.CODE_SEASON       = :SA-CODE-SEASON             
                  AND A.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD       
                  AND A.CODE_TIME_PERIOD  = :SA-CODE-TIME-PERIOD        
                  AND A.CODE_STATUS       = 'A'                         
                  AND A.DATE_TO = (SELECT MAX(B.DATE_TO)                
                           FROM  CSS_SPCL_FCTR_APPL B                   
                           WHERE B.RATE_PLAN_NO    = A.RATE_PLAN_NO     
                           AND B.CODE_UTIL_TYPE    = A.CODE_UTIL_TYPE   
                           AND B.FACTOR_ID         = A.FACTOR_ID        
                           AND B.CMPNT_ID_CD       = A.CMPNT_ID_CD      
                           AND B.CODE_STATUS       = A.CODE_STATUS      
                           AND B.BLOCK_NO          = A.BLOCK_NO         
                           AND B.CODE_SEASON       = A.CODE_SEASON      
                           AND B.INSTR_USE_TYPE_CD = A.INSTR_USE_TYPE_CD
                           AND B.CODE_TIME_PERIOD  = A.CODE_TIME_PERIOD 
                           AND B.DATE_TO > CAST(SYSDATETIMEOFFSET() 
           AS DATE))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*        SELECT MAX(A.ENTRY_NO)                                           
MFA-TR*              ,MAX(A.DATE_TO)                                            
MFA-TR*          INTO :WS-MAX-ENTRY-NO:WS-ENTRY-NO-IND                          
MFA-TR*              ,:WS-MAX-DATE-TO:WS-DATE-TO-IND                            
MFA-TR*          FROM CSS_SPCL_FCTR_APPL A                                      
MFA-TR*         WHERE A.RATE_PLAN_NO      = :SA-RATE-PLAN-NO                    
MFA-TR*           AND A.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE                  
MFA-TR*           AND A.FACTOR_ID         = :SA-FACTOR-ID                       
MFA-TR*           AND A.CMPNT_ID_CD       = :SA-CMPNT-ID-CD                     
MFA-TR*           AND A.BLOCK_NO          = :SA-BLOCK-NO                        
MFA-TR*           AND A.CODE_SEASON       = :SA-CODE-SEASON                     
MFA-TR*           AND A.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD               
MFA-TR*           AND A.CODE_TIME_PERIOD  = :SA-CODE-TIME-PERIOD                
MFA-TR*           AND A.CODE_STATUS       = 'A'                                 
MFA-TR*           AND A.DATE_TO = (SELECT MAX(B.DATE_TO)                        
MFA-TR*                    FROM  CSS_SPCL_FCTR_APPL B                           
MFA-TR*                    WHERE B.RATE_PLAN_NO    = A.RATE_PLAN_NO             
MFA-TR*                    AND B.CODE_UTIL_TYPE    = A.CODE_UTIL_TYPE           
MFA-TR*                    AND B.FACTOR_ID         = A.FACTOR_ID                
MFA-TR*                    AND B.CMPNT_ID_CD       = A.CMPNT_ID_CD              
MFA-TR*                    AND B.CODE_STATUS       = A.CODE_STATUS              
MFA-TR*                    AND B.BLOCK_NO          = A.BLOCK_NO                 
MFA-TR*                    AND B.CODE_SEASON       = A.CODE_SEASON              
MFA-TR*                    AND B.INSTR_USE_TYPE_CD = A.INSTR_USE_TYPE_CD        
MFA-TR*                    AND B.CODE_TIME_PERIOD  = A.CODE_TIME_PERIOD         
MFA-TR*                    AND B.DATE_TO > CURRENT DATE)                06680002
MFA-TR*    END-EXEC.                                                    06480002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-ENTRY-NO-IND = NULL-VALUE                         
                   MOVE 0                   TO WS-MAX-ENTRY-NO          
                   MOVE SPACES              TO WS-MAX-DATE-TO           
               END-IF                                                   
           ELSE                                                         
                IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 0                    TO WS-MAX-ENTRY-NO        
                    MOVE SPACES               TO WS-MAX-DATE-TO         
                ELSE                                                    
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '2650'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT '            TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
                    MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1        
                    MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2        
                    MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-3        
                    MOVE SA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1      
                    MOVE SA-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2      
                    MOVE SA-FACTOR-ID         TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                END-IF                                                  
           END-IF.                                                      
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06893802
      * 2660 UPDATE FACTOR                                             *06893902
      *    -- THIS MODULE UPDATES A FACTOR VALUE FOR ALL RATES INFO.   *06894002
      *       IN THE CSS_SPCL_FCTR_APPL TABLE, WHEN PARM-FCTR-UPDATE-FL*06895002
      *       EQUALS TO "Y" AND PARM-CJG-INDICATOR EQUALS TO "Y".      *06896002
      ******************************************************************06896002
       2660-UPDATE-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_FCTR_APPL                                
                  SET  FACTOR             = :WS-FACTOR-DEC,             
                       USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY          
                      ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()               
                WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND            
                       CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               
                       RATE_PLAN_NO   = :WS-RATE-PLAN AND               
                       FACTOR_ID      = :WS-FACTOR-ID AND               
                       DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                  
                   AND BLOCK_NO       = :WS-BLOCK-NO                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06899002
MFA-TR*        UPDATE CSS_SPCL_FCTR_APPL                                06899102
MFA-TR*           SET  FACTOR             = :WS-FACTOR-DEC,             06899202
MFA-TR*                USER_ID_UPD_BY     = :WS-USER-ID-UPD-BY          06900402
MFA-TR*               ,LAST_UPDATE_TS = CURRENT TIMESTAMP                       
MFA-TR*         WHERE  ENTRY_NO       = :WS-ENTRY-NO-INT AND            06900502
MFA-TR*                CODE_UTIL_TYPE = :WS-UTIL-TYPE AND               06900602
MFA-TR*                RATE_PLAN_NO   = :WS-RATE-PLAN AND               06900702
MFA-TR*                FACTOR_ID      = :WS-FACTOR-ID AND               06900802
MFA-TR*                DATE_FROM      = :WS-START-DATE                  06900902
MFA-TR*            AND BLOCK_NO       = :WS-BLOCK-NO                            
MFA-TR*                                                                 06901002
MFA-TR*    END-EXEC.                                                    06901102

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2660'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-3          
               MOVE 'DATE_FROM'             TO TABLE-ELEMENT-4          
               MOVE WS-UTIL-TYPE            TO HOSTVAR-ELEMENT-1        
               MOVE WS-RATE-PLAN            TO HOSTVAR-ELEMENT-2        
               MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-3        
               MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2660-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06920001
      * 2700 DELETE ROW                                                *06930001
      *    -- THIS MODULE DELETES A ROW OF FACTOR USE INFORMATION      *06940001
      *       FROM THE CSS_SPCL_FCTR_APPL TABLE.                       *06950001
      ******************************************************************06960001
       2700-DELETE-ROW.                                                 
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_SPCL_FCTR_APPL                           
                WHERE ENTRY_NO       = :WS-ENTRY-NO-INT                 
                  AND CODE_UTIL_TYPE = :WS-UTIL-TYPE                    
                  AND RATE_PLAN_NO   = :WS-RATE-PLAN                    
                  AND FACTOR_ID      = :WS-FACTOR-ID                    
                  AND DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )                   
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06990001
MFA-TR*        DELETE FROM CSS_SPCL_FCTR_APPL                           07000001
MFA-TR*         WHERE ENTRY_NO       = :WS-ENTRY-NO-INT                 07010001
MFA-TR*           AND CODE_UTIL_TYPE = :WS-UTIL-TYPE                            
MFA-TR*           AND RATE_PLAN_NO   = :WS-RATE-PLAN                            
MFA-TR*           AND FACTOR_ID      = :WS-FACTOR-ID                            
MFA-TR*           AND DATE_FROM      = :WS-START-DATE                           
MFA-TR*                                                                 07020001
MFA-TR*    END-EXEC.                                                    07030001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SPCL_FCTR_APPL'    TO TABLE-1                  
               MOVE 'ENTRY_NO'              TO TABLE-ELEMENT-1          
               MOVE WS-ENTRY-NO-INT         TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177******************************************************************06920001
A04177* 2704 CHK ROW EXIST IN  BUSINESS PROCESS REQUEST.               *06930001
A04177******************************************************************06960001
A04177 2704-CHK-ROW-EXIST.                                              
A04177                                                                  
A04177     EXEC SQL                                                     
A04177         SELECT TOP(1) 'Y'                                               
A04177           INTO :WS-ROW-EXIST                                     
A04177           FROM CSS_PROCESS_REQ WITH(READUNCOMMITTED)                     
A04177          WHERE PROC_REQ_ID    = :SA-PROC-REQ-ID                  
A04177                                              
A04177                                                           
A04177                                                      
A04177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06990001
MFA-TR*        SELECT 'Y'                                               07000001
MFA-TR*          INTO :WS-ROW-EXIST                                             
MFA-TR*          FROM CSS_PROCESS_REQ                                           
MFA-TR*         WHERE PROC_REQ_ID    = :SA-PROC-REQ-ID                  07010001
MFA-TR*         FETCH FIRST ROW ONLY                                    07020001
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 2704                                                      
MFA-TR*    END-EXEC.                                                    07030001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04177                                                                  
A04177     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04177         NEXT SENTENCE                                            
A04177     ELSE                                                         
A04177         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04177         MOVE '2704'                  TO ACTIVE-PARAGRAPH         
A04177         MOVE 'SELECT'                TO ABEND-FUNCTION           
A04177         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
A04177                                         ABEND-TABLES             
A04177         MOVE 'CSS_PROCESS_REQ'       TO TABLE-1                  
A04177         MOVE 'PROCESS_REQ_ID'        TO TABLE-ELEMENT-1          
A04177         MOVE SA-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1        
A04177         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A04177         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A04177     END-IF.                                                      
A04177                                                                  
A04177 2704-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
      ******************************************************************06920001
      * 2705 GET COUNT OF BUSINESS PROCESS REQUEST                     *06930001
      *    -- THIS MODULE COUNTS NUMBER OF BUSINESS PROCESS REQUESTS   *06940001
      *       ASSOCIATED WITH THE CSS_SPCL_FCTR_APPL ROW.              *06950001
      *       FLAG IS SET AND RETURNED SO APPLICATION KNOWS WHETHER TO *        
      *       DELETE THE CORRESPONDING BUSINESS PROCESS REQUEST.       *        
      ******************************************************************06960001
       2705-GET-BPR-COUNT.                                              
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-BPR-COUNT                                     
                 FROM CSS_SPCL_FCTR_APPL                                
                WHERE PROC_REQ_ID    = :SA-PROC-REQ-ID                  
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '2695'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_PROCESS_REQ'       TO TABLE-1                  
               MOVE 'PROCESS_REQ_ID'        TO TABLE-ELEMENT-1          
               MOVE 1P-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2705-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2710-OPEN-TRNFCTR-CURSOR                                      *         
      *****************************************************************         
       2710-OPEN-TRNFCTR-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN TRN_FACTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2710'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2720-FETCH-TRNFCTR-CURSOR                                      *        
      * FETCHES A ROW WHICH HAS A  FACTOR-ID AND CODE-UTIL-TYPE        *        
      * MATCHING THE NEW ROW AND CODE_STATUS ACTIVE                    *        
      ******************************************************************        
                                                                        
       2720-FETCH-TRNFCTR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH TRN_FACTOR_CRSR                                   
                 INTO :SA-RATE-PLAN-NO,                                 
                      :SA-DATE-FROM,                                    
                      :SA-DATE-TO,                                      
                      :SA-ENTRY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2720'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2720-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2730-CLOSE-TRNFCTR-CURSOR                                     *         
      *****************************************************************         
       2730-CLOSE-TRNFCTR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE TRN_FACTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2730'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-UTIL-TYPE             TO HOSTVAR-ELEMENT-1        
              MOVE WS-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06416005
      * 2740-GET-MAX-DATE-TO                                           *06420002
      *    -- THIS MODULE GETS THE MAX DATE-TO  FOR THE RATE-PLAN      *06430002
      *       INSERTED IN THE PANEL FOR TRANSCO CURSOT FOR TRN_FCTR_CRSR06440002
      ******************************************************************06450002
       2740-GET-MAX-DATE-TO.                                            
                                                                        
           EXEC SQL                                                     
               SELECT MAX(DATE_TO)                                      
                 INTO :WS-MAX-DATE-TO                                   
                 FROM CSS_SPCL_FCTR_APPL                                
                WHERE RATE_PLAN_NO   = :PARM-RATE-PLAN    AND           
                      CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE AND           
                      FACTOR_ID      = :SA-FACTOR-ID      AND           
                      CMPNT_ID_CD    = :SA-CMPNT-ID-CD    AND           
                      BLOCK_NO       = :SA-BLOCK-NO       AND           
                      CODE_STATUS    IN ('A', 'E')                      
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
                IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    CONTINUE                                            
                ELSE                                                    
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '2740'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT '            TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
                    MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1        
                    MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2        
                    MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-3        
                    MOVE SA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1      
                    MOVE SA-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2      
                    MOVE SA-FACTOR-ID         TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                END-IF.                                                 
                                                                        
       2740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06416005
      * 2750-GET-MAX-ENTRY-NO                                          *06420002
      *    -- THIS MODULE GETS THE MAX ENTRY-NO FOR THE RATE-PLAN      *06430002
      *       FETCHED BY CURSOR  TRN_FACTOR_CRSR                       *06440002
      ******************************************************************06450002
       2750-GET-MAX-ENTRY-NO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT MAX(ENTRY_NO)                                     
                 INTO :WS-MAX-ENTRY-NO :WS-ENTRY-NO-IND                  
                 FROM CSS_SPCL_FCTR_APPL                                
                WHERE RATE_PLAN_NO   = :SA-RATE-PLAN-NO   AND           
                      CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE AND           
                      FACTOR_ID      = :SA-FACTOR-ID      AND           
                      CMPNT_ID_CD    = :SA-CMPNT-ID-CD    AND           
                      BLOCK_NO       = :SA-BLOCK-NO       AND           
                      CODE_STATUS    IN ( 'A', 'E')                     
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-ENTRY-NO-IND = NULL-VALUE                         
                   MOVE 0                   TO WS-MAX-ENTRY-NO          
               END-IF                                                   
           ELSE                                                         
                IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 0                    TO WS-MAX-ENTRY-NO        
                ELSE                                                    
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '2750'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT '            TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
                    MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1        
                    MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2        
                    MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-3        
                    MOVE SA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1      
                    MOVE SA-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2      
                    MOVE SA-FACTOR-ID         TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                END-IF                                                  
           END-IF.                                                      
                                                                        
       2750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06416005
      * 2800-VALIDATE-BLOCK-NO                                         *06420002
      ******************************************************************06450002
       2800-VALIDATE-BLOCK-NO.                                          
                                                                        
                                                                        
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE ZERO                        TO WS-DATABASE.             
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
                                                                        
           PERFORM 7025-GET-DELINQUENCY-VALUE    THRU 7025-EXIT.        
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
           MOVE WS-UTIL-TYPE                TO PS-CODE-UTIL-TYPE        
                                               RD-CODE-UTIL-TYPE.       
           MOVE WS-RATE-PLAN                TO PS-RATE-PLAN-NO          
                                               RD-RATE-PLAN-NO.         
                                                                        
           MOVE 'N'                           TO RD-SECURED-RATE-FL     
                                                                        
           PERFORM 7075-GET-SECURED-RATE-FL      THRU 7075-EXIT.        
                                                                        
           MOVE ZERO                        TO WS-BLOCK-NULL-ID.        
                                                                        
           PERFORM 7000-GET-ALLOWED-BLOCK-NO  THRU 7000-EXIT.           
                                                                        
           IF (WS-BLOCK-NO > PS-BLOCK-NO OR                             
              ( PS-BLOCK-NO = 1 AND WS-BLOCK-NO NOT = 0 )) AND          
              (NOT (CSR-DATABASE  AND RD-SECURED-RATE-FL = 'Y'))        
              MOVE 100                     TO S-RETURN-CODE             
              MOVE 251                     TO S-APPL-RETURN-CODE        
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06416005
      * 7000-GET-ALLOWED-BLOCK-NO                                      *06420002
      *    -- THIS MODULE GETS THE BLOCK NO FOR THE GIVE RATE PLAN NO  *06430002
      *       AND CODE UTIL TYPE                                       *06440002
      ******************************************************************06450002
       7000-GET-ALLOWED-BLOCK-NO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(BLOCK_NO)                                     
                 INTO :PS-BLOCK-NO :WS-BLOCK-NULL-ID                     
                 FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                  
                WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO          
                  AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE        
                  AND PS.VERSION_NO_CNTRL = (                           
                      SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE         
                         AND RATE_PLAN_NO   = PS.RATE_PLAN_NO           
                         AND CODE_STATUS    IN ( 'A', 'T'))             
                                                    
                                                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06480002
MFA-TR*        SELECT MAX(BLOCK_NO)                                             
MFA-TR*          INTO :PS-BLOCK-NO:WS-BLOCK-NULL-ID                             
MFA-TR*          FROM CSS_PRICE_SCHED PS                                        
MFA-TR*         WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                  
MFA-TR*           AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                
MFA-TR*           AND PS.VERSION_NO_CNTRL = (                                   
MFA-TR*               SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR                                   
MFA-TR*                WHERE CODE_UTIL_TYPE = PS.CODE_UTIL_TYPE                 
MFA-TR*                  AND RATE_PLAN_NO   = PS.RATE_PLAN_NO                   
MFA-TR*                  AND CODE_STATUS    IN ( 'A', 'T'))                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*                                                                 06680002
MFA-TR*    END-EXEC.                                                    06480002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                  
                  WS-BLOCK-NULL-ID = -1                                 
                  MOVE ZERO                 TO PS-BLOCK-NO              
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_PRICE_SCHED'       TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'RATE_PLAN_NO'          TO TABLE-ELEMENT-2          
               MOVE 'BLOCK_NO'              TO TABLE-ELEMENT-3          
               MOVE PS-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE PS-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2        
               MOVE PS-BLOCK-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17920000
      *   ARE WE IN SEB OR CSR?                                        *17930000
      ******************************************************************17940000
                                                                        
       7025-GET-DELINQUENCY-VALUE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT DELINQ_VALUE                                       17970000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   17980000
MFA-TR*         FROM CSS_DELINQUENCY C8                                 17990000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         18000000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        18010000
MFA-TR*         WITH UR                                                 18011000
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSR04519'               TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DATABASE'               TO TABLE-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17920000
      *   MAKE SURE PROC-REQ-ID EXISTS.                                *17930000
      ******************************************************************17940000
       7050-CHECK-PROCESS-REQ-EXISTS.                                   
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-PROCESS-REQ-EXISTS-FL                            
              FROM CSS_PROCESS_REQ WITH(READUNCOMMITTED)                        
              WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-PROCESS-REQ-EXISTS-FL                                    
MFA-TR*       FROM CSS_PROCESS_REQ                                              
MFA-TR*       WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSR04519'               TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROC_REQ_ID'        TO TABLE-1                  
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1          
              MOVE 1P-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17920000
      *   GETTING SECURED_RATE_FL FROM RD TABLE.                       *17930000
      ******************************************************************17940000
                                                                        
       7075-GET-SECURED-RATE-FL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT SECURED_RATE_FL                                    
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                
                 AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT SECURED_RATE_FL                                    17970000
MFA-TR*         INTO :RD-SECURED-RATE-FL                                17980000
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                              17990000
MFA-TR*        WHERE CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                18000000
MFA-TR*          AND RATE_PLAN_NO   = :RD-RATE-PLAN-NO                  18010000
MFA-TR*         WITH UR                                                 18011000
MFA-TR*      QUERYNO 7075                                                       
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSR04519'               TO ABEND-PROGRAM            
              MOVE '7075'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE RD-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ473*****************************************************************         
PRJ473* 7100-OPEN-SPCL-FCTR-APPL.                                     *         
PRJ473*****************************************************************         
PRJ473 7100-OPEN-SPCL-FCTR-APPL.                                        
PRJ473                                                                  
PRJ473     EXEC SQL                                                     
PRJ473         OPEN SPCL_FCTR_APPL_CUR                                  
PRJ473     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ473                                                                  
PRJ473     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ473                                                                  
PRJ473     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ473        NEXT SENTENCE                                             
PRJ473     ELSE                                                         
PRJ473        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
PRJ473        MOVE '7100'                   TO ACTIVE-PARAGRAPH         
PRJ473        MOVE 'OPEN'                   TO ABEND-FUNCTION           
PRJ473        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
PRJ473                                         ABEND-TABLES             
PRJ473        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
PRJ473        MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1          
PRJ473        MOVE SA-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
PRJ473        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ473        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ473     END-IF.                                                      
PRJ473                                                                  
PRJ473 7100-EXIT.                                                       
PRJ473     EXIT.                                                        
PRJ473                                                                  
PRJ473******************************************************************        
PRJ473* 7200-FETCH-SPCL-FCTR-APPL.                                     *        
PRJ473******************************************************************        
PRJ473                                                                  
PRJ473 7200-FETCH-SPCL-FCTR-APPL.                                       
PRJ473                                                                  
PRJ473     EXEC SQL                                                     
PRJ473          FETCH SPCL_FCTR_APPL_CUR                                
PRJ473           INTO :SA-CODE-UTIL-TYPE                                
PRJ473               ,:SA-RATE-PLAN-NO                                  
PRJ473               ,:SA-FACTOR-ID                                     
PRJ473               ,:SA-DATE-FROM                                     
PRJ473               ,:SA-DATE-TO                                       
PRJ473               ,:SA-ENTRY-NO                                      
A04177               ,:SA-BLOCK-NO                                      
A04177               ,:SA-CMPNT-ID-CD                                   
A04177               ,:SA-CODE-SEASON                                   
A04177               ,:SA-INSTR-USE-TYPE-CD                             
A04177               ,:SA-CODE-TIME-PERIOD                              
A04177               ,:SA-CODE-STATUS                                   
A04221               ,:SA-INT-DISP-START-TS                             
PRJ473     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ473                                                                  
PRJ473     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ473                                                                  
PRJ473     EVALUATE WS-ACTIVE-RETURN-CODE                               
PRJ473         WHEN SUCCESSFUL-CALL                                     
PRJ473              MOVE 'Y'                TO WS-ROW-STATUS            
PRJ473         WHEN NOT-FOUND                                           
PRJ473              MOVE 'Y'                TO WS-NO-MORE-ROWS          
PRJ473         WHEN OTHER                                               
PRJ473              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
PRJ473              MOVE '7200'             TO ACTIVE-PARAGRAPH         
PRJ473              MOVE 'FETCH'            TO ABEND-FUNCTION           
PRJ473              MOVE SPACES             TO ABEND-SQL-PREDICATES     
PRJ473                                         ABEND-TABLES             
PRJ473              MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                
PRJ473              MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-1          
PRJ473              MOVE SA-PROC-REQ-ID     TO HOSTVAR-ELEMENT-1        
PRJ473              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
PRJ473              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
PRJ473     END-EVALUATE.                                                
PRJ473                                                                  
PRJ473 7200-EXIT.                                                       
PRJ473     EXIT.                                                        
PRJ473                                                                  
PRJ473*****************************************************************         
PRJ473* 7300-CLOSE-SPCL-FCTR-APPL.                                    *         
PRJ473*****************************************************************         
PRJ473 7300-CLOSE-SPCL-FCTR-APPL.                                       
PRJ473                                                                  
PRJ473     EXEC SQL                                                     
PRJ473        CLOSE SPCL_FCTR_APPL_CUR                                  
PRJ473     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ473                                                                  
PRJ473     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ473                                                                  
PRJ473     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ473        NEXT SENTENCE                                             
PRJ473     ELSE                                                         
PRJ473        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
PRJ473        MOVE '7300'                   TO ACTIVE-PARAGRAPH         
PRJ473        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
PRJ473        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
PRJ473                                         ABEND-TABLES             
PRJ473        MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
PRJ473        MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1          
PRJ473        MOVE SA-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
PRJ473        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PRJ473        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PRJ473     END-IF.                                                      
PRJ473                                                                  
PRJ473 7300-EXIT.                                                       
PRJ473     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE '8000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04519_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04519_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04519_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04519_R1                       
                  (    RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,ENTRY_NO                                         
                      ,DELETE_BPR                                       
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-ENTRY-NO                                         
                   ,:S-DELETE-BPR                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04519_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,ENTRY_NO                                                 
MFA-TR*               ,DELETE_BPR                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-ENTRY-NO                                                 
MFA-TR*            ,:S-DELETE-BPR                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-APPL-RETURN-CODE           
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04519_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
