       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04518.                                     
       DATE-WRITTEN.  10/30/2011.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE ENTRY/RPM DASHBOARD AND     *        
      *  STATUS UPDATE SCREENS                                         *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : DEVELOP-RMM-FACTOR-GETSPCLFCTRAP                  *        
      *  INPUT     : APPL_PROG_ID         CHAR(03)                     *        
      *              USER_ID              CHAR(07)                     *        
      *              FACTOR_ID            CHAR(09)                     *        
      *              CODE_UTIL_TYPE       CHAR(01)                     *        
      *              BEGIN_DATE           CHAR(10)                     *        
      *              END_DATE             CHAR(10)                     *        
      *              RATE_PLAN_NO         CHAR(03)                     *        
      *              CODE_STATUS          CHAR(01)                     *        
      *              PROC_REQ_ID          CHAR(10)                     *        
      *              MAX_DATE_FL          CHAR(01)                     *        
      *              EXCLUDE_RATE_FCTR_FL CHAR(01)                     *        
      *              RATE_DEPT_CD         CHAR(03)                     *        
      *  OUTPUT    : RETURN_CODE       INTEGER                         *        
      *              APPL_RETURN_CODE  INTEGER                         *        
      *              PROC_FLOW_IND     CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              PROC_STATUS_CD    CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_TS        CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_USERID    CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_COMMENTS  CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              CATEGORY_ID       CSS_PROCESS_REQ_CH TABLE DEF    *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED.              *        
P00473*  05/24/12  AW41078    ADDING EXCLUDE_RATE_FCTR_FL AND          *        
P00473*                       RATE_DEPT_CD PARAMETERS                  *        
P00473*  06/06/12  AW41078    MODIFIED RESULT SET SORT ORDER           *        
P00473*  06/29/12  AW41078    ADDED FCTR-UPDATE-FL TO RESULT SET       *        
P00473*  11/13/12  AW41078    CORRECT ISSUE WITH MAX DATE FLAG NOT     *        
P00473*                       RETURNING CORRECT RESULTS                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  +400    ADDRESS WAS FOUND BY FINALIST AND IT MATCHED EXACTLY  *        
      *          WITH THE ENTERED ADDRESS                              *        
      *  +300    ADDRESS WAS NOT FOUND BY FINALIST                     *        
      *  +200    ADDRESS WAS FOUND BY FINALIST BUT IT DID NOT EXACTLY  *        
      *          MATCH THE ENTERED ADDRESS                             *        
      *  ANY -   ERROR                                                 *        
      *   0      FINALIST WAS NOT CALLED                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04518'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4518 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04518'.      
                                                                        
       01  WS-NULL-IND1                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND2                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND3                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND4                PIC S9(4) COMP VALUE 0.          
       01  WS-ALLOW-UPDATE             PIC X(01) VALUE 'N'.             
       01  WS-BLOCK-NULL-ID            PIC S9(4) COMP VALUE 0.          
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
           05  S-APPL-RETURN-CODE       PIC S9(09) COMP VALUE +0.       
           05  S-FACTOR-ID              PIC X(09) VALUE SPACES.         
           05  S-CODE-UTIL-TYPE         PIC X(01)  VALUE SPACES.        
           05  S-RATE-PLAN-NO           PIC X(03)  VALUE SPACES.        
           05  S-CODE-TIME-PERIOD       PIC S9(04) COMP VALUE 0.        
           05  S-CODE-REVENUE-CLASS     PIC X(03)  VALUE SPACES.        
           05  S-START-DATE             PIC X(10)  VALUE SPACES.        
           05  S-END-DATE               PIC X(10)  VALUE SPACES.        
           05  S-FACTOR                 PIC S999V999999 USAGE COMP-3    
                                                   VALUE 0.             
           05  S-CODE-STATUS            PIC X(01)  VALUE SPACES.        
           05  S-ENTRY-NO               PIC S9(04) COMP VALUE 0.        
           05  S-BLOCK-NO               PIC S9(04) COMP VALUE 0.        
           05  S-VERS-PRORATE-CD        PIC X(01) VALUE SPACES.         
           05  S-USER-ID-UPD-BY         PIC X(07)  VALUE SPACES.        
           05  S-LAST-UPDATE-TS         PIC X(26)  VALUE SPACES.        
           05  S-INT-DISP-START-TS      PIC X(26)  VALUE SPACES.        
           05  S-INT-DISP-END-TS        PIC X(26)  VALUE SPACES.        
           05  S-EXT-DISP-START-TS      PIC X(26)  VALUE SPACES.        
           05  S-EXT-DISP-END-TS        PIC X(26)  VALUE SPACES.        
           05  S-ALLOW-UPDATE           PIC X(01)  VALUE SPACES.        
           05  S-PROC-REQ-ID            PIC S9(10)V COMP-3 VALUE +0.    
           05  S-FCTR-UPDATE-FL         PIC X(01)  VALUE SPACES.        
                                                                        
       01  RS-RATE-COMPONENT.                                           
           05  RS-CMPNT-ID-CD           PIC X(02)  VALUE SPACES.        
           05  RS-CODE-SEASON           PIC X(01)  VALUE SPACES.        
           05  RS-INSTR-USE-TYPE-CD     PIC X(01)  VALUE SPACES.        
           05  RS-CODE-TIME-PERIOD-3    PIC X(04)  VALUE SPACES.        
      *                                                                 02556000
       01  S-RATE-COMPONENT             PIC X(08)  VALUE SPACES.        
      *                                                                 02556000
       01  RS-REDEFINITIONS.                                            
           05  RS-CODE-TIME-PERIOD-1    PIC 9(04)  VALUE 0.             
           05  RS-CODE-TIME-PERIOD-2 REDEFINES RS-CODE-TIME-PERIOD-1    
                                        PIC X(04).                      
      *                                                                 02556000
       01  TEMP-DATE-REFORMAT.                                          
           05  TEMP-MONTH               PIC X(02).                      
           05  FILLER                   PIC X(01).                      
           05  TEMP-DAY                 PIC X(02).                      
           05  FILLER                   PIC X(01).                      
           05  TEMP-YEAR                PIC X(04).                      
      *                                                                 02559400
       01  START-DATE-REFORMAT.                                         
           05  START-MONTH              PIC X(02).                      
           05  WS-FILLER-1              PIC X(1) VALUE '/'.             
           05  START-DAY                PIC X(02).                      
           05  WS-FILLER-2              PIC X(1) VALUE '/'.             
           05  START-YEAR               PIC X(04).                      
      *                                                                 02559900
       01  END-DATE-REFORMAT.                                           
           05  END-MONTH                PIC X(02).                      
           05  WS-FILLER-3              PIC X(1) VALUE '/'.             
           05  END-DAY                  PIC X(02).                      
           05  WS-FILLER-4              PIC X(1) VALUE '/'.             
           05  END-YEAR                 PIC X(04).                      
      *                                                                 02559400
       01  DUMMY-DATE-FORMAT.                                           
           05 DUMMY-DATE                PIC X(10).                      
      *                                                                 02559400
       01  WS-STORAGE-FIELDS.                                           
           05  WS-FACTOR-ID            PIC X(09) VALUE SPACES.          
           05  WS-BLOCK-NO             PIC S9(04) COMP VALUE 0.         
           05  WS-UPDT-FACT-ID         PIC X(21) VALUE                  
                                   'UPDATEABLE FACTOR-ID='.             
           05  WS-PARM-DATA            PIC X(80) VALUE SPACES.          
           05  WS-PARM-DATA-RED   REDEFINES WS-PARM-DATA.               
               10 WS-PARM-DESC         PIC X(21).                       
               10 WS-PARM-FACT-ID      PIC X(09).                       
               10 FILLER               PIC X(50).                       
           05  WS-CMND-CODE            PIC X(04) VALUE 'PARM'.          
           05  WS-PRGM-NAME            PIC X(10) VALUE 'CSR04518'.      
           05  WS-PANEL-NO             PIC X(10) VALUE 'PANEL397'.      
           05  WS-DATE-FLTR            PIC X(01) VALUE 'N'.             
           05  WS-RTPL-FLTR            PIC X(01) VALUE 'N'.             
           05  WS-CDST-FLTR            PIC X(01) VALUE 'N'.             
           05  WS-FCTR-FLTR            PIC X(01) VALUE 'N'.             
           05  WS-PRID-FLTR            PIC X(01) VALUE 'N'.             
           05  WS-MAX-DATE-FLTR        PIC X(01) VALUE 'N'.             
           05  WS-EX-RATE-FCTR-FLTR    PIC X(01) VALUE 'N'.             
           05  WS-RATE-DEPT-FLTR       PIC X(03) VALUE 'N'.             
           05  WS-CODE-UTIL-TYPE       PIC X(01).                       
           05  WS-BEGIN-DATE           PIC X(10).                       
           05  WS-END-DATE             PIC X(10).                       
           05  WS-CODE-STATUS          PIC X(01).                       
           05  WS-RATE-PLAN-NO         PIC X(03).                       
           05  WS-RATE-DEPT-CD         PIC X(03).                       
           05  WS-PROC-REQ-ID          PIC S9(10)V COMP-3 VALUE +0.     
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      * CURSOR TO FETCH DETAILS USING FACTOR ID                         03984000
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE FACTORCURSOR CURSOR FOR                          
                  SELECT SA1.CODE_UTIL_TYPE,                            
                         SA1.RATE_PLAN_NO,                              
                         SA1.CMPNT_ID_CD,                               
                         SA1.BLOCK_NO,                                  
                         SA1.VERS_PRORATE_CD,                           
                         SA1.CODE_SEASON,                               
                         SA1.INSTR_USE_TYPE_CD,                         
                         SA1.CODE_TIME_PERIOD,                          
                         SA1.CODE_REVENUE_CLASS,                        
                         CIS.CHAR2$DATE(SA1.DATE_FROM, 'USA'),                  
                         CIS.CHAR2$DATE(SA1.DATE_TO, 'USA'),                    
                         SA1.FACTOR,                                    
                         SA1.CODE_STATUS,                               
                         SA1.ENTRY_NO,                                  
                         SA1.USER_ID_UPD_BY,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                            
                         SA1.DATE_FROM,                                 
                         SA1.DATE_TO,                                   
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_END_TS,                           
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_END_TS,                           
                         SA1.FACTOR_ID,                                 
                         SA1.PROC_REQ_ID                                
                    FROM CSS_SPCL_FCTR_APPL SA1 WITH(READUNCOMMITTED)           
                        ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                 
                        ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)            
                   WHERE SA1.FACTOR_ID      =  :WS-FACTOR-ID            
                     AND SA1.CODE_UTIL_TYPE =  :WS-CODE-UTIL-TYPE       
                     AND SA1.FACTOR_ID      =  SF.FACTOR_ID             
                     AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO           
                     AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE         
                     AND (   :WS-DATE-FLTR  = 'N' OR                    
                          (  :WS-DATE-FLTR  = 'Y'                       
                          AND SA1.DATE_FROM      >= 
              IIF(TRY_CONVERT(DATE, :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )      
                          AND SA1.DATE_TO        <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))     
                     AND (   :WS-CDST-FLTR  = 'N' OR                    
                          (  :WS-CDST-FLTR  = 'Y'                       
                          AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-RTPL-FLTR  = 'N' OR                    
                          (  :WS-RTPL-FLTR  = 'Y'                       
                          AND SA1.RATE_PLAN_NO = :WS-RATE-PLAN-NO))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF.FACTOR_TYPE <> 'A'))                   
                     AND (   :WS-RATE-DEPT-FLTR = 'N' OR                
                          (  :WS-RATE-DEPT-FLTR = 'Y'                   
                          AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))      
                     AND (   :WS-MAX-DATE-FLTR = 'N' OR                 
                          (  :WS-MAX-DATE-FLTR = 'Y'                    
                          AND SA1.DATE_FROM =                           
                  (SELECT MAX(SA2.DATE_FROM)                            
                    FROM CSS_SPCL_FCTR_APPL SA2 WITH(READUNCOMMITTED)           
                         ,CSS_SPCL_FCTR SF2 WITH(READUNCOMMITTED)               
                         ,CSS_RATE_PLAN_DESC RD2 WITH(READUNCOMMITTED)          
                   WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE     
                     AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO       
                     AND SA2.FACTOR_ID         = SA1.FACTOR_ID          
                     AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD        
                     AND SA2.BLOCK_NO          = SA1.BLOCK_NO           
                     AND SA2.CODE_SEASON       = SA1.CODE_SEASON        
                     AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD  
                     AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD   
                     AND SA2.FACTOR_ID         = SF2.FACTOR_ID          
                     AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO       
                     AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE     
                     AND (   :WS-DATE-FLTR  = 'N' OR                    
                          (  :WS-DATE-FLTR  = 'Y'                       
                          AND SA2.DATE_FROM      >= 
              IIF(TRY_CONVERT(DATE, :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )      
                          AND SA2.DATE_TO        <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))     
                     AND (   :WS-CDST-FLTR  = 'N' OR                    
                          (  :WS-CDST-FLTR  = 'Y'                       
                          AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-RTPL-FLTR  = 'N' OR                    
                          (  :WS-RTPL-FLTR  = 'Y'                       
                          AND SA2.RATE_PLAN_NO = :WS-RATE-PLAN-NO))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF2.FACTOR_TYPE <> 'A'))                  
                     AND (   :WS-RATE-DEPT-FLTR = 'N' OR                
                          (  :WS-RATE-DEPT-FLTR = 'Y'                   
                          AND RD2.RATE_DEPT_CD = :WS-RATE-DEPT-CD)))))  
                   ORDER BY SA1.FACTOR_ID,                              
                            SA1.CODE_UTIL_TYPE,                         
                            SA1.RATE_PLAN_NO,                           
                            SA1.DATE_FROM DESC,                         
                            SA1.CODE_STATUS                             
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03985000
MFA-TR*        DECLARE FACTORCURSOR CURSOR FOR                          03986000
MFA-TR*           SELECT SA1.CODE_UTIL_TYPE,                            03987000
MFA-TR*                  SA1.RATE_PLAN_NO,                              03988000
MFA-TR*                  SA1.CMPNT_ID_CD,                               03989000
MFA-TR*                  SA1.BLOCK_NO,                                          
MFA-TR*                  SA1.VERS_PRORATE_CD,                                   
MFA-TR*                  SA1.CODE_SEASON,                               03989100
MFA-TR*                  SA1.INSTR_USE_TYPE_CD,                         03989200
MFA-TR*                  SA1.CODE_TIME_PERIOD,                          03989300
MFA-TR*                  SA1.CODE_REVENUE_CLASS,                        03989400
MFA-TR*                  CHAR(SA1.DATE_FROM, USA),                      03989500
MFA-TR*                  CHAR(SA1.DATE_TO, USA),                        03989600
MFA-TR*                  SA1.FACTOR,                                    03989700
MFA-TR*                  SA1.CODE_STATUS,                               03989800
MFA-TR*                  SA1.ENTRY_NO,                                  03989900
MFA-TR*                  SA1.USER_ID_UPD_BY,                            03990000
MFA-TR*                  SA1.LAST_UPDATE_TS,                                    
MFA-TR*                  SA1.DATE_FROM,                                 03990100
MFA-TR*                  SA1.DATE_TO,                                   03990200
MFA-TR*                  SA1.INT_DISP_START_TS,                                 
MFA-TR*                  SA1.INT_DISP_END_TS,                                   
MFA-TR*                  SA1.EXT_DISP_START_TS,                                 
MFA-TR*                  SA1.EXT_DISP_END_TS,                                   
MFA-TR*                  SA1.FACTOR_ID,                                         
MFA-TR*                  SA1.PROC_REQ_ID                                        
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA1                         03990300
MFA-TR*                 ,CSS_SPCL_FCTR SF                                       
MFA-TR*                 ,CSS_RATE_PLAN_DESC RD                                  
MFA-TR*            WHERE SA1.FACTOR_ID      =  :WS-FACTOR-ID            03990400
MFA-TR*              AND SA1.CODE_UTIL_TYPE =  :WS-CODE-UTIL-TYPE               
MFA-TR*              AND SA1.FACTOR_ID      =  SF.FACTOR_ID                     
MFA-TR*              AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO                   
MFA-TR*              AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                 
MFA-TR*              AND (   :WS-DATE-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-DATE-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.DATE_FROM      >= :WS-BEGIN-DATE              
MFA-TR*                   AND SA1.DATE_TO        <= :WS-END-DATE ))             
MFA-TR*              AND (   :WS-CDST-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-CDST-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-RTPL-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-RTPL-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.RATE_PLAN_NO = :WS-RATE-PLAN-NO))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF.FACTOR_TYPE <> 'A'))                           
MFA-TR*              AND (   :WS-RATE-DEPT-FLTR = 'N' OR                        
MFA-TR*                   (  :WS-RATE-DEPT-FLTR = 'Y'                           
MFA-TR*                   AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))              
MFA-TR*              AND (   :WS-MAX-DATE-FLTR = 'N' OR                         
MFA-TR*                   (  :WS-MAX-DATE-FLTR = 'Y'                            
MFA-TR*                   AND SA1.DATE_FROM =                                   
MFA-TR*           (SELECT MAX(SA2.DATE_FROM)                                    
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA2                                 
MFA-TR*                  ,CSS_SPCL_FCTR SF2                                     
MFA-TR*                  ,CSS_RATE_PLAN_DESC RD2                                
MFA-TR*            WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE             
MFA-TR*              AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO               
MFA-TR*              AND SA2.FACTOR_ID         = SA1.FACTOR_ID                  
MFA-TR*              AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD                
MFA-TR*              AND SA2.BLOCK_NO          = SA1.BLOCK_NO                   
MFA-TR*              AND SA2.CODE_SEASON       = SA1.CODE_SEASON                
MFA-TR*              AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD          
MFA-TR*              AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD           
MFA-TR*              AND SA2.FACTOR_ID         = SF2.FACTOR_ID                  
MFA-TR*              AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO               
MFA-TR*              AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE             
MFA-TR*              AND (   :WS-DATE-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-DATE-FLTR  = 'Y'                               
MFA-TR*                   AND SA2.DATE_FROM      >= :WS-BEGIN-DATE              
MFA-TR*                   AND SA2.DATE_TO        <= :WS-END-DATE ))             
MFA-TR*              AND (   :WS-CDST-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-CDST-FLTR  = 'Y'                               
MFA-TR*                   AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-RTPL-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-RTPL-FLTR  = 'Y'                               
MFA-TR*                   AND SA2.RATE_PLAN_NO = :WS-RATE-PLAN-NO))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF2.FACTOR_TYPE <> 'A'))                          
MFA-TR*              AND (   :WS-RATE-DEPT-FLTR = 'N' OR                        
MFA-TR*                   (  :WS-RATE-DEPT-FLTR = 'Y'                           
MFA-TR*                   AND RD2.RATE_DEPT_CD = :WS-RATE-DEPT-CD)))))          
MFA-TR*            ORDER BY SA1.FACTOR_ID,                              03990500
MFA-TR*                     SA1.CODE_UTIL_TYPE,                                 
MFA-TR*                     SA1.RATE_PLAN_NO,                           03990600
MFA-TR*                     SA1.DATE_FROM DESC,                         03990800
MFA-TR*                     SA1.CODE_STATUS                             03990700
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 5000                                                 
MFA-TR*    END-EXEC.                                                    03991100
                                                                        
      ******************************************************************        
      * CURSOR TO FETCH DETAILS USING RATE PLAN NO                      03984000
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE FACTORRATE CURSOR FOR                            
                  SELECT SA1.CODE_UTIL_TYPE,                            
                         SA1.RATE_PLAN_NO,                              
                         SA1.CMPNT_ID_CD,                               
                         SA1.BLOCK_NO,                                  
                         SA1.VERS_PRORATE_CD,                           
                         SA1.CODE_SEASON,                               
                         SA1.INSTR_USE_TYPE_CD,                         
                         SA1.CODE_TIME_PERIOD,                          
                         SA1.CODE_REVENUE_CLASS,                        
                         CIS.CHAR2$DATE(SA1.DATE_FROM, 'USA'),                  
                         CIS.CHAR2$DATE(SA1.DATE_TO, 'USA'),                    
                         SA1.FACTOR,                                    
                         SA1.CODE_STATUS,                               
                         SA1.ENTRY_NO,                                  
                         SA1.USER_ID_UPD_BY,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                            
                         SA1.DATE_FROM,                                 
                         SA1.DATE_TO,                                   
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_END_TS,                           
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_END_TS,                           
                         SA1.FACTOR_ID,                                 
                         SA1.PROC_REQ_ID                                
                    FROM CSS_SPCL_FCTR_APPL SA1 WITH(READUNCOMMITTED)           
                        ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                 
                        ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)            
                   WHERE SA1.RATE_PLAN_NO   =  :WS-RATE-PLAN-NO         
                     AND SA1.CODE_UTIL_TYPE =  :WS-CODE-UTIL-TYPE       
                     AND SA1.FACTOR_ID      = SF.FACTOR_ID              
                     AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO           
                     AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE         
                     AND (   :WS-DATE-FLTR  = 'N' OR                    
                          (  :WS-DATE-FLTR  = 'Y'                       
                          AND SA1.DATE_FROM      >= 
              IIF(TRY_CONVERT(DATE, :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )      
                          AND SA1.DATE_TO        <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))     
                     AND (   :WS-CDST-FLTR  = 'N' OR                    
                          (  :WS-CDST-FLTR  = 'Y'                       
                          AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF.FACTOR_TYPE <> 'A'))                   
                     AND (   :WS-RATE-DEPT-FLTR = 'N' OR                
                          (  :WS-RATE-DEPT-FLTR = 'Y'                   
                          AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))      
                     AND (   :WS-MAX-DATE-FLTR = 'N' OR                 
                          (  :WS-MAX-DATE-FLTR = 'Y'                    
                          AND SA1.DATE_FROM =                           
                  (SELECT MAX(SA2.DATE_FROM)                            
                    FROM CSS_SPCL_FCTR_APPL SA2 WITH(READUNCOMMITTED)           
                        ,CSS_SPCL_FCTR SF2 WITH(READUNCOMMITTED)                
                        ,CSS_RATE_PLAN_DESC RD2 WITH(READUNCOMMITTED)           
                   WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE     
                     AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO       
                     AND SA2.FACTOR_ID         = SA1.FACTOR_ID          
                     AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD        
                     AND SA2.BLOCK_NO          = SA1.BLOCK_NO           
                     AND SA2.CODE_SEASON       = SA1.CODE_SEASON        
                     AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD  
                     AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD   
                     AND SA2.FACTOR_ID         = SF2.FACTOR_ID          
                     AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO       
                     AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE     
                     AND (   :WS-DATE-FLTR     = 'N' OR                 
                          (  :WS-DATE-FLTR     = 'Y'                    
                          AND SA2.DATE_FROM    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )        
                          AND SA2.DATE_TO      <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))       
                     AND (   :WS-CDST-FLTR     = 'N' OR                 
                          (  :WS-CDST-FLTR     = 'Y'                    
                          AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF2.FACTOR_TYPE  <> 'A'))                 
                     AND (   :WS-RATE-DEPT-FLTR = 'N' OR                
                          (  :WS-RATE-DEPT-FLTR = 'Y'                   
                          AND RD2.RATE_DEPT_CD  = :WS-RATE-DEPT-CD))))) 
                   ORDER BY SA1.FACTOR_ID,                              
                            SA1.CODE_UTIL_TYPE,                         
                            SA1.RATE_PLAN_NO,                           
                            SA1.DATE_FROM DESC,                         
                            SA1.CODE_STATUS                             
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FACTORRATE CURSOR FOR                            03986000
MFA-TR*           SELECT SA1.CODE_UTIL_TYPE,                            03987000
MFA-TR*                  SA1.RATE_PLAN_NO,                              03988000
MFA-TR*                  SA1.CMPNT_ID_CD,                               03989000
MFA-TR*                  SA1.BLOCK_NO,                                          
MFA-TR*                  SA1.VERS_PRORATE_CD,                                   
MFA-TR*                  SA1.CODE_SEASON,                               03989100
MFA-TR*                  SA1.INSTR_USE_TYPE_CD,                         03989200
MFA-TR*                  SA1.CODE_TIME_PERIOD,                          03989300
MFA-TR*                  SA1.CODE_REVENUE_CLASS,                        03989400
MFA-TR*                  CHAR(SA1.DATE_FROM, USA),                      03989500
MFA-TR*                  CHAR(SA1.DATE_TO, USA),                        03989600
MFA-TR*                  SA1.FACTOR,                                    03989700
MFA-TR*                  SA1.CODE_STATUS,                               03989800
MFA-TR*                  SA1.ENTRY_NO,                                  03989900
MFA-TR*                  SA1.USER_ID_UPD_BY,                            03990000
MFA-TR*                  SA1.LAST_UPDATE_TS,                                    
MFA-TR*                  SA1.DATE_FROM,                                 03990100
MFA-TR*                  SA1.DATE_TO,                                   03990200
MFA-TR*                  SA1.INT_DISP_START_TS,                                 
MFA-TR*                  SA1.INT_DISP_END_TS,                                   
MFA-TR*                  SA1.EXT_DISP_START_TS,                                 
MFA-TR*                  SA1.EXT_DISP_END_TS,                                   
MFA-TR*                  SA1.FACTOR_ID,                                         
MFA-TR*                  SA1.PROC_REQ_ID                                        
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA1                                 
MFA-TR*                 ,CSS_SPCL_FCTR SF                                       
MFA-TR*                 ,CSS_RATE_PLAN_DESC RD                                  
MFA-TR*            WHERE SA1.RATE_PLAN_NO   =  :WS-RATE-PLAN-NO                 
MFA-TR*              AND SA1.CODE_UTIL_TYPE =  :WS-CODE-UTIL-TYPE               
MFA-TR*              AND SA1.FACTOR_ID      = SF.FACTOR_ID                      
MFA-TR*              AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO                   
MFA-TR*              AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                 
MFA-TR*              AND (   :WS-DATE-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-DATE-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.DATE_FROM      >= :WS-BEGIN-DATE              
MFA-TR*                   AND SA1.DATE_TO        <= :WS-END-DATE ))             
MFA-TR*              AND (   :WS-CDST-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-CDST-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF.FACTOR_TYPE <> 'A'))                           
MFA-TR*              AND (   :WS-RATE-DEPT-FLTR = 'N' OR                        
MFA-TR*                   (  :WS-RATE-DEPT-FLTR = 'Y'                           
MFA-TR*                   AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))              
MFA-TR*              AND (   :WS-MAX-DATE-FLTR = 'N' OR                         
MFA-TR*                   (  :WS-MAX-DATE-FLTR = 'Y'                            
MFA-TR*                   AND SA1.DATE_FROM =                                   
MFA-TR*           (SELECT MAX(SA2.DATE_FROM)                                    
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA2                                 
MFA-TR*                 ,CSS_SPCL_FCTR SF2                                      
MFA-TR*                 ,CSS_RATE_PLAN_DESC RD2                                 
MFA-TR*            WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE             
MFA-TR*              AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO               
MFA-TR*              AND SA2.FACTOR_ID         = SA1.FACTOR_ID                  
MFA-TR*              AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD                
MFA-TR*              AND SA2.BLOCK_NO          = SA1.BLOCK_NO                   
MFA-TR*              AND SA2.CODE_SEASON       = SA1.CODE_SEASON                
MFA-TR*              AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD          
MFA-TR*              AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD           
MFA-TR*              AND SA2.FACTOR_ID         = SF2.FACTOR_ID                  
MFA-TR*              AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO               
MFA-TR*              AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE             
MFA-TR*              AND (   :WS-DATE-FLTR     = 'N' OR                         
MFA-TR*                   (  :WS-DATE-FLTR     = 'Y'                            
MFA-TR*                   AND SA2.DATE_FROM    >= :WS-BEGIN-DATE                
MFA-TR*                   AND SA2.DATE_TO      <= :WS-END-DATE ))               
MFA-TR*              AND (   :WS-CDST-FLTR     = 'N' OR                         
MFA-TR*                   (  :WS-CDST-FLTR     = 'Y'                            
MFA-TR*                   AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF2.FACTOR_TYPE  <> 'A'))                         
MFA-TR*              AND (   :WS-RATE-DEPT-FLTR = 'N' OR                        
MFA-TR*                   (  :WS-RATE-DEPT-FLTR = 'Y'                           
MFA-TR*                   AND RD2.RATE_DEPT_CD  = :WS-RATE-DEPT-CD)))))         
MFA-TR*            ORDER BY SA1.FACTOR_ID,                                      
MFA-TR*                     SA1.CODE_UTIL_TYPE,                                 
MFA-TR*                     SA1.RATE_PLAN_NO,                                   
MFA-TR*                     SA1.DATE_FROM DESC,                                 
MFA-TR*                     SA1.CODE_STATUS                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 5500                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR TO FETCH DETAILS USING RATE DEPARTMENT                   03984000
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE FACTORRATEDEPT CURSOR FOR                        
                  SELECT SA1.CODE_UTIL_TYPE,                            
                         SA1.RATE_PLAN_NO,                              
                         SA1.CMPNT_ID_CD,                               
                         SA1.BLOCK_NO,                                  
                         SA1.VERS_PRORATE_CD,                           
                         SA1.CODE_SEASON,                               
                         SA1.INSTR_USE_TYPE_CD,                         
                         SA1.CODE_TIME_PERIOD,                          
                         SA1.CODE_REVENUE_CLASS,                        
                         CIS.CHAR2$DATE(SA1.DATE_FROM, 'USA'),                  
                         CIS.CHAR2$DATE(SA1.DATE_TO, 'USA'),                    
                         SA1.FACTOR,                                    
                         SA1.CODE_STATUS,                               
                         SA1.ENTRY_NO,                                  
                         SA1.USER_ID_UPD_BY,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                            
                         SA1.DATE_FROM,                                 
                         SA1.DATE_TO,                                   
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.INT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_END_TS,                           
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_START_TS,                         
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA1.EXT_DISP_END_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_END_TS,                           
                         SA1.FACTOR_ID,                                 
                         SA1.PROC_REQ_ID                                
                    FROM CSS_SPCL_FCTR_APPL SA1 WITH(READUNCOMMITTED)           
                        ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                 
                        ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)            
                   WHERE RD.RATE_DEPT_CD    =  :WS-RATE-DEPT-CD         
                     AND SA1.FACTOR_ID      = SF.FACTOR_ID              
                     AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO           
                     AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE         
                     AND (   :WS-DATE-FLTR  = 'N' OR                    
                          (  :WS-DATE-FLTR  = 'Y'                       
                          AND SA1.DATE_FROM      >= 
              IIF(TRY_CONVERT(DATE, :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )      
                          AND SA1.DATE_TO        <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))     
                     AND (   :WS-CDST-FLTR  = 'N' OR                    
                          (  :WS-CDST-FLTR  = 'Y'                       
                          AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF.FACTOR_TYPE <> 'A'))                   
                     AND (   :WS-FCTR-FLTR = 'N' OR                     
                          (  :WS-FCTR-FLTR = 'Y'                        
                          AND SA1.FACTOR_ID = :WS-FACTOR-ID             
                          AND SA1.CODE_UTIL_TYPE =:WS-CODE-UTIL-TYPE)) 
                     AND (   :WS-RTPL-FLTR = 'N' OR                     
                          (  :WS-RTPL-FLTR = 'Y'                        
                          AND SA1.RATE_PLAN_NO = :WS-RATE-PLAN-NO       
                          AND SA1.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)) 
                     AND (   :WS-MAX-DATE-FLTR = 'N' OR                 
                          (  :WS-MAX-DATE-FLTR = 'Y'                    
                          AND SA1.DATE_FROM =                           
                  (SELECT MAX(SA2.DATE_FROM)                            
                    FROM CSS_SPCL_FCTR_APPL SA2 WITH(READUNCOMMITTED)           
                        ,CSS_SPCL_FCTR SF2 WITH(READUNCOMMITTED)                
                        ,CSS_RATE_PLAN_DESC RD2 WITH(READUNCOMMITTED)           
                   WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE     
                     AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO       
                     AND SA2.FACTOR_ID         = SA1.FACTOR_ID          
                     AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD        
                     AND SA2.BLOCK_NO          = SA1.BLOCK_NO           
                     AND SA2.CODE_SEASON       = SA1.CODE_SEASON        
                     AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD  
                     AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD   
                     AND SA2.FACTOR_ID         = SF2.FACTOR_ID          
                     AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO       
                     AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE     
                     AND RD2.RATE_DEPT_CD    =  :WS-RATE-DEPT-CD        
                     AND (   :WS-DATE-FLTR  = 'N' OR                    
                          (  :WS-DATE-FLTR  = 'Y'                       
                          AND SA2.DATE_FROM      >= 
              IIF(TRY_CONVERT(DATE, :WS-BEGIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEGIN-DATE
              ) <> 0) OR (LEN(:WS-BEGIN-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-BEGIN-DATE
              ), CONVERT(DATE, :WS-BEGIN-DATE) )      
                          AND SA2.DATE_TO        <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))     
                     AND (   :WS-CDST-FLTR  = 'N' OR                    
                          (  :WS-CDST-FLTR  = 'Y'                       
                          AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))     
                     AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR             
                          (  :WS-EX-RATE-FCTR-FLTR = 'Y'                
                          AND SF2.FACTOR_TYPE <> 'A'))                  
                     AND (   :WS-FCTR-FLTR = 'N' OR                     
                          (  :WS-FCTR-FLTR = 'Y'                        
                          AND SA2.FACTOR_ID = :WS-FACTOR-ID             
                          AND SA2.CODE_UTIL_TYPE =:WS-CODE-UTIL-TYPE)) 
                     AND (   :WS-RTPL-FLTR = 'N' OR                     
                          (  :WS-RTPL-FLTR = 'Y'                        
                          AND SA2.RATE_PLAN_NO = :WS-RATE-PLAN-NO       
                          AND SA2.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)) 
                          )))                                           
                   ORDER BY SA1.FACTOR_ID,                              
                            SA1.CODE_UTIL_TYPE,                         
                            SA1.RATE_PLAN_NO,                           
                            SA1.DATE_FROM DESC,                         
                            SA1.CODE_STATUS                             
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FACTORRATEDEPT CURSOR FOR                        03986000
MFA-TR*           SELECT SA1.CODE_UTIL_TYPE,                            03987000
MFA-TR*                  SA1.RATE_PLAN_NO,                              03988000
MFA-TR*                  SA1.CMPNT_ID_CD,                               03989000
MFA-TR*                  SA1.BLOCK_NO,                                          
MFA-TR*                  SA1.VERS_PRORATE_CD,                                   
MFA-TR*                  SA1.CODE_SEASON,                               03989100
MFA-TR*                  SA1.INSTR_USE_TYPE_CD,                         03989200
MFA-TR*                  SA1.CODE_TIME_PERIOD,                          03989300
MFA-TR*                  SA1.CODE_REVENUE_CLASS,                        03989400
MFA-TR*                  CHAR(SA1.DATE_FROM, USA),                      03989500
MFA-TR*                  CHAR(SA1.DATE_TO, USA),                        03989600
MFA-TR*                  SA1.FACTOR,                                    03989700
MFA-TR*                  SA1.CODE_STATUS,                               03989800
MFA-TR*                  SA1.ENTRY_NO,                                  03989900
MFA-TR*                  SA1.USER_ID_UPD_BY,                            03990000
MFA-TR*                  SA1.LAST_UPDATE_TS,                                    
MFA-TR*                  SA1.DATE_FROM,                                 03990100
MFA-TR*                  SA1.DATE_TO,                                   03990200
MFA-TR*                  SA1.INT_DISP_START_TS,                                 
MFA-TR*                  SA1.INT_DISP_END_TS,                                   
MFA-TR*                  SA1.EXT_DISP_START_TS,                                 
MFA-TR*                  SA1.EXT_DISP_END_TS,                                   
MFA-TR*                  SA1.FACTOR_ID,                                         
MFA-TR*                  SA1.PROC_REQ_ID                                        
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA1                                 
MFA-TR*                 ,CSS_SPCL_FCTR SF                                       
MFA-TR*                 ,CSS_RATE_PLAN_DESC RD                                  
MFA-TR*            WHERE RD.RATE_DEPT_CD    =  :WS-RATE-DEPT-CD                 
MFA-TR*              AND SA1.FACTOR_ID      = SF.FACTOR_ID                      
MFA-TR*              AND SA1.RATE_PLAN_NO   = RD.RATE_PLAN_NO                   
MFA-TR*              AND SA1.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                 
MFA-TR*              AND (   :WS-DATE-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-DATE-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.DATE_FROM      >= :WS-BEGIN-DATE              
MFA-TR*                   AND SA1.DATE_TO        <= :WS-END-DATE ))             
MFA-TR*              AND (   :WS-CDST-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-CDST-FLTR  = 'Y'                               
MFA-TR*                   AND SA1.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF.FACTOR_TYPE <> 'A'))                           
MFA-TR*              AND (   :WS-FCTR-FLTR = 'N' OR                             
MFA-TR*                   (  :WS-FCTR-FLTR = 'Y'                                
MFA-TR*                   AND SA1.FACTOR_ID = :WS-FACTOR-ID                     
MFA-TR*                   AND SA1.CODE_UTIL_TYPE =: WS-CODE-UTIL-TYPE))         
MFA-TR*              AND (   :WS-RTPL-FLTR = 'N' OR                             
MFA-TR*                   (  :WS-RTPL-FLTR = 'Y'                                
MFA-TR*                   AND SA1.RATE_PLAN_NO = :WS-RATE-PLAN-NO               
MFA-TR*                   AND SA1.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE))         
MFA-TR*              AND (   :WS-MAX-DATE-FLTR = 'N' OR                         
MFA-TR*                   (  :WS-MAX-DATE-FLTR = 'Y'                            
MFA-TR*                   AND SA1.DATE_FROM =                                   
MFA-TR*           (SELECT MAX(SA2.DATE_FROM)                                    
MFA-TR*             FROM CSS_SPCL_FCTR_APPL SA2                                 
MFA-TR*                 ,CSS_SPCL_FCTR SF2                                      
MFA-TR*                 ,CSS_RATE_PLAN_DESC RD2                                 
MFA-TR*            WHERE SA2.CODE_UTIL_TYPE    = SA1.CODE_UTIL_TYPE             
MFA-TR*              AND SA2.RATE_PLAN_NO      = SA1.RATE_PLAN_NO               
MFA-TR*              AND SA2.FACTOR_ID         = SA1.FACTOR_ID                  
MFA-TR*              AND SA2.CMPNT_ID_CD       = SA1.CMPNT_ID_CD                
MFA-TR*              AND SA2.BLOCK_NO          = SA1.BLOCK_NO                   
MFA-TR*              AND SA2.CODE_SEASON       = SA1.CODE_SEASON                
MFA-TR*              AND SA2.INSTR_USE_TYPE_CD = SA1.INSTR_USE_TYPE_CD          
MFA-TR*              AND SA2.CODE_TIME_PERIOD  = SA1.CODE_TIME_PERIOD           
MFA-TR*              AND SA2.FACTOR_ID         = SF2.FACTOR_ID                  
MFA-TR*              AND SA2.RATE_PLAN_NO      = RD2.RATE_PLAN_NO               
MFA-TR*              AND SA2.CODE_UTIL_TYPE    = RD2.CODE_UTIL_TYPE             
MFA-TR*              AND RD2.RATE_DEPT_CD    =  :WS-RATE-DEPT-CD                
MFA-TR*              AND (   :WS-DATE-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-DATE-FLTR  = 'Y'                               
MFA-TR*                   AND SA2.DATE_FROM      >= :WS-BEGIN-DATE              
MFA-TR*                   AND SA2.DATE_TO        <= :WS-END-DATE ))             
MFA-TR*              AND (   :WS-CDST-FLTR  = 'N' OR                            
MFA-TR*                   (  :WS-CDST-FLTR  = 'Y'                               
MFA-TR*                   AND SA2.CODE_STATUS  = :WS-CODE-STATUS ))             
MFA-TR*              AND (   :WS-EX-RATE-FCTR-FLTR = 'N' OR                     
MFA-TR*                   (  :WS-EX-RATE-FCTR-FLTR = 'Y'                        
MFA-TR*                   AND SF2.FACTOR_TYPE <> 'A'))                          
MFA-TR*              AND (   :WS-FCTR-FLTR = 'N' OR                             
MFA-TR*                   (  :WS-FCTR-FLTR = 'Y'                                
MFA-TR*                   AND SA2.FACTOR_ID = :WS-FACTOR-ID                     
MFA-TR*                   AND SA2.CODE_UTIL_TYPE =: WS-CODE-UTIL-TYPE))         
MFA-TR*              AND (   :WS-RTPL-FLTR = 'N' OR                             
MFA-TR*                   (  :WS-RTPL-FLTR = 'Y'                                
MFA-TR*                   AND SA2.RATE_PLAN_NO = :WS-RATE-PLAN-NO               
MFA-TR*                   AND SA2.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE))         
MFA-TR*                   )))                                                   
MFA-TR*            ORDER BY SA1.FACTOR_ID,                                      
MFA-TR*                     SA1.CODE_UTIL_TYPE,                                 
MFA-TR*                     SA1.RATE_PLAN_NO,                                   
MFA-TR*                     SA1.DATE_FROM DESC,                                 
MFA-TR*                     SA1.CODE_STATUS                                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 5700                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR TO RETRIEVE SPECIAL FACTOR APPL DETAILS USING PROC REQ ID03984000
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE PROC_REQ_ID_CUR CURSOR FOR                       
                  SELECT  CODE_UTIL_TYPE                                
                         ,RATE_PLAN_NO                                  
                         ,CMPNT_ID_CD                                   
                         ,BLOCK_NO                                      
                         ,VERS_PRORATE_CD                               
                         ,CODE_SEASON                                   
                         ,INSTR_USE_TYPE_CD                             
                         ,CODE_TIME_PERIOD                              
                         ,CODE_REVENUE_CLASS                            
                         ,CIS.CHAR2$DATE(DATE_FROM, 'USA')                      
                         ,CIS.CHAR2$DATE(DATE_TO, 'USA')                        
                         ,FACTOR                                        
                         ,CODE_STATUS                                   
                         ,ENTRY_NO                                      
                         ,USER_ID_UPD_BY                                
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                         ,DATE_FROM                                     
                         ,DATE_TO                                       
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           INT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           INT_DISP_START_TS                             
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           INT_DISP_END_TS, 121), ' ', '-'), ':', '.') INT_DISP_END_TS         
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           EXT_DISP_START_TS, 121), ' ', '-'), ':', '.') 
           EXT_DISP_START_TS                             
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           EXT_DISP_END_TS, 121), ' ', '-'), ':', '.') EXT_DISP_END_TS         
                         ,FACTOR_ID                                     
                         ,PROC_REQ_ID                                   
                    FROM  CSS_SPCL_FCTR_APPL WITH(READUNCOMMITTED)              
                   WHERE  PROC_REQ_ID     = :WS-PROC-REQ-ID             
                 ORDER BY FACTOR_ID,                                    
                          CODE_UTIL_TYPE,                               
                          RATE_PLAN_NO,                                 
                          DATE_FROM DESC,                               
                          CODE_STATUS                                   
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PROC_REQ_ID_CUR CURSOR FOR                       03986000
MFA-TR*           SELECT  CODE_UTIL_TYPE                                03987000
MFA-TR*                  ,RATE_PLAN_NO                                  03988000
MFA-TR*                  ,CMPNT_ID_CD                                   03989000
MFA-TR*                  ,BLOCK_NO                                              
MFA-TR*                  ,VERS_PRORATE_CD                                       
MFA-TR*                  ,CODE_SEASON                                   03989100
MFA-TR*                  ,INSTR_USE_TYPE_CD                             03989200
MFA-TR*                  ,CODE_TIME_PERIOD                              03989300
MFA-TR*                  ,CODE_REVENUE_CLASS                            03989400
MFA-TR*                  ,CHAR(DATE_FROM, USA)                          03989500
MFA-TR*                  ,CHAR(DATE_TO, USA)                            03989600
MFA-TR*                  ,FACTOR                                        03989700
MFA-TR*                  ,CODE_STATUS                                   03989800
MFA-TR*                  ,ENTRY_NO                                      03989900
MFA-TR*                  ,USER_ID_UPD_BY                                03990000
MFA-TR*                  ,LAST_UPDATE_TS                                        
MFA-TR*                  ,DATE_FROM                                     03990100
MFA-TR*                  ,DATE_TO                                       03990200
MFA-TR*                  ,INT_DISP_START_TS                                     
MFA-TR*                  ,INT_DISP_END_TS                                       
MFA-TR*                  ,EXT_DISP_START_TS                                     
MFA-TR*                  ,EXT_DISP_END_TS                                       
MFA-TR*                  ,FACTOR_ID                                             
MFA-TR*                  ,PROC_REQ_ID                                           
MFA-TR*             FROM  CSS_SPCL_FCTR_APPL                                    
MFA-TR*            WHERE  PROC_REQ_ID     = :WS-PROC-REQ-ID                     
MFA-TR*          ORDER BY FACTOR_ID,                                            
MFA-TR*                   CODE_UTIL_TYPE,                                       
MFA-TR*                   RATE_PLAN_NO,                                         
MFA-TR*                   DATE_FROM DESC,                                       
MFA-TR*                   CODE_STATUS                                           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 5250                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID       PIC X(03).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-FACTOR-ID          PIC X(09).                           
       01  PARM-CODE-UTIL-TYPE     PIC X(01).                           
       01  PARM-BEGIN-DATE         PIC X(10).                           
       01  PARM-END-DATE           PIC X(10).                           
       01  PARM-RATE-PLAN-NO       PIC X(03).                           
       01  PARM-CODE-STATUS        PIC X(01).                           
       01  PARM-PROC-REQ-ID        PIC X(10).                           
       01  PARM-MAX-DATE-FL        PIC X(01).                           
       01  PARM-EX-RATE-FCTR-FL    PIC X(01).                           
       01  PARM-RATE-DEPT-CD       PIC X(03).                           
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-USER-ID                            
                                PARM-FACTOR-ID                          
                                PARM-CODE-UTIL-TYPE                     
                                PARM-BEGIN-DATE                         
                                PARM-END-DATE                           
                                PARM-RATE-PLAN-NO                       
                                PARM-CODE-STATUS                        
                                PARM-PROC-REQ-ID                        
                                PARM-MAX-DATE-FL                        
                                PARM-EX-RATE-FCTR-FL                    
                                PARM-RATE-DEPT-CD.                      
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. VALIDATE INPUT PARMS                                    *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE PARM-FACTOR-ID               TO WS-FACTOR-ID.           
           MOVE PARM-PROC-REQ-ID             TO WS-PROC-REQ-ID.         
                                                                        
           IF PARM-BEGIN-DATE > SPACES AND                              
              PARM-END-DATE > SPACES                                    
              MOVE 'Y'                       TO WS-DATE-FLTR            
           ELSE                                                         
              MOVE '1900-01-01'              TO PARM-BEGIN-DATE         
                                                PARM-END-DATE           
           END-IF.                                                      
                                                                        
           IF PARM-RATE-PLAN-NO > SPACES                                
              MOVE 'Y'                       TO WS-RTPL-FLTR            
           END-IF.                                                      
                                                                        
           IF PARM-CODE-STATUS > SPACES                                 
              MOVE 'Y'                       TO WS-CDST-FLTR            
           END-IF.                                                      
                                                                        
           IF PARM-FACTOR-ID   > SPACES                                 
              MOVE 'Y'                       TO WS-FCTR-FLTR            
           END-IF.                                                      
                                                                        
           IF WS-PROC-REQ-ID   > 0                                      
              MOVE 'Y'                       TO WS-PRID-FLTR            
           END-IF.                                                      
                                                                        
           IF PARM-RATE-DEPT-CD > SPACES                                
              MOVE 'Y'                       TO WS-RATE-DEPT-FLTR       
           END-IF.                                                      
                                                                        
           MOVE PARM-CODE-UTIL-TYPE  TO WS-CODE-UTIL-TYPE               
           MOVE PARM-BEGIN-DATE      TO WS-BEGIN-DATE                   
           MOVE PARM-END-DATE        TO WS-END-DATE                     
           MOVE PARM-CODE-STATUS     TO WS-CODE-STATUS                  
           MOVE PARM-RATE-PLAN-NO    TO WS-RATE-PLAN-NO                 
           MOVE PARM-MAX-DATE-FL     TO WS-MAX-DATE-FLTR                
           MOVE PARM-EX-RATE-FCTR-FL TO WS-EX-RATE-FCTR-FLTR            
           MOVE PARM-RATE-DEPT-CD    TO WS-RATE-DEPT-CD                 
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,FACTOR_ID                                                 
             ,CODE_UTIL_TYPE                                            
             ,RATE_PLAN_NO                                              
             ,RATE_COMPONENT                                            
             ,CODE_REVENUE_CLASS                                        
             ,START_DATE                                                
             ,END_DATE                                                  
             ,FACTOR                                                    
             ,CODE_STATUS                                               
             ,ENTRY_NO                                                  
             ,USER_ID_UPD_BY                                            
             ,LAST_UPDATE_TS                                            
             ,INT_DISP_START_TS                                         
             ,INT_DISP_END_TS                                           
             ,EXT_DISP_START_TS                                         
             ,EXT_DISP_END_TS                                           
             ,BLOCK_NO                                                  
             ,VERS_PRORATE_CD                                           
             ,ALLOW_UPDATE                                              
             ,PROC_REQ_ID                                               
             ,FCTR_UPDATE_FL                                            
                FROM #CSR04518_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,FACTOR_ID                                                         
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,RATE_COMPONENT                                                    
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,START_DATE                                                        
MFA-TR*      ,END_DATE                                                          
MFA-TR*      ,FACTOR                                                            
MFA-TR*      ,CODE_STATUS                                                       
MFA-TR*      ,ENTRY_NO                                                          
MFA-TR*      ,USER_ID_UPD_BY                                                    
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*      ,INT_DISP_START_TS                                                 
MFA-TR*      ,INT_DISP_END_TS                                                   
MFA-TR*      ,EXT_DISP_START_TS                                                 
MFA-TR*      ,EXT_DISP_END_TS                                                   
MFA-TR*      ,BLOCK_NO                                                          
MFA-TR*      ,VERS_PRORATE_CD                                                   
MFA-TR*      ,ALLOW_UPDATE                                                      
MFA-TR*      ,PROC_REQ_ID                                                       
MFA-TR*      ,FCTR_UPDATE_FL                                                    
MFA-TR*         FROM SESSION.CSR04518_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE '0100A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04518_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04518_R1
              (                                                        
                   RETURN_CODE           INT                        
                  ,APPL_RETURN_CODE      INT                        
                  ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,RATE_COMPONENT CHAR(08)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,FACTOR              DECIMAL(9,6)                     
                  ,CODE_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,ENTRY_NO            SMALLINT                         
                  ,USER_ID_UPD_BY CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,INT_DISP_START_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,INT_DISP_END_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,EXT_DISP_START_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,EXT_DISP_END_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,BLOCK_NO            SMALLINT                         
                  ,VERS_PRORATE_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,ALLOW_UPDATE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,PROC_REQ_ID         DECIMAL(10,0)                    
                  ,FCTR_UPDATE_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                                               DCLCSS-SPCL-FCTR-APPL    
                  MOVE 100                  TO S-RETURN-CODE            
                  MOVE 910                  TO S-APPL-RETURN-CODE       
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04518_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE '8000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04518_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04518_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
                                            DCLCSS-SPCL-FCTR-APPL       
               MOVE 100                  TO S-RETURN-CODE               
               MOVE 911                  TO S-APPL-RETURN-CODE          
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04518_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
           PERFORM 2200-GET-FACTOR-DTLS   THRU 2200-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16233300
      ******************************************************************16234000
      * 2200-GET-FACTOR-DTLS                                           *16240000
      *                                                                *16250000
      *  1. OPEN CURSOR                                                *16260000
      *  2. FETCH DEPENDENT ACCOUNT INFORMATION                        *16270000
      *  3. CLOSE CURSOR                                               *16271000
      *  4. DETERMINE MASTER ACCOUNT INFORMATION                       *16280000
      *                                                                *16281000
      ******************************************************************16290000
       2200-GET-FACTOR-DTLS.                                            
      *                                                                 16310000
           IF WS-PRID-FLTR = 'Y'                                        
              PERFORM 5200-OPEN-PROC-REQ-ID-CURSOR    THRU 5200-EXIT    
              PERFORM 5250-FETCH-PROC-REQ-ID-CURSOR   THRU 5250-EXIT    
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
              PERFORM 7100-CLOSE-PROC-REQ-ID-CURSOR   THRU 7100-EXIT    
           ELSE                                                         
             IF WS-RATE-DEPT-FLTR = 'Y' AND WS-FCTR-FLTR = 'N'          
                 AND WS-RTPL-FLTR = 'N'                                 
                PERFORM 5700-OPEN-RATEDEPTFCT-CURSOR      THRU 5700-EXIT
                PERFORM 5800-FETCH-RATEDEPTFCT-CURSOR     THRU 5800-EXIT
                   UNTIL SQLCODE = NOT-FOUND                            
                PERFORM 7600-CLOSE-RATEDEPTFCT-CURSOR     THRU 7600-EXIT
             ELSE                                                       
                IF WS-FCTR-FLTR = 'N' AND WS-RTPL-FLTR = 'Y'            
                   PERFORM 5500-OPEN-RATEFCT-CURSOR       THRU 5500-EXIT
                   PERFORM 5600-FETCH-RATEFCT-CURSOR      THRU 5600-EXIT
                       UNTIL SQLCODE = NOT-FOUND                        
                   PERFORM 7500-CLOSE-RATEFCT-CURSOR      THRU 7500-EXIT
                ELSE                                                    
                   PERFORM 5000-OPEN-FACTOR-CURSOR        THRU 5000-EXIT
                   PERFORM 5100-FETCH-FACTOR-CURSOR       THRU 5100-EXIT
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                   PERFORM 7000-CLOSE-FACTOR-CURSOR       THRU 7000-EXIT
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
      *                                                                 16390000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16650000
      *                                                                 16651000
      ******************************************************************16663000
      * 2300 SET RETURNS                                               *16670000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*16680000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *16690000
      ******************************************************************16700000
       2300-SET-RETURNS.                                                
      *                                                                 16711000
           MOVE SA-FACTOR-ID          TO S-FACTOR-ID.                   
           MOVE SA-PROC-REQ-ID        TO S-PROC-REQ-ID.                 
           MOVE SA-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE               
                                         PS-CODE-UTIL-TYPE.             
           MOVE SA-RATE-PLAN-NO       TO S-RATE-PLAN-NO                 
                                         PS-RATE-PLAN-NO.               
           MOVE SA-CMPNT-ID-CD        TO RS-CMPNT-ID-CD.                
           MOVE ZERO                  TO WS-BLOCK-NO                    
                                         WS-BLOCK-NULL-ID.              
           MOVE SA-BLOCK-NO           TO S-BLOCK-NO.                    
           MOVE SA-VERS-PRORATE-CD    TO S-VERS-PRORATE-CD.             
           MOVE SA-CODE-SEASON        TO RS-CODE-SEASON.                
           MOVE SA-INSTR-USE-TYPE-CD  TO RS-INSTR-USE-TYPE-CD.          
           MOVE SA-CODE-TIME-PERIOD   TO S-CODE-TIME-PERIOD.            
           MOVE SA-CODE-REVENUE-CLASS TO S-CODE-REVENUE-CLASS.          
           MOVE SA-FACTOR             TO S-FACTOR.                      
           MOVE SA-CODE-STATUS        TO S-CODE-STATUS.                 
           MOVE SA-ENTRY-NO           TO S-ENTRY-NO.                    
           MOVE SA-USER-ID-UPD-BY     TO S-USER-ID-UPD-BY.              
           MOVE SA-LAST-UPDATE-TS     TO S-LAST-UPDATE-TS.              
           MOVE SA-INT-DISP-START-TS  TO S-INT-DISP-START-TS.           
           MOVE SA-INT-DISP-END-TS    TO S-INT-DISP-END-TS.             
           MOVE SA-EXT-DISP-START-TS  TO S-EXT-DISP-START-TS.           
           MOVE SA-EXT-DISP-END-TS    TO S-EXT-DISP-END-TS.             
      *                                                                 16746000
           MOVE SA-DATE-FROM          TO TEMP-DATE-REFORMAT.            
           MOVE TEMP-MONTH            TO START-MONTH.                   
           MOVE TEMP-DAY              TO START-DAY.                     
           MOVE TEMP-YEAR             TO START-YEAR.                    
           MOVE '/'                   TO WS-FILLER-1.                   
           MOVE '/'                   TO WS-FILLER-2.                   
           MOVE START-DATE-REFORMAT   TO S-START-DATE.                  
      *                                                                 16746600
           MOVE SA-DATE-TO            TO TEMP-DATE-REFORMAT.            
           MOVE TEMP-MONTH            TO END-MONTH.                     
           MOVE TEMP-DAY              TO END-DAY.                       
           MOVE TEMP-YEAR             TO END-YEAR.                      
           MOVE '/'                   TO WS-FILLER-3.                   
           MOVE '/'                   TO WS-FILLER-4.                   
           MOVE END-DATE-REFORMAT     TO S-END-DATE.                    
      *                                                                 16747400
           MOVE S-CODE-TIME-PERIOD    TO RS-CODE-TIME-PERIOD-1          
           MOVE RS-CODE-TIME-PERIOD-2 TO RS-CODE-TIME-PERIOD-3.         
           MOVE RS-RATE-COMPONENT     TO S-RATE-COMPONENT.              
                                                                        
           PERFORM 7110-SELECT-JOB-PARM   THRU 7110-EXIT.               
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE SPACES  TO WS-PARM-DATA                              
           END-IF.                                                      
                                                                        
           PERFORM 7120-CHECK-FACTOR-UPDATEABLE                         
                                          THRU 7120-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N'                    TO S-ALLOW-UPDATE             
           ELSE                                                         
              MOVE WS-ALLOW-UPDATE        TO S-ALLOW-UPDATE             
           END-IF                                                       
                                                                        
           IF WS-PARM-FACT-ID EQUAL SA-FACTOR-ID                        
              MOVE 'Y'  TO   S-FCTR-UPDATE-FL                           
           ELSE                                                         
              MOVE 'N'  TO   S-FCTR-UPDATE-FL                           
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42239500
      ******************************************************************42239600
      * 5000-OPEN-FACTOR-CURSOR                                        *42239700
      *       -- THIS MODULE OPENS THE CURSOR THAT WILL CREATE THE     *42239800
      *          RESULT SET OF SPECIAL RATE FACTORS.                   *42239900
      ******************************************************************42240000
       5000-OPEN-FACTOR-CURSOR.                                         
      *                                                                 42240200
           EXEC SQL                                                     
               OPEN FACTORCURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42240800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '5000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1               
               MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1       
               MOVE WS-FACTOR-ID               TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42242400
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42242800
      ******************************************************************42242900
      * 5100-FETCH-FACTOR-CURSOR                                       *42243000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF SPECIAL FACTOR   *42243100
      *        RATES.                                                  *42243200
      ******************************************************************42243300
       5100-FETCH-FACTOR-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH FACTORCURSOR                                       
                  INTO :SA-CODE-UTIL-TYPE,                              
                       :SA-RATE-PLAN-NO,                                
                       :SA-CMPNT-ID-CD,                                 
                       :SA-BLOCK-NO,                                    
                       :SA-VERS-PRORATE-CD,                             
                       :SA-CODE-SEASON,                                 
                       :SA-INSTR-USE-TYPE-CD,                           
                       :SA-CODE-TIME-PERIOD,                            
                       :SA-CODE-REVENUE-CLASS,                          
                       :SA-DATE-FROM,                                   
                       :SA-DATE-TO,                                     
                       :SA-FACTOR,                                      
                       :SA-CODE-STATUS,                                 
                       :SA-ENTRY-NO,                                    
                       :SA-USER-ID-UPD-BY,                              
                       :SA-LAST-UPDATE-TS,                              
                       :DUMMY-DATE,                                     
                       :DUMMY-DATE,                                     
                       :SA-INT-DISP-START-TS :WS-NULL-IND1,              
                       :SA-INT-DISP-END-TS :WS-NULL-IND2,                
                       :SA-EXT-DISP-START-TS :WS-NULL-IND3,              
                       :SA-EXT-DISP-END-TS :WS-NULL-IND4,                
                       :SA-FACTOR-ID,                                   
                       :SA-PROC-REQ-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42245500
           IF WS-NULL-IND1 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND2 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-END-TS                         
           END-IF.                                                      
           IF WS-NULL-IND3 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND4 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-END-TS                         
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              PERFORM 2300-SET-RETURNS     THRU 2300-EXIT               
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
              MOVE +0                   TO WS-ACTIVE-RETURN-CODE        
           WHEN NOT-FOUND                                               
              IF CTR-ROWS = 0                                           
                INITIALIZE GTT-RETURN-FIELDS                            
                           DCLCSS-SPCL-FCTR-APPL                        
                MOVE +100                 TO S-RETURN-CODE              
                MOVE +901                 TO S-APPL-RETURN-CODE         
                MOVE PARM-FACTOR-ID       TO SA-FACTOR-ID               
                MOVE PARM-CODE-UTIL-TYPE  TO SA-CODE-UTIL-TYPE          
                MOVE PARM-RATE-PLAN-NO    TO SA-RATE-PLAN-NO            
                MOVE PARM-CODE-STATUS     TO SA-CODE-STATUS             
                PERFORM 2300-SET-RETURNS     THRU 2300-EXIT             
                PERFORM 8100-SEND-RESULT     THRU 8100-EXIT             
                MOVE +100                 TO WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
           WHEN OTHER                                                   
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5100'          TO ACTIVE-PARAGRAPH                 
               MOVE 'FETCH'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1             
               MOVE  WS-FACTOR-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                 42248100
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42239500
      ******************************************************************42239600
      * 5200-OPEN-PROC-REQ-ID-CURSOR                                   *42239700
      *       -- THIS MODULE OPENS THE CURSOR THAT WILL CREATE THE     *42239800
      *          RESULT SET OF SPECIAL RATE FACTORS.                   *42239900
      ******************************************************************42240000
       5200-OPEN-PROC-REQ-ID-CURSOR.                                    
      *                                                                 42240200
           EXEC SQL                                                     
               OPEN PROC_REQ_ID_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42240800
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '5200'                   TO ACTIVE-PARAGRAPH        
               MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                 
               MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1         
               MOVE WS-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42242400
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42242800
      ******************************************************************42242900
      * 5250-FETCH-PROC-REQ-ID-CURSOR                                  *42243000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF SPECIAL FACTOR   *42243100
      *        RATES.                                                  *42243200
      ******************************************************************42243300
       5250-FETCH-PROC-REQ-ID-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               FETCH PROC_REQ_ID_CUR                                    
                  INTO :SA-CODE-UTIL-TYPE                               
                      ,:SA-RATE-PLAN-NO                                 
                      ,:SA-CMPNT-ID-CD                                  
                      ,:SA-BLOCK-NO                                     
                      ,:SA-VERS-PRORATE-CD                              
                      ,:SA-CODE-SEASON                                  
                      ,:SA-INSTR-USE-TYPE-CD                            
                      ,:SA-CODE-TIME-PERIOD                             
                      ,:SA-CODE-REVENUE-CLASS                           
                      ,:SA-DATE-FROM                                    
                      ,:SA-DATE-TO                                      
                      ,:SA-FACTOR                                       
                      ,:SA-CODE-STATUS                                  
                      ,:SA-ENTRY-NO                                     
                      ,:SA-USER-ID-UPD-BY                               
                      ,:SA-LAST-UPDATE-TS                               
                      ,:DUMMY-DATE                                      
                      ,:DUMMY-DATE                                      
                      ,:SA-INT-DISP-START-TS :WS-NULL-IND1              
                      ,:SA-INT-DISP-END-TS :WS-NULL-IND2              
                      ,:SA-EXT-DISP-START-TS :WS-NULL-IND3              
                      ,:SA-EXT-DISP-END-TS :WS-NULL-IND4              
                      ,:SA-FACTOR-ID                                    
                      ,:SA-PROC-REQ-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42245500
           IF WS-NULL-IND1 < 0 THEN                                     
              MOVE SPACES                    TO SA-INT-DISP-START-TS    
           END-IF.                                                      
           IF WS-NULL-IND2 < 0 THEN                                     
              MOVE SPACES                    TO SA-INT-DISP-END-TS      
           END-IF.                                                      
           IF WS-NULL-IND3 < 0 THEN                                     
              MOVE SPACES                    TO SA-EXT-DISP-START-TS    
           END-IF.                                                      
           IF WS-NULL-IND4 < 0 THEN                                     
              MOVE SPACES                    TO SA-EXT-DISP-END-TS      
           END-IF.                                                      
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              PERFORM 2300-SET-RETURNS       THRU 2300-EXIT             
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
              MOVE +0                        TO WS-ACTIVE-RETURN-CODE   
           WHEN NOT-FOUND                                               
              IF CTR-ROWS = 0                                           
                INITIALIZE GTT-RETURN-FIELDS                            
                           DCLCSS-SPCL-FCTR-APPL                        
                MOVE +100                    TO S-RETURN-CODE           
                MOVE +901                    TO S-APPL-RETURN-CODE      
                MOVE PARM-FACTOR-ID          TO SA-FACTOR-ID            
                MOVE PARM-CODE-UTIL-TYPE     TO SA-CODE-UTIL-TYPE       
                MOVE PARM-RATE-PLAN-NO       TO SA-RATE-PLAN-NO         
                MOVE PARM-CODE-STATUS        TO SA-CODE-STATUS          
                PERFORM 2300-SET-RETURNS     THRU 2300-EXIT             
                PERFORM 8100-SEND-RESULT     THRU 8100-EXIT             
                MOVE +100                    TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           WHEN OTHER                                                   
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '5250'                   TO ACTIVE-PARAGRAPH        
               MOVE 'FETCH'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                 
               MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1         
               MOVE  WS-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                 42248100
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42239500
      ******************************************************************42239600
      * 5500-OPEN-RATEFCT-CURSOR                                       *42239700
      *       -- THIS MODULE OPENS THE CURSOR THAT WILL CREATE THE     *42239800
      *          RESULT SET OF SPECIAL RATE FACTORS.                   *42239900
      ******************************************************************42240000
       5500-OPEN-RATEFCT-CURSOR.                                        
      *                                                                 42240200
           EXEC SQL                                                     
               OPEN FACTORRATE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42240800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '5500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1               
               MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1       
               MOVE WS-FACTOR-ID               TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42242400
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42242800
      ******************************************************************42242900
      * 5600-FETCH-RATEFCT-CURSOR                                      *42243000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF SPECIAL FACTOR   *42243100
      *        RATES.                                                  *42243200
      ******************************************************************42243300
       5600-FETCH-RATEFCT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH FACTORRATE                                         
                  INTO :SA-CODE-UTIL-TYPE,                              
                       :SA-RATE-PLAN-NO,                                
                       :SA-CMPNT-ID-CD,                                 
                       :SA-BLOCK-NO,                                    
                       :SA-VERS-PRORATE-CD,                             
                       :SA-CODE-SEASON,                                 
                       :SA-INSTR-USE-TYPE-CD,                           
                       :SA-CODE-TIME-PERIOD,                            
                       :SA-CODE-REVENUE-CLASS,                          
                       :SA-DATE-FROM,                                   
                       :SA-DATE-TO,                                     
                       :SA-FACTOR,                                      
                       :SA-CODE-STATUS,                                 
                       :SA-ENTRY-NO,                                    
                       :SA-USER-ID-UPD-BY,                              
                       :SA-LAST-UPDATE-TS,                              
                       :DUMMY-DATE,                                     
                       :DUMMY-DATE,                                     
                       :SA-INT-DISP-START-TS :WS-NULL-IND1,              
                       :SA-INT-DISP-END-TS :WS-NULL-IND2,                
                       :SA-EXT-DISP-START-TS :WS-NULL-IND3,              
                       :SA-EXT-DISP-END-TS :WS-NULL-IND4,                
                       :SA-FACTOR-ID,                                   
                       :SA-PROC-REQ-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42245500
           IF WS-NULL-IND1 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND2 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-END-TS                         
           END-IF.                                                      
           IF WS-NULL-IND3 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND4 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-END-TS                         
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              PERFORM 2300-SET-RETURNS     THRU 2300-EXIT               
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
              MOVE +0                   TO WS-ACTIVE-RETURN-CODE        
           WHEN NOT-FOUND                                               
              IF CTR-ROWS = 0                                           
                INITIALIZE GTT-RETURN-FIELDS                            
                           DCLCSS-SPCL-FCTR-APPL                        
                MOVE +100                 TO S-RETURN-CODE              
                MOVE +901                 TO S-APPL-RETURN-CODE         
                MOVE PARM-FACTOR-ID       TO SA-FACTOR-ID               
                MOVE PARM-CODE-UTIL-TYPE  TO SA-CODE-UTIL-TYPE          
                MOVE PARM-RATE-PLAN-NO    TO SA-RATE-PLAN-NO            
                MOVE PARM-CODE-STATUS     TO SA-CODE-STATUS             
                PERFORM 2300-SET-RETURNS     THRU 2300-EXIT             
                PERFORM 8100-SEND-RESULT     THRU 8100-EXIT             
                MOVE +100                 TO WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
           WHEN OTHER                                                   
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5600'          TO ACTIVE-PARAGRAPH                 
               MOVE 'FETCH'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1             
               MOVE  WS-FACTOR-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                 42248100
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42269600
      ******************************************************************42239600
      * 5700-OPEN-RATEDEPTFCT-CURSOR                                   *42239700
      *       -- THIS MODULE OPENS THE CURSOR THAT WILL CREATE THE     *42239800
      *          RESULT SET OF SPECIAL RATE FACTORS.                   *42239900
      ******************************************************************42240000
       5700-OPEN-RATEDEPTFCT-CURSOR.                                    
      *                                                                 42240200
           EXEC SQL                                                     
               OPEN FACTORRATEDEPT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42240800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '5700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1               
               MOVE 'RATE_DEPT_CD'             TO TABLE-ELEMENT-1       
               MOVE WS-RATE-DEPT-CD            TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42242400
       5700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42242800
      ******************************************************************42242900
      * 5800-FETCH-RATEDEPT-FCT-CURSOR                                 *42243000
      *     -- THIS MODULE FETCHES THE RESULT ROWS OF SPECIAL FACTOR   *42243100
      *        RATES.                                                  *42243200
      ******************************************************************42243300
       5800-FETCH-RATEDEPTFCT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               FETCH FACTORRATEDEPT                                     
                  INTO :SA-CODE-UTIL-TYPE,                              
                       :SA-RATE-PLAN-NO,                                
                       :SA-CMPNT-ID-CD,                                 
                       :SA-BLOCK-NO,                                    
                       :SA-VERS-PRORATE-CD,                             
                       :SA-CODE-SEASON,                                 
                       :SA-INSTR-USE-TYPE-CD,                           
                       :SA-CODE-TIME-PERIOD,                            
                       :SA-CODE-REVENUE-CLASS,                          
                       :SA-DATE-FROM,                                   
                       :SA-DATE-TO,                                     
                       :SA-FACTOR,                                      
                       :SA-CODE-STATUS,                                 
                       :SA-ENTRY-NO,                                    
                       :SA-USER-ID-UPD-BY,                              
                       :SA-LAST-UPDATE-TS,                              
                       :DUMMY-DATE,                                     
                       :DUMMY-DATE,                                     
                       :SA-INT-DISP-START-TS :WS-NULL-IND1,              
                       :SA-INT-DISP-END-TS :WS-NULL-IND2,                
                       :SA-EXT-DISP-START-TS :WS-NULL-IND3,              
                       :SA-EXT-DISP-END-TS :WS-NULL-IND4,                
                       :SA-FACTOR-ID,                                   
                       :SA-PROC-REQ-ID                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42245500
           IF WS-NULL-IND1 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND2 < 0 THEN                                     
              MOVE SPACES TO SA-INT-DISP-END-TS                         
           END-IF.                                                      
           IF WS-NULL-IND3 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-START-TS                       
           END-IF.                                                      
           IF WS-NULL-IND4 < 0 THEN                                     
              MOVE SPACES TO SA-EXT-DISP-END-TS                         
           END-IF.                                                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
              INITIALIZE GTT-RETURN-FIELDS                              
              PERFORM 2300-SET-RETURNS     THRU 2300-EXIT               
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
              MOVE +0                   TO WS-ACTIVE-RETURN-CODE        
           WHEN NOT-FOUND                                               
              IF CTR-ROWS = 0                                           
                INITIALIZE GTT-RETURN-FIELDS                            
                           DCLCSS-SPCL-FCTR-APPL                        
                MOVE +100                 TO S-RETURN-CODE              
                MOVE +901                 TO S-APPL-RETURN-CODE         
                MOVE PARM-FACTOR-ID       TO SA-FACTOR-ID               
                MOVE PARM-CODE-UTIL-TYPE  TO SA-CODE-UTIL-TYPE          
                MOVE PARM-RATE-PLAN-NO    TO SA-RATE-PLAN-NO            
                MOVE PARM-CODE-STATUS     TO SA-CODE-STATUS             
                PERFORM 2300-SET-RETURNS     THRU 2300-EXIT             
                PERFORM 8100-SEND-RESULT     THRU 8100-EXIT             
                MOVE +100                 TO WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
           WHEN OTHER                                                   
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5800'          TO ACTIVE-PARAGRAPH                 
               MOVE 'FETCH'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'RATE_DEPT_CD'       TO TABLE-ELEMENT-1             
               MOVE  WS-RATE-DEPT-CD     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                 42248100
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42269600
      ******************************************************************42269700
      * 7000-CLOSE-FACTOR-CURSOR                                       *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       7000-CLOSE-FACTOR-CURSOR.                                        
      *                                                                 42270200
           EXEC SQL                                                     
               CLOSE FACTORCURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42270700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7000'          TO ACTIVE-PARAGRAPH                 
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1             
               MOVE  WS-FACTOR-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42272300
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42269600
      ******************************************************************42269700
      * 7100-CLOSE-PROC-REQ-ID-CURSOR                                  *42269800
      *       -- THIS MODULE CLOSES THE PROC-REQ-ID CURSOR             *42269900
      ******************************************************************42270000
       7100-CLOSE-PROC-REQ-ID-CURSOR.                                   
      *                                                                 42270200
           EXEC SQL                                                     
               CLOSE PROC_REQ_ID_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42270700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7100'                   TO ACTIVE-PARAGRAPH        
               MOVE 'CLOSE'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                 
               MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1         
               MOVE  WS-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42272300
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42269600
      ******************************************************************42269700
      * 7500-CLOSE-RATEFCT-CURSOR                                      *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       7500-CLOSE-RATEFCT-CURSOR.                                       
      *                                                                 42270200
           EXEC SQL                                                     
               CLOSE FACTORRATE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42270700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7500'          TO ACTIVE-PARAGRAPH                 
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1             
               MOVE  WS-FACTOR-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42272300
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************42269700
      * 7600-CLOSE-RATEDEPTFCT-CURSOR                                  *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       7600-CLOSE-RATEDEPTFCT-CURSOR.                                   
      *                                                                 42270200
           EXEC SQL                                                     
               CLOSE FACTORRATEDEPT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42270700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7600'          TO ACTIVE-PARAGRAPH                 
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'RATE_DEPT_CD'       TO TABLE-ELEMENT-1             
               MOVE  WS-RATE-DEPT-CD     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42272300
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7110-SELECT-JOB-PARM                                           *        
      *       -- THIS MODULE SELECT UPDATABLE FACTOR-ID PARM           *        
      ******************************************************************        
       7110-SELECT-JOB-PARM.                                            
      *                                                                         
           MOVE '7110'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT PARM_DATA                                         
                 INTO :WS-PARM-DATA                                     
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = :WS-PRGM-NAME                      
                  AND CMND_CODE = :WS-CMND-CODE                         
                  AND STATUS = 'A'                                      
                  AND CIS.SUBSTR3(PARM_DATA,22,9) = :SA-FACTOR-ID            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PARM_DATA                                                 
MFA-TR*          INTO :WS-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = :WS-PRGM-NAME                              
MFA-TR*           AND CMND_CODE = :WS-CMND-CODE                                 
MFA-TR*           AND STATUS = 'A'                                              
MFA-TR*           AND SUBSTR(PARM_DATA,22,9) = :SA-FACTOR-ID                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7110'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_JOB_PARM'       TO TABLE-1                     
               MOVE 'FACTOR_ID'          TO TABLE-ELEMENT-1             
               MOVE  WS-FACTOR-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************42269700
      * 7120-CHECK-FACTOR-UPDATEABLE                                   *42269800
      *       -- THIS MODULE SELECT UPDATABLE FACTOR-ID PARM           *42269900
      ******************************************************************42270000
       7120-CHECK-FACTOR-UPDATEABLE.                                    
      *                                                                 42270200
           MOVE '7120'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-ALLOW-UPDATE                                  
                 FROM CSS_JOB_PARM                                      
                WHERE PROGRAM_NAME = :WS-PANEL-NO                       
                  AND CMND_CODE    = :WS-CMND-CODE                      
                  AND STATUS       = 'A'                                
                  AND CIS.SUBSTR3(PARM_DATA,11,9) = :SA-FACTOR-ID            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*        SELECT 'Y'                                               42270400
MFA-TR*          INTO :WS-ALLOW-UPDATE                                          
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = :WS-PANEL-NO                               
MFA-TR*           AND CMND_CODE    = :WS-CMND-CODE                              
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*           AND SUBSTR(PARM_DATA,11,9) = :SA-FACTOR-ID                    
MFA-TR*    END-EXEC.                                                    42270500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42270600
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7120'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_JOB_PARM'           TO TABLE-1                 
               MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1         
               MOVE  WS-FACTOR-ID            TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 42272200
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04518_R1                       
                  (    RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,FACTOR_ID                                        
                      ,CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,RATE_COMPONENT                                   
                      ,CODE_REVENUE_CLASS                               
                      ,START_DATE                                       
                      ,END_DATE                                         
                      ,FACTOR                                           
                      ,CODE_STATUS                                      
                      ,ENTRY_NO                                         
                      ,USER_ID_UPD_BY                                   
                      ,LAST_UPDATE_TS                                   
                      ,INT_DISP_START_TS                                
                      ,INT_DISP_END_TS                                  
                      ,EXT_DISP_START_TS                                
                      ,EXT_DISP_END_TS                                  
                      ,BLOCK_NO                                         
                      ,VERS_PRORATE_CD                                  
                      ,ALLOW_UPDATE                                     
                      ,PROC_REQ_ID                                      
                      ,FCTR_UPDATE_FL                                   
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-FACTOR-ID                                        
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-RATE-COMPONENT                                   
                   ,:S-CODE-REVENUE-CLASS                               
                   ,:S-START-DATE                                       
                   ,:S-END-DATE                                         
                   ,:S-FACTOR                                           
                   ,:S-CODE-STATUS                                      
                   ,:S-ENTRY-NO                                         
                   ,:S-USER-ID-UPD-BY                                   
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-INT-DISP-START-TS                                
                   ,:S-INT-DISP-END-TS                                  
                   ,:S-EXT-DISP-START-TS                                
                   ,:S-EXT-DISP-END-TS                                  
                   ,:S-BLOCK-NO                                         
                   ,:S-VERS-PRORATE-CD                                  
                   ,:S-ALLOW-UPDATE                                     
                   ,:S-PROC-REQ-ID                                      
                   ,:S-FCTR-UPDATE-FL                                   
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04518_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_COMPONENT                                           
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,START_DATE                                               
MFA-TR*               ,END_DATE                                                 
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,CODE_STATUS                                              
MFA-TR*               ,ENTRY_NO                                                 
MFA-TR*               ,USER_ID_UPD_BY                                           
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,INT_DISP_START_TS                                        
MFA-TR*               ,INT_DISP_END_TS                                          
MFA-TR*               ,EXT_DISP_START_TS                                        
MFA-TR*               ,EXT_DISP_END_TS                                          
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,VERS_PRORATE_CD                                          
MFA-TR*               ,ALLOW_UPDATE                                             
MFA-TR*               ,PROC_REQ_ID                                              
MFA-TR*               ,FCTR_UPDATE_FL                                           
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-FACTOR-ID                                                
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-RATE-PLAN-NO                                             
MFA-TR*            ,:S-RATE-COMPONENT                                           
MFA-TR*            ,:S-CODE-REVENUE-CLASS                                       
MFA-TR*            ,:S-START-DATE                                               
MFA-TR*            ,:S-END-DATE                                                 
MFA-TR*            ,:S-FACTOR                                                   
MFA-TR*            ,:S-CODE-STATUS                                              
MFA-TR*            ,:S-ENTRY-NO                                                 
MFA-TR*            ,:S-USER-ID-UPD-BY                                           
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-INT-DISP-START-TS                                        
MFA-TR*            ,:S-INT-DISP-END-TS                                          
MFA-TR*            ,:S-EXT-DISP-START-TS                                        
MFA-TR*            ,:S-EXT-DISP-END-TS                                          
MFA-TR*            ,:S-BLOCK-NO                                                 
MFA-TR*            ,:S-VERS-PRORATE-CD                                          
MFA-TR*            ,:S-ALLOW-UPDATE                                             
MFA-TR*            ,:S-PROC-REQ-ID                                              
MFA-TR*            ,:S-FCTR-UPDATE-FL                                           
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-APPL-RETURN-CODE           
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04518_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
