       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04517.                                          
       AUTHOR.       SIDDHARTHA SARKAR.                                 
COB303 DATE-WRITTEN. AUG 2011.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                 SOUTH CAROLINA ELECTRIC & GAS                **        
      ******************************************************************        
      **                  STORED PROCEDURE:  CSR04517                 **        
      ******************************************************************        
      **                          S U M M A R Y                       **        
      **                                                              **        
      **   CSR04517 :                                                 **        
      **                                                              **        
      **   1. INVOKED FROM THE NONE CALC BPA PANEL.                   **        
      **      A. UPDATE CSS_BILL_MANUAL/CSS_BILL_MAN_DET TABLES FOR   **        
      **         EDITED BILLS.                                        **        
      **      B. STORE DATA IMPORTED FROM EXCEL FOR MANUALLY BILLED   **        
      **         ACCOUNTS IN CSS_BILL_MANUAL/CSS_BILL_MAN_DET TABLES. **        
      **                                                              **        
      ******************************************************************        
      **   PARAMETERS                                                 **        
      **                                                              **        
      **       IN                                                     **        
      **             I_CALL_TYPE           CHAR(01)                   **        
      **             I_ACCOUNT_NO          CHAR(13)                   **        
      **             I_CODE_UTIL_TYPE      CHAR(01)                   **        
      **             I_IC_NO               CHAR(04)                   **        
      **             I_BILL_NO             CHAR(04)                   **        
      **             I_BILL_ITEM_TIMESTMP  CHAR(26)                   **        
      **             I_BILL_MAN_SOURCE_CD  CHAR(01)                   **        
      **             I_BILL_MAN_STATUS_CD  CHAR(01)                   **        
      **             I_RATE_PLAN_NO        CHAR(03)                   **        
      **             I_CODE_REVENUE_CLASS  CHAR(03)                   **        
      **             I_REVENUE_MONTH       CHAR(06)                   **        
      **             I_USAGE_END_DATE      CHAR(10)                   **        
      **             I_NO_OF_CONS_DAYS     CHAR(04)                   **        
      **             I_NEW_RATE_FROM_DT    CHAR(10)                   **        
      **             I_OLD_RATE_FROM_DT    CHAR(10)                   **        
      **             I_NEW_RATE_PCT        CHAR(05)                   **        
      **             I_REBILL_IND          CHAR(01)                   **        
      **             I_PRORATE_CD          CHAR(01)                   **        
      **             I_ACCT_CYCLE          CHAR(02)                   **        
      **             I_BILL_CALC_CYCLE     CHAR(02)                   **        
      **             I_BTU_FACTOR          CHAR(08)                   **        
      **             I_GAS_BASE_USE        CHAR(10)                   **        
      **             I_STATE_TAX_XMPT      CHAR(01)                   **        
      **             I_CITY_TAX_XMPT       CHAR(01)                   **        
      **             I_STATE_TAX_RATE      CHAR(06)                   **        
      **             I_CITY_TAX_RATE       CHAR(06)                   **        
      **             I_AMT_STATE_TAX       CHAR(10)                   **        
      **             I_AMT_CITY_TAX        CHAR(10)                   **        
      **             I_AMT_BILL_ITEM       CHAR(12)                   **        
      **             I_USAGE_CHARGES       CHAR(12)                   **        
      **             I_DEMAND_CHARGES      CHAR(12)                   **        
      **                                                              **        
      ****50 OCCURANCES FOR COMPONENTS. EACH AREA TO HAVE 1 COMPONENT **        
      ****WITH DETAILS FOR ALL 9 BLOCKS.                              **        
      **                                                              **        
      **             I_BC_ROW_DET_01 - 50  VARCHAR(659)               **        
      **                                                              **        
      ****200 OCCURANCES FOR BILL ADJUSTMENTS. EACH AREA TO HAVE DTLS **        
      ****FOR 20 ADJUSTMENTS.                                         **        
      **                                                              **        
      **             I_BA_ROW_DET_01 - 20  VARCHAR(862)               **        
      **                                                              **        
      **       OUT                                                    **        
      **             NONE                                             **        
      **                                                              **        
      **       INOUT                                                  **        
      **             NONE                                             **        
      **                                                              **        
      **       RESULT SET                                             **        
      **                                                              **        
      **             RETURN_CODE           INTEGER                    **        
      **                                                              **        
      ******************************************************************        
      **                 PROGRAM MODIFICATION LOG.                    **        
      **                                                              **        
      **   DATE          INITIALS    COMMENTS                         **        
      **   ----------    --------    ---------------------------------**        
      **   08/10/2011    SS97726     INITIAL VERSION.                 **        
ACT004**   06/01/2016    TP7R341     REMOVE UNWANTED COLUMNS FROM     **        
ACT004**    A04177                   TABLE CSS_SPCL_FCTR              **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04517'.
MSQ017     COPY MFASQLM.
                                                                        
      **** DB2 INCLUDES                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MANUAL, NG                                                  
           EXEC SQL                                                             
               INCLUDE TBBILMNL                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MAN_DET, NU                                                 
           EXEC SQL                                                             
               INCLUDE TBBILMDE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_HDR, BI                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_DET, BG                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SPCL_FCTR, SF                                                    
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_WINDOW, BN                                                  
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_ADJUSTMNT, BP                                               
           EXEC SQL                                                             
               INCLUDE TBBILADJ                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CNSMPTN_HIST, CX                                                 
            EXEC SQL                                                            
               INCLUDE TBCNSMP                                                  
            END-EXEC.                                                           
      *                                                                         
      **** CSS_CUST_PLAN, CP                                                    
            EXEC SQL                                                            
               INCLUDE TBCSTPLN                                                 
            END-EXEC.                                                           
      *                                                                         
      **** CSS_UM_CNSMPT_HIST, UC                                               
            EXEC SQL                                                            
               INCLUDE TBUMCNSM                                                 
            END-EXEC.                                                           
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MNT_TRANS_HIST, MH                                               
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MT_TRN_HST_DET, MI                                               
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04517'. 
           05 WS-TRAN-APPL-NO               PIC S9(04) COMP VALUE +1.   
           05 WS-N                          PIC X(01) VALUE 'N'.        
           05 GTT-NAME                      PIC X(26)                   
                                            VALUE 'SESSION.CSR04517_R1'.
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05 GTT-ROW.                                                  
              49 GTT-ROW-LEN                PIC S9(04) COMP.            
              49 GTT-ROW-CHAR               PIC X(1024).                
           05 GTT-SQLCODE                   PIC S9(9)  COMP.            
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
           05  WS-ROW-COUNT                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-CHARGES-EDITED            PIC X(01) VALUE 'N'.        
               88 CHARGES-EDITED                      VALUE 'Y'.        
               88 CHARGES-NOT-EDITED                  VALUE 'N'.        
           05  WS-ADJUSTMENTS-EDITED        PIC X(01) VALUE 'N'.        
               88 ADJUSTMENTS-EDITED                  VALUE 'Y'.        
               88 ADJUSTMENTS-NOT-EDITED              VALUE 'N'.        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
           05  S-BUS-RULE-TYPE              PIC X(06) VALUE SPACES.     
           05  S-BUS-RULE-RESULT            PIC X(01) VALUE SPACES.     
           05  S-ERROR-CODE                 PIC S9(09) COMP VALUE 0.    
      *                                                                         
       01  WS-PARM-BC-UPD-DATA.                                         
           49  WS-PARM-BC-UPD-DATA-LEN      PIC S9(4) USAGE COMP.       
           49  WS-PARM-BC-UPD-DATA-TEXT     PIC X(657).                 
      *                                                                         
       01  WS-PARM-BA-UPD-DATA.                                         
           49  WS-PARM-BA-UPD-DATA-LEN      PIC S9(4) USAGE COMP.       
           49  WS-PARM-BA-UPD-DATA-TEXT     PIC X(860).                 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-CALL-TYPE               PIC X(01).                  
           05  PARM-ACCOUNT-NO              PIC X(13).                  
           05  PARM-ACCOUNT-NO-NUM      REDEFINES                       
                   PARM-ACCOUNT-NO          PIC 9(13).                  
           05  PARM-CODE-UTIL-TYPE          PIC X(01).                  
           05  PARM-IC-NO                   PIC X(04).                  
           05  PARM-IC-NO-NUM           REDEFINES                       
                   PARM-IC-NO               PIC 9(04).                  
           05  PARM-BILL-NO                 PIC X(04).                  
           05  PARM-BILL-NO-NUM         REDEFINES                       
                   PARM-BILL-NO             PIC 9(04).                  
           05  PARM-BILL-ITEM-TIMESTMP      PIC X(26).                  
           05  PARM-BILL-MAN-SOURCE-CD      PIC X(01).                  
           05  PARM-BILL-MAN-STATUS-CD      PIC X(01).                  
           05  PARM-RATE-PLAN-NO            PIC X(03).                  
           05  PARM-CODE-REVENUE-CLASS      PIC X(03).                  
           05  PARM-REVENUE-MONTH           PIC X(06).                  
           05  PARM-REVENUE-MONTH-NUM   REDEFINES                       
                   PARM-REVENUE-MONTH       PIC 9(06).                  
           05  PARM-USAGE-END-DATE          PIC X(10).                  
           05  PARM-NO-OF-CONS-DAYS         PIC X(04).                  
           05  PARM-NO-OF-CONS-DAYS-NUM REDEFINES                       
                   PARM-NO-OF-CONS-DAYS     PIC 9(04).                  
           05  PARM-NEW-RATE-FROM-DT        PIC X(10).                  
           05  PARM-OLD-RATE-FROM-DT        PIC X(10).                  
           05  PARM-NEW-RATE-PCT.                                       
               10  PARM-NEW-RATE-PCT-SGN    PIC X(01).                  
               10  PARM-NEW-RATE-PCT-VAL    PIC X(04).                  
           05  PARM-REBILL-IND              PIC X(01).                  
           05  PARM-PRORATE-CD              PIC X(01).                  
           05  PARM-ACCT-CYCLE              PIC X(02).                  
           05  PARM-BILL-CALC-CYCLE         PIC X(02).                  
           05  PARM-BTU-FACTOR.                                         
               10  PARM-BTU-FACTOR-SGN      PIC X(01).                  
               10  PARM-BTU-FACTOR-VAL      PIC X(07).                  
           05  PARM-GAS-BASE-USE.                                       
               10  PARM-GAS-BASE-USE-SGN    PIC X(01).                  
               10  PARM-GAS-BASE-USE-VAL    PIC X(09).                  
           05  PARM-STATE-TAX-XMPT          PIC X(01).                  
           05  PARM-CITY-TAX-XMPT           PIC X(01).                  
           05  PARM-STATE-TAX-RATE.                                     
               10  PARM-STATE-TAX-RATE-SGN  PIC X(01).                  
               10  PARM-STATE-TAX-RATE-VAL  PIC X(05).                  
           05  PARM-CITY-TAX-RATE.                                      
               10  PARM-CITY-TAX-RATE-SGN   PIC X(01).                  
               10  PARM-CITY-TAX-RATE-VAL   PIC X(05).                  
           05  PARM-AMT-STATE-TAX.                                      
               10  PARM-AMT-STATE-TAX-SGN   PIC X(01).                  
               10  PARM-AMT-STATE-TAX-VAL   PIC X(09).                  
           05  PARM-AMT-CITY-TAX.                                       
               10  PARM-AMT-CITY-TAX-SGN    PIC X(01).                  
               10  PARM-AMT-CITY-TAX-VAL    PIC X(09).                  
           05  PARM-AMT-BILL-ITEM.                                      
               10  PARM-AMT-BILL-ITEM-SGN   PIC X(01).                  
               10  PARM-AMT-BILL-ITEM-VAL   PIC X(11).                  
           05  PARM-USAGE-CHARGES.                                      
               10  PARM-USAGE-CHARGES-SGN   PIC X(01).                  
               10  PARM-USAGE-CHARGES-VAL   PIC X(11).                  
           05  PARM-DEMAND-CHARGES.                                     
               10  PARM-DEMAND-CHARGES-SGN  PIC X(01).                  
               10  PARM-DEMAND-CHARGES-VAL  PIC X(11).                  
           05  PARM-BC-ROW-DET-01           PIC X(657).                 
           05  PARM-BC-ROW-DET-02           PIC X(657).                 
           05  PARM-BC-ROW-DET-03           PIC X(657).                 
           05  PARM-BC-ROW-DET-04           PIC X(657).                 
           05  PARM-BC-ROW-DET-05           PIC X(657).                 
           05  PARM-BC-ROW-DET-06           PIC X(657).                 
           05  PARM-BC-ROW-DET-07           PIC X(657).                 
           05  PARM-BC-ROW-DET-08           PIC X(657).                 
           05  PARM-BC-ROW-DET-09           PIC X(657).                 
           05  PARM-BC-ROW-DET-10           PIC X(657).                 
           05  PARM-BC-ROW-DET-11           PIC X(657).                 
           05  PARM-BC-ROW-DET-12           PIC X(657).                 
           05  PARM-BC-ROW-DET-13           PIC X(657).                 
           05  PARM-BC-ROW-DET-14           PIC X(657).                 
           05  PARM-BC-ROW-DET-15           PIC X(657).                 
           05  PARM-BC-ROW-DET-16           PIC X(657).                 
           05  PARM-BC-ROW-DET-17           PIC X(657).                 
           05  PARM-BC-ROW-DET-18           PIC X(657).                 
           05  PARM-BC-ROW-DET-19           PIC X(657).                 
           05  PARM-BC-ROW-DET-20           PIC X(657).                 
           05  PARM-BC-ROW-DET-21           PIC X(657).                 
           05  PARM-BC-ROW-DET-22           PIC X(657).                 
           05  PARM-BC-ROW-DET-23           PIC X(657).                 
           05  PARM-BC-ROW-DET-24           PIC X(657).                 
           05  PARM-BC-ROW-DET-25           PIC X(657).                 
           05  PARM-BC-ROW-DET-26           PIC X(657).                 
           05  PARM-BC-ROW-DET-27           PIC X(657).                 
           05  PARM-BC-ROW-DET-28           PIC X(657).                 
           05  PARM-BC-ROW-DET-29           PIC X(657).                 
           05  PARM-BC-ROW-DET-30           PIC X(657).                 
           05  PARM-BC-ROW-DET-31           PIC X(657).                 
           05  PARM-BC-ROW-DET-32           PIC X(657).                 
           05  PARM-BC-ROW-DET-33           PIC X(657).                 
           05  PARM-BC-ROW-DET-34           PIC X(657).                 
           05  PARM-BC-ROW-DET-35           PIC X(657).                 
           05  PARM-BC-ROW-DET-36           PIC X(657).                 
           05  PARM-BC-ROW-DET-37           PIC X(657).                 
           05  PARM-BC-ROW-DET-38           PIC X(657).                 
           05  PARM-BC-ROW-DET-39           PIC X(657).                 
           05  PARM-BC-ROW-DET-40           PIC X(657).                 
           05  PARM-BC-ROW-DET-41           PIC X(657).                 
           05  PARM-BC-ROW-DET-42           PIC X(657).                 
           05  PARM-BC-ROW-DET-43           PIC X(657).                 
           05  PARM-BC-ROW-DET-44           PIC X(657).                 
           05  PARM-BC-ROW-DET-45           PIC X(657).                 
           05  PARM-BC-ROW-DET-46           PIC X(657).                 
           05  PARM-BC-ROW-DET-47           PIC X(657).                 
           05  PARM-BC-ROW-DET-48           PIC X(657).                 
           05  PARM-BC-ROW-DET-49           PIC X(657).                 
           05  PARM-BC-ROW-DET-50           PIC X(657).                 
           05  PARM-BA-ROW-DET-01           PIC X(860).                 
           05  PARM-BA-ROW-DET-02           PIC X(860).                 
           05  PARM-BA-ROW-DET-03           PIC X(860).                 
           05  PARM-BA-ROW-DET-04           PIC X(860).                 
           05  PARM-BA-ROW-DET-05           PIC X(860).                 
           05  PARM-BA-ROW-DET-06           PIC X(860).                 
           05  PARM-BA-ROW-DET-07           PIC X(860).                 
           05  PARM-BA-ROW-DET-08           PIC X(860).                 
           05  PARM-BA-ROW-DET-09           PIC X(860).                 
           05  PARM-BA-ROW-DET-10           PIC X(860).                 
           05  PARM-BA-ROW-DET-11           PIC X(860).                 
           05  PARM-BA-ROW-DET-12           PIC X(860).                 
           05  PARM-BA-ROW-DET-13           PIC X(860).                 
           05  PARM-BA-ROW-DET-14           PIC X(860).                 
           05  PARM-BA-ROW-DET-15           PIC X(860).                 
           05  PARM-BA-ROW-DET-16           PIC X(860).                 
           05  PARM-BA-ROW-DET-17           PIC X(860).                 
           05  PARM-BA-ROW-DET-18           PIC X(860).                 
           05  PARM-BA-ROW-DET-19           PIC X(860).                 
           05  PARM-BA-ROW-DET-20           PIC X(860).                 
      *                                                                         
       01  WS-BC-DATA-PARSED.                                           
           05  WS-BC-PARSE-ACTION-IND                 PIC X(1).         
           05  WS-BC-PARSE-SEQ-NO                     PIC X(4).         
           05  WS-BC-PARSE-SEQ-NO-NUM   REDEFINES                       
                  WS-BC-PARSE-SEQ-NO                  PIC 9(4).         
           05  WS-BC-PARSE-COMPONENT-ID               PIC X(3).         
           05  WS-BC-PARSE-CNSMPTN-TYPE               PIC X(1).         
           05  WS-BC-PARSE-REGISTER-TYPE              PIC X(1).         
           05  WS-BC-PARSE-CODE-TOU                   PIC X(1).         
           05  WS-BC-PARSE-CD-TOU-NUM   REDEFINES                       
                  WS-BC-PARSE-CODE-TOU                PIC 9(1).         
           05  WS-BC-PARSE-CODE-SEASON                PIC X(1).         
           05  WS-BC-PARSE-RATE-VERSION               PIC X(1).         
           05  WS-BC-PARSE-NET-SEL-RSN                PIC X(1).         
           05  WS-BC-PARSE-READ-UNITS.                                  
               10  WS-BC-PARSE-READ-UNITS-SGN         PIC X(1).         
               10  WS-BC-PARSE-READ-UNITS-VAL         PIC X(9).         
           05  WS-BC-PARSE-CALC-AMT.                                    
               10  WS-BC-PARSE-CALC-AMT-SGN           PIC X(1).         
               10  WS-BC-PARSE-CALC-AMT-VAL           PIC X(11).        
           05  WS-BC-PARSE-NET-AMT.                                     
               10  WS-BC-PARSE-NET-AMT-SGN            PIC X(1).         
               10  WS-BC-PARSE-NET-AMT-VAL            PIC X(11).        
           05  WS-BC-PARSE-EVENT-NO                   PIC X(2).         
           05  WS-BC-PARSE-EVENT-NO-NUM REDEFINES                       
                  WS-BC-PARSE-EVENT-NO                PIC 9(2).         
           05  WS-BC-PARSE-EVENT-DATE                 PIC X(10).        
           05  WS-BC-PARSE-BLOCK-DETAILS                                
                  OCCURS 9 TIMES                                        
                  INDEXED BY WS-BC-PARSE-BLK-INDX.                      
               10  WS-BC-PARSE-BLOCK-SIZE.                              
                   15  WS-BC-PARSE-BLOCK-SIZE-SGN     PIC X(1).         
                   15  WS-BC-PARSE-BLOCK-SIZE-VAL     PIC X(9).         
               10  WS-BC-PARSE-UNITS-BILLED.                            
                   15  WS-BC-PARSE-UNITS-BILLED-SGN   PIC X(1).         
                   15  WS-BC-PARSE-UNITS-BILLED-VAL   PIC X(13).        
               10  WS-BC-PARSE-PRICE-TYPE-CD          PIC X(1).         
               10  WS-BC-PARSE-AMT-BASE-RATE.                           
                   15  WS-BC-PARSE-AMT-BASE-RATE-SGN  PIC X(1).         
                   15  WS-BC-PARSE-AMT-BASE-RATE-VAL  PIC X(11).        
               10  WS-BC-PARSE-AMT-NET-RATE.                            
                   15  WS-BC-PARSE-AMT-NET-RATE-SGN   PIC X(1).         
                   15  WS-BC-PARSE-AMT-NET-RATE-VAL   PIC X(11).        
               10  WS-BC-PARSE-AMT-BLOCK.                               
                   15  WS-BC-PARSE-AMT-BLOCK-SGN      PIC X(1).         
                   15  WS-BC-PARSE-AMT-BLOCK-VAL      PIC X(11).        
      *                                                                         
       01  WS-BC-DATA-LAYOUT.                                           
           05  WS-BC-DET-DATA                                           
                  OCCURS 200 TIMES                                      
                  INDEXED BY WS-BC-DET-INDX.                            
               10  WS-BC-DET-ACTION-IND          PIC X(1).              
               10  WS-BC-DET-SEQ-NO              PIC S9(4) USAGE COMP.  
               10  WS-BC-DET-COMPONENT-ID        PIC X(3).              
               10  WS-BC-DET-CNSMPTN-TYPE        PIC X(1).              
               10  WS-BC-DET-REGISTER-TYPE       PIC X(1).              
               10  WS-BC-DET-CODE-TOU            PIC 9(1).              
               10  WS-BC-DET-CODE-SEASON         PIC X(1).              
               10  WS-BC-DET-RATE-VERSION        PIC X(1).              
               10  WS-BC-DET-NET-SEL-RSN         PIC X(1).              
COB305         10 WS-BC-DET-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.
COB305         10 WS-BC-DET-CALC-CMPNT-AMT        PIC S9(9)V9(2) COMP-3 
COB305           VALUE 0.
COB305         10 WS-BC-DET-NET-CMPNT-AMT        PIC S9(9)V9(2) COMP-3 
COB305           VALUE 0.
               10  WS-BC-DET-EVENT-NO            PIC 9(2).              
               10  WS-BC-DET-EVENT-DATE          PIC X(10).             
               10  WS-BC-DET-BLOCK-DETAILS                              
                      OCCURS 9 TIMES                                    
                      INDEXED BY WS-BC-DET-BLK-INDX.                    
COB305             15 WS-BC-DET-BLOCK-SIZE        PIC S9(9) COMP-3 
COB305               VALUE 0.
COB305             15 WS-BC-DET-UNITS-BILLED        PIC S9(9)V9(4) 
COB305               COMP-3 VALUE 0.
                   15  WS-BC-DET-PRICE-TYPE-CD   PIC X(1).              
COB305             15 WS-BC-DET-AMT-BASE-RATE        PIC S9(5)V9(6) 
COB305               COMP-3 VALUE 0.
COB305             15 WS-BC-DET-AMT-NET-RATE        PIC S9(5)V9(6) 
COB305               COMP-3 VALUE 0. 
COB305             15 WS-BC-DET-AMT-BLOCK        PIC S9(9)V9(2) COMP-3 
COB305               VALUE 0.
      *                                                                         
       01  WS-BA-DATA-PARSED.                                           
           05  WS-BA-DATA-PARSED-DET                                    
                  OCCURS 10 TIMES                                       
                  INDEXED BY WS-BA-PARSE-INDX.                          
               10  WS-BA-PARSE-ACTION-IND             PIC X(1).         
               10  WS-BA-PARSE-SEQ-NO                 PIC X(4).         
               10  WS-BA-PARSE-SEQ-NO-NUM     REDEFINES                 
                      WS-BA-PARSE-SEQ-NO              PIC 9(4).         
      ***COMPONENT KEY TO RELATE CORRESPONDING BILL COMPONENT                   
               10  WS-BA-PARSE-COMPONENT-ID           PIC X(3).         
               10  WS-BA-PARSE-CNSMPTN-TYPE           PIC X(1).         
               10  WS-BA-PARSE-REGISTER-TYPE          PIC X(1).         
               10  WS-BA-PARSE-CODE-TOU               PIC X(1).         
               10  WS-BA-PARSE-CODE-TOU-NUM   REDEFINES                 
                      WS-BA-PARSE-CODE-TOU            PIC 9(1).         
               10  WS-BA-PARSE-CODE-SEASON            PIC X(1).         
               10  WS-BA-PARSE-RATE-VERSION           PIC X(1).         
      ***END COMPONENT KEY                                                      
               10  WS-BA-PARSE-FACTOR-ID              PIC X(9).         
               10  WS-BA-PARSE-BLOCK-NO               PIC X(4).         
               10  WS-BA-PARSE-BLOCK-NO-NUM   REDEFINES                 
                      WS-BA-PARSE-BLOCK-NO            PIC 9(4).         
               10  WS-BA-PARSE-ADJ-UNITS.                               
                   15  WS-BA-PARSE-ADJ-UNITS-SGN      PIC X(1).         
                   15  WS-BA-PARSE-ADJ-UNITS-VAL      PIC X(15).        
               10  WS-BA-PARSE-ADJ-FACTOR.                              
                   15  WS-BA-PARSE-ADJ-FACTOR-SGN     PIC X(1).         
                   15  WS-BA-PARSE-ADJ-FACTOR-VAL     PIC X(15).        
               10  WS-BA-PARSE-ADJ-AMT.                                 
                   15  WS-BA-PARSE-ADJ-AMT-SGN        PIC X(1).         
                   15  WS-BA-PARSE-ADJ-AMT-VAL        PIC X(15).        
               10  WS-BA-PARSE-RATE-FROM-DT           PIC X(10).        
               10  WS-BA-PARSE-ST-TAX-XMPT            PIC X(1).         
               10  WS-BA-PARSE-CITY-TAX-XMPT          PIC X(1).         
      *                                                                         
       01  WS-BA-DATA-LAYOUT.                                           
           05  WS-BA-DET-DATA                                           
                  OCCURS 200 TIMES                                      
                  INDEXED BY WS-BA-DET-INDX.                            
               10  WS-BA-DET-ACTION-IND     PIC X(1).                   
               10  WS-BA-DET-SEQ-NO         PIC S9(4)       USAGE COMP. 
      ***COMPONENT KEY TO RELATE CORRESPONDING BILL COMPONENT                   
               10  WS-BA-DET-COMPONENT-ID   PIC X(3).                   
               10  WS-BA-DET-CNSMPTN-TYPE   PIC X(1).                   
               10  WS-BA-DET-REGISTER-TYPE  PIC X(1).                   
               10  WS-BA-DET-CODE-TOU       PIC 9(1).                   
               10  WS-BA-DET-CODE-SEASON    PIC X(1).                   
               10  WS-BA-DET-RATE-VERSION   PIC X(1).                   
      ***END COMPONENT KEY                                                      
               10  WS-BA-DET-FACTOR-ID      PIC X(9).                   
               10  WS-BA-DET-BLOCK-NO       PIC S9(4)       USAGE COMP. 
COB305         10 WS-BA-DET-ADJ-UNITS        PIC S9(9)V9(6) COMP-3 
COB305           VALUE 0.     
COB305         10 WS-BA-DET-ADJ-FACTOR        PIC S9(9)V9(6) COMP-3 
COB305           VALUE 0.     
COB305         10 WS-BA-DET-ADJ-AMT        PIC S9(9)V9(6) COMP-3 
COB305           VALUE 0.     
               10  WS-BA-DET-RATE-FROM-DT   PIC X(10).                  
               10  WS-BA-DET-ST-TAX-XMPT    PIC X(1).                   
               10  WS-BA-DET-CITY-TAX-XMPT  PIC X(1).                   
      *                                                                         
       01  WS-MISC-PROG-VARS.                                           
           05  WS-DECIMAL-9V4-NUM           PIC S9(13).                 
           05  WS-DECIMAL-9V4-NUM-RED  REDEFINES WS-DECIMAL-9V4-NUM     
                                            PIC S9(9)V9(4).             
           05  WS-DECIMAL-5V6-NUM           PIC S9(11).                 
           05  WS-DECIMAL-5V6-NUM-RED  REDEFINES WS-DECIMAL-5V6-NUM     
                                            PIC S9(5)V9(6).             
           05  WS-DECIMAL-9V2-NUM           PIC S9(11).                 
           05  WS-DECIMAL-9V2-NUM-RED  REDEFINES WS-DECIMAL-9V2-NUM     
                                            PIC S9(9)V9(2).             
           05  WS-DECIMAL-9V6-NUM           PIC S9(15).                 
           05  WS-DECIMAL-9V6-NUM-RED  REDEFINES WS-DECIMAL-9V6-NUM     
                                            PIC S9(9)V9(6).             
           05  WS-DECIMAL-0V4-NUM           PIC S9(4).                  
           05  WS-DECIMAL-0V4-NUM-RED  REDEFINES WS-DECIMAL-0V4-NUM     
                                            PIC SV9(4).                 
           05  WS-DECIMAL-2V5-NUM           PIC S9(7).                  
           05  WS-DECIMAL-2V5-NUM-RED  REDEFINES WS-DECIMAL-2V5-NUM     
                                            PIC S9(2)V9(5).             
           05  WS-DECIMAL-2V3-NUM           PIC S9(5).                  
           05  WS-DECIMAL-2V3-NUM-RED  REDEFINES WS-DECIMAL-2V3-NUM     
                                            PIC S9(2)V9(3).             
           05  WS-DECIMAL-7V2-NUM           PIC S9(9).                  
           05  WS-DECIMAL-7V2-NUM-RED  REDEFINES WS-DECIMAL-7V2-NUM     
                                            PIC S9(7)V9(2).             
           05  WS-DECIMAL-1V2-NUM           PIC S9(3).                  
           05  WS-DECIMAL-1V2-NUM-RED  REDEFINES WS-DECIMAL-1V2-NUM     
                                            PIC S9(1)V9(2).             
      *                                                                         
       01  WS-MISC-VARIABLES.                                           
           05  WS-NXT-BILL-MAN-DET-SEQ      PIC S9(4) USAGE COMP.       
           05  WS-BG-MAN-DET-SEQ            PIC S9(4) USAGE COMP.       
           05  WS-NU-TBL1                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL2                   PIC S9(9) COMP VALUE 0.     
COB305     05 WS-HOLD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-CMPR-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-USAGE-CHARGES        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-DEMAND-CHARGES        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-STATE-TAX        PIC S9(7)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-FRANCHISE-TAX        PIC S9(7)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-GAS-BASE-USAGE        PIC S9(9)V COMP-3 VALUE 0.        
COB305     05 WS-HOLD-TOT-CMPNT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.        
           05  WS-CURRENT-TS                PIC X(26).                  
           05  WS-BFC-DELETED-FLAG          PIC X(01) VALUE 'N'.        
      *                                                                         
       01  WS-TRAN-COMMENT-DETAIL.                                      
           05  FILLER                       PIC X(10) VALUE             
                                              ' Bill No: '.             
           05  WS-TRAN-BILL-NO              PIC X(4)  VALUE SPACES.     
           05  FILLER                       PIC X(8)  VALUE             
                                              ' Ic No: '.               
           05  WS-TRAN-IC-NO                PIC X(4)  VALUE SPACES.     
           05  FILLER                       PIC X(10) VALUE             
                                              ' Utility: '.             
           05  WS-TRAN-UTIL-TYPE            PIC X(1)  VALUE SPACES.     
           05  FILLER                       PIC X(10) VALUE             
                                              ' Bill TS: '.             
           05  WS-TRAN-BILL-TIMESTMP        PIC X(26) VALUE SPACES.     
           05  WS-DET-FILLER-01             PIC X(2)  VALUE SPACES.     
           05  WS-TRAN-COMMENT-01           PIC X(50) VALUE SPACES.     
           05  WS-DET-FILLER-02             PIC X(2)  VALUE SPACES.     
           05  WS-TRAN-COMMENT-02           PIC X(50) VALUE SPACES.     
           05  WS-END-FILLER                PIC X(33) VALUE SPACES.     
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(4) COMP.             
           05  WS-NULL-IND-02               PIC S9(4) COMP.             
           05  WS-NULL-IND-03               PIC S9(4) COMP.             
           05  WS-NULL-IND-04               PIC S9(4) COMP.             
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      **** TABLE IDS USED IN BE00 FILES                                         
           COPY CWS00050.                                                       
      *                                                                         
      **** BILL EXTRACT INFORMATION (FCSBE00)                                   
           COPY CWS1000A.                                                       
           COPY CWS1000B.                                                       
                                                                        
      **** COPYBOOKS NEEDED TO CALL CPD04517 ROUTINE                            
           EXEC SQL                                                             
               INCLUDE CWS04517                                                 
           END-EXEC.                                                            
                                                                        
      **** COPYBOOKS NEEDED TO CALL BILL CALCULATION ROUTINE                    
           EXEC SQL                                                             
               INCLUDE CWS0022B                                                 
           END-EXEC.                                                            
                                                                        
           COPY CWS0024B.                                                       
           COPY CWS1001A.                                                       
           COPY CWS1001B.                                                       
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
      *                                                                         
      **** CURSOR TO GET THE BG, BC DATA                                        
      *                                                                         
           EXEC SQL                                                     
              DECLARE BILL_MAN_DET CURSOR FOR                           
                 SELECT NU.BILL_MAN_DET_SEQ                             
                       ,NU.BILL_MANUAL_TBL_ID                           
                       ,NU.BILL_MANUAL_DATA                             
                   FROM CSS_BILL_MAN_DET  NU WITH(READUNCOMMITTED)              
                  WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO          
                    AND NU.BILL_NO            = :NU-BILL-NO             
                    AND NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE      
                    AND NU.IC_NO              = :NU-IC-NO               
                    AND NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )  
                    AND NU.BILL_MANUAL_TBL_ID IN (:WS-NU-TBL1           
                                                 ,:WS-NU-TBL2)          
                  ORDER BY NU.BILL_MANUAL_TBL_ID                        
                          ,NU.BILL_MAN_DET_SEQ                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL_MAN_DET CURSOR FOR                                   
MFA-TR*          SELECT NU.BILL_MAN_DET_SEQ                                     
MFA-TR*                ,NU.BILL_MANUAL_TBL_ID                                   
MFA-TR*                ,NU.BILL_MANUAL_DATA                                     
MFA-TR*            FROM CSS_BILL_MAN_DET  NU                                    
MFA-TR*           WHERE NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                  
MFA-TR*             AND NU.BILL_NO            = :NU-BILL-NO                     
MFA-TR*             AND NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE              
MFA-TR*             AND NU.IC_NO              = :NU-IC-NO                       
MFA-TR*             AND NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP          
MFA-TR*             AND NU.BILL_MANUAL_TBL_ID IN (:WS-NU-TBL1                   
MFA-TR*                                          ,:WS-NU-TBL2)                  
MFA-TR*           ORDER BY NU.BILL_MANUAL_TBL_ID                                
MFA-TR*                   ,NU.BILL_MAN_DET_SEQ                                  
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE                   PIC X(01).                  
       01  LINK-ACCOUNT-NO                  PIC X(13).                  
       01  LINK-CODE-UTIL-TYPE              PIC X(01).                  
       01  LINK-IC-NO                       PIC X(04).                  
       01  LINK-BILL-NO                     PIC X(04).                  
       01  LINK-BILL-ITEM-TIMESTMP          PIC X(26).                  
       01  LINK-BILL-MAN-SOURCE-CD          PIC X(01).                  
       01  LINK-BILL-MAN-STATUS-CD          PIC X(01).                  
       01  LINK-RATE-PLAN-NO                PIC X(03).                  
       01  LINK-CODE-REVENUE-CLASS          PIC X(03).                  
       01  LINK-REVENUE-MONTH               PIC X(06).                  
       01  LINK-USAGE-END-DATE              PIC X(10).                  
       01  LINK-NO-OF-CONS-DAYS             PIC X(04).                  
       01  LINK-NEW-RATE-FROM-DT            PIC X(10).                  
       01  LINK-OLD-RATE-FROM-DT            PIC X(10).                  
       01  LINK-NEW-RATE-PCT                PIC X(05).                  
       01  LINK-REBILL-IND                  PIC X(01).                  
       01  LINK-PRORATE-CD                  PIC X(01).                  
       01  LINK-ACCT-CYCLE                  PIC X(02).                  
       01  LINK-BILL-CALC-CYCLE             PIC X(02).                  
       01  LINK-BTU-FACTOR                  PIC X(08).                  
       01  LINK-GAS-BASE-USE                PIC X(10).                  
       01  LINK-STATE-TAX-XMPT              PIC X(01).                  
       01  LINK-CITY-TAX-XMPT               PIC X(01).                  
       01  LINK-STATE-TAX-RATE              PIC X(06).                  
       01  LINK-CITY-TAX-RATE               PIC X(06).                  
       01  LINK-AMT-STATE-TAX               PIC X(10).                  
       01  LINK-AMT-CITY-TAX                PIC X(10).                  
       01  LINK-AMT-BILL-ITEM               PIC X(12).                  
       01  LINK-USAGE-CHARGES               PIC X(12).                  
       01  LINK-DEMAND-CHARGES              PIC X(12).                  
       01  LINK-BC-ROW-DET-01               PIC X(659).                 
       01  LINK-BC-ROW-DET-02               PIC X(659).                 
       01  LINK-BC-ROW-DET-03               PIC X(659).                 
       01  LINK-BC-ROW-DET-04               PIC X(659).                 
       01  LINK-BC-ROW-DET-05               PIC X(659).                 
       01  LINK-BC-ROW-DET-06               PIC X(659).                 
       01  LINK-BC-ROW-DET-07               PIC X(659).                 
       01  LINK-BC-ROW-DET-08               PIC X(659).                 
       01  LINK-BC-ROW-DET-09               PIC X(659).                 
       01  LINK-BC-ROW-DET-10               PIC X(659).                 
       01  LINK-BC-ROW-DET-11               PIC X(659).                 
       01  LINK-BC-ROW-DET-12               PIC X(659).                 
       01  LINK-BC-ROW-DET-13               PIC X(659).                 
       01  LINK-BC-ROW-DET-14               PIC X(659).                 
       01  LINK-BC-ROW-DET-15               PIC X(659).                 
       01  LINK-BC-ROW-DET-16               PIC X(659).                 
       01  LINK-BC-ROW-DET-17               PIC X(659).                 
       01  LINK-BC-ROW-DET-18               PIC X(659).                 
       01  LINK-BC-ROW-DET-19               PIC X(659).                 
       01  LINK-BC-ROW-DET-20               PIC X(659).                 
       01  LINK-BC-ROW-DET-21               PIC X(659).                 
       01  LINK-BC-ROW-DET-22               PIC X(659).                 
       01  LINK-BC-ROW-DET-23               PIC X(659).                 
       01  LINK-BC-ROW-DET-24               PIC X(659).                 
       01  LINK-BC-ROW-DET-25               PIC X(659).                 
       01  LINK-BC-ROW-DET-26               PIC X(659).                 
       01  LINK-BC-ROW-DET-27               PIC X(659).                 
       01  LINK-BC-ROW-DET-28               PIC X(659).                 
       01  LINK-BC-ROW-DET-29               PIC X(659).                 
       01  LINK-BC-ROW-DET-30               PIC X(659).                 
       01  LINK-BC-ROW-DET-31               PIC X(659).                 
       01  LINK-BC-ROW-DET-32               PIC X(659).                 
       01  LINK-BC-ROW-DET-33               PIC X(659).                 
       01  LINK-BC-ROW-DET-34               PIC X(659).                 
       01  LINK-BC-ROW-DET-35               PIC X(659).                 
       01  LINK-BC-ROW-DET-36               PIC X(659).                 
       01  LINK-BC-ROW-DET-37               PIC X(659).                 
       01  LINK-BC-ROW-DET-38               PIC X(659).                 
       01  LINK-BC-ROW-DET-39               PIC X(659).                 
       01  LINK-BC-ROW-DET-40               PIC X(659).                 
       01  LINK-BC-ROW-DET-41               PIC X(659).                 
       01  LINK-BC-ROW-DET-42               PIC X(659).                 
       01  LINK-BC-ROW-DET-43               PIC X(659).                 
       01  LINK-BC-ROW-DET-44               PIC X(659).                 
       01  LINK-BC-ROW-DET-45               PIC X(659).                 
       01  LINK-BC-ROW-DET-46               PIC X(659).                 
       01  LINK-BC-ROW-DET-47               PIC X(659).                 
       01  LINK-BC-ROW-DET-48               PIC X(659).                 
       01  LINK-BC-ROW-DET-49               PIC X(659).                 
       01  LINK-BC-ROW-DET-50               PIC X(659).                 
       01  LINK-BA-ROW-DET-01               PIC X(862).                 
       01  LINK-BA-ROW-DET-02               PIC X(862).                 
       01  LINK-BA-ROW-DET-03               PIC X(862).                 
       01  LINK-BA-ROW-DET-04               PIC X(862).                 
       01  LINK-BA-ROW-DET-05               PIC X(862).                 
       01  LINK-BA-ROW-DET-06               PIC X(862).                 
       01  LINK-BA-ROW-DET-07               PIC X(862).                 
       01  LINK-BA-ROW-DET-08               PIC X(862).                 
       01  LINK-BA-ROW-DET-09               PIC X(862).                 
       01  LINK-BA-ROW-DET-10               PIC X(862).                 
       01  LINK-BA-ROW-DET-11               PIC X(862).                 
       01  LINK-BA-ROW-DET-12               PIC X(862).                 
       01  LINK-BA-ROW-DET-13               PIC X(862).                 
       01  LINK-BA-ROW-DET-14               PIC X(862).                 
       01  LINK-BA-ROW-DET-15               PIC X(862).                 
       01  LINK-BA-ROW-DET-16               PIC X(862).                 
       01  LINK-BA-ROW-DET-17               PIC X(862).                 
       01  LINK-BA-ROW-DET-18               PIC X(862).                 
       01  LINK-BA-ROW-DET-19               PIC X(862).                 
       01  LINK-BA-ROW-DET-20               PIC X(862).                 
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-ACCOUNT-NO                        
                                ,LINK-CODE-UTIL-TYPE                    
                                ,LINK-IC-NO                             
                                ,LINK-BILL-NO                           
                                ,LINK-BILL-ITEM-TIMESTMP                
                                ,LINK-BILL-MAN-SOURCE-CD                
                                ,LINK-BILL-MAN-STATUS-CD                
                                ,LINK-RATE-PLAN-NO                      
                                ,LINK-CODE-REVENUE-CLASS                
                                ,LINK-REVENUE-MONTH                     
                                ,LINK-USAGE-END-DATE                    
                                ,LINK-NO-OF-CONS-DAYS                   
                                ,LINK-NEW-RATE-FROM-DT                  
                                ,LINK-OLD-RATE-FROM-DT                  
                                ,LINK-NEW-RATE-PCT                      
                                ,LINK-REBILL-IND                        
                                ,LINK-PRORATE-CD                        
                                ,LINK-ACCT-CYCLE                        
                                ,LINK-BILL-CALC-CYCLE                   
                                ,LINK-BTU-FACTOR                        
                                ,LINK-GAS-BASE-USE                      
                                ,LINK-STATE-TAX-XMPT                    
                                ,LINK-CITY-TAX-XMPT                     
                                ,LINK-STATE-TAX-RATE                    
                                ,LINK-CITY-TAX-RATE                     
                                ,LINK-AMT-STATE-TAX                     
                                ,LINK-AMT-CITY-TAX                      
                                ,LINK-AMT-BILL-ITEM                     
                                ,LINK-USAGE-CHARGES                     
                                ,LINK-DEMAND-CHARGES                    
                                ,LINK-BC-ROW-DET-01                     
                                ,LINK-BC-ROW-DET-02                     
                                ,LINK-BC-ROW-DET-03                     
                                ,LINK-BC-ROW-DET-04                     
                                ,LINK-BC-ROW-DET-05                     
                                ,LINK-BC-ROW-DET-06                     
                                ,LINK-BC-ROW-DET-07                     
                                ,LINK-BC-ROW-DET-08                     
                                ,LINK-BC-ROW-DET-09                     
                                ,LINK-BC-ROW-DET-10                     
                                ,LINK-BC-ROW-DET-11                     
                                ,LINK-BC-ROW-DET-12                     
                                ,LINK-BC-ROW-DET-13                     
                                ,LINK-BC-ROW-DET-14                     
                                ,LINK-BC-ROW-DET-15                     
                                ,LINK-BC-ROW-DET-16                     
                                ,LINK-BC-ROW-DET-17                     
                                ,LINK-BC-ROW-DET-18                     
                                ,LINK-BC-ROW-DET-19                     
                                ,LINK-BC-ROW-DET-20                     
                                ,LINK-BC-ROW-DET-21                     
                                ,LINK-BC-ROW-DET-22                     
                                ,LINK-BC-ROW-DET-23                     
                                ,LINK-BC-ROW-DET-24                     
                                ,LINK-BC-ROW-DET-25                     
                                ,LINK-BC-ROW-DET-26                     
                                ,LINK-BC-ROW-DET-27                     
                                ,LINK-BC-ROW-DET-28                     
                                ,LINK-BC-ROW-DET-29                     
                                ,LINK-BC-ROW-DET-30                     
                                ,LINK-BC-ROW-DET-31                     
                                ,LINK-BC-ROW-DET-32                     
                                ,LINK-BC-ROW-DET-33                     
                                ,LINK-BC-ROW-DET-34                     
                                ,LINK-BC-ROW-DET-35                     
                                ,LINK-BC-ROW-DET-36                     
                                ,LINK-BC-ROW-DET-37                     
                                ,LINK-BC-ROW-DET-38                     
                                ,LINK-BC-ROW-DET-39                     
                                ,LINK-BC-ROW-DET-40                     
                                ,LINK-BC-ROW-DET-41                     
                                ,LINK-BC-ROW-DET-42                     
                                ,LINK-BC-ROW-DET-43                     
                                ,LINK-BC-ROW-DET-44                     
                                ,LINK-BC-ROW-DET-45                     
                                ,LINK-BC-ROW-DET-46                     
                                ,LINK-BC-ROW-DET-47                     
                                ,LINK-BC-ROW-DET-48                     
                                ,LINK-BC-ROW-DET-49                     
                                ,LINK-BC-ROW-DET-50                     
                                ,LINK-BA-ROW-DET-01                     
                                ,LINK-BA-ROW-DET-02                     
                                ,LINK-BA-ROW-DET-03                     
                                ,LINK-BA-ROW-DET-04                     
                                ,LINK-BA-ROW-DET-05                     
                                ,LINK-BA-ROW-DET-06                     
                                ,LINK-BA-ROW-DET-07                     
                                ,LINK-BA-ROW-DET-08                     
                                ,LINK-BA-ROW-DET-09                     
                                ,LINK-BA-ROW-DET-10                     
                                ,LINK-BA-ROW-DET-11                     
                                ,LINK-BA-ROW-DET-12                     
                                ,LINK-BA-ROW-DET-13                     
                                ,LINK-BA-ROW-DET-14                     
                                ,LINK-BA-ROW-DET-15                     
                                ,LINK-BA-ROW-DET-16                     
                                ,LINK-BA-ROW-DET-17                     
                                ,LINK-BA-ROW-DET-18                     
                                ,LINK-BA-ROW-DET-19                     
                                ,LINK-BA-ROW-DET-20.                    
                                                                        
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE        THRU  0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT     THRU  1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT    THRU  2000-EXIT.              
           PERFORM 9999-END-PROGRAM       THRU  9999-EXIT.              
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS                                 
                      WS-MISC-VARIABLES.                                
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04517_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04517_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,BUS_RULE_TYPE CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ERROR_CODE              INT                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE EQUAL '42710'                                 
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                 SELECT RETURN_CODE                                     
                       ,BUS_RULE_TYPE                                   
                       ,BUS_RULE_RESULT                                 
                       ,ERROR_CODE                                      
                   FROM #CSR04517_R1                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*          SELECT RETURN_CODE                                             
MFA-TR*                ,BUS_RULE_TYPE                                           
MFA-TR*                ,BUS_RULE_RESULT                                         
MFA-TR*                ,ERROR_CODE                                              
MFA-TR*            FROM SESSION.CSR04517_R1                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * RECEIVE INPUT PARMS                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           MOVE LINK-IC-NO                TO PARM-IC-NO.                
           MOVE LINK-BILL-NO              TO PARM-BILL-NO.              
           MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP.   
           MOVE LINK-BILL-MAN-SOURCE-CD   TO PARM-BILL-MAN-SOURCE-CD.   
           MOVE LINK-BILL-MAN-STATUS-CD   TO PARM-BILL-MAN-STATUS-CD.   
           MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO.         
           MOVE LINK-CODE-REVENUE-CLASS   TO PARM-CODE-REVENUE-CLASS.   
           MOVE LINK-REVENUE-MONTH        TO PARM-REVENUE-MONTH.        
           MOVE LINK-USAGE-END-DATE       TO PARM-USAGE-END-DATE.       
           MOVE LINK-NO-OF-CONS-DAYS      TO PARM-NO-OF-CONS-DAYS.      
           MOVE LINK-NEW-RATE-FROM-DT     TO PARM-NEW-RATE-FROM-DT.     
           MOVE LINK-OLD-RATE-FROM-DT     TO PARM-OLD-RATE-FROM-DT.     
           MOVE LINK-NEW-RATE-PCT         TO PARM-NEW-RATE-PCT.         
           MOVE LINK-REBILL-IND           TO PARM-REBILL-IND.           
           MOVE LINK-PRORATE-CD           TO PARM-PRORATE-CD.           
           MOVE LINK-ACCT-CYCLE           TO PARM-ACCT-CYCLE.           
           MOVE LINK-BILL-CALC-CYCLE      TO PARM-BILL-CALC-CYCLE.      
           MOVE LINK-BTU-FACTOR           TO PARM-BTU-FACTOR.           
           MOVE LINK-GAS-BASE-USE         TO PARM-GAS-BASE-USE.         
           MOVE LINK-STATE-TAX-XMPT       TO PARM-STATE-TAX-XMPT.       
           MOVE LINK-CITY-TAX-XMPT        TO PARM-CITY-TAX-XMPT.        
           MOVE LINK-STATE-TAX-RATE       TO PARM-STATE-TAX-RATE.       
           MOVE LINK-CITY-TAX-RATE        TO PARM-CITY-TAX-RATE.        
           MOVE LINK-AMT-STATE-TAX        TO PARM-AMT-STATE-TAX.        
           MOVE LINK-AMT-CITY-TAX         TO PARM-AMT-CITY-TAX.         
           MOVE LINK-AMT-BILL-ITEM        TO PARM-AMT-BILL-ITEM.        
           MOVE LINK-USAGE-CHARGES        TO PARM-USAGE-CHARGES.        
           MOVE LINK-DEMAND-CHARGES       TO PARM-DEMAND-CHARGES.       
                                                                        
      ****ACCEPT ALL BILL COMPONENT VARCHAR PARMS.                              
           MOVE LINK-BC-ROW-DET-01        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-01.        
           MOVE LINK-BC-ROW-DET-02        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-02.        
           MOVE LINK-BC-ROW-DET-03        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-03.        
           MOVE LINK-BC-ROW-DET-04        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-04.        
           MOVE LINK-BC-ROW-DET-05        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-05.        
           MOVE LINK-BC-ROW-DET-06        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-06.        
           MOVE LINK-BC-ROW-DET-07        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-07.        
           MOVE LINK-BC-ROW-DET-08        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-08.        
           MOVE LINK-BC-ROW-DET-09        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-09.        
           MOVE LINK-BC-ROW-DET-10        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-10.        
           MOVE LINK-BC-ROW-DET-11        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-11.        
           MOVE LINK-BC-ROW-DET-12        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-12.        
           MOVE LINK-BC-ROW-DET-13        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-13.        
           MOVE LINK-BC-ROW-DET-14        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-14.        
           MOVE LINK-BC-ROW-DET-15        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-15.        
           MOVE LINK-BC-ROW-DET-16        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-16.        
           MOVE LINK-BC-ROW-DET-17        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-17.        
           MOVE LINK-BC-ROW-DET-18        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-18.        
           MOVE LINK-BC-ROW-DET-19        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-19.        
           MOVE LINK-BC-ROW-DET-20        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-20.        
           MOVE LINK-BC-ROW-DET-21        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-21.        
           MOVE LINK-BC-ROW-DET-22        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-22.        
           MOVE LINK-BC-ROW-DET-23        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-23.        
           MOVE LINK-BC-ROW-DET-24        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-24.        
           MOVE LINK-BC-ROW-DET-25        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-25.        
           MOVE LINK-BC-ROW-DET-26        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-26.        
           MOVE LINK-BC-ROW-DET-27        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-27.        
           MOVE LINK-BC-ROW-DET-28        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-28.        
           MOVE LINK-BC-ROW-DET-29        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-29.        
           MOVE LINK-BC-ROW-DET-30        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-30.        
           MOVE LINK-BC-ROW-DET-31        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-31.        
           MOVE LINK-BC-ROW-DET-32        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-32.        
           MOVE LINK-BC-ROW-DET-33        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-33.        
           MOVE LINK-BC-ROW-DET-34        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-34.        
           MOVE LINK-BC-ROW-DET-35        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-35.        
           MOVE LINK-BC-ROW-DET-36        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-36.        
           MOVE LINK-BC-ROW-DET-37        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-37.        
           MOVE LINK-BC-ROW-DET-38        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-38.        
           MOVE LINK-BC-ROW-DET-39        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-39.        
           MOVE LINK-BC-ROW-DET-40        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-40.        
           MOVE LINK-BC-ROW-DET-41        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-41.        
           MOVE LINK-BC-ROW-DET-42        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-42.        
           MOVE LINK-BC-ROW-DET-43        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-43.        
           MOVE LINK-BC-ROW-DET-44        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-44.        
           MOVE LINK-BC-ROW-DET-45        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-45.        
           MOVE LINK-BC-ROW-DET-46        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-46.        
           MOVE LINK-BC-ROW-DET-47        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-47.        
           MOVE LINK-BC-ROW-DET-48        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-48.        
           MOVE LINK-BC-ROW-DET-49        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-49.        
           MOVE LINK-BC-ROW-DET-50        TO WS-PARM-BC-UPD-DATA.       
           MOVE WS-PARM-BC-UPD-DATA-TEXT  TO PARM-BC-ROW-DET-50.        
                                                                        
      ****ACCEPT ALL BILL ADJUSTMENT VARCHAR PARMS.                             
           MOVE LINK-BA-ROW-DET-01        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-01.        
           MOVE LINK-BA-ROW-DET-02        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-02.        
           MOVE LINK-BA-ROW-DET-03        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-03.        
           MOVE LINK-BA-ROW-DET-04        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-04.        
           MOVE LINK-BA-ROW-DET-05        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-05.        
           MOVE LINK-BA-ROW-DET-06        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-06.        
           MOVE LINK-BA-ROW-DET-07        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-07.        
           MOVE LINK-BA-ROW-DET-08        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-08.        
           MOVE LINK-BA-ROW-DET-09        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-09.        
           MOVE LINK-BA-ROW-DET-10        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-10.        
           MOVE LINK-BA-ROW-DET-11        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-11.        
           MOVE LINK-BA-ROW-DET-12        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-12.        
           MOVE LINK-BA-ROW-DET-13        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-13.        
           MOVE LINK-BA-ROW-DET-14        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-14.        
           MOVE LINK-BA-ROW-DET-15        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-15.        
           MOVE LINK-BA-ROW-DET-16        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-16.        
           MOVE LINK-BA-ROW-DET-17        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-17.        
           MOVE LINK-BA-ROW-DET-18        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-18.        
           MOVE LINK-BA-ROW-DET-19        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-19.        
           MOVE LINK-BA-ROW-DET-20        TO WS-PARM-BA-UPD-DATA.       
           MOVE WS-PARM-BA-UPD-DATA-TEXT  TO PARM-BA-ROW-DET-20.        
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO NG-ACCOUNT-NO              
                                             NU-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
                                                                        
           MOVE PARM-CODE-UTIL-TYPE       TO NG-CODE-UTIL-TYPE          
                                             NU-CODE-UTIL-TYPE          
                                             BG-CODE-UTIL-TYPE.         
                                                                        
           MOVE PARM-IC-NO-NUM            TO NG-IC-NO                   
                                             NU-IC-NO                   
                                             BG-IC-NO.                  
                                                                        
           MOVE PARM-BILL-NO-NUM          TO NG-BILL-NO                 
                                             NU-BILL-NO                 
                                             BG-BILL-NO.                
                                                                        
           MOVE PARM-BILL-ITEM-TIMESTMP   TO NG-BILL-ITEM-TIMESTMP      
                                             NU-BILL-ITEM-TIMESTMP      
                                             BG-BILL-ITEM-TIMESTMP.     
                                                                        
           SET  CHARGES-NOT-EDITED        TO TRUE.                      
           SET  ADJUSTMENTS-NOT-EDITED    TO TRUE.                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESS OUTPUT                                                 *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE ZEROS                     TO WS-NXT-BILL-MAN-DET-SEQ.   
                                                                        
           IF PARM-CALL-TYPE EQUAL 'D'                                  
              PERFORM 8150-DELETE-MANUAL-BILL     THRU 8150-EXIT        
           ELSE                                                         
              IF PARM-BILL-MAN-SOURCE-CD EQUAL 'E'                      
                 PERFORM 3000-PROCESS-EXCEL-DATA  THRU 3000-EXIT        
              ELSE                                                      
                 PERFORM 3100-PROCESS-EDITED-BILL THRU 3100-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ****WRITE TRANSACTION HISTORY COMMENTS.                                   
           IF S-RETURN-CODE EQUAL ZERO AND                              
              S-ERROR-CODE  EQUAL ZERO                                  
              PERFORM 5200-PROCESS-TRAN-HIST-HDR  THRU 5200-EXIT        
           END-IF.                                                      
                                                                        
           IF S-BUS-RULE-TYPE EQUAL SPACES                              
              MOVE 'NON000'               TO S-BUS-RULE-TYPE            
           END-IF.                                                      
                                                                        
           IF S-BUS-RULE-RESULT EQUAL SPACES                            
              MOVE 'G'                    TO S-BUS-RULE-RESULT          
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3000-PROCESS-EXCEL-DATA.                                      *         
      * PROCESS THE DATA UPLOADED THROUGH EXCEL SPREADSHEET.          *         
      *  1. MANUAL NORMAL BILL                                        *         
      *  2. MANUAL NONE-CALC BILL                                     *         
      *****************************************************************         
      *                                                                         
       3000-PROCESS-EXCEL-DATA.                                         
      *                                                                         
           MOVE '3000'                        TO ACTIVE-PARAGRAPH.      
      *                                                                         
      ****LOAD THE BILLING COMPONENTS/ADJUSTMENTS                               
           PERFORM 3200-LOAD-BILL-CMPNT          THRU 3200-EXIT.        
           PERFORM 3400-LOAD-BILL-ADJ            THRU 3400-EXIT.        
                                                                        
           PERFORM 3010-CHECK-FOR-CROSSFOOT      THRU 3010-EXIT.        
                                                                        
           PERFORM 7100-SELECT-BILLING-DETAIL    THRU 7100-EXIT.        
                                                                        
      ****CALL BILL CALC ONLY FOR NORMAL BILL TO GET ADDITIONAL DETAILS.        
           MOVE SPACES                        TO WS-CALC-ERROR.         
           IF BG-CODE-BILL-CALC EQUAL 'A'                               
              PERFORM 5000-BILL-CALC-PROCESS     THRU 5000-EXIT         
           END-IF.                                                      
                                                                        
           IF WS-CALC-ERROR EQUAL SPACES AND                            
              WS-CPD4517-REJ-WQ-CNT EQUAL ZERO                          
                                                                        
      ****CREATE MANUAL_BILL HEADER RECORD                                      
              MOVE PARM-BILL-MAN-STATUS-CD    TO NG-BILL-MAN-STATUS-CD  
              MOVE PARM-BILL-MAN-SOURCE-CD    TO NG-BILL-MAN-SOURCE-CD  
              MOVE 'SYSTEM'                   TO NG-LAST-UPDATE-USERID  
              PERFORM 8300-INSERT-MANUAL-BILL    THRU 8300-EXIT         
                                                                        
      ****CREATE MANUAL_BILL DETAIL BG RECORD                                   
              PERFORM 3020-CREATE-MAN-BILL-BG    THRU 3020-EXIT         
                                                                        
      ****CREATE MANUAL BILL DETAIL CX AND BASELINE RECORDS                     
              IF BG-CODE-BILL-CALC EQUAL 'A'                            
                 PERFORM 5100-STORE-CNSMPTN-DATA THRU 5100-EXIT         
                 PERFORM 3030-CREATE-MAN-BILL-CX THRU 3030-EXIT         
                 PERFORM 3050-CREATE-BSLN-HIST   THRU 3050-EXIT         
              END-IF                                                    
                                                                        
      ****CREATE MANUAL BILL DETAIL BC AND BA RECORDS                           
              PERFORM 3600-PROC-BILL-CMPNT       THRU 3600-EXIT         
              MOVE 'N'                        TO WS-BFC-DELETED-FLAG    
              PERFORM 3700-PROC-BILL-ADJ         THRU 3700-EXIT         
           END-IF.                                                      
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3010-CHECK-FOR-CROSSFOOT.                                     *         
      * CHECK CROSSFOOT FOR THE DATA UPLOADED FROM EXCEL.             *         
      *****************************************************************         
      *                                                                         
       3010-CHECK-FOR-CROSSFOOT.                                        
      *                                                                         
           MOVE '3010'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE ZEROS                     TO WS-HOLD-AMT-BILL-ITEM      
                                             WS-HOLD-STATE-TAX          
                                             WS-HOLD-FRANCHISE-TAX      
                                             WS-HOLD-TOT-CMPNT-AMT.     
                                                                        
           PERFORM VARYING WS-BC-DET-INDX FROM 1 BY 1                   
SCA006       UNTIL WS-BC-DET-INDX > 200 OR 
                   WS-BC-DET-ACTION-IND (WS-BC-DET-INDX) EQUAL SPACES           
                   COMPUTE WS-HOLD-TOT-CMPNT-AMT ROUNDED EQUAL          
                           WS-HOLD-TOT-CMPNT-AMT +                      
                           WS-BC-DET-NET-CMPNT-AMT (WS-BC-DET-INDX)     
                   END-COMPUTE                                          
           END-PERFORM.                                                 
                                                                        
           MOVE PARM-AMT-BILL-ITEM-VAL    TO WS-DECIMAL-9V2-NUM.        
           IF PARM-AMT-BILL-ITEM-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO WS-HOLD-AMT-BILL-ITEM.     
                                                                        
           MOVE PARM-AMT-STATE-TAX-VAL    TO WS-DECIMAL-7V2-NUM.        
           IF PARM-AMT-STATE-TAX-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-7V2-NUM-RED    TO WS-HOLD-STATE-TAX.         
                                                                        
           MOVE PARM-AMT-CITY-TAX-VAL     TO WS-DECIMAL-7V2-NUM.        
           IF PARM-AMT-CITY-TAX-SGN  EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-7V2-NUM-RED    TO WS-HOLD-FRANCHISE-TAX.     
                                                                        
           COMPUTE WS-CMPR-AMT-BILL-ITEM ROUNDED EQUAL                  
                   WS-HOLD-TOT-CMPNT-AMT                                
                +  WS-HOLD-STATE-TAX                                    
                +  WS-HOLD-FRANCHISE-TAX                                
           END-COMPUTE.                                                 
                                                                        
           IF WS-HOLD-AMT-BILL-ITEM NOT EQUAL WS-CMPR-AMT-BILL-ITEM     
              MOVE 'NON004'               TO S-BUS-RULE-TYPE            
              MOVE 'R'                    TO S-BUS-RULE-RESULT          
              MOVE ZERO                   TO WS-ACTIVE-RETURN-CODE      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT            
           END-IF.                                                      
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3020-CREATE-MAN-BILL-BG.                                      *         
      * CREATE THE BG RECORD FOR THE MANUAL BILL.                     *         
      *****************************************************************         
      *                                                                         
       3020-CREATE-MAN-BILL-BG.                                         
      *                                                                         
           MOVE '3020'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET WS-BILLING-INDX            TO 1.                         
           INITIALIZE WS-BILLING-DATA (WS-BILLING-INDX).                
                                                                        
           MOVE BG-ACCOUNT-NO             TO                            
                WS-ACCOUNT-NO-BG (WS-BILLING-INDX).                     
           MOVE BG-BILL-NO                TO                            
                WS-BILL-NO-BG (WS-BILLING-INDX).                        
           MOVE BG-CODE-UTIL-TYPE         TO                            
                WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX).                 
           MOVE BG-IC-NO                  TO                            
                WS-IC-NO-BG (WS-BILLING-INDX).                          
           MOVE BG-BILL-ITEM-TIMESTMP     TO                            
                WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX).             
           MOVE BG-PREMISE-NO             TO                            
                WS-PREMISE-NO-BG (WS-BILLING-INDX).                     
           MOVE BG-DATE-ORIG-BILL         TO                            
                WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX).                 
                                                                        
           MOVE PARM-AMT-BILL-ITEM-VAL    TO WS-DECIMAL-9V2-NUM.        
           IF PARM-AMT-BILL-ITEM-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO                            
                WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX).                  
                                                                        
           MOVE BG-CODE-BILL-CALC         TO                            
                WS-CODE-BILL-CALC-BG (WS-BILLING-INDX).                 
           MOVE BG-CODE-BILL-ITM-TYPE     TO                            
                WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX).             
           MOVE BG-CODE-BILL-ITM-IND      TO                            
                WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX).              
           MOVE BG-CODE-DR-CR-CNSMPTN     TO                            
                WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX).             
                                                                        
           MOVE PARM-AMT-STATE-TAX-VAL    TO WS-DECIMAL-7V2-NUM.        
           IF PARM-AMT-STATE-TAX-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-7V2-NUM-RED    TO                            
                WS-AMT-STATE-TAX-BG (WS-BILLING-INDX).                  
           MOVE PARM-AMT-CITY-TAX-VAL     TO WS-DECIMAL-7V2-NUM.        
           IF PARM-AMT-CITY-TAX-SGN  EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-7V2-NUM-RED    TO                            
                WS-AMT-CITY-TAX-BG (WS-BILLING-INDX).                   
           MOVE BG-AMT-OTHER-TAX          TO                            
                WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX).                  
                                                                        
           MOVE BG-CODE-REVENUE-CLASS     TO                            
                WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX).             
           MOVE BG-CODE-SIC-NO            TO                            
                WS-CODE-SIC-NO-BG (WS-BILLING-INDX).                    
           MOVE BG-RATE-PLAN-NO           TO                            
                WS-RATE-PLAN-NO-BG (WS-BILLING-INDX).                   
           MOVE BG-CODE-CURTAIL-PRTY      TO                            
                WS-CODE-CURTAIL-PRTY-BG (WS-BILLING-INDX).              
                                                                        
           MOVE PARM-STATE-TAX-XMPT       TO                            
                WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX).              
           MOVE PARM-CITY-TAX-XMPT        TO                            
                WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX).              
           MOVE BG-CODE-OTHR-TAX-XMT      TO                            
                WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX).              
                                                                        
           MOVE BG-REV-RPT-CD             TO                            
                WS-REV-RPT-CD-BG (WS-BILLING-INDX)                      
           MOVE BG-STANDBY-COMPLIED       TO                            
                WS-STANDBY-COMPLIED-BG (WS-BILLING-INDX).               
                                                                        
           MOVE PARM-PRORATE-CD           TO                            
                WS-PRORATE-CD-BG (WS-BILLING-INDX).                     
           MOVE PARM-NEW-RATE-PCT-VAL     TO WS-DECIMAL-0V4-NUM.        
           IF PARM-NEW-RATE-PCT-SGN EQUAL '-'                           
              COMPUTE WS-DECIMAL-0V4-NUM-RED EQUAL                      
                      WS-DECIMAL-0V4-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-0V4-NUM-RED    TO                            
                WS-NEW-RATE-PCT-BG (WS-BILLING-INDX).                   
                                                                        
           MOVE BG-CODE-SUB-TOTAL         TO                            
                WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX).                 
           MOVE BG-TAX-REFUND-CD          TO                            
                WS-TAX-REFUND-CD-BG (WS-BILLING-INDX).                  
           MOVE BG-COMPANY-NO             TO                            
                WS-COMPANY-NO-BG (WS-BILLING-INDX).                     
           MOVE BG-DATE-LFTM-HI-DMD       TO                            
                WS-DATE-LFTM-HI-DMD-BG (WS-BILLING-INDX).               
           MOVE BG-LFTM-HI-PEAK-DMD       TO                            
                WS-LFTM-HI-PEAK-DMD-BG (WS-BILLING-INDX).               
           MOVE PARM-REBILL-IND           TO                            
                WS-REBILL-IND-BG (WS-BILLING-INDX).                     
           MOVE BG-ADJ-REASON-CD          TO                            
                WS-ADJ-REASON-CD-BG (WS-BILLING-INDX).                  
                                                                        
           MOVE PARM-REVENUE-MONTH-NUM    TO                            
                WS-REVENUE-MONTH-BG (WS-BILLING-INDX).                  
                                                                        
           MOVE PARM-BTU-FACTOR-VAL       TO WS-DECIMAL-2V5-NUM.        
           IF PARM-BTU-FACTOR-SGN EQUAL '-'                             
              COMPUTE WS-DECIMAL-2V5-NUM-RED EQUAL                      
                      WS-DECIMAL-2V5-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-2V5-NUM-RED    TO                            
                WS-BTU-FACTOR-BG (WS-BILLING-INDX).                     
           MOVE BG-WNA-FACTOR             TO                            
                WS-WNA-FACTOR-BG (WS-BILLING-INDX).                     
           MOVE PARM-GAS-BASE-USE-VAL     TO                            
                WS-GAS-BASE-USE-BG (WS-BILLING-INDX).                   
           IF PARM-GAS-BASE-USE-SGN EQUAL '-'                           
              COMPUTE WS-GAS-BASE-USE-BG (WS-BILLING-INDX) EQUAL        
                      WS-GAS-BASE-USE-BG (WS-BILLING-INDX) * -1         
           END-IF.                                                      
                                                                        
           MOVE PARM-NO-OF-CONS-DAYS-NUM  TO                            
                WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX).                
           MOVE BG-REV-MTH-ORIG-BILL      TO                            
                WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX).              
                                                                        
           MOVE PARM-USAGE-CHARGES-VAL    TO WS-DECIMAL-9V2-NUM.        
           IF PARM-USAGE-CHARGES-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO                            
                WS-USAGE-DOLLARS-CALC (WS-BILLING-INDX).                
           MOVE PARM-DEMAND-CHARGES-VAL   TO WS-DECIMAL-9V2-NUM.        
           IF PARM-DEMAND-CHARGES-SGN EQUAL '-'                         
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO                            
                WS-DEMAND-DOLLARS-CALC (WS-BILLING-INDX).               
                                                                        
           MOVE PARM-STATE-TAX-RATE-VAL   TO WS-DECIMAL-2V3-NUM.        
           IF PARM-STATE-TAX-RATE-SGN EQUAL '-'                         
              COMPUTE WS-DECIMAL-2V3-NUM-RED EQUAL                      
                      WS-DECIMAL-2V3-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-2V3-NUM-RED    TO                            
                WS-STATE-TX-RATE-CALC (WS-BILLING-INDX).                
           MOVE PARM-CITY-TAX-RATE-VAL    TO WS-DECIMAL-2V3-NUM.        
           IF PARM-CITY-TAX-RATE-VAL  EQUAL '-'                         
              COMPUTE WS-DECIMAL-2V3-NUM-RED EQUAL                      
                      WS-DECIMAL-2V3-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-2V3-NUM-RED    TO                            
                WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX).            
                                                                        
           MOVE PARM-USAGE-END-DATE       TO                            
                WS-USAGE-END-DATE-CALC (WS-BILLING-INDX).               
                                                                        
           MOVE BG-FUEL-SHIPPER-CD        TO                            
                WS-FUEL-SHIPPER-CD-BG (WS-BILLING-INDX).                
                                                                        
           MOVE PARM-BILL-CALC-CYCLE      TO                            
                WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX).                
                                                                        
           MOVE BG-NAICS-CD               TO                            
                WS-NAICS-CD-BG (WS-BILLING-INDX).                       
           MOVE BG-RT-PKG-OPT-SEQ-NO      TO                            
                WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX).              
           MOVE 'U'                       TO                            
                WS-UPDATE-ACTION-IND-BG (WS-BILLING-INDX).              
           PERFORM 3950-SYNC-BASIC-FAC-CHRG  THRU 3950-EXIT.            
                                                                        
           IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS                       
              PERFORM 7050-GET-NEXT-BILL-MAN-SEQ THRU 7050-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-BG                     TO NU-BILL-MANUAL-TBL-ID.     
           MOVE WS-NXT-BILL-MAN-DET-SEQ   TO NU-BILL-MAN-DET-SEQ.       
           MOVE WS-BILLING-DATA (WS-BILLING-INDX)                       
                                          TO NU-BILL-MANUAL-DATA-TEXT.  
           PERFORM 8350-INSERT-BILL-MAN-DET  THRU 8350-EXIT             
           COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                        
                   WS-NXT-BILL-MAN-DET-SEQ + 1.                         
      *                                                                         
       3020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3030-CREATE-MAN-BILL-CX.                                      *         
      * CREATE THE CX RECORDS FOR THE MANUAL BILL.                    *         
      *****************************************************************         
      *                                                                         
       3030-CREATE-MAN-BILL-CX.                                         
      *                                                                         
           MOVE '3030'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS                       
              PERFORM 7050-GET-NEXT-BILL-MAN-SEQ    THRU 7050-EXIT      
           END-IF.                                                      
                                                                        
           MOVE WS-CX                     TO NU-BILL-MANUAL-TBL-ID.     
                                                                        
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
             UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY                    
                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) EQUAL ZEROS       
                   MOVE WS-NXT-BILL-MAN-DET-SEQ                         
                     TO NU-BILL-MAN-DET-SEQ                             
                   MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)               
                     TO NU-BILL-MANUAL-DATA-TEXT                        
                   PERFORM 8350-INSERT-BILL-MAN-DET THRU 8350-EXIT      
                   COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                
                           WS-NXT-BILL-MAN-DET-SEQ + 1                  
                   END-COMPUTE                                          
           END-PERFORM.                                                 
      *                                                                         
       3030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3040-CREATE-MAN-BILL-XD.                                      *         
      * CREATE THE XD RECORDS FOR THE MANUAL BILL.                    *         
      *****************************************************************         
      *                                                                         
       3040-CREATE-MAN-BILL-XD.                                         
      *                                                                         
           MOVE '3040'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET WS-CALC-X-INDX             TO 1.                         
           INITIALIZE WS-BILL-CALC-X-DATA (WS-CALC-X-INDX).             
                                                                        
           MOVE NG-ACCOUNT-NO                                           
                TO WS-ACCOUNT-NO-XD (WS-CALC-X-INDX).                   
           MOVE NG-CODE-UTIL-TYPE                                       
                TO WS-CODE-UTIL-TYPE-XD (WS-CALC-X-INDX).               
           MOVE NG-IC-NO                                                
                TO WS-IC-NO-XD (WS-CALC-X-INDX).                        
           MOVE NG-BILL-NO                                              
                TO WS-BILL-NO-XD (WS-CALC-X-INDX).                      
           MOVE NG-BILL-ITEM-TIMESTMP                                   
                TO WS-BILL-ITEM-TIMESTMP-XD (WS-CALC-X-INDX).           
           MOVE WS-BC-DET-COMPONENT-ID (WS-BC-DET-INDX)                 
                TO WS-COMPONENT-CODE-XD (WS-CALC-X-INDX).               
           MOVE WS-BC-DET-CNSMPTN-TYPE (WS-BC-DET-INDX)                 
                TO WS-CONSUMPTION-TYPE-XD (WS-CALC-X-INDX).             
           MOVE WS-BC-DET-REGISTER-TYPE (WS-BC-DET-INDX)                
                TO WS-REGISTER-TYPE-XD (WS-CALC-X-INDX).                
           MOVE WS-BC-DET-CODE-TOU (WS-BC-DET-INDX)                     
                TO WS-CODE-TOU-XD (WS-CALC-X-INDX).                     
           MOVE WS-BC-DET-CODE-SEASON (WS-BC-DET-INDX)                  
                TO WS-CODE-SEASON-XD (WS-CALC-X-INDX).                  
           MOVE WS-BC-DET-RATE-VERSION (WS-BC-DET-INDX)                 
                TO WS-RATE-VERSION-XD (WS-CALC-X-INDX).                 
                                                                        
           IF WS-BC-DET-RATE-VERSION (WS-BC-DET-INDX) EQUAL '1'         
              MOVE PARM-NEW-RATE-FROM-DT                                
                   TO WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)             
           ELSE                                                         
              MOVE PARM-OLD-RATE-FROM-DT                                
                   TO WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)             
           END-IF.                                                      
                                                                        
           IF WS-BC-DET-EVENT-NO (WS-BC-DET-INDX) > 0                   
              MOVE WS-BC-DET-EVENT-NO (WS-BC-DET-INDX)                  
                   TO WS-EVENT-NUMBER-XD (WS-CALC-X-INDX)               
           END-IF                                                       
                                                                        
           MOVE 'I'                                                     
                TO WS-UPDATE-ACTION-IND-XD (WS-CALC-X-INDX)             
                                                                        
           IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS                       
              PERFORM 7050-GET-NEXT-BILL-MAN-SEQ THRU 7050-EXIT         
           END-IF.                                                      
                                                                        
           MOVE WS-XD                     TO NU-BILL-MANUAL-TBL-ID.     
                                                                        
           MOVE WS-NXT-BILL-MAN-DET-SEQ   TO NU-BILL-MAN-DET-SEQ.       
           MOVE WS-BILL-CALC-X-DATA (WS-CALC-X-INDX)                    
                                          TO NU-BILL-MANUAL-DATA-TEXT.  
           PERFORM 8350-INSERT-BILL-MAN-DET      THRU 8350-EXIT.        
           COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                        
                   WS-NXT-BILL-MAN-DET-SEQ + 1                          
           END-COMPUTE.                                                 
      *                                                                         
       3040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3050-CREATE-BSLN-HIST.                                         *        
      * STORE THE BASELINE HISTORY DATA RETURNED FROM BILL CALC        *        
      ******************************************************************        
      *                                                                         
       3050-CREATE-BSLN-HIST.                                           
      *                                                                         
           MOVE '3050'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM VARYING WS-LO-INDEX FROM 1 BY 1                      
             UNTIL WS-LO-INDEX > 20                                     
                OR WS-ACCOUNT-NO-LO (WS-LO-INDEX) EQUAL ZEROS           
                   MOVE WS-LO             TO NU-BILL-MANUAL-TBL-ID      
                   IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS               
                      PERFORM 7050-GET-NEXT-BILL-MAN-SEQ                
                         THRU 7050-EXIT                                 
                   END-IF                                               
                   MOVE WS-NXT-BILL-MAN-DET-SEQ                         
                                          TO NU-BILL-MAN-DET-SEQ        
                   MOVE WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX)            
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                   PERFORM 8350-INSERT-BILL-MAN-DET                     
                      THRU 8350-EXIT                                    
                   COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                
                           WS-NXT-BILL-MAN-DET-SEQ + 1                  
                   END-COMPUTE                                          
           END-PERFORM.                                                 
      *                                                                         
       3050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3100-PROCESS-EDITED-BILL.                                     *         
      * PROCESS UPDATES FOR BILL CALC EDITED BILL.                    *         
      *****************************************************************         
      *                                                                         
       3100-PROCESS-EDITED-BILL.                                        
      *                                                                         
           MOVE '3100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 3200-LOAD-BILL-CMPNT        THRU 3200-EXIT.          
           PERFORM 3400-LOAD-BILL-ADJ          THRU 3400-EXIT.          
                                                                        
      ****UPDATE MANUAL BILL DETAIL BC AND BA RECORDS                           
           PERFORM 3600-PROC-BILL-CMPNT        THRU 3600-EXIT.          
           MOVE 'N'                         TO WS-BFC-DELETED-FLAG.     
           PERFORM 3700-PROC-BILL-ADJ          THRU 3700-EXIT.          
                                                                        
           MOVE PARM-BILL-MAN-STATUS-CD     TO NG-BILL-MAN-STATUS-CD.   
           MOVE PARM-BILL-MAN-SOURCE-CD     TO NG-BILL-MAN-SOURCE-CD.   
           MOVE 'SYSTEM'                    TO NG-LAST-UPDATE-USERID.   
           PERFORM 8400-UPDATE-MANUAL-BILL     THRU 8400-EXIT.          
                                                                        
      ****UPDATE BG RECORD FOR COMPONENT UPDATES                                
           MOVE WS-BG                       TO WS-NU-TBL1.              
           MOVE WS-BC                       TO WS-NU-TBL2.              
           MOVE ZEROS                       TO WS-BG-MAN-DET-SEQ.       
           PERFORM 7200-OPEN-BILL-MAN-DET-CUR  THRU 7200-EXIT.          
           PERFORM 7250-FETCH-BILL-MAN-DET-CUR THRU 7250-EXIT.          
           SET WS-BILLING-INDX                                          
               WS-CALC-INDX                 TO 1.                       
           INITIALIZE        WS-BILLING-BG                              
                             WS-BILL-CALC-DETAIL.                       
           PERFORM 3800-PROCESS-BILL-MAN-DET   THRU 3800-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           PERFORM 7300-CLOSE-BILL-MAN-DET-CUR THRU 7300-EXIT.          
                                                                        
           PERFORM 3900-SYNC-MAN-BILL-DET-BG   THRU 3900-EXIT.          
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3200-LOAD-BILL-CMPNT.                                          *        
      * LOAD ALL BILL COMPONENT DETAILS PASSED IN LINKAGE.             *        
      ******************************************************************        
      *                                                                         
       3200-LOAD-BILL-CMPNT.                                            
      *                                                                         
           MOVE '3200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE WS-BC-DATA-LAYOUT.                                
                                                                        
           IF PARM-BC-ROW-DET-01 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              SET  WS-BC-DET-INDX           TO 1                        
              MOVE PARM-BC-ROW-DET-01       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-02 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-02       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-03 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-03       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-04 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-04       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-05 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-05       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-06 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-06       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-07 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-07       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-08 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-08       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-09 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-09       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-10 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-10       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-11 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-11       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-12 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-12       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-13 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-13       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-14 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-14       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-15 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-15       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-16 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-16       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-17 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-17       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-18 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-18       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-19 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-19       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-20 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-20       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-21 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-21       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-22 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-22       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-23 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-23       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-24 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-24       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-25 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-25       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-26 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-26       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-27 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-27       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-28 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-28       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-29 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-29       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-30 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-30       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-31 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-31       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-32 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-32       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-33 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-33       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-34 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-34       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-35 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-35       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-36 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-36       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-36 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-37       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-38 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-38       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-39 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-39       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-40 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-40       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-41 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-41       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-42 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-42       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-43 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-43       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-44 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-44       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-45 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-45       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-46 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-46       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-47 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-47       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-48 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-48       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-49 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-49       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
                                                                        
           IF PARM-BC-ROW-DET-50 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BC-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              MOVE PARM-BC-ROW-DET-50       TO WS-BC-DATA-PARSED        
              PERFORM 3300-LOAD-BC-ARRAY       THRU 3300-EXIT           
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3300-LOAD-BC-ARRAY.                                            *        
      * LOAD THE INDIVIDUAL BC AREAS INTO WS ARRAY.                    *        
      ******************************************************************        
       3300-LOAD-BC-ARRAY.                                              
      *                                                                         
           MOVE '3300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE WS-BC-DET-DATA (WS-BC-DET-INDX).                  
                                                                        
           MOVE WS-BC-PARSE-ACTION-IND    TO WS-BC-DET-ACTION-IND       
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-SEQ-NO-NUM    TO WS-BC-DET-SEQ-NO           
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-COMPONENT-ID  TO WS-BC-DET-COMPONENT-ID     
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-CNSMPTN-TYPE  TO WS-BC-DET-CNSMPTN-TYPE     
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-REGISTER-TYPE TO WS-BC-DET-REGISTER-TYPE    
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-CODE-TOU      TO WS-BC-DET-CODE-TOU         
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-CODE-SEASON   TO WS-BC-DET-CODE-SEASON      
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-RATE-VERSION  TO WS-BC-DET-RATE-VERSION     
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-NET-SEL-RSN   TO WS-BC-DET-NET-SEL-RSN      
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-READ-UNITS-VAL                              
                                          TO WS-BC-DET-READ-UNITS       
                                                      (WS-BC-DET-INDX). 
           IF WS-BC-PARSE-READ-UNITS-SGN EQUAL '-'                      
              COMPUTE WS-BC-DET-READ-UNITS (WS-BC-DET-INDX) EQUAL       
                      WS-BC-DET-READ-UNITS (WS-BC-DET-INDX) * -1        
           END-IF.                                                      
                                                                        
           MOVE WS-BC-PARSE-CALC-AMT-VAL  TO WS-DECIMAL-9V2-NUM.        
           IF WS-BC-PARSE-CALC-AMT-SGN EQUAL '-'                        
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO WS-BC-DET-CALC-CMPNT-AMT   
                                                      (WS-BC-DET-INDX). 
                                                                        
           MOVE WS-BC-PARSE-NET-AMT-VAL   TO WS-DECIMAL-9V2-NUM.        
           IF WS-BC-PARSE-NET-AMT-SGN EQUAL '-'                         
              COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL                      
                      WS-DECIMAL-9V2-NUM-RED * -1                       
           END-IF.                                                      
           MOVE WS-DECIMAL-9V2-NUM-RED    TO WS-BC-DET-NET-CMPNT-AMT    
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-EVENT-DATE    TO WS-BC-DET-EVENT-DATE       
                                                      (WS-BC-DET-INDX). 
           MOVE WS-BC-PARSE-EVENT-NO-NUM  TO WS-BC-DET-EVENT-NO         
                                                      (WS-BC-DET-INDX). 
                                                                        
           SET  WS-BC-DET-BLK-INDX        TO 1.                         
           PERFORM VARYING WS-BC-PARSE-BLK-INDX FROM 1 BY 1             
             UNTIL WS-BC-PARSE-BLK-INDX > 9                             
                OR WS-BC-PARSE-UNITS-BILLED                             
                        (WS-BC-PARSE-BLK-INDX) EQUAL SPACES             
                   MOVE WS-BC-PARSE-BLOCK-SIZE-VAL                      
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-BC-DET-BLOCK-SIZE       
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   MOVE WS-BC-PARSE-UNITS-BILLED-VAL                    
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-DECIMAL-9V4-NUM         
                   IF WS-BC-PARSE-UNITS-BILLED-SGN                      
                             (WS-BC-PARSE-BLK-INDX)  EQUAL '-'          
                      COMPUTE WS-DECIMAL-9V4-NUM-RED EQUAL              
                              WS-DECIMAL-9V4-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-9V4-NUM-RED                          
                                          TO WS-BC-DET-UNITS-BILLED     
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   MOVE WS-BC-PARSE-PRICE-TYPE-CD                       
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-BC-DET-PRICE-TYPE-CD    
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   MOVE WS-BC-PARSE-AMT-BASE-RATE-VAL                   
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-DECIMAL-5V6-NUM         
                   IF WS-BC-PARSE-AMT-BASE-RATE-SGN                     
                             (WS-BC-PARSE-BLK-INDX)  EQUAL '-'          
                      COMPUTE WS-DECIMAL-5V6-NUM-RED EQUAL              
                              WS-DECIMAL-5V6-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-5V6-NUM-RED                          
                                          TO WS-BC-DET-AMT-BASE-RATE    
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   MOVE WS-BC-PARSE-AMT-NET-RATE-VAL                    
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-DECIMAL-5V6-NUM         
                   IF WS-BC-PARSE-AMT-NET-RATE-SGN                      
                             (WS-BC-PARSE-BLK-INDX)   EQUAL '-'         
                      COMPUTE WS-DECIMAL-5V6-NUM-RED EQUAL              
                              WS-DECIMAL-5V6-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-5V6-NUM-RED                          
                                          TO WS-BC-DET-AMT-NET-RATE     
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   MOVE WS-BC-PARSE-AMT-BLOCK-VAL                       
                             (WS-BC-PARSE-BLK-INDX)                     
                                          TO WS-DECIMAL-9V2-NUM         
                   IF WS-BC-PARSE-AMT-BLOCK-SGN                         
                             (WS-BC-PARSE-BLK-INDX)  EQUAL '-'          
                      COMPUTE WS-DECIMAL-9V2-NUM-RED EQUAL              
                              WS-DECIMAL-9V2-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-9V2-NUM-RED                          
                                          TO WS-BC-DET-AMT-BLOCK        
                                     (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)
                   SET WS-BC-DET-BLK-INDX UP BY 1                       
           END-PERFORM.                                                 
           SET  WS-BC-DET-INDX UP BY 1.                                 
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3400-LOAD-BILL-ADJ.                                            *        
      * LOAD ALL BILL ADJUSTMENT DETAILS PASSED IN LINKAGE.            *        
      ******************************************************************        
       3400-LOAD-BILL-ADJ.                                              
      *                                                                         
           MOVE '3400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE WS-BA-DATA-LAYOUT.                                
                                                                        
           IF PARM-BA-ROW-DET-01 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
                         WS-MISC-PROG-VARS                              
              SET  WS-BA-DET-INDX         TO 1                          
              MOVE PARM-BA-ROW-DET-01     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-02 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-02     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-03 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-03     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-04 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-04     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-05 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-05     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-06 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-06     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-07 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-07     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-08 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-08     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-09 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-09     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-10 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-10     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-11 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-11     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-12 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-12     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-13 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-13     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-14 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-14     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-15 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-15     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-16 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-16     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-17 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-17     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-18 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-18     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-19 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-19     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-BA-ROW-DET-20 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE WS-BA-DATA-PARSED                              
              MOVE PARM-BA-ROW-DET-20     TO WS-BA-DATA-PARSED          
              PERFORM 3500-LOAD-BA-ARRAY     THRU 3500-EXIT             
           END-IF.                                                      
      *                                                                         
       3400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3500-LOAD-BA-ARRAY.                                            *        
      * LOAD THE INDIVIDUAL BA AREAS INTO WS ARRAY.                    *        
      ******************************************************************        
      *                                                                         
       3500-LOAD-BA-ARRAY.                                              
      *                                                                         
           MOVE '3500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE WS-BA-DET-DATA (WS-BA-DET-INDX).                  
                                                                        
           PERFORM VARYING WS-BA-PARSE-INDX FROM 1 BY 1                 
             UNTIL WS-BA-PARSE-INDX > 10                                
                OR WS-BA-PARSE-ACTION-IND                               
                       (WS-BA-PARSE-INDX) EQUAL SPACES                  
                   MOVE WS-BA-PARSE-ACTION-IND (WS-BA-PARSE-INDX)       
                                          TO                            
                        WS-BA-DET-ACTION-IND (WS-BA-DET-INDX)           
                   MOVE WS-BA-PARSE-SEQ-NO (WS-BA-PARSE-INDX)           
                                          TO                            
                        WS-BA-DET-SEQ-NO (WS-BA-DET-INDX)               
                   MOVE WS-BA-PARSE-COMPONENT-ID (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-COMPONENT-ID (WS-BA-DET-INDX)         
                   MOVE WS-BA-PARSE-CNSMPTN-TYPE (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-CNSMPTN-TYPE (WS-BA-DET-INDX)         
                   MOVE WS-BA-PARSE-REGISTER-TYPE (WS-BA-PARSE-INDX)    
                                          TO                            
                        WS-BA-DET-REGISTER-TYPE (WS-BA-DET-INDX)        
                   MOVE WS-BA-PARSE-CODE-TOU-NUM (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-CODE-TOU (WS-BA-DET-INDX)             
                   MOVE WS-BA-PARSE-CODE-SEASON (WS-BA-PARSE-INDX)      
                                          TO                            
                        WS-BA-DET-CODE-SEASON (WS-BA-DET-INDX)          
                   MOVE WS-BA-PARSE-RATE-VERSION (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-RATE-VERSION (WS-BA-DET-INDX)         
                   MOVE WS-BA-PARSE-FACTOR-ID (WS-BA-PARSE-INDX)        
                                          TO                            
                        WS-BA-DET-FACTOR-ID (WS-BA-DET-INDX)            
                   MOVE WS-BA-PARSE-BLOCK-NO-NUM (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-BLOCK-NO (WS-BA-DET-INDX)             
                                                                        
                   MOVE ZEROES            TO WS-DECIMAL-9V6-NUM         
                   MOVE WS-BA-PARSE-ADJ-UNITS-VAL (WS-BA-PARSE-INDX)    
                                          TO WS-DECIMAL-9V6-NUM         
                   IF WS-BA-PARSE-ADJ-UNITS-SGN                         
                          (WS-BA-PARSE-INDX) EQUAL '-'                  
                      COMPUTE WS-DECIMAL-9V6-NUM-RED EQUAL              
                              WS-DECIMAL-9V6-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-9V6-NUM-RED                          
                                          TO                            
                        WS-BA-DET-ADJ-UNITS (WS-BA-DET-INDX)            
                                                                        
                   MOVE ZEROES            TO WS-DECIMAL-9V6-NUM         
                   MOVE WS-BA-PARSE-ADJ-FACTOR-VAL (WS-BA-PARSE-INDX)   
                                          TO WS-DECIMAL-9V6-NUM         
                   IF WS-BA-PARSE-ADJ-FACTOR-SGN                        
                          (WS-BA-PARSE-INDX) EQUAL '-'                  
                      COMPUTE WS-DECIMAL-9V6-NUM-RED EQUAL              
                              WS-DECIMAL-9V6-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-9V6-NUM-RED                          
                                          TO                            
                        WS-BA-DET-ADJ-FACTOR (WS-BA-DET-INDX)           
                                                                        
                   MOVE ZEROES            TO WS-DECIMAL-9V6-NUM         
                   MOVE WS-BA-PARSE-ADJ-AMT-VAL (WS-BA-PARSE-INDX)      
                                          TO WS-DECIMAL-9V6-NUM         
                   IF WS-BA-PARSE-ADJ-AMT-SGN                           
                          (WS-BA-PARSE-INDX) EQUAL '-'                  
                      COMPUTE WS-DECIMAL-9V6-NUM-RED EQUAL              
                              WS-DECIMAL-9V6-NUM-RED * -1               
                   END-IF                                               
                   MOVE WS-DECIMAL-9V6-NUM-RED                          
                                          TO                            
                        WS-BA-DET-ADJ-AMT (WS-BA-DET-INDX)              
                                                                        
                   MOVE WS-BA-PARSE-RATE-FROM-DT (WS-BA-PARSE-INDX)     
                                          TO                            
                        WS-BA-DET-RATE-FROM-DT (WS-BA-DET-INDX)         
                   MOVE WS-BA-PARSE-ST-TAX-XMPT (WS-BA-PARSE-INDX)      
                                          TO                            
                        WS-BA-DET-ST-TAX-XMPT (WS-BA-DET-INDX)          
                   MOVE WS-BA-PARSE-CITY-TAX-XMPT (WS-BA-PARSE-INDX)    
                                          TO                            
                        WS-BA-DET-CITY-TAX-XMPT (WS-BA-DET-INDX)        
                   SET  WS-BA-DET-INDX UP BY 1                          
           END-PERFORM.                                                 
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3600-PROC-BILL-CMPNT.                                          *        
      * PROCESS UPDATES/INSERTS/DELETES FOR ALL BILL COMPONENT RECORDS.*        
      ******************************************************************        
      *                                                                         
       3600-PROC-BILL-CMPNT.                                            
      *                                                                         
           MOVE '3600'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           SET WS-BC-DET-INDX             TO 1.                         
           IF WS-BC-DET-ACTION-IND (WS-BC-DET-INDX) EQUAL               
                                          'I' OR 'U' OR 'D'             
              SET CHARGES-EDITED          TO TRUE                       
           END-IF.                                                      
                                                                        
           PERFORM VARYING WS-BC-DET-INDX FROM 1 BY 1                   
SCA006       UNTIL WS-BC-DET-INDX > 200 OR 
                   WS-BC-DET-ACTION-IND (WS-BC-DET-INDX) EQUAL SPACES           
              MOVE WS-BC                  TO NU-BILL-MANUAL-TBL-ID      
              EVALUATE WS-BC-DET-ACTION-IND (WS-BC-DET-INDX)            
                  WHEN 'U'                                              
                    MOVE WS-BC-DET-SEQ-NO (WS-BC-DET-INDX)              
                                          TO NU-BILL-MAN-DET-SEQ        
                    PERFORM 7000-GET-BILL-MAN-DET      THRU 7000-EXIT   
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       SET WS-CALC-INDX   TO 1                          
                       INITIALIZE WS-BILL-CALC-DATA (WS-CALC-INDX)      
                       MOVE NU-BILL-MANUAL-DATA-TEXT                    
                         TO WS-BILL-CALC-DATA (WS-CALC-INDX)            
                       PERFORM 3610-UPDATE-BILL-CMPNT  THRU 3610-EXIT   
                    END-IF                                              
                  WHEN 'D'                                              
                    MOVE WS-BC-DET-SEQ-NO (WS-BC-DET-INDX)              
                                          TO NU-BILL-MAN-DET-SEQ        
                    PERFORM 8250-DEL-BILL-MAN-DET      THRU 8250-EXIT   
                  WHEN 'I'                                              
                    PERFORM 3620-CREATE-BILL-CMPNT     THRU 3620-EXIT   
              END-EVALUATE                                              
           END-PERFORM.                                                 
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3610-UPDATE-BILL-CMPNT.                                        *        
      * UPDATE THE BILL COMPONENT AREA.                                *        
      ******************************************************************        
      *                                                                         
       3610-UPDATE-BILL-CMPNT.                                          
      *                                                                         
           MOVE '3610'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-BC-DET-NET-SEL-RSN       (WS-BC-DET-INDX)            
                TO WS-NET-UNIT-SEL-RSN-BC   (WS-CALC-INDX).             
           MOVE WS-BC-DET-READ-UNITS        (WS-BC-DET-INDX)            
                TO WS-READ-UNITS-BC         (WS-CALC-INDX).             
           MOVE WS-BC-DET-CALC-CMPNT-AMT    (WS-BC-DET-INDX)            
                TO WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX).             
           MOVE WS-BC-DET-NET-CMPNT-AMT     (WS-BC-DET-INDX)            
                TO WS-NET-COMPONENT-AMT-BC  (WS-CALC-INDX).             
           MOVE WS-BC-DET-RATE-VERSION      (WS-BC-DET-INDX)            
                TO WS-RATE-VERSION-BC       (WS-CALC-INDX).             
           MOVE WS-BC-DET-EVENT-DATE        (WS-BC-DET-INDX)            
                TO WS-EVENT-DATE-BC         (WS-CALC-INDX).             
                                                                        
           SET WS-BLK-INDX TO 1.                                        
           PERFORM VARYING WS-BC-DET-BLK-INDX FROM 1 BY 1               
             UNTIL WS-BC-DET-BLK-INDX > 9                               
                OR WS-BC-DET-UNITS-BILLED                               
                            (WS-BC-DET-INDX WS-BC-DET-BLK-INDX) EQUAL 0 
              MOVE WS-BC-DET-UNITS-BILLED                               
                            (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)         
                TO WS-UNITS-BILLED-BC                                   
                            (WS-CALC-INDX WS-BLK-INDX)                  
              MOVE WS-BC-DET-AMT-BASE-RATE                              
                            (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)         
                TO WS-AMT-BASE-RATE-BC                                  
                            (WS-CALC-INDX WS-BLK-INDX)                  
              MOVE WS-BC-DET-AMT-NET-RATE                               
                            (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)         
                TO WS-AMT-NET-RATE-BC                                   
                            (WS-CALC-INDX WS-BLK-INDX)                  
              MOVE WS-BC-DET-AMT-BLOCK                                  
                            (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)         
                TO WS-AMT-BLOCK-BC                                      
                            (WS-CALC-INDX WS-BLK-INDX)                  
               SET WS-BLK-INDX UP BY 1                                  
           END-PERFORM.                                                 
                                                                        
           MOVE WS-BILL-CALC-DATA (WS-CALC-INDX)                        
                TO NU-BILL-MANUAL-DATA-TEXT.                            
           PERFORM 8200-UPD-BILL-MAN-DET THRU 8200-EXIT.                
      *                                                                         
       3610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3620-CREATE-BILL-CMPNT.                                        *        
      * CREATE NEW BILL COMPONENT.                                     *        
      ******************************************************************        
      *                                                                         
       3620-CREATE-BILL-CMPNT.                                          
      *                                                                         
           MOVE '3620'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           SET  WS-CALC-INDX                TO 1.                       
           INITIALIZE WS-BILL-CALC-DATA (WS-CALC-INDX).                 
                                                                        
           MOVE NG-ACCOUNT-NO                                           
                TO WS-ACCOUNT-NO-BC (WS-CALC-INDX).                     
           MOVE NG-BILL-NO                                              
                TO WS-BILL-NO-BC (WS-CALC-INDX).                        
           MOVE NG-CODE-UTIL-TYPE                                       
                TO WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX).                 
           MOVE NG-IC-NO                                                
                TO WS-IC-NO-BC (WS-CALC-INDX).                          
           MOVE NG-BILL-ITEM-TIMESTMP                                   
                TO WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX).             
           MOVE WS-BC-DET-COMPONENT-ID (WS-BC-DET-INDX)                 
                TO WS-COMPONENT-CODE-BC (WS-CALC-INDX).                 
           MOVE WS-BC-DET-CNSMPTN-TYPE (WS-BC-DET-INDX)                 
                TO WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX).               
           MOVE WS-BC-DET-REGISTER-TYPE (WS-BC-DET-INDX)                
                TO WS-REGISTER-TYPE-BC (WS-CALC-INDX).                  
           MOVE WS-BC-DET-CODE-TOU (WS-BC-DET-INDX)                     
                TO WS-CODE-TOU-BC (WS-CALC-INDX).                       
           MOVE WS-BC-DET-CODE-SEASON (WS-BC-DET-INDX)                  
                TO WS-CODE-SEASON-BC (WS-CALC-INDX).                    
           MOVE WS-BC-DET-RATE-VERSION (WS-BC-DET-INDX)                 
                TO WS-RATE-VERSION-BC (WS-CALC-INDX).                   
           MOVE WS-BC-DET-NET-SEL-RSN (WS-BC-DET-INDX)                  
                TO WS-NET-UNIT-SEL-RSN-BC (WS-CALC-INDX).               
           MOVE WS-BC-DET-READ-UNITS (WS-BC-DET-INDX)                   
                TO WS-READ-UNITS-BC (WS-CALC-INDX)                      
           MOVE WS-BC-DET-CALC-CMPNT-AMT (WS-BC-DET-INDX)               
                TO WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX).             
           MOVE WS-BC-DET-NET-CMPNT-AMT (WS-BC-DET-INDX)                
                TO WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX).              
           MOVE WS-BC-DET-EVENT-DATE (WS-BC-DET-INDX)                   
                TO WS-EVENT-DATE-BC (WS-CALC-INDX).                     
                                                                        
           SET  WS-BLK-INDX                 TO 1.                       
           PERFORM VARYING WS-BC-DET-BLK-INDX FROM 1 BY 1               
             UNTIL WS-BC-DET-BLK-INDX > 9                               
                OR WS-BC-DET-BLOCK-SIZE                                 
                        (WS-BC-DET-INDX WS-BC-DET-BLK-INDX) EQUAL ZEROS 
                   MOVE WS-BC-DET-BLOCK-SIZE                            
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-BLOCK-SIZE-BC (WS-CALC-INDX WS-BLK-INDX)     
                   MOVE WS-BC-DET-UNITS-BILLED                          
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-UNITS-BILLED-BC (WS-CALC-INDX WS-BLK-INDX)   
                   COMPUTE WS-NET-UNITS-BC (WS-CALC-INDX) EQUAL         
                           WS-NET-UNITS-BC (WS-CALC-INDX) +             
                           WS-UNITS-BILLED-BC (WS-CALC-INDX WS-BLK-INDX)
                   END-COMPUTE                                          
                   MOVE WS-BC-DET-PRICE-TYPE-CD                         
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-PRICE-TYPE-CD-BC (WS-CALC-INDX WS-BLK-INDX)  
                   MOVE WS-BC-DET-AMT-BASE-RATE                         
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-AMT-BASE-RATE-BC (WS-CALC-INDX WS-BLK-INDX)  
                   MOVE WS-BC-DET-AMT-NET-RATE                          
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-AMT-NET-RATE-BC (WS-CALC-INDX WS-BLK-INDX)   
                   MOVE WS-BC-DET-AMT-BLOCK                             
                          (WS-BC-DET-INDX WS-BC-DET-BLK-INDX)           
                     TO WS-AMT-BLOCK-BC (WS-CALC-INDX WS-BLK-INDX)      
                   ADD +1 TO WS-BLOCKS-USED-BC (WS-CALC-INDX)           
                   SET  WS-BLK-INDX UP BY 1                             
           END-PERFORM.                                                 
                                                                        
           MOVE 'I'                                                     
                TO WS-UPDATE-ACTION-IND-BC (WS-CALC-INDX)               
                                                                        
           MOVE WS-BC                       TO NU-BILL-MANUAL-TBL-ID.   
           IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS                       
              PERFORM 7050-GET-NEXT-BILL-MAN-SEQ THRU 7050-EXIT         
           END-IF.                                                      
           MOVE WS-NXT-BILL-MAN-DET-SEQ     TO NU-BILL-MAN-DET-SEQ.     
           MOVE WS-BILL-CALC-DATA (WS-CALC-INDX)                        
                                            TO NU-BILL-MANUAL-DATA-TEXT.
           PERFORM 8350-INSERT-BILL-MAN-DET      THRU 8350-EXIT         
           COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                        
                   WS-NXT-BILL-MAN-DET-SEQ + 1.                         
                                                                        
      ****CREATE CORRESPONDING MANUAL BILL DETAIL XD RECORD                     
           PERFORM 3040-CREATE-MAN-BILL-XD       THRU 3040-EXIT.        
      *                                                                         
       3620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3700-PROC-BILL-ADJ.                                            *        
      * PROCESS UPDATES/INSERTS/DELETES FOR ALL BILL ADJUSTMENT RECORDS*        
      ******************************************************************        
      *                                                                         
       3700-PROC-BILL-ADJ.                                              
      *                                                                         
           MOVE '3700'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           SET WS-BA-DET-INDX               TO 1.                       
           IF WS-BA-DET-ACTION-IND (WS-BA-DET-INDX) EQUAL               
                                            'I' OR 'U' OR 'D'           
              SET ADJUSTMENTS-EDITED        TO TRUE                     
           END-IF.                                                      
                                                                        
           PERFORM VARYING WS-BA-DET-INDX FROM 1 BY 1                   
             UNTIL WS-BA-DET-INDX > 200                                 
                OR WS-BA-DET-ACTION-IND (WS-BA-DET-INDX) EQUAL SPACES   
              MOVE WS-BA                    TO NU-BILL-MANUAL-TBL-ID    
              EVALUATE WS-BA-DET-ACTION-IND (WS-BA-DET-INDX)            
                  WHEN 'U'                                              
                    MOVE WS-BA-DET-SEQ-NO (WS-BA-DET-INDX)              
                                            TO NU-BILL-MAN-DET-SEQ      
                    PERFORM 7000-GET-BILL-MAN-DET   THRU 7000-EXIT      
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       SET WS-BILL-ADJ-INDX TO 1                        
                       INITIALIZE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)   
                       MOVE NU-BILL-MANUAL-DATA-TEXT                    
                         TO WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)         
                       PERFORM 3710-UPDATE-BILL-ADJ THRU 3710-EXIT      
                    END-IF                                              
                  WHEN 'D'                                              
                    MOVE WS-BA-DET-SEQ-NO (WS-BA-DET-INDX)              
                                            TO NU-BILL-MAN-DET-SEQ      
                    IF WS-BA-DET-FACTOR-ID (WS-BA-DET-INDX)             
                                            = 'BFACCHRG '               
                       MOVE 'Y'             TO WS-BFC-DELETED-FLAG      
                    END-IF                                              
                    PERFORM 8250-DEL-BILL-MAN-DET   THRU 8250-EXIT      
                  WHEN 'I'                                              
                    PERFORM 3720-CREATE-BILL-ADJ    THRU 3720-EXIT      
              END-EVALUATE                                              
           END-PERFORM.                                                 
      *                                                                         
       3700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3710-UPDATE-BILL-ADJ.                                          *        
      * UPDATE THE BILL ADJUSTMENT AREA.                               *        
      ******************************************************************        
      *                                                                         
       3710-UPDATE-BILL-ADJ.                                            
      *                                                                         
           MOVE '3710'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-BA-DET-BLOCK-NO          (WS-BA-DET-INDX)            
                TO WS-BLOCK-NO-BA           (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-ADJ-UNITS         (WS-BA-DET-INDX)            
                TO WS-ADJ-UNITS-BA          (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-ADJ-FACTOR        (WS-BA-DET-INDX)            
                TO WS-FACTOR-BA             (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-ADJ-AMT           (WS-BA-DET-INDX)            
                TO WS-AMT-ADJUSTMENT-BA     (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-RATE-FROM-DT      (WS-BA-DET-INDX)            
                TO WS-RATE-FROM-DATE-BA     (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-ST-TAX-XMPT       (WS-BA-DET-INDX)            
                TO WS-STATE-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-CITY-TAX-XMPT     (WS-BA-DET-INDX)            
                TO WS-CITY-TAX-XMPT-ADJ-BA  (WS-BILL-ADJ-INDX).         
      *                                                                         
           MOVE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)                     
             TO NU-BILL-MANUAL-DATA-TEXT.                               
           PERFORM 8200-UPD-BILL-MAN-DET       THRU 8200-EXIT.          
      *                                                                         
       3710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3720-CREATE-BILL-ADJ.                                          *        
      * CREATE NEW BILL ADJUSTMENT.                                    *        
      ******************************************************************        
      *                                                                         
       3720-CREATE-BILL-ADJ.                                            
      *                                                                         
           MOVE '3720'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           SET  WS-BILL-ADJ-INDX            TO 1.                       
           INITIALIZE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX).              
                                                                        
           MOVE NG-ACCOUNT-NO                                           
                TO WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX).                 
           MOVE NG-BILL-NO                                              
                TO WS-BILL-NO-BA (WS-BILL-ADJ-INDX).                    
           MOVE NG-CODE-UTIL-TYPE                                       
                TO WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX).             
           MOVE NG-IC-NO                                                
                TO WS-IC-NO-BA (WS-BILL-ADJ-INDX).                      
           MOVE NG-BILL-ITEM-TIMESTMP                                   
                TO WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-FACTOR-ID (WS-BA-DET-INDX)                    
                TO WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX)                   
                   SF-FACTOR-ID.                                        
           MOVE WS-BA-DET-COMPONENT-ID (WS-BA-DET-INDX)                 
                TO WS-FCT-CMPNT-ID-BA (WS-BILL-ADJ-INDX).               
           MOVE WS-BA-DET-CNSMPTN-TYPE (WS-BA-DET-INDX)                 
                TO WS-FCT-CNSMPT-TYPE-BA (WS-BILL-ADJ-INDX).            
           MOVE WS-BA-DET-REGISTER-TYPE (WS-BA-DET-INDX)                
                TO WS-FCT-REGISTER-TYPE-BA (WS-BILL-ADJ-INDX).          
           MOVE WS-BA-DET-CODE-TOU (WS-BA-DET-INDX)                     
                TO WS-FCT-TOU-BA (WS-BILL-ADJ-INDX).                    
           MOVE WS-BA-DET-CODE-SEASON (WS-BA-DET-INDX)                  
                TO WS-FCT-SEASON-BA (WS-BILL-ADJ-INDX).                 
           MOVE WS-BA-DET-RATE-VERSION (WS-BA-DET-INDX)                 
                TO WS-FCT-RATE-VERSION-BA (WS-BILL-ADJ-INDX).           
           MOVE WS-BA-DET-BLOCK-NO (WS-BA-DET-INDX)                     
                TO WS-BLOCK-NO-BA (WS-BILL-ADJ-INDX).                   
           MOVE WS-BA-DET-ADJ-UNITS (WS-BA-DET-INDX)                    
                TO WS-ADJ-UNITS-BA (WS-BILL-ADJ-INDX).                  
           MOVE WS-BA-DET-ADJ-FACTOR (WS-BA-DET-INDX)                   
                TO WS-R-FACTOR-BA (WS-BILL-ADJ-INDX)                    
                   WS-FACTOR-BA (WS-BILL-ADJ-INDX).                     
           MOVE WS-BA-DET-ADJ-AMT (WS-BA-DET-INDX)                      
                TO WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX).             
           MOVE WS-BA-DET-RATE-FROM-DT (WS-BA-DET-INDX)                 
                TO WS-RATE-FROM-DATE-BA (WS-BILL-ADJ-INDX).             
           MOVE WS-BA-DET-ST-TAX-XMPT (WS-BA-DET-INDX)                  
                TO WS-STATE-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX).         
           MOVE WS-BA-DET-CITY-TAX-XMPT (WS-BA-DET-INDX)                
                TO WS-CITY-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX).          
                                                                        
      ****GET ADDITONAL FACTOR DETAILS                                          
           PERFORM 7150-SELECT-FACTOR-DETAILS    THRU 7150-EXIT.        
                                                                        
           MOVE SF-CALC-TYPE-CD                                         
                TO WS-CODE-CALC-TYPE-BA (WS-BILL-ADJ-INDX).             
           MOVE SF-CHECK-ELEMENT                                        
                TO WS-CODE-ADJ-UNIT-SOURCE-BA (WS-BILL-ADJ-INDX).       
           MOVE SF-ADJUST-ELEMENT                                       
                TO WS-CODE-ADJUST-TYPE-BA (WS-BILL-ADJ-INDX).           
           MOVE SF-VERS-PRORATE-CD                                      
                TO WS-PRORATE-CD-BA (WS-BILL-ADJ-INDX).                 
           MOVE SF-PRORATE-FL                                           
                TO WS-PRORATE-FL-BA (WS-BILL-ADJ-INDX).                 
           MOVE SF-SPCL-GROUP-CD                                        
                TO WS-SPCL-GROUP-CD-BA (WS-BILL-ADJ-INDX).              
           MOVE SF-REV-INTERFACE-FL                                     
                TO WS-REV-INTERFACE-FL-BA (WS-BILL-ADJ-INDX).           
           MOVE SF-BILL-PRT-LN-ITM-FL                                   
                TO WS-BILL-PRT-LN-ITM-FL-BA  (WS-BILL-ADJ-INDX).        
           MOVE SF-SPECIAL-CALC-CD                                      
                TO WS-SPECIAL-CALC-CD-BA (WS-BILL-ADJ-INDX).            
           MOVE SF-BILL-PRT-FCTR-CD                                     
                TO WS-BILL-PRT-FCTR-CD-BA (WS-BILL-ADJ-INDX).           
           MOVE SF-BILL-PRT-UNITS-CD                                    
                TO WS-BILL-PRT-UNITS-CD-BA (WS-BILL-ADJ-INDX).          
           MOVE SF-MULTI-VRSN-BA-CD                                     
                TO WS-MULTI-VRSN-BA-CD-BA (WS-BILL-ADJ-INDX).           
           MOVE 'I'                                                     
                TO WS-UPDATE-ACTION-IND-BA (WS-BILL-ADJ-INDX).          
                                                                        
           MOVE WS-BA                       TO NU-BILL-MANUAL-TBL-ID.   
           IF WS-NXT-BILL-MAN-DET-SEQ EQUAL ZEROS                       
              PERFORM 7050-GET-NEXT-BILL-MAN-SEQ THRU 7050-EXIT         
           END-IF.                                                      
           MOVE WS-NXT-BILL-MAN-DET-SEQ     TO NU-BILL-MAN-DET-SEQ.     
           MOVE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)                     
                                            TO NU-BILL-MANUAL-DATA-TEXT.
           PERFORM 8350-INSERT-BILL-MAN-DET      THRU 8350-EXIT         
           COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                        
                   WS-NXT-BILL-MAN-DET-SEQ + 1.                         
      *                                                                         
       3720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3800-PROCESS-BILL-MAN-DET.                                     *        
      * LOAD THE BG AND BC RECORDS INTO CWS1000B AREAS FOR PROCESSING  *        
      ******************************************************************        
      *                                                                         
       3800-PROCESS-BILL-MAN-DET.                                       
      *                                                                         
           MOVE '3800'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EVALUATE NU-BILL-MANUAL-TBL-ID                               
               WHEN WS-BG                                               
                  MOVE NU-BILL-MAN-DET-SEQ  TO WS-BG-MAN-DET-SEQ        
                  INITIALIZE WS-BILLING-DATA (WS-BILLING-INDX)          
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILLING-DATA (WS-BILLING-INDX)                
               WHEN WS-BC                                               
                  INITIALIZE WS-BILL-CALC-DATA (WS-CALC-INDX)           
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-CALC-DATA (WS-CALC-INDX)                 
                   SET WS-CALC-INDX UP BY 1                             
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 7250-FETCH-BILL-MAN-DET-CUR THRU 7250-EXIT.          
      *                                                                         
       3800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3900-SYNC-MAN-BILL-DET-BG.                                     *        
      * UPDATE THE BG RECORD BASED ON THE COMPONENT UPDATES.           *        
      ******************************************************************        
      *                                                                         
       3900-SYNC-MAN-BILL-DET-BG.                                       
      *                                                                         
           MOVE '3900'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           MOVE ZEROS                    TO WS-HOLD-AMT-BILL-ITEM       
                                            WS-HOLD-USAGE-CHARGES       
                                            WS-HOLD-DEMAND-CHARGES      
                                            WS-HOLD-STATE-TAX           
                                            WS-HOLD-FRANCHISE-TAX       
                                            WS-HOLD-GAS-BASE-USAGE.     
                                                                        
      ****ACCUMULATE THE DOLLAR AMOUNTS FROM COMPONENT AREA.                    
           PERFORM VARYING WS-CALC-INDX FROM 1 BY 1                     
SCA006       UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY OR 
                   WS-ACCOUNT-NO-BC (WS-CALC-INDX) EQUAL ZEROS                  
                   COMPUTE WS-HOLD-AMT-BILL-ITEM ROUNDED EQUAL          
                           WS-HOLD-AMT-BILL-ITEM +                      
                           WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)       
                   SET BC-INDX TO 1                                     
                   MOVE WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX)           
                     TO WS-BC-CONSUMPTION-TYPE (BC-INDX)                
                   IF ENERGY-COMPONENT (BC-INDX) AND                    
                      WS-COMPONENT-ID-BC (WS-CALC-INDX) = '10'          
                      COMPUTE WS-HOLD-USAGE-CHARGES ROUNDED EQUAL       
                              WS-HOLD-USAGE-CHARGES +                   
                              WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)    
                   END-IF                                               
                   IF DEMAND-COMPONENT (BC-INDX)                        
                      COMPUTE WS-HOLD-DEMAND-CHARGES ROUNDED EQUAL      
                              WS-HOLD-DEMAND-CHARGES +                  
                              WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)    
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
           MOVE PARM-AMT-CITY-TAX-VAL    TO WS-DECIMAL-7V2-NUM.         
           IF PARM-AMT-CITY-TAX-SGN  EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
                                                                        
           IF WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) NOT EQUAL            
              WS-DECIMAL-7V2-NUM-RED                                    
              MOVE WS-DECIMAL-7V2-NUM-RED                               
                TO WS-HOLD-FRANCHISE-TAX                                
           ELSE                                                         
              COMPUTE WS-HOLD-FRANCHISE-TAX ROUNDED EQUAL               
                      WS-HOLD-AMT-BILL-ITEM *                           
                      WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX)       
           END-IF.                                                      
                                                                        
           COMPUTE WS-HOLD-AMT-BILL-ITEM ROUNDED EQUAL                  
                   WS-HOLD-AMT-BILL-ITEM + WS-HOLD-FRANCHISE-TAX.       
                                                                        
           MOVE PARM-AMT-STATE-TAX-VAL   TO WS-DECIMAL-7V2-NUM.         
           IF PARM-AMT-STATE-TAX-SGN EQUAL '-'                          
              COMPUTE WS-DECIMAL-7V2-NUM-RED EQUAL                      
                      WS-DECIMAL-7V2-NUM-RED * -1                       
           END-IF.                                                      
                                                                        
           IF WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) NOT EQUAL           
              WS-DECIMAL-7V2-NUM-RED                                    
              MOVE WS-DECIMAL-7V2-NUM-RED                               
                TO WS-HOLD-STATE-TAX                                    
           ELSE                                                         
              COMPUTE WS-HOLD-STATE-TAX ROUNDED EQUAL                   
                      WS-HOLD-AMT-BILL-ITEM *                           
                      WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)           
           END-IF                                                       
                                                                        
           COMPUTE WS-HOLD-AMT-BILL-ITEM ROUNDED EQUAL                  
                   WS-HOLD-AMT-BILL-ITEM + WS-HOLD-STATE-TAX.           
                                                                        
           IF WS-USAGE-DOLLARS-CALC (WS-BILLING-INDX) NOT EQUAL         
              WS-HOLD-USAGE-CHARGES                                     
              MOVE WS-HOLD-USAGE-CHARGES                                
                TO WS-USAGE-DOLLARS-CALC (WS-BILLING-INDX)              
           END-IF.                                                      
                                                                        
           IF WS-DEMAND-DOLLARS-CALC (WS-BILLING-INDX) NOT EQUAL        
              WS-HOLD-DEMAND-CHARGES                                    
              MOVE WS-HOLD-DEMAND-CHARGES                               
                TO WS-DEMAND-DOLLARS-CALC (WS-BILLING-INDX)             
           END-IF.                                                      
                                                                        
           IF WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) NOT EQUAL           
              WS-HOLD-STATE-TAX                                         
              MOVE WS-HOLD-STATE-TAX                                    
                TO WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)                
           END-IF.                                                      
                                                                        
           IF WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) NOT EQUAL            
              WS-HOLD-FRANCHISE-TAX                                     
              MOVE WS-HOLD-FRANCHISE-TAX                                
                TO WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)                 
           END-IF.                                                      
                                                                        
           IF WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX) NOT EQUAL           
              WS-HOLD-AMT-BILL-ITEM                                     
              MOVE WS-HOLD-AMT-BILL-ITEM                                
                TO WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)                
           END-IF.                                                      
                                                                        
           IF PARM-STATE-TAX-XMPT NOT EQUAL                             
              WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)                 
              MOVE PARM-STATE-TAX-XMPT                                  
                TO WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)            
           END-IF.                                                      
                                                                        
           IF PARM-CITY-TAX-XMPT NOT EQUAL                              
              WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)                 
              MOVE PARM-CITY-TAX-XMPT                                   
                TO WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)            
           END-IF.                                                      
                                                                        
           MOVE PARM-BTU-FACTOR-VAL      TO WS-DECIMAL-2V5-NUM.         
           IF PARM-BTU-FACTOR-SGN EQUAL '-'                             
              COMPUTE WS-DECIMAL-2V5-NUM-RED EQUAL                      
                      WS-DECIMAL-2V5-NUM-RED * -1                       
           END-IF.                                                      
           IF WS-DECIMAL-2V5-NUM-RED NOT EQUAL                          
              WS-BTU-FACTOR-BG (WS-BILLING-INDX)                        
              MOVE WS-DECIMAL-2V5-NUM-RED                               
                TO WS-BTU-FACTOR-BG (WS-BILLING-INDX)                   
           END-IF.                                                      
                                                                        
           MOVE PARM-GAS-BASE-USE-VAL    TO WS-HOLD-GAS-BASE-USAGE.     
           IF PARM-GAS-BASE-USE-SGN EQUAL '-'                           
              COMPUTE WS-HOLD-GAS-BASE-USAGE EQUAL                      
                      WS-HOLD-GAS-BASE-USAGE * -1                       
           END-IF.                                                      
           IF WS-HOLD-GAS-BASE-USAGE NOT EQUAL                          
              WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                      
              MOVE WS-HOLD-GAS-BASE-USAGE                               
                TO WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                 
           END-IF.                                                      
                                                                        
           IF PARM-NO-OF-CONS-DAYS-NUM NOT EQUAL                        
              WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)                   
              MOVE PARM-NO-OF-CONS-DAYS-NUM                             
                TO WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)              
           END-IF.                                                      
                                                                        
           IF PARM-USAGE-END-DATE NOT EQUAL                             
              WS-USAGE-END-DATE-CALC (WS-BILLING-INDX)                  
              MOVE PARM-USAGE-END-DATE                                  
                TO WS-USAGE-END-DATE-CALC (WS-BILLING-INDX)             
           END-IF.                                                      
                                                                        
           IF PARM-BILL-CALC-CYCLE NOT EQUAL                            
              WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX)                   
              MOVE PARM-BILL-CALC-CYCLE                                 
                TO WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX)              
           END-IF.                                                      
                                                                        
           PERFORM 3950-SYNC-BASIC-FAC-CHRG THRU 3950-EXIT.             
           MOVE WS-BG                    TO NU-BILL-MANUAL-TBL-ID.      
           MOVE WS-BG-MAN-DET-SEQ        TO NU-BILL-MAN-DET-SEQ.        
           MOVE WS-BILLING-DATA (WS-BILLING-INDX)                       
                                         TO NU-BILL-MANUAL-DATA-TEXT.   
           PERFORM 8200-UPD-BILL-MAN-DET    THRU 8200-EXIT.             
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3950-SYNC-BASIC-FAC-CHRG.                                      *        
      * UPDATE THE BG RECORD BASED ON THE BFC UPDATES.                 *        
      ******************************************************************        
      *                                                                         
       3950-SYNC-BASIC-FAC-CHRG.                                        
      *                                                                         
           MOVE '3950'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           PERFORM VARYING WS-BA-DET-INDX FROM 1 BY 1                   
             UNTIL WS-BA-DET-INDX > 200                                 
                OR WS-BA-DET-ACTION-IND (WS-BA-DET-INDX) EQUAL SPACES   
                IF WS-BA-DET-FACTOR-ID (WS-BA-DET-INDX) = 'BFACCHRG '   
                   MOVE WS-BA-DET-ADJ-AMT (WS-BA-DET-INDX)              
                     TO WS-CUST-CHRG-DOLLARS-CALC (WS-BILLING-INDX)     
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           IF WS-BFC-DELETED-FLAG = 'Y'                                 
              MOVE ZEROS TO WS-CUST-CHRG-DOLLARS-CALC (WS-BILLING-INDX) 
           END-IF.                                                      
      *                                                                         
       3950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5000-BILL-CALC-PROCESS.                                       *         
      * POPULATE REQUIRED PARAMETERS FOR BILL CALC CALL.              *         
      *****************************************************************         
      *                                                                         
       5000-BILL-CALC-PROCESS.                                          
      *                                                                         
           MOVE '5000'                     TO ACTIVE-PARAGRAPH.         
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE NG-ACCOUNT-NO              TO WS-CPD4517-ACCOUNT-NO.    
           MOVE NG-CODE-UTIL-TYPE          TO WS-CPD4517-CODE-UTIL-TYPE.
           MOVE NG-IC-NO                   TO WS-CPD4517-IC-NO.         
           MOVE NG-BILL-NO                 TO WS-CPD4517-BILL-NO.       
           MOVE NG-BILL-ITEM-TIMESTMP      TO WS-CPD4517-BILL-TIMESTMP. 
           MOVE PARM-REVENUE-MONTH-NUM     TO WS-CPD4517-REVENUE-MONTH. 
                                                                        
           PERFORM 6000-CPD4517-MAIN-PROCESS  THRU 6000-CPD4517-EXIT.   
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-STORE-CNSMPTN-DATA.                                       *        
      * TRANSFER CONSUMPTION DATA RETURNED FROM BILL CALC.             *        
      ******************************************************************        
      *                                                                         
       5100-STORE-CNSMPTN-DATA.                                         
      *                                                                         
           MOVE '5100'                     TO ACTIVE-PARAGRAPH.         
           INITIALIZE WS-CNSMPTN-HIST-CX.                               
           SET WS-CNSMPTN-INDX             TO 1.                        
                                                                        
           PERFORM VARYING CX-INDX FROM 1 BY 1                          
             UNTIL CX-INDX > WS-CX-MAX-ENTRY                            
                OR WS-BC-ACCOUNT-NO-CX (CX-INDX) EQUAL ZEROS            
              MOVE WS-BC-ACCOUNT-NO-CX (CX-INDX)                        
                   TO WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)                
              MOVE WS-BC-BILL-NO-CX (CX-INDX)                           
                   TO WS-BILL-NO-CX (WS-CNSMPTN-INDX)                   
              MOVE WS-BC-CODE-UTIL-TYPE-CX (CX-INDX)                    
                   TO WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)            
              MOVE WS-BC-IC-NO-CX (CX-INDX)                             
                   TO WS-IC-NO-CX (WS-CNSMPTN-INDX)                     
              MOVE WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX)                
                   TO WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)        
              MOVE WS-BC-MTR-REF-NO-CX (CX-INDX)                        
                   TO WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)                
              MOVE WS-BC-CODE-USAGE-TYPE-CX (CX-INDX)                   
                   TO WS-CODE-USAGE-TYPE-CX (WS-CNSMPTN-INDX)           
              MOVE WS-BC-CODE-USAGE-ID-CX (CX-INDX)                     
                   TO WS-CODE-USAGE-ID-CX (WS-CNSMPTN-INDX)             
              MOVE WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX)                 
                   TO WS-CODE-USAGE-SOURCE-CX (WS-CNSMPTN-INDX)         
              MOVE WS-BC-CODE-TIME-PERIOD-CX (CX-INDX)                  
                   TO WS-CODE-TIME-PERIOD-CX (WS-CNSMPTN-INDX)          
              MOVE WS-BC-ITEM-SEQ-NO-CX (CX-INDX)                       
                   TO WS-ITEM-SEQ-NO-CX (WS-CNSMPTN-INDX)               
              MOVE WS-BC-METER-NO-CX (CX-INDX)                          
                   TO WS-METER-NO-CX (WS-CNSMPTN-INDX)                  
              MOVE WS-BC-REG-ID-NO-CX (CX-INDX)                         
                   TO WS-REG-ID-NO-CX (WS-CNSMPTN-INDX)                 
              MOVE WS-BC-DATE-READ-CX (CX-INDX)                         
                   TO WS-DATE-READ-CX (WS-CNSMPTN-INDX)                 
              MOVE WS-BC-CODE-METER-READ-CX (CX-INDX)                   
                   TO WS-CODE-METER-READ-CX (WS-CNSMPTN-INDX)           
              MOVE WS-BC-CODE-METER-NO-READ-CX (CX-INDX)                
                   TO WS-CODE-METER-NO-READ-CX (WS-CNSMPTN-INDX)        
              MOVE WS-BC-METER-READING-CX (CX-INDX)                     
                   TO WS-METER-READING-CX (WS-CNSMPTN-INDX)             
              MOVE WS-BC-DEMAND-READING-CX (CX-INDX)                    
                   TO WS-DEMAND-READING-CX (WS-CNSMPTN-INDX)            
              MOVE WS-BC-EMPLOYEE-NO-CX (CX-INDX)                       
                   TO WS-EMPLOYEE-NO-CX (WS-CNSMPTN-INDX)               
              MOVE WS-BC-NO-UNITS-CX (CX-INDX)                          
                   TO WS-NO-UNITS-CX (WS-CNSMPTN-INDX)                  
              MOVE WS-BC-NO-DEMAND-UNITS-CX (CX-INDX)                   
                   TO WS-NO-DEMAND-UNITS-CX (WS-CNSMPTN-INDX)           
              MOVE WS-BC-NO-DAYS-CX (CX-INDX)                           
                   TO WS-NO-DAYS-CX (WS-CNSMPTN-INDX)                   
              MOVE WS-BC-CODE-SOURCE-ID-CX (CX-INDX)                    
                   TO WS-CODE-SOURCE-ID-CX (WS-CNSMPTN-INDX)            
              MOVE WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX)                 
                   TO WS-CODE-DEBIT-CREDIT-CX (WS-CNSMPTN-INDX)         
              MOVE WS-BC-CODE-ITEM-STATUS-CX (CX-INDX)                  
                   TO WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)          
              MOVE WS-BC-CODE-DISCOUNT-CX (CX-INDX)                     
                   TO WS-CODE-DISCOUNT-CX (WS-CNSMPTN-INDX)             
              MOVE WS-BC-CONSTANT-CX (CX-INDX)                          
                   TO WS-CONSTANT-CX (WS-CNSMPTN-INDX)                  
              MOVE WS-BC-NO-DIALS-CX (CX-INDX)                          
                   TO WS-NO-DIALS-CX (WS-CNSMPTN-INDX)                  
              MOVE WS-BC-COMPANY-NO-CX (CX-INDX)                        
                   TO WS-COMPANY-NO-CX (WS-CNSMPTN-INDX)                
              MOVE WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX)                
                   TO WS-EXCEPT-OVERRIDE-CD-CX (WS-CNSMPTN-INDX)        
              MOVE WS-BC-REQUESTED-USAGE-CX (CX-INDX)                   
                   TO WS-REQUESTED-USAGE-CX (WS-CNSMPTN-INDX)           
              MOVE WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX)                
                   TO WS-DIGTL-INTRL-MTR-NO-CX (WS-CNSMPTN-INDX)        
              MOVE WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX)                    
                   TO WS-DIGTL-MTR-TYPE-CX (WS-CNSMPTN-INDX)            
              MOVE WS-BC-CODE-TOU-SEASN-CX (CX-INDX)                    
                   TO WS-CODE-TOU-SEASN-CX (WS-CNSMPTN-INDX)            
              MOVE WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX)                 
                   TO WS-EXCL-DMD-RCHT-IND-CX (WS-CNSMPTN-INDX)         
              MOVE WS-BC-PRV-MTR-READ-DT-CALC-CX (CX-INDX)              
                   TO WS-PREV-METER-READ-DATE-CALC (WS-CNSMPTN-INDX)    
              MOVE WS-BC-PRV-MTR-READ-COMB-FLG-CX (CX-INDX)             
                   TO WS-PRV-MTR-READ-COMB-FLG-CX (WS-CNSMPTN-INDX)     
              MOVE WS-BC-UPDATE-ACTION-IND-CX (CX-INDX)                 
                   TO WS-UPDATE-ACTION-IND-CX (WS-CNSMPTN-INDX)         
              SET  WS-CNSMPTN-INDX UP BY 1                              
           END-PERFORM.                                                 
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-PROCESS-TRAN-HIST-HDR.                                    *        
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.             *        
      ******************************************************************        
      *                                                                         
       5200-PROCESS-TRAN-HIST-HDR.                                      
      *                                                                         
           MOVE '5200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7350-GET-CURRENT-TS           THRU 7350-EXIT.        
           MOVE WS-CURRENT-TS                 TO MH-TRANS-HIST-SEQ-NO.  
           MOVE WS-CURRENT-TS(1:10)           TO MH-DATE-TRANS.         
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE SPACES                        TO MH-RESP-AREA-ID.       
           MOVE NG-ACCOUNT-NO                 TO MH-ACCOUNT-NO.         
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                      TO MH-USER-ID.            
           MOVE 'NONECALC'                    TO MH-APPL-PROGRAM-ID.    
           MOVE PARM-BILL-NO                  TO WS-TRAN-BILL-NO.       
           MOVE PARM-IC-NO                    TO WS-TRAN-IC-NO.         
           MOVE PARM-CODE-UTIL-TYPE           TO WS-TRAN-UTIL-TYPE.     
           MOVE PARM-BILL-ITEM-TIMESTMP       TO WS-TRAN-BILL-TIMESTMP. 
           MOVE SPACES                        TO WS-END-FILLER          
                                                 WS-DET-FILLER-01       
                                                 WS-DET-FILLER-02       
                                                 WS-TRAN-COMMENT-01     
                                                 WS-TRAN-COMMENT-02.    
           IF PARM-CALL-TYPE EQUAL 'D'                                  
              MOVE ' Manual Bill Calculations Deleted  '                
                   TO WS-TRAN-COMMENT-01                                
           ELSE                                                         
              IF PARM-BILL-MAN-SOURCE-CD EQUAL 'E'                      
                 MOVE ' Manual Bill Calculations Uploaded From Excel '  
                      TO WS-TRAN-COMMENT-01                             
              ELSE                                                      
                 EVALUATE WS-CHARGES-EDITED ALSO WS-ADJUSTMENTS-EDITED  
                     WHEN 'Y' ALSO 'Y'                                  
                          MOVE ' Billing Charges Updated '              
                               TO WS-TRAN-COMMENT-01                    
                          MOVE ' Billing Adjustments Updated '          
                               TO WS-TRAN-COMMENT-02                    
                     WHEN 'Y' ALSO 'N'                                  
                          MOVE ' Billing Charges Updated '              
                               TO WS-TRAN-COMMENT-01                    
                     WHEN 'N' ALSO 'Y'                                  
                          MOVE ' Billing Adjustments Updated '          
                               TO WS-TRAN-COMMENT-01                    
                     WHEN 'N' ALSO 'N'                                  
                          MOVE ' Manual Bill Calculations Updated '     
                               TO WS-TRAN-COMMENT-01                    
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE +210                          TO MH-TRAN-COMMENT-LEN.   
           MOVE WS-TRAN-COMMENT-DETAIL        TO MH-TRAN-COMMENT-TEXT.  
           PERFORM 6540-INSERT-MNT-TRANS-HIST    THRU 6540-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE 'NON001'               TO S-BUS-RULE-TYPE            
              MOVE 'R'                    TO S-BUS-RULE-RESULT          
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT            
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6000-CPD4517-MAIN-PROCESS.                                     *        
      * POPULATE REQUIRED PARAMETERS AND CALL ONLINE BILL CALC.        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD04517                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6540-INSERT-MNT-TRANS-HIST.                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6999-CPD4517-ERROR-PROCESS.                                    *        
      ******************************************************************        
      *                                                                         
       6999-CPD4517-ERROR-PROCESS.                                      
      *                                                                         
           EVALUATE WS-CPD4517-RETURN-CODE                              
               WHEN 12                                                  
                    MOVE 'NON003'             TO S-BUS-RULE-TYPE        
               WHEN 9999                                                
                    MOVE 'NON002'             TO S-BUS-RULE-TYPE        
               WHEN OTHER                                               
                    MOVE 'NON001'             TO S-BUS-RULE-TYPE        
           END-EVALUATE.                                                
                                                                        
           MOVE 'R'                           TO S-BUS-RULE-RESULT.     
           MOVE WS-CPD4517-RETURN-CODE        TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT.        
           PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT.        
      *                                                                         
       6999-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-BILL-MAN-DET.                                         *        
      * GET EXISTING DETAIL RECORDS FROM CSS_BILL_MAN_DET.             *        
      ******************************************************************        
      *                                                                         
       7000-GET-BILL-MAN-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  NU.BILL_MANUAL_DATA                                
               INTO :NU-BILL-MANUAL-DATA                                
               FROM  CSS_BILL_MAN_DET  NU WITH(READUNCOMMITTED)                 
              WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO             
                AND  NU.BILL_NO            = :NU-BILL-NO                
                AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE         
                AND  NU.IC_NO              = :NU-IC-NO                  
                AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )     
                AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ       
                AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID     
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  NU.BILL_MANUAL_DATA                                        
MFA-TR*        INTO :NU-BILL-MANUAL-DATA                                        
MFA-TR*        FROM  CSS_BILL_MAN_DET  NU                                       
MFA-TR*       WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                     
MFA-TR*         AND  NU.BILL_NO            = :NU-BILL-NO                        
MFA-TR*         AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE                 
MFA-TR*         AND  NU.IC_NO              = :NU-IC-NO                          
MFA-TR*         AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP             
MFA-TR*         AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ               
MFA-TR*         AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID             
MFA-TR*        WITH  UR                                                         
MFA-TR*     QUERYNO  7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-GET-NEXT-BILL-MAN-SEQ.                                    *        
      * GET THE NEXT AVAILABLE DETAIL SEQUENCE NUMBER.                 *        
      ******************************************************************        
      *                                                                         
       7050-GET-NEXT-BILL-MAN-SEQ.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  MAX(NU.BILL_MAN_DET_SEQ)                           
               INTO :WS-NXT-BILL-MAN-DET-SEQ :WS-NULL-IND-01             
               FROM  CSS_BILL_MAN_DET  NU                               
              WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO             
                AND  NU.BILL_NO            = :NU-BILL-NO                
                AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE         
                AND  NU.IC_NO              = :NU-IC-NO                  
                AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  MAX(NU.BILL_MAN_DET_SEQ)                                   
MFA-TR*        INTO :WS-NXT-BILL-MAN-DET-SEQ:WS-NULL-IND-01                     
MFA-TR*        FROM  CSS_BILL_MAN_DET  NU                                       
MFA-TR*       WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                     
MFA-TR*         AND  NU.BILL_NO            = :NU-BILL-NO                        
MFA-TR*         AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE                 
MFA-TR*         AND  NU.IC_NO              = :NU-IC-NO                          
MFA-TR*         AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP             
MFA-TR*     QUERYNO  7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-01 EQUAL -1                                
                 MOVE +1                      TO WS-NXT-BILL-MAN-DET-SEQ
              ELSE                                                      
                 COMPUTE WS-NXT-BILL-MAN-DET-SEQ EQUAL                  
                         WS-NXT-BILL-MAN-DET-SEQ + 1                    
              END-IF                                                    
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-BILLING-DETAIL.                                    *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-BILLING-DETAIL.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.PREMISE_NO                                     
                     ,BG.DATE_ORIG_BILL                                 
                     ,BG.AMT_BILL_ITEM                                  
                     ,BG.CODE_BILL_CALC                                 
                     ,BG.CODE_BILL_ITM_TYPE                             
                     ,BG.CODE_BILL_ITM_IND                              
                     ,BG.CODE_DR_CR_CNSMPTN                             
                     ,BG.AMT_STATE_TAX                                  
                     ,BG.AMT_CITY_TAX                                   
                     ,BG.AMT_OTHER_TAX                                  
                     ,BG.CODE_REVENUE_CLASS                             
                     ,BG.CODE_SIC_NO                                    
                     ,BG.RATE_PLAN_NO                                   
                     ,BG.CODE_CURTAIL_PRTY                              
                     ,BG.CODE_STAT_TAX_XMT                              
                     ,BG.CODE_CITY_TAX_XMT                              
                     ,BG.CODE_OTHR_TAX_XMT                              
                     ,BG.REV_RPT_CD                                     
                     ,BG.STANDBY_COMPLIED                               
                     ,BG.PRORATE_CD                                     
                     ,BG.NEW_RATE_PCT                                   
                     ,BG.CODE_SUB_TOTAL                                 
                     ,BG.TAX_REFUND_CD                                  
                     ,BG.ACCOUNT_NO                                     
                     ,BG.COMPANY_NO                                     
                     ,BG.DATE_LFTM_HI_DMD                               
                     ,BG.LFTM_HI_PEAK_DMD                               
                     ,BG.REBILL_IND                                     
                     ,BG.ADJ_REASON_CD                                  
                     ,BG.REVENUE_MONTH                                  
                     ,BG.GAS_BASE_USE                                   
                     ,BG.WNA_FACTOR                                     
                     ,BG.BTU_FACTOR                                     
                     ,BG.REV_MTH_ORIG_BILL                              
                     ,BG.BILL_CALC_CYCLE                                
                     ,BG.RT_PKG_OPT_SEQ_NO                              
                     ,BG.CITY_TAX_RATE                                  
                     ,BG.STATE_TAX_RATE                                 
                INTO :BG-PREMISE-NO                                     
                    ,:BG-DATE-ORIG-BILL :WS-NULL-IND-02                  
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-CODE-SUB-TOTAL                                 
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-ACCOUNT-NO                                     
                    ,:BG-COMPANY-NO                                     
                    ,:BG-DATE-LFTM-HI-DMD :WS-NULL-IND-03                
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-BILL-CALC-CYCLE                                
                    ,:BG-RT-PKG-OPT-SEQ-NO :WS-NULL-IND-04               
                    ,:BG-CITY-TAX-RATE                                  
                    ,:BG-STATE-TAX-RATE                                 
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.PREMISE_NO                                             
MFA-TR*              ,BG.DATE_ORIG_BILL                                         
MFA-TR*              ,BG.AMT_BILL_ITEM                                          
MFA-TR*              ,BG.CODE_BILL_CALC                                         
MFA-TR*              ,BG.CODE_BILL_ITM_TYPE                                     
MFA-TR*              ,BG.CODE_BILL_ITM_IND                                      
MFA-TR*              ,BG.CODE_DR_CR_CNSMPTN                                     
MFA-TR*              ,BG.AMT_STATE_TAX                                          
MFA-TR*              ,BG.AMT_CITY_TAX                                           
MFA-TR*              ,BG.AMT_OTHER_TAX                                          
MFA-TR*              ,BG.CODE_REVENUE_CLASS                                     
MFA-TR*              ,BG.CODE_SIC_NO                                            
MFA-TR*              ,BG.RATE_PLAN_NO                                           
MFA-TR*              ,BG.CODE_CURTAIL_PRTY                                      
MFA-TR*              ,BG.CODE_STAT_TAX_XMT                                      
MFA-TR*              ,BG.CODE_CITY_TAX_XMT                                      
MFA-TR*              ,BG.CODE_OTHR_TAX_XMT                                      
MFA-TR*              ,BG.REV_RPT_CD                                             
MFA-TR*              ,BG.STANDBY_COMPLIED                                       
MFA-TR*              ,BG.PRORATE_CD                                             
MFA-TR*              ,BG.NEW_RATE_PCT                                           
MFA-TR*              ,BG.CODE_SUB_TOTAL                                         
MFA-TR*              ,BG.TAX_REFUND_CD                                          
MFA-TR*              ,BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.COMPANY_NO                                             
MFA-TR*              ,BG.DATE_LFTM_HI_DMD                                       
MFA-TR*              ,BG.LFTM_HI_PEAK_DMD                                       
MFA-TR*              ,BG.REBILL_IND                                             
MFA-TR*              ,BG.ADJ_REASON_CD                                          
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*              ,BG.GAS_BASE_USE                                           
MFA-TR*              ,BG.WNA_FACTOR                                             
MFA-TR*              ,BG.BTU_FACTOR                                             
MFA-TR*              ,BG.REV_MTH_ORIG_BILL                                      
MFA-TR*              ,BG.BILL_CALC_CYCLE                                        
MFA-TR*              ,BG.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,BG.CITY_TAX_RATE                                          
MFA-TR*              ,BG.STATE_TAX_RATE                                         
MFA-TR*         INTO :BG-PREMISE-NO                                             
MFA-TR*             ,:BG-DATE-ORIG-BILL:WS-NULL-IND-02                          
MFA-TR*             ,:BG-AMT-BILL-ITEM                                          
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*             ,:BG-CODE-BILL-ITM-TYPE                                     
MFA-TR*             ,:BG-CODE-BILL-ITM-IND                                      
MFA-TR*             ,:BG-CODE-DR-CR-CNSMPTN                                     
MFA-TR*             ,:BG-AMT-STATE-TAX                                          
MFA-TR*             ,:BG-AMT-CITY-TAX                                           
MFA-TR*             ,:BG-AMT-OTHER-TAX                                          
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-CODE-SIC-NO                                            
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-CODE-CURTAIL-PRTY                                      
MFA-TR*             ,:BG-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-OTHR-TAX-XMT                                      
MFA-TR*             ,:BG-REV-RPT-CD                                             
MFA-TR*             ,:BG-STANDBY-COMPLIED                                       
MFA-TR*             ,:BG-PRORATE-CD                                             
MFA-TR*             ,:BG-NEW-RATE-PCT                                           
MFA-TR*             ,:BG-CODE-SUB-TOTAL                                         
MFA-TR*             ,:BG-TAX-REFUND-CD                                          
MFA-TR*             ,:BG-ACCOUNT-NO                                             
MFA-TR*             ,:BG-COMPANY-NO                                             
MFA-TR*             ,:BG-DATE-LFTM-HI-DMD:WS-NULL-IND-03                        
MFA-TR*             ,:BG-LFTM-HI-PEAK-DMD                                       
MFA-TR*             ,:BG-REBILL-IND                                             
MFA-TR*             ,:BG-ADJ-REASON-CD                                          
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-GAS-BASE-USE                                           
MFA-TR*             ,:BG-WNA-FACTOR                                             
MFA-TR*             ,:BG-BTU-FACTOR                                             
MFA-TR*             ,:BG-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:BG-BILL-CALC-CYCLE                                        
MFA-TR*             ,:BG-RT-PKG-OPT-SEQ-NO:WS-NULL-IND-04                       
MFA-TR*             ,:BG-CITY-TAX-RATE                                          
MFA-TR*             ,:BG-STATE-TAX-RATE                                         
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND-02 EQUAL -1                                
                 MOVE SPACES                  TO BG-DATE-ORIG-BILL      
                 MOVE ZEROES                  TO WS-NULL-IND-02         
              END-IF                                                    
              IF WS-NULL-IND-04 EQUAL -1                                
                 MOVE ZEROES                  TO BG-RT-PKG-OPT-SEQ-NO   
                                                 WS-NULL-IND-04         
              END-IF                                                    
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SELECT-FACTOR-DETAILS.                                    *        
      ******************************************************************        
      *                                                                         
       7150-SELECT-FACTOR-DETAILS.                                      
      *                                                                         
           EXEC SQL                                                     
               SELECT  SF.CALC_TYPE_CD                                  
                      ,SF.ADJUST_ELEMENT                                
                      ,SF.CHECK_ELEMENT                                 
                      ,SF.VERS_PRORATE_CD                               
                      ,SF.PRORATE_FL                                    
                      ,SF.SPCL_GROUP_CD                                 
                      ,SF.REV_INTERFACE_FL                              
                      ,SF.BILL_PRT_LN_ITM_FL                            
                      ,SF.SPECIAL_CALC_CD                               
                      ,SF.BILL_PRT_FCTR_CD                              
                      ,SF.BILL_PRT_UNITS_CD                             
                      ,SF.MULTI_VRSN_BA_CD                              
                 INTO                                                   
                      :SF-CALC-TYPE-CD                                  
                     ,:SF-ADJUST-ELEMENT                                
                     ,:SF-CHECK-ELEMENT                                 
                     ,:SF-VERS-PRORATE-CD                               
                     ,:SF-PRORATE-FL                                    
                     ,:SF-SPCL-GROUP-CD                                 
                     ,:SF-REV-INTERFACE-FL                              
                     ,:SF-BILL-PRT-LN-ITM-FL                            
                     ,:SF-SPECIAL-CALC-CD                               
                     ,:SF-BILL-PRT-FCTR-CD                              
                     ,:SF-BILL-PRT-UNITS-CD                             
                     ,:SF-MULTI-VRSN-BA-CD                              
                 FROM                                                   
                      CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                WHERE SF.FACTOR_ID   = :SF-FACTOR-ID                    
                  AND SF.CODE_STATUS = 'A'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SF.CALC_TYPE_CD                                          
MFA-TR*               ,SF.ADJUST_ELEMENT                                        
MFA-TR*               ,SF.CHECK_ELEMENT                                         
MFA-TR*               ,SF.VERS_PRORATE_CD                                       
MFA-TR*               ,SF.PRORATE_FL                                            
MFA-TR*               ,SF.SPCL_GROUP_CD                                         
MFA-TR*               ,SF.REV_INTERFACE_FL                                      
MFA-TR*               ,SF.BILL_PRT_LN_ITM_FL                                    
MFA-TR*               ,SF.SPECIAL_CALC_CD                                       
MFA-TR*               ,SF.BILL_PRT_FCTR_CD                                      
MFA-TR*               ,SF.BILL_PRT_UNITS_CD                                     
MFA-TR*               ,SF.MULTI_VRSN_BA_CD                                      
MFA-TR*          INTO                                                           
MFA-TR*               :SF-CALC-TYPE-CD                                          
MFA-TR*              ,:SF-ADJUST-ELEMENT                                        
MFA-TR*              ,:SF-CHECK-ELEMENT                                         
MFA-TR*              ,:SF-VERS-PRORATE-CD                                       
MFA-TR*              ,:SF-PRORATE-FL                                            
MFA-TR*              ,:SF-SPCL-GROUP-CD                                         
MFA-TR*              ,:SF-REV-INTERFACE-FL                                      
MFA-TR*              ,:SF-BILL-PRT-LN-ITM-FL                                    
MFA-TR*              ,:SF-SPECIAL-CALC-CD                                       
MFA-TR*              ,:SF-BILL-PRT-FCTR-CD                                      
MFA-TR*              ,:SF-BILL-PRT-UNITS-CD                                     
MFA-TR*              ,:SF-MULTI-VRSN-BA-CD                                      
MFA-TR*          FROM                                                           
MFA-TR*               CSS_SPCL_FCTR SF                                          
MFA-TR*         WHERE SF.FACTOR_ID   = :SF-FACTOR-ID                            
MFA-TR*           AND SF.CODE_STATUS = 'A'                                      
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-BILL-MAN-DET-CUR.                                    *        
      * OPEN BILL_MAN_DET CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7200-OPEN-BILL-MAN-DET-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN BILL_MAN_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-FETCH-BILL-MAN-DET-CUR.                                   *        
      * FETCH BILL_MAN_DET CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       7250-FETCH-BILL-MAN-DET-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH BILL_MAN_DET                                        
               INTO :NU-BILL-MAN-DET-SEQ                                
                   ,:NU-BILL-MANUAL-TBL-ID                              
                   ,:NU-BILL-MANUAL-DATA                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-BILL-MAN-DET-CUR.                                   *        
      * CLOSE BILL_MAN_DET CURSOR.                                     *        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-BILL-MAN-DET-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE BILL_MAN_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7350-GET-CURRENT-TS.                                           *        
      * GET THE CURRENT TIMESTAMP FOR TRANSACTION HISTORY              *        
      ******************************************************************        
      *                                                                         
       7350-GET-CURRENT-TS.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04517_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04517_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES                TO WS-ACTIVE-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE 'NON001'              TO S-BUS-RULE-TYPE       
                    MOVE 'R'                   TO S-BUS-RULE-RESULT     
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE SQLCODE               TO ABEND-SQLCODE         
                    MOVE SQLSTATE              TO ABEND-SQLSTATE        
                    MOVE '8000A'               TO ACTIVE-PARAGRAPH      
                    MOVE 'DELETE'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSR04517_R1'         TO TABLE-1               
                    MOVE SPACES                TO TABLE-ELEMENT-1       
                    MOVE SPACES                TO HOSTVAR-ELEMENT-1     
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04517_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,BUS_RULE_TYPE                                        
                  ,BUS_RULE_RESULT                                      
                  ,ERROR_CODE                                           
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-BUS-RULE-TYPE                                     
                  ,:S-BUS-RULE-RESULT                                   
                  ,:S-ERROR-CODE                                        
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04517_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,BUS_RULE_TYPE                                                
MFA-TR*           ,BUS_RULE_RESULT                                              
MFA-TR*           ,ERROR_CODE                                                   
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-BUS-RULE-TYPE                                             
MFA-TR*           ,:S-BUS-RULE-RESULT                                           
MFA-TR*           ,:S-ERROR-CODE                                                
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD +1                          TO CTR-ROWS               
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04517_R1'              TO TABLE-1                
              MOVE SPACES                     TO TABLE-ELEMENT-1        
              MOVE SPACES                     TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8150-DELETE-MANUAL-BILL.                                       *        
      * DELETE THE MANUAL BILL HEADER.                                 *        
      ******************************************************************        
      *                                                                         
       8150-DELETE-MANUAL-BILL.                                         
      *                                                                         
           EXEC SQL                                                     
             DELETE  FROM NG                             
             FROM CSS_BILL_MANUAL NG
              WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO             
                AND  NG.BILL_NO            = :NG-BILL-NO                
                AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE         
                AND  NG.IC_NO              = :NG-IC-NO                  
                AND  NG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE  FROM CSS_BILL_MANUAL  NG                                   
MFA-TR*       WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO                     
MFA-TR*         AND  NG.BILL_NO            = :NG-BILL-NO                        
MFA-TR*         AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE                 
MFA-TR*         AND  NG.IC_NO              = :NG-IC-NO                          
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP = :NG-BILL-ITEM-TIMESTMP             
MFA-TR*     QUERYNO  8150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-UPD-BILL-MAN-DET.                                         *        
      * UPDATE CSS_BILL_MAN_DET BE00 RECORDS.                          *        
      ******************************************************************        
      *                                                                         
       8200-UPD-BILL-MAN-DET.                                           
      *                                                                         
           MOVE LENGTH OF NU-BILL-MANUAL-DATA-TEXT                      
                                             TO NU-BILL-MANUAL-DATA-LEN.
           EXEC SQL                                                     
             UPDATE  NU                                 
                SET  NU.BILL_MANUAL_DATA   = :NU-BILL-MANUAL-DATA       
             FROM CSS_BILL_MAN_DET NU
              WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO             
                AND  NU.BILL_NO            = :NU-BILL-NO                
                AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE         
                AND  NU.IC_NO              = :NU-IC-NO                  
                AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )     
                AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ       
                AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_BILL_MAN_DET  NU                                       
MFA-TR*         SET  NU.BILL_MANUAL_DATA   = :NU-BILL-MANUAL-DATA               
MFA-TR*       WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                     
MFA-TR*         AND  NU.BILL_NO            = :NU-BILL-NO                        
MFA-TR*         AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE                 
MFA-TR*         AND  NU.IC_NO              = :NU-IC-NO                          
MFA-TR*         AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP             
MFA-TR*         AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ               
MFA-TR*         AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID             
MFA-TR*     QUERYNO  8200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              INITIALIZE                      NU-BILL-MANUAL-DATA-TEXT  
                                              NU-BILL-MANUAL-DATA-LEN   
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8250-DEL-BILL-MAN-DET.                                         *        
      * DELETE CSS_BILL_MAN_DET BE00 RECORDS.                          *        
      ******************************************************************        
      *                                                                         
       8250-DEL-BILL-MAN-DET.                                           
      *                                                                         
           EXEC SQL                                                     
             DELETE  FROM NU                            
             FROM CSS_BILL_MAN_DET NU
              WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO             
                AND  NU.BILL_NO            = :NU-BILL-NO                
                AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE         
                AND  NU.IC_NO              = :NU-IC-NO                  
                AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )     
                AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ       
                AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE  FROM CSS_BILL_MAN_DET  NU                                  
MFA-TR*       WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                     
MFA-TR*         AND  NU.BILL_NO            = :NU-BILL-NO                        
MFA-TR*         AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE                 
MFA-TR*         AND  NU.IC_NO              = :NU-IC-NO                          
MFA-TR*         AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP             
MFA-TR*         AND  NU.BILL_MAN_DET_SEQ   = :NU-BILL-MAN-DET-SEQ               
MFA-TR*         AND  NU.BILL_MANUAL_TBL_ID = :NU-BILL-MANUAL-TBL-ID             
MFA-TR*     QUERYNO  8250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-INSERT-MANUAL-BILL.                                       *        
      * CREATE NEW MANUAL BILL HEADER.                                 *        
      ******************************************************************        
      *                                                                         
       8300-INSERT-MANUAL-BILL.                                         
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_BILL_MANUAL                                
                 (  ACCOUNT_NO                                          
                   ,BILL_NO                                             
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,BILL_ITEM_TIMESTMP                                  
                   ,BILL_MAN_STATUS_CD                                  
                   ,BILL_MAN_SOURCE_CD                                  
                   ,LAST_UPDATE_USERID                                  
                   ,LAST_UPDATE_TS   )                                  
             VALUES                                                     
                 (  :NG-ACCOUNT-NO                                      
                   ,:NG-BILL-NO                                         
                   ,:NG-CODE-UTIL-TYPE                                  
                   ,:NG-IC-NO                                           
                   ,CIS.CHAR2TIMESTAMP(:NG-BILL-ITEM-TIMESTMP)                  
                   ,:NG-BILL-MAN-STATUS-CD                              
                   ,:NG-BILL-MAN-SOURCE-CD                              
                   ,:NG-LAST-UPDATE-USERID                              
                   ,CIS.CURRENT$TIMESTAMP()     )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BILL_MANUAL                                        
MFA-TR*          (  ACCOUNT_NO                                                  
MFA-TR*            ,BILL_NO                                                     
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,BILL_ITEM_TIMESTMP                                          
MFA-TR*            ,BILL_MAN_STATUS_CD                                          
MFA-TR*            ,BILL_MAN_SOURCE_CD                                          
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,LAST_UPDATE_TS   )                                          
MFA-TR*      VALUES                                                             
MFA-TR*          (  :NG-ACCOUNT-NO                                              
MFA-TR*            ,:NG-BILL-NO                                                 
MFA-TR*            ,:NG-CODE-UTIL-TYPE                                          
MFA-TR*            ,:NG-IC-NO                                                   
MFA-TR*            ,:NG-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:NG-BILL-MAN-STATUS-CD                                      
MFA-TR*            ,:NG-BILL-MAN-SOURCE-CD                                      
MFA-TR*            ,:NG-LAST-UPDATE-USERID                                      
MFA-TR*            ,CURRENT TIMESTAMP     )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8350-INSERT-BILL-MAN-DET.                                      *        
      * INSERT DATA INTO BILL MANUAL DETAIL.                           *        
      ******************************************************************        
      *                                                                         
       8350-INSERT-BILL-MAN-DET.                                        
      *                                                                         
           MOVE LENGTH OF NU-BILL-MANUAL-DATA-TEXT                      
                                             TO NU-BILL-MANUAL-DATA-LEN.
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_BILL_MAN_DET                               
                 (  ACCOUNT_NO                                          
                   ,BILL_NO                                             
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,BILL_ITEM_TIMESTMP                                  
                   ,BILL_MAN_DET_SEQ                                    
                   ,BILL_MANUAL_TBL_ID                                  
                   ,BILL_MANUAL_DATA )                                  
             VALUES                                                     
                 (  :NU-ACCOUNT-NO                                      
                   ,:NU-BILL-NO                                         
                   ,:NU-CODE-UTIL-TYPE                                  
                   ,:NU-IC-NO                                           
                   ,CIS.CHAR2TIMESTAMP(:NU-BILL-ITEM-TIMESTMP)                  
                   ,:NU-BILL-MAN-DET-SEQ                                
                   ,:NU-BILL-MANUAL-TBL-ID                              
                   ,:NU-BILL-MANUAL-DATA )                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BILL_MAN_DET                                       
MFA-TR*          (  ACCOUNT_NO                                                  
MFA-TR*            ,BILL_NO                                                     
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,BILL_ITEM_TIMESTMP                                          
MFA-TR*            ,BILL_MAN_DET_SEQ                                            
MFA-TR*            ,BILL_MANUAL_TBL_ID                                          
MFA-TR*            ,BILL_MANUAL_DATA )                                          
MFA-TR*      VALUES                                                             
MFA-TR*          (  :NU-ACCOUNT-NO                                              
MFA-TR*            ,:NU-BILL-NO                                                 
MFA-TR*            ,:NU-CODE-UTIL-TYPE                                          
MFA-TR*            ,:NU-IC-NO                                                   
MFA-TR*            ,:NU-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:NU-BILL-MAN-DET-SEQ                                        
MFA-TR*            ,:NU-BILL-MANUAL-TBL-ID                                      
MFA-TR*            ,:NU-BILL-MANUAL-DATA )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              INITIALIZE                      NU-BILL-MAN-DET-SEQ       
                                              NU-BILL-MANUAL-DATA-TEXT  
                                              NU-BILL-MANUAL-DATA-LEN   
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-UPDATE-MANUAL-BILL.                                       *        
      * UPDATE CSS_BILL_MANUAL HEADER RECORD.                          *        
      ******************************************************************        
      *                                                                         
       8400-UPDATE-MANUAL-BILL.                                         
      *                                                                         
           EXEC SQL                                                     
             UPDATE  NG                                  
                SET  NG.BILL_MAN_STATUS_CD = :NG-BILL-MAN-STATUS-CD     
                    ,NG.LAST_UPDATE_USERID = :NG-LAST-UPDATE-USERID     
             FROM CSS_BILL_MANUAL NG
              WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO             
                AND  NG.BILL_NO            = :NG-BILL-NO                
                AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE         
                AND  NG.IC_NO              = :NG-IC-NO                  
                AND  NG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_BILL_MANUAL  NG                                        
MFA-TR*         SET  NG.BILL_MAN_STATUS_CD = :NG-BILL-MAN-STATUS-CD             
MFA-TR*             ,NG.LAST_UPDATE_USERID = :NG-LAST-UPDATE-USERID             
MFA-TR*       WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO                     
MFA-TR*         AND  NG.BILL_NO            = :NG-BILL-NO                        
MFA-TR*         AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE                 
MFA-TR*         AND  NG.IC_NO              = :NG-IC-NO                          
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP = :NG-BILL-ITEM-TIMESTMP             
MFA-TR*     QUERYNO  8400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                           TO SEND-DONE-SW.          
           MOVE 100                           TO S-RETURN-CODE          
           MOVE WS-ACTIVE-RETURN-CODE         TO S-ERROR-CODE           
                                                 ABEND-SQLCODE.         
           MOVE SQLERRMC                      TO ABEND-SQLERRMC.        
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                 TO ABEND-FUNCTION         
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT             THRU 0100A-EXIT.       
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9999-END-PROGRAM'         TO ABEND-FUNCTION         
              MOVE 'PROGRAMMER LOGIC'         TO TABLE-1                
              MOVE 'FAILED TO SEND'           TO TABLE-ELEMENT-1        
              MOVE 'RESULT SET'               TO HOSTVAR-ELEMENT-1      
              MOVE 'NON001'                   TO S-BUS-RULE-TYPE        
              MOVE 'R'                        TO S-BUS-RULE-RESULT      
              MOVE -1                         TO WS-ACTIVE-RETURN-CODE  
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           ELSE                                                         
              PERFORM 8900-SEND-DONE             THRU 8900-EXIT         
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
