       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04516.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. JUL 21, 2011.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04516                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** THIS PROGRAM IS USED IN NONE-CALC BPA. THIS PROGRAM WILL    **         
      ** INSERT DATA INTO CSS_BILL_MANUAL & CSS_BILL_MAN_DET TABLES  **         
      ** USING BILL CALC DATA FROM MCSCB102/105.                     **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   CALL_TYPE              CHAR(01)                           **         
      **   ACCOUNT_NO             CHAR(13)                           **         
      **   COMPANY_NO             CHAR(02)                           **         
      **   BILL_CYCLE             CHAR(02)                           **         
      **   CODE_UTIL_TYPE         CHAR(01)                           **         
      **   IC_NO                  CHAR(04)                           **         
      **   BILL_NO                CHAR(04)                           **         
      **   BILL_ITEM_TIMESTMP     CHAR(26)                           **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET WITH DATA INSERTION SQL RETURN CODE               **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
      ** 07/21/11    GD97441      NEW PROGRAM.                       **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04516'.
MSQ017     COPY MFASQLM.
                                                                        
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MANUAL, NG                                                  
           EXEC SQL                                                             
               INCLUDE TBBILMNL                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MAN_DET, NU                                                 
           EXEC SQL                                                             
               INCLUDE TBBILMDE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MNT_TRANS_HIST, MH                                               
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MT_TRN_HST_DET, MI                                               
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_DET, BG                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_WEATHER_TREND, WT                                                
           EXEC SQL                                                             
               INCLUDE TBWTHTRD                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_READ_WINDOW, RW                                                  
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_WINDOW, BN                                                  
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04516'.      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CALL-TYPE          PIC X(01).                       
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM  REDEFINES                           
                   PARM-ACCOUNT-NO     PIC 9(13).                       
           05  PARM-COMPANY-NO         PIC X(02).                       
           05  PARM-BILL-CYCLE         PIC X(02).                       
           05  PARM-CODE-UTIL-TYPE     PIC X(01).                       
           05  PARM-IC-NO              PIC X(04).                       
           05  PARM-IC-NO-NUM       REDEFINES                           
                   PARM-IC-NO          PIC 9(04).                       
           05  PARM-BILL-NO            PIC X(04).                       
           05  PARM-BILL-NO-NUM     REDEFINES                           
                   PARM-BILL-NO        PIC 9(04).                       
           05  PARM-BILL-ITEM-TIMESTMP PIC X(26).                       
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(9) COMP VALUE 0.     
           05  S-BUS-RULE-TYPE              PIC X(06) VALUE SPACES.     
           05  S-BUS-RULE-RESULT            PIC X(01) VALUE SPACES.     
           05  S-ERROR-CODE                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-BILL-MAN-DET-SEQ          PIC S9(4) COMP VALUE 0.     
      *                                                                         
      **** CONTAINS COMMON SUBROUTINE DATA                                      
           COPY CWS0024B.                                                       
      *                                                                         
      **** CA00 WORK DATA                                                       
           COPY CWS00039.                                                       
      *                                                                         
      **** TABLE IDS USED IN BE** FILES                                         
           COPY CWS00050.                                                       
      *                                                                 00000040
      **** GL NUMBERS                                                           
           COPY CWS00061.                                                       
      *                                                                 00000040
      **** CONTAINS BE00 RECORD LAYOUTS                                         
           COPY CWS1000A.                                                       
           COPY CWS1000B.                                                       
      *                                                                 00000040
      **** CONTAINS BE01 RECORD LAYOUTS                                         
           COPY CWS1001A.                                                       
           COPY CWS1001B.                                                       
      *                                                                 00000040
      **** MCSCB102 & MCSCB105 CALL                                             
           EXEC SQL                                                     00000010
               INCLUDE CWS04515                                         00000020
           END-EXEC.                                                    00000030
      *                                                                 00000040
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
      *                                                                 00000040
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                 00000040
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE           PIC X(01).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-BILL-CYCLE          PIC X(02).                          
       01  LINK-CODE-UTIL-TYPE      PIC X(01).                          
       01  LINK-IC-NO               PIC X(04).                          
       01  LINK-BILL-NO             PIC X(04).                          
       01  LINK-BILL-ITEM-TIMESTMP  PIC X(26).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-ACCOUNT-NO                        
                                ,LINK-COMPANY-NO                        
                                ,LINK-BILL-CYCLE                        
                                ,LINK-CODE-UTIL-TYPE                    
                                ,LINK-IC-NO                             
                                ,LINK-BILL-NO                           
                                ,LINK-BILL-ITEM-TIMESTMP.               
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 1000-PROCESS-INPUT     THRU  1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT    THRU  2000-EXIT.              
           PERFORM 2500-MOVE-RESULT       THRU  2500-EXIT.              
           PERFORM 9999-END-PROGRAM       THRU  9999-EXIT.              
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE                               **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04516_R1'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04516_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04516_R1
              (                                                    
                       RETURN_CODE            INT                   
                      ,BUS_RULE_TYPE CHAR(06)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ERROR_CODE             INT                   
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS  THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04516_R1'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BUS_RULE_TYPE                                    
                      ,BUS_RULE_RESULT                                  
                      ,ERROR_CODE                                       
               FROM #CSR04516_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BUS_RULE_TYPE                                            
MFA-TR*               ,BUS_RULE_RESULT                                          
MFA-TR*               ,ERROR_CODE                                               
MFA-TR*        FROM SESSION.CSR04516_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT      THRU  0100A-EXIT.             
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO.           
           MOVE LINK-BILL-CYCLE           TO PARM-BILL-CYCLE.           
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           MOVE LINK-IC-NO                TO PARM-IC-NO.                
           MOVE LINK-BILL-NO              TO PARM-BILL-NO.              
           MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP.   
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO NG-ACCOUNT-NO              
                                             NU-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
           MOVE PARM-CODE-UTIL-TYPE       TO NG-CODE-UTIL-TYPE          
                                             NU-CODE-UTIL-TYPE          
                                             BG-CODE-UTIL-TYPE.         
           MOVE PARM-IC-NO                TO NG-IC-NO                   
                                             NU-IC-NO                   
                                             BG-IC-NO.                  
           MOVE PARM-BILL-NO              TO NG-BILL-NO                 
                                             NU-BILL-NO                 
                                             BG-BILL-NO.                
           MOVE PARM-BILL-ITEM-TIMESTMP   TO NG-BILL-ITEM-TIMESTMP      
                                             NU-BILL-ITEM-TIMESTMP      
                                             BG-BILL-ITEM-TIMESTMP.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS OUTPUT                                               **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF PARM-CALL-TYPE = 'D'                                      
              PERFORM 8400-DELETE-BILL-MANUAL  THRU  8400-EXIT          
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           INITIALIZE                        BG-REVENUE-MONTH           
                                             BG-DATE-ORIG-BILL          
                                             WS-CPD4515-INPUTS.         
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO WS-CPD4515-ACCT-NO.        
           MOVE PARM-BILL-CYCLE           TO WS-CPD4515-BILL-CYCLE.     
           MOVE PARM-COMPANY-NO           TO WS-CPD4515-COMPANY-NO.     
      *                                                                         
           PERFORM 7150-GET-REVENUE-MONTH-BG   THRU  7150-EXIT.         
           IF BG-REVENUE-MONTH > 0                                      
              MOVE BG-REVENUE-MONTH       TO WS-CPD4515-REV-MTH         
           END-IF.                                                      
PRDFIX     IF BG-CODE-BILL-CALC EQUAL 'S'                               
PRDFIX        MOVE '1900-01-01'           TO WS-CPD4515-DATE-ORIG-BILL  
PRDFIX     END-IF.                                                      
           IF BG-DATE-ORIG-BILL > '1900-01-01'                          
              MOVE BG-DATE-ORIG-BILL      TO WS-CPD4515-DATE-ORIG-BILL  
           END-IF.                                                      
      *                                                                         
           PERFORM 6000-PROCESS-BILLCALC-CPD4515  THRU                  
                   6000-CPD4515-EXIT.                                   
      *                                                                         
      **** PROCESS HEADER INFO & INSERT DATA INTO CSS_BILL_MANUAL               
      *                                                                         
      **** C -> CREATED                                                         
           MOVE 'C'                       TO NG-BILL-MAN-STATUS-CD.     
      **** B -> BILL CALC MODIFIED                                              
           MOVE 'B'                       TO NG-BILL-MAN-SOURCE-CD.     
           MOVE 'SYSTEM'                  TO NG-LAST-UPDATE-USERID.     
      *                                                                         
           PERFORM 8500-INSERT-BILL-MANUAL  THRU  8500-EXIT.            
      *                                                                         
      **** PROCESS BG AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
             UNTIL WS-BILLING-INDX > WS-BG-MAX-ENTRY                    
                OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = 0               
             IF (WS-ACCOUNT-NO-BG (WS-BILLING-INDX) =                   
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-BG (WS-BILLING-INDX) =                      
                                       PARM-BILL-NO-NUM) AND            
                (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) =               
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-BG (WS-BILLING-INDX) = PARM-IC-NO-NUM) AND    
                (WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) =           
                                PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-BG                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILLING-DATA (WS-BILLING-INDX)                  
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS BC AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-CALC-INDX FROM 1 BY 1                     
             UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY                       
                OR WS-ACCOUNT-NO-BC (WS-CALC-INDX) = 0                  
             IF (WS-ACCOUNT-NO-BC (WS-CALC-INDX) =                      
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-BC (WS-CALC-INDX) = PARM-BILL-NO-NUM) AND   
                (WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX) =                  
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-BC (WS-CALC-INDX) = PARM-IC-NO-NUM) AND       
                (WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX) =              
                                     PARM-BILL-ITEM-TIMESTMP)           
                MOVE WS-BC                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILL-CALC-DATA (WS-CALC-INDX)                   
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS BA AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1                 
             UNTIL WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY                   
                OR WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = 0              
             IF (WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) =                  
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-BA (WS-BILL-ADJ-INDX) =                     
                                       PARM-BILL-NO-NUM) AND            
                (WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX) =              
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-BA (WS-BILL-ADJ-INDX) = PARM-IC-NO-NUM) AND   
                (WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX) =          
                                PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-BA                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)                
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS BX AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-BX-INDX FROM 1 BY 1 UNTIL                 
             WS-BX-INDX > 20 OR WS-ACCOUNT-NO-BX (WS-BX-INDX) = 0       
             IF (WS-ACCOUNT-NO-BX (WS-BX-INDX) =                        
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-BX (WS-BX-INDX) = PARM-BILL-NO-NUM) AND     
                (WS-CODE-UTIL-TYPE-BX (WS-BX-INDX) =                    
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-BX (WS-BX-INDX) = PARM-IC-NO-NUM) AND         
                (WS-BILL-ITEM-TIMESTMP-BX (WS-BX-INDX)                  
                                =  PARM-BILL-ITEM-TIMESTMP)             
                MOVE WS-BX                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILL-CNTR-HIST-DATA (WS-BX-INDX)                
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS LO AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-LO-INDEX FROM 1 BY 1 UNTIL                
             WS-LO-INDEX > 20 OR WS-ACCOUNT-NO-LO (WS-LO-INDEX) = 0     
             IF (WS-ACCOUNT-NO-LO (WS-LO-INDEX) =                       
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-LO (WS-LO-INDEX) = PARM-BILL-NO-NUM) AND    
                (WS-CODE-UTIL-TYPE-LO (WS-LO-INDEX) =                   
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-LO (WS-LO-INDEX) = PARM-IC-NO-NUM) AND        
                (WS-BILL-ITEM-TIMESTMP-LO (WS-LO-INDEX) =               
                                PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-LO                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX)               
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS XD AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-CALC-X-INDX FROM 1 BY 1                   
             UNTIL WS-CALC-X-INDX > 200                                 
                OR WS-ACCOUNT-NO-XD (WS-CALC-X-INDX) = 0                
             IF (WS-ACCOUNT-NO-XD (WS-CALC-X-INDX) =                    
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-XD (WS-CALC-X-INDX) =                       
                                       PARM-BILL-NO-NUM) AND            
                (WS-CODE-UTIL-TYPE-XD (WS-CALC-X-INDX) =                
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-XD (WS-CALC-X-INDX) = PARM-IC-NO-NUM) AND     
                (WS-BILL-ITEM-TIMESTMP-XD (WS-CALC-X-INDX) =            
                                PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-XD                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-BILL-CALC-X-DATA (WS-CALC-X-INDX)               
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS CX AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
             UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY                    
                OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0               
             IF (WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) =                   
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-CX (WS-CNSMPTN-INDX) =                      
                                       PARM-BILL-NO-NUM) AND            
                (WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX) =               
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-CX (WS-CNSMPTN-INDX) = PARM-IC-NO-NUM) AND    
                (WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX) =           
                                PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-CX                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)                  
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS ND AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-ND-INDX FROM 1 BY 1                       
             UNTIL WS-ND-INDX > WS-ND-MAX-ENTRY                         
                OR WS-ACCOUNT-NO-ND (WS-ND-INDX) = 0                    
             IF (WS-ACCOUNT-NO-ND (WS-ND-INDX) =                        
                                    PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-ND (WS-ND-INDX) = PARM-BILL-NO-NUM) AND     
                (WS-CODE-UTIL-TYPE-ND (WS-ND-INDX) =                    
                                    PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-ND (WS-ND-INDX) = PARM-IC-NO-NUM) AND         
                (WS-BILL-ITEM-TIMESTMP-ND (WS-ND-INDX) =                
                                   PARM-BILL-ITEM-TIMESTMP)             
                MOVE WS-ND                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-VOL-DAILY-DATA (WS-ND-INDX)                     
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
      **** PROCESS UC AREA & INSERT DATA INTO CSS_BILL_MAN_DET                  
      *                                                                         
           PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
             UNTIL WS-UNMTRD-CNSMPTN-INDX > WS-UC-MAX-ENTRY             
                OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = 0        
             IF (WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)              
                              =     PARM-ACCOUNT-NO-NUM) AND            
                (WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                 
                              =        PARM-BILL-NO-NUM) AND            
                (WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)          
                              =     PARM-CODE-UTIL-TYPE) AND            
                (WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                   
                              =          PARM-IC-NO-NUM) AND            
                (WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)      
                              = PARM-BILL-ITEM-TIMESTMP)                
                MOVE WS-UC                TO NU-BILL-MANUAL-TBL-ID      
                MOVE WS-UNMTRD-CNSMPTN-DATA (WS-UNMTRD-CNSMPTN-INDX)    
                                          TO NU-BILL-MANUAL-DATA-TEXT   
                PERFORM 5000-CREATE-BILL-MAN-DET  THRU  5000-EXIT       
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET                                              **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT.                                                
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 'NON000'                  TO S-BUS-RULE-TYPE.           
           MOVE 'G'                       TO S-BUS-RULE-RESULT.         
      *                                                                         
           PERFORM 8100A-SEND-RESULT  THRU  8100A-EXIT.                 
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CREATE BILL MAN DET FOR VARIOUS TABLE ID'S                   **        
      ******************************************************************        
      *                                                                         
       5000-CREATE-BILL-MAN-DET.                                        
      *                                                                         
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           ADD 1                          TO WS-BILL-MAN-DET-SEQ.       
           MOVE WS-BILL-MAN-DET-SEQ       TO NU-BILL-MAN-DET-SEQ.       
           MOVE LENGTH OF NU-BILL-MANUAL-DATA-TEXT                      
                                          TO NU-BILL-MANUAL-DATA-LEN.   
      *                                                                         
           PERFORM 8550-INSERT-BILL-MAN-DET  THRU  8550-EXIT.           
      *                                                                         
           INITIALIZE                        NU-BILL-MAN-DET-SEQ        
                                             NU-BILL-MANUAL-TBL-ID      
                                             NU-BILL-MANUAL-DATA-TEXT   
                                             NU-BILL-MANUAL-DATA-LEN.   
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** JOURNALING COPYBOOK (TRANSACTION HISTORY)                    **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6000-PROCESS-102-AND-105-CPD4515 THRU 6000-CPD4515-EXIT      **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04515                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** ERROR ROUTINE FOR COPYBOOK CPD4515                           **        
      ******************************************************************        
      *                                                                 00003400
       6999-ERROR-ROUTINE-CPD4515.                                      
      *                                                                 00003400
           MOVE WS-CPD4515-RETURN-CODE    TO S-RETURN-CODE.             
      *                                                                         
           EVALUATE S-RETURN-CODE                                       
               WHEN 12                                                  
                    MOVE 'NON003'         TO S-BUS-RULE-TYPE            
               WHEN 9999                                                
                    MOVE 'NON002'         TO S-BUS-RULE-TYPE            
               WHEN OTHER                                               
                    MOVE 'NON001'         TO S-BUS-RULE-TYPE            
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6999-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REVENUE MONTH / REV MTH ORIG BILL                       **        
      ******************************************************************        
      *                                                                         
       7150-GET-REVENUE-MONTH-BG.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) COALESCE(CASE WHEN BG.REV_MTH_ORIG_BILL > 0          
                           THEN BG.REV_MTH_ORIG_BILL                    
                           ELSE BG.REVENUE_MONTH                        
                           END,0),
              COALESCE(BG.DATE_ORIG_BILL,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              BG.CODE_BILL_CALC                                  
               INTO  :BG-REVENUE-MONTH                                  
                    ,:BG-DATE-ORIG-BILL                                 
PRDFIX              ,:BG-CODE-BILL-CALC                                 
               FROM  CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
              WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO           
                AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE       
                AND  BG.IC_NO               =  :BG-IC-NO                
                AND  BG.BILL_NO             =  :BG-BILL-NO              
                AND  BG.BILL_ITEM_TIMESTMP  =  CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                AND  BG.CODE_BILL_CALC      IN ('A','S')                
                AND  BG.CODE_BILL_ITM_TYPE  =   'C'                     
                AND  BG.CODE_BILL_ITM_IND   =   'A'                     
                AND  BG.REV_RPT_CD          <>  'T'                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(CASE WHEN BG.REV_MTH_ORIG_BILL > 0                  
MFA-TR*                    THEN BG.REV_MTH_ORIG_BILL                            
MFA-TR*                    ELSE BG.REVENUE_MONTH                                
MFA-TR*                    END,0)                                               
MFA-TR*             ,IFNULL(BG.DATE_ORIG_BILL,'1900-01-01')                     
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*        INTO  :BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-DATE-ORIG-BILL                                         
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*        FROM  CSS_BILLING_DET  BG                                        
MFA-TR*       WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO                   
MFA-TR*         AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE               
MFA-TR*         AND  BG.IC_NO               =  :BG-IC-NO                        
MFA-TR*         AND  BG.BILL_NO             =  :BG-BILL-NO                      
MFA-TR*         AND  BG.BILL_ITEM_TIMESTMP  =  :BG-BILL-ITEM-TIMESTMP           
MFA-TR*         AND  BG.CODE_BILL_CALC      IN ('A','S')                        
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE  =   'C'                             
MFA-TR*         AND  BG.CODE_BILL_ITM_IND   =   'A'                             
MFA-TR*         AND  BG.REV_RPT_CD          <>  'T'                             
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE BG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00000100
      ** DELETE SESSION TABLE - HDR                                   **00000200
      ******************************************************************00000300
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04516_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04516_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04516_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE           
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04516_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************00000100
      ** SEND RESULT SET                                              **00000200
      ******************************************************************00000300
      *                                                                         
       8100A-SEND-RESULT.                                               
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04516_R1                            
             (                                                          
               RETURN_CODE                                              
              ,BUS_RULE_TYPE                                            
              ,BUS_RULE_RESULT                                          
              ,ERROR_CODE                                               
             )                                                          
             VALUES                                                     
             (                                                          
               :S-RETURN-CODE                                           
              ,:S-BUS-RULE-TYPE                                         
              ,:S-BUS-RULE-RESULT                                       
              ,:S-ERROR-CODE                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04516_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,BUS_RULE_TYPE                                                    
MFA-TR*       ,BUS_RULE_RESULT                                                  
MFA-TR*       ,ERROR_CODE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*        :S-RETURN-CODE                                                   
MFA-TR*       ,:S-BUS-RULE-TYPE                                                 
MFA-TR*       ,:S-BUS-RULE-RESULT                                               
MFA-TR*       ,:S-ERROR-CODE                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00000200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04516_R1'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                 00001700
       8100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DELETE DATA FROM CSS_BILL_MANUAL                             **        
      ******************************************************************        
      *                                                                         
       8400-DELETE-BILL-MANUAL.                                         
      *                                                                         
           EXEC SQL                                                     
             DELETE  FROM NG                             
             FROM CSS_BILL_MANUAL NG
              WHERE  NG.ACCOUNT_NO          =  :NG-ACCOUNT-NO           
                AND  NG.BILL_NO             =  :NG-BILL-NO              
                AND  NG.CODE_UTIL_TYPE      =  :NG-CODE-UTIL-TYPE       
                AND  NG.IC_NO               =  :NG-IC-NO                
                AND  NG.BILL_ITEM_TIMESTMP  =  CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE  FROM CSS_BILL_MANUAL  NG                                   
MFA-TR*       WHERE  NG.ACCOUNT_NO          =  :NG-ACCOUNT-NO                   
MFA-TR*         AND  NG.BILL_NO             =  :NG-BILL-NO                      
MFA-TR*         AND  NG.CODE_UTIL_TYPE      =  :NG-CODE-UTIL-TYPE               
MFA-TR*         AND  NG.IC_NO               =  :NG-IC-NO                        
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP  =  :NG-BILL-ITEM-TIMESTMP           
MFA-TR*      QUERYNO 8400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  INSERT DATA INTO CSS_BILL_MANUAL                            **        
      ******************************************************************        
      *                                                                         
       8500-INSERT-BILL-MANUAL.                                         
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_BILL_MANUAL                                
                 (  ACCOUNT_NO                                          
                   ,BILL_NO                                             
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,BILL_ITEM_TIMESTMP                                  
                   ,BILL_MAN_STATUS_CD                                  
                   ,BILL_MAN_SOURCE_CD                                  
                   ,LAST_UPDATE_USERID                                  
                   ,LAST_UPDATE_TS   )                                  
             VALUES                                                     
                 (  :NG-ACCOUNT-NO                                      
                   ,:NG-BILL-NO                                         
                   ,:NG-CODE-UTIL-TYPE                                  
                   ,:NG-IC-NO                                           
                   ,CIS.CHAR2TIMESTAMP(:NG-BILL-ITEM-TIMESTMP)                  
                   ,:NG-BILL-MAN-STATUS-CD                              
                   ,:NG-BILL-MAN-SOURCE-CD                              
                   ,:NG-LAST-UPDATE-USERID                              
                   ,CIS.CURRENT$TIMESTAMP()     )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BILL_MANUAL                                        
MFA-TR*          (  ACCOUNT_NO                                                  
MFA-TR*            ,BILL_NO                                                     
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,BILL_ITEM_TIMESTMP                                          
MFA-TR*            ,BILL_MAN_STATUS_CD                                          
MFA-TR*            ,BILL_MAN_SOURCE_CD                                          
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,LAST_UPDATE_TS   )                                          
MFA-TR*      VALUES                                                             
MFA-TR*          (  :NG-ACCOUNT-NO                                              
MFA-TR*            ,:NG-BILL-NO                                                 
MFA-TR*            ,:NG-CODE-UTIL-TYPE                                          
MFA-TR*            ,:NG-IC-NO                                                   
MFA-TR*            ,:NG-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:NG-BILL-MAN-STATUS-CD                                      
MFA-TR*            ,:NG-BILL-MAN-SOURCE-CD                                      
MFA-TR*            ,:NG-LAST-UPDATE-USERID                                      
MFA-TR*            ,CURRENT TIMESTAMP     )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  INSERT DATA INTO CSS_BILL_MAN_DET                           **        
      ******************************************************************        
      *                                                                         
       8550-INSERT-BILL-MAN-DET.                                        
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_BILL_MAN_DET                               
                 (  ACCOUNT_NO                                          
                   ,BILL_NO                                             
                   ,CODE_UTIL_TYPE                                      
                   ,IC_NO                                               
                   ,BILL_ITEM_TIMESTMP                                  
                   ,BILL_MAN_DET_SEQ                                    
                   ,BILL_MANUAL_TBL_ID                                  
                   ,BILL_MANUAL_DATA )                                  
             VALUES                                                     
                 (  :NU-ACCOUNT-NO                                      
                   ,:NU-BILL-NO                                         
                   ,:NU-CODE-UTIL-TYPE                                  
                   ,:NU-IC-NO                                           
                   ,CIS.CHAR2TIMESTAMP(:NU-BILL-ITEM-TIMESTMP)                  
                   ,:NU-BILL-MAN-DET-SEQ                                
                   ,:NU-BILL-MANUAL-TBL-ID                              
                   ,:NU-BILL-MANUAL-DATA )                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BILL_MAN_DET                                       
MFA-TR*          (  ACCOUNT_NO                                                  
MFA-TR*            ,BILL_NO                                                     
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,BILL_ITEM_TIMESTMP                                          
MFA-TR*            ,BILL_MAN_DET_SEQ                                            
MFA-TR*            ,BILL_MANUAL_TBL_ID                                          
MFA-TR*            ,BILL_MANUAL_DATA )                                          
MFA-TR*      VALUES                                                             
MFA-TR*          (  :NU-ACCOUNT-NO                                              
MFA-TR*            ,:NU-BILL-NO                                                 
MFA-TR*            ,:NU-CODE-UTIL-TYPE                                          
MFA-TR*            ,:NU-IC-NO                                                   
MFA-TR*            ,:NU-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:NU-BILL-MAN-DET-SEQ                                        
MFA-TR*            ,:NU-BILL-MANUAL-TBL-ID                                      
MFA-TR*            ,:NU-BILL-MANUAL-DATA )                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8550'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MAN_DET'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                 00003400
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 00003400
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU  0100A-EXIT.                 
      *                                                                         
           IF S-BUS-RULE-TYPE > SPACES                                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'NON001'            TO S-BUS-RULE-TYPE               
           END-IF.                                                      
           MOVE S-RETURN-CODE          TO S-ERROR-CODE.                 
           MOVE 100                    TO S-RETURN-CODE.                
           MOVE 'R'                    TO S-BUS-RULE-RESULT.            
      *                                                                         
           PERFORM 8100A-SEND-RESULT       THRU  8100A-EXIT.            
      *                                                                 00003400
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT.             
      *                                                                 00003400
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE      THRU  8900-EXIT.                 
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
