       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04515.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. JUL 21, 2011.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04515                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** THIS PROGRAM IS USED IN NONE-CALC PANEL/BPA. BA, BG ETC     **         
      ** TYPE OF BILL CALC DATA WILL BE SENT IN RESULT SET DATA.     **         
      ** IF DATA EXISTS IN BILL_MAN% TABLES, WE RETRIEVE THE DATA    **         
      ** AND POPULATE RESULTS OTHERWISE WE CALL MCSCB102/105 FOR     **         
      ** UNBILLED SCENARIO / MCSCB107 FOR BILLED SCENARIO.           **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   ACCOUNT_NO             CHAR(13)                           **         
      **   COMPANY_NO             CHAR(02)                           **         
      **   CODE_UTIL_TYPE         CHAR(01)                           **         
      **   IC_NO                  CHAR(04)                           **         
      **   BILL_NO                CHAR(04)                           **         
      **   BILL_ITEM_TIMESTMP     CHAR(26)                           **         
      **   DATE_BILLED            CHAR(10)                           **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET1:HEADER-NONE CALC BILL HEADER                     **         
      **   RES SET2:BG-BILLING DETAILS AREA OF BILL CALC(1910)       **         
      **   RES SET3:BC-BILL CALCULATIONS AREA OF BLL CALC(1920)      **         
      **   RES SET4:BA-BILL ADJUSTMENTS AREA OF BILL CALC(1930)      **         
      **   RES SET5:BX-BILL CONTRACT HIST AREA OF BILL CALC(2050)    **         
      **   RES SET6:LO-BILL BASELINE HIST AREA OF BILL CALC(2020)    **         
      **   RES SET7:XD-ADDL BILL CALC DET AREA OF BILL CALC(1940)    **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
      ** 07/21/11    GD97441      NEW PROGRAM.                       **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04515'.
MSQ017     COPY MFASQLM.
                                                                        
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MANUAL, NG                                                  
           EXEC SQL                                                             
               INCLUDE TBBILMNL                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_MAN_DET, NU                                                 
           EXEC SQL                                                             
               INCLUDE TBBILMDE                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_HDR, BI                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILLING_DET, BG                                                  
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_ADJUSTMNT, BP                                               
           EXEC SQL                                                             
               INCLUDE TBBILADJ                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_READ_WINDOW, RW                                                  
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_BILL_WINDOW, BN                                                  
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_ACCOUNT, AT                                                      
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUSTOMER, CN                                                     
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_NAME, DQ                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UTIL_ENVRNMT, UT                                                 
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MTRD_ENVRNMT, MN                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CNSMPTN_HIST, CX                                                 
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_UM_CNSMPT_HIST, UC                                               
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_CUST_PLAN, CP                                                    
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_SPCL_FCTR, SF                                                    
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_WEATHER_TREND, WT                                                
           EXEC SQL                                                             
               INCLUDE TBWTHTRD                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_PLAN_DESC, RD                                               
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_REVENUE_CLASS, F3                                                
           EXEC SQL                                                             
               INCLUDE TBREVCLS                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04515'.      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO PIC 9(13). 
           05  PARM-COMPANY-NO         PIC X(02).                       
           05  PARM-CODE-UTIL-TYPE     PIC X(01).                       
           05  PARM-IC-NO              PIC X(04).                       
           05  PARM-IC-NO-NUM      REDEFINES PARM-IC-NO   PIC 9(04).    
           05  PARM-BILL-NO            PIC X(04).                       
           05  PARM-BILL-NO-NUM    REDEFINES PARM-BILL-NO PIC 9(04).    
           05  PARM-BILL-ITEM-TIMESTMP PIC X(26).                       
           05  PARM-DATE-BILLED        PIC X(10).                       
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-MAIN                PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-HDR                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-BG                  PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-BC                  PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-BA                  PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-BX                  PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-LO                  PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-MAIN.                                  
               10 S-RETURN-CODE             PIC S9(9) COMP VALUE 0.     
               10 S-BUS-RULE-TYPE           PIC X(06) VALUE SPACES.     
               10 S-BUS-RULE-RESULT         PIC X(01) VALUE SPACES.     
               10 S-ERROR-CODE              PIC S9(9) COMP VALUE 0.     
      *                                                                         
           05  GTT-RETURN-FIELDS-HDR.                                   
               10 S-RETURN-CODE-HDR         PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-STATUS-CD      PIC X(01).                  
               10 S-BILL-MAN-SOURCE-CD      PIC X(01).                  
               10 S-DATA-SOURCE-CD          PIC X(01).                  
               10 S-CUSTOMER-NAME           PIC X(75).                  
               10 S-BILL-CYCLE              PIC X(02).                  
      *                                                                         
           05  GTT-RETURN-FIELDS-BG.                                    
               10 S-RETURN-CODE-BG          PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-DET-SEQ-BG     PIC S9(4) COMP VALUE 0.     
COB305         10 S-AMT-BILL-ITEM-BG        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305         10 S-AMT-STATE-TAX-BG        PIC S9(7)V99 COMP-3 VALUE 0.        
COB305         10 S-AMT-CITY-TAX-BG        PIC S9(7)V99 COMP-3 VALUE 0.        
               10 S-CODE-REVENUE-CLASS-BG   PIC X(3).                   
               10 S-REVENUE-CLS-DESC-BG     PIC X(26).                  
               10 S-RATE-PLAN-NO-BG         PIC X(03).                  
               10 S-RATE-DESC-BG            PIC X(50).                  
               10 S-CODE-STAT-TAX-XMT-BG    PIC X(01).                  
               10 S-CODE-CITY-TAX-XMT-BG    PIC X(01).                  
               10 S-PRORATE-CD-BG           PIC X(01).                  
COB305         10 S-NEW-RATE-PCT-BG        PIC S9(03)V9(04) COMP-3 
COB305           VALUE 0.    
COB305         10 S-OLD-RATE-PCT-BG        PIC S9(03)V9(04) COMP-3 
COB305           VALUE 0.    
               10 S-REBILL-IND-BG           PIC X(01).                  
               10 S-ADJ-REASON-CD-BG        PIC X(04).                  
COB305         10 S-REVENUE-MONTH-BG        PIC S9(06)V COMP-3 VALUE 0.         
COB305         10 S-BTU-FACTOR-BG        PIC S99V9(5) COMP-3 VALUE 0.        
COB305         10 S-GAS-BASE-USE-BG        PIC S9(9)V COMP-3 VALUE 0.          
               10 S-NO-OF-CONS-DAYS-BG      PIC S9(4) COMP.             
COB305         10 S-REV-MTH-ORIG-BILL-BG        PIC S9(6) COMP-3 
COB305           VALUE 0.           
COB305         10 S-TOT-NEW-CHRGS-CALC        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.       
COB305         10 S-CUST-CHRG-DOLLARS-CALC        PIC S9(07)V99 COMP-3 
COB305           VALUE 0.       
COB305         10 S-USAGE-DOLLARS-CALC        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.       
COB305         10 S-DEMAND-DOLLARS-CALC        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.       
               10 S-USAGE-END-DATE-CALC     PIC X(10).                  
COB305         10 S-FRANCHISE-TX-RATE-CALC        PIC S99V9(3) COMP-3 
COB305           VALUE 0.        
COB305         10 S-STATE-TX-RATE-CALC        PIC S99V9(3) COMP-3 
COB305           VALUE 0.        
               10 S-BILL-CALC-CYCLE-BG      PIC X(2).                   
               10 S-PRORATED-ON-NBR-DAYS-BG PIC X(01).                  
               10 S-NEW-RATE-EFF-DATE-BG    PIC X(10).                  
               10 S-OLD-RATE-EFF-DATE-BG    PIC X(10).                  
      *                                                                         
           05  GTT-RETURN-FIELDS-BC.                                    
               10 S-RETURN-CODE-BC          PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-DET-SEQ-BC     PIC S9(4) COMP VALUE 0.     
               10 S-COMPONENT-ID-BC         PIC X(3).                   
               10 S-CONSUMPTION-TYPE-BC     PIC X(1).                   
               10 S-REGISTER-TYPE-BC        PIC X(1).                   
               10 S-CODE-TOU-BC             PIC X(1).                   
               10 S-CODE-SEASON-BC          PIC X(1).                   
               10 S-RATE-VERSION-BC         PIC X(1).                   
COB305         10 S-READ-UNITS-BC        PIC S9(9) COMP-3 VALUE 0.           
               10 S-NET-UNIT-SEL-RSN-BC     PIC X(1).                   
               10 S-BLOCKS-USED-BC          PIC X(1).                   
               10 S-BLOCK-NO-BC             PIC S9(4) COMP.             
COB305         10 S-BLOCK-SIZE-BC        PIC S9(9) COMP-3 VALUE 0.           
COB305         10 S-UNITS-BILLED-BC        PIC S9(9)V9999 COMP-3 
COB305           VALUE 0.      
               10 S-PRICE-TYPE-CD-BC        PIC X(1).                   
COB305         10 S-AMT-BASE-RATE-BC        PIC S9(5)V9(6) COMP-3 
COB305           VALUE 0.      
COB305         10 S-AMT-NET-RATE-BC        PIC S9(5)V9(6) COMP-3 
COB305           VALUE 0.      
COB305         10 S-AMT-BLOCK-BC        PIC S9(9)V9(2) COMP-3 VALUE 0.      
COB305         10 S-CALC-COMPONENT-AMT-BC        PIC S9(9)V9(2) COMP-3 
COB305           VALUE 0.      
COB305         10 S-NET-COMPONENT-AMT-BC        PIC S9(9)V9(2) COMP-3 
COB305           VALUE 0.      
               10 S-EVENT-NUMBER-BC         PIC X(02).                  
               10 S-EVENT-DATE-BC           PIC X(10).                  
      *                                                                         
           05  GTT-RETURN-FIELDS-BA.                                    
               10 S-RETURN-CODE-BA          PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-DET-SEQ-BA     PIC S9(4) COMP VALUE 0.     
               10 S-FACTOR-ID-BA            PIC X(9).                   
               10 S-FCT-CMPNT-ID-BA         PIC X(3).                   
               10 S-FCT-CNSMPT-TYPE-BA      PIC X(1).                   
               10 S-FCT-REGISTER-TYPE-BA    PIC X(1).                   
               10 S-FCT-TOU-BA              PIC X(1).                   
               10 S-FCT-SEASON-BA           PIC X(1).                   
               10 S-FCT-RATE-VERSION-BA     PIC X(1).                   
               10 S-CODE-CALC-TYPE-BA       PIC X(1).                   
               10 S-CODE-ADJ-UNIT-SOURCE-BA PIC X(1).                   
               10 S-CODE-ADJUST-TYPE-BA     PIC X(1).                   
COB305         10 S-ADJ-UNITS-BA        PIC S9(9)V9(6) COMP-3 VALUE 0.      
COB305         10 S-FACTOR-BA        PIC S9(9)V9(6) COMP-3 VALUE 0.      
COB305         10 S-AMT-ADJUSTMENT-BA        PIC S9(9)V9(6) COMP-3 
COB305           VALUE 0.      
               10 S-STATE-TAX-XMPT-ADJ-BA   PIC X(1).                   
               10 S-CITY-TAX-XMPT-ADJ-BA    PIC X(1).                   
               10 S-OTHER-TAX-XMPT-ADJ-BA   PIC X(1).                   
               10 S-BLOCK-NO-BA             PIC S9(04) COMP.            
               10 S-RATE-FROM-DATE-BA       PIC X(10).                  
      *                                                                         
           05  GTT-RETURN-FIELDS-BX.                                    
               10 S-RETURN-CODE-BX          PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-DET-SEQ-BX     PIC S9(4) COMP VALUE 0.     
               10 S-CNTRCT-START-DT-BX      PIC X(10).                  
               10 S-CNTRCT-END-DT-BX        PIC X(10).                  
COB305         10 S-SPCL-ADM-CHRG-AM-BX        PIC S9(5)V99 COMP-3 
COB305           VALUE 0.        
COB305         10 S-SPCL-MO-MIN-AM-BX        PIC S9(5)V99 COMP-3 
COB305           VALUE 0.        
COB305         10 S-SPCL-ANN-MIN-AM-OLD-BX        PIC S9(5)V99 COMP-3 
COB305           VALUE 0.        
               10 S-ANN-MIN-TYPE-CD-BX      PIC X(1).                   
               10 S-CBL-REF-RATE-PLN-BX     PIC X(3).                   
               10 S-COMP-RATE-PLAN-BX       PIC X(3).                   
               10 S-COMPARE-TYPE-CD-BX      PIC X(1).                   
COB305         10 S-CANCEL-CHRG-AM-BX        PIC S9(5)V99 COMP-3 
COB305           VALUE 0.        
COB305         10 S-CONTRACT-STDBY-DEM-BX        PIC S9(7)V99 COMP-3 
COB305           VALUE 0.       
COB305         10 S-CONTRACT-DEMAND-BX        PIC S9(7)V99 COMP-3 
COB305           VALUE 0.       
COB305         10 S-FIRM-PER-HR-KWH-BX        PIC S9(7)V99 COMP-3 
COB305           VALUE 0.       
               10 S-BUILD-UP-MONTHS-BX      PIC S9(4) COMP.             
               10 S-STDBY-YTD-PK-HRS-BX     PIC S9(4) COMP.             
               10 S-STDBY-YTD-HRS-BX        PIC S9(4) COMP.             
               10 S-UPDATE-ACTION-IND-BX    PIC X(1).                   
COB305         10 S-CONTRACT-ECON-DEM-BX        PIC S9(7) COMP-3 
COB305           VALUE 0.           
COB305         10 S-MAX-ECON-DEM-BX        PIC S9(7) COMP-3 VALUE 0.           
               10 S-DEM-CNSLDTN-CD-BX       PIC X(1).                   
               10 S-DFLT-USAGE-CLS-CD-BX    PIC X(1).                   
               10 S-STDBY-LIMIT-HRS-BX      PIC S9(4) COMP.             
               10 S-STDBY-LIMIT-PK-HRS-BX   PIC S9(4) COMP.             
COB305         10 S-STDBY-RESET-MTH-BX        PIC S9(2) COMP-3 VALUE 0.         
               10 S-ALT-SPLY-RATE-NO-BX     PIC X(3).                   
               10 S-ALT-SPLY-REV-CL-CD-BX   PIC X(3).                   
               10 S-ALTERNATE-FUEL-CD-BX    PIC X(1).                   
               10 S-ALTN-FUEL-SPLY-CD-BX    PIC X(1).                   
               10 S-FUEL-SHIPPER-CD-BX      PIC X(1).                   
               10 S-VERS-PRORATE-CD-BX      PIC X(1).                   
COB305         10 S-TRNSP-SHRINK-PCT-BX        PIC S9(2)V9(2) COMP-3 
COB305           VALUE 0.      
               10 S-ANN-REVIEW-MONTH-BX     PIC X(2).                   
               10 S-CONTRACT-TERM-CD-BX     PIC X(1).                   
COB305         10 S-SPCL-ANN-MIN-AM-BX        PIC S9(9)V99 COMP-3 
COB305           VALUE 0.        
      *                                                                         
           05  GTT-RETURN-FIELDS-LO.                                    
               10 S-RETURN-CODE-LO          PIC S9(9) COMP VALUE 0.     
               10 S-BILL-MAN-DET-SEQ-LO     PIC S9(4) COMP VALUE 0.     
               10 S-CNTRCT-START-DT-LO      PIC X(10).                  
               10 S-BASELINE-MONTH-LO       PIC S9(4) USAGE COMP.       
               10 S-CMPNT-ID-CD-LO          PIC X(2).                   
               10 S-INSTR-USE-TYPE-CD-LO    PIC X(1).                   
               10 S-CODE-TIME-PERIOD-LO     PIC X(1).                   
COB305         10 S-BASELINE-UNITS-LO        PIC S9(9)V9(1) COMP-3 
COB305           VALUE 0.      
               10 S-UPDATE-ACTION-IND-LO    PIC X(1).                   
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88  SEND-DONE-ERROR                    VALUE 'N'.        
               88  SEND-DONE-OK                       VALUE 'Y'.        
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-NU-TBL1                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL2                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL3                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL4                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL5                   PIC S9(9) COMP VALUE 0.     
           05  WS-NU-TBL6                   PIC S9(9) COMP VALUE 0.     
           05  WS-RETURN-CODE-ERR           PIC S9(9) COMP VALUE 0.     
           05  WS-BUS-RULE-TYPE-ERR         PIC X(06) VALUE SPACES.     
           05  WS-BILL-MAN-DET-SEQ          PIC S9(4) COMP VALUE 0.     
           05  WS-NEW-RATE-EFF-DATE         PIC X(10) VALUE SPACES.     
           05  WS-OLD-RATE-EFF-DATE         PIC X(10) VALUE SPACES.     
           05  WS-CUSTOMER-NAME             PIC X(75) VALUE SPACES.     
           05  WS-ACCT-BILL-CYCLE           PIC X(02) VALUE SPACES.     
      *                                                                         
      **** COPYBOOKS NEEDED TO CALL BILL CALCULATION ROUTINE                    
           EXEC SQL                                                             
               INCLUDE CWS0022B                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CONTAINS COMMON SUBROUTINE DATA                                      
           COPY CWS0024B.                                                       
      *                                                                         
      **** CA00 WORK DATA                                                       
           COPY CWS00039.                                                       
      *                                                                         
      **** TABLE IDS USED IN BE** FILES                                         
           COPY CWS00050.                                                       
      *                                                                         
      **** GL NUMBERS                                                           
           COPY CWS00061.                                                       
      *                                                                         
      **** CONTAINS BE00 RECORD LAYOUTS                                         
           COPY CWS1000A.                                                       
           COPY CWS1000B.                                                       
      *                                                                         
      **** CONTAINS BE01 RECORD LAYOUTS                                         
           COPY CWS1001A.                                                       
           COPY CWS1001B.                                                       
      *                                                                         
      **** MCSCB102 & MCSCB105 CALL                                             
           EXEC SQL                                                             
               INCLUDE CWS04515                                                 
           END-EXEC.                                                            
      *                                                                         
      **** MCSCB107 CALL                                                        
           EXEC SQL                                                             
               INCLUDE CWS04517                                                 
           END-EXEC.                                                            
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** SELECT BG, BC, BA, BX, LO & XD TABLE DATA                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE  MAN_DET_CUR CURSOR FOR                            
              SELECT  NU.BILL_MAN_DET_SEQ                               
                     ,NU.BILL_MANUAL_TBL_ID                             
                     ,NU.BILL_MANUAL_DATA                               
               FROM  CSS_BILL_MAN_DET  NU WITH(READUNCOMMITTED)                 
              WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO             
                AND  NU.BILL_NO            = :NU-BILL-NO                
                AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE         
                AND  NU.IC_NO              = :NU-IC-NO                  
                AND  NU.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NU-BILL-ITEM-TIMESTMP
              )     
                AND  NU.BILL_MANUAL_TBL_ID IN (:WS-NU-TBL1,:WS-NU-TBL2  
                                  ,:WS-NU-TBL3,:WS-NU-TBL4,:WS-NU-TBL5  
                                  ,:WS-NU-TBL6)                         
             ORDER BY 2, 1                                              
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  MAN_DET_CUR CURSOR FOR                                    
MFA-TR*       SELECT  NU.BILL_MAN_DET_SEQ                                       
MFA-TR*              ,NU.BILL_MANUAL_TBL_ID                                     
MFA-TR*              ,NU.BILL_MANUAL_DATA                                       
MFA-TR*        FROM  CSS_BILL_MAN_DET  NU                                       
MFA-TR*       WHERE  NU.ACCOUNT_NO         = :NU-ACCOUNT-NO                     
MFA-TR*         AND  NU.BILL_NO            = :NU-BILL-NO                        
MFA-TR*         AND  NU.CODE_UTIL_TYPE     = :NU-CODE-UTIL-TYPE                 
MFA-TR*         AND  NU.IC_NO              = :NU-IC-NO                          
MFA-TR*         AND  NU.BILL_ITEM_TIMESTMP = :NU-BILL-ITEM-TIMESTMP             
MFA-TR*         AND  NU.BILL_MANUAL_TBL_ID IN (:WS-NU-TBL1,:WS-NU-TBL2          
MFA-TR*                           ,:WS-NU-TBL3,:WS-NU-TBL4,:WS-NU-TBL5          
MFA-TR*                           ,:WS-NU-TBL6)                                 
MFA-TR*      ORDER BY 2, 1                                                      
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-CODE-UTIL-TYPE      PIC X(01).                          
       01  LINK-IC-NO               PIC X(04).                          
       01  LINK-BILL-NO             PIC X(04).                          
       01  LINK-BILL-ITEM-TIMESTMP  PIC X(26).                          
       01  LINK-DATE-BILLED         PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO                        
                                ,LINK-COMPANY-NO                        
                                ,LINK-CODE-UTIL-TYPE                    
                                ,LINK-IC-NO                             
                                ,LINK-BILL-NO                           
                                ,LINK-BILL-ITEM-TIMESTMP                
                                ,LINK-DATE-BILLED.                      
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE        THRU  0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT     THRU  1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT    THRU  2000-EXIT.              
           PERFORM 2500-MOVE-RESULT-MAIN  THRU  2500-EXIT.              
           PERFORM 2400-VLDT-NOTFOUND-RES THRU  2400-EXIT.              
           PERFORM 9999-END-PROGRAM       THRU  9999-EXIT.              
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           MOVE WS-BG                     TO WS-NU-TBL1.                
           MOVE WS-BC                     TO WS-NU-TBL2.                
           MOVE WS-BA                     TO WS-NU-TBL3.                
           MOVE WS-BX                     TO WS-NU-TBL4.                
           MOVE WS-LO                     TO WS-NU-TBL5.                
           MOVE WS-XD                     TO WS-NU-TBL6.                
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-MAIN  THRU  0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-HDR   THRU  0100B-EXIT.            
           PERFORM 0100C-DECLARE-GTT-BG    THRU  0100C-EXIT.            
           PERFORM 0100D-DECLARE-GTT-BC    THRU  0100D-EXIT.            
           PERFORM 0100E-DECLARE-GTT-BA    THRU  0100E-EXIT.            
           PERFORM 0100F-DECLARE-GTT-BX    THRU  0100F-EXIT.            
           PERFORM 0100G-DECLARE-GTT-LO    THRU  0100G-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - MAIN                        **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-MAIN.                                          
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_MAIN'               
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_MAIN')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_MAIN
              (                                                    
                       RETURN_CODE            INT                   
                      ,BUS_RULE_TYPE CHAR(06)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ERROR_CODE             INT                   
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS-MAIN THRU 8000A-EXIT        
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_MAIN'       TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BUS_RULE_TYPE                                    
                      ,BUS_RULE_RESULT                                  
                      ,ERROR_CODE                                       
               FROM #CSR04515_MAIN                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BUS_RULE_TYPE                                            
MFA-TR*               ,BUS_RULE_RESULT                                          
MFA-TR*               ,ERROR_CODE                                               
MFA-TR*        FROM SESSION.CSR04515_MAIN                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - HDR                         **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-HDR.                                           
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_HDR'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_HDR')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_HDR
              (                                                    
                       RETURN_CODE            INT                   
                      ,BILL_MAN_STATUS_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BILL_MAN_SOURCE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,DATA_SOURCE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CUSTOMER_NAME CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BILL_CYCLE CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS-HDR THRU 8000B-EXIT         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_HDR'        TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_STATUS_CD                               
                      ,BILL_MAN_SOURCE_CD                               
                      ,DATA_SOURCE_CD                                   
                      ,CUSTOMER_NAME                                    
                      ,BILL_CYCLE                                       
               FROM #CSR04515_HDR                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_STATUS_CD                                       
MFA-TR*               ,BILL_MAN_SOURCE_CD                                       
MFA-TR*               ,DATA_SOURCE_CD                                           
MFA-TR*               ,CUSTOMER_NAME                                            
MFA-TR*               ,BILL_CYCLE                                               
MFA-TR*        FROM SESSION.CSR04515_HDR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - BG                          **        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT-BG.                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_BG'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_BG')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_BG
              (                                                    
                     RETURN_CODE              INT                   
                    ,BILL_MAN_DET_SEQ         INT                   
                    ,AMT_BILL_ITEM            DECIMAL(11,2)             
                    ,AMT_STATE_TAX            DECIMAL(9,2)              
                    ,AMT_CITY_TAX             DECIMAL(9,2)              
                    ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,REVENUE_CLS_DESC CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,CODE_STAT_TAX_XMT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CODE_CITY_TAX_XMT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,PRORATE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,NEW_RATE_PCT             DECIMAL(07,4)             
                    ,OLD_RATE_PCT             DECIMAL(07,4)             
                    ,REBILL_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,ADJ_REASON_CD CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,REVENUE_MONTH            DECIMAL(6,0)              
                    ,BTU_FACTOR               DECIMAL(7,5)              
                    ,GAS_BASE_USE             DECIMAL(9,0)              
                    ,NO_OF_CONS_DAYS          DECIMAL(4,0)              
                    ,REV_MTH_ORIG_BILL        DECIMAL(6,0)              
                    ,TOT_NEW_CHRGS_CALC       DECIMAL(11,2)             
                    ,CUST_CHRG_DOLLARS_CALC   DECIMAL(9,2)              
                    ,USAGE_DOLLARS_CALC       DECIMAL(11,2)             
                    ,DEMAND_DOLLARS_CALC      DECIMAL(11,2)             
                    ,USAGE_END_DATE_CALC CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,FRANCHISE_TX_RATE_CALC   DECIMAL(5,3)              
                    ,STATE_TX_RATE_CALC       DECIMAL(5,3)              
                    ,BILL_CALC_CYCLE CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,PRORATED_ON_NBR_DAYS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,NEW_RATE_EFF_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,OLD_RATE_EFF_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000C-DELETE-GTT-ROWS-BG THRU 8000C-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_BG'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_DET_SEQ                                 
                      ,AMT_BILL_ITEM                                    
                      ,AMT_STATE_TAX                                    
                      ,AMT_CITY_TAX                                     
                      ,CODE_REVENUE_CLASS                               
                      ,REVENUE_CLS_DESC                                 
                      ,RATE_PLAN_NO                                     
                      ,RATE_DESC                                        
                      ,CODE_STAT_TAX_XMT                                
                      ,CODE_CITY_TAX_XMT                                
                      ,PRORATE_CD                                       
                      ,NEW_RATE_PCT                                     
                      ,OLD_RATE_PCT                                     
                      ,REBILL_IND                                       
                      ,ADJ_REASON_CD                                    
                      ,REVENUE_MONTH                                    
                      ,BTU_FACTOR                                       
                      ,GAS_BASE_USE                                     
                      ,NO_OF_CONS_DAYS                                  
                      ,REV_MTH_ORIG_BILL                                
                      ,TOT_NEW_CHRGS_CALC                               
                      ,CUST_CHRG_DOLLARS_CALC                           
                      ,USAGE_DOLLARS_CALC                               
                      ,DEMAND_DOLLARS_CALC                              
                      ,USAGE_END_DATE_CALC                              
                      ,FRANCHISE_TX_RATE_CALC                           
                      ,STATE_TX_RATE_CALC                               
                      ,BILL_CALC_CYCLE                                  
                      ,PRORATED_ON_NBR_DAYS                             
                      ,NEW_RATE_EFF_DATE                                
                      ,OLD_RATE_EFF_DATE                                
               FROM #CSR04515_BG                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_DET_SEQ                                         
MFA-TR*               ,AMT_BILL_ITEM                                            
MFA-TR*               ,AMT_STATE_TAX                                            
MFA-TR*               ,AMT_CITY_TAX                                             
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,REVENUE_CLS_DESC                                         
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,CODE_STAT_TAX_XMT                                        
MFA-TR*               ,CODE_CITY_TAX_XMT                                        
MFA-TR*               ,PRORATE_CD                                               
MFA-TR*               ,NEW_RATE_PCT                                             
MFA-TR*               ,OLD_RATE_PCT                                             
MFA-TR*               ,REBILL_IND                                               
MFA-TR*               ,ADJ_REASON_CD                                            
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,GAS_BASE_USE                                             
MFA-TR*               ,NO_OF_CONS_DAYS                                          
MFA-TR*               ,REV_MTH_ORIG_BILL                                        
MFA-TR*               ,TOT_NEW_CHRGS_CALC                                       
MFA-TR*               ,CUST_CHRG_DOLLARS_CALC                                   
MFA-TR*               ,USAGE_DOLLARS_CALC                                       
MFA-TR*               ,DEMAND_DOLLARS_CALC                                      
MFA-TR*               ,USAGE_END_DATE_CALC                                      
MFA-TR*               ,FRANCHISE_TX_RATE_CALC                                   
MFA-TR*               ,STATE_TX_RATE_CALC                                       
MFA-TR*               ,BILL_CALC_CYCLE                                          
MFA-TR*               ,PRORATED_ON_NBR_DAYS                                     
MFA-TR*               ,NEW_RATE_EFF_DATE                                        
MFA-TR*               ,OLD_RATE_EFF_DATE                                        
MFA-TR*        FROM SESSION.CSR04515_BG                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - BC                          **        
      ******************************************************************        
      *                                                                         
       0100D-DECLARE-GTT-BC.                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_BC'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_BC')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_BC
              (                                                    
                     RETURN_CODE              INT                   
                    ,BILL_MAN_DET_SEQ         INT                   
                    ,COMPONENT_ID CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CONSUMPTION_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,REGISTER_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,CODE_TOU CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                    ,CODE_SEASON CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,RATE_VERSION CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,READ_UNITS               INT                   
                    ,NET_UNIT_SEL_RSN CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,BLOCKS_USED CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,BLOCK_NO                 SMALLINT                  
                    ,BLOCK_SIZE               INT                   
                    ,UNITS_BILLED             DECIMAL(13,4)             
                    ,PRICE_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,AMT_BASE_RATE            DECIMAL(11,6)             
                    ,AMT_NET_RATE             DECIMAL(11,6)             
                    ,AMT_BLOCK                DECIMAL(11,2)             
                    ,CALC_COMPONENT_AMT       DECIMAL(11,2)             
                    ,NET_COMPONENT_AMT        DECIMAL(11,2)             
                    ,EVENT_NUMBER CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                    ,EVENT_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000D-DELETE-GTT-ROWS-BC THRU 8000D-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100D'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_BC'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_DET_SEQ                                 
                      ,COMPONENT_ID                                     
                      ,CONSUMPTION_TYPE                                 
                      ,REGISTER_TYPE                                    
                      ,CODE_TOU                                         
                      ,CODE_SEASON                                      
                      ,RATE_VERSION                                     
                      ,READ_UNITS                                       
                      ,NET_UNIT_SEL_RSN                                 
                      ,BLOCKS_USED                                      
                      ,BLOCK_NO                                         
                      ,BLOCK_SIZE                                       
                      ,UNITS_BILLED                                     
                      ,PRICE_TYPE_CD                                    
                      ,AMT_BASE_RATE                                    
                      ,AMT_NET_RATE                                     
                      ,AMT_BLOCK                                        
                      ,CALC_COMPONENT_AMT                               
                      ,NET_COMPONENT_AMT                                
                      ,EVENT_NUMBER                                     
                      ,EVENT_DATE                                       
               FROM #CSR04515_BC                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_DET_SEQ                                         
MFA-TR*               ,COMPONENT_ID                                             
MFA-TR*               ,CONSUMPTION_TYPE                                         
MFA-TR*               ,REGISTER_TYPE                                            
MFA-TR*               ,CODE_TOU                                                 
MFA-TR*               ,CODE_SEASON                                              
MFA-TR*               ,RATE_VERSION                                             
MFA-TR*               ,READ_UNITS                                               
MFA-TR*               ,NET_UNIT_SEL_RSN                                         
MFA-TR*               ,BLOCKS_USED                                              
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,BLOCK_SIZE                                               
MFA-TR*               ,UNITS_BILLED                                             
MFA-TR*               ,PRICE_TYPE_CD                                            
MFA-TR*               ,AMT_BASE_RATE                                            
MFA-TR*               ,AMT_NET_RATE                                             
MFA-TR*               ,AMT_BLOCK                                                
MFA-TR*               ,CALC_COMPONENT_AMT                                       
MFA-TR*               ,NET_COMPONENT_AMT                                        
MFA-TR*               ,EVENT_NUMBER                                             
MFA-TR*               ,EVENT_DATE                                               
MFA-TR*        FROM SESSION.CSR04515_BC                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - BA                          **        
      ******************************************************************        
      *                                                                         
       0100E-DECLARE-GTT-BA.                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_BA'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_BA')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_BA
              (                                                    
                     RETURN_CODE               INT                  
                    ,BILL_MAN_DET_SEQ          INT                  
                    ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2        
                    ,FCT_CMPNT_ID CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,FCT_CNSMPT_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,FCT_REGISTER_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,FCT_TOU CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                    ,FCT_SEASON CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,FCT_RATE_VERSION CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,CODE_CALC_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,CODE_ADJ_UNIT_SOURCE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,CODE_ADJUST_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,ADJ_UNITS                 DECIMAL(15,6)            
                    ,FACTOR                    DECIMAL(15,6)            
                    ,AMT_ADJUSTMENT            DECIMAL(15,6)            
                    ,STATE_TAX_XMPT_ADJ CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,CITY_TAX_XMPT_ADJ CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,OTHER_TAX_XMPT_ADJ CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                    ,BLOCK_NO                  SMALLINT                 
                    ,RATE_FROM_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000E-DELETE-GTT-ROWS-BA THRU 8000E-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100E'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_BA'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_DET_SEQ                                 
                      ,FACTOR_ID                                        
                      ,FCT_CMPNT_ID                                     
                      ,FCT_CNSMPT_TYPE                                  
                      ,FCT_REGISTER_TYPE                                
                      ,FCT_TOU                                          
                      ,FCT_SEASON                                       
                      ,FCT_RATE_VERSION                                 
                      ,CODE_CALC_TYPE                                   
                      ,CODE_ADJ_UNIT_SOURCE                             
                      ,CODE_ADJUST_TYPE                                 
                      ,ADJ_UNITS                                        
                      ,FACTOR                                           
                      ,AMT_ADJUSTMENT                                   
                      ,STATE_TAX_XMPT_ADJ                               
                      ,CITY_TAX_XMPT_ADJ                                
                      ,OTHER_TAX_XMPT_ADJ                               
                      ,BLOCK_NO                                         
                      ,RATE_FROM_DATE                                   
               FROM #CSR04515_BA                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_DET_SEQ                                         
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,FCT_CMPNT_ID                                             
MFA-TR*               ,FCT_CNSMPT_TYPE                                          
MFA-TR*               ,FCT_REGISTER_TYPE                                        
MFA-TR*               ,FCT_TOU                                                  
MFA-TR*               ,FCT_SEASON                                               
MFA-TR*               ,FCT_RATE_VERSION                                         
MFA-TR*               ,CODE_CALC_TYPE                                           
MFA-TR*               ,CODE_ADJ_UNIT_SOURCE                                     
MFA-TR*               ,CODE_ADJUST_TYPE                                         
MFA-TR*               ,ADJ_UNITS                                                
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,AMT_ADJUSTMENT                                           
MFA-TR*               ,STATE_TAX_XMPT_ADJ                                       
MFA-TR*               ,CITY_TAX_XMPT_ADJ                                        
MFA-TR*               ,OTHER_TAX_XMPT_ADJ                                       
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,RATE_FROM_DATE                                           
MFA-TR*        FROM SESSION.CSR04515_BA                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100E-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - BX                          **        
      ******************************************************************        
      *                                                                         
       0100F-DECLARE-GTT-BX.                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_BX'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_BX')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_BX
              (                                                    
                     RETURN_CODE            INT                     
                    ,BILL_MAN_DET_SEQ       INT                     
                    ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CNTRCT_END_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,SPCL_ADM_CHRG_AM       DECIMAL(7,2)                
                    ,SPCL_MO_MIN_AM         DECIMAL(7,2)                
                    ,SPCL_ANN_MIN_AM_OLD    DECIMAL(7,2)                
                    ,ANN_MIN_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CBL_REF_RATE_PLN CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,COMP_RATE_PLAN CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,COMPARE_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CANCEL_CHRG_AM         DECIMAL(7,2)                
                    ,CONTRACT_STDBY_DEM     DECIMAL(9,2)                
                    ,CONTRACT_DEMAND        DECIMAL(9,2)                
                    ,FIRM_PER_HR_KWH        DECIMAL(9,2)                
                    ,BUILD_UP_MONTHS        SMALLINT                    
                    ,STDBY_YTD_PK_HRS       SMALLINT                    
                    ,STDBY_YTD_HRS          SMALLINT                    
                    ,UPDATE_ACTION_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CONTRACT_ECON_DEM      INT                     
                    ,MAX_ECON_DEM           INT                     
                    ,DEM_CNSLDTN_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,DFLT_USAGE_CLS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,STDBY_LIMIT_HRS        SMALLINT                    
                    ,STDBY_LIMIT_PK_HRS     SMALLINT                    
                    ,STDBY_RESET_MTH        SMALLINT                    
                    ,ALT_SPLY_RATE_NO CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,ALT_SPLY_REV_CL_CD CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,ALTERNATE_FUEL_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,ALTN_FUEL_SPLY_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,FUEL_SHIPPER_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,VERS_PRORATE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,TRNSP_SHRINK_PCT       DECIMAL(4,2)                
                    ,ANN_REVIEW_MONTH CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CONTRACT_TERM_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,SPCL_ANN_MIN_AM        DECIMAL(11,2)               
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000F-DELETE-GTT-ROWS-BX THRU 8000F-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100F'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_BX'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_DET_SEQ                                 
                      ,CNTRCT_START_DT                                  
                      ,CNTRCT_END_DT                                    
                      ,SPCL_ADM_CHRG_AM                                 
                      ,SPCL_MO_MIN_AM                                   
                      ,SPCL_ANN_MIN_AM_OLD                              
                      ,ANN_MIN_TYPE_CD                                  
                      ,CBL_REF_RATE_PLN                                 
                      ,COMP_RATE_PLAN                                   
                      ,COMPARE_TYPE_CD                                  
                      ,CANCEL_CHRG_AM                                   
                      ,CONTRACT_STDBY_DEM                               
                      ,CONTRACT_DEMAND                                  
                      ,FIRM_PER_HR_KWH                                  
                      ,BUILD_UP_MONTHS                                  
                      ,STDBY_YTD_PK_HRS                                 
                      ,STDBY_YTD_HRS                                    
                      ,UPDATE_ACTION_IND                                
                      ,CONTRACT_ECON_DEM                                
                      ,MAX_ECON_DEM                                     
                      ,DEM_CNSLDTN_CD                                   
                      ,DFLT_USAGE_CLS_CD                                
                      ,STDBY_LIMIT_HRS                                  
                      ,STDBY_LIMIT_PK_HRS                               
                      ,STDBY_RESET_MTH                                  
                      ,ALT_SPLY_RATE_NO                                 
                      ,ALT_SPLY_REV_CL_CD                               
                      ,ALTERNATE_FUEL_CD                                
                      ,ALTN_FUEL_SPLY_CD                                
                      ,FUEL_SHIPPER_CD                                  
                      ,VERS_PRORATE_CD                                  
                      ,TRNSP_SHRINK_PCT                                 
                      ,ANN_REVIEW_MONTH                                 
                      ,CONTRACT_TERM_CD                                 
                      ,SPCL_ANN_MIN_AM                                  
               FROM #CSR04515_BX                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_DET_SEQ                                         
MFA-TR*               ,CNTRCT_START_DT                                          
MFA-TR*               ,CNTRCT_END_DT                                            
MFA-TR*               ,SPCL_ADM_CHRG_AM                                         
MFA-TR*               ,SPCL_MO_MIN_AM                                           
MFA-TR*               ,SPCL_ANN_MIN_AM_OLD                                      
MFA-TR*               ,ANN_MIN_TYPE_CD                                          
MFA-TR*               ,CBL_REF_RATE_PLN                                         
MFA-TR*               ,COMP_RATE_PLAN                                           
MFA-TR*               ,COMPARE_TYPE_CD                                          
MFA-TR*               ,CANCEL_CHRG_AM                                           
MFA-TR*               ,CONTRACT_STDBY_DEM                                       
MFA-TR*               ,CONTRACT_DEMAND                                          
MFA-TR*               ,FIRM_PER_HR_KWH                                          
MFA-TR*               ,BUILD_UP_MONTHS                                          
MFA-TR*               ,STDBY_YTD_PK_HRS                                         
MFA-TR*               ,STDBY_YTD_HRS                                            
MFA-TR*               ,UPDATE_ACTION_IND                                        
MFA-TR*               ,CONTRACT_ECON_DEM                                        
MFA-TR*               ,MAX_ECON_DEM                                             
MFA-TR*               ,DEM_CNSLDTN_CD                                           
MFA-TR*               ,DFLT_USAGE_CLS_CD                                        
MFA-TR*               ,STDBY_LIMIT_HRS                                          
MFA-TR*               ,STDBY_LIMIT_PK_HRS                                       
MFA-TR*               ,STDBY_RESET_MTH                                          
MFA-TR*               ,ALT_SPLY_RATE_NO                                         
MFA-TR*               ,ALT_SPLY_REV_CL_CD                                       
MFA-TR*               ,ALTERNATE_FUEL_CD                                        
MFA-TR*               ,ALTN_FUEL_SPLY_CD                                        
MFA-TR*               ,FUEL_SHIPPER_CD                                          
MFA-TR*               ,VERS_PRORATE_CD                                          
MFA-TR*               ,TRNSP_SHRINK_PCT                                         
MFA-TR*               ,ANN_REVIEW_MONTH                                         
MFA-TR*               ,CONTRACT_TERM_CD                                         
MFA-TR*               ,SPCL_ANN_MIN_AM                                          
MFA-TR*        FROM SESSION.CSR04515_BX                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - LO                          **        
      ******************************************************************        
      *                                                                         
       0100G-DECLARE-GTT-LO.                                            
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04515_LO'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04515_LO')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04515_LO
              (                                                    
                     RETURN_CODE            INT                     
                    ,BILL_MAN_DET_SEQ       INT                     
                    ,CNTRCT_START_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,BASELINE_MONTH         SMALLINT                    
                    ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,INSTR_USE_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,CODE_TIME_PERIOD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                    ,BASELINE_UNITS         DECIMAL(10,1)               
                    ,UPDATE_ACTION_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000G-DELETE-GTT-ROWS-LO THRU 8000G-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100G'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04515_LO'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C7 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,BILL_MAN_DET_SEQ                                 
                      ,CNTRCT_START_DT                                  
                      ,BASELINE_MONTH                                   
                      ,CMPNT_ID_CD                                      
                      ,INSTR_USE_TYPE_CD                                
                      ,CODE_TIME_PERIOD                                 
                      ,BASELINE_UNITS                                   
                      ,UPDATE_ACTION_IND                                
               FROM #CSR04515_LO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,BILL_MAN_DET_SEQ                                         
MFA-TR*               ,CNTRCT_START_DT                                          
MFA-TR*               ,BASELINE_MONTH                                           
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,BASELINE_UNITS                                           
MFA-TR*               ,UPDATE_ACTION_IND                                        
MFA-TR*        FROM SESSION.CSR04515_LO                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100G-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO.           
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           MOVE LINK-IC-NO                TO PARM-IC-NO.                
           MOVE LINK-BILL-NO              TO PARM-BILL-NO.              
           MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP.   
           MOVE LINK-DATE-BILLED          TO PARM-DATE-BILLED.          
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO              
                                             NG-ACCOUNT-NO              
                                             NU-ACCOUNT-NO              
                                             BG-ACCOUNT-NO.             
           MOVE PARM-COMPANY-NO           TO RD-COMPANY-NO              
                                             F3-COMPANY-NO.             
           MOVE PARM-CODE-UTIL-TYPE       TO NG-CODE-UTIL-TYPE          
                                             NU-CODE-UTIL-TYPE          
                                             BG-CODE-UTIL-TYPE          
                                             RD-CODE-UTIL-TYPE          
                                             F3-CODE-UTIL-TYPE.         
           MOVE PARM-IC-NO                TO NG-IC-NO                   
                                             NU-IC-NO                   
                                             BG-IC-NO.                  
           MOVE PARM-BILL-NO              TO NG-BILL-NO                 
                                             NU-BILL-NO                 
                                             BG-BILL-NO.                
           MOVE PARM-BILL-ITEM-TIMESTMP   TO NG-BILL-ITEM-TIMESTMP      
                                             NU-BILL-ITEM-TIMESTMP      
                                             BG-BILL-ITEM-TIMESTMP.     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CASE1: IF DATA EXISTS IN BILL_MANUAL, GET BILL_MAN_DET DATA  **        
      **        AND POPULATE RESULTS                                  **        
      ** CASE2: IF DATA DOES NOT EXISTS IN CASE1 & ALREADY BILLED     **        
      **        SCENARIO THEN CALL MCSCB107 & POPULATE RESULTS        **        
      ** CASE3: IF DATA DOES NOT EXISTS IN CASE1 & UNBILLED SCNEARIO  **        
      **        THEN CALL MCSCB102/MCSCB105 AND POPULATE RESULTS      **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE SPACES                    TO WS-CUSTOMER-NAME           
                                             WS-ACCT-BILL-CYCLE.        
      *                                                                         
           PERFORM 7000-GET-ACCOUNT-DETAILS THRU  7000-EXIT.            
      *                                                                         
           PERFORM 7050-SELECT-BILL-MANUAL  THRU  7050-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2510-MOVE-RESULT-HDR        THRU 2510-EXIT        
              PERFORM 7100-OPEN-BILL-MAN-DET-CUR  THRU 7100-EXIT        
              PERFORM 7110-FETCH-BILL-MAN-DET-CUR THRU 7110-EXIT        
              PERFORM 2100-PROCESS-BILL-MAN-DET   THRU 2100-EXIT        
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
              PERFORM 7120-CLOSE-BILL-MAN-DET-CUR THRU 7120-EXIT        
           ELSE                                                         
              IF PARM-DATE-BILLED > SPACES                              
                 PERFORM 2200-PROCESS-107-DATA         THRU 2200-EXIT   
              ELSE                                                      
                 PERFORM 2300-PROCESS-102-AND-105-DATA THRU 2300-EXIT   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      ** ADDITIONAL PROCESSING FOR BG RESULT SET                                
      *                                                                         
           IF S-RATE-PLAN-NO-BG > SPACES                                
              MOVE S-RATE-PLAN-NO-BG      TO RD-RATE-PLAN-NO            
              PERFORM 7060-GET-RATE-PLAN-DESC  THRU  7070-EXIT          
              MOVE RD-RATE-DESC           TO S-RATE-DESC-BG             
           END-IF.                                                      
           IF S-CODE-REVENUE-CLASS-BG > SPACES                          
              MOVE S-CODE-REVENUE-CLASS-BG                              
                                          TO F3-CODE-REVENUE-CLASS      
              PERFORM 7070-GET-REV-CLASS-DESC  THRU  7070-EXIT          
              MOVE F3-REVENUE-CLS-DESC    TO S-REVENUE-CLS-DESC-BG      
           END-IF.                                                      
           IF S-NEW-RATE-PCT-BG > 0                                     
              COMPUTE S-NEW-RATE-PCT-BG = S-NEW-RATE-PCT-BG * 100       
              END-COMPUTE                                               
              COMPUTE S-OLD-RATE-PCT-BG = 100 - S-NEW-RATE-PCT-BG       
              END-COMPUTE                                               
           END-IF.                                                      
           IF S-NEW-RATE-PCT-BG = 0                                     
              MOVE 100                    TO S-NEW-RATE-PCT-BG          
              MOVE 0                      TO S-OLD-RATE-PCT-BG          
           END-IF.                                                      
           COMPUTE S-FRANCHISE-TX-RATE-CALC  =                          
                   S-FRANCHISE-TX-RATE-CALC  *  100                     
           END-COMPUTE.                                                 
           COMPUTE S-STATE-TX-RATE-CALC = S-STATE-TX-RATE-CALC * 100    
           END-COMPUTE.                                                 
           COMPUTE S-USAGE-DOLLARS-CALC  =                              
                   S-USAGE-DOLLARS-CALC  - S-CUST-CHRG-DOLLARS-CALC     
           END-COMPUTE.                                                 
           MOVE WS-NEW-RATE-EFF-DATE      TO S-NEW-RATE-EFF-DATE-BG.    
           MOVE WS-OLD-RATE-EFF-DATE      TO S-OLD-RATE-EFF-DATE-BG.    
           PERFORM 8100C-SEND-RESULT-BG   THRU  8100C-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CASE1: GET BILL_MAN_DET DATA AND POPULATE RESULTS            **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-BILL-MAN-DET.                                       
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-BILL-MAN-DET-SEQ        
                                             GTT-RETURN-FIELDS-BC       
                                             GTT-RETURN-FIELDS-BA       
                                             GTT-RETURN-FIELDS-BX       
                                             GTT-RETURN-FIELDS-LO.      
                                                                        
                                                                        
      *                                                                         
           MOVE NU-BILL-MAN-DET-SEQ       TO WS-BILL-MAN-DET-SEQ.       
      *                                                                         
           EVALUATE NU-BILL-MANUAL-TBL-ID                               
               WHEN WS-BG                                               
                  SET WS-BILLING-INDX   TO 1                            
                  INITIALIZE WS-BILLING-DATA (WS-BILLING-INDX)          
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILLING-DATA (WS-BILLING-INDX)                
                  PERFORM 2520-MOVE-RESULT-BG THRU 2520-EXIT            
               WHEN WS-BC                                               
                  MOVE 0                TO S-RETURN-CODE-BC             
                  SET WS-CALC-INDX      TO 1                            
                  INITIALIZE WS-BILL-CALC-DATA (WS-CALC-INDX)           
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-CALC-DATA (WS-CALC-INDX)                 
                  PERFORM 2530-MOVE-RESULT-BC THRU 2530-EXIT            
               WHEN WS-BA                                               
                  MOVE 0                TO S-RETURN-CODE-BA             
                  SET WS-BILL-ADJ-INDX  TO 1                            
                  INITIALIZE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)        
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX)              
                  PERFORM 2540-MOVE-RESULT-BA THRU 2540-EXIT            
               WHEN WS-BX                                               
                  MOVE 0                TO S-RETURN-CODE-BX             
                  SET WS-BX-INDX        TO 1                            
                  INITIALIZE WS-BILL-CNTR-HIST-DATA (WS-BX-INDX)        
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-CNTR-HIST-DATA (WS-BX-INDX)              
                  PERFORM 2550-MOVE-RESULT-BX THRU 2550-EXIT            
               WHEN WS-LO                                               
                  MOVE 0                TO S-RETURN-CODE-LO             
                  SET WS-LO-INDEX       TO 1                            
                  INITIALIZE WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX)       
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX)             
                  PERFORM 2560-MOVE-RESULT-LO THRU 2560-EXIT            
               WHEN WS-XD                                               
                  SET WS-CALC-X-INDX    TO 1                            
                  INITIALIZE WS-BILL-CALC-X-DATA (WS-CALC-X-INDX)       
                  MOVE NU-BILL-MANUAL-DATA-TEXT                         
                    TO WS-BILL-CALC-X-DATA (WS-CALC-X-INDX)             
                  IF WS-RATE-VERSION-XD (WS-CALC-X-INDX) = 1 AND        
                     WS-NEW-RATE-EFF-DATE = SPACES                      
                     MOVE WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)         
                                        TO WS-NEW-RATE-EFF-DATE         
                  END-IF                                                
                  IF WS-RATE-VERSION-XD (WS-CALC-X-INDX) = 2 AND        
                     WS-OLD-RATE-EFF-DATE = SPACES                      
                     MOVE WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)         
                                        TO WS-OLD-RATE-EFF-DATE         
                  END-IF                                                
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 7110-FETCH-BILL-MAN-DET-CUR THRU 7110-EXIT.          
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CASE2:IF DATA DOES NOT EXISTS IN BILL_MAN% TABLES & BILLED   **        
      ** SCENARIO THEN CALL MCSCB107 AND POPULATE RESULTS             **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-107-DATA.                                           
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO WS-CPD4517-ACCOUNT-NO.     
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CPD4517-CODE-UTIL-TYPE. 
           MOVE PARM-IC-NO-NUM            TO WS-CPD4517-IC-NO.          
           MOVE PARM-BILL-NO-NUM          TO WS-CPD4517-BILL-NO.        
           MOVE PARM-BILL-ITEM-TIMESTMP   TO WS-CPD4517-BILL-TIMESTMP.  
           MOVE ZEROS                     TO WS-CPD4517-REVENUE-MONTH.  
      *                                                                         
      **** PROCESS MCSCB107 CALL                                                
      *                                                                         
           PERFORM 6000-CPD4517-MAIN-PROCESS  THRU                      
                   6000-CPD4517-EXIT.                                   
      *                                                                         
      **** PROCESS HEADER RESULT SET                                            
      *                                                                         
           PERFORM 2515-MOVE-RESULT-HDR-BILL-CALC  THRU  2515-EXIT.     
      *                                                                         
      **** PROCESS BG RESULT SET                                                
      *                                                                         
           PERFORM 2525-MOVE-RESULT-BG-107     THRU  2525-EXIT.         
      *                                                                         
      **** PROCESS BC AREA                                                      
      *                                                                         
           PERFORM 2535-MOVE-RESULT-BC-107  THRU  2535-EXIT             
           VARYING BC-INDX FROM 1 BY 1 UNTIL BC-INDX > WS-BZ-MAX-ENTRY  
                OR WS-BC-COMPONENT-ID (BC-INDX) = SPACES.               
      *                                                                         
      **** PROCESS BA AREA                                                      
      *                                                                         
           PERFORM 2545-MOVE-RESULT-BA-107  THRU  2545-EXIT             
           VARYING BA-INDX FROM 1 BY 1 UNTIL BA-INDX > WS-BA-MAX-ENTRY  
                OR WS-BC-FACTOR-ID (BA-INDX) = SPACES.                  
      *                                                                         
      **** PROCESS BX AREA                                                      
      *                                                                         
           PERFORM 2350-VLDT-BILL-CALC-DATA-BX  THRU  2350-EXIT         
           VARYING WS-BX-INDX FROM 1 BY 1                               
             UNTIL WS-BX-INDX > 20                                      
                OR WS-ACCOUNT-NO-BX (WS-BX-INDX) = 0.                   
      *                                                                         
      **** PROCESS LO AREA                                                      
      *                                                                         
           PERFORM 2360-VLDT-BILL-CALC-DATA-LO  THRU  2360-EXIT         
           VARYING WS-LO-INDEX FROM 1 BY 1                              
             UNTIL WS-LO-INDEX > 20                                     
                OR WS-ACCOUNT-NO-LO (WS-LO-INDEX) = 0.                  
      *                                                                         
      **** PROCESS XD AREA                                                      
      *                                                                         
           PERFORM VARYING WS-CALC-INDX-X FROM 1 BY 1                   
             UNTIL WS-CALC-INDX-X > 200                                 
                OR WS-BC-COMPONENT-ID-XD (WS-CALC-INDX-X) = SPACES      
               IF WS-BC-RATE-VERSION-XD (WS-CALC-INDX-X) = 1 AND        
                  WS-NEW-RATE-EFF-DATE = SPACES                         
                  MOVE WS-BC-RATE-FROM-DATE-XD (WS-CALC-INDX-X)         
                                          TO WS-NEW-RATE-EFF-DATE       
               END-IF                                                   
               IF WS-BC-RATE-VERSION-XD (WS-CALC-INDX-X) = 2 AND        
                  WS-OLD-RATE-EFF-DATE = SPACES                         
                  MOVE WS-BC-RATE-FROM-DATE-XD (WS-CALC-INDX-X)         
                                          TO WS-OLD-RATE-EFF-DATE       
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CASE3:IF DATA DOES NOT EXISTS IN BILL_MAN% TABLES & UNBILLED **        
      ** SCENARIO THEN CALL MCSCB102/MCSCB105 AND POPULATE RESULTS    **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-102-AND-105-DATA.                                   
      *                                                                         
           MOVE '2300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        BG-REVENUE-MONTH           
                                             BG-DATE-ORIG-BILL          
                                             WS-CPD4515-INPUTS.         
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO WS-CPD4515-ACCT-NO.        
           MOVE WS-ACCT-BILL-CYCLE        TO WS-CPD4515-BILL-CYCLE.     
           MOVE PARM-COMPANY-NO           TO WS-CPD4515-COMPANY-NO.     
      *                                                                         
           PERFORM 7150-GET-REVENUE-MONTH-BG   THRU  7150-EXIT.         
           IF BG-REVENUE-MONTH > 0                                      
              MOVE BG-REVENUE-MONTH       TO WS-CPD4515-REV-MTH         
           END-IF.                                                      
                                                                        
PRDFIX     IF BG-CODE-BILL-CALC EQUAL 'S'                               
PRDFIX        MOVE '1900-01-01'           TO WS-CPD4515-DATE-ORIG-BILL  
PRDFIX     END-IF.                                                      
                                                                        
           IF BG-DATE-ORIG-BILL > '1900-01-01'                          
              MOVE BG-DATE-ORIG-BILL      TO WS-CPD4515-DATE-ORIG-BILL  
           END-IF.                                                      
      *                                                                         
           PERFORM 6000-PROCESS-BILLCALC-CPD4515  THRU                  
                   6000-CPD4515-EXIT.                                   
      *                                                                         
           PERFORM 2515-MOVE-RESULT-HDR-BILL-CALC  THRU  2515-EXIT.     
      *                                                                         
      **** PROCESS BG AREA                                                      
      *                                                                         
           PERFORM 2320-VLDT-BILL-CALC-DATA-BG  THRU  2320-EXIT         
           VARYING WS-BILLING-INDX FROM 1 BY 1                          
             UNTIL WS-BILLING-INDX > WS-BG-MAX-ENTRY                    
                OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = 0.              
      *                                                                         
      **** PROCESS BC AREA                                                      
      *                                                                         
           PERFORM 2330-VLDT-BILL-CALC-DATA-BC  THRU  2330-EXIT         
           VARYING WS-CALC-INDX FROM 1 BY 1                             
             UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY                       
                OR WS-ACCOUNT-NO-BC (WS-CALC-INDX) = 0.                 
      *                                                                         
      **** PROCESS BA AREA                                                      
      *                                                                         
           PERFORM 2340-VLDT-BILL-CALC-DATA-BA  THRU  2340-EXIT         
           VARYING WS-BILL-ADJ-INDX FROM 1 BY 1                         
             UNTIL WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY                   
                OR WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = 0.             
      *                                                                         
      **** PROCESS BX AREA                                                      
      *                                                                         
           PERFORM 2350-VLDT-BILL-CALC-DATA-BX  THRU  2350-EXIT         
           VARYING WS-BX-INDX FROM 1 BY 1                               
             UNTIL WS-BX-INDX > 20                                      
                OR WS-ACCOUNT-NO-BX (WS-BX-INDX) = 0.                   
      *                                                                         
      **** PROCESS LO AREA                                                      
      *                                                                         
           PERFORM 2360-VLDT-BILL-CALC-DATA-LO  THRU  2360-EXIT         
           VARYING WS-LO-INDEX FROM 1 BY 1                              
             UNTIL WS-LO-INDEX > 20                                     
                OR WS-ACCOUNT-NO-LO (WS-LO-INDEX) = 0.                  
      *                                                                         
      **** PROCESS XD AREA                                                      
      *                                                                         
           PERFORM 2370-VLDT-BILL-CALC-DATA-XD  THRU  2370-EXIT         
           VARYING WS-CALC-X-INDX FROM 1 BY 1                           
             UNTIL WS-CALC-X-INDX > 200                                 
                OR WS-ACCOUNT-NO-XD (WS-CALC-X-INDX) = 0.               
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BG-VALIDATE BILL CALC DATA & POPULATE RESULT SET             **        
      ******************************************************************        
      *                                                                         
       2320-VLDT-BILL-CALC-DATA-BG.                                     
      *                                                                         
           MOVE '2320'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF (WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                       
                                            = PARM-ACCOUNT-NO-NUM) AND  
              (WS-BILL-NO-BG (WS-BILLING-INDX) = PARM-BILL-NO-NUM) AND  
              (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                   
                                            = PARM-CODE-UTIL-TYPE) AND  
              (WS-IC-NO-BG (WS-BILLING-INDX)     = PARM-IC-NO-NUM) AND  
              (WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)               
                                       =  PARM-BILL-ITEM-TIMESTMP)      
              ADD 1                       TO WS-BILL-MAN-DET-SEQ        
              PERFORM 2520-MOVE-RESULT-BG  THRU  2520-EXIT              
           END-IF.                                                      
      *                                                                         
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BC-VALIDATE BILL CALC DATA & POPULATE RESULT SET             **        
      ******************************************************************        
      *                                                                         
       2330-VLDT-BILL-CALC-DATA-BC.                                     
      *                                                                         
           MOVE '2330'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BC.      
           MOVE 0                         TO S-RETURN-CODE-BC.          
      *                                                                         
           IF (WS-ACCOUNT-NO-BC (WS-CALC-INDX)                          
                                         = PARM-ACCOUNT-NO-NUM) AND     
              (WS-BILL-NO-BC (WS-CALC-INDX) = PARM-BILL-NO-NUM) AND     
              (WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX)                      
                                         = PARM-CODE-UTIL-TYPE) AND     
              (WS-IC-NO-BC (WS-CALC-INDX) =     PARM-IC-NO-NUM) AND     
              (WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX)                  
                                    =  PARM-BILL-ITEM-TIMESTMP)         
              ADD 1                       TO WS-BILL-MAN-DET-SEQ        
              PERFORM 2530-MOVE-RESULT-BC  THRU  2530-EXIT              
           END-IF.                                                      
      *                                                                         
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BA-VALIDATE BILL CALC DATA & POPULATE RESULT SET             **        
      ******************************************************************        
      *                                                                         
       2340-VLDT-BILL-CALC-DATA-BA.                                     
      *                                                                         
           MOVE '2340'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BA.      
           MOVE 0                         TO S-RETURN-CODE-BA.          
      *                                                                         
           IF (WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX)                      
                                             = PARM-ACCOUNT-NO-NUM) AND 
              (WS-BILL-NO-BA (WS-BILL-ADJ-INDX) = PARM-BILL-NO-NUM) AND 
              (WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX)                  
                                             = PARM-CODE-UTIL-TYPE) AND 
              (WS-IC-NO-BA (WS-BILL-ADJ-INDX)     = PARM-IC-NO-NUM) AND 
              (WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX)              
                                        =  PARM-BILL-ITEM-TIMESTMP)     
              ADD 1                       TO WS-BILL-MAN-DET-SEQ        
              PERFORM 2540-MOVE-RESULT-BA  THRU  2540-EXIT              
           END-IF.                                                      
      *                                                                         
       2340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BX-VALIDATE BILL CALC DATA & POPULATE RESULT SET             **        
      ******************************************************************        
      *                                                                         
       2350-VLDT-BILL-CALC-DATA-BX.                                     
      *                                                                         
           MOVE '2350'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BX.      
           MOVE 0                         TO S-RETURN-CODE-BX.          
      *                                                                         
           IF (WS-ACCOUNT-NO-BX (WS-BX-INDX) = PARM-ACCOUNT-NO-NUM) AND 
              (WS-BILL-NO-BX (WS-BX-INDX)    = PARM-BILL-NO-NUM   ) AND 
              (WS-CODE-UTIL-TYPE-BX (WS-BX-INDX)                        
                                             = PARM-CODE-UTIL-TYPE) AND 
              (WS-IC-NO-BX (WS-BX-INDX)      = PARM-IC-NO-NUM     ) AND 
              (WS-BILL-ITEM-TIMESTMP-BX (WS-BX-INDX)                    
                                        =  PARM-BILL-ITEM-TIMESTMP)     
              ADD 1                       TO WS-BILL-MAN-DET-SEQ        
              PERFORM 2550-MOVE-RESULT-BX  THRU  2550-EXIT              
           END-IF.                                                      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** LO-VALIDATE BILL CALC DATA & POPULATE RESULT SET             **        
      ******************************************************************        
      *                                                                         
       2360-VLDT-BILL-CALC-DATA-LO.                                     
      *                                                                         
           MOVE '2360'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-LO.      
           MOVE 0                         TO S-RETURN-CODE-LO.          
      *                                                                         
           IF (WS-ACCOUNT-NO-LO (WS-LO-INDEX)                           
                                            = PARM-ACCOUNT-NO-NUM) AND  
              (WS-BILL-NO-LO (WS-LO-INDEX)  = PARM-BILL-NO-NUM   ) AND  
              (WS-CODE-UTIL-TYPE-LO (WS-LO-INDEX)                       
                                            = PARM-CODE-UTIL-TYPE) AND  
              (WS-IC-NO-LO (WS-LO-INDEX)    = PARM-IC-NO-NUM     ) AND  
              (WS-BILL-ITEM-TIMESTMP-LO (WS-LO-INDEX)                   
                                       =  PARM-BILL-ITEM-TIMESTMP)      
              ADD 1                       TO WS-BILL-MAN-DET-SEQ        
              PERFORM 2560-MOVE-RESULT-LO  THRU  2560-EXIT              
           END-IF.                                                      
      *                                                                         
       2360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** XD-VALIDATE BILL CALC DATA                                   **        
      ******************************************************************        
      *                                                                         
       2370-VLDT-BILL-CALC-DATA-XD.                                     
      *                                                                         
           MOVE '2370'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF (WS-ACCOUNT-NO-XD (WS-CALC-X-INDX)                        
                                           = PARM-ACCOUNT-NO-NUM) AND   
              (WS-BILL-NO-XD (WS-CALC-X-INDX) = PARM-BILL-NO-NUM) AND   
              (WS-CODE-UTIL-TYPE-XD (WS-CALC-X-INDX)                    
                                           = PARM-CODE-UTIL-TYPE) AND   
              (WS-IC-NO-XD (WS-CALC-X-INDX) =     PARM-IC-NO-NUM) AND   
              (WS-BILL-ITEM-TIMESTMP-XD (WS-CALC-X-INDX)                
                                      =  PARM-BILL-ITEM-TIMESTMP)       
              IF WS-RATE-VERSION-XD (WS-CALC-X-INDX) = 1 AND            
                 WS-NEW-RATE-EFF-DATE = SPACES                          
                 MOVE WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)             
                                          TO WS-NEW-RATE-EFF-DATE       
              END-IF                                                    
              IF WS-RATE-VERSION-XD (WS-CALC-X-INDX) = 2 AND            
                 WS-OLD-RATE-EFF-DATE = SPACES                          
                 MOVE WS-RATE-FROM-DATE-XD (WS-CALC-X-INDX)             
                                          TO WS-OLD-RATE-EFF-DATE       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2400-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-MAIN = 0                                         
              INITIALIZE                     GTT-RETURN-FIELDS-MAIN     
              MOVE 100                    TO S-RETURN-CODE              
                                             S-ERROR-CODE               
              PERFORM 8100A-SEND-RESULT-MAIN THRU  8100A-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-HDR = 0                                          
              INITIALIZE                     GTT-RETURN-FIELDS-HDR      
              MOVE 100                    TO S-RETURN-CODE-HDR          
                                             S-ERROR-CODE               
              PERFORM 8100B-SEND-RESULT-HDR  THRU  8100B-EXIT           
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-BG = 0                                           
              INITIALIZE                     GTT-RETURN-FIELDS-BG       
              MOVE 100                    TO S-RETURN-CODE-BG           
                                             S-ERROR-CODE               
              PERFORM 8100C-SEND-RESULT-BG  THRU  8100C-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-BC = 0                                           
              INITIALIZE                     GTT-RETURN-FIELDS-BC       
              MOVE 100                    TO S-RETURN-CODE-BC           
                                             S-ERROR-CODE               
              PERFORM 8100D-SEND-RESULT-BC  THRU  8100D-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-BA = 0                                           
              INITIALIZE                     GTT-RETURN-FIELDS-BA       
              MOVE 100                    TO S-RETURN-CODE-BA           
                                             S-ERROR-CODE               
              PERFORM 8100E-SEND-RESULT-BA  THRU  8100E-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-BX = 0                                           
              INITIALIZE                     GTT-RETURN-FIELDS-BX       
              MOVE 100                    TO S-RETURN-CODE-BX           
                                             S-ERROR-CODE               
              PERFORM 8100F-SEND-RESULT-BX  THRU  8100F-EXIT            
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-LO = 0                                           
              INITIALIZE                     GTT-RETURN-FIELDS-LO       
              MOVE 100                    TO S-RETURN-CODE-LO           
                                             S-ERROR-CODE               
              PERFORM 8100G-SEND-RESULT-LO  THRU  8100G-EXIT            
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - MAIN                                       **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-MAIN.                                           
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE 'NON000'                  TO S-BUS-RULE-TYPE.           
           MOVE 'G'                       TO S-BUS-RULE-RESULT.         
      *                                                                         
           PERFORM 8100A-SEND-RESULT-MAIN THRU  8100A-EXIT.             
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - HEADER                                     **        
      ******************************************************************        
      *                                                                         
       2510-MOVE-RESULT-HDR.                                            
      *                                                                         
           MOVE '2510'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE NG-BILL-MAN-STATUS-CD     TO S-BILL-MAN-STATUS-CD.      
           MOVE NG-BILL-MAN-SOURCE-CD     TO S-BILL-MAN-SOURCE-CD.      
      *                                                                         
      **** D --> DATA FROM DB2                                                  
           MOVE 'D'                       TO S-DATA-SOURCE-CD.          
      *                                                                         
      **** SEND CUSTOMER NAME AND BILL CYCLE                                    
           MOVE WS-CUSTOMER-NAME          TO S-CUSTOMER-NAME.           
           MOVE WS-ACCT-BILL-CYCLE        TO S-BILL-CYCLE.              
      *                                                                         
           PERFORM 8100B-SEND-RESULT-HDR  THRU  8100B-EXIT.             
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - HEADER - BILL CALC                         **        
      ******************************************************************        
      *                                                                         
       2515-MOVE-RESULT-HDR-BILL-CALC.                                  
      *                                                                         
           MOVE '2515'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
      **** C -> CREATED                                                         
           MOVE 'C'                       TO S-BILL-MAN-STATUS-CD.      
      *                                                                         
      **** B -> BILL CALC MODIFIED                                              
           MOVE 'B'                       TO S-BILL-MAN-SOURCE-CD.      
      *                                                                         
      **** B --> BILL CALC                                                      
           MOVE 'B'                       TO S-DATA-SOURCE-CD.          
      *                                                                         
      **** SEND CUSTOMER NAME AND BILL CYCLE                                    
           MOVE WS-CUSTOMER-NAME          TO S-CUSTOMER-NAME.           
           MOVE WS-ACCT-BILL-CYCLE        TO S-BILL-CYCLE.              
                                                                        
           PERFORM 8100B-SEND-RESULT-HDR  THRU  8100B-EXIT.             
      *                                                                         
       2515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - BG                                         **        
      ******************************************************************        
      *                                                                         
       2520-MOVE-RESULT-BG.                                             
      *                                                                         
           MOVE '2520'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BG.      
      *                                                                         
           MOVE 0                         TO S-RETURN-CODE-BG.          
      *                                                                         
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BG.     
      *                                                                         
           MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)                   
                                          TO S-AMT-BILL-ITEM-BG.        
           MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)                   
                                          TO S-AMT-STATE-TAX-BG.        
           MOVE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)                    
                                          TO S-AMT-CITY-TAX-BG.         
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX)              
                                          TO S-CODE-REVENUE-CLASS-BG.   
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                    
                                          TO S-RATE-PLAN-NO-BG.         
           MOVE WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)               
                                          TO S-CODE-STAT-TAX-XMT-BG.    
           MOVE WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)               
                                          TO S-CODE-CITY-TAX-XMT-BG.    
           MOVE WS-PRORATE-CD-BG (WS-BILLING-INDX)                      
                                          TO S-PRORATE-CD-BG.           
           MOVE WS-NEW-RATE-PCT-BG (WS-BILLING-INDX)                    
                                          TO S-NEW-RATE-PCT-BG.         
           MOVE WS-REBILL-IND-BG (WS-BILLING-INDX)                      
                                          TO S-REBILL-IND-BG.           
           MOVE WS-ADJ-REASON-CD-BG (WS-BILLING-INDX)                   
                                          TO S-ADJ-REASON-CD-BG.        
           MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                   
                                          TO S-REVENUE-MONTH-BG.        
           MOVE WS-BTU-FACTOR-BG (WS-BILLING-INDX)                      
                                          TO S-BTU-FACTOR-BG.           
           MOVE WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                    
                                          TO S-GAS-BASE-USE-BG.         
           MOVE WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)                 
                                          TO S-NO-OF-CONS-DAYS-BG.      
           MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)               
                                          TO S-REV-MTH-ORIG-BILL-BG.    
           MOVE WS-TOT-NEW-CHRGS-CALC (WS-BILLING-INDX)                 
                                          TO S-TOT-NEW-CHRGS-CALC.      
           MOVE WS-CUST-CHRG-DOLLARS-CALC (WS-BILLING-INDX)             
                                          TO S-CUST-CHRG-DOLLARS-CALC.  
           MOVE WS-USAGE-END-DATE-CALC (WS-BILLING-INDX)                
                                          TO S-USAGE-END-DATE-CALC.     
           MOVE WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX)             
                                          TO S-FRANCHISE-TX-RATE-CALC.  
           MOVE WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)                 
                                          TO S-STATE-TX-RATE-CALC.      
           MOVE WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX)                 
                                          TO S-BILL-CALC-CYCLE-BG.      
           MOVE WS-PRORATED-ON-NBR-DAYS-BG (WS-BILLING-INDX)            
                                          TO S-PRORATED-ON-NBR-DAYS-BG. 
      *                                                                         
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - 107 CALL - BG                              **        
      ******************************************************************        
      *                                                                         
       2525-MOVE-RESULT-BG-107.                                         
      *                                                                         
           MOVE '2525'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BG.      
      *                                                                         
           MOVE 0                         TO S-RETURN-CODE-BG.          
      *                                                                         
           ADD 1                          TO WS-BILL-MAN-DET-SEQ.       
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BG.     
      *                                                                         
           MOVE WS-BC-AMT-BILL-ITEM-BG    TO S-AMT-BILL-ITEM-BG.        
           MOVE WS-BC-AMT-STATE-TAX-BG    TO S-AMT-STATE-TAX-BG.        
           MOVE WS-BC-AMT-CITY-TAX-BG     TO S-AMT-CITY-TAX-BG.         
           MOVE WS-BC-CODE-REVENUE-CLASS-BG TO S-CODE-REVENUE-CLASS-BG. 
           MOVE WS-BC-RATE-PLAN-NO-BG       TO S-RATE-PLAN-NO-BG.       
           MOVE WS-BC-CODE-STAT-TAX-XMT-BG  TO S-CODE-STAT-TAX-XMT-BG.  
           MOVE WS-BC-CODE-CITY-TAX-XMT-BG  TO S-CODE-CITY-TAX-XMT-BG.  
           MOVE WS-BC-PRORATE-CD-BG       TO S-PRORATE-CD-BG.           
           MOVE WS-BC-NEW-RATE-PCT-BG     TO S-NEW-RATE-PCT-BG.         
           MOVE WS-BC-REBILL-IND-BG       TO S-REBILL-IND-BG.           
           MOVE WS-BC-ADJ-REASON-CD-BG    TO S-ADJ-REASON-CD-BG.        
           MOVE WS-BC-REVENUE-MONTH-BG    TO S-REVENUE-MONTH-BG.        
           MOVE WS-BC-BTU-FACTOR-BG       TO S-BTU-FACTOR-BG.           
           MOVE WS-BC-GAS-BASE-USE-BG     TO S-GAS-BASE-USE-BG.         
           MOVE WS-BC-NO-CNSMPTN-DAYS     TO S-NO-OF-CONS-DAYS-BG.      
           MOVE WS-BC-REV-MTH-ORIG-BILL-BG                              
                                          TO S-REV-MTH-ORIG-BILL-BG.    
           COMPUTE S-AMT-BILL-ITEM-BG    =  S-AMT-BILL-ITEM-BG  +       
                     S-AMT-STATE-TAX-BG  +  S-AMT-CITY-TAX-BG           
           END-COMPUTE.                                                 
           MOVE WS-BC-CNSMPTN-END-DATE    TO S-USAGE-END-DATE-CALC.     
           MOVE BG-CITY-TAX-RATE          TO S-FRANCHISE-TX-RATE-CALC.  
           MOVE BG-STATE-TAX-RATE         TO S-STATE-TX-RATE-CALC.      
           MOVE WS-BC-BILL-CALC-CYCLE-BG  TO S-BILL-CALC-CYCLE-BG.      
           MOVE WS-BC-PRORATED-ON-NBR-DAYS-BG                           
                                          TO S-PRORATED-ON-NBR-DAYS-BG. 
      *                                                                         
       2525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - BC                                         **        
      ******************************************************************        
      *                                                                         
       2530-MOVE-RESULT-BC.                                             
      *                                                                         
           MOVE '2530'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BC.     
      *                                                                         
           MOVE WS-COMPONENT-CODE-BC (WS-CALC-INDX)                     
                                          TO S-COMPONENT-ID-BC.         
           MOVE WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX)                   
                                          TO S-CONSUMPTION-TYPE-BC.     
           MOVE WS-REGISTER-TYPE-BC (WS-CALC-INDX)                      
                                          TO S-REGISTER-TYPE-BC.        
           MOVE WS-CODE-TOU-BC (WS-CALC-INDX)                           
                                          TO S-CODE-TOU-BC.             
           MOVE WS-CODE-SEASON-BC (WS-CALC-INDX)                        
                                          TO S-CODE-SEASON-BC.          
           MOVE WS-RATE-VERSION-BC (WS-CALC-INDX)                       
                                          TO S-RATE-VERSION-BC.         
           MOVE WS-READ-UNITS-BC (WS-CALC-INDX)                         
                                          TO S-READ-UNITS-BC.           
           MOVE WS-NET-UNIT-SEL-RSN-BC (WS-CALC-INDX)                   
                                          TO S-NET-UNIT-SEL-RSN-BC.     
           MOVE WS-BLOCKS-USED-BC (WS-CALC-INDX)                        
                                          TO S-BLOCKS-USED-BC.          
           MOVE WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX)                 
                                          TO S-CALC-COMPONENT-AMT-BC.   
           MOVE WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)                  
                                          TO S-NET-COMPONENT-AMT-BC.    
      *                                                                         
      ***** S-USAGE-DOLLARS-CALC IS PART OF BG RESULT SET                       
           IF S-CONSUMPTION-TYPE-BC = 'B' OR 'C' OR 'D'                 
              COMPUTE S-USAGE-DOLLARS-CALC  =                           
                      S-USAGE-DOLLARS-CALC  +  S-NET-COMPONENT-AMT-BC   
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
      ***** S-DEMAND-DOLLARS-CALC IS PART OF BG RESULT SET                      
           IF S-CONSUMPTION-TYPE-BC = 'E' OR 'J' OR 'Q'                 
              COMPUTE S-DEMAND-DOLLARS-CALC =                           
                      S-DEMAND-DOLLARS-CALC +  S-NET-COMPONENT-AMT-BC   
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
           MOVE WS-EVENT-NUMBER-BC (WS-CALC-INDX)                       
                                          TO S-EVENT-NUMBER-BC.         
           MOVE WS-EVENT-DATE-BC (WS-CALC-INDX)                         
                                          TO S-EVENT-DATE-BC.           
      *                                                                         
           PERFORM VARYING WS-BLK-INDX FROM 1 BY 1                      
             UNTIL WS-BLK-INDX > 9                                      
                OR WS-BLK-INDX > WS-BLOCKS-USED-BC (WS-CALC-INDX)       
              SET  S-BLOCK-NO-BC          TO WS-BLK-INDX                
              MOVE WS-BLOCK-SIZE-BC (WS-CALC-INDX WS-BLK-INDX)          
                                          TO S-BLOCK-SIZE-BC            
              MOVE WS-UNITS-BILLED-BC (WS-CALC-INDX WS-BLK-INDX)        
                                          TO S-UNITS-BILLED-BC          
              MOVE WS-PRICE-TYPE-CD-BC (WS-CALC-INDX WS-BLK-INDX)       
                                          TO S-PRICE-TYPE-CD-BC         
              MOVE WS-AMT-BASE-RATE-BC (WS-CALC-INDX WS-BLK-INDX)       
                                          TO S-AMT-BASE-RATE-BC         
              MOVE WS-AMT-NET-RATE-BC (WS-CALC-INDX WS-BLK-INDX)        
                                          TO S-AMT-NET-RATE-BC          
              MOVE WS-AMT-BLOCK-BC (WS-CALC-INDX WS-BLK-INDX)           
                                          TO S-AMT-BLOCK-BC             
              PERFORM 8100D-SEND-RESULT-BC  THRU  8100D-EXIT            
              INITIALIZE                     S-BLOCK-NO-BC              
                                             S-BLOCK-SIZE-BC            
                                             S-UNITS-BILLED-BC          
                                             S-PRICE-TYPE-CD-BC         
                                             S-AMT-BASE-RATE-BC         
                                             S-AMT-NET-RATE-BC          
                                             S-AMT-BLOCK-BC             
           END-PERFORM.                                                 
      *                                                                         
       2530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - 107 CALL - BC                              **        
      ******************************************************************        
      *                                                                         
       2535-MOVE-RESULT-BC-107.                                         
      *                                                                         
           MOVE '2535'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BC.      
      *                                                                         
           MOVE 0                         TO S-RETURN-CODE-BC.          
      *                                                                         
           ADD 1                          TO WS-BILL-MAN-DET-SEQ.       
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BC.     
      *                                                                         
           MOVE WS-BC-COMPONENT-CODE (BC-INDX)                          
                                          TO S-COMPONENT-ID-BC.         
           MOVE WS-BC-CONSUMPTION-TYPE (BC-INDX)                        
                                          TO S-CONSUMPTION-TYPE-BC.     
           MOVE WS-BC-REGISTER-TYPE (BC-INDX)                           
                                          TO S-REGISTER-TYPE-BC.        
           MOVE WS-BC-CODE-TOU (BC-INDX)  TO S-CODE-TOU-BC.             
           MOVE WS-BC-CODE-SEASON (BC-INDX)                             
                                          TO S-CODE-SEASON-BC.          
           MOVE WS-BC-RATE-VERSION (BC-INDX)                            
                                          TO S-RATE-VERSION-BC.         
           MOVE WS-BC-READ-UNITS (BC-INDX)                              
                                          TO S-READ-UNITS-BC.           
           MOVE WS-BC-NET-UNIT-SEL-RSN (BC-INDX)                        
                                          TO S-NET-UNIT-SEL-RSN-BC.     
           MOVE WS-BC-BLOCKS-USED (BC-INDX)                             
                                          TO S-BLOCKS-USED-BC.          
           MOVE WS-BC-CALC-COMPONENT-AMT (BC-INDX)                      
                                          TO S-CALC-COMPONENT-AMT-BC.   
           MOVE WS-BC-NET-COMPONENT-AMT (BC-INDX)                       
                                          TO S-NET-COMPONENT-AMT-BC.    
      *                                                                         
      ***** S-USAGE-DOLLARS-CALC IS PART OF BG RESULT SET                       
           IF S-CONSUMPTION-TYPE-BC = 'B' OR 'C' OR 'D'                 
              COMPUTE S-USAGE-DOLLARS-CALC  =                           
                      S-USAGE-DOLLARS-CALC  +  S-NET-COMPONENT-AMT-BC   
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
      ***** S-DEMAND-DOLLARS-CALC IS PART OF BG RESULT SET                      
           IF S-CONSUMPTION-TYPE-BC = 'E' OR 'J' OR 'Q'                 
              COMPUTE S-DEMAND-DOLLARS-CALC =                           
                      S-DEMAND-DOLLARS-CALC +  S-NET-COMPONENT-AMT-BC   
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
           MOVE WS-BC-EVENT-NUMBER (BC-INDX)                            
                                          TO S-EVENT-NUMBER-BC.         
           MOVE WS-BC-EVENT-DATE (BC-INDX)                              
                                          TO S-EVENT-DATE-BC.           
           PERFORM VARYING BLK-INDX FROM 1 BY 1 UNTIL BLK-INDX > 9      
                OR BLK-INDX > WS-BC-BLOCKS-USED (BC-INDX)               
              SET  S-BLOCK-NO-BC          TO BLK-INDX                   
              MOVE WS-BC-BLOCK-SIZE (BC-INDX BLK-INDX)                  
                                          TO S-BLOCK-SIZE-BC            
              MOVE WS-BC-UNITS-BILLED (BC-INDX BLK-INDX)                
                                          TO S-UNITS-BILLED-BC          
              MOVE WS-BC-PRICE-TYPE-CD (BC-INDX BLK-INDX)               
                                          TO S-PRICE-TYPE-CD-BC         
              MOVE WS-BC-AMT-BASE-RATE (BC-INDX BLK-INDX)               
                                          TO S-AMT-BASE-RATE-BC         
              MOVE WS-BC-AMT-NET-RATE (BC-INDX BLK-INDX)                
                                          TO S-AMT-NET-RATE-BC          
              MOVE WS-BC-AMT-BLOCK (BC-INDX BLK-INDX)                   
                                          TO S-AMT-BLOCK-BC             
              PERFORM 8100D-SEND-RESULT-BC  THRU  8100D-EXIT            
              INITIALIZE                     S-BLOCK-NO-BC              
                                             S-BLOCK-SIZE-BC            
                                             S-UNITS-BILLED-BC          
                                             S-PRICE-TYPE-CD-BC         
                                             S-AMT-BASE-RATE-BC         
                                             S-AMT-NET-RATE-BC          
                                             S-AMT-BLOCK-BC             
           END-PERFORM.                                                 
      *                                                                         
       2535-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - BA                                         **        
      ******************************************************************        
      *                                                                         
       2540-MOVE-RESULT-BA.                                             
      *                                                                         
           MOVE '2540'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BA.     
      *                                                                         
           MOVE WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX)                      
                                          TO S-FACTOR-ID-BA.            
           MOVE WS-FCT-CMPNT-ID-BA (WS-BILL-ADJ-INDX)                   
                                          TO S-FCT-CMPNT-ID-BA.         
           MOVE WS-FCT-CNSMPT-TYPE-BA (WS-BILL-ADJ-INDX)                
                                          TO S-FCT-CNSMPT-TYPE-BA.      
           MOVE WS-FCT-REGISTER-TYPE-BA (WS-BILL-ADJ-INDX)              
                                          TO S-FCT-REGISTER-TYPE-BA.    
           MOVE WS-FCT-TOU-BA (WS-BILL-ADJ-INDX)                        
                                          TO S-FCT-TOU-BA.              
           MOVE WS-FCT-SEASON-BA (WS-BILL-ADJ-INDX)                     
                                          TO S-FCT-SEASON-BA.           
           MOVE WS-FCT-RATE-VERSION-BA (WS-BILL-ADJ-INDX)               
                                          TO S-FCT-RATE-VERSION-BA.     
           MOVE WS-CODE-CALC-TYPE-BA (WS-BILL-ADJ-INDX)                 
                                          TO S-CODE-CALC-TYPE-BA.       
           MOVE WS-CODE-ADJ-UNIT-SOURCE-BA (WS-BILL-ADJ-INDX)           
                                          TO S-CODE-ADJ-UNIT-SOURCE-BA. 
           MOVE WS-CODE-ADJUST-TYPE-BA (WS-BILL-ADJ-INDX)               
                                          TO S-CODE-ADJUST-TYPE-BA.     
           MOVE WS-ADJ-UNITS-BA (WS-BILL-ADJ-INDX)                      
                                          TO S-ADJ-UNITS-BA.            
           MOVE WS-FACTOR-BA (WS-BILL-ADJ-INDX)                         
                                          TO S-FACTOR-BA.               
           MOVE WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX)                 
                                          TO S-AMT-ADJUSTMENT-BA.       
           MOVE WS-STATE-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX)             
                                          TO S-STATE-TAX-XMPT-ADJ-BA.   
           MOVE WS-CITY-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX)              
                                          TO S-CITY-TAX-XMPT-ADJ-BA.    
           MOVE WS-OTHER-TAX-XMPT-ADJ-BA (WS-BILL-ADJ-INDX)             
                                          TO S-OTHER-TAX-XMPT-ADJ-BA.   
           MOVE WS-BLOCK-NO-BA (WS-BILL-ADJ-INDX)                       
                                          TO S-BLOCK-NO-BA.             
           MOVE WS-RATE-FROM-DATE-BA (WS-BILL-ADJ-INDX)                 
                                          TO S-RATE-FROM-DATE-BA.       
      *                                                                         
           PERFORM 8100E-SEND-RESULT-BA   THRU  8100E-EXIT.             
      *                                                                         
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - 107 CALL - BA                              **        
      ******************************************************************        
      *                                                                         
       2545-MOVE-RESULT-BA-107.                                         
      *                                                                         
           MOVE '2545'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-BA.      
      *                                                                         
           MOVE 0                         TO S-RETURN-CODE-BA.          
      *                                                                         
           ADD 1                          TO WS-BILL-MAN-DET-SEQ.       
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BA.     
      *                                                                         
           MOVE WS-BC-FACTOR-ID (BA-INDX) TO S-FACTOR-ID-BA.            
           MOVE WS-BC-FCT-CMPNT-ID (BA-INDX)                            
                                          TO S-FCT-CMPNT-ID-BA.         
           MOVE WS-BC-FCT-CNSMPT-TYPE (BA-INDX)                         
                                          TO S-FCT-CNSMPT-TYPE-BA.      
           MOVE WS-BC-FCT-REGISTER-TYPE (BA-INDX)                       
                                          TO S-FCT-REGISTER-TYPE-BA.    
           MOVE WS-BC-FCT-TOU (BA-INDX)   TO S-FCT-TOU-BA.              
           MOVE WS-BC-FCT-SEASON (BA-INDX)                              
                                          TO S-FCT-SEASON-BA.           
           MOVE WS-BC-FCT-RATE-VERSION (BA-INDX)                        
                                          TO S-FCT-RATE-VERSION-BA.     
           MOVE WS-BC-CODE-CALC-TYPE (BA-INDX)                          
                                          TO S-CODE-CALC-TYPE-BA.       
           MOVE WS-BC-CODE-ADJ-UNIT-SOURCE (BA-INDX)                    
                                          TO S-CODE-ADJ-UNIT-SOURCE-BA. 
           MOVE WS-BC-CODE-ADJUST-TYPE (BA-INDX)                        
                                          TO S-CODE-ADJUST-TYPE-BA.     
           MOVE WS-BC-ADJ-UNITS (BA-INDX) TO S-ADJ-UNITS-BA.            
           MOVE WS-BC-FACTOR (BA-INDX)    TO S-FACTOR-BA.               
           MOVE WS-BC-AMT-ADJUSTMENT (BA-INDX)                          
                                          TO S-AMT-ADJUSTMENT-BA.       
           MOVE WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX)                      
                                          TO S-STATE-TAX-XMPT-ADJ-BA.   
           MOVE WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX)                       
                                          TO S-CITY-TAX-XMPT-ADJ-BA.    
           MOVE WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX)                      
                                          TO S-OTHER-TAX-XMPT-ADJ-BA.   
           MOVE WS-BC-BLOCK-NO (BA-INDX)  TO S-BLOCK-NO-BA.             
           MOVE WS-BC-RATE-FROM-DATE (BA-INDX)                          
                                          TO S-RATE-FROM-DATE-BA.       
      *                                                                         
      ***** S-CUST-CHRG-DOLLARS-CALC IS PART OF BG RESULT SET                   
      *                                                                         
           IF S-FACTOR-ID-BA = 'BFACCHRG'                               
              COMPUTE S-CUST-CHRG-DOLLARS-CALC  ROUNDED =               
                      S-CUST-CHRG-DOLLARS-CALC  +                       
                      S-AMT-ADJUSTMENT-BA                               
              END-COMPUTE                                               
           END-IF.                                                      
      *                                                                         
           PERFORM 8100E-SEND-RESULT-BA   THRU  8100E-EXIT.             
      *                                                                         
       2545-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - BX                                         **        
      ******************************************************************        
      *                                                                         
       2550-MOVE-RESULT-BX.                                             
      *                                                                         
           MOVE '2550'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-BX.     
      *                                                                         
           MOVE WS-CNTRCT-START-DT-BX (WS-BX-INDX)                      
                                          TO S-CNTRCT-START-DT-BX.      
           MOVE WS-CNTRCT-END-DT-BX (WS-BX-INDX)                        
                                          TO S-CNTRCT-END-DT-BX.        
           MOVE WS-SPCL-ADM-CHRG-AM-BX (WS-BX-INDX)                     
                                          TO S-SPCL-ADM-CHRG-AM-BX.     
           MOVE WS-SPCL-MO-MIN-AM-BX (WS-BX-INDX)                       
                                          TO S-SPCL-MO-MIN-AM-BX.       
           MOVE WS-SPCL-ANN-MIN-AM-OLD-BX (WS-BX-INDX)                  
                                          TO S-SPCL-ANN-MIN-AM-OLD-BX.  
           MOVE WS-ANN-MIN-TYPE-CD-BX (WS-BX-INDX)                      
                                          TO S-ANN-MIN-TYPE-CD-BX.      
           MOVE WS-CBL-REF-RATE-PLN-BX (WS-BX-INDX)                     
                                          TO S-CBL-REF-RATE-PLN-BX.     
           MOVE WS-COMP-RATE-PLAN-BX (WS-BX-INDX)                       
                                          TO S-COMP-RATE-PLAN-BX.       
           MOVE WS-COMPARE-TYPE-CD-BX (WS-BX-INDX)                      
                                          TO S-COMPARE-TYPE-CD-BX.      
           MOVE WS-CANCEL-CHRG-AM-BX (WS-BX-INDX)                       
                                          TO S-CANCEL-CHRG-AM-BX.       
           MOVE WS-CONTRACT-STDBY-DEM-BX (WS-BX-INDX)                   
                                          TO S-CONTRACT-STDBY-DEM-BX.   
           MOVE WS-CONTRACT-DEMAND-BX (WS-BX-INDX)                      
                                          TO S-CONTRACT-DEMAND-BX.      
           MOVE WS-FIRM-PER-HR-KWH-BX (WS-BX-INDX)                      
                                          TO S-FIRM-PER-HR-KWH-BX.      
           MOVE WS-BUILD-UP-MONTHS-BX (WS-BX-INDX)                      
                                          TO S-BUILD-UP-MONTHS-BX.      
           MOVE WS-STDBY-YTD-PK-HRS-BX (WS-BX-INDX)                     
                                          TO S-STDBY-YTD-PK-HRS-BX.     
           MOVE WS-STDBY-YTD-HRS-BX (WS-BX-INDX)                        
                                          TO S-STDBY-YTD-HRS-BX.        
           MOVE WS-UPDATE-ACTION-IND-BX (WS-BX-INDX)                    
                                          TO S-UPDATE-ACTION-IND-BX.    
           MOVE WS-CONTRACT-ECON-DEM-BX (WS-BX-INDX)                    
                                          TO S-CONTRACT-ECON-DEM-BX.    
           MOVE WS-MAX-ECON-DEM-BX (WS-BX-INDX)                         
                                          TO S-MAX-ECON-DEM-BX.         
           MOVE WS-DEM-CNSLDTN-CD-BX (WS-BX-INDX)                       
                                          TO S-DEM-CNSLDTN-CD-BX.       
           MOVE WS-DFLT-USAGE-CLS-CD-BX (WS-BX-INDX)                    
                                          TO S-DFLT-USAGE-CLS-CD-BX.    
           MOVE WS-STDBY-LIMIT-HRS-BX (WS-BX-INDX)                      
                                          TO S-STDBY-LIMIT-HRS-BX.      
           MOVE WS-STDBY-LIMIT-PK-HRS-BX (WS-BX-INDX)                   
                                          TO S-STDBY-LIMIT-PK-HRS-BX.   
           MOVE WS-STDBY-RESET-MTH-BX (WS-BX-INDX)                      
                                          TO S-STDBY-RESET-MTH-BX.      
           MOVE WS-ALT-SPLY-RATE-NO-BX (WS-BX-INDX)                     
                                          TO S-ALT-SPLY-RATE-NO-BX.     
           MOVE WS-ALT-SPLY-REV-CL-CD-BX (WS-BX-INDX)                   
                                          TO S-ALT-SPLY-REV-CL-CD-BX.   
           MOVE WS-ALTERNATE-FUEL-CD-BX (WS-BX-INDX)                    
                                          TO S-ALTERNATE-FUEL-CD-BX.    
           MOVE WS-ALTN-FUEL-SPLY-CD-BX (WS-BX-INDX)                    
                                          TO S-ALTN-FUEL-SPLY-CD-BX.    
           MOVE WS-FUEL-SHIPPER-CD-BX (WS-BX-INDX)                      
                                          TO S-FUEL-SHIPPER-CD-BX.      
           MOVE WS-VERS-PRORATE-CD-BX (WS-BX-INDX)                      
                                          TO S-VERS-PRORATE-CD-BX.      
           MOVE WS-TRNSP-SHRINK-PCT-BX (WS-BX-INDX)                     
                                          TO S-TRNSP-SHRINK-PCT-BX.     
           MOVE WS-ANN-REVIEW-MONTH-BX (WS-BX-INDX)                     
                                          TO S-ANN-REVIEW-MONTH-BX.     
           MOVE WS-CONTRACT-TERM-CD-BX (WS-BX-INDX)                     
                                          TO S-CONTRACT-TERM-CD-BX.     
           MOVE WS-SPCL-ANN-MIN-AM-BX (WS-BX-INDX)                      
                                          TO S-SPCL-ANN-MIN-AM-BX.      
      *                                                                         
           PERFORM 8100F-SEND-RESULT-BX   THRU  8100F-EXIT.             
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - LO                                         **        
      ******************************************************************        
      *                                                                         
       2560-MOVE-RESULT-LO.                                             
      *                                                                         
           MOVE '2560'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-BILL-MAN-DET-SEQ       TO S-BILL-MAN-DET-SEQ-LO.     
      *                                                                         
           MOVE WS-CNTRCT-START-DT-LO (WS-LO-INDEX)                     
                                          TO S-CNTRCT-START-DT-LO.      
           MOVE WS-BASELINE-MONTH-LO (WS-LO-INDEX)                      
                                          TO S-BASELINE-MONTH-LO.       
           MOVE WS-UPDATE-ACTION-IND-LO (WS-LO-INDEX)                   
                                          TO S-UPDATE-ACTION-IND-LO.    
      *                                                                         
           PERFORM VARYING WS-LO-UNITS-INDX FROM 1 BY 1                 
             UNTIL WS-LO-UNITS-INDX > 30                                
                OR WS-CMPNT-ID-CD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)     
                   = SPACES                                             
             MOVE WS-CMPNT-ID-CD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)      
                                          TO S-CMPNT-ID-CD-LO           
             MOVE WS-INSTR-USE-TYPE-CD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)
                                          TO S-INSTR-USE-TYPE-CD-LO     
             MOVE WS-CODE-TIME-PERIOD-LO (WS-LO-INDEX WS-LO-UNITS-INDX) 
                                          TO S-CODE-TIME-PERIOD-LO      
             MOVE WS-BASELINE-UNITS-LO (WS-LO-INDEX WS-LO-UNITS-INDX)   
                                          TO S-BASELINE-UNITS-LO        
             PERFORM 8100G-SEND-RESULT-LO  THRU  8100G-EXIT             
             INITIALIZE                      S-CMPNT-ID-CD-LO           
                                             S-INSTR-USE-TYPE-CD-LO     
                                             S-CODE-TIME-PERIOD-LO      
                                             S-BASELINE-UNITS-LO        
           END-PERFORM.                                                 
      *                                                                         
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 6000-PROCESS-102-AND-105-CPD4515 THRU 6000-CPD4515-EXIT      **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04515                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 6000-CPD4517-MAIN-PROCESS THRU 6000-CPD4517-EXIT             **        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04517                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** ERROR ROUTINE FOR COPYBOOK CPD4515                           **        
      ******************************************************************        
      *                                                                         
       6999-ERROR-ROUTINE-CPD4515.                                      
      *                                                                         
           MOVE WS-CPD4515-RETURN-CODE TO WS-RETURN-CODE-ERR.           
                                                                        
           EVALUATE WS-RETURN-CODE-ERR                                  
               WHEN 12                                                  
                    MOVE 'NON003'      TO WS-BUS-RULE-TYPE-ERR          
               WHEN 9999                                                
                    MOVE 'NON002'      TO WS-BUS-RULE-TYPE-ERR          
               WHEN OTHER                                               
                    MOVE 'NON001'      TO WS-BUS-RULE-TYPE-ERR          
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6999-CPD4515-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** ERROR ROUTINE FOR COPYBOOK CPD4517                           **        
      ******************************************************************        
      *                                                                         
       6999-CPD4517-ERROR-PROCESS.                                      
      *                                                                         
           MOVE WS-CPD4517-RETURN-CODE TO WS-RETURN-CODE-ERR.           
      *                                                                         
           EVALUATE WS-RETURN-CODE-ERR                                  
               WHEN 12                                                  
                    MOVE 'NON003'      TO WS-BUS-RULE-TYPE-ERR          
               WHEN 9999                                                
                    MOVE 'NON002'      TO WS-BUS-RULE-TYPE-ERR          
               WHEN OTHER                                               
                    MOVE 'NON001'      TO WS-BUS-RULE-TYPE-ERR          
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT.             
      *                                                                         
       6999-CPD4517-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  SELECT ACCOUNT BILL CYCLE AND CUSTOMER NAME                 **        
      ******************************************************************        
      *                                                                         
       7000-GET-ACCOUNT-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) CASE                                               
                       WHEN DQ.NAME_FORMAT = 'B'                        
                         THEN DQ.FULL_NAME                              
                       WHEN DQ.NAME_FORMAT = 'I'                        
                         THEN (LTRIM(RTRIM(DQ.LAST_NAME)) + ',' + ' ' + 
           LTRIM(RTRIM(DQ.FIRST_NAME)) + ' ' + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)))            
                     END,
              AT.BILL_CYCLE                                      
                                                                        
               INTO  :WS-CUSTOMER-NAME                                  
                    ,:WS-ACCT-BILL-CYCLE                                
                                                                        
               FROM  CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                     
                    ,CSS_CUSTOMER  CU WITH(READUNCOMMITTED)                     
                    ,CSS_NAME      DQ WITH(READUNCOMMITTED)                     
              WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                AND  AT.CUSTOMER_NO = CU.CUSTOMER_NO                    
                AND  CU.NAME_ID     = DQ.NAME_ID                        
                AND  DQ.NAME_TYPE   = 'CN'                              
                                                                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  CASE                                                       
MFA-TR*                WHEN DQ.NAME_FORMAT = 'B'                                
MFA-TR*                  THEN DQ.FULL_NAME                                      
MFA-TR*                WHEN DQ.NAME_FORMAT = 'I'                                
MFA-TR*                  THEN (LTRIM(RTRIM(DQ.LAST_NAME))  || ',' || ' '        
MFA-TR*                     || LTRIM(RTRIM(DQ.FIRST_NAME)) || ' ' ||            
MFA-TR*                        LTRIM(RTRIM(DQ.MIDDLE_NAME)))                    
MFA-TR*              END                                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*                                                                         
MFA-TR*        INTO  :WS-CUSTOMER-NAME                                          
MFA-TR*             ,:WS-ACCT-BILL-CYCLE                                        
MFA-TR*                                                                         
MFA-TR*        FROM  CSS_ACCOUNT   AT                                           
MFA-TR*             ,CSS_CUSTOMER  CU                                           
MFA-TR*             ,CSS_NAME      DQ                                           
MFA-TR*       WHERE  AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*         AND  AT.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*         AND  CU.NAME_ID     = DQ.NAME_ID                                
MFA-TR*         AND  DQ.NAME_TYPE   = 'CN'                                      
MFA-TR*                                                                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CSS_CUSTOMER'             TO TABLE-2                
              MOVE 'CSS_NAME'                 TO TABLE-3                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  SELECT HEADER DETAILS FROM CSS_BILL_MANUAL                  **        
      ******************************************************************        
      *                                                                         
       7050-SELECT-BILL-MANUAL.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  NG.BILL_MAN_STATUS_CD                              
                    ,NG.BILL_MAN_SOURCE_CD                              
               INTO  :NG-BILL-MAN-STATUS-CD                             
                    ,:NG-BILL-MAN-SOURCE-CD                             
               FROM  CSS_BILL_MANUAL   NG WITH(READUNCOMMITTED)                 
              WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO             
                AND  NG.BILL_NO            = :NG-BILL-NO                
                AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE         
                AND  NG.IC_NO              = :NG-IC-NO                  
                AND  NG.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :NG-BILL-ITEM-TIMESTMP
              )     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  NG.BILL_MAN_STATUS_CD                                      
MFA-TR*             ,NG.BILL_MAN_SOURCE_CD                                      
MFA-TR*        INTO  :NG-BILL-MAN-STATUS-CD                                     
MFA-TR*             ,:NG-BILL-MAN-SOURCE-CD                                     
MFA-TR*        FROM  CSS_BILL_MANUAL   NG                                       
MFA-TR*       WHERE  NG.ACCOUNT_NO         = :NG-ACCOUNT-NO                     
MFA-TR*         AND  NG.BILL_NO            = :NG-BILL-NO                        
MFA-TR*         AND  NG.CODE_UTIL_TYPE     = :NG-CODE-UTIL-TYPE                 
MFA-TR*         AND  NG.IC_NO              = :NG-IC-NO                          
MFA-TR*         AND  NG.BILL_ITEM_TIMESTMP = :NG-BILL-ITEM-TIMESTMP             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET RATE PLAN DESC                                          **        
      ******************************************************************        
      *                                                                         
       7060-GET-RATE-PLAN-DESC.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT   RD.RATE_DESC                                      
               INTO  :RD-RATE-DESC                                      
               FROM  CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)               
              WHERE  RD.RATE_PLAN_NO    =  :RD-RATE-PLAN-NO             
                AND  RD.CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE           
                AND  RD.COMPANY_NO      =  :RD-COMPANY-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   RD.RATE_DESC                                              
MFA-TR*        INTO  :RD-RATE-DESC                                              
MFA-TR*        FROM  CSS_RATE_PLAN_DESC  RD                                     
MFA-TR*       WHERE  RD.RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                     
MFA-TR*         AND  RD.CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE                   
MFA-TR*         AND  RD.COMPANY_NO      =  :RD-COMPANY-NO                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7060'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE RD-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REV CLASS DESC                                          **        
      ******************************************************************        
      *                                                                         
       7070-GET-REV-CLASS-DESC.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT   F3.REVENUE_CLS_DESC                               
               INTO  :F3-REVENUE-CLS-DESC                               
               FROM  CSS_REVENUE_CLASS  F3 WITH(READUNCOMMITTED)                
              WHERE  F3.CODE_REVENUE_CLASS  =  :F3-CODE-REVENUE-CLASS   
                AND  F3.CODE_UTIL_TYPE      =  :F3-CODE-UTIL-TYPE       
                AND  F3.COMPANY_NO          =  :F3-COMPANY-NO           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   F3.REVENUE_CLS_DESC                                       
MFA-TR*        INTO  :F3-REVENUE-CLS-DESC                                       
MFA-TR*        FROM  CSS_REVENUE_CLASS  F3                                      
MFA-TR*       WHERE  F3.CODE_REVENUE_CLASS  =  :F3-CODE-REVENUE-CLASS           
MFA-TR*         AND  F3.CODE_UTIL_TYPE      =  :F3-CODE-UTIL-TYPE               
MFA-TR*         AND  F3.COMPANY_NO          =  :F3-COMPANY-NO                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7070                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7070'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REVENUE_CLASS'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_REVENUE_CLASS'       TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE F3-CODE-REVENUE-CLASS      TO HOSTVAR-ELEMENT-2      
              MOVE F3-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE F3-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MAN_DET_CUR CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-BILL-MAN-DET-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN MAN_DET_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MAN_DET_CUR CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-BILL-MAN-DET-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH MAN_DET_CUR                                         
               INTO :NU-BILL-MAN-DET-SEQ                                
                   ,:NU-BILL-MANUAL-TBL-ID                              
                   ,:NU-BILL-MANUAL-DATA                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MAN_DET_CUR CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-BILL-MAN-DET-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE MAN_DET_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_MANUAL'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NU-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NU-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NU-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REVENUE MONTH / REV MTH ORIG BILL                       **        
      ******************************************************************        
      *                                                                         
       7150-GET-REVENUE-MONTH-BG.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) COALESCE(CASE WHEN BG.REV_MTH_ORIG_BILL > 0          
                           THEN BG.REV_MTH_ORIG_BILL                    
                           ELSE BG.REVENUE_MONTH                        
                           END,0),
              COALESCE(BG.DATE_ORIG_BILL,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              BG.CODE_BILL_CALC                                  
               INTO  :BG-REVENUE-MONTH                                  
                    ,:BG-DATE-ORIG-BILL                                 
PRDFIX              ,:BG-CODE-BILL-CALC                                 
               FROM  CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
              WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO           
                AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE       
                AND  BG.IC_NO               =  :BG-IC-NO                
                AND  BG.BILL_NO             =  :BG-BILL-NO              
                AND  BG.BILL_ITEM_TIMESTMP  =  CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )   
                AND  BG.CODE_BILL_CALC      IN ('A','S')                
                AND  BG.CODE_BILL_ITM_TYPE  =   'C'                     
                AND  BG.CODE_BILL_ITM_IND   =   'A'                     
                AND  BG.REV_RPT_CD          <>  'T'                     
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(CASE WHEN BG.REV_MTH_ORIG_BILL > 0                  
MFA-TR*                    THEN BG.REV_MTH_ORIG_BILL                            
MFA-TR*                    ELSE BG.REVENUE_MONTH                                
MFA-TR*                    END,0)                                               
MFA-TR*             ,IFNULL(BG.DATE_ORIG_BILL,'1900-01-01')                     
MFA-TR*             ,BG.CODE_BILL_CALC                                          
MFA-TR*        INTO  :BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-DATE-ORIG-BILL                                         
MFA-TR*             ,:BG-CODE-BILL-CALC                                         
MFA-TR*        FROM  CSS_BILLING_DET  BG                                        
MFA-TR*       WHERE  BG.ACCOUNT_NO          =  :BG-ACCOUNT-NO                   
MFA-TR*         AND  BG.CODE_UTIL_TYPE      =  :BG-CODE-UTIL-TYPE               
MFA-TR*         AND  BG.IC_NO               =  :BG-IC-NO                        
MFA-TR*         AND  BG.BILL_NO             =  :BG-BILL-NO                      
MFA-TR*         AND  BG.BILL_ITEM_TIMESTMP  =  :BG-BILL-ITEM-TIMESTMP           
MFA-TR*         AND  BG.CODE_BILL_CALC      IN ('A','S')                        
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE  =   'C'                             
MFA-TR*         AND  BG.CODE_BILL_ITM_IND   =   'A'                             
MFA-TR*         AND  BG.REV_RPT_CD          <>  'T'                             
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE BG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - MAIN                                  **        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS-MAIN.                                      
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_MAIN'                
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_MAIN                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_MAIN                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_MAIN'          TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - HDR                                   **        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS-HDR.                                       
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_HDR'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_HDR                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_HDR                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_HDR'           TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - BG                                    **        
      ******************************************************************        
      *                                                                         
       8000C-DELETE-GTT-ROWS-BG.                                        
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_BG'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_BG                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_BG                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000C'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_BG'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - BC                                    **        
      ******************************************************************        
      *                                                                         
       8000D-DELETE-GTT-ROWS-BC.                                        
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_BC'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_BC                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_BC                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000D'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_BC'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - BA                                    **        
      ******************************************************************        
      *                                                                         
       8000E-DELETE-GTT-ROWS-BA.                                        
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_BA'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_BA                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_BA                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000E'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_BA'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000E-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - BX                                    **        
      ******************************************************************        
      *                                                                         
       8000F-DELETE-GTT-ROWS-BX.                                        
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_BX'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_BX                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_BX                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000F'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_BX'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000F-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - LO                                    **        
      ******************************************************************        
      *                                                                         
       8000G-DELETE-GTT-ROWS-LO.                                        
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04515_LO'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04515_LO                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04515_LO                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO WS-RETURN-CODE-ERR      
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000G'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04515_LO'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000G-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - MAIN                                       **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-MAIN.                                          
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_MAIN                          
             (                                                          
              RETURN_CODE                                               
             ,BUS_RULE_TYPE                                             
             ,BUS_RULE_RESULT                                           
             ,ERROR_CODE                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-BUS-RULE-TYPE                                          
             ,:S-BUS-RULE-RESULT                                        
             ,:S-ERROR-CODE                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_MAIN                                  
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BUS_RULE_TYPE                                                     
MFA-TR*      ,BUS_RULE_RESULT                                                   
MFA-TR*      ,ERROR_CODE                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-BUS-RULE-TYPE                                                  
MFA-TR*      ,:S-BUS-RULE-RESULT                                                
MFA-TR*      ,:S-ERROR-CODE                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_MAIN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-MAIN.                
      *                                                                         
       8100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - HDR                                        **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-HDR.                                           
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_HDR                           
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_STATUS_CD                                        
             ,BILL_MAN_SOURCE_CD                                        
             ,DATA_SOURCE_CD                                            
             ,CUSTOMER_NAME                                             
             ,BILL_CYCLE                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-HDR                                        
             ,:S-BILL-MAN-STATUS-CD                                     
             ,:S-BILL-MAN-SOURCE-CD                                     
             ,:S-DATA-SOURCE-CD                                         
             ,:S-CUSTOMER-NAME                                          
             ,:S-BILL-CYCLE                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_HDR                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_STATUS_CD                                                
MFA-TR*      ,BILL_MAN_SOURCE_CD                                                
MFA-TR*      ,DATA_SOURCE_CD                                                    
MFA-TR*      ,CUSTOMER_NAME                                                     
MFA-TR*      ,BILL_CYCLE                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-HDR                                                
MFA-TR*      ,:S-BILL-MAN-STATUS-CD                                             
MFA-TR*      ,:S-BILL-MAN-SOURCE-CD                                             
MFA-TR*      ,:S-DATA-SOURCE-CD                                                 
MFA-TR*      ,:S-CUSTOMER-NAME                                                  
MFA-TR*      ,:S-BILL-CYCLE                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100B'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_HDR'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-HDR.                 
      *                                                                         
       8100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - BG                                         **        
      ******************************************************************        
      *                                                                         
       8100C-SEND-RESULT-BG.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_BG                            
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_DET_SEQ                                          
             ,AMT_BILL_ITEM                                             
             ,AMT_STATE_TAX                                             
             ,AMT_CITY_TAX                                              
             ,CODE_REVENUE_CLASS                                        
             ,REVENUE_CLS_DESC                                          
             ,RATE_PLAN_NO                                              
             ,RATE_DESC                                                 
             ,CODE_STAT_TAX_XMT                                         
             ,CODE_CITY_TAX_XMT                                         
             ,PRORATE_CD                                                
             ,NEW_RATE_PCT                                              
             ,OLD_RATE_PCT                                              
             ,REBILL_IND                                                
             ,ADJ_REASON_CD                                             
             ,REVENUE_MONTH                                             
             ,BTU_FACTOR                                                
             ,GAS_BASE_USE                                              
             ,NO_OF_CONS_DAYS                                           
             ,REV_MTH_ORIG_BILL                                         
             ,TOT_NEW_CHRGS_CALC                                        
             ,CUST_CHRG_DOLLARS_CALC                                    
             ,USAGE_DOLLARS_CALC                                        
             ,DEMAND_DOLLARS_CALC                                       
             ,USAGE_END_DATE_CALC                                       
             ,FRANCHISE_TX_RATE_CALC                                    
             ,STATE_TX_RATE_CALC                                        
             ,BILL_CALC_CYCLE                                           
             ,PRORATED_ON_NBR_DAYS                                      
             ,NEW_RATE_EFF_DATE                                         
             ,OLD_RATE_EFF_DATE                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-BG                                         
             ,:S-BILL-MAN-DET-SEQ-BG                                    
             ,:S-AMT-BILL-ITEM-BG                                       
             ,:S-AMT-STATE-TAX-BG                                       
             ,:S-AMT-CITY-TAX-BG                                        
             ,:S-CODE-REVENUE-CLASS-BG                                  
             ,:S-REVENUE-CLS-DESC-BG                                    
             ,:S-RATE-PLAN-NO-BG                                        
             ,:S-RATE-DESC-BG                                           
             ,:S-CODE-STAT-TAX-XMT-BG                                   
             ,:S-CODE-CITY-TAX-XMT-BG                                   
             ,:S-PRORATE-CD-BG                                          
             ,:S-NEW-RATE-PCT-BG                                        
             ,:S-OLD-RATE-PCT-BG                                        
             ,:S-REBILL-IND-BG                                          
             ,:S-ADJ-REASON-CD-BG                                       
             ,:S-REVENUE-MONTH-BG                                       
             ,:S-BTU-FACTOR-BG                                          
             ,:S-GAS-BASE-USE-BG                                        
             ,:S-NO-OF-CONS-DAYS-BG                                     
             ,:S-REV-MTH-ORIG-BILL-BG                                   
             ,:S-TOT-NEW-CHRGS-CALC                                     
             ,:S-CUST-CHRG-DOLLARS-CALC                                 
             ,:S-USAGE-DOLLARS-CALC                                     
             ,:S-DEMAND-DOLLARS-CALC                                    
             ,:S-USAGE-END-DATE-CALC                                    
             ,:S-FRANCHISE-TX-RATE-CALC                                 
             ,:S-STATE-TX-RATE-CALC                                     
             ,:S-BILL-CALC-CYCLE-BG                                     
             ,:S-PRORATED-ON-NBR-DAYS-BG                                
             ,:S-NEW-RATE-EFF-DATE-BG                                   
             ,:S-OLD-RATE-EFF-DATE-BG                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_BG                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_DET_SEQ                                                  
MFA-TR*      ,AMT_BILL_ITEM                                                     
MFA-TR*      ,AMT_STATE_TAX                                                     
MFA-TR*      ,AMT_CITY_TAX                                                      
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,REVENUE_CLS_DESC                                                  
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,RATE_DESC                                                         
MFA-TR*      ,CODE_STAT_TAX_XMT                                                 
MFA-TR*      ,CODE_CITY_TAX_XMT                                                 
MFA-TR*      ,PRORATE_CD                                                        
MFA-TR*      ,NEW_RATE_PCT                                                      
MFA-TR*      ,OLD_RATE_PCT                                                      
MFA-TR*      ,REBILL_IND                                                        
MFA-TR*      ,ADJ_REASON_CD                                                     
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      ,BTU_FACTOR                                                        
MFA-TR*      ,GAS_BASE_USE                                                      
MFA-TR*      ,NO_OF_CONS_DAYS                                                   
MFA-TR*      ,REV_MTH_ORIG_BILL                                                 
MFA-TR*      ,TOT_NEW_CHRGS_CALC                                                
MFA-TR*      ,CUST_CHRG_DOLLARS_CALC                                            
MFA-TR*      ,USAGE_DOLLARS_CALC                                                
MFA-TR*      ,DEMAND_DOLLARS_CALC                                               
MFA-TR*      ,USAGE_END_DATE_CALC                                               
MFA-TR*      ,FRANCHISE_TX_RATE_CALC                                            
MFA-TR*      ,STATE_TX_RATE_CALC                                                
MFA-TR*      ,BILL_CALC_CYCLE                                                   
MFA-TR*      ,PRORATED_ON_NBR_DAYS                                              
MFA-TR*      ,NEW_RATE_EFF_DATE                                                 
MFA-TR*      ,OLD_RATE_EFF_DATE                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-BG                                                 
MFA-TR*      ,:S-BILL-MAN-DET-SEQ-BG                                            
MFA-TR*      ,:S-AMT-BILL-ITEM-BG                                               
MFA-TR*      ,:S-AMT-STATE-TAX-BG                                               
MFA-TR*      ,:S-AMT-CITY-TAX-BG                                                
MFA-TR*      ,:S-CODE-REVENUE-CLASS-BG                                          
MFA-TR*      ,:S-REVENUE-CLS-DESC-BG                                            
MFA-TR*      ,:S-RATE-PLAN-NO-BG                                                
MFA-TR*      ,:S-RATE-DESC-BG                                                   
MFA-TR*      ,:S-CODE-STAT-TAX-XMT-BG                                           
MFA-TR*      ,:S-CODE-CITY-TAX-XMT-BG                                           
MFA-TR*      ,:S-PRORATE-CD-BG                                                  
MFA-TR*      ,:S-NEW-RATE-PCT-BG                                                
MFA-TR*      ,:S-OLD-RATE-PCT-BG                                                
MFA-TR*      ,:S-REBILL-IND-BG                                                  
MFA-TR*      ,:S-ADJ-REASON-CD-BG                                               
MFA-TR*      ,:S-REVENUE-MONTH-BG                                               
MFA-TR*      ,:S-BTU-FACTOR-BG                                                  
MFA-TR*      ,:S-GAS-BASE-USE-BG                                                
MFA-TR*      ,:S-NO-OF-CONS-DAYS-BG                                             
MFA-TR*      ,:S-REV-MTH-ORIG-BILL-BG                                           
MFA-TR*      ,:S-TOT-NEW-CHRGS-CALC                                             
MFA-TR*      ,:S-CUST-CHRG-DOLLARS-CALC                                         
MFA-TR*      ,:S-USAGE-DOLLARS-CALC                                             
MFA-TR*      ,:S-DEMAND-DOLLARS-CALC                                            
MFA-TR*      ,:S-USAGE-END-DATE-CALC                                            
MFA-TR*      ,:S-FRANCHISE-TX-RATE-CALC                                         
MFA-TR*      ,:S-STATE-TX-RATE-CALC                                             
MFA-TR*      ,:S-BILL-CALC-CYCLE-BG                                             
MFA-TR*      ,:S-PRORATED-ON-NBR-DAYS-BG                                        
MFA-TR*      ,:S-NEW-RATE-EFF-DATE-BG                                           
MFA-TR*      ,:S-OLD-RATE-EFF-DATE-BG                                           
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100C'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_BG'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-BG.                  
      *                                                                         
       8100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - BC                                         **        
      ******************************************************************        
      *                                                                         
       8100D-SEND-RESULT-BC.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_BC                            
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_DET_SEQ                                          
             ,COMPONENT_ID                                              
             ,CONSUMPTION_TYPE                                          
             ,REGISTER_TYPE                                             
             ,CODE_TOU                                                  
             ,CODE_SEASON                                               
             ,RATE_VERSION                                              
             ,READ_UNITS                                                
             ,NET_UNIT_SEL_RSN                                          
             ,BLOCKS_USED                                               
             ,BLOCK_NO                                                  
             ,BLOCK_SIZE                                                
             ,UNITS_BILLED                                              
             ,PRICE_TYPE_CD                                             
             ,AMT_BASE_RATE                                             
             ,AMT_NET_RATE                                              
             ,AMT_BLOCK                                                 
             ,CALC_COMPONENT_AMT                                        
             ,NET_COMPONENT_AMT                                         
             ,EVENT_NUMBER                                              
             ,EVENT_DATE                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-BC                                         
             ,:S-BILL-MAN-DET-SEQ-BC                                    
             ,:S-COMPONENT-ID-BC                                        
             ,:S-CONSUMPTION-TYPE-BC                                    
             ,:S-REGISTER-TYPE-BC                                       
             ,:S-CODE-TOU-BC                                            
             ,:S-CODE-SEASON-BC                                         
             ,:S-RATE-VERSION-BC                                        
             ,:S-READ-UNITS-BC                                          
             ,:S-NET-UNIT-SEL-RSN-BC                                    
             ,:S-BLOCKS-USED-BC                                         
             ,:S-BLOCK-NO-BC                                            
             ,:S-BLOCK-SIZE-BC                                          
             ,:S-UNITS-BILLED-BC                                        
             ,:S-PRICE-TYPE-CD-BC                                       
             ,:S-AMT-BASE-RATE-BC                                       
             ,:S-AMT-NET-RATE-BC                                        
             ,:S-AMT-BLOCK-BC                                           
             ,:S-CALC-COMPONENT-AMT-BC                                  
             ,:S-NET-COMPONENT-AMT-BC                                   
             ,:S-EVENT-NUMBER-BC                                        
             ,:S-EVENT-DATE-BC                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_BC                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_DET_SEQ                                                  
MFA-TR*      ,COMPONENT_ID                                                      
MFA-TR*      ,CONSUMPTION_TYPE                                                  
MFA-TR*      ,REGISTER_TYPE                                                     
MFA-TR*      ,CODE_TOU                                                          
MFA-TR*      ,CODE_SEASON                                                       
MFA-TR*      ,RATE_VERSION                                                      
MFA-TR*      ,READ_UNITS                                                        
MFA-TR*      ,NET_UNIT_SEL_RSN                                                  
MFA-TR*      ,BLOCKS_USED                                                       
MFA-TR*      ,BLOCK_NO                                                          
MFA-TR*      ,BLOCK_SIZE                                                        
MFA-TR*      ,UNITS_BILLED                                                      
MFA-TR*      ,PRICE_TYPE_CD                                                     
MFA-TR*      ,AMT_BASE_RATE                                                     
MFA-TR*      ,AMT_NET_RATE                                                      
MFA-TR*      ,AMT_BLOCK                                                         
MFA-TR*      ,CALC_COMPONENT_AMT                                                
MFA-TR*      ,NET_COMPONENT_AMT                                                 
MFA-TR*      ,EVENT_NUMBER                                                      
MFA-TR*      ,EVENT_DATE                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-BC                                                 
MFA-TR*      ,:S-BILL-MAN-DET-SEQ-BC                                            
MFA-TR*      ,:S-COMPONENT-ID-BC                                                
MFA-TR*      ,:S-CONSUMPTION-TYPE-BC                                            
MFA-TR*      ,:S-REGISTER-TYPE-BC                                               
MFA-TR*      ,:S-CODE-TOU-BC                                                    
MFA-TR*      ,:S-CODE-SEASON-BC                                                 
MFA-TR*      ,:S-RATE-VERSION-BC                                                
MFA-TR*      ,:S-READ-UNITS-BC                                                  
MFA-TR*      ,:S-NET-UNIT-SEL-RSN-BC                                            
MFA-TR*      ,:S-BLOCKS-USED-BC                                                 
MFA-TR*      ,:S-BLOCK-NO-BC                                                    
MFA-TR*      ,:S-BLOCK-SIZE-BC                                                  
MFA-TR*      ,:S-UNITS-BILLED-BC                                                
MFA-TR*      ,:S-PRICE-TYPE-CD-BC                                               
MFA-TR*      ,:S-AMT-BASE-RATE-BC                                               
MFA-TR*      ,:S-AMT-NET-RATE-BC                                                
MFA-TR*      ,:S-AMT-BLOCK-BC                                                   
MFA-TR*      ,:S-CALC-COMPONENT-AMT-BC                                          
MFA-TR*      ,:S-NET-COMPONENT-AMT-BC                                           
MFA-TR*      ,:S-EVENT-NUMBER-BC                                                
MFA-TR*      ,:S-EVENT-DATE-BC                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100D'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_BC'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-BC.                  
      *                                                                         
       8100D-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - BA                                         **        
      ******************************************************************        
      *                                                                         
       8100E-SEND-RESULT-BA.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_BA                            
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_DET_SEQ                                          
             ,FACTOR_ID                                                 
             ,FCT_CMPNT_ID                                              
             ,FCT_CNSMPT_TYPE                                           
             ,FCT_REGISTER_TYPE                                         
             ,FCT_TOU                                                   
             ,FCT_SEASON                                                
             ,FCT_RATE_VERSION                                          
             ,CODE_CALC_TYPE                                            
             ,CODE_ADJ_UNIT_SOURCE                                      
             ,CODE_ADJUST_TYPE                                          
             ,ADJ_UNITS                                                 
             ,FACTOR                                                    
             ,AMT_ADJUSTMENT                                            
             ,STATE_TAX_XMPT_ADJ                                        
             ,CITY_TAX_XMPT_ADJ                                         
             ,OTHER_TAX_XMPT_ADJ                                        
             ,BLOCK_NO                                                  
             ,RATE_FROM_DATE                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-BA                                         
             ,:S-BILL-MAN-DET-SEQ-BA                                    
             ,:S-FACTOR-ID-BA                                           
             ,:S-FCT-CMPNT-ID-BA                                        
             ,:S-FCT-CNSMPT-TYPE-BA                                     
             ,:S-FCT-REGISTER-TYPE-BA                                   
             ,:S-FCT-TOU-BA                                             
             ,:S-FCT-SEASON-BA                                          
             ,:S-FCT-RATE-VERSION-BA                                    
             ,:S-CODE-CALC-TYPE-BA                                      
             ,:S-CODE-ADJ-UNIT-SOURCE-BA                                
             ,:S-CODE-ADJUST-TYPE-BA                                    
             ,:S-ADJ-UNITS-BA                                           
             ,:S-FACTOR-BA                                              
             ,:S-AMT-ADJUSTMENT-BA                                      
             ,:S-STATE-TAX-XMPT-ADJ-BA                                  
             ,:S-CITY-TAX-XMPT-ADJ-BA                                   
             ,:S-OTHER-TAX-XMPT-ADJ-BA                                  
             ,:S-BLOCK-NO-BA                                            
             ,:S-RATE-FROM-DATE-BA                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_BA                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_DET_SEQ                                                  
MFA-TR*      ,FACTOR_ID                                                         
MFA-TR*      ,FCT_CMPNT_ID                                                      
MFA-TR*      ,FCT_CNSMPT_TYPE                                                   
MFA-TR*      ,FCT_REGISTER_TYPE                                                 
MFA-TR*      ,FCT_TOU                                                           
MFA-TR*      ,FCT_SEASON                                                        
MFA-TR*      ,FCT_RATE_VERSION                                                  
MFA-TR*      ,CODE_CALC_TYPE                                                    
MFA-TR*      ,CODE_ADJ_UNIT_SOURCE                                              
MFA-TR*      ,CODE_ADJUST_TYPE                                                  
MFA-TR*      ,ADJ_UNITS                                                         
MFA-TR*      ,FACTOR                                                            
MFA-TR*      ,AMT_ADJUSTMENT                                                    
MFA-TR*      ,STATE_TAX_XMPT_ADJ                                                
MFA-TR*      ,CITY_TAX_XMPT_ADJ                                                 
MFA-TR*      ,OTHER_TAX_XMPT_ADJ                                                
MFA-TR*      ,BLOCK_NO                                                          
MFA-TR*      ,RATE_FROM_DATE                                                    
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-BA                                                 
MFA-TR*      ,:S-BILL-MAN-DET-SEQ-BA                                            
MFA-TR*      ,:S-FACTOR-ID-BA                                                   
MFA-TR*      ,:S-FCT-CMPNT-ID-BA                                                
MFA-TR*      ,:S-FCT-CNSMPT-TYPE-BA                                             
MFA-TR*      ,:S-FCT-REGISTER-TYPE-BA                                           
MFA-TR*      ,:S-FCT-TOU-BA                                                     
MFA-TR*      ,:S-FCT-SEASON-BA                                                  
MFA-TR*      ,:S-FCT-RATE-VERSION-BA                                            
MFA-TR*      ,:S-CODE-CALC-TYPE-BA                                              
MFA-TR*      ,:S-CODE-ADJ-UNIT-SOURCE-BA                                        
MFA-TR*      ,:S-CODE-ADJUST-TYPE-BA                                            
MFA-TR*      ,:S-ADJ-UNITS-BA                                                   
MFA-TR*      ,:S-FACTOR-BA                                                      
MFA-TR*      ,:S-AMT-ADJUSTMENT-BA                                              
MFA-TR*      ,:S-STATE-TAX-XMPT-ADJ-BA                                          
MFA-TR*      ,:S-CITY-TAX-XMPT-ADJ-BA                                           
MFA-TR*      ,:S-OTHER-TAX-XMPT-ADJ-BA                                          
MFA-TR*      ,:S-BLOCK-NO-BA                                                    
MFA-TR*      ,:S-RATE-FROM-DATE-BA                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100E'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_BA'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-BA.                  
      *                                                                         
       8100E-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - BX                                         **        
      ******************************************************************        
      *                                                                         
       8100F-SEND-RESULT-BX.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_BX                            
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_DET_SEQ                                          
             ,CNTRCT_START_DT                                           
             ,CNTRCT_END_DT                                             
             ,SPCL_ADM_CHRG_AM                                          
             ,SPCL_MO_MIN_AM                                            
             ,SPCL_ANN_MIN_AM_OLD                                       
             ,ANN_MIN_TYPE_CD                                           
             ,CBL_REF_RATE_PLN                                          
             ,COMP_RATE_PLAN                                            
             ,COMPARE_TYPE_CD                                           
             ,CANCEL_CHRG_AM                                            
             ,CONTRACT_STDBY_DEM                                        
             ,CONTRACT_DEMAND                                           
             ,FIRM_PER_HR_KWH                                           
             ,BUILD_UP_MONTHS                                           
             ,STDBY_YTD_PK_HRS                                          
             ,STDBY_YTD_HRS                                             
             ,UPDATE_ACTION_IND                                         
             ,CONTRACT_ECON_DEM                                         
             ,MAX_ECON_DEM                                              
             ,DEM_CNSLDTN_CD                                            
             ,DFLT_USAGE_CLS_CD                                         
             ,STDBY_LIMIT_HRS                                           
             ,STDBY_LIMIT_PK_HRS                                        
             ,STDBY_RESET_MTH                                           
             ,ALT_SPLY_RATE_NO                                          
             ,ALT_SPLY_REV_CL_CD                                        
             ,ALTERNATE_FUEL_CD                                         
             ,ALTN_FUEL_SPLY_CD                                         
             ,FUEL_SHIPPER_CD                                           
             ,VERS_PRORATE_CD                                           
             ,TRNSP_SHRINK_PCT                                          
             ,ANN_REVIEW_MONTH                                          
             ,CONTRACT_TERM_CD                                          
             ,SPCL_ANN_MIN_AM                                           
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-BX                                         
             ,:S-BILL-MAN-DET-SEQ-BX                                    
             ,:S-CNTRCT-START-DT-BX                                     
             ,:S-CNTRCT-END-DT-BX                                       
             ,:S-SPCL-ADM-CHRG-AM-BX                                    
             ,:S-SPCL-MO-MIN-AM-BX                                      
             ,:S-SPCL-ANN-MIN-AM-OLD-BX                                 
             ,:S-ANN-MIN-TYPE-CD-BX                                     
             ,:S-CBL-REF-RATE-PLN-BX                                    
             ,:S-COMP-RATE-PLAN-BX                                      
             ,:S-COMPARE-TYPE-CD-BX                                     
             ,:S-CANCEL-CHRG-AM-BX                                      
             ,:S-CONTRACT-STDBY-DEM-BX                                  
             ,:S-CONTRACT-DEMAND-BX                                     
             ,:S-FIRM-PER-HR-KWH-BX                                     
             ,:S-BUILD-UP-MONTHS-BX                                     
             ,:S-STDBY-YTD-PK-HRS-BX                                    
             ,:S-STDBY-YTD-HRS-BX                                       
             ,:S-UPDATE-ACTION-IND-BX                                   
             ,:S-CONTRACT-ECON-DEM-BX                                   
             ,:S-MAX-ECON-DEM-BX                                        
             ,:S-DEM-CNSLDTN-CD-BX                                      
             ,:S-DFLT-USAGE-CLS-CD-BX                                   
             ,:S-STDBY-LIMIT-HRS-BX                                     
             ,:S-STDBY-LIMIT-PK-HRS-BX                                  
             ,:S-STDBY-RESET-MTH-BX                                     
             ,:S-ALT-SPLY-RATE-NO-BX                                    
             ,:S-ALT-SPLY-REV-CL-CD-BX                                  
             ,:S-ALTERNATE-FUEL-CD-BX                                   
             ,:S-ALTN-FUEL-SPLY-CD-BX                                   
             ,:S-FUEL-SHIPPER-CD-BX                                     
             ,:S-VERS-PRORATE-CD-BX                                     
             ,:S-TRNSP-SHRINK-PCT-BX                                    
             ,:S-ANN-REVIEW-MONTH-BX                                    
             ,:S-CONTRACT-TERM-CD-BX                                    
             ,:S-SPCL-ANN-MIN-AM-BX                                     
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_BX                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_DET_SEQ                                                  
MFA-TR*      ,CNTRCT_START_DT                                                   
MFA-TR*      ,CNTRCT_END_DT                                                     
MFA-TR*      ,SPCL_ADM_CHRG_AM                                                  
MFA-TR*      ,SPCL_MO_MIN_AM                                                    
MFA-TR*      ,SPCL_ANN_MIN_AM_OLD                                               
MFA-TR*      ,ANN_MIN_TYPE_CD                                                   
MFA-TR*      ,CBL_REF_RATE_PLN                                                  
MFA-TR*      ,COMP_RATE_PLAN                                                    
MFA-TR*      ,COMPARE_TYPE_CD                                                   
MFA-TR*      ,CANCEL_CHRG_AM                                                    
MFA-TR*      ,CONTRACT_STDBY_DEM                                                
MFA-TR*      ,CONTRACT_DEMAND                                                   
MFA-TR*      ,FIRM_PER_HR_KWH                                                   
MFA-TR*      ,BUILD_UP_MONTHS                                                   
MFA-TR*      ,STDBY_YTD_PK_HRS                                                  
MFA-TR*      ,STDBY_YTD_HRS                                                     
MFA-TR*      ,UPDATE_ACTION_IND                                                 
MFA-TR*      ,CONTRACT_ECON_DEM                                                 
MFA-TR*      ,MAX_ECON_DEM                                                      
MFA-TR*      ,DEM_CNSLDTN_CD                                                    
MFA-TR*      ,DFLT_USAGE_CLS_CD                                                 
MFA-TR*      ,STDBY_LIMIT_HRS                                                   
MFA-TR*      ,STDBY_LIMIT_PK_HRS                                                
MFA-TR*      ,STDBY_RESET_MTH                                                   
MFA-TR*      ,ALT_SPLY_RATE_NO                                                  
MFA-TR*      ,ALT_SPLY_REV_CL_CD                                                
MFA-TR*      ,ALTERNATE_FUEL_CD                                                 
MFA-TR*      ,ALTN_FUEL_SPLY_CD                                                 
MFA-TR*      ,FUEL_SHIPPER_CD                                                   
MFA-TR*      ,VERS_PRORATE_CD                                                   
MFA-TR*      ,TRNSP_SHRINK_PCT                                                  
MFA-TR*      ,ANN_REVIEW_MONTH                                                  
MFA-TR*      ,CONTRACT_TERM_CD                                                  
MFA-TR*      ,SPCL_ANN_MIN_AM                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-BX                                                 
MFA-TR*      ,:S-BILL-MAN-DET-SEQ-BX                                            
MFA-TR*      ,:S-CNTRCT-START-DT-BX                                             
MFA-TR*      ,:S-CNTRCT-END-DT-BX                                               
MFA-TR*      ,:S-SPCL-ADM-CHRG-AM-BX                                            
MFA-TR*      ,:S-SPCL-MO-MIN-AM-BX                                              
MFA-TR*      ,:S-SPCL-ANN-MIN-AM-OLD-BX                                         
MFA-TR*      ,:S-ANN-MIN-TYPE-CD-BX                                             
MFA-TR*      ,:S-CBL-REF-RATE-PLN-BX                                            
MFA-TR*      ,:S-COMP-RATE-PLAN-BX                                              
MFA-TR*      ,:S-COMPARE-TYPE-CD-BX                                             
MFA-TR*      ,:S-CANCEL-CHRG-AM-BX                                              
MFA-TR*      ,:S-CONTRACT-STDBY-DEM-BX                                          
MFA-TR*      ,:S-CONTRACT-DEMAND-BX                                             
MFA-TR*      ,:S-FIRM-PER-HR-KWH-BX                                             
MFA-TR*      ,:S-BUILD-UP-MONTHS-BX                                             
MFA-TR*      ,:S-STDBY-YTD-PK-HRS-BX                                            
MFA-TR*      ,:S-STDBY-YTD-HRS-BX                                               
MFA-TR*      ,:S-UPDATE-ACTION-IND-BX                                           
MFA-TR*      ,:S-CONTRACT-ECON-DEM-BX                                           
MFA-TR*      ,:S-MAX-ECON-DEM-BX                                                
MFA-TR*      ,:S-DEM-CNSLDTN-CD-BX                                              
MFA-TR*      ,:S-DFLT-USAGE-CLS-CD-BX                                           
MFA-TR*      ,:S-STDBY-LIMIT-HRS-BX                                             
MFA-TR*      ,:S-STDBY-LIMIT-PK-HRS-BX                                          
MFA-TR*      ,:S-STDBY-RESET-MTH-BX                                             
MFA-TR*      ,:S-ALT-SPLY-RATE-NO-BX                                            
MFA-TR*      ,:S-ALT-SPLY-REV-CL-CD-BX                                          
MFA-TR*      ,:S-ALTERNATE-FUEL-CD-BX                                           
MFA-TR*      ,:S-ALTN-FUEL-SPLY-CD-BX                                           
MFA-TR*      ,:S-FUEL-SHIPPER-CD-BX                                             
MFA-TR*      ,:S-VERS-PRORATE-CD-BX                                             
MFA-TR*      ,:S-TRNSP-SHRINK-PCT-BX                                            
MFA-TR*      ,:S-ANN-REVIEW-MONTH-BX                                            
MFA-TR*      ,:S-CONTRACT-TERM-CD-BX                                            
MFA-TR*      ,:S-SPCL-ANN-MIN-AM-BX                                             
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100F'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_BX'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-BX.                  
      *                                                                         
       8100F-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - LO                                         **        
      ******************************************************************        
      *                                                                         
       8100G-SEND-RESULT-LO.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04515_LO                            
             (                                                          
              RETURN_CODE                                               
             ,BILL_MAN_DET_SEQ                                          
             ,CNTRCT_START_DT                                           
             ,BASELINE_MONTH                                            
             ,CMPNT_ID_CD                                               
             ,INSTR_USE_TYPE_CD                                         
             ,CODE_TIME_PERIOD                                          
             ,BASELINE_UNITS                                            
             ,UPDATE_ACTION_IND                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-LO                                         
             ,:S-BILL-MAN-DET-SEQ-LO                                    
             ,:S-CNTRCT-START-DT-LO                                     
             ,:S-BASELINE-MONTH-LO                                      
             ,:S-CMPNT-ID-CD-LO                                         
             ,:S-INSTR-USE-TYPE-CD-LO                                   
             ,:S-CODE-TIME-PERIOD-LO                                    
             ,:S-BASELINE-UNITS-LO                                      
             ,:S-UPDATE-ACTION-IND-LO                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04515_LO                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,BILL_MAN_DET_SEQ                                                  
MFA-TR*      ,CNTRCT_START_DT                                                   
MFA-TR*      ,BASELINE_MONTH                                                    
MFA-TR*      ,CMPNT_ID_CD                                                       
MFA-TR*      ,INSTR_USE_TYPE_CD                                                 
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,BASELINE_UNITS                                                    
MFA-TR*      ,UPDATE_ACTION_IND                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-LO                                                 
MFA-TR*      ,:S-BILL-MAN-DET-SEQ-LO                                            
MFA-TR*      ,:S-CNTRCT-START-DT-LO                                             
MFA-TR*      ,:S-BASELINE-MONTH-LO                                              
MFA-TR*      ,:S-CMPNT-ID-CD-LO                                                 
MFA-TR*      ,:S-INSTR-USE-TYPE-CD-LO                                           
MFA-TR*      ,:S-CODE-TIME-PERIOD-LO                                            
MFA-TR*      ,:S-BASELINE-UNITS-LO                                              
MFA-TR*      ,:S-UPDATE-ACTION-IND-LO                                           
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO WS-RETURN-CODE-ERR     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100G'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04515_LO'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'BILL_ITEM_TIMESTMP'       TO TABLE-ELEMENT-4        
              MOVE NG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE NG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              MOVE NG-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE NG-BILL-ITEM-TIMESTMP      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                       TO CTR-ROWS-LO.                  
      *                                                                         
       8100G-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-MAIN  THRU  0100A-EXIT.            
           PERFORM 0100B-DECLARE-GTT-HDR   THRU  0100B-EXIT.            
           PERFORM 0100C-DECLARE-GTT-BG    THRU  0100C-EXIT.            
           PERFORM 0100D-DECLARE-GTT-BC    THRU  0100D-EXIT.            
           PERFORM 0100E-DECLARE-GTT-BA    THRU  0100E-EXIT.            
           PERFORM 0100F-DECLARE-GTT-BX    THRU  0100F-EXIT.            
           PERFORM 0100G-DECLARE-GTT-LO    THRU  0100G-EXIT.            
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
           MOVE WS-RETURN-CODE-ERR     TO S-ERROR-CODE.                 
           MOVE 100                    TO S-RETURN-CODE                 
                                          S-RETURN-CODE-HDR             
                                          S-RETURN-CODE-BG              
                                          S-RETURN-CODE-BC              
                                          S-RETURN-CODE-BA              
                                          S-RETURN-CODE-BX              
                                          S-RETURN-CODE-LO.             
           IF WS-BUS-RULE-TYPE-ERR > SPACES                             
              MOVE WS-BUS-RULE-TYPE-ERR TO S-BUS-RULE-TYPE              
           ELSE                                                         
              MOVE 'NON001'             TO S-BUS-RULE-TYPE              
           END-IF.                                                      
           MOVE 'R'                     TO S-BUS-RULE-RESULT.           
      *                                                                         
           PERFORM 8100A-SEND-RESULT-MAIN  THRU  8100A-EXIT.            
           PERFORM 8100B-SEND-RESULT-HDR   THRU  8100B-EXIT.            
           PERFORM 8100C-SEND-RESULT-BG    THRU  8100C-EXIT.            
           PERFORM 8100D-SEND-RESULT-BC    THRU  8100D-EXIT.            
           PERFORM 8100E-SEND-RESULT-BA    THRU  8100E-EXIT.            
           PERFORM 8100F-SEND-RESULT-BX    THRU  8100F-EXIT.            
           PERFORM 8100G-SEND-RESULT-LO    THRU  8100G-EXIT.            
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT.             
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE      THRU  8900-EXIT.                 
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
