       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04509.                                         
       DATE-WRITTEN.  07/30/2011.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE ENTRY/RPM DASHBOARD AND     *        
      *  STATUS UPDATE SCREENS                                         *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUGETBUSPROCREQCNTRLBUSINESSOP                  *        
      *  INPUT     : APPL_PROG_ID      CHAR(3)                         *        
      *              USER_ID           CHAR(7)                         *        
      *  OUTPUT    : COMPANY_NO        CSS_PROCESS_CNTRL TABLE DEF     *        
      *              CODE_UTIL_TYPE    CSS_PROCESS_CNTRL TABLE DEF     *        
      *              PROC_TYPE_CD      CSS_PROCESS_CNTRL TABLE DEF     *        
      *              RETURN_CODE         INTEGER                       *        
      *              APPL_RETURN_CODE    INTEGER                       *        
      *              COMPANY_NO          CSS_PROCESS_CNTRL TABLE DEF   *        
      *              CODE_UTIL_TYPE      CSS_PROCESS_CNTRL TABLE DEF   *        
      *              PROC_TYPE_CD        CSS_PROCESS_CNTRL TABLE DEF   *        
      *              STATUS_SEQ_NO       CSS_PROCESS_CNTRL TABLE DEF   *        
      *              PROC_FLOW_IND       CSS_PROCESS_CNTRL TABLE DEF   *        
      *              PROC_STATUS_CD      CSS_PROCESS_CNTRL TABLE DEF   *        
      *              RQUIRED_STATUS_FL   CSS_PROCESS_CNTRL TABLE DEF   *        
      *              PROMOTE_BUTTON_TX   CSS_PROCESS_CNTRL TABLE DEF   *        
      *              DEMOTE_BUTTON_TX    CSS_PROCESS_CNTRL TABLE DEF   *        
      *              DEFAULT_COMMENTS    CSS_PROCESS_CNTRL TABLE DEF   *        
      *              CATEGORY_ID         CSS_PROCESS_CNTRL TABLE DEF   *        
      *              NOTIFY_TYPE_CD      CSS_PROCESS_CNTRL TABLE DEF   *        
      *              NOTIFY_LIST         CSS_PROCESS_CNTRL TABLE DEF   *        
      *              ESCLTN_DURATION_UM  CSS_PROCESS_CNTRL TABLE DEF   *        
      *              ESCLTN_DURATION     CSS_PROCESS_CNTRL TABLE DEF   *        
      *              STATUS_CD           CSS_PROCESS_CNTRL TABLE DEF   *        
      *              STATUS_CHANGE_DT    CSS_PROCESS_CNTRL TABLE DEF   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04509'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4509 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_CNTRL                                               
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_CATEGORY                                                    
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  HAS-ACCESS-FL           PIC X(01) VALUE 'N'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08)      VALUE 'CSR04509'. 
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE +0.     
           05  S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE +0.     
           05  S-COMPANY-NO               PIC X(02)  VALUE SPACES.      
           05  S-CODE-UTIL-TYPE           PIC X(02)  VALUE SPACES.      
           05  S-PROC-TYPE-CD             PIC X(06)  VALUE SPACES.      
           05  S-STATUS-SEQ-NO            PIC S9(09) COMP VALUE +0.     
           05  S-PROC-FLOW-IND            PIC X(01)  VALUE SPACES.      
           05  S-PROC-STATUS-CD           PIC X(02)  VALUE SPACES.      
           05  S-REQUIRED-STATUS-FL       PIC X(01)  VALUE SPACES.      
           05  S-PROMOTE-BUTTON-TX        PIC X(15)  VALUE SPACES.      
           05  S-DEMOTE-BUTTON-TX         PIC X(15)  VALUE SPACES.      
           05  S-DEFAULT-COMMENTS.                                      
              10  S-DEFAULT-LEN           PIC S9(4) COMP.               
              10  S-DEFAULT-COMMENTS-TEXT PIC X(255)   VALUE SPACES.    
           05  S-CATEGORY-ID              PIC S9(09) COMP VALUE +0.     
           05  S-NOTIFY-TYPE-CD           PIC X(01)  VALUE SPACES.      
           05  S-NOTIFY-LIST.                                           
              10  S-NOTIFY-LEN            PIC S9(4) COMP.               
              10  S-NOTIFY-LIST-TEXT      PIC X(255)  VALUE SPACES.     
           05  S-ESCLTN-DURATION-UM       PIC X(01)  VALUE SPACES.      
           05  S-ESCLTN-DURATION          PIC S9(4) USAGE COMP.         
           05  S-STATUS-CD                PIC X(01)  VALUE SPACES.      
           05  S-STATUS-CHANGE-DT         PIC X(10)  VALUE SPACES.      
           05  S-HAS-ACCESS-FL            PIC X(01)  VALUE SPACES.      
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE 6P-CURSOR CURSOR FOR                        
            SELECT COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,PROC_TYPE_CD                                         
                  ,STATUS_SEQ_NO                                        
                  ,PROC_FLOW_IND                                        
                  ,PROC_STATUS_CD                                       
                  ,REQUIRED_STATUS_FL                                   
                  ,PROMOTE_BUTTON_TX                                    
                  ,DEMOTE_BUTTON_TX                                     
                  ,COALESCE(DEFAULT_COMMENTS,' ')                         
                  ,CATEGORY_ID                                          
                  ,NOTIFY_TYPE_CD                                       
                  ,COALESCE(NOTIFY_LIST,' ')                              
                  ,ESCLTN_DURATION_UM                                   
                  ,ESCLTN_DURATION                                      
                  ,STATUS_CD                                            
                  ,STATUS_CHANGE_DT                                     
                FROM CSS_PROCESS_CNTRL WITH(READUNCOMMITTED)                    
                ORDER BY COMPANY_NO, CODE_UTIL_TYPE, PROC_TYPE_CD,      
                         STATUS_SEQ_NO, PROC_FLOW_IND                   
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE 6P-CURSOR CURSOR FOR                                
MFA-TR*     SELECT COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,PROC_TYPE_CD                                                 
MFA-TR*           ,STATUS_SEQ_NO                                                
MFA-TR*           ,PROC_FLOW_IND                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,REQUIRED_STATUS_FL                                           
MFA-TR*           ,PROMOTE_BUTTON_TX                                            
MFA-TR*           ,DEMOTE_BUTTON_TX                                             
MFA-TR*           ,IFNULL(DEFAULT_COMMENTS,' ')                                 
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,NOTIFY_TYPE_CD                                               
MFA-TR*           ,IFNULL(NOTIFY_LIST,' ')                                      
MFA-TR*           ,ESCLTN_DURATION_UM                                           
MFA-TR*           ,ESCLTN_DURATION                                              
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,STATUS_CHANGE_DT                                             
MFA-TR*         FROM CSS_PROCESS_CNTRL                                          
MFA-TR*         ORDER BY COMPANY_NO, CODE_UTIL_TYPE, PROC_TYPE_CD,              
MFA-TR*                  STATUS_SEQ_NO, PROC_FLOW_IND                           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-APPL-PROG-ID       PIC X(03).                           
       01  LINK-USER-ID            PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-APPL-PROG-ID                                       
              , LINK-USER-ID.                                           
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = 100.                        
           PERFORM 7200-CLOSE-PROCESS-CNTRL   THRU 7200-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,COMPANY_NO                                                
             ,CODE_UTIL_TYPE                                            
             ,PROC_TYPE_CD                                              
             ,STATUS_SEQ_NO                                             
             ,PROC_FLOW_IND                                             
             ,PROC_STATUS_CD                                            
             ,REQUIRED_STATUS_FL                                        
             ,PROMOTE_BUTTON_TX                                         
             ,DEMOTE_BUTTON_TX                                          
             ,DEFAULT_COMMENTS_TXT                                      
             ,CATEGORY_ID                                               
             ,NOTIFY_TYPE_CD                                            
             ,NOTIFY_LIST_TXT                                           
             ,ESCLTN_DURATION_UM                                        
             ,ESCLTN_DURATION                                           
             ,STATUS_CD                                                 
             ,STATUS_CHANGE_DT                                          
             ,HAS_ACCESS_FL                                             
                FROM #CSR04509_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,PROC_TYPE_CD                                                      
MFA-TR*      ,STATUS_SEQ_NO                                                     
MFA-TR*      ,PROC_FLOW_IND                                                     
MFA-TR*      ,PROC_STATUS_CD                                                    
MFA-TR*      ,REQUIRED_STATUS_FL                                                
MFA-TR*      ,PROMOTE_BUTTON_TX                                                 
MFA-TR*      ,DEMOTE_BUTTON_TX                                                  
MFA-TR*      ,DEFAULT_COMMENTS_TXT                                              
MFA-TR*      ,CATEGORY_ID                                                       
MFA-TR*      ,NOTIFY_TYPE_CD                                                    
MFA-TR*      ,NOTIFY_LIST_TXT                                                   
MFA-TR*      ,ESCLTN_DURATION_UM                                                
MFA-TR*      ,ESCLTN_DURATION                                                   
MFA-TR*      ,STATUS_CD                                                         
MFA-TR*      ,STATUS_CHANGE_DT                                                  
MFA-TR*      ,HAS_ACCESS_FL                                                     
MFA-TR*         FROM SESSION.CSR04509_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04509_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04509_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CODE_UTIL_TYPE CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_TYPE_CD CHAR(06)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,STATUS_SEQ_NO           INT                      
                  ,PROC_FLOW_IND CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,REQUIRED_STATUS_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROMOTE_BUTTON_TX CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,DEMOTE_BUTTON_TX CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,DEFAULT_COMMENTS_TXT CHAR(255)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CATEGORY_ID             INT                      
                  ,NOTIFY_TYPE_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,NOTIFY_LIST_TXT CHAR(255)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ESCLTN_DURATION_UM CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,ESCLTN_DURATION         SMALLINT                     
                  ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,HAS_ACCESS_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04509_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04509_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04509_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04509_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7000-OPEN-PROCESS-CNTRL THRU 7000-EXIT.              
           PERFORM 7100-FETCH-PROCESS-CNTRL THRU 7100-EXIT.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE 6P-STATUS-SEQ-NO          TO S-STATUS-SEQ-NO            
           MOVE 6P-COMPANY-NO             TO S-COMPANY-NO               
           MOVE 6P-CODE-UTIL-TYPE         TO S-CODE-UTIL-TYPE           
           MOVE 6P-PROC-TYPE-CD           TO S-PROC-TYPE-CD             
           MOVE 6P-PROC-FLOW-IND          TO S-PROC-FLOW-IND            
           MOVE 6P-PROC-STATUS-CD         TO S-PROC-STATUS-CD           
           MOVE 6P-REQUIRED-STATUS-FL     TO S-REQUIRED-STATUS-FL       
           MOVE 6P-PROMOTE-BUTTON-TX      TO S-PROMOTE-BUTTON-TX        
           MOVE 6P-DEMOTE-BUTTON-TX       TO S-DEMOTE-BUTTON-TX         
           MOVE 6P-DEFAULT-COMMENTS-LEN   TO SUB1                       
           MOVE SPACES                    TO S-DEFAULT-COMMENTS-TEXT    
           MOVE 6P-DEFAULT-COMMENTS-TEXT(1:SUB1) TO                     
                S-DEFAULT-COMMENTS-TEXT                                 
           MOVE 6P-CATEGORY-ID            TO S-CATEGORY-ID              
                                             F5-CATEGORY-ID             
           MOVE LINK-USER-ID              TO F5-USER-ID.                
           MOVE 'N'                       TO HAS-ACCESS-FL.             
                                                                        
           PERFORM 7300-CHECK-USER-ACCESS THRU 7300-EXIT.               
                                                                        
           MOVE HAS-ACCESS-FL             TO S-HAS-ACCESS-FL.           
                                                                        
           MOVE 6P-NOTIFY-TYPE-CD         TO S-NOTIFY-TYPE-CD           
           MOVE 6P-NOTIFY-LIST-LEN        TO SUB1                       
           MOVE SPACES                    TO S-NOTIFY-LIST-TEXT         
           MOVE 6P-NOTIFY-LIST-TEXT(1:SUB1) TO S-NOTIFY-LIST-TEXT       
           MOVE 6P-ESCLTN-DURATION-UM     TO S-ESCLTN-DURATION-UM       
           MOVE 6P-ESCLTN-DURATION        TO S-ESCLTN-DURATION          
           MOVE 6P-STATUS-CD              TO S-STATUS-CD                
           MOVE 6P-STATUS-CHANGE-DT       TO S-STATUS-CHANGE-DT         
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
           PERFORM 7100-FETCH-PROCESS-CNTRL THRU 7100-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7000-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7000-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN 6P-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS             
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              MOVE SQLCODE             TO S-APPL-RETURN-CODE            
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      *                                                                *        
      ******************************************************************        
       7100-FETCH-PROCESS-CNTRL.                                        
                                                                        
           MOVE '7110'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH 6P-CURSOR                                           
                INTO :6P-COMPANY-NO                                     
                    ,:6P-CODE-UTIL-TYPE                                 
                    ,:6P-PROC-TYPE-CD                                   
                    ,:6P-STATUS-SEQ-NO                                  
                    ,:6P-PROC-FLOW-IND                                  
                    ,:6P-PROC-STATUS-CD                                 
                    ,:6P-REQUIRED-STATUS-FL                             
                    ,:6P-PROMOTE-BUTTON-TX                              
                    ,:6P-DEMOTE-BUTTON-TX                               
                    ,:6P-DEFAULT-COMMENTS                               
                    ,:6P-CATEGORY-ID                                    
                    ,:6P-NOTIFY-TYPE-CD                                 
                    ,:6P-NOTIFY-LIST                                    
                    ,:6P-ESCLTN-DURATION-UM                             
                    ,:6P-ESCLTN-DURATION                                
                    ,:6P-STATUS-CD                                      
                    ,:6P-STATUS-CHANGE-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0 TO S-RETURN-CODE                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 100 TO S-RETURN-CODE                              
                 IF CTR-ROWS = 0                                        
                    INITIALIZE                    GTT-RETURN-FIELDS     
                    MOVE 100                   TO S-RETURN-CODE         
                    MOVE SQLCODE               TO S-APPL-RETURN-CODE    
                    MOVE 6P-COMPANY-NO         TO S-COMPANY-NO          
                    MOVE 6P-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE      
                    MOVE 6P-PROC-TYPE-CD       TO S-PROC-TYPE-CD        
                    PERFORM 8100-SEND-RESULT   THRU 8100-EXIT           
                    MOVE 100                   TO WS-ACTIVE-RETURN-CODE 
                 END-IF                                                 
              ELSE                                                      
                 INITIALIZE                      GTT-RETURN-FIELDS      
                 MOVE 100                     TO S-RETURN-CODE          
                 ADD 1                        TO CTR-ROWS               
                 MOVE SQLCODE                 TO S-APPL-RETURN-CODE     
                 PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7100'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_PROCESS_CNTRL'     TO TABLE-1                
                 MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2        
                 MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1      
                 MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7200-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE 6P-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS             
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              MOVE SQLCODE             TO S-APPL-RETURN-CODE            
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-CHECK-USER-ACCESS                                     *            
      ****************************************************************          
                                                                        
       7300-CHECK-USER-ACCESS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :HAS-ACCESS-FL                                       
              FROM CSS_CATEGORY F5                                      
              WHERE F5.USER_ID = :F5-USER-ID                            
              AND F5.CATEGORY_ID = :F5-CATEGORY-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              INITIALIZE                  GTT-RETURN-FIELDS             
              MOVE 100                 TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              MOVE SQLCODE             TO S-APPL-RETURN-CODE            
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CATEGORY '     TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE F5-USER-ID          TO HOSTVAR-ELEMENT-1             
              MOVE 'CATEGORY_ID'       TO TABLE-ELEMENT-2               
              MOVE F5-CATEGORY-ID      TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04509_R1                       
                  (    RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,COMPANY_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,PROC_TYPE_CD                                     
                      ,STATUS_SEQ_NO                                    
                      ,PROC_FLOW_IND                                    
                      ,PROC_STATUS_CD                                   
                      ,REQUIRED_STATUS_FL                               
                      ,PROMOTE_BUTTON_TX                                
                      ,DEMOTE_BUTTON_TX                                 
                      ,DEFAULT_COMMENTS_TXT                             
                      ,CATEGORY_ID                                      
                      ,NOTIFY_TYPE_CD                                   
                      ,NOTIFY_LIST_TXT                                  
                      ,ESCLTN_DURATION_UM                               
                      ,ESCLTN_DURATION                                  
                      ,STATUS_CD                                        
                      ,STATUS_CHANGE_DT                                 
                      ,HAS_ACCESS_FL                                    
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-COMPANY-NO                                       
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-PROC-TYPE-CD                                     
                   ,:S-STATUS-SEQ-NO                                    
                   ,:S-PROC-FLOW-IND                                    
                   ,:S-PROC-STATUS-CD                                   
                   ,:S-REQUIRED-STATUS-FL                               
                   ,:S-PROMOTE-BUTTON-TX                                
                   ,:S-DEMOTE-BUTTON-TX                                 
                   ,:S-DEFAULT-COMMENTS-TEXT                            
                   ,:S-CATEGORY-ID                                      
                   ,:S-NOTIFY-TYPE-CD                                   
                   ,:S-NOTIFY-LIST-TEXT                                 
                   ,:S-ESCLTN-DURATION-UM                               
                   ,:S-ESCLTN-DURATION                                  
                   ,:S-STATUS-CD                                        
                   ,:S-STATUS-CHANGE-DT                                 
                   ,:S-HAS-ACCESS-FL                                    
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04509_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,PROC_TYPE_CD                                             
MFA-TR*               ,STATUS_SEQ_NO                                            
MFA-TR*               ,PROC_FLOW_IND                                            
MFA-TR*               ,PROC_STATUS_CD                                           
MFA-TR*               ,REQUIRED_STATUS_FL                                       
MFA-TR*               ,PROMOTE_BUTTON_TX                                        
MFA-TR*               ,DEMOTE_BUTTON_TX                                         
MFA-TR*               ,DEFAULT_COMMENTS_TXT                                     
MFA-TR*               ,CATEGORY_ID                                              
MFA-TR*               ,NOTIFY_TYPE_CD                                           
MFA-TR*               ,NOTIFY_LIST_TXT                                          
MFA-TR*               ,ESCLTN_DURATION_UM                                       
MFA-TR*               ,ESCLTN_DURATION                                          
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,STATUS_CHANGE_DT                                         
MFA-TR*               ,HAS_ACCESS_FL                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-PROC-TYPE-CD                                             
MFA-TR*            ,:S-STATUS-SEQ-NO                                            
MFA-TR*            ,:S-PROC-FLOW-IND                                            
MFA-TR*            ,:S-PROC-STATUS-CD                                           
MFA-TR*            ,:S-REQUIRED-STATUS-FL                                       
MFA-TR*            ,:S-PROMOTE-BUTTON-TX                                        
MFA-TR*            ,:S-DEMOTE-BUTTON-TX                                         
MFA-TR*            ,:S-DEFAULT-COMMENTS-TEXT                                    
MFA-TR*            ,:S-CATEGORY-ID                                              
MFA-TR*            ,:S-NOTIFY-TYPE-CD                                           
MFA-TR*            ,:S-NOTIFY-LIST-TEXT                                         
MFA-TR*            ,:S-ESCLTN-DURATION-UM                                       
MFA-TR*            ,:S-ESCLTN-DURATION                                          
MFA-TR*            ,:S-STATUS-CD                                                
MFA-TR*            ,:S-STATUS-CHANGE-DT                                         
MFA-TR*            ,:S-HAS-ACCESS-FL                                            
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              ADD 1 TO CTR-ROWS                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-APPL-RETURN-CODE           
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04509_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
