       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04508.                                         
       DATE-WRITTEN.  07/30/2011.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE ENTRY/RPM DASHBOARD AND     *        
      *  STATUS UPDATE SCREENS                                         *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUGETBUSPROCREQCHGHISTBUSINESS                  *        
      *  INPUT     : APPL_PROG_ID      CHAR(3)                         *        
      *              USER_ID           CHAR(7)                         *        
      *              PROC_REQ_ID       CSS_PROCESS_REQ_CH TABLE DEF    *        
      *  OUTPUT    : RETURN_CODE       INTEGER                         *        
      *              APPL_RETURN_CODE  INTEGER                         *        
      *              PROC_FLOW_IND     CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              PROC_STATUS_CD    CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_TS        CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_USERID    CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              REQ_CHG_COMMENTS  CSS_PROCESS_REQ_CH TABLE DEF    *        
      *              CATEGORY_ID       CSS_PROCESS_REQ_CH TABLE DEF    *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  +400    ADDRESS WAS FOUND BY FINALIST AND IT MATCHED EXACTLY  *        
      *          WITH THE ENTERED ADDRESS                              *        
      *  +300    ADDRESS WAS NOT FOUND BY FINALIST                     *        
      *  +200    ADDRESS WAS FOUND BY FINALIST BUT IT DID NOT EXACTLY  *        
      *          MATCH THE ENTERED ADDRESS                             *        
      *  ANY -   ERROR                                                 *        
      *   0      FINALIST WAS NOT CALLED                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04508'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC 4508 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_REQ_CH                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCCHG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04508'.      
           05  WS-PROC-REQ-ID          PIC X(10).                       
           05  WS-PROC-REQ-NO REDEFINES WS-PROC-REQ-ID PIC 9(10).       
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE +0.     
           05  S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE +0.     
           05  S-PROC-REQ-ID              PIC S9(10)V COMP-3 VALUE +0.  
           05  S-REQ-CHG-TS               PIC X(26).                    
           05  S-PROC-FLOW-IND            PIC X(1).                     
           05  S-PROC-STATUS-CD           PIC X(2).                     
           05  S-REQ-CHG-USERID           PIC X(7).                     
           05  S-REQ-CHG-COMMENTS-TEXT    PIC X(255)  VALUE SPACES.     
           05  S-CATEGORY-ID              PIC S9(09) COMP VALUE +0.     
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE 4P-CURSOR CURSOR FOR                        
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), REQ_CHG_TS
           , 121), ' ', '-'), ':', '.') REQ_CHG_TS                             
                    ,PROC_FLOW_IND                                      
                    ,PROC_STATUS_CD                                     
                    ,REQ_CHG_USERID                                     
                    ,COALESCE(REQ_CHG_COMMENTS,' ')                       
                    ,CATEGORY_ID                                        
                FROM CSS_PROCESS_REQ_CH WITH(READUNCOMMITTED)                   
               WHERE PROC_REQ_ID = :4P-PROC-REQ-ID                      
                 ORDER BY REQ_CHG_TS  DESC                              
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE 4P-CURSOR CURSOR FOR                                
MFA-TR*       SELECT REQ_CHG_TS                                                 
MFA-TR*             ,PROC_FLOW_IND                                              
MFA-TR*             ,PROC_STATUS_CD                                             
MFA-TR*             ,REQ_CHG_USERID                                             
MFA-TR*             ,IFNULL(REQ_CHG_COMMENTS,' ')                               
MFA-TR*             ,CATEGORY_ID                                                
MFA-TR*         FROM CSS_PROCESS_REQ_CH                                         
MFA-TR*        WHERE PROC_REQ_ID = :4P-PROC-REQ-ID                              
MFA-TR*          ORDER BY REQ_CHG_TS  DESC                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID PIC X(03)                .                 
       01  PARM-USER-ID      PIC X(07)                .                 
       01  PARM-PROC-REQ-ID  PIC X(10)                .                 
      *01  PARM-PROC-REQ-ID  PIC 9(10)V COMP-3       .                          
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-APPL-PROG-ID                                       
              , PARM-USER-ID                                            
              , PARM-PROC-REQ-ID.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE = 100.                        
           PERFORM 7200-CLOSE-PROCESS-CNTRL THRU 7200-EXIT.             
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,PROC_FLOW_IND                                             
             ,PROC_STATUS_CD                                            
             ,REQ_CHG_TS                                                
             ,REQ_CHG_USERID                                            
             ,REQ_CHG_COMMENTS_TXT                                      
             ,CATEGORY_ID                                               
                FROM #CSR04508_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,PROC_FLOW_IND                                                     
MFA-TR*      ,PROC_STATUS_CD                                                    
MFA-TR*      ,REQ_CHG_TS                                                        
MFA-TR*      ,REQ_CHG_USERID                                                    
MFA-TR*      ,REQ_CHG_COMMENTS_TXT                                              
MFA-TR*      ,CATEGORY_ID                                                       
MFA-TR*         FROM SESSION.CSR04508_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE PARM-PROC-REQ-ID    TO WS-PROC-REQ-ID                   
           IF WS-PROC-REQ-ID NOT NUMERIC                                
              MOVE ZEROS TO WS-PROC-REQ-NO                              
           END-IF                                                       
           MOVE WS-PROC-REQ-NO      TO 4P-PROC-REQ-ID.                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE '0100A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04508_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04508_R1
              (                                                        
                   RETURN_CODE           INT                        
                  ,APPL_RETURN_CODE      INT                        
                  ,PROC_REQ_ID           DECIMAL(10,0)                  
                  ,REQ_CHG_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,PROC_FLOW_IND CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,REQ_CHG_USERID CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,REQ_CHG_COMMENTS_TXT CHAR(255)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                      
                  ,CATEGORY_ID           INT                        
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04508_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE '8000A'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04508_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04508_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04508_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7000-OPEN-PROCESS-CNTRL THRU 7000-EXIT.              
           PERFORM 7100-FETCH-PROCESS-CNTRL THRU 7100-EXIT.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE 4P-PROC-REQ-ID            TO S-PROC-REQ-ID              
           MOVE 4P-REQ-CHG-TS             TO S-REQ-CHG-TS               
           MOVE 4P-PROC-FLOW-IND          TO S-PROC-FLOW-IND            
           MOVE 4P-PROC-STATUS-CD         TO S-PROC-STATUS-CD           
           MOVE 4P-REQ-CHG-USERID         TO S-REQ-CHG-USERID           
           MOVE 4P-REQ-CHG-COMMENTS-LEN   TO SUB1                       
           MOVE SPACES                    TO S-REQ-CHG-COMMENTS-TEXT    
           MOVE 4P-REQ-CHG-COMMENTS-TEXT(1:SUB1) TO                     
                S-REQ-CHG-COMMENTS-TEXT                                 
           MOVE 4P-CATEGORY-ID            TO S-CATEGORY-ID              
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
           PERFORM 7100-FETCH-PROCESS-CNTRL THRU 7100-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7000-OPEN-PROCESS-CNTRL.                                         
                                                                        
           MOVE '7000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              OPEN 4P-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO S-APPL-RETURN-CODE            
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ_CH' TO TABLE-1                      
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE PARM-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_REQ_CH                       *        
      *                                                                *        
      ******************************************************************        
       7100-FETCH-PROCESS-CNTRL.                                        
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH 4P-CURSOR                                           
                INTO :4P-REQ-CHG-TS                                     
                    ,:4P-PROC-FLOW-IND                                  
                    ,:4P-PROC-STATUS-CD                                 
                    ,:4P-REQ-CHG-USERID                                 
                    ,:4P-REQ-CHG-COMMENTS                               
                    ,:4P-CATEGORY-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0 TO S-RETURN-CODE                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 100 TO S-RETURN-CODE                              
                 IF CTR-ROWS = 0                                        
                    INITIALIZE                      GTT-RETURN-FIELDS   
                    MOVE 100                     TO S-RETURN-CODE       
                    MOVE 4P-PROC-REQ-ID          TO S-PROC-REQ-ID       
                    MOVE SQLCODE                 TO S-APPL-RETURN-CODE  
                    PERFORM 8100-SEND-RESULT     THRU 8100-EXIT         
                    MOVE 100 TO WS-ACTIVE-RETURN-CODE                   
                 END-IF                                                 
              ELSE                                                      
                 MOVE 100 TO S-RETURN-CODE                              
                 MOVE WS-ACTIVE-RETURN-CODE   TO S-APPL-RETURN-CODE     
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_PROCESS_REQ_CH'    TO TABLE-1                
                 MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1        
                 MOVE PARM-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7200-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE 4P-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE SQLCODE             TO S-APPL-RETURN-CODE            
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ_CH' TO TABLE-1                      
              MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1               
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04508_R1                       
                  (    RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,PROC_REQ_ID                                      
                      ,REQ_CHG_TS                                       
                      ,PROC_FLOW_IND                                    
                      ,PROC_STATUS_CD                                   
                      ,REQ_CHG_USERID                                   
                      ,REQ_CHG_COMMENTS_TXT                             
                      ,CATEGORY_ID                                      
                  )                                                     
               VALUES                                                   
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-PROC-REQ-ID                                      
                   ,:S-REQ-CHG-TS                                       
                   ,:S-PROC-FLOW-IND                                    
                   ,:S-PROC-STATUS-CD                                   
                   ,:S-REQ-CHG-USERID                                   
                   ,:S-REQ-CHG-COMMENTS-TEXT                            
                   ,:S-CATEGORY-ID                                      
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04508_R1                               
MFA-TR*           (    RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,PROC_REQ_ID                                              
MFA-TR*               ,REQ_CHG_TS                                               
MFA-TR*               ,PROC_FLOW_IND                                            
MFA-TR*               ,PROC_STATUS_CD                                           
MFA-TR*               ,REQ_CHG_USERID                                           
MFA-TR*               ,REQ_CHG_COMMENTS_TXT                                     
MFA-TR*               ,CATEGORY_ID                                              
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-PROC-REQ-ID                                              
MFA-TR*            ,:S-REQ-CHG-TS                                               
MFA-TR*            ,:S-PROC-FLOW-IND                                            
MFA-TR*            ,:S-PROC-STATUS-CD                                           
MFA-TR*            ,:S-REQ-CHG-USERID                                           
MFA-TR*            ,:S-REQ-CHG-COMMENTS-TEXT                                    
MFA-TR*            ,:S-CATEGORY-ID                                              
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 100                  TO S-RETURN-CODE                
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           S-APPL-RETURN-CODE           
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04508_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
