       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04507.                                       
       AUTHOR.       MS93554.                                           
COB303 DATE-WRITTEN. 01 NOV 2011.                                        
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04507              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04507 :                                                --         
      *--                                                            --         
      *--  #  WIZARDS IN NEW RATE MANAGEMENT MODULE.                 --         
      *--  #  RETRIEVE RATE PLANS FOR APPLYING TO FACTORS.           --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_APPL_PGM_ID     CHAR(08)                      --         
      *--            I_USER_ID         CHAR(07)                      --         
      *--            I_FACTOR_ID       CHAR(09)                      --         
      *--            I_BLOCK_NO        CHAR(08)                      --         
      *--            I_CMPNT_ID_CD     CHAR(02)                      --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--            RETURN_CODE           INTEGER                   --         
      *--            APPL_RETURN_CODE      INTEGER                   --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            RATE_DEPT_CD          CHAR(03)                  --         
      *--            RATE_PLAN_NO          CHAR(03)                  --         
      *--            RATE_DESC             CHAR(50)                  --         
      *--            FACTOR_EXISTS_FL      CHAR(01)                  --         
      *--            PENDING_EXISTS_FL     CHAR(01)                  --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  11/01/2011    MS93554     RETRIEVE RATE PLANS DESC FOR    --         
      *--                            APPLYING TO FACTORS.            --         
P00473*--  06/29/2012    AW41078     ADDING BLOCK_NO AND CMPNT_ID_CD --         
P00473*--                            AS PARAMETERS                   --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04507'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC RD                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL SA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE              PIC X(05) VALUE SPACES.          
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW              PIC X(01) VALUE 'N'.             
              88 NOT-ALL-DONE                    VALUE 'N'.             
              88 ALL-DONE                        VALUE 'Y'.             
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
           05 WS-NO-MORE-ROWS          PIC X(01) VALUE 'N'.             
              88 NO-MORE-ROWS                    VALUE 'Y'.             
           05 WS-FACTOR-ID             PIC X(01) VALUE 'N'.             
              88 FACTOR-ID-PASSED                VALUE 'Y'.             
           05 WS-BLOCK-NO-SW           PIC X(01) VALUE 'N'.             
              88 BLOCK-NO-PASSED                 VALUE 'Y'.             
              88 BLOCK-NO-NOT-PASSED             VALUE 'N'.             
           05 WS-CMPNT-ID-CD-SW        PIC X(01) VALUE 'N'.             
              88 CMPNT-ID-CD-PASSED              VALUE 'Y'.             
              88 CMPNT-ID-CD-NOT-PASSED          VALUE 'N'.             
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04507'.      
           05 WS-ACTIVE                PIC X(01) VALUE 'A'.             
           05 WS-TEST                  PIC X(01) VALUE 'T'.             
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 GTT-NAME                 PIC X(26)                        
                                            VALUE 'SESSION.CSR04507_R1'.
                                                                        
       01  WS-MISC.                                                     
           05 WS-APPL-PGM-ID           PIC X(03).                       
           05 WS-CURRENT-DATE          PIC X(10).                       
           05 WS-FACTOR-EXISTS-FL      PIC X(01) VALUE 'N'.             
           05 WS-PENDING-EXISTS-FL     PIC X(01) VALUE 'N'.             
           05 WS-RT-PLAN-AND-RT-DESC   PIC X(60) VALUE SPACES.          
           05 WS-BLOCK-NO              PIC S9(04) COMP VALUE 0.         
           05 WS-CMPNT-ID-CD           PIC X(02) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
            05  GTT-SQLCODE            PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05 RS-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.         
           05 RS-COMPANY-NO            PIC X(02)  VALUE SPACES.         
           05 RS-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.         
           05 RS-RATE-DEPT-CD          PIC X(03)  VALUE SPACES.         
           05 RS-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.         
           05 RS-RATE-DESC             PIC X(50)  VALUE SPACES.         
           05 RS-FACTOR-EXISTS-FL      PIC X(01)  VALUE SPACES.         
           05 RS-PENDING-EXISTS-FL     PIC X(01)  VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.         
           05  S-COMPANY-NO            PIC X(02)  VALUE SPACES.         
           05  S-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.         
           05  S-RATE-DEPT-CD          PIC X(03)  VALUE SPACES.         
           05  S-RATE-PLAN-NO          PIC X(03)  VALUE SPACES.         
           05  S-RATE-DESC             PIC X(50)  VALUE SPACES.         
           05  S-FACTOR-EXISTS-FL      PIC X(01)  VALUE SPACES.         
           05  S-PENDING-EXISTS-FL     PIC X(01)  VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH ALL THE RATE PLAN DESC DETAILS  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RT_PLAN_DESC_CUR CURSOR FOR                      
                SELECT RD.COMPANY_NO                                    
                      ,RD.CODE_UTIL_TYPE                                
                      ,RD.RATE_DEPT_CD                                  
                      ,RD.RATE_PLAN_NO                                  
                      ,RTRIM(RD.RATE_DESC) AS RATE_DESC                 
                      ,RTRIM(RD.RATE_PLAN_NO) + ' - ' + RTRIM(
           RD.RATE_DESC) AS RATE_PLAN_DESC   
                  FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                 ORDER BY RD.RATE_PLAN_NO                               
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RT_PLAN_DESC_CUR CURSOR FOR                              
MFA-TR*         SELECT RD.COMPANY_NO                                            
MFA-TR*               ,RD.CODE_UTIL_TYPE                                        
MFA-TR*               ,RD.RATE_DEPT_CD                                          
MFA-TR*               ,RD.RATE_PLAN_NO                                          
MFA-TR*               ,RTRIM(RD.RATE_DESC) AS RATE_DESC                         
MFA-TR*               ,RTRIM(RD.RATE_PLAN_NO) || ' - ' ||                       
MFA-TR*                         RTRIM(RD.RATE_DESC) AS RATE_PLAN_DESC           
MFA-TR*           FROM CSS_RATE_PLAN_DESC RD                                    
MFA-TR*          ORDER BY RD.RATE_PLAN_NO                                       
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID            PIC X(03).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-FACTOR-ID              PIC X(09).                       
       01  PARM-BLOCK-NO               PIC X(08).                       
       01  PARM-CMPNT-ID-CD            PIC X(02).                       
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-USER-ID                           
                                 PARM-FACTOR-ID                         
                                 PARM-BLOCK-NO                          
                                 PARM-CMPNT-ID-CD.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04507_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04507_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DEPT_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR_EXISTS_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PENDING_EXISTS_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,COMPANY_NO                                       
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE)) AS CODE_UTIL_TYPE          
                      ,RATE_DEPT_CD                                     
                      ,LTRIM(RTRIM(RATE_PLAN_NO))   AS RATE_PLAN_NO            
                      ,LTRIM(RTRIM(RATE_DESC))      AS RATE_DESC               
                      ,FACTOR_EXISTS_FL                                 
                      ,PENDING_EXISTS_FL                                
                  FROM #CSR04507_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,STRIP(CODE_UTIL_TYPE) AS CODE_UTIL_TYPE                  
MFA-TR*               ,RATE_DEPT_CD                                             
MFA-TR*               ,STRIP(RATE_PLAN_NO)   AS RATE_PLAN_NO                    
MFA-TR*               ,STRIP(RATE_DESC)      AS RATE_DESC                       
MFA-TR*               ,FACTOR_EXISTS_FL                                         
MFA-TR*               ,PENDING_EXISTS_FL                                        
MFA-TR*           FROM SESSION.CSR04507_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PGM-ID          TO WS-APPL-PGM-ID             
           MOVE PARM-FACTOR-ID            TO SA-FACTOR-ID               
                                                                        
           IF SA-FACTOR-ID > SPACES                                     
              SET FACTOR-ID-PASSED    TO TRUE                           
           END-IF.                                                      
                                                                        
           IF PARM-BLOCK-NO IS NUMERIC                                  
              MOVE PARM-BLOCK-NO         TO WS-BLOCK-NO                 
              SET BLOCK-NO-PASSED        TO TRUE                        
           ELSE                                                         
              SET BLOCK-NO-NOT-PASSED    TO TRUE                        
           END-IF.                                                      
                                                                        
           IF PARM-CMPNT-ID-CD > SPACES                                 
              MOVE PARM-CMPNT-ID-CD      TO WS-CMPNT-ID-CD              
              SET CMPNT-ID-CD-PASSED     TO TRUE                        
           ELSE                                                         
              SET CMPNT-ID-CD-NOT-PASSED TO TRUE                        
           END-IF.                                                      
                                                                        
           PERFORM 7005-ACCEPT-CURRENT-DATE  THRU 7005-EXIT.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-NO         TO WS-NO-MORE-ROWS                        
           PERFORM 7050-OPEN-RT-PLAN-DESC-CUR    THRU 7050-EXIT         
           PERFORM 7060-FETCH-RT-PLAN-DESC-CUR   THRU 7060-EXIT         
           PERFORM 2100-PROCESS-FACTOR           THRU 2100-EXIT         
                                                 UNTIL NO-MORE-ROWS     
           PERFORM 7070-CLOSE-RT-PLAN-DESC-CUR   THRU 7070-EXIT.        
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                        TO S-RETURN-CODE          
              MOVE   0                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
           MOVE RS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE.      
           MOVE RS-COMPANY-NO               TO S-COMPANY-NO.            
           MOVE RS-CODE-UTIL-TYPE           TO S-CODE-UTIL-TYPE.        
           MOVE RS-RATE-DEPT-CD             TO S-RATE-DEPT-CD.          
           MOVE RS-RATE-PLAN-NO             TO S-RATE-PLAN-NO.          
           MOVE RS-RATE-DESC                TO S-RATE-DESC.             
           MOVE RS-FACTOR-EXISTS-FL         TO S-FACTOR-EXISTS-FL.      
           MOVE RS-PENDING-EXISTS-FL        TO S-PENDING-EXISTS-FL.     
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100-PROCESS-FACTOR.                                          *         
      *****************************************************************         
       2100-PROCESS-FACTOR.                                             
                                                                        
           IF FACTOR-ID-PASSED                                          
              INITIALIZE                       SA-CODE-STATUS           
                                              ,SA-DATE-TO               
                                              ,SA-BLOCK-NO              
                                              ,SA-CMPNT-ID-CD           
                                              ,WS-FACTOR-EXISTS-FL      
                                              ,WS-PENDING-EXISTS-FL     
                                                                        
              MOVE RD-CODE-UTIL-TYPE        TO SA-CODE-UTIL-TYPE        
              MOVE RD-RATE-PLAN-NO          TO SA-RATE-PLAN-NO          
              PERFORM 7000-CHK-SPCL-FCTR-APPL  THRU 7000-EXIT           
                                                                        
              IF (BLOCK-NO-NOT-PASSED OR                                
                 (BLOCK-NO-PASSED AND SA-BLOCK-NO EQUAL WS-BLOCK-NO))   
                 AND                                                    
                 (CMPNT-ID-CD-NOT-PASSED OR                             
                 (CMPNT-ID-CD-PASSED AND                                
                  SA-CMPNT-ID-CD EQUAL WS-CMPNT-ID-CD))                 
                                                                        
                 IF SA-CODE-STATUS EQUAL WS-ACTIVE AND                  
                    SA-DATE-TO > WS-CURRENT-DATE                        
                    MOVE WS-YES    TO WS-FACTOR-EXISTS-FL               
                 ELSE                                                   
                    MOVE WS-NO     TO WS-FACTOR-EXISTS-FL               
                 END-IF                                                 
                                                                        
                 IF SA-CODE-STATUS EQUAL WS-TEST                        
                    MOVE WS-YES    TO WS-PENDING-EXISTS-FL              
                 ELSE                                                   
                    MOVE WS-NO     TO WS-PENDING-EXISTS-FL              
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-NO        TO WS-FACTOR-EXISTS-FL               
                 MOVE WS-NO        TO WS-PENDING-EXISTS-FL              
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO        TO WS-FACTOR-EXISTS-FL                  
              MOVE WS-NO        TO WS-PENDING-EXISTS-FL                 
           END-IF.                                                      
                                                                        
           PERFORM 2200-MOVE-RATE-DESC-DET     THRU 2200-EXIT           
           PERFORM 7060-FETCH-RT-PLAN-DESC-CUR THRU 7060-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2200-MOVE-RATE-DESC-DET.                                      *         
      *****************************************************************         
       2200-MOVE-RATE-DESC-DET.                                         
                                                                        
           MOVE RD-COMPANY-NO               TO RS-COMPANY-NO            
           MOVE RD-CODE-UTIL-TYPE           TO RS-CODE-UTIL-TYPE        
           MOVE RD-RATE-DEPT-CD             TO RS-RATE-DEPT-CD          
           MOVE RD-RATE-PLAN-NO             TO RS-RATE-PLAN-NO          
           MOVE RD-RATE-DESC                TO RS-RATE-DESC             
           MOVE WS-FACTOR-EXISTS-FL         TO RS-FACTOR-EXISTS-FL      
           MOVE WS-PENDING-EXISTS-FL        TO RS-PENDING-EXISTS-FL.    
                                                                        
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-CHK-SPCL-FCTR-APPL                                       *         
      *****************************************************************         
       7000-CHK-SPCL-FCTR-APPL.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SA.CODE_STATUS,
              SA.DATE_TO,
              SA.BLOCK_NO,
              SA.CMPNT_ID_CD                                    
                 INTO :SA-CODE-STATUS                                   
                     ,:SA-DATE-TO                                       
                     ,:SA-BLOCK-NO                                      
                     ,:SA-CMPNT-ID-CD                                   
                 FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
                WHERE SA.FACTOR_ID      = :SA-FACTOR-ID                 
                  AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO              
                  AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE            
                  AND SA.CODE_STATUS IN ('A','T')                       
                ORDER BY SA.DATE_TO DESC                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SA.CODE_STATUS                                            
MFA-TR*              ,SA.DATE_TO                                                
MFA-TR*              ,SA.BLOCK_NO                                               
MFA-TR*              ,SA.CMPNT_ID_CD                                            
MFA-TR*          INTO :SA-CODE-STATUS                                           
MFA-TR*              ,:SA-DATE-TO                                               
MFA-TR*              ,:SA-BLOCK-NO                                              
MFA-TR*              ,:SA-CMPNT-ID-CD                                           
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*         WHERE SA.FACTOR_ID      = :SA-FACTOR-ID                         
MFA-TR*           AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                      
MFA-TR*           AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                    
MFA-TR*           AND SA.CODE_STATUS IN ('A','T')                               
MFA-TR*         ORDER BY SA.DATE_TO DESC                                        
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL  OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SPCL_FCTR_APPL'  TO TABLE-1                     
              MOVE 'FACTOR_ID'           TO TABLE-ELEMENT-1             
              MOVE SA-FACTOR-ID          TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7005-ACCEPT-CURRENT-DATE.                                      *        
      ******************************************************************        
       7005-ACCEPT-CURRENT-DATE.                                        
                                                                        
           MOVE '7005'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7050-OPEN-RT-PLAN-DESC-CUR.                                   *        
      ******************************************************************        
       7050-OPEN-RT-PLAN-DESC-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN RT_PLAN_DESC_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-FETCH-RT-PLAN-DESC-CUR.                                   *        
      ******************************************************************        
       7060-FETCH-RT-PLAN-DESC-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH RT_PLAN_DESC_CUR                                   
                INTO :RD-COMPANY-NO                                     
                    ,:RD-CODE-UTIL-TYPE                                 
                    ,:RD-RATE-DEPT-CD                                   
                    ,:RD-RATE-PLAN-NO                                   
                    ,:RD-RATE-DESC                                      
                    ,:WS-RT-PLAN-AND-RT-DESC                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-ROWS          
               WHEN OTHER                                               
                    MOVE WS-ACTIVE-RETURN-CODE                          
                                            TO RS-RETURN-CODE           
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7060'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-CLOSE-RT-PLAN-DESC-CUR.                                   *        
      ******************************************************************        
       7070-CLOSE-RT-PLAN-DESC-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE RT_PLAN_DESC_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04507_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04507_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04507_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04507_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,RATE_DEPT_CD                                         
                  ,RATE_PLAN_NO                                         
                  ,RATE_DESC                                            
                  ,FACTOR_EXISTS_FL                                     
                  ,PENDING_EXISTS_FL                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-COMPANY-NO                                        
                  ,:S-CODE-UTIL-TYPE                                    
                  ,:S-RATE-DEPT-CD                                      
                  ,:S-RATE-PLAN-NO                                      
                  ,:S-RATE-DESC                                         
                  ,:S-FACTOR-EXISTS-FL                                  
                  ,:S-PENDING-EXISTS-FL                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04507_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,RATE_DEPT_CD                                                 
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,RATE_DESC                                                    
MFA-TR*           ,FACTOR_EXISTS_FL                                             
MFA-TR*           ,PENDING_EXISTS_FL                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-COMPANY-NO                                                
MFA-TR*           ,:S-CODE-UTIL-TYPE                                            
MFA-TR*           ,:S-RATE-DEPT-CD                                              
MFA-TR*           ,:S-RATE-PLAN-NO                                              
MFA-TR*           ,:S-RATE-DESC                                                 
MFA-TR*           ,:S-FACTOR-EXISTS-FL                                          
MFA-TR*           ,:S-PENDING-EXISTS-FL                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04507_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
        9700-PROCESS-ABEND.                                             
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.            
                                                                        
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.            
                                                                        
        9700-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
